%------------------------------------------------------------------------------
% File     : LCL748_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 31
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_31 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.4.0, 0.25 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  152 (  64 unt;  39 typ;   0 def)
%            Number of atoms       :  189 ( 127 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  101 (  25   ~;   2   |;   8   &)
%                                         (  19 <=>;  47  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   4 avg)
%            Maximal term depth    :    8 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   37 (  18   >;  19   *;   0   +;   0  <<)
%            Number of predicates  :   15 (  14 usr;   0 prp; 1-2 aty)
%            Number of functors    :   22 (  22 usr;   5 con; 0-5 aty)
%            Number of variables   :  289 ( 269   !;   0   ?; 289   :)
%                                         (  20  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:15:06
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (34)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,type,
    semiri456707255roduct: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: dB > $o ).

tff(sy_c_Lambda_Obeta,type,
    beta: ( dB * dB ) > $o ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__case,type,
    dB_case: 
      !>[T2: $tType] : ( ( fun(nat,T2) * fun(dB,fun(dB,T2)) * fun(dB,T2) * dB ) > T2 ) ).

tff(sy_c_Lambda_OdB_OdB__rec,type,
    dB_rec: 
      !>[T2: $tType] : ( ( fun(nat,T2) * fun(dB,fun(dB,fun(T2,fun(T2,T2)))) * fun(dB,fun(T2,T2)) * dB ) > T2 ) ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: ( dB * nat ) > dB ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: ( dB * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_ia,type,
    ia: nat ).

tff(sy_v_r,type,
    r: dB ).

%----Relevant facts (98)
tff(fact_0_Lambda,axiom,
    ! [R1: dB] :
      ( it(R1)
     => it(abs(R1)) ) ).

tff(fact_1_dB_Osimps_I3_J,axiom,
    ! [DB5: dB,DB4: dB] :
      ( ( abs(DB4) = abs(DB5) )
    <=> ( DB4 = DB5 ) ) ).

tff(fact_2_dB_Osimps_I12_J,axiom,
    ! [A: $tType,DB4: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,abs(DB4)) = aa(dB,A,F3,DB4) ) ).

tff(fact_3_dB_Orecs_I3_J,axiom,
    ! [A: $tType,DB4: dB,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,abs(DB4)) = aa(A,A,aa(dB,fun(A,A),F3,DB4),dB_rec(A,F1,F2,F3,DB4)) ) ).

tff(fact_4_lift_Osimps_I3_J,axiom,
    ! [K: nat,S1: dB] : ( lift(abs(S1),K) = abs(lift(S1,plus_plus(nat,K,one_one(nat)))) ) ).

tff(fact_5_abs,axiom,
    ! [T: dB,S1: dB] :
      ( beta(S1,T)
     => beta(abs(S1),abs(T)) ) ).

tff(fact_6_subst__lift,axiom,
    ! [S1: dB,K: nat,T: dB] : ( subst(lift(T,K),S1,K) = T ) ).

tff(fact_7_lift_Osimps_I2_J,axiom,
    ! [K: nat,T: dB,S1: dB] : ( lift(aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,lift(S1,K)),lift(T,K)) ) ).

tff(fact_8_lift__preserves__beta,axiom,
    ! [I1: nat,S1: dB,R1: dB] :
      ( beta(R1,S1)
     => beta(lift(R1,I1),lift(S1,I1)) ) ).

tff(fact_9_dB_Osimps_I7_J,axiom,
    ! [Nat4: nat,DB3: dB] : ( abs(DB3) != var(Nat4) ) ).

tff(fact_10_dB_Osimps_I6_J,axiom,
    ! [DB3: dB,Nat4: nat] : ( var(Nat4) != abs(DB3) ) ).

tff(fact_11_beta__cases_I2_J,axiom,
    ! [S1: dB,R1: dB] :
      ( beta(abs(R1),S1)
     => ~ ! [T1: dB] :
            ( ( S1 = abs(T1) )
           => ~ beta(R1,T1) ) ) ).

tff(fact_12_dB_Osimps_I2_J,axiom,
    ! [DB23: dB,DB13: dB,DB21: dB,DB11: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) )
    <=> ( ( DB11 = DB13 )
        & ( DB21 = DB23 ) ) ) ).

tff(fact_13_dB_Osimps_I1_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( var(Nat2) = var(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_14_appL,axiom,
    ! [U: dB,T: dB,S1: dB] :
      ( beta(S1,T)
     => beta(aa(dB,dB,aa(dB,fun(dB,dB),app,S1),U),aa(dB,dB,aa(dB,fun(dB,dB),app,T),U)) ) ).

tff(fact_15_appR,axiom,
    ! [U: dB,T: dB,S1: dB] :
      ( beta(S1,T)
     => beta(aa(dB,dB,aa(dB,fun(dB,dB),app,U),S1),aa(dB,dB,aa(dB,fun(dB,dB),app,U),T)) ) ).

tff(fact_16_subst__App,axiom,
    ! [K: nat,S1: dB,U: dB,T: dB] : ( subst(aa(dB,dB,aa(dB,fun(dB,dB),app,T),U),S1,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,subst(T,S1,K)),subst(U,S1,K)) ) ).

tff(fact_17_beta__cases_I1_J,axiom,
    ! [T: dB,I1: nat] : ~ beta(var(I1),T) ).

tff(fact_18_dB_Osimps_I4_J,axiom,
    ! [DB22: dB,DB12: dB,Nat4: nat] : ( var(Nat4) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) ) ).

tff(fact_19_dB_Osimps_I5_J,axiom,
    ! [Nat4: nat,DB22: dB,DB12: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) != var(Nat4) ) ).

tff(fact_20_subst__eq,axiom,
    ! [U: dB,K: nat] : ( subst(var(K),U,K) = U ) ).

tff(fact_21_dB_Orecs_I1_J,axiom,
    ! [A: $tType,Nat2: nat,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,var(Nat2)) = aa(nat,A,F1,Nat2) ) ).

tff(fact_22_dB_Osimps_I10_J,axiom,
    ! [A: $tType,Nat2: nat,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,var(Nat2)) = aa(nat,A,F1,Nat2) ) ).

tff(fact_23_dB_Osimps_I11_J,axiom,
    ! [A: $tType,DB21: dB,DB11: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21)) = aa(dB,A,aa(dB,fun(dB,A),F2,DB11),DB21) ) ).

tff(fact_24_dB_Orecs_I2_J,axiom,
    ! [A: $tType,DB21: dB,DB11: dB,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21)) = aa(A,A,aa(A,fun(A,A),aa(dB,fun(A,fun(A,A)),aa(dB,fun(dB,fun(A,fun(A,A))),F2,DB11),DB21),dB_rec(A,F1,F2,F3,DB11)),dB_rec(A,F1,F2,F3,DB21)) ) ).

tff(fact_25_subst__preserves__beta,axiom,
    ! [I1: nat,T: dB,S1: dB,R1: dB] :
      ( beta(R1,S1)
     => beta(subst(R1,T,I1),subst(S1,T,I1)) ) ).

tff(fact_26_dB_Osimps_I8_J,axiom,
    ! [DB3: dB,DB2: dB,DB1: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) != abs(DB3) ) ).

tff(fact_27_dB_Osimps_I9_J,axiom,
    ! [DB2: dB,DB1: dB,DB3: dB] : ( abs(DB3) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) ) ).

tff(fact_28_substn_Osimps_I3_J,axiom,
    ! [K: nat,S1: dB,T: dB] : ( substn(abs(T),S1,K) = abs(substn(T,S1,plus_plus(nat,K,one_one(nat)))) ) ).

tff(fact_29_nat__add__left__cancel,axiom,
    ! [N: nat,M: nat,K1: nat] :
      ( ( plus_plus(nat,K1,M) = plus_plus(nat,K1,N) )
    <=> ( M = N ) ) ).

tff(fact_30_nat__add__right__cancel,axiom,
    ! [N: nat,K1: nat,M: nat] :
      ( ( plus_plus(nat,M,K1) = plus_plus(nat,N,K1) )
    <=> ( M = N ) ) ).

tff(fact_31_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B2: A,A2: A] :
          ( ( plus_plus(A,A2,B2) = plus_plus(A,A2,C1) )
        <=> ( B2 = C1 ) ) ) ).

tff(fact_32_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,A2: A,B2: A] :
          ( ( plus_plus(A,B2,A2) = plus_plus(A,C1,A2) )
        <=> ( B2 = C1 ) ) ) ).

tff(fact_33_liftn_Osimps_I3_J,axiom,
    ! [K: nat,S1: dB,N1: nat] : ( liftn(N1,abs(S1),K) = abs(liftn(N1,S1,plus_plus(nat,K,one_one(nat)))) ) ).

tff(fact_34_subst__Abs,axiom,
    ! [K: nat,S1: dB,T: dB] : ( subst(abs(T),S1,K) = abs(subst(T,lift(S1,zero_zero(nat)),plus_plus(nat,K,one_one(nat)))) ) ).

tff(fact_35_beta,axiom,
    ! [T: dB,S1: dB] : beta(aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S1)),T),subst(S1,T,zero_zero(nat))) ).

tff(fact_36_double__zero__sym,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A2: A] :
          ( ( zero_zero(A) = plus_plus(A,A2,A2) )
        <=> ( A2 = zero_zero(A) ) ) ) ).

tff(fact_37_add__is__0,axiom,
    ! [N: nat,M: nat] :
      ( ( plus_plus(nat,M,N) = zero_zero(nat) )
    <=> ( ( M = zero_zero(nat) )
        & ( N = zero_zero(nat) ) ) ) ).

tff(fact_38_liftn_Osimps_I2_J,axiom,
    ! [K: nat,T: dB,S1: dB,N1: nat] : ( liftn(N1,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,liftn(N1,S1,K)),liftn(N1,T,K)) ) ).

tff(fact_39_substn_Osimps_I2_J,axiom,
    ! [K: nat,S1: dB,U: dB,T: dB] : ( substn(aa(dB,dB,aa(dB,fun(dB,dB),app,T),U),S1,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,substn(T,S1,K)),substn(U,S1,K)) ) ).

tff(fact_40_substn__subst__n,axiom,
    ! [N1: nat,S1: dB,T: dB] : ( substn(T,S1,N1) = subst(T,liftn(N1,S1,zero_zero(nat)),N1) ) ).

tff(fact_41_liftn__0,axiom,
    ! [K: nat,T: dB] : ( liftn(zero_zero(nat),T,K) = T ) ).

tff(fact_42_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X2: A] :
          ( ( zero_zero(A) = X2 )
        <=> ( X2 = zero_zero(A) ) ) ) ).

tff(fact_43_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_44_add__0__right,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_45_add__0,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,zero_zero(A),A1) = A1 ) ) ).

tff(fact_46_add__0__left,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,zero_zero(A),A1) = A1 ) ) ).

tff(fact_47_add__eq__self__zero,axiom,
    ! [N1: nat,M1: nat] :
      ( ( plus_plus(nat,M1,N1) = M1 )
     => ( N1 = zero_zero(nat) ) ) ).

tff(fact_48_Nat_Oadd__0__right,axiom,
    ! [M1: nat] : ( plus_plus(nat,M1,zero_zero(nat)) = M1 ) ).

tff(fact_49_plus__nat_Oadd__0,axiom,
    ! [N1: nat] : ( plus_plus(nat,zero_zero(nat),N1) = N1 ) ).

tff(fact_50_substn__subst__0,axiom,
    ! [S1: dB,T: dB] : ( substn(T,S1,zero_zero(nat)) = subst(T,S1,zero_zero(nat)) ) ).

tff(fact_51_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,A1: A,B1: A] :
          ( ( plus_plus(A,B1,A1) = plus_plus(A,C,A1) )
         => ( B1 = C ) ) ) ).

tff(fact_52_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C: A,B1: A,A1: A] :
          ( ( plus_plus(A,A1,B1) = plus_plus(A,A1,C) )
         => ( B1 = C ) ) ) ).

tff(fact_53_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,B1: A,A1: A] :
          ( ( plus_plus(A,A1,B1) = plus_plus(A,A1,C) )
         => ( B1 = C ) ) ) ).

tff(fact_54_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C: A,B1: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B1),C) = plus_plus(A,A1,plus_plus(A,B1,C)) ) ) ).

tff(fact_55_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [X2: A] :
          ( ( one_one(A) = X2 )
        <=> ( X2 = one_one(A) ) ) ) ).

tff(fact_56_nat__add__assoc,axiom,
    ! [K: nat,N1: nat,M1: nat] : ( plus_plus(nat,plus_plus(nat,M1,N1),K) = plus_plus(nat,M1,plus_plus(nat,N1,K)) ) ).

tff(fact_57_nat__add__left__commute,axiom,
    ! [Z: nat,Y: nat,X: nat] : ( plus_plus(nat,X,plus_plus(nat,Y,Z)) = plus_plus(nat,Y,plus_plus(nat,X,Z)) ) ).

tff(fact_58_nat__add__commute,axiom,
    ! [N1: nat,M1: nat] : ( plus_plus(nat,M1,N1) = plus_plus(nat,N1,M1) ) ).

tff(fact_59_double__eq__0__iff,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A2: A] :
          ( ( plus_plus(A,A2,A2) = zero_zero(A) )
        <=> ( A2 = zero_zero(A) ) ) ) ).

tff(fact_60_beta__cases_I3_J,axiom,
    ! [U: dB,T: dB,S1: dB] :
      ( beta(aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T),U)
     => ( ! [S2: dB] :
            ( ( U = subst(S2,T,zero_zero(nat)) )
           => ( S1 != abs(S2) ) )
       => ( ! [T1: dB] :
              ( ( U = aa(dB,dB,aa(dB,fun(dB,dB),app,T1),T) )
             => ~ beta(S1,T1) )
         => ~ ! [T1: dB] :
                ( ( U = aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T1) )
               => ~ beta(T,T1) ) ) ) ) ).

tff(fact_61_dB_Osize_I1_J,axiom,
    ! [Nat4: nat] : ( dB_size(var(Nat4)) = zero_zero(nat) ) ).

tff(fact_62_zero__neq__one,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( zero_zero(A) != one_one(A) ) ) ).

tff(fact_63_one__neq__zero,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( one_one(A) != zero_zero(A) ) ) ).

tff(fact_64_comm__semiring__1__class_Onormalizing__semiring__rules_I5_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : ( plus_plus(A,zero_zero(A),A1) = A1 ) ) ).

tff(fact_65_comm__semiring__1__class_Onormalizing__semiring__rules_I6_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : ( plus_plus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_66_add__0__iff,axiom,
    ! [A: $tType] :
      ( semiri456707255roduct(A)
     => ! [A2: A,B2: A] :
          ( ( B2 = plus_plus(A,B2,A2) )
        <=> ( A2 = zero_zero(A) ) ) ) ).

tff(fact_67_comm__semiring__1__class_Onormalizing__semiring__rules_I20_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C: A,B1: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B1),plus_plus(A,C,D)) = plus_plus(A,plus_plus(A,A1,C),plus_plus(A,B1,D)) ) ) ).

tff(fact_68_comm__semiring__1__class_Onormalizing__semiring__rules_I23_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,B1: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B1),C) = plus_plus(A,plus_plus(A,A1,C),B1) ) ) ).

tff(fact_69_comm__semiring__1__class_Onormalizing__semiring__rules_I21_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,B1: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B1),C) = plus_plus(A,A1,plus_plus(A,B1,C)) ) ) ).

tff(fact_70_comm__semiring__1__class_Onormalizing__semiring__rules_I25_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C: A,A1: A] : ( plus_plus(A,A1,plus_plus(A,C,D)) = plus_plus(A,plus_plus(A,A1,C),D) ) ) ).

tff(fact_71_comm__semiring__1__class_Onormalizing__semiring__rules_I22_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C: A,A1: A] : ( plus_plus(A,A1,plus_plus(A,C,D)) = plus_plus(A,C,plus_plus(A,A1,D)) ) ) ).

tff(fact_72_comm__semiring__1__class_Onormalizing__semiring__rules_I24_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,A1: A] : ( plus_plus(A,A1,C) = plus_plus(A,C,A1) ) ) ).

tff(fact_73_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X1: A] : ( aa(A,B,F,X1) = aa(A,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_74_Beta,axiom,
    ! [Ss: list(dB),S: dB,R: dB] :
      ( it(foldl(dB,dB,app,subst(R,S,zero_zero(nat)),Ss))
     => ( it(S)
       => it(foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R)),S),Ss)) ) ) ).

tff(fact_75_dB_Osize_I3_J,axiom,
    ! [DB: dB] : ( dB_size(abs(DB)) = plus_plus(nat,dB_size(DB),suc(zero_zero(nat))) ) ).

tff(fact_76_dB_Osize_I2_J,axiom,
    ! [DB2: dB,DB1: dB] : ( dB_size(aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2)) = plus_plus(nat,plus_plus(nat,dB_size(DB1),dB_size(DB2)),suc(zero_zero(nat))) ) ).

tff(fact_77_nat_Oinject,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( suc(Nat2) = suc(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_78_add__Suc,axiom,
    ! [N1: nat,M1: nat] : ( plus_plus(nat,suc(M1),N1) = suc(plus_plus(nat,M1,N1)) ) ).

tff(fact_79_add__Suc__right,axiom,
    ! [N1: nat,M1: nat] : ( plus_plus(nat,M1,suc(N1)) = suc(plus_plus(nat,M1,N1)) ) ).

tff(fact_80_One__nat__def,axiom,
    one_one(nat) = suc(zero_zero(nat)) ).

tff(fact_81_liftn__lift,axiom,
    ! [K: nat,T: dB,N1: nat] : ( liftn(suc(N1),T,K) = lift(liftn(N1,T,K),K) ) ).

tff(fact_82_one__is__add,axiom,
    ! [N: nat,M: nat] :
      ( ( suc(zero_zero(nat)) = plus_plus(nat,M,N) )
    <=> ( ( ( M = suc(zero_zero(nat)) )
          & ( N = zero_zero(nat) ) )
        | ( ( M = zero_zero(nat) )
          & ( N = suc(zero_zero(nat)) ) ) ) ) ).

tff(fact_83_add__is__1,axiom,
    ! [N: nat,M: nat] :
      ( ( plus_plus(nat,M,N) = suc(zero_zero(nat)) )
    <=> ( ( ( M = suc(zero_zero(nat)) )
          & ( N = zero_zero(nat) ) )
        | ( ( M = zero_zero(nat) )
          & ( N = suc(zero_zero(nat)) ) ) ) ) ).

tff(fact_84_Suc__inject,axiom,
    ! [Y: nat,X: nat] :
      ( ( suc(X) = suc(Y) )
     => ( X = Y ) ) ).

tff(fact_85_Suc__n__not__n,axiom,
    ! [N1: nat] : ( suc(N1) != N1 ) ).

tff(fact_86_n__not__Suc__n,axiom,
    ! [N1: nat] : ( N1 != suc(N1) ) ).

tff(fact_87_add__Suc__shift,axiom,
    ! [N1: nat,M1: nat] : ( plus_plus(nat,suc(M1),N1) = plus_plus(nat,M1,suc(N1)) ) ).

tff(fact_88_Suc__neq__Zero,axiom,
    ! [M1: nat] : ( suc(M1) != zero_zero(nat) ) ).

tff(fact_89_Zero__neq__Suc,axiom,
    ! [M1: nat] : ( zero_zero(nat) != suc(M1) ) ).

tff(fact_90_nat_Osimps_I3_J,axiom,
    ! [Nat1: nat] : ( suc(Nat1) != zero_zero(nat) ) ).

tff(fact_91_Suc__not__Zero,axiom,
    ! [M1: nat] : ( suc(M1) != zero_zero(nat) ) ).

tff(fact_92_nat_Osimps_I2_J,axiom,
    ! [Nat: nat] : ( zero_zero(nat) != suc(Nat) ) ).

tff(fact_93_Zero__not__Suc,axiom,
    ! [M1: nat] : ( zero_zero(nat) != suc(M1) ) ).

tff(fact_94_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss: list(dB),N: nat,Rs: list(dB),M: nat] :
      ( ( foldl(dB,dB,app,var(M),Rs) = foldl(dB,dB,app,var(N),Ss) )
    <=> ( ( M = N )
        & ( Rs = Ss ) ) ) ).

tff(fact_95_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss: list(dB),S: dB,Rs: list(dB),R: dB] :
      ( ( foldl(dB,dB,app,abs(R),Rs) = foldl(dB,dB,app,abs(S),Ss) )
    <=> ( ( R = S )
        & ( Rs = Ss ) ) ) ).

tff(fact_96_apps__eq__tail__conv,axiom,
    ! [S: dB,Ts: list(dB),R: dB] :
      ( ( foldl(dB,dB,app,R,Ts) = foldl(dB,dB,app,S,Ts) )
    <=> ( R = S ) ) ).

tff(fact_97_Var__apps__neq__Abs__apps,axiom,
    ! [Ss: list(dB),R: dB,Ts: list(dB),N: nat] : ( foldl(dB,dB,app,var(N),Ts) != foldl(dB,dB,app,abs(R),Ss) ) ).

%----Arities (10)
tff(arity_Nat_Onat___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (3)
tff(conj_0,hypothesis,
    it(r) ).

tff(conj_1,hypothesis,
    ! [I: nat] : it(lift(r,I)) ).

tff(conj_2,conjecture,
    it(lift(abs(r),ia)) ).

%------------------------------------------------------------------------------
