%------------------------------------------------------------------------------
% File     : LCL747_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 22
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_22 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  174 (  62 unt;  50 typ;   0 def)
%            Number of atoms       :  228 ( 112 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :  147 (  43   ~;  11   |;  14   &)
%                                         (  28 <=>;  51  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   5 avg)
%            Maximal term depth    :    9 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   50 (  25   >;  25   *;   0   +;   0  <<)
%            Number of predicates  :   12 (  11 usr;   0 prp; 1-3 aty)
%            Number of functors    :   35 (  35 usr;  10 con; 0-5 aty)
%            Number of variables   :  353 ( 304   !;  11   ?; 353   :)
%                                         (  38  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:15:05
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (44)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Nat_Osemiring__char__0,type,
    semiring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_If,type,
    if: 
      !>[A: $tType] : ( ( bool * A * A ) > A ) ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Int_Oring__1__class_Oof__int,type,
    ring_1_of_int: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Lambda_Obeta,type,
    beta: ( dB * dB ) > $o ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__case,type,
    dB_case: 
      !>[T2: $tType] : ( ( fun(nat,T2) * fun(dB,fun(dB,T2)) * fun(dB,T2) * dB ) > T2 ) ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: fun(dB,fun(nat,dB)) ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: fun(dB,fun(dB,fun(nat,dB))) ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T2: $tType,A: $tType] : ( ( T2 * fun(A,fun(list(A),T2)) * list(A) ) > T2 ) ).

tff(sy_c_List_Olist_Olist__rec,type,
    list_rec: 
      !>[T2: $tType,A: $tType] : ( ( T2 * fun(A,fun(list(A),fun(T2,T2))) * list(A) ) > T2 ) ).

tff(sy_c_List_Olist_Olist__size,type,
    list_size: 
      !>[A: $tType] : ( ( fun(A,nat) * list(A) ) > nat ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat,type,
    semiring_1_of_nat: 
      !>[A: $tType] : ( nat > A ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fAll,type,
    fAll: 
      !>[A: $tType] : fun(fun(A,bool),bool) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_ia,type,
    ia: nat ).

tff(sy_v_n,type,
    n: nat ).

tff(sy_v_rs,type,
    rs: list(dB) ).

%----Relevant facts (99)
tff(fact_0_IT_OVar,axiom,
    ! [N1: nat,Rs1: list(dB)] :
      ( listsp(dB,it,Rs1)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(N1),Rs1))) ) ).

tff(fact_1_lift__map,axiom,
    ! [Ia: nat,Ts1: list(dB),Ta: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,foldl(dB,dB,app,Ta,Ts1)),Ia) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),lift,Ta),Ia),map(dB,dB,combc(dB,nat,dB,lift,Ia),Ts1)) ) ).

tff(fact_2_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss: list(dB),N1: nat,Rs1: list(dB),M: nat] :
      ( ( foldl(dB,dB,app,var(M),Rs1) = foldl(dB,dB,app,var(N1),Ss) )
    <=> ( ( M = N1 )
        & ( Rs1 = Ss ) ) ) ).

tff(fact_3_lift_Osimps_I2_J,axiom,
    ! [K: nat,T: dB,S: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,aa(dB,dB,aa(dB,fun(dB,dB),app,S),T)),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),lift,S),K)),aa(nat,dB,aa(dB,fun(nat,dB),lift,T),K)) ) ).

tff(fact_4_apps__eq__tail__conv,axiom,
    ! [S2: dB,Ts1: list(dB),R1: dB] :
      ( ( foldl(dB,dB,app,R1,Ts1) = foldl(dB,dB,app,S2,Ts1) )
    <=> ( R1 = S2 ) ) ).

tff(fact_5_listsp__conj__eq,axiom,
    ! [A: $tType,B1: fun(A,bool),A2: fun(A,bool),X3: list(A)] :
      ( listsp(A,combs(A,bool,bool,aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),A2),B1),X3)
    <=> ( listsp(A,A2,X3)
        & listsp(A,B1,X3) ) ) ).

tff(fact_6_map__ident,axiom,
    ! [A: $tType,X3: list(A)] : ( map(A,A,combi(A),X3) = X3 ) ).

tff(fact_7_dB_Osimps_I1_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( var(Nat2) = var(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_8_dB_Osimps_I2_J,axiom,
    ! [DB24: dB,DB14: dB,DB22: dB,DB12: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB14),DB24) )
    <=> ( ( DB12 = DB14 )
        & ( DB22 = DB24 ) ) ) ).

tff(fact_9_foldl__map,axiom,
    ! [A: $tType,B: $tType,C: $tType,Xs: list(C),F: fun(C,B),A1: A,G: fun(A,fun(B,A))] : ( foldl(A,B,G,A1,map(C,B,F,Xs)) = foldl(A,C,combc(A,fun(C,B),fun(C,A),aa(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A))),aa(fun(fun(B,A),fun(fun(C,B),fun(C,A))),fun(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A)))),combb(fun(B,A),fun(fun(C,B),fun(C,A)),A),combb(B,A,C)),G),F),A1,Xs) ) ).

tff(fact_10_dB_Osimps_I4_J,axiom,
    ! [DB23: dB,DB13: dB,Nat: nat] : ( var(Nat) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) ) ).

tff(fact_11_dB_Osimps_I5_J,axiom,
    ! [Nat: nat,DB23: dB,DB13: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) != var(Nat) ) ).

tff(fact_12_subst__map,axiom,
    ! [Ia: nat,U2: dB,Ts1: list(dB),Ta: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,foldl(dB,dB,app,Ta,Ts1)),U2),Ia) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),U2),Ia),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,U2),Ia),Ts1)) ) ).

tff(fact_13_foldl__fun__comm,axiom,
    ! [B: $tType,A: $tType,X1: A,Xs: list(A),S2: B,F: fun(B,fun(A,B))] :
      ( ! [X2: A,Y2: A,S1: B] : ( aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S1),X2)),Y2) = aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S1),Y2)),X2) )
     => ( aa(A,B,aa(B,fun(A,B),F,foldl(B,A,F,S2,Xs)),X1) = foldl(B,A,F,aa(A,B,aa(B,fun(A,B),F,S2),X1),Xs) ) ) ).

tff(fact_14_Var__eq__apps__conv,axiom,
    ! [Ss: list(dB),S2: dB,M: nat] :
      ( ( var(M) = foldl(dB,dB,app,S2,Ss) )
    <=> ( ( var(M) = S2 )
        & ( Ss = nil(dB) ) ) ) ).

tff(fact_15_dB_Osimps_I10_J,axiom,
    ! [A: $tType,Nat2: nat,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,var(Nat2)) = aa(nat,A,F1,Nat2) ) ).

tff(fact_16_dB_Osimps_I11_J,axiom,
    ! [A: $tType,DB22: dB,DB12: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22)) = aa(dB,A,aa(dB,fun(dB,A),F2,DB12),DB22) ) ).

tff(fact_17_substn_Osimps_I2_J,axiom,
    ! [K: nat,S: dB,U: dB,T: dB] : ( substn(aa(dB,dB,aa(dB,fun(dB,dB),app,T),U),S,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,substn(T,S,K)),substn(U,S,K)) ) ).

tff(fact_18_Var__apps__neq__Abs__apps,axiom,
    ! [Ss: list(dB),R1: dB,Ts1: list(dB),N1: nat] : ( foldl(dB,dB,app,var(N1),Ts1) != foldl(dB,dB,app,abs(R1),Ss) ) ).

tff(fact_19_Abs__App__neq__Var__apps,axiom,
    ! [Ss: list(dB),N1: nat,Ta: dB,S2: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S2)),Ta) != foldl(dB,dB,app,var(N1),Ss) ) ).

tff(fact_20_nat__less__cases,axiom,
    ! [P1: fun(nat,fun(nat,bool)),N1: nat,M: nat] :
      ( ( ord_less(nat,M,N1)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M)) )
     => ( ( ( M = N1 )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M)) )
       => ( ( ord_less(nat,N1,M)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M)) ) ) ) ).

tff(fact_21_dB_Osimps_I3_J,axiom,
    ! [DB5: dB,DB4: dB] :
      ( ( abs(DB4) = abs(DB5) )
    <=> ( DB4 = DB5 ) ) ).

tff(fact_22_Nil__is__map__conv,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,A)] :
      ( ( nil(A) = map(B,A,F,Xs) )
    <=> ( Xs = nil(B) ) ) ).

tff(fact_23_map_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,F: fun(B,A)] : ( map(B,A,F,nil(B)) = nil(A) ) ).

tff(fact_24_map__is__Nil__conv,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xs) = nil(A) )
    <=> ( Xs = nil(B) ) ) ).

tff(fact_25_listsp_ONil,axiom,
    ! [A: $tType,A2: fun(A,bool)] : listsp(A,A2,nil(A)) ).

tff(fact_26_subst__App,axiom,
    ! [K: nat,S: dB,U: dB,T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(dB,dB,aa(dB,fun(dB,dB),app,T),U)),S),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),S),K)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,U),S),K)) ) ).

tff(fact_27_Lambda,axiom,
    ! [R2: dB] :
      ( pp(aa(dB,bool,it,R2))
     => pp(aa(dB,bool,it,abs(R2))) ) ).

tff(fact_28_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss: list(dB),S2: dB,Rs1: list(dB),R1: dB] :
      ( ( foldl(dB,dB,app,abs(R1),Rs1) = foldl(dB,dB,app,abs(S2),Ss) )
    <=> ( ( R1 = S2 )
        & ( Rs1 = Ss ) ) ) ).

tff(fact_29_Abs__eq__apps__conv,axiom,
    ! [Ss: list(dB),S2: dB,R1: dB] :
      ( ( abs(R1) = foldl(dB,dB,app,S2,Ss) )
    <=> ( ( abs(R1) = S2 )
        & ( Ss = nil(dB) ) ) ) ).

tff(fact_30_apps__eq__Abs__conv,axiom,
    ! [R1: dB,Ss: list(dB),S2: dB] :
      ( ( foldl(dB,dB,app,S2,Ss) = abs(R1) )
    <=> ( ( S2 = abs(R1) )
        & ( Ss = nil(dB) ) ) ) ).

tff(fact_31_dB_Osimps_I12_J,axiom,
    ! [A: $tType,DB4: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,abs(DB4)) = aa(dB,A,F3,DB4) ) ).

tff(fact_32_foldl__Nil,axiom,
    ! [B: $tType,A: $tType,A1: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,A1,nil(B)) = A1 ) ).

tff(fact_33_dB_Osimps_I9_J,axiom,
    ! [DB21: dB,DB11: dB,DB3: dB] : ( abs(DB3) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) ) ).

tff(fact_34_dB_Osimps_I8_J,axiom,
    ! [DB3: dB,DB21: dB,DB11: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) != abs(DB3) ) ).

tff(fact_35_dB_Osimps_I7_J,axiom,
    ! [Nat: nat,DB3: dB] : ( abs(DB3) != var(Nat) ) ).

tff(fact_36_dB_Osimps_I6_J,axiom,
    ! [DB3: dB,Nat: nat] : ( var(Nat) != abs(DB3) ) ).

tff(fact_37_subst__eq,axiom,
    ! [U: dB,K: nat] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,var(K)),U),K) = U ) ).

tff(fact_38_subst__lift,axiom,
    ! [S: dB,K: nat,T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(nat,dB,aa(dB,fun(nat,dB),lift,T),K)),S),K) = T ) ).

tff(fact_39_subst__lt,axiom,
    ! [U: dB,I: nat,J: nat] :
      ( ord_less(nat,J,I)
     => ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,var(J)),U),I) = var(J) ) ) ).

tff(fact_40_less__not__refl,axiom,
    ! [N2: nat] : ~ ord_less(nat,N2,N2) ).

tff(fact_41_nat__neq__iff,axiom,
    ! [N1: nat,M: nat] :
      ( ( M != N1 )
    <=> ( ord_less(nat,M,N1)
        | ord_less(nat,N1,M) ) ) ).

tff(fact_42_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ ord_less(nat,X,Y)
       => ord_less(nat,Y,X) ) ) ).

tff(fact_43_less__irrefl__nat,axiom,
    ! [N2: nat] : ~ ord_less(nat,N2,N2) ).

tff(fact_44_less__not__refl2,axiom,
    ! [M1: nat,N2: nat] :
      ( ord_less(nat,N2,M1)
     => ( M1 != N2 ) ) ).

tff(fact_45_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( ord_less(nat,S,T)
     => ( S != T ) ) ).

tff(fact_46_Beta,axiom,
    ! [Ss: list(dB),S2: dB,R1: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R1),S2),zero_zero(nat)),Ss)))
     => ( pp(aa(dB,bool,it,S2))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R1)),S2),Ss))) ) ) ).

tff(fact_47_IT_Osimps,axiom,
    ! [A1: dB] :
      ( pp(aa(dB,bool,it,A1))
    <=> ( ? [Rs: list(dB),N3: nat] :
            ( ( A1 = foldl(dB,dB,app,var(N3),Rs) )
            & listsp(dB,it,Rs) )
        | ? [R3: dB] :
            ( ( A1 = abs(R3) )
            & pp(aa(dB,bool,it,R3)) )
        | ? [R3: dB,S3: dB,Ss1: list(dB)] :
            ( ( A1 = foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R3)),S3),Ss1) )
            & pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R3),S3),zero_zero(nat)),Ss1)))
            & pp(aa(dB,bool,it,S3)) ) ) ) ).

tff(fact_48_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_49_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ~ list_ex1(A,P1,nil(A)) ).

tff(fact_50_dB_Oexhaust,axiom,
    ! [Y: dB] :
      ( ! [Nat1: nat] : ( Y != var(Nat1) )
     => ( ! [DB1: dB,DB2: dB] : ( Y != aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) )
       => ~ ! [DB: dB] : ( Y != abs(DB) ) ) ) ).

tff(fact_51_ex__head__tail,axiom,
    ! [Ta: dB] :
    ? [Ts: list(dB),H: dB] :
      ( ( Ta = foldl(dB,dB,app,H,Ts) )
      & ( ? [N: nat] : ( H = var(N) )
        | ? [U1: dB] : ( H = abs(U1) ) ) ) ).

tff(fact_52_list_Orecs_I1_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),fun(A,A))),F1: A] : ( list_rec(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_53_less__zeroE,axiom,
    ! [N2: nat] : ~ ord_less(nat,N2,zero_zero(nat)) ).

tff(fact_54_less__nat__zero__code,axiom,
    ! [N2: nat] : ~ ord_less(nat,N2,zero_zero(nat)) ).

tff(fact_55_neq0__conv,axiom,
    ! [N1: nat] :
      ( ( N1 != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),N1) ) ).

tff(fact_56_gr0I,axiom,
    ! [N2: nat] :
      ( ( N2 != zero_zero(nat) )
     => ord_less(nat,zero_zero(nat),N2) ) ).

tff(fact_57_gr__implies__not0,axiom,
    ! [N2: nat,M1: nat] :
      ( ord_less(nat,M1,N2)
     => ( N2 != zero_zero(nat) ) ) ).

tff(fact_58_not__less0,axiom,
    ! [N2: nat] : ~ ord_less(nat,N2,zero_zero(nat)) ).

tff(fact_59_substn__subst__0,axiom,
    ! [S: dB,T: dB] : ( substn(T,S,zero_zero(nat)) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),S),zero_zero(nat)) ) ).

tff(fact_60_substn__subst__n,axiom,
    ! [N2: nat,S: dB,T: dB] : ( substn(T,S,N2) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),liftn(N2,S,zero_zero(nat))),N2) ) ).

tff(fact_61_dB_Osize_I1_J,axiom,
    ! [Nat: nat] : ( dB_size(var(Nat)) = zero_zero(nat) ) ).

tff(fact_62_beta,axiom,
    ! [T: dB,S: dB] : beta(aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S)),T),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S),T),zero_zero(nat))) ).

tff(fact_63_appL,axiom,
    ! [U: dB,T: dB,S: dB] :
      ( beta(S,T)
     => beta(aa(dB,dB,aa(dB,fun(dB,dB),app,S),U),aa(dB,dB,aa(dB,fun(dB,dB),app,T),U)) ) ).

tff(fact_64_appR,axiom,
    ! [U: dB,T: dB,S: dB] :
      ( beta(S,T)
     => beta(aa(dB,dB,aa(dB,fun(dB,dB),app,U),S),aa(dB,dB,aa(dB,fun(dB,dB),app,U),T)) ) ).

tff(fact_65_abs,axiom,
    ! [T: dB,S: dB] :
      ( beta(S,T)
     => beta(abs(S),abs(T)) ) ).

tff(fact_66_beta__cases_I1_J,axiom,
    ! [T: dB,I: nat] : ~ beta(var(I),T) ).

tff(fact_67_liftn_Osimps_I2_J,axiom,
    ! [K: nat,T: dB,S: dB,N2: nat] : ( liftn(N2,aa(dB,dB,aa(dB,fun(dB,dB),app,S),T),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,liftn(N2,S,K)),liftn(N2,T,K)) ) ).

tff(fact_68_subst__preserves__beta,axiom,
    ! [I: nat,T: dB,S: dB,R2: dB] :
      ( beta(R2,S)
     => beta(aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R2),T),I),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S),T),I)) ) ).

tff(fact_69_lift__preserves__beta,axiom,
    ! [I: nat,S: dB,R2: dB] :
      ( beta(R2,S)
     => beta(aa(nat,dB,aa(dB,fun(nat,dB),lift,R2),I),aa(nat,dB,aa(dB,fun(nat,dB),lift,S),I)) ) ).

tff(fact_70_liftn__0,axiom,
    ! [K: nat,T: dB] : ( liftn(zero_zero(nat),T,K) = T ) ).

tff(fact_71_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_72_beta__cases_I2_J,axiom,
    ! [S: dB,R2: dB] :
      ( beta(abs(R2),S)
     => ~ ! [T1: dB] :
            ( ( S = abs(T1) )
           => ~ beta(R2,T1) ) ) ).

tff(fact_73_apps__preserves__beta,axiom,
    ! [Ss: list(dB),S2: dB,R1: dB] :
      ( beta(R1,S2)
     => beta(foldl(dB,dB,app,R1,Ss),foldl(dB,dB,app,S2,Ss)) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_75_beta__cases_I3_J,axiom,
    ! [U: dB,T: dB,S: dB] :
      ( beta(aa(dB,dB,aa(dB,fun(dB,dB),app,S),T),U)
     => ( ! [S1: dB] :
            ( ( U = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S1),T),zero_zero(nat)) )
           => ( S != abs(S1) ) )
       => ( ! [T1: dB] :
              ( ( U = aa(dB,dB,aa(dB,fun(dB,dB),app,T1),T) )
             => ~ beta(S,T1) )
         => ~ ! [T1: dB] :
                ( ( U = aa(dB,dB,aa(dB,fun(dB,dB),app,S),T1) )
               => ~ beta(T,T1) ) ) ) ) ).

tff(fact_76_dB_Osize_I4_J,axiom,
    ! [Nat: nat] : ( size_size(dB,var(Nat)) = zero_zero(nat) ) ).

tff(fact_77_of__nat__0__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N1: nat] :
          ( ord_less(A,zero_zero(A),semiring_1_of_nat(A,N1))
        <=> ord_less(nat,zero_zero(nat),N1) ) ) ).

tff(fact_78_of__nat__eq__iff,axiom,
    ! [A: $tType] :
      ( semiring_char_0(A)
     => ! [N1: nat,M: nat] :
          ( ( semiring_1_of_nat(A,M) = semiring_1_of_nat(A,N1) )
        <=> ( M = N1 ) ) ) ).

tff(fact_79_of__nat__0,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( semiring_1_of_nat(A,zero_zero(nat)) = zero_zero(A) ) ) ).

tff(fact_80_of__nat__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N1: nat,M: nat] :
          ( ord_less(A,semiring_1_of_nat(A,M),semiring_1_of_nat(A,N1))
        <=> ord_less(nat,M,N1) ) ) ).

tff(fact_81_of__nat__less__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [M1: nat] : ~ ord_less(A,semiring_1_of_nat(A,M1),zero_zero(A)) ) ).

tff(fact_82_of__nat__less__imp__less,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N2: nat,M1: nat] :
          ( ord_less(A,semiring_1_of_nat(A,M1),semiring_1_of_nat(A,N2))
         => ord_less(nat,M1,N2) ) ) ).

tff(fact_83_less__imp__of__nat__less,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N2: nat,M1: nat] :
          ( ord_less(nat,M1,N2)
         => ord_less(A,semiring_1_of_nat(A,M1),semiring_1_of_nat(A,N2)) ) ) ).

tff(fact_84_zero__less__int__conv,axiom,
    ! [N1: nat] :
      ( ord_less(int,zero_zero(int),semiring_1_of_nat(int,N1))
    <=> ord_less(nat,zero_zero(nat),N1) ) ).

tff(fact_85_list_Osize_I1_J,axiom,
    ! [A: $tType,Fa: fun(A,nat)] : ( list_size(A,Fa,nil(A)) = zero_zero(nat) ) ).

tff(fact_86_int__int__eq,axiom,
    ! [N1: nat,M: nat] :
      ( ( semiring_1_of_nat(int,M) = semiring_1_of_nat(int,N1) )
    <=> ( M = N1 ) ) ).

tff(fact_87_int__less__0__conv,axiom,
    ! [K: nat] : ~ ord_less(int,semiring_1_of_nat(int,K),zero_zero(int)) ).

tff(fact_88_int__0,axiom,
    semiring_1_of_nat(int,zero_zero(nat)) = zero_zero(int) ).

tff(fact_89_int__eq__0__conv,axiom,
    ! [N1: nat] :
      ( ( semiring_1_of_nat(int,N1) = zero_zero(int) )
    <=> ( N1 = zero_zero(nat) ) ) ).

tff(fact_90_zless__int,axiom,
    ! [N1: nat,M: nat] :
      ( ord_less(int,semiring_1_of_nat(int,M),semiring_1_of_nat(int,N1))
    <=> ord_less(nat,M,N1) ) ).

tff(fact_91_zero__less__imp__eq__int,axiom,
    ! [K: int] :
      ( ord_less(int,zero_zero(int),K)
     => ? [N: nat] :
          ( ord_less(nat,zero_zero(nat),N)
          & ( K = semiring_1_of_nat(int,N) ) ) ) ).

tff(fact_92_transfer__int__nat__relations_I2_J,axiom,
    ! [Y1: nat,X1: nat] :
      ( ord_less(int,semiring_1_of_nat(int,X1),semiring_1_of_nat(int,Y1))
    <=> ord_less(nat,X1,Y1) ) ).

tff(fact_93_transfer__int__nat__relations_I1_J,axiom,
    ! [Y1: nat,X1: nat] :
      ( ( semiring_1_of_nat(int,X1) = semiring_1_of_nat(int,Y1) )
    <=> ( X1 = Y1 ) ) ).

tff(fact_94_int__if__cong,axiom,
    ! [Y1: nat,X1: nat,P1: bool] :
      ( ( pp(P1)
       => ( semiring_1_of_nat(int,X1) = semiring_1_of_nat(int,if(nat,P1,X1,Y1)) ) )
      & ( ~ pp(P1)
       => ( semiring_1_of_nat(int,Y1) = semiring_1_of_nat(int,if(nat,P1,X1,Y1)) ) ) ) ).

tff(fact_95_transfer__int__nat__numerals_I1_J,axiom,
    zero_zero(int) = semiring_1_of_nat(int,zero_zero(nat)) ).

tff(fact_96_of__int__less__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z: int] :
          ( ord_less(A,ring_1_of_int(A,Z),zero_zero(A))
        <=> ord_less(int,Z,zero_zero(int)) ) ) ).

tff(fact_97_of__int__0__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z: int] :
          ( ord_less(A,zero_zero(A),ring_1_of_int(A,Z))
        <=> ord_less(int,zero_zero(int),Z) ) ) ).

tff(fact_98_of__int__eq__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z: int,W: int] :
          ( ( ring_1_of_int(A,W) = ring_1_of_int(A,Z) )
        <=> ( W = Z ) ) ) ).

%----Arities (10)
tff(arity_Int_Oint___Rings_Olinordered__semidom,axiom,
    linordered_semidom(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Nat_Osemiring__char__0,axiom,
    semiring_char_0(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Nat_Osemiring__char__0,axiom,
    semiring_char_0(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (13)
tff(help_If_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( if(A,fTrue,X,Y) = X ) ).

tff(help_If_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( if(A,fFalse,X,Y) = Y ) ).

tff(help_If_3_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fAll_1_1_U,axiom,
    ! [A: $tType,X: A,P: fun(A,bool)] :
      ( ~ pp(aa(fun(A,bool),bool,fAll(A),P))
      | pp(aa(A,bool,P,X)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    listsp(dB,combs(dB,bool,bool,aa(fun(dB,bool),fun(dB,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(dB,bool),fun(dB,fun(bool,bool))),combb(bool,fun(bool,bool),dB),fconj),it),aa(fun(dB,fun(nat,bool)),fun(dB,bool),aa(fun(fun(nat,bool),bool),fun(fun(dB,fun(nat,bool)),fun(dB,bool)),combb(fun(nat,bool),bool,dB),fAll(nat)),aa(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool)),aa(fun(fun(nat,dB),fun(nat,bool)),fun(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool))),combb(fun(nat,dB),fun(nat,bool),dB),aa(fun(dB,bool),fun(fun(nat,dB),fun(nat,bool)),combb(dB,bool,nat),it)),lift))),rs) ).

tff(conj_1,conjecture,
    ( ~ ord_less(nat,n,ia)
    | pp(aa(dB,bool,it,foldl(dB,dB,app,var(n),map(dB,dB,combc(dB,nat,dB,lift,ia),rs)))) ) ).

%------------------------------------------------------------------------------
