%------------------------------------------------------------------------------
% File     : LCL746_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 21
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_21 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  163 (  48 unt;  42 typ;   0 def)
%            Number of atoms       :  246 (  92 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :  158 (  33   ~;   9   |;   7   &)
%                                         (  23 <=>;  86  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   5 avg)
%            Maximal term depth    :    9 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   31 (  15   >;  16   *;   0   +;   0  <<)
%            Number of predicates  :   12 (  11 usr;   0 prp; 1-3 aty)
%            Number of functors    :   28 (  28 usr;  10 con; 0-5 aty)
%            Number of variables   :  373 ( 339   !;   2   ?; 373   :)
%                                         (  32  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:14:48
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (37)
tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Osemigroup__add,type,
    semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__semigroup__add__imp__le,type,
    ordere236663937imp_le: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__cancel__ab__semigroup__add,type,
    ordere223160158up_add: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__case,type,
    dB_case: 
      !>[T1: $tType] : ( ( fun(nat,T1) * fun(dB,fun(dB,T1)) * fun(dB,T1) * dB ) > T1 ) ).

tff(sy_c_Lambda_Olift,type,
    lift: fun(dB,fun(nat,dB)) ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: fun(dB,fun(dB,fun(nat,dB))) ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat__aux,type,
    semiri532925092at_aux: 
      !>[A: $tType] : ( ( fun(A,A) * nat * A ) > A ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fAll,type,
    fAll: 
      !>[A: $tType] : fun(fun(A,bool),bool) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_ia,type,
    ia: nat ).

tff(sy_v_n,type,
    n: nat ).

tff(sy_v_rs,type,
    rs: list(dB) ).

%----Relevant facts (99)
tff(fact_0_IT_OVar,axiom,
    ! [N1: nat,Rs: list(dB)] :
      ( listsp(dB,it,Rs)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(N1),Rs))) ) ).

tff(fact_1_lift__map,axiom,
    ! [Ia: nat,Ts: list(dB),Ta: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,foldl(dB,dB,app,Ta,Ts)),Ia) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),lift,Ta),Ia),map(dB,dB,combc(dB,nat,dB,lift,Ia),Ts)) ) ).

tff(fact_2_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss: list(dB),N1: nat,Rs: list(dB),M1: nat] :
      ( ( foldl(dB,dB,app,var(M1),Rs) = foldl(dB,dB,app,var(N1),Ss) )
    <=> ( ( M1 = N1 )
        & ( Rs = Ss ) ) ) ).

tff(fact_3_lift_Osimps_I2_J,axiom,
    ! [K: nat,T: dB,S1: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T)),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),lift,S1),K)),aa(nat,dB,aa(dB,fun(nat,dB),lift,T),K)) ) ).

tff(fact_4_apps__eq__tail__conv,axiom,
    ! [S: dB,Ts: list(dB),R1: dB] :
      ( ( foldl(dB,dB,app,R1,Ts) = foldl(dB,dB,app,S,Ts) )
    <=> ( R1 = S ) ) ).

tff(fact_5_lessI,axiom,
    ! [N: nat] : ord_less(nat,N,suc(N)) ).

tff(fact_6_not__less__eq,axiom,
    ! [N1: nat,M1: nat] :
      ( ~ ord_less(nat,M1,N1)
    <=> ord_less(nat,N1,suc(M1)) ) ).

tff(fact_7_Suc__less__eq,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less(nat,suc(M1),suc(N1))
    <=> ord_less(nat,M1,N1) ) ).

tff(fact_8_Suc__mono,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,N)
     => ord_less(nat,suc(M),suc(N)) ) ).

tff(fact_9_listsp__conj__eq,axiom,
    ! [A: $tType,B3: fun(A,bool),A3: fun(A,bool),X3: list(A)] :
      ( listsp(A,combs(A,bool,bool,aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),A3),B3),X3)
    <=> ( listsp(A,A3,X3)
        & listsp(A,B3,X3) ) ) ).

tff(fact_10_map__ident,axiom,
    ! [A: $tType,X3: list(A)] : ( map(A,A,combi(A),X3) = X3 ) ).

tff(fact_11_dB_Osimps_I1_J,axiom,
    ! [Nat2: nat,Nat: nat] :
      ( ( var(Nat) = var(Nat2) )
    <=> ( Nat = Nat2 ) ) ).

tff(fact_12_nat_Oinject,axiom,
    ! [Nat2: nat,Nat: nat] :
      ( ( suc(Nat) = suc(Nat2) )
    <=> ( Nat = Nat2 ) ) ).

tff(fact_13_dB_Osimps_I2_J,axiom,
    ! [DB22: dB,DB12: dB,DB2: dB,DB1: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) )
    <=> ( ( DB1 = DB12 )
        & ( DB2 = DB22 ) ) ) ).

tff(fact_14_Suc__inject,axiom,
    ! [Y: nat,X: nat] :
      ( ( suc(X) = suc(Y) )
     => ( X = Y ) ) ).

tff(fact_15_Suc__n__not__n,axiom,
    ! [N: nat] : ( suc(N) != N ) ).

tff(fact_16_n__not__Suc__n,axiom,
    ! [N: nat] : ( N != suc(N) ) ).

tff(fact_17_nat__less__cases,axiom,
    ! [P1: fun(nat,fun(nat,bool)),N1: nat,M1: nat] :
      ( ( ord_less(nat,M1,N1)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M1)) )
     => ( ( ( M1 = N1 )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M1)) )
       => ( ( ord_less(nat,N1,M1)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M1)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M1)) ) ) ) ).

tff(fact_18_less__not__refl3,axiom,
    ! [T: nat,S1: nat] :
      ( ord_less(nat,S1,T)
     => ( S1 != T ) ) ).

tff(fact_19_less__not__refl2,axiom,
    ! [M: nat,N: nat] :
      ( ord_less(nat,N,M)
     => ( M != N ) ) ).

tff(fact_20_less__irrefl__nat,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_21_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ ord_less(nat,X,Y)
       => ord_less(nat,Y,X) ) ) ).

tff(fact_22_nat__neq__iff,axiom,
    ! [N1: nat,M1: nat] :
      ( ( M1 != N1 )
    <=> ( ord_less(nat,M1,N1)
        | ord_less(nat,N1,M1) ) ) ).

tff(fact_23_less__not__refl,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_24_Suc__less__SucD,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,suc(M),suc(N))
     => ord_less(nat,M,N) ) ).

tff(fact_25_Suc__lessD,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,suc(M),N)
     => ord_less(nat,M,N) ) ).

tff(fact_26_less__SucE,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,suc(N))
     => ( ~ ord_less(nat,M,N)
       => ( M = N ) ) ) ).

tff(fact_27_less__trans__Suc,axiom,
    ! [K: nat,J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ( ord_less(nat,J,K)
       => ord_less(nat,suc(I),K) ) ) ).

tff(fact_28_Suc__lessI,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,N)
     => ( ( suc(M) != N )
       => ord_less(nat,suc(M),N) ) ) ).

tff(fact_29_less__SucI,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,N)
     => ord_less(nat,M,suc(N)) ) ).

tff(fact_30_less__antisym,axiom,
    ! [M: nat,N: nat] :
      ( ~ ord_less(nat,N,M)
     => ( ord_less(nat,N,suc(M))
       => ( M = N ) ) ) ).

tff(fact_31_not__less__less__Suc__eq,axiom,
    ! [M1: nat,N1: nat] :
      ( ~ ord_less(nat,N1,M1)
     => ( ord_less(nat,N1,suc(M1))
      <=> ( N1 = M1 ) ) ) ).

tff(fact_32_less__Suc__eq,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less(nat,M1,suc(N1))
    <=> ( ord_less(nat,M1,N1)
        | ( M1 = N1 ) ) ) ).

tff(fact_33_dB_Osimps_I5_J,axiom,
    ! [Nat1: nat,DB21: dB,DB11: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) != var(Nat1) ) ).

tff(fact_34_dB_Osimps_I4_J,axiom,
    ! [DB21: dB,DB11: dB,Nat1: nat] : ( var(Nat1) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) ) ).

tff(fact_35_foldl__map,axiom,
    ! [A: $tType,B: $tType,C: $tType,Xs: list(C),F: fun(C,B),A2: A,G: fun(A,fun(B,A))] : ( foldl(A,B,G,A2,map(C,B,F,Xs)) = foldl(A,C,combc(A,fun(C,B),fun(C,A),aa(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A))),aa(fun(fun(B,A),fun(fun(C,B),fun(C,A))),fun(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A)))),combb(fun(B,A),fun(fun(C,B),fun(C,A)),A),combb(B,A,C)),G),F),A2,Xs) ) ).

tff(fact_36_lift__Suc__mono__less,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [N3: nat,N1: nat,F: fun(nat,A)] :
          ( ! [N2: nat] : ord_less(A,aa(nat,A,F,N2),aa(nat,A,F,suc(N2)))
         => ( ord_less(nat,N1,N3)
           => ord_less(A,aa(nat,A,F,N1),aa(nat,A,F,N3)) ) ) ) ).

tff(fact_37_lift__Suc__mono__less__iff,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [M1: nat,N1: nat,F: fun(nat,A)] :
          ( ! [N2: nat] : ord_less(A,aa(nat,A,F,N2),aa(nat,A,F,suc(N2)))
         => ( ord_less(A,aa(nat,A,F,N1),aa(nat,A,F,M1))
          <=> ord_less(nat,N1,M1) ) ) ) ).

tff(fact_38_Suc__lessE,axiom,
    ! [K: nat,I: nat] :
      ( ord_less(nat,suc(I),K)
     => ~ ! [J2: nat] :
            ( ord_less(nat,I,J2)
           => ( K != suc(J2) ) ) ) ).

tff(fact_39_lessE,axiom,
    ! [K: nat,I: nat] :
      ( ord_less(nat,I,K)
     => ( ( K != suc(I) )
       => ~ ! [J2: nat] :
              ( ord_less(nat,I,J2)
             => ( K != suc(J2) ) ) ) ) ).

tff(fact_40_subst__map,axiom,
    ! [Ia: nat,U1: dB,Ts: list(dB),Ta: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,foldl(dB,dB,app,Ta,Ts)),U1),Ia) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),U1),Ia),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,U1),Ia),Ts)) ) ).

tff(fact_41_liftn__lift,axiom,
    ! [K: nat,T: dB,N: nat] : ( liftn(suc(N),T,K) = aa(nat,dB,aa(dB,fun(nat,dB),lift,liftn(N,T,K)),K) ) ).

tff(fact_42_of__nat__aux_Osimps_I2_J,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ! [Ia: A,N1: nat,Inc: fun(A,A)] : ( semiri532925092at_aux(A,Inc,suc(N1),Ia) = semiri532925092at_aux(A,Inc,N1,aa(A,A,Inc,Ia)) ) ) ).

tff(fact_43_foldl__fun__comm,axiom,
    ! [B: $tType,A: $tType,X2: A,Xs: list(A),S: B,F: fun(B,fun(A,B))] :
      ( ! [X1: A,Y2: A,S2: B] : ( aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S2),X1)),Y2) = aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S2),Y2)),X1) )
     => ( aa(A,B,aa(B,fun(A,B),F,foldl(B,A,F,S,Xs)),X2) = foldl(B,A,F,aa(A,B,aa(B,fun(A,B),F,S),X2),Xs) ) ) ).

tff(fact_44_subst__App,axiom,
    ! [K: nat,S1: dB,U: dB,T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(dB,dB,aa(dB,fun(dB,dB),app,T),U)),S1),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),S1),K)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,U),S1),K)) ) ).

tff(fact_45_liftn_Osimps_I2_J,axiom,
    ! [K: nat,T: dB,S1: dB,N: nat] : ( liftn(N,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,liftn(N,S1,K)),liftn(N,T,K)) ) ).

tff(fact_46_subst__eq,axiom,
    ! [U: dB,K: nat] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,var(K)),U),K) = U ) ).

tff(fact_47_subst__lift,axiom,
    ! [S1: dB,K: nat,T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(nat,dB,aa(dB,fun(nat,dB),lift,T),K)),S1),K) = T ) ).

tff(fact_48_subst__lt,axiom,
    ! [U: dB,I: nat,J: nat] :
      ( ord_less(nat,J,I)
     => ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,var(J)),U),I) = var(J) ) ) ).

tff(fact_49_liftn_Osimps_I1_J,axiom,
    ! [N: nat,K: nat,I: nat] :
      ( ( ord_less(nat,I,K)
       => ( liftn(N,var(I),K) = var(I) ) )
      & ( ~ ord_less(nat,I,K)
       => ( liftn(N,var(I),K) = var(aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),I),N)) ) ) ) ).

tff(fact_50_Var__eq__apps__conv,axiom,
    ! [Ss: list(dB),S: dB,M1: nat] :
      ( ( var(M1) = foldl(dB,dB,app,S,Ss) )
    <=> ( ( var(M1) = S )
        & ( Ss = nil(dB) ) ) ) ).

tff(fact_51_dB_Osimps_I10_J,axiom,
    ! [A: $tType,Nat: nat,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,var(Nat)) = aa(nat,A,F1,Nat) ) ).

tff(fact_52_less__Suc__induct,axiom,
    ! [P1: fun(nat,fun(nat,bool)),J1: nat,Ia: nat] :
      ( ord_less(nat,Ia,J1)
     => ( ! [I1: nat] : pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,I1),suc(I1)))
       => ( ! [I1: nat,J2: nat,K1: nat] :
              ( ord_less(nat,I1,J2)
             => ( ord_less(nat,J2,K1)
               => ( pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,I1),J2))
                 => ( pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,J2),K1))
                   => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,I1),K1)) ) ) ) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Ia),J1)) ) ) ) ).

tff(fact_53_nat__add__right__cancel,axiom,
    ! [N1: nat,K3: nat,M1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),K3) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N1),K3) )
    <=> ( M1 = N1 ) ) ).

tff(fact_54_nat__add__left__cancel,axiom,
    ! [N1: nat,M1: nat,K3: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),K3),M1) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),K3),N1) )
    <=> ( M1 = N1 ) ) ).

tff(fact_55_add__Suc,axiom,
    ! [N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),suc(M)),N) = suc(aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N)) ) ).

tff(fact_56_add__Suc__right,axiom,
    ! [N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),suc(N)) = suc(aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N)) ) ).

tff(fact_57_nat__add__left__cancel__less,axiom,
    ! [N1: nat,M1: nat,K3: nat] :
      ( ord_less(nat,aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),K3),M1),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),K3),N1))
    <=> ord_less(nat,M1,N1) ) ).

tff(fact_58_map__is__Nil__conv,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xs) = nil(A) )
    <=> ( Xs = nil(B) ) ) ).

tff(fact_59_map_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,F: fun(B,A)] : ( map(B,A,F,nil(B)) = nil(A) ) ).

tff(fact_60_Nil__is__map__conv,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,A)] :
      ( ( nil(A) = map(B,A,F,Xs) )
    <=> ( Xs = nil(B) ) ) ).

tff(fact_61_listsp_ONil,axiom,
    ! [A: $tType,A3: fun(A,bool)] : listsp(A,A3,nil(A)) ).

tff(fact_62_add__Suc__shift,axiom,
    ! [N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),suc(M)),N) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),suc(N)) ) ).

tff(fact_63_not__add__less1,axiom,
    ! [J: nat,I: nat] : ~ ord_less(nat,aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),I),J),I) ).

tff(fact_64_not__add__less2,axiom,
    ! [I: nat,J: nat] : ~ ord_less(nat,aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),J),I),I) ).

tff(fact_65_trans__less__add1,axiom,
    ! [M: nat,J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ord_less(nat,I,aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),J),M)) ) ).

tff(fact_66_trans__less__add2,axiom,
    ! [M: nat,J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ord_less(nat,I,aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),J)) ) ).

tff(fact_67_add__less__mono1,axiom,
    ! [K: nat,J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ord_less(nat,aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),I),K),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),J),K)) ) ).

tff(fact_68_add__less__mono,axiom,
    ! [L: nat,K: nat,J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ( ord_less(nat,K,L)
       => ord_less(nat,aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),I),K),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),J),L)) ) ) ).

tff(fact_69_less__add__eq__less,axiom,
    ! [N: nat,M: nat,L: nat,K: nat] :
      ( ord_less(nat,K,L)
     => ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),L) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),K),N) )
       => ord_less(nat,M,N) ) ) ).

tff(fact_70_add__lessD1,axiom,
    ! [K: nat,J: nat,I: nat] :
      ( ord_less(nat,aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),I),J),K)
     => ord_less(nat,I,K) ) ).

tff(fact_71_foldl__assoc,axiom,
    ! [A: $tType] :
      ( semigroup_add(A)
     => ! [Zs: list(A),Y1: A,X2: A] : ( foldl(A,A,plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),X2),Y1),Zs) = aa(A,A,aa(A,fun(A,A),plus_plus(A),X2),foldl(A,A,plus_plus(A),Y1,Zs)) ) ) ).

tff(fact_72_foldl__Nil,axiom,
    ! [B: $tType,A: $tType,A2: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,A2,nil(B)) = A2 ) ).

tff(fact_73_nat__add__assoc,axiom,
    ! [K: nat,N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N)),K) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N),K)) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X1: A] : ( aa(A,B,F,X1) = aa(A,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_75_nat__add__left__commute,axiom,
    ! [Z: nat,Y: nat,X: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),X),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Y),Z)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Y),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),X),Z)) ) ).

tff(fact_76_nat__add__commute,axiom,
    ! [N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N),M) ) ).

tff(fact_77_less__iff__Suc__add,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less(nat,M1,N1)
    <=> ? [K2: nat] : ( N1 = suc(aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),K2)) ) ) ).

tff(fact_78_less__add__Suc2,axiom,
    ! [M: nat,I: nat] : ord_less(nat,I,suc(aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),I))) ).

tff(fact_79_less__add__Suc1,axiom,
    ! [M: nat,I: nat] : ord_less(nat,I,suc(aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),I),M))) ).

tff(fact_80_dB_Osimps_I11_J,axiom,
    ! [A: $tType,DB2: dB,DB1: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2)) = aa(dB,A,aa(dB,fun(dB,A),F2,DB1),DB2) ) ).

tff(fact_81_add__less__cancel__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B2: A,C2: A,A2: A] :
          ( ord_less(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),C2),aa(A,A,aa(A,fun(A,A),plus_plus(A),B2),C2))
        <=> ord_less(A,A2,B2) ) ) ).

tff(fact_82_add__less__cancel__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B2: A,A2: A,C2: A] :
          ( ord_less(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),C2),A2),aa(A,A,aa(A,fun(A,A),plus_plus(A),C2),B2))
        <=> ord_less(A,A2,B2) ) ) ).

tff(fact_83_less__imp__Suc__add,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,N)
     => ? [K1: nat] : ( N = suc(aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),K1)) ) ) ).

tff(fact_84_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C2: A,B2: A,A2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),B2) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),C2) )
        <=> ( B2 = C2 ) ) ) ).

tff(fact_85_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C2: A,A2: A,B2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),B2),A2) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C2),A2) )
        <=> ( B2 = C2 ) ) ) ).

tff(fact_86_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,A1: A,B1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),B1),A1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),A1) )
         => ( B1 = C1 ) ) ) ).

tff(fact_87_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C1: A,B1: A,A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C1) )
         => ( B1 = C1 ) ) ) ).

tff(fact_88_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B1: A,A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C1) )
         => ( B1 = C1 ) ) ) ).

tff(fact_89_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C1: A,B1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1)),C1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),aa(A,A,aa(A,fun(A,A),plus_plus(A),B1),C1)) ) ) ).

tff(fact_90_add__strict__right__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [C1: A,B1: A,A1: A] :
          ( ord_less(A,A1,B1)
         => ord_less(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C1),aa(A,A,aa(A,fun(A,A),plus_plus(A),B1),C1)) ) ) ).

tff(fact_91_add__strict__left__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [C1: A,B1: A,A1: A] :
          ( ord_less(A,A1,B1)
         => ord_less(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),A1),aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),B1)) ) ) ).

tff(fact_92_add__strict__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [D: A,C1: A,B1: A,A1: A] :
          ( ord_less(A,A1,B1)
         => ( ord_less(A,C1,D)
           => ord_less(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C1),aa(A,A,aa(A,fun(A,A),plus_plus(A),B1),D)) ) ) ) ).

tff(fact_93_add__less__imp__less__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B1: A,C1: A,A1: A] :
          ( ord_less(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C1),aa(A,A,aa(A,fun(A,A),plus_plus(A),B1),C1))
         => ord_less(A,A1,B1) ) ) ).

tff(fact_94_add__less__imp__less__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B1: A,A1: A,C1: A] :
          ( ord_less(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),A1),aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),B1))
         => ord_less(A,A1,B1) ) ) ).

tff(fact_95_termination__basic__simps_I2_J,axiom,
    ! [Y: nat,Z: nat,X: nat] :
      ( ord_less(nat,X,Z)
     => ord_less(nat,X,aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Y),Z)) ) ).

tff(fact_96_termination__basic__simps_I1_J,axiom,
    ! [Z: nat,Y: nat,X: nat] :
      ( ord_less(nat,X,Y)
     => ord_less(nat,X,aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Y),Z)) ) ).

tff(fact_97_subst__subst,axiom,
    ! [U: dB,V: dB,T: dB,J: nat,I: nat] :
      ( ord_less(nat,I,aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),J),one_one(nat)))
     => ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),aa(nat,dB,aa(dB,fun(nat,dB),lift,V),I)),suc(J))),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,U),V),J)),I) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),U),I)),V),J) ) ) ).

tff(fact_98_lift_Osimps_I1_J,axiom,
    ! [K: nat,I: nat] :
      ( ( ord_less(nat,I,K)
       => ( aa(nat,dB,aa(dB,fun(nat,dB),lift,var(I)),K) = var(I) ) )
      & ( ~ ord_less(nat,I,K)
       => ( aa(nat,dB,aa(dB,fun(nat,dB),lift,var(I)),K) = var(aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),I),one_one(nat))) ) ) ) ).

%----Arities (10)
tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Groups_Oordered__cancel__ab__semigroup__add,axiom,
    ordere223160158up_add(nat) ).

tff(arity_Nat_Onat___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Osemigroup__add,axiom,
    semigroup_add(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

%----Helper facts (10)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fAll_1_1_U,axiom,
    ! [A: $tType,X: A,P: fun(A,bool)] :
      ( ~ pp(aa(fun(A,bool),bool,fAll(A),P))
      | pp(aa(A,bool,P,X)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    listsp(dB,combs(dB,bool,bool,aa(fun(dB,bool),fun(dB,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(dB,bool),fun(dB,fun(bool,bool))),combb(bool,fun(bool,bool),dB),fconj),it),aa(fun(dB,fun(nat,bool)),fun(dB,bool),aa(fun(fun(nat,bool),bool),fun(fun(dB,fun(nat,bool)),fun(dB,bool)),combb(fun(nat,bool),bool,dB),fAll(nat)),aa(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool)),aa(fun(fun(nat,dB),fun(nat,bool)),fun(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool))),combb(fun(nat,dB),fun(nat,bool),dB),aa(fun(dB,bool),fun(fun(nat,dB),fun(nat,bool)),combb(dB,bool,nat),it)),lift))),rs) ).

tff(conj_1,conjecture,
    ( ( ~ ord_less(nat,n,ia)
      | pp(aa(dB,bool,it,foldl(dB,dB,app,var(n),map(dB,dB,combc(dB,nat,dB,lift,ia),rs)))) )
    & ( ~ ord_less(nat,ia,suc(n))
      | pp(aa(dB,bool,it,foldl(dB,dB,app,var(suc(n)),map(dB,dB,combc(dB,nat,dB,lift,ia),rs)))) ) ) ).

%------------------------------------------------------------------------------
