%------------------------------------------------------------------------------
% File     : LCL744_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 19
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_19 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  153 (  52 unt;  44 typ;   0 def)
%            Number of atoms       :  210 ( 125 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :  137 (  36   ~;   3   |;  10   &)
%                                         (  18 <=>;  70  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   5 avg)
%            Maximal term depth    :    6 (   1 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   52 (  25   >;  27   *;   0   +;   0  <<)
%            Number of predicates  :   13 (  12 usr;   0 prp; 1-4 aty)
%            Number of functors    :   28 (  28 usr;   6 con; 0-5 aty)
%            Number of variables   :  315 ( 293   !;   1   ?; 315   :)
%                                         (  21  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:14:14
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Type_Otype,type,
    type: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (38)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: dB > $o ).

tff(sy_c_Lambda_Obeta,type,
    beta: fun(dB,fun(dB,bool)) ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OdB__case,type,
    dB_case: 
      !>[T5: $tType] : ( ( fun(nat,T5) * fun(dB,fun(dB,T5)) * fun(dB,T5) * dB ) > T5 ) ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: ( dB * nat ) > dB ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: ( dB * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_ListOrder_Ostep1,type,
    step1: 
      !>[A: $tType] : ( ( fun(A,fun(A,bool)) * list(A) * list(A) ) > $o ) ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B1: $tType,A: $tType] : ( ( fun(B1,fun(A,B1)) * B1 * list(A) ) > B1 ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat__aux,type,
    semiri532925092at_aux: 
      !>[A: $tType] : ( ( fun(A,A) * nat * A ) > A ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Type_Oshift,type,
    shift: 
      !>[A: $tType] : ( ( fun(nat,A) * nat * A ) > fun(nat,A) ) ).

tff(sy_c_Type_Otype_OAtom,type,
    atom: nat > type ).

tff(sy_c_Type_Otype_OFun,type,
    fun1: ( type * type ) > type ).

tff(sy_c_Type_Otype_Otype__case,type,
    type_case: 
      !>[T5: $tType] : ( ( fun(nat,T5) * fun(type,fun(type,T5)) * type ) > T5 ) ).

tff(sy_c_Type_Otype_Otype__size,type,
    type_size: type > nat ).

tff(sy_c_Type_Otyping,type,
    typing: ( fun(nat,type) * dB * type ) > $o ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B1: $tType] : ( ( fun(A,B1) * A ) > B1 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_i,type,
    i: nat ).

tff(sy_v_t,type,
    t: dB ).

%----Relevant facts (98)
tff(fact_0_Lambda,axiom,
    ! [R2: dB] :
      ( it(R2)
     => it(abs(R2)) ) ).

tff(fact_1_subst__lift,axiom,
    ! [S1: dB,K: nat,T1: dB] : ( subst(lift(T1,K),S1,K) = T1 ) ).

tff(fact_2_lift_Osimps_I2_J,axiom,
    ! [K: nat,T1: dB,S1: dB] : ( lift(aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T1),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,lift(S1,K)),lift(T1,K)) ) ).

tff(fact_3_lift__preserves__beta,axiom,
    ! [I: nat,S1: dB,R2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R2),S1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,lift(R2,I)),lift(S1,I))) ) ).

tff(fact_4_liftn__lift,axiom,
    ! [K: nat,T1: dB,N1: nat] : ( liftn(suc(N1),T1,K) = lift(liftn(N1,T1,K),K) ) ).

tff(fact_5_lift__type,axiom,
    ! [U4: type,Ia: nat,T2: type,Ta: dB,E: fun(nat,type)] :
      ( typing(E,Ta,T2)
     => typing(shift(type,E,Ia,U4),lift(Ta,Ia),T2) ) ).

tff(fact_6_dB_Osimps_I2_J,axiom,
    ! [DB22: dB,DB12: dB,DB21: dB,DB11: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) )
    <=> ( ( DB11 = DB12 )
        & ( DB21 = DB22 ) ) ) ).

tff(fact_7_dB_Osimps_I3_J,axiom,
    ! [DB5: dB,DB3: dB] :
      ( ( abs(DB3) = abs(DB5) )
    <=> ( DB3 = DB5 ) ) ).

tff(fact_8_appL,axiom,
    ! [U1: dB,T1: dB,S1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S1),T1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),U1)),aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U1))) ) ).

tff(fact_9_appR,axiom,
    ! [U1: dB,T1: dB,S1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S1),T1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,U1),S1)),aa(dB,dB,aa(dB,fun(dB,dB),app,U1),T1))) ) ).

tff(fact_10_subst__App,axiom,
    ! [K: nat,S1: dB,U1: dB,T1: dB] : ( subst(aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U1),S1,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,subst(T1,S1,K)),subst(U1,S1,K)) ) ).

tff(fact_11_abs,axiom,
    ! [T1: dB,S1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S1),T1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(S1)),abs(T1))) ) ).

tff(fact_12_liftn_Osimps_I2_J,axiom,
    ! [K: nat,T1: dB,S1: dB,N1: nat] : ( liftn(N1,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T1),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,liftn(N1,S1,K)),liftn(N1,T1,K)) ) ).

tff(fact_13_dB_Osimps_I9_J,axiom,
    ! [DB2: dB,DB1: dB,DB4: dB] : ( abs(DB4) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) ) ).

tff(fact_14_dB_Osimps_I8_J,axiom,
    ! [DB4: dB,DB2: dB,DB1: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) != abs(DB4) ) ).

tff(fact_15_subst__preserves__beta,axiom,
    ! [I: nat,T1: dB,S1: dB,R2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R2),S1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,subst(R2,T1,I)),subst(S1,T1,I))) ) ).

tff(fact_16_shift__eq,axiom,
    ! [A: $tType,T2: A,E: fun(nat,A),J: nat,Ia: nat] :
      ( ( Ia = J )
     => ( aa(nat,A,shift(A,E,Ia,T2),J) = T2 ) ) ).

tff(fact_17_subject__reduction,axiom,
    ! [T4: dB,T2: type,Ta: dB,E: fun(nat,type)] :
      ( typing(E,Ta,T2)
     => ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,Ta),T4))
       => typing(E,T4,T2) ) ) ).

tff(fact_18_subst__lemma,axiom,
    ! [Ia: nat,U4: type,U3: dB,E1: fun(nat,type),T2: type,Ta: dB,E: fun(nat,type)] :
      ( typing(E,Ta,T2)
     => ( typing(E1,U3,U4)
       => ( ( E = shift(type,E1,Ia,U4) )
         => typing(E1,subst(Ta,U3,Ia),T2) ) ) ) ).

tff(fact_19_beta__cases_I2_J,axiom,
    ! [S1: dB,R2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(R2)),S1))
     => ~ ! [T: dB] :
            ( ( S1 = abs(T) )
           => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R2),T)) ) ) ).

tff(fact_20_nat_Oinject,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( suc(Nat2) = suc(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_21_beta,axiom,
    ! [T1: dB,S1: dB] : pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S1)),T1)),subst(S1,T1,zero_zero(nat)))) ).

tff(fact_22_App,axiom,
    ! [Ta: dB,U4: type,T2: type,S: dB,Env: fun(nat,type)] :
      ( typing(Env,S,fun1(T2,U4))
     => ( typing(Env,Ta,T2)
       => typing(Env,aa(dB,dB,aa(dB,fun(dB,dB),app,S),Ta),U4) ) ) ).

tff(fact_23_dB_Osimps_I12_J,axiom,
    ! [A: $tType,DB3: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,abs(DB3)) = aa(dB,A,F3,DB3) ) ).

tff(fact_24_dB_Osimps_I11_J,axiom,
    ! [A: $tType,DB21: dB,DB11: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21)) = aa(dB,A,aa(dB,fun(dB,A),F2,DB11),DB21) ) ).

tff(fact_25_substn_Osimps_I2_J,axiom,
    ! [K: nat,S1: dB,U1: dB,T1: dB] : ( substn(aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U1),S1,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,substn(T1,S1,K)),substn(U1,S1,K)) ) ).

tff(fact_26_n__not__Suc__n,axiom,
    ! [N1: nat] : ( N1 != suc(N1) ) ).

tff(fact_27_Suc__n__not__n,axiom,
    ! [N1: nat] : ( suc(N1) != N1 ) ).

tff(fact_28_type_Osimps_I2_J,axiom,
    ! [Type24: type,Type14: type,Type23: type,Type13: type] :
      ( ( fun1(Type13,Type23) = fun1(Type14,Type24) )
    <=> ( ( Type13 = Type14 )
        & ( Type23 = Type24 ) ) ) ).

tff(fact_29_shift__commute,axiom,
    ! [A: $tType,T2: A,U4: A,Ia: nat,E: fun(nat,A)] : ( shift(A,shift(A,E,Ia,U4),zero_zero(nat),T2) = shift(A,shift(A,E,zero_zero(nat),T2),suc(Ia),U4) ) ).

tff(fact_30_substn__subst__n,axiom,
    ! [N1: nat,S1: dB,T1: dB] : ( substn(T1,S1,N1) = subst(T1,liftn(N1,S1,zero_zero(nat)),N1) ) ).

tff(fact_31_Abs,axiom,
    ! [U4: type,Ta: dB,T2: type,Env: fun(nat,type)] :
      ( typing(shift(type,Env,zero_zero(nat),T2),Ta,U4)
     => typing(Env,abs(Ta),fun1(T2,U4)) ) ).

tff(fact_32_Suc__neq__Zero,axiom,
    ! [M1: nat] : ( suc(M1) != zero_zero(nat) ) ).

tff(fact_33_Zero__neq__Suc,axiom,
    ! [M1: nat] : ( zero_zero(nat) != suc(M1) ) ).

tff(fact_34_nat_Osimps_I3_J,axiom,
    ! [Nat5: nat] : ( suc(Nat5) != zero_zero(nat) ) ).

tff(fact_35_Suc__not__Zero,axiom,
    ! [M1: nat] : ( suc(M1) != zero_zero(nat) ) ).

tff(fact_36_nat_Osimps_I2_J,axiom,
    ! [Nat4: nat] : ( zero_zero(nat) != suc(Nat4) ) ).

tff(fact_37_Zero__not__Suc,axiom,
    ! [M1: nat] : ( zero_zero(nat) != suc(M1) ) ).

tff(fact_38_substn__subst__0,axiom,
    ! [S1: dB,T1: dB] : ( substn(T1,S1,zero_zero(nat)) = subst(T1,S1,zero_zero(nat)) ) ).

tff(fact_39_liftn__0,axiom,
    ! [K: nat,T1: dB] : ( liftn(zero_zero(nat),T1,K) = T1 ) ).

tff(fact_40_Suc__inject,axiom,
    ! [Y1: nat,X1: nat] :
      ( ( suc(X1) = suc(Y1) )
     => ( X1 = Y1 ) ) ).

tff(fact_41_typing__elims_I3_J,axiom,
    ! [T2: type,Ta: dB,E: fun(nat,type)] :
      ( typing(E,abs(Ta),T2)
     => ~ ! [T3: type,U2: type] :
            ( ( T2 = fun1(T3,U2) )
           => ~ typing(shift(type,E,zero_zero(nat),T3),Ta,U2) ) ) ).

tff(fact_42_typing__elims_I2_J,axiom,
    ! [T2: type,U3: dB,Ta: dB,E: fun(nat,type)] :
      ( typing(E,aa(dB,dB,aa(dB,fun(dB,dB),app,Ta),U3),T2)
     => ~ ! [T3: type] :
            ( typing(E,Ta,fun1(T3,T2))
           => ~ typing(E,U3,T3) ) ) ).

tff(fact_43_abs__typeE,axiom,
    ! [T2: type,Ta: dB,E: fun(nat,type)] :
      ( typing(E,abs(Ta),T2)
     => ~ ! [U2: type,V: type] : ~ typing(shift(type,E,zero_zero(nat),U2),Ta,V) ) ).

tff(fact_44_beta__cases_I3_J,axiom,
    ! [U1: dB,T1: dB,S1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T1)),U1))
     => ( ! [S2: dB] :
            ( ( U1 = subst(S2,T1,zero_zero(nat)) )
           => ( S1 != abs(S2) ) )
       => ( ! [T: dB] :
              ( ( U1 = aa(dB,dB,aa(dB,fun(dB,dB),app,T),T1) )
             => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S1),T)) )
         => ~ ! [T: dB] :
                ( ( U1 = aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T) )
               => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,T1),T)) ) ) ) ) ).

tff(fact_45_nat_Oexhaust,axiom,
    ! [Y1: nat] :
      ( ( Y1 != zero_zero(nat) )
     => ~ ! [Nat: nat] : ( Y1 != suc(Nat) ) ) ).

tff(fact_46_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X: A] :
          ( ( zero_zero(A) = X )
        <=> ( X = zero_zero(A) ) ) ) ).

tff(fact_47_not0__implies__Suc,axiom,
    ! [N1: nat] :
      ( ( N1 != zero_zero(nat) )
     => ? [M2: nat] : ( N1 = suc(M2) ) ) ).

tff(fact_48_nat__induct,axiom,
    ! [N: nat,P: fun(nat,bool)] :
      ( pp(aa(nat,bool,P,zero_zero(nat)))
     => ( ! [N2: nat] :
            ( pp(aa(nat,bool,P,N2))
           => pp(aa(nat,bool,P,suc(N2))) )
       => pp(aa(nat,bool,P,N)) ) ) ).

tff(fact_49_zero__induct,axiom,
    ! [K1: nat,P: fun(nat,bool)] :
      ( pp(aa(nat,bool,P,K1))
     => ( ! [N2: nat] :
            ( pp(aa(nat,bool,P,suc(N2)))
           => pp(aa(nat,bool,P,N2)) )
       => pp(aa(nat,bool,P,zero_zero(nat))) ) ) ).

tff(fact_50_Beta,axiom,
    ! [Ss: list(dB),S: dB,R: dB] :
      ( it(foldl(dB,dB,app,subst(R,S,zero_zero(nat)),Ss))
     => ( it(S)
       => it(foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R)),S),Ss)) ) ) ).

tff(fact_51_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss: list(dB),S: dB,Rs: list(dB),R: dB] :
      ( ( foldl(dB,dB,app,abs(R),Rs) = foldl(dB,dB,app,abs(S),Ss) )
    <=> ( ( R = S )
        & ( Rs = Ss ) ) ) ).

tff(fact_52_apps__eq__tail__conv,axiom,
    ! [S: dB,Ts: list(dB),R: dB] :
      ( ( foldl(dB,dB,app,R,Ts) = foldl(dB,dB,app,S,Ts) )
    <=> ( R = S ) ) ).

tff(fact_53_apps__preserves__beta,axiom,
    ! [Ss: list(dB),S: dB,R: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R),S))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R,Ss)),foldl(dB,dB,app,S,Ss))) ) ).

tff(fact_54_type_Osimps_I6_J,axiom,
    ! [A: $tType,Type23: type,Type13: type,F2: fun(type,fun(type,A)),F1: fun(nat,A)] : ( type_case(A,F1,F2,fun1(Type13,Type23)) = aa(type,A,aa(type,fun(type,A),F2,Type13),Type23) ) ).

tff(fact_55_of__nat__aux_Osimps_I2_J,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ! [Ia: A,N: nat,Inc: fun(A,A)] : ( semiri532925092at_aux(A,Inc,suc(N),Ia) = semiri532925092at_aux(A,Inc,N,aa(A,A,Inc,Ia)) ) ) ).

tff(fact_56_apps__preserves__betas,axiom,
    ! [R: dB,Ss: list(dB),Rs: list(dB)] :
      ( step1(dB,beta,Rs,Ss)
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R,Rs)),foldl(dB,dB,app,R,Ss))) ) ).

tff(fact_57_type_Osimps_I5_J,axiom,
    ! [A: $tType,Nat2: nat,F2: fun(type,fun(type,A)),F1: fun(nat,A)] : ( type_case(A,F1,F2,atom(Nat2)) = aa(nat,A,F1,Nat2) ) ).

tff(fact_58_type_Osimps_I1_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( atom(Nat2) = atom(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_59_type_Osimps_I3_J,axiom,
    ! [Type22: type,Type12: type,Nat1: nat] : ( atom(Nat1) != fun1(Type12,Type22) ) ).

tff(fact_60_type_Osimps_I4_J,axiom,
    ! [Nat1: nat,Type22: type,Type12: type] : ( fun1(Type12,Type22) != atom(Nat1) ) ).

tff(fact_61_of__nat__aux_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ! [Ia: A,Inc: fun(A,A)] : ( semiri532925092at_aux(A,Inc,zero_zero(nat),Ia) = Ia ) ) ).

tff(fact_62_type_Osize_I1_J,axiom,
    ! [Nat1: nat] : ( type_size(atom(Nat1)) = zero_zero(nat) ) ).

tff(fact_63_type_Osize_I3_J,axiom,
    ! [Nat1: nat] : ( size_size(type,atom(Nat1)) = zero_zero(nat) ) ).

tff(fact_64_type_Oexhaust,axiom,
    ! [Y1: type] :
      ( ! [Nat: nat] : ( Y1 != atom(Nat) )
     => ~ ! [Type11: type,Type21: type] : ( Y1 != fun1(Type11,Type21) ) ) ).

tff(fact_65_type_Osize_I4_J,axiom,
    ! [Type2: type,Type1: type] : ( size_size(type,fun1(Type1,Type2)) = plus_plus(nat,plus_plus(nat,size_size(type,Type1),size_size(type,Type2)),suc(zero_zero(nat))) ) ).

tff(fact_66_type_Osize_I2_J,axiom,
    ! [Type2: type,Type1: type] : ( type_size(fun1(Type1,Type2)) = plus_plus(nat,plus_plus(nat,type_size(Type1),type_size(Type2)),suc(zero_zero(nat))) ) ).

tff(fact_67_apps__betasE,axiom,
    ! [S: dB,Rs: list(dB),R: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R,Rs)),S))
     => ( ! [R1: dB] :
            ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R),R1))
           => ( S != foldl(dB,dB,app,R1,Rs) ) )
       => ( ! [Rs1: list(dB)] :
              ( step1(dB,beta,Rs,Rs1)
             => ( S != foldl(dB,dB,app,R,Rs1) ) )
         => ~ ! [T: dB] :
                ( ( R = abs(T) )
               => ! [U: dB,Us: list(dB)] :
                    ( ( Rs = cons(dB,U,Us) )
                   => ( S != foldl(dB,dB,app,subst(T,U,zero_zero(nat)),Us) ) ) ) ) ) ) ).

tff(fact_68_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B2: A,A1: A] :
          ( ( plus_plus(A,A1,B2) = plus_plus(A,A1,C1) )
        <=> ( B2 = C1 ) ) ) ).

tff(fact_69_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,A1: A,B2: A] :
          ( ( plus_plus(A,B2,A1) = plus_plus(A,C1,A1) )
        <=> ( B2 = C1 ) ) ) ).

tff(fact_70_nat__add__left__cancel,axiom,
    ! [N: nat,M: nat,K1: nat] :
      ( ( plus_plus(nat,K1,M) = plus_plus(nat,K1,N) )
    <=> ( M = N ) ) ).

tff(fact_71_nat__add__right__cancel,axiom,
    ! [N: nat,K1: nat,M: nat] :
      ( ( plus_plus(nat,M,K1) = plus_plus(nat,N,K1) )
    <=> ( M = N ) ) ).

tff(fact_72_double__zero__sym,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( ( zero_zero(A) = plus_plus(A,A1,A1) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_73_ext,axiom,
    ! [B1: $tType,A: $tType,G: fun(A,B1),F: fun(A,B1)] :
      ( ! [X2: A] : ( aa(A,B1,F,X2) = aa(A,B1,G,X2) )
     => ( F = G ) ) ).

tff(fact_74_add__is__0,axiom,
    ! [N: nat,M: nat] :
      ( ( plus_plus(nat,M,N) = zero_zero(nat) )
    <=> ( ( M = zero_zero(nat) )
        & ( N = zero_zero(nat) ) ) ) ).

tff(fact_75_add__Suc__right,axiom,
    ! [N1: nat,M1: nat] : ( plus_plus(nat,M1,suc(N1)) = suc(plus_plus(nat,M1,N1)) ) ).

tff(fact_76_add__Suc,axiom,
    ! [N1: nat,M1: nat] : ( plus_plus(nat,suc(M1),N1) = suc(plus_plus(nat,M1,N1)) ) ).

tff(fact_77_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A2: A] : ( plus_plus(A,A2,zero_zero(A)) = A2 ) ) ).

tff(fact_78_add__0__right,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A2: A] : ( plus_plus(A,A2,zero_zero(A)) = A2 ) ) ).

tff(fact_79_add__0,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A2: A] : ( plus_plus(A,zero_zero(A),A2) = A2 ) ) ).

tff(fact_80_add__0__left,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A2: A] : ( plus_plus(A,zero_zero(A),A2) = A2 ) ) ).

tff(fact_81_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C: A,B: A,A2: A] : ( plus_plus(A,plus_plus(A,A2,B),C) = plus_plus(A,A2,plus_plus(A,B,C)) ) ) ).

tff(fact_82_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,B: A,A2: A] :
          ( ( plus_plus(A,A2,B) = plus_plus(A,A2,C) )
         => ( B = C ) ) ) ).

tff(fact_83_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C: A,B: A,A2: A] :
          ( ( plus_plus(A,A2,B) = plus_plus(A,A2,C) )
         => ( B = C ) ) ) ).

tff(fact_84_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,A2: A,B: A] :
          ( ( plus_plus(A,B,A2) = plus_plus(A,C,A2) )
         => ( B = C ) ) ) ).

tff(fact_85_plus__nat_Oadd__0,axiom,
    ! [N1: nat] : ( plus_plus(nat,zero_zero(nat),N1) = N1 ) ).

tff(fact_86_Nat_Oadd__0__right,axiom,
    ! [M1: nat] : ( plus_plus(nat,M1,zero_zero(nat)) = M1 ) ).

tff(fact_87_add__eq__self__zero,axiom,
    ! [N1: nat,M1: nat] :
      ( ( plus_plus(nat,M1,N1) = M1 )
     => ( N1 = zero_zero(nat) ) ) ).

tff(fact_88_add__Suc__shift,axiom,
    ! [N1: nat,M1: nat] : ( plus_plus(nat,suc(M1),N1) = plus_plus(nat,M1,suc(N1)) ) ).

tff(fact_89_nat__add__commute,axiom,
    ! [N1: nat,M1: nat] : ( plus_plus(nat,M1,N1) = plus_plus(nat,N1,M1) ) ).

tff(fact_90_nat__add__left__commute,axiom,
    ! [Z: nat,Y1: nat,X1: nat] : ( plus_plus(nat,X1,plus_plus(nat,Y1,Z)) = plus_plus(nat,Y1,plus_plus(nat,X1,Z)) ) ).

tff(fact_91_nat__add__assoc,axiom,
    ! [K: nat,N1: nat,M1: nat] : ( plus_plus(nat,plus_plus(nat,M1,N1),K) = plus_plus(nat,M1,plus_plus(nat,N1,K)) ) ).

tff(fact_92_one__is__add,axiom,
    ! [N: nat,M: nat] :
      ( ( suc(zero_zero(nat)) = plus_plus(nat,M,N) )
    <=> ( ( ( M = suc(zero_zero(nat)) )
          & ( N = zero_zero(nat) ) )
        | ( ( M = zero_zero(nat) )
          & ( N = suc(zero_zero(nat)) ) ) ) ) ).

tff(fact_93_add__is__1,axiom,
    ! [N: nat,M: nat] :
      ( ( plus_plus(nat,M,N) = suc(zero_zero(nat)) )
    <=> ( ( ( M = suc(zero_zero(nat)) )
          & ( N = zero_zero(nat) ) )
        | ( ( M = zero_zero(nat) )
          & ( N = suc(zero_zero(nat)) ) ) ) ) ).

tff(fact_94_Cons__step1__Cons,axiom,
    ! [A: $tType,Xs: list(A),X: A,Ys: list(A),Y: A,R: fun(A,fun(A,bool))] :
      ( step1(A,R,cons(A,Y,Ys),cons(A,X,Xs))
    <=> ( ( pp(aa(A,bool,aa(A,fun(A,bool),R,Y),X))
          & ( Xs = Ys ) )
        | ( ( X = Y )
          & step1(A,R,Ys,Xs) ) ) ) ).

tff(fact_95_double__eq__0__iff,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( ( plus_plus(A,A1,A1) = zero_zero(A) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_96_dB_Osize_I3_J,axiom,
    ! [DB: dB] : ( dB_size(abs(DB)) = plus_plus(nat,dB_size(DB),suc(zero_zero(nat))) ) ).

tff(fact_97_dB_Osize_I2_J,axiom,
    ! [DB2: dB,DB1: dB] : ( dB_size(aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2)) = plus_plus(nat,plus_plus(nat,dB_size(DB1),dB_size(DB2)),suc(zero_zero(nat))) ) ).

%----Arities (7)
tff(arity_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    it(t) ).

tff(conj_1,conjecture,
    it(lift(t,i)) ).

%------------------------------------------------------------------------------
