%------------------------------------------------------------------------------
% File     : LCL685+1.005 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Logic Calculi (Modal Logic)
% Problem  : In S4, pigeonhole formulae missing a conjunct, size 5
% Version  : Especial.
% English  :

% Refs     : [BHS00] Balsiger et al. (2000), A Benchmark Method for the Pro
%          : [Kam08] Kaminski (2008), Email to G. Sutcliffe
% Source   : [Kam08]
% Names    : s4_ph_n [BHS00]

% Status   : CounterSatisfiable
% Rating   : 0.33 v9.1.0, 0.40 v9.0.0, 0.33 v8.2.0, 0.00 v7.4.0, 0.33 v7.3.0, 0.00 v7.0.0, 0.33 v6.4.0, 0.00 v6.2.0, 0.22 v6.1.0, 0.10 v6.0.0, 0.00 v5.5.0, 0.29 v5.4.0, 0.60 v5.3.0, 0.62 v5.2.0, 0.25 v5.0.0, 0.33 v4.1.0, 0.17 v4.0.1, 0.33 v4.0.0
% Syntax   : Number of formulae    :    3 (   1 unt;   0 def)
%            Number of atoms       :  320 (   0 equ)
%            Maximal formula atoms :  316 ( 106 avg)
%            Number of connectives :  613 ( 296   ~; 235   |;  81   &)
%                                         (   0 <=>;   1  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   88 (  32 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of predicates  :   31 (  31 usr;   0 prp; 1-2 aty)
%            Number of functors    :    0 (   0 usr;   0 con; --- aty)
%            Number of variables   :  141 ( 140   !;   1   ?)
% SPC      : FOF_CSA_RFO_NEQ

% Comments : A naive relational encoding of the modal logic problem into
%            first-order logic.
%------------------------------------------------------------------------------
fof(reflexivity,axiom,
    ! [X] : r1(X,X) ).

fof(transitivity,axiom,
    ! [X,Y,Z] :
      ( ( r1(X,Y)
        & r1(Y,Z) )
     => r1(X,Z) ) ).

fof(main,conjecture,
    ~ ? [X] :
        ~ ( ~ ! [Y] :
                ( ~ r1(X,Y)
                | ~ ( ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p605(X)
                              & p505(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p605(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p405(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p505(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p405(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p605(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p305(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p505(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p305(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p405(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p305(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p605(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p205(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p505(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p205(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p405(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p205(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p305(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p205(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p605(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p105(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p505(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p105(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p405(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p105(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p305(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p105(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p205(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p105(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p604(X)
                              & p504(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p604(X)
                              & ~ p404(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p504(X)
                              & ~ p404(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p604(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p304(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p504(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p304(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ~ p404(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p304(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p604(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p204(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p504(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p204(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ~ p404(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p204(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p304(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p204(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p604(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p104(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p504(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p104(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ~ p404(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p104(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p304(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p104(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p204(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p104(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p603(X)
                              & p503(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p603(X)
                              & p403(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p503(X)
                              & p403(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p603(X)
                              & p303(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p503(X)
                              & p303(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p403(X)
                              & p303(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p603(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p203(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p503(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p203(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p403(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p203(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p303(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p203(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p603(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p103(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p503(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p103(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p403(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p103(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p303(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p103(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p203(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p103(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p602(X)
                              & p502(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p602(X)
                              & p402(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p502(X)
                              & p402(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p602(X)
                              & p302(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p502(X)
                              & p302(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p402(X)
                              & p302(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p602(X)
                              & p202(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p502(X)
                              & p202(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p402(X)
                              & p202(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p302(X)
                              & p202(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p602(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p102(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p502(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p102(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p402(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p102(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p302(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p102(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p202(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p102(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p601(X)
                              & p501(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p601(X)
                              & p401(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p501(X)
                              & p401(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p601(X)
                              & p301(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p501(X)
                              & p301(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p401(X)
                              & p301(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p601(X)
                              & p201(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p501(X)
                              & p201(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p401(X)
                              & p201(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p301(X)
                              & p201(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p601(X)
                              & p101(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p501(X)
                              & p101(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p401(X)
                              & p101(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p301(X)
                              & p101(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p201(X)
                              & p101(X) ) ) ) )
          | ~ ( ( p605(X)
                | p604(X)
                | p603(X)
                | p602(X)
                | p601(X) )
              & ( p505(X)
                | p504(X)
                | p503(X)
                | p502(X)
                | p501(X) )
              & ( ! [Y] :
                    ( ~ r1(X,Y)
                    | p405(Y) )
                | p404(X)
                | p403(X)
                | p402(X)
                | p401(X) )
              & ( ! [Y] :
                    ( ~ r1(X,Y)
                    | p305(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p304(Y) )
                | p303(X)
                | p302(X)
                | p301(X) )
              & ( ! [Y] :
                    ( ~ r1(X,Y)
                    | p205(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p204(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p203(Y) )
                | p202(X)
                | p201(X) )
              & ( ! [Y] :
                    ( ~ r1(X,Y)
                    | p105(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p104(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p103(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p102(Y) )
                | p101(X) ) ) ) ).

%------------------------------------------------------------------------------
