%------------------------------------------------------------------------------
% File     : LCL684+1.010 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Logic Calculi (Modal Logic)
% Problem  : In S4, pigeonhole formulae, size 10
% Version  : Especial.
% English  :

% Refs     : [BHS00] Balsiger et al. (2000), A Benchmark Method for the Pro
%          : [Kam08] Kaminski (2008), Email to G. Sutcliffe
% Source   : [Kam08]
% Names    : s4_ph_p [BHS00]

% Status   : Theorem
% Rating   : 0.95 v9.1.0, 0.93 v9.0.0, 0.94 v8.2.0, 0.87 v8.1.0, 0.86 v7.5.0, 0.95 v7.4.0, 0.81 v7.3.0, 0.86 v7.2.0, 0.67 v7.1.0, 0.50 v7.0.0, 0.79 v6.4.0, 0.71 v6.3.0, 0.85 v6.2.0, 0.91 v6.1.0, 0.92 v6.0.0, 0.50 v5.5.0, 0.92 v5.4.0, 0.91 v5.3.0, 0.96 v5.2.0, 0.86 v5.0.0, 0.90 v4.1.0, 0.94 v4.0.1, 0.95 v4.0.0
% Syntax   : Number of formulae    :    3 (   1 unt;   0 def)
%            Number of atoms       : 2260 (   0 equ)
%            Maximal formula atoms : 2256 ( 753 avg)
%            Number of connectives : 4408 (2151   ~;1695   |; 561   &)
%                                         (   0 <=>;   1  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  563 ( 190 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of predicates  :  111 ( 111 usr;   0 prp; 1-2 aty)
%            Number of functors    :    0 (   0 usr;   0 con; --- aty)
%            Number of variables   : 1051 (1050   !;   1   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : A naive relational encoding of the modal logic problem into
%            first-order logic.
%------------------------------------------------------------------------------
fof(reflexivity,axiom,
    ! [X] : r1(X,X) ).

fof(transitivity,axiom,
    ! [X,Y,Z] :
      ( ( r1(X,Y)
        & r1(Y,Z) )
     => r1(X,Z) ) ).

fof(main,conjecture,
    ~ ? [X] :
        ~ ( ~ ! [Y] :
                ( ~ r1(X,Y)
                | ~ ( ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1110(X)
                              & p1010(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1110(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p910(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1010(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p910(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1110(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p810(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1010(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p810(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p910(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p810(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1110(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p710(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1010(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p710(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p910(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p710(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p810(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p710(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1110(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p610(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1010(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p610(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p910(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p610(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p810(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p610(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p710(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p610(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1110(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p510(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1010(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p510(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p910(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p510(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p810(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p510(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p710(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p510(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p610(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p510(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1110(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p410(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1010(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p410(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p910(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p410(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p810(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p410(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p710(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p410(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p610(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p410(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p510(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p410(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1110(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p310(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1010(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p310(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p910(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p310(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p810(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p310(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p710(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p310(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p610(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p310(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p510(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p310(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p410(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p310(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1110(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p210(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1010(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p210(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p910(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p210(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p810(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p210(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p710(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p210(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p610(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p210(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p510(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p210(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p410(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p210(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p310(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p210(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1110(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p110(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1010(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p110(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p910(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p110(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p810(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p110(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p710(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p110(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p610(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p110(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p510(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p110(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p410(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p110(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p310(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p110(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p210(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p110(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1109(X)
                              & p1009(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1109(X)
                              & p909(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1009(X)
                              & p909(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1109(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p809(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1009(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p809(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p909(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p809(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1109(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p709(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1009(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p709(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p909(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p709(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p809(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p709(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1109(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p609(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1009(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p609(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p909(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p609(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p809(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p609(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p709(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p609(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1109(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p509(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1009(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p509(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p909(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p509(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p809(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p509(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p709(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p509(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p609(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p509(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1109(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p409(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1009(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p409(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p909(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p409(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p809(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p409(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p709(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p409(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p609(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p409(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p509(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p409(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1109(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p309(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1009(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p309(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p909(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p309(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p809(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p309(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p709(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p309(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p609(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p309(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p509(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p309(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p409(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p309(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1109(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p209(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1009(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p209(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p909(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p209(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p809(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p209(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p709(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p209(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p609(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p209(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p509(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p209(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p409(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p209(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p309(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p209(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1109(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p109(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1009(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p109(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p909(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p109(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p809(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p109(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p709(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p109(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p609(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p109(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p509(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p109(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p409(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p109(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p309(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p109(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p209(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p109(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1108(X)
                              & p1008(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1108(X)
                              & p908(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1008(X)
                              & p908(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1108(X)
                              & p808(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1008(X)
                              & p808(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p908(X)
                              & p808(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1108(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p708(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1008(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p708(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p908(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p708(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p808(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p708(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1108(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p608(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1008(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p608(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p908(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p608(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p808(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p608(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p708(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p608(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1108(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p508(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1008(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p508(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p908(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p508(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p808(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p508(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p708(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p508(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p608(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p508(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1108(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p408(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1008(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p408(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p908(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p408(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p808(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p408(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p708(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p408(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p608(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p408(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p508(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p408(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1108(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p308(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1008(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p308(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p908(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p308(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p808(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p308(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p708(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p308(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p608(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p308(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p508(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p308(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p408(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p308(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1108(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p208(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1008(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p208(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p908(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p208(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p808(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p208(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p708(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p208(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p608(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p208(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p508(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p208(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p408(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p208(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p308(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p208(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1108(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p108(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1008(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p108(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p908(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p108(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p808(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p108(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p708(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p108(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p608(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p108(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p508(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p108(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p408(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p108(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p308(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p108(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p208(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p108(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1107(X)
                              & p1007(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1107(X)
                              & p907(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1007(X)
                              & p907(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1107(X)
                              & p807(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1007(X)
                              & p807(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p907(X)
                              & p807(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1107(X)
                              & p707(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1007(X)
                              & p707(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p907(X)
                              & p707(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p807(X)
                              & p707(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1107(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p607(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1007(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p607(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p907(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p607(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p807(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p607(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p707(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p607(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1107(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p507(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1007(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p507(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p907(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p507(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p807(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p507(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p707(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p507(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p607(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p507(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1107(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p407(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1007(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p407(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p907(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p407(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p807(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p407(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p707(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p407(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p607(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p407(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p507(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p407(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1107(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p307(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1007(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p307(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p907(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p307(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p807(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p307(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p707(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p307(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p607(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p307(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p507(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p307(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p407(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p307(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1107(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p207(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1007(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p207(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p907(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p207(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p807(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p207(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p707(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p207(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p607(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p207(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p507(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p207(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p407(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p207(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p307(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p207(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1107(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p107(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1007(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p107(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p907(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p107(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p807(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p107(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p707(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p107(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p607(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p107(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p507(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p107(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p407(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p107(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p307(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p107(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p207(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p107(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1106(X)
                              & p1006(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1106(X)
                              & p906(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1006(X)
                              & p906(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1106(X)
                              & p806(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1006(X)
                              & p806(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p906(X)
                              & p806(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1106(X)
                              & p706(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1006(X)
                              & p706(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p906(X)
                              & p706(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p806(X)
                              & p706(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1106(X)
                              & p606(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1006(X)
                              & p606(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p906(X)
                              & p606(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p806(X)
                              & p606(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p706(X)
                              & p606(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1106(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p506(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1006(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p506(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p906(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p506(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p806(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p506(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p706(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p506(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p606(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p506(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1106(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p406(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1006(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p406(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p906(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p406(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p806(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p406(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p706(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p406(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p606(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p406(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p506(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p406(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1106(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p306(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1006(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p306(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p906(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p306(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p806(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p306(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p706(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p306(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p606(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p306(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p506(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p306(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p406(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p306(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1106(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p206(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1006(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p206(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p906(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p206(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p806(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p206(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p706(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p206(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p606(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p206(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p506(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p206(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p406(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p206(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p306(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p206(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1106(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p106(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1006(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p106(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p906(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p106(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p806(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p106(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p706(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p106(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p606(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p106(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p506(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p106(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p406(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p106(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p306(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p106(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p206(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p106(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1105(X)
                              & p1005(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1105(X)
                              & p905(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1005(X)
                              & p905(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1105(X)
                              & p805(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1005(X)
                              & p805(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p905(X)
                              & p805(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1105(X)
                              & p705(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1005(X)
                              & p705(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p905(X)
                              & p705(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p805(X)
                              & p705(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1105(X)
                              & p605(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1005(X)
                              & p605(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p905(X)
                              & p605(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p805(X)
                              & p605(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p705(X)
                              & p605(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1105(X)
                              & p505(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1005(X)
                              & p505(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p905(X)
                              & p505(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p805(X)
                              & p505(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p705(X)
                              & p505(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p605(X)
                              & p505(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1105(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p405(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1005(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p405(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p905(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p405(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p805(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p405(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p705(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p405(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p605(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p405(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p505(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p405(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1105(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p305(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1005(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p305(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p905(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p305(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p805(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p305(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p705(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p305(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p605(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p305(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p505(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p305(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p405(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p305(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1105(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p205(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1005(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p205(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p905(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p205(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p805(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p205(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p705(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p205(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p605(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p205(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p505(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p205(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p405(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p205(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p305(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p205(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1105(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p105(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1005(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p105(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p905(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p105(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p805(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p105(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p705(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p105(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p605(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p105(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p505(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p105(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p405(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p105(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p305(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p105(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p205(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p105(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1104(X)
                              & p1004(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1104(X)
                              & p904(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1004(X)
                              & p904(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1104(X)
                              & p804(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1004(X)
                              & p804(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p904(X)
                              & p804(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1104(X)
                              & p704(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1004(X)
                              & p704(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p904(X)
                              & p704(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p804(X)
                              & p704(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1104(X)
                              & p604(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1004(X)
                              & p604(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p904(X)
                              & p604(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p804(X)
                              & p604(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p704(X)
                              & p604(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1104(X)
                              & p504(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1004(X)
                              & p504(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p904(X)
                              & p504(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p804(X)
                              & p504(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p704(X)
                              & p504(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p604(X)
                              & p504(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1104(X)
                              & p404(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1004(X)
                              & p404(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p904(X)
                              & p404(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p804(X)
                              & p404(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p704(X)
                              & p404(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p604(X)
                              & p404(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p504(X)
                              & p404(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1104(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p304(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1004(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p304(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p904(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p304(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p804(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p304(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p704(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p304(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p604(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p304(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p504(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p304(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p404(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p304(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1104(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p204(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1004(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p204(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p904(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p204(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p804(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p204(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p704(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p204(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p604(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p204(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p504(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p204(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p404(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p204(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p304(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p204(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1104(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p104(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1004(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p104(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p904(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p104(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p804(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p104(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p704(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p104(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p604(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p104(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p504(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p104(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p404(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p104(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p304(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p104(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p204(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p104(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1103(X)
                              & p1003(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1103(X)
                              & p903(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1003(X)
                              & p903(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1103(X)
                              & p803(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1003(X)
                              & p803(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p903(X)
                              & p803(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1103(X)
                              & p703(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1003(X)
                              & p703(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p903(X)
                              & p703(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p803(X)
                              & p703(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1103(X)
                              & p603(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1003(X)
                              & p603(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p903(X)
                              & p603(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p803(X)
                              & p603(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p703(X)
                              & p603(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1103(X)
                              & p503(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1003(X)
                              & p503(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p903(X)
                              & p503(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p803(X)
                              & p503(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p703(X)
                              & p503(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p603(X)
                              & p503(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1103(X)
                              & p403(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1003(X)
                              & p403(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p903(X)
                              & p403(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p803(X)
                              & p403(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p703(X)
                              & p403(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p603(X)
                              & p403(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p503(X)
                              & p403(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1103(X)
                              & p303(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1003(X)
                              & p303(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p903(X)
                              & p303(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p803(X)
                              & p303(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p703(X)
                              & p303(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p603(X)
                              & p303(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p503(X)
                              & p303(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p403(X)
                              & p303(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1103(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p203(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1003(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p203(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p903(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p203(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p803(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p203(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p703(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p203(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p603(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p203(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p503(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p203(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p403(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p203(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p303(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p203(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1103(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p103(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1003(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p103(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p903(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p103(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p803(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p103(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p703(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p103(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p603(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p103(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p503(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p103(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p403(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p103(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p303(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p103(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p203(Y) )
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p103(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1102(X)
                              & p1002(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1102(X)
                              & p902(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1002(X)
                              & p902(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1102(X)
                              & p802(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1002(X)
                              & p802(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p902(X)
                              & p802(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1102(X)
                              & p702(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1002(X)
                              & p702(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p902(X)
                              & p702(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p802(X)
                              & p702(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1102(X)
                              & p602(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1002(X)
                              & p602(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p902(X)
                              & p602(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p802(X)
                              & p602(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p702(X)
                              & p602(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1102(X)
                              & p502(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1002(X)
                              & p502(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p902(X)
                              & p502(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p802(X)
                              & p502(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p702(X)
                              & p502(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p602(X)
                              & p502(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1102(X)
                              & p402(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1002(X)
                              & p402(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p902(X)
                              & p402(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p802(X)
                              & p402(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p702(X)
                              & p402(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p602(X)
                              & p402(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p502(X)
                              & p402(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1102(X)
                              & p302(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1002(X)
                              & p302(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p902(X)
                              & p302(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p802(X)
                              & p302(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p702(X)
                              & p302(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p602(X)
                              & p302(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p502(X)
                              & p302(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p402(X)
                              & p302(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1102(X)
                              & p202(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1002(X)
                              & p202(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p902(X)
                              & p202(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p802(X)
                              & p202(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p702(X)
                              & p202(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p602(X)
                              & p202(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p502(X)
                              & p202(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p402(X)
                              & p202(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p302(X)
                              & p202(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1102(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p102(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1002(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p102(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p902(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p102(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p802(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p102(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p702(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p102(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p602(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p102(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p502(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p102(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p402(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p102(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p302(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p102(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p202(X)
                              & ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p102(Y) ) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1101(X)
                              & p1001(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1101(X)
                              & p901(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1001(X)
                              & p901(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1101(X)
                              & p801(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1001(X)
                              & p801(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p901(X)
                              & p801(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1101(X)
                              & p701(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1001(X)
                              & p701(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p901(X)
                              & p701(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p801(X)
                              & p701(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1101(X)
                              & p601(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1001(X)
                              & p601(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p901(X)
                              & p601(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p801(X)
                              & p601(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p701(X)
                              & p601(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1101(X)
                              & p501(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1001(X)
                              & p501(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p901(X)
                              & p501(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p801(X)
                              & p501(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p701(X)
                              & p501(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p601(X)
                              & p501(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1101(X)
                              & p401(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1001(X)
                              & p401(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p901(X)
                              & p401(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p801(X)
                              & p401(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p701(X)
                              & p401(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p601(X)
                              & p401(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p501(X)
                              & p401(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1101(X)
                              & p301(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1001(X)
                              & p301(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p901(X)
                              & p301(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p801(X)
                              & p301(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p701(X)
                              & p301(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p601(X)
                              & p301(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p501(X)
                              & p301(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p401(X)
                              & p301(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1101(X)
                              & p201(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1001(X)
                              & p201(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p901(X)
                              & p201(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p801(X)
                              & p201(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p701(X)
                              & p201(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p601(X)
                              & p201(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p501(X)
                              & p201(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p401(X)
                              & p201(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p301(X)
                              & p201(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1101(X)
                              & p101(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p1001(X)
                              & p101(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p901(X)
                              & p101(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p801(X)
                              & p101(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p701(X)
                              & p101(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p601(X)
                              & p101(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p501(X)
                              & p101(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p401(X)
                              & p101(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p301(X)
                              & p101(X) ) )
                    | ~ ! [X] :
                          ( ~ r1(Y,X)
                          | ~ ( p201(X)
                              & p101(X) ) ) ) )
          | ~ ( ( p1110(X)
                | p1109(X)
                | p1108(X)
                | p1107(X)
                | p1106(X)
                | p1105(X)
                | p1104(X)
                | p1103(X)
                | p1102(X)
                | p1101(X) )
              & ( p1010(X)
                | p1009(X)
                | p1008(X)
                | p1007(X)
                | p1006(X)
                | p1005(X)
                | p1004(X)
                | p1003(X)
                | p1002(X)
                | p1001(X) )
              & ( ! [Y] :
                    ( ~ r1(X,Y)
                    | p910(Y) )
                | p909(X)
                | p908(X)
                | p907(X)
                | p906(X)
                | p905(X)
                | p904(X)
                | p903(X)
                | p902(X)
                | p901(X) )
              & ( ! [Y] :
                    ( ~ r1(X,Y)
                    | p810(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p809(Y) )
                | p808(X)
                | p807(X)
                | p806(X)
                | p805(X)
                | p804(X)
                | p803(X)
                | p802(X)
                | p801(X) )
              & ( ! [Y] :
                    ( ~ r1(X,Y)
                    | p710(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p709(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p708(Y) )
                | p707(X)
                | p706(X)
                | p705(X)
                | p704(X)
                | p703(X)
                | p702(X)
                | p701(X) )
              & ( ! [Y] :
                    ( ~ r1(X,Y)
                    | p610(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p609(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p608(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p607(Y) )
                | p606(X)
                | p605(X)
                | p604(X)
                | p603(X)
                | p602(X)
                | p601(X) )
              & ( ! [Y] :
                    ( ~ r1(X,Y)
                    | p510(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p509(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p508(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p507(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p506(Y) )
                | p505(X)
                | p504(X)
                | p503(X)
                | p502(X)
                | p501(X) )
              & ( ! [Y] :
                    ( ~ r1(X,Y)
                    | p410(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p409(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p408(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p407(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p406(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p405(Y) )
                | p404(X)
                | p403(X)
                | p402(X)
                | p401(X) )
              & ( ! [Y] :
                    ( ~ r1(X,Y)
                    | p310(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p309(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p308(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p307(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p306(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p305(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p304(Y) )
                | p303(X)
                | p302(X)
                | p301(X) )
              & ( ! [Y] :
                    ( ~ r1(X,Y)
                    | p210(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p209(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p208(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p207(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p206(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p205(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p204(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p203(Y) )
                | p202(X)
                | p201(X) )
              & ( ! [Y] :
                    ( ~ r1(X,Y)
                    | p110(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p109(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p108(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p107(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p106(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p105(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p104(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p103(Y) )
                | ! [Y] :
                    ( ~ r1(X,Y)
                    | p102(Y) )
                | p101(X) ) ) ) ).

%------------------------------------------------------------------------------
