%------------------------------------------------------------------------------
% File     : LCL675+1.010 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Logic Calculi (Modal Logic)
% Problem  : In S4, the branching formula, size 10
% Version  : Especial.
% English  :

% Refs     : [BHS00] Balsiger et al. (2000), A Benchmark Method for the Pro
%          : [Kam08] Kaminski (2008), Email to G. Sutcliffe
% Source   : [Kam08]
% Names    : s4_branch_n [BHS00]

% Status   : CounterSatisfiable
% Rating   : 0.67 v9.1.0, 0.80 v9.0.0, 0.67 v6.4.0, 0.75 v6.3.0, 0.83 v6.2.0, 0.89 v6.1.0, 0.90 v6.0.0, 0.86 v5.4.0, 0.93 v5.3.0, 0.92 v5.2.0, 0.88 v5.0.0, 0.89 v4.1.0, 0.83 v4.0.1, 1.00 v4.0.0
% Syntax   : Number of formulae    :    3 (   1 unt;   0 def)
%            Number of atoms       :  228 (   0 equ)
%            Maximal formula atoms :  224 (  76 avg)
%            Number of connectives :  426 ( 201   ~; 119   |; 105   &)
%                                         (   0 <=>;   1  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   39 (  16 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of predicates  :   24 (  24 usr;   0 prp; 1-2 aty)
%            Number of functors    :    0 (   0 usr;   0 con; --- aty)
%            Number of variables   :   48 (  47   !;   1   ?)
% SPC      : FOF_CSA_RFO_NEQ

% Comments : A naive relational encoding of the modal logic problem into
%            first-order logic.
%------------------------------------------------------------------------------
fof(reflexivity,axiom,
    ! [X] : r1(X,X) ).

fof(transitivity,axiom,
    ! [X,Y,Z] :
      ( ( r1(X,Y)
        & r1(Y,Z) )
     => r1(X,Z) ) ).

fof(main,conjecture,
    ~ ? [X] :
        ( ! [Y] :
            ( ~ r1(X,Y)
            | ( ( ( ~ ! [X] :
                        ( ~ r1(Y,X)
                        | ~ ( ~ p11(X)
                            & ~ p111(X)
                            & p110(X) ) )
                  & ~ ! [X] :
                        ( ~ r1(Y,X)
                        | ~ ( p11(X)
                            & ~ p111(X)
                            & p110(X) ) ) )
                | ~ ( ~ p110(Y)
                    & p109(Y) ) )
              & ( ( ~ ! [X] :
                        ( ~ r1(Y,X)
                        | ~ ( ~ p10(X)
                            & ~ p110(X)
                            & p109(X) ) )
                  & ~ ! [X] :
                        ( ~ r1(Y,X)
                        | ~ ( p10(X)
                            & ~ p110(X)
                            & p109(X) ) ) )
                | ~ ( ~ p109(Y)
                    & p108(Y) ) )
              & ( ( ~ ! [X] :
                        ( ~ r1(Y,X)
                        | ~ ( ~ p9(X)
                            & ~ p109(X)
                            & p108(X) ) )
                  & ~ ! [X] :
                        ( ~ r1(Y,X)
                        | ~ ( p9(X)
                            & ~ p109(X)
                            & p108(X) ) ) )
                | ~ ( ~ p108(Y)
                    & p107(Y) ) )
              & ( ( ~ ! [X] :
                        ( ~ r1(Y,X)
                        | ~ ( ~ p8(X)
                            & ~ p108(X)
                            & p107(X) ) )
                  & ~ ! [X] :
                        ( ~ r1(Y,X)
                        | ~ ( p8(X)
                            & ~ p108(X)
                            & p107(X) ) ) )
                | ~ ( ~ p107(Y)
                    & p106(Y) ) )
              & ( ( ~ ! [X] :
                        ( ~ r1(Y,X)
                        | ~ ( ~ p7(X)
                            & ~ p107(X)
                            & p106(X) ) )
                  & ~ ! [X] :
                        ( ~ r1(Y,X)
                        | ~ ( p7(X)
                            & ~ p107(X)
                            & p106(X) ) ) )
                | ~ ( ~ p106(Y)
                    & p105(Y) ) )
              & ( ( ~ ! [X] :
                        ( ~ r1(Y,X)
                        | ~ ( ~ p6(X)
                            & ~ p106(X)
                            & p105(X) ) )
                  & ~ ! [X] :
                        ( ~ r1(Y,X)
                        | ~ ( p6(X)
                            & ~ p106(X)
                            & p105(X) ) ) )
                | ~ ( ~ p105(Y)
                    & p104(Y) ) )
              & ( ( ~ ! [X] :
                        ( ~ r1(Y,X)
                        | ~ ( ~ p5(X)
                            & ~ p105(X)
                            & p104(X) ) )
                  & ~ ! [X] :
                        ( ~ r1(Y,X)
                        | ~ ( p5(X)
                            & ~ p105(X)
                            & p104(X) ) ) )
                | ~ ( ~ p104(Y)
                    & p103(Y) ) )
              & ( ( ~ ! [X] :
                        ( ~ r1(Y,X)
                        | ~ ( ~ p4(X)
                            & ~ p104(X)
                            & p103(X) ) )
                  & ~ ! [X] :
                        ( ~ r1(Y,X)
                        | ~ ( p4(X)
                            & ~ p104(X)
                            & p103(X) ) ) )
                | ~ ( ~ p103(Y)
                    & p102(Y) ) )
              & ( ( ~ ! [X] :
                        ( ~ r1(Y,X)
                        | ~ ( ~ p3(X)
                            & ~ p103(X)
                            & p102(X) ) )
                  & ~ ! [X] :
                        ( ~ r1(Y,X)
                        | ~ ( p3(X)
                            & ~ p103(X)
                            & p102(X) ) ) )
                | ~ ( ~ p102(Y)
                    & p101(Y) ) )
              & ( ( ~ ! [X] :
                        ( ~ r1(Y,X)
                        | ~ ( ~ p2(X)
                            & ~ p102(X)
                            & p101(X) ) )
                  & ~ ! [X] :
                        ( ~ r1(Y,X)
                        | ~ ( p2(X)
                            & ~ p102(X)
                            & p101(X) ) ) )
                | ~ ( ~ p101(Y)
                    & p100(Y) ) )
              & ( ( ( ! [X] :
                        ( ~ r1(Y,X)
                        | ~ p11(X)
                        | ~ p110(X) )
                    | p11(Y) )
                  & ( ! [X] :
                        ( ~ r1(Y,X)
                        | p11(X)
                        | ~ p110(X) )
                    | ~ p11(Y) ) )
                | ~ p110(Y) )
              & ( ( ( ! [X] :
                        ( ~ r1(Y,X)
                        | ~ p10(X)
                        | ~ p109(X) )
                    | p10(Y) )
                  & ( ! [X] :
                        ( ~ r1(Y,X)
                        | p10(X)
                        | ~ p109(X) )
                    | ~ p10(Y) ) )
                | ~ p109(Y) )
              & ( ( ( ! [X] :
                        ( ~ r1(Y,X)
                        | ~ p9(X)
                        | ~ p108(X) )
                    | p9(Y) )
                  & ( ! [X] :
                        ( ~ r1(Y,X)
                        | p9(X)
                        | ~ p108(X) )
                    | ~ p9(Y) ) )
                | ~ p108(Y) )
              & ( ( ( ! [X] :
                        ( ~ r1(Y,X)
                        | ~ p8(X)
                        | ~ p107(X) )
                    | p8(Y) )
                  & ( ! [X] :
                        ( ~ r1(Y,X)
                        | p8(X)
                        | ~ p107(X) )
                    | ~ p8(Y) ) )
                | ~ p107(Y) )
              & ( ( ( ! [X] :
                        ( ~ r1(Y,X)
                        | ~ p7(X)
                        | ~ p106(X) )
                    | p7(Y) )
                  & ( ! [X] :
                        ( ~ r1(Y,X)
                        | p7(X)
                        | ~ p106(X) )
                    | ~ p7(Y) ) )
                | ~ p106(Y) )
              & ( ( ( ! [X] :
                        ( ~ r1(Y,X)
                        | ~ p6(X)
                        | ~ p105(X) )
                    | p6(Y) )
                  & ( ! [X] :
                        ( ~ r1(Y,X)
                        | p6(X)
                        | ~ p105(X) )
                    | ~ p6(Y) ) )
                | ~ p105(Y) )
              & ( ( ( ! [X] :
                        ( ~ r1(Y,X)
                        | ~ p5(X)
                        | ~ p104(X) )
                    | p5(Y) )
                  & ( ! [X] :
                        ( ~ r1(Y,X)
                        | p5(X)
                        | ~ p104(X) )
                    | ~ p5(Y) ) )
                | ~ p104(Y) )
              & ( ( ( ! [X] :
                        ( ~ r1(Y,X)
                        | ~ p4(X)
                        | ~ p103(X) )
                    | p4(Y) )
                  & ( ! [X] :
                        ( ~ r1(Y,X)
                        | p4(X)
                        | ~ p103(X) )
                    | ~ p4(Y) ) )
                | ~ p103(Y) )
              & ( ( ( ! [X] :
                        ( ~ r1(Y,X)
                        | ~ p3(X)
                        | ~ p102(X) )
                    | p3(Y) )
                  & ( ! [X] :
                        ( ~ r1(Y,X)
                        | p3(X)
                        | ~ p102(X) )
                    | ~ p3(Y) ) )
                | ~ p102(Y) )
              & ( ( ( ! [X] :
                        ( ~ r1(Y,X)
                        | ~ p2(X)
                        | ~ p101(X) )
                    | p2(Y) )
                  & ( ! [X] :
                        ( ~ r1(Y,X)
                        | p2(X)
                        | ~ p101(X) )
                    | ~ p2(Y) ) )
                | ~ p101(Y) )
              & ( ( ( ! [X] :
                        ( ~ r1(Y,X)
                        | ~ p1(X)
                        | ~ p100(X) )
                    | p1(Y) )
                  & ( ! [X] :
                        ( ~ r1(Y,X)
                        | p1(X)
                        | ~ p100(X) )
                    | ~ p1(Y) ) )
                | ~ p100(Y) )
              & ( p110(Y)
                | ~ p111(Y) )
              & ( p109(Y)
                | ~ p110(Y) )
              & ( p108(Y)
                | ~ p109(Y) )
              & ( p107(Y)
                | ~ p108(Y) )
              & ( p106(Y)
                | ~ p107(Y) )
              & ( p105(Y)
                | ~ p106(Y) )
              & ( p104(Y)
                | ~ p105(Y) )
              & ( p103(Y)
                | ~ p104(Y) )
              & ( p102(Y)
                | ~ p103(Y) )
              & ( p101(Y)
                | ~ p102(Y) )
              & ( p100(Y)
                | ~ p101(Y) ) ) )
        & ~ p101(X)
        & p100(X) ) ).

%------------------------------------------------------------------------------
