%------------------------------------------------------------------------------
% File     : LCL672+1.005 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Logic Calculi (Modal Logic)
% Problem  : In S4, A5{box p0/p0} & box A5{~p0/p0} -> A5, size 5
% Version  : Especial.
% English  :

% Refs     : [BHS00] Balsiger et al. (2000), A Benchmark Method for the Pro
%          : [Kam08] Kaminski (2008), Email to G. Sutcliffe
% Source   : [Kam08]
% Names    : s4_45_p [BHS00]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.40 v9.0.0, 0.19 v8.2.0, 0.33 v8.1.0, 0.43 v7.5.0, 0.48 v7.4.0, 0.31 v7.3.0, 0.43 v7.2.0, 0.33 v7.1.0, 0.50 v7.0.0, 0.21 v6.3.0, 0.31 v6.2.0, 0.36 v6.1.0, 0.48 v6.0.0, 0.25 v5.5.0, 0.67 v5.4.0, 0.61 v5.3.0, 0.65 v5.2.0, 0.57 v5.1.0, 0.64 v5.0.0, 0.75 v4.1.0, 0.78 v4.0.1, 0.79 v4.0.0
% Syntax   : Number of formulae    :    3 (   1 unt;   0 def)
%            Number of atoms       :  549 (   0 equ)
%            Maximal formula atoms :  545 ( 183 avg)
%            Number of connectives : 1178 ( 632   ~; 409   |; 136   &)
%                                         (   0 <=>;   1  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   63 (  24 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of predicates  :    4 (   3 usr;   1 prp; 0-2 aty)
%            Number of functors    :    0 (   0 usr;   0 con; --- aty)
%            Number of variables   :  335 ( 334   !;   1   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : A naive relational encoding of the modal logic problem into
%            first-order logic.
%------------------------------------------------------------------------------
fof(reflexivity,axiom,
    ! [X] : r1(X,X) ).

fof(transitivity,axiom,
    ! [X,Y,Z] :
      ( ( r1(X,Y)
        & r1(Y,Z) )
     => r1(X,Z) ) ).

fof(main,conjecture,
    ~ ? [X] :
        ~ ( ( ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p2(Y) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | ~ ( ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p2(X) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | ~ ( ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | p2(Y) )
                                & ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | ~ ( ~ ! [X] :
                                                ( ~ r1(Y,X)
                                                | p2(X) )
                                          & ~ ! [X] :
                                                ( ~ r1(Y,X)
                                                | ~ ( ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | p2(Y) )
                                                    & ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ ( ~ ! [X] :
                                                                    ( ~ r1(Y,X)
                                                                    | ~ ! [Y] :
                                                                          ( ~ r1(X,Y)
                                                                          | ~ p1(Y) ) )
                                                              & p1(Y) ) )
                                                    & ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | p1(Y) ) ) )
                                          & ~ ! [X] :
                                                ( ~ r1(Y,X)
                                                | p1(X) ) ) )
                                & ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | p1(Y) ) ) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p1(X) ) ) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p1(Y) ) )
          | ( ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p2(Y) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | ~ ( ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p2(X) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | ~ ( ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | p2(Y) )
                                & ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | ~ ( ~ ! [X] :
                                                ( ~ r1(Y,X)
                                                | p2(X) )
                                          & ~ ! [X] :
                                                ( ~ r1(Y,X)
                                                | ~ ( ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | p2(Y) )
                                                    & ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ ( ~ ! [Y] :
                                                                        ( ~ r1(X,Y)
                                                                        | ~ ! [X] :
                                                                              ( ~ r1(Y,X)
                                                                              | p1(X) ) )
                                                                  & ~ ! [Y] :
                                                                        ( ~ r1(X,Y)
                                                                        | p1(Y) ) ) ) )
                                                    & ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | p1(Y) ) ) )
                                          & ~ ! [X] :
                                                ( ~ r1(Y,X)
                                                | p1(X) ) ) )
                                & ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | p1(Y) ) ) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p1(X) ) ) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p1(Y) ) )
          | ( ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p2(Y) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | ~ ( ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p2(X) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | ~ ( ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | p2(Y) )
                                & ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | ~ ( ~ ! [X] :
                                                ( ~ r1(Y,X)
                                                | p2(X) )
                                          & ~ ! [X] :
                                                ( ~ r1(Y,X)
                                                | ~ ( ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | p2(Y) )
                                                    & ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ ( ~ ! [X] :
                                                                    ( ~ r1(Y,X)
                                                                    | ~ ! [Y] :
                                                                          ( ~ r1(X,Y)
                                                                          | ~ ! [X] :
                                                                                ( ~ r1(Y,X)
                                                                                | p1(X) ) ) )
                                                              & ~ ! [X] :
                                                                    ( ~ r1(Y,X)
                                                                    | ~ ! [Y] :
                                                                          ( ~ r1(X,Y)
                                                                          | p1(Y) ) ) ) )
                                                    & ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | p1(Y) ) ) )
                                          & ~ ! [X] :
                                                ( ~ r1(Y,X)
                                                | p1(X) ) ) )
                                & ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | p1(Y) ) ) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p1(X) ) ) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p1(Y) ) )
          | ( ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p2(Y) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | ~ ( ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p2(X) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | ~ ( ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | p2(Y) )
                                & ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | ~ ( ~ ! [X] :
                                                ( ~ r1(Y,X)
                                                | p2(X) )
                                          & ~ ! [X] :
                                                ( ~ r1(Y,X)
                                                | ~ ( ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | p2(Y) )
                                                    & ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ ! [X] :
                                                                ( ~ r1(Y,X)
                                                                | $false ) )
                                                    & ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | p1(Y) ) ) )
                                          & ~ ! [X] :
                                                ( ~ r1(Y,X)
                                                | p1(X) ) ) )
                                & ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | p1(Y) ) ) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p1(X) ) ) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p1(Y) ) )
          | ! [Y] :
              ( ~ r1(X,Y)
              | p2(Y) )
          | ! [Y] :
              ( ~ r1(X,Y)
              | ! [X] :
                  ( ~ r1(Y,X)
                  | p2(X) )
              | ! [X] :
                  ( ~ r1(Y,X)
                  | ! [Y] :
                      ( ~ r1(X,Y)
                      | p2(Y) )
                  | ! [Y] :
                      ( ~ r1(X,Y)
                      | ! [X] :
                          ( ~ r1(Y,X)
                          | p2(X) )
                      | ! [X] :
                          ( ~ r1(Y,X)
                          | ! [Y] :
                              ( ~ r1(X,Y)
                              | p2(Y) )
                          | ! [Y] :
                              ( ~ r1(X,Y)
                              | ! [X] :
                                  ( ~ r1(Y,X)
                                  | ~ ! [Y] :
                                        ( ~ r1(X,Y)
                                        | p1(Y) ) )
                              | ! [X] :
                                  ( ~ r1(Y,X)
                                  | p1(X) ) )
                          | ! [Y] :
                              ( ~ r1(X,Y)
                              | p1(Y) ) )
                      | ! [X] :
                          ( ~ r1(Y,X)
                          | p1(X) ) )
                  | ! [Y] :
                      ( ~ r1(X,Y)
                      | p1(Y) ) )
              | ! [X] :
                  ( ~ r1(Y,X)
                  | p1(X) ) )
          | ! [Y] :
              ( ~ r1(X,Y)
              | p1(Y) )
          | ( ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p2(Y) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | ~ ( ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p2(X) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | ~ ( ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | p2(Y) )
                                & ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | ~ ( ~ ! [X] :
                                                ( ~ r1(Y,X)
                                                | p2(X) )
                                          & ~ ! [X] :
                                                ( ~ r1(Y,X)
                                                | ~ ( ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ ! [X] :
                                                                ( ~ r1(Y,X)
                                                                | ~ p1(X) ) )
                                                    & p1(X) ) )
                                          & ~ ! [X] :
                                                ( ~ r1(Y,X)
                                                | p1(X) ) ) )
                                & ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | p1(Y) ) ) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p1(X) ) ) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p1(Y) ) )
          | ( ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p2(Y) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | ~ ( ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p2(X) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | ~ ( ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | p2(Y) )
                                & ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | ~ ( ~ ! [X] :
                                                ( ~ r1(Y,X)
                                                | p2(X) )
                                          & ~ ! [X] :
                                                ( ~ r1(Y,X)
                                                | ! [Y] :
                                                    ( ~ r1(X,Y)
                                                    | ~ ( ~ ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ ! [Y] :
                                                                    ( ~ r1(X,Y)
                                                                    | p1(Y) ) )
                                                        & ~ ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | p1(X) ) ) ) )
                                          & ~ ! [X] :
                                                ( ~ r1(Y,X)
                                                | p1(X) ) ) )
                                & ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | p1(Y) ) ) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p1(X) ) ) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p1(Y) ) )
          | ( ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p2(Y) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | ~ ( ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p2(X) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | ~ ( ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | p2(Y) )
                                & ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | ~ ( ~ ! [X] :
                                                ( ~ r1(Y,X)
                                                | p2(X) )
                                          & ~ ! [X] :
                                                ( ~ r1(Y,X)
                                                | ~ ( ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ ! [X] :
                                                                ( ~ r1(Y,X)
                                                                | ~ ! [Y] :
                                                                      ( ~ r1(X,Y)
                                                                      | p1(Y) ) ) )
                                                    & ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ ! [X] :
                                                                ( ~ r1(Y,X)
                                                                | p1(X) ) ) ) )
                                          & ~ ! [X] :
                                                ( ~ r1(Y,X)
                                                | p1(X) ) ) )
                                & ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | p1(Y) ) ) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p1(X) ) ) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p1(Y) ) )
          | ( ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p2(Y) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | ~ ( ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p2(X) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | ~ ( ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | p2(Y) )
                                & ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | ~ ( ~ ! [X] :
                                                ( ~ r1(Y,X)
                                                | p2(X) )
                                          & ~ ! [X] :
                                                ( ~ r1(Y,X)
                                                | ~ ! [Y] :
                                                      ( ~ r1(X,Y)
                                                      | $false ) )
                                          & ~ ! [X] :
                                                ( ~ r1(Y,X)
                                                | p1(X) ) ) )
                                & ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | p1(Y) ) ) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p1(X) ) ) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p1(Y) ) )
          | ! [Y] :
              ( ~ r1(X,Y)
              | p2(Y) )
          | ! [Y] :
              ( ~ r1(X,Y)
              | ! [X] :
                  ( ~ r1(Y,X)
                  | p2(X) )
              | ! [X] :
                  ( ~ r1(Y,X)
                  | ! [Y] :
                      ( ~ r1(X,Y)
                      | p2(Y) )
                  | ! [Y] :
                      ( ~ r1(X,Y)
                      | ! [X] :
                          ( ~ r1(Y,X)
                          | p2(X) )
                      | ! [X] :
                          ( ~ r1(Y,X)
                          | ! [Y] :
                              ( ~ r1(X,Y)
                              | p2(Y) )
                          | ! [Y] :
                              ( ~ r1(X,Y)
                              | ! [X] :
                                  ( ~ r1(Y,X)
                                  | ~ ! [Y] :
                                        ( ~ r1(X,Y)
                                        | p1(Y) ) )
                              | ! [X] :
                                  ( ~ r1(Y,X)
                                  | p1(X) ) )
                          | ! [Y] :
                              ( ~ r1(X,Y)
                              | p1(Y) ) )
                      | ! [X] :
                          ( ~ r1(Y,X)
                          | p1(X) ) )
                  | ! [Y] :
                      ( ~ r1(X,Y)
                      | p1(Y) ) )
              | ! [X] :
                  ( ~ r1(Y,X)
                  | p1(X) ) )
          | ! [Y] :
              ( ~ r1(X,Y)
              | p1(Y) )
          | ( ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p2(Y) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | ~ ( ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p2(X) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | ~ ( ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | p2(Y) )
                                & ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | ~ ( ~ ! [X] :
                                                ( ~ r1(Y,X)
                                                | ~ ! [Y] :
                                                      ( ~ r1(X,Y)
                                                      | ~ p1(Y) ) )
                                          & p1(Y) ) )
                                & ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | p1(Y) ) ) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p1(X) ) ) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p1(Y) ) )
          | ( ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p2(Y) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | ~ ( ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p2(X) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | ~ ( ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | p2(Y) )
                                & ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | ! [X] :
                                          ( ~ r1(Y,X)
                                          | ~ ( ~ ! [Y] :
                                                    ( ~ r1(X,Y)
                                                    | ~ ! [X] :
                                                          ( ~ r1(Y,X)
                                                          | p1(X) ) )
                                              & ~ ! [Y] :
                                                    ( ~ r1(X,Y)
                                                    | p1(Y) ) ) ) )
                                & ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | p1(Y) ) ) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p1(X) ) ) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p1(Y) ) )
          | ( ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p2(Y) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | ~ ( ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p2(X) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | ~ ( ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | p2(Y) )
                                & ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | ~ ( ~ ! [X] :
                                                ( ~ r1(Y,X)
                                                | ~ ! [Y] :
                                                      ( ~ r1(X,Y)
                                                      | ~ ! [X] :
                                                            ( ~ r1(Y,X)
                                                            | p1(X) ) ) )
                                          & ~ ! [X] :
                                                ( ~ r1(Y,X)
                                                | ~ ! [Y] :
                                                      ( ~ r1(X,Y)
                                                      | p1(Y) ) ) ) )
                                & ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | p1(Y) ) ) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p1(X) ) ) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p1(Y) ) )
          | ( ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p2(Y) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | ~ ( ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p2(X) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | ~ ( ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | p2(Y) )
                                & ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | ~ ! [X] :
                                            ( ~ r1(Y,X)
                                            | $false ) )
                                & ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | p1(Y) ) ) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p1(X) ) ) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p1(Y) ) )
          | ! [Y] :
              ( ~ r1(X,Y)
              | p2(Y) )
          | ! [Y] :
              ( ~ r1(X,Y)
              | ! [X] :
                  ( ~ r1(Y,X)
                  | p2(X) )
              | ! [X] :
                  ( ~ r1(Y,X)
                  | ! [Y] :
                      ( ~ r1(X,Y)
                      | p2(Y) )
                  | ! [Y] :
                      ( ~ r1(X,Y)
                      | ! [X] :
                          ( ~ r1(Y,X)
                          | p2(X) )
                      | ! [X] :
                          ( ~ r1(Y,X)
                          | ! [Y] :
                              ( ~ r1(X,Y)
                              | p2(Y) )
                          | ! [Y] :
                              ( ~ r1(X,Y)
                              | ! [X] :
                                  ( ~ r1(Y,X)
                                  | ~ ! [Y] :
                                        ( ~ r1(X,Y)
                                        | p1(Y) ) )
                              | ! [X] :
                                  ( ~ r1(Y,X)
                                  | p1(X) ) )
                          | ! [Y] :
                              ( ~ r1(X,Y)
                              | p1(Y) ) )
                      | ! [X] :
                          ( ~ r1(Y,X)
                          | p1(X) ) )
                  | ! [Y] :
                      ( ~ r1(X,Y)
                      | p1(Y) ) )
              | ! [X] :
                  ( ~ r1(Y,X)
                  | p1(X) ) )
          | ! [Y] :
              ( ~ r1(X,Y)
              | p1(Y) )
          | ( ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p2(Y) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | ~ ( ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p2(X) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | ~ ( ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | ~ ! [X] :
                                            ( ~ r1(Y,X)
                                            | ~ p1(X) ) )
                                & p1(X) ) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p1(X) ) ) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p1(Y) ) )
          | ( ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p2(Y) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | ~ ( ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p2(X) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | ! [Y] :
                                ( ~ r1(X,Y)
                                | ~ ( ~ ! [X] :
                                          ( ~ r1(Y,X)
                                          | ~ ! [Y] :
                                                ( ~ r1(X,Y)
                                                | p1(Y) ) )
                                    & ~ ! [X] :
                                          ( ~ r1(Y,X)
                                          | p1(X) ) ) ) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p1(X) ) ) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p1(Y) ) )
          | ( ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p2(Y) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | ~ ( ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p2(X) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | ~ ( ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | ~ ! [X] :
                                            ( ~ r1(Y,X)
                                            | ~ ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | p1(Y) ) ) )
                                & ~ ! [Y] :
                                      ( ~ r1(X,Y)
                                      | ~ ! [X] :
                                            ( ~ r1(Y,X)
                                            | p1(X) ) ) ) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p1(X) ) ) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p1(Y) ) )
          | ( ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p2(Y) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | ~ ( ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p2(X) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | ~ ! [Y] :
                                  ( ~ r1(X,Y)
                                  | $false ) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | p1(X) ) ) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p1(Y) ) )
          | ! [Y] :
              ( ~ r1(X,Y)
              | p2(Y) )
          | ! [Y] :
              ( ~ r1(X,Y)
              | ! [X] :
                  ( ~ r1(Y,X)
                  | p2(X) )
              | ! [X] :
                  ( ~ r1(Y,X)
                  | ! [Y] :
                      ( ~ r1(X,Y)
                      | p2(Y) )
                  | ! [Y] :
                      ( ~ r1(X,Y)
                      | ! [X] :
                          ( ~ r1(Y,X)
                          | p2(X) )
                      | ! [X] :
                          ( ~ r1(Y,X)
                          | ! [Y] :
                              ( ~ r1(X,Y)
                              | p2(Y) )
                          | ! [Y] :
                              ( ~ r1(X,Y)
                              | ! [X] :
                                  ( ~ r1(Y,X)
                                  | ~ ! [Y] :
                                        ( ~ r1(X,Y)
                                        | p1(Y) ) )
                              | ! [X] :
                                  ( ~ r1(Y,X)
                                  | p1(X) ) )
                          | ! [Y] :
                              ( ~ r1(X,Y)
                              | p1(Y) ) )
                      | ! [X] :
                          ( ~ r1(Y,X)
                          | p1(X) ) )
                  | ! [Y] :
                      ( ~ r1(X,Y)
                      | p1(Y) ) )
              | ! [X] :
                  ( ~ r1(Y,X)
                  | p1(X) ) )
          | ! [Y] :
              ( ~ r1(X,Y)
              | p1(Y) )
          | ( ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p2(Y) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | ~ ( ~ ! [X] :
                            ( ~ r1(Y,X)
                            | ~ ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ p1(Y) ) )
                      & p1(Y) ) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p1(Y) ) )
          | ( ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p2(Y) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | ! [X] :
                      ( ~ r1(Y,X)
                      | ~ ( ~ ! [Y] :
                                ( ~ r1(X,Y)
                                | ~ ! [X] :
                                      ( ~ r1(Y,X)
                                      | p1(X) ) )
                          & ~ ! [Y] :
                                ( ~ r1(X,Y)
                                | p1(Y) ) ) ) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p1(Y) ) )
          | ( ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p2(Y) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | ~ ( ~ ! [X] :
                            ( ~ r1(Y,X)
                            | ~ ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ ! [X] :
                                        ( ~ r1(Y,X)
                                        | p1(X) ) ) )
                      & ~ ! [X] :
                            ( ~ r1(Y,X)
                            | ~ ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p1(Y) ) ) ) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p1(Y) ) )
          | ( ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p2(Y) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | ~ ! [X] :
                        ( ~ r1(Y,X)
                        | $false ) )
            & ~ ! [Y] :
                  ( ~ r1(X,Y)
                  | p1(Y) ) )
          | ! [Y] :
              ( ~ r1(X,Y)
              | p2(Y) )
          | ! [Y] :
              ( ~ r1(X,Y)
              | ! [X] :
                  ( ~ r1(Y,X)
                  | p2(X) )
              | ! [X] :
                  ( ~ r1(Y,X)
                  | ! [Y] :
                      ( ~ r1(X,Y)
                      | p2(Y) )
                  | ! [Y] :
                      ( ~ r1(X,Y)
                      | ! [X] :
                          ( ~ r1(Y,X)
                          | p2(X) )
                      | ! [X] :
                          ( ~ r1(Y,X)
                          | ! [Y] :
                              ( ~ r1(X,Y)
                              | p2(Y) )
                          | ! [Y] :
                              ( ~ r1(X,Y)
                              | ! [X] :
                                  ( ~ r1(Y,X)
                                  | ~ ! [Y] :
                                        ( ~ r1(X,Y)
                                        | p1(Y) ) )
                              | ! [X] :
                                  ( ~ r1(Y,X)
                                  | p1(X) ) )
                          | ! [Y] :
                              ( ~ r1(X,Y)
                              | p1(Y) ) )
                      | ! [X] :
                          ( ~ r1(Y,X)
                          | p1(X) ) )
                  | ! [Y] :
                      ( ~ r1(X,Y)
                      | p1(Y) ) )
              | ! [X] :
                  ( ~ r1(Y,X)
                  | p1(X) ) )
          | ! [Y] :
              ( ~ r1(X,Y)
              | p1(Y) ) ) ).

%------------------------------------------------------------------------------
