%------------------------------------------------------------------------------
% File     : LCL636+1.010 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Logic Calculi (Modal Logic)
% Problem  : In K, the branching formula made provable, size 10
% Version  : Especial.
% English  : The branching formula plus a negation symbol in front and an
%            additional subformula to make the formula provable.

% Refs     : [BHS00] Balsiger et al. (2000), A Benchmark Method for the Pro
%          : [Kam08] Kaminski (2008), Email to G. Sutcliffe
% Source   : [Kam08]
% Names    : k_branch_p [BHS00]

% Status   : Theorem
% Rating   : 0.90 v9.1.0, 0.87 v9.0.0, 0.88 v8.2.0, 1.00 v8.1.0, 0.86 v7.5.0, 0.95 v7.4.0, 0.94 v7.3.0, 0.86 v7.2.0, 0.83 v7.1.0, 0.75 v7.0.0, 0.86 v6.4.0, 0.93 v6.3.0, 0.92 v6.2.0, 0.91 v6.1.0, 1.00 v6.0.0, 0.75 v5.5.0, 1.00 v5.2.0, 0.93 v5.0.0, 0.95 v4.1.0, 1.00 v4.0.0
% Syntax   : Number of formulae    :    1 (   0 unt;   0 def)
%            Number of atoms       : 2499 (   0 equ)
%            Maximal formula atoms : 2499 (2499 avg)
%            Number of connectives : 4746 (2248   ~;1364   |;1134   &)
%                                         (   0 <=>;   0  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   60 (  60 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of predicates  :   24 (  24 usr;   0 prp; 1-2 aty)
%            Number of functors    :    0 (   0 usr;   0 con; --- aty)
%            Number of variables   :  528 ( 527   !;   1   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : A naive relational encoding of the modal logic problem into
%            first-order logic.
%------------------------------------------------------------------------------
fof(main,conjecture,
    ~ ? [X] :
        ~ ( ~ ! [Y] :
                ( ~ r1(X,Y)
                | ! [X] :
                    ( ~ r1(Y,X)
                    | ! [Y] :
                        ( ~ r1(X,Y)
                        | ! [X] :
                            ( ~ r1(Y,X)
                            | ! [Y] :
                                ( ~ r1(X,Y)
                                | ! [X] :
                                    ( ~ r1(Y,X)
                                    | ! [Y] :
                                        ( ~ r1(X,Y)
                                        | ! [X] :
                                            ( ~ r1(Y,X)
                                            | ! [Y] :
                                                ( ~ r1(X,Y)
                                                | ! [X] :
                                                    ( ~ r1(Y,X)
                                                    | p5(X) ) ) ) ) ) ) ) ) ) )
          | ~ ( ! [Y] :
                  ( ~ r1(X,Y)
                  | ! [X] :
                      ( ~ r1(Y,X)
                      | ! [Y] :
                          ( ~ r1(X,Y)
                          | ! [X] :
                              ( ~ r1(Y,X)
                              | ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ! [X] :
                                      ( ~ r1(Y,X)
                                      | ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ! [X] :
                                              ( ~ r1(Y,X)
                                              | ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ( ( ( ~ ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ ( ~ p11(Y)
                                                                      & ~ p111(Y)
                                                                      & p110(Y) ) )
                                                            & ~ ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ ( p11(Y)
                                                                      & ~ p111(Y)
                                                                      & p110(Y) ) ) )
                                                          | ~ ( ~ p110(X)
                                                              & p109(X) ) )
                                                        & ( ( ~ ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ ( ~ p10(Y)
                                                                      & ~ p110(Y)
                                                                      & p109(Y) ) )
                                                            & ~ ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ ( p10(Y)
                                                                      & ~ p110(Y)
                                                                      & p109(Y) ) ) )
                                                          | ~ ( ~ p109(X)
                                                              & p108(X) ) )
                                                        & ( ( ~ ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ ( ~ p9(Y)
                                                                      & ~ p109(Y)
                                                                      & p108(Y) ) )
                                                            & ~ ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ ( p9(Y)
                                                                      & ~ p109(Y)
                                                                      & p108(Y) ) ) )
                                                          | ~ ( ~ p108(X)
                                                              & p107(X) ) )
                                                        & ( ( ~ ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ ( ~ p8(Y)
                                                                      & ~ p108(Y)
                                                                      & p107(Y) ) )
                                                            & ~ ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ ( p8(Y)
                                                                      & ~ p108(Y)
                                                                      & p107(Y) ) ) )
                                                          | ~ ( ~ p107(X)
                                                              & p106(X) ) )
                                                        & ( ( ~ ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ ( ~ p7(Y)
                                                                      & ~ p107(Y)
                                                                      & p106(Y) ) )
                                                            & ~ ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ ( p7(Y)
                                                                      & ~ p107(Y)
                                                                      & p106(Y) ) ) )
                                                          | ~ ( ~ p106(X)
                                                              & p105(X) ) )
                                                        & ( ( ~ ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ ( ~ p6(Y)
                                                                      & ~ p106(Y)
                                                                      & p105(Y) ) )
                                                            & ~ ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ ( p6(Y)
                                                                      & ~ p106(Y)
                                                                      & p105(Y) ) ) )
                                                          | ~ ( ~ p105(X)
                                                              & p104(X) ) )
                                                        & ( ( ~ ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ ( ~ p5(Y)
                                                                      & ~ p105(Y)
                                                                      & p104(Y) ) )
                                                            & ~ ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ ( p5(Y)
                                                                      & ~ p105(Y)
                                                                      & p104(Y) ) ) )
                                                          | ~ ( ~ p104(X)
                                                              & p103(X) ) )
                                                        & ( ( ~ ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ ( ~ p4(Y)
                                                                      & ~ p104(Y)
                                                                      & p103(Y) ) )
                                                            & ~ ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ ( p4(Y)
                                                                      & ~ p104(Y)
                                                                      & p103(Y) ) ) )
                                                          | ~ ( ~ p103(X)
                                                              & p102(X) ) )
                                                        & ( ( ~ ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ ( ~ p3(Y)
                                                                      & ~ p103(Y)
                                                                      & p102(Y) ) )
                                                            & ~ ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ ( p3(Y)
                                                                      & ~ p103(Y)
                                                                      & p102(Y) ) ) )
                                                          | ~ ( ~ p102(X)
                                                              & p101(X) ) )
                                                        & ( ( ~ ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ ( ~ p2(Y)
                                                                      & ~ p102(Y)
                                                                      & p101(Y) ) )
                                                            & ~ ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ ( p2(Y)
                                                                      & ~ p102(Y)
                                                                      & p101(Y) ) ) )
                                                          | ~ ( ~ p101(X)
                                                              & p100(X) ) )
                                                        & ( ( ( ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ p11(Y)
                                                                  | ~ p110(Y) )
                                                              | p11(X) )
                                                            & ( ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | p11(Y)
                                                                  | ~ p110(Y) )
                                                              | ~ p11(X) ) )
                                                          | ~ p110(X) )
                                                        & ( ( ( ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ p10(Y)
                                                                  | ~ p109(Y) )
                                                              | p10(X) )
                                                            & ( ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | p10(Y)
                                                                  | ~ p109(Y) )
                                                              | ~ p10(X) ) )
                                                          | ~ p109(X) )
                                                        & ( ( ( ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ p9(Y)
                                                                  | ~ p108(Y) )
                                                              | p9(X) )
                                                            & ( ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | p9(Y)
                                                                  | ~ p108(Y) )
                                                              | ~ p9(X) ) )
                                                          | ~ p108(X) )
                                                        & ( ( ( ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ p8(Y)
                                                                  | ~ p107(Y) )
                                                              | p8(X) )
                                                            & ( ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | p8(Y)
                                                                  | ~ p107(Y) )
                                                              | ~ p8(X) ) )
                                                          | ~ p107(X) )
                                                        & ( ( ( ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ p7(Y)
                                                                  | ~ p106(Y) )
                                                              | p7(X) )
                                                            & ( ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | p7(Y)
                                                                  | ~ p106(Y) )
                                                              | ~ p7(X) ) )
                                                          | ~ p106(X) )
                                                        & ( ( ( ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ p6(Y)
                                                                  | ~ p105(Y) )
                                                              | p6(X) )
                                                            & ( ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | p6(Y)
                                                                  | ~ p105(Y) )
                                                              | ~ p6(X) ) )
                                                          | ~ p105(X) )
                                                        & ( ( ( ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ p5(Y)
                                                                  | ~ p104(Y) )
                                                              | p5(X) )
                                                            & ( ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | p5(Y)
                                                                  | ~ p104(Y) )
                                                              | ~ p5(X) ) )
                                                          | ~ p104(X) )
                                                        & ( ( ( ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ p4(Y)
                                                                  | ~ p103(Y) )
                                                              | p4(X) )
                                                            & ( ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | p4(Y)
                                                                  | ~ p103(Y) )
                                                              | ~ p4(X) ) )
                                                          | ~ p103(X) )
                                                        & ( ( ( ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ p3(Y)
                                                                  | ~ p102(Y) )
                                                              | p3(X) )
                                                            & ( ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | p3(Y)
                                                                  | ~ p102(Y) )
                                                              | ~ p3(X) ) )
                                                          | ~ p102(X) )
                                                        & ( ( ( ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ p2(Y)
                                                                  | ~ p101(Y) )
                                                              | p2(X) )
                                                            & ( ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | p2(Y)
                                                                  | ~ p101(Y) )
                                                              | ~ p2(X) ) )
                                                          | ~ p101(X) )
                                                        & ( ( ( ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | ~ p1(Y)
                                                                  | ~ p100(Y) )
                                                              | p1(X) )
                                                            & ( ! [Y] :
                                                                  ( ~ r1(X,Y)
                                                                  | p1(Y)
                                                                  | ~ p100(Y) )
                                                              | ~ p1(X) ) )
                                                          | ~ p100(X) )
                                                        & ( p110(X)
                                                          | ~ p111(X) )
                                                        & ( p109(X)
                                                          | ~ p110(X) )
                                                        & ( p108(X)
                                                          | ~ p109(X) )
                                                        & ( p107(X)
                                                          | ~ p108(X) )
                                                        & ( p106(X)
                                                          | ~ p107(X) )
                                                        & ( p105(X)
                                                          | ~ p106(X) )
                                                        & ( p104(X)
                                                          | ~ p105(X) )
                                                        & ( p103(X)
                                                          | ~ p104(X) )
                                                        & ( p102(X)
                                                          | ~ p103(X) )
                                                        & ( p101(X)
                                                          | ~ p102(X) )
                                                        & ( p100(X)
                                                          | ~ p101(X) ) ) ) ) ) ) ) ) ) ) ) )
              & ! [Y] :
                  ( ~ r1(X,Y)
                  | ! [X] :
                      ( ~ r1(Y,X)
                      | ! [Y] :
                          ( ~ r1(X,Y)
                          | ! [X] :
                              ( ~ r1(Y,X)
                              | ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ! [X] :
                                      ( ~ r1(Y,X)
                                      | ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ! [X] :
                                              ( ~ r1(Y,X)
                                              | ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ( ( ( ~ ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ ( ~ p11(X)
                                                                  & ~ p111(X)
                                                                  & p110(X) ) )
                                                        & ~ ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ ( p11(X)
                                                                  & ~ p111(X)
                                                                  & p110(X) ) ) )
                                                      | ~ ( ~ p110(Y)
                                                          & p109(Y) ) )
                                                    & ( ( ~ ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ ( ~ p10(X)
                                                                  & ~ p110(X)
                                                                  & p109(X) ) )
                                                        & ~ ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ ( p10(X)
                                                                  & ~ p110(X)
                                                                  & p109(X) ) ) )
                                                      | ~ ( ~ p109(Y)
                                                          & p108(Y) ) )
                                                    & ( ( ~ ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ ( ~ p9(X)
                                                                  & ~ p109(X)
                                                                  & p108(X) ) )
                                                        & ~ ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ ( p9(X)
                                                                  & ~ p109(X)
                                                                  & p108(X) ) ) )
                                                      | ~ ( ~ p108(Y)
                                                          & p107(Y) ) )
                                                    & ( ( ~ ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ ( ~ p8(X)
                                                                  & ~ p108(X)
                                                                  & p107(X) ) )
                                                        & ~ ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ ( p8(X)
                                                                  & ~ p108(X)
                                                                  & p107(X) ) ) )
                                                      | ~ ( ~ p107(Y)
                                                          & p106(Y) ) )
                                                    & ( ( ~ ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ ( ~ p7(X)
                                                                  & ~ p107(X)
                                                                  & p106(X) ) )
                                                        & ~ ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ ( p7(X)
                                                                  & ~ p107(X)
                                                                  & p106(X) ) ) )
                                                      | ~ ( ~ p106(Y)
                                                          & p105(Y) ) )
                                                    & ( ( ~ ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ ( ~ p6(X)
                                                                  & ~ p106(X)
                                                                  & p105(X) ) )
                                                        & ~ ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ ( p6(X)
                                                                  & ~ p106(X)
                                                                  & p105(X) ) ) )
                                                      | ~ ( ~ p105(Y)
                                                          & p104(Y) ) )
                                                    & ( ( ~ ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ ( ~ p5(X)
                                                                  & ~ p105(X)
                                                                  & p104(X) ) )
                                                        & ~ ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ ( p5(X)
                                                                  & ~ p105(X)
                                                                  & p104(X) ) ) )
                                                      | ~ ( ~ p104(Y)
                                                          & p103(Y) ) )
                                                    & ( ( ~ ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ ( ~ p4(X)
                                                                  & ~ p104(X)
                                                                  & p103(X) ) )
                                                        & ~ ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ ( p4(X)
                                                                  & ~ p104(X)
                                                                  & p103(X) ) ) )
                                                      | ~ ( ~ p103(Y)
                                                          & p102(Y) ) )
                                                    & ( ( ~ ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ ( ~ p3(X)
                                                                  & ~ p103(X)
                                                                  & p102(X) ) )
                                                        & ~ ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ ( p3(X)
                                                                  & ~ p103(X)
                                                                  & p102(X) ) ) )
                                                      | ~ ( ~ p102(Y)
                                                          & p101(Y) ) )
                                                    & ( ( ~ ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ ( ~ p2(X)
                                                                  & ~ p102(X)
                                                                  & p101(X) ) )
                                                        & ~ ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ ( p2(X)
                                                                  & ~ p102(X)
                                                                  & p101(X) ) ) )
                                                      | ~ ( ~ p101(Y)
                                                          & p100(Y) ) )
                                                    & ( ( ( ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ p11(X)
                                                              | ~ p110(X) )
                                                          | p11(Y) )
                                                        & ( ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | p11(X)
                                                              | ~ p110(X) )
                                                          | ~ p11(Y) ) )
                                                      | ~ p110(Y) )
                                                    & ( ( ( ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ p10(X)
                                                              | ~ p109(X) )
                                                          | p10(Y) )
                                                        & ( ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | p10(X)
                                                              | ~ p109(X) )
                                                          | ~ p10(Y) ) )
                                                      | ~ p109(Y) )
                                                    & ( ( ( ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ p9(X)
                                                              | ~ p108(X) )
                                                          | p9(Y) )
                                                        & ( ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | p9(X)
                                                              | ~ p108(X) )
                                                          | ~ p9(Y) ) )
                                                      | ~ p108(Y) )
                                                    & ( ( ( ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ p8(X)
                                                              | ~ p107(X) )
                                                          | p8(Y) )
                                                        & ( ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | p8(X)
                                                              | ~ p107(X) )
                                                          | ~ p8(Y) ) )
                                                      | ~ p107(Y) )
                                                    & ( ( ( ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ p7(X)
                                                              | ~ p106(X) )
                                                          | p7(Y) )
                                                        & ( ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | p7(X)
                                                              | ~ p106(X) )
                                                          | ~ p7(Y) ) )
                                                      | ~ p106(Y) )
                                                    & ( ( ( ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ p6(X)
                                                              | ~ p105(X) )
                                                          | p6(Y) )
                                                        & ( ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | p6(X)
                                                              | ~ p105(X) )
                                                          | ~ p6(Y) ) )
                                                      | ~ p105(Y) )
                                                    & ( ( ( ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ p5(X)
                                                              | ~ p104(X) )
                                                          | p5(Y) )
                                                        & ( ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | p5(X)
                                                              | ~ p104(X) )
                                                          | ~ p5(Y) ) )
                                                      | ~ p104(Y) )
                                                    & ( ( ( ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ p4(X)
                                                              | ~ p103(X) )
                                                          | p4(Y) )
                                                        & ( ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | p4(X)
                                                              | ~ p103(X) )
                                                          | ~ p4(Y) ) )
                                                      | ~ p103(Y) )
                                                    & ( ( ( ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ p3(X)
                                                              | ~ p102(X) )
                                                          | p3(Y) )
                                                        & ( ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | p3(X)
                                                              | ~ p102(X) )
                                                          | ~ p3(Y) ) )
                                                      | ~ p102(Y) )
                                                    & ( ( ( ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ p2(X)
                                                              | ~ p101(X) )
                                                          | p2(Y) )
                                                        & ( ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | p2(X)
                                                              | ~ p101(X) )
                                                          | ~ p2(Y) ) )
                                                      | ~ p101(Y) )
                                                    & ( ( ( ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | ~ p1(X)
                                                              | ~ p100(X) )
                                                          | p1(Y) )
                                                        & ( ! [X] :
                                                              ( ~ r1(Y,X)
                                                              | p1(X)
                                                              | ~ p100(X) )
                                                          | ~ p1(Y) ) )
                                                      | ~ p100(Y) )
                                                    & ( p110(Y)
                                                      | ~ p111(Y) )
                                                    & ( p109(Y)
                                                      | ~ p110(Y) )
                                                    & ( p108(Y)
                                                      | ~ p109(Y) )
                                                    & ( p107(Y)
                                                      | ~ p108(Y) )
                                                    & ( p106(Y)
                                                      | ~ p107(Y) )
                                                    & ( p105(Y)
                                                      | ~ p106(Y) )
                                                    & ( p104(Y)
                                                      | ~ p105(Y) )
                                                    & ( p103(Y)
                                                      | ~ p104(Y) )
                                                    & ( p102(Y)
                                                      | ~ p103(Y) )
                                                    & ( p101(Y)
                                                      | ~ p102(Y) )
                                                    & ( p100(Y)
                                                      | ~ p101(Y) ) ) ) ) ) ) ) ) ) ) )
              & ! [Y] :
                  ( ~ r1(X,Y)
                  | ! [X] :
                      ( ~ r1(Y,X)
                      | ! [Y] :
                          ( ~ r1(X,Y)
                          | ! [X] :
                              ( ~ r1(Y,X)
                              | ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ! [X] :
                                      ( ~ r1(Y,X)
                                      | ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ! [X] :
                                              ( ~ r1(Y,X)
                                              | ( ( ( ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ ( ~ p11(Y)
                                                              & ~ p111(Y)
                                                              & p110(Y) ) )
                                                    & ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ ( p11(Y)
                                                              & ~ p111(Y)
                                                              & p110(Y) ) ) )
                                                  | ~ ( ~ p110(X)
                                                      & p109(X) ) )
                                                & ( ( ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ ( ~ p10(Y)
                                                              & ~ p110(Y)
                                                              & p109(Y) ) )
                                                    & ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ ( p10(Y)
                                                              & ~ p110(Y)
                                                              & p109(Y) ) ) )
                                                  | ~ ( ~ p109(X)
                                                      & p108(X) ) )
                                                & ( ( ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ ( ~ p9(Y)
                                                              & ~ p109(Y)
                                                              & p108(Y) ) )
                                                    & ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ ( p9(Y)
                                                              & ~ p109(Y)
                                                              & p108(Y) ) ) )
                                                  | ~ ( ~ p108(X)
                                                      & p107(X) ) )
                                                & ( ( ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ ( ~ p8(Y)
                                                              & ~ p108(Y)
                                                              & p107(Y) ) )
                                                    & ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ ( p8(Y)
                                                              & ~ p108(Y)
                                                              & p107(Y) ) ) )
                                                  | ~ ( ~ p107(X)
                                                      & p106(X) ) )
                                                & ( ( ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ ( ~ p7(Y)
                                                              & ~ p107(Y)
                                                              & p106(Y) ) )
                                                    & ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ ( p7(Y)
                                                              & ~ p107(Y)
                                                              & p106(Y) ) ) )
                                                  | ~ ( ~ p106(X)
                                                      & p105(X) ) )
                                                & ( ( ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ ( ~ p6(Y)
                                                              & ~ p106(Y)
                                                              & p105(Y) ) )
                                                    & ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ ( p6(Y)
                                                              & ~ p106(Y)
                                                              & p105(Y) ) ) )
                                                  | ~ ( ~ p105(X)
                                                      & p104(X) ) )
                                                & ( ( ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ ( ~ p5(Y)
                                                              & ~ p105(Y)
                                                              & p104(Y) ) )
                                                    & ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ ( p5(Y)
                                                              & ~ p105(Y)
                                                              & p104(Y) ) ) )
                                                  | ~ ( ~ p104(X)
                                                      & p103(X) ) )
                                                & ( ( ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ ( ~ p4(Y)
                                                              & ~ p104(Y)
                                                              & p103(Y) ) )
                                                    & ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ ( p4(Y)
                                                              & ~ p104(Y)
                                                              & p103(Y) ) ) )
                                                  | ~ ( ~ p103(X)
                                                      & p102(X) ) )
                                                & ( ( ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ ( ~ p3(Y)
                                                              & ~ p103(Y)
                                                              & p102(Y) ) )
                                                    & ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ ( p3(Y)
                                                              & ~ p103(Y)
                                                              & p102(Y) ) ) )
                                                  | ~ ( ~ p102(X)
                                                      & p101(X) ) )
                                                & ( ( ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ ( ~ p2(Y)
                                                              & ~ p102(Y)
                                                              & p101(Y) ) )
                                                    & ~ ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ ( p2(Y)
                                                              & ~ p102(Y)
                                                              & p101(Y) ) ) )
                                                  | ~ ( ~ p101(X)
                                                      & p100(X) ) )
                                                & ( ( ( ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ p11(Y)
                                                          | ~ p110(Y) )
                                                      | p11(X) )
                                                    & ( ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | p11(Y)
                                                          | ~ p110(Y) )
                                                      | ~ p11(X) ) )
                                                  | ~ p110(X) )
                                                & ( ( ( ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ p10(Y)
                                                          | ~ p109(Y) )
                                                      | p10(X) )
                                                    & ( ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | p10(Y)
                                                          | ~ p109(Y) )
                                                      | ~ p10(X) ) )
                                                  | ~ p109(X) )
                                                & ( ( ( ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ p9(Y)
                                                          | ~ p108(Y) )
                                                      | p9(X) )
                                                    & ( ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | p9(Y)
                                                          | ~ p108(Y) )
                                                      | ~ p9(X) ) )
                                                  | ~ p108(X) )
                                                & ( ( ( ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ p8(Y)
                                                          | ~ p107(Y) )
                                                      | p8(X) )
                                                    & ( ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | p8(Y)
                                                          | ~ p107(Y) )
                                                      | ~ p8(X) ) )
                                                  | ~ p107(X) )
                                                & ( ( ( ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ p7(Y)
                                                          | ~ p106(Y) )
                                                      | p7(X) )
                                                    & ( ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | p7(Y)
                                                          | ~ p106(Y) )
                                                      | ~ p7(X) ) )
                                                  | ~ p106(X) )
                                                & ( ( ( ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ p6(Y)
                                                          | ~ p105(Y) )
                                                      | p6(X) )
                                                    & ( ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | p6(Y)
                                                          | ~ p105(Y) )
                                                      | ~ p6(X) ) )
                                                  | ~ p105(X) )
                                                & ( ( ( ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ p5(Y)
                                                          | ~ p104(Y) )
                                                      | p5(X) )
                                                    & ( ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | p5(Y)
                                                          | ~ p104(Y) )
                                                      | ~ p5(X) ) )
                                                  | ~ p104(X) )
                                                & ( ( ( ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ p4(Y)
                                                          | ~ p103(Y) )
                                                      | p4(X) )
                                                    & ( ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | p4(Y)
                                                          | ~ p103(Y) )
                                                      | ~ p4(X) ) )
                                                  | ~ p103(X) )
                                                & ( ( ( ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ p3(Y)
                                                          | ~ p102(Y) )
                                                      | p3(X) )
                                                    & ( ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | p3(Y)
                                                          | ~ p102(Y) )
                                                      | ~ p3(X) ) )
                                                  | ~ p102(X) )
                                                & ( ( ( ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ p2(Y)
                                                          | ~ p101(Y) )
                                                      | p2(X) )
                                                    & ( ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | p2(Y)
                                                          | ~ p101(Y) )
                                                      | ~ p2(X) ) )
                                                  | ~ p101(X) )
                                                & ( ( ( ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | ~ p1(Y)
                                                          | ~ p100(Y) )
                                                      | p1(X) )
                                                    & ( ! [Y] :
                                                          ( ~ r1(X,Y)
                                                          | p1(Y)
                                                          | ~ p100(Y) )
                                                      | ~ p1(X) ) )
                                                  | ~ p100(X) )
                                                & ( p110(X)
                                                  | ~ p111(X) )
                                                & ( p109(X)
                                                  | ~ p110(X) )
                                                & ( p108(X)
                                                  | ~ p109(X) )
                                                & ( p107(X)
                                                  | ~ p108(X) )
                                                & ( p106(X)
                                                  | ~ p107(X) )
                                                & ( p105(X)
                                                  | ~ p106(X) )
                                                & ( p104(X)
                                                  | ~ p105(X) )
                                                & ( p103(X)
                                                  | ~ p104(X) )
                                                & ( p102(X)
                                                  | ~ p103(X) )
                                                & ( p101(X)
                                                  | ~ p102(X) )
                                                & ( p100(X)
                                                  | ~ p101(X) ) ) ) ) ) ) ) ) ) )
              & ! [Y] :
                  ( ~ r1(X,Y)
                  | ! [X] :
                      ( ~ r1(Y,X)
                      | ! [Y] :
                          ( ~ r1(X,Y)
                          | ! [X] :
                              ( ~ r1(Y,X)
                              | ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ! [X] :
                                      ( ~ r1(Y,X)
                                      | ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ( ( ( ~ ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ ( ~ p11(X)
                                                          & ~ p111(X)
                                                          & p110(X) ) )
                                                & ~ ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ ( p11(X)
                                                          & ~ p111(X)
                                                          & p110(X) ) ) )
                                              | ~ ( ~ p110(Y)
                                                  & p109(Y) ) )
                                            & ( ( ~ ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ ( ~ p10(X)
                                                          & ~ p110(X)
                                                          & p109(X) ) )
                                                & ~ ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ ( p10(X)
                                                          & ~ p110(X)
                                                          & p109(X) ) ) )
                                              | ~ ( ~ p109(Y)
                                                  & p108(Y) ) )
                                            & ( ( ~ ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ ( ~ p9(X)
                                                          & ~ p109(X)
                                                          & p108(X) ) )
                                                & ~ ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ ( p9(X)
                                                          & ~ p109(X)
                                                          & p108(X) ) ) )
                                              | ~ ( ~ p108(Y)
                                                  & p107(Y) ) )
                                            & ( ( ~ ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ ( ~ p8(X)
                                                          & ~ p108(X)
                                                          & p107(X) ) )
                                                & ~ ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ ( p8(X)
                                                          & ~ p108(X)
                                                          & p107(X) ) ) )
                                              | ~ ( ~ p107(Y)
                                                  & p106(Y) ) )
                                            & ( ( ~ ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ ( ~ p7(X)
                                                          & ~ p107(X)
                                                          & p106(X) ) )
                                                & ~ ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ ( p7(X)
                                                          & ~ p107(X)
                                                          & p106(X) ) ) )
                                              | ~ ( ~ p106(Y)
                                                  & p105(Y) ) )
                                            & ( ( ~ ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ ( ~ p6(X)
                                                          & ~ p106(X)
                                                          & p105(X) ) )
                                                & ~ ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ ( p6(X)
                                                          & ~ p106(X)
                                                          & p105(X) ) ) )
                                              | ~ ( ~ p105(Y)
                                                  & p104(Y) ) )
                                            & ( ( ~ ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ ( ~ p5(X)
                                                          & ~ p105(X)
                                                          & p104(X) ) )
                                                & ~ ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ ( p5(X)
                                                          & ~ p105(X)
                                                          & p104(X) ) ) )
                                              | ~ ( ~ p104(Y)
                                                  & p103(Y) ) )
                                            & ( ( ~ ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ ( ~ p4(X)
                                                          & ~ p104(X)
                                                          & p103(X) ) )
                                                & ~ ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ ( p4(X)
                                                          & ~ p104(X)
                                                          & p103(X) ) ) )
                                              | ~ ( ~ p103(Y)
                                                  & p102(Y) ) )
                                            & ( ( ~ ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ ( ~ p3(X)
                                                          & ~ p103(X)
                                                          & p102(X) ) )
                                                & ~ ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ ( p3(X)
                                                          & ~ p103(X)
                                                          & p102(X) ) ) )
                                              | ~ ( ~ p102(Y)
                                                  & p101(Y) ) )
                                            & ( ( ~ ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ ( ~ p2(X)
                                                          & ~ p102(X)
                                                          & p101(X) ) )
                                                & ~ ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ ( p2(X)
                                                          & ~ p102(X)
                                                          & p101(X) ) ) )
                                              | ~ ( ~ p101(Y)
                                                  & p100(Y) ) )
                                            & ( ( ( ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ p11(X)
                                                      | ~ p110(X) )
                                                  | p11(Y) )
                                                & ( ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | p11(X)
                                                      | ~ p110(X) )
                                                  | ~ p11(Y) ) )
                                              | ~ p110(Y) )
                                            & ( ( ( ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ p10(X)
                                                      | ~ p109(X) )
                                                  | p10(Y) )
                                                & ( ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | p10(X)
                                                      | ~ p109(X) )
                                                  | ~ p10(Y) ) )
                                              | ~ p109(Y) )
                                            & ( ( ( ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ p9(X)
                                                      | ~ p108(X) )
                                                  | p9(Y) )
                                                & ( ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | p9(X)
                                                      | ~ p108(X) )
                                                  | ~ p9(Y) ) )
                                              | ~ p108(Y) )
                                            & ( ( ( ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ p8(X)
                                                      | ~ p107(X) )
                                                  | p8(Y) )
                                                & ( ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | p8(X)
                                                      | ~ p107(X) )
                                                  | ~ p8(Y) ) )
                                              | ~ p107(Y) )
                                            & ( ( ( ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ p7(X)
                                                      | ~ p106(X) )
                                                  | p7(Y) )
                                                & ( ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | p7(X)
                                                      | ~ p106(X) )
                                                  | ~ p7(Y) ) )
                                              | ~ p106(Y) )
                                            & ( ( ( ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ p6(X)
                                                      | ~ p105(X) )
                                                  | p6(Y) )
                                                & ( ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | p6(X)
                                                      | ~ p105(X) )
                                                  | ~ p6(Y) ) )
                                              | ~ p105(Y) )
                                            & ( ( ( ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ p5(X)
                                                      | ~ p104(X) )
                                                  | p5(Y) )
                                                & ( ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | p5(X)
                                                      | ~ p104(X) )
                                                  | ~ p5(Y) ) )
                                              | ~ p104(Y) )
                                            & ( ( ( ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ p4(X)
                                                      | ~ p103(X) )
                                                  | p4(Y) )
                                                & ( ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | p4(X)
                                                      | ~ p103(X) )
                                                  | ~ p4(Y) ) )
                                              | ~ p103(Y) )
                                            & ( ( ( ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ p3(X)
                                                      | ~ p102(X) )
                                                  | p3(Y) )
                                                & ( ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | p3(X)
                                                      | ~ p102(X) )
                                                  | ~ p3(Y) ) )
                                              | ~ p102(Y) )
                                            & ( ( ( ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ p2(X)
                                                      | ~ p101(X) )
                                                  | p2(Y) )
                                                & ( ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | p2(X)
                                                      | ~ p101(X) )
                                                  | ~ p2(Y) ) )
                                              | ~ p101(Y) )
                                            & ( ( ( ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | ~ p1(X)
                                                      | ~ p100(X) )
                                                  | p1(Y) )
                                                & ( ! [X] :
                                                      ( ~ r1(Y,X)
                                                      | p1(X)
                                                      | ~ p100(X) )
                                                  | ~ p1(Y) ) )
                                              | ~ p100(Y) )
                                            & ( p110(Y)
                                              | ~ p111(Y) )
                                            & ( p109(Y)
                                              | ~ p110(Y) )
                                            & ( p108(Y)
                                              | ~ p109(Y) )
                                            & ( p107(Y)
                                              | ~ p108(Y) )
                                            & ( p106(Y)
                                              | ~ p107(Y) )
                                            & ( p105(Y)
                                              | ~ p106(Y) )
                                            & ( p104(Y)
                                              | ~ p105(Y) )
                                            & ( p103(Y)
                                              | ~ p104(Y) )
                                            & ( p102(Y)
                                              | ~ p103(Y) )
                                            & ( p101(Y)
                                              | ~ p102(Y) )
                                            & ( p100(Y)
                                              | ~ p101(Y) ) ) ) ) ) ) ) ) )
              & ! [Y] :
                  ( ~ r1(X,Y)
                  | ! [X] :
                      ( ~ r1(Y,X)
                      | ! [Y] :
                          ( ~ r1(X,Y)
                          | ! [X] :
                              ( ~ r1(Y,X)
                              | ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ! [X] :
                                      ( ~ r1(Y,X)
                                      | ( ( ( ~ ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ ( ~ p11(Y)
                                                      & ~ p111(Y)
                                                      & p110(Y) ) )
                                            & ~ ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ ( p11(Y)
                                                      & ~ p111(Y)
                                                      & p110(Y) ) ) )
                                          | ~ ( ~ p110(X)
                                              & p109(X) ) )
                                        & ( ( ~ ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ ( ~ p10(Y)
                                                      & ~ p110(Y)
                                                      & p109(Y) ) )
                                            & ~ ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ ( p10(Y)
                                                      & ~ p110(Y)
                                                      & p109(Y) ) ) )
                                          | ~ ( ~ p109(X)
                                              & p108(X) ) )
                                        & ( ( ~ ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ ( ~ p9(Y)
                                                      & ~ p109(Y)
                                                      & p108(Y) ) )
                                            & ~ ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ ( p9(Y)
                                                      & ~ p109(Y)
                                                      & p108(Y) ) ) )
                                          | ~ ( ~ p108(X)
                                              & p107(X) ) )
                                        & ( ( ~ ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ ( ~ p8(Y)
                                                      & ~ p108(Y)
                                                      & p107(Y) ) )
                                            & ~ ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ ( p8(Y)
                                                      & ~ p108(Y)
                                                      & p107(Y) ) ) )
                                          | ~ ( ~ p107(X)
                                              & p106(X) ) )
                                        & ( ( ~ ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ ( ~ p7(Y)
                                                      & ~ p107(Y)
                                                      & p106(Y) ) )
                                            & ~ ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ ( p7(Y)
                                                      & ~ p107(Y)
                                                      & p106(Y) ) ) )
                                          | ~ ( ~ p106(X)
                                              & p105(X) ) )
                                        & ( ( ~ ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ ( ~ p6(Y)
                                                      & ~ p106(Y)
                                                      & p105(Y) ) )
                                            & ~ ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ ( p6(Y)
                                                      & ~ p106(Y)
                                                      & p105(Y) ) ) )
                                          | ~ ( ~ p105(X)
                                              & p104(X) ) )
                                        & ( ( ~ ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ ( ~ p5(Y)
                                                      & ~ p105(Y)
                                                      & p104(Y) ) )
                                            & ~ ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ ( p5(Y)
                                                      & ~ p105(Y)
                                                      & p104(Y) ) ) )
                                          | ~ ( ~ p104(X)
                                              & p103(X) ) )
                                        & ( ( ~ ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ ( ~ p4(Y)
                                                      & ~ p104(Y)
                                                      & p103(Y) ) )
                                            & ~ ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ ( p4(Y)
                                                      & ~ p104(Y)
                                                      & p103(Y) ) ) )
                                          | ~ ( ~ p103(X)
                                              & p102(X) ) )
                                        & ( ( ~ ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ ( ~ p3(Y)
                                                      & ~ p103(Y)
                                                      & p102(Y) ) )
                                            & ~ ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ ( p3(Y)
                                                      & ~ p103(Y)
                                                      & p102(Y) ) ) )
                                          | ~ ( ~ p102(X)
                                              & p101(X) ) )
                                        & ( ( ~ ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ ( ~ p2(Y)
                                                      & ~ p102(Y)
                                                      & p101(Y) ) )
                                            & ~ ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ ( p2(Y)
                                                      & ~ p102(Y)
                                                      & p101(Y) ) ) )
                                          | ~ ( ~ p101(X)
                                              & p100(X) ) )
                                        & ( ( ( ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ p11(Y)
                                                  | ~ p110(Y) )
                                              | p11(X) )
                                            & ( ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | p11(Y)
                                                  | ~ p110(Y) )
                                              | ~ p11(X) ) )
                                          | ~ p110(X) )
                                        & ( ( ( ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ p10(Y)
                                                  | ~ p109(Y) )
                                              | p10(X) )
                                            & ( ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | p10(Y)
                                                  | ~ p109(Y) )
                                              | ~ p10(X) ) )
                                          | ~ p109(X) )
                                        & ( ( ( ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ p9(Y)
                                                  | ~ p108(Y) )
                                              | p9(X) )
                                            & ( ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | p9(Y)
                                                  | ~ p108(Y) )
                                              | ~ p9(X) ) )
                                          | ~ p108(X) )
                                        & ( ( ( ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ p8(Y)
                                                  | ~ p107(Y) )
                                              | p8(X) )
                                            & ( ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | p8(Y)
                                                  | ~ p107(Y) )
                                              | ~ p8(X) ) )
                                          | ~ p107(X) )
                                        & ( ( ( ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ p7(Y)
                                                  | ~ p106(Y) )
                                              | p7(X) )
                                            & ( ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | p7(Y)
                                                  | ~ p106(Y) )
                                              | ~ p7(X) ) )
                                          | ~ p106(X) )
                                        & ( ( ( ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ p6(Y)
                                                  | ~ p105(Y) )
                                              | p6(X) )
                                            & ( ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | p6(Y)
                                                  | ~ p105(Y) )
                                              | ~ p6(X) ) )
                                          | ~ p105(X) )
                                        & ( ( ( ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ p5(Y)
                                                  | ~ p104(Y) )
                                              | p5(X) )
                                            & ( ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | p5(Y)
                                                  | ~ p104(Y) )
                                              | ~ p5(X) ) )
                                          | ~ p104(X) )
                                        & ( ( ( ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ p4(Y)
                                                  | ~ p103(Y) )
                                              | p4(X) )
                                            & ( ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | p4(Y)
                                                  | ~ p103(Y) )
                                              | ~ p4(X) ) )
                                          | ~ p103(X) )
                                        & ( ( ( ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ p3(Y)
                                                  | ~ p102(Y) )
                                              | p3(X) )
                                            & ( ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | p3(Y)
                                                  | ~ p102(Y) )
                                              | ~ p3(X) ) )
                                          | ~ p102(X) )
                                        & ( ( ( ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ p2(Y)
                                                  | ~ p101(Y) )
                                              | p2(X) )
                                            & ( ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | p2(Y)
                                                  | ~ p101(Y) )
                                              | ~ p2(X) ) )
                                          | ~ p101(X) )
                                        & ( ( ( ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | ~ p1(Y)
                                                  | ~ p100(Y) )
                                              | p1(X) )
                                            & ( ! [Y] :
                                                  ( ~ r1(X,Y)
                                                  | p1(Y)
                                                  | ~ p100(Y) )
                                              | ~ p1(X) ) )
                                          | ~ p100(X) )
                                        & ( p110(X)
                                          | ~ p111(X) )
                                        & ( p109(X)
                                          | ~ p110(X) )
                                        & ( p108(X)
                                          | ~ p109(X) )
                                        & ( p107(X)
                                          | ~ p108(X) )
                                        & ( p106(X)
                                          | ~ p107(X) )
                                        & ( p105(X)
                                          | ~ p106(X) )
                                        & ( p104(X)
                                          | ~ p105(X) )
                                        & ( p103(X)
                                          | ~ p104(X) )
                                        & ( p102(X)
                                          | ~ p103(X) )
                                        & ( p101(X)
                                          | ~ p102(X) )
                                        & ( p100(X)
                                          | ~ p101(X) ) ) ) ) ) ) ) )
              & ! [Y] :
                  ( ~ r1(X,Y)
                  | ! [X] :
                      ( ~ r1(Y,X)
                      | ! [Y] :
                          ( ~ r1(X,Y)
                          | ! [X] :
                              ( ~ r1(Y,X)
                              | ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ( ( ( ~ ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ ( ~ p11(X)
                                                  & ~ p111(X)
                                                  & p110(X) ) )
                                        & ~ ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ ( p11(X)
                                                  & ~ p111(X)
                                                  & p110(X) ) ) )
                                      | ~ ( ~ p110(Y)
                                          & p109(Y) ) )
                                    & ( ( ~ ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ ( ~ p10(X)
                                                  & ~ p110(X)
                                                  & p109(X) ) )
                                        & ~ ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ ( p10(X)
                                                  & ~ p110(X)
                                                  & p109(X) ) ) )
                                      | ~ ( ~ p109(Y)
                                          & p108(Y) ) )
                                    & ( ( ~ ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ ( ~ p9(X)
                                                  & ~ p109(X)
                                                  & p108(X) ) )
                                        & ~ ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ ( p9(X)
                                                  & ~ p109(X)
                                                  & p108(X) ) ) )
                                      | ~ ( ~ p108(Y)
                                          & p107(Y) ) )
                                    & ( ( ~ ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ ( ~ p8(X)
                                                  & ~ p108(X)
                                                  & p107(X) ) )
                                        & ~ ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ ( p8(X)
                                                  & ~ p108(X)
                                                  & p107(X) ) ) )
                                      | ~ ( ~ p107(Y)
                                          & p106(Y) ) )
                                    & ( ( ~ ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ ( ~ p7(X)
                                                  & ~ p107(X)
                                                  & p106(X) ) )
                                        & ~ ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ ( p7(X)
                                                  & ~ p107(X)
                                                  & p106(X) ) ) )
                                      | ~ ( ~ p106(Y)
                                          & p105(Y) ) )
                                    & ( ( ~ ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ ( ~ p6(X)
                                                  & ~ p106(X)
                                                  & p105(X) ) )
                                        & ~ ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ ( p6(X)
                                                  & ~ p106(X)
                                                  & p105(X) ) ) )
                                      | ~ ( ~ p105(Y)
                                          & p104(Y) ) )
                                    & ( ( ~ ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ ( ~ p5(X)
                                                  & ~ p105(X)
                                                  & p104(X) ) )
                                        & ~ ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ ( p5(X)
                                                  & ~ p105(X)
                                                  & p104(X) ) ) )
                                      | ~ ( ~ p104(Y)
                                          & p103(Y) ) )
                                    & ( ( ~ ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ ( ~ p4(X)
                                                  & ~ p104(X)
                                                  & p103(X) ) )
                                        & ~ ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ ( p4(X)
                                                  & ~ p104(X)
                                                  & p103(X) ) ) )
                                      | ~ ( ~ p103(Y)
                                          & p102(Y) ) )
                                    & ( ( ~ ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ ( ~ p3(X)
                                                  & ~ p103(X)
                                                  & p102(X) ) )
                                        & ~ ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ ( p3(X)
                                                  & ~ p103(X)
                                                  & p102(X) ) ) )
                                      | ~ ( ~ p102(Y)
                                          & p101(Y) ) )
                                    & ( ( ~ ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ ( ~ p2(X)
                                                  & ~ p102(X)
                                                  & p101(X) ) )
                                        & ~ ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ ( p2(X)
                                                  & ~ p102(X)
                                                  & p101(X) ) ) )
                                      | ~ ( ~ p101(Y)
                                          & p100(Y) ) )
                                    & ( ( ( ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ p11(X)
                                              | ~ p110(X) )
                                          | p11(Y) )
                                        & ( ! [X] :
                                              ( ~ r1(Y,X)
                                              | p11(X)
                                              | ~ p110(X) )
                                          | ~ p11(Y) ) )
                                      | ~ p110(Y) )
                                    & ( ( ( ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ p10(X)
                                              | ~ p109(X) )
                                          | p10(Y) )
                                        & ( ! [X] :
                                              ( ~ r1(Y,X)
                                              | p10(X)
                                              | ~ p109(X) )
                                          | ~ p10(Y) ) )
                                      | ~ p109(Y) )
                                    & ( ( ( ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ p9(X)
                                              | ~ p108(X) )
                                          | p9(Y) )
                                        & ( ! [X] :
                                              ( ~ r1(Y,X)
                                              | p9(X)
                                              | ~ p108(X) )
                                          | ~ p9(Y) ) )
                                      | ~ p108(Y) )
                                    & ( ( ( ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ p8(X)
                                              | ~ p107(X) )
                                          | p8(Y) )
                                        & ( ! [X] :
                                              ( ~ r1(Y,X)
                                              | p8(X)
                                              | ~ p107(X) )
                                          | ~ p8(Y) ) )
                                      | ~ p107(Y) )
                                    & ( ( ( ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ p7(X)
                                              | ~ p106(X) )
                                          | p7(Y) )
                                        & ( ! [X] :
                                              ( ~ r1(Y,X)
                                              | p7(X)
                                              | ~ p106(X) )
                                          | ~ p7(Y) ) )
                                      | ~ p106(Y) )
                                    & ( ( ( ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ p6(X)
                                              | ~ p105(X) )
                                          | p6(Y) )
                                        & ( ! [X] :
                                              ( ~ r1(Y,X)
                                              | p6(X)
                                              | ~ p105(X) )
                                          | ~ p6(Y) ) )
                                      | ~ p105(Y) )
                                    & ( ( ( ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ p5(X)
                                              | ~ p104(X) )
                                          | p5(Y) )
                                        & ( ! [X] :
                                              ( ~ r1(Y,X)
                                              | p5(X)
                                              | ~ p104(X) )
                                          | ~ p5(Y) ) )
                                      | ~ p104(Y) )
                                    & ( ( ( ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ p4(X)
                                              | ~ p103(X) )
                                          | p4(Y) )
                                        & ( ! [X] :
                                              ( ~ r1(Y,X)
                                              | p4(X)
                                              | ~ p103(X) )
                                          | ~ p4(Y) ) )
                                      | ~ p103(Y) )
                                    & ( ( ( ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ p3(X)
                                              | ~ p102(X) )
                                          | p3(Y) )
                                        & ( ! [X] :
                                              ( ~ r1(Y,X)
                                              | p3(X)
                                              | ~ p102(X) )
                                          | ~ p3(Y) ) )
                                      | ~ p102(Y) )
                                    & ( ( ( ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ p2(X)
                                              | ~ p101(X) )
                                          | p2(Y) )
                                        & ( ! [X] :
                                              ( ~ r1(Y,X)
                                              | p2(X)
                                              | ~ p101(X) )
                                          | ~ p2(Y) ) )
                                      | ~ p101(Y) )
                                    & ( ( ( ! [X] :
                                              ( ~ r1(Y,X)
                                              | ~ p1(X)
                                              | ~ p100(X) )
                                          | p1(Y) )
                                        & ( ! [X] :
                                              ( ~ r1(Y,X)
                                              | p1(X)
                                              | ~ p100(X) )
                                          | ~ p1(Y) ) )
                                      | ~ p100(Y) )
                                    & ( p110(Y)
                                      | ~ p111(Y) )
                                    & ( p109(Y)
                                      | ~ p110(Y) )
                                    & ( p108(Y)
                                      | ~ p109(Y) )
                                    & ( p107(Y)
                                      | ~ p108(Y) )
                                    & ( p106(Y)
                                      | ~ p107(Y) )
                                    & ( p105(Y)
                                      | ~ p106(Y) )
                                    & ( p104(Y)
                                      | ~ p105(Y) )
                                    & ( p103(Y)
                                      | ~ p104(Y) )
                                    & ( p102(Y)
                                      | ~ p103(Y) )
                                    & ( p101(Y)
                                      | ~ p102(Y) )
                                    & ( p100(Y)
                                      | ~ p101(Y) ) ) ) ) ) ) )
              & ! [Y] :
                  ( ~ r1(X,Y)
                  | ! [X] :
                      ( ~ r1(Y,X)
                      | ! [Y] :
                          ( ~ r1(X,Y)
                          | ! [X] :
                              ( ~ r1(Y,X)
                              | ( ( ( ~ ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ ( ~ p11(Y)
                                              & ~ p111(Y)
                                              & p110(Y) ) )
                                    & ~ ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ ( p11(Y)
                                              & ~ p111(Y)
                                              & p110(Y) ) ) )
                                  | ~ ( ~ p110(X)
                                      & p109(X) ) )
                                & ( ( ~ ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ ( ~ p10(Y)
                                              & ~ p110(Y)
                                              & p109(Y) ) )
                                    & ~ ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ ( p10(Y)
                                              & ~ p110(Y)
                                              & p109(Y) ) ) )
                                  | ~ ( ~ p109(X)
                                      & p108(X) ) )
                                & ( ( ~ ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ ( ~ p9(Y)
                                              & ~ p109(Y)
                                              & p108(Y) ) )
                                    & ~ ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ ( p9(Y)
                                              & ~ p109(Y)
                                              & p108(Y) ) ) )
                                  | ~ ( ~ p108(X)
                                      & p107(X) ) )
                                & ( ( ~ ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ ( ~ p8(Y)
                                              & ~ p108(Y)
                                              & p107(Y) ) )
                                    & ~ ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ ( p8(Y)
                                              & ~ p108(Y)
                                              & p107(Y) ) ) )
                                  | ~ ( ~ p107(X)
                                      & p106(X) ) )
                                & ( ( ~ ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ ( ~ p7(Y)
                                              & ~ p107(Y)
                                              & p106(Y) ) )
                                    & ~ ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ ( p7(Y)
                                              & ~ p107(Y)
                                              & p106(Y) ) ) )
                                  | ~ ( ~ p106(X)
                                      & p105(X) ) )
                                & ( ( ~ ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ ( ~ p6(Y)
                                              & ~ p106(Y)
                                              & p105(Y) ) )
                                    & ~ ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ ( p6(Y)
                                              & ~ p106(Y)
                                              & p105(Y) ) ) )
                                  | ~ ( ~ p105(X)
                                      & p104(X) ) )
                                & ( ( ~ ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ ( ~ p5(Y)
                                              & ~ p105(Y)
                                              & p104(Y) ) )
                                    & ~ ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ ( p5(Y)
                                              & ~ p105(Y)
                                              & p104(Y) ) ) )
                                  | ~ ( ~ p104(X)
                                      & p103(X) ) )
                                & ( ( ~ ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ ( ~ p4(Y)
                                              & ~ p104(Y)
                                              & p103(Y) ) )
                                    & ~ ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ ( p4(Y)
                                              & ~ p104(Y)
                                              & p103(Y) ) ) )
                                  | ~ ( ~ p103(X)
                                      & p102(X) ) )
                                & ( ( ~ ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ ( ~ p3(Y)
                                              & ~ p103(Y)
                                              & p102(Y) ) )
                                    & ~ ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ ( p3(Y)
                                              & ~ p103(Y)
                                              & p102(Y) ) ) )
                                  | ~ ( ~ p102(X)
                                      & p101(X) ) )
                                & ( ( ~ ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ ( ~ p2(Y)
                                              & ~ p102(Y)
                                              & p101(Y) ) )
                                    & ~ ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ ( p2(Y)
                                              & ~ p102(Y)
                                              & p101(Y) ) ) )
                                  | ~ ( ~ p101(X)
                                      & p100(X) ) )
                                & ( ( ( ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ p11(Y)
                                          | ~ p110(Y) )
                                      | p11(X) )
                                    & ( ! [Y] :
                                          ( ~ r1(X,Y)
                                          | p11(Y)
                                          | ~ p110(Y) )
                                      | ~ p11(X) ) )
                                  | ~ p110(X) )
                                & ( ( ( ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ p10(Y)
                                          | ~ p109(Y) )
                                      | p10(X) )
                                    & ( ! [Y] :
                                          ( ~ r1(X,Y)
                                          | p10(Y)
                                          | ~ p109(Y) )
                                      | ~ p10(X) ) )
                                  | ~ p109(X) )
                                & ( ( ( ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ p9(Y)
                                          | ~ p108(Y) )
                                      | p9(X) )
                                    & ( ! [Y] :
                                          ( ~ r1(X,Y)
                                          | p9(Y)
                                          | ~ p108(Y) )
                                      | ~ p9(X) ) )
                                  | ~ p108(X) )
                                & ( ( ( ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ p8(Y)
                                          | ~ p107(Y) )
                                      | p8(X) )
                                    & ( ! [Y] :
                                          ( ~ r1(X,Y)
                                          | p8(Y)
                                          | ~ p107(Y) )
                                      | ~ p8(X) ) )
                                  | ~ p107(X) )
                                & ( ( ( ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ p7(Y)
                                          | ~ p106(Y) )
                                      | p7(X) )
                                    & ( ! [Y] :
                                          ( ~ r1(X,Y)
                                          | p7(Y)
                                          | ~ p106(Y) )
                                      | ~ p7(X) ) )
                                  | ~ p106(X) )
                                & ( ( ( ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ p6(Y)
                                          | ~ p105(Y) )
                                      | p6(X) )
                                    & ( ! [Y] :
                                          ( ~ r1(X,Y)
                                          | p6(Y)
                                          | ~ p105(Y) )
                                      | ~ p6(X) ) )
                                  | ~ p105(X) )
                                & ( ( ( ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ p5(Y)
                                          | ~ p104(Y) )
                                      | p5(X) )
                                    & ( ! [Y] :
                                          ( ~ r1(X,Y)
                                          | p5(Y)
                                          | ~ p104(Y) )
                                      | ~ p5(X) ) )
                                  | ~ p104(X) )
                                & ( ( ( ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ p4(Y)
                                          | ~ p103(Y) )
                                      | p4(X) )
                                    & ( ! [Y] :
                                          ( ~ r1(X,Y)
                                          | p4(Y)
                                          | ~ p103(Y) )
                                      | ~ p4(X) ) )
                                  | ~ p103(X) )
                                & ( ( ( ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ p3(Y)
                                          | ~ p102(Y) )
                                      | p3(X) )
                                    & ( ! [Y] :
                                          ( ~ r1(X,Y)
                                          | p3(Y)
                                          | ~ p102(Y) )
                                      | ~ p3(X) ) )
                                  | ~ p102(X) )
                                & ( ( ( ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ p2(Y)
                                          | ~ p101(Y) )
                                      | p2(X) )
                                    & ( ! [Y] :
                                          ( ~ r1(X,Y)
                                          | p2(Y)
                                          | ~ p101(Y) )
                                      | ~ p2(X) ) )
                                  | ~ p101(X) )
                                & ( ( ( ! [Y] :
                                          ( ~ r1(X,Y)
                                          | ~ p1(Y)
                                          | ~ p100(Y) )
                                      | p1(X) )
                                    & ( ! [Y] :
                                          ( ~ r1(X,Y)
                                          | p1(Y)
                                          | ~ p100(Y) )
                                      | ~ p1(X) ) )
                                  | ~ p100(X) )
                                & ( p110(X)
                                  | ~ p111(X) )
                                & ( p109(X)
                                  | ~ p110(X) )
                                & ( p108(X)
                                  | ~ p109(X) )
                                & ( p107(X)
                                  | ~ p108(X) )
                                & ( p106(X)
                                  | ~ p107(X) )
                                & ( p105(X)
                                  | ~ p106(X) )
                                & ( p104(X)
                                  | ~ p105(X) )
                                & ( p103(X)
                                  | ~ p104(X) )
                                & ( p102(X)
                                  | ~ p103(X) )
                                & ( p101(X)
                                  | ~ p102(X) )
                                & ( p100(X)
                                  | ~ p101(X) ) ) ) ) ) )
              & ! [Y] :
                  ( ~ r1(X,Y)
                  | ! [X] :
                      ( ~ r1(Y,X)
                      | ! [Y] :
                          ( ~ r1(X,Y)
                          | ( ( ( ~ ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ ( ~ p11(X)
                                          & ~ p111(X)
                                          & p110(X) ) )
                                & ~ ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ ( p11(X)
                                          & ~ p111(X)
                                          & p110(X) ) ) )
                              | ~ ( ~ p110(Y)
                                  & p109(Y) ) )
                            & ( ( ~ ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ ( ~ p10(X)
                                          & ~ p110(X)
                                          & p109(X) ) )
                                & ~ ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ ( p10(X)
                                          & ~ p110(X)
                                          & p109(X) ) ) )
                              | ~ ( ~ p109(Y)
                                  & p108(Y) ) )
                            & ( ( ~ ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ ( ~ p9(X)
                                          & ~ p109(X)
                                          & p108(X) ) )
                                & ~ ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ ( p9(X)
                                          & ~ p109(X)
                                          & p108(X) ) ) )
                              | ~ ( ~ p108(Y)
                                  & p107(Y) ) )
                            & ( ( ~ ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ ( ~ p8(X)
                                          & ~ p108(X)
                                          & p107(X) ) )
                                & ~ ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ ( p8(X)
                                          & ~ p108(X)
                                          & p107(X) ) ) )
                              | ~ ( ~ p107(Y)
                                  & p106(Y) ) )
                            & ( ( ~ ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ ( ~ p7(X)
                                          & ~ p107(X)
                                          & p106(X) ) )
                                & ~ ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ ( p7(X)
                                          & ~ p107(X)
                                          & p106(X) ) ) )
                              | ~ ( ~ p106(Y)
                                  & p105(Y) ) )
                            & ( ( ~ ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ ( ~ p6(X)
                                          & ~ p106(X)
                                          & p105(X) ) )
                                & ~ ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ ( p6(X)
                                          & ~ p106(X)
                                          & p105(X) ) ) )
                              | ~ ( ~ p105(Y)
                                  & p104(Y) ) )
                            & ( ( ~ ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ ( ~ p5(X)
                                          & ~ p105(X)
                                          & p104(X) ) )
                                & ~ ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ ( p5(X)
                                          & ~ p105(X)
                                          & p104(X) ) ) )
                              | ~ ( ~ p104(Y)
                                  & p103(Y) ) )
                            & ( ( ~ ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ ( ~ p4(X)
                                          & ~ p104(X)
                                          & p103(X) ) )
                                & ~ ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ ( p4(X)
                                          & ~ p104(X)
                                          & p103(X) ) ) )
                              | ~ ( ~ p103(Y)
                                  & p102(Y) ) )
                            & ( ( ~ ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ ( ~ p3(X)
                                          & ~ p103(X)
                                          & p102(X) ) )
                                & ~ ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ ( p3(X)
                                          & ~ p103(X)
                                          & p102(X) ) ) )
                              | ~ ( ~ p102(Y)
                                  & p101(Y) ) )
                            & ( ( ~ ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ ( ~ p2(X)
                                          & ~ p102(X)
                                          & p101(X) ) )
                                & ~ ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ ( p2(X)
                                          & ~ p102(X)
                                          & p101(X) ) ) )
                              | ~ ( ~ p101(Y)
                                  & p100(Y) ) )
                            & ( ( ( ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ p11(X)
                                      | ~ p110(X) )
                                  | p11(Y) )
                                & ( ! [X] :
                                      ( ~ r1(Y,X)
                                      | p11(X)
                                      | ~ p110(X) )
                                  | ~ p11(Y) ) )
                              | ~ p110(Y) )
                            & ( ( ( ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ p10(X)
                                      | ~ p109(X) )
                                  | p10(Y) )
                                & ( ! [X] :
                                      ( ~ r1(Y,X)
                                      | p10(X)
                                      | ~ p109(X) )
                                  | ~ p10(Y) ) )
                              | ~ p109(Y) )
                            & ( ( ( ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ p9(X)
                                      | ~ p108(X) )
                                  | p9(Y) )
                                & ( ! [X] :
                                      ( ~ r1(Y,X)
                                      | p9(X)
                                      | ~ p108(X) )
                                  | ~ p9(Y) ) )
                              | ~ p108(Y) )
                            & ( ( ( ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ p8(X)
                                      | ~ p107(X) )
                                  | p8(Y) )
                                & ( ! [X] :
                                      ( ~ r1(Y,X)
                                      | p8(X)
                                      | ~ p107(X) )
                                  | ~ p8(Y) ) )
                              | ~ p107(Y) )
                            & ( ( ( ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ p7(X)
                                      | ~ p106(X) )
                                  | p7(Y) )
                                & ( ! [X] :
                                      ( ~ r1(Y,X)
                                      | p7(X)
                                      | ~ p106(X) )
                                  | ~ p7(Y) ) )
                              | ~ p106(Y) )
                            & ( ( ( ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ p6(X)
                                      | ~ p105(X) )
                                  | p6(Y) )
                                & ( ! [X] :
                                      ( ~ r1(Y,X)
                                      | p6(X)
                                      | ~ p105(X) )
                                  | ~ p6(Y) ) )
                              | ~ p105(Y) )
                            & ( ( ( ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ p5(X)
                                      | ~ p104(X) )
                                  | p5(Y) )
                                & ( ! [X] :
                                      ( ~ r1(Y,X)
                                      | p5(X)
                                      | ~ p104(X) )
                                  | ~ p5(Y) ) )
                              | ~ p104(Y) )
                            & ( ( ( ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ p4(X)
                                      | ~ p103(X) )
                                  | p4(Y) )
                                & ( ! [X] :
                                      ( ~ r1(Y,X)
                                      | p4(X)
                                      | ~ p103(X) )
                                  | ~ p4(Y) ) )
                              | ~ p103(Y) )
                            & ( ( ( ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ p3(X)
                                      | ~ p102(X) )
                                  | p3(Y) )
                                & ( ! [X] :
                                      ( ~ r1(Y,X)
                                      | p3(X)
                                      | ~ p102(X) )
                                  | ~ p3(Y) ) )
                              | ~ p102(Y) )
                            & ( ( ( ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ p2(X)
                                      | ~ p101(X) )
                                  | p2(Y) )
                                & ( ! [X] :
                                      ( ~ r1(Y,X)
                                      | p2(X)
                                      | ~ p101(X) )
                                  | ~ p2(Y) ) )
                              | ~ p101(Y) )
                            & ( ( ( ! [X] :
                                      ( ~ r1(Y,X)
                                      | ~ p1(X)
                                      | ~ p100(X) )
                                  | p1(Y) )
                                & ( ! [X] :
                                      ( ~ r1(Y,X)
                                      | p1(X)
                                      | ~ p100(X) )
                                  | ~ p1(Y) ) )
                              | ~ p100(Y) )
                            & ( p110(Y)
                              | ~ p111(Y) )
                            & ( p109(Y)
                              | ~ p110(Y) )
                            & ( p108(Y)
                              | ~ p109(Y) )
                            & ( p107(Y)
                              | ~ p108(Y) )
                            & ( p106(Y)
                              | ~ p107(Y) )
                            & ( p105(Y)
                              | ~ p106(Y) )
                            & ( p104(Y)
                              | ~ p105(Y) )
                            & ( p103(Y)
                              | ~ p104(Y) )
                            & ( p102(Y)
                              | ~ p103(Y) )
                            & ( p101(Y)
                              | ~ p102(Y) )
                            & ( p100(Y)
                              | ~ p101(Y) ) ) ) ) )
              & ! [Y] :
                  ( ~ r1(X,Y)
                  | ! [X] :
                      ( ~ r1(Y,X)
                      | ( ( ( ~ ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ ( ~ p11(Y)
                                      & ~ p111(Y)
                                      & p110(Y) ) )
                            & ~ ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ ( p11(Y)
                                      & ~ p111(Y)
                                      & p110(Y) ) ) )
                          | ~ ( ~ p110(X)
                              & p109(X) ) )
                        & ( ( ~ ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ ( ~ p10(Y)
                                      & ~ p110(Y)
                                      & p109(Y) ) )
                            & ~ ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ ( p10(Y)
                                      & ~ p110(Y)
                                      & p109(Y) ) ) )
                          | ~ ( ~ p109(X)
                              & p108(X) ) )
                        & ( ( ~ ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ ( ~ p9(Y)
                                      & ~ p109(Y)
                                      & p108(Y) ) )
                            & ~ ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ ( p9(Y)
                                      & ~ p109(Y)
                                      & p108(Y) ) ) )
                          | ~ ( ~ p108(X)
                              & p107(X) ) )
                        & ( ( ~ ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ ( ~ p8(Y)
                                      & ~ p108(Y)
                                      & p107(Y) ) )
                            & ~ ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ ( p8(Y)
                                      & ~ p108(Y)
                                      & p107(Y) ) ) )
                          | ~ ( ~ p107(X)
                              & p106(X) ) )
                        & ( ( ~ ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ ( ~ p7(Y)
                                      & ~ p107(Y)
                                      & p106(Y) ) )
                            & ~ ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ ( p7(Y)
                                      & ~ p107(Y)
                                      & p106(Y) ) ) )
                          | ~ ( ~ p106(X)
                              & p105(X) ) )
                        & ( ( ~ ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ ( ~ p6(Y)
                                      & ~ p106(Y)
                                      & p105(Y) ) )
                            & ~ ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ ( p6(Y)
                                      & ~ p106(Y)
                                      & p105(Y) ) ) )
                          | ~ ( ~ p105(X)
                              & p104(X) ) )
                        & ( ( ~ ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ ( ~ p5(Y)
                                      & ~ p105(Y)
                                      & p104(Y) ) )
                            & ~ ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ ( p5(Y)
                                      & ~ p105(Y)
                                      & p104(Y) ) ) )
                          | ~ ( ~ p104(X)
                              & p103(X) ) )
                        & ( ( ~ ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ ( ~ p4(Y)
                                      & ~ p104(Y)
                                      & p103(Y) ) )
                            & ~ ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ ( p4(Y)
                                      & ~ p104(Y)
                                      & p103(Y) ) ) )
                          | ~ ( ~ p103(X)
                              & p102(X) ) )
                        & ( ( ~ ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ ( ~ p3(Y)
                                      & ~ p103(Y)
                                      & p102(Y) ) )
                            & ~ ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ ( p3(Y)
                                      & ~ p103(Y)
                                      & p102(Y) ) ) )
                          | ~ ( ~ p102(X)
                              & p101(X) ) )
                        & ( ( ~ ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ ( ~ p2(Y)
                                      & ~ p102(Y)
                                      & p101(Y) ) )
                            & ~ ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ ( p2(Y)
                                      & ~ p102(Y)
                                      & p101(Y) ) ) )
                          | ~ ( ~ p101(X)
                              & p100(X) ) )
                        & ( ( ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ p11(Y)
                                  | ~ p110(Y) )
                              | p11(X) )
                            & ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p11(Y)
                                  | ~ p110(Y) )
                              | ~ p11(X) ) )
                          | ~ p110(X) )
                        & ( ( ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ p10(Y)
                                  | ~ p109(Y) )
                              | p10(X) )
                            & ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p10(Y)
                                  | ~ p109(Y) )
                              | ~ p10(X) ) )
                          | ~ p109(X) )
                        & ( ( ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ p9(Y)
                                  | ~ p108(Y) )
                              | p9(X) )
                            & ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p9(Y)
                                  | ~ p108(Y) )
                              | ~ p9(X) ) )
                          | ~ p108(X) )
                        & ( ( ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ p8(Y)
                                  | ~ p107(Y) )
                              | p8(X) )
                            & ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p8(Y)
                                  | ~ p107(Y) )
                              | ~ p8(X) ) )
                          | ~ p107(X) )
                        & ( ( ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ p7(Y)
                                  | ~ p106(Y) )
                              | p7(X) )
                            & ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p7(Y)
                                  | ~ p106(Y) )
                              | ~ p7(X) ) )
                          | ~ p106(X) )
                        & ( ( ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ p6(Y)
                                  | ~ p105(Y) )
                              | p6(X) )
                            & ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p6(Y)
                                  | ~ p105(Y) )
                              | ~ p6(X) ) )
                          | ~ p105(X) )
                        & ( ( ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ p5(Y)
                                  | ~ p104(Y) )
                              | p5(X) )
                            & ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p5(Y)
                                  | ~ p104(Y) )
                              | ~ p5(X) ) )
                          | ~ p104(X) )
                        & ( ( ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ p4(Y)
                                  | ~ p103(Y) )
                              | p4(X) )
                            & ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p4(Y)
                                  | ~ p103(Y) )
                              | ~ p4(X) ) )
                          | ~ p103(X) )
                        & ( ( ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ p3(Y)
                                  | ~ p102(Y) )
                              | p3(X) )
                            & ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p3(Y)
                                  | ~ p102(Y) )
                              | ~ p3(X) ) )
                          | ~ p102(X) )
                        & ( ( ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ p2(Y)
                                  | ~ p101(Y) )
                              | p2(X) )
                            & ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p2(Y)
                                  | ~ p101(Y) )
                              | ~ p2(X) ) )
                          | ~ p101(X) )
                        & ( ( ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | ~ p1(Y)
                                  | ~ p100(Y) )
                              | p1(X) )
                            & ( ! [Y] :
                                  ( ~ r1(X,Y)
                                  | p1(Y)
                                  | ~ p100(Y) )
                              | ~ p1(X) ) )
                          | ~ p100(X) )
                        & ( p110(X)
                          | ~ p111(X) )
                        & ( p109(X)
                          | ~ p110(X) )
                        & ( p108(X)
                          | ~ p109(X) )
                        & ( p107(X)
                          | ~ p108(X) )
                        & ( p106(X)
                          | ~ p107(X) )
                        & ( p105(X)
                          | ~ p106(X) )
                        & ( p104(X)
                          | ~ p105(X) )
                        & ( p103(X)
                          | ~ p104(X) )
                        & ( p102(X)
                          | ~ p103(X) )
                        & ( p101(X)
                          | ~ p102(X) )
                        & ( p100(X)
                          | ~ p101(X) ) ) ) )
              & ! [Y] :
                  ( ~ r1(X,Y)
                  | ( ( ( ~ ! [X] :
                              ( ~ r1(Y,X)
                              | ~ ( ~ p11(X)
                                  & ~ p111(X)
                                  & p110(X) ) )
                        & ~ ! [X] :
                              ( ~ r1(Y,X)
                              | ~ ( p11(X)
                                  & ~ p111(X)
                                  & p110(X) ) ) )
                      | ~ ( ~ p110(Y)
                          & p109(Y) ) )
                    & ( ( ~ ! [X] :
                              ( ~ r1(Y,X)
                              | ~ ( ~ p10(X)
                                  & ~ p110(X)
                                  & p109(X) ) )
                        & ~ ! [X] :
                              ( ~ r1(Y,X)
                              | ~ ( p10(X)
                                  & ~ p110(X)
                                  & p109(X) ) ) )
                      | ~ ( ~ p109(Y)
                          & p108(Y) ) )
                    & ( ( ~ ! [X] :
                              ( ~ r1(Y,X)
                              | ~ ( ~ p9(X)
                                  & ~ p109(X)
                                  & p108(X) ) )
                        & ~ ! [X] :
                              ( ~ r1(Y,X)
                              | ~ ( p9(X)
                                  & ~ p109(X)
                                  & p108(X) ) ) )
                      | ~ ( ~ p108(Y)
                          & p107(Y) ) )
                    & ( ( ~ ! [X] :
                              ( ~ r1(Y,X)
                              | ~ ( ~ p8(X)
                                  & ~ p108(X)
                                  & p107(X) ) )
                        & ~ ! [X] :
                              ( ~ r1(Y,X)
                              | ~ ( p8(X)
                                  & ~ p108(X)
                                  & p107(X) ) ) )
                      | ~ ( ~ p107(Y)
                          & p106(Y) ) )
                    & ( ( ~ ! [X] :
                              ( ~ r1(Y,X)
                              | ~ ( ~ p7(X)
                                  & ~ p107(X)
                                  & p106(X) ) )
                        & ~ ! [X] :
                              ( ~ r1(Y,X)
                              | ~ ( p7(X)
                                  & ~ p107(X)
                                  & p106(X) ) ) )
                      | ~ ( ~ p106(Y)
                          & p105(Y) ) )
                    & ( ( ~ ! [X] :
                              ( ~ r1(Y,X)
                              | ~ ( ~ p6(X)
                                  & ~ p106(X)
                                  & p105(X) ) )
                        & ~ ! [X] :
                              ( ~ r1(Y,X)
                              | ~ ( p6(X)
                                  & ~ p106(X)
                                  & p105(X) ) ) )
                      | ~ ( ~ p105(Y)
                          & p104(Y) ) )
                    & ( ( ~ ! [X] :
                              ( ~ r1(Y,X)
                              | ~ ( ~ p5(X)
                                  & ~ p105(X)
                                  & p104(X) ) )
                        & ~ ! [X] :
                              ( ~ r1(Y,X)
                              | ~ ( p5(X)
                                  & ~ p105(X)
                                  & p104(X) ) ) )
                      | ~ ( ~ p104(Y)
                          & p103(Y) ) )
                    & ( ( ~ ! [X] :
                              ( ~ r1(Y,X)
                              | ~ ( ~ p4(X)
                                  & ~ p104(X)
                                  & p103(X) ) )
                        & ~ ! [X] :
                              ( ~ r1(Y,X)
                              | ~ ( p4(X)
                                  & ~ p104(X)
                                  & p103(X) ) ) )
                      | ~ ( ~ p103(Y)
                          & p102(Y) ) )
                    & ( ( ~ ! [X] :
                              ( ~ r1(Y,X)
                              | ~ ( ~ p3(X)
                                  & ~ p103(X)
                                  & p102(X) ) )
                        & ~ ! [X] :
                              ( ~ r1(Y,X)
                              | ~ ( p3(X)
                                  & ~ p103(X)
                                  & p102(X) ) ) )
                      | ~ ( ~ p102(Y)
                          & p101(Y) ) )
                    & ( ( ~ ! [X] :
                              ( ~ r1(Y,X)
                              | ~ ( ~ p2(X)
                                  & ~ p102(X)
                                  & p101(X) ) )
                        & ~ ! [X] :
                              ( ~ r1(Y,X)
                              | ~ ( p2(X)
                                  & ~ p102(X)
                                  & p101(X) ) ) )
                      | ~ ( ~ p101(Y)
                          & p100(Y) ) )
                    & ( ( ( ! [X] :
                              ( ~ r1(Y,X)
                              | ~ p11(X)
                              | ~ p110(X) )
                          | p11(Y) )
                        & ( ! [X] :
                              ( ~ r1(Y,X)
                              | p11(X)
                              | ~ p110(X) )
                          | ~ p11(Y) ) )
                      | ~ p110(Y) )
                    & ( ( ( ! [X] :
                              ( ~ r1(Y,X)
                              | ~ p10(X)
                              | ~ p109(X) )
                          | p10(Y) )
                        & ( ! [X] :
                              ( ~ r1(Y,X)
                              | p10(X)
                              | ~ p109(X) )
                          | ~ p10(Y) ) )
                      | ~ p109(Y) )
                    & ( ( ( ! [X] :
                              ( ~ r1(Y,X)
                              | ~ p9(X)
                              | ~ p108(X) )
                          | p9(Y) )
                        & ( ! [X] :
                              ( ~ r1(Y,X)
                              | p9(X)
                              | ~ p108(X) )
                          | ~ p9(Y) ) )
                      | ~ p108(Y) )
                    & ( ( ( ! [X] :
                              ( ~ r1(Y,X)
                              | ~ p8(X)
                              | ~ p107(X) )
                          | p8(Y) )
                        & ( ! [X] :
                              ( ~ r1(Y,X)
                              | p8(X)
                              | ~ p107(X) )
                          | ~ p8(Y) ) )
                      | ~ p107(Y) )
                    & ( ( ( ! [X] :
                              ( ~ r1(Y,X)
                              | ~ p7(X)
                              | ~ p106(X) )
                          | p7(Y) )
                        & ( ! [X] :
                              ( ~ r1(Y,X)
                              | p7(X)
                              | ~ p106(X) )
                          | ~ p7(Y) ) )
                      | ~ p106(Y) )
                    & ( ( ( ! [X] :
                              ( ~ r1(Y,X)
                              | ~ p6(X)
                              | ~ p105(X) )
                          | p6(Y) )
                        & ( ! [X] :
                              ( ~ r1(Y,X)
                              | p6(X)
                              | ~ p105(X) )
                          | ~ p6(Y) ) )
                      | ~ p105(Y) )
                    & ( ( ( ! [X] :
                              ( ~ r1(Y,X)
                              | ~ p5(X)
                              | ~ p104(X) )
                          | p5(Y) )
                        & ( ! [X] :
                              ( ~ r1(Y,X)
                              | p5(X)
                              | ~ p104(X) )
                          | ~ p5(Y) ) )
                      | ~ p104(Y) )
                    & ( ( ( ! [X] :
                              ( ~ r1(Y,X)
                              | ~ p4(X)
                              | ~ p103(X) )
                          | p4(Y) )
                        & ( ! [X] :
                              ( ~ r1(Y,X)
                              | p4(X)
                              | ~ p103(X) )
                          | ~ p4(Y) ) )
                      | ~ p103(Y) )
                    & ( ( ( ! [X] :
                              ( ~ r1(Y,X)
                              | ~ p3(X)
                              | ~ p102(X) )
                          | p3(Y) )
                        & ( ! [X] :
                              ( ~ r1(Y,X)
                              | p3(X)
                              | ~ p102(X) )
                          | ~ p3(Y) ) )
                      | ~ p102(Y) )
                    & ( ( ( ! [X] :
                              ( ~ r1(Y,X)
                              | ~ p2(X)
                              | ~ p101(X) )
                          | p2(Y) )
                        & ( ! [X] :
                              ( ~ r1(Y,X)
                              | p2(X)
                              | ~ p101(X) )
                          | ~ p2(Y) ) )
                      | ~ p101(Y) )
                    & ( ( ( ! [X] :
                              ( ~ r1(Y,X)
                              | ~ p1(X)
                              | ~ p100(X) )
                          | p1(Y) )
                        & ( ! [X] :
                              ( ~ r1(Y,X)
                              | p1(X)
                              | ~ p100(X) )
                          | ~ p1(Y) ) )
                      | ~ p100(Y) )
                    & ( p110(Y)
                      | ~ p111(Y) )
                    & ( p109(Y)
                      | ~ p110(Y) )
                    & ( p108(Y)
                      | ~ p109(Y) )
                    & ( p107(Y)
                      | ~ p108(Y) )
                    & ( p106(Y)
                      | ~ p107(Y) )
                    & ( p105(Y)
                      | ~ p106(Y) )
                    & ( p104(Y)
                      | ~ p105(Y) )
                    & ( p103(Y)
                      | ~ p104(Y) )
                    & ( p102(Y)
                      | ~ p103(Y) )
                    & ( p101(Y)
                      | ~ p102(Y) )
                    & ( p100(Y)
                      | ~ p101(Y) ) ) )
              & ( ( ~ ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ ( ~ p11(Y)
                            & ~ p111(Y)
                            & p110(Y) ) )
                  & ~ ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ ( p11(Y)
                            & ~ p111(Y)
                            & p110(Y) ) ) )
                | ~ ( ~ p110(X)
                    & p109(X) ) )
              & ( ( ~ ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ ( ~ p10(Y)
                            & ~ p110(Y)
                            & p109(Y) ) )
                  & ~ ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ ( p10(Y)
                            & ~ p110(Y)
                            & p109(Y) ) ) )
                | ~ ( ~ p109(X)
                    & p108(X) ) )
              & ( ( ~ ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ ( ~ p9(Y)
                            & ~ p109(Y)
                            & p108(Y) ) )
                  & ~ ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ ( p9(Y)
                            & ~ p109(Y)
                            & p108(Y) ) ) )
                | ~ ( ~ p108(X)
                    & p107(X) ) )
              & ( ( ~ ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ ( ~ p8(Y)
                            & ~ p108(Y)
                            & p107(Y) ) )
                  & ~ ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ ( p8(Y)
                            & ~ p108(Y)
                            & p107(Y) ) ) )
                | ~ ( ~ p107(X)
                    & p106(X) ) )
              & ( ( ~ ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ ( ~ p7(Y)
                            & ~ p107(Y)
                            & p106(Y) ) )
                  & ~ ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ ( p7(Y)
                            & ~ p107(Y)
                            & p106(Y) ) ) )
                | ~ ( ~ p106(X)
                    & p105(X) ) )
              & ( ( ~ ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ ( ~ p6(Y)
                            & ~ p106(Y)
                            & p105(Y) ) )
                  & ~ ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ ( p6(Y)
                            & ~ p106(Y)
                            & p105(Y) ) ) )
                | ~ ( ~ p105(X)
                    & p104(X) ) )
              & ( ( ~ ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ ( ~ p5(Y)
                            & ~ p105(Y)
                            & p104(Y) ) )
                  & ~ ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ ( p5(Y)
                            & ~ p105(Y)
                            & p104(Y) ) ) )
                | ~ ( ~ p104(X)
                    & p103(X) ) )
              & ( ( ~ ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ ( ~ p4(Y)
                            & ~ p104(Y)
                            & p103(Y) ) )
                  & ~ ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ ( p4(Y)
                            & ~ p104(Y)
                            & p103(Y) ) ) )
                | ~ ( ~ p103(X)
                    & p102(X) ) )
              & ( ( ~ ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ ( ~ p3(Y)
                            & ~ p103(Y)
                            & p102(Y) ) )
                  & ~ ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ ( p3(Y)
                            & ~ p103(Y)
                            & p102(Y) ) ) )
                | ~ ( ~ p102(X)
                    & p101(X) ) )
              & ( ( ~ ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ ( ~ p2(Y)
                            & ~ p102(Y)
                            & p101(Y) ) )
                  & ~ ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ ( p2(Y)
                            & ~ p102(Y)
                            & p101(Y) ) ) )
                | ~ ( ~ p101(X)
                    & p100(X) ) )
              & ( ( ( ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ p11(Y)
                        | ~ p110(Y) )
                    | p11(X) )
                  & ( ! [Y] :
                        ( ~ r1(X,Y)
                        | p11(Y)
                        | ~ p110(Y) )
                    | ~ p11(X) ) )
                | ~ p110(X) )
              & ( ( ( ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ p10(Y)
                        | ~ p109(Y) )
                    | p10(X) )
                  & ( ! [Y] :
                        ( ~ r1(X,Y)
                        | p10(Y)
                        | ~ p109(Y) )
                    | ~ p10(X) ) )
                | ~ p109(X) )
              & ( ( ( ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ p9(Y)
                        | ~ p108(Y) )
                    | p9(X) )
                  & ( ! [Y] :
                        ( ~ r1(X,Y)
                        | p9(Y)
                        | ~ p108(Y) )
                    | ~ p9(X) ) )
                | ~ p108(X) )
              & ( ( ( ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ p8(Y)
                        | ~ p107(Y) )
                    | p8(X) )
                  & ( ! [Y] :
                        ( ~ r1(X,Y)
                        | p8(Y)
                        | ~ p107(Y) )
                    | ~ p8(X) ) )
                | ~ p107(X) )
              & ( ( ( ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ p7(Y)
                        | ~ p106(Y) )
                    | p7(X) )
                  & ( ! [Y] :
                        ( ~ r1(X,Y)
                        | p7(Y)
                        | ~ p106(Y) )
                    | ~ p7(X) ) )
                | ~ p106(X) )
              & ( ( ( ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ p6(Y)
                        | ~ p105(Y) )
                    | p6(X) )
                  & ( ! [Y] :
                        ( ~ r1(X,Y)
                        | p6(Y)
                        | ~ p105(Y) )
                    | ~ p6(X) ) )
                | ~ p105(X) )
              & ( ( ( ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ p5(Y)
                        | ~ p104(Y) )
                    | p5(X) )
                  & ( ! [Y] :
                        ( ~ r1(X,Y)
                        | p5(Y)
                        | ~ p104(Y) )
                    | ~ p5(X) ) )
                | ~ p104(X) )
              & ( ( ( ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ p4(Y)
                        | ~ p103(Y) )
                    | p4(X) )
                  & ( ! [Y] :
                        ( ~ r1(X,Y)
                        | p4(Y)
                        | ~ p103(Y) )
                    | ~ p4(X) ) )
                | ~ p103(X) )
              & ( ( ( ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ p3(Y)
                        | ~ p102(Y) )
                    | p3(X) )
                  & ( ! [Y] :
                        ( ~ r1(X,Y)
                        | p3(Y)
                        | ~ p102(Y) )
                    | ~ p3(X) ) )
                | ~ p102(X) )
              & ( ( ( ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ p2(Y)
                        | ~ p101(Y) )
                    | p2(X) )
                  & ( ! [Y] :
                        ( ~ r1(X,Y)
                        | p2(Y)
                        | ~ p101(Y) )
                    | ~ p2(X) ) )
                | ~ p101(X) )
              & ( ( ( ! [Y] :
                        ( ~ r1(X,Y)
                        | ~ p1(Y)
                        | ~ p100(Y) )
                    | p1(X) )
                  & ( ! [Y] :
                        ( ~ r1(X,Y)
                        | p1(Y)
                        | ~ p100(Y) )
                    | ~ p1(X) ) )
                | ~ p100(X) )
              & ( p110(X)
                | ~ p111(X) )
              & ( p109(X)
                | ~ p110(X) )
              & ( p108(X)
                | ~ p109(X) )
              & ( p107(X)
                | ~ p108(X) )
              & ( p106(X)
                | ~ p107(X) )
              & ( p105(X)
                | ~ p106(X) )
              & ( p104(X)
                | ~ p105(X) )
              & ( p103(X)
                | ~ p104(X) )
              & ( p102(X)
                | ~ p103(X) )
              & ( p101(X)
                | ~ p102(X) )
              & ( p100(X)
                | ~ p101(X) )
              & ~ p101(X)
              & p100(X) ) ) ).

%------------------------------------------------------------------------------
