%------------------------------------------------------------------------------
% File     : LCL453+1 : TPTP v9.2.0. Bugfixed v9.2.0.
% Domain   : ? v9.2.0
% Problem  : Prove Lukasiewicz's cn3 axiom from Hilbert's axiomatization
% Version  : [HB34] axioms.
% English  :

% Refs     : [HB34]  Hilbert & Bernays (1934), Grundlagen der Mathematick
%          : [Hal]   Halleck (URL), John Halleck's Logic Systems
% Source   : [TPTP]
% Names    :

% Status   : Theorem
% Rating   : ? v9.2.0
% Syntax   : Number of formulae    :   53 (  22 unt;   0 def)
%            Number of atoms       :   87 (   6 equ)
%            Maximal formula atoms :    4 (   1 avg)
%            Number of connectives :   34 (   0   ~;   0   |;   1   &)
%                                         (  26 <=>;   7  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    6 (   3 avg)
%            Maximal term depth    :    5 (   2 avg)
%            Number of predicates  :   34 (  33 usr;  32 prp; 0-2 aty)
%            Number of functors    :    5 (   5 usr;   0 con; 1-2 aty)
%            Number of variables   :   65 (  65   !;   0   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments :
% Bugfixes : v9.2.0 - Bugfix in LCL006+2.ax
%------------------------------------------------------------------------------
%----Include axioms of propositional logic
include('Axioms/LCL006+0.ax').
include('Axioms/LCL006+1.ax').
%----Include Hilbert's axiomatization of propositional logic
include('Axioms/LCL006+2.ax').
%------------------------------------------------------------------------------
%----Operator definitions to reduce everything to and & not
fof(luka_op_or,axiom,
    op_or ).

fof(luka_op_implies,axiom,
    op_implies ).

fof(luka_op_equiv,axiom,
    op_equiv ).

fof(luka_cn3,conjecture,
    cn3 ).

%------------------------------------------------------------------------------
