%--------------------------------------------------------------------------
% File     : LCL084-3 : TPTP v9.2.0. Bugfixed v1.2.0.
% Domain   : Logic Calculi (Implicational propositional)
% Problem  : IC-4 depends on the 1st Lukasiewicz axiom
% Version  : [ANL] axioms : Augmented.
% English  : Axiomatisations of the Implicational propositional calculus
%            are {IC-2,IC-3,IC-4} by Tarski-Bernays and single Lukasiewicz
%            axioms. Show that IC-4 depends on the first Lukasiewicz
%            axiom.

% Refs     : [Luk48] Lukasiewicz (1948), The Shortest Axiom of the Implicat
%          : [Pfe88] Pfenning (1988), Single Axioms in the Implicational Pr
% Source   : [Pfe88]
% Names    : IPH1 [Pfe88]
%          : ls7 [SETHEO]

% Status   : Unsatisfiable
% Rating   : 0.71 v9.1.0, 0.60 v9.0.0, 0.45 v8.2.0, 0.14 v8.1.0, 0.00 v7.4.0, 0.33 v7.3.0, 0.00 v6.4.0, 0.25 v6.2.0, 0.33 v6.1.0, 0.79 v6.0.0, 0.67 v5.5.0, 0.81 v5.4.0, 0.78 v5.3.0, 0.80 v5.2.0, 0.77 v5.1.0, 0.75 v5.0.0, 0.73 v4.1.0, 0.67 v4.0.1, 0.29 v3.4.0, 0.00 v3.3.0, 0.33 v3.1.0, 0.67 v2.7.0, 0.88 v2.6.0, 0.86 v2.4.0, 1.00 v2.3.0, 0.71 v2.2.1, 0.83 v2.2.0, 1.00 v2.0.0
% Syntax   : Number of clauses     :    5 (   4 unt;   0 nHn;   2 RR)
%            Number of literals    :    7 (   0 equ;   3 neg)
%            Maximal clause size   :    3 (   1 avg)
%            Maximal term depth    :    4 (   2 avg)
%            Number of predicates  :    1 (   1 usr;   0 prp; 1-1 aty)
%            Number of functors    :    4 (   4 usr;   3 con; 0-2 aty)
%            Number of variables   :    9 (   3 sgn)
% SPC      : CNF_UNS_RFO_NEQ_HRN

% Comments : Supplies IC-1 and IC-3 as extra axioms.
% Bugfixes : v1.2.0 - Clause ic_1 fixed.
%--------------------------------------------------------------------------
cnf(condensed_detachment,axiom,
    ( ~ is_a_theorem(implies(X,Y))
    | ~ is_a_theorem(X)
    | is_a_theorem(Y) ) ).

cnf(ic_JLukasiewicz,axiom,
    is_a_theorem(implies(implies(implies(X,Y),Z),implies(implies(Z,X),implies(U,X)))) ).

cnf(ic_1,axiom,
    is_a_theorem(implies(X,X)) ).

cnf(ic_3,axiom,
    is_a_theorem(implies(implies(implies(X,Y),X),X)) ).

cnf(prove_ic_4,negated_conjecture,
    ~ is_a_theorem(implies(implies(a,b),implies(implies(b,c),implies(a,c)))) ).

%--------------------------------------------------------------------------
