%------------------------------------------------------------------------------
% File     : LAT221-1 : TPTP v9.2.0. Released v3.1.0.
% Domain   : Lattice Theory
% Problem  : Equation H4 is Huntington by implication
% Version  : [McC05] (equality) axioms : Especial.
% English  : Show that H4 is Huntington by deriving the Huntington implication
%            X ^ Y = Y  ->  X' v Y' = Y' in uniquely complemented lattices.

% Refs     : [McC05] McCune (2005), Email to Geoff Sutcliffe
% Source   : [McC05]
% Names    :

% Status   : Unsatisfiable
% Rating   : 0.88 v9.1.0, 0.87 v8.2.0, 0.94 v8.1.0, 0.95 v7.5.0, 0.94 v7.4.0, 1.00 v7.3.0, 0.92 v7.2.0, 1.00 v3.1.0
% Syntax   : Number of clauses     :   14 (  13 unt;   0 nHn;   3 RR)
%            Number of literals    :   16 (  16 equ;   3 neg)
%            Maximal clause size   :    3 (   1 avg)
%            Maximal term depth    :    6 (   2 avg)
%            Number of predicates  :    1 (   0 usr;   0 prp; 2-2 aty)
%            Number of functors    :    7 (   7 usr;   4 con; 0-2 aty)
%            Number of variables   :   24 (   2 sgn)
% SPC      : CNF_UNS_RFO_PEQ_NUE

% Comments :
%------------------------------------------------------------------------------
%----Include Lattice theory (equality) axioms
include('Axioms/LAT001-0.ax').
%----Include Lattice theory unique complementation (equality) axioms
include('Axioms/LAT001-4.ax').
%------------------------------------------------------------------------------
cnf(equation_H4,axiom,
    meet(X,join(Y,meet(X,join(Z,U)))) = meet(X,join(Y,meet(join(X,meet(Y,U)),join(Z,U)))) ).

cnf(prove_distributivity_hypothesis,hypothesis,
    meet(b,a) = a ).

cnf(prove_distributivity,negated_conjecture,
    join(complement(b),complement(a)) != complement(a) ).

%------------------------------------------------------------------------------
