%------------------------------------------------------------------------------
% File     : LAT162-1 : TPTP v9.2.0. Released v3.1.0.
% Domain   : Lattice Theory
% Problem  : Huntington equation H68 implies H73
% Version  : [McC05] (equality) axioms : Especial.
% English  :

% Refs     : [McC05] McCune (2005), Email to Geoff Sutcliffe
% Source   : [McC05]
% Names    :

% Status   : Unsatisfiable
% Rating   : 0.87 v9.1.0, 0.86 v8.2.0, 0.92 v8.1.0, 0.95 v7.5.0, 0.83 v7.3.0, 0.79 v7.1.0, 0.78 v7.0.0, 0.89 v6.3.0, 0.88 v6.2.0, 0.93 v6.1.0, 0.94 v6.0.0, 0.95 v5.4.0, 0.93 v5.3.0, 0.92 v5.2.0, 0.93 v5.1.0, 0.87 v5.0.0, 0.86 v4.1.0, 0.82 v4.0.1, 0.86 v4.0.0, 0.85 v3.7.0, 0.78 v3.4.0, 0.75 v3.3.0, 0.86 v3.1.0
% Syntax   : Number of clauses     :   10 (  10 unt;   0 nHn;   1 RR)
%            Number of literals    :   10 (  10 equ;   1 neg)
%            Maximal clause size   :    1 (   1 avg)
%            Maximal term depth    :    7 (   2 avg)
%            Number of predicates  :    1 (   0 usr;   0 prp; 2-2 aty)
%            Number of functors    :    6 (   6 usr;   4 con; 0-2 aty)
%            Number of variables   :   19 (   2 sgn)
% SPC      : CNF_UNS_RFO_PEQ_UEQ

% Comments :
%------------------------------------------------------------------------------
%----Include Lattice theory (equality) axioms
include('Axioms/LAT001-0.ax').
%------------------------------------------------------------------------------
cnf(equation_H68,axiom,
    meet(X,join(Y,Z)) = meet(X,join(Y,meet(X,join(Z,meet(X,Y))))) ).

cnf(prove_H73,negated_conjecture,
    meet(a,meet(b,join(c,d))) != meet(a,meet(b,join(c,meet(a,join(d,meet(b,c)))))) ).

%------------------------------------------------------------------------------
