%--------------------------------------------------------------------------
% File     : LAT075-1 : TPTP v9.2.0. Released v2.6.0.
% Domain   : Lattice Theory (Ortholattices)
% Problem  : Given single axiom MOL-25A, prove modularity
% Version  : [MRV03] (equality) axioms.
% English  : Given a single axiom candidate MOL-25A for modular ortholattices
%            (MOL) in terms of the Sheffer Stroke, prove a Sheffer stroke form
%            of modularity.

% Refs     : [MRV03] McCune et al. (2003), Sheffer Stroke Bases for Ortholatt
% Source   : [MRV03]
% Names    : MOL-25A-modularity [MRV03]

% Status   : Unsatisfiable
% Rating   : 1.00 v2.6.0
% Syntax   : Number of clauses     :    2 (   2 unt;   0 nHn;   1 RR)
%            Number of literals    :    2 (   2 equ;   1 neg)
%            Maximal clause size   :    1 (   1 avg)
%            Maximal term depth    :    8 (   2 avg)
%            Number of predicates  :    1 (   0 usr;   0 prp; 2-2 aty)
%            Number of functors    :    4 (   4 usr;   3 con; 0-2 aty)
%            Number of variables   :    4 (   1 sgn)
% SPC      : CNF_UNS_RFO_PEQ_UEQ

% Comments :
%--------------------------------------------------------------------------
%----Single axiom MOL-25A
cnf(mol_25A,axiom,
    f(f(B,A),f(f(f(A,A),C),f(f(f(f(f(A,B),C),C),A),f(A,D)))) = A ).

%----Denial of Sheffer stroke modularity
cnf(modularity,negated_conjecture,
    f(a,f(b,f(a,f(c,c)))) != f(a,f(c,f(a,f(b,b)))) ).

%--------------------------------------------------------------------------
