%------------------------------------------------------------------------------
% File     : KRS149+1 : TPTP v9.2.0. Released v3.1.0.
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: k_grz ABox test from DL98 systems comparison
% Version  : Especial.
% English  :

% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : positive_description-logic-Manifest204 [Bec03]

% Status   : Theorem
% Rating   : 0.00 v6.1.0, 0.08 v6.0.0, 0.25 v5.5.0, 0.08 v5.4.0, 0.13 v5.3.0, 0.17 v5.2.0, 0.07 v5.0.0, 0.05 v4.1.0, 0.00 v3.2.0, 0.11 v3.1.0
% Syntax   : Number of formulae    :  126 (  12 unt;   0 def)
%            Number of atoms       :  356 (   0 equ)
%            Maximal formula atoms :   12 (   2 avg)
%            Number of connectives :  322 (  92   ~;   0   |; 117   &)
%                                         ( 108 <=>;   5  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   10 (   5 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of predicates  :  115 ( 115 usr;   0 prp; 1-2 aty)
%            Number of functors    :    1 (   1 usr;   1 con; 0-0 aty)
%            Number of variables   :  169 ( 115   !;  54   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
%------------------------------------------------------------------------------
%----Thing and Nothing
fof(axiom_0,axiom,
    ! [X] :
      ( cowlThing(X)
      & ~ cowlNothing(X) ) ).

%----String and Integer disjoint
fof(axiom_1,axiom,
    ! [X] :
      ( xsd_string(X)
    <=> ~ xsd_integer(X) ) ).

%----Equality cC10
fof(axiom_2,axiom,
    ! [X] :
      ( cC10(X)
    <=> ( ~ cC8(X)
        & ~ cC2(X) ) ) ).

%----Equality cC100
fof(axiom_3,axiom,
    ! [X] :
      ( cC100(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & ~ cC98(Y) ) ) ).

%----Equality cC102
fof(axiom_4,axiom,
    ! [X] :
      ( cC102(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & ~ cC16(Y) ) ) ).

%----Equality cC104
fof(axiom_5,axiom,
    ! [X] :
      ( cC104(X)
    <=> ( cC102(X)
        & cC16(X) ) ) ).

%----Equality cC106
fof(axiom_6,axiom,
    ! [X] :
      ( cC106(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC104(Y) ) ) ).

%----Equality cC108
fof(axiom_7,axiom,
    ! [X] :
      ( cC108(X)
    <=> ( ~ cC106(X)
        & ~ cC16(X) ) ) ).

%----Equality cC110
fof(axiom_8,axiom,
    ! [X] :
      ( cC110(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & ~ cC16(Y) ) ) ).

%----Equality cC112
fof(axiom_9,axiom,
    ! [X] :
      ( cC112(X)
    <=> ( cC110(X)
        & cC16(X) ) ) ).

%----Equality cC114
fof(axiom_10,axiom,
    ! [X] :
      ( cC114(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC112(Y) ) ) ).

%----Equality cC116
fof(axiom_11,axiom,
    ! [X] :
      ( cC116(X)
    <=> ( ~ cC16(X)
        & ~ cC114(X) ) ) ).

%----Equality cC118
fof(axiom_12,axiom,
    ! [X] :
      ( cC118(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC116(Y) ) ) ).

%----Equality cC12
fof(axiom_13,axiom,
    ! [X] :
      ( cC12(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC10(Y) ) ) ).

%----Equality cC120
fof(axiom_14,axiom,
    ! [X] :
      ( cC120(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC118(Y) ) ) ).

%----Equality cC122
fof(axiom_15,axiom,
    ! [X] :
      ( cC122(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & ~ cC16(Y) ) ) ).

%----Equality cC124
fof(axiom_16,axiom,
    ! [X] :
      ( cC124(X)
    <=> ( cC122(X)
        & cC16(X) ) ) ).

%----Equality cC126
fof(axiom_17,axiom,
    ! [X] :
      ( cC126(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC124(Y) ) ) ).

%----Equality cC128
fof(axiom_18,axiom,
    ! [X] :
      ( cC128(X)
    <=> ( ~ cC16(X)
        & ~ cC126(X) ) ) ).

%----Equality cC130
fof(axiom_19,axiom,
    ! [X] :
      ( cC130(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC128(Y) ) ) ).

%----Equality cC132
fof(axiom_20,axiom,
    ! [X] :
      ( cC132(X)
    <=> ( ~ cC130(X)
        & cC120(X) ) ) ).

%----Equality cC134
fof(axiom_21,axiom,
    ! [X] :
      ( cC134(X)
    <=> ( ~ cC132(X)
        & ~ cC108(X) ) ) ).

%----Equality cC136
fof(axiom_22,axiom,
    ! [X] :
      ( cC136(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & ~ cC16(Y) ) ) ).

%----Equality cC138
fof(axiom_23,axiom,
    ! [X] :
      ( cC138(X)
    <=> ( cC136(X)
        & cC16(X) ) ) ).

%----Equality cC14
fof(axiom_24,axiom,
    ! [X] :
      ( cC14(X)
    <=> ( ~ cC12(X)
        & ~ cC2(X) ) ) ).

%----Equality cC140
fof(axiom_25,axiom,
    ! [X] :
      ( cC140(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC138(Y) ) ) ).

%----Equality cC142
fof(axiom_26,axiom,
    ! [X] :
      ( cC142(X)
    <=> ( ~ cC140(X)
        & ~ cC16(X) ) ) ).

%----Equality cC144
fof(axiom_27,axiom,
    ! [X] :
      ( cC144(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & ~ cC16(Y) ) ) ).

%----Equality cC146
fof(axiom_28,axiom,
    ! [X] :
      ( cC146(X)
    <=> ( cC144(X)
        & cC16(X) ) ) ).

%----Equality cC148
fof(axiom_29,axiom,
    ! [X] :
      ( cC148(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC146(Y) ) ) ).

%----Equality cC150
fof(axiom_30,axiom,
    ! [X] :
      ( cC150(X)
    <=> ( ~ cC16(X)
        & ~ cC148(X) ) ) ).

%----Equality cC152
fof(axiom_31,axiom,
    ! [X] :
      ( cC152(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC150(Y) ) ) ).

%----Equality cC154
fof(axiom_32,axiom,
    ! [X] :
      ( cC154(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC152(Y) ) ) ).

%----Equality cC156
fof(axiom_33,axiom,
    ! [X] :
      ( cC156(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & ~ cC16(Y) ) ) ).

%----Equality cC158
fof(axiom_34,axiom,
    ! [X] :
      ( cC158(X)
    <=> ( cC156(X)
        & cC16(X) ) ) ).

%----Equality cC160
fof(axiom_35,axiom,
    ! [X] :
      ( cC160(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC158(Y) ) ) ).

%----Equality cC162
fof(axiom_36,axiom,
    ! [X] :
      ( cC162(X)
    <=> ( ~ cC16(X)
        & ~ cC160(X) ) ) ).

%----Equality cC164
fof(axiom_37,axiom,
    ! [X] :
      ( cC164(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC162(Y) ) ) ).

%----Equality cC166
fof(axiom_38,axiom,
    ! [X] :
      ( cC166(X)
    <=> ( cC154(X)
        & ~ cC164(X) ) ) ).

%----Equality cC168
fof(axiom_39,axiom,
    ! [X] :
      ( cC168(X)
    <=> ( ~ cC166(X)
        & ~ cC142(X) ) ) ).

%----Equality cC170
fof(axiom_40,axiom,
    ! [X] :
      ( cC170(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & ~ cC168(Y) ) ) ).

%----Equality cC172
fof(axiom_41,axiom,
    ! [X] :
      ( cC172(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & ~ cC16(Y) ) ) ).

%----Equality cC174
fof(axiom_42,axiom,
    ! [X] :
      ( cC174(X)
    <=> ( cC172(X)
        & cC16(X) ) ) ).

%----Equality cC176
fof(axiom_43,axiom,
    ! [X] :
      ( cC176(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC174(Y) ) ) ).

%----Equality cC178
fof(axiom_44,axiom,
    ! [X] :
      ( cC178(X)
    <=> ( ~ cC16(X)
        & ~ cC176(X) ) ) ).

%----Equality cC18
fof(axiom_45,axiom,
    ! [X] :
      ( cC18(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & ~ cC16(Y) ) ) ).

%----Equality cC180
fof(axiom_46,axiom,
    ! [X] :
      ( cC180(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & ~ cC16(Y) ) ) ).

%----Equality cC182
fof(axiom_47,axiom,
    ! [X] :
      ( cC182(X)
    <=> ( cC16(X)
        & cC180(X) ) ) ).

%----Equality cC184
fof(axiom_48,axiom,
    ! [X] :
      ( cC184(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC182(Y) ) ) ).

%----Equality cC186
fof(axiom_49,axiom,
    ! [X] :
      ( cC186(X)
    <=> ( ~ cC16(X)
        & ~ cC184(X) ) ) ).

%----Equality cC188
fof(axiom_50,axiom,
    ! [X] :
      ( cC188(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC186(Y) ) ) ).

%----Equality cC190
fof(axiom_51,axiom,
    ! [X] :
      ( cC190(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC188(Y) ) ) ).

%----Equality cC192
fof(axiom_52,axiom,
    ! [X] :
      ( cC192(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & ~ cC16(Y) ) ) ).

%----Equality cC194
fof(axiom_53,axiom,
    ! [X] :
      ( cC194(X)
    <=> ( cC192(X)
        & cC16(X) ) ) ).

%----Equality cC196
fof(axiom_54,axiom,
    ! [X] :
      ( cC196(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC194(Y) ) ) ).

%----Equality cC198
fof(axiom_55,axiom,
    ! [X] :
      ( cC198(X)
    <=> ( ~ cC196(X)
        & ~ cC16(X) ) ) ).

%----Equality cC20
fof(axiom_56,axiom,
    ! [X] :
      ( cC20(X)
    <=> ( cC18(X)
        & cC16(X) ) ) ).

%----Equality cC200
fof(axiom_57,axiom,
    ! [X] :
      ( cC200(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC198(Y) ) ) ).

%----Equality cC202
fof(axiom_58,axiom,
    ! [X] :
      ( cC202(X)
    <=> ( cC190(X)
        & ~ cC200(X) ) ) ).

%----Equality cC204
fof(axiom_59,axiom,
    ! [X] :
      ( cC204(X)
    <=> ( ~ cC178(X)
        & ~ cC202(X) ) ) ).

%----Equality cC206
fof(axiom_60,axiom,
    ! [X] :
      ( cC206(X)
    <=> ( cC170(X)
        & cC204(X) ) ) ).

%----Equality cC208
fof(axiom_61,axiom,
    ! [X] :
      ( cC208(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC206(Y) ) ) ).

%----Equality cC210
fof(axiom_62,axiom,
    ! [X] :
      ( cC210(X)
    <=> ( ~ cC208(X)
        & ~ cC134(X) ) ) ).

%----Equality cC212
fof(axiom_63,axiom,
    ! [X] :
      ( cC212(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC210(Y) ) ) ).

%----Equality cC214
fof(axiom_64,axiom,
    ! [X] :
      ( cC214(X)
    <=> ( cC100(X)
        & ~ cC212(X) ) ) ).

%----Equality cC216
fof(axiom_65,axiom,
    ! [X] :
      ( cC216(X)
    <=> ( ~ cC214(X)
        & cC64(X) ) ) ).

%----Equality cC22
fof(axiom_66,axiom,
    ! [X] :
      ( cC22(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC20(Y) ) ) ).

%----Equality cC24
fof(axiom_67,axiom,
    ! [X] :
      ( cC24(X)
    <=> ( ~ cC22(X)
        & ~ cC16(X) ) ) ).

%----Equality cC26
fof(axiom_68,axiom,
    ! [X] :
      ( cC26(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC24(Y) ) ) ).

%----Equality cC28
fof(axiom_69,axiom,
    ! [X] :
      ( cC28(X)
    <=> ( ~ cC26(X)
        & ~ cC16(X) ) ) ).

%----Equality cC30
fof(axiom_70,axiom,
    ! [X] :
      ( cC30(X)
    <=> ( cC14(X)
        & cC28(X) ) ) ).

%----Equality cC34
fof(axiom_71,axiom,
    ! [X] :
      ( cC34(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & ~ cC32(Y) ) ) ).

%----Equality cC36
fof(axiom_72,axiom,
    ! [X] :
      ( cC36(X)
    <=> ( cC32(X)
        & cC34(X) ) ) ).

%----Equality cC38
fof(axiom_73,axiom,
    ! [X] :
      ( cC38(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC36(Y) ) ) ).

%----Equality cC4
fof(axiom_74,axiom,
    ! [X] :
      ( cC4(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & ~ cC2(Y) ) ) ).

%----Equality cC40
fof(axiom_75,axiom,
    ! [X] :
      ( cC40(X)
    <=> ( ~ cC38(X)
        & ~ cC32(X) ) ) ).

%----Equality cC42
fof(axiom_76,axiom,
    ! [X] :
      ( cC42(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC40(Y) ) ) ).

%----Equality cC44
fof(axiom_77,axiom,
    ! [X] :
      ( cC44(X)
    <=> ( ~ cC32(X)
        & ~ cC42(X) ) ) ).

%----Equality cC46
fof(axiom_78,axiom,
    ! [X] :
      ( cC46(X)
    <=> ( cC30(X)
        & cC44(X) ) ) ).

%----Equality cC48
fof(axiom_79,axiom,
    ! [X] :
      ( cC48(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & ~ cC16(Y) ) ) ).

%----Equality cC50
fof(axiom_80,axiom,
    ! [X] :
      ( cC50(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & ~ cC16(Y) ) ) ).

%----Equality cC52
fof(axiom_81,axiom,
    ! [X] :
      ( cC52(X)
    <=> ( cC50(X)
        & cC16(X) ) ) ).

%----Equality cC54
fof(axiom_82,axiom,
    ! [X] :
      ( cC54(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC52(Y) ) ) ).

%----Equality cC56
fof(axiom_83,axiom,
    ! [X] :
      ( cC56(X)
    <=> ( ~ cC16(X)
        & ~ cC54(X) ) ) ).

%----Equality cC58
fof(axiom_84,axiom,
    ! [X] :
      ( cC58(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC56(Y) ) ) ).

%----Equality cC6
fof(axiom_85,axiom,
    ! [X] :
      ( cC6(X)
    <=> ( cC2(X)
        & cC4(X) ) ) ).

%----Equality cC60
fof(axiom_86,axiom,
    ! [X] :
      ( cC60(X)
    <=> ( cC48(X)
        & ~ cC58(X) ) ) ).

%----Equality cC62
fof(axiom_87,axiom,
    ! [X] :
      ( cC62(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC60(Y) ) ) ).

%----Equality cC64
fof(axiom_88,axiom,
    ! [X] :
      ( cC64(X)
    <=> ( ~ cC62(X)
        & cTOP(X) ) ) ).

%----Equality cC66
fof(axiom_89,axiom,
    ! [X] :
      ( cC66(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & ~ cC16(Y) ) ) ).

%----Equality cC68
fof(axiom_90,axiom,
    ! [X] :
      ( cC68(X)
    <=> ( cC66(X)
        & cC16(X) ) ) ).

%----Equality cC70
fof(axiom_91,axiom,
    ! [X] :
      ( cC70(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC68(Y) ) ) ).

%----Equality cC72
fof(axiom_92,axiom,
    ! [X] :
      ( cC72(X)
    <=> ( ~ cC70(X)
        & ~ cC16(X) ) ) ).

%----Equality cC74
fof(axiom_93,axiom,
    ! [X] :
      ( cC74(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & ~ cC16(Y) ) ) ).

%----Equality cC76
fof(axiom_94,axiom,
    ! [X] :
      ( cC76(X)
    <=> ( cC74(X)
        & cC16(X) ) ) ).

%----Equality cC78
fof(axiom_95,axiom,
    ! [X] :
      ( cC78(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC76(Y) ) ) ).

%----Equality cC8
fof(axiom_96,axiom,
    ! [X] :
      ( cC8(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC6(Y) ) ) ).

%----Equality cC80
fof(axiom_97,axiom,
    ! [X] :
      ( cC80(X)
    <=> ( ~ cC16(X)
        & ~ cC78(X) ) ) ).

%----Equality cC82
fof(axiom_98,axiom,
    ! [X] :
      ( cC82(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC80(Y) ) ) ).

%----Equality cC84
fof(axiom_99,axiom,
    ! [X] :
      ( cC84(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC82(Y) ) ) ).

%----Equality cC86
fof(axiom_100,axiom,
    ! [X] :
      ( cC86(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & ~ cC16(Y) ) ) ).

%----Equality cC88
fof(axiom_101,axiom,
    ! [X] :
      ( cC88(X)
    <=> ( cC86(X)
        & cC16(X) ) ) ).

%----Equality cC90
fof(axiom_102,axiom,
    ! [X] :
      ( cC90(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC88(Y) ) ) ).

%----Equality cC92
fof(axiom_103,axiom,
    ! [X] :
      ( cC92(X)
    <=> ( ~ cC90(X)
        & ~ cC16(X) ) ) ).

%----Equality cC94
fof(axiom_104,axiom,
    ! [X] :
      ( cC94(X)
    <=> ? [Y] :
          ( rR1(X,Y)
          & cC92(Y) ) ) ).

%----Equality cC96
fof(axiom_105,axiom,
    ! [X] :
      ( cC96(X)
    <=> ( cC84(X)
        & ~ cC94(X) ) ) ).

%----Equality cC98
fof(axiom_106,axiom,
    ! [X] :
      ( cC98(X)
    <=> ( ~ cC72(X)
        & ~ cC96(X) ) ) ).

%----Equality cTEST
fof(axiom_107,axiom,
    ! [X] :
      ( cTEST(X)
    <=> ( cC216(X)
        & cC46(X) ) ) ).

%----iV3102
fof(axiom_108,axiom,
    cTEST(iV3102) ).

%----iV3102
fof(axiom_109,axiom,
    cowlThing(iV3102) ).

%----iV3102
fof(axiom_110,axiom,
    ! [X] :
      ( rR1(iV3102,X)
     => ~ cC60(X) ) ).

%----iV3102
fof(axiom_111,axiom,
    ! [X] :
      ( rR1(iV3102,X)
     => ~ cC10(X) ) ).

%----iV3102
fof(axiom_112,axiom,
    cTOP(iV3102) ).

%----iV3102
fof(axiom_113,axiom,
    ! [X] :
      ( rR1(iV3102,X)
     => ~ cC24(X) ) ).

%----iV3102
fof(axiom_114,axiom,
    ~ cC42(iV3102) ).

%----iV3102
fof(axiom_115,axiom,
    ~ cC12(iV3102) ).

%----iV3102
fof(axiom_116,axiom,
    ~ cC26(iV3102) ).

%----iV3102
fof(axiom_117,axiom,
    ! [X] :
      ( rR1(iV3102,X)
     => cC98(X) ) ).

%----iV3102
fof(axiom_118,axiom,
    ~ cC214(iV3102) ).

%----iV3102
fof(axiom_119,axiom,
    ~ cC62(iV3102) ).

%----iV3102
fof(axiom_120,axiom,
    ! [X] :
      ( rR1(iV3102,X)
     => ~ cC40(X) ) ).

%----iV3102
fof(axiom_121,axiom,
    ~ cC16(iV3102) ).

%----iV3102
fof(axiom_122,axiom,
    ~ cC2(iV3102) ).

%----iV3102
fof(axiom_123,axiom,
    ~ cC32(iV3102) ).

%----iV3102
fof(axiom_124,axiom,
    ~ cC100(iV3102) ).

%----Thing and Nothing
%----String and Integer disjoint
%----iV3102
%----iV3102
%----iV3102
%----iV3102
%----iV3102
%----iV3102
%----iV3102
%----iV3102
fof(the_axiom,conjecture,
    ( ! [X] :
        ( cowlThing(X)
        & ~ cowlNothing(X) )
    & ! [X] :
        ( xsd_string(X)
      <=> ~ xsd_integer(X) )
    & cC216(iV3102)
    & cC46(iV3102)
    & cC30(iV3102)
    & cC44(iV3102)
    & cC28(iV3102)
    & cC64(iV3102)
    & cC14(iV3102)
    & cowlThing(iV3102) ) ).

%------------------------------------------------------------------------------
