%------------------------------------------------------------------------------
% File     : KRS101+1 : TPTP v9.2.0. Released v3.1.0.
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: heinsohn4.2
% Version  : Especial.
% English  : Tbox tests from [HK+94]

% Refs     : [HK+94] Heinsohn et al. (1994), An Empirical Analysis of Termi
%          : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : inconsistent_description-logic-Manifest111 [Bec03]

% Status   : Unsatisfiable
% Rating   : 0.00 v3.1.0
% Syntax   : Number of formulae    :   16 (   1 unt;   0 def)
%            Number of atoms       :   52 (  13 equ)
%            Maximal formula atoms :   12 (   3 avg)
%            Number of connectives :   42 (   6   ~;   1   |;  18   &)
%                                         (   2 <=>;  15  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   5 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of predicates  :   10 (   9 usr;   0 prp; 1-2 aty)
%            Number of functors    :    1 (   1 usr;   1 con; 0-0 aty)
%            Number of variables   :   37 (  34   !;   3   ?)
% SPC      : FOF_UNS_RFO_SEQ

% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
%          : Tests role restrictions
%------------------------------------------------------------------------------
fof(cUnsatisfiable_substitution_1,axiom,
    ! [A,B] :
      ( ( A = B
        & cUnsatisfiable(A) )
     => cUnsatisfiable(B) ) ).

fof(cc_substitution_1,axiom,
    ! [A,B] :
      ( ( A = B
        & cc(A) )
     => cc(B) ) ).

fof(cd_substitution_1,axiom,
    ! [A,B] :
      ( ( A = B
        & cd(A) )
     => cd(B) ) ).

fof(cowlNothing_substitution_1,axiom,
    ! [A,B] :
      ( ( A = B
        & cowlNothing(A) )
     => cowlNothing(B) ) ).

fof(cowlThing_substitution_1,axiom,
    ! [A,B] :
      ( ( A = B
        & cowlThing(A) )
     => cowlThing(B) ) ).

fof(rr_substitution_1,axiom,
    ! [A,B,C] :
      ( ( A = B
        & rr(A,C) )
     => rr(B,C) ) ).

fof(rr_substitution_2,axiom,
    ! [A,B,C] :
      ( ( A = B
        & rr(C,A) )
     => rr(C,B) ) ).

fof(rs_substitution_1,axiom,
    ! [A,B,C] :
      ( ( A = B
        & rs(A,C) )
     => rs(B,C) ) ).

fof(rs_substitution_2,axiom,
    ! [A,B,C] :
      ( ( A = B
        & rs(C,A) )
     => rs(C,B) ) ).

fof(xsd_integer_substitution_1,axiom,
    ! [A,B] :
      ( ( A = B
        & xsd_integer(A) )
     => xsd_integer(B) ) ).

fof(xsd_string_substitution_1,axiom,
    ! [A,B] :
      ( ( A = B
        & xsd_string(A) )
     => xsd_string(B) ) ).

%----Thing and Nothing
fof(axiom_0,axiom,
    ! [X] :
      ( cowlThing(X)
      & ~ cowlNothing(X) ) ).

%----String and Integer disjoint
fof(axiom_1,axiom,
    ! [X] :
      ( xsd_string(X)
    <=> ~ xsd_integer(X) ) ).

%----Equality cUnsatisfiable
fof(axiom_2,axiom,
    ! [X] :
      ( cUnsatisfiable(X)
    <=> ( ! [Y] :
            ( rr(X,Y)
           => cd(Y) )
        & ! [Y] :
            ( rr(X,Y)
           => ( ~ ? [Z0,Z1] :
                    ( rs(Y,Z0)
                    & rs(Y,Z1)
                    & Z0 != Z1 )
              | cc(Y) ) )
        & ? [Y] :
            ( rr(X,Y)
            & ~ ! [Z0,Z1] :
                  ( ( rs(Y,Z0)
                    & rs(Y,Z1) )
                 => Z0 = Z1 ) ) ) ) ).

%----Super cc
fof(axiom_3,axiom,
    ! [X] :
      ( cc(X)
     => ~ cd(X) ) ).

%----i2003_11_14_17_20_36582
fof(axiom_4,axiom,
    cUnsatisfiable(i2003_11_14_17_20_36582) ).

%------------------------------------------------------------------------------
