%------------------------------------------------------------------------------
% File     : KLE169+1 : TPTP v9.2.0. Released v5.2.0.
% Domain   : Kleene Algebra (Regular Expressions)
% Problem  : Exponential automata
% Version  : [Hoe08] axioms.
% English  : Automata grows exponentially with N in sigma*.a.sigma^N.a

% Refs     : [Hoe08] Hoefner (2008), Email to G. Sutcliffe
% Source   : [TPTP]
% Names    :

% Status   : Theorem
% Rating   : 0.61 v9.1.0, 0.70 v9.0.0, 0.67 v8.2.0, 0.72 v7.5.0, 0.78 v7.4.0, 0.63 v7.3.0, 0.69 v7.1.0, 0.61 v7.0.0, 0.67 v6.4.0, 0.69 v6.3.0, 0.62 v6.2.0, 0.72 v6.1.0, 0.73 v6.0.0, 0.78 v5.5.0, 0.85 v5.4.0, 0.89 v5.2.0
% Syntax   : Number of formulae    :   18 (  15 unt;   0 def)
%            Number of atoms       :   21 (  13 equ)
%            Maximal formula atoms :    2 (   1 avg)
%            Number of connectives :    3 (   0   ~;   0   |;   0   &)
%                                         (   1 <=>;   2  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    5 (   3 avg)
%            Maximal term depth    :    4 (   2 avg)
%            Number of predicates  :    2 (   1 usr;   0 prp; 2-2 aty)
%            Number of functors    :    8 (   8 usr;   5 con; 0-2 aty)
%            Number of variables   :   30 (  30   !;   0   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : 
%------------------------------------------------------------------------------
%----Include axioms of Kleene algebra
include('Axioms/KLE002+0.ax').
%------------------------------------------------------------------------------
fof(an,axiom,
    sigma = addition(a,b) ).

fof(a,conjecture,
    leq(multiplication(a,multiplication(b,a)),multiplication(star(sigma),multiplication(a,multiplication(sigma,a)))) ).

%------------------------------------------------------------------------------
