%------------------------------------------------------------------------------
% File     : KLE134+1 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Kleene Algebra (Modal Semirings)
% Problem  : A no name lemma
% Version  : [Hoe08] axioms.
% English  :

% Refs     : [DMS04] Desharnais et al. (2004), Termination in Modal Kleene
%          : [Hoe08] Hoefner (2008), Email to G. Sutcliffe
% Source   : [Hoe08]
% Names    :

% Status   : Theorem
% Rating   : 1.00 v9.1.0, 0.97 v9.0.0, 1.00 v7.0.0, 0.93 v6.4.0, 1.00 v6.1.0, 0.97 v6.0.0, 1.00 v5.3.0, 0.96 v5.2.0, 0.95 v5.0.0, 1.00 v4.0.0
% Syntax   : Number of formulae    :   27 (  26 unt;   0 def)
%            Number of atoms       :   28 (  27 equ)
%            Maximal formula atoms :    2 (   1 avg)
%            Number of connectives :    1 (   0   ~;   0   |;   0   &)
%                                         (   1 <=>;   0  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    4 (   3 avg)
%            Maximal term depth    :    6 (   2 avg)
%            Number of predicates  :    2 (   1 usr;   0 prp; 2-2 aty)
%            Number of functors    :   14 (  14 usr;   2 con; 0-2 aty)
%            Number of variables   :   46 (  46   !;   0   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : Equational encoding
%------------------------------------------------------------------------------
%---Include axioms for modal semiring
include('Axioms/KLE001+0.ax').
%---Include axioms for Boolean domain/codomain
include('Axioms/KLE001+4.ax').
%---Include axioms for diamond and boxes
include('Axioms/KLE001+6.ax').
%------------------------------------------------------------------------------
fof(goals,conjecture,
    ! [X0,X1,X2] : addition(domain_difference(forward_diamond(X0,domain(X1)),forward_diamond(X0,domain(X2))),forward_diamond(X0,domain_difference(domain(X1),domain(X2)))) = forward_diamond(X0,domain_difference(domain(X1),domain(X2))) ).

%------------------------------------------------------------------------------
