%------------------------------------------------------------------------------
% File     : KLE028+3 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Kleene Algebra (Idempotent Test Semirings)
% Problem  : Switch nested conditions and rearrange branches of conditional
% Version  : [Hoe08] axioms : Augmented.
% English  : If p then (if q then u else x) else (if q then y else z) =
%            if q then (if p then u else y) else (if p then x else z).

% Refs     : [Hoe08] Hoefner (2008), Email to G. Sutcliffe
% Source   : [Hoe08]
% Names    :

% Status   : Theorem
% Rating   : 0.70 v9.0.0, 0.75 v8.1.0, 0.81 v7.4.0, 0.70 v7.3.0, 0.72 v7.1.0, 0.70 v7.0.0, 0.73 v6.3.0, 0.71 v6.2.0, 0.84 v6.1.0, 0.90 v6.0.0, 0.78 v5.5.0, 0.85 v5.4.0, 0.82 v5.3.0, 0.85 v5.2.0, 0.90 v5.0.0, 0.92 v4.1.0, 0.91 v4.0.0
% Syntax   : Number of formulae    :   19 (  11 unt;   0 def)
%            Number of atoms       :   33 (  20 equ)
%            Maximal formula atoms :    4 (   1 avg)
%            Number of connectives :   15 (   1   ~;   0   |;   5   &)
%                                         (   4 <=>;   5  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    9 (   4 avg)
%            Maximal term depth    :    6 (   2 avg)
%            Number of predicates  :    4 (   3 usr;   0 prp; 1-2 aty)
%            Number of functors    :    5 (   5 usr;   2 con; 0-2 aty)
%            Number of variables   :   39 (  38   !;   1   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : Equational encoding : additionally the de Morgan laws
%------------------------------------------------------------------------------
%---Include axioms for idempotent test semiring
include('Axioms/KLE001+0.ax').
%---Include test axioms
include('Axioms/KLE001+1.ax').
%---Include additionally axioms
include('Axioms/KLE001+2.ax').
%------------------------------------------------------------------------------
fof(goals,conjecture,
    ! [X0,X1,X2,X3,X4,X5] :
      ( ( test(X4)
        & test(X5) )
     => addition(multiplication(X4,addition(multiplication(X5,X0),multiplication(c(X5),X1))),multiplication(c(X4),addition(multiplication(X5,X2),multiplication(c(X5),X3)))) = addition(multiplication(X5,addition(multiplication(X4,X0),multiplication(c(X4),X2))),multiplication(c(X5),addition(multiplication(X4,X1),multiplication(c(X4),X3)))) ) ).

%------------------------------------------------------------------------------
