%------------------------------------------------------------------------------
% File     : ITP018_5 : TPTP v9.2.0. Bugfixed v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : HOL4 set theory export of thm_2Ebinary__ieee_2Eneg__ulp.p, chainy mode
% Version  : [BG+19] axioms.
% English  :

% Refs     : [BG+19] Brown et al. (2019), GRUNGE: A Grand Unified ATP Chall
%          : [Gau20] Gauthier (2020), Email to Geoff Sutcliffe
% Source   : [BG+19]
% Names    : thm_2Ebinary__ieee_2Eneg__ulp.p [Gau20]
%          : HL408501_5.p [TPAP]

% Status   : Theorem
% Rating   : 0.75 v9.1.0, 0.80 v9.0.0, 0.89 v8.2.0, 1.00 v7.5.0
% Syntax   : Number of formulae    : 22823 (5063 unt;5848 typ;   0 def)
%            Number of atoms       : 422014 (18560 equ)
%            Maximal formula atoms : 5763 (  18 avg)
%            Number of connectives : 65332 (1906   ~; 871   |;24154   &)
%                                         (5505 <=>;32896  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  361 (   7 avg)
%            Maximal term depth    :  132 (   2 avg)
%            Number of FOOLs       : 341613 (341613 fml;   0 var)
%            Number of types       :  118 ( 116 usr)
%            Number of type conns  : 11362 (4866   >;6496   *;   0   +;   0  <<)
%            Number of predicates  :  110 ( 107 usr;  47 prp; 0-3 aty)
%            Number of functors    : 5730 (5730 usr; 866 con; 0-11 aty)
%            Number of variables   : 72292 (58581   !;13711   ?;72292   :)
% SPC      : TF0_THM_EQU_NAR

% Comments :
% Bugfixes : v7.5.0 - Bugfixes in axioms and export.
%------------------------------------------------------------------------------
include('Axioms/ITP001/ITP001_2.ax').
include('Axioms/ITP001/ITP002_5.ax').
include('Axioms/ITP001/ITP003_5.ax').
include('Axioms/ITP001/ITP004_5.ax').
include('Axioms/ITP001/ITP007_5.ax').
include('Axioms/ITP001/ITP006_5.ax').
include('Axioms/ITP001/ITP005_5.ax').
include('Axioms/ITP001/ITP008_5.ax').
include('Axioms/ITP001/ITP009_5.ax').
include('Axioms/ITP001/ITP010_5.ax').
include('Axioms/ITP001/ITP012_5.ax').
include('Axioms/ITP001/ITP011_5.ax').
include('Axioms/ITP001/ITP013_5.ax').
include('Axioms/ITP001/ITP014_5.ax').
include('Axioms/ITP001/ITP015_5.ax').
include('Axioms/ITP001/ITP017_5.ax').
include('Axioms/ITP001/ITP016_5.ax').
include('Axioms/ITP001/ITP019_5.ax').
include('Axioms/ITP001/ITP018_5.ax').
include('Axioms/ITP001/ITP021_5.ax').
include('Axioms/ITP001/ITP022_5.ax').
include('Axioms/ITP001/ITP020_5.ax').
include('Axioms/ITP001/ITP024_5.ax').
include('Axioms/ITP001/ITP023_5.ax').
include('Axioms/ITP001/ITP025_5.ax').
include('Axioms/ITP001/ITP026_5.ax').
include('Axioms/ITP001/ITP027_5.ax').
include('Axioms/ITP001/ITP028_5.ax').
include('Axioms/ITP001/ITP031_5.ax').
include('Axioms/ITP001/ITP029_5.ax').
include('Axioms/ITP001/ITP033_5.ax').
include('Axioms/ITP001/ITP030_5.ax').
include('Axioms/ITP001/ITP032_5.ax').
include('Axioms/ITP001/ITP038_5.ax').
include('Axioms/ITP001/ITP035_5.ax').
include('Axioms/ITP001/ITP034_5.ax').
include('Axioms/ITP001/ITP036_5.ax').
include('Axioms/ITP001/ITP037_5.ax').
include('Axioms/ITP001/ITP039_5.ax').
include('Axioms/ITP001/ITP041_5.ax').
include('Axioms/ITP001/ITP042_5.ax').
include('Axioms/ITP001/ITP040_5.ax').
include('Axioms/ITP001/ITP044_5.ax').
include('Axioms/ITP001/ITP051_5.ax').
include('Axioms/ITP001/ITP045_5.ax').
include('Axioms/ITP001/ITP056_5.ax').
include('Axioms/ITP001/ITP046_5.ax').
include('Axioms/ITP001/ITP043_5.ax').
include('Axioms/ITP001/ITP052_5.ax').
include('Axioms/ITP001/ITP057_5.ax').
include('Axioms/ITP001/ITP048_5.ax').
include('Axioms/ITP001/ITP047_5.ax').
include('Axioms/ITP001/ITP055_5.ax').
include('Axioms/ITP001/ITP053_5.ax').
include('Axioms/ITP001/ITP054_5.ax').
include('Axioms/ITP001/ITP058_5.ax').
include('Axioms/ITP001/ITP049_5.ax').
include('Axioms/ITP001/ITP050_5.ax').
include('Axioms/ITP001/ITP061_5.ax').
include('Axioms/ITP001/ITP069_5.ax').
include('Axioms/ITP001/ITP062_5.ax').
include('Axioms/ITP001/ITP068_5.ax').
include('Axioms/ITP001/ITP078_5.ax').
include('Axioms/ITP001/ITP064_5.ax').
include('Axioms/ITP001/ITP060_5.ax').
include('Axioms/ITP001/ITP067_5.ax').
include('Axioms/ITP001/ITP075_5.ax').
include('Axioms/ITP001/ITP074_5.ax').
include('Axioms/ITP001/ITP063_5.ax').
include('Axioms/ITP001/ITP059_5.ax').
include('Axioms/ITP001/ITP065_5.ax').
include('Axioms/ITP001/ITP076_5.ax').
include('Axioms/ITP001/ITP066_5.ax').
include('Axioms/ITP001/ITP077_5.ax').
include('Axioms/ITP001/ITP070_5.ax').
include('Axioms/ITP001/ITP071_5.ax').
include('Axioms/ITP001/ITP072_5.ax').
include('Axioms/ITP001/ITP073_5.ax').
include('Axioms/ITP001/ITP080_5.ax').
include('Axioms/ITP001/ITP083_5.ax').
include('Axioms/ITP001/ITP088_5.ax').
include('Axioms/ITP001/ITP082_5.ax').
include('Axioms/ITP001/ITP081_5.ax').
include('Axioms/ITP001/ITP079_5.ax').
include('Axioms/ITP001/ITP087_5.ax').
include('Axioms/ITP001/ITP085_5.ax').
include('Axioms/ITP001/ITP086_5.ax').
include('Axioms/ITP001/ITP090_5.ax').
include('Axioms/ITP001/ITP089_5.ax').
include('Axioms/ITP001/ITP084_5.ax').
include('Axioms/ITP001/ITP104_5.ax').
include('Axioms/ITP001/ITP097_5.ax').
include('Axioms/ITP001/ITP094_5.ax').
include('Axioms/ITP001/ITP095_5.ax').
include('Axioms/ITP001/ITP093_5.ax').
include('Axioms/ITP001/ITP102_5.ax').
include('Axioms/ITP001/ITP091_5.ax').
include('Axioms/ITP001/ITP098_5.ax').
include('Axioms/ITP001/ITP096_5.ax').
include('Axioms/ITP001/ITP100_5.ax').
include('Axioms/ITP001/ITP092_5.ax').
include('Axioms/ITP001/ITP105_5.ax').
include('Axioms/ITP001/ITP101_5.ax').
include('Axioms/ITP001/ITP103_5.ax').
include('Axioms/ITP001/ITP099_5.ax').
include('Axioms/ITP001/ITP111_5.ax').
include('Axioms/ITP001/ITP108_5.ax').
include('Axioms/ITP001/ITP106_5.ax').
include('Axioms/ITP001/ITP107_5.ax').
include('Axioms/ITP001/ITP114_5.ax').
include('Axioms/ITP001/ITP110_5.ax').
include('Axioms/ITP001/ITP109_5.ax').
include('Axioms/ITP001/ITP112_5.ax').
include('Axioms/ITP001/ITP113_5.ax').
include('Axioms/ITP001/ITP117_5.ax').
include('Axioms/ITP001/ITP116_5.ax').
include('Axioms/ITP001/ITP118_5.ax').
include('Axioms/ITP001/ITP120_5.ax').
include('Axioms/ITP001/ITP119_5.ax').
include('Axioms/ITP001/ITP121_5.ax').
include('Axioms/ITP001/ITP123_5.ax').
include('Axioms/ITP001/ITP124_5.ax').
include('Axioms/ITP001/ITP126_5.ax').
include('Axioms/ITP001/ITP127_5.ax').
include('Axioms/ITP001/ITP129_5.ax').
include('Axioms/ITP001/ITP128_5.ax').
include('Axioms/ITP001/ITP130_5.ax').
include('Axioms/ITP001/ITP131_5.ax').
include('Axioms/ITP001/ITP132_5.ax').
%------------------------------------------------------------------------------
tff(tp_ty_2Ebinary__ieee_2Eflags,type,
    ty_2Ebinary__ieee_2Eflags: del ).

tff(tp_ty_2Ebinary__ieee_2Efloat,type,
    ty_2Ebinary__ieee_2Efloat: ( del * del ) > del ).

tff(tp_ty_2Ebinary__ieee_2Efloat__compare,type,
    ty_2Ebinary__ieee_2Efloat__compare: del ).

tff(tp_ty_2Ebinary__ieee_2Efloat__value,type,
    ty_2Ebinary__ieee_2Efloat__value: del ).

tff(tp_ty_2Ebinary__ieee_2Efp__op,type,
    ty_2Ebinary__ieee_2Efp__op: ( del * del ) > del ).

tff(tp_ty_2Ebinary__ieee_2Erounding,type,
    ty_2Ebinary__ieee_2Erounding: del ).

tff(stp_ty_2Ebinary__ieee_2Efloat__compare,type,
    tp__ty_2Ebinary__ieee_2Efloat__compare: $tType ).

tff(stp_inj_ty_2Ebinary__ieee_2Efloat__compare,type,
    inj__ty_2Ebinary__ieee_2Efloat__compare: tp__ty_2Ebinary__ieee_2Efloat__compare > $i ).

tff(stp_surj_ty_2Ebinary__ieee_2Efloat__compare,type,
    surj__ty_2Ebinary__ieee_2Efloat__compare: $i > tp__ty_2Ebinary__ieee_2Efloat__compare ).

tff(stp_inj_surj_ty_2Ebinary__ieee_2Efloat__compare,axiom,
    ! [X: tp__ty_2Ebinary__ieee_2Efloat__compare] : ( surj__ty_2Ebinary__ieee_2Efloat__compare(inj__ty_2Ebinary__ieee_2Efloat__compare(X)) = X ) ).

tff(stp_inj_mem_ty_2Ebinary__ieee_2Efloat__compare,axiom,
    ! [X: tp__ty_2Ebinary__ieee_2Efloat__compare] : mem(inj__ty_2Ebinary__ieee_2Efloat__compare(X),ty_2Ebinary__ieee_2Efloat__compare) ).

tff(stp_iso_mem_ty_2Ebinary__ieee_2Efloat__compare,axiom,
    ! [X: $i] :
      ( mem(X,ty_2Ebinary__ieee_2Efloat__compare)
     => ( X = inj__ty_2Ebinary__ieee_2Efloat__compare(surj__ty_2Ebinary__ieee_2Efloat__compare(X)) ) ) ).

tff(tp_c_2Ebinary__ieee_2EEQ,type,
    c_2Ebinary__ieee_2EEQ: $i ).

tff(mem_c_2Ebinary__ieee_2EEQ,axiom,
    mem(c_2Ebinary__ieee_2EEQ,ty_2Ebinary__ieee_2Efloat__compare) ).

tff(stp_fo_c_2Ebinary__ieee_2EEQ,type,
    fo__c_2Ebinary__ieee_2EEQ: tp__ty_2Ebinary__ieee_2Efloat__compare ).

tff(stp_eq_fo_c_2Ebinary__ieee_2EEQ,axiom,
    inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2EEQ) = c_2Ebinary__ieee_2EEQ ).

tff(stp_ty_2Ebinary__ieee_2Erounding,type,
    tp__ty_2Ebinary__ieee_2Erounding: $tType ).

tff(stp_inj_ty_2Ebinary__ieee_2Erounding,type,
    inj__ty_2Ebinary__ieee_2Erounding: tp__ty_2Ebinary__ieee_2Erounding > $i ).

tff(stp_surj_ty_2Ebinary__ieee_2Erounding,type,
    surj__ty_2Ebinary__ieee_2Erounding: $i > tp__ty_2Ebinary__ieee_2Erounding ).

tff(stp_inj_surj_ty_2Ebinary__ieee_2Erounding,axiom,
    ! [X: tp__ty_2Ebinary__ieee_2Erounding] : ( surj__ty_2Ebinary__ieee_2Erounding(inj__ty_2Ebinary__ieee_2Erounding(X)) = X ) ).

tff(stp_inj_mem_ty_2Ebinary__ieee_2Erounding,axiom,
    ! [X: tp__ty_2Ebinary__ieee_2Erounding] : mem(inj__ty_2Ebinary__ieee_2Erounding(X),ty_2Ebinary__ieee_2Erounding) ).

tff(stp_iso_mem_ty_2Ebinary__ieee_2Erounding,axiom,
    ! [X: $i] :
      ( mem(X,ty_2Ebinary__ieee_2Erounding)
     => ( X = inj__ty_2Ebinary__ieee_2Erounding(surj__ty_2Ebinary__ieee_2Erounding(X)) ) ) ).

tff(tp_c_2Ebinary__ieee_2EFP__Add,type,
    c_2Ebinary__ieee_2EFP__Add: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2EFP__Add,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))))) ).

tff(tp_c_2Ebinary__ieee_2EFP__Div,type,
    c_2Ebinary__ieee_2EFP__Div: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2EFP__Div,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))))) ).

tff(tp_c_2Ebinary__ieee_2EFP__Mul,type,
    c_2Ebinary__ieee_2EFP__Mul: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2EFP__Mul,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))))) ).

tff(tp_c_2Ebinary__ieee_2EFP__MulAdd,type,
    c_2Ebinary__ieee_2EFP__MulAdd: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2EFP__MulAdd,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w)))))) ).

tff(tp_c_2Ebinary__ieee_2EFP__MulSub,type,
    c_2Ebinary__ieee_2EFP__MulSub: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2EFP__MulSub,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w)))))) ).

tff(tp_c_2Ebinary__ieee_2EFP__Sqrt,type,
    c_2Ebinary__ieee_2EFP__Sqrt: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2EFP__Sqrt,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w)))) ).

tff(tp_c_2Ebinary__ieee_2EFP__Sub,type,
    c_2Ebinary__ieee_2EFP__Sub: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2EFP__Sub,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))))) ).

tff(stp_ty_2Ebinary__ieee_2Efloat__value,type,
    tp__ty_2Ebinary__ieee_2Efloat__value: $tType ).

tff(stp_inj_ty_2Ebinary__ieee_2Efloat__value,type,
    inj__ty_2Ebinary__ieee_2Efloat__value: tp__ty_2Ebinary__ieee_2Efloat__value > $i ).

tff(stp_surj_ty_2Ebinary__ieee_2Efloat__value,type,
    surj__ty_2Ebinary__ieee_2Efloat__value: $i > tp__ty_2Ebinary__ieee_2Efloat__value ).

tff(stp_inj_surj_ty_2Ebinary__ieee_2Efloat__value,axiom,
    ! [X: tp__ty_2Ebinary__ieee_2Efloat__value] : ( surj__ty_2Ebinary__ieee_2Efloat__value(inj__ty_2Ebinary__ieee_2Efloat__value(X)) = X ) ).

tff(stp_inj_mem_ty_2Ebinary__ieee_2Efloat__value,axiom,
    ! [X: tp__ty_2Ebinary__ieee_2Efloat__value] : mem(inj__ty_2Ebinary__ieee_2Efloat__value(X),ty_2Ebinary__ieee_2Efloat__value) ).

tff(stp_iso_mem_ty_2Ebinary__ieee_2Efloat__value,axiom,
    ! [X: $i] :
      ( mem(X,ty_2Ebinary__ieee_2Efloat__value)
     => ( X = inj__ty_2Ebinary__ieee_2Efloat__value(surj__ty_2Ebinary__ieee_2Efloat__value(X)) ) ) ).

tff(tp_c_2Ebinary__ieee_2EFloat,type,
    c_2Ebinary__ieee_2EFloat: $i ).

tff(mem_c_2Ebinary__ieee_2EFloat,axiom,
    mem(c_2Ebinary__ieee_2EFloat,arr(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat__value)) ).

tff(stp_fo_c_2Ebinary__ieee_2EFloat,type,
    fo__c_2Ebinary__ieee_2EFloat: tp__ty_2Erealax_2Ereal > tp__ty_2Ebinary__ieee_2Efloat__value ).

tff(stp_eq_fo_c_2Ebinary__ieee_2EFloat,axiom,
    ! [X0: tp__ty_2Erealax_2Ereal] : ( inj__ty_2Ebinary__ieee_2Efloat__value(fo__c_2Ebinary__ieee_2EFloat(X0)) = ap(c_2Ebinary__ieee_2EFloat,inj__ty_2Erealax_2Ereal(X0)) ) ).

tff(tp_c_2Ebinary__ieee_2EGT,type,
    c_2Ebinary__ieee_2EGT: $i ).

tff(mem_c_2Ebinary__ieee_2EGT,axiom,
    mem(c_2Ebinary__ieee_2EGT,ty_2Ebinary__ieee_2Efloat__compare) ).

tff(stp_fo_c_2Ebinary__ieee_2EGT,type,
    fo__c_2Ebinary__ieee_2EGT: tp__ty_2Ebinary__ieee_2Efloat__compare ).

tff(stp_eq_fo_c_2Ebinary__ieee_2EGT,axiom,
    inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2EGT) = c_2Ebinary__ieee_2EGT ).

tff(tp_c_2Ebinary__ieee_2EInfinity,type,
    c_2Ebinary__ieee_2EInfinity: $i ).

tff(mem_c_2Ebinary__ieee_2EInfinity,axiom,
    mem(c_2Ebinary__ieee_2EInfinity,ty_2Ebinary__ieee_2Efloat__value) ).

tff(stp_fo_c_2Ebinary__ieee_2EInfinity,type,
    fo__c_2Ebinary__ieee_2EInfinity: tp__ty_2Ebinary__ieee_2Efloat__value ).

tff(stp_eq_fo_c_2Ebinary__ieee_2EInfinity,axiom,
    inj__ty_2Ebinary__ieee_2Efloat__value(fo__c_2Ebinary__ieee_2EInfinity) = c_2Ebinary__ieee_2EInfinity ).

tff(tp_c_2Ebinary__ieee_2ELT,type,
    c_2Ebinary__ieee_2ELT: $i ).

tff(mem_c_2Ebinary__ieee_2ELT,axiom,
    mem(c_2Ebinary__ieee_2ELT,ty_2Ebinary__ieee_2Efloat__compare) ).

tff(stp_fo_c_2Ebinary__ieee_2ELT,type,
    fo__c_2Ebinary__ieee_2ELT: tp__ty_2Ebinary__ieee_2Efloat__compare ).

tff(stp_eq_fo_c_2Ebinary__ieee_2ELT,axiom,
    inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2ELT) = c_2Ebinary__ieee_2ELT ).

tff(tp_c_2Ebinary__ieee_2ENaN,type,
    c_2Ebinary__ieee_2ENaN: $i ).

tff(mem_c_2Ebinary__ieee_2ENaN,axiom,
    mem(c_2Ebinary__ieee_2ENaN,ty_2Ebinary__ieee_2Efloat__value) ).

tff(stp_fo_c_2Ebinary__ieee_2ENaN,type,
    fo__c_2Ebinary__ieee_2ENaN: tp__ty_2Ebinary__ieee_2Efloat__value ).

tff(stp_eq_fo_c_2Ebinary__ieee_2ENaN,axiom,
    inj__ty_2Ebinary__ieee_2Efloat__value(fo__c_2Ebinary__ieee_2ENaN) = c_2Ebinary__ieee_2ENaN ).

tff(tp_c_2Ebinary__ieee_2EULP,type,
    c_2Ebinary__ieee_2EULP: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2EULP,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2EULP(A_27t,A_27w),arr(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Ebool_2Eitself(A_27t)),ty_2Erealax_2Ereal)) ).

tff(tp_c_2Ebinary__ieee_2EUN,type,
    c_2Ebinary__ieee_2EUN: $i ).

tff(mem_c_2Ebinary__ieee_2EUN,axiom,
    mem(c_2Ebinary__ieee_2EUN,ty_2Ebinary__ieee_2Efloat__compare) ).

tff(stp_fo_c_2Ebinary__ieee_2EUN,type,
    fo__c_2Ebinary__ieee_2EUN: tp__ty_2Ebinary__ieee_2Efloat__compare ).

tff(stp_eq_fo_c_2Ebinary__ieee_2EUN,axiom,
    inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2EUN) = c_2Ebinary__ieee_2EUN ).

tff(stp_ty_2Ebinary__ieee_2Eflags,type,
    tp__ty_2Ebinary__ieee_2Eflags: $tType ).

tff(stp_inj_ty_2Ebinary__ieee_2Eflags,type,
    inj__ty_2Ebinary__ieee_2Eflags: tp__ty_2Ebinary__ieee_2Eflags > $i ).

tff(stp_surj_ty_2Ebinary__ieee_2Eflags,type,
    surj__ty_2Ebinary__ieee_2Eflags: $i > tp__ty_2Ebinary__ieee_2Eflags ).

tff(stp_inj_surj_ty_2Ebinary__ieee_2Eflags,axiom,
    ! [X: tp__ty_2Ebinary__ieee_2Eflags] : ( surj__ty_2Ebinary__ieee_2Eflags(inj__ty_2Ebinary__ieee_2Eflags(X)) = X ) ).

tff(stp_inj_mem_ty_2Ebinary__ieee_2Eflags,axiom,
    ! [X: tp__ty_2Ebinary__ieee_2Eflags] : mem(inj__ty_2Ebinary__ieee_2Eflags(X),ty_2Ebinary__ieee_2Eflags) ).

tff(stp_iso_mem_ty_2Ebinary__ieee_2Eflags,axiom,
    ! [X: $i] :
      ( mem(X,ty_2Ebinary__ieee_2Eflags)
     => ( X = inj__ty_2Ebinary__ieee_2Eflags(surj__ty_2Ebinary__ieee_2Eflags(X)) ) ) ).

tff(tp_c_2Ebinary__ieee_2Echeck__for__signalling,type,
    c_2Ebinary__ieee_2Echeck__for__signalling: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Echeck__for__signalling,axiom,
    ! [A_27a: del,A_27b: del] : mem(c_2Ebinary__ieee_2Echeck__for__signalling(A_27a,A_27b),arr(ty_2Elist_2Elist(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b)),ty_2Ebinary__ieee_2Eflags)) ).

tff(tp_c_2Ebinary__ieee_2Eclear__flags,type,
    c_2Ebinary__ieee_2Eclear__flags: $i ).

tff(mem_c_2Ebinary__ieee_2Eclear__flags,axiom,
    mem(c_2Ebinary__ieee_2Eclear__flags,ty_2Ebinary__ieee_2Eflags) ).

tff(stp_fo_c_2Ebinary__ieee_2Eclear__flags,type,
    fo__c_2Ebinary__ieee_2Eclear__flags: tp__ty_2Ebinary__ieee_2Eflags ).

tff(stp_eq_fo_c_2Ebinary__ieee_2Eclear__flags,axiom,
    inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Eclear__flags) = c_2Ebinary__ieee_2Eclear__flags ).

tff(tp_c_2Ebinary__ieee_2Eclosest,type,
    c_2Ebinary__ieee_2Eclosest: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Eclosest,axiom,
    ! [A_27a: del,A_27b: del] : mem(c_2Ebinary__ieee_2Eclosest(A_27a,A_27b),arr(arr(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b),bool),arr(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b)))) ).

tff(tp_c_2Ebinary__ieee_2Eclosest__such,type,
    c_2Ebinary__ieee_2Eclosest__such: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Eclosest__such,axiom,
    ! [A_27a: del,A_27b: del] : mem(c_2Ebinary__ieee_2Eclosest__such(A_27a,A_27b),arr(arr(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b),bool),arr(arr(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b),bool),arr(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b))))) ).

tff(tp_c_2Ebinary__ieee_2Edividezero__flags,type,
    c_2Ebinary__ieee_2Edividezero__flags: $i ).

tff(mem_c_2Ebinary__ieee_2Edividezero__flags,axiom,
    mem(c_2Ebinary__ieee_2Edividezero__flags,ty_2Ebinary__ieee_2Eflags) ).

tff(stp_fo_c_2Ebinary__ieee_2Edividezero__flags,type,
    fo__c_2Ebinary__ieee_2Edividezero__flags: tp__ty_2Ebinary__ieee_2Eflags ).

tff(stp_eq_fo_c_2Ebinary__ieee_2Edividezero__flags,axiom,
    inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Edividezero__flags) = c_2Ebinary__ieee_2Edividezero__flags ).

tff(tp_c_2Ebinary__ieee_2Eexponent__boundary,type,
    c_2Ebinary__ieee_2Eexponent__boundary: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Eexponent__boundary,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Eexponent__boundary(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool))) ).

tff(tp_c_2Ebinary__ieee_2Eflags__CASE,type,
    c_2Ebinary__ieee_2Eflags__CASE: del > $i ).

tff(mem_c_2Ebinary__ieee_2Eflags__CASE,axiom,
    ! [A_27a: del] : mem(c_2Ebinary__ieee_2Eflags__CASE(A_27a),arr(ty_2Ebinary__ieee_2Eflags,arr(arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,A_27a)))))),A_27a))) ).

tff(tp_c_2Ebinary__ieee_2Eflags__DivideByZero,type,
    c_2Ebinary__ieee_2Eflags__DivideByZero: $i ).

tff(mem_c_2Ebinary__ieee_2Eflags__DivideByZero,axiom,
    mem(c_2Ebinary__ieee_2Eflags__DivideByZero,arr(ty_2Ebinary__ieee_2Eflags,bool)) ).

tff(stp_fo_c_2Ebinary__ieee_2Eflags__DivideByZero,type,
    fo__c_2Ebinary__ieee_2Eflags__DivideByZero: tp__ty_2Ebinary__ieee_2Eflags > tp__o ).

tff(stp_eq_fo_c_2Ebinary__ieee_2Eflags__DivideByZero,axiom,
    ! [X0: tp__ty_2Ebinary__ieee_2Eflags] : ( inj__o(fo__c_2Ebinary__ieee_2Eflags__DivideByZero(X0)) = ap(c_2Ebinary__ieee_2Eflags__DivideByZero,inj__ty_2Ebinary__ieee_2Eflags(X0)) ) ).

tff(tp_c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,type,
    c_2Ebinary__ieee_2Eflags__DivideByZero__fupd: $i ).

tff(mem_c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,axiom,
    mem(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,arr(arr(bool,bool),arr(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags))) ).

tff(tp_c_2Ebinary__ieee_2Eflags__InvalidOp,type,
    c_2Ebinary__ieee_2Eflags__InvalidOp: $i ).

tff(mem_c_2Ebinary__ieee_2Eflags__InvalidOp,axiom,
    mem(c_2Ebinary__ieee_2Eflags__InvalidOp,arr(ty_2Ebinary__ieee_2Eflags,bool)) ).

tff(stp_fo_c_2Ebinary__ieee_2Eflags__InvalidOp,type,
    fo__c_2Ebinary__ieee_2Eflags__InvalidOp: tp__ty_2Ebinary__ieee_2Eflags > tp__o ).

tff(stp_eq_fo_c_2Ebinary__ieee_2Eflags__InvalidOp,axiom,
    ! [X0: tp__ty_2Ebinary__ieee_2Eflags] : ( inj__o(fo__c_2Ebinary__ieee_2Eflags__InvalidOp(X0)) = ap(c_2Ebinary__ieee_2Eflags__InvalidOp,inj__ty_2Ebinary__ieee_2Eflags(X0)) ) ).

tff(tp_c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,type,
    c_2Ebinary__ieee_2Eflags__InvalidOp__fupd: $i ).

tff(mem_c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,axiom,
    mem(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,arr(arr(bool,bool),arr(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags))) ).

tff(tp_c_2Ebinary__ieee_2Eflags__Overflow,type,
    c_2Ebinary__ieee_2Eflags__Overflow: $i ).

tff(mem_c_2Ebinary__ieee_2Eflags__Overflow,axiom,
    mem(c_2Ebinary__ieee_2Eflags__Overflow,arr(ty_2Ebinary__ieee_2Eflags,bool)) ).

tff(stp_fo_c_2Ebinary__ieee_2Eflags__Overflow,type,
    fo__c_2Ebinary__ieee_2Eflags__Overflow: tp__ty_2Ebinary__ieee_2Eflags > tp__o ).

tff(stp_eq_fo_c_2Ebinary__ieee_2Eflags__Overflow,axiom,
    ! [X0: tp__ty_2Ebinary__ieee_2Eflags] : ( inj__o(fo__c_2Ebinary__ieee_2Eflags__Overflow(X0)) = ap(c_2Ebinary__ieee_2Eflags__Overflow,inj__ty_2Ebinary__ieee_2Eflags(X0)) ) ).

tff(tp_c_2Ebinary__ieee_2Eflags__Overflow__fupd,type,
    c_2Ebinary__ieee_2Eflags__Overflow__fupd: $i ).

tff(mem_c_2Ebinary__ieee_2Eflags__Overflow__fupd,axiom,
    mem(c_2Ebinary__ieee_2Eflags__Overflow__fupd,arr(arr(bool,bool),arr(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags))) ).

tff(tp_c_2Ebinary__ieee_2Eflags__Precision,type,
    c_2Ebinary__ieee_2Eflags__Precision: $i ).

tff(mem_c_2Ebinary__ieee_2Eflags__Precision,axiom,
    mem(c_2Ebinary__ieee_2Eflags__Precision,arr(ty_2Ebinary__ieee_2Eflags,bool)) ).

tff(stp_fo_c_2Ebinary__ieee_2Eflags__Precision,type,
    fo__c_2Ebinary__ieee_2Eflags__Precision: tp__ty_2Ebinary__ieee_2Eflags > tp__o ).

tff(stp_eq_fo_c_2Ebinary__ieee_2Eflags__Precision,axiom,
    ! [X0: tp__ty_2Ebinary__ieee_2Eflags] : ( inj__o(fo__c_2Ebinary__ieee_2Eflags__Precision(X0)) = ap(c_2Ebinary__ieee_2Eflags__Precision,inj__ty_2Ebinary__ieee_2Eflags(X0)) ) ).

tff(tp_c_2Ebinary__ieee_2Eflags__Precision__fupd,type,
    c_2Ebinary__ieee_2Eflags__Precision__fupd: $i ).

tff(mem_c_2Ebinary__ieee_2Eflags__Precision__fupd,axiom,
    mem(c_2Ebinary__ieee_2Eflags__Precision__fupd,arr(arr(bool,bool),arr(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags))) ).

tff(tp_c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,type,
    c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding: $i ).

tff(mem_c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,axiom,
    mem(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,arr(ty_2Ebinary__ieee_2Eflags,bool)) ).

tff(stp_fo_c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,type,
    fo__c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding: tp__ty_2Ebinary__ieee_2Eflags > tp__o ).

tff(stp_eq_fo_c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,axiom,
    ! [X0: tp__ty_2Ebinary__ieee_2Eflags] : ( inj__o(fo__c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding(X0)) = ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,inj__ty_2Ebinary__ieee_2Eflags(X0)) ) ).

tff(tp_c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,type,
    c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd: $i ).

tff(mem_c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,axiom,
    mem(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,arr(arr(bool,bool),arr(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags))) ).

tff(tp_c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,type,
    c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding: $i ).

tff(mem_c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,axiom,
    mem(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,arr(ty_2Ebinary__ieee_2Eflags,bool)) ).

tff(stp_fo_c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,type,
    fo__c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding: tp__ty_2Ebinary__ieee_2Eflags > tp__o ).

tff(stp_eq_fo_c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,axiom,
    ! [X0: tp__ty_2Ebinary__ieee_2Eflags] : ( inj__o(fo__c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding(X0)) = ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,inj__ty_2Ebinary__ieee_2Eflags(X0)) ) ).

tff(tp_c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,type,
    c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd: $i ).

tff(mem_c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,axiom,
    mem(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,arr(arr(bool,bool),arr(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags))) ).

tff(tp_c_2Ebinary__ieee_2Eflags__size,type,
    c_2Ebinary__ieee_2Eflags__size: $i ).

tff(mem_c_2Ebinary__ieee_2Eflags__size,axiom,
    mem(c_2Ebinary__ieee_2Eflags__size,arr(ty_2Ebinary__ieee_2Eflags,ty_2Enum_2Enum)) ).

tff(stp_fo_c_2Ebinary__ieee_2Eflags__size,type,
    fo__c_2Ebinary__ieee_2Eflags__size: tp__ty_2Ebinary__ieee_2Eflags > tp__ty_2Enum_2Enum ).

tff(stp_eq_fo_c_2Ebinary__ieee_2Eflags__size,axiom,
    ! [X0: tp__ty_2Ebinary__ieee_2Eflags] : ( inj__ty_2Enum_2Enum(fo__c_2Ebinary__ieee_2Eflags__size(X0)) = ap(c_2Ebinary__ieee_2Eflags__size,inj__ty_2Ebinary__ieee_2Eflags(X0)) ) ).

tff(tp_c_2Ebinary__ieee_2Efloat__CASE,type,
    c_2Ebinary__ieee_2Efloat__CASE: ( del * del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__CASE,axiom,
    ! [A_27a: del,A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__CASE(A_27a,A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),arr(ty_2Efcp_2Ecart(bool,A_27w),arr(ty_2Efcp_2Ecart(bool,A_27t),A_27a))),A_27a))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__Exponent,type,
    c_2Ebinary__ieee_2Efloat__Exponent: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__Exponent,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Efcp_2Ecart(bool,A_27w))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__Exponent__fupd,type,
    c_2Ebinary__ieee_2Efloat__Exponent__fupd: ( del * del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__Exponent__fupd,axiom,
    ! [A_27t: del,A_27w: del,A_27x: del] : mem(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),arr(arr(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27x)),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27x)))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__Sign,type,
    c_2Ebinary__ieee_2Efloat__Sign: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__Sign,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__Sign__fupd,type,
    c_2Ebinary__ieee_2Efloat__Sign__fupd: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__Sign__fupd,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),arr(arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__Significand,type,
    c_2Ebinary__ieee_2Efloat__Significand: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__Significand,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Efcp_2Ecart(bool,A_27t))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__Significand__fupd,type,
    c_2Ebinary__ieee_2Efloat__Significand__fupd: ( del * del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__Significand__fupd,axiom,
    ! [A_27t: del,A_27u: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),arr(arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27u)),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27u,A_27w)))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__abs,type,
    c_2Ebinary__ieee_2Efloat__abs: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__abs,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__abs(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__add,type,
    c_2Ebinary__ieee_2Efloat__add: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__add,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__add(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__bottom,type,
    c_2Ebinary__ieee_2Efloat__bottom: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__bottom,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),arr(ty_2Ebool_2Eitself(ty_2Epair_2Eprod(A_27t,A_27w)),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__compare,type,
    c_2Ebinary__ieee_2Efloat__compare: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__compare,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__compare(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat__compare))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__compare2num,type,
    c_2Ebinary__ieee_2Efloat__compare2num: $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__compare2num,axiom,
    mem(c_2Ebinary__ieee_2Efloat__compare2num,arr(ty_2Ebinary__ieee_2Efloat__compare,ty_2Enum_2Enum)) ).

tff(stp_fo_c_2Ebinary__ieee_2Efloat__compare2num,type,
    fo__c_2Ebinary__ieee_2Efloat__compare2num: tp__ty_2Ebinary__ieee_2Efloat__compare > tp__ty_2Enum_2Enum ).

tff(stp_eq_fo_c_2Ebinary__ieee_2Efloat__compare2num,axiom,
    ! [X0: tp__ty_2Ebinary__ieee_2Efloat__compare] : ( inj__ty_2Enum_2Enum(fo__c_2Ebinary__ieee_2Efloat__compare2num(X0)) = ap(c_2Ebinary__ieee_2Efloat__compare2num,inj__ty_2Ebinary__ieee_2Efloat__compare(X0)) ) ).

tff(tp_c_2Ebinary__ieee_2Efloat__compare__CASE,type,
    c_2Ebinary__ieee_2Efloat__compare__CASE: del > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__compare__CASE,axiom,
    ! [A_27a: del] : mem(c_2Ebinary__ieee_2Efloat__compare__CASE(A_27a),arr(ty_2Ebinary__ieee_2Efloat__compare,arr(A_27a,arr(A_27a,arr(A_27a,arr(A_27a,A_27a)))))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__compare__size,type,
    c_2Ebinary__ieee_2Efloat__compare__size: $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__compare__size,axiom,
    mem(c_2Ebinary__ieee_2Efloat__compare__size,arr(ty_2Ebinary__ieee_2Efloat__compare,ty_2Enum_2Enum)) ).

tff(stp_fo_c_2Ebinary__ieee_2Efloat__compare__size,type,
    fo__c_2Ebinary__ieee_2Efloat__compare__size: tp__ty_2Ebinary__ieee_2Efloat__compare > tp__ty_2Enum_2Enum ).

tff(stp_eq_fo_c_2Ebinary__ieee_2Efloat__compare__size,axiom,
    ! [X0: tp__ty_2Ebinary__ieee_2Efloat__compare] : ( inj__ty_2Enum_2Enum(fo__c_2Ebinary__ieee_2Efloat__compare__size(X0)) = ap(c_2Ebinary__ieee_2Efloat__compare__size,inj__ty_2Ebinary__ieee_2Efloat__compare(X0)) ) ).

tff(tp_c_2Ebinary__ieee_2Efloat__div,type,
    c_2Ebinary__ieee_2Efloat__div: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__div,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__div(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__equal,type,
    c_2Ebinary__ieee_2Efloat__equal: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__equal,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__equal(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__greater__equal,type,
    c_2Ebinary__ieee_2Efloat__greater__equal: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__greater__equal,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__greater__equal(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__greater__than,type,
    c_2Ebinary__ieee_2Efloat__greater__than: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__greater__than,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__greater__than(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__is__finite,type,
    c_2Ebinary__ieee_2Efloat__is__finite: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__is__finite,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__is__finite(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool)) ).

tff(tp_c_2Ebinary__ieee_2Efloat__is__infinite,type,
    c_2Ebinary__ieee_2Efloat__is__infinite: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__is__infinite,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool)) ).

tff(tp_c_2Ebinary__ieee_2Efloat__is__integral,type,
    c_2Ebinary__ieee_2Efloat__is__integral: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__is__integral,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__is__integral(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool)) ).

tff(tp_c_2Ebinary__ieee_2Efloat__is__nan,type,
    c_2Ebinary__ieee_2Efloat__is__nan: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__is__nan,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool)) ).

tff(tp_c_2Ebinary__ieee_2Efloat__is__normal,type,
    c_2Ebinary__ieee_2Efloat__is__normal: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__is__normal,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__is__normal(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool)) ).

tff(tp_c_2Ebinary__ieee_2Efloat__is__signalling,type,
    c_2Ebinary__ieee_2Efloat__is__signalling: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__is__signalling,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__is__signalling(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool)) ).

tff(tp_c_2Ebinary__ieee_2Efloat__is__subnormal,type,
    c_2Ebinary__ieee_2Efloat__is__subnormal: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__is__subnormal,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool)) ).

tff(tp_c_2Ebinary__ieee_2Efloat__is__zero,type,
    c_2Ebinary__ieee_2Efloat__is__zero: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__is__zero,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool)) ).

tff(tp_c_2Ebinary__ieee_2Efloat__less__equal,type,
    c_2Ebinary__ieee_2Efloat__less__equal: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__less__equal,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__less__equal(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__less__than,type,
    c_2Ebinary__ieee_2Efloat__less__than: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__less__than,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__less__than(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__minus__infinity,type,
    c_2Ebinary__ieee_2Efloat__minus__infinity: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__minus__infinity,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),arr(ty_2Ebool_2Eitself(ty_2Epair_2Eprod(A_27t,A_27w)),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__minus__min,type,
    c_2Ebinary__ieee_2Efloat__minus__min: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__minus__min,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),arr(ty_2Ebool_2Eitself(ty_2Epair_2Eprod(A_27t,A_27w)),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__minus__zero,type,
    c_2Ebinary__ieee_2Efloat__minus__zero: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__minus__zero,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),arr(ty_2Ebool_2Eitself(ty_2Epair_2Eprod(A_27t,A_27w)),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__mul,type,
    c_2Ebinary__ieee_2Efloat__mul: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__mul,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__mul(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__mul__add,type,
    c_2Ebinary__ieee_2Efloat__mul__add: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__mul__add,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__mul__add(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__mul__sub,type,
    c_2Ebinary__ieee_2Efloat__mul__sub: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__mul__sub,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__mul__sub(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__negate,type,
    c_2Ebinary__ieee_2Efloat__negate: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__negate,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__negate(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__plus__infinity,type,
    c_2Ebinary__ieee_2Efloat__plus__infinity: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__plus__infinity,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),arr(ty_2Ebool_2Eitself(ty_2Epair_2Eprod(A_27t,A_27w)),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__plus__min,type,
    c_2Ebinary__ieee_2Efloat__plus__min: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__plus__min,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),arr(ty_2Ebool_2Eitself(ty_2Epair_2Eprod(A_27t,A_27w)),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__plus__zero,type,
    c_2Ebinary__ieee_2Efloat__plus__zero: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__plus__zero,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),arr(ty_2Ebool_2Eitself(ty_2Epair_2Eprod(A_27t,A_27w)),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__round,type,
    c_2Ebinary__ieee_2Efloat__round: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__round,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__round(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(bool,arr(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__round__to__integral,type,
    c_2Ebinary__ieee_2Efloat__round__to__integral: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__round__to__integral,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__round__to__integral(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__round__with__flags,type,
    c_2Ebinary__ieee_2Efloat__round__with__flags: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__round__with__flags,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__round__with__flags(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(bool,arr(ty_2Erealax_2Ereal,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__size,type,
    c_2Ebinary__ieee_2Efloat__size: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__size,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),arr(arr(A_27t,ty_2Enum_2Enum),arr(arr(A_27w,ty_2Enum_2Enum),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Enum_2Enum)))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__some__qnan,type,
    c_2Ebinary__ieee_2Efloat__some__qnan: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__some__qnan,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__sqrt,type,
    c_2Ebinary__ieee_2Efloat__sqrt: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__sqrt,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__sqrt(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__sub,type,
    c_2Ebinary__ieee_2Efloat__sub: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__sub,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__sub(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))) ).

tff(stp_c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint,type,
    tp__c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint: $tType ).

tff(stp_inj_c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint,type,
    inj__c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint: tp__c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint > $i ).

tff(stp_surj_c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint,type,
    surj__c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint: $i > tp__c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint ).

tff(stp_inj_surj_c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint,axiom,
    ! [X: tp__c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint] : ( surj__c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint(inj__c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint(X)) = X ) ).

tff(stp_inj_mem_c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint,axiom,
    ! [X: tp__c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint] : mem(inj__c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint(X),ty_2Eoption_2Eoption(ty_2Einteger_2Eint)) ).

tff(stp_iso_mem_c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint,axiom,
    ! [X: $i] :
      ( mem(X,ty_2Eoption_2Eoption(ty_2Einteger_2Eint))
     => ( X = inj__c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint(surj__c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint(X)) ) ) ).

tff(tp_c_2Ebinary__ieee_2Efloat__to__int,type,
    c_2Ebinary__ieee_2Efloat__to__int: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__to__int,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__to__int(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Eoption_2Eoption(ty_2Einteger_2Eint)))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__to__real,type,
    c_2Ebinary__ieee_2Efloat__to__real: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__to__real,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Erealax_2Ereal)) ).

tff(tp_c_2Ebinary__ieee_2Efloat__top,type,
    c_2Ebinary__ieee_2Efloat__top: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__top,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),arr(ty_2Ebool_2Eitself(ty_2Epair_2Eprod(A_27t,A_27w)),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__value,type,
    c_2Ebinary__ieee_2Efloat__value: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__value,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat__value)) ).

tff(tp_c_2Ebinary__ieee_2Efloat__value__CASE,type,
    c_2Ebinary__ieee_2Efloat__value__CASE: del > $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__value__CASE,axiom,
    ! [A_27a: del] : mem(c_2Ebinary__ieee_2Efloat__value__CASE(A_27a),arr(ty_2Ebinary__ieee_2Efloat__value,arr(arr(ty_2Erealax_2Ereal,A_27a),arr(A_27a,arr(A_27a,A_27a))))) ).

tff(tp_c_2Ebinary__ieee_2Efloat__value__size,type,
    c_2Ebinary__ieee_2Efloat__value__size: $i ).

tff(mem_c_2Ebinary__ieee_2Efloat__value__size,axiom,
    mem(c_2Ebinary__ieee_2Efloat__value__size,arr(ty_2Ebinary__ieee_2Efloat__value,ty_2Enum_2Enum)) ).

tff(stp_fo_c_2Ebinary__ieee_2Efloat__value__size,type,
    fo__c_2Ebinary__ieee_2Efloat__value__size: tp__ty_2Ebinary__ieee_2Efloat__value > tp__ty_2Enum_2Enum ).

tff(stp_eq_fo_c_2Ebinary__ieee_2Efloat__value__size,axiom,
    ! [X0: tp__ty_2Ebinary__ieee_2Efloat__value] : ( inj__ty_2Enum_2Enum(fo__c_2Ebinary__ieee_2Efloat__value__size(X0)) = ap(c_2Ebinary__ieee_2Efloat__value__size,inj__ty_2Ebinary__ieee_2Efloat__value(X0)) ) ).

tff(tp_c_2Ebinary__ieee_2Efp__op__CASE,type,
    c_2Ebinary__ieee_2Efp__op__CASE: ( del * del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efp__op__CASE,axiom,
    ! [A_27a: del,A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efp__op__CASE(A_27a,A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w),arr(arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)),arr(arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))),arr(arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))),arr(arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))),arr(arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))),arr(arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))),arr(arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))),A_27a))))))))) ).

tff(tp_c_2Ebinary__ieee_2Efp__op__size,type,
    c_2Ebinary__ieee_2Efp__op__size: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Efp__op__size,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Efp__op__size(A_27t,A_27w),arr(arr(A_27t,ty_2Enum_2Enum),arr(arr(A_27w,ty_2Enum_2Enum),arr(ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w),ty_2Enum_2Enum)))) ).

tff(tp_c_2Ebinary__ieee_2Eintegral__round,type,
    c_2Ebinary__ieee_2Eintegral__round: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Eintegral__round,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Eintegral__round(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))) ).

tff(tp_c_2Ebinary__ieee_2Einvalidop__flags,type,
    c_2Ebinary__ieee_2Einvalidop__flags: $i ).

tff(mem_c_2Ebinary__ieee_2Einvalidop__flags,axiom,
    mem(c_2Ebinary__ieee_2Einvalidop__flags,ty_2Ebinary__ieee_2Eflags) ).

tff(stp_fo_c_2Ebinary__ieee_2Einvalidop__flags,type,
    fo__c_2Ebinary__ieee_2Einvalidop__flags: tp__ty_2Ebinary__ieee_2Eflags ).

tff(stp_eq_fo_c_2Ebinary__ieee_2Einvalidop__flags,axiom,
    inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Einvalidop__flags) = c_2Ebinary__ieee_2Einvalidop__flags ).

tff(tp_c_2Ebinary__ieee_2Eis__closest,type,
    c_2Ebinary__ieee_2Eis__closest: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Eis__closest,axiom,
    ! [A_27a: del,A_27b: del] : mem(c_2Ebinary__ieee_2Eis__closest(A_27a,A_27b),arr(arr(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b),bool),arr(ty_2Erealax_2Ereal,arr(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b),bool)))) ).

tff(tp_c_2Ebinary__ieee_2Eis__integral,type,
    c_2Ebinary__ieee_2Eis__integral: $i ).

tff(mem_c_2Ebinary__ieee_2Eis__integral,axiom,
    mem(c_2Ebinary__ieee_2Eis__integral,arr(ty_2Erealax_2Ereal,bool)) ).

tff(stp_fo_c_2Ebinary__ieee_2Eis__integral,type,
    fo__c_2Ebinary__ieee_2Eis__integral: tp__ty_2Erealax_2Ereal > tp__o ).

tff(stp_eq_fo_c_2Ebinary__ieee_2Eis__integral,axiom,
    ! [X0: tp__ty_2Erealax_2Ereal] : ( inj__o(fo__c_2Ebinary__ieee_2Eis__integral(X0)) = ap(c_2Ebinary__ieee_2Eis__integral,inj__ty_2Erealax_2Ereal(X0)) ) ).

tff(tp_c_2Ebinary__ieee_2Elargest,type,
    c_2Ebinary__ieee_2Elargest: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Elargest,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Elargest(A_27t,A_27w),arr(ty_2Ebool_2Eitself(ty_2Epair_2Eprod(A_27t,A_27w)),ty_2Erealax_2Ereal)) ).

tff(tp_c_2Ebinary__ieee_2Enum2float__compare,type,
    c_2Ebinary__ieee_2Enum2float__compare: $i ).

tff(mem_c_2Ebinary__ieee_2Enum2float__compare,axiom,
    mem(c_2Ebinary__ieee_2Enum2float__compare,arr(ty_2Enum_2Enum,ty_2Ebinary__ieee_2Efloat__compare)) ).

tff(stp_fo_c_2Ebinary__ieee_2Enum2float__compare,type,
    fo__c_2Ebinary__ieee_2Enum2float__compare: tp__ty_2Enum_2Enum > tp__ty_2Ebinary__ieee_2Efloat__compare ).

tff(stp_eq_fo_c_2Ebinary__ieee_2Enum2float__compare,axiom,
    ! [X0: tp__ty_2Enum_2Enum] : ( inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2Enum2float__compare(X0)) = ap(c_2Ebinary__ieee_2Enum2float__compare,inj__ty_2Enum_2Enum(X0)) ) ).

tff(tp_c_2Ebinary__ieee_2Enum2rounding,type,
    c_2Ebinary__ieee_2Enum2rounding: $i ).

tff(mem_c_2Ebinary__ieee_2Enum2rounding,axiom,
    mem(c_2Ebinary__ieee_2Enum2rounding,arr(ty_2Enum_2Enum,ty_2Ebinary__ieee_2Erounding)) ).

tff(stp_fo_c_2Ebinary__ieee_2Enum2rounding,type,
    fo__c_2Ebinary__ieee_2Enum2rounding: tp__ty_2Enum_2Enum > tp__ty_2Ebinary__ieee_2Erounding ).

tff(stp_eq_fo_c_2Ebinary__ieee_2Enum2rounding,axiom,
    ! [X0: tp__ty_2Enum_2Enum] : ( inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2Enum2rounding(X0)) = ap(c_2Ebinary__ieee_2Enum2rounding,inj__ty_2Enum_2Enum(X0)) ) ).

tff(tp_c_2Ebinary__ieee_2Ereal__to__float,type,
    c_2Ebinary__ieee_2Ereal__to__float: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Ereal__to__float,axiom,
    ! [A_27a: del,A_27b: del] : mem(c_2Ebinary__ieee_2Ereal__to__float(A_27a,A_27b),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b)))) ).

tff(tp_c_2Ebinary__ieee_2Ereal__to__float__with__flags,type,
    c_2Ebinary__ieee_2Ereal__to__float__with__flags: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Ereal__to__float__with__flags,axiom,
    ! [A_27a: del,A_27b: del] : mem(c_2Ebinary__ieee_2Ereal__to__float__with__flags(A_27a,A_27b),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Erealax_2Ereal,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b))))) ).

tff(tp_c_2Ebinary__ieee_2Erecordtype_2Eflags,type,
    c_2Ebinary__ieee_2Erecordtype_2Eflags: $i ).

tff(mem_c_2Ebinary__ieee_2Erecordtype_2Eflags,axiom,
    mem(c_2Ebinary__ieee_2Erecordtype_2Eflags,arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,ty_2Ebinary__ieee_2Eflags))))))) ).

tff(stp_fo_c_2Ebinary__ieee_2Erecordtype_2Eflags,type,
    fo__c_2Ebinary__ieee_2Erecordtype_2Eflags: ( tp__o * tp__o * tp__o * tp__o * tp__o * tp__o ) > tp__ty_2Ebinary__ieee_2Eflags ).

tff(stp_eq_fo_c_2Ebinary__ieee_2Erecordtype_2Eflags,axiom,
    ! [X0: tp__o,X1: tp__o,X2: tp__o,X3: tp__o,X4: tp__o,X5: tp__o] : ( inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Erecordtype_2Eflags(X0,X1,X2,X3,X4,X5)) = ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(X0)),inj__o(X1)),inj__o(X2)),inj__o(X3)),inj__o(X4)),inj__o(X5)) ) ).

tff(tp_c_2Ebinary__ieee_2Erecordtype_2Efloat,type,
    c_2Ebinary__ieee_2Erecordtype_2Efloat: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Erecordtype_2Efloat,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),arr(ty_2Efcp_2Ecart(bool,A_27w),arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))) ).

tff(tp_c_2Ebinary__ieee_2Eround,type,
    c_2Ebinary__ieee_2Eround: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Eround,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Eround(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))) ).

tff(tp_c_2Ebinary__ieee_2EroundTiesToEven,type,
    c_2Ebinary__ieee_2EroundTiesToEven: $i ).

tff(mem_c_2Ebinary__ieee_2EroundTiesToEven,axiom,
    mem(c_2Ebinary__ieee_2EroundTiesToEven,ty_2Ebinary__ieee_2Erounding) ).

tff(stp_fo_c_2Ebinary__ieee_2EroundTiesToEven,type,
    fo__c_2Ebinary__ieee_2EroundTiesToEven: tp__ty_2Ebinary__ieee_2Erounding ).

tff(stp_eq_fo_c_2Ebinary__ieee_2EroundTiesToEven,axiom,
    inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2EroundTiesToEven) = c_2Ebinary__ieee_2EroundTiesToEven ).

tff(tp_c_2Ebinary__ieee_2EroundTowardNegative,type,
    c_2Ebinary__ieee_2EroundTowardNegative: $i ).

tff(mem_c_2Ebinary__ieee_2EroundTowardNegative,axiom,
    mem(c_2Ebinary__ieee_2EroundTowardNegative,ty_2Ebinary__ieee_2Erounding) ).

tff(stp_fo_c_2Ebinary__ieee_2EroundTowardNegative,type,
    fo__c_2Ebinary__ieee_2EroundTowardNegative: tp__ty_2Ebinary__ieee_2Erounding ).

tff(stp_eq_fo_c_2Ebinary__ieee_2EroundTowardNegative,axiom,
    inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2EroundTowardNegative) = c_2Ebinary__ieee_2EroundTowardNegative ).

tff(tp_c_2Ebinary__ieee_2EroundTowardPositive,type,
    c_2Ebinary__ieee_2EroundTowardPositive: $i ).

tff(mem_c_2Ebinary__ieee_2EroundTowardPositive,axiom,
    mem(c_2Ebinary__ieee_2EroundTowardPositive,ty_2Ebinary__ieee_2Erounding) ).

tff(stp_fo_c_2Ebinary__ieee_2EroundTowardPositive,type,
    fo__c_2Ebinary__ieee_2EroundTowardPositive: tp__ty_2Ebinary__ieee_2Erounding ).

tff(stp_eq_fo_c_2Ebinary__ieee_2EroundTowardPositive,axiom,
    inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2EroundTowardPositive) = c_2Ebinary__ieee_2EroundTowardPositive ).

tff(tp_c_2Ebinary__ieee_2EroundTowardZero,type,
    c_2Ebinary__ieee_2EroundTowardZero: $i ).

tff(mem_c_2Ebinary__ieee_2EroundTowardZero,axiom,
    mem(c_2Ebinary__ieee_2EroundTowardZero,ty_2Ebinary__ieee_2Erounding) ).

tff(stp_fo_c_2Ebinary__ieee_2EroundTowardZero,type,
    fo__c_2Ebinary__ieee_2EroundTowardZero: tp__ty_2Ebinary__ieee_2Erounding ).

tff(stp_eq_fo_c_2Ebinary__ieee_2EroundTowardZero,axiom,
    inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2EroundTowardZero) = c_2Ebinary__ieee_2EroundTowardZero ).

tff(tp_c_2Ebinary__ieee_2Erounding2num,type,
    c_2Ebinary__ieee_2Erounding2num: $i ).

tff(mem_c_2Ebinary__ieee_2Erounding2num,axiom,
    mem(c_2Ebinary__ieee_2Erounding2num,arr(ty_2Ebinary__ieee_2Erounding,ty_2Enum_2Enum)) ).

tff(stp_fo_c_2Ebinary__ieee_2Erounding2num,type,
    fo__c_2Ebinary__ieee_2Erounding2num: tp__ty_2Ebinary__ieee_2Erounding > tp__ty_2Enum_2Enum ).

tff(stp_eq_fo_c_2Ebinary__ieee_2Erounding2num,axiom,
    ! [X0: tp__ty_2Ebinary__ieee_2Erounding] : ( inj__ty_2Enum_2Enum(fo__c_2Ebinary__ieee_2Erounding2num(X0)) = ap(c_2Ebinary__ieee_2Erounding2num,inj__ty_2Ebinary__ieee_2Erounding(X0)) ) ).

tff(tp_c_2Ebinary__ieee_2Erounding__CASE,type,
    c_2Ebinary__ieee_2Erounding__CASE: del > $i ).

tff(mem_c_2Ebinary__ieee_2Erounding__CASE,axiom,
    ! [A_27a: del] : mem(c_2Ebinary__ieee_2Erounding__CASE(A_27a),arr(ty_2Ebinary__ieee_2Erounding,arr(A_27a,arr(A_27a,arr(A_27a,arr(A_27a,A_27a)))))) ).

tff(tp_c_2Ebinary__ieee_2Erounding__size,type,
    c_2Ebinary__ieee_2Erounding__size: $i ).

tff(mem_c_2Ebinary__ieee_2Erounding__size,axiom,
    mem(c_2Ebinary__ieee_2Erounding__size,arr(ty_2Ebinary__ieee_2Erounding,ty_2Enum_2Enum)) ).

tff(stp_fo_c_2Ebinary__ieee_2Erounding__size,type,
    fo__c_2Ebinary__ieee_2Erounding__size: tp__ty_2Ebinary__ieee_2Erounding > tp__ty_2Enum_2Enum ).

tff(stp_eq_fo_c_2Ebinary__ieee_2Erounding__size,axiom,
    ! [X0: tp__ty_2Ebinary__ieee_2Erounding] : ( inj__ty_2Enum_2Enum(fo__c_2Ebinary__ieee_2Erounding__size(X0)) = ap(c_2Ebinary__ieee_2Erounding__size,inj__ty_2Ebinary__ieee_2Erounding(X0)) ) ).

tff(tp_c_2Ebinary__ieee_2Ethreshold,type,
    c_2Ebinary__ieee_2Ethreshold: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Ethreshold,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Ethreshold(A_27t,A_27w),arr(ty_2Ebool_2Eitself(ty_2Epair_2Eprod(A_27t,A_27w)),ty_2Erealax_2Ereal)) ).

tff(tp_c_2Ebinary__ieee_2Eulp,type,
    c_2Ebinary__ieee_2Eulp: ( del * del ) > $i ).

tff(mem_c_2Ebinary__ieee_2Eulp,axiom,
    ! [A_27t: del,A_27w: del] : mem(c_2Ebinary__ieee_2Eulp(A_27t,A_27w),arr(ty_2Ebool_2Eitself(ty_2Epair_2Eprod(A_27t,A_27w)),ty_2Erealax_2Ereal)) ).

tff(lamtp_f2917,type,
    f2917: ( del * del * $i * tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone ) > $i ).

tff(lameq_f2917,axiom,
    ! [A_27w: del,A_27t: del,V8a1: $i] :
      ( mem(V8a1,ty_2Efcp_2Ecart(bool,A_27w))
     => ! [V7a0: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V9a2: $i] : ( ap(f2917(A_27w,A_27t,V8a1,V7a0),V9a2) = ap(ap(ap(c_2Eind__type_2ECONSTR(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27t)))),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)),ap(ap(c_2Epair_2E_2C(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27t))),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V7a0)),ap(ap(c_2Epair_2E_2C(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27t)),V8a1),V9a2))),k(ty_2Enum_2Enum,c_2Eind__type_2EBOTTOM(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27t)))))) ) ) ).

tff(lamtp_f2918,type,
    f2918: ( del * del * tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone ) > $i ).

tff(lameq_f2918,axiom,
    ! [A_27t: del,A_27w: del,V7a0: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V8a1: $i] : ( ap(f2918(A_27t,A_27w,V7a0),V8a1) = f2917(A_27w,A_27t,V8a1,V7a0) ) ).

tff(lamtp_f2919,type,
    f2919: ( del * del ) > $i ).

tff(lameq_f2919,axiom,
    ! [A_27w: del,A_27t: del,V7a0: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone] : ( ap(f2919(A_27w,A_27t),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V7a0)) = f2918(A_27t,A_27w,V7a0) ) ).

tff(lamtp_f2920,type,
    f2920: ( del * del * tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone * $i * $i ) > $i ).

tff(lameq_f2920,axiom,
    ! [A_27w: del,A_27t: del,V4a0: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V5a1: $i] :
      ( mem(V5a1,ty_2Efcp_2Ecart(bool,A_27w))
     => ! [V3a0_27: $i] :
          ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27t)))))
         => ! [V6a2: $i] : ( ap(f2920(A_27w,A_27t,V4a0,V5a1,V3a0_27),V6a2) = ap(ap(c_2Emin_2E_3D(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27t))))),V3a0_27),ap(ap(ap(f2919(A_27w,A_27t),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V4a0)),V5a1),V6a2)) ) ) ) ).

tff(lamtp_f2921,type,
    f2921: ( del * del * $i * tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone ) > $i ).

tff(lameq_f2921,axiom,
    ! [A_27t: del,A_27w: del,V3a0_27: $i] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27t)))))
     => ! [V4a0: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V5a1: $i] : ( ap(f2921(A_27t,A_27w,V3a0_27,V4a0),V5a1) = ap(c_2Ebool_2E_3F(ty_2Efcp_2Ecart(bool,A_27t)),f2920(A_27w,A_27t,V4a0,V5a1,V3a0_27)) ) ) ).

tff(lamtp_f2922,type,
    f2922: ( del * del * $i ) > $i ).

tff(lameq_f2922,axiom,
    ! [A_27w: del,A_27t: del,V3a0_27: $i] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27t)))))
     => ! [V4a0: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone] : ( ap(f2922(A_27w,A_27t,V3a0_27),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V4a0)) = ap(c_2Ebool_2E_3F(ty_2Efcp_2Ecart(bool,A_27w)),f2921(A_27t,A_27w,V3a0_27,V4a0)) ) ) ).

tff(lamtp_f2923,type,
    f2923: ( del * del * $i ) > $i ).

tff(lameq_f2923,axiom,
    ! [A_27w: del,A_27t: del,V2_27float_27: $i] :
      ( mem(V2_27float_27,arr(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27t)))),bool))
     => ! [V3a0_27: $i] : ( ap(f2923(A_27w,A_27t,V2_27float_27),V3a0_27) = ap(ap(c_2Emin_2E_3D_3D_3E,ap(c_2Ebool_2E_3F(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),f2922(A_27w,A_27t,V3a0_27))),ap(V2_27float_27,V3a0_27)) ) ) ).

tff(lamtp_f2924,type,
    f2924: ( del * del * $i ) > $i ).

tff(lameq_f2924,axiom,
    ! [A_27w: del,A_27t: del,V1a0_27: $i] :
      ( mem(V1a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27t)))))
     => ! [V2_27float_27: $i] : ( ap(f2924(A_27w,A_27t,V1a0_27),V2_27float_27) = ap(ap(c_2Emin_2E_3D_3D_3E,ap(c_2Ebool_2E_21(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27t))))),f2923(A_27w,A_27t,V2_27float_27))),ap(V2_27float_27,V1a0_27)) ) ) ).

tff(lamtp_f2925,type,
    f2925: ( del * del ) > $i ).

tff(lameq_f2925,axiom,
    ! [A_27w: del,A_27t: del,V1a0_27: $i] : ( ap(f2925(A_27w,A_27t),V1a0_27) = ap(c_2Ebool_2E_21(arr(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27t)))),bool)),f2924(A_27w,A_27t,V1a0_27)) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__TY__DEF,axiom,
    ! [A_27t: del,A_27w: del] :
    ? [V0rep: $i] :
      ( mem(V0rep,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27t))))))
      & p(ap(ap(c_2Ebool_2ETYPE__DEFINITION(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27t)))),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2925(A_27w,A_27t)),V0rep)) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__case__def,axiom,
    ! [A_27a: del,A_27t: del,A_27w: del,V0a0: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V1a1: $i] :
      ( mem(V1a1,ty_2Efcp_2Ecart(bool,A_27w))
     => ! [V2a2: $i] :
          ( mem(V2a2,ty_2Efcp_2Ecart(bool,A_27t))
         => ! [V3f: $i] :
              ( mem(V3f,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),arr(ty_2Efcp_2Ecart(bool,A_27w),arr(ty_2Efcp_2Ecart(bool,A_27t),A_27a))))
             => ( ap(ap(c_2Ebinary__ieee_2Efloat__CASE(A_27a,A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V0a0)),V1a1),V2a2)),V3f) = ap(ap(ap(V3f,inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V0a0)),V1a1),V2a2) ) ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__size__def,axiom,
    ! [A_27t: del,A_27w: del,V0f: $i] :
      ( mem(V0f,arr(A_27t,ty_2Enum_2Enum))
     => ! [V1f1: $i] :
          ( mem(V1f1,arr(A_27w,ty_2Enum_2Enum))
         => ! [V2a0: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V3a1: $i] :
              ( mem(V3a1,ty_2Efcp_2Ecart(bool,A_27w))
             => ! [V4a2: $i] :
                  ( mem(V4a2,ty_2Efcp_2Ecart(bool,A_27t))
                 => ( surj__ty_2Enum_2Enum(ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V0f),V1f1),ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V2a0)),V3a1),V4a2))) = surj__ty_2Enum_2Enum(ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))) ) ) ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__Sign,axiom,
    ! [A_27t: del,A_27w: del,V0c: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V1c0: $i] :
      ( mem(V1c0,ty_2Efcp_2Ecart(bool,A_27w))
     => ! [V2c1: $i] :
          ( mem(V2c1,ty_2Efcp_2Ecart(bool,A_27t))
         => ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V0c)),V1c0),V2c1))) = V0c ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__Exponent,axiom,
    ! [A_27t: del,A_27w: del,V0c: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V1c0: $i] :
      ( mem(V1c0,ty_2Efcp_2Ecart(bool,A_27w))
     => ! [V2c1: $i] :
          ( mem(V2c1,ty_2Efcp_2Ecart(bool,A_27t))
         => ( ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V0c)),V1c0),V2c1)) = V1c0 ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__Significand,axiom,
    ! [A_27t: del,A_27w: del,V0c: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V1c0: $i] :
      ( mem(V1c0,ty_2Efcp_2Ecart(bool,A_27w))
     => ! [V2c1: $i] :
          ( mem(V2c1,ty_2Efcp_2Ecart(bool,A_27t))
         => ( ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V0c)),V1c0),V2c1)) = V2c1 ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__accessors,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ! [V0c: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V1c0: $i] :
          ( mem(V1c0,ty_2Efcp_2Ecart(bool,A_27w))
         => ! [V2c1: $i] :
              ( mem(V2c1,ty_2Efcp_2Ecart(bool,A_27t))
             => ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V0c)),V1c0),V2c1))) = V0c ) ) )
      & ! [V3c: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V4c0: $i] :
          ( mem(V4c0,ty_2Efcp_2Ecart(bool,A_27w))
         => ! [V5c1: $i] :
              ( mem(V5c1,ty_2Efcp_2Ecart(bool,A_27t))
             => ( ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V3c)),V4c0),V5c1)) = V4c0 ) ) )
      & ! [V6c: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V7c0: $i] :
          ( mem(V7c0,ty_2Efcp_2Ecart(bool,A_27w))
         => ! [V8c1: $i] :
              ( mem(V8c1,ty_2Efcp_2Ecart(bool,A_27t))
             => ( ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V6c)),V7c0),V8c1)) = V8c1 ) ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__Sign__fupd,axiom,
    ! [A_27t: del,A_27w: del,V0f: $i] :
      ( mem(V0f,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
     => ! [V1c: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V2c0: $i] :
          ( mem(V2c0,ty_2Efcp_2Ecart(bool,A_27w))
         => ! [V3c1: $i] :
              ( mem(V3c1,ty_2Efcp_2Ecart(bool,A_27t))
             => ( ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V0f),ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V1c)),V2c0),V3c1)) = ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),ap(V0f,inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V1c))),V2c0),V3c1) ) ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__Exponent__fupd,axiom,
    ! [A_27t: del,A_27w: del,A_27x: del,V0f: $i] :
      ( mem(V0f,arr(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27x)))
     => ! [V1c: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V2c0: $i] :
          ( mem(V2c0,ty_2Efcp_2Ecart(bool,A_27w))
         => ! [V3c1: $i] :
              ( mem(V3c1,ty_2Efcp_2Ecart(bool,A_27t))
             => ( ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V0f),ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V1c)),V2c0),V3c1)) = ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27x),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V1c)),ap(V0f,V2c0)),V3c1) ) ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__Significand__fupd,axiom,
    ! [A_27t: del,A_27u: del,A_27w: del,V0f: $i] :
      ( mem(V0f,arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27u)))
     => ! [V1c: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V2c0: $i] :
          ( mem(V2c0,ty_2Efcp_2Ecart(bool,A_27w))
         => ! [V3c1: $i] :
              ( mem(V3c1,ty_2Efcp_2Ecart(bool,A_27t))
             => ( ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V0f),ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V1c)),V2c0),V3c1)) = ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27u,A_27w),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V1c)),V2c0),ap(V0f,V3c1)) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__fn__updates,axiom,
    ! [A_27t: del,A_27u: del,A_27w: del,A_27x: del] :
      ( ! [V0f: $i] :
          ( mem(V0f,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
         => ! [V1c: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V2c0: $i] :
              ( mem(V2c0,ty_2Efcp_2Ecart(bool,A_27w))
             => ! [V3c1: $i] :
                  ( mem(V3c1,ty_2Efcp_2Ecart(bool,A_27t))
                 => ( ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V0f),ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V1c)),V2c0),V3c1)) = ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),ap(V0f,inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V1c))),V2c0),V3c1) ) ) ) )
      & ! [V4f: $i] :
          ( mem(V4f,arr(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27x)))
         => ! [V5c: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V6c0: $i] :
              ( mem(V6c0,ty_2Efcp_2Ecart(bool,A_27w))
             => ! [V7c1: $i] :
                  ( mem(V7c1,ty_2Efcp_2Ecart(bool,A_27t))
                 => ( ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V4f),ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V5c)),V6c0),V7c1)) = ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27x),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V5c)),ap(V4f,V6c0)),V7c1) ) ) ) )
      & ! [V8f: $i] :
          ( mem(V8f,arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27u)))
         => ! [V9c: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V10c0: $i] :
              ( mem(V10c0,ty_2Efcp_2Ecart(bool,A_27w))
             => ! [V11c1: $i] :
                  ( mem(V11c1,ty_2Efcp_2Ecart(bool,A_27t))
                 => ( ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V8f),ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V9c)),V10c0),V11c1)) = ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27u,A_27w),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V9c)),V10c0),ap(V8f,V11c1)) ) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__accfupds,axiom,
    ! [A_27t: del,A_27u: del,A_27w: del,A_27x: del] :
      ( ! [V0f0: $i] :
          ( mem(V0f0,arr(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27x)))
         => ! [V1f: $i] :
              ( mem(V1f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27x),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V0f0),V1f))) = surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1f)) ) ) )
      & ! [V2f0: $i] :
          ( mem(V2f0,arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27u)))
         => ! [V3f: $i] :
              ( mem(V3f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(ap(c_2Ebinary__ieee_2Efloat__Sign(A_27u,A_27w),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V2f0),V3f))) = surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V3f)) ) ) )
      & ! [V4f0: $i] :
          ( mem(V4f0,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
         => ! [V5f: $i] :
              ( mem(V5f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ( ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V4f0),V5f)) = ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),V5f) ) ) )
      & ! [V6f0: $i] :
          ( mem(V6f0,arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27u)))
         => ! [V7f: $i] :
              ( mem(V7f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ( ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27u,A_27w),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V6f0),V7f)) = ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),V7f) ) ) )
      & ! [V8f0: $i] :
          ( mem(V8f0,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
         => ! [V9f: $i] :
              ( mem(V9f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ( ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V8f0),V9f)) = ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),V9f) ) ) )
      & ! [V10f0: $i] :
          ( mem(V10f0,arr(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27x)))
         => ! [V11f: $i] :
              ( mem(V11f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ( ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27x),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V10f0),V11f)) = ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),V11f) ) ) )
      & ! [V12f0: $i] :
          ( mem(V12f0,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
         => ! [V13f: $i] :
              ( mem(V13f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V12f0),V13f))) = surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(ap(V12f0,ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V13f))) ) ) )
      & ! [V14f0: $i] :
          ( mem(V14f0,arr(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27x)))
         => ! [V15f: $i] :
              ( mem(V15f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ( ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27x),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V14f0),V15f)) = ap(V14f0,ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),V15f)) ) ) )
      & ! [V16f0: $i] :
          ( mem(V16f0,arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27u)))
         => ! [V17f: $i] :
              ( mem(V17f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ( ap(c_2Ebinary__ieee_2Efloat__Significand(A_27u,A_27w),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V16f0),V17f)) = ap(V16f0,ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),V17f)) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__fupdfupds,axiom,
    ! [A_27t: del,A_27u: del,A_27v: del,A_27w: del,A_27x: del,A_27y: del] :
      ( ! [V0g: $i] :
          ( mem(V0g,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
         => ! [V1f0: $i] :
              ( mem(V1f0,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
             => ! [V2f: $i] :
                  ( mem(V2f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ( ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V1f0),ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V0g),V2f)) = ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),ap(ap(c_2Ecombin_2Eo(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),V1f0),V0g)),V2f) ) ) ) )
      & ! [V3g: $i] :
          ( mem(V3g,arr(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27x)))
         => ! [V4f0: $i] :
              ( mem(V4f0,arr(ty_2Efcp_2Ecart(bool,A_27x),ty_2Efcp_2Ecart(bool,A_27y)))
             => ! [V5f: $i] :
                  ( mem(V5f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ( ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27x,A_27y),V4f0),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V3g),V5f)) = ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27y),ap(ap(c_2Ecombin_2Eo(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27y),ty_2Efcp_2Ecart(bool,A_27x)),V4f0),V3g)),V5f) ) ) ) )
      & ! [V6g: $i] :
          ( mem(V6g,arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27u)))
         => ! [V7f0: $i] :
              ( mem(V7f0,arr(ty_2Efcp_2Ecart(bool,A_27u),ty_2Efcp_2Ecart(bool,A_27v)))
             => ! [V8f: $i] :
                  ( mem(V8f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ( ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27u,A_27v,A_27w),V7f0),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V6g),V8f)) = ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27v,A_27w),ap(ap(c_2Ecombin_2Eo(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27v),ty_2Efcp_2Ecart(bool,A_27u)),V7f0),V6g)),V8f) ) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__fupdfupds__comp,axiom,
    ! [A_27a: del,A_27t: del,A_27u: del,A_27v: del,A_27w: del,A_27x: del,A_27y: del] :
      ( ! [V0g: $i] :
          ( mem(V0g,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
         => ! [V1f0: $i] :
              ( mem(V1f0,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
             => ( ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V1f0)),ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V0g)) = ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),ap(ap(c_2Ecombin_2Eo(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),V1f0),V0g)) ) ) )
      & ! [V2h: $i] :
          ( mem(V2h,arr(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))
         => ! [V3g: $i] :
              ( mem(V3g,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
             => ! [V4f0: $i] :
                  ( mem(V4f0,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
                 => ( ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V4f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V3g)),V2h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),ap(ap(c_2Ecombin_2Eo(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),V4f0),V3g))),V2h) ) ) ) )
      & ! [V5g: $i] :
          ( mem(V5g,arr(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27x)))
         => ! [V6f0: $i] :
              ( mem(V6f0,arr(ty_2Efcp_2Ecart(bool,A_27x),ty_2Efcp_2Ecart(bool,A_27y)))
             => ( ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27y),ty_2Ebinary__ieee_2Efloat(A_27t,A_27x)),ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27x,A_27y),V6f0)),ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V5g)) = ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27y),ap(ap(c_2Ecombin_2Eo(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27y),ty_2Efcp_2Ecart(bool,A_27x)),V6f0),V5g)) ) ) )
      & ! [V7h: $i] :
          ( mem(V7h,arr(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))
         => ! [V8g: $i] :
              ( mem(V8g,arr(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27x)))
             => ! [V9f0: $i] :
                  ( mem(V9f0,arr(ty_2Efcp_2Ecart(bool,A_27x),ty_2Efcp_2Ecart(bool,A_27y)))
                 => ( ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27y),ty_2Ebinary__ieee_2Efloat(A_27t,A_27x)),ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27x,A_27y),V9f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27x),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V8g)),V7h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27y),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27y),ap(ap(c_2Ecombin_2Eo(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27y),ty_2Efcp_2Ecart(bool,A_27x)),V9f0),V8g))),V7h) ) ) ) )
      & ! [V10g: $i] :
          ( mem(V10g,arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27u)))
         => ! [V11f0: $i] :
              ( mem(V11f0,arr(ty_2Efcp_2Ecart(bool,A_27u),ty_2Efcp_2Ecart(bool,A_27v)))
             => ( ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27v,A_27w),ty_2Ebinary__ieee_2Efloat(A_27u,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27u,A_27v,A_27w),V11f0)),ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V10g)) = ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27v,A_27w),ap(ap(c_2Ecombin_2Eo(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27v),ty_2Efcp_2Ecart(bool,A_27u)),V11f0),V10g)) ) ) )
      & ! [V12h: $i] :
          ( mem(V12h,arr(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))
         => ! [V13g: $i] :
              ( mem(V13g,arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27u)))
             => ! [V14f0: $i] :
                  ( mem(V14f0,arr(ty_2Efcp_2Ecart(bool,A_27u),ty_2Efcp_2Ecart(bool,A_27v)))
                 => ( ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27v,A_27w),ty_2Ebinary__ieee_2Efloat(A_27u,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27u,A_27v,A_27w),V14f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27u,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V13g)),V12h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27v,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27v,A_27w),ap(ap(c_2Ecombin_2Eo(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27v),ty_2Efcp_2Ecart(bool,A_27u)),V14f0),V13g))),V12h) ) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__fupdcanon,axiom,
    ! [A_27t: del,A_27u: del,A_27w: del,A_27x: del] :
      ( ! [V0g: $i] :
          ( mem(V0g,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
         => ! [V1f0: $i] :
              ( mem(V1f0,arr(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27x)))
             => ! [V2f: $i] :
                  ( mem(V2f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ( ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V1f0),ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V0g),V2f)) = ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27x),V0g),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V1f0),V2f)) ) ) ) )
      & ! [V3g: $i] :
          ( mem(V3g,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
         => ! [V4f0: $i] :
              ( mem(V4f0,arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27u)))
             => ! [V5f: $i] :
                  ( mem(V5f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ( ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V4f0),ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V3g),V5f)) = ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27u,A_27w),V3g),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V4f0),V5f)) ) ) ) )
      & ! [V6g: $i] :
          ( mem(V6g,arr(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27x)))
         => ! [V7f0: $i] :
              ( mem(V7f0,arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27u)))
             => ! [V8f: $i] :
                  ( mem(V8f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ( ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27x),V7f0),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V6g),V8f)) = ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27u,A_27w,A_27x),V6g),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V7f0),V8f)) ) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__fupdcanon__comp,axiom,
    ! [A_27a: del,A_27t: del,A_27u: del,A_27w: del,A_27x: del] :
      ( ! [V0g: $i] :
          ( mem(V0g,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
         => ! [V1f0: $i] :
              ( mem(V1f0,arr(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27x)))
             => ( ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27x),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V1f0)),ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V0g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27x),ty_2Ebinary__ieee_2Efloat(A_27t,A_27x)),ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27x),V0g)),ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V1f0)) ) ) )
      & ! [V2h: $i] :
          ( mem(V2h,arr(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))
         => ! [V3g: $i] :
              ( mem(V3g,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
             => ! [V4f0: $i] :
                  ( mem(V4f0,arr(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27x)))
                 => ( ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27x),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V4f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V3g)),V2h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27x),ty_2Ebinary__ieee_2Efloat(A_27t,A_27x)),ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27x),V3g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27x),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V4f0)),V2h)) ) ) ) )
      & ! [V5g: $i] :
          ( mem(V5g,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
         => ! [V6f0: $i] :
              ( mem(V6f0,arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27u)))
             => ( ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27u,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V6f0)),ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V5g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27u,A_27w),ty_2Ebinary__ieee_2Efloat(A_27u,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27u,A_27w),V5g)),ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V6f0)) ) ) )
      & ! [V7h: $i] :
          ( mem(V7h,arr(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))
         => ! [V8g: $i] :
              ( mem(V8g,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
             => ! [V9f0: $i] :
                  ( mem(V9f0,arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27u)))
                 => ( ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27u,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V9f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V8g)),V7h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27u,A_27w),ty_2Ebinary__ieee_2Efloat(A_27u,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27u,A_27w),V8g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27u,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V9f0)),V7h)) ) ) ) )
      & ! [V10g: $i] :
          ( mem(V10g,arr(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27x)))
         => ! [V11f0: $i] :
              ( mem(V11f0,arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27u)))
             => ( ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27u,A_27x),ty_2Ebinary__ieee_2Efloat(A_27t,A_27x)),ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27x),V11f0)),ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V10g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27u,A_27x),ty_2Ebinary__ieee_2Efloat(A_27u,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27u,A_27w,A_27x),V10g)),ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V11f0)) ) ) )
      & ! [V12h: $i] :
          ( mem(V12h,arr(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))
         => ! [V13g: $i] :
              ( mem(V13g,arr(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27x)))
             => ! [V14f0: $i] :
                  ( mem(V14f0,arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27u)))
                 => ( ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27u,A_27x),ty_2Ebinary__ieee_2Efloat(A_27t,A_27x)),ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27x),V14f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27x),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V13g)),V12h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27u,A_27x),ty_2Ebinary__ieee_2Efloat(A_27u,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27u,A_27w,A_27x),V13g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27u,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V14f0)),V12h)) ) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__component__equality,axiom,
    ! [A_27t: del,A_27w: del,V0f1: $i] :
      ( mem(V0f1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V1f2: $i] :
          ( mem(V1f2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ( ( V0f1 = V1f2 )
          <=> ( ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V0f1)) = surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1f2)) )
              & ( ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),V0f1) = ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),V1f2) )
              & ( ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),V0f1) = ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),V1f2) ) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__updates__eq__literal,axiom,
    ! [A_27t: del,A_27u: del,A_27w: del,A_27x: del,V0f: $i] :
      ( mem(V0f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V1c1: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V2c0: $i] :
          ( mem(V2c0,ty_2Efcp_2Ecart(bool,A_27x))
         => ! [V3c: $i] :
              ( mem(V3c,ty_2Efcp_2Ecart(bool,A_27u))
             => ( ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27u,A_27x),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V1c1))),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27u,A_27w,A_27x),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27x),ty_2Efcp_2Ecart(bool,A_27w)),V2c0)),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27u),ty_2Efcp_2Ecart(bool,A_27t)),V3c)),V0f))) = ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27u,A_27x),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V1c1))),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27u,A_27w,A_27x),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27x),ty_2Efcp_2Ecart(bool,A_27w)),V2c0)),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27u),ty_2Efcp_2Ecart(bool,A_27t)),V3c)),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__literal__nchotomy,axiom,
    ! [A_27t: del,A_27u: del,A_27w: del,A_27x: del,V0f: $i] :
      ( mem(V0f,ty_2Ebinary__ieee_2Efloat(A_27u,A_27x))
     => ? [V1c1: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V2c0: $i] :
          ( mem(V2c0,ty_2Efcp_2Ecart(bool,A_27x))
          & ? [V3c: $i] :
              ( mem(V3c,ty_2Efcp_2Ecart(bool,A_27u))
              & ( V0f = ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27u,A_27x),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V1c1))),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27u,A_27w,A_27x),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27x),ty_2Efcp_2Ecart(bool,A_27w)),V2c0)),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27u),ty_2Efcp_2Ecart(bool,A_27t)),V3c)),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2EFORALL__float,axiom,
    ! [A_27t: del,A_27u: del,A_27w: del,A_27x: del,V0P: $i] :
      ( mem(V0P,arr(ty_2Ebinary__ieee_2Efloat(A_27u,A_27x),bool))
     => ( ! [V1f: $i] :
            ( mem(V1f,ty_2Ebinary__ieee_2Efloat(A_27u,A_27x))
           => p(ap(V0P,V1f)) )
      <=> ! [V2c1: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V3c0: $i] :
            ( mem(V3c0,ty_2Efcp_2Ecart(bool,A_27x))
           => ! [V4c: $i] :
                ( mem(V4c,ty_2Efcp_2Ecart(bool,A_27u))
               => p(ap(V0P,ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27u,A_27x),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V2c1))),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27u,A_27w,A_27x),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27x),ty_2Efcp_2Ecart(bool,A_27w)),V3c0)),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27u),ty_2Efcp_2Ecart(bool,A_27t)),V4c)),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2EEXISTS__float,axiom,
    ! [A_27t: del,A_27u: del,A_27w: del,A_27x: del,V0P: $i] :
      ( mem(V0P,arr(ty_2Ebinary__ieee_2Efloat(A_27u,A_27x),bool))
     => ( ? [V1f: $i] :
            ( mem(V1f,ty_2Ebinary__ieee_2Efloat(A_27u,A_27x))
            & p(ap(V0P,V1f)) )
      <=> ? [V2c1: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V3c0: $i] :
            ( mem(V3c0,ty_2Efcp_2Ecart(bool,A_27x))
            & ? [V4c: $i] :
                ( mem(V4c,ty_2Efcp_2Ecart(bool,A_27u))
                & p(ap(V0P,ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27u,A_27x),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V2c1))),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27u,A_27w,A_27x),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27x),ty_2Efcp_2Ecart(bool,A_27w)),V3c0)),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27u),ty_2Efcp_2Ecart(bool,A_27t)),V4c)),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__literal__11,axiom,
    ! [A_27t: del,A_27u: del,A_27w: del,A_27x: del,V0c11: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V1c01: $i] :
      ( mem(V1c01,ty_2Efcp_2Ecart(bool,A_27x))
     => ! [V2c1: $i] :
          ( mem(V2c1,ty_2Efcp_2Ecart(bool,A_27u))
         => ! [V3c12: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V4c02: $i] :
              ( mem(V4c02,ty_2Efcp_2Ecart(bool,A_27x))
             => ! [V5c2: $i] :
                  ( mem(V5c2,ty_2Efcp_2Ecart(bool,A_27u))
                 => ( ( ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27u,A_27x),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V0c11))),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27u,A_27w,A_27x),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27x),ty_2Efcp_2Ecart(bool,A_27w)),V1c01)),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27u),ty_2Efcp_2Ecart(bool,A_27t)),V2c1)),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))) = ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27u,A_27x),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V3c12))),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27u,A_27w,A_27x),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27x),ty_2Efcp_2Ecart(bool,A_27w)),V4c02)),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27u),ty_2Efcp_2Ecart(bool,A_27t)),V5c2)),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))) )
                  <=> ( ( V0c11 = V3c12 )
                      & ( V1c01 = V4c02 )
                      & ( V2c1 = V5c2 ) ) ) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Edatatype__float,axiom,
    ! [A_27t: del,A_27w: del,V0record: $i] :
      ( mem(V0record,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),arr(ty_2Efcp_2Ecart(bool,A_27w),arr(ty_2Efcp_2Ecart(bool,A_27t),bool)))))
     => ! [V1float: $i] :
          ( mem(V1float,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V2Sign: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V3Exponent: $i] :
              ( mem(V3Exponent,ty_2Efcp_2Ecart(bool,A_27w))
             => ! [V4Significand: $i] :
                  ( mem(V4Significand,ty_2Efcp_2Ecart(bool,A_27t))
                 => p(ap(c_2Ebool_2EDATATYPE(bool),ap(ap(ap(ap(V0record,V1float),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V2Sign)),V3Exponent),V4Significand))) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__11,axiom,
    ! [A_27t: del,A_27w: del,V0a0: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V1a1: $i] :
      ( mem(V1a1,ty_2Efcp_2Ecart(bool,A_27w))
     => ! [V2a2: $i] :
          ( mem(V2a2,ty_2Efcp_2Ecart(bool,A_27t))
         => ! [V3a0_27: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V4a1_27: $i] :
              ( mem(V4a1_27,ty_2Efcp_2Ecart(bool,A_27w))
             => ! [V5a2_27: $i] :
                  ( mem(V5a2_27,ty_2Efcp_2Ecart(bool,A_27t))
                 => ( ( ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V0a0)),V1a1),V2a2) = ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V3a0_27)),V4a1_27),V5a2_27) )
                  <=> ( ( V0a0 = V3a0_27 )
                      & ( V1a1 = V4a1_27 )
                      & ( V2a2 = V5a2_27 ) ) ) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__nchotomy,axiom,
    ! [A_27t: del,A_27w: del,V0ff: $i] :
      ( mem(V0ff,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ? [V1c: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V2c0: $i] :
          ( mem(V2c0,ty_2Efcp_2Ecart(bool,A_27w))
          & ? [V3c1: $i] :
              ( mem(V3c1,ty_2Efcp_2Ecart(bool,A_27t))
              & ( V0ff = ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V1c)),V2c0),V3c1) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__Axiom,axiom,
    ! [A_27a: del,A_27t: del,A_27w: del,V0f: $i] :
      ( mem(V0f,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),arr(ty_2Efcp_2Ecart(bool,A_27w),arr(ty_2Efcp_2Ecart(bool,A_27t),A_27a))))
     => ? [V1fn: $i] :
          ( mem(V1fn,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))
          & ! [V2a0: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V3a1: $i] :
              ( mem(V3a1,ty_2Efcp_2Ecart(bool,A_27w))
             => ! [V4a2: $i] :
                  ( mem(V4a2,ty_2Efcp_2Ecart(bool,A_27t))
                 => ( ap(V1fn,ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V2a0)),V3a1),V4a2)) = ap(ap(ap(V0f,inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V2a0)),V3a1),V4a2) ) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__induction,axiom,
    ! [A_27t: del,A_27w: del,V0P: $i] :
      ( mem(V0P,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool))
     => ( ! [V1c: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V2c0: $i] :
            ( mem(V2c0,ty_2Efcp_2Ecart(bool,A_27w))
           => ! [V3c1: $i] :
                ( mem(V3c1,ty_2Efcp_2Ecart(bool,A_27t))
               => p(ap(V0P,ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V1c)),V2c0),V3c1))) ) )
       => ! [V4f: $i] :
            ( mem(V4f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
           => p(ap(V0P,V4f)) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__case__cong,axiom,
    ! [A_27a: del,A_27t: del,A_27w: del,V0f_27: $i] :
      ( mem(V0f_27,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),arr(ty_2Efcp_2Ecart(bool,A_27w),arr(ty_2Efcp_2Ecart(bool,A_27t),A_27a))))
     => ! [V1M: $i] :
          ( mem(V1M,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V2M_27: $i] :
              ( mem(V2M_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V3f: $i] :
                  ( mem(V3f,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),arr(ty_2Efcp_2Ecart(bool,A_27w),arr(ty_2Efcp_2Ecart(bool,A_27t),A_27a))))
                 => ( ( ( V1M = V2M_27 )
                      & ! [V4a0: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V5a1: $i] :
                          ( mem(V5a1,ty_2Efcp_2Ecart(bool,A_27w))
                         => ! [V6a2: $i] :
                              ( mem(V6a2,ty_2Efcp_2Ecart(bool,A_27t))
                             => ( ( V2M_27 = ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V4a0)),V5a1),V6a2) )
                               => ( ap(ap(ap(V3f,inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V4a0)),V5a1),V6a2) = ap(ap(ap(V0f_27,inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V4a0)),V5a1),V6a2) ) ) ) ) )
                   => ( ap(ap(c_2Ebinary__ieee_2Efloat__CASE(A_27a,A_27t,A_27w),V1M),V3f) = ap(ap(c_2Ebinary__ieee_2Efloat__CASE(A_27a,A_27t,A_27w),V2M_27),V0f_27) ) ) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__case__eq,axiom,
    ! [A_27a: del,A_27t: del,A_27w: del,V0x: $i] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V1f: $i] :
          ( mem(V1f,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),arr(ty_2Efcp_2Ecart(bool,A_27w),arr(ty_2Efcp_2Ecart(bool,A_27t),A_27a))))
         => ! [V2v: $i] :
              ( mem(V2v,A_27a)
             => ( ( ap(ap(c_2Ebinary__ieee_2Efloat__CASE(A_27a,A_27t,A_27w),V0x),V1f) = V2v )
              <=> ? [V3c: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V4c0: $i] :
                    ( mem(V4c0,ty_2Efcp_2Ecart(bool,A_27w))
                    & ? [V5c1: $i] :
                        ( mem(V5c1,ty_2Efcp_2Ecart(bool,A_27t))
                        & ( V0x = ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V3c)),V4c0),V5c1) )
                        & ( ap(ap(ap(V1f,inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V3c)),V4c0),V5c1) = V2v ) ) ) ) ) ) ) ).

tff(stp_c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal,type,
    tp__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal: $tType ).

tff(stp_inj_c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal,type,
    inj__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal: tp__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal > $i ).

tff(stp_surj_c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal,type,
    surj__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal: $i > tp__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal ).

tff(stp_inj_surj_c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal,axiom,
    ! [X: tp__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal] : ( surj__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal(inj__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal(X)) = X ) ).

tff(stp_inj_mem_c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal,axiom,
    ! [X: tp__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal] : mem(inj__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal(X),ty_2Eind__type_2Erecspace(ty_2Erealax_2Ereal)) ).

tff(stp_iso_mem_c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal,axiom,
    ! [X: $i] :
      ( mem(X,ty_2Eind__type_2Erecspace(ty_2Erealax_2Ereal))
     => ( X = inj__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal(surj__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal(X)) ) ) ).

tff(lamtp_f2926,type,
    f2926: $i ).

tff(lameq_f2926,axiom,
    ! [V5a: tp__ty_2Erealax_2Ereal] : ( ap(f2926,inj__ty_2Erealax_2Ereal(V5a)) = ap(ap(ap(c_2Eind__type_2ECONSTR(ty_2Erealax_2Ereal),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)),inj__ty_2Erealax_2Ereal(V5a)),k(ty_2Enum_2Enum,c_2Eind__type_2EBOTTOM(ty_2Erealax_2Ereal))) ) ).

tff(lamtp_f2927,type,
    f2927: tp__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal > $i ).

tff(lameq_f2927,axiom,
    ! [V3a0: tp__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal,V4a: tp__ty_2Erealax_2Ereal] : ( ap(f2927(V3a0),inj__ty_2Erealax_2Ereal(V4a)) = ap(ap(c_2Emin_2E_3D(ty_2Eind__type_2Erecspace(ty_2Erealax_2Ereal)),inj__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal(V3a0)),ap(f2926,inj__ty_2Erealax_2Ereal(V4a))) ) ).

tff(lamtp_f2928,type,
    f2928: $i > $i ).

tff(lameq_f2928,axiom,
    ! [V2_27float__value_27: $i] :
      ( mem(V2_27float__value_27,arr(ty_2Eind__type_2Erecspace(ty_2Erealax_2Ereal),bool))
     => ! [V3a0: tp__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal] : ( ap(f2928(V2_27float__value_27),inj__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal(V3a0)) = ap(ap(c_2Emin_2E_3D_3D_3E,ap(ap(c_2Ebool_2E_5C_2F,ap(c_2Ebool_2E_3F(ty_2Erealax_2Ereal),f2927(V3a0))),ap(ap(c_2Ebool_2E_5C_2F,ap(ap(c_2Emin_2E_3D(ty_2Eind__type_2Erecspace(ty_2Erealax_2Ereal)),inj__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal(V3a0)),ap(ap(ap(c_2Eind__type_2ECONSTR(ty_2Erealax_2Ereal),ap(c_2Enum_2ESUC,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0))),c_2Ebool_2EARB(ty_2Erealax_2Ereal)),k(ty_2Enum_2Enum,c_2Eind__type_2EBOTTOM(ty_2Erealax_2Ereal))))),ap(ap(c_2Emin_2E_3D(ty_2Eind__type_2Erecspace(ty_2Erealax_2Ereal)),inj__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal(V3a0)),ap(ap(ap(c_2Eind__type_2ECONSTR(ty_2Erealax_2Ereal),ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))),c_2Ebool_2EARB(ty_2Erealax_2Ereal)),k(ty_2Enum_2Enum,c_2Eind__type_2EBOTTOM(ty_2Erealax_2Ereal))))))),ap(V2_27float__value_27,inj__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal(V3a0))) ) ) ).

tff(lamtp_f2929,type,
    f2929: tp__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal > $i ).

tff(lameq_f2929,axiom,
    ! [V1a0: tp__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal,V2_27float__value_27: $i] : ( ap(f2929(V1a0),V2_27float__value_27) = ap(ap(c_2Emin_2E_3D_3D_3E,ap(c_2Ebool_2E_21(ty_2Eind__type_2Erecspace(ty_2Erealax_2Ereal)),f2928(V2_27float__value_27))),ap(V2_27float__value_27,inj__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal(V1a0))) ) ).

tff(lamtp_f2930,type,
    f2930: $i ).

tff(lameq_f2930,axiom,
    ! [V1a0: tp__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal] : ( ap(f2930,inj__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal(V1a0)) = ap(c_2Ebool_2E_21(arr(ty_2Eind__type_2Erecspace(ty_2Erealax_2Ereal),bool)),f2929(V1a0)) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__value__TY__DEF,axiom,
    ? [V0rep: $i] :
      ( mem(V0rep,arr(ty_2Ebinary__ieee_2Efloat__value,ty_2Eind__type_2Erecspace(ty_2Erealax_2Ereal)))
      & p(ap(ap(c_2Ebool_2ETYPE__DEFINITION(ty_2Eind__type_2Erecspace(ty_2Erealax_2Ereal),ty_2Ebinary__ieee_2Efloat__value),f2930),V0rep)) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__value__case__def,axiom,
    ! [A_27a: del] :
      ( ! [V0a: tp__ty_2Erealax_2Ereal,V1f: $i] :
          ( mem(V1f,arr(ty_2Erealax_2Ereal,A_27a))
         => ! [V2v: $i] :
              ( mem(V2v,A_27a)
             => ! [V3v1: $i] :
                  ( mem(V3v1,A_27a)
                 => ( ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(A_27a),ap(c_2Ebinary__ieee_2EFloat,inj__ty_2Erealax_2Ereal(V0a))),V1f),V2v),V3v1) = ap(V1f,inj__ty_2Erealax_2Ereal(V0a)) ) ) ) )
      & ! [V4f: $i] :
          ( mem(V4f,arr(ty_2Erealax_2Ereal,A_27a))
         => ! [V5v: $i] :
              ( mem(V5v,A_27a)
             => ! [V6v1: $i] :
                  ( mem(V6v1,A_27a)
                 => ( ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(A_27a),inj__ty_2Ebinary__ieee_2Efloat__value(fo__c_2Ebinary__ieee_2EInfinity)),V4f),V5v),V6v1) = V5v ) ) ) )
      & ! [V7f: $i] :
          ( mem(V7f,arr(ty_2Erealax_2Ereal,A_27a))
         => ! [V8v: $i] :
              ( mem(V8v,A_27a)
             => ! [V9v1: $i] :
                  ( mem(V9v1,A_27a)
                 => ( ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(A_27a),inj__ty_2Ebinary__ieee_2Efloat__value(fo__c_2Ebinary__ieee_2ENaN)),V7f),V8v),V9v1) = V9v1 ) ) ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__value__size__def,axiom,
    ( ! [V0a: tp__ty_2Erealax_2Ereal] : ( surj__ty_2Enum_2Enum(ap(c_2Ebinary__ieee_2Efloat__value__size,ap(c_2Ebinary__ieee_2EFloat,inj__ty_2Erealax_2Ereal(V0a)))) = surj__ty_2Enum_2Enum(ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))) )
    & ( surj__ty_2Enum_2Enum(ap(c_2Ebinary__ieee_2Efloat__value__size,inj__ty_2Ebinary__ieee_2Efloat__value(fo__c_2Ebinary__ieee_2EInfinity))) = fo__c_2Enum_2E0 )
    & ( surj__ty_2Enum_2Enum(ap(c_2Ebinary__ieee_2Efloat__value__size,inj__ty_2Ebinary__ieee_2Efloat__value(fo__c_2Ebinary__ieee_2ENaN))) = fo__c_2Enum_2E0 ) ) ).

tff(conj_thm_2Ebinary__ieee_2Edatatype__float__value,axiom,
    ! [V0float__value: $i] :
      ( mem(V0float__value,arr(arr(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat__value),arr(ty_2Ebinary__ieee_2Efloat__value,arr(ty_2Ebinary__ieee_2Efloat__value,bool))))
     => p(ap(c_2Ebool_2EDATATYPE(bool),ap(ap(ap(V0float__value,c_2Ebinary__ieee_2EFloat),inj__ty_2Ebinary__ieee_2Efloat__value(fo__c_2Ebinary__ieee_2EInfinity)),inj__ty_2Ebinary__ieee_2Efloat__value(fo__c_2Ebinary__ieee_2ENaN)))) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__value__11,axiom,
    ! [V0a: tp__ty_2Erealax_2Ereal,V1a_27: tp__ty_2Erealax_2Ereal] :
      ( ( surj__ty_2Ebinary__ieee_2Efloat__value(ap(c_2Ebinary__ieee_2EFloat,inj__ty_2Erealax_2Ereal(V0a))) = surj__ty_2Ebinary__ieee_2Efloat__value(ap(c_2Ebinary__ieee_2EFloat,inj__ty_2Erealax_2Ereal(V1a_27))) )
    <=> ( V0a = V1a_27 ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__value__distinct,axiom,
    ( ! [V0a: tp__ty_2Erealax_2Ereal] : ( surj__ty_2Ebinary__ieee_2Efloat__value(ap(c_2Ebinary__ieee_2EFloat,inj__ty_2Erealax_2Ereal(V0a))) != fo__c_2Ebinary__ieee_2EInfinity )
    & ! [V1a: tp__ty_2Erealax_2Ereal] : ( surj__ty_2Ebinary__ieee_2Efloat__value(ap(c_2Ebinary__ieee_2EFloat,inj__ty_2Erealax_2Ereal(V1a))) != fo__c_2Ebinary__ieee_2ENaN )
    & ( fo__c_2Ebinary__ieee_2EInfinity != fo__c_2Ebinary__ieee_2ENaN ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__value__nchotomy,axiom,
    ! [V0ff: tp__ty_2Ebinary__ieee_2Efloat__value] :
      ( ? [V1r: tp__ty_2Erealax_2Ereal] : ( V0ff = surj__ty_2Ebinary__ieee_2Efloat__value(ap(c_2Ebinary__ieee_2EFloat,inj__ty_2Erealax_2Ereal(V1r))) )
      | ( V0ff = fo__c_2Ebinary__ieee_2EInfinity )
      | ( V0ff = fo__c_2Ebinary__ieee_2ENaN ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__value__Axiom,axiom,
    ! [A_27a: del,V0f0: $i] :
      ( mem(V0f0,arr(ty_2Erealax_2Ereal,A_27a))
     => ! [V1f1: $i] :
          ( mem(V1f1,A_27a)
         => ! [V2f2: $i] :
              ( mem(V2f2,A_27a)
             => ? [V3fn: $i] :
                  ( mem(V3fn,arr(ty_2Ebinary__ieee_2Efloat__value,A_27a))
                  & ! [V4a: tp__ty_2Erealax_2Ereal] : ( ap(V3fn,ap(c_2Ebinary__ieee_2EFloat,inj__ty_2Erealax_2Ereal(V4a))) = ap(V0f0,inj__ty_2Erealax_2Ereal(V4a)) )
                  & ( ap(V3fn,inj__ty_2Ebinary__ieee_2Efloat__value(fo__c_2Ebinary__ieee_2EInfinity)) = V1f1 )
                  & ( ap(V3fn,inj__ty_2Ebinary__ieee_2Efloat__value(fo__c_2Ebinary__ieee_2ENaN)) = V2f2 ) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__value__induction,axiom,
    ! [V0P: $i] :
      ( mem(V0P,arr(ty_2Ebinary__ieee_2Efloat__value,bool))
     => ( ( ! [V1r: tp__ty_2Erealax_2Ereal] : p(ap(V0P,ap(c_2Ebinary__ieee_2EFloat,inj__ty_2Erealax_2Ereal(V1r))))
          & p(ap(V0P,inj__ty_2Ebinary__ieee_2Efloat__value(fo__c_2Ebinary__ieee_2EInfinity)))
          & p(ap(V0P,inj__ty_2Ebinary__ieee_2Efloat__value(fo__c_2Ebinary__ieee_2ENaN))) )
       => ! [V2f: tp__ty_2Ebinary__ieee_2Efloat__value] : p(ap(V0P,inj__ty_2Ebinary__ieee_2Efloat__value(V2f))) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__value__case__cong,axiom,
    ! [A_27a: del,V0f_27: $i] :
      ( mem(V0f_27,arr(ty_2Erealax_2Ereal,A_27a))
     => ! [V1v_27: $i] :
          ( mem(V1v_27,A_27a)
         => ! [V2v1_27: $i] :
              ( mem(V2v1_27,A_27a)
             => ! [V3M: tp__ty_2Ebinary__ieee_2Efloat__value,V4M_27: tp__ty_2Ebinary__ieee_2Efloat__value,V5f: $i] :
                  ( mem(V5f,arr(ty_2Erealax_2Ereal,A_27a))
                 => ! [V6v: $i] :
                      ( mem(V6v,A_27a)
                     => ! [V7v1: $i] :
                          ( mem(V7v1,A_27a)
                         => ( ( ( V3M = V4M_27 )
                              & ! [V8a: tp__ty_2Erealax_2Ereal] :
                                  ( ( V4M_27 = surj__ty_2Ebinary__ieee_2Efloat__value(ap(c_2Ebinary__ieee_2EFloat,inj__ty_2Erealax_2Ereal(V8a))) )
                                 => ( ap(V5f,inj__ty_2Erealax_2Ereal(V8a)) = ap(V0f_27,inj__ty_2Erealax_2Ereal(V8a)) ) )
                              & ( ( V4M_27 = fo__c_2Ebinary__ieee_2EInfinity )
                               => ( V6v = V1v_27 ) )
                              & ( ( V4M_27 = fo__c_2Ebinary__ieee_2ENaN )
                               => ( V7v1 = V2v1_27 ) ) )
                           => ( ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(A_27a),inj__ty_2Ebinary__ieee_2Efloat__value(V3M)),V5f),V6v),V7v1) = ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(A_27a),inj__ty_2Ebinary__ieee_2Efloat__value(V4M_27)),V0f_27),V1v_27),V2v1_27) ) ) ) ) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__value__case__eq,axiom,
    ! [A_27a: del,V0x: tp__ty_2Ebinary__ieee_2Efloat__value,V1f: $i] :
      ( mem(V1f,arr(ty_2Erealax_2Ereal,A_27a))
     => ! [V2v: $i] :
          ( mem(V2v,A_27a)
         => ! [V3v1: $i] :
              ( mem(V3v1,A_27a)
             => ! [V4v_27: $i] :
                  ( mem(V4v_27,A_27a)
                 => ( ( ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(A_27a),inj__ty_2Ebinary__ieee_2Efloat__value(V0x)),V1f),V2v),V3v1) = V4v_27 )
                  <=> ( ? [V5r: tp__ty_2Erealax_2Ereal] :
                          ( ( V0x = surj__ty_2Ebinary__ieee_2Efloat__value(ap(c_2Ebinary__ieee_2EFloat,inj__ty_2Erealax_2Ereal(V5r))) )
                          & ( ap(V1f,inj__ty_2Erealax_2Ereal(V5r)) = V4v_27 ) )
                      | ( ( V0x = fo__c_2Ebinary__ieee_2EInfinity )
                        & ( V2v = V4v_27 ) )
                      | ( ( V0x = fo__c_2Ebinary__ieee_2ENaN )
                        & ( V3v1 = V4v_27 ) ) ) ) ) ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__to__real__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ( surj__ty_2Erealax_2Ereal(ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),V0x)) = surj__ty_2Erealax_2Ereal(ap(ap(ap(c_2Ebool_2ECOND(ty_2Erealax_2Ereal),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),V0x)),ap(c_2Ewords_2En2w(A_27w),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))),ap(ap(c_2Erealax_2Ereal__mul,ap(ap(c_2Erealax_2Ereal__mul,ap(ap(c_2Ereal_2Epow,ap(c_2Erealax_2Ereal__neg,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))))),ap(c_2Ewords_2Ew2n(ty_2Eone_2Eone),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V0x)))),ap(ap(c_2Ereal_2E_2F,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),ap(c_2Ewords_2EINT__MAX(A_27w),c_2Ebool_2Ethe__value(A_27w)))))),ap(ap(c_2Ereal_2E_2F,ap(c_2Ereal_2Ereal__of__num,ap(c_2Ewords_2Ew2n(A_27t),ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),V0x)))),ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),ap(c_2Efcp_2Edimindex(A_27t),c_2Ebool_2Ethe__value(A_27t)))))),ap(ap(c_2Erealax_2Ereal__mul,ap(ap(c_2Erealax_2Ereal__mul,ap(ap(c_2Ereal_2Epow,ap(c_2Erealax_2Ereal__neg,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))))),ap(c_2Ewords_2Ew2n(ty_2Eone_2Eone),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V0x)))),ap(ap(c_2Ereal_2E_2F,ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),ap(c_2Ewords_2Ew2n(A_27w),ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),V0x)))),ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),ap(c_2Ewords_2EINT__MAX(A_27w),c_2Ebool_2Ethe__value(A_27w)))))),ap(ap(c_2Erealax_2Ereal__add,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),ap(ap(c_2Ereal_2E_2F,ap(c_2Ereal_2Ereal__of__num,ap(c_2Ewords_2Ew2n(A_27t),ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),V0x)))),ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),ap(c_2Efcp_2Edimindex(A_27t),c_2Ebool_2Ethe__value(A_27t)))))))) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__value__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ( surj__ty_2Ebinary__ieee_2Efloat__value(ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V0x)) = surj__ty_2Ebinary__ieee_2Efloat__value(ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat__value),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),V0x)),c_2Ewords_2Eword__T(A_27w))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat__value),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,A_27t)),ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),V0x)),ap(c_2Ewords_2En2w(A_27t),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))),inj__ty_2Ebinary__ieee_2Efloat__value(fo__c_2Ebinary__ieee_2EInfinity)),inj__ty_2Ebinary__ieee_2Efloat__value(fo__c_2Ebinary__ieee_2ENaN))),ap(c_2Ebinary__ieee_2EFloat,ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),V0x)))) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__is__nan__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ( p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),V0x))
      <=> p(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(bool),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V0x)),k(ty_2Erealax_2Ereal,c_2Ebool_2EF)),inj__o(fo__c_2Ebool_2EF)),inj__o(fo__c_2Ebool_2ET))) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__is__signalling__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ( p(ap(c_2Ebinary__ieee_2Efloat__is__signalling(A_27t,A_27w),V0x))
      <=> ( p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),V0x))
          & ~ p(ap(c_2Ewords_2Eword__msb(A_27t),ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),V0x))) ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__is__infinite__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ( p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V0x))
      <=> p(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(bool),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V0x)),k(ty_2Erealax_2Ereal,c_2Ebool_2EF)),inj__o(fo__c_2Ebool_2ET)),inj__o(fo__c_2Ebool_2EF))) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__is__normal__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ( p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27t,A_27w),V0x))
      <=> ( ( ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),V0x) != ap(c_2Ewords_2En2w(A_27w),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)) )
          & ( ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),V0x) != c_2Ewords_2Eword__T(A_27w) ) ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__is__subnormal__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ( p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27t,A_27w),V0x))
      <=> ( ( ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),V0x) = ap(c_2Ewords_2En2w(A_27w),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)) )
          & ( ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),V0x) != ap(c_2Ewords_2En2w(A_27t),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)) ) ) ) ) ).

tff(lamtp_f2931,type,
    f2931: $i ).

tff(lameq_f2931,axiom,
    ! [V1r: tp__ty_2Erealax_2Ereal] : ( ap(f2931,inj__ty_2Erealax_2Ereal(V1r)) = ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),inj__ty_2Erealax_2Ereal(V1r)),ap(c_2Ereal_2Ereal__of__num,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0))) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__is__zero__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ( p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w),V0x))
      <=> p(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(bool),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V0x)),f2931),inj__o(fo__c_2Ebool_2EF)),inj__o(fo__c_2Ebool_2EF))) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__is__finite__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ( p(ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27t,A_27w),V0x))
      <=> p(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(bool),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V0x)),k(ty_2Erealax_2Ereal,c_2Ebool_2ET)),inj__o(fo__c_2Ebool_2EF)),inj__o(fo__c_2Ebool_2EF))) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Eis__integral__def,axiom,
    ! [V0r: tp__ty_2Erealax_2Ereal] :
      ( p(ap(c_2Ebinary__ieee_2Eis__integral,inj__ty_2Erealax_2Ereal(V0r)))
    <=> ? [V1n: tp__ty_2Enum_2Enum] : ( surj__ty_2Erealax_2Ereal(ap(c_2Ereal_2Eabs,inj__ty_2Erealax_2Ereal(V0r))) = surj__ty_2Erealax_2Ereal(ap(c_2Ereal_2Ereal__of__num,inj__ty_2Enum_2Enum(V1n))) ) ) ).

tff(lamtp_f2932,type,
    f2932: $i ).

tff(lameq_f2932,axiom,
    ! [V1r: tp__ty_2Erealax_2Ereal] : ( ap(f2932,inj__ty_2Erealax_2Ereal(V1r)) = ap(c_2Ebinary__ieee_2Eis__integral,inj__ty_2Erealax_2Ereal(V1r)) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__is__integral__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ( p(ap(c_2Ebinary__ieee_2Efloat__is__integral(A_27t,A_27w),V0x))
      <=> p(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(bool),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V0x)),f2932),inj__o(fo__c_2Ebool_2EF)),inj__o(fo__c_2Ebool_2EF))) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__negate__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ( ap(c_2Ebinary__ieee_2Efloat__negate(A_27t,A_27w),V0x) = ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ewords_2Eword__1comp(ty_2Eone_2Eone),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V0x)))),V0x) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__abs__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ( ap(c_2Ebinary__ieee_2Efloat__abs(A_27t,A_27w),V0x) = ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))),V0x) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__plus__infinity__def,axiom,
    ! [A_27t: del,A_27w: del] : ( ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) = ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27w)),c_2Ewords_2Eword__T(A_27w))),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27t,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27t)),ap(c_2Ewords_2En2w(A_27t),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__plus__zero__def,axiom,
    ! [A_27t: del,A_27w: del] : ( ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) = ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27w)),ap(c_2Ewords_2En2w(A_27w),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27t,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27t)),ap(c_2Ewords_2En2w(A_27t),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__top__def,axiom,
    ! [A_27t: del,A_27w: del] : ( ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) = ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27w)),ap(ap(c_2Ewords_2Eword__sub(A_27w),c_2Ewords_2Eword__T(A_27w)),ap(c_2Ewords_2En2w(A_27w),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))))),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27t,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27t)),c_2Ewords_2Eword__T(A_27t))),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__plus__min__def,axiom,
    ! [A_27t: del,A_27w: del] : ( ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) = ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27w)),ap(c_2Ewords_2En2w(A_27w),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27t,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27t)),ap(c_2Ewords_2En2w(A_27t),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))))),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__minus__infinity__def,axiom,
    ! [A_27t: del,A_27w: del] : ( ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) = ap(c_2Ebinary__ieee_2Efloat__negate(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__minus__zero__def,axiom,
    ! [A_27t: del,A_27w: del] : ( ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) = ap(c_2Ebinary__ieee_2Efloat__negate(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__bottom__def,axiom,
    ! [A_27t: del,A_27w: del] : ( ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) = ap(c_2Ebinary__ieee_2Efloat__negate(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__minus__min__def,axiom,
    ! [A_27t: del,A_27w: del] : ( ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) = ap(c_2Ebinary__ieee_2Efloat__negate(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) ) ).

tff(stp_c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,type,
    tp__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o: $tType ).

tff(stp_inj_c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,type,
    inj__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o: tp__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o > $i ).

tff(stp_surj_c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,type,
    surj__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o: $i > tp__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o ).

tff(stp_inj_surj_c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,axiom,
    ! [X: tp__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o] : ( surj__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o(inj__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o(X)) = X ) ).

tff(stp_inj_mem_c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,axiom,
    ! [X: tp__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o] : mem(inj__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o(X),ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool))))))) ).

tff(stp_iso_mem_c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,axiom,
    ! [X: $i] :
      ( mem(X,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool)))))))
     => ( X = inj__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o(surj__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o(X)) ) ) ).

tff(stp_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,type,
    tp__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o: $tType ).

tff(stp_inj_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,type,
    inj__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o: tp__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o > $i ).

tff(stp_surj_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,type,
    surj__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o: $i > tp__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o ).

tff(stp_inj_surj_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,axiom,
    ! [X: tp__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o] : ( surj__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o(inj__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o(X)) = X ) ).

tff(stp_inj_mem_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,axiom,
    ! [X: tp__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o] : mem(inj__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o(X),ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool)))))) ).

tff(stp_iso_mem_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,axiom,
    ! [X: $i] :
      ( mem(X,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool))))))
     => ( X = inj__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o(surj__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o(X)) ) ) ).

tff(stp_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,type,
    tp__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o: $tType ).

tff(stp_inj_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,type,
    inj__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o: tp__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o > $i ).

tff(stp_surj_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,type,
    surj__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o: $i > tp__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o ).

tff(stp_inj_surj_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,axiom,
    ! [X: tp__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o] : ( surj__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o(inj__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o(X)) = X ) ).

tff(stp_inj_mem_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,axiom,
    ! [X: tp__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o] : mem(inj__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o(X),ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool))))) ).

tff(stp_iso_mem_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,axiom,
    ! [X: $i] :
      ( mem(X,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool)))))
     => ( X = inj__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o(surj__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o(X)) ) ) ).

tff(lamtp_f2933,type,
    f2933: ( tp__o * tp__o * tp__o * tp__o * tp__o ) > $i ).

tff(lameq_f2933,axiom,
    ! [V11a1: tp__o,V13a3: tp__o,V14a4: tp__o,V12a2: tp__o,V10a0: tp__o,V15a5: tp__o] : ( ap(f2933(V11a1,V13a3,V14a4,V12a2,V10a0),inj__o(V15a5)) = ap(ap(ap(c_2Eind__type_2ECONSTR(ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool)))))),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)),ap(ap(c_2Epair_2E_2C(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool))))),inj__o(V10a0)),ap(ap(c_2Epair_2E_2C(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool)))),inj__o(V11a1)),ap(ap(c_2Epair_2E_2C(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool))),inj__o(V12a2)),ap(ap(c_2Epair_2E_2C(bool,ty_2Epair_2Eprod(bool,bool)),inj__o(V13a3)),ap(ap(c_2Epair_2E_2C(bool,bool),inj__o(V14a4)),inj__o(V15a5))))))),k(ty_2Enum_2Enum,c_2Eind__type_2EBOTTOM(ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool)))))))) ) ).

tff(lamtp_f2934,type,
    f2934: ( tp__o * tp__o * tp__o * tp__o ) > $i ).

tff(lameq_f2934,axiom,
    ! [V11a1: tp__o,V13a3: tp__o,V12a2: tp__o,V10a0: tp__o,V14a4: tp__o] : ( ap(f2934(V11a1,V13a3,V12a2,V10a0),inj__o(V14a4)) = f2933(V11a1,V13a3,V14a4,V12a2,V10a0) ) ).

tff(lamtp_f2935,type,
    f2935: ( tp__o * tp__o * tp__o ) > $i ).

tff(lameq_f2935,axiom,
    ! [V11a1: tp__o,V12a2: tp__o,V10a0: tp__o,V13a3: tp__o] : ( ap(f2935(V11a1,V12a2,V10a0),inj__o(V13a3)) = f2934(V11a1,V13a3,V12a2,V10a0) ) ).

tff(lamtp_f2936,type,
    f2936: ( tp__o * tp__o ) > $i ).

tff(lameq_f2936,axiom,
    ! [V11a1: tp__o,V10a0: tp__o,V12a2: tp__o] : ( ap(f2936(V11a1,V10a0),inj__o(V12a2)) = f2935(V11a1,V12a2,V10a0) ) ).

tff(lamtp_f2937,type,
    f2937: tp__o > $i ).

tff(lameq_f2937,axiom,
    ! [V10a0: tp__o,V11a1: tp__o] : ( ap(f2937(V10a0),inj__o(V11a1)) = f2936(V11a1,V10a0) ) ).

tff(lamtp_f2938,type,
    f2938: $i ).

tff(lameq_f2938,axiom,
    ! [V10a0: tp__o] : ( ap(f2938,inj__o(V10a0)) = f2937(V10a0) ) ).

tff(lamtp_f2939,type,
    f2939: ( tp__o * tp__o * tp__o * tp__o * tp__o * tp__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o ) > $i ).

tff(lameq_f2939,axiom,
    ! [V7a3: tp__o,V5a1: tp__o,V4a0: tp__o,V6a2: tp__o,V8a4: tp__o,V3a0_27: tp__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,V9a5: tp__o] : ( ap(f2939(V7a3,V5a1,V4a0,V6a2,V8a4,V3a0_27),inj__o(V9a5)) = ap(ap(c_2Emin_2E_3D(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool))))))),inj__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o(V3a0_27)),ap(ap(ap(ap(ap(ap(f2938,inj__o(V4a0)),inj__o(V5a1)),inj__o(V6a2)),inj__o(V7a3)),inj__o(V8a4)),inj__o(V9a5))) ) ).

tff(lamtp_f2940,type,
    f2940: ( tp__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o * tp__o * tp__o * tp__o * tp__o ) > $i ).

tff(lameq_f2940,axiom,
    ! [V3a0_27: tp__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,V6a2: tp__o,V4a0: tp__o,V5a1: tp__o,V7a3: tp__o,V8a4: tp__o] : ( ap(f2940(V3a0_27,V6a2,V4a0,V5a1,V7a3),inj__o(V8a4)) = ap(c_2Ebool_2E_3F(bool),f2939(V7a3,V5a1,V4a0,V6a2,V8a4,V3a0_27)) ) ).

tff(lamtp_f2941,type,
    f2941: ( tp__o * tp__o * tp__o * tp__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o ) > $i ).

tff(lameq_f2941,axiom,
    ! [V5a1: tp__o,V4a0: tp__o,V6a2: tp__o,V3a0_27: tp__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,V7a3: tp__o] : ( ap(f2941(V5a1,V4a0,V6a2,V3a0_27),inj__o(V7a3)) = ap(c_2Ebool_2E_3F(bool),f2940(V3a0_27,V6a2,V4a0,V5a1,V7a3)) ) ).

tff(lamtp_f2942,type,
    f2942: ( tp__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o * tp__o * tp__o ) > $i ).

tff(lameq_f2942,axiom,
    ! [V3a0_27: tp__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,V4a0: tp__o,V5a1: tp__o,V6a2: tp__o] : ( ap(f2942(V3a0_27,V4a0,V5a1),inj__o(V6a2)) = ap(c_2Ebool_2E_3F(bool),f2941(V5a1,V4a0,V6a2,V3a0_27)) ) ).

tff(lamtp_f2943,type,
    f2943: ( tp__o * tp__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o ) > $i ).

tff(lameq_f2943,axiom,
    ! [V4a0: tp__o,V3a0_27: tp__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,V5a1: tp__o] : ( ap(f2943(V4a0,V3a0_27),inj__o(V5a1)) = ap(c_2Ebool_2E_3F(bool),f2942(V3a0_27,V4a0,V5a1)) ) ).

tff(lamtp_f2944,type,
    f2944: tp__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o > $i ).

tff(lameq_f2944,axiom,
    ! [V3a0_27: tp__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,V4a0: tp__o] : ( ap(f2944(V3a0_27),inj__o(V4a0)) = ap(c_2Ebool_2E_3F(bool),f2943(V4a0,V3a0_27)) ) ).

tff(lamtp_f2945,type,
    f2945: $i > $i ).

tff(lameq_f2945,axiom,
    ! [V2_27flags_27: $i] :
      ( mem(V2_27flags_27,arr(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool)))))),bool))
     => ! [V3a0_27: tp__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o] : ( ap(f2945(V2_27flags_27),inj__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o(V3a0_27)) = ap(ap(c_2Emin_2E_3D_3D_3E,ap(c_2Ebool_2E_3F(bool),f2944(V3a0_27))),ap(V2_27flags_27,inj__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o(V3a0_27))) ) ) ).

tff(lamtp_f2946,type,
    f2946: tp__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o > $i ).

tff(lameq_f2946,axiom,
    ! [V1a0_27: tp__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,V2_27flags_27: $i] : ( ap(f2946(V1a0_27),V2_27flags_27) = ap(ap(c_2Emin_2E_3D_3D_3E,ap(c_2Ebool_2E_21(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool))))))),f2945(V2_27flags_27))),ap(V2_27flags_27,inj__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o(V1a0_27))) ) ).

tff(lamtp_f2947,type,
    f2947: $i ).

tff(lameq_f2947,axiom,
    ! [V1a0_27: tp__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o] : ( ap(f2947,inj__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o(V1a0_27)) = ap(c_2Ebool_2E_21(arr(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool)))))),bool)),f2946(V1a0_27)) ) ).

tff(ax_thm_2Ebinary__ieee_2Eflags__TY__DEF,axiom,
    ? [V0rep: $i] :
      ( mem(V0rep,arr(ty_2Ebinary__ieee_2Eflags,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool))))))))
      & p(ap(ap(c_2Ebool_2ETYPE__DEFINITION(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool)))))),ty_2Ebinary__ieee_2Eflags),f2947),V0rep)) ) ).

tff(ax_thm_2Ebinary__ieee_2Eflags__case__def,axiom,
    ! [A_27a: del,V0a0: tp__o,V1a1: tp__o,V2a2: tp__o,V3a3: tp__o,V4a4: tp__o,V5a5: tp__o,V6f: $i] :
      ( mem(V6f,arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,A_27a)))))))
     => ( ap(ap(c_2Ebinary__ieee_2Eflags__CASE(A_27a),ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V0a0)),inj__o(V1a1)),inj__o(V2a2)),inj__o(V3a3)),inj__o(V4a4)),inj__o(V5a5))),V6f) = ap(ap(ap(ap(ap(ap(V6f,inj__o(V0a0)),inj__o(V1a1)),inj__o(V2a2)),inj__o(V3a3)),inj__o(V4a4)),inj__o(V5a5)) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Eflags__size__def,axiom,
    ! [V0a0: tp__o,V1a1: tp__o,V2a2: tp__o,V3a3: tp__o,V4a4: tp__o,V5a5: tp__o] : ( surj__ty_2Enum_2Enum(ap(c_2Ebinary__ieee_2Eflags__size,ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V0a0)),inj__o(V1a1)),inj__o(V2a2)),inj__o(V3a3)),inj__o(V4a4)),inj__o(V5a5)))) = surj__ty_2Enum_2Enum(ap(ap(c_2Earithmetic_2E_2B,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))),ap(ap(c_2Earithmetic_2E_2B,ap(c_2EbasicSize_2Ebool__size,inj__o(V0a0))),ap(ap(c_2Earithmetic_2E_2B,ap(c_2EbasicSize_2Ebool__size,inj__o(V1a1))),ap(ap(c_2Earithmetic_2E_2B,ap(c_2EbasicSize_2Ebool__size,inj__o(V2a2))),ap(ap(c_2Earithmetic_2E_2B,ap(c_2EbasicSize_2Ebool__size,inj__o(V3a3))),ap(ap(c_2Earithmetic_2E_2B,ap(c_2EbasicSize_2Ebool__size,inj__o(V4a4))),ap(c_2EbasicSize_2Ebool__size,inj__o(V5a5))))))))) ) ).

tff(ax_thm_2Ebinary__ieee_2Eflags__DivideByZero,axiom,
    ! [V0b: tp__o,V1b0: tp__o,V2b1: tp__o,V3b2: tp__o,V4b3: tp__o,V5b4: tp__o] :
      ( p(ap(c_2Ebinary__ieee_2Eflags__DivideByZero,ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V0b)),inj__o(V1b0)),inj__o(V2b1)),inj__o(V3b2)),inj__o(V4b3)),inj__o(V5b4))))
    <=> p(inj__o(V0b)) ) ).

tff(ax_thm_2Ebinary__ieee_2Eflags__InvalidOp,axiom,
    ! [V0b: tp__o,V1b0: tp__o,V2b1: tp__o,V3b2: tp__o,V4b3: tp__o,V5b4: tp__o] :
      ( p(ap(c_2Ebinary__ieee_2Eflags__InvalidOp,ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V0b)),inj__o(V1b0)),inj__o(V2b1)),inj__o(V3b2)),inj__o(V4b3)),inj__o(V5b4))))
    <=> p(inj__o(V1b0)) ) ).

tff(ax_thm_2Ebinary__ieee_2Eflags__Overflow,axiom,
    ! [V0b: tp__o,V1b0: tp__o,V2b1: tp__o,V3b2: tp__o,V4b3: tp__o,V5b4: tp__o] :
      ( p(ap(c_2Ebinary__ieee_2Eflags__Overflow,ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V0b)),inj__o(V1b0)),inj__o(V2b1)),inj__o(V3b2)),inj__o(V4b3)),inj__o(V5b4))))
    <=> p(inj__o(V2b1)) ) ).

tff(ax_thm_2Ebinary__ieee_2Eflags__Precision,axiom,
    ! [V0b: tp__o,V1b0: tp__o,V2b1: tp__o,V3b2: tp__o,V4b3: tp__o,V5b4: tp__o] :
      ( p(ap(c_2Ebinary__ieee_2Eflags__Precision,ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V0b)),inj__o(V1b0)),inj__o(V2b1)),inj__o(V3b2)),inj__o(V4b3)),inj__o(V5b4))))
    <=> p(inj__o(V3b2)) ) ).

tff(ax_thm_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,axiom,
    ! [V0b: tp__o,V1b0: tp__o,V2b1: tp__o,V3b2: tp__o,V4b3: tp__o,V5b4: tp__o] :
      ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V0b)),inj__o(V1b0)),inj__o(V2b1)),inj__o(V3b2)),inj__o(V4b3)),inj__o(V5b4))))
    <=> p(inj__o(V4b3)) ) ).

tff(ax_thm_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,axiom,
    ! [V0b: tp__o,V1b0: tp__o,V2b1: tp__o,V3b2: tp__o,V4b3: tp__o,V5b4: tp__o] :
      ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V0b)),inj__o(V1b0)),inj__o(V2b1)),inj__o(V3b2)),inj__o(V4b3)),inj__o(V5b4))))
    <=> p(inj__o(V5b4)) ) ).

tff(conj_thm_2Ebinary__ieee_2Eflags__accessors,axiom,
    ( ! [V0b: tp__o,V1b0: tp__o,V2b1: tp__o,V3b2: tp__o,V4b3: tp__o,V5b4: tp__o] :
        ( p(ap(c_2Ebinary__ieee_2Eflags__DivideByZero,ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V0b)),inj__o(V1b0)),inj__o(V2b1)),inj__o(V3b2)),inj__o(V4b3)),inj__o(V5b4))))
      <=> p(inj__o(V0b)) )
    & ! [V6b: tp__o,V7b0: tp__o,V8b1: tp__o,V9b2: tp__o,V10b3: tp__o,V11b4: tp__o] :
        ( p(ap(c_2Ebinary__ieee_2Eflags__InvalidOp,ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V6b)),inj__o(V7b0)),inj__o(V8b1)),inj__o(V9b2)),inj__o(V10b3)),inj__o(V11b4))))
      <=> p(inj__o(V7b0)) )
    & ! [V12b: tp__o,V13b0: tp__o,V14b1: tp__o,V15b2: tp__o,V16b3: tp__o,V17b4: tp__o] :
        ( p(ap(c_2Ebinary__ieee_2Eflags__Overflow,ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V12b)),inj__o(V13b0)),inj__o(V14b1)),inj__o(V15b2)),inj__o(V16b3)),inj__o(V17b4))))
      <=> p(inj__o(V14b1)) )
    & ! [V18b: tp__o,V19b0: tp__o,V20b1: tp__o,V21b2: tp__o,V22b3: tp__o,V23b4: tp__o] :
        ( p(ap(c_2Ebinary__ieee_2Eflags__Precision,ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V18b)),inj__o(V19b0)),inj__o(V20b1)),inj__o(V21b2)),inj__o(V22b3)),inj__o(V23b4))))
      <=> p(inj__o(V21b2)) )
    & ! [V24b: tp__o,V25b0: tp__o,V26b1: tp__o,V27b2: tp__o,V28b3: tp__o,V29b4: tp__o] :
        ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V24b)),inj__o(V25b0)),inj__o(V26b1)),inj__o(V27b2)),inj__o(V28b3)),inj__o(V29b4))))
      <=> p(inj__o(V28b3)) )
    & ! [V30b: tp__o,V31b0: tp__o,V32b1: tp__o,V33b2: tp__o,V34b3: tp__o,V35b4: tp__o] :
        ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V30b)),inj__o(V31b0)),inj__o(V32b1)),inj__o(V33b2)),inj__o(V34b3)),inj__o(V35b4))))
      <=> p(inj__o(V35b4)) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Eflags__DivideByZero__fupd,axiom,
    ! [V0f: $i] :
      ( mem(V0f,arr(bool,bool))
     => ! [V1b: tp__o,V2b0: tp__o,V3b1: tp__o,V4b2: tp__o,V5b3: tp__o,V6b4: tp__o] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V0f),ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V1b)),inj__o(V2b0)),inj__o(V3b1)),inj__o(V4b2)),inj__o(V5b3)),inj__o(V6b4)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,ap(V0f,inj__o(V1b))),inj__o(V2b0)),inj__o(V3b1)),inj__o(V4b2)),inj__o(V5b3)),inj__o(V6b4))) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Eflags__InvalidOp__fupd,axiom,
    ! [V0f: $i] :
      ( mem(V0f,arr(bool,bool))
     => ! [V1b: tp__o,V2b0: tp__o,V3b1: tp__o,V4b2: tp__o,V5b3: tp__o,V6b4: tp__o] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V0f),ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V1b)),inj__o(V2b0)),inj__o(V3b1)),inj__o(V4b2)),inj__o(V5b3)),inj__o(V6b4)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V1b)),ap(V0f,inj__o(V2b0))),inj__o(V3b1)),inj__o(V4b2)),inj__o(V5b3)),inj__o(V6b4))) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Eflags__Overflow__fupd,axiom,
    ! [V0f: $i] :
      ( mem(V0f,arr(bool,bool))
     => ! [V1b: tp__o,V2b0: tp__o,V3b1: tp__o,V4b2: tp__o,V5b3: tp__o,V6b4: tp__o] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V0f),ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V1b)),inj__o(V2b0)),inj__o(V3b1)),inj__o(V4b2)),inj__o(V5b3)),inj__o(V6b4)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V1b)),inj__o(V2b0)),ap(V0f,inj__o(V3b1))),inj__o(V4b2)),inj__o(V5b3)),inj__o(V6b4))) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Eflags__Precision__fupd,axiom,
    ! [V0f: $i] :
      ( mem(V0f,arr(bool,bool))
     => ! [V1b: tp__o,V2b0: tp__o,V3b1: tp__o,V4b2: tp__o,V5b3: tp__o,V6b4: tp__o] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V0f),ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V1b)),inj__o(V2b0)),inj__o(V3b1)),inj__o(V4b2)),inj__o(V5b3)),inj__o(V6b4)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V1b)),inj__o(V2b0)),inj__o(V3b1)),ap(V0f,inj__o(V4b2))),inj__o(V5b3)),inj__o(V6b4))) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,axiom,
    ! [V0f: $i] :
      ( mem(V0f,arr(bool,bool))
     => ! [V1b: tp__o,V2b0: tp__o,V3b1: tp__o,V4b2: tp__o,V5b3: tp__o,V6b4: tp__o] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V0f),ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V1b)),inj__o(V2b0)),inj__o(V3b1)),inj__o(V4b2)),inj__o(V5b3)),inj__o(V6b4)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V1b)),inj__o(V2b0)),inj__o(V3b1)),inj__o(V4b2)),ap(V0f,inj__o(V5b3))),inj__o(V6b4))) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,axiom,
    ! [V0f: $i] :
      ( mem(V0f,arr(bool,bool))
     => ! [V1b: tp__o,V2b0: tp__o,V3b1: tp__o,V4b2: tp__o,V5b3: tp__o,V6b4: tp__o] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V0f),ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V1b)),inj__o(V2b0)),inj__o(V3b1)),inj__o(V4b2)),inj__o(V5b3)),inj__o(V6b4)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V1b)),inj__o(V2b0)),inj__o(V3b1)),inj__o(V4b2)),inj__o(V5b3)),ap(V0f,inj__o(V6b4)))) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Eflags__fn__updates,axiom,
    ( ! [V0f: $i] :
        ( mem(V0f,arr(bool,bool))
       => ! [V1b: tp__o,V2b0: tp__o,V3b1: tp__o,V4b2: tp__o,V5b3: tp__o,V6b4: tp__o] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V0f),ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V1b)),inj__o(V2b0)),inj__o(V3b1)),inj__o(V4b2)),inj__o(V5b3)),inj__o(V6b4)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,ap(V0f,inj__o(V1b))),inj__o(V2b0)),inj__o(V3b1)),inj__o(V4b2)),inj__o(V5b3)),inj__o(V6b4))) ) )
    & ! [V7f: $i] :
        ( mem(V7f,arr(bool,bool))
       => ! [V8b: tp__o,V9b0: tp__o,V10b1: tp__o,V11b2: tp__o,V12b3: tp__o,V13b4: tp__o] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V7f),ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V8b)),inj__o(V9b0)),inj__o(V10b1)),inj__o(V11b2)),inj__o(V12b3)),inj__o(V13b4)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V8b)),ap(V7f,inj__o(V9b0))),inj__o(V10b1)),inj__o(V11b2)),inj__o(V12b3)),inj__o(V13b4))) ) )
    & ! [V14f: $i] :
        ( mem(V14f,arr(bool,bool))
       => ! [V15b: tp__o,V16b0: tp__o,V17b1: tp__o,V18b2: tp__o,V19b3: tp__o,V20b4: tp__o] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V14f),ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V15b)),inj__o(V16b0)),inj__o(V17b1)),inj__o(V18b2)),inj__o(V19b3)),inj__o(V20b4)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V15b)),inj__o(V16b0)),ap(V14f,inj__o(V17b1))),inj__o(V18b2)),inj__o(V19b3)),inj__o(V20b4))) ) )
    & ! [V21f: $i] :
        ( mem(V21f,arr(bool,bool))
       => ! [V22b: tp__o,V23b0: tp__o,V24b1: tp__o,V25b2: tp__o,V26b3: tp__o,V27b4: tp__o] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V21f),ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V22b)),inj__o(V23b0)),inj__o(V24b1)),inj__o(V25b2)),inj__o(V26b3)),inj__o(V27b4)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V22b)),inj__o(V23b0)),inj__o(V24b1)),ap(V21f,inj__o(V25b2))),inj__o(V26b3)),inj__o(V27b4))) ) )
    & ! [V28f: $i] :
        ( mem(V28f,arr(bool,bool))
       => ! [V29b: tp__o,V30b0: tp__o,V31b1: tp__o,V32b2: tp__o,V33b3: tp__o,V34b4: tp__o] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V28f),ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V29b)),inj__o(V30b0)),inj__o(V31b1)),inj__o(V32b2)),inj__o(V33b3)),inj__o(V34b4)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V29b)),inj__o(V30b0)),inj__o(V31b1)),inj__o(V32b2)),ap(V28f,inj__o(V33b3))),inj__o(V34b4))) ) )
    & ! [V35f: $i] :
        ( mem(V35f,arr(bool,bool))
       => ! [V36b: tp__o,V37b0: tp__o,V38b1: tp__o,V39b2: tp__o,V40b3: tp__o,V41b4: tp__o] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V35f),ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V36b)),inj__o(V37b0)),inj__o(V38b1)),inj__o(V39b2)),inj__o(V40b3)),inj__o(V41b4)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V36b)),inj__o(V37b0)),inj__o(V38b1)),inj__o(V39b2)),inj__o(V40b3)),ap(V35f,inj__o(V41b4)))) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Eflags__accfupds,axiom,
    ( ! [V0f0: $i] :
        ( mem(V0f0,arr(bool,bool))
       => ! [V1f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__DivideByZero,ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V0f0),inj__ty_2Ebinary__ieee_2Eflags(V1f))))
          <=> p(ap(c_2Ebinary__ieee_2Eflags__DivideByZero,inj__ty_2Ebinary__ieee_2Eflags(V1f))) ) )
    & ! [V2f0: $i] :
        ( mem(V2f0,arr(bool,bool))
       => ! [V3f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__DivideByZero,ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V2f0),inj__ty_2Ebinary__ieee_2Eflags(V3f))))
          <=> p(ap(c_2Ebinary__ieee_2Eflags__DivideByZero,inj__ty_2Ebinary__ieee_2Eflags(V3f))) ) )
    & ! [V4f0: $i] :
        ( mem(V4f0,arr(bool,bool))
       => ! [V5f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__DivideByZero,ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V4f0),inj__ty_2Ebinary__ieee_2Eflags(V5f))))
          <=> p(ap(c_2Ebinary__ieee_2Eflags__DivideByZero,inj__ty_2Ebinary__ieee_2Eflags(V5f))) ) )
    & ! [V6f0: $i] :
        ( mem(V6f0,arr(bool,bool))
       => ! [V7f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__DivideByZero,ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V6f0),inj__ty_2Ebinary__ieee_2Eflags(V7f))))
          <=> p(ap(c_2Ebinary__ieee_2Eflags__DivideByZero,inj__ty_2Ebinary__ieee_2Eflags(V7f))) ) )
    & ! [V8f0: $i] :
        ( mem(V8f0,arr(bool,bool))
       => ! [V9f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__DivideByZero,ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V8f0),inj__ty_2Ebinary__ieee_2Eflags(V9f))))
          <=> p(ap(c_2Ebinary__ieee_2Eflags__DivideByZero,inj__ty_2Ebinary__ieee_2Eflags(V9f))) ) )
    & ! [V10f0: $i] :
        ( mem(V10f0,arr(bool,bool))
       => ! [V11f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__InvalidOp,ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V10f0),inj__ty_2Ebinary__ieee_2Eflags(V11f))))
          <=> p(ap(c_2Ebinary__ieee_2Eflags__InvalidOp,inj__ty_2Ebinary__ieee_2Eflags(V11f))) ) )
    & ! [V12f0: $i] :
        ( mem(V12f0,arr(bool,bool))
       => ! [V13f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__InvalidOp,ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V12f0),inj__ty_2Ebinary__ieee_2Eflags(V13f))))
          <=> p(ap(c_2Ebinary__ieee_2Eflags__InvalidOp,inj__ty_2Ebinary__ieee_2Eflags(V13f))) ) )
    & ! [V14f0: $i] :
        ( mem(V14f0,arr(bool,bool))
       => ! [V15f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__InvalidOp,ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V14f0),inj__ty_2Ebinary__ieee_2Eflags(V15f))))
          <=> p(ap(c_2Ebinary__ieee_2Eflags__InvalidOp,inj__ty_2Ebinary__ieee_2Eflags(V15f))) ) )
    & ! [V16f0: $i] :
        ( mem(V16f0,arr(bool,bool))
       => ! [V17f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__InvalidOp,ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V16f0),inj__ty_2Ebinary__ieee_2Eflags(V17f))))
          <=> p(ap(c_2Ebinary__ieee_2Eflags__InvalidOp,inj__ty_2Ebinary__ieee_2Eflags(V17f))) ) )
    & ! [V18f0: $i] :
        ( mem(V18f0,arr(bool,bool))
       => ! [V19f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__InvalidOp,ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V18f0),inj__ty_2Ebinary__ieee_2Eflags(V19f))))
          <=> p(ap(c_2Ebinary__ieee_2Eflags__InvalidOp,inj__ty_2Ebinary__ieee_2Eflags(V19f))) ) )
    & ! [V20f0: $i] :
        ( mem(V20f0,arr(bool,bool))
       => ! [V21f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__Overflow,ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V20f0),inj__ty_2Ebinary__ieee_2Eflags(V21f))))
          <=> p(ap(c_2Ebinary__ieee_2Eflags__Overflow,inj__ty_2Ebinary__ieee_2Eflags(V21f))) ) )
    & ! [V22f0: $i] :
        ( mem(V22f0,arr(bool,bool))
       => ! [V23f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__Overflow,ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V22f0),inj__ty_2Ebinary__ieee_2Eflags(V23f))))
          <=> p(ap(c_2Ebinary__ieee_2Eflags__Overflow,inj__ty_2Ebinary__ieee_2Eflags(V23f))) ) )
    & ! [V24f0: $i] :
        ( mem(V24f0,arr(bool,bool))
       => ! [V25f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__Overflow,ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V24f0),inj__ty_2Ebinary__ieee_2Eflags(V25f))))
          <=> p(ap(c_2Ebinary__ieee_2Eflags__Overflow,inj__ty_2Ebinary__ieee_2Eflags(V25f))) ) )
    & ! [V26f0: $i] :
        ( mem(V26f0,arr(bool,bool))
       => ! [V27f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__Overflow,ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V26f0),inj__ty_2Ebinary__ieee_2Eflags(V27f))))
          <=> p(ap(c_2Ebinary__ieee_2Eflags__Overflow,inj__ty_2Ebinary__ieee_2Eflags(V27f))) ) )
    & ! [V28f0: $i] :
        ( mem(V28f0,arr(bool,bool))
       => ! [V29f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__Overflow,ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V28f0),inj__ty_2Ebinary__ieee_2Eflags(V29f))))
          <=> p(ap(c_2Ebinary__ieee_2Eflags__Overflow,inj__ty_2Ebinary__ieee_2Eflags(V29f))) ) )
    & ! [V30f0: $i] :
        ( mem(V30f0,arr(bool,bool))
       => ! [V31f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__Precision,ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V30f0),inj__ty_2Ebinary__ieee_2Eflags(V31f))))
          <=> p(ap(c_2Ebinary__ieee_2Eflags__Precision,inj__ty_2Ebinary__ieee_2Eflags(V31f))) ) )
    & ! [V32f0: $i] :
        ( mem(V32f0,arr(bool,bool))
       => ! [V33f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__Precision,ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V32f0),inj__ty_2Ebinary__ieee_2Eflags(V33f))))
          <=> p(ap(c_2Ebinary__ieee_2Eflags__Precision,inj__ty_2Ebinary__ieee_2Eflags(V33f))) ) )
    & ! [V34f0: $i] :
        ( mem(V34f0,arr(bool,bool))
       => ! [V35f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__Precision,ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V34f0),inj__ty_2Ebinary__ieee_2Eflags(V35f))))
          <=> p(ap(c_2Ebinary__ieee_2Eflags__Precision,inj__ty_2Ebinary__ieee_2Eflags(V35f))) ) )
    & ! [V36f0: $i] :
        ( mem(V36f0,arr(bool,bool))
       => ! [V37f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__Precision,ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V36f0),inj__ty_2Ebinary__ieee_2Eflags(V37f))))
          <=> p(ap(c_2Ebinary__ieee_2Eflags__Precision,inj__ty_2Ebinary__ieee_2Eflags(V37f))) ) )
    & ! [V38f0: $i] :
        ( mem(V38f0,arr(bool,bool))
       => ! [V39f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__Precision,ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V38f0),inj__ty_2Ebinary__ieee_2Eflags(V39f))))
          <=> p(ap(c_2Ebinary__ieee_2Eflags__Precision,inj__ty_2Ebinary__ieee_2Eflags(V39f))) ) )
    & ! [V40f0: $i] :
        ( mem(V40f0,arr(bool,bool))
       => ! [V41f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V40f0),inj__ty_2Ebinary__ieee_2Eflags(V41f))))
          <=> p(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,inj__ty_2Ebinary__ieee_2Eflags(V41f))) ) )
    & ! [V42f0: $i] :
        ( mem(V42f0,arr(bool,bool))
       => ! [V43f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V42f0),inj__ty_2Ebinary__ieee_2Eflags(V43f))))
          <=> p(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,inj__ty_2Ebinary__ieee_2Eflags(V43f))) ) )
    & ! [V44f0: $i] :
        ( mem(V44f0,arr(bool,bool))
       => ! [V45f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V44f0),inj__ty_2Ebinary__ieee_2Eflags(V45f))))
          <=> p(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,inj__ty_2Ebinary__ieee_2Eflags(V45f))) ) )
    & ! [V46f0: $i] :
        ( mem(V46f0,arr(bool,bool))
       => ! [V47f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V46f0),inj__ty_2Ebinary__ieee_2Eflags(V47f))))
          <=> p(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,inj__ty_2Ebinary__ieee_2Eflags(V47f))) ) )
    & ! [V48f0: $i] :
        ( mem(V48f0,arr(bool,bool))
       => ! [V49f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V48f0),inj__ty_2Ebinary__ieee_2Eflags(V49f))))
          <=> p(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,inj__ty_2Ebinary__ieee_2Eflags(V49f))) ) )
    & ! [V50f0: $i] :
        ( mem(V50f0,arr(bool,bool))
       => ! [V51f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V50f0),inj__ty_2Ebinary__ieee_2Eflags(V51f))))
          <=> p(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,inj__ty_2Ebinary__ieee_2Eflags(V51f))) ) )
    & ! [V52f0: $i] :
        ( mem(V52f0,arr(bool,bool))
       => ! [V53f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V52f0),inj__ty_2Ebinary__ieee_2Eflags(V53f))))
          <=> p(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,inj__ty_2Ebinary__ieee_2Eflags(V53f))) ) )
    & ! [V54f0: $i] :
        ( mem(V54f0,arr(bool,bool))
       => ! [V55f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V54f0),inj__ty_2Ebinary__ieee_2Eflags(V55f))))
          <=> p(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,inj__ty_2Ebinary__ieee_2Eflags(V55f))) ) )
    & ! [V56f0: $i] :
        ( mem(V56f0,arr(bool,bool))
       => ! [V57f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V56f0),inj__ty_2Ebinary__ieee_2Eflags(V57f))))
          <=> p(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,inj__ty_2Ebinary__ieee_2Eflags(V57f))) ) )
    & ! [V58f0: $i] :
        ( mem(V58f0,arr(bool,bool))
       => ! [V59f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V58f0),inj__ty_2Ebinary__ieee_2Eflags(V59f))))
          <=> p(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,inj__ty_2Ebinary__ieee_2Eflags(V59f))) ) )
    & ! [V60f0: $i] :
        ( mem(V60f0,arr(bool,bool))
       => ! [V61f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__DivideByZero,ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V60f0),inj__ty_2Ebinary__ieee_2Eflags(V61f))))
          <=> p(ap(V60f0,ap(c_2Ebinary__ieee_2Eflags__DivideByZero,inj__ty_2Ebinary__ieee_2Eflags(V61f)))) ) )
    & ! [V62f0: $i] :
        ( mem(V62f0,arr(bool,bool))
       => ! [V63f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__InvalidOp,ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V62f0),inj__ty_2Ebinary__ieee_2Eflags(V63f))))
          <=> p(ap(V62f0,ap(c_2Ebinary__ieee_2Eflags__InvalidOp,inj__ty_2Ebinary__ieee_2Eflags(V63f)))) ) )
    & ! [V64f0: $i] :
        ( mem(V64f0,arr(bool,bool))
       => ! [V65f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__Overflow,ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V64f0),inj__ty_2Ebinary__ieee_2Eflags(V65f))))
          <=> p(ap(V64f0,ap(c_2Ebinary__ieee_2Eflags__Overflow,inj__ty_2Ebinary__ieee_2Eflags(V65f)))) ) )
    & ! [V66f0: $i] :
        ( mem(V66f0,arr(bool,bool))
       => ! [V67f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__Precision,ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V66f0),inj__ty_2Ebinary__ieee_2Eflags(V67f))))
          <=> p(ap(V66f0,ap(c_2Ebinary__ieee_2Eflags__Precision,inj__ty_2Ebinary__ieee_2Eflags(V67f)))) ) )
    & ! [V68f0: $i] :
        ( mem(V68f0,arr(bool,bool))
       => ! [V69f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V68f0),inj__ty_2Ebinary__ieee_2Eflags(V69f))))
          <=> p(ap(V68f0,ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,inj__ty_2Ebinary__ieee_2Eflags(V69f)))) ) )
    & ! [V70f0: $i] :
        ( mem(V70f0,arr(bool,bool))
       => ! [V71f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V70f0),inj__ty_2Ebinary__ieee_2Eflags(V71f))))
          <=> p(ap(V70f0,ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,inj__ty_2Ebinary__ieee_2Eflags(V71f)))) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Eflags__fupdfupds,axiom,
    ( ! [V0g: $i] :
        ( mem(V0g,arr(bool,bool))
       => ! [V1f0: $i] :
            ( mem(V1f0,arr(bool,bool))
           => ! [V2f: tp__ty_2Ebinary__ieee_2Eflags] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V1f0),ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V0g),inj__ty_2Ebinary__ieee_2Eflags(V2f)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V1f0),V0g)),inj__ty_2Ebinary__ieee_2Eflags(V2f))) ) ) )
    & ! [V3g: $i] :
        ( mem(V3g,arr(bool,bool))
       => ! [V4f0: $i] :
            ( mem(V4f0,arr(bool,bool))
           => ! [V5f: tp__ty_2Ebinary__ieee_2Eflags] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V4f0),ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V3g),inj__ty_2Ebinary__ieee_2Eflags(V5f)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V4f0),V3g)),inj__ty_2Ebinary__ieee_2Eflags(V5f))) ) ) )
    & ! [V6g: $i] :
        ( mem(V6g,arr(bool,bool))
       => ! [V7f0: $i] :
            ( mem(V7f0,arr(bool,bool))
           => ! [V8f: tp__ty_2Ebinary__ieee_2Eflags] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V7f0),ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V6g),inj__ty_2Ebinary__ieee_2Eflags(V8f)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V7f0),V6g)),inj__ty_2Ebinary__ieee_2Eflags(V8f))) ) ) )
    & ! [V9g: $i] :
        ( mem(V9g,arr(bool,bool))
       => ! [V10f0: $i] :
            ( mem(V10f0,arr(bool,bool))
           => ! [V11f: tp__ty_2Ebinary__ieee_2Eflags] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V10f0),ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V9g),inj__ty_2Ebinary__ieee_2Eflags(V11f)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V10f0),V9g)),inj__ty_2Ebinary__ieee_2Eflags(V11f))) ) ) )
    & ! [V12g: $i] :
        ( mem(V12g,arr(bool,bool))
       => ! [V13f0: $i] :
            ( mem(V13f0,arr(bool,bool))
           => ! [V14f: tp__ty_2Ebinary__ieee_2Eflags] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V13f0),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V12g),inj__ty_2Ebinary__ieee_2Eflags(V14f)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V13f0),V12g)),inj__ty_2Ebinary__ieee_2Eflags(V14f))) ) ) )
    & ! [V15g: $i] :
        ( mem(V15g,arr(bool,bool))
       => ! [V16f0: $i] :
            ( mem(V16f0,arr(bool,bool))
           => ! [V17f: tp__ty_2Ebinary__ieee_2Eflags] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V16f0),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V15g),inj__ty_2Ebinary__ieee_2Eflags(V17f)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V16f0),V15g)),inj__ty_2Ebinary__ieee_2Eflags(V17f))) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Eflags__fupdfupds__comp,axiom,
    ! [A_27a: del] :
      ( ! [V0g: $i] :
          ( mem(V0g,arr(bool,bool))
         => ! [V1f0: $i] :
              ( mem(V1f0,arr(bool,bool))
             => ( ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V1f0)),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V0g)) = ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V1f0),V0g)) ) ) )
      & ! [V2h: $i] :
          ( mem(V2h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
         => ! [V3g: $i] :
              ( mem(V3g,arr(bool,bool))
             => ! [V4f0: $i] :
                  ( mem(V4f0,arr(bool,bool))
                 => ( ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V4f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V3g)),V2h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V4f0),V3g))),V2h) ) ) ) )
      & ! [V5g: $i] :
          ( mem(V5g,arr(bool,bool))
         => ! [V6f0: $i] :
              ( mem(V6f0,arr(bool,bool))
             => ( ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V6f0)),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V5g)) = ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V6f0),V5g)) ) ) )
      & ! [V7h: $i] :
          ( mem(V7h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
         => ! [V8g: $i] :
              ( mem(V8g,arr(bool,bool))
             => ! [V9f0: $i] :
                  ( mem(V9f0,arr(bool,bool))
                 => ( ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V9f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V8g)),V7h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V9f0),V8g))),V7h) ) ) ) )
      & ! [V10g: $i] :
          ( mem(V10g,arr(bool,bool))
         => ! [V11f0: $i] :
              ( mem(V11f0,arr(bool,bool))
             => ( ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V11f0)),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V10g)) = ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V11f0),V10g)) ) ) )
      & ! [V12h: $i] :
          ( mem(V12h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
         => ! [V13g: $i] :
              ( mem(V13g,arr(bool,bool))
             => ! [V14f0: $i] :
                  ( mem(V14f0,arr(bool,bool))
                 => ( ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V14f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V13g)),V12h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V14f0),V13g))),V12h) ) ) ) )
      & ! [V15g: $i] :
          ( mem(V15g,arr(bool,bool))
         => ! [V16f0: $i] :
              ( mem(V16f0,arr(bool,bool))
             => ( ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V16f0)),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V15g)) = ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V16f0),V15g)) ) ) )
      & ! [V17h: $i] :
          ( mem(V17h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
         => ! [V18g: $i] :
              ( mem(V18g,arr(bool,bool))
             => ! [V19f0: $i] :
                  ( mem(V19f0,arr(bool,bool))
                 => ( ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V19f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V18g)),V17h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V19f0),V18g))),V17h) ) ) ) )
      & ! [V20g: $i] :
          ( mem(V20g,arr(bool,bool))
         => ! [V21f0: $i] :
              ( mem(V21f0,arr(bool,bool))
             => ( ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V21f0)),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V20g)) = ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V21f0),V20g)) ) ) )
      & ! [V22h: $i] :
          ( mem(V22h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
         => ! [V23g: $i] :
              ( mem(V23g,arr(bool,bool))
             => ! [V24f0: $i] :
                  ( mem(V24f0,arr(bool,bool))
                 => ( ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V24f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V23g)),V22h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V24f0),V23g))),V22h) ) ) ) )
      & ! [V25g: $i] :
          ( mem(V25g,arr(bool,bool))
         => ! [V26f0: $i] :
              ( mem(V26f0,arr(bool,bool))
             => ( ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V26f0)),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V25g)) = ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V26f0),V25g)) ) ) )
      & ! [V27h: $i] :
          ( mem(V27h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
         => ! [V28g: $i] :
              ( mem(V28g,arr(bool,bool))
             => ! [V29f0: $i] :
                  ( mem(V29f0,arr(bool,bool))
                 => ( ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V29f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V28g)),V27h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V29f0),V28g))),V27h) ) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Eflags__fupdcanon,axiom,
    ( ! [V0g: $i] :
        ( mem(V0g,arr(bool,bool))
       => ! [V1f0: $i] :
            ( mem(V1f0,arr(bool,bool))
           => ! [V2f: tp__ty_2Ebinary__ieee_2Eflags] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V1f0),ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V0g),inj__ty_2Ebinary__ieee_2Eflags(V2f)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V0g),ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V1f0),inj__ty_2Ebinary__ieee_2Eflags(V2f)))) ) ) )
    & ! [V3g: $i] :
        ( mem(V3g,arr(bool,bool))
       => ! [V4f0: $i] :
            ( mem(V4f0,arr(bool,bool))
           => ! [V5f: tp__ty_2Ebinary__ieee_2Eflags] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V4f0),ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V3g),inj__ty_2Ebinary__ieee_2Eflags(V5f)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V3g),ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V4f0),inj__ty_2Ebinary__ieee_2Eflags(V5f)))) ) ) )
    & ! [V6g: $i] :
        ( mem(V6g,arr(bool,bool))
       => ! [V7f0: $i] :
            ( mem(V7f0,arr(bool,bool))
           => ! [V8f: tp__ty_2Ebinary__ieee_2Eflags] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V7f0),ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V6g),inj__ty_2Ebinary__ieee_2Eflags(V8f)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V6g),ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V7f0),inj__ty_2Ebinary__ieee_2Eflags(V8f)))) ) ) )
    & ! [V9g: $i] :
        ( mem(V9g,arr(bool,bool))
       => ! [V10f0: $i] :
            ( mem(V10f0,arr(bool,bool))
           => ! [V11f: tp__ty_2Ebinary__ieee_2Eflags] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V10f0),ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V9g),inj__ty_2Ebinary__ieee_2Eflags(V11f)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V9g),ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V10f0),inj__ty_2Ebinary__ieee_2Eflags(V11f)))) ) ) )
    & ! [V12g: $i] :
        ( mem(V12g,arr(bool,bool))
       => ! [V13f0: $i] :
            ( mem(V13f0,arr(bool,bool))
           => ! [V14f: tp__ty_2Ebinary__ieee_2Eflags] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V13f0),ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V12g),inj__ty_2Ebinary__ieee_2Eflags(V14f)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V12g),ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V13f0),inj__ty_2Ebinary__ieee_2Eflags(V14f)))) ) ) )
    & ! [V15g: $i] :
        ( mem(V15g,arr(bool,bool))
       => ! [V16f0: $i] :
            ( mem(V16f0,arr(bool,bool))
           => ! [V17f: tp__ty_2Ebinary__ieee_2Eflags] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V16f0),ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V15g),inj__ty_2Ebinary__ieee_2Eflags(V17f)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V15g),ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V16f0),inj__ty_2Ebinary__ieee_2Eflags(V17f)))) ) ) )
    & ! [V18g: $i] :
        ( mem(V18g,arr(bool,bool))
       => ! [V19f0: $i] :
            ( mem(V19f0,arr(bool,bool))
           => ! [V20f: tp__ty_2Ebinary__ieee_2Eflags] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V19f0),ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V18g),inj__ty_2Ebinary__ieee_2Eflags(V20f)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V18g),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V19f0),inj__ty_2Ebinary__ieee_2Eflags(V20f)))) ) ) )
    & ! [V21g: $i] :
        ( mem(V21g,arr(bool,bool))
       => ! [V22f0: $i] :
            ( mem(V22f0,arr(bool,bool))
           => ! [V23f: tp__ty_2Ebinary__ieee_2Eflags] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V22f0),ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V21g),inj__ty_2Ebinary__ieee_2Eflags(V23f)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V21g),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V22f0),inj__ty_2Ebinary__ieee_2Eflags(V23f)))) ) ) )
    & ! [V24g: $i] :
        ( mem(V24g,arr(bool,bool))
       => ! [V25f0: $i] :
            ( mem(V25f0,arr(bool,bool))
           => ! [V26f: tp__ty_2Ebinary__ieee_2Eflags] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V25f0),ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V24g),inj__ty_2Ebinary__ieee_2Eflags(V26f)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V24g),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V25f0),inj__ty_2Ebinary__ieee_2Eflags(V26f)))) ) ) )
    & ! [V27g: $i] :
        ( mem(V27g,arr(bool,bool))
       => ! [V28f0: $i] :
            ( mem(V28f0,arr(bool,bool))
           => ! [V29f: tp__ty_2Ebinary__ieee_2Eflags] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V28f0),ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V27g),inj__ty_2Ebinary__ieee_2Eflags(V29f)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V27g),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V28f0),inj__ty_2Ebinary__ieee_2Eflags(V29f)))) ) ) )
    & ! [V30g: $i] :
        ( mem(V30g,arr(bool,bool))
       => ! [V31f0: $i] :
            ( mem(V31f0,arr(bool,bool))
           => ! [V32f: tp__ty_2Ebinary__ieee_2Eflags] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V31f0),ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V30g),inj__ty_2Ebinary__ieee_2Eflags(V32f)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V30g),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V31f0),inj__ty_2Ebinary__ieee_2Eflags(V32f)))) ) ) )
    & ! [V33g: $i] :
        ( mem(V33g,arr(bool,bool))
       => ! [V34f0: $i] :
            ( mem(V34f0,arr(bool,bool))
           => ! [V35f: tp__ty_2Ebinary__ieee_2Eflags] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V34f0),ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V33g),inj__ty_2Ebinary__ieee_2Eflags(V35f)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V33g),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V34f0),inj__ty_2Ebinary__ieee_2Eflags(V35f)))) ) ) )
    & ! [V36g: $i] :
        ( mem(V36g,arr(bool,bool))
       => ! [V37f0: $i] :
            ( mem(V37f0,arr(bool,bool))
           => ! [V38f: tp__ty_2Ebinary__ieee_2Eflags] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V37f0),ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V36g),inj__ty_2Ebinary__ieee_2Eflags(V38f)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V36g),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V37f0),inj__ty_2Ebinary__ieee_2Eflags(V38f)))) ) ) )
    & ! [V39g: $i] :
        ( mem(V39g,arr(bool,bool))
       => ! [V40f0: $i] :
            ( mem(V40f0,arr(bool,bool))
           => ! [V41f: tp__ty_2Ebinary__ieee_2Eflags] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V40f0),ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V39g),inj__ty_2Ebinary__ieee_2Eflags(V41f)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V39g),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V40f0),inj__ty_2Ebinary__ieee_2Eflags(V41f)))) ) ) )
    & ! [V42g: $i] :
        ( mem(V42g,arr(bool,bool))
       => ! [V43f0: $i] :
            ( mem(V43f0,arr(bool,bool))
           => ! [V44f: tp__ty_2Ebinary__ieee_2Eflags] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V43f0),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V42g),inj__ty_2Ebinary__ieee_2Eflags(V44f)))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V42g),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V43f0),inj__ty_2Ebinary__ieee_2Eflags(V44f)))) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Eflags__fupdcanon__comp,axiom,
    ! [A_27a: del] :
      ( ! [V0g: $i] :
          ( mem(V0g,arr(bool,bool))
         => ! [V1f0: $i] :
              ( mem(V1f0,arr(bool,bool))
             => ( ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V1f0)),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V0g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V0g)),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V1f0)) ) ) )
      & ! [V2h: $i] :
          ( mem(V2h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
         => ! [V3g: $i] :
              ( mem(V3g,arr(bool,bool))
             => ! [V4f0: $i] :
                  ( mem(V4f0,arr(bool,bool))
                 => ( ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V4f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V3g)),V2h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V3g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V4f0)),V2h)) ) ) ) )
      & ! [V5g: $i] :
          ( mem(V5g,arr(bool,bool))
         => ! [V6f0: $i] :
              ( mem(V6f0,arr(bool,bool))
             => ( ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V6f0)),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V5g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V5g)),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V6f0)) ) ) )
      & ! [V7h: $i] :
          ( mem(V7h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
         => ! [V8g: $i] :
              ( mem(V8g,arr(bool,bool))
             => ! [V9f0: $i] :
                  ( mem(V9f0,arr(bool,bool))
                 => ( ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V9f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V8g)),V7h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V8g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V9f0)),V7h)) ) ) ) )
      & ! [V10g: $i] :
          ( mem(V10g,arr(bool,bool))
         => ! [V11f0: $i] :
              ( mem(V11f0,arr(bool,bool))
             => ( ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V11f0)),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V10g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V10g)),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V11f0)) ) ) )
      & ! [V12h: $i] :
          ( mem(V12h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
         => ! [V13g: $i] :
              ( mem(V13g,arr(bool,bool))
             => ! [V14f0: $i] :
                  ( mem(V14f0,arr(bool,bool))
                 => ( ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V14f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V13g)),V12h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V13g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V14f0)),V12h)) ) ) ) )
      & ! [V15g: $i] :
          ( mem(V15g,arr(bool,bool))
         => ! [V16f0: $i] :
              ( mem(V16f0,arr(bool,bool))
             => ( ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V16f0)),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V15g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V15g)),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V16f0)) ) ) )
      & ! [V17h: $i] :
          ( mem(V17h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
         => ! [V18g: $i] :
              ( mem(V18g,arr(bool,bool))
             => ! [V19f0: $i] :
                  ( mem(V19f0,arr(bool,bool))
                 => ( ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V19f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V18g)),V17h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V18g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V19f0)),V17h)) ) ) ) )
      & ! [V20g: $i] :
          ( mem(V20g,arr(bool,bool))
         => ! [V21f0: $i] :
              ( mem(V21f0,arr(bool,bool))
             => ( ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V21f0)),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V20g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V20g)),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V21f0)) ) ) )
      & ! [V22h: $i] :
          ( mem(V22h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
         => ! [V23g: $i] :
              ( mem(V23g,arr(bool,bool))
             => ! [V24f0: $i] :
                  ( mem(V24f0,arr(bool,bool))
                 => ( ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V24f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V23g)),V22h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V23g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V24f0)),V22h)) ) ) ) )
      & ! [V25g: $i] :
          ( mem(V25g,arr(bool,bool))
         => ! [V26f0: $i] :
              ( mem(V26f0,arr(bool,bool))
             => ( ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V26f0)),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V25g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V25g)),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V26f0)) ) ) )
      & ! [V27h: $i] :
          ( mem(V27h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
         => ! [V28g: $i] :
              ( mem(V28g,arr(bool,bool))
             => ! [V29f0: $i] :
                  ( mem(V29f0,arr(bool,bool))
                 => ( ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V29f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V28g)),V27h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V28g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V29f0)),V27h)) ) ) ) )
      & ! [V30g: $i] :
          ( mem(V30g,arr(bool,bool))
         => ! [V31f0: $i] :
              ( mem(V31f0,arr(bool,bool))
             => ( ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V31f0)),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V30g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V30g)),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V31f0)) ) ) )
      & ! [V32h: $i] :
          ( mem(V32h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
         => ! [V33g: $i] :
              ( mem(V33g,arr(bool,bool))
             => ! [V34f0: $i] :
                  ( mem(V34f0,arr(bool,bool))
                 => ( ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V34f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V33g)),V32h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V33g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V34f0)),V32h)) ) ) ) )
      & ! [V35g: $i] :
          ( mem(V35g,arr(bool,bool))
         => ! [V36f0: $i] :
              ( mem(V36f0,arr(bool,bool))
             => ( ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V36f0)),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V35g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V35g)),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V36f0)) ) ) )
      & ! [V37h: $i] :
          ( mem(V37h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
         => ! [V38g: $i] :
              ( mem(V38g,arr(bool,bool))
             => ! [V39f0: $i] :
                  ( mem(V39f0,arr(bool,bool))
                 => ( ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V39f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V38g)),V37h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V38g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V39f0)),V37h)) ) ) ) )
      & ! [V40g: $i] :
          ( mem(V40g,arr(bool,bool))
         => ! [V41f0: $i] :
              ( mem(V41f0,arr(bool,bool))
             => ( ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V41f0)),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V40g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V40g)),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V41f0)) ) ) )
      & ! [V42h: $i] :
          ( mem(V42h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
         => ! [V43g: $i] :
              ( mem(V43g,arr(bool,bool))
             => ! [V44f0: $i] :
                  ( mem(V44f0,arr(bool,bool))
                 => ( ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V44f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V43g)),V42h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V43g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V44f0)),V42h)) ) ) ) )
      & ! [V45g: $i] :
          ( mem(V45g,arr(bool,bool))
         => ! [V46f0: $i] :
              ( mem(V46f0,arr(bool,bool))
             => ( ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V46f0)),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V45g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V45g)),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V46f0)) ) ) )
      & ! [V47h: $i] :
          ( mem(V47h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
         => ! [V48g: $i] :
              ( mem(V48g,arr(bool,bool))
             => ! [V49f0: $i] :
                  ( mem(V49f0,arr(bool,bool))
                 => ( ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V49f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V48g)),V47h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V48g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V49f0)),V47h)) ) ) ) )
      & ! [V50g: $i] :
          ( mem(V50g,arr(bool,bool))
         => ! [V51f0: $i] :
              ( mem(V51f0,arr(bool,bool))
             => ( ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V51f0)),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V50g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V50g)),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V51f0)) ) ) )
      & ! [V52h: $i] :
          ( mem(V52h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
         => ! [V53g: $i] :
              ( mem(V53g,arr(bool,bool))
             => ! [V54f0: $i] :
                  ( mem(V54f0,arr(bool,bool))
                 => ( ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V54f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V53g)),V52h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V53g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V54f0)),V52h)) ) ) ) )
      & ! [V55g: $i] :
          ( mem(V55g,arr(bool,bool))
         => ! [V56f0: $i] :
              ( mem(V56f0,arr(bool,bool))
             => ( ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V56f0)),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V55g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V55g)),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V56f0)) ) ) )
      & ! [V57h: $i] :
          ( mem(V57h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
         => ! [V58g: $i] :
              ( mem(V58g,arr(bool,bool))
             => ! [V59f0: $i] :
                  ( mem(V59f0,arr(bool,bool))
                 => ( ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V59f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V58g)),V57h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V58g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V59f0)),V57h)) ) ) ) )
      & ! [V60g: $i] :
          ( mem(V60g,arr(bool,bool))
         => ! [V61f0: $i] :
              ( mem(V61f0,arr(bool,bool))
             => ( ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V61f0)),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V60g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V60g)),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V61f0)) ) ) )
      & ! [V62h: $i] :
          ( mem(V62h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
         => ! [V63g: $i] :
              ( mem(V63g,arr(bool,bool))
             => ! [V64f0: $i] :
                  ( mem(V64f0,arr(bool,bool))
                 => ( ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V64f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V63g)),V62h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V63g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V64f0)),V62h)) ) ) ) )
      & ! [V65g: $i] :
          ( mem(V65g,arr(bool,bool))
         => ! [V66f0: $i] :
              ( mem(V66f0,arr(bool,bool))
             => ( ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V66f0)),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V65g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V65g)),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V66f0)) ) ) )
      & ! [V67h: $i] :
          ( mem(V67h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
         => ! [V68g: $i] :
              ( mem(V68g,arr(bool,bool))
             => ! [V69f0: $i] :
                  ( mem(V69f0,arr(bool,bool))
                 => ( ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V69f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V68g)),V67h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V68g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V69f0)),V67h)) ) ) ) )
      & ! [V70g: $i] :
          ( mem(V70g,arr(bool,bool))
         => ! [V71f0: $i] :
              ( mem(V71f0,arr(bool,bool))
             => ( ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V71f0)),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V70g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V70g)),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V71f0)) ) ) )
      & ! [V72h: $i] :
          ( mem(V72h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
         => ! [V73g: $i] :
              ( mem(V73g,arr(bool,bool))
             => ! [V74f0: $i] :
                  ( mem(V74f0,arr(bool,bool))
                 => ( ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V74f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V73g)),V72h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V73g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V74f0)),V72h)) ) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Eflags__component__equality,axiom,
    ! [V0f1: tp__ty_2Ebinary__ieee_2Eflags,V1f2: tp__ty_2Ebinary__ieee_2Eflags] :
      ( ( V0f1 = V1f2 )
    <=> ( ( p(ap(c_2Ebinary__ieee_2Eflags__DivideByZero,inj__ty_2Ebinary__ieee_2Eflags(V0f1)))
        <=> p(ap(c_2Ebinary__ieee_2Eflags__DivideByZero,inj__ty_2Ebinary__ieee_2Eflags(V1f2))) )
        & ( p(ap(c_2Ebinary__ieee_2Eflags__InvalidOp,inj__ty_2Ebinary__ieee_2Eflags(V0f1)))
        <=> p(ap(c_2Ebinary__ieee_2Eflags__InvalidOp,inj__ty_2Ebinary__ieee_2Eflags(V1f2))) )
        & ( p(ap(c_2Ebinary__ieee_2Eflags__Overflow,inj__ty_2Ebinary__ieee_2Eflags(V0f1)))
        <=> p(ap(c_2Ebinary__ieee_2Eflags__Overflow,inj__ty_2Ebinary__ieee_2Eflags(V1f2))) )
        & ( p(ap(c_2Ebinary__ieee_2Eflags__Precision,inj__ty_2Ebinary__ieee_2Eflags(V0f1)))
        <=> p(ap(c_2Ebinary__ieee_2Eflags__Precision,inj__ty_2Ebinary__ieee_2Eflags(V1f2))) )
        & ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,inj__ty_2Ebinary__ieee_2Eflags(V0f1)))
        <=> p(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,inj__ty_2Ebinary__ieee_2Eflags(V1f2))) )
        & ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,inj__ty_2Ebinary__ieee_2Eflags(V0f1)))
        <=> p(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,inj__ty_2Ebinary__ieee_2Eflags(V1f2))) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Eflags__updates__eq__literal,axiom,
    ! [V0f: tp__ty_2Ebinary__ieee_2Eflags,V1b4: tp__o,V2b3: tp__o,V3b2: tp__o,V4b1: tp__o,V5b0: tp__o,V6b: tp__o] : ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V1b4))),ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V2b3))),ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V3b2))),ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V4b1))),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V5b0))),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V6b))),inj__ty_2Ebinary__ieee_2Eflags(V0f)))))))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V1b4))),ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V2b3))),ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V3b2))),ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V4b1))),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V5b0))),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V6b))),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Eflags)))))))) ) ).

tff(conj_thm_2Ebinary__ieee_2Eflags__literal__nchotomy,axiom,
    ! [V0f: tp__ty_2Ebinary__ieee_2Eflags] :
    ? [V1b4: tp__o,V2b3: tp__o,V3b2: tp__o,V4b1: tp__o,V5b0: tp__o,V6b: tp__o] : ( V0f = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V1b4))),ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V2b3))),ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V3b2))),ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V4b1))),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V5b0))),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V6b))),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Eflags)))))))) ) ).

tff(conj_thm_2Ebinary__ieee_2EFORALL__flags,axiom,
    ! [V0P: $i] :
      ( mem(V0P,arr(ty_2Ebinary__ieee_2Eflags,bool))
     => ( ! [V1f: tp__ty_2Ebinary__ieee_2Eflags] : p(ap(V0P,inj__ty_2Ebinary__ieee_2Eflags(V1f)))
      <=> ! [V2b4: tp__o,V3b3: tp__o,V4b2: tp__o,V5b1: tp__o,V6b0: tp__o,V7b: tp__o] : p(ap(V0P,ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V2b4))),ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V3b3))),ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V4b2))),ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V5b1))),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V6b0))),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V7b))),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Eflags))))))))) ) ) ).

tff(conj_thm_2Ebinary__ieee_2EEXISTS__flags,axiom,
    ! [V0P: $i] :
      ( mem(V0P,arr(ty_2Ebinary__ieee_2Eflags,bool))
     => ( ? [V1f: tp__ty_2Ebinary__ieee_2Eflags] : p(ap(V0P,inj__ty_2Ebinary__ieee_2Eflags(V1f)))
      <=> ? [V2b4: tp__o,V3b3: tp__o,V4b2: tp__o,V5b1: tp__o,V6b0: tp__o,V7b: tp__o] : p(ap(V0P,ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V2b4))),ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V3b3))),ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V4b2))),ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V5b1))),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V6b0))),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V7b))),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Eflags))))))))) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Eflags__literal__11,axiom,
    ! [V0b41: tp__o,V1b31: tp__o,V2b21: tp__o,V3b11: tp__o,V4b01: tp__o,V5b1: tp__o,V6b42: tp__o,V7b32: tp__o,V8b22: tp__o,V9b12: tp__o,V10b02: tp__o,V11b2: tp__o] :
      ( ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V0b41))),ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V1b31))),ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V2b21))),ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V3b11))),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V4b01))),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V5b1))),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Eflags)))))))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V6b42))),ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V7b32))),ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V8b22))),ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V9b12))),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V10b02))),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V11b2))),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Eflags)))))))) )
    <=> ( ( p(inj__o(V0b41))
        <=> p(inj__o(V6b42)) )
        & ( p(inj__o(V1b31))
        <=> p(inj__o(V7b32)) )
        & ( p(inj__o(V2b21))
        <=> p(inj__o(V8b22)) )
        & ( p(inj__o(V3b11))
        <=> p(inj__o(V9b12)) )
        & ( p(inj__o(V4b01))
        <=> p(inj__o(V10b02)) )
        & ( p(inj__o(V5b1))
        <=> p(inj__o(V11b2)) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Edatatype__flags,axiom,
    ! [V0record: $i] :
      ( mem(V0record,arr(ty_2Ebinary__ieee_2Eflags,arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,bool))))))))
     => ! [V1flags: tp__ty_2Ebinary__ieee_2Eflags,V2DivideByZero: tp__o,V3InvalidOp: tp__o,V4Overflow: tp__o,V5Precision: tp__o,V6Underflow__BeforeRounding: tp__o,V7Underflow__AfterRounding: tp__o] : p(ap(c_2Ebool_2EDATATYPE(bool),ap(ap(ap(ap(ap(ap(ap(V0record,inj__ty_2Ebinary__ieee_2Eflags(V1flags)),inj__o(V2DivideByZero)),inj__o(V3InvalidOp)),inj__o(V4Overflow)),inj__o(V5Precision)),inj__o(V6Underflow__BeforeRounding)),inj__o(V7Underflow__AfterRounding)))) ) ).

tff(conj_thm_2Ebinary__ieee_2Eflags__11,axiom,
    ! [V0a0: tp__o,V1a1: tp__o,V2a2: tp__o,V3a3: tp__o,V4a4: tp__o,V5a5: tp__o,V6a0_27: tp__o,V7a1_27: tp__o,V8a2_27: tp__o,V9a3_27: tp__o,V10a4_27: tp__o,V11a5_27: tp__o] :
      ( ( surj__ty_2Ebinary__ieee_2Eflags(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V0a0)),inj__o(V1a1)),inj__o(V2a2)),inj__o(V3a3)),inj__o(V4a4)),inj__o(V5a5))) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V6a0_27)),inj__o(V7a1_27)),inj__o(V8a2_27)),inj__o(V9a3_27)),inj__o(V10a4_27)),inj__o(V11a5_27))) )
    <=> ( ( p(inj__o(V0a0))
        <=> p(inj__o(V6a0_27)) )
        & ( p(inj__o(V1a1))
        <=> p(inj__o(V7a1_27)) )
        & ( p(inj__o(V2a2))
        <=> p(inj__o(V8a2_27)) )
        & ( p(inj__o(V3a3))
        <=> p(inj__o(V9a3_27)) )
        & ( p(inj__o(V4a4))
        <=> p(inj__o(V10a4_27)) )
        & ( p(inj__o(V5a5))
        <=> p(inj__o(V11a5_27)) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Eflags__nchotomy,axiom,
    ! [V0ff: tp__ty_2Ebinary__ieee_2Eflags] :
    ? [V1b: tp__o,V2b0: tp__o,V3b1: tp__o,V4b2: tp__o,V5b3: tp__o,V6b4: tp__o] : ( V0ff = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V1b)),inj__o(V2b0)),inj__o(V3b1)),inj__o(V4b2)),inj__o(V5b3)),inj__o(V6b4))) ) ).

tff(conj_thm_2Ebinary__ieee_2Eflags__Axiom,axiom,
    ! [A_27a: del,V0f: $i] :
      ( mem(V0f,arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,A_27a)))))))
     => ? [V1fn: $i] :
          ( mem(V1fn,arr(ty_2Ebinary__ieee_2Eflags,A_27a))
          & ! [V2a0: tp__o,V3a1: tp__o,V4a2: tp__o,V5a3: tp__o,V6a4: tp__o,V7a5: tp__o] : ( ap(V1fn,ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V2a0)),inj__o(V3a1)),inj__o(V4a2)),inj__o(V5a3)),inj__o(V6a4)),inj__o(V7a5))) = ap(ap(ap(ap(ap(ap(V0f,inj__o(V2a0)),inj__o(V3a1)),inj__o(V4a2)),inj__o(V5a3)),inj__o(V6a4)),inj__o(V7a5)) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Eflags__induction,axiom,
    ! [V0P: $i] :
      ( mem(V0P,arr(ty_2Ebinary__ieee_2Eflags,bool))
     => ( ! [V1b: tp__o,V2b0: tp__o,V3b1: tp__o,V4b2: tp__o,V5b3: tp__o,V6b4: tp__o] : p(ap(V0P,ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V1b)),inj__o(V2b0)),inj__o(V3b1)),inj__o(V4b2)),inj__o(V5b3)),inj__o(V6b4))))
       => ! [V7f: tp__ty_2Ebinary__ieee_2Eflags] : p(ap(V0P,inj__ty_2Ebinary__ieee_2Eflags(V7f))) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Eflags__case__cong,axiom,
    ! [A_27a: del,V0f_27: $i] :
      ( mem(V0f_27,arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,A_27a)))))))
     => ! [V1M: tp__ty_2Ebinary__ieee_2Eflags,V2M_27: tp__ty_2Ebinary__ieee_2Eflags,V3f: $i] :
          ( mem(V3f,arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,A_27a)))))))
         => ( ( ( V1M = V2M_27 )
              & ! [V4a0: tp__o,V5a1: tp__o,V6a2: tp__o,V7a3: tp__o,V8a4: tp__o,V9a5: tp__o] :
                  ( ( V2M_27 = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V4a0)),inj__o(V5a1)),inj__o(V6a2)),inj__o(V7a3)),inj__o(V8a4)),inj__o(V9a5))) )
                 => ( ap(ap(ap(ap(ap(ap(V3f,inj__o(V4a0)),inj__o(V5a1)),inj__o(V6a2)),inj__o(V7a3)),inj__o(V8a4)),inj__o(V9a5)) = ap(ap(ap(ap(ap(ap(V0f_27,inj__o(V4a0)),inj__o(V5a1)),inj__o(V6a2)),inj__o(V7a3)),inj__o(V8a4)),inj__o(V9a5)) ) ) )
           => ( ap(ap(c_2Ebinary__ieee_2Eflags__CASE(A_27a),inj__ty_2Ebinary__ieee_2Eflags(V1M)),V3f) = ap(ap(c_2Ebinary__ieee_2Eflags__CASE(A_27a),inj__ty_2Ebinary__ieee_2Eflags(V2M_27)),V0f_27) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Eflags__case__eq,axiom,
    ! [A_27a: del,V0x: tp__ty_2Ebinary__ieee_2Eflags,V1f: $i] :
      ( mem(V1f,arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,A_27a)))))))
     => ! [V2v: $i] :
          ( mem(V2v,A_27a)
         => ( ( ap(ap(c_2Ebinary__ieee_2Eflags__CASE(A_27a),inj__ty_2Ebinary__ieee_2Eflags(V0x)),V1f) = V2v )
          <=> ? [V3b: tp__o,V4b0: tp__o,V5b1: tp__o,V6b2: tp__o,V7b3: tp__o,V8b4: tp__o] :
                ( ( V0x = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,inj__o(V3b)),inj__o(V4b0)),inj__o(V5b1)),inj__o(V6b2)),inj__o(V7b3)),inj__o(V8b4))) )
                & ( ap(ap(ap(ap(ap(ap(V1f,inj__o(V3b)),inj__o(V4b0)),inj__o(V5b1)),inj__o(V6b2)),inj__o(V7b3)),inj__o(V8b4)) = V2v ) ) ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Eclear__flags__def,axiom,
    fo__c_2Ebinary__ieee_2Eclear__flags = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(fo__c_2Ebool_2EF))),ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(fo__c_2Ebool_2EF))),ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(fo__c_2Ebool_2EF))),ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(fo__c_2Ebool_2EF))),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(fo__c_2Ebool_2EF))),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(fo__c_2Ebool_2EF))),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Eflags)))))))) ).

tff(ax_thm_2Ebinary__ieee_2Einvalidop__flags__def,axiom,
    fo__c_2Ebinary__ieee_2Einvalidop__flags = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(fo__c_2Ebool_2ET))),inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Eclear__flags))) ).

tff(ax_thm_2Ebinary__ieee_2Edividezero__flags__def,axiom,
    fo__c_2Ebinary__ieee_2Edividezero__flags = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(fo__c_2Ebool_2ET))),inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Eclear__flags))) ).

tff(lamtp_f2948,type,
    f2948: $i ).

tff(lameq_f2948,axiom,
    ! [V1n: tp__ty_2Enum_2Enum] : ( ap(f2948,inj__ty_2Enum_2Enum(V1n)) = ap(ap(c_2Eprim__rec_2E_3C,inj__ty_2Enum_2Enum(V1n)),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))) ) ).

tff(ax_thm_2Ebinary__ieee_2Erounding__TY__DEF,axiom,
    ? [V0rep: $i] :
      ( mem(V0rep,arr(ty_2Ebinary__ieee_2Erounding,ty_2Enum_2Enum))
      & p(ap(ap(c_2Ebool_2ETYPE__DEFINITION(ty_2Enum_2Enum,ty_2Ebinary__ieee_2Erounding),f2948),V0rep)) ) ).

tff(lamtp_f2949,type,
    f2949: $i ).

tff(lameq_f2949,axiom,
    ! [V2n: tp__ty_2Enum_2Enum] : ( ap(f2949,inj__ty_2Enum_2Enum(V2n)) = ap(ap(c_2Eprim__rec_2E_3C,inj__ty_2Enum_2Enum(V2n)),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))) ) ).

tff(ax_thm_2Ebinary__ieee_2Erounding__BIJ,axiom,
    ( ! [V0a: tp__ty_2Ebinary__ieee_2Erounding] : ( surj__ty_2Ebinary__ieee_2Erounding(ap(c_2Ebinary__ieee_2Enum2rounding,ap(c_2Ebinary__ieee_2Erounding2num,inj__ty_2Ebinary__ieee_2Erounding(V0a)))) = V0a )
    & ! [V1r: tp__ty_2Enum_2Enum] :
        ( p(ap(f2949,inj__ty_2Enum_2Enum(V1r)))
      <=> ( surj__ty_2Enum_2Enum(ap(c_2Ebinary__ieee_2Erounding2num,ap(c_2Ebinary__ieee_2Enum2rounding,inj__ty_2Enum_2Enum(V1r)))) = V1r ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Enum2rounding__rounding2num,axiom,
    ! [V0a: tp__ty_2Ebinary__ieee_2Erounding] : ( surj__ty_2Ebinary__ieee_2Erounding(ap(c_2Ebinary__ieee_2Enum2rounding,ap(c_2Ebinary__ieee_2Erounding2num,inj__ty_2Ebinary__ieee_2Erounding(V0a)))) = V0a ) ).

tff(conj_thm_2Ebinary__ieee_2Erounding2num__num2rounding,axiom,
    ! [V0r: tp__ty_2Enum_2Enum] :
      ( p(ap(ap(c_2Eprim__rec_2E_3C,inj__ty_2Enum_2Enum(V0r)),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))))
    <=> ( surj__ty_2Enum_2Enum(ap(c_2Ebinary__ieee_2Erounding2num,ap(c_2Ebinary__ieee_2Enum2rounding,inj__ty_2Enum_2Enum(V0r)))) = V0r ) ) ).

tff(conj_thm_2Ebinary__ieee_2Enum2rounding__11,axiom,
    ! [V0r: tp__ty_2Enum_2Enum,V1r_27: tp__ty_2Enum_2Enum] :
      ( p(ap(ap(c_2Eprim__rec_2E_3C,inj__ty_2Enum_2Enum(V0r)),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))))
     => ( p(ap(ap(c_2Eprim__rec_2E_3C,inj__ty_2Enum_2Enum(V1r_27)),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))))
       => ( ( surj__ty_2Ebinary__ieee_2Erounding(ap(c_2Ebinary__ieee_2Enum2rounding,inj__ty_2Enum_2Enum(V0r))) = surj__ty_2Ebinary__ieee_2Erounding(ap(c_2Ebinary__ieee_2Enum2rounding,inj__ty_2Enum_2Enum(V1r_27))) )
        <=> ( V0r = V1r_27 ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Erounding2num__11,axiom,
    ! [V0a: tp__ty_2Ebinary__ieee_2Erounding,V1a_27: tp__ty_2Ebinary__ieee_2Erounding] :
      ( ( surj__ty_2Enum_2Enum(ap(c_2Ebinary__ieee_2Erounding2num,inj__ty_2Ebinary__ieee_2Erounding(V0a))) = surj__ty_2Enum_2Enum(ap(c_2Ebinary__ieee_2Erounding2num,inj__ty_2Ebinary__ieee_2Erounding(V1a_27))) )
    <=> ( V0a = V1a_27 ) ) ).

tff(conj_thm_2Ebinary__ieee_2Enum2rounding__ONTO,axiom,
    ! [V0a: tp__ty_2Ebinary__ieee_2Erounding] :
    ? [V1r: tp__ty_2Enum_2Enum] :
      ( ( V0a = surj__ty_2Ebinary__ieee_2Erounding(ap(c_2Ebinary__ieee_2Enum2rounding,inj__ty_2Enum_2Enum(V1r))) )
      & p(ap(ap(c_2Eprim__rec_2E_3C,inj__ty_2Enum_2Enum(V1r)),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))))) ) ).

tff(conj_thm_2Ebinary__ieee_2Erounding2num__ONTO,axiom,
    ! [V0r: tp__ty_2Enum_2Enum] :
      ( p(ap(ap(c_2Eprim__rec_2E_3C,inj__ty_2Enum_2Enum(V0r)),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))))
    <=> ? [V1a: tp__ty_2Ebinary__ieee_2Erounding] : ( V0r = surj__ty_2Enum_2Enum(ap(c_2Ebinary__ieee_2Erounding2num,inj__ty_2Ebinary__ieee_2Erounding(V1a))) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Enum2rounding__thm,axiom,
    ( ( surj__ty_2Ebinary__ieee_2Erounding(ap(c_2Ebinary__ieee_2Enum2rounding,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0))) = fo__c_2Ebinary__ieee_2EroundTiesToEven )
    & ( surj__ty_2Ebinary__ieee_2Erounding(ap(c_2Ebinary__ieee_2Enum2rounding,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))) = fo__c_2Ebinary__ieee_2EroundTowardPositive )
    & ( surj__ty_2Ebinary__ieee_2Erounding(ap(c_2Ebinary__ieee_2Enum2rounding,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))) = fo__c_2Ebinary__ieee_2EroundTowardNegative )
    & ( surj__ty_2Ebinary__ieee_2Erounding(ap(c_2Ebinary__ieee_2Enum2rounding,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))))) = fo__c_2Ebinary__ieee_2EroundTowardZero ) ) ).

tff(conj_thm_2Ebinary__ieee_2Erounding2num__thm,axiom,
    ( ( surj__ty_2Enum_2Enum(ap(c_2Ebinary__ieee_2Erounding2num,inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2EroundTiesToEven))) = fo__c_2Enum_2E0 )
    & ( surj__ty_2Enum_2Enum(ap(c_2Ebinary__ieee_2Erounding2num,inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2EroundTowardPositive))) = surj__ty_2Enum_2Enum(ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))) )
    & ( surj__ty_2Enum_2Enum(ap(c_2Ebinary__ieee_2Erounding2num,inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2EroundTowardNegative))) = surj__ty_2Enum_2Enum(ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))) )
    & ( surj__ty_2Enum_2Enum(ap(c_2Ebinary__ieee_2Erounding2num,inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2EroundTowardZero))) = surj__ty_2Enum_2Enum(ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Erounding__EQ__rounding,axiom,
    ! [V0a: tp__ty_2Ebinary__ieee_2Erounding,V1a_27: tp__ty_2Ebinary__ieee_2Erounding] :
      ( ( V0a = V1a_27 )
    <=> ( surj__ty_2Enum_2Enum(ap(c_2Ebinary__ieee_2Erounding2num,inj__ty_2Ebinary__ieee_2Erounding(V0a))) = surj__ty_2Enum_2Enum(ap(c_2Ebinary__ieee_2Erounding2num,inj__ty_2Ebinary__ieee_2Erounding(V1a_27))) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Erounding__size__def,axiom,
    ! [V0x: tp__ty_2Ebinary__ieee_2Erounding] : ( surj__ty_2Enum_2Enum(ap(c_2Ebinary__ieee_2Erounding__size,inj__ty_2Ebinary__ieee_2Erounding(V0x))) = fo__c_2Enum_2E0 ) ).

tff(lamtp_f2950,type,
    f2950: ( del * $i * $i * $i * $i ) > $i ).

tff(lameq_f2950,axiom,
    ! [A_27a: del,V2v1: $i] :
      ( mem(V2v1,A_27a)
     => ! [V3v2: $i] :
          ( mem(V3v2,A_27a)
         => ! [V4v3: $i] :
              ( mem(V4v3,A_27a)
             => ! [V1v0: $i] :
                  ( mem(V1v0,A_27a)
                 => ! [V5m: tp__ty_2Enum_2Enum] : ( ap(f2950(A_27a,V2v1,V3v2,V4v3,V1v0),inj__ty_2Enum_2Enum(V5m)) = ap(ap(ap(c_2Ebool_2ECOND(A_27a),ap(ap(c_2Eprim__rec_2E_3C,inj__ty_2Enum_2Enum(V5m)),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),V1v0),ap(ap(ap(c_2Ebool_2ECOND(A_27a),ap(ap(c_2Eprim__rec_2E_3C,inj__ty_2Enum_2Enum(V5m)),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),V2v1),ap(ap(ap(c_2Ebool_2ECOND(A_27a),ap(ap(c_2Emin_2E_3D(ty_2Enum_2Enum),inj__ty_2Enum_2Enum(V5m)),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),V3v2),V4v3))) ) ) ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Erounding__CASE,axiom,
    ! [A_27a: del,V0x: tp__ty_2Ebinary__ieee_2Erounding,V1v0: $i] :
      ( mem(V1v0,A_27a)
     => ! [V2v1: $i] :
          ( mem(V2v1,A_27a)
         => ! [V3v2: $i] :
              ( mem(V3v2,A_27a)
             => ! [V4v3: $i] :
                  ( mem(V4v3,A_27a)
                 => ( ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erounding__CASE(A_27a),inj__ty_2Ebinary__ieee_2Erounding(V0x)),V1v0),V2v1),V3v2),V4v3) = ap(f2950(A_27a,V2v1,V3v2,V4v3,V1v0),ap(c_2Ebinary__ieee_2Erounding2num,inj__ty_2Ebinary__ieee_2Erounding(V0x))) ) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Erounding__case__def,axiom,
    ! [A_27a: del] :
      ( ! [V0v0: $i] :
          ( mem(V0v0,A_27a)
         => ! [V1v1: $i] :
              ( mem(V1v1,A_27a)
             => ! [V2v2: $i] :
                  ( mem(V2v2,A_27a)
                 => ! [V3v3: $i] :
                      ( mem(V3v3,A_27a)
                     => ( ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erounding__CASE(A_27a),inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2EroundTiesToEven)),V0v0),V1v1),V2v2),V3v3) = V0v0 ) ) ) ) )
      & ! [V4v0: $i] :
          ( mem(V4v0,A_27a)
         => ! [V5v1: $i] :
              ( mem(V5v1,A_27a)
             => ! [V6v2: $i] :
                  ( mem(V6v2,A_27a)
                 => ! [V7v3: $i] :
                      ( mem(V7v3,A_27a)
                     => ( ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erounding__CASE(A_27a),inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2EroundTowardPositive)),V4v0),V5v1),V6v2),V7v3) = V5v1 ) ) ) ) )
      & ! [V8v0: $i] :
          ( mem(V8v0,A_27a)
         => ! [V9v1: $i] :
              ( mem(V9v1,A_27a)
             => ! [V10v2: $i] :
                  ( mem(V10v2,A_27a)
                 => ! [V11v3: $i] :
                      ( mem(V11v3,A_27a)
                     => ( ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erounding__CASE(A_27a),inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2EroundTowardNegative)),V8v0),V9v1),V10v2),V11v3) = V10v2 ) ) ) ) )
      & ! [V12v0: $i] :
          ( mem(V12v0,A_27a)
         => ! [V13v1: $i] :
              ( mem(V13v1,A_27a)
             => ! [V14v2: $i] :
                  ( mem(V14v2,A_27a)
                 => ! [V15v3: $i] :
                      ( mem(V15v3,A_27a)
                     => ( ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erounding__CASE(A_27a),inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2EroundTowardZero)),V12v0),V13v1),V14v2),V15v3) = V15v3 ) ) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Edatatype__rounding,axiom,
    ! [V0rounding: $i] :
      ( mem(V0rounding,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Erounding,bool)))))
     => p(ap(c_2Ebool_2EDATATYPE(bool),ap(ap(ap(ap(V0rounding,inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2EroundTiesToEven)),inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2EroundTowardPositive)),inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2EroundTowardNegative)),inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2EroundTowardZero)))) ) ).

tff(conj_thm_2Ebinary__ieee_2Erounding__distinct,axiom,
    ( ( fo__c_2Ebinary__ieee_2EroundTiesToEven != fo__c_2Ebinary__ieee_2EroundTowardPositive )
    & ( fo__c_2Ebinary__ieee_2EroundTiesToEven != fo__c_2Ebinary__ieee_2EroundTowardNegative )
    & ( fo__c_2Ebinary__ieee_2EroundTiesToEven != fo__c_2Ebinary__ieee_2EroundTowardZero )
    & ( fo__c_2Ebinary__ieee_2EroundTowardPositive != fo__c_2Ebinary__ieee_2EroundTowardNegative )
    & ( fo__c_2Ebinary__ieee_2EroundTowardPositive != fo__c_2Ebinary__ieee_2EroundTowardZero )
    & ( fo__c_2Ebinary__ieee_2EroundTowardNegative != fo__c_2Ebinary__ieee_2EroundTowardZero ) ) ).

tff(conj_thm_2Ebinary__ieee_2Erounding__nchotomy,axiom,
    ! [V0a: tp__ty_2Ebinary__ieee_2Erounding] :
      ( ( V0a = fo__c_2Ebinary__ieee_2EroundTiesToEven )
      | ( V0a = fo__c_2Ebinary__ieee_2EroundTowardPositive )
      | ( V0a = fo__c_2Ebinary__ieee_2EroundTowardNegative )
      | ( V0a = fo__c_2Ebinary__ieee_2EroundTowardZero ) ) ).

tff(conj_thm_2Ebinary__ieee_2Erounding__Axiom,axiom,
    ! [A_27a: del,V0x0: $i] :
      ( mem(V0x0,A_27a)
     => ! [V1x1: $i] :
          ( mem(V1x1,A_27a)
         => ! [V2x2: $i] :
              ( mem(V2x2,A_27a)
             => ! [V3x3: $i] :
                  ( mem(V3x3,A_27a)
                 => ? [V4f: $i] :
                      ( mem(V4f,arr(ty_2Ebinary__ieee_2Erounding,A_27a))
                      & ( ap(V4f,inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2EroundTiesToEven)) = V0x0 )
                      & ( ap(V4f,inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2EroundTowardPositive)) = V1x1 )
                      & ( ap(V4f,inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2EroundTowardNegative)) = V2x2 )
                      & ( ap(V4f,inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2EroundTowardZero)) = V3x3 ) ) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Erounding__induction,axiom,
    ! [V0P: $i] :
      ( mem(V0P,arr(ty_2Ebinary__ieee_2Erounding,bool))
     => ( ( p(ap(V0P,inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2EroundTiesToEven)))
          & p(ap(V0P,inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2EroundTowardNegative)))
          & p(ap(V0P,inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2EroundTowardPositive)))
          & p(ap(V0P,inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2EroundTowardZero))) )
       => ! [V1a: tp__ty_2Ebinary__ieee_2Erounding] : p(ap(V0P,inj__ty_2Ebinary__ieee_2Erounding(V1a))) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Erounding__case__cong,axiom,
    ! [A_27a: del,V0v0_27: $i] :
      ( mem(V0v0_27,A_27a)
     => ! [V1v1_27: $i] :
          ( mem(V1v1_27,A_27a)
         => ! [V2v2_27: $i] :
              ( mem(V2v2_27,A_27a)
             => ! [V3v3_27: $i] :
                  ( mem(V3v3_27,A_27a)
                 => ! [V4M: tp__ty_2Ebinary__ieee_2Erounding,V5M_27: tp__ty_2Ebinary__ieee_2Erounding,V6v0: $i] :
                      ( mem(V6v0,A_27a)
                     => ! [V7v1: $i] :
                          ( mem(V7v1,A_27a)
                         => ! [V8v2: $i] :
                              ( mem(V8v2,A_27a)
                             => ! [V9v3: $i] :
                                  ( mem(V9v3,A_27a)
                                 => ( ( ( V4M = V5M_27 )
                                      & ( ( V5M_27 = fo__c_2Ebinary__ieee_2EroundTiesToEven )
                                       => ( V6v0 = V0v0_27 ) )
                                      & ( ( V5M_27 = fo__c_2Ebinary__ieee_2EroundTowardPositive )
                                       => ( V7v1 = V1v1_27 ) )
                                      & ( ( V5M_27 = fo__c_2Ebinary__ieee_2EroundTowardNegative )
                                       => ( V8v2 = V2v2_27 ) )
                                      & ( ( V5M_27 = fo__c_2Ebinary__ieee_2EroundTowardZero )
                                       => ( V9v3 = V3v3_27 ) ) )
                                   => ( ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erounding__CASE(A_27a),inj__ty_2Ebinary__ieee_2Erounding(V4M)),V6v0),V7v1),V8v2),V9v3) = ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erounding__CASE(A_27a),inj__ty_2Ebinary__ieee_2Erounding(V5M_27)),V0v0_27),V1v1_27),V2v2_27),V3v3_27) ) ) ) ) ) ) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Erounding__case__eq,axiom,
    ! [A_27a: del,V0x: tp__ty_2Ebinary__ieee_2Erounding,V1v0: $i] :
      ( mem(V1v0,A_27a)
     => ! [V2v1: $i] :
          ( mem(V2v1,A_27a)
         => ! [V3v2: $i] :
              ( mem(V3v2,A_27a)
             => ! [V4v3: $i] :
                  ( mem(V4v3,A_27a)
                 => ! [V5v: $i] :
                      ( mem(V5v,A_27a)
                     => ( ( ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erounding__CASE(A_27a),inj__ty_2Ebinary__ieee_2Erounding(V0x)),V1v0),V2v1),V3v2),V4v3) = V5v )
                      <=> ( ( ( V0x = fo__c_2Ebinary__ieee_2EroundTiesToEven )
                            & ( V1v0 = V5v ) )
                          | ( ( V0x = fo__c_2Ebinary__ieee_2EroundTowardPositive )
                            & ( V2v1 = V5v ) )
                          | ( ( V0x = fo__c_2Ebinary__ieee_2EroundTowardNegative )
                            & ( V3v2 = V5v ) )
                          | ( ( V0x = fo__c_2Ebinary__ieee_2EroundTowardZero )
                            & ( V4v3 = V5v ) ) ) ) ) ) ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Eis__closest__def,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b),bool))
     => ! [V1x: tp__ty_2Erealax_2Ereal,V2a: $i] :
          ( mem(V2a,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b))
         => ( p(ap(ap(ap(c_2Ebinary__ieee_2Eis__closest(A_27a,A_27b),V0s),inj__ty_2Erealax_2Ereal(V1x)),V2a))
          <=> ( p(ap(ap(c_2Ebool_2EIN(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b)),V2a),V0s))
              & ! [V3b: $i] :
                  ( mem(V3b,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b))
                 => ( p(ap(ap(c_2Ebool_2EIN(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b)),V3b),V0s))
                   => p(ap(ap(c_2Ereal_2Ereal__lte,ap(c_2Ereal_2Eabs,ap(ap(c_2Ereal_2Ereal__sub,ap(c_2Ebinary__ieee_2Efloat__to__real(A_27a,A_27b),V2a)),inj__ty_2Erealax_2Ereal(V1x)))),ap(c_2Ereal_2Eabs,ap(ap(c_2Ereal_2Ereal__sub,ap(c_2Ebinary__ieee_2Efloat__to__real(A_27a,A_27b),V3b)),inj__ty_2Erealax_2Ereal(V1x))))) ) ) ) ) ) ) ).

tff(lamtp_f2951,type,
    f2951: ( del * del * tp__ty_2Erealax_2Ereal * $i * $i * $i ) > $i ).

tff(lameq_f2951,axiom,
    ! [A_27a: del,A_27b: del,V2x: tp__ty_2Erealax_2Ereal,V1s: $i] :
      ( mem(V1s,arr(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b),bool))
     => ! [V0p: $i] :
          ( mem(V0p,arr(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b),bool))
         => ! [V3a: $i] :
              ( mem(V3a,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b))
             => ! [V4b: $i] : ( ap(f2951(A_27a,A_27b,V2x,V1s,V0p,V3a),V4b) = ap(ap(c_2Emin_2E_3D_3D_3E,ap(ap(c_2Ebool_2E_2F_5C,ap(ap(ap(c_2Ebinary__ieee_2Eis__closest(A_27a,A_27b),V1s),inj__ty_2Erealax_2Ereal(V2x)),V4b)),ap(V0p,V4b))),ap(V0p,V3a)) ) ) ) ) ).

tff(lamtp_f2952,type,
    f2952: ( del * del * $i * $i * tp__ty_2Erealax_2Ereal ) > $i ).

tff(lameq_f2952,axiom,
    ! [A_27a: del,A_27b: del,V0p: $i] :
      ( mem(V0p,arr(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b),bool))
     => ! [V1s: $i] :
          ( mem(V1s,arr(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b),bool))
         => ! [V2x: tp__ty_2Erealax_2Ereal,V3a: $i] : ( ap(f2952(A_27a,A_27b,V0p,V1s,V2x),V3a) = ap(ap(c_2Ebool_2E_2F_5C,ap(ap(ap(c_2Ebinary__ieee_2Eis__closest(A_27a,A_27b),V1s),inj__ty_2Erealax_2Ereal(V2x)),V3a)),ap(c_2Ebool_2E_21(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b)),f2951(A_27a,A_27b,V2x,V1s,V0p,V3a))) ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Eclosest__such__def,axiom,
    ! [A_27a: del,A_27b: del,V0p: $i] :
      ( mem(V0p,arr(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b),bool))
     => ! [V1s: $i] :
          ( mem(V1s,arr(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b),bool))
         => ! [V2x: tp__ty_2Erealax_2Ereal] : ( ap(ap(ap(c_2Ebinary__ieee_2Eclosest__such(A_27a,A_27b),V0p),V1s),inj__ty_2Erealax_2Ereal(V2x)) = ap(c_2Emin_2E_40(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b)),f2952(A_27a,A_27b,V0p,V1s,V2x)) ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Eclosest__def,axiom,
    ! [A_27a: del,A_27b: del] : ( c_2Ebinary__ieee_2Eclosest(A_27a,A_27b) = ap(c_2Ebinary__ieee_2Eclosest__such(A_27a,A_27b),ap(c_2Ecombin_2EK(bool,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b)),inj__o(fo__c_2Ebool_2ET))) ) ).

tff(ax_thm_2Ebinary__ieee_2Elargest__def,axiom,
    ! [A_27t: del,A_27w: del] : ( surj__ty_2Erealax_2Ereal(ap(c_2Ebinary__ieee_2Elargest(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = surj__ty_2Erealax_2Ereal(ap(ap(c_2Erealax_2Ereal__mul,ap(ap(c_2Ereal_2E_2F,ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),ap(ap(c_2Earithmetic_2E_2D,ap(c_2Ewords_2EUINT__MAX(A_27w),c_2Ebool_2Ethe__value(A_27w))),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))))),ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),ap(c_2Ewords_2EINT__MAX(A_27w),c_2Ebool_2Ethe__value(A_27w))))),ap(ap(c_2Ereal_2Ereal__sub,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),ap(c_2Erealax_2Einv,ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),ap(c_2Efcp_2Edimindex(A_27t),c_2Ebool_2Ethe__value(A_27t))))))) ) ).

tff(ax_thm_2Ebinary__ieee_2Ethreshold__def,axiom,
    ! [A_27t: del,A_27w: del] : ( surj__ty_2Erealax_2Ereal(ap(c_2Ebinary__ieee_2Ethreshold(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = surj__ty_2Erealax_2Ereal(ap(ap(c_2Erealax_2Ereal__mul,ap(ap(c_2Ereal_2E_2F,ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),ap(ap(c_2Earithmetic_2E_2D,ap(c_2Ewords_2EUINT__MAX(A_27w),c_2Ebool_2Ethe__value(A_27w))),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))))),ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),ap(c_2Ewords_2EINT__MAX(A_27w),c_2Ebool_2Ethe__value(A_27w))))),ap(ap(c_2Ereal_2Ereal__sub,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),ap(c_2Erealax_2Einv,ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),ap(c_2Enum_2ESUC,ap(c_2Efcp_2Edimindex(A_27t),c_2Ebool_2Ethe__value(A_27t)))))))) ) ).

tff(lamtp_f2953,type,
    f2953: ( del * del ) > $i ).

tff(lameq_f2953,axiom,
    ! [A_27t: del,A_27w: del,V0R: $i] : ( ap(f2953(A_27t,A_27w),V0R) = ap(c_2Erelation_2EWF(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Ebool_2Eitself(A_27t))),V0R) ) ).

tff(lamtp_f2954,type,
    f2954: ( del * del ) > $i ).

tff(lameq_f2954,axiom,
    ! [A_27t: del,A_27w: del,V3v: $i] : ( ap(f2954(A_27t,A_27w),V3v) = k(ty_2Ebool_2Eitself(A_27t),ap(c_2Ecombin_2EI(ty_2Erealax_2Ereal),ap(ap(c_2Ereal_2E_2F,ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Enum_2Enum),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,A_27w)),V3v),ap(c_2Ewords_2En2w(A_27w),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))),ap(c_2Ewords_2Ew2n(A_27w),V3v)))),ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),ap(ap(c_2Earithmetic_2E_2B,ap(c_2Ewords_2EINT__MAX(A_27w),c_2Ebool_2Ethe__value(A_27w))),ap(c_2Efcp_2Edimindex(A_27t),c_2Ebool_2Ethe__value(A_27t))))))) ) ).

tff(lamtp_f2955,type,
    f2955: ( del * del ) > $i ).

tff(lameq_f2955,axiom,
    ! [A_27t: del,A_27w: del,V2a: $i] : ( ap(f2955(A_27t,A_27w),V2a) = ap(ap(c_2Epair_2Epair__CASE(ty_2Erealax_2Ereal,ty_2Efcp_2Ecart(bool,A_27w),ty_2Ebool_2Eitself(A_27t)),V2a),f2954(A_27t,A_27w)) ) ).

tff(ax_thm_2Ebinary__ieee_2EULP__primitive__def,axiom,
    ! [A_27t: del,A_27w: del] : ( c_2Ebinary__ieee_2EULP(A_27t,A_27w) = ap(ap(c_2Erelation_2EWFREC(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Ebool_2Eitself(A_27t)),ty_2Erealax_2Ereal),ap(c_2Emin_2E_40(arr(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Ebool_2Eitself(A_27t)),arr(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Ebool_2Eitself(A_27t)),bool))),f2953(A_27t,A_27w))),k(arr(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Ebool_2Eitself(A_27t)),ty_2Erealax_2Ereal),f2955(A_27t,A_27w))) ) ).

tff(conj_thm_2Ebinary__ieee_2EULP__ind,axiom,
    ! [A_27t: del,A_27w: del,V0P: $i] :
      ( mem(V0P,arr(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Ebool_2Eitself(A_27t)),bool))
     => ( ! [V1e: $i] :
            ( mem(V1e,ty_2Efcp_2Ecart(bool,A_27w))
           => p(ap(V0P,ap(ap(c_2Epair_2E_2C(ty_2Efcp_2Ecart(bool,A_27w),ty_2Ebool_2Eitself(A_27t)),V1e),c_2Ebool_2Ethe__value(A_27t)))) )
       => ! [V2v: $i] :
            ( mem(V2v,ty_2Efcp_2Ecart(bool,A_27w))
           => ! [V3v1: $i] :
                ( mem(V3v1,ty_2Ebool_2Eitself(A_27t))
               => p(ap(V0P,ap(ap(c_2Epair_2E_2C(ty_2Efcp_2Ecart(bool,A_27w),ty_2Ebool_2Eitself(A_27t)),V2v),V3v1))) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2EULP__def,axiom,
    ! [A_27t: del,A_27w: del,V0e: $i] :
      ( mem(V0e,ty_2Efcp_2Ecart(bool,A_27w))
     => ( surj__ty_2Erealax_2Ereal(ap(c_2Ebinary__ieee_2EULP(A_27t,A_27w),ap(ap(c_2Epair_2E_2C(ty_2Efcp_2Ecart(bool,A_27w),ty_2Ebool_2Eitself(A_27t)),V0e),c_2Ebool_2Ethe__value(A_27t)))) = surj__ty_2Erealax_2Ereal(ap(ap(c_2Ereal_2E_2F,ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Enum_2Enum),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,A_27w)),V0e),ap(c_2Ewords_2En2w(A_27w),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))),ap(c_2Ewords_2Ew2n(A_27w),V0e)))),ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),ap(ap(c_2Earithmetic_2E_2B,ap(c_2Ewords_2EINT__MAX(A_27w),c_2Ebool_2Ethe__value(A_27w))),ap(c_2Efcp_2Edimindex(A_27t),c_2Ebool_2Ethe__value(A_27t)))))) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Eulp__def,axiom,
    ! [A_27t: del,A_27w: del] : ( surj__ty_2Erealax_2Ereal(ap(c_2Ebinary__ieee_2Eulp(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = surj__ty_2Erealax_2Ereal(ap(c_2Ebinary__ieee_2EULP(A_27t,A_27w),ap(ap(c_2Epair_2E_2C(ty_2Efcp_2Ecart(bool,A_27w),ty_2Ebool_2Eitself(A_27t)),ap(c_2Ewords_2En2w(A_27w),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0))),c_2Ebool_2Ethe__value(A_27t)))) ) ).

tff(lamtp_f2956,type,
    f2956: ( del * del ) > $i ).

tff(lameq_f2956,axiom,
    ! [A_27t: del,A_27w: del,V3a: $i] : ( ap(f2956(A_27t,A_27w),V3a) = ap(c_2Ebool_2E_7E,ap(c_2Ewords_2Eword__lsb(A_27t),ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),V3a))) ) ).

tff(lamtp_f2957,type,
    f2957: ( del * del * tp__ty_2Erealax_2Ereal ) > $i ).

tff(lameq_f2957,axiom,
    ! [A_27w: del,A_27t: del,V1x: tp__ty_2Erealax_2Ereal,V2t: tp__ty_2Erealax_2Ereal] : ( ap(f2957(A_27w,A_27t,V1x),inj__ty_2Erealax_2Ereal(V2t)) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Ereal_2Ereal__lte,inj__ty_2Erealax_2Ereal(V1x)),ap(c_2Erealax_2Ereal__neg,inj__ty_2Erealax_2Ereal(V2t)))),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Ereal_2Ereal__ge,inj__ty_2Erealax_2Ereal(V1x)),inj__ty_2Erealax_2Ereal(V2t))),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(ap(c_2Ebinary__ieee_2Eclosest__such(A_27t,A_27w),f2956(A_27t,A_27w)),c_2Ebinary__ieee_2Efloat__is__finite(A_27t,A_27w)),inj__ty_2Erealax_2Ereal(V1x)))) ) ).

tff(lamtp_f2958,type,
    f2958: ( del * del * tp__ty_2Erealax_2Ereal ) > $i ).

tff(lameq_f2958,axiom,
    ! [A_27t: del,A_27w: del,V1x: tp__ty_2Erealax_2Ereal,V5a: $i] : ( ap(f2958(A_27t,A_27w,V1x),V5a) = ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool),V5a),ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27t,A_27w),V5a)),ap(ap(c_2Ereal_2Ereal__ge,ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),V5a)),inj__ty_2Erealax_2Ereal(V1x)))) ) ).

tff(lamtp_f2959,type,
    f2959: ( del * del * tp__ty_2Erealax_2Ereal ) > $i ).

tff(lameq_f2959,axiom,
    ! [A_27t: del,A_27w: del,V1x: tp__ty_2Erealax_2Ereal,V4t: tp__ty_2Erealax_2Ereal] : ( ap(f2959(A_27t,A_27w,V1x),inj__ty_2Erealax_2Ereal(V4t)) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Erealax_2Ereal__lt,inj__ty_2Erealax_2Ereal(V1x)),ap(c_2Erealax_2Ereal__neg,inj__ty_2Erealax_2Ereal(V4t)))),ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Ereal_2Ereal__gt,inj__ty_2Erealax_2Ereal(V1x)),inj__ty_2Erealax_2Ereal(V4t))),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(c_2Ebinary__ieee_2Eclosest(A_27t,A_27w),ap(c_2Epred__set_2EGSPEC(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2958(A_27t,A_27w,V1x))),inj__ty_2Erealax_2Ereal(V1x)))) ) ).

tff(lamtp_f2960,type,
    f2960: ( del * del * tp__ty_2Erealax_2Ereal ) > $i ).

tff(lameq_f2960,axiom,
    ! [A_27t: del,A_27w: del,V1x: tp__ty_2Erealax_2Ereal,V7a: $i] : ( ap(f2960(A_27t,A_27w,V1x),V7a) = ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool),V7a),ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27t,A_27w),V7a)),ap(ap(c_2Ereal_2Ereal__lte,ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),V7a)),inj__ty_2Erealax_2Ereal(V1x)))) ) ).

tff(lamtp_f2961,type,
    f2961: ( del * del * tp__ty_2Erealax_2Ereal ) > $i ).

tff(lameq_f2961,axiom,
    ! [A_27t: del,A_27w: del,V1x: tp__ty_2Erealax_2Ereal,V6t: tp__ty_2Erealax_2Ereal] : ( ap(f2961(A_27t,A_27w,V1x),inj__ty_2Erealax_2Ereal(V6t)) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Erealax_2Ereal__lt,inj__ty_2Erealax_2Ereal(V1x)),ap(c_2Erealax_2Ereal__neg,inj__ty_2Erealax_2Ereal(V6t)))),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Ereal_2Ereal__gt,inj__ty_2Erealax_2Ereal(V1x)),inj__ty_2Erealax_2Ereal(V6t))),ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(c_2Ebinary__ieee_2Eclosest(A_27t,A_27w),ap(c_2Epred__set_2EGSPEC(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2960(A_27t,A_27w,V1x))),inj__ty_2Erealax_2Ereal(V1x)))) ) ).

tff(lamtp_f2962,type,
    f2962: ( del * del * tp__ty_2Erealax_2Ereal ) > $i ).

tff(lameq_f2962,axiom,
    ! [A_27w: del,A_27t: del,V1x: tp__ty_2Erealax_2Ereal,V9a: $i] : ( ap(f2962(A_27w,A_27t,V1x),V9a) = ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool),V9a),ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27t,A_27w),V9a)),ap(ap(c_2Ereal_2Ereal__lte,ap(c_2Ereal_2Eabs,ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),V9a))),ap(c_2Ereal_2Eabs,inj__ty_2Erealax_2Ereal(V1x))))) ) ).

tff(lamtp_f2963,type,
    f2963: ( del * del * tp__ty_2Erealax_2Ereal ) > $i ).

tff(lameq_f2963,axiom,
    ! [A_27w: del,A_27t: del,V1x: tp__ty_2Erealax_2Ereal,V8t: tp__ty_2Erealax_2Ereal] : ( ap(f2963(A_27w,A_27t,V1x),inj__ty_2Erealax_2Ereal(V8t)) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Erealax_2Ereal__lt,inj__ty_2Erealax_2Ereal(V1x)),ap(c_2Erealax_2Ereal__neg,inj__ty_2Erealax_2Ereal(V8t)))),ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Ereal_2Ereal__gt,inj__ty_2Erealax_2Ereal(V1x)),inj__ty_2Erealax_2Ereal(V8t))),ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(c_2Ebinary__ieee_2Eclosest(A_27t,A_27w),ap(c_2Epred__set_2EGSPEC(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2962(A_27w,A_27t,V1x))),inj__ty_2Erealax_2Ereal(V1x)))) ) ).

tff(ax_thm_2Ebinary__ieee_2Eround__def,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: tp__ty_2Erealax_2Ereal] : ( ap(ap(c_2Ebinary__ieee_2Eround(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),inj__ty_2Erealax_2Ereal(V1x)) = ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erounding__CASE(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),ap(ap(c_2Ebool_2ELET(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2957(A_27w,A_27t,V1x)),ap(c_2Ebinary__ieee_2Ethreshold(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))),ap(ap(c_2Ebool_2ELET(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2959(A_27t,A_27w,V1x)),ap(c_2Ebinary__ieee_2Elargest(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))),ap(ap(c_2Ebool_2ELET(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2961(A_27t,A_27w,V1x)),ap(c_2Ebinary__ieee_2Elargest(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))),ap(ap(c_2Ebool_2ELET(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2963(A_27w,A_27t,V1x)),ap(c_2Ebinary__ieee_2Elargest(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) ) ).

tff(lamtp_f2964,type,
    f2964: ( del * del * $i ) > $i ).

tff(lameq_f2964,axiom,
    ! [A_27w: del,A_27t: del,V3a: $i] :
      ( mem(V3a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V4n: tp__ty_2Enum_2Enum] : ( ap(f2964(A_27w,A_27t,V3a),inj__ty_2Enum_2Enum(V4n)) = ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Earithmetic_2EEVEN,inj__ty_2Enum_2Enum(V4n))),ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),ap(c_2Ereal_2Eabs,ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),V3a))),ap(c_2Ereal_2Ereal__of__num,inj__ty_2Enum_2Enum(V4n)))) ) ) ).

tff(lamtp_f2965,type,
    f2965: ( del * del ) > $i ).

tff(lameq_f2965,axiom,
    ! [A_27t: del,A_27w: del,V3a: $i] : ( ap(f2965(A_27t,A_27w),V3a) = ap(c_2Ebool_2E_3F(ty_2Enum_2Enum),f2964(A_27w,A_27t,V3a)) ) ).

tff(lamtp_f2966,type,
    f2966: ( del * del * tp__ty_2Erealax_2Ereal ) > $i ).

tff(lameq_f2966,axiom,
    ! [A_27w: del,A_27t: del,V1x: tp__ty_2Erealax_2Ereal,V2t: tp__ty_2Erealax_2Ereal] : ( ap(f2966(A_27w,A_27t,V1x),inj__ty_2Erealax_2Ereal(V2t)) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Ereal_2Ereal__lte,inj__ty_2Erealax_2Ereal(V1x)),ap(c_2Erealax_2Ereal__neg,inj__ty_2Erealax_2Ereal(V2t)))),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Ereal_2Ereal__ge,inj__ty_2Erealax_2Ereal(V1x)),inj__ty_2Erealax_2Ereal(V2t))),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(ap(c_2Ebinary__ieee_2Eclosest__such(A_27t,A_27w),f2965(A_27t,A_27w)),c_2Ebinary__ieee_2Efloat__is__integral(A_27t,A_27w)),inj__ty_2Erealax_2Ereal(V1x)))) ) ).

tff(lamtp_f2967,type,
    f2967: ( del * del * tp__ty_2Erealax_2Ereal ) > $i ).

tff(lameq_f2967,axiom,
    ! [A_27t: del,A_27w: del,V1x: tp__ty_2Erealax_2Ereal,V6a: $i] : ( ap(f2967(A_27t,A_27w,V1x),V6a) = ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool),V6a),ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__integral(A_27t,A_27w),V6a)),ap(ap(c_2Ereal_2Ereal__ge,ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),V6a)),inj__ty_2Erealax_2Ereal(V1x)))) ) ).

tff(lamtp_f2968,type,
    f2968: ( del * del * tp__ty_2Erealax_2Ereal ) > $i ).

tff(lameq_f2968,axiom,
    ! [A_27t: del,A_27w: del,V1x: tp__ty_2Erealax_2Ereal,V5t: tp__ty_2Erealax_2Ereal] : ( ap(f2968(A_27t,A_27w,V1x),inj__ty_2Erealax_2Ereal(V5t)) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Erealax_2Ereal__lt,inj__ty_2Erealax_2Ereal(V1x)),ap(c_2Erealax_2Ereal__neg,inj__ty_2Erealax_2Ereal(V5t)))),ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Ereal_2Ereal__gt,inj__ty_2Erealax_2Ereal(V1x)),inj__ty_2Erealax_2Ereal(V5t))),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(c_2Ebinary__ieee_2Eclosest(A_27t,A_27w),ap(c_2Epred__set_2EGSPEC(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2967(A_27t,A_27w,V1x))),inj__ty_2Erealax_2Ereal(V1x)))) ) ).

tff(lamtp_f2969,type,
    f2969: ( del * del * tp__ty_2Erealax_2Ereal ) > $i ).

tff(lameq_f2969,axiom,
    ! [A_27t: del,A_27w: del,V1x: tp__ty_2Erealax_2Ereal,V8a: $i] : ( ap(f2969(A_27t,A_27w,V1x),V8a) = ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool),V8a),ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__integral(A_27t,A_27w),V8a)),ap(ap(c_2Ereal_2Ereal__lte,ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),V8a)),inj__ty_2Erealax_2Ereal(V1x)))) ) ).

tff(lamtp_f2970,type,
    f2970: ( del * del * tp__ty_2Erealax_2Ereal ) > $i ).

tff(lameq_f2970,axiom,
    ! [A_27t: del,A_27w: del,V1x: tp__ty_2Erealax_2Ereal,V7t: tp__ty_2Erealax_2Ereal] : ( ap(f2970(A_27t,A_27w,V1x),inj__ty_2Erealax_2Ereal(V7t)) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Erealax_2Ereal__lt,inj__ty_2Erealax_2Ereal(V1x)),ap(c_2Erealax_2Ereal__neg,inj__ty_2Erealax_2Ereal(V7t)))),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Ereal_2Ereal__gt,inj__ty_2Erealax_2Ereal(V1x)),inj__ty_2Erealax_2Ereal(V7t))),ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(c_2Ebinary__ieee_2Eclosest(A_27t,A_27w),ap(c_2Epred__set_2EGSPEC(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2969(A_27t,A_27w,V1x))),inj__ty_2Erealax_2Ereal(V1x)))) ) ).

tff(lamtp_f2971,type,
    f2971: ( del * del * tp__ty_2Erealax_2Ereal ) > $i ).

tff(lameq_f2971,axiom,
    ! [A_27w: del,A_27t: del,V1x: tp__ty_2Erealax_2Ereal,V10a: $i] : ( ap(f2971(A_27w,A_27t,V1x),V10a) = ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool),V10a),ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__integral(A_27t,A_27w),V10a)),ap(ap(c_2Ereal_2Ereal__lte,ap(c_2Ereal_2Eabs,ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),V10a))),ap(c_2Ereal_2Eabs,inj__ty_2Erealax_2Ereal(V1x))))) ) ).

tff(lamtp_f2972,type,
    f2972: ( del * del * tp__ty_2Erealax_2Ereal ) > $i ).

tff(lameq_f2972,axiom,
    ! [A_27w: del,A_27t: del,V1x: tp__ty_2Erealax_2Ereal,V9t: tp__ty_2Erealax_2Ereal] : ( ap(f2972(A_27w,A_27t,V1x),inj__ty_2Erealax_2Ereal(V9t)) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Erealax_2Ereal__lt,inj__ty_2Erealax_2Ereal(V1x)),ap(c_2Erealax_2Ereal__neg,inj__ty_2Erealax_2Ereal(V9t)))),ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Ereal_2Ereal__gt,inj__ty_2Erealax_2Ereal(V1x)),inj__ty_2Erealax_2Ereal(V9t))),ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(c_2Ebinary__ieee_2Eclosest(A_27t,A_27w),ap(c_2Epred__set_2EGSPEC(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2971(A_27w,A_27t,V1x))),inj__ty_2Erealax_2Ereal(V1x)))) ) ).

tff(ax_thm_2Ebinary__ieee_2Eintegral__round__def,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: tp__ty_2Erealax_2Ereal] : ( ap(ap(c_2Ebinary__ieee_2Eintegral__round(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),inj__ty_2Erealax_2Ereal(V1x)) = ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erounding__CASE(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),ap(ap(c_2Ebool_2ELET(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2966(A_27w,A_27t,V1x)),ap(c_2Ebinary__ieee_2Ethreshold(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))),ap(ap(c_2Ebool_2ELET(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2968(A_27t,A_27w,V1x)),ap(c_2Ebinary__ieee_2Elargest(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))),ap(ap(c_2Ebool_2ELET(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2970(A_27t,A_27w,V1x)),ap(c_2Ebinary__ieee_2Elargest(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))),ap(ap(c_2Ebool_2ELET(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2972(A_27w,A_27t,V1x)),ap(c_2Ebinary__ieee_2Elargest(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) ) ).

tff(lamtp_f2973,type,
    f2973: ( del * del * tp__ty_2Ebinary__ieee_2Erounding ) > $i ).

tff(lameq_f2973,axiom,
    ! [A_27w: del,A_27t: del,V6a0: tp__ty_2Ebinary__ieee_2Erounding,V7a1: $i] : ( ap(f2973(A_27w,A_27t,V6a0),V7a1) = ap(ap(ap(c_2Eind__type_2ECONSTR(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))),inj__ty_2Ebinary__ieee_2Erounding(V6a0)),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),V7a1),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),k(ty_2Enum_2Enum,c_2Eind__type_2EBOTTOM(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))) ) ).

tff(lamtp_f2974,type,
    f2974: ( del * del ) > $i ).

tff(lameq_f2974,axiom,
    ! [A_27t: del,A_27w: del,V6a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(f2974(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V6a0)) = f2973(A_27w,A_27t,V6a0) ) ).

tff(lamtp_f2975,type,
    f2975: ( del * del * tp__ty_2Ebinary__ieee_2Erounding * $i ) > $i ).

tff(lameq_f2975,axiom,
    ! [A_27t: del,A_27w: del,V4a0: tp__ty_2Ebinary__ieee_2Erounding,V3a0_27: $i] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V5a1: $i] : ( ap(f2975(A_27t,A_27w,V4a0,V3a0_27),V5a1) = ap(ap(c_2Emin_2E_3D(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),V3a0_27),ap(ap(f2974(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V4a0)),V5a1)) ) ) ).

tff(lamtp_f2976,type,
    f2976: ( del * del * $i ) > $i ).

tff(lameq_f2976,axiom,
    ! [A_27w: del,A_27t: del,V3a0_27: $i] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V4a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(f2976(A_27w,A_27t,V3a0_27),inj__ty_2Ebinary__ieee_2Erounding(V4a0)) = ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2975(A_27t,A_27w,V4a0,V3a0_27)) ) ) ).

tff(lamtp_f2977,type,
    f2977: ( del * del * $i * tp__ty_2Ebinary__ieee_2Erounding ) > $i ).

tff(lameq_f2977,axiom,
    ! [A_27w: del,A_27t: del,V13a1: $i] :
      ( mem(V13a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V12a0: tp__ty_2Ebinary__ieee_2Erounding,V14a2: $i] : ( ap(f2977(A_27w,A_27t,V13a1,V12a0),V14a2) = ap(ap(ap(c_2Eind__type_2ECONSTR(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ap(c_2Enum_2ESUC,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))),inj__ty_2Ebinary__ieee_2Erounding(V12a0)),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),V13a1),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V14a2),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),k(ty_2Enum_2Enum,c_2Eind__type_2EBOTTOM(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))) ) ) ).

tff(lamtp_f2978,type,
    f2978: ( del * del * tp__ty_2Ebinary__ieee_2Erounding ) > $i ).

tff(lameq_f2978,axiom,
    ! [A_27w: del,A_27t: del,V12a0: tp__ty_2Ebinary__ieee_2Erounding,V13a1: $i] : ( ap(f2978(A_27w,A_27t,V12a0),V13a1) = f2977(A_27w,A_27t,V13a1,V12a0) ) ).

tff(lamtp_f2979,type,
    f2979: ( del * del ) > $i ).

tff(lameq_f2979,axiom,
    ! [A_27t: del,A_27w: del,V12a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(f2979(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V12a0)) = f2978(A_27w,A_27t,V12a0) ) ).

tff(lamtp_f2980,type,
    f2980: ( del * del * tp__ty_2Ebinary__ieee_2Erounding * $i * $i ) > $i ).

tff(lameq_f2980,axiom,
    ! [A_27t: del,A_27w: del,V9a0: tp__ty_2Ebinary__ieee_2Erounding,V10a1: $i] :
      ( mem(V10a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V3a0_27: $i] :
          ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
         => ! [V11a2: $i] : ( ap(f2980(A_27t,A_27w,V9a0,V10a1,V3a0_27),V11a2) = ap(ap(c_2Emin_2E_3D(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),V3a0_27),ap(ap(ap(f2979(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V9a0)),V10a1),V11a2)) ) ) ) ).

tff(lamtp_f2981,type,
    f2981: ( del * del * $i * tp__ty_2Ebinary__ieee_2Erounding ) > $i ).

tff(lameq_f2981,axiom,
    ! [A_27t: del,A_27w: del,V3a0_27: $i] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V9a0: tp__ty_2Ebinary__ieee_2Erounding,V10a1: $i] : ( ap(f2981(A_27t,A_27w,V3a0_27,V9a0),V10a1) = ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2980(A_27t,A_27w,V9a0,V10a1,V3a0_27)) ) ) ).

tff(lamtp_f2982,type,
    f2982: ( del * del * $i ) > $i ).

tff(lameq_f2982,axiom,
    ! [A_27w: del,A_27t: del,V3a0_27: $i] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V9a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(f2982(A_27w,A_27t,V3a0_27),inj__ty_2Ebinary__ieee_2Erounding(V9a0)) = ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2981(A_27t,A_27w,V3a0_27,V9a0)) ) ) ).

tff(lamtp_f2983,type,
    f2983: ( del * del * $i * tp__ty_2Ebinary__ieee_2Erounding ) > $i ).

tff(lameq_f2983,axiom,
    ! [A_27w: del,A_27t: del,V20a1: $i] :
      ( mem(V20a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V19a0: tp__ty_2Ebinary__ieee_2Erounding,V21a2: $i] : ( ap(f2983(A_27w,A_27t,V20a1,V19a0),V21a2) = ap(ap(ap(c_2Eind__type_2ECONSTR(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))),inj__ty_2Ebinary__ieee_2Erounding(V19a0)),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),V20a1),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V21a2),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),k(ty_2Enum_2Enum,c_2Eind__type_2EBOTTOM(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))) ) ) ).

tff(lamtp_f2984,type,
    f2984: ( del * del * tp__ty_2Ebinary__ieee_2Erounding ) > $i ).

tff(lameq_f2984,axiom,
    ! [A_27w: del,A_27t: del,V19a0: tp__ty_2Ebinary__ieee_2Erounding,V20a1: $i] : ( ap(f2984(A_27w,A_27t,V19a0),V20a1) = f2983(A_27w,A_27t,V20a1,V19a0) ) ).

tff(lamtp_f2985,type,
    f2985: ( del * del ) > $i ).

tff(lameq_f2985,axiom,
    ! [A_27t: del,A_27w: del,V19a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(f2985(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V19a0)) = f2984(A_27w,A_27t,V19a0) ) ).

tff(lamtp_f2986,type,
    f2986: ( del * del * tp__ty_2Ebinary__ieee_2Erounding * $i * $i ) > $i ).

tff(lameq_f2986,axiom,
    ! [A_27t: del,A_27w: del,V16a0: tp__ty_2Ebinary__ieee_2Erounding,V17a1: $i] :
      ( mem(V17a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V3a0_27: $i] :
          ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
         => ! [V18a2: $i] : ( ap(f2986(A_27t,A_27w,V16a0,V17a1,V3a0_27),V18a2) = ap(ap(c_2Emin_2E_3D(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),V3a0_27),ap(ap(ap(f2985(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V16a0)),V17a1),V18a2)) ) ) ) ).

tff(lamtp_f2987,type,
    f2987: ( del * del * $i * tp__ty_2Ebinary__ieee_2Erounding ) > $i ).

tff(lameq_f2987,axiom,
    ! [A_27t: del,A_27w: del,V3a0_27: $i] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V16a0: tp__ty_2Ebinary__ieee_2Erounding,V17a1: $i] : ( ap(f2987(A_27t,A_27w,V3a0_27,V16a0),V17a1) = ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2986(A_27t,A_27w,V16a0,V17a1,V3a0_27)) ) ) ).

tff(lamtp_f2988,type,
    f2988: ( del * del * $i ) > $i ).

tff(lameq_f2988,axiom,
    ! [A_27w: del,A_27t: del,V3a0_27: $i] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V16a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(f2988(A_27w,A_27t,V3a0_27),inj__ty_2Ebinary__ieee_2Erounding(V16a0)) = ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2987(A_27t,A_27w,V3a0_27,V16a0)) ) ) ).

tff(lamtp_f2989,type,
    f2989: ( del * del * $i * tp__ty_2Ebinary__ieee_2Erounding ) > $i ).

tff(lameq_f2989,axiom,
    ! [A_27w: del,A_27t: del,V27a1: $i] :
      ( mem(V27a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V26a0: tp__ty_2Ebinary__ieee_2Erounding,V28a2: $i] : ( ap(f2989(A_27w,A_27t,V27a1,V26a0),V28a2) = ap(ap(ap(c_2Eind__type_2ECONSTR(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))),inj__ty_2Ebinary__ieee_2Erounding(V26a0)),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),V27a1),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V28a2),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),k(ty_2Enum_2Enum,c_2Eind__type_2EBOTTOM(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))) ) ) ).

tff(lamtp_f2990,type,
    f2990: ( del * del * tp__ty_2Ebinary__ieee_2Erounding ) > $i ).

tff(lameq_f2990,axiom,
    ! [A_27w: del,A_27t: del,V26a0: tp__ty_2Ebinary__ieee_2Erounding,V27a1: $i] : ( ap(f2990(A_27w,A_27t,V26a0),V27a1) = f2989(A_27w,A_27t,V27a1,V26a0) ) ).

tff(lamtp_f2991,type,
    f2991: ( del * del ) > $i ).

tff(lameq_f2991,axiom,
    ! [A_27t: del,A_27w: del,V26a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(f2991(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V26a0)) = f2990(A_27w,A_27t,V26a0) ) ).

tff(lamtp_f2992,type,
    f2992: ( del * del * tp__ty_2Ebinary__ieee_2Erounding * $i * $i ) > $i ).

tff(lameq_f2992,axiom,
    ! [A_27t: del,A_27w: del,V23a0: tp__ty_2Ebinary__ieee_2Erounding,V24a1: $i] :
      ( mem(V24a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V3a0_27: $i] :
          ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
         => ! [V25a2: $i] : ( ap(f2992(A_27t,A_27w,V23a0,V24a1,V3a0_27),V25a2) = ap(ap(c_2Emin_2E_3D(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),V3a0_27),ap(ap(ap(f2991(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V23a0)),V24a1),V25a2)) ) ) ) ).

tff(lamtp_f2993,type,
    f2993: ( del * del * $i * tp__ty_2Ebinary__ieee_2Erounding ) > $i ).

tff(lameq_f2993,axiom,
    ! [A_27t: del,A_27w: del,V3a0_27: $i] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V23a0: tp__ty_2Ebinary__ieee_2Erounding,V24a1: $i] : ( ap(f2993(A_27t,A_27w,V3a0_27,V23a0),V24a1) = ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2992(A_27t,A_27w,V23a0,V24a1,V3a0_27)) ) ) ).

tff(lamtp_f2994,type,
    f2994: ( del * del * $i ) > $i ).

tff(lameq_f2994,axiom,
    ! [A_27w: del,A_27t: del,V3a0_27: $i] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V23a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(f2994(A_27w,A_27t,V3a0_27),inj__ty_2Ebinary__ieee_2Erounding(V23a0)) = ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2993(A_27t,A_27w,V3a0_27,V23a0)) ) ) ).

tff(lamtp_f2995,type,
    f2995: ( del * del * $i * tp__ty_2Ebinary__ieee_2Erounding ) > $i ).

tff(lameq_f2995,axiom,
    ! [A_27w: del,A_27t: del,V34a1: $i] :
      ( mem(V34a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V33a0: tp__ty_2Ebinary__ieee_2Erounding,V35a2: $i] : ( ap(f2995(A_27w,A_27t,V34a1,V33a0),V35a2) = ap(ap(ap(c_2Eind__type_2ECONSTR(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))),inj__ty_2Ebinary__ieee_2Erounding(V33a0)),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),V34a1),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V35a2),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),k(ty_2Enum_2Enum,c_2Eind__type_2EBOTTOM(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))) ) ) ).

tff(lamtp_f2996,type,
    f2996: ( del * del * tp__ty_2Ebinary__ieee_2Erounding ) > $i ).

tff(lameq_f2996,axiom,
    ! [A_27w: del,A_27t: del,V33a0: tp__ty_2Ebinary__ieee_2Erounding,V34a1: $i] : ( ap(f2996(A_27w,A_27t,V33a0),V34a1) = f2995(A_27w,A_27t,V34a1,V33a0) ) ).

tff(lamtp_f2997,type,
    f2997: ( del * del ) > $i ).

tff(lameq_f2997,axiom,
    ! [A_27t: del,A_27w: del,V33a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(f2997(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V33a0)) = f2996(A_27w,A_27t,V33a0) ) ).

tff(lamtp_f2998,type,
    f2998: ( del * del * tp__ty_2Ebinary__ieee_2Erounding * $i * $i ) > $i ).

tff(lameq_f2998,axiom,
    ! [A_27t: del,A_27w: del,V30a0: tp__ty_2Ebinary__ieee_2Erounding,V31a1: $i] :
      ( mem(V31a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V3a0_27: $i] :
          ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
         => ! [V32a2: $i] : ( ap(f2998(A_27t,A_27w,V30a0,V31a1,V3a0_27),V32a2) = ap(ap(c_2Emin_2E_3D(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),V3a0_27),ap(ap(ap(f2997(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V30a0)),V31a1),V32a2)) ) ) ) ).

tff(lamtp_f2999,type,
    f2999: ( del * del * $i * tp__ty_2Ebinary__ieee_2Erounding ) > $i ).

tff(lameq_f2999,axiom,
    ! [A_27t: del,A_27w: del,V3a0_27: $i] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V30a0: tp__ty_2Ebinary__ieee_2Erounding,V31a1: $i] : ( ap(f2999(A_27t,A_27w,V3a0_27,V30a0),V31a1) = ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2998(A_27t,A_27w,V30a0,V31a1,V3a0_27)) ) ) ).

tff(lamtp_f3000,type,
    f3000: ( del * del * $i ) > $i ).

tff(lameq_f3000,axiom,
    ! [A_27w: del,A_27t: del,V3a0_27: $i] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V30a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(f3000(A_27w,A_27t,V3a0_27),inj__ty_2Ebinary__ieee_2Erounding(V30a0)) = ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2999(A_27t,A_27w,V3a0_27,V30a0)) ) ) ).

tff(lamtp_f3001,type,
    f3001: ( del * del * $i * $i * tp__ty_2Ebinary__ieee_2Erounding ) > $i ).

tff(lameq_f3001,axiom,
    ! [A_27w: del,A_27t: del,V42a1: $i] :
      ( mem(V42a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V43a2: $i] :
          ( mem(V43a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V41a0: tp__ty_2Ebinary__ieee_2Erounding,V44a3: $i] : ( ap(f3001(A_27w,A_27t,V42a1,V43a2,V41a0),V44a3) = ap(ap(ap(c_2Eind__type_2ECONSTR(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0))))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))),inj__ty_2Ebinary__ieee_2Erounding(V41a0)),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),V42a1),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V43a2),V44a3)))),k(ty_2Enum_2Enum,c_2Eind__type_2EBOTTOM(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))) ) ) ) ).

tff(lamtp_f3002,type,
    f3002: ( del * del * $i * tp__ty_2Ebinary__ieee_2Erounding ) > $i ).

tff(lameq_f3002,axiom,
    ! [A_27w: del,A_27t: del,V42a1: $i] :
      ( mem(V42a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V41a0: tp__ty_2Ebinary__ieee_2Erounding,V43a2: $i] : ( ap(f3002(A_27w,A_27t,V42a1,V41a0),V43a2) = f3001(A_27w,A_27t,V42a1,V43a2,V41a0) ) ) ).

tff(lamtp_f3003,type,
    f3003: ( del * del * tp__ty_2Ebinary__ieee_2Erounding ) > $i ).

tff(lameq_f3003,axiom,
    ! [A_27w: del,A_27t: del,V41a0: tp__ty_2Ebinary__ieee_2Erounding,V42a1: $i] : ( ap(f3003(A_27w,A_27t,V41a0),V42a1) = f3002(A_27w,A_27t,V42a1,V41a0) ) ).

tff(lamtp_f3004,type,
    f3004: ( del * del ) > $i ).

tff(lameq_f3004,axiom,
    ! [A_27t: del,A_27w: del,V41a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(f3004(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V41a0)) = f3003(A_27w,A_27t,V41a0) ) ).

tff(lamtp_f3005,type,
    f3005: ( del * del * $i * tp__ty_2Ebinary__ieee_2Erounding * $i * $i ) > $i ).

tff(lameq_f3005,axiom,
    ! [A_27t: del,A_27w: del,V38a1: $i] :
      ( mem(V38a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V37a0: tp__ty_2Ebinary__ieee_2Erounding,V39a2: $i] :
          ( mem(V39a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V3a0_27: $i] :
              ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
             => ! [V40a3: $i] : ( ap(f3005(A_27t,A_27w,V38a1,V37a0,V39a2,V3a0_27),V40a3) = ap(ap(c_2Emin_2E_3D(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),V3a0_27),ap(ap(ap(ap(f3004(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V37a0)),V38a1),V39a2),V40a3)) ) ) ) ) ).

tff(lamtp_f3006,type,
    f3006: ( del * del * $i * tp__ty_2Ebinary__ieee_2Erounding * $i ) > $i ).

tff(lameq_f3006,axiom,
    ! [A_27t: del,A_27w: del,V3a0_27: $i] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V37a0: tp__ty_2Ebinary__ieee_2Erounding,V38a1: $i] :
          ( mem(V38a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V39a2: $i] : ( ap(f3006(A_27t,A_27w,V3a0_27,V37a0,V38a1),V39a2) = ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f3005(A_27t,A_27w,V38a1,V37a0,V39a2,V3a0_27)) ) ) ) ).

tff(lamtp_f3007,type,
    f3007: ( del * del * tp__ty_2Ebinary__ieee_2Erounding * $i ) > $i ).

tff(lameq_f3007,axiom,
    ! [A_27t: del,A_27w: del,V37a0: tp__ty_2Ebinary__ieee_2Erounding,V3a0_27: $i] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V38a1: $i] : ( ap(f3007(A_27t,A_27w,V37a0,V3a0_27),V38a1) = ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f3006(A_27t,A_27w,V3a0_27,V37a0,V38a1)) ) ) ).

tff(lamtp_f3008,type,
    f3008: ( del * del * $i ) > $i ).

tff(lameq_f3008,axiom,
    ! [A_27w: del,A_27t: del,V3a0_27: $i] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V37a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(f3008(A_27w,A_27t,V3a0_27),inj__ty_2Ebinary__ieee_2Erounding(V37a0)) = ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f3007(A_27t,A_27w,V37a0,V3a0_27)) ) ) ).

tff(lamtp_f3009,type,
    f3009: ( del * del * $i * $i * tp__ty_2Ebinary__ieee_2Erounding ) > $i ).

tff(lameq_f3009,axiom,
    ! [A_27w: del,A_27t: del,V51a1: $i] :
      ( mem(V51a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V52a2: $i] :
          ( mem(V52a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V50a0: tp__ty_2Ebinary__ieee_2Erounding,V53a3: $i] : ( ap(f3009(A_27w,A_27t,V51a1,V52a2,V50a0),V53a3) = ap(ap(ap(c_2Eind__type_2ECONSTR(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))),inj__ty_2Ebinary__ieee_2Erounding(V50a0)),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),V51a1),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V52a2),V53a3)))),k(ty_2Enum_2Enum,c_2Eind__type_2EBOTTOM(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))) ) ) ) ).

tff(lamtp_f3010,type,
    f3010: ( del * del * $i * tp__ty_2Ebinary__ieee_2Erounding ) > $i ).

tff(lameq_f3010,axiom,
    ! [A_27w: del,A_27t: del,V51a1: $i] :
      ( mem(V51a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V50a0: tp__ty_2Ebinary__ieee_2Erounding,V52a2: $i] : ( ap(f3010(A_27w,A_27t,V51a1,V50a0),V52a2) = f3009(A_27w,A_27t,V51a1,V52a2,V50a0) ) ) ).

tff(lamtp_f3011,type,
    f3011: ( del * del * tp__ty_2Ebinary__ieee_2Erounding ) > $i ).

tff(lameq_f3011,axiom,
    ! [A_27w: del,A_27t: del,V50a0: tp__ty_2Ebinary__ieee_2Erounding,V51a1: $i] : ( ap(f3011(A_27w,A_27t,V50a0),V51a1) = f3010(A_27w,A_27t,V51a1,V50a0) ) ).

tff(lamtp_f3012,type,
    f3012: ( del * del ) > $i ).

tff(lameq_f3012,axiom,
    ! [A_27t: del,A_27w: del,V50a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(f3012(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V50a0)) = f3011(A_27w,A_27t,V50a0) ) ).

tff(lamtp_f3013,type,
    f3013: ( del * del * $i * tp__ty_2Ebinary__ieee_2Erounding * $i * $i ) > $i ).

tff(lameq_f3013,axiom,
    ! [A_27t: del,A_27w: del,V47a1: $i] :
      ( mem(V47a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V46a0: tp__ty_2Ebinary__ieee_2Erounding,V48a2: $i] :
          ( mem(V48a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V3a0_27: $i] :
              ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
             => ! [V49a3: $i] : ( ap(f3013(A_27t,A_27w,V47a1,V46a0,V48a2,V3a0_27),V49a3) = ap(ap(c_2Emin_2E_3D(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),V3a0_27),ap(ap(ap(ap(f3012(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V46a0)),V47a1),V48a2),V49a3)) ) ) ) ) ).

tff(lamtp_f3014,type,
    f3014: ( del * del * $i * tp__ty_2Ebinary__ieee_2Erounding * $i ) > $i ).

tff(lameq_f3014,axiom,
    ! [A_27t: del,A_27w: del,V3a0_27: $i] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V46a0: tp__ty_2Ebinary__ieee_2Erounding,V47a1: $i] :
          ( mem(V47a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V48a2: $i] : ( ap(f3014(A_27t,A_27w,V3a0_27,V46a0,V47a1),V48a2) = ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f3013(A_27t,A_27w,V47a1,V46a0,V48a2,V3a0_27)) ) ) ) ).

tff(lamtp_f3015,type,
    f3015: ( del * del * tp__ty_2Ebinary__ieee_2Erounding * $i ) > $i ).

tff(lameq_f3015,axiom,
    ! [A_27t: del,A_27w: del,V46a0: tp__ty_2Ebinary__ieee_2Erounding,V3a0_27: $i] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V47a1: $i] : ( ap(f3015(A_27t,A_27w,V46a0,V3a0_27),V47a1) = ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f3014(A_27t,A_27w,V3a0_27,V46a0,V47a1)) ) ) ).

tff(lamtp_f3016,type,
    f3016: ( del * del * $i ) > $i ).

tff(lameq_f3016,axiom,
    ! [A_27w: del,A_27t: del,V3a0_27: $i] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V46a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(f3016(A_27w,A_27t,V3a0_27),inj__ty_2Ebinary__ieee_2Erounding(V46a0)) = ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f3015(A_27t,A_27w,V46a0,V3a0_27)) ) ) ).

tff(lamtp_f3017,type,
    f3017: ( del * del * $i ) > $i ).

tff(lameq_f3017,axiom,
    ! [A_27t: del,A_27w: del,V2_27fp__op_27: $i] :
      ( mem(V2_27fp__op_27,arr(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),bool))
     => ! [V3a0_27: $i] : ( ap(f3017(A_27t,A_27w,V2_27fp__op_27),V3a0_27) = ap(ap(c_2Emin_2E_3D_3D_3E,ap(ap(c_2Ebool_2E_5C_2F,ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Erounding),f2976(A_27w,A_27t,V3a0_27))),ap(ap(c_2Ebool_2E_5C_2F,ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Erounding),f2982(A_27w,A_27t,V3a0_27))),ap(ap(c_2Ebool_2E_5C_2F,ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Erounding),f2988(A_27w,A_27t,V3a0_27))),ap(ap(c_2Ebool_2E_5C_2F,ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Erounding),f2994(A_27w,A_27t,V3a0_27))),ap(ap(c_2Ebool_2E_5C_2F,ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Erounding),f3000(A_27w,A_27t,V3a0_27))),ap(ap(c_2Ebool_2E_5C_2F,ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Erounding),f3008(A_27w,A_27t,V3a0_27))),ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Erounding),f3016(A_27w,A_27t,V3a0_27))))))))),ap(V2_27fp__op_27,V3a0_27)) ) ) ).

tff(lamtp_f3018,type,
    f3018: ( del * del * $i ) > $i ).

tff(lameq_f3018,axiom,
    ! [A_27t: del,A_27w: del,V1a0_27: $i] :
      ( mem(V1a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V2_27fp__op_27: $i] : ( ap(f3018(A_27t,A_27w,V1a0_27),V2_27fp__op_27) = ap(ap(c_2Emin_2E_3D_3D_3E,ap(c_2Ebool_2E_21(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),f3017(A_27t,A_27w,V2_27fp__op_27))),ap(V2_27fp__op_27,V1a0_27)) ) ) ).

tff(lamtp_f3019,type,
    f3019: ( del * del ) > $i ).

tff(lameq_f3019,axiom,
    ! [A_27t: del,A_27w: del,V1a0_27: $i] : ( ap(f3019(A_27t,A_27w),V1a0_27) = ap(c_2Ebool_2E_21(arr(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),bool)),f3018(A_27t,A_27w,V1a0_27)) ) ).

tff(ax_thm_2Ebinary__ieee_2Efp__op__TY__DEF,axiom,
    ! [A_27t: del,A_27w: del] :
    ? [V0rep: $i] :
      ( mem(V0rep,arr(ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w),ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))))
      & p(ap(ap(c_2Ebool_2ETYPE__DEFINITION(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w)),f3019(A_27t,A_27w)),V0rep)) ) ).

tff(ax_thm_2Ebinary__ieee_2Efp__op__case__def,axiom,
    ! [A_27a: del,A_27t: del,A_27w: del] :
      ( ! [V0a0: tp__ty_2Ebinary__ieee_2Erounding,V1a1: $i] :
          ( mem(V1a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V2f: $i] :
              ( mem(V2f,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))
             => ! [V3f1: $i] :
                  ( mem(V3f1,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                 => ! [V4f2: $i] :
                      ( mem(V4f2,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                     => ! [V5f3: $i] :
                          ( mem(V5f3,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                         => ! [V6f4: $i] :
                              ( mem(V6f4,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                             => ! [V7f5: $i] :
                                  ( mem(V7f5,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                 => ! [V8f6: $i] :
                                      ( mem(V8f6,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                     => ( ap(ap(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efp__op__CASE(A_27a,A_27t,A_27w),ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0a0)),V1a1)),V2f),V3f1),V4f2),V5f3),V6f4),V7f5),V8f6) = ap(ap(V2f,inj__ty_2Ebinary__ieee_2Erounding(V0a0)),V1a1) ) ) ) ) ) ) ) ) )
      & ! [V9a0: tp__ty_2Ebinary__ieee_2Erounding,V10a1: $i] :
          ( mem(V10a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V11a2: $i] :
              ( mem(V11a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V12f: $i] :
                  ( mem(V12f,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))
                 => ! [V13f1: $i] :
                      ( mem(V13f1,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                     => ! [V14f2: $i] :
                          ( mem(V14f2,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                         => ! [V15f3: $i] :
                              ( mem(V15f3,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                             => ! [V16f4: $i] :
                                  ( mem(V16f4,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                 => ! [V17f5: $i] :
                                      ( mem(V17f5,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                     => ! [V18f6: $i] :
                                          ( mem(V18f6,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                         => ( ap(ap(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efp__op__CASE(A_27a,A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V9a0)),V10a1),V11a2)),V12f),V13f1),V14f2),V15f3),V16f4),V17f5),V18f6) = ap(ap(ap(V13f1,inj__ty_2Ebinary__ieee_2Erounding(V9a0)),V10a1),V11a2) ) ) ) ) ) ) ) ) ) )
      & ! [V19a0: tp__ty_2Ebinary__ieee_2Erounding,V20a1: $i] :
          ( mem(V20a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V21a2: $i] :
              ( mem(V21a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V22f: $i] :
                  ( mem(V22f,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))
                 => ! [V23f1: $i] :
                      ( mem(V23f1,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                     => ! [V24f2: $i] :
                          ( mem(V24f2,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                         => ! [V25f3: $i] :
                              ( mem(V25f3,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                             => ! [V26f4: $i] :
                                  ( mem(V26f4,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                 => ! [V27f5: $i] :
                                      ( mem(V27f5,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                     => ! [V28f6: $i] :
                                          ( mem(V28f6,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                         => ( ap(ap(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efp__op__CASE(A_27a,A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V19a0)),V20a1),V21a2)),V22f),V23f1),V24f2),V25f3),V26f4),V27f5),V28f6) = ap(ap(ap(V24f2,inj__ty_2Ebinary__ieee_2Erounding(V19a0)),V20a1),V21a2) ) ) ) ) ) ) ) ) ) )
      & ! [V29a0: tp__ty_2Ebinary__ieee_2Erounding,V30a1: $i] :
          ( mem(V30a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V31a2: $i] :
              ( mem(V31a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V32f: $i] :
                  ( mem(V32f,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))
                 => ! [V33f1: $i] :
                      ( mem(V33f1,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                     => ! [V34f2: $i] :
                          ( mem(V34f2,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                         => ! [V35f3: $i] :
                              ( mem(V35f3,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                             => ! [V36f4: $i] :
                                  ( mem(V36f4,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                 => ! [V37f5: $i] :
                                      ( mem(V37f5,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                     => ! [V38f6: $i] :
                                          ( mem(V38f6,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                         => ( ap(ap(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efp__op__CASE(A_27a,A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V29a0)),V30a1),V31a2)),V32f),V33f1),V34f2),V35f3),V36f4),V37f5),V38f6) = ap(ap(ap(V35f3,inj__ty_2Ebinary__ieee_2Erounding(V29a0)),V30a1),V31a2) ) ) ) ) ) ) ) ) ) )
      & ! [V39a0: tp__ty_2Ebinary__ieee_2Erounding,V40a1: $i] :
          ( mem(V40a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V41a2: $i] :
              ( mem(V41a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V42f: $i] :
                  ( mem(V42f,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))
                 => ! [V43f1: $i] :
                      ( mem(V43f1,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                     => ! [V44f2: $i] :
                          ( mem(V44f2,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                         => ! [V45f3: $i] :
                              ( mem(V45f3,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                             => ! [V46f4: $i] :
                                  ( mem(V46f4,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                 => ! [V47f5: $i] :
                                      ( mem(V47f5,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                     => ! [V48f6: $i] :
                                          ( mem(V48f6,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                         => ( ap(ap(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efp__op__CASE(A_27a,A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V39a0)),V40a1),V41a2)),V42f),V43f1),V44f2),V45f3),V46f4),V47f5),V48f6) = ap(ap(ap(V46f4,inj__ty_2Ebinary__ieee_2Erounding(V39a0)),V40a1),V41a2) ) ) ) ) ) ) ) ) ) )
      & ! [V49a0: tp__ty_2Ebinary__ieee_2Erounding,V50a1: $i] :
          ( mem(V50a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V51a2: $i] :
              ( mem(V51a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V52a3: $i] :
                  ( mem(V52a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V53f: $i] :
                      ( mem(V53f,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))
                     => ! [V54f1: $i] :
                          ( mem(V54f1,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                         => ! [V55f2: $i] :
                              ( mem(V55f2,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                             => ! [V56f3: $i] :
                                  ( mem(V56f3,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                 => ! [V57f4: $i] :
                                      ( mem(V57f4,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                     => ! [V58f5: $i] :
                                          ( mem(V58f5,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                         => ! [V59f6: $i] :
                                              ( mem(V59f6,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                             => ( ap(ap(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efp__op__CASE(A_27a,A_27t,A_27w),ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V49a0)),V50a1),V51a2),V52a3)),V53f),V54f1),V55f2),V56f3),V57f4),V58f5),V59f6) = ap(ap(ap(ap(V58f5,inj__ty_2Ebinary__ieee_2Erounding(V49a0)),V50a1),V51a2),V52a3) ) ) ) ) ) ) ) ) ) ) )
      & ! [V60a0: tp__ty_2Ebinary__ieee_2Erounding,V61a1: $i] :
          ( mem(V61a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V62a2: $i] :
              ( mem(V62a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V63a3: $i] :
                  ( mem(V63a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V64f: $i] :
                      ( mem(V64f,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))
                     => ! [V65f1: $i] :
                          ( mem(V65f1,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                         => ! [V66f2: $i] :
                              ( mem(V66f2,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                             => ! [V67f3: $i] :
                                  ( mem(V67f3,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                 => ! [V68f4: $i] :
                                      ( mem(V68f4,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                     => ! [V69f5: $i] :
                                          ( mem(V69f5,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                         => ! [V70f6: $i] :
                                              ( mem(V70f6,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                             => ( ap(ap(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efp__op__CASE(A_27a,A_27t,A_27w),ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V60a0)),V61a1),V62a2),V63a3)),V64f),V65f1),V66f2),V67f3),V68f4),V69f5),V70f6) = ap(ap(ap(ap(V70f6,inj__ty_2Ebinary__ieee_2Erounding(V60a0)),V61a1),V62a2),V63a3) ) ) ) ) ) ) ) ) ) ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efp__op__size__def,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ! [V0f: $i] :
          ( mem(V0f,arr(A_27t,ty_2Enum_2Enum))
         => ! [V1f1: $i] :
              ( mem(V1f1,arr(A_27w,ty_2Enum_2Enum))
             => ! [V2a0: tp__ty_2Ebinary__ieee_2Erounding,V3a1: $i] :
                  ( mem(V3a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ( surj__ty_2Enum_2Enum(ap(ap(ap(c_2Ebinary__ieee_2Efp__op__size(A_27t,A_27w),V0f),V1f1),ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V2a0)),V3a1))) = surj__ty_2Enum_2Enum(ap(ap(c_2Earithmetic_2E_2B,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))),ap(ap(c_2Earithmetic_2E_2B,ap(c_2Ebinary__ieee_2Erounding__size,inj__ty_2Ebinary__ieee_2Erounding(V2a0))),ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V0f),V1f1),V3a1)))) ) ) ) )
      & ! [V4f: $i] :
          ( mem(V4f,arr(A_27t,ty_2Enum_2Enum))
         => ! [V5f1: $i] :
              ( mem(V5f1,arr(A_27w,ty_2Enum_2Enum))
             => ! [V6a0: tp__ty_2Ebinary__ieee_2Erounding,V7a1: $i] :
                  ( mem(V7a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V8a2: $i] :
                      ( mem(V8a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ( surj__ty_2Enum_2Enum(ap(ap(ap(c_2Ebinary__ieee_2Efp__op__size(A_27t,A_27w),V4f),V5f1),ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V6a0)),V7a1),V8a2))) = surj__ty_2Enum_2Enum(ap(ap(c_2Earithmetic_2E_2B,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))),ap(ap(c_2Earithmetic_2E_2B,ap(c_2Ebinary__ieee_2Erounding__size,inj__ty_2Ebinary__ieee_2Erounding(V6a0))),ap(ap(c_2Earithmetic_2E_2B,ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V4f),V5f1),V7a1)),ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V4f),V5f1),V8a2))))) ) ) ) ) )
      & ! [V9f: $i] :
          ( mem(V9f,arr(A_27t,ty_2Enum_2Enum))
         => ! [V10f1: $i] :
              ( mem(V10f1,arr(A_27w,ty_2Enum_2Enum))
             => ! [V11a0: tp__ty_2Ebinary__ieee_2Erounding,V12a1: $i] :
                  ( mem(V12a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V13a2: $i] :
                      ( mem(V13a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ( surj__ty_2Enum_2Enum(ap(ap(ap(c_2Ebinary__ieee_2Efp__op__size(A_27t,A_27w),V9f),V10f1),ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V11a0)),V12a1),V13a2))) = surj__ty_2Enum_2Enum(ap(ap(c_2Earithmetic_2E_2B,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))),ap(ap(c_2Earithmetic_2E_2B,ap(c_2Ebinary__ieee_2Erounding__size,inj__ty_2Ebinary__ieee_2Erounding(V11a0))),ap(ap(c_2Earithmetic_2E_2B,ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V9f),V10f1),V12a1)),ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V9f),V10f1),V13a2))))) ) ) ) ) )
      & ! [V14f: $i] :
          ( mem(V14f,arr(A_27t,ty_2Enum_2Enum))
         => ! [V15f1: $i] :
              ( mem(V15f1,arr(A_27w,ty_2Enum_2Enum))
             => ! [V16a0: tp__ty_2Ebinary__ieee_2Erounding,V17a1: $i] :
                  ( mem(V17a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V18a2: $i] :
                      ( mem(V18a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ( surj__ty_2Enum_2Enum(ap(ap(ap(c_2Ebinary__ieee_2Efp__op__size(A_27t,A_27w),V14f),V15f1),ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V16a0)),V17a1),V18a2))) = surj__ty_2Enum_2Enum(ap(ap(c_2Earithmetic_2E_2B,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))),ap(ap(c_2Earithmetic_2E_2B,ap(c_2Ebinary__ieee_2Erounding__size,inj__ty_2Ebinary__ieee_2Erounding(V16a0))),ap(ap(c_2Earithmetic_2E_2B,ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V14f),V15f1),V17a1)),ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V14f),V15f1),V18a2))))) ) ) ) ) )
      & ! [V19f: $i] :
          ( mem(V19f,arr(A_27t,ty_2Enum_2Enum))
         => ! [V20f1: $i] :
              ( mem(V20f1,arr(A_27w,ty_2Enum_2Enum))
             => ! [V21a0: tp__ty_2Ebinary__ieee_2Erounding,V22a1: $i] :
                  ( mem(V22a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V23a2: $i] :
                      ( mem(V23a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ( surj__ty_2Enum_2Enum(ap(ap(ap(c_2Ebinary__ieee_2Efp__op__size(A_27t,A_27w),V19f),V20f1),ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V21a0)),V22a1),V23a2))) = surj__ty_2Enum_2Enum(ap(ap(c_2Earithmetic_2E_2B,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))),ap(ap(c_2Earithmetic_2E_2B,ap(c_2Ebinary__ieee_2Erounding__size,inj__ty_2Ebinary__ieee_2Erounding(V21a0))),ap(ap(c_2Earithmetic_2E_2B,ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V19f),V20f1),V22a1)),ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V19f),V20f1),V23a2))))) ) ) ) ) )
      & ! [V24f: $i] :
          ( mem(V24f,arr(A_27t,ty_2Enum_2Enum))
         => ! [V25f1: $i] :
              ( mem(V25f1,arr(A_27w,ty_2Enum_2Enum))
             => ! [V26a0: tp__ty_2Ebinary__ieee_2Erounding,V27a1: $i] :
                  ( mem(V27a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V28a2: $i] :
                      ( mem(V28a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ! [V29a3: $i] :
                          ( mem(V29a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                         => ( surj__ty_2Enum_2Enum(ap(ap(ap(c_2Ebinary__ieee_2Efp__op__size(A_27t,A_27w),V24f),V25f1),ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V26a0)),V27a1),V28a2),V29a3))) = surj__ty_2Enum_2Enum(ap(ap(c_2Earithmetic_2E_2B,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))),ap(ap(c_2Earithmetic_2E_2B,ap(c_2Ebinary__ieee_2Erounding__size,inj__ty_2Ebinary__ieee_2Erounding(V26a0))),ap(ap(c_2Earithmetic_2E_2B,ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V24f),V25f1),V27a1)),ap(ap(c_2Earithmetic_2E_2B,ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V24f),V25f1),V28a2)),ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V24f),V25f1),V29a3)))))) ) ) ) ) ) )
      & ! [V30f: $i] :
          ( mem(V30f,arr(A_27t,ty_2Enum_2Enum))
         => ! [V31f1: $i] :
              ( mem(V31f1,arr(A_27w,ty_2Enum_2Enum))
             => ! [V32a0: tp__ty_2Ebinary__ieee_2Erounding,V33a1: $i] :
                  ( mem(V33a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V34a2: $i] :
                      ( mem(V34a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ! [V35a3: $i] :
                          ( mem(V35a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                         => ( surj__ty_2Enum_2Enum(ap(ap(ap(c_2Ebinary__ieee_2Efp__op__size(A_27t,A_27w),V30f),V31f1),ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V32a0)),V33a1),V34a2),V35a3))) = surj__ty_2Enum_2Enum(ap(ap(c_2Earithmetic_2E_2B,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))),ap(ap(c_2Earithmetic_2E_2B,ap(c_2Ebinary__ieee_2Erounding__size,inj__ty_2Ebinary__ieee_2Erounding(V32a0))),ap(ap(c_2Earithmetic_2E_2B,ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V30f),V31f1),V33a1)),ap(ap(c_2Earithmetic_2E_2B,ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V30f),V31f1),V34a2)),ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V30f),V31f1),V35a3)))))) ) ) ) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Edatatype__fp__op,axiom,
    ! [A_27t: del,A_27w: del,V0fp__op: $i] :
      ( mem(V0fp__op,arr(arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))),arr(arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w)))),arr(arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w)))),arr(arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w)))),arr(arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w)))),arr(arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))))),arr(arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))))),bool))))))))
     => p(ap(c_2Ebool_2EDATATYPE(bool),ap(ap(ap(ap(ap(ap(ap(V0fp__op,c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w)),c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w)),c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w)),c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w)),c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w)),c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w)),c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w)))) ) ).

tff(conj_thm_2Ebinary__ieee_2Efp__op__11,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ! [V0a0: tp__ty_2Ebinary__ieee_2Erounding,V1a1: $i] :
          ( mem(V1a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V2a0_27: tp__ty_2Ebinary__ieee_2Erounding,V3a1_27: $i] :
              ( mem(V3a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ( ( ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0a0)),V1a1) = ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V2a0_27)),V3a1_27) )
              <=> ( ( V0a0 = V2a0_27 )
                  & ( V1a1 = V3a1_27 ) ) ) ) )
      & ! [V4a0: tp__ty_2Ebinary__ieee_2Erounding,V5a1: $i] :
          ( mem(V5a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V6a2: $i] :
              ( mem(V6a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V7a0_27: tp__ty_2Ebinary__ieee_2Erounding,V8a1_27: $i] :
                  ( mem(V8a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V9a2_27: $i] :
                      ( mem(V9a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ( ( ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V4a0)),V5a1),V6a2) = ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V7a0_27)),V8a1_27),V9a2_27) )
                      <=> ( ( V4a0 = V7a0_27 )
                          & ( V5a1 = V8a1_27 )
                          & ( V6a2 = V9a2_27 ) ) ) ) ) ) )
      & ! [V10a0: tp__ty_2Ebinary__ieee_2Erounding,V11a1: $i] :
          ( mem(V11a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V12a2: $i] :
              ( mem(V12a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V13a0_27: tp__ty_2Ebinary__ieee_2Erounding,V14a1_27: $i] :
                  ( mem(V14a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V15a2_27: $i] :
                      ( mem(V15a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ( ( ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V10a0)),V11a1),V12a2) = ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V13a0_27)),V14a1_27),V15a2_27) )
                      <=> ( ( V10a0 = V13a0_27 )
                          & ( V11a1 = V14a1_27 )
                          & ( V12a2 = V15a2_27 ) ) ) ) ) ) )
      & ! [V16a0: tp__ty_2Ebinary__ieee_2Erounding,V17a1: $i] :
          ( mem(V17a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V18a2: $i] :
              ( mem(V18a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V19a0_27: tp__ty_2Ebinary__ieee_2Erounding,V20a1_27: $i] :
                  ( mem(V20a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V21a2_27: $i] :
                      ( mem(V21a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ( ( ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V16a0)),V17a1),V18a2) = ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V19a0_27)),V20a1_27),V21a2_27) )
                      <=> ( ( V16a0 = V19a0_27 )
                          & ( V17a1 = V20a1_27 )
                          & ( V18a2 = V21a2_27 ) ) ) ) ) ) )
      & ! [V22a0: tp__ty_2Ebinary__ieee_2Erounding,V23a1: $i] :
          ( mem(V23a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V24a2: $i] :
              ( mem(V24a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V25a0_27: tp__ty_2Ebinary__ieee_2Erounding,V26a1_27: $i] :
                  ( mem(V26a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V27a2_27: $i] :
                      ( mem(V27a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ( ( ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V22a0)),V23a1),V24a2) = ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V25a0_27)),V26a1_27),V27a2_27) )
                      <=> ( ( V22a0 = V25a0_27 )
                          & ( V23a1 = V26a1_27 )
                          & ( V24a2 = V27a2_27 ) ) ) ) ) ) )
      & ! [V28a0: tp__ty_2Ebinary__ieee_2Erounding,V29a1: $i] :
          ( mem(V29a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V30a2: $i] :
              ( mem(V30a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V31a3: $i] :
                  ( mem(V31a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V32a0_27: tp__ty_2Ebinary__ieee_2Erounding,V33a1_27: $i] :
                      ( mem(V33a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ! [V34a2_27: $i] :
                          ( mem(V34a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                         => ! [V35a3_27: $i] :
                              ( mem(V35a3_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                             => ( ( ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V28a0)),V29a1),V30a2),V31a3) = ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V32a0_27)),V33a1_27),V34a2_27),V35a3_27) )
                              <=> ( ( V28a0 = V32a0_27 )
                                  & ( V29a1 = V33a1_27 )
                                  & ( V30a2 = V34a2_27 )
                                  & ( V31a3 = V35a3_27 ) ) ) ) ) ) ) ) )
      & ! [V36a0: tp__ty_2Ebinary__ieee_2Erounding,V37a1: $i] :
          ( mem(V37a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V38a2: $i] :
              ( mem(V38a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V39a3: $i] :
                  ( mem(V39a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V40a0_27: tp__ty_2Ebinary__ieee_2Erounding,V41a1_27: $i] :
                      ( mem(V41a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ! [V42a2_27: $i] :
                          ( mem(V42a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                         => ! [V43a3_27: $i] :
                              ( mem(V43a3_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                             => ( ( ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V36a0)),V37a1),V38a2),V39a3) = ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V40a0_27)),V41a1_27),V42a2_27),V43a3_27) )
                              <=> ( ( V36a0 = V40a0_27 )
                                  & ( V37a1 = V41a1_27 )
                                  & ( V38a2 = V42a2_27 )
                                  & ( V39a3 = V43a3_27 ) ) ) ) ) ) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efp__op__distinct,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ! [V0a2: $i] :
          ( mem(V0a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V1a1_27: $i] :
              ( mem(V1a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V2a1: $i] :
                  ( mem(V2a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V3a0_27: tp__ty_2Ebinary__ieee_2Erounding,V4a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V4a0)),V2a1) != ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V3a0_27)),V1a1_27),V0a2) ) ) ) )
      & ! [V5a2: $i] :
          ( mem(V5a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V6a1_27: $i] :
              ( mem(V6a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V7a1: $i] :
                  ( mem(V7a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V8a0_27: tp__ty_2Ebinary__ieee_2Erounding,V9a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V9a0)),V7a1) != ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V8a0_27)),V6a1_27),V5a2) ) ) ) )
      & ! [V10a2: $i] :
          ( mem(V10a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V11a1_27: $i] :
              ( mem(V11a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V12a1: $i] :
                  ( mem(V12a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V13a0_27: tp__ty_2Ebinary__ieee_2Erounding,V14a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V14a0)),V12a1) != ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V13a0_27)),V11a1_27),V10a2) ) ) ) )
      & ! [V15a2: $i] :
          ( mem(V15a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V16a1_27: $i] :
              ( mem(V16a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V17a1: $i] :
                  ( mem(V17a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V18a0_27: tp__ty_2Ebinary__ieee_2Erounding,V19a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V19a0)),V17a1) != ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V18a0_27)),V16a1_27),V15a2) ) ) ) )
      & ! [V20a3: $i] :
          ( mem(V20a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V21a2: $i] :
              ( mem(V21a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V22a1_27: $i] :
                  ( mem(V22a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V23a1: $i] :
                      ( mem(V23a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ! [V24a0_27: tp__ty_2Ebinary__ieee_2Erounding,V25a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V25a0)),V23a1) != ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V24a0_27)),V22a1_27),V21a2),V20a3) ) ) ) ) )
      & ! [V26a3: $i] :
          ( mem(V26a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V27a2: $i] :
              ( mem(V27a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V28a1_27: $i] :
                  ( mem(V28a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V29a1: $i] :
                      ( mem(V29a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ! [V30a0_27: tp__ty_2Ebinary__ieee_2Erounding,V31a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V31a0)),V29a1) != ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V30a0_27)),V28a1_27),V27a2),V26a3) ) ) ) ) )
      & ! [V32a2_27: $i] :
          ( mem(V32a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V33a2: $i] :
              ( mem(V33a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V34a1_27: $i] :
                  ( mem(V34a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V35a1: $i] :
                      ( mem(V35a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ! [V36a0_27: tp__ty_2Ebinary__ieee_2Erounding,V37a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V37a0)),V35a1),V33a2) != ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V36a0_27)),V34a1_27),V32a2_27) ) ) ) ) )
      & ! [V38a2_27: $i] :
          ( mem(V38a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V39a2: $i] :
              ( mem(V39a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V40a1_27: $i] :
                  ( mem(V40a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V41a1: $i] :
                      ( mem(V41a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ! [V42a0_27: tp__ty_2Ebinary__ieee_2Erounding,V43a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V43a0)),V41a1),V39a2) != ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V42a0_27)),V40a1_27),V38a2_27) ) ) ) ) )
      & ! [V44a2_27: $i] :
          ( mem(V44a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V45a2: $i] :
              ( mem(V45a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V46a1_27: $i] :
                  ( mem(V46a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V47a1: $i] :
                      ( mem(V47a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ! [V48a0_27: tp__ty_2Ebinary__ieee_2Erounding,V49a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V49a0)),V47a1),V45a2) != ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V48a0_27)),V46a1_27),V44a2_27) ) ) ) ) )
      & ! [V50a3: $i] :
          ( mem(V50a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V51a2_27: $i] :
              ( mem(V51a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V52a2: $i] :
                  ( mem(V52a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V53a1_27: $i] :
                      ( mem(V53a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ! [V54a1: $i] :
                          ( mem(V54a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                         => ! [V55a0_27: tp__ty_2Ebinary__ieee_2Erounding,V56a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V56a0)),V54a1),V52a2) != ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V55a0_27)),V53a1_27),V51a2_27),V50a3) ) ) ) ) ) )
      & ! [V57a3: $i] :
          ( mem(V57a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V58a2_27: $i] :
              ( mem(V58a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V59a2: $i] :
                  ( mem(V59a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V60a1_27: $i] :
                      ( mem(V60a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ! [V61a1: $i] :
                          ( mem(V61a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                         => ! [V62a0_27: tp__ty_2Ebinary__ieee_2Erounding,V63a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V63a0)),V61a1),V59a2) != ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V62a0_27)),V60a1_27),V58a2_27),V57a3) ) ) ) ) ) )
      & ! [V64a2_27: $i] :
          ( mem(V64a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V65a2: $i] :
              ( mem(V65a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V66a1_27: $i] :
                  ( mem(V66a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V67a1: $i] :
                      ( mem(V67a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ! [V68a0_27: tp__ty_2Ebinary__ieee_2Erounding,V69a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V69a0)),V67a1),V65a2) != ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V68a0_27)),V66a1_27),V64a2_27) ) ) ) ) )
      & ! [V70a2_27: $i] :
          ( mem(V70a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V71a2: $i] :
              ( mem(V71a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V72a1_27: $i] :
                  ( mem(V72a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V73a1: $i] :
                      ( mem(V73a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ! [V74a0_27: tp__ty_2Ebinary__ieee_2Erounding,V75a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V75a0)),V73a1),V71a2) != ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V74a0_27)),V72a1_27),V70a2_27) ) ) ) ) )
      & ! [V76a3: $i] :
          ( mem(V76a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V77a2_27: $i] :
              ( mem(V77a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V78a2: $i] :
                  ( mem(V78a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V79a1_27: $i] :
                      ( mem(V79a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ! [V80a1: $i] :
                          ( mem(V80a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                         => ! [V81a0_27: tp__ty_2Ebinary__ieee_2Erounding,V82a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V82a0)),V80a1),V78a2) != ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V81a0_27)),V79a1_27),V77a2_27),V76a3) ) ) ) ) ) )
      & ! [V83a3: $i] :
          ( mem(V83a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V84a2_27: $i] :
              ( mem(V84a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V85a2: $i] :
                  ( mem(V85a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V86a1_27: $i] :
                      ( mem(V86a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ! [V87a1: $i] :
                          ( mem(V87a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                         => ! [V88a0_27: tp__ty_2Ebinary__ieee_2Erounding,V89a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V89a0)),V87a1),V85a2) != ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V88a0_27)),V86a1_27),V84a2_27),V83a3) ) ) ) ) ) )
      & ! [V90a2_27: $i] :
          ( mem(V90a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V91a2: $i] :
              ( mem(V91a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V92a1_27: $i] :
                  ( mem(V92a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V93a1: $i] :
                      ( mem(V93a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ! [V94a0_27: tp__ty_2Ebinary__ieee_2Erounding,V95a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V95a0)),V93a1),V91a2) != ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V94a0_27)),V92a1_27),V90a2_27) ) ) ) ) )
      & ! [V96a3: $i] :
          ( mem(V96a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V97a2_27: $i] :
              ( mem(V97a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V98a2: $i] :
                  ( mem(V98a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V99a1_27: $i] :
                      ( mem(V99a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ! [V100a1: $i] :
                          ( mem(V100a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                         => ! [V101a0_27: tp__ty_2Ebinary__ieee_2Erounding,V102a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V102a0)),V100a1),V98a2) != ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V101a0_27)),V99a1_27),V97a2_27),V96a3) ) ) ) ) ) )
      & ! [V103a3: $i] :
          ( mem(V103a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V104a2_27: $i] :
              ( mem(V104a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V105a2: $i] :
                  ( mem(V105a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V106a1_27: $i] :
                      ( mem(V106a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ! [V107a1: $i] :
                          ( mem(V107a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                         => ! [V108a0_27: tp__ty_2Ebinary__ieee_2Erounding,V109a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V109a0)),V107a1),V105a2) != ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V108a0_27)),V106a1_27),V104a2_27),V103a3) ) ) ) ) ) )
      & ! [V110a3: $i] :
          ( mem(V110a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V111a2_27: $i] :
              ( mem(V111a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V112a2: $i] :
                  ( mem(V112a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V113a1_27: $i] :
                      ( mem(V113a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ! [V114a1: $i] :
                          ( mem(V114a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                         => ! [V115a0_27: tp__ty_2Ebinary__ieee_2Erounding,V116a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V116a0)),V114a1),V112a2) != ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V115a0_27)),V113a1_27),V111a2_27),V110a3) ) ) ) ) ) )
      & ! [V117a3: $i] :
          ( mem(V117a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V118a2_27: $i] :
              ( mem(V118a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V119a2: $i] :
                  ( mem(V119a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V120a1_27: $i] :
                      ( mem(V120a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ! [V121a1: $i] :
                          ( mem(V121a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                         => ! [V122a0_27: tp__ty_2Ebinary__ieee_2Erounding,V123a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V123a0)),V121a1),V119a2) != ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V122a0_27)),V120a1_27),V118a2_27),V117a3) ) ) ) ) ) )
      & ! [V124a3_27: $i] :
          ( mem(V124a3_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V125a3: $i] :
              ( mem(V125a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V126a2_27: $i] :
                  ( mem(V126a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V127a2: $i] :
                      ( mem(V127a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ! [V128a1_27: $i] :
                          ( mem(V128a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                         => ! [V129a1: $i] :
                              ( mem(V129a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                             => ! [V130a0_27: tp__ty_2Ebinary__ieee_2Erounding,V131a0: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V131a0)),V129a1),V127a2),V125a3) != ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V130a0_27)),V128a1_27),V126a2_27),V124a3_27) ) ) ) ) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efp__op__nchotomy,axiom,
    ! [A_27t: del,A_27w: del,V0ff: $i] :
      ( mem(V0ff,ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))
     => ( ? [V1r: tp__ty_2Ebinary__ieee_2Erounding,V2f: $i] :
            ( mem(V2f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
            & ( V0ff = ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V1r)),V2f) ) )
        | ? [V3r: tp__ty_2Ebinary__ieee_2Erounding,V4f: $i] :
            ( mem(V4f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
            & ? [V5f0: $i] :
                ( mem(V5f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                & ( V0ff = ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V3r)),V4f),V5f0) ) ) )
        | ? [V6r: tp__ty_2Ebinary__ieee_2Erounding,V7f: $i] :
            ( mem(V7f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
            & ? [V8f0: $i] :
                ( mem(V8f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                & ( V0ff = ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V6r)),V7f),V8f0) ) ) )
        | ? [V9r: tp__ty_2Ebinary__ieee_2Erounding,V10f: $i] :
            ( mem(V10f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
            & ? [V11f0: $i] :
                ( mem(V11f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                & ( V0ff = ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V9r)),V10f),V11f0) ) ) )
        | ? [V12r: tp__ty_2Ebinary__ieee_2Erounding,V13f: $i] :
            ( mem(V13f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
            & ? [V14f0: $i] :
                ( mem(V14f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                & ( V0ff = ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V12r)),V13f),V14f0) ) ) )
        | ? [V15r: tp__ty_2Ebinary__ieee_2Erounding,V16f: $i] :
            ( mem(V16f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
            & ? [V17f0: $i] :
                ( mem(V17f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                & ? [V18f1: $i] :
                    ( mem(V18f1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                    & ( V0ff = ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V15r)),V16f),V17f0),V18f1) ) ) ) )
        | ? [V19r: tp__ty_2Ebinary__ieee_2Erounding,V20f: $i] :
            ( mem(V20f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
            & ? [V21f0: $i] :
                ( mem(V21f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                & ? [V22f1: $i] :
                    ( mem(V22f1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                    & ( V0ff = ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V19r)),V20f),V21f0),V22f1) ) ) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efp__op__Axiom,axiom,
    ! [A_27a: del,A_27t: del,A_27w: del,V0f0: $i] :
      ( mem(V0f0,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))
     => ! [V1f1: $i] :
          ( mem(V1f1,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
         => ! [V2f2: $i] :
              ( mem(V2f2,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
             => ! [V3f3: $i] :
                  ( mem(V3f3,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                 => ! [V4f4: $i] :
                      ( mem(V4f4,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                     => ! [V5f5: $i] :
                          ( mem(V5f5,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                         => ! [V6f6: $i] :
                              ( mem(V6f6,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                             => ? [V7fn: $i] :
                                  ( mem(V7fn,arr(ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w),A_27a))
                                  & ! [V8a0: tp__ty_2Ebinary__ieee_2Erounding,V9a1: $i] :
                                      ( mem(V9a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                     => ( ap(V7fn,ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V8a0)),V9a1)) = ap(ap(V0f0,inj__ty_2Ebinary__ieee_2Erounding(V8a0)),V9a1) ) )
                                  & ! [V10a0: tp__ty_2Ebinary__ieee_2Erounding,V11a1: $i] :
                                      ( mem(V11a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                     => ! [V12a2: $i] :
                                          ( mem(V12a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                         => ( ap(V7fn,ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V10a0)),V11a1),V12a2)) = ap(ap(ap(V1f1,inj__ty_2Ebinary__ieee_2Erounding(V10a0)),V11a1),V12a2) ) ) )
                                  & ! [V13a0: tp__ty_2Ebinary__ieee_2Erounding,V14a1: $i] :
                                      ( mem(V14a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                     => ! [V15a2: $i] :
                                          ( mem(V15a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                         => ( ap(V7fn,ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V13a0)),V14a1),V15a2)) = ap(ap(ap(V2f2,inj__ty_2Ebinary__ieee_2Erounding(V13a0)),V14a1),V15a2) ) ) )
                                  & ! [V16a0: tp__ty_2Ebinary__ieee_2Erounding,V17a1: $i] :
                                      ( mem(V17a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                     => ! [V18a2: $i] :
                                          ( mem(V18a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                         => ( ap(V7fn,ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V16a0)),V17a1),V18a2)) = ap(ap(ap(V3f3,inj__ty_2Ebinary__ieee_2Erounding(V16a0)),V17a1),V18a2) ) ) )
                                  & ! [V19a0: tp__ty_2Ebinary__ieee_2Erounding,V20a1: $i] :
                                      ( mem(V20a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                     => ! [V21a2: $i] :
                                          ( mem(V21a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                         => ( ap(V7fn,ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V19a0)),V20a1),V21a2)) = ap(ap(ap(V4f4,inj__ty_2Ebinary__ieee_2Erounding(V19a0)),V20a1),V21a2) ) ) )
                                  & ! [V22a0: tp__ty_2Ebinary__ieee_2Erounding,V23a1: $i] :
                                      ( mem(V23a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                     => ! [V24a2: $i] :
                                          ( mem(V24a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                         => ! [V25a3: $i] :
                                              ( mem(V25a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                             => ( ap(V7fn,ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V22a0)),V23a1),V24a2),V25a3)) = ap(ap(ap(ap(V5f5,inj__ty_2Ebinary__ieee_2Erounding(V22a0)),V23a1),V24a2),V25a3) ) ) ) )
                                  & ! [V26a0: tp__ty_2Ebinary__ieee_2Erounding,V27a1: $i] :
                                      ( mem(V27a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                     => ! [V28a2: $i] :
                                          ( mem(V28a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                         => ! [V29a3: $i] :
                                              ( mem(V29a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                             => ( ap(V7fn,ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V26a0)),V27a1),V28a2),V29a3)) = ap(ap(ap(ap(V6f6,inj__ty_2Ebinary__ieee_2Erounding(V26a0)),V27a1),V28a2),V29a3) ) ) ) ) ) ) ) ) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efp__op__induction,axiom,
    ! [A_27t: del,A_27w: del,V0P: $i] :
      ( mem(V0P,arr(ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w),bool))
     => ( ( ! [V1r: tp__ty_2Ebinary__ieee_2Erounding,V2f: $i] :
              ( mem(V2f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => p(ap(V0P,ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V1r)),V2f))) )
          & ! [V3r: tp__ty_2Ebinary__ieee_2Erounding,V4f: $i] :
              ( mem(V4f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V5f0: $i] :
                  ( mem(V5f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => p(ap(V0P,ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V3r)),V4f),V5f0))) ) )
          & ! [V6r: tp__ty_2Ebinary__ieee_2Erounding,V7f: $i] :
              ( mem(V7f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V8f0: $i] :
                  ( mem(V8f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => p(ap(V0P,ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V6r)),V7f),V8f0))) ) )
          & ! [V9r: tp__ty_2Ebinary__ieee_2Erounding,V10f: $i] :
              ( mem(V10f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V11f0: $i] :
                  ( mem(V11f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => p(ap(V0P,ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V9r)),V10f),V11f0))) ) )
          & ! [V12r: tp__ty_2Ebinary__ieee_2Erounding,V13f: $i] :
              ( mem(V13f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V14f0: $i] :
                  ( mem(V14f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => p(ap(V0P,ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V12r)),V13f),V14f0))) ) )
          & ! [V15r: tp__ty_2Ebinary__ieee_2Erounding,V16f: $i] :
              ( mem(V16f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V17f0: $i] :
                  ( mem(V17f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V18f1: $i] :
                      ( mem(V18f1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => p(ap(V0P,ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V15r)),V16f),V17f0),V18f1))) ) ) )
          & ! [V19r: tp__ty_2Ebinary__ieee_2Erounding,V20f: $i] :
              ( mem(V20f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V21f0: $i] :
                  ( mem(V21f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V22f1: $i] :
                      ( mem(V22f1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => p(ap(V0P,ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V19r)),V20f),V21f0),V22f1))) ) ) ) )
       => ! [V23f: $i] :
            ( mem(V23f,ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))
           => p(ap(V0P,V23f)) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efp__op__case__cong,axiom,
    ! [A_27a: del,A_27t: del,A_27w: del,V0f_27: $i] :
      ( mem(V0f_27,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))
     => ! [V1f1_27: $i] :
          ( mem(V1f1_27,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
         => ! [V2f2_27: $i] :
              ( mem(V2f2_27,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
             => ! [V3f3_27: $i] :
                  ( mem(V3f3_27,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                 => ! [V4f4_27: $i] :
                      ( mem(V4f4_27,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                     => ! [V5f5_27: $i] :
                          ( mem(V5f5_27,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                         => ! [V6f6_27: $i] :
                              ( mem(V6f6_27,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                             => ! [V7M: $i] :
                                  ( mem(V7M,ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))
                                 => ! [V8M_27: $i] :
                                      ( mem(V8M_27,ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))
                                     => ! [V9f: $i] :
                                          ( mem(V9f,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))
                                         => ! [V10f1: $i] :
                                              ( mem(V10f1,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                             => ! [V11f2: $i] :
                                                  ( mem(V11f2,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                                 => ! [V12f3: $i] :
                                                      ( mem(V12f3,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                                     => ! [V13f4: $i] :
                                                          ( mem(V13f4,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                                         => ! [V14f5: $i] :
                                                              ( mem(V14f5,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                                             => ! [V15f6: $i] :
                                                                  ( mem(V15f6,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                                                 => ( ( ( V7M = V8M_27 )
                                                                      & ! [V16a0: tp__ty_2Ebinary__ieee_2Erounding,V17a1: $i] :
                                                                          ( mem(V17a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                         => ( ( V8M_27 = ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V16a0)),V17a1) )
                                                                           => ( ap(ap(V9f,inj__ty_2Ebinary__ieee_2Erounding(V16a0)),V17a1) = ap(ap(V0f_27,inj__ty_2Ebinary__ieee_2Erounding(V16a0)),V17a1) ) ) )
                                                                      & ! [V18a0: tp__ty_2Ebinary__ieee_2Erounding,V19a1: $i] :
                                                                          ( mem(V19a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                         => ! [V20a2: $i] :
                                                                              ( mem(V20a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                             => ( ( V8M_27 = ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V18a0)),V19a1),V20a2) )
                                                                               => ( ap(ap(ap(V10f1,inj__ty_2Ebinary__ieee_2Erounding(V18a0)),V19a1),V20a2) = ap(ap(ap(V1f1_27,inj__ty_2Ebinary__ieee_2Erounding(V18a0)),V19a1),V20a2) ) ) ) )
                                                                      & ! [V21a0: tp__ty_2Ebinary__ieee_2Erounding,V22a1: $i] :
                                                                          ( mem(V22a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                         => ! [V23a2: $i] :
                                                                              ( mem(V23a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                             => ( ( V8M_27 = ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V21a0)),V22a1),V23a2) )
                                                                               => ( ap(ap(ap(V11f2,inj__ty_2Ebinary__ieee_2Erounding(V21a0)),V22a1),V23a2) = ap(ap(ap(V2f2_27,inj__ty_2Ebinary__ieee_2Erounding(V21a0)),V22a1),V23a2) ) ) ) )
                                                                      & ! [V24a0: tp__ty_2Ebinary__ieee_2Erounding,V25a1: $i] :
                                                                          ( mem(V25a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                         => ! [V26a2: $i] :
                                                                              ( mem(V26a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                             => ( ( V8M_27 = ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V24a0)),V25a1),V26a2) )
                                                                               => ( ap(ap(ap(V12f3,inj__ty_2Ebinary__ieee_2Erounding(V24a0)),V25a1),V26a2) = ap(ap(ap(V3f3_27,inj__ty_2Ebinary__ieee_2Erounding(V24a0)),V25a1),V26a2) ) ) ) )
                                                                      & ! [V27a0: tp__ty_2Ebinary__ieee_2Erounding,V28a1: $i] :
                                                                          ( mem(V28a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                         => ! [V29a2: $i] :
                                                                              ( mem(V29a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                             => ( ( V8M_27 = ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V27a0)),V28a1),V29a2) )
                                                                               => ( ap(ap(ap(V13f4,inj__ty_2Ebinary__ieee_2Erounding(V27a0)),V28a1),V29a2) = ap(ap(ap(V4f4_27,inj__ty_2Ebinary__ieee_2Erounding(V27a0)),V28a1),V29a2) ) ) ) )
                                                                      & ! [V30a0: tp__ty_2Ebinary__ieee_2Erounding,V31a1: $i] :
                                                                          ( mem(V31a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                         => ! [V32a2: $i] :
                                                                              ( mem(V32a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                             => ! [V33a3: $i] :
                                                                                  ( mem(V33a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                                 => ( ( V8M_27 = ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V30a0)),V31a1),V32a2),V33a3) )
                                                                                   => ( ap(ap(ap(ap(V14f5,inj__ty_2Ebinary__ieee_2Erounding(V30a0)),V31a1),V32a2),V33a3) = ap(ap(ap(ap(V5f5_27,inj__ty_2Ebinary__ieee_2Erounding(V30a0)),V31a1),V32a2),V33a3) ) ) ) ) )
                                                                      & ! [V34a0: tp__ty_2Ebinary__ieee_2Erounding,V35a1: $i] :
                                                                          ( mem(V35a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                         => ! [V36a2: $i] :
                                                                              ( mem(V36a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                             => ! [V37a3: $i] :
                                                                                  ( mem(V37a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                                 => ( ( V8M_27 = ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V34a0)),V35a1),V36a2),V37a3) )
                                                                                   => ( ap(ap(ap(ap(V15f6,inj__ty_2Ebinary__ieee_2Erounding(V34a0)),V35a1),V36a2),V37a3) = ap(ap(ap(ap(V6f6_27,inj__ty_2Ebinary__ieee_2Erounding(V34a0)),V35a1),V36a2),V37a3) ) ) ) ) ) )
                                                                   => ( ap(ap(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efp__op__CASE(A_27a,A_27t,A_27w),V7M),V9f),V10f1),V11f2),V12f3),V13f4),V14f5),V15f6) = ap(ap(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efp__op__CASE(A_27a,A_27t,A_27w),V8M_27),V0f_27),V1f1_27),V2f2_27),V3f3_27),V4f4_27),V5f5_27),V6f6_27) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efp__op__case__eq,axiom,
    ! [A_27a: del,A_27t: del,A_27w: del,V0x: $i] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))
     => ! [V1f: $i] :
          ( mem(V1f,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))
         => ! [V2f1: $i] :
              ( mem(V2f1,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
             => ! [V3f2: $i] :
                  ( mem(V3f2,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                 => ! [V4f3: $i] :
                      ( mem(V4f3,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                     => ! [V5f4: $i] :
                          ( mem(V5f4,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                         => ! [V6f5: $i] :
                              ( mem(V6f5,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                             => ! [V7f6: $i] :
                                  ( mem(V7f6,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                 => ! [V8v: $i] :
                                      ( mem(V8v,A_27a)
                                     => ( ( ap(ap(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efp__op__CASE(A_27a,A_27t,A_27w),V0x),V1f),V2f1),V3f2),V4f3),V5f4),V6f5),V7f6) = V8v )
                                      <=> ( ? [V9r: tp__ty_2Ebinary__ieee_2Erounding,V10f_27: $i] :
                                              ( mem(V10f_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                              & ( V0x = ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V9r)),V10f_27) )
                                              & ( ap(ap(V1f,inj__ty_2Ebinary__ieee_2Erounding(V9r)),V10f_27) = V8v ) )
                                          | ? [V11r: tp__ty_2Ebinary__ieee_2Erounding,V12f_27: $i] :
                                              ( mem(V12f_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                              & ? [V13f0: $i] :
                                                  ( mem(V13f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                  & ( V0x = ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V11r)),V12f_27),V13f0) )
                                                  & ( ap(ap(ap(V2f1,inj__ty_2Ebinary__ieee_2Erounding(V11r)),V12f_27),V13f0) = V8v ) ) )
                                          | ? [V14r: tp__ty_2Ebinary__ieee_2Erounding,V15f_27: $i] :
                                              ( mem(V15f_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                              & ? [V16f0: $i] :
                                                  ( mem(V16f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                  & ( V0x = ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V14r)),V15f_27),V16f0) )
                                                  & ( ap(ap(ap(V3f2,inj__ty_2Ebinary__ieee_2Erounding(V14r)),V15f_27),V16f0) = V8v ) ) )
                                          | ? [V17r: tp__ty_2Ebinary__ieee_2Erounding,V18f_27: $i] :
                                              ( mem(V18f_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                              & ? [V19f0: $i] :
                                                  ( mem(V19f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                  & ( V0x = ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V17r)),V18f_27),V19f0) )
                                                  & ( ap(ap(ap(V4f3,inj__ty_2Ebinary__ieee_2Erounding(V17r)),V18f_27),V19f0) = V8v ) ) )
                                          | ? [V20r: tp__ty_2Ebinary__ieee_2Erounding,V21f_27: $i] :
                                              ( mem(V21f_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                              & ? [V22f0: $i] :
                                                  ( mem(V22f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                  & ( V0x = ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V20r)),V21f_27),V22f0) )
                                                  & ( ap(ap(ap(V5f4,inj__ty_2Ebinary__ieee_2Erounding(V20r)),V21f_27),V22f0) = V8v ) ) )
                                          | ? [V23r: tp__ty_2Ebinary__ieee_2Erounding,V24f_27: $i] :
                                              ( mem(V24f_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                              & ? [V25f0: $i] :
                                                  ( mem(V25f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                  & ? [V26f1_27: $i] :
                                                      ( mem(V26f1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                      & ( V0x = ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V23r)),V24f_27),V25f0),V26f1_27) )
                                                      & ( ap(ap(ap(ap(V6f5,inj__ty_2Ebinary__ieee_2Erounding(V23r)),V24f_27),V25f0),V26f1_27) = V8v ) ) ) )
                                          | ? [V27r: tp__ty_2Ebinary__ieee_2Erounding,V28f_27: $i] :
                                              ( mem(V28f_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                              & ? [V29f0: $i] :
                                                  ( mem(V29f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                  & ? [V30f1_27: $i] :
                                                      ( mem(V30f1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                      & ( V0x = ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V27r)),V28f_27),V29f0),V30f1_27) )
                                                      & ( ap(ap(ap(ap(V7f6,inj__ty_2Ebinary__ieee_2Erounding(V27r)),V28f_27),V29f0),V30f1_27) = V8v ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

tff(lamtp_f3020,type,
    f3020: ( del * del ) > $i ).

tff(lameq_f3020,axiom,
    ! [A_27w: del,A_27t: del,V2qnan: $i] : ( ap(f3020(A_27w,A_27t),V2qnan) = ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),V2qnan)),ap(c_2Ebool_2E_7E,ap(c_2Ebinary__ieee_2Efloat__is__signalling(A_27t,A_27w),V2qnan))) ) ).

tff(lamtp_f3021,type,
    f3021: ( del * del * $i ) > $i ).

tff(lameq_f3021,axiom,
    ! [A_27t: del,A_27w: del,V0fp__op: $i] :
      ( mem(V0fp__op,ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))
     => ! [V1f: $i] : ( ap(f3021(A_27t,A_27w,V0fp__op),V1f) = ap(ap(c_2Ebool_2ELET(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool),f3020(A_27w,A_27t)),ap(V1f,V0fp__op)) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__some__qnan__def,axiom,
    ! [A_27t: del,A_27w: del,V0fp__op: $i] :
      ( mem(V0fp__op,ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))
     => ( ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),V0fp__op) = ap(ap(c_2Emin_2E_40(arr(ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),f3021(A_27t,A_27w,V0fp__op)),V0fp__op) ) ) ).

tff(lamtp_f3022,type,
    f3022: ( del * del * tp__o ) > $i ).

tff(lameq_f3022,axiom,
    ! [A_27t: del,A_27w: del,V1toneg: tp__o,V3x: $i] : ( ap(f3022(A_27t,A_27w,V1toneg),V3x) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w),V3x)),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),inj__o(V1toneg)),ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))),V3x) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__round__def,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1toneg: tp__o,V2r: tp__ty_2Erealax_2Ereal] : ( ap(ap(ap(c_2Ebinary__ieee_2Efloat__round(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),inj__o(V1toneg)),inj__ty_2Erealax_2Ereal(V2r)) = ap(ap(c_2Ebool_2ELET(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f3022(A_27t,A_27w,V1toneg)),ap(ap(c_2Ebinary__ieee_2Eround(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),inj__ty_2Erealax_2Ereal(V2r))) ) ).

tff(lamtp_f3023,type,
    f3023: ( del * del * tp__ty_2Erealax_2Ereal * tp__ty_2Ebinary__ieee_2Erounding * tp__o * tp__ty_2Erealax_2Ereal * $i ) > $i ).

tff(lameq_f3023,axiom,
    ! [A_27w: del,A_27t: del,V2r: tp__ty_2Erealax_2Ereal,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1to__neg: tp__o,V4a: tp__ty_2Erealax_2Ereal,V3x: $i] :
      ( mem(V3x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V5inexact: tp__o] : ( ap(f3023(A_27w,A_27t,V2r,V0mode,V1to__neg,V4a,V3x),inj__o(V5inexact)) = ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,ap(c_2Ecombin_2EK(bool,bool),ap(ap(c_2Ebool_2E_5C_2F,ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V3x)),ap(ap(c_2Ereal_2Ereal__lte,ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),ap(c_2Ewords_2EINT__MIN(A_27w),c_2Ebool_2Ethe__value(A_27w)))),inj__ty_2Erealax_2Ereal(V4a))))),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),ap(ap(c_2Ebool_2E_2F_5C,inj__o(V5inexact)),ap(ap(c_2Erealax_2Ereal__lt,inj__ty_2Erealax_2Ereal(V4a)),ap(ap(c_2Ereal_2E_2F,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),ap(c_2Ewords_2EINT__MAX(A_27w),c_2Ebool_2Ethe__value(A_27w)))))))),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),ap(ap(c_2Ebool_2E_2F_5C,inj__o(V5inexact)),ap(ap(c_2Ewords_2Eword__ls(ty_2Esum_2Esum(A_27w,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,ty_2Esum_2Esum(A_27w,ty_2Eone_2Eone)),ap(ap(ap(c_2Ebinary__ieee_2Efloat__round(A_27t,ty_2Esum_2Esum(A_27w,ty_2Eone_2Eone)),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),inj__o(V1to__neg)),inj__ty_2Erealax_2Ereal(V2r)))),ap(c_2Ewords_2En2w(ty_2Esum_2Esum(A_27w,ty_2Eone_2Eone)),ap(c_2Ewords_2EINT__MIN(A_27w),c_2Ebool_2Ethe__value(A_27w))))))),ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,ap(c_2Ecombin_2EK(bool,bool),inj__o(V5inexact))),inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Eclear__flags)))))),V3x) ) ) ).

tff(lamtp_f3024,type,
    f3024: ( del * del * tp__ty_2Ebinary__ieee_2Erounding * tp__o * tp__ty_2Erealax_2Ereal * $i ) > $i ).

tff(lameq_f3024,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1to__neg: tp__o,V2r: tp__ty_2Erealax_2Ereal,V3x: $i] :
      ( mem(V3x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V4a: tp__ty_2Erealax_2Ereal] : ( ap(f3024(A_27t,A_27w,V0mode,V1to__neg,V2r,V3x),inj__ty_2Erealax_2Ereal(V4a)) = ap(ap(c_2Ebool_2ELET(bool,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),f3023(A_27w,A_27t,V2r,V0mode,V1to__neg,V4a,V3x)),ap(c_2Ebool_2E_7E,ap(ap(c_2Emin_2E_3D(ty_2Ebinary__ieee_2Efloat__value),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V3x)),ap(c_2Ebinary__ieee_2EFloat,inj__ty_2Erealax_2Ereal(V2r))))) ) ) ).

tff(lamtp_f3025,type,
    f3025: ( del * del * tp__ty_2Ebinary__ieee_2Erounding * tp__o * tp__ty_2Erealax_2Ereal ) > $i ).

tff(lameq_f3025,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1to__neg: tp__o,V2r: tp__ty_2Erealax_2Ereal,V3x: $i] : ( ap(f3025(A_27t,A_27w,V0mode,V1to__neg,V2r),V3x) = f3024(A_27t,A_27w,V0mode,V1to__neg,V2r,V3x) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__round__with__flags__def,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1to__neg: tp__o,V2r: tp__ty_2Erealax_2Ereal] : ( ap(ap(ap(c_2Ebinary__ieee_2Efloat__round__with__flags(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),inj__o(V1to__neg)),inj__ty_2Erealax_2Ereal(V2r)) = ap(ap(c_2Ebool_2ELET(ty_2Erealax_2Ereal,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Ebool_2ELET(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Erealax_2Ereal,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))),f3025(A_27t,A_27w,V0mode,V1to__neg,V2r)),ap(ap(ap(c_2Ebinary__ieee_2Efloat__round(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),inj__o(V1to__neg)),inj__ty_2Erealax_2Ereal(V2r)))),ap(c_2Ereal_2Eabs,inj__ty_2Erealax_2Ereal(V2r))) ) ).

tff(ax_thm_2Ebinary__ieee_2Echeck__for__signalling__def,axiom,
    ! [A_27a: del,A_27b: del,V0l: $i] :
      ( mem(V0l,ty_2Elist_2Elist(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b)))
     => ( surj__ty_2Ebinary__ieee_2Eflags(ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27a,A_27b),V0l)) = surj__ty_2Ebinary__ieee_2Eflags(ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,ap(c_2Ecombin_2EK(bool,bool),ap(ap(c_2Elist_2EEXISTS(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b)),c_2Ebinary__ieee_2Efloat__is__signalling(A_27a,A_27b)),V0l))),inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Eclear__flags))) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Ereal__to__float__def,axiom,
    ! [A_27a: del,A_27b: del,V0m: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(c_2Ebinary__ieee_2Ereal__to__float(A_27a,A_27b),inj__ty_2Ebinary__ieee_2Erounding(V0m)) = ap(ap(c_2Ebinary__ieee_2Efloat__round(A_27a,A_27b),inj__ty_2Ebinary__ieee_2Erounding(V0m)),ap(ap(c_2Emin_2E_3D(ty_2Ebinary__ieee_2Erounding),inj__ty_2Ebinary__ieee_2Erounding(V0m)),inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2EroundTowardNegative))) ) ).

tff(ax_thm_2Ebinary__ieee_2Ereal__to__float__with__flags__def,axiom,
    ! [A_27a: del,A_27b: del,V0m: tp__ty_2Ebinary__ieee_2Erounding] : ( ap(c_2Ebinary__ieee_2Ereal__to__float__with__flags(A_27a,A_27b),inj__ty_2Ebinary__ieee_2Erounding(V0m)) = ap(ap(c_2Ebinary__ieee_2Efloat__round__with__flags(A_27a,A_27b),inj__ty_2Ebinary__ieee_2Erounding(V0m)),ap(ap(c_2Emin_2E_3D(ty_2Ebinary__ieee_2Erounding),inj__ty_2Ebinary__ieee_2Erounding(V0m)),inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2EroundTowardNegative))) ) ).

tff(lamtp_f3026,type,
    f3026: ( del * del * tp__ty_2Ebinary__ieee_2Erounding ) > $i ).

tff(lameq_f3026,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V2r: tp__ty_2Erealax_2Ereal] : ( ap(f3026(A_27t,A_27w,V0mode),inj__ty_2Erealax_2Ereal(V2r)) = ap(ap(c_2Ebinary__ieee_2Eintegral__round(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),inj__ty_2Erealax_2Ereal(V2r)) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__round__to__integral__def,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ( ap(ap(c_2Ebinary__ieee_2Efloat__round__to__integral(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x) = ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V1x)),f3026(A_27t,A_27w,V0mode)),V1x),V1x) ) ) ).

tff(lamtp_f3027,type,
    f3027: ( tp__ty_2Einteger_2Eint * tp__ty_2Erealax_2Ereal ) > $i ).

tff(lameq_f3027,axiom,
    ! [V3f: tp__ty_2Einteger_2Eint,V2r: tp__ty_2Erealax_2Ereal,V4df: tp__ty_2Erealax_2Ereal] : ( ap(f3027(V3f,V2r),inj__ty_2Erealax_2Ereal(V4df)) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Einteger_2Eint),ap(ap(c_2Ebool_2E_5C_2F,ap(ap(c_2Erealax_2Ereal__lt,inj__ty_2Erealax_2Ereal(V4df)),ap(ap(c_2Ereal_2E_2F,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))))),ap(ap(c_2Ebool_2E_2F_5C,ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),inj__ty_2Erealax_2Ereal(V4df)),ap(ap(c_2Ereal_2E_2F,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))))),ap(c_2Earithmetic_2EEVEN,ap(c_2Einteger_2ENum,ap(c_2Einteger_2EABS,inj__ty_2Einteger_2Eint(V3f))))))),inj__ty_2Einteger_2Eint(V3f)),ap(c_2Eintreal_2EINT__CEILING,inj__ty_2Erealax_2Ereal(V2r))) ) ).

tff(lamtp_f3028,type,
    f3028: tp__ty_2Erealax_2Ereal > $i ).

tff(lameq_f3028,axiom,
    ! [V2r: tp__ty_2Erealax_2Ereal,V3f: tp__ty_2Einteger_2Eint] : ( ap(f3028(V2r),inj__ty_2Einteger_2Eint(V3f)) = ap(ap(c_2Ebool_2ELET(ty_2Erealax_2Ereal,ty_2Einteger_2Eint),f3027(V3f,V2r)),ap(c_2Ereal_2Eabs,ap(ap(c_2Ereal_2Ereal__sub,inj__ty_2Erealax_2Ereal(V2r)),ap(c_2Eintreal_2Ereal__of__int,inj__ty_2Einteger_2Eint(V3f))))) ) ).

tff(lamtp_f3029,type,
    f3029: ( del * del * $i * tp__ty_2Ebinary__ieee_2Erounding ) > $i ).

tff(lameq_f3029,axiom,
    ! [A_27t: del,A_27w: del,V1x: $i] :
      ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V0mode: tp__ty_2Ebinary__ieee_2Erounding,V2r: tp__ty_2Erealax_2Ereal] : ( ap(f3029(A_27t,A_27w,V1x,V0mode),inj__ty_2Erealax_2Ereal(V2r)) = ap(c_2Eoption_2ESOME(ty_2Einteger_2Eint),ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erounding__CASE(ty_2Einteger_2Eint),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),ap(ap(c_2Ebool_2ELET(ty_2Einteger_2Eint,ty_2Einteger_2Eint),f3028(V2r)),ap(c_2Eintreal_2EINT__FLOOR,inj__ty_2Erealax_2Ereal(V2r)))),ap(c_2Eintreal_2EINT__CEILING,inj__ty_2Erealax_2Ereal(V2r))),ap(c_2Eintreal_2EINT__FLOOR,inj__ty_2Erealax_2Ereal(V2r))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Einteger_2Eint),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))))),ap(c_2Eintreal_2EINT__CEILING,inj__ty_2Erealax_2Ereal(V2r))),ap(c_2Eintreal_2EINT__FLOOR,inj__ty_2Erealax_2Ereal(V2r))))) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__to__int__def,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ( surj__c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint(ap(ap(c_2Ebinary__ieee_2Efloat__to__int(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x)) = surj__c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Eoption_2Eoption(ty_2Einteger_2Eint)),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V1x)),f3029(A_27t,A_27w,V1x,V0mode)),c_2Eoption_2ENONE(ty_2Einteger_2Eint)),c_2Eoption_2ENONE(ty_2Einteger_2Eint))) ) ) ).

tff(lamtp_f3030,type,
    f3030: ( del * del * tp__ty_2Ebinary__ieee_2Erounding ) > $i ).

tff(lameq_f3030,axiom,
    ! [A_27w: del,A_27t: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V2r: tp__ty_2Erealax_2Ereal] : ( ap(f3030(A_27w,A_27t,V0mode),inj__ty_2Erealax_2Ereal(V2r)) = ap(ap(ap(c_2Ebinary__ieee_2Efloat__round__with__flags(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),inj__o(fo__c_2Ebool_2EF)),ap(c_2Etransc_2Esqrt,inj__ty_2Erealax_2Ereal(V2r))) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__sqrt__def,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ( ap(ap(c_2Ebinary__ieee_2Efloat__sqrt(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))),ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V1x)),f3030(A_27w,A_27t,V0mode)),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Eclear__flags)),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27t,A_27w),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V1x),c_2Elist_2ENIL(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Einvalidop__flags)),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x)))) ) ) ).

tff(lamtp_f3031,type,
    f3031: ( del * del * tp__ty_2Ebinary__ieee_2Erounding * $i * $i * tp__ty_2Erealax_2Ereal ) > $i ).

tff(lameq_f3031,axiom,
    ! [A_27w: del,A_27t: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V2y: $i] :
          ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V5r1: tp__ty_2Erealax_2Ereal,V6r2: tp__ty_2Erealax_2Ereal] : ( ap(f3031(A_27w,A_27t,V0mode,V1x,V2y,V5r1),inj__ty_2Erealax_2Ereal(V6r2)) = ap(ap(ap(c_2Ebinary__ieee_2Efloat__round__with__flags(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),ap(ap(ap(c_2Ebool_2ECOND(bool),ap(ap(c_2Ebool_2E_2F_5C,ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),inj__ty_2Erealax_2Ereal(V5r1)),ap(c_2Ereal_2Ereal__of__num,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))),ap(ap(c_2Ebool_2E_2F_5C,ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),inj__ty_2Erealax_2Ereal(V6r2)),ap(c_2Ereal_2Ereal__of__num,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V2y))))),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))))),ap(ap(c_2Emin_2E_3D(ty_2Ebinary__ieee_2Erounding),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2EroundTowardNegative)))),ap(ap(c_2Erealax_2Ereal__add,inj__ty_2Erealax_2Ereal(V5r1)),inj__ty_2Erealax_2Ereal(V6r2))) ) ) ) ).

tff(lamtp_f3032,type,
    f3032: ( del * del * tp__ty_2Ebinary__ieee_2Efloat__value * $i * tp__ty_2Ebinary__ieee_2Erounding * $i ) > $i ).

tff(lameq_f3032,axiom,
    ! [A_27w: del,A_27t: del,V4v1: tp__ty_2Ebinary__ieee_2Efloat__value,V1x: $i] :
      ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V0mode: tp__ty_2Ebinary__ieee_2Erounding,V2y: $i] :
          ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V5r1: tp__ty_2Erealax_2Ereal] : ( ap(f3032(A_27w,A_27t,V4v1,V1x,V0mode,V2y),inj__ty_2Erealax_2Ereal(V5r1)) = ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),inj__ty_2Ebinary__ieee_2Efloat__value(V4v1)),f3031(A_27w,A_27t,V0mode,V1x,V2y,V5r1)),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Eclear__flags)),V2y)),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27t,A_27w),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V2y),c_2Elist_2ENIL(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x),V2y)))) ) ) ) ).

tff(lamtp_f3033,type,
    f3033: ( del * del * tp__ty_2Ebinary__ieee_2Efloat__value * tp__ty_2Ebinary__ieee_2Erounding * $i * $i ) > $i ).

tff(lameq_f3033,axiom,
    ! [A_27w: del,A_27t: del,V3v: tp__ty_2Ebinary__ieee_2Efloat__value,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V2y: $i] :
          ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V4v1: tp__ty_2Ebinary__ieee_2Efloat__value] : ( ap(f3033(A_27w,A_27t,V3v,V0mode,V1x,V2y),inj__ty_2Ebinary__ieee_2Efloat__value(V4v1)) = ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),inj__ty_2Ebinary__ieee_2Efloat__value(V3v)),f3032(A_27w,A_27t,V4v1,V1x,V0mode,V2y)),ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),inj__ty_2Ebinary__ieee_2Efloat__value(V4v1)),k(ty_2Erealax_2Ereal,ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Eclear__flags)),V1x))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V2y))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Eclear__flags)),V1x)),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Einvalidop__flags)),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x),V2y))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27t,A_27w),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V2y),c_2Elist_2ENIL(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x),V2y))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27t,A_27w),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V1x),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V2y),c_2Elist_2ENIL(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x),V2y)))) ) ) ) ).

tff(lamtp_f3034,type,
    f3034: ( del * del * tp__ty_2Ebinary__ieee_2Erounding * $i * $i ) > $i ).

tff(lameq_f3034,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V2y: $i] :
          ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V3v: tp__ty_2Ebinary__ieee_2Efloat__value] : ( ap(f3034(A_27t,A_27w,V0mode,V1x,V2y),inj__ty_2Ebinary__ieee_2Efloat__value(V3v)) = f3033(A_27w,A_27t,V3v,V0mode,V1x,V2y) ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__add__def,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V2y: $i] :
          ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ( ap(ap(ap(c_2Ebinary__ieee_2Efloat__add(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x),V2y) = ap(ap(c_2Epair_2Epair__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ty_2Ebinary__ieee_2Efloat__value,ty_2Ebinary__ieee_2Efloat__value),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat__value,ty_2Ebinary__ieee_2Efloat__value),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V2y))),f3034(A_27t,A_27w,V0mode,V1x,V2y)) ) ) ) ).

tff(lamtp_f3035,type,
    f3035: ( del * del * tp__ty_2Ebinary__ieee_2Erounding * $i * $i * tp__ty_2Erealax_2Ereal ) > $i ).

tff(lameq_f3035,axiom,
    ! [A_27w: del,A_27t: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V2y: $i] :
          ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V5r1: tp__ty_2Erealax_2Ereal,V6r2: tp__ty_2Erealax_2Ereal] : ( ap(f3035(A_27w,A_27t,V0mode,V1x,V2y,V5r1),inj__ty_2Erealax_2Ereal(V6r2)) = ap(ap(ap(c_2Ebinary__ieee_2Efloat__round__with__flags(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),ap(ap(ap(c_2Ebool_2ECOND(bool),ap(ap(c_2Ebool_2E_2F_5C,ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),inj__ty_2Erealax_2Ereal(V5r1)),ap(c_2Ereal_2Ereal__of__num,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))),ap(ap(c_2Ebool_2E_2F_5C,ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),inj__ty_2Erealax_2Ereal(V6r2)),ap(c_2Ereal_2Ereal__of__num,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))),ap(c_2Ebool_2E_7E,ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V2y)))))),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))))),ap(ap(c_2Emin_2E_3D(ty_2Ebinary__ieee_2Erounding),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2EroundTowardNegative)))),ap(ap(c_2Ereal_2Ereal__sub,inj__ty_2Erealax_2Ereal(V5r1)),inj__ty_2Erealax_2Ereal(V6r2))) ) ) ) ).

tff(lamtp_f3036,type,
    f3036: ( del * del * tp__ty_2Ebinary__ieee_2Efloat__value * $i * tp__ty_2Ebinary__ieee_2Erounding * $i ) > $i ).

tff(lameq_f3036,axiom,
    ! [A_27w: del,A_27t: del,V4v1: tp__ty_2Ebinary__ieee_2Efloat__value,V1x: $i] :
      ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V0mode: tp__ty_2Ebinary__ieee_2Erounding,V2y: $i] :
          ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V5r1: tp__ty_2Erealax_2Ereal] : ( ap(f3036(A_27w,A_27t,V4v1,V1x,V0mode,V2y),inj__ty_2Erealax_2Ereal(V5r1)) = ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),inj__ty_2Ebinary__ieee_2Efloat__value(V4v1)),f3035(A_27w,A_27t,V0mode,V1x,V2y,V5r1)),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Eclear__flags)),ap(c_2Ebinary__ieee_2Efloat__negate(A_27t,A_27w),V2y))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27t,A_27w),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V2y),c_2Elist_2ENIL(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x),V2y)))) ) ) ) ).

tff(lamtp_f3037,type,
    f3037: ( del * del * tp__ty_2Ebinary__ieee_2Efloat__value * tp__ty_2Ebinary__ieee_2Erounding * $i * $i ) > $i ).

tff(lameq_f3037,axiom,
    ! [A_27w: del,A_27t: del,V3v: tp__ty_2Ebinary__ieee_2Efloat__value,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V2y: $i] :
          ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V4v1: tp__ty_2Ebinary__ieee_2Efloat__value] : ( ap(f3037(A_27w,A_27t,V3v,V0mode,V1x,V2y),inj__ty_2Ebinary__ieee_2Efloat__value(V4v1)) = ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),inj__ty_2Ebinary__ieee_2Efloat__value(V3v)),f3036(A_27w,A_27t,V4v1,V1x,V0mode,V2y)),ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),inj__ty_2Ebinary__ieee_2Efloat__value(V4v1)),k(ty_2Erealax_2Ereal,ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Eclear__flags)),V1x))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V2y))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Einvalidop__flags)),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x),V2y)))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Eclear__flags)),V1x))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27t,A_27w),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V2y),c_2Elist_2ENIL(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x),V2y))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27t,A_27w),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V1x),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V2y),c_2Elist_2ENIL(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x),V2y)))) ) ) ) ).

tff(lamtp_f3038,type,
    f3038: ( del * del * tp__ty_2Ebinary__ieee_2Erounding * $i * $i ) > $i ).

tff(lameq_f3038,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V2y: $i] :
          ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V3v: tp__ty_2Ebinary__ieee_2Efloat__value] : ( ap(f3038(A_27t,A_27w,V0mode,V1x,V2y),inj__ty_2Ebinary__ieee_2Efloat__value(V3v)) = f3037(A_27w,A_27t,V3v,V0mode,V1x,V2y) ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__sub__def,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V2y: $i] :
          ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ( ap(ap(ap(c_2Ebinary__ieee_2Efloat__sub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x),V2y) = ap(ap(c_2Epair_2Epair__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ty_2Ebinary__ieee_2Efloat__value,ty_2Ebinary__ieee_2Efloat__value),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat__value,ty_2Ebinary__ieee_2Efloat__value),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V2y))),f3038(A_27t,A_27w,V0mode,V1x,V2y)) ) ) ) ).

tff(lamtp_f3039,type,
    f3039: ( del * del * tp__ty_2Ebinary__ieee_2Erounding * $i * $i * tp__ty_2Erealax_2Ereal ) > $i ).

tff(lameq_f3039,axiom,
    ! [A_27w: del,A_27t: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V2y: $i] :
      ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V1x: $i] :
          ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V5r_27: tp__ty_2Erealax_2Ereal,V6r2: tp__ty_2Erealax_2Ereal] : ( ap(f3039(A_27w,A_27t,V0mode,V2y,V1x,V5r_27),inj__ty_2Erealax_2Ereal(V6r2)) = ap(ap(ap(c_2Ebinary__ieee_2Efloat__round__with__flags(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),ap(c_2Ebool_2E_7E,ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V2y)))),ap(ap(c_2Erealax_2Ereal__mul,inj__ty_2Erealax_2Ereal(V5r_27)),inj__ty_2Erealax_2Ereal(V6r2))) ) ) ) ).

tff(lamtp_f3040,type,
    f3040: ( del * del * tp__ty_2Ebinary__ieee_2Efloat__value * $i * tp__ty_2Ebinary__ieee_2Erounding * $i ) > $i ).

tff(lameq_f3040,axiom,
    ! [A_27w: del,A_27t: del,V4v1: tp__ty_2Ebinary__ieee_2Efloat__value,V1x: $i] :
      ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V0mode: tp__ty_2Ebinary__ieee_2Erounding,V2y: $i] :
          ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V5r_27: tp__ty_2Erealax_2Ereal] : ( ap(f3040(A_27w,A_27t,V4v1,V1x,V0mode,V2y),inj__ty_2Erealax_2Ereal(V5r_27)) = ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),inj__ty_2Ebinary__ieee_2Efloat__value(V4v1)),f3039(A_27w,A_27t,V0mode,V2y,V1x,V5r_27)),ap(ap(ap(c_2Ebool_2ECOND(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),inj__ty_2Erealax_2Ereal(V5r_27)),ap(c_2Ereal_2Ereal__of__num,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Einvalidop__flags)),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x),V2y)))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Eclear__flags)),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V2y))),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27t,A_27w),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V2y),c_2Elist_2ENIL(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x),V2y)))) ) ) ) ).

tff(lamtp_f3041,type,
    f3041: ( del * del * tp__ty_2Ebinary__ieee_2Erounding * $i * $i ) > $i ).

tff(lameq_f3041,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V2y: $i] :
          ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V7r: tp__ty_2Erealax_2Ereal] : ( ap(f3041(A_27t,A_27w,V0mode,V1x,V2y),inj__ty_2Erealax_2Ereal(V7r)) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),inj__ty_2Erealax_2Ereal(V7r)),ap(c_2Ereal_2Ereal__of__num,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Einvalidop__flags)),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x),V2y)))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Eclear__flags)),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V2y))),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))) ) ) ) ).

tff(lamtp_f3042,type,
    f3042: ( del * del * tp__ty_2Ebinary__ieee_2Efloat__value * tp__ty_2Ebinary__ieee_2Erounding * $i * $i ) > $i ).

tff(lameq_f3042,axiom,
    ! [A_27w: del,A_27t: del,V3v: tp__ty_2Ebinary__ieee_2Efloat__value,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V2y: $i] :
          ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V4v1: tp__ty_2Ebinary__ieee_2Efloat__value] : ( ap(f3042(A_27w,A_27t,V3v,V0mode,V1x,V2y),inj__ty_2Ebinary__ieee_2Efloat__value(V4v1)) = ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),inj__ty_2Ebinary__ieee_2Efloat__value(V3v)),f3040(A_27w,A_27t,V4v1,V1x,V0mode,V2y)),ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),inj__ty_2Ebinary__ieee_2Efloat__value(V4v1)),f3041(A_27t,A_27w,V0mode,V1x,V2y)),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Eclear__flags)),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V2y))),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27t,A_27w),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V2y),c_2Elist_2ENIL(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x),V2y))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27t,A_27w),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V1x),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V2y),c_2Elist_2ENIL(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x),V2y)))) ) ) ) ).

tff(lamtp_f3043,type,
    f3043: ( del * del * tp__ty_2Ebinary__ieee_2Erounding * $i * $i ) > $i ).

tff(lameq_f3043,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V2y: $i] :
          ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V3v: tp__ty_2Ebinary__ieee_2Efloat__value] : ( ap(f3043(A_27t,A_27w,V0mode,V1x,V2y),inj__ty_2Ebinary__ieee_2Efloat__value(V3v)) = f3042(A_27w,A_27t,V3v,V0mode,V1x,V2y) ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__mul__def,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V2y: $i] :
          ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ( ap(ap(ap(c_2Ebinary__ieee_2Efloat__mul(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x),V2y) = ap(ap(c_2Epair_2Epair__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ty_2Ebinary__ieee_2Efloat__value,ty_2Ebinary__ieee_2Efloat__value),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat__value,ty_2Ebinary__ieee_2Efloat__value),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V2y))),f3043(A_27t,A_27w,V0mode,V1x,V2y)) ) ) ) ).

tff(lamtp_f3044,type,
    f3044: ( del * del * tp__ty_2Ebinary__ieee_2Erounding * $i * $i * tp__ty_2Erealax_2Ereal ) > $i ).

tff(lameq_f3044,axiom,
    ! [A_27w: del,A_27t: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V2y: $i] :
      ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V1x: $i] :
          ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V5r1: tp__ty_2Erealax_2Ereal,V6r2: tp__ty_2Erealax_2Ereal] : ( ap(f3044(A_27w,A_27t,V0mode,V2y,V1x,V5r1),inj__ty_2Erealax_2Ereal(V6r2)) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),inj__ty_2Erealax_2Ereal(V6r2)),ap(c_2Ereal_2Ereal__of__num,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),inj__ty_2Erealax_2Ereal(V5r1)),ap(c_2Ereal_2Ereal__of__num,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Einvalidop__flags)),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x),V2y)))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Edividezero__flags)),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V2y))),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))))),ap(ap(ap(c_2Ebinary__ieee_2Efloat__round__with__flags(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),ap(c_2Ebool_2E_7E,ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V2y)))),ap(ap(c_2Ereal_2E_2F,inj__ty_2Erealax_2Ereal(V5r1)),inj__ty_2Erealax_2Ereal(V6r2)))) ) ) ) ).

tff(lamtp_f3045,type,
    f3045: ( del * del * tp__ty_2Ebinary__ieee_2Efloat__value * $i * tp__ty_2Ebinary__ieee_2Erounding * $i ) > $i ).

tff(lameq_f3045,axiom,
    ! [A_27w: del,A_27t: del,V4v1: tp__ty_2Ebinary__ieee_2Efloat__value,V1x: $i] :
      ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V0mode: tp__ty_2Ebinary__ieee_2Erounding,V2y: $i] :
          ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V5r1: tp__ty_2Erealax_2Ereal] : ( ap(f3045(A_27w,A_27t,V4v1,V1x,V0mode,V2y),inj__ty_2Erealax_2Ereal(V5r1)) = ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),inj__ty_2Ebinary__ieee_2Efloat__value(V4v1)),f3044(A_27w,A_27t,V0mode,V2y,V1x,V5r1)),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Eclear__flags)),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V2y))),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27t,A_27w),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V2y),c_2Elist_2ENIL(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x),V2y)))) ) ) ) ).

tff(lamtp_f3046,type,
    f3046: ( del * del * tp__ty_2Ebinary__ieee_2Efloat__value * tp__ty_2Ebinary__ieee_2Erounding * $i * $i ) > $i ).

tff(lameq_f3046,axiom,
    ! [A_27w: del,A_27t: del,V3v: tp__ty_2Ebinary__ieee_2Efloat__value,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V2y: $i] :
          ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V4v1: tp__ty_2Ebinary__ieee_2Efloat__value] : ( ap(f3046(A_27w,A_27t,V3v,V0mode,V1x,V2y),inj__ty_2Ebinary__ieee_2Efloat__value(V4v1)) = ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),inj__ty_2Ebinary__ieee_2Efloat__value(V3v)),f3045(A_27w,A_27t,V4v1,V1x,V0mode,V2y)),ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),inj__ty_2Ebinary__ieee_2Efloat__value(V4v1)),k(ty_2Erealax_2Ereal,ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Eclear__flags)),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V2y))),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Einvalidop__flags)),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x),V2y)))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27t,A_27w),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V2y),c_2Elist_2ENIL(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x),V2y))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27t,A_27w),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V1x),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V2y),c_2Elist_2ENIL(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x),V2y)))) ) ) ) ).

tff(lamtp_f3047,type,
    f3047: ( del * del * tp__ty_2Ebinary__ieee_2Erounding * $i * $i ) > $i ).

tff(lameq_f3047,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V2y: $i] :
          ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V3v: tp__ty_2Ebinary__ieee_2Efloat__value] : ( ap(f3047(A_27t,A_27w,V0mode,V1x,V2y),inj__ty_2Ebinary__ieee_2Efloat__value(V3v)) = f3046(A_27w,A_27t,V3v,V0mode,V1x,V2y) ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__div__def,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V2y: $i] :
          ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ( ap(ap(ap(c_2Ebinary__ieee_2Efloat__div(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x),V2y) = ap(ap(c_2Epair_2Epair__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ty_2Ebinary__ieee_2Efloat__value,ty_2Ebinary__ieee_2Efloat__value),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat__value,ty_2Ebinary__ieee_2Efloat__value),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V2y))),f3047(A_27t,A_27w,V0mode,V1x,V2y)) ) ) ) ).

tff(lamtp_f3048,type,
    f3048: ( del * del * tp__ty_2Ebinary__ieee_2Erounding * tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone * $i * tp__ty_2Erealax_2Ereal ) > $i ).

tff(lameq_f3048,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V4signP: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V3z: $i] :
      ( mem(V3z,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V6r1: tp__ty_2Erealax_2Ereal,V7r2: tp__ty_2Erealax_2Ereal] : ( ap(f3048(A_27t,A_27w,V0mode,V4signP,V3z,V6r1),inj__ty_2Erealax_2Ereal(V7r2)) = ap(ap(ap(c_2Ebinary__ieee_2Efloat__round__with__flags(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),ap(ap(ap(c_2Ebool_2ECOND(bool),ap(ap(c_2Ebool_2E_2F_5C,ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),inj__ty_2Erealax_2Ereal(V6r1)),ap(c_2Ereal_2Ereal__of__num,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))),ap(ap(c_2Ebool_2E_2F_5C,ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),inj__ty_2Erealax_2Ereal(V7r2)),ap(c_2Ereal_2Ereal__of__num,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V4signP)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V3z))))),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V4signP)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))))),ap(ap(c_2Emin_2E_3D(ty_2Ebinary__ieee_2Erounding),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2EroundTowardNegative)))),ap(ap(c_2Erealax_2Ereal__add,inj__ty_2Erealax_2Ereal(V6r1)),inj__ty_2Erealax_2Ereal(V7r2))) ) ) ).

tff(lamtp_f3049,type,
    f3049: ( del * del * tp__ty_2Ebinary__ieee_2Erounding * tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone * $i ) > $i ).

tff(lameq_f3049,axiom,
    ! [A_27w: del,A_27t: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V4signP: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V3z: $i] :
      ( mem(V3z,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V6r1: tp__ty_2Erealax_2Ereal] : ( ap(f3049(A_27w,A_27t,V0mode,V4signP,V3z),inj__ty_2Erealax_2Ereal(V6r1)) = f3048(A_27t,A_27w,V0mode,V4signP,V3z,V6r1) ) ) ).

tff(lamtp_f3050,type,
    f3050: ( del * del * tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone * tp__ty_2Ebinary__ieee_2Erounding * $i * $i * $i ) > $i ).

tff(lameq_f3050,axiom,
    ! [A_27w: del,A_27t: del,V4signP: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V2y: $i] :
          ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V3z: $i] :
              ( mem(V3z,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V5infP: tp__o] : ( ap(f3050(A_27w,A_27t,V4signP,V0mode,V1x,V2y,V3z),inj__o(V5infP)) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Ebool_2E_5C_2F,ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),V1x)),ap(ap(c_2Ebool_2E_5C_2F,ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),V2y)),ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),V3z)))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27t,A_27w),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V1x),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V2y),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V3z),c_2Elist_2ENIL(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x),V2y),V3z)))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Ebool_2E_5C_2F,ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w),V2y))),ap(ap(c_2Ebool_2E_5C_2F,ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V2y))),ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V3z)),ap(ap(c_2Ebool_2E_2F_5C,inj__o(V5infP)),ap(c_2Ebool_2E_7E,ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V4signP)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V3z)))))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Einvalidop__flags)),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x),V2y),V3z)))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Ebool_2E_5C_2F,ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V3z)),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V3z)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0))))),ap(ap(c_2Ebool_2E_2F_5C,inj__o(V5infP)),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V4signP)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Eclear__flags)),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Ebool_2E_5C_2F,ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V3z)),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V3z)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))))),ap(ap(c_2Ebool_2E_2F_5C,inj__o(V5infP)),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V4signP)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Eclear__flags)),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))),ap(ap(c_2Ebool_2ELET(ty_2Erealax_2Ereal,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Ebool_2ELET(ty_2Erealax_2Ereal,arr(ty_2Erealax_2Ereal,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))),f3049(A_27w,A_27t,V0mode,V4signP,V3z)),ap(ap(c_2Erealax_2Ereal__mul,ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),V2y)))),ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),V3z)))))) ) ) ) ) ).

tff(lamtp_f3051,type,
    f3051: ( del * del * tp__ty_2Ebinary__ieee_2Erounding * $i * $i * $i ) > $i ).

tff(lameq_f3051,axiom,
    ! [A_27w: del,A_27t: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V3z: $i] :
      ( mem(V3z,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V1x: $i] :
          ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V2y: $i] :
              ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V4signP: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone] : ( ap(f3051(A_27w,A_27t,V0mode,V3z,V1x,V2y),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V4signP)) = ap(ap(c_2Ebool_2ELET(bool,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),f3050(A_27w,A_27t,V4signP,V0mode,V1x,V2y,V3z)),ap(ap(c_2Ebool_2E_5C_2F,ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V2y))) ) ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__mul__add__def,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V2y: $i] :
          ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V3z: $i] :
              ( mem(V3z,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ( ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__mul__add(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x),V2y),V3z) = ap(ap(c_2Ebool_2ELET(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),f3051(A_27w,A_27t,V0mode,V3z,V1x,V2y)),ap(ap(c_2Ewords_2Eword__xor(ty_2Eone_2Eone),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V2y))) ) ) ) ) ).

tff(lamtp_f3052,type,
    f3052: ( del * del * tp__ty_2Ebinary__ieee_2Erounding * tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone * $i * tp__ty_2Erealax_2Ereal ) > $i ).

tff(lameq_f3052,axiom,
    ! [A_27w: del,A_27t: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V4signP: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V3z: $i] :
      ( mem(V3z,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V6r1: tp__ty_2Erealax_2Ereal,V7r2: tp__ty_2Erealax_2Ereal] : ( ap(f3052(A_27w,A_27t,V0mode,V4signP,V3z,V6r1),inj__ty_2Erealax_2Ereal(V7r2)) = ap(ap(ap(c_2Ebinary__ieee_2Efloat__round__with__flags(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),ap(ap(ap(c_2Ebool_2ECOND(bool),ap(ap(c_2Ebool_2E_2F_5C,ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),inj__ty_2Erealax_2Ereal(V6r1)),ap(c_2Ereal_2Ereal__of__num,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))),ap(ap(c_2Ebool_2E_2F_5C,ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),inj__ty_2Erealax_2Ereal(V7r2)),ap(c_2Ereal_2Ereal__of__num,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))),ap(c_2Ebool_2E_7E,ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V4signP)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V3z)))))),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V4signP)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))))),ap(ap(c_2Emin_2E_3D(ty_2Ebinary__ieee_2Erounding),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),inj__ty_2Ebinary__ieee_2Erounding(fo__c_2Ebinary__ieee_2EroundTowardNegative)))),ap(ap(c_2Ereal_2Ereal__sub,inj__ty_2Erealax_2Ereal(V6r1)),inj__ty_2Erealax_2Ereal(V7r2))) ) ) ).

tff(lamtp_f3053,type,
    f3053: ( del * del * tp__ty_2Ebinary__ieee_2Erounding * tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone * $i ) > $i ).

tff(lameq_f3053,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V4signP: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V3z: $i] :
      ( mem(V3z,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V6r1: tp__ty_2Erealax_2Ereal] : ( ap(f3053(A_27t,A_27w,V0mode,V4signP,V3z),inj__ty_2Erealax_2Ereal(V6r1)) = f3052(A_27w,A_27t,V0mode,V4signP,V3z,V6r1) ) ) ).

tff(lamtp_f3054,type,
    f3054: ( del * del * tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone * tp__ty_2Ebinary__ieee_2Erounding * $i * $i * $i ) > $i ).

tff(lameq_f3054,axiom,
    ! [A_27w: del,A_27t: del,V4signP: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V2y: $i] :
          ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V3z: $i] :
              ( mem(V3z,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V5infP: tp__o] : ( ap(f3054(A_27w,A_27t,V4signP,V0mode,V1x,V2y,V3z),inj__o(V5infP)) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Ebool_2E_5C_2F,ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),V1x)),ap(ap(c_2Ebool_2E_5C_2F,ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),V2y)),ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),V3z)))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27t,A_27w),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V1x),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V2y),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V3z),c_2Elist_2ENIL(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x),V2y),V3z)))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Ebool_2E_5C_2F,ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w),V2y))),ap(ap(c_2Ebool_2E_5C_2F,ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V2y))),ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V3z)),ap(ap(c_2Ebool_2E_2F_5C,inj__o(V5infP)),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V4signP)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V3z))))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Einvalidop__flags)),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x),V2y),V3z)))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Ebool_2E_5C_2F,ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V3z)),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V3z)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))))),ap(ap(c_2Ebool_2E_2F_5C,inj__o(V5infP)),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V4signP)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Eclear__flags)),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Ebool_2E_5C_2F,ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V3z)),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V3z)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0))))),ap(ap(c_2Ebool_2E_2F_5C,inj__o(V5infP)),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V4signP)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),inj__ty_2Ebinary__ieee_2Eflags(fo__c_2Ebinary__ieee_2Eclear__flags)),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))),ap(ap(c_2Ebool_2ELET(ty_2Erealax_2Ereal,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Ebool_2ELET(ty_2Erealax_2Ereal,arr(ty_2Erealax_2Ereal,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))),f3053(A_27t,A_27w,V0mode,V4signP,V3z)),ap(ap(c_2Erealax_2Ereal__mul,ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),V2y)))),ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),V3z)))))) ) ) ) ) ).

tff(lamtp_f3055,type,
    f3055: ( del * del * tp__ty_2Ebinary__ieee_2Erounding * $i * $i * $i ) > $i ).

tff(lameq_f3055,axiom,
    ! [A_27w: del,A_27t: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V3z: $i] :
      ( mem(V3z,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V1x: $i] :
          ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V2y: $i] :
              ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V4signP: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone] : ( ap(f3055(A_27w,A_27t,V0mode,V3z,V1x,V2y),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V4signP)) = ap(ap(c_2Ebool_2ELET(bool,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),f3054(A_27w,A_27t,V4signP,V0mode,V1x,V2y,V3z)),ap(ap(c_2Ebool_2E_5C_2F,ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V2y))) ) ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__mul__sub__def,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V2y: $i] :
          ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V3z: $i] :
              ( mem(V3z,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ( ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__mul__sub(A_27t,A_27w),inj__ty_2Ebinary__ieee_2Erounding(V0mode)),V1x),V2y),V3z) = ap(ap(c_2Ebool_2ELET(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),f3055(A_27w,A_27t,V0mode,V3z,V1x,V2y)),ap(ap(c_2Ewords_2Eword__xor(ty_2Eone_2Eone),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V2y))) ) ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__compare__TY__DEF,axiom,
    ? [V0rep: $i] :
      ( mem(V0rep,arr(ty_2Ebinary__ieee_2Efloat__compare,ty_2Enum_2Enum))
      & p(ap(ap(c_2Ebool_2ETYPE__DEFINITION(ty_2Enum_2Enum,ty_2Ebinary__ieee_2Efloat__compare),f2948),V0rep)) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__compare__BIJ,axiom,
    ( ! [V0a: tp__ty_2Ebinary__ieee_2Efloat__compare] : ( surj__ty_2Ebinary__ieee_2Efloat__compare(ap(c_2Ebinary__ieee_2Enum2float__compare,ap(c_2Ebinary__ieee_2Efloat__compare2num,inj__ty_2Ebinary__ieee_2Efloat__compare(V0a)))) = V0a )
    & ! [V1r: tp__ty_2Enum_2Enum] :
        ( p(ap(f2949,inj__ty_2Enum_2Enum(V1r)))
      <=> ( surj__ty_2Enum_2Enum(ap(c_2Ebinary__ieee_2Efloat__compare2num,ap(c_2Ebinary__ieee_2Enum2float__compare,inj__ty_2Enum_2Enum(V1r)))) = V1r ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Enum2float__compare__float__compare2num,axiom,
    ! [V0a: tp__ty_2Ebinary__ieee_2Efloat__compare] : ( surj__ty_2Ebinary__ieee_2Efloat__compare(ap(c_2Ebinary__ieee_2Enum2float__compare,ap(c_2Ebinary__ieee_2Efloat__compare2num,inj__ty_2Ebinary__ieee_2Efloat__compare(V0a)))) = V0a ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__compare2num__num2float__compare,axiom,
    ! [V0r: tp__ty_2Enum_2Enum] :
      ( p(ap(ap(c_2Eprim__rec_2E_3C,inj__ty_2Enum_2Enum(V0r)),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))))
    <=> ( surj__ty_2Enum_2Enum(ap(c_2Ebinary__ieee_2Efloat__compare2num,ap(c_2Ebinary__ieee_2Enum2float__compare,inj__ty_2Enum_2Enum(V0r)))) = V0r ) ) ).

tff(conj_thm_2Ebinary__ieee_2Enum2float__compare__11,axiom,
    ! [V0r: tp__ty_2Enum_2Enum,V1r_27: tp__ty_2Enum_2Enum] :
      ( p(ap(ap(c_2Eprim__rec_2E_3C,inj__ty_2Enum_2Enum(V0r)),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))))
     => ( p(ap(ap(c_2Eprim__rec_2E_3C,inj__ty_2Enum_2Enum(V1r_27)),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))))
       => ( ( surj__ty_2Ebinary__ieee_2Efloat__compare(ap(c_2Ebinary__ieee_2Enum2float__compare,inj__ty_2Enum_2Enum(V0r))) = surj__ty_2Ebinary__ieee_2Efloat__compare(ap(c_2Ebinary__ieee_2Enum2float__compare,inj__ty_2Enum_2Enum(V1r_27))) )
        <=> ( V0r = V1r_27 ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__compare2num__11,axiom,
    ! [V0a: tp__ty_2Ebinary__ieee_2Efloat__compare,V1a_27: tp__ty_2Ebinary__ieee_2Efloat__compare] :
      ( ( surj__ty_2Enum_2Enum(ap(c_2Ebinary__ieee_2Efloat__compare2num,inj__ty_2Ebinary__ieee_2Efloat__compare(V0a))) = surj__ty_2Enum_2Enum(ap(c_2Ebinary__ieee_2Efloat__compare2num,inj__ty_2Ebinary__ieee_2Efloat__compare(V1a_27))) )
    <=> ( V0a = V1a_27 ) ) ).

tff(conj_thm_2Ebinary__ieee_2Enum2float__compare__ONTO,axiom,
    ! [V0a: tp__ty_2Ebinary__ieee_2Efloat__compare] :
    ? [V1r: tp__ty_2Enum_2Enum] :
      ( ( V0a = surj__ty_2Ebinary__ieee_2Efloat__compare(ap(c_2Ebinary__ieee_2Enum2float__compare,inj__ty_2Enum_2Enum(V1r))) )
      & p(ap(ap(c_2Eprim__rec_2E_3C,inj__ty_2Enum_2Enum(V1r)),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))))) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__compare2num__ONTO,axiom,
    ! [V0r: tp__ty_2Enum_2Enum] :
      ( p(ap(ap(c_2Eprim__rec_2E_3C,inj__ty_2Enum_2Enum(V0r)),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))))
    <=> ? [V1a: tp__ty_2Ebinary__ieee_2Efloat__compare] : ( V0r = surj__ty_2Enum_2Enum(ap(c_2Ebinary__ieee_2Efloat__compare2num,inj__ty_2Ebinary__ieee_2Efloat__compare(V1a))) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Enum2float__compare__thm,axiom,
    ( ( surj__ty_2Ebinary__ieee_2Efloat__compare(ap(c_2Ebinary__ieee_2Enum2float__compare,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0))) = fo__c_2Ebinary__ieee_2ELT )
    & ( surj__ty_2Ebinary__ieee_2Efloat__compare(ap(c_2Ebinary__ieee_2Enum2float__compare,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))) = fo__c_2Ebinary__ieee_2EEQ )
    & ( surj__ty_2Ebinary__ieee_2Efloat__compare(ap(c_2Ebinary__ieee_2Enum2float__compare,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))) = fo__c_2Ebinary__ieee_2EGT )
    & ( surj__ty_2Ebinary__ieee_2Efloat__compare(ap(c_2Ebinary__ieee_2Enum2float__compare,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))))) = fo__c_2Ebinary__ieee_2EUN ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__compare2num__thm,axiom,
    ( ( surj__ty_2Enum_2Enum(ap(c_2Ebinary__ieee_2Efloat__compare2num,inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2ELT))) = fo__c_2Enum_2E0 )
    & ( surj__ty_2Enum_2Enum(ap(c_2Ebinary__ieee_2Efloat__compare2num,inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2EEQ))) = surj__ty_2Enum_2Enum(ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))) )
    & ( surj__ty_2Enum_2Enum(ap(c_2Ebinary__ieee_2Efloat__compare2num,inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2EGT))) = surj__ty_2Enum_2Enum(ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))) )
    & ( surj__ty_2Enum_2Enum(ap(c_2Ebinary__ieee_2Efloat__compare2num,inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2EUN))) = surj__ty_2Enum_2Enum(ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__compare__EQ__float__compare,axiom,
    ! [V0a: tp__ty_2Ebinary__ieee_2Efloat__compare,V1a_27: tp__ty_2Ebinary__ieee_2Efloat__compare] :
      ( ( V0a = V1a_27 )
    <=> ( surj__ty_2Enum_2Enum(ap(c_2Ebinary__ieee_2Efloat__compare2num,inj__ty_2Ebinary__ieee_2Efloat__compare(V0a))) = surj__ty_2Enum_2Enum(ap(c_2Ebinary__ieee_2Efloat__compare2num,inj__ty_2Ebinary__ieee_2Efloat__compare(V1a_27))) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__compare__size__def,axiom,
    ! [V0x: tp__ty_2Ebinary__ieee_2Efloat__compare] : ( surj__ty_2Enum_2Enum(ap(c_2Ebinary__ieee_2Efloat__compare__size,inj__ty_2Ebinary__ieee_2Efloat__compare(V0x))) = fo__c_2Enum_2E0 ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__compare__CASE,axiom,
    ! [A_27a: del,V0x: tp__ty_2Ebinary__ieee_2Efloat__compare,V1v0: $i] :
      ( mem(V1v0,A_27a)
     => ! [V2v1: $i] :
          ( mem(V2v1,A_27a)
         => ! [V3v2: $i] :
              ( mem(V3v2,A_27a)
             => ! [V4v3: $i] :
                  ( mem(V4v3,A_27a)
                 => ( ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__compare__CASE(A_27a),inj__ty_2Ebinary__ieee_2Efloat__compare(V0x)),V1v0),V2v1),V3v2),V4v3) = ap(f2950(A_27a,V2v1,V3v2,V4v3,V1v0),ap(c_2Ebinary__ieee_2Efloat__compare2num,inj__ty_2Ebinary__ieee_2Efloat__compare(V0x))) ) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__compare__case__def,axiom,
    ! [A_27a: del] :
      ( ! [V0v0: $i] :
          ( mem(V0v0,A_27a)
         => ! [V1v1: $i] :
              ( mem(V1v1,A_27a)
             => ! [V2v2: $i] :
                  ( mem(V2v2,A_27a)
                 => ! [V3v3: $i] :
                      ( mem(V3v3,A_27a)
                     => ( ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__compare__CASE(A_27a),inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2ELT)),V0v0),V1v1),V2v2),V3v3) = V0v0 ) ) ) ) )
      & ! [V4v0: $i] :
          ( mem(V4v0,A_27a)
         => ! [V5v1: $i] :
              ( mem(V5v1,A_27a)
             => ! [V6v2: $i] :
                  ( mem(V6v2,A_27a)
                 => ! [V7v3: $i] :
                      ( mem(V7v3,A_27a)
                     => ( ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__compare__CASE(A_27a),inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2EEQ)),V4v0),V5v1),V6v2),V7v3) = V5v1 ) ) ) ) )
      & ! [V8v0: $i] :
          ( mem(V8v0,A_27a)
         => ! [V9v1: $i] :
              ( mem(V9v1,A_27a)
             => ! [V10v2: $i] :
                  ( mem(V10v2,A_27a)
                 => ! [V11v3: $i] :
                      ( mem(V11v3,A_27a)
                     => ( ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__compare__CASE(A_27a),inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2EGT)),V8v0),V9v1),V10v2),V11v3) = V10v2 ) ) ) ) )
      & ! [V12v0: $i] :
          ( mem(V12v0,A_27a)
         => ! [V13v1: $i] :
              ( mem(V13v1,A_27a)
             => ! [V14v2: $i] :
                  ( mem(V14v2,A_27a)
                 => ! [V15v3: $i] :
                      ( mem(V15v3,A_27a)
                     => ( ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__compare__CASE(A_27a),inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2EUN)),V12v0),V13v1),V14v2),V15v3) = V15v3 ) ) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Edatatype__float__compare,axiom,
    ! [V0float__compare: $i] :
      ( mem(V0float__compare,arr(ty_2Ebinary__ieee_2Efloat__compare,arr(ty_2Ebinary__ieee_2Efloat__compare,arr(ty_2Ebinary__ieee_2Efloat__compare,arr(ty_2Ebinary__ieee_2Efloat__compare,bool)))))
     => p(ap(c_2Ebool_2EDATATYPE(bool),ap(ap(ap(ap(V0float__compare,inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2ELT)),inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2EEQ)),inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2EGT)),inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2EUN)))) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__compare__distinct,axiom,
    ( ( fo__c_2Ebinary__ieee_2ELT != fo__c_2Ebinary__ieee_2EEQ )
    & ( fo__c_2Ebinary__ieee_2ELT != fo__c_2Ebinary__ieee_2EGT )
    & ( fo__c_2Ebinary__ieee_2ELT != fo__c_2Ebinary__ieee_2EUN )
    & ( fo__c_2Ebinary__ieee_2EEQ != fo__c_2Ebinary__ieee_2EGT )
    & ( fo__c_2Ebinary__ieee_2EEQ != fo__c_2Ebinary__ieee_2EUN )
    & ( fo__c_2Ebinary__ieee_2EGT != fo__c_2Ebinary__ieee_2EUN ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__compare__nchotomy,axiom,
    ! [V0a: tp__ty_2Ebinary__ieee_2Efloat__compare] :
      ( ( V0a = fo__c_2Ebinary__ieee_2ELT )
      | ( V0a = fo__c_2Ebinary__ieee_2EEQ )
      | ( V0a = fo__c_2Ebinary__ieee_2EGT )
      | ( V0a = fo__c_2Ebinary__ieee_2EUN ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__compare__Axiom,axiom,
    ! [A_27a: del,V0x0: $i] :
      ( mem(V0x0,A_27a)
     => ! [V1x1: $i] :
          ( mem(V1x1,A_27a)
         => ! [V2x2: $i] :
              ( mem(V2x2,A_27a)
             => ! [V3x3: $i] :
                  ( mem(V3x3,A_27a)
                 => ? [V4f: $i] :
                      ( mem(V4f,arr(ty_2Ebinary__ieee_2Efloat__compare,A_27a))
                      & ( ap(V4f,inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2ELT)) = V0x0 )
                      & ( ap(V4f,inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2EEQ)) = V1x1 )
                      & ( ap(V4f,inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2EGT)) = V2x2 )
                      & ( ap(V4f,inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2EUN)) = V3x3 ) ) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__compare__induction,axiom,
    ! [V0P: $i] :
      ( mem(V0P,arr(ty_2Ebinary__ieee_2Efloat__compare,bool))
     => ( ( p(ap(V0P,inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2EEQ)))
          & p(ap(V0P,inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2EGT)))
          & p(ap(V0P,inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2ELT)))
          & p(ap(V0P,inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2EUN))) )
       => ! [V1a: tp__ty_2Ebinary__ieee_2Efloat__compare] : p(ap(V0P,inj__ty_2Ebinary__ieee_2Efloat__compare(V1a))) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__compare__case__cong,axiom,
    ! [A_27a: del,V0v0_27: $i] :
      ( mem(V0v0_27,A_27a)
     => ! [V1v1_27: $i] :
          ( mem(V1v1_27,A_27a)
         => ! [V2v2_27: $i] :
              ( mem(V2v2_27,A_27a)
             => ! [V3v3_27: $i] :
                  ( mem(V3v3_27,A_27a)
                 => ! [V4M: tp__ty_2Ebinary__ieee_2Efloat__compare,V5M_27: tp__ty_2Ebinary__ieee_2Efloat__compare,V6v0: $i] :
                      ( mem(V6v0,A_27a)
                     => ! [V7v1: $i] :
                          ( mem(V7v1,A_27a)
                         => ! [V8v2: $i] :
                              ( mem(V8v2,A_27a)
                             => ! [V9v3: $i] :
                                  ( mem(V9v3,A_27a)
                                 => ( ( ( V4M = V5M_27 )
                                      & ( ( V5M_27 = fo__c_2Ebinary__ieee_2ELT )
                                       => ( V6v0 = V0v0_27 ) )
                                      & ( ( V5M_27 = fo__c_2Ebinary__ieee_2EEQ )
                                       => ( V7v1 = V1v1_27 ) )
                                      & ( ( V5M_27 = fo__c_2Ebinary__ieee_2EGT )
                                       => ( V8v2 = V2v2_27 ) )
                                      & ( ( V5M_27 = fo__c_2Ebinary__ieee_2EUN )
                                       => ( V9v3 = V3v3_27 ) ) )
                                   => ( ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__compare__CASE(A_27a),inj__ty_2Ebinary__ieee_2Efloat__compare(V4M)),V6v0),V7v1),V8v2),V9v3) = ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__compare__CASE(A_27a),inj__ty_2Ebinary__ieee_2Efloat__compare(V5M_27)),V0v0_27),V1v1_27),V2v2_27),V3v3_27) ) ) ) ) ) ) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__compare__case__eq,axiom,
    ! [A_27a: del,V0x: tp__ty_2Ebinary__ieee_2Efloat__compare,V1v0: $i] :
      ( mem(V1v0,A_27a)
     => ! [V2v1: $i] :
          ( mem(V2v1,A_27a)
         => ! [V3v2: $i] :
              ( mem(V3v2,A_27a)
             => ! [V4v3: $i] :
                  ( mem(V4v3,A_27a)
                 => ! [V5v: $i] :
                      ( mem(V5v,A_27a)
                     => ( ( ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__compare__CASE(A_27a),inj__ty_2Ebinary__ieee_2Efloat__compare(V0x)),V1v0),V2v1),V3v2),V4v3) = V5v )
                      <=> ( ( ( V0x = fo__c_2Ebinary__ieee_2ELT )
                            & ( V1v0 = V5v ) )
                          | ( ( V0x = fo__c_2Ebinary__ieee_2EEQ )
                            & ( V2v1 = V5v ) )
                          | ( ( V0x = fo__c_2Ebinary__ieee_2EGT )
                            & ( V3v2 = V5v ) )
                          | ( ( V0x = fo__c_2Ebinary__ieee_2EUN )
                            & ( V4v3 = V5v ) ) ) ) ) ) ) ) ) ).

tff(lamtp_f3056,type,
    f3056: tp__ty_2Erealax_2Ereal > $i ).

tff(lameq_f3056,axiom,
    ! [V4r1: tp__ty_2Erealax_2Ereal,V5r2: tp__ty_2Erealax_2Ereal] : ( ap(f3056(V4r1),inj__ty_2Erealax_2Ereal(V5r2)) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat__compare),ap(ap(c_2Erealax_2Ereal__lt,inj__ty_2Erealax_2Ereal(V4r1)),inj__ty_2Erealax_2Ereal(V5r2))),inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2ELT)),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat__compare),ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),inj__ty_2Erealax_2Ereal(V4r1)),inj__ty_2Erealax_2Ereal(V5r2))),inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2EEQ)),inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2EGT))) ) ).

tff(lamtp_f3057,type,
    f3057: ( del * del * $i * tp__ty_2Ebinary__ieee_2Efloat__value ) > $i ).

tff(lameq_f3057,axiom,
    ! [A_27t: del,A_27w: del,V1y: $i] :
      ( mem(V1y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V3v1: tp__ty_2Ebinary__ieee_2Efloat__value,V4r1: tp__ty_2Erealax_2Ereal] : ( ap(f3057(A_27t,A_27w,V1y,V3v1),inj__ty_2Erealax_2Ereal(V4r1)) = ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Ebinary__ieee_2Efloat__compare),inj__ty_2Ebinary__ieee_2Efloat__value(V3v1)),f3056(V4r1)),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat__compare),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1y)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))))),inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2EGT)),inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2ELT))),inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2EUN)) ) ) ).

tff(lamtp_f3058,type,
    f3058: ( del * del * $i * $i * tp__ty_2Ebinary__ieee_2Efloat__value ) > $i ).

tff(lameq_f3058,axiom,
    ! [A_27t: del,A_27w: del,V1y: $i] :
      ( mem(V1y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V0x: $i] :
          ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V2v: tp__ty_2Ebinary__ieee_2Efloat__value,V3v1: tp__ty_2Ebinary__ieee_2Efloat__value] : ( ap(f3058(A_27t,A_27w,V1y,V0x,V2v),inj__ty_2Ebinary__ieee_2Efloat__value(V3v1)) = ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Ebinary__ieee_2Efloat__compare),inj__ty_2Ebinary__ieee_2Efloat__value(V2v)),f3057(A_27t,A_27w,V1y,V3v1)),ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Ebinary__ieee_2Efloat__compare),inj__ty_2Ebinary__ieee_2Efloat__value(V3v1)),k(ty_2Erealax_2Ereal,ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat__compare),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V0x)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))))),inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2ELT)),inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2EGT)))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat__compare),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V0x)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1y))),inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2EEQ)),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat__compare),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V0x)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))))),inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2ELT)),inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2EGT)))),inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2EUN))),inj__ty_2Ebinary__ieee_2Efloat__compare(fo__c_2Ebinary__ieee_2EUN)) ) ) ) ).

tff(lamtp_f3059,type,
    f3059: ( del * del * $i * $i ) > $i ).

tff(lameq_f3059,axiom,
    ! [A_27w: del,A_27t: del,V1y: $i] :
      ( mem(V1y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V0x: $i] :
          ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V2v: tp__ty_2Ebinary__ieee_2Efloat__value] : ( ap(f3059(A_27w,A_27t,V1y,V0x),inj__ty_2Ebinary__ieee_2Efloat__value(V2v)) = f3058(A_27t,A_27w,V1y,V0x,V2v) ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__compare__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V1y: $i] :
          ( mem(V1y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ( surj__ty_2Ebinary__ieee_2Efloat__compare(ap(ap(c_2Ebinary__ieee_2Efloat__compare(A_27t,A_27w),V0x),V1y)) = surj__ty_2Ebinary__ieee_2Efloat__compare(ap(ap(c_2Epair_2Epair__CASE(ty_2Ebinary__ieee_2Efloat__compare,ty_2Ebinary__ieee_2Efloat__value,ty_2Ebinary__ieee_2Efloat__value),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat__value,ty_2Ebinary__ieee_2Efloat__value),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V0x)),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V1y))),f3059(A_27w,A_27t,V1y,V0x))) ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__less__than__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V1y: $i] :
          ( mem(V1y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ( p(ap(ap(c_2Ebinary__ieee_2Efloat__less__than(A_27t,A_27w),V0x),V1y))
          <=> ( surj__ty_2Ebinary__ieee_2Efloat__compare(ap(ap(c_2Ebinary__ieee_2Efloat__compare(A_27t,A_27w),V0x),V1y)) = fo__c_2Ebinary__ieee_2ELT ) ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__less__equal__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V1y: $i] :
          ( mem(V1y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ( p(ap(ap(c_2Ebinary__ieee_2Efloat__less__equal(A_27t,A_27w),V0x),V1y))
          <=> p(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__compare__CASE(bool),ap(ap(c_2Ebinary__ieee_2Efloat__compare(A_27t,A_27w),V0x),V1y)),inj__o(fo__c_2Ebool_2ET)),inj__o(fo__c_2Ebool_2ET)),inj__o(fo__c_2Ebool_2EF)),inj__o(fo__c_2Ebool_2EF))) ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__greater__than__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V1y: $i] :
          ( mem(V1y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ( p(ap(ap(c_2Ebinary__ieee_2Efloat__greater__than(A_27t,A_27w),V0x),V1y))
          <=> ( surj__ty_2Ebinary__ieee_2Efloat__compare(ap(ap(c_2Ebinary__ieee_2Efloat__compare(A_27t,A_27w),V0x),V1y)) = fo__c_2Ebinary__ieee_2EGT ) ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__greater__equal__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V1y: $i] :
          ( mem(V1y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ( p(ap(ap(c_2Ebinary__ieee_2Efloat__greater__equal(A_27t,A_27w),V0x),V1y))
          <=> p(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__compare__CASE(bool),ap(ap(c_2Ebinary__ieee_2Efloat__compare(A_27t,A_27w),V0x),V1y)),inj__o(fo__c_2Ebool_2EF)),inj__o(fo__c_2Ebool_2ET)),inj__o(fo__c_2Ebool_2ET)),inj__o(fo__c_2Ebool_2EF))) ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Efloat__equal__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V1y: $i] :
          ( mem(V1y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ( p(ap(ap(c_2Ebinary__ieee_2Efloat__equal(A_27t,A_27w),V0x),V1y))
          <=> ( surj__ty_2Ebinary__ieee_2Efloat__compare(ap(ap(c_2Ebinary__ieee_2Efloat__compare(A_27t,A_27w),V0x),V1y)) = fo__c_2Ebinary__ieee_2EEQ ) ) ) ) ).

tff(ax_thm_2Ebinary__ieee_2Eexponent__boundary__def,axiom,
    ! [A_27t: del,A_27w: del,V0y: $i] :
      ( mem(V0y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V1x: $i] :
          ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ( p(ap(ap(c_2Ebinary__ieee_2Eexponent__boundary(A_27t,A_27w),V0y),V1x))
          <=> ( ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)) = surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V0y)) )
              & ( surj__ty_2Enum_2Enum(ap(c_2Ewords_2Ew2n(A_27w),ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),V1x))) = surj__ty_2Enum_2Enum(ap(ap(c_2Earithmetic_2E_2B,ap(c_2Ewords_2Ew2n(A_27w),ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),V0y))),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))) )
              & ( ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),V1x) != ap(c_2Ewords_2En2w(A_27w),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))) )
              & ( ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),V0y) = ap(c_2Ewords_2Eword__2comp(A_27t),ap(c_2Ewords_2En2w(A_27t),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))) )
              & ( ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),V1x) = ap(c_2Ewords_2En2w(A_27t),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)) ) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Ezero__lt__twopow,axiom,
    ! [V0n: tp__ty_2Enum_2Enum] : p(ap(ap(c_2Erealax_2Ereal__lt,ap(c_2Ereal_2Ereal__of__num,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0))),ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),inj__ty_2Enum_2Enum(V0n)))) ).

tff(conj_thm_2Ebinary__ieee_2Ezero__le__twopow,axiom,
    ! [V0n: tp__ty_2Enum_2Enum] : p(ap(ap(c_2Ereal_2Ereal__lte,ap(c_2Ereal_2Ereal__of__num,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0))),ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),inj__ty_2Enum_2Enum(V0n)))) ).

tff(conj_thm_2Ebinary__ieee_2Ezero__neq__twopow,axiom,
    ! [V0n: tp__ty_2Enum_2Enum] : ( surj__ty_2Erealax_2Ereal(ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),inj__ty_2Enum_2Enum(V0n))) != surj__ty_2Erealax_2Ereal(ap(c_2Ereal_2Ereal__of__num,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0))) ) ).

tff(conj_thm_2Ebinary__ieee_2Ezero__le__pos__div__twopow,axiom,
    ! [V0m: tp__ty_2Enum_2Enum,V1n: tp__ty_2Enum_2Enum] : p(ap(ap(c_2Ereal_2Ereal__lte,ap(c_2Ereal_2Ereal__of__num,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0))),ap(ap(c_2Ereal_2E_2F,ap(c_2Ereal_2Ereal__of__num,inj__ty_2Enum_2Enum(V0m))),ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),inj__ty_2Enum_2Enum(V1n))))) ).

tff(conj_thm_2Ebinary__ieee_2Ediv__eq0,axiom,
    ! [V0a: tp__ty_2Erealax_2Ereal,V1b: tp__ty_2Erealax_2Ereal] :
      ( p(ap(ap(c_2Erealax_2Ereal__lt,ap(c_2Ereal_2Ereal__of__num,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0))),inj__ty_2Erealax_2Ereal(V1b)))
     => ( ( surj__ty_2Erealax_2Ereal(ap(ap(c_2Ereal_2E_2F,inj__ty_2Erealax_2Ereal(V0a)),inj__ty_2Erealax_2Ereal(V1b))) = surj__ty_2Erealax_2Ereal(ap(c_2Ereal_2Ereal__of__num,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0))) )
      <=> ( V0a = surj__ty_2Erealax_2Ereal(ap(c_2Ereal_2Ereal__of__num,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0))) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Eexp__ge2,axiom,
    ! [V0b: tp__ty_2Enum_2Enum] :
      ( p(ap(ap(c_2Earithmetic_2E_3C_3D,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))),ap(ap(c_2Earithmetic_2EEXP,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))),inj__ty_2Enum_2Enum(V0b))))
    <=> p(ap(ap(c_2Earithmetic_2E_3C_3D,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))),inj__ty_2Enum_2Enum(V0b))) ) ).

tff(conj_thm_2Ebinary__ieee_2Eexp__gt2,axiom,
    ! [V0b: tp__ty_2Enum_2Enum] :
      ( p(ap(ap(c_2Eprim__rec_2E_3C,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))),ap(ap(c_2Earithmetic_2EEXP,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))),inj__ty_2Enum_2Enum(V0b))))
    <=> p(ap(ap(c_2Eprim__rec_2E_3C,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))),inj__ty_2Enum_2Enum(V0b))) ) ).

tff(conj_thm_2Ebinary__ieee_2Ele2,axiom,
    ! [V0n: tp__ty_2Erealax_2Ereal,V1m: tp__ty_2Erealax_2Ereal] :
      ( ( p(ap(ap(c_2Ereal_2Ereal__lte,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),inj__ty_2Erealax_2Ereal(V0n)))
        & p(ap(ap(c_2Ereal_2Ereal__lte,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),inj__ty_2Erealax_2Ereal(V1m))) )
     => p(ap(ap(c_2Ereal_2Ereal__lte,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),ap(ap(c_2Erealax_2Ereal__mul,inj__ty_2Erealax_2Ereal(V0n)),inj__ty_2Erealax_2Ereal(V1m)))) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__components,axiom,
    ! [A_27a: del,A_27b: del,A_27c: del,A_27d: del,A_27e: del,A_27f: del,A_27g: del,A_27h: del,A_27i: del,A_27j: del,A_27t: del,A_27w: del] :
      ( ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) = surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(ap(c_2Ewords_2En2w(ty_2Eone_2Eone),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0))) )
      & ( ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = c_2Ewords_2Eword__T(A_27w) )
      & ( ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ewords_2En2w(A_27t),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)) )
      & ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) = surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))) )
      & ( ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = c_2Ewords_2Eword__T(A_27w) )
      & ( ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ewords_2En2w(A_27t),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)) )
      & ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) = surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(ap(c_2Ewords_2En2w(ty_2Eone_2Eone),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0))) )
      & ( ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ewords_2En2w(A_27w),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)) )
      & ( ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ewords_2En2w(A_27t),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)) )
      & ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) = surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))) )
      & ( ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ewords_2En2w(A_27w),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)) )
      & ( ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ewords_2En2w(A_27t),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)) )
      & ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) = surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(ap(c_2Ewords_2En2w(ty_2Eone_2Eone),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0))) )
      & ( ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ewords_2En2w(A_27w),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)) )
      & ( ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ewords_2En2w(A_27t),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))) )
      & ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) = surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))) )
      & ( ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ewords_2En2w(A_27w),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)) )
      & ( ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ewords_2En2w(A_27t),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))) )
      & ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) = surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(ap(c_2Ewords_2En2w(ty_2Eone_2Eone),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0))) )
      & ( ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(ap(c_2Ewords_2Eword__sub(A_27w),c_2Ewords_2Eword__T(A_27w)),ap(c_2Ewords_2En2w(A_27w),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))) )
      & ( ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = c_2Ewords_2Eword__T(A_27t) )
      & ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) = surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))) )
      & ( ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(ap(c_2Ewords_2Eword__sub(A_27w),c_2Ewords_2Eword__T(A_27w)),ap(c_2Ewords_2En2w(A_27w),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))) )
      & ( ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = c_2Ewords_2Eword__T(A_27t) )
      & ! [V0fp__op: $i] :
          ( mem(V0fp__op,ty_2Ebinary__ieee_2Efp__op(A_27a,A_27b))
         => ( ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27a,A_27b),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27a,A_27b),V0fp__op)) = c_2Ewords_2Eword__T(A_27b) ) )
      & ! [V1fp__op: $i] :
          ( mem(V1fp__op,ty_2Ebinary__ieee_2Efp__op(A_27c,A_27d))
         => ( ap(c_2Ebinary__ieee_2Efloat__Significand(A_27c,A_27d),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27c,A_27d),V1fp__op)) != ap(c_2Ewords_2En2w(A_27c),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)) ) )
      & ! [V2x: $i] :
          ( mem(V2x,ty_2Ebinary__ieee_2Efloat(A_27e,A_27f))
         => ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(ap(c_2Ebinary__ieee_2Efloat__Sign(A_27e,A_27f),ap(c_2Ebinary__ieee_2Efloat__negate(A_27e,A_27f),V2x))) = surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(ap(c_2Ewords_2Eword__1comp(ty_2Eone_2Eone),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27e,A_27f),V2x))) ) )
      & ! [V3x: $i] :
          ( mem(V3x,ty_2Ebinary__ieee_2Efloat(A_27g,A_27h))
         => ( ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27g,A_27h),ap(c_2Ebinary__ieee_2Efloat__negate(A_27g,A_27h),V3x)) = ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27g,A_27h),V3x) ) )
      & ! [V4x: $i] :
          ( mem(V4x,ty_2Ebinary__ieee_2Efloat(A_27i,A_27j))
         => ( ap(c_2Ebinary__ieee_2Efloat__Significand(A_27i,A_27j),ap(c_2Ebinary__ieee_2Efloat__negate(A_27i,A_27j),V4x)) = ap(c_2Ebinary__ieee_2Efloat__Significand(A_27i,A_27j),V4x) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__distinct,axiom,
    ! [A_27a: del,A_27b: del,A_27t: del,A_27w: del] :
      ( ( ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) )
      & ( ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) )
      & ( ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) )
      & ( ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) )
      & ( ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) )
      & ( ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) )
      & ( ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) )
      & ! [V0fp__op: $i] :
          ( mem(V0fp__op,ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))
         => ( ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),V0fp__op) ) )
      & ( ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) )
      & ( ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) )
      & ( ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) )
      & ( ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) )
      & ( ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) )
      & ( ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) )
      & ! [V1fp__op: $i] :
          ( mem(V1fp__op,ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))
         => ( ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),V1fp__op) ) )
      & ( ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) )
      & ( ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) )
      & ( ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) )
      & ( ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) )
      & ( ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) )
      & ! [V2fp__op: $i] :
          ( mem(V2fp__op,ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))
         => ( ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),V2fp__op) ) )
      & ( ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) )
      & ( ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) )
      & ( ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) )
      & ( ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) )
      & ! [V3fp__op: $i] :
          ( mem(V3fp__op,ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))
         => ( ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),V3fp__op) ) )
      & ( ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) )
      & ( ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) )
      & ! [V4fp__op: $i] :
          ( mem(V4fp__op,ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))
         => ( ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),V4fp__op) ) )
      & ( ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) )
      & ! [V5fp__op: $i] :
          ( mem(V5fp__op,ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))
         => ( ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),V5fp__op) ) )
      & ! [V6fp__op: $i] :
          ( mem(V6fp__op,ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))
         => ( ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),V6fp__op) ) )
      & ( ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) )
      & ! [V7fp__op: $i] :
          ( mem(V7fp__op,ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))
         => ( ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),V7fp__op) ) )
      & ! [V8x: $i] :
          ( mem(V8x,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b))
         => ( ap(c_2Ebinary__ieee_2Efloat__negate(A_27a,A_27b),V8x) != V8x ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__values,axiom,
    ! [A_27a: del,A_27b: del,A_27t: del,A_27w: del] :
      ( ( surj__ty_2Ebinary__ieee_2Efloat__value(ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) = fo__c_2Ebinary__ieee_2EInfinity )
      & ( surj__ty_2Ebinary__ieee_2Efloat__value(ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) = fo__c_2Ebinary__ieee_2EInfinity )
      & ! [V0fp__op: $i] :
          ( mem(V0fp__op,ty_2Ebinary__ieee_2Efp__op(A_27a,A_27b))
         => ( surj__ty_2Ebinary__ieee_2Efloat__value(ap(c_2Ebinary__ieee_2Efloat__value(A_27a,A_27b),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27a,A_27b),V0fp__op))) = fo__c_2Ebinary__ieee_2ENaN ) )
      & ( surj__ty_2Ebinary__ieee_2Efloat__value(ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) = surj__ty_2Ebinary__ieee_2Efloat__value(ap(c_2Ebinary__ieee_2EFloat,ap(c_2Ereal_2Ereal__of__num,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))) )
      & ( surj__ty_2Ebinary__ieee_2Efloat__value(ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) = surj__ty_2Ebinary__ieee_2Efloat__value(ap(c_2Ebinary__ieee_2EFloat,ap(c_2Ereal_2Ereal__of__num,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))) )
      & ( surj__ty_2Ebinary__ieee_2Efloat__value(ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) = surj__ty_2Ebinary__ieee_2Efloat__value(ap(c_2Ebinary__ieee_2EFloat,ap(ap(c_2Ereal_2E_2F,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),ap(ap(c_2Earithmetic_2E_2B,ap(c_2Ewords_2EINT__MAX(A_27w),c_2Ebool_2Ethe__value(A_27w))),ap(c_2Efcp_2Edimindex(A_27t),c_2Ebool_2Ethe__value(A_27t))))))) )
      & ( surj__ty_2Ebinary__ieee_2Efloat__value(ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) = surj__ty_2Ebinary__ieee_2Efloat__value(ap(c_2Ebinary__ieee_2EFloat,ap(ap(c_2Ereal_2E_2F,ap(c_2Erealax_2Ereal__neg,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))))),ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),ap(ap(c_2Earithmetic_2E_2B,ap(c_2Ewords_2EINT__MAX(A_27w),c_2Ebool_2Ethe__value(A_27w))),ap(c_2Efcp_2Edimindex(A_27t),c_2Ebool_2Ethe__value(A_27t))))))) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Ezero__to__real,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ( surj__ty_2Erealax_2Ereal(ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) = surj__ty_2Erealax_2Ereal(ap(c_2Ereal_2Ereal__of__num,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0))) )
      & ( surj__ty_2Erealax_2Ereal(ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) = surj__ty_2Erealax_2Ereal(ap(c_2Ereal_2Ereal__of__num,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0))) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Esign__not__zero,axiom,
    ! [V0s: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone] : ( surj__ty_2Erealax_2Ereal(ap(ap(c_2Ereal_2Epow,ap(c_2Erealax_2Ereal__neg,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))))),ap(c_2Ewords_2Ew2n(ty_2Eone_2Eone),inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone(V0s)))) != surj__ty_2Erealax_2Ereal(ap(c_2Ereal_2Ereal__of__num,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0))) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__sets,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ( c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w) = ap(ap(c_2Epred__set_2EINSERT(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(c_2Epred__set_2EINSERT(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),c_2Epred__set_2EEMPTY(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))) )
      & ( c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w) = ap(ap(c_2Epred__set_2EINSERT(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(c_2Epred__set_2EINSERT(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),c_2Epred__set_2EEMPTY(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Einfinity__properties,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ~ p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__integral(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__integral(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) ) ).

tff(conj_thm_2Ebinary__ieee_2Ezero__properties,axiom,
    ! [A_27t: del,A_27w: del] :
      ( p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & p(ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & p(ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & p(ap(c_2Ebinary__ieee_2Efloat__is__integral(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & p(ap(c_2Ebinary__ieee_2Efloat__is__integral(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) ) ).

tff(conj_thm_2Ebinary__ieee_2Esome__nan__properties,axiom,
    ! [A_27a: del,A_27b: del,V0fp__op: $i] :
      ( mem(V0fp__op,ty_2Ebinary__ieee_2Efp__op(A_27a,A_27b))
     => ( ~ p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27a,A_27b),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27a,A_27b),V0fp__op)))
        & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27a,A_27b),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27a,A_27b),V0fp__op)))
        & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__integral(A_27a,A_27b),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27a,A_27b),V0fp__op)))
        & p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27a,A_27b),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27a,A_27b),V0fp__op)))
        & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__signalling(A_27a,A_27b),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27a,A_27b),V0fp__op)))
        & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27a,A_27b),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27a,A_27b),V0fp__op)))
        & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27a,A_27b),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27a,A_27b),V0fp__op)))
        & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27a,A_27b),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27a,A_27b),V0fp__op))) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Emin__properties,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ~ p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & p(ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & ( p(ap(c_2Ebinary__ieee_2Efloat__is__integral(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      <=> ( ( surj__ty_2Enum_2Enum(ap(c_2Efcp_2Edimindex(A_27w),c_2Ebool_2Ethe__value(A_27w))) = surj__ty_2Enum_2Enum(ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))) )
          & ( surj__ty_2Enum_2Enum(ap(c_2Efcp_2Edimindex(A_27t),c_2Ebool_2Ethe__value(A_27t))) = surj__ty_2Enum_2Enum(ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))) ) ) )
      & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & p(ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & ( p(ap(c_2Ebinary__ieee_2Efloat__is__integral(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      <=> ( ( surj__ty_2Enum_2Enum(ap(c_2Efcp_2Edimindex(A_27w),c_2Ebool_2Ethe__value(A_27w))) = surj__ty_2Enum_2Enum(ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))) )
          & ( surj__ty_2Enum_2Enum(ap(c_2Efcp_2Edimindex(A_27t),c_2Ebool_2Ethe__value(A_27t))) = surj__ty_2Enum_2Enum(ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))) ) ) )
      & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) ) ).

tff(conj_thm_2Ebinary__ieee_2Etop__properties,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ~ p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & p(ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & ( p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      <=> ( surj__ty_2Enum_2Enum(ap(c_2Efcp_2Edimindex(A_27w),c_2Ebool_2Ethe__value(A_27w))) != surj__ty_2Enum_2Enum(ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))) ) )
      & ( p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      <=> ( surj__ty_2Enum_2Enum(ap(c_2Efcp_2Edimindex(A_27w),c_2Ebool_2Ethe__value(A_27w))) = surj__ty_2Enum_2Enum(ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))) ) )
      & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) ) ).

tff(conj_thm_2Ebinary__ieee_2Ebottom__properties,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ~ p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & p(ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      & ( p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      <=> ( surj__ty_2Enum_2Enum(ap(c_2Efcp_2Edimindex(A_27w),c_2Ebool_2Ethe__value(A_27w))) != surj__ty_2Enum_2Enum(ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))) ) )
      & ( p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
      <=> ( surj__ty_2Enum_2Enum(ap(c_2Efcp_2Edimindex(A_27w),c_2Ebool_2Ethe__value(A_27w))) = surj__ty_2Enum_2Enum(ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))) ) )
      & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__is__zero,axiom,
    ! [A_27a: del,A_27b: del,V0x: $i] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b))
     => ( p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27a,A_27b),V0x))
      <=> ( ( ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27a,A_27b),V0x) = ap(c_2Ewords_2En2w(A_27b),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)) )
          & ( ap(c_2Ebinary__ieee_2Efloat__Significand(A_27a,A_27b),V0x) = ap(c_2Ewords_2En2w(A_27a),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__is__finite,axiom,
    ! [A_27a: del,A_27b: del,V0x: $i] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b))
     => ( p(ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27a,A_27b),V0x))
      <=> ( p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27a,A_27b),V0x))
          | p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27a,A_27b),V0x))
          | p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27a,A_27b),V0x)) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__cases__finite,axiom,
    ! [A_27a: del,A_27b: del,V0x: $i] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b))
     => ( p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27a,A_27b),V0x))
        | p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27a,A_27b),V0x))
        | p(ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27a,A_27b),V0x)) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__distinct__finite,axiom,
    ! [A_27a: del,A_27b: del,V0x: $i] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b))
     => ( ~ ( p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27a,A_27b),V0x))
            & p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27a,A_27b),V0x)) )
        & ~ ( p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27a,A_27b),V0x))
            & p(ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27a,A_27b),V0x)) )
        & ~ ( p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27a,A_27b),V0x))
            & p(ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27a,A_27b),V0x)) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__cases,axiom,
    ! [A_27a: del,A_27b: del,V0x: $i] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b))
     => ( p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27a,A_27b),V0x))
        | p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27a,A_27b),V0x))
        | p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27a,A_27b),V0x))
        | p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27a,A_27b),V0x))
        | p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27a,A_27b),V0x)) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__is__distinct,axiom,
    ! [A_27a: del,A_27b: del,V0x: $i] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b))
     => ( ~ ( p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27a,A_27b),V0x))
            & p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27a,A_27b),V0x)) )
        & ~ ( p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27a,A_27b),V0x))
            & p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27a,A_27b),V0x)) )
        & ~ ( p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27a,A_27b),V0x))
            & p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27a,A_27b),V0x)) )
        & ~ ( p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27a,A_27b),V0x))
            & p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27a,A_27b),V0x)) )
        & ~ ( p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27a,A_27b),V0x))
            & p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27a,A_27b),V0x)) )
        & ~ ( p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27a,A_27b),V0x))
            & p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27a,A_27b),V0x)) )
        & ~ ( p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27a,A_27b),V0x))
            & p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27a,A_27b),V0x)) )
        & ~ ( p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27a,A_27b),V0x))
            & p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27a,A_27b),V0x)) )
        & ~ ( p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27a,A_27b),V0x))
            & p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27a,A_27b),V0x)) )
        & ~ ( p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27a,A_27b),V0x))
            & p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27a,A_27b),V0x)) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__infinities,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ( p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V0x))
      <=> ( ( V0x = ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) )
          | ( V0x = ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) ) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__infinities__distinct,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ~ ( ( V0x = ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) )
          & ( V0x = ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) ) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__to__real__negate,axiom,
    ! [A_27a: del,A_27b: del,V0x: $i] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b))
     => ( surj__ty_2Erealax_2Ereal(ap(c_2Ebinary__ieee_2Efloat__to__real(A_27a,A_27b),ap(c_2Ebinary__ieee_2Efloat__negate(A_27a,A_27b),V0x))) = surj__ty_2Erealax_2Ereal(ap(c_2Erealax_2Ereal__neg,ap(c_2Ebinary__ieee_2Efloat__to__real(A_27a,A_27b),V0x))) ) ) ).

tff(conj_thm_2Ebinary__ieee_2Efloat__negate__negate,axiom,
    ! [A_27a: del,A_27b: del,V0x: $i] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b))
     => ( ap(c_2Ebinary__ieee_2Efloat__negate(A_27a,A_27b),ap(c_2Ebinary__ieee_2Efloat__negate(A_27a,A_27b),V0x)) = V0x ) ) ).

tff(conj_thm_2Ebinary__ieee_2Eulp,axiom,
    ! [A_27t: del,A_27w: del] : ( surj__ty_2Erealax_2Ereal(ap(c_2Ebinary__ieee_2Eulp(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = surj__ty_2Erealax_2Ereal(ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) ) ).

tff(conj_thm_2Ebinary__ieee_2Eneg__ulp,conjecture,
    ! [A_27t: del,A_27w: del] : ( surj__ty_2Erealax_2Ereal(ap(c_2Erealax_2Ereal__neg,ap(c_2Ebinary__ieee_2Eulp(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) = surj__ty_2Erealax_2Ereal(ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__negate(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))) ) ).

%------------------------------------------------------------------------------
