%------------------------------------------------------------------------------
% File     : ITP018+5 : TPTP v9.2.0. Bugfixed v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : HOL4 set theory export of thm_2Ebinary__ieee_2Eneg__ulp.p, chainy mode
% Version  : [BG+19] axioms.
% English  :

% Refs     : [BG+19] Brown et al. (2019), GRUNGE: A Grand Unified ATP Chall
%          : [Gau20] Gauthier (2020), Email to Geoff Sutcliffe
% Source   : [BG+19]
% Names    : thm_2Ebinary__ieee_2Eneg__ulp.p [Gau20]
%          : HL408501+5.p [TPAP]

% Status   : Theorem
% Rating   : 0.91 v9.1.0, 0.94 v9.0.0, 0.92 v8.2.0, 0.94 v8.1.0, 0.86 v7.5.0
% Syntax   : Number of formulae    : 16279 (1406 unt;   0 def)
%            Number of atoms       : 105217 (17924 equ)
%            Maximal formula atoms : 5765 (   6 avg)
%            Number of connectives : 90844 (1906   ~; 871   |;24808   &)
%                                         (5505 <=>;57754  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  363 (   8 avg)
%            Maximal term depth    :  130 (   2 avg)
%            Number of predicates  :    6 (   3 usr;   2 prp; 0-2 aty)
%            Number of functors    : 5094 (5094 usr; 830 con; 0-11 aty)
%            Number of variables   : 71399 (57688   !;13711   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments :
% Bugfixes : v7.5.0 - Bugfixes in axioms and export.
%------------------------------------------------------------------------------
include('Axioms/ITP001/ITP001+2.ax').
include('Axioms/ITP001/ITP002+5.ax').
include('Axioms/ITP001/ITP003+5.ax').
include('Axioms/ITP001/ITP004+5.ax').
include('Axioms/ITP001/ITP007+5.ax').
include('Axioms/ITP001/ITP006+5.ax').
include('Axioms/ITP001/ITP005+5.ax').
include('Axioms/ITP001/ITP008+5.ax').
include('Axioms/ITP001/ITP009+5.ax').
include('Axioms/ITP001/ITP010+5.ax').
include('Axioms/ITP001/ITP012+5.ax').
include('Axioms/ITP001/ITP011+5.ax').
include('Axioms/ITP001/ITP013+5.ax').
include('Axioms/ITP001/ITP014+5.ax').
include('Axioms/ITP001/ITP015+5.ax').
include('Axioms/ITP001/ITP017+5.ax').
include('Axioms/ITP001/ITP016+5.ax').
include('Axioms/ITP001/ITP019+5.ax').
include('Axioms/ITP001/ITP018+5.ax').
include('Axioms/ITP001/ITP021+5.ax').
include('Axioms/ITP001/ITP022+5.ax').
include('Axioms/ITP001/ITP020+5.ax').
include('Axioms/ITP001/ITP024+5.ax').
include('Axioms/ITP001/ITP023+5.ax').
include('Axioms/ITP001/ITP025+5.ax').
include('Axioms/ITP001/ITP026+5.ax').
include('Axioms/ITP001/ITP027+5.ax').
include('Axioms/ITP001/ITP028+5.ax').
include('Axioms/ITP001/ITP031+5.ax').
include('Axioms/ITP001/ITP029+5.ax').
include('Axioms/ITP001/ITP033+5.ax').
include('Axioms/ITP001/ITP030+5.ax').
include('Axioms/ITP001/ITP032+5.ax').
include('Axioms/ITP001/ITP038+5.ax').
include('Axioms/ITP001/ITP035+5.ax').
include('Axioms/ITP001/ITP034+5.ax').
include('Axioms/ITP001/ITP036+5.ax').
include('Axioms/ITP001/ITP037+5.ax').
include('Axioms/ITP001/ITP039+5.ax').
include('Axioms/ITP001/ITP041+5.ax').
include('Axioms/ITP001/ITP042+5.ax').
include('Axioms/ITP001/ITP040+5.ax').
include('Axioms/ITP001/ITP044+5.ax').
include('Axioms/ITP001/ITP051+5.ax').
include('Axioms/ITP001/ITP045+5.ax').
include('Axioms/ITP001/ITP056+5.ax').
include('Axioms/ITP001/ITP046+5.ax').
include('Axioms/ITP001/ITP043+5.ax').
include('Axioms/ITP001/ITP052+5.ax').
include('Axioms/ITP001/ITP057+5.ax').
include('Axioms/ITP001/ITP048+5.ax').
include('Axioms/ITP001/ITP047+5.ax').
include('Axioms/ITP001/ITP055+5.ax').
include('Axioms/ITP001/ITP053+5.ax').
include('Axioms/ITP001/ITP054+5.ax').
include('Axioms/ITP001/ITP058+5.ax').
include('Axioms/ITP001/ITP049+5.ax').
include('Axioms/ITP001/ITP050+5.ax').
include('Axioms/ITP001/ITP061+5.ax').
include('Axioms/ITP001/ITP069+5.ax').
include('Axioms/ITP001/ITP062+5.ax').
include('Axioms/ITP001/ITP068+5.ax').
include('Axioms/ITP001/ITP078+5.ax').
include('Axioms/ITP001/ITP064+5.ax').
include('Axioms/ITP001/ITP060+5.ax').
include('Axioms/ITP001/ITP067+5.ax').
include('Axioms/ITP001/ITP075+5.ax').
include('Axioms/ITP001/ITP074+5.ax').
include('Axioms/ITP001/ITP063+5.ax').
include('Axioms/ITP001/ITP059+5.ax').
include('Axioms/ITP001/ITP065+5.ax').
include('Axioms/ITP001/ITP076+5.ax').
include('Axioms/ITP001/ITP066+5.ax').
include('Axioms/ITP001/ITP077+5.ax').
include('Axioms/ITP001/ITP070+5.ax').
include('Axioms/ITP001/ITP071+5.ax').
include('Axioms/ITP001/ITP072+5.ax').
include('Axioms/ITP001/ITP073+5.ax').
include('Axioms/ITP001/ITP080+5.ax').
include('Axioms/ITP001/ITP083+5.ax').
include('Axioms/ITP001/ITP088+5.ax').
include('Axioms/ITP001/ITP082+5.ax').
include('Axioms/ITP001/ITP081+5.ax').
include('Axioms/ITP001/ITP079+5.ax').
include('Axioms/ITP001/ITP087+5.ax').
include('Axioms/ITP001/ITP085+5.ax').
include('Axioms/ITP001/ITP086+5.ax').
include('Axioms/ITP001/ITP090+5.ax').
include('Axioms/ITP001/ITP089+5.ax').
include('Axioms/ITP001/ITP084+5.ax').
include('Axioms/ITP001/ITP104+5.ax').
include('Axioms/ITP001/ITP097+5.ax').
include('Axioms/ITP001/ITP094+5.ax').
include('Axioms/ITP001/ITP095+5.ax').
include('Axioms/ITP001/ITP093+5.ax').
include('Axioms/ITP001/ITP102+5.ax').
include('Axioms/ITP001/ITP091+5.ax').
include('Axioms/ITP001/ITP098+5.ax').
include('Axioms/ITP001/ITP096+5.ax').
include('Axioms/ITP001/ITP100+5.ax').
include('Axioms/ITP001/ITP092+5.ax').
include('Axioms/ITP001/ITP105+5.ax').
include('Axioms/ITP001/ITP101+5.ax').
include('Axioms/ITP001/ITP103+5.ax').
include('Axioms/ITP001/ITP099+5.ax').
include('Axioms/ITP001/ITP111+5.ax').
include('Axioms/ITP001/ITP108+5.ax').
include('Axioms/ITP001/ITP106+5.ax').
include('Axioms/ITP001/ITP107+5.ax').
include('Axioms/ITP001/ITP114+5.ax').
include('Axioms/ITP001/ITP110+5.ax').
include('Axioms/ITP001/ITP109+5.ax').
include('Axioms/ITP001/ITP112+5.ax').
include('Axioms/ITP001/ITP113+5.ax').
include('Axioms/ITP001/ITP117+5.ax').
include('Axioms/ITP001/ITP116+5.ax').
include('Axioms/ITP001/ITP118+5.ax').
include('Axioms/ITP001/ITP120+5.ax').
include('Axioms/ITP001/ITP119+5.ax').
include('Axioms/ITP001/ITP121+5.ax').
include('Axioms/ITP001/ITP123+5.ax').
include('Axioms/ITP001/ITP124+5.ax').
include('Axioms/ITP001/ITP126+5.ax').
include('Axioms/ITP001/ITP127+5.ax').
include('Axioms/ITP001/ITP129+5.ax').
include('Axioms/ITP001/ITP128+5.ax').
include('Axioms/ITP001/ITP130+5.ax').
include('Axioms/ITP001/ITP131+5.ax').
include('Axioms/ITP001/ITP132+5.ax').
%------------------------------------------------------------------------------
fof(ne_ty_2Ebinary__ieee_2Eflags,axiom,
    ne(ty_2Ebinary__ieee_2Eflags) ).

fof(ne_ty_2Ebinary__ieee_2Efloat,axiom,
    ! [A0] :
      ( ne(A0)
     => ! [A1] :
          ( ne(A1)
         => ne(ty_2Ebinary__ieee_2Efloat(A0,A1)) ) ) ).

fof(ne_ty_2Ebinary__ieee_2Efloat__compare,axiom,
    ne(ty_2Ebinary__ieee_2Efloat__compare) ).

fof(ne_ty_2Ebinary__ieee_2Efloat__value,axiom,
    ne(ty_2Ebinary__ieee_2Efloat__value) ).

fof(ne_ty_2Ebinary__ieee_2Efp__op,axiom,
    ! [A0] :
      ( ne(A0)
     => ! [A1] :
          ( ne(A1)
         => ne(ty_2Ebinary__ieee_2Efp__op(A0,A1)) ) ) ).

fof(ne_ty_2Ebinary__ieee_2Erounding,axiom,
    ne(ty_2Ebinary__ieee_2Erounding) ).

fof(mem_c_2Ebinary__ieee_2EEQ,axiom,
    mem(c_2Ebinary__ieee_2EEQ,ty_2Ebinary__ieee_2Efloat__compare) ).

fof(mem_c_2Ebinary__ieee_2EFP__Add,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))))) ) ) ).

fof(mem_c_2Ebinary__ieee_2EFP__Div,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))))) ) ) ).

fof(mem_c_2Ebinary__ieee_2EFP__Mul,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))))) ) ) ).

fof(mem_c_2Ebinary__ieee_2EFP__MulAdd,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w)))))) ) ) ).

fof(mem_c_2Ebinary__ieee_2EFP__MulSub,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w)))))) ) ) ).

fof(mem_c_2Ebinary__ieee_2EFP__Sqrt,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w)))) ) ) ).

fof(mem_c_2Ebinary__ieee_2EFP__Sub,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))))) ) ) ).

fof(mem_c_2Ebinary__ieee_2EFloat,axiom,
    mem(c_2Ebinary__ieee_2EFloat,arr(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat__value)) ).

fof(mem_c_2Ebinary__ieee_2EGT,axiom,
    mem(c_2Ebinary__ieee_2EGT,ty_2Ebinary__ieee_2Efloat__compare) ).

fof(mem_c_2Ebinary__ieee_2EInfinity,axiom,
    mem(c_2Ebinary__ieee_2EInfinity,ty_2Ebinary__ieee_2Efloat__value) ).

fof(mem_c_2Ebinary__ieee_2ELT,axiom,
    mem(c_2Ebinary__ieee_2ELT,ty_2Ebinary__ieee_2Efloat__compare) ).

fof(mem_c_2Ebinary__ieee_2ENaN,axiom,
    mem(c_2Ebinary__ieee_2ENaN,ty_2Ebinary__ieee_2Efloat__value) ).

fof(mem_c_2Ebinary__ieee_2EULP,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2EULP(A_27t,A_27w),arr(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Ebool_2Eitself(A_27t)),ty_2Erealax_2Ereal)) ) ) ).

fof(mem_c_2Ebinary__ieee_2EUN,axiom,
    mem(c_2Ebinary__ieee_2EUN,ty_2Ebinary__ieee_2Efloat__compare) ).

fof(mem_c_2Ebinary__ieee_2Echeck__for__signalling,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27b] :
          ( ne(A_27b)
         => mem(c_2Ebinary__ieee_2Echeck__for__signalling(A_27a,A_27b),arr(ty_2Elist_2Elist(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b)),ty_2Ebinary__ieee_2Eflags)) ) ) ).

fof(mem_c_2Ebinary__ieee_2Eclear__flags,axiom,
    mem(c_2Ebinary__ieee_2Eclear__flags,ty_2Ebinary__ieee_2Eflags) ).

fof(mem_c_2Ebinary__ieee_2Eclosest,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27b] :
          ( ne(A_27b)
         => mem(c_2Ebinary__ieee_2Eclosest(A_27a,A_27b),arr(arr(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b),bool),arr(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b)))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Eclosest__such,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27b] :
          ( ne(A_27b)
         => mem(c_2Ebinary__ieee_2Eclosest__such(A_27a,A_27b),arr(arr(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b),bool),arr(arr(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b),bool),arr(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b))))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Edividezero__flags,axiom,
    mem(c_2Ebinary__ieee_2Edividezero__flags,ty_2Ebinary__ieee_2Eflags) ).

fof(mem_c_2Ebinary__ieee_2Eexponent__boundary,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Eexponent__boundary(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Eflags__CASE,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => mem(c_2Ebinary__ieee_2Eflags__CASE(A_27a),arr(ty_2Ebinary__ieee_2Eflags,arr(arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,A_27a)))))),A_27a))) ) ).

fof(mem_c_2Ebinary__ieee_2Eflags__DivideByZero,axiom,
    mem(c_2Ebinary__ieee_2Eflags__DivideByZero,arr(ty_2Ebinary__ieee_2Eflags,bool)) ).

fof(mem_c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,axiom,
    mem(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,arr(arr(bool,bool),arr(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags))) ).

fof(mem_c_2Ebinary__ieee_2Eflags__InvalidOp,axiom,
    mem(c_2Ebinary__ieee_2Eflags__InvalidOp,arr(ty_2Ebinary__ieee_2Eflags,bool)) ).

fof(mem_c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,axiom,
    mem(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,arr(arr(bool,bool),arr(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags))) ).

fof(mem_c_2Ebinary__ieee_2Eflags__Overflow,axiom,
    mem(c_2Ebinary__ieee_2Eflags__Overflow,arr(ty_2Ebinary__ieee_2Eflags,bool)) ).

fof(mem_c_2Ebinary__ieee_2Eflags__Overflow__fupd,axiom,
    mem(c_2Ebinary__ieee_2Eflags__Overflow__fupd,arr(arr(bool,bool),arr(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags))) ).

fof(mem_c_2Ebinary__ieee_2Eflags__Precision,axiom,
    mem(c_2Ebinary__ieee_2Eflags__Precision,arr(ty_2Ebinary__ieee_2Eflags,bool)) ).

fof(mem_c_2Ebinary__ieee_2Eflags__Precision__fupd,axiom,
    mem(c_2Ebinary__ieee_2Eflags__Precision__fupd,arr(arr(bool,bool),arr(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags))) ).

fof(mem_c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,axiom,
    mem(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,arr(ty_2Ebinary__ieee_2Eflags,bool)) ).

fof(mem_c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,axiom,
    mem(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,arr(arr(bool,bool),arr(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags))) ).

fof(mem_c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,axiom,
    mem(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,arr(ty_2Ebinary__ieee_2Eflags,bool)) ).

fof(mem_c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,axiom,
    mem(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,arr(arr(bool,bool),arr(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags))) ).

fof(mem_c_2Ebinary__ieee_2Eflags__size,axiom,
    mem(c_2Ebinary__ieee_2Eflags__size,arr(ty_2Ebinary__ieee_2Eflags,ty_2Enum_2Enum)) ).

fof(mem_c_2Ebinary__ieee_2Efloat__CASE,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27t] :
          ( ne(A_27t)
         => ! [A_27w] :
              ( ne(A_27w)
             => mem(c_2Ebinary__ieee_2Efloat__CASE(A_27a,A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),arr(ty_2Efcp_2Ecart(bool,A_27w),arr(ty_2Efcp_2Ecart(bool,A_27t),A_27a))),A_27a))) ) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__Exponent,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Efcp_2Ecart(bool,A_27w))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__Exponent__fupd,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [A_27x] :
              ( ne(A_27x)
             => mem(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),arr(arr(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27x)),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27x)))) ) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__Sign,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__Sign__fupd,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),arr(arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__Significand,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Efcp_2Ecart(bool,A_27t))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__Significand__fupd,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27u] :
          ( ne(A_27u)
         => ! [A_27w] :
              ( ne(A_27w)
             => mem(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),arr(arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27u)),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27u,A_27w)))) ) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__abs,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__abs(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__add,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__add(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__bottom,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),arr(ty_2Ebool_2Eitself(ty_2Epair_2Eprod(A_27t,A_27w)),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__compare,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__compare(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat__compare))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__compare2num,axiom,
    mem(c_2Ebinary__ieee_2Efloat__compare2num,arr(ty_2Ebinary__ieee_2Efloat__compare,ty_2Enum_2Enum)) ).

fof(mem_c_2Ebinary__ieee_2Efloat__compare__CASE,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => mem(c_2Ebinary__ieee_2Efloat__compare__CASE(A_27a),arr(ty_2Ebinary__ieee_2Efloat__compare,arr(A_27a,arr(A_27a,arr(A_27a,arr(A_27a,A_27a)))))) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__compare__size,axiom,
    mem(c_2Ebinary__ieee_2Efloat__compare__size,arr(ty_2Ebinary__ieee_2Efloat__compare,ty_2Enum_2Enum)) ).

fof(mem_c_2Ebinary__ieee_2Efloat__div,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__div(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__equal,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__equal(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__greater__equal,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__greater__equal(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__greater__than,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__greater__than(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__is__finite,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__is__finite(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool)) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__is__infinite,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool)) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__is__integral,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__is__integral(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool)) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__is__nan,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool)) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__is__normal,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__is__normal(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool)) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__is__signalling,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__is__signalling(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool)) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__is__subnormal,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool)) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__is__zero,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool)) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__less__equal,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__less__equal(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__less__than,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__less__than(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__minus__infinity,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),arr(ty_2Ebool_2Eitself(ty_2Epair_2Eprod(A_27t,A_27w)),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__minus__min,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),arr(ty_2Ebool_2Eitself(ty_2Epair_2Eprod(A_27t,A_27w)),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__minus__zero,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),arr(ty_2Ebool_2Eitself(ty_2Epair_2Eprod(A_27t,A_27w)),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__mul,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__mul(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__mul__add,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__mul__add(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__mul__sub,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__mul__sub(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__negate,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__negate(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__plus__infinity,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),arr(ty_2Ebool_2Eitself(ty_2Epair_2Eprod(A_27t,A_27w)),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__plus__min,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),arr(ty_2Ebool_2Eitself(ty_2Epair_2Eprod(A_27t,A_27w)),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__plus__zero,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),arr(ty_2Ebool_2Eitself(ty_2Epair_2Eprod(A_27t,A_27w)),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__round,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__round(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(bool,arr(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__round__to__integral,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__round__to__integral(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__round__with__flags,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__round__with__flags(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(bool,arr(ty_2Erealax_2Ereal,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__size,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),arr(arr(A_27t,ty_2Enum_2Enum),arr(arr(A_27w,ty_2Enum_2Enum),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Enum_2Enum)))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__some__qnan,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__sqrt,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__sqrt(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__sub,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__sub(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__to__int,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__to__int(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Eoption_2Eoption(ty_2Einteger_2Eint)))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__to__real,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Erealax_2Ereal)) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__top,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),arr(ty_2Ebool_2Eitself(ty_2Epair_2Eprod(A_27t,A_27w)),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__value,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat__value)) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__value__CASE,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => mem(c_2Ebinary__ieee_2Efloat__value__CASE(A_27a),arr(ty_2Ebinary__ieee_2Efloat__value,arr(arr(ty_2Erealax_2Ereal,A_27a),arr(A_27a,arr(A_27a,A_27a))))) ) ).

fof(mem_c_2Ebinary__ieee_2Efloat__value__size,axiom,
    mem(c_2Ebinary__ieee_2Efloat__value__size,arr(ty_2Ebinary__ieee_2Efloat__value,ty_2Enum_2Enum)) ).

fof(mem_c_2Ebinary__ieee_2Efp__op__CASE,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27t] :
          ( ne(A_27t)
         => ! [A_27w] :
              ( ne(A_27w)
             => mem(c_2Ebinary__ieee_2Efp__op__CASE(A_27a,A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w),arr(arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)),arr(arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))),arr(arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))),arr(arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))),arr(arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))),arr(arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))),arr(arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))),A_27a))))))))) ) ) ) ).

fof(mem_c_2Ebinary__ieee_2Efp__op__size,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Efp__op__size(A_27t,A_27w),arr(arr(A_27t,ty_2Enum_2Enum),arr(arr(A_27w,ty_2Enum_2Enum),arr(ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w),ty_2Enum_2Enum)))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Eintegral__round,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Eintegral__round(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Einvalidop__flags,axiom,
    mem(c_2Ebinary__ieee_2Einvalidop__flags,ty_2Ebinary__ieee_2Eflags) ).

fof(mem_c_2Ebinary__ieee_2Eis__closest,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27b] :
          ( ne(A_27b)
         => mem(c_2Ebinary__ieee_2Eis__closest(A_27a,A_27b),arr(arr(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b),bool),arr(ty_2Erealax_2Ereal,arr(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b),bool)))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Eis__integral,axiom,
    mem(c_2Ebinary__ieee_2Eis__integral,arr(ty_2Erealax_2Ereal,bool)) ).

fof(mem_c_2Ebinary__ieee_2Elargest,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Elargest(A_27t,A_27w),arr(ty_2Ebool_2Eitself(ty_2Epair_2Eprod(A_27t,A_27w)),ty_2Erealax_2Ereal)) ) ) ).

fof(mem_c_2Ebinary__ieee_2Enum2float__compare,axiom,
    mem(c_2Ebinary__ieee_2Enum2float__compare,arr(ty_2Enum_2Enum,ty_2Ebinary__ieee_2Efloat__compare)) ).

fof(mem_c_2Ebinary__ieee_2Enum2rounding,axiom,
    mem(c_2Ebinary__ieee_2Enum2rounding,arr(ty_2Enum_2Enum,ty_2Ebinary__ieee_2Erounding)) ).

fof(mem_c_2Ebinary__ieee_2Ereal__to__float,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27b] :
          ( ne(A_27b)
         => mem(c_2Ebinary__ieee_2Ereal__to__float(A_27a,A_27b),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b)))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Ereal__to__float__with__flags,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27b] :
          ( ne(A_27b)
         => mem(c_2Ebinary__ieee_2Ereal__to__float__with__flags(A_27a,A_27b),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Erealax_2Ereal,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b))))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Erecordtype_2Eflags,axiom,
    mem(c_2Ebinary__ieee_2Erecordtype_2Eflags,arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,ty_2Ebinary__ieee_2Eflags))))))) ).

fof(mem_c_2Ebinary__ieee_2Erecordtype_2Efloat,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),arr(ty_2Efcp_2Ecart(bool,A_27w),arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))) ) ) ).

fof(mem_c_2Ebinary__ieee_2Eround,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Eround(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))) ) ) ).

fof(mem_c_2Ebinary__ieee_2EroundTiesToEven,axiom,
    mem(c_2Ebinary__ieee_2EroundTiesToEven,ty_2Ebinary__ieee_2Erounding) ).

fof(mem_c_2Ebinary__ieee_2EroundTowardNegative,axiom,
    mem(c_2Ebinary__ieee_2EroundTowardNegative,ty_2Ebinary__ieee_2Erounding) ).

fof(mem_c_2Ebinary__ieee_2EroundTowardPositive,axiom,
    mem(c_2Ebinary__ieee_2EroundTowardPositive,ty_2Ebinary__ieee_2Erounding) ).

fof(mem_c_2Ebinary__ieee_2EroundTowardZero,axiom,
    mem(c_2Ebinary__ieee_2EroundTowardZero,ty_2Ebinary__ieee_2Erounding) ).

fof(mem_c_2Ebinary__ieee_2Erounding2num,axiom,
    mem(c_2Ebinary__ieee_2Erounding2num,arr(ty_2Ebinary__ieee_2Erounding,ty_2Enum_2Enum)) ).

fof(mem_c_2Ebinary__ieee_2Erounding__CASE,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => mem(c_2Ebinary__ieee_2Erounding__CASE(A_27a),arr(ty_2Ebinary__ieee_2Erounding,arr(A_27a,arr(A_27a,arr(A_27a,arr(A_27a,A_27a)))))) ) ).

fof(mem_c_2Ebinary__ieee_2Erounding__size,axiom,
    mem(c_2Ebinary__ieee_2Erounding__size,arr(ty_2Ebinary__ieee_2Erounding,ty_2Enum_2Enum)) ).

fof(mem_c_2Ebinary__ieee_2Ethreshold,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Ethreshold(A_27t,A_27w),arr(ty_2Ebool_2Eitself(ty_2Epair_2Eprod(A_27t,A_27w)),ty_2Erealax_2Ereal)) ) ) ).

fof(mem_c_2Ebinary__ieee_2Eulp,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => mem(c_2Ebinary__ieee_2Eulp(A_27t,A_27w),arr(ty_2Ebool_2Eitself(ty_2Epair_2Eprod(A_27t,A_27w)),ty_2Erealax_2Ereal)) ) ) ).

fof(lameq_f2917,axiom,
    ! [A_27w,A_27t,V8a1] :
      ( mem(V8a1,ty_2Efcp_2Ecart(bool,A_27w))
     => ! [V7a0] :
          ( mem(V7a0,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
         => ! [V9a2] : ap(f2917(A_27w,A_27t,V8a1,V7a0),V9a2) = ap(ap(ap(c_2Eind__type_2ECONSTR(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27t)))),c_2Enum_2E0),ap(ap(c_2Epair_2E_2C(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27t))),V7a0),ap(ap(c_2Epair_2E_2C(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27t)),V8a1),V9a2))),k(ty_2Enum_2Enum,c_2Eind__type_2EBOTTOM(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27t)))))) ) ) ).

fof(lameq_f2918,axiom,
    ! [A_27t,A_27w,V7a0] :
      ( mem(V7a0,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
     => ! [V8a1] : ap(f2918(A_27t,A_27w,V7a0),V8a1) = f2917(A_27w,A_27t,V8a1,V7a0) ) ).

fof(lameq_f2919,axiom,
    ! [A_27w,A_27t,V7a0] : ap(f2919(A_27w,A_27t),V7a0) = f2918(A_27t,A_27w,V7a0) ).

fof(lameq_f2920,axiom,
    ! [A_27w,A_27t,V4a0] :
      ( mem(V4a0,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
     => ! [V5a1] :
          ( mem(V5a1,ty_2Efcp_2Ecart(bool,A_27w))
         => ! [V3a0_27] :
              ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27t)))))
             => ! [V6a2] : ap(f2920(A_27w,A_27t,V4a0,V5a1,V3a0_27),V6a2) = ap(ap(c_2Emin_2E_3D(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27t))))),V3a0_27),ap(ap(ap(f2919(A_27w,A_27t),V4a0),V5a1),V6a2)) ) ) ) ).

fof(lameq_f2921,axiom,
    ! [A_27t,A_27w,V3a0_27] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27t)))))
     => ! [V4a0] :
          ( mem(V4a0,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
         => ! [V5a1] : ap(f2921(A_27t,A_27w,V3a0_27,V4a0),V5a1) = ap(c_2Ebool_2E_3F(ty_2Efcp_2Ecart(bool,A_27t)),f2920(A_27w,A_27t,V4a0,V5a1,V3a0_27)) ) ) ).

fof(lameq_f2922,axiom,
    ! [A_27w,A_27t,V3a0_27] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27t)))))
     => ! [V4a0] : ap(f2922(A_27w,A_27t,V3a0_27),V4a0) = ap(c_2Ebool_2E_3F(ty_2Efcp_2Ecart(bool,A_27w)),f2921(A_27t,A_27w,V3a0_27,V4a0)) ) ).

fof(lameq_f2923,axiom,
    ! [A_27w,A_27t,V2_27float_27] :
      ( mem(V2_27float_27,arr(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27t)))),bool))
     => ! [V3a0_27] : ap(f2923(A_27w,A_27t,V2_27float_27),V3a0_27) = ap(ap(c_2Emin_2E_3D_3D_3E,ap(c_2Ebool_2E_3F(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),f2922(A_27w,A_27t,V3a0_27))),ap(V2_27float_27,V3a0_27)) ) ).

fof(lameq_f2924,axiom,
    ! [A_27w,A_27t,V1a0_27] :
      ( mem(V1a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27t)))))
     => ! [V2_27float_27] : ap(f2924(A_27w,A_27t,V1a0_27),V2_27float_27) = ap(ap(c_2Emin_2E_3D_3D_3E,ap(c_2Ebool_2E_21(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27t))))),f2923(A_27w,A_27t,V2_27float_27))),ap(V2_27float_27,V1a0_27)) ) ).

fof(lameq_f2925,axiom,
    ! [A_27w,A_27t,V1a0_27] : ap(f2925(A_27w,A_27t),V1a0_27) = ap(c_2Ebool_2E_21(arr(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27t)))),bool)),f2924(A_27w,A_27t,V1a0_27)) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__TY__DEF,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ? [V0rep] :
              ( mem(V0rep,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27t))))))
              & p(ap(ap(c_2Ebool_2ETYPE__DEFINITION(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27t)))),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2925(A_27w,A_27t)),V0rep)) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__case__def,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27t] :
          ( ne(A_27t)
         => ! [A_27w] :
              ( ne(A_27w)
             => ! [V0a0] :
                  ( mem(V0a0,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
                 => ! [V1a1] :
                      ( mem(V1a1,ty_2Efcp_2Ecart(bool,A_27w))
                     => ! [V2a2] :
                          ( mem(V2a2,ty_2Efcp_2Ecart(bool,A_27t))
                         => ! [V3f] :
                              ( mem(V3f,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),arr(ty_2Efcp_2Ecart(bool,A_27w),arr(ty_2Efcp_2Ecart(bool,A_27t),A_27a))))
                             => ap(ap(c_2Ebinary__ieee_2Efloat__CASE(A_27a,A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),V0a0),V1a1),V2a2)),V3f) = ap(ap(ap(V3f,V0a0),V1a1),V2a2) ) ) ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__size__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0f] :
              ( mem(V0f,arr(A_27t,ty_2Enum_2Enum))
             => ! [V1f1] :
                  ( mem(V1f1,arr(A_27w,ty_2Enum_2Enum))
                 => ! [V2a0] :
                      ( mem(V2a0,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
                     => ! [V3a1] :
                          ( mem(V3a1,ty_2Efcp_2Ecart(bool,A_27w))
                         => ! [V4a2] :
                              ( mem(V4a2,ty_2Efcp_2Ecart(bool,A_27t))
                             => ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V0f),V1f1),ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),V2a0),V3a1),V4a2)) = ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)) ) ) ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__Sign,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0c] :
              ( mem(V0c,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
             => ! [V1c0] :
                  ( mem(V1c0,ty_2Efcp_2Ecart(bool,A_27w))
                 => ! [V2c1] :
                      ( mem(V2c1,ty_2Efcp_2Ecart(bool,A_27t))
                     => ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),V0c),V1c0),V2c1)) = V0c ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__Exponent,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0c] :
              ( mem(V0c,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
             => ! [V1c0] :
                  ( mem(V1c0,ty_2Efcp_2Ecart(bool,A_27w))
                 => ! [V2c1] :
                      ( mem(V2c1,ty_2Efcp_2Ecart(bool,A_27t))
                     => ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),V0c),V1c0),V2c1)) = V1c0 ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__Significand,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0c] :
              ( mem(V0c,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
             => ! [V1c0] :
                  ( mem(V1c0,ty_2Efcp_2Ecart(bool,A_27w))
                 => ! [V2c1] :
                      ( mem(V2c1,ty_2Efcp_2Ecart(bool,A_27t))
                     => ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),V0c),V1c0),V2c1)) = V2c1 ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__accessors,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ( ! [V0c] :
                ( mem(V0c,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
               => ! [V1c0] :
                    ( mem(V1c0,ty_2Efcp_2Ecart(bool,A_27w))
                   => ! [V2c1] :
                        ( mem(V2c1,ty_2Efcp_2Ecart(bool,A_27t))
                       => ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),V0c),V1c0),V2c1)) = V0c ) ) )
            & ! [V3c] :
                ( mem(V3c,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
               => ! [V4c0] :
                    ( mem(V4c0,ty_2Efcp_2Ecart(bool,A_27w))
                   => ! [V5c1] :
                        ( mem(V5c1,ty_2Efcp_2Ecart(bool,A_27t))
                       => ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),V3c),V4c0),V5c1)) = V4c0 ) ) )
            & ! [V6c] :
                ( mem(V6c,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
               => ! [V7c0] :
                    ( mem(V7c0,ty_2Efcp_2Ecart(bool,A_27w))
                   => ! [V8c1] :
                        ( mem(V8c1,ty_2Efcp_2Ecart(bool,A_27t))
                       => ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),V6c),V7c0),V8c1)) = V8c1 ) ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__Sign__fupd,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0f] :
              ( mem(V0f,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
             => ! [V1c] :
                  ( mem(V1c,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
                 => ! [V2c0] :
                      ( mem(V2c0,ty_2Efcp_2Ecart(bool,A_27w))
                     => ! [V3c1] :
                          ( mem(V3c1,ty_2Efcp_2Ecart(bool,A_27t))
                         => ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V0f),ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),V1c),V2c0),V3c1)) = ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),ap(V0f,V1c)),V2c0),V3c1) ) ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__Exponent__fupd,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [A_27x] :
              ( ne(A_27x)
             => ! [V0f] :
                  ( mem(V0f,arr(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27x)))
                 => ! [V1c] :
                      ( mem(V1c,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
                     => ! [V2c0] :
                          ( mem(V2c0,ty_2Efcp_2Ecart(bool,A_27w))
                         => ! [V3c1] :
                              ( mem(V3c1,ty_2Efcp_2Ecart(bool,A_27t))
                             => ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V0f),ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),V1c),V2c0),V3c1)) = ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27x),V1c),ap(V0f,V2c0)),V3c1) ) ) ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__Significand__fupd,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27u] :
          ( ne(A_27u)
         => ! [A_27w] :
              ( ne(A_27w)
             => ! [V0f] :
                  ( mem(V0f,arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27u)))
                 => ! [V1c] :
                      ( mem(V1c,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
                     => ! [V2c0] :
                          ( mem(V2c0,ty_2Efcp_2Ecart(bool,A_27w))
                         => ! [V3c1] :
                              ( mem(V3c1,ty_2Efcp_2Ecart(bool,A_27t))
                             => ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V0f),ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),V1c),V2c0),V3c1)) = ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27u,A_27w),V1c),V2c0),ap(V0f,V3c1)) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__fn__updates,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27u] :
          ( ne(A_27u)
         => ! [A_27w] :
              ( ne(A_27w)
             => ! [A_27x] :
                  ( ne(A_27x)
                 => ( ! [V0f] :
                        ( mem(V0f,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
                       => ! [V1c] :
                            ( mem(V1c,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
                           => ! [V2c0] :
                                ( mem(V2c0,ty_2Efcp_2Ecart(bool,A_27w))
                               => ! [V3c1] :
                                    ( mem(V3c1,ty_2Efcp_2Ecart(bool,A_27t))
                                   => ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V0f),ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),V1c),V2c0),V3c1)) = ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),ap(V0f,V1c)),V2c0),V3c1) ) ) ) )
                    & ! [V4f] :
                        ( mem(V4f,arr(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27x)))
                       => ! [V5c] :
                            ( mem(V5c,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
                           => ! [V6c0] :
                                ( mem(V6c0,ty_2Efcp_2Ecart(bool,A_27w))
                               => ! [V7c1] :
                                    ( mem(V7c1,ty_2Efcp_2Ecart(bool,A_27t))
                                   => ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V4f),ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),V5c),V6c0),V7c1)) = ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27x),V5c),ap(V4f,V6c0)),V7c1) ) ) ) )
                    & ! [V8f] :
                        ( mem(V8f,arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27u)))
                       => ! [V9c] :
                            ( mem(V9c,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
                           => ! [V10c0] :
                                ( mem(V10c0,ty_2Efcp_2Ecart(bool,A_27w))
                               => ! [V11c1] :
                                    ( mem(V11c1,ty_2Efcp_2Ecart(bool,A_27t))
                                   => ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V8f),ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),V9c),V10c0),V11c1)) = ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27u,A_27w),V9c),V10c0),ap(V8f,V11c1)) ) ) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__accfupds,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27u] :
          ( ne(A_27u)
         => ! [A_27w] :
              ( ne(A_27w)
             => ! [A_27x] :
                  ( ne(A_27x)
                 => ( ! [V0f0] :
                        ( mem(V0f0,arr(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27x)))
                       => ! [V1f] :
                            ( mem(V1f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27x),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V0f0),V1f)) = ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1f) ) )
                    & ! [V2f0] :
                        ( mem(V2f0,arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27u)))
                       => ! [V3f] :
                            ( mem(V3f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ap(c_2Ebinary__ieee_2Efloat__Sign(A_27u,A_27w),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V2f0),V3f)) = ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V3f) ) )
                    & ! [V4f0] :
                        ( mem(V4f0,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
                       => ! [V5f] :
                            ( mem(V5f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V4f0),V5f)) = ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),V5f) ) )
                    & ! [V6f0] :
                        ( mem(V6f0,arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27u)))
                       => ! [V7f] :
                            ( mem(V7f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27u,A_27w),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V6f0),V7f)) = ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),V7f) ) )
                    & ! [V8f0] :
                        ( mem(V8f0,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
                       => ! [V9f] :
                            ( mem(V9f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V8f0),V9f)) = ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),V9f) ) )
                    & ! [V10f0] :
                        ( mem(V10f0,arr(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27x)))
                       => ! [V11f] :
                            ( mem(V11f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27x),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V10f0),V11f)) = ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),V11f) ) )
                    & ! [V12f0] :
                        ( mem(V12f0,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
                       => ! [V13f] :
                            ( mem(V13f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V12f0),V13f)) = ap(V12f0,ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V13f)) ) )
                    & ! [V14f0] :
                        ( mem(V14f0,arr(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27x)))
                       => ! [V15f] :
                            ( mem(V15f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27x),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V14f0),V15f)) = ap(V14f0,ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),V15f)) ) )
                    & ! [V16f0] :
                        ( mem(V16f0,arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27u)))
                       => ! [V17f] :
                            ( mem(V17f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ap(c_2Ebinary__ieee_2Efloat__Significand(A_27u,A_27w),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V16f0),V17f)) = ap(V16f0,ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),V17f)) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__fupdfupds,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27u] :
          ( ne(A_27u)
         => ! [A_27v] :
              ( ne(A_27v)
             => ! [A_27w] :
                  ( ne(A_27w)
                 => ! [A_27x] :
                      ( ne(A_27x)
                     => ! [A_27y] :
                          ( ne(A_27y)
                         => ( ! [V0g] :
                                ( mem(V0g,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
                               => ! [V1f0] :
                                    ( mem(V1f0,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
                                   => ! [V2f] :
                                        ( mem(V2f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                       => ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V1f0),ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V0g),V2f)) = ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),ap(ap(c_2Ecombin_2Eo(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),V1f0),V0g)),V2f) ) ) )
                            & ! [V3g] :
                                ( mem(V3g,arr(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27x)))
                               => ! [V4f0] :
                                    ( mem(V4f0,arr(ty_2Efcp_2Ecart(bool,A_27x),ty_2Efcp_2Ecart(bool,A_27y)))
                                   => ! [V5f] :
                                        ( mem(V5f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                       => ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27x,A_27y),V4f0),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V3g),V5f)) = ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27y),ap(ap(c_2Ecombin_2Eo(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27y),ty_2Efcp_2Ecart(bool,A_27x)),V4f0),V3g)),V5f) ) ) )
                            & ! [V6g] :
                                ( mem(V6g,arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27u)))
                               => ! [V7f0] :
                                    ( mem(V7f0,arr(ty_2Efcp_2Ecart(bool,A_27u),ty_2Efcp_2Ecart(bool,A_27v)))
                                   => ! [V8f] :
                                        ( mem(V8f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                       => ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27u,A_27v,A_27w),V7f0),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V6g),V8f)) = ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27v,A_27w),ap(ap(c_2Ecombin_2Eo(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27v),ty_2Efcp_2Ecart(bool,A_27u)),V7f0),V6g)),V8f) ) ) ) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__fupdfupds__comp,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27t] :
          ( ne(A_27t)
         => ! [A_27u] :
              ( ne(A_27u)
             => ! [A_27v] :
                  ( ne(A_27v)
                 => ! [A_27w] :
                      ( ne(A_27w)
                     => ! [A_27x] :
                          ( ne(A_27x)
                         => ! [A_27y] :
                              ( ne(A_27y)
                             => ( ! [V0g] :
                                    ( mem(V0g,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
                                   => ! [V1f0] :
                                        ( mem(V1f0,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
                                       => ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V1f0)),ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V0g)) = ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),ap(ap(c_2Ecombin_2Eo(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),V1f0),V0g)) ) )
                                & ! [V2h] :
                                    ( mem(V2h,arr(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))
                                   => ! [V3g] :
                                        ( mem(V3g,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
                                       => ! [V4f0] :
                                            ( mem(V4f0,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
                                           => ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V4f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V3g)),V2h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),ap(ap(c_2Ecombin_2Eo(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),V4f0),V3g))),V2h) ) ) )
                                & ! [V5g] :
                                    ( mem(V5g,arr(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27x)))
                                   => ! [V6f0] :
                                        ( mem(V6f0,arr(ty_2Efcp_2Ecart(bool,A_27x),ty_2Efcp_2Ecart(bool,A_27y)))
                                       => ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27y),ty_2Ebinary__ieee_2Efloat(A_27t,A_27x)),ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27x,A_27y),V6f0)),ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V5g)) = ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27y),ap(ap(c_2Ecombin_2Eo(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27y),ty_2Efcp_2Ecart(bool,A_27x)),V6f0),V5g)) ) )
                                & ! [V7h] :
                                    ( mem(V7h,arr(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))
                                   => ! [V8g] :
                                        ( mem(V8g,arr(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27x)))
                                       => ! [V9f0] :
                                            ( mem(V9f0,arr(ty_2Efcp_2Ecart(bool,A_27x),ty_2Efcp_2Ecart(bool,A_27y)))
                                           => ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27y),ty_2Ebinary__ieee_2Efloat(A_27t,A_27x)),ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27x,A_27y),V9f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27x),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V8g)),V7h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27y),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27y),ap(ap(c_2Ecombin_2Eo(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27y),ty_2Efcp_2Ecart(bool,A_27x)),V9f0),V8g))),V7h) ) ) )
                                & ! [V10g] :
                                    ( mem(V10g,arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27u)))
                                   => ! [V11f0] :
                                        ( mem(V11f0,arr(ty_2Efcp_2Ecart(bool,A_27u),ty_2Efcp_2Ecart(bool,A_27v)))
                                       => ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27v,A_27w),ty_2Ebinary__ieee_2Efloat(A_27u,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27u,A_27v,A_27w),V11f0)),ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V10g)) = ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27v,A_27w),ap(ap(c_2Ecombin_2Eo(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27v),ty_2Efcp_2Ecart(bool,A_27u)),V11f0),V10g)) ) )
                                & ! [V12h] :
                                    ( mem(V12h,arr(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))
                                   => ! [V13g] :
                                        ( mem(V13g,arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27u)))
                                       => ! [V14f0] :
                                            ( mem(V14f0,arr(ty_2Efcp_2Ecart(bool,A_27u),ty_2Efcp_2Ecart(bool,A_27v)))
                                           => ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27v,A_27w),ty_2Ebinary__ieee_2Efloat(A_27u,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27u,A_27v,A_27w),V14f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27u,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V13g)),V12h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27v,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27v,A_27w),ap(ap(c_2Ecombin_2Eo(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27v),ty_2Efcp_2Ecart(bool,A_27u)),V14f0),V13g))),V12h) ) ) ) ) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__fupdcanon,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27u] :
          ( ne(A_27u)
         => ! [A_27w] :
              ( ne(A_27w)
             => ! [A_27x] :
                  ( ne(A_27x)
                 => ( ! [V0g] :
                        ( mem(V0g,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
                       => ! [V1f0] :
                            ( mem(V1f0,arr(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27x)))
                           => ! [V2f] :
                                ( mem(V2f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                               => ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V1f0),ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V0g),V2f)) = ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27x),V0g),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V1f0),V2f)) ) ) )
                    & ! [V3g] :
                        ( mem(V3g,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
                       => ! [V4f0] :
                            ( mem(V4f0,arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27u)))
                           => ! [V5f] :
                                ( mem(V5f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                               => ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V4f0),ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V3g),V5f)) = ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27u,A_27w),V3g),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V4f0),V5f)) ) ) )
                    & ! [V6g] :
                        ( mem(V6g,arr(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27x)))
                       => ! [V7f0] :
                            ( mem(V7f0,arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27u)))
                           => ! [V8f] :
                                ( mem(V8f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                               => ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27x),V7f0),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V6g),V8f)) = ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27u,A_27w,A_27x),V6g),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V7f0),V8f)) ) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__fupdcanon__comp,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27t] :
          ( ne(A_27t)
         => ! [A_27u] :
              ( ne(A_27u)
             => ! [A_27w] :
                  ( ne(A_27w)
                 => ! [A_27x] :
                      ( ne(A_27x)
                     => ( ! [V0g] :
                            ( mem(V0g,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
                           => ! [V1f0] :
                                ( mem(V1f0,arr(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27x)))
                               => ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27x),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V1f0)),ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V0g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27x),ty_2Ebinary__ieee_2Efloat(A_27t,A_27x)),ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27x),V0g)),ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V1f0)) ) )
                        & ! [V2h] :
                            ( mem(V2h,arr(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))
                           => ! [V3g] :
                                ( mem(V3g,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
                               => ! [V4f0] :
                                    ( mem(V4f0,arr(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27x)))
                                   => ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27x),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V4f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V3g)),V2h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27x),ty_2Ebinary__ieee_2Efloat(A_27t,A_27x)),ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27x),V3g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27x),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V4f0)),V2h)) ) ) )
                        & ! [V5g] :
                            ( mem(V5g,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
                           => ! [V6f0] :
                                ( mem(V6f0,arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27u)))
                               => ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27u,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V6f0)),ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V5g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27u,A_27w),ty_2Ebinary__ieee_2Efloat(A_27u,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27u,A_27w),V5g)),ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V6f0)) ) )
                        & ! [V7h] :
                            ( mem(V7h,arr(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))
                           => ! [V8g] :
                                ( mem(V8g,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)))
                               => ! [V9f0] :
                                    ( mem(V9f0,arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27u)))
                                   => ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27u,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V9f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),V8g)),V7h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27u,A_27w),ty_2Ebinary__ieee_2Efloat(A_27u,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27u,A_27w),V8g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27u,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V9f0)),V7h)) ) ) )
                        & ! [V10g] :
                            ( mem(V10g,arr(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27x)))
                           => ! [V11f0] :
                                ( mem(V11f0,arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27u)))
                               => ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27u,A_27x),ty_2Ebinary__ieee_2Efloat(A_27t,A_27x)),ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27x),V11f0)),ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V10g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27u,A_27x),ty_2Ebinary__ieee_2Efloat(A_27u,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27u,A_27w,A_27x),V10g)),ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V11f0)) ) )
                        & ! [V12h] :
                            ( mem(V12h,arr(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))
                           => ! [V13g] :
                                ( mem(V13g,arr(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27x)))
                               => ! [V14f0] :
                                    ( mem(V14f0,arr(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27u)))
                                   => ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27u,A_27x),ty_2Ebinary__ieee_2Efloat(A_27t,A_27x)),ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27x),V14f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27x),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27x),V13g)),V12h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27u,A_27x),ty_2Ebinary__ieee_2Efloat(A_27u,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27u,A_27w,A_27x),V13g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Efloat(A_27u,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),V14f0)),V12h)) ) ) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__component__equality,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0f1] :
              ( mem(V0f1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V1f2] :
                  ( mem(V1f2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ( V0f1 = V1f2
                  <=> ( ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V0f1) = ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1f2)
                      & ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),V0f1) = ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),V1f2)
                      & ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),V0f1) = ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),V1f2) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__updates__eq__literal,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27u] :
          ( ne(A_27u)
         => ! [A_27w] :
              ( ne(A_27w)
             => ! [A_27x] :
                  ( ne(A_27x)
                 => ! [V0f] :
                      ( mem(V0f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ! [V1c1] :
                          ( mem(V1c1,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
                         => ! [V2c0] :
                              ( mem(V2c0,ty_2Efcp_2Ecart(bool,A_27x))
                             => ! [V3c] :
                                  ( mem(V3c,ty_2Efcp_2Ecart(bool,A_27u))
                                 => ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27u,A_27x),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),V1c1)),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27u,A_27w,A_27x),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27x),ty_2Efcp_2Ecart(bool,A_27w)),V2c0)),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27u),ty_2Efcp_2Ecart(bool,A_27t)),V3c)),V0f))) = ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27u,A_27x),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),V1c1)),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27u,A_27w,A_27x),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27x),ty_2Efcp_2Ecart(bool,A_27w)),V2c0)),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27u),ty_2Efcp_2Ecart(bool,A_27t)),V3c)),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))) ) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__literal__nchotomy,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27u] :
          ( ne(A_27u)
         => ! [A_27w] :
              ( ne(A_27w)
             => ! [A_27x] :
                  ( ne(A_27x)
                 => ! [V0f] :
                      ( mem(V0f,ty_2Ebinary__ieee_2Efloat(A_27u,A_27x))
                     => ? [V1c1] :
                          ( mem(V1c1,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
                          & ? [V2c0] :
                              ( mem(V2c0,ty_2Efcp_2Ecart(bool,A_27x))
                              & ? [V3c] :
                                  ( mem(V3c,ty_2Efcp_2Ecart(bool,A_27u))
                                  & V0f = ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27u,A_27x),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),V1c1)),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27u,A_27w,A_27x),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27x),ty_2Efcp_2Ecart(bool,A_27w)),V2c0)),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27u),ty_2Efcp_2Ecart(bool,A_27t)),V3c)),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))) ) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2EFORALL__float,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27u] :
          ( ne(A_27u)
         => ! [A_27w] :
              ( ne(A_27w)
             => ! [A_27x] :
                  ( ne(A_27x)
                 => ! [V0P] :
                      ( mem(V0P,arr(ty_2Ebinary__ieee_2Efloat(A_27u,A_27x),bool))
                     => ( ! [V1f] :
                            ( mem(V1f,ty_2Ebinary__ieee_2Efloat(A_27u,A_27x))
                           => p(ap(V0P,V1f)) )
                      <=> ! [V2c1] :
                            ( mem(V2c1,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
                           => ! [V3c0] :
                                ( mem(V3c0,ty_2Efcp_2Ecart(bool,A_27x))
                               => ! [V4c] :
                                    ( mem(V4c,ty_2Efcp_2Ecart(bool,A_27u))
                                   => p(ap(V0P,ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27u,A_27x),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),V2c1)),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27u,A_27w,A_27x),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27x),ty_2Efcp_2Ecart(bool,A_27w)),V3c0)),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27u),ty_2Efcp_2Ecart(bool,A_27t)),V4c)),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))) ) ) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2EEXISTS__float,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27u] :
          ( ne(A_27u)
         => ! [A_27w] :
              ( ne(A_27w)
             => ! [A_27x] :
                  ( ne(A_27x)
                 => ! [V0P] :
                      ( mem(V0P,arr(ty_2Ebinary__ieee_2Efloat(A_27u,A_27x),bool))
                     => ( ? [V1f] :
                            ( mem(V1f,ty_2Ebinary__ieee_2Efloat(A_27u,A_27x))
                            & p(ap(V0P,V1f)) )
                      <=> ? [V2c1] :
                            ( mem(V2c1,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
                            & ? [V3c0] :
                                ( mem(V3c0,ty_2Efcp_2Ecart(bool,A_27x))
                                & ? [V4c] :
                                    ( mem(V4c,ty_2Efcp_2Ecart(bool,A_27u))
                                    & p(ap(V0P,ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27u,A_27x),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),V2c1)),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27u,A_27w,A_27x),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27x),ty_2Efcp_2Ecart(bool,A_27w)),V3c0)),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27u),ty_2Efcp_2Ecart(bool,A_27t)),V4c)),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))) ) ) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__literal__11,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27u] :
          ( ne(A_27u)
         => ! [A_27w] :
              ( ne(A_27w)
             => ! [A_27x] :
                  ( ne(A_27x)
                 => ! [V0c11] :
                      ( mem(V0c11,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
                     => ! [V1c01] :
                          ( mem(V1c01,ty_2Efcp_2Ecart(bool,A_27x))
                         => ! [V2c1] :
                              ( mem(V2c1,ty_2Efcp_2Ecart(bool,A_27u))
                             => ! [V3c12] :
                                  ( mem(V3c12,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
                                 => ! [V4c02] :
                                      ( mem(V4c02,ty_2Efcp_2Ecart(bool,A_27x))
                                     => ! [V5c2] :
                                          ( mem(V5c2,ty_2Efcp_2Ecart(bool,A_27u))
                                         => ( ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27u,A_27x),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),V0c11)),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27u,A_27w,A_27x),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27x),ty_2Efcp_2Ecart(bool,A_27w)),V1c01)),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27u),ty_2Efcp_2Ecart(bool,A_27t)),V2c1)),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))) = ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27u,A_27x),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),V3c12)),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27u,A_27w,A_27x),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27x),ty_2Efcp_2Ecart(bool,A_27w)),V4c02)),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27u,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27u),ty_2Efcp_2Ecart(bool,A_27t)),V5c2)),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))
                                          <=> ( V0c11 = V3c12
                                              & V1c01 = V4c02
                                              & V2c1 = V5c2 ) ) ) ) ) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Edatatype__float,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0record] :
              ( mem(V0record,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),arr(ty_2Efcp_2Ecart(bool,A_27w),arr(ty_2Efcp_2Ecart(bool,A_27t),bool)))))
             => ! [V1float] :
                  ( mem(V1float,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V2Sign] :
                      ( mem(V2Sign,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
                     => ! [V3Exponent] :
                          ( mem(V3Exponent,ty_2Efcp_2Ecart(bool,A_27w))
                         => ! [V4Significand] :
                              ( mem(V4Significand,ty_2Efcp_2Ecart(bool,A_27t))
                             => p(ap(c_2Ebool_2EDATATYPE(bool),ap(ap(ap(ap(V0record,V1float),V2Sign),V3Exponent),V4Significand))) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__11,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0a0] :
              ( mem(V0a0,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
             => ! [V1a1] :
                  ( mem(V1a1,ty_2Efcp_2Ecart(bool,A_27w))
                 => ! [V2a2] :
                      ( mem(V2a2,ty_2Efcp_2Ecart(bool,A_27t))
                     => ! [V3a0_27] :
                          ( mem(V3a0_27,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
                         => ! [V4a1_27] :
                              ( mem(V4a1_27,ty_2Efcp_2Ecart(bool,A_27w))
                             => ! [V5a2_27] :
                                  ( mem(V5a2_27,ty_2Efcp_2Ecart(bool,A_27t))
                                 => ( ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),V0a0),V1a1),V2a2) = ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),V3a0_27),V4a1_27),V5a2_27)
                                  <=> ( V0a0 = V3a0_27
                                      & V1a1 = V4a1_27
                                      & V2a2 = V5a2_27 ) ) ) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__nchotomy,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0ff] :
              ( mem(V0ff,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ? [V1c] :
                  ( mem(V1c,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
                  & ? [V2c0] :
                      ( mem(V2c0,ty_2Efcp_2Ecart(bool,A_27w))
                      & ? [V3c1] :
                          ( mem(V3c1,ty_2Efcp_2Ecart(bool,A_27t))
                          & V0ff = ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),V1c),V2c0),V3c1) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__Axiom,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27t] :
          ( ne(A_27t)
         => ! [A_27w] :
              ( ne(A_27w)
             => ! [V0f] :
                  ( mem(V0f,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),arr(ty_2Efcp_2Ecart(bool,A_27w),arr(ty_2Efcp_2Ecart(bool,A_27t),A_27a))))
                 => ? [V1fn] :
                      ( mem(V1fn,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))
                      & ! [V2a0] :
                          ( mem(V2a0,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
                         => ! [V3a1] :
                              ( mem(V3a1,ty_2Efcp_2Ecart(bool,A_27w))
                             => ! [V4a2] :
                                  ( mem(V4a2,ty_2Efcp_2Ecart(bool,A_27t))
                                 => ap(V1fn,ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),V2a0),V3a1),V4a2)) = ap(ap(ap(V0f,V2a0),V3a1),V4a2) ) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__induction,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0P] :
              ( mem(V0P,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool))
             => ( ! [V1c] :
                    ( mem(V1c,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
                   => ! [V2c0] :
                        ( mem(V2c0,ty_2Efcp_2Ecart(bool,A_27w))
                       => ! [V3c1] :
                            ( mem(V3c1,ty_2Efcp_2Ecart(bool,A_27t))
                           => p(ap(V0P,ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),V1c),V2c0),V3c1))) ) ) )
               => ! [V4f] :
                    ( mem(V4f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                   => p(ap(V0P,V4f)) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__case__cong,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27t] :
          ( ne(A_27t)
         => ! [A_27w] :
              ( ne(A_27w)
             => ! [V0f_27] :
                  ( mem(V0f_27,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),arr(ty_2Efcp_2Ecart(bool,A_27w),arr(ty_2Efcp_2Ecart(bool,A_27t),A_27a))))
                 => ! [V1M] :
                      ( mem(V1M,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ! [V2M_27] :
                          ( mem(V2M_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                         => ! [V3f] :
                              ( mem(V3f,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),arr(ty_2Efcp_2Ecart(bool,A_27w),arr(ty_2Efcp_2Ecart(bool,A_27t),A_27a))))
                             => ( ( V1M = V2M_27
                                  & ! [V4a0] :
                                      ( mem(V4a0,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
                                     => ! [V5a1] :
                                          ( mem(V5a1,ty_2Efcp_2Ecart(bool,A_27w))
                                         => ! [V6a2] :
                                              ( mem(V6a2,ty_2Efcp_2Ecart(bool,A_27t))
                                             => ( V2M_27 = ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),V4a0),V5a1),V6a2)
                                               => ap(ap(ap(V3f,V4a0),V5a1),V6a2) = ap(ap(ap(V0f_27,V4a0),V5a1),V6a2) ) ) ) ) )
                               => ap(ap(c_2Ebinary__ieee_2Efloat__CASE(A_27a,A_27t,A_27w),V1M),V3f) = ap(ap(c_2Ebinary__ieee_2Efloat__CASE(A_27a,A_27t,A_27w),V2M_27),V0f_27) ) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__case__eq,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27t] :
          ( ne(A_27t)
         => ! [A_27w] :
              ( ne(A_27w)
             => ! [V0x] :
                  ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V1f] :
                      ( mem(V1f,arr(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),arr(ty_2Efcp_2Ecart(bool,A_27w),arr(ty_2Efcp_2Ecart(bool,A_27t),A_27a))))
                     => ! [V2v] :
                          ( mem(V2v,A_27a)
                         => ( ap(ap(c_2Ebinary__ieee_2Efloat__CASE(A_27a,A_27t,A_27w),V0x),V1f) = V2v
                          <=> ? [V3c] :
                                ( mem(V3c,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
                                & ? [V4c0] :
                                    ( mem(V4c0,ty_2Efcp_2Ecart(bool,A_27w))
                                    & ? [V5c1] :
                                        ( mem(V5c1,ty_2Efcp_2Ecart(bool,A_27t))
                                        & V0x = ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Efloat(A_27t,A_27w),V3c),V4c0),V5c1)
                                        & ap(ap(ap(V1f,V3c),V4c0),V5c1) = V2v ) ) ) ) ) ) ) ) ) ) ).

fof(lameq_f2926,axiom,
    ! [V5a] : ap(f2926,V5a) = ap(ap(ap(c_2Eind__type_2ECONSTR(ty_2Erealax_2Ereal),c_2Enum_2E0),V5a),k(ty_2Enum_2Enum,c_2Eind__type_2EBOTTOM(ty_2Erealax_2Ereal))) ).

fof(lameq_f2927,axiom,
    ! [V3a0] :
      ( mem(V3a0,ty_2Eind__type_2Erecspace(ty_2Erealax_2Ereal))
     => ! [V4a] : ap(f2927(V3a0),V4a) = ap(ap(c_2Emin_2E_3D(ty_2Eind__type_2Erecspace(ty_2Erealax_2Ereal)),V3a0),ap(f2926,V4a)) ) ).

fof(lameq_f2928,axiom,
    ! [V2_27float__value_27] :
      ( mem(V2_27float__value_27,arr(ty_2Eind__type_2Erecspace(ty_2Erealax_2Ereal),bool))
     => ! [V3a0] : ap(f2928(V2_27float__value_27),V3a0) = ap(ap(c_2Emin_2E_3D_3D_3E,ap(ap(c_2Ebool_2E_5C_2F,ap(c_2Ebool_2E_3F(ty_2Erealax_2Ereal),f2927(V3a0))),ap(ap(c_2Ebool_2E_5C_2F,ap(ap(c_2Emin_2E_3D(ty_2Eind__type_2Erecspace(ty_2Erealax_2Ereal)),V3a0),ap(ap(ap(c_2Eind__type_2ECONSTR(ty_2Erealax_2Ereal),ap(c_2Enum_2ESUC,c_2Enum_2E0)),c_2Ebool_2EARB(ty_2Erealax_2Ereal)),k(ty_2Enum_2Enum,c_2Eind__type_2EBOTTOM(ty_2Erealax_2Ereal))))),ap(ap(c_2Emin_2E_3D(ty_2Eind__type_2Erecspace(ty_2Erealax_2Ereal)),V3a0),ap(ap(ap(c_2Eind__type_2ECONSTR(ty_2Erealax_2Ereal),ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,c_2Enum_2E0))),c_2Ebool_2EARB(ty_2Erealax_2Ereal)),k(ty_2Enum_2Enum,c_2Eind__type_2EBOTTOM(ty_2Erealax_2Ereal))))))),ap(V2_27float__value_27,V3a0)) ) ).

fof(lameq_f2929,axiom,
    ! [V1a0] :
      ( mem(V1a0,ty_2Eind__type_2Erecspace(ty_2Erealax_2Ereal))
     => ! [V2_27float__value_27] : ap(f2929(V1a0),V2_27float__value_27) = ap(ap(c_2Emin_2E_3D_3D_3E,ap(c_2Ebool_2E_21(ty_2Eind__type_2Erecspace(ty_2Erealax_2Ereal)),f2928(V2_27float__value_27))),ap(V2_27float__value_27,V1a0)) ) ).

fof(lameq_f2930,axiom,
    ! [V1a0] : ap(f2930,V1a0) = ap(c_2Ebool_2E_21(arr(ty_2Eind__type_2Erecspace(ty_2Erealax_2Ereal),bool)),f2929(V1a0)) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__value__TY__DEF,axiom,
    ? [V0rep] :
      ( mem(V0rep,arr(ty_2Ebinary__ieee_2Efloat__value,ty_2Eind__type_2Erecspace(ty_2Erealax_2Ereal)))
      & p(ap(ap(c_2Ebool_2ETYPE__DEFINITION(ty_2Eind__type_2Erecspace(ty_2Erealax_2Ereal),ty_2Ebinary__ieee_2Efloat__value),f2930),V0rep)) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__value__case__def,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ( ! [V0a] :
            ( mem(V0a,ty_2Erealax_2Ereal)
           => ! [V1f] :
                ( mem(V1f,arr(ty_2Erealax_2Ereal,A_27a))
               => ! [V2v] :
                    ( mem(V2v,A_27a)
                   => ! [V3v1] :
                        ( mem(V3v1,A_27a)
                       => ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(A_27a),ap(c_2Ebinary__ieee_2EFloat,V0a)),V1f),V2v),V3v1) = ap(V1f,V0a) ) ) ) )
        & ! [V4f] :
            ( mem(V4f,arr(ty_2Erealax_2Ereal,A_27a))
           => ! [V5v] :
                ( mem(V5v,A_27a)
               => ! [V6v1] :
                    ( mem(V6v1,A_27a)
                   => ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(A_27a),c_2Ebinary__ieee_2EInfinity),V4f),V5v),V6v1) = V5v ) ) )
        & ! [V7f] :
            ( mem(V7f,arr(ty_2Erealax_2Ereal,A_27a))
           => ! [V8v] :
                ( mem(V8v,A_27a)
               => ! [V9v1] :
                    ( mem(V9v1,A_27a)
                   => ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(A_27a),c_2Ebinary__ieee_2ENaN),V7f),V8v),V9v1) = V9v1 ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__value__size__def,axiom,
    ( ! [V0a] :
        ( mem(V0a,ty_2Erealax_2Ereal)
       => ap(c_2Ebinary__ieee_2Efloat__value__size,ap(c_2Ebinary__ieee_2EFloat,V0a)) = ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)) )
    & ap(c_2Ebinary__ieee_2Efloat__value__size,c_2Ebinary__ieee_2EInfinity) = c_2Enum_2E0
    & ap(c_2Ebinary__ieee_2Efloat__value__size,c_2Ebinary__ieee_2ENaN) = c_2Enum_2E0 ) ).

fof(conj_thm_2Ebinary__ieee_2Edatatype__float__value,axiom,
    ! [V0float__value] :
      ( mem(V0float__value,arr(arr(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat__value),arr(ty_2Ebinary__ieee_2Efloat__value,arr(ty_2Ebinary__ieee_2Efloat__value,bool))))
     => p(ap(c_2Ebool_2EDATATYPE(bool),ap(ap(ap(V0float__value,c_2Ebinary__ieee_2EFloat),c_2Ebinary__ieee_2EInfinity),c_2Ebinary__ieee_2ENaN))) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__value__11,axiom,
    ! [V0a] :
      ( mem(V0a,ty_2Erealax_2Ereal)
     => ! [V1a_27] :
          ( mem(V1a_27,ty_2Erealax_2Ereal)
         => ( ap(c_2Ebinary__ieee_2EFloat,V0a) = ap(c_2Ebinary__ieee_2EFloat,V1a_27)
          <=> V0a = V1a_27 ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__value__distinct,axiom,
    ( ! [V0a] :
        ( mem(V0a,ty_2Erealax_2Ereal)
       => ap(c_2Ebinary__ieee_2EFloat,V0a) != c_2Ebinary__ieee_2EInfinity )
    & ! [V1a] :
        ( mem(V1a,ty_2Erealax_2Ereal)
       => ap(c_2Ebinary__ieee_2EFloat,V1a) != c_2Ebinary__ieee_2ENaN )
    & c_2Ebinary__ieee_2EInfinity != c_2Ebinary__ieee_2ENaN ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__value__nchotomy,axiom,
    ! [V0ff] :
      ( mem(V0ff,ty_2Ebinary__ieee_2Efloat__value)
     => ( ? [V1r] :
            ( mem(V1r,ty_2Erealax_2Ereal)
            & V0ff = ap(c_2Ebinary__ieee_2EFloat,V1r) )
        | V0ff = c_2Ebinary__ieee_2EInfinity
        | V0ff = c_2Ebinary__ieee_2ENaN ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__value__Axiom,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [V0f0] :
          ( mem(V0f0,arr(ty_2Erealax_2Ereal,A_27a))
         => ! [V1f1] :
              ( mem(V1f1,A_27a)
             => ! [V2f2] :
                  ( mem(V2f2,A_27a)
                 => ? [V3fn] :
                      ( mem(V3fn,arr(ty_2Ebinary__ieee_2Efloat__value,A_27a))
                      & ! [V4a] :
                          ( mem(V4a,ty_2Erealax_2Ereal)
                         => ap(V3fn,ap(c_2Ebinary__ieee_2EFloat,V4a)) = ap(V0f0,V4a) )
                      & ap(V3fn,c_2Ebinary__ieee_2EInfinity) = V1f1
                      & ap(V3fn,c_2Ebinary__ieee_2ENaN) = V2f2 ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__value__induction,axiom,
    ! [V0P] :
      ( mem(V0P,arr(ty_2Ebinary__ieee_2Efloat__value,bool))
     => ( ( ! [V1r] :
              ( mem(V1r,ty_2Erealax_2Ereal)
             => p(ap(V0P,ap(c_2Ebinary__ieee_2EFloat,V1r))) )
          & p(ap(V0P,c_2Ebinary__ieee_2EInfinity))
          & p(ap(V0P,c_2Ebinary__ieee_2ENaN)) )
       => ! [V2f] :
            ( mem(V2f,ty_2Ebinary__ieee_2Efloat__value)
           => p(ap(V0P,V2f)) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__value__case__cong,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [V0f_27] :
          ( mem(V0f_27,arr(ty_2Erealax_2Ereal,A_27a))
         => ! [V1v_27] :
              ( mem(V1v_27,A_27a)
             => ! [V2v1_27] :
                  ( mem(V2v1_27,A_27a)
                 => ! [V3M] :
                      ( mem(V3M,ty_2Ebinary__ieee_2Efloat__value)
                     => ! [V4M_27] :
                          ( mem(V4M_27,ty_2Ebinary__ieee_2Efloat__value)
                         => ! [V5f] :
                              ( mem(V5f,arr(ty_2Erealax_2Ereal,A_27a))
                             => ! [V6v] :
                                  ( mem(V6v,A_27a)
                                 => ! [V7v1] :
                                      ( mem(V7v1,A_27a)
                                     => ( ( V3M = V4M_27
                                          & ! [V8a] :
                                              ( mem(V8a,ty_2Erealax_2Ereal)
                                             => ( V4M_27 = ap(c_2Ebinary__ieee_2EFloat,V8a)
                                               => ap(V5f,V8a) = ap(V0f_27,V8a) ) )
                                          & ( V4M_27 = c_2Ebinary__ieee_2EInfinity
                                           => V6v = V1v_27 )
                                          & ( V4M_27 = c_2Ebinary__ieee_2ENaN
                                           => V7v1 = V2v1_27 ) )
                                       => ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(A_27a),V3M),V5f),V6v),V7v1) = ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(A_27a),V4M_27),V0f_27),V1v_27),V2v1_27) ) ) ) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__value__case__eq,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [V0x] :
          ( mem(V0x,ty_2Ebinary__ieee_2Efloat__value)
         => ! [V1f] :
              ( mem(V1f,arr(ty_2Erealax_2Ereal,A_27a))
             => ! [V2v] :
                  ( mem(V2v,A_27a)
                 => ! [V3v1] :
                      ( mem(V3v1,A_27a)
                     => ! [V4v_27] :
                          ( mem(V4v_27,A_27a)
                         => ( ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(A_27a),V0x),V1f),V2v),V3v1) = V4v_27
                          <=> ( ? [V5r] :
                                  ( mem(V5r,ty_2Erealax_2Ereal)
                                  & V0x = ap(c_2Ebinary__ieee_2EFloat,V5r)
                                  & ap(V1f,V5r) = V4v_27 )
                              | ( V0x = c_2Ebinary__ieee_2EInfinity
                                & V2v = V4v_27 )
                              | ( V0x = c_2Ebinary__ieee_2ENaN
                                & V3v1 = V4v_27 ) ) ) ) ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__to__real__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0x] :
              ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),V0x) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Erealax_2Ereal),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),V0x)),ap(c_2Ewords_2En2w(A_27w),c_2Enum_2E0))),ap(ap(c_2Erealax_2Ereal__mul,ap(ap(c_2Erealax_2Ereal__mul,ap(ap(c_2Ereal_2Epow,ap(c_2Erealax_2Ereal__neg,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))))),ap(c_2Ewords_2Ew2n(ty_2Eone_2Eone),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V0x)))),ap(ap(c_2Ereal_2E_2F,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),ap(c_2Ewords_2EINT__MAX(A_27w),c_2Ebool_2Ethe__value(A_27w)))))),ap(ap(c_2Ereal_2E_2F,ap(c_2Ereal_2Ereal__of__num,ap(c_2Ewords_2Ew2n(A_27t),ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),V0x)))),ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),ap(c_2Efcp_2Edimindex(A_27t),c_2Ebool_2Ethe__value(A_27t)))))),ap(ap(c_2Erealax_2Ereal__mul,ap(ap(c_2Erealax_2Ereal__mul,ap(ap(c_2Ereal_2Epow,ap(c_2Erealax_2Ereal__neg,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))))),ap(c_2Ewords_2Ew2n(ty_2Eone_2Eone),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V0x)))),ap(ap(c_2Ereal_2E_2F,ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),ap(c_2Ewords_2Ew2n(A_27w),ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),V0x)))),ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),ap(c_2Ewords_2EINT__MAX(A_27w),c_2Ebool_2Ethe__value(A_27w)))))),ap(ap(c_2Erealax_2Ereal__add,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)))),ap(ap(c_2Ereal_2E_2F,ap(c_2Ereal_2Ereal__of__num,ap(c_2Ewords_2Ew2n(A_27t),ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),V0x)))),ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),ap(c_2Efcp_2Edimindex(A_27t),c_2Ebool_2Ethe__value(A_27t))))))) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__value__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0x] :
              ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V0x) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat__value),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,A_27w)),ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),V0x)),c_2Ewords_2Eword__T(A_27w))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat__value),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,A_27t)),ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),V0x)),ap(c_2Ewords_2En2w(A_27t),c_2Enum_2E0))),c_2Ebinary__ieee_2EInfinity),c_2Ebinary__ieee_2ENaN)),ap(c_2Ebinary__ieee_2EFloat,ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),V0x))) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__is__nan__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0x] :
              ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ( p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),V0x))
              <=> p(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(bool),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V0x)),k(ty_2Erealax_2Ereal,c_2Ebool_2EF)),c_2Ebool_2EF),c_2Ebool_2ET)) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__is__signalling__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0x] :
              ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ( p(ap(c_2Ebinary__ieee_2Efloat__is__signalling(A_27t,A_27w),V0x))
              <=> ( p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),V0x))
                  & ~ p(ap(c_2Ewords_2Eword__msb(A_27t),ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),V0x))) ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__is__infinite__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0x] :
              ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ( p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V0x))
              <=> p(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(bool),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V0x)),k(ty_2Erealax_2Ereal,c_2Ebool_2EF)),c_2Ebool_2ET),c_2Ebool_2EF)) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__is__normal__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0x] :
              ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ( p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27t,A_27w),V0x))
              <=> ( ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),V0x) != ap(c_2Ewords_2En2w(A_27w),c_2Enum_2E0)
                  & ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),V0x) != c_2Ewords_2Eword__T(A_27w) ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__is__subnormal__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0x] :
              ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ( p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27t,A_27w),V0x))
              <=> ( ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),V0x) = ap(c_2Ewords_2En2w(A_27w),c_2Enum_2E0)
                  & ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),V0x) != ap(c_2Ewords_2En2w(A_27t),c_2Enum_2E0) ) ) ) ) ) ).

fof(lameq_f2931,axiom,
    ! [V1r] : ap(f2931,V1r) = ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),V1r),ap(c_2Ereal_2Ereal__of__num,c_2Enum_2E0)) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__is__zero__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0x] :
              ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ( p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w),V0x))
              <=> p(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(bool),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V0x)),f2931),c_2Ebool_2EF),c_2Ebool_2EF)) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__is__finite__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0x] :
              ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ( p(ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27t,A_27w),V0x))
              <=> p(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(bool),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V0x)),k(ty_2Erealax_2Ereal,c_2Ebool_2ET)),c_2Ebool_2EF),c_2Ebool_2EF)) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Eis__integral__def,axiom,
    ! [V0r] :
      ( mem(V0r,ty_2Erealax_2Ereal)
     => ( p(ap(c_2Ebinary__ieee_2Eis__integral,V0r))
      <=> ? [V1n] :
            ( mem(V1n,ty_2Enum_2Enum)
            & ap(c_2Ereal_2Eabs,V0r) = ap(c_2Ereal_2Ereal__of__num,V1n) ) ) ) ).

fof(lameq_f2932,axiom,
    ! [V1r] : ap(f2932,V1r) = ap(c_2Ebinary__ieee_2Eis__integral,V1r) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__is__integral__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0x] :
              ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ( p(ap(c_2Ebinary__ieee_2Efloat__is__integral(A_27t,A_27w),V0x))
              <=> p(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(bool),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V0x)),f2932),c_2Ebool_2EF),c_2Ebool_2EF)) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__negate__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0x] :
              ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ap(c_2Ebinary__ieee_2Efloat__negate(A_27t,A_27w),V0x) = ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ewords_2Eword__1comp(ty_2Eone_2Eone),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V0x)))),V0x) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__abs__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0x] :
              ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ap(c_2Ebinary__ieee_2Efloat__abs(A_27t,A_27w),V0x) = ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),c_2Enum_2E0))),V0x) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__plus__infinity__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) = ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),c_2Enum_2E0))),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27w)),c_2Ewords_2Eword__T(A_27w))),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27t,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27t)),ap(c_2Ewords_2En2w(A_27t),c_2Enum_2E0))),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__plus__zero__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) = ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),c_2Enum_2E0))),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27w)),ap(c_2Ewords_2En2w(A_27w),c_2Enum_2E0))),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27t,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27t)),ap(c_2Ewords_2En2w(A_27t),c_2Enum_2E0))),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__top__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) = ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),c_2Enum_2E0))),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27w)),ap(ap(c_2Ewords_2Eword__sub(A_27w),c_2Ewords_2Eword__T(A_27w)),ap(c_2Ewords_2En2w(A_27w),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)))))),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27t,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27t)),c_2Ewords_2Eword__T(A_27t))),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__plus__min__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) = ap(ap(c_2Ebinary__ieee_2Efloat__Sign__fupd(A_27t,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),c_2Enum_2E0))),ap(ap(c_2Ebinary__ieee_2Efloat__Exponent__fupd(A_27t,A_27w,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27w),ty_2Efcp_2Ecart(bool,A_27w)),ap(c_2Ewords_2En2w(A_27w),c_2Enum_2E0))),ap(ap(c_2Ebinary__ieee_2Efloat__Significand__fupd(A_27t,A_27t,A_27w),ap(c_2Ecombin_2EK(ty_2Efcp_2Ecart(bool,A_27t),ty_2Efcp_2Ecart(bool,A_27t)),ap(c_2Ewords_2En2w(A_27t),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))))),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__minus__infinity__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) = ap(c_2Ebinary__ieee_2Efloat__negate(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__minus__zero__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) = ap(c_2Ebinary__ieee_2Efloat__negate(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__bottom__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) = ap(c_2Ebinary__ieee_2Efloat__negate(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__minus__min__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) = ap(c_2Ebinary__ieee_2Efloat__negate(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) ) ) ).

fof(lameq_f2933,axiom,
    ! [V11a1] :
      ( mem(V11a1,bool)
     => ! [V13a3] :
          ( mem(V13a3,bool)
         => ! [V14a4] :
              ( mem(V14a4,bool)
             => ! [V12a2] :
                  ( mem(V12a2,bool)
                 => ! [V10a0] :
                      ( mem(V10a0,bool)
                     => ! [V15a5] : ap(f2933(V11a1,V13a3,V14a4,V12a2,V10a0),V15a5) = ap(ap(ap(c_2Eind__type_2ECONSTR(ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool)))))),c_2Enum_2E0),ap(ap(c_2Epair_2E_2C(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool))))),V10a0),ap(ap(c_2Epair_2E_2C(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool)))),V11a1),ap(ap(c_2Epair_2E_2C(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool))),V12a2),ap(ap(c_2Epair_2E_2C(bool,ty_2Epair_2Eprod(bool,bool)),V13a3),ap(ap(c_2Epair_2E_2C(bool,bool),V14a4),V15a5)))))),k(ty_2Enum_2Enum,c_2Eind__type_2EBOTTOM(ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool)))))))) ) ) ) ) ) ).

fof(lameq_f2934,axiom,
    ! [V11a1] :
      ( mem(V11a1,bool)
     => ! [V13a3] :
          ( mem(V13a3,bool)
         => ! [V12a2] :
              ( mem(V12a2,bool)
             => ! [V10a0] :
                  ( mem(V10a0,bool)
                 => ! [V14a4] : ap(f2934(V11a1,V13a3,V12a2,V10a0),V14a4) = f2933(V11a1,V13a3,V14a4,V12a2,V10a0) ) ) ) ) ).

fof(lameq_f2935,axiom,
    ! [V11a1] :
      ( mem(V11a1,bool)
     => ! [V12a2] :
          ( mem(V12a2,bool)
         => ! [V10a0] :
              ( mem(V10a0,bool)
             => ! [V13a3] : ap(f2935(V11a1,V12a2,V10a0),V13a3) = f2934(V11a1,V13a3,V12a2,V10a0) ) ) ) ).

fof(lameq_f2936,axiom,
    ! [V11a1] :
      ( mem(V11a1,bool)
     => ! [V10a0] :
          ( mem(V10a0,bool)
         => ! [V12a2] : ap(f2936(V11a1,V10a0),V12a2) = f2935(V11a1,V12a2,V10a0) ) ) ).

fof(lameq_f2937,axiom,
    ! [V10a0] :
      ( mem(V10a0,bool)
     => ! [V11a1] : ap(f2937(V10a0),V11a1) = f2936(V11a1,V10a0) ) ).

fof(lameq_f2938,axiom,
    ! [V10a0] : ap(f2938,V10a0) = f2937(V10a0) ).

fof(lameq_f2939,axiom,
    ! [V7a3] :
      ( mem(V7a3,bool)
     => ! [V5a1] :
          ( mem(V5a1,bool)
         => ! [V4a0] :
              ( mem(V4a0,bool)
             => ! [V6a2] :
                  ( mem(V6a2,bool)
                 => ! [V8a4] :
                      ( mem(V8a4,bool)
                     => ! [V3a0_27] :
                          ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool)))))))
                         => ! [V9a5] : ap(f2939(V7a3,V5a1,V4a0,V6a2,V8a4,V3a0_27),V9a5) = ap(ap(c_2Emin_2E_3D(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool))))))),V3a0_27),ap(ap(ap(ap(ap(ap(f2938,V4a0),V5a1),V6a2),V7a3),V8a4),V9a5)) ) ) ) ) ) ) ).

fof(lameq_f2940,axiom,
    ! [V3a0_27] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool)))))))
     => ! [V6a2] :
          ( mem(V6a2,bool)
         => ! [V4a0] :
              ( mem(V4a0,bool)
             => ! [V5a1] :
                  ( mem(V5a1,bool)
                 => ! [V7a3] :
                      ( mem(V7a3,bool)
                     => ! [V8a4] : ap(f2940(V3a0_27,V6a2,V4a0,V5a1,V7a3),V8a4) = ap(c_2Ebool_2E_3F(bool),f2939(V7a3,V5a1,V4a0,V6a2,V8a4,V3a0_27)) ) ) ) ) ) ).

fof(lameq_f2941,axiom,
    ! [V5a1] :
      ( mem(V5a1,bool)
     => ! [V4a0] :
          ( mem(V4a0,bool)
         => ! [V6a2] :
              ( mem(V6a2,bool)
             => ! [V3a0_27] :
                  ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool)))))))
                 => ! [V7a3] : ap(f2941(V5a1,V4a0,V6a2,V3a0_27),V7a3) = ap(c_2Ebool_2E_3F(bool),f2940(V3a0_27,V6a2,V4a0,V5a1,V7a3)) ) ) ) ) ).

fof(lameq_f2942,axiom,
    ! [V3a0_27] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool)))))))
     => ! [V4a0] :
          ( mem(V4a0,bool)
         => ! [V5a1] :
              ( mem(V5a1,bool)
             => ! [V6a2] : ap(f2942(V3a0_27,V4a0,V5a1),V6a2) = ap(c_2Ebool_2E_3F(bool),f2941(V5a1,V4a0,V6a2,V3a0_27)) ) ) ) ).

fof(lameq_f2943,axiom,
    ! [V4a0] :
      ( mem(V4a0,bool)
     => ! [V3a0_27] :
          ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool)))))))
         => ! [V5a1] : ap(f2943(V4a0,V3a0_27),V5a1) = ap(c_2Ebool_2E_3F(bool),f2942(V3a0_27,V4a0,V5a1)) ) ) ).

fof(lameq_f2944,axiom,
    ! [V3a0_27] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool)))))))
     => ! [V4a0] : ap(f2944(V3a0_27),V4a0) = ap(c_2Ebool_2E_3F(bool),f2943(V4a0,V3a0_27)) ) ).

fof(lameq_f2945,axiom,
    ! [V2_27flags_27] :
      ( mem(V2_27flags_27,arr(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool)))))),bool))
     => ! [V3a0_27] : ap(f2945(V2_27flags_27),V3a0_27) = ap(ap(c_2Emin_2E_3D_3D_3E,ap(c_2Ebool_2E_3F(bool),f2944(V3a0_27))),ap(V2_27flags_27,V3a0_27)) ) ).

fof(lameq_f2946,axiom,
    ! [V1a0_27] :
      ( mem(V1a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool)))))))
     => ! [V2_27flags_27] : ap(f2946(V1a0_27),V2_27flags_27) = ap(ap(c_2Emin_2E_3D_3D_3E,ap(c_2Ebool_2E_21(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool))))))),f2945(V2_27flags_27))),ap(V2_27flags_27,V1a0_27)) ) ).

fof(lameq_f2947,axiom,
    ! [V1a0_27] : ap(f2947,V1a0_27) = ap(c_2Ebool_2E_21(arr(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool)))))),bool)),f2946(V1a0_27)) ).

fof(ax_thm_2Ebinary__ieee_2Eflags__TY__DEF,axiom,
    ? [V0rep] :
      ( mem(V0rep,arr(ty_2Ebinary__ieee_2Eflags,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool))))))))
      & p(ap(ap(c_2Ebool_2ETYPE__DEFINITION(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,ty_2Epair_2Eprod(bool,bool)))))),ty_2Ebinary__ieee_2Eflags),f2947),V0rep)) ) ).

fof(ax_thm_2Ebinary__ieee_2Eflags__case__def,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [V0a0] :
          ( mem(V0a0,bool)
         => ! [V1a1] :
              ( mem(V1a1,bool)
             => ! [V2a2] :
                  ( mem(V2a2,bool)
                 => ! [V3a3] :
                      ( mem(V3a3,bool)
                     => ! [V4a4] :
                          ( mem(V4a4,bool)
                         => ! [V5a5] :
                              ( mem(V5a5,bool)
                             => ! [V6f] :
                                  ( mem(V6f,arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,A_27a)))))))
                                 => ap(ap(c_2Ebinary__ieee_2Eflags__CASE(A_27a),ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V0a0),V1a1),V2a2),V3a3),V4a4),V5a5)),V6f) = ap(ap(ap(ap(ap(ap(V6f,V0a0),V1a1),V2a2),V3a3),V4a4),V5a5) ) ) ) ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Eflags__size__def,axiom,
    ! [V0a0] :
      ( mem(V0a0,bool)
     => ! [V1a1] :
          ( mem(V1a1,bool)
         => ! [V2a2] :
              ( mem(V2a2,bool)
             => ! [V3a3] :
                  ( mem(V3a3,bool)
                 => ! [V4a4] :
                      ( mem(V4a4,bool)
                     => ! [V5a5] :
                          ( mem(V5a5,bool)
                         => ap(c_2Ebinary__ieee_2Eflags__size,ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V0a0),V1a1),V2a2),V3a3),V4a4),V5a5)) = ap(ap(c_2Earithmetic_2E_2B,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))),ap(ap(c_2Earithmetic_2E_2B,ap(c_2EbasicSize_2Ebool__size,V0a0)),ap(ap(c_2Earithmetic_2E_2B,ap(c_2EbasicSize_2Ebool__size,V1a1)),ap(ap(c_2Earithmetic_2E_2B,ap(c_2EbasicSize_2Ebool__size,V2a2)),ap(ap(c_2Earithmetic_2E_2B,ap(c_2EbasicSize_2Ebool__size,V3a3)),ap(ap(c_2Earithmetic_2E_2B,ap(c_2EbasicSize_2Ebool__size,V4a4)),ap(c_2EbasicSize_2Ebool__size,V5a5))))))) ) ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Eflags__DivideByZero,axiom,
    ! [V0b] :
      ( mem(V0b,bool)
     => ! [V1b0] :
          ( mem(V1b0,bool)
         => ! [V2b1] :
              ( mem(V2b1,bool)
             => ! [V3b2] :
                  ( mem(V3b2,bool)
                 => ! [V4b3] :
                      ( mem(V4b3,bool)
                     => ! [V5b4] :
                          ( mem(V5b4,bool)
                         => ( p(ap(c_2Ebinary__ieee_2Eflags__DivideByZero,ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V0b),V1b0),V2b1),V3b2),V4b3),V5b4)))
                          <=> p(V0b) ) ) ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Eflags__InvalidOp,axiom,
    ! [V0b] :
      ( mem(V0b,bool)
     => ! [V1b0] :
          ( mem(V1b0,bool)
         => ! [V2b1] :
              ( mem(V2b1,bool)
             => ! [V3b2] :
                  ( mem(V3b2,bool)
                 => ! [V4b3] :
                      ( mem(V4b3,bool)
                     => ! [V5b4] :
                          ( mem(V5b4,bool)
                         => ( p(ap(c_2Ebinary__ieee_2Eflags__InvalidOp,ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V0b),V1b0),V2b1),V3b2),V4b3),V5b4)))
                          <=> p(V1b0) ) ) ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Eflags__Overflow,axiom,
    ! [V0b] :
      ( mem(V0b,bool)
     => ! [V1b0] :
          ( mem(V1b0,bool)
         => ! [V2b1] :
              ( mem(V2b1,bool)
             => ! [V3b2] :
                  ( mem(V3b2,bool)
                 => ! [V4b3] :
                      ( mem(V4b3,bool)
                     => ! [V5b4] :
                          ( mem(V5b4,bool)
                         => ( p(ap(c_2Ebinary__ieee_2Eflags__Overflow,ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V0b),V1b0),V2b1),V3b2),V4b3),V5b4)))
                          <=> p(V2b1) ) ) ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Eflags__Precision,axiom,
    ! [V0b] :
      ( mem(V0b,bool)
     => ! [V1b0] :
          ( mem(V1b0,bool)
         => ! [V2b1] :
              ( mem(V2b1,bool)
             => ! [V3b2] :
                  ( mem(V3b2,bool)
                 => ! [V4b3] :
                      ( mem(V4b3,bool)
                     => ! [V5b4] :
                          ( mem(V5b4,bool)
                         => ( p(ap(c_2Ebinary__ieee_2Eflags__Precision,ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V0b),V1b0),V2b1),V3b2),V4b3),V5b4)))
                          <=> p(V3b2) ) ) ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,axiom,
    ! [V0b] :
      ( mem(V0b,bool)
     => ! [V1b0] :
          ( mem(V1b0,bool)
         => ! [V2b1] :
              ( mem(V2b1,bool)
             => ! [V3b2] :
                  ( mem(V3b2,bool)
                 => ! [V4b3] :
                      ( mem(V4b3,bool)
                     => ! [V5b4] :
                          ( mem(V5b4,bool)
                         => ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V0b),V1b0),V2b1),V3b2),V4b3),V5b4)))
                          <=> p(V4b3) ) ) ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,axiom,
    ! [V0b] :
      ( mem(V0b,bool)
     => ! [V1b0] :
          ( mem(V1b0,bool)
         => ! [V2b1] :
              ( mem(V2b1,bool)
             => ! [V3b2] :
                  ( mem(V3b2,bool)
                 => ! [V4b3] :
                      ( mem(V4b3,bool)
                     => ! [V5b4] :
                          ( mem(V5b4,bool)
                         => ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V0b),V1b0),V2b1),V3b2),V4b3),V5b4)))
                          <=> p(V5b4) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Eflags__accessors,axiom,
    ( ! [V0b] :
        ( mem(V0b,bool)
       => ! [V1b0] :
            ( mem(V1b0,bool)
           => ! [V2b1] :
                ( mem(V2b1,bool)
               => ! [V3b2] :
                    ( mem(V3b2,bool)
                   => ! [V4b3] :
                        ( mem(V4b3,bool)
                       => ! [V5b4] :
                            ( mem(V5b4,bool)
                           => ( p(ap(c_2Ebinary__ieee_2Eflags__DivideByZero,ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V0b),V1b0),V2b1),V3b2),V4b3),V5b4)))
                            <=> p(V0b) ) ) ) ) ) ) )
    & ! [V6b] :
        ( mem(V6b,bool)
       => ! [V7b0] :
            ( mem(V7b0,bool)
           => ! [V8b1] :
                ( mem(V8b1,bool)
               => ! [V9b2] :
                    ( mem(V9b2,bool)
                   => ! [V10b3] :
                        ( mem(V10b3,bool)
                       => ! [V11b4] :
                            ( mem(V11b4,bool)
                           => ( p(ap(c_2Ebinary__ieee_2Eflags__InvalidOp,ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V6b),V7b0),V8b1),V9b2),V10b3),V11b4)))
                            <=> p(V7b0) ) ) ) ) ) ) )
    & ! [V12b] :
        ( mem(V12b,bool)
       => ! [V13b0] :
            ( mem(V13b0,bool)
           => ! [V14b1] :
                ( mem(V14b1,bool)
               => ! [V15b2] :
                    ( mem(V15b2,bool)
                   => ! [V16b3] :
                        ( mem(V16b3,bool)
                       => ! [V17b4] :
                            ( mem(V17b4,bool)
                           => ( p(ap(c_2Ebinary__ieee_2Eflags__Overflow,ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V12b),V13b0),V14b1),V15b2),V16b3),V17b4)))
                            <=> p(V14b1) ) ) ) ) ) ) )
    & ! [V18b] :
        ( mem(V18b,bool)
       => ! [V19b0] :
            ( mem(V19b0,bool)
           => ! [V20b1] :
                ( mem(V20b1,bool)
               => ! [V21b2] :
                    ( mem(V21b2,bool)
                   => ! [V22b3] :
                        ( mem(V22b3,bool)
                       => ! [V23b4] :
                            ( mem(V23b4,bool)
                           => ( p(ap(c_2Ebinary__ieee_2Eflags__Precision,ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V18b),V19b0),V20b1),V21b2),V22b3),V23b4)))
                            <=> p(V21b2) ) ) ) ) ) ) )
    & ! [V24b] :
        ( mem(V24b,bool)
       => ! [V25b0] :
            ( mem(V25b0,bool)
           => ! [V26b1] :
                ( mem(V26b1,bool)
               => ! [V27b2] :
                    ( mem(V27b2,bool)
                   => ! [V28b3] :
                        ( mem(V28b3,bool)
                       => ! [V29b4] :
                            ( mem(V29b4,bool)
                           => ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V24b),V25b0),V26b1),V27b2),V28b3),V29b4)))
                            <=> p(V28b3) ) ) ) ) ) ) )
    & ! [V30b] :
        ( mem(V30b,bool)
       => ! [V31b0] :
            ( mem(V31b0,bool)
           => ! [V32b1] :
                ( mem(V32b1,bool)
               => ! [V33b2] :
                    ( mem(V33b2,bool)
                   => ! [V34b3] :
                        ( mem(V34b3,bool)
                       => ! [V35b4] :
                            ( mem(V35b4,bool)
                           => ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V30b),V31b0),V32b1),V33b2),V34b3),V35b4)))
                            <=> p(V35b4) ) ) ) ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Eflags__DivideByZero__fupd,axiom,
    ! [V0f] :
      ( mem(V0f,arr(bool,bool))
     => ! [V1b] :
          ( mem(V1b,bool)
         => ! [V2b0] :
              ( mem(V2b0,bool)
             => ! [V3b1] :
                  ( mem(V3b1,bool)
                 => ! [V4b2] :
                      ( mem(V4b2,bool)
                     => ! [V5b3] :
                          ( mem(V5b3,bool)
                         => ! [V6b4] :
                              ( mem(V6b4,bool)
                             => ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V0f),ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V1b),V2b0),V3b1),V4b2),V5b3),V6b4)) = ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,ap(V0f,V1b)),V2b0),V3b1),V4b2),V5b3),V6b4) ) ) ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Eflags__InvalidOp__fupd,axiom,
    ! [V0f] :
      ( mem(V0f,arr(bool,bool))
     => ! [V1b] :
          ( mem(V1b,bool)
         => ! [V2b0] :
              ( mem(V2b0,bool)
             => ! [V3b1] :
                  ( mem(V3b1,bool)
                 => ! [V4b2] :
                      ( mem(V4b2,bool)
                     => ! [V5b3] :
                          ( mem(V5b3,bool)
                         => ! [V6b4] :
                              ( mem(V6b4,bool)
                             => ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V0f),ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V1b),V2b0),V3b1),V4b2),V5b3),V6b4)) = ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V1b),ap(V0f,V2b0)),V3b1),V4b2),V5b3),V6b4) ) ) ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Eflags__Overflow__fupd,axiom,
    ! [V0f] :
      ( mem(V0f,arr(bool,bool))
     => ! [V1b] :
          ( mem(V1b,bool)
         => ! [V2b0] :
              ( mem(V2b0,bool)
             => ! [V3b1] :
                  ( mem(V3b1,bool)
                 => ! [V4b2] :
                      ( mem(V4b2,bool)
                     => ! [V5b3] :
                          ( mem(V5b3,bool)
                         => ! [V6b4] :
                              ( mem(V6b4,bool)
                             => ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V0f),ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V1b),V2b0),V3b1),V4b2),V5b3),V6b4)) = ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V1b),V2b0),ap(V0f,V3b1)),V4b2),V5b3),V6b4) ) ) ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Eflags__Precision__fupd,axiom,
    ! [V0f] :
      ( mem(V0f,arr(bool,bool))
     => ! [V1b] :
          ( mem(V1b,bool)
         => ! [V2b0] :
              ( mem(V2b0,bool)
             => ! [V3b1] :
                  ( mem(V3b1,bool)
                 => ! [V4b2] :
                      ( mem(V4b2,bool)
                     => ! [V5b3] :
                          ( mem(V5b3,bool)
                         => ! [V6b4] :
                              ( mem(V6b4,bool)
                             => ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V0f),ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V1b),V2b0),V3b1),V4b2),V5b3),V6b4)) = ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V1b),V2b0),V3b1),ap(V0f,V4b2)),V5b3),V6b4) ) ) ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,axiom,
    ! [V0f] :
      ( mem(V0f,arr(bool,bool))
     => ! [V1b] :
          ( mem(V1b,bool)
         => ! [V2b0] :
              ( mem(V2b0,bool)
             => ! [V3b1] :
                  ( mem(V3b1,bool)
                 => ! [V4b2] :
                      ( mem(V4b2,bool)
                     => ! [V5b3] :
                          ( mem(V5b3,bool)
                         => ! [V6b4] :
                              ( mem(V6b4,bool)
                             => ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V0f),ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V1b),V2b0),V3b1),V4b2),V5b3),V6b4)) = ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V1b),V2b0),V3b1),V4b2),ap(V0f,V5b3)),V6b4) ) ) ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,axiom,
    ! [V0f] :
      ( mem(V0f,arr(bool,bool))
     => ! [V1b] :
          ( mem(V1b,bool)
         => ! [V2b0] :
              ( mem(V2b0,bool)
             => ! [V3b1] :
                  ( mem(V3b1,bool)
                 => ! [V4b2] :
                      ( mem(V4b2,bool)
                     => ! [V5b3] :
                          ( mem(V5b3,bool)
                         => ! [V6b4] :
                              ( mem(V6b4,bool)
                             => ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V0f),ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V1b),V2b0),V3b1),V4b2),V5b3),V6b4)) = ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V1b),V2b0),V3b1),V4b2),V5b3),ap(V0f,V6b4)) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Eflags__fn__updates,axiom,
    ( ! [V0f] :
        ( mem(V0f,arr(bool,bool))
       => ! [V1b] :
            ( mem(V1b,bool)
           => ! [V2b0] :
                ( mem(V2b0,bool)
               => ! [V3b1] :
                    ( mem(V3b1,bool)
                   => ! [V4b2] :
                        ( mem(V4b2,bool)
                       => ! [V5b3] :
                            ( mem(V5b3,bool)
                           => ! [V6b4] :
                                ( mem(V6b4,bool)
                               => ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V0f),ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V1b),V2b0),V3b1),V4b2),V5b3),V6b4)) = ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,ap(V0f,V1b)),V2b0),V3b1),V4b2),V5b3),V6b4) ) ) ) ) ) ) )
    & ! [V7f] :
        ( mem(V7f,arr(bool,bool))
       => ! [V8b] :
            ( mem(V8b,bool)
           => ! [V9b0] :
                ( mem(V9b0,bool)
               => ! [V10b1] :
                    ( mem(V10b1,bool)
                   => ! [V11b2] :
                        ( mem(V11b2,bool)
                       => ! [V12b3] :
                            ( mem(V12b3,bool)
                           => ! [V13b4] :
                                ( mem(V13b4,bool)
                               => ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V7f),ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V8b),V9b0),V10b1),V11b2),V12b3),V13b4)) = ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V8b),ap(V7f,V9b0)),V10b1),V11b2),V12b3),V13b4) ) ) ) ) ) ) )
    & ! [V14f] :
        ( mem(V14f,arr(bool,bool))
       => ! [V15b] :
            ( mem(V15b,bool)
           => ! [V16b0] :
                ( mem(V16b0,bool)
               => ! [V17b1] :
                    ( mem(V17b1,bool)
                   => ! [V18b2] :
                        ( mem(V18b2,bool)
                       => ! [V19b3] :
                            ( mem(V19b3,bool)
                           => ! [V20b4] :
                                ( mem(V20b4,bool)
                               => ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V14f),ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V15b),V16b0),V17b1),V18b2),V19b3),V20b4)) = ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V15b),V16b0),ap(V14f,V17b1)),V18b2),V19b3),V20b4) ) ) ) ) ) ) )
    & ! [V21f] :
        ( mem(V21f,arr(bool,bool))
       => ! [V22b] :
            ( mem(V22b,bool)
           => ! [V23b0] :
                ( mem(V23b0,bool)
               => ! [V24b1] :
                    ( mem(V24b1,bool)
                   => ! [V25b2] :
                        ( mem(V25b2,bool)
                       => ! [V26b3] :
                            ( mem(V26b3,bool)
                           => ! [V27b4] :
                                ( mem(V27b4,bool)
                               => ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V21f),ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V22b),V23b0),V24b1),V25b2),V26b3),V27b4)) = ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V22b),V23b0),V24b1),ap(V21f,V25b2)),V26b3),V27b4) ) ) ) ) ) ) )
    & ! [V28f] :
        ( mem(V28f,arr(bool,bool))
       => ! [V29b] :
            ( mem(V29b,bool)
           => ! [V30b0] :
                ( mem(V30b0,bool)
               => ! [V31b1] :
                    ( mem(V31b1,bool)
                   => ! [V32b2] :
                        ( mem(V32b2,bool)
                       => ! [V33b3] :
                            ( mem(V33b3,bool)
                           => ! [V34b4] :
                                ( mem(V34b4,bool)
                               => ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V28f),ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V29b),V30b0),V31b1),V32b2),V33b3),V34b4)) = ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V29b),V30b0),V31b1),V32b2),ap(V28f,V33b3)),V34b4) ) ) ) ) ) ) )
    & ! [V35f] :
        ( mem(V35f,arr(bool,bool))
       => ! [V36b] :
            ( mem(V36b,bool)
           => ! [V37b0] :
                ( mem(V37b0,bool)
               => ! [V38b1] :
                    ( mem(V38b1,bool)
                   => ! [V39b2] :
                        ( mem(V39b2,bool)
                       => ! [V40b3] :
                            ( mem(V40b3,bool)
                           => ! [V41b4] :
                                ( mem(V41b4,bool)
                               => ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V35f),ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V36b),V37b0),V38b1),V39b2),V40b3),V41b4)) = ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V36b),V37b0),V38b1),V39b2),V40b3),ap(V35f,V41b4)) ) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Eflags__accfupds,axiom,
    ( ! [V0f0] :
        ( mem(V0f0,arr(bool,bool))
       => ! [V1f] :
            ( mem(V1f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__DivideByZero,ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V0f0),V1f)))
            <=> p(ap(c_2Ebinary__ieee_2Eflags__DivideByZero,V1f)) ) ) )
    & ! [V2f0] :
        ( mem(V2f0,arr(bool,bool))
       => ! [V3f] :
            ( mem(V3f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__DivideByZero,ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V2f0),V3f)))
            <=> p(ap(c_2Ebinary__ieee_2Eflags__DivideByZero,V3f)) ) ) )
    & ! [V4f0] :
        ( mem(V4f0,arr(bool,bool))
       => ! [V5f] :
            ( mem(V5f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__DivideByZero,ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V4f0),V5f)))
            <=> p(ap(c_2Ebinary__ieee_2Eflags__DivideByZero,V5f)) ) ) )
    & ! [V6f0] :
        ( mem(V6f0,arr(bool,bool))
       => ! [V7f] :
            ( mem(V7f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__DivideByZero,ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V6f0),V7f)))
            <=> p(ap(c_2Ebinary__ieee_2Eflags__DivideByZero,V7f)) ) ) )
    & ! [V8f0] :
        ( mem(V8f0,arr(bool,bool))
       => ! [V9f] :
            ( mem(V9f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__DivideByZero,ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V8f0),V9f)))
            <=> p(ap(c_2Ebinary__ieee_2Eflags__DivideByZero,V9f)) ) ) )
    & ! [V10f0] :
        ( mem(V10f0,arr(bool,bool))
       => ! [V11f] :
            ( mem(V11f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__InvalidOp,ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V10f0),V11f)))
            <=> p(ap(c_2Ebinary__ieee_2Eflags__InvalidOp,V11f)) ) ) )
    & ! [V12f0] :
        ( mem(V12f0,arr(bool,bool))
       => ! [V13f] :
            ( mem(V13f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__InvalidOp,ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V12f0),V13f)))
            <=> p(ap(c_2Ebinary__ieee_2Eflags__InvalidOp,V13f)) ) ) )
    & ! [V14f0] :
        ( mem(V14f0,arr(bool,bool))
       => ! [V15f] :
            ( mem(V15f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__InvalidOp,ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V14f0),V15f)))
            <=> p(ap(c_2Ebinary__ieee_2Eflags__InvalidOp,V15f)) ) ) )
    & ! [V16f0] :
        ( mem(V16f0,arr(bool,bool))
       => ! [V17f] :
            ( mem(V17f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__InvalidOp,ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V16f0),V17f)))
            <=> p(ap(c_2Ebinary__ieee_2Eflags__InvalidOp,V17f)) ) ) )
    & ! [V18f0] :
        ( mem(V18f0,arr(bool,bool))
       => ! [V19f] :
            ( mem(V19f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__InvalidOp,ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V18f0),V19f)))
            <=> p(ap(c_2Ebinary__ieee_2Eflags__InvalidOp,V19f)) ) ) )
    & ! [V20f0] :
        ( mem(V20f0,arr(bool,bool))
       => ! [V21f] :
            ( mem(V21f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__Overflow,ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V20f0),V21f)))
            <=> p(ap(c_2Ebinary__ieee_2Eflags__Overflow,V21f)) ) ) )
    & ! [V22f0] :
        ( mem(V22f0,arr(bool,bool))
       => ! [V23f] :
            ( mem(V23f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__Overflow,ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V22f0),V23f)))
            <=> p(ap(c_2Ebinary__ieee_2Eflags__Overflow,V23f)) ) ) )
    & ! [V24f0] :
        ( mem(V24f0,arr(bool,bool))
       => ! [V25f] :
            ( mem(V25f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__Overflow,ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V24f0),V25f)))
            <=> p(ap(c_2Ebinary__ieee_2Eflags__Overflow,V25f)) ) ) )
    & ! [V26f0] :
        ( mem(V26f0,arr(bool,bool))
       => ! [V27f] :
            ( mem(V27f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__Overflow,ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V26f0),V27f)))
            <=> p(ap(c_2Ebinary__ieee_2Eflags__Overflow,V27f)) ) ) )
    & ! [V28f0] :
        ( mem(V28f0,arr(bool,bool))
       => ! [V29f] :
            ( mem(V29f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__Overflow,ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V28f0),V29f)))
            <=> p(ap(c_2Ebinary__ieee_2Eflags__Overflow,V29f)) ) ) )
    & ! [V30f0] :
        ( mem(V30f0,arr(bool,bool))
       => ! [V31f] :
            ( mem(V31f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__Precision,ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V30f0),V31f)))
            <=> p(ap(c_2Ebinary__ieee_2Eflags__Precision,V31f)) ) ) )
    & ! [V32f0] :
        ( mem(V32f0,arr(bool,bool))
       => ! [V33f] :
            ( mem(V33f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__Precision,ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V32f0),V33f)))
            <=> p(ap(c_2Ebinary__ieee_2Eflags__Precision,V33f)) ) ) )
    & ! [V34f0] :
        ( mem(V34f0,arr(bool,bool))
       => ! [V35f] :
            ( mem(V35f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__Precision,ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V34f0),V35f)))
            <=> p(ap(c_2Ebinary__ieee_2Eflags__Precision,V35f)) ) ) )
    & ! [V36f0] :
        ( mem(V36f0,arr(bool,bool))
       => ! [V37f] :
            ( mem(V37f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__Precision,ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V36f0),V37f)))
            <=> p(ap(c_2Ebinary__ieee_2Eflags__Precision,V37f)) ) ) )
    & ! [V38f0] :
        ( mem(V38f0,arr(bool,bool))
       => ! [V39f] :
            ( mem(V39f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__Precision,ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V38f0),V39f)))
            <=> p(ap(c_2Ebinary__ieee_2Eflags__Precision,V39f)) ) ) )
    & ! [V40f0] :
        ( mem(V40f0,arr(bool,bool))
       => ! [V41f] :
            ( mem(V41f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V40f0),V41f)))
            <=> p(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,V41f)) ) ) )
    & ! [V42f0] :
        ( mem(V42f0,arr(bool,bool))
       => ! [V43f] :
            ( mem(V43f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V42f0),V43f)))
            <=> p(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,V43f)) ) ) )
    & ! [V44f0] :
        ( mem(V44f0,arr(bool,bool))
       => ! [V45f] :
            ( mem(V45f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V44f0),V45f)))
            <=> p(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,V45f)) ) ) )
    & ! [V46f0] :
        ( mem(V46f0,arr(bool,bool))
       => ! [V47f] :
            ( mem(V47f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V46f0),V47f)))
            <=> p(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,V47f)) ) ) )
    & ! [V48f0] :
        ( mem(V48f0,arr(bool,bool))
       => ! [V49f] :
            ( mem(V49f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V48f0),V49f)))
            <=> p(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,V49f)) ) ) )
    & ! [V50f0] :
        ( mem(V50f0,arr(bool,bool))
       => ! [V51f] :
            ( mem(V51f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V50f0),V51f)))
            <=> p(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,V51f)) ) ) )
    & ! [V52f0] :
        ( mem(V52f0,arr(bool,bool))
       => ! [V53f] :
            ( mem(V53f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V52f0),V53f)))
            <=> p(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,V53f)) ) ) )
    & ! [V54f0] :
        ( mem(V54f0,arr(bool,bool))
       => ! [V55f] :
            ( mem(V55f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V54f0),V55f)))
            <=> p(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,V55f)) ) ) )
    & ! [V56f0] :
        ( mem(V56f0,arr(bool,bool))
       => ! [V57f] :
            ( mem(V57f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V56f0),V57f)))
            <=> p(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,V57f)) ) ) )
    & ! [V58f0] :
        ( mem(V58f0,arr(bool,bool))
       => ! [V59f] :
            ( mem(V59f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V58f0),V59f)))
            <=> p(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,V59f)) ) ) )
    & ! [V60f0] :
        ( mem(V60f0,arr(bool,bool))
       => ! [V61f] :
            ( mem(V61f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__DivideByZero,ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V60f0),V61f)))
            <=> p(ap(V60f0,ap(c_2Ebinary__ieee_2Eflags__DivideByZero,V61f))) ) ) )
    & ! [V62f0] :
        ( mem(V62f0,arr(bool,bool))
       => ! [V63f] :
            ( mem(V63f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__InvalidOp,ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V62f0),V63f)))
            <=> p(ap(V62f0,ap(c_2Ebinary__ieee_2Eflags__InvalidOp,V63f))) ) ) )
    & ! [V64f0] :
        ( mem(V64f0,arr(bool,bool))
       => ! [V65f] :
            ( mem(V65f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__Overflow,ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V64f0),V65f)))
            <=> p(ap(V64f0,ap(c_2Ebinary__ieee_2Eflags__Overflow,V65f))) ) ) )
    & ! [V66f0] :
        ( mem(V66f0,arr(bool,bool))
       => ! [V67f] :
            ( mem(V67f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__Precision,ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V66f0),V67f)))
            <=> p(ap(V66f0,ap(c_2Ebinary__ieee_2Eflags__Precision,V67f))) ) ) )
    & ! [V68f0] :
        ( mem(V68f0,arr(bool,bool))
       => ! [V69f] :
            ( mem(V69f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V68f0),V69f)))
            <=> p(ap(V68f0,ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,V69f))) ) ) )
    & ! [V70f0] :
        ( mem(V70f0,arr(bool,bool))
       => ! [V71f] :
            ( mem(V71f,ty_2Ebinary__ieee_2Eflags)
           => ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V70f0),V71f)))
            <=> p(ap(V70f0,ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,V71f))) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Eflags__fupdfupds,axiom,
    ( ! [V0g] :
        ( mem(V0g,arr(bool,bool))
       => ! [V1f0] :
            ( mem(V1f0,arr(bool,bool))
           => ! [V2f] :
                ( mem(V2f,ty_2Ebinary__ieee_2Eflags)
               => ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V1f0),ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V0g),V2f)) = ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V1f0),V0g)),V2f) ) ) )
    & ! [V3g] :
        ( mem(V3g,arr(bool,bool))
       => ! [V4f0] :
            ( mem(V4f0,arr(bool,bool))
           => ! [V5f] :
                ( mem(V5f,ty_2Ebinary__ieee_2Eflags)
               => ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V4f0),ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V3g),V5f)) = ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V4f0),V3g)),V5f) ) ) )
    & ! [V6g] :
        ( mem(V6g,arr(bool,bool))
       => ! [V7f0] :
            ( mem(V7f0,arr(bool,bool))
           => ! [V8f] :
                ( mem(V8f,ty_2Ebinary__ieee_2Eflags)
               => ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V7f0),ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V6g),V8f)) = ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V7f0),V6g)),V8f) ) ) )
    & ! [V9g] :
        ( mem(V9g,arr(bool,bool))
       => ! [V10f0] :
            ( mem(V10f0,arr(bool,bool))
           => ! [V11f] :
                ( mem(V11f,ty_2Ebinary__ieee_2Eflags)
               => ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V10f0),ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V9g),V11f)) = ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V10f0),V9g)),V11f) ) ) )
    & ! [V12g] :
        ( mem(V12g,arr(bool,bool))
       => ! [V13f0] :
            ( mem(V13f0,arr(bool,bool))
           => ! [V14f] :
                ( mem(V14f,ty_2Ebinary__ieee_2Eflags)
               => ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V13f0),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V12g),V14f)) = ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V13f0),V12g)),V14f) ) ) )
    & ! [V15g] :
        ( mem(V15g,arr(bool,bool))
       => ! [V16f0] :
            ( mem(V16f0,arr(bool,bool))
           => ! [V17f] :
                ( mem(V17f,ty_2Ebinary__ieee_2Eflags)
               => ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V16f0),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V15g),V17f)) = ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V16f0),V15g)),V17f) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Eflags__fupdfupds__comp,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ( ! [V0g] :
            ( mem(V0g,arr(bool,bool))
           => ! [V1f0] :
                ( mem(V1f0,arr(bool,bool))
               => ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V1f0)),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V0g)) = ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V1f0),V0g)) ) )
        & ! [V2h] :
            ( mem(V2h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
           => ! [V3g] :
                ( mem(V3g,arr(bool,bool))
               => ! [V4f0] :
                    ( mem(V4f0,arr(bool,bool))
                   => ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V4f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V3g)),V2h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V4f0),V3g))),V2h) ) ) )
        & ! [V5g] :
            ( mem(V5g,arr(bool,bool))
           => ! [V6f0] :
                ( mem(V6f0,arr(bool,bool))
               => ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V6f0)),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V5g)) = ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V6f0),V5g)) ) )
        & ! [V7h] :
            ( mem(V7h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
           => ! [V8g] :
                ( mem(V8g,arr(bool,bool))
               => ! [V9f0] :
                    ( mem(V9f0,arr(bool,bool))
                   => ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V9f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V8g)),V7h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V9f0),V8g))),V7h) ) ) )
        & ! [V10g] :
            ( mem(V10g,arr(bool,bool))
           => ! [V11f0] :
                ( mem(V11f0,arr(bool,bool))
               => ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V11f0)),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V10g)) = ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V11f0),V10g)) ) )
        & ! [V12h] :
            ( mem(V12h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
           => ! [V13g] :
                ( mem(V13g,arr(bool,bool))
               => ! [V14f0] :
                    ( mem(V14f0,arr(bool,bool))
                   => ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V14f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V13g)),V12h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V14f0),V13g))),V12h) ) ) )
        & ! [V15g] :
            ( mem(V15g,arr(bool,bool))
           => ! [V16f0] :
                ( mem(V16f0,arr(bool,bool))
               => ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V16f0)),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V15g)) = ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V16f0),V15g)) ) )
        & ! [V17h] :
            ( mem(V17h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
           => ! [V18g] :
                ( mem(V18g,arr(bool,bool))
               => ! [V19f0] :
                    ( mem(V19f0,arr(bool,bool))
                   => ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V19f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V18g)),V17h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V19f0),V18g))),V17h) ) ) )
        & ! [V20g] :
            ( mem(V20g,arr(bool,bool))
           => ! [V21f0] :
                ( mem(V21f0,arr(bool,bool))
               => ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V21f0)),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V20g)) = ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V21f0),V20g)) ) )
        & ! [V22h] :
            ( mem(V22h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
           => ! [V23g] :
                ( mem(V23g,arr(bool,bool))
               => ! [V24f0] :
                    ( mem(V24f0,arr(bool,bool))
                   => ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V24f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V23g)),V22h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V24f0),V23g))),V22h) ) ) )
        & ! [V25g] :
            ( mem(V25g,arr(bool,bool))
           => ! [V26f0] :
                ( mem(V26f0,arr(bool,bool))
               => ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V26f0)),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V25g)) = ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V26f0),V25g)) ) )
        & ! [V27h] :
            ( mem(V27h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
           => ! [V28g] :
                ( mem(V28g,arr(bool,bool))
               => ! [V29f0] :
                    ( mem(V29f0,arr(bool,bool))
                   => ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V29f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V28g)),V27h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,ap(ap(c_2Ecombin_2Eo(bool,bool,bool),V29f0),V28g))),V27h) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Eflags__fupdcanon,axiom,
    ( ! [V0g] :
        ( mem(V0g,arr(bool,bool))
       => ! [V1f0] :
            ( mem(V1f0,arr(bool,bool))
           => ! [V2f] :
                ( mem(V2f,ty_2Ebinary__ieee_2Eflags)
               => ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V1f0),ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V0g),V2f)) = ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V0g),ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V1f0),V2f)) ) ) )
    & ! [V3g] :
        ( mem(V3g,arr(bool,bool))
       => ! [V4f0] :
            ( mem(V4f0,arr(bool,bool))
           => ! [V5f] :
                ( mem(V5f,ty_2Ebinary__ieee_2Eflags)
               => ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V4f0),ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V3g),V5f)) = ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V3g),ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V4f0),V5f)) ) ) )
    & ! [V6g] :
        ( mem(V6g,arr(bool,bool))
       => ! [V7f0] :
            ( mem(V7f0,arr(bool,bool))
           => ! [V8f] :
                ( mem(V8f,ty_2Ebinary__ieee_2Eflags)
               => ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V7f0),ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V6g),V8f)) = ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V6g),ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V7f0),V8f)) ) ) )
    & ! [V9g] :
        ( mem(V9g,arr(bool,bool))
       => ! [V10f0] :
            ( mem(V10f0,arr(bool,bool))
           => ! [V11f] :
                ( mem(V11f,ty_2Ebinary__ieee_2Eflags)
               => ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V10f0),ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V9g),V11f)) = ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V9g),ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V10f0),V11f)) ) ) )
    & ! [V12g] :
        ( mem(V12g,arr(bool,bool))
       => ! [V13f0] :
            ( mem(V13f0,arr(bool,bool))
           => ! [V14f] :
                ( mem(V14f,ty_2Ebinary__ieee_2Eflags)
               => ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V13f0),ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V12g),V14f)) = ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V12g),ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V13f0),V14f)) ) ) )
    & ! [V15g] :
        ( mem(V15g,arr(bool,bool))
       => ! [V16f0] :
            ( mem(V16f0,arr(bool,bool))
           => ! [V17f] :
                ( mem(V17f,ty_2Ebinary__ieee_2Eflags)
               => ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V16f0),ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V15g),V17f)) = ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V15g),ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V16f0),V17f)) ) ) )
    & ! [V18g] :
        ( mem(V18g,arr(bool,bool))
       => ! [V19f0] :
            ( mem(V19f0,arr(bool,bool))
           => ! [V20f] :
                ( mem(V20f,ty_2Ebinary__ieee_2Eflags)
               => ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V19f0),ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V18g),V20f)) = ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V18g),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V19f0),V20f)) ) ) )
    & ! [V21g] :
        ( mem(V21g,arr(bool,bool))
       => ! [V22f0] :
            ( mem(V22f0,arr(bool,bool))
           => ! [V23f] :
                ( mem(V23f,ty_2Ebinary__ieee_2Eflags)
               => ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V22f0),ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V21g),V23f)) = ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V21g),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V22f0),V23f)) ) ) )
    & ! [V24g] :
        ( mem(V24g,arr(bool,bool))
       => ! [V25f0] :
            ( mem(V25f0,arr(bool,bool))
           => ! [V26f] :
                ( mem(V26f,ty_2Ebinary__ieee_2Eflags)
               => ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V25f0),ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V24g),V26f)) = ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V24g),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V25f0),V26f)) ) ) )
    & ! [V27g] :
        ( mem(V27g,arr(bool,bool))
       => ! [V28f0] :
            ( mem(V28f0,arr(bool,bool))
           => ! [V29f] :
                ( mem(V29f,ty_2Ebinary__ieee_2Eflags)
               => ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V28f0),ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V27g),V29f)) = ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V27g),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V28f0),V29f)) ) ) )
    & ! [V30g] :
        ( mem(V30g,arr(bool,bool))
       => ! [V31f0] :
            ( mem(V31f0,arr(bool,bool))
           => ! [V32f] :
                ( mem(V32f,ty_2Ebinary__ieee_2Eflags)
               => ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V31f0),ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V30g),V32f)) = ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V30g),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V31f0),V32f)) ) ) )
    & ! [V33g] :
        ( mem(V33g,arr(bool,bool))
       => ! [V34f0] :
            ( mem(V34f0,arr(bool,bool))
           => ! [V35f] :
                ( mem(V35f,ty_2Ebinary__ieee_2Eflags)
               => ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V34f0),ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V33g),V35f)) = ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V33g),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V34f0),V35f)) ) ) )
    & ! [V36g] :
        ( mem(V36g,arr(bool,bool))
       => ! [V37f0] :
            ( mem(V37f0,arr(bool,bool))
           => ! [V38f] :
                ( mem(V38f,ty_2Ebinary__ieee_2Eflags)
               => ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V37f0),ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V36g),V38f)) = ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V36g),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V37f0),V38f)) ) ) )
    & ! [V39g] :
        ( mem(V39g,arr(bool,bool))
       => ! [V40f0] :
            ( mem(V40f0,arr(bool,bool))
           => ! [V41f] :
                ( mem(V41f,ty_2Ebinary__ieee_2Eflags)
               => ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V40f0),ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V39g),V41f)) = ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V39g),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V40f0),V41f)) ) ) )
    & ! [V42g] :
        ( mem(V42g,arr(bool,bool))
       => ! [V43f0] :
            ( mem(V43f0,arr(bool,bool))
           => ! [V44f] :
                ( mem(V44f,ty_2Ebinary__ieee_2Eflags)
               => ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V43f0),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V42g),V44f)) = ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V42g),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V43f0),V44f)) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Eflags__fupdcanon__comp,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ( ! [V0g] :
            ( mem(V0g,arr(bool,bool))
           => ! [V1f0] :
                ( mem(V1f0,arr(bool,bool))
               => ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V1f0)),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V0g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V0g)),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V1f0)) ) )
        & ! [V2h] :
            ( mem(V2h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
           => ! [V3g] :
                ( mem(V3g,arr(bool,bool))
               => ! [V4f0] :
                    ( mem(V4f0,arr(bool,bool))
                   => ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V4f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V3g)),V2h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V3g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V4f0)),V2h)) ) ) )
        & ! [V5g] :
            ( mem(V5g,arr(bool,bool))
           => ! [V6f0] :
                ( mem(V6f0,arr(bool,bool))
               => ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V6f0)),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V5g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V5g)),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V6f0)) ) )
        & ! [V7h] :
            ( mem(V7h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
           => ! [V8g] :
                ( mem(V8g,arr(bool,bool))
               => ! [V9f0] :
                    ( mem(V9f0,arr(bool,bool))
                   => ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V9f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V8g)),V7h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V8g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V9f0)),V7h)) ) ) )
        & ! [V10g] :
            ( mem(V10g,arr(bool,bool))
           => ! [V11f0] :
                ( mem(V11f0,arr(bool,bool))
               => ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V11f0)),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V10g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V10g)),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V11f0)) ) )
        & ! [V12h] :
            ( mem(V12h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
           => ! [V13g] :
                ( mem(V13g,arr(bool,bool))
               => ! [V14f0] :
                    ( mem(V14f0,arr(bool,bool))
                   => ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V14f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V13g)),V12h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V13g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V14f0)),V12h)) ) ) )
        & ! [V15g] :
            ( mem(V15g,arr(bool,bool))
           => ! [V16f0] :
                ( mem(V16f0,arr(bool,bool))
               => ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V16f0)),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V15g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V15g)),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V16f0)) ) )
        & ! [V17h] :
            ( mem(V17h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
           => ! [V18g] :
                ( mem(V18g,arr(bool,bool))
               => ! [V19f0] :
                    ( mem(V19f0,arr(bool,bool))
                   => ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V19f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V18g)),V17h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V18g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V19f0)),V17h)) ) ) )
        & ! [V20g] :
            ( mem(V20g,arr(bool,bool))
           => ! [V21f0] :
                ( mem(V21f0,arr(bool,bool))
               => ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V21f0)),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V20g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V20g)),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V21f0)) ) )
        & ! [V22h] :
            ( mem(V22h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
           => ! [V23g] :
                ( mem(V23g,arr(bool,bool))
               => ! [V24f0] :
                    ( mem(V24f0,arr(bool,bool))
                   => ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V24f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V23g)),V22h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V23g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V24f0)),V22h)) ) ) )
        & ! [V25g] :
            ( mem(V25g,arr(bool,bool))
           => ! [V26f0] :
                ( mem(V26f0,arr(bool,bool))
               => ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V26f0)),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V25g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V25g)),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V26f0)) ) )
        & ! [V27h] :
            ( mem(V27h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
           => ! [V28g] :
                ( mem(V28g,arr(bool,bool))
               => ! [V29f0] :
                    ( mem(V29f0,arr(bool,bool))
                   => ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V29f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V28g)),V27h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V28g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V29f0)),V27h)) ) ) )
        & ! [V30g] :
            ( mem(V30g,arr(bool,bool))
           => ! [V31f0] :
                ( mem(V31f0,arr(bool,bool))
               => ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V31f0)),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V30g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V30g)),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V31f0)) ) )
        & ! [V32h] :
            ( mem(V32h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
           => ! [V33g] :
                ( mem(V33g,arr(bool,bool))
               => ! [V34f0] :
                    ( mem(V34f0,arr(bool,bool))
                   => ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V34f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V33g)),V32h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V33g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V34f0)),V32h)) ) ) )
        & ! [V35g] :
            ( mem(V35g,arr(bool,bool))
           => ! [V36f0] :
                ( mem(V36f0,arr(bool,bool))
               => ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V36f0)),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V35g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V35g)),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V36f0)) ) )
        & ! [V37h] :
            ( mem(V37h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
           => ! [V38g] :
                ( mem(V38g,arr(bool,bool))
               => ! [V39f0] :
                    ( mem(V39f0,arr(bool,bool))
                   => ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V39f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V38g)),V37h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V38g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V39f0)),V37h)) ) ) )
        & ! [V40g] :
            ( mem(V40g,arr(bool,bool))
           => ! [V41f0] :
                ( mem(V41f0,arr(bool,bool))
               => ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V41f0)),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V40g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V40g)),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V41f0)) ) )
        & ! [V42h] :
            ( mem(V42h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
           => ! [V43g] :
                ( mem(V43g,arr(bool,bool))
               => ! [V44f0] :
                    ( mem(V44f0,arr(bool,bool))
                   => ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V44f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V43g)),V42h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V43g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V44f0)),V42h)) ) ) )
        & ! [V45g] :
            ( mem(V45g,arr(bool,bool))
           => ! [V46f0] :
                ( mem(V46f0,arr(bool,bool))
               => ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V46f0)),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V45g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V45g)),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V46f0)) ) )
        & ! [V47h] :
            ( mem(V47h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
           => ! [V48g] :
                ( mem(V48g,arr(bool,bool))
               => ! [V49f0] :
                    ( mem(V49f0,arr(bool,bool))
                   => ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V49f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V48g)),V47h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V48g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V49f0)),V47h)) ) ) )
        & ! [V50g] :
            ( mem(V50g,arr(bool,bool))
           => ! [V51f0] :
                ( mem(V51f0,arr(bool,bool))
               => ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V51f0)),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V50g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V50g)),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V51f0)) ) )
        & ! [V52h] :
            ( mem(V52h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
           => ! [V53g] :
                ( mem(V53g,arr(bool,bool))
               => ! [V54f0] :
                    ( mem(V54f0,arr(bool,bool))
                   => ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V54f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V53g)),V52h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,V53g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V54f0)),V52h)) ) ) )
        & ! [V55g] :
            ( mem(V55g,arr(bool,bool))
           => ! [V56f0] :
                ( mem(V56f0,arr(bool,bool))
               => ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V56f0)),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V55g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V55g)),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V56f0)) ) )
        & ! [V57h] :
            ( mem(V57h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
           => ! [V58g] :
                ( mem(V58g,arr(bool,bool))
               => ! [V59f0] :
                    ( mem(V59f0,arr(bool,bool))
                   => ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V59f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V58g)),V57h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,V58g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V59f0)),V57h)) ) ) )
        & ! [V60g] :
            ( mem(V60g,arr(bool,bool))
           => ! [V61f0] :
                ( mem(V61f0,arr(bool,bool))
               => ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V61f0)),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V60g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V60g)),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V61f0)) ) )
        & ! [V62h] :
            ( mem(V62h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
           => ! [V63g] :
                ( mem(V63g,arr(bool,bool))
               => ! [V64f0] :
                    ( mem(V64f0,arr(bool,bool))
                   => ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V64f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V63g)),V62h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,V63g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V64f0)),V62h)) ) ) )
        & ! [V65g] :
            ( mem(V65g,arr(bool,bool))
           => ! [V66f0] :
                ( mem(V66f0,arr(bool,bool))
               => ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V66f0)),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V65g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V65g)),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V66f0)) ) )
        & ! [V67h] :
            ( mem(V67h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
           => ! [V68g] :
                ( mem(V68g,arr(bool,bool))
               => ! [V69f0] :
                    ( mem(V69f0,arr(bool,bool))
                   => ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V69f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V68g)),V67h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,V68g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V69f0)),V67h)) ) ) )
        & ! [V70g] :
            ( mem(V70g,arr(bool,bool))
           => ! [V71f0] :
                ( mem(V71f0,arr(bool,bool))
               => ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V71f0)),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V70g)) = ap(ap(c_2Ecombin_2Eo(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V70g)),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V71f0)) ) )
        & ! [V72h] :
            ( mem(V72h,arr(A_27a,ty_2Ebinary__ieee_2Eflags))
           => ! [V73g] :
                ( mem(V73g,arr(bool,bool))
               => ! [V74f0] :
                    ( mem(V74f0,arr(bool,bool))
                   => ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V74f0)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V73g)),V72h)) = ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,V73g)),ap(ap(c_2Ecombin_2Eo(A_27a,ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Eflags),ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,V74f0)),V72h)) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Eflags__component__equality,axiom,
    ! [V0f1] :
      ( mem(V0f1,ty_2Ebinary__ieee_2Eflags)
     => ! [V1f2] :
          ( mem(V1f2,ty_2Ebinary__ieee_2Eflags)
         => ( V0f1 = V1f2
          <=> ( ( p(ap(c_2Ebinary__ieee_2Eflags__DivideByZero,V0f1))
              <=> p(ap(c_2Ebinary__ieee_2Eflags__DivideByZero,V1f2)) )
              & ( p(ap(c_2Ebinary__ieee_2Eflags__InvalidOp,V0f1))
              <=> p(ap(c_2Ebinary__ieee_2Eflags__InvalidOp,V1f2)) )
              & ( p(ap(c_2Ebinary__ieee_2Eflags__Overflow,V0f1))
              <=> p(ap(c_2Ebinary__ieee_2Eflags__Overflow,V1f2)) )
              & ( p(ap(c_2Ebinary__ieee_2Eflags__Precision,V0f1))
              <=> p(ap(c_2Ebinary__ieee_2Eflags__Precision,V1f2)) )
              & ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,V0f1))
              <=> p(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,V1f2)) )
              & ( p(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,V0f1))
              <=> p(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,V1f2)) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Eflags__updates__eq__literal,axiom,
    ! [V0f] :
      ( mem(V0f,ty_2Ebinary__ieee_2Eflags)
     => ! [V1b4] :
          ( mem(V1b4,bool)
         => ! [V2b3] :
              ( mem(V2b3,bool)
             => ! [V3b2] :
                  ( mem(V3b2,bool)
                 => ! [V4b1] :
                      ( mem(V4b1,bool)
                     => ! [V5b0] :
                          ( mem(V5b0,bool)
                         => ! [V6b] :
                              ( mem(V6b,bool)
                             => ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,ap(c_2Ecombin_2EK(bool,bool),V1b4)),ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,ap(c_2Ecombin_2EK(bool,bool),V2b3)),ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,ap(c_2Ecombin_2EK(bool,bool),V3b2)),ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,ap(c_2Ecombin_2EK(bool,bool),V4b1)),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),V5b0)),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),V6b)),V0f)))))) = ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,ap(c_2Ecombin_2EK(bool,bool),V1b4)),ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,ap(c_2Ecombin_2EK(bool,bool),V2b3)),ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,ap(c_2Ecombin_2EK(bool,bool),V3b2)),ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,ap(c_2Ecombin_2EK(bool,bool),V4b1)),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),V5b0)),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),V6b)),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Eflags))))))) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Eflags__literal__nchotomy,axiom,
    ! [V0f] :
      ( mem(V0f,ty_2Ebinary__ieee_2Eflags)
     => ? [V1b4] :
          ( mem(V1b4,bool)
          & ? [V2b3] :
              ( mem(V2b3,bool)
              & ? [V3b2] :
                  ( mem(V3b2,bool)
                  & ? [V4b1] :
                      ( mem(V4b1,bool)
                      & ? [V5b0] :
                          ( mem(V5b0,bool)
                          & ? [V6b] :
                              ( mem(V6b,bool)
                              & V0f = ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,ap(c_2Ecombin_2EK(bool,bool),V1b4)),ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,ap(c_2Ecombin_2EK(bool,bool),V2b3)),ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,ap(c_2Ecombin_2EK(bool,bool),V3b2)),ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,ap(c_2Ecombin_2EK(bool,bool),V4b1)),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),V5b0)),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),V6b)),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Eflags))))))) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2EFORALL__flags,axiom,
    ! [V0P] :
      ( mem(V0P,arr(ty_2Ebinary__ieee_2Eflags,bool))
     => ( ! [V1f] :
            ( mem(V1f,ty_2Ebinary__ieee_2Eflags)
           => p(ap(V0P,V1f)) )
      <=> ! [V2b4] :
            ( mem(V2b4,bool)
           => ! [V3b3] :
                ( mem(V3b3,bool)
               => ! [V4b2] :
                    ( mem(V4b2,bool)
                   => ! [V5b1] :
                        ( mem(V5b1,bool)
                       => ! [V6b0] :
                            ( mem(V6b0,bool)
                           => ! [V7b] :
                                ( mem(V7b,bool)
                               => p(ap(V0P,ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,ap(c_2Ecombin_2EK(bool,bool),V2b4)),ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,ap(c_2Ecombin_2EK(bool,bool),V3b3)),ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,ap(c_2Ecombin_2EK(bool,bool),V4b2)),ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,ap(c_2Ecombin_2EK(bool,bool),V5b1)),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),V6b0)),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),V7b)),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Eflags))))))))) ) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2EEXISTS__flags,axiom,
    ! [V0P] :
      ( mem(V0P,arr(ty_2Ebinary__ieee_2Eflags,bool))
     => ( ? [V1f] :
            ( mem(V1f,ty_2Ebinary__ieee_2Eflags)
            & p(ap(V0P,V1f)) )
      <=> ? [V2b4] :
            ( mem(V2b4,bool)
            & ? [V3b3] :
                ( mem(V3b3,bool)
                & ? [V4b2] :
                    ( mem(V4b2,bool)
                    & ? [V5b1] :
                        ( mem(V5b1,bool)
                        & ? [V6b0] :
                            ( mem(V6b0,bool)
                            & ? [V7b] :
                                ( mem(V7b,bool)
                                & p(ap(V0P,ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,ap(c_2Ecombin_2EK(bool,bool),V2b4)),ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,ap(c_2Ecombin_2EK(bool,bool),V3b3)),ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,ap(c_2Ecombin_2EK(bool,bool),V4b2)),ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,ap(c_2Ecombin_2EK(bool,bool),V5b1)),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),V6b0)),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),V7b)),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Eflags))))))))) ) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Eflags__literal__11,axiom,
    ! [V0b41] :
      ( mem(V0b41,bool)
     => ! [V1b31] :
          ( mem(V1b31,bool)
         => ! [V2b21] :
              ( mem(V2b21,bool)
             => ! [V3b11] :
                  ( mem(V3b11,bool)
                 => ! [V4b01] :
                      ( mem(V4b01,bool)
                     => ! [V5b1] :
                          ( mem(V5b1,bool)
                         => ! [V6b42] :
                              ( mem(V6b42,bool)
                             => ! [V7b32] :
                                  ( mem(V7b32,bool)
                                 => ! [V8b22] :
                                      ( mem(V8b22,bool)
                                     => ! [V9b12] :
                                          ( mem(V9b12,bool)
                                         => ! [V10b02] :
                                              ( mem(V10b02,bool)
                                             => ! [V11b2] :
                                                  ( mem(V11b2,bool)
                                                 => ( ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,ap(c_2Ecombin_2EK(bool,bool),V0b41)),ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,ap(c_2Ecombin_2EK(bool,bool),V1b31)),ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,ap(c_2Ecombin_2EK(bool,bool),V2b21)),ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,ap(c_2Ecombin_2EK(bool,bool),V3b11)),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),V4b01)),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),V5b1)),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Eflags))))))) = ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,ap(c_2Ecombin_2EK(bool,bool),V6b42)),ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,ap(c_2Ecombin_2EK(bool,bool),V7b32)),ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,ap(c_2Ecombin_2EK(bool,bool),V8b22)),ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,ap(c_2Ecombin_2EK(bool,bool),V9b12)),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),V10b02)),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),V11b2)),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Eflags)))))))
                                                  <=> ( ( p(V0b41)
                                                      <=> p(V6b42) )
                                                      & ( p(V1b31)
                                                      <=> p(V7b32) )
                                                      & ( p(V2b21)
                                                      <=> p(V8b22) )
                                                      & ( p(V3b11)
                                                      <=> p(V9b12) )
                                                      & ( p(V4b01)
                                                      <=> p(V10b02) )
                                                      & ( p(V5b1)
                                                      <=> p(V11b2) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Edatatype__flags,axiom,
    ! [V0record] :
      ( mem(V0record,arr(ty_2Ebinary__ieee_2Eflags,arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,bool))))))))
     => ! [V1flags] :
          ( mem(V1flags,ty_2Ebinary__ieee_2Eflags)
         => ! [V2DivideByZero] :
              ( mem(V2DivideByZero,bool)
             => ! [V3InvalidOp] :
                  ( mem(V3InvalidOp,bool)
                 => ! [V4Overflow] :
                      ( mem(V4Overflow,bool)
                     => ! [V5Precision] :
                          ( mem(V5Precision,bool)
                         => ! [V6Underflow__BeforeRounding] :
                              ( mem(V6Underflow__BeforeRounding,bool)
                             => ! [V7Underflow__AfterRounding] :
                                  ( mem(V7Underflow__AfterRounding,bool)
                                 => p(ap(c_2Ebool_2EDATATYPE(bool),ap(ap(ap(ap(ap(ap(ap(V0record,V1flags),V2DivideByZero),V3InvalidOp),V4Overflow),V5Precision),V6Underflow__BeforeRounding),V7Underflow__AfterRounding))) ) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Eflags__11,axiom,
    ! [V0a0] :
      ( mem(V0a0,bool)
     => ! [V1a1] :
          ( mem(V1a1,bool)
         => ! [V2a2] :
              ( mem(V2a2,bool)
             => ! [V3a3] :
                  ( mem(V3a3,bool)
                 => ! [V4a4] :
                      ( mem(V4a4,bool)
                     => ! [V5a5] :
                          ( mem(V5a5,bool)
                         => ! [V6a0_27] :
                              ( mem(V6a0_27,bool)
                             => ! [V7a1_27] :
                                  ( mem(V7a1_27,bool)
                                 => ! [V8a2_27] :
                                      ( mem(V8a2_27,bool)
                                     => ! [V9a3_27] :
                                          ( mem(V9a3_27,bool)
                                         => ! [V10a4_27] :
                                              ( mem(V10a4_27,bool)
                                             => ! [V11a5_27] :
                                                  ( mem(V11a5_27,bool)
                                                 => ( ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V0a0),V1a1),V2a2),V3a3),V4a4),V5a5) = ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V6a0_27),V7a1_27),V8a2_27),V9a3_27),V10a4_27),V11a5_27)
                                                  <=> ( ( p(V0a0)
                                                      <=> p(V6a0_27) )
                                                      & ( p(V1a1)
                                                      <=> p(V7a1_27) )
                                                      & ( p(V2a2)
                                                      <=> p(V8a2_27) )
                                                      & ( p(V3a3)
                                                      <=> p(V9a3_27) )
                                                      & ( p(V4a4)
                                                      <=> p(V10a4_27) )
                                                      & ( p(V5a5)
                                                      <=> p(V11a5_27) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Eflags__nchotomy,axiom,
    ! [V0ff] :
      ( mem(V0ff,ty_2Ebinary__ieee_2Eflags)
     => ? [V1b] :
          ( mem(V1b,bool)
          & ? [V2b0] :
              ( mem(V2b0,bool)
              & ? [V3b1] :
                  ( mem(V3b1,bool)
                  & ? [V4b2] :
                      ( mem(V4b2,bool)
                      & ? [V5b3] :
                          ( mem(V5b3,bool)
                          & ? [V6b4] :
                              ( mem(V6b4,bool)
                              & V0ff = ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V1b),V2b0),V3b1),V4b2),V5b3),V6b4) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Eflags__Axiom,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [V0f] :
          ( mem(V0f,arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,A_27a)))))))
         => ? [V1fn] :
              ( mem(V1fn,arr(ty_2Ebinary__ieee_2Eflags,A_27a))
              & ! [V2a0] :
                  ( mem(V2a0,bool)
                 => ! [V3a1] :
                      ( mem(V3a1,bool)
                     => ! [V4a2] :
                          ( mem(V4a2,bool)
                         => ! [V5a3] :
                              ( mem(V5a3,bool)
                             => ! [V6a4] :
                                  ( mem(V6a4,bool)
                                 => ! [V7a5] :
                                      ( mem(V7a5,bool)
                                     => ap(V1fn,ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V2a0),V3a1),V4a2),V5a3),V6a4),V7a5)) = ap(ap(ap(ap(ap(ap(V0f,V2a0),V3a1),V4a2),V5a3),V6a4),V7a5) ) ) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Eflags__induction,axiom,
    ! [V0P] :
      ( mem(V0P,arr(ty_2Ebinary__ieee_2Eflags,bool))
     => ( ! [V1b] :
            ( mem(V1b,bool)
           => ! [V2b0] :
                ( mem(V2b0,bool)
               => ! [V3b1] :
                    ( mem(V3b1,bool)
                   => ! [V4b2] :
                        ( mem(V4b2,bool)
                       => ! [V5b3] :
                            ( mem(V5b3,bool)
                           => ! [V6b4] :
                                ( mem(V6b4,bool)
                               => p(ap(V0P,ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V1b),V2b0),V3b1),V4b2),V5b3),V6b4))) ) ) ) ) ) )
       => ! [V7f] :
            ( mem(V7f,ty_2Ebinary__ieee_2Eflags)
           => p(ap(V0P,V7f)) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Eflags__case__cong,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [V0f_27] :
          ( mem(V0f_27,arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,A_27a)))))))
         => ! [V1M] :
              ( mem(V1M,ty_2Ebinary__ieee_2Eflags)
             => ! [V2M_27] :
                  ( mem(V2M_27,ty_2Ebinary__ieee_2Eflags)
                 => ! [V3f] :
                      ( mem(V3f,arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,A_27a)))))))
                     => ( ( V1M = V2M_27
                          & ! [V4a0] :
                              ( mem(V4a0,bool)
                             => ! [V5a1] :
                                  ( mem(V5a1,bool)
                                 => ! [V6a2] :
                                      ( mem(V6a2,bool)
                                     => ! [V7a3] :
                                          ( mem(V7a3,bool)
                                         => ! [V8a4] :
                                              ( mem(V8a4,bool)
                                             => ! [V9a5] :
                                                  ( mem(V9a5,bool)
                                                 => ( V2M_27 = ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V4a0),V5a1),V6a2),V7a3),V8a4),V9a5)
                                                   => ap(ap(ap(ap(ap(ap(V3f,V4a0),V5a1),V6a2),V7a3),V8a4),V9a5) = ap(ap(ap(ap(ap(ap(V0f_27,V4a0),V5a1),V6a2),V7a3),V8a4),V9a5) ) ) ) ) ) ) ) )
                       => ap(ap(c_2Ebinary__ieee_2Eflags__CASE(A_27a),V1M),V3f) = ap(ap(c_2Ebinary__ieee_2Eflags__CASE(A_27a),V2M_27),V0f_27) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Eflags__case__eq,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [V0x] :
          ( mem(V0x,ty_2Ebinary__ieee_2Eflags)
         => ! [V1f] :
              ( mem(V1f,arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,arr(bool,A_27a)))))))
             => ! [V2v] :
                  ( mem(V2v,A_27a)
                 => ( ap(ap(c_2Ebinary__ieee_2Eflags__CASE(A_27a),V0x),V1f) = V2v
                  <=> ? [V3b] :
                        ( mem(V3b,bool)
                        & ? [V4b0] :
                            ( mem(V4b0,bool)
                            & ? [V5b1] :
                                ( mem(V5b1,bool)
                                & ? [V6b2] :
                                    ( mem(V6b2,bool)
                                    & ? [V7b3] :
                                        ( mem(V7b3,bool)
                                        & ? [V8b4] :
                                            ( mem(V8b4,bool)
                                            & V0x = ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erecordtype_2Eflags,V3b),V4b0),V5b1),V6b2),V7b3),V8b4)
                                            & ap(ap(ap(ap(ap(ap(V1f,V3b),V4b0),V5b1),V6b2),V7b3),V8b4) = V2v ) ) ) ) ) ) ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Eclear__flags__def,axiom,
    c_2Ebinary__ieee_2Eclear__flags = ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,ap(c_2Ecombin_2EK(bool,bool),c_2Ebool_2EF)),ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,ap(c_2Ecombin_2EK(bool,bool),c_2Ebool_2EF)),ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,ap(c_2Ecombin_2EK(bool,bool),c_2Ebool_2EF)),ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,ap(c_2Ecombin_2EK(bool,bool),c_2Ebool_2EF)),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),c_2Ebool_2EF)),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),c_2Ebool_2EF)),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Eflags))))))) ).

fof(ax_thm_2Ebinary__ieee_2Einvalidop__flags__def,axiom,
    c_2Ebinary__ieee_2Einvalidop__flags = ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,ap(c_2Ecombin_2EK(bool,bool),c_2Ebool_2ET)),c_2Ebinary__ieee_2Eclear__flags) ).

fof(ax_thm_2Ebinary__ieee_2Edividezero__flags__def,axiom,
    c_2Ebinary__ieee_2Edividezero__flags = ap(ap(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,ap(c_2Ecombin_2EK(bool,bool),c_2Ebool_2ET)),c_2Ebinary__ieee_2Eclear__flags) ).

fof(lameq_f2948,axiom,
    ! [V1n] : ap(f2948,V1n) = ap(ap(c_2Eprim__rec_2E_3C,V1n),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)))) ).

fof(ax_thm_2Ebinary__ieee_2Erounding__TY__DEF,axiom,
    ? [V0rep] :
      ( mem(V0rep,arr(ty_2Ebinary__ieee_2Erounding,ty_2Enum_2Enum))
      & p(ap(ap(c_2Ebool_2ETYPE__DEFINITION(ty_2Enum_2Enum,ty_2Ebinary__ieee_2Erounding),f2948),V0rep)) ) ).

fof(lameq_f2949,axiom,
    ! [V2n] : ap(f2949,V2n) = ap(ap(c_2Eprim__rec_2E_3C,V2n),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)))) ).

fof(ax_thm_2Ebinary__ieee_2Erounding__BIJ,axiom,
    ( ! [V0a] :
        ( mem(V0a,ty_2Ebinary__ieee_2Erounding)
       => ap(c_2Ebinary__ieee_2Enum2rounding,ap(c_2Ebinary__ieee_2Erounding2num,V0a)) = V0a )
    & ! [V1r] :
        ( mem(V1r,ty_2Enum_2Enum)
       => ( p(ap(f2949,V1r))
        <=> ap(c_2Ebinary__ieee_2Erounding2num,ap(c_2Ebinary__ieee_2Enum2rounding,V1r)) = V1r ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Enum2rounding__rounding2num,axiom,
    ! [V0a] :
      ( mem(V0a,ty_2Ebinary__ieee_2Erounding)
     => ap(c_2Ebinary__ieee_2Enum2rounding,ap(c_2Ebinary__ieee_2Erounding2num,V0a)) = V0a ) ).

fof(conj_thm_2Ebinary__ieee_2Erounding2num__num2rounding,axiom,
    ! [V0r] :
      ( mem(V0r,ty_2Enum_2Enum)
     => ( p(ap(ap(c_2Eprim__rec_2E_3C,V0r),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)))))
      <=> ap(c_2Ebinary__ieee_2Erounding2num,ap(c_2Ebinary__ieee_2Enum2rounding,V0r)) = V0r ) ) ).

fof(conj_thm_2Ebinary__ieee_2Enum2rounding__11,axiom,
    ! [V0r] :
      ( mem(V0r,ty_2Enum_2Enum)
     => ! [V1r_27] :
          ( mem(V1r_27,ty_2Enum_2Enum)
         => ( p(ap(ap(c_2Eprim__rec_2E_3C,V0r),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)))))
           => ( p(ap(ap(c_2Eprim__rec_2E_3C,V1r_27),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)))))
             => ( ap(c_2Ebinary__ieee_2Enum2rounding,V0r) = ap(c_2Ebinary__ieee_2Enum2rounding,V1r_27)
              <=> V0r = V1r_27 ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Erounding2num__11,axiom,
    ! [V0a] :
      ( mem(V0a,ty_2Ebinary__ieee_2Erounding)
     => ! [V1a_27] :
          ( mem(V1a_27,ty_2Ebinary__ieee_2Erounding)
         => ( ap(c_2Ebinary__ieee_2Erounding2num,V0a) = ap(c_2Ebinary__ieee_2Erounding2num,V1a_27)
          <=> V0a = V1a_27 ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Enum2rounding__ONTO,axiom,
    ! [V0a] :
      ( mem(V0a,ty_2Ebinary__ieee_2Erounding)
     => ? [V1r] :
          ( mem(V1r,ty_2Enum_2Enum)
          & V0a = ap(c_2Ebinary__ieee_2Enum2rounding,V1r)
          & p(ap(ap(c_2Eprim__rec_2E_3C,V1r),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))))) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Erounding2num__ONTO,axiom,
    ! [V0r] :
      ( mem(V0r,ty_2Enum_2Enum)
     => ( p(ap(ap(c_2Eprim__rec_2E_3C,V0r),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)))))
      <=> ? [V1a] :
            ( mem(V1a,ty_2Ebinary__ieee_2Erounding)
            & V0r = ap(c_2Ebinary__ieee_2Erounding2num,V1a) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Enum2rounding__thm,axiom,
    ( ap(c_2Ebinary__ieee_2Enum2rounding,c_2Enum_2E0) = c_2Ebinary__ieee_2EroundTiesToEven
    & ap(c_2Ebinary__ieee_2Enum2rounding,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))) = c_2Ebinary__ieee_2EroundTowardPositive
    & ap(c_2Ebinary__ieee_2Enum2rounding,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO))) = c_2Ebinary__ieee_2EroundTowardNegative
    & ap(c_2Ebinary__ieee_2Enum2rounding,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)))) = c_2Ebinary__ieee_2EroundTowardZero ) ).

fof(conj_thm_2Ebinary__ieee_2Erounding2num__thm,axiom,
    ( ap(c_2Ebinary__ieee_2Erounding2num,c_2Ebinary__ieee_2EroundTiesToEven) = c_2Enum_2E0
    & ap(c_2Ebinary__ieee_2Erounding2num,c_2Ebinary__ieee_2EroundTowardPositive) = ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))
    & ap(c_2Ebinary__ieee_2Erounding2num,c_2Ebinary__ieee_2EroundTowardNegative) = ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO))
    & ap(c_2Ebinary__ieee_2Erounding2num,c_2Ebinary__ieee_2EroundTowardZero) = ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))) ) ).

fof(conj_thm_2Ebinary__ieee_2Erounding__EQ__rounding,axiom,
    ! [V0a] :
      ( mem(V0a,ty_2Ebinary__ieee_2Erounding)
     => ! [V1a_27] :
          ( mem(V1a_27,ty_2Ebinary__ieee_2Erounding)
         => ( V0a = V1a_27
          <=> ap(c_2Ebinary__ieee_2Erounding2num,V0a) = ap(c_2Ebinary__ieee_2Erounding2num,V1a_27) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Erounding__size__def,axiom,
    ! [V0x] :
      ( mem(V0x,ty_2Ebinary__ieee_2Erounding)
     => ap(c_2Ebinary__ieee_2Erounding__size,V0x) = c_2Enum_2E0 ) ).

fof(lameq_f2950,axiom,
    ! [A_27a,V2v1] :
      ( mem(V2v1,A_27a)
     => ! [V3v2] :
          ( mem(V3v2,A_27a)
         => ! [V4v3] :
              ( mem(V4v3,A_27a)
             => ! [V1v0] :
                  ( mem(V1v0,A_27a)
                 => ! [V5m] : ap(f2950(A_27a,V2v1,V3v2,V4v3,V1v0),V5m) = ap(ap(ap(c_2Ebool_2ECOND(A_27a),ap(ap(c_2Eprim__rec_2E_3C,V5m),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)))),V1v0),ap(ap(ap(c_2Ebool_2ECOND(A_27a),ap(ap(c_2Eprim__rec_2E_3C,V5m),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),V2v1),ap(ap(ap(c_2Ebool_2ECOND(A_27a),ap(ap(c_2Emin_2E_3D(ty_2Enum_2Enum),V5m),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),V3v2),V4v3))) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Erounding__CASE,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [V0x] :
          ( mem(V0x,ty_2Ebinary__ieee_2Erounding)
         => ! [V1v0] :
              ( mem(V1v0,A_27a)
             => ! [V2v1] :
                  ( mem(V2v1,A_27a)
                 => ! [V3v2] :
                      ( mem(V3v2,A_27a)
                     => ! [V4v3] :
                          ( mem(V4v3,A_27a)
                         => ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erounding__CASE(A_27a),V0x),V1v0),V2v1),V3v2),V4v3) = ap(f2950(A_27a,V2v1,V3v2,V4v3,V1v0),ap(c_2Ebinary__ieee_2Erounding2num,V0x)) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Erounding__case__def,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ( ! [V0v0] :
            ( mem(V0v0,A_27a)
           => ! [V1v1] :
                ( mem(V1v1,A_27a)
               => ! [V2v2] :
                    ( mem(V2v2,A_27a)
                   => ! [V3v3] :
                        ( mem(V3v3,A_27a)
                       => ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erounding__CASE(A_27a),c_2Ebinary__ieee_2EroundTiesToEven),V0v0),V1v1),V2v2),V3v3) = V0v0 ) ) ) )
        & ! [V4v0] :
            ( mem(V4v0,A_27a)
           => ! [V5v1] :
                ( mem(V5v1,A_27a)
               => ! [V6v2] :
                    ( mem(V6v2,A_27a)
                   => ! [V7v3] :
                        ( mem(V7v3,A_27a)
                       => ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erounding__CASE(A_27a),c_2Ebinary__ieee_2EroundTowardPositive),V4v0),V5v1),V6v2),V7v3) = V5v1 ) ) ) )
        & ! [V8v0] :
            ( mem(V8v0,A_27a)
           => ! [V9v1] :
                ( mem(V9v1,A_27a)
               => ! [V10v2] :
                    ( mem(V10v2,A_27a)
                   => ! [V11v3] :
                        ( mem(V11v3,A_27a)
                       => ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erounding__CASE(A_27a),c_2Ebinary__ieee_2EroundTowardNegative),V8v0),V9v1),V10v2),V11v3) = V10v2 ) ) ) )
        & ! [V12v0] :
            ( mem(V12v0,A_27a)
           => ! [V13v1] :
                ( mem(V13v1,A_27a)
               => ! [V14v2] :
                    ( mem(V14v2,A_27a)
                   => ! [V15v3] :
                        ( mem(V15v3,A_27a)
                       => ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erounding__CASE(A_27a),c_2Ebinary__ieee_2EroundTowardZero),V12v0),V13v1),V14v2),V15v3) = V15v3 ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Edatatype__rounding,axiom,
    ! [V0rounding] :
      ( mem(V0rounding,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Erounding,bool)))))
     => p(ap(c_2Ebool_2EDATATYPE(bool),ap(ap(ap(ap(V0rounding,c_2Ebinary__ieee_2EroundTiesToEven),c_2Ebinary__ieee_2EroundTowardPositive),c_2Ebinary__ieee_2EroundTowardNegative),c_2Ebinary__ieee_2EroundTowardZero))) ) ).

fof(conj_thm_2Ebinary__ieee_2Erounding__distinct,axiom,
    ( c_2Ebinary__ieee_2EroundTiesToEven != c_2Ebinary__ieee_2EroundTowardPositive
    & c_2Ebinary__ieee_2EroundTiesToEven != c_2Ebinary__ieee_2EroundTowardNegative
    & c_2Ebinary__ieee_2EroundTiesToEven != c_2Ebinary__ieee_2EroundTowardZero
    & c_2Ebinary__ieee_2EroundTowardPositive != c_2Ebinary__ieee_2EroundTowardNegative
    & c_2Ebinary__ieee_2EroundTowardPositive != c_2Ebinary__ieee_2EroundTowardZero
    & c_2Ebinary__ieee_2EroundTowardNegative != c_2Ebinary__ieee_2EroundTowardZero ) ).

fof(conj_thm_2Ebinary__ieee_2Erounding__nchotomy,axiom,
    ! [V0a] :
      ( mem(V0a,ty_2Ebinary__ieee_2Erounding)
     => ( V0a = c_2Ebinary__ieee_2EroundTiesToEven
        | V0a = c_2Ebinary__ieee_2EroundTowardPositive
        | V0a = c_2Ebinary__ieee_2EroundTowardNegative
        | V0a = c_2Ebinary__ieee_2EroundTowardZero ) ) ).

fof(conj_thm_2Ebinary__ieee_2Erounding__Axiom,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [V0x0] :
          ( mem(V0x0,A_27a)
         => ! [V1x1] :
              ( mem(V1x1,A_27a)
             => ! [V2x2] :
                  ( mem(V2x2,A_27a)
                 => ! [V3x3] :
                      ( mem(V3x3,A_27a)
                     => ? [V4f] :
                          ( mem(V4f,arr(ty_2Ebinary__ieee_2Erounding,A_27a))
                          & ap(V4f,c_2Ebinary__ieee_2EroundTiesToEven) = V0x0
                          & ap(V4f,c_2Ebinary__ieee_2EroundTowardPositive) = V1x1
                          & ap(V4f,c_2Ebinary__ieee_2EroundTowardNegative) = V2x2
                          & ap(V4f,c_2Ebinary__ieee_2EroundTowardZero) = V3x3 ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Erounding__induction,axiom,
    ! [V0P] :
      ( mem(V0P,arr(ty_2Ebinary__ieee_2Erounding,bool))
     => ( ( p(ap(V0P,c_2Ebinary__ieee_2EroundTiesToEven))
          & p(ap(V0P,c_2Ebinary__ieee_2EroundTowardNegative))
          & p(ap(V0P,c_2Ebinary__ieee_2EroundTowardPositive))
          & p(ap(V0P,c_2Ebinary__ieee_2EroundTowardZero)) )
       => ! [V1a] :
            ( mem(V1a,ty_2Ebinary__ieee_2Erounding)
           => p(ap(V0P,V1a)) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Erounding__case__cong,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [V0v0_27] :
          ( mem(V0v0_27,A_27a)
         => ! [V1v1_27] :
              ( mem(V1v1_27,A_27a)
             => ! [V2v2_27] :
                  ( mem(V2v2_27,A_27a)
                 => ! [V3v3_27] :
                      ( mem(V3v3_27,A_27a)
                     => ! [V4M] :
                          ( mem(V4M,ty_2Ebinary__ieee_2Erounding)
                         => ! [V5M_27] :
                              ( mem(V5M_27,ty_2Ebinary__ieee_2Erounding)
                             => ! [V6v0] :
                                  ( mem(V6v0,A_27a)
                                 => ! [V7v1] :
                                      ( mem(V7v1,A_27a)
                                     => ! [V8v2] :
                                          ( mem(V8v2,A_27a)
                                         => ! [V9v3] :
                                              ( mem(V9v3,A_27a)
                                             => ( ( V4M = V5M_27
                                                  & ( V5M_27 = c_2Ebinary__ieee_2EroundTiesToEven
                                                   => V6v0 = V0v0_27 )
                                                  & ( V5M_27 = c_2Ebinary__ieee_2EroundTowardPositive
                                                   => V7v1 = V1v1_27 )
                                                  & ( V5M_27 = c_2Ebinary__ieee_2EroundTowardNegative
                                                   => V8v2 = V2v2_27 )
                                                  & ( V5M_27 = c_2Ebinary__ieee_2EroundTowardZero
                                                   => V9v3 = V3v3_27 ) )
                                               => ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erounding__CASE(A_27a),V4M),V6v0),V7v1),V8v2),V9v3) = ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erounding__CASE(A_27a),V5M_27),V0v0_27),V1v1_27),V2v2_27),V3v3_27) ) ) ) ) ) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Erounding__case__eq,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [V0x] :
          ( mem(V0x,ty_2Ebinary__ieee_2Erounding)
         => ! [V1v0] :
              ( mem(V1v0,A_27a)
             => ! [V2v1] :
                  ( mem(V2v1,A_27a)
                 => ! [V3v2] :
                      ( mem(V3v2,A_27a)
                     => ! [V4v3] :
                          ( mem(V4v3,A_27a)
                         => ! [V5v] :
                              ( mem(V5v,A_27a)
                             => ( ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erounding__CASE(A_27a),V0x),V1v0),V2v1),V3v2),V4v3) = V5v
                              <=> ( ( V0x = c_2Ebinary__ieee_2EroundTiesToEven
                                    & V1v0 = V5v )
                                  | ( V0x = c_2Ebinary__ieee_2EroundTowardPositive
                                    & V2v1 = V5v )
                                  | ( V0x = c_2Ebinary__ieee_2EroundTowardNegative
                                    & V3v2 = V5v )
                                  | ( V0x = c_2Ebinary__ieee_2EroundTowardZero
                                    & V4v3 = V5v ) ) ) ) ) ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Eis__closest__def,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27b] :
          ( ne(A_27b)
         => ! [V0s] :
              ( mem(V0s,arr(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b),bool))
             => ! [V1x] :
                  ( mem(V1x,ty_2Erealax_2Ereal)
                 => ! [V2a] :
                      ( mem(V2a,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b))
                     => ( p(ap(ap(ap(c_2Ebinary__ieee_2Eis__closest(A_27a,A_27b),V0s),V1x),V2a))
                      <=> ( p(ap(ap(c_2Ebool_2EIN(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b)),V2a),V0s))
                          & ! [V3b] :
                              ( mem(V3b,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b))
                             => ( p(ap(ap(c_2Ebool_2EIN(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b)),V3b),V0s))
                               => p(ap(ap(c_2Ereal_2Ereal__lte,ap(c_2Ereal_2Eabs,ap(ap(c_2Ereal_2Ereal__sub,ap(c_2Ebinary__ieee_2Efloat__to__real(A_27a,A_27b),V2a)),V1x))),ap(c_2Ereal_2Eabs,ap(ap(c_2Ereal_2Ereal__sub,ap(c_2Ebinary__ieee_2Efloat__to__real(A_27a,A_27b),V3b)),V1x)))) ) ) ) ) ) ) ) ) ) ).

fof(lameq_f2951,axiom,
    ! [A_27a,A_27b,V2x] :
      ( mem(V2x,ty_2Erealax_2Ereal)
     => ! [V1s] :
          ( mem(V1s,arr(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b),bool))
         => ! [V0p] :
              ( mem(V0p,arr(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b),bool))
             => ! [V3a] :
                  ( mem(V3a,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b))
                 => ! [V4b] : ap(f2951(A_27a,A_27b,V2x,V1s,V0p,V3a),V4b) = ap(ap(c_2Emin_2E_3D_3D_3E,ap(ap(c_2Ebool_2E_2F_5C,ap(ap(ap(c_2Ebinary__ieee_2Eis__closest(A_27a,A_27b),V1s),V2x),V4b)),ap(V0p,V4b))),ap(V0p,V3a)) ) ) ) ) ).

fof(lameq_f2952,axiom,
    ! [A_27a,A_27b,V0p] :
      ( mem(V0p,arr(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b),bool))
     => ! [V1s] :
          ( mem(V1s,arr(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b),bool))
         => ! [V2x] :
              ( mem(V2x,ty_2Erealax_2Ereal)
             => ! [V3a] : ap(f2952(A_27a,A_27b,V0p,V1s,V2x),V3a) = ap(ap(c_2Ebool_2E_2F_5C,ap(ap(ap(c_2Ebinary__ieee_2Eis__closest(A_27a,A_27b),V1s),V2x),V3a)),ap(c_2Ebool_2E_21(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b)),f2951(A_27a,A_27b,V2x,V1s,V0p,V3a))) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Eclosest__such__def,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27b] :
          ( ne(A_27b)
         => ! [V0p] :
              ( mem(V0p,arr(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b),bool))
             => ! [V1s] :
                  ( mem(V1s,arr(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b),bool))
                 => ! [V2x] :
                      ( mem(V2x,ty_2Erealax_2Ereal)
                     => ap(ap(ap(c_2Ebinary__ieee_2Eclosest__such(A_27a,A_27b),V0p),V1s),V2x) = ap(c_2Emin_2E_40(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b)),f2952(A_27a,A_27b,V0p,V1s,V2x)) ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Eclosest__def,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27b] :
          ( ne(A_27b)
         => c_2Ebinary__ieee_2Eclosest(A_27a,A_27b) = ap(c_2Ebinary__ieee_2Eclosest__such(A_27a,A_27b),ap(c_2Ecombin_2EK(bool,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b)),c_2Ebool_2ET)) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Elargest__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ap(c_2Ebinary__ieee_2Elargest(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) = ap(ap(c_2Erealax_2Ereal__mul,ap(ap(c_2Ereal_2E_2F,ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),ap(ap(c_2Earithmetic_2E_2D,ap(c_2Ewords_2EUINT__MAX(A_27w),c_2Ebool_2Ethe__value(A_27w))),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))))),ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),ap(c_2Ewords_2EINT__MAX(A_27w),c_2Ebool_2Ethe__value(A_27w))))),ap(ap(c_2Ereal_2Ereal__sub,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),ap(c_2Erealax_2Einv,ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),ap(c_2Efcp_2Edimindex(A_27t),c_2Ebool_2Ethe__value(A_27t)))))) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Ethreshold__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ap(c_2Ebinary__ieee_2Ethreshold(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) = ap(ap(c_2Erealax_2Ereal__mul,ap(ap(c_2Ereal_2E_2F,ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),ap(ap(c_2Earithmetic_2E_2D,ap(c_2Ewords_2EUINT__MAX(A_27w),c_2Ebool_2Ethe__value(A_27w))),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))))),ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),ap(c_2Ewords_2EINT__MAX(A_27w),c_2Ebool_2Ethe__value(A_27w))))),ap(ap(c_2Ereal_2Ereal__sub,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),ap(c_2Erealax_2Einv,ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),ap(c_2Enum_2ESUC,ap(c_2Efcp_2Edimindex(A_27t),c_2Ebool_2Ethe__value(A_27t))))))) ) ) ).

fof(lameq_f2953,axiom,
    ! [A_27t,A_27w,V0R] : ap(f2953(A_27t,A_27w),V0R) = ap(c_2Erelation_2EWF(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Ebool_2Eitself(A_27t))),V0R) ).

fof(lameq_f2954,axiom,
    ! [A_27t,A_27w,V3v] : ap(f2954(A_27t,A_27w),V3v) = k(ty_2Ebool_2Eitself(A_27t),ap(c_2Ecombin_2EI(ty_2Erealax_2Ereal),ap(ap(c_2Ereal_2E_2F,ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Enum_2Enum),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,A_27w)),V3v),ap(c_2Ewords_2En2w(A_27w),c_2Enum_2E0))),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))),ap(c_2Ewords_2Ew2n(A_27w),V3v)))),ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),ap(ap(c_2Earithmetic_2E_2B,ap(c_2Ewords_2EINT__MAX(A_27w),c_2Ebool_2Ethe__value(A_27w))),ap(c_2Efcp_2Edimindex(A_27t),c_2Ebool_2Ethe__value(A_27t))))))) ).

fof(lameq_f2955,axiom,
    ! [A_27t,A_27w,V2a] : ap(f2955(A_27t,A_27w),V2a) = ap(ap(c_2Epair_2Epair__CASE(ty_2Erealax_2Ereal,ty_2Efcp_2Ecart(bool,A_27w),ty_2Ebool_2Eitself(A_27t)),V2a),f2954(A_27t,A_27w)) ).

fof(ax_thm_2Ebinary__ieee_2EULP__primitive__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => c_2Ebinary__ieee_2EULP(A_27t,A_27w) = ap(ap(c_2Erelation_2EWFREC(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Ebool_2Eitself(A_27t)),ty_2Erealax_2Ereal),ap(c_2Emin_2E_40(arr(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Ebool_2Eitself(A_27t)),arr(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Ebool_2Eitself(A_27t)),bool))),f2953(A_27t,A_27w))),k(arr(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Ebool_2Eitself(A_27t)),ty_2Erealax_2Ereal),f2955(A_27t,A_27w))) ) ) ).

fof(conj_thm_2Ebinary__ieee_2EULP__ind,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0P] :
              ( mem(V0P,arr(ty_2Epair_2Eprod(ty_2Efcp_2Ecart(bool,A_27w),ty_2Ebool_2Eitself(A_27t)),bool))
             => ( ! [V1e] :
                    ( mem(V1e,ty_2Efcp_2Ecart(bool,A_27w))
                   => p(ap(V0P,ap(ap(c_2Epair_2E_2C(ty_2Efcp_2Ecart(bool,A_27w),ty_2Ebool_2Eitself(A_27t)),V1e),c_2Ebool_2Ethe__value(A_27t)))) )
               => ! [V2v] :
                    ( mem(V2v,ty_2Efcp_2Ecart(bool,A_27w))
                   => ! [V3v1] :
                        ( mem(V3v1,ty_2Ebool_2Eitself(A_27t))
                       => p(ap(V0P,ap(ap(c_2Epair_2E_2C(ty_2Efcp_2Ecart(bool,A_27w),ty_2Ebool_2Eitself(A_27t)),V2v),V3v1))) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2EULP__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0e] :
              ( mem(V0e,ty_2Efcp_2Ecart(bool,A_27w))
             => ap(c_2Ebinary__ieee_2EULP(A_27t,A_27w),ap(ap(c_2Epair_2E_2C(ty_2Efcp_2Ecart(bool,A_27w),ty_2Ebool_2Eitself(A_27t)),V0e),c_2Ebool_2Ethe__value(A_27t))) = ap(ap(c_2Ereal_2E_2F,ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Enum_2Enum),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,A_27w)),V0e),ap(c_2Ewords_2En2w(A_27w),c_2Enum_2E0))),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))),ap(c_2Ewords_2Ew2n(A_27w),V0e)))),ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),ap(ap(c_2Earithmetic_2E_2B,ap(c_2Ewords_2EINT__MAX(A_27w),c_2Ebool_2Ethe__value(A_27w))),ap(c_2Efcp_2Edimindex(A_27t),c_2Ebool_2Ethe__value(A_27t))))) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Eulp__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ap(c_2Ebinary__ieee_2Eulp(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) = ap(c_2Ebinary__ieee_2EULP(A_27t,A_27w),ap(ap(c_2Epair_2E_2C(ty_2Efcp_2Ecart(bool,A_27w),ty_2Ebool_2Eitself(A_27t)),ap(c_2Ewords_2En2w(A_27w),c_2Enum_2E0)),c_2Ebool_2Ethe__value(A_27t))) ) ) ).

fof(lameq_f2956,axiom,
    ! [A_27t,A_27w,V3a] : ap(f2956(A_27t,A_27w),V3a) = ap(c_2Ebool_2E_7E,ap(c_2Ewords_2Eword__lsb(A_27t),ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),V3a))) ).

fof(lameq_f2957,axiom,
    ! [A_27w,A_27t,V1x] :
      ( mem(V1x,ty_2Erealax_2Ereal)
     => ! [V2t] : ap(f2957(A_27w,A_27t,V1x),V2t) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Ereal_2Ereal__lte,V1x),ap(c_2Erealax_2Ereal__neg,V2t))),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Ereal_2Ereal__ge,V1x),V2t)),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(ap(c_2Ebinary__ieee_2Eclosest__such(A_27t,A_27w),f2956(A_27t,A_27w)),c_2Ebinary__ieee_2Efloat__is__finite(A_27t,A_27w)),V1x))) ) ).

fof(lameq_f2958,axiom,
    ! [A_27t,A_27w,V1x] :
      ( mem(V1x,ty_2Erealax_2Ereal)
     => ! [V5a] : ap(f2958(A_27t,A_27w,V1x),V5a) = ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool),V5a),ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27t,A_27w),V5a)),ap(ap(c_2Ereal_2Ereal__ge,ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),V5a)),V1x))) ) ).

fof(lameq_f2959,axiom,
    ! [A_27t,A_27w,V1x] :
      ( mem(V1x,ty_2Erealax_2Ereal)
     => ! [V4t] : ap(f2959(A_27t,A_27w,V1x),V4t) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Erealax_2Ereal__lt,V1x),ap(c_2Erealax_2Ereal__neg,V4t))),ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Ereal_2Ereal__gt,V1x),V4t)),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(c_2Ebinary__ieee_2Eclosest(A_27t,A_27w),ap(c_2Epred__set_2EGSPEC(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2958(A_27t,A_27w,V1x))),V1x))) ) ).

fof(lameq_f2960,axiom,
    ! [A_27t,A_27w,V1x] :
      ( mem(V1x,ty_2Erealax_2Ereal)
     => ! [V7a] : ap(f2960(A_27t,A_27w,V1x),V7a) = ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool),V7a),ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27t,A_27w),V7a)),ap(ap(c_2Ereal_2Ereal__lte,ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),V7a)),V1x))) ) ).

fof(lameq_f2961,axiom,
    ! [A_27t,A_27w,V1x] :
      ( mem(V1x,ty_2Erealax_2Ereal)
     => ! [V6t] : ap(f2961(A_27t,A_27w,V1x),V6t) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Erealax_2Ereal__lt,V1x),ap(c_2Erealax_2Ereal__neg,V6t))),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Ereal_2Ereal__gt,V1x),V6t)),ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(c_2Ebinary__ieee_2Eclosest(A_27t,A_27w),ap(c_2Epred__set_2EGSPEC(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2960(A_27t,A_27w,V1x))),V1x))) ) ).

fof(lameq_f2962,axiom,
    ! [A_27w,A_27t,V1x] :
      ( mem(V1x,ty_2Erealax_2Ereal)
     => ! [V9a] : ap(f2962(A_27w,A_27t,V1x),V9a) = ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool),V9a),ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27t,A_27w),V9a)),ap(ap(c_2Ereal_2Ereal__lte,ap(c_2Ereal_2Eabs,ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),V9a))),ap(c_2Ereal_2Eabs,V1x)))) ) ).

fof(lameq_f2963,axiom,
    ! [A_27w,A_27t,V1x] :
      ( mem(V1x,ty_2Erealax_2Ereal)
     => ! [V8t] : ap(f2963(A_27w,A_27t,V1x),V8t) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Erealax_2Ereal__lt,V1x),ap(c_2Erealax_2Ereal__neg,V8t))),ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Ereal_2Ereal__gt,V1x),V8t)),ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(c_2Ebinary__ieee_2Eclosest(A_27t,A_27w),ap(c_2Epred__set_2EGSPEC(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2962(A_27w,A_27t,V1x))),V1x))) ) ).

fof(ax_thm_2Ebinary__ieee_2Eround__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0mode] :
              ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
             => ! [V1x] :
                  ( mem(V1x,ty_2Erealax_2Ereal)
                 => ap(ap(c_2Ebinary__ieee_2Eround(A_27t,A_27w),V0mode),V1x) = ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erounding__CASE(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V0mode),ap(ap(c_2Ebool_2ELET(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2957(A_27w,A_27t,V1x)),ap(c_2Ebinary__ieee_2Ethreshold(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))),ap(ap(c_2Ebool_2ELET(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2959(A_27t,A_27w,V1x)),ap(c_2Ebinary__ieee_2Elargest(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))),ap(ap(c_2Ebool_2ELET(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2961(A_27t,A_27w,V1x)),ap(c_2Ebinary__ieee_2Elargest(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))),ap(ap(c_2Ebool_2ELET(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2963(A_27w,A_27t,V1x)),ap(c_2Ebinary__ieee_2Elargest(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) ) ) ) ) ).

fof(lameq_f2964,axiom,
    ! [A_27w,A_27t,V3a] :
      ( mem(V3a,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V4n] : ap(f2964(A_27w,A_27t,V3a),V4n) = ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Earithmetic_2EEVEN,V4n)),ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),ap(c_2Ereal_2Eabs,ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),V3a))),ap(c_2Ereal_2Ereal__of__num,V4n))) ) ).

fof(lameq_f2965,axiom,
    ! [A_27t,A_27w,V3a] : ap(f2965(A_27t,A_27w),V3a) = ap(c_2Ebool_2E_3F(ty_2Enum_2Enum),f2964(A_27w,A_27t,V3a)) ).

fof(lameq_f2966,axiom,
    ! [A_27w,A_27t,V1x] :
      ( mem(V1x,ty_2Erealax_2Ereal)
     => ! [V2t] : ap(f2966(A_27w,A_27t,V1x),V2t) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Ereal_2Ereal__lte,V1x),ap(c_2Erealax_2Ereal__neg,V2t))),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Ereal_2Ereal__ge,V1x),V2t)),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(ap(c_2Ebinary__ieee_2Eclosest__such(A_27t,A_27w),f2965(A_27t,A_27w)),c_2Ebinary__ieee_2Efloat__is__integral(A_27t,A_27w)),V1x))) ) ).

fof(lameq_f2967,axiom,
    ! [A_27t,A_27w,V1x] :
      ( mem(V1x,ty_2Erealax_2Ereal)
     => ! [V6a] : ap(f2967(A_27t,A_27w,V1x),V6a) = ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool),V6a),ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__integral(A_27t,A_27w),V6a)),ap(ap(c_2Ereal_2Ereal__ge,ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),V6a)),V1x))) ) ).

fof(lameq_f2968,axiom,
    ! [A_27t,A_27w,V1x] :
      ( mem(V1x,ty_2Erealax_2Ereal)
     => ! [V5t] : ap(f2968(A_27t,A_27w,V1x),V5t) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Erealax_2Ereal__lt,V1x),ap(c_2Erealax_2Ereal__neg,V5t))),ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Ereal_2Ereal__gt,V1x),V5t)),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(c_2Ebinary__ieee_2Eclosest(A_27t,A_27w),ap(c_2Epred__set_2EGSPEC(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2967(A_27t,A_27w,V1x))),V1x))) ) ).

fof(lameq_f2969,axiom,
    ! [A_27t,A_27w,V1x] :
      ( mem(V1x,ty_2Erealax_2Ereal)
     => ! [V8a] : ap(f2969(A_27t,A_27w,V1x),V8a) = ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool),V8a),ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__integral(A_27t,A_27w),V8a)),ap(ap(c_2Ereal_2Ereal__lte,ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),V8a)),V1x))) ) ).

fof(lameq_f2970,axiom,
    ! [A_27t,A_27w,V1x] :
      ( mem(V1x,ty_2Erealax_2Ereal)
     => ! [V7t] : ap(f2970(A_27t,A_27w,V1x),V7t) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Erealax_2Ereal__lt,V1x),ap(c_2Erealax_2Ereal__neg,V7t))),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Ereal_2Ereal__gt,V1x),V7t)),ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(c_2Ebinary__ieee_2Eclosest(A_27t,A_27w),ap(c_2Epred__set_2EGSPEC(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2969(A_27t,A_27w,V1x))),V1x))) ) ).

fof(lameq_f2971,axiom,
    ! [A_27w,A_27t,V1x] :
      ( mem(V1x,ty_2Erealax_2Ereal)
     => ! [V10a] : ap(f2971(A_27w,A_27t,V1x),V10a) = ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool),V10a),ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__integral(A_27t,A_27w),V10a)),ap(ap(c_2Ereal_2Ereal__lte,ap(c_2Ereal_2Eabs,ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),V10a))),ap(c_2Ereal_2Eabs,V1x)))) ) ).

fof(lameq_f2972,axiom,
    ! [A_27w,A_27t,V1x] :
      ( mem(V1x,ty_2Erealax_2Ereal)
     => ! [V9t] : ap(f2972(A_27w,A_27t,V1x),V9t) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Erealax_2Ereal__lt,V1x),ap(c_2Erealax_2Ereal__neg,V9t))),ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Ereal_2Ereal__gt,V1x),V9t)),ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(c_2Ebinary__ieee_2Eclosest(A_27t,A_27w),ap(c_2Epred__set_2EGSPEC(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2971(A_27w,A_27t,V1x))),V1x))) ) ).

fof(ax_thm_2Ebinary__ieee_2Eintegral__round__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0mode] :
              ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
             => ! [V1x] :
                  ( mem(V1x,ty_2Erealax_2Ereal)
                 => ap(ap(c_2Ebinary__ieee_2Eintegral__round(A_27t,A_27w),V0mode),V1x) = ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erounding__CASE(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V0mode),ap(ap(c_2Ebool_2ELET(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2966(A_27w,A_27t,V1x)),ap(c_2Ebinary__ieee_2Ethreshold(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))),ap(ap(c_2Ebool_2ELET(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2968(A_27t,A_27w,V1x)),ap(c_2Ebinary__ieee_2Elargest(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))),ap(ap(c_2Ebool_2ELET(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2970(A_27t,A_27w,V1x)),ap(c_2Ebinary__ieee_2Elargest(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))),ap(ap(c_2Ebool_2ELET(ty_2Erealax_2Ereal,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2972(A_27w,A_27t,V1x)),ap(c_2Ebinary__ieee_2Elargest(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) ) ) ) ) ).

fof(lameq_f2973,axiom,
    ! [A_27w,A_27t,V6a0] :
      ( mem(V6a0,ty_2Ebinary__ieee_2Erounding)
     => ! [V7a1] : ap(f2973(A_27w,A_27t,V6a0),V7a1) = ap(ap(ap(c_2Eind__type_2ECONSTR(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),c_2Enum_2E0),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))),V6a0),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),V7a1),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),k(ty_2Enum_2Enum,c_2Eind__type_2EBOTTOM(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))) ) ).

fof(lameq_f2974,axiom,
    ! [A_27t,A_27w,V6a0] : ap(f2974(A_27t,A_27w),V6a0) = f2973(A_27w,A_27t,V6a0) ).

fof(lameq_f2975,axiom,
    ! [A_27t,A_27w,V4a0] :
      ( mem(V4a0,ty_2Ebinary__ieee_2Erounding)
     => ! [V3a0_27] :
          ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
         => ! [V5a1] : ap(f2975(A_27t,A_27w,V4a0,V3a0_27),V5a1) = ap(ap(c_2Emin_2E_3D(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),V3a0_27),ap(ap(f2974(A_27t,A_27w),V4a0),V5a1)) ) ) ).

fof(lameq_f2976,axiom,
    ! [A_27w,A_27t,V3a0_27] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V4a0] : ap(f2976(A_27w,A_27t,V3a0_27),V4a0) = ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2975(A_27t,A_27w,V4a0,V3a0_27)) ) ).

fof(lameq_f2977,axiom,
    ! [A_27w,A_27t,V13a1] :
      ( mem(V13a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V12a0] :
          ( mem(V12a0,ty_2Ebinary__ieee_2Erounding)
         => ! [V14a2] : ap(f2977(A_27w,A_27t,V13a1,V12a0),V14a2) = ap(ap(ap(c_2Eind__type_2ECONSTR(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ap(c_2Enum_2ESUC,c_2Enum_2E0)),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))),V12a0),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),V13a1),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V14a2),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),k(ty_2Enum_2Enum,c_2Eind__type_2EBOTTOM(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))) ) ) ).

fof(lameq_f2978,axiom,
    ! [A_27w,A_27t,V12a0] :
      ( mem(V12a0,ty_2Ebinary__ieee_2Erounding)
     => ! [V13a1] : ap(f2978(A_27w,A_27t,V12a0),V13a1) = f2977(A_27w,A_27t,V13a1,V12a0) ) ).

fof(lameq_f2979,axiom,
    ! [A_27t,A_27w,V12a0] : ap(f2979(A_27t,A_27w),V12a0) = f2978(A_27w,A_27t,V12a0) ).

fof(lameq_f2980,axiom,
    ! [A_27t,A_27w,V9a0] :
      ( mem(V9a0,ty_2Ebinary__ieee_2Erounding)
     => ! [V10a1] :
          ( mem(V10a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V3a0_27] :
              ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
             => ! [V11a2] : ap(f2980(A_27t,A_27w,V9a0,V10a1,V3a0_27),V11a2) = ap(ap(c_2Emin_2E_3D(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),V3a0_27),ap(ap(ap(f2979(A_27t,A_27w),V9a0),V10a1),V11a2)) ) ) ) ).

fof(lameq_f2981,axiom,
    ! [A_27t,A_27w,V3a0_27] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V9a0] :
          ( mem(V9a0,ty_2Ebinary__ieee_2Erounding)
         => ! [V10a1] : ap(f2981(A_27t,A_27w,V3a0_27,V9a0),V10a1) = ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2980(A_27t,A_27w,V9a0,V10a1,V3a0_27)) ) ) ).

fof(lameq_f2982,axiom,
    ! [A_27w,A_27t,V3a0_27] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V9a0] : ap(f2982(A_27w,A_27t,V3a0_27),V9a0) = ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2981(A_27t,A_27w,V3a0_27,V9a0)) ) ).

fof(lameq_f2983,axiom,
    ! [A_27w,A_27t,V20a1] :
      ( mem(V20a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V19a0] :
          ( mem(V19a0,ty_2Ebinary__ieee_2Erounding)
         => ! [V21a2] : ap(f2983(A_27w,A_27t,V20a1,V19a0),V21a2) = ap(ap(ap(c_2Eind__type_2ECONSTR(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,c_2Enum_2E0))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))),V19a0),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),V20a1),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V21a2),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),k(ty_2Enum_2Enum,c_2Eind__type_2EBOTTOM(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))) ) ) ).

fof(lameq_f2984,axiom,
    ! [A_27w,A_27t,V19a0] :
      ( mem(V19a0,ty_2Ebinary__ieee_2Erounding)
     => ! [V20a1] : ap(f2984(A_27w,A_27t,V19a0),V20a1) = f2983(A_27w,A_27t,V20a1,V19a0) ) ).

fof(lameq_f2985,axiom,
    ! [A_27t,A_27w,V19a0] : ap(f2985(A_27t,A_27w),V19a0) = f2984(A_27w,A_27t,V19a0) ).

fof(lameq_f2986,axiom,
    ! [A_27t,A_27w,V16a0] :
      ( mem(V16a0,ty_2Ebinary__ieee_2Erounding)
     => ! [V17a1] :
          ( mem(V17a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V3a0_27] :
              ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
             => ! [V18a2] : ap(f2986(A_27t,A_27w,V16a0,V17a1,V3a0_27),V18a2) = ap(ap(c_2Emin_2E_3D(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),V3a0_27),ap(ap(ap(f2985(A_27t,A_27w),V16a0),V17a1),V18a2)) ) ) ) ).

fof(lameq_f2987,axiom,
    ! [A_27t,A_27w,V3a0_27] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V16a0] :
          ( mem(V16a0,ty_2Ebinary__ieee_2Erounding)
         => ! [V17a1] : ap(f2987(A_27t,A_27w,V3a0_27,V16a0),V17a1) = ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2986(A_27t,A_27w,V16a0,V17a1,V3a0_27)) ) ) ).

fof(lameq_f2988,axiom,
    ! [A_27w,A_27t,V3a0_27] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V16a0] : ap(f2988(A_27w,A_27t,V3a0_27),V16a0) = ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2987(A_27t,A_27w,V3a0_27,V16a0)) ) ).

fof(lameq_f2989,axiom,
    ! [A_27w,A_27t,V27a1] :
      ( mem(V27a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V26a0] :
          ( mem(V26a0,ty_2Ebinary__ieee_2Erounding)
         => ! [V28a2] : ap(f2989(A_27w,A_27t,V27a1,V26a0),V28a2) = ap(ap(ap(c_2Eind__type_2ECONSTR(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,c_2Enum_2E0)))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))),V26a0),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),V27a1),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V28a2),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),k(ty_2Enum_2Enum,c_2Eind__type_2EBOTTOM(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))) ) ) ).

fof(lameq_f2990,axiom,
    ! [A_27w,A_27t,V26a0] :
      ( mem(V26a0,ty_2Ebinary__ieee_2Erounding)
     => ! [V27a1] : ap(f2990(A_27w,A_27t,V26a0),V27a1) = f2989(A_27w,A_27t,V27a1,V26a0) ) ).

fof(lameq_f2991,axiom,
    ! [A_27t,A_27w,V26a0] : ap(f2991(A_27t,A_27w),V26a0) = f2990(A_27w,A_27t,V26a0) ).

fof(lameq_f2992,axiom,
    ! [A_27t,A_27w,V23a0] :
      ( mem(V23a0,ty_2Ebinary__ieee_2Erounding)
     => ! [V24a1] :
          ( mem(V24a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V3a0_27] :
              ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
             => ! [V25a2] : ap(f2992(A_27t,A_27w,V23a0,V24a1,V3a0_27),V25a2) = ap(ap(c_2Emin_2E_3D(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),V3a0_27),ap(ap(ap(f2991(A_27t,A_27w),V23a0),V24a1),V25a2)) ) ) ) ).

fof(lameq_f2993,axiom,
    ! [A_27t,A_27w,V3a0_27] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V23a0] :
          ( mem(V23a0,ty_2Ebinary__ieee_2Erounding)
         => ! [V24a1] : ap(f2993(A_27t,A_27w,V3a0_27,V23a0),V24a1) = ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2992(A_27t,A_27w,V23a0,V24a1,V3a0_27)) ) ) ).

fof(lameq_f2994,axiom,
    ! [A_27w,A_27t,V3a0_27] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V23a0] : ap(f2994(A_27w,A_27t,V3a0_27),V23a0) = ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2993(A_27t,A_27w,V3a0_27,V23a0)) ) ).

fof(lameq_f2995,axiom,
    ! [A_27w,A_27t,V34a1] :
      ( mem(V34a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V33a0] :
          ( mem(V33a0,ty_2Ebinary__ieee_2Erounding)
         => ! [V35a2] : ap(f2995(A_27w,A_27t,V34a1,V33a0),V35a2) = ap(ap(ap(c_2Eind__type_2ECONSTR(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,c_2Enum_2E0))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))),V33a0),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),V34a1),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V35a2),c_2Ebool_2EARB(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),k(ty_2Enum_2Enum,c_2Eind__type_2EBOTTOM(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))) ) ) ).

fof(lameq_f2996,axiom,
    ! [A_27w,A_27t,V33a0] :
      ( mem(V33a0,ty_2Ebinary__ieee_2Erounding)
     => ! [V34a1] : ap(f2996(A_27w,A_27t,V33a0),V34a1) = f2995(A_27w,A_27t,V34a1,V33a0) ) ).

fof(lameq_f2997,axiom,
    ! [A_27t,A_27w,V33a0] : ap(f2997(A_27t,A_27w),V33a0) = f2996(A_27w,A_27t,V33a0) ).

fof(lameq_f2998,axiom,
    ! [A_27t,A_27w,V30a0] :
      ( mem(V30a0,ty_2Ebinary__ieee_2Erounding)
     => ! [V31a1] :
          ( mem(V31a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V3a0_27] :
              ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
             => ! [V32a2] : ap(f2998(A_27t,A_27w,V30a0,V31a1,V3a0_27),V32a2) = ap(ap(c_2Emin_2E_3D(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),V3a0_27),ap(ap(ap(f2997(A_27t,A_27w),V30a0),V31a1),V32a2)) ) ) ) ).

fof(lameq_f2999,axiom,
    ! [A_27t,A_27w,V3a0_27] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V30a0] :
          ( mem(V30a0,ty_2Ebinary__ieee_2Erounding)
         => ! [V31a1] : ap(f2999(A_27t,A_27w,V3a0_27,V30a0),V31a1) = ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2998(A_27t,A_27w,V30a0,V31a1,V3a0_27)) ) ) ).

fof(lameq_f3000,axiom,
    ! [A_27w,A_27t,V3a0_27] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V30a0] : ap(f3000(A_27w,A_27t,V3a0_27),V30a0) = ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f2999(A_27t,A_27w,V3a0_27,V30a0)) ) ).

fof(lameq_f3001,axiom,
    ! [A_27w,A_27t,V42a1] :
      ( mem(V42a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V43a2] :
          ( mem(V43a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V41a0] :
              ( mem(V41a0,ty_2Ebinary__ieee_2Erounding)
             => ! [V44a3] : ap(f3001(A_27w,A_27t,V42a1,V43a2,V41a0),V44a3) = ap(ap(ap(c_2Eind__type_2ECONSTR(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,c_2Enum_2E0)))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))),V41a0),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),V42a1),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V43a2),V44a3)))),k(ty_2Enum_2Enum,c_2Eind__type_2EBOTTOM(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))) ) ) ) ).

fof(lameq_f3002,axiom,
    ! [A_27w,A_27t,V42a1] :
      ( mem(V42a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V41a0] :
          ( mem(V41a0,ty_2Ebinary__ieee_2Erounding)
         => ! [V43a2] : ap(f3002(A_27w,A_27t,V42a1,V41a0),V43a2) = f3001(A_27w,A_27t,V42a1,V43a2,V41a0) ) ) ).

fof(lameq_f3003,axiom,
    ! [A_27w,A_27t,V41a0] :
      ( mem(V41a0,ty_2Ebinary__ieee_2Erounding)
     => ! [V42a1] : ap(f3003(A_27w,A_27t,V41a0),V42a1) = f3002(A_27w,A_27t,V42a1,V41a0) ) ).

fof(lameq_f3004,axiom,
    ! [A_27t,A_27w,V41a0] : ap(f3004(A_27t,A_27w),V41a0) = f3003(A_27w,A_27t,V41a0) ).

fof(lameq_f3005,axiom,
    ! [A_27t,A_27w,V38a1] :
      ( mem(V38a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V37a0] :
          ( mem(V37a0,ty_2Ebinary__ieee_2Erounding)
         => ! [V39a2] :
              ( mem(V39a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V3a0_27] :
                  ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
                 => ! [V40a3] : ap(f3005(A_27t,A_27w,V38a1,V37a0,V39a2,V3a0_27),V40a3) = ap(ap(c_2Emin_2E_3D(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),V3a0_27),ap(ap(ap(ap(f3004(A_27t,A_27w),V37a0),V38a1),V39a2),V40a3)) ) ) ) ) ).

fof(lameq_f3006,axiom,
    ! [A_27t,A_27w,V3a0_27] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V37a0] :
          ( mem(V37a0,ty_2Ebinary__ieee_2Erounding)
         => ! [V38a1] :
              ( mem(V38a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V39a2] : ap(f3006(A_27t,A_27w,V3a0_27,V37a0,V38a1),V39a2) = ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f3005(A_27t,A_27w,V38a1,V37a0,V39a2,V3a0_27)) ) ) ) ).

fof(lameq_f3007,axiom,
    ! [A_27t,A_27w,V37a0] :
      ( mem(V37a0,ty_2Ebinary__ieee_2Erounding)
     => ! [V3a0_27] :
          ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
         => ! [V38a1] : ap(f3007(A_27t,A_27w,V37a0,V3a0_27),V38a1) = ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f3006(A_27t,A_27w,V3a0_27,V37a0,V38a1)) ) ) ).

fof(lameq_f3008,axiom,
    ! [A_27w,A_27t,V3a0_27] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V37a0] : ap(f3008(A_27w,A_27t,V3a0_27),V37a0) = ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f3007(A_27t,A_27w,V37a0,V3a0_27)) ) ).

fof(lameq_f3009,axiom,
    ! [A_27w,A_27t,V51a1] :
      ( mem(V51a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V52a2] :
          ( mem(V52a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V50a0] :
              ( mem(V50a0,ty_2Ebinary__ieee_2Erounding)
             => ! [V53a3] : ap(f3009(A_27w,A_27t,V51a1,V52a2,V50a0),V53a3) = ap(ap(ap(c_2Eind__type_2ECONSTR(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,ap(c_2Enum_2ESUC,c_2Enum_2E0))))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))),V50a0),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),V51a1),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V52a2),V53a3)))),k(ty_2Enum_2Enum,c_2Eind__type_2EBOTTOM(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))) ) ) ) ).

fof(lameq_f3010,axiom,
    ! [A_27w,A_27t,V51a1] :
      ( mem(V51a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V50a0] :
          ( mem(V50a0,ty_2Ebinary__ieee_2Erounding)
         => ! [V52a2] : ap(f3010(A_27w,A_27t,V51a1,V50a0),V52a2) = f3009(A_27w,A_27t,V51a1,V52a2,V50a0) ) ) ).

fof(lameq_f3011,axiom,
    ! [A_27w,A_27t,V50a0] :
      ( mem(V50a0,ty_2Ebinary__ieee_2Erounding)
     => ! [V51a1] : ap(f3011(A_27w,A_27t,V50a0),V51a1) = f3010(A_27w,A_27t,V51a1,V50a0) ) ).

fof(lameq_f3012,axiom,
    ! [A_27t,A_27w,V50a0] : ap(f3012(A_27t,A_27w),V50a0) = f3011(A_27w,A_27t,V50a0) ).

fof(lameq_f3013,axiom,
    ! [A_27t,A_27w,V47a1] :
      ( mem(V47a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V46a0] :
          ( mem(V46a0,ty_2Ebinary__ieee_2Erounding)
         => ! [V48a2] :
              ( mem(V48a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V3a0_27] :
                  ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
                 => ! [V49a3] : ap(f3013(A_27t,A_27w,V47a1,V46a0,V48a2,V3a0_27),V49a3) = ap(ap(c_2Emin_2E_3D(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),V3a0_27),ap(ap(ap(ap(f3012(A_27t,A_27w),V46a0),V47a1),V48a2),V49a3)) ) ) ) ) ).

fof(lameq_f3014,axiom,
    ! [A_27t,A_27w,V3a0_27] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V46a0] :
          ( mem(V46a0,ty_2Ebinary__ieee_2Erounding)
         => ! [V47a1] :
              ( mem(V47a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V48a2] : ap(f3014(A_27t,A_27w,V3a0_27,V46a0,V47a1),V48a2) = ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f3013(A_27t,A_27w,V47a1,V46a0,V48a2,V3a0_27)) ) ) ) ).

fof(lameq_f3015,axiom,
    ! [A_27t,A_27w,V46a0] :
      ( mem(V46a0,ty_2Ebinary__ieee_2Erounding)
     => ! [V3a0_27] :
          ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
         => ! [V47a1] : ap(f3015(A_27t,A_27w,V46a0,V3a0_27),V47a1) = ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f3014(A_27t,A_27w,V3a0_27,V46a0,V47a1)) ) ) ).

fof(lameq_f3016,axiom,
    ! [A_27w,A_27t,V3a0_27] :
      ( mem(V3a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V46a0] : ap(f3016(A_27w,A_27t,V3a0_27),V46a0) = ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f3015(A_27t,A_27w,V46a0,V3a0_27)) ) ).

fof(lameq_f3017,axiom,
    ! [A_27t,A_27w,V2_27fp__op_27] :
      ( mem(V2_27fp__op_27,arr(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),bool))
     => ! [V3a0_27] : ap(f3017(A_27t,A_27w,V2_27fp__op_27),V3a0_27) = ap(ap(c_2Emin_2E_3D_3D_3E,ap(ap(c_2Ebool_2E_5C_2F,ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Erounding),f2976(A_27w,A_27t,V3a0_27))),ap(ap(c_2Ebool_2E_5C_2F,ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Erounding),f2982(A_27w,A_27t,V3a0_27))),ap(ap(c_2Ebool_2E_5C_2F,ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Erounding),f2988(A_27w,A_27t,V3a0_27))),ap(ap(c_2Ebool_2E_5C_2F,ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Erounding),f2994(A_27w,A_27t,V3a0_27))),ap(ap(c_2Ebool_2E_5C_2F,ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Erounding),f3000(A_27w,A_27t,V3a0_27))),ap(ap(c_2Ebool_2E_5C_2F,ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Erounding),f3008(A_27w,A_27t,V3a0_27))),ap(c_2Ebool_2E_3F(ty_2Ebinary__ieee_2Erounding),f3016(A_27w,A_27t,V3a0_27))))))))),ap(V2_27fp__op_27,V3a0_27)) ) ).

fof(lameq_f3018,axiom,
    ! [A_27t,A_27w,V1a0_27] :
      ( mem(V1a0_27,ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))
     => ! [V2_27fp__op_27] : ap(f3018(A_27t,A_27w,V1a0_27),V2_27fp__op_27) = ap(ap(c_2Emin_2E_3D_3D_3E,ap(c_2Ebool_2E_21(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),f3017(A_27t,A_27w,V2_27fp__op_27))),ap(V2_27fp__op_27,V1a0_27)) ) ).

fof(lameq_f3019,axiom,
    ! [A_27t,A_27w,V1a0_27] : ap(f3019(A_27t,A_27w),V1a0_27) = ap(c_2Ebool_2E_21(arr(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),bool)),f3018(A_27t,A_27w,V1a0_27)) ).

fof(ax_thm_2Ebinary__ieee_2Efp__op__TY__DEF,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ? [V0rep] :
              ( mem(V0rep,arr(ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w),ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))))
              & p(ap(ap(c_2Ebool_2ETYPE__DEFINITION(ty_2Eind__type_2Erecspace(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Erounding,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w)),f3019(A_27t,A_27w)),V0rep)) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efp__op__case__def,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27t] :
          ( ne(A_27t)
         => ! [A_27w] :
              ( ne(A_27w)
             => ( ! [V0a0] :
                    ( mem(V0a0,ty_2Ebinary__ieee_2Erounding)
                   => ! [V1a1] :
                        ( mem(V1a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V2f] :
                            ( mem(V2f,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))
                           => ! [V3f1] :
                                ( mem(V3f1,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                               => ! [V4f2] :
                                    ( mem(V4f2,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                   => ! [V5f3] :
                                        ( mem(V5f3,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                       => ! [V6f4] :
                                            ( mem(V6f4,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                           => ! [V7f5] :
                                                ( mem(V7f5,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                               => ! [V8f6] :
                                                    ( mem(V8f6,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                                   => ap(ap(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efp__op__CASE(A_27a,A_27t,A_27w),ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),V0a0),V1a1)),V2f),V3f1),V4f2),V5f3),V6f4),V7f5),V8f6) = ap(ap(V2f,V0a0),V1a1) ) ) ) ) ) ) ) ) )
                & ! [V9a0] :
                    ( mem(V9a0,ty_2Ebinary__ieee_2Erounding)
                   => ! [V10a1] :
                        ( mem(V10a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V11a2] :
                            ( mem(V11a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V12f] :
                                ( mem(V12f,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))
                               => ! [V13f1] :
                                    ( mem(V13f1,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                   => ! [V14f2] :
                                        ( mem(V14f2,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                       => ! [V15f3] :
                                            ( mem(V15f3,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                           => ! [V16f4] :
                                                ( mem(V16f4,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                               => ! [V17f5] :
                                                    ( mem(V17f5,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                                   => ! [V18f6] :
                                                        ( mem(V18f6,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                                       => ap(ap(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efp__op__CASE(A_27a,A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),V9a0),V10a1),V11a2)),V12f),V13f1),V14f2),V15f3),V16f4),V17f5),V18f6) = ap(ap(ap(V13f1,V9a0),V10a1),V11a2) ) ) ) ) ) ) ) ) ) )
                & ! [V19a0] :
                    ( mem(V19a0,ty_2Ebinary__ieee_2Erounding)
                   => ! [V20a1] :
                        ( mem(V20a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V21a2] :
                            ( mem(V21a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V22f] :
                                ( mem(V22f,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))
                               => ! [V23f1] :
                                    ( mem(V23f1,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                   => ! [V24f2] :
                                        ( mem(V24f2,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                       => ! [V25f3] :
                                            ( mem(V25f3,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                           => ! [V26f4] :
                                                ( mem(V26f4,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                               => ! [V27f5] :
                                                    ( mem(V27f5,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                                   => ! [V28f6] :
                                                        ( mem(V28f6,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                                       => ap(ap(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efp__op__CASE(A_27a,A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),V19a0),V20a1),V21a2)),V22f),V23f1),V24f2),V25f3),V26f4),V27f5),V28f6) = ap(ap(ap(V24f2,V19a0),V20a1),V21a2) ) ) ) ) ) ) ) ) ) )
                & ! [V29a0] :
                    ( mem(V29a0,ty_2Ebinary__ieee_2Erounding)
                   => ! [V30a1] :
                        ( mem(V30a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V31a2] :
                            ( mem(V31a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V32f] :
                                ( mem(V32f,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))
                               => ! [V33f1] :
                                    ( mem(V33f1,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                   => ! [V34f2] :
                                        ( mem(V34f2,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                       => ! [V35f3] :
                                            ( mem(V35f3,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                           => ! [V36f4] :
                                                ( mem(V36f4,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                               => ! [V37f5] :
                                                    ( mem(V37f5,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                                   => ! [V38f6] :
                                                        ( mem(V38f6,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                                       => ap(ap(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efp__op__CASE(A_27a,A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),V29a0),V30a1),V31a2)),V32f),V33f1),V34f2),V35f3),V36f4),V37f5),V38f6) = ap(ap(ap(V35f3,V29a0),V30a1),V31a2) ) ) ) ) ) ) ) ) ) )
                & ! [V39a0] :
                    ( mem(V39a0,ty_2Ebinary__ieee_2Erounding)
                   => ! [V40a1] :
                        ( mem(V40a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V41a2] :
                            ( mem(V41a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V42f] :
                                ( mem(V42f,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))
                               => ! [V43f1] :
                                    ( mem(V43f1,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                   => ! [V44f2] :
                                        ( mem(V44f2,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                       => ! [V45f3] :
                                            ( mem(V45f3,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                           => ! [V46f4] :
                                                ( mem(V46f4,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                               => ! [V47f5] :
                                                    ( mem(V47f5,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                                   => ! [V48f6] :
                                                        ( mem(V48f6,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                                       => ap(ap(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efp__op__CASE(A_27a,A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),V39a0),V40a1),V41a2)),V42f),V43f1),V44f2),V45f3),V46f4),V47f5),V48f6) = ap(ap(ap(V46f4,V39a0),V40a1),V41a2) ) ) ) ) ) ) ) ) ) )
                & ! [V49a0] :
                    ( mem(V49a0,ty_2Ebinary__ieee_2Erounding)
                   => ! [V50a1] :
                        ( mem(V50a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V51a2] :
                            ( mem(V51a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V52a3] :
                                ( mem(V52a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                               => ! [V53f] :
                                    ( mem(V53f,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))
                                   => ! [V54f1] :
                                        ( mem(V54f1,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                       => ! [V55f2] :
                                            ( mem(V55f2,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                           => ! [V56f3] :
                                                ( mem(V56f3,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                               => ! [V57f4] :
                                                    ( mem(V57f4,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                                   => ! [V58f5] :
                                                        ( mem(V58f5,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                                       => ! [V59f6] :
                                                            ( mem(V59f6,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                                           => ap(ap(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efp__op__CASE(A_27a,A_27t,A_27w),ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),V49a0),V50a1),V51a2),V52a3)),V53f),V54f1),V55f2),V56f3),V57f4),V58f5),V59f6) = ap(ap(ap(ap(V58f5,V49a0),V50a1),V51a2),V52a3) ) ) ) ) ) ) ) ) ) ) )
                & ! [V60a0] :
                    ( mem(V60a0,ty_2Ebinary__ieee_2Erounding)
                   => ! [V61a1] :
                        ( mem(V61a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V62a2] :
                            ( mem(V62a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V63a3] :
                                ( mem(V63a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                               => ! [V64f] :
                                    ( mem(V64f,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))
                                   => ! [V65f1] :
                                        ( mem(V65f1,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                       => ! [V66f2] :
                                            ( mem(V66f2,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                           => ! [V67f3] :
                                                ( mem(V67f3,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                               => ! [V68f4] :
                                                    ( mem(V68f4,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                                   => ! [V69f5] :
                                                        ( mem(V69f5,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                                       => ! [V70f6] :
                                                            ( mem(V70f6,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                                           => ap(ap(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efp__op__CASE(A_27a,A_27t,A_27w),ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),V60a0),V61a1),V62a2),V63a3)),V64f),V65f1),V66f2),V67f3),V68f4),V69f5),V70f6) = ap(ap(ap(ap(V70f6,V60a0),V61a1),V62a2),V63a3) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efp__op__size__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ( ! [V0f] :
                ( mem(V0f,arr(A_27t,ty_2Enum_2Enum))
               => ! [V1f1] :
                    ( mem(V1f1,arr(A_27w,ty_2Enum_2Enum))
                   => ! [V2a0] :
                        ( mem(V2a0,ty_2Ebinary__ieee_2Erounding)
                       => ! [V3a1] :
                            ( mem(V3a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ap(ap(ap(c_2Ebinary__ieee_2Efp__op__size(A_27t,A_27w),V0f),V1f1),ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),V2a0),V3a1)) = ap(ap(c_2Earithmetic_2E_2B,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))),ap(ap(c_2Earithmetic_2E_2B,ap(c_2Ebinary__ieee_2Erounding__size,V2a0)),ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V0f),V1f1),V3a1))) ) ) ) )
            & ! [V4f] :
                ( mem(V4f,arr(A_27t,ty_2Enum_2Enum))
               => ! [V5f1] :
                    ( mem(V5f1,arr(A_27w,ty_2Enum_2Enum))
                   => ! [V6a0] :
                        ( mem(V6a0,ty_2Ebinary__ieee_2Erounding)
                       => ! [V7a1] :
                            ( mem(V7a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V8a2] :
                                ( mem(V8a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                               => ap(ap(ap(c_2Ebinary__ieee_2Efp__op__size(A_27t,A_27w),V4f),V5f1),ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),V6a0),V7a1),V8a2)) = ap(ap(c_2Earithmetic_2E_2B,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))),ap(ap(c_2Earithmetic_2E_2B,ap(c_2Ebinary__ieee_2Erounding__size,V6a0)),ap(ap(c_2Earithmetic_2E_2B,ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V4f),V5f1),V7a1)),ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V4f),V5f1),V8a2)))) ) ) ) ) )
            & ! [V9f] :
                ( mem(V9f,arr(A_27t,ty_2Enum_2Enum))
               => ! [V10f1] :
                    ( mem(V10f1,arr(A_27w,ty_2Enum_2Enum))
                   => ! [V11a0] :
                        ( mem(V11a0,ty_2Ebinary__ieee_2Erounding)
                       => ! [V12a1] :
                            ( mem(V12a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V13a2] :
                                ( mem(V13a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                               => ap(ap(ap(c_2Ebinary__ieee_2Efp__op__size(A_27t,A_27w),V9f),V10f1),ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),V11a0),V12a1),V13a2)) = ap(ap(c_2Earithmetic_2E_2B,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))),ap(ap(c_2Earithmetic_2E_2B,ap(c_2Ebinary__ieee_2Erounding__size,V11a0)),ap(ap(c_2Earithmetic_2E_2B,ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V9f),V10f1),V12a1)),ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V9f),V10f1),V13a2)))) ) ) ) ) )
            & ! [V14f] :
                ( mem(V14f,arr(A_27t,ty_2Enum_2Enum))
               => ! [V15f1] :
                    ( mem(V15f1,arr(A_27w,ty_2Enum_2Enum))
                   => ! [V16a0] :
                        ( mem(V16a0,ty_2Ebinary__ieee_2Erounding)
                       => ! [V17a1] :
                            ( mem(V17a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V18a2] :
                                ( mem(V18a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                               => ap(ap(ap(c_2Ebinary__ieee_2Efp__op__size(A_27t,A_27w),V14f),V15f1),ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),V16a0),V17a1),V18a2)) = ap(ap(c_2Earithmetic_2E_2B,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))),ap(ap(c_2Earithmetic_2E_2B,ap(c_2Ebinary__ieee_2Erounding__size,V16a0)),ap(ap(c_2Earithmetic_2E_2B,ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V14f),V15f1),V17a1)),ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V14f),V15f1),V18a2)))) ) ) ) ) )
            & ! [V19f] :
                ( mem(V19f,arr(A_27t,ty_2Enum_2Enum))
               => ! [V20f1] :
                    ( mem(V20f1,arr(A_27w,ty_2Enum_2Enum))
                   => ! [V21a0] :
                        ( mem(V21a0,ty_2Ebinary__ieee_2Erounding)
                       => ! [V22a1] :
                            ( mem(V22a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V23a2] :
                                ( mem(V23a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                               => ap(ap(ap(c_2Ebinary__ieee_2Efp__op__size(A_27t,A_27w),V19f),V20f1),ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),V21a0),V22a1),V23a2)) = ap(ap(c_2Earithmetic_2E_2B,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))),ap(ap(c_2Earithmetic_2E_2B,ap(c_2Ebinary__ieee_2Erounding__size,V21a0)),ap(ap(c_2Earithmetic_2E_2B,ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V19f),V20f1),V22a1)),ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V19f),V20f1),V23a2)))) ) ) ) ) )
            & ! [V24f] :
                ( mem(V24f,arr(A_27t,ty_2Enum_2Enum))
               => ! [V25f1] :
                    ( mem(V25f1,arr(A_27w,ty_2Enum_2Enum))
                   => ! [V26a0] :
                        ( mem(V26a0,ty_2Ebinary__ieee_2Erounding)
                       => ! [V27a1] :
                            ( mem(V27a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V28a2] :
                                ( mem(V28a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                               => ! [V29a3] :
                                    ( mem(V29a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                   => ap(ap(ap(c_2Ebinary__ieee_2Efp__op__size(A_27t,A_27w),V24f),V25f1),ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),V26a0),V27a1),V28a2),V29a3)) = ap(ap(c_2Earithmetic_2E_2B,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))),ap(ap(c_2Earithmetic_2E_2B,ap(c_2Ebinary__ieee_2Erounding__size,V26a0)),ap(ap(c_2Earithmetic_2E_2B,ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V24f),V25f1),V27a1)),ap(ap(c_2Earithmetic_2E_2B,ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V24f),V25f1),V28a2)),ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V24f),V25f1),V29a3))))) ) ) ) ) ) )
            & ! [V30f] :
                ( mem(V30f,arr(A_27t,ty_2Enum_2Enum))
               => ! [V31f1] :
                    ( mem(V31f1,arr(A_27w,ty_2Enum_2Enum))
                   => ! [V32a0] :
                        ( mem(V32a0,ty_2Ebinary__ieee_2Erounding)
                       => ! [V33a1] :
                            ( mem(V33a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V34a2] :
                                ( mem(V34a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                               => ! [V35a3] :
                                    ( mem(V35a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                   => ap(ap(ap(c_2Ebinary__ieee_2Efp__op__size(A_27t,A_27w),V30f),V31f1),ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),V32a0),V33a1),V34a2),V35a3)) = ap(ap(c_2Earithmetic_2E_2B,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))),ap(ap(c_2Earithmetic_2E_2B,ap(c_2Ebinary__ieee_2Erounding__size,V32a0)),ap(ap(c_2Earithmetic_2E_2B,ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V30f),V31f1),V33a1)),ap(ap(c_2Earithmetic_2E_2B,ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V30f),V31f1),V34a2)),ap(ap(ap(c_2Ebinary__ieee_2Efloat__size(A_27t,A_27w),V30f),V31f1),V35a3))))) ) ) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Edatatype__fp__op,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0fp__op] :
              ( mem(V0fp__op,arr(arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))),arr(arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w)))),arr(arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w)))),arr(arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w)))),arr(arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w)))),arr(arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))))),arr(arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))))),bool))))))))
             => p(ap(c_2Ebool_2EDATATYPE(bool),ap(ap(ap(ap(ap(ap(ap(V0fp__op,c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w)),c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w)),c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w)),c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w)),c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w)),c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w)),c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w)))) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efp__op__11,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ( ! [V0a0] :
                ( mem(V0a0,ty_2Ebinary__ieee_2Erounding)
               => ! [V1a1] :
                    ( mem(V1a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                   => ! [V2a0_27] :
                        ( mem(V2a0_27,ty_2Ebinary__ieee_2Erounding)
                       => ! [V3a1_27] :
                            ( mem(V3a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ( ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),V0a0),V1a1) = ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),V2a0_27),V3a1_27)
                            <=> ( V0a0 = V2a0_27
                                & V1a1 = V3a1_27 ) ) ) ) ) )
            & ! [V4a0] :
                ( mem(V4a0,ty_2Ebinary__ieee_2Erounding)
               => ! [V5a1] :
                    ( mem(V5a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                   => ! [V6a2] :
                        ( mem(V6a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V7a0_27] :
                            ( mem(V7a0_27,ty_2Ebinary__ieee_2Erounding)
                           => ! [V8a1_27] :
                                ( mem(V8a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                               => ! [V9a2_27] :
                                    ( mem(V9a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                   => ( ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),V4a0),V5a1),V6a2) = ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),V7a0_27),V8a1_27),V9a2_27)
                                    <=> ( V4a0 = V7a0_27
                                        & V5a1 = V8a1_27
                                        & V6a2 = V9a2_27 ) ) ) ) ) ) ) )
            & ! [V10a0] :
                ( mem(V10a0,ty_2Ebinary__ieee_2Erounding)
               => ! [V11a1] :
                    ( mem(V11a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                   => ! [V12a2] :
                        ( mem(V12a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V13a0_27] :
                            ( mem(V13a0_27,ty_2Ebinary__ieee_2Erounding)
                           => ! [V14a1_27] :
                                ( mem(V14a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                               => ! [V15a2_27] :
                                    ( mem(V15a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                   => ( ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),V10a0),V11a1),V12a2) = ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),V13a0_27),V14a1_27),V15a2_27)
                                    <=> ( V10a0 = V13a0_27
                                        & V11a1 = V14a1_27
                                        & V12a2 = V15a2_27 ) ) ) ) ) ) ) )
            & ! [V16a0] :
                ( mem(V16a0,ty_2Ebinary__ieee_2Erounding)
               => ! [V17a1] :
                    ( mem(V17a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                   => ! [V18a2] :
                        ( mem(V18a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V19a0_27] :
                            ( mem(V19a0_27,ty_2Ebinary__ieee_2Erounding)
                           => ! [V20a1_27] :
                                ( mem(V20a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                               => ! [V21a2_27] :
                                    ( mem(V21a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                   => ( ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),V16a0),V17a1),V18a2) = ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),V19a0_27),V20a1_27),V21a2_27)
                                    <=> ( V16a0 = V19a0_27
                                        & V17a1 = V20a1_27
                                        & V18a2 = V21a2_27 ) ) ) ) ) ) ) )
            & ! [V22a0] :
                ( mem(V22a0,ty_2Ebinary__ieee_2Erounding)
               => ! [V23a1] :
                    ( mem(V23a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                   => ! [V24a2] :
                        ( mem(V24a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V25a0_27] :
                            ( mem(V25a0_27,ty_2Ebinary__ieee_2Erounding)
                           => ! [V26a1_27] :
                                ( mem(V26a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                               => ! [V27a2_27] :
                                    ( mem(V27a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                   => ( ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),V22a0),V23a1),V24a2) = ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),V25a0_27),V26a1_27),V27a2_27)
                                    <=> ( V22a0 = V25a0_27
                                        & V23a1 = V26a1_27
                                        & V24a2 = V27a2_27 ) ) ) ) ) ) ) )
            & ! [V28a0] :
                ( mem(V28a0,ty_2Ebinary__ieee_2Erounding)
               => ! [V29a1] :
                    ( mem(V29a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                   => ! [V30a2] :
                        ( mem(V30a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V31a3] :
                            ( mem(V31a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V32a0_27] :
                                ( mem(V32a0_27,ty_2Ebinary__ieee_2Erounding)
                               => ! [V33a1_27] :
                                    ( mem(V33a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                   => ! [V34a2_27] :
                                        ( mem(V34a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                       => ! [V35a3_27] :
                                            ( mem(V35a3_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                           => ( ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),V28a0),V29a1),V30a2),V31a3) = ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),V32a0_27),V33a1_27),V34a2_27),V35a3_27)
                                            <=> ( V28a0 = V32a0_27
                                                & V29a1 = V33a1_27
                                                & V30a2 = V34a2_27
                                                & V31a3 = V35a3_27 ) ) ) ) ) ) ) ) ) )
            & ! [V36a0] :
                ( mem(V36a0,ty_2Ebinary__ieee_2Erounding)
               => ! [V37a1] :
                    ( mem(V37a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                   => ! [V38a2] :
                        ( mem(V38a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V39a3] :
                            ( mem(V39a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V40a0_27] :
                                ( mem(V40a0_27,ty_2Ebinary__ieee_2Erounding)
                               => ! [V41a1_27] :
                                    ( mem(V41a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                   => ! [V42a2_27] :
                                        ( mem(V42a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                       => ! [V43a3_27] :
                                            ( mem(V43a3_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                           => ( ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),V36a0),V37a1),V38a2),V39a3) = ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),V40a0_27),V41a1_27),V42a2_27),V43a3_27)
                                            <=> ( V36a0 = V40a0_27
                                                & V37a1 = V41a1_27
                                                & V38a2 = V42a2_27
                                                & V39a3 = V43a3_27 ) ) ) ) ) ) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efp__op__distinct,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ( ! [V0a2] :
                ( mem(V0a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
               => ! [V1a1_27] :
                    ( mem(V1a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                   => ! [V2a1] :
                        ( mem(V2a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V3a0_27] :
                            ( mem(V3a0_27,ty_2Ebinary__ieee_2Erounding)
                           => ! [V4a0] :
                                ( mem(V4a0,ty_2Ebinary__ieee_2Erounding)
                               => ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),V4a0),V2a1) != ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),V3a0_27),V1a1_27),V0a2) ) ) ) ) )
            & ! [V5a2] :
                ( mem(V5a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
               => ! [V6a1_27] :
                    ( mem(V6a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                   => ! [V7a1] :
                        ( mem(V7a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V8a0_27] :
                            ( mem(V8a0_27,ty_2Ebinary__ieee_2Erounding)
                           => ! [V9a0] :
                                ( mem(V9a0,ty_2Ebinary__ieee_2Erounding)
                               => ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),V9a0),V7a1) != ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),V8a0_27),V6a1_27),V5a2) ) ) ) ) )
            & ! [V10a2] :
                ( mem(V10a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
               => ! [V11a1_27] :
                    ( mem(V11a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                   => ! [V12a1] :
                        ( mem(V12a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V13a0_27] :
                            ( mem(V13a0_27,ty_2Ebinary__ieee_2Erounding)
                           => ! [V14a0] :
                                ( mem(V14a0,ty_2Ebinary__ieee_2Erounding)
                               => ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),V14a0),V12a1) != ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),V13a0_27),V11a1_27),V10a2) ) ) ) ) )
            & ! [V15a2] :
                ( mem(V15a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
               => ! [V16a1_27] :
                    ( mem(V16a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                   => ! [V17a1] :
                        ( mem(V17a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V18a0_27] :
                            ( mem(V18a0_27,ty_2Ebinary__ieee_2Erounding)
                           => ! [V19a0] :
                                ( mem(V19a0,ty_2Ebinary__ieee_2Erounding)
                               => ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),V19a0),V17a1) != ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),V18a0_27),V16a1_27),V15a2) ) ) ) ) )
            & ! [V20a3] :
                ( mem(V20a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
               => ! [V21a2] :
                    ( mem(V21a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                   => ! [V22a1_27] :
                        ( mem(V22a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V23a1] :
                            ( mem(V23a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V24a0_27] :
                                ( mem(V24a0_27,ty_2Ebinary__ieee_2Erounding)
                               => ! [V25a0] :
                                    ( mem(V25a0,ty_2Ebinary__ieee_2Erounding)
                                   => ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),V25a0),V23a1) != ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),V24a0_27),V22a1_27),V21a2),V20a3) ) ) ) ) ) )
            & ! [V26a3] :
                ( mem(V26a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
               => ! [V27a2] :
                    ( mem(V27a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                   => ! [V28a1_27] :
                        ( mem(V28a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V29a1] :
                            ( mem(V29a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V30a0_27] :
                                ( mem(V30a0_27,ty_2Ebinary__ieee_2Erounding)
                               => ! [V31a0] :
                                    ( mem(V31a0,ty_2Ebinary__ieee_2Erounding)
                                   => ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),V31a0),V29a1) != ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),V30a0_27),V28a1_27),V27a2),V26a3) ) ) ) ) ) )
            & ! [V32a2_27] :
                ( mem(V32a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
               => ! [V33a2] :
                    ( mem(V33a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                   => ! [V34a1_27] :
                        ( mem(V34a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V35a1] :
                            ( mem(V35a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V36a0_27] :
                                ( mem(V36a0_27,ty_2Ebinary__ieee_2Erounding)
                               => ! [V37a0] :
                                    ( mem(V37a0,ty_2Ebinary__ieee_2Erounding)
                                   => ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),V37a0),V35a1),V33a2) != ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),V36a0_27),V34a1_27),V32a2_27) ) ) ) ) ) )
            & ! [V38a2_27] :
                ( mem(V38a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
               => ! [V39a2] :
                    ( mem(V39a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                   => ! [V40a1_27] :
                        ( mem(V40a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V41a1] :
                            ( mem(V41a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V42a0_27] :
                                ( mem(V42a0_27,ty_2Ebinary__ieee_2Erounding)
                               => ! [V43a0] :
                                    ( mem(V43a0,ty_2Ebinary__ieee_2Erounding)
                                   => ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),V43a0),V41a1),V39a2) != ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),V42a0_27),V40a1_27),V38a2_27) ) ) ) ) ) )
            & ! [V44a2_27] :
                ( mem(V44a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
               => ! [V45a2] :
                    ( mem(V45a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                   => ! [V46a1_27] :
                        ( mem(V46a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V47a1] :
                            ( mem(V47a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V48a0_27] :
                                ( mem(V48a0_27,ty_2Ebinary__ieee_2Erounding)
                               => ! [V49a0] :
                                    ( mem(V49a0,ty_2Ebinary__ieee_2Erounding)
                                   => ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),V49a0),V47a1),V45a2) != ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),V48a0_27),V46a1_27),V44a2_27) ) ) ) ) ) )
            & ! [V50a3] :
                ( mem(V50a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
               => ! [V51a2_27] :
                    ( mem(V51a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                   => ! [V52a2] :
                        ( mem(V52a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V53a1_27] :
                            ( mem(V53a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V54a1] :
                                ( mem(V54a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                               => ! [V55a0_27] :
                                    ( mem(V55a0_27,ty_2Ebinary__ieee_2Erounding)
                                   => ! [V56a0] :
                                        ( mem(V56a0,ty_2Ebinary__ieee_2Erounding)
                                       => ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),V56a0),V54a1),V52a2) != ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),V55a0_27),V53a1_27),V51a2_27),V50a3) ) ) ) ) ) ) )
            & ! [V57a3] :
                ( mem(V57a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
               => ! [V58a2_27] :
                    ( mem(V58a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                   => ! [V59a2] :
                        ( mem(V59a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V60a1_27] :
                            ( mem(V60a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V61a1] :
                                ( mem(V61a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                               => ! [V62a0_27] :
                                    ( mem(V62a0_27,ty_2Ebinary__ieee_2Erounding)
                                   => ! [V63a0] :
                                        ( mem(V63a0,ty_2Ebinary__ieee_2Erounding)
                                       => ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),V63a0),V61a1),V59a2) != ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),V62a0_27),V60a1_27),V58a2_27),V57a3) ) ) ) ) ) ) )
            & ! [V64a2_27] :
                ( mem(V64a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
               => ! [V65a2] :
                    ( mem(V65a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                   => ! [V66a1_27] :
                        ( mem(V66a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V67a1] :
                            ( mem(V67a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V68a0_27] :
                                ( mem(V68a0_27,ty_2Ebinary__ieee_2Erounding)
                               => ! [V69a0] :
                                    ( mem(V69a0,ty_2Ebinary__ieee_2Erounding)
                                   => ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),V69a0),V67a1),V65a2) != ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),V68a0_27),V66a1_27),V64a2_27) ) ) ) ) ) )
            & ! [V70a2_27] :
                ( mem(V70a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
               => ! [V71a2] :
                    ( mem(V71a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                   => ! [V72a1_27] :
                        ( mem(V72a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V73a1] :
                            ( mem(V73a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V74a0_27] :
                                ( mem(V74a0_27,ty_2Ebinary__ieee_2Erounding)
                               => ! [V75a0] :
                                    ( mem(V75a0,ty_2Ebinary__ieee_2Erounding)
                                   => ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),V75a0),V73a1),V71a2) != ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),V74a0_27),V72a1_27),V70a2_27) ) ) ) ) ) )
            & ! [V76a3] :
                ( mem(V76a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
               => ! [V77a2_27] :
                    ( mem(V77a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                   => ! [V78a2] :
                        ( mem(V78a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V79a1_27] :
                            ( mem(V79a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V80a1] :
                                ( mem(V80a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                               => ! [V81a0_27] :
                                    ( mem(V81a0_27,ty_2Ebinary__ieee_2Erounding)
                                   => ! [V82a0] :
                                        ( mem(V82a0,ty_2Ebinary__ieee_2Erounding)
                                       => ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),V82a0),V80a1),V78a2) != ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),V81a0_27),V79a1_27),V77a2_27),V76a3) ) ) ) ) ) ) )
            & ! [V83a3] :
                ( mem(V83a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
               => ! [V84a2_27] :
                    ( mem(V84a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                   => ! [V85a2] :
                        ( mem(V85a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V86a1_27] :
                            ( mem(V86a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V87a1] :
                                ( mem(V87a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                               => ! [V88a0_27] :
                                    ( mem(V88a0_27,ty_2Ebinary__ieee_2Erounding)
                                   => ! [V89a0] :
                                        ( mem(V89a0,ty_2Ebinary__ieee_2Erounding)
                                       => ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),V89a0),V87a1),V85a2) != ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),V88a0_27),V86a1_27),V84a2_27),V83a3) ) ) ) ) ) ) )
            & ! [V90a2_27] :
                ( mem(V90a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
               => ! [V91a2] :
                    ( mem(V91a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                   => ! [V92a1_27] :
                        ( mem(V92a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V93a1] :
                            ( mem(V93a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V94a0_27] :
                                ( mem(V94a0_27,ty_2Ebinary__ieee_2Erounding)
                               => ! [V95a0] :
                                    ( mem(V95a0,ty_2Ebinary__ieee_2Erounding)
                                   => ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),V95a0),V93a1),V91a2) != ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),V94a0_27),V92a1_27),V90a2_27) ) ) ) ) ) )
            & ! [V96a3] :
                ( mem(V96a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
               => ! [V97a2_27] :
                    ( mem(V97a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                   => ! [V98a2] :
                        ( mem(V98a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V99a1_27] :
                            ( mem(V99a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V100a1] :
                                ( mem(V100a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                               => ! [V101a0_27] :
                                    ( mem(V101a0_27,ty_2Ebinary__ieee_2Erounding)
                                   => ! [V102a0] :
                                        ( mem(V102a0,ty_2Ebinary__ieee_2Erounding)
                                       => ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),V102a0),V100a1),V98a2) != ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),V101a0_27),V99a1_27),V97a2_27),V96a3) ) ) ) ) ) ) )
            & ! [V103a3] :
                ( mem(V103a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
               => ! [V104a2_27] :
                    ( mem(V104a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                   => ! [V105a2] :
                        ( mem(V105a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V106a1_27] :
                            ( mem(V106a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V107a1] :
                                ( mem(V107a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                               => ! [V108a0_27] :
                                    ( mem(V108a0_27,ty_2Ebinary__ieee_2Erounding)
                                   => ! [V109a0] :
                                        ( mem(V109a0,ty_2Ebinary__ieee_2Erounding)
                                       => ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),V109a0),V107a1),V105a2) != ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),V108a0_27),V106a1_27),V104a2_27),V103a3) ) ) ) ) ) ) )
            & ! [V110a3] :
                ( mem(V110a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
               => ! [V111a2_27] :
                    ( mem(V111a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                   => ! [V112a2] :
                        ( mem(V112a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V113a1_27] :
                            ( mem(V113a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V114a1] :
                                ( mem(V114a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                               => ! [V115a0_27] :
                                    ( mem(V115a0_27,ty_2Ebinary__ieee_2Erounding)
                                   => ! [V116a0] :
                                        ( mem(V116a0,ty_2Ebinary__ieee_2Erounding)
                                       => ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),V116a0),V114a1),V112a2) != ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),V115a0_27),V113a1_27),V111a2_27),V110a3) ) ) ) ) ) ) )
            & ! [V117a3] :
                ( mem(V117a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
               => ! [V118a2_27] :
                    ( mem(V118a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                   => ! [V119a2] :
                        ( mem(V119a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V120a1_27] :
                            ( mem(V120a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V121a1] :
                                ( mem(V121a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                               => ! [V122a0_27] :
                                    ( mem(V122a0_27,ty_2Ebinary__ieee_2Erounding)
                                   => ! [V123a0] :
                                        ( mem(V123a0,ty_2Ebinary__ieee_2Erounding)
                                       => ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),V123a0),V121a1),V119a2) != ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),V122a0_27),V120a1_27),V118a2_27),V117a3) ) ) ) ) ) ) )
            & ! [V124a3_27] :
                ( mem(V124a3_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
               => ! [V125a3] :
                    ( mem(V125a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                   => ! [V126a2_27] :
                        ( mem(V126a2_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                       => ! [V127a2] :
                            ( mem(V127a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                           => ! [V128a1_27] :
                                ( mem(V128a1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                               => ! [V129a1] :
                                    ( mem(V129a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                   => ! [V130a0_27] :
                                        ( mem(V130a0_27,ty_2Ebinary__ieee_2Erounding)
                                       => ! [V131a0] :
                                            ( mem(V131a0,ty_2Ebinary__ieee_2Erounding)
                                           => ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),V131a0),V129a1),V127a2),V125a3) != ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),V130a0_27),V128a1_27),V126a2_27),V124a3_27) ) ) ) ) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efp__op__nchotomy,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0ff] :
              ( mem(V0ff,ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))
             => ( ? [V1r] :
                    ( mem(V1r,ty_2Ebinary__ieee_2Erounding)
                    & ? [V2f] :
                        ( mem(V2f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                        & V0ff = ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),V1r),V2f) ) )
                | ? [V3r] :
                    ( mem(V3r,ty_2Ebinary__ieee_2Erounding)
                    & ? [V4f] :
                        ( mem(V4f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                        & ? [V5f0] :
                            ( mem(V5f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                            & V0ff = ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),V3r),V4f),V5f0) ) ) )
                | ? [V6r] :
                    ( mem(V6r,ty_2Ebinary__ieee_2Erounding)
                    & ? [V7f] :
                        ( mem(V7f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                        & ? [V8f0] :
                            ( mem(V8f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                            & V0ff = ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),V6r),V7f),V8f0) ) ) )
                | ? [V9r] :
                    ( mem(V9r,ty_2Ebinary__ieee_2Erounding)
                    & ? [V10f] :
                        ( mem(V10f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                        & ? [V11f0] :
                            ( mem(V11f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                            & V0ff = ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),V9r),V10f),V11f0) ) ) )
                | ? [V12r] :
                    ( mem(V12r,ty_2Ebinary__ieee_2Erounding)
                    & ? [V13f] :
                        ( mem(V13f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                        & ? [V14f0] :
                            ( mem(V14f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                            & V0ff = ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),V12r),V13f),V14f0) ) ) )
                | ? [V15r] :
                    ( mem(V15r,ty_2Ebinary__ieee_2Erounding)
                    & ? [V16f] :
                        ( mem(V16f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                        & ? [V17f0] :
                            ( mem(V17f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                            & ? [V18f1] :
                                ( mem(V18f1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                & V0ff = ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),V15r),V16f),V17f0),V18f1) ) ) ) )
                | ? [V19r] :
                    ( mem(V19r,ty_2Ebinary__ieee_2Erounding)
                    & ? [V20f] :
                        ( mem(V20f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                        & ? [V21f0] :
                            ( mem(V21f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                            & ? [V22f1] :
                                ( mem(V22f1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                & V0ff = ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),V19r),V20f),V21f0),V22f1) ) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efp__op__Axiom,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27t] :
          ( ne(A_27t)
         => ! [A_27w] :
              ( ne(A_27w)
             => ! [V0f0] :
                  ( mem(V0f0,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))
                 => ! [V1f1] :
                      ( mem(V1f1,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                     => ! [V2f2] :
                          ( mem(V2f2,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                         => ! [V3f3] :
                              ( mem(V3f3,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                             => ! [V4f4] :
                                  ( mem(V4f4,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                 => ! [V5f5] :
                                      ( mem(V5f5,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                     => ! [V6f6] :
                                          ( mem(V6f6,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                         => ? [V7fn] :
                                              ( mem(V7fn,arr(ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w),A_27a))
                                              & ! [V8a0] :
                                                  ( mem(V8a0,ty_2Ebinary__ieee_2Erounding)
                                                 => ! [V9a1] :
                                                      ( mem(V9a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                     => ap(V7fn,ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),V8a0),V9a1)) = ap(ap(V0f0,V8a0),V9a1) ) )
                                              & ! [V10a0] :
                                                  ( mem(V10a0,ty_2Ebinary__ieee_2Erounding)
                                                 => ! [V11a1] :
                                                      ( mem(V11a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                     => ! [V12a2] :
                                                          ( mem(V12a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                         => ap(V7fn,ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),V10a0),V11a1),V12a2)) = ap(ap(ap(V1f1,V10a0),V11a1),V12a2) ) ) )
                                              & ! [V13a0] :
                                                  ( mem(V13a0,ty_2Ebinary__ieee_2Erounding)
                                                 => ! [V14a1] :
                                                      ( mem(V14a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                     => ! [V15a2] :
                                                          ( mem(V15a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                         => ap(V7fn,ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),V13a0),V14a1),V15a2)) = ap(ap(ap(V2f2,V13a0),V14a1),V15a2) ) ) )
                                              & ! [V16a0] :
                                                  ( mem(V16a0,ty_2Ebinary__ieee_2Erounding)
                                                 => ! [V17a1] :
                                                      ( mem(V17a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                     => ! [V18a2] :
                                                          ( mem(V18a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                         => ap(V7fn,ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),V16a0),V17a1),V18a2)) = ap(ap(ap(V3f3,V16a0),V17a1),V18a2) ) ) )
                                              & ! [V19a0] :
                                                  ( mem(V19a0,ty_2Ebinary__ieee_2Erounding)
                                                 => ! [V20a1] :
                                                      ( mem(V20a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                     => ! [V21a2] :
                                                          ( mem(V21a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                         => ap(V7fn,ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),V19a0),V20a1),V21a2)) = ap(ap(ap(V4f4,V19a0),V20a1),V21a2) ) ) )
                                              & ! [V22a0] :
                                                  ( mem(V22a0,ty_2Ebinary__ieee_2Erounding)
                                                 => ! [V23a1] :
                                                      ( mem(V23a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                     => ! [V24a2] :
                                                          ( mem(V24a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                         => ! [V25a3] :
                                                              ( mem(V25a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                             => ap(V7fn,ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),V22a0),V23a1),V24a2),V25a3)) = ap(ap(ap(ap(V5f5,V22a0),V23a1),V24a2),V25a3) ) ) ) )
                                              & ! [V26a0] :
                                                  ( mem(V26a0,ty_2Ebinary__ieee_2Erounding)
                                                 => ! [V27a1] :
                                                      ( mem(V27a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                     => ! [V28a2] :
                                                          ( mem(V28a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                         => ! [V29a3] :
                                                              ( mem(V29a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                             => ap(V7fn,ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),V26a0),V27a1),V28a2),V29a3)) = ap(ap(ap(ap(V6f6,V26a0),V27a1),V28a2),V29a3) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efp__op__induction,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0P] :
              ( mem(V0P,arr(ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w),bool))
             => ( ( ! [V1r] :
                      ( mem(V1r,ty_2Ebinary__ieee_2Erounding)
                     => ! [V2f] :
                          ( mem(V2f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                         => p(ap(V0P,ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),V1r),V2f))) ) )
                  & ! [V3r] :
                      ( mem(V3r,ty_2Ebinary__ieee_2Erounding)
                     => ! [V4f] :
                          ( mem(V4f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                         => ! [V5f0] :
                              ( mem(V5f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                             => p(ap(V0P,ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),V3r),V4f),V5f0))) ) ) )
                  & ! [V6r] :
                      ( mem(V6r,ty_2Ebinary__ieee_2Erounding)
                     => ! [V7f] :
                          ( mem(V7f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                         => ! [V8f0] :
                              ( mem(V8f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                             => p(ap(V0P,ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),V6r),V7f),V8f0))) ) ) )
                  & ! [V9r] :
                      ( mem(V9r,ty_2Ebinary__ieee_2Erounding)
                     => ! [V10f] :
                          ( mem(V10f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                         => ! [V11f0] :
                              ( mem(V11f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                             => p(ap(V0P,ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),V9r),V10f),V11f0))) ) ) )
                  & ! [V12r] :
                      ( mem(V12r,ty_2Ebinary__ieee_2Erounding)
                     => ! [V13f] :
                          ( mem(V13f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                         => ! [V14f0] :
                              ( mem(V14f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                             => p(ap(V0P,ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),V12r),V13f),V14f0))) ) ) )
                  & ! [V15r] :
                      ( mem(V15r,ty_2Ebinary__ieee_2Erounding)
                     => ! [V16f] :
                          ( mem(V16f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                         => ! [V17f0] :
                              ( mem(V17f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                             => ! [V18f1] :
                                  ( mem(V18f1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                 => p(ap(V0P,ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),V15r),V16f),V17f0),V18f1))) ) ) ) )
                  & ! [V19r] :
                      ( mem(V19r,ty_2Ebinary__ieee_2Erounding)
                     => ! [V20f] :
                          ( mem(V20f,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                         => ! [V21f0] :
                              ( mem(V21f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                             => ! [V22f1] :
                                  ( mem(V22f1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                 => p(ap(V0P,ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),V19r),V20f),V21f0),V22f1))) ) ) ) ) )
               => ! [V23f] :
                    ( mem(V23f,ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))
                   => p(ap(V0P,V23f)) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efp__op__case__cong,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27t] :
          ( ne(A_27t)
         => ! [A_27w] :
              ( ne(A_27w)
             => ! [V0f_27] :
                  ( mem(V0f_27,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))
                 => ! [V1f1_27] :
                      ( mem(V1f1_27,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                     => ! [V2f2_27] :
                          ( mem(V2f2_27,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                         => ! [V3f3_27] :
                              ( mem(V3f3_27,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                             => ! [V4f4_27] :
                                  ( mem(V4f4_27,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                 => ! [V5f5_27] :
                                      ( mem(V5f5_27,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                     => ! [V6f6_27] :
                                          ( mem(V6f6_27,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                         => ! [V7M] :
                                              ( mem(V7M,ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))
                                             => ! [V8M_27] :
                                                  ( mem(V8M_27,ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))
                                                 => ! [V9f] :
                                                      ( mem(V9f,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))
                                                     => ! [V10f1] :
                                                          ( mem(V10f1,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                                         => ! [V11f2] :
                                                              ( mem(V11f2,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                                             => ! [V12f3] :
                                                                  ( mem(V12f3,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                                                 => ! [V13f4] :
                                                                      ( mem(V13f4,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                                                     => ! [V14f5] :
                                                                          ( mem(V14f5,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                                                         => ! [V15f6] :
                                                                              ( mem(V15f6,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                                                             => ( ( V7M = V8M_27
                                                                                  & ! [V16a0] :
                                                                                      ( mem(V16a0,ty_2Ebinary__ieee_2Erounding)
                                                                                     => ! [V17a1] :
                                                                                          ( mem(V17a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                                         => ( V8M_27 = ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),V16a0),V17a1)
                                                                                           => ap(ap(V9f,V16a0),V17a1) = ap(ap(V0f_27,V16a0),V17a1) ) ) )
                                                                                  & ! [V18a0] :
                                                                                      ( mem(V18a0,ty_2Ebinary__ieee_2Erounding)
                                                                                     => ! [V19a1] :
                                                                                          ( mem(V19a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                                         => ! [V20a2] :
                                                                                              ( mem(V20a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                                             => ( V8M_27 = ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),V18a0),V19a1),V20a2)
                                                                                               => ap(ap(ap(V10f1,V18a0),V19a1),V20a2) = ap(ap(ap(V1f1_27,V18a0),V19a1),V20a2) ) ) ) )
                                                                                  & ! [V21a0] :
                                                                                      ( mem(V21a0,ty_2Ebinary__ieee_2Erounding)
                                                                                     => ! [V22a1] :
                                                                                          ( mem(V22a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                                         => ! [V23a2] :
                                                                                              ( mem(V23a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                                             => ( V8M_27 = ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),V21a0),V22a1),V23a2)
                                                                                               => ap(ap(ap(V11f2,V21a0),V22a1),V23a2) = ap(ap(ap(V2f2_27,V21a0),V22a1),V23a2) ) ) ) )
                                                                                  & ! [V24a0] :
                                                                                      ( mem(V24a0,ty_2Ebinary__ieee_2Erounding)
                                                                                     => ! [V25a1] :
                                                                                          ( mem(V25a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                                         => ! [V26a2] :
                                                                                              ( mem(V26a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                                             => ( V8M_27 = ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),V24a0),V25a1),V26a2)
                                                                                               => ap(ap(ap(V12f3,V24a0),V25a1),V26a2) = ap(ap(ap(V3f3_27,V24a0),V25a1),V26a2) ) ) ) )
                                                                                  & ! [V27a0] :
                                                                                      ( mem(V27a0,ty_2Ebinary__ieee_2Erounding)
                                                                                     => ! [V28a1] :
                                                                                          ( mem(V28a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                                         => ! [V29a2] :
                                                                                              ( mem(V29a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                                             => ( V8M_27 = ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),V27a0),V28a1),V29a2)
                                                                                               => ap(ap(ap(V13f4,V27a0),V28a1),V29a2) = ap(ap(ap(V4f4_27,V27a0),V28a1),V29a2) ) ) ) )
                                                                                  & ! [V30a0] :
                                                                                      ( mem(V30a0,ty_2Ebinary__ieee_2Erounding)
                                                                                     => ! [V31a1] :
                                                                                          ( mem(V31a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                                         => ! [V32a2] :
                                                                                              ( mem(V32a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                                             => ! [V33a3] :
                                                                                                  ( mem(V33a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                                                 => ( V8M_27 = ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),V30a0),V31a1),V32a2),V33a3)
                                                                                                   => ap(ap(ap(ap(V14f5,V30a0),V31a1),V32a2),V33a3) = ap(ap(ap(ap(V5f5_27,V30a0),V31a1),V32a2),V33a3) ) ) ) ) )
                                                                                  & ! [V34a0] :
                                                                                      ( mem(V34a0,ty_2Ebinary__ieee_2Erounding)
                                                                                     => ! [V35a1] :
                                                                                          ( mem(V35a1,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                                         => ! [V36a2] :
                                                                                              ( mem(V36a2,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                                             => ! [V37a3] :
                                                                                                  ( mem(V37a3,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                                                 => ( V8M_27 = ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),V34a0),V35a1),V36a2),V37a3)
                                                                                                   => ap(ap(ap(ap(V15f6,V34a0),V35a1),V36a2),V37a3) = ap(ap(ap(ap(V6f6_27,V34a0),V35a1),V36a2),V37a3) ) ) ) ) ) )
                                                                               => ap(ap(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efp__op__CASE(A_27a,A_27t,A_27w),V7M),V9f),V10f1),V11f2),V12f3),V13f4),V14f5),V15f6) = ap(ap(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efp__op__CASE(A_27a,A_27t,A_27w),V8M_27),V0f_27),V1f1_27),V2f2_27),V3f3_27),V4f4_27),V5f5_27),V6f6_27) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efp__op__case__eq,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27t] :
          ( ne(A_27t)
         => ! [A_27w] :
              ( ne(A_27w)
             => ! [V0x] :
                  ( mem(V0x,ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))
                 => ! [V1f] :
                      ( mem(V1f,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))
                     => ! [V2f1] :
                          ( mem(V2f1,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                         => ! [V3f2] :
                              ( mem(V3f2,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                             => ! [V4f3] :
                                  ( mem(V4f3,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                 => ! [V5f4] :
                                      ( mem(V5f4,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a))))
                                     => ! [V6f5] :
                                          ( mem(V6f5,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                         => ! [V7f6] :
                                              ( mem(V7f6,arr(ty_2Ebinary__ieee_2Erounding,arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),A_27a)))))
                                             => ! [V8v] :
                                                  ( mem(V8v,A_27a)
                                                 => ( ap(ap(ap(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efp__op__CASE(A_27a,A_27t,A_27w),V0x),V1f),V2f1),V3f2),V4f3),V5f4),V6f5),V7f6) = V8v
                                                  <=> ( ? [V9r] :
                                                          ( mem(V9r,ty_2Ebinary__ieee_2Erounding)
                                                          & ? [V10f_27] :
                                                              ( mem(V10f_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                              & V0x = ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),V9r),V10f_27)
                                                              & ap(ap(V1f,V9r),V10f_27) = V8v ) )
                                                      | ? [V11r] :
                                                          ( mem(V11r,ty_2Ebinary__ieee_2Erounding)
                                                          & ? [V12f_27] :
                                                              ( mem(V12f_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                              & ? [V13f0] :
                                                                  ( mem(V13f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                  & V0x = ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),V11r),V12f_27),V13f0)
                                                                  & ap(ap(ap(V2f1,V11r),V12f_27),V13f0) = V8v ) ) )
                                                      | ? [V14r] :
                                                          ( mem(V14r,ty_2Ebinary__ieee_2Erounding)
                                                          & ? [V15f_27] :
                                                              ( mem(V15f_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                              & ? [V16f0] :
                                                                  ( mem(V16f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                  & V0x = ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),V14r),V15f_27),V16f0)
                                                                  & ap(ap(ap(V3f2,V14r),V15f_27),V16f0) = V8v ) ) )
                                                      | ? [V17r] :
                                                          ( mem(V17r,ty_2Ebinary__ieee_2Erounding)
                                                          & ? [V18f_27] :
                                                              ( mem(V18f_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                              & ? [V19f0] :
                                                                  ( mem(V19f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                  & V0x = ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),V17r),V18f_27),V19f0)
                                                                  & ap(ap(ap(V4f3,V17r),V18f_27),V19f0) = V8v ) ) )
                                                      | ? [V20r] :
                                                          ( mem(V20r,ty_2Ebinary__ieee_2Erounding)
                                                          & ? [V21f_27] :
                                                              ( mem(V21f_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                              & ? [V22f0] :
                                                                  ( mem(V22f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                  & V0x = ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),V20r),V21f_27),V22f0)
                                                                  & ap(ap(ap(V5f4,V20r),V21f_27),V22f0) = V8v ) ) )
                                                      | ? [V23r] :
                                                          ( mem(V23r,ty_2Ebinary__ieee_2Erounding)
                                                          & ? [V24f_27] :
                                                              ( mem(V24f_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                              & ? [V25f0] :
                                                                  ( mem(V25f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                  & ? [V26f1_27] :
                                                                      ( mem(V26f1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                      & V0x = ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),V23r),V24f_27),V25f0),V26f1_27)
                                                                      & ap(ap(ap(ap(V6f5,V23r),V24f_27),V25f0),V26f1_27) = V8v ) ) ) )
                                                      | ? [V27r] :
                                                          ( mem(V27r,ty_2Ebinary__ieee_2Erounding)
                                                          & ? [V28f_27] :
                                                              ( mem(V28f_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                              & ? [V29f0] :
                                                                  ( mem(V29f0,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                  & ? [V30f1_27] :
                                                                      ( mem(V30f1_27,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                                                                      & V0x = ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),V27r),V28f_27),V29f0),V30f1_27)
                                                                      & ap(ap(ap(ap(V7f6,V27r),V28f_27),V29f0),V30f1_27) = V8v ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

fof(lameq_f3020,axiom,
    ! [A_27w,A_27t,V2qnan] : ap(f3020(A_27w,A_27t),V2qnan) = ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),V2qnan)),ap(c_2Ebool_2E_7E,ap(c_2Ebinary__ieee_2Efloat__is__signalling(A_27t,A_27w),V2qnan))) ).

fof(lameq_f3021,axiom,
    ! [A_27t,A_27w,V0fp__op] :
      ( mem(V0fp__op,ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))
     => ! [V1f] : ap(f3021(A_27t,A_27w,V0fp__op),V1f) = ap(ap(c_2Ebool_2ELET(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),bool),f3020(A_27w,A_27t)),ap(V1f,V0fp__op)) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__some__qnan__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0fp__op] :
              ( mem(V0fp__op,ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))
             => ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),V0fp__op) = ap(ap(c_2Emin_2E_40(arr(ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),f3021(A_27t,A_27w,V0fp__op)),V0fp__op) ) ) ) ).

fof(lameq_f3022,axiom,
    ! [A_27t,A_27w,V1toneg] :
      ( mem(V1toneg,bool)
     => ! [V3x] : ap(f3022(A_27t,A_27w,V1toneg),V3x) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w),V3x)),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V1toneg),ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))),V3x) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__round__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0mode] :
              ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
             => ! [V1toneg] :
                  ( mem(V1toneg,bool)
                 => ! [V2r] :
                      ( mem(V2r,ty_2Erealax_2Ereal)
                     => ap(ap(ap(c_2Ebinary__ieee_2Efloat__round(A_27t,A_27w),V0mode),V1toneg),V2r) = ap(ap(c_2Ebool_2ELET(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),f3022(A_27t,A_27w,V1toneg)),ap(ap(c_2Ebinary__ieee_2Eround(A_27t,A_27w),V0mode),V2r)) ) ) ) ) ) ).

fof(lameq_f3023,axiom,
    ! [A_27w,A_27t,V2r] :
      ( mem(V2r,ty_2Erealax_2Ereal)
     => ! [V0mode] :
          ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
         => ! [V1to__neg] :
              ( mem(V1to__neg,bool)
             => ! [V4a] :
                  ( mem(V4a,ty_2Erealax_2Ereal)
                 => ! [V3x] :
                      ( mem(V3x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ! [V5inexact] : ap(f3023(A_27w,A_27t,V2r,V0mode,V1to__neg,V4a,V3x),V5inexact) = ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Ebinary__ieee_2Eflags__Overflow__fupd,ap(c_2Ecombin_2EK(bool,bool),ap(ap(c_2Ebool_2E_5C_2F,ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V3x)),ap(ap(c_2Ereal_2Ereal__lte,ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),ap(c_2Ewords_2EINT__MIN(A_27w),c_2Ebool_2Ethe__value(A_27w)))),V4a)))),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),ap(ap(c_2Ebool_2E_2F_5C,V5inexact),ap(ap(c_2Erealax_2Ereal__lt,V4a),ap(ap(c_2Ereal_2E_2F,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),ap(c_2Ewords_2EINT__MAX(A_27w),c_2Ebool_2Ethe__value(A_27w)))))))),ap(ap(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,ap(c_2Ecombin_2EK(bool,bool),ap(ap(c_2Ebool_2E_2F_5C,V5inexact),ap(ap(c_2Ewords_2Eword__ls(ty_2Esum_2Esum(A_27w,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,ty_2Esum_2Esum(A_27w,ty_2Eone_2Eone)),ap(ap(ap(c_2Ebinary__ieee_2Efloat__round(A_27t,ty_2Esum_2Esum(A_27w,ty_2Eone_2Eone)),V0mode),V1to__neg),V2r))),ap(c_2Ewords_2En2w(ty_2Esum_2Esum(A_27w,ty_2Eone_2Eone)),ap(c_2Ewords_2EINT__MIN(A_27w),c_2Ebool_2Ethe__value(A_27w))))))),ap(ap(c_2Ebinary__ieee_2Eflags__Precision__fupd,ap(c_2Ecombin_2EK(bool,bool),V5inexact)),c_2Ebinary__ieee_2Eclear__flags))))),V3x) ) ) ) ) ) ).

fof(lameq_f3024,axiom,
    ! [A_27t,A_27w,V0mode] :
      ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
     => ! [V1to__neg] :
          ( mem(V1to__neg,bool)
         => ! [V2r] :
              ( mem(V2r,ty_2Erealax_2Ereal)
             => ! [V3x] :
                  ( mem(V3x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V4a] : ap(f3024(A_27t,A_27w,V0mode,V1to__neg,V2r,V3x),V4a) = ap(ap(c_2Ebool_2ELET(bool,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),f3023(A_27w,A_27t,V2r,V0mode,V1to__neg,V4a,V3x)),ap(c_2Ebool_2E_7E,ap(ap(c_2Emin_2E_3D(ty_2Ebinary__ieee_2Efloat__value),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V3x)),ap(c_2Ebinary__ieee_2EFloat,V2r)))) ) ) ) ) ).

fof(lameq_f3025,axiom,
    ! [A_27t,A_27w,V0mode] :
      ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
     => ! [V1to__neg] :
          ( mem(V1to__neg,bool)
         => ! [V2r] :
              ( mem(V2r,ty_2Erealax_2Ereal)
             => ! [V3x] : ap(f3025(A_27t,A_27w,V0mode,V1to__neg,V2r),V3x) = f3024(A_27t,A_27w,V0mode,V1to__neg,V2r,V3x) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__round__with__flags__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0mode] :
              ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
             => ! [V1to__neg] :
                  ( mem(V1to__neg,bool)
                 => ! [V2r] :
                      ( mem(V2r,ty_2Erealax_2Ereal)
                     => ap(ap(ap(c_2Ebinary__ieee_2Efloat__round__with__flags(A_27t,A_27w),V0mode),V1to__neg),V2r) = ap(ap(c_2Ebool_2ELET(ty_2Erealax_2Ereal,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Ebool_2ELET(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w),arr(ty_2Erealax_2Ereal,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))),f3025(A_27t,A_27w,V0mode,V1to__neg,V2r)),ap(ap(ap(c_2Ebinary__ieee_2Efloat__round(A_27t,A_27w),V0mode),V1to__neg),V2r))),ap(c_2Ereal_2Eabs,V2r)) ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Echeck__for__signalling__def,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27b] :
          ( ne(A_27b)
         => ! [V0l] :
              ( mem(V0l,ty_2Elist_2Elist(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b)))
             => ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27a,A_27b),V0l) = ap(ap(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,ap(c_2Ecombin_2EK(bool,bool),ap(ap(c_2Elist_2EEXISTS(ty_2Ebinary__ieee_2Efloat(A_27a,A_27b)),c_2Ebinary__ieee_2Efloat__is__signalling(A_27a,A_27b)),V0l))),c_2Ebinary__ieee_2Eclear__flags) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Ereal__to__float__def,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27b] :
          ( ne(A_27b)
         => ! [V0m] :
              ( mem(V0m,ty_2Ebinary__ieee_2Erounding)
             => ap(c_2Ebinary__ieee_2Ereal__to__float(A_27a,A_27b),V0m) = ap(ap(c_2Ebinary__ieee_2Efloat__round(A_27a,A_27b),V0m),ap(ap(c_2Emin_2E_3D(ty_2Ebinary__ieee_2Erounding),V0m),c_2Ebinary__ieee_2EroundTowardNegative)) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Ereal__to__float__with__flags__def,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27b] :
          ( ne(A_27b)
         => ! [V0m] :
              ( mem(V0m,ty_2Ebinary__ieee_2Erounding)
             => ap(c_2Ebinary__ieee_2Ereal__to__float__with__flags(A_27a,A_27b),V0m) = ap(ap(c_2Ebinary__ieee_2Efloat__round__with__flags(A_27a,A_27b),V0m),ap(ap(c_2Emin_2E_3D(ty_2Ebinary__ieee_2Erounding),V0m),c_2Ebinary__ieee_2EroundTowardNegative)) ) ) ) ).

fof(lameq_f3026,axiom,
    ! [A_27t,A_27w,V0mode] :
      ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
     => ! [V2r] : ap(f3026(A_27t,A_27w,V0mode),V2r) = ap(ap(c_2Ebinary__ieee_2Eintegral__round(A_27t,A_27w),V0mode),V2r) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__round__to__integral__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0mode] :
              ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
             => ! [V1x] :
                  ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ap(ap(c_2Ebinary__ieee_2Efloat__round__to__integral(A_27t,A_27w),V0mode),V1x) = ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V1x)),f3026(A_27t,A_27w,V0mode)),V1x),V1x) ) ) ) ) ).

fof(lameq_f3027,axiom,
    ! [V3f] :
      ( mem(V3f,ty_2Einteger_2Eint)
     => ! [V2r] :
          ( mem(V2r,ty_2Erealax_2Ereal)
         => ! [V4df] : ap(f3027(V3f,V2r),V4df) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Einteger_2Eint),ap(ap(c_2Ebool_2E_5C_2F,ap(ap(c_2Erealax_2Ereal__lt,V4df),ap(ap(c_2Ereal_2E_2F,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)))),ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))))),ap(ap(c_2Ebool_2E_2F_5C,ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),V4df),ap(ap(c_2Ereal_2E_2F,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)))),ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))))),ap(c_2Earithmetic_2EEVEN,ap(c_2Einteger_2ENum,ap(c_2Einteger_2EABS,V3f)))))),V3f),ap(c_2Eintreal_2EINT__CEILING,V2r)) ) ) ).

fof(lameq_f3028,axiom,
    ! [V2r] :
      ( mem(V2r,ty_2Erealax_2Ereal)
     => ! [V3f] : ap(f3028(V2r),V3f) = ap(ap(c_2Ebool_2ELET(ty_2Erealax_2Ereal,ty_2Einteger_2Eint),f3027(V3f,V2r)),ap(c_2Ereal_2Eabs,ap(ap(c_2Ereal_2Ereal__sub,V2r),ap(c_2Eintreal_2Ereal__of__int,V3f)))) ) ).

fof(lameq_f3029,axiom,
    ! [A_27t,A_27w,V1x] :
      ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V0mode] :
          ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
         => ! [V2r] : ap(f3029(A_27t,A_27w,V1x,V0mode),V2r) = ap(c_2Eoption_2ESOME(ty_2Einteger_2Eint),ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Erounding__CASE(ty_2Einteger_2Eint),V0mode),ap(ap(c_2Ebool_2ELET(ty_2Einteger_2Eint,ty_2Einteger_2Eint),f3028(V2r)),ap(c_2Eintreal_2EINT__FLOOR,V2r))),ap(c_2Eintreal_2EINT__CEILING,V2r)),ap(c_2Eintreal_2EINT__FLOOR,V2r)),ap(ap(ap(c_2Ebool_2ECOND(ty_2Einteger_2Eint),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))))),ap(c_2Eintreal_2EINT__CEILING,V2r)),ap(c_2Eintreal_2EINT__FLOOR,V2r)))) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__to__int__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0mode] :
              ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
             => ! [V1x] :
                  ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ap(ap(c_2Ebinary__ieee_2Efloat__to__int(A_27t,A_27w),V0mode),V1x) = ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Eoption_2Eoption(ty_2Einteger_2Eint)),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V1x)),f3029(A_27t,A_27w,V1x,V0mode)),c_2Eoption_2ENONE(ty_2Einteger_2Eint)),c_2Eoption_2ENONE(ty_2Einteger_2Eint)) ) ) ) ) ).

fof(lameq_f3030,axiom,
    ! [A_27w,A_27t,V0mode] :
      ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
     => ! [V2r] : ap(f3030(A_27w,A_27t,V0mode),V2r) = ap(ap(ap(c_2Ebinary__ieee_2Efloat__round__with__flags(A_27t,A_27w),V0mode),c_2Ebool_2EF),ap(c_2Etransc_2Esqrt,V2r)) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__sqrt__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0mode] :
              ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
             => ! [V1x] :
                  ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ap(ap(c_2Ebinary__ieee_2Efloat__sqrt(A_27t,A_27w),V0mode),V1x) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),c_2Enum_2E0))),ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V1x)),f3030(A_27w,A_27t,V0mode)),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),c_2Ebinary__ieee_2Eclear__flags),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27t,A_27w),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V1x),c_2Elist_2ENIL(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),V0mode),V1x))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),c_2Ebinary__ieee_2Einvalidop__flags),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(c_2Ebinary__ieee_2EFP__Sqrt(A_27t,A_27w),V0mode),V1x)))) ) ) ) ) ).

fof(lameq_f3031,axiom,
    ! [A_27w,A_27t,V0mode] :
      ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
     => ! [V1x] :
          ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V2y] :
              ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V5r1] :
                  ( mem(V5r1,ty_2Erealax_2Ereal)
                 => ! [V6r2] : ap(f3031(A_27w,A_27t,V0mode,V1x,V2y,V5r1),V6r2) = ap(ap(ap(c_2Ebinary__ieee_2Efloat__round__with__flags(A_27t,A_27w),V0mode),ap(ap(ap(c_2Ebool_2ECOND(bool),ap(ap(c_2Ebool_2E_2F_5C,ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),V5r1),ap(c_2Ereal_2Ereal__of__num,c_2Enum_2E0))),ap(ap(c_2Ebool_2E_2F_5C,ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),V6r2),ap(c_2Ereal_2Ereal__of__num,c_2Enum_2E0))),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V2y))))),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))))),ap(ap(c_2Emin_2E_3D(ty_2Ebinary__ieee_2Erounding),V0mode),c_2Ebinary__ieee_2EroundTowardNegative))),ap(ap(c_2Erealax_2Ereal__add,V5r1),V6r2)) ) ) ) ) ).

fof(lameq_f3032,axiom,
    ! [A_27w,A_27t,V4v1] :
      ( mem(V4v1,ty_2Ebinary__ieee_2Efloat__value)
     => ! [V1x] :
          ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V0mode] :
              ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
             => ! [V2y] :
                  ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V5r1] : ap(f3032(A_27w,A_27t,V4v1,V1x,V0mode,V2y),V5r1) = ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),V4v1),f3031(A_27w,A_27t,V0mode,V1x,V2y,V5r1)),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),c_2Ebinary__ieee_2Eclear__flags),V2y)),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27t,A_27w),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V2y),c_2Elist_2ENIL(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),V0mode),V1x),V2y)))) ) ) ) ) ).

fof(lameq_f3033,axiom,
    ! [A_27w,A_27t,V3v] :
      ( mem(V3v,ty_2Ebinary__ieee_2Efloat__value)
     => ! [V0mode] :
          ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
         => ! [V1x] :
              ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V2y] :
                  ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V4v1] : ap(f3033(A_27w,A_27t,V3v,V0mode,V1x,V2y),V4v1) = ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),V3v),f3032(A_27w,A_27t,V4v1,V1x,V0mode,V2y)),ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),V4v1),k(ty_2Erealax_2Ereal,ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),c_2Ebinary__ieee_2Eclear__flags),V1x))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V2y))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),c_2Ebinary__ieee_2Eclear__flags),V1x)),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),c_2Ebinary__ieee_2Einvalidop__flags),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),V0mode),V1x),V2y))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27t,A_27w),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V2y),c_2Elist_2ENIL(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),V0mode),V1x),V2y))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27t,A_27w),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V1x),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V2y),c_2Elist_2ENIL(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Add(A_27t,A_27w),V0mode),V1x),V2y)))) ) ) ) ) ).

fof(lameq_f3034,axiom,
    ! [A_27t,A_27w,V0mode] :
      ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
     => ! [V1x] :
          ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V2y] :
              ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V3v] : ap(f3034(A_27t,A_27w,V0mode,V1x,V2y),V3v) = f3033(A_27w,A_27t,V3v,V0mode,V1x,V2y) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__add__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0mode] :
              ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
             => ! [V1x] :
                  ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V2y] :
                      ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ap(ap(ap(c_2Ebinary__ieee_2Efloat__add(A_27t,A_27w),V0mode),V1x),V2y) = ap(ap(c_2Epair_2Epair__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ty_2Ebinary__ieee_2Efloat__value,ty_2Ebinary__ieee_2Efloat__value),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat__value,ty_2Ebinary__ieee_2Efloat__value),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V2y))),f3034(A_27t,A_27w,V0mode,V1x,V2y)) ) ) ) ) ) ).

fof(lameq_f3035,axiom,
    ! [A_27w,A_27t,V0mode] :
      ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
     => ! [V1x] :
          ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V2y] :
              ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V5r1] :
                  ( mem(V5r1,ty_2Erealax_2Ereal)
                 => ! [V6r2] : ap(f3035(A_27w,A_27t,V0mode,V1x,V2y,V5r1),V6r2) = ap(ap(ap(c_2Ebinary__ieee_2Efloat__round__with__flags(A_27t,A_27w),V0mode),ap(ap(ap(c_2Ebool_2ECOND(bool),ap(ap(c_2Ebool_2E_2F_5C,ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),V5r1),ap(c_2Ereal_2Ereal__of__num,c_2Enum_2E0))),ap(ap(c_2Ebool_2E_2F_5C,ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),V6r2),ap(c_2Ereal_2Ereal__of__num,c_2Enum_2E0))),ap(c_2Ebool_2E_7E,ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V2y)))))),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))))),ap(ap(c_2Emin_2E_3D(ty_2Ebinary__ieee_2Erounding),V0mode),c_2Ebinary__ieee_2EroundTowardNegative))),ap(ap(c_2Ereal_2Ereal__sub,V5r1),V6r2)) ) ) ) ) ).

fof(lameq_f3036,axiom,
    ! [A_27w,A_27t,V4v1] :
      ( mem(V4v1,ty_2Ebinary__ieee_2Efloat__value)
     => ! [V1x] :
          ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V0mode] :
              ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
             => ! [V2y] :
                  ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V5r1] : ap(f3036(A_27w,A_27t,V4v1,V1x,V0mode,V2y),V5r1) = ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),V4v1),f3035(A_27w,A_27t,V0mode,V1x,V2y,V5r1)),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),c_2Ebinary__ieee_2Eclear__flags),ap(c_2Ebinary__ieee_2Efloat__negate(A_27t,A_27w),V2y))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27t,A_27w),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V2y),c_2Elist_2ENIL(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),V0mode),V1x),V2y)))) ) ) ) ) ).

fof(lameq_f3037,axiom,
    ! [A_27w,A_27t,V3v] :
      ( mem(V3v,ty_2Ebinary__ieee_2Efloat__value)
     => ! [V0mode] :
          ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
         => ! [V1x] :
              ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V2y] :
                  ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V4v1] : ap(f3037(A_27w,A_27t,V3v,V0mode,V1x,V2y),V4v1) = ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),V3v),f3036(A_27w,A_27t,V4v1,V1x,V0mode,V2y)),ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),V4v1),k(ty_2Erealax_2Ereal,ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),c_2Ebinary__ieee_2Eclear__flags),V1x))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V2y))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),c_2Ebinary__ieee_2Einvalidop__flags),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),V0mode),V1x),V2y)))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),c_2Ebinary__ieee_2Eclear__flags),V1x))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27t,A_27w),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V2y),c_2Elist_2ENIL(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),V0mode),V1x),V2y))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27t,A_27w),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V1x),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V2y),c_2Elist_2ENIL(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Sub(A_27t,A_27w),V0mode),V1x),V2y)))) ) ) ) ) ).

fof(lameq_f3038,axiom,
    ! [A_27t,A_27w,V0mode] :
      ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
     => ! [V1x] :
          ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V2y] :
              ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V3v] : ap(f3038(A_27t,A_27w,V0mode,V1x,V2y),V3v) = f3037(A_27w,A_27t,V3v,V0mode,V1x,V2y) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__sub__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0mode] :
              ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
             => ! [V1x] :
                  ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V2y] :
                      ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ap(ap(ap(c_2Ebinary__ieee_2Efloat__sub(A_27t,A_27w),V0mode),V1x),V2y) = ap(ap(c_2Epair_2Epair__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ty_2Ebinary__ieee_2Efloat__value,ty_2Ebinary__ieee_2Efloat__value),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat__value,ty_2Ebinary__ieee_2Efloat__value),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V2y))),f3038(A_27t,A_27w,V0mode,V1x,V2y)) ) ) ) ) ) ).

fof(lameq_f3039,axiom,
    ! [A_27w,A_27t,V0mode] :
      ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
     => ! [V2y] :
          ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V1x] :
              ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V5r_27] :
                  ( mem(V5r_27,ty_2Erealax_2Ereal)
                 => ! [V6r2] : ap(f3039(A_27w,A_27t,V0mode,V2y,V1x,V5r_27),V6r2) = ap(ap(ap(c_2Ebinary__ieee_2Efloat__round__with__flags(A_27t,A_27w),V0mode),ap(c_2Ebool_2E_7E,ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V2y)))),ap(ap(c_2Erealax_2Ereal__mul,V5r_27),V6r2)) ) ) ) ) ).

fof(lameq_f3040,axiom,
    ! [A_27w,A_27t,V4v1] :
      ( mem(V4v1,ty_2Ebinary__ieee_2Efloat__value)
     => ! [V1x] :
          ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V0mode] :
              ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
             => ! [V2y] :
                  ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V5r_27] : ap(f3040(A_27w,A_27t,V4v1,V1x,V0mode,V2y),V5r_27) = ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),V4v1),f3039(A_27w,A_27t,V0mode,V2y,V1x,V5r_27)),ap(ap(ap(c_2Ebool_2ECOND(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),V5r_27),ap(c_2Ereal_2Ereal__of__num,c_2Enum_2E0))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),c_2Ebinary__ieee_2Einvalidop__flags),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),V0mode),V1x),V2y)))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),c_2Ebinary__ieee_2Eclear__flags),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V2y))),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27t,A_27w),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V2y),c_2Elist_2ENIL(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),V0mode),V1x),V2y)))) ) ) ) ) ).

fof(lameq_f3041,axiom,
    ! [A_27t,A_27w,V0mode] :
      ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
     => ! [V1x] :
          ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V2y] :
              ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V7r] : ap(f3041(A_27t,A_27w,V0mode,V1x,V2y),V7r) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),V7r),ap(c_2Ereal_2Ereal__of__num,c_2Enum_2E0))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),c_2Ebinary__ieee_2Einvalidop__flags),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),V0mode),V1x),V2y)))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),c_2Ebinary__ieee_2Eclear__flags),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V2y))),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))) ) ) ) ).

fof(lameq_f3042,axiom,
    ! [A_27w,A_27t,V3v] :
      ( mem(V3v,ty_2Ebinary__ieee_2Efloat__value)
     => ! [V0mode] :
          ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
         => ! [V1x] :
              ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V2y] :
                  ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V4v1] : ap(f3042(A_27w,A_27t,V3v,V0mode,V1x,V2y),V4v1) = ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),V3v),f3040(A_27w,A_27t,V4v1,V1x,V0mode,V2y)),ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),V4v1),f3041(A_27t,A_27w,V0mode,V1x,V2y)),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),c_2Ebinary__ieee_2Eclear__flags),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V2y))),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27t,A_27w),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V2y),c_2Elist_2ENIL(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),V0mode),V1x),V2y))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27t,A_27w),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V1x),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V2y),c_2Elist_2ENIL(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Mul(A_27t,A_27w),V0mode),V1x),V2y)))) ) ) ) ) ).

fof(lameq_f3043,axiom,
    ! [A_27t,A_27w,V0mode] :
      ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
     => ! [V1x] :
          ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V2y] :
              ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V3v] : ap(f3043(A_27t,A_27w,V0mode,V1x,V2y),V3v) = f3042(A_27w,A_27t,V3v,V0mode,V1x,V2y) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__mul__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0mode] :
              ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
             => ! [V1x] :
                  ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V2y] :
                      ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ap(ap(ap(c_2Ebinary__ieee_2Efloat__mul(A_27t,A_27w),V0mode),V1x),V2y) = ap(ap(c_2Epair_2Epair__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ty_2Ebinary__ieee_2Efloat__value,ty_2Ebinary__ieee_2Efloat__value),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat__value,ty_2Ebinary__ieee_2Efloat__value),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V2y))),f3043(A_27t,A_27w,V0mode,V1x,V2y)) ) ) ) ) ) ).

fof(lameq_f3044,axiom,
    ! [A_27w,A_27t,V0mode] :
      ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
     => ! [V2y] :
          ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V1x] :
              ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V5r1] :
                  ( mem(V5r1,ty_2Erealax_2Ereal)
                 => ! [V6r2] : ap(f3044(A_27w,A_27t,V0mode,V2y,V1x,V5r1),V6r2) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),V6r2),ap(c_2Ereal_2Ereal__of__num,c_2Enum_2E0))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),V5r1),ap(c_2Ereal_2Ereal__of__num,c_2Enum_2E0))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),c_2Ebinary__ieee_2Einvalidop__flags),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),V0mode),V1x),V2y)))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),c_2Ebinary__ieee_2Edividezero__flags),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V2y))),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))))),ap(ap(ap(c_2Ebinary__ieee_2Efloat__round__with__flags(A_27t,A_27w),V0mode),ap(c_2Ebool_2E_7E,ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V2y)))),ap(ap(c_2Ereal_2E_2F,V5r1),V6r2))) ) ) ) ) ).

fof(lameq_f3045,axiom,
    ! [A_27w,A_27t,V4v1] :
      ( mem(V4v1,ty_2Ebinary__ieee_2Efloat__value)
     => ! [V1x] :
          ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V0mode] :
              ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
             => ! [V2y] :
                  ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V5r1] : ap(f3045(A_27w,A_27t,V4v1,V1x,V0mode,V2y),V5r1) = ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),V4v1),f3044(A_27w,A_27t,V0mode,V2y,V1x,V5r1)),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),c_2Ebinary__ieee_2Eclear__flags),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V2y))),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27t,A_27w),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V2y),c_2Elist_2ENIL(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),V0mode),V1x),V2y)))) ) ) ) ) ).

fof(lameq_f3046,axiom,
    ! [A_27w,A_27t,V3v] :
      ( mem(V3v,ty_2Ebinary__ieee_2Efloat__value)
     => ! [V0mode] :
          ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
         => ! [V1x] :
              ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V2y] :
                  ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V4v1] : ap(f3046(A_27w,A_27t,V3v,V0mode,V1x,V2y),V4v1) = ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),V3v),f3045(A_27w,A_27t,V4v1,V1x,V0mode,V2y)),ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),V4v1),k(ty_2Erealax_2Ereal,ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),c_2Ebinary__ieee_2Eclear__flags),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V2y))),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),c_2Ebinary__ieee_2Einvalidop__flags),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),V0mode),V1x),V2y)))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27t,A_27w),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V2y),c_2Elist_2ENIL(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),V0mode),V1x),V2y))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27t,A_27w),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V1x),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V2y),c_2Elist_2ENIL(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))))),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(c_2Ebinary__ieee_2EFP__Div(A_27t,A_27w),V0mode),V1x),V2y)))) ) ) ) ) ).

fof(lameq_f3047,axiom,
    ! [A_27t,A_27w,V0mode] :
      ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
     => ! [V1x] :
          ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V2y] :
              ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V3v] : ap(f3047(A_27t,A_27w,V0mode,V1x,V2y),V3v) = f3046(A_27w,A_27t,V3v,V0mode,V1x,V2y) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__div__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0mode] :
              ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
             => ! [V1x] :
                  ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V2y] :
                      ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ap(ap(ap(c_2Ebinary__ieee_2Efloat__div(A_27t,A_27w),V0mode),V1x),V2y) = ap(ap(c_2Epair_2Epair__CASE(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ty_2Ebinary__ieee_2Efloat__value,ty_2Ebinary__ieee_2Efloat__value),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat__value,ty_2Ebinary__ieee_2Efloat__value),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V2y))),f3047(A_27t,A_27w,V0mode,V1x,V2y)) ) ) ) ) ) ).

fof(lameq_f3048,axiom,
    ! [A_27t,A_27w,V0mode] :
      ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
     => ! [V4signP] :
          ( mem(V4signP,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
         => ! [V3z] :
              ( mem(V3z,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V6r1] :
                  ( mem(V6r1,ty_2Erealax_2Ereal)
                 => ! [V7r2] : ap(f3048(A_27t,A_27w,V0mode,V4signP,V3z,V6r1),V7r2) = ap(ap(ap(c_2Ebinary__ieee_2Efloat__round__with__flags(A_27t,A_27w),V0mode),ap(ap(ap(c_2Ebool_2ECOND(bool),ap(ap(c_2Ebool_2E_2F_5C,ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),V6r1),ap(c_2Ereal_2Ereal__of__num,c_2Enum_2E0))),ap(ap(c_2Ebool_2E_2F_5C,ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),V7r2),ap(c_2Ereal_2Ereal__of__num,c_2Enum_2E0))),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),V4signP),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V3z))))),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),V4signP),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))))),ap(ap(c_2Emin_2E_3D(ty_2Ebinary__ieee_2Erounding),V0mode),c_2Ebinary__ieee_2EroundTowardNegative))),ap(ap(c_2Erealax_2Ereal__add,V6r1),V7r2)) ) ) ) ) ).

fof(lameq_f3049,axiom,
    ! [A_27w,A_27t,V0mode] :
      ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
     => ! [V4signP] :
          ( mem(V4signP,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
         => ! [V3z] :
              ( mem(V3z,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V6r1] : ap(f3049(A_27w,A_27t,V0mode,V4signP,V3z),V6r1) = f3048(A_27t,A_27w,V0mode,V4signP,V3z,V6r1) ) ) ) ).

fof(lameq_f3050,axiom,
    ! [A_27w,A_27t,V4signP] :
      ( mem(V4signP,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
     => ! [V0mode] :
          ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
         => ! [V1x] :
              ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V2y] :
                  ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V3z] :
                      ( mem(V3z,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ! [V5infP] : ap(f3050(A_27w,A_27t,V4signP,V0mode,V1x,V2y,V3z),V5infP) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Ebool_2E_5C_2F,ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),V1x)),ap(ap(c_2Ebool_2E_5C_2F,ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),V2y)),ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),V3z)))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27t,A_27w),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V1x),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V2y),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V3z),c_2Elist_2ENIL(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),V0mode),V1x),V2y),V3z)))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Ebool_2E_5C_2F,ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w),V2y))),ap(ap(c_2Ebool_2E_5C_2F,ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V2y))),ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V3z)),ap(ap(c_2Ebool_2E_2F_5C,V5infP),ap(c_2Ebool_2E_7E,ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),V4signP),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V3z)))))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),c_2Ebinary__ieee_2Einvalidop__flags),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),V0mode),V1x),V2y),V3z)))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Ebool_2E_5C_2F,ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V3z)),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V3z)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),c_2Enum_2E0)))),ap(ap(c_2Ebool_2E_2F_5C,V5infP),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),V4signP),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),c_2Enum_2E0))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),c_2Ebinary__ieee_2Eclear__flags),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Ebool_2E_5C_2F,ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V3z)),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V3z)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)))))),ap(ap(c_2Ebool_2E_2F_5C,V5infP),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),V4signP),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),c_2Ebinary__ieee_2Eclear__flags),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))),ap(ap(c_2Ebool_2ELET(ty_2Erealax_2Ereal,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Ebool_2ELET(ty_2Erealax_2Ereal,arr(ty_2Erealax_2Ereal,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))),f3049(A_27w,A_27t,V0mode,V4signP,V3z)),ap(ap(c_2Erealax_2Ereal__mul,ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),V2y)))),ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),V3z)))))) ) ) ) ) ) ).

fof(lameq_f3051,axiom,
    ! [A_27w,A_27t,V0mode] :
      ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
     => ! [V3z] :
          ( mem(V3z,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V1x] :
              ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V2y] :
                  ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V4signP] : ap(f3051(A_27w,A_27t,V0mode,V3z,V1x,V2y),V4signP) = ap(ap(c_2Ebool_2ELET(bool,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),f3050(A_27w,A_27t,V4signP,V0mode,V1x,V2y,V3z)),ap(ap(c_2Ebool_2E_5C_2F,ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V2y))) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__mul__add__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0mode] :
              ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
             => ! [V1x] :
                  ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V2y] :
                      ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ! [V3z] :
                          ( mem(V3z,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                         => ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__mul__add(A_27t,A_27w),V0mode),V1x),V2y),V3z) = ap(ap(c_2Ebool_2ELET(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),f3051(A_27w,A_27t,V0mode,V3z,V1x,V2y)),ap(ap(c_2Ewords_2Eword__xor(ty_2Eone_2Eone),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V2y))) ) ) ) ) ) ) ).

fof(lameq_f3052,axiom,
    ! [A_27w,A_27t,V0mode] :
      ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
     => ! [V4signP] :
          ( mem(V4signP,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
         => ! [V3z] :
              ( mem(V3z,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V6r1] :
                  ( mem(V6r1,ty_2Erealax_2Ereal)
                 => ! [V7r2] : ap(f3052(A_27w,A_27t,V0mode,V4signP,V3z,V6r1),V7r2) = ap(ap(ap(c_2Ebinary__ieee_2Efloat__round__with__flags(A_27t,A_27w),V0mode),ap(ap(ap(c_2Ebool_2ECOND(bool),ap(ap(c_2Ebool_2E_2F_5C,ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),V6r1),ap(c_2Ereal_2Ereal__of__num,c_2Enum_2E0))),ap(ap(c_2Ebool_2E_2F_5C,ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),V7r2),ap(c_2Ereal_2Ereal__of__num,c_2Enum_2E0))),ap(c_2Ebool_2E_7E,ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),V4signP),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V3z)))))),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),V4signP),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))))),ap(ap(c_2Emin_2E_3D(ty_2Ebinary__ieee_2Erounding),V0mode),c_2Ebinary__ieee_2EroundTowardNegative))),ap(ap(c_2Ereal_2Ereal__sub,V6r1),V7r2)) ) ) ) ) ).

fof(lameq_f3053,axiom,
    ! [A_27t,A_27w,V0mode] :
      ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
     => ! [V4signP] :
          ( mem(V4signP,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
         => ! [V3z] :
              ( mem(V3z,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V6r1] : ap(f3053(A_27t,A_27w,V0mode,V4signP,V3z),V6r1) = f3052(A_27w,A_27t,V0mode,V4signP,V3z,V6r1) ) ) ) ).

fof(lameq_f3054,axiom,
    ! [A_27w,A_27t,V4signP] :
      ( mem(V4signP,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
     => ! [V0mode] :
          ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
         => ! [V1x] :
              ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V2y] :
                  ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V3z] :
                      ( mem(V3z,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ! [V5infP] : ap(f3054(A_27w,A_27t,V4signP,V0mode,V1x,V2y,V3z),V5infP) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Ebool_2E_5C_2F,ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),V1x)),ap(ap(c_2Ebool_2E_5C_2F,ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),V2y)),ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),V3z)))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Echeck__for__signalling(A_27t,A_27w),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V1x),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V2y),ap(ap(c_2Elist_2ECONS(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),V3z),c_2Elist_2ENIL(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))))),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulSub(A_27t,A_27w),V0mode),V1x),V2y),V3z)))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Ebool_2E_5C_2F,ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w),V2y))),ap(ap(c_2Ebool_2E_5C_2F,ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V2y))),ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V3z)),ap(ap(c_2Ebool_2E_2F_5C,V5infP),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),V4signP),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V3z))))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),c_2Ebinary__ieee_2Einvalidop__flags),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),ap(ap(ap(ap(c_2Ebinary__ieee_2EFP__MulAdd(A_27t,A_27w),V0mode),V1x),V2y),V3z)))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Ebool_2E_5C_2F,ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V3z)),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V3z)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)))))),ap(ap(c_2Ebool_2E_2F_5C,V5infP),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),V4signP),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),c_2Enum_2E0))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),c_2Ebinary__ieee_2Eclear__flags),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Ebool_2E_5C_2F,ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V3z)),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V3z)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),c_2Enum_2E0)))),ap(ap(c_2Ebool_2E_2F_5C,V5infP),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),V4signP),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))))))),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),c_2Ebinary__ieee_2Eclear__flags),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))),ap(ap(c_2Ebool_2ELET(ty_2Erealax_2Ereal,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),ap(ap(c_2Ebool_2ELET(ty_2Erealax_2Ereal,arr(ty_2Erealax_2Ereal,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))),f3053(A_27t,A_27w,V0mode,V4signP,V3z)),ap(ap(c_2Erealax_2Ereal__mul,ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),V2y)))),ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),V3z)))))) ) ) ) ) ) ).

fof(lameq_f3055,axiom,
    ! [A_27w,A_27t,V0mode] :
      ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
     => ! [V3z] :
          ( mem(V3z,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V1x] :
              ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V2y] :
                  ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V4signP] : ap(f3055(A_27w,A_27t,V0mode,V3z,V1x,V2y),V4signP) = ap(ap(c_2Ebool_2ELET(bool,ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),f3054(A_27w,A_27t,V4signP,V0mode,V1x,V2y,V3z)),ap(ap(c_2Ebool_2E_5C_2F,ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V2y))) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__mul__sub__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0mode] :
              ( mem(V0mode,ty_2Ebinary__ieee_2Erounding)
             => ! [V1x] :
                  ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ! [V2y] :
                      ( mem(V2y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                     => ! [V3z] :
                          ( mem(V3z,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                         => ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__mul__sub(A_27t,A_27w),V0mode),V1x),V2y),V3z) = ap(ap(c_2Ebool_2ELET(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone),ty_2Epair_2Eprod(ty_2Ebinary__ieee_2Eflags,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))),f3055(A_27w,A_27t,V0mode,V3z,V1x,V2y)),ap(ap(c_2Ewords_2Eword__xor(ty_2Eone_2Eone),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V2y))) ) ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__compare__TY__DEF,axiom,
    ? [V0rep] :
      ( mem(V0rep,arr(ty_2Ebinary__ieee_2Efloat__compare,ty_2Enum_2Enum))
      & p(ap(ap(c_2Ebool_2ETYPE__DEFINITION(ty_2Enum_2Enum,ty_2Ebinary__ieee_2Efloat__compare),f2948),V0rep)) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__compare__BIJ,axiom,
    ( ! [V0a] :
        ( mem(V0a,ty_2Ebinary__ieee_2Efloat__compare)
       => ap(c_2Ebinary__ieee_2Enum2float__compare,ap(c_2Ebinary__ieee_2Efloat__compare2num,V0a)) = V0a )
    & ! [V1r] :
        ( mem(V1r,ty_2Enum_2Enum)
       => ( p(ap(f2949,V1r))
        <=> ap(c_2Ebinary__ieee_2Efloat__compare2num,ap(c_2Ebinary__ieee_2Enum2float__compare,V1r)) = V1r ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Enum2float__compare__float__compare2num,axiom,
    ! [V0a] :
      ( mem(V0a,ty_2Ebinary__ieee_2Efloat__compare)
     => ap(c_2Ebinary__ieee_2Enum2float__compare,ap(c_2Ebinary__ieee_2Efloat__compare2num,V0a)) = V0a ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__compare2num__num2float__compare,axiom,
    ! [V0r] :
      ( mem(V0r,ty_2Enum_2Enum)
     => ( p(ap(ap(c_2Eprim__rec_2E_3C,V0r),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)))))
      <=> ap(c_2Ebinary__ieee_2Efloat__compare2num,ap(c_2Ebinary__ieee_2Enum2float__compare,V0r)) = V0r ) ) ).

fof(conj_thm_2Ebinary__ieee_2Enum2float__compare__11,axiom,
    ! [V0r] :
      ( mem(V0r,ty_2Enum_2Enum)
     => ! [V1r_27] :
          ( mem(V1r_27,ty_2Enum_2Enum)
         => ( p(ap(ap(c_2Eprim__rec_2E_3C,V0r),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)))))
           => ( p(ap(ap(c_2Eprim__rec_2E_3C,V1r_27),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)))))
             => ( ap(c_2Ebinary__ieee_2Enum2float__compare,V0r) = ap(c_2Ebinary__ieee_2Enum2float__compare,V1r_27)
              <=> V0r = V1r_27 ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__compare2num__11,axiom,
    ! [V0a] :
      ( mem(V0a,ty_2Ebinary__ieee_2Efloat__compare)
     => ! [V1a_27] :
          ( mem(V1a_27,ty_2Ebinary__ieee_2Efloat__compare)
         => ( ap(c_2Ebinary__ieee_2Efloat__compare2num,V0a) = ap(c_2Ebinary__ieee_2Efloat__compare2num,V1a_27)
          <=> V0a = V1a_27 ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Enum2float__compare__ONTO,axiom,
    ! [V0a] :
      ( mem(V0a,ty_2Ebinary__ieee_2Efloat__compare)
     => ? [V1r] :
          ( mem(V1r,ty_2Enum_2Enum)
          & V0a = ap(c_2Ebinary__ieee_2Enum2float__compare,V1r)
          & p(ap(ap(c_2Eprim__rec_2E_3C,V1r),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))))) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__compare2num__ONTO,axiom,
    ! [V0r] :
      ( mem(V0r,ty_2Enum_2Enum)
     => ( p(ap(ap(c_2Eprim__rec_2E_3C,V0r),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)))))
      <=> ? [V1a] :
            ( mem(V1a,ty_2Ebinary__ieee_2Efloat__compare)
            & V0r = ap(c_2Ebinary__ieee_2Efloat__compare2num,V1a) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Enum2float__compare__thm,axiom,
    ( ap(c_2Ebinary__ieee_2Enum2float__compare,c_2Enum_2E0) = c_2Ebinary__ieee_2ELT
    & ap(c_2Ebinary__ieee_2Enum2float__compare,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))) = c_2Ebinary__ieee_2EEQ
    & ap(c_2Ebinary__ieee_2Enum2float__compare,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO))) = c_2Ebinary__ieee_2EGT
    & ap(c_2Ebinary__ieee_2Enum2float__compare,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)))) = c_2Ebinary__ieee_2EUN ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__compare2num__thm,axiom,
    ( ap(c_2Ebinary__ieee_2Efloat__compare2num,c_2Ebinary__ieee_2ELT) = c_2Enum_2E0
    & ap(c_2Ebinary__ieee_2Efloat__compare2num,c_2Ebinary__ieee_2EEQ) = ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))
    & ap(c_2Ebinary__ieee_2Efloat__compare2num,c_2Ebinary__ieee_2EGT) = ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO))
    & ap(c_2Ebinary__ieee_2Efloat__compare2num,c_2Ebinary__ieee_2EUN) = ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__compare__EQ__float__compare,axiom,
    ! [V0a] :
      ( mem(V0a,ty_2Ebinary__ieee_2Efloat__compare)
     => ! [V1a_27] :
          ( mem(V1a_27,ty_2Ebinary__ieee_2Efloat__compare)
         => ( V0a = V1a_27
          <=> ap(c_2Ebinary__ieee_2Efloat__compare2num,V0a) = ap(c_2Ebinary__ieee_2Efloat__compare2num,V1a_27) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__compare__size__def,axiom,
    ! [V0x] :
      ( mem(V0x,ty_2Ebinary__ieee_2Efloat__compare)
     => ap(c_2Ebinary__ieee_2Efloat__compare__size,V0x) = c_2Enum_2E0 ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__compare__CASE,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [V0x] :
          ( mem(V0x,ty_2Ebinary__ieee_2Efloat__compare)
         => ! [V1v0] :
              ( mem(V1v0,A_27a)
             => ! [V2v1] :
                  ( mem(V2v1,A_27a)
                 => ! [V3v2] :
                      ( mem(V3v2,A_27a)
                     => ! [V4v3] :
                          ( mem(V4v3,A_27a)
                         => ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__compare__CASE(A_27a),V0x),V1v0),V2v1),V3v2),V4v3) = ap(f2950(A_27a,V2v1,V3v2,V4v3,V1v0),ap(c_2Ebinary__ieee_2Efloat__compare2num,V0x)) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__compare__case__def,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ( ! [V0v0] :
            ( mem(V0v0,A_27a)
           => ! [V1v1] :
                ( mem(V1v1,A_27a)
               => ! [V2v2] :
                    ( mem(V2v2,A_27a)
                   => ! [V3v3] :
                        ( mem(V3v3,A_27a)
                       => ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__compare__CASE(A_27a),c_2Ebinary__ieee_2ELT),V0v0),V1v1),V2v2),V3v3) = V0v0 ) ) ) )
        & ! [V4v0] :
            ( mem(V4v0,A_27a)
           => ! [V5v1] :
                ( mem(V5v1,A_27a)
               => ! [V6v2] :
                    ( mem(V6v2,A_27a)
                   => ! [V7v3] :
                        ( mem(V7v3,A_27a)
                       => ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__compare__CASE(A_27a),c_2Ebinary__ieee_2EEQ),V4v0),V5v1),V6v2),V7v3) = V5v1 ) ) ) )
        & ! [V8v0] :
            ( mem(V8v0,A_27a)
           => ! [V9v1] :
                ( mem(V9v1,A_27a)
               => ! [V10v2] :
                    ( mem(V10v2,A_27a)
                   => ! [V11v3] :
                        ( mem(V11v3,A_27a)
                       => ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__compare__CASE(A_27a),c_2Ebinary__ieee_2EGT),V8v0),V9v1),V10v2),V11v3) = V10v2 ) ) ) )
        & ! [V12v0] :
            ( mem(V12v0,A_27a)
           => ! [V13v1] :
                ( mem(V13v1,A_27a)
               => ! [V14v2] :
                    ( mem(V14v2,A_27a)
                   => ! [V15v3] :
                        ( mem(V15v3,A_27a)
                       => ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__compare__CASE(A_27a),c_2Ebinary__ieee_2EUN),V12v0),V13v1),V14v2),V15v3) = V15v3 ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Edatatype__float__compare,axiom,
    ! [V0float__compare] :
      ( mem(V0float__compare,arr(ty_2Ebinary__ieee_2Efloat__compare,arr(ty_2Ebinary__ieee_2Efloat__compare,arr(ty_2Ebinary__ieee_2Efloat__compare,arr(ty_2Ebinary__ieee_2Efloat__compare,bool)))))
     => p(ap(c_2Ebool_2EDATATYPE(bool),ap(ap(ap(ap(V0float__compare,c_2Ebinary__ieee_2ELT),c_2Ebinary__ieee_2EEQ),c_2Ebinary__ieee_2EGT),c_2Ebinary__ieee_2EUN))) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__compare__distinct,axiom,
    ( c_2Ebinary__ieee_2ELT != c_2Ebinary__ieee_2EEQ
    & c_2Ebinary__ieee_2ELT != c_2Ebinary__ieee_2EGT
    & c_2Ebinary__ieee_2ELT != c_2Ebinary__ieee_2EUN
    & c_2Ebinary__ieee_2EEQ != c_2Ebinary__ieee_2EGT
    & c_2Ebinary__ieee_2EEQ != c_2Ebinary__ieee_2EUN
    & c_2Ebinary__ieee_2EGT != c_2Ebinary__ieee_2EUN ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__compare__nchotomy,axiom,
    ! [V0a] :
      ( mem(V0a,ty_2Ebinary__ieee_2Efloat__compare)
     => ( V0a = c_2Ebinary__ieee_2ELT
        | V0a = c_2Ebinary__ieee_2EEQ
        | V0a = c_2Ebinary__ieee_2EGT
        | V0a = c_2Ebinary__ieee_2EUN ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__compare__Axiom,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [V0x0] :
          ( mem(V0x0,A_27a)
         => ! [V1x1] :
              ( mem(V1x1,A_27a)
             => ! [V2x2] :
                  ( mem(V2x2,A_27a)
                 => ! [V3x3] :
                      ( mem(V3x3,A_27a)
                     => ? [V4f] :
                          ( mem(V4f,arr(ty_2Ebinary__ieee_2Efloat__compare,A_27a))
                          & ap(V4f,c_2Ebinary__ieee_2ELT) = V0x0
                          & ap(V4f,c_2Ebinary__ieee_2EEQ) = V1x1
                          & ap(V4f,c_2Ebinary__ieee_2EGT) = V2x2
                          & ap(V4f,c_2Ebinary__ieee_2EUN) = V3x3 ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__compare__induction,axiom,
    ! [V0P] :
      ( mem(V0P,arr(ty_2Ebinary__ieee_2Efloat__compare,bool))
     => ( ( p(ap(V0P,c_2Ebinary__ieee_2EEQ))
          & p(ap(V0P,c_2Ebinary__ieee_2EGT))
          & p(ap(V0P,c_2Ebinary__ieee_2ELT))
          & p(ap(V0P,c_2Ebinary__ieee_2EUN)) )
       => ! [V1a] :
            ( mem(V1a,ty_2Ebinary__ieee_2Efloat__compare)
           => p(ap(V0P,V1a)) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__compare__case__cong,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [V0v0_27] :
          ( mem(V0v0_27,A_27a)
         => ! [V1v1_27] :
              ( mem(V1v1_27,A_27a)
             => ! [V2v2_27] :
                  ( mem(V2v2_27,A_27a)
                 => ! [V3v3_27] :
                      ( mem(V3v3_27,A_27a)
                     => ! [V4M] :
                          ( mem(V4M,ty_2Ebinary__ieee_2Efloat__compare)
                         => ! [V5M_27] :
                              ( mem(V5M_27,ty_2Ebinary__ieee_2Efloat__compare)
                             => ! [V6v0] :
                                  ( mem(V6v0,A_27a)
                                 => ! [V7v1] :
                                      ( mem(V7v1,A_27a)
                                     => ! [V8v2] :
                                          ( mem(V8v2,A_27a)
                                         => ! [V9v3] :
                                              ( mem(V9v3,A_27a)
                                             => ( ( V4M = V5M_27
                                                  & ( V5M_27 = c_2Ebinary__ieee_2ELT
                                                   => V6v0 = V0v0_27 )
                                                  & ( V5M_27 = c_2Ebinary__ieee_2EEQ
                                                   => V7v1 = V1v1_27 )
                                                  & ( V5M_27 = c_2Ebinary__ieee_2EGT
                                                   => V8v2 = V2v2_27 )
                                                  & ( V5M_27 = c_2Ebinary__ieee_2EUN
                                                   => V9v3 = V3v3_27 ) )
                                               => ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__compare__CASE(A_27a),V4M),V6v0),V7v1),V8v2),V9v3) = ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__compare__CASE(A_27a),V5M_27),V0v0_27),V1v1_27),V2v2_27),V3v3_27) ) ) ) ) ) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__compare__case__eq,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [V0x] :
          ( mem(V0x,ty_2Ebinary__ieee_2Efloat__compare)
         => ! [V1v0] :
              ( mem(V1v0,A_27a)
             => ! [V2v1] :
                  ( mem(V2v1,A_27a)
                 => ! [V3v2] :
                      ( mem(V3v2,A_27a)
                     => ! [V4v3] :
                          ( mem(V4v3,A_27a)
                         => ! [V5v] :
                              ( mem(V5v,A_27a)
                             => ( ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__compare__CASE(A_27a),V0x),V1v0),V2v1),V3v2),V4v3) = V5v
                              <=> ( ( V0x = c_2Ebinary__ieee_2ELT
                                    & V1v0 = V5v )
                                  | ( V0x = c_2Ebinary__ieee_2EEQ
                                    & V2v1 = V5v )
                                  | ( V0x = c_2Ebinary__ieee_2EGT
                                    & V3v2 = V5v )
                                  | ( V0x = c_2Ebinary__ieee_2EUN
                                    & V4v3 = V5v ) ) ) ) ) ) ) ) ) ) ).

fof(lameq_f3056,axiom,
    ! [V4r1] :
      ( mem(V4r1,ty_2Erealax_2Ereal)
     => ! [V5r2] : ap(f3056(V4r1),V5r2) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat__compare),ap(ap(c_2Erealax_2Ereal__lt,V4r1),V5r2)),c_2Ebinary__ieee_2ELT),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat__compare),ap(ap(c_2Emin_2E_3D(ty_2Erealax_2Ereal),V4r1),V5r2)),c_2Ebinary__ieee_2EEQ),c_2Ebinary__ieee_2EGT)) ) ).

fof(lameq_f3057,axiom,
    ! [A_27t,A_27w,V1y] :
      ( mem(V1y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V3v1] :
          ( mem(V3v1,ty_2Ebinary__ieee_2Efloat__value)
         => ! [V4r1] : ap(f3057(A_27t,A_27w,V1y,V3v1),V4r1) = ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Ebinary__ieee_2Efloat__compare),V3v1),f3056(V4r1)),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat__compare),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1y)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))))),c_2Ebinary__ieee_2EGT),c_2Ebinary__ieee_2ELT)),c_2Ebinary__ieee_2EUN) ) ) ).

fof(lameq_f3058,axiom,
    ! [A_27t,A_27w,V1y] :
      ( mem(V1y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V0x] :
          ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V2v] :
              ( mem(V2v,ty_2Ebinary__ieee_2Efloat__value)
             => ! [V3v1] : ap(f3058(A_27t,A_27w,V1y,V0x,V2v),V3v1) = ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Ebinary__ieee_2Efloat__compare),V2v),f3057(A_27t,A_27w,V1y,V3v1)),ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__value__CASE(ty_2Ebinary__ieee_2Efloat__compare),V3v1),k(ty_2Erealax_2Ereal,ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat__compare),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V0x)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))))),c_2Ebinary__ieee_2ELT),c_2Ebinary__ieee_2EGT))),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat__compare),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V0x)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1y))),c_2Ebinary__ieee_2EEQ),ap(ap(ap(c_2Ebool_2ECOND(ty_2Ebinary__ieee_2Efloat__compare),ap(ap(c_2Emin_2E_3D(ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone)),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V0x)),ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))))),c_2Ebinary__ieee_2ELT),c_2Ebinary__ieee_2EGT))),c_2Ebinary__ieee_2EUN)),c_2Ebinary__ieee_2EUN) ) ) ) ).

fof(lameq_f3059,axiom,
    ! [A_27w,A_27t,V1y] :
      ( mem(V1y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
     => ! [V0x] :
          ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
         => ! [V2v] : ap(f3059(A_27w,A_27t,V1y,V0x),V2v) = f3058(A_27t,A_27w,V1y,V0x,V2v) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__compare__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0x] :
              ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V1y] :
                  ( mem(V1y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ap(ap(c_2Ebinary__ieee_2Efloat__compare(A_27t,A_27w),V0x),V1y) = ap(ap(c_2Epair_2Epair__CASE(ty_2Ebinary__ieee_2Efloat__compare,ty_2Ebinary__ieee_2Efloat__value,ty_2Ebinary__ieee_2Efloat__value),ap(ap(c_2Epair_2E_2C(ty_2Ebinary__ieee_2Efloat__value,ty_2Ebinary__ieee_2Efloat__value),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V0x)),ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),V1y))),f3059(A_27w,A_27t,V1y,V0x)) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__less__than__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0x] :
              ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V1y] :
                  ( mem(V1y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ( p(ap(ap(c_2Ebinary__ieee_2Efloat__less__than(A_27t,A_27w),V0x),V1y))
                  <=> ap(ap(c_2Ebinary__ieee_2Efloat__compare(A_27t,A_27w),V0x),V1y) = c_2Ebinary__ieee_2ELT ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__less__equal__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0x] :
              ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V1y] :
                  ( mem(V1y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ( p(ap(ap(c_2Ebinary__ieee_2Efloat__less__equal(A_27t,A_27w),V0x),V1y))
                  <=> p(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__compare__CASE(bool),ap(ap(c_2Ebinary__ieee_2Efloat__compare(A_27t,A_27w),V0x),V1y)),c_2Ebool_2ET),c_2Ebool_2ET),c_2Ebool_2EF),c_2Ebool_2EF)) ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__greater__than__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0x] :
              ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V1y] :
                  ( mem(V1y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ( p(ap(ap(c_2Ebinary__ieee_2Efloat__greater__than(A_27t,A_27w),V0x),V1y))
                  <=> ap(ap(c_2Ebinary__ieee_2Efloat__compare(A_27t,A_27w),V0x),V1y) = c_2Ebinary__ieee_2EGT ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__greater__equal__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0x] :
              ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V1y] :
                  ( mem(V1y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ( p(ap(ap(c_2Ebinary__ieee_2Efloat__greater__equal(A_27t,A_27w),V0x),V1y))
                  <=> p(ap(ap(ap(ap(ap(c_2Ebinary__ieee_2Efloat__compare__CASE(bool),ap(ap(c_2Ebinary__ieee_2Efloat__compare(A_27t,A_27w),V0x),V1y)),c_2Ebool_2EF),c_2Ebool_2ET),c_2Ebool_2ET),c_2Ebool_2EF)) ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Efloat__equal__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0x] :
              ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V1y] :
                  ( mem(V1y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ( p(ap(ap(c_2Ebinary__ieee_2Efloat__equal(A_27t,A_27w),V0x),V1y))
                  <=> ap(ap(c_2Ebinary__ieee_2Efloat__compare(A_27t,A_27w),V0x),V1y) = c_2Ebinary__ieee_2EEQ ) ) ) ) ) ).

fof(ax_thm_2Ebinary__ieee_2Eexponent__boundary__def,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0y] :
              ( mem(V0y,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ! [V1x] :
                  ( mem(V1x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
                 => ( p(ap(ap(c_2Ebinary__ieee_2Eexponent__boundary(A_27t,A_27w),V0y),V1x))
                  <=> ( ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V1x) = ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),V0y)
                      & ap(c_2Ewords_2Ew2n(A_27w),ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),V1x)) = ap(ap(c_2Earithmetic_2E_2B,ap(c_2Ewords_2Ew2n(A_27w),ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),V0y))),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)))
                      & ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),V1x) != ap(c_2Ewords_2En2w(A_27w),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)))
                      & ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),V0y) = ap(c_2Ewords_2Eword__2comp(A_27t),ap(c_2Ewords_2En2w(A_27t),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))))
                      & ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),V1x) = ap(c_2Ewords_2En2w(A_27t),c_2Enum_2E0) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Ezero__lt__twopow,axiom,
    ! [V0n] :
      ( mem(V0n,ty_2Enum_2Enum)
     => p(ap(ap(c_2Erealax_2Ereal__lt,ap(c_2Ereal_2Ereal__of__num,c_2Enum_2E0)),ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),V0n))) ) ).

fof(conj_thm_2Ebinary__ieee_2Ezero__le__twopow,axiom,
    ! [V0n] :
      ( mem(V0n,ty_2Enum_2Enum)
     => p(ap(ap(c_2Ereal_2Ereal__lte,ap(c_2Ereal_2Ereal__of__num,c_2Enum_2E0)),ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),V0n))) ) ).

fof(conj_thm_2Ebinary__ieee_2Ezero__neq__twopow,axiom,
    ! [V0n] :
      ( mem(V0n,ty_2Enum_2Enum)
     => ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),V0n) != ap(c_2Ereal_2Ereal__of__num,c_2Enum_2E0) ) ).

fof(conj_thm_2Ebinary__ieee_2Ezero__le__pos__div__twopow,axiom,
    ! [V0m] :
      ( mem(V0m,ty_2Enum_2Enum)
     => ! [V1n] :
          ( mem(V1n,ty_2Enum_2Enum)
         => p(ap(ap(c_2Ereal_2Ereal__lte,ap(c_2Ereal_2Ereal__of__num,c_2Enum_2E0)),ap(ap(c_2Ereal_2E_2F,ap(c_2Ereal_2Ereal__of__num,V0m)),ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),V1n)))) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Ediv__eq0,axiom,
    ! [V0a] :
      ( mem(V0a,ty_2Erealax_2Ereal)
     => ! [V1b] :
          ( mem(V1b,ty_2Erealax_2Ereal)
         => ( p(ap(ap(c_2Erealax_2Ereal__lt,ap(c_2Ereal_2Ereal__of__num,c_2Enum_2E0)),V1b))
           => ( ap(ap(c_2Ereal_2E_2F,V0a),V1b) = ap(c_2Ereal_2Ereal__of__num,c_2Enum_2E0)
            <=> V0a = ap(c_2Ereal_2Ereal__of__num,c_2Enum_2E0) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Eexp__ge2,axiom,
    ! [V0b] :
      ( mem(V0b,ty_2Enum_2Enum)
     => ( p(ap(ap(c_2Earithmetic_2E_3C_3D,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO))),ap(ap(c_2Earithmetic_2EEXP,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO))),V0b)))
      <=> p(ap(ap(c_2Earithmetic_2E_3C_3D,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))),V0b)) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Eexp__gt2,axiom,
    ! [V0b] :
      ( mem(V0b,ty_2Enum_2Enum)
     => ( p(ap(ap(c_2Eprim__rec_2E_3C,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO))),ap(ap(c_2Earithmetic_2EEXP,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO))),V0b)))
      <=> p(ap(ap(c_2Eprim__rec_2E_3C,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))),V0b)) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Ele2,axiom,
    ! [V0n] :
      ( mem(V0n,ty_2Erealax_2Ereal)
     => ! [V1m] :
          ( mem(V1m,ty_2Erealax_2Ereal)
         => ( ( p(ap(ap(c_2Ereal_2Ereal__lte,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),V0n))
              & p(ap(ap(c_2Ereal_2Ereal__lte,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),V1m)) )
           => p(ap(ap(c_2Ereal_2Ereal__lte,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),ap(ap(c_2Erealax_2Ereal__mul,V0n),V1m))) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__components,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27b] :
          ( ne(A_27b)
         => ! [A_27c] :
              ( ne(A_27c)
             => ! [A_27d] :
                  ( ne(A_27d)
                 => ! [A_27e] :
                      ( ne(A_27e)
                     => ! [A_27f] :
                          ( ne(A_27f)
                         => ! [A_27g] :
                              ( ne(A_27g)
                             => ! [A_27h] :
                                  ( ne(A_27h)
                                 => ! [A_27i] :
                                      ( ne(A_27i)
                                     => ! [A_27j] :
                                          ( ne(A_27j)
                                         => ! [A_27t] :
                                              ( ne(A_27t)
                                             => ! [A_27w] :
                                                  ( ne(A_27w)
                                                 => ( ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ewords_2En2w(ty_2Eone_2Eone),c_2Enum_2E0)
                                                    & ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = c_2Ewords_2Eword__T(A_27w)
                                                    & ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ewords_2En2w(A_27t),c_2Enum_2E0)
                                                    & ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)))
                                                    & ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = c_2Ewords_2Eword__T(A_27w)
                                                    & ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ewords_2En2w(A_27t),c_2Enum_2E0)
                                                    & ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ewords_2En2w(ty_2Eone_2Eone),c_2Enum_2E0)
                                                    & ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ewords_2En2w(A_27w),c_2Enum_2E0)
                                                    & ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ewords_2En2w(A_27t),c_2Enum_2E0)
                                                    & ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)))
                                                    & ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ewords_2En2w(A_27w),c_2Enum_2E0)
                                                    & ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ewords_2En2w(A_27t),c_2Enum_2E0)
                                                    & ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ewords_2En2w(ty_2Eone_2Eone),c_2Enum_2E0)
                                                    & ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ewords_2En2w(A_27w),c_2Enum_2E0)
                                                    & ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ewords_2En2w(A_27t),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)))
                                                    & ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)))
                                                    & ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ewords_2En2w(A_27w),c_2Enum_2E0)
                                                    & ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ewords_2En2w(A_27t),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)))
                                                    & ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ewords_2En2w(ty_2Eone_2Eone),c_2Enum_2E0)
                                                    & ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(ap(c_2Ewords_2Eword__sub(A_27w),c_2Ewords_2Eword__T(A_27w)),ap(c_2Ewords_2En2w(A_27w),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))))
                                                    & ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = c_2Ewords_2Eword__T(A_27t)
                                                    & ap(c_2Ebinary__ieee_2Efloat__Sign(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ewords_2En2w(ty_2Eone_2Eone),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)))
                                                    & ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(ap(c_2Ewords_2Eword__sub(A_27w),c_2Ewords_2Eword__T(A_27w)),ap(c_2Ewords_2En2w(A_27w),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))))
                                                    & ap(c_2Ebinary__ieee_2Efloat__Significand(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = c_2Ewords_2Eword__T(A_27t)
                                                    & ! [V0fp__op] :
                                                        ( mem(V0fp__op,ty_2Ebinary__ieee_2Efp__op(A_27a,A_27b))
                                                       => ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27a,A_27b),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27a,A_27b),V0fp__op)) = c_2Ewords_2Eword__T(A_27b) )
                                                    & ! [V1fp__op] :
                                                        ( mem(V1fp__op,ty_2Ebinary__ieee_2Efp__op(A_27c,A_27d))
                                                       => ap(c_2Ebinary__ieee_2Efloat__Significand(A_27c,A_27d),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27c,A_27d),V1fp__op)) != ap(c_2Ewords_2En2w(A_27c),c_2Enum_2E0) )
                                                    & ! [V2x] :
                                                        ( mem(V2x,ty_2Ebinary__ieee_2Efloat(A_27e,A_27f))
                                                       => ap(c_2Ebinary__ieee_2Efloat__Sign(A_27e,A_27f),ap(c_2Ebinary__ieee_2Efloat__negate(A_27e,A_27f),V2x)) = ap(c_2Ewords_2Eword__1comp(ty_2Eone_2Eone),ap(c_2Ebinary__ieee_2Efloat__Sign(A_27e,A_27f),V2x)) )
                                                    & ! [V3x] :
                                                        ( mem(V3x,ty_2Ebinary__ieee_2Efloat(A_27g,A_27h))
                                                       => ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27g,A_27h),ap(c_2Ebinary__ieee_2Efloat__negate(A_27g,A_27h),V3x)) = ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27g,A_27h),V3x) )
                                                    & ! [V4x] :
                                                        ( mem(V4x,ty_2Ebinary__ieee_2Efloat(A_27i,A_27j))
                                                       => ap(c_2Ebinary__ieee_2Efloat__Significand(A_27i,A_27j),ap(c_2Ebinary__ieee_2Efloat__negate(A_27i,A_27j),V4x)) = ap(c_2Ebinary__ieee_2Efloat__Significand(A_27i,A_27j),V4x) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__distinct,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27b] :
          ( ne(A_27b)
         => ! [A_27t] :
              ( ne(A_27t)
             => ! [A_27w] :
                  ( ne(A_27w)
                 => ( ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))
                    & ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))
                    & ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))
                    & ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))
                    & ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))
                    & ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))
                    & ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))
                    & ! [V0fp__op] :
                        ( mem(V0fp__op,ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))
                       => ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),V0fp__op) )
                    & ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))
                    & ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))
                    & ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))
                    & ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))
                    & ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))
                    & ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))
                    & ! [V1fp__op] :
                        ( mem(V1fp__op,ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))
                       => ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),V1fp__op) )
                    & ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))
                    & ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))
                    & ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))
                    & ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))
                    & ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))
                    & ! [V2fp__op] :
                        ( mem(V2fp__op,ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))
                       => ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),V2fp__op) )
                    & ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))
                    & ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))
                    & ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))
                    & ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))
                    & ! [V3fp__op] :
                        ( mem(V3fp__op,ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))
                       => ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),V3fp__op) )
                    & ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))
                    & ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))
                    & ! [V4fp__op] :
                        ( mem(V4fp__op,ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))
                       => ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),V4fp__op) )
                    & ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))
                    & ! [V5fp__op] :
                        ( mem(V5fp__op,ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))
                       => ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),V5fp__op) )
                    & ! [V6fp__op] :
                        ( mem(V6fp__op,ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))
                       => ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),V6fp__op) )
                    & ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))
                    & ! [V7fp__op] :
                        ( mem(V7fp__op,ty_2Ebinary__ieee_2Efp__op(A_27t,A_27w))
                       => ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) != ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27t,A_27w),V7fp__op) )
                    & ! [V8x] :
                        ( mem(V8x,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b))
                       => ap(c_2Ebinary__ieee_2Efloat__negate(A_27a,A_27b),V8x) != V8x ) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__values,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27b] :
          ( ne(A_27b)
         => ! [A_27t] :
              ( ne(A_27t)
             => ! [A_27w] :
                  ( ne(A_27w)
                 => ( ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = c_2Ebinary__ieee_2EInfinity
                    & ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = c_2Ebinary__ieee_2EInfinity
                    & ! [V0fp__op] :
                        ( mem(V0fp__op,ty_2Ebinary__ieee_2Efp__op(A_27a,A_27b))
                       => ap(c_2Ebinary__ieee_2Efloat__value(A_27a,A_27b),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27a,A_27b),V0fp__op)) = c_2Ebinary__ieee_2ENaN )
                    & ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ebinary__ieee_2EFloat,ap(c_2Ereal_2Ereal__of__num,c_2Enum_2E0))
                    & ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ebinary__ieee_2EFloat,ap(c_2Ereal_2Ereal__of__num,c_2Enum_2E0))
                    & ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ebinary__ieee_2EFloat,ap(ap(c_2Ereal_2E_2F,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),ap(ap(c_2Earithmetic_2E_2B,ap(c_2Ewords_2EINT__MAX(A_27w),c_2Ebool_2Ethe__value(A_27w))),ap(c_2Efcp_2Edimindex(A_27t),c_2Ebool_2Ethe__value(A_27t))))))
                    & ap(c_2Ebinary__ieee_2Efloat__value(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ebinary__ieee_2EFloat,ap(ap(c_2Ereal_2E_2F,ap(c_2Erealax_2Ereal__neg,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO))))),ap(ap(c_2Ereal_2Epow,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,c_2Earithmetic_2EZERO)))),ap(ap(c_2Earithmetic_2E_2B,ap(c_2Ewords_2EINT__MAX(A_27w),c_2Ebool_2Ethe__value(A_27w))),ap(c_2Efcp_2Edimindex(A_27t),c_2Ebool_2Ethe__value(A_27t)))))) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Ezero__to__real,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ( ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ereal_2Ereal__of__num,c_2Enum_2E0)
            & ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ereal_2Ereal__of__num,c_2Enum_2E0) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Esign__not__zero,axiom,
    ! [V0s] :
      ( mem(V0s,ty_2Efcp_2Ecart(bool,ty_2Eone_2Eone))
     => ap(ap(c_2Ereal_2Epow,ap(c_2Erealax_2Ereal__neg,ap(c_2Ereal_2Ereal__of__num,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))))),ap(c_2Ewords_2Ew2n(ty_2Eone_2Eone),V0s)) != ap(c_2Ereal_2Ereal__of__num,c_2Enum_2E0) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__sets,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ( c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w) = ap(ap(c_2Epred__set_2EINSERT(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(c_2Epred__set_2EINSERT(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),c_2Epred__set_2EEMPTY(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))))
            & c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w) = ap(ap(c_2Epred__set_2EINSERT(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),ap(ap(c_2Epred__set_2EINSERT(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))),c_2Epred__set_2EEMPTY(ty_2Ebinary__ieee_2Efloat(A_27t,A_27w)))) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Einfinity__properties,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ( ~ p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__integral(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__integral(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Ezero__properties,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ( p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & p(ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & p(ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & p(ap(c_2Ebinary__ieee_2Efloat__is__integral(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & p(ap(c_2Ebinary__ieee_2Efloat__is__integral(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__zero(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Esome__nan__properties,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27b] :
          ( ne(A_27b)
         => ! [V0fp__op] :
              ( mem(V0fp__op,ty_2Ebinary__ieee_2Efp__op(A_27a,A_27b))
             => ( ~ p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27a,A_27b),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27a,A_27b),V0fp__op)))
                & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27a,A_27b),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27a,A_27b),V0fp__op)))
                & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__integral(A_27a,A_27b),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27a,A_27b),V0fp__op)))
                & p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27a,A_27b),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27a,A_27b),V0fp__op)))
                & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__signalling(A_27a,A_27b),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27a,A_27b),V0fp__op)))
                & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27a,A_27b),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27a,A_27b),V0fp__op)))
                & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27a,A_27b),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27a,A_27b),V0fp__op)))
                & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27a,A_27b),ap(c_2Ebinary__ieee_2Efloat__some__qnan(A_27a,A_27b),V0fp__op))) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Emin__properties,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ( ~ p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & p(ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & ( p(ap(c_2Ebinary__ieee_2Efloat__is__integral(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            <=> ( ap(c_2Efcp_2Edimindex(A_27w),c_2Ebool_2Ethe__value(A_27w)) = ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))
                & ap(c_2Efcp_2Edimindex(A_27t),c_2Ebool_2Ethe__value(A_27t)) = ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)) ) )
            & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & p(ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & ( p(ap(c_2Ebinary__ieee_2Efloat__is__integral(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            <=> ( ap(c_2Efcp_2Edimindex(A_27w),c_2Ebool_2Ethe__value(A_27w)) = ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO))
                & ap(c_2Efcp_2Edimindex(A_27t),c_2Ebool_2Ethe__value(A_27t)) = ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)) ) )
            & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__minus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Etop__properties,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ( ~ p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & p(ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & ( p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            <=> ap(c_2Efcp_2Edimindex(A_27w),c_2Ebool_2Ethe__value(A_27w)) != ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)) )
            & ( p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            <=> ap(c_2Efcp_2Edimindex(A_27w),c_2Ebool_2Ethe__value(A_27w)) = ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)) )
            & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__top(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Ebottom__properties,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ( ~ p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & p(ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            & ( p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            <=> ap(c_2Efcp_2Edimindex(A_27w),c_2Ebool_2Ethe__value(A_27w)) != ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)) )
            & ( p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))))
            <=> ap(c_2Efcp_2Edimindex(A_27w),c_2Ebool_2Ethe__value(A_27w)) = ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,c_2Earithmetic_2EZERO)) )
            & ~ p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__bottom(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__is__zero,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27b] :
          ( ne(A_27b)
         => ! [V0x] :
              ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b))
             => ( p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27a,A_27b),V0x))
              <=> ( ap(c_2Ebinary__ieee_2Efloat__Exponent(A_27a,A_27b),V0x) = ap(c_2Ewords_2En2w(A_27b),c_2Enum_2E0)
                  & ap(c_2Ebinary__ieee_2Efloat__Significand(A_27a,A_27b),V0x) = ap(c_2Ewords_2En2w(A_27a),c_2Enum_2E0) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__is__finite,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27b] :
          ( ne(A_27b)
         => ! [V0x] :
              ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b))
             => ( p(ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27a,A_27b),V0x))
              <=> ( p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27a,A_27b),V0x))
                  | p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27a,A_27b),V0x))
                  | p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27a,A_27b),V0x)) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__cases__finite,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27b] :
          ( ne(A_27b)
         => ! [V0x] :
              ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b))
             => ( p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27a,A_27b),V0x))
                | p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27a,A_27b),V0x))
                | p(ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27a,A_27b),V0x)) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__distinct__finite,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27b] :
          ( ne(A_27b)
         => ! [V0x] :
              ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b))
             => ( ~ ( p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27a,A_27b),V0x))
                    & p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27a,A_27b),V0x)) )
                & ~ ( p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27a,A_27b),V0x))
                    & p(ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27a,A_27b),V0x)) )
                & ~ ( p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27a,A_27b),V0x))
                    & p(ap(c_2Ebinary__ieee_2Efloat__is__finite(A_27a,A_27b),V0x)) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__cases,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27b] :
          ( ne(A_27b)
         => ! [V0x] :
              ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b))
             => ( p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27a,A_27b),V0x))
                | p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27a,A_27b),V0x))
                | p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27a,A_27b),V0x))
                | p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27a,A_27b),V0x))
                | p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27a,A_27b),V0x)) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__is__distinct,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27b] :
          ( ne(A_27b)
         => ! [V0x] :
              ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b))
             => ( ~ ( p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27a,A_27b),V0x))
                    & p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27a,A_27b),V0x)) )
                & ~ ( p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27a,A_27b),V0x))
                    & p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27a,A_27b),V0x)) )
                & ~ ( p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27a,A_27b),V0x))
                    & p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27a,A_27b),V0x)) )
                & ~ ( p(ap(c_2Ebinary__ieee_2Efloat__is__nan(A_27a,A_27b),V0x))
                    & p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27a,A_27b),V0x)) )
                & ~ ( p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27a,A_27b),V0x))
                    & p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27a,A_27b),V0x)) )
                & ~ ( p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27a,A_27b),V0x))
                    & p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27a,A_27b),V0x)) )
                & ~ ( p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27a,A_27b),V0x))
                    & p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27a,A_27b),V0x)) )
                & ~ ( p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27a,A_27b),V0x))
                    & p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27a,A_27b),V0x)) )
                & ~ ( p(ap(c_2Ebinary__ieee_2Efloat__is__normal(A_27a,A_27b),V0x))
                    & p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27a,A_27b),V0x)) )
                & ~ ( p(ap(c_2Ebinary__ieee_2Efloat__is__subnormal(A_27a,A_27b),V0x))
                    & p(ap(c_2Ebinary__ieee_2Efloat__is__zero(A_27a,A_27b),V0x)) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__infinities,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0x] :
              ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ( p(ap(c_2Ebinary__ieee_2Efloat__is__infinite(A_27t,A_27w),V0x))
              <=> ( V0x = ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))
                  | V0x = ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) ) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__infinities__distinct,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ! [V0x] :
              ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27t,A_27w))
             => ~ ( V0x = ap(c_2Ebinary__ieee_2Efloat__plus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))
                  & V0x = ap(c_2Ebinary__ieee_2Efloat__minus__infinity(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) ) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__to__real__negate,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27b] :
          ( ne(A_27b)
         => ! [V0x] :
              ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b))
             => ap(c_2Ebinary__ieee_2Efloat__to__real(A_27a,A_27b),ap(c_2Ebinary__ieee_2Efloat__negate(A_27a,A_27b),V0x)) = ap(c_2Erealax_2Ereal__neg,ap(c_2Ebinary__ieee_2Efloat__to__real(A_27a,A_27b),V0x)) ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Efloat__negate__negate,axiom,
    ! [A_27a] :
      ( ne(A_27a)
     => ! [A_27b] :
          ( ne(A_27b)
         => ! [V0x] :
              ( mem(V0x,ty_2Ebinary__ieee_2Efloat(A_27a,A_27b))
             => ap(c_2Ebinary__ieee_2Efloat__negate(A_27a,A_27b),ap(c_2Ebinary__ieee_2Efloat__negate(A_27a,A_27b),V0x)) = V0x ) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Eulp,axiom,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ap(c_2Ebinary__ieee_2Eulp(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))) = ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) ) ) ).

fof(conj_thm_2Ebinary__ieee_2Eneg__ulp,conjecture,
    ! [A_27t] :
      ( ne(A_27t)
     => ! [A_27w] :
          ( ne(A_27w)
         => ap(c_2Erealax_2Ereal__neg,ap(c_2Ebinary__ieee_2Eulp(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w)))) = ap(c_2Ebinary__ieee_2Efloat__to__real(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__negate(A_27t,A_27w),ap(c_2Ebinary__ieee_2Efloat__plus__min(A_27t,A_27w),c_2Ebool_2Ethe__value(ty_2Epair_2Eprod(A_27t,A_27w))))) ) ) ).

%------------------------------------------------------------------------------
