%------------------------------------------------------------------------------
% File     : ITP012_4 : TPTP v9.2.0. Bugfixed v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : HOL4 syntactic export of thm_2Einteger_2EINT__DIVIDES__RSUB.p, chainy mode
% Version  : [BG+19] axioms.
% English  :

% Refs     : [BG+19] Brown et al. (2019), GRUNGE: A Grand Unified ATP Chall
%          : [Gau20] Gauthier (2020), Email to Geoff Sutcliffe
% Source   : [BG+19]
% Names    : thm_2Einteger_2EINT__DIVIDES__RSUB.p [Gau20]
%          : HL405501_4.p [TPAP]

% Status   : Theorem
% Rating   : 0.62 v9.1.0, 0.50 v9.0.0, 0.56 v8.2.0, 0.80 v8.1.0, 0.82 v7.5.0
% Syntax   : Number of formulae    : 36789 (12886 unt;17594 typ;   0 def)
%            Number of atoms       : 40895 (22870 equ)
%            Maximal formula atoms :  912 (   1 avg)
%            Number of connectives : 23560 (1860   ~;1113   |;8103   &)
%                                         (5626 <=>;6858  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  360 (   5 avg)
%            Maximal term depth    :   53 (   3 avg)
%            Number of types       :  598 ( 597 usr)
%            Number of type conns  : 15161 (9868   >;5293   *;   0   +;   0  <<)
%            Number of predicates  :    2 (   1 usr;   0 prp; 1-2 aty)
%            Number of functors    : 5349 (5349 usr;1704 con; 0-6 aty)
%            Number of variables   : 75899 (62528   !;13371   ?;75899   :)
% SPC      : TF0_THM_EQU_NAR

% Comments :
% Bugfixes : v7.5.0 - Bugfixes in axioms and export.
%------------------------------------------------------------------------------
include('Axioms/ITP001/ITP002_4.ax').
include('Axioms/ITP001/ITP003_4.ax').
include('Axioms/ITP001/ITP004_4.ax').
include('Axioms/ITP001/ITP005_4.ax').
include('Axioms/ITP001/ITP006_4.ax').
include('Axioms/ITP001/ITP007_4.ax').
include('Axioms/ITP001/ITP008_4.ax').
include('Axioms/ITP001/ITP009_4.ax').
include('Axioms/ITP001/ITP010_4.ax').
include('Axioms/ITP001/ITP011_4.ax').
include('Axioms/ITP001/ITP012_4.ax').
include('Axioms/ITP001/ITP013_4.ax').
include('Axioms/ITP001/ITP014_4.ax').
include('Axioms/ITP001/ITP015_4.ax').
include('Axioms/ITP001/ITP016_4.ax').
include('Axioms/ITP001/ITP017_4.ax').
include('Axioms/ITP001/ITP018_4.ax').
include('Axioms/ITP001/ITP019_4.ax').
include('Axioms/ITP001/ITP020_4.ax').
include('Axioms/ITP001/ITP021_4.ax').
include('Axioms/ITP001/ITP022_4.ax').
include('Axioms/ITP001/ITP023_4.ax').
include('Axioms/ITP001/ITP024_4.ax').
include('Axioms/ITP001/ITP025_4.ax').
include('Axioms/ITP001/ITP026_4.ax').
include('Axioms/ITP001/ITP027_4.ax').
include('Axioms/ITP001/ITP028_4.ax').
include('Axioms/ITP001/ITP029_4.ax').
include('Axioms/ITP001/ITP030_4.ax').
include('Axioms/ITP001/ITP031_4.ax').
include('Axioms/ITP001/ITP032_4.ax').
include('Axioms/ITP001/ITP033_4.ax').
include('Axioms/ITP001/ITP034_4.ax').
include('Axioms/ITP001/ITP035_4.ax').
include('Axioms/ITP001/ITP036_4.ax').
include('Axioms/ITP001/ITP037_4.ax').
include('Axioms/ITP001/ITP038_4.ax').
include('Axioms/ITP001/ITP039_4.ax').
include('Axioms/ITP001/ITP040_4.ax').
include('Axioms/ITP001/ITP041_4.ax').
include('Axioms/ITP001/ITP042_4.ax').
include('Axioms/ITP001/ITP043_4.ax').
include('Axioms/ITP001/ITP044_4.ax').
include('Axioms/ITP001/ITP045_4.ax').
include('Axioms/ITP001/ITP046_4.ax').
include('Axioms/ITP001/ITP047_4.ax').
include('Axioms/ITP001/ITP048_4.ax').
include('Axioms/ITP001/ITP049_4.ax').
include('Axioms/ITP001/ITP050_4.ax').
include('Axioms/ITP001/ITP051_4.ax').
include('Axioms/ITP001/ITP052_4.ax').
include('Axioms/ITP001/ITP053_4.ax').
include('Axioms/ITP001/ITP054_4.ax').
include('Axioms/ITP001/ITP055_4.ax').
include('Axioms/ITP001/ITP056_4.ax').
include('Axioms/ITP001/ITP057_4.ax').
include('Axioms/ITP001/ITP058_4.ax').
include('Axioms/ITP001/ITP059_4.ax').
include('Axioms/ITP001/ITP060_4.ax').
include('Axioms/ITP001/ITP061_4.ax').
include('Axioms/ITP001/ITP062_4.ax').
include('Axioms/ITP001/ITP063_4.ax').
include('Axioms/ITP001/ITP064_4.ax').
include('Axioms/ITP001/ITP065_4.ax').
include('Axioms/ITP001/ITP066_4.ax').
include('Axioms/ITP001/ITP067_4.ax').
include('Axioms/ITP001/ITP068_4.ax').
include('Axioms/ITP001/ITP069_4.ax').
include('Axioms/ITP001/ITP070_4.ax').
include('Axioms/ITP001/ITP071_4.ax').
include('Axioms/ITP001/ITP072_4.ax').
include('Axioms/ITP001/ITP073_4.ax').
include('Axioms/ITP001/ITP074_4.ax').
include('Axioms/ITP001/ITP075_4.ax').
include('Axioms/ITP001/ITP076_4.ax').
include('Axioms/ITP001/ITP077_4.ax').
include('Axioms/ITP001/ITP078_4.ax').
include('Axioms/ITP001/ITP079_4.ax').
include('Axioms/ITP001/ITP080_4.ax').
include('Axioms/ITP001/ITP081_4.ax').
include('Axioms/ITP001/ITP082_4.ax').
include('Axioms/ITP001/ITP083_4.ax').
include('Axioms/ITP001/ITP084_4.ax').
%------------------------------------------------------------------------------
tff(u,type,
    u: $tType ).

tff(d,type,
    d: $tType ).

tff(du,type,
    du: $tType ).

tff(mono_2Etyop_2Emin_2Ebool,type,
    mono_2Etyop_2Emin_2Ebool: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Einteger_2Eint_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Einteger_2Eint_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Enum_2Enum_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Enum_2Enum_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Einteger_2Eint_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Einteger_2Eint_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Enum_2Enum_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Enum_2Enum_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29: $tType ).

tff(mono_2Etyop_2Einteger_2Eint,type,
    mono_2Etyop_2Einteger_2Eint: $tType ).

tff(mono_2Etyop_2Enum_2Enum,type,
    mono_2Etyop_2Enum_2Enum: $tType ).

tff(mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,type,
    mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29: $tType ).

tff(tyop_2Einteger_2Eint,type,
    tyop_2Einteger_2Eint: d ).

tff(tyop_2Emin_2Ebool,type,
    tyop_2Emin_2Ebool: d ).

tff(tyop_2Emin_2Efun,type,
    tyop_2Emin_2Efun: ( d * d ) > d ).

tff(tyop_2Enum_2Enum,type,
    tyop_2Enum_2Enum: d ).

tff(tyop_2Epair_2Eprod,type,
    tyop_2Epair_2Eprod: ( d * d ) > d ).

tff(s,type,
    s: ( d * u ) > du ).

tff(app_2E2,type,
    app_2E2: ( du * du ) > u ).

tff(p,type,
    p: mono_2Etyop_2Emin_2Ebool > $o ).

tff(combin_i_2E0,type,
    combin_i_2E0: u ).

tff(combin_k_2E0,type,
    combin_k_2E0: u ).

tff(combin_s_2E0,type,
    combin_s_2E0: u ).

tff(c_2Ebool_2E_21_2E0,type,
    c_2Ebool_2E_21_2E0: u ).

tff(c_2Ebool_2E_21_2E1,type,
    c_2Ebool_2E_21_2E1: du > u ).

tff(c_2Earithmetic_2E_2A_2E0,type,
    c_2Earithmetic_2E_2A_2E0: u ).

tff(c_2Earithmetic_2E_2A_2E2,type,
    c_2Earithmetic_2E_2A_2E2: ( du * du ) > u ).

tff(c_2Earithmetic_2E_2B_2E0,type,
    c_2Earithmetic_2E_2B_2E0: u ).

tff(c_2Earithmetic_2E_2B_2E2,type,
    c_2Earithmetic_2E_2B_2E2: ( du * du ) > u ).

tff(c_2Epair_2E_2C_2E0,type,
    c_2Epair_2E_2C_2E0: u ).

tff(c_2Epair_2E_2C_2E2,type,
    c_2Epair_2E_2C_2E2: ( du * du ) > u ).

tff(c_2Earithmetic_2E_2D_2E0,type,
    c_2Earithmetic_2E_2D_2E0: u ).

tff(c_2Earithmetic_2E_2D_2E2,type,
    c_2Earithmetic_2E_2D_2E2: ( du * du ) > u ).

tff(c_2Ebool_2E_2F_5C_2E0,type,
    c_2Ebool_2E_2F_5C_2E0: u ).

tff(c_2Ebool_2E_2F_5C_2E2,type,
    c_2Ebool_2E_2F_5C_2E2: ( du * du ) > u ).

tff(c_2Enum_2E0_2E0,type,
    c_2Enum_2E0_2E0: u ).

tff(c_2Eprim__rec_2E_3C_2E0,type,
    c_2Eprim__rec_2E_3C_2E0: u ).

tff(c_2Eprim__rec_2E_3C_2E2,type,
    c_2Eprim__rec_2E_3C_2E2: ( du * du ) > u ).

tff(c_2Earithmetic_2E_3C_3D_2E0,type,
    c_2Earithmetic_2E_3C_3D_2E0: u ).

tff(c_2Earithmetic_2E_3C_3D_2E2,type,
    c_2Earithmetic_2E_3C_3D_2E2: ( du * du ) > u ).

tff(c_2Emin_2E_3D_2E0,type,
    c_2Emin_2E_3D_2E0: u ).

tff(c_2Emin_2E_3D_2E2,type,
    c_2Emin_2E_3D_2E2: ( du * du ) > u ).

tff(c_2Emin_2E_3D_3D_3E_2E0,type,
    c_2Emin_2E_3D_3D_3E_2E0: u ).

tff(c_2Emin_2E_3D_3D_3E_2E2,type,
    c_2Emin_2E_3D_3D_3E_2E2: ( du * du ) > u ).

tff(c_2Ebool_2E_3F_2E0,type,
    c_2Ebool_2E_3F_2E0: u ).

tff(c_2Ebool_2E_3F_2E1,type,
    c_2Ebool_2E_3F_2E1: du > u ).

tff(c_2Ebool_2E_3F_21_2E0,type,
    c_2Ebool_2E_3F_21_2E0: u ).

tff(c_2Ebool_2E_3F_21_2E1,type,
    c_2Ebool_2E_3F_21_2E1: du > u ).

tff(c_2Emin_2E_40_2E0,type,
    c_2Emin_2E_40_2E0: u ).

tff(c_2Emin_2E_40_2E1,type,
    c_2Emin_2E_40_2E1: du > u ).

tff(c_2Einteger_2EABS_2E0,type,
    c_2Einteger_2EABS_2E0: u ).

tff(c_2Einteger_2EABS_2E1,type,
    c_2Einteger_2EABS_2E1: du > u ).

tff(c_2Earithmetic_2EBIT1_2E0,type,
    c_2Earithmetic_2EBIT1_2E0: u ).

tff(c_2Earithmetic_2EBIT1_2E1,type,
    c_2Earithmetic_2EBIT1_2E1: du > u ).

tff(c_2Earithmetic_2EBIT2_2E0,type,
    c_2Earithmetic_2EBIT2_2E0: u ).

tff(c_2Earithmetic_2EBIT2_2E1,type,
    c_2Earithmetic_2EBIT2_2E1: du > u ).

tff(c_2Ebool_2ECOND_2E0,type,
    c_2Ebool_2ECOND_2E0: u ).

tff(c_2Ebool_2ECOND_2E3,type,
    c_2Ebool_2ECOND_2E3: ( du * du * du ) > u ).

tff(c_2Earithmetic_2EDIV_2E0,type,
    c_2Earithmetic_2EDIV_2E0: u ).

tff(c_2Earithmetic_2EDIV_2E2,type,
    c_2Earithmetic_2EDIV_2E2: ( du * du ) > u ).

tff(c_2Ebool_2EF_2E0,type,
    c_2Ebool_2EF_2E0: u ).

tff(c_2Epair_2EFST_2E0,type,
    c_2Epair_2EFST_2E0: u ).

tff(c_2Epair_2EFST_2E1,type,
    c_2Epair_2EFST_2E1: du > u ).

tff(c_2Earithmetic_2EMOD_2E0,type,
    c_2Earithmetic_2EMOD_2E0: u ).

tff(c_2Earithmetic_2EMOD_2E2,type,
    c_2Earithmetic_2EMOD_2E2: ( du * du ) > u ).

tff(c_2Earithmetic_2ENUMERAL_2E0,type,
    c_2Earithmetic_2ENUMERAL_2E0: u ).

tff(c_2Earithmetic_2ENUMERAL_2E1,type,
    c_2Earithmetic_2ENUMERAL_2E1: du > u ).

tff(c_2Einteger_2ENum_2E0,type,
    c_2Einteger_2ENum_2E0: u ).

tff(c_2Einteger_2ENum_2E1,type,
    c_2Einteger_2ENum_2E1: du > u ).

tff(c_2Equotient_2EQUOTIENT_2E0,type,
    c_2Equotient_2EQUOTIENT_2E0: u ).

tff(c_2Equotient_2EQUOTIENT_2E3,type,
    c_2Equotient_2EQUOTIENT_2E3: ( du * du * du ) > u ).

tff(c_2Epair_2ESND_2E0,type,
    c_2Epair_2ESND_2E0: u ).

tff(c_2Epair_2ESND_2E1,type,
    c_2Epair_2ESND_2E1: du > u ).

tff(c_2Enum_2ESUC_2E0,type,
    c_2Enum_2ESUC_2E0: u ).

tff(c_2Enum_2ESUC_2E1,type,
    c_2Enum_2ESUC_2E1: du > u ).

tff(c_2Ebool_2ET_2E0,type,
    c_2Ebool_2ET_2E0: u ).

tff(c_2Ebool_2ETYPE__DEFINITION_2E0,type,
    c_2Ebool_2ETYPE__DEFINITION_2E0: u ).

tff(c_2Ebool_2ETYPE__DEFINITION_2E2,type,
    c_2Ebool_2ETYPE__DEFINITION_2E2: ( du * du ) > u ).

tff(c_2Earithmetic_2EZERO_2E0,type,
    c_2Earithmetic_2EZERO_2E0: u ).

tff(c_2Ebool_2E_5C_2F_2E0,type,
    c_2Ebool_2E_5C_2F_2E0: u ).

tff(c_2Ebool_2E_5C_2F_2E2,type,
    c_2Ebool_2E_5C_2F_2E2: ( du * du ) > u ).

tff(c_2Einteger_2Eint__0_2E0,type,
    c_2Einteger_2Eint__0_2E0: u ).

tff(c_2Einteger_2Eint__1_2E0,type,
    c_2Einteger_2Eint__1_2E0: u ).

tff(c_2Einteger_2Eint__ABS_2E0,type,
    c_2Einteger_2Eint__ABS_2E0: u ).

tff(c_2Einteger_2Eint__ABS_2E1,type,
    c_2Einteger_2Eint__ABS_2E1: du > u ).

tff(c_2Einteger_2Eint__ABS__CLASS_2E0,type,
    c_2Einteger_2Eint__ABS__CLASS_2E0: u ).

tff(c_2Einteger_2Eint__ABS__CLASS_2E1,type,
    c_2Einteger_2Eint__ABS__CLASS_2E1: du > u ).

tff(c_2Einteger_2Eint__REP_2E0,type,
    c_2Einteger_2Eint__REP_2E0: u ).

tff(c_2Einteger_2Eint__REP_2E1,type,
    c_2Einteger_2Eint__REP_2E1: du > u ).

tff(c_2Einteger_2Eint__REP__CLASS_2E0,type,
    c_2Einteger_2Eint__REP__CLASS_2E0: u ).

tff(c_2Einteger_2Eint__REP__CLASS_2E1,type,
    c_2Einteger_2Eint__REP__CLASS_2E1: du > u ).

tff(c_2Einteger_2Eint__add_2E0,type,
    c_2Einteger_2Eint__add_2E0: u ).

tff(c_2Einteger_2Eint__add_2E2,type,
    c_2Einteger_2Eint__add_2E2: ( du * du ) > u ).

tff(c_2Einteger_2Eint__div_2E0,type,
    c_2Einteger_2Eint__div_2E0: u ).

tff(c_2Einteger_2Eint__div_2E2,type,
    c_2Einteger_2Eint__div_2E2: ( du * du ) > u ).

tff(c_2Einteger_2Eint__divides_2E0,type,
    c_2Einteger_2Eint__divides_2E0: u ).

tff(c_2Einteger_2Eint__divides_2E2,type,
    c_2Einteger_2Eint__divides_2E2: ( du * du ) > u ).

tff(c_2Einteger_2Eint__ge_2E0,type,
    c_2Einteger_2Eint__ge_2E0: u ).

tff(c_2Einteger_2Eint__ge_2E2,type,
    c_2Einteger_2Eint__ge_2E2: ( du * du ) > u ).

tff(c_2Einteger_2Eint__gt_2E0,type,
    c_2Einteger_2Eint__gt_2E0: u ).

tff(c_2Einteger_2Eint__gt_2E2,type,
    c_2Einteger_2Eint__gt_2E2: ( du * du ) > u ).

tff(c_2Einteger_2Eint__le_2E0,type,
    c_2Einteger_2Eint__le_2E0: u ).

tff(c_2Einteger_2Eint__le_2E2,type,
    c_2Einteger_2Eint__le_2E2: ( du * du ) > u ).

tff(c_2Einteger_2Eint__lt_2E0,type,
    c_2Einteger_2Eint__lt_2E0: u ).

tff(c_2Einteger_2Eint__lt_2E2,type,
    c_2Einteger_2Eint__lt_2E2: ( du * du ) > u ).

tff(c_2Einteger_2Eint__mod_2E0,type,
    c_2Einteger_2Eint__mod_2E0: u ).

tff(c_2Einteger_2Eint__mod_2E2,type,
    c_2Einteger_2Eint__mod_2E2: ( du * du ) > u ).

tff(c_2Einteger_2Eint__mul_2E0,type,
    c_2Einteger_2Eint__mul_2E0: u ).

tff(c_2Einteger_2Eint__mul_2E2,type,
    c_2Einteger_2Eint__mul_2E2: ( du * du ) > u ).

tff(c_2Einteger_2Eint__neg_2E0,type,
    c_2Einteger_2Eint__neg_2E0: u ).

tff(c_2Einteger_2Eint__neg_2E1,type,
    c_2Einteger_2Eint__neg_2E1: du > u ).

tff(c_2Einteger_2Eint__of__num_2E0,type,
    c_2Einteger_2Eint__of__num_2E0: u ).

tff(c_2Einteger_2Eint__of__num_2E1,type,
    c_2Einteger_2Eint__of__num_2E1: du > u ).

tff(c_2Einteger_2Eint__quot_2E0,type,
    c_2Einteger_2Eint__quot_2E0: u ).

tff(c_2Einteger_2Eint__quot_2E2,type,
    c_2Einteger_2Eint__quot_2E2: ( du * du ) > u ).

tff(c_2Einteger_2Eint__rem_2E0,type,
    c_2Einteger_2Eint__rem_2E0: u ).

tff(c_2Einteger_2Eint__rem_2E2,type,
    c_2Einteger_2Eint__rem_2E2: ( du * du ) > u ).

tff(c_2Einteger_2Eint__sub_2E0,type,
    c_2Einteger_2Eint__sub_2E0: u ).

tff(c_2Einteger_2Eint__sub_2E2,type,
    c_2Einteger_2Eint__sub_2E2: ( du * du ) > u ).

tff(c_2Einteger_2Etint__0_2E0,type,
    c_2Einteger_2Etint__0_2E0: u ).

tff(c_2Einteger_2Etint__1_2E0,type,
    c_2Einteger_2Etint__1_2E0: u ).

tff(c_2Einteger_2Etint__add_2E0,type,
    c_2Einteger_2Etint__add_2E0: u ).

tff(c_2Einteger_2Etint__add_2E2,type,
    c_2Einteger_2Etint__add_2E2: ( du * du ) > u ).

tff(c_2Einteger_2Etint__eq_2E0,type,
    c_2Einteger_2Etint__eq_2E0: u ).

tff(c_2Einteger_2Etint__eq_2E1,type,
    c_2Einteger_2Etint__eq_2E1: du > u ).

tff(c_2Einteger_2Etint__eq_2E2,type,
    c_2Einteger_2Etint__eq_2E2: ( du * du ) > u ).

tff(c_2Einteger_2Etint__lt_2E0,type,
    c_2Einteger_2Etint__lt_2E0: u ).

tff(c_2Einteger_2Etint__lt_2E2,type,
    c_2Einteger_2Etint__lt_2E2: ( du * du ) > u ).

tff(c_2Einteger_2Etint__mul_2E0,type,
    c_2Einteger_2Etint__mul_2E0: u ).

tff(c_2Einteger_2Etint__mul_2E2,type,
    c_2Einteger_2Etint__mul_2E2: ( du * du ) > u ).

tff(c_2Einteger_2Etint__neg_2E0,type,
    c_2Einteger_2Etint__neg_2E0: u ).

tff(c_2Einteger_2Etint__neg_2E1,type,
    c_2Einteger_2Etint__neg_2E1: du > u ).

tff(c_2Einteger_2Etint__of__num_2E0,type,
    c_2Einteger_2Etint__of__num_2E0: u ).

tff(c_2Einteger_2Etint__of__num_2E1,type,
    c_2Einteger_2Etint__of__num_2E1: du > u ).

tff(c_2Ebool_2E_7E_2E0,type,
    c_2Ebool_2E_7E_2E0: u ).

tff(c_2Ebool_2E_7E_2E1,type,
    c_2Ebool_2E_7E_2E1: du > u ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool: ( mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29 * mono_2Etyop_2Emin_2Ebool ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29 * mono_2Etyop_2Emin_2Ebool ) > mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_29 * mono_2Etyop_2Emin_2Ebool ) > mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29_29 * mono_2Etyop_2Emin_2Ebool ) > mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29_29 * mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29 ) > mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Emin_2Ebool,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Emin_2Ebool: ( mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29 * mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29 ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_20mono_2Etyop_2Emin_2Ebool,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_20mono_2Etyop_2Emin_2Ebool: ( mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29 * mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Emin_2Ebool,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Emin_2Ebool: ( mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29 * mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29 ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Enum_2Enum,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Enum_2Enum: ( mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29 * mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29 ) > mono_2Etyop_2Enum_2Enum ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Emin_2Ebool,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Emin_2Ebool: ( mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29 * mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29 ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Einteger_2Eint,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Einteger_2Eint: ( mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Einteger_2Eint_29 * mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29 ) > mono_2Etyop_2Einteger_2Eint ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 * mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29 ) > mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29_29 * mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29 ) > mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29 * mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29 ) > mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool: ( mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29 * mono_2Etyop_2Einteger_2Eint ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29 * mono_2Etyop_2Einteger_2Eint ) > mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29 * mono_2Etyop_2Einteger_2Eint ) > mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29 * mono_2Etyop_2Einteger_2Eint ) > mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29 * mono_2Etyop_2Einteger_2Eint ) > mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Einteger_2Eint,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Einteger_2Eint: ( mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29 * mono_2Etyop_2Einteger_2Eint ) > mono_2Etyop_2Einteger_2Eint ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Enum_2Enum,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Enum_2Enum: ( mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Enum_2Enum_29 * mono_2Etyop_2Einteger_2Eint ) > mono_2Etyop_2Enum_2Enum ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 * mono_2Etyop_2Einteger_2Eint ) > mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Ebool,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Ebool: ( mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29 * mono_2Etyop_2Enum_2Enum ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29 * mono_2Etyop_2Enum_2Enum ) > mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 * mono_2Etyop_2Enum_2Enum ) > mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29 * mono_2Etyop_2Enum_2Enum ) > mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Einteger_2Eint,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Einteger_2Eint: ( mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Einteger_2Eint_29 * mono_2Etyop_2Enum_2Enum ) > mono_2Etyop_2Einteger_2Eint ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum: ( mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 * mono_2Etyop_2Enum_2Enum ) > mono_2Etyop_2Enum_2Enum ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 * mono_2Etyop_2Enum_2Enum ) > mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Emin_2Ebool,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Emin_2Ebool: ( mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29 * mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29 * mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ) > mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29 * mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ) > mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Einteger_2Eint,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Einteger_2Eint: ( mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29 * mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ) > mono_2Etyop_2Einteger_2Eint ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Enum_2Enum,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Enum_2Enum: ( mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Enum_2Enum_29 * mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ) > mono_2Etyop_2Enum_2Enum ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 * mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ) > mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ).

tff(mono_2Ec_2Earithmetic_2E_2A_2E0,type,
    mono_2Ec_2Earithmetic_2E_2A_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 ).

tff(mono_2Ec_2Earithmetic_2E_2A_2E2,type,
    mono_2Ec_2Earithmetic_2E_2A_2E2: ( mono_2Etyop_2Enum_2Enum * mono_2Etyop_2Enum_2Enum ) > mono_2Etyop_2Enum_2Enum ).

tff(mono_2Ec_2Earithmetic_2E_2B_2E0,type,
    mono_2Ec_2Earithmetic_2E_2B_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 ).

tff(mono_2Ec_2Earithmetic_2E_2B_2E2,type,
    mono_2Ec_2Earithmetic_2E_2B_2E2: ( mono_2Etyop_2Enum_2Enum * mono_2Etyop_2Enum_2Enum ) > mono_2Etyop_2Enum_2Enum ).

tff(mono_2Ec_2Epair_2E_2C_2E0_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum,type,
    mono_2Ec_2Epair_2E_2C_2E0_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29 ).

tff(mono_2Ec_2Epair_2E_2C_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum,type,
    mono_2Ec_2Epair_2E_2C_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum: ( mono_2Etyop_2Enum_2Enum * mono_2Etyop_2Enum_2Enum ) > mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ).

tff(mono_2Ec_2Earithmetic_2E_2D_2E0,type,
    mono_2Ec_2Earithmetic_2E_2D_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 ).

tff(mono_2Ec_2Earithmetic_2E_2D_2E2,type,
    mono_2Ec_2Earithmetic_2E_2D_2E2: ( mono_2Etyop_2Enum_2Enum * mono_2Etyop_2Enum_2Enum ) > mono_2Etyop_2Enum_2Enum ).

tff(mono_2Ec_2Ebool_2E_2F_5C_2E0,type,
    mono_2Ec_2Ebool_2E_2F_5C_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29 ).

tff(mono_2Ec_2Ebool_2E_2F_5C_2E2,type,
    mono_2Ec_2Ebool_2E_2F_5C_2E2: ( mono_2Etyop_2Emin_2Ebool * mono_2Etyop_2Emin_2Ebool ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Ec_2Enum_2E0_2E0,type,
    mono_2Ec_2Enum_2E0_2E0: mono_2Etyop_2Enum_2Enum ).

tff(mono_2Ec_2Eprim__rec_2E_3C_2E0,type,
    mono_2Ec_2Eprim__rec_2E_3C_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29 ).

tff(mono_2Ec_2Eprim__rec_2E_3C_2E2,type,
    mono_2Ec_2Eprim__rec_2E_3C_2E2: ( mono_2Etyop_2Enum_2Enum * mono_2Etyop_2Enum_2Enum ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Ec_2Earithmetic_2E_3C_3D_2E0,type,
    mono_2Ec_2Earithmetic_2E_3C_3D_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29 ).

tff(mono_2Ec_2Earithmetic_2E_3C_3D_2E2,type,
    mono_2Ec_2Earithmetic_2E_3C_3D_2E2: ( mono_2Etyop_2Enum_2Enum * mono_2Etyop_2Enum_2Enum ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Ec_2Emin_2E_3D_3D_3E_2E0,type,
    mono_2Ec_2Emin_2E_3D_3D_3E_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29 ).

tff(mono_2Ec_2Emin_2E_3D_3D_3E_2E2,type,
    mono_2Ec_2Emin_2E_3D_3D_3E_2E2: ( mono_2Etyop_2Emin_2Ebool * mono_2Etyop_2Emin_2Ebool ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Ec_2Ebool_2E_3F_21_2E0_2Emono_2Etyop_2Enum_2Enum,type,
    mono_2Ec_2Ebool_2E_3F_21_2E0_2Emono_2Etyop_2Enum_2Enum: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29 ).

tff(mono_2Ec_2Ebool_2E_3F_21_2E1_2Emono_2Etyop_2Enum_2Enum,type,
    mono_2Ec_2Ebool_2E_3F_21_2E1_2Emono_2Etyop_2Enum_2Enum: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29 > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Ec_2Emin_2E_40_2E0_2Emono_2Etyop_2Enum_2Enum,type,
    mono_2Ec_2Emin_2E_40_2E0_2Emono_2Etyop_2Enum_2Enum: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29 ).

tff(mono_2Ec_2Emin_2E_40_2E1_2Emono_2Etyop_2Enum_2Enum,type,
    mono_2Ec_2Emin_2E_40_2E1_2Emono_2Etyop_2Enum_2Enum: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29 > mono_2Etyop_2Enum_2Enum ).

tff(mono_2Ec_2Emin_2E_40_2E0_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,type,
    mono_2Ec_2Emin_2E_40_2E0_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 ).

tff(mono_2Ec_2Emin_2E_40_2E1_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,type,
    mono_2Ec_2Emin_2E_40_2E1_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29 > mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ).

tff(mono_2Ec_2Einteger_2EABS_2E0,type,
    mono_2Ec_2Einteger_2EABS_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29 ).

tff(mono_2Ec_2Einteger_2EABS_2E1,type,
    mono_2Ec_2Einteger_2EABS_2E1: mono_2Etyop_2Einteger_2Eint > mono_2Etyop_2Einteger_2Eint ).

tff(mono_2Ec_2Earithmetic_2EBIT1_2E0,type,
    mono_2Ec_2Earithmetic_2EBIT1_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ).

tff(mono_2Ec_2Earithmetic_2EBIT1_2E1,type,
    mono_2Ec_2Earithmetic_2EBIT1_2E1: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ).

tff(mono_2Ec_2Earithmetic_2EBIT2_2E0,type,
    mono_2Ec_2Earithmetic_2EBIT2_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ).

tff(mono_2Ec_2Earithmetic_2EBIT2_2E1,type,
    mono_2Ec_2Earithmetic_2EBIT2_2E1: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ).

tff(mono_2Ec_2Ebool_2ECOND_2E0_2Emono_2Etyop_2Emin_2Ebool,type,
    mono_2Ec_2Ebool_2ECOND_2E0_2Emono_2Etyop_2Emin_2Ebool: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_29 ).

tff(mono_2Ec_2Ebool_2ECOND_2E3_2Emono_2Etyop_2Emin_2Ebool,type,
    mono_2Ec_2Ebool_2ECOND_2E3_2Emono_2Etyop_2Emin_2Ebool: ( mono_2Etyop_2Emin_2Ebool * mono_2Etyop_2Emin_2Ebool * mono_2Etyop_2Emin_2Ebool ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Ec_2Ebool_2ECOND_2E0_2Emono_2Etyop_2Einteger_2Eint,type,
    mono_2Ec_2Ebool_2ECOND_2E0_2Emono_2Etyop_2Einteger_2Eint: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29_29 ).

tff(mono_2Ec_2Ebool_2ECOND_2E3_2Emono_2Etyop_2Einteger_2Eint,type,
    mono_2Ec_2Ebool_2ECOND_2E3_2Emono_2Etyop_2Einteger_2Eint: ( mono_2Etyop_2Emin_2Ebool * mono_2Etyop_2Einteger_2Eint * mono_2Etyop_2Einteger_2Eint ) > mono_2Etyop_2Einteger_2Eint ).

tff(mono_2Ec_2Earithmetic_2EDIV_2E0,type,
    mono_2Ec_2Earithmetic_2EDIV_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 ).

tff(mono_2Ec_2Earithmetic_2EDIV_2E2,type,
    mono_2Ec_2Earithmetic_2EDIV_2E2: ( mono_2Etyop_2Enum_2Enum * mono_2Etyop_2Enum_2Enum ) > mono_2Etyop_2Enum_2Enum ).

tff(mono_2Ec_2Ebool_2EF_2E0,type,
    mono_2Ec_2Ebool_2EF_2E0: mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Ec_2Epair_2EFST_2E0_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum,type,
    mono_2Ec_2Epair_2EFST_2E0_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Enum_2Enum_29 ).

tff(mono_2Ec_2Epair_2EFST_2E1_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum,type,
    mono_2Ec_2Epair_2EFST_2E1_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 > mono_2Etyop_2Enum_2Enum ).

tff(mono_2Ec_2Earithmetic_2EMOD_2E0,type,
    mono_2Ec_2Earithmetic_2EMOD_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 ).

tff(mono_2Ec_2Earithmetic_2EMOD_2E2,type,
    mono_2Ec_2Earithmetic_2EMOD_2E2: ( mono_2Etyop_2Enum_2Enum * mono_2Etyop_2Enum_2Enum ) > mono_2Etyop_2Enum_2Enum ).

tff(mono_2Ec_2Earithmetic_2ENUMERAL_2E0,type,
    mono_2Ec_2Earithmetic_2ENUMERAL_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ).

tff(mono_2Ec_2Earithmetic_2ENUMERAL_2E1,type,
    mono_2Ec_2Earithmetic_2ENUMERAL_2E1: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ).

tff(mono_2Ec_2Einteger_2ENum_2E0,type,
    mono_2Ec_2Einteger_2ENum_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Enum_2Enum_29 ).

tff(mono_2Ec_2Einteger_2ENum_2E1,type,
    mono_2Ec_2Einteger_2ENum_2E1: mono_2Etyop_2Einteger_2Eint > mono_2Etyop_2Enum_2Enum ).

tff(mono_2Ec_2Equotient_2EQUOTIENT_2E0_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Einteger_2Eint,type,
    mono_2Ec_2Equotient_2EQUOTIENT_2E0_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Einteger_2Eint: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29_29 ).

tff(mono_2Ec_2Equotient_2EQUOTIENT_2E3_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Einteger_2Eint,type,
    mono_2Ec_2Equotient_2EQUOTIENT_2E3_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Einteger_2Eint: ( mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29 * mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29 * mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Ec_2Epair_2ESND_2E0_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum,type,
    mono_2Ec_2Epair_2ESND_2E0_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Enum_2Enum_29 ).

tff(mono_2Ec_2Epair_2ESND_2E1_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum,type,
    mono_2Ec_2Epair_2ESND_2E1_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 > mono_2Etyop_2Enum_2Enum ).

tff(mono_2Ec_2Enum_2ESUC_2E0,type,
    mono_2Ec_2Enum_2ESUC_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ).

tff(mono_2Ec_2Enum_2ESUC_2E1,type,
    mono_2Ec_2Enum_2ESUC_2E1: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ).

tff(mono_2Ec_2Ebool_2ET_2E0,type,
    mono_2Ec_2Ebool_2ET_2E0: mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Ec_2Ebool_2ETYPE__DEFINITION_2E0_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Einteger_2Eint,type,
    mono_2Ec_2Ebool_2ETYPE__DEFINITION_2E0_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Einteger_2Eint: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29_29 ).

tff(mono_2Ec_2Ebool_2ETYPE__DEFINITION_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Einteger_2Eint,type,
    mono_2Ec_2Ebool_2ETYPE__DEFINITION_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Einteger_2Eint: ( mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29 * mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29 ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Ec_2Earithmetic_2EZERO_2E0,type,
    mono_2Ec_2Earithmetic_2EZERO_2E0: mono_2Etyop_2Enum_2Enum ).

tff(mono_2Ec_2Ebool_2E_5C_2F_2E0,type,
    mono_2Ec_2Ebool_2E_5C_2F_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29 ).

tff(mono_2Ec_2Ebool_2E_5C_2F_2E2,type,
    mono_2Ec_2Ebool_2E_5C_2F_2E2: ( mono_2Etyop_2Emin_2Ebool * mono_2Etyop_2Emin_2Ebool ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Ec_2Einteger_2Eint__0_2E0,type,
    mono_2Ec_2Einteger_2Eint__0_2E0: mono_2Etyop_2Einteger_2Eint ).

tff(mono_2Ec_2Einteger_2Eint__1_2E0,type,
    mono_2Ec_2Einteger_2Eint__1_2E0: mono_2Etyop_2Einteger_2Eint ).

tff(mono_2Ec_2Einteger_2Eint__ABS_2E0,type,
    mono_2Ec_2Einteger_2Eint__ABS_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29 ).

tff(mono_2Ec_2Einteger_2Eint__ABS_2E1,type,
    mono_2Ec_2Einteger_2Eint__ABS_2E1: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 > mono_2Etyop_2Einteger_2Eint ).

tff(mono_2Ec_2Einteger_2Eint__ABS__CLASS_2E0,type,
    mono_2Ec_2Einteger_2Eint__ABS__CLASS_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Einteger_2Eint_29 ).

tff(mono_2Ec_2Einteger_2Eint__ABS__CLASS_2E1,type,
    mono_2Ec_2Einteger_2Eint__ABS__CLASS_2E1: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29 > mono_2Etyop_2Einteger_2Eint ).

tff(mono_2Ec_2Einteger_2Eint__REP_2E0,type,
    mono_2Ec_2Einteger_2Eint__REP_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 ).

tff(mono_2Ec_2Einteger_2Eint__REP_2E1,type,
    mono_2Ec_2Einteger_2Eint__REP_2E1: mono_2Etyop_2Einteger_2Eint > mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ).

tff(mono_2Ec_2Einteger_2Eint__REP__CLASS_2E0,type,
    mono_2Ec_2Einteger_2Eint__REP__CLASS_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29 ).

tff(mono_2Ec_2Einteger_2Eint__REP__CLASS_2E1,type,
    mono_2Ec_2Einteger_2Eint__REP__CLASS_2E1: mono_2Etyop_2Einteger_2Eint > mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29 ).

tff(mono_2Ec_2Einteger_2Eint__add_2E0,type,
    mono_2Ec_2Einteger_2Eint__add_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29 ).

tff(mono_2Ec_2Einteger_2Eint__add_2E2,type,
    mono_2Ec_2Einteger_2Eint__add_2E2: ( mono_2Etyop_2Einteger_2Eint * mono_2Etyop_2Einteger_2Eint ) > mono_2Etyop_2Einteger_2Eint ).

tff(mono_2Ec_2Einteger_2Eint__div_2E0,type,
    mono_2Ec_2Einteger_2Eint__div_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29 ).

tff(mono_2Ec_2Einteger_2Eint__div_2E2,type,
    mono_2Ec_2Einteger_2Eint__div_2E2: ( mono_2Etyop_2Einteger_2Eint * mono_2Etyop_2Einteger_2Eint ) > mono_2Etyop_2Einteger_2Eint ).

tff(mono_2Ec_2Einteger_2Eint__divides_2E0,type,
    mono_2Ec_2Einteger_2Eint__divides_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29 ).

tff(mono_2Ec_2Einteger_2Eint__divides_2E2,type,
    mono_2Ec_2Einteger_2Eint__divides_2E2: ( mono_2Etyop_2Einteger_2Eint * mono_2Etyop_2Einteger_2Eint ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Ec_2Einteger_2Eint__ge_2E0,type,
    mono_2Ec_2Einteger_2Eint__ge_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29 ).

tff(mono_2Ec_2Einteger_2Eint__ge_2E2,type,
    mono_2Ec_2Einteger_2Eint__ge_2E2: ( mono_2Etyop_2Einteger_2Eint * mono_2Etyop_2Einteger_2Eint ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Ec_2Einteger_2Eint__gt_2E0,type,
    mono_2Ec_2Einteger_2Eint__gt_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29 ).

tff(mono_2Ec_2Einteger_2Eint__gt_2E2,type,
    mono_2Ec_2Einteger_2Eint__gt_2E2: ( mono_2Etyop_2Einteger_2Eint * mono_2Etyop_2Einteger_2Eint ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Ec_2Einteger_2Eint__le_2E0,type,
    mono_2Ec_2Einteger_2Eint__le_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29 ).

tff(mono_2Ec_2Einteger_2Eint__le_2E2,type,
    mono_2Ec_2Einteger_2Eint__le_2E2: ( mono_2Etyop_2Einteger_2Eint * mono_2Etyop_2Einteger_2Eint ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Ec_2Einteger_2Eint__lt_2E0,type,
    mono_2Ec_2Einteger_2Eint__lt_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29 ).

tff(mono_2Ec_2Einteger_2Eint__lt_2E2,type,
    mono_2Ec_2Einteger_2Eint__lt_2E2: ( mono_2Etyop_2Einteger_2Eint * mono_2Etyop_2Einteger_2Eint ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Ec_2Einteger_2Eint__mod_2E0,type,
    mono_2Ec_2Einteger_2Eint__mod_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29 ).

tff(mono_2Ec_2Einteger_2Eint__mod_2E2,type,
    mono_2Ec_2Einteger_2Eint__mod_2E2: ( mono_2Etyop_2Einteger_2Eint * mono_2Etyop_2Einteger_2Eint ) > mono_2Etyop_2Einteger_2Eint ).

tff(mono_2Ec_2Einteger_2Eint__mul_2E0,type,
    mono_2Ec_2Einteger_2Eint__mul_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29 ).

tff(mono_2Ec_2Einteger_2Eint__mul_2E2,type,
    mono_2Ec_2Einteger_2Eint__mul_2E2: ( mono_2Etyop_2Einteger_2Eint * mono_2Etyop_2Einteger_2Eint ) > mono_2Etyop_2Einteger_2Eint ).

tff(mono_2Ec_2Einteger_2Eint__neg_2E0,type,
    mono_2Ec_2Einteger_2Eint__neg_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29 ).

tff(mono_2Ec_2Einteger_2Eint__neg_2E1,type,
    mono_2Ec_2Einteger_2Eint__neg_2E1: mono_2Etyop_2Einteger_2Eint > mono_2Etyop_2Einteger_2Eint ).

tff(mono_2Ec_2Einteger_2Eint__of__num_2E0,type,
    mono_2Ec_2Einteger_2Eint__of__num_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Einteger_2Eint_29 ).

tff(mono_2Ec_2Einteger_2Eint__of__num_2E1,type,
    mono_2Ec_2Einteger_2Eint__of__num_2E1: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Einteger_2Eint ).

tff(mono_2Ec_2Einteger_2Eint__quot_2E0,type,
    mono_2Ec_2Einteger_2Eint__quot_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29 ).

tff(mono_2Ec_2Einteger_2Eint__quot_2E2,type,
    mono_2Ec_2Einteger_2Eint__quot_2E2: ( mono_2Etyop_2Einteger_2Eint * mono_2Etyop_2Einteger_2Eint ) > mono_2Etyop_2Einteger_2Eint ).

tff(mono_2Ec_2Einteger_2Eint__rem_2E0,type,
    mono_2Ec_2Einteger_2Eint__rem_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29 ).

tff(mono_2Ec_2Einteger_2Eint__rem_2E2,type,
    mono_2Ec_2Einteger_2Eint__rem_2E2: ( mono_2Etyop_2Einteger_2Eint * mono_2Etyop_2Einteger_2Eint ) > mono_2Etyop_2Einteger_2Eint ).

tff(mono_2Ec_2Einteger_2Eint__sub_2E0,type,
    mono_2Ec_2Einteger_2Eint__sub_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29 ).

tff(mono_2Ec_2Einteger_2Eint__sub_2E2,type,
    mono_2Ec_2Einteger_2Eint__sub_2E2: ( mono_2Etyop_2Einteger_2Eint * mono_2Etyop_2Einteger_2Eint ) > mono_2Etyop_2Einteger_2Eint ).

tff(mono_2Ec_2Einteger_2Etint__0_2E0,type,
    mono_2Ec_2Einteger_2Etint__0_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ).

tff(mono_2Ec_2Einteger_2Etint__1_2E0,type,
    mono_2Ec_2Einteger_2Etint__1_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ).

tff(mono_2Ec_2Einteger_2Etint__add_2E0,type,
    mono_2Ec_2Einteger_2Etint__add_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29 ).

tff(mono_2Ec_2Einteger_2Etint__add_2E2,type,
    mono_2Ec_2Einteger_2Etint__add_2E2: ( mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 * mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ) > mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ).

tff(mono_2Ec_2Einteger_2Etint__eq_2E0,type,
    mono_2Ec_2Einteger_2Etint__eq_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29 ).

tff(mono_2Ec_2Einteger_2Etint__eq_2E1,type,
    mono_2Ec_2Einteger_2Etint__eq_2E1: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 > mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29 ).

tff(mono_2Ec_2Einteger_2Etint__eq_2E2,type,
    mono_2Ec_2Einteger_2Etint__eq_2E2: ( mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 * mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Ec_2Einteger_2Etint__lt_2E0,type,
    mono_2Ec_2Einteger_2Etint__lt_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29 ).

tff(mono_2Ec_2Einteger_2Etint__lt_2E2,type,
    mono_2Ec_2Einteger_2Etint__lt_2E2: ( mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 * mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Ec_2Einteger_2Etint__mul_2E0,type,
    mono_2Ec_2Einteger_2Etint__mul_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29 ).

tff(mono_2Ec_2Einteger_2Etint__mul_2E2,type,
    mono_2Ec_2Einteger_2Etint__mul_2E2: ( mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 * mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ) > mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ).

tff(mono_2Ec_2Einteger_2Etint__neg_2E0,type,
    mono_2Ec_2Einteger_2Etint__neg_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 ).

tff(mono_2Ec_2Einteger_2Etint__neg_2E1,type,
    mono_2Ec_2Einteger_2Etint__neg_2E1: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 > mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ).

tff(mono_2Ec_2Einteger_2Etint__of__num_2E0,type,
    mono_2Ec_2Einteger_2Etint__of__num_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 ).

tff(mono_2Ec_2Einteger_2Etint__of__num_2E1,type,
    mono_2Ec_2Einteger_2Etint__of__num_2E1: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ).

tff(mono_2Ec_2Ebool_2E_7E_2E0,type,
    mono_2Ec_2Ebool_2E_7E_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29 ).

tff(mono_2Ec_2Ebool_2E_7E_2E1,type,
    mono_2Ec_2Ebool_2E_7E_2E1: mono_2Etyop_2Emin_2Ebool > mono_2Etyop_2Emin_2Ebool ).

tff(i_mono_2Etyop_2Emin_2Ebool,type,
    i_mono_2Etyop_2Emin_2Ebool: mono_2Etyop_2Emin_2Ebool > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Einteger_2Eint_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Einteger_2Eint_29: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Einteger_2Eint_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Enum_2Enum_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Enum_2Enum_29: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Enum_2Enum_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Einteger_2Eint_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Einteger_2Eint_29: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Einteger_2Eint_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Enum_2Enum_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Enum_2Enum_29: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Enum_2Enum_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 > u ).

tff(i_mono_2Etyop_2Einteger_2Eint,type,
    i_mono_2Etyop_2Einteger_2Eint: mono_2Etyop_2Einteger_2Eint > u ).

tff(i_mono_2Etyop_2Enum_2Enum,type,
    i_mono_2Etyop_2Enum_2Enum: mono_2Etyop_2Enum_2Enum > u ).

tff(i_mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,type,
    i_mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 > u ).

tff(j_mono_2Etyop_2Emin_2Ebool,type,
    j_mono_2Etyop_2Emin_2Ebool: du > mono_2Etyop_2Emin_2Ebool ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Einteger_2Eint_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Einteger_2Eint_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Einteger_2Eint_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Enum_2Enum_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Enum_2Enum_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Enum_2Enum_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Einteger_2Eint_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Einteger_2Eint_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Einteger_2Eint_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Enum_2Enum_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Enum_2Enum_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Enum_2Enum_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 ).

tff(j_mono_2Etyop_2Einteger_2Eint,type,
    j_mono_2Etyop_2Einteger_2Eint: du > mono_2Etyop_2Einteger_2Eint ).

tff(j_mono_2Etyop_2Enum_2Enum,type,
    j_mono_2Etyop_2Enum_2Enum: du > mono_2Etyop_2Enum_2Enum ).

tff(j_mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,type,
    j_mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29: du > mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ).

tff(reserved_2Eho_2Eeq__ext,axiom,
    ! [A_27a: d,A_27b: d,V0f_2E0: u,V1g_2E0: u] :
      ( ! [V2x_2E0: u] : ( s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V0f_2E0),s(A_27a,V2x_2E0))) = s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V1g_2E0),s(A_27a,V2x_2E0))) )
     => ( s(tyop_2Emin_2Efun(A_27a,A_27b),V0f_2E0) = s(tyop_2Emin_2Efun(A_27a,A_27b),V1g_2E0) ) ) ).

tff(reserved_2Eho_2Eboolext,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Ebool,V1_2E0: mono_2Etyop_2Emin_2Ebool] :
      ( ( p(V0_2E0)
      <=> p(V1_2E0) )
     => ( V0_2E0 = V1_2E0 ) ) ).

tff(reserved_2Eho_2Etruth,axiom,
    p(mono_2Ec_2Ebool_2ET_2E0) ).

tff(reserved_2Eho_2Enotfalse,axiom,
    ~ p(mono_2Ec_2Ebool_2EF_2E0) ).

tff(reserved_2Eho_2Ebool__cases__ax,axiom,
    ! [V0t_2E0: mono_2Etyop_2Emin_2Ebool] :
      ( ( V0t_2E0 = mono_2Ec_2Ebool_2ET_2E0 )
      | ( V0t_2E0 = mono_2Ec_2Ebool_2EF_2E0 ) ) ).

tff(reserved_2Eho_2Ei__thm,axiom,
    ! [A_27a: d,V0x_2E0: u] : ( s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27a),combin_i_2E0),s(A_27a,V0x_2E0))) = s(A_27a,V0x_2E0) ) ).

tff(reserved_2Eho_2Ek__thm,axiom,
    ! [A_27a: d,A_27b: d,V0x_2E0: u,V1y_2E0: u] : ( s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27b,A_27a),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27b,A_27a)),combin_k_2E0),s(A_27a,V0x_2E0))),s(A_27b,V1y_2E0))) = s(A_27a,V0x_2E0) ) ).

tff(reserved_2Eho_2Es__thm,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,V0f_2E0: u,V1g_2E0: u,V2x_2E0: u] : ( s(A_27c,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27c),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(A_27a,A_27c)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27b,A_27c)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(A_27a,A_27c))),combin_s_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27b,A_27c)),V0f_2E0))),s(tyop_2Emin_2Efun(A_27a,A_27b),V1g_2E0))),s(A_27a,V2x_2E0))) = s(A_27c,app_2E2(s(tyop_2Emin_2Efun(A_27b,A_27c),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27b,A_27c)),V0f_2E0),s(A_27a,V2x_2E0))),s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V1g_2E0),s(A_27a,V2x_2E0))))) ) ).

tff(reserved_2Elogic_2E_2F_5C,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Ebool,V1_2E0: mono_2Etyop_2Emin_2Ebool] :
      ( p(mono_2Ec_2Ebool_2E_2F_5C_2E2(V0_2E0,V1_2E0))
    <=> ( p(V0_2E0)
        & p(V1_2E0) ) ) ).

tff(reserved_2Elogic_2E_5C_2F,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Ebool,V1_2E0: mono_2Etyop_2Emin_2Ebool] :
      ( p(mono_2Ec_2Ebool_2E_5C_2F_2E2(V0_2E0,V1_2E0))
    <=> ( p(V0_2E0)
        | p(V1_2E0) ) ) ).

tff(reserved_2Elogic_2E_7E,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Ebool] :
      ( p(mono_2Ec_2Ebool_2E_7E_2E1(V0_2E0))
    <=> ~ p(V0_2E0) ) ).

tff(reserved_2Elogic_2E_3D_3D_3E,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Ebool,V1_2E0: mono_2Etyop_2Emin_2Ebool] :
      ( p(mono_2Ec_2Emin_2E_3D_3D_3E_2E2(V0_2E0,V1_2E0))
    <=> ( p(V0_2E0)
       => p(V1_2E0) ) ) ).

tff(reserved_2Elogic_2E_3D,axiom,
    ! [A_27a: d,V0_2E0: u,V1_2E0: u] :
      ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Emin_2E_3D_2E2(s(A_27a,V0_2E0),s(A_27a,V1_2E0)))))
    <=> ( s(A_27a,V0_2E0) = s(A_27a,V1_2E0) ) ) ).

tff(reserved_2Equant_2E_21,axiom,
    ! [A_27a: d,V0f_2E0: u] :
      ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Ebool_2E_21_2E1(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V0f_2E0)))))
    <=> ! [V1x_2E0: u] : p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V0f_2E0),s(A_27a,V1x_2E0))))) ) ).

tff(reserved_2Equant_2E_3F,axiom,
    ! [A_27a: d,V0f_2E0: u] :
      ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Ebool_2E_3F_2E1(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V0f_2E0)))))
    <=> ? [V1x_2E0: u] : p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V0f_2E0),s(A_27a,V1x_2E0))))) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,V0_2E0)))) = s(tyop_2Emin_2Ebool,V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool)),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool)),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool))),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool))),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Einteger_2Eint))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Einteger_2Eint))),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Einteger_2Eint))),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),tyop_2Emin_2Ebool)),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),tyop_2Emin_2Ebool)),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),tyop_2Emin_2Ebool),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),tyop_2Emin_2Ebool),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),tyop_2Emin_2Ebool),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),tyop_2Emin_2Ebool),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),tyop_2Enum_2Enum),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),tyop_2Enum_2Enum),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),tyop_2Enum_2Enum),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Einteger_2Eint_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),tyop_2Einteger_2Eint),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Einteger_2Eint_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Einteger_2Eint_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),tyop_2Einteger_2Eint),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),tyop_2Einteger_2Eint),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Einteger_2Eint),tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),tyop_2Emin_2Ebool))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Einteger_2Eint),tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),tyop_2Emin_2Ebool))),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Einteger_2Eint),tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),tyop_2Emin_2Ebool))),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Einteger_2Eint),tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Einteger_2Eint),tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),tyop_2Emin_2Ebool)),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Einteger_2Eint),tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),tyop_2Emin_2Ebool)),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Ebool),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Ebool),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Ebool)),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Ebool)),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Einteger_2Eint)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29(s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Einteger_2Eint)),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Einteger_2Eint)),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool)),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool)),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Einteger_2Eint),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29(s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Einteger_2Eint),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Einteger_2Eint),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Enum_2Enum_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Enum_2Enum),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Enum_2Enum_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Enum_2Enum_29(s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Enum_2Enum),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Enum_2Enum),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool)),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool)),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum))),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum))),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Einteger_2Eint_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Einteger_2Eint),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Einteger_2Eint_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Einteger_2Eint_29(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Einteger_2Eint),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Einteger_2Eint),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Enum_2Enum),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Enum_2Enum),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Enum_2Enum),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum))),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum))),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Einteger_2Eint),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Einteger_2Eint),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Einteger_2Eint),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Enum_2Enum_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Enum_2Enum),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Enum_2Enum_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Enum_2Enum_29(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Enum_2Enum),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Enum_2Enum),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Einteger_2Eint,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Einteger_2Eint,i_mono_2Etyop_2Einteger_2Eint(j_mono_2Etyop_2Einteger_2Eint(s(tyop_2Einteger_2Eint,V0_2E0)))) = s(tyop_2Einteger_2Eint,V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Enum_2Enum,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(j_mono_2Etyop_2Enum_2Enum(s(tyop_2Enum_2Enum,V0_2E0)))) = s(tyop_2Enum_2Enum,V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),i_mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(j_mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(s(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),V0_2E0)))) = s(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),V0_2E0) ) ).

tff(ji_2Emono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Ebool] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Einteger_2Eint))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),tyop_2Enum_2Enum),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Einteger_2Eint_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Einteger_2Eint_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Einteger_2Eint_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),tyop_2Einteger_2Eint),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Einteger_2Eint_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Einteger_2Eint),tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),tyop_2Emin_2Ebool))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Einteger_2Eint),tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29(s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Einteger_2Eint)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29(s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Einteger_2Eint),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Enum_2Enum_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Enum_2Enum_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Enum_2Enum_29(s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Enum_2Enum),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Enum_2Enum_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Einteger_2Eint_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Einteger_2Eint_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Einteger_2Eint_29(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Einteger_2Eint),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Einteger_2Eint_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Enum_2Enum),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Einteger_2Eint),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Enum_2Enum_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Enum_2Enum_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Enum_2Enum_29(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Enum_2Enum),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Enum_2Enum_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Einteger_2Eint,axiom,
    ! [V0_2E0: mono_2Etyop_2Einteger_2Eint] : ( j_mono_2Etyop_2Einteger_2Eint(s(tyop_2Einteger_2Eint,i_mono_2Etyop_2Einteger_2Eint(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Enum_2Enum,axiom,
    ! [V0_2E0: mono_2Etyop_2Enum_2Enum] : ( j_mono_2Etyop_2Enum_2Enum(s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : ( j_mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(s(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),i_mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(V0_2E0))) = V0_2E0 ) ).

tff(arityeq1_2Ec_2Ebool_2E_21_2E1_2Emono_2EA_27a,axiom,
    ! [A_27a: d,X0_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Ebool_2E_21_2E1(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),X0_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),c_2Ebool_2E_21_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),X0_2E0)))) ) ).

tff(arityeq2_2Ec_2Earithmetic_2E_2A_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Enum_2Enum,X1_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Earithmetic_2E_2A_2E2(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(mono_2Ec_2Earithmetic_2E_2A_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Earithmetic_2E_2B_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Enum_2Enum,X1_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Earithmetic_2E_2B_2E2(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(mono_2Ec_2Earithmetic_2E_2B_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Epair_2E_2C_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum,axiom,
    ! [X0_2E0: mono_2Etyop_2Enum_2Enum,X1_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Epair_2E_2C_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(mono_2Ec_2Epair_2E_2C_2E0_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Earithmetic_2E_2D_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Enum_2Enum,X1_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Earithmetic_2E_2D_2E2(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(mono_2Ec_2Earithmetic_2E_2D_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Ebool_2E_2F_5C_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Emin_2Ebool,X1_2E0: mono_2Etyop_2Emin_2Ebool] :
      ( ( p(X0_2E0)
        & p(X1_2E0) )
    <=> p(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(mono_2Ec_2Ebool_2E_2F_5C_2E0,X0_2E0),X1_2E0)) ) ).

tff(arityeq2_2Ec_2Eprim__rec_2E_3C_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Enum_2Enum,X1_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Eprim__rec_2E_3C_2E2(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29(mono_2Ec_2Eprim__rec_2E_3C_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Earithmetic_2E_3C_3D_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Enum_2Enum,X1_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Earithmetic_2E_3C_3D_2E2(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29(mono_2Ec_2Earithmetic_2E_3C_3D_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Emin_2E_3D_2E2_2Emono_2EA_27a,axiom,
    ! [A_27a: d,X0_2E0: u,X1_2E0: u] :
      ( ( s(A_27a,X0_2E0) = s(A_27a,X1_2E0) )
    <=> p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)),c_2Emin_2E_3D_2E0),s(A_27a,X0_2E0))),s(A_27a,X1_2E0))))) ) ).

tff(arityeq2_2Ec_2Emin_2E_3D_3D_3E_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Emin_2Ebool,X1_2E0: mono_2Etyop_2Emin_2Ebool] :
      ( ( p(X0_2E0)
       => p(X1_2E0) )
    <=> p(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(mono_2Ec_2Emin_2E_3D_3D_3E_2E0,X0_2E0),X1_2E0)) ) ).

tff(arityeq1_2Ec_2Ebool_2E_3F_2E1_2Emono_2EA_27a,axiom,
    ! [A_27a: d,X0_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Ebool_2E_3F_2E1(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),X0_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),c_2Ebool_2E_3F_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),X0_2E0)))) ) ).

tff(arityeq1_2Ec_2Ebool_2E_3F_21_2E1_2Emono_2Etyop_2Enum_2Enum,axiom,
    ! [X0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29] : ( mono_2Ec_2Ebool_2E_3F_21_2E1_2Emono_2Etyop_2Enum_2Enum(X0_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Emin_2Ebool(mono_2Ec_2Ebool_2E_3F_21_2E0_2Emono_2Etyop_2Enum_2Enum,X0_2E0) ) ).

tff(arityeq1_2Ec_2Emin_2E_40_2E1_2Emono_2Etyop_2Enum_2Enum,axiom,
    ! [X0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29] : ( mono_2Ec_2Emin_2E_40_2E1_2Emono_2Etyop_2Enum_2Enum(X0_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Enum_2Enum(mono_2Ec_2Emin_2E_40_2E0_2Emono_2Etyop_2Enum_2Enum,X0_2E0) ) ).

tff(arityeq1_2Ec_2Emin_2E_40_2E1_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,axiom,
    ! [X0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29] : ( mono_2Ec_2Emin_2E_40_2E1_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(X0_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(mono_2Ec_2Emin_2E_40_2E0_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,X0_2E0) ) ).

tff(arityeq1_2Ec_2Einteger_2EABS_2E1,axiom,
    ! [X0_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2EABS_2E1(X0_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Einteger_2Eint(mono_2Ec_2Einteger_2EABS_2E0,X0_2E0) ) ).

tff(arityeq1_2Ec_2Earithmetic_2EBIT1_2E1,axiom,
    ! [X0_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Earithmetic_2EBIT1_2E1(X0_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(mono_2Ec_2Earithmetic_2EBIT1_2E0,X0_2E0) ) ).

tff(arityeq1_2Ec_2Earithmetic_2EBIT2_2E1,axiom,
    ! [X0_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Earithmetic_2EBIT2_2E1(X0_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(mono_2Ec_2Earithmetic_2EBIT2_2E0,X0_2E0) ) ).

tff(arityeq3_2Ec_2Ebool_2ECOND_2E3_2Emono_2Etyop_2Emin_2Ebool,axiom,
    ! [X0_2E0: mono_2Etyop_2Emin_2Ebool,X1_2E0: mono_2Etyop_2Emin_2Ebool,X2_2E0: mono_2Etyop_2Emin_2Ebool] : ( mono_2Ec_2Ebool_2ECOND_2E3_2Emono_2Etyop_2Emin_2Ebool(X0_2E0,X1_2E0,X2_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29(mono_2Ec_2Ebool_2ECOND_2E0_2Emono_2Etyop_2Emin_2Ebool,X0_2E0),X1_2E0),X2_2E0) ) ).

tff(arityeq3_2Ec_2Ebool_2ECOND_2E3_2Emono_2Etyop_2Einteger_2Eint,axiom,
    ! [X0_2E0: mono_2Etyop_2Emin_2Ebool,X1_2E0: mono_2Etyop_2Einteger_2Eint,X2_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Ebool_2ECOND_2E3_2Emono_2Etyop_2Einteger_2Eint(X0_2E0,X1_2E0,X2_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Einteger_2Eint(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29(mono_2Ec_2Ebool_2ECOND_2E0_2Emono_2Etyop_2Einteger_2Eint,X0_2E0),X1_2E0),X2_2E0) ) ).

tff(arityeq2_2Ec_2Earithmetic_2EDIV_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Enum_2Enum,X1_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Earithmetic_2EDIV_2E2(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(mono_2Ec_2Earithmetic_2EDIV_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq1_2Ec_2Epair_2EFST_2E1_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum,axiom,
    ! [X0_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : ( mono_2Ec_2Epair_2EFST_2E1_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(X0_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Enum_2Enum(mono_2Ec_2Epair_2EFST_2E0_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum,X0_2E0) ) ).

tff(arityeq2_2Ec_2Earithmetic_2EMOD_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Enum_2Enum,X1_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Earithmetic_2EMOD_2E2(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(mono_2Ec_2Earithmetic_2EMOD_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq1_2Ec_2Earithmetic_2ENUMERAL_2E1,axiom,
    ! [X0_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Earithmetic_2ENUMERAL_2E1(X0_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(mono_2Ec_2Earithmetic_2ENUMERAL_2E0,X0_2E0) ) ).

tff(arityeq1_2Ec_2Einteger_2ENum_2E1,axiom,
    ! [X0_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2ENum_2E1(X0_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Enum_2Enum(mono_2Ec_2Einteger_2ENum_2E0,X0_2E0) ) ).

tff(arityeq3_2Ec_2Equotient_2EQUOTIENT_2E3_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Einteger_2Eint,axiom,
    ! [X0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29,X1_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29,X2_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29] : ( mono_2Ec_2Equotient_2EQUOTIENT_2E3_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Einteger_2Eint(X0_2E0,X1_2E0,X2_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29(mono_2Ec_2Equotient_2EQUOTIENT_2E0_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Einteger_2Eint,X0_2E0),X1_2E0),X2_2E0) ) ).

tff(arityeq1_2Ec_2Epair_2ESND_2E1_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum,axiom,
    ! [X0_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : ( mono_2Ec_2Epair_2ESND_2E1_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(X0_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Enum_2Enum(mono_2Ec_2Epair_2ESND_2E0_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum,X0_2E0) ) ).

tff(arityeq1_2Ec_2Enum_2ESUC_2E1,axiom,
    ! [X0_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Enum_2ESUC_2E1(X0_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(mono_2Ec_2Enum_2ESUC_2E0,X0_2E0) ) ).

tff(arityeq2_2Ec_2Ebool_2ETYPE__DEFINITION_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Einteger_2Eint,axiom,
    ! [X0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29,X1_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29] : ( mono_2Ec_2Ebool_2ETYPE__DEFINITION_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Einteger_2Eint(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29(mono_2Ec_2Ebool_2ETYPE__DEFINITION_2E0_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Einteger_2Eint,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Ebool_2E_5C_2F_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Emin_2Ebool,X1_2E0: mono_2Etyop_2Emin_2Ebool] :
      ( ( p(X0_2E0)
        | p(X1_2E0) )
    <=> p(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(mono_2Ec_2Ebool_2E_5C_2F_2E0,X0_2E0),X1_2E0)) ) ).

tff(arityeq1_2Ec_2Einteger_2Eint__ABS_2E1,axiom,
    ! [X0_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : ( mono_2Ec_2Einteger_2Eint__ABS_2E1(X0_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Einteger_2Eint(mono_2Ec_2Einteger_2Eint__ABS_2E0,X0_2E0) ) ).

tff(arityeq1_2Ec_2Einteger_2Eint__ABS__CLASS_2E1,axiom,
    ! [X0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29] : ( mono_2Ec_2Einteger_2Eint__ABS__CLASS_2E1(X0_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Einteger_2Eint(mono_2Ec_2Einteger_2Eint__ABS__CLASS_2E0,X0_2E0) ) ).

tff(arityeq1_2Ec_2Einteger_2Eint__REP_2E1,axiom,
    ! [X0_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__REP_2E1(X0_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(mono_2Ec_2Einteger_2Eint__REP_2E0,X0_2E0) ) ).

tff(arityeq1_2Ec_2Einteger_2Eint__REP__CLASS_2E1,axiom,
    ! [X0_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__REP__CLASS_2E1(X0_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29(mono_2Ec_2Einteger_2Eint__REP__CLASS_2E0,X0_2E0) ) ).

tff(arityeq2_2Ec_2Einteger_2Eint__add_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Einteger_2Eint,X1_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__add_2E2(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Einteger_2Eint(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29(mono_2Ec_2Einteger_2Eint__add_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Einteger_2Eint__div_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Einteger_2Eint,X1_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__div_2E2(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Einteger_2Eint(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29(mono_2Ec_2Einteger_2Eint__div_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Einteger_2Eint__divides_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Einteger_2Eint,X1_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__divides_2E2(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(mono_2Ec_2Einteger_2Eint__divides_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Einteger_2Eint__ge_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Einteger_2Eint,X1_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__ge_2E2(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(mono_2Ec_2Einteger_2Eint__ge_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Einteger_2Eint__gt_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Einteger_2Eint,X1_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__gt_2E2(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(mono_2Ec_2Einteger_2Eint__gt_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Einteger_2Eint__le_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Einteger_2Eint,X1_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__le_2E2(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(mono_2Ec_2Einteger_2Eint__le_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Einteger_2Eint__lt_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Einteger_2Eint,X1_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__lt_2E2(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(mono_2Ec_2Einteger_2Eint__lt_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Einteger_2Eint__mod_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Einteger_2Eint,X1_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__mod_2E2(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Einteger_2Eint(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29(mono_2Ec_2Einteger_2Eint__mod_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Einteger_2Eint__mul_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Einteger_2Eint,X1_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__mul_2E2(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Einteger_2Eint(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29(mono_2Ec_2Einteger_2Eint__mul_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq1_2Ec_2Einteger_2Eint__neg_2E1,axiom,
    ! [X0_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__neg_2E1(X0_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Einteger_2Eint(mono_2Ec_2Einteger_2Eint__neg_2E0,X0_2E0) ) ).

tff(arityeq1_2Ec_2Einteger_2Eint__of__num_2E1,axiom,
    ! [X0_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Einteger_2Eint__of__num_2E1(X0_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Einteger_2Eint(mono_2Ec_2Einteger_2Eint__of__num_2E0,X0_2E0) ) ).

tff(arityeq2_2Ec_2Einteger_2Eint__quot_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Einteger_2Eint,X1_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__quot_2E2(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Einteger_2Eint(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29(mono_2Ec_2Einteger_2Eint__quot_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Einteger_2Eint__rem_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Einteger_2Eint,X1_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__rem_2E2(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Einteger_2Eint(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29(mono_2Ec_2Einteger_2Eint__rem_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Einteger_2Eint__sub_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Einteger_2Eint,X1_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__sub_2E2(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Einteger_2Eint(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29(mono_2Ec_2Einteger_2Eint__sub_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Einteger_2Etint__add_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,X1_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : ( mono_2Ec_2Einteger_2Etint__add_2E2(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(mono_2Ec_2Einteger_2Etint__add_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq1_2Ec_2Einteger_2Etint__eq_2E1,axiom,
    ! [X0_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : ( mono_2Ec_2Einteger_2Etint__eq_2E1(X0_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29(mono_2Ec_2Einteger_2Etint__eq_2E0,X0_2E0) ) ).

tff(arityeq2_2Ec_2Einteger_2Etint__eq_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,X1_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : ( mono_2Ec_2Einteger_2Etint__eq_2E2(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29(mono_2Ec_2Einteger_2Etint__eq_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Einteger_2Etint__lt_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,X1_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : ( mono_2Ec_2Einteger_2Etint__lt_2E2(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29(mono_2Ec_2Einteger_2Etint__lt_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Einteger_2Etint__mul_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,X1_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : ( mono_2Ec_2Einteger_2Etint__mul_2E2(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(mono_2Ec_2Einteger_2Etint__mul_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq1_2Ec_2Einteger_2Etint__neg_2E1,axiom,
    ! [X0_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : ( mono_2Ec_2Einteger_2Etint__neg_2E1(X0_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(mono_2Ec_2Einteger_2Etint__neg_2E0,X0_2E0) ) ).

tff(arityeq1_2Ec_2Einteger_2Etint__of__num_2E1,axiom,
    ! [X0_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Einteger_2Etint__of__num_2E1(X0_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(mono_2Ec_2Einteger_2Etint__of__num_2E0,X0_2E0) ) ).

tff(arityeq1_2Ec_2Ebool_2E_7E_2E1,axiom,
    ! [X0_2E0: mono_2Etyop_2Emin_2Ebool] :
      ( ~ p(X0_2E0)
    <=> p(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool(mono_2Ec_2Ebool_2E_7E_2E0,X0_2E0)) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29,V1_2E0: mono_2Etyop_2Emin_2Ebool] : ( s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(V0_2E0)),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29,V1_2E0: mono_2Etyop_2Emin_2Ebool] : ( s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29(V0_2E0)),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_29,V1_2E0: mono_2Etyop_2Emin_2Ebool] : ( s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_29(V0_2E0)),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29_29,V1_2E0: mono_2Etyop_2Emin_2Ebool] : ( s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Einteger_2Eint)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Einteger_2Eint)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Einteger_2Eint))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29_29(V0_2E0)),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29_29,V1_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29] : ( s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29_29(V0_2E0)),s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29,V1_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29] : ( s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Emin_2Ebool(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29(V0_2E0)),s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_20mono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29,V1_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29] : ( s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_20mono_2Etyop_2Emin_2Ebool(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29(V0_2E0)),s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29,V1_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29] : ( s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Emin_2Ebool(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29(V0_2E0)),s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Enum_2Enum,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29,V1_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29] : ( s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Enum_2Enum(V0_2E0,V1_2E0))) = s(tyop_2Enum_2Enum,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),tyop_2Enum_2Enum),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29(V0_2E0)),s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29,V1_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29] : ( s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Emin_2Ebool(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29(V0_2E0)),s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Einteger_2Eint,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Einteger_2Eint_29,V1_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29] : ( s(tyop_2Einteger_2Eint,i_mono_2Etyop_2Einteger_2Eint(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Einteger_2Eint(V0_2E0,V1_2E0))) = s(tyop_2Einteger_2Eint,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),tyop_2Einteger_2Eint),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Einteger_2Eint_29(V0_2E0)),s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,V1_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29] : ( s(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),i_mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(V0_2E0,V1_2E0))) = s(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(V0_2E0)),s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29_29,V1_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29] : ( s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Einteger_2Eint),tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Einteger_2Eint),tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Einteger_2Eint),tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),tyop_2Emin_2Ebool))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29_29(V0_2E0)),s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29,V1_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29] : ( s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Einteger_2Eint),tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29(V0_2E0)),s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Einteger_2Eint),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29,V1_2E0: mono_2Etyop_2Einteger_2Eint] : ( s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(V0_2E0)),s(tyop_2Einteger_2Eint,i_mono_2Etyop_2Einteger_2Eint(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29,V1_2E0: mono_2Etyop_2Einteger_2Eint] : ( s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29(V0_2E0)),s(tyop_2Einteger_2Eint,i_mono_2Etyop_2Einteger_2Eint(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29,V1_2E0: mono_2Etyop_2Einteger_2Eint] : ( s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Einteger_2Eint),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Einteger_2Eint),app_2E2(s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Einteger_2Eint)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29(V0_2E0)),s(tyop_2Einteger_2Eint,i_mono_2Etyop_2Einteger_2Eint(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29,V1_2E0: mono_2Etyop_2Einteger_2Eint] : ( s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29(V0_2E0)),s(tyop_2Einteger_2Eint,i_mono_2Etyop_2Einteger_2Eint(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29,V1_2E0: mono_2Etyop_2Einteger_2Eint] : ( s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29(V0_2E0)),s(tyop_2Einteger_2Eint,i_mono_2Etyop_2Einteger_2Eint(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Einteger_2Eint,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29,V1_2E0: mono_2Etyop_2Einteger_2Eint] : ( s(tyop_2Einteger_2Eint,i_mono_2Etyop_2Einteger_2Eint(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Einteger_2Eint(V0_2E0,V1_2E0))) = s(tyop_2Einteger_2Eint,app_2E2(s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Einteger_2Eint),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29(V0_2E0)),s(tyop_2Einteger_2Eint,i_mono_2Etyop_2Einteger_2Eint(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Enum_2Enum,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Enum_2Enum_29,V1_2E0: mono_2Etyop_2Einteger_2Eint] : ( s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Enum_2Enum(V0_2E0,V1_2E0))) = s(tyop_2Enum_2Enum,app_2E2(s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Enum_2Enum),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Enum_2Enum_29(V0_2E0)),s(tyop_2Einteger_2Eint,i_mono_2Etyop_2Einteger_2Eint(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,V1_2E0: mono_2Etyop_2Einteger_2Eint] : ( s(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),i_mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(V0_2E0,V1_2E0))) = s(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),app_2E2(s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(V0_2E0)),s(tyop_2Einteger_2Eint,i_mono_2Etyop_2Einteger_2Eint(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29,V1_2E0: mono_2Etyop_2Enum_2Enum] : ( s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Ebool(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29(V0_2E0)),s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29,V1_2E0: mono_2Etyop_2Enum_2Enum] : ( s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29(V0_2E0)),s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,V1_2E0: mono_2Etyop_2Enum_2Enum] : ( s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Enum_2Enum),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Enum_2Enum),app_2E2(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(V0_2E0)),s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29,V1_2E0: mono_2Etyop_2Enum_2Enum] : ( s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29(V0_2E0)),s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Einteger_2Eint,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Einteger_2Eint_29,V1_2E0: mono_2Etyop_2Enum_2Enum] : ( s(tyop_2Einteger_2Eint,i_mono_2Etyop_2Einteger_2Eint(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Einteger_2Eint(V0_2E0,V1_2E0))) = s(tyop_2Einteger_2Eint,app_2E2(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Einteger_2Eint),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Einteger_2Eint_29(V0_2E0)),s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V1_2E0: mono_2Etyop_2Enum_2Enum] : ( s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(V0_2E0,V1_2E0))) = s(tyop_2Enum_2Enum,app_2E2(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Enum_2Enum),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(V0_2E0)),s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,V1_2E0: mono_2Etyop_2Enum_2Enum] : ( s(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),i_mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(V0_2E0,V1_2E0))) = s(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),app_2E2(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(V0_2E0)),s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29,V1_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : ( s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Emin_2Ebool(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29(V0_2E0)),s(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),i_mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29,V1_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : ( s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29(mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29(V0_2E0)),s(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),i_mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29,V1_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : ( s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29(V0_2E0)),s(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),i_mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Einteger_2Eint,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29,V1_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : ( s(tyop_2Einteger_2Eint,i_mono_2Etyop_2Einteger_2Eint(mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Einteger_2Eint(V0_2E0,V1_2E0))) = s(tyop_2Einteger_2Eint,app_2E2(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Einteger_2Eint),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29(V0_2E0)),s(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),i_mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Enum_2Enum,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Enum_2Enum_29,V1_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : ( s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Enum_2Enum(V0_2E0,V1_2E0))) = s(tyop_2Enum_2Enum,app_2E2(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Enum_2Enum),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Enum_2Enum_29(V0_2E0)),s(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),i_mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,V1_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : ( s(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),i_mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(V0_2E0,V1_2E0))) = s(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),app_2E2(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(V0_2E0)),s(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),i_mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Ec_2Epair_2E_2C_2E0_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum,axiom,
    s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29(mono_2Ec_2Epair_2E_2C_2E0_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum)) = s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum))),c_2Epair_2E_2C_2E0) ).

tff(monoeq_2Emono_2Ec_2Epair_2E_2C_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum,axiom,
    ! [V0_2E0: mono_2Etyop_2Enum_2Enum,V1_2E0: mono_2Etyop_2Enum_2Enum] : ( s(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),i_mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(mono_2Ec_2Epair_2E_2C_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(V0_2E0,V1_2E0))) = s(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),c_2Epair_2E_2C_2E2(s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(V0_2E0)),s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Ec_2Ebool_2E_3F_21_2E0_2Emono_2Etyop_2Enum_2Enum,axiom,
    s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29(mono_2Ec_2Ebool_2E_3F_21_2E0_2Emono_2Etyop_2Enum_2Enum)) = s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),c_2Ebool_2E_3F_21_2E0) ).

tff(monoeq_2Emono_2Ec_2Ebool_2E_3F_21_2E1_2Emono_2Etyop_2Enum_2Enum,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29] : ( s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(mono_2Ec_2Ebool_2E_3F_21_2E1_2Emono_2Etyop_2Enum_2Enum(V0_2E0))) = s(tyop_2Emin_2Ebool,c_2Ebool_2E_3F_21_2E1(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29(V0_2E0)))) ) ).

tff(monoeq_2Emono_2Ec_2Emin_2E_40_2E0_2Emono_2Etyop_2Enum_2Enum,axiom,
    s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),tyop_2Enum_2Enum),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29(mono_2Ec_2Emin_2E_40_2E0_2Emono_2Etyop_2Enum_2Enum)) = s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),tyop_2Enum_2Enum),c_2Emin_2E_40_2E0) ).

tff(monoeq_2Emono_2Ec_2Emin_2E_40_2E1_2Emono_2Etyop_2Enum_2Enum,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29] : ( s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(mono_2Ec_2Emin_2E_40_2E1_2Emono_2Etyop_2Enum_2Enum(V0_2E0))) = s(tyop_2Enum_2Enum,c_2Emin_2E_40_2E1(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29(V0_2E0)))) ) ).

tff(monoeq_2Emono_2Ec_2Emin_2E_40_2E0_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,axiom,
    s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(mono_2Ec_2Emin_2E_40_2E0_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29)) = s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),c_2Emin_2E_40_2E0) ).

tff(monoeq_2Emono_2Ec_2Emin_2E_40_2E1_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29] : ( s(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),i_mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(mono_2Ec_2Emin_2E_40_2E1_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(V0_2E0))) = s(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),c_2Emin_2E_40_2E1(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29(V0_2E0)))) ) ).

tff(monoeq_2Emono_2Ec_2Ebool_2ECOND_2E0_2Emono_2Etyop_2Emin_2Ebool,axiom,
    s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_29(mono_2Ec_2Ebool_2ECOND_2E0_2Emono_2Etyop_2Emin_2Ebool)) = s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool))),c_2Ebool_2ECOND_2E0) ).

tff(monoeq_2Emono_2Ec_2Ebool_2ECOND_2E3_2Emono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Ebool,V1_2E0: mono_2Etyop_2Emin_2Ebool,V2_2E0: mono_2Etyop_2Emin_2Ebool] : ( s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(mono_2Ec_2Ebool_2ECOND_2E3_2Emono_2Etyop_2Emin_2Ebool(V0_2E0,V1_2E0,V2_2E0))) = s(tyop_2Emin_2Ebool,c_2Ebool_2ECOND_2E3(s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V0_2E0)),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V1_2E0)),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V2_2E0)))) ) ).

tff(monoeq_2Emono_2Ec_2Ebool_2ECOND_2E0_2Emono_2Etyop_2Einteger_2Eint,axiom,
    s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Einteger_2Eint))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Einteger_2Eint_29_29_29(mono_2Ec_2Ebool_2ECOND_2E0_2Emono_2Etyop_2Einteger_2Eint)) = s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Einteger_2Eint))),c_2Ebool_2ECOND_2E0) ).

tff(monoeq_2Emono_2Ec_2Ebool_2ECOND_2E3_2Emono_2Etyop_2Einteger_2Eint,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Ebool,V1_2E0: mono_2Etyop_2Einteger_2Eint,V2_2E0: mono_2Etyop_2Einteger_2Eint] : ( s(tyop_2Einteger_2Eint,i_mono_2Etyop_2Einteger_2Eint(mono_2Ec_2Ebool_2ECOND_2E3_2Emono_2Etyop_2Einteger_2Eint(V0_2E0,V1_2E0,V2_2E0))) = s(tyop_2Einteger_2Eint,c_2Ebool_2ECOND_2E3(s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V0_2E0)),s(tyop_2Einteger_2Eint,i_mono_2Etyop_2Einteger_2Eint(V1_2E0)),s(tyop_2Einteger_2Eint,i_mono_2Etyop_2Einteger_2Eint(V2_2E0)))) ) ).

tff(monoeq_2Emono_2Ec_2Epair_2EFST_2E0_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum,axiom,
    s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Enum_2Enum),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Enum_2Enum_29(mono_2Ec_2Epair_2EFST_2E0_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum)) = s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Enum_2Enum),c_2Epair_2EFST_2E0) ).

tff(monoeq_2Emono_2Ec_2Epair_2EFST_2E1_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum,axiom,
    ! [V0_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : ( s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(mono_2Ec_2Epair_2EFST_2E1_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(V0_2E0))) = s(tyop_2Enum_2Enum,c_2Epair_2EFST_2E1(s(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),i_mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(V0_2E0)))) ) ).

tff(monoeq_2Emono_2Ec_2Equotient_2EQUOTIENT_2E0_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Einteger_2Eint,axiom,
    s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Einteger_2Eint),tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),tyop_2Emin_2Ebool))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_2Ctyop_2Emin_2Ebool_29_29_29(mono_2Ec_2Equotient_2EQUOTIENT_2E0_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Einteger_2Eint)) = s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Einteger_2Eint),tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),tyop_2Emin_2Ebool))),c_2Equotient_2EQUOTIENT_2E0) ).

tff(monoeq_2Emono_2Ec_2Equotient_2EQUOTIENT_2E3_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Einteger_2Eint,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29,V1_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29,V2_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29] : ( s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(mono_2Ec_2Equotient_2EQUOTIENT_2E3_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Einteger_2Eint(V0_2E0,V1_2E0,V2_2E0))) = s(tyop_2Emin_2Ebool,c_2Equotient_2EQUOTIENT_2E3(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29(V0_2E0)),s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Einteger_2Eint),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Einteger_2Eint_29(V1_2E0)),s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(V2_2E0)))) ) ).

tff(monoeq_2Emono_2Ec_2Epair_2ESND_2E0_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum,axiom,
    s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Enum_2Enum),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Enum_2Enum_29(mono_2Ec_2Epair_2ESND_2E0_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum)) = s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Enum_2Enum),c_2Epair_2ESND_2E0) ).

tff(monoeq_2Emono_2Ec_2Epair_2ESND_2E1_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum,axiom,
    ! [V0_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : ( s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(mono_2Ec_2Epair_2ESND_2E1_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(V0_2E0))) = s(tyop_2Enum_2Enum,c_2Epair_2ESND_2E1(s(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),i_mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(V0_2E0)))) ) ).

tff(monoeq_2Emono_2Ec_2Ebool_2ETYPE__DEFINITION_2E0_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Einteger_2Eint,axiom,
    s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29_29(mono_2Ec_2Ebool_2ETYPE__DEFINITION_2E0_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Einteger_2Eint)) = s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),tyop_2Emin_2Ebool)),c_2Ebool_2ETYPE__DEFINITION_2E0) ).

tff(monoeq_2Emono_2Ec_2Ebool_2ETYPE__DEFINITION_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Einteger_2Eint,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29,V1_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29] : ( s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(mono_2Ec_2Ebool_2ETYPE__DEFINITION_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Einteger_2Eint(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Ebool,c_2Ebool_2ETYPE__DEFINITION_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29(V0_2E0)),s(tyop_2Emin_2Efun(tyop_2Einteger_2Eint,tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Enum_2Enum,tyop_2Enum_2Enum),tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29(V1_2E0)))) ) ).

tff(thm_2Einteger_2Eint__ge,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__ge_2E2(V0x_2E0,V1y_2E0) = mono_2Ec_2Einteger_2Eint__le_2E2(V1y_2E0,V0x_2E0) ) ).

tff(thm_2Einteger_2Eint__gt,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__gt_2E2(V0x_2E0,V1y_2E0) = mono_2Ec_2Einteger_2Eint__lt_2E2(V1y_2E0,V0x_2E0) ) ).

tff(thm_2Einteger_2Eint__le,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__le_2E2(V0x_2E0,V1y_2E0))
    <=> ~ p(mono_2Ec_2Einteger_2Eint__lt_2E2(V1y_2E0,V0x_2E0)) ) ).

tff(thm_2Einteger_2Eint__sub,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__sub_2E2(V0x_2E0,V1y_2E0) = mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,mono_2Ec_2Einteger_2Eint__neg_2E1(V1y_2E0)) ) ).

tff(thm_2Einteger_2Etint__0,axiom,
    mono_2Ec_2Einteger_2Etint__0_2E0 = mono_2Ec_2Epair_2E_2C_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0)),mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0))) ).

tff(thm_2Einteger_2Etint__1,axiom,
    mono_2Ec_2Einteger_2Etint__1_2E0 = mono_2Ec_2Epair_2E_2C_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(mono_2Ec_2Earithmetic_2E_2B_2E2(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0)),mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0))),mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0))) ).

tff(thm_2Einteger_2Etint__neg,axiom,
    ! [V0x_2E0: mono_2Etyop_2Enum_2Enum,V1y_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Einteger_2Etint__neg_2E1(mono_2Ec_2Epair_2E_2C_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(V0x_2E0,V1y_2E0)) = mono_2Ec_2Epair_2E_2C_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(V1y_2E0,V0x_2E0) ) ).

tff(thm_2Einteger_2Etint__add,axiom,
    ! [V0x1_2E0: mono_2Etyop_2Enum_2Enum,V1y1_2E0: mono_2Etyop_2Enum_2Enum,V2x2_2E0: mono_2Etyop_2Enum_2Enum,V3y2_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Einteger_2Etint__add_2E2(mono_2Ec_2Epair_2E_2C_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(V0x1_2E0,V1y1_2E0),mono_2Ec_2Epair_2E_2C_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(V2x2_2E0,V3y2_2E0)) = mono_2Ec_2Epair_2E_2C_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(mono_2Ec_2Earithmetic_2E_2B_2E2(V0x1_2E0,V2x2_2E0),mono_2Ec_2Earithmetic_2E_2B_2E2(V1y1_2E0,V3y2_2E0)) ) ).

tff(thm_2Einteger_2Etint__mul,axiom,
    ! [V0x1_2E0: mono_2Etyop_2Enum_2Enum,V1y1_2E0: mono_2Etyop_2Enum_2Enum,V2x2_2E0: mono_2Etyop_2Enum_2Enum,V3y2_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Einteger_2Etint__mul_2E2(mono_2Ec_2Epair_2E_2C_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(V0x1_2E0,V1y1_2E0),mono_2Ec_2Epair_2E_2C_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(V2x2_2E0,V3y2_2E0)) = mono_2Ec_2Epair_2E_2C_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(mono_2Ec_2Earithmetic_2E_2B_2E2(mono_2Ec_2Earithmetic_2E_2A_2E2(V0x1_2E0,V2x2_2E0),mono_2Ec_2Earithmetic_2E_2A_2E2(V1y1_2E0,V3y2_2E0)),mono_2Ec_2Earithmetic_2E_2B_2E2(mono_2Ec_2Earithmetic_2E_2A_2E2(V0x1_2E0,V3y2_2E0),mono_2Ec_2Earithmetic_2E_2A_2E2(V1y1_2E0,V2x2_2E0))) ) ).

tff(thm_2Einteger_2Etint__lt,axiom,
    ! [V0x1_2E0: mono_2Etyop_2Enum_2Enum,V1y1_2E0: mono_2Etyop_2Enum_2Enum,V2x2_2E0: mono_2Etyop_2Enum_2Enum,V3y2_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Einteger_2Etint__lt_2E2(mono_2Ec_2Epair_2E_2C_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(V0x1_2E0,V1y1_2E0),mono_2Ec_2Epair_2E_2C_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(V2x2_2E0,V3y2_2E0)) = mono_2Ec_2Eprim__rec_2E_3C_2E2(mono_2Ec_2Earithmetic_2E_2B_2E2(V0x1_2E0,V3y2_2E0),mono_2Ec_2Earithmetic_2E_2B_2E2(V2x2_2E0,V1y1_2E0)) ) ).

tff(thm_2Einteger_2Etint__eq,axiom,
    ! [V0x1_2E0: mono_2Etyop_2Enum_2Enum,V1y1_2E0: mono_2Etyop_2Enum_2Enum,V2x2_2E0: mono_2Etyop_2Enum_2Enum,V3y2_2E0: mono_2Etyop_2Enum_2Enum] :
      ( p(mono_2Ec_2Einteger_2Etint__eq_2E2(mono_2Ec_2Epair_2E_2C_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(V0x1_2E0,V1y1_2E0),mono_2Ec_2Epair_2E_2C_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(V2x2_2E0,V3y2_2E0)))
    <=> ( mono_2Ec_2Earithmetic_2E_2B_2E2(V0x1_2E0,V3y2_2E0) = mono_2Ec_2Earithmetic_2E_2B_2E2(V2x2_2E0,V1y1_2E0) ) ) ).

tff(thm_2Einteger_2Etint__of__num,axiom,
    ( ( mono_2Ec_2Einteger_2Etint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) = mono_2Ec_2Einteger_2Etint__0_2E0 )
    & ! [V0n_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Einteger_2Etint__of__num_2E1(mono_2Ec_2Enum_2ESUC_2E1(V0n_2E0)) = mono_2Ec_2Einteger_2Etint__add_2E2(mono_2Ec_2Einteger_2Etint__of__num_2E1(V0n_2E0),mono_2Ec_2Einteger_2Etint__1_2E0) ) ) ).

tff(thm_2Einteger_2Eint__TY__DEF,axiom,
    ! [F0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29] :
      ( ! [V1c_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29] :
          ( p(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Emin_2Ebool(F0_2E0,V1c_2E0))
        <=> ? [V2r_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] :
              ( p(mono_2Ec_2Einteger_2Etint__eq_2E2(V2r_2E0,V2r_2E0))
              & ( V1c_2E0 = mono_2Ec_2Einteger_2Etint__eq_2E1(V2r_2E0) ) ) )
     => ? [V0rep_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_29] : p(mono_2Ec_2Ebool_2ETYPE__DEFINITION_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Einteger_2Eint(F0_2E0,V0rep_2E0)) ) ).

tff(thm_2Einteger_2Eint__bijections,axiom,
    ( ! [V0a_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__ABS__CLASS_2E1(mono_2Ec_2Einteger_2Eint__REP__CLASS_2E1(V0a_2E0)) = V0a_2E0 )
    & ! [V1r_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29] :
        ( ? [V2r_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] :
            ( p(mono_2Ec_2Einteger_2Etint__eq_2E2(V2r_2E0,V2r_2E0))
            & ( V1r_2E0 = mono_2Ec_2Einteger_2Etint__eq_2E1(V2r_2E0) ) )
      <=> ( mono_2Ec_2Einteger_2Eint__REP__CLASS_2E1(mono_2Ec_2Einteger_2Eint__ABS__CLASS_2E1(V1r_2E0)) = V1r_2E0 ) ) ) ).

tff(thm_2Einteger_2Eint__REP__def,axiom,
    ! [V0a_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__REP_2E1(V0a_2E0) = mono_2Ec_2Emin_2E_40_2E1_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(mono_2Ec_2Einteger_2Eint__REP__CLASS_2E1(V0a_2E0)) ) ).

tff(thm_2Einteger_2Eint__ABS__def,axiom,
    ! [V0r_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : ( mono_2Ec_2Einteger_2Eint__ABS_2E1(V0r_2E0) = mono_2Ec_2Einteger_2Eint__ABS__CLASS_2E1(mono_2Ec_2Einteger_2Etint__eq_2E1(V0r_2E0)) ) ).

tff(thm_2Einteger_2Eint__0,axiom,
    mono_2Ec_2Einteger_2Eint__0_2E0 = mono_2Ec_2Einteger_2Eint__ABS_2E1(mono_2Ec_2Einteger_2Etint__0_2E0) ).

tff(thm_2Einteger_2Eint__1,axiom,
    mono_2Ec_2Einteger_2Eint__1_2E0 = mono_2Ec_2Einteger_2Eint__ABS_2E1(mono_2Ec_2Einteger_2Etint__1_2E0) ).

tff(thm_2Einteger_2Eint__neg,axiom,
    ! [V0T1_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__neg_2E1(V0T1_2E0) = mono_2Ec_2Einteger_2Eint__ABS_2E1(mono_2Ec_2Einteger_2Etint__neg_2E1(mono_2Ec_2Einteger_2Eint__REP_2E1(V0T1_2E0))) ) ).

tff(thm_2Einteger_2Eint__add,axiom,
    ! [V0T1_2E0: mono_2Etyop_2Einteger_2Eint,V1T2_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__add_2E2(V0T1_2E0,V1T2_2E0) = mono_2Ec_2Einteger_2Eint__ABS_2E1(mono_2Ec_2Einteger_2Etint__add_2E2(mono_2Ec_2Einteger_2Eint__REP_2E1(V0T1_2E0),mono_2Ec_2Einteger_2Eint__REP_2E1(V1T2_2E0))) ) ).

tff(thm_2Einteger_2Eint__mul,axiom,
    ! [V0T1_2E0: mono_2Etyop_2Einteger_2Eint,V1T2_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__mul_2E2(V0T1_2E0,V1T2_2E0) = mono_2Ec_2Einteger_2Eint__ABS_2E1(mono_2Ec_2Einteger_2Etint__mul_2E2(mono_2Ec_2Einteger_2Eint__REP_2E1(V0T1_2E0),mono_2Ec_2Einteger_2Eint__REP_2E1(V1T2_2E0))) ) ).

tff(thm_2Einteger_2Eint__lt,axiom,
    ! [V0T1_2E0: mono_2Etyop_2Einteger_2Eint,V1T2_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__lt_2E2(V0T1_2E0,V1T2_2E0) = mono_2Ec_2Einteger_2Etint__lt_2E2(mono_2Ec_2Einteger_2Eint__REP_2E1(V0T1_2E0),mono_2Ec_2Einteger_2Eint__REP_2E1(V1T2_2E0)) ) ).

tff(thm_2Einteger_2ENum,axiom,
    ! [F0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29] :
      ( ! [V0i_2E0: mono_2Etyop_2Einteger_2Eint,V1n_2E0: mono_2Etyop_2Enum_2Enum] :
          ( p(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29(F0_2E0,V0i_2E0),V1n_2E0))
        <=> ( V0i_2E0 = mono_2Ec_2Einteger_2Eint__of__num_2E1(V1n_2E0) ) )
     => ! [V0i_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2ENum_2E1(V0i_2E0) = mono_2Ec_2Emin_2E_40_2E1_2Emono_2Etyop_2Enum_2Enum(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29(F0_2E0,V0i_2E0)) ) ) ).

tff(thm_2Einteger_2Eint__div,axiom,
    ! [F0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29,F1_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29] :
      ( ! [V0i_2E0: mono_2Etyop_2Einteger_2Eint,V1j_2E0: mono_2Etyop_2Einteger_2Eint] :
          ( p(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(F0_2E0,V0i_2E0),V1j_2E0))
        <=> ( mono_2Ec_2Earithmetic_2EMOD_2E2(mono_2Ec_2Einteger_2ENum_2E1(mono_2Ec_2Einteger_2Eint__neg_2E1(V0i_2E0)),mono_2Ec_2Einteger_2ENum_2E1(V1j_2E0)) = mono_2Ec_2Enum_2E0_2E0 ) )
     => ( ! [V0i_2E0: mono_2Etyop_2Einteger_2Eint,V1j_2E0: mono_2Etyop_2Einteger_2Eint] :
            ( p(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(F1_2E0,V0i_2E0),V1j_2E0))
          <=> ( mono_2Ec_2Earithmetic_2EMOD_2E2(mono_2Ec_2Einteger_2ENum_2E1(V0i_2E0),mono_2Ec_2Einteger_2ENum_2E1(mono_2Ec_2Einteger_2Eint__neg_2E1(V1j_2E0))) = mono_2Ec_2Enum_2E0_2E0 ) )
       => ! [V0i_2E0: mono_2Etyop_2Einteger_2Eint,V1j_2E0: mono_2Etyop_2Einteger_2Eint] :
            ( ( V1j_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
           => ( mono_2Ec_2Einteger_2Eint__div_2E2(V0i_2E0,V1j_2E0) = mono_2Ec_2Ebool_2ECOND_2E3_2Emono_2Etyop_2Einteger_2Eint(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V1j_2E0),mono_2Ec_2Ebool_2ECOND_2E3_2Emono_2Etyop_2Einteger_2Eint(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0i_2E0),mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2EDIV_2E2(mono_2Ec_2Einteger_2ENum_2E1(V0i_2E0),mono_2Ec_2Einteger_2ENum_2E1(V1j_2E0))),mono_2Ec_2Einteger_2Eint__add_2E2(mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2EDIV_2E2(mono_2Ec_2Einteger_2ENum_2E1(mono_2Ec_2Einteger_2Eint__neg_2E1(V0i_2E0)),mono_2Ec_2Einteger_2ENum_2E1(V1j_2E0)))),mono_2Ec_2Ebool_2ECOND_2E3_2Emono_2Etyop_2Einteger_2Eint(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(F0_2E0,V0i_2E0),V1j_2E0),mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0))))))),mono_2Ec_2Ebool_2ECOND_2E3_2Emono_2Etyop_2Einteger_2Eint(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0i_2E0),mono_2Ec_2Einteger_2Eint__add_2E2(mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2EDIV_2E2(mono_2Ec_2Einteger_2ENum_2E1(V0i_2E0),mono_2Ec_2Einteger_2ENum_2E1(mono_2Ec_2Einteger_2Eint__neg_2E1(V1j_2E0))))),mono_2Ec_2Ebool_2ECOND_2E3_2Emono_2Etyop_2Einteger_2Eint(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(F1_2E0,V0i_2E0),V1j_2E0),mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0)))))),mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2EDIV_2E2(mono_2Ec_2Einteger_2ENum_2E1(mono_2Ec_2Einteger_2Eint__neg_2E1(V0i_2E0)),mono_2Ec_2Einteger_2ENum_2E1(mono_2Ec_2Einteger_2Eint__neg_2E1(V1j_2E0)))))) ) ) ) ) ).

tff(thm_2Einteger_2Eint__mod,axiom,
    ! [V0i_2E0: mono_2Etyop_2Einteger_2Eint,V1j_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V1j_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ( mono_2Ec_2Einteger_2Eint__mod_2E2(V0i_2E0,V1j_2E0) = mono_2Ec_2Einteger_2Eint__sub_2E2(V0i_2E0,mono_2Ec_2Einteger_2Eint__mul_2E2(mono_2Ec_2Einteger_2Eint__div_2E2(V0i_2E0,V1j_2E0),V1j_2E0)) ) ) ).

tff(thm_2Einteger_2EINT__ABS,axiom,
    ! [V0n_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2EABS_2E1(V0n_2E0) = mono_2Ec_2Ebool_2ECOND_2E3_2Emono_2Etyop_2Einteger_2Eint(mono_2Ec_2Einteger_2Eint__lt_2E2(V0n_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0)),mono_2Ec_2Einteger_2Eint__neg_2E1(V0n_2E0),V0n_2E0) ) ).

tff(thm_2Einteger_2Eint__quot,axiom,
    ! [V0i_2E0: mono_2Etyop_2Einteger_2Eint,V1j_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V1j_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ( mono_2Ec_2Einteger_2Eint__quot_2E2(V0i_2E0,V1j_2E0) = mono_2Ec_2Ebool_2ECOND_2E3_2Emono_2Etyop_2Einteger_2Eint(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V1j_2E0),mono_2Ec_2Ebool_2ECOND_2E3_2Emono_2Etyop_2Einteger_2Eint(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0i_2E0),mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2EDIV_2E2(mono_2Ec_2Einteger_2ENum_2E1(V0i_2E0),mono_2Ec_2Einteger_2ENum_2E1(V1j_2E0))),mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2EDIV_2E2(mono_2Ec_2Einteger_2ENum_2E1(mono_2Ec_2Einteger_2Eint__neg_2E1(V0i_2E0)),mono_2Ec_2Einteger_2ENum_2E1(V1j_2E0))))),mono_2Ec_2Ebool_2ECOND_2E3_2Emono_2Etyop_2Einteger_2Eint(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0i_2E0),mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2EDIV_2E2(mono_2Ec_2Einteger_2ENum_2E1(V0i_2E0),mono_2Ec_2Einteger_2ENum_2E1(mono_2Ec_2Einteger_2Eint__neg_2E1(V1j_2E0))))),mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2EDIV_2E2(mono_2Ec_2Einteger_2ENum_2E1(mono_2Ec_2Einteger_2Eint__neg_2E1(V0i_2E0)),mono_2Ec_2Einteger_2ENum_2E1(mono_2Ec_2Einteger_2Eint__neg_2E1(V1j_2E0)))))) ) ) ).

tff(thm_2Einteger_2Eint__rem,axiom,
    ! [V0i_2E0: mono_2Etyop_2Einteger_2Eint,V1j_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V1j_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ( mono_2Ec_2Einteger_2Eint__rem_2E2(V0i_2E0,V1j_2E0) = mono_2Ec_2Einteger_2Eint__sub_2E2(V0i_2E0,mono_2Ec_2Einteger_2Eint__mul_2E2(mono_2Ec_2Einteger_2Eint__quot_2E2(V0i_2E0,V1j_2E0),V1j_2E0)) ) ) ).

tff(thm_2Einteger_2EINT__DIVIDES,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint,V1q_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__divides_2E2(V0p_2E0,V1q_2E0))
    <=> ? [V2m_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__mul_2E2(V2m_2E0,V0p_2E0) = V1q_2E0 ) ) ).

tff(thm_2Einteger_2EINT__LT,axiom,
    ! [V0m_2E0: mono_2Etyop_2Enum_2Enum,V1n_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(V0m_2E0),mono_2Ec_2Einteger_2Eint__of__num_2E1(V1n_2E0)) = mono_2Ec_2Eprim__rec_2E_3C_2E2(V0m_2E0,V1n_2E0) ) ).

tff(thm_2Einteger_2EINT__LE,axiom,
    ! [V0m_2E0: mono_2Etyop_2Enum_2Enum,V1n_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(V0m_2E0),mono_2Ec_2Einteger_2Eint__of__num_2E1(V1n_2E0)) = mono_2Ec_2Earithmetic_2E_3C_3D_2E2(V0m_2E0,V1n_2E0) ) ).

tff(thm_2Einteger_2EINT__POS,axiom,
    ! [V0n_2E0: mono_2Etyop_2Enum_2Enum] : p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),mono_2Ec_2Einteger_2Eint__of__num_2E1(V0n_2E0))) ).

tff(thm_2Einteger_2EINT,axiom,
    ! [V0n_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2ESUC_2E1(V0n_2E0)) = mono_2Ec_2Einteger_2Eint__add_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(V0n_2E0),mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0)))) ) ).

tff(thm_2Einteger_2EINT__EQ__RMUL,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2z_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( mono_2Ec_2Einteger_2Eint__mul_2E2(V0x_2E0,V2z_2E0) = mono_2Ec_2Einteger_2Eint__mul_2E2(V1y_2E0,V2z_2E0) )
    <=> ( ( V2z_2E0 = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
        | ( V0x_2E0 = V1y_2E0 ) ) ) ).

tff(thm_2Einteger_2EINT__EQ__LMUL,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2z_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( mono_2Ec_2Einteger_2Eint__mul_2E2(V0x_2E0,V1y_2E0) = mono_2Ec_2Einteger_2Eint__mul_2E2(V0x_2E0,V2z_2E0) )
    <=> ( ( V0x_2E0 = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
        | ( V1y_2E0 = V2z_2E0 ) ) ) ).

tff(thm_2Einteger_2EINT__ENTIRE,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( mono_2Ec_2Einteger_2Eint__mul_2E2(V0x_2E0,V1y_2E0) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
    <=> ( ( V0x_2E0 = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
        | ( V1y_2E0 = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) ) ) ).

tff(thm_2Einteger_2EINT__LT__ADDL,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__lt_2E2(V1y_2E0,mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V1y_2E0)) = mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0x_2E0) ) ).

tff(thm_2Einteger_2EINT__LT__ADDR,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__lt_2E2(V0x_2E0,mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V1y_2E0)) = mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V1y_2E0) ) ).

tff(thm_2Einteger_2EINT__LE__ADDL,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__le_2E2(V1y_2E0,mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V1y_2E0)) = mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0x_2E0) ) ).

tff(thm_2Einteger_2EINT__LE__ADDR,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__le_2E2(V0x_2E0,mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V1y_2E0)) = mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V1y_2E0) ) ).

tff(thm_2Einteger_2EINT__LT__IMP__NE,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(V0x_2E0,V1y_2E0))
     => ( V0x_2E0 != V1y_2E0 ) ) ).

tff(thm_2Einteger_2EINT__NEG__MINUS1,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__neg_2E1(V0x_2E0) = mono_2Ec_2Einteger_2Eint__mul_2E2(mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0)))),V0x_2E0) ) ).

tff(thm_2Einteger_2EINT__NEG__EQ,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( mono_2Ec_2Einteger_2Eint__neg_2E1(V0x_2E0) = V1y_2E0 )
    <=> ( V0x_2E0 = mono_2Ec_2Einteger_2Eint__neg_2E1(V1y_2E0) ) ) ).

tff(thm_2Einteger_2EINT__SUB__RDISTRIB,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2z_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__mul_2E2(mono_2Ec_2Einteger_2Eint__sub_2E2(V0x_2E0,V1y_2E0),V2z_2E0) = mono_2Ec_2Einteger_2Eint__sub_2E2(mono_2Ec_2Einteger_2Eint__mul_2E2(V0x_2E0,V2z_2E0),mono_2Ec_2Einteger_2Eint__mul_2E2(V1y_2E0,V2z_2E0)) ) ).

tff(thm_2Einteger_2EINT__SUB__LDISTRIB,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2z_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__mul_2E2(V0x_2E0,mono_2Ec_2Einteger_2Eint__sub_2E2(V1y_2E0,V2z_2E0)) = mono_2Ec_2Einteger_2Eint__sub_2E2(mono_2Ec_2Einteger_2Eint__mul_2E2(V0x_2E0,V1y_2E0),mono_2Ec_2Einteger_2Eint__mul_2E2(V0x_2E0,V2z_2E0)) ) ).

tff(thm_2Einteger_2EINT__ADD__SUB,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__sub_2E2(mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V1y_2E0),V0x_2E0) = V1y_2E0 ) ).

tff(thm_2Einteger_2EINT__SUB__LE,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),mono_2Ec_2Einteger_2Eint__sub_2E2(V0x_2E0,V1y_2E0)) = mono_2Ec_2Einteger_2Eint__le_2E2(V1y_2E0,V0x_2E0) ) ).

tff(thm_2Einteger_2EINT__SUB__LT,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),mono_2Ec_2Einteger_2Eint__sub_2E2(V0x_2E0,V1y_2E0)) = mono_2Ec_2Einteger_2Eint__lt_2E2(V1y_2E0,V0x_2E0) ) ).

tff(thm_2Einteger_2EINT__NEG__SUB,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2Eint__sub_2E2(V0x_2E0,V1y_2E0)) = mono_2Ec_2Einteger_2Eint__sub_2E2(V1y_2E0,V0x_2E0) ) ).

tff(thm_2Einteger_2EINT__NEG__0,axiom,
    mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0)) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ).

tff(thm_2Einteger_2EINT__NEG__EQ0,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( mono_2Ec_2Einteger_2Eint__neg_2E1(V0x_2E0) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
    <=> ( V0x_2E0 = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) ) ).

tff(thm_2Einteger_2EINT__LE__NEGR,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__le_2E2(V0x_2E0,mono_2Ec_2Einteger_2Eint__neg_2E1(V0x_2E0)) = mono_2Ec_2Einteger_2Eint__le_2E2(V0x_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0)) ) ).

tff(thm_2Einteger_2EINT__LE__NEGL,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__neg_2E1(V0x_2E0),V0x_2E0) = mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0x_2E0) ) ).

tff(thm_2Einteger_2EINT__LE__DOUBLE,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V0x_2E0)) = mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0x_2E0) ) ).

tff(thm_2Einteger_2EINT__SUB__0,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( mono_2Ec_2Einteger_2Eint__sub_2E2(V0x_2E0,V1y_2E0) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
    <=> ( V0x_2E0 = V1y_2E0 ) ) ).

tff(thm_2Einteger_2EINT__SUB__REFL,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__sub_2E2(V0x_2E0,V0x_2E0) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) ).

tff(thm_2Einteger_2EINT__SUB__ADD2,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__add_2E2(V1y_2E0,mono_2Ec_2Einteger_2Eint__sub_2E2(V0x_2E0,V1y_2E0)) = V0x_2E0 ) ).

tff(thm_2Einteger_2EINT__SUB__ADD,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__add_2E2(mono_2Ec_2Einteger_2Eint__sub_2E2(V0x_2E0,V1y_2E0),V1y_2E0) = V0x_2E0 ) ).

tff(thm_2Einteger_2EINT__LT__ADD1,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__le_2E2(V0x_2E0,V1y_2E0))
     => p(mono_2Ec_2Einteger_2Eint__lt_2E2(V0x_2E0,mono_2Ec_2Einteger_2Eint__add_2E2(V1y_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0)))))) ) ).

tff(thm_2Einteger_2EINT__LT__ADDNEG2,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2z_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,mono_2Ec_2Einteger_2Eint__neg_2E1(V1y_2E0)),V2z_2E0) = mono_2Ec_2Einteger_2Eint__lt_2E2(V0x_2E0,mono_2Ec_2Einteger_2Eint__add_2E2(V2z_2E0,V1y_2E0)) ) ).

tff(thm_2Einteger_2EINT__LT__ADDNEG,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2z_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__lt_2E2(V1y_2E0,mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,mono_2Ec_2Einteger_2Eint__neg_2E1(V2z_2E0))) = mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__add_2E2(V1y_2E0,V2z_2E0),V0x_2E0) ) ).

tff(thm_2Einteger_2EINT__LT__ADD,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0x_2E0))
        & p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V1y_2E0)) )
     => p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V1y_2E0))) ) ).

tff(thm_2Einteger_2EINT__LE__ADD,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0x_2E0))
        & p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V1y_2E0)) )
     => p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V1y_2E0))) ) ).

tff(thm_2Einteger_2EINT__LE__ADD2,axiom,
    ! [V0w_2E0: mono_2Etyop_2Einteger_2Eint,V1x_2E0: mono_2Etyop_2Einteger_2Eint,V2y_2E0: mono_2Etyop_2Einteger_2Eint,V3z_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( p(mono_2Ec_2Einteger_2Eint__le_2E2(V0w_2E0,V1x_2E0))
        & p(mono_2Ec_2Einteger_2Eint__le_2E2(V2y_2E0,V3z_2E0)) )
     => p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__add_2E2(V0w_2E0,V2y_2E0),mono_2Ec_2Einteger_2Eint__add_2E2(V1x_2E0,V3z_2E0))) ) ).

tff(thm_2Einteger_2EINT__LT__ADD2,axiom,
    ! [V0w_2E0: mono_2Etyop_2Einteger_2Eint,V1x_2E0: mono_2Etyop_2Einteger_2Eint,V2y_2E0: mono_2Etyop_2Einteger_2Eint,V3z_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(V0w_2E0,V1x_2E0))
        & p(mono_2Ec_2Einteger_2Eint__lt_2E2(V2y_2E0,V3z_2E0)) )
     => p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__add_2E2(V0w_2E0,V2y_2E0),mono_2Ec_2Einteger_2Eint__add_2E2(V1x_2E0,V3z_2E0))) ) ).

tff(thm_2Einteger_2EINT__LE__RADD,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2z_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V2z_2E0),mono_2Ec_2Einteger_2Eint__add_2E2(V1y_2E0,V2z_2E0)) = mono_2Ec_2Einteger_2Eint__le_2E2(V0x_2E0,V1y_2E0) ) ).

tff(thm_2Einteger_2EINT__LE__LADD,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2z_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V1y_2E0),mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V2z_2E0)) = mono_2Ec_2Einteger_2Eint__le_2E2(V1y_2E0,V2z_2E0) ) ).

tff(thm_2Einteger_2EINT__LT__01,axiom,
    p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0))))) ).

tff(thm_2Einteger_2EINT__LE__01,axiom,
    p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0))))) ).

tff(thm_2Einteger_2EINT__LE__SQUARE,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] : p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),mono_2Ec_2Einteger_2Eint__mul_2E2(V0x_2E0,V0x_2E0))) ).

tff(thm_2Einteger_2EINT__LE__MUL,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0x_2E0))
        & p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V1y_2E0)) )
     => p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),mono_2Ec_2Einteger_2Eint__mul_2E2(V0x_2E0,V1y_2E0))) ) ).

tff(thm_2Einteger_2EINT__LE__NEGTOTAL,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0x_2E0))
      | p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),mono_2Ec_2Einteger_2Eint__neg_2E1(V0x_2E0))) ) ).

tff(thm_2Einteger_2EINT__LT__NEGTOTAL,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V0x_2E0 = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
      | p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0x_2E0))
      | p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),mono_2Ec_2Einteger_2Eint__neg_2E1(V0x_2E0))) ) ).

tff(thm_2Einteger_2EINT__NEG__GE0,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),mono_2Ec_2Einteger_2Eint__neg_2E1(V0x_2E0)) = mono_2Ec_2Einteger_2Eint__le_2E2(V0x_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0)) ) ).

tff(thm_2Einteger_2EINT__NEG__LE0,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__neg_2E1(V0x_2E0),mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0)) = mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0x_2E0) ) ).

tff(thm_2Einteger_2EINT__NEG__GT0,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),mono_2Ec_2Einteger_2Eint__neg_2E1(V0x_2E0)) = mono_2Ec_2Einteger_2Eint__lt_2E2(V0x_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0)) ) ).

tff(thm_2Einteger_2EINT__NEG__LT0,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__neg_2E1(V0x_2E0),mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0)) = mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0x_2E0) ) ).

tff(thm_2Einteger_2EINT__LTE__ANTSYM,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ~ ( p(mono_2Ec_2Einteger_2Eint__le_2E2(V0x_2E0,V1y_2E0))
        & p(mono_2Ec_2Einteger_2Eint__lt_2E2(V1y_2E0,V0x_2E0)) ) ).

tff(thm_2Einteger_2EINT__LET__ANTISYM,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ~ ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(V0x_2E0,V1y_2E0))
        & p(mono_2Ec_2Einteger_2Eint__le_2E2(V1y_2E0,V0x_2E0)) ) ).

tff(thm_2Einteger_2EINT__LE__ANTISYM,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( p(mono_2Ec_2Einteger_2Eint__le_2E2(V0x_2E0,V1y_2E0))
        & p(mono_2Ec_2Einteger_2Eint__le_2E2(V1y_2E0,V0x_2E0)) )
    <=> ( V0x_2E0 = V1y_2E0 ) ) ).

tff(thm_2Einteger_2EINT__LE__TRANS,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2z_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( p(mono_2Ec_2Einteger_2Eint__le_2E2(V0x_2E0,V1y_2E0))
        & p(mono_2Ec_2Einteger_2Eint__le_2E2(V1y_2E0,V2z_2E0)) )
     => p(mono_2Ec_2Einteger_2Eint__le_2E2(V0x_2E0,V2z_2E0)) ) ).

tff(thm_2Einteger_2EINT__LET__TRANS,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2z_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( p(mono_2Ec_2Einteger_2Eint__le_2E2(V0x_2E0,V1y_2E0))
        & p(mono_2Ec_2Einteger_2Eint__lt_2E2(V1y_2E0,V2z_2E0)) )
     => p(mono_2Ec_2Einteger_2Eint__lt_2E2(V0x_2E0,V2z_2E0)) ) ).

tff(thm_2Einteger_2EINT__LTE__TRANS,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2z_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(V0x_2E0,V1y_2E0))
        & p(mono_2Ec_2Einteger_2Eint__le_2E2(V1y_2E0,V2z_2E0)) )
     => p(mono_2Ec_2Einteger_2Eint__lt_2E2(V0x_2E0,V2z_2E0)) ) ).

tff(thm_2Einteger_2EINT__LT__IMP__LE,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(V0x_2E0,V1y_2E0))
     => p(mono_2Ec_2Einteger_2Eint__le_2E2(V0x_2E0,V1y_2E0)) ) ).

tff(thm_2Einteger_2EINT__LT__LE,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(V0x_2E0,V1y_2E0))
    <=> ( p(mono_2Ec_2Einteger_2Eint__le_2E2(V0x_2E0,V1y_2E0))
        & ( V0x_2E0 != V1y_2E0 ) ) ) ).

tff(thm_2Einteger_2EINT__LE__LT,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__le_2E2(V0x_2E0,V1y_2E0))
    <=> ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(V0x_2E0,V1y_2E0))
        | ( V0x_2E0 = V1y_2E0 ) ) ) ).

tff(thm_2Einteger_2EINT__LE__REFL,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] : p(mono_2Ec_2Einteger_2Eint__le_2E2(V0x_2E0,V0x_2E0)) ).

tff(thm_2Einteger_2EINT__LTE__TOTAL,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(V0x_2E0,V1y_2E0))
      | p(mono_2Ec_2Einteger_2Eint__le_2E2(V1y_2E0,V0x_2E0)) ) ).

tff(thm_2Einteger_2EINT__LET__TOTAL,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__le_2E2(V0x_2E0,V1y_2E0))
      | p(mono_2Ec_2Einteger_2Eint__lt_2E2(V1y_2E0,V0x_2E0)) ) ).

tff(thm_2Einteger_2EINT__LE__TOTAL,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__le_2E2(V0x_2E0,V1y_2E0))
      | p(mono_2Ec_2Einteger_2Eint__le_2E2(V1y_2E0,V0x_2E0)) ) ).

tff(thm_2Einteger_2EINT__NOT__LE,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ~ p(mono_2Ec_2Einteger_2Eint__le_2E2(V0x_2E0,V1y_2E0))
    <=> p(mono_2Ec_2Einteger_2Eint__lt_2E2(V1y_2E0,V0x_2E0)) ) ).

tff(thm_2Einteger_2EINT__LT__GT,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(V0x_2E0,V1y_2E0))
     => ~ p(mono_2Ec_2Einteger_2Eint__lt_2E2(V1y_2E0,V0x_2E0)) ) ).

tff(thm_2Einteger_2EINT__LT__ANTISYM,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ~ ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(V0x_2E0,V1y_2E0))
        & p(mono_2Ec_2Einteger_2Eint__lt_2E2(V1y_2E0,V0x_2E0)) ) ).

tff(thm_2Einteger_2EINT__NOT__LT,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ~ p(mono_2Ec_2Einteger_2Eint__lt_2E2(V0x_2E0,V1y_2E0))
    <=> p(mono_2Ec_2Einteger_2Eint__le_2E2(V1y_2E0,V0x_2E0)) ) ).

tff(thm_2Einteger_2EINT__LT__RADD,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2z_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V2z_2E0),mono_2Ec_2Einteger_2Eint__add_2E2(V1y_2E0,V2z_2E0)) = mono_2Ec_2Einteger_2Eint__lt_2E2(V0x_2E0,V1y_2E0) ) ).

tff(thm_2Einteger_2EINT__LT__LADD,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2z_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V1y_2E0),mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V2z_2E0)) = mono_2Ec_2Einteger_2Eint__lt_2E2(V1y_2E0,V2z_2E0) ) ).

tff(thm_2Einteger_2EINT__NEG__MUL2,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__mul_2E2(mono_2Ec_2Einteger_2Eint__neg_2E1(V0x_2E0),mono_2Ec_2Einteger_2Eint__neg_2E1(V1y_2E0)) = mono_2Ec_2Einteger_2Eint__mul_2E2(V0x_2E0,V1y_2E0) ) ).

tff(thm_2Einteger_2EINT__NEGNEG,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2Eint__neg_2E1(V0x_2E0)) = V0x_2E0 ) ).

tff(thm_2Einteger_2EINT__NEG__RMUL,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2Eint__mul_2E2(V0x_2E0,V1y_2E0)) = mono_2Ec_2Einteger_2Eint__mul_2E2(V0x_2E0,mono_2Ec_2Einteger_2Eint__neg_2E1(V1y_2E0)) ) ).

tff(thm_2Einteger_2EINT__NEG__LMUL,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2Eint__mul_2E2(V0x_2E0,V1y_2E0)) = mono_2Ec_2Einteger_2Eint__mul_2E2(mono_2Ec_2Einteger_2Eint__neg_2E1(V0x_2E0),V1y_2E0) ) ).

tff(thm_2Einteger_2EINT__MUL__RZERO,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__mul_2E2(V0x_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0)) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) ).

tff(thm_2Einteger_2EINT__MUL__LZERO,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__mul_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0x_2E0) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) ).

tff(thm_2Einteger_2EINT__NEG__ADD,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V1y_2E0)) = mono_2Ec_2Einteger_2Eint__add_2E2(mono_2Ec_2Einteger_2Eint__neg_2E1(V0x_2E0),mono_2Ec_2Einteger_2Eint__neg_2E1(V1y_2E0)) ) ).

tff(thm_2Einteger_2EINT__RNEG__UNIQ,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V1y_2E0) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
    <=> ( V1y_2E0 = mono_2Ec_2Einteger_2Eint__neg_2E1(V0x_2E0) ) ) ).

tff(thm_2Einteger_2EINT__LNEG__UNIQ,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V1y_2E0) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
    <=> ( V0x_2E0 = mono_2Ec_2Einteger_2Eint__neg_2E1(V1y_2E0) ) ) ).

tff(thm_2Einteger_2EINT__ADD__RID__UNIQ,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V1y_2E0) = V0x_2E0 )
    <=> ( V1y_2E0 = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) ) ).

tff(thm_2Einteger_2EINT__ADD__LID__UNIQ,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V1y_2E0) = V1y_2E0 )
    <=> ( V0x_2E0 = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) ) ).

tff(thm_2Einteger_2EINT__EQ__RADD,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2z_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V2z_2E0) = mono_2Ec_2Einteger_2Eint__add_2E2(V1y_2E0,V2z_2E0) )
    <=> ( V0x_2E0 = V1y_2E0 ) ) ).

tff(thm_2Einteger_2EINT__EQ__LADD,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2z_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V1y_2E0) = mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V2z_2E0) )
    <=> ( V1y_2E0 = V2z_2E0 ) ) ).

tff(thm_2Einteger_2EINT__RDISTRIB,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2z_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__mul_2E2(mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V1y_2E0),V2z_2E0) = mono_2Ec_2Einteger_2Eint__add_2E2(mono_2Ec_2Einteger_2Eint__mul_2E2(V0x_2E0,V2z_2E0),mono_2Ec_2Einteger_2Eint__mul_2E2(V1y_2E0,V2z_2E0)) ) ).

tff(thm_2Einteger_2EINT__MUL__RID,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__mul_2E2(V0x_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0)))) = V0x_2E0 ) ).

tff(thm_2Einteger_2EINT__MUL__LID,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__mul_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0))),V0x_2E0) = V0x_2E0 ) ).

tff(thm_2Einteger_2EINT__ADD__RINV,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,mono_2Ec_2Einteger_2Eint__neg_2E1(V0x_2E0)) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) ).

tff(thm_2Einteger_2EINT__ADD__LINV,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__add_2E2(mono_2Ec_2Einteger_2Eint__neg_2E1(V0x_2E0),V0x_2E0) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) ).

tff(thm_2Einteger_2EINT__ADD__RID,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0)) = V0x_2E0 ) ).

tff(thm_2Einteger_2EINT__ADD__LID,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__add_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0x_2E0) = V0x_2E0 ) ).

tff(thm_2Einteger_2EINT__1,axiom,
    mono_2Ec_2Einteger_2Eint__1_2E0 = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0))) ).

tff(thm_2Einteger_2EINT__0,axiom,
    mono_2Ec_2Einteger_2Eint__0_2E0 = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ).

tff(thm_2Einteger_2ENUM__POSINT__EX,axiom,
    ! [V0t_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ~ p(mono_2Ec_2Einteger_2Eint__lt_2E2(V0t_2E0,mono_2Ec_2Einteger_2Eint__0_2E0))
     => ? [V1n_2E0: mono_2Etyop_2Enum_2Enum] : ( V0t_2E0 = mono_2Ec_2Einteger_2Eint__of__num_2E1(V1n_2E0) ) ) ).

tff(thm_2Einteger_2EINT__LT__MUL,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__0_2E0,V0x_2E0))
        & p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__0_2E0,V1y_2E0)) )
     => p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__0_2E0,mono_2Ec_2Einteger_2Eint__mul_2E2(V0x_2E0,V1y_2E0))) ) ).

tff(thm_2Einteger_2EINT__LT__LADD__IMP,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2z_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(V1y_2E0,V2z_2E0))
     => p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V1y_2E0),mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V2z_2E0))) ) ).

tff(thm_2Einteger_2EINT__LT__TRANS,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2z_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(V0x_2E0,V1y_2E0))
        & p(mono_2Ec_2Einteger_2Eint__lt_2E2(V1y_2E0,V2z_2E0)) )
     => p(mono_2Ec_2Einteger_2Eint__lt_2E2(V0x_2E0,V2z_2E0)) ) ).

tff(thm_2Einteger_2EINT__LT__REFL,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] : ~ p(mono_2Ec_2Einteger_2Eint__lt_2E2(V0x_2E0,V0x_2E0)) ).

tff(thm_2Einteger_2EINT__LT__TOTAL,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V0x_2E0 = V1y_2E0 )
      | p(mono_2Ec_2Einteger_2Eint__lt_2E2(V0x_2E0,V1y_2E0))
      | p(mono_2Ec_2Einteger_2Eint__lt_2E2(V1y_2E0,V0x_2E0)) ) ).

tff(thm_2Einteger_2EINT__LDISTRIB,axiom,
    ! [V0z_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2x_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__mul_2E2(V2x_2E0,mono_2Ec_2Einteger_2Eint__add_2E2(V1y_2E0,V0z_2E0)) = mono_2Ec_2Einteger_2Eint__add_2E2(mono_2Ec_2Einteger_2Eint__mul_2E2(V2x_2E0,V1y_2E0),mono_2Ec_2Einteger_2Eint__mul_2E2(V2x_2E0,V0z_2E0)) ) ).

tff(thm_2Einteger_2EINT__MUL__ASSOC,axiom,
    ! [V0z_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2x_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__mul_2E2(V2x_2E0,mono_2Ec_2Einteger_2Eint__mul_2E2(V1y_2E0,V0z_2E0)) = mono_2Ec_2Einteger_2Eint__mul_2E2(mono_2Ec_2Einteger_2Eint__mul_2E2(V2x_2E0,V1y_2E0),V0z_2E0) ) ).

tff(thm_2Einteger_2EINT__ADD__ASSOC,axiom,
    ! [V0z_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2x_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__add_2E2(V2x_2E0,mono_2Ec_2Einteger_2Eint__add_2E2(V1y_2E0,V0z_2E0)) = mono_2Ec_2Einteger_2Eint__add_2E2(mono_2Ec_2Einteger_2Eint__add_2E2(V2x_2E0,V1y_2E0),V0z_2E0) ) ).

tff(thm_2Einteger_2EINT__MUL__COMM,axiom,
    ! [V0y_2E0: mono_2Etyop_2Einteger_2Eint,V1x_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__mul_2E2(V1x_2E0,V0y_2E0) = mono_2Ec_2Einteger_2Eint__mul_2E2(V0y_2E0,V1x_2E0) ) ).

tff(thm_2Einteger_2EINT__MUL__SYM,axiom,
    ! [V0y_2E0: mono_2Etyop_2Einteger_2Eint,V1x_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__mul_2E2(V1x_2E0,V0y_2E0) = mono_2Ec_2Einteger_2Eint__mul_2E2(V0y_2E0,V1x_2E0) ) ).

tff(thm_2Einteger_2EINT__ADD__COMM,axiom,
    ! [V0y_2E0: mono_2Etyop_2Einteger_2Eint,V1x_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__add_2E2(V1x_2E0,V0y_2E0) = mono_2Ec_2Einteger_2Eint__add_2E2(V0y_2E0,V1x_2E0) ) ).

tff(thm_2Einteger_2EINT__ADD__SYM,axiom,
    ! [V0y_2E0: mono_2Etyop_2Einteger_2Eint,V1x_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__add_2E2(V1x_2E0,V0y_2E0) = mono_2Ec_2Einteger_2Eint__add_2E2(V0y_2E0,V1x_2E0) ) ).

tff(thm_2Einteger_2EINT__10,axiom,
    mono_2Ec_2Einteger_2Eint__1_2E0 != mono_2Ec_2Einteger_2Eint__0_2E0 ).

tff(thm_2Einteger_2EEQ__LADD,axiom,
    ! [V0m_2E0: mono_2Etyop_2Enum_2Enum,V1n_2E0: mono_2Etyop_2Enum_2Enum,V2p_2E0: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_2B_2E2(V0m_2E0,V1n_2E0) = mono_2Ec_2Earithmetic_2E_2B_2E2(V0m_2E0,V2p_2E0) )
    <=> ( V1n_2E0 = V2p_2E0 ) ) ).

tff(thm_2Einteger_2EEQ__ADDL,axiom,
    ! [V0x_2E0: mono_2Etyop_2Enum_2Enum,V1y_2E0: mono_2Etyop_2Enum_2Enum] :
      ( ( V0x_2E0 = mono_2Ec_2Earithmetic_2E_2B_2E2(V0x_2E0,V1y_2E0) )
    <=> ( V1y_2E0 = mono_2Ec_2Enum_2E0_2E0 ) ) ).

tff(thm_2Einteger_2ELT__LADD,axiom,
    ! [V0x_2E0: mono_2Etyop_2Enum_2Enum,V1y_2E0: mono_2Etyop_2Enum_2Enum,V2z_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Eprim__rec_2E_3C_2E2(mono_2Ec_2Earithmetic_2E_2B_2E2(V0x_2E0,V1y_2E0),mono_2Ec_2Earithmetic_2E_2B_2E2(V0x_2E0,V2z_2E0)) = mono_2Ec_2Eprim__rec_2E_3C_2E2(V1y_2E0,V2z_2E0) ) ).

tff(thm_2Einteger_2ELT__ADDL,axiom,
    ! [V0x_2E0: mono_2Etyop_2Enum_2Enum,V1y_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Eprim__rec_2E_3C_2E2(V0x_2E0,mono_2Ec_2Earithmetic_2E_2B_2E2(V0x_2E0,V1y_2E0)) = mono_2Ec_2Eprim__rec_2E_3C_2E2(mono_2Ec_2Enum_2E0_2E0,V1y_2E0) ) ).

tff(thm_2Einteger_2ELT__ADDR,axiom,
    ! [V0x_2E0: mono_2Etyop_2Enum_2Enum,V1y_2E0: mono_2Etyop_2Enum_2Enum] : ~ p(mono_2Ec_2Eprim__rec_2E_3C_2E2(mono_2Ec_2Earithmetic_2E_2B_2E2(V0x_2E0,V1y_2E0),V0x_2E0)) ).

tff(thm_2Einteger_2ELT__ADD2,axiom,
    ! [V0x1_2E0: mono_2Etyop_2Enum_2Enum,V1x2_2E0: mono_2Etyop_2Enum_2Enum,V2y1_2E0: mono_2Etyop_2Enum_2Enum,V3y2_2E0: mono_2Etyop_2Enum_2Enum] :
      ( ( p(mono_2Ec_2Eprim__rec_2E_3C_2E2(V0x1_2E0,V2y1_2E0))
        & p(mono_2Ec_2Eprim__rec_2E_3C_2E2(V1x2_2E0,V3y2_2E0)) )
     => p(mono_2Ec_2Eprim__rec_2E_3C_2E2(mono_2Ec_2Earithmetic_2E_2B_2E2(V0x1_2E0,V1x2_2E0),mono_2Ec_2Earithmetic_2E_2B_2E2(V2y1_2E0,V3y2_2E0))) ) ).

tff(thm_2Einteger_2ETINT__EQ__REFL,axiom,
    ! [V0x_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : p(mono_2Ec_2Einteger_2Etint__eq_2E2(V0x_2E0,V0x_2E0)) ).

tff(thm_2Einteger_2ETINT__EQ__SYM,axiom,
    ! [V0x_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V1y_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : ( mono_2Ec_2Einteger_2Etint__eq_2E2(V0x_2E0,V1y_2E0) = mono_2Ec_2Einteger_2Etint__eq_2E2(V1y_2E0,V0x_2E0) ) ).

tff(thm_2Einteger_2ETINT__EQ__TRANS,axiom,
    ! [V0x_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V1y_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V2z_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] :
      ( ( p(mono_2Ec_2Einteger_2Etint__eq_2E2(V0x_2E0,V1y_2E0))
        & p(mono_2Ec_2Einteger_2Etint__eq_2E2(V1y_2E0,V2z_2E0)) )
     => p(mono_2Ec_2Einteger_2Etint__eq_2E2(V0x_2E0,V2z_2E0)) ) ).

tff(thm_2Einteger_2ETINT__EQ__EQUIV,axiom,
    ! [V0p_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V1q_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] :
      ( p(mono_2Ec_2Einteger_2Etint__eq_2E2(V0p_2E0,V1q_2E0))
    <=> ( mono_2Ec_2Einteger_2Etint__eq_2E1(V0p_2E0) = mono_2Ec_2Einteger_2Etint__eq_2E1(V1q_2E0) ) ) ).

tff(thm_2Einteger_2ETINT__EQ__AP,axiom,
    ! [V0p_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V1q_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] :
      ( ( V0p_2E0 = V1q_2E0 )
     => p(mono_2Ec_2Einteger_2Etint__eq_2E2(V0p_2E0,V1q_2E0)) ) ).

tff(thm_2Einteger_2ETINT__10,axiom,
    ~ p(mono_2Ec_2Einteger_2Etint__eq_2E2(mono_2Ec_2Einteger_2Etint__1_2E0,mono_2Ec_2Einteger_2Etint__0_2E0)) ).

tff(thm_2Einteger_2ETINT__ADD__SYM,axiom,
    ! [V0x_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V1y_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : ( mono_2Ec_2Einteger_2Etint__add_2E2(V0x_2E0,V1y_2E0) = mono_2Ec_2Einteger_2Etint__add_2E2(V1y_2E0,V0x_2E0) ) ).

tff(thm_2Einteger_2ETINT__MUL__SYM,axiom,
    ! [V0x_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V1y_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : ( mono_2Ec_2Einteger_2Etint__mul_2E2(V0x_2E0,V1y_2E0) = mono_2Ec_2Einteger_2Etint__mul_2E2(V1y_2E0,V0x_2E0) ) ).

tff(thm_2Einteger_2ETINT__ADD__ASSOC,axiom,
    ! [V0x_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V1y_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V2z_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : ( mono_2Ec_2Einteger_2Etint__add_2E2(V0x_2E0,mono_2Ec_2Einteger_2Etint__add_2E2(V1y_2E0,V2z_2E0)) = mono_2Ec_2Einteger_2Etint__add_2E2(mono_2Ec_2Einteger_2Etint__add_2E2(V0x_2E0,V1y_2E0),V2z_2E0) ) ).

tff(thm_2Einteger_2ETINT__MUL__ASSOC,axiom,
    ! [V0x_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V1y_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V2z_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : ( mono_2Ec_2Einteger_2Etint__mul_2E2(V0x_2E0,mono_2Ec_2Einteger_2Etint__mul_2E2(V1y_2E0,V2z_2E0)) = mono_2Ec_2Einteger_2Etint__mul_2E2(mono_2Ec_2Einteger_2Etint__mul_2E2(V0x_2E0,V1y_2E0),V2z_2E0) ) ).

tff(thm_2Einteger_2ETINT__LDISTRIB,axiom,
    ! [V0x_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V1y_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V2z_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : ( mono_2Ec_2Einteger_2Etint__mul_2E2(V0x_2E0,mono_2Ec_2Einteger_2Etint__add_2E2(V1y_2E0,V2z_2E0)) = mono_2Ec_2Einteger_2Etint__add_2E2(mono_2Ec_2Einteger_2Etint__mul_2E2(V0x_2E0,V1y_2E0),mono_2Ec_2Einteger_2Etint__mul_2E2(V0x_2E0,V2z_2E0)) ) ).

tff(thm_2Einteger_2ETINT__ADD__LID,axiom,
    ! [V0x_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : p(mono_2Ec_2Einteger_2Etint__eq_2E2(mono_2Ec_2Einteger_2Etint__add_2E2(mono_2Ec_2Einteger_2Etint__0_2E0,V0x_2E0),V0x_2E0)) ).

tff(thm_2Einteger_2ETINT__MUL__LID,axiom,
    ! [V0x_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : p(mono_2Ec_2Einteger_2Etint__eq_2E2(mono_2Ec_2Einteger_2Etint__mul_2E2(mono_2Ec_2Einteger_2Etint__1_2E0,V0x_2E0),V0x_2E0)) ).

tff(thm_2Einteger_2ETINT__ADD__LINV,axiom,
    ! [V0x_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : p(mono_2Ec_2Einteger_2Etint__eq_2E2(mono_2Ec_2Einteger_2Etint__add_2E2(mono_2Ec_2Einteger_2Etint__neg_2E1(V0x_2E0),V0x_2E0),mono_2Ec_2Einteger_2Etint__0_2E0)) ).

tff(thm_2Einteger_2ETINT__LT__TOTAL,axiom,
    ! [V0x_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V1y_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] :
      ( p(mono_2Ec_2Einteger_2Etint__eq_2E2(V0x_2E0,V1y_2E0))
      | p(mono_2Ec_2Einteger_2Etint__lt_2E2(V0x_2E0,V1y_2E0))
      | p(mono_2Ec_2Einteger_2Etint__lt_2E2(V1y_2E0,V0x_2E0)) ) ).

tff(thm_2Einteger_2ETINT__LT__REFL,axiom,
    ! [V0x_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : ~ p(mono_2Ec_2Einteger_2Etint__lt_2E2(V0x_2E0,V0x_2E0)) ).

tff(thm_2Einteger_2ETINT__LT__TRANS,axiom,
    ! [V0x_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V1y_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V2z_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] :
      ( ( p(mono_2Ec_2Einteger_2Etint__lt_2E2(V0x_2E0,V1y_2E0))
        & p(mono_2Ec_2Einteger_2Etint__lt_2E2(V1y_2E0,V2z_2E0)) )
     => p(mono_2Ec_2Einteger_2Etint__lt_2E2(V0x_2E0,V2z_2E0)) ) ).

tff(thm_2Einteger_2ETINT__LT__ADD,axiom,
    ! [V0x_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V1y_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V2z_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] :
      ( p(mono_2Ec_2Einteger_2Etint__lt_2E2(V1y_2E0,V2z_2E0))
     => p(mono_2Ec_2Einteger_2Etint__lt_2E2(mono_2Ec_2Einteger_2Etint__add_2E2(V0x_2E0,V1y_2E0),mono_2Ec_2Einteger_2Etint__add_2E2(V0x_2E0,V2z_2E0))) ) ).

tff(thm_2Einteger_2ETINT__LT__MUL,axiom,
    ! [V0x_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V1y_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] :
      ( ( p(mono_2Ec_2Einteger_2Etint__lt_2E2(mono_2Ec_2Einteger_2Etint__0_2E0,V0x_2E0))
        & p(mono_2Ec_2Einteger_2Etint__lt_2E2(mono_2Ec_2Einteger_2Etint__0_2E0,V1y_2E0)) )
     => p(mono_2Ec_2Einteger_2Etint__lt_2E2(mono_2Ec_2Einteger_2Etint__0_2E0,mono_2Ec_2Einteger_2Etint__mul_2E2(V0x_2E0,V1y_2E0))) ) ).

tff(thm_2Einteger_2ETINT__NEG__WELLDEF,axiom,
    ! [V0x1_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V1x2_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] :
      ( p(mono_2Ec_2Einteger_2Etint__eq_2E2(V0x1_2E0,V1x2_2E0))
     => p(mono_2Ec_2Einteger_2Etint__eq_2E2(mono_2Ec_2Einteger_2Etint__neg_2E1(V0x1_2E0),mono_2Ec_2Einteger_2Etint__neg_2E1(V1x2_2E0))) ) ).

tff(thm_2Einteger_2ETINT__ADD__WELLDEFR,axiom,
    ! [V0x1_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V1x2_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V2y_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] :
      ( p(mono_2Ec_2Einteger_2Etint__eq_2E2(V0x1_2E0,V1x2_2E0))
     => p(mono_2Ec_2Einteger_2Etint__eq_2E2(mono_2Ec_2Einteger_2Etint__add_2E2(V0x1_2E0,V2y_2E0),mono_2Ec_2Einteger_2Etint__add_2E2(V1x2_2E0,V2y_2E0))) ) ).

tff(thm_2Einteger_2ETINT__ADD__WELLDEF,axiom,
    ! [V0x1_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V1x2_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V2y1_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V3y2_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] :
      ( ( p(mono_2Ec_2Einteger_2Etint__eq_2E2(V0x1_2E0,V1x2_2E0))
        & p(mono_2Ec_2Einteger_2Etint__eq_2E2(V2y1_2E0,V3y2_2E0)) )
     => p(mono_2Ec_2Einteger_2Etint__eq_2E2(mono_2Ec_2Einteger_2Etint__add_2E2(V0x1_2E0,V2y1_2E0),mono_2Ec_2Einteger_2Etint__add_2E2(V1x2_2E0,V3y2_2E0))) ) ).

tff(thm_2Einteger_2ETINT__MUL__WELLDEFR,axiom,
    ! [V0x1_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V1x2_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V2y_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] :
      ( p(mono_2Ec_2Einteger_2Etint__eq_2E2(V0x1_2E0,V1x2_2E0))
     => p(mono_2Ec_2Einteger_2Etint__eq_2E2(mono_2Ec_2Einteger_2Etint__mul_2E2(V0x1_2E0,V2y_2E0),mono_2Ec_2Einteger_2Etint__mul_2E2(V1x2_2E0,V2y_2E0))) ) ).

tff(thm_2Einteger_2ETINT__MUL__WELLDEF,axiom,
    ! [V0x1_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V1x2_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V2y1_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V3y2_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] :
      ( ( p(mono_2Ec_2Einteger_2Etint__eq_2E2(V0x1_2E0,V1x2_2E0))
        & p(mono_2Ec_2Einteger_2Etint__eq_2E2(V2y1_2E0,V3y2_2E0)) )
     => p(mono_2Ec_2Einteger_2Etint__eq_2E2(mono_2Ec_2Einteger_2Etint__mul_2E2(V0x1_2E0,V2y1_2E0),mono_2Ec_2Einteger_2Etint__mul_2E2(V1x2_2E0,V3y2_2E0))) ) ).

tff(thm_2Einteger_2ETINT__LT__WELLDEFR,axiom,
    ! [V0x1_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V1x2_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V2y_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] :
      ( p(mono_2Ec_2Einteger_2Etint__eq_2E2(V0x1_2E0,V1x2_2E0))
     => ( mono_2Ec_2Einteger_2Etint__lt_2E2(V0x1_2E0,V2y_2E0) = mono_2Ec_2Einteger_2Etint__lt_2E2(V1x2_2E0,V2y_2E0) ) ) ).

tff(thm_2Einteger_2ETINT__LT__WELLDEFL,axiom,
    ! [V0x_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V1y1_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V2y2_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] :
      ( p(mono_2Ec_2Einteger_2Etint__eq_2E2(V1y1_2E0,V2y2_2E0))
     => ( mono_2Ec_2Einteger_2Etint__lt_2E2(V0x_2E0,V1y1_2E0) = mono_2Ec_2Einteger_2Etint__lt_2E2(V0x_2E0,V2y2_2E0) ) ) ).

tff(thm_2Einteger_2ETINT__LT__WELLDEF,axiom,
    ! [V0x1_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V1x2_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V2y1_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V3y2_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] :
      ( ( p(mono_2Ec_2Einteger_2Etint__eq_2E2(V0x1_2E0,V1x2_2E0))
        & p(mono_2Ec_2Einteger_2Etint__eq_2E2(V2y1_2E0,V3y2_2E0)) )
     => ( mono_2Ec_2Einteger_2Etint__lt_2E2(V0x1_2E0,V2y1_2E0) = mono_2Ec_2Einteger_2Etint__lt_2E2(V1x2_2E0,V3y2_2E0) ) ) ).

tff(thm_2Einteger_2Etint__of__num__eq,axiom,
    ! [V0n_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Epair_2EFST_2E1_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(mono_2Ec_2Einteger_2Etint__of__num_2E1(V0n_2E0)) = mono_2Ec_2Earithmetic_2E_2B_2E2(mono_2Ec_2Epair_2ESND_2E1_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(mono_2Ec_2Einteger_2Etint__of__num_2E1(V0n_2E0)),V0n_2E0) ) ).

tff(thm_2Einteger_2ETINT__INJ,axiom,
    ! [V0m_2E0: mono_2Etyop_2Enum_2Enum,V1n_2E0: mono_2Etyop_2Enum_2Enum] :
      ( p(mono_2Ec_2Einteger_2Etint__eq_2E2(mono_2Ec_2Einteger_2Etint__of__num_2E1(V0m_2E0),mono_2Ec_2Einteger_2Etint__of__num_2E1(V1n_2E0)))
    <=> ( V0m_2E0 = V1n_2E0 ) ) ).

tff(thm_2Einteger_2ENUM__POSTINT__EX,axiom,
    ! [V0t_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] :
      ( ~ p(mono_2Ec_2Einteger_2Etint__lt_2E2(V0t_2E0,mono_2Ec_2Einteger_2Etint__0_2E0))
     => ? [V1n_2E0: mono_2Etyop_2Enum_2Enum] : p(mono_2Ec_2Einteger_2Etint__eq_2E2(V0t_2E0,mono_2Ec_2Einteger_2Etint__of__num_2E1(V1n_2E0))) ) ).

tff(thm_2Einteger_2Eint__ABS__REP__CLASS,axiom,
    ( ! [V0a_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__ABS__CLASS_2E1(mono_2Ec_2Einteger_2Eint__REP__CLASS_2E1(V0a_2E0)) = V0a_2E0 )
    & ! [V1c_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29] :
        ( ? [V2r_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] :
            ( p(mono_2Ec_2Einteger_2Etint__eq_2E2(V2r_2E0,V2r_2E0))
            & ( V1c_2E0 = mono_2Ec_2Einteger_2Etint__eq_2E1(V2r_2E0) ) )
      <=> ( mono_2Ec_2Einteger_2Eint__REP__CLASS_2E1(mono_2Ec_2Einteger_2Eint__ABS__CLASS_2E1(V1c_2E0)) = V1c_2E0 ) ) ) ).

tff(thm_2Einteger_2Eint__QUOTIENT,axiom,
    p(mono_2Ec_2Equotient_2EQUOTIENT_2E3_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Einteger_2Eint(mono_2Ec_2Einteger_2Etint__eq_2E0,mono_2Ec_2Einteger_2Eint__ABS_2E0,mono_2Ec_2Einteger_2Eint__REP_2E0)) ).

tff(thm_2Einteger_2Eint__of__num,axiom,
    ( ( mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) = mono_2Ec_2Einteger_2Eint__0_2E0 )
    & ! [V0n_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2ESUC_2E1(V0n_2E0)) = mono_2Ec_2Einteger_2Eint__add_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(V0n_2E0),mono_2Ec_2Einteger_2Eint__1_2E0) ) ) ).

tff(thm_2Einteger_2EINT__INJ,axiom,
    ! [V0m_2E0: mono_2Etyop_2Enum_2Enum,V1n_2E0: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Einteger_2Eint__of__num_2E1(V0m_2E0) = mono_2Ec_2Einteger_2Eint__of__num_2E1(V1n_2E0) )
    <=> ( V0m_2E0 = V1n_2E0 ) ) ).

tff(thm_2Einteger_2EINT__ADD,axiom,
    ! [V0m_2E0: mono_2Etyop_2Enum_2Enum,V1n_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Einteger_2Eint__add_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(V0m_2E0),mono_2Ec_2Einteger_2Eint__of__num_2E1(V1n_2E0)) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2E_2B_2E2(V0m_2E0,V1n_2E0)) ) ).

tff(thm_2Einteger_2EINT__MUL,axiom,
    ! [V0m_2E0: mono_2Etyop_2Enum_2Enum,V1n_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Einteger_2Eint__mul_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(V0m_2E0),mono_2Ec_2Einteger_2Eint__of__num_2E1(V1n_2E0)) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2E_2A_2E2(V0m_2E0,V1n_2E0)) ) ).

tff(thm_2Einteger_2EINT__LT__NZ,axiom,
    ! [V0n_2E0: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Einteger_2Eint__of__num_2E1(V0n_2E0) != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
    <=> p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),mono_2Ec_2Einteger_2Eint__of__num_2E1(V0n_2E0))) ) ).

tff(thm_2Einteger_2EINT__NZ__IMP__LT,axiom,
    ! [V0n_2E0: mono_2Etyop_2Enum_2Enum] :
      ( ( V0n_2E0 != mono_2Ec_2Enum_2E0_2E0 )
     => p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),mono_2Ec_2Einteger_2Eint__of__num_2E1(V0n_2E0))) ) ).

tff(thm_2Einteger_2EINT__DOUBLE,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V0x_2E0) = mono_2Ec_2Einteger_2Eint__mul_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT2_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0))),V0x_2E0) ) ).

tff(thm_2Einteger_2EINT__SUB__SUB,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__sub_2E2(mono_2Ec_2Einteger_2Eint__sub_2E2(V0x_2E0,V1y_2E0),V0x_2E0) = mono_2Ec_2Einteger_2Eint__neg_2E1(V1y_2E0) ) ).

tff(thm_2Einteger_2EINT__LT__ADD__SUB,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2z_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V1y_2E0),V2z_2E0) = mono_2Ec_2Einteger_2Eint__lt_2E2(V0x_2E0,mono_2Ec_2Einteger_2Eint__sub_2E2(V2z_2E0,V1y_2E0)) ) ).

tff(thm_2Einteger_2EINT__LT__SUB__RADD,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2z_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__sub_2E2(V0x_2E0,V1y_2E0),V2z_2E0) = mono_2Ec_2Einteger_2Eint__lt_2E2(V0x_2E0,mono_2Ec_2Einteger_2Eint__add_2E2(V2z_2E0,V1y_2E0)) ) ).

tff(thm_2Einteger_2EINT__LT__SUB__LADD,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2z_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__lt_2E2(V0x_2E0,mono_2Ec_2Einteger_2Eint__sub_2E2(V1y_2E0,V2z_2E0)) = mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V2z_2E0),V1y_2E0) ) ).

tff(thm_2Einteger_2EINT__LE__SUB__LADD,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2z_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__le_2E2(V0x_2E0,mono_2Ec_2Einteger_2Eint__sub_2E2(V1y_2E0,V2z_2E0)) = mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V2z_2E0),V1y_2E0) ) ).

tff(thm_2Einteger_2EINT__LE__SUB__RADD,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2z_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__sub_2E2(V0x_2E0,V1y_2E0),V2z_2E0) = mono_2Ec_2Einteger_2Eint__le_2E2(V0x_2E0,mono_2Ec_2Einteger_2Eint__add_2E2(V2z_2E0,V1y_2E0)) ) ).

tff(thm_2Einteger_2EINT__LT__NEG,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__neg_2E1(V0x_2E0),mono_2Ec_2Einteger_2Eint__neg_2E1(V1y_2E0)) = mono_2Ec_2Einteger_2Eint__lt_2E2(V1y_2E0,V0x_2E0) ) ).

tff(thm_2Einteger_2EINT__LE__NEG,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__neg_2E1(V0x_2E0),mono_2Ec_2Einteger_2Eint__neg_2E1(V1y_2E0)) = mono_2Ec_2Einteger_2Eint__le_2E2(V1y_2E0,V0x_2E0) ) ).

tff(thm_2Einteger_2EINT__ADD2__SUB2,axiom,
    ! [V0a_2E0: mono_2Etyop_2Einteger_2Eint,V1b_2E0: mono_2Etyop_2Einteger_2Eint,V2c_2E0: mono_2Etyop_2Einteger_2Eint,V3d_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__sub_2E2(mono_2Ec_2Einteger_2Eint__add_2E2(V0a_2E0,V1b_2E0),mono_2Ec_2Einteger_2Eint__add_2E2(V2c_2E0,V3d_2E0)) = mono_2Ec_2Einteger_2Eint__add_2E2(mono_2Ec_2Einteger_2Eint__sub_2E2(V0a_2E0,V2c_2E0),mono_2Ec_2Einteger_2Eint__sub_2E2(V1b_2E0,V3d_2E0)) ) ).

tff(thm_2Einteger_2EINT__SUB__LZERO,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__sub_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0x_2E0) = mono_2Ec_2Einteger_2Eint__neg_2E1(V0x_2E0) ) ).

tff(thm_2Einteger_2EINT__SUB__RZERO,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__sub_2E2(V0x_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0)) = V0x_2E0 ) ).

tff(thm_2Einteger_2EINT__LET__ADD2,axiom,
    ! [V0w_2E0: mono_2Etyop_2Einteger_2Eint,V1x_2E0: mono_2Etyop_2Einteger_2Eint,V2y_2E0: mono_2Etyop_2Einteger_2Eint,V3z_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( p(mono_2Ec_2Einteger_2Eint__le_2E2(V0w_2E0,V1x_2E0))
        & p(mono_2Ec_2Einteger_2Eint__lt_2E2(V2y_2E0,V3z_2E0)) )
     => p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__add_2E2(V0w_2E0,V2y_2E0),mono_2Ec_2Einteger_2Eint__add_2E2(V1x_2E0,V3z_2E0))) ) ).

tff(thm_2Einteger_2EINT__LTE__ADD2,axiom,
    ! [V0w_2E0: mono_2Etyop_2Einteger_2Eint,V1x_2E0: mono_2Etyop_2Einteger_2Eint,V2y_2E0: mono_2Etyop_2Einteger_2Eint,V3z_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(V0w_2E0,V1x_2E0))
        & p(mono_2Ec_2Einteger_2Eint__le_2E2(V2y_2E0,V3z_2E0)) )
     => p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__add_2E2(V0w_2E0,V2y_2E0),mono_2Ec_2Einteger_2Eint__add_2E2(V1x_2E0,V3z_2E0))) ) ).

tff(thm_2Einteger_2EINT__LET__ADD,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0x_2E0))
        & p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V1y_2E0)) )
     => p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V1y_2E0))) ) ).

tff(thm_2Einteger_2EINT__LTE__ADD,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0x_2E0))
        & p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V1y_2E0)) )
     => p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V1y_2E0))) ) ).

tff(thm_2Einteger_2EINT__LT__MUL2,axiom,
    ! [V0x1_2E0: mono_2Etyop_2Einteger_2Eint,V1x2_2E0: mono_2Etyop_2Einteger_2Eint,V2y1_2E0: mono_2Etyop_2Einteger_2Eint,V3y2_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0x1_2E0))
        & p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V2y1_2E0))
        & p(mono_2Ec_2Einteger_2Eint__lt_2E2(V0x1_2E0,V1x2_2E0))
        & p(mono_2Ec_2Einteger_2Eint__lt_2E2(V2y1_2E0,V3y2_2E0)) )
     => p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__mul_2E2(V0x1_2E0,V2y1_2E0),mono_2Ec_2Einteger_2Eint__mul_2E2(V1x2_2E0,V3y2_2E0))) ) ).

tff(thm_2Einteger_2EINT__SUB__LNEG,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__sub_2E2(mono_2Ec_2Einteger_2Eint__neg_2E1(V0x_2E0),V1y_2E0) = mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V1y_2E0)) ) ).

tff(thm_2Einteger_2EINT__SUB__RNEG,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__sub_2E2(V0x_2E0,mono_2Ec_2Einteger_2Eint__neg_2E1(V1y_2E0)) = mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V1y_2E0) ) ).

tff(thm_2Einteger_2EINT__SUB__NEG2,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__sub_2E2(mono_2Ec_2Einteger_2Eint__neg_2E1(V0x_2E0),mono_2Ec_2Einteger_2Eint__neg_2E1(V1y_2E0)) = mono_2Ec_2Einteger_2Eint__sub_2E2(V1y_2E0,V0x_2E0) ) ).

tff(thm_2Einteger_2EINT__SUB__TRIANGLE,axiom,
    ! [V0a_2E0: mono_2Etyop_2Einteger_2Eint,V1b_2E0: mono_2Etyop_2Einteger_2Eint,V2c_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__add_2E2(mono_2Ec_2Einteger_2Eint__sub_2E2(V0a_2E0,V1b_2E0),mono_2Ec_2Einteger_2Eint__sub_2E2(V1b_2E0,V2c_2E0)) = mono_2Ec_2Einteger_2Eint__sub_2E2(V0a_2E0,V2c_2E0) ) ).

tff(thm_2Einteger_2EINT__EQ__SUB__LADD,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2z_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V0x_2E0 = mono_2Ec_2Einteger_2Eint__sub_2E2(V1y_2E0,V2z_2E0) )
    <=> ( mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V2z_2E0) = V1y_2E0 ) ) ).

tff(thm_2Einteger_2EINT__EQ__SUB__RADD,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2z_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( mono_2Ec_2Einteger_2Eint__sub_2E2(V0x_2E0,V1y_2E0) = V2z_2E0 )
    <=> ( V0x_2E0 = mono_2Ec_2Einteger_2Eint__add_2E2(V2z_2E0,V1y_2E0) ) ) ).

tff(thm_2Einteger_2EINT__SUB,axiom,
    ! [V0n_2E0: mono_2Etyop_2Enum_2Enum,V1m_2E0: mono_2Etyop_2Enum_2Enum] :
      ( p(mono_2Ec_2Earithmetic_2E_3C_3D_2E2(V1m_2E0,V0n_2E0))
     => ( mono_2Ec_2Einteger_2Eint__sub_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(V0n_2E0),mono_2Ec_2Einteger_2Eint__of__num_2E1(V1m_2E0)) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2E_2D_2E2(V0n_2E0,V1m_2E0)) ) ) ).

tff(thm_2Einteger_2EINT__SUB__SUB2,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__sub_2E2(V0x_2E0,mono_2Ec_2Einteger_2Eint__sub_2E2(V0x_2E0,V1y_2E0)) = V1y_2E0 ) ).

tff(thm_2Einteger_2EINT__ADD__SUB2,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__sub_2E2(V0x_2E0,mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V1y_2E0)) = mono_2Ec_2Einteger_2Eint__neg_2E1(V1y_2E0) ) ).

tff(thm_2Einteger_2EINT__EQ__LMUL2,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2z_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V0x_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ( ( V1y_2E0 = V2z_2E0 )
      <=> ( mono_2Ec_2Einteger_2Eint__mul_2E2(V0x_2E0,V1y_2E0) = mono_2Ec_2Einteger_2Eint__mul_2E2(V0x_2E0,V2z_2E0) ) ) ) ).

tff(thm_2Einteger_2EINT__EQ__IMP__LE,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V0x_2E0 = V1y_2E0 )
     => p(mono_2Ec_2Einteger_2Eint__le_2E2(V0x_2E0,V1y_2E0)) ) ).

tff(thm_2Einteger_2EINT__POS__NZ,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0x_2E0))
     => ( V0x_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) ) ).

tff(thm_2Einteger_2EINT__EQ__RMUL__IMP,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2z_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( ( V2z_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
        & ( mono_2Ec_2Einteger_2Eint__mul_2E2(V0x_2E0,V2z_2E0) = mono_2Ec_2Einteger_2Eint__mul_2E2(V1y_2E0,V2z_2E0) ) )
     => ( V0x_2E0 = V1y_2E0 ) ) ).

tff(thm_2Einteger_2EINT__EQ__LMUL__IMP,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2z_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( ( V0x_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
        & ( mono_2Ec_2Einteger_2Eint__mul_2E2(V0x_2E0,V1y_2E0) = mono_2Ec_2Einteger_2Eint__mul_2E2(V0x_2E0,V2z_2E0) ) )
     => ( V1y_2E0 = V2z_2E0 ) ) ).

tff(thm_2Einteger_2EINT__DIFFSQ,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__mul_2E2(mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,V1y_2E0),mono_2Ec_2Einteger_2Eint__sub_2E2(V0x_2E0,V1y_2E0)) = mono_2Ec_2Einteger_2Eint__sub_2E2(mono_2Ec_2Einteger_2Eint__mul_2E2(V0x_2E0,V0x_2E0),mono_2Ec_2Einteger_2Eint__mul_2E2(V1y_2E0,V1y_2E0)) ) ).

tff(thm_2Einteger_2EINT__POASQ,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),mono_2Ec_2Einteger_2Eint__mul_2E2(V0x_2E0,V0x_2E0)))
    <=> ( V0x_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) ) ).

tff(thm_2Einteger_2EINT__SUMSQ,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( mono_2Ec_2Einteger_2Eint__add_2E2(mono_2Ec_2Einteger_2Eint__mul_2E2(V0x_2E0,V0x_2E0),mono_2Ec_2Einteger_2Eint__mul_2E2(V1y_2E0,V1y_2E0)) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
    <=> ( ( V0x_2E0 = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
        & ( V1y_2E0 = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) ) ) ).

tff(thm_2Einteger_2EINT__EQ__NEG,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( mono_2Ec_2Einteger_2Eint__neg_2E1(V0x_2E0) = mono_2Ec_2Einteger_2Eint__neg_2E1(V1y_2E0) )
    <=> ( V0x_2E0 = V1y_2E0 ) ) ).

tff(thm_2Einteger_2EINT__LT__CALCULATE,axiom,
    ! [V0n_2E0: mono_2Etyop_2Enum_2Enum,V1m_2E0: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(V0n_2E0),mono_2Ec_2Einteger_2Eint__of__num_2E1(V1m_2E0)) = mono_2Ec_2Eprim__rec_2E_3C_2E2(V0n_2E0,V1m_2E0) )
      & ( mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2Eint__of__num_2E1(V0n_2E0)),mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2Eint__of__num_2E1(V1m_2E0))) = mono_2Ec_2Eprim__rec_2E_3C_2E2(V1m_2E0,V0n_2E0) )
      & ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2Eint__of__num_2E1(V0n_2E0)),mono_2Ec_2Einteger_2Eint__of__num_2E1(V1m_2E0)))
      <=> ( ( V0n_2E0 != mono_2Ec_2Enum_2E0_2E0 )
          | ( V1m_2E0 != mono_2Ec_2Enum_2E0_2E0 ) ) )
      & ( mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(V0n_2E0),mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2Eint__of__num_2E1(V1m_2E0))) = mono_2Ec_2Ebool_2EF_2E0 ) ) ).

tff(thm_2Einteger_2ENUM__POSINT,axiom,
    ! [F0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29] :
      ( ! [V0i_2E0: mono_2Etyop_2Einteger_2Eint,V1n_2E0: mono_2Etyop_2Enum_2Enum] :
          ( p(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29(F0_2E0,V0i_2E0),V1n_2E0))
        <=> ( V0i_2E0 = mono_2Ec_2Einteger_2Eint__of__num_2E1(V1n_2E0) ) )
     => ! [V0i_2E0: mono_2Etyop_2Einteger_2Eint] :
          ( p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0i_2E0))
         => p(mono_2Ec_2Ebool_2E_3F_21_2E1_2Emono_2Etyop_2Enum_2Enum(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29(F0_2E0,V0i_2E0))) ) ) ).

tff(thm_2Einteger_2ENUM__POSINT__EXISTS,axiom,
    ! [V0i_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0i_2E0))
     => ? [V1n_2E0: mono_2Etyop_2Enum_2Enum] : ( V0i_2E0 = mono_2Ec_2Einteger_2Eint__of__num_2E1(V1n_2E0) ) ) ).

tff(thm_2Einteger_2ENUM__NEGINT__EXISTS,axiom,
    ! [V0i_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__le_2E2(V0i_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0)))
     => ? [V1n_2E0: mono_2Etyop_2Enum_2Enum] : ( V0i_2E0 = mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2Eint__of__num_2E1(V1n_2E0)) ) ) ).

tff(thm_2Einteger_2EINT__NUM__CASES,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ? [V1n_2E0: mono_2Etyop_2Enum_2Enum] :
          ( ( V0p_2E0 = mono_2Ec_2Einteger_2Eint__of__num_2E1(V1n_2E0) )
          & ( V1n_2E0 != mono_2Ec_2Enum_2E0_2E0 ) )
      | ? [V2n_2E0: mono_2Etyop_2Enum_2Enum] :
          ( ( V0p_2E0 = mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2Eint__of__num_2E1(V2n_2E0)) )
          & ( V2n_2E0 != mono_2Ec_2Enum_2E0_2E0 ) )
      | ( V0p_2E0 = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) ) ).

tff(thm_2Einteger_2EINT__DISCRETE,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ~ ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(V0x_2E0,V1y_2E0))
        & p(mono_2Ec_2Einteger_2Eint__lt_2E2(V1y_2E0,mono_2Ec_2Einteger_2Eint__add_2E2(V0x_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0)))))) ) ).

tff(thm_2Einteger_2EINT__LE__LT1,axiom,
    ! [V0y_2E0: mono_2Etyop_2Einteger_2Eint,V1x_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__le_2E2(V1x_2E0,V0y_2E0) = mono_2Ec_2Einteger_2Eint__lt_2E2(V1x_2E0,mono_2Ec_2Einteger_2Eint__add_2E2(V0y_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0))))) ) ).

tff(thm_2Einteger_2EINT__LT__LE1,axiom,
    ! [V0y_2E0: mono_2Etyop_2Einteger_2Eint,V1x_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__lt_2E2(V1x_2E0,V0y_2E0) = mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__add_2E2(V1x_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0)))),V0y_2E0) ) ).

tff(thm_2Einteger_2EINT__MUL__EQ__1,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( mono_2Ec_2Einteger_2Eint__mul_2E2(V0x_2E0,V1y_2E0) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0))) )
    <=> ( ( ( V0x_2E0 = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0))) )
          & ( V1y_2E0 = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0))) ) )
        | ( ( V0x_2E0 = mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0)))) )
          & ( V1y_2E0 = mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0)))) ) ) ) ) ).

tff(thm_2Einteger_2ENUM__OF__INT,axiom,
    ! [V0n_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Einteger_2ENum_2E1(mono_2Ec_2Einteger_2Eint__of__num_2E1(V0n_2E0)) = V0n_2E0 ) ).

tff(thm_2Einteger_2EINT__OF__NUM,axiom,
    ! [V0i_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Einteger_2ENum_2E1(V0i_2E0)) = V0i_2E0 )
    <=> p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0i_2E0)) ) ).

tff(thm_2Einteger_2ELE__NUM__OF__INT,axiom,
    ! [V0n_2E0: mono_2Etyop_2Enum_2Enum,V1i_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(V0n_2E0),V1i_2E0))
     => p(mono_2Ec_2Earithmetic_2E_3C_3D_2E2(V0n_2E0,mono_2Ec_2Einteger_2ENum_2E1(V1i_2E0))) ) ).

tff(thm_2Einteger_2ENUM__LT,axiom,
    ! [V0y_2E0: mono_2Etyop_2Einteger_2Eint,V1x_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V1x_2E0))
        & p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0y_2E0)) )
     => ( mono_2Ec_2Eprim__rec_2E_3C_2E2(mono_2Ec_2Einteger_2ENum_2E1(V1x_2E0),mono_2Ec_2Einteger_2ENum_2E1(V0y_2E0)) = mono_2Ec_2Einteger_2Eint__lt_2E2(V1x_2E0,V0y_2E0) ) ) ).

tff(thm_2Einteger_2EINT__DIV,axiom,
    ! [V0n_2E0: mono_2Etyop_2Enum_2Enum,V1m_2E0: mono_2Etyop_2Enum_2Enum] :
      ( ( V1m_2E0 != mono_2Ec_2Enum_2E0_2E0 )
     => ( mono_2Ec_2Einteger_2Eint__div_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(V0n_2E0),mono_2Ec_2Einteger_2Eint__of__num_2E1(V1m_2E0)) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2EDIV_2E2(V0n_2E0,V1m_2E0)) ) ) ).

tff(thm_2Einteger_2EINT__DIV__NEG,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint,V1q_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V1q_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ( mono_2Ec_2Einteger_2Eint__div_2E2(V0p_2E0,mono_2Ec_2Einteger_2Eint__neg_2E1(V1q_2E0)) = mono_2Ec_2Einteger_2Eint__div_2E2(mono_2Ec_2Einteger_2Eint__neg_2E1(V0p_2E0),V1q_2E0) ) ) ).

tff(thm_2Einteger_2EINT__DIV__1,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__div_2E2(V0p_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0)))) = V0p_2E0 ) ).

tff(thm_2Einteger_2EINT__DIV__0,axiom,
    ! [V0q_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V0q_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ( mono_2Ec_2Einteger_2Eint__div_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0q_2E0) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) ) ).

tff(thm_2Einteger_2EINT__DIV__ID,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V0p_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ( mono_2Ec_2Einteger_2Eint__div_2E2(V0p_2E0,V0p_2E0) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0))) ) ) ).

tff(thm_2Einteger_2EINT__MOD__BOUNDS,axiom,
    ! [F0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29,F1_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29] :
      ( ! [V1q_2E0: mono_2Etyop_2Einteger_2Eint,V0p_2E0: mono_2Etyop_2Einteger_2Eint] :
          ( p(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(F0_2E0,V1q_2E0),V0p_2E0))
        <=> ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(V1q_2E0,mono_2Ec_2Einteger_2Eint__mod_2E2(V0p_2E0,V1q_2E0)))
            & p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__mod_2E2(V0p_2E0,V1q_2E0),mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0))) ) )
     => ( ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint,V1q_2E0: mono_2Etyop_2Einteger_2Eint] :
            ( p(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(F1_2E0,V0p_2E0),V1q_2E0))
          <=> ( p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),mono_2Ec_2Einteger_2Eint__mod_2E2(V0p_2E0,V1q_2E0)))
              & p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__mod_2E2(V0p_2E0,V1q_2E0),V1q_2E0)) ) )
       => ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint,V1q_2E0: mono_2Etyop_2Einteger_2Eint] :
            ( ( V1q_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
           => p(mono_2Ec_2Ebool_2ECOND_2E3_2Emono_2Etyop_2Emin_2Ebool(mono_2Ec_2Einteger_2Eint__lt_2E2(V1q_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0)),mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(F0_2E0,V1q_2E0),V0p_2E0),mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(F1_2E0,V0p_2E0),V1q_2E0))) ) ) ) ).

tff(thm_2Einteger_2EINT__DIVISION,axiom,
    ! [F0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29,F1_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29] :
      ( ! [V0q_2E0: mono_2Etyop_2Einteger_2Eint,V1p_2E0: mono_2Etyop_2Einteger_2Eint] :
          ( p(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(F0_2E0,V0q_2E0),V1p_2E0))
        <=> ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(V0q_2E0,mono_2Ec_2Einteger_2Eint__mod_2E2(V1p_2E0,V0q_2E0)))
            & p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__mod_2E2(V1p_2E0,V0q_2E0),mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0))) ) )
     => ( ! [V1p_2E0: mono_2Etyop_2Einteger_2Eint,V0q_2E0: mono_2Etyop_2Einteger_2Eint] :
            ( p(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(F1_2E0,V1p_2E0),V0q_2E0))
          <=> ( p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),mono_2Ec_2Einteger_2Eint__mod_2E2(V1p_2E0,V0q_2E0)))
              & p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__mod_2E2(V1p_2E0,V0q_2E0),V0q_2E0)) ) )
       => ! [V0q_2E0: mono_2Etyop_2Einteger_2Eint] :
            ( ( V0q_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
           => ! [V1p_2E0: mono_2Etyop_2Einteger_2Eint] :
                ( ( V1p_2E0 = mono_2Ec_2Einteger_2Eint__add_2E2(mono_2Ec_2Einteger_2Eint__mul_2E2(mono_2Ec_2Einteger_2Eint__div_2E2(V1p_2E0,V0q_2E0),V0q_2E0),mono_2Ec_2Einteger_2Eint__mod_2E2(V1p_2E0,V0q_2E0)) )
                & p(mono_2Ec_2Ebool_2ECOND_2E3_2Emono_2Etyop_2Emin_2Ebool(mono_2Ec_2Einteger_2Eint__lt_2E2(V0q_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0)),mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(F0_2E0,V0q_2E0),V1p_2E0),mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(F1_2E0,V1p_2E0),V0q_2E0))) ) ) ) ) ).

tff(thm_2Einteger_2EINT__MOD,axiom,
    ! [V0n_2E0: mono_2Etyop_2Enum_2Enum,V1m_2E0: mono_2Etyop_2Enum_2Enum] :
      ( ( V1m_2E0 != mono_2Ec_2Enum_2E0_2E0 )
     => ( mono_2Ec_2Einteger_2Eint__mod_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(V0n_2E0),mono_2Ec_2Einteger_2Eint__of__num_2E1(V1m_2E0)) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2EMOD_2E2(V0n_2E0,V1m_2E0)) ) ) ).

tff(thm_2Einteger_2EINT__MOD__NEG,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint,V1q_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V1q_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ( mono_2Ec_2Einteger_2Eint__mod_2E2(V0p_2E0,mono_2Ec_2Einteger_2Eint__neg_2E1(V1q_2E0)) = mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2Eint__mod_2E2(mono_2Ec_2Einteger_2Eint__neg_2E1(V0p_2E0),V1q_2E0)) ) ) ).

tff(thm_2Einteger_2EINT__MOD0,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V0p_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ( mono_2Ec_2Einteger_2Eint__mod_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0p_2E0) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) ) ).

tff(thm_2Einteger_2EINT__DIV__MUL__ID,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint,V1q_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( ( V1q_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
        & ( mono_2Ec_2Einteger_2Eint__mod_2E2(V0p_2E0,V1q_2E0) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) )
     => ( mono_2Ec_2Einteger_2Eint__mul_2E2(mono_2Ec_2Einteger_2Eint__div_2E2(V0p_2E0,V1q_2E0),V1q_2E0) = V0p_2E0 ) ) ).

tff(thm_2Einteger_2EINT__DIV__UNIQUE,axiom,
    ! [F0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29,F1_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29] :
      ( ! [V1j_2E0: mono_2Etyop_2Einteger_2Eint,V3r_2E0: mono_2Etyop_2Einteger_2Eint] :
          ( p(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(F0_2E0,V1j_2E0),V3r_2E0))
        <=> ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(V1j_2E0,V3r_2E0))
            & p(mono_2Ec_2Einteger_2Eint__le_2E2(V3r_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0))) ) )
     => ( ! [V3r_2E0: mono_2Etyop_2Einteger_2Eint,V1j_2E0: mono_2Etyop_2Einteger_2Eint] :
            ( p(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(F1_2E0,V3r_2E0),V1j_2E0))
          <=> ( p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V3r_2E0))
              & p(mono_2Ec_2Einteger_2Eint__lt_2E2(V3r_2E0,V1j_2E0)) ) )
       => ! [V0i_2E0: mono_2Etyop_2Einteger_2Eint,V1j_2E0: mono_2Etyop_2Einteger_2Eint,V2q_2E0: mono_2Etyop_2Einteger_2Eint] :
            ( ? [V3r_2E0: mono_2Etyop_2Einteger_2Eint] :
                ( ( V0i_2E0 = mono_2Ec_2Einteger_2Eint__add_2E2(mono_2Ec_2Einteger_2Eint__mul_2E2(V2q_2E0,V1j_2E0),V3r_2E0) )
                & p(mono_2Ec_2Ebool_2ECOND_2E3_2Emono_2Etyop_2Emin_2Ebool(mono_2Ec_2Einteger_2Eint__lt_2E2(V1j_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0)),mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(F0_2E0,V1j_2E0),V3r_2E0),mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(F1_2E0,V3r_2E0),V1j_2E0))) )
           => ( mono_2Ec_2Einteger_2Eint__div_2E2(V0i_2E0,V1j_2E0) = V2q_2E0 ) ) ) ) ).

tff(thm_2Einteger_2EINT__MOD__UNIQUE,axiom,
    ! [F0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29,F1_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29_29] :
      ( ! [V1j_2E0: mono_2Etyop_2Einteger_2Eint,V2m_2E0: mono_2Etyop_2Einteger_2Eint] :
          ( p(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(F0_2E0,V1j_2E0),V2m_2E0))
        <=> ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(V1j_2E0,V2m_2E0))
            & p(mono_2Ec_2Einteger_2Eint__le_2E2(V2m_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0))) ) )
     => ( ! [V2m_2E0: mono_2Etyop_2Einteger_2Eint,V1j_2E0: mono_2Etyop_2Einteger_2Eint] :
            ( p(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(F1_2E0,V2m_2E0),V1j_2E0))
          <=> ( p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V2m_2E0))
              & p(mono_2Ec_2Einteger_2Eint__lt_2E2(V2m_2E0,V1j_2E0)) ) )
       => ! [V0i_2E0: mono_2Etyop_2Einteger_2Eint,V1j_2E0: mono_2Etyop_2Einteger_2Eint,V2m_2E0: mono_2Etyop_2Einteger_2Eint] :
            ( ? [V3q_2E0: mono_2Etyop_2Einteger_2Eint] :
                ( ( V0i_2E0 = mono_2Ec_2Einteger_2Eint__add_2E2(mono_2Ec_2Einteger_2Eint__mul_2E2(V3q_2E0,V1j_2E0),V2m_2E0) )
                & p(mono_2Ec_2Ebool_2ECOND_2E3_2Emono_2Etyop_2Emin_2Ebool(mono_2Ec_2Einteger_2Eint__lt_2E2(V1j_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0)),mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(F0_2E0,V1j_2E0),V2m_2E0),mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29(F1_2E0,V2m_2E0),V1j_2E0))) )
           => ( mono_2Ec_2Einteger_2Eint__mod_2E2(V0i_2E0,V1j_2E0) = V2m_2E0 ) ) ) ) ).

tff(thm_2Einteger_2EINT__MOD__ID,axiom,
    ! [V0i_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V0i_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ( mono_2Ec_2Einteger_2Eint__mod_2E2(V0i_2E0,V0i_2E0) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) ) ).

tff(thm_2Einteger_2EINT__MOD__COMMON__FACTOR,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V0p_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ! [V1q_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__mod_2E2(mono_2Ec_2Einteger_2Eint__mul_2E2(V1q_2E0,V0p_2E0),V0p_2E0) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) ) ).

tff(thm_2Einteger_2EINT__DIV__LMUL,axiom,
    ! [V0i_2E0: mono_2Etyop_2Einteger_2Eint,V1j_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V0i_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ( mono_2Ec_2Einteger_2Eint__div_2E2(mono_2Ec_2Einteger_2Eint__mul_2E2(V0i_2E0,V1j_2E0),V0i_2E0) = V1j_2E0 ) ) ).

tff(thm_2Einteger_2EINT__DIV__RMUL,axiom,
    ! [V0i_2E0: mono_2Etyop_2Einteger_2Eint,V1j_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V0i_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ( mono_2Ec_2Einteger_2Eint__div_2E2(mono_2Ec_2Einteger_2Eint__mul_2E2(V1j_2E0,V0i_2E0),V0i_2E0) = V1j_2E0 ) ) ).

tff(thm_2Einteger_2EINT__MOD__EQ0,axiom,
    ! [V0q_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V0q_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ! [V1p_2E0: mono_2Etyop_2Einteger_2Eint] :
          ( ( mono_2Ec_2Einteger_2Eint__mod_2E2(V1p_2E0,V0q_2E0) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
        <=> ? [V2k_2E0: mono_2Etyop_2Einteger_2Eint] : ( V1p_2E0 = mono_2Ec_2Einteger_2Eint__mul_2E2(V2k_2E0,V0q_2E0) ) ) ) ).

tff(thm_2Einteger_2EINT__MUL__DIV,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint,V1q_2E0: mono_2Etyop_2Einteger_2Eint,V2k_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( ( V1q_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
        & ( mono_2Ec_2Einteger_2Eint__mod_2E2(V0p_2E0,V1q_2E0) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) )
     => ( mono_2Ec_2Einteger_2Eint__div_2E2(mono_2Ec_2Einteger_2Eint__mul_2E2(V2k_2E0,V0p_2E0),V1q_2E0) = mono_2Ec_2Einteger_2Eint__mul_2E2(V2k_2E0,mono_2Ec_2Einteger_2Eint__div_2E2(V0p_2E0,V1q_2E0)) ) ) ).

tff(thm_2Einteger_2EINT__ADD__DIV,axiom,
    ! [V0i_2E0: mono_2Etyop_2Einteger_2Eint,V1j_2E0: mono_2Etyop_2Einteger_2Eint,V2k_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( ( V2k_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
        & ( ( mono_2Ec_2Einteger_2Eint__mod_2E2(V0i_2E0,V2k_2E0) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
          | ( mono_2Ec_2Einteger_2Eint__mod_2E2(V1j_2E0,V2k_2E0) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) ) )
     => ( mono_2Ec_2Einteger_2Eint__div_2E2(mono_2Ec_2Einteger_2Eint__add_2E2(V0i_2E0,V1j_2E0),V2k_2E0) = mono_2Ec_2Einteger_2Eint__add_2E2(mono_2Ec_2Einteger_2Eint__div_2E2(V0i_2E0,V2k_2E0),mono_2Ec_2Einteger_2Eint__div_2E2(V1j_2E0,V2k_2E0)) ) ) ).

tff(thm_2Einteger_2EINT__MOD__ADD__MULTIPLES,axiom,
    ! [V0r_2E0: mono_2Etyop_2Einteger_2Eint,V1q_2E0: mono_2Etyop_2Einteger_2Eint,V2k_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V2k_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ( mono_2Ec_2Einteger_2Eint__mod_2E2(mono_2Ec_2Einteger_2Eint__add_2E2(mono_2Ec_2Einteger_2Eint__mul_2E2(V1q_2E0,V2k_2E0),V0r_2E0),V2k_2E0) = mono_2Ec_2Einteger_2Eint__mod_2E2(V0r_2E0,V2k_2E0) ) ) ).

tff(thm_2Einteger_2EINT__MOD__NEG__NUMERATOR,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1k_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V1k_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ( mono_2Ec_2Einteger_2Eint__mod_2E2(mono_2Ec_2Einteger_2Eint__neg_2E1(V0x_2E0),V1k_2E0) = mono_2Ec_2Einteger_2Eint__mod_2E2(mono_2Ec_2Einteger_2Eint__sub_2E2(V1k_2E0,V0x_2E0),V1k_2E0) ) ) ).

tff(thm_2Einteger_2EINT__MOD__PLUS,axiom,
    ! [V0k_2E0: mono_2Etyop_2Einteger_2Eint,V1j_2E0: mono_2Etyop_2Einteger_2Eint,V2i_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V0k_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ( mono_2Ec_2Einteger_2Eint__mod_2E2(mono_2Ec_2Einteger_2Eint__add_2E2(mono_2Ec_2Einteger_2Eint__mod_2E2(V2i_2E0,V0k_2E0),mono_2Ec_2Einteger_2Eint__mod_2E2(V1j_2E0,V0k_2E0)),V0k_2E0) = mono_2Ec_2Einteger_2Eint__mod_2E2(mono_2Ec_2Einteger_2Eint__add_2E2(V2i_2E0,V1j_2E0),V0k_2E0) ) ) ).

tff(thm_2Einteger_2EINT__MOD__SUB,axiom,
    ! [V0k_2E0: mono_2Etyop_2Einteger_2Eint,V1j_2E0: mono_2Etyop_2Einteger_2Eint,V2i_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V0k_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ( mono_2Ec_2Einteger_2Eint__mod_2E2(mono_2Ec_2Einteger_2Eint__sub_2E2(mono_2Ec_2Einteger_2Eint__mod_2E2(V2i_2E0,V0k_2E0),mono_2Ec_2Einteger_2Eint__mod_2E2(V1j_2E0,V0k_2E0)),V0k_2E0) = mono_2Ec_2Einteger_2Eint__mod_2E2(mono_2Ec_2Einteger_2Eint__sub_2E2(V2i_2E0,V1j_2E0),V0k_2E0) ) ) ).

tff(thm_2Einteger_2EINT__MOD__MOD,axiom,
    ! [V0k_2E0: mono_2Etyop_2Einteger_2Eint,V1j_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V0k_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ( mono_2Ec_2Einteger_2Eint__mod_2E2(mono_2Ec_2Einteger_2Eint__mod_2E2(V1j_2E0,V0k_2E0),V0k_2E0) = mono_2Ec_2Einteger_2Eint__mod_2E2(V1j_2E0,V0k_2E0) ) ) ).

tff(thm_2Einteger_2EINT__DIV__P,axiom,
    ! [V0P_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29,V1x_2E0: mono_2Etyop_2Einteger_2Eint,V2c_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V2c_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ( p(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(V0P_2E0,mono_2Ec_2Einteger_2Eint__div_2E2(V1x_2E0,V2c_2E0)))
      <=> ? [V3k_2E0: mono_2Etyop_2Einteger_2Eint,V4r_2E0: mono_2Etyop_2Einteger_2Eint] :
            ( ( V1x_2E0 = mono_2Ec_2Einteger_2Eint__add_2E2(mono_2Ec_2Einteger_2Eint__mul_2E2(V3k_2E0,V2c_2E0),V4r_2E0) )
            & ( ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(V2c_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0)))
                & p(mono_2Ec_2Einteger_2Eint__lt_2E2(V2c_2E0,V4r_2E0))
                & p(mono_2Ec_2Einteger_2Eint__le_2E2(V4r_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0))) )
              | ( ~ p(mono_2Ec_2Einteger_2Eint__lt_2E2(V2c_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0)))
                & p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V4r_2E0))
                & p(mono_2Ec_2Einteger_2Eint__lt_2E2(V4r_2E0,V2c_2E0)) ) )
            & p(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(V0P_2E0,V3k_2E0)) ) ) ) ).

tff(thm_2Einteger_2EINT__MOD__P,axiom,
    ! [V0P_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29,V1x_2E0: mono_2Etyop_2Einteger_2Eint,V2c_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V2c_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ( p(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(V0P_2E0,mono_2Ec_2Einteger_2Eint__mod_2E2(V1x_2E0,V2c_2E0)))
      <=> ? [V3k_2E0: mono_2Etyop_2Einteger_2Eint,V4r_2E0: mono_2Etyop_2Einteger_2Eint] :
            ( ( V1x_2E0 = mono_2Ec_2Einteger_2Eint__add_2E2(mono_2Ec_2Einteger_2Eint__mul_2E2(V3k_2E0,V2c_2E0),V4r_2E0) )
            & ( ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(V2c_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0)))
                & p(mono_2Ec_2Einteger_2Eint__lt_2E2(V2c_2E0,V4r_2E0))
                & p(mono_2Ec_2Einteger_2Eint__le_2E2(V4r_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0))) )
              | ( ~ p(mono_2Ec_2Einteger_2Eint__lt_2E2(V2c_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0)))
                & p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V4r_2E0))
                & p(mono_2Ec_2Einteger_2Eint__lt_2E2(V4r_2E0,V2c_2E0)) ) )
            & p(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(V0P_2E0,V4r_2E0)) ) ) ) ).

tff(thm_2Einteger_2EINT__DIV__FORALL__P,axiom,
    ! [V0P_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29,V1x_2E0: mono_2Etyop_2Einteger_2Eint,V2c_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V2c_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ( p(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(V0P_2E0,mono_2Ec_2Einteger_2Eint__div_2E2(V1x_2E0,V2c_2E0)))
      <=> ! [V3k_2E0: mono_2Etyop_2Einteger_2Eint,V4r_2E0: mono_2Etyop_2Einteger_2Eint] :
            ( ( ( V1x_2E0 = mono_2Ec_2Einteger_2Eint__add_2E2(mono_2Ec_2Einteger_2Eint__mul_2E2(V3k_2E0,V2c_2E0),V4r_2E0) )
              & ( ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(V2c_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0)))
                  & p(mono_2Ec_2Einteger_2Eint__lt_2E2(V2c_2E0,V4r_2E0))
                  & p(mono_2Ec_2Einteger_2Eint__le_2E2(V4r_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0))) )
                | ( ~ p(mono_2Ec_2Einteger_2Eint__lt_2E2(V2c_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0)))
                  & p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V4r_2E0))
                  & p(mono_2Ec_2Einteger_2Eint__lt_2E2(V4r_2E0,V2c_2E0)) ) ) )
           => p(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(V0P_2E0,V3k_2E0)) ) ) ) ).

tff(thm_2Einteger_2EINT__MOD__FORALL__P,axiom,
    ! [V0P_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Einteger_2Eint_2Ctyop_2Emin_2Ebool_29,V1x_2E0: mono_2Etyop_2Einteger_2Eint,V2c_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V2c_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ( p(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(V0P_2E0,mono_2Ec_2Einteger_2Eint__mod_2E2(V1x_2E0,V2c_2E0)))
      <=> ! [V3q_2E0: mono_2Etyop_2Einteger_2Eint,V4r_2E0: mono_2Etyop_2Einteger_2Eint] :
            ( ( ( V1x_2E0 = mono_2Ec_2Einteger_2Eint__add_2E2(mono_2Ec_2Einteger_2Eint__mul_2E2(V3q_2E0,V2c_2E0),V4r_2E0) )
              & ( ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(V2c_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0)))
                  & p(mono_2Ec_2Einteger_2Eint__lt_2E2(V2c_2E0,V4r_2E0))
                  & p(mono_2Ec_2Einteger_2Eint__le_2E2(V4r_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0))) )
                | ( ~ p(mono_2Ec_2Einteger_2Eint__lt_2E2(V2c_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0)))
                  & p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V4r_2E0))
                  & p(mono_2Ec_2Einteger_2Eint__lt_2E2(V4r_2E0,V2c_2E0)) ) ) )
           => p(mono_2Eapp_2E2_2Emono_2Etyop_2Einteger_2Eint_20mono_2Etyop_2Emin_2Ebool(V0P_2E0,V4r_2E0)) ) ) ) ).

tff(thm_2Einteger_2EINT__MOD__1,axiom,
    ! [V0i_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__mod_2E2(V0i_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0)))) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) ).

tff(thm_2Einteger_2EINT__LESS__MOD,axiom,
    ! [V0i_2E0: mono_2Etyop_2Einteger_2Eint,V1j_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0i_2E0))
        & p(mono_2Ec_2Einteger_2Eint__lt_2E2(V0i_2E0,V1j_2E0)) )
     => ( mono_2Ec_2Einteger_2Eint__mod_2E2(V0i_2E0,V1j_2E0) = V0i_2E0 ) ) ).

tff(thm_2Einteger_2EINT__MOD__MINUS1,axiom,
    ! [V0n_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0n_2E0))
     => ( mono_2Ec_2Einteger_2Eint__mod_2E2(mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0)))),V0n_2E0) = mono_2Ec_2Einteger_2Eint__sub_2E2(V0n_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0)))) ) ) ).

tff(thm_2Einteger_2EINT__ABS__POS,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint] : p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),mono_2Ec_2Einteger_2EABS_2E1(V0p_2E0))) ).

tff(thm_2Einteger_2EINT__ABS__NUM,axiom,
    ! [V0n_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Einteger_2EABS_2E1(mono_2Ec_2Einteger_2Eint__of__num_2E1(V0n_2E0)) = mono_2Ec_2Einteger_2Eint__of__num_2E1(V0n_2E0) ) ).

tff(thm_2Einteger_2EINT__NEG__SAME__EQ,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V0p_2E0 = mono_2Ec_2Einteger_2Eint__neg_2E1(V0p_2E0) )
    <=> ( V0p_2E0 = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) ) ).

tff(thm_2Einteger_2EINT__ABS__NEG,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2EABS_2E1(mono_2Ec_2Einteger_2Eint__neg_2E1(V0p_2E0)) = mono_2Ec_2Einteger_2EABS_2E1(V0p_2E0) ) ).

tff(thm_2Einteger_2EINT__ABS__ABS,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2EABS_2E1(mono_2Ec_2Einteger_2EABS_2E1(V0p_2E0)) = mono_2Ec_2Einteger_2EABS_2E1(V0p_2E0) ) ).

tff(thm_2Einteger_2EINT__ABS__EQ__ID,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( mono_2Ec_2Einteger_2EABS_2E1(V0p_2E0) = V0p_2E0 )
    <=> p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0p_2E0)) ) ).

tff(thm_2Einteger_2EINT__ABS__MUL,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint,V1q_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__mul_2E2(mono_2Ec_2Einteger_2EABS_2E1(V0p_2E0),mono_2Ec_2Einteger_2EABS_2E1(V1q_2E0)) = mono_2Ec_2Einteger_2EABS_2E1(mono_2Ec_2Einteger_2Eint__mul_2E2(V0p_2E0,V1q_2E0)) ) ).

tff(thm_2Einteger_2EINT__ABS__EQ0,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( mono_2Ec_2Einteger_2EABS_2E1(V0p_2E0) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
    <=> ( V0p_2E0 = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) ) ).

tff(thm_2Einteger_2EINT__ABS__LT0,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint] : ~ p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2EABS_2E1(V0p_2E0),mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0))) ).

tff(thm_2Einteger_2EINT__ABS__0LT,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),mono_2Ec_2Einteger_2EABS_2E1(V0p_2E0)))
    <=> ( V0p_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) ) ).

tff(thm_2Einteger_2EINT__ABS__LE0,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2EABS_2E1(V0p_2E0),mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0)))
    <=> ( V0p_2E0 = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) ) ).

tff(thm_2Einteger_2EINT__ABS__LT,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint,V1q_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2EABS_2E1(V0p_2E0),V1q_2E0))
      <=> ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(V0p_2E0,V1q_2E0))
          & p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__neg_2E1(V1q_2E0),V0p_2E0)) ) )
      & ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(V1q_2E0,mono_2Ec_2Einteger_2EABS_2E1(V0p_2E0)))
      <=> ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(V1q_2E0,V0p_2E0))
          | p(mono_2Ec_2Einteger_2Eint__lt_2E2(V0p_2E0,mono_2Ec_2Einteger_2Eint__neg_2E1(V1q_2E0))) ) )
      & ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2EABS_2E1(V0p_2E0)),V1q_2E0))
      <=> ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__neg_2E1(V1q_2E0),V0p_2E0))
          | p(mono_2Ec_2Einteger_2Eint__lt_2E2(V0p_2E0,V1q_2E0)) ) )
      & ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(V1q_2E0,mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2EABS_2E1(V0p_2E0))))
      <=> ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(V0p_2E0,mono_2Ec_2Einteger_2Eint__neg_2E1(V1q_2E0)))
          & p(mono_2Ec_2Einteger_2Eint__lt_2E2(V1q_2E0,V0p_2E0)) ) ) ) ).

tff(thm_2Einteger_2EINT__ABS__LE,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint,V1q_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2EABS_2E1(V0p_2E0),V1q_2E0))
      <=> ( p(mono_2Ec_2Einteger_2Eint__le_2E2(V0p_2E0,V1q_2E0))
          & p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__neg_2E1(V1q_2E0),V0p_2E0)) ) )
      & ( p(mono_2Ec_2Einteger_2Eint__le_2E2(V1q_2E0,mono_2Ec_2Einteger_2EABS_2E1(V0p_2E0)))
      <=> ( p(mono_2Ec_2Einteger_2Eint__le_2E2(V1q_2E0,V0p_2E0))
          | p(mono_2Ec_2Einteger_2Eint__le_2E2(V0p_2E0,mono_2Ec_2Einteger_2Eint__neg_2E1(V1q_2E0))) ) )
      & ( p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2EABS_2E1(V0p_2E0)),V1q_2E0))
      <=> ( p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__neg_2E1(V1q_2E0),V0p_2E0))
          | p(mono_2Ec_2Einteger_2Eint__le_2E2(V0p_2E0,V1q_2E0)) ) )
      & ( p(mono_2Ec_2Einteger_2Eint__le_2E2(V1q_2E0,mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2EABS_2E1(V0p_2E0))))
      <=> ( p(mono_2Ec_2Einteger_2Eint__le_2E2(V0p_2E0,mono_2Ec_2Einteger_2Eint__neg_2E1(V1q_2E0)))
          & p(mono_2Ec_2Einteger_2Eint__le_2E2(V1q_2E0,V0p_2E0)) ) ) ) ).

tff(thm_2Einteger_2EINT__ABS__EQ,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint,V1q_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( ( mono_2Ec_2Einteger_2EABS_2E1(V0p_2E0) = V1q_2E0 )
      <=> ( ( ( V0p_2E0 = V1q_2E0 )
            & p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V1q_2E0)) )
          | ( ( V0p_2E0 = mono_2Ec_2Einteger_2Eint__neg_2E1(V1q_2E0) )
            & p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V1q_2E0)) ) ) )
      & ( ( V1q_2E0 = mono_2Ec_2Einteger_2EABS_2E1(V0p_2E0) )
      <=> ( ( ( V0p_2E0 = V1q_2E0 )
            & p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V1q_2E0)) )
          | ( ( V0p_2E0 = mono_2Ec_2Einteger_2Eint__neg_2E1(V1q_2E0) )
            & p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V1q_2E0)) ) ) ) ) ).

tff(thm_2Einteger_2EINT__ABS__EQ__ABS,axiom,
    ! [V0y_2E0: mono_2Etyop_2Einteger_2Eint,V1x_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( mono_2Ec_2Einteger_2EABS_2E1(V1x_2E0) = mono_2Ec_2Einteger_2EABS_2E1(V0y_2E0) )
    <=> ( ( V1x_2E0 = V0y_2E0 )
        | ( V1x_2E0 = mono_2Ec_2Einteger_2Eint__neg_2E1(V0y_2E0) ) ) ) ).

tff(thm_2Einteger_2EINT__QUOT,axiom,
    ! [V0p_2E0: mono_2Etyop_2Enum_2Enum,V1q_2E0: mono_2Etyop_2Enum_2Enum] :
      ( ( V1q_2E0 != mono_2Ec_2Enum_2E0_2E0 )
     => ( mono_2Ec_2Einteger_2Eint__quot_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(V0p_2E0),mono_2Ec_2Einteger_2Eint__of__num_2E1(V1q_2E0)) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2EDIV_2E2(V0p_2E0,V1q_2E0)) ) ) ).

tff(thm_2Einteger_2EINT__QUOT__0,axiom,
    ! [V0q_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V0q_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ( mono_2Ec_2Einteger_2Eint__quot_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0q_2E0) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) ) ).

tff(thm_2Einteger_2EINT__QUOT__1,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__quot_2E2(V0p_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0)))) = V0p_2E0 ) ).

tff(thm_2Einteger_2EINT__QUOT__NEG,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint,V1q_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V1q_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ( ( mono_2Ec_2Einteger_2Eint__quot_2E2(mono_2Ec_2Einteger_2Eint__neg_2E1(V0p_2E0),V1q_2E0) = mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2Eint__quot_2E2(V0p_2E0,V1q_2E0)) )
        & ( mono_2Ec_2Einteger_2Eint__quot_2E2(V0p_2E0,mono_2Ec_2Einteger_2Eint__neg_2E1(V1q_2E0)) = mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2Eint__quot_2E2(V0p_2E0,V1q_2E0)) ) ) ) ).

tff(thm_2Einteger_2EINT__ABS__QUOT,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint,V1q_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V1q_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => p(mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2EABS_2E1(mono_2Ec_2Einteger_2Eint__mul_2E2(mono_2Ec_2Einteger_2Eint__quot_2E2(V0p_2E0,V1q_2E0),V1q_2E0)),mono_2Ec_2Einteger_2EABS_2E1(V0p_2E0))) ) ).

tff(thm_2Einteger_2EINT__QUOT__UNIQUE,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint,V1q_2E0: mono_2Etyop_2Einteger_2Eint,V2k_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ? [V3r_2E0: mono_2Etyop_2Einteger_2Eint] :
          ( ( V0p_2E0 = mono_2Ec_2Einteger_2Eint__add_2E2(mono_2Ec_2Einteger_2Eint__mul_2E2(V2k_2E0,V1q_2E0),V3r_2E0) )
          & p(mono_2Ec_2Ebool_2ECOND_2E3_2Emono_2Etyop_2Emin_2Ebool(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0p_2E0),mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V3r_2E0),mono_2Ec_2Einteger_2Eint__le_2E2(V3r_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0))))
          & p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2EABS_2E1(V3r_2E0),mono_2Ec_2Einteger_2EABS_2E1(V1q_2E0))) )
     => ( mono_2Ec_2Einteger_2Eint__quot_2E2(V0p_2E0,V1q_2E0) = V2k_2E0 ) ) ).

tff(thm_2Einteger_2EINT__QUOT__ID,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V0p_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ( mono_2Ec_2Einteger_2Eint__quot_2E2(V0p_2E0,V0p_2E0) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0))) ) ) ).

tff(thm_2Einteger_2EINT__REM,axiom,
    ! [V0p_2E0: mono_2Etyop_2Enum_2Enum,V1q_2E0: mono_2Etyop_2Enum_2Enum] :
      ( ( V1q_2E0 != mono_2Ec_2Enum_2E0_2E0 )
     => ( mono_2Ec_2Einteger_2Eint__rem_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(V0p_2E0),mono_2Ec_2Einteger_2Eint__of__num_2E1(V1q_2E0)) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2EMOD_2E2(V0p_2E0,V1q_2E0)) ) ) ).

tff(thm_2Einteger_2EINT__REMQUOT,axiom,
    ! [V0q_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V0q_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ! [V1p_2E0: mono_2Etyop_2Einteger_2Eint] :
          ( ( V1p_2E0 = mono_2Ec_2Einteger_2Eint__add_2E2(mono_2Ec_2Einteger_2Eint__mul_2E2(mono_2Ec_2Einteger_2Eint__quot_2E2(V1p_2E0,V0q_2E0),V0q_2E0),mono_2Ec_2Einteger_2Eint__rem_2E2(V1p_2E0,V0q_2E0)) )
          & p(mono_2Ec_2Ebool_2ECOND_2E3_2Emono_2Etyop_2Emin_2Ebool(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V1p_2E0),mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),mono_2Ec_2Einteger_2Eint__rem_2E2(V1p_2E0,V0q_2E0)),mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__rem_2E2(V1p_2E0,V0q_2E0),mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0))))
          & p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2EABS_2E1(mono_2Ec_2Einteger_2Eint__rem_2E2(V1p_2E0,V0q_2E0)),mono_2Ec_2Einteger_2EABS_2E1(V0q_2E0))) ) ) ).

tff(thm_2Einteger_2EINT__REM__UNIQUE,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint,V1q_2E0: mono_2Etyop_2Einteger_2Eint,V2r_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2EABS_2E1(V2r_2E0),mono_2Ec_2Einteger_2EABS_2E1(V1q_2E0)))
        & p(mono_2Ec_2Ebool_2ECOND_2E3_2Emono_2Etyop_2Emin_2Ebool(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0p_2E0),mono_2Ec_2Einteger_2Eint__le_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V2r_2E0),mono_2Ec_2Einteger_2Eint__le_2E2(V2r_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0))))
        & ? [V3k_2E0: mono_2Etyop_2Einteger_2Eint] : ( V0p_2E0 = mono_2Ec_2Einteger_2Eint__add_2E2(mono_2Ec_2Einteger_2Eint__mul_2E2(V3k_2E0,V1q_2E0),V2r_2E0) ) )
     => ( mono_2Ec_2Einteger_2Eint__rem_2E2(V0p_2E0,V1q_2E0) = V2r_2E0 ) ) ).

tff(thm_2Einteger_2EINT__REM__NEG,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint,V1q_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V1q_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ( ( mono_2Ec_2Einteger_2Eint__rem_2E2(mono_2Ec_2Einteger_2Eint__neg_2E1(V0p_2E0),V1q_2E0) = mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2Eint__rem_2E2(V0p_2E0,V1q_2E0)) )
        & ( mono_2Ec_2Einteger_2Eint__rem_2E2(V0p_2E0,mono_2Ec_2Einteger_2Eint__neg_2E1(V1q_2E0)) = mono_2Ec_2Einteger_2Eint__rem_2E2(V0p_2E0,V1q_2E0) ) ) ) ).

tff(thm_2Einteger_2EINT__REM__ID,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V0p_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ( mono_2Ec_2Einteger_2Eint__rem_2E2(V0p_2E0,V0p_2E0) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) ) ).

tff(thm_2Einteger_2EINT__REM0,axiom,
    ! [V0q_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V0q_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ( mono_2Ec_2Einteger_2Eint__rem_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V0q_2E0) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) ) ).

tff(thm_2Einteger_2EINT__REM__COMMON__FACTOR,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V0p_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ! [V1q_2E0: mono_2Etyop_2Einteger_2Eint] : ( mono_2Ec_2Einteger_2Eint__rem_2E2(mono_2Ec_2Einteger_2Eint__mul_2E2(V1q_2E0,V0p_2E0),V0p_2E0) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) ) ).

tff(thm_2Einteger_2EINT__REM__EQ0,axiom,
    ! [V0q_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V0q_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ! [V1p_2E0: mono_2Etyop_2Einteger_2Eint] :
          ( ( mono_2Ec_2Einteger_2Eint__rem_2E2(V1p_2E0,V0q_2E0) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
        <=> ? [V2k_2E0: mono_2Etyop_2Einteger_2Eint] : ( V1p_2E0 = mono_2Ec_2Einteger_2Eint__mul_2E2(V2k_2E0,V0q_2E0) ) ) ) ).

tff(thm_2Einteger_2EINT__MUL__QUOT,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint,V1q_2E0: mono_2Etyop_2Einteger_2Eint,V2k_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( ( V1q_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
        & ( mono_2Ec_2Einteger_2Eint__rem_2E2(V0p_2E0,V1q_2E0) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) )
     => ( mono_2Ec_2Einteger_2Eint__quot_2E2(mono_2Ec_2Einteger_2Eint__mul_2E2(V2k_2E0,V0p_2E0),V1q_2E0) = mono_2Ec_2Einteger_2Eint__mul_2E2(V2k_2E0,mono_2Ec_2Einteger_2Eint__quot_2E2(V0p_2E0,V1q_2E0)) ) ) ).

tff(thm_2Einteger_2EINT__REM__EQ__MOD,axiom,
    ! [V0i_2E0: mono_2Etyop_2Einteger_2Eint,V1n_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__lt_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V1n_2E0))
     => ( mono_2Ec_2Einteger_2Eint__rem_2E2(V0i_2E0,V1n_2E0) = mono_2Ec_2Ebool_2ECOND_2E3_2Emono_2Etyop_2Einteger_2Eint(mono_2Ec_2Einteger_2Eint__lt_2E2(V0i_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0)),mono_2Ec_2Einteger_2Eint__add_2E2(mono_2Ec_2Einteger_2Eint__sub_2E2(mono_2Ec_2Einteger_2Eint__mod_2E2(mono_2Ec_2Einteger_2Eint__sub_2E2(V0i_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0)))),V1n_2E0),V1n_2E0),mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0)))),mono_2Ec_2Einteger_2Eint__mod_2E2(V0i_2E0,V1n_2E0)) ) ) ).

tff(thm_2Einteger_2EINT__DIVIDES__MOD0,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint,V1q_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__divides_2E2(V0p_2E0,V1q_2E0))
    <=> ( ( ( mono_2Ec_2Einteger_2Eint__mod_2E2(V1q_2E0,V0p_2E0) = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
          & ( V0p_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) )
        | ( ( V0p_2E0 = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
          & ( V1q_2E0 = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) ) ) ) ).

tff(thm_2Einteger_2EINT__DIVIDES__0,axiom,
    ( ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] : p(mono_2Ec_2Einteger_2Eint__divides_2E2(V0x_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0)))
    & ! [V1x_2E0: mono_2Etyop_2Einteger_2Eint] :
        ( p(mono_2Ec_2Einteger_2Eint__divides_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0),V1x_2E0))
      <=> ( V1x_2E0 = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) ) ) ) ).

tff(thm_2Einteger_2EINT__DIVIDES__1,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__divides_2E2(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0))),V0x_2E0))
      & ( p(mono_2Ec_2Einteger_2Eint__divides_2E2(V0x_2E0,mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0)))))
      <=> ( ( V0x_2E0 = mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0))) )
          | ( V0x_2E0 = mono_2Ec_2Einteger_2Eint__neg_2E1(mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Earithmetic_2ENUMERAL_2E1(mono_2Ec_2Earithmetic_2EBIT1_2E1(mono_2Ec_2Earithmetic_2EZERO_2E0)))) ) ) ) ) ).

tff(thm_2Einteger_2EINT__DIVIDES__REFL,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint] : p(mono_2Ec_2Einteger_2Eint__divides_2E2(V0x_2E0,V0x_2E0)) ).

tff(thm_2Einteger_2EINT__DIVIDES__TRANS,axiom,
    ! [V0x_2E0: mono_2Etyop_2Einteger_2Eint,V1y_2E0: mono_2Etyop_2Einteger_2Eint,V2z_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( p(mono_2Ec_2Einteger_2Eint__divides_2E2(V0x_2E0,V1y_2E0))
        & p(mono_2Ec_2Einteger_2Eint__divides_2E2(V1y_2E0,V2z_2E0)) )
     => p(mono_2Ec_2Einteger_2Eint__divides_2E2(V0x_2E0,V2z_2E0)) ) ).

tff(thm_2Einteger_2EINT__DIVIDES__MUL,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint,V1q_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__divides_2E2(V0p_2E0,mono_2Ec_2Einteger_2Eint__mul_2E2(V0p_2E0,V1q_2E0)))
      & p(mono_2Ec_2Einteger_2Eint__divides_2E2(V0p_2E0,mono_2Ec_2Einteger_2Eint__mul_2E2(V1q_2E0,V0p_2E0))) ) ).

tff(thm_2Einteger_2EINT__DIVIDES__LMUL,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint,V1q_2E0: mono_2Etyop_2Einteger_2Eint,V2r_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__divides_2E2(V0p_2E0,V1q_2E0))
     => p(mono_2Ec_2Einteger_2Eint__divides_2E2(V0p_2E0,mono_2Ec_2Einteger_2Eint__mul_2E2(V1q_2E0,V2r_2E0))) ) ).

tff(thm_2Einteger_2EINT__DIVIDES__RMUL,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint,V1q_2E0: mono_2Etyop_2Einteger_2Eint,V2r_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__divides_2E2(V0p_2E0,V1q_2E0))
     => p(mono_2Ec_2Einteger_2Eint__divides_2E2(V0p_2E0,mono_2Ec_2Einteger_2Eint__mul_2E2(V2r_2E0,V1q_2E0))) ) ).

tff(thm_2Einteger_2EINT__DIVIDES__MUL__BOTH,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint,V1q_2E0: mono_2Etyop_2Einteger_2Eint,V2r_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( V0p_2E0 != mono_2Ec_2Einteger_2Eint__of__num_2E1(mono_2Ec_2Enum_2E0_2E0) )
     => ( mono_2Ec_2Einteger_2Eint__divides_2E2(mono_2Ec_2Einteger_2Eint__mul_2E2(V0p_2E0,V1q_2E0),mono_2Ec_2Einteger_2Eint__mul_2E2(V0p_2E0,V2r_2E0)) = mono_2Ec_2Einteger_2Eint__divides_2E2(V1q_2E0,V2r_2E0) ) ) ).

tff(thm_2Einteger_2EINT__DIVIDES__LADD,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint,V1q_2E0: mono_2Etyop_2Einteger_2Eint,V2r_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__divides_2E2(V0p_2E0,V1q_2E0))
     => ( mono_2Ec_2Einteger_2Eint__divides_2E2(V0p_2E0,mono_2Ec_2Einteger_2Eint__add_2E2(V1q_2E0,V2r_2E0)) = mono_2Ec_2Einteger_2Eint__divides_2E2(V0p_2E0,V2r_2E0) ) ) ).

tff(thm_2Einteger_2EINT__DIVIDES__RADD,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint,V1q_2E0: mono_2Etyop_2Einteger_2Eint,V2r_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__divides_2E2(V0p_2E0,V1q_2E0))
     => ( mono_2Ec_2Einteger_2Eint__divides_2E2(V0p_2E0,mono_2Ec_2Einteger_2Eint__add_2E2(V2r_2E0,V1q_2E0)) = mono_2Ec_2Einteger_2Eint__divides_2E2(V0p_2E0,V2r_2E0) ) ) ).

tff(thm_2Einteger_2EINT__DIVIDES__NEG,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint,V1q_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( ( mono_2Ec_2Einteger_2Eint__divides_2E2(V0p_2E0,mono_2Ec_2Einteger_2Eint__neg_2E1(V1q_2E0)) = mono_2Ec_2Einteger_2Eint__divides_2E2(V0p_2E0,V1q_2E0) )
      & ( mono_2Ec_2Einteger_2Eint__divides_2E2(mono_2Ec_2Einteger_2Eint__neg_2E1(V0p_2E0),V1q_2E0) = mono_2Ec_2Einteger_2Eint__divides_2E2(V0p_2E0,V1q_2E0) ) ) ).

tff(thm_2Einteger_2EINT__DIVIDES__LSUB,axiom,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint,V1q_2E0: mono_2Etyop_2Einteger_2Eint,V2r_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__divides_2E2(V0p_2E0,V1q_2E0))
     => ( mono_2Ec_2Einteger_2Eint__divides_2E2(V0p_2E0,mono_2Ec_2Einteger_2Eint__sub_2E2(V1q_2E0,V2r_2E0)) = mono_2Ec_2Einteger_2Eint__divides_2E2(V0p_2E0,V2r_2E0) ) ) ).

tff(thm_2Einteger_2EINT__DIVIDES__RSUB,conjecture,
    ! [V0p_2E0: mono_2Etyop_2Einteger_2Eint,V1q_2E0: mono_2Etyop_2Einteger_2Eint,V2r_2E0: mono_2Etyop_2Einteger_2Eint] :
      ( p(mono_2Ec_2Einteger_2Eint__divides_2E2(V0p_2E0,V1q_2E0))
     => ( mono_2Ec_2Einteger_2Eint__divides_2E2(V0p_2E0,mono_2Ec_2Einteger_2Eint__sub_2E2(V2r_2E0,V1q_2E0)) = mono_2Ec_2Einteger_2Eint__divides_2E2(V0p_2E0,V2r_2E0) ) ) ).

%------------------------------------------------------------------------------
