%------------------------------------------------------------------------------
% File     : ITP010_5 : TPTP v9.2.0. Bugfixed v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : HOL4 set theory export of thm_2Ecardinal_2ECARD__NOT__LE.p, chainy mode
% Version  : [BG+19] axioms.
% English  :

% Refs     : [BG+19] Brown et al. (2019), GRUNGE: A Grand Unified ATP Chall
%          : [Gau20] Gauthier (2020), Email to Geoff Sutcliffe
% Source   : [BG+19]
% Names    : thm_2Ecardinal_2ECARD__NOT__LE.p [Gau20]
%          : HL404501_5.p [TPAP]

% Status   : Theorem
% Rating   : 0.12 v9.1.0, 0.20 v9.0.0, 0.22 v8.2.0, 0.20 v8.1.0, 0.27 v7.5.0
% Syntax   : Number of formulae    : 11903 (1908 unt;3085 typ;   0 def)
%            Number of atoms       : 231756 (10342 equ)
%            Maximal formula atoms : 5763 (  19 avg)
%            Number of connectives : 43294 ( 835   ~; 457   |;18912   &)
%                                         (3601 <=>;19489  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  361 (   7 avg)
%            Maximal term depth    :   28 (   2 avg)
%            Number of FOOLs       : 180479 (180479 fml;   0 var)
%            Number of types       :   37 (  35 usr)
%            Number of type conns  : 6596 (2760   >;3836   *;   0   +;   0  <<)
%            Number of predicates  :   71 (  68 usr;  22 prp; 0-3 aty)
%            Number of functors    : 3048 (3048 usr; 290 con; 0-11 aty)
%            Number of variables   : 44374 (31588   !;12786   ?;44374   :)
% SPC      : TF0_THM_EQU_NAR

% Comments :
% Bugfixes : v7.5.0 - Bugfixes in axioms and export.
%------------------------------------------------------------------------------
include('Axioms/ITP001/ITP001_2.ax').
include('Axioms/ITP001/ITP002_5.ax').
include('Axioms/ITP001/ITP003_5.ax').
include('Axioms/ITP001/ITP004_5.ax').
include('Axioms/ITP001/ITP007_5.ax').
include('Axioms/ITP001/ITP006_5.ax').
include('Axioms/ITP001/ITP005_5.ax').
include('Axioms/ITP001/ITP008_5.ax').
include('Axioms/ITP001/ITP009_5.ax').
include('Axioms/ITP001/ITP010_5.ax').
include('Axioms/ITP001/ITP012_5.ax').
include('Axioms/ITP001/ITP011_5.ax').
include('Axioms/ITP001/ITP013_5.ax').
include('Axioms/ITP001/ITP014_5.ax').
include('Axioms/ITP001/ITP015_5.ax').
include('Axioms/ITP001/ITP017_5.ax').
include('Axioms/ITP001/ITP016_5.ax').
include('Axioms/ITP001/ITP019_5.ax').
include('Axioms/ITP001/ITP018_5.ax').
include('Axioms/ITP001/ITP021_5.ax').
include('Axioms/ITP001/ITP022_5.ax').
include('Axioms/ITP001/ITP020_5.ax').
include('Axioms/ITP001/ITP024_5.ax').
include('Axioms/ITP001/ITP023_5.ax').
include('Axioms/ITP001/ITP025_5.ax').
include('Axioms/ITP001/ITP026_5.ax').
include('Axioms/ITP001/ITP027_5.ax').
include('Axioms/ITP001/ITP028_5.ax').
include('Axioms/ITP001/ITP031_5.ax').
include('Axioms/ITP001/ITP029_5.ax').
include('Axioms/ITP001/ITP033_5.ax').
include('Axioms/ITP001/ITP030_5.ax').
include('Axioms/ITP001/ITP032_5.ax').
include('Axioms/ITP001/ITP038_5.ax').
include('Axioms/ITP001/ITP035_5.ax').
include('Axioms/ITP001/ITP034_5.ax').
include('Axioms/ITP001/ITP036_5.ax').
include('Axioms/ITP001/ITP037_5.ax').
include('Axioms/ITP001/ITP039_5.ax').
include('Axioms/ITP001/ITP041_5.ax').
include('Axioms/ITP001/ITP042_5.ax').
include('Axioms/ITP001/ITP040_5.ax').
include('Axioms/ITP001/ITP044_5.ax').
include('Axioms/ITP001/ITP051_5.ax').
include('Axioms/ITP001/ITP045_5.ax').
include('Axioms/ITP001/ITP056_5.ax').
include('Axioms/ITP001/ITP046_5.ax').
include('Axioms/ITP001/ITP043_5.ax').
include('Axioms/ITP001/ITP052_5.ax').
include('Axioms/ITP001/ITP057_5.ax').
include('Axioms/ITP001/ITP048_5.ax').
include('Axioms/ITP001/ITP047_5.ax').
include('Axioms/ITP001/ITP055_5.ax').
include('Axioms/ITP001/ITP053_5.ax').
include('Axioms/ITP001/ITP054_5.ax').
include('Axioms/ITP001/ITP058_5.ax').
include('Axioms/ITP001/ITP049_5.ax').
include('Axioms/ITP001/ITP050_5.ax').
include('Axioms/ITP001/ITP061_5.ax').
include('Axioms/ITP001/ITP069_5.ax').
include('Axioms/ITP001/ITP062_5.ax').
include('Axioms/ITP001/ITP068_5.ax').
include('Axioms/ITP001/ITP078_5.ax').
include('Axioms/ITP001/ITP064_5.ax').
include('Axioms/ITP001/ITP060_5.ax').
include('Axioms/ITP001/ITP067_5.ax').
include('Axioms/ITP001/ITP075_5.ax').
include('Axioms/ITP001/ITP074_5.ax').
%------------------------------------------------------------------------------
tff(tp_c_2Ecardinal_2E_2B__c,type,
    c_2Ecardinal_2E_2B__c: ( del * del ) > $i ).

tff(mem_c_2Ecardinal_2E_2B__c,axiom,
    ! [A_27a: del,A_27b: del] : mem(c_2Ecardinal_2E_2B__c(A_27a,A_27b),arr(arr(A_27a,bool),arr(arr(A_27b,bool),arr(ty_2Esum_2Esum(A_27a,A_27b),bool)))) ).

tff(tp_c_2Ecardinal_2EHAS__SIZE,type,
    c_2Ecardinal_2EHAS__SIZE: del > $i ).

tff(mem_c_2Ecardinal_2EHAS__SIZE,axiom,
    ! [A_27a: del] : mem(c_2Ecardinal_2EHAS__SIZE(A_27a),arr(arr(A_27a,bool),arr(ty_2Enum_2Enum,bool))) ).

tff(tp_c_2Ecardinal_2Ebijns,type,
    c_2Ecardinal_2Ebijns: del > $i ).

tff(mem_c_2Ecardinal_2Ebijns,axiom,
    ! [A_27a: del] : mem(c_2Ecardinal_2Ebijns(A_27a),arr(arr(A_27a,bool),arr(arr(A_27a,ty_2Eoption_2Eoption(A_27a)),bool))) ).

tff(tp_c_2Ecardinal_2Ecardeq,type,
    c_2Ecardinal_2Ecardeq: ( del * del ) > $i ).

tff(mem_c_2Ecardinal_2Ecardeq,axiom,
    ! [A_27a: del,A_27b: del] : mem(c_2Ecardinal_2Ecardeq(A_27a,A_27b),arr(arr(A_27a,bool),arr(arr(A_27b,bool),bool))) ).

tff(tp_c_2Ecardinal_2Ecardgeq,type,
    c_2Ecardinal_2Ecardgeq: ( del * del ) > $i ).

tff(mem_c_2Ecardinal_2Ecardgeq,axiom,
    ! [A_27a: del,A_27b: del] : mem(c_2Ecardinal_2Ecardgeq(A_27a,A_27b),arr(arr(A_27a,bool),arr(arr(A_27b,bool),bool))) ).

tff(tp_c_2Ecardinal_2Ecardgt,type,
    c_2Ecardinal_2Ecardgt: ( del * del ) > $i ).

tff(mem_c_2Ecardinal_2Ecardgt,axiom,
    ! [A_27a: del,A_27b: del] : mem(c_2Ecardinal_2Ecardgt(A_27a,A_27b),arr(arr(A_27a,bool),arr(arr(A_27b,bool),bool))) ).

tff(tp_c_2Ecardinal_2Ecardleq,type,
    c_2Ecardinal_2Ecardleq: ( del * del ) > $i ).

tff(mem_c_2Ecardinal_2Ecardleq,axiom,
    ! [A_27a: del,A_27b: del] : mem(c_2Ecardinal_2Ecardleq(A_27a,A_27b),arr(arr(A_27a,bool),arr(arr(A_27b,bool),bool))) ).

tff(tp_c_2Ecardinal_2Elist,type,
    c_2Ecardinal_2Elist: del > $i ).

tff(mem_c_2Ecardinal_2Elist,axiom,
    ! [A_27a: del] : mem(c_2Ecardinal_2Elist(A_27a),arr(arr(A_27a,bool),arr(ty_2Elist_2Elist(A_27a),bool))) ).

tff(tp_c_2Ecardinal_2Eset__exp,type,
    c_2Ecardinal_2Eset__exp: ( del * del ) > $i ).

tff(mem_c_2Ecardinal_2Eset__exp,axiom,
    ! [A_27a: del,A_27b: del] : mem(c_2Ecardinal_2Eset__exp(A_27a,A_27b),arr(arr(A_27b,bool),arr(arr(A_27a,bool),arr(arr(A_27a,ty_2Eoption_2Eoption(A_27b)),bool)))) ).

tff(ax_thm_2Ecardinal_2Ecardeq__def,axiom,
    ! [A_27a: del,A_27b: del,V0s1: $i] :
      ( mem(V0s1,arr(A_27a,bool))
     => ! [V1s2: $i] :
          ( mem(V1s2,arr(A_27b,bool))
         => ( p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a,A_27b),V0s1),V1s2))
          <=> ? [V2f: $i] :
                ( mem(V2f,arr(A_27a,A_27b))
                & p(ap(ap(ap(c_2Epred__set_2EBIJ(A_27a,A_27b),V2f),V0s1),V1s2)) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2Ecardeq__REFL,axiom,
    ! [A_27a: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a,A_27a),V0s),V0s)) ) ).

tff(conj_thm_2Ecardinal_2Ecardeq__SYM,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ( p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a,A_27b),V0s),V1t))
          <=> p(ap(ap(c_2Ecardinal_2Ecardeq(A_27b,A_27a),V1t),V0s)) ) ) ) ).

tff(conj_thm_2Ecardinal_2Ecardeq__TRANS,axiom,
    ! [A_27a: del,A_27b: del,A_27c: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ! [V2u: $i] :
              ( mem(V2u,arr(A_27c,bool))
             => ( ( p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a,A_27b),V0s),V1t))
                  & p(ap(ap(c_2Ecardinal_2Ecardeq(A_27b,A_27c),V1t),V2u)) )
               => p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a,A_27c),V0s),V2u)) ) ) ) ) ).

tff(ax_thm_2Ecardinal_2Ecardleq__def,axiom,
    ! [A_27a: del,A_27b: del,V0s1: $i] :
      ( mem(V0s1,arr(A_27a,bool))
     => ! [V1s2: $i] :
          ( mem(V1s2,arr(A_27b,bool))
         => ( p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0s1),V1s2))
          <=> ? [V2f: $i] :
                ( mem(V2f,arr(A_27a,A_27b))
                & p(ap(ap(ap(c_2Epred__set_2EINJ(A_27a,A_27b),V2f),V0s1),V1s2)) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2Ecardleq__REFL,axiom,
    ! [A_27a: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27a),V0s),V0s)) ) ).

tff(conj_thm_2Ecardinal_2Ecardleq__TRANS,axiom,
    ! [A_27a: del,A_27b: del,A_27c: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ! [V2u: $i] :
              ( mem(V2u,arr(A_27c,bool))
             => ( ( p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0s),V1t))
                  & p(ap(ap(c_2Ecardinal_2Ecardleq(A_27b,A_27c),V1t),V2u)) )
               => p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27c),V0s),V2u)) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2Ecardleq__ANTISYM,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ( ( p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0s),V1t))
              & p(ap(ap(c_2Ecardinal_2Ecardleq(A_27b,A_27a),V1t),V0s)) )
           => p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a,A_27b),V0s),V1t)) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARDEQ__FINITE,axiom,
    ! [A_27a: del,A_27b: del,V0s1: $i] :
      ( mem(V0s1,arr(A_27a,bool))
     => ! [V1s2: $i] :
          ( mem(V1s2,arr(A_27b,bool))
         => ( p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a,A_27b),V0s1),V1s2))
           => ( p(ap(c_2Epred__set_2EFINITE(A_27a),V0s1))
            <=> p(ap(c_2Epred__set_2EFINITE(A_27b),V1s2)) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARDEQ__CARD,axiom,
    ! [A_27a: del,A_27b: del,V0s1: $i] :
      ( mem(V0s1,arr(A_27a,bool))
     => ! [V1s2: $i] :
          ( mem(V1s2,arr(A_27b,bool))
         => ( ( p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a,A_27b),V0s1),V1s2))
              & p(ap(c_2Epred__set_2EFINITE(A_27a),V0s1)) )
           => ( surj__ty_2Enum_2Enum(ap(c_2Epred__set_2ECARD(A_27a),V0s1)) = surj__ty_2Enum_2Enum(ap(c_2Epred__set_2ECARD(A_27b),V1s2)) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARDEQ__0,axiom,
    ! [A_27a: del,A_27b: del,A_27c: del,V0x: $i] :
      ( mem(V0x,arr(A_27a,bool))
     => ( ( p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a,A_27b),V0x),c_2Epred__set_2EEMPTY(A_27b)))
        <=> ( V0x = c_2Epred__set_2EEMPTY(A_27a) ) )
        & ( p(ap(ap(c_2Ecardinal_2Ecardeq(A_27c,A_27a),c_2Epred__set_2EEMPTY(A_27c)),V0x))
        <=> ( V0x = c_2Epred__set_2EEMPTY(A_27a) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2Ecardeq__INSERT,axiom,
    ! [A_27a: del,V0x: $i] :
      ( mem(V0x,A_27a)
     => ! [V1s: $i] :
          ( mem(V1s,arr(A_27a,bool))
         => ( p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a,A_27a),ap(ap(c_2Epred__set_2EINSERT(A_27a),V0x),V1s)),V1s))
          <=> ( p(ap(ap(c_2Ebool_2EIN(A_27a),V0x),V1s))
              | ~ p(ap(c_2Epred__set_2EFINITE(A_27a),V1s)) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARDEQ__INSERT__RWT,axiom,
    ! [A_27a: del,V0x: $i] :
      ( mem(V0x,A_27a)
     => ! [V1s: $i] :
          ( mem(V1s,arr(A_27a,bool))
         => ( ~ p(ap(c_2Epred__set_2EFINITE(A_27a),V1s))
           => p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a,A_27a),ap(ap(c_2Epred__set_2EINSERT(A_27a),V0x),V1s)),V1s)) ) ) ) ).

tff(conj_thm_2Ecardinal_2EEMPTY__CARDLEQ,axiom,
    ! [A_27a: del,A_27b: del,V0t: $i] :
      ( mem(V0t,arr(A_27b,bool))
     => p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),c_2Epred__set_2EEMPTY(A_27a)),V0t)) ) ).

tff(conj_thm_2Ecardinal_2EFINITE__CLE__INFINITE,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ( ( p(ap(c_2Epred__set_2EFINITE(A_27a),V0s))
              & ~ p(ap(c_2Epred__set_2EFINITE(A_27b),V1t)) )
           => p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0s),V1t)) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARDEQ__CROSS,axiom,
    ! [A_27a: del,A_27b: del,A_27c: del,A_27d: del,V0s1: $i] :
      ( mem(V0s1,arr(A_27a,bool))
     => ! [V1s2: $i] :
          ( mem(V1s2,arr(A_27b,bool))
         => ! [V2t1: $i] :
              ( mem(V2t1,arr(A_27c,bool))
             => ! [V3t2: $i] :
                  ( mem(V3t2,arr(A_27d,bool))
                 => ( ( p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a,A_27b),V0s1),V1s2))
                      & p(ap(ap(c_2Ecardinal_2Ecardeq(A_27c,A_27d),V2t1),V3t2)) )
                   => p(ap(ap(c_2Ecardinal_2Ecardeq(ty_2Epair_2Eprod(A_27a,A_27c),ty_2Epair_2Eprod(A_27b,A_27d)),ap(ap(c_2Epred__set_2ECROSS(A_27a,A_27c),V0s1),V2t1)),ap(ap(c_2Epred__set_2ECROSS(A_27b,A_27d),V1s2),V3t2))) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARDEQ__CROSS__SYM,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => p(ap(ap(c_2Ecardinal_2Ecardeq(ty_2Epair_2Eprod(A_27a,A_27b),ty_2Epair_2Eprod(A_27b,A_27a)),ap(ap(c_2Epred__set_2ECROSS(A_27a,A_27b),V0s),V1t)),ap(ap(c_2Epred__set_2ECROSS(A_27b,A_27a),V1t),V0s))) ) ) ).

tff(conj_thm_2Ecardinal_2ECARDEQ__SUBSET__CARDLEQ,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ( p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a,A_27b),V0s),V1t))
           => p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0s),V1t)) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARDEQ__CARDLEQ,axiom,
    ! [A_27a: del,A_27b: del,A_27c: del,A_27d: del,V0s1: $i] :
      ( mem(V0s1,arr(A_27a,bool))
     => ! [V1s2: $i] :
          ( mem(V1s2,arr(A_27b,bool))
         => ! [V2t1: $i] :
              ( mem(V2t1,arr(A_27c,bool))
             => ! [V3t2: $i] :
                  ( mem(V3t2,arr(A_27d,bool))
                 => ( ( p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a,A_27b),V0s1),V1s2))
                      & p(ap(ap(c_2Ecardinal_2Ecardeq(A_27c,A_27d),V2t1),V3t2)) )
                   => ( p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27c),V0s1),V2t1))
                    <=> p(ap(ap(c_2Ecardinal_2Ecardleq(A_27b,A_27d),V1s2),V3t2)) ) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARDLEQ__FINITE,axiom,
    ! [A_27a: del,A_27b: del,V0s1: $i] :
      ( mem(V0s1,arr(A_27a,bool))
     => ! [V1s2: $i] :
          ( mem(V1s2,arr(A_27b,bool))
         => ( ( p(ap(c_2Epred__set_2EFINITE(A_27b),V1s2))
              & p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0s1),V1s2)) )
           => p(ap(c_2Epred__set_2EFINITE(A_27a),V0s1)) ) ) ) ).

tff(conj_thm_2Ecardinal_2EINFINITE__UNIV__INF,axiom,
    ! [A_27a: del] : ~ p(ap(c_2Epred__set_2EFINITE(ty_2Esum_2Esum(ty_2Enum_2Enum,A_27a)),c_2Epred__set_2EUNIV(ty_2Esum_2Esum(ty_2Enum_2Enum,A_27a)))) ).

tff(conj_thm_2Ecardinal_2EIMAGE__cardleq,axiom,
    ! [A_27a: del,A_27b: del,V0f: $i] :
      ( mem(V0f,arr(A_27a,A_27b))
     => ! [V1s: $i] :
          ( mem(V1s,arr(A_27a,bool))
         => p(ap(ap(c_2Ecardinal_2Ecardleq(A_27b,A_27a),ap(ap(c_2Epred__set_2EIMAGE(A_27a,A_27b),V0f),V1s)),V1s)) ) ) ).

tff(conj_thm_2Ecardinal_2ECARDLEQ__CROSS__CONG,axiom,
    ! [A_27a: del,A_27b: del,A_27c: del,A_27d: del,V0x1: $i] :
      ( mem(V0x1,arr(A_27a,bool))
     => ! [V1x2: $i] :
          ( mem(V1x2,arr(A_27b,bool))
         => ! [V2y1: $i] :
              ( mem(V2y1,arr(A_27c,bool))
             => ! [V3y2: $i] :
                  ( mem(V3y2,arr(A_27d,bool))
                 => ( ( p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0x1),V1x2))
                      & p(ap(ap(c_2Ecardinal_2Ecardleq(A_27c,A_27d),V2y1),V3y2)) )
                   => p(ap(ap(c_2Ecardinal_2Ecardleq(ty_2Epair_2Eprod(A_27a,A_27c),ty_2Epair_2Eprod(A_27b,A_27d)),ap(ap(c_2Epred__set_2ECROSS(A_27a,A_27c),V0x1),V2y1)),ap(ap(c_2Epred__set_2ECROSS(A_27b,A_27d),V1x2),V3y2))) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ESUBSET__CARDLEQ,axiom,
    ! [A_27a: del,V0x: $i] :
      ( mem(V0x,arr(A_27a,bool))
     => ! [V1y: $i] :
          ( mem(V1y,arr(A_27a,bool))
         => ( p(ap(ap(c_2Epred__set_2ESUBSET(A_27a),V0x),V1y))
           => p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27a),V0x),V1y)) ) ) ) ).

tff(conj_thm_2Ecardinal_2EIMAGE__cardleq__rwt,axiom,
    ! [A_27a: del,A_27b: del,A_27c: del,V0f: $i] :
      ( mem(V0f,arr(A_27a,A_27c))
     => ! [V1s: $i] :
          ( mem(V1s,arr(A_27a,bool))
         => ! [V2t: $i] :
              ( mem(V2t,arr(A_27b,bool))
             => ( p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V1s),V2t))
               => p(ap(ap(c_2Ecardinal_2Ecardleq(A_27c,A_27b),ap(ap(c_2Epred__set_2EIMAGE(A_27a,A_27c),V0f),V1s)),V2t)) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2Ecountable__thm,axiom,
    ! [A_27a: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ( p(ap(c_2Epred__set_2Ecountable(A_27a),V0s))
      <=> p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,ty_2Enum_2Enum),V0s),c_2Epred__set_2EUNIV(ty_2Enum_2Enum))) ) ) ).

tff(conj_thm_2Ecardinal_2Ecountable__cardeq,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ( p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a,A_27b),V0s),V1t))
           => ( p(ap(c_2Epred__set_2Ecountable(A_27a),V0s))
            <=> p(ap(c_2Epred__set_2Ecountable(A_27b),V1t)) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2Ecardleq__dichotomy,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ( p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0s),V1t))
            | p(ap(ap(c_2Ecardinal_2Ecardleq(A_27b,A_27a),V1t),V0s)) ) ) ) ).

tff(conj_thm_2Ecardinal_2Ecardleq__lteq,axiom,
    ! [A_27a: del,A_27b: del,V0s1: $i] :
      ( mem(V0s1,arr(A_27a,bool))
     => ! [V1s2: $i] :
          ( mem(V1s2,arr(A_27b,bool))
         => ( p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0s1),V1s2))
          <=> ( ~ p(ap(ap(c_2Ecardinal_2Ecardleq(A_27b,A_27a),V1s2),V0s1))
              | p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a,A_27b),V0s1),V1s2)) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2Ecardlt__REFL,axiom,
    ! [A_27a: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ~ ~ p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27a),V0s),V0s)) ) ).

tff(conj_thm_2Ecardinal_2Ecardlt__lenoteq,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ( ~ p(ap(ap(c_2Ecardinal_2Ecardleq(A_27b,A_27a),V1t),V0s))
          <=> ( p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0s),V1t))
              & ~ p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a,A_27b),V0s),V1t)) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2Ecardlt__TRANS,axiom,
    ! [A_27a: del,A_27b: del,A_27c: del,V0s: $i] :
      ( mem(V0s,arr(A_27b,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27c,bool))
         => ! [V2u: $i] :
              ( mem(V2u,arr(A_27a,bool))
             => ( ( ~ p(ap(ap(c_2Ecardinal_2Ecardleq(A_27c,A_27b),V1t),V0s))
                  & ~ p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27c),V2u),V1t)) )
               => ~ p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V2u),V0s)) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2Ecardlt__leq__trans,axiom,
    ! [A_27a: del,A_27b: del,A_27c: del,V0r: $i] :
      ( mem(V0r,arr(A_27a,bool))
     => ! [V1s: $i] :
          ( mem(V1s,arr(A_27b,bool))
         => ! [V2t: $i] :
              ( mem(V2t,arr(A_27c,bool))
             => ( ( ~ p(ap(ap(c_2Ecardinal_2Ecardleq(A_27b,A_27a),V1s),V0r))
                  & p(ap(ap(c_2Ecardinal_2Ecardleq(A_27b,A_27c),V1s),V2t)) )
               => ~ p(ap(ap(c_2Ecardinal_2Ecardleq(A_27c,A_27a),V2t),V0r)) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2Ecardleq__lt__trans,axiom,
    ! [A_27a: del,A_27b: del,A_27c: del,V0r: $i] :
      ( mem(V0r,arr(A_27a,bool))
     => ! [V1s: $i] :
          ( mem(V1s,arr(A_27b,bool))
         => ! [V2t: $i] :
              ( mem(V2t,arr(A_27c,bool))
             => ( ( p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0r),V1s))
                  & ~ p(ap(ap(c_2Ecardinal_2Ecardleq(A_27c,A_27b),V2t),V1s)) )
               => ~ p(ap(ap(c_2Ecardinal_2Ecardleq(A_27c,A_27a),V2t),V0r)) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2Ecardleq__empty,axiom,
    ! [A_27a: del,A_27b: del,V0x: $i] :
      ( mem(V0x,arr(A_27a,bool))
     => ( p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0x),c_2Epred__set_2EEMPTY(A_27b)))
      <=> ( V0x = c_2Epred__set_2EEMPTY(A_27a) ) ) ) ).

tff(conj_thm_2Ecardinal_2Eset__binomial2,axiom,
    ! [A_27a: del,V0A: $i] :
      ( mem(V0A,arr(A_27a,bool))
     => ! [V1B: $i] :
          ( mem(V1B,arr(A_27a,bool))
         => ( ap(ap(c_2Epred__set_2ECROSS(A_27a,A_27a),ap(ap(c_2Epred__set_2EUNION(A_27a),V0A),V1B)),ap(ap(c_2Epred__set_2EUNION(A_27a),V0A),V1B)) = ap(ap(c_2Epred__set_2EUNION(ty_2Epair_2Eprod(A_27a,A_27a)),ap(ap(c_2Epred__set_2EUNION(ty_2Epair_2Eprod(A_27a,A_27a)),ap(ap(c_2Epred__set_2EUNION(ty_2Epair_2Eprod(A_27a,A_27a)),ap(ap(c_2Epred__set_2ECROSS(A_27a,A_27a),V0A),V0A)),ap(ap(c_2Epred__set_2ECROSS(A_27a,A_27a),V0A),V1B))),ap(ap(c_2Epred__set_2ECROSS(A_27a,A_27a),V1B),V0A))),ap(ap(c_2Epred__set_2ECROSS(A_27a,A_27a),V1B),V1B)) ) ) ) ).

tff(conj_thm_2Ecardinal_2ESET__SQUARED__CARDEQ__SET,axiom,
    ! [A_27a: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ( ~ p(ap(c_2Epred__set_2EFINITE(A_27a),V0s))
       => p(ap(ap(c_2Ecardinal_2Ecardeq(ty_2Epair_2Eprod(A_27a,A_27a),A_27a),ap(ap(c_2Epred__set_2ECROSS(A_27a,A_27a),V0s),V0s)),V0s)) ) ) ).

tff(conj_thm_2Ecardinal_2ESET__SUM__CARDEQ__SET,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ( ~ p(ap(c_2Epred__set_2EFINITE(A_27a),V0s))
       => ( p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a,ty_2Epair_2Eprod(bool,A_27a)),V0s),ap(ap(c_2Epred__set_2ECROSS(bool,A_27a),ap(ap(c_2Epred__set_2EINSERT(bool),inj__o(fo__c_2Ebool_2ET)),ap(ap(c_2Epred__set_2EINSERT(bool),inj__o(fo__c_2Ebool_2EF)),c_2Epred__set_2EEMPTY(bool)))),V0s)))
          & ! [V1A: $i] :
              ( mem(V1A,arr(A_27b,bool))
             => ! [V2B: $i] :
                  ( mem(V2B,arr(A_27b,bool))
                 => ( ( p(ap(ap(c_2Epred__set_2EDISJOINT(A_27b),V1A),V2B))
                      & p(ap(ap(c_2Ecardinal_2Ecardeq(A_27b,A_27a),V1A),V0s))
                      & p(ap(ap(c_2Ecardinal_2Ecardeq(A_27b,A_27a),V2B),V0s)) )
                   => p(ap(ap(c_2Ecardinal_2Ecardeq(A_27b,A_27a),ap(ap(c_2Epred__set_2EUNION(A_27b),V1A),V2B)),V0s)) ) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARD__BIGUNION,axiom,
    ! [A_27a: del,A_27b: del,V0k: $i] :
      ( mem(V0k,arr(A_27a,bool))
     => ! [V1s1: $i] :
          ( mem(V1s1,arr(arr(A_27b,bool),bool))
         => ( ( ~ p(ap(c_2Epred__set_2EFINITE(A_27a),V0k))
              & p(ap(ap(c_2Ecardinal_2Ecardleq(arr(A_27b,bool),A_27a),V1s1),V0k))
              & ! [V2e: $i] :
                  ( mem(V2e,arr(A_27b,bool))
                 => ( p(ap(ap(c_2Ebool_2EIN(arr(A_27b,bool)),V2e),V1s1))
                   => p(ap(ap(c_2Ecardinal_2Ecardleq(A_27b,A_27a),V2e),V0k)) ) ) )
           => p(ap(ap(c_2Ecardinal_2Ecardleq(A_27b,A_27a),ap(c_2Epred__set_2EBIGUNION(A_27b),V1s1)),V0k)) ) ) ) ).

tff(lamtp_f1848,type,
    f1848: ( del * del * $i * $i * $i ) > $i ).

tff(lameq_f1848,axiom,
    ! [A_27a: del,A_27b: del,V3b: $i] :
      ( mem(V3b,A_27a)
     => ! [V2f: $i] :
          ( mem(V2f,arr(A_27a,ty_2Eoption_2Eoption(A_27b)))
         => ! [V0A: $i] :
              ( mem(V0A,arr(A_27b,bool))
             => ! [V4a: $i] : ( ap(f1848(A_27a,A_27b,V3b,V2f,V0A),V4a) = ap(ap(c_2Ebool_2E_2F_5C,ap(ap(c_2Ebool_2EIN(A_27b),V4a),V0A)),ap(ap(c_2Emin_2E_3D(ty_2Eoption_2Eoption(A_27b)),ap(V2f,V3b)),ap(c_2Eoption_2ESOME(A_27b),V4a))) ) ) ) ) ).

tff(lamtp_f1849,type,
    f1849: ( del * del * $i * $i * $i ) > $i ).

tff(lameq_f1849,axiom,
    ! [A_27b: del,A_27a: del,V2f: $i] :
      ( mem(V2f,arr(A_27a,ty_2Eoption_2Eoption(A_27b)))
     => ! [V0A: $i] :
          ( mem(V0A,arr(A_27b,bool))
         => ! [V1B: $i] :
              ( mem(V1B,arr(A_27a,bool))
             => ! [V3b: $i] : ( ap(f1849(A_27b,A_27a,V2f,V0A,V1B),V3b) = ap(ap(c_2Emin_2E_3D_3D_3E,ap(ap(c_2Ebool_2EIN(A_27a),V3b),V1B)),ap(c_2Ebool_2E_3F(A_27b),f1848(A_27a,A_27b,V3b,V2f,V0A))) ) ) ) ) ).

tff(lamtp_f1850,type,
    f1850: ( del * del * $i * $i ) > $i ).

tff(lameq_f1850,axiom,
    ! [A_27b: del,A_27a: del,V1B: $i] :
      ( mem(V1B,arr(A_27a,bool))
     => ! [V2f: $i] :
          ( mem(V2f,arr(A_27a,ty_2Eoption_2Eoption(A_27b)))
         => ! [V5b: $i] : ( ap(f1850(A_27b,A_27a,V1B,V2f),V5b) = ap(ap(c_2Emin_2E_3D_3D_3E,ap(c_2Ebool_2E_7E,ap(ap(c_2Ebool_2EIN(A_27a),V5b),V1B))),ap(ap(c_2Emin_2E_3D(ty_2Eoption_2Eoption(A_27b)),ap(V2f,V5b)),c_2Eoption_2ENONE(A_27b))) ) ) ) ).

tff(lamtp_f1851,type,
    f1851: ( del * del * $i * $i ) > $i ).

tff(lameq_f1851,axiom,
    ! [A_27b: del,A_27a: del,V1B: $i] :
      ( mem(V1B,arr(A_27a,bool))
     => ! [V0A: $i] :
          ( mem(V0A,arr(A_27b,bool))
         => ! [V2f: $i] : ( ap(f1851(A_27b,A_27a,V1B,V0A),V2f) = ap(ap(c_2Epair_2E_2C(arr(A_27a,ty_2Eoption_2Eoption(A_27b)),bool),V2f),ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Ebool_2E_21(A_27a),f1849(A_27b,A_27a,V2f,V0A,V1B))),ap(c_2Ebool_2E_21(A_27a),f1850(A_27b,A_27a,V1B,V2f)))) ) ) ) ).

tff(ax_thm_2Ecardinal_2Eset__exp__def,axiom,
    ! [A_27a: del,A_27b: del,V0A: $i] :
      ( mem(V0A,arr(A_27b,bool))
     => ! [V1B: $i] :
          ( mem(V1B,arr(A_27a,bool))
         => ( ap(ap(c_2Ecardinal_2Eset__exp(A_27a,A_27b),V0A),V1B) = ap(c_2Epred__set_2EGSPEC(arr(A_27a,ty_2Eoption_2Eoption(A_27b)),arr(A_27a,ty_2Eoption_2Eoption(A_27b))),f1851(A_27b,A_27a,V1B,V0A)) ) ) ) ).

tff(conj_thm_2Ecardinal_2EBIJ__functions__agree,axiom,
    ! [A_27a: del,A_27b: del,V0f: $i] :
      ( mem(V0f,arr(A_27a,A_27b))
     => ! [V1g: $i] :
          ( mem(V1g,arr(A_27a,A_27b))
         => ! [V2s: $i] :
              ( mem(V2s,arr(A_27a,bool))
             => ! [V3t: $i] :
                  ( mem(V3t,arr(A_27b,bool))
                 => ( ( p(ap(ap(ap(c_2Epred__set_2EBIJ(A_27a,A_27b),V0f),V2s),V3t))
                      & ! [V4x: $i] :
                          ( mem(V4x,A_27a)
                         => ( p(ap(ap(c_2Ebool_2EIN(A_27a),V4x),V2s))
                           => ( ap(V0f,V4x) = ap(V1g,V4x) ) ) ) )
                   => p(ap(ap(ap(c_2Epred__set_2EBIJ(A_27a,A_27b),V1g),V2s),V3t)) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARD__CARDEQ__I,axiom,
    ! [A_27a: del,A_27b: del,V0s1: $i] :
      ( mem(V0s1,arr(A_27a,bool))
     => ! [V1s2: $i] :
          ( mem(V1s2,arr(A_27b,bool))
         => ( ( p(ap(c_2Epred__set_2EFINITE(A_27a),V0s1))
              & p(ap(c_2Epred__set_2EFINITE(A_27b),V1s2))
              & ( surj__ty_2Enum_2Enum(ap(c_2Epred__set_2ECARD(A_27a),V0s1)) = surj__ty_2Enum_2Enum(ap(c_2Epred__set_2ECARD(A_27b),V1s2)) ) )
           => p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a,A_27b),V0s1),V1s2)) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARDEQ__CARD__EQN,axiom,
    ! [A_27a: del,A_27b: del,V0s1: $i] :
      ( mem(V0s1,arr(A_27a,bool))
     => ! [V1s2: $i] :
          ( mem(V1s2,arr(A_27b,bool))
         => ( ( p(ap(c_2Epred__set_2EFINITE(A_27a),V0s1))
              & p(ap(c_2Epred__set_2EFINITE(A_27b),V1s2)) )
           => ( p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a,A_27b),V0s1),V1s2))
            <=> ( surj__ty_2Enum_2Enum(ap(c_2Epred__set_2ECARD(A_27a),V0s1)) = surj__ty_2Enum_2Enum(ap(c_2Epred__set_2ECARD(A_27b),V1s2)) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARDLEQ__CARD,axiom,
    ! [A_27a: del,A_27b: del,V0s1: $i] :
      ( mem(V0s1,arr(A_27a,bool))
     => ! [V1s2: $i] :
          ( mem(V1s2,arr(A_27b,bool))
         => ( ( p(ap(c_2Epred__set_2EFINITE(A_27a),V0s1))
              & p(ap(c_2Epred__set_2EFINITE(A_27b),V1s2)) )
           => ( p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0s1),V1s2))
            <=> p(ap(ap(c_2Earithmetic_2E_3C_3D,ap(c_2Epred__set_2ECARD(A_27a),V0s1)),ap(c_2Epred__set_2ECARD(A_27b),V1s2))) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2EEMPTY__set__exp,axiom,
    ! [A_27a: del,A_27b: del,A_27c: del,A_27d: del,V0A: $i] :
      ( mem(V0A,arr(A_27b,bool))
     => ! [V1B: $i] :
          ( mem(V1B,arr(A_27c,bool))
         => ( ( ap(ap(c_2Ecardinal_2Eset__exp(A_27a,A_27b),V0A),c_2Epred__set_2EEMPTY(A_27a)) = ap(ap(c_2Epred__set_2EINSERT(arr(A_27a,ty_2Eoption_2Eoption(A_27b))),ap(c_2Ecombin_2EK(ty_2Eoption_2Eoption(A_27b),A_27a),c_2Eoption_2ENONE(A_27b))),c_2Epred__set_2EEMPTY(arr(A_27a,ty_2Eoption_2Eoption(A_27b)))) )
            & ( ( V1B != c_2Epred__set_2EEMPTY(A_27c) )
             => ( ap(ap(c_2Ecardinal_2Eset__exp(A_27c,A_27d),c_2Epred__set_2EEMPTY(A_27d)),V1B) = c_2Epred__set_2EEMPTY(arr(A_27c,ty_2Eoption_2Eoption(A_27d))) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2EEMPTY__set__exp__CARD,axiom,
    ! [A_27a: del,A_27b: del,V0A: $i] :
      ( mem(V0A,arr(A_27b,bool))
     => p(ap(ap(c_2Ecardinal_2Ecardeq(arr(A_27a,ty_2Eoption_2Eoption(A_27b)),ty_2Enum_2Enum),ap(ap(c_2Ecardinal_2Eset__exp(A_27a,A_27b),V0A),c_2Epred__set_2EEMPTY(A_27a))),ap(c_2Epred__set_2Ecount,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))))) ) ).

tff(lamtp_f1852,type,
    f1852: ( del * del * $i * $i ) > $i ).

tff(lameq_f1852,axiom,
    ! [A_27b: del,A_27a: del,V0x: $i] :
      ( mem(V0x,A_27b)
     => ! [V1B: $i] :
          ( mem(V1B,arr(A_27a,bool))
         => ! [V3b: $i] : ( ap(f1852(A_27b,A_27a,V0x,V1B),V3b) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Eoption_2Eoption(A_27b)),ap(ap(c_2Ebool_2EIN(A_27a),V3b),V1B)),ap(c_2Eoption_2ESOME(A_27b),V0x)),c_2Eoption_2ENONE(A_27b)) ) ) ) ).

tff(lamtp_f1853,type,
    f1853: ( del * del * $i * $i ) > $i ).

tff(lameq_f1853,axiom,
    ! [A_27c: del,A_27b: del,V4a: $i] :
      ( mem(V4a,A_27c)
     => ! [V0x: $i] :
          ( mem(V0x,A_27b)
         => ! [V5b: $i] : ( ap(f1853(A_27c,A_27b,V4a,V0x),V5b) = ap(ap(ap(c_2Ebool_2ECOND(ty_2Eoption_2Eoption(A_27c)),ap(ap(c_2Emin_2E_3D(A_27b),V5b),V0x)),ap(c_2Eoption_2ESOME(A_27c),V4a)),c_2Eoption_2ENONE(A_27c)) ) ) ) ).

tff(lamtp_f1854,type,
    f1854: ( del * del * $i * $i ) > $i ).

tff(lameq_f1854,axiom,
    ! [A_27b: del,A_27c: del,V0x: $i] :
      ( mem(V0x,A_27b)
     => ! [V2A: $i] :
          ( mem(V2A,arr(A_27c,bool))
         => ! [V4a: $i] : ( ap(f1854(A_27b,A_27c,V0x,V2A),V4a) = ap(ap(c_2Epair_2E_2C(arr(A_27b,ty_2Eoption_2Eoption(A_27c)),bool),f1853(A_27c,A_27b,V4a,V0x)),ap(ap(c_2Ebool_2EIN(A_27c),V4a),V2A)) ) ) ) ).

tff(conj_thm_2Ecardinal_2ESING__set__exp,axiom,
    ! [A_27a: del,A_27b: del,A_27c: del,V0x: $i] :
      ( mem(V0x,A_27b)
     => ! [V1B: $i] :
          ( mem(V1B,arr(A_27a,bool))
         => ! [V2A: $i] :
              ( mem(V2A,arr(A_27c,bool))
             => ( ( ap(ap(c_2Ecardinal_2Eset__exp(A_27a,A_27b),ap(ap(c_2Epred__set_2EINSERT(A_27b),V0x),c_2Epred__set_2EEMPTY(A_27b))),V1B) = ap(ap(c_2Epred__set_2EINSERT(arr(A_27a,ty_2Eoption_2Eoption(A_27b))),f1852(A_27b,A_27a,V0x,V1B)),c_2Epred__set_2EEMPTY(arr(A_27a,ty_2Eoption_2Eoption(A_27b)))) )
                & ( ap(ap(c_2Ecardinal_2Eset__exp(A_27b,A_27c),V2A),ap(ap(c_2Epred__set_2EINSERT(A_27b),V0x),c_2Epred__set_2EEMPTY(A_27b))) = ap(c_2Epred__set_2EGSPEC(arr(A_27b,ty_2Eoption_2Eoption(A_27c)),A_27c),f1854(A_27b,A_27c,V0x,V2A)) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ESING__set__exp__CARD,axiom,
    ! [A_27a: del,A_27b: del,A_27c: del,V0x: $i] :
      ( mem(V0x,A_27b)
     => ! [V1B: $i] :
          ( mem(V1B,arr(A_27a,bool))
         => ! [V2A: $i] :
              ( mem(V2A,arr(A_27c,bool))
             => ( p(ap(ap(c_2Ecardinal_2Ecardeq(arr(A_27a,ty_2Eoption_2Eoption(A_27b)),ty_2Enum_2Enum),ap(ap(c_2Ecardinal_2Eset__exp(A_27a,A_27b),ap(ap(c_2Epred__set_2EINSERT(A_27b),V0x),c_2Epred__set_2EEMPTY(A_27b))),V1B)),ap(c_2Epred__set_2Ecount,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))))
                & p(ap(ap(c_2Ecardinal_2Ecardeq(arr(A_27b,ty_2Eoption_2Eoption(A_27c)),A_27c),ap(ap(c_2Ecardinal_2Eset__exp(A_27b,A_27c),V2A),ap(ap(c_2Epred__set_2EINSERT(A_27b),V0x),c_2Epred__set_2EEMPTY(A_27b)))),V2A)) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2EPOW__TWO__set__exp,axiom,
    ! [A_27a: del,V0A: $i] :
      ( mem(V0A,arr(A_27a,bool))
     => p(ap(ap(c_2Ecardinal_2Ecardeq(arr(A_27a,bool),arr(A_27a,ty_2Eoption_2Eoption(ty_2Enum_2Enum))),ap(c_2Epred__set_2EPOW(A_27a),V0A)),ap(ap(c_2Ecardinal_2Eset__exp(A_27a,ty_2Enum_2Enum),ap(c_2Epred__set_2Ecount,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))),V0A))) ) ).

tff(lamtp_f1855,type,
    f1855: ( del * $i * $i ) > $i ).

tff(lameq_f1855,axiom,
    ! [A_27a: del,V2l: $i] :
      ( mem(V2l,ty_2Elist_2Elist(A_27a))
     => ! [V0A: $i] :
          ( mem(V0A,arr(A_27a,bool))
         => ! [V3e: $i] : ( ap(f1855(A_27a,V2l,V0A),V3e) = ap(ap(c_2Emin_2E_3D_3D_3E,ap(ap(c_2Ebool_2EIN(A_27a),V3e),ap(c_2Elist_2ELIST__TO__SET(A_27a),V2l))),ap(ap(c_2Ebool_2EIN(A_27a),V3e),V0A)) ) ) ) ).

tff(lamtp_f1856,type,
    f1856: ( del * $i * tp__ty_2Enum_2Enum ) > $i ).

tff(lameq_f1856,axiom,
    ! [A_27a: del,V0A: $i] :
      ( mem(V0A,arr(A_27a,bool))
     => ! [V1n: tp__ty_2Enum_2Enum,V2l: $i] : ( ap(f1856(A_27a,V0A,V1n),V2l) = ap(ap(c_2Epair_2E_2C(ty_2Elist_2Elist(A_27a),bool),V2l),ap(ap(c_2Ebool_2E_2F_5C,ap(ap(c_2Emin_2E_3D(ty_2Enum_2Enum),ap(c_2Elist_2ELENGTH(A_27a),V2l)),inj__ty_2Enum_2Enum(V1n))),ap(c_2Ebool_2E_21(A_27a),f1855(A_27a,V2l,V0A)))) ) ) ).

tff(conj_thm_2Ecardinal_2Eset__exp__count,axiom,
    ! [A_27a: del,V0A: $i] :
      ( mem(V0A,arr(A_27a,bool))
     => ! [V1n: tp__ty_2Enum_2Enum] : p(ap(ap(c_2Ecardinal_2Ecardeq(arr(ty_2Enum_2Enum,ty_2Eoption_2Eoption(A_27a)),ty_2Elist_2Elist(A_27a)),ap(ap(c_2Ecardinal_2Eset__exp(ty_2Enum_2Enum,A_27a),V0A),ap(c_2Epred__set_2Ecount,inj__ty_2Enum_2Enum(V1n)))),ap(c_2Epred__set_2EGSPEC(ty_2Elist_2Elist(A_27a),ty_2Elist_2Elist(A_27a)),f1856(A_27a,V0A,V1n)))) ) ).

tff(conj_thm_2Ecardinal_2Eset__exp__card__cong,axiom,
    ! [A_27a1: del,A_27a2: del,A_27b1: del,A_27b2: del,V0a1: $i] :
      ( mem(V0a1,arr(A_27a1,bool))
     => ! [V1a2: $i] :
          ( mem(V1a2,arr(A_27a2,bool))
         => ! [V2b1: $i] :
              ( mem(V2b1,arr(A_27b1,bool))
             => ! [V3b2: $i] :
                  ( mem(V3b2,arr(A_27b2,bool))
                 => ( p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a1,A_27a2),V0a1),V1a2))
                   => ( p(ap(ap(c_2Ecardinal_2Ecardeq(A_27b1,A_27b2),V2b1),V3b2))
                     => p(ap(ap(c_2Ecardinal_2Ecardeq(arr(A_27b1,ty_2Eoption_2Eoption(A_27a1)),arr(A_27b2,ty_2Eoption_2Eoption(A_27a2))),ap(ap(c_2Ecardinal_2Eset__exp(A_27b1,A_27a1),V0a1),V2b1)),ap(ap(c_2Ecardinal_2Eset__exp(A_27b2,A_27a2),V1a2),V3b2))) ) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2Eset__exp__cardle__cong,axiom,
    ! [A_27a: del,A_27b: del,A_27c: del,A_27d: del,V0b: $i] :
      ( mem(V0b,arr(A_27a,bool))
     => ! [V1d: $i] :
          ( mem(V1d,arr(A_27b,bool))
         => ! [V2a: $i] :
              ( mem(V2a,arr(A_27c,bool))
             => ! [V3c: $i] :
                  ( mem(V3c,arr(A_27d,bool))
                 => ( ( ( V0b = c_2Epred__set_2EEMPTY(A_27a) )
                     => ( V1d = c_2Epred__set_2EEMPTY(A_27b) ) )
                   => ( ( p(ap(ap(c_2Ecardinal_2Ecardleq(A_27c,A_27a),V2a),V0b))
                        & p(ap(ap(c_2Ecardinal_2Ecardleq(A_27d,A_27b),V3c),V1d)) )
                     => p(ap(ap(c_2Ecardinal_2Ecardleq(arr(A_27d,ty_2Eoption_2Eoption(A_27c)),arr(A_27b,ty_2Eoption_2Eoption(A_27a))),ap(ap(c_2Ecardinal_2Eset__exp(A_27d,A_27c),V2a),V3c)),ap(ap(c_2Ecardinal_2Eset__exp(A_27b,A_27a),V0b),V1d))) ) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2Eexp__INSERT__cardeq,axiom,
    ! [A_27a: del,A_27b: del,V0e: $i] :
      ( mem(V0e,A_27a)
     => ! [V1s: $i] :
          ( mem(V1s,arr(A_27a,bool))
         => ! [V2A: $i] :
              ( mem(V2A,arr(A_27b,bool))
             => ( ~ p(ap(ap(c_2Ebool_2EIN(A_27a),V0e),V1s))
               => p(ap(ap(c_2Ecardinal_2Ecardeq(arr(A_27a,ty_2Eoption_2Eoption(A_27b)),ty_2Epair_2Eprod(A_27b,arr(A_27a,ty_2Eoption_2Eoption(A_27b)))),ap(ap(c_2Ecardinal_2Eset__exp(A_27a,A_27b),V2A),ap(ap(c_2Epred__set_2EINSERT(A_27a),V0e),V1s))),ap(ap(c_2Epred__set_2ECROSS(A_27b,arr(A_27a,ty_2Eoption_2Eoption(A_27b))),V2A),ap(ap(c_2Ecardinal_2Eset__exp(A_27a,A_27b),V2A),V1s)))) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2Eexp__count__cardeq,axiom,
    ! [A_27a: del,V0A: $i] :
      ( mem(V0A,arr(A_27a,bool))
     => ! [V1n: tp__ty_2Enum_2Enum] :
          ( ( ~ p(ap(c_2Epred__set_2EFINITE(A_27a),V0A))
            & p(ap(ap(c_2Eprim__rec_2E_3C,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)),inj__ty_2Enum_2Enum(V1n))) )
         => p(ap(ap(c_2Ecardinal_2Ecardeq(arr(ty_2Enum_2Enum,ty_2Eoption_2Eoption(A_27a)),A_27a),ap(ap(c_2Ecardinal_2Eset__exp(ty_2Enum_2Enum,A_27a),V0A),ap(c_2Epred__set_2Ecount,inj__ty_2Enum_2Enum(V1n)))),V0A)) ) ) ).

tff(conj_thm_2Ecardinal_2EINFINITE__Unum,axiom,
    ! [A_27a: del,V0A: $i] :
      ( mem(V0A,arr(A_27a,bool))
     => ( ~ p(ap(c_2Epred__set_2EFINITE(A_27a),V0A))
      <=> p(ap(ap(c_2Ecardinal_2Ecardleq(ty_2Enum_2Enum,A_27a),c_2Epred__set_2EUNIV(ty_2Enum_2Enum)),V0A)) ) ) ).

tff(conj_thm_2Ecardinal_2Ecardleq__SURJ,axiom,
    ! [A_27a: del,A_27b: del,V0A: $i] :
      ( mem(V0A,arr(A_27a,bool))
     => ! [V1B: $i] :
          ( mem(V1B,arr(A_27b,bool))
         => ( p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0A),V1B))
          <=> ( ? [V2f: $i] :
                  ( mem(V2f,arr(A_27b,A_27a))
                  & p(ap(ap(ap(c_2Epred__set_2ESURJ(A_27b,A_27a),V2f),V1B),V0A)) )
              | ( V0A = c_2Epred__set_2EEMPTY(A_27a) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2EINFINITE__cardleq__INSERT,axiom,
    ! [A_27a: del,A_27b: del,V0A: $i] :
      ( mem(V0A,arr(A_27a,bool))
     => ! [V1x: $i] :
          ( mem(V1x,A_27b)
         => ! [V2s: $i] :
              ( mem(V2s,arr(A_27b,bool))
             => ( ~ p(ap(c_2Epred__set_2EFINITE(A_27a),V0A))
               => ( p(ap(ap(c_2Ecardinal_2Ecardleq(A_27b,A_27a),ap(ap(c_2Epred__set_2EINSERT(A_27b),V1x),V2s)),V0A))
                <=> p(ap(ap(c_2Ecardinal_2Ecardleq(A_27b,A_27a),V2s),V0A)) ) ) ) ) ) ).

tff(lamtp_f1857,type,
    f1857: ( del * $i * $i ) > $i ).

tff(lameq_f1857,axiom,
    ! [A_27a: del,V1l: $i] :
      ( mem(V1l,ty_2Elist_2Elist(A_27a))
     => ! [V0A: $i] :
          ( mem(V0A,arr(A_27a,bool))
         => ! [V2e: $i] : ( ap(f1857(A_27a,V1l,V0A),V2e) = ap(ap(c_2Emin_2E_3D_3D_3E,ap(ap(c_2Ebool_2EIN(A_27a),V2e),ap(c_2Elist_2ELIST__TO__SET(A_27a),V1l))),ap(ap(c_2Ebool_2EIN(A_27a),V2e),V0A)) ) ) ) ).

tff(lamtp_f1858,type,
    f1858: ( del * $i ) > $i ).

tff(lameq_f1858,axiom,
    ! [A_27a: del,V0A: $i] :
      ( mem(V0A,arr(A_27a,bool))
     => ! [V1l: $i] : ( ap(f1858(A_27a,V0A),V1l) = ap(ap(c_2Epair_2E_2C(ty_2Elist_2Elist(A_27a),bool),V1l),ap(c_2Ebool_2E_21(A_27a),f1857(A_27a,V1l,V0A))) ) ) ).

tff(ax_thm_2Ecardinal_2Elist__def,axiom,
    ! [A_27a: del,V0A: $i] :
      ( mem(V0A,arr(A_27a,bool))
     => ( ap(c_2Ecardinal_2Elist(A_27a),V0A) = ap(c_2Epred__set_2EGSPEC(ty_2Elist_2Elist(A_27a),ty_2Elist_2Elist(A_27a)),f1858(A_27a,V0A)) ) ) ).

tff(conj_thm_2Ecardinal_2Elist__EMPTY,axiom,
    ! [A_27a: del] : ( ap(c_2Ecardinal_2Elist(A_27a),c_2Epred__set_2EEMPTY(A_27a)) = ap(ap(c_2Epred__set_2EINSERT(ty_2Elist_2Elist(A_27a)),c_2Elist_2ENIL(A_27a)),c_2Epred__set_2EEMPTY(ty_2Elist_2Elist(A_27a))) ) ).

tff(conj_thm_2Ecardinal_2Elist__SING,axiom,
    ! [A_27a: del,V0e: $i] :
      ( mem(V0e,A_27a)
     => p(ap(ap(c_2Ecardinal_2Ecardeq(ty_2Elist_2Elist(A_27a),ty_2Enum_2Enum),ap(c_2Ecardinal_2Elist(A_27a),ap(ap(c_2Epred__set_2EINSERT(A_27a),V0e),c_2Epred__set_2EEMPTY(A_27a)))),c_2Epred__set_2EUNIV(ty_2Enum_2Enum))) ) ).

tff(conj_thm_2Ecardinal_2EUNIV__list,axiom,
    ! [A_27a: del] : ( c_2Epred__set_2EUNIV(ty_2Elist_2Elist(A_27a)) = ap(c_2Ecardinal_2Elist(A_27a),c_2Epred__set_2EUNIV(A_27a)) ) ).

tff(lamtp_f1859,type,
    f1859: ( del * $i ) > $i ).

tff(lameq_f1859,axiom,
    ! [A_27a: del,V0A: $i] :
      ( mem(V0A,arr(A_27a,bool))
     => ! [V1n: tp__ty_2Enum_2Enum] : ( ap(f1859(A_27a,V0A),inj__ty_2Enum_2Enum(V1n)) = ap(ap(c_2Ecardinal_2Eset__exp(ty_2Enum_2Enum,A_27a),V0A),ap(c_2Epred__set_2Ecount,inj__ty_2Enum_2Enum(V1n))) ) ) ).

tff(conj_thm_2Ecardinal_2Elist__BIGUNION__EXP,axiom,
    ! [A_27a: del,V0A: $i] :
      ( mem(V0A,arr(A_27a,bool))
     => p(ap(ap(c_2Ecardinal_2Ecardeq(ty_2Elist_2Elist(A_27a),arr(ty_2Enum_2Enum,ty_2Eoption_2Eoption(A_27a))),ap(c_2Ecardinal_2Elist(A_27a),V0A)),ap(c_2Epred__set_2EBIGUNION(arr(ty_2Enum_2Enum,ty_2Eoption_2Eoption(A_27a))),ap(ap(c_2Epred__set_2EIMAGE(ty_2Enum_2Enum,arr(arr(ty_2Enum_2Enum,ty_2Eoption_2Eoption(A_27a)),bool)),f1859(A_27a,V0A)),c_2Epred__set_2EUNIV(ty_2Enum_2Enum))))) ) ).

tff(conj_thm_2Ecardinal_2EINFINITE__A__list__BIJ__A,axiom,
    ! [A_27a: del,V0A: $i] :
      ( mem(V0A,arr(A_27a,bool))
     => ( ~ p(ap(c_2Epred__set_2EFINITE(A_27a),V0A))
       => p(ap(ap(c_2Ecardinal_2Ecardeq(ty_2Elist_2Elist(A_27a),A_27a),ap(c_2Ecardinal_2Elist(A_27a),V0A)),V0A)) ) ) ).

tff(lamtp_f1860,type,
    f1860: ( del * $i ) > $i ).

tff(lameq_f1860,axiom,
    ! [A_27a: del,V0A: $i] :
      ( mem(V0A,arr(A_27a,bool))
     => ! [V1s: $i] : ( ap(f1860(A_27a,V0A),V1s) = ap(ap(c_2Epair_2E_2C(arr(A_27a,bool),bool),V1s),ap(ap(c_2Ebool_2E_2F_5C,ap(c_2Epred__set_2EFINITE(A_27a),V1s)),ap(ap(c_2Epred__set_2ESUBSET(A_27a),V1s),V0A))) ) ) ).

tff(conj_thm_2Ecardinal_2Efinite__subsets__bijection,axiom,
    ! [A_27a: del,V0A: $i] :
      ( mem(V0A,arr(A_27a,bool))
     => ( ~ p(ap(c_2Epred__set_2EFINITE(A_27a),V0A))
       => p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a,arr(A_27a,bool)),V0A),ap(c_2Epred__set_2EGSPEC(arr(A_27a,bool),arr(A_27a,bool)),f1860(A_27a,V0A)))) ) ) ).

tff(conj_thm_2Ecardinal_2EFINITE__IMAGE__INJ_27,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1f: $i] :
          ( mem(V1f,arr(A_27a,A_27b))
         => ( ! [V2x: $i] :
                ( mem(V2x,A_27a)
               => ! [V3y: $i] :
                    ( mem(V3y,A_27a)
                   => ( ( p(ap(ap(c_2Ebool_2EIN(A_27a),V2x),V0s))
                        & p(ap(ap(c_2Ebool_2EIN(A_27a),V3y),V0s)) )
                     => ( ( ap(V1f,V2x) = ap(V1f,V3y) )
                      <=> ( V2x = V3y ) ) ) ) )
           => ( p(ap(c_2Epred__set_2EFINITE(A_27b),ap(ap(c_2Epred__set_2EIMAGE(A_27a,A_27b),V1f),V0s)))
            <=> p(ap(c_2Epred__set_2EFINITE(A_27a),V0s)) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2Ecountable__decomposition,axiom,
    ! [A_27a: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ( ~ p(ap(c_2Epred__set_2EFINITE(A_27a),V0s))
       => ? [V1A: $i] :
            ( mem(V1A,arr(arr(A_27a,bool),bool))
            & ( ap(c_2Epred__set_2EBIGUNION(A_27a),V1A) = V0s )
            & ! [V2a: $i] :
                ( mem(V2a,arr(A_27a,bool))
               => ( p(ap(ap(c_2Ebool_2EIN(arr(A_27a,bool)),V2a),V1A))
                 => ( ~ p(ap(c_2Epred__set_2EFINITE(A_27a),V2a))
                    & p(ap(c_2Epred__set_2Ecountable(A_27a),V2a)) ) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2Edisjoint__countable__decomposition,axiom,
    ! [A_27a: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ( ~ p(ap(c_2Epred__set_2EFINITE(A_27a),V0s))
       => ? [V1A: $i] :
            ( mem(V1A,arr(arr(A_27a,bool),bool))
            & ( ap(c_2Epred__set_2EBIGUNION(A_27a),V1A) = V0s )
            & ! [V2a: $i] :
                ( mem(V2a,arr(A_27a,bool))
               => ( p(ap(ap(c_2Ebool_2EIN(arr(A_27a,bool)),V2a),V1A))
                 => ( ~ p(ap(c_2Epred__set_2EFINITE(A_27a),V2a))
                    & p(ap(c_2Epred__set_2Ecountable(A_27a),V2a)) ) ) )
            & ! [V3a1: $i] :
                ( mem(V3a1,arr(A_27a,bool))
               => ! [V4a2: $i] :
                    ( mem(V4a2,arr(A_27a,bool))
                   => ( ( p(ap(ap(c_2Ebool_2EIN(arr(A_27a,bool)),V3a1),V1A))
                        & p(ap(ap(c_2Ebool_2EIN(arr(A_27a,bool)),V4a2),V1A))
                        & ( V3a1 != V4a2 ) )
                     => p(ap(ap(c_2Epred__set_2EDISJOINT(A_27a),V3a1),V4a2)) ) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2Ecount__cardle,axiom,
    ! [A_27a: del,V0n: tp__ty_2Enum_2Enum,V1A: $i] :
      ( mem(V1A,arr(A_27a,bool))
     => ( p(ap(ap(c_2Ecardinal_2Ecardleq(ty_2Enum_2Enum,A_27a),ap(c_2Epred__set_2Ecount,inj__ty_2Enum_2Enum(V0n))),V1A))
      <=> ( p(ap(c_2Epred__set_2EFINITE(A_27a),V1A))
         => p(ap(ap(c_2Earithmetic_2E_3C_3D,inj__ty_2Enum_2Enum(V0n)),ap(c_2Epred__set_2ECARD(A_27a),V1A))) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECANTOR,axiom,
    ! [A_27a: del,V0A: $i] :
      ( mem(V0A,arr(A_27a,bool))
     => ~ p(ap(ap(c_2Ecardinal_2Ecardleq(arr(A_27a,bool),A_27a),ap(c_2Epred__set_2EPOW(A_27a),V0A)),V0A)) ) ).

tff(conj_thm_2Ecardinal_2Ecardlt__cardle,axiom,
    ! [A_27a: del,A_27b: del,V0B: $i] :
      ( mem(V0B,arr(A_27b,bool))
     => ! [V1A: $i] :
          ( mem(V1A,arr(A_27a,bool))
         => ( ~ p(ap(ap(c_2Ecardinal_2Ecardleq(A_27b,A_27a),V0B),V1A))
           => p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V1A),V0B)) ) ) ) ).

tff(conj_thm_2Ecardinal_2Eset__exp__product,axiom,
    ! [A_27a: del,A_27b: del,A_27c: del,V0A: $i] :
      ( mem(V0A,arr(A_27c,bool))
     => ! [V1B1: $i] :
          ( mem(V1B1,arr(A_27b,bool))
         => ! [V2B2: $i] :
              ( mem(V2B2,arr(A_27a,bool))
             => p(ap(ap(c_2Ecardinal_2Ecardeq(arr(A_27a,ty_2Eoption_2Eoption(arr(A_27b,ty_2Eoption_2Eoption(A_27c)))),arr(ty_2Epair_2Eprod(A_27b,A_27a),ty_2Eoption_2Eoption(A_27c))),ap(ap(c_2Ecardinal_2Eset__exp(A_27a,arr(A_27b,ty_2Eoption_2Eoption(A_27c))),ap(ap(c_2Ecardinal_2Eset__exp(A_27b,A_27c),V0A),V1B1)),V2B2)),ap(ap(c_2Ecardinal_2Eset__exp(ty_2Epair_2Eprod(A_27b,A_27a),A_27c),V0A),ap(ap(c_2Epred__set_2ECROSS(A_27b,A_27a),V1B1),V2B2)))) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECOUNT__EQ__EMPTY,axiom,
    ! [V0n: tp__ty_2Enum_2Enum] :
      ( ( ap(c_2Epred__set_2Ecount,inj__ty_2Enum_2Enum(V0n)) = c_2Epred__set_2EEMPTY(ty_2Enum_2Enum) )
    <=> ( V0n = fo__c_2Enum_2E0 ) ) ).

tff(conj_thm_2Ecardinal_2EPOW__EQ__X__EXP__X,axiom,
    ! [A_27a: del,V0A: $i] :
      ( mem(V0A,arr(A_27a,bool))
     => ( ~ p(ap(c_2Epred__set_2EFINITE(A_27a),V0A))
       => p(ap(ap(c_2Ecardinal_2Ecardeq(arr(A_27a,bool),arr(A_27a,ty_2Eoption_2Eoption(A_27a))),ap(c_2Epred__set_2EPOW(A_27a),V0A)),ap(ap(c_2Ecardinal_2Eset__exp(A_27a,A_27a),V0A),V0A))) ) ) ).

tff(lamtp_f1861,type,
    f1861: ( del * $i * $i ) > $i ).

tff(lameq_f1861,axiom,
    ! [A_27a: del,V1f: $i] :
      ( mem(V1f,arr(A_27a,ty_2Eoption_2Eoption(A_27a)))
     => ! [V2a: $i] :
          ( mem(V2a,A_27a)
         => ! [V3b: $i] : ( ap(f1861(A_27a,V1f,V2a),V3b) = ap(ap(c_2Emin_2E_3D(ty_2Eoption_2Eoption(A_27a)),ap(V1f,V2a)),ap(c_2Eoption_2ESOME(A_27a),V3b)) ) ) ) ).

tff(lamtp_f1862,type,
    f1862: ( del * $i * $i ) > $i ).

tff(lameq_f1862,axiom,
    ! [A_27a: del,V0A: $i] :
      ( mem(V0A,arr(A_27a,bool))
     => ! [V1f: $i] :
          ( mem(V1f,arr(A_27a,ty_2Eoption_2Eoption(A_27a)))
         => ! [V2a: $i] : ( ap(f1862(A_27a,V0A,V1f),V2a) = ap(ap(c_2Emin_2E_3D(bool),ap(ap(c_2Ebool_2EIN(A_27a),V2a),V0A)),ap(c_2Ebool_2E_3F(A_27a),f1861(A_27a,V1f,V2a))) ) ) ) ).

tff(lamtp_f1863,type,
    f1863: ( del * $i ) > $i ).

tff(lameq_f1863,axiom,
    ! [A_27a: del,V0A: $i] :
      ( mem(V0A,arr(A_27a,bool))
     => ! [V1f: $i] : ( ap(f1863(A_27a,V0A),V1f) = ap(ap(c_2Epair_2E_2C(arr(A_27a,ty_2Eoption_2Eoption(A_27a)),bool),V1f),ap(ap(c_2Ebool_2E_2F_5C,ap(ap(ap(c_2Epred__set_2EBIJ(A_27a,A_27a),ap(ap(c_2Ecombin_2Eo(A_27a,A_27a,ty_2Eoption_2Eoption(A_27a)),c_2Eoption_2ETHE(A_27a)),V1f)),V0A),V0A)),ap(c_2Ebool_2E_21(A_27a),f1862(A_27a,V0A,V1f)))) ) ) ).

tff(ax_thm_2Ecardinal_2Ebijns__def,axiom,
    ! [A_27a: del,V0A: $i] :
      ( mem(V0A,arr(A_27a,bool))
     => ( ap(c_2Ecardinal_2Ebijns(A_27a),V0A) = ap(c_2Epred__set_2EGSPEC(arr(A_27a,ty_2Eoption_2Eoption(A_27a)),arr(A_27a,ty_2Eoption_2Eoption(A_27a))),f1863(A_27a,V0A)) ) ) ).

tff(conj_thm_2Ecardinal_2Ecardeq__bijns__cong,axiom,
    ! [A_27a: del,A_27b: del,V0A: $i] :
      ( mem(V0A,arr(A_27a,bool))
     => ! [V1B: $i] :
          ( mem(V1B,arr(A_27b,bool))
         => ( p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a,A_27b),V0A),V1B))
           => p(ap(ap(c_2Ecardinal_2Ecardeq(arr(A_27a,ty_2Eoption_2Eoption(A_27a)),arr(A_27b,ty_2Eoption_2Eoption(A_27b))),ap(c_2Ecardinal_2Ebijns(A_27a),V0A)),ap(c_2Ecardinal_2Ebijns(A_27b),V1B))) ) ) ) ).

tff(conj_thm_2Ecardinal_2Ebijections__cardeq,axiom,
    ! [A_27a: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ( ~ p(ap(c_2Epred__set_2EFINITE(A_27a),V0s))
       => p(ap(ap(c_2Ecardinal_2Ecardeq(arr(A_27a,ty_2Eoption_2Eoption(A_27a)),arr(A_27a,bool)),ap(c_2Ecardinal_2Ebijns(A_27a),V0s)),ap(c_2Epred__set_2EPOW(A_27a),V0s))) ) ) ).

tff(conj_thm_2Ecardinal_2ELEFT__IMP__EXISTS__THM,axiom,
    ! [A_27a: del,V0P: $i] :
      ( mem(V0P,arr(A_27a,bool))
     => ! [V1Q: tp__o] :
          ( ( ? [V2x: $i] :
                ( mem(V2x,A_27a)
                & p(ap(V0P,V2x)) )
           => p(inj__o(V1Q)) )
        <=> ! [V3x: $i] :
              ( mem(V3x,A_27a)
             => ( p(ap(V0P,V3x))
               => p(inj__o(V1Q)) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ELEFT__IMP__FORALL__THM,axiom,
    ! [A_27a: del,V0P: $i] :
      ( mem(V0P,arr(A_27a,bool))
     => ! [V1Q: tp__o] :
          ( ( ! [V2x: $i] :
                ( mem(V2x,A_27a)
               => p(ap(V0P,V2x)) )
           => p(inj__o(V1Q)) )
        <=> ? [V3x: $i] :
              ( mem(V3x,A_27a)
              & ( p(ap(V0P,V3x))
               => p(inj__o(V1Q)) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ERIGHT__IMP__EXISTS__THM,axiom,
    ! [A_27a: del,V0P: tp__o,V1Q: $i] :
      ( mem(V1Q,arr(A_27a,bool))
     => ( ( p(inj__o(V0P))
         => ? [V2x: $i] :
              ( mem(V2x,A_27a)
              & p(ap(V1Q,V2x)) ) )
      <=> ? [V3x: $i] :
            ( mem(V3x,A_27a)
            & ( p(inj__o(V0P))
             => p(ap(V1Q,V3x)) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ERIGHT__IMP__FORALL__THM,axiom,
    ! [A_27a: del,V0P: tp__o,V1Q: $i] :
      ( mem(V1Q,arr(A_27a,bool))
     => ( ( p(inj__o(V0P))
         => ! [V2x: $i] :
              ( mem(V2x,A_27a)
             => p(ap(V1Q,V2x)) ) )
      <=> ! [V3x: $i] :
            ( mem(V3x,A_27a)
           => ( p(inj__o(V0P))
             => p(ap(V1Q,V3x)) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2EFINITE__FINITE__BIGUNIONS,axiom,
    ! [A_27a: del,V0s: $i] :
      ( mem(V0s,arr(arr(A_27a,bool),bool))
     => ( p(ap(c_2Epred__set_2EFINITE(arr(A_27a,bool)),V0s))
       => ( p(ap(c_2Epred__set_2EFINITE(A_27a),ap(c_2Epred__set_2EBIGUNION(A_27a),V0s)))
        <=> ! [V1t: $i] :
              ( mem(V1t,arr(A_27a,bool))
             => ( p(ap(ap(c_2Ebool_2EIN(arr(A_27a,bool)),V1t),V0s))
               => p(ap(c_2Epred__set_2EFINITE(A_27a),V1t)) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECONJ__EQ__IMP,axiom,
    ! [V0r: tp__o,V1p: tp__o,V2q: tp__o] :
      ( ( ( p(inj__o(V1p))
          & p(inj__o(V2q)) )
       => p(inj__o(V0r)) )
    <=> ( p(inj__o(V1p))
       => ( p(inj__o(V2q))
         => p(inj__o(V0r)) ) ) ) ).

tff(conj_thm_2Ecardinal_2EIMP__CONJ__ALT,axiom,
    ! [V0r: tp__o,V1p: tp__o,V2q: tp__o] :
      ( ( ( p(inj__o(V1p))
          & p(inj__o(V2q)) )
       => p(inj__o(V0r)) )
    <=> ( p(inj__o(V2q))
       => ( p(inj__o(V1p))
         => p(inj__o(V0r)) ) ) ) ).

tff(conj_thm_2Ecardinal_2ELT__SUC__LE,axiom,
    ! [V0m: tp__ty_2Enum_2Enum,V1n: tp__ty_2Enum_2Enum] :
      ( p(ap(ap(c_2Eprim__rec_2E_3C,inj__ty_2Enum_2Enum(V0m)),ap(c_2Enum_2ESUC,inj__ty_2Enum_2Enum(V1n))))
    <=> p(ap(ap(c_2Earithmetic_2E_3C_3D,inj__ty_2Enum_2Enum(V0m)),inj__ty_2Enum_2Enum(V1n))) ) ).

tff(conj_thm_2Ecardinal_2ESURJECTIVE__ON__RIGHT__INVERSE,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1f: $i] :
          ( mem(V1f,arr(A_27a,A_27b))
         => ! [V2t: $i] :
              ( mem(V2t,arr(A_27b,bool))
             => ( ! [V3y: $i] :
                    ( mem(V3y,A_27b)
                   => ( p(ap(ap(c_2Ebool_2EIN(A_27b),V3y),V2t))
                     => ? [V4x: $i] :
                          ( mem(V4x,A_27a)
                          & p(ap(ap(c_2Ebool_2EIN(A_27a),V4x),V0s))
                          & ( ap(V1f,V4x) = V3y ) ) ) )
              <=> ? [V5g: $i] :
                    ( mem(V5g,arr(A_27b,A_27a))
                    & ! [V6y: $i] :
                        ( mem(V6y,A_27b)
                       => ( p(ap(ap(c_2Ebool_2EIN(A_27b),V6y),V2t))
                         => ( p(ap(ap(c_2Ebool_2EIN(A_27a),ap(V5g,V6y)),V0s))
                            & ( ap(V1f,ap(V5g,V6y)) = V6y ) ) ) ) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ESURJECTIVE__RIGHT__INVERSE,axiom,
    ! [A_27a: del,A_27b: del,V0f: $i] :
      ( mem(V0f,arr(A_27b,A_27a))
     => ( ! [V1y: $i] :
            ( mem(V1y,A_27a)
           => ? [V2x: $i] :
                ( mem(V2x,A_27b)
                & ( ap(V0f,V2x) = V1y ) ) )
      <=> ? [V3g: $i] :
            ( mem(V3g,arr(A_27a,A_27b))
            & ! [V4y: $i] :
                ( mem(V4y,A_27a)
               => ( ap(V0f,ap(V3g,V4y)) = V4y ) ) ) ) ) ).

tff(lamtp_f1864,type,
    f1864: ( del * del * $i * $i * $i ) > $i ).

tff(lameq_f1864,axiom,
    ! [A_27b: del,A_27a: del,V2s: $i] :
      ( mem(V2s,arr(A_27a,bool))
     => ! [V0f: $i] :
          ( mem(V0f,arr(A_27a,A_27b))
         => ! [V1A: $i] :
              ( mem(V1A,arr(A_27b,bool))
             => ! [V5x: $i] : ( ap(f1864(A_27b,A_27a,V2s,V0f,V1A),V5x) = ap(ap(c_2Epair_2E_2C(A_27a,bool),V5x),ap(ap(c_2Ebool_2E_2F_5C,ap(ap(c_2Ebool_2EIN(A_27a),V5x),V2s)),ap(ap(c_2Ebool_2EIN(A_27b),ap(V0f,V5x)),V1A))) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2EFINITE__IMAGE__INJ__GENERAL,axiom,
    ! [A_27a: del,A_27b: del,V0f: $i] :
      ( mem(V0f,arr(A_27a,A_27b))
     => ! [V1A: $i] :
          ( mem(V1A,arr(A_27b,bool))
         => ! [V2s: $i] :
              ( mem(V2s,arr(A_27a,bool))
             => ( ( ! [V3x: $i] :
                      ( mem(V3x,A_27a)
                     => ! [V4y: $i] :
                          ( mem(V4y,A_27a)
                         => ( ( p(ap(ap(c_2Ebool_2EIN(A_27a),V3x),V2s))
                              & p(ap(ap(c_2Ebool_2EIN(A_27a),V4y),V2s))
                              & ( ap(V0f,V3x) = ap(V0f,V4y) ) )
                           => ( V3x = V4y ) ) ) )
                  & p(ap(c_2Epred__set_2EFINITE(A_27b),V1A)) )
               => p(ap(c_2Epred__set_2EFINITE(A_27a),ap(c_2Epred__set_2EGSPEC(A_27a,A_27a),f1864(A_27b,A_27a,V2s,V0f,V1A)))) ) ) ) ) ).

tff(lamtp_f1865,type,
    f1865: ( del * del * $i * $i ) > $i ).

tff(lameq_f1865,axiom,
    ! [A_27b: del,A_27a: del,V1A: $i] :
      ( mem(V1A,arr(A_27b,bool))
     => ! [V0f: $i] :
          ( mem(V0f,arr(A_27a,A_27b))
         => ! [V4x: $i] : ( ap(f1865(A_27b,A_27a,V1A,V0f),V4x) = ap(ap(c_2Epair_2E_2C(A_27a,bool),V4x),ap(ap(c_2Ebool_2EIN(A_27b),ap(V0f,V4x)),V1A)) ) ) ) ).

tff(conj_thm_2Ecardinal_2EFINITE__IMAGE__INJ,axiom,
    ! [A_27a: del,A_27b: del,V0f: $i] :
      ( mem(V0f,arr(A_27a,A_27b))
     => ! [V1A: $i] :
          ( mem(V1A,arr(A_27b,bool))
         => ( ( ! [V2x: $i] :
                  ( mem(V2x,A_27a)
                 => ! [V3y: $i] :
                      ( mem(V3y,A_27a)
                     => ( ( ap(V0f,V2x) = ap(V0f,V3y) )
                       => ( V2x = V3y ) ) ) )
              & p(ap(c_2Epred__set_2EFINITE(A_27b),V1A)) )
           => p(ap(c_2Epred__set_2EFINITE(A_27a),ap(c_2Epred__set_2EGSPEC(A_27a,A_27a),f1865(A_27b,A_27a,V1A,V0f)))) ) ) ) ).

tff(conj_thm_2Ecardinal_2EFINITE__IMAGE__INJ__EQ,axiom,
    ! [A_27a: del,A_27b: del,V0f: $i] :
      ( mem(V0f,arr(A_27a,A_27b))
     => ! [V1s: $i] :
          ( mem(V1s,arr(A_27a,bool))
         => ( ! [V2x: $i] :
                ( mem(V2x,A_27a)
               => ! [V3y: $i] :
                    ( mem(V3y,A_27a)
                   => ( ( p(ap(ap(c_2Ebool_2EIN(A_27a),V2x),V1s))
                        & p(ap(ap(c_2Ebool_2EIN(A_27a),V3y),V1s))
                        & ( ap(V0f,V2x) = ap(V0f,V3y) ) )
                     => ( V2x = V3y ) ) ) )
           => ( p(ap(c_2Epred__set_2EFINITE(A_27b),ap(ap(c_2Epred__set_2EIMAGE(A_27a,A_27b),V0f),V1s)))
            <=> p(ap(c_2Epred__set_2EFINITE(A_27a),V1s)) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2EINFINITE__IMAGE__INJ,axiom,
    ! [A_27a: del,A_27b: del,V0f: $i] :
      ( mem(V0f,arr(A_27a,A_27b))
     => ( ! [V1x: $i] :
            ( mem(V1x,A_27a)
           => ! [V2y: $i] :
                ( mem(V2y,A_27a)
               => ( ( ap(V0f,V1x) = ap(V0f,V2y) )
                 => ( V1x = V2y ) ) ) )
       => ! [V3s: $i] :
            ( mem(V3s,arr(A_27a,bool))
           => ( ~ p(ap(c_2Epred__set_2EFINITE(A_27a),V3s))
             => ~ p(ap(c_2Epred__set_2EFINITE(A_27b),ap(ap(c_2Epred__set_2EIMAGE(A_27a,A_27b),V0f),V3s))) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2EINFINITE__NONEMPTY,axiom,
    ! [A_27a: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ( ~ p(ap(c_2Epred__set_2EFINITE(A_27a),V0s))
       => ( V0s != c_2Epred__set_2EEMPTY(A_27a) ) ) ) ).

tff(lamtp_f1866,type,
    f1866: ( del * del * del * $i * $i * $i * $i ) > $i ).

tff(lameq_f1866,axiom,
    ! [A_27a: del,A_27c: del,A_27b: del,V1s: $i] :
      ( mem(V1s,arr(A_27a,bool))
     => ! [V2t: $i] :
          ( mem(V2t,arr(A_27a,arr(A_27b,bool)))
         => ! [V0f: $i] :
              ( mem(V0f,arr(A_27a,arr(A_27b,A_27c)))
             => ! [V4x: $i] :
                  ( mem(V4x,A_27a)
                 => ! [V5y: $i] : ( ap(f1866(A_27a,A_27c,A_27b,V1s,V2t,V0f,V4x),V5y) = ap(ap(c_2Epair_2E_2C(A_27c,bool),ap(ap(V0f,V4x),V5y)),ap(ap(c_2Ebool_2E_2F_5C,ap(ap(c_2Ebool_2EIN(A_27a),V4x),V1s)),ap(ap(c_2Ebool_2EIN(A_27b),V5y),ap(V2t,V4x)))) ) ) ) ) ) ).

tff(lamtp_f1867,type,
    f1867: ( del * del * del * $i * $i * $i ) > $i ).

tff(lameq_f1867,axiom,
    ! [A_27b: del,A_27c: del,A_27a: del,V1s: $i] :
      ( mem(V1s,arr(A_27a,bool))
     => ! [V2t: $i] :
          ( mem(V2t,arr(A_27a,arr(A_27b,bool)))
         => ! [V0f: $i] :
              ( mem(V0f,arr(A_27a,arr(A_27b,A_27c)))
             => ! [V4x: $i] : ( ap(f1867(A_27b,A_27c,A_27a,V1s,V2t,V0f),V4x) = f1866(A_27a,A_27c,A_27b,V1s,V2t,V0f,V4x) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2EFINITE__PRODUCT__DEPENDENT,axiom,
    ! [A_27a: del,A_27b: del,A_27c: del,V0f: $i] :
      ( mem(V0f,arr(A_27a,arr(A_27b,A_27c)))
     => ! [V1s: $i] :
          ( mem(V1s,arr(A_27a,bool))
         => ! [V2t: $i] :
              ( mem(V2t,arr(A_27a,arr(A_27b,bool)))
             => ( ( p(ap(c_2Epred__set_2EFINITE(A_27a),V1s))
                  & ! [V3x: $i] :
                      ( mem(V3x,A_27a)
                     => ( p(ap(ap(c_2Ebool_2EIN(A_27a),V3x),V1s))
                       => p(ap(c_2Epred__set_2EFINITE(A_27b),ap(V2t,V3x))) ) ) )
               => p(ap(c_2Epred__set_2EFINITE(A_27c),ap(c_2Epred__set_2EGSPEC(A_27c,ty_2Epair_2Eprod(A_27a,A_27b)),ap(c_2Epair_2EUNCURRY(A_27a,A_27b,ty_2Epair_2Eprod(A_27c,bool)),f1867(A_27b,A_27c,A_27a,V1s,V2t,V0f))))) ) ) ) ) ).

tff(lamtp_f1868,type,
    f1868: ( del * del * $i * $i * $i ) > $i ).

tff(lameq_f1868,axiom,
    ! [A_27a: del,A_27b: del,V1t: $i] :
      ( mem(V1t,arr(A_27b,bool))
     => ! [V0s: $i] :
          ( mem(V0s,arr(A_27a,bool))
         => ! [V2x: $i] :
              ( mem(V2x,A_27a)
             => ! [V3y: $i] : ( ap(f1868(A_27a,A_27b,V1t,V0s,V2x),V3y) = ap(ap(c_2Epair_2E_2C(ty_2Epair_2Eprod(A_27a,A_27b),bool),ap(ap(c_2Epair_2E_2C(A_27a,A_27b),V2x),V3y)),ap(ap(c_2Ebool_2E_2F_5C,ap(ap(c_2Ebool_2EIN(A_27a),V2x),V0s)),ap(ap(c_2Ebool_2EIN(A_27b),V3y),V1t))) ) ) ) ) ).

tff(lamtp_f1869,type,
    f1869: ( del * del * $i * $i ) > $i ).

tff(lameq_f1869,axiom,
    ! [A_27b: del,A_27a: del,V1t: $i] :
      ( mem(V1t,arr(A_27b,bool))
     => ! [V0s: $i] :
          ( mem(V0s,arr(A_27a,bool))
         => ! [V2x: $i] : ( ap(f1869(A_27b,A_27a,V1t,V0s),V2x) = f1868(A_27a,A_27b,V1t,V0s,V2x) ) ) ) ).

tff(conj_thm_2Ecardinal_2EFINITE__PRODUCT,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ( ( p(ap(c_2Epred__set_2EFINITE(A_27a),V0s))
              & p(ap(c_2Epred__set_2EFINITE(A_27b),V1t)) )
           => p(ap(c_2Epred__set_2EFINITE(ty_2Epair_2Eprod(A_27a,A_27b)),ap(c_2Epred__set_2EGSPEC(ty_2Epair_2Eprod(A_27a,A_27b),ty_2Epair_2Eprod(A_27a,A_27b)),ap(c_2Epair_2EUNCURRY(A_27a,A_27b,ty_2Epair_2Eprod(ty_2Epair_2Eprod(A_27a,A_27b),bool)),f1869(A_27b,A_27a,V1t,V0s))))) ) ) ) ).

tff(lamtp_f1870,type,
    f1870: ( del * del * $i * $i ) > $i ).

tff(lameq_f1870,axiom,
    ! [A_27b: del,A_27a: del,V3P: $i] :
      ( mem(V3P,arr(A_27b,bool))
     => ! [V0f: $i] :
          ( mem(V0f,arr(A_27a,A_27b))
         => ! [V4x: $i] : ( ap(f1870(A_27b,A_27a,V3P,V0f),V4x) = ap(ap(c_2Epair_2E_2C(A_27a,bool),V4x),ap(V3P,ap(V0f,V4x))) ) ) ) ).

tff(lamtp_f1871,type,
    f1871: ( del * $i ) > $i ).

tff(lameq_f1871,axiom,
    ! [A_27b: del,V3P: $i] :
      ( mem(V3P,arr(A_27b,bool))
     => ! [V5x: $i] : ( ap(f1871(A_27b,V3P),V5x) = ap(ap(c_2Epair_2E_2C(A_27b,bool),V5x),ap(V3P,V5x)) ) ) ).

tff(conj_thm_2Ecardinal_2ESURJECTIVE__IMAGE__THM,axiom,
    ! [A_27a: del,A_27b: del,V0f: $i] :
      ( mem(V0f,arr(A_27a,A_27b))
     => ( ! [V1y: $i] :
            ( mem(V1y,A_27b)
           => ? [V2x: $i] :
                ( mem(V2x,A_27a)
                & ( ap(V0f,V2x) = V1y ) ) )
      <=> ! [V3P: $i] :
            ( mem(V3P,arr(A_27b,bool))
           => ( ap(ap(c_2Epred__set_2EIMAGE(A_27a,A_27b),V0f),ap(c_2Epred__set_2EGSPEC(A_27a,A_27a),f1870(A_27b,A_27a,V3P,V0f))) = ap(c_2Epred__set_2EGSPEC(A_27b,A_27b),f1871(A_27b,V3P)) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ESURJECTIVE__ON__IMAGE,axiom,
    ! [A_27a: del,A_27b: del,V0f: $i] :
      ( mem(V0f,arr(A_27a,A_27b))
     => ! [V1u: $i] :
          ( mem(V1u,arr(A_27a,bool))
         => ! [V2v: $i] :
              ( mem(V2v,arr(A_27b,bool))
             => ( ! [V3t: $i] :
                    ( mem(V3t,arr(A_27b,bool))
                   => ( p(ap(ap(c_2Epred__set_2ESUBSET(A_27b),V3t),V2v))
                     => ? [V4s: $i] :
                          ( mem(V4s,arr(A_27a,bool))
                          & p(ap(ap(c_2Epred__set_2ESUBSET(A_27a),V4s),V1u))
                          & ( ap(ap(c_2Epred__set_2EIMAGE(A_27a,A_27b),V0f),V4s) = V3t ) ) ) )
              <=> ! [V5y: $i] :
                    ( mem(V5y,A_27b)
                   => ( p(ap(ap(c_2Ebool_2EIN(A_27b),V5y),V2v))
                     => ? [V6x: $i] :
                          ( mem(V6x,A_27a)
                          & p(ap(ap(c_2Ebool_2EIN(A_27a),V6x),V1u))
                          & ( ap(V0f,V6x) = V5y ) ) ) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ESURJECTIVE__IMAGE,axiom,
    ! [A_27a: del,A_27b: del,V0f: $i] :
      ( mem(V0f,arr(A_27a,A_27b))
     => ( ! [V1t: $i] :
            ( mem(V1t,arr(A_27b,bool))
           => ? [V2s: $i] :
                ( mem(V2s,arr(A_27a,bool))
                & ( ap(ap(c_2Epred__set_2EIMAGE(A_27a,A_27b),V0f),V2s) = V1t ) ) )
      <=> ! [V3y: $i] :
            ( mem(V3y,A_27b)
           => ? [V4x: $i] :
                ( mem(V4x,A_27a)
                & ( ap(V0f,V4x) = V3y ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARD__LE__INJ,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ( ( p(ap(c_2Epred__set_2EFINITE(A_27a),V0s))
              & p(ap(c_2Epred__set_2EFINITE(A_27b),V1t))
              & p(ap(ap(c_2Earithmetic_2E_3C_3D,ap(c_2Epred__set_2ECARD(A_27a),V0s)),ap(c_2Epred__set_2ECARD(A_27b),V1t))) )
           => ? [V2f: $i] :
                ( mem(V2f,arr(A_27a,A_27b))
                & p(ap(ap(c_2Epred__set_2ESUBSET(A_27b),ap(ap(c_2Epred__set_2EIMAGE(A_27a,A_27b),V2f),V0s)),V1t))
                & ! [V3x: $i] :
                    ( mem(V3x,A_27a)
                   => ! [V4y: $i] :
                        ( mem(V4y,A_27a)
                       => ( ( p(ap(ap(c_2Ebool_2EIN(A_27a),V3x),V0s))
                            & p(ap(ap(c_2Ebool_2EIN(A_27a),V4y),V0s))
                            & ( ap(V2f,V3x) = ap(V2f,V4y) ) )
                         => ( V3x = V4y ) ) ) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARD__IMAGE__INJ,axiom,
    ! [A_27a: del,A_27b: del,V0f: $i] :
      ( mem(V0f,arr(A_27a,A_27b))
     => ! [V1s: $i] :
          ( mem(V1s,arr(A_27a,bool))
         => ( ( ! [V2x: $i] :
                  ( mem(V2x,A_27a)
                 => ! [V3y: $i] :
                      ( mem(V3y,A_27a)
                     => ( ( p(ap(ap(c_2Ebool_2EIN(A_27a),V2x),V1s))
                          & p(ap(ap(c_2Ebool_2EIN(A_27a),V3y),V1s))
                          & ( ap(V0f,V2x) = ap(V0f,V3y) ) )
                       => ( V2x = V3y ) ) ) )
              & p(ap(c_2Epred__set_2EFINITE(A_27a),V1s)) )
           => ( surj__ty_2Enum_2Enum(ap(c_2Epred__set_2ECARD(A_27b),ap(ap(c_2Epred__set_2EIMAGE(A_27a,A_27b),V0f),V1s))) = surj__ty_2Enum_2Enum(ap(c_2Epred__set_2ECARD(A_27a),V1s)) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARD__IMAGE__LE,axiom,
    ! [A_27a: del,A_27b: del,V0f: $i] :
      ( mem(V0f,arr(A_27a,A_27b))
     => ! [V1s: $i] :
          ( mem(V1s,arr(A_27a,bool))
         => ( p(ap(c_2Epred__set_2EFINITE(A_27a),V1s))
           => p(ap(ap(c_2Earithmetic_2E_3C_3D,ap(c_2Epred__set_2ECARD(A_27b),ap(ap(c_2Epred__set_2EIMAGE(A_27a,A_27b),V0f),V1s))),ap(c_2Epred__set_2ECARD(A_27a),V1s))) ) ) ) ).

tff(conj_thm_2Ecardinal_2ESURJECTIVE__IFF__INJECTIVE__GEN,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ! [V2f: $i] :
              ( mem(V2f,arr(A_27a,A_27b))
             => ( ( p(ap(c_2Epred__set_2EFINITE(A_27a),V0s))
                  & p(ap(c_2Epred__set_2EFINITE(A_27b),V1t))
                  & ( surj__ty_2Enum_2Enum(ap(c_2Epred__set_2ECARD(A_27a),V0s)) = surj__ty_2Enum_2Enum(ap(c_2Epred__set_2ECARD(A_27b),V1t)) )
                  & p(ap(ap(c_2Epred__set_2ESUBSET(A_27b),ap(ap(c_2Epred__set_2EIMAGE(A_27a,A_27b),V2f),V0s)),V1t)) )
               => ( ! [V3y: $i] :
                      ( mem(V3y,A_27b)
                     => ( p(ap(ap(c_2Ebool_2EIN(A_27b),V3y),V1t))
                       => ? [V4x: $i] :
                            ( mem(V4x,A_27a)
                            & p(ap(ap(c_2Ebool_2EIN(A_27a),V4x),V0s))
                            & ( ap(V2f,V4x) = V3y ) ) ) )
                <=> ! [V5x: $i] :
                      ( mem(V5x,A_27a)
                     => ! [V6y: $i] :
                          ( mem(V6y,A_27a)
                         => ( ( p(ap(ap(c_2Ebool_2EIN(A_27a),V5x),V0s))
                              & p(ap(ap(c_2Ebool_2EIN(A_27a),V6y),V0s))
                              & ( ap(V2f,V5x) = ap(V2f,V6y) ) )
                           => ( V5x = V6y ) ) ) ) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ESURJECTIVE__IFF__INJECTIVE,axiom,
    ! [A_27a: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1f: $i] :
          ( mem(V1f,arr(A_27a,A_27a))
         => ( ( p(ap(c_2Epred__set_2EFINITE(A_27a),V0s))
              & p(ap(ap(c_2Epred__set_2ESUBSET(A_27a),ap(ap(c_2Epred__set_2EIMAGE(A_27a,A_27a),V1f),V0s)),V0s)) )
           => ( ! [V2y: $i] :
                  ( mem(V2y,A_27a)
                 => ( p(ap(ap(c_2Ebool_2EIN(A_27a),V2y),V0s))
                   => ? [V3x: $i] :
                        ( mem(V3x,A_27a)
                        & p(ap(ap(c_2Ebool_2EIN(A_27a),V3x),V0s))
                        & ( ap(V1f,V3x) = V2y ) ) ) )
            <=> ! [V4x: $i] :
                  ( mem(V4x,A_27a)
                 => ! [V5y: $i] :
                      ( mem(V5y,A_27a)
                     => ( ( p(ap(ap(c_2Ebool_2EIN(A_27a),V4x),V0s))
                          & p(ap(ap(c_2Ebool_2EIN(A_27a),V5y),V0s))
                          & ( ap(V1f,V4x) = ap(V1f,V5y) ) )
                       => ( V4x = V5y ) ) ) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARD__EQ__BIJECTION,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ( ( p(ap(c_2Epred__set_2EFINITE(A_27a),V0s))
              & p(ap(c_2Epred__set_2EFINITE(A_27b),V1t))
              & ( surj__ty_2Enum_2Enum(ap(c_2Epred__set_2ECARD(A_27a),V0s)) = surj__ty_2Enum_2Enum(ap(c_2Epred__set_2ECARD(A_27b),V1t)) ) )
           => ? [V2f: $i] :
                ( mem(V2f,arr(A_27a,A_27b))
                & ! [V3x: $i] :
                    ( mem(V3x,A_27a)
                   => ( p(ap(ap(c_2Ebool_2EIN(A_27a),V3x),V0s))
                     => p(ap(ap(c_2Ebool_2EIN(A_27b),ap(V2f,V3x)),V1t)) ) )
                & ! [V4y: $i] :
                    ( mem(V4y,A_27b)
                   => ( p(ap(ap(c_2Ebool_2EIN(A_27b),V4y),V1t))
                     => ? [V5x: $i] :
                          ( mem(V5x,A_27a)
                          & p(ap(ap(c_2Ebool_2EIN(A_27a),V5x),V0s))
                          & ( ap(V2f,V5x) = V4y ) ) ) )
                & ! [V6x: $i] :
                    ( mem(V6x,A_27a)
                   => ! [V7y: $i] :
                        ( mem(V7y,A_27a)
                       => ( ( p(ap(ap(c_2Ebool_2EIN(A_27a),V6x),V0s))
                            & p(ap(ap(c_2Ebool_2EIN(A_27a),V7y),V0s))
                            & ( ap(V2f,V6x) = ap(V2f,V7y) ) )
                         => ( V6x = V7y ) ) ) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARD__EQ__BIJECTIONS,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ( ( p(ap(c_2Epred__set_2EFINITE(A_27a),V0s))
              & p(ap(c_2Epred__set_2EFINITE(A_27b),V1t))
              & ( surj__ty_2Enum_2Enum(ap(c_2Epred__set_2ECARD(A_27a),V0s)) = surj__ty_2Enum_2Enum(ap(c_2Epred__set_2ECARD(A_27b),V1t)) ) )
           => ? [V2f: $i] :
                ( mem(V2f,arr(A_27a,A_27b))
                & ? [V3g: $i] :
                    ( mem(V3g,arr(A_27b,A_27a))
                    & ! [V4x: $i] :
                        ( mem(V4x,A_27a)
                       => ( p(ap(ap(c_2Ebool_2EIN(A_27a),V4x),V0s))
                         => ( p(ap(ap(c_2Ebool_2EIN(A_27b),ap(V2f,V4x)),V1t))
                            & ( ap(V3g,ap(V2f,V4x)) = V4x ) ) ) )
                    & ! [V5y: $i] :
                        ( mem(V5y,A_27b)
                       => ( p(ap(ap(c_2Ebool_2EIN(A_27b),V5y),V1t))
                         => ( p(ap(ap(c_2Ebool_2EIN(A_27a),ap(V3g,V5y)),V0s))
                            & ( ap(V2f,ap(V3g,V5y)) = V5y ) ) ) ) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ESING__SUBSET,axiom,
    ! [A_27a: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1x: $i] :
          ( mem(V1x,A_27a)
         => ( p(ap(ap(c_2Epred__set_2ESUBSET(A_27a),ap(ap(c_2Epred__set_2EINSERT(A_27a),V1x),c_2Epred__set_2EEMPTY(A_27a))),V0s))
          <=> p(ap(ap(c_2Ebool_2EIN(A_27a),V1x),V0s)) ) ) ) ).

tff(conj_thm_2Ecardinal_2EINJECTIVE__ON__IMAGE,axiom,
    ! [A_27a: del,A_27b: del,V0f: $i] :
      ( mem(V0f,arr(A_27a,A_27b))
     => ! [V1u: $i] :
          ( mem(V1u,arr(A_27a,bool))
         => ( ! [V2s: $i] :
                ( mem(V2s,arr(A_27a,bool))
               => ! [V3t: $i] :
                    ( mem(V3t,arr(A_27a,bool))
                   => ( ( p(ap(ap(c_2Epred__set_2ESUBSET(A_27a),V2s),V1u))
                        & p(ap(ap(c_2Epred__set_2ESUBSET(A_27a),V3t),V1u))
                        & ( ap(ap(c_2Epred__set_2EIMAGE(A_27a,A_27b),V0f),V2s) = ap(ap(c_2Epred__set_2EIMAGE(A_27a,A_27b),V0f),V3t) ) )
                     => ( V2s = V3t ) ) ) )
          <=> ! [V4x: $i] :
                ( mem(V4x,A_27a)
               => ! [V5y: $i] :
                    ( mem(V5y,A_27a)
                   => ( ( p(ap(ap(c_2Ebool_2EIN(A_27a),V4x),V1u))
                        & p(ap(ap(c_2Ebool_2EIN(A_27a),V5y),V1u))
                        & ( ap(V0f,V4x) = ap(V0f,V5y) ) )
                     => ( V4x = V5y ) ) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2EINJECTIVE__IMAGE,axiom,
    ! [A_27a: del,A_27b: del,V0f: $i] :
      ( mem(V0f,arr(A_27a,A_27b))
     => ( ! [V1s: $i] :
            ( mem(V1s,arr(A_27a,bool))
           => ! [V2t: $i] :
                ( mem(V2t,arr(A_27a,bool))
               => ( ( ap(ap(c_2Epred__set_2EIMAGE(A_27a,A_27b),V0f),V1s) = ap(ap(c_2Epred__set_2EIMAGE(A_27a,A_27b),V0f),V2t) )
                 => ( V1s = V2t ) ) ) )
      <=> ! [V3x: $i] :
            ( mem(V3x,A_27a)
           => ! [V4y: $i] :
                ( mem(V4y,A_27a)
               => ( ( ap(V0f,V3x) = ap(V0f,V4y) )
                 => ( V3x = V4y ) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2EFINITE__FINITE__BIGUNION,axiom,
    ! [A_27a: del,V0s: $i] :
      ( mem(V0s,arr(arr(A_27a,bool),bool))
     => ( p(ap(c_2Epred__set_2EFINITE(arr(A_27a,bool)),V0s))
       => ( p(ap(c_2Epred__set_2EFINITE(A_27a),ap(c_2Epred__set_2EBIGUNION(A_27a),V0s)))
        <=> ! [V1t: $i] :
              ( mem(V1t,arr(A_27a,bool))
             => ( p(ap(ap(c_2Ebool_2EIN(arr(A_27a,bool)),V1t),V0s))
               => p(ap(c_2Epred__set_2EFINITE(A_27a),V1t)) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2Enum__FINITE,axiom,
    ! [V0s: $i] :
      ( mem(V0s,arr(ty_2Enum_2Enum,bool))
     => ( p(ap(c_2Epred__set_2EFINITE(ty_2Enum_2Enum),V0s))
      <=> ? [V1a: tp__ty_2Enum_2Enum] :
          ! [V2x: tp__ty_2Enum_2Enum] :
            ( p(ap(ap(c_2Ebool_2EIN(ty_2Enum_2Enum),inj__ty_2Enum_2Enum(V2x)),V0s))
           => p(ap(ap(c_2Earithmetic_2E_3C_3D,inj__ty_2Enum_2Enum(V2x)),inj__ty_2Enum_2Enum(V1a))) ) ) ) ).

tff(conj_thm_2Ecardinal_2Enum__FINITE__AVOID,axiom,
    ! [V0s: $i] :
      ( mem(V0s,arr(ty_2Enum_2Enum,bool))
     => ( p(ap(c_2Epred__set_2EFINITE(ty_2Enum_2Enum),V0s))
       => ? [V1a: tp__ty_2Enum_2Enum] : ~ p(ap(ap(c_2Ebool_2EIN(ty_2Enum_2Enum),inj__ty_2Enum_2Enum(V1a)),V0s)) ) ) ).

tff(conj_thm_2Ecardinal_2Enum__INFINITE,axiom,
    ~ p(ap(c_2Epred__set_2EFINITE(ty_2Enum_2Enum),c_2Epred__set_2EUNIV(ty_2Enum_2Enum))) ).

tff(ax_thm_2Ecardinal_2EHAS__SIZE,axiom,
    ! [A_27a: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1n: tp__ty_2Enum_2Enum] :
          ( p(ap(ap(c_2Ecardinal_2EHAS__SIZE(A_27a),V0s),inj__ty_2Enum_2Enum(V1n)))
        <=> ( p(ap(c_2Epred__set_2EFINITE(A_27a),V0s))
            & ( surj__ty_2Enum_2Enum(ap(c_2Epred__set_2ECARD(A_27a),V0s)) = V1n ) ) ) ) ).

tff(conj_thm_2Ecardinal_2EHAS__SIZE__CARD,axiom,
    ! [A_27a: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1n: tp__ty_2Enum_2Enum] :
          ( p(ap(ap(c_2Ecardinal_2EHAS__SIZE(A_27a),V0s),inj__ty_2Enum_2Enum(V1n)))
         => ( surj__ty_2Enum_2Enum(ap(c_2Epred__set_2ECARD(A_27a),V0s)) = V1n ) ) ) ).

tff(conj_thm_2Ecardinal_2EHAS__SIZE__0,axiom,
    ! [A_27a: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ( p(ap(ap(c_2Ecardinal_2EHAS__SIZE(A_27a),V0s),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))
      <=> ( V0s = c_2Epred__set_2EEMPTY(A_27a) ) ) ) ).

tff(conj_thm_2Ecardinal_2EHAS__SIZE__SUC,axiom,
    ! [A_27a: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1n: tp__ty_2Enum_2Enum] :
          ( p(ap(ap(c_2Ecardinal_2EHAS__SIZE(A_27a),V0s),ap(c_2Enum_2ESUC,inj__ty_2Enum_2Enum(V1n))))
        <=> ( ( V0s != c_2Epred__set_2EEMPTY(A_27a) )
            & ! [V2a: $i] :
                ( mem(V2a,A_27a)
               => ( p(ap(ap(c_2Ebool_2EIN(A_27a),V2a),V0s))
                 => p(ap(ap(c_2Ecardinal_2EHAS__SIZE(A_27a),ap(ap(c_2Epred__set_2EDELETE(A_27a),V0s),V2a)),inj__ty_2Enum_2Enum(V1n))) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2EFINITE__HAS__SIZE,axiom,
    ! [A_27a: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ( p(ap(c_2Epred__set_2EFINITE(A_27a),V0s))
      <=> p(ap(ap(c_2Ecardinal_2EHAS__SIZE(A_27a),V0s),ap(c_2Epred__set_2ECARD(A_27a),V0s))) ) ) ).

tff(conj_thm_2Ecardinal_2EHAS__SIZE__CLAUSES,axiom,
    ! [A_27a: del,V0n: tp__ty_2Enum_2Enum,V1s: $i] :
      ( mem(V1s,arr(A_27a,bool))
     => ( ( p(ap(ap(c_2Ecardinal_2EHAS__SIZE(A_27a),V1s),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))
        <=> ( V1s = c_2Epred__set_2EEMPTY(A_27a) ) )
        & ( p(ap(ap(c_2Ecardinal_2EHAS__SIZE(A_27a),V1s),ap(c_2Enum_2ESUC,inj__ty_2Enum_2Enum(V0n))))
        <=> ? [V2a: $i] :
              ( mem(V2a,A_27a)
              & ? [V3t: $i] :
                  ( mem(V3t,arr(A_27a,bool))
                  & p(ap(ap(c_2Ecardinal_2EHAS__SIZE(A_27a),V3t),inj__ty_2Enum_2Enum(V0n)))
                  & ~ p(ap(ap(c_2Ebool_2EIN(A_27a),V2a),V3t))
                  & ( V1s = ap(ap(c_2Epred__set_2EINSERT(A_27a),V2a),V3t) ) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARD__SUBSET__EQ,axiom,
    ! [A_27a: del,V0a: $i] :
      ( mem(V0a,arr(A_27a,bool))
     => ! [V1b: $i] :
          ( mem(V1b,arr(A_27a,bool))
         => ( ( p(ap(c_2Epred__set_2EFINITE(A_27a),V1b))
              & p(ap(ap(c_2Epred__set_2ESUBSET(A_27a),V0a),V1b))
              & ( surj__ty_2Enum_2Enum(ap(c_2Epred__set_2ECARD(A_27a),V0a)) = surj__ty_2Enum_2Enum(ap(c_2Epred__set_2ECARD(A_27a),V1b)) ) )
           => ( V0a = V1b ) ) ) ) ).

tff(lamtp_f1872,type,
    f1872: ( del * $i * $i * tp__ty_2Enum_2Enum ) > $i ).

tff(lameq_f1872,axiom,
    ! [A_27a: del,V4x: $i] :
      ( mem(V4x,A_27a)
     => ! [V2f: $i] :
          ( mem(V2f,arr(ty_2Enum_2Enum,A_27a))
         => ! [V1n: tp__ty_2Enum_2Enum,V5m: tp__ty_2Enum_2Enum] : ( ap(f1872(A_27a,V4x,V2f,V1n),inj__ty_2Enum_2Enum(V5m)) = ap(ap(c_2Ebool_2E_2F_5C,ap(ap(c_2Eprim__rec_2E_3C,inj__ty_2Enum_2Enum(V5m)),inj__ty_2Enum_2Enum(V1n))),ap(ap(c_2Emin_2E_3D(A_27a),ap(V2f,inj__ty_2Enum_2Enum(V5m))),V4x)) ) ) ) ).

tff(conj_thm_2Ecardinal_2EHAS__SIZE__INDEX,axiom,
    ! [A_27a: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1n: tp__ty_2Enum_2Enum] :
          ( p(ap(ap(c_2Ecardinal_2EHAS__SIZE(A_27a),V0s),inj__ty_2Enum_2Enum(V1n)))
         => ? [V2f: $i] :
              ( mem(V2f,arr(ty_2Enum_2Enum,A_27a))
              & ! [V3m: tp__ty_2Enum_2Enum] :
                  ( p(ap(ap(c_2Eprim__rec_2E_3C,inj__ty_2Enum_2Enum(V3m)),inj__ty_2Enum_2Enum(V1n)))
                 => p(ap(ap(c_2Ebool_2EIN(A_27a),ap(V2f,inj__ty_2Enum_2Enum(V3m))),V0s)) )
              & ! [V4x: $i] :
                  ( mem(V4x,A_27a)
                 => ( p(ap(ap(c_2Ebool_2EIN(A_27a),V4x),V0s))
                   => p(ap(c_2Ebool_2E_3F_21(ty_2Enum_2Enum),f1872(A_27a,V4x,V2f,V1n))) ) ) ) ) ) ).

tff(lamtp_f1873,type,
    f1873: ( del * del * $i * $i ) > $i ).

tff(lameq_f1873,axiom,
    ! [A_27b: del,A_27a: del,V1t: $i] :
      ( mem(V1t,arr(A_27a,arr(A_27b,bool)))
     => ! [V0s: $i] :
          ( mem(V0s,arr(A_27a,bool))
         => ! [V5x: $i] : ( ap(f1873(A_27b,A_27a,V1t,V0s),V5x) = ap(ap(c_2Epair_2E_2C(arr(A_27b,bool),bool),ap(V1t,V5x)),ap(ap(c_2Ebool_2EIN(A_27a),V5x),V0s)) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARD__BIGUNION__LE,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27a,arr(A_27b,bool)))
         => ! [V2m: tp__ty_2Enum_2Enum,V3n: tp__ty_2Enum_2Enum] :
              ( ( p(ap(ap(c_2Ecardinal_2EHAS__SIZE(A_27a),V0s),inj__ty_2Enum_2Enum(V2m)))
                & ! [V4x: $i] :
                    ( mem(V4x,A_27a)
                   => ( p(ap(ap(c_2Ebool_2EIN(A_27a),V4x),V0s))
                     => ( p(ap(c_2Epred__set_2EFINITE(A_27b),ap(V1t,V4x)))
                        & p(ap(ap(c_2Earithmetic_2E_3C_3D,ap(c_2Epred__set_2ECARD(A_27b),ap(V1t,V4x))),inj__ty_2Enum_2Enum(V3n))) ) ) ) )
             => p(ap(ap(c_2Earithmetic_2E_3C_3D,ap(c_2Epred__set_2ECARD(A_27b),ap(c_2Epred__set_2EBIGUNION(A_27b),ap(c_2Epred__set_2EGSPEC(arr(A_27b,bool),A_27a),f1873(A_27b,A_27a,V1t,V0s))))),ap(ap(c_2Earithmetic_2E_2A,inj__ty_2Enum_2Enum(V2m)),inj__ty_2Enum_2Enum(V3n)))) ) ) ) ).

tff(conj_thm_2Ecardinal_2EHAS__SIZE__BOOL,axiom,
    p(ap(ap(c_2Ecardinal_2EHAS__SIZE(bool),c_2Epred__set_2EUNIV(bool)),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))) ).

tff(conj_thm_2Ecardinal_2ECARD__BOOL,axiom,
    surj__ty_2Enum_2Enum(ap(c_2Epred__set_2ECARD(bool),c_2Epred__set_2EUNIV(bool))) = surj__ty_2Enum_2Enum(ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT2,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))) ).

tff(conj_thm_2Ecardinal_2EFINITE__BOOL,axiom,
    p(ap(c_2Epred__set_2EFINITE(bool),c_2Epred__set_2EUNIV(bool))) ).

tff(conj_thm_2Ecardinal_2EHAS__SIZE__CART__UNIV,axiom,
    ! [A_27a: del,V0m: tp__ty_2Enum_2Enum] :
      ( p(ap(ap(c_2Ecardinal_2EHAS__SIZE(A_27a),c_2Epred__set_2EUNIV(A_27a)),inj__ty_2Enum_2Enum(V0m)))
     => p(ap(ap(c_2Ecardinal_2EHAS__SIZE(A_27a),c_2Epred__set_2EUNIV(A_27a)),ap(ap(c_2Earithmetic_2EEXP,inj__ty_2Enum_2Enum(V0m)),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))))) ) ).

tff(conj_thm_2Ecardinal_2ECARD__CART__UNIV,axiom,
    ! [A_27a: del] :
      ( p(ap(c_2Epred__set_2EFINITE(A_27a),c_2Epred__set_2EUNIV(A_27a)))
     => ( surj__ty_2Enum_2Enum(ap(c_2Epred__set_2ECARD(A_27a),c_2Epred__set_2EUNIV(A_27a))) = surj__ty_2Enum_2Enum(ap(ap(c_2Earithmetic_2EEXP,ap(c_2Epred__set_2ECARD(A_27a),c_2Epred__set_2EUNIV(A_27a))),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO))))) ) ) ).

tff(conj_thm_2Ecardinal_2EFINITE__CART__UNIV,axiom,
    ! [A_27a: del] :
      ( p(ap(c_2Epred__set_2EFINITE(A_27a),c_2Epred__set_2EUNIV(A_27a)))
     => p(ap(c_2Epred__set_2EFINITE(A_27a),c_2Epred__set_2EUNIV(A_27a))) ) ).

tff(conj_thm_2Ecardinal_2EHAS__SIZE__NUMSEG__LT,axiom,
    ! [V0n: tp__ty_2Enum_2Enum] : p(ap(ap(c_2Ecardinal_2EHAS__SIZE(ty_2Enum_2Enum),ap(c_2Epred__set_2EGSPEC(ty_2Enum_2Enum,ty_2Enum_2Enum),f275(V0n))),inj__ty_2Enum_2Enum(V0n))) ).

tff(conj_thm_2Ecardinal_2EFINITE__NUMSEG__LT,axiom,
    ! [V0n: tp__ty_2Enum_2Enum] : p(ap(c_2Epred__set_2EFINITE(ty_2Enum_2Enum),ap(c_2Epred__set_2EGSPEC(ty_2Enum_2Enum,ty_2Enum_2Enum),f275(V0n)))) ).

tff(lamtp_f1874,type,
    f1874: tp__ty_2Enum_2Enum > $i ).

tff(lameq_f1874,axiom,
    ! [V0n: tp__ty_2Enum_2Enum,V1m: tp__ty_2Enum_2Enum] : ( ap(f1874(V0n),inj__ty_2Enum_2Enum(V1m)) = ap(ap(c_2Epair_2E_2C(ty_2Enum_2Enum,bool),inj__ty_2Enum_2Enum(V1m)),ap(ap(c_2Earithmetic_2E_3C_3D,inj__ty_2Enum_2Enum(V1m)),inj__ty_2Enum_2Enum(V0n))) ) ).

tff(conj_thm_2Ecardinal_2EHAS__SIZE__NUMSEG__LE,axiom,
    ! [V0n: tp__ty_2Enum_2Enum] : p(ap(ap(c_2Ecardinal_2EHAS__SIZE(ty_2Enum_2Enum),ap(c_2Epred__set_2EGSPEC(ty_2Enum_2Enum,ty_2Enum_2Enum),f1874(V0n))),ap(ap(c_2Earithmetic_2E_2B,inj__ty_2Enum_2Enum(V0n)),ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))))) ).

tff(conj_thm_2Ecardinal_2EFINITE__NUMSEG__LE,axiom,
    ! [V0n: tp__ty_2Enum_2Enum] : p(ap(c_2Epred__set_2EFINITE(ty_2Enum_2Enum),ap(c_2Epred__set_2EGSPEC(ty_2Enum_2Enum,ty_2Enum_2Enum),f1874(V0n)))) ).

tff(conj_thm_2Ecardinal_2EINFINITE__DIFF__FINITE,axiom,
    ! [A_27a: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27a,bool))
         => ( ( ~ p(ap(c_2Epred__set_2EFINITE(A_27a),V0s))
              & p(ap(c_2Epred__set_2EFINITE(A_27a),V1t)) )
           => ~ p(ap(c_2Epred__set_2EFINITE(A_27a),ap(ap(c_2Epred__set_2EDIFF(A_27a),V0s),V1t))) ) ) ) ).

tff(conj_thm_2Ecardinal_2ELE__CASES,axiom,
    ! [V0m: tp__ty_2Enum_2Enum,V1n: tp__ty_2Enum_2Enum] :
      ( p(ap(ap(c_2Earithmetic_2E_3C_3D,inj__ty_2Enum_2Enum(V0m)),inj__ty_2Enum_2Enum(V1n)))
      | p(ap(ap(c_2Earithmetic_2E_3C_3D,inj__ty_2Enum_2Enum(V1n)),inj__ty_2Enum_2Enum(V0m))) ) ).

tff(conj_thm_2Ecardinal_2ELT__CASES,axiom,
    ! [V0m: tp__ty_2Enum_2Enum,V1n: tp__ty_2Enum_2Enum] :
      ( p(ap(ap(c_2Eprim__rec_2E_3C,inj__ty_2Enum_2Enum(V0m)),inj__ty_2Enum_2Enum(V1n)))
      | p(ap(ap(c_2Eprim__rec_2E_3C,inj__ty_2Enum_2Enum(V1n)),inj__ty_2Enum_2Enum(V0m)))
      | ( V0m = V1n ) ) ).

tff(conj_thm_2Ecardinal_2ELT,axiom,
    ( ! [V0m: tp__ty_2Enum_2Enum] :
        ( p(ap(ap(c_2Eprim__rec_2E_3C,inj__ty_2Enum_2Enum(V0m)),inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)))
      <=> $false )
    & ! [V1m: tp__ty_2Enum_2Enum,V2n: tp__ty_2Enum_2Enum] :
        ( p(ap(ap(c_2Eprim__rec_2E_3C,inj__ty_2Enum_2Enum(V1m)),ap(c_2Enum_2ESUC,inj__ty_2Enum_2Enum(V2n))))
      <=> ( ( V1m = V2n )
          | p(ap(ap(c_2Eprim__rec_2E_3C,inj__ty_2Enum_2Enum(V1m)),inj__ty_2Enum_2Enum(V2n))) ) ) ) ).

tff(conj_thm_2Ecardinal_2ELT__LE,axiom,
    ! [V0m: tp__ty_2Enum_2Enum,V1n: tp__ty_2Enum_2Enum] :
      ( p(ap(ap(c_2Eprim__rec_2E_3C,inj__ty_2Enum_2Enum(V0m)),inj__ty_2Enum_2Enum(V1n)))
    <=> ( p(ap(ap(c_2Earithmetic_2E_3C_3D,inj__ty_2Enum_2Enum(V0m)),inj__ty_2Enum_2Enum(V1n)))
        & ( V0m != V1n ) ) ) ).

tff(conj_thm_2Ecardinal_2EGE,axiom,
    ! [V0n: tp__ty_2Enum_2Enum,V1m: tp__ty_2Enum_2Enum] :
      ( p(ap(ap(c_2Earithmetic_2E_3E_3D,inj__ty_2Enum_2Enum(V1m)),inj__ty_2Enum_2Enum(V0n)))
    <=> p(ap(ap(c_2Earithmetic_2E_3C_3D,inj__ty_2Enum_2Enum(V0n)),inj__ty_2Enum_2Enum(V1m))) ) ).

tff(conj_thm_2Ecardinal_2ELE__SUC__LT,axiom,
    ! [V0m: tp__ty_2Enum_2Enum,V1n: tp__ty_2Enum_2Enum] :
      ( p(ap(ap(c_2Earithmetic_2E_3C_3D,ap(c_2Enum_2ESUC,inj__ty_2Enum_2Enum(V0m))),inj__ty_2Enum_2Enum(V1n)))
    <=> p(ap(ap(c_2Eprim__rec_2E_3C,inj__ty_2Enum_2Enum(V0m)),inj__ty_2Enum_2Enum(V1n))) ) ).

tff(conj_thm_2Ecardinal_2EINJECTIVE__ON__LEFT__INVERSE,axiom,
    ! [A_27a: del,A_27b: del,V0f: $i] :
      ( mem(V0f,arr(A_27a,A_27b))
     => ! [V1s: $i] :
          ( mem(V1s,arr(A_27a,bool))
         => ( ! [V2x: $i] :
                ( mem(V2x,A_27a)
               => ! [V3y: $i] :
                    ( mem(V3y,A_27a)
                   => ( ( p(ap(ap(c_2Ebool_2EIN(A_27a),V2x),V1s))
                        & p(ap(ap(c_2Ebool_2EIN(A_27a),V3y),V1s))
                        & ( ap(V0f,V2x) = ap(V0f,V3y) ) )
                     => ( V2x = V3y ) ) ) )
          <=> ? [V4g: $i] :
                ( mem(V4g,arr(A_27b,A_27a))
                & ! [V5x: $i] :
                    ( mem(V5x,A_27a)
                   => ( p(ap(ap(c_2Ebool_2EIN(A_27a),V5x),V1s))
                     => ( ap(V4g,ap(V0f,V5x)) = V5x ) ) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2EINJECTIVE__LEFT__INVERSE,axiom,
    ! [A_27a: del,A_27b: del,V0f: $i] :
      ( mem(V0f,arr(A_27a,A_27b))
     => ( ! [V1x: $i] :
            ( mem(V1x,A_27a)
           => ! [V2y: $i] :
                ( mem(V2y,A_27a)
               => ( ( ap(V0f,V1x) = ap(V0f,V2y) )
                 => ( V1x = V2y ) ) ) )
      <=> ? [V3g: $i] :
            ( mem(V3g,arr(A_27b,A_27a))
            & ! [V4x: $i] :
                ( mem(V4x,A_27a)
               => ( ap(V3g,ap(V0f,V4x)) = V4x ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2EINTER__ACI,axiom,
    ! [A_27a: del,V0r: $i] :
      ( mem(V0r,arr(A_27a,bool))
     => ! [V1p: $i] :
          ( mem(V1p,arr(A_27a,bool))
         => ! [V2q: $i] :
              ( mem(V2q,arr(A_27a,bool))
             => ( ( ap(ap(c_2Epred__set_2EINTER(A_27a),V1p),V2q) = ap(ap(c_2Epred__set_2EINTER(A_27a),V2q),V1p) )
                & ( ap(ap(c_2Epred__set_2EINTER(A_27a),ap(ap(c_2Epred__set_2EINTER(A_27a),V1p),V2q)),V0r) = ap(ap(c_2Epred__set_2EINTER(A_27a),ap(ap(c_2Epred__set_2EINTER(A_27a),V1p),V2q)),V0r) )
                & ( ap(ap(c_2Epred__set_2EINTER(A_27a),ap(ap(c_2Epred__set_2EINTER(A_27a),V1p),V2q)),V0r) = ap(ap(c_2Epred__set_2EINTER(A_27a),ap(ap(c_2Epred__set_2EINTER(A_27a),V2q),V1p)),V0r) )
                & ( ap(ap(c_2Epred__set_2EINTER(A_27a),V1p),V1p) = V1p )
                & ( ap(ap(c_2Epred__set_2EINTER(A_27a),ap(ap(c_2Epred__set_2EINTER(A_27a),V1p),V1p)),V2q) = ap(ap(c_2Epred__set_2EINTER(A_27a),V1p),V2q) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECONJ__ACI,axiom,
    ! [V0r: tp__o,V1p: tp__o,V2q: tp__o] :
      ( ( ( p(inj__o(V1p))
          & p(inj__o(V2q)) )
      <=> ( p(inj__o(V2q))
          & p(inj__o(V1p)) ) )
      & ( ( p(inj__o(V1p))
          & p(inj__o(V2q))
          & p(inj__o(V0r)) )
      <=> ( p(inj__o(V1p))
          & p(inj__o(V2q))
          & p(inj__o(V0r)) ) )
      & ( ( p(inj__o(V1p))
          & p(inj__o(V2q))
          & p(inj__o(V0r)) )
      <=> ( p(inj__o(V2q))
          & p(inj__o(V1p))
          & p(inj__o(V0r)) ) )
      & ( ( p(inj__o(V1p))
          & p(inj__o(V1p)) )
      <=> p(inj__o(V1p)) )
      & ( ( p(inj__o(V1p))
          & p(inj__o(V1p))
          & p(inj__o(V2q)) )
      <=> ( p(inj__o(V1p))
          & p(inj__o(V2q)) ) ) ) ).

tff(conj_thm_2Ecardinal_2EUNION__ACI,axiom,
    ! [A_27a: del,V0r: $i] :
      ( mem(V0r,arr(A_27a,bool))
     => ! [V1p: $i] :
          ( mem(V1p,arr(A_27a,bool))
         => ! [V2q: $i] :
              ( mem(V2q,arr(A_27a,bool))
             => ( ( ap(ap(c_2Epred__set_2EUNION(A_27a),V1p),V2q) = ap(ap(c_2Epred__set_2EUNION(A_27a),V2q),V1p) )
                & ( ap(ap(c_2Epred__set_2EUNION(A_27a),ap(ap(c_2Epred__set_2EUNION(A_27a),V1p),V2q)),V0r) = ap(ap(c_2Epred__set_2EUNION(A_27a),ap(ap(c_2Epred__set_2EUNION(A_27a),V1p),V2q)),V0r) )
                & ( ap(ap(c_2Epred__set_2EUNION(A_27a),ap(ap(c_2Epred__set_2EUNION(A_27a),V1p),V2q)),V0r) = ap(ap(c_2Epred__set_2EUNION(A_27a),ap(ap(c_2Epred__set_2EUNION(A_27a),V2q),V1p)),V0r) )
                & ( ap(ap(c_2Epred__set_2EUNION(A_27a),V1p),V1p) = V1p )
                & ( ap(ap(c_2Epred__set_2EUNION(A_27a),ap(ap(c_2Epred__set_2EUNION(A_27a),V1p),V1p)),V2q) = ap(ap(c_2Epred__set_2EUNION(A_27a),V1p),V2q) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ELT__NZ,axiom,
    ! [V0n: tp__ty_2Enum_2Enum] :
      ( p(ap(ap(c_2Eprim__rec_2E_3C,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)),inj__ty_2Enum_2Enum(V0n)))
    <=> ( V0n != fo__c_2Enum_2E0 ) ) ).

tff(conj_thm_2Ecardinal_2ELE__1,axiom,
    ( ! [V0n: tp__ty_2Enum_2Enum] :
        ( ( V0n != fo__c_2Enum_2E0 )
       => p(ap(ap(c_2Eprim__rec_2E_3C,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)),inj__ty_2Enum_2Enum(V0n))) )
    & ! [V1n: tp__ty_2Enum_2Enum] :
        ( ( V1n != fo__c_2Enum_2E0 )
       => p(ap(ap(c_2Earithmetic_2E_3C_3D,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))),inj__ty_2Enum_2Enum(V1n))) )
    & ! [V2n: tp__ty_2Enum_2Enum] :
        ( p(ap(ap(c_2Eprim__rec_2E_3C,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)),inj__ty_2Enum_2Enum(V2n)))
       => ( V2n != fo__c_2Enum_2E0 ) )
    & ! [V3n: tp__ty_2Enum_2Enum] :
        ( p(ap(ap(c_2Eprim__rec_2E_3C,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)),inj__ty_2Enum_2Enum(V3n)))
       => p(ap(ap(c_2Earithmetic_2E_3C_3D,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))),inj__ty_2Enum_2Enum(V3n))) )
    & ! [V4n: tp__ty_2Enum_2Enum] :
        ( p(ap(ap(c_2Earithmetic_2E_3C_3D,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))),inj__ty_2Enum_2Enum(V4n)))
       => p(ap(ap(c_2Eprim__rec_2E_3C,inj__ty_2Enum_2Enum(fo__c_2Enum_2E0)),inj__ty_2Enum_2Enum(V4n))) )
    & ! [V5n: tp__ty_2Enum_2Enum] :
        ( p(ap(ap(c_2Earithmetic_2E_3C_3D,ap(c_2Earithmetic_2ENUMERAL,ap(c_2Earithmetic_2EBIT1,inj__ty_2Enum_2Enum(fo__c_2Earithmetic_2EZERO)))),inj__ty_2Enum_2Enum(V5n)))
       => ( V5n != fo__c_2Enum_2E0 ) ) ) ).

tff(conj_thm_2Ecardinal_2EOR__EXISTS__THM,axiom,
    ! [A_27a: del,V0P: $i] :
      ( mem(V0P,arr(A_27a,bool))
     => ! [V1Q: $i] :
          ( mem(V1Q,arr(A_27a,bool))
         => ( ( ? [V2x: $i] :
                  ( mem(V2x,A_27a)
                  & p(ap(V0P,V2x)) )
              | ? [V3x: $i] :
                  ( mem(V3x,A_27a)
                  & p(ap(V1Q,V3x)) ) )
          <=> ? [V4x: $i] :
                ( mem(V4x,A_27a)
                & ( p(ap(V0P,V4x))
                  | p(ap(V1Q,V4x)) ) ) ) ) ) ).

tff(lamtp_f1875,type,
    f1875: ( del * del * $i * $i * $i ) > $i ).

tff(lameq_f1875,axiom,
    ! [A_27b: del,A_27a: del,V4y: $i] :
      ( mem(V4y,A_27b)
     => ! [V0f: $i] :
          ( mem(V0f,arr(A_27a,A_27b))
         => ! [V1s: $i] :
              ( mem(V1s,arr(A_27a,bool))
             => ! [V5x: $i] : ( ap(f1875(A_27b,A_27a,V4y,V0f,V1s),V5x) = ap(ap(c_2Ebool_2E_2F_5C,ap(ap(c_2Ebool_2EIN(A_27a),V5x),V1s)),ap(ap(c_2Emin_2E_3D(A_27b),ap(V0f,V5x)),V4y)) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2EBIJECTIVE__INJECTIVE__SURJECTIVE,axiom,
    ! [A_27a: del,A_27b: del,V0f: $i] :
      ( mem(V0f,arr(A_27a,A_27b))
     => ! [V1s: $i] :
          ( mem(V1s,arr(A_27a,bool))
         => ! [V2t: $i] :
              ( mem(V2t,arr(A_27b,bool))
             => ( ( ! [V3x: $i] :
                      ( mem(V3x,A_27a)
                     => ( p(ap(ap(c_2Ebool_2EIN(A_27a),V3x),V1s))
                       => p(ap(ap(c_2Ebool_2EIN(A_27b),ap(V0f,V3x)),V2t)) ) )
                  & ! [V4y: $i] :
                      ( mem(V4y,A_27b)
                     => ( p(ap(ap(c_2Ebool_2EIN(A_27b),V4y),V2t))
                       => p(ap(c_2Ebool_2E_3F_21(A_27a),f1875(A_27b,A_27a,V4y,V0f,V1s))) ) ) )
              <=> ( ! [V6x: $i] :
                      ( mem(V6x,A_27a)
                     => ( p(ap(ap(c_2Ebool_2EIN(A_27a),V6x),V1s))
                       => p(ap(ap(c_2Ebool_2EIN(A_27b),ap(V0f,V6x)),V2t)) ) )
                  & ! [V7x: $i] :
                      ( mem(V7x,A_27a)
                     => ! [V8y: $i] :
                          ( mem(V8y,A_27a)
                         => ( ( p(ap(ap(c_2Ebool_2EIN(A_27a),V7x),V1s))
                              & p(ap(ap(c_2Ebool_2EIN(A_27a),V8y),V1s))
                              & ( ap(V0f,V7x) = ap(V0f,V8y) ) )
                           => ( V7x = V8y ) ) ) )
                  & ! [V9y: $i] :
                      ( mem(V9y,A_27b)
                     => ( p(ap(ap(c_2Ebool_2EIN(A_27b),V9y),V2t))
                       => ? [V10x: $i] :
                            ( mem(V10x,A_27a)
                            & p(ap(ap(c_2Ebool_2EIN(A_27a),V10x),V1s))
                            & ( ap(V0f,V10x) = V9y ) ) ) ) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2EBIJECTIVE__INVERSES,axiom,
    ! [A_27a: del,A_27b: del,V0f: $i] :
      ( mem(V0f,arr(A_27a,A_27b))
     => ! [V1s: $i] :
          ( mem(V1s,arr(A_27a,bool))
         => ! [V2t: $i] :
              ( mem(V2t,arr(A_27b,bool))
             => ( ( ! [V3x: $i] :
                      ( mem(V3x,A_27a)
                     => ( p(ap(ap(c_2Ebool_2EIN(A_27a),V3x),V1s))
                       => p(ap(ap(c_2Ebool_2EIN(A_27b),ap(V0f,V3x)),V2t)) ) )
                  & ! [V4y: $i] :
                      ( mem(V4y,A_27b)
                     => ( p(ap(ap(c_2Ebool_2EIN(A_27b),V4y),V2t))
                       => p(ap(c_2Ebool_2E_3F_21(A_27a),f1875(A_27b,A_27a,V4y,V0f,V1s))) ) ) )
              <=> ( ! [V6x: $i] :
                      ( mem(V6x,A_27a)
                     => ( p(ap(ap(c_2Ebool_2EIN(A_27a),V6x),V1s))
                       => p(ap(ap(c_2Ebool_2EIN(A_27b),ap(V0f,V6x)),V2t)) ) )
                  & ? [V7g: $i] :
                      ( mem(V7g,arr(A_27b,A_27a))
                      & ! [V8y: $i] :
                          ( mem(V8y,A_27b)
                         => ( p(ap(ap(c_2Ebool_2EIN(A_27b),V8y),V2t))
                           => p(ap(ap(c_2Ebool_2EIN(A_27a),ap(V7g,V8y)),V1s)) ) )
                      & ! [V9y: $i] :
                          ( mem(V9y,A_27b)
                         => ( p(ap(ap(c_2Ebool_2EIN(A_27b),V9y),V2t))
                           => ( ap(V0f,ap(V7g,V9y)) = V9y ) ) )
                      & ! [V10x: $i] :
                          ( mem(V10x,A_27a)
                         => ( p(ap(ap(c_2Ebool_2EIN(A_27a),V10x),V1s))
                           => ( ap(V7g,ap(V0f,V10x)) = V10x ) ) ) ) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2Ele__c,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ( p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0s),V1t))
          <=> ? [V2f: $i] :
                ( mem(V2f,arr(A_27a,A_27b))
                & ! [V3x: $i] :
                    ( mem(V3x,A_27a)
                   => ( p(ap(ap(c_2Ebool_2EIN(A_27a),V3x),V0s))
                     => p(ap(ap(c_2Ebool_2EIN(A_27b),ap(V2f,V3x)),V1t)) ) )
                & ! [V4x: $i] :
                    ( mem(V4x,A_27a)
                   => ! [V5y: $i] :
                        ( mem(V5y,A_27a)
                       => ( ( p(ap(ap(c_2Ebool_2EIN(A_27a),V4x),V0s))
                            & p(ap(ap(c_2Ebool_2EIN(A_27a),V5y),V0s))
                            & ( ap(V2f,V4x) = ap(V2f,V5y) ) )
                         => ( V4x = V5y ) ) ) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2Elt__c,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ( ~ p(ap(ap(c_2Ecardinal_2Ecardleq(A_27b,A_27a),V1t),V0s))
          <=> ( p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0s),V1t))
              & ~ p(ap(ap(c_2Ecardinal_2Ecardleq(A_27b,A_27a),V1t),V0s)) ) ) ) ) ).

tff(lamtp_f1876,type,
    f1876: ( del * del * $i * $i * $i ) > $i ).

tff(lameq_f1876,axiom,
    ! [A_27b: del,A_27a: del,V4y: $i] :
      ( mem(V4y,A_27b)
     => ! [V2f: $i] :
          ( mem(V2f,arr(A_27a,A_27b))
         => ! [V0s: $i] :
              ( mem(V0s,arr(A_27a,bool))
             => ! [V5x: $i] : ( ap(f1876(A_27b,A_27a,V4y,V2f,V0s),V5x) = ap(ap(c_2Ebool_2E_2F_5C,ap(ap(c_2Ebool_2EIN(A_27a),V5x),V0s)),ap(ap(c_2Emin_2E_3D(A_27b),ap(V2f,V5x)),V4y)) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2Eeq__c,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ( p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a,A_27b),V0s),V1t))
          <=> ? [V2f: $i] :
                ( mem(V2f,arr(A_27a,A_27b))
                & ! [V3x: $i] :
                    ( mem(V3x,A_27a)
                   => ( p(ap(ap(c_2Ebool_2EIN(A_27a),V3x),V0s))
                     => p(ap(ap(c_2Ebool_2EIN(A_27b),ap(V2f,V3x)),V1t)) ) )
                & ! [V4y: $i] :
                    ( mem(V4y,A_27b)
                   => ( p(ap(ap(c_2Ebool_2EIN(A_27b),V4y),V1t))
                     => p(ap(c_2Ebool_2E_3F_21(A_27a),f1876(A_27b,A_27a,V4y,V2f,V0s))) ) ) ) ) ) ) ).

tff(ax_thm_2Ecardinal_2Ecardgeq__def,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ( p(ap(ap(c_2Ecardinal_2Ecardgeq(A_27a,A_27b),V0s),V1t))
          <=> p(ap(ap(c_2Ecardinal_2Ecardleq(A_27b,A_27a),V1t),V0s)) ) ) ) ).

tff(conj_thm_2Ecardinal_2Ege__c,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ( p(ap(ap(c_2Ecardinal_2Ecardgeq(A_27a,A_27b),V0s),V1t))
          <=> p(ap(ap(c_2Ecardinal_2Ecardleq(A_27b,A_27a),V1t),V0s)) ) ) ) ).

tff(ax_thm_2Ecardinal_2Ecardgt__def,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ( p(ap(ap(c_2Ecardinal_2Ecardgt(A_27a,A_27b),V0s),V1t))
          <=> ~ p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0s),V1t)) ) ) ) ).

tff(conj_thm_2Ecardinal_2Egt__c,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ( p(ap(ap(c_2Ecardinal_2Ecardgt(A_27a,A_27b),V0s),V1t))
          <=> ~ p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0s),V1t)) ) ) ) ).

tff(conj_thm_2Ecardinal_2ELE__C,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ( p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0s),V1t))
          <=> ? [V2g: $i] :
                ( mem(V2g,arr(A_27b,A_27a))
                & ! [V3x: $i] :
                    ( mem(V3x,A_27a)
                   => ( p(ap(ap(c_2Ebool_2EIN(A_27a),V3x),V0s))
                     => ? [V4y: $i] :
                          ( mem(V4y,A_27b)
                          & p(ap(ap(c_2Ebool_2EIN(A_27b),V4y),V1t))
                          & ( ap(V2g,V4y) = V3x ) ) ) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2EGE__C,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ( p(ap(ap(c_2Ecardinal_2Ecardgeq(A_27a,A_27b),V0s),V1t))
          <=> ? [V2f: $i] :
                ( mem(V2f,arr(A_27a,A_27b))
                & ! [V3y: $i] :
                    ( mem(V3y,A_27b)
                   => ( p(ap(ap(c_2Ebool_2EIN(A_27b),V3y),V1t))
                     => ? [V4x: $i] :
                          ( mem(V4x,A_27a)
                          & p(ap(ap(c_2Ebool_2EIN(A_27a),V4x),V0s))
                          & ( V3y = ap(V2f,V4x) ) ) ) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECOUNTABLE,axiom,
    ! [A_27a: del,V0t: $i] :
      ( mem(V0t,arr(A_27a,bool))
     => ( p(ap(c_2Epred__set_2Ecountable(A_27a),V0t))
      <=> p(ap(ap(c_2Ecardinal_2Ecardgeq(ty_2Enum_2Enum,A_27a),c_2Epred__set_2EUNIV(ty_2Enum_2Enum)),V0t)) ) ) ).

tff(lamtp_f1877,type,
    f1877: ( del * del * $i * $i * $i ) > $i ).

tff(lameq_f1877,axiom,
    ! [A_27a: del,A_27b: del,V2R: $i] :
      ( mem(V2R,arr(ty_2Epair_2Eprod(A_27a,A_27b),bool))
     => ! [V5x: $i] :
          ( mem(V5x,A_27a)
         => ! [V1t: $i] :
              ( mem(V1t,arr(A_27b,bool))
             => ! [V6y: $i] : ( ap(f1877(A_27a,A_27b,V2R,V5x,V1t),V6y) = ap(ap(c_2Ebool_2E_2F_5C,ap(ap(c_2Ebool_2EIN(A_27b),V6y),V1t)),ap(V2R,ap(ap(c_2Epair_2E_2C(A_27a,A_27b),V5x),V6y))) ) ) ) ) ).

tff(lamtp_f1878,type,
    f1878: ( del * del * $i * $i * $i ) > $i ).

tff(lameq_f1878,axiom,
    ! [A_27b: del,A_27a: del,V2R: $i] :
      ( mem(V2R,arr(ty_2Epair_2Eprod(A_27a,A_27b),bool))
     => ! [V7y: $i] :
          ( mem(V7y,A_27b)
         => ! [V0s: $i] :
              ( mem(V0s,arr(A_27a,bool))
             => ! [V8x: $i] : ( ap(f1878(A_27b,A_27a,V2R,V7y,V0s),V8x) = ap(ap(c_2Ebool_2E_2F_5C,ap(ap(c_2Ebool_2EIN(A_27a),V8x),V0s)),ap(V2R,ap(ap(c_2Epair_2E_2C(A_27a,A_27b),V8x),V7y))) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2EEQ__C,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ( p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a,A_27b),V0s),V1t))
          <=> ? [V2R: $i] :
                ( mem(V2R,arr(ty_2Epair_2Eprod(A_27a,A_27b),bool))
                & ! [V3x: $i] :
                    ( mem(V3x,A_27a)
                   => ! [V4y: $i] :
                        ( mem(V4y,A_27b)
                       => ( p(ap(V2R,ap(ap(c_2Epair_2E_2C(A_27a,A_27b),V3x),V4y)))
                         => ( p(ap(ap(c_2Ebool_2EIN(A_27a),V3x),V0s))
                            & p(ap(ap(c_2Ebool_2EIN(A_27b),V4y),V1t)) ) ) ) )
                & ! [V5x: $i] :
                    ( mem(V5x,A_27a)
                   => ( p(ap(ap(c_2Ebool_2EIN(A_27a),V5x),V0s))
                     => p(ap(c_2Ebool_2E_3F_21(A_27b),f1877(A_27a,A_27b,V2R,V5x,V1t))) ) )
                & ! [V7y: $i] :
                    ( mem(V7y,A_27b)
                   => ( p(ap(ap(c_2Ebool_2EIN(A_27b),V7y),V1t))
                     => p(ap(c_2Ebool_2E_3F_21(A_27a),f1878(A_27b,A_27a,V2R,V7y,V0s))) ) ) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARD__LE__REFL,axiom,
    ! [A_27a: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27a),V0s),V0s)) ) ).

tff(conj_thm_2Ecardinal_2ECARD__LE__TRANS,axiom,
    ! [A_27a: del,A_27b: del,A_27c: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ! [V2u: $i] :
              ( mem(V2u,arr(A_27c,bool))
             => ( ( p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0s),V1t))
                  & p(ap(ap(c_2Ecardinal_2Ecardleq(A_27b,A_27c),V1t),V2u)) )
               => p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27c),V0s),V2u)) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARD__LT__REFL,axiom,
    ! [A_27a: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ~ ~ p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27a),V0s),V0s)) ) ).

tff(conj_thm_2Ecardinal_2ECARD__LET__TRANS,axiom,
    ! [A_27a: del,A_27b: del,A_27c: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ! [V2u: $i] :
              ( mem(V2u,arr(A_27c,bool))
             => ( ( p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0s),V1t))
                  & ~ p(ap(ap(c_2Ecardinal_2Ecardleq(A_27c,A_27b),V2u),V1t)) )
               => ~ p(ap(ap(c_2Ecardinal_2Ecardleq(A_27c,A_27a),V2u),V0s)) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARD__LTE__TRANS,axiom,
    ! [A_27a: del,A_27b: del,A_27c: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ! [V2u: $i] :
              ( mem(V2u,arr(A_27c,bool))
             => ( ( ~ p(ap(ap(c_2Ecardinal_2Ecardleq(A_27b,A_27a),V1t),V0s))
                  & p(ap(ap(c_2Ecardinal_2Ecardleq(A_27b,A_27c),V1t),V2u)) )
               => ~ p(ap(ap(c_2Ecardinal_2Ecardleq(A_27c,A_27a),V2u),V0s)) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARD__LT__TRANS,axiom,
    ! [A_27a: del,A_27b: del,A_27c: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ! [V2u: $i] :
              ( mem(V2u,arr(A_27c,bool))
             => ( ( ~ p(ap(ap(c_2Ecardinal_2Ecardleq(A_27b,A_27a),V1t),V0s))
                  & ~ p(ap(ap(c_2Ecardinal_2Ecardleq(A_27c,A_27b),V2u),V1t)) )
               => ~ p(ap(ap(c_2Ecardinal_2Ecardleq(A_27c,A_27a),V2u),V0s)) ) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARD__EQ__REFL,axiom,
    ! [A_27a: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a,A_27a),V0s),V0s)) ) ).

tff(conj_thm_2Ecardinal_2ECARD__EQ__SYM,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ( p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a,A_27b),V0s),V1t))
          <=> p(ap(ap(c_2Ecardinal_2Ecardeq(A_27b,A_27a),V1t),V0s)) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARD__EQ__IMP__LE,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ( p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a,A_27b),V0s),V1t))
           => p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0s),V1t)) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARD__LT__IMP__LE,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ( ~ p(ap(ap(c_2Ecardinal_2Ecardleq(A_27b,A_27a),V1t),V0s))
           => p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0s),V1t)) ) ) ) ).

tff(lamtp_f1879,type,
    f1879: ( del * del * $i * $i * $i ) > $i ).

tff(lameq_f1879,axiom,
    ! [A_27b: del,A_27a: del,V5y: $i] :
      ( mem(V5y,A_27b)
     => ! [V0R: $i] :
          ( mem(V0R,arr(A_27a,arr(A_27b,bool)))
         => ! [V1s: $i] :
              ( mem(V1s,arr(A_27a,bool))
             => ! [V6x: $i] : ( ap(f1879(A_27b,A_27a,V5y,V0R,V1s),V6x) = ap(ap(c_2Ebool_2E_2F_5C,ap(ap(c_2Ebool_2EIN(A_27a),V6x),V1s)),ap(ap(V0R,V6x),V5y)) ) ) ) ) ).

tff(lamtp_f1880,type,
    f1880: ( del * del * $i * $i ) > $i ).

tff(lameq_f1880,axiom,
    ! [A_27a: del,A_27b: del,V0R: $i] :
      ( mem(V0R,arr(A_27a,arr(A_27b,bool)))
     => ! [V1s: $i] :
          ( mem(V1s,arr(A_27a,bool))
         => ! [V5y: $i] : ( ap(f1880(A_27a,A_27b,V0R,V1s),V5y) = ap(ap(c_2Epair_2E_2C(A_27b,bool),V5y),ap(c_2Ebool_2E_3F(A_27a),f1879(A_27b,A_27a,V5y,V0R,V1s))) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARD__LE__RELATIONAL,axiom,
    ! [A_27a: del,A_27b: del,V0R: $i] :
      ( mem(V0R,arr(A_27a,arr(A_27b,bool)))
     => ! [V1s: $i] :
          ( mem(V1s,arr(A_27a,bool))
         => ( ! [V2x: $i] :
                ( mem(V2x,A_27a)
               => ! [V3y: $i] :
                    ( mem(V3y,A_27b)
                   => ! [V4y_27: $i] :
                        ( mem(V4y_27,A_27b)
                       => ( ( p(ap(ap(c_2Ebool_2EIN(A_27a),V2x),V1s))
                            & p(ap(ap(V0R,V2x),V3y))
                            & p(ap(ap(V0R,V2x),V4y_27)) )
                         => ( V3y = V4y_27 ) ) ) ) )
           => p(ap(ap(c_2Ecardinal_2Ecardleq(A_27b,A_27a),ap(c_2Epred__set_2EGSPEC(A_27b,A_27b),f1880(A_27a,A_27b,V0R,V1s))),V1s)) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARD__LE__EMPTY,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ( p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0s),c_2Epred__set_2EEMPTY(A_27b)))
      <=> ( V0s = c_2Epred__set_2EEMPTY(A_27a) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARD__EQ__EMPTY,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ( p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a,A_27b),V0s),c_2Epred__set_2EEMPTY(A_27b)))
      <=> ( V0s = c_2Epred__set_2EEMPTY(A_27a) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARD__LE__ANTISYM,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ( ( p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0s),V1t))
              & p(ap(ap(c_2Ecardinal_2Ecardleq(A_27b,A_27a),V1t),V0s)) )
          <=> p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a,A_27b),V0s),V1t)) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARD__LE__TOTAL,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ( p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0s),V1t))
            | p(ap(ap(c_2Ecardinal_2Ecardleq(A_27b,A_27a),V1t),V0s)) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARD__LET__TOTAL,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ( p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0s),V1t))
            | ~ p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0s),V1t)) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARD__LTE__TOTAL,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ( ~ p(ap(ap(c_2Ecardinal_2Ecardleq(A_27b,A_27a),V1t),V0s))
            | p(ap(ap(c_2Ecardinal_2Ecardleq(A_27b,A_27a),V1t),V0s)) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARD__LT__TOTAL,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ( p(ap(ap(c_2Ecardinal_2Ecardeq(A_27a,A_27b),V0s),V1t))
            | ~ p(ap(ap(c_2Ecardinal_2Ecardleq(A_27b,A_27a),V1t),V0s))
            | ~ p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0s),V1t)) ) ) ) ).

tff(conj_thm_2Ecardinal_2ECARD__NOT__LE,conjecture,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( mem(V0s,arr(A_27a,bool))
     => ! [V1t: $i] :
          ( mem(V1t,arr(A_27b,bool))
         => ( ~ p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0s),V1t))
          <=> ~ p(ap(ap(c_2Ecardinal_2Ecardleq(A_27a,A_27b),V0s),V1t)) ) ) ) ).

%------------------------------------------------------------------------------
