%------------------------------------------------------------------------------
% File     : ITP007_7 : TPTP v9.2.0. Bugfixed v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : HOL4 syntactic export of thm_2EpatternMatches_2EPMATCH__FLATTEN__FUN__PMATCH__ROW.p, chainy mode
% Version  : [BG+19] axioms.
% English  :

% Refs     : [BG+19] Brown et al. (2019), GRUNGE: A Grand Unified ATP Chall
%          : [Gau20] Gauthier (2020), Email to Geoff Sutcliffe
% Source   : [BG+19]
% Names    : thm_2EpatternMatches_2EPMATCH__FLATTEN__FUN__PMATCH__ROW.p [Gau20]
%          : HL403001_7.p [TPAP]

% Status   : Theorem
% Rating   : 1.00 v7.5.0
% Syntax   : Number of formulae    : 10719 (3716 unt;3647 typ;   0 def)
%            Number of atoms       : 18852 (9911 equ)
%            Maximal formula atoms :  912 (   1 avg)
%            Number of connectives : 12474 ( 694   ~; 471   |;4566   &)
%                                         (3311 <=>;3432  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  360 (   6 avg)
%            Maximal term depth    :   27 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  : 3049 (1775   >;1274   *;   0   +;   0  <<)
%            Number of predicates  :    2 (   1 usr;   0 prp; 1-2 aty)
%            Number of functors    : 1227 (1227 usr; 151 con; 0-7 aty)
%            Number of variables   : 42761 (26933   !;12518   ?;42761   :)
%                                         (3310  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments :
% Bugfixes : v7.5.0 - Bugfixes in axioms and export.
%------------------------------------------------------------------------------
include('Axioms/ITP001/ITP002_7.ax').
include('Axioms/ITP001/ITP003_7.ax').
include('Axioms/ITP001/ITP004_7.ax').
include('Axioms/ITP001/ITP005_7.ax').
include('Axioms/ITP001/ITP006_7.ax').
include('Axioms/ITP001/ITP007_7.ax').
include('Axioms/ITP001/ITP008_7.ax').
include('Axioms/ITP001/ITP009_7.ax').
include('Axioms/ITP001/ITP010_7.ax').
include('Axioms/ITP001/ITP011_7.ax').
include('Axioms/ITP001/ITP012_7.ax').
include('Axioms/ITP001/ITP013_7.ax').
include('Axioms/ITP001/ITP014_7.ax').
include('Axioms/ITP001/ITP015_7.ax').
include('Axioms/ITP001/ITP016_7.ax').
include('Axioms/ITP001/ITP017_7.ax').
include('Axioms/ITP001/ITP018_7.ax').
include('Axioms/ITP001/ITP019_7.ax').
include('Axioms/ITP001/ITP020_7.ax').
include('Axioms/ITP001/ITP021_7.ax').
include('Axioms/ITP001/ITP022_7.ax').
include('Axioms/ITP001/ITP023_7.ax').
include('Axioms/ITP001/ITP024_7.ax').
include('Axioms/ITP001/ITP025_7.ax').
include('Axioms/ITP001/ITP026_7.ax').
include('Axioms/ITP001/ITP027_7.ax').
include('Axioms/ITP001/ITP028_7.ax').
include('Axioms/ITP001/ITP029_7.ax').
include('Axioms/ITP001/ITP030_7.ax').
include('Axioms/ITP001/ITP031_7.ax').
include('Axioms/ITP001/ITP032_7.ax').
include('Axioms/ITP001/ITP033_7.ax').
include('Axioms/ITP001/ITP034_7.ax').
include('Axioms/ITP001/ITP035_7.ax').
include('Axioms/ITP001/ITP036_7.ax').
include('Axioms/ITP001/ITP037_7.ax').
include('Axioms/ITP001/ITP038_7.ax').
include('Axioms/ITP001/ITP039_7.ax').
include('Axioms/ITP001/ITP040_7.ax').
include('Axioms/ITP001/ITP041_7.ax').
%------------------------------------------------------------------------------
tff(tyop_2Elist_2Elist,type,
    tyop_2Elist_2Elist: $tType > $tType ).

tff(tyop_2Emin_2Ebool,type,
    tyop_2Emin_2Ebool: $tType ).

tff(tyop_2Emin_2Efun,type,
    tyop_2Emin_2Efun: ( $tType * $tType ) > $tType ).

tff(tyop_2Enum_2Enum,type,
    tyop_2Enum_2Enum: $tType ).

tff(tyop_2Eoption_2Eoption,type,
    tyop_2Eoption_2Eoption: $tType > $tType ).

tff(tyop_2Epair_2Eprod,type,
    tyop_2Epair_2Eprod: ( $tType * $tType ) > $tType ).

tff(app_2E2,type,
    app_2E2: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( tyop_2Emin_2Efun(A_27a,A_27b) * A_27a ) > A_27b ) ).

tff(p,type,
    p: tyop_2Emin_2Ebool > $o ).

tff(combin_i_2E0,type,
    combin_i_2E0: 
      !>[A_27a: $tType] : tyop_2Emin_2Efun(A_27a,A_27a) ).

tff(combin_k_2E0,type,
    combin_k_2E0: 
      !>[A_27a: $tType,A_27b: $tType] : tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27b,A_27a)) ).

tff(combin_s_2E0,type,
    combin_s_2E0: 
      !>[A_27a: $tType,A_27b: $tType,A_27c: $tType] : tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27b,A_27c)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(A_27a,A_27c))) ).

tff(c_2Ebool_2E_21_2E0,type,
    c_2Ebool_2E_21_2E0: 
      !>[A_27a: $tType] : tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool) ).

tff(c_2Ebool_2E_21_2E1,type,
    c_2Ebool_2E_21_2E1: 
      !>[A_27a: $tType] : ( tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool) > tyop_2Emin_2Ebool ) ).

tff(c_2Earithmetic_2E_2B_2E0,type,
    c_2Earithmetic_2E_2B_2E0: tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Enum_2Enum)) ).

tff(c_2Earithmetic_2E_2B_2E2,type,
    c_2Earithmetic_2E_2B_2E2: ( tyop_2Enum_2Enum * tyop_2Enum_2Enum ) > tyop_2Enum_2Enum ).

tff(c_2Epair_2E_2C_2E0,type,
    c_2Epair_2E_2C_2E0: 
      !>[A_27a: $tType,A_27b: $tType] : tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27b,tyop_2Epair_2Eprod(A_27a,A_27b))) ).

tff(c_2Epair_2E_2C_2E2,type,
    c_2Epair_2E_2C_2E2: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( A_27a * A_27b ) > tyop_2Epair_2Eprod(A_27a,A_27b) ) ).

tff(c_2Earithmetic_2E_2D_2E0,type,
    c_2Earithmetic_2E_2D_2E0: tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Enum_2Enum)) ).

tff(c_2Earithmetic_2E_2D_2E2,type,
    c_2Earithmetic_2E_2D_2E2: ( tyop_2Enum_2Enum * tyop_2Enum_2Enum ) > tyop_2Enum_2Enum ).

tff(c_2Ebool_2E_2F_5C_2E0,type,
    c_2Ebool_2E_2F_5C_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool)) ).

tff(c_2Ebool_2E_2F_5C_2E2,type,
    c_2Ebool_2E_2F_5C_2E2: ( tyop_2Emin_2Ebool * tyop_2Emin_2Ebool ) > tyop_2Emin_2Ebool ).

tff(c_2Enum_2E0_2E0,type,
    c_2Enum_2E0_2E0: tyop_2Enum_2Enum ).

tff(c_2Eprim__rec_2E_3C_2E0,type,
    c_2Eprim__rec_2E_3C_2E0: tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool)) ).

tff(c_2Eprim__rec_2E_3C_2E2,type,
    c_2Eprim__rec_2E_3C_2E2: ( tyop_2Enum_2Enum * tyop_2Enum_2Enum ) > tyop_2Emin_2Ebool ).

tff(c_2Emin_2E_3D_2E0,type,
    c_2Emin_2E_3D_2E0: 
      !>[A_27a: $tType] : tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)) ).

tff(c_2Emin_2E_3D_2E2,type,
    c_2Emin_2E_3D_2E2: 
      !>[A_27a: $tType] : ( ( A_27a * A_27a ) > tyop_2Emin_2Ebool ) ).

tff(c_2Emin_2E_3D_3D_3E_2E0,type,
    c_2Emin_2E_3D_3D_3E_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool)) ).

tff(c_2Emin_2E_3D_3D_3E_2E2,type,
    c_2Emin_2E_3D_3D_3E_2E2: ( tyop_2Emin_2Ebool * tyop_2Emin_2Ebool ) > tyop_2Emin_2Ebool ).

tff(c_2Earithmetic_2E_3E_3D_2E0,type,
    c_2Earithmetic_2E_3E_3D_2E0: tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool)) ).

tff(c_2Earithmetic_2E_3E_3D_2E2,type,
    c_2Earithmetic_2E_3E_3D_2E2: ( tyop_2Enum_2Enum * tyop_2Enum_2Enum ) > tyop_2Emin_2Ebool ).

tff(c_2Ebool_2E_3F_2E0,type,
    c_2Ebool_2E_3F_2E0: 
      !>[A_27a: $tType] : tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool) ).

tff(c_2Ebool_2E_3F_2E1,type,
    c_2Ebool_2E_3F_2E1: 
      !>[A_27a: $tType] : ( tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool) > tyop_2Emin_2Ebool ) ).

tff(c_2Emin_2E_40_2E0,type,
    c_2Emin_2E_40_2E0: 
      !>[A_27a: $tType] : tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),A_27a) ).

tff(c_2Emin_2E_40_2E1,type,
    c_2Emin_2E_40_2E1: 
      !>[A_27a: $tType] : ( tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool) > A_27a ) ).

tff(c_2Elist_2EAPPEND_2E0,type,
    c_2Elist_2EAPPEND_2E0: 
      !>[A_27a: $tType] : tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27a),tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27a),tyop_2Elist_2Elist(A_27a))) ).

tff(c_2Elist_2EAPPEND_2E2,type,
    c_2Elist_2EAPPEND_2E2: 
      !>[A_27a: $tType] : ( ( tyop_2Elist_2Elist(A_27a) * tyop_2Elist_2Elist(A_27a) ) > tyop_2Elist_2Elist(A_27a) ) ).

tff(c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E0,type,
    c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E0: 
      !>[A_27a: $tType] : tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27a),tyop_2Elist_2Elist(A_27a))) ).

tff(c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2,type,
    c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2: 
      !>[A_27a: $tType] : ( ( tyop_2Elist_2Elist(tyop_2Emin_2Ebool) * tyop_2Elist_2Elist(A_27a) ) > tyop_2Elist_2Elist(A_27a) ) ).

tff(c_2Ebool_2EARB_2E0,type,
    c_2Ebool_2EARB_2E0: 
      !>[A_27a: $tType] : A_27a ).

tff(c_2Ebool_2ECOND_2E0,type,
    c_2Ebool_2ECOND_2E0: 
      !>[A_27a: $tType] : tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27a,A_27a))) ).

tff(c_2Ebool_2ECOND_2E3,type,
    c_2Ebool_2ECOND_2E3: 
      !>[A_27a: $tType] : ( ( tyop_2Emin_2Ebool * A_27a * A_27a ) > A_27a ) ).

tff(c_2Elist_2ECONS_2E0,type,
    c_2Elist_2ECONS_2E0: 
      !>[A_27a: $tType] : tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27a),tyop_2Elist_2Elist(A_27a))) ).

tff(c_2Elist_2ECONS_2E2,type,
    c_2Elist_2ECONS_2E2: 
      !>[A_27a: $tType] : ( ( A_27a * tyop_2Elist_2Elist(A_27a) ) > tyop_2Elist_2Elist(A_27a) ) ).

tff(c_2Elist_2EEL_2E0,type,
    c_2Elist_2EEL_2E0: 
      !>[A_27a: $tType] : tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27a),A_27a)) ).

tff(c_2Elist_2EEL_2E2,type,
    c_2Elist_2EEL_2E2: 
      !>[A_27a: $tType] : ( ( tyop_2Enum_2Enum * tyop_2Elist_2Elist(A_27a) ) > A_27a ) ).

tff(c_2Elist_2EEVERY_2E0,type,
    c_2Elist_2EEVERY_2E0: 
      !>[A_27a: $tType] : tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27a),tyop_2Emin_2Ebool)) ).

tff(c_2Elist_2EEVERY_2E2,type,
    c_2Elist_2EEVERY_2E2: 
      !>[A_27a: $tType] : ( ( tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool) * tyop_2Elist_2Elist(A_27a) ) > tyop_2Emin_2Ebool ) ).

tff(c_2Elist_2EEXISTS_2E0,type,
    c_2Elist_2EEXISTS_2E0: 
      !>[A_27a: $tType] : tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27a),tyop_2Emin_2Ebool)) ).

tff(c_2Elist_2EEXISTS_2E2,type,
    c_2Elist_2EEXISTS_2E2: 
      !>[A_27a: $tType] : ( ( tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool) * tyop_2Elist_2Elist(A_27a) ) > tyop_2Emin_2Ebool ) ).

tff(c_2Ebool_2EF_2E0,type,
    c_2Ebool_2EF_2E0: tyop_2Emin_2Ebool ).

tff(c_2Elist_2EFILTER_2E0,type,
    c_2Elist_2EFILTER_2E0: 
      !>[A_27a: $tType] : tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27a),tyop_2Elist_2Elist(A_27a))) ).

tff(c_2Elist_2EFILTER_2E2,type,
    c_2Elist_2EFILTER_2E2: 
      !>[A_27a: $tType] : ( ( tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool) * tyop_2Elist_2Elist(A_27a) ) > tyop_2Elist_2Elist(A_27a) ) ).

tff(c_2Epair_2EFST_2E0,type,
    c_2Epair_2EFST_2E0: 
      !>[A_27a: $tType,A_27b: $tType] : tyop_2Emin_2Efun(tyop_2Epair_2Eprod(A_27a,A_27b),A_27a) ).

tff(c_2Epair_2EFST_2E1,type,
    c_2Epair_2EFST_2E1: 
      !>[A_27a: $tType,A_27b: $tType] : ( tyop_2Epair_2Eprod(A_27a,A_27b) > A_27a ) ).

tff(c_2Ecombin_2EI_2E0,type,
    c_2Ecombin_2EI_2E0: 
      !>[A_27a: $tType] : tyop_2Emin_2Efun(A_27a,A_27a) ).

tff(c_2Ebool_2EIN_2E0,type,
    c_2Ebool_2EIN_2E0: 
      !>[A_27a: $tType] : tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)) ).

tff(c_2Ebool_2EIN_2E2,type,
    c_2Ebool_2EIN_2E2: 
      !>[A_27a: $tType] : ( ( A_27a * tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool) ) > tyop_2Emin_2Ebool ) ).

tff(c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E0,type,
    c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E0: 
      !>[A_27a: $tType,A_27b: $tType] : tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)))) ).

tff(c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4,type,
    c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( A_27a * tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))) * tyop_2Emin_2Ebool * tyop_2Elist_2Elist(tyop_2Emin_2Ebool) ) > tyop_2Emin_2Ebool ) ).

tff(c_2Eoption_2EIS__SOME_2E0,type,
    c_2Eoption_2EIS__SOME_2E0: 
      !>[A_27a: $tType] : tyop_2Emin_2Efun(tyop_2Eoption_2Eoption(A_27a),tyop_2Emin_2Ebool) ).

tff(c_2Eoption_2EIS__SOME_2E1,type,
    c_2Eoption_2EIS__SOME_2E1: 
      !>[A_27a: $tType] : ( tyop_2Eoption_2Eoption(A_27a) > tyop_2Emin_2Ebool ) ).

tff(c_2Elist_2ELENGTH_2E0,type,
    c_2Elist_2ELENGTH_2E0: 
      !>[A_27a: $tType] : tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27a),tyop_2Enum_2Enum) ).

tff(c_2Elist_2ELENGTH_2E1,type,
    c_2Elist_2ELENGTH_2E1: 
      !>[A_27a: $tType] : ( tyop_2Elist_2Elist(A_27a) > tyop_2Enum_2Enum ) ).

tff(c_2Elist_2ELIST__TO__SET_2E0,type,
    c_2Elist_2ELIST__TO__SET_2E0: 
      !>[A_27a: $tType] : tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27a),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)) ).

tff(c_2Elist_2ELIST__TO__SET_2E1,type,
    c_2Elist_2ELIST__TO__SET_2E1: 
      !>[A_27a: $tType] : ( tyop_2Elist_2Elist(A_27a) > tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool) ) ).

tff(c_2Elist_2EMAP_2E0,type,
    c_2Elist_2EMAP_2E0: 
      !>[A_27a: $tType,A_27b: $tType] : tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27a),tyop_2Elist_2Elist(A_27b))) ).

tff(c_2Elist_2EMAP_2E2,type,
    c_2Elist_2EMAP_2E2: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( tyop_2Emin_2Efun(A_27a,A_27b) * tyop_2Elist_2Elist(A_27a) ) > tyop_2Elist_2Elist(A_27b) ) ).

tff(c_2Elist_2EMAP2_2E0,type,
    c_2Elist_2EMAP2_2E0: 
      !>[A_27a: $tType,A_27b: $tType,A_27c: $tType] : tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27c,A_27a)),tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27b),tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27c),tyop_2Elist_2Elist(A_27a)))) ).

tff(c_2Elist_2EMAP2_2E3,type,
    c_2Elist_2EMAP2_2E3: 
      !>[A_27a: $tType,A_27b: $tType,A_27c: $tType] : ( ( tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27c,A_27a)) * tyop_2Elist_2Elist(A_27b) * tyop_2Elist_2Elist(A_27c) ) > tyop_2Elist_2Elist(A_27a) ) ).

tff(c_2Elist_2ENIL_2E0,type,
    c_2Elist_2ENIL_2E0: 
      !>[A_27a: $tType] : tyop_2Elist_2Elist(A_27a) ).

tff(c_2Eoption_2ENONE_2E0,type,
    c_2Eoption_2ENONE_2E0: 
      !>[A_27a: $tType] : tyop_2Eoption_2Eoption(A_27a) ).

tff(c_2Eoption_2EOPTION__MAP_2E0,type,
    c_2Eoption_2EOPTION__MAP_2E0: 
      !>[A_27a: $tType,A_27b: $tType] : tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(tyop_2Eoption_2Eoption(A_27a),tyop_2Eoption_2Eoption(A_27b))) ).

tff(c_2Eoption_2EOPTION__MAP_2E2,type,
    c_2Eoption_2EOPTION__MAP_2E2: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( tyop_2Emin_2Efun(A_27a,A_27b) * tyop_2Eoption_2Eoption(A_27a) ) > tyop_2Eoption_2Eoption(A_27b) ) ).

tff(c_2EpatternMatches_2EPMATCH_2E0,type,
    c_2EpatternMatches_2EPMATCH_2E0: 
      !>[A_27a: $tType,A_27b: $tType] : tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),A_27a)) ).

tff(c_2EpatternMatches_2EPMATCH_2E2,type,
    c_2EpatternMatches_2EPMATCH_2E2: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( A_27b * tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))) ) > A_27a ) ).

tff(c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E0,type,
    c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E0: 
      !>[A_27a: $tType,A_27b: $tType] : tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Ebool))) ).

tff(c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E2,type,
    c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E2: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( A_27a * tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))) ) > tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Ebool) ) ).

tff(c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3,type,
    c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( A_27a * tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))) * tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))) ) > tyop_2Emin_2Ebool ) ).

tff(c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E0,type,
    c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E0: 
      !>[A_27a: $tType,A_27b: $tType,A_27c: $tType] : tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))))) ).

tff(c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E3,type,
    c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E3: 
      !>[A_27a: $tType,A_27b: $tType,A_27c: $tType] : ( ( tyop_2Emin_2Efun(A_27b,A_27c) * tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool) * tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))) ) > tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a)) ) ).

tff(c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E4,type,
    c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E4: 
      !>[A_27a: $tType,A_27b: $tType,A_27c: $tType] : ( ( tyop_2Emin_2Efun(A_27b,A_27c) * tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool) * tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))) * A_27c ) > tyop_2Eoption_2Eoption(A_27a) ) ).

tff(c_2EpatternMatches_2EPMATCH__INCOMPLETE_2E0,type,
    c_2EpatternMatches_2EPMATCH__INCOMPLETE_2E0: 
      !>[A_27a: $tType] : A_27a ).

tff(c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E0,type,
    c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E0: 
      !>[A_27a: $tType,A_27b: $tType] : tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Ebool)) ).

tff(c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2,type,
    c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( A_27a * tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))) ) > tyop_2Emin_2Ebool ) ).

tff(c_2EpatternMatches_2EPMATCH__ROW_2E0,type,
    c_2EpatternMatches_2EPMATCH__ROW_2E0: 
      !>[A_27a: $tType,A_27b: $tType,A_27c: $tType] : tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))))) ).

tff(c_2EpatternMatches_2EPMATCH__ROW_2E3,type,
    c_2EpatternMatches_2EPMATCH__ROW_2E3: 
      !>[A_27a: $tType,A_27b: $tType,A_27c: $tType] : ( ( tyop_2Emin_2Efun(A_27b,A_27c) * tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool) * tyop_2Emin_2Efun(A_27b,A_27a) ) > tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a)) ) ).

tff(c_2EpatternMatches_2EPMATCH__ROW_2E4,type,
    c_2EpatternMatches_2EPMATCH__ROW_2E4: 
      !>[A_27a: $tType,A_27b: $tType,A_27c: $tType] : ( ( tyop_2Emin_2Efun(A_27b,A_27c) * tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool) * tyop_2Emin_2Efun(A_27b,A_27a) * A_27c ) > tyop_2Eoption_2Eoption(A_27a) ) ).

tff(c_2EpatternMatches_2EPMATCH__ROW__COND_2E0,type,
    c_2EpatternMatches_2EPMATCH__ROW__COND_2E0: 
      !>[A_27a: $tType,A_27b: $tType] : tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)))) ).

tff(c_2EpatternMatches_2EPMATCH__ROW__COND_2E4,type,
    c_2EpatternMatches_2EPMATCH__ROW__COND_2E4: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( tyop_2Emin_2Efun(A_27a,A_27b) * tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool) * A_27b * A_27a ) > tyop_2Emin_2Ebool ) ).

tff(c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E0,type,
    c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E0: 
      !>[A_27a: $tType,A_27b: $tType] : tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool))) ).

tff(c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3,type,
    c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( A_27a * tyop_2Emin_2Efun(A_27b,A_27a) * tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool) ) > tyop_2Emin_2Ebool ) ).

tff(c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E0,type,
    c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E0: 
      !>[A_27a: $tType,A_27b: $tType] : tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool))) ).

tff(c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E3,type,
    c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E3: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( A_27a * tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))) * tyop_2Enum_2Enum ) > tyop_2Emin_2Ebool ) ).

tff(c_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ_2E0,type,
    c_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ_2E0: tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool))) ).

tff(c_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ_2E2,type,
    c_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ_2E2: ( tyop_2Elist_2Elist(tyop_2Emin_2Ebool) * tyop_2Elist_2Elist(tyop_2Emin_2Ebool) ) > tyop_2Elist_2Elist(tyop_2Emin_2Ebool) ).

tff(c_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__DISJ_2E0,type,
    c_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__DISJ_2E0: tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool))) ).

tff(c_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__DISJ_2E2,type,
    c_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__DISJ_2E2: ( tyop_2Elist_2Elist(tyop_2Emin_2Ebool) * tyop_2Elist_2Elist(tyop_2Emin_2Ebool) ) > tyop_2Elist_2Elist(tyop_2Emin_2Ebool) ).

tff(c_2Epair_2ESND_2E0,type,
    c_2Epair_2ESND_2E0: 
      !>[A_27a: $tType,A_27b: $tType] : tyop_2Emin_2Efun(tyop_2Epair_2Eprod(A_27a,A_27b),A_27b) ).

tff(c_2Epair_2ESND_2E1,type,
    c_2Epair_2ESND_2E1: 
      !>[A_27a: $tType,A_27b: $tType] : ( tyop_2Epair_2Eprod(A_27a,A_27b) > A_27b ) ).

tff(c_2Elist_2ESNOC_2E0,type,
    c_2Elist_2ESNOC_2E0: 
      !>[A_27a: $tType] : tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27a),tyop_2Elist_2Elist(A_27a))) ).

tff(c_2Elist_2ESNOC_2E2,type,
    c_2Elist_2ESNOC_2E2: 
      !>[A_27a: $tType] : ( ( A_27a * tyop_2Elist_2Elist(A_27a) ) > tyop_2Elist_2Elist(A_27a) ) ).

tff(c_2Eoption_2ESOME_2E0,type,
    c_2Eoption_2ESOME_2E0: 
      !>[A_27a: $tType] : tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27a)) ).

tff(c_2Eoption_2ESOME_2E1,type,
    c_2Eoption_2ESOME_2E1: 
      !>[A_27a: $tType] : ( A_27a > tyop_2Eoption_2Eoption(A_27a) ) ).

tff(c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO_2E0,type,
    c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO_2E0: 
      !>[A_27a: $tType,A_27b: $tType] : tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Elist_2Elist(tyop_2Emin_2Ebool))) ).

tff(c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO_2E2,type,
    c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO_2E2: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( A_27a * tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))) ) > tyop_2Elist_2Elist(tyop_2Emin_2Ebool) ) ).

tff(c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX_2E0,type,
    c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX_2E0: 
      !>[A_27a: $tType,A_27b: $tType] : tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)))))) ).

tff(c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX_2E4,type,
    c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX_2E4: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( A_27a * tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))) * tyop_2Emin_2Ebool * tyop_2Elist_2Elist(tyop_2Emin_2Ebool) ) > tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)) ) ).

tff(c_2Enum_2ESUC_2E0,type,
    c_2Enum_2ESUC_2E0: tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Enum_2Enum) ).

tff(c_2Enum_2ESUC_2E1,type,
    c_2Enum_2ESUC_2E1: tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

tff(c_2Ebool_2ET_2E0,type,
    c_2Ebool_2ET_2E0: tyop_2Emin_2Ebool ).

tff(c_2Elist_2ETAKE_2E0,type,
    c_2Elist_2ETAKE_2E0: 
      !>[A_27a: $tType] : tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27a),tyop_2Elist_2Elist(A_27a))) ).

tff(c_2Elist_2ETAKE_2E2,type,
    c_2Elist_2ETAKE_2E2: 
      !>[A_27a: $tType] : ( ( tyop_2Enum_2Enum * tyop_2Elist_2Elist(A_27a) ) > tyop_2Elist_2Elist(A_27a) ) ).

tff(c_2Elist_2EZIP_2E0,type,
    c_2Elist_2EZIP_2E0: 
      !>[A_27a: $tType,A_27b: $tType] : tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Elist_2Elist(A_27a),tyop_2Elist_2Elist(A_27b)),tyop_2Elist_2Elist(tyop_2Epair_2Eprod(A_27a,A_27b))) ).

tff(c_2Elist_2EZIP_2E1,type,
    c_2Elist_2EZIP_2E1: 
      !>[A_27a: $tType,A_27b: $tType] : ( tyop_2Epair_2Eprod(tyop_2Elist_2Elist(A_27a),tyop_2Elist_2Elist(A_27b)) > tyop_2Elist_2Elist(tyop_2Epair_2Eprod(A_27a,A_27b)) ) ).

tff(c_2Ebool_2E_5C_2F_2E0,type,
    c_2Ebool_2E_5C_2F_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool)) ).

tff(c_2Ebool_2E_5C_2F_2E2,type,
    c_2Ebool_2E_5C_2F_2E2: ( tyop_2Emin_2Ebool * tyop_2Emin_2Ebool ) > tyop_2Emin_2Ebool ).

tff(c_2Eoption_2Eoption__CASE_2E0,type,
    c_2Eoption_2Eoption__CASE_2E0: 
      !>[A_27a: $tType,A_27b: $tType] : tyop_2Emin_2Efun(tyop_2Eoption_2Eoption(A_27a),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),A_27b))) ).

tff(c_2Eoption_2Eoption__CASE_2E3,type,
    c_2Eoption_2Eoption__CASE_2E3: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( tyop_2Eoption_2Eoption(A_27a) * A_27b * tyop_2Emin_2Efun(A_27a,A_27b) ) > A_27b ) ).

tff(c_2Eoption_2Esome_2E0,type,
    c_2Eoption_2Esome_2E0: 
      !>[A_27a: $tType] : tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Eoption_2Eoption(A_27a)) ).

tff(c_2Eoption_2Esome_2E1,type,
    c_2Eoption_2Esome_2E1: 
      !>[A_27a: $tType] : ( tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool) > tyop_2Eoption_2Eoption(A_27a) ) ).

tff(c_2Ebool_2E_7E_2E0,type,
    c_2Ebool_2E_7E_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool) ).

tff(c_2Ebool_2E_7E_2E1,type,
    c_2Ebool_2E_7E_2E1: tyop_2Emin_2Ebool > tyop_2Emin_2Ebool ).

tff(thm_2Eextra_2Dho_2Eeq__ext,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0f_2E0: tyop_2Emin_2Efun(A_27a,A_27b),V1g_2E0: tyop_2Emin_2Efun(A_27a,A_27b)] :
      ( ! [V2x_2E0: A_27a] : ( app_2E2(A_27a,A_27b,V0f_2E0,V2x_2E0) = app_2E2(A_27a,A_27b,V1g_2E0,V2x_2E0) )
     => ( V0f_2E0 = V1g_2E0 ) ) ).

tff(thm_2Eextra_2Dho_2Eboolext,axiom,
    ! [V0_2E0: tyop_2Emin_2Ebool,V1_2E0: tyop_2Emin_2Ebool] :
      ( ( p(V0_2E0)
      <=> p(V1_2E0) )
     => ( V0_2E0 = V1_2E0 ) ) ).

tff(thm_2Eextra_2Dho_2Etruth,axiom,
    p(c_2Ebool_2ET_2E0) ).

tff(thm_2Eextra_2Dho_2Enotfalse,axiom,
    ~ p(c_2Ebool_2EF_2E0) ).

tff(thm_2Eextra_2Dho_2Ebool__cases__ax,axiom,
    ! [V0t_2E0: tyop_2Emin_2Ebool] :
      ( ( V0t_2E0 = c_2Ebool_2ET_2E0 )
      | ( V0t_2E0 = c_2Ebool_2EF_2E0 ) ) ).

tff(thm_2Eextra_2Dho_2Ei__thm,axiom,
    ! [A_27a: $tType,V0x_2E0: A_27a] : ( app_2E2(A_27a,A_27a,combin_i_2E0(A_27a),V0x_2E0) = V0x_2E0 ) ).

tff(thm_2Eextra_2Dho_2Ek__thm,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0x_2E0: A_27a,V1y_2E0: A_27b] : ( app_2E2(A_27b,A_27a,app_2E2(A_27a,tyop_2Emin_2Efun(A_27b,A_27a),combin_k_2E0(A_27a,A_27b),V0x_2E0),V1y_2E0) = V0x_2E0 ) ).

tff(thm_2Eextra_2Dho_2Es__thm,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,V0f_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27b,A_27c)),V1g_2E0: tyop_2Emin_2Efun(A_27a,A_27b),V2x_2E0: A_27a] : ( app_2E2(A_27a,A_27c,app_2E2(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(A_27a,A_27c),app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27b,A_27c)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(A_27a,A_27c)),combin_s_2E0(A_27a,A_27b,A_27c),V0f_2E0),V1g_2E0),V2x_2E0) = app_2E2(A_27b,A_27c,app_2E2(A_27a,tyop_2Emin_2Efun(A_27b,A_27c),V0f_2E0,V2x_2E0),app_2E2(A_27a,A_27b,V1g_2E0,V2x_2E0)) ) ).

tff(logicdef_2E_2F_5C,axiom,
    ! [V0_2E0: tyop_2Emin_2Ebool,V1_2E0: tyop_2Emin_2Ebool] :
      ( p(c_2Ebool_2E_2F_5C_2E2(V0_2E0,V1_2E0))
    <=> ( p(V0_2E0)
        & p(V1_2E0) ) ) ).

tff(logicdef_2E_5C_2F,axiom,
    ! [V0_2E0: tyop_2Emin_2Ebool,V1_2E0: tyop_2Emin_2Ebool] :
      ( p(c_2Ebool_2E_5C_2F_2E2(V0_2E0,V1_2E0))
    <=> ( p(V0_2E0)
        | p(V1_2E0) ) ) ).

tff(logicdef_2E_7E,axiom,
    ! [V0_2E0: tyop_2Emin_2Ebool] :
      ( p(c_2Ebool_2E_7E_2E1(V0_2E0))
    <=> ~ p(V0_2E0) ) ).

tff(logicdef_2E_3D_3D_3E,axiom,
    ! [V0_2E0: tyop_2Emin_2Ebool,V1_2E0: tyop_2Emin_2Ebool] :
      ( p(c_2Emin_2E_3D_3D_3E_2E2(V0_2E0,V1_2E0))
    <=> ( p(V0_2E0)
       => p(V1_2E0) ) ) ).

tff(logicdef_2E_3D,axiom,
    ! [A_27a: $tType,V0_2E0: A_27a,V1_2E0: A_27a] :
      ( p(c_2Emin_2E_3D_2E2(A_27a,V0_2E0,V1_2E0))
    <=> ( V0_2E0 = V1_2E0 ) ) ).

tff(quantdef_2E_21,axiom,
    ! [A_27a: $tType,V0f_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)] :
      ( p(c_2Ebool_2E_21_2E1(A_27a,V0f_2E0))
    <=> ! [V1x_2E0: A_27a] : p(app_2E2(A_27a,tyop_2Emin_2Ebool,V0f_2E0,V1x_2E0)) ) ).

tff(quantdef_2E_3F,axiom,
    ! [A_27a: $tType,V0f_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)] :
      ( p(c_2Ebool_2E_3F_2E1(A_27a,V0f_2E0))
    <=> ? [V1x_2E0: A_27a] : p(app_2E2(A_27a,tyop_2Emin_2Ebool,V0f_2E0,V1x_2E0)) ) ).

tff(arityeq1_2Ec_2Ebool_2E_21_2E1_2Emono_2EA_27a,axiom,
    ! [A_27a: $tType,X0_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)] : ( c_2Ebool_2E_21_2E1(A_27a,X0_2E0) = app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool,c_2Ebool_2E_21_2E0(A_27a),X0_2E0) ) ).

tff(arityeq2_2Ec_2Earithmetic_2E_2B_2E2,axiom,
    ! [X0_2E0: tyop_2Enum_2Enum,X1_2E0: tyop_2Enum_2Enum] : ( c_2Earithmetic_2E_2B_2E2(X0_2E0,X1_2E0) = app_2E2(tyop_2Enum_2Enum,tyop_2Enum_2Enum,app_2E2(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Enum_2Enum),c_2Earithmetic_2E_2B_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Epair_2E_2C_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,axiom,
    ! [X0_2E0: tyop_2Emin_2Ebool,X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool)] : ( c_2Epair_2E_2C_2E2(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool),X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool))),c_2Epair_2E_2C_2E0(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Epair_2E_2C_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Elist_2Elist_28A_27a_29,axiom,
    ! [A_27a: $tType,X0_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool),X1_2E0: tyop_2Elist_2Elist(A_27a)] : ( c_2Epair_2E_2C_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(A_27a),X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(A_27a),tyop_2Epair_2Eprod(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(A_27a)),app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27a),tyop_2Epair_2Eprod(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(A_27a))),c_2Epair_2E_2C_2E0(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(A_27a)),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Earithmetic_2E_2D_2E2,axiom,
    ! [X0_2E0: tyop_2Enum_2Enum,X1_2E0: tyop_2Enum_2Enum] : ( c_2Earithmetic_2E_2D_2E2(X0_2E0,X1_2E0) = app_2E2(tyop_2Enum_2Enum,tyop_2Enum_2Enum,app_2E2(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Enum_2Enum),c_2Earithmetic_2E_2D_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Ebool_2E_2F_5C_2E2,axiom,
    ! [X0_2E0: tyop_2Emin_2Ebool,X1_2E0: tyop_2Emin_2Ebool] :
      ( ( p(X0_2E0)
        & p(X1_2E0) )
    <=> p(app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),c_2Ebool_2E_2F_5C_2E0,X0_2E0),X1_2E0)) ) ).

tff(arityeq2_2Ec_2Eprim__rec_2E_3C_2E2,axiom,
    ! [X0_2E0: tyop_2Enum_2Enum,X1_2E0: tyop_2Enum_2Enum] : ( c_2Eprim__rec_2E_3C_2E2(X0_2E0,X1_2E0) = app_2E2(tyop_2Enum_2Enum,tyop_2Emin_2Ebool,app_2E2(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),c_2Eprim__rec_2E_3C_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Emin_2E_3D_2E2_2Emono_2EA_27a,axiom,
    ! [A_27a: $tType,X0_2E0: A_27a,X1_2E0: A_27a] :
      ( ( X0_2E0 = X1_2E0 )
    <=> p(app_2E2(A_27a,tyop_2Emin_2Ebool,app_2E2(A_27a,tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),c_2Emin_2E_3D_2E0(A_27a),X0_2E0),X1_2E0)) ) ).

tff(arityeq2_2Ec_2Emin_2E_3D_3D_3E_2E2,axiom,
    ! [X0_2E0: tyop_2Emin_2Ebool,X1_2E0: tyop_2Emin_2Ebool] :
      ( ( p(X0_2E0)
       => p(X1_2E0) )
    <=> p(app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),c_2Emin_2E_3D_3D_3E_2E0,X0_2E0),X1_2E0)) ) ).

tff(arityeq2_2Ec_2Earithmetic_2E_3E_3D_2E2,axiom,
    ! [X0_2E0: tyop_2Enum_2Enum,X1_2E0: tyop_2Enum_2Enum] : ( c_2Earithmetic_2E_3E_3D_2E2(X0_2E0,X1_2E0) = app_2E2(tyop_2Enum_2Enum,tyop_2Emin_2Ebool,app_2E2(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),c_2Earithmetic_2E_3E_3D_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq1_2Ec_2Ebool_2E_3F_2E1_2Emono_2EA_27a,axiom,
    ! [A_27a: $tType,X0_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)] : ( c_2Ebool_2E_3F_2E1(A_27a,X0_2E0) = app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool,c_2Ebool_2E_3F_2E0(A_27a),X0_2E0) ) ).

tff(arityeq1_2Ec_2Emin_2E_40_2E1_2Emono_2EA_27a,axiom,
    ! [A_27a: $tType,X0_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)] : ( c_2Emin_2E_40_2E1(A_27a,X0_2E0) = app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),A_27a,c_2Emin_2E_40_2E0(A_27a),X0_2E0) ) ).

tff(arityeq1_2Ec_2Emin_2E_40_2E1_2Emono_2EA_27b,axiom,
    ! [A_27b: $tType,X0_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)] : ( c_2Emin_2E_40_2E1(A_27b,X0_2E0) = app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),A_27b,c_2Emin_2E_40_2E0(A_27b),X0_2E0) ) ).

tff(arityeq1_2Ec_2Emin_2E_40_2E1_2Emono_2EA_27d,axiom,
    ! [A_27d: $tType,X0_2E0: tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool)] : ( c_2Emin_2E_40_2E1(A_27d,X0_2E0) = app_2E2(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),A_27d,c_2Emin_2E_40_2E0(A_27d),X0_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2EAPPEND_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27a_2Ctyop_2Eoption_2Eoption_28A_27b_29_29,axiom,
    ! [A_27a: $tType,A_27b: $tType,X0_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))] : ( c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))),c_2Elist_2EAPPEND_2E0(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2EAPPEND_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27a_2Ctyop_2Eoption_2Eoption_28A_27c_29_29,axiom,
    ! [A_27a: $tType,A_27c: $tType,X0_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)))] : ( c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)))),c_2Elist_2EAPPEND_2E0(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2EAPPEND_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27b_2Ctyop_2Eoption_2Eoption_28A_27c_29_29,axiom,
    ! [A_27b: $tType,A_27c: $tType,X0_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))] : ( c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),c_2Elist_2EAPPEND_2E0(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2_2Emono_2EA_27a,axiom,
    ! [A_27a: $tType,X0_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool),X1_2E0: tyop_2Elist_2Elist(A_27a)] : ( c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2(A_27a,X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(A_27a),tyop_2Elist_2Elist(A_27a),app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27a),tyop_2Elist_2Elist(A_27a)),c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E0(A_27a),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2_2Emono_2EA_27b,axiom,
    ! [A_27b: $tType,X0_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool),X1_2E0: tyop_2Elist_2Elist(A_27b)] : ( c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2(A_27b,X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(A_27b),tyop_2Elist_2Elist(A_27b),app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27b),tyop_2Elist_2Elist(A_27b)),c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E0(A_27b),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2_2Emono_2EA_27c,axiom,
    ! [A_27c: $tType,X0_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool),X1_2E0: tyop_2Elist_2Elist(A_27c)] : ( c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2(A_27c,X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(A_27c),tyop_2Elist_2Elist(A_27c),app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27c),tyop_2Elist_2Elist(A_27c)),c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E0(A_27c),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27a_2Ctyop_2Eoption_2Eoption_28A_27b_29_29,axiom,
    ! [A_27a: $tType,A_27b: $tType,X0_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool),X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))] : ( c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))),c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E0(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X0_2E0),X1_2E0) ) ).

tff(arityeq3_2Ec_2Ebool_2ECOND_2E3_2Emono_2EA_27b,axiom,
    ! [A_27b: $tType,X0_2E0: tyop_2Emin_2Ebool,X1_2E0: A_27b,X2_2E0: A_27b] : ( c_2Ebool_2ECOND_2E3(A_27b,X0_2E0,X1_2E0,X2_2E0) = app_2E2(A_27b,A_27b,app_2E2(A_27b,tyop_2Emin_2Efun(A_27b,A_27b),app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,A_27b)),c_2Ebool_2ECOND_2E0(A_27b),X0_2E0),X1_2E0),X2_2E0) ) ).

tff(arityeq3_2Ec_2Ebool_2ECOND_2E3_2Emono_2EA_27c,axiom,
    ! [A_27c: $tType,X0_2E0: tyop_2Emin_2Ebool,X1_2E0: A_27c,X2_2E0: A_27c] : ( c_2Ebool_2ECOND_2E3(A_27c,X0_2E0,X1_2E0,X2_2E0) = app_2E2(A_27c,A_27c,app_2E2(A_27c,tyop_2Emin_2Efun(A_27c,A_27c),app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27c,A_27c)),c_2Ebool_2ECOND_2E0(A_27c),X0_2E0),X1_2E0),X2_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2ECONS_2E2_2Emono_2EA_27b,axiom,
    ! [A_27b: $tType,X0_2E0: A_27b,X1_2E0: tyop_2Elist_2Elist(A_27b)] : ( c_2Elist_2ECONS_2E2(A_27b,X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(A_27b),tyop_2Elist_2Elist(A_27b),app_2E2(A_27b,tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27b),tyop_2Elist_2Elist(A_27b)),c_2Elist_2ECONS_2E0(A_27b),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2ECONS_2E2_2Emono_2EA_27c,axiom,
    ! [A_27c: $tType,X0_2E0: A_27c,X1_2E0: tyop_2Elist_2Elist(A_27c)] : ( c_2Elist_2ECONS_2E2(A_27c,X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(A_27c),tyop_2Elist_2Elist(A_27c),app_2E2(A_27c,tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27c),tyop_2Elist_2Elist(A_27c)),c_2Elist_2ECONS_2E0(A_27c),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2ECONS_2E2_2Emono_2Etyop_2Emin_2Ebool,axiom,
    ! [X0_2E0: tyop_2Emin_2Ebool,X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool)] : ( c_2Elist_2ECONS_2E2(tyop_2Emin_2Ebool,X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),c_2Elist_2ECONS_2E0(tyop_2Emin_2Ebool),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2ECONS_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27a_2Ctyop_2Eoption_2Eoption_28A_27b_29_29,axiom,
    ! [A_27a: $tType,A_27b: $tType,X0_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))] : ( c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))),c_2Elist_2ECONS_2E0(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2ECONS_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27a_2Ctyop_2Eoption_2Eoption_28A_27c_29_29,axiom,
    ! [A_27a: $tType,A_27c: $tType,X0_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)))] : ( c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)))),c_2Elist_2ECONS_2E0(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2ECONS_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27b_2Ctyop_2Eoption_2Eoption_28A_27a_29_29,axiom,
    ! [A_27a: $tType,A_27b: $tType,X0_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)))] : ( c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)))),c_2Elist_2ECONS_2E0(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2ECONS_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27b_2Ctyop_2Eoption_2Eoption_28A_27c_29_29,axiom,
    ! [A_27b: $tType,A_27c: $tType,X0_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))] : ( c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),c_2Elist_2ECONS_2E0(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2ECONS_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27c_2Ctyop_2Eoption_2Eoption_28A_27a_29_29,axiom,
    ! [A_27a: $tType,A_27c: $tType,X0_2E0: tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a)),X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a)))] : ( c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a)),X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))),app_2E2(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a)),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a)))),c_2Elist_2ECONS_2E0(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2ECONS_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27c_2Ctyop_2Eoption_2Eoption_28A_27d_29_29,axiom,
    ! [A_27c: $tType,A_27d: $tType,X0_2E0: tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d)),X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d)))] : ( c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d)),X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d))),app_2E2(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d)),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d)))),c_2Elist_2ECONS_2E0(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d))),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2EEL_2E2_2Emono_2Etyop_2Emin_2Ebool,axiom,
    ! [X0_2E0: tyop_2Enum_2Enum,X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool)] : ( c_2Elist_2EEL_2E2(tyop_2Emin_2Ebool,X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool,app_2E2(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),c_2Elist_2EEL_2E0(tyop_2Emin_2Ebool),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2EEL_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27a_2Ctyop_2Eoption_2Eoption_28A_27b_29_29,axiom,
    ! [A_27a: $tType,A_27b: $tType,X0_2E0: tyop_2Enum_2Enum,X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))] : ( c_2Elist_2EEL_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),app_2E2(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2EEL_2E0(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2EEVERY_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27a_2Ctyop_2Eoption_2Eoption_28A_27b_29_29,axiom,
    ! [A_27a: $tType,A_27b: $tType,X0_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))] : ( c_2Elist_2EEVERY_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Ebool),c_2Elist_2EEVERY_2E0(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2EEVERY_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27a_2Ctyop_2Eoption_2Eoption_28A_27c_29_29,axiom,
    ! [A_27a: $tType,A_27c: $tType,X0_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool),X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)))] : ( c_2Elist_2EEVERY_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Ebool),c_2Elist_2EEVERY_2E0(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2EEVERY_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27b_2Ctyop_2Eoption_2Eoption_28A_27c_29_29,axiom,
    ! [A_27b: $tType,A_27c: $tType,X0_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool),X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))] : ( c_2Elist_2EEVERY_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Ebool),c_2Elist_2EEVERY_2E0(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2EEXISTS_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27a_2Ctyop_2Eoption_2Eoption_28A_27b_29_29,axiom,
    ! [A_27a: $tType,A_27b: $tType,X0_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))] : ( c_2Elist_2EEXISTS_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Ebool),c_2Elist_2EEXISTS_2E0(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2EFILTER_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2CA_27a_29,axiom,
    ! [A_27a: $tType,X0_2E0: tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a),tyop_2Emin_2Ebool),X1_2E0: tyop_2Elist_2Elist(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a))] : ( c_2Elist_2EFILTER_2E2(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a),X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a)),tyop_2Elist_2Elist(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a)),app_2E2(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a),tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a)),tyop_2Elist_2Elist(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a))),c_2Elist_2EFILTER_2E0(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a)),X0_2E0),X1_2E0) ) ).

tff(arityeq1_2Ec_2Epair_2EFST_2E1_2Emono_2Etyop_2Emin_2Ebool_20mono_2EA_27a,axiom,
    ! [A_27a: $tType,X0_2E0: tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a)] : ( c_2Epair_2EFST_2E1(tyop_2Emin_2Ebool,A_27a,X0_2E0) = app_2E2(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a),tyop_2Emin_2Ebool,c_2Epair_2EFST_2E0(tyop_2Emin_2Ebool,A_27a),X0_2E0) ) ).

tff(arityeq1_2Ec_2Epair_2EFST_2E1_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,axiom,
    ! [X0_2E0: tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool))] : ( c_2Epair_2EFST_2E1(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool),X0_2E0) = app_2E2(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),tyop_2Emin_2Ebool,c_2Epair_2EFST_2E0(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),X0_2E0) ) ).

tff(arityeq2_2Ec_2Ebool_2EIN_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27a_2Ctyop_2Eoption_2Eoption_28A_27b_29_29,axiom,
    ! [A_27a: $tType,A_27b: $tType,X0_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),X1_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool)] : ( c_2Ebool_2EIN_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),X0_2E0,X1_2E0) = app_2E2(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),c_2Ebool_2EIN_2E0(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X0_2E0),X1_2E0) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4_2Emono_2EA_27a_20mono_2EA_27b,axiom,
    ! [A_27a: $tType,A_27b: $tType,X0_2E0: A_27a,X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X2_2E0: tyop_2Emin_2Ebool,X3_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool)] : ( c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(A_27a,A_27b,X0_2E0,X1_2E0,X2_2E0,X3_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)),app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool))),c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E0(A_27a,A_27b),X0_2E0),X1_2E0),X2_2E0),X3_2E0) ) ).

tff(arityeq1_2Ec_2Eoption_2EIS__SOME_2E1_2Emono_2EA_27b,axiom,
    ! [A_27b: $tType,X0_2E0: tyop_2Eoption_2Eoption(A_27b)] : ( c_2Eoption_2EIS__SOME_2E1(A_27b,X0_2E0) = app_2E2(tyop_2Eoption_2Eoption(A_27b),tyop_2Emin_2Ebool,c_2Eoption_2EIS__SOME_2E0(A_27b),X0_2E0) ) ).

tff(arityeq1_2Ec_2Elist_2ELENGTH_2E1_2Emono_2Etyop_2Emin_2Ebool,axiom,
    ! [X0_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool)] : ( c_2Elist_2ELENGTH_2E1(tyop_2Emin_2Ebool,X0_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Enum_2Enum,c_2Elist_2ELENGTH_2E0(tyop_2Emin_2Ebool),X0_2E0) ) ).

tff(arityeq1_2Ec_2Elist_2ELENGTH_2E1_2Emono_2Etyop_2Emin_2Efun_28A_27a_2Ctyop_2Eoption_2Eoption_28A_27b_29_29,axiom,
    ! [A_27a: $tType,A_27b: $tType,X0_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))] : ( c_2Elist_2ELENGTH_2E1(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),X0_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Enum_2Enum,c_2Elist_2ELENGTH_2E0(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X0_2E0) ) ).

tff(arityeq1_2Ec_2Elist_2ELIST__TO__SET_2E1_2Emono_2Etyop_2Emin_2Efun_28A_27a_2Ctyop_2Eoption_2Eoption_28A_27b_29_29,axiom,
    ! [A_27a: $tType,A_27b: $tType,X0_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))] : ( c_2Elist_2ELIST__TO__SET_2E1(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),X0_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),c_2Elist_2ELIST__TO__SET_2E0(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X0_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2EMAP_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27b_2Ctyop_2Emin_2Efun_28A_27b_2Ctyop_2Eoption_2Eoption_28A_27c_29_29_29_20mono_2Etyop_2Emin_2Efun_28A_27a_2Ctyop_2Eoption_2Eoption_28A_27c_29_29,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,X0_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))))] : ( c_2Elist_2EMAP_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),app_2E2(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)))),c_2Elist_2EMAP_2E0(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2EMAP_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27b_2Ctyop_2Emin_2Efun_28A_27b_2Ctyop_2Eoption_2Eoption_28A_27c_29_29_29_20mono_2Etyop_2Emin_2Efun_28A_27b_2Ctyop_2Eoption_2Eoption_28A_27c_29_29,axiom,
    ! [A_27b: $tType,A_27c: $tType,X0_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))))] : ( c_2Elist_2EMAP_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),app_2E2(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),c_2Elist_2EMAP_2E0(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2EMAP_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2CA_27a_29_20mono_2EA_27a,axiom,
    ! [A_27a: $tType,X0_2E0: tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a),A_27a),X1_2E0: tyop_2Elist_2Elist(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a))] : ( c_2Elist_2EMAP_2E2(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a),A_27a,X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a)),tyop_2Elist_2Elist(A_27a),app_2E2(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a),A_27a),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a)),tyop_2Elist_2Elist(A_27a)),c_2Elist_2EMAP_2E0(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a),A_27a),X0_2E0),X1_2E0) ) ).

tff(arityeq3_2Ec_2Elist_2EMAP2_2E3_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool,axiom,
    ! [X0_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool)),X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool),X2_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool)] : ( c_2Elist_2EMAP2_2E3(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool,tyop_2Emin_2Ebool,X0_2E0,X1_2E0,X2_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool),app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),app_2E2(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool))),c_2Elist_2EMAP2_2E0(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),X0_2E0),X1_2E0),X2_2E0) ) ).

tff(arityeq2_2Ec_2Eoption_2EOPTION__MAP_2E2_2Emono_2EA_27b_20mono_2EA_27a,axiom,
    ! [A_27a: $tType,A_27b: $tType,X0_2E0: tyop_2Emin_2Efun(A_27b,A_27a),X1_2E0: tyop_2Eoption_2Eoption(A_27b)] : ( c_2Eoption_2EOPTION__MAP_2E2(A_27b,A_27a,X0_2E0,X1_2E0) = app_2E2(tyop_2Eoption_2Eoption(A_27b),tyop_2Eoption_2Eoption(A_27a),app_2E2(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Eoption_2Eoption(A_27b),tyop_2Eoption_2Eoption(A_27a)),c_2Eoption_2EOPTION__MAP_2E0(A_27b,A_27a),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EPMATCH_2E2_2Emono_2EA_27b_20mono_2EA_27a,axiom,
    ! [A_27a: $tType,A_27b: $tType,X0_2E0: A_27a,X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))] : ( c_2EpatternMatches_2EPMATCH_2E2(A_27b,A_27a,X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),A_27b,app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),A_27b),c_2EpatternMatches_2EPMATCH_2E0(A_27b,A_27a),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EPMATCH_2E2_2Emono_2EA_27c_20mono_2EA_27a,axiom,
    ! [A_27a: $tType,A_27c: $tType,X0_2E0: A_27a,X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)))] : ( c_2EpatternMatches_2EPMATCH_2E2(A_27c,A_27a,X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),A_27c,app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),A_27c),c_2EpatternMatches_2EPMATCH_2E0(A_27c,A_27a),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EPMATCH_2E2_2Emono_2EA_27a_20mono_2EA_27b,axiom,
    ! [A_27a: $tType,A_27b: $tType,X0_2E0: A_27b,X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)))] : ( c_2EpatternMatches_2EPMATCH_2E2(A_27a,A_27b,X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),A_27a,app_2E2(A_27b,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),A_27a),c_2EpatternMatches_2EPMATCH_2E0(A_27a,A_27b),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EPMATCH_2E2_2Emono_2EA_27c_20mono_2EA_27b,axiom,
    ! [A_27b: $tType,A_27c: $tType,X0_2E0: A_27b,X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))] : ( c_2EpatternMatches_2EPMATCH_2E2(A_27c,A_27b,X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),A_27c,app_2E2(A_27b,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),A_27c),c_2EpatternMatches_2EPMATCH_2E0(A_27c,A_27b),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EPMATCH_2E2_2Emono_2EA_27a_20mono_2EA_27c,axiom,
    ! [A_27a: $tType,A_27c: $tType,X0_2E0: A_27c,X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a)))] : ( c_2EpatternMatches_2EPMATCH_2E2(A_27a,A_27c,X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))),A_27a,app_2E2(A_27c,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))),A_27a),c_2EpatternMatches_2EPMATCH_2E0(A_27a,A_27c),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E2_2Emono_2EA_27a_20mono_2EA_27b,axiom,
    ! [A_27a: $tType,A_27b: $tType,X0_2E0: A_27a,X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))] : ( c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E2(A_27a,A_27b,X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Ebool),app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Ebool)),c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E0(A_27a,A_27b),X0_2E0),X1_2E0) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3_2Emono_2EA_27a_20mono_2EA_27b,axiom,
    ! [A_27a: $tType,A_27b: $tType,X0_2E0: A_27a,X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X2_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))] : ( c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(A_27a,A_27b,X0_2E0,X1_2E0,X2_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Ebool,app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Ebool),app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Ebool)),c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E0(A_27a,A_27b),X0_2E0),X1_2E0),X2_2E0) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3_2Emono_2EA_27a_20mono_2EA_27c,axiom,
    ! [A_27a: $tType,A_27c: $tType,X0_2E0: A_27a,X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),X2_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)))] : ( c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(A_27a,A_27c,X0_2E0,X1_2E0,X2_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Ebool,app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Ebool),app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Ebool)),c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E0(A_27a,A_27c),X0_2E0),X1_2E0),X2_2E0) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E2_2Emono_2EA_27b_20mono_2EA_27a,axiom,
    ! [A_27a: $tType,A_27b: $tType,X0_2E0: A_27b,X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)))] : ( c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E2(A_27b,A_27a,X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Emin_2Ebool),app_2E2(A_27b,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Emin_2Ebool)),c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E0(A_27b,A_27a),X0_2E0),X1_2E0) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E3_2Emono_2EA_27d_20mono_2EA_27a_20mono_2EA_27b,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27d: $tType,X0_2E0: tyop_2Emin_2Efun(A_27a,A_27b),X1_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),X2_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d)))] : ( c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E3(A_27d,A_27a,A_27b,X0_2E0,X1_2E0,X2_2E0) = app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27d)),app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27d))),app_2E2(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27d)))),c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E0(A_27d,A_27a,A_27b),X0_2E0),X1_2E0),X2_2E0) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E3_2Emono_2EA_27c_20mono_2EA_27b_20mono_2EA_27a,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,X0_2E0: tyop_2Emin_2Efun(A_27b,A_27a),X1_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X2_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))] : ( c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E3(A_27c,A_27b,A_27a,X0_2E0,X1_2E0,X2_2E0) = app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),app_2E2(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)))),c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E0(A_27c,A_27b,A_27a),X0_2E0),X1_2E0),X2_2E0) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E4_2Emono_2EA_27a_20mono_2EA_27b_20mono_2EA_27c,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,X0_2E0: tyop_2Emin_2Efun(A_27b,A_27c),X1_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X2_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),X3_2E0: A_27c] : ( c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E4(A_27a,A_27b,A_27c,X0_2E0,X1_2E0,X2_2E0,X3_2E0) = app_2E2(A_27c,tyop_2Eoption_2Eoption(A_27a),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a)),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))),app_2E2(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a)))),c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E0(A_27a,A_27b,A_27c),X0_2E0),X1_2E0),X2_2E0),X3_2E0) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2_2Emono_2EA_27a_20mono_2EA_27b,axiom,
    ! [A_27a: $tType,A_27b: $tType,X0_2E0: A_27a,X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))] : ( c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2(A_27a,A_27b,X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Ebool,app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Ebool),c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E0(A_27a,A_27b),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2_2Emono_2EA_27b_20mono_2EA_27c,axiom,
    ! [A_27b: $tType,A_27c: $tType,X0_2E0: A_27b,X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))] : ( c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2(A_27b,A_27c,X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Ebool,app_2E2(A_27b,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Ebool),c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E0(A_27b,A_27c),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2_2Emono_2EA_27c_20mono_2EA_27d,axiom,
    ! [A_27c: $tType,A_27d: $tType,X0_2E0: A_27c,X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d)))] : ( c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2(A_27c,A_27d,X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d))),tyop_2Emin_2Ebool,app_2E2(A_27c,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d))),tyop_2Emin_2Ebool),c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E0(A_27c,A_27d),X0_2E0),X1_2E0) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW_2E3_2Emono_2EA_27c_20mono_2EA_27a_20mono_2EA_27b,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,X0_2E0: tyop_2Emin_2Efun(A_27a,A_27b),X1_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),X2_2E0: tyop_2Emin_2Efun(A_27a,A_27c)] : ( c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27c,A_27a,A_27b,X0_2E0,X1_2E0,X2_2E0) = app_2E2(tyop_2Emin_2Efun(A_27a,A_27c),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27c),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),app_2E2(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27c),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),c_2EpatternMatches_2EPMATCH__ROW_2E0(A_27c,A_27a,A_27b),X0_2E0),X1_2E0),X2_2E0) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EPMATCH__ROW_2E4_2Emono_2EA_27c_20mono_2EA_27a_20mono_2EA_27b,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,X0_2E0: tyop_2Emin_2Efun(A_27a,A_27b),X1_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),X2_2E0: tyop_2Emin_2Efun(A_27a,A_27c),X3_2E0: A_27b] : ( c_2EpatternMatches_2EPMATCH__ROW_2E4(A_27c,A_27a,A_27b,X0_2E0,X1_2E0,X2_2E0,X3_2E0) = app_2E2(A_27b,tyop_2Eoption_2Eoption(A_27c),app_2E2(tyop_2Emin_2Efun(A_27a,A_27c),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27c),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),app_2E2(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27c),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),c_2EpatternMatches_2EPMATCH__ROW_2E0(A_27c,A_27a,A_27b),X0_2E0),X1_2E0),X2_2E0),X3_2E0) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW_2E3_2Emono_2EA_27d_20mono_2EA_27a_20mono_2EA_27c,axiom,
    ! [A_27a: $tType,A_27c: $tType,A_27d: $tType,X0_2E0: tyop_2Emin_2Efun(A_27a,A_27c),X1_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),X2_2E0: tyop_2Emin_2Efun(A_27a,A_27d)] : ( c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27d,A_27a,A_27c,X0_2E0,X1_2E0,X2_2E0) = app_2E2(tyop_2Emin_2Efun(A_27a,A_27d),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d)),app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27d),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d))),app_2E2(tyop_2Emin_2Efun(A_27a,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27d),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d)))),c_2EpatternMatches_2EPMATCH__ROW_2E0(A_27d,A_27a,A_27c),X0_2E0),X1_2E0),X2_2E0) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW_2E3_2Emono_2EA_27c_20mono_2EA_27b_20mono_2EA_27a,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,X0_2E0: tyop_2Emin_2Efun(A_27b,A_27a),X1_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X2_2E0: tyop_2Emin_2Efun(A_27b,A_27c)] : ( c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27c,A_27b,A_27a,X0_2E0,X1_2E0,X2_2E0) = app_2E2(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),app_2E2(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)))),c_2EpatternMatches_2EPMATCH__ROW_2E0(A_27c,A_27b,A_27a),X0_2E0),X1_2E0),X2_2E0) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EPMATCH__ROW_2E4_2Emono_2EA_27c_20mono_2EA_27b_20mono_2EA_27a,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,X0_2E0: tyop_2Emin_2Efun(A_27b,A_27a),X1_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X2_2E0: tyop_2Emin_2Efun(A_27b,A_27c),X3_2E0: A_27a] : ( c_2EpatternMatches_2EPMATCH__ROW_2E4(A_27c,A_27b,A_27a,X0_2E0,X1_2E0,X2_2E0,X3_2E0) = app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27c),app_2E2(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),app_2E2(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)))),c_2EpatternMatches_2EPMATCH__ROW_2E0(A_27c,A_27b,A_27a),X0_2E0),X1_2E0),X2_2E0),X3_2E0) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW_2E3_2Emono_2EA_27d_20mono_2EA_27b_20mono_2EA_27a,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27d: $tType,X0_2E0: tyop_2Emin_2Efun(A_27b,A_27a),X1_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X2_2E0: tyop_2Emin_2Efun(A_27b,A_27d)] : ( c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27d,A_27b,A_27a,X0_2E0,X1_2E0,X2_2E0) = app_2E2(tyop_2Emin_2Efun(A_27b,A_27d),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d)),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27d),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d))),app_2E2(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27d),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d)))),c_2EpatternMatches_2EPMATCH__ROW_2E0(A_27d,A_27b,A_27a),X0_2E0),X1_2E0),X2_2E0) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW_2E3_2Emono_2EA_27a_20mono_2EA_27b_20mono_2EA_27b,axiom,
    ! [A_27a: $tType,A_27b: $tType,X0_2E0: tyop_2Emin_2Efun(A_27b,A_27b),X1_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X2_2E0: tyop_2Emin_2Efun(A_27b,A_27a)] : ( c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27a,A_27b,A_27b,X0_2E0,X1_2E0,X2_2E0) = app_2E2(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),app_2E2(tyop_2Emin_2Efun(A_27b,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)))),c_2EpatternMatches_2EPMATCH__ROW_2E0(A_27a,A_27b,A_27b),X0_2E0),X1_2E0),X2_2E0) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW_2E3_2Emono_2EA_27a_20mono_2EA_27b_20mono_2EA_27c,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,X0_2E0: tyop_2Emin_2Efun(A_27b,A_27c),X1_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X2_2E0: tyop_2Emin_2Efun(A_27b,A_27a)] : ( c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27a,A_27b,A_27c,X0_2E0,X1_2E0,X2_2E0) = app_2E2(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a)),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))),app_2E2(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a)))),c_2EpatternMatches_2EPMATCH__ROW_2E0(A_27a,A_27b,A_27c),X0_2E0),X1_2E0),X2_2E0) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EPMATCH__ROW_2E4_2Emono_2EA_27a_20mono_2EA_27b_20mono_2EA_27c,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,X0_2E0: tyop_2Emin_2Efun(A_27b,A_27c),X1_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X2_2E0: tyop_2Emin_2Efun(A_27b,A_27a),X3_2E0: A_27c] : ( c_2EpatternMatches_2EPMATCH__ROW_2E4(A_27a,A_27b,A_27c,X0_2E0,X1_2E0,X2_2E0,X3_2E0) = app_2E2(A_27c,tyop_2Eoption_2Eoption(A_27a),app_2E2(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a)),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))),app_2E2(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a)))),c_2EpatternMatches_2EPMATCH__ROW_2E0(A_27a,A_27b,A_27c),X0_2E0),X1_2E0),X2_2E0),X3_2E0) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW_2E3_2Emono_2EA_27d_20mono_2EA_27b_20mono_2EA_27c,axiom,
    ! [A_27b: $tType,A_27c: $tType,A_27d: $tType,X0_2E0: tyop_2Emin_2Efun(A_27b,A_27c),X1_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X2_2E0: tyop_2Emin_2Efun(A_27b,A_27d)] : ( c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27d,A_27b,A_27c,X0_2E0,X1_2E0,X2_2E0) = app_2E2(tyop_2Emin_2Efun(A_27b,A_27d),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d)),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27d),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d))),app_2E2(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27d),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d)))),c_2EpatternMatches_2EPMATCH__ROW_2E0(A_27d,A_27b,A_27c),X0_2E0),X1_2E0),X2_2E0) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW_2E3_2Emono_2EA_27b_20mono_2EA_27c_20mono_2EA_27a,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,X0_2E0: tyop_2Emin_2Efun(A_27c,A_27a),X1_2E0: tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),X2_2E0: tyop_2Emin_2Efun(A_27c,A_27b)] : ( c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27b,A_27c,A_27a,X0_2E0,X1_2E0,X2_2E0) = app_2E2(tyop_2Emin_2Efun(A_27c,A_27b),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),app_2E2(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27b),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),app_2E2(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27b),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))),c_2EpatternMatches_2EPMATCH__ROW_2E0(A_27b,A_27c,A_27a),X0_2E0),X1_2E0),X2_2E0) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW_2E3_2Emono_2EA_27d_20mono_2EA_27c_20mono_2EA_27a,axiom,
    ! [A_27a: $tType,A_27c: $tType,A_27d: $tType,X0_2E0: tyop_2Emin_2Efun(A_27c,A_27a),X1_2E0: tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),X2_2E0: tyop_2Emin_2Efun(A_27c,A_27d)] : ( c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27d,A_27c,A_27a,X0_2E0,X1_2E0,X2_2E0) = app_2E2(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d)),app_2E2(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d))),app_2E2(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d)))),c_2EpatternMatches_2EPMATCH__ROW_2E0(A_27d,A_27c,A_27a),X0_2E0),X1_2E0),X2_2E0) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EPMATCH__ROW_2E4_2Emono_2EA_27d_20mono_2EA_27c_20mono_2EA_27a,axiom,
    ! [A_27a: $tType,A_27c: $tType,A_27d: $tType,X0_2E0: tyop_2Emin_2Efun(A_27c,A_27a),X1_2E0: tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),X2_2E0: tyop_2Emin_2Efun(A_27c,A_27d),X3_2E0: A_27a] : ( c_2EpatternMatches_2EPMATCH__ROW_2E4(A_27d,A_27c,A_27a,X0_2E0,X1_2E0,X2_2E0,X3_2E0) = app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27d),app_2E2(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d)),app_2E2(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d))),app_2E2(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d)))),c_2EpatternMatches_2EPMATCH__ROW_2E0(A_27d,A_27c,A_27a),X0_2E0),X1_2E0),X2_2E0),X3_2E0) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW_2E3_2Emono_2EA_27d_20mono_2EA_27c_20mono_2EA_27b,axiom,
    ! [A_27b: $tType,A_27c: $tType,A_27d: $tType,X0_2E0: tyop_2Emin_2Efun(A_27c,A_27b),X1_2E0: tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),X2_2E0: tyop_2Emin_2Efun(A_27c,A_27d)] : ( c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27d,A_27c,A_27b,X0_2E0,X1_2E0,X2_2E0) = app_2E2(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27d)),app_2E2(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27d))),app_2E2(tyop_2Emin_2Efun(A_27c,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27d)))),c_2EpatternMatches_2EPMATCH__ROW_2E0(A_27d,A_27c,A_27b),X0_2E0),X1_2E0),X2_2E0) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EPMATCH__ROW_2E4_2Emono_2EA_27d_20mono_2EA_27c_20mono_2EA_27b,axiom,
    ! [A_27b: $tType,A_27c: $tType,A_27d: $tType,X0_2E0: tyop_2Emin_2Efun(A_27c,A_27b),X1_2E0: tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),X2_2E0: tyop_2Emin_2Efun(A_27c,A_27d),X3_2E0: A_27b] : ( c_2EpatternMatches_2EPMATCH__ROW_2E4(A_27d,A_27c,A_27b,X0_2E0,X1_2E0,X2_2E0,X3_2E0) = app_2E2(A_27b,tyop_2Eoption_2Eoption(A_27d),app_2E2(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27d)),app_2E2(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27d))),app_2E2(tyop_2Emin_2Efun(A_27c,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27d)))),c_2EpatternMatches_2EPMATCH__ROW_2E0(A_27d,A_27c,A_27b),X0_2E0),X1_2E0),X2_2E0),X3_2E0) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EPMATCH__ROW_2E4_2Emono_2EA_27e_20mono_2EA_27c_20mono_2EA_27b,axiom,
    ! [A_27b: $tType,A_27c: $tType,A_27e: $tType,X0_2E0: tyop_2Emin_2Efun(A_27c,A_27b),X1_2E0: tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),X2_2E0: tyop_2Emin_2Efun(A_27c,A_27e),X3_2E0: A_27b] : ( c_2EpatternMatches_2EPMATCH__ROW_2E4(A_27e,A_27c,A_27b,X0_2E0,X1_2E0,X2_2E0,X3_2E0) = app_2E2(A_27b,tyop_2Eoption_2Eoption(A_27e),app_2E2(tyop_2Emin_2Efun(A_27c,A_27e),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27e)),app_2E2(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27e),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27e))),app_2E2(tyop_2Emin_2Efun(A_27c,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27e),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27e)))),c_2EpatternMatches_2EPMATCH__ROW_2E0(A_27e,A_27c,A_27b),X0_2E0),X1_2E0),X2_2E0),X3_2E0) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EPMATCH__ROW_2E4_2Emono_2EA_27e_20mono_2EA_27d_20mono_2EA_27a,axiom,
    ! [A_27a: $tType,A_27d: $tType,A_27e: $tType,X0_2E0: tyop_2Emin_2Efun(A_27d,A_27a),X1_2E0: tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),X2_2E0: tyop_2Emin_2Efun(A_27d,A_27e),X3_2E0: A_27a] : ( c_2EpatternMatches_2EPMATCH__ROW_2E4(A_27e,A_27d,A_27a,X0_2E0,X1_2E0,X2_2E0,X3_2E0) = app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27e),app_2E2(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27e)),app_2E2(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27e))),app_2E2(tyop_2Emin_2Efun(A_27d,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27e)))),c_2EpatternMatches_2EPMATCH__ROW_2E0(A_27e,A_27d,A_27a),X0_2E0),X1_2E0),X2_2E0),X3_2E0) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW_2E3_2Emono_2EA_27c_20mono_2EA_27d_20mono_2EA_27b,axiom,
    ! [A_27b: $tType,A_27c: $tType,A_27d: $tType,X0_2E0: tyop_2Emin_2Efun(A_27d,A_27b),X1_2E0: tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),X2_2E0: tyop_2Emin_2Efun(A_27d,A_27c)] : ( c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27c,A_27d,A_27b,X0_2E0,X1_2E0,X2_2E0) = app_2E2(tyop_2Emin_2Efun(A_27d,A_27c),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),app_2E2(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27c),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),app_2E2(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27c),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),c_2EpatternMatches_2EPMATCH__ROW_2E0(A_27c,A_27d,A_27b),X0_2E0),X1_2E0),X2_2E0) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EPMATCH__ROW_2E4_2Emono_2EA_27f_20mono_2EA_27d_20mono_2EA_27b,axiom,
    ! [A_27b: $tType,A_27d: $tType,A_27f: $tType,X0_2E0: tyop_2Emin_2Efun(A_27d,A_27b),X1_2E0: tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),X2_2E0: tyop_2Emin_2Efun(A_27d,A_27f),X3_2E0: A_27b] : ( c_2EpatternMatches_2EPMATCH__ROW_2E4(A_27f,A_27d,A_27b,X0_2E0,X1_2E0,X2_2E0,X3_2E0) = app_2E2(A_27b,tyop_2Eoption_2Eoption(A_27f),app_2E2(tyop_2Emin_2Efun(A_27d,A_27f),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27f)),app_2E2(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27f),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27f))),app_2E2(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27f),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27f)))),c_2EpatternMatches_2EPMATCH__ROW_2E0(A_27f,A_27d,A_27b),X0_2E0),X1_2E0),X2_2E0),X3_2E0) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EPMATCH__ROW_2E4_2Emono_2EA_27f_20mono_2EA_27e_20mono_2EA_27a,axiom,
    ! [A_27a: $tType,A_27e: $tType,A_27f: $tType,X0_2E0: tyop_2Emin_2Efun(A_27e,A_27a),X1_2E0: tyop_2Emin_2Efun(A_27e,tyop_2Emin_2Ebool),X2_2E0: tyop_2Emin_2Efun(A_27e,A_27f),X3_2E0: A_27a] : ( c_2EpatternMatches_2EPMATCH__ROW_2E4(A_27f,A_27e,A_27a,X0_2E0,X1_2E0,X2_2E0,X3_2E0) = app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27f),app_2E2(tyop_2Emin_2Efun(A_27e,A_27f),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27f)),app_2E2(tyop_2Emin_2Efun(A_27e,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27e,A_27f),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27f))),app_2E2(tyop_2Emin_2Efun(A_27e,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27e,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27e,A_27f),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27f)))),c_2EpatternMatches_2EPMATCH__ROW_2E0(A_27f,A_27e,A_27a),X0_2E0),X1_2E0),X2_2E0),X3_2E0) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EPMATCH__ROW__COND_2E4_2Emono_2EA_27a_20mono_2EA_27b,axiom,
    ! [A_27a: $tType,A_27b: $tType,X0_2E0: tyop_2Emin_2Efun(A_27a,A_27b),X1_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),X2_2E0: A_27b,X3_2E0: A_27a] : ( c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(A_27a,A_27b,X0_2E0,X1_2E0,X2_2E0,X3_2E0) = app_2E2(A_27a,tyop_2Emin_2Ebool,app_2E2(A_27b,tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)),app_2E2(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool))),c_2EpatternMatches_2EPMATCH__ROW__COND_2E0(A_27a,A_27b),X0_2E0),X1_2E0),X2_2E0),X3_2E0) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EPMATCH__ROW__COND_2E4_2Emono_2EA_27b_20mono_2EA_27a,axiom,
    ! [A_27a: $tType,A_27b: $tType,X0_2E0: tyop_2Emin_2Efun(A_27b,A_27a),X1_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X2_2E0: A_27a,X3_2E0: A_27b] : ( c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(A_27b,A_27a,X0_2E0,X1_2E0,X2_2E0,X3_2E0) = app_2E2(A_27b,tyop_2Emin_2Ebool,app_2E2(A_27a,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)),app_2E2(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool))),c_2EpatternMatches_2EPMATCH__ROW__COND_2E0(A_27b,A_27a),X0_2E0),X1_2E0),X2_2E0),X3_2E0) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EPMATCH__ROW__COND_2E4_2Emono_2EA_27b_20mono_2EA_27c,axiom,
    ! [A_27b: $tType,A_27c: $tType,X0_2E0: tyop_2Emin_2Efun(A_27b,A_27c),X1_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X2_2E0: A_27c,X3_2E0: A_27b] : ( c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(A_27b,A_27c,X0_2E0,X1_2E0,X2_2E0,X3_2E0) = app_2E2(A_27b,tyop_2Emin_2Ebool,app_2E2(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)),app_2E2(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool))),c_2EpatternMatches_2EPMATCH__ROW__COND_2E0(A_27b,A_27c),X0_2E0),X1_2E0),X2_2E0),X3_2E0) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EPMATCH__ROW__COND_2E4_2Emono_2EA_27c_20mono_2EA_27a,axiom,
    ! [A_27a: $tType,A_27c: $tType,X0_2E0: tyop_2Emin_2Efun(A_27c,A_27a),X1_2E0: tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),X2_2E0: A_27a,X3_2E0: A_27c] : ( c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(A_27c,A_27a,X0_2E0,X1_2E0,X2_2E0,X3_2E0) = app_2E2(A_27c,tyop_2Emin_2Ebool,app_2E2(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),app_2E2(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool))),c_2EpatternMatches_2EPMATCH__ROW__COND_2E0(A_27c,A_27a),X0_2E0),X1_2E0),X2_2E0),X3_2E0) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EPMATCH__ROW__COND_2E4_2Emono_2EA_27d_20mono_2EA_27b,axiom,
    ! [A_27b: $tType,A_27d: $tType,X0_2E0: tyop_2Emin_2Efun(A_27d,A_27b),X1_2E0: tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),X2_2E0: A_27b,X3_2E0: A_27d] : ( c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(A_27d,A_27b,X0_2E0,X1_2E0,X2_2E0,X3_2E0) = app_2E2(A_27d,tyop_2Emin_2Ebool,app_2E2(A_27b,tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool)),app_2E2(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool))),c_2EpatternMatches_2EPMATCH__ROW__COND_2E0(A_27d,A_27b),X0_2E0),X1_2E0),X2_2E0),X3_2E0) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3_2Emono_2EA_27a_20mono_2EA_27b,axiom,
    ! [A_27a: $tType,A_27b: $tType,X0_2E0: A_27a,X1_2E0: tyop_2Emin_2Efun(A_27b,A_27a),X2_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)] : ( c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(A_27a,A_27b,X0_2E0,X1_2E0,X2_2E0) = app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)),c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E0(A_27a,A_27b),X0_2E0),X1_2E0),X2_2E0) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3_2Emono_2EA_27a_20mono_2EA_27c,axiom,
    ! [A_27a: $tType,A_27c: $tType,X0_2E0: A_27a,X1_2E0: tyop_2Emin_2Efun(A_27c,A_27a),X2_2E0: tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)] : ( c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(A_27a,A_27c,X0_2E0,X1_2E0,X2_2E0) = app_2E2(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)),c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E0(A_27a,A_27c),X0_2E0),X1_2E0),X2_2E0) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3_2Emono_2EA_27c_20mono_2EA_27a,axiom,
    ! [A_27a: $tType,A_27c: $tType,X0_2E0: A_27c,X1_2E0: tyop_2Emin_2Efun(A_27a,A_27c),X2_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)] : ( c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(A_27c,A_27a,X0_2E0,X1_2E0,X2_2E0) = app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Efun(A_27a,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),app_2E2(A_27c,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)),c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E0(A_27c,A_27a),X0_2E0),X1_2E0),X2_2E0) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3_2Emono_2EA_27c_20mono_2EA_27b,axiom,
    ! [A_27b: $tType,A_27c: $tType,X0_2E0: A_27c,X1_2E0: tyop_2Emin_2Efun(A_27b,A_27c),X2_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)] : ( c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(A_27c,A_27b,X0_2E0,X1_2E0,X2_2E0) = app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),app_2E2(A_27c,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)),c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E0(A_27c,A_27b),X0_2E0),X1_2E0),X2_2E0) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E3_2Emono_2EA_27a_20mono_2EA_27b,axiom,
    ! [A_27a: $tType,A_27b: $tType,X0_2E0: A_27a,X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X2_2E0: tyop_2Enum_2Enum] : ( c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E3(A_27a,A_27b,X0_2E0,X1_2E0,X2_2E0) = app_2E2(tyop_2Enum_2Enum,tyop_2Emin_2Ebool,app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool)),c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E0(A_27a,A_27b),X0_2E0),X1_2E0),X2_2E0) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ_2E2,axiom,
    ! [X0_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool),X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool)] : ( c_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ_2E2(X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool),app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),c_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__DISJ_2E2,axiom,
    ! [X0_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool),X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool)] : ( c_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__DISJ_2E2(X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool),app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),c_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__DISJ_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq1_2Ec_2Epair_2ESND_2E1_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,axiom,
    ! [X0_2E0: tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool))] : ( c_2Epair_2ESND_2E1(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool),X0_2E0) = app_2E2(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),tyop_2Elist_2Elist(tyop_2Emin_2Ebool),c_2Epair_2ESND_2E0(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),X0_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2ESNOC_2E2_2Emono_2Etyop_2Emin_2Ebool,axiom,
    ! [X0_2E0: tyop_2Emin_2Ebool,X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool)] : ( c_2Elist_2ESNOC_2E2(tyop_2Emin_2Ebool,X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),c_2Elist_2ESNOC_2E0(tyop_2Emin_2Ebool),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2ESNOC_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27a_2Ctyop_2Eoption_2Eoption_28A_27b_29_29,axiom,
    ! [A_27a: $tType,A_27b: $tType,X0_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))] : ( c_2Elist_2ESNOC_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))),c_2Elist_2ESNOC_2E0(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2ESNOC_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27b_2Ctyop_2Eoption_2Eoption_28A_27a_29_29,axiom,
    ! [A_27a: $tType,A_27b: $tType,X0_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)))] : ( c_2Elist_2ESNOC_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)))),c_2Elist_2ESNOC_2E0(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2ESNOC_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27b_2Ctyop_2Eoption_2Eoption_28A_27c_29_29,axiom,
    ! [A_27b: $tType,A_27c: $tType,X0_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))] : ( c_2Elist_2ESNOC_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),c_2Elist_2ESNOC_2E0(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),X0_2E0),X1_2E0) ) ).

tff(arityeq1_2Ec_2Eoption_2ESOME_2E1_2Emono_2EA_27a,axiom,
    ! [A_27a: $tType,X0_2E0: A_27a] : ( c_2Eoption_2ESOME_2E1(A_27a,X0_2E0) = app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27a),c_2Eoption_2ESOME_2E0(A_27a),X0_2E0) ) ).

tff(arityeq1_2Ec_2Eoption_2ESOME_2E1_2Emono_2EA_27b,axiom,
    ! [A_27b: $tType,X0_2E0: A_27b] : ( c_2Eoption_2ESOME_2E1(A_27b,X0_2E0) = app_2E2(A_27b,tyop_2Eoption_2Eoption(A_27b),c_2Eoption_2ESOME_2E0(A_27b),X0_2E0) ) ).

tff(arityeq1_2Ec_2Eoption_2ESOME_2E1_2Emono_2EA_27c,axiom,
    ! [A_27c: $tType,X0_2E0: A_27c] : ( c_2Eoption_2ESOME_2E1(A_27c,X0_2E0) = app_2E2(A_27c,tyop_2Eoption_2Eoption(A_27c),c_2Eoption_2ESOME_2E0(A_27c),X0_2E0) ) ).

tff(arityeq1_2Ec_2Eoption_2ESOME_2E1_2Emono_2Etyop_2Emin_2Ebool,axiom,
    ! [X0_2E0: tyop_2Emin_2Ebool] : ( c_2Eoption_2ESOME_2E1(tyop_2Emin_2Ebool,X0_2E0) = app_2E2(tyop_2Emin_2Ebool,tyop_2Eoption_2Eoption(tyop_2Emin_2Ebool),c_2Eoption_2ESOME_2E0(tyop_2Emin_2Ebool),X0_2E0) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO_2E2_2Emono_2EA_27a_20mono_2EA_27b,axiom,
    ! [A_27a: $tType,A_27b: $tType,X0_2E0: A_27a,X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))] : ( c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO_2E2(A_27a,A_27b,X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Elist_2Elist(tyop_2Emin_2Ebool),app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO_2E0(A_27a,A_27b),X0_2E0),X1_2E0) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX_2E4_2Emono_2EA_27a_20mono_2EA_27b,axiom,
    ! [A_27a: $tType,A_27b: $tType,X0_2E0: A_27a,X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X2_2E0: tyop_2Emin_2Ebool,X3_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool)] : ( c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX_2E4(A_27a,A_27b,X0_2E0,X1_2E0,X2_2E0,X3_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool))),app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)))),app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool))))),c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX_2E0(A_27a,A_27b),X0_2E0),X1_2E0),X2_2E0),X3_2E0) ) ).

tff(arityeq1_2Ec_2Enum_2ESUC_2E1,axiom,
    ! [X0_2E0: tyop_2Enum_2Enum] : ( c_2Enum_2ESUC_2E1(X0_2E0) = app_2E2(tyop_2Enum_2Enum,tyop_2Enum_2Enum,c_2Enum_2ESUC_2E0,X0_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2ETAKE_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27a_2Ctyop_2Eoption_2Eoption_28A_27b_29_29,axiom,
    ! [A_27a: $tType,A_27b: $tType,X0_2E0: tyop_2Enum_2Enum,X1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))] : ( c_2Elist_2ETAKE_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),X0_2E0,X1_2E0) = app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),app_2E2(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))),c_2Elist_2ETAKE_2E0(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X0_2E0),X1_2E0) ) ).

tff(arityeq1_2Ec_2Elist_2EZIP_2E1_2Emono_2Etyop_2Emin_2Ebool_20mono_2EA_27a,axiom,
    ! [A_27a: $tType,X0_2E0: tyop_2Epair_2Eprod(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(A_27a))] : ( c_2Elist_2EZIP_2E1(tyop_2Emin_2Ebool,A_27a,X0_2E0) = app_2E2(tyop_2Epair_2Eprod(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(A_27a)),tyop_2Elist_2Elist(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a)),c_2Elist_2EZIP_2E0(tyop_2Emin_2Ebool,A_27a),X0_2E0) ) ).

tff(arityeq2_2Ec_2Ebool_2E_5C_2F_2E2,axiom,
    ! [X0_2E0: tyop_2Emin_2Ebool,X1_2E0: tyop_2Emin_2Ebool] :
      ( ( p(X0_2E0)
        | p(X1_2E0) )
    <=> p(app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),c_2Ebool_2E_5C_2F_2E0,X0_2E0),X1_2E0)) ) ).

tff(arityeq3_2Ec_2Eoption_2Eoption__CASE_2E3_2Emono_2EA_27a_20mono_2EA_27a,axiom,
    ! [A_27a: $tType,X0_2E0: tyop_2Eoption_2Eoption(A_27a),X1_2E0: A_27a,X2_2E0: tyop_2Emin_2Efun(A_27a,A_27a)] : ( c_2Eoption_2Eoption__CASE_2E3(A_27a,A_27a,X0_2E0,X1_2E0,X2_2E0) = app_2E2(tyop_2Emin_2Efun(A_27a,A_27a),A_27a,app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27a),A_27a),app_2E2(tyop_2Eoption_2Eoption(A_27a),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27a),A_27a)),c_2Eoption_2Eoption__CASE_2E0(A_27a,A_27a),X0_2E0),X1_2E0),X2_2E0) ) ).

tff(arityeq3_2Ec_2Eoption_2Eoption__CASE_2E3_2Emono_2EA_27b_20mono_2Etyop_2Eoption_2Eoption_28A_27a_29,axiom,
    ! [A_27a: $tType,A_27b: $tType,X0_2E0: tyop_2Eoption_2Eoption(A_27b),X1_2E0: tyop_2Eoption_2Eoption(A_27a),X2_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))] : ( c_2Eoption_2Eoption__CASE_2E3(A_27b,tyop_2Eoption_2Eoption(A_27a),X0_2E0,X1_2E0,X2_2E0) = app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),tyop_2Eoption_2Eoption(A_27a),app_2E2(tyop_2Eoption_2Eoption(A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),tyop_2Eoption_2Eoption(A_27a)),app_2E2(tyop_2Eoption_2Eoption(A_27b),tyop_2Emin_2Efun(tyop_2Eoption_2Eoption(A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),tyop_2Eoption_2Eoption(A_27a))),c_2Eoption_2Eoption__CASE_2E0(A_27b,tyop_2Eoption_2Eoption(A_27a)),X0_2E0),X1_2E0),X2_2E0) ) ).

tff(arityeq1_2Ec_2Eoption_2Esome_2E1_2Emono_2EA_27b,axiom,
    ! [A_27b: $tType,X0_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)] : ( c_2Eoption_2Esome_2E1(A_27b,X0_2E0) = app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Eoption_2Eoption(A_27b),c_2Eoption_2Esome_2E0(A_27b),X0_2E0) ) ).

tff(arityeq1_2Ec_2Eoption_2Esome_2E1_2Emono_2Etyop_2Emin_2Ebool,axiom,
    ! [X0_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool)] : ( c_2Eoption_2Esome_2E1(tyop_2Emin_2Ebool,X0_2E0) = app_2E2(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),tyop_2Eoption_2Eoption(tyop_2Emin_2Ebool),c_2Eoption_2Esome_2E0(tyop_2Emin_2Ebool),X0_2E0) ) ).

tff(arityeq1_2Ec_2Ebool_2E_7E_2E1,axiom,
    ! [X0_2E0: tyop_2Emin_2Ebool] :
      ( ~ p(X0_2E0)
    <=> p(app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool,c_2Ebool_2E_7E_2E0,X0_2E0)) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__COND__def,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0pat_2E0: tyop_2Emin_2Efun(A_27a,A_27b),V1guard_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V2inp_2E0: A_27b,V3v_2E0: A_27a] :
      ( p(c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(A_27a,A_27b,V0pat_2E0,V1guard_2E0,V2inp_2E0,V3v_2E0))
    <=> ( ( app_2E2(A_27a,A_27b,V0pat_2E0,V3v_2E0) = V2inp_2E0 )
        & p(app_2E2(A_27a,tyop_2Emin_2Ebool,V1guard_2E0,V3v_2E0)) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__def,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,F0_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool))))] :
      ( ! [V0pat_2E0: tyop_2Emin_2Efun(A_27b,A_27c),V1guard_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V3i_2E0: A_27c,V4v_2E0: A_27b] : ( app_2E2(A_27b,tyop_2Emin_2Ebool,app_2E2(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)),app_2E2(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool))),F0_2E0,V0pat_2E0),V1guard_2E0),V3i_2E0),V4v_2E0) = c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(A_27b,A_27c,V0pat_2E0,V1guard_2E0,V3i_2E0,V4v_2E0) )
     => ! [V0pat_2E0: tyop_2Emin_2Efun(A_27b,A_27c),V1guard_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V2rhs_2E0: tyop_2Emin_2Efun(A_27b,A_27a),V3i_2E0: A_27c] : ( c_2EpatternMatches_2EPMATCH__ROW_2E4(A_27a,A_27b,A_27c,V0pat_2E0,V1guard_2E0,V2rhs_2E0,V3i_2E0) = c_2Eoption_2EOPTION__MAP_2E2(A_27b,A_27a,V2rhs_2E0,c_2Eoption_2Esome_2E1(A_27b,app_2E2(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)),app_2E2(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool))),F0_2E0,V0pat_2E0),V1guard_2E0),V3i_2E0))) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__INCOMPLETE__def,axiom,
    ! [A_27a: $tType] : ( c_2EpatternMatches_2EPMATCH__INCOMPLETE_2E0(A_27a) = c_2Ebool_2EARB_2E0(A_27a) ) ).

tff(thm_2EpatternMatches_2EPMATCH__def,axiom,
    ! [A_27a: $tType,A_27b: $tType] :
      ( ! [V0v_2E0: A_27b] : ( c_2EpatternMatches_2EPMATCH_2E2(A_27a,A_27b,V0v_2E0,c_2Elist_2ENIL_2E0(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)))) = c_2EpatternMatches_2EPMATCH__INCOMPLETE_2E0(A_27a) )
      & ! [V1v_2E0: A_27b,V2r_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),V3rs_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)))] : ( c_2EpatternMatches_2EPMATCH_2E2(A_27a,A_27b,V1v_2E0,c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),V2r_2E0,V3rs_2E0)) = c_2Eoption_2Eoption__CASE_2E3(A_27a,A_27a,app_2E2(A_27b,tyop_2Eoption_2Eoption(A_27a),V2r_2E0,V1v_2E0),c_2EpatternMatches_2EPMATCH_2E2(A_27a,A_27b,V1v_2E0,V3rs_2E0),c_2Ecombin_2EI_2E0(A_27a)) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__EQUIV__ROWS__def,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0v_2E0: A_27a,V1rows1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows2_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))] :
      ( p(c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(A_27a,A_27b,V0v_2E0,V1rows1_2E0,V2rows2_2E0))
    <=> ( ( c_2EpatternMatches_2EPMATCH_2E2(A_27b,A_27a,V0v_2E0,V1rows1_2E0) = c_2EpatternMatches_2EPMATCH_2E2(A_27b,A_27a,V0v_2E0,V2rows2_2E0) )
        & ( ? [V3r_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))] :
              ( p(c_2Ebool_2EIN_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V3r_2E0,c_2Elist_2ELIST__TO__SET_2E1(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1rows1_2E0)))
              & p(c_2Eoption_2EIS__SOME_2E1(A_27b,app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),V3r_2E0,V0v_2E0))) )
        <=> ? [V4r_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))] :
              ( p(c_2Ebool_2EIN_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V4r_2E0,c_2Elist_2ELIST__TO__SET_2E1(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V2rows2_2E0)))
              & p(c_2Eoption_2EIS__SOME_2E1(A_27b,app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),V4r_2E0,V0v_2E0))) ) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__REDUNDANT__def,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0v_2E0: A_27a,V1rs_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2i_2E0: tyop_2Enum_2Enum] :
      ( p(c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E3(A_27a,A_27b,V0v_2E0,V1rs_2E0,V2i_2E0))
    <=> ( p(c_2Eprim__rec_2E_3C_2E2(V2i_2E0,c_2Elist_2ELENGTH_2E1(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1rs_2E0)))
        & ( p(c_2Eoption_2EIS__SOME_2E1(A_27b,app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),c_2Elist_2EEL_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V2i_2E0,V1rs_2E0),V0v_2E0)))
         => ? [V3j_2E0: tyop_2Enum_2Enum] :
              ( p(c_2Eprim__rec_2E_3C_2E2(V3j_2E0,V2i_2E0))
              & p(c_2Eoption_2EIS__SOME_2E1(A_27b,app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),c_2Elist_2EEL_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V3j_2E0,V1rs_2E0),V0v_2E0))) ) ) ) ) ).

tff(thm_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO__def,axiom,
    ! [A_27a: $tType,A_27b: $tType,F0_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool))] :
      ( ! [V0v_2E0: A_27a,V5r_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))] :
          ( p(app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool,app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),F0_2E0,V0v_2E0),V5r_2E0))
        <=> ( app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),V5r_2E0,V0v_2E0) = c_2Eoption_2ENONE_2E0(A_27b) ) )
     => ! [V0v_2E0: A_27a,V1rows_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2c_2E0: tyop_2Emin_2Ebool,V3infos_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool)] :
          ( p(c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(A_27a,A_27b,V0v_2E0,V1rows_2E0,V2c_2E0,V3infos_2E0))
        <=> ( ( c_2Elist_2ELENGTH_2E1(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1rows_2E0) = c_2Elist_2ELENGTH_2E1(tyop_2Emin_2Ebool,V3infos_2E0) )
            & ! [V4i_2E0: tyop_2Enum_2Enum] :
                ( p(c_2Eprim__rec_2E_3C_2E2(V4i_2E0,c_2Elist_2ELENGTH_2E1(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1rows_2E0)))
               => ( p(c_2Elist_2EEL_2E2(tyop_2Emin_2Ebool,V4i_2E0,V3infos_2E0))
                 => p(c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E3(A_27a,A_27b,V0v_2E0,V1rows_2E0,V4i_2E0)) ) )
            & ( p(c_2Elist_2EEVERY_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),F0_2E0,V0v_2E0),V1rows_2E0))
             => p(V2c_2E0) ) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__COND__EX__def,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0i_2E0: A_27a,V1p_2E0: tyop_2Emin_2Efun(A_27b,A_27a),V2g_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)] :
      ( p(c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(A_27a,A_27b,V0i_2E0,V1p_2E0,V2g_2E0))
    <=> ? [V3x_2E0: A_27b] : p(c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(A_27b,A_27a,V1p_2E0,V2g_2E0,V0i_2E0,V3x_2E0)) ) ).

tff(thm_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO__def,axiom,
    ! [A_27a: $tType,F0_2E0: tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a),tyop_2Emin_2Ebool)] :
      ( ! [V2x_2E0: tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a)] :
          ( p(app_2E2(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a),tyop_2Emin_2Ebool,F0_2E0,V2x_2E0))
        <=> ~ p(c_2Epair_2EFST_2E1(tyop_2Emin_2Ebool,A_27a,V2x_2E0)) )
     => ! [V0is_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool),V1xs_2E0: tyop_2Elist_2Elist(A_27a)] : ( c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2(A_27a,V0is_2E0,V1xs_2E0) = c_2Elist_2EMAP_2E2(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a),A_27a,c_2Epair_2ESND_2E0(tyop_2Emin_2Ebool,A_27a),c_2Elist_2EFILTER_2E2(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a),F0_2E0,c_2Elist_2EZIP_2E1(tyop_2Emin_2Ebool,A_27a,c_2Epair_2E_2C_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(A_27a),V0is_2E0,V1xs_2E0)))) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE__def,axiom,
    ! [A_27a: $tType,A_27b: $tType,F0_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool))] :
      ( ! [V0v_2E0: A_27a,V2r_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))] : ( app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool,app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),F0_2E0,V0v_2E0),V2r_2E0) = c_2Eoption_2EIS__SOME_2E1(A_27b,app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),V2r_2E0,V0v_2E0)) )
     => ! [V0v_2E0: A_27a,V1rs_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))] : ( c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2(A_27a,A_27b,V0v_2E0,V1rs_2E0) = c_2Elist_2EEXISTS_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),F0_2E0,V0v_2E0),V1rs_2E0) ) ) ).

tff(thm_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ__def,axiom,
    ! [F0_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool))] :
      ( ! [V2i1_2E0: tyop_2Emin_2Ebool,V3i2_2E0: tyop_2Emin_2Ebool] :
          ( p(app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),F0_2E0,V2i1_2E0),V3i2_2E0))
        <=> ( p(V2i1_2E0)
            & p(V3i2_2E0) ) )
     => ! [V0ip1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool),V1ip2_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool)] : ( c_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ_2E2(V0ip1_2E0,V1ip2_2E0) = c_2Elist_2EMAP2_2E3(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool,tyop_2Emin_2Ebool,F0_2E0,V0ip1_2E0,V1ip2_2E0) ) ) ).

tff(thm_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__DISJ__def,axiom,
    ! [F0_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool))] :
      ( ! [V2i1_2E0: tyop_2Emin_2Ebool,V3i2_2E0: tyop_2Emin_2Ebool] :
          ( p(app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),F0_2E0,V2i1_2E0),V3i2_2E0))
        <=> ( p(V2i1_2E0)
            | p(V3i2_2E0) ) )
     => ! [V0ip1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool),V1ip2_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool)] : ( c_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__DISJ_2E2(V0ip1_2E0,V1ip2_2E0) = c_2Elist_2EMAP2_2E3(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool,tyop_2Emin_2Ebool,F0_2E0,V0ip1_2E0,V1ip2_2E0) ) ) ).

tff(thm_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX__def,axiom,
    ! [A_27a: $tType,A_27b: $tType,F1_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool))),F0_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)))] :
      ( ! [V6p_2E0: tyop_2Emin_2Ebool,V4r_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V3v_2E0: A_27a] :
          ( p(app_2E2(A_27a,tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)),F1_2E0,V6p_2E0),V4r_2E0),V3v_2E0))
        <=> ( p(V6p_2E0)
           => ( app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),V4r_2E0,V3v_2E0) = c_2Eoption_2ENONE_2E0(A_27b) ) ) )
     => ( ! [V6p_2E0: tyop_2Emin_2Ebool,V4r_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V3v_2E0: A_27a] :
            ( p(app_2E2(A_27a,tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)),F0_2E0,V6p_2E0),V4r_2E0),V3v_2E0))
          <=> ( p(V6p_2E0)
              & ( app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),V4r_2E0,V3v_2E0) = c_2Eoption_2ENONE_2E0(A_27b) ) ) )
       => ( ! [V0v_2E0: A_27a,V1p_2E0: tyop_2Emin_2Ebool,V2infos_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool)] : ( c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX_2E4(A_27a,A_27b,V0v_2E0,c_2Elist_2ENIL_2E0(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1p_2E0,V2infos_2E0) = c_2Epair_2E_2C_2E2(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool),V1p_2E0,V2infos_2E0) )
          & ! [V3v_2E0: A_27a,V4r_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V5rows_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V6p_2E0: tyop_2Emin_2Ebool,V7infos_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool)] : ( c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX_2E4(A_27a,A_27b,V3v_2E0,c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V4r_2E0,V5rows_2E0),V6p_2E0,V7infos_2E0) = c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX_2E4(A_27a,A_27b,V3v_2E0,V5rows_2E0,app_2E2(A_27a,tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)),F0_2E0,V6p_2E0),V4r_2E0),V3v_2E0),c_2Elist_2ESNOC_2E2(tyop_2Emin_2Ebool,app_2E2(A_27a,tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)),F1_2E0,V6p_2E0),V4r_2E0),V3v_2E0),V7infos_2E0)) ) ) ) ) ).

tff(thm_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__def,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0v_2E0: A_27a,V1rows_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))] : ( c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO_2E2(A_27a,A_27b,V0v_2E0,V1rows_2E0) = c_2Epair_2ESND_2E1(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool),c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX_2E4(A_27a,A_27b,V0v_2E0,V1rows_2E0,c_2Ebool_2ET_2E0,c_2Elist_2ENIL_2E0(tyop_2Emin_2Ebool))) ) ).

tff(thm_2EpatternMatches_2EPMATCH__FLATTEN__FUN__def,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,F1_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),F0_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool))))] :
      ( ! [V2row_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),V5x_2E0: A_27b] : ( app_2E2(A_27b,tyop_2Eoption_2Eoption(A_27a),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),F1_2E0,V2row_2E0),V5x_2E0) = app_2E2(A_27b,tyop_2Eoption_2Eoption(A_27a),app_2E2(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),V2row_2E0,V5x_2E0),V5x_2E0) )
     => ( ! [V0p_2E0: tyop_2Emin_2Efun(A_27b,A_27c),V1g_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V3v_2E0: A_27c,V4x_2E0: A_27b] : ( app_2E2(A_27b,tyop_2Emin_2Ebool,app_2E2(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)),app_2E2(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool))),F0_2E0,V0p_2E0),V1g_2E0),V3v_2E0),V4x_2E0) = c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(A_27b,A_27c,V0p_2E0,V1g_2E0,V3v_2E0,V4x_2E0) )
       => ! [V0p_2E0: tyop_2Emin_2Efun(A_27b,A_27c),V1g_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V2row_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),V3v_2E0: A_27c] : ( c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E4(A_27a,A_27b,A_27c,V0p_2E0,V1g_2E0,V2row_2E0,V3v_2E0) = c_2Eoption_2Eoption__CASE_2E3(A_27b,tyop_2Eoption_2Eoption(A_27a),c_2Eoption_2Esome_2E1(A_27b,app_2E2(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)),app_2E2(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool))),F0_2E0,V0p_2E0),V1g_2E0),V3v_2E0)),c_2Eoption_2ENONE_2E0(A_27a),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),F1_2E0,V2row_2E0)) ) ) ) ).

tff(thm_2EpatternMatches_2ELENGTH__STRONGEST__REDUNDANT__ROWS__INFO,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0v_2E0: A_27a,V1rows_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))] : ( c_2Elist_2ELENGTH_2E1(tyop_2Emin_2Ebool,c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO_2E2(A_27a,A_27b,V0v_2E0,V1rows_2E0)) = c_2Elist_2ELENGTH_2E1(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1rows_2E0) ) ).

tff(thm_2EpatternMatches_2EEL2__STRONGEST__REDUNDANT__ROWS__INFO__AUX,axiom,
    ! [A_27a: $tType,A_27b: $tType,F0_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool))] :
      ( ! [V0v_2E0: A_27a,V5r_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))] :
          ( p(app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool,app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),F0_2E0,V0v_2E0),V5r_2E0))
        <=> ( app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),V5r_2E0,V0v_2E0) = c_2Eoption_2ENONE_2E0(A_27b) ) )
     => ! [V0v_2E0: A_27a,V1rows_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2p_2E0: tyop_2Emin_2Ebool,V3infos_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool),V4i_2E0: tyop_2Enum_2Enum] :
          ( ( p(c_2Earithmetic_2E_3E_3D_2E2(V4i_2E0,c_2Elist_2ELENGTH_2E1(tyop_2Emin_2Ebool,V3infos_2E0)))
            & p(c_2Eprim__rec_2E_3C_2E2(V4i_2E0,c_2Earithmetic_2E_2B_2E2(c_2Elist_2ELENGTH_2E1(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1rows_2E0),c_2Elist_2ELENGTH_2E1(tyop_2Emin_2Ebool,V3infos_2E0)))) )
         => ( p(c_2Elist_2EEL_2E2(tyop_2Emin_2Ebool,V4i_2E0,c_2Epair_2ESND_2E1(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool),c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX_2E4(A_27a,A_27b,V0v_2E0,V1rows_2E0,V2p_2E0,V3infos_2E0))))
          <=> ( ( p(V2p_2E0)
                & p(c_2Elist_2EEVERY_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),F0_2E0,V0v_2E0),c_2Elist_2ETAKE_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),c_2Earithmetic_2E_2D_2E2(V4i_2E0,c_2Elist_2ELENGTH_2E1(tyop_2Emin_2Ebool,V3infos_2E0)),V1rows_2E0))) )
             => ( app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),c_2Elist_2EEL_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),c_2Earithmetic_2E_2D_2E2(V4i_2E0,c_2Elist_2ELENGTH_2E1(tyop_2Emin_2Ebool,V3infos_2E0)),V1rows_2E0),V0v_2E0) = c_2Eoption_2ENONE_2E0(A_27b) ) ) ) ) ) ).

tff(thm_2EpatternMatches_2EEL1__STRONGEST__REDUNDANT__ROWS__INFO__AUX,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0v_2E0: A_27a,V1rows_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2p_2E0: tyop_2Emin_2Ebool,V3infos_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool),V4i_2E0: tyop_2Enum_2Enum] :
      ( p(c_2Eprim__rec_2E_3C_2E2(V4i_2E0,c_2Elist_2ELENGTH_2E1(tyop_2Emin_2Ebool,V3infos_2E0)))
     => ( c_2Elist_2EEL_2E2(tyop_2Emin_2Ebool,V4i_2E0,c_2Epair_2ESND_2E1(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool),c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX_2E4(A_27a,A_27b,V0v_2E0,V1rows_2E0,V2p_2E0,V3infos_2E0))) = c_2Elist_2EEL_2E2(tyop_2Emin_2Ebool,V4i_2E0,V3infos_2E0) ) ) ).

tff(thm_2EpatternMatches_2Esome__var__bool__T,axiom,
    ! [F0_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool)] :
      ( ! [V0x_2E0: tyop_2Emin_2Ebool] : ( app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool,F0_2E0,V0x_2E0) = V0x_2E0 )
     => ( c_2Eoption_2Esome_2E1(tyop_2Emin_2Ebool,F0_2E0) = c_2Eoption_2ESOME_2E1(tyop_2Emin_2Ebool,c_2Ebool_2ET_2E0) ) ) ).

tff(thm_2EpatternMatches_2Esome__var__bool__F,axiom,
    ! [F0_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool)] :
      ( ! [V0x_2E0: tyop_2Emin_2Ebool] :
          ( p(app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool,F0_2E0,V0x_2E0))
        <=> ~ p(V0x_2E0) )
     => ( c_2Eoption_2Esome_2E1(tyop_2Emin_2Ebool,F0_2E0) = c_2Eoption_2ESOME_2E1(tyop_2Emin_2Ebool,c_2Ebool_2EF_2E0) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__CONG,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,V0p_2E0: tyop_2Emin_2Efun(A_27a,A_27b),V1p_27_2E0: tyop_2Emin_2Efun(A_27a,A_27b),V2g_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V3g_27_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V4r_2E0: tyop_2Emin_2Efun(A_27a,A_27c),V5r_27_2E0: tyop_2Emin_2Efun(A_27a,A_27c),V6v_2E0: A_27b,V7v_27_2E0: A_27b] :
      ( ( ( V0p_2E0 = V1p_27_2E0 )
        & ( V6v_2E0 = V7v_27_2E0 )
        & ! [V8x_2E0: A_27a] :
            ( ( V6v_2E0 = app_2E2(A_27a,A_27b,V0p_2E0,V8x_2E0) )
           => ( app_2E2(A_27a,tyop_2Emin_2Ebool,V2g_2E0,V8x_2E0) = app_2E2(A_27a,tyop_2Emin_2Ebool,V3g_27_2E0,V8x_2E0) ) )
        & ! [V9x_2E0: A_27a] :
            ( ( ( V6v_2E0 = app_2E2(A_27a,A_27b,V0p_2E0,V9x_2E0) )
              & p(app_2E2(A_27a,tyop_2Emin_2Ebool,V2g_2E0,V9x_2E0)) )
           => ( app_2E2(A_27a,A_27c,V4r_2E0,V9x_2E0) = app_2E2(A_27a,A_27c,V5r_27_2E0,V9x_2E0) ) ) )
     => ( c_2EpatternMatches_2EPMATCH__ROW_2E4(A_27c,A_27a,A_27b,V0p_2E0,V2g_2E0,V4r_2E0,V6v_2E0) = c_2EpatternMatches_2EPMATCH__ROW_2E4(A_27c,A_27a,A_27b,V1p_27_2E0,V3g_27_2E0,V5r_27_2E0,V7v_27_2E0) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__CONG,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0v_2E0: A_27a,V1v_27_2E0: A_27a,V2rows_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V3rows_27_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V4r_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V5r_27_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))] :
      ( ( ( V0v_2E0 = V1v_27_2E0 )
        & ( app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),V4r_2E0,V1v_27_2E0) = app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),V5r_27_2E0,V1v_27_2E0) )
        & ( c_2EpatternMatches_2EPMATCH_2E2(A_27b,A_27a,V1v_27_2E0,V2rows_2E0) = c_2EpatternMatches_2EPMATCH_2E2(A_27b,A_27a,V1v_27_2E0,V3rows_27_2E0) ) )
     => ( c_2EpatternMatches_2EPMATCH_2E2(A_27b,A_27a,V0v_2E0,c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V4r_2E0,V2rows_2E0)) = c_2EpatternMatches_2EPMATCH_2E2(A_27b,A_27a,V1v_27_2E0,c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V5r_27_2E0,V3rows_27_2E0)) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__EQ__AUX,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,A_27d: $tType,V0r_27_2E0: tyop_2Emin_2Efun(A_27c,A_27d),V1r_2E0: tyop_2Emin_2Efun(A_27b,A_27d),V2p_27_2E0: tyop_2Emin_2Efun(A_27c,A_27a),V3p_2E0: tyop_2Emin_2Efun(A_27b,A_27a),V4g_27_2E0: tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),V5g_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)] :
      ( ( ! [V6i_2E0: A_27a] :
            ( ? [V7x_2E0: A_27b] : p(c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(A_27b,A_27a,V3p_2E0,V5g_2E0,V6i_2E0,V7x_2E0))
          <=> ? [V8x_27_2E0: A_27c] : p(c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(A_27c,A_27a,V2p_27_2E0,V4g_27_2E0,V6i_2E0,V8x_27_2E0)) )
        & ! [V9x_2E0: A_27b,V10x_27_2E0: A_27c] :
            ( ( ( app_2E2(A_27b,A_27a,V3p_2E0,V9x_2E0) = app_2E2(A_27c,A_27a,V2p_27_2E0,V10x_27_2E0) )
              & p(app_2E2(A_27b,tyop_2Emin_2Ebool,V5g_2E0,V9x_2E0))
              & p(app_2E2(A_27c,tyop_2Emin_2Ebool,V4g_27_2E0,V10x_27_2E0)) )
           => ( app_2E2(A_27b,A_27d,V1r_2E0,V9x_2E0) = app_2E2(A_27c,A_27d,V0r_27_2E0,V10x_27_2E0) ) ) )
     => ( c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27d,A_27b,A_27a,V3p_2E0,V5g_2E0,V1r_2E0) = c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27d,A_27c,A_27a,V2p_27_2E0,V4g_27_2E0,V0r_27_2E0) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__EQ__NONE,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,V0r_2E0: tyop_2Emin_2Efun(A_27b,A_27a),V1p_2E0: tyop_2Emin_2Efun(A_27b,A_27c),V2i_2E0: A_27c,V3g_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)] :
      ( ( c_2EpatternMatches_2EPMATCH__ROW_2E4(A_27a,A_27b,A_27c,V1p_2E0,V3g_2E0,V0r_2E0,V2i_2E0) = c_2Eoption_2ENONE_2E0(A_27a) )
    <=> ! [V4x_2E0: A_27b] : ~ p(c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(A_27b,A_27c,V1p_2E0,V3g_2E0,V2i_2E0,V4x_2E0)) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__EQ__SOME,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,V0y_2E0: A_27a,V1r_2E0: tyop_2Emin_2Efun(A_27b,A_27a),V2p_2E0: tyop_2Emin_2Efun(A_27b,A_27c),V3i_2E0: A_27c,V4g_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)] :
      ( ( c_2EpatternMatches_2EPMATCH__ROW_2E4(A_27a,A_27b,A_27c,V2p_2E0,V4g_2E0,V1r_2E0,V3i_2E0) = c_2Eoption_2ESOME_2E1(A_27a,V0y_2E0) )
     => ? [V5x_2E0: A_27b] :
          ( p(c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(A_27b,A_27c,V2p_2E0,V4g_2E0,V3i_2E0,V5x_2E0))
          & ( V0y_2E0 = app_2E2(A_27b,A_27a,V1r_2E0,V5x_2E0) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__COND__SELECT__UNIQUE,axiom,
    ! [A_27a: $tType,A_27b: $tType,F0_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool))))] :
      ( ! [V0p_2E0: tyop_2Emin_2Efun(A_27a,A_27b),V1g_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V2i_2E0: A_27b,V6y_2E0: A_27a] : ( app_2E2(A_27a,tyop_2Emin_2Ebool,app_2E2(A_27b,tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)),app_2E2(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool))),F0_2E0,V0p_2E0),V1g_2E0),V2i_2E0),V6y_2E0) = c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(A_27a,A_27b,V0p_2E0,V1g_2E0,V2i_2E0,V6y_2E0) )
     => ! [V0p_2E0: tyop_2Emin_2Efun(A_27a,A_27b),V1g_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V2i_2E0: A_27b] :
          ( ! [V3x1_2E0: A_27a,V4x2_2E0: A_27a] :
              ( ( p(app_2E2(A_27a,tyop_2Emin_2Ebool,V1g_2E0,V3x1_2E0))
                & p(app_2E2(A_27a,tyop_2Emin_2Ebool,V1g_2E0,V4x2_2E0))
                & ( app_2E2(A_27a,A_27b,V0p_2E0,V3x1_2E0) = app_2E2(A_27a,A_27b,V0p_2E0,V4x2_2E0) ) )
             => ( V3x1_2E0 = V4x2_2E0 ) )
         => ! [V5x_2E0: A_27a] :
              ( p(c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(A_27a,A_27b,V0p_2E0,V1g_2E0,V2i_2E0,V5x_2E0))
             => ( c_2Emin_2E_40_2E1(A_27a,app_2E2(A_27b,tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)),app_2E2(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool))),F0_2E0,V0p_2E0),V1g_2E0),V2i_2E0)) = V5x_2E0 ) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__COND__DEF__GSYM,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0v_2E0: A_27a,V1pat_2E0: tyop_2Emin_2Efun(A_27a,A_27b),V2inp_2E0: A_27b,V3guard_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)] :
      ( p(c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(A_27a,A_27b,V1pat_2E0,V3guard_2E0,V2inp_2E0,V0v_2E0))
    <=> ( ( V2inp_2E0 = app_2E2(A_27a,A_27b,V1pat_2E0,V0v_2E0) )
        & p(app_2E2(A_27a,tyop_2Emin_2Ebool,V3guard_2E0,V0v_2E0)) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__EVAL,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,A_27d: $tType,F0_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool))),F1_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool))))] :
      ( ! [V3p_2E0: tyop_2Emin_2Efun(A_27d,A_27b),V4g_2E0: tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),V0v_2E0: A_27b] :
          ( p(app_2E2(A_27b,tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)),F0_2E0,V3p_2E0),V4g_2E0),V0v_2E0))
        <=> ? [V5x_2E0: A_27d] : p(c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(A_27d,A_27b,V3p_2E0,V4g_2E0,V0v_2E0,V5x_2E0)) )
     => ( ! [V3p_2E0: tyop_2Emin_2Efun(A_27d,A_27b),V4g_2E0: tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),V0v_2E0: A_27b,V6x_2E0: A_27d] : ( app_2E2(A_27d,tyop_2Emin_2Ebool,app_2E2(A_27b,tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool)),app_2E2(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool))),F1_2E0,V3p_2E0),V4g_2E0),V0v_2E0),V6x_2E0) = c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(A_27d,A_27b,V3p_2E0,V4g_2E0,V0v_2E0,V6x_2E0) )
       => ! [V0v_2E0: A_27b,V1rs_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V2r_2E0: tyop_2Emin_2Efun(A_27d,A_27c),V3p_2E0: tyop_2Emin_2Efun(A_27d,A_27b),V4g_2E0: tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool)] :
            ( ( c_2EpatternMatches_2EPMATCH_2E2(A_27a,A_27b,V0v_2E0,c_2Elist_2ENIL_2E0(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)))) = c_2EpatternMatches_2EPMATCH__INCOMPLETE_2E0(A_27a) )
            & ( c_2EpatternMatches_2EPMATCH_2E2(A_27c,A_27b,V0v_2E0,c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27c,A_27d,A_27b,V3p_2E0,V4g_2E0,V2r_2E0),V1rs_2E0)) = c_2Ebool_2ECOND_2E3(A_27c,app_2E2(A_27b,tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)),F0_2E0,V3p_2E0),V4g_2E0),V0v_2E0),app_2E2(A_27d,A_27c,V2r_2E0,c_2Emin_2E_40_2E1(A_27d,app_2E2(A_27b,tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool)),app_2E2(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool))),F1_2E0,V3p_2E0),V4g_2E0),V0v_2E0))),c_2EpatternMatches_2EPMATCH_2E2(A_27c,A_27b,V0v_2E0,V1rs_2E0)) ) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__EVAL__MATCH,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,F0_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool))))] :
      ( ! [V3p_2E0: tyop_2Emin_2Efun(A_27b,A_27c),V4g_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V0v_2E0: A_27c,V5x_2E0: A_27b] : ( app_2E2(A_27b,tyop_2Emin_2Ebool,app_2E2(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)),app_2E2(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool))),F0_2E0,V3p_2E0),V4g_2E0),V0v_2E0),V5x_2E0) = c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(A_27b,A_27c,V3p_2E0,V4g_2E0,V0v_2E0,V5x_2E0) )
     => ! [V0v_2E0: A_27c,V1rs_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))),V2r_2E0: tyop_2Emin_2Efun(A_27b,A_27a),V3p_2E0: tyop_2Emin_2Efun(A_27b,A_27c),V4g_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)] :
          ( ( c_2EpatternMatches_2EPMATCH__ROW_2E4(A_27a,A_27b,A_27c,V3p_2E0,V4g_2E0,V2r_2E0,V0v_2E0) != c_2Eoption_2ENONE_2E0(A_27a) )
         => ( c_2EpatternMatches_2EPMATCH_2E2(A_27a,A_27c,V0v_2E0,c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a)),c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27a,A_27b,A_27c,V3p_2E0,V4g_2E0,V2r_2E0),V1rs_2E0)) = app_2E2(A_27b,A_27a,V2r_2E0,c_2Emin_2E_40_2E1(A_27b,app_2E2(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)),app_2E2(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool))),F0_2E0,V3p_2E0),V4g_2E0),V0v_2E0))) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__EXTEND__BASE,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,V0v__old_2E0: A_27a,V1v__new_2E0: A_27b] : ( c_2EpatternMatches_2EPMATCH_2E2(A_27c,A_27a,V0v__old_2E0,c_2Elist_2ENIL_2E0(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)))) = c_2EpatternMatches_2EPMATCH_2E2(A_27c,A_27b,V1v__new_2E0,c_2Elist_2ENIL_2E0(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))) ) ).

tff(thm_2EpatternMatches_2EPMATCH__EXTEND__BOTH,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,V0v__old_2E0: A_27a,V1v__new_2E0: A_27b,V2rows__old_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),V3rows__new_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V4r__old_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),V5r__new_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))] :
      ( ( app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27c),V4r__old_2E0,V0v__old_2E0) = app_2E2(A_27b,tyop_2Eoption_2Eoption(A_27c),V5r__new_2E0,V1v__new_2E0) )
     => ( ( c_2EpatternMatches_2EPMATCH_2E2(A_27c,A_27a,V0v__old_2E0,V2rows__old_2E0) = c_2EpatternMatches_2EPMATCH_2E2(A_27c,A_27b,V1v__new_2E0,V3rows__new_2E0) )
       => ( c_2EpatternMatches_2EPMATCH_2E2(A_27c,A_27a,V0v__old_2E0,c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),V4r__old_2E0,V2rows__old_2E0)) = c_2EpatternMatches_2EPMATCH_2E2(A_27c,A_27b,V1v__new_2E0,c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),V5r__new_2E0,V3rows__new_2E0)) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__EXTEND__BOTH__ID,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0v_2E0: A_27a,V1rows__old_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows__new_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V3r_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))] :
      ( ( c_2EpatternMatches_2EPMATCH_2E2(A_27b,A_27a,V0v_2E0,V1rows__old_2E0) = c_2EpatternMatches_2EPMATCH_2E2(A_27b,A_27a,V0v_2E0,V2rows__new_2E0) )
     => ( c_2EpatternMatches_2EPMATCH_2E2(A_27b,A_27a,V0v_2E0,c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V3r_2E0,V1rows__old_2E0)) = c_2EpatternMatches_2EPMATCH_2E2(A_27b,A_27a,V0v_2E0,c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V3r_2E0,V2rows__new_2E0)) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__EXTEND__OLD,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,V0v__old_2E0: A_27a,V1v__new_2E0: A_27b,V2rows__old_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),V3rows__new_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V4r__old_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))] :
      ( ( app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27c),V4r__old_2E0,V0v__old_2E0) = c_2Eoption_2ENONE_2E0(A_27c) )
     => ( ( c_2EpatternMatches_2EPMATCH_2E2(A_27c,A_27a,V0v__old_2E0,V2rows__old_2E0) = c_2EpatternMatches_2EPMATCH_2E2(A_27c,A_27b,V1v__new_2E0,V3rows__new_2E0) )
       => ( c_2EpatternMatches_2EPMATCH_2E2(A_27c,A_27a,V0v__old_2E0,c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),V4r__old_2E0,V2rows__old_2E0)) = c_2EpatternMatches_2EPMATCH_2E2(A_27c,A_27b,V1v__new_2E0,V3rows__new_2E0) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__REMOVE__FUN,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,A_27d: $tType,F1_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27a)),F0_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27b)))] :
      ( ! [V2p_2E0: tyop_2Emin_2Efun(A_27c,A_27a),V8x_2E0: A_27c] : ( app_2E2(A_27c,A_27a,app_2E2(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27a),F1_2E0,V2p_2E0),V8x_2E0) = app_2E2(A_27c,A_27a,V2p_2E0,V8x_2E0) )
     => ( ! [V0ff_2E0: tyop_2Emin_2Efun(A_27a,A_27b),V2p_2E0: tyop_2Emin_2Efun(A_27c,A_27a),V7x_2E0: A_27c] : ( app_2E2(A_27c,A_27b,app_2E2(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27b),app_2E2(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27b)),F0_2E0,V0ff_2E0),V2p_2E0),V7x_2E0) = app_2E2(A_27a,A_27b,V0ff_2E0,app_2E2(A_27c,A_27a,V2p_2E0,V7x_2E0)) )
       => ! [V0ff_2E0: tyop_2Emin_2Efun(A_27a,A_27b),V1v_2E0: A_27a,V2p_2E0: tyop_2Emin_2Efun(A_27c,A_27a),V3g_2E0: tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),V4r_2E0: tyop_2Emin_2Efun(A_27c,A_27d)] :
            ( ! [V5x_2E0: A_27a,V6y_2E0: A_27a] :
                ( ( app_2E2(A_27a,A_27b,V0ff_2E0,V5x_2E0) = app_2E2(A_27a,A_27b,V0ff_2E0,V6y_2E0) )
               => ( V5x_2E0 = V6y_2E0 ) )
           => ( c_2EpatternMatches_2EPMATCH__ROW_2E4(A_27d,A_27c,A_27b,app_2E2(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27b),app_2E2(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27b)),F0_2E0,V0ff_2E0),V2p_2E0),V3g_2E0,V4r_2E0,app_2E2(A_27a,A_27b,V0ff_2E0,V1v_2E0)) = c_2EpatternMatches_2EPMATCH__ROW_2E4(A_27d,A_27c,A_27a,app_2E2(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27a),F1_2E0,V2p_2E0),V3g_2E0,V4r_2E0,V1v_2E0) ) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__EXTEND__INPUT,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,A_27d: $tType,A_27e: $tType,A_27f: $tType,F0_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27e,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool))))),F1_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27e,A_27f)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,A_27f)))))] :
      ( ! [V5g_2E0: tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27e,tyop_2Emin_2Ebool)),V2f_27_2E0: tyop_2Emin_2Efun(A_27b,A_27c),V7p_27_2E0: tyop_2Emin_2Efun(A_27d,A_27b),V3f_2E0: tyop_2Emin_2Efun(A_27d,A_27e),V13x_2E0: A_27d] : ( app_2E2(A_27d,tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool)),app_2E2(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool))),app_2E2(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27e,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool)))),F0_2E0,V5g_2E0),V2f_27_2E0),V7p_27_2E0),V3f_2E0),V13x_2E0) = app_2E2(A_27e,tyop_2Emin_2Ebool,app_2E2(A_27c,tyop_2Emin_2Efun(A_27e,tyop_2Emin_2Ebool),V5g_2E0,app_2E2(A_27b,A_27c,V2f_27_2E0,app_2E2(A_27d,A_27b,V7p_27_2E0,V13x_2E0))),app_2E2(A_27d,A_27e,V3f_2E0,V13x_2E0)) )
     => ( ! [V6r_2E0: tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27e,A_27f)),V2f_27_2E0: tyop_2Emin_2Efun(A_27b,A_27c),V7p_27_2E0: tyop_2Emin_2Efun(A_27d,A_27b),V3f_2E0: tyop_2Emin_2Efun(A_27d,A_27e),V14x_2E0: A_27d] : ( app_2E2(A_27d,A_27f,app_2E2(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,A_27f),app_2E2(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,A_27f)),app_2E2(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,A_27f))),app_2E2(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27e,A_27f)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,A_27f)))),F1_2E0,V6r_2E0),V2f_27_2E0),V7p_27_2E0),V3f_2E0),V14x_2E0) = app_2E2(A_27e,A_27f,app_2E2(A_27c,tyop_2Emin_2Efun(A_27e,A_27f),V6r_2E0,app_2E2(A_27b,A_27c,V2f_27_2E0,app_2E2(A_27d,A_27b,V7p_27_2E0,V14x_2E0))),app_2E2(A_27d,A_27e,V3f_2E0,V14x_2E0)) )
       => ! [V0v_2E0: A_27a,V1v_27_2E0: A_27b,V2f_27_2E0: tyop_2Emin_2Efun(A_27b,A_27c),V3f_2E0: tyop_2Emin_2Efun(A_27d,A_27e),V4p_2E0: tyop_2Emin_2Efun(A_27e,A_27a),V5g_2E0: tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27e,tyop_2Emin_2Ebool)),V6r_2E0: tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27e,A_27f)),V7p_27_2E0: tyop_2Emin_2Efun(A_27d,A_27b)] :
            ( ( ! [V8x_27_2E0: A_27d] :
                  ( ( V1v_27_2E0 = app_2E2(A_27d,A_27b,V7p_27_2E0,V8x_27_2E0) )
                 => ( app_2E2(A_27e,A_27a,V4p_2E0,app_2E2(A_27d,A_27e,V3f_2E0,V8x_27_2E0)) = V0v_2E0 ) )
              & ! [V9x_2E0: A_27e] :
                  ( ( V0v_2E0 = app_2E2(A_27e,A_27a,V4p_2E0,V9x_2E0) )
                 => ? [V10x_27_2E0: A_27d] : ( app_2E2(A_27d,A_27b,V7p_27_2E0,V10x_27_2E0) = V1v_27_2E0 ) )
              & ! [V11x_2E0: A_27e,V12y_2E0: A_27e] :
                  ( ( app_2E2(A_27e,A_27a,V4p_2E0,V11x_2E0) = app_2E2(A_27e,A_27a,V4p_2E0,V12y_2E0) )
                 => ( V11x_2E0 = V12y_2E0 ) ) )
           => ( c_2EpatternMatches_2EPMATCH__ROW_2E4(A_27f,A_27e,A_27a,V4p_2E0,app_2E2(A_27c,tyop_2Emin_2Efun(A_27e,tyop_2Emin_2Ebool),V5g_2E0,app_2E2(A_27b,A_27c,V2f_27_2E0,V1v_27_2E0)),app_2E2(A_27c,tyop_2Emin_2Efun(A_27e,A_27f),V6r_2E0,app_2E2(A_27b,A_27c,V2f_27_2E0,V1v_27_2E0)),V0v_2E0) = c_2EpatternMatches_2EPMATCH__ROW_2E4(A_27f,A_27d,A_27b,V7p_27_2E0,app_2E2(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool)),app_2E2(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool))),app_2E2(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27e,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool)))),F0_2E0,V5g_2E0),V2f_27_2E0),V7p_27_2E0),V3f_2E0),app_2E2(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,A_27f),app_2E2(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,A_27f)),app_2E2(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,A_27f))),app_2E2(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27e,A_27f)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,A_27f)))),F1_2E0,V6r_2E0),V2f_27_2E0),V7p_27_2E0),V3f_2E0),V1v_27_2E0) ) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__REMOVE__FUN__VAR,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,A_27d: $tType,A_27e: $tType,F0_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool))),F1_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27c,A_27e)))] :
      ( ! [V4g_2E0: tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),V2f_2E0: tyop_2Emin_2Efun(A_27c,A_27d),V12x_2E0: A_27c] : ( app_2E2(A_27c,tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),F0_2E0,V4g_2E0),V2f_2E0),V12x_2E0) = app_2E2(A_27d,tyop_2Emin_2Ebool,V4g_2E0,app_2E2(A_27c,A_27d,V2f_2E0,V12x_2E0)) )
     => ( ! [V5r_2E0: tyop_2Emin_2Efun(A_27d,A_27e),V2f_2E0: tyop_2Emin_2Efun(A_27c,A_27d),V13x_2E0: A_27c] : ( app_2E2(A_27c,A_27e,app_2E2(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27c,A_27e),app_2E2(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27c,A_27e)),F1_2E0,V5r_2E0),V2f_2E0),V13x_2E0) = app_2E2(A_27d,A_27e,V5r_2E0,app_2E2(A_27c,A_27d,V2f_2E0,V13x_2E0)) )
       => ! [V0v_2E0: A_27a,V1v_27_2E0: A_27b,V2f_2E0: tyop_2Emin_2Efun(A_27c,A_27d),V3p_2E0: tyop_2Emin_2Efun(A_27d,A_27a),V4g_2E0: tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),V5r_2E0: tyop_2Emin_2Efun(A_27d,A_27e),V6p_27_2E0: tyop_2Emin_2Efun(A_27c,A_27b)] :
            ( ( ! [V7x_27_2E0: A_27c] :
                  ( ( V1v_27_2E0 = app_2E2(A_27c,A_27b,V6p_27_2E0,V7x_27_2E0) )
                <=> ( app_2E2(A_27d,A_27a,V3p_2E0,app_2E2(A_27c,A_27d,V2f_2E0,V7x_27_2E0)) = V0v_2E0 ) )
              & ! [V8x_2E0: A_27d] :
                  ( ( V0v_2E0 = app_2E2(A_27d,A_27a,V3p_2E0,V8x_2E0) )
                 => ? [V9x_27_2E0: A_27c] : ( app_2E2(A_27c,A_27d,V2f_2E0,V9x_27_2E0) = V8x_2E0 ) )
              & ! [V10x_2E0: A_27d,V11y_2E0: A_27d] :
                  ( ( app_2E2(A_27d,A_27a,V3p_2E0,V10x_2E0) = app_2E2(A_27d,A_27a,V3p_2E0,V11y_2E0) )
                 => ( V10x_2E0 = V11y_2E0 ) ) )
           => ( c_2EpatternMatches_2EPMATCH__ROW_2E4(A_27e,A_27d,A_27a,V3p_2E0,V4g_2E0,V5r_2E0,V0v_2E0) = c_2EpatternMatches_2EPMATCH__ROW_2E4(A_27e,A_27c,A_27b,V6p_27_2E0,app_2E2(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),F0_2E0,V4g_2E0),V2f_2E0),app_2E2(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27c,A_27e),app_2E2(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27c,A_27e)),F1_2E0,V5r_2E0),V2f_2E0),V1v_27_2E0) ) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__EQUIV__ROWS__EQUIV__EXPAND,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0v_2E0: A_27a,V1rows2_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))] :
      ( p(c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(A_27a,A_27b,V0v_2E0,V2rows1_2E0,V1rows2_2E0))
    <=> ( c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E2(A_27a,A_27b,V0v_2E0,V2rows1_2E0) = c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E2(A_27a,A_27b,V0v_2E0,V1rows2_2E0) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__EQUIV__ROWS__is__equiv__1,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0v_2E0: A_27a,V1rows_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))] : p(c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(A_27a,A_27b,V0v_2E0,V1rows_2E0,V1rows_2E0)) ).

tff(thm_2EpatternMatches_2EPMATCH__EQUIV__ROWS__is__equiv__2,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0v_2E0: A_27a,V1rows1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows2_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))] : ( c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(A_27a,A_27b,V0v_2E0,V1rows1_2E0,V2rows2_2E0) = c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(A_27a,A_27b,V0v_2E0,V2rows2_2E0,V1rows1_2E0) ) ).

tff(thm_2EpatternMatches_2EPMATCH__EQUIV__ROWS__is__equiv__3,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0v_2E0: A_27a,V1rows1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows2_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V3rows3_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))] :
      ( p(c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(A_27a,A_27b,V0v_2E0,V1rows1_2E0,V2rows2_2E0))
     => ( p(c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(A_27a,A_27b,V0v_2E0,V2rows2_2E0,V3rows3_2E0))
       => p(c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(A_27a,A_27b,V0v_2E0,V1rows1_2E0,V3rows3_2E0)) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__EQUIV__ROWS__MATCH,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0v_2E0: A_27a,V1rows2_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))] :
      ( p(c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(A_27a,A_27b,V0v_2E0,V2rows1_2E0,V1rows2_2E0))
     => ( c_2EpatternMatches_2EPMATCH_2E2(A_27b,A_27a,V0v_2E0,V2rows1_2E0) = c_2EpatternMatches_2EPMATCH_2E2(A_27b,A_27a,V0v_2E0,V1rows2_2E0) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__APPEND__SEM,axiom,
    ! [A_27a: $tType,A_27b: $tType,F0_2E0: tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool))] :
      ( ! [V1rows1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V0v_2E0: A_27a] :
          ( p(app_2E2(A_27a,tyop_2Emin_2Ebool,app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),F0_2E0,V1rows1_2E0),V0v_2E0))
        <=> ? [V3r_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))] :
              ( p(c_2Ebool_2EIN_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V3r_2E0,c_2Elist_2ELIST__TO__SET_2E1(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1rows1_2E0)))
              & p(c_2Eoption_2EIS__SOME_2E1(A_27b,app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),V3r_2E0,V0v_2E0))) ) )
     => ! [V0v_2E0: A_27a,V1rows1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows2_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))] : ( c_2EpatternMatches_2EPMATCH_2E2(A_27b,A_27a,V0v_2E0,c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1rows1_2E0,V2rows2_2E0)) = c_2Ebool_2ECOND_2E3(A_27b,app_2E2(A_27a,tyop_2Emin_2Ebool,app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),F0_2E0,V1rows1_2E0),V0v_2E0),c_2EpatternMatches_2EPMATCH_2E2(A_27b,A_27a,V0v_2E0,V1rows1_2E0),c_2EpatternMatches_2EPMATCH_2E2(A_27b,A_27a,V0v_2E0,V2rows2_2E0)) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__EQUIV__APPEND,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0v_2E0: A_27a,V1rows1a_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows1b_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V3rows2a_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V4rows2b_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))] :
      ( p(c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(A_27a,A_27b,V0v_2E0,V1rows1a_2E0,V2rows1b_2E0))
     => ( p(c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(A_27a,A_27b,V0v_2E0,V3rows2a_2E0,V4rows2b_2E0))
       => p(c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(A_27a,A_27b,V0v_2E0,c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1rows1a_2E0,V3rows2a_2E0),c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V2rows1b_2E0,V4rows2b_2E0))) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__EQUIV__ROWS__CONS__NONE,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0v_2E0: A_27b,V1rows_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),V2row_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))] :
      ( ( app_2E2(A_27b,tyop_2Eoption_2Eoption(A_27a),V2row_2E0,V0v_2E0) = c_2Eoption_2ENONE_2E0(A_27a) )
     => ( c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E2(A_27b,A_27a,V0v_2E0,c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),V2row_2E0,V1rows_2E0)) = c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E2(A_27b,A_27a,V0v_2E0,V1rows_2E0) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROWS__DROP__REDUNDANT__TRIVIAL__SOUNDNESS__EQUIV,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0v_2E0: A_27a,V1rows_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2n_2E0: tyop_2Enum_2Enum] :
      ( ( p(c_2Eprim__rec_2E_3C_2E2(V2n_2E0,c_2Elist_2ELENGTH_2E1(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1rows_2E0)))
        & p(c_2Eoption_2EIS__SOME_2E1(A_27b,app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),c_2Elist_2EEL_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V2n_2E0,V1rows_2E0),V0v_2E0))) )
     => p(c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(A_27a,A_27b,V0v_2E0,V1rows_2E0,c_2Elist_2ETAKE_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),c_2Enum_2ESUC_2E1(V2n_2E0),V1rows_2E0))) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROWS__DROP__REDUNDANT__TRIVIAL__SOUNDNESS,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0v_2E0: A_27a,V1rows_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2n_2E0: tyop_2Enum_2Enum] :
      ( ( p(c_2Eprim__rec_2E_3C_2E2(V2n_2E0,c_2Elist_2ELENGTH_2E1(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1rows_2E0)))
        & p(c_2Eoption_2EIS__SOME_2E1(A_27b,app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),c_2Elist_2EEL_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V2n_2E0,V1rows_2E0),V0v_2E0))) )
     => ( c_2EpatternMatches_2EPMATCH_2E2(A_27b,A_27a,V0v_2E0,V1rows_2E0) = c_2EpatternMatches_2EPMATCH_2E2(A_27b,A_27a,V0v_2E0,c_2Elist_2ETAKE_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),c_2Enum_2ESUC_2E1(V2n_2E0),V1rows_2E0)) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROWS__DROP__REDUNDANT,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0r1_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1r2_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V2rows1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V3rows2_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V4rows3_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V5v_2E0: A_27a] :
      ( ( p(c_2Eoption_2EIS__SOME_2E1(A_27b,app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),V1r2_2E0,V5v_2E0)))
       => p(c_2Eoption_2EIS__SOME_2E1(A_27b,app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),V0r1_2E0,V5v_2E0))) )
     => ( c_2EpatternMatches_2EPMATCH_2E2(A_27b,A_27a,V5v_2E0,c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V2rows1_2E0,c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V0r1_2E0,V3rows2_2E0)),c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1r2_2E0,V4rows3_2E0))) = c_2EpatternMatches_2EPMATCH_2E2(A_27b,A_27a,V5v_2E0,c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V2rows1_2E0,c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V0r1_2E0,V3rows2_2E0)),V4rows3_2E0)) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROWS__DROP__REDUNDANT__PMATCH__ROWS,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,A_27d: $tType,V0p_2E0: tyop_2Emin_2Efun(A_27a,A_27b),V1g_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V2r_2E0: tyop_2Emin_2Efun(A_27a,A_27c),V3p_27_2E0: tyop_2Emin_2Efun(A_27d,A_27b),V4g_27_2E0: tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),V5r_27_2E0: tyop_2Emin_2Efun(A_27d,A_27c),V6rows1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V7rows2_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V8rows3_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V9v_2E0: A_27b] :
      ( ! [V10x_27_2E0: A_27d] :
          ( ( ( V9v_2E0 = app_2E2(A_27d,A_27b,V3p_27_2E0,V10x_27_2E0) )
            & p(app_2E2(A_27d,tyop_2Emin_2Ebool,V4g_27_2E0,V10x_27_2E0)) )
         => ? [V11x_2E0: A_27a] :
              ( ( app_2E2(A_27d,A_27b,V3p_27_2E0,V10x_27_2E0) = app_2E2(A_27a,A_27b,V0p_2E0,V11x_2E0) )
              & p(app_2E2(A_27a,tyop_2Emin_2Ebool,V1g_2E0,V11x_2E0)) ) )
     => ( c_2EpatternMatches_2EPMATCH_2E2(A_27c,A_27b,V9v_2E0,c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),V6rows1_2E0,c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27c,A_27a,A_27b,V0p_2E0,V1g_2E0,V2r_2E0),V7rows2_2E0)),c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27c,A_27d,A_27b,V3p_27_2E0,V4g_27_2E0,V5r_27_2E0),V8rows3_2E0))) = c_2EpatternMatches_2EPMATCH_2E2(A_27c,A_27b,V9v_2E0,c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),V6rows1_2E0,c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27c,A_27a,A_27b,V0p_2E0,V1g_2E0,V2r_2E0),V7rows2_2E0)),V8rows3_2E0)) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROWS__DROP__SUBSUMED,axiom,
    ! [A_27a: $tType,A_27b: $tType,F0_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool))] :
      ( ! [V5v_2E0: A_27a,V7row_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))] :
          ( p(app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool,app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),F0_2E0,V5v_2E0),V7row_2E0))
        <=> ( app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),V7row_2E0,V5v_2E0) = c_2Eoption_2ENONE_2E0(A_27b) ) )
     => ! [V0r1_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1r2_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V2rows1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V3rows2_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V4rows3_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V5v_2E0: A_27a] :
          ( ( ! [V6x_2E0: A_27b] :
                ( ( app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),V0r1_2E0,V5v_2E0) = c_2Eoption_2ESOME_2E1(A_27b,V6x_2E0) )
               => ( app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),V1r2_2E0,V5v_2E0) = c_2Eoption_2ESOME_2E1(A_27b,V6x_2E0) ) )
            & ( p(c_2Eoption_2EIS__SOME_2E1(A_27b,app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),V0r1_2E0,V5v_2E0)))
             => p(c_2Elist_2EEVERY_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),F0_2E0,V5v_2E0),V3rows2_2E0)) ) )
         => ( c_2EpatternMatches_2EPMATCH_2E2(A_27b,A_27a,V5v_2E0,c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V2rows1_2E0,c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V0r1_2E0,c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V3rows2_2E0,c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1r2_2E0,V4rows3_2E0))))) = c_2EpatternMatches_2EPMATCH_2E2(A_27b,A_27a,V5v_2E0,c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V2rows1_2E0,V3rows2_2E0),c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1r2_2E0,V4rows3_2E0))) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROWS__DROP__SUBSUMED__PMATCH__ROWS,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,A_27d: $tType,F0_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool)))] :
      ( ! [V0p_2E0: tyop_2Emin_2Efun(A_27a,A_27b),V14x_2E0: A_27a,V15row_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))] :
          ( p(app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool,app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool)),F0_2E0,V0p_2E0),V14x_2E0),V15row_2E0))
        <=> ( app_2E2(A_27b,tyop_2Eoption_2Eoption(A_27c),V15row_2E0,app_2E2(A_27a,A_27b,V0p_2E0,V14x_2E0)) = c_2Eoption_2ENONE_2E0(A_27c) ) )
     => ! [V0p_2E0: tyop_2Emin_2Efun(A_27a,A_27b),V1g_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V2r_2E0: tyop_2Emin_2Efun(A_27a,A_27c),V3p_27_2E0: tyop_2Emin_2Efun(A_27d,A_27b),V4g_27_2E0: tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),V5r_27_2E0: tyop_2Emin_2Efun(A_27d,A_27c),V6rows1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V7rows2_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V8rows3_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V9v_2E0: A_27b] :
          ( ( ! [V10x_2E0: A_27a] :
                ( ( ( V9v_2E0 = app_2E2(A_27a,A_27b,V0p_2E0,V10x_2E0) )
                  & p(app_2E2(A_27a,tyop_2Emin_2Ebool,V1g_2E0,V10x_2E0)) )
               => ? [V11x_27_2E0: A_27d] :
                    ( ( app_2E2(A_27a,A_27b,V0p_2E0,V10x_2E0) = app_2E2(A_27d,A_27b,V3p_27_2E0,V11x_27_2E0) )
                    & p(app_2E2(A_27d,tyop_2Emin_2Ebool,V4g_27_2E0,V11x_27_2E0)) ) )
            & ! [V12x_2E0: A_27a,V13x_27_2E0: A_27d] :
                ( ( ( V9v_2E0 = app_2E2(A_27a,A_27b,V0p_2E0,V12x_2E0) )
                  & ( app_2E2(A_27a,A_27b,V0p_2E0,V12x_2E0) = app_2E2(A_27d,A_27b,V3p_27_2E0,V13x_27_2E0) )
                  & p(app_2E2(A_27a,tyop_2Emin_2Ebool,V1g_2E0,V12x_2E0))
                  & p(app_2E2(A_27d,tyop_2Emin_2Ebool,V4g_27_2E0,V13x_27_2E0)) )
               => ( app_2E2(A_27a,A_27c,V2r_2E0,V12x_2E0) = app_2E2(A_27d,A_27c,V5r_27_2E0,V13x_27_2E0) ) )
            & ! [V14x_2E0: A_27a] :
                ( ( ( V9v_2E0 = app_2E2(A_27a,A_27b,V0p_2E0,V14x_2E0) )
                  & p(app_2E2(A_27a,tyop_2Emin_2Ebool,V1g_2E0,V14x_2E0)) )
               => p(c_2Elist_2EEVERY_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool)),F0_2E0,V0p_2E0),V14x_2E0),V7rows2_2E0)) ) )
         => ( c_2EpatternMatches_2EPMATCH_2E2(A_27c,A_27b,V9v_2E0,c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),V6rows1_2E0,c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27c,A_27a,A_27b,V0p_2E0,V1g_2E0,V2r_2E0),c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),V7rows2_2E0,c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27c,A_27d,A_27b,V3p_27_2E0,V4g_27_2E0,V5r_27_2E0),V8rows3_2E0))))) = c_2EpatternMatches_2EPMATCH_2E2(A_27c,A_27b,V9v_2E0,c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),V6rows1_2E0,V7rows2_2E0),c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27c,A_27d,A_27b,V3p_27_2E0,V4g_27_2E0,V5r_27_2E0),V8rows3_2E0))) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__REMOVE__ARB,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,V0p_2E0: tyop_2Emin_2Efun(A_27a,A_27b),V1g_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V2r_2E0: tyop_2Emin_2Efun(A_27a,A_27c),V3v_2E0: A_27b,V4rows_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))] :
      ( ! [V5x_2E0: A_27a] : ( app_2E2(A_27a,A_27c,V2r_2E0,V5x_2E0) = c_2Ebool_2EARB_2E0(A_27c) )
     => ( c_2EpatternMatches_2EPMATCH_2E2(A_27c,A_27b,V3v_2E0,c_2Elist_2ESNOC_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27c,A_27a,A_27b,V0p_2E0,V1g_2E0,V2r_2E0),V4rows_2E0)) = c_2EpatternMatches_2EPMATCH_2E2(A_27c,A_27b,V3v_2E0,V4rows_2E0) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__INTRO__CATCHALL,axiom,
    ! [A_27a: $tType,A_27b: $tType,F1_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),F0_2E0: tyop_2Emin_2Efun(A_27b,A_27b),F2_2E0: tyop_2Emin_2Efun(A_27b,A_27a)] :
      ( ! [V3__0_2E0: A_27b] : ( app_2E2(A_27b,tyop_2Emin_2Ebool,F1_2E0,V3__0_2E0) = c_2Ebool_2ET_2E0 )
     => ( ! [V2__0_2E0: A_27b] : ( app_2E2(A_27b,A_27b,F0_2E0,V2__0_2E0) = V2__0_2E0 )
       => ( ! [V4__0_2E0: A_27b] : ( app_2E2(A_27b,A_27a,F2_2E0,V4__0_2E0) = c_2Ebool_2EARB_2E0(A_27a) )
         => ! [V0v_2E0: A_27b,V1rows_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)))] : ( c_2EpatternMatches_2EPMATCH_2E2(A_27a,A_27b,V0v_2E0,V1rows_2E0) = c_2EpatternMatches_2EPMATCH_2E2(A_27a,A_27b,V0v_2E0,c_2Elist_2ESNOC_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27a,A_27b,A_27b,F0_2E0,F1_2E0,F2_2E0),V1rows_2E0)) ) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__REMOVE__ARB__NO__OVERLAP,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,F0_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool)))] :
      ( ! [V1p_2E0: tyop_2Emin_2Efun(A_27b,A_27a),V7x_2E0: A_27b,V8row_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))] :
          ( p(app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool,app_2E2(A_27b,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool)),F0_2E0,V1p_2E0),V7x_2E0),V8row_2E0))
        <=> ( app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27c),V8row_2E0,app_2E2(A_27b,A_27a,V1p_2E0,V7x_2E0)) = c_2Eoption_2ENONE_2E0(A_27c) ) )
     => ! [V0v_2E0: A_27a,V1p_2E0: tyop_2Emin_2Efun(A_27b,A_27a),V2g_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V3r_2E0: tyop_2Emin_2Efun(A_27b,A_27c),V4rows1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),V5rows2_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)))] :
          ( ( ! [V6x_2E0: A_27b] : ( app_2E2(A_27b,A_27c,V3r_2E0,V6x_2E0) = c_2Ebool_2EARB_2E0(A_27c) )
            & ! [V7x_2E0: A_27b] :
                ( ( ( V0v_2E0 = app_2E2(A_27b,A_27a,V1p_2E0,V7x_2E0) )
                  & p(app_2E2(A_27b,tyop_2Emin_2Ebool,V2g_2E0,V7x_2E0)) )
               => p(c_2Elist_2EEVERY_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),app_2E2(A_27b,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool)),F0_2E0,V1p_2E0),V7x_2E0),V5rows2_2E0)) ) )
         => ( c_2EpatternMatches_2EPMATCH_2E2(A_27c,A_27a,V0v_2E0,c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),V4rows1_2E0,c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27c,A_27b,A_27a,V1p_2E0,V2g_2E0,V3r_2E0),V5rows2_2E0))) = c_2EpatternMatches_2EPMATCH_2E2(A_27c,A_27a,V0v_2E0,c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),V4rows1_2E0,V5rows2_2E0)) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__REDUNDANT__NIL,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0v_2E0: A_27a,V1i_2E0: tyop_2Enum_2Enum] : ( c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E3(A_27a,A_27b,V0v_2E0,c_2Elist_2ENIL_2E0(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1i_2E0) = c_2Ebool_2EF_2E0 ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__REDUNDANT__0,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0v_2E0: A_27a,V1rs_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2r_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))] :
      ( p(c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E3(A_27a,A_27b,V0v_2E0,c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V2r_2E0,V1rs_2E0),c_2Enum_2E0_2E0))
    <=> ( app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),V2r_2E0,V0v_2E0) = c_2Eoption_2ENONE_2E0(A_27b) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__REDUNDANT__SUC,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0v_2E0: A_27a,V1r_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V2rs_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V3i_2E0: tyop_2Enum_2Enum] :
      ( p(c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E3(A_27a,A_27b,V0v_2E0,c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1r_2E0,V2rs_2E0),c_2Enum_2ESUC_2E1(V3i_2E0)))
    <=> ( ( ( app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),V1r_2E0,V0v_2E0) != c_2Eoption_2ENONE_2E0(A_27b) )
          & p(c_2Eprim__rec_2E_3C_2E2(V3i_2E0,c_2Elist_2ELENGTH_2E1(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V2rs_2E0))) )
        | p(c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E3(A_27a,A_27b,V0v_2E0,V2rs_2E0,V3i_2E0)) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__REDUNDANT__APPEND__LT,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0v_2E0: A_27a,V1rs1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rs2_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V3i_2E0: tyop_2Enum_2Enum] :
      ( p(c_2Eprim__rec_2E_3C_2E2(V3i_2E0,c_2Elist_2ELENGTH_2E1(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1rs1_2E0)))
     => ( c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E3(A_27a,A_27b,V0v_2E0,c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1rs1_2E0,V2rs2_2E0),V3i_2E0) = c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E3(A_27a,A_27b,V0v_2E0,V1rs1_2E0,V3i_2E0) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__REDUNDANT__APPEND__GE,axiom,
    ! [A_27a: $tType,A_27b: $tType,F0_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool))] :
      ( ! [V0v_2E0: A_27a,V4r_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))] :
          ( p(app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool,app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),F0_2E0,V0v_2E0),V4r_2E0))
        <=> ( app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),V4r_2E0,V0v_2E0) = c_2Eoption_2ENONE_2E0(A_27b) ) )
     => ! [V0v_2E0: A_27a,V1rs1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rs2_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V3i_2E0: tyop_2Enum_2Enum] :
          ( ~ p(c_2Eprim__rec_2E_3C_2E2(V3i_2E0,c_2Elist_2ELENGTH_2E1(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1rs1_2E0)))
         => ( p(c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E3(A_27a,A_27b,V0v_2E0,c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1rs1_2E0,V2rs2_2E0),V3i_2E0))
          <=> ( ( ~ p(c_2Elist_2EEVERY_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),F0_2E0,V0v_2E0),V1rs1_2E0))
                & p(c_2Eprim__rec_2E_3C_2E2(V3i_2E0,c_2Earithmetic_2E_2B_2E2(c_2Elist_2ELENGTH_2E1(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1rs1_2E0),c_2Elist_2ELENGTH_2E1(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V2rs2_2E0)))) )
              | p(c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E3(A_27a,A_27b,V0v_2E0,V2rs2_2E0,c_2Earithmetic_2E_2D_2E2(V3i_2E0,c_2Elist_2ELENGTH_2E1(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1rs1_2E0)))) ) ) ) ) ).

tff(thm_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO__NIL,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0v_2E0: A_27a] : p(c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(A_27a,A_27b,V0v_2E0,c_2Elist_2ENIL_2E0(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Ebool_2ET_2E0,c_2Elist_2ENIL_2E0(tyop_2Emin_2Ebool))) ).

tff(thm_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO__SNOC,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0v_2E0: A_27a,V1rows_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2c_2E0: tyop_2Emin_2Ebool,V3infos_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool),V4r_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V5i_2E0: tyop_2Emin_2Ebool,V6c_27_2E0: tyop_2Emin_2Ebool] :
      ( p(c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(A_27a,A_27b,V0v_2E0,V1rows_2E0,V2c_2E0,V3infos_2E0))
     => ( ( ( app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),V4r_2E0,V0v_2E0) = c_2Eoption_2ENONE_2E0(A_27b) )
         => ( p(V2c_2E0)
           => p(V6c_27_2E0) ) )
       => ( ( p(V2c_2E0)
           => ( p(V5i_2E0)
             => ( app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),V4r_2E0,V0v_2E0) = c_2Eoption_2ENONE_2E0(A_27b) ) ) )
         => p(c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(A_27a,A_27b,V0v_2E0,c_2Elist_2ESNOC_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V4r_2E0,V1rows_2E0),V6c_27_2E0,c_2Elist_2ESNOC_2E2(tyop_2Emin_2Ebool,V5i_2E0,V3infos_2E0))) ) ) ) ).

tff(thm_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO__SNOC__PMATCH__ROW,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,F0_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool))))] :
      ( ! [V2c_2E0: tyop_2Emin_2Ebool,V0v_2E0: A_27a,V4p_2E0: tyop_2Emin_2Efun(A_27c,A_27a),V5g_2E0: tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)] :
          ( p(app_2E2(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)),app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool))),F0_2E0,V2c_2E0),V0v_2E0),V4p_2E0),V5g_2E0))
        <=> ( p(V2c_2E0)
           => ~ p(c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(A_27a,A_27c,V0v_2E0,V4p_2E0,V5g_2E0)) ) )
     => ! [V0v_2E0: A_27a,V1rows_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2c_2E0: tyop_2Emin_2Ebool,V3infos_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool),V4p_2E0: tyop_2Emin_2Efun(A_27c,A_27a),V5g_2E0: tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),V6r_2E0: tyop_2Emin_2Efun(A_27c,A_27b),V7c_27_2E0: tyop_2Emin_2Ebool] :
          ( p(c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(A_27a,A_27b,V0v_2E0,V1rows_2E0,V2c_2E0,V3infos_2E0))
         => ( ( ~ p(c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(A_27a,A_27c,V0v_2E0,V4p_2E0,V5g_2E0))
             => ( V2c_2E0 = V7c_27_2E0 ) )
           => p(c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(A_27a,A_27b,V0v_2E0,c_2Elist_2ESNOC_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27b,A_27c,A_27a,V4p_2E0,V5g_2E0,V6r_2E0),V1rows_2E0),V7c_27_2E0,c_2Elist_2ESNOC_2E2(tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)),app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool))),F0_2E0,V2c_2E0),V0v_2E0),V4p_2E0),V5g_2E0),V3infos_2E0))) ) ) ) ).

tff(thm_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO__CONS,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0v_2E0: A_27a,V1rows_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2row_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V3infos_27_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool),V4i_2E0: tyop_2Emin_2Ebool,V5c_2E0: tyop_2Emin_2Ebool] :
      ( p(c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(A_27a,A_27b,V0v_2E0,c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V2row_2E0,V1rows_2E0),V5c_2E0,c_2Elist_2ECONS_2E2(tyop_2Emin_2Ebool,V4i_2E0,V3infos_27_2E0)))
    <=> ( ( c_2Elist_2ELENGTH_2E1(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1rows_2E0) = c_2Elist_2ELENGTH_2E1(tyop_2Emin_2Ebool,V3infos_27_2E0) )
        & ( p(V4i_2E0)
         => ( app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),V2row_2E0,V0v_2E0) = c_2Eoption_2ENONE_2E0(A_27b) ) )
        & ( ( app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),V2row_2E0,V0v_2E0) = c_2Eoption_2ENONE_2E0(A_27b) )
         => p(c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(A_27a,A_27b,V0v_2E0,V1rows_2E0,V5c_2E0,V3infos_27_2E0)) ) ) ) ).

tff(thm_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO__THMS,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType] :
      ( ( c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2(A_27a,c_2Elist_2ENIL_2E0(tyop_2Emin_2Ebool),c_2Elist_2ENIL_2E0(A_27a)) = c_2Elist_2ENIL_2E0(A_27a) )
      & ! [V0is_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool),V1x_2E0: A_27b,V2xs_2E0: tyop_2Elist_2Elist(A_27b)] : ( c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2(A_27b,c_2Elist_2ECONS_2E2(tyop_2Emin_2Ebool,c_2Ebool_2ET_2E0,V0is_2E0),c_2Elist_2ECONS_2E2(A_27b,V1x_2E0,V2xs_2E0)) = c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2(A_27b,V0is_2E0,V2xs_2E0) )
      & ! [V3is_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool),V4x_2E0: A_27c,V5xs_2E0: tyop_2Elist_2Elist(A_27c)] : ( c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2(A_27c,c_2Elist_2ECONS_2E2(tyop_2Emin_2Ebool,c_2Ebool_2EF_2E0,V3is_2E0),c_2Elist_2ECONS_2E2(A_27c,V4x_2E0,V5xs_2E0)) = c_2Elist_2ECONS_2E2(A_27c,V4x_2E0,c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2(A_27c,V3is_2E0,V5xs_2E0)) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROWS__DROP__REDUNDANT__ROWS__INFO__EQUIV,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0v_2E0: A_27a,V1c_2E0: tyop_2Emin_2Ebool,V2rows_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V3infos_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool)] :
      ( p(c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(A_27a,A_27b,V0v_2E0,V2rows_2E0,V1c_2E0,V3infos_2E0))
     => p(c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(A_27a,A_27b,V0v_2E0,V2rows_2E0,c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V3infos_2E0,V2rows_2E0))) ) ).

tff(thm_2EpatternMatches_2EREDUNDANT__ROWS__INFO__TO__PMATCH__EQ,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0v_2E0: A_27a,V1c_2E0: tyop_2Emin_2Ebool,V2rows_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V3infos_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool)] :
      ( p(c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(A_27a,A_27b,V0v_2E0,V2rows_2E0,V1c_2E0,V3infos_2E0))
     => ( c_2EpatternMatches_2EPMATCH_2E2(A_27b,A_27a,V0v_2E0,V2rows_2E0) = c_2EpatternMatches_2EPMATCH_2E2(A_27b,A_27a,V0v_2E0,c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V3infos_2E0,V2rows_2E0)) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE__REWRITES,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,A_27d: $tType] :
      ( ! [V0v_2E0: A_27a] : ( c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2(A_27a,A_27b,V0v_2E0,c_2Elist_2ENIL_2E0(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))) = c_2Ebool_2EF_2E0 )
      & ! [V1v_2E0: A_27c,V2r_2E0: tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d)),V3rs_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d)))] :
          ( p(c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2(A_27c,A_27d,V1v_2E0,c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d)),V2r_2E0,V3rs_2E0)))
        <=> ( ( app_2E2(A_27c,tyop_2Eoption_2Eoption(A_27d),V2r_2E0,V1v_2E0) != c_2Eoption_2ENONE_2E0(A_27d) )
            | p(c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2(A_27c,A_27d,V1v_2E0,V3rs_2E0)) ) ) ) ).

tff(thm_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO__EXTRACT__IS__EXHAUSTIVE,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0v_2E0: A_27a,V1rows_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2c_2E0: tyop_2Emin_2Ebool,V3infos_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool)] :
      ( p(c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(A_27a,A_27b,V0v_2E0,V1rows_2E0,V2c_2E0,V3infos_2E0))
     => ( ~ p(V2c_2E0)
       => p(c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2(A_27a,A_27b,V0v_2E0,V1rows_2E0)) ) ) ).

tff(thm_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ__REWRITE,axiom,
    ! [F0_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool))] :
      ( ! [V3i1_2E0: tyop_2Emin_2Ebool,V2i2_2E0: tyop_2Emin_2Ebool] :
          ( p(app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),F0_2E0,V3i1_2E0),V2i2_2E0))
        <=> ( p(V3i1_2E0)
            & p(V2i2_2E0) ) )
     => ! [V0is2_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool),V1is1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool),V2i2_2E0: tyop_2Emin_2Ebool,V3i1_2E0: tyop_2Emin_2Ebool] :
          ( ( c_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ_2E2(c_2Elist_2ENIL_2E0(tyop_2Emin_2Ebool),c_2Elist_2ENIL_2E0(tyop_2Emin_2Ebool)) = c_2Elist_2ENIL_2E0(tyop_2Emin_2Ebool) )
          & ( c_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ_2E2(c_2Elist_2ECONS_2E2(tyop_2Emin_2Ebool,V3i1_2E0,V1is1_2E0),c_2Elist_2ECONS_2E2(tyop_2Emin_2Ebool,V2i2_2E0,V0is2_2E0)) = c_2Elist_2ECONS_2E2(tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),F0_2E0,V3i1_2E0),V2i2_2E0),c_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ_2E2(V1is1_2E0,V0is2_2E0)) ) ) ) ).

tff(thm_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ__THM,axiom,
    ! [A_27a: $tType,A_27b: $tType,F0_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool))] :
      ( ! [V2c_2E0: tyop_2Emin_2Ebool,V4c_27_2E0: tyop_2Emin_2Ebool] :
          ( p(app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),F0_2E0,V2c_2E0),V4c_27_2E0))
        <=> ( p(V2c_2E0)
            | p(V4c_27_2E0) ) )
     => ! [V0v_2E0: A_27a,V1rows_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2c_2E0: tyop_2Emin_2Ebool,V3infos_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool),V4c_27_2E0: tyop_2Emin_2Ebool,V5infos_27_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool)] :
          ( p(c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(A_27a,A_27b,V0v_2E0,V1rows_2E0,V2c_2E0,V3infos_2E0))
         => ( ( c_2Elist_2ELENGTH_2E1(tyop_2Emin_2Ebool,V5infos_27_2E0) = c_2Elist_2ELENGTH_2E1(tyop_2Emin_2Ebool,V3infos_2E0) )
           => p(c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(A_27a,A_27b,V0v_2E0,V1rows_2E0,app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),F0_2E0,V2c_2E0),V4c_27_2E0),c_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ_2E2(V3infos_2E0,V5infos_27_2E0))) ) ) ) ).

tff(thm_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__DISJ__THM,axiom,
    ! [A_27a: $tType,A_27b: $tType,F0_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool))] :
      ( ! [V2c_2E0: tyop_2Emin_2Ebool,V4c_27_2E0: tyop_2Emin_2Ebool] :
          ( p(app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),F0_2E0,V2c_2E0),V4c_27_2E0))
        <=> ( p(V2c_2E0)
            & p(V4c_27_2E0) ) )
     => ! [V0v_2E0: A_27a,V1rows_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2c_2E0: tyop_2Emin_2Ebool,V3infos_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool),V4c_27_2E0: tyop_2Emin_2Ebool,V5infos_27_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool)] :
          ( p(c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(A_27a,A_27b,V0v_2E0,V1rows_2E0,V2c_2E0,V3infos_2E0))
         => ( p(c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(A_27a,A_27b,V0v_2E0,V1rows_2E0,V4c_27_2E0,V5infos_27_2E0))
           => p(c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(A_27a,A_27b,V0v_2E0,V1rows_2E0,app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),F0_2E0,V2c_2E0),V4c_27_2E0),c_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__DISJ_2E2(V3infos_2E0,V5infos_27_2E0))) ) ) ) ).

tff(thm_2EpatternMatches_2ELENGTH__STRONGEST__REDUNDANT__ROWS__INFO__AUX,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0v_2E0: A_27a,V1rows_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2p_2E0: tyop_2Emin_2Ebool,V3infos_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool)] : ( c_2Elist_2ELENGTH_2E1(tyop_2Emin_2Ebool,c_2Epair_2ESND_2E1(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool),c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX_2E4(A_27a,A_27b,V0v_2E0,V1rows_2E0,V2p_2E0,V3infos_2E0))) = c_2Earithmetic_2E_2B_2E2(c_2Elist_2ELENGTH_2E1(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1rows_2E0),c_2Elist_2ELENGTH_2E1(tyop_2Emin_2Ebool,V3infos_2E0)) ) ).

tff(thm_2EpatternMatches_2EFST__STRONGEST__REDUNDANT__ROWS__INFO__AUX,axiom,
    ! [A_27a: $tType,A_27b: $tType,F0_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool))] :
      ( ! [V0v_2E0: A_27a,V4r_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))] :
          ( p(app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool,app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),F0_2E0,V0v_2E0),V4r_2E0))
        <=> ( app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),V4r_2E0,V0v_2E0) = c_2Eoption_2ENONE_2E0(A_27b) ) )
     => ! [V0v_2E0: A_27a,V1rows_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2p_2E0: tyop_2Emin_2Ebool,V3infos_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Ebool)] :
          ( p(c_2Epair_2EFST_2E1(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool),c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX_2E4(A_27a,A_27b,V0v_2E0,V1rows_2E0,V2p_2E0,V3infos_2E0)))
        <=> ( p(V2p_2E0)
            & p(c_2Elist_2EEVERY_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),F0_2E0,V0v_2E0),V1rows_2E0)) ) ) ) ).

tff(thm_2EpatternMatches_2EEL__STRONGEST__REDUNDANT__ROWS__INFO,axiom,
    ! [A_27a: $tType,A_27b: $tType,F0_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool))] :
      ( ! [V0v_2E0: A_27a,V3r_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))] :
          ( p(app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool,app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),F0_2E0,V0v_2E0),V3r_2E0))
        <=> ( app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),V3r_2E0,V0v_2E0) = c_2Eoption_2ENONE_2E0(A_27b) ) )
     => ! [V0v_2E0: A_27a,V1rows_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2i_2E0: tyop_2Enum_2Enum] :
          ( p(c_2Eprim__rec_2E_3C_2E2(V2i_2E0,c_2Elist_2ELENGTH_2E1(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1rows_2E0)))
         => ( p(c_2Elist_2EEL_2E2(tyop_2Emin_2Ebool,V2i_2E0,c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO_2E2(A_27a,A_27b,V0v_2E0,V1rows_2E0)))
          <=> ( p(c_2Elist_2EEVERY_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),F0_2E0,V0v_2E0),c_2Elist_2ETAKE_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V2i_2E0,V1rows_2E0)))
             => ( app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),c_2Elist_2EEL_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V2i_2E0,V1rows_2E0),V0v_2E0) = c_2Eoption_2ENONE_2E0(A_27b) ) ) ) ) ) ).

tff(thm_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__OK,axiom,
    ! [A_27a: $tType,A_27b: $tType,F0_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool))] :
      ( ! [V0v_2E0: A_27a,V2r_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))] :
          ( p(app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool,app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),F0_2E0,V0v_2E0),V2r_2E0))
        <=> ( app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),V2r_2E0,V0v_2E0) = c_2Eoption_2ENONE_2E0(A_27b) ) )
     => ! [V0v_2E0: A_27a,V1rows_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))] : p(c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(A_27a,A_27b,V0v_2E0,V1rows_2E0,c_2Elist_2EEVERY_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),F0_2E0,V0v_2E0),V1rows_2E0),c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO_2E2(A_27a,A_27b,V0v_2E0,V1rows_2E0))) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__COND__EX__FULL__DEF,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0p_2E0: tyop_2Emin_2Efun(A_27b,A_27a),V1i_2E0: A_27a,V2g_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)] :
      ( p(c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(A_27a,A_27b,V1i_2E0,V0p_2E0,V2g_2E0))
    <=> ? [V3x_2E0: A_27b] :
          ( ( V1i_2E0 = app_2E2(A_27b,A_27a,V0p_2E0,V3x_2E0) )
          & p(app_2E2(A_27b,tyop_2Emin_2Ebool,V2g_2E0,V3x_2E0)) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__COND__EX__WEAKEN,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,F0_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool))))] :
      ( ! [V5g_27_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V3g_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V0f_2E0: tyop_2Emin_2Efun(A_27a,A_27b),V7x_2E0: A_27a] :
          ( p(app_2E2(A_27a,tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)),app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool))),F0_2E0,V5g_27_2E0),V3g_2E0),V0f_2E0),V7x_2E0))
        <=> ( p(app_2E2(A_27a,tyop_2Emin_2Ebool,V5g_27_2E0,V7x_2E0))
            & ~ p(app_2E2(A_27b,tyop_2Emin_2Ebool,V3g_2E0,app_2E2(A_27a,A_27b,V0f_2E0,V7x_2E0))) ) )
     => ! [V0f_2E0: tyop_2Emin_2Efun(A_27a,A_27b),V1v_2E0: A_27c,V2p_2E0: tyop_2Emin_2Efun(A_27b,A_27c),V3g_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V4p_27_2E0: tyop_2Emin_2Efun(A_27a,A_27c),V5g_27_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)] :
          ( ~ p(c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(A_27c,A_27b,V1v_2E0,V2p_2E0,V3g_2E0))
         => ( ! [V6x_2E0: A_27a] : ( app_2E2(A_27a,A_27c,V4p_27_2E0,V6x_2E0) = app_2E2(A_27b,A_27c,V2p_2E0,app_2E2(A_27a,A_27b,V0f_2E0,V6x_2E0)) )
           => ( c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(A_27c,A_27a,V1v_2E0,V4p_27_2E0,V5g_27_2E0) = c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(A_27c,A_27a,V1v_2E0,V4p_27_2E0,app_2E2(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)),app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool))),F0_2E0,V5g_27_2E0),V3g_2E0),V0f_2E0)) ) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__COND__EX__FALSE,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0v_2E0: A_27a,V1p_2E0: tyop_2Emin_2Efun(A_27b,A_27a),V2g_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)] :
      ( ! [V3x_2E0: A_27b] : ~ p(app_2E2(A_27b,tyop_2Emin_2Ebool,V2g_2E0,V3x_2E0))
     => ( c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(A_27a,A_27b,V0v_2E0,V1p_2E0,V2g_2E0) = c_2Ebool_2EF_2E0 ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__COND__EX__IMP__REWRITE,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,V0v_2E0: A_27a,V1p_2E0: tyop_2Emin_2Efun(A_27b,A_27a),V2g_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V3p_27_2E0: tyop_2Emin_2Efun(A_27c,A_27a),V4g_27_2E0: tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),V5RES_2E0: tyop_2Emin_2Ebool] :
      ( p(c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(A_27a,A_27b,V0v_2E0,V1p_2E0,V2g_2E0))
     => ( ! [V6x_2E0: A_27b] :
            ( p(app_2E2(A_27b,tyop_2Emin_2Ebool,V2g_2E0,V6x_2E0))
           => ( ? [V7x_27_2E0: A_27c] :
                  ( ( app_2E2(A_27c,A_27a,V3p_27_2E0,V7x_27_2E0) = app_2E2(A_27b,A_27a,V1p_2E0,V6x_2E0) )
                  & p(app_2E2(A_27c,tyop_2Emin_2Ebool,V4g_27_2E0,V7x_27_2E0)) )
            <=> p(V5RES_2E0) ) )
       => ( c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(A_27a,A_27c,V0v_2E0,V3p_27_2E0,V4g_27_2E0) = V5RES_2E0 ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE__CONTRADICT,axiom,
    ! [A_27a: $tType,A_27b: $tType,F0_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool))] :
      ( ! [V0v_2E0: A_27a,V2r_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))] :
          ( p(app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool,app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),F0_2E0,V0v_2E0),V2r_2E0))
        <=> ( app_2E2(A_27a,tyop_2Eoption_2Eoption(A_27b),V2r_2E0,V0v_2E0) = c_2Eoption_2ENONE_2E0(A_27b) ) )
     => ! [V0v_2E0: A_27a,V1rs_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))] :
          ( ( p(c_2Elist_2EEVERY_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),app_2E2(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),F0_2E0,V0v_2E0),V1rs_2E0))
           => p(c_2Ebool_2EF_2E0) )
         => p(c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2(A_27a,A_27b,V0v_2E0,V1rs_2E0)) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__EVAL__COND__EX,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,F0_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool))))] :
      ( ! [V1p_2E0: tyop_2Emin_2Efun(A_27b,A_27a),V3g_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V2i_2E0: A_27a,V4x_2E0: A_27b] : ( app_2E2(A_27b,tyop_2Emin_2Ebool,app_2E2(A_27a,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)),app_2E2(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool))),F0_2E0,V1p_2E0),V3g_2E0),V2i_2E0),V4x_2E0) = c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(A_27b,A_27a,V1p_2E0,V3g_2E0,V2i_2E0,V4x_2E0) )
     => ! [V0r_2E0: tyop_2Emin_2Efun(A_27b,A_27c),V1p_2E0: tyop_2Emin_2Efun(A_27b,A_27a),V2i_2E0: A_27a,V3g_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)] :
          ( p(c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(A_27a,A_27b,V2i_2E0,V1p_2E0,V3g_2E0))
         => ( c_2EpatternMatches_2EPMATCH__ROW_2E4(A_27c,A_27b,A_27a,V1p_2E0,V3g_2E0,V0r_2E0,V2i_2E0) = c_2Eoption_2ESOME_2E1(A_27c,app_2E2(A_27b,A_27c,V0r_2E0,c_2Emin_2E_40_2E1(A_27b,app_2E2(A_27a,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)),app_2E2(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool))),F0_2E0,V1p_2E0),V3g_2E0),V2i_2E0)))) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__NEQ__NONE,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,V0r_2E0: tyop_2Emin_2Efun(A_27b,A_27a),V1p_2E0: tyop_2Emin_2Efun(A_27b,A_27c),V2i_2E0: A_27c,V3g_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)] :
      ( ( c_2EpatternMatches_2EPMATCH__ROW_2E4(A_27a,A_27b,A_27c,V1p_2E0,V3g_2E0,V0r_2E0,V2i_2E0) != c_2Eoption_2ENONE_2E0(A_27a) )
    <=> p(c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(A_27c,A_27b,V2i_2E0,V1p_2E0,V3g_2E0)) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__REMOVE__DOUBLE__BINDS__THM,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,A_27d: $tType,V0g_2E0: tyop_2Emin_2Efun(A_27a,A_27b),V1p1_2E0: tyop_2Emin_2Efun(A_27a,A_27c),V2g1_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V3r1_2E0: tyop_2Emin_2Efun(A_27a,A_27d),V4p2_2E0: tyop_2Emin_2Efun(A_27b,A_27c),V5g2_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V6r2_2E0: tyop_2Emin_2Efun(A_27b,A_27d)] :
      ( ( ! [V7x_2E0: A_27a,V8y_2E0: A_27a] :
            ( ( app_2E2(A_27a,A_27c,V1p1_2E0,V7x_2E0) = app_2E2(A_27a,A_27c,V1p1_2E0,V8y_2E0) )
           => ( V7x_2E0 = V8y_2E0 ) )
        & ! [V9x_2E0: A_27a] : ( app_2E2(A_27b,A_27c,V4p2_2E0,app_2E2(A_27a,A_27b,V0g_2E0,V9x_2E0)) = app_2E2(A_27a,A_27c,V1p1_2E0,V9x_2E0) )
        & ! [V10x_27_2E0: A_27b] :
            ( p(app_2E2(A_27b,tyop_2Emin_2Ebool,V5g2_2E0,V10x_27_2E0))
          <=> ? [V11x_2E0: A_27a] :
                ( ( V10x_27_2E0 = app_2E2(A_27a,A_27b,V0g_2E0,V11x_2E0) )
                & p(app_2E2(A_27a,tyop_2Emin_2Ebool,V2g1_2E0,V11x_2E0)) ) )
        & ! [V12x_2E0: A_27a] : ( app_2E2(A_27b,A_27d,V6r2_2E0,app_2E2(A_27a,A_27b,V0g_2E0,V12x_2E0)) = app_2E2(A_27a,A_27d,V3r1_2E0,V12x_2E0) ) )
     => ( c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27d,A_27a,A_27c,V1p1_2E0,V2g1_2E0,V3r1_2E0) = c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27d,A_27b,A_27c,V4p2_2E0,V5g2_2E0,V6r2_2E0) ) ) ).

tff(thm_2EpatternMatches_2EGUARDS__ELIM__THM,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,F1_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(A_27c,A_27b))))),F0_2E0: tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)] :
      ( ! [V4g_2E0: tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),V5r_2E0: tyop_2Emin_2Efun(A_27c,A_27b),V3p_2E0: tyop_2Emin_2Efun(A_27c,A_27a),V2rs2_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V9x_2E0: A_27c] : ( app_2E2(A_27c,A_27b,app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(A_27c,A_27b),app_2E2(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(A_27c,A_27b)),app_2E2(tyop_2Emin_2Efun(A_27c,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(A_27c,A_27b))),app_2E2(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(A_27c,A_27b)))),F1_2E0,V4g_2E0),V5r_2E0),V3p_2E0),V2rs2_2E0),V9x_2E0) = c_2Ebool_2ECOND_2E3(A_27b,app_2E2(A_27c,tyop_2Emin_2Ebool,V4g_2E0,V9x_2E0),app_2E2(A_27c,A_27b,V5r_2E0,V9x_2E0),c_2EpatternMatches_2EPMATCH_2E2(A_27b,A_27a,app_2E2(A_27c,A_27a,V3p_2E0,V9x_2E0),V2rs2_2E0)) )
     => ( ! [V8x_2E0: A_27c] : ( app_2E2(A_27c,tyop_2Emin_2Ebool,F0_2E0,V8x_2E0) = c_2Ebool_2ET_2E0 )
       => ! [V0v_2E0: A_27a,V1rs1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rs2_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V3p_2E0: tyop_2Emin_2Efun(A_27c,A_27a),V4g_2E0: tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),V5r_2E0: tyop_2Emin_2Efun(A_27c,A_27b)] :
            ( ! [V6x1_2E0: A_27c,V7x2_2E0: A_27c] :
                ( ( app_2E2(A_27c,A_27a,V3p_2E0,V6x1_2E0) = app_2E2(A_27c,A_27a,V3p_2E0,V7x2_2E0) )
               => ( V6x1_2E0 = V7x2_2E0 ) )
           => ( c_2EpatternMatches_2EPMATCH_2E2(A_27b,A_27a,V0v_2E0,c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1rs1_2E0,c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27b,A_27c,A_27a,V3p_2E0,V4g_2E0,V5r_2E0),V2rs2_2E0))) = c_2EpatternMatches_2EPMATCH_2E2(A_27b,A_27a,V0v_2E0,c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1rs1_2E0,c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27b,A_27c,A_27a,V3p_2E0,F0_2E0,app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(A_27c,A_27b),app_2E2(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(A_27c,A_27b)),app_2E2(tyop_2Emin_2Efun(A_27c,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(A_27c,A_27b))),app_2E2(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(A_27c,A_27b)))),F1_2E0,V4g_2E0),V5r_2E0),V3p_2E0),V2rs2_2E0)),V2rs2_2E0))) ) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__FLATTEN__THM__SINGLE,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,F3_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),F1_2E0: tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),tyop_2Emin_2Efun(A_27b,A_27c)),F2_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))))),F0_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))))] :
      ( ! [V6x_2E0: A_27b,V7r_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))] : ( app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),app_2E2(A_27b,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),F3_2E0,V6x_2E0),V7r_2E0) = app_2E2(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),V7r_2E0,V6x_2E0) )
     => ( ! [V3rows_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),V6x_2E0: A_27b] : ( app_2E2(A_27b,A_27c,app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),tyop_2Emin_2Efun(A_27b,A_27c),F1_2E0,V3rows_2E0),V6x_2E0) = c_2EpatternMatches_2EPMATCH_2E2(A_27c,A_27b,V6x_2E0,c_2Elist_2EMAP_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),app_2E2(A_27b,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),F3_2E0,V6x_2E0),V3rows_2E0)) )
       => ( ! [V1p_2E0: tyop_2Emin_2Efun(A_27b,A_27a),V2g_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V8r_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))] : ( app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),app_2E2(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)))),F2_2E0,V1p_2E0),V2g_2E0),V8r_2E0) = c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E3(A_27c,A_27b,A_27a,V1p_2E0,V2g_2E0,V8r_2E0) )
         => ( ! [V4x_2E0: A_27b,V5r_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))] : ( app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),app_2E2(A_27b,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),F0_2E0,V4x_2E0),V5r_2E0) = app_2E2(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),V5r_2E0,V4x_2E0) )
           => ! [V0v_2E0: A_27a,V1p_2E0: tyop_2Emin_2Efun(A_27b,A_27a),V2g_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V3rows_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))))] :
                ( ! [V4x_2E0: A_27b] : p(c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2(A_27b,A_27c,V4x_2E0,c_2Elist_2EMAP_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),app_2E2(A_27b,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),F0_2E0,V4x_2E0),V3rows_2E0)))
               => p(c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(A_27a,A_27c,V0v_2E0,c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27c,A_27b,A_27a,V1p_2E0,V2g_2E0,app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),tyop_2Emin_2Efun(A_27b,A_27c),F1_2E0,V3rows_2E0)),c_2Elist_2ENIL_2E0(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)))),c_2Elist_2EMAP_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),app_2E2(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)))),F2_2E0,V1p_2E0),V2g_2E0),V3rows_2E0))) ) ) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__FLATTEN__THM,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,F3_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),F1_2E0: tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),tyop_2Emin_2Efun(A_27b,A_27c)),F2_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))))),F0_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))))] :
      ( ! [V8x_2E0: A_27b,V9r_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))] : ( app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),app_2E2(A_27b,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),F3_2E0,V8x_2E0),V9r_2E0) = app_2E2(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),V9r_2E0,V8x_2E0) )
     => ( ! [V5rows_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),V8x_2E0: A_27b] : ( app_2E2(A_27b,A_27c,app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),tyop_2Emin_2Efun(A_27b,A_27c),F1_2E0,V5rows_2E0),V8x_2E0) = c_2EpatternMatches_2EPMATCH_2E2(A_27c,A_27b,V8x_2E0,c_2Elist_2EMAP_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),app_2E2(A_27b,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),F3_2E0,V8x_2E0),V5rows_2E0)) )
       => ( ! [V1p_2E0: tyop_2Emin_2Efun(A_27b,A_27a),V2g_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V10r_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))] : ( app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),app_2E2(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)))),F2_2E0,V1p_2E0),V2g_2E0),V10r_2E0) = c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E3(A_27c,A_27b,A_27a,V1p_2E0,V2g_2E0,V10r_2E0) )
         => ( ! [V6x_2E0: A_27b,V7r_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))] : ( app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),app_2E2(A_27b,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),F0_2E0,V6x_2E0),V7r_2E0) = app_2E2(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),V7r_2E0,V6x_2E0) )
           => ! [V0v_2E0: A_27a,V1p_2E0: tyop_2Emin_2Efun(A_27b,A_27a),V2g_2E0: tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V3rows1_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),V4rows2_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),V5rows_2E0: tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))))] :
                ( ! [V6x_2E0: A_27b] : p(c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2(A_27b,A_27c,V6x_2E0,c_2Elist_2EMAP_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),app_2E2(A_27b,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),F0_2E0,V6x_2E0),V5rows_2E0)))
               => ( c_2EpatternMatches_2EPMATCH_2E2(A_27c,A_27a,V0v_2E0,c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),V3rows1_2E0,c_2Elist_2ECONS_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27c,A_27b,A_27a,V1p_2E0,V2g_2E0,app_2E2(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),tyop_2Emin_2Efun(A_27b,A_27c),F1_2E0,V5rows_2E0)),V4rows2_2E0))) = c_2EpatternMatches_2EPMATCH_2E2(A_27c,A_27a,V0v_2E0,c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),c_2Elist_2EAPPEND_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),V3rows1_2E0,c_2Elist_2EMAP_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),app_2E2(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),app_2E2(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)))),F2_2E0,V1p_2E0),V2g_2E0),V5rows_2E0)),V4rows2_2E0)) ) ) ) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__FLATTEN__FUN__PMATCH__ROW,conjecture,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,A_27d: $tType,F0_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,A_27d)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d)))))),F3_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,A_27d)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27d))),F2_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)))),F1_2E0: tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27b)))] :
      ( ! [V4p_27_2E0: tyop_2Emin_2Efun(A_27c,A_27a),V5g_27_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),V6r_27_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,A_27d)),V7x_2E0: A_27a] : ( app_2E2(A_27a,tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d)),app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,A_27d)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d))),app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,A_27d)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d)))),app_2E2(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,A_27d)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d))))),F0_2E0,V4p_27_2E0),V5g_27_2E0),V6r_27_2E0),V7x_2E0) = c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27d,A_27c,A_27a,V4p_27_2E0,app_2E2(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),V5g_27_2E0,V7x_2E0),app_2E2(A_27a,tyop_2Emin_2Efun(A_27c,A_27d),V6r_27_2E0,V7x_2E0)) )
     => ( ! [V6r_27_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,A_27d)),V4p_27_2E0: tyop_2Emin_2Efun(A_27c,A_27a),V10x_2E0: A_27c] : ( app_2E2(A_27c,A_27d,app_2E2(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27d),app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,A_27d)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27d)),F3_2E0,V6r_27_2E0),V4p_27_2E0),V10x_2E0) = app_2E2(A_27c,A_27d,app_2E2(A_27a,tyop_2Emin_2Efun(A_27c,A_27d),V6r_27_2E0,app_2E2(A_27c,A_27a,V4p_27_2E0,V10x_2E0)),V10x_2E0) )
       => ( ! [V3g_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V4p_27_2E0: tyop_2Emin_2Efun(A_27c,A_27a),V5g_27_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),V9x_2E0: A_27c] :
              ( p(app_2E2(A_27c,tyop_2Emin_2Ebool,app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool))),F2_2E0,V3g_2E0),V4p_27_2E0),V5g_27_2E0),V9x_2E0))
            <=> ( p(app_2E2(A_27a,tyop_2Emin_2Ebool,V3g_2E0,app_2E2(A_27c,A_27a,V4p_27_2E0,V9x_2E0)))
                & p(app_2E2(A_27c,tyop_2Emin_2Ebool,app_2E2(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),V5g_27_2E0,app_2E2(A_27c,A_27a,V4p_27_2E0,V9x_2E0)),V9x_2E0)) ) )
         => ( ! [V0p_2E0: tyop_2Emin_2Efun(A_27a,A_27b),V4p_27_2E0: tyop_2Emin_2Efun(A_27c,A_27a),V8x_2E0: A_27c] : ( app_2E2(A_27c,A_27b,app_2E2(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27b),app_2E2(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27b)),F1_2E0,V0p_2E0),V4p_27_2E0),V8x_2E0) = app_2E2(A_27a,A_27b,V0p_2E0,app_2E2(A_27c,A_27a,V4p_27_2E0,V8x_2E0)) )
           => ! [V0p_2E0: tyop_2Emin_2Efun(A_27a,A_27b)] :
                ( ! [V1x1_2E0: A_27a,V2x2_2E0: A_27a] :
                    ( ( app_2E2(A_27a,A_27b,V0p_2E0,V1x1_2E0) = app_2E2(A_27a,A_27b,V0p_2E0,V2x2_2E0) )
                   => ( V1x1_2E0 = V2x2_2E0 ) )
               => ! [V3g_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V4p_27_2E0: tyop_2Emin_2Efun(A_27c,A_27a),V5g_27_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),V6r_27_2E0: tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,A_27d))] : ( c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E3(A_27d,A_27a,A_27b,V0p_2E0,V3g_2E0,app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,A_27d)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d))),app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,A_27d)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d)))),app_2E2(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,A_27d)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d))))),F0_2E0,V4p_27_2E0),V5g_27_2E0),V6r_27_2E0)) = c_2EpatternMatches_2EPMATCH__ROW_2E3(A_27d,A_27c,A_27b,app_2E2(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27b),app_2E2(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27b)),F1_2E0,V0p_2E0),V4p_27_2E0),app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),app_2E2(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool))),F2_2E0,V3g_2E0),V4p_27_2E0),V5g_27_2E0),app_2E2(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27d),app_2E2(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,A_27d)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27d)),F3_2E0,V6r_27_2E0),V4p_27_2E0)) ) ) ) ) ) ) ).

%------------------------------------------------------------------------------
