%------------------------------------------------------------------------------
% File     : ITP007_4 : TPTP v9.2.0. Bugfixed v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : HOL4 syntactic export of thm_2EpatternMatches_2EPMATCH__FLATTEN__FUN__PMATCH__ROW.p, chainy mode
% Version  : [BG+19] axioms.
% English  :

% Refs     : [BG+19] Brown et al. (2019), GRUNGE: A Grand Unified ATP Chall
%          : [Gau20] Gauthier (2020), Email to Geoff Sutcliffe
% Source   : [BG+19]
% Names    : thm_2EpatternMatches_2EPMATCH__FLATTEN__FUN__PMATCH__ROW.p [Gau20]
%          : HL403001_4.p [TPAP]

% Status   : Theorem
% Rating   : 1.00 v7.5.0
% Syntax   : Number of formulae    : 16999 (5849 unt;7794 typ;   0 def)
%            Number of atoms       : 20985 (12044 equ)
%            Maximal formula atoms :  912 (   1 avg)
%            Number of connectives : 12474 ( 694   ~; 471   |;4566   &)
%                                         (3311 <=>;3432  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  360 (   5 avg)
%            Maximal term depth    :   53 (   3 avg)
%            Number of types       :  216 ( 215 usr)
%            Number of type conns  : 6642 (4292   >;2350   *;   0   +;   0  <<)
%            Number of predicates  :    2 (   1 usr;   0 prp; 1-2 aty)
%            Number of functors    : 2394 (2394 usr; 850 con; 0-6 aty)
%            Number of variables   : 42053 (29535   !;12518   ?;42053   :)
% SPC      : TF0_THM_EQU_NAR

% Comments :
% Bugfixes : v7.5.0 - Bugfixes in axioms and export.
%------------------------------------------------------------------------------
include('Axioms/ITP001/ITP002_4.ax').
include('Axioms/ITP001/ITP003_4.ax').
include('Axioms/ITP001/ITP004_4.ax').
include('Axioms/ITP001/ITP005_4.ax').
include('Axioms/ITP001/ITP006_4.ax').
include('Axioms/ITP001/ITP007_4.ax').
include('Axioms/ITP001/ITP008_4.ax').
include('Axioms/ITP001/ITP009_4.ax').
include('Axioms/ITP001/ITP010_4.ax').
include('Axioms/ITP001/ITP011_4.ax').
include('Axioms/ITP001/ITP012_4.ax').
include('Axioms/ITP001/ITP013_4.ax').
include('Axioms/ITP001/ITP014_4.ax').
include('Axioms/ITP001/ITP015_4.ax').
include('Axioms/ITP001/ITP016_4.ax').
include('Axioms/ITP001/ITP017_4.ax').
include('Axioms/ITP001/ITP018_4.ax').
include('Axioms/ITP001/ITP019_4.ax').
include('Axioms/ITP001/ITP020_4.ax').
include('Axioms/ITP001/ITP021_4.ax').
include('Axioms/ITP001/ITP022_4.ax').
include('Axioms/ITP001/ITP023_4.ax').
include('Axioms/ITP001/ITP024_4.ax').
include('Axioms/ITP001/ITP025_4.ax').
include('Axioms/ITP001/ITP026_4.ax').
include('Axioms/ITP001/ITP027_4.ax').
include('Axioms/ITP001/ITP028_4.ax').
include('Axioms/ITP001/ITP029_4.ax').
include('Axioms/ITP001/ITP030_4.ax').
include('Axioms/ITP001/ITP031_4.ax').
include('Axioms/ITP001/ITP032_4.ax').
include('Axioms/ITP001/ITP033_4.ax').
include('Axioms/ITP001/ITP034_4.ax').
include('Axioms/ITP001/ITP035_4.ax').
include('Axioms/ITP001/ITP036_4.ax').
include('Axioms/ITP001/ITP037_4.ax').
include('Axioms/ITP001/ITP038_4.ax').
include('Axioms/ITP001/ITP039_4.ax').
include('Axioms/ITP001/ITP040_4.ax').
include('Axioms/ITP001/ITP041_4.ax').
%------------------------------------------------------------------------------
tff(u,type,
    u: $tType ).

tff(d,type,
    d: $tType ).

tff(du,type,
    du: $tType ).

tff(mono_2Etyop_2Emin_2Ebool,type,
    mono_2Etyop_2Emin_2Ebool: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29: $tType ).

tff(mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29,type,
    mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29: $tType ).

tff(mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,type,
    mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29: $tType ).

tff(mono_2Etyop_2Enum_2Enum,type,
    mono_2Etyop_2Enum_2Enum: $tType ).

tff(mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29,type,
    mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29: $tType ).

tff(mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29,type,
    mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29: $tType ).

tff(tyop_2Elist_2Elist,type,
    tyop_2Elist_2Elist: d > d ).

tff(tyop_2Emin_2Ebool,type,
    tyop_2Emin_2Ebool: d ).

tff(tyop_2Emin_2Efun,type,
    tyop_2Emin_2Efun: ( d * d ) > d ).

tff(tyop_2Enum_2Enum,type,
    tyop_2Enum_2Enum: d ).

tff(tyop_2Eoption_2Eoption,type,
    tyop_2Eoption_2Eoption: d > d ).

tff(tyop_2Epair_2Eprod,type,
    tyop_2Epair_2Eprod: ( d * d ) > d ).

tff(s,type,
    s: ( d * u ) > du ).

tff(app_2E2,type,
    app_2E2: ( du * du ) > u ).

tff(p,type,
    p: mono_2Etyop_2Emin_2Ebool > $o ).

tff(combin_i_2E0,type,
    combin_i_2E0: u ).

tff(combin_k_2E0,type,
    combin_k_2E0: u ).

tff(combin_s_2E0,type,
    combin_s_2E0: u ).

tff(c_2Ebool_2E_21_2E0,type,
    c_2Ebool_2E_21_2E0: u ).

tff(c_2Ebool_2E_21_2E1,type,
    c_2Ebool_2E_21_2E1: du > u ).

tff(c_2Earithmetic_2E_2B_2E0,type,
    c_2Earithmetic_2E_2B_2E0: u ).

tff(c_2Earithmetic_2E_2B_2E2,type,
    c_2Earithmetic_2E_2B_2E2: ( du * du ) > u ).

tff(c_2Epair_2E_2C_2E0,type,
    c_2Epair_2E_2C_2E0: u ).

tff(c_2Epair_2E_2C_2E2,type,
    c_2Epair_2E_2C_2E2: ( du * du ) > u ).

tff(c_2Earithmetic_2E_2D_2E0,type,
    c_2Earithmetic_2E_2D_2E0: u ).

tff(c_2Earithmetic_2E_2D_2E2,type,
    c_2Earithmetic_2E_2D_2E2: ( du * du ) > u ).

tff(c_2Ebool_2E_2F_5C_2E0,type,
    c_2Ebool_2E_2F_5C_2E0: u ).

tff(c_2Ebool_2E_2F_5C_2E2,type,
    c_2Ebool_2E_2F_5C_2E2: ( du * du ) > u ).

tff(c_2Enum_2E0_2E0,type,
    c_2Enum_2E0_2E0: u ).

tff(c_2Eprim__rec_2E_3C_2E0,type,
    c_2Eprim__rec_2E_3C_2E0: u ).

tff(c_2Eprim__rec_2E_3C_2E2,type,
    c_2Eprim__rec_2E_3C_2E2: ( du * du ) > u ).

tff(c_2Emin_2E_3D_2E0,type,
    c_2Emin_2E_3D_2E0: u ).

tff(c_2Emin_2E_3D_2E2,type,
    c_2Emin_2E_3D_2E2: ( du * du ) > u ).

tff(c_2Emin_2E_3D_3D_3E_2E0,type,
    c_2Emin_2E_3D_3D_3E_2E0: u ).

tff(c_2Emin_2E_3D_3D_3E_2E2,type,
    c_2Emin_2E_3D_3D_3E_2E2: ( du * du ) > u ).

tff(c_2Earithmetic_2E_3E_3D_2E0,type,
    c_2Earithmetic_2E_3E_3D_2E0: u ).

tff(c_2Earithmetic_2E_3E_3D_2E2,type,
    c_2Earithmetic_2E_3E_3D_2E2: ( du * du ) > u ).

tff(c_2Ebool_2E_3F_2E0,type,
    c_2Ebool_2E_3F_2E0: u ).

tff(c_2Ebool_2E_3F_2E1,type,
    c_2Ebool_2E_3F_2E1: du > u ).

tff(c_2Emin_2E_40_2E0,type,
    c_2Emin_2E_40_2E0: u ).

tff(c_2Emin_2E_40_2E1,type,
    c_2Emin_2E_40_2E1: du > u ).

tff(c_2Elist_2EAPPEND_2E0,type,
    c_2Elist_2EAPPEND_2E0: u ).

tff(c_2Elist_2EAPPEND_2E2,type,
    c_2Elist_2EAPPEND_2E2: ( du * du ) > u ).

tff(c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E0,type,
    c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E0: u ).

tff(c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2,type,
    c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2: ( du * du ) > u ).

tff(c_2Ebool_2EARB_2E0,type,
    c_2Ebool_2EARB_2E0: u ).

tff(c_2Ebool_2ECOND_2E0,type,
    c_2Ebool_2ECOND_2E0: u ).

tff(c_2Ebool_2ECOND_2E3,type,
    c_2Ebool_2ECOND_2E3: ( du * du * du ) > u ).

tff(c_2Elist_2ECONS_2E0,type,
    c_2Elist_2ECONS_2E0: u ).

tff(c_2Elist_2ECONS_2E2,type,
    c_2Elist_2ECONS_2E2: ( du * du ) > u ).

tff(c_2Elist_2EEL_2E0,type,
    c_2Elist_2EEL_2E0: u ).

tff(c_2Elist_2EEL_2E2,type,
    c_2Elist_2EEL_2E2: ( du * du ) > u ).

tff(c_2Elist_2EEVERY_2E0,type,
    c_2Elist_2EEVERY_2E0: u ).

tff(c_2Elist_2EEVERY_2E2,type,
    c_2Elist_2EEVERY_2E2: ( du * du ) > u ).

tff(c_2Elist_2EEXISTS_2E0,type,
    c_2Elist_2EEXISTS_2E0: u ).

tff(c_2Elist_2EEXISTS_2E2,type,
    c_2Elist_2EEXISTS_2E2: ( du * du ) > u ).

tff(c_2Ebool_2EF_2E0,type,
    c_2Ebool_2EF_2E0: u ).

tff(c_2Elist_2EFILTER_2E0,type,
    c_2Elist_2EFILTER_2E0: u ).

tff(c_2Elist_2EFILTER_2E2,type,
    c_2Elist_2EFILTER_2E2: ( du * du ) > u ).

tff(c_2Epair_2EFST_2E0,type,
    c_2Epair_2EFST_2E0: u ).

tff(c_2Epair_2EFST_2E1,type,
    c_2Epair_2EFST_2E1: du > u ).

tff(c_2Ecombin_2EI_2E0,type,
    c_2Ecombin_2EI_2E0: u ).

tff(c_2Ebool_2EIN_2E0,type,
    c_2Ebool_2EIN_2E0: u ).

tff(c_2Ebool_2EIN_2E2,type,
    c_2Ebool_2EIN_2E2: ( du * du ) > u ).

tff(c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E0,type,
    c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E0: u ).

tff(c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4,type,
    c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4: ( du * du * du * du ) > u ).

tff(c_2Eoption_2EIS__SOME_2E0,type,
    c_2Eoption_2EIS__SOME_2E0: u ).

tff(c_2Eoption_2EIS__SOME_2E1,type,
    c_2Eoption_2EIS__SOME_2E1: du > u ).

tff(c_2Elist_2ELENGTH_2E0,type,
    c_2Elist_2ELENGTH_2E0: u ).

tff(c_2Elist_2ELENGTH_2E1,type,
    c_2Elist_2ELENGTH_2E1: du > u ).

tff(c_2Elist_2ELIST__TO__SET_2E0,type,
    c_2Elist_2ELIST__TO__SET_2E0: u ).

tff(c_2Elist_2ELIST__TO__SET_2E1,type,
    c_2Elist_2ELIST__TO__SET_2E1: du > u ).

tff(c_2Elist_2EMAP_2E0,type,
    c_2Elist_2EMAP_2E0: u ).

tff(c_2Elist_2EMAP_2E2,type,
    c_2Elist_2EMAP_2E2: ( du * du ) > u ).

tff(c_2Elist_2EMAP2_2E0,type,
    c_2Elist_2EMAP2_2E0: u ).

tff(c_2Elist_2EMAP2_2E3,type,
    c_2Elist_2EMAP2_2E3: ( du * du * du ) > u ).

tff(c_2Elist_2ENIL_2E0,type,
    c_2Elist_2ENIL_2E0: u ).

tff(c_2Eoption_2ENONE_2E0,type,
    c_2Eoption_2ENONE_2E0: u ).

tff(c_2Eoption_2EOPTION__MAP_2E0,type,
    c_2Eoption_2EOPTION__MAP_2E0: u ).

tff(c_2Eoption_2EOPTION__MAP_2E2,type,
    c_2Eoption_2EOPTION__MAP_2E2: ( du * du ) > u ).

tff(c_2EpatternMatches_2EPMATCH_2E0,type,
    c_2EpatternMatches_2EPMATCH_2E0: u ).

tff(c_2EpatternMatches_2EPMATCH_2E2,type,
    c_2EpatternMatches_2EPMATCH_2E2: ( du * du ) > u ).

tff(c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E0,type,
    c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E0: u ).

tff(c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E2,type,
    c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E2: ( du * du ) > u ).

tff(c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3,type,
    c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3: ( du * du * du ) > u ).

tff(c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E0,type,
    c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E0: u ).

tff(c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E3,type,
    c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E3: ( du * du * du ) > u ).

tff(c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E4,type,
    c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E4: ( du * du * du * du ) > u ).

tff(c_2EpatternMatches_2EPMATCH__INCOMPLETE_2E0,type,
    c_2EpatternMatches_2EPMATCH__INCOMPLETE_2E0: u ).

tff(c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E0,type,
    c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E0: u ).

tff(c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2,type,
    c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2: ( du * du ) > u ).

tff(c_2EpatternMatches_2EPMATCH__ROW_2E0,type,
    c_2EpatternMatches_2EPMATCH__ROW_2E0: u ).

tff(c_2EpatternMatches_2EPMATCH__ROW_2E3,type,
    c_2EpatternMatches_2EPMATCH__ROW_2E3: ( du * du * du ) > u ).

tff(c_2EpatternMatches_2EPMATCH__ROW_2E4,type,
    c_2EpatternMatches_2EPMATCH__ROW_2E4: ( du * du * du * du ) > u ).

tff(c_2EpatternMatches_2EPMATCH__ROW__COND_2E0,type,
    c_2EpatternMatches_2EPMATCH__ROW__COND_2E0: u ).

tff(c_2EpatternMatches_2EPMATCH__ROW__COND_2E4,type,
    c_2EpatternMatches_2EPMATCH__ROW__COND_2E4: ( du * du * du * du ) > u ).

tff(c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E0,type,
    c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E0: u ).

tff(c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3,type,
    c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3: ( du * du * du ) > u ).

tff(c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E0,type,
    c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E0: u ).

tff(c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E3,type,
    c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E3: ( du * du * du ) > u ).

tff(c_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ_2E0,type,
    c_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ_2E0: u ).

tff(c_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ_2E2,type,
    c_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ_2E2: ( du * du ) > u ).

tff(c_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__DISJ_2E0,type,
    c_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__DISJ_2E0: u ).

tff(c_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__DISJ_2E2,type,
    c_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__DISJ_2E2: ( du * du ) > u ).

tff(c_2Epair_2ESND_2E0,type,
    c_2Epair_2ESND_2E0: u ).

tff(c_2Epair_2ESND_2E1,type,
    c_2Epair_2ESND_2E1: du > u ).

tff(c_2Elist_2ESNOC_2E0,type,
    c_2Elist_2ESNOC_2E0: u ).

tff(c_2Elist_2ESNOC_2E2,type,
    c_2Elist_2ESNOC_2E2: ( du * du ) > u ).

tff(c_2Eoption_2ESOME_2E0,type,
    c_2Eoption_2ESOME_2E0: u ).

tff(c_2Eoption_2ESOME_2E1,type,
    c_2Eoption_2ESOME_2E1: du > u ).

tff(c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO_2E0,type,
    c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO_2E0: u ).

tff(c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO_2E2,type,
    c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO_2E2: ( du * du ) > u ).

tff(c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX_2E0,type,
    c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX_2E0: u ).

tff(c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX_2E4,type,
    c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX_2E4: ( du * du * du * du ) > u ).

tff(c_2Enum_2ESUC_2E0,type,
    c_2Enum_2ESUC_2E0: u ).

tff(c_2Enum_2ESUC_2E1,type,
    c_2Enum_2ESUC_2E1: du > u ).

tff(c_2Ebool_2ET_2E0,type,
    c_2Ebool_2ET_2E0: u ).

tff(c_2Elist_2ETAKE_2E0,type,
    c_2Elist_2ETAKE_2E0: u ).

tff(c_2Elist_2ETAKE_2E2,type,
    c_2Elist_2ETAKE_2E2: ( du * du ) > u ).

tff(c_2Elist_2EZIP_2E0,type,
    c_2Elist_2EZIP_2E0: u ).

tff(c_2Elist_2EZIP_2E1,type,
    c_2Elist_2EZIP_2E1: du > u ).

tff(c_2Ebool_2E_5C_2F_2E0,type,
    c_2Ebool_2E_5C_2F_2E0: u ).

tff(c_2Ebool_2E_5C_2F_2E2,type,
    c_2Ebool_2E_5C_2F_2E2: ( du * du ) > u ).

tff(c_2Eoption_2Eoption__CASE_2E0,type,
    c_2Eoption_2Eoption__CASE_2E0: u ).

tff(c_2Eoption_2Eoption__CASE_2E3,type,
    c_2Eoption_2Eoption__CASE_2E3: ( du * du * du ) > u ).

tff(c_2Eoption_2Esome_2E0,type,
    c_2Eoption_2Esome_2E0: u ).

tff(c_2Eoption_2Esome_2E1,type,
    c_2Eoption_2Esome_2E1: du > u ).

tff(c_2Ebool_2E_7E_2E0,type,
    c_2Ebool_2E_7E_2E0: u ).

tff(c_2Ebool_2E_7E_2E1,type,
    c_2Ebool_2E_7E_2E1: du > u ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool: ( mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29 * mono_2Etyop_2Emin_2Ebool ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29 * mono_2Etyop_2Emin_2Ebool ) > mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29 * mono_2Etyop_2Emin_2Ebool ) > mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29 * mono_2Etyop_2Emin_2Ebool ) > mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29 * mono_2Etyop_2Emin_2Ebool ) > mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29 * mono_2Etyop_2Emin_2Ebool ) > mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29 * mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29 ) > mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29 * mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29 ) > mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Emin_2Ebool,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Emin_2Ebool: ( mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29 * mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29 ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29 * mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29 ) > mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29 * mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29 ) > mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Enum_2Enum,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Enum_2Enum: ( mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29 * mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29 ) > mono_2Etyop_2Enum_2Enum ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29 * mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29 ) > mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Ebool,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Ebool: ( mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29 * mono_2Etyop_2Enum_2Enum ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29 * mono_2Etyop_2Enum_2Enum ) > mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29 * mono_2Etyop_2Enum_2Enum ) > mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 * mono_2Etyop_2Enum_2Enum ) > mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum: ( mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 * mono_2Etyop_2Enum_2Enum ) > mono_2Etyop_2Enum_2Enum ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Emin_2Ebool,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Emin_2Ebool: ( mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29 * mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29 ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,type,
    mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29: ( mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29 * mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29 ) > mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29 ).

tff(mono_2Ec_2Earithmetic_2E_2B_2E0,type,
    mono_2Ec_2Earithmetic_2E_2B_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 ).

tff(mono_2Ec_2Earithmetic_2E_2B_2E2,type,
    mono_2Ec_2Earithmetic_2E_2B_2E2: ( mono_2Etyop_2Enum_2Enum * mono_2Etyop_2Enum_2Enum ) > mono_2Etyop_2Enum_2Enum ).

tff(mono_2Ec_2Epair_2E_2C_2E0_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,type,
    mono_2Ec_2Epair_2E_2C_2E0_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29 ).

tff(mono_2Ec_2Epair_2E_2C_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,type,
    mono_2Ec_2Epair_2E_2C_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29: ( mono_2Etyop_2Emin_2Ebool * mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29 ) > mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29 ).

tff(mono_2Ec_2Earithmetic_2E_2D_2E0,type,
    mono_2Ec_2Earithmetic_2E_2D_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 ).

tff(mono_2Ec_2Earithmetic_2E_2D_2E2,type,
    mono_2Ec_2Earithmetic_2E_2D_2E2: ( mono_2Etyop_2Enum_2Enum * mono_2Etyop_2Enum_2Enum ) > mono_2Etyop_2Enum_2Enum ).

tff(mono_2Ec_2Ebool_2E_2F_5C_2E0,type,
    mono_2Ec_2Ebool_2E_2F_5C_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29 ).

tff(mono_2Ec_2Ebool_2E_2F_5C_2E2,type,
    mono_2Ec_2Ebool_2E_2F_5C_2E2: ( mono_2Etyop_2Emin_2Ebool * mono_2Etyop_2Emin_2Ebool ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Ec_2Enum_2E0_2E0,type,
    mono_2Ec_2Enum_2E0_2E0: mono_2Etyop_2Enum_2Enum ).

tff(mono_2Ec_2Eprim__rec_2E_3C_2E0,type,
    mono_2Ec_2Eprim__rec_2E_3C_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29 ).

tff(mono_2Ec_2Eprim__rec_2E_3C_2E2,type,
    mono_2Ec_2Eprim__rec_2E_3C_2E2: ( mono_2Etyop_2Enum_2Enum * mono_2Etyop_2Enum_2Enum ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Ec_2Emin_2E_3D_3D_3E_2E0,type,
    mono_2Ec_2Emin_2E_3D_3D_3E_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29 ).

tff(mono_2Ec_2Emin_2E_3D_3D_3E_2E2,type,
    mono_2Ec_2Emin_2E_3D_3D_3E_2E2: ( mono_2Etyop_2Emin_2Ebool * mono_2Etyop_2Emin_2Ebool ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Ec_2Earithmetic_2E_3E_3D_2E0,type,
    mono_2Ec_2Earithmetic_2E_3E_3D_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29 ).

tff(mono_2Ec_2Earithmetic_2E_3E_3D_2E2,type,
    mono_2Ec_2Earithmetic_2E_3E_3D_2E2: ( mono_2Etyop_2Enum_2Enum * mono_2Etyop_2Enum_2Enum ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Ec_2Elist_2ECONS_2E0_2Emono_2Etyop_2Emin_2Ebool,type,
    mono_2Ec_2Elist_2ECONS_2E0_2Emono_2Etyop_2Emin_2Ebool: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29 ).

tff(mono_2Ec_2Elist_2ECONS_2E2_2Emono_2Etyop_2Emin_2Ebool,type,
    mono_2Ec_2Elist_2ECONS_2E2_2Emono_2Etyop_2Emin_2Ebool: ( mono_2Etyop_2Emin_2Ebool * mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29 ) > mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29 ).

tff(mono_2Ec_2Elist_2EEL_2E0_2Emono_2Etyop_2Emin_2Ebool,type,
    mono_2Ec_2Elist_2EEL_2E0_2Emono_2Etyop_2Emin_2Ebool: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29 ).

tff(mono_2Ec_2Elist_2EEL_2E2_2Emono_2Etyop_2Emin_2Ebool,type,
    mono_2Ec_2Elist_2EEL_2E2_2Emono_2Etyop_2Emin_2Ebool: ( mono_2Etyop_2Enum_2Enum * mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29 ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Ec_2Ebool_2EF_2E0,type,
    mono_2Ec_2Ebool_2EF_2E0: mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Ec_2Epair_2EFST_2E0_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,type,
    mono_2Ec_2Epair_2EFST_2E0_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29 ).

tff(mono_2Ec_2Epair_2EFST_2E1_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,type,
    mono_2Ec_2Epair_2EFST_2E1_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29: mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29 > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Ec_2Elist_2ELENGTH_2E0_2Emono_2Etyop_2Emin_2Ebool,type,
    mono_2Ec_2Elist_2ELENGTH_2E0_2Emono_2Etyop_2Emin_2Ebool: mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29 ).

tff(mono_2Ec_2Elist_2ELENGTH_2E1_2Emono_2Etyop_2Emin_2Ebool,type,
    mono_2Ec_2Elist_2ELENGTH_2E1_2Emono_2Etyop_2Emin_2Ebool: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29 > mono_2Etyop_2Enum_2Enum ).

tff(mono_2Ec_2Elist_2EMAP2_2E0_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool,type,
    mono_2Ec_2Elist_2EMAP2_2E0_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29 ).

tff(mono_2Ec_2Elist_2EMAP2_2E3_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool,type,
    mono_2Ec_2Elist_2EMAP2_2E3_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool: ( mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29 * mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29 * mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29 ) > mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29 ).

tff(mono_2Ec_2Elist_2ENIL_2E0_2Emono_2Etyop_2Emin_2Ebool,type,
    mono_2Ec_2Elist_2ENIL_2E0_2Emono_2Etyop_2Emin_2Ebool: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29 ).

tff(mono_2Ec_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ_2E0,type,
    mono_2Ec_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29 ).

tff(mono_2Ec_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ_2E2,type,
    mono_2Ec_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ_2E2: ( mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29 * mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29 ) > mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29 ).

tff(mono_2Ec_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__DISJ_2E0,type,
    mono_2Ec_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__DISJ_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29 ).

tff(mono_2Ec_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__DISJ_2E2,type,
    mono_2Ec_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__DISJ_2E2: ( mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29 * mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29 ) > mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29 ).

tff(mono_2Ec_2Epair_2ESND_2E0_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,type,
    mono_2Ec_2Epair_2ESND_2E0_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29 ).

tff(mono_2Ec_2Epair_2ESND_2E1_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,type,
    mono_2Ec_2Epair_2ESND_2E1_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29: mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29 > mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29 ).

tff(mono_2Ec_2Elist_2ESNOC_2E0_2Emono_2Etyop_2Emin_2Ebool,type,
    mono_2Ec_2Elist_2ESNOC_2E0_2Emono_2Etyop_2Emin_2Ebool: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29 ).

tff(mono_2Ec_2Elist_2ESNOC_2E2_2Emono_2Etyop_2Emin_2Ebool,type,
    mono_2Ec_2Elist_2ESNOC_2E2_2Emono_2Etyop_2Emin_2Ebool: ( mono_2Etyop_2Emin_2Ebool * mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29 ) > mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29 ).

tff(mono_2Ec_2Eoption_2ESOME_2E0_2Emono_2Etyop_2Emin_2Ebool,type,
    mono_2Ec_2Eoption_2ESOME_2E0_2Emono_2Etyop_2Emin_2Ebool: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29 ).

tff(mono_2Ec_2Eoption_2ESOME_2E1_2Emono_2Etyop_2Emin_2Ebool,type,
    mono_2Ec_2Eoption_2ESOME_2E1_2Emono_2Etyop_2Emin_2Ebool: mono_2Etyop_2Emin_2Ebool > mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29 ).

tff(mono_2Ec_2Enum_2ESUC_2E0,type,
    mono_2Ec_2Enum_2ESUC_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ).

tff(mono_2Ec_2Enum_2ESUC_2E1,type,
    mono_2Ec_2Enum_2ESUC_2E1: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ).

tff(mono_2Ec_2Ebool_2ET_2E0,type,
    mono_2Ec_2Ebool_2ET_2E0: mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Ec_2Ebool_2E_5C_2F_2E0,type,
    mono_2Ec_2Ebool_2E_5C_2F_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29 ).

tff(mono_2Ec_2Ebool_2E_5C_2F_2E2,type,
    mono_2Ec_2Ebool_2E_5C_2F_2E2: ( mono_2Etyop_2Emin_2Ebool * mono_2Etyop_2Emin_2Ebool ) > mono_2Etyop_2Emin_2Ebool ).

tff(mono_2Ec_2Eoption_2Esome_2E0_2Emono_2Etyop_2Emin_2Ebool,type,
    mono_2Ec_2Eoption_2Esome_2E0_2Emono_2Etyop_2Emin_2Ebool: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29 ).

tff(mono_2Ec_2Eoption_2Esome_2E1_2Emono_2Etyop_2Emin_2Ebool,type,
    mono_2Ec_2Eoption_2Esome_2E1_2Emono_2Etyop_2Emin_2Ebool: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29 > mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29 ).

tff(mono_2Ec_2Ebool_2E_7E_2E0,type,
    mono_2Ec_2Ebool_2E_7E_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29 ).

tff(mono_2Ec_2Ebool_2E_7E_2E1,type,
    mono_2Ec_2Ebool_2E_7E_2E1: mono_2Etyop_2Emin_2Ebool > mono_2Etyop_2Emin_2Ebool ).

tff(i_mono_2Etyop_2Emin_2Ebool,type,
    i_mono_2Etyop_2Emin_2Ebool: mono_2Etyop_2Emin_2Ebool > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29: mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29: mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29 > u ).

tff(i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29 > u ).

tff(i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,type,
    i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29 > u ).

tff(i_mono_2Etyop_2Enum_2Enum,type,
    i_mono_2Etyop_2Enum_2Enum: mono_2Etyop_2Enum_2Enum > u ).

tff(i_mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29,type,
    i_mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29: mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29 > u ).

tff(i_mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29,type,
    i_mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29: mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29 > u ).

tff(j_mono_2Etyop_2Emin_2Ebool,type,
    j_mono_2Etyop_2Emin_2Ebool: du > mono_2Etyop_2Emin_2Ebool ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29 ).

tff(j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29: du > mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29 ).

tff(j_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,type,
    j_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29: du > mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29 ).

tff(j_mono_2Etyop_2Enum_2Enum,type,
    j_mono_2Etyop_2Enum_2Enum: du > mono_2Etyop_2Enum_2Enum ).

tff(j_mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29,type,
    j_mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29: du > mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29 ).

tff(j_mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29,type,
    j_mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29: du > mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29 ).

tff(reserved_2Eho_2Eeq__ext,axiom,
    ! [A_27a: d,A_27b: d,V0f_2E0: u,V1g_2E0: u] :
      ( ! [V2x_2E0: u] : ( s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V0f_2E0),s(A_27a,V2x_2E0))) = s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V1g_2E0),s(A_27a,V2x_2E0))) )
     => ( s(tyop_2Emin_2Efun(A_27a,A_27b),V0f_2E0) = s(tyop_2Emin_2Efun(A_27a,A_27b),V1g_2E0) ) ) ).

tff(reserved_2Eho_2Eboolext,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Ebool,V1_2E0: mono_2Etyop_2Emin_2Ebool] :
      ( ( p(V0_2E0)
      <=> p(V1_2E0) )
     => ( V0_2E0 = V1_2E0 ) ) ).

tff(reserved_2Eho_2Etruth,axiom,
    p(mono_2Ec_2Ebool_2ET_2E0) ).

tff(reserved_2Eho_2Enotfalse,axiom,
    ~ p(mono_2Ec_2Ebool_2EF_2E0) ).

tff(reserved_2Eho_2Ebool__cases__ax,axiom,
    ! [V0t_2E0: mono_2Etyop_2Emin_2Ebool] :
      ( ( V0t_2E0 = mono_2Ec_2Ebool_2ET_2E0 )
      | ( V0t_2E0 = mono_2Ec_2Ebool_2EF_2E0 ) ) ).

tff(reserved_2Eho_2Ei__thm,axiom,
    ! [A_27a: d,V0x_2E0: u] : ( s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27a),combin_i_2E0),s(A_27a,V0x_2E0))) = s(A_27a,V0x_2E0) ) ).

tff(reserved_2Eho_2Ek__thm,axiom,
    ! [A_27a: d,A_27b: d,V0x_2E0: u,V1y_2E0: u] : ( s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27b,A_27a),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27b,A_27a)),combin_k_2E0),s(A_27a,V0x_2E0))),s(A_27b,V1y_2E0))) = s(A_27a,V0x_2E0) ) ).

tff(reserved_2Eho_2Es__thm,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,V0f_2E0: u,V1g_2E0: u,V2x_2E0: u] : ( s(A_27c,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27c),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(A_27a,A_27c)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27b,A_27c)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(A_27a,A_27c))),combin_s_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27b,A_27c)),V0f_2E0))),s(tyop_2Emin_2Efun(A_27a,A_27b),V1g_2E0))),s(A_27a,V2x_2E0))) = s(A_27c,app_2E2(s(tyop_2Emin_2Efun(A_27b,A_27c),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27b,A_27c)),V0f_2E0),s(A_27a,V2x_2E0))),s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V1g_2E0),s(A_27a,V2x_2E0))))) ) ).

tff(reserved_2Elogic_2E_2F_5C,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Ebool,V1_2E0: mono_2Etyop_2Emin_2Ebool] :
      ( p(mono_2Ec_2Ebool_2E_2F_5C_2E2(V0_2E0,V1_2E0))
    <=> ( p(V0_2E0)
        & p(V1_2E0) ) ) ).

tff(reserved_2Elogic_2E_5C_2F,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Ebool,V1_2E0: mono_2Etyop_2Emin_2Ebool] :
      ( p(mono_2Ec_2Ebool_2E_5C_2F_2E2(V0_2E0,V1_2E0))
    <=> ( p(V0_2E0)
        | p(V1_2E0) ) ) ).

tff(reserved_2Elogic_2E_7E,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Ebool] :
      ( p(mono_2Ec_2Ebool_2E_7E_2E1(V0_2E0))
    <=> ~ p(V0_2E0) ) ).

tff(reserved_2Elogic_2E_3D_3D_3E,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Ebool,V1_2E0: mono_2Etyop_2Emin_2Ebool] :
      ( p(mono_2Ec_2Emin_2E_3D_3D_3E_2E2(V0_2E0,V1_2E0))
    <=> ( p(V0_2E0)
       => p(V1_2E0) ) ) ).

tff(reserved_2Elogic_2E_3D,axiom,
    ! [A_27a: d,V0_2E0: u,V1_2E0: u] :
      ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Emin_2E_3D_2E2(s(A_27a,V0_2E0),s(A_27a,V1_2E0)))))
    <=> ( s(A_27a,V0_2E0) = s(A_27a,V1_2E0) ) ) ).

tff(reserved_2Equant_2E_21,axiom,
    ! [A_27a: d,V0f_2E0: u] :
      ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Ebool_2E_21_2E1(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V0f_2E0)))))
    <=> ! [V1x_2E0: u] : p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V0f_2E0),s(A_27a,V1x_2E0))))) ) ).

tff(reserved_2Equant_2E_3F,axiom,
    ! [A_27a: d,V0f_2E0: u] :
      ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Ebool_2E_3F_2E1(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V0f_2E0)))))
    <=> ? [V1x_2E0: u] : p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V0f_2E0),s(A_27a,V1x_2E0))))) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,V0_2E0)))) = s(tyop_2Emin_2Ebool,V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool)),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool)),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool))),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool))),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)))),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)))),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Eoption_2Eoption(tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Eoption_2Eoption(tyop_2Emin_2Ebool)),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Eoption_2Eoption(tyop_2Emin_2Ebool)),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),tyop_2Eoption_2Eoption(tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),tyop_2Eoption_2Eoption(tyop_2Emin_2Ebool)),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),tyop_2Eoption_2Eoption(tyop_2Emin_2Ebool)),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool)))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool)))),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool)))),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool))),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool))),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Enum_2Enum),i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Enum_2Enum),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Enum_2Enum),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool))),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool))),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool)),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool)),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Enum_2Enum),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Enum_2Enum),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Enum_2Enum),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),tyop_2Emin_2Ebool),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),tyop_2Emin_2Ebool),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),V0_2E0)))) = s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(j_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),V0_2E0)))) = s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Enum_2Enum,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(j_mono_2Etyop_2Enum_2Enum(s(tyop_2Enum_2Enum,V0_2E0)))) = s(tyop_2Enum_2Enum,V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Eoption_2Eoption(tyop_2Emin_2Ebool),i_mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29(j_mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29(s(tyop_2Eoption_2Eoption(tyop_2Emin_2Ebool),V0_2E0)))) = s(tyop_2Eoption_2Eoption(tyop_2Emin_2Ebool),V0_2E0) ) ).

tff(ij_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: u] : ( s(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),i_mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(j_mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(s(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),V0_2E0)))) = s(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),V0_2E0) ) ).

tff(ji_2Emono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Ebool] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Eoption_2Eoption(tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),tyop_2Eoption_2Eoption(tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool)))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Enum_2Enum),i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Enum_2Enum),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29] : ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] : ( j_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Enum_2Enum,axiom,
    ! [V0_2E0: mono_2Etyop_2Enum_2Enum] : ( j_mono_2Etyop_2Enum_2Enum(s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29] : ( j_mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29(s(tyop_2Eoption_2Eoption(tyop_2Emin_2Ebool),i_mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29(V0_2E0))) = V0_2E0 ) ).

tff(ji_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29] : ( j_mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(s(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),i_mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(V0_2E0))) = V0_2E0 ) ).

tff(arityeq1_2Ec_2Ebool_2E_21_2E1_2Emono_2EA_27a,axiom,
    ! [A_27a: d,X0_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Ebool_2E_21_2E1(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),X0_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),c_2Ebool_2E_21_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),X0_2E0)))) ) ).

tff(arityeq2_2Ec_2Earithmetic_2E_2B_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Enum_2Enum,X1_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Earithmetic_2E_2B_2E2(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(mono_2Ec_2Earithmetic_2E_2B_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Epair_2E_2C_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,axiom,
    ! [X0_2E0: mono_2Etyop_2Emin_2Ebool,X1_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] : ( mono_2Ec_2Epair_2E_2C_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29(mono_2Ec_2Epair_2E_2C_2E0_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Epair_2E_2C_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Elist_2Elist_28A_27a_29,axiom,
    ! [A_27a: d,X0_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,X1_2E0: u] : ( s(tyop_2Epair_2Eprod(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(A_27a)),c_2Epair_2E_2C_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(X0_2E0)),s(tyop_2Elist_2Elist(A_27a),X1_2E0))) = s(tyop_2Epair_2Eprod(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(A_27a)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27a),tyop_2Epair_2Eprod(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(A_27a))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27a),tyop_2Epair_2Eprod(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(A_27a)))),c_2Epair_2E_2C_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(X0_2E0)))),s(tyop_2Elist_2Elist(A_27a),X1_2E0))) ) ).

tff(arityeq2_2Ec_2Earithmetic_2E_2D_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Enum_2Enum,X1_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Earithmetic_2E_2D_2E2(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(mono_2Ec_2Earithmetic_2E_2D_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Ebool_2E_2F_5C_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Emin_2Ebool,X1_2E0: mono_2Etyop_2Emin_2Ebool] :
      ( ( p(X0_2E0)
        & p(X1_2E0) )
    <=> p(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(mono_2Ec_2Ebool_2E_2F_5C_2E0,X0_2E0),X1_2E0)) ) ).

tff(arityeq2_2Ec_2Eprim__rec_2E_3C_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Enum_2Enum,X1_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Eprim__rec_2E_3C_2E2(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29(mono_2Ec_2Eprim__rec_2E_3C_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Emin_2E_3D_2E2_2Emono_2EA_27a,axiom,
    ! [A_27a: d,X0_2E0: u,X1_2E0: u] :
      ( ( s(A_27a,X0_2E0) = s(A_27a,X1_2E0) )
    <=> p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)),c_2Emin_2E_3D_2E0),s(A_27a,X0_2E0))),s(A_27a,X1_2E0))))) ) ).

tff(arityeq2_2Ec_2Emin_2E_3D_3D_3E_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Emin_2Ebool,X1_2E0: mono_2Etyop_2Emin_2Ebool] :
      ( ( p(X0_2E0)
       => p(X1_2E0) )
    <=> p(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(mono_2Ec_2Emin_2E_3D_3D_3E_2E0,X0_2E0),X1_2E0)) ) ).

tff(arityeq2_2Ec_2Earithmetic_2E_3E_3D_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Enum_2Enum,X1_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Earithmetic_2E_3E_3D_2E2(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29(mono_2Ec_2Earithmetic_2E_3E_3D_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq1_2Ec_2Ebool_2E_3F_2E1_2Emono_2EA_27a,axiom,
    ! [A_27a: d,X0_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Ebool_2E_3F_2E1(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),X0_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),c_2Ebool_2E_3F_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),X0_2E0)))) ) ).

tff(arityeq1_2Ec_2Emin_2E_40_2E1_2Emono_2EA_27a,axiom,
    ! [A_27a: d,X0_2E0: u] : ( s(A_27a,c_2Emin_2E_40_2E1(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),X0_2E0))) = s(A_27a,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),A_27a),c_2Emin_2E_40_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),X0_2E0))) ) ).

tff(arityeq1_2Ec_2Emin_2E_40_2E1_2Emono_2EA_27b,axiom,
    ! [A_27b: d,X0_2E0: u] : ( s(A_27b,c_2Emin_2E_40_2E1(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X0_2E0))) = s(A_27b,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),A_27b),c_2Emin_2E_40_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X0_2E0))) ) ).

tff(arityeq1_2Ec_2Emin_2E_40_2E1_2Emono_2EA_27d,axiom,
    ! [A_27d: d,X0_2E0: u] : ( s(A_27d,c_2Emin_2E_40_2E1(s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),X0_2E0))) = s(A_27d,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),A_27d),c_2Emin_2E_40_2E0),s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),X0_2E0))) ) ).

tff(arityeq2_2Ec_2Elist_2EAPPEND_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27a_2Ctyop_2Eoption_2Eoption_28A_27b_29_29,axiom,
    ! [A_27a: d,A_27b: d,X0_2E0: u,X1_2E0: u] : ( s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0))) = s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))))),c_2Elist_2EAPPEND_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0))) ) ).

tff(arityeq2_2Ec_2Elist_2EAPPEND_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27a_2Ctyop_2Eoption_2Eoption_28A_27c_29_29,axiom,
    ! [A_27a: d,A_27c: d,X0_2E0: u,X1_2E0: u] : ( s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),X1_2E0))) = s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))))),c_2Elist_2EAPPEND_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),X1_2E0))) ) ).

tff(arityeq2_2Ec_2Elist_2EAPPEND_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27b_2Ctyop_2Eoption_2Eoption_28A_27c_29_29,axiom,
    ! [A_27b: d,A_27c: d,X0_2E0: u,X1_2E0: u] : ( s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),X1_2E0))) = s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))))),c_2Elist_2EAPPEND_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),X1_2E0))) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2_2Emono_2EA_27a,axiom,
    ! [A_27a: d,X0_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,X1_2E0: u] : ( s(tyop_2Elist_2Elist(A_27a),c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(X0_2E0)),s(tyop_2Elist_2Elist(A_27a),X1_2E0))) = s(tyop_2Elist_2Elist(A_27a),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27a),tyop_2Elist_2Elist(A_27a)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27a),tyop_2Elist_2Elist(A_27a))),c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(X0_2E0)))),s(tyop_2Elist_2Elist(A_27a),X1_2E0))) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2_2Emono_2EA_27b,axiom,
    ! [A_27b: d,X0_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,X1_2E0: u] : ( s(tyop_2Elist_2Elist(A_27b),c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(X0_2E0)),s(tyop_2Elist_2Elist(A_27b),X1_2E0))) = s(tyop_2Elist_2Elist(A_27b),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27b),tyop_2Elist_2Elist(A_27b)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27b),tyop_2Elist_2Elist(A_27b))),c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(X0_2E0)))),s(tyop_2Elist_2Elist(A_27b),X1_2E0))) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2_2Emono_2EA_27c,axiom,
    ! [A_27c: d,X0_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,X1_2E0: u] : ( s(tyop_2Elist_2Elist(A_27c),c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(X0_2E0)),s(tyop_2Elist_2Elist(A_27c),X1_2E0))) = s(tyop_2Elist_2Elist(A_27c),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27c),tyop_2Elist_2Elist(A_27c)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27c),tyop_2Elist_2Elist(A_27c))),c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(X0_2E0)))),s(tyop_2Elist_2Elist(A_27c),X1_2E0))) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27a_2Ctyop_2Eoption_2Eoption_28A_27b_29_29,axiom,
    ! [A_27a: d,A_27b: d,X0_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,X1_2E0: u] : ( s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(X0_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0))) = s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))))),c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(X0_2E0)))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0))) ) ).

tff(arityeq3_2Ec_2Ebool_2ECOND_2E3_2Emono_2EA_27b,axiom,
    ! [A_27b: d,X0_2E0: mono_2Etyop_2Emin_2Ebool,X1_2E0: u,X2_2E0: u] : ( s(A_27b,c_2Ebool_2ECOND_2E3(s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(X0_2E0)),s(A_27b,X1_2E0),s(A_27b,X2_2E0))) = s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27b,A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,A_27b)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,A_27b))),c_2Ebool_2ECOND_2E0),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(X0_2E0)))),s(A_27b,X1_2E0))),s(A_27b,X2_2E0))) ) ).

tff(arityeq3_2Ec_2Ebool_2ECOND_2E3_2Emono_2EA_27c,axiom,
    ! [A_27c: d,X0_2E0: mono_2Etyop_2Emin_2Ebool,X1_2E0: u,X2_2E0: u] : ( s(A_27c,c_2Ebool_2ECOND_2E3(s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(X0_2E0)),s(A_27c,X1_2E0),s(A_27c,X2_2E0))) = s(A_27c,app_2E2(s(tyop_2Emin_2Efun(A_27c,A_27c),app_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27c,A_27c)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27c,A_27c))),c_2Ebool_2ECOND_2E0),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(X0_2E0)))),s(A_27c,X1_2E0))),s(A_27c,X2_2E0))) ) ).

tff(arityeq2_2Ec_2Elist_2ECONS_2E2_2Emono_2EA_27b,axiom,
    ! [A_27b: d,X0_2E0: u,X1_2E0: u] : ( s(tyop_2Elist_2Elist(A_27b),c_2Elist_2ECONS_2E2(s(A_27b,X0_2E0),s(tyop_2Elist_2Elist(A_27b),X1_2E0))) = s(tyop_2Elist_2Elist(A_27b),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27b),tyop_2Elist_2Elist(A_27b)),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27b),tyop_2Elist_2Elist(A_27b))),c_2Elist_2ECONS_2E0),s(A_27b,X0_2E0))),s(tyop_2Elist_2Elist(A_27b),X1_2E0))) ) ).

tff(arityeq2_2Ec_2Elist_2ECONS_2E2_2Emono_2EA_27c,axiom,
    ! [A_27c: d,X0_2E0: u,X1_2E0: u] : ( s(tyop_2Elist_2Elist(A_27c),c_2Elist_2ECONS_2E2(s(A_27c,X0_2E0),s(tyop_2Elist_2Elist(A_27c),X1_2E0))) = s(tyop_2Elist_2Elist(A_27c),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27c),tyop_2Elist_2Elist(A_27c)),app_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(tyop_2Elist_2Elist(A_27c),tyop_2Elist_2Elist(A_27c))),c_2Elist_2ECONS_2E0),s(A_27c,X0_2E0))),s(tyop_2Elist_2Elist(A_27c),X1_2E0))) ) ).

tff(arityeq2_2Ec_2Elist_2ECONS_2E2_2Emono_2Etyop_2Emin_2Ebool,axiom,
    ! [X0_2E0: mono_2Etyop_2Emin_2Ebool,X1_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] : ( mono_2Ec_2Elist_2ECONS_2E2_2Emono_2Etyop_2Emin_2Ebool(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(mono_2Ec_2Elist_2ECONS_2E0_2Emono_2Etyop_2Emin_2Ebool,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2ECONS_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27a_2Ctyop_2Eoption_2Eoption_28A_27b_29_29,axiom,
    ! [A_27a: d,A_27b: d,X0_2E0: u,X1_2E0: u] : ( s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0))) = s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))))),c_2Elist_2ECONS_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0))) ) ).

tff(arityeq2_2Ec_2Elist_2ECONS_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27a_2Ctyop_2Eoption_2Eoption_28A_27c_29_29,axiom,
    ! [A_27a: d,A_27c: d,X0_2E0: u,X1_2E0: u] : ( s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),X1_2E0))) = s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))))),c_2Elist_2ECONS_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),X1_2E0))) ) ).

tff(arityeq2_2Ec_2Elist_2ECONS_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27b_2Ctyop_2Eoption_2Eoption_28A_27a_29_29,axiom,
    ! [A_27a: d,A_27b: d,X0_2E0: u,X1_2E0: u] : ( s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),X1_2E0))) = s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))))),c_2Elist_2ECONS_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),X1_2E0))) ) ).

tff(arityeq2_2Ec_2Elist_2ECONS_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27b_2Ctyop_2Eoption_2Eoption_28A_27c_29_29,axiom,
    ! [A_27b: d,A_27c: d,X0_2E0: u,X1_2E0: u] : ( s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),X1_2E0))) = s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))))),c_2Elist_2ECONS_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),X1_2E0))) ) ).

tff(arityeq2_2Ec_2Elist_2ECONS_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27c_2Ctyop_2Eoption_2Eoption_28A_27a_29_29,axiom,
    ! [A_27a: d,A_27c: d,X0_2E0: u,X1_2E0: u] : ( s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a)),X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))),X1_2E0))) = s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a)),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))))),c_2Elist_2ECONS_2E0),s(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a)),X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))),X1_2E0))) ) ).

tff(arityeq2_2Ec_2Elist_2ECONS_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27c_2Ctyop_2Eoption_2Eoption_28A_27d_29_29,axiom,
    ! [A_27c: d,A_27d: d,X0_2E0: u,X1_2E0: u] : ( s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d)),X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d))),X1_2E0))) = s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d)),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d))))),c_2Elist_2ECONS_2E0),s(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d)),X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d))),X1_2E0))) ) ).

tff(arityeq2_2Ec_2Elist_2EEL_2E2_2Emono_2Etyop_2Emin_2Ebool,axiom,
    ! [X0_2E0: mono_2Etyop_2Enum_2Enum,X1_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] : ( mono_2Ec_2Elist_2EEL_2E2_2Emono_2Etyop_2Emin_2Ebool(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29(mono_2Ec_2Elist_2EEL_2E0_2Emono_2Etyop_2Emin_2Ebool,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2EEL_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27a_2Ctyop_2Eoption_2Eoption_28A_27b_29_29,axiom,
    ! [A_27a: d,A_27b: d,X0_2E0: mono_2Etyop_2Enum_2Enum,X1_2E0: u] : ( s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),c_2Elist_2EEL_2E2(s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(X0_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0))) = s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))),c_2Elist_2EEL_2E0),s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(X0_2E0)))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0))) ) ).

tff(arityeq2_2Ec_2Elist_2EEVERY_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27a_2Ctyop_2Eoption_2Eoption_28A_27b_29_29,axiom,
    ! [A_27a: d,A_27b: d,X0_2E0: u,X1_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Elist_2EEVERY_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Ebool)),c_2Elist_2EEVERY_2E0),s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0)))) ) ).

tff(arityeq2_2Ec_2Elist_2EEVERY_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27a_2Ctyop_2Eoption_2Eoption_28A_27c_29_29,axiom,
    ! [A_27a: d,A_27c: d,X0_2E0: u,X1_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Elist_2EEVERY_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool),X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),X1_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Ebool)),c_2Elist_2EEVERY_2E0),s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool),X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),X1_2E0)))) ) ).

tff(arityeq2_2Ec_2Elist_2EEVERY_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27b_2Ctyop_2Eoption_2Eoption_28A_27c_29_29,axiom,
    ! [A_27b: d,A_27c: d,X0_2E0: u,X1_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Elist_2EEVERY_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool),X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),X1_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Ebool)),c_2Elist_2EEVERY_2E0),s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool),X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),X1_2E0)))) ) ).

tff(arityeq2_2Ec_2Elist_2EEXISTS_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27a_2Ctyop_2Eoption_2Eoption_28A_27b_29_29,axiom,
    ! [A_27a: d,A_27b: d,X0_2E0: u,X1_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Elist_2EEXISTS_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Ebool)),c_2Elist_2EEXISTS_2E0),s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0)))) ) ).

tff(arityeq2_2Ec_2Elist_2EFILTER_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2CA_27a_29,axiom,
    ! [A_27a: d,X0_2E0: u,X1_2E0: u] : ( s(tyop_2Elist_2Elist(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a)),c_2Elist_2EFILTER_2E2(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a),tyop_2Emin_2Ebool),X0_2E0),s(tyop_2Elist_2Elist(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a)),X1_2E0))) = s(tyop_2Elist_2Elist(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a)),tyop_2Elist_2Elist(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a),tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a)),tyop_2Elist_2Elist(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a)))),c_2Elist_2EFILTER_2E0),s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a),tyop_2Emin_2Ebool),X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a)),X1_2E0))) ) ).

tff(arityeq1_2Ec_2Epair_2EFST_2E1_2Emono_2Etyop_2Emin_2Ebool_20mono_2EA_27a,axiom,
    ! [A_27a: d,X0_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Epair_2EFST_2E1(s(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a),X0_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a),tyop_2Emin_2Ebool),c_2Epair_2EFST_2E0),s(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a),X0_2E0)))) ) ).

tff(arityeq1_2Ec_2Epair_2EFST_2E1_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,axiom,
    ! [X0_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29] : ( mono_2Ec_2Epair_2EFST_2E1_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(X0_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Emin_2Ebool(mono_2Ec_2Epair_2EFST_2E0_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,X0_2E0) ) ).

tff(arityeq2_2Ec_2Ebool_2EIN_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27a_2Ctyop_2Eoption_2Eoption_28A_27b_29_29,axiom,
    ! [A_27a: d,A_27b: d,X0_2E0: u,X1_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Ebool_2EIN_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),X0_2E0),s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),X1_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)),c_2Ebool_2EIN_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),X0_2E0))),s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),X1_2E0)))) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4_2Emono_2EA_27a_20mono_2EA_27b,axiom,
    ! [A_27a: d,A_27b: d,X0_2E0: u,X1_2E0: u,X2_2E0: mono_2Etyop_2Emin_2Ebool,X3_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(s(A_27a,X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(X2_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(X3_2E0))))) = mono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool))),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)))),c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E0),s(A_27a,X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0)))),X2_2E0),X3_2E0) ) ).

tff(arityeq1_2Ec_2Eoption_2EIS__SOME_2E1_2Emono_2EA_27b,axiom,
    ! [A_27b: d,X0_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Eoption_2EIS__SOME_2E1(s(tyop_2Eoption_2Eoption(A_27b),X0_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Eoption_2Eoption(A_27b),tyop_2Emin_2Ebool),c_2Eoption_2EIS__SOME_2E0),s(tyop_2Eoption_2Eoption(A_27b),X0_2E0)))) ) ).

tff(arityeq1_2Ec_2Elist_2ELENGTH_2E1_2Emono_2Etyop_2Emin_2Ebool,axiom,
    ! [X0_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] : ( mono_2Ec_2Elist_2ELENGTH_2E1_2Emono_2Etyop_2Emin_2Ebool(X0_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Enum_2Enum(mono_2Ec_2Elist_2ELENGTH_2E0_2Emono_2Etyop_2Emin_2Ebool,X0_2E0) ) ).

tff(arityeq1_2Ec_2Elist_2ELENGTH_2E1_2Emono_2Etyop_2Emin_2Efun_28A_27a_2Ctyop_2Eoption_2Eoption_28A_27b_29_29,axiom,
    ! [A_27a: d,A_27b: d,X0_2E0: u] : ( j_mono_2Etyop_2Enum_2Enum(s(tyop_2Enum_2Enum,c_2Elist_2ELENGTH_2E1(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X0_2E0)))) = j_mono_2Etyop_2Enum_2Enum(s(tyop_2Enum_2Enum,app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Enum_2Enum),c_2Elist_2ELENGTH_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X0_2E0)))) ) ).

tff(arityeq1_2Ec_2Elist_2ELIST__TO__SET_2E1_2Emono_2Etyop_2Emin_2Efun_28A_27a_2Ctyop_2Eoption_2Eoption_28A_27b_29_29,axiom,
    ! [A_27a: d,A_27b: d,X0_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),c_2Elist_2ELIST__TO__SET_2E1(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X0_2E0))) = s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool)),c_2Elist_2ELIST__TO__SET_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X0_2E0))) ) ).

tff(arityeq2_2Ec_2Elist_2EMAP_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27b_2Ctyop_2Emin_2Efun_28A_27b_2Ctyop_2Eoption_2Eoption_28A_27c_29_29_29_20mono_2Etyop_2Emin_2Efun_28A_27a_2Ctyop_2Eoption_2Eoption_28A_27c_29_29,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,X0_2E0: u,X1_2E0: u] : ( s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2EMAP_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),X1_2E0))) = s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))))),c_2Elist_2EMAP_2E0),s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),X1_2E0))) ) ).

tff(arityeq2_2Ec_2Elist_2EMAP_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27b_2Ctyop_2Emin_2Efun_28A_27b_2Ctyop_2Eoption_2Eoption_28A_27c_29_29_29_20mono_2Etyop_2Emin_2Efun_28A_27b_2Ctyop_2Eoption_2Eoption_28A_27c_29_29,axiom,
    ! [A_27b: d,A_27c: d,X0_2E0: u,X1_2E0: u] : ( s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2EMAP_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),X1_2E0))) = s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))))),c_2Elist_2EMAP_2E0),s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),X1_2E0))) ) ).

tff(arityeq2_2Ec_2Elist_2EMAP_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2CA_27a_29_20mono_2EA_27a,axiom,
    ! [A_27a: d,X0_2E0: u,X1_2E0: u] : ( s(tyop_2Elist_2Elist(A_27a),c_2Elist_2EMAP_2E2(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a),A_27a),X0_2E0),s(tyop_2Elist_2Elist(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a)),X1_2E0))) = s(tyop_2Elist_2Elist(A_27a),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a)),tyop_2Elist_2Elist(A_27a)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a),A_27a),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a)),tyop_2Elist_2Elist(A_27a))),c_2Elist_2EMAP_2E0),s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a),A_27a),X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a)),X1_2E0))) ) ).

tff(arityeq3_2Ec_2Elist_2EMAP2_2E3_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool,axiom,
    ! [X0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29,X1_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,X2_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] : ( mono_2Ec_2Elist_2EMAP2_2E3_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool(X0_2E0,X1_2E0,X2_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(mono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29(mono_2Ec_2Elist_2EMAP2_2E0_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool,X0_2E0),X1_2E0),X2_2E0) ) ).

tff(arityeq2_2Ec_2Eoption_2EOPTION__MAP_2E2_2Emono_2EA_27b_20mono_2EA_27a,axiom,
    ! [A_27a: d,A_27b: d,X0_2E0: u,X1_2E0: u] : ( s(tyop_2Eoption_2Eoption(A_27a),c_2Eoption_2EOPTION__MAP_2E2(s(tyop_2Emin_2Efun(A_27b,A_27a),X0_2E0),s(tyop_2Eoption_2Eoption(A_27b),X1_2E0))) = s(tyop_2Eoption_2Eoption(A_27a),app_2E2(s(tyop_2Emin_2Efun(tyop_2Eoption_2Eoption(A_27b),tyop_2Eoption_2Eoption(A_27a)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Eoption_2Eoption(A_27b),tyop_2Eoption_2Eoption(A_27a))),c_2Eoption_2EOPTION__MAP_2E0),s(tyop_2Emin_2Efun(A_27b,A_27a),X0_2E0))),s(tyop_2Eoption_2Eoption(A_27b),X1_2E0))) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EPMATCH_2E2_2Emono_2EA_27b_20mono_2EA_27a,axiom,
    ! [A_27a: d,A_27b: d,X0_2E0: u,X1_2E0: u] : ( s(A_27b,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0))) = s(A_27b,app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),A_27b)),c_2EpatternMatches_2EPMATCH_2E0),s(A_27a,X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0))) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EPMATCH_2E2_2Emono_2EA_27c_20mono_2EA_27a,axiom,
    ! [A_27a: d,A_27c: d,X0_2E0: u,X1_2E0: u] : ( s(A_27c,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),X1_2E0))) = s(A_27c,app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),A_27c),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),A_27c)),c_2EpatternMatches_2EPMATCH_2E0),s(A_27a,X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),X1_2E0))) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EPMATCH_2E2_2Emono_2EA_27a_20mono_2EA_27b,axiom,
    ! [A_27a: d,A_27b: d,X0_2E0: u,X1_2E0: u] : ( s(A_27a,c_2EpatternMatches_2EPMATCH_2E2(s(A_27b,X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),X1_2E0))) = s(A_27a,app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),A_27a),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),A_27a)),c_2EpatternMatches_2EPMATCH_2E0),s(A_27b,X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),X1_2E0))) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EPMATCH_2E2_2Emono_2EA_27c_20mono_2EA_27b,axiom,
    ! [A_27b: d,A_27c: d,X0_2E0: u,X1_2E0: u] : ( s(A_27c,c_2EpatternMatches_2EPMATCH_2E2(s(A_27b,X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),X1_2E0))) = s(A_27c,app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),A_27c),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),A_27c)),c_2EpatternMatches_2EPMATCH_2E0),s(A_27b,X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),X1_2E0))) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EPMATCH_2E2_2Emono_2EA_27a_20mono_2EA_27c,axiom,
    ! [A_27a: d,A_27c: d,X0_2E0: u,X1_2E0: u] : ( s(A_27a,c_2EpatternMatches_2EPMATCH_2E2(s(A_27c,X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))),X1_2E0))) = s(A_27a,app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))),A_27a),app_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))),A_27a)),c_2EpatternMatches_2EPMATCH_2E0),s(A_27c,X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))),X1_2E0))) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E2_2Emono_2EA_27a_20mono_2EA_27b,axiom,
    ! [A_27a: d,A_27b: d,X0_2E0: u,X1_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Ebool),c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E2(s(A_27a,X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0))) = s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Ebool))),c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E0),s(A_27a,X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0))) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3_2Emono_2EA_27a_20mono_2EA_27b,axiom,
    ! [A_27a: d,A_27b: d,X0_2E0: u,X1_2E0: u,X2_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(s(A_27a,X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X2_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Ebool))),c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E0),s(A_27a,X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X2_2E0)))) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3_2Emono_2EA_27a_20mono_2EA_27c,axiom,
    ! [A_27a: d,A_27c: d,X0_2E0: u,X1_2E0: u,X2_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(s(A_27a,X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),X1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),X2_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Ebool))),c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E0),s(A_27a,X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),X1_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),X2_2E0)))) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E2_2Emono_2EA_27b_20mono_2EA_27a,axiom,
    ! [A_27a: d,A_27b: d,X0_2E0: u,X1_2E0: u] : ( s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Emin_2Ebool),c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E2(s(A_27b,X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),X1_2E0))) = s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Emin_2Ebool))),c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E0),s(A_27b,X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),X1_2E0))) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E3_2Emono_2EA_27d_20mono_2EA_27a_20mono_2EA_27b,axiom,
    ! [A_27a: d,A_27b: d,A_27d: d,X0_2E0: u,X1_2E0: u,X2_2E0: u] : ( s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27d)),c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E3(s(tyop_2Emin_2Efun(A_27a,A_27b),X0_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),X1_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d))),X2_2E0))) = s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27d)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27d))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27d)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27d))))),c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E0),s(tyop_2Emin_2Efun(A_27a,A_27b),X0_2E0))),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),X1_2E0))),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d))),X2_2E0))) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E3_2Emono_2EA_27c_20mono_2EA_27b_20mono_2EA_27a,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,X0_2E0: u,X1_2E0: u,X2_2E0: u] : ( s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E3(s(tyop_2Emin_2Efun(A_27b,A_27a),X0_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X1_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),X2_2E0))) = s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))))),c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E0),s(tyop_2Emin_2Efun(A_27b,A_27a),X0_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X1_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),X2_2E0))) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E4_2Emono_2EA_27a_20mono_2EA_27b_20mono_2EA_27c,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,X0_2E0: u,X1_2E0: u,X2_2E0: u,X3_2E0: u] : ( s(tyop_2Eoption_2Eoption(A_27a),c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E4(s(tyop_2Emin_2Efun(A_27b,A_27c),X0_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X1_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),X2_2E0),s(A_27c,X3_2E0))) = s(tyop_2Eoption_2Eoption(A_27a),app_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))))),c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E0),s(tyop_2Emin_2Efun(A_27b,A_27c),X0_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X1_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),X2_2E0))),s(A_27c,X3_2E0))) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2_2Emono_2EA_27a_20mono_2EA_27b,axiom,
    ! [A_27a: d,A_27b: d,X0_2E0: u,X1_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2(s(A_27a,X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Ebool)),c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E0),s(A_27a,X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0)))) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2_2Emono_2EA_27b_20mono_2EA_27c,axiom,
    ! [A_27b: d,A_27c: d,X0_2E0: u,X1_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2(s(A_27b,X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),X1_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Ebool)),c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E0),s(A_27b,X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),X1_2E0)))) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2_2Emono_2EA_27c_20mono_2EA_27d,axiom,
    ! [A_27c: d,A_27d: d,X0_2E0: u,X1_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2(s(A_27c,X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d))),X1_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d))),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d))),tyop_2Emin_2Ebool)),c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E0),s(A_27c,X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d))),X1_2E0)))) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW_2E3_2Emono_2EA_27c_20mono_2EA_27a_20mono_2EA_27b,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,X0_2E0: u,X1_2E0: u,X2_2E0: u] : ( s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27a,A_27b),X0_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),X1_2E0),s(tyop_2Emin_2Efun(A_27a,A_27c),X2_2E0))) = s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27c),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27c),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27c),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))))),c_2EpatternMatches_2EPMATCH__ROW_2E0),s(tyop_2Emin_2Efun(A_27a,A_27b),X0_2E0))),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),X1_2E0))),s(tyop_2Emin_2Efun(A_27a,A_27c),X2_2E0))) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EPMATCH__ROW_2E4_2Emono_2EA_27c_20mono_2EA_27a_20mono_2EA_27b,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,X0_2E0: u,X1_2E0: u,X2_2E0: u,X3_2E0: u] : ( s(tyop_2Eoption_2Eoption(A_27c),c_2EpatternMatches_2EPMATCH__ROW_2E4(s(tyop_2Emin_2Efun(A_27a,A_27b),X0_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),X1_2E0),s(tyop_2Emin_2Efun(A_27a,A_27c),X2_2E0),s(A_27b,X3_2E0))) = s(tyop_2Eoption_2Eoption(A_27c),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27c),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27c),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27c),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))))),c_2EpatternMatches_2EPMATCH__ROW_2E0),s(tyop_2Emin_2Efun(A_27a,A_27b),X0_2E0))),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),X1_2E0))),s(tyop_2Emin_2Efun(A_27a,A_27c),X2_2E0))),s(A_27b,X3_2E0))) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW_2E3_2Emono_2EA_27d_20mono_2EA_27a_20mono_2EA_27c,axiom,
    ! [A_27a: d,A_27c: d,A_27d: d,X0_2E0: u,X1_2E0: u,X2_2E0: u] : ( s(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27a,A_27c),X0_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),X1_2E0),s(tyop_2Emin_2Efun(A_27a,A_27d),X2_2E0))) = s(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27d),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27d),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27d),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d))))),c_2EpatternMatches_2EPMATCH__ROW_2E0),s(tyop_2Emin_2Efun(A_27a,A_27c),X0_2E0))),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),X1_2E0))),s(tyop_2Emin_2Efun(A_27a,A_27d),X2_2E0))) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW_2E3_2Emono_2EA_27c_20mono_2EA_27b_20mono_2EA_27a,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,X0_2E0: u,X1_2E0: u,X2_2E0: u] : ( s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27b,A_27a),X0_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X1_2E0),s(tyop_2Emin_2Efun(A_27b,A_27c),X2_2E0))) = s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))))),c_2EpatternMatches_2EPMATCH__ROW_2E0),s(tyop_2Emin_2Efun(A_27b,A_27a),X0_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X1_2E0))),s(tyop_2Emin_2Efun(A_27b,A_27c),X2_2E0))) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EPMATCH__ROW_2E4_2Emono_2EA_27c_20mono_2EA_27b_20mono_2EA_27a,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,X0_2E0: u,X1_2E0: u,X2_2E0: u,X3_2E0: u] : ( s(tyop_2Eoption_2Eoption(A_27c),c_2EpatternMatches_2EPMATCH__ROW_2E4(s(tyop_2Emin_2Efun(A_27b,A_27a),X0_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X1_2E0),s(tyop_2Emin_2Efun(A_27b,A_27c),X2_2E0),s(A_27a,X3_2E0))) = s(tyop_2Eoption_2Eoption(A_27c),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))))),c_2EpatternMatches_2EPMATCH__ROW_2E0),s(tyop_2Emin_2Efun(A_27b,A_27a),X0_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X1_2E0))),s(tyop_2Emin_2Efun(A_27b,A_27c),X2_2E0))),s(A_27a,X3_2E0))) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW_2E3_2Emono_2EA_27d_20mono_2EA_27b_20mono_2EA_27a,axiom,
    ! [A_27a: d,A_27b: d,A_27d: d,X0_2E0: u,X1_2E0: u,X2_2E0: u] : ( s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27b,A_27a),X0_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X1_2E0),s(tyop_2Emin_2Efun(A_27b,A_27d),X2_2E0))) = s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27d),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27d),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27d),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d))))),c_2EpatternMatches_2EPMATCH__ROW_2E0),s(tyop_2Emin_2Efun(A_27b,A_27a),X0_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X1_2E0))),s(tyop_2Emin_2Efun(A_27b,A_27d),X2_2E0))) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW_2E3_2Emono_2EA_27a_20mono_2EA_27b_20mono_2EA_27b,axiom,
    ! [A_27a: d,A_27b: d,X0_2E0: u,X1_2E0: u,X2_2E0: u] : ( s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27b,A_27b),X0_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X1_2E0),s(tyop_2Emin_2Efun(A_27b,A_27a),X2_2E0))) = s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))))),c_2EpatternMatches_2EPMATCH__ROW_2E0),s(tyop_2Emin_2Efun(A_27b,A_27b),X0_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X1_2E0))),s(tyop_2Emin_2Efun(A_27b,A_27a),X2_2E0))) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW_2E3_2Emono_2EA_27a_20mono_2EA_27b_20mono_2EA_27c,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,X0_2E0: u,X1_2E0: u,X2_2E0: u] : ( s(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27b,A_27c),X0_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X1_2E0),s(tyop_2Emin_2Efun(A_27b,A_27a),X2_2E0))) = s(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))))),c_2EpatternMatches_2EPMATCH__ROW_2E0),s(tyop_2Emin_2Efun(A_27b,A_27c),X0_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X1_2E0))),s(tyop_2Emin_2Efun(A_27b,A_27a),X2_2E0))) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EPMATCH__ROW_2E4_2Emono_2EA_27a_20mono_2EA_27b_20mono_2EA_27c,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,X0_2E0: u,X1_2E0: u,X2_2E0: u,X3_2E0: u] : ( s(tyop_2Eoption_2Eoption(A_27a),c_2EpatternMatches_2EPMATCH__ROW_2E4(s(tyop_2Emin_2Efun(A_27b,A_27c),X0_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X1_2E0),s(tyop_2Emin_2Efun(A_27b,A_27a),X2_2E0),s(A_27c,X3_2E0))) = s(tyop_2Eoption_2Eoption(A_27a),app_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))))),c_2EpatternMatches_2EPMATCH__ROW_2E0),s(tyop_2Emin_2Efun(A_27b,A_27c),X0_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X1_2E0))),s(tyop_2Emin_2Efun(A_27b,A_27a),X2_2E0))),s(A_27c,X3_2E0))) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW_2E3_2Emono_2EA_27d_20mono_2EA_27b_20mono_2EA_27c,axiom,
    ! [A_27b: d,A_27c: d,A_27d: d,X0_2E0: u,X1_2E0: u,X2_2E0: u] : ( s(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27b,A_27c),X0_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X1_2E0),s(tyop_2Emin_2Efun(A_27b,A_27d),X2_2E0))) = s(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27d),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27d),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27d),tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d))))),c_2EpatternMatches_2EPMATCH__ROW_2E0),s(tyop_2Emin_2Efun(A_27b,A_27c),X0_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X1_2E0))),s(tyop_2Emin_2Efun(A_27b,A_27d),X2_2E0))) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW_2E3_2Emono_2EA_27b_20mono_2EA_27c_20mono_2EA_27a,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,X0_2E0: u,X1_2E0: u,X2_2E0: u] : ( s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27c,A_27a),X0_2E0),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),X1_2E0),s(tyop_2Emin_2Efun(A_27c,A_27b),X2_2E0))) = s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27b),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27b),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27b),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))))),c_2EpatternMatches_2EPMATCH__ROW_2E0),s(tyop_2Emin_2Efun(A_27c,A_27a),X0_2E0))),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),X1_2E0))),s(tyop_2Emin_2Efun(A_27c,A_27b),X2_2E0))) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW_2E3_2Emono_2EA_27d_20mono_2EA_27c_20mono_2EA_27a,axiom,
    ! [A_27a: d,A_27c: d,A_27d: d,X0_2E0: u,X1_2E0: u,X2_2E0: u] : ( s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27c,A_27a),X0_2E0),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),X1_2E0),s(tyop_2Emin_2Efun(A_27c,A_27d),X2_2E0))) = s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d))))),c_2EpatternMatches_2EPMATCH__ROW_2E0),s(tyop_2Emin_2Efun(A_27c,A_27a),X0_2E0))),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),X1_2E0))),s(tyop_2Emin_2Efun(A_27c,A_27d),X2_2E0))) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EPMATCH__ROW_2E4_2Emono_2EA_27d_20mono_2EA_27c_20mono_2EA_27a,axiom,
    ! [A_27a: d,A_27c: d,A_27d: d,X0_2E0: u,X1_2E0: u,X2_2E0: u,X3_2E0: u] : ( s(tyop_2Eoption_2Eoption(A_27d),c_2EpatternMatches_2EPMATCH__ROW_2E4(s(tyop_2Emin_2Efun(A_27c,A_27a),X0_2E0),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),X1_2E0),s(tyop_2Emin_2Efun(A_27c,A_27d),X2_2E0),s(A_27a,X3_2E0))) = s(tyop_2Eoption_2Eoption(A_27d),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d))))),c_2EpatternMatches_2EPMATCH__ROW_2E0),s(tyop_2Emin_2Efun(A_27c,A_27a),X0_2E0))),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),X1_2E0))),s(tyop_2Emin_2Efun(A_27c,A_27d),X2_2E0))),s(A_27a,X3_2E0))) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW_2E3_2Emono_2EA_27d_20mono_2EA_27c_20mono_2EA_27b,axiom,
    ! [A_27b: d,A_27c: d,A_27d: d,X0_2E0: u,X1_2E0: u,X2_2E0: u] : ( s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27d)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27c,A_27b),X0_2E0),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),X1_2E0),s(tyop_2Emin_2Efun(A_27c,A_27d),X2_2E0))) = s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27d)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27d))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27d)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27d))))),c_2EpatternMatches_2EPMATCH__ROW_2E0),s(tyop_2Emin_2Efun(A_27c,A_27b),X0_2E0))),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),X1_2E0))),s(tyop_2Emin_2Efun(A_27c,A_27d),X2_2E0))) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EPMATCH__ROW_2E4_2Emono_2EA_27d_20mono_2EA_27c_20mono_2EA_27b,axiom,
    ! [A_27b: d,A_27c: d,A_27d: d,X0_2E0: u,X1_2E0: u,X2_2E0: u,X3_2E0: u] : ( s(tyop_2Eoption_2Eoption(A_27d),c_2EpatternMatches_2EPMATCH__ROW_2E4(s(tyop_2Emin_2Efun(A_27c,A_27b),X0_2E0),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),X1_2E0),s(tyop_2Emin_2Efun(A_27c,A_27d),X2_2E0),s(A_27b,X3_2E0))) = s(tyop_2Eoption_2Eoption(A_27d),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27d)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27d))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27d)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27d))))),c_2EpatternMatches_2EPMATCH__ROW_2E0),s(tyop_2Emin_2Efun(A_27c,A_27b),X0_2E0))),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),X1_2E0))),s(tyop_2Emin_2Efun(A_27c,A_27d),X2_2E0))),s(A_27b,X3_2E0))) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EPMATCH__ROW_2E4_2Emono_2EA_27e_20mono_2EA_27c_20mono_2EA_27b,axiom,
    ! [A_27b: d,A_27c: d,A_27e: d,X0_2E0: u,X1_2E0: u,X2_2E0: u,X3_2E0: u] : ( s(tyop_2Eoption_2Eoption(A_27e),c_2EpatternMatches_2EPMATCH__ROW_2E4(s(tyop_2Emin_2Efun(A_27c,A_27b),X0_2E0),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),X1_2E0),s(tyop_2Emin_2Efun(A_27c,A_27e),X2_2E0),s(A_27b,X3_2E0))) = s(tyop_2Eoption_2Eoption(A_27e),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27e)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27e),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27e))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27e),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27e)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27e),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27e))))),c_2EpatternMatches_2EPMATCH__ROW_2E0),s(tyop_2Emin_2Efun(A_27c,A_27b),X0_2E0))),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),X1_2E0))),s(tyop_2Emin_2Efun(A_27c,A_27e),X2_2E0))),s(A_27b,X3_2E0))) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EPMATCH__ROW_2E4_2Emono_2EA_27e_20mono_2EA_27d_20mono_2EA_27a,axiom,
    ! [A_27a: d,A_27d: d,A_27e: d,X0_2E0: u,X1_2E0: u,X2_2E0: u,X3_2E0: u] : ( s(tyop_2Eoption_2Eoption(A_27e),c_2EpatternMatches_2EPMATCH__ROW_2E4(s(tyop_2Emin_2Efun(A_27d,A_27a),X0_2E0),s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),X1_2E0),s(tyop_2Emin_2Efun(A_27d,A_27e),X2_2E0),s(A_27a,X3_2E0))) = s(tyop_2Eoption_2Eoption(A_27e),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27e)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27e))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27e)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27e))))),c_2EpatternMatches_2EPMATCH__ROW_2E0),s(tyop_2Emin_2Efun(A_27d,A_27a),X0_2E0))),s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),X1_2E0))),s(tyop_2Emin_2Efun(A_27d,A_27e),X2_2E0))),s(A_27a,X3_2E0))) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW_2E3_2Emono_2EA_27c_20mono_2EA_27d_20mono_2EA_27b,axiom,
    ! [A_27b: d,A_27c: d,A_27d: d,X0_2E0: u,X1_2E0: u,X2_2E0: u] : ( s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27d,A_27b),X0_2E0),s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),X1_2E0),s(tyop_2Emin_2Efun(A_27d,A_27c),X2_2E0))) = s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27c),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27c),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27c),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))))),c_2EpatternMatches_2EPMATCH__ROW_2E0),s(tyop_2Emin_2Efun(A_27d,A_27b),X0_2E0))),s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),X1_2E0))),s(tyop_2Emin_2Efun(A_27d,A_27c),X2_2E0))) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EPMATCH__ROW_2E4_2Emono_2EA_27f_20mono_2EA_27d_20mono_2EA_27b,axiom,
    ! [A_27b: d,A_27d: d,A_27f: d,X0_2E0: u,X1_2E0: u,X2_2E0: u,X3_2E0: u] : ( s(tyop_2Eoption_2Eoption(A_27f),c_2EpatternMatches_2EPMATCH__ROW_2E4(s(tyop_2Emin_2Efun(A_27d,A_27b),X0_2E0),s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),X1_2E0),s(tyop_2Emin_2Efun(A_27d,A_27f),X2_2E0),s(A_27b,X3_2E0))) = s(tyop_2Eoption_2Eoption(A_27f),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27f)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27f),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27f))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27f),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27f)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27f),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27f))))),c_2EpatternMatches_2EPMATCH__ROW_2E0),s(tyop_2Emin_2Efun(A_27d,A_27b),X0_2E0))),s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),X1_2E0))),s(tyop_2Emin_2Efun(A_27d,A_27f),X2_2E0))),s(A_27b,X3_2E0))) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EPMATCH__ROW_2E4_2Emono_2EA_27f_20mono_2EA_27e_20mono_2EA_27a,axiom,
    ! [A_27a: d,A_27e: d,A_27f: d,X0_2E0: u,X1_2E0: u,X2_2E0: u,X3_2E0: u] : ( s(tyop_2Eoption_2Eoption(A_27f),c_2EpatternMatches_2EPMATCH__ROW_2E4(s(tyop_2Emin_2Efun(A_27e,A_27a),X0_2E0),s(tyop_2Emin_2Efun(A_27e,tyop_2Emin_2Ebool),X1_2E0),s(tyop_2Emin_2Efun(A_27e,A_27f),X2_2E0),s(A_27a,X3_2E0))) = s(tyop_2Eoption_2Eoption(A_27f),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27f)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27e,A_27f),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27f))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27e,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27e,A_27f),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27f)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27e,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27e,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27e,A_27f),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27f))))),c_2EpatternMatches_2EPMATCH__ROW_2E0),s(tyop_2Emin_2Efun(A_27e,A_27a),X0_2E0))),s(tyop_2Emin_2Efun(A_27e,tyop_2Emin_2Ebool),X1_2E0))),s(tyop_2Emin_2Efun(A_27e,A_27f),X2_2E0))),s(A_27a,X3_2E0))) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EPMATCH__ROW__COND_2E4_2Emono_2EA_27a_20mono_2EA_27b,axiom,
    ! [A_27a: d,A_27b: d,X0_2E0: u,X1_2E0: u,X2_2E0: u,X3_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(s(tyop_2Emin_2Efun(A_27a,A_27b),X0_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),X1_2E0),s(A_27b,X2_2E0),s(A_27a,X3_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)))),c_2EpatternMatches_2EPMATCH__ROW__COND_2E0),s(tyop_2Emin_2Efun(A_27a,A_27b),X0_2E0))),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),X1_2E0))),s(A_27b,X2_2E0))),s(A_27a,X3_2E0)))) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EPMATCH__ROW__COND_2E4_2Emono_2EA_27b_20mono_2EA_27a,axiom,
    ! [A_27a: d,A_27b: d,X0_2E0: u,X1_2E0: u,X2_2E0: u,X3_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(s(tyop_2Emin_2Efun(A_27b,A_27a),X0_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X1_2E0),s(A_27a,X2_2E0),s(A_27b,X3_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)))),c_2EpatternMatches_2EPMATCH__ROW__COND_2E0),s(tyop_2Emin_2Efun(A_27b,A_27a),X0_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X1_2E0))),s(A_27a,X2_2E0))),s(A_27b,X3_2E0)))) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EPMATCH__ROW__COND_2E4_2Emono_2EA_27b_20mono_2EA_27c,axiom,
    ! [A_27b: d,A_27c: d,X0_2E0: u,X1_2E0: u,X2_2E0: u,X3_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(s(tyop_2Emin_2Efun(A_27b,A_27c),X0_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X1_2E0),s(A_27c,X2_2E0),s(A_27b,X3_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)))),c_2EpatternMatches_2EPMATCH__ROW__COND_2E0),s(tyop_2Emin_2Efun(A_27b,A_27c),X0_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X1_2E0))),s(A_27c,X2_2E0))),s(A_27b,X3_2E0)))) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EPMATCH__ROW__COND_2E4_2Emono_2EA_27c_20mono_2EA_27a,axiom,
    ! [A_27a: d,A_27c: d,X0_2E0: u,X1_2E0: u,X2_2E0: u,X3_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(s(tyop_2Emin_2Efun(A_27c,A_27a),X0_2E0),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),X1_2E0),s(A_27a,X2_2E0),s(A_27c,X3_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)))),c_2EpatternMatches_2EPMATCH__ROW__COND_2E0),s(tyop_2Emin_2Efun(A_27c,A_27a),X0_2E0))),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),X1_2E0))),s(A_27a,X2_2E0))),s(A_27c,X3_2E0)))) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2EPMATCH__ROW__COND_2E4_2Emono_2EA_27d_20mono_2EA_27b,axiom,
    ! [A_27b: d,A_27d: d,X0_2E0: u,X1_2E0: u,X2_2E0: u,X3_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(s(tyop_2Emin_2Efun(A_27d,A_27b),X0_2E0),s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),X1_2E0),s(A_27b,X2_2E0),s(A_27d,X3_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool)))),c_2EpatternMatches_2EPMATCH__ROW__COND_2E0),s(tyop_2Emin_2Efun(A_27d,A_27b),X0_2E0))),s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),X1_2E0))),s(A_27b,X2_2E0))),s(A_27d,X3_2E0)))) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3_2Emono_2EA_27a_20mono_2EA_27b,axiom,
    ! [A_27a: d,A_27b: d,X0_2E0: u,X1_2E0: u,X2_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(s(A_27a,X0_2E0),s(tyop_2Emin_2Efun(A_27b,A_27a),X1_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X2_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool))),c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E0),s(A_27a,X0_2E0))),s(tyop_2Emin_2Efun(A_27b,A_27a),X1_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X2_2E0)))) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3_2Emono_2EA_27a_20mono_2EA_27c,axiom,
    ! [A_27a: d,A_27c: d,X0_2E0: u,X1_2E0: u,X2_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(s(A_27a,X0_2E0),s(tyop_2Emin_2Efun(A_27c,A_27a),X1_2E0),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),X2_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool))),c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E0),s(A_27a,X0_2E0))),s(tyop_2Emin_2Efun(A_27c,A_27a),X1_2E0))),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),X2_2E0)))) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3_2Emono_2EA_27c_20mono_2EA_27a,axiom,
    ! [A_27a: d,A_27c: d,X0_2E0: u,X1_2E0: u,X2_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(s(A_27c,X0_2E0),s(tyop_2Emin_2Efun(A_27a,A_27c),X1_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),X2_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool))),c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E0),s(A_27c,X0_2E0))),s(tyop_2Emin_2Efun(A_27a,A_27c),X1_2E0))),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),X2_2E0)))) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3_2Emono_2EA_27c_20mono_2EA_27b,axiom,
    ! [A_27b: d,A_27c: d,X0_2E0: u,X1_2E0: u,X2_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(s(A_27c,X0_2E0),s(tyop_2Emin_2Efun(A_27b,A_27c),X1_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X2_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool))),c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E0),s(A_27c,X0_2E0))),s(tyop_2Emin_2Efun(A_27b,A_27c),X1_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X2_2E0)))) ) ).

tff(arityeq3_2Ec_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E3_2Emono_2EA_27a_20mono_2EA_27b,axiom,
    ! [A_27a: d,A_27b: d,X0_2E0: u,X1_2E0: u,X2_2E0: mono_2Etyop_2Enum_2Enum] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E3(s(A_27a,X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0),s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(X2_2E0))))) = mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Ebool(j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool))),c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E0),s(A_27a,X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0)))),X2_2E0) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,X1_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] : ( mono_2Ec_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ_2E2(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(mono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(mono_2Ec_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__DISJ_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,X1_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] : ( mono_2Ec_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__DISJ_2E2(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(mono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(mono_2Ec_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__DISJ_2E0,X0_2E0),X1_2E0) ) ).

tff(arityeq1_2Ec_2Epair_2ESND_2E1_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,axiom,
    ! [X0_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29] : ( mono_2Ec_2Epair_2ESND_2E1_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(X0_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(mono_2Ec_2Epair_2ESND_2E0_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,X0_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2ESNOC_2E2_2Emono_2Etyop_2Emin_2Ebool,axiom,
    ! [X0_2E0: mono_2Etyop_2Emin_2Ebool,X1_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] : ( mono_2Ec_2Elist_2ESNOC_2E2_2Emono_2Etyop_2Emin_2Ebool(X0_2E0,X1_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(mono_2Ec_2Elist_2ESNOC_2E0_2Emono_2Etyop_2Emin_2Ebool,X0_2E0),X1_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2ESNOC_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27a_2Ctyop_2Eoption_2Eoption_28A_27b_29_29,axiom,
    ! [A_27a: d,A_27b: d,X0_2E0: u,X1_2E0: u] : ( s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2ESNOC_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0))) = s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))))),c_2Elist_2ESNOC_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0))) ) ).

tff(arityeq2_2Ec_2Elist_2ESNOC_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27b_2Ctyop_2Eoption_2Eoption_28A_27a_29_29,axiom,
    ! [A_27a: d,A_27b: d,X0_2E0: u,X1_2E0: u] : ( s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),c_2Elist_2ESNOC_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),X1_2E0))) = s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))))),c_2Elist_2ESNOC_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),X1_2E0))) ) ).

tff(arityeq2_2Ec_2Elist_2ESNOC_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27b_2Ctyop_2Eoption_2Eoption_28A_27c_29_29,axiom,
    ! [A_27b: d,A_27c: d,X0_2E0: u,X1_2E0: u] : ( s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2ESNOC_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),X1_2E0))) = s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))))),c_2Elist_2ESNOC_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),X1_2E0))) ) ).

tff(arityeq1_2Ec_2Eoption_2ESOME_2E1_2Emono_2EA_27a,axiom,
    ! [A_27a: d,X0_2E0: u] : ( s(tyop_2Eoption_2Eoption(A_27a),c_2Eoption_2ESOME_2E1(s(A_27a,X0_2E0))) = s(tyop_2Eoption_2Eoption(A_27a),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27a)),c_2Eoption_2ESOME_2E0),s(A_27a,X0_2E0))) ) ).

tff(arityeq1_2Ec_2Eoption_2ESOME_2E1_2Emono_2EA_27b,axiom,
    ! [A_27b: d,X0_2E0: u] : ( s(tyop_2Eoption_2Eoption(A_27b),c_2Eoption_2ESOME_2E1(s(A_27b,X0_2E0))) = s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27b)),c_2Eoption_2ESOME_2E0),s(A_27b,X0_2E0))) ) ).

tff(arityeq1_2Ec_2Eoption_2ESOME_2E1_2Emono_2EA_27c,axiom,
    ! [A_27c: d,X0_2E0: u] : ( s(tyop_2Eoption_2Eoption(A_27c),c_2Eoption_2ESOME_2E1(s(A_27c,X0_2E0))) = s(tyop_2Eoption_2Eoption(A_27c),app_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27c)),c_2Eoption_2ESOME_2E0),s(A_27c,X0_2E0))) ) ).

tff(arityeq1_2Ec_2Eoption_2ESOME_2E1_2Emono_2Etyop_2Emin_2Ebool,axiom,
    ! [X0_2E0: mono_2Etyop_2Emin_2Ebool] : ( mono_2Ec_2Eoption_2ESOME_2E1_2Emono_2Etyop_2Emin_2Ebool(X0_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29(mono_2Ec_2Eoption_2ESOME_2E0_2Emono_2Etyop_2Emin_2Ebool,X0_2E0) ) ).

tff(arityeq2_2Ec_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO_2E2_2Emono_2EA_27a_20mono_2EA_27b,axiom,
    ! [A_27a: d,A_27b: d,X0_2E0: u,X1_2E0: u] : ( j_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO_2E2(s(A_27a,X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0)))) = j_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Elist_2Elist(tyop_2Emin_2Ebool))),c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO_2E0),s(A_27a,X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0)))) ) ).

tff(arityeq4_2Ec_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX_2E4_2Emono_2EA_27a_20mono_2EA_27b,axiom,
    ! [A_27a: d,A_27b: d,X0_2E0: u,X1_2E0: u,X2_2E0: mono_2Etyop_2Emin_2Ebool,X3_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] : ( j_mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(s(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX_2E4(s(A_27a,X0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(X2_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(X3_2E0))))) = mono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool))))),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)))))),c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX_2E0),s(A_27a,X0_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0)))),X2_2E0),X3_2E0) ) ).

tff(arityeq1_2Ec_2Enum_2ESUC_2E1,axiom,
    ! [X0_2E0: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Enum_2ESUC_2E1(X0_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(mono_2Ec_2Enum_2ESUC_2E0,X0_2E0) ) ).

tff(arityeq2_2Ec_2Elist_2ETAKE_2E2_2Emono_2Etyop_2Emin_2Efun_28A_27a_2Ctyop_2Eoption_2Eoption_28A_27b_29_29,axiom,
    ! [A_27a: d,A_27b: d,X0_2E0: mono_2Etyop_2Enum_2Enum,X1_2E0: u] : ( s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2ETAKE_2E2(s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(X0_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0))) = s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))))),c_2Elist_2ETAKE_2E0),s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(X0_2E0)))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),X1_2E0))) ) ).

tff(arityeq1_2Ec_2Elist_2EZIP_2E1_2Emono_2Etyop_2Emin_2Ebool_20mono_2EA_27a,axiom,
    ! [A_27a: d,X0_2E0: u] : ( s(tyop_2Elist_2Elist(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a)),c_2Elist_2EZIP_2E1(s(tyop_2Epair_2Eprod(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(A_27a)),X0_2E0))) = s(tyop_2Elist_2Elist(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(A_27a)),tyop_2Elist_2Elist(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a))),c_2Elist_2EZIP_2E0),s(tyop_2Epair_2Eprod(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(A_27a)),X0_2E0))) ) ).

tff(arityeq2_2Ec_2Ebool_2E_5C_2F_2E2,axiom,
    ! [X0_2E0: mono_2Etyop_2Emin_2Ebool,X1_2E0: mono_2Etyop_2Emin_2Ebool] :
      ( ( p(X0_2E0)
        | p(X1_2E0) )
    <=> p(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(mono_2Ec_2Ebool_2E_5C_2F_2E0,X0_2E0),X1_2E0)) ) ).

tff(arityeq3_2Ec_2Eoption_2Eoption__CASE_2E3_2Emono_2EA_27a_20mono_2EA_27a,axiom,
    ! [A_27a: d,X0_2E0: u,X1_2E0: u,X2_2E0: u] : ( s(A_27a,c_2Eoption_2Eoption__CASE_2E3(s(tyop_2Eoption_2Eoption(A_27a),X0_2E0),s(A_27a,X1_2E0),s(tyop_2Emin_2Efun(A_27a,A_27a),X2_2E0))) = s(A_27a,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27a),A_27a),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27a),A_27a)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Eoption_2Eoption(A_27a),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27a),A_27a))),c_2Eoption_2Eoption__CASE_2E0),s(tyop_2Eoption_2Eoption(A_27a),X0_2E0))),s(A_27a,X1_2E0))),s(tyop_2Emin_2Efun(A_27a,A_27a),X2_2E0))) ) ).

tff(arityeq3_2Ec_2Eoption_2Eoption__CASE_2E3_2Emono_2EA_27b_20mono_2Etyop_2Eoption_2Eoption_28A_27a_29,axiom,
    ! [A_27a: d,A_27b: d,X0_2E0: u,X1_2E0: u,X2_2E0: u] : ( s(tyop_2Eoption_2Eoption(A_27a),c_2Eoption_2Eoption__CASE_2E3(s(tyop_2Eoption_2Eoption(A_27b),X0_2E0),s(tyop_2Eoption_2Eoption(A_27a),X1_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),X2_2E0))) = s(tyop_2Eoption_2Eoption(A_27a),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),tyop_2Eoption_2Eoption(A_27a)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Eoption_2Eoption(A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),tyop_2Eoption_2Eoption(A_27a))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Eoption_2Eoption(A_27b),tyop_2Emin_2Efun(tyop_2Eoption_2Eoption(A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),tyop_2Eoption_2Eoption(A_27a)))),c_2Eoption_2Eoption__CASE_2E0),s(tyop_2Eoption_2Eoption(A_27b),X0_2E0))),s(tyop_2Eoption_2Eoption(A_27a),X1_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),X2_2E0))) ) ).

tff(arityeq1_2Ec_2Eoption_2Esome_2E1_2Emono_2EA_27b,axiom,
    ! [A_27b: d,X0_2E0: u] : ( s(tyop_2Eoption_2Eoption(A_27b),c_2Eoption_2Esome_2E1(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X0_2E0))) = s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Eoption_2Eoption(A_27b)),c_2Eoption_2Esome_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),X0_2E0))) ) ).

tff(arityeq1_2Ec_2Eoption_2Esome_2E1_2Emono_2Etyop_2Emin_2Ebool,axiom,
    ! [X0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29] : ( mono_2Ec_2Eoption_2Esome_2E1_2Emono_2Etyop_2Emin_2Ebool(X0_2E0) = mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29(mono_2Ec_2Eoption_2Esome_2E0_2Emono_2Etyop_2Emin_2Ebool,X0_2E0) ) ).

tff(arityeq1_2Ec_2Ebool_2E_7E_2E1,axiom,
    ! [X0_2E0: mono_2Etyop_2Emin_2Ebool] :
      ( ~ p(X0_2E0)
    <=> p(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool(mono_2Ec_2Ebool_2E_7E_2E0,X0_2E0)) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29,V1_2E0: mono_2Etyop_2Emin_2Ebool] : ( s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(V0_2E0)),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29,V1_2E0: mono_2Etyop_2Emin_2Ebool] : ( s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29(V0_2E0)),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29,V1_2E0: mono_2Etyop_2Emin_2Ebool] : ( s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29(V0_2E0)),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29,V1_2E0: mono_2Etyop_2Emin_2Ebool] : ( s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29(V0_2E0)),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29,V1_2E0: mono_2Etyop_2Emin_2Ebool] : ( s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29(V0_2E0)),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29,V1_2E0: mono_2Etyop_2Emin_2Ebool] : ( s(tyop_2Eoption_2Eoption(tyop_2Emin_2Ebool),i_mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29(V0_2E0,V1_2E0))) = s(tyop_2Eoption_2Eoption(tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Eoption_2Eoption(tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29(V0_2E0)),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29,V1_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29] : ( s(tyop_2Eoption_2Eoption(tyop_2Emin_2Ebool),i_mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_20mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29(V0_2E0,V1_2E0))) = s(tyop_2Eoption_2Eoption(tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),tyop_2Eoption_2Eoption(tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29(V0_2E0)),s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29,V1_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29] : ( s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool)))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29(V0_2E0)),s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29,V1_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] : ( s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Emin_2Ebool(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29(V0_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29,V1_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] : ( s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(mono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29(V0_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29,V1_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] : ( s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(mono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V0_2E0,V1_2E0))) = s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(V0_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Enum_2Enum,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29,V1_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] : ( s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(mono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Enum_2Enum(V0_2E0,V1_2E0))) = s(tyop_2Enum_2Enum,app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Enum_2Enum),i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29(V0_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29,V1_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] : ( s(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),i_mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(mono_2Eapp_2E2_2Emono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_20mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(V0_2E0,V1_2E0))) = s(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29(V0_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29,V1_2E0: mono_2Etyop_2Enum_2Enum] : ( s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Ebool(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29(V0_2E0)),s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29,V1_2E0: mono_2Etyop_2Enum_2Enum] : ( s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29(V0_2E0)),s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29,V1_2E0: mono_2Etyop_2Enum_2Enum] : ( s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29(V0_2E0)),s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,V1_2E0: mono_2Etyop_2Enum_2Enum] : ( s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Enum_2Enum),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Enum_2Enum),app_2E2(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Enum_2Enum)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29(V0_2E0)),s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,V1_2E0: mono_2Etyop_2Enum_2Enum] : ( s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(mono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum(V0_2E0,V1_2E0))) = s(tyop_2Enum_2Enum,app_2E2(s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Enum_2Enum),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29(V0_2E0)),s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29,V1_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29] : ( s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Emin_2Ebool(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29(V0_2E0)),s(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),i_mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29,V1_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29] : ( s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(mono_2Eapp_2E2_2Emono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V0_2E0,V1_2E0))) = s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(V0_2E0)),s(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),i_mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Ec_2Epair_2E_2C_2E0_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,axiom,
    s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29(mono_2Ec_2Epair_2E_2C_2E0_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29)) = s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)))),c_2Epair_2E_2C_2E0) ).

tff(monoeq_2Emono_2Ec_2Epair_2E_2C_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Ebool,V1_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] : ( s(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),i_mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(mono_2Ec_2Epair_2E_2C_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V0_2E0,V1_2E0))) = s(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),c_2Epair_2E_2C_2E2(s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V0_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Ec_2Elist_2ECONS_2E0_2Emono_2Etyop_2Emin_2Ebool,axiom,
    s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29(mono_2Ec_2Elist_2ECONS_2E0_2Emono_2Etyop_2Emin_2Ebool)) = s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool))),c_2Elist_2ECONS_2E0) ).

tff(monoeq_2Emono_2Ec_2Elist_2ECONS_2E2_2Emono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Ebool,V1_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] : ( s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(mono_2Ec_2Elist_2ECONS_2E2_2Emono_2Etyop_2Emin_2Ebool(V0_2E0,V1_2E0))) = s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V0_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Ec_2Elist_2EEL_2E0_2Emono_2Etyop_2Emin_2Ebool,axiom,
    s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Ebool_29_29(mono_2Ec_2Elist_2EEL_2E0_2Emono_2Etyop_2Emin_2Ebool)) = s(tyop_2Emin_2Efun(tyop_2Enum_2Enum,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)),c_2Elist_2EEL_2E0) ).

tff(monoeq_2Emono_2Ec_2Elist_2EEL_2E2_2Emono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0_2E0: mono_2Etyop_2Enum_2Enum,V1_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] : ( s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(mono_2Ec_2Elist_2EEL_2E2_2Emono_2Etyop_2Emin_2Ebool(V0_2E0,V1_2E0))) = s(tyop_2Emin_2Ebool,c_2Elist_2EEL_2E2(s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(V0_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Ec_2Epair_2EFST_2E0_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,axiom,
    s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29(mono_2Ec_2Epair_2EFST_2E0_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29)) = s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),tyop_2Emin_2Ebool),c_2Epair_2EFST_2E0) ).

tff(monoeq_2Emono_2Ec_2Epair_2EFST_2E1_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29] : ( s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(mono_2Ec_2Epair_2EFST_2E1_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V0_2E0))) = s(tyop_2Emin_2Ebool,c_2Epair_2EFST_2E1(s(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),i_mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(V0_2E0)))) ) ).

tff(monoeq_2Emono_2Ec_2Elist_2ELENGTH_2E0_2Emono_2Etyop_2Emin_2Ebool,axiom,
    s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Enum_2Enum),i_mono_2Etyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Enum_2Enum_29(mono_2Ec_2Elist_2ELENGTH_2E0_2Emono_2Etyop_2Emin_2Ebool)) = s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Enum_2Enum),c_2Elist_2ELENGTH_2E0) ).

tff(monoeq_2Emono_2Ec_2Elist_2ELENGTH_2E1_2Emono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] : ( s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(mono_2Ec_2Elist_2ELENGTH_2E1_2Emono_2Etyop_2Emin_2Ebool(V0_2E0))) = s(tyop_2Enum_2Enum,c_2Elist_2ELENGTH_2E1(s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V0_2E0)))) ) ).

tff(monoeq_2Emono_2Ec_2Elist_2EMAP2_2E0_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool,axiom,
    s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool)))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29_29(mono_2Ec_2Elist_2EMAP2_2E0_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool)) = s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool)))),c_2Elist_2EMAP2_2E0) ).

tff(monoeq_2Emono_2Ec_2Elist_2EMAP2_2E3_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29,V1_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,V2_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] : ( s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(mono_2Ec_2Elist_2EMAP2_2E3_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool(V0_2E0,V1_2E0,V2_2E0))) = s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),c_2Elist_2EMAP2_2E3(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29(V0_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V1_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V2_2E0)))) ) ).

tff(monoeq_2Emono_2Ec_2Elist_2ENIL_2E0_2Emono_2Etyop_2Emin_2Ebool,axiom,
    s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(mono_2Ec_2Elist_2ENIL_2E0_2Emono_2Etyop_2Emin_2Ebool)) = s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),c_2Elist_2ENIL_2E0) ).

tff(monoeq_2Emono_2Ec_2Epair_2ESND_2E0_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,axiom,
    s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(mono_2Ec_2Epair_2ESND_2E0_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29)) = s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),c_2Epair_2ESND_2E0) ).

tff(monoeq_2Emono_2Ec_2Epair_2ESND_2E1_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29] : ( s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(mono_2Ec_2Epair_2ESND_2E1_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V0_2E0))) = s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),c_2Epair_2ESND_2E1(s(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),i_mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(V0_2E0)))) ) ).

tff(monoeq_2Emono_2Ec_2Elist_2ESNOC_2E0_2Emono_2Etyop_2Emin_2Ebool,axiom,
    s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool))),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29_29(mono_2Ec_2Elist_2ESNOC_2E0_2Emono_2Etyop_2Emin_2Ebool)) = s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(tyop_2Emin_2Ebool))),c_2Elist_2ESNOC_2E0) ).

tff(monoeq_2Emono_2Ec_2Elist_2ESNOC_2E2_2Emono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Ebool,V1_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] : ( s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(mono_2Ec_2Elist_2ESNOC_2E2_2Emono_2Etyop_2Emin_2Ebool(V0_2E0,V1_2E0))) = s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),c_2Elist_2ESNOC_2E2(s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V0_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V1_2E0)))) ) ).

tff(monoeq_2Emono_2Ec_2Eoption_2ESOME_2E0_2Emono_2Etyop_2Emin_2Ebool,axiom,
    s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Eoption_2Eoption(tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29(mono_2Ec_2Eoption_2ESOME_2E0_2Emono_2Etyop_2Emin_2Ebool)) = s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Eoption_2Eoption(tyop_2Emin_2Ebool)),c_2Eoption_2ESOME_2E0) ).

tff(monoeq_2Emono_2Ec_2Eoption_2ESOME_2E1_2Emono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Ebool] : ( s(tyop_2Eoption_2Eoption(tyop_2Emin_2Ebool),i_mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29(mono_2Ec_2Eoption_2ESOME_2E1_2Emono_2Etyop_2Emin_2Ebool(V0_2E0))) = s(tyop_2Eoption_2Eoption(tyop_2Emin_2Ebool),c_2Eoption_2ESOME_2E1(s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V0_2E0)))) ) ).

tff(monoeq_2Emono_2Ec_2Eoption_2Esome_2E0_2Emono_2Etyop_2Emin_2Ebool,axiom,
    s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),tyop_2Eoption_2Eoption(tyop_2Emin_2Ebool)),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_2Ctyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29_29(mono_2Ec_2Eoption_2Esome_2E0_2Emono_2Etyop_2Emin_2Ebool)) = s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),tyop_2Eoption_2Eoption(tyop_2Emin_2Ebool)),c_2Eoption_2Esome_2E0) ).

tff(monoeq_2Emono_2Ec_2Eoption_2Esome_2E1_2Emono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29] : ( s(tyop_2Eoption_2Eoption(tyop_2Emin_2Ebool),i_mono_2Etyop_2Eoption_2Eoption_28tyop_2Emin_2Ebool_29(mono_2Ec_2Eoption_2Esome_2E1_2Emono_2Etyop_2Emin_2Ebool(V0_2E0))) = s(tyop_2Eoption_2Eoption(tyop_2Emin_2Ebool),c_2Eoption_2Esome_2E1(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Ebool),i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(V0_2E0)))) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__COND__def,axiom,
    ! [A_27a: d,A_27b: d,V0pat_2E0: u,V1guard_2E0: u,V2inp_2E0: u,V3v_2E0: u] :
      ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(s(tyop_2Emin_2Efun(A_27a,A_27b),V0pat_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V1guard_2E0),s(A_27b,V2inp_2E0),s(A_27a,V3v_2E0)))))
    <=> ( ( s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V0pat_2E0),s(A_27a,V3v_2E0))) = s(A_27b,V2inp_2E0) )
        & p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V1guard_2E0),s(A_27a,V3v_2E0))))) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__def,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,F0_2E0: u] :
      ( ! [V0pat_2E0: u,V1guard_2E0: u,V3i_2E0: u,V4v_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)))),F0_2E0),s(tyop_2Emin_2Efun(A_27b,A_27c),V0pat_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V1guard_2E0))),s(A_27c,V3i_2E0))),s(A_27b,V4v_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(s(tyop_2Emin_2Efun(A_27b,A_27c),V0pat_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V1guard_2E0),s(A_27c,V3i_2E0),s(A_27b,V4v_2E0)))) )
     => ! [V0pat_2E0: u,V1guard_2E0: u,V2rhs_2E0: u,V3i_2E0: u] : ( s(tyop_2Eoption_2Eoption(A_27a),c_2EpatternMatches_2EPMATCH__ROW_2E4(s(tyop_2Emin_2Efun(A_27b,A_27c),V0pat_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V1guard_2E0),s(tyop_2Emin_2Efun(A_27b,A_27a),V2rhs_2E0),s(A_27c,V3i_2E0))) = s(tyop_2Eoption_2Eoption(A_27a),c_2Eoption_2EOPTION__MAP_2E2(s(tyop_2Emin_2Efun(A_27b,A_27a),V2rhs_2E0),s(tyop_2Eoption_2Eoption(A_27b),c_2Eoption_2Esome_2E1(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)))),F0_2E0),s(tyop_2Emin_2Efun(A_27b,A_27c),V0pat_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V1guard_2E0))),s(A_27c,V3i_2E0))))))) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__INCOMPLETE__def,axiom,
    ! [A_27a: d] : ( s(A_27a,c_2EpatternMatches_2EPMATCH__INCOMPLETE_2E0) = s(A_27a,c_2Ebool_2EARB_2E0) ) ).

tff(thm_2EpatternMatches_2EPMATCH__def,axiom,
    ! [A_27a: d,A_27b: d] :
      ( ! [V0v_2E0: u] : ( s(A_27a,c_2EpatternMatches_2EPMATCH_2E2(s(A_27b,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),c_2Elist_2ENIL_2E0))) = s(A_27a,c_2EpatternMatches_2EPMATCH__INCOMPLETE_2E0) )
      & ! [V1v_2E0: u,V2r_2E0: u,V3rs_2E0: u] : ( s(A_27a,c_2EpatternMatches_2EPMATCH_2E2(s(A_27b,V1v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),V2r_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),V3rs_2E0))))) = s(A_27a,c_2Eoption_2Eoption__CASE_2E3(s(tyop_2Eoption_2Eoption(A_27a),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),V2r_2E0),s(A_27b,V1v_2E0))),s(A_27a,c_2EpatternMatches_2EPMATCH_2E2(s(A_27b,V1v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),V3rs_2E0))),s(tyop_2Emin_2Efun(A_27a,A_27a),c_2Ecombin_2EI_2E0))) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__EQUIV__ROWS__def,axiom,
    ! [A_27a: d,A_27b: d,V0v_2E0: u,V1rows1_2E0: u,V2rows2_2E0: u] :
      ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows2_2E0)))))
    <=> ( ( s(A_27b,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows1_2E0))) = s(A_27b,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows2_2E0))) )
        & ( ? [V3r_2E0: u] :
              ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Ebool_2EIN_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V3r_2E0),s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),c_2Elist_2ELIST__TO__SET_2E1(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows1_2E0)))))))
              & p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Eoption_2EIS__SOME_2E1(s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V3r_2E0),s(A_27a,V0v_2E0))))))) )
        <=> ? [V4r_2E0: u] :
              ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Ebool_2EIN_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V4r_2E0),s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),c_2Elist_2ELIST__TO__SET_2E1(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows2_2E0)))))))
              & p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Eoption_2EIS__SOME_2E1(s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V4r_2E0),s(A_27a,V0v_2E0))))))) ) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__REDUNDANT__def,axiom,
    ! [A_27a: d,A_27b: d,V0v_2E0: u,V1rs_2E0: u,V2i_2E0: mono_2Etyop_2Enum_2Enum] :
      ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E3(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rs_2E0),s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(V2i_2E0))))))
    <=> ( p(mono_2Ec_2Eprim__rec_2E_3C_2E2(V2i_2E0,j_mono_2Etyop_2Enum_2Enum(s(tyop_2Enum_2Enum,c_2Elist_2ELENGTH_2E1(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rs_2E0))))))
        & ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Eoption_2EIS__SOME_2E1(s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),c_2Elist_2EEL_2E2(s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(V2i_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rs_2E0))),s(A_27a,V0v_2E0)))))))
         => ? [V3j_2E0: mono_2Etyop_2Enum_2Enum] :
              ( p(mono_2Ec_2Eprim__rec_2E_3C_2E2(V3j_2E0,V2i_2E0))
              & p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Eoption_2EIS__SOME_2E1(s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),c_2Elist_2EEL_2E2(s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(V3j_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rs_2E0))),s(A_27a,V0v_2E0))))))) ) ) ) ) ).

tff(thm_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO__def,axiom,
    ! [A_27a: d,A_27b: d,F0_2E0: u] :
      ( ! [V0v_2E0: u,V5r_2E0: u] :
          ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool)),F0_2E0),s(A_27a,V0v_2E0))),s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V5r_2E0)))))
        <=> ( s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V5r_2E0),s(A_27a,V0v_2E0))) = s(tyop_2Eoption_2Eoption(A_27b),c_2Eoption_2ENONE_2E0) ) )
     => ! [V0v_2E0: u,V1rows_2E0: u,V2c_2E0: mono_2Etyop_2Emin_2Ebool,V3infos_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] :
          ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V2c_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V3infos_2E0))))))
        <=> ( ( j_mono_2Etyop_2Enum_2Enum(s(tyop_2Enum_2Enum,c_2Elist_2ELENGTH_2E1(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0)))) = mono_2Ec_2Elist_2ELENGTH_2E1_2Emono_2Etyop_2Emin_2Ebool(V3infos_2E0) )
            & ! [V4i_2E0: mono_2Etyop_2Enum_2Enum] :
                ( p(mono_2Ec_2Eprim__rec_2E_3C_2E2(V4i_2E0,j_mono_2Etyop_2Enum_2Enum(s(tyop_2Enum_2Enum,c_2Elist_2ELENGTH_2E1(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0))))))
               => ( p(mono_2Ec_2Elist_2EEL_2E2_2Emono_2Etyop_2Emin_2Ebool(V4i_2E0,V3infos_2E0))
                 => p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E3(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0),s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(V4i_2E0)))))) ) )
            & ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Elist_2EEVERY_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool)),F0_2E0),s(A_27a,V0v_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0)))))
             => p(V2c_2E0) ) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__COND__EX__def,axiom,
    ! [A_27a: d,A_27b: d,V0i_2E0: u,V1p_2E0: u,V2g_2E0: u] :
      ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(s(A_27a,V0i_2E0),s(tyop_2Emin_2Efun(A_27b,A_27a),V1p_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V2g_2E0)))))
    <=> ? [V3x_2E0: u] : p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(s(tyop_2Emin_2Efun(A_27b,A_27a),V1p_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V2g_2E0),s(A_27a,V0i_2E0),s(A_27b,V3x_2E0))))) ) ).

tff(thm_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO__def,axiom,
    ! [A_27a: d,F0_2E0: u] :
      ( ! [V2x_2E0: u] :
          ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a),tyop_2Emin_2Ebool),F0_2E0),s(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a),V2x_2E0)))))
        <=> ~ p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Epair_2EFST_2E1(s(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a),V2x_2E0))))) )
     => ! [V0is_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,V1xs_2E0: u] : ( s(tyop_2Elist_2Elist(A_27a),c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V0is_2E0)),s(tyop_2Elist_2Elist(A_27a),V1xs_2E0))) = s(tyop_2Elist_2Elist(A_27a),c_2Elist_2EMAP_2E2(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a),A_27a),c_2Epair_2ESND_2E0),s(tyop_2Elist_2Elist(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a)),c_2Elist_2EFILTER_2E2(s(tyop_2Emin_2Efun(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a),tyop_2Emin_2Ebool),F0_2E0),s(tyop_2Elist_2Elist(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,A_27a)),c_2Elist_2EZIP_2E1(s(tyop_2Epair_2Eprod(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),tyop_2Elist_2Elist(A_27a)),c_2Epair_2E_2C_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V0is_2E0)),s(tyop_2Elist_2Elist(A_27a),V1xs_2E0))))))))) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE__def,axiom,
    ! [A_27a: d,A_27b: d,F0_2E0: u] :
      ( ! [V0v_2E0: u,V2r_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool)),F0_2E0),s(A_27a,V0v_2E0))),s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V2r_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Eoption_2EIS__SOME_2E1(s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V2r_2E0),s(A_27a,V0v_2E0)))))) )
     => ! [V0v_2E0: u,V1rs_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rs_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Elist_2EEXISTS_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool)),F0_2E0),s(A_27a,V0v_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rs_2E0)))) ) ) ).

tff(thm_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ__def,axiom,
    ! [F0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29] :
      ( ! [V2i1_2E0: mono_2Etyop_2Emin_2Ebool,V3i2_2E0: mono_2Etyop_2Emin_2Ebool] :
          ( p(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(F0_2E0,V2i1_2E0),V3i2_2E0))
        <=> ( p(V2i1_2E0)
            & p(V3i2_2E0) ) )
     => ! [V0ip1_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,V1ip2_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] : ( mono_2Ec_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ_2E2(V0ip1_2E0,V1ip2_2E0) = mono_2Ec_2Elist_2EMAP2_2E3_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool(F0_2E0,V0ip1_2E0,V1ip2_2E0) ) ) ).

tff(thm_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__DISJ__def,axiom,
    ! [F0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29] :
      ( ! [V2i1_2E0: mono_2Etyop_2Emin_2Ebool,V3i2_2E0: mono_2Etyop_2Emin_2Ebool] :
          ( p(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(F0_2E0,V2i1_2E0),V3i2_2E0))
        <=> ( p(V2i1_2E0)
            | p(V3i2_2E0) ) )
     => ! [V0ip1_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,V1ip2_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] : ( mono_2Ec_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__DISJ_2E2(V0ip1_2E0,V1ip2_2E0) = mono_2Ec_2Elist_2EMAP2_2E3_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool(F0_2E0,V0ip1_2E0,V1ip2_2E0) ) ) ).

tff(thm_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX__def,axiom,
    ! [A_27a: d,A_27b: d,F1_2E0: u,F0_2E0: u] :
      ( ! [V6p_2E0: mono_2Etyop_2Emin_2Ebool,V4r_2E0: u,V3v_2E0: u] :
          ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool))),F1_2E0),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V6p_2E0)))),s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V4r_2E0))),s(A_27a,V3v_2E0)))))
        <=> ( p(V6p_2E0)
           => ( s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V4r_2E0),s(A_27a,V3v_2E0))) = s(tyop_2Eoption_2Eoption(A_27b),c_2Eoption_2ENONE_2E0) ) ) )
     => ( ! [V6p_2E0: mono_2Etyop_2Emin_2Ebool,V4r_2E0: u,V3v_2E0: u] :
            ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool))),F0_2E0),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V6p_2E0)))),s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V4r_2E0))),s(A_27a,V3v_2E0)))))
          <=> ( p(V6p_2E0)
              & ( s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V4r_2E0),s(A_27a,V3v_2E0))) = s(tyop_2Eoption_2Eoption(A_27b),c_2Eoption_2ENONE_2E0) ) ) )
       => ( ! [V0v_2E0: u,V1p_2E0: mono_2Etyop_2Emin_2Ebool,V2infos_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] : ( j_mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(s(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX_2E4(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2ENIL_2E0),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V1p_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V2infos_2E0))))) = mono_2Ec_2Epair_2E_2C_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V1p_2E0,V2infos_2E0) )
          & ! [V3v_2E0: u,V4r_2E0: u,V5rows_2E0: u,V6p_2E0: mono_2Etyop_2Emin_2Ebool,V7infos_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] : ( j_mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(s(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX_2E4(s(A_27a,V3v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V4r_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V5rows_2E0))),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V6p_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V7infos_2E0))))) = j_mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(s(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX_2E4(s(A_27a,V3v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V5rows_2E0),s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool))),F0_2E0),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V6p_2E0)))),s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V4r_2E0))),s(A_27a,V3v_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(mono_2Ec_2Elist_2ESNOC_2E2_2Emono_2Etyop_2Emin_2Ebool(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool))),F1_2E0),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V6p_2E0)))),s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V4r_2E0))),s(A_27a,V3v_2E0)))),V7infos_2E0)))))) ) ) ) ) ).

tff(thm_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__def,axiom,
    ! [A_27a: d,A_27b: d,V0v_2E0: u,V1rows_2E0: u] : ( j_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0)))) = mono_2Ec_2Epair_2ESND_2E1_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(j_mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(s(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX_2E4(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(mono_2Ec_2Ebool_2ET_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(mono_2Ec_2Elist_2ENIL_2E0_2Emono_2Etyop_2Emin_2Ebool)))))) ) ).

tff(thm_2EpatternMatches_2EPMATCH__FLATTEN__FUN__def,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,F1_2E0: u,F0_2E0: u] :
      ( ! [V2row_2E0: u,V5x_2E0: u] : ( s(tyop_2Eoption_2Eoption(A_27a),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),F1_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),V2row_2E0))),s(A_27b,V5x_2E0))) = s(tyop_2Eoption_2Eoption(A_27a),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),V2row_2E0),s(A_27b,V5x_2E0))),s(A_27b,V5x_2E0))) )
     => ( ! [V0p_2E0: u,V1g_2E0: u,V3v_2E0: u,V4x_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)))),F0_2E0),s(tyop_2Emin_2Efun(A_27b,A_27c),V0p_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V1g_2E0))),s(A_27c,V3v_2E0))),s(A_27b,V4x_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(s(tyop_2Emin_2Efun(A_27b,A_27c),V0p_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V1g_2E0),s(A_27c,V3v_2E0),s(A_27b,V4x_2E0)))) )
       => ! [V0p_2E0: u,V1g_2E0: u,V2row_2E0: u,V3v_2E0: u] : ( s(tyop_2Eoption_2Eoption(A_27a),c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E4(s(tyop_2Emin_2Efun(A_27b,A_27c),V0p_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V1g_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),V2row_2E0),s(A_27c,V3v_2E0))) = s(tyop_2Eoption_2Eoption(A_27a),c_2Eoption_2Eoption__CASE_2E3(s(tyop_2Eoption_2Eoption(A_27b),c_2Eoption_2Esome_2E1(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)))),F0_2E0),s(tyop_2Emin_2Efun(A_27b,A_27c),V0p_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V1g_2E0))),s(A_27c,V3v_2E0))))),s(tyop_2Eoption_2Eoption(A_27a),c_2Eoption_2ENONE_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),F1_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),V2row_2E0))))) ) ) ) ).

tff(thm_2EpatternMatches_2ELENGTH__STRONGEST__REDUNDANT__ROWS__INFO,axiom,
    ! [A_27a: d,A_27b: d,V0v_2E0: u,V1rows_2E0: u] : ( mono_2Ec_2Elist_2ELENGTH_2E1_2Emono_2Etyop_2Emin_2Ebool(j_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0))))) = j_mono_2Etyop_2Enum_2Enum(s(tyop_2Enum_2Enum,c_2Elist_2ELENGTH_2E1(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0)))) ) ).

tff(thm_2EpatternMatches_2EEL2__STRONGEST__REDUNDANT__ROWS__INFO__AUX,axiom,
    ! [A_27a: d,A_27b: d,F0_2E0: u] :
      ( ! [V0v_2E0: u,V5r_2E0: u] :
          ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool)),F0_2E0),s(A_27a,V0v_2E0))),s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V5r_2E0)))))
        <=> ( s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V5r_2E0),s(A_27a,V0v_2E0))) = s(tyop_2Eoption_2Eoption(A_27b),c_2Eoption_2ENONE_2E0) ) )
     => ! [V0v_2E0: u,V1rows_2E0: u,V2p_2E0: mono_2Etyop_2Emin_2Ebool,V3infos_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,V4i_2E0: mono_2Etyop_2Enum_2Enum] :
          ( ( p(mono_2Ec_2Earithmetic_2E_3E_3D_2E2(V4i_2E0,mono_2Ec_2Elist_2ELENGTH_2E1_2Emono_2Etyop_2Emin_2Ebool(V3infos_2E0)))
            & p(mono_2Ec_2Eprim__rec_2E_3C_2E2(V4i_2E0,mono_2Ec_2Earithmetic_2E_2B_2E2(j_mono_2Etyop_2Enum_2Enum(s(tyop_2Enum_2Enum,c_2Elist_2ELENGTH_2E1(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0)))),mono_2Ec_2Elist_2ELENGTH_2E1_2Emono_2Etyop_2Emin_2Ebool(V3infos_2E0)))) )
         => ( p(mono_2Ec_2Elist_2EEL_2E2_2Emono_2Etyop_2Emin_2Ebool(V4i_2E0,mono_2Ec_2Epair_2ESND_2E1_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(j_mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(s(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX_2E4(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V2p_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V3infos_2E0))))))))
          <=> ( ( p(V2p_2E0)
                & p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Elist_2EEVERY_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool)),F0_2E0),s(A_27a,V0v_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2ETAKE_2E2(s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(mono_2Ec_2Earithmetic_2E_2D_2E2(V4i_2E0,mono_2Ec_2Elist_2ELENGTH_2E1_2Emono_2Etyop_2Emin_2Ebool(V3infos_2E0)))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0))))))) )
             => ( s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),c_2Elist_2EEL_2E2(s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(mono_2Ec_2Earithmetic_2E_2D_2E2(V4i_2E0,mono_2Ec_2Elist_2ELENGTH_2E1_2Emono_2Etyop_2Emin_2Ebool(V3infos_2E0)))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0))),s(A_27a,V0v_2E0))) = s(tyop_2Eoption_2Eoption(A_27b),c_2Eoption_2ENONE_2E0) ) ) ) ) ) ).

tff(thm_2EpatternMatches_2EEL1__STRONGEST__REDUNDANT__ROWS__INFO__AUX,axiom,
    ! [A_27a: d,A_27b: d,V0v_2E0: u,V1rows_2E0: u,V2p_2E0: mono_2Etyop_2Emin_2Ebool,V3infos_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,V4i_2E0: mono_2Etyop_2Enum_2Enum] :
      ( p(mono_2Ec_2Eprim__rec_2E_3C_2E2(V4i_2E0,mono_2Ec_2Elist_2ELENGTH_2E1_2Emono_2Etyop_2Emin_2Ebool(V3infos_2E0)))
     => ( mono_2Ec_2Elist_2EEL_2E2_2Emono_2Etyop_2Emin_2Ebool(V4i_2E0,mono_2Ec_2Epair_2ESND_2E1_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(j_mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(s(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX_2E4(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V2p_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V3infos_2E0))))))) = mono_2Ec_2Elist_2EEL_2E2_2Emono_2Etyop_2Emin_2Ebool(V4i_2E0,V3infos_2E0) ) ) ).

tff(thm_2EpatternMatches_2Esome__var__bool__T,axiom,
    ! [F0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29] :
      ( ! [V0x_2E0: mono_2Etyop_2Emin_2Ebool] : ( mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool(F0_2E0,V0x_2E0) = V0x_2E0 )
     => ( mono_2Ec_2Eoption_2Esome_2E1_2Emono_2Etyop_2Emin_2Ebool(F0_2E0) = mono_2Ec_2Eoption_2ESOME_2E1_2Emono_2Etyop_2Emin_2Ebool(mono_2Ec_2Ebool_2ET_2E0) ) ) ).

tff(thm_2EpatternMatches_2Esome__var__bool__F,axiom,
    ! [F0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29] :
      ( ! [V0x_2E0: mono_2Etyop_2Emin_2Ebool] :
          ( p(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool(F0_2E0,V0x_2E0))
        <=> ~ p(V0x_2E0) )
     => ( mono_2Ec_2Eoption_2Esome_2E1_2Emono_2Etyop_2Emin_2Ebool(F0_2E0) = mono_2Ec_2Eoption_2ESOME_2E1_2Emono_2Etyop_2Emin_2Ebool(mono_2Ec_2Ebool_2EF_2E0) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__CONG,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,V0p_2E0: u,V1p_27_2E0: u,V2g_2E0: u,V3g_27_2E0: u,V4r_2E0: u,V5r_27_2E0: u,V6v_2E0: u,V7v_27_2E0: u] :
      ( ( ( s(tyop_2Emin_2Efun(A_27a,A_27b),V0p_2E0) = s(tyop_2Emin_2Efun(A_27a,A_27b),V1p_27_2E0) )
        & ( s(A_27b,V6v_2E0) = s(A_27b,V7v_27_2E0) )
        & ! [V8x_2E0: u] :
            ( ( s(A_27b,V6v_2E0) = s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V0p_2E0),s(A_27a,V8x_2E0))) )
           => ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V2g_2E0),s(A_27a,V8x_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V3g_27_2E0),s(A_27a,V8x_2E0)))) ) )
        & ! [V9x_2E0: u] :
            ( ( ( s(A_27b,V6v_2E0) = s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V0p_2E0),s(A_27a,V9x_2E0))) )
              & p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V2g_2E0),s(A_27a,V9x_2E0))))) )
           => ( s(A_27c,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27c),V4r_2E0),s(A_27a,V9x_2E0))) = s(A_27c,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27c),V5r_27_2E0),s(A_27a,V9x_2E0))) ) ) )
     => ( s(tyop_2Eoption_2Eoption(A_27c),c_2EpatternMatches_2EPMATCH__ROW_2E4(s(tyop_2Emin_2Efun(A_27a,A_27b),V0p_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V2g_2E0),s(tyop_2Emin_2Efun(A_27a,A_27c),V4r_2E0),s(A_27b,V6v_2E0))) = s(tyop_2Eoption_2Eoption(A_27c),c_2EpatternMatches_2EPMATCH__ROW_2E4(s(tyop_2Emin_2Efun(A_27a,A_27b),V1p_27_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V3g_27_2E0),s(tyop_2Emin_2Efun(A_27a,A_27c),V5r_27_2E0),s(A_27b,V7v_27_2E0))) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__CONG,axiom,
    ! [A_27a: d,A_27b: d,V0v_2E0: u,V1v_27_2E0: u,V2rows_2E0: u,V3rows_27_2E0: u,V4r_2E0: u,V5r_27_2E0: u] :
      ( ( ( s(A_27a,V0v_2E0) = s(A_27a,V1v_27_2E0) )
        & ( s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V4r_2E0),s(A_27a,V1v_27_2E0))) = s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V5r_27_2E0),s(A_27a,V1v_27_2E0))) )
        & ( s(A_27b,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V1v_27_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows_2E0))) = s(A_27b,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V1v_27_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V3rows_27_2E0))) ) )
     => ( s(A_27b,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V4r_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows_2E0))))) = s(A_27b,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V1v_27_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V5r_27_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V3rows_27_2E0))))) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__EQ__AUX,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,A_27d: d,V0r_27_2E0: u,V1r_2E0: u,V2p_27_2E0: u,V3p_2E0: u,V4g_27_2E0: u,V5g_2E0: u] :
      ( ( ! [V6i_2E0: u] :
            ( ? [V7x_2E0: u] : p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(s(tyop_2Emin_2Efun(A_27b,A_27a),V3p_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V5g_2E0),s(A_27a,V6i_2E0),s(A_27b,V7x_2E0)))))
          <=> ? [V8x_27_2E0: u] : p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(s(tyop_2Emin_2Efun(A_27c,A_27a),V2p_27_2E0),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),V4g_27_2E0),s(A_27a,V6i_2E0),s(A_27c,V8x_27_2E0))))) )
        & ! [V9x_2E0: u,V10x_27_2E0: u] :
            ( ( ( s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27b,A_27a),V3p_2E0),s(A_27b,V9x_2E0))) = s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27c,A_27a),V2p_27_2E0),s(A_27c,V10x_27_2E0))) )
              & p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V5g_2E0),s(A_27b,V9x_2E0)))))
              & p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),V4g_27_2E0),s(A_27c,V10x_27_2E0))))) )
           => ( s(A_27d,app_2E2(s(tyop_2Emin_2Efun(A_27b,A_27d),V1r_2E0),s(A_27b,V9x_2E0))) = s(A_27d,app_2E2(s(tyop_2Emin_2Efun(A_27c,A_27d),V0r_27_2E0),s(A_27c,V10x_27_2E0))) ) ) )
     => ( s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27b,A_27a),V3p_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V5g_2E0),s(tyop_2Emin_2Efun(A_27b,A_27d),V1r_2E0))) = s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27c,A_27a),V2p_27_2E0),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),V4g_27_2E0),s(tyop_2Emin_2Efun(A_27c,A_27d),V0r_27_2E0))) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__EQ__NONE,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,V0r_2E0: u,V1p_2E0: u,V2i_2E0: u,V3g_2E0: u] :
      ( ( s(tyop_2Eoption_2Eoption(A_27a),c_2EpatternMatches_2EPMATCH__ROW_2E4(s(tyop_2Emin_2Efun(A_27b,A_27c),V1p_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V3g_2E0),s(tyop_2Emin_2Efun(A_27b,A_27a),V0r_2E0),s(A_27c,V2i_2E0))) = s(tyop_2Eoption_2Eoption(A_27a),c_2Eoption_2ENONE_2E0) )
    <=> ! [V4x_2E0: u] : ~ p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(s(tyop_2Emin_2Efun(A_27b,A_27c),V1p_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V3g_2E0),s(A_27c,V2i_2E0),s(A_27b,V4x_2E0))))) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__EQ__SOME,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,V0y_2E0: u,V1r_2E0: u,V2p_2E0: u,V3i_2E0: u,V4g_2E0: u] :
      ( ( s(tyop_2Eoption_2Eoption(A_27a),c_2EpatternMatches_2EPMATCH__ROW_2E4(s(tyop_2Emin_2Efun(A_27b,A_27c),V2p_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V4g_2E0),s(tyop_2Emin_2Efun(A_27b,A_27a),V1r_2E0),s(A_27c,V3i_2E0))) = s(tyop_2Eoption_2Eoption(A_27a),c_2Eoption_2ESOME_2E1(s(A_27a,V0y_2E0))) )
     => ? [V5x_2E0: u] :
          ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(s(tyop_2Emin_2Efun(A_27b,A_27c),V2p_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V4g_2E0),s(A_27c,V3i_2E0),s(A_27b,V5x_2E0)))))
          & ( s(A_27a,V0y_2E0) = s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27b,A_27a),V1r_2E0),s(A_27b,V5x_2E0))) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__COND__SELECT__UNIQUE,axiom,
    ! [A_27a: d,A_27b: d,F0_2E0: u] :
      ( ! [V0p_2E0: u,V1g_2E0: u,V2i_2E0: u,V6y_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)))),F0_2E0),s(tyop_2Emin_2Efun(A_27a,A_27b),V0p_2E0))),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V1g_2E0))),s(A_27b,V2i_2E0))),s(A_27a,V6y_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(s(tyop_2Emin_2Efun(A_27a,A_27b),V0p_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V1g_2E0),s(A_27b,V2i_2E0),s(A_27a,V6y_2E0)))) )
     => ! [V0p_2E0: u,V1g_2E0: u,V2i_2E0: u] :
          ( ! [V3x1_2E0: u,V4x2_2E0: u] :
              ( ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V1g_2E0),s(A_27a,V3x1_2E0)))))
                & p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V1g_2E0),s(A_27a,V4x2_2E0)))))
                & ( s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V0p_2E0),s(A_27a,V3x1_2E0))) = s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V0p_2E0),s(A_27a,V4x2_2E0))) ) )
             => ( s(A_27a,V3x1_2E0) = s(A_27a,V4x2_2E0) ) )
         => ! [V5x_2E0: u] :
              ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(s(tyop_2Emin_2Efun(A_27a,A_27b),V0p_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V1g_2E0),s(A_27b,V2i_2E0),s(A_27a,V5x_2E0)))))
             => ( s(A_27a,c_2Emin_2E_40_2E1(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)))),F0_2E0),s(tyop_2Emin_2Efun(A_27a,A_27b),V0p_2E0))),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V1g_2E0))),s(A_27b,V2i_2E0))))) = s(A_27a,V5x_2E0) ) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__COND__DEF__GSYM,axiom,
    ! [A_27a: d,A_27b: d,V0v_2E0: u,V1pat_2E0: u,V2inp_2E0: u,V3guard_2E0: u] :
      ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(s(tyop_2Emin_2Efun(A_27a,A_27b),V1pat_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V3guard_2E0),s(A_27b,V2inp_2E0),s(A_27a,V0v_2E0)))))
    <=> ( ( s(A_27b,V2inp_2E0) = s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V1pat_2E0),s(A_27a,V0v_2E0))) )
        & p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V3guard_2E0),s(A_27a,V0v_2E0))))) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__EVAL,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,A_27d: d,F0_2E0: u,F1_2E0: u] :
      ( ! [V3p_2E0: u,V4g_2E0: u,V0v_2E0: u] :
          ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool))),F0_2E0),s(tyop_2Emin_2Efun(A_27d,A_27b),V3p_2E0))),s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),V4g_2E0))),s(A_27b,V0v_2E0)))))
        <=> ? [V5x_2E0: u] : p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(s(tyop_2Emin_2Efun(A_27d,A_27b),V3p_2E0),s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),V4g_2E0),s(A_27b,V0v_2E0),s(A_27d,V5x_2E0))))) )
     => ( ! [V3p_2E0: u,V4g_2E0: u,V0v_2E0: u,V6x_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool)))),F1_2E0),s(tyop_2Emin_2Efun(A_27d,A_27b),V3p_2E0))),s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),V4g_2E0))),s(A_27b,V0v_2E0))),s(A_27d,V6x_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(s(tyop_2Emin_2Efun(A_27d,A_27b),V3p_2E0),s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),V4g_2E0),s(A_27b,V0v_2E0),s(A_27d,V6x_2E0)))) )
       => ! [V0v_2E0: u,V1rs_2E0: u,V2r_2E0: u,V3p_2E0: u,V4g_2E0: u] :
            ( ( s(A_27a,c_2EpatternMatches_2EPMATCH_2E2(s(A_27b,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),c_2Elist_2ENIL_2E0))) = s(A_27a,c_2EpatternMatches_2EPMATCH__INCOMPLETE_2E0) )
            & ( s(A_27c,c_2EpatternMatches_2EPMATCH_2E2(s(A_27b,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27d,A_27b),V3p_2E0),s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),V4g_2E0),s(tyop_2Emin_2Efun(A_27d,A_27c),V2r_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V1rs_2E0))))) = s(A_27c,c_2Ebool_2ECOND_2E3(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool))),F0_2E0),s(tyop_2Emin_2Efun(A_27d,A_27b),V3p_2E0))),s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),V4g_2E0))),s(A_27b,V0v_2E0))),s(A_27c,app_2E2(s(tyop_2Emin_2Efun(A_27d,A_27c),V2r_2E0),s(A_27d,c_2Emin_2E_40_2E1(s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool)))),F1_2E0),s(tyop_2Emin_2Efun(A_27d,A_27b),V3p_2E0))),s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),V4g_2E0))),s(A_27b,V0v_2E0))))))),s(A_27c,c_2EpatternMatches_2EPMATCH_2E2(s(A_27b,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V1rs_2E0))))) ) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__EVAL__MATCH,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,F0_2E0: u] :
      ( ! [V3p_2E0: u,V4g_2E0: u,V0v_2E0: u,V5x_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)))),F0_2E0),s(tyop_2Emin_2Efun(A_27b,A_27c),V3p_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V4g_2E0))),s(A_27c,V0v_2E0))),s(A_27b,V5x_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(s(tyop_2Emin_2Efun(A_27b,A_27c),V3p_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V4g_2E0),s(A_27c,V0v_2E0),s(A_27b,V5x_2E0)))) )
     => ! [V0v_2E0: u,V1rs_2E0: u,V2r_2E0: u,V3p_2E0: u,V4g_2E0: u] :
          ( ( s(tyop_2Eoption_2Eoption(A_27a),c_2EpatternMatches_2EPMATCH__ROW_2E4(s(tyop_2Emin_2Efun(A_27b,A_27c),V3p_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V4g_2E0),s(tyop_2Emin_2Efun(A_27b,A_27a),V2r_2E0),s(A_27c,V0v_2E0))) != s(tyop_2Eoption_2Eoption(A_27a),c_2Eoption_2ENONE_2E0) )
         => ( s(A_27a,c_2EpatternMatches_2EPMATCH_2E2(s(A_27c,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27b,A_27c),V3p_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V4g_2E0),s(tyop_2Emin_2Efun(A_27b,A_27a),V2r_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27a))),V1rs_2E0))))) = s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27b,A_27a),V2r_2E0),s(A_27b,c_2Emin_2E_40_2E1(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)))),F0_2E0),s(tyop_2Emin_2Efun(A_27b,A_27c),V3p_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V4g_2E0))),s(A_27c,V0v_2E0))))))) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__EXTEND__BASE,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,V0v__old_2E0: u,V1v__new_2E0: u] : ( s(A_27c,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V0v__old_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2ENIL_2E0))) = s(A_27c,c_2EpatternMatches_2EPMATCH_2E2(s(A_27b,V1v__new_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2ENIL_2E0))) ) ).

tff(thm_2EpatternMatches_2EPMATCH__EXTEND__BOTH,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,V0v__old_2E0: u,V1v__new_2E0: u,V2rows__old_2E0: u,V3rows__new_2E0: u,V4r__old_2E0: u,V5r__new_2E0: u] :
      ( ( s(tyop_2Eoption_2Eoption(A_27c),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),V4r__old_2E0),s(A_27a,V0v__old_2E0))) = s(tyop_2Eoption_2Eoption(A_27c),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),V5r__new_2E0),s(A_27b,V1v__new_2E0))) )
     => ( ( s(A_27c,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V0v__old_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),V2rows__old_2E0))) = s(A_27c,c_2EpatternMatches_2EPMATCH_2E2(s(A_27b,V1v__new_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V3rows__new_2E0))) )
       => ( s(A_27c,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V0v__old_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),V4r__old_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),V2rows__old_2E0))))) = s(A_27c,c_2EpatternMatches_2EPMATCH_2E2(s(A_27b,V1v__new_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),V5r__new_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V3rows__new_2E0))))) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__EXTEND__BOTH__ID,axiom,
    ! [A_27a: d,A_27b: d,V0v_2E0: u,V1rows__old_2E0: u,V2rows__new_2E0: u,V3r_2E0: u] :
      ( ( s(A_27b,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows__old_2E0))) = s(A_27b,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows__new_2E0))) )
     => ( s(A_27b,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V3r_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows__old_2E0))))) = s(A_27b,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V3r_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows__new_2E0))))) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__EXTEND__OLD,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,V0v__old_2E0: u,V1v__new_2E0: u,V2rows__old_2E0: u,V3rows__new_2E0: u,V4r__old_2E0: u] :
      ( ( s(tyop_2Eoption_2Eoption(A_27c),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),V4r__old_2E0),s(A_27a,V0v__old_2E0))) = s(tyop_2Eoption_2Eoption(A_27c),c_2Eoption_2ENONE_2E0) )
     => ( ( s(A_27c,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V0v__old_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),V2rows__old_2E0))) = s(A_27c,c_2EpatternMatches_2EPMATCH_2E2(s(A_27b,V1v__new_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V3rows__new_2E0))) )
       => ( s(A_27c,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V0v__old_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),V4r__old_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),V2rows__old_2E0))))) = s(A_27c,c_2EpatternMatches_2EPMATCH_2E2(s(A_27b,V1v__new_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V3rows__new_2E0))) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__REMOVE__FUN,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,A_27d: d,F1_2E0: u,F0_2E0: u] :
      ( ! [V2p_2E0: u,V8x_2E0: u] : ( s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27c,A_27a),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27a)),F1_2E0),s(tyop_2Emin_2Efun(A_27c,A_27a),V2p_2E0))),s(A_27c,V8x_2E0))) = s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27c,A_27a),V2p_2E0),s(A_27c,V8x_2E0))) )
     => ( ! [V0ff_2E0: u,V2p_2E0: u,V7x_2E0: u] : ( s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27c,A_27b),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27b)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27b))),F0_2E0),s(tyop_2Emin_2Efun(A_27a,A_27b),V0ff_2E0))),s(tyop_2Emin_2Efun(A_27c,A_27a),V2p_2E0))),s(A_27c,V7x_2E0))) = s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V0ff_2E0),s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27c,A_27a),V2p_2E0),s(A_27c,V7x_2E0))))) )
       => ! [V0ff_2E0: u,V1v_2E0: u,V2p_2E0: u,V3g_2E0: u,V4r_2E0: u] :
            ( ! [V5x_2E0: u,V6y_2E0: u] :
                ( ( s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V0ff_2E0),s(A_27a,V5x_2E0))) = s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V0ff_2E0),s(A_27a,V6y_2E0))) )
               => ( s(A_27a,V5x_2E0) = s(A_27a,V6y_2E0) ) )
           => ( s(tyop_2Eoption_2Eoption(A_27d),c_2EpatternMatches_2EPMATCH__ROW_2E4(s(tyop_2Emin_2Efun(A_27c,A_27b),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27b)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27b))),F0_2E0),s(tyop_2Emin_2Efun(A_27a,A_27b),V0ff_2E0))),s(tyop_2Emin_2Efun(A_27c,A_27a),V2p_2E0))),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),V3g_2E0),s(tyop_2Emin_2Efun(A_27c,A_27d),V4r_2E0),s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V0ff_2E0),s(A_27a,V1v_2E0))))) = s(tyop_2Eoption_2Eoption(A_27d),c_2EpatternMatches_2EPMATCH__ROW_2E4(s(tyop_2Emin_2Efun(A_27c,A_27a),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27a)),F1_2E0),s(tyop_2Emin_2Efun(A_27c,A_27a),V2p_2E0))),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),V3g_2E0),s(tyop_2Emin_2Efun(A_27c,A_27d),V4r_2E0),s(A_27a,V1v_2E0))) ) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__EXTEND__INPUT,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,A_27d: d,A_27e: d,A_27f: d,F0_2E0: u,F1_2E0: u] :
      ( ! [V5g_2E0: u,V2f_27_2E0: u,V7p_27_2E0: u,V3f_2E0: u,V13x_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27e,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool))))),F0_2E0),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27e,tyop_2Emin_2Ebool)),V5g_2E0))),s(tyop_2Emin_2Efun(A_27b,A_27c),V2f_27_2E0))),s(tyop_2Emin_2Efun(A_27d,A_27b),V7p_27_2E0))),s(tyop_2Emin_2Efun(A_27d,A_27e),V3f_2E0))),s(A_27d,V13x_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27e,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27e,tyop_2Emin_2Ebool)),V5g_2E0),s(A_27c,app_2E2(s(tyop_2Emin_2Efun(A_27b,A_27c),V2f_27_2E0),s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27d,A_27b),V7p_27_2E0),s(A_27d,V13x_2E0))))))),s(A_27e,app_2E2(s(tyop_2Emin_2Efun(A_27d,A_27e),V3f_2E0),s(A_27d,V13x_2E0)))))) )
     => ( ! [V6r_2E0: u,V2f_27_2E0: u,V7p_27_2E0: u,V3f_2E0: u,V14x_2E0: u] : ( s(A_27f,app_2E2(s(tyop_2Emin_2Efun(A_27d,A_27f),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,A_27f)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,A_27f))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,A_27f)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27e,A_27f)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,A_27f))))),F1_2E0),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27e,A_27f)),V6r_2E0))),s(tyop_2Emin_2Efun(A_27b,A_27c),V2f_27_2E0))),s(tyop_2Emin_2Efun(A_27d,A_27b),V7p_27_2E0))),s(tyop_2Emin_2Efun(A_27d,A_27e),V3f_2E0))),s(A_27d,V14x_2E0))) = s(A_27f,app_2E2(s(tyop_2Emin_2Efun(A_27e,A_27f),app_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27e,A_27f)),V6r_2E0),s(A_27c,app_2E2(s(tyop_2Emin_2Efun(A_27b,A_27c),V2f_27_2E0),s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27d,A_27b),V7p_27_2E0),s(A_27d,V14x_2E0))))))),s(A_27e,app_2E2(s(tyop_2Emin_2Efun(A_27d,A_27e),V3f_2E0),s(A_27d,V14x_2E0))))) )
       => ! [V0v_2E0: u,V1v_27_2E0: u,V2f_27_2E0: u,V3f_2E0: u,V4p_2E0: u,V5g_2E0: u,V6r_2E0: u,V7p_27_2E0: u] :
            ( ( ! [V8x_27_2E0: u] :
                  ( ( s(A_27b,V1v_27_2E0) = s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27d,A_27b),V7p_27_2E0),s(A_27d,V8x_27_2E0))) )
                 => ( s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27e,A_27a),V4p_2E0),s(A_27e,app_2E2(s(tyop_2Emin_2Efun(A_27d,A_27e),V3f_2E0),s(A_27d,V8x_27_2E0))))) = s(A_27a,V0v_2E0) ) )
              & ! [V9x_2E0: u] :
                  ( ( s(A_27a,V0v_2E0) = s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27e,A_27a),V4p_2E0),s(A_27e,V9x_2E0))) )
                 => ? [V10x_27_2E0: u] : ( s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27d,A_27b),V7p_27_2E0),s(A_27d,V10x_27_2E0))) = s(A_27b,V1v_27_2E0) ) )
              & ! [V11x_2E0: u,V12y_2E0: u] :
                  ( ( s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27e,A_27a),V4p_2E0),s(A_27e,V11x_2E0))) = s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27e,A_27a),V4p_2E0),s(A_27e,V12y_2E0))) )
                 => ( s(A_27e,V11x_2E0) = s(A_27e,V12y_2E0) ) ) )
           => ( s(tyop_2Eoption_2Eoption(A_27f),c_2EpatternMatches_2EPMATCH__ROW_2E4(s(tyop_2Emin_2Efun(A_27e,A_27a),V4p_2E0),s(tyop_2Emin_2Efun(A_27e,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27e,tyop_2Emin_2Ebool)),V5g_2E0),s(A_27c,app_2E2(s(tyop_2Emin_2Efun(A_27b,A_27c),V2f_27_2E0),s(A_27b,V1v_27_2E0))))),s(tyop_2Emin_2Efun(A_27e,A_27f),app_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27e,A_27f)),V6r_2E0),s(A_27c,app_2E2(s(tyop_2Emin_2Efun(A_27b,A_27c),V2f_27_2E0),s(A_27b,V1v_27_2E0))))),s(A_27a,V0v_2E0))) = s(tyop_2Eoption_2Eoption(A_27f),c_2EpatternMatches_2EPMATCH__ROW_2E4(s(tyop_2Emin_2Efun(A_27d,A_27b),V7p_27_2E0),s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27e,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool))))),F0_2E0),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27e,tyop_2Emin_2Ebool)),V5g_2E0))),s(tyop_2Emin_2Efun(A_27b,A_27c),V2f_27_2E0))),s(tyop_2Emin_2Efun(A_27d,A_27b),V7p_27_2E0))),s(tyop_2Emin_2Efun(A_27d,A_27e),V3f_2E0))),s(tyop_2Emin_2Efun(A_27d,A_27f),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,A_27f)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,A_27f))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,A_27f)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27e,A_27f)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27c),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(A_27d,A_27f))))),F1_2E0),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Efun(A_27e,A_27f)),V6r_2E0))),s(tyop_2Emin_2Efun(A_27b,A_27c),V2f_27_2E0))),s(tyop_2Emin_2Efun(A_27d,A_27b),V7p_27_2E0))),s(tyop_2Emin_2Efun(A_27d,A_27e),V3f_2E0))),s(A_27b,V1v_27_2E0))) ) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__REMOVE__FUN__VAR,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,A_27d: d,A_27e: d,F0_2E0: u,F1_2E0: u] :
      ( ! [V4g_2E0: u,V2f_2E0: u,V12x_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool))),F0_2E0),s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),V4g_2E0))),s(tyop_2Emin_2Efun(A_27c,A_27d),V2f_2E0))),s(A_27c,V12x_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),V4g_2E0),s(A_27d,app_2E2(s(tyop_2Emin_2Efun(A_27c,A_27d),V2f_2E0),s(A_27c,V12x_2E0)))))) )
     => ( ! [V5r_2E0: u,V2f_2E0: u,V13x_2E0: u] : ( s(A_27e,app_2E2(s(tyop_2Emin_2Efun(A_27c,A_27e),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27c,A_27e)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27c,A_27e))),F1_2E0),s(tyop_2Emin_2Efun(A_27d,A_27e),V5r_2E0))),s(tyop_2Emin_2Efun(A_27c,A_27d),V2f_2E0))),s(A_27c,V13x_2E0))) = s(A_27e,app_2E2(s(tyop_2Emin_2Efun(A_27d,A_27e),V5r_2E0),s(A_27d,app_2E2(s(tyop_2Emin_2Efun(A_27c,A_27d),V2f_2E0),s(A_27c,V13x_2E0))))) )
       => ! [V0v_2E0: u,V1v_27_2E0: u,V2f_2E0: u,V3p_2E0: u,V4g_2E0: u,V5r_2E0: u,V6p_27_2E0: u] :
            ( ( ! [V7x_27_2E0: u] :
                  ( ( s(A_27b,V1v_27_2E0) = s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27c,A_27b),V6p_27_2E0),s(A_27c,V7x_27_2E0))) )
                <=> ( s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27d,A_27a),V3p_2E0),s(A_27d,app_2E2(s(tyop_2Emin_2Efun(A_27c,A_27d),V2f_2E0),s(A_27c,V7x_27_2E0))))) = s(A_27a,V0v_2E0) ) )
              & ! [V8x_2E0: u] :
                  ( ( s(A_27a,V0v_2E0) = s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27d,A_27a),V3p_2E0),s(A_27d,V8x_2E0))) )
                 => ? [V9x_27_2E0: u] : ( s(A_27d,app_2E2(s(tyop_2Emin_2Efun(A_27c,A_27d),V2f_2E0),s(A_27c,V9x_27_2E0))) = s(A_27d,V8x_2E0) ) )
              & ! [V10x_2E0: u,V11y_2E0: u] :
                  ( ( s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27d,A_27a),V3p_2E0),s(A_27d,V10x_2E0))) = s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27d,A_27a),V3p_2E0),s(A_27d,V11y_2E0))) )
                 => ( s(A_27d,V10x_2E0) = s(A_27d,V11y_2E0) ) ) )
           => ( s(tyop_2Eoption_2Eoption(A_27e),c_2EpatternMatches_2EPMATCH__ROW_2E4(s(tyop_2Emin_2Efun(A_27d,A_27a),V3p_2E0),s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),V4g_2E0),s(tyop_2Emin_2Efun(A_27d,A_27e),V5r_2E0),s(A_27a,V0v_2E0))) = s(tyop_2Eoption_2Eoption(A_27e),c_2EpatternMatches_2EPMATCH__ROW_2E4(s(tyop_2Emin_2Efun(A_27c,A_27b),V6p_27_2E0),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool))),F0_2E0),s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),V4g_2E0))),s(tyop_2Emin_2Efun(A_27c,A_27d),V2f_2E0))),s(tyop_2Emin_2Efun(A_27c,A_27e),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27c,A_27e)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27d,A_27e),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27d),tyop_2Emin_2Efun(A_27c,A_27e))),F1_2E0),s(tyop_2Emin_2Efun(A_27d,A_27e),V5r_2E0))),s(tyop_2Emin_2Efun(A_27c,A_27d),V2f_2E0))),s(A_27b,V1v_27_2E0))) ) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__EQUIV__ROWS__EQUIV__EXPAND,axiom,
    ! [A_27a: d,A_27b: d,V0v_2E0: u,V1rows2_2E0: u,V2rows1_2E0: u] :
      ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows2_2E0)))))
    <=> ( s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Ebool),c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows1_2E0))) = s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Ebool),c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows2_2E0))) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__EQUIV__ROWS__is__equiv__1,axiom,
    ! [A_27a: d,A_27b: d,V0v_2E0: u,V1rows_2E0: u] : p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0))))) ).

tff(thm_2EpatternMatches_2EPMATCH__EQUIV__ROWS__is__equiv__2,axiom,
    ! [A_27a: d,A_27b: d,V0v_2E0: u,V1rows1_2E0: u,V2rows2_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows2_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows2_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows1_2E0)))) ) ).

tff(thm_2EpatternMatches_2EPMATCH__EQUIV__ROWS__is__equiv__3,axiom,
    ! [A_27a: d,A_27b: d,V0v_2E0: u,V1rows1_2E0: u,V2rows2_2E0: u,V3rows3_2E0: u] :
      ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows2_2E0)))))
     => ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows2_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V3rows3_2E0)))))
       => p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V3rows3_2E0))))) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__EQUIV__ROWS__MATCH,axiom,
    ! [A_27a: d,A_27b: d,V0v_2E0: u,V1rows2_2E0: u,V2rows1_2E0: u] :
      ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows2_2E0)))))
     => ( s(A_27b,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows1_2E0))) = s(A_27b,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows2_2E0))) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__APPEND__SEM,axiom,
    ! [A_27a: d,A_27b: d,F0_2E0: u] :
      ( ! [V1rows1_2E0: u,V0v_2E0: u] :
          ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)),F0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows1_2E0))),s(A_27a,V0v_2E0)))))
        <=> ? [V3r_2E0: u] :
              ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Ebool_2EIN_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V3r_2E0),s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),c_2Elist_2ELIST__TO__SET_2E1(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows1_2E0)))))))
              & p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Eoption_2EIS__SOME_2E1(s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V3r_2E0),s(A_27a,V0v_2E0))))))) ) )
     => ! [V0v_2E0: u,V1rows1_2E0: u,V2rows2_2E0: u] : ( s(A_27b,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows2_2E0))))) = s(A_27b,c_2Ebool_2ECOND_2E3(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)),F0_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows1_2E0))),s(A_27a,V0v_2E0))),s(A_27b,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows1_2E0))),s(A_27b,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows2_2E0))))) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__EQUIV__APPEND,axiom,
    ! [A_27a: d,A_27b: d,V0v_2E0: u,V1rows1a_2E0: u,V2rows1b_2E0: u,V3rows2a_2E0: u,V4rows2b_2E0: u] :
      ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows1a_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows1b_2E0)))))
     => ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V3rows2a_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V4rows2b_2E0)))))
       => p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows1a_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V3rows2a_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows1b_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V4rows2b_2E0))))))) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__EQUIV__ROWS__CONS__NONE,axiom,
    ! [A_27a: d,A_27b: d,V0v_2E0: u,V1rows_2E0: u,V2row_2E0: u] :
      ( ( s(tyop_2Eoption_2Eoption(A_27a),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),V2row_2E0),s(A_27b,V0v_2E0))) = s(tyop_2Eoption_2Eoption(A_27a),c_2Eoption_2ENONE_2E0) )
     => ( s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Emin_2Ebool),c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E2(s(A_27b,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),V2row_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),V1rows_2E0))))) = s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),tyop_2Emin_2Ebool),c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E2(s(A_27b,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),V1rows_2E0))) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROWS__DROP__REDUNDANT__TRIVIAL__SOUNDNESS__EQUIV,axiom,
    ! [A_27a: d,A_27b: d,V0v_2E0: u,V1rows_2E0: u,V2n_2E0: mono_2Etyop_2Enum_2Enum] :
      ( ( p(mono_2Ec_2Eprim__rec_2E_3C_2E2(V2n_2E0,j_mono_2Etyop_2Enum_2Enum(s(tyop_2Enum_2Enum,c_2Elist_2ELENGTH_2E1(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0))))))
        & p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Eoption_2EIS__SOME_2E1(s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),c_2Elist_2EEL_2E2(s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(V2n_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0))),s(A_27a,V0v_2E0))))))) )
     => p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2ETAKE_2E2(s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(mono_2Ec_2Enum_2ESUC_2E1(V2n_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0))))))) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROWS__DROP__REDUNDANT__TRIVIAL__SOUNDNESS,axiom,
    ! [A_27a: d,A_27b: d,V0v_2E0: u,V1rows_2E0: u,V2n_2E0: mono_2Etyop_2Enum_2Enum] :
      ( ( p(mono_2Ec_2Eprim__rec_2E_3C_2E2(V2n_2E0,j_mono_2Etyop_2Enum_2Enum(s(tyop_2Enum_2Enum,c_2Elist_2ELENGTH_2E1(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0))))))
        & p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Eoption_2EIS__SOME_2E1(s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),c_2Elist_2EEL_2E2(s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(V2n_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0))),s(A_27a,V0v_2E0))))))) )
     => ( s(A_27b,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0))) = s(A_27b,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2ETAKE_2E2(s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(mono_2Ec_2Enum_2ESUC_2E1(V2n_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0))))) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROWS__DROP__REDUNDANT,axiom,
    ! [A_27a: d,A_27b: d,V0r1_2E0: u,V1r2_2E0: u,V2rows1_2E0: u,V3rows2_2E0: u,V4rows3_2E0: u,V5v_2E0: u] :
      ( ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Eoption_2EIS__SOME_2E1(s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1r2_2E0),s(A_27a,V5v_2E0)))))))
       => p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Eoption_2EIS__SOME_2E1(s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V0r1_2E0),s(A_27a,V5v_2E0))))))) )
     => ( s(A_27b,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V5v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V0r1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V3rows2_2E0))))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1r2_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V4rows3_2E0))))))) = s(A_27b,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V5v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V0r1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V3rows2_2E0))))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V4rows3_2E0))))) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROWS__DROP__REDUNDANT__PMATCH__ROWS,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,A_27d: d,V0p_2E0: u,V1g_2E0: u,V2r_2E0: u,V3p_27_2E0: u,V4g_27_2E0: u,V5r_27_2E0: u,V6rows1_2E0: u,V7rows2_2E0: u,V8rows3_2E0: u,V9v_2E0: u] :
      ( ! [V10x_27_2E0: u] :
          ( ( ( s(A_27b,V9v_2E0) = s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27d,A_27b),V3p_27_2E0),s(A_27d,V10x_27_2E0))) )
            & p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),V4g_27_2E0),s(A_27d,V10x_27_2E0))))) )
         => ? [V11x_2E0: u] :
              ( ( s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27d,A_27b),V3p_27_2E0),s(A_27d,V10x_27_2E0))) = s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V0p_2E0),s(A_27a,V11x_2E0))) )
              & p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V1g_2E0),s(A_27a,V11x_2E0))))) ) )
     => ( s(A_27c,c_2EpatternMatches_2EPMATCH_2E2(s(A_27b,V9v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V6rows1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27a,A_27b),V0p_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V1g_2E0),s(tyop_2Emin_2Efun(A_27a,A_27c),V2r_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V7rows2_2E0))))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27d,A_27b),V3p_27_2E0),s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),V4g_27_2E0),s(tyop_2Emin_2Efun(A_27d,A_27c),V5r_27_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V8rows3_2E0))))))) = s(A_27c,c_2EpatternMatches_2EPMATCH_2E2(s(A_27b,V9v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V6rows1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27a,A_27b),V0p_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V1g_2E0),s(tyop_2Emin_2Efun(A_27a,A_27c),V2r_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V7rows2_2E0))))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V8rows3_2E0))))) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROWS__DROP__SUBSUMED,axiom,
    ! [A_27a: d,A_27b: d,F0_2E0: u] :
      ( ! [V5v_2E0: u,V7row_2E0: u] :
          ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool)),F0_2E0),s(A_27a,V5v_2E0))),s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V7row_2E0)))))
        <=> ( s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V7row_2E0),s(A_27a,V5v_2E0))) = s(tyop_2Eoption_2Eoption(A_27b),c_2Eoption_2ENONE_2E0) ) )
     => ! [V0r1_2E0: u,V1r2_2E0: u,V2rows1_2E0: u,V3rows2_2E0: u,V4rows3_2E0: u,V5v_2E0: u] :
          ( ( ! [V6x_2E0: u] :
                ( ( s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V0r1_2E0),s(A_27a,V5v_2E0))) = s(tyop_2Eoption_2Eoption(A_27b),c_2Eoption_2ESOME_2E1(s(A_27b,V6x_2E0))) )
               => ( s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1r2_2E0),s(A_27a,V5v_2E0))) = s(tyop_2Eoption_2Eoption(A_27b),c_2Eoption_2ESOME_2E1(s(A_27b,V6x_2E0))) ) )
            & ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Eoption_2EIS__SOME_2E1(s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V0r1_2E0),s(A_27a,V5v_2E0)))))))
             => p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Elist_2EEVERY_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool)),F0_2E0),s(A_27a,V5v_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V3rows2_2E0))))) ) )
         => ( s(A_27b,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V5v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V0r1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V3rows2_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1r2_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V4rows3_2E0))))))))))) = s(A_27b,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V5v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V3rows2_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1r2_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V4rows3_2E0))))))) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROWS__DROP__SUBSUMED__PMATCH__ROWS,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,A_27d: d,F0_2E0: u] :
      ( ! [V0p_2E0: u,V14x_2E0: u,V15row_2E0: u] :
          ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool))),F0_2E0),s(tyop_2Emin_2Efun(A_27a,A_27b),V0p_2E0))),s(A_27a,V14x_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),V15row_2E0)))))
        <=> ( s(tyop_2Eoption_2Eoption(A_27c),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),V15row_2E0),s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V0p_2E0),s(A_27a,V14x_2E0))))) = s(tyop_2Eoption_2Eoption(A_27c),c_2Eoption_2ENONE_2E0) ) )
     => ! [V0p_2E0: u,V1g_2E0: u,V2r_2E0: u,V3p_27_2E0: u,V4g_27_2E0: u,V5r_27_2E0: u,V6rows1_2E0: u,V7rows2_2E0: u,V8rows3_2E0: u,V9v_2E0: u] :
          ( ( ! [V10x_2E0: u] :
                ( ( ( s(A_27b,V9v_2E0) = s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V0p_2E0),s(A_27a,V10x_2E0))) )
                  & p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V1g_2E0),s(A_27a,V10x_2E0))))) )
               => ? [V11x_27_2E0: u] :
                    ( ( s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V0p_2E0),s(A_27a,V10x_2E0))) = s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27d,A_27b),V3p_27_2E0),s(A_27d,V11x_27_2E0))) )
                    & p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),V4g_27_2E0),s(A_27d,V11x_27_2E0))))) ) )
            & ! [V12x_2E0: u,V13x_27_2E0: u] :
                ( ( ( s(A_27b,V9v_2E0) = s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V0p_2E0),s(A_27a,V12x_2E0))) )
                  & ( s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V0p_2E0),s(A_27a,V12x_2E0))) = s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27d,A_27b),V3p_27_2E0),s(A_27d,V13x_27_2E0))) )
                  & p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V1g_2E0),s(A_27a,V12x_2E0)))))
                  & p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),V4g_27_2E0),s(A_27d,V13x_27_2E0))))) )
               => ( s(A_27c,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27c),V2r_2E0),s(A_27a,V12x_2E0))) = s(A_27c,app_2E2(s(tyop_2Emin_2Efun(A_27d,A_27c),V5r_27_2E0),s(A_27d,V13x_27_2E0))) ) )
            & ! [V14x_2E0: u] :
                ( ( ( s(A_27b,V9v_2E0) = s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V0p_2E0),s(A_27a,V14x_2E0))) )
                  & p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V1g_2E0),s(A_27a,V14x_2E0))))) )
               => p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Elist_2EEVERY_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool))),F0_2E0),s(tyop_2Emin_2Efun(A_27a,A_27b),V0p_2E0))),s(A_27a,V14x_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V7rows2_2E0))))) ) )
         => ( s(A_27c,c_2EpatternMatches_2EPMATCH_2E2(s(A_27b,V9v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V6rows1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27a,A_27b),V0p_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V1g_2E0),s(tyop_2Emin_2Efun(A_27a,A_27c),V2r_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V7rows2_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27d,A_27b),V3p_27_2E0),s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),V4g_27_2E0),s(tyop_2Emin_2Efun(A_27d,A_27c),V5r_27_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V8rows3_2E0))))))))))) = s(A_27c,c_2EpatternMatches_2EPMATCH_2E2(s(A_27b,V9v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V6rows1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V7rows2_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27d,A_27b),V3p_27_2E0),s(tyop_2Emin_2Efun(A_27d,tyop_2Emin_2Ebool),V4g_27_2E0),s(tyop_2Emin_2Efun(A_27d,A_27c),V5r_27_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V8rows3_2E0))))))) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__REMOVE__ARB,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,V0p_2E0: u,V1g_2E0: u,V2r_2E0: u,V3v_2E0: u,V4rows_2E0: u] :
      ( ! [V5x_2E0: u] : ( s(A_27c,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27c),V2r_2E0),s(A_27a,V5x_2E0))) = s(A_27c,c_2Ebool_2EARB_2E0) )
     => ( s(A_27c,c_2EpatternMatches_2EPMATCH_2E2(s(A_27b,V3v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2ESNOC_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27a,A_27b),V0p_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V1g_2E0),s(tyop_2Emin_2Efun(A_27a,A_27c),V2r_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V4rows_2E0))))) = s(A_27c,c_2EpatternMatches_2EPMATCH_2E2(s(A_27b,V3v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V4rows_2E0))) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__INTRO__CATCHALL,axiom,
    ! [A_27a: d,A_27b: d,F1_2E0: u,F0_2E0: u,F2_2E0: u] :
      ( ! [V3__0_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),F1_2E0),s(A_27b,V3__0_2E0)))) = mono_2Ec_2Ebool_2ET_2E0 )
     => ( ! [V2__0_2E0: u] : ( s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27b,A_27b),F0_2E0),s(A_27b,V2__0_2E0))) = s(A_27b,V2__0_2E0) )
       => ( ! [V4__0_2E0: u] : ( s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27b,A_27a),F2_2E0),s(A_27b,V4__0_2E0))) = s(A_27a,c_2Ebool_2EARB_2E0) )
         => ! [V0v_2E0: u,V1rows_2E0: u] : ( s(A_27a,c_2EpatternMatches_2EPMATCH_2E2(s(A_27b,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),V1rows_2E0))) = s(A_27a,c_2EpatternMatches_2EPMATCH_2E2(s(A_27b,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),c_2Elist_2ESNOC_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27b,A_27b),F0_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),F1_2E0),s(tyop_2Emin_2Efun(A_27b,A_27a),F2_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27a))),V1rows_2E0))))) ) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__REMOVE__ARB__NO__OVERLAP,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,F0_2E0: u] :
      ( ! [V1p_2E0: u,V7x_2E0: u,V8row_2E0: u] :
          ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool))),F0_2E0),s(tyop_2Emin_2Efun(A_27b,A_27a),V1p_2E0))),s(A_27b,V7x_2E0))),s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),V8row_2E0)))))
        <=> ( s(tyop_2Eoption_2Eoption(A_27c),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),V8row_2E0),s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27b,A_27a),V1p_2E0),s(A_27b,V7x_2E0))))) = s(tyop_2Eoption_2Eoption(A_27c),c_2Eoption_2ENONE_2E0) ) )
     => ! [V0v_2E0: u,V1p_2E0: u,V2g_2E0: u,V3r_2E0: u,V4rows1_2E0: u,V5rows2_2E0: u] :
          ( ( ! [V6x_2E0: u] : ( s(A_27c,app_2E2(s(tyop_2Emin_2Efun(A_27b,A_27c),V3r_2E0),s(A_27b,V6x_2E0))) = s(A_27c,c_2Ebool_2EARB_2E0) )
            & ! [V7x_2E0: u] :
                ( ( ( s(A_27a,V0v_2E0) = s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27b,A_27a),V1p_2E0),s(A_27b,V7x_2E0))) )
                  & p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V2g_2E0),s(A_27b,V7x_2E0))))) )
               => p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Elist_2EEVERY_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),tyop_2Emin_2Ebool))),F0_2E0),s(tyop_2Emin_2Efun(A_27b,A_27a),V1p_2E0))),s(A_27b,V7x_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),V5rows2_2E0))))) ) )
         => ( s(A_27c,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),V4rows1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27b,A_27a),V1p_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V2g_2E0),s(tyop_2Emin_2Efun(A_27b,A_27c),V3r_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),V5rows2_2E0))))))) = s(A_27c,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),V4rows1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),V5rows2_2E0))))) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__REDUNDANT__NIL,axiom,
    ! [A_27a: d,A_27b: d,V0v_2E0: u,V1i_2E0: mono_2Etyop_2Enum_2Enum] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E3(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2ENIL_2E0),s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(V1i_2E0))))) = mono_2Ec_2Ebool_2EF_2E0 ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__REDUNDANT__0,axiom,
    ! [A_27a: d,A_27b: d,V0v_2E0: u,V1rs_2E0: u,V2r_2E0: u] :
      ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E3(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V2r_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rs_2E0))),s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(mono_2Ec_2Enum_2E0_2E0))))))
    <=> ( s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V2r_2E0),s(A_27a,V0v_2E0))) = s(tyop_2Eoption_2Eoption(A_27b),c_2Eoption_2ENONE_2E0) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__REDUNDANT__SUC,axiom,
    ! [A_27a: d,A_27b: d,V0v_2E0: u,V1r_2E0: u,V2rs_2E0: u,V3i_2E0: mono_2Etyop_2Enum_2Enum] :
      ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E3(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1r_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rs_2E0))),s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(mono_2Ec_2Enum_2ESUC_2E1(V3i_2E0)))))))
    <=> ( ( ( s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V1r_2E0),s(A_27a,V0v_2E0))) != s(tyop_2Eoption_2Eoption(A_27b),c_2Eoption_2ENONE_2E0) )
          & p(mono_2Ec_2Eprim__rec_2E_3C_2E2(V3i_2E0,j_mono_2Etyop_2Enum_2Enum(s(tyop_2Enum_2Enum,c_2Elist_2ELENGTH_2E1(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rs_2E0)))))) )
        | p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E3(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rs_2E0),s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(V3i_2E0)))))) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__REDUNDANT__APPEND__LT,axiom,
    ! [A_27a: d,A_27b: d,V0v_2E0: u,V1rs1_2E0: u,V2rs2_2E0: u,V3i_2E0: mono_2Etyop_2Enum_2Enum] :
      ( p(mono_2Ec_2Eprim__rec_2E_3C_2E2(V3i_2E0,j_mono_2Etyop_2Enum_2Enum(s(tyop_2Enum_2Enum,c_2Elist_2ELENGTH_2E1(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rs1_2E0))))))
     => ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E3(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rs1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rs2_2E0))),s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(V3i_2E0))))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E3(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rs1_2E0),s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(V3i_2E0))))) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__REDUNDANT__APPEND__GE,axiom,
    ! [A_27a: d,A_27b: d,F0_2E0: u] :
      ( ! [V0v_2E0: u,V4r_2E0: u] :
          ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool)),F0_2E0),s(A_27a,V0v_2E0))),s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V4r_2E0)))))
        <=> ( s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V4r_2E0),s(A_27a,V0v_2E0))) = s(tyop_2Eoption_2Eoption(A_27b),c_2Eoption_2ENONE_2E0) ) )
     => ! [V0v_2E0: u,V1rs1_2E0: u,V2rs2_2E0: u,V3i_2E0: mono_2Etyop_2Enum_2Enum] :
          ( ~ p(mono_2Ec_2Eprim__rec_2E_3C_2E2(V3i_2E0,j_mono_2Etyop_2Enum_2Enum(s(tyop_2Enum_2Enum,c_2Elist_2ELENGTH_2E1(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rs1_2E0))))))
         => ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E3(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rs1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rs2_2E0))),s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(V3i_2E0))))))
          <=> ( ( ~ p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Elist_2EEVERY_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool)),F0_2E0),s(A_27a,V0v_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rs1_2E0)))))
                & p(mono_2Ec_2Eprim__rec_2E_3C_2E2(V3i_2E0,mono_2Ec_2Earithmetic_2E_2B_2E2(j_mono_2Etyop_2Enum_2Enum(s(tyop_2Enum_2Enum,c_2Elist_2ELENGTH_2E1(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rs1_2E0)))),j_mono_2Etyop_2Enum_2Enum(s(tyop_2Enum_2Enum,c_2Elist_2ELENGTH_2E1(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rs2_2E0))))))) )
              | p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__REDUNDANT_2E3(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rs2_2E0),s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(mono_2Ec_2Earithmetic_2E_2D_2E2(V3i_2E0,j_mono_2Etyop_2Enum_2Enum(s(tyop_2Enum_2Enum,c_2Elist_2ELENGTH_2E1(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rs1_2E0))))))))))) ) ) ) ) ).

tff(thm_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO__NIL,axiom,
    ! [A_27a: d,A_27b: d,V0v_2E0: u] : p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2ENIL_2E0),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(mono_2Ec_2Ebool_2ET_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(mono_2Ec_2Elist_2ENIL_2E0_2Emono_2Etyop_2Emin_2Ebool)))))) ).

tff(thm_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO__SNOC,axiom,
    ! [A_27a: d,A_27b: d,V0v_2E0: u,V1rows_2E0: u,V2c_2E0: mono_2Etyop_2Emin_2Ebool,V3infos_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,V4r_2E0: u,V5i_2E0: mono_2Etyop_2Emin_2Ebool,V6c_27_2E0: mono_2Etyop_2Emin_2Ebool] :
      ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V2c_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V3infos_2E0))))))
     => ( ( ( s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V4r_2E0),s(A_27a,V0v_2E0))) = s(tyop_2Eoption_2Eoption(A_27b),c_2Eoption_2ENONE_2E0) )
         => ( p(V2c_2E0)
           => p(V6c_27_2E0) ) )
       => ( ( p(V2c_2E0)
           => ( p(V5i_2E0)
             => ( s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V4r_2E0),s(A_27a,V0v_2E0))) = s(tyop_2Eoption_2Eoption(A_27b),c_2Eoption_2ENONE_2E0) ) ) )
         => p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2ESNOC_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V4r_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0))),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V6c_27_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(mono_2Ec_2Elist_2ESNOC_2E2_2Emono_2Etyop_2Emin_2Ebool(V5i_2E0,V3infos_2E0))))))) ) ) ) ).

tff(thm_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO__SNOC__PMATCH__ROW,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,F0_2E0: u] :
      ( ! [V2c_2E0: mono_2Etyop_2Emin_2Ebool,V0v_2E0: u,V4p_2E0: u,V5g_2E0: u] :
          ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)))),F0_2E0),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V2c_2E0)))),s(A_27a,V0v_2E0))),s(tyop_2Emin_2Efun(A_27c,A_27a),V4p_2E0))),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),V5g_2E0)))))
        <=> ( p(V2c_2E0)
           => ~ p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(s(A_27a,V0v_2E0),s(tyop_2Emin_2Efun(A_27c,A_27a),V4p_2E0),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),V5g_2E0))))) ) )
     => ! [V0v_2E0: u,V1rows_2E0: u,V2c_2E0: mono_2Etyop_2Emin_2Ebool,V3infos_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,V4p_2E0: u,V5g_2E0: u,V6r_2E0: u,V7c_27_2E0: mono_2Etyop_2Emin_2Ebool] :
          ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V2c_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V3infos_2E0))))))
         => ( ( ~ p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(s(A_27a,V0v_2E0),s(tyop_2Emin_2Efun(A_27c,A_27a),V4p_2E0),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),V5g_2E0)))))
             => ( V2c_2E0 = V7c_27_2E0 ) )
           => p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2ESNOC_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27c,A_27a),V4p_2E0),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),V5g_2E0),s(tyop_2Emin_2Efun(A_27c,A_27b),V6r_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0))),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V7c_27_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(mono_2Ec_2Elist_2ESNOC_2E2_2Emono_2Etyop_2Emin_2Ebool(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Ebool,tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Ebool)))),F0_2E0),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V2c_2E0)))),s(A_27a,V0v_2E0))),s(tyop_2Emin_2Efun(A_27c,A_27a),V4p_2E0))),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),V5g_2E0)))),V3infos_2E0))))))) ) ) ) ).

tff(thm_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO__CONS,axiom,
    ! [A_27a: d,A_27b: d,V0v_2E0: u,V1rows_2E0: u,V2row_2E0: u,V3infos_27_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,V4i_2E0: mono_2Etyop_2Emin_2Ebool,V5c_2E0: mono_2Etyop_2Emin_2Ebool] :
      ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V2row_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0))),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V5c_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(mono_2Ec_2Elist_2ECONS_2E2_2Emono_2Etyop_2Emin_2Ebool(V4i_2E0,V3infos_27_2E0)))))))
    <=> ( ( j_mono_2Etyop_2Enum_2Enum(s(tyop_2Enum_2Enum,c_2Elist_2ELENGTH_2E1(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0)))) = mono_2Ec_2Elist_2ELENGTH_2E1_2Emono_2Etyop_2Emin_2Ebool(V3infos_27_2E0) )
        & ( p(V4i_2E0)
         => ( s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V2row_2E0),s(A_27a,V0v_2E0))) = s(tyop_2Eoption_2Eoption(A_27b),c_2Eoption_2ENONE_2E0) ) )
        & ( ( s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V2row_2E0),s(A_27a,V0v_2E0))) = s(tyop_2Eoption_2Eoption(A_27b),c_2Eoption_2ENONE_2E0) )
         => p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V5c_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V3infos_27_2E0)))))) ) ) ) ).

tff(thm_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO__THMS,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d] :
      ( ( s(tyop_2Elist_2Elist(A_27a),c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(mono_2Ec_2Elist_2ENIL_2E0_2Emono_2Etyop_2Emin_2Ebool)),s(tyop_2Elist_2Elist(A_27a),c_2Elist_2ENIL_2E0))) = s(tyop_2Elist_2Elist(A_27a),c_2Elist_2ENIL_2E0) )
      & ! [V0is_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,V1x_2E0: u,V2xs_2E0: u] : ( s(tyop_2Elist_2Elist(A_27b),c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(mono_2Ec_2Elist_2ECONS_2E2_2Emono_2Etyop_2Emin_2Ebool(mono_2Ec_2Ebool_2ET_2E0,V0is_2E0))),s(tyop_2Elist_2Elist(A_27b),c_2Elist_2ECONS_2E2(s(A_27b,V1x_2E0),s(tyop_2Elist_2Elist(A_27b),V2xs_2E0))))) = s(tyop_2Elist_2Elist(A_27b),c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V0is_2E0)),s(tyop_2Elist_2Elist(A_27b),V2xs_2E0))) )
      & ! [V3is_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,V4x_2E0: u,V5xs_2E0: u] : ( s(tyop_2Elist_2Elist(A_27c),c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(mono_2Ec_2Elist_2ECONS_2E2_2Emono_2Etyop_2Emin_2Ebool(mono_2Ec_2Ebool_2EF_2E0,V3is_2E0))),s(tyop_2Elist_2Elist(A_27c),c_2Elist_2ECONS_2E2(s(A_27c,V4x_2E0),s(tyop_2Elist_2Elist(A_27c),V5xs_2E0))))) = s(tyop_2Elist_2Elist(A_27c),c_2Elist_2ECONS_2E2(s(A_27c,V4x_2E0),s(tyop_2Elist_2Elist(A_27c),c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V3is_2E0)),s(tyop_2Elist_2Elist(A_27c),V5xs_2E0))))) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROWS__DROP__REDUNDANT__ROWS__INFO__EQUIV,axiom,
    ! [A_27a: d,A_27b: d,V0v_2E0: u,V1c_2E0: mono_2Etyop_2Emin_2Ebool,V2rows_2E0: u,V3infos_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] :
      ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows_2E0),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V1c_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V3infos_2E0))))))
     => p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V3infos_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows_2E0))))))) ) ).

tff(thm_2EpatternMatches_2EREDUNDANT__ROWS__INFO__TO__PMATCH__EQ,axiom,
    ! [A_27a: d,A_27b: d,V0v_2E0: u,V1c_2E0: mono_2Etyop_2Emin_2Ebool,V2rows_2E0: u,V3infos_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] :
      ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows_2E0),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V1c_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V3infos_2E0))))))
     => ( s(A_27b,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows_2E0))) = s(A_27b,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2EpatternMatches_2EAPPLY__REDUNDANT__ROWS__INFO_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V3infos_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rows_2E0))))) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE__REWRITES,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,A_27d: d] :
      ( ! [V0v_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2ENIL_2E0)))) = mono_2Ec_2Ebool_2EF_2E0 )
      & ! [V1v_2E0: u,V2r_2E0: u,V3rs_2E0: u] :
          ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2(s(A_27c,V1v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d)),V2r_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d))),V3rs_2E0)))))))
        <=> ( ( s(tyop_2Eoption_2Eoption(A_27d),app_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d)),V2r_2E0),s(A_27c,V1v_2E0))) != s(tyop_2Eoption_2Eoption(A_27d),c_2Eoption_2ENONE_2E0) )
            | p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2(s(A_27c,V1v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d))),V3rs_2E0))))) ) ) ) ).

tff(thm_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO__EXTRACT__IS__EXHAUSTIVE,axiom,
    ! [A_27a: d,A_27b: d,V0v_2E0: u,V1rows_2E0: u,V2c_2E0: mono_2Etyop_2Emin_2Ebool,V3infos_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] :
      ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V2c_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V3infos_2E0))))))
     => ( ~ p(V2c_2E0)
       => p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0))))) ) ) ).

tff(thm_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ__REWRITE,axiom,
    ! [F0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29] :
      ( ! [V3i1_2E0: mono_2Etyop_2Emin_2Ebool,V2i2_2E0: mono_2Etyop_2Emin_2Ebool] :
          ( p(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(F0_2E0,V3i1_2E0),V2i2_2E0))
        <=> ( p(V3i1_2E0)
            & p(V2i2_2E0) ) )
     => ! [V0is2_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,V1is1_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,V2i2_2E0: mono_2Etyop_2Emin_2Ebool,V3i1_2E0: mono_2Etyop_2Emin_2Ebool] :
          ( ( mono_2Ec_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ_2E2(mono_2Ec_2Elist_2ENIL_2E0_2Emono_2Etyop_2Emin_2Ebool,mono_2Ec_2Elist_2ENIL_2E0_2Emono_2Etyop_2Emin_2Ebool) = mono_2Ec_2Elist_2ENIL_2E0_2Emono_2Etyop_2Emin_2Ebool )
          & ( mono_2Ec_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ_2E2(mono_2Ec_2Elist_2ECONS_2E2_2Emono_2Etyop_2Emin_2Ebool(V3i1_2E0,V1is1_2E0),mono_2Ec_2Elist_2ECONS_2E2_2Emono_2Etyop_2Emin_2Ebool(V2i2_2E0,V0is2_2E0)) = mono_2Ec_2Elist_2ECONS_2E2_2Emono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(F0_2E0,V3i1_2E0),V2i2_2E0),mono_2Ec_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ_2E2(V1is1_2E0,V0is2_2E0)) ) ) ) ).

tff(thm_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ__THM,axiom,
    ! [A_27a: d,A_27b: d,F0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29] :
      ( ! [V2c_2E0: mono_2Etyop_2Emin_2Ebool,V4c_27_2E0: mono_2Etyop_2Emin_2Ebool] :
          ( p(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(F0_2E0,V2c_2E0),V4c_27_2E0))
        <=> ( p(V2c_2E0)
            | p(V4c_27_2E0) ) )
     => ! [V0v_2E0: u,V1rows_2E0: u,V2c_2E0: mono_2Etyop_2Emin_2Ebool,V3infos_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,V4c_27_2E0: mono_2Etyop_2Emin_2Ebool,V5infos_27_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] :
          ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V2c_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V3infos_2E0))))))
         => ( ( mono_2Ec_2Elist_2ELENGTH_2E1_2Emono_2Etyop_2Emin_2Ebool(V5infos_27_2E0) = mono_2Ec_2Elist_2ELENGTH_2E1_2Emono_2Etyop_2Emin_2Ebool(V3infos_2E0) )
           => p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(F0_2E0,V2c_2E0),V4c_27_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(mono_2Ec_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__CONJ_2E2(V3infos_2E0,V5infos_27_2E0))))))) ) ) ) ).

tff(thm_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__DISJ__THM,axiom,
    ! [A_27a: d,A_27b: d,F0_2E0: mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29] :
      ( ! [V2c_2E0: mono_2Etyop_2Emin_2Ebool,V4c_27_2E0: mono_2Etyop_2Emin_2Ebool] :
          ( p(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(F0_2E0,V2c_2E0),V4c_27_2E0))
        <=> ( p(V2c_2E0)
            & p(V4c_27_2E0) ) )
     => ! [V0v_2E0: u,V1rows_2E0: u,V2c_2E0: mono_2Etyop_2Emin_2Ebool,V3infos_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29,V4c_27_2E0: mono_2Etyop_2Emin_2Ebool,V5infos_27_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] :
          ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V2c_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V3infos_2E0))))))
         => ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V4c_27_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V5infos_27_2E0))))))
           => p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool(mono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29(F0_2E0,V2c_2E0),V4c_27_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(mono_2Ec_2EpatternMatches_2EREDUNDANT__ROWS__INFOS__DISJ_2E2(V3infos_2E0,V5infos_27_2E0))))))) ) ) ) ).

tff(thm_2EpatternMatches_2ELENGTH__STRONGEST__REDUNDANT__ROWS__INFO__AUX,axiom,
    ! [A_27a: d,A_27b: d,V0v_2E0: u,V1rows_2E0: u,V2p_2E0: mono_2Etyop_2Emin_2Ebool,V3infos_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] : ( mono_2Ec_2Elist_2ELENGTH_2E1_2Emono_2Etyop_2Emin_2Ebool(mono_2Ec_2Epair_2ESND_2E1_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(j_mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(s(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX_2E4(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V2p_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V3infos_2E0))))))) = mono_2Ec_2Earithmetic_2E_2B_2E2(j_mono_2Etyop_2Enum_2Enum(s(tyop_2Enum_2Enum,c_2Elist_2ELENGTH_2E1(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0)))),mono_2Ec_2Elist_2ELENGTH_2E1_2Emono_2Etyop_2Emin_2Ebool(V3infos_2E0)) ) ).

tff(thm_2EpatternMatches_2EFST__STRONGEST__REDUNDANT__ROWS__INFO__AUX,axiom,
    ! [A_27a: d,A_27b: d,F0_2E0: u] :
      ( ! [V0v_2E0: u,V4r_2E0: u] :
          ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool)),F0_2E0),s(A_27a,V0v_2E0))),s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V4r_2E0)))))
        <=> ( s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V4r_2E0),s(A_27a,V0v_2E0))) = s(tyop_2Eoption_2Eoption(A_27b),c_2Eoption_2ENONE_2E0) ) )
     => ! [V0v_2E0: u,V1rows_2E0: u,V2p_2E0: mono_2Etyop_2Emin_2Ebool,V3infos_2E0: mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29] :
          ( p(mono_2Ec_2Epair_2EFST_2E1_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(j_mono_2Etyop_2Epair_2Eprod_28tyop_2Emin_2Ebool_2Ctyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29_29(s(tyop_2Epair_2Eprod(tyop_2Emin_2Ebool,tyop_2Elist_2Elist(tyop_2Emin_2Ebool)),c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__AUX_2E4(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0),s(tyop_2Emin_2Ebool,i_mono_2Etyop_2Emin_2Ebool(V2p_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),i_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(V3infos_2E0)))))))
        <=> ( p(V2p_2E0)
            & p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Elist_2EEVERY_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool)),F0_2E0),s(A_27a,V0v_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0))))) ) ) ) ).

tff(thm_2EpatternMatches_2EEL__STRONGEST__REDUNDANT__ROWS__INFO,axiom,
    ! [A_27a: d,A_27b: d,F0_2E0: u] :
      ( ! [V0v_2E0: u,V3r_2E0: u] :
          ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool)),F0_2E0),s(A_27a,V0v_2E0))),s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V3r_2E0)))))
        <=> ( s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V3r_2E0),s(A_27a,V0v_2E0))) = s(tyop_2Eoption_2Eoption(A_27b),c_2Eoption_2ENONE_2E0) ) )
     => ! [V0v_2E0: u,V1rows_2E0: u,V2i_2E0: mono_2Etyop_2Enum_2Enum] :
          ( p(mono_2Ec_2Eprim__rec_2E_3C_2E2(V2i_2E0,j_mono_2Etyop_2Enum_2Enum(s(tyop_2Enum_2Enum,c_2Elist_2ELENGTH_2E1(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0))))))
         => ( p(mono_2Ec_2Elist_2EEL_2E2_2Emono_2Etyop_2Emin_2Ebool(V2i_2E0,j_mono_2Etyop_2Elist_2Elist_28tyop_2Emin_2Ebool_29(s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0))))))
          <=> ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Elist_2EEVERY_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool)),F0_2E0),s(A_27a,V0v_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2ETAKE_2E2(s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(V2i_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0)))))))
             => ( s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),c_2Elist_2EEL_2E2(s(tyop_2Enum_2Enum,i_mono_2Etyop_2Enum_2Enum(V2i_2E0)),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0))),s(A_27a,V0v_2E0))) = s(tyop_2Eoption_2Eoption(A_27b),c_2Eoption_2ENONE_2E0) ) ) ) ) ) ).

tff(thm_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO__OK,axiom,
    ! [A_27a: d,A_27b: d,F0_2E0: u] :
      ( ! [V0v_2E0: u,V2r_2E0: u] :
          ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool)),F0_2E0),s(A_27a,V0v_2E0))),s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V2r_2E0)))))
        <=> ( s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V2r_2E0),s(A_27a,V0v_2E0))) = s(tyop_2Eoption_2Eoption(A_27b),c_2Eoption_2ENONE_2E0) ) )
     => ! [V0v_2E0: u,V1rows_2E0: u] : p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EIS__REDUNDANT__ROWS__INFO_2E4(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0),s(tyop_2Emin_2Ebool,c_2Elist_2EEVERY_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool)),F0_2E0),s(A_27a,V0v_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Ebool),c_2EpatternMatches_2ESTRONGEST__REDUNDANT__ROWS__INFO_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rows_2E0))))))) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__COND__EX__FULL__DEF,axiom,
    ! [A_27a: d,A_27b: d,V0p_2E0: u,V1i_2E0: u,V2g_2E0: u] :
      ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(s(A_27a,V1i_2E0),s(tyop_2Emin_2Efun(A_27b,A_27a),V0p_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V2g_2E0)))))
    <=> ? [V3x_2E0: u] :
          ( ( s(A_27a,V1i_2E0) = s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27b,A_27a),V0p_2E0),s(A_27b,V3x_2E0))) )
          & p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V2g_2E0),s(A_27b,V3x_2E0))))) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__COND__EX__WEAKEN,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,F0_2E0: u] :
      ( ! [V5g_27_2E0: u,V3g_2E0: u,V0f_2E0: u,V7x_2E0: u] :
          ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)))),F0_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V5g_27_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V3g_2E0))),s(tyop_2Emin_2Efun(A_27a,A_27b),V0f_2E0))),s(A_27a,V7x_2E0)))))
        <=> ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V5g_27_2E0),s(A_27a,V7x_2E0)))))
            & ~ p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V3g_2E0),s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V0f_2E0),s(A_27a,V7x_2E0))))))) ) )
     => ! [V0f_2E0: u,V1v_2E0: u,V2p_2E0: u,V3g_2E0: u,V4p_27_2E0: u,V5g_27_2E0: u] :
          ( ~ p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(s(A_27c,V1v_2E0),s(tyop_2Emin_2Efun(A_27b,A_27c),V2p_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V3g_2E0)))))
         => ( ! [V6x_2E0: u] : ( s(A_27c,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27c),V4p_27_2E0),s(A_27a,V6x_2E0))) = s(A_27c,app_2E2(s(tyop_2Emin_2Efun(A_27b,A_27c),V2p_2E0),s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V0f_2E0),s(A_27a,V6x_2E0))))) )
           => ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(s(A_27c,V1v_2E0),s(tyop_2Emin_2Efun(A_27a,A_27c),V4p_27_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V5g_27_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(s(A_27c,V1v_2E0),s(tyop_2Emin_2Efun(A_27a,A_27c),V4p_27_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool)))),F0_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V5g_27_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V3g_2E0))),s(tyop_2Emin_2Efun(A_27a,A_27b),V0f_2E0)))))) ) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__COND__EX__FALSE,axiom,
    ! [A_27a: d,A_27b: d,V0v_2E0: u,V1p_2E0: u,V2g_2E0: u] :
      ( ! [V3x_2E0: u] : ~ p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V2g_2E0),s(A_27b,V3x_2E0)))))
     => ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(s(A_27a,V0v_2E0),s(tyop_2Emin_2Efun(A_27b,A_27a),V1p_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V2g_2E0)))) = mono_2Ec_2Ebool_2EF_2E0 ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__COND__EX__IMP__REWRITE,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,V0v_2E0: u,V1p_2E0: u,V2g_2E0: u,V3p_27_2E0: u,V4g_27_2E0: u,V5RES_2E0: mono_2Etyop_2Emin_2Ebool] :
      ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(s(A_27a,V0v_2E0),s(tyop_2Emin_2Efun(A_27b,A_27a),V1p_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V2g_2E0)))))
     => ( ! [V6x_2E0: u] :
            ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V2g_2E0),s(A_27b,V6x_2E0)))))
           => ( ? [V7x_27_2E0: u] :
                  ( ( s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27c,A_27a),V3p_27_2E0),s(A_27c,V7x_27_2E0))) = s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27b,A_27a),V1p_2E0),s(A_27b,V6x_2E0))) )
                  & p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),V4g_27_2E0),s(A_27c,V7x_27_2E0))))) )
            <=> p(V5RES_2E0) ) )
       => ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(s(A_27a,V0v_2E0),s(tyop_2Emin_2Efun(A_27c,A_27a),V3p_27_2E0),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),V4g_27_2E0)))) = V5RES_2E0 ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE__CONTRADICT,axiom,
    ! [A_27a: d,A_27b: d,F0_2E0: u] :
      ( ! [V0v_2E0: u,V2r_2E0: u] :
          ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool)),F0_2E0),s(A_27a,V0v_2E0))),s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V2r_2E0)))))
        <=> ( s(tyop_2Eoption_2Eoption(A_27b),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),V2r_2E0),s(A_27a,V0v_2E0))) = s(tyop_2Eoption_2Eoption(A_27b),c_2Eoption_2ENONE_2E0) ) )
     => ! [V0v_2E0: u,V1rs_2E0: u] :
          ( ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2Elist_2EEVERY_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),tyop_2Emin_2Ebool)),F0_2E0),s(A_27a,V0v_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rs_2E0)))))
           => p(mono_2Ec_2Ebool_2EF_2E0) )
         => p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rs_2E0))))) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__EVAL__COND__EX,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,F0_2E0: u] :
      ( ! [V1p_2E0: u,V3g_2E0: u,V2i_2E0: u,V4x_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)))),F0_2E0),s(tyop_2Emin_2Efun(A_27b,A_27a),V1p_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V3g_2E0))),s(A_27a,V2i_2E0))),s(A_27b,V4x_2E0)))) = j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND_2E4(s(tyop_2Emin_2Efun(A_27b,A_27a),V1p_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V3g_2E0),s(A_27a,V2i_2E0),s(A_27b,V4x_2E0)))) )
     => ! [V0r_2E0: u,V1p_2E0: u,V2i_2E0: u,V3g_2E0: u] :
          ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(s(A_27a,V2i_2E0),s(tyop_2Emin_2Efun(A_27b,A_27a),V1p_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V3g_2E0)))))
         => ( s(tyop_2Eoption_2Eoption(A_27c),c_2EpatternMatches_2EPMATCH__ROW_2E4(s(tyop_2Emin_2Efun(A_27b,A_27a),V1p_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V3g_2E0),s(tyop_2Emin_2Efun(A_27b,A_27c),V0r_2E0),s(A_27a,V2i_2E0))) = s(tyop_2Eoption_2Eoption(A_27c),c_2Eoption_2ESOME_2E1(s(A_27c,app_2E2(s(tyop_2Emin_2Efun(A_27b,A_27c),V0r_2E0),s(A_27b,c_2Emin_2E_40_2E1(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool)))),F0_2E0),s(tyop_2Emin_2Efun(A_27b,A_27a),V1p_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V3g_2E0))),s(A_27a,V2i_2E0))))))))) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__NEQ__NONE,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,V0r_2E0: u,V1p_2E0: u,V2i_2E0: u,V3g_2E0: u] :
      ( ( s(tyop_2Eoption_2Eoption(A_27a),c_2EpatternMatches_2EPMATCH__ROW_2E4(s(tyop_2Emin_2Efun(A_27b,A_27c),V1p_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V3g_2E0),s(tyop_2Emin_2Efun(A_27b,A_27a),V0r_2E0),s(A_27c,V2i_2E0))) != s(tyop_2Eoption_2Eoption(A_27a),c_2Eoption_2ENONE_2E0) )
    <=> p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__ROW__COND__EX_2E3(s(A_27c,V2i_2E0),s(tyop_2Emin_2Efun(A_27b,A_27c),V1p_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V3g_2E0))))) ) ).

tff(thm_2EpatternMatches_2EPMATCH__ROW__REMOVE__DOUBLE__BINDS__THM,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,A_27d: d,V0g_2E0: u,V1p1_2E0: u,V2g1_2E0: u,V3r1_2E0: u,V4p2_2E0: u,V5g2_2E0: u,V6r2_2E0: u] :
      ( ( ! [V7x_2E0: u,V8y_2E0: u] :
            ( ( s(A_27c,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27c),V1p1_2E0),s(A_27a,V7x_2E0))) = s(A_27c,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27c),V1p1_2E0),s(A_27a,V8y_2E0))) )
           => ( s(A_27a,V7x_2E0) = s(A_27a,V8y_2E0) ) )
        & ! [V9x_2E0: u] : ( s(A_27c,app_2E2(s(tyop_2Emin_2Efun(A_27b,A_27c),V4p2_2E0),s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V0g_2E0),s(A_27a,V9x_2E0))))) = s(A_27c,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27c),V1p1_2E0),s(A_27a,V9x_2E0))) )
        & ! [V10x_27_2E0: u] :
            ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V5g2_2E0),s(A_27b,V10x_27_2E0)))))
          <=> ? [V11x_2E0: u] :
                ( ( s(A_27b,V10x_27_2E0) = s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V0g_2E0),s(A_27a,V11x_2E0))) )
                & p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V2g1_2E0),s(A_27a,V11x_2E0))))) ) )
        & ! [V12x_2E0: u] : ( s(A_27d,app_2E2(s(tyop_2Emin_2Efun(A_27b,A_27d),V6r2_2E0),s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V0g_2E0),s(A_27a,V12x_2E0))))) = s(A_27d,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27d),V3r1_2E0),s(A_27a,V12x_2E0))) ) )
     => ( s(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27a,A_27c),V1p1_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V2g1_2E0),s(tyop_2Emin_2Efun(A_27a,A_27d),V3r1_2E0))) = s(tyop_2Emin_2Efun(A_27c,tyop_2Eoption_2Eoption(A_27d)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27b,A_27c),V4p2_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V5g2_2E0),s(tyop_2Emin_2Efun(A_27b,A_27d),V6r2_2E0))) ) ) ).

tff(thm_2EpatternMatches_2EGUARDS__ELIM__THM,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,F1_2E0: u,F0_2E0: u] :
      ( ! [V4g_2E0: u,V5r_2E0: u,V3p_2E0: u,V2rs2_2E0: u,V9x_2E0: u] : ( s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27c,A_27b),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(A_27c,A_27b)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(A_27c,A_27b))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(A_27c,A_27b)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(A_27c,A_27b))))),F1_2E0),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),V4g_2E0))),s(tyop_2Emin_2Efun(A_27c,A_27b),V5r_2E0))),s(tyop_2Emin_2Efun(A_27c,A_27a),V3p_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rs2_2E0))),s(A_27c,V9x_2E0))) = s(A_27b,c_2Ebool_2ECOND_2E3(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),V4g_2E0),s(A_27c,V9x_2E0))),s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27c,A_27b),V5r_2E0),s(A_27c,V9x_2E0))),s(A_27b,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27c,A_27a),V3p_2E0),s(A_27c,V9x_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rs2_2E0))))) )
     => ( ! [V8x_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),F0_2E0),s(A_27c,V8x_2E0)))) = mono_2Ec_2Ebool_2ET_2E0 )
       => ! [V0v_2E0: u,V1rs1_2E0: u,V2rs2_2E0: u,V3p_2E0: u,V4g_2E0: u,V5r_2E0: u] :
            ( ! [V6x1_2E0: u,V7x2_2E0: u] :
                ( ( s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27c,A_27a),V3p_2E0),s(A_27c,V6x1_2E0))) = s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27c,A_27a),V3p_2E0),s(A_27c,V7x2_2E0))) )
               => ( s(A_27c,V6x1_2E0) = s(A_27c,V7x2_2E0) ) )
           => ( s(A_27b,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rs1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27c,A_27a),V3p_2E0),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),V4g_2E0),s(tyop_2Emin_2Efun(A_27c,A_27b),V5r_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rs2_2E0))))))) = s(A_27b,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V1rs1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27c,A_27a),V3p_2E0),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),F0_2E0),s(tyop_2Emin_2Efun(A_27c,A_27b),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(A_27c,A_27b)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(A_27c,A_27b))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(A_27c,A_27b)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),tyop_2Emin_2Efun(A_27c,A_27b))))),F1_2E0),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),V4g_2E0))),s(tyop_2Emin_2Efun(A_27c,A_27b),V5r_2E0))),s(tyop_2Emin_2Efun(A_27c,A_27a),V3p_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rs2_2E0))))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27b))),V2rs2_2E0))))))) ) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__FLATTEN__THM__SINGLE,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,F3_2E0: u,F1_2E0: u,F2_2E0: u,F0_2E0: u] :
      ( ! [V6x_2E0: u,V7r_2E0: u] : ( s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),F3_2E0),s(A_27b,V6x_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V7r_2E0))) = s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V7r_2E0),s(A_27b,V6x_2E0))) )
     => ( ! [V3rows_2E0: u,V6x_2E0: u] : ( s(A_27c,app_2E2(s(tyop_2Emin_2Efun(A_27b,A_27c),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),tyop_2Emin_2Efun(A_27b,A_27c)),F1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),V3rows_2E0))),s(A_27b,V6x_2E0))) = s(A_27c,c_2EpatternMatches_2EPMATCH_2E2(s(A_27b,V6x_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2EMAP_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),F3_2E0),s(A_27b,V6x_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),V3rows_2E0))))) )
       => ( ! [V1p_2E0: u,V2g_2E0: u,V8r_2E0: u] : ( s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))))),F2_2E0),s(tyop_2Emin_2Efun(A_27b,A_27a),V1p_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V2g_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V8r_2E0))) = s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E3(s(tyop_2Emin_2Efun(A_27b,A_27a),V1p_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V2g_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V8r_2E0))) )
         => ( ! [V4x_2E0: u,V5r_2E0: u] : ( s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),F0_2E0),s(A_27b,V4x_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V5r_2E0))) = s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V5r_2E0),s(A_27b,V4x_2E0))) )
           => ! [V0v_2E0: u,V1p_2E0: u,V2g_2E0: u,V3rows_2E0: u] :
                ( ! [V4x_2E0: u] : p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2(s(A_27b,V4x_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2EMAP_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),F0_2E0),s(A_27b,V4x_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),V3rows_2E0)))))))
               => p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__EQUIV__ROWS_2E3(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27b,A_27a),V1p_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V2g_2E0),s(tyop_2Emin_2Efun(A_27b,A_27c),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),tyop_2Emin_2Efun(A_27b,A_27c)),F1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),V3rows_2E0))))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2ENIL_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2EMAP_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))))),F2_2E0),s(tyop_2Emin_2Efun(A_27b,A_27a),V1p_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V2g_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),V3rows_2E0))))))) ) ) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__FLATTEN__THM,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,F3_2E0: u,F1_2E0: u,F2_2E0: u,F0_2E0: u] :
      ( ! [V8x_2E0: u,V9r_2E0: u] : ( s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),F3_2E0),s(A_27b,V8x_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V9r_2E0))) = s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V9r_2E0),s(A_27b,V8x_2E0))) )
     => ( ! [V5rows_2E0: u,V8x_2E0: u] : ( s(A_27c,app_2E2(s(tyop_2Emin_2Efun(A_27b,A_27c),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),tyop_2Emin_2Efun(A_27b,A_27c)),F1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),V5rows_2E0))),s(A_27b,V8x_2E0))) = s(A_27c,c_2EpatternMatches_2EPMATCH_2E2(s(A_27b,V8x_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2EMAP_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),F3_2E0),s(A_27b,V8x_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),V5rows_2E0))))) )
       => ( ! [V1p_2E0: u,V2g_2E0: u,V10r_2E0: u] : ( s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))))),F2_2E0),s(tyop_2Emin_2Efun(A_27b,A_27a),V1p_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V2g_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V10r_2E0))) = s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E3(s(tyop_2Emin_2Efun(A_27b,A_27a),V1p_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V2g_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V10r_2E0))) )
         => ( ! [V6x_2E0: u,V7r_2E0: u] : ( s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),F0_2E0),s(A_27b,V6x_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V7r_2E0))) = s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),V7r_2E0),s(A_27b,V6x_2E0))) )
           => ! [V0v_2E0: u,V1p_2E0: u,V2g_2E0: u,V3rows1_2E0: u,V4rows2_2E0: u,V5rows_2E0: u] :
                ( ! [V6x_2E0: u] : p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,c_2EpatternMatches_2EPMATCH__IS__EXHAUSTIVE_2E2(s(A_27b,V6x_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2EMAP_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),app_2E2(s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),F0_2E0),s(A_27b,V6x_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),V5rows_2E0)))))))
               => ( s(A_27c,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),V3rows1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2ECONS_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27b,A_27a),V1p_2E0),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V2g_2E0),s(tyop_2Emin_2Efun(A_27b,A_27c),app_2E2(s(tyop_2Emin_2Efun(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),tyop_2Emin_2Efun(A_27b,A_27c)),F1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),V5rows_2E0))))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),V4rows2_2E0))))))) = s(A_27c,c_2EpatternMatches_2EPMATCH_2E2(s(A_27a,V0v_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2EAPPEND_2E2(s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),V3rows1_2E0),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),c_2Elist_2EMAP_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c))),tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))))),F2_2E0),s(tyop_2Emin_2Efun(A_27b,A_27a),V1p_2E0))),s(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Ebool),V2g_2E0))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27b,tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27c)))),V5rows_2E0))))),s(tyop_2Elist_2Elist(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27c))),V4rows2_2E0))))) ) ) ) ) ) ) ).

tff(thm_2EpatternMatches_2EPMATCH__FLATTEN__FUN__PMATCH__ROW,conjecture,
    ! [A_27a: d,A_27b: d,A_27c: d,A_27d: d,F0_2E0: u,F3_2E0: u,F2_2E0: u,F1_2E0: u] :
      ( ! [V4p_27_2E0: u,V5g_27_2E0: u,V6r_27_2E0: u,V7x_2E0: u] : ( s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d)),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,A_27d)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,A_27d)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d))))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,A_27d)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d)))))),F0_2E0),s(tyop_2Emin_2Efun(A_27c,A_27a),V4p_27_2E0))),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),V5g_27_2E0))),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,A_27d)),V6r_27_2E0))),s(A_27a,V7x_2E0))) = s(tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27c,A_27a),V4p_27_2E0),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),V5g_27_2E0),s(A_27a,V7x_2E0))),s(tyop_2Emin_2Efun(A_27c,A_27d),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,A_27d)),V6r_27_2E0),s(A_27a,V7x_2E0))))) )
     => ( ! [V6r_27_2E0: u,V4p_27_2E0: u,V10x_2E0: u] : ( s(A_27d,app_2E2(s(tyop_2Emin_2Efun(A_27c,A_27d),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27d)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,A_27d)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27d))),F3_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,A_27d)),V6r_27_2E0))),s(tyop_2Emin_2Efun(A_27c,A_27a),V4p_27_2E0))),s(A_27c,V10x_2E0))) = s(A_27d,app_2E2(s(tyop_2Emin_2Efun(A_27c,A_27d),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,A_27d)),V6r_27_2E0),s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27c,A_27a),V4p_27_2E0),s(A_27c,V10x_2E0))))),s(A_27c,V10x_2E0))) )
       => ( ! [V3g_2E0: u,V4p_27_2E0: u,V5g_27_2E0: u,V9x_2E0: u] :
              ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)))),F2_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V3g_2E0))),s(tyop_2Emin_2Efun(A_27c,A_27a),V4p_27_2E0))),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),V5g_27_2E0))),s(A_27c,V9x_2E0)))))
            <=> ( p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V3g_2E0),s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27c,A_27a),V4p_27_2E0),s(A_27c,V9x_2E0)))))))
                & p(j_mono_2Etyop_2Emin_2Ebool(s(tyop_2Emin_2Ebool,app_2E2(s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),V5g_27_2E0),s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27c,A_27a),V4p_27_2E0),s(A_27c,V9x_2E0))))),s(A_27c,V9x_2E0))))) ) )
         => ( ! [V0p_2E0: u,V4p_27_2E0: u,V8x_2E0: u] : ( s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27c,A_27b),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27b)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27b))),F1_2E0),s(tyop_2Emin_2Efun(A_27a,A_27b),V0p_2E0))),s(tyop_2Emin_2Efun(A_27c,A_27a),V4p_27_2E0))),s(A_27c,V8x_2E0))) = s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V0p_2E0),s(A_27a,app_2E2(s(tyop_2Emin_2Efun(A_27c,A_27a),V4p_27_2E0),s(A_27c,V8x_2E0))))) )
           => ! [V0p_2E0: u] :
                ( ! [V1x1_2E0: u,V2x2_2E0: u] :
                    ( ( s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V0p_2E0),s(A_27a,V1x1_2E0))) = s(A_27b,app_2E2(s(tyop_2Emin_2Efun(A_27a,A_27b),V0p_2E0),s(A_27a,V2x2_2E0))) )
                   => ( s(A_27a,V1x1_2E0) = s(A_27a,V2x2_2E0) ) )
               => ! [V3g_2E0: u,V4p_27_2E0: u,V5g_27_2E0: u,V6r_27_2E0: u] : ( s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27d)),c_2EpatternMatches_2EPMATCH__FLATTEN__FUN_2E3(s(tyop_2Emin_2Efun(A_27a,A_27b),V0p_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V3g_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,A_27d)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d)))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,A_27d)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d))))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,A_27d)),tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27a,tyop_2Eoption_2Eoption(A_27d)))))),F0_2E0),s(tyop_2Emin_2Efun(A_27c,A_27a),V4p_27_2E0))),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),V5g_27_2E0))),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,A_27d)),V6r_27_2E0))))) = s(tyop_2Emin_2Efun(A_27b,tyop_2Eoption_2Eoption(A_27d)),c_2EpatternMatches_2EPMATCH__ROW_2E3(s(tyop_2Emin_2Efun(A_27c,A_27b),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27b)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,A_27b),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27b))),F1_2E0),s(tyop_2Emin_2Efun(A_27a,A_27b),V0p_2E0))),s(tyop_2Emin_2Efun(A_27c,A_27a),V4p_27_2E0))),s(tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool))),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)))),F2_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Ebool),V3g_2E0))),s(tyop_2Emin_2Efun(A_27c,A_27a),V4p_27_2E0))),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,tyop_2Emin_2Ebool)),V5g_27_2E0))),s(tyop_2Emin_2Efun(A_27c,A_27d),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27d)),app_2E2(s(tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,A_27d)),tyop_2Emin_2Efun(tyop_2Emin_2Efun(A_27c,A_27a),tyop_2Emin_2Efun(A_27c,A_27d))),F3_2E0),s(tyop_2Emin_2Efun(A_27a,tyop_2Emin_2Efun(A_27c,A_27d)),V6r_27_2E0))),s(tyop_2Emin_2Efun(A_27c,A_27a),V4p_27_2E0))))) ) ) ) ) ) ) ).

%------------------------------------------------------------------------------
