%------------------------------------------------------------------------------
% File     : HWV129+1 : TPTP v9.2.0. Released v6.1.0.
% Domain   : Hardware Verification
% Problem  : niu_rxc property 1 cone of influence 5_b20
% Version  : Especial.
% English  : Verification of a property of the SPARCT2 RTL hardware design.

% Refs     : [Kha14] Khasidashvili (2014), Email to Geoff Sutcliffe
% Source   : [Kha14]
% Names    : niu_rxc_prop1_cone5_b20 [Kha14]

% Status   : Theorem
% Rating   : 1.00 v6.1.0
% Syntax   : Number of formulae    : 19962 (2714 unt;   0 def)
%            Number of atoms       : 344125 (1153 equ)
%            Maximal formula atoms :  359 (  17 avg)
%            Number of connectives : 330165 (6002   ~;2784   |;150720   &)
%                                         (162315 <=>;8344  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  172 (  11 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of predicates  : 13234 (13231 usr;   2 prp; 0-2 aty)
%            Number of functors    : 9493 (9493 usr;9493 con; 0-0 aty)
%            Number of variables   : 22060 (22060   !;   0   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : Copyright 2013 Moshe Emmer and Zurab Khasidashvili
%            Licensed under the Apache License, Version 2.0 (the "License");
%            you may not use this file except in compliance with the License.
%            You may obtain a copy of the License at
%                http://www.apache.org/licenses/LICENSE-2.0
%            Unless required by applicable law or agreed to in writing,
%            software distributed under the License is distributed on an "AS
%            IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
%            express or implied. See the License for the specific language
%            governing permissions and limitations under the License.
%------------------------------------------------------------------------------
fof(pathAxiom_8,axiom,
    nextState(constB8,constB9) ).

fof(pathAxiom_7,axiom,
    nextState(constB7,constB8) ).

fof(pathAxiom_6,axiom,
    nextState(constB6,constB7) ).

fof(pathAxiom_5,axiom,
    nextState(constB5,constB6) ).

fof(pathAxiom_4,axiom,
    nextState(constB4,constB5) ).

fof(pathAxiom_3,axiom,
    nextState(constB3,constB4) ).

fof(pathAxiom_2,axiom,
    nextState(constB2,constB3) ).

fof(pathAxiom_1,axiom,
    nextState(constB1,constB2) ).

fof(pathAxiom,axiom,
    nextState(constB0,constB1) ).

fof(reachableStateAxiom_22,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( reachableState(VarCurr)
        & reachableState(VarNext) ) ) ).

fof(reachableStateAxiom_21,axiom,
    ! [VarState] :
      ( reachableState(VarState)
     => ( constB0 = VarState
        | constB1 = VarState
        | constB2 = VarState
        | constB3 = VarState
        | constB4 = VarState
        | constB5 = VarState
        | constB6 = VarState
        | constB7 = VarState
        | constB8 = VarState
        | constB9 = VarState
        | constB10 = VarState
        | constB11 = VarState
        | constB12 = VarState
        | constB13 = VarState
        | constB14 = VarState
        | constB15 = VarState
        | constB16 = VarState
        | constB17 = VarState
        | constB18 = VarState
        | constB19 = VarState
        | constB20 = VarState ) ) ).

fof(reachableStateAxiom_20,axiom,
    reachableState(constB20) ).

fof(reachableStateAxiom_19,axiom,
    reachableState(constB19) ).

fof(reachableStateAxiom_18,axiom,
    reachableState(constB18) ).

fof(reachableStateAxiom_17,axiom,
    reachableState(constB17) ).

fof(reachableStateAxiom_16,axiom,
    reachableState(constB16) ).

fof(reachableStateAxiom_15,axiom,
    reachableState(constB15) ).

fof(reachableStateAxiom_14,axiom,
    reachableState(constB14) ).

fof(reachableStateAxiom_13,axiom,
    reachableState(constB13) ).

fof(reachableStateAxiom_12,axiom,
    reachableState(constB12) ).

fof(reachableStateAxiom_11,axiom,
    reachableState(constB11) ).

fof(reachableStateAxiom_10,axiom,
    reachableState(constB10) ).

fof(reachableStateAxiom_9,axiom,
    reachableState(constB9) ).

fof(reachableStateAxiom_8,axiom,
    reachableState(constB8) ).

fof(reachableStateAxiom_7,axiom,
    reachableState(constB7) ).

fof(reachableStateAxiom_6,axiom,
    reachableState(constB6) ).

fof(reachableStateAxiom_5,axiom,
    reachableState(constB5) ).

fof(reachableStateAxiom_4,axiom,
    reachableState(constB4) ).

fof(reachableStateAxiom_3,axiom,
    reachableState(constB3) ).

fof(reachableStateAxiom_2,axiom,
    reachableState(constB2) ).

fof(reachableStateAxiom_1,axiom,
    reachableState(constB1) ).

fof(reachableStateAxiom,axiom,
    reachableState(constB0) ).

fof(clock_toggling,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1(VarCurr)
      <=> ~ v1(VarNext) ) ) ).

fof(clock_pattern,axiom,
    ~ v1(constB0) ).

fof(addAssertion,conjecture,
    ! [VarCurr] :
      ( reachableState(VarCurr)
     => v4(VarCurr) ) ).

fof(writeUnaryOperator_1791,axiom,
    ! [VarCurr] :
      ( ~ v4(VarCurr)
    <=> v20275(VarCurr) ) ).

fof(writeUnaryOperator_1790,axiom,
    ! [VarCurr] :
      ( ~ v20275(VarCurr)
    <=> v20276(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5559,axiom,
    ! [VarCurr] :
      ( v20276(VarCurr)
    <=> ( v20278(VarCurr)
        & v20432(VarCurr) ) ) ).

fof(writeUnaryOperator_1789,axiom,
    ! [VarCurr] :
      ( ~ v20432(VarCurr)
    <=> v20279(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_1788,axiom,
    ! [VarCurr] :
      ( ~ v20278(VarCurr)
    <=> v20279(VarCurr,bitIndex2) ) ).

fof(addAssignment_3171,axiom,
    ! [VarCurr] :
      ( v20279(VarCurr,bitIndex0)
    <=> v20427(VarCurr) ) ).

fof(addAssignment_3170,axiom,
    ! [VarCurr] :
      ( v20279(VarCurr,bitIndex1)
    <=> v20422(VarCurr) ) ).

fof(addAssignment_3169,axiom,
    ! [VarCurr] :
      ( v20279(VarCurr,bitIndex2)
    <=> v20417(VarCurr) ) ).

fof(addAssignment_3168,axiom,
    ! [VarCurr] :
      ( v20279(VarCurr,bitIndex3)
    <=> v20281(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5558,axiom,
    ! [VarCurr] :
      ( v20427(VarCurr)
    <=> ( v20428(VarCurr)
        & v20431(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1739,axiom,
    ! [VarCurr] :
      ( v20431(VarCurr)
    <=> ( v20411(VarCurr)
        | v6(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5557,axiom,
    ! [VarCurr] :
      ( v20428(VarCurr)
    <=> ( v20429(VarCurr)
        | v20430(VarCurr) ) ) ).

fof(writeUnaryOperator_1787,axiom,
    ! [VarCurr] :
      ( ~ v20430(VarCurr)
    <=> v6(VarCurr,bitIndex8) ) ).

fof(writeUnaryOperator_1786,axiom,
    ! [VarCurr] :
      ( ~ v20429(VarCurr)
    <=> v20411(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5556,axiom,
    ! [VarCurr] :
      ( v20422(VarCurr)
    <=> ( v20423(VarCurr)
        & v20426(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5555,axiom,
    ! [VarCurr] :
      ( v20426(VarCurr)
    <=> ( v20405(VarCurr)
        | v20410(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5554,axiom,
    ! [VarCurr] :
      ( v20423(VarCurr)
    <=> ( v20424(VarCurr)
        | v20425(VarCurr) ) ) ).

fof(writeUnaryOperator_1785,axiom,
    ! [VarCurr] :
      ( ~ v20425(VarCurr)
    <=> v20410(VarCurr) ) ).

fof(writeUnaryOperator_1784,axiom,
    ! [VarCurr] :
      ( ~ v20424(VarCurr)
    <=> v20405(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5553,axiom,
    ! [VarCurr] :
      ( v20417(VarCurr)
    <=> ( v20418(VarCurr)
        & v20421(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5552,axiom,
    ! [VarCurr] :
      ( v20421(VarCurr)
    <=> ( v20399(VarCurr)
        | v20404(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5551,axiom,
    ! [VarCurr] :
      ( v20418(VarCurr)
    <=> ( v20419(VarCurr)
        | v20420(VarCurr) ) ) ).

fof(writeUnaryOperator_1783,axiom,
    ! [VarCurr] :
      ( ~ v20420(VarCurr)
    <=> v20404(VarCurr) ) ).

fof(writeUnaryOperator_1782,axiom,
    ! [VarCurr] :
      ( ~ v20419(VarCurr)
    <=> v20399(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5550,axiom,
    ! [VarCurr] :
      ( v20281(VarCurr)
    <=> ( v20282(VarCurr)
        & v20416(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5549,axiom,
    ! [VarCurr] :
      ( v20416(VarCurr)
    <=> ( v20284(VarCurr)
        | v20398(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5548,axiom,
    ! [VarCurr] :
      ( v20282(VarCurr)
    <=> ( v20283(VarCurr)
        | v20397(VarCurr) ) ) ).

fof(writeUnaryOperator_1781,axiom,
    ! [VarCurr] :
      ( ~ v20397(VarCurr)
    <=> v20398(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5547,axiom,
    ! [VarCurr] :
      ( v20398(VarCurr)
    <=> ( v20399(VarCurr)
        & v20404(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5546,axiom,
    ! [VarCurr] :
      ( v20404(VarCurr)
    <=> ( v20405(VarCurr)
        & v20410(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1738,axiom,
    ! [VarCurr] :
      ( v20410(VarCurr)
    <=> ( v20411(VarCurr)
        & v6(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5545,axiom,
    ! [VarCurr] :
      ( v20411(VarCurr)
    <=> ( v20412(VarCurr)
        & v20415(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1737,axiom,
    ! [VarCurr] :
      ( v20415(VarCurr)
    <=> ( v20391(VarCurr)
        | v6(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5544,axiom,
    ! [VarCurr] :
      ( v20412(VarCurr)
    <=> ( v20413(VarCurr)
        | v20414(VarCurr) ) ) ).

fof(writeUnaryOperator_1780,axiom,
    ! [VarCurr] :
      ( ~ v20414(VarCurr)
    <=> v6(VarCurr,bitIndex7) ) ).

fof(writeUnaryOperator_1779,axiom,
    ! [VarCurr] :
      ( ~ v20413(VarCurr)
    <=> v20391(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5543,axiom,
    ! [VarCurr] :
      ( v20405(VarCurr)
    <=> ( v20406(VarCurr)
        & v20409(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5542,axiom,
    ! [VarCurr] :
      ( v20409(VarCurr)
    <=> ( v20385(VarCurr)
        | v20390(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5541,axiom,
    ! [VarCurr] :
      ( v20406(VarCurr)
    <=> ( v20407(VarCurr)
        | v20408(VarCurr) ) ) ).

fof(writeUnaryOperator_1778,axiom,
    ! [VarCurr] :
      ( ~ v20408(VarCurr)
    <=> v20390(VarCurr) ) ).

fof(writeUnaryOperator_1777,axiom,
    ! [VarCurr] :
      ( ~ v20407(VarCurr)
    <=> v20385(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5540,axiom,
    ! [VarCurr] :
      ( v20399(VarCurr)
    <=> ( v20400(VarCurr)
        & v20403(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5539,axiom,
    ! [VarCurr] :
      ( v20403(VarCurr)
    <=> ( v20379(VarCurr)
        | v20384(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5538,axiom,
    ! [VarCurr] :
      ( v20400(VarCurr)
    <=> ( v20401(VarCurr)
        | v20402(VarCurr) ) ) ).

fof(writeUnaryOperator_1776,axiom,
    ! [VarCurr] :
      ( ~ v20402(VarCurr)
    <=> v20384(VarCurr) ) ).

fof(writeUnaryOperator_1775,axiom,
    ! [VarCurr] :
      ( ~ v20401(VarCurr)
    <=> v20379(VarCurr) ) ).

fof(writeUnaryOperator_1774,axiom,
    ! [VarCurr] :
      ( ~ v20283(VarCurr)
    <=> v20284(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5537,axiom,
    ! [VarCurr] :
      ( v20284(VarCurr)
    <=> ( v20285(VarCurr)
        & v20396(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5536,axiom,
    ! [VarCurr] :
      ( v20396(VarCurr)
    <=> ( v20287(VarCurr)
        | v20378(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5535,axiom,
    ! [VarCurr] :
      ( v20285(VarCurr)
    <=> ( v20286(VarCurr)
        | v20377(VarCurr) ) ) ).

fof(writeUnaryOperator_1773,axiom,
    ! [VarCurr] :
      ( ~ v20377(VarCurr)
    <=> v20378(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5534,axiom,
    ! [VarCurr] :
      ( v20378(VarCurr)
    <=> ( v20379(VarCurr)
        & v20384(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5533,axiom,
    ! [VarCurr] :
      ( v20384(VarCurr)
    <=> ( v20385(VarCurr)
        & v20390(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1736,axiom,
    ! [VarCurr] :
      ( v20390(VarCurr)
    <=> ( v20391(VarCurr)
        & v6(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5532,axiom,
    ! [VarCurr] :
      ( v20391(VarCurr)
    <=> ( v20392(VarCurr)
        & v20395(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1735,axiom,
    ! [VarCurr] :
      ( v20395(VarCurr)
    <=> ( v20371(VarCurr)
        | v6(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5531,axiom,
    ! [VarCurr] :
      ( v20392(VarCurr)
    <=> ( v20393(VarCurr)
        | v20394(VarCurr) ) ) ).

fof(writeUnaryOperator_1772,axiom,
    ! [VarCurr] :
      ( ~ v20394(VarCurr)
    <=> v6(VarCurr,bitIndex6) ) ).

fof(writeUnaryOperator_1771,axiom,
    ! [VarCurr] :
      ( ~ v20393(VarCurr)
    <=> v20371(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5530,axiom,
    ! [VarCurr] :
      ( v20385(VarCurr)
    <=> ( v20386(VarCurr)
        & v20389(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5529,axiom,
    ! [VarCurr] :
      ( v20389(VarCurr)
    <=> ( v20365(VarCurr)
        | v20370(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5528,axiom,
    ! [VarCurr] :
      ( v20386(VarCurr)
    <=> ( v20387(VarCurr)
        | v20388(VarCurr) ) ) ).

fof(writeUnaryOperator_1770,axiom,
    ! [VarCurr] :
      ( ~ v20388(VarCurr)
    <=> v20370(VarCurr) ) ).

fof(writeUnaryOperator_1769,axiom,
    ! [VarCurr] :
      ( ~ v20387(VarCurr)
    <=> v20365(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5527,axiom,
    ! [VarCurr] :
      ( v20379(VarCurr)
    <=> ( v20380(VarCurr)
        & v20383(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5526,axiom,
    ! [VarCurr] :
      ( v20383(VarCurr)
    <=> ( v20359(VarCurr)
        | v20364(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5525,axiom,
    ! [VarCurr] :
      ( v20380(VarCurr)
    <=> ( v20381(VarCurr)
        | v20382(VarCurr) ) ) ).

fof(writeUnaryOperator_1768,axiom,
    ! [VarCurr] :
      ( ~ v20382(VarCurr)
    <=> v20364(VarCurr) ) ).

fof(writeUnaryOperator_1767,axiom,
    ! [VarCurr] :
      ( ~ v20381(VarCurr)
    <=> v20359(VarCurr) ) ).

fof(writeUnaryOperator_1766,axiom,
    ! [VarCurr] :
      ( ~ v20286(VarCurr)
    <=> v20287(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5524,axiom,
    ! [VarCurr] :
      ( v20287(VarCurr)
    <=> ( v20288(VarCurr)
        & v20376(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5523,axiom,
    ! [VarCurr] :
      ( v20376(VarCurr)
    <=> ( v20290(VarCurr)
        | v20358(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5522,axiom,
    ! [VarCurr] :
      ( v20288(VarCurr)
    <=> ( v20289(VarCurr)
        | v20357(VarCurr) ) ) ).

fof(writeUnaryOperator_1765,axiom,
    ! [VarCurr] :
      ( ~ v20357(VarCurr)
    <=> v20358(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5521,axiom,
    ! [VarCurr] :
      ( v20358(VarCurr)
    <=> ( v20359(VarCurr)
        & v20364(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5520,axiom,
    ! [VarCurr] :
      ( v20364(VarCurr)
    <=> ( v20365(VarCurr)
        & v20370(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1734,axiom,
    ! [VarCurr] :
      ( v20370(VarCurr)
    <=> ( v20371(VarCurr)
        & v6(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5519,axiom,
    ! [VarCurr] :
      ( v20371(VarCurr)
    <=> ( v20372(VarCurr)
        & v20375(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1733,axiom,
    ! [VarCurr] :
      ( v20375(VarCurr)
    <=> ( v20351(VarCurr)
        | v6(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5518,axiom,
    ! [VarCurr] :
      ( v20372(VarCurr)
    <=> ( v20373(VarCurr)
        | v20374(VarCurr) ) ) ).

fof(writeUnaryOperator_1764,axiom,
    ! [VarCurr] :
      ( ~ v20374(VarCurr)
    <=> v6(VarCurr,bitIndex5) ) ).

fof(writeUnaryOperator_1763,axiom,
    ! [VarCurr] :
      ( ~ v20373(VarCurr)
    <=> v20351(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5517,axiom,
    ! [VarCurr] :
      ( v20365(VarCurr)
    <=> ( v20366(VarCurr)
        & v20369(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5516,axiom,
    ! [VarCurr] :
      ( v20369(VarCurr)
    <=> ( v20345(VarCurr)
        | v20350(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5515,axiom,
    ! [VarCurr] :
      ( v20366(VarCurr)
    <=> ( v20367(VarCurr)
        | v20368(VarCurr) ) ) ).

fof(writeUnaryOperator_1762,axiom,
    ! [VarCurr] :
      ( ~ v20368(VarCurr)
    <=> v20350(VarCurr) ) ).

fof(writeUnaryOperator_1761,axiom,
    ! [VarCurr] :
      ( ~ v20367(VarCurr)
    <=> v20345(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5514,axiom,
    ! [VarCurr] :
      ( v20359(VarCurr)
    <=> ( v20360(VarCurr)
        & v20363(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5513,axiom,
    ! [VarCurr] :
      ( v20363(VarCurr)
    <=> ( v20339(VarCurr)
        | v20344(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5512,axiom,
    ! [VarCurr] :
      ( v20360(VarCurr)
    <=> ( v20361(VarCurr)
        | v20362(VarCurr) ) ) ).

fof(writeUnaryOperator_1760,axiom,
    ! [VarCurr] :
      ( ~ v20362(VarCurr)
    <=> v20344(VarCurr) ) ).

fof(writeUnaryOperator_1759,axiom,
    ! [VarCurr] :
      ( ~ v20361(VarCurr)
    <=> v20339(VarCurr) ) ).

fof(writeUnaryOperator_1758,axiom,
    ! [VarCurr] :
      ( ~ v20289(VarCurr)
    <=> v20290(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5511,axiom,
    ! [VarCurr] :
      ( v20290(VarCurr)
    <=> ( v20291(VarCurr)
        & v20356(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5510,axiom,
    ! [VarCurr] :
      ( v20356(VarCurr)
    <=> ( v20293(VarCurr)
        | v20338(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5509,axiom,
    ! [VarCurr] :
      ( v20291(VarCurr)
    <=> ( v20292(VarCurr)
        | v20337(VarCurr) ) ) ).

fof(writeUnaryOperator_1757,axiom,
    ! [VarCurr] :
      ( ~ v20337(VarCurr)
    <=> v20338(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5508,axiom,
    ! [VarCurr] :
      ( v20338(VarCurr)
    <=> ( v20339(VarCurr)
        & v20344(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5507,axiom,
    ! [VarCurr] :
      ( v20344(VarCurr)
    <=> ( v20345(VarCurr)
        & v20350(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1732,axiom,
    ! [VarCurr] :
      ( v20350(VarCurr)
    <=> ( v20351(VarCurr)
        & v6(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5506,axiom,
    ! [VarCurr] :
      ( v20351(VarCurr)
    <=> ( v20352(VarCurr)
        & v20355(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1731,axiom,
    ! [VarCurr] :
      ( v20355(VarCurr)
    <=> ( v20331(VarCurr)
        | v6(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5505,axiom,
    ! [VarCurr] :
      ( v20352(VarCurr)
    <=> ( v20353(VarCurr)
        | v20354(VarCurr) ) ) ).

fof(writeUnaryOperator_1756,axiom,
    ! [VarCurr] :
      ( ~ v20354(VarCurr)
    <=> v6(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_1755,axiom,
    ! [VarCurr] :
      ( ~ v20353(VarCurr)
    <=> v20331(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5504,axiom,
    ! [VarCurr] :
      ( v20345(VarCurr)
    <=> ( v20346(VarCurr)
        & v20349(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5503,axiom,
    ! [VarCurr] :
      ( v20349(VarCurr)
    <=> ( v20325(VarCurr)
        | v20330(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5502,axiom,
    ! [VarCurr] :
      ( v20346(VarCurr)
    <=> ( v20347(VarCurr)
        | v20348(VarCurr) ) ) ).

fof(writeUnaryOperator_1754,axiom,
    ! [VarCurr] :
      ( ~ v20348(VarCurr)
    <=> v20330(VarCurr) ) ).

fof(writeUnaryOperator_1753,axiom,
    ! [VarCurr] :
      ( ~ v20347(VarCurr)
    <=> v20325(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5501,axiom,
    ! [VarCurr] :
      ( v20339(VarCurr)
    <=> ( v20340(VarCurr)
        & v20343(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5500,axiom,
    ! [VarCurr] :
      ( v20343(VarCurr)
    <=> ( v20319(VarCurr)
        | v20324(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5499,axiom,
    ! [VarCurr] :
      ( v20340(VarCurr)
    <=> ( v20341(VarCurr)
        | v20342(VarCurr) ) ) ).

fof(writeUnaryOperator_1752,axiom,
    ! [VarCurr] :
      ( ~ v20342(VarCurr)
    <=> v20324(VarCurr) ) ).

fof(writeUnaryOperator_1751,axiom,
    ! [VarCurr] :
      ( ~ v20341(VarCurr)
    <=> v20319(VarCurr) ) ).

fof(writeUnaryOperator_1750,axiom,
    ! [VarCurr] :
      ( ~ v20292(VarCurr)
    <=> v20293(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5498,axiom,
    ! [VarCurr] :
      ( v20293(VarCurr)
    <=> ( v20294(VarCurr)
        & v20336(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5497,axiom,
    ! [VarCurr] :
      ( v20336(VarCurr)
    <=> ( v20296(VarCurr)
        | v20318(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5496,axiom,
    ! [VarCurr] :
      ( v20294(VarCurr)
    <=> ( v20295(VarCurr)
        | v20317(VarCurr) ) ) ).

fof(writeUnaryOperator_1749,axiom,
    ! [VarCurr] :
      ( ~ v20317(VarCurr)
    <=> v20318(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5495,axiom,
    ! [VarCurr] :
      ( v20318(VarCurr)
    <=> ( v20319(VarCurr)
        & v20324(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5494,axiom,
    ! [VarCurr] :
      ( v20324(VarCurr)
    <=> ( v20325(VarCurr)
        & v20330(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1730,axiom,
    ! [VarCurr] :
      ( v20330(VarCurr)
    <=> ( v20331(VarCurr)
        & v6(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5493,axiom,
    ! [VarCurr] :
      ( v20331(VarCurr)
    <=> ( v20332(VarCurr)
        & v20335(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1729,axiom,
    ! [VarCurr] :
      ( v20335(VarCurr)
    <=> ( v6(VarCurr,bitIndex3)
        | v20312(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5492,axiom,
    ! [VarCurr] :
      ( v20332(VarCurr)
    <=> ( v20333(VarCurr)
        | v20334(VarCurr) ) ) ).

fof(writeUnaryOperator_1748,axiom,
    ! [VarCurr] :
      ( ~ v20334(VarCurr)
    <=> v20312(VarCurr) ) ).

fof(writeUnaryOperator_1747,axiom,
    ! [VarCurr] :
      ( ~ v20333(VarCurr)
    <=> v6(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5491,axiom,
    ! [VarCurr] :
      ( v20325(VarCurr)
    <=> ( v20326(VarCurr)
        & v20329(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5490,axiom,
    ! [VarCurr] :
      ( v20329(VarCurr)
    <=> ( v20306(VarCurr)
        | v20311(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5489,axiom,
    ! [VarCurr] :
      ( v20326(VarCurr)
    <=> ( v20327(VarCurr)
        | v20328(VarCurr) ) ) ).

fof(writeUnaryOperator_1746,axiom,
    ! [VarCurr] :
      ( ~ v20328(VarCurr)
    <=> v20311(VarCurr) ) ).

fof(writeUnaryOperator_1745,axiom,
    ! [VarCurr] :
      ( ~ v20327(VarCurr)
    <=> v20306(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5488,axiom,
    ! [VarCurr] :
      ( v20319(VarCurr)
    <=> ( v20320(VarCurr)
        & v20323(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5487,axiom,
    ! [VarCurr] :
      ( v20323(VarCurr)
    <=> ( v20297(VarCurr)
        | v20305(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5486,axiom,
    ! [VarCurr] :
      ( v20320(VarCurr)
    <=> ( v20321(VarCurr)
        | v20322(VarCurr) ) ) ).

fof(writeUnaryOperator_1744,axiom,
    ! [VarCurr] :
      ( ~ v20322(VarCurr)
    <=> v20305(VarCurr) ) ).

fof(writeUnaryOperator_1743,axiom,
    ! [VarCurr] :
      ( ~ v20321(VarCurr)
    <=> v20297(VarCurr) ) ).

fof(writeUnaryOperator_1742,axiom,
    ! [VarCurr] :
      ( ~ v20295(VarCurr)
    <=> v20296(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5485,axiom,
    ! [VarCurr] :
      ( v20296(VarCurr)
    <=> ( v20297(VarCurr)
        & v20305(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5484,axiom,
    ! [VarCurr] :
      ( v20305(VarCurr)
    <=> ( v20306(VarCurr)
        & v20311(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1728,axiom,
    ! [VarCurr] :
      ( v20311(VarCurr)
    <=> ( v6(VarCurr,bitIndex3)
        & v20312(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5483,axiom,
    ! [VarCurr] :
      ( v20312(VarCurr)
    <=> ( v20313(VarCurr)
        & v20316(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1727,axiom,
    ! [VarCurr] :
      ( v20316(VarCurr)
    <=> ( v6(VarCurr,bitIndex2)
        | v20300(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5482,axiom,
    ! [VarCurr] :
      ( v20313(VarCurr)
    <=> ( v20314(VarCurr)
        | v20315(VarCurr) ) ) ).

fof(writeUnaryOperator_1741,axiom,
    ! [VarCurr] :
      ( ~ v20315(VarCurr)
    <=> v20300(VarCurr) ) ).

fof(writeUnaryOperator_1740,axiom,
    ! [VarCurr] :
      ( ~ v20314(VarCurr)
    <=> v6(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5481,axiom,
    ! [VarCurr] :
      ( v20306(VarCurr)
    <=> ( v20307(VarCurr)
        & v20310(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5480,axiom,
    ! [VarCurr] :
      ( v20310(VarCurr)
    <=> ( v20298(VarCurr)
        | v20299(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5479,axiom,
    ! [VarCurr] :
      ( v20307(VarCurr)
    <=> ( v20308(VarCurr)
        | v20309(VarCurr) ) ) ).

fof(writeUnaryOperator_1739,axiom,
    ! [VarCurr] :
      ( ~ v20309(VarCurr)
    <=> v20299(VarCurr) ) ).

fof(writeUnaryOperator_1738,axiom,
    ! [VarCurr] :
      ( ~ v20308(VarCurr)
    <=> v20298(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5478,axiom,
    ! [VarCurr] :
      ( v20297(VarCurr)
    <=> ( v20298(VarCurr)
        & v20299(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1726,axiom,
    ! [VarCurr] :
      ( v20299(VarCurr)
    <=> ( v6(VarCurr,bitIndex2)
        & v20300(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5477,axiom,
    ! [VarCurr] :
      ( v20300(VarCurr)
    <=> ( v20301(VarCurr)
        & v20304(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1725,axiom,
    ! [VarCurr] :
      ( v20304(VarCurr)
    <=> ( v6(VarCurr,bitIndex1)
        | v6(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5476,axiom,
    ! [VarCurr] :
      ( v20301(VarCurr)
    <=> ( v20302(VarCurr)
        | v20303(VarCurr) ) ) ).

fof(writeUnaryOperator_1737,axiom,
    ! [VarCurr] :
      ( ~ v20303(VarCurr)
    <=> v6(VarCurr,bitIndex0) ) ).

fof(writeUnaryOperator_1736,axiom,
    ! [VarCurr] :
      ( ~ v20302(VarCurr)
    <=> v6(VarCurr,bitIndex1) ) ).

fof(writeBinaryOperatorShiftedRanges_1724,axiom,
    ! [VarCurr] :
      ( v20298(VarCurr)
    <=> ( v6(VarCurr,bitIndex1)
        & v6(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_3167,axiom,
    ! [VarCurr,B] :
      ( range_8_0(B)
     => ( v6(VarCurr,B)
      <=> v8(VarCurr,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_181,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v20261(VarNext)
       => ! [B] :
            ( range_8_0(B)
           => ( v8(VarNext,B)
            <=> v8(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_748,axiom,
    ! [VarNext] :
      ( v20261(VarNext)
     => ! [B] :
          ( range_8_0(B)
         => ( v8(VarNext,B)
          <=> v20271(VarNext,B) ) ) ) ).

fof(addAssignment_3166,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_8_0(B)
         => ( v20271(VarNext,B)
          <=> v20269(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_201,axiom,
    ! [VarCurr] :
      ( ~ v10(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v20269(VarCurr,B)
          <=> v322(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_219,axiom,
    ! [VarCurr] :
      ( v10(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v20269(VarCurr,B)
          <=> b000000001(B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5475,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v20261(VarNext)
      <=> v20262(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5474,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v20262(VarNext)
      <=> ( v20263(VarNext)
          & v20258(VarNext) ) ) ) ).

fof(writeUnaryOperator_1735,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v20263(VarNext)
      <=> v20265(VarNext) ) ) ).

fof(addAssignment_3165,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v20265(VarNext)
      <=> v20258(VarCurr) ) ) ).

fof(addAssignmentInitValue_88,axiom,
    ~ v8(constB0,bitIndex8) ).

fof(addAssignmentInitValue_87,axiom,
    ~ v8(constB0,bitIndex7) ).

fof(addAssignmentInitValue_86,axiom,
    ~ v8(constB0,bitIndex6) ).

fof(addAssignmentInitValue_85,axiom,
    ~ v8(constB0,bitIndex5) ).

fof(addAssignmentInitValue_84,axiom,
    ~ v8(constB0,bitIndex4) ).

fof(addAssignmentInitValue_83,axiom,
    ~ v8(constB0,bitIndex3) ).

fof(addAssignmentInitValue_82,axiom,
    ~ v8(constB0,bitIndex2) ).

fof(addAssignmentInitValue_81,axiom,
    ~ v8(constB0,bitIndex1) ).

fof(addAssignmentInitValue_80,axiom,
    v8(constB0,bitIndex0) ).

fof(addAssignment_3164,axiom,
    ! [VarCurr] :
      ( v20258(VarCurr)
    <=> v441(VarCurr) ) ).

fof(addAssignment_3163,axiom,
    ! [VarCurr,B] :
      ( range_8_0(B)
     => ( v322(VarCurr,B)
      <=> v324(VarCurr,B) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges10_5,axiom,
    ! [VarCurr] :
      ( ( ~ v12764(VarCurr)
        & ~ v12751(VarCurr)
        & ~ v12752(VarCurr)
        & ~ v12753(VarCurr)
        & ~ v12765(VarCurr)
        & ~ v12766(VarCurr)
        & ~ v12767(VarCurr)
        & ~ v12768(VarCurr)
        & ~ v12769(VarCurr)
        & ~ v12770(VarCurr) )
     => ! [B] :
          ( range_8_0(B)
         => ( v324(VarCurr,B)
          <=> b000000001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges9_6,axiom,
    ! [VarCurr] :
      ( v12770(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v324(VarCurr,B)
          <=> b010000000(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges8_8,axiom,
    ! [VarCurr] :
      ( v12769(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v324(VarCurr,B)
          <=> b000000001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges7_7,axiom,
    ! [VarCurr] :
      ( v12768(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v324(VarCurr,B)
          <=> v20256(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges6_7,axiom,
    ! [VarCurr] :
      ( v12767(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v324(VarCurr,B)
          <=> b001110000(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges5_7,axiom,
    ! [VarCurr] :
      ( v12766(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v324(VarCurr,B)
          <=> b001100000(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_14,axiom,
    ! [VarCurr] :
      ( v12765(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v324(VarCurr,B)
          <=> v20255(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_15,axiom,
    ! [VarCurr] :
      ( v12753(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v324(VarCurr,B)
          <=> v20253(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_29,axiom,
    ! [VarCurr] :
      ( v12752(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v324(VarCurr,B)
          <=> v20248(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_40,axiom,
    ! [VarCurr] :
      ( v12751(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v324(VarCurr,B)
          <=> v20244(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_43,axiom,
    ! [VarCurr] :
      ( v12764(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v324(VarCurr,B)
          <=> v20243(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_200,axiom,
    ! [VarCurr] :
      ( ~ v7861(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v20256(VarCurr,B)
          <=> b010000000(B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_218,axiom,
    ! [VarCurr] :
      ( v7861(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v20256(VarCurr,B)
          <=> b100000000(B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_199,axiom,
    ! [VarCurr] :
      ( ~ v20240(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v20255(VarCurr,B)
          <=> b001000000(B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_217,axiom,
    ! [VarCurr] :
      ( v20240(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v20255(VarCurr,B)
          <=> b001010000(B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_198,axiom,
    ! [VarCurr] :
      ( ~ v20228(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v20253(VarCurr,B)
          <=> v20254(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_216,axiom,
    ! [VarCurr] :
      ( v20228(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v20253(VarCurr,B)
          <=> b001010000(B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_197,axiom,
    ! [VarCurr] :
      ( ~ v20235(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v20254(VarCurr,B)
          <=> b000001000(B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_215,axiom,
    ! [VarCurr] :
      ( v20235(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v20254(VarCurr,B)
          <=> b001000000(B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_196,axiom,
    ! [VarCurr] :
      ( ~ v20249(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v20248(VarCurr,B)
          <=> v20250(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_214,axiom,
    ! [VarCurr] :
      ( v20249(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v20248(VarCurr,B)
          <=> b010000000(B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_195,axiom,
    ! [VarCurr] :
      ( ~ v20211(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v20250(VarCurr,B)
          <=> v20251(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_213,axiom,
    ! [VarCurr] :
      ( v20211(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v20250(VarCurr,B)
          <=> b001000000(B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_194,axiom,
    ! [VarCurr] :
      ( ~ v20225(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v20251(VarCurr,B)
          <=> v20252(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_212,axiom,
    ! [VarCurr] :
      ( v20225(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v20251(VarCurr,B)
          <=> b001010000(B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_193,axiom,
    ! [VarCurr] :
      ( ~ v338(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v20252(VarCurr,B)
          <=> b000000100(B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_211,axiom,
    ! [VarCurr] :
      ( v338(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v20252(VarCurr,B)
          <=> b000001000(B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5473,axiom,
    ! [VarCurr] :
      ( v20249(VarCurr)
    <=> ( v12724(VarCurr)
        | v19914(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_192,axiom,
    ! [VarCurr] :
      ( ~ v7751(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v20244(VarCurr,B)
          <=> v20245(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_210,axiom,
    ! [VarCurr] :
      ( v7751(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v20244(VarCurr,B)
          <=> b010000000(B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_191,axiom,
    ! [VarCurr] :
      ( ~ v12724(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v20245(VarCurr,B)
          <=> v20246(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_209,axiom,
    ! [VarCurr] :
      ( v12724(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v20245(VarCurr,B)
          <=> b010000000(B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_190,axiom,
    ! [VarCurr] :
      ( ~ v19416(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v20246(VarCurr,B)
          <=> v20247(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_208,axiom,
    ! [VarCurr] :
      ( v19416(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v20246(VarCurr,B)
          <=> b001000000(B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_189,axiom,
    ! [VarCurr] :
      ( ~ v338(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v20247(VarCurr,B)
          <=> b000000010(B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_207,axiom,
    ! [VarCurr] :
      ( v338(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v20247(VarCurr,B)
          <=> b000000100(B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_188,axiom,
    ! [VarCurr] :
      ( ~ v326(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v20243(VarCurr,B)
          <=> b000000001(B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_206,axiom,
    ! [VarCurr] :
      ( v326(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v20243(VarCurr,B)
          <=> b000000010(B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5472,axiom,
    ! [VarCurr] :
      ( v20240(VarCurr)
    <=> ( v338(VarCurr)
        | v12706(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5471,axiom,
    ! [VarCurr] :
      ( v20235(VarCurr)
    <=> ( v20237(VarCurr)
        | v12724(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5470,axiom,
    ! [VarCurr] :
      ( v20237(VarCurr)
    <=> ( v338(VarCurr)
        & v20238(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5469,axiom,
    ! [VarCurr] :
      ( v20238(VarCurr)
    <=> ( v19903(VarCurr)
        | v20213(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5468,axiom,
    ! [VarCurr] :
      ( v20228(VarCurr)
    <=> ( v338(VarCurr)
        & v20230(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1723,axiom,
    ! [VarCurr] :
      ( v20230(VarCurr)
    <=> ( v20231(VarCurr)
        | v7857(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5467,axiom,
    ! [VarCurr] :
      ( v20231(VarCurr)
    <=> ( v20232(VarCurr)
        & v20233(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_1356,axiom,
    ! [VarCurr] :
      ( v20233(VarCurr)
    <=> ( ( v12796(VarCurr,bitIndex3)
        <=> $false )
        & ( v12796(VarCurr,bitIndex2)
        <=> $false )
        & ( v12796(VarCurr,bitIndex1)
        <=> $false )
        & ( v12796(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5466,axiom,
    ! [VarCurr] :
      ( v20232(VarCurr)
    <=> ( v19418(VarCurr)
        & v19903(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1722,axiom,
    ! [VarCurr] :
      ( v20225(VarCurr)
    <=> ( v338(VarCurr)
        & v7857(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5465,axiom,
    ! [VarCurr] :
      ( v20211(VarCurr)
    <=> ( v338(VarCurr)
        & v20222(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5464,axiom,
    ! [VarCurr] :
      ( v20222(VarCurr)
    <=> ( v20223(VarCurr)
        | v20213(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5463,axiom,
    ! [VarCurr] :
      ( v20223(VarCurr)
    <=> ( v19418(VarCurr)
        & v19903(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5462,axiom,
    ! [VarCurr] :
      ( v20213(VarCurr)
    <=> ( v20218(VarCurr)
        & v12808(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5461,axiom,
    ! [VarCurr] :
      ( v20218(VarCurr)
    <=> ( v20219(VarCurr)
        & v20220(VarCurr) ) ) ).

fof(writeUnaryOperator_1734,axiom,
    ! [VarCurr] :
      ( ~ v20220(VarCurr)
    <=> v7857(VarCurr,bitIndex2) ) ).

fof(addBitVectorEqualityBitBlasted_1355,axiom,
    ! [VarCurr] :
      ( v20219(VarCurr)
    <=> ( ( v20215(VarCurr,bitIndex12)
        <=> v12868(VarCurr,bitIndex12) )
        & ( v20215(VarCurr,bitIndex11)
        <=> v12868(VarCurr,bitIndex11) )
        & ( v20215(VarCurr,bitIndex10)
        <=> v12868(VarCurr,bitIndex10) )
        & ( v20215(VarCurr,bitIndex9)
        <=> v12868(VarCurr,bitIndex9) )
        & ( v20215(VarCurr,bitIndex8)
        <=> v12868(VarCurr,bitIndex8) )
        & ( v20215(VarCurr,bitIndex7)
        <=> v12868(VarCurr,bitIndex7) )
        & ( v20215(VarCurr,bitIndex6)
        <=> v12868(VarCurr,bitIndex6) )
        & ( v20215(VarCurr,bitIndex5)
        <=> v12868(VarCurr,bitIndex5) )
        & ( v20215(VarCurr,bitIndex4)
        <=> v12868(VarCurr,bitIndex4) )
        & ( v20215(VarCurr,bitIndex3)
        <=> v12868(VarCurr,bitIndex3) )
        & ( v20215(VarCurr,bitIndex2)
        <=> v12868(VarCurr,bitIndex2) )
        & ( v20215(VarCurr,bitIndex1)
        <=> v12868(VarCurr,bitIndex1) )
        & ( v20215(VarCurr,bitIndex0)
        <=> v12868(VarCurr,bitIndex0) ) ) ) ).

fof(addAssignment_3162,axiom,
    ! [VarCurr] :
      ( v7857(VarCurr,bitIndex2)
    <=> v7859(VarCurr,bitIndex2) ) ).

fof(addAssignment_3161,axiom,
    ! [VarCurr] :
      ( v7859(VarCurr,bitIndex2)
    <=> v14000(VarCurr,bitIndex2) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_20,axiom,
    ! [VarCurr] :
      ( ~ v12808(VarCurr)
     => ( ( v20215(VarCurr,bitIndex12)
        <=> v12798(VarCurr,bitIndex16) )
        & ( v20215(VarCurr,bitIndex11)
        <=> v12798(VarCurr,bitIndex15) )
        & ( v20215(VarCurr,bitIndex10)
        <=> v12798(VarCurr,bitIndex14) )
        & ( v20215(VarCurr,bitIndex9)
        <=> v12798(VarCurr,bitIndex13) )
        & ( v20215(VarCurr,bitIndex8)
        <=> v12798(VarCurr,bitIndex12) )
        & ( v20215(VarCurr,bitIndex7)
        <=> v12798(VarCurr,bitIndex11) )
        & ( v20215(VarCurr,bitIndex6)
        <=> v12798(VarCurr,bitIndex10) )
        & ( v20215(VarCurr,bitIndex5)
        <=> v12798(VarCurr,bitIndex9) )
        & ( v20215(VarCurr,bitIndex4)
        <=> v12798(VarCurr,bitIndex8) )
        & ( v20215(VarCurr,bitIndex3)
        <=> v12798(VarCurr,bitIndex7) )
        & ( v20215(VarCurr,bitIndex2)
        <=> v12798(VarCurr,bitIndex6) )
        & ( v20215(VarCurr,bitIndex1)
        <=> v12798(VarCurr,bitIndex5) )
        & ( v20215(VarCurr,bitIndex0)
        <=> v12798(VarCurr,bitIndex4) ) ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_2,axiom,
    ! [VarCurr] :
      ( v12808(VarCurr)
     => ( ( v20215(VarCurr,bitIndex12)
        <=> v18497(VarCurr,bitIndex16) )
        & ( v20215(VarCurr,bitIndex11)
        <=> v18497(VarCurr,bitIndex15) )
        & ( v20215(VarCurr,bitIndex10)
        <=> v18497(VarCurr,bitIndex14) )
        & ( v20215(VarCurr,bitIndex9)
        <=> v18497(VarCurr,bitIndex13) )
        & ( v20215(VarCurr,bitIndex8)
        <=> v18497(VarCurr,bitIndex12) )
        & ( v20215(VarCurr,bitIndex7)
        <=> v18497(VarCurr,bitIndex11) )
        & ( v20215(VarCurr,bitIndex6)
        <=> v18497(VarCurr,bitIndex10) )
        & ( v20215(VarCurr,bitIndex5)
        <=> v18497(VarCurr,bitIndex9) )
        & ( v20215(VarCurr,bitIndex4)
        <=> v18497(VarCurr,bitIndex8) )
        & ( v20215(VarCurr,bitIndex3)
        <=> v18497(VarCurr,bitIndex7) )
        & ( v20215(VarCurr,bitIndex2)
        <=> v18497(VarCurr,bitIndex6) )
        & ( v20215(VarCurr,bitIndex1)
        <=> v18497(VarCurr,bitIndex5) )
        & ( v20215(VarCurr,bitIndex0)
        <=> v18497(VarCurr,bitIndex4) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5460,axiom,
    ! [VarCurr] :
      ( v19914(VarCurr)
    <=> ( v19967(VarCurr)
        | v20079(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5459,axiom,
    ! [VarCurr] :
      ( v20079(VarCurr)
    <=> ( v20081(VarCurr)
        | v20209(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1721,axiom,
    ! [VarCurr] :
      ( v20209(VarCurr)
    <=> ( v18793(VarCurr,bitIndex16)
        & v20207(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5458,axiom,
    ! [VarCurr] :
      ( v20081(VarCurr)
    <=> ( v20082(VarCurr)
        & v20204(VarCurr) ) ) ).

fof(writeUnaryOperator_1733,axiom,
    ! [VarCurr] :
      ( ~ v20204(VarCurr)
    <=> v20205(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5457,axiom,
    ! [VarCurr] :
      ( v20205(VarCurr)
    <=> ( v20206(VarCurr)
        & v20208(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1720,axiom,
    ! [VarCurr] :
      ( v20208(VarCurr)
    <=> ( v18793(VarCurr,bitIndex16)
        | v19916(VarCurr,bitIndex16) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5456,axiom,
    ! [VarCurr] :
      ( v20206(VarCurr)
    <=> ( v20009(VarCurr)
        | v20207(VarCurr) ) ) ).

fof(writeUnaryOperator_1732,axiom,
    ! [VarCurr] :
      ( ~ v20207(VarCurr)
    <=> v19916(VarCurr,bitIndex16) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5455,axiom,
    ! [VarCurr] :
      ( v20082(VarCurr)
    <=> ( v20083(VarCurr)
        | v20203(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1719,axiom,
    ! [VarCurr] :
      ( v20203(VarCurr)
    <=> ( v18793(VarCurr,bitIndex15)
        & v20201(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5454,axiom,
    ! [VarCurr] :
      ( v20083(VarCurr)
    <=> ( v20084(VarCurr)
        & v20198(VarCurr) ) ) ).

fof(writeUnaryOperator_1731,axiom,
    ! [VarCurr] :
      ( ~ v20198(VarCurr)
    <=> v20199(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5453,axiom,
    ! [VarCurr] :
      ( v20199(VarCurr)
    <=> ( v20200(VarCurr)
        & v20202(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1718,axiom,
    ! [VarCurr] :
      ( v20202(VarCurr)
    <=> ( v18793(VarCurr,bitIndex15)
        | v19916(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5452,axiom,
    ! [VarCurr] :
      ( v20200(VarCurr)
    <=> ( v20008(VarCurr)
        | v20201(VarCurr) ) ) ).

fof(writeUnaryOperator_1730,axiom,
    ! [VarCurr] :
      ( ~ v20201(VarCurr)
    <=> v19916(VarCurr,bitIndex15) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5451,axiom,
    ! [VarCurr] :
      ( v20084(VarCurr)
    <=> ( v20085(VarCurr)
        | v20197(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1717,axiom,
    ! [VarCurr] :
      ( v20197(VarCurr)
    <=> ( v18793(VarCurr,bitIndex14)
        & v20195(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5450,axiom,
    ! [VarCurr] :
      ( v20085(VarCurr)
    <=> ( v20086(VarCurr)
        & v20192(VarCurr) ) ) ).

fof(writeUnaryOperator_1729,axiom,
    ! [VarCurr] :
      ( ~ v20192(VarCurr)
    <=> v20193(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5449,axiom,
    ! [VarCurr] :
      ( v20193(VarCurr)
    <=> ( v20194(VarCurr)
        & v20196(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1716,axiom,
    ! [VarCurr] :
      ( v20196(VarCurr)
    <=> ( v18793(VarCurr,bitIndex14)
        | v19916(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5448,axiom,
    ! [VarCurr] :
      ( v20194(VarCurr)
    <=> ( v20007(VarCurr)
        | v20195(VarCurr) ) ) ).

fof(writeUnaryOperator_1728,axiom,
    ! [VarCurr] :
      ( ~ v20195(VarCurr)
    <=> v19916(VarCurr,bitIndex14) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5447,axiom,
    ! [VarCurr] :
      ( v20086(VarCurr)
    <=> ( v20087(VarCurr)
        | v20191(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1715,axiom,
    ! [VarCurr] :
      ( v20191(VarCurr)
    <=> ( v18793(VarCurr,bitIndex13)
        & v20189(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5446,axiom,
    ! [VarCurr] :
      ( v20087(VarCurr)
    <=> ( v20088(VarCurr)
        & v20186(VarCurr) ) ) ).

fof(writeUnaryOperator_1727,axiom,
    ! [VarCurr] :
      ( ~ v20186(VarCurr)
    <=> v20187(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5445,axiom,
    ! [VarCurr] :
      ( v20187(VarCurr)
    <=> ( v20188(VarCurr)
        & v20190(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1714,axiom,
    ! [VarCurr] :
      ( v20190(VarCurr)
    <=> ( v18793(VarCurr,bitIndex13)
        | v19916(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5444,axiom,
    ! [VarCurr] :
      ( v20188(VarCurr)
    <=> ( v20006(VarCurr)
        | v20189(VarCurr) ) ) ).

fof(writeUnaryOperator_1726,axiom,
    ! [VarCurr] :
      ( ~ v20189(VarCurr)
    <=> v19916(VarCurr,bitIndex13) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5443,axiom,
    ! [VarCurr] :
      ( v20088(VarCurr)
    <=> ( v20089(VarCurr)
        | v20185(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1713,axiom,
    ! [VarCurr] :
      ( v20185(VarCurr)
    <=> ( v18793(VarCurr,bitIndex12)
        & v20183(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5442,axiom,
    ! [VarCurr] :
      ( v20089(VarCurr)
    <=> ( v20090(VarCurr)
        & v20180(VarCurr) ) ) ).

fof(writeUnaryOperator_1725,axiom,
    ! [VarCurr] :
      ( ~ v20180(VarCurr)
    <=> v20181(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5441,axiom,
    ! [VarCurr] :
      ( v20181(VarCurr)
    <=> ( v20182(VarCurr)
        & v20184(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1712,axiom,
    ! [VarCurr] :
      ( v20184(VarCurr)
    <=> ( v18793(VarCurr,bitIndex12)
        | v19916(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5440,axiom,
    ! [VarCurr] :
      ( v20182(VarCurr)
    <=> ( v20005(VarCurr)
        | v20183(VarCurr) ) ) ).

fof(writeUnaryOperator_1724,axiom,
    ! [VarCurr] :
      ( ~ v20183(VarCurr)
    <=> v19916(VarCurr,bitIndex12) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5439,axiom,
    ! [VarCurr] :
      ( v20090(VarCurr)
    <=> ( v20091(VarCurr)
        | v20179(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1711,axiom,
    ! [VarCurr] :
      ( v20179(VarCurr)
    <=> ( v18793(VarCurr,bitIndex11)
        & v20177(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5438,axiom,
    ! [VarCurr] :
      ( v20091(VarCurr)
    <=> ( v20092(VarCurr)
        & v20174(VarCurr) ) ) ).

fof(writeUnaryOperator_1723,axiom,
    ! [VarCurr] :
      ( ~ v20174(VarCurr)
    <=> v20175(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5437,axiom,
    ! [VarCurr] :
      ( v20175(VarCurr)
    <=> ( v20176(VarCurr)
        & v20178(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1710,axiom,
    ! [VarCurr] :
      ( v20178(VarCurr)
    <=> ( v18793(VarCurr,bitIndex11)
        | v19916(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5436,axiom,
    ! [VarCurr] :
      ( v20176(VarCurr)
    <=> ( v20004(VarCurr)
        | v20177(VarCurr) ) ) ).

fof(writeUnaryOperator_1722,axiom,
    ! [VarCurr] :
      ( ~ v20177(VarCurr)
    <=> v19916(VarCurr,bitIndex11) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5435,axiom,
    ! [VarCurr] :
      ( v20092(VarCurr)
    <=> ( v20093(VarCurr)
        | v20173(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1709,axiom,
    ! [VarCurr] :
      ( v20173(VarCurr)
    <=> ( v18793(VarCurr,bitIndex10)
        & v20171(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5434,axiom,
    ! [VarCurr] :
      ( v20093(VarCurr)
    <=> ( v20094(VarCurr)
        & v20168(VarCurr) ) ) ).

fof(writeUnaryOperator_1721,axiom,
    ! [VarCurr] :
      ( ~ v20168(VarCurr)
    <=> v20169(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5433,axiom,
    ! [VarCurr] :
      ( v20169(VarCurr)
    <=> ( v20170(VarCurr)
        & v20172(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1708,axiom,
    ! [VarCurr] :
      ( v20172(VarCurr)
    <=> ( v18793(VarCurr,bitIndex10)
        | v19916(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5432,axiom,
    ! [VarCurr] :
      ( v20170(VarCurr)
    <=> ( v20003(VarCurr)
        | v20171(VarCurr) ) ) ).

fof(writeUnaryOperator_1720,axiom,
    ! [VarCurr] :
      ( ~ v20171(VarCurr)
    <=> v19916(VarCurr,bitIndex10) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5431,axiom,
    ! [VarCurr] :
      ( v20094(VarCurr)
    <=> ( v20095(VarCurr)
        | v20167(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1707,axiom,
    ! [VarCurr] :
      ( v20167(VarCurr)
    <=> ( v18793(VarCurr,bitIndex9)
        & v20165(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5430,axiom,
    ! [VarCurr] :
      ( v20095(VarCurr)
    <=> ( v20096(VarCurr)
        & v20162(VarCurr) ) ) ).

fof(writeUnaryOperator_1719,axiom,
    ! [VarCurr] :
      ( ~ v20162(VarCurr)
    <=> v20163(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5429,axiom,
    ! [VarCurr] :
      ( v20163(VarCurr)
    <=> ( v20164(VarCurr)
        & v20166(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1706,axiom,
    ! [VarCurr] :
      ( v20166(VarCurr)
    <=> ( v18793(VarCurr,bitIndex9)
        | v19916(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5428,axiom,
    ! [VarCurr] :
      ( v20164(VarCurr)
    <=> ( v20002(VarCurr)
        | v20165(VarCurr) ) ) ).

fof(writeUnaryOperator_1718,axiom,
    ! [VarCurr] :
      ( ~ v20165(VarCurr)
    <=> v19916(VarCurr,bitIndex9) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5427,axiom,
    ! [VarCurr] :
      ( v20096(VarCurr)
    <=> ( v20097(VarCurr)
        | v20161(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1705,axiom,
    ! [VarCurr] :
      ( v20161(VarCurr)
    <=> ( v18793(VarCurr,bitIndex8)
        & v20159(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5426,axiom,
    ! [VarCurr] :
      ( v20097(VarCurr)
    <=> ( v20098(VarCurr)
        & v20156(VarCurr) ) ) ).

fof(writeUnaryOperator_1717,axiom,
    ! [VarCurr] :
      ( ~ v20156(VarCurr)
    <=> v20157(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5425,axiom,
    ! [VarCurr] :
      ( v20157(VarCurr)
    <=> ( v20158(VarCurr)
        & v20160(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1704,axiom,
    ! [VarCurr] :
      ( v20160(VarCurr)
    <=> ( v18793(VarCurr,bitIndex8)
        | v19916(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5424,axiom,
    ! [VarCurr] :
      ( v20158(VarCurr)
    <=> ( v20001(VarCurr)
        | v20159(VarCurr) ) ) ).

fof(writeUnaryOperator_1716,axiom,
    ! [VarCurr] :
      ( ~ v20159(VarCurr)
    <=> v19916(VarCurr,bitIndex8) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5423,axiom,
    ! [VarCurr] :
      ( v20098(VarCurr)
    <=> ( v20099(VarCurr)
        | v20155(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1703,axiom,
    ! [VarCurr] :
      ( v20155(VarCurr)
    <=> ( v18793(VarCurr,bitIndex7)
        & v20153(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5422,axiom,
    ! [VarCurr] :
      ( v20099(VarCurr)
    <=> ( v20100(VarCurr)
        & v20150(VarCurr) ) ) ).

fof(writeUnaryOperator_1715,axiom,
    ! [VarCurr] :
      ( ~ v20150(VarCurr)
    <=> v20151(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5421,axiom,
    ! [VarCurr] :
      ( v20151(VarCurr)
    <=> ( v20152(VarCurr)
        & v20154(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1702,axiom,
    ! [VarCurr] :
      ( v20154(VarCurr)
    <=> ( v18793(VarCurr,bitIndex7)
        | v19916(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5420,axiom,
    ! [VarCurr] :
      ( v20152(VarCurr)
    <=> ( v20000(VarCurr)
        | v20153(VarCurr) ) ) ).

fof(writeUnaryOperator_1714,axiom,
    ! [VarCurr] :
      ( ~ v20153(VarCurr)
    <=> v19916(VarCurr,bitIndex7) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5419,axiom,
    ! [VarCurr] :
      ( v20100(VarCurr)
    <=> ( v20101(VarCurr)
        | v20149(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1701,axiom,
    ! [VarCurr] :
      ( v20149(VarCurr)
    <=> ( v18793(VarCurr,bitIndex6)
        & v20147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5418,axiom,
    ! [VarCurr] :
      ( v20101(VarCurr)
    <=> ( v20102(VarCurr)
        & v20144(VarCurr) ) ) ).

fof(writeUnaryOperator_1713,axiom,
    ! [VarCurr] :
      ( ~ v20144(VarCurr)
    <=> v20145(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5417,axiom,
    ! [VarCurr] :
      ( v20145(VarCurr)
    <=> ( v20146(VarCurr)
        & v20148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1700,axiom,
    ! [VarCurr] :
      ( v20148(VarCurr)
    <=> ( v18793(VarCurr,bitIndex6)
        | v19916(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5416,axiom,
    ! [VarCurr] :
      ( v20146(VarCurr)
    <=> ( v19999(VarCurr)
        | v20147(VarCurr) ) ) ).

fof(writeUnaryOperator_1712,axiom,
    ! [VarCurr] :
      ( ~ v20147(VarCurr)
    <=> v19916(VarCurr,bitIndex6) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5415,axiom,
    ! [VarCurr] :
      ( v20102(VarCurr)
    <=> ( v20103(VarCurr)
        | v20143(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1699,axiom,
    ! [VarCurr] :
      ( v20143(VarCurr)
    <=> ( v18793(VarCurr,bitIndex5)
        & v20141(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5414,axiom,
    ! [VarCurr] :
      ( v20103(VarCurr)
    <=> ( v20104(VarCurr)
        & v20138(VarCurr) ) ) ).

fof(writeUnaryOperator_1711,axiom,
    ! [VarCurr] :
      ( ~ v20138(VarCurr)
    <=> v20139(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5413,axiom,
    ! [VarCurr] :
      ( v20139(VarCurr)
    <=> ( v20140(VarCurr)
        & v20142(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1698,axiom,
    ! [VarCurr] :
      ( v20142(VarCurr)
    <=> ( v18793(VarCurr,bitIndex5)
        | v19916(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5412,axiom,
    ! [VarCurr] :
      ( v20140(VarCurr)
    <=> ( v19988(VarCurr)
        | v20141(VarCurr) ) ) ).

fof(writeUnaryOperator_1710,axiom,
    ! [VarCurr] :
      ( ~ v20141(VarCurr)
    <=> v19916(VarCurr,bitIndex5) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5411,axiom,
    ! [VarCurr] :
      ( v20104(VarCurr)
    <=> ( v20105(VarCurr)
        | v20137(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1697,axiom,
    ! [VarCurr] :
      ( v20137(VarCurr)
    <=> ( v18793(VarCurr,bitIndex4)
        & v20135(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5410,axiom,
    ! [VarCurr] :
      ( v20105(VarCurr)
    <=> ( v20106(VarCurr)
        & v20132(VarCurr) ) ) ).

fof(writeUnaryOperator_1709,axiom,
    ! [VarCurr] :
      ( ~ v20132(VarCurr)
    <=> v20133(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5409,axiom,
    ! [VarCurr] :
      ( v20133(VarCurr)
    <=> ( v20134(VarCurr)
        & v20136(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1696,axiom,
    ! [VarCurr] :
      ( v20136(VarCurr)
    <=> ( v18793(VarCurr,bitIndex4)
        | v19916(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5408,axiom,
    ! [VarCurr] :
      ( v20134(VarCurr)
    <=> ( v19991(VarCurr)
        | v20135(VarCurr) ) ) ).

fof(writeUnaryOperator_1708,axiom,
    ! [VarCurr] :
      ( ~ v20135(VarCurr)
    <=> v19916(VarCurr,bitIndex4) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5407,axiom,
    ! [VarCurr] :
      ( v20106(VarCurr)
    <=> ( v20107(VarCurr)
        | v20131(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1695,axiom,
    ! [VarCurr] :
      ( v20131(VarCurr)
    <=> ( v18793(VarCurr,bitIndex3)
        & v20129(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5406,axiom,
    ! [VarCurr] :
      ( v20107(VarCurr)
    <=> ( v20108(VarCurr)
        & v20126(VarCurr) ) ) ).

fof(writeUnaryOperator_1707,axiom,
    ! [VarCurr] :
      ( ~ v20126(VarCurr)
    <=> v20127(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5405,axiom,
    ! [VarCurr] :
      ( v20127(VarCurr)
    <=> ( v20128(VarCurr)
        & v20130(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1694,axiom,
    ! [VarCurr] :
      ( v20130(VarCurr)
    <=> ( v18793(VarCurr,bitIndex3)
        | v19916(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5404,axiom,
    ! [VarCurr] :
      ( v20128(VarCurr)
    <=> ( v19998(VarCurr)
        | v20129(VarCurr) ) ) ).

fof(writeUnaryOperator_1706,axiom,
    ! [VarCurr] :
      ( ~ v20129(VarCurr)
    <=> v19916(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5403,axiom,
    ! [VarCurr] :
      ( v20108(VarCurr)
    <=> ( v20109(VarCurr)
        | v20125(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1693,axiom,
    ! [VarCurr] :
      ( v20125(VarCurr)
    <=> ( v18793(VarCurr,bitIndex2)
        & v20123(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5402,axiom,
    ! [VarCurr] :
      ( v20109(VarCurr)
    <=> ( v20110(VarCurr)
        & v20120(VarCurr) ) ) ).

fof(writeUnaryOperator_1705,axiom,
    ! [VarCurr] :
      ( ~ v20120(VarCurr)
    <=> v20121(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5401,axiom,
    ! [VarCurr] :
      ( v20121(VarCurr)
    <=> ( v20122(VarCurr)
        & v20124(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1692,axiom,
    ! [VarCurr] :
      ( v20124(VarCurr)
    <=> ( v18793(VarCurr,bitIndex2)
        | v19916(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5400,axiom,
    ! [VarCurr] :
      ( v20122(VarCurr)
    <=> ( v19995(VarCurr)
        | v20123(VarCurr) ) ) ).

fof(writeUnaryOperator_1704,axiom,
    ! [VarCurr] :
      ( ~ v20123(VarCurr)
    <=> v19916(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5399,axiom,
    ! [VarCurr] :
      ( v20110(VarCurr)
    <=> ( v20111(VarCurr)
        | v20119(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1691,axiom,
    ! [VarCurr] :
      ( v20119(VarCurr)
    <=> ( v18793(VarCurr,bitIndex1)
        & v20117(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5398,axiom,
    ! [VarCurr] :
      ( v20111(VarCurr)
    <=> ( v20112(VarCurr)
        & v20114(VarCurr) ) ) ).

fof(writeUnaryOperator_1703,axiom,
    ! [VarCurr] :
      ( ~ v20114(VarCurr)
    <=> v20115(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5397,axiom,
    ! [VarCurr] :
      ( v20115(VarCurr)
    <=> ( v20116(VarCurr)
        & v20118(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1690,axiom,
    ! [VarCurr] :
      ( v20118(VarCurr)
    <=> ( v18793(VarCurr,bitIndex1)
        | v19916(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5396,axiom,
    ! [VarCurr] :
      ( v20116(VarCurr)
    <=> ( v19997(VarCurr)
        | v20117(VarCurr) ) ) ).

fof(writeUnaryOperator_1702,axiom,
    ! [VarCurr] :
      ( ~ v20117(VarCurr)
    <=> v19916(VarCurr,bitIndex1) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5395,axiom,
    ! [VarCurr] :
      ( v20112(VarCurr)
    <=> ( v18793(VarCurr,bitIndex0)
        & v20113(VarCurr) ) ) ).

fof(writeUnaryOperator_1701,axiom,
    ! [VarCurr] :
      ( ~ v20113(VarCurr)
    <=> v19916(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5394,axiom,
    ! [VarCurr] :
      ( v19967(VarCurr)
    <=> ( v19968(VarCurr)
        | v20072(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5393,axiom,
    ! [VarCurr] :
      ( v20072(VarCurr)
    <=> ( v20073(VarCurr)
        & v20074(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5392,axiom,
    ! [VarCurr] :
      ( v20074(VarCurr)
    <=> ( v14022(VarCurr)
        & v20076(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5391,axiom,
    ! [VarCurr] :
      ( v20076(VarCurr)
    <=> ( v14439(VarCurr)
        | v20077(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1689,axiom,
    ! [VarCurr] :
      ( v20077(VarCurr)
    <=> ( v12672(VarCurr,bitIndex2)
        & v20078(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5390,axiom,
    ! [VarCurr] :
      ( v20078(VarCurr)
    <=> ( v14260(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_1354,axiom,
    ! [VarCurr] :
      ( v20073(VarCurr)
    <=> ( ( v7803(VarCurr,bitIndex1)
        <=> $false )
        & ( v7803(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5389,axiom,
    ! [VarCurr] :
      ( v19968(VarCurr)
    <=> ( v19969(VarCurr)
        | v20050(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5388,axiom,
    ! [VarCurr] :
      ( v20050(VarCurr)
    <=> ( v20051(VarCurr)
        & v20054(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5387,axiom,
    ! [VarCurr] :
      ( v20054(VarCurr)
    <=> ( v20009(VarCurr)
        & v20056(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5386,axiom,
    ! [VarCurr] :
      ( v20056(VarCurr)
    <=> ( v20008(VarCurr)
        & v20057(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5385,axiom,
    ! [VarCurr] :
      ( v20057(VarCurr)
    <=> ( v20007(VarCurr)
        & v20058(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5384,axiom,
    ! [VarCurr] :
      ( v20058(VarCurr)
    <=> ( v20006(VarCurr)
        & v20059(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5383,axiom,
    ! [VarCurr] :
      ( v20059(VarCurr)
    <=> ( v20005(VarCurr)
        & v20060(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5382,axiom,
    ! [VarCurr] :
      ( v20060(VarCurr)
    <=> ( v20004(VarCurr)
        & v20061(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5381,axiom,
    ! [VarCurr] :
      ( v20061(VarCurr)
    <=> ( v20003(VarCurr)
        & v20062(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5380,axiom,
    ! [VarCurr] :
      ( v20062(VarCurr)
    <=> ( v20002(VarCurr)
        & v20063(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5379,axiom,
    ! [VarCurr] :
      ( v20063(VarCurr)
    <=> ( v20001(VarCurr)
        & v20064(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5378,axiom,
    ! [VarCurr] :
      ( v20064(VarCurr)
    <=> ( v20000(VarCurr)
        & v20065(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5377,axiom,
    ! [VarCurr] :
      ( v20065(VarCurr)
    <=> ( v19999(VarCurr)
        & v20066(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5376,axiom,
    ! [VarCurr] :
      ( v20066(VarCurr)
    <=> ( v19988(VarCurr)
        | v20067(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1688,axiom,
    ! [VarCurr] :
      ( v20067(VarCurr)
    <=> ( v18793(VarCurr,bitIndex5)
        & v20068(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5375,axiom,
    ! [VarCurr] :
      ( v20068(VarCurr)
    <=> ( v19991(VarCurr)
        | v20069(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1687,axiom,
    ! [VarCurr] :
      ( v20069(VarCurr)
    <=> ( v18793(VarCurr,bitIndex4)
        & v20070(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5374,axiom,
    ! [VarCurr] :
      ( v20070(VarCurr)
    <=> ( v19998(VarCurr)
        | v20071(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1686,axiom,
    ! [VarCurr] :
      ( v20071(VarCurr)
    <=> ( v19994(VarCurr)
        & v18793(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5373,axiom,
    ! [VarCurr] :
      ( v20051(VarCurr)
    <=> ( v20052(VarCurr)
        & v20053(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_1353,axiom,
    ! [VarCurr] :
      ( v20053(VarCurr)
    <=> ( ( v7803(VarCurr,bitIndex1)
        <=> $true )
        & ( v7803(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1352,axiom,
    ! [VarCurr] :
      ( v20052(VarCurr)
    <=> ( ( v7753(VarCurr,bitIndex1)
        <=> $true )
        & ( v7753(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5372,axiom,
    ! [VarCurr] :
      ( v19969(VarCurr)
    <=> ( v19970(VarCurr)
        | v20032(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5371,axiom,
    ! [VarCurr] :
      ( v20032(VarCurr)
    <=> ( v20033(VarCurr)
        & v20036(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5370,axiom,
    ! [VarCurr] :
      ( v20036(VarCurr)
    <=> ( v20009(VarCurr)
        & v20038(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5369,axiom,
    ! [VarCurr] :
      ( v20038(VarCurr)
    <=> ( v20008(VarCurr)
        & v20039(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5368,axiom,
    ! [VarCurr] :
      ( v20039(VarCurr)
    <=> ( v20007(VarCurr)
        & v20040(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5367,axiom,
    ! [VarCurr] :
      ( v20040(VarCurr)
    <=> ( v20006(VarCurr)
        & v20041(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5366,axiom,
    ! [VarCurr] :
      ( v20041(VarCurr)
    <=> ( v20005(VarCurr)
        & v20042(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5365,axiom,
    ! [VarCurr] :
      ( v20042(VarCurr)
    <=> ( v20004(VarCurr)
        & v20043(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5364,axiom,
    ! [VarCurr] :
      ( v20043(VarCurr)
    <=> ( v20003(VarCurr)
        & v20044(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5363,axiom,
    ! [VarCurr] :
      ( v20044(VarCurr)
    <=> ( v20002(VarCurr)
        & v20045(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5362,axiom,
    ! [VarCurr] :
      ( v20045(VarCurr)
    <=> ( v20001(VarCurr)
        & v20046(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5361,axiom,
    ! [VarCurr] :
      ( v20046(VarCurr)
    <=> ( v20000(VarCurr)
        & v20047(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5360,axiom,
    ! [VarCurr] :
      ( v20047(VarCurr)
    <=> ( v19999(VarCurr)
        & v20048(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5359,axiom,
    ! [VarCurr] :
      ( v20048(VarCurr)
    <=> ( v19988(VarCurr)
        | v20049(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1685,axiom,
    ! [VarCurr] :
      ( v20049(VarCurr)
    <=> ( v18793(VarCurr,bitIndex5)
        & v20028(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5358,axiom,
    ! [VarCurr] :
      ( v20033(VarCurr)
    <=> ( v20034(VarCurr)
        & v20035(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_1351,axiom,
    ! [VarCurr] :
      ( v20035(VarCurr)
    <=> ( ( v7803(VarCurr,bitIndex1)
        <=> $false )
        & ( v7803(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1350,axiom,
    ! [VarCurr] :
      ( v20034(VarCurr)
    <=> ( ( v7753(VarCurr,bitIndex1)
        <=> $true )
        & ( v7753(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5357,axiom,
    ! [VarCurr] :
      ( v19970(VarCurr)
    <=> ( v19971(VarCurr)
        | v20010(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5356,axiom,
    ! [VarCurr] :
      ( v20010(VarCurr)
    <=> ( v20011(VarCurr)
        & v20014(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5355,axiom,
    ! [VarCurr] :
      ( v20014(VarCurr)
    <=> ( v20009(VarCurr)
        & v20016(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5354,axiom,
    ! [VarCurr] :
      ( v20016(VarCurr)
    <=> ( v20008(VarCurr)
        & v20017(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5353,axiom,
    ! [VarCurr] :
      ( v20017(VarCurr)
    <=> ( v20007(VarCurr)
        & v20018(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5352,axiom,
    ! [VarCurr] :
      ( v20018(VarCurr)
    <=> ( v20006(VarCurr)
        & v20019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5351,axiom,
    ! [VarCurr] :
      ( v20019(VarCurr)
    <=> ( v20005(VarCurr)
        & v20020(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5350,axiom,
    ! [VarCurr] :
      ( v20020(VarCurr)
    <=> ( v20004(VarCurr)
        & v20021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5349,axiom,
    ! [VarCurr] :
      ( v20021(VarCurr)
    <=> ( v20003(VarCurr)
        & v20022(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5348,axiom,
    ! [VarCurr] :
      ( v20022(VarCurr)
    <=> ( v20002(VarCurr)
        & v20023(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5347,axiom,
    ! [VarCurr] :
      ( v20023(VarCurr)
    <=> ( v20001(VarCurr)
        & v20024(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5346,axiom,
    ! [VarCurr] :
      ( v20024(VarCurr)
    <=> ( v20000(VarCurr)
        & v20025(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5345,axiom,
    ! [VarCurr] :
      ( v20025(VarCurr)
    <=> ( v19999(VarCurr)
        | v20026(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1684,axiom,
    ! [VarCurr] :
      ( v20026(VarCurr)
    <=> ( v18793(VarCurr,bitIndex6)
        & v20027(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5344,axiom,
    ! [VarCurr] :
      ( v20027(VarCurr)
    <=> ( v19988(VarCurr)
        & v20028(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5343,axiom,
    ! [VarCurr] :
      ( v20028(VarCurr)
    <=> ( v19991(VarCurr)
        & v20029(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5342,axiom,
    ! [VarCurr] :
      ( v20029(VarCurr)
    <=> ( v19998(VarCurr)
        | v20030(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1683,axiom,
    ! [VarCurr] :
      ( v20030(VarCurr)
    <=> ( v18793(VarCurr,bitIndex3)
        & v20031(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5341,axiom,
    ! [VarCurr] :
      ( v20031(VarCurr)
    <=> ( v19997(VarCurr)
        & v19995(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5340,axiom,
    ! [VarCurr] :
      ( v20011(VarCurr)
    <=> ( v20012(VarCurr)
        & v20013(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_1349,axiom,
    ! [VarCurr] :
      ( v20013(VarCurr)
    <=> ( ( v7803(VarCurr,bitIndex1)
        <=> $true )
        & ( v7803(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1348,axiom,
    ! [VarCurr] :
      ( v20012(VarCurr)
    <=> ( ( v7753(VarCurr,bitIndex1)
        <=> $false )
        & ( v7753(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5339,axiom,
    ! [VarCurr] :
      ( v19971(VarCurr)
    <=> ( v19972(VarCurr)
        & v19975(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5338,axiom,
    ! [VarCurr] :
      ( v19975(VarCurr)
    <=> ( v19977(VarCurr)
        & v20009(VarCurr) ) ) ).

fof(writeUnaryOperator_1700,axiom,
    ! [VarCurr] :
      ( ~ v20009(VarCurr)
    <=> v18793(VarCurr,bitIndex16) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5337,axiom,
    ! [VarCurr] :
      ( v19977(VarCurr)
    <=> ( v19978(VarCurr)
        & v20008(VarCurr) ) ) ).

fof(writeUnaryOperator_1699,axiom,
    ! [VarCurr] :
      ( ~ v20008(VarCurr)
    <=> v18793(VarCurr,bitIndex15) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5336,axiom,
    ! [VarCurr] :
      ( v19978(VarCurr)
    <=> ( v19979(VarCurr)
        & v20007(VarCurr) ) ) ).

fof(writeUnaryOperator_1698,axiom,
    ! [VarCurr] :
      ( ~ v20007(VarCurr)
    <=> v18793(VarCurr,bitIndex14) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5335,axiom,
    ! [VarCurr] :
      ( v19979(VarCurr)
    <=> ( v19980(VarCurr)
        & v20006(VarCurr) ) ) ).

fof(writeUnaryOperator_1697,axiom,
    ! [VarCurr] :
      ( ~ v20006(VarCurr)
    <=> v18793(VarCurr,bitIndex13) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5334,axiom,
    ! [VarCurr] :
      ( v19980(VarCurr)
    <=> ( v19981(VarCurr)
        & v20005(VarCurr) ) ) ).

fof(writeUnaryOperator_1696,axiom,
    ! [VarCurr] :
      ( ~ v20005(VarCurr)
    <=> v18793(VarCurr,bitIndex12) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5333,axiom,
    ! [VarCurr] :
      ( v19981(VarCurr)
    <=> ( v19982(VarCurr)
        & v20004(VarCurr) ) ) ).

fof(writeUnaryOperator_1695,axiom,
    ! [VarCurr] :
      ( ~ v20004(VarCurr)
    <=> v18793(VarCurr,bitIndex11) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5332,axiom,
    ! [VarCurr] :
      ( v19982(VarCurr)
    <=> ( v19983(VarCurr)
        & v20003(VarCurr) ) ) ).

fof(writeUnaryOperator_1694,axiom,
    ! [VarCurr] :
      ( ~ v20003(VarCurr)
    <=> v18793(VarCurr,bitIndex10) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5331,axiom,
    ! [VarCurr] :
      ( v19983(VarCurr)
    <=> ( v19984(VarCurr)
        & v20002(VarCurr) ) ) ).

fof(writeUnaryOperator_1693,axiom,
    ! [VarCurr] :
      ( ~ v20002(VarCurr)
    <=> v18793(VarCurr,bitIndex9) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5330,axiom,
    ! [VarCurr] :
      ( v19984(VarCurr)
    <=> ( v19985(VarCurr)
        & v20001(VarCurr) ) ) ).

fof(writeUnaryOperator_1692,axiom,
    ! [VarCurr] :
      ( ~ v20001(VarCurr)
    <=> v18793(VarCurr,bitIndex8) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5329,axiom,
    ! [VarCurr] :
      ( v19985(VarCurr)
    <=> ( v19986(VarCurr)
        & v20000(VarCurr) ) ) ).

fof(writeUnaryOperator_1691,axiom,
    ! [VarCurr] :
      ( ~ v20000(VarCurr)
    <=> v18793(VarCurr,bitIndex7) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5328,axiom,
    ! [VarCurr] :
      ( v19986(VarCurr)
    <=> ( v19987(VarCurr)
        & v19999(VarCurr) ) ) ).

fof(writeUnaryOperator_1690,axiom,
    ! [VarCurr] :
      ( ~ v19999(VarCurr)
    <=> v18793(VarCurr,bitIndex6) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5327,axiom,
    ! [VarCurr] :
      ( v19987(VarCurr)
    <=> ( v19988(VarCurr)
        | v19989(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1682,axiom,
    ! [VarCurr] :
      ( v19989(VarCurr)
    <=> ( v19990(VarCurr)
        & v18793(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5326,axiom,
    ! [VarCurr] :
      ( v19990(VarCurr)
    <=> ( v19991(VarCurr)
        | v19992(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1681,axiom,
    ! [VarCurr] :
      ( v19992(VarCurr)
    <=> ( v19993(VarCurr)
        & v18793(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5325,axiom,
    ! [VarCurr] :
      ( v19993(VarCurr)
    <=> ( v19994(VarCurr)
        & v19998(VarCurr) ) ) ).

fof(writeUnaryOperator_1689,axiom,
    ! [VarCurr] :
      ( ~ v19998(VarCurr)
    <=> v18793(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5324,axiom,
    ! [VarCurr] :
      ( v19994(VarCurr)
    <=> ( v19995(VarCurr)
        | v19996(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1680,axiom,
    ! [VarCurr] :
      ( v19996(VarCurr)
    <=> ( v19997(VarCurr)
        & v18793(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_1688,axiom,
    ! [VarCurr] :
      ( ~ v19997(VarCurr)
    <=> v18793(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_1687,axiom,
    ! [VarCurr] :
      ( ~ v19995(VarCurr)
    <=> v18793(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_1686,axiom,
    ! [VarCurr] :
      ( ~ v19991(VarCurr)
    <=> v18793(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_1685,axiom,
    ! [VarCurr] :
      ( ~ v19988(VarCurr)
    <=> v18793(VarCurr,bitIndex5) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5323,axiom,
    ! [VarCurr] :
      ( v19972(VarCurr)
    <=> ( v19973(VarCurr)
        & v19974(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_1347,axiom,
    ! [VarCurr] :
      ( v19974(VarCurr)
    <=> ( ( v7803(VarCurr,bitIndex1)
        <=> $false )
        & ( v7803(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1346,axiom,
    ! [VarCurr] :
      ( v19973(VarCurr)
    <=> ( ( v7753(VarCurr,bitIndex1)
        <=> $false )
        & ( v7753(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_3160,axiom,
    ! [VarCurr,B] :
      ( range_16_0(B)
     => ( v19916(VarCurr,B)
      <=> v19918(VarCurr,B) ) ) ).

fof(addAssignment_3159,axiom,
    ! [VarCurr,B] :
      ( range_16_0(B)
     => ( v19918(VarCurr,B)
      <=> v19920(VarCurr,B) ) ) ).

fof(addAssignment_3158,axiom,
    ! [VarCurr] :
      ( ( v19920(VarCurr,bitIndex16)
      <=> v844(VarCurr,bitIndex24) )
      & ( v19920(VarCurr,bitIndex15)
      <=> v844(VarCurr,bitIndex23) )
      & ( v19920(VarCurr,bitIndex14)
      <=> v844(VarCurr,bitIndex22) )
      & ( v19920(VarCurr,bitIndex13)
      <=> v844(VarCurr,bitIndex21) )
      & ( v19920(VarCurr,bitIndex12)
      <=> v844(VarCurr,bitIndex20) )
      & ( v19920(VarCurr,bitIndex11)
      <=> v844(VarCurr,bitIndex19) )
      & ( v19920(VarCurr,bitIndex10)
      <=> v844(VarCurr,bitIndex18) )
      & ( v19920(VarCurr,bitIndex9)
      <=> v844(VarCurr,bitIndex17) )
      & ( v19920(VarCurr,bitIndex8)
      <=> v844(VarCurr,bitIndex16) )
      & ( v19920(VarCurr,bitIndex7)
      <=> v844(VarCurr,bitIndex15) )
      & ( v19920(VarCurr,bitIndex6)
      <=> v844(VarCurr,bitIndex14) )
      & ( v19920(VarCurr,bitIndex5)
      <=> v844(VarCurr,bitIndex13) )
      & ( v19920(VarCurr,bitIndex4)
      <=> v844(VarCurr,bitIndex12) )
      & ( v19920(VarCurr,bitIndex3)
      <=> v844(VarCurr,bitIndex11) )
      & ( v19920(VarCurr,bitIndex2)
      <=> v844(VarCurr,bitIndex10) )
      & ( v19920(VarCurr,bitIndex1)
      <=> v844(VarCurr,bitIndex9) )
      & ( v19920(VarCurr,bitIndex0)
      <=> v844(VarCurr,bitIndex8) ) ) ).

fof(addAssignment_3157,axiom,
    ! [VarCurr,B] :
      ( range_24_8(B)
     => ( v844(VarCurr,B)
      <=> v846(VarCurr,B) ) ) ).

fof(addAssignment_3156,axiom,
    ! [VarCurr] :
      ( ( v846(VarCurr,bitIndex24)
      <=> v19922(VarCurr,bitIndex16) )
      & ( v846(VarCurr,bitIndex23)
      <=> v19922(VarCurr,bitIndex15) )
      & ( v846(VarCurr,bitIndex22)
      <=> v19922(VarCurr,bitIndex14) )
      & ( v846(VarCurr,bitIndex21)
      <=> v19922(VarCurr,bitIndex13) )
      & ( v846(VarCurr,bitIndex20)
      <=> v19922(VarCurr,bitIndex12) )
      & ( v846(VarCurr,bitIndex19)
      <=> v19922(VarCurr,bitIndex11) )
      & ( v846(VarCurr,bitIndex18)
      <=> v19922(VarCurr,bitIndex10) )
      & ( v846(VarCurr,bitIndex17)
      <=> v19922(VarCurr,bitIndex9) )
      & ( v846(VarCurr,bitIndex16)
      <=> v19922(VarCurr,bitIndex8) )
      & ( v846(VarCurr,bitIndex15)
      <=> v19922(VarCurr,bitIndex7) )
      & ( v846(VarCurr,bitIndex14)
      <=> v19922(VarCurr,bitIndex6) )
      & ( v846(VarCurr,bitIndex13)
      <=> v19922(VarCurr,bitIndex5) )
      & ( v846(VarCurr,bitIndex12)
      <=> v19922(VarCurr,bitIndex4) )
      & ( v846(VarCurr,bitIndex11)
      <=> v19922(VarCurr,bitIndex3) )
      & ( v846(VarCurr,bitIndex10)
      <=> v19922(VarCurr,bitIndex2) )
      & ( v846(VarCurr,bitIndex9)
      <=> v19922(VarCurr,bitIndex1) )
      & ( v846(VarCurr,bitIndex8)
      <=> v19922(VarCurr,bitIndex0) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_180,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19950(VarNext)
       => ! [B] :
            ( range_16_0(B)
           => ( v19922(VarNext,B)
            <=> v19922(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_747,axiom,
    ! [VarNext] :
      ( v19950(VarNext)
     => ! [B] :
          ( range_16_0(B)
         => ( v19922(VarNext,B)
          <=> v19963(VarNext,B) ) ) ) ).

fof(addAssignment_3155,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_16_0(B)
         => ( v19963(VarNext,B)
          <=> v19961(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_187,axiom,
    ! [VarCurr] :
      ( ~ v19924(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v19961(VarCurr,B)
          <=> v19927(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_205,axiom,
    ! [VarCurr] :
      ( v19924(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v19961(VarCurr,B)
          <=> $true ) ) ) ).

fof(bitBlastConstant_2593,axiom,
    b11111111111111111(bitIndex16) ).

fof(bitBlastConstant_2592,axiom,
    b11111111111111111(bitIndex15) ).

fof(bitBlastConstant_2591,axiom,
    b11111111111111111(bitIndex14) ).

fof(bitBlastConstant_2590,axiom,
    b11111111111111111(bitIndex13) ).

fof(bitBlastConstant_2589,axiom,
    b11111111111111111(bitIndex12) ).

fof(bitBlastConstant_2588,axiom,
    b11111111111111111(bitIndex11) ).

fof(bitBlastConstant_2587,axiom,
    b11111111111111111(bitIndex10) ).

fof(bitBlastConstant_2586,axiom,
    b11111111111111111(bitIndex9) ).

fof(bitBlastConstant_2585,axiom,
    b11111111111111111(bitIndex8) ).

fof(bitBlastConstant_2584,axiom,
    b11111111111111111(bitIndex7) ).

fof(bitBlastConstant_2583,axiom,
    b11111111111111111(bitIndex6) ).

fof(bitBlastConstant_2582,axiom,
    b11111111111111111(bitIndex5) ).

fof(bitBlastConstant_2581,axiom,
    b11111111111111111(bitIndex4) ).

fof(bitBlastConstant_2580,axiom,
    b11111111111111111(bitIndex3) ).

fof(bitBlastConstant_2579,axiom,
    b11111111111111111(bitIndex2) ).

fof(bitBlastConstant_2578,axiom,
    b11111111111111111(bitIndex1) ).

fof(bitBlastConstant_2577,axiom,
    b11111111111111111(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5322,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19950(VarNext)
      <=> ( v19951(VarNext)
          & v19960(VarNext) ) ) ) ).

fof(addAssignment_3154,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19960(VarNext)
      <=> v19958(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5321,axiom,
    ! [VarCurr] :
      ( v19958(VarCurr)
    <=> ( v19945(VarCurr)
        | v19924(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5320,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19951(VarNext)
      <=> ( v19952(VarNext)
          & v19947(VarNext) ) ) ) ).

fof(writeUnaryOperator_1684,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19952(VarNext)
      <=> v19954(VarNext) ) ) ).

fof(addAssignment_3153,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19954(VarNext)
      <=> v19947(VarCurr) ) ) ).

fof(addAssignment_3152,axiom,
    ! [VarCurr] :
      ( v19947(VarCurr)
    <=> v96(VarCurr) ) ).

fof(addAssignment_3151,axiom,
    ! [VarCurr] :
      ( v19945(VarCurr)
    <=> v60(VarCurr) ) ).

fof(addAssignment_3150,axiom,
    ! [VarCurr] :
      ( ( v19927(VarCurr,bitIndex16)
      <=> v263(VarCurr,bitIndex24) )
      & ( v19927(VarCurr,bitIndex15)
      <=> v263(VarCurr,bitIndex23) )
      & ( v19927(VarCurr,bitIndex14)
      <=> v263(VarCurr,bitIndex22) )
      & ( v19927(VarCurr,bitIndex13)
      <=> v263(VarCurr,bitIndex21) )
      & ( v19927(VarCurr,bitIndex12)
      <=> v263(VarCurr,bitIndex20) )
      & ( v19927(VarCurr,bitIndex11)
      <=> v263(VarCurr,bitIndex19) )
      & ( v19927(VarCurr,bitIndex10)
      <=> v263(VarCurr,bitIndex18) )
      & ( v19927(VarCurr,bitIndex9)
      <=> v263(VarCurr,bitIndex17) )
      & ( v19927(VarCurr,bitIndex8)
      <=> v263(VarCurr,bitIndex16) )
      & ( v19927(VarCurr,bitIndex7)
      <=> v263(VarCurr,bitIndex15) )
      & ( v19927(VarCurr,bitIndex6)
      <=> v263(VarCurr,bitIndex14) )
      & ( v19927(VarCurr,bitIndex5)
      <=> v263(VarCurr,bitIndex13) )
      & ( v19927(VarCurr,bitIndex4)
      <=> v263(VarCurr,bitIndex12) )
      & ( v19927(VarCurr,bitIndex3)
      <=> v263(VarCurr,bitIndex11) )
      & ( v19927(VarCurr,bitIndex2)
      <=> v263(VarCurr,bitIndex10) )
      & ( v19927(VarCurr,bitIndex1)
      <=> v263(VarCurr,bitIndex9) )
      & ( v19927(VarCurr,bitIndex0)
      <=> v263(VarCurr,bitIndex8) ) ) ).

fof(addAssignment_3149,axiom,
    ! [VarCurr,B] :
      ( range_24_8(B)
     => ( v263(VarCurr,B)
      <=> v265(VarCurr,B) ) ) ).

fof(addAssignment_3148,axiom,
    ! [VarNext,B] :
      ( range_24_8(B)
     => ( v265(VarNext,B)
      <=> v19937(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_179,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19938(VarNext)
       => ! [B] :
            ( range_31_0(B)
           => ( v19937(VarNext,B)
            <=> v265(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_746,axiom,
    ! [VarNext] :
      ( v19938(VarNext)
     => ! [B] :
          ( range_31_0(B)
         => ( v19937(VarNext,B)
          <=> v287(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5319,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19938(VarNext)
      <=> v19939(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5318,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19939(VarNext)
      <=> ( v19941(VarNext)
          & v275(VarNext) ) ) ) ).

fof(writeUnaryOperator_1683,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19941(VarNext)
      <=> v282(VarNext) ) ) ).

fof(addAssignment_3147,axiom,
    ! [VarCurr,B] :
      ( range_24_8(B)
     => ( v267(VarCurr,B)
      <=> v269(VarCurr,B) ) ) ).

fof(addAssignment_3146,axiom,
    ! [VarCurr,B] :
      ( range_24_8(B)
     => ( v269(VarCurr,B)
      <=> v271(VarCurr,B) ) ) ).

fof(range_axiom_82,axiom,
    ! [B] :
      ( range_24_8(B)
    <=> ( $false
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B ) ) ).

fof(addAssignment_3145,axiom,
    ! [VarCurr,B] :
      ( range_24_11(B)
     => ( v271(VarCurr,B)
      <=> v273(VarCurr,B) ) ) ).

fof(addAssignment_3144,axiom,
    ! [VarNext,B] :
      ( range_24_11(B)
     => ( v273(VarNext,B)
      <=> v19929(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_178,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19930(VarNext)
       => ! [B] :
            ( range_31_0(B)
           => ( v19929(VarNext,B)
            <=> v273(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_745,axiom,
    ! [VarNext] :
      ( v19930(VarNext)
     => ! [B] :
          ( range_31_0(B)
         => ( v19929(VarNext,B)
          <=> v836(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5317,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19930(VarNext)
      <=> v19931(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5316,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19931(VarNext)
      <=> ( v19933(VarNext)
          & v41(VarNext) ) ) ) ).

fof(writeUnaryOperator_1682,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19933(VarNext)
      <=> v84(VarNext) ) ) ).

fof(addAssignment_3143,axiom,
    ! [VarCurr,B] :
      ( range_24_11(B)
     => ( v823(VarCurr,B)
      <=> v825(VarCurr,B) ) ) ).

fof(range_axiom_81,axiom,
    ! [B] :
      ( range_24_11(B)
    <=> ( $false
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B ) ) ).

fof(addAssignment_3142,axiom,
    ! [VarCurr] :
      ( v19924(VarCurr)
    <=> v22(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5315,axiom,
    ! [VarCurr] :
      ( v19416(VarCurr)
    <=> ( v19912(VarCurr)
        & v19903(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5314,axiom,
    ! [VarCurr] :
      ( v19912(VarCurr)
    <=> ( v338(VarCurr)
        & v19418(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_186,axiom,
    ! [VarCurr] :
      ( ~ v7861(VarCurr)
     => ( v19903(VarCurr)
      <=> v19908(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_204,axiom,
    ! [VarCurr] :
      ( v7861(VarCurr)
     => ( v19903(VarCurr)
      <=> v19905(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_1345,axiom,
    ! [VarCurr] :
      ( v19908(VarCurr)
    <=> ( ( v18793(VarCurr,bitIndex16)
        <=> v12868(VarCurr,bitIndex12) )
        & ( v18793(VarCurr,bitIndex15)
        <=> v12868(VarCurr,bitIndex11) )
        & ( v18793(VarCurr,bitIndex14)
        <=> v12868(VarCurr,bitIndex10) )
        & ( v18793(VarCurr,bitIndex13)
        <=> v12868(VarCurr,bitIndex9) )
        & ( v18793(VarCurr,bitIndex12)
        <=> v12868(VarCurr,bitIndex8) )
        & ( v18793(VarCurr,bitIndex11)
        <=> v12868(VarCurr,bitIndex7) )
        & ( v18793(VarCurr,bitIndex10)
        <=> v12868(VarCurr,bitIndex6) )
        & ( v18793(VarCurr,bitIndex9)
        <=> v12868(VarCurr,bitIndex5) )
        & ( v18793(VarCurr,bitIndex8)
        <=> v12868(VarCurr,bitIndex4) )
        & ( v18793(VarCurr,bitIndex7)
        <=> v12868(VarCurr,bitIndex3) )
        & ( v18793(VarCurr,bitIndex6)
        <=> v12868(VarCurr,bitIndex2) )
        & ( v18793(VarCurr,bitIndex5)
        <=> v12868(VarCurr,bitIndex1) )
        & ( v18793(VarCurr,bitIndex4)
        <=> v12868(VarCurr,bitIndex0) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1344,axiom,
    ! [VarCurr] :
      ( v19905(VarCurr)
    <=> ( ( v12798(VarCurr,bitIndex16)
        <=> v12868(VarCurr,bitIndex12) )
        & ( v12798(VarCurr,bitIndex15)
        <=> v12868(VarCurr,bitIndex11) )
        & ( v12798(VarCurr,bitIndex14)
        <=> v12868(VarCurr,bitIndex10) )
        & ( v12798(VarCurr,bitIndex13)
        <=> v12868(VarCurr,bitIndex9) )
        & ( v12798(VarCurr,bitIndex12)
        <=> v12868(VarCurr,bitIndex8) )
        & ( v12798(VarCurr,bitIndex11)
        <=> v12868(VarCurr,bitIndex7) )
        & ( v12798(VarCurr,bitIndex10)
        <=> v12868(VarCurr,bitIndex6) )
        & ( v12798(VarCurr,bitIndex9)
        <=> v12868(VarCurr,bitIndex5) )
        & ( v12798(VarCurr,bitIndex8)
        <=> v12868(VarCurr,bitIndex4) )
        & ( v12798(VarCurr,bitIndex7)
        <=> v12868(VarCurr,bitIndex3) )
        & ( v12798(VarCurr,bitIndex6)
        <=> v12868(VarCurr,bitIndex2) )
        & ( v12798(VarCurr,bitIndex5)
        <=> v12868(VarCurr,bitIndex1) )
        & ( v12798(VarCurr,bitIndex4)
        <=> v12868(VarCurr,bitIndex0) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_185,axiom,
    ! [VarCurr] :
      ( ~ v7861(VarCurr)
     => ( v19418(VarCurr)
      <=> v19713(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_203,axiom,
    ! [VarCurr] :
      ( v7861(VarCurr)
     => ( v19418(VarCurr)
      <=> v19420(VarCurr) ) ) ).

fof(addAssignment_3141,axiom,
    ! [VarCurr] :
      ( v19713(VarCurr)
    <=> v19715(VarCurr,bitIndex13) ) ).

fof(addAssignment_3140,axiom,
    ! [VarCurr] :
      ( v19715(VarCurr,bitIndex13)
    <=> v19724(VarCurr,bitIndex13) ) ).

fof(addAssignment_3139,axiom,
    ! [VarCurr] :
      ( v19724(VarCurr,bitIndex0)
    <=> v19896(VarCurr) ) ).

fof(addAssignment_3138,axiom,
    ! [VarCurr] :
      ( v19724(VarCurr,bitIndex1)
    <=> v19891(VarCurr) ) ).

fof(addAssignment_3137,axiom,
    ! [VarCurr] :
      ( v19724(VarCurr,bitIndex2)
    <=> v19886(VarCurr) ) ).

fof(addAssignment_3136,axiom,
    ! [VarCurr] :
      ( v19724(VarCurr,bitIndex3)
    <=> v19881(VarCurr) ) ).

fof(addAssignment_3135,axiom,
    ! [VarCurr] :
      ( v19724(VarCurr,bitIndex4)
    <=> v19876(VarCurr) ) ).

fof(addAssignment_3134,axiom,
    ! [VarCurr] :
      ( v19724(VarCurr,bitIndex5)
    <=> v19871(VarCurr) ) ).

fof(addAssignment_3133,axiom,
    ! [VarCurr] :
      ( v19724(VarCurr,bitIndex6)
    <=> v19866(VarCurr) ) ).

fof(addAssignment_3132,axiom,
    ! [VarCurr] :
      ( v19724(VarCurr,bitIndex7)
    <=> v19861(VarCurr) ) ).

fof(addAssignment_3131,axiom,
    ! [VarCurr] :
      ( v19724(VarCurr,bitIndex8)
    <=> v19856(VarCurr) ) ).

fof(addAssignment_3130,axiom,
    ! [VarCurr] :
      ( v19724(VarCurr,bitIndex9)
    <=> v19851(VarCurr) ) ).

fof(addAssignment_3129,axiom,
    ! [VarCurr] :
      ( v19724(VarCurr,bitIndex10)
    <=> v19846(VarCurr) ) ).

fof(addAssignment_3128,axiom,
    ! [VarCurr] :
      ( v19724(VarCurr,bitIndex11)
    <=> v19841(VarCurr) ) ).

fof(addAssignment_3127,axiom,
    ! [VarCurr] :
      ( v19724(VarCurr,bitIndex12)
    <=> v19836(VarCurr) ) ).

fof(addAssignment_3126,axiom,
    ! [VarCurr] :
      ( v19724(VarCurr,bitIndex13)
    <=> v19726(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5313,axiom,
    ! [VarCurr] :
      ( v19896(VarCurr)
    <=> ( v19897(VarCurr)
        & v19900(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5312,axiom,
    ! [VarCurr] :
      ( v19900(VarCurr)
    <=> ( v19754(VarCurr,bitIndex0)
        | v19755(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5311,axiom,
    ! [VarCurr] :
      ( v19897(VarCurr)
    <=> ( v19898(VarCurr)
        | v19899(VarCurr) ) ) ).

fof(writeUnaryOperator_1681,axiom,
    ! [VarCurr] :
      ( ~ v19899(VarCurr)
    <=> v19755(VarCurr,bitIndex0) ) ).

fof(writeUnaryOperator_1680,axiom,
    ! [VarCurr] :
      ( ~ v19898(VarCurr)
    <=> v19754(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5310,axiom,
    ! [VarCurr] :
      ( v19891(VarCurr)
    <=> ( v19892(VarCurr)
        & v19895(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5309,axiom,
    ! [VarCurr] :
      ( v19895(VarCurr)
    <=> ( v19753(VarCurr)
        | v19757(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5308,axiom,
    ! [VarCurr] :
      ( v19892(VarCurr)
    <=> ( v19893(VarCurr)
        | v19894(VarCurr) ) ) ).

fof(writeUnaryOperator_1679,axiom,
    ! [VarCurr] :
      ( ~ v19894(VarCurr)
    <=> v19757(VarCurr) ) ).

fof(writeUnaryOperator_1678,axiom,
    ! [VarCurr] :
      ( ~ v19893(VarCurr)
    <=> v19753(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5307,axiom,
    ! [VarCurr] :
      ( v19886(VarCurr)
    <=> ( v19887(VarCurr)
        & v19890(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5306,axiom,
    ! [VarCurr] :
      ( v19890(VarCurr)
    <=> ( v19751(VarCurr)
        | v19763(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5305,axiom,
    ! [VarCurr] :
      ( v19887(VarCurr)
    <=> ( v19888(VarCurr)
        | v19889(VarCurr) ) ) ).

fof(writeUnaryOperator_1677,axiom,
    ! [VarCurr] :
      ( ~ v19889(VarCurr)
    <=> v19763(VarCurr) ) ).

fof(writeUnaryOperator_1676,axiom,
    ! [VarCurr] :
      ( ~ v19888(VarCurr)
    <=> v19751(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5304,axiom,
    ! [VarCurr] :
      ( v19881(VarCurr)
    <=> ( v19882(VarCurr)
        & v19885(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5303,axiom,
    ! [VarCurr] :
      ( v19885(VarCurr)
    <=> ( v19749(VarCurr)
        | v19769(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5302,axiom,
    ! [VarCurr] :
      ( v19882(VarCurr)
    <=> ( v19883(VarCurr)
        | v19884(VarCurr) ) ) ).

fof(writeUnaryOperator_1675,axiom,
    ! [VarCurr] :
      ( ~ v19884(VarCurr)
    <=> v19769(VarCurr) ) ).

fof(writeUnaryOperator_1674,axiom,
    ! [VarCurr] :
      ( ~ v19883(VarCurr)
    <=> v19749(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5301,axiom,
    ! [VarCurr] :
      ( v19876(VarCurr)
    <=> ( v19877(VarCurr)
        & v19880(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5300,axiom,
    ! [VarCurr] :
      ( v19880(VarCurr)
    <=> ( v19747(VarCurr)
        | v19775(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5299,axiom,
    ! [VarCurr] :
      ( v19877(VarCurr)
    <=> ( v19878(VarCurr)
        | v19879(VarCurr) ) ) ).

fof(writeUnaryOperator_1673,axiom,
    ! [VarCurr] :
      ( ~ v19879(VarCurr)
    <=> v19775(VarCurr) ) ).

fof(writeUnaryOperator_1672,axiom,
    ! [VarCurr] :
      ( ~ v19878(VarCurr)
    <=> v19747(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5298,axiom,
    ! [VarCurr] :
      ( v19871(VarCurr)
    <=> ( v19872(VarCurr)
        & v19875(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5297,axiom,
    ! [VarCurr] :
      ( v19875(VarCurr)
    <=> ( v19745(VarCurr)
        | v19781(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5296,axiom,
    ! [VarCurr] :
      ( v19872(VarCurr)
    <=> ( v19873(VarCurr)
        | v19874(VarCurr) ) ) ).

fof(writeUnaryOperator_1671,axiom,
    ! [VarCurr] :
      ( ~ v19874(VarCurr)
    <=> v19781(VarCurr) ) ).

fof(writeUnaryOperator_1670,axiom,
    ! [VarCurr] :
      ( ~ v19873(VarCurr)
    <=> v19745(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5295,axiom,
    ! [VarCurr] :
      ( v19866(VarCurr)
    <=> ( v19867(VarCurr)
        & v19870(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5294,axiom,
    ! [VarCurr] :
      ( v19870(VarCurr)
    <=> ( v19743(VarCurr)
        | v19787(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5293,axiom,
    ! [VarCurr] :
      ( v19867(VarCurr)
    <=> ( v19868(VarCurr)
        | v19869(VarCurr) ) ) ).

fof(writeUnaryOperator_1669,axiom,
    ! [VarCurr] :
      ( ~ v19869(VarCurr)
    <=> v19787(VarCurr) ) ).

fof(writeUnaryOperator_1668,axiom,
    ! [VarCurr] :
      ( ~ v19868(VarCurr)
    <=> v19743(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5292,axiom,
    ! [VarCurr] :
      ( v19861(VarCurr)
    <=> ( v19862(VarCurr)
        & v19865(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5291,axiom,
    ! [VarCurr] :
      ( v19865(VarCurr)
    <=> ( v19741(VarCurr)
        | v19793(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5290,axiom,
    ! [VarCurr] :
      ( v19862(VarCurr)
    <=> ( v19863(VarCurr)
        | v19864(VarCurr) ) ) ).

fof(writeUnaryOperator_1667,axiom,
    ! [VarCurr] :
      ( ~ v19864(VarCurr)
    <=> v19793(VarCurr) ) ).

fof(writeUnaryOperator_1666,axiom,
    ! [VarCurr] :
      ( ~ v19863(VarCurr)
    <=> v19741(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5289,axiom,
    ! [VarCurr] :
      ( v19856(VarCurr)
    <=> ( v19857(VarCurr)
        & v19860(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5288,axiom,
    ! [VarCurr] :
      ( v19860(VarCurr)
    <=> ( v19739(VarCurr)
        | v19799(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5287,axiom,
    ! [VarCurr] :
      ( v19857(VarCurr)
    <=> ( v19858(VarCurr)
        | v19859(VarCurr) ) ) ).

fof(writeUnaryOperator_1665,axiom,
    ! [VarCurr] :
      ( ~ v19859(VarCurr)
    <=> v19799(VarCurr) ) ).

fof(writeUnaryOperator_1664,axiom,
    ! [VarCurr] :
      ( ~ v19858(VarCurr)
    <=> v19739(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5286,axiom,
    ! [VarCurr] :
      ( v19851(VarCurr)
    <=> ( v19852(VarCurr)
        & v19855(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5285,axiom,
    ! [VarCurr] :
      ( v19855(VarCurr)
    <=> ( v19737(VarCurr)
        | v19805(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5284,axiom,
    ! [VarCurr] :
      ( v19852(VarCurr)
    <=> ( v19853(VarCurr)
        | v19854(VarCurr) ) ) ).

fof(writeUnaryOperator_1663,axiom,
    ! [VarCurr] :
      ( ~ v19854(VarCurr)
    <=> v19805(VarCurr) ) ).

fof(writeUnaryOperator_1662,axiom,
    ! [VarCurr] :
      ( ~ v19853(VarCurr)
    <=> v19737(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5283,axiom,
    ! [VarCurr] :
      ( v19846(VarCurr)
    <=> ( v19847(VarCurr)
        & v19850(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5282,axiom,
    ! [VarCurr] :
      ( v19850(VarCurr)
    <=> ( v19735(VarCurr)
        | v19811(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5281,axiom,
    ! [VarCurr] :
      ( v19847(VarCurr)
    <=> ( v19848(VarCurr)
        | v19849(VarCurr) ) ) ).

fof(writeUnaryOperator_1661,axiom,
    ! [VarCurr] :
      ( ~ v19849(VarCurr)
    <=> v19811(VarCurr) ) ).

fof(writeUnaryOperator_1660,axiom,
    ! [VarCurr] :
      ( ~ v19848(VarCurr)
    <=> v19735(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5280,axiom,
    ! [VarCurr] :
      ( v19841(VarCurr)
    <=> ( v19842(VarCurr)
        & v19845(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5279,axiom,
    ! [VarCurr] :
      ( v19845(VarCurr)
    <=> ( v19733(VarCurr)
        | v19817(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5278,axiom,
    ! [VarCurr] :
      ( v19842(VarCurr)
    <=> ( v19843(VarCurr)
        | v19844(VarCurr) ) ) ).

fof(writeUnaryOperator_1659,axiom,
    ! [VarCurr] :
      ( ~ v19844(VarCurr)
    <=> v19817(VarCurr) ) ).

fof(writeUnaryOperator_1658,axiom,
    ! [VarCurr] :
      ( ~ v19843(VarCurr)
    <=> v19733(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5277,axiom,
    ! [VarCurr] :
      ( v19836(VarCurr)
    <=> ( v19837(VarCurr)
        & v19840(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5276,axiom,
    ! [VarCurr] :
      ( v19840(VarCurr)
    <=> ( v19731(VarCurr)
        | v19823(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5275,axiom,
    ! [VarCurr] :
      ( v19837(VarCurr)
    <=> ( v19838(VarCurr)
        | v19839(VarCurr) ) ) ).

fof(writeUnaryOperator_1657,axiom,
    ! [VarCurr] :
      ( ~ v19839(VarCurr)
    <=> v19823(VarCurr) ) ).

fof(writeUnaryOperator_1656,axiom,
    ! [VarCurr] :
      ( ~ v19838(VarCurr)
    <=> v19731(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5274,axiom,
    ! [VarCurr] :
      ( v19726(VarCurr)
    <=> ( v19727(VarCurr)
        & v19835(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5273,axiom,
    ! [VarCurr] :
      ( v19835(VarCurr)
    <=> ( v19729(VarCurr)
        | v19830(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5272,axiom,
    ! [VarCurr] :
      ( v19727(VarCurr)
    <=> ( v19728(VarCurr)
        | v19829(VarCurr) ) ) ).

fof(writeUnaryOperator_1655,axiom,
    ! [VarCurr] :
      ( ~ v19829(VarCurr)
    <=> v19830(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5271,axiom,
    ! [VarCurr] :
      ( v19830(VarCurr)
    <=> ( v19831(VarCurr)
        & v19834(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1679,axiom,
    ! [VarCurr] :
      ( v19834(VarCurr)
    <=> ( v19754(VarCurr,bitIndex13)
        | v19755(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5270,axiom,
    ! [VarCurr] :
      ( v19831(VarCurr)
    <=> ( v19832(VarCurr)
        | v19833(VarCurr) ) ) ).

fof(writeUnaryOperator_1654,axiom,
    ! [VarCurr] :
      ( ~ v19833(VarCurr)
    <=> v19755(VarCurr,bitIndex13) ) ).

fof(writeUnaryOperator_1653,axiom,
    ! [VarCurr] :
      ( ~ v19832(VarCurr)
    <=> v19754(VarCurr,bitIndex13) ) ).

fof(writeUnaryOperator_1652,axiom,
    ! [VarCurr] :
      ( ~ v19728(VarCurr)
    <=> v19729(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5269,axiom,
    ! [VarCurr] :
      ( v19729(VarCurr)
    <=> ( v19730(VarCurr)
        | v19828(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1678,axiom,
    ! [VarCurr] :
      ( v19828(VarCurr)
    <=> ( v19754(VarCurr,bitIndex12)
        & v19755(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5268,axiom,
    ! [VarCurr] :
      ( v19730(VarCurr)
    <=> ( v19731(VarCurr)
        & v19823(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5267,axiom,
    ! [VarCurr] :
      ( v19823(VarCurr)
    <=> ( v19824(VarCurr)
        & v19827(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1677,axiom,
    ! [VarCurr] :
      ( v19827(VarCurr)
    <=> ( v19754(VarCurr,bitIndex12)
        | v19755(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5266,axiom,
    ! [VarCurr] :
      ( v19824(VarCurr)
    <=> ( v19825(VarCurr)
        | v19826(VarCurr) ) ) ).

fof(writeUnaryOperator_1651,axiom,
    ! [VarCurr] :
      ( ~ v19826(VarCurr)
    <=> v19755(VarCurr,bitIndex12) ) ).

fof(writeUnaryOperator_1650,axiom,
    ! [VarCurr] :
      ( ~ v19825(VarCurr)
    <=> v19754(VarCurr,bitIndex12) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5265,axiom,
    ! [VarCurr] :
      ( v19731(VarCurr)
    <=> ( v19732(VarCurr)
        | v19822(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1676,axiom,
    ! [VarCurr] :
      ( v19822(VarCurr)
    <=> ( v19754(VarCurr,bitIndex11)
        & v19755(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5264,axiom,
    ! [VarCurr] :
      ( v19732(VarCurr)
    <=> ( v19733(VarCurr)
        & v19817(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5263,axiom,
    ! [VarCurr] :
      ( v19817(VarCurr)
    <=> ( v19818(VarCurr)
        & v19821(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1675,axiom,
    ! [VarCurr] :
      ( v19821(VarCurr)
    <=> ( v19754(VarCurr,bitIndex11)
        | v19755(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5262,axiom,
    ! [VarCurr] :
      ( v19818(VarCurr)
    <=> ( v19819(VarCurr)
        | v19820(VarCurr) ) ) ).

fof(writeUnaryOperator_1649,axiom,
    ! [VarCurr] :
      ( ~ v19820(VarCurr)
    <=> v19755(VarCurr,bitIndex11) ) ).

fof(writeUnaryOperator_1648,axiom,
    ! [VarCurr] :
      ( ~ v19819(VarCurr)
    <=> v19754(VarCurr,bitIndex11) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5261,axiom,
    ! [VarCurr] :
      ( v19733(VarCurr)
    <=> ( v19734(VarCurr)
        | v19816(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1674,axiom,
    ! [VarCurr] :
      ( v19816(VarCurr)
    <=> ( v19754(VarCurr,bitIndex10)
        & v19755(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5260,axiom,
    ! [VarCurr] :
      ( v19734(VarCurr)
    <=> ( v19735(VarCurr)
        & v19811(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5259,axiom,
    ! [VarCurr] :
      ( v19811(VarCurr)
    <=> ( v19812(VarCurr)
        & v19815(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1673,axiom,
    ! [VarCurr] :
      ( v19815(VarCurr)
    <=> ( v19754(VarCurr,bitIndex10)
        | v19755(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5258,axiom,
    ! [VarCurr] :
      ( v19812(VarCurr)
    <=> ( v19813(VarCurr)
        | v19814(VarCurr) ) ) ).

fof(writeUnaryOperator_1647,axiom,
    ! [VarCurr] :
      ( ~ v19814(VarCurr)
    <=> v19755(VarCurr,bitIndex10) ) ).

fof(writeUnaryOperator_1646,axiom,
    ! [VarCurr] :
      ( ~ v19813(VarCurr)
    <=> v19754(VarCurr,bitIndex10) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5257,axiom,
    ! [VarCurr] :
      ( v19735(VarCurr)
    <=> ( v19736(VarCurr)
        | v19810(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1672,axiom,
    ! [VarCurr] :
      ( v19810(VarCurr)
    <=> ( v19754(VarCurr,bitIndex9)
        & v19755(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5256,axiom,
    ! [VarCurr] :
      ( v19736(VarCurr)
    <=> ( v19737(VarCurr)
        & v19805(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5255,axiom,
    ! [VarCurr] :
      ( v19805(VarCurr)
    <=> ( v19806(VarCurr)
        & v19809(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1671,axiom,
    ! [VarCurr] :
      ( v19809(VarCurr)
    <=> ( v19754(VarCurr,bitIndex9)
        | v19755(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5254,axiom,
    ! [VarCurr] :
      ( v19806(VarCurr)
    <=> ( v19807(VarCurr)
        | v19808(VarCurr) ) ) ).

fof(writeUnaryOperator_1645,axiom,
    ! [VarCurr] :
      ( ~ v19808(VarCurr)
    <=> v19755(VarCurr,bitIndex9) ) ).

fof(writeUnaryOperator_1644,axiom,
    ! [VarCurr] :
      ( ~ v19807(VarCurr)
    <=> v19754(VarCurr,bitIndex9) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5253,axiom,
    ! [VarCurr] :
      ( v19737(VarCurr)
    <=> ( v19738(VarCurr)
        | v19804(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1670,axiom,
    ! [VarCurr] :
      ( v19804(VarCurr)
    <=> ( v19754(VarCurr,bitIndex8)
        & v19755(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5252,axiom,
    ! [VarCurr] :
      ( v19738(VarCurr)
    <=> ( v19739(VarCurr)
        & v19799(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5251,axiom,
    ! [VarCurr] :
      ( v19799(VarCurr)
    <=> ( v19800(VarCurr)
        & v19803(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1669,axiom,
    ! [VarCurr] :
      ( v19803(VarCurr)
    <=> ( v19754(VarCurr,bitIndex8)
        | v19755(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5250,axiom,
    ! [VarCurr] :
      ( v19800(VarCurr)
    <=> ( v19801(VarCurr)
        | v19802(VarCurr) ) ) ).

fof(writeUnaryOperator_1643,axiom,
    ! [VarCurr] :
      ( ~ v19802(VarCurr)
    <=> v19755(VarCurr,bitIndex8) ) ).

fof(writeUnaryOperator_1642,axiom,
    ! [VarCurr] :
      ( ~ v19801(VarCurr)
    <=> v19754(VarCurr,bitIndex8) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5249,axiom,
    ! [VarCurr] :
      ( v19739(VarCurr)
    <=> ( v19740(VarCurr)
        | v19798(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1668,axiom,
    ! [VarCurr] :
      ( v19798(VarCurr)
    <=> ( v19754(VarCurr,bitIndex7)
        & v19755(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5248,axiom,
    ! [VarCurr] :
      ( v19740(VarCurr)
    <=> ( v19741(VarCurr)
        & v19793(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5247,axiom,
    ! [VarCurr] :
      ( v19793(VarCurr)
    <=> ( v19794(VarCurr)
        & v19797(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1667,axiom,
    ! [VarCurr] :
      ( v19797(VarCurr)
    <=> ( v19754(VarCurr,bitIndex7)
        | v19755(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5246,axiom,
    ! [VarCurr] :
      ( v19794(VarCurr)
    <=> ( v19795(VarCurr)
        | v19796(VarCurr) ) ) ).

fof(writeUnaryOperator_1641,axiom,
    ! [VarCurr] :
      ( ~ v19796(VarCurr)
    <=> v19755(VarCurr,bitIndex7) ) ).

fof(writeUnaryOperator_1640,axiom,
    ! [VarCurr] :
      ( ~ v19795(VarCurr)
    <=> v19754(VarCurr,bitIndex7) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5245,axiom,
    ! [VarCurr] :
      ( v19741(VarCurr)
    <=> ( v19742(VarCurr)
        | v19792(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1666,axiom,
    ! [VarCurr] :
      ( v19792(VarCurr)
    <=> ( v19754(VarCurr,bitIndex6)
        & v19755(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5244,axiom,
    ! [VarCurr] :
      ( v19742(VarCurr)
    <=> ( v19743(VarCurr)
        & v19787(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5243,axiom,
    ! [VarCurr] :
      ( v19787(VarCurr)
    <=> ( v19788(VarCurr)
        & v19791(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1665,axiom,
    ! [VarCurr] :
      ( v19791(VarCurr)
    <=> ( v19754(VarCurr,bitIndex6)
        | v19755(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5242,axiom,
    ! [VarCurr] :
      ( v19788(VarCurr)
    <=> ( v19789(VarCurr)
        | v19790(VarCurr) ) ) ).

fof(writeUnaryOperator_1639,axiom,
    ! [VarCurr] :
      ( ~ v19790(VarCurr)
    <=> v19755(VarCurr,bitIndex6) ) ).

fof(writeUnaryOperator_1638,axiom,
    ! [VarCurr] :
      ( ~ v19789(VarCurr)
    <=> v19754(VarCurr,bitIndex6) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5241,axiom,
    ! [VarCurr] :
      ( v19743(VarCurr)
    <=> ( v19744(VarCurr)
        | v19786(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1664,axiom,
    ! [VarCurr] :
      ( v19786(VarCurr)
    <=> ( v19754(VarCurr,bitIndex5)
        & v19755(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5240,axiom,
    ! [VarCurr] :
      ( v19744(VarCurr)
    <=> ( v19745(VarCurr)
        & v19781(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5239,axiom,
    ! [VarCurr] :
      ( v19781(VarCurr)
    <=> ( v19782(VarCurr)
        & v19785(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1663,axiom,
    ! [VarCurr] :
      ( v19785(VarCurr)
    <=> ( v19754(VarCurr,bitIndex5)
        | v19755(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5238,axiom,
    ! [VarCurr] :
      ( v19782(VarCurr)
    <=> ( v19783(VarCurr)
        | v19784(VarCurr) ) ) ).

fof(writeUnaryOperator_1637,axiom,
    ! [VarCurr] :
      ( ~ v19784(VarCurr)
    <=> v19755(VarCurr,bitIndex5) ) ).

fof(writeUnaryOperator_1636,axiom,
    ! [VarCurr] :
      ( ~ v19783(VarCurr)
    <=> v19754(VarCurr,bitIndex5) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5237,axiom,
    ! [VarCurr] :
      ( v19745(VarCurr)
    <=> ( v19746(VarCurr)
        | v19780(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1662,axiom,
    ! [VarCurr] :
      ( v19780(VarCurr)
    <=> ( v19754(VarCurr,bitIndex4)
        & v19755(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5236,axiom,
    ! [VarCurr] :
      ( v19746(VarCurr)
    <=> ( v19747(VarCurr)
        & v19775(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5235,axiom,
    ! [VarCurr] :
      ( v19775(VarCurr)
    <=> ( v19776(VarCurr)
        & v19779(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1661,axiom,
    ! [VarCurr] :
      ( v19779(VarCurr)
    <=> ( v19754(VarCurr,bitIndex4)
        | v19755(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5234,axiom,
    ! [VarCurr] :
      ( v19776(VarCurr)
    <=> ( v19777(VarCurr)
        | v19778(VarCurr) ) ) ).

fof(writeUnaryOperator_1635,axiom,
    ! [VarCurr] :
      ( ~ v19778(VarCurr)
    <=> v19755(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_1634,axiom,
    ! [VarCurr] :
      ( ~ v19777(VarCurr)
    <=> v19754(VarCurr,bitIndex4) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5233,axiom,
    ! [VarCurr] :
      ( v19747(VarCurr)
    <=> ( v19748(VarCurr)
        | v19774(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1660,axiom,
    ! [VarCurr] :
      ( v19774(VarCurr)
    <=> ( v19754(VarCurr,bitIndex3)
        & v19755(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5232,axiom,
    ! [VarCurr] :
      ( v19748(VarCurr)
    <=> ( v19749(VarCurr)
        & v19769(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5231,axiom,
    ! [VarCurr] :
      ( v19769(VarCurr)
    <=> ( v19770(VarCurr)
        & v19773(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1659,axiom,
    ! [VarCurr] :
      ( v19773(VarCurr)
    <=> ( v19754(VarCurr,bitIndex3)
        | v19755(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5230,axiom,
    ! [VarCurr] :
      ( v19770(VarCurr)
    <=> ( v19771(VarCurr)
        | v19772(VarCurr) ) ) ).

fof(writeUnaryOperator_1633,axiom,
    ! [VarCurr] :
      ( ~ v19772(VarCurr)
    <=> v19755(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_1632,axiom,
    ! [VarCurr] :
      ( ~ v19771(VarCurr)
    <=> v19754(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5229,axiom,
    ! [VarCurr] :
      ( v19749(VarCurr)
    <=> ( v19750(VarCurr)
        | v19768(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1658,axiom,
    ! [VarCurr] :
      ( v19768(VarCurr)
    <=> ( v19754(VarCurr,bitIndex2)
        & v19755(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5228,axiom,
    ! [VarCurr] :
      ( v19750(VarCurr)
    <=> ( v19751(VarCurr)
        & v19763(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5227,axiom,
    ! [VarCurr] :
      ( v19763(VarCurr)
    <=> ( v19764(VarCurr)
        & v19767(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1657,axiom,
    ! [VarCurr] :
      ( v19767(VarCurr)
    <=> ( v19754(VarCurr,bitIndex2)
        | v19755(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5226,axiom,
    ! [VarCurr] :
      ( v19764(VarCurr)
    <=> ( v19765(VarCurr)
        | v19766(VarCurr) ) ) ).

fof(writeUnaryOperator_1631,axiom,
    ! [VarCurr] :
      ( ~ v19766(VarCurr)
    <=> v19755(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_1630,axiom,
    ! [VarCurr] :
      ( ~ v19765(VarCurr)
    <=> v19754(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5225,axiom,
    ! [VarCurr] :
      ( v19751(VarCurr)
    <=> ( v19752(VarCurr)
        | v19762(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1656,axiom,
    ! [VarCurr] :
      ( v19762(VarCurr)
    <=> ( v19754(VarCurr,bitIndex1)
        & v19755(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5224,axiom,
    ! [VarCurr] :
      ( v19752(VarCurr)
    <=> ( v19753(VarCurr)
        & v19757(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5223,axiom,
    ! [VarCurr] :
      ( v19757(VarCurr)
    <=> ( v19758(VarCurr)
        & v19761(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1655,axiom,
    ! [VarCurr] :
      ( v19761(VarCurr)
    <=> ( v19754(VarCurr,bitIndex1)
        | v19755(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5222,axiom,
    ! [VarCurr] :
      ( v19758(VarCurr)
    <=> ( v19759(VarCurr)
        | v19760(VarCurr) ) ) ).

fof(writeUnaryOperator_1629,axiom,
    ! [VarCurr] :
      ( ~ v19760(VarCurr)
    <=> v19755(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_1628,axiom,
    ! [VarCurr] :
      ( ~ v19759(VarCurr)
    <=> v19754(VarCurr,bitIndex1) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5221,axiom,
    ! [VarCurr] :
      ( v19753(VarCurr)
    <=> ( v19754(VarCurr,bitIndex0)
        & v19755(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_3125,axiom,
    ! [VarCurr,B] :
      ( range_12_0(B)
     => ( v19755(VarCurr,B)
      <=> v19756(VarCurr,B) ) ) ).

fof(addAssignment_3124,axiom,
    ! [VarCurr] :
      ( v19755(VarCurr,bitIndex13)
    <=> $false ) ).

fof(writeUnaryOperator_1627,axiom,
    ! [VarCurr,B] :
      ( range_12_0(B)
     => ( v19756(VarCurr,B)
      <=> ~ v12870(VarCurr,B) ) ) ).

fof(addAssignment_3123,axiom,
    ! [VarCurr] :
      ( ( v19754(VarCurr,bitIndex12)
      <=> v18793(VarCurr,bitIndex16) )
      & ( v19754(VarCurr,bitIndex11)
      <=> v18793(VarCurr,bitIndex15) )
      & ( v19754(VarCurr,bitIndex10)
      <=> v18793(VarCurr,bitIndex14) )
      & ( v19754(VarCurr,bitIndex9)
      <=> v18793(VarCurr,bitIndex13) )
      & ( v19754(VarCurr,bitIndex8)
      <=> v18793(VarCurr,bitIndex12) )
      & ( v19754(VarCurr,bitIndex7)
      <=> v18793(VarCurr,bitIndex11) )
      & ( v19754(VarCurr,bitIndex6)
      <=> v18793(VarCurr,bitIndex10) )
      & ( v19754(VarCurr,bitIndex5)
      <=> v18793(VarCurr,bitIndex9) )
      & ( v19754(VarCurr,bitIndex4)
      <=> v18793(VarCurr,bitIndex8) )
      & ( v19754(VarCurr,bitIndex3)
      <=> v18793(VarCurr,bitIndex7) )
      & ( v19754(VarCurr,bitIndex2)
      <=> v18793(VarCurr,bitIndex6) )
      & ( v19754(VarCurr,bitIndex1)
      <=> v18793(VarCurr,bitIndex5) )
      & ( v19754(VarCurr,bitIndex0)
      <=> v18793(VarCurr,bitIndex4) ) ) ).

fof(addAssignment_3122,axiom,
    ! [VarCurr] :
      ( v19754(VarCurr,bitIndex13)
    <=> $false ) ).

fof(addAssignment_3121,axiom,
    ! [VarCurr,B] :
      ( range_16_4(B)
     => ( v18793(VarCurr,B)
      <=> v18795(VarCurr,B) ) ) ).

fof(addAssignment_3120,axiom,
    ! [VarNext,B] :
      ( range_16_4(B)
     => ( v18795(VarNext,B)
      <=> v19717(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_177,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19718(VarNext)
       => ! [B] :
            ( range_16_0(B)
           => ( v19717(VarNext,B)
            <=> v18795(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_744,axiom,
    ! [VarNext] :
      ( v19718(VarNext)
     => ! [B] :
          ( range_16_0(B)
         => ( v19717(VarNext,B)
          <=> v19245(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5220,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19718(VarNext)
      <=> v19719(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5219,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19719(VarNext)
      <=> ( v19721(VarNext)
          & v19233(VarNext) ) ) ) ).

fof(writeUnaryOperator_1626,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19721(VarNext)
      <=> v19240(VarNext) ) ) ).

fof(addAssignment_3119,axiom,
    ! [VarCurr,B] :
      ( range_16_4(B)
     => ( v18797(VarCurr,B)
      <=> v19226(VarCurr,B) ) ) ).

fof(addAssignment_3118,axiom,
    ! [VarCurr,B] :
      ( range_16_4(B)
     => ( v18806(VarCurr,B)
      <=> v18808(VarCurr,B) ) ) ).

fof(addAssignment_3117,axiom,
    ! [VarCurr] :
      ( ( v18808(VarCurr,bitIndex16)
      <=> v19025(VarCurr,bitIndex15) )
      & ( v18808(VarCurr,bitIndex15)
      <=> v19025(VarCurr,bitIndex14) )
      & ( v18808(VarCurr,bitIndex14)
      <=> v19025(VarCurr,bitIndex13) )
      & ( v18808(VarCurr,bitIndex13)
      <=> v19025(VarCurr,bitIndex12) )
      & ( v18808(VarCurr,bitIndex12)
      <=> v19025(VarCurr,bitIndex11) )
      & ( v18808(VarCurr,bitIndex11)
      <=> v19025(VarCurr,bitIndex10) )
      & ( v18808(VarCurr,bitIndex10)
      <=> v19025(VarCurr,bitIndex9) )
      & ( v18808(VarCurr,bitIndex9)
      <=> v19025(VarCurr,bitIndex8) )
      & ( v18808(VarCurr,bitIndex8)
      <=> v19025(VarCurr,bitIndex7) )
      & ( v18808(VarCurr,bitIndex7)
      <=> v19025(VarCurr,bitIndex6) )
      & ( v18808(VarCurr,bitIndex6)
      <=> v19025(VarCurr,bitIndex5) )
      & ( v18808(VarCurr,bitIndex5)
      <=> v19025(VarCurr,bitIndex4) )
      & ( v18808(VarCurr,bitIndex4)
      <=> v19025(VarCurr,bitIndex3) ) ) ).

fof(addAssignment_3116,axiom,
    ! [VarCurr] :
      ( v19018(VarCurr,bitIndex16)
    <=> v19023(VarCurr,bitIndex16) ) ).

fof(addAssignment_3115,axiom,
    ! [VarCurr] :
      ( v19018(VarCurr,bitIndex15)
    <=> v19023(VarCurr,bitIndex15) ) ).

fof(addAssignment_3114,axiom,
    ! [VarCurr] :
      ( v19018(VarCurr,bitIndex14)
    <=> v19023(VarCurr,bitIndex14) ) ).

fof(addAssignment_3113,axiom,
    ! [VarCurr] :
      ( v19018(VarCurr,bitIndex13)
    <=> v19023(VarCurr,bitIndex13) ) ).

fof(addAssignment_3112,axiom,
    ! [VarCurr] :
      ( v19018(VarCurr,bitIndex12)
    <=> v19023(VarCurr,bitIndex12) ) ).

fof(addAssignment_3111,axiom,
    ! [VarCurr] :
      ( v19018(VarCurr,bitIndex11)
    <=> v19023(VarCurr,bitIndex11) ) ).

fof(addAssignment_3110,axiom,
    ! [VarCurr] :
      ( v19018(VarCurr,bitIndex10)
    <=> v19023(VarCurr,bitIndex10) ) ).

fof(addAssignment_3109,axiom,
    ! [VarCurr] :
      ( v19018(VarCurr,bitIndex9)
    <=> v19023(VarCurr,bitIndex9) ) ).

fof(addAssignment_3108,axiom,
    ! [VarCurr] :
      ( v19018(VarCurr,bitIndex8)
    <=> v19023(VarCurr,bitIndex8) ) ).

fof(addAssignment_3107,axiom,
    ! [VarCurr] :
      ( v19018(VarCurr,bitIndex7)
    <=> v19023(VarCurr,bitIndex7) ) ).

fof(addAssignment_3106,axiom,
    ! [VarCurr] :
      ( v19018(VarCurr,bitIndex6)
    <=> v19023(VarCurr,bitIndex6) ) ).

fof(addAssignment_3105,axiom,
    ! [VarCurr] :
      ( v19018(VarCurr,bitIndex5)
    <=> v19023(VarCurr,bitIndex5) ) ).

fof(addAssignment_3104,axiom,
    ! [VarCurr] :
      ( v19018(VarCurr,bitIndex4)
    <=> v19023(VarCurr,bitIndex4) ) ).

fof(addAssignment_3103,axiom,
    ! [VarCurr] :
      ( v18810(VarCurr,bitIndex15)
    <=> v18886(VarCurr,bitIndex15) ) ).

fof(addAssignment_3102,axiom,
    ! [VarCurr] :
      ( v18810(VarCurr,bitIndex14)
    <=> v18886(VarCurr,bitIndex14) ) ).

fof(addAssignment_3101,axiom,
    ! [VarCurr] :
      ( v18810(VarCurr,bitIndex13)
    <=> v18886(VarCurr,bitIndex13) ) ).

fof(addAssignment_3100,axiom,
    ! [VarCurr] :
      ( v18810(VarCurr,bitIndex12)
    <=> v18886(VarCurr,bitIndex12) ) ).

fof(addAssignment_3099,axiom,
    ! [VarCurr] :
      ( v18810(VarCurr,bitIndex11)
    <=> v18886(VarCurr,bitIndex11) ) ).

fof(addAssignment_3098,axiom,
    ! [VarCurr] :
      ( v18810(VarCurr,bitIndex10)
    <=> v18886(VarCurr,bitIndex10) ) ).

fof(addAssignment_3097,axiom,
    ! [VarCurr] :
      ( v18810(VarCurr,bitIndex9)
    <=> v18886(VarCurr,bitIndex9) ) ).

fof(addAssignment_3096,axiom,
    ! [VarCurr] :
      ( v18810(VarCurr,bitIndex8)
    <=> v18886(VarCurr,bitIndex8) ) ).

fof(addAssignment_3095,axiom,
    ! [VarCurr] :
      ( v18810(VarCurr,bitIndex7)
    <=> v18886(VarCurr,bitIndex7) ) ).

fof(addAssignment_3094,axiom,
    ! [VarCurr] :
      ( v18810(VarCurr,bitIndex6)
    <=> v18886(VarCurr,bitIndex6) ) ).

fof(addAssignment_3093,axiom,
    ! [VarCurr] :
      ( v18810(VarCurr,bitIndex5)
    <=> v18886(VarCurr,bitIndex5) ) ).

fof(addAssignment_3092,axiom,
    ! [VarCurr] :
      ( v18810(VarCurr,bitIndex4)
    <=> v18886(VarCurr,bitIndex4) ) ).

fof(addAssignment_3091,axiom,
    ! [VarCurr] :
      ( v19420(VarCurr)
    <=> v19422(VarCurr,bitIndex13) ) ).

fof(addAssignment_3090,axiom,
    ! [VarCurr] :
      ( v19422(VarCurr,bitIndex13)
    <=> v19535(VarCurr,bitIndex13) ) ).

fof(addAssignment_3089,axiom,
    ! [VarCurr] :
      ( v19535(VarCurr,bitIndex0)
    <=> v19707(VarCurr) ) ).

fof(addAssignment_3088,axiom,
    ! [VarCurr] :
      ( v19535(VarCurr,bitIndex1)
    <=> v19702(VarCurr) ) ).

fof(addAssignment_3087,axiom,
    ! [VarCurr] :
      ( v19535(VarCurr,bitIndex2)
    <=> v19697(VarCurr) ) ).

fof(addAssignment_3086,axiom,
    ! [VarCurr] :
      ( v19535(VarCurr,bitIndex3)
    <=> v19692(VarCurr) ) ).

fof(addAssignment_3085,axiom,
    ! [VarCurr] :
      ( v19535(VarCurr,bitIndex4)
    <=> v19687(VarCurr) ) ).

fof(addAssignment_3084,axiom,
    ! [VarCurr] :
      ( v19535(VarCurr,bitIndex5)
    <=> v19682(VarCurr) ) ).

fof(addAssignment_3083,axiom,
    ! [VarCurr] :
      ( v19535(VarCurr,bitIndex6)
    <=> v19677(VarCurr) ) ).

fof(addAssignment_3082,axiom,
    ! [VarCurr] :
      ( v19535(VarCurr,bitIndex7)
    <=> v19672(VarCurr) ) ).

fof(addAssignment_3081,axiom,
    ! [VarCurr] :
      ( v19535(VarCurr,bitIndex8)
    <=> v19667(VarCurr) ) ).

fof(addAssignment_3080,axiom,
    ! [VarCurr] :
      ( v19535(VarCurr,bitIndex9)
    <=> v19662(VarCurr) ) ).

fof(addAssignment_3079,axiom,
    ! [VarCurr] :
      ( v19535(VarCurr,bitIndex10)
    <=> v19657(VarCurr) ) ).

fof(addAssignment_3078,axiom,
    ! [VarCurr] :
      ( v19535(VarCurr,bitIndex11)
    <=> v19652(VarCurr) ) ).

fof(addAssignment_3077,axiom,
    ! [VarCurr] :
      ( v19535(VarCurr,bitIndex12)
    <=> v19647(VarCurr) ) ).

fof(addAssignment_3076,axiom,
    ! [VarCurr] :
      ( v19535(VarCurr,bitIndex13)
    <=> v19537(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5218,axiom,
    ! [VarCurr] :
      ( v19707(VarCurr)
    <=> ( v19708(VarCurr)
        & v19711(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5217,axiom,
    ! [VarCurr] :
      ( v19711(VarCurr)
    <=> ( v19565(VarCurr,bitIndex0)
        | v19566(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5216,axiom,
    ! [VarCurr] :
      ( v19708(VarCurr)
    <=> ( v19709(VarCurr)
        | v19710(VarCurr) ) ) ).

fof(writeUnaryOperator_1625,axiom,
    ! [VarCurr] :
      ( ~ v19710(VarCurr)
    <=> v19566(VarCurr,bitIndex0) ) ).

fof(writeUnaryOperator_1624,axiom,
    ! [VarCurr] :
      ( ~ v19709(VarCurr)
    <=> v19565(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5215,axiom,
    ! [VarCurr] :
      ( v19702(VarCurr)
    <=> ( v19703(VarCurr)
        & v19706(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5214,axiom,
    ! [VarCurr] :
      ( v19706(VarCurr)
    <=> ( v19564(VarCurr)
        | v19568(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5213,axiom,
    ! [VarCurr] :
      ( v19703(VarCurr)
    <=> ( v19704(VarCurr)
        | v19705(VarCurr) ) ) ).

fof(writeUnaryOperator_1623,axiom,
    ! [VarCurr] :
      ( ~ v19705(VarCurr)
    <=> v19568(VarCurr) ) ).

fof(writeUnaryOperator_1622,axiom,
    ! [VarCurr] :
      ( ~ v19704(VarCurr)
    <=> v19564(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5212,axiom,
    ! [VarCurr] :
      ( v19697(VarCurr)
    <=> ( v19698(VarCurr)
        & v19701(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5211,axiom,
    ! [VarCurr] :
      ( v19701(VarCurr)
    <=> ( v19562(VarCurr)
        | v19574(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5210,axiom,
    ! [VarCurr] :
      ( v19698(VarCurr)
    <=> ( v19699(VarCurr)
        | v19700(VarCurr) ) ) ).

fof(writeUnaryOperator_1621,axiom,
    ! [VarCurr] :
      ( ~ v19700(VarCurr)
    <=> v19574(VarCurr) ) ).

fof(writeUnaryOperator_1620,axiom,
    ! [VarCurr] :
      ( ~ v19699(VarCurr)
    <=> v19562(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5209,axiom,
    ! [VarCurr] :
      ( v19692(VarCurr)
    <=> ( v19693(VarCurr)
        & v19696(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5208,axiom,
    ! [VarCurr] :
      ( v19696(VarCurr)
    <=> ( v19560(VarCurr)
        | v19580(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5207,axiom,
    ! [VarCurr] :
      ( v19693(VarCurr)
    <=> ( v19694(VarCurr)
        | v19695(VarCurr) ) ) ).

fof(writeUnaryOperator_1619,axiom,
    ! [VarCurr] :
      ( ~ v19695(VarCurr)
    <=> v19580(VarCurr) ) ).

fof(writeUnaryOperator_1618,axiom,
    ! [VarCurr] :
      ( ~ v19694(VarCurr)
    <=> v19560(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5206,axiom,
    ! [VarCurr] :
      ( v19687(VarCurr)
    <=> ( v19688(VarCurr)
        & v19691(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5205,axiom,
    ! [VarCurr] :
      ( v19691(VarCurr)
    <=> ( v19558(VarCurr)
        | v19586(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5204,axiom,
    ! [VarCurr] :
      ( v19688(VarCurr)
    <=> ( v19689(VarCurr)
        | v19690(VarCurr) ) ) ).

fof(writeUnaryOperator_1617,axiom,
    ! [VarCurr] :
      ( ~ v19690(VarCurr)
    <=> v19586(VarCurr) ) ).

fof(writeUnaryOperator_1616,axiom,
    ! [VarCurr] :
      ( ~ v19689(VarCurr)
    <=> v19558(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5203,axiom,
    ! [VarCurr] :
      ( v19682(VarCurr)
    <=> ( v19683(VarCurr)
        & v19686(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5202,axiom,
    ! [VarCurr] :
      ( v19686(VarCurr)
    <=> ( v19556(VarCurr)
        | v19592(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5201,axiom,
    ! [VarCurr] :
      ( v19683(VarCurr)
    <=> ( v19684(VarCurr)
        | v19685(VarCurr) ) ) ).

fof(writeUnaryOperator_1615,axiom,
    ! [VarCurr] :
      ( ~ v19685(VarCurr)
    <=> v19592(VarCurr) ) ).

fof(writeUnaryOperator_1614,axiom,
    ! [VarCurr] :
      ( ~ v19684(VarCurr)
    <=> v19556(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5200,axiom,
    ! [VarCurr] :
      ( v19677(VarCurr)
    <=> ( v19678(VarCurr)
        & v19681(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5199,axiom,
    ! [VarCurr] :
      ( v19681(VarCurr)
    <=> ( v19554(VarCurr)
        | v19598(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5198,axiom,
    ! [VarCurr] :
      ( v19678(VarCurr)
    <=> ( v19679(VarCurr)
        | v19680(VarCurr) ) ) ).

fof(writeUnaryOperator_1613,axiom,
    ! [VarCurr] :
      ( ~ v19680(VarCurr)
    <=> v19598(VarCurr) ) ).

fof(writeUnaryOperator_1612,axiom,
    ! [VarCurr] :
      ( ~ v19679(VarCurr)
    <=> v19554(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5197,axiom,
    ! [VarCurr] :
      ( v19672(VarCurr)
    <=> ( v19673(VarCurr)
        & v19676(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5196,axiom,
    ! [VarCurr] :
      ( v19676(VarCurr)
    <=> ( v19552(VarCurr)
        | v19604(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5195,axiom,
    ! [VarCurr] :
      ( v19673(VarCurr)
    <=> ( v19674(VarCurr)
        | v19675(VarCurr) ) ) ).

fof(writeUnaryOperator_1611,axiom,
    ! [VarCurr] :
      ( ~ v19675(VarCurr)
    <=> v19604(VarCurr) ) ).

fof(writeUnaryOperator_1610,axiom,
    ! [VarCurr] :
      ( ~ v19674(VarCurr)
    <=> v19552(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5194,axiom,
    ! [VarCurr] :
      ( v19667(VarCurr)
    <=> ( v19668(VarCurr)
        & v19671(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5193,axiom,
    ! [VarCurr] :
      ( v19671(VarCurr)
    <=> ( v19550(VarCurr)
        | v19610(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5192,axiom,
    ! [VarCurr] :
      ( v19668(VarCurr)
    <=> ( v19669(VarCurr)
        | v19670(VarCurr) ) ) ).

fof(writeUnaryOperator_1609,axiom,
    ! [VarCurr] :
      ( ~ v19670(VarCurr)
    <=> v19610(VarCurr) ) ).

fof(writeUnaryOperator_1608,axiom,
    ! [VarCurr] :
      ( ~ v19669(VarCurr)
    <=> v19550(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5191,axiom,
    ! [VarCurr] :
      ( v19662(VarCurr)
    <=> ( v19663(VarCurr)
        & v19666(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5190,axiom,
    ! [VarCurr] :
      ( v19666(VarCurr)
    <=> ( v19548(VarCurr)
        | v19616(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5189,axiom,
    ! [VarCurr] :
      ( v19663(VarCurr)
    <=> ( v19664(VarCurr)
        | v19665(VarCurr) ) ) ).

fof(writeUnaryOperator_1607,axiom,
    ! [VarCurr] :
      ( ~ v19665(VarCurr)
    <=> v19616(VarCurr) ) ).

fof(writeUnaryOperator_1606,axiom,
    ! [VarCurr] :
      ( ~ v19664(VarCurr)
    <=> v19548(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5188,axiom,
    ! [VarCurr] :
      ( v19657(VarCurr)
    <=> ( v19658(VarCurr)
        & v19661(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5187,axiom,
    ! [VarCurr] :
      ( v19661(VarCurr)
    <=> ( v19546(VarCurr)
        | v19622(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5186,axiom,
    ! [VarCurr] :
      ( v19658(VarCurr)
    <=> ( v19659(VarCurr)
        | v19660(VarCurr) ) ) ).

fof(writeUnaryOperator_1605,axiom,
    ! [VarCurr] :
      ( ~ v19660(VarCurr)
    <=> v19622(VarCurr) ) ).

fof(writeUnaryOperator_1604,axiom,
    ! [VarCurr] :
      ( ~ v19659(VarCurr)
    <=> v19546(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5185,axiom,
    ! [VarCurr] :
      ( v19652(VarCurr)
    <=> ( v19653(VarCurr)
        & v19656(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5184,axiom,
    ! [VarCurr] :
      ( v19656(VarCurr)
    <=> ( v19544(VarCurr)
        | v19628(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5183,axiom,
    ! [VarCurr] :
      ( v19653(VarCurr)
    <=> ( v19654(VarCurr)
        | v19655(VarCurr) ) ) ).

fof(writeUnaryOperator_1603,axiom,
    ! [VarCurr] :
      ( ~ v19655(VarCurr)
    <=> v19628(VarCurr) ) ).

fof(writeUnaryOperator_1602,axiom,
    ! [VarCurr] :
      ( ~ v19654(VarCurr)
    <=> v19544(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5182,axiom,
    ! [VarCurr] :
      ( v19647(VarCurr)
    <=> ( v19648(VarCurr)
        & v19651(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5181,axiom,
    ! [VarCurr] :
      ( v19651(VarCurr)
    <=> ( v19542(VarCurr)
        | v19634(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5180,axiom,
    ! [VarCurr] :
      ( v19648(VarCurr)
    <=> ( v19649(VarCurr)
        | v19650(VarCurr) ) ) ).

fof(writeUnaryOperator_1601,axiom,
    ! [VarCurr] :
      ( ~ v19650(VarCurr)
    <=> v19634(VarCurr) ) ).

fof(writeUnaryOperator_1600,axiom,
    ! [VarCurr] :
      ( ~ v19649(VarCurr)
    <=> v19542(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5179,axiom,
    ! [VarCurr] :
      ( v19537(VarCurr)
    <=> ( v19538(VarCurr)
        & v19646(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5178,axiom,
    ! [VarCurr] :
      ( v19646(VarCurr)
    <=> ( v19540(VarCurr)
        | v19641(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5177,axiom,
    ! [VarCurr] :
      ( v19538(VarCurr)
    <=> ( v19539(VarCurr)
        | v19640(VarCurr) ) ) ).

fof(writeUnaryOperator_1599,axiom,
    ! [VarCurr] :
      ( ~ v19640(VarCurr)
    <=> v19641(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5176,axiom,
    ! [VarCurr] :
      ( v19641(VarCurr)
    <=> ( v19642(VarCurr)
        & v19645(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1654,axiom,
    ! [VarCurr] :
      ( v19645(VarCurr)
    <=> ( v19565(VarCurr,bitIndex13)
        | v19566(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5175,axiom,
    ! [VarCurr] :
      ( v19642(VarCurr)
    <=> ( v19643(VarCurr)
        | v19644(VarCurr) ) ) ).

fof(writeUnaryOperator_1598,axiom,
    ! [VarCurr] :
      ( ~ v19644(VarCurr)
    <=> v19566(VarCurr,bitIndex13) ) ).

fof(writeUnaryOperator_1597,axiom,
    ! [VarCurr] :
      ( ~ v19643(VarCurr)
    <=> v19565(VarCurr,bitIndex13) ) ).

fof(writeUnaryOperator_1596,axiom,
    ! [VarCurr] :
      ( ~ v19539(VarCurr)
    <=> v19540(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5174,axiom,
    ! [VarCurr] :
      ( v19540(VarCurr)
    <=> ( v19541(VarCurr)
        | v19639(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1653,axiom,
    ! [VarCurr] :
      ( v19639(VarCurr)
    <=> ( v19565(VarCurr,bitIndex12)
        & v19566(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5173,axiom,
    ! [VarCurr] :
      ( v19541(VarCurr)
    <=> ( v19542(VarCurr)
        & v19634(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5172,axiom,
    ! [VarCurr] :
      ( v19634(VarCurr)
    <=> ( v19635(VarCurr)
        & v19638(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1652,axiom,
    ! [VarCurr] :
      ( v19638(VarCurr)
    <=> ( v19565(VarCurr,bitIndex12)
        | v19566(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5171,axiom,
    ! [VarCurr] :
      ( v19635(VarCurr)
    <=> ( v19636(VarCurr)
        | v19637(VarCurr) ) ) ).

fof(writeUnaryOperator_1595,axiom,
    ! [VarCurr] :
      ( ~ v19637(VarCurr)
    <=> v19566(VarCurr,bitIndex12) ) ).

fof(writeUnaryOperator_1594,axiom,
    ! [VarCurr] :
      ( ~ v19636(VarCurr)
    <=> v19565(VarCurr,bitIndex12) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5170,axiom,
    ! [VarCurr] :
      ( v19542(VarCurr)
    <=> ( v19543(VarCurr)
        | v19633(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1651,axiom,
    ! [VarCurr] :
      ( v19633(VarCurr)
    <=> ( v19565(VarCurr,bitIndex11)
        & v19566(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5169,axiom,
    ! [VarCurr] :
      ( v19543(VarCurr)
    <=> ( v19544(VarCurr)
        & v19628(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5168,axiom,
    ! [VarCurr] :
      ( v19628(VarCurr)
    <=> ( v19629(VarCurr)
        & v19632(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1650,axiom,
    ! [VarCurr] :
      ( v19632(VarCurr)
    <=> ( v19565(VarCurr,bitIndex11)
        | v19566(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5167,axiom,
    ! [VarCurr] :
      ( v19629(VarCurr)
    <=> ( v19630(VarCurr)
        | v19631(VarCurr) ) ) ).

fof(writeUnaryOperator_1593,axiom,
    ! [VarCurr] :
      ( ~ v19631(VarCurr)
    <=> v19566(VarCurr,bitIndex11) ) ).

fof(writeUnaryOperator_1592,axiom,
    ! [VarCurr] :
      ( ~ v19630(VarCurr)
    <=> v19565(VarCurr,bitIndex11) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5166,axiom,
    ! [VarCurr] :
      ( v19544(VarCurr)
    <=> ( v19545(VarCurr)
        | v19627(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1649,axiom,
    ! [VarCurr] :
      ( v19627(VarCurr)
    <=> ( v19565(VarCurr,bitIndex10)
        & v19566(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5165,axiom,
    ! [VarCurr] :
      ( v19545(VarCurr)
    <=> ( v19546(VarCurr)
        & v19622(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5164,axiom,
    ! [VarCurr] :
      ( v19622(VarCurr)
    <=> ( v19623(VarCurr)
        & v19626(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1648,axiom,
    ! [VarCurr] :
      ( v19626(VarCurr)
    <=> ( v19565(VarCurr,bitIndex10)
        | v19566(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5163,axiom,
    ! [VarCurr] :
      ( v19623(VarCurr)
    <=> ( v19624(VarCurr)
        | v19625(VarCurr) ) ) ).

fof(writeUnaryOperator_1591,axiom,
    ! [VarCurr] :
      ( ~ v19625(VarCurr)
    <=> v19566(VarCurr,bitIndex10) ) ).

fof(writeUnaryOperator_1590,axiom,
    ! [VarCurr] :
      ( ~ v19624(VarCurr)
    <=> v19565(VarCurr,bitIndex10) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5162,axiom,
    ! [VarCurr] :
      ( v19546(VarCurr)
    <=> ( v19547(VarCurr)
        | v19621(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1647,axiom,
    ! [VarCurr] :
      ( v19621(VarCurr)
    <=> ( v19565(VarCurr,bitIndex9)
        & v19566(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5161,axiom,
    ! [VarCurr] :
      ( v19547(VarCurr)
    <=> ( v19548(VarCurr)
        & v19616(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5160,axiom,
    ! [VarCurr] :
      ( v19616(VarCurr)
    <=> ( v19617(VarCurr)
        & v19620(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1646,axiom,
    ! [VarCurr] :
      ( v19620(VarCurr)
    <=> ( v19565(VarCurr,bitIndex9)
        | v19566(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5159,axiom,
    ! [VarCurr] :
      ( v19617(VarCurr)
    <=> ( v19618(VarCurr)
        | v19619(VarCurr) ) ) ).

fof(writeUnaryOperator_1589,axiom,
    ! [VarCurr] :
      ( ~ v19619(VarCurr)
    <=> v19566(VarCurr,bitIndex9) ) ).

fof(writeUnaryOperator_1588,axiom,
    ! [VarCurr] :
      ( ~ v19618(VarCurr)
    <=> v19565(VarCurr,bitIndex9) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5158,axiom,
    ! [VarCurr] :
      ( v19548(VarCurr)
    <=> ( v19549(VarCurr)
        | v19615(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1645,axiom,
    ! [VarCurr] :
      ( v19615(VarCurr)
    <=> ( v19565(VarCurr,bitIndex8)
        & v19566(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5157,axiom,
    ! [VarCurr] :
      ( v19549(VarCurr)
    <=> ( v19550(VarCurr)
        & v19610(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5156,axiom,
    ! [VarCurr] :
      ( v19610(VarCurr)
    <=> ( v19611(VarCurr)
        & v19614(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1644,axiom,
    ! [VarCurr] :
      ( v19614(VarCurr)
    <=> ( v19565(VarCurr,bitIndex8)
        | v19566(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5155,axiom,
    ! [VarCurr] :
      ( v19611(VarCurr)
    <=> ( v19612(VarCurr)
        | v19613(VarCurr) ) ) ).

fof(writeUnaryOperator_1587,axiom,
    ! [VarCurr] :
      ( ~ v19613(VarCurr)
    <=> v19566(VarCurr,bitIndex8) ) ).

fof(writeUnaryOperator_1586,axiom,
    ! [VarCurr] :
      ( ~ v19612(VarCurr)
    <=> v19565(VarCurr,bitIndex8) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5154,axiom,
    ! [VarCurr] :
      ( v19550(VarCurr)
    <=> ( v19551(VarCurr)
        | v19609(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1643,axiom,
    ! [VarCurr] :
      ( v19609(VarCurr)
    <=> ( v19565(VarCurr,bitIndex7)
        & v19566(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5153,axiom,
    ! [VarCurr] :
      ( v19551(VarCurr)
    <=> ( v19552(VarCurr)
        & v19604(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5152,axiom,
    ! [VarCurr] :
      ( v19604(VarCurr)
    <=> ( v19605(VarCurr)
        & v19608(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1642,axiom,
    ! [VarCurr] :
      ( v19608(VarCurr)
    <=> ( v19565(VarCurr,bitIndex7)
        | v19566(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5151,axiom,
    ! [VarCurr] :
      ( v19605(VarCurr)
    <=> ( v19606(VarCurr)
        | v19607(VarCurr) ) ) ).

fof(writeUnaryOperator_1585,axiom,
    ! [VarCurr] :
      ( ~ v19607(VarCurr)
    <=> v19566(VarCurr,bitIndex7) ) ).

fof(writeUnaryOperator_1584,axiom,
    ! [VarCurr] :
      ( ~ v19606(VarCurr)
    <=> v19565(VarCurr,bitIndex7) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5150,axiom,
    ! [VarCurr] :
      ( v19552(VarCurr)
    <=> ( v19553(VarCurr)
        | v19603(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1641,axiom,
    ! [VarCurr] :
      ( v19603(VarCurr)
    <=> ( v19565(VarCurr,bitIndex6)
        & v19566(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5149,axiom,
    ! [VarCurr] :
      ( v19553(VarCurr)
    <=> ( v19554(VarCurr)
        & v19598(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5148,axiom,
    ! [VarCurr] :
      ( v19598(VarCurr)
    <=> ( v19599(VarCurr)
        & v19602(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1640,axiom,
    ! [VarCurr] :
      ( v19602(VarCurr)
    <=> ( v19565(VarCurr,bitIndex6)
        | v19566(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5147,axiom,
    ! [VarCurr] :
      ( v19599(VarCurr)
    <=> ( v19600(VarCurr)
        | v19601(VarCurr) ) ) ).

fof(writeUnaryOperator_1583,axiom,
    ! [VarCurr] :
      ( ~ v19601(VarCurr)
    <=> v19566(VarCurr,bitIndex6) ) ).

fof(writeUnaryOperator_1582,axiom,
    ! [VarCurr] :
      ( ~ v19600(VarCurr)
    <=> v19565(VarCurr,bitIndex6) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5146,axiom,
    ! [VarCurr] :
      ( v19554(VarCurr)
    <=> ( v19555(VarCurr)
        | v19597(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1639,axiom,
    ! [VarCurr] :
      ( v19597(VarCurr)
    <=> ( v19565(VarCurr,bitIndex5)
        & v19566(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5145,axiom,
    ! [VarCurr] :
      ( v19555(VarCurr)
    <=> ( v19556(VarCurr)
        & v19592(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5144,axiom,
    ! [VarCurr] :
      ( v19592(VarCurr)
    <=> ( v19593(VarCurr)
        & v19596(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1638,axiom,
    ! [VarCurr] :
      ( v19596(VarCurr)
    <=> ( v19565(VarCurr,bitIndex5)
        | v19566(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5143,axiom,
    ! [VarCurr] :
      ( v19593(VarCurr)
    <=> ( v19594(VarCurr)
        | v19595(VarCurr) ) ) ).

fof(writeUnaryOperator_1581,axiom,
    ! [VarCurr] :
      ( ~ v19595(VarCurr)
    <=> v19566(VarCurr,bitIndex5) ) ).

fof(writeUnaryOperator_1580,axiom,
    ! [VarCurr] :
      ( ~ v19594(VarCurr)
    <=> v19565(VarCurr,bitIndex5) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5142,axiom,
    ! [VarCurr] :
      ( v19556(VarCurr)
    <=> ( v19557(VarCurr)
        | v19591(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1637,axiom,
    ! [VarCurr] :
      ( v19591(VarCurr)
    <=> ( v19565(VarCurr,bitIndex4)
        & v19566(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5141,axiom,
    ! [VarCurr] :
      ( v19557(VarCurr)
    <=> ( v19558(VarCurr)
        & v19586(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5140,axiom,
    ! [VarCurr] :
      ( v19586(VarCurr)
    <=> ( v19587(VarCurr)
        & v19590(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1636,axiom,
    ! [VarCurr] :
      ( v19590(VarCurr)
    <=> ( v19565(VarCurr,bitIndex4)
        | v19566(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5139,axiom,
    ! [VarCurr] :
      ( v19587(VarCurr)
    <=> ( v19588(VarCurr)
        | v19589(VarCurr) ) ) ).

fof(writeUnaryOperator_1579,axiom,
    ! [VarCurr] :
      ( ~ v19589(VarCurr)
    <=> v19566(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_1578,axiom,
    ! [VarCurr] :
      ( ~ v19588(VarCurr)
    <=> v19565(VarCurr,bitIndex4) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5138,axiom,
    ! [VarCurr] :
      ( v19558(VarCurr)
    <=> ( v19559(VarCurr)
        | v19585(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1635,axiom,
    ! [VarCurr] :
      ( v19585(VarCurr)
    <=> ( v19565(VarCurr,bitIndex3)
        & v19566(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5137,axiom,
    ! [VarCurr] :
      ( v19559(VarCurr)
    <=> ( v19560(VarCurr)
        & v19580(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5136,axiom,
    ! [VarCurr] :
      ( v19580(VarCurr)
    <=> ( v19581(VarCurr)
        & v19584(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1634,axiom,
    ! [VarCurr] :
      ( v19584(VarCurr)
    <=> ( v19565(VarCurr,bitIndex3)
        | v19566(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5135,axiom,
    ! [VarCurr] :
      ( v19581(VarCurr)
    <=> ( v19582(VarCurr)
        | v19583(VarCurr) ) ) ).

fof(writeUnaryOperator_1577,axiom,
    ! [VarCurr] :
      ( ~ v19583(VarCurr)
    <=> v19566(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_1576,axiom,
    ! [VarCurr] :
      ( ~ v19582(VarCurr)
    <=> v19565(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5134,axiom,
    ! [VarCurr] :
      ( v19560(VarCurr)
    <=> ( v19561(VarCurr)
        | v19579(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1633,axiom,
    ! [VarCurr] :
      ( v19579(VarCurr)
    <=> ( v19565(VarCurr,bitIndex2)
        & v19566(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5133,axiom,
    ! [VarCurr] :
      ( v19561(VarCurr)
    <=> ( v19562(VarCurr)
        & v19574(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5132,axiom,
    ! [VarCurr] :
      ( v19574(VarCurr)
    <=> ( v19575(VarCurr)
        & v19578(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1632,axiom,
    ! [VarCurr] :
      ( v19578(VarCurr)
    <=> ( v19565(VarCurr,bitIndex2)
        | v19566(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5131,axiom,
    ! [VarCurr] :
      ( v19575(VarCurr)
    <=> ( v19576(VarCurr)
        | v19577(VarCurr) ) ) ).

fof(writeUnaryOperator_1575,axiom,
    ! [VarCurr] :
      ( ~ v19577(VarCurr)
    <=> v19566(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_1574,axiom,
    ! [VarCurr] :
      ( ~ v19576(VarCurr)
    <=> v19565(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5130,axiom,
    ! [VarCurr] :
      ( v19562(VarCurr)
    <=> ( v19563(VarCurr)
        | v19573(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1631,axiom,
    ! [VarCurr] :
      ( v19573(VarCurr)
    <=> ( v19565(VarCurr,bitIndex1)
        & v19566(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5129,axiom,
    ! [VarCurr] :
      ( v19563(VarCurr)
    <=> ( v19564(VarCurr)
        & v19568(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5128,axiom,
    ! [VarCurr] :
      ( v19568(VarCurr)
    <=> ( v19569(VarCurr)
        & v19572(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1630,axiom,
    ! [VarCurr] :
      ( v19572(VarCurr)
    <=> ( v19565(VarCurr,bitIndex1)
        | v19566(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5127,axiom,
    ! [VarCurr] :
      ( v19569(VarCurr)
    <=> ( v19570(VarCurr)
        | v19571(VarCurr) ) ) ).

fof(writeUnaryOperator_1573,axiom,
    ! [VarCurr] :
      ( ~ v19571(VarCurr)
    <=> v19566(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_1572,axiom,
    ! [VarCurr] :
      ( ~ v19570(VarCurr)
    <=> v19565(VarCurr,bitIndex1) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5126,axiom,
    ! [VarCurr] :
      ( v19564(VarCurr)
    <=> ( v19565(VarCurr,bitIndex0)
        & v19566(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_3075,axiom,
    ! [VarCurr,B] :
      ( range_12_0(B)
     => ( v19566(VarCurr,B)
      <=> v19567(VarCurr,B) ) ) ).

fof(addAssignment_3074,axiom,
    ! [VarCurr] :
      ( v19566(VarCurr,bitIndex13)
    <=> $false ) ).

fof(writeUnaryOperator_1571,axiom,
    ! [VarCurr,B] :
      ( range_12_0(B)
     => ( v19567(VarCurr,B)
      <=> ~ v12870(VarCurr,B) ) ) ).

fof(addAssignment_3073,axiom,
    ! [VarCurr] :
      ( ( v19565(VarCurr,bitIndex12)
      <=> v12798(VarCurr,bitIndex16) )
      & ( v19565(VarCurr,bitIndex11)
      <=> v12798(VarCurr,bitIndex15) )
      & ( v19565(VarCurr,bitIndex10)
      <=> v12798(VarCurr,bitIndex14) )
      & ( v19565(VarCurr,bitIndex9)
      <=> v12798(VarCurr,bitIndex13) )
      & ( v19565(VarCurr,bitIndex8)
      <=> v12798(VarCurr,bitIndex12) )
      & ( v19565(VarCurr,bitIndex7)
      <=> v12798(VarCurr,bitIndex11) )
      & ( v19565(VarCurr,bitIndex6)
      <=> v12798(VarCurr,bitIndex10) )
      & ( v19565(VarCurr,bitIndex5)
      <=> v12798(VarCurr,bitIndex9) )
      & ( v19565(VarCurr,bitIndex4)
      <=> v12798(VarCurr,bitIndex8) )
      & ( v19565(VarCurr,bitIndex3)
      <=> v12798(VarCurr,bitIndex7) )
      & ( v19565(VarCurr,bitIndex2)
      <=> v12798(VarCurr,bitIndex6) )
      & ( v19565(VarCurr,bitIndex1)
      <=> v12798(VarCurr,bitIndex5) )
      & ( v19565(VarCurr,bitIndex0)
      <=> v12798(VarCurr,bitIndex4) ) ) ).

fof(addAssignment_3072,axiom,
    ! [VarCurr] :
      ( v19565(VarCurr,bitIndex13)
    <=> $false ) ).

fof(addAssignment_3071,axiom,
    ! [VarCurr,B] :
      ( range_16_4(B)
     => ( v12798(VarCurr,B)
      <=> v12800(VarCurr,B) ) ) ).

fof(addAssignment_3070,axiom,
    ! [VarNext,B] :
      ( range_16_4(B)
     => ( v12800(VarNext,B)
      <=> v19528(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_176,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19529(VarNext)
       => ! [B] :
            ( range_16_0(B)
           => ( v19528(VarNext,B)
            <=> v12800(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_743,axiom,
    ! [VarNext] :
      ( v19529(VarNext)
     => ! [B] :
          ( range_16_0(B)
         => ( v19528(VarNext,B)
          <=> v18789(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5125,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19529(VarNext)
      <=> v19530(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5124,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19530(VarNext)
      <=> ( v19532(VarNext)
          & v18777(VarNext) ) ) ) ).

fof(writeUnaryOperator_1570,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19532(VarNext)
      <=> v18784(VarNext) ) ) ).

fof(addAssignment_3069,axiom,
    ! [VarCurr,B] :
      ( range_16_4(B)
     => ( v12802(VarCurr,B)
      <=> v18770(VarCurr,B) ) ) ).

fof(addAssignment_3068,axiom,
    ! [VarCurr,B] :
      ( range_16_4(B)
     => ( v18495(VarCurr,B)
      <=> v18497(VarCurr,B) ) ) ).

fof(range_axiom_80,axiom,
    ! [B] :
      ( range_16_4(B)
    <=> ( $false
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B ) ) ).

fof(addAssignment_3067,axiom,
    ! [VarCurr] :
      ( ( v18497(VarCurr,bitIndex16)
      <=> v18569(VarCurr,bitIndex15) )
      & ( v18497(VarCurr,bitIndex15)
      <=> v18569(VarCurr,bitIndex14) )
      & ( v18497(VarCurr,bitIndex14)
      <=> v18569(VarCurr,bitIndex13) )
      & ( v18497(VarCurr,bitIndex13)
      <=> v18569(VarCurr,bitIndex12) )
      & ( v18497(VarCurr,bitIndex12)
      <=> v18569(VarCurr,bitIndex11) )
      & ( v18497(VarCurr,bitIndex11)
      <=> v18569(VarCurr,bitIndex10) )
      & ( v18497(VarCurr,bitIndex10)
      <=> v18569(VarCurr,bitIndex9) )
      & ( v18497(VarCurr,bitIndex9)
      <=> v18569(VarCurr,bitIndex8) )
      & ( v18497(VarCurr,bitIndex8)
      <=> v18569(VarCurr,bitIndex7) )
      & ( v18497(VarCurr,bitIndex7)
      <=> v18569(VarCurr,bitIndex6) )
      & ( v18497(VarCurr,bitIndex6)
      <=> v18569(VarCurr,bitIndex5) )
      & ( v18497(VarCurr,bitIndex5)
      <=> v18569(VarCurr,bitIndex4) )
      & ( v18497(VarCurr,bitIndex4)
      <=> v18569(VarCurr,bitIndex3) ) ) ).

fof(addAssignment_3066,axiom,
    ! [VarCurr] :
      ( v18499(VarCurr,bitIndex16)
    <=> v18501(VarCurr,bitIndex16) ) ).

fof(addAssignment_3065,axiom,
    ! [VarNext] :
      ( v18501(VarNext,bitIndex16)
    <=> v19520(VarNext,bitIndex16) ) ).

fof(addCaseBooleanConditionEqualRanges1_175,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19521(VarNext)
       => ! [B] :
            ( range_16_0(B)
           => ( v19520(VarNext,B)
            <=> v18501(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_742,axiom,
    ! [VarNext] :
      ( v19521(VarNext)
     => ! [B] :
          ( range_16_0(B)
         => ( v19520(VarNext,B)
          <=> v18550(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5123,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19521(VarNext)
      <=> v19522(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5122,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19522(VarNext)
      <=> ( v19524(VarNext)
          & v18538(VarNext) ) ) ) ).

fof(writeUnaryOperator_1569,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19524(VarNext)
      <=> v18545(VarNext) ) ) ).

fof(addAssignment_3064,axiom,
    ! [VarCurr] :
      ( v18503(VarCurr,bitIndex16)
    <=> v18529(VarCurr,bitIndex16) ) ).

fof(addAssignment_3063,axiom,
    ! [VarCurr] :
      ( v18509(VarCurr,bitIndex16)
    <=> v18511(VarCurr,bitIndex16) ) ).

fof(addAssignment_3062,axiom,
    ! [VarCurr] :
      ( v18511(VarCurr,bitIndex16)
    <=> v18526(VarCurr,bitIndex16) ) ).

fof(addAssignment_3061,axiom,
    ! [VarCurr] :
      ( v18499(VarCurr,bitIndex15)
    <=> v18501(VarCurr,bitIndex15) ) ).

fof(addAssignment_3060,axiom,
    ! [VarNext] :
      ( v18501(VarNext,bitIndex15)
    <=> v19512(VarNext,bitIndex15) ) ).

fof(addCaseBooleanConditionEqualRanges1_174,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19513(VarNext)
       => ! [B] :
            ( range_16_0(B)
           => ( v19512(VarNext,B)
            <=> v18501(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_741,axiom,
    ! [VarNext] :
      ( v19513(VarNext)
     => ! [B] :
          ( range_16_0(B)
         => ( v19512(VarNext,B)
          <=> v18550(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5121,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19513(VarNext)
      <=> v19514(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5120,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19514(VarNext)
      <=> ( v19516(VarNext)
          & v18538(VarNext) ) ) ) ).

fof(writeUnaryOperator_1568,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19516(VarNext)
      <=> v18545(VarNext) ) ) ).

fof(addAssignment_3059,axiom,
    ! [VarCurr] :
      ( v18503(VarCurr,bitIndex15)
    <=> v18529(VarCurr,bitIndex15) ) ).

fof(addAssignment_3058,axiom,
    ! [VarCurr] :
      ( v18509(VarCurr,bitIndex15)
    <=> v18511(VarCurr,bitIndex15) ) ).

fof(addAssignment_3057,axiom,
    ! [VarCurr] :
      ( v18511(VarCurr,bitIndex15)
    <=> v18526(VarCurr,bitIndex15) ) ).

fof(addAssignment_3056,axiom,
    ! [VarCurr] :
      ( v18499(VarCurr,bitIndex14)
    <=> v18501(VarCurr,bitIndex14) ) ).

fof(addAssignment_3055,axiom,
    ! [VarNext] :
      ( v18501(VarNext,bitIndex14)
    <=> v19504(VarNext,bitIndex14) ) ).

fof(addCaseBooleanConditionEqualRanges1_173,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19505(VarNext)
       => ! [B] :
            ( range_16_0(B)
           => ( v19504(VarNext,B)
            <=> v18501(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_740,axiom,
    ! [VarNext] :
      ( v19505(VarNext)
     => ! [B] :
          ( range_16_0(B)
         => ( v19504(VarNext,B)
          <=> v18550(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5119,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19505(VarNext)
      <=> v19506(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5118,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19506(VarNext)
      <=> ( v19508(VarNext)
          & v18538(VarNext) ) ) ) ).

fof(writeUnaryOperator_1567,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19508(VarNext)
      <=> v18545(VarNext) ) ) ).

fof(addAssignment_3054,axiom,
    ! [VarCurr] :
      ( v18503(VarCurr,bitIndex14)
    <=> v18529(VarCurr,bitIndex14) ) ).

fof(addAssignment_3053,axiom,
    ! [VarCurr] :
      ( v18509(VarCurr,bitIndex14)
    <=> v18511(VarCurr,bitIndex14) ) ).

fof(addAssignment_3052,axiom,
    ! [VarCurr] :
      ( v18511(VarCurr,bitIndex14)
    <=> v18526(VarCurr,bitIndex14) ) ).

fof(addAssignment_3051,axiom,
    ! [VarCurr] :
      ( v18499(VarCurr,bitIndex13)
    <=> v18501(VarCurr,bitIndex13) ) ).

fof(addAssignment_3050,axiom,
    ! [VarNext] :
      ( v18501(VarNext,bitIndex13)
    <=> v19496(VarNext,bitIndex13) ) ).

fof(addCaseBooleanConditionEqualRanges1_172,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19497(VarNext)
       => ! [B] :
            ( range_16_0(B)
           => ( v19496(VarNext,B)
            <=> v18501(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_739,axiom,
    ! [VarNext] :
      ( v19497(VarNext)
     => ! [B] :
          ( range_16_0(B)
         => ( v19496(VarNext,B)
          <=> v18550(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5117,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19497(VarNext)
      <=> v19498(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5116,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19498(VarNext)
      <=> ( v19500(VarNext)
          & v18538(VarNext) ) ) ) ).

fof(writeUnaryOperator_1566,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19500(VarNext)
      <=> v18545(VarNext) ) ) ).

fof(addAssignment_3049,axiom,
    ! [VarCurr] :
      ( v18503(VarCurr,bitIndex13)
    <=> v18529(VarCurr,bitIndex13) ) ).

fof(addAssignment_3048,axiom,
    ! [VarCurr] :
      ( v18509(VarCurr,bitIndex13)
    <=> v18511(VarCurr,bitIndex13) ) ).

fof(addAssignment_3047,axiom,
    ! [VarCurr] :
      ( v18511(VarCurr,bitIndex13)
    <=> v18526(VarCurr,bitIndex13) ) ).

fof(addAssignment_3046,axiom,
    ! [VarCurr] :
      ( v18499(VarCurr,bitIndex12)
    <=> v18501(VarCurr,bitIndex12) ) ).

fof(addAssignment_3045,axiom,
    ! [VarNext] :
      ( v18501(VarNext,bitIndex12)
    <=> v19488(VarNext,bitIndex12) ) ).

fof(addCaseBooleanConditionEqualRanges1_171,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19489(VarNext)
       => ! [B] :
            ( range_16_0(B)
           => ( v19488(VarNext,B)
            <=> v18501(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_738,axiom,
    ! [VarNext] :
      ( v19489(VarNext)
     => ! [B] :
          ( range_16_0(B)
         => ( v19488(VarNext,B)
          <=> v18550(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5115,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19489(VarNext)
      <=> v19490(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5114,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19490(VarNext)
      <=> ( v19492(VarNext)
          & v18538(VarNext) ) ) ) ).

fof(writeUnaryOperator_1565,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19492(VarNext)
      <=> v18545(VarNext) ) ) ).

fof(addAssignment_3044,axiom,
    ! [VarCurr] :
      ( v18503(VarCurr,bitIndex12)
    <=> v18529(VarCurr,bitIndex12) ) ).

fof(addAssignment_3043,axiom,
    ! [VarCurr] :
      ( v18509(VarCurr,bitIndex12)
    <=> v18511(VarCurr,bitIndex12) ) ).

fof(addAssignment_3042,axiom,
    ! [VarCurr] :
      ( v18511(VarCurr,bitIndex12)
    <=> v18526(VarCurr,bitIndex12) ) ).

fof(addAssignment_3041,axiom,
    ! [VarCurr] :
      ( v18499(VarCurr,bitIndex11)
    <=> v18501(VarCurr,bitIndex11) ) ).

fof(addAssignment_3040,axiom,
    ! [VarNext] :
      ( v18501(VarNext,bitIndex11)
    <=> v19480(VarNext,bitIndex11) ) ).

fof(addCaseBooleanConditionEqualRanges1_170,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19481(VarNext)
       => ! [B] :
            ( range_16_0(B)
           => ( v19480(VarNext,B)
            <=> v18501(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_737,axiom,
    ! [VarNext] :
      ( v19481(VarNext)
     => ! [B] :
          ( range_16_0(B)
         => ( v19480(VarNext,B)
          <=> v18550(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5113,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19481(VarNext)
      <=> v19482(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5112,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19482(VarNext)
      <=> ( v19484(VarNext)
          & v18538(VarNext) ) ) ) ).

fof(writeUnaryOperator_1564,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19484(VarNext)
      <=> v18545(VarNext) ) ) ).

fof(addAssignment_3039,axiom,
    ! [VarCurr] :
      ( v18503(VarCurr,bitIndex11)
    <=> v18529(VarCurr,bitIndex11) ) ).

fof(addAssignment_3038,axiom,
    ! [VarCurr] :
      ( v18509(VarCurr,bitIndex11)
    <=> v18511(VarCurr,bitIndex11) ) ).

fof(addAssignment_3037,axiom,
    ! [VarCurr] :
      ( v18511(VarCurr,bitIndex11)
    <=> v18526(VarCurr,bitIndex11) ) ).

fof(addAssignment_3036,axiom,
    ! [VarCurr] :
      ( v18499(VarCurr,bitIndex10)
    <=> v18501(VarCurr,bitIndex10) ) ).

fof(addAssignment_3035,axiom,
    ! [VarNext] :
      ( v18501(VarNext,bitIndex10)
    <=> v19472(VarNext,bitIndex10) ) ).

fof(addCaseBooleanConditionEqualRanges1_169,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19473(VarNext)
       => ! [B] :
            ( range_16_0(B)
           => ( v19472(VarNext,B)
            <=> v18501(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_736,axiom,
    ! [VarNext] :
      ( v19473(VarNext)
     => ! [B] :
          ( range_16_0(B)
         => ( v19472(VarNext,B)
          <=> v18550(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5111,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19473(VarNext)
      <=> v19474(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5110,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19474(VarNext)
      <=> ( v19476(VarNext)
          & v18538(VarNext) ) ) ) ).

fof(writeUnaryOperator_1563,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19476(VarNext)
      <=> v18545(VarNext) ) ) ).

fof(addAssignment_3034,axiom,
    ! [VarCurr] :
      ( v18503(VarCurr,bitIndex10)
    <=> v18529(VarCurr,bitIndex10) ) ).

fof(addAssignment_3033,axiom,
    ! [VarCurr] :
      ( v18509(VarCurr,bitIndex10)
    <=> v18511(VarCurr,bitIndex10) ) ).

fof(addAssignment_3032,axiom,
    ! [VarCurr] :
      ( v18511(VarCurr,bitIndex10)
    <=> v18526(VarCurr,bitIndex10) ) ).

fof(addAssignment_3031,axiom,
    ! [VarCurr] :
      ( v18499(VarCurr,bitIndex9)
    <=> v18501(VarCurr,bitIndex9) ) ).

fof(addAssignment_3030,axiom,
    ! [VarNext] :
      ( v18501(VarNext,bitIndex9)
    <=> v19464(VarNext,bitIndex9) ) ).

fof(addCaseBooleanConditionEqualRanges1_168,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19465(VarNext)
       => ! [B] :
            ( range_16_0(B)
           => ( v19464(VarNext,B)
            <=> v18501(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_735,axiom,
    ! [VarNext] :
      ( v19465(VarNext)
     => ! [B] :
          ( range_16_0(B)
         => ( v19464(VarNext,B)
          <=> v18550(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5109,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19465(VarNext)
      <=> v19466(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5108,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19466(VarNext)
      <=> ( v19468(VarNext)
          & v18538(VarNext) ) ) ) ).

fof(writeUnaryOperator_1562,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19468(VarNext)
      <=> v18545(VarNext) ) ) ).

fof(addAssignment_3029,axiom,
    ! [VarCurr] :
      ( v18503(VarCurr,bitIndex9)
    <=> v18529(VarCurr,bitIndex9) ) ).

fof(addAssignment_3028,axiom,
    ! [VarCurr] :
      ( v18509(VarCurr,bitIndex9)
    <=> v18511(VarCurr,bitIndex9) ) ).

fof(addAssignment_3027,axiom,
    ! [VarCurr] :
      ( v18511(VarCurr,bitIndex9)
    <=> v18526(VarCurr,bitIndex9) ) ).

fof(addAssignment_3026,axiom,
    ! [VarCurr] :
      ( v18499(VarCurr,bitIndex8)
    <=> v18501(VarCurr,bitIndex8) ) ).

fof(addAssignment_3025,axiom,
    ! [VarNext] :
      ( v18501(VarNext,bitIndex8)
    <=> v19456(VarNext,bitIndex8) ) ).

fof(addCaseBooleanConditionEqualRanges1_167,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19457(VarNext)
       => ! [B] :
            ( range_16_0(B)
           => ( v19456(VarNext,B)
            <=> v18501(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_734,axiom,
    ! [VarNext] :
      ( v19457(VarNext)
     => ! [B] :
          ( range_16_0(B)
         => ( v19456(VarNext,B)
          <=> v18550(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5107,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19457(VarNext)
      <=> v19458(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5106,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19458(VarNext)
      <=> ( v19460(VarNext)
          & v18538(VarNext) ) ) ) ).

fof(writeUnaryOperator_1561,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19460(VarNext)
      <=> v18545(VarNext) ) ) ).

fof(addAssignment_3024,axiom,
    ! [VarCurr] :
      ( v18503(VarCurr,bitIndex8)
    <=> v18529(VarCurr,bitIndex8) ) ).

fof(addAssignment_3023,axiom,
    ! [VarCurr] :
      ( v18509(VarCurr,bitIndex8)
    <=> v18511(VarCurr,bitIndex8) ) ).

fof(addAssignment_3022,axiom,
    ! [VarCurr] :
      ( v18511(VarCurr,bitIndex8)
    <=> v18526(VarCurr,bitIndex8) ) ).

fof(addAssignment_3021,axiom,
    ! [VarCurr] :
      ( v18499(VarCurr,bitIndex7)
    <=> v18501(VarCurr,bitIndex7) ) ).

fof(addAssignment_3020,axiom,
    ! [VarNext] :
      ( v18501(VarNext,bitIndex7)
    <=> v19448(VarNext,bitIndex7) ) ).

fof(addCaseBooleanConditionEqualRanges1_166,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19449(VarNext)
       => ! [B] :
            ( range_16_0(B)
           => ( v19448(VarNext,B)
            <=> v18501(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_733,axiom,
    ! [VarNext] :
      ( v19449(VarNext)
     => ! [B] :
          ( range_16_0(B)
         => ( v19448(VarNext,B)
          <=> v18550(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5105,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19449(VarNext)
      <=> v19450(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5104,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19450(VarNext)
      <=> ( v19452(VarNext)
          & v18538(VarNext) ) ) ) ).

fof(writeUnaryOperator_1560,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19452(VarNext)
      <=> v18545(VarNext) ) ) ).

fof(addAssignment_3019,axiom,
    ! [VarCurr] :
      ( v18503(VarCurr,bitIndex7)
    <=> v18529(VarCurr,bitIndex7) ) ).

fof(addAssignment_3018,axiom,
    ! [VarCurr] :
      ( v18509(VarCurr,bitIndex7)
    <=> v18511(VarCurr,bitIndex7) ) ).

fof(addAssignment_3017,axiom,
    ! [VarCurr] :
      ( v18511(VarCurr,bitIndex7)
    <=> v18526(VarCurr,bitIndex7) ) ).

fof(addAssignment_3016,axiom,
    ! [VarCurr] :
      ( v18499(VarCurr,bitIndex6)
    <=> v18501(VarCurr,bitIndex6) ) ).

fof(addAssignment_3015,axiom,
    ! [VarNext] :
      ( v18501(VarNext,bitIndex6)
    <=> v19440(VarNext,bitIndex6) ) ).

fof(addCaseBooleanConditionEqualRanges1_165,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19441(VarNext)
       => ! [B] :
            ( range_16_0(B)
           => ( v19440(VarNext,B)
            <=> v18501(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_732,axiom,
    ! [VarNext] :
      ( v19441(VarNext)
     => ! [B] :
          ( range_16_0(B)
         => ( v19440(VarNext,B)
          <=> v18550(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5103,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19441(VarNext)
      <=> v19442(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5102,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19442(VarNext)
      <=> ( v19444(VarNext)
          & v18538(VarNext) ) ) ) ).

fof(writeUnaryOperator_1559,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19444(VarNext)
      <=> v18545(VarNext) ) ) ).

fof(addAssignment_3014,axiom,
    ! [VarCurr] :
      ( v18503(VarCurr,bitIndex6)
    <=> v18529(VarCurr,bitIndex6) ) ).

fof(addAssignment_3013,axiom,
    ! [VarCurr] :
      ( v18509(VarCurr,bitIndex6)
    <=> v18511(VarCurr,bitIndex6) ) ).

fof(addAssignment_3012,axiom,
    ! [VarCurr] :
      ( v18511(VarCurr,bitIndex6)
    <=> v18526(VarCurr,bitIndex6) ) ).

fof(addAssignment_3011,axiom,
    ! [VarCurr] :
      ( v18499(VarCurr,bitIndex5)
    <=> v18501(VarCurr,bitIndex5) ) ).

fof(addAssignment_3010,axiom,
    ! [VarNext] :
      ( v18501(VarNext,bitIndex5)
    <=> v19432(VarNext,bitIndex5) ) ).

fof(addCaseBooleanConditionEqualRanges1_164,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19433(VarNext)
       => ! [B] :
            ( range_16_0(B)
           => ( v19432(VarNext,B)
            <=> v18501(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_731,axiom,
    ! [VarNext] :
      ( v19433(VarNext)
     => ! [B] :
          ( range_16_0(B)
         => ( v19432(VarNext,B)
          <=> v18550(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5101,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19433(VarNext)
      <=> v19434(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5100,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19434(VarNext)
      <=> ( v19436(VarNext)
          & v18538(VarNext) ) ) ) ).

fof(writeUnaryOperator_1558,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19436(VarNext)
      <=> v18545(VarNext) ) ) ).

fof(addAssignment_3009,axiom,
    ! [VarCurr] :
      ( v18503(VarCurr,bitIndex5)
    <=> v18529(VarCurr,bitIndex5) ) ).

fof(addAssignment_3008,axiom,
    ! [VarCurr] :
      ( v18509(VarCurr,bitIndex5)
    <=> v18511(VarCurr,bitIndex5) ) ).

fof(addAssignment_3007,axiom,
    ! [VarCurr] :
      ( v18511(VarCurr,bitIndex5)
    <=> v18526(VarCurr,bitIndex5) ) ).

fof(addAssignment_3006,axiom,
    ! [VarCurr] :
      ( v18499(VarCurr,bitIndex4)
    <=> v18501(VarCurr,bitIndex4) ) ).

fof(addAssignment_3005,axiom,
    ! [VarNext] :
      ( v18501(VarNext,bitIndex4)
    <=> v19424(VarNext,bitIndex4) ) ).

fof(addCaseBooleanConditionEqualRanges1_163,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19425(VarNext)
       => ! [B] :
            ( range_16_0(B)
           => ( v19424(VarNext,B)
            <=> v18501(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_730,axiom,
    ! [VarNext] :
      ( v19425(VarNext)
     => ! [B] :
          ( range_16_0(B)
         => ( v19424(VarNext,B)
          <=> v18550(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5099,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19425(VarNext)
      <=> v19426(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5098,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19426(VarNext)
      <=> ( v19428(VarNext)
          & v18538(VarNext) ) ) ) ).

fof(writeUnaryOperator_1557,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19428(VarNext)
      <=> v18545(VarNext) ) ) ).

fof(addAssignment_3004,axiom,
    ! [VarCurr] :
      ( v18503(VarCurr,bitIndex4)
    <=> v18529(VarCurr,bitIndex4) ) ).

fof(addAssignment_3003,axiom,
    ! [VarCurr] :
      ( v18509(VarCurr,bitIndex4)
    <=> v18511(VarCurr,bitIndex4) ) ).

fof(addAssignment_3002,axiom,
    ! [VarCurr] :
      ( v18511(VarCurr,bitIndex4)
    <=> v18526(VarCurr,bitIndex4) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5097,axiom,
    ! [VarCurr] :
      ( v7751(VarCurr)
    <=> ( v19403(VarCurr)
        | v19411(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5096,axiom,
    ! [VarCurr] :
      ( v19411(VarCurr)
    <=> ( v19412(VarCurr)
        & v7845(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5095,axiom,
    ! [VarCurr] :
      ( v19412(VarCurr)
    <=> ( v19413(VarCurr)
        | v19414(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_1343,axiom,
    ! [VarCurr] :
      ( v19414(VarCurr)
    <=> ( ( v7803(VarCurr,bitIndex1)
        <=> $true )
        & ( v7803(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1342,axiom,
    ! [VarCurr] :
      ( v19413(VarCurr)
    <=> ( ( v7803(VarCurr,bitIndex1)
        <=> $false )
        & ( v7803(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5094,axiom,
    ! [VarCurr] :
      ( v19403(VarCurr)
    <=> ( v19404(VarCurr)
        | v19410(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_1341,axiom,
    ! [VarCurr] :
      ( v19410(VarCurr)
    <=> ( ( v7803(VarCurr,bitIndex1)
        <=> $true )
        & ( v7803(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5093,axiom,
    ! [VarCurr] :
      ( v19404(VarCurr)
    <=> ( v19405(VarCurr)
        | v19409(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_1340,axiom,
    ! [VarCurr] :
      ( v19409(VarCurr)
    <=> ( ( v7803(VarCurr,bitIndex1)
        <=> $false )
        & ( v7803(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5092,axiom,
    ! [VarCurr] :
      ( v19405(VarCurr)
    <=> ( v19406(VarCurr)
        & v7797(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5091,axiom,
    ! [VarCurr] :
      ( v19406(VarCurr)
    <=> ( v19407(VarCurr)
        | v19408(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_1339,axiom,
    ! [VarCurr] :
      ( v19408(VarCurr)
    <=> ( ( v7753(VarCurr,bitIndex1)
        <=> $true )
        & ( v7753(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1338,axiom,
    ! [VarCurr] :
      ( v19407(VarCurr)
    <=> ( ( v7753(VarCurr,bitIndex1)
        <=> $false )
        & ( v7753(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_3001,axiom,
    ! [VarCurr] :
      ( v7845(VarCurr)
    <=> v7847(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_162,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19390(VarNext)
       => ( v7847(VarNext)
        <=> v7847(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_729,axiom,
    ! [VarNext] :
      ( v19390(VarNext)
     => ( v7847(VarNext)
      <=> v19399(VarNext) ) ) ).

fof(addAssignment_3000,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19399(VarNext)
      <=> v7849(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5090,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19390(VarNext)
      <=> v19391(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5089,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19391(VarNext)
      <=> ( v19392(VarNext)
          & v19387(VarNext) ) ) ) ).

fof(writeUnaryOperator_1556,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19392(VarNext)
      <=> v19394(VarNext) ) ) ).

fof(addAssignment_2999,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19394(VarNext)
      <=> v19387(VarCurr) ) ) ).

fof(addAssignment_2998,axiom,
    ! [VarCurr] :
      ( v19387(VarCurr)
    <=> v441(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_28,axiom,
    ! [VarCurr] :
      ( ( ~ v19381(VarCurr)
        & ~ v19383(VarCurr) )
     => ( v7849(VarCurr)
      <=> v7847(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_39,axiom,
    ! [VarCurr] :
      ( v19383(VarCurr)
     => ( v7849(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_42,axiom,
    ! [VarCurr] :
      ( v19381(VarCurr)
     => ( v7849(VarCurr)
      <=> v19250(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_16,axiom,
    ( v7847(constB0)
  <=> $false ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5088,axiom,
    ! [VarCurr] :
      ( v19383(VarCurr)
    <=> ( v19384(VarCurr)
        | v19385(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_1337,axiom,
    ! [VarCurr] :
      ( v19385(VarCurr)
    <=> ( ( v19382(VarCurr,bitIndex1)
        <=> $true )
        & ( v19382(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1336,axiom,
    ! [VarCurr] :
      ( v19384(VarCurr)
    <=> ( ( v19382(VarCurr,bitIndex1)
        <=> $true )
        & ( v19382(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1335,axiom,
    ! [VarCurr] :
      ( v19381(VarCurr)
    <=> ( ( v19382(VarCurr,bitIndex1)
        <=> $false )
        & ( v19382(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2997,axiom,
    ! [VarCurr] :
      ( v19382(VarCurr,bitIndex0)
    <=> v7853(VarCurr) ) ).

fof(addAssignment_2996,axiom,
    ! [VarCurr] :
      ( v19382(VarCurr,bitIndex1)
    <=> v7851(VarCurr) ) ).

fof(addAssignment_2995,axiom,
    ! [VarCurr] :
      ( v19250(VarCurr)
    <=> v19252(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5087,axiom,
    ! [VarCurr] :
      ( v19252(VarCurr)
    <=> ( v19379(VarCurr)
        & v7861(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_1334,axiom,
    ! [VarCurr] :
      ( v19379(VarCurr)
    <=> ( ( v19254(VarCurr,bitIndex15)
        <=> $false )
        & ( v19254(VarCurr,bitIndex14)
        <=> $false )
        & ( v19254(VarCurr,bitIndex13)
        <=> $false )
        & ( v19254(VarCurr,bitIndex12)
        <=> $false )
        & ( v19254(VarCurr,bitIndex11)
        <=> $false )
        & ( v19254(VarCurr,bitIndex10)
        <=> $false )
        & ( v19254(VarCurr,bitIndex9)
        <=> $false )
        & ( v19254(VarCurr,bitIndex8)
        <=> $false )
        & ( v19254(VarCurr,bitIndex7)
        <=> $false )
        & ( v19254(VarCurr,bitIndex6)
        <=> $false )
        & ( v19254(VarCurr,bitIndex5)
        <=> $false )
        & ( v19254(VarCurr,bitIndex4)
        <=> $false )
        & ( v19254(VarCurr,bitIndex3)
        <=> $false )
        & ( v19254(VarCurr,bitIndex2)
        <=> $false )
        & ( v19254(VarCurr,bitIndex1)
        <=> $false )
        & ( v19254(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges4_10,axiom,
    ! [VarCurr] :
      ( ( ~ v19374(VarCurr)
        & ~ v19375(VarCurr)
        & ~ v19376(VarCurr)
        & ~ v19377(VarCurr) )
     => ( ( v19254(VarCurr,bitIndex15)
        <=> v8258(VarCurr,bitIndex31) )
        & ( v19254(VarCurr,bitIndex14)
        <=> v8258(VarCurr,bitIndex30) )
        & ( v19254(VarCurr,bitIndex13)
        <=> v8258(VarCurr,bitIndex29) )
        & ( v19254(VarCurr,bitIndex12)
        <=> v8258(VarCurr,bitIndex28) )
        & ( v19254(VarCurr,bitIndex11)
        <=> v8258(VarCurr,bitIndex27) )
        & ( v19254(VarCurr,bitIndex10)
        <=> v8258(VarCurr,bitIndex26) )
        & ( v19254(VarCurr,bitIndex9)
        <=> v8258(VarCurr,bitIndex25) )
        & ( v19254(VarCurr,bitIndex8)
        <=> v8258(VarCurr,bitIndex24) )
        & ( v19254(VarCurr,bitIndex7)
        <=> v8258(VarCurr,bitIndex23) )
        & ( v19254(VarCurr,bitIndex6)
        <=> v8258(VarCurr,bitIndex22) )
        & ( v19254(VarCurr,bitIndex5)
        <=> v8258(VarCurr,bitIndex21) )
        & ( v19254(VarCurr,bitIndex4)
        <=> v8258(VarCurr,bitIndex20) )
        & ( v19254(VarCurr,bitIndex3)
        <=> v8258(VarCurr,bitIndex19) )
        & ( v19254(VarCurr,bitIndex2)
        <=> v8258(VarCurr,bitIndex18) )
        & ( v19254(VarCurr,bitIndex1)
        <=> v8258(VarCurr,bitIndex17) )
        & ( v19254(VarCurr,bitIndex0)
        <=> v8258(VarCurr,bitIndex16) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges3_11,axiom,
    ! [VarCurr] :
      ( v19377(VarCurr)
     => ( ( v19254(VarCurr,bitIndex15)
        <=> v8258(VarCurr,bitIndex127) )
        & ( v19254(VarCurr,bitIndex14)
        <=> v8258(VarCurr,bitIndex126) )
        & ( v19254(VarCurr,bitIndex13)
        <=> v8258(VarCurr,bitIndex125) )
        & ( v19254(VarCurr,bitIndex12)
        <=> v8258(VarCurr,bitIndex124) )
        & ( v19254(VarCurr,bitIndex11)
        <=> v8258(VarCurr,bitIndex123) )
        & ( v19254(VarCurr,bitIndex10)
        <=> v8258(VarCurr,bitIndex122) )
        & ( v19254(VarCurr,bitIndex9)
        <=> v8258(VarCurr,bitIndex121) )
        & ( v19254(VarCurr,bitIndex8)
        <=> v8258(VarCurr,bitIndex120) )
        & ( v19254(VarCurr,bitIndex7)
        <=> v8258(VarCurr,bitIndex119) )
        & ( v19254(VarCurr,bitIndex6)
        <=> v8258(VarCurr,bitIndex118) )
        & ( v19254(VarCurr,bitIndex5)
        <=> v8258(VarCurr,bitIndex117) )
        & ( v19254(VarCurr,bitIndex4)
        <=> v8258(VarCurr,bitIndex116) )
        & ( v19254(VarCurr,bitIndex3)
        <=> v8258(VarCurr,bitIndex115) )
        & ( v19254(VarCurr,bitIndex2)
        <=> v8258(VarCurr,bitIndex114) )
        & ( v19254(VarCurr,bitIndex1)
        <=> v8258(VarCurr,bitIndex113) )
        & ( v19254(VarCurr,bitIndex0)
        <=> v8258(VarCurr,bitIndex112) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges2_11,axiom,
    ! [VarCurr] :
      ( v19376(VarCurr)
     => ( ( v19254(VarCurr,bitIndex15)
        <=> v8258(VarCurr,bitIndex95) )
        & ( v19254(VarCurr,bitIndex14)
        <=> v8258(VarCurr,bitIndex94) )
        & ( v19254(VarCurr,bitIndex13)
        <=> v8258(VarCurr,bitIndex93) )
        & ( v19254(VarCurr,bitIndex12)
        <=> v8258(VarCurr,bitIndex92) )
        & ( v19254(VarCurr,bitIndex11)
        <=> v8258(VarCurr,bitIndex91) )
        & ( v19254(VarCurr,bitIndex10)
        <=> v8258(VarCurr,bitIndex90) )
        & ( v19254(VarCurr,bitIndex9)
        <=> v8258(VarCurr,bitIndex89) )
        & ( v19254(VarCurr,bitIndex8)
        <=> v8258(VarCurr,bitIndex88) )
        & ( v19254(VarCurr,bitIndex7)
        <=> v8258(VarCurr,bitIndex87) )
        & ( v19254(VarCurr,bitIndex6)
        <=> v8258(VarCurr,bitIndex86) )
        & ( v19254(VarCurr,bitIndex5)
        <=> v8258(VarCurr,bitIndex85) )
        & ( v19254(VarCurr,bitIndex4)
        <=> v8258(VarCurr,bitIndex84) )
        & ( v19254(VarCurr,bitIndex3)
        <=> v8258(VarCurr,bitIndex83) )
        & ( v19254(VarCurr,bitIndex2)
        <=> v8258(VarCurr,bitIndex82) )
        & ( v19254(VarCurr,bitIndex1)
        <=> v8258(VarCurr,bitIndex81) )
        & ( v19254(VarCurr,bitIndex0)
        <=> v8258(VarCurr,bitIndex80) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges1_11,axiom,
    ! [VarCurr] :
      ( v19375(VarCurr)
     => ( ( v19254(VarCurr,bitIndex15)
        <=> v8258(VarCurr,bitIndex63) )
        & ( v19254(VarCurr,bitIndex14)
        <=> v8258(VarCurr,bitIndex62) )
        & ( v19254(VarCurr,bitIndex13)
        <=> v8258(VarCurr,bitIndex61) )
        & ( v19254(VarCurr,bitIndex12)
        <=> v8258(VarCurr,bitIndex60) )
        & ( v19254(VarCurr,bitIndex11)
        <=> v8258(VarCurr,bitIndex59) )
        & ( v19254(VarCurr,bitIndex10)
        <=> v8258(VarCurr,bitIndex58) )
        & ( v19254(VarCurr,bitIndex9)
        <=> v8258(VarCurr,bitIndex57) )
        & ( v19254(VarCurr,bitIndex8)
        <=> v8258(VarCurr,bitIndex56) )
        & ( v19254(VarCurr,bitIndex7)
        <=> v8258(VarCurr,bitIndex55) )
        & ( v19254(VarCurr,bitIndex6)
        <=> v8258(VarCurr,bitIndex54) )
        & ( v19254(VarCurr,bitIndex5)
        <=> v8258(VarCurr,bitIndex53) )
        & ( v19254(VarCurr,bitIndex4)
        <=> v8258(VarCurr,bitIndex52) )
        & ( v19254(VarCurr,bitIndex3)
        <=> v8258(VarCurr,bitIndex51) )
        & ( v19254(VarCurr,bitIndex2)
        <=> v8258(VarCurr,bitIndex50) )
        & ( v19254(VarCurr,bitIndex1)
        <=> v8258(VarCurr,bitIndex49) )
        & ( v19254(VarCurr,bitIndex0)
        <=> v8258(VarCurr,bitIndex48) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_8,axiom,
    ! [VarCurr] :
      ( v19374(VarCurr)
     => ( ( v19254(VarCurr,bitIndex15)
        <=> v8258(VarCurr,bitIndex31) )
        & ( v19254(VarCurr,bitIndex14)
        <=> v8258(VarCurr,bitIndex30) )
        & ( v19254(VarCurr,bitIndex13)
        <=> v8258(VarCurr,bitIndex29) )
        & ( v19254(VarCurr,bitIndex12)
        <=> v8258(VarCurr,bitIndex28) )
        & ( v19254(VarCurr,bitIndex11)
        <=> v8258(VarCurr,bitIndex27) )
        & ( v19254(VarCurr,bitIndex10)
        <=> v8258(VarCurr,bitIndex26) )
        & ( v19254(VarCurr,bitIndex9)
        <=> v8258(VarCurr,bitIndex25) )
        & ( v19254(VarCurr,bitIndex8)
        <=> v8258(VarCurr,bitIndex24) )
        & ( v19254(VarCurr,bitIndex7)
        <=> v8258(VarCurr,bitIndex23) )
        & ( v19254(VarCurr,bitIndex6)
        <=> v8258(VarCurr,bitIndex22) )
        & ( v19254(VarCurr,bitIndex5)
        <=> v8258(VarCurr,bitIndex21) )
        & ( v19254(VarCurr,bitIndex4)
        <=> v8258(VarCurr,bitIndex20) )
        & ( v19254(VarCurr,bitIndex3)
        <=> v8258(VarCurr,bitIndex19) )
        & ( v19254(VarCurr,bitIndex2)
        <=> v8258(VarCurr,bitIndex18) )
        & ( v19254(VarCurr,bitIndex1)
        <=> v8258(VarCurr,bitIndex17) )
        & ( v19254(VarCurr,bitIndex0)
        <=> v8258(VarCurr,bitIndex16) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1333,axiom,
    ! [VarCurr] :
      ( v19377(VarCurr)
    <=> ( ( v19256(VarCurr,bitIndex1)
        <=> $true )
        & ( v19256(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1332,axiom,
    ! [VarCurr] :
      ( v19376(VarCurr)
    <=> ( ( v19256(VarCurr,bitIndex1)
        <=> $true )
        & ( v19256(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1331,axiom,
    ! [VarCurr] :
      ( v19375(VarCurr)
    <=> ( ( v19256(VarCurr,bitIndex1)
        <=> $false )
        & ( v19256(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1330,axiom,
    ! [VarCurr] :
      ( v19374(VarCurr)
    <=> ( ( v19256(VarCurr,bitIndex1)
        <=> $false )
        & ( v19256(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2994,axiom,
    ! [VarCurr,B] :
      ( range_127_116(B)
     => ( v8258(VarCurr,B)
      <=> v8260(VarCurr,B) ) ) ).

fof(addAssignment_2993,axiom,
    ! [VarCurr,B] :
      ( range_127_116(B)
     => ( v8260(VarCurr,B)
      <=> v9317(VarCurr,B) ) ) ).

fof(range_axiom_79,axiom,
    ! [B] :
      ( range_127_116(B)
    <=> ( $false
        | bitIndex116 = B
        | bitIndex117 = B
        | bitIndex118 = B
        | bitIndex119 = B
        | bitIndex120 = B
        | bitIndex121 = B
        | bitIndex122 = B
        | bitIndex123 = B
        | bitIndex124 = B
        | bitIndex125 = B
        | bitIndex126 = B
        | bitIndex127 = B ) ) ).

fof(addAssignment_2992,axiom,
    ! [VarCurr,B] :
      ( range_15_12(B)
     => ( v8262(VarCurr,B)
      <=> v8264(VarCurr,B) ) ) ).

fof(addAssignment_2991,axiom,
    ! [VarNext,B] :
      ( range_15_12(B)
     => ( v8264(VarNext,B)
      <=> v19366(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_161,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19367(VarNext)
       => ! [B] :
            ( range_145_0(B)
           => ( v19366(VarNext,B)
            <=> v8264(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_728,axiom,
    ! [VarNext] :
      ( v19367(VarNext)
     => ! [B] :
          ( range_145_0(B)
         => ( v19366(VarNext,B)
          <=> v8792(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5086,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19367(VarNext)
      <=> v19368(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5085,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19368(VarNext)
      <=> ( v19370(VarNext)
          & v98(VarNext) ) ) ) ).

fof(writeUnaryOperator_1555,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19370(VarNext)
      <=> v7677(VarNext) ) ) ).

fof(addAssignment_2990,axiom,
    ! [VarCurr,B] :
      ( range_15_12(B)
     => ( v1214(VarCurr,B)
      <=> v1216(VarCurr,B) ) ) ).

fof(addAssignment_2989,axiom,
    ! [VarCurr,B] :
      ( range_15_12(B)
     => ( v1216(VarCurr,B)
      <=> v1218(VarCurr,B) ) ) ).

fof(addAssignment_2988,axiom,
    ! [VarCurr,B] :
      ( range_15_12(B)
     => ( v1218(VarCurr,B)
      <=> v1220(VarCurr,B) ) ) ).

fof(addAssignment_2987,axiom,
    ! [VarCurr,B] :
      ( range_15_12(B)
     => ( v1220(VarCurr,B)
      <=> v1222(VarCurr,B) ) ) ).

fof(addAssignment_2986,axiom,
    ! [VarCurr,B] :
      ( range_15_12(B)
     => ( v1222(VarCurr,B)
      <=> v1224(VarCurr,B) ) ) ).

fof(addAssignment_2985,axiom,
    ! [VarCurr,B] :
      ( range_15_12(B)
     => ( v1224(VarCurr,B)
      <=> v1226(VarCurr,B) ) ) ).

fof(addAssignment_2984,axiom,
    ! [VarCurr,B] :
      ( range_15_12(B)
     => ( v1226(VarCurr,B)
      <=> v1228(VarCurr,B) ) ) ).

fof(addAssignment_2983,axiom,
    ! [VarNext,B] :
      ( range_15_12(B)
     => ( v1228(VarNext,B)
      <=> v19364(VarNext,B) ) ) ).

fof(range_axiom_78,axiom,
    ! [B] :
      ( range_15_12(B)
    <=> ( $false
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_184,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3569(VarNext)
       => ! [B] :
            ( range_147_0(B)
           => ( v19364(VarNext,B)
            <=> v1228(VarCurr,B) ) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_202,axiom,
    ! [VarNext] :
      ( v3569(VarNext)
     => ! [B] :
          ( range_147_0(B)
         => ( v19364(VarNext,B)
          <=> v3593(VarNext,B) ) ) ) ).

fof(addAssignment_2982,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v8262(VarCurr,B)
      <=> v8264(VarCurr,B) ) ) ).

fof(addAssignment_2981,axiom,
    ! [VarNext,B] :
      ( range_7_0(B)
     => ( v8264(VarNext,B)
      <=> v19356(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_160,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19357(VarNext)
       => ! [B] :
            ( range_145_0(B)
           => ( v19356(VarNext,B)
            <=> v8264(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_727,axiom,
    ! [VarNext] :
      ( v19357(VarNext)
     => ! [B] :
          ( range_145_0(B)
         => ( v19356(VarNext,B)
          <=> v8792(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5084,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19357(VarNext)
      <=> v19358(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5083,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19358(VarNext)
      <=> ( v19360(VarNext)
          & v98(VarNext) ) ) ) ).

fof(writeUnaryOperator_1554,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19360(VarNext)
      <=> v7677(VarNext) ) ) ).

fof(addAssignment_2980,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v1214(VarCurr,B)
      <=> v1216(VarCurr,B) ) ) ).

fof(addAssignment_2979,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v1216(VarCurr,B)
      <=> v1218(VarCurr,B) ) ) ).

fof(addAssignment_2978,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v1218(VarCurr,B)
      <=> v1220(VarCurr,B) ) ) ).

fof(addAssignment_2977,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v1220(VarCurr,B)
      <=> v1222(VarCurr,B) ) ) ).

fof(addAssignment_2976,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v1222(VarCurr,B)
      <=> v1224(VarCurr,B) ) ) ).

fof(addAssignment_2975,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v1224(VarCurr,B)
      <=> v1226(VarCurr,B) ) ) ).

fof(addAssignment_2974,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v1226(VarCurr,B)
      <=> v1228(VarCurr,B) ) ) ).

fof(addAssignment_2973,axiom,
    ! [VarNext,B] :
      ( range_7_0(B)
     => ( v1228(VarNext,B)
      <=> v19354(VarNext,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_183,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3569(VarNext)
       => ! [B] :
            ( range_147_0(B)
           => ( v19354(VarNext,B)
            <=> v1228(VarCurr,B) ) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_201,axiom,
    ! [VarNext] :
      ( v3569(VarNext)
     => ! [B] :
          ( range_147_0(B)
         => ( v19354(VarNext,B)
          <=> v3593(VarNext,B) ) ) ) ).

fof(addAssignment_2972,axiom,
    ! [VarCurr,B] :
      ( range_95_84(B)
     => ( v8258(VarCurr,B)
      <=> v8260(VarCurr,B) ) ) ).

fof(addAssignment_2971,axiom,
    ! [VarCurr,B] :
      ( range_95_84(B)
     => ( v8260(VarCurr,B)
      <=> v9317(VarCurr,B) ) ) ).

fof(range_axiom_77,axiom,
    ! [B] :
      ( range_95_84(B)
    <=> ( $false
        | bitIndex84 = B
        | bitIndex85 = B
        | bitIndex86 = B
        | bitIndex87 = B
        | bitIndex88 = B
        | bitIndex89 = B
        | bitIndex90 = B
        | bitIndex91 = B
        | bitIndex92 = B
        | bitIndex93 = B
        | bitIndex94 = B
        | bitIndex95 = B ) ) ).

fof(addAssignment_2970,axiom,
    ! [VarCurr,B] :
      ( range_47_44(B)
     => ( v8262(VarCurr,B)
      <=> v8264(VarCurr,B) ) ) ).

fof(addAssignment_2969,axiom,
    ! [VarNext,B] :
      ( range_47_44(B)
     => ( v8264(VarNext,B)
      <=> v19346(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_159,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19347(VarNext)
       => ! [B] :
            ( range_145_0(B)
           => ( v19346(VarNext,B)
            <=> v8264(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_726,axiom,
    ! [VarNext] :
      ( v19347(VarNext)
     => ! [B] :
          ( range_145_0(B)
         => ( v19346(VarNext,B)
          <=> v8792(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5082,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19347(VarNext)
      <=> v19348(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5081,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19348(VarNext)
      <=> ( v19350(VarNext)
          & v98(VarNext) ) ) ) ).

fof(writeUnaryOperator_1553,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19350(VarNext)
      <=> v7677(VarNext) ) ) ).

fof(addAssignment_2968,axiom,
    ! [VarCurr,B] :
      ( range_47_44(B)
     => ( v1214(VarCurr,B)
      <=> v1216(VarCurr,B) ) ) ).

fof(addAssignment_2967,axiom,
    ! [VarCurr,B] :
      ( range_47_44(B)
     => ( v1216(VarCurr,B)
      <=> v1218(VarCurr,B) ) ) ).

fof(addAssignment_2966,axiom,
    ! [VarCurr,B] :
      ( range_47_44(B)
     => ( v1218(VarCurr,B)
      <=> v1220(VarCurr,B) ) ) ).

fof(addAssignment_2965,axiom,
    ! [VarCurr,B] :
      ( range_47_44(B)
     => ( v1220(VarCurr,B)
      <=> v1222(VarCurr,B) ) ) ).

fof(addAssignment_2964,axiom,
    ! [VarCurr,B] :
      ( range_47_44(B)
     => ( v1222(VarCurr,B)
      <=> v1224(VarCurr,B) ) ) ).

fof(addAssignment_2963,axiom,
    ! [VarCurr,B] :
      ( range_47_44(B)
     => ( v1224(VarCurr,B)
      <=> v1226(VarCurr,B) ) ) ).

fof(addAssignment_2962,axiom,
    ! [VarCurr,B] :
      ( range_47_44(B)
     => ( v1226(VarCurr,B)
      <=> v1228(VarCurr,B) ) ) ).

fof(addAssignment_2961,axiom,
    ! [VarNext,B] :
      ( range_47_44(B)
     => ( v1228(VarNext,B)
      <=> v19344(VarNext,B) ) ) ).

fof(range_axiom_76,axiom,
    ! [B] :
      ( range_47_44(B)
    <=> ( $false
        | bitIndex44 = B
        | bitIndex45 = B
        | bitIndex46 = B
        | bitIndex47 = B ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_182,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3569(VarNext)
       => ! [B] :
            ( range_147_0(B)
           => ( v19344(VarNext,B)
            <=> v1228(VarCurr,B) ) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_200,axiom,
    ! [VarNext] :
      ( v3569(VarNext)
     => ! [B] :
          ( range_147_0(B)
         => ( v19344(VarNext,B)
          <=> v3593(VarNext,B) ) ) ) ).

fof(addAssignment_2960,axiom,
    ! [VarCurr,B] :
      ( range_39_32(B)
     => ( v8262(VarCurr,B)
      <=> v8264(VarCurr,B) ) ) ).

fof(addAssignment_2959,axiom,
    ! [VarNext,B] :
      ( range_39_32(B)
     => ( v8264(VarNext,B)
      <=> v19336(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_158,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19337(VarNext)
       => ! [B] :
            ( range_145_0(B)
           => ( v19336(VarNext,B)
            <=> v8264(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_725,axiom,
    ! [VarNext] :
      ( v19337(VarNext)
     => ! [B] :
          ( range_145_0(B)
         => ( v19336(VarNext,B)
          <=> v8792(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5080,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19337(VarNext)
      <=> v19338(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5079,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19338(VarNext)
      <=> ( v19340(VarNext)
          & v98(VarNext) ) ) ) ).

fof(writeUnaryOperator_1552,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19340(VarNext)
      <=> v7677(VarNext) ) ) ).

fof(addAssignment_2958,axiom,
    ! [VarCurr,B] :
      ( range_39_32(B)
     => ( v1214(VarCurr,B)
      <=> v1216(VarCurr,B) ) ) ).

fof(addAssignment_2957,axiom,
    ! [VarCurr,B] :
      ( range_39_32(B)
     => ( v1216(VarCurr,B)
      <=> v1218(VarCurr,B) ) ) ).

fof(addAssignment_2956,axiom,
    ! [VarCurr,B] :
      ( range_39_32(B)
     => ( v1218(VarCurr,B)
      <=> v1220(VarCurr,B) ) ) ).

fof(addAssignment_2955,axiom,
    ! [VarCurr,B] :
      ( range_39_32(B)
     => ( v1220(VarCurr,B)
      <=> v1222(VarCurr,B) ) ) ).

fof(addAssignment_2954,axiom,
    ! [VarCurr,B] :
      ( range_39_32(B)
     => ( v1222(VarCurr,B)
      <=> v1224(VarCurr,B) ) ) ).

fof(addAssignment_2953,axiom,
    ! [VarCurr,B] :
      ( range_39_32(B)
     => ( v1224(VarCurr,B)
      <=> v1226(VarCurr,B) ) ) ).

fof(addAssignment_2952,axiom,
    ! [VarCurr,B] :
      ( range_39_32(B)
     => ( v1226(VarCurr,B)
      <=> v1228(VarCurr,B) ) ) ).

fof(addAssignment_2951,axiom,
    ! [VarNext,B] :
      ( range_39_32(B)
     => ( v1228(VarNext,B)
      <=> v19334(VarNext,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_181,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3569(VarNext)
       => ! [B] :
            ( range_147_0(B)
           => ( v19334(VarNext,B)
            <=> v1228(VarCurr,B) ) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_199,axiom,
    ! [VarNext] :
      ( v3569(VarNext)
     => ! [B] :
          ( range_147_0(B)
         => ( v19334(VarNext,B)
          <=> v3593(VarNext,B) ) ) ) ).

fof(addAssignment_2950,axiom,
    ! [VarCurr,B] :
      ( range_63_52(B)
     => ( v8258(VarCurr,B)
      <=> v8260(VarCurr,B) ) ) ).

fof(addAssignment_2949,axiom,
    ! [VarCurr,B] :
      ( range_63_52(B)
     => ( v8260(VarCurr,B)
      <=> v9317(VarCurr,B) ) ) ).

fof(range_axiom_75,axiom,
    ! [B] :
      ( range_63_52(B)
    <=> ( $false
        | bitIndex52 = B
        | bitIndex53 = B
        | bitIndex54 = B
        | bitIndex55 = B
        | bitIndex56 = B
        | bitIndex57 = B
        | bitIndex58 = B
        | bitIndex59 = B
        | bitIndex60 = B
        | bitIndex61 = B
        | bitIndex62 = B
        | bitIndex63 = B ) ) ).

fof(addAssignment_2948,axiom,
    ! [VarCurr,B] :
      ( range_79_76(B)
     => ( v8262(VarCurr,B)
      <=> v8264(VarCurr,B) ) ) ).

fof(addAssignment_2947,axiom,
    ! [VarNext,B] :
      ( range_79_76(B)
     => ( v8264(VarNext,B)
      <=> v19326(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_157,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19327(VarNext)
       => ! [B] :
            ( range_145_0(B)
           => ( v19326(VarNext,B)
            <=> v8264(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_724,axiom,
    ! [VarNext] :
      ( v19327(VarNext)
     => ! [B] :
          ( range_145_0(B)
         => ( v19326(VarNext,B)
          <=> v8792(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5078,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19327(VarNext)
      <=> v19328(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5077,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19328(VarNext)
      <=> ( v19330(VarNext)
          & v98(VarNext) ) ) ) ).

fof(writeUnaryOperator_1551,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19330(VarNext)
      <=> v7677(VarNext) ) ) ).

fof(addAssignment_2946,axiom,
    ! [VarCurr,B] :
      ( range_79_76(B)
     => ( v1214(VarCurr,B)
      <=> v1216(VarCurr,B) ) ) ).

fof(addAssignment_2945,axiom,
    ! [VarCurr,B] :
      ( range_79_76(B)
     => ( v1216(VarCurr,B)
      <=> v1218(VarCurr,B) ) ) ).

fof(addAssignment_2944,axiom,
    ! [VarCurr,B] :
      ( range_79_76(B)
     => ( v1218(VarCurr,B)
      <=> v1220(VarCurr,B) ) ) ).

fof(addAssignment_2943,axiom,
    ! [VarCurr,B] :
      ( range_79_76(B)
     => ( v1220(VarCurr,B)
      <=> v1222(VarCurr,B) ) ) ).

fof(addAssignment_2942,axiom,
    ! [VarCurr,B] :
      ( range_79_76(B)
     => ( v1222(VarCurr,B)
      <=> v1224(VarCurr,B) ) ) ).

fof(addAssignment_2941,axiom,
    ! [VarCurr,B] :
      ( range_79_76(B)
     => ( v1224(VarCurr,B)
      <=> v1226(VarCurr,B) ) ) ).

fof(addAssignment_2940,axiom,
    ! [VarCurr,B] :
      ( range_79_76(B)
     => ( v1226(VarCurr,B)
      <=> v1228(VarCurr,B) ) ) ).

fof(addAssignment_2939,axiom,
    ! [VarNext,B] :
      ( range_79_76(B)
     => ( v1228(VarNext,B)
      <=> v19324(VarNext,B) ) ) ).

fof(range_axiom_74,axiom,
    ! [B] :
      ( range_79_76(B)
    <=> ( $false
        | bitIndex76 = B
        | bitIndex77 = B
        | bitIndex78 = B
        | bitIndex79 = B ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_180,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3569(VarNext)
       => ! [B] :
            ( range_147_0(B)
           => ( v19324(VarNext,B)
            <=> v1228(VarCurr,B) ) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_198,axiom,
    ! [VarNext] :
      ( v3569(VarNext)
     => ! [B] :
          ( range_147_0(B)
         => ( v19324(VarNext,B)
          <=> v3593(VarNext,B) ) ) ) ).

fof(addAssignment_2938,axiom,
    ! [VarCurr,B] :
      ( range_71_64(B)
     => ( v8262(VarCurr,B)
      <=> v8264(VarCurr,B) ) ) ).

fof(addAssignment_2937,axiom,
    ! [VarNext,B] :
      ( range_71_64(B)
     => ( v8264(VarNext,B)
      <=> v19316(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_156,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19317(VarNext)
       => ! [B] :
            ( range_145_0(B)
           => ( v19316(VarNext,B)
            <=> v8264(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_723,axiom,
    ! [VarNext] :
      ( v19317(VarNext)
     => ! [B] :
          ( range_145_0(B)
         => ( v19316(VarNext,B)
          <=> v8792(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5076,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19317(VarNext)
      <=> v19318(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5075,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19318(VarNext)
      <=> ( v19320(VarNext)
          & v98(VarNext) ) ) ) ).

fof(writeUnaryOperator_1550,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19320(VarNext)
      <=> v7677(VarNext) ) ) ).

fof(addAssignment_2936,axiom,
    ! [VarCurr,B] :
      ( range_71_64(B)
     => ( v1214(VarCurr,B)
      <=> v1216(VarCurr,B) ) ) ).

fof(addAssignment_2935,axiom,
    ! [VarCurr,B] :
      ( range_71_64(B)
     => ( v1216(VarCurr,B)
      <=> v1218(VarCurr,B) ) ) ).

fof(addAssignment_2934,axiom,
    ! [VarCurr,B] :
      ( range_71_64(B)
     => ( v1218(VarCurr,B)
      <=> v1220(VarCurr,B) ) ) ).

fof(addAssignment_2933,axiom,
    ! [VarCurr,B] :
      ( range_71_64(B)
     => ( v1220(VarCurr,B)
      <=> v1222(VarCurr,B) ) ) ).

fof(addAssignment_2932,axiom,
    ! [VarCurr,B] :
      ( range_71_64(B)
     => ( v1222(VarCurr,B)
      <=> v1224(VarCurr,B) ) ) ).

fof(addAssignment_2931,axiom,
    ! [VarCurr,B] :
      ( range_71_64(B)
     => ( v1224(VarCurr,B)
      <=> v1226(VarCurr,B) ) ) ).

fof(addAssignment_2930,axiom,
    ! [VarCurr,B] :
      ( range_71_64(B)
     => ( v1226(VarCurr,B)
      <=> v1228(VarCurr,B) ) ) ).

fof(addAssignment_2929,axiom,
    ! [VarNext,B] :
      ( range_71_64(B)
     => ( v1228(VarNext,B)
      <=> v19314(VarNext,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_179,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3569(VarNext)
       => ! [B] :
            ( range_147_0(B)
           => ( v19314(VarNext,B)
            <=> v1228(VarCurr,B) ) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_197,axiom,
    ! [VarNext] :
      ( v3569(VarNext)
     => ! [B] :
          ( range_147_0(B)
         => ( v19314(VarNext,B)
          <=> v3593(VarNext,B) ) ) ) ).

fof(addAssignment_2928,axiom,
    ! [VarCurr,B] :
      ( range_31_20(B)
     => ( v8258(VarCurr,B)
      <=> v8260(VarCurr,B) ) ) ).

fof(addAssignment_2927,axiom,
    ! [VarCurr,B] :
      ( range_31_20(B)
     => ( v8260(VarCurr,B)
      <=> v9317(VarCurr,B) ) ) ).

fof(range_axiom_73,axiom,
    ! [B] :
      ( range_31_20(B)
    <=> ( $false
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B
        | bitIndex30 = B
        | bitIndex31 = B ) ) ).

fof(addAssignment_2926,axiom,
    ! [VarCurr,B] :
      ( range_111_108(B)
     => ( v8262(VarCurr,B)
      <=> v8264(VarCurr,B) ) ) ).

fof(addAssignment_2925,axiom,
    ! [VarNext,B] :
      ( range_111_108(B)
     => ( v8264(VarNext,B)
      <=> v19306(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_155,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19307(VarNext)
       => ! [B] :
            ( range_145_0(B)
           => ( v19306(VarNext,B)
            <=> v8264(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_722,axiom,
    ! [VarNext] :
      ( v19307(VarNext)
     => ! [B] :
          ( range_145_0(B)
         => ( v19306(VarNext,B)
          <=> v8792(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5074,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19307(VarNext)
      <=> v19308(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5073,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19308(VarNext)
      <=> ( v19310(VarNext)
          & v98(VarNext) ) ) ) ).

fof(writeUnaryOperator_1549,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19310(VarNext)
      <=> v7677(VarNext) ) ) ).

fof(addAssignment_2924,axiom,
    ! [VarCurr,B] :
      ( range_111_108(B)
     => ( v1214(VarCurr,B)
      <=> v1216(VarCurr,B) ) ) ).

fof(addAssignment_2923,axiom,
    ! [VarCurr,B] :
      ( range_111_108(B)
     => ( v1216(VarCurr,B)
      <=> v1218(VarCurr,B) ) ) ).

fof(addAssignment_2922,axiom,
    ! [VarCurr,B] :
      ( range_111_108(B)
     => ( v1218(VarCurr,B)
      <=> v1220(VarCurr,B) ) ) ).

fof(addAssignment_2921,axiom,
    ! [VarCurr,B] :
      ( range_111_108(B)
     => ( v1220(VarCurr,B)
      <=> v1222(VarCurr,B) ) ) ).

fof(addAssignment_2920,axiom,
    ! [VarCurr,B] :
      ( range_111_108(B)
     => ( v1222(VarCurr,B)
      <=> v1224(VarCurr,B) ) ) ).

fof(addAssignment_2919,axiom,
    ! [VarCurr,B] :
      ( range_111_108(B)
     => ( v1224(VarCurr,B)
      <=> v1226(VarCurr,B) ) ) ).

fof(addAssignment_2918,axiom,
    ! [VarCurr,B] :
      ( range_111_108(B)
     => ( v1226(VarCurr,B)
      <=> v1228(VarCurr,B) ) ) ).

fof(addAssignment_2917,axiom,
    ! [VarNext,B] :
      ( range_111_108(B)
     => ( v1228(VarNext,B)
      <=> v19304(VarNext,B) ) ) ).

fof(range_axiom_72,axiom,
    ! [B] :
      ( range_111_108(B)
    <=> ( $false
        | bitIndex108 = B
        | bitIndex109 = B
        | bitIndex110 = B
        | bitIndex111 = B ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_178,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3569(VarNext)
       => ! [B] :
            ( range_147_0(B)
           => ( v19304(VarNext,B)
            <=> v1228(VarCurr,B) ) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_196,axiom,
    ! [VarNext] :
      ( v3569(VarNext)
     => ! [B] :
          ( range_147_0(B)
         => ( v19304(VarNext,B)
          <=> v3593(VarNext,B) ) ) ) ).

fof(addAssignment_2916,axiom,
    ! [VarCurr,B] :
      ( range_103_96(B)
     => ( v8262(VarCurr,B)
      <=> v8264(VarCurr,B) ) ) ).

fof(addAssignment_2915,axiom,
    ! [VarNext,B] :
      ( range_103_96(B)
     => ( v8264(VarNext,B)
      <=> v19296(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_154,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19297(VarNext)
       => ! [B] :
            ( range_145_0(B)
           => ( v19296(VarNext,B)
            <=> v8264(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_721,axiom,
    ! [VarNext] :
      ( v19297(VarNext)
     => ! [B] :
          ( range_145_0(B)
         => ( v19296(VarNext,B)
          <=> v8792(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5072,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19297(VarNext)
      <=> v19298(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5071,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19298(VarNext)
      <=> ( v19300(VarNext)
          & v98(VarNext) ) ) ) ).

fof(writeUnaryOperator_1548,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19300(VarNext)
      <=> v7677(VarNext) ) ) ).

fof(addAssignment_2914,axiom,
    ! [VarCurr,B] :
      ( range_103_96(B)
     => ( v1214(VarCurr,B)
      <=> v1216(VarCurr,B) ) ) ).

fof(addAssignment_2913,axiom,
    ! [VarCurr,B] :
      ( range_103_96(B)
     => ( v1216(VarCurr,B)
      <=> v1218(VarCurr,B) ) ) ).

fof(addAssignment_2912,axiom,
    ! [VarCurr,B] :
      ( range_103_96(B)
     => ( v1218(VarCurr,B)
      <=> v1220(VarCurr,B) ) ) ).

fof(addAssignment_2911,axiom,
    ! [VarCurr,B] :
      ( range_103_96(B)
     => ( v1220(VarCurr,B)
      <=> v1222(VarCurr,B) ) ) ).

fof(addAssignment_2910,axiom,
    ! [VarCurr,B] :
      ( range_103_96(B)
     => ( v1222(VarCurr,B)
      <=> v1224(VarCurr,B) ) ) ).

fof(addAssignment_2909,axiom,
    ! [VarCurr,B] :
      ( range_103_96(B)
     => ( v1224(VarCurr,B)
      <=> v1226(VarCurr,B) ) ) ).

fof(addAssignment_2908,axiom,
    ! [VarCurr,B] :
      ( range_103_96(B)
     => ( v1226(VarCurr,B)
      <=> v1228(VarCurr,B) ) ) ).

fof(addAssignment_2907,axiom,
    ! [VarNext,B] :
      ( range_103_96(B)
     => ( v1228(VarNext,B)
      <=> v19294(VarNext,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_177,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3569(VarNext)
       => ! [B] :
            ( range_147_0(B)
           => ( v19294(VarNext,B)
            <=> v1228(VarCurr,B) ) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_195,axiom,
    ! [VarNext] :
      ( v3569(VarNext)
     => ! [B] :
          ( range_147_0(B)
         => ( v19294(VarNext,B)
          <=> v3593(VarNext,B) ) ) ) ).

fof(addAssignment_2906,axiom,
    ! [VarCurr,B] :
      ( range_1_0(B)
     => ( v19256(VarCurr,B)
      <=> v19258(VarCurr,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_153,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19281(VarNext)
       => ! [B] :
            ( range_1_0(B)
           => ( v19258(VarNext,B)
            <=> v19258(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_720,axiom,
    ! [VarNext] :
      ( v19281(VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v19258(VarNext,B)
          <=> v19290(VarNext,B) ) ) ) ).

fof(addAssignment_2905,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v19290(VarNext,B)
          <=> v19260(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5070,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19281(VarNext)
      <=> v19282(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5069,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19282(VarNext)
      <=> ( v19283(VarNext)
          & v19278(VarNext) ) ) ) ).

fof(writeUnaryOperator_1547,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19283(VarNext)
      <=> v19285(VarNext) ) ) ).

fof(addAssignment_2904,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19285(VarNext)
      <=> v19278(VarCurr) ) ) ).

fof(addAssignment_2903,axiom,
    ! [VarCurr] :
      ( v19278(VarCurr)
    <=> v441(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_27,axiom,
    ! [VarCurr] :
      ( ( ~ v19272(VarCurr)
        & ~ v19274(VarCurr) )
     => ! [B] :
          ( range_1_0(B)
         => ( v19260(VarCurr,B)
          <=> v19258(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_38,axiom,
    ! [VarCurr] :
      ( v19274(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19260(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_41,axiom,
    ! [VarCurr] :
      ( v19272(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19260(VarCurr,B)
          <=> v19266(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5068,axiom,
    ! [VarCurr] :
      ( v19274(VarCurr)
    <=> ( v19275(VarCurr)
        | v19276(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_1329,axiom,
    ! [VarCurr] :
      ( v19276(VarCurr)
    <=> ( ( v19273(VarCurr,bitIndex1)
        <=> $true )
        & ( v19273(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1328,axiom,
    ! [VarCurr] :
      ( v19275(VarCurr)
    <=> ( ( v19273(VarCurr,bitIndex1)
        <=> $true )
        & ( v19273(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1327,axiom,
    ! [VarCurr] :
      ( v19272(VarCurr)
    <=> ( ( v19273(VarCurr,bitIndex1)
        <=> $false )
        & ( v19273(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2902,axiom,
    ! [VarCurr] :
      ( v19273(VarCurr,bitIndex0)
    <=> v19264(VarCurr) ) ).

fof(addAssignment_2901,axiom,
    ! [VarCurr] :
      ( v19273(VarCurr,bitIndex1)
    <=> v19262(VarCurr) ) ).

fof(addAssignment_2900,axiom,
    ! [VarCurr,B] :
      ( range_1_0(B)
     => ( v19266(VarCurr,B)
      <=> v19268(VarCurr,B) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges48_3,axiom,
    ! [VarCurr] :
      ( ( ~ v8056(VarCurr)
        & ~ v8064(VarCurr)
        & ~ v8073(VarCurr)
        & ~ v8079(VarCurr)
        & ~ v8083(VarCurr)
        & ~ v8088(VarCurr)
        & ~ v8091(VarCurr)
        & ~ v8094(VarCurr)
        & ~ v8097(VarCurr)
        & ~ v8100(VarCurr)
        & ~ v8102(VarCurr)
        & ~ v8104(VarCurr)
        & ~ v8106(VarCurr)
        & ~ v8114(VarCurr)
        & ~ v8119(VarCurr)
        & ~ v8123(VarCurr)
        & ~ v8127(VarCurr)
        & ~ v8130(VarCurr)
        & ~ v8133(VarCurr)
        & ~ v8136(VarCurr)
        & ~ v8139(VarCurr)
        & ~ v8141(VarCurr)
        & ~ v8143(VarCurr)
        & ~ v8145(VarCurr)
        & ~ v8153(VarCurr)
        & ~ v8158(VarCurr)
        & ~ v8162(VarCurr)
        & ~ v8166(VarCurr)
        & ~ v8169(VarCurr)
        & ~ v8172(VarCurr)
        & ~ v8175(VarCurr)
        & ~ v8178(VarCurr)
        & ~ v8180(VarCurr)
        & ~ v8182(VarCurr)
        & ~ v8184(VarCurr)
        & ~ v8192(VarCurr)
        & ~ v8197(VarCurr)
        & ~ v8201(VarCurr)
        & ~ v8205(VarCurr)
        & ~ v8208(VarCurr)
        & ~ v8211(VarCurr)
        & ~ v8214(VarCurr)
        & ~ v8217(VarCurr)
        & ~ v8219(VarCurr)
        & ~ v19270(VarCurr)
        & ~ v8226(VarCurr)
        & ~ v8229(VarCurr)
        & ~ v8232(VarCurr) )
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges47_3,axiom,
    ! [VarCurr] :
      ( v8232(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges46_3,axiom,
    ! [VarCurr] :
      ( v8229(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges45_3,axiom,
    ! [VarCurr] :
      ( v8226(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges44_3,axiom,
    ! [VarCurr] :
      ( v19270(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges43_3,axiom,
    ! [VarCurr] :
      ( v8219(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges42_3,axiom,
    ! [VarCurr] :
      ( v8217(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges41_3,axiom,
    ! [VarCurr] :
      ( v8214(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges40_3,axiom,
    ! [VarCurr] :
      ( v8211(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges39_3,axiom,
    ! [VarCurr] :
      ( v8208(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges38_3,axiom,
    ! [VarCurr] :
      ( v8205(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges37_3,axiom,
    ! [VarCurr] :
      ( v8201(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges36_3,axiom,
    ! [VarCurr] :
      ( v8197(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges35_3,axiom,
    ! [VarCurr] :
      ( v8192(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges34_3,axiom,
    ! [VarCurr] :
      ( v8184(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges33_3,axiom,
    ! [VarCurr] :
      ( v8182(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges32_3,axiom,
    ! [VarCurr] :
      ( v8180(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges31_3,axiom,
    ! [VarCurr] :
      ( v8178(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges30_3,axiom,
    ! [VarCurr] :
      ( v8175(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges29_3,axiom,
    ! [VarCurr] :
      ( v8172(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges28_3,axiom,
    ! [VarCurr] :
      ( v8169(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges27_3,axiom,
    ! [VarCurr] :
      ( v8166(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges26_3,axiom,
    ! [VarCurr] :
      ( v8162(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges25_3,axiom,
    ! [VarCurr] :
      ( v8158(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges24_3,axiom,
    ! [VarCurr] :
      ( v8153(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges23_3,axiom,
    ! [VarCurr] :
      ( v8145(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges22_3,axiom,
    ! [VarCurr] :
      ( v8143(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges21_3,axiom,
    ! [VarCurr] :
      ( v8141(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges20_3,axiom,
    ! [VarCurr] :
      ( v8139(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges19_3,axiom,
    ! [VarCurr] :
      ( v8136(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges18_3,axiom,
    ! [VarCurr] :
      ( v8133(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges17_3,axiom,
    ! [VarCurr] :
      ( v8130(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges16_3,axiom,
    ! [VarCurr] :
      ( v8127(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges15_3,axiom,
    ! [VarCurr] :
      ( v8123(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges14_3,axiom,
    ! [VarCurr] :
      ( v8119(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges13_3,axiom,
    ! [VarCurr] :
      ( v8114(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges12_4,axiom,
    ! [VarCurr] :
      ( v8106(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges11_4,axiom,
    ! [VarCurr] :
      ( v8104(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges10_4,axiom,
    ! [VarCurr] :
      ( v8102(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges9_5,axiom,
    ! [VarCurr] :
      ( v8100(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges8_7,axiom,
    ! [VarCurr] :
      ( v8097(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges7_6,axiom,
    ! [VarCurr] :
      ( v8094(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges6_6,axiom,
    ! [VarCurr] :
      ( v8091(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges5_6,axiom,
    ! [VarCurr] :
      ( v8088(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_13,axiom,
    ! [VarCurr] :
      ( v8083(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_14,axiom,
    ! [VarCurr] :
      ( v8079(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_26,axiom,
    ! [VarCurr] :
      ( v8073(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_37,axiom,
    ! [VarCurr] :
      ( v8064(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_40,axiom,
    ! [VarCurr] :
      ( v8056(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v19268(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5067,axiom,
    ! [VarCurr] :
      ( v19270(VarCurr)
    <=> ( v8222(VarCurr)
        | v8224(VarCurr) ) ) ).

fof(addAssignment_2899,axiom,
    ! [VarCurr] :
      ( v19264(VarCurr)
    <=> v7765(VarCurr) ) ).

fof(addAssignment_2898,axiom,
    ! [VarCurr] :
      ( v19262(VarCurr)
    <=> v7761(VarCurr) ) ).

fof(addAssignment_2897,axiom,
    ! [VarCurr] :
      ( v7853(VarCurr)
    <=> v7855(VarCurr) ) ).

fof(addAssignment_2896,axiom,
    ! [VarCurr] :
      ( v7855(VarCurr)
    <=> v7857(VarCurr,bitIndex0) ) ).

fof(addAssignment_2895,axiom,
    ! [VarCurr] :
      ( v7857(VarCurr,bitIndex0)
    <=> v7859(VarCurr,bitIndex0) ) ).

fof(addAssignment_2894,axiom,
    ! [VarCurr] :
      ( v7859(VarCurr,bitIndex0)
    <=> v14000(VarCurr,bitIndex0) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_176,axiom,
    ! [VarCurr] :
      ( ~ v7861(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v12796(VarCurr,B)
          <=> v18793(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_194,axiom,
    ! [VarCurr] :
      ( v7861(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v12796(VarCurr,B)
          <=> v12798(VarCurr,B) ) ) ) ).

fof(addAssignment_2893,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v18793(VarCurr,B)
      <=> v18795(VarCurr,B) ) ) ).

fof(addAssignment_2892,axiom,
    ! [VarNext,B] :
      ( range_3_0(B)
     => ( v18795(VarNext,B)
      <=> v19235(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_152,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19236(VarNext)
       => ! [B] :
            ( range_16_0(B)
           => ( v19235(VarNext,B)
            <=> v18795(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_719,axiom,
    ! [VarNext] :
      ( v19236(VarNext)
     => ! [B] :
          ( range_16_0(B)
         => ( v19235(VarNext,B)
          <=> v19245(VarNext,B) ) ) ) ).

fof(addAssignment_2891,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_16_0(B)
         => ( v19245(VarNext,B)
          <=> v18797(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5066,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19236(VarNext)
      <=> v19237(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5065,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19237(VarNext)
      <=> ( v19238(VarNext)
          & v19233(VarNext) ) ) ) ).

fof(writeUnaryOperator_1546,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19238(VarNext)
      <=> v19240(VarNext) ) ) ).

fof(addAssignment_2890,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19240(VarNext)
      <=> v19233(VarCurr) ) ) ).

fof(addAssignment_2889,axiom,
    ! [VarCurr] :
      ( v19233(VarCurr)
    <=> v441(VarCurr) ) ).

fof(addAssignment_2888,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v18797(VarCurr,B)
      <=> v19226(VarCurr,B) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_25,axiom,
    ! [VarCurr] :
      ( ( ~ v19227(VarCurr)
        & ~ v19229(VarCurr) )
     => ! [B] :
          ( range_16_0(B)
         => ( v19226(VarCurr,B)
          <=> v18795(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_36,axiom,
    ! [VarCurr] :
      ( v19229(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v19226(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_39,axiom,
    ! [VarCurr] :
      ( v19227(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v19226(VarCurr,B)
          <=> v18806(VarCurr,B) ) ) ) ).

fof(addAssignmentInitValueVector_15,axiom,
    ! [B] :
      ( range_16_0(B)
     => ( v18795(constB0,B)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5064,axiom,
    ! [VarCurr] :
      ( v19229(VarCurr)
    <=> ( v19230(VarCurr)
        | v19231(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_1326,axiom,
    ! [VarCurr] :
      ( v19231(VarCurr)
    <=> ( ( v19228(VarCurr,bitIndex1)
        <=> $true )
        & ( v19228(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1325,axiom,
    ! [VarCurr] :
      ( v19230(VarCurr)
    <=> ( ( v19228(VarCurr,bitIndex1)
        <=> $true )
        & ( v19228(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1324,axiom,
    ! [VarCurr] :
      ( v19227(VarCurr)
    <=> ( ( v19228(VarCurr,bitIndex1)
        <=> $false )
        & ( v19228(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2887,axiom,
    ! [VarCurr] :
      ( v19228(VarCurr,bitIndex0)
    <=> v18801(VarCurr) ) ).

fof(addAssignment_2886,axiom,
    ! [VarCurr] :
      ( v19228(VarCurr,bitIndex1)
    <=> v18799(VarCurr) ) ).

fof(addAssignment_2885,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v18806(VarCurr,B)
      <=> v18808(VarCurr,B) ) ) ).

fof(addAssignment_2884,axiom,
    ! [VarCurr] :
      ( ( v18808(VarCurr,bitIndex3)
      <=> v19025(VarCurr,bitIndex2) )
      & ( v18808(VarCurr,bitIndex2)
      <=> v19025(VarCurr,bitIndex1) )
      & ( v18808(VarCurr,bitIndex1)
      <=> v19025(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_2883,axiom,
    ! [VarCurr] :
      ( v19025(VarCurr,bitIndex0)
    <=> v19221(VarCurr) ) ).

fof(addAssignment_2882,axiom,
    ! [VarCurr] :
      ( v19025(VarCurr,bitIndex1)
    <=> v19216(VarCurr) ) ).

fof(addAssignment_2881,axiom,
    ! [VarCurr] :
      ( v19025(VarCurr,bitIndex2)
    <=> v19211(VarCurr) ) ).

fof(addAssignment_2880,axiom,
    ! [VarCurr] :
      ( v19025(VarCurr,bitIndex3)
    <=> v19206(VarCurr) ) ).

fof(addAssignment_2879,axiom,
    ! [VarCurr] :
      ( v19025(VarCurr,bitIndex4)
    <=> v19201(VarCurr) ) ).

fof(addAssignment_2878,axiom,
    ! [VarCurr] :
      ( v19025(VarCurr,bitIndex5)
    <=> v19196(VarCurr) ) ).

fof(addAssignment_2877,axiom,
    ! [VarCurr] :
      ( v19025(VarCurr,bitIndex6)
    <=> v19191(VarCurr) ) ).

fof(addAssignment_2876,axiom,
    ! [VarCurr] :
      ( v19025(VarCurr,bitIndex7)
    <=> v19186(VarCurr) ) ).

fof(addAssignment_2875,axiom,
    ! [VarCurr] :
      ( v19025(VarCurr,bitIndex8)
    <=> v19181(VarCurr) ) ).

fof(addAssignment_2874,axiom,
    ! [VarCurr] :
      ( v19025(VarCurr,bitIndex9)
    <=> v19176(VarCurr) ) ).

fof(addAssignment_2873,axiom,
    ! [VarCurr] :
      ( v19025(VarCurr,bitIndex10)
    <=> v19171(VarCurr) ) ).

fof(addAssignment_2872,axiom,
    ! [VarCurr] :
      ( v19025(VarCurr,bitIndex11)
    <=> v19166(VarCurr) ) ).

fof(addAssignment_2871,axiom,
    ! [VarCurr] :
      ( v19025(VarCurr,bitIndex12)
    <=> v19161(VarCurr) ) ).

fof(addAssignment_2870,axiom,
    ! [VarCurr] :
      ( v19025(VarCurr,bitIndex13)
    <=> v19156(VarCurr) ) ).

fof(addAssignment_2869,axiom,
    ! [VarCurr] :
      ( v19025(VarCurr,bitIndex14)
    <=> v19151(VarCurr) ) ).

fof(addAssignment_2868,axiom,
    ! [VarCurr] :
      ( v19025(VarCurr,bitIndex15)
    <=> v19027(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5063,axiom,
    ! [VarCurr] :
      ( v19221(VarCurr)
    <=> ( v19222(VarCurr)
        & v19225(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1629,axiom,
    ! [VarCurr] :
      ( v19225(VarCurr)
    <=> ( v19059(VarCurr,bitIndex0)
        | v19018(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5062,axiom,
    ! [VarCurr] :
      ( v19222(VarCurr)
    <=> ( v19223(VarCurr)
        | v19224(VarCurr) ) ) ).

fof(writeUnaryOperator_1545,axiom,
    ! [VarCurr] :
      ( ~ v19224(VarCurr)
    <=> v19018(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_1544,axiom,
    ! [VarCurr] :
      ( ~ v19223(VarCurr)
    <=> v19059(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5061,axiom,
    ! [VarCurr] :
      ( v19216(VarCurr)
    <=> ( v19217(VarCurr)
        & v19220(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5060,axiom,
    ! [VarCurr] :
      ( v19220(VarCurr)
    <=> ( v19058(VarCurr)
        | v19060(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5059,axiom,
    ! [VarCurr] :
      ( v19217(VarCurr)
    <=> ( v19218(VarCurr)
        | v19219(VarCurr) ) ) ).

fof(writeUnaryOperator_1543,axiom,
    ! [VarCurr] :
      ( ~ v19219(VarCurr)
    <=> v19060(VarCurr) ) ).

fof(writeUnaryOperator_1542,axiom,
    ! [VarCurr] :
      ( ~ v19218(VarCurr)
    <=> v19058(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5058,axiom,
    ! [VarCurr] :
      ( v19211(VarCurr)
    <=> ( v19212(VarCurr)
        & v19215(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5057,axiom,
    ! [VarCurr] :
      ( v19215(VarCurr)
    <=> ( v19056(VarCurr)
        | v19066(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5056,axiom,
    ! [VarCurr] :
      ( v19212(VarCurr)
    <=> ( v19213(VarCurr)
        | v19214(VarCurr) ) ) ).

fof(writeUnaryOperator_1541,axiom,
    ! [VarCurr] :
      ( ~ v19214(VarCurr)
    <=> v19066(VarCurr) ) ).

fof(writeUnaryOperator_1540,axiom,
    ! [VarCurr] :
      ( ~ v19213(VarCurr)
    <=> v19056(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5055,axiom,
    ! [VarCurr] :
      ( v19206(VarCurr)
    <=> ( v19207(VarCurr)
        & v19210(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5054,axiom,
    ! [VarCurr] :
      ( v19210(VarCurr)
    <=> ( v19054(VarCurr)
        | v19072(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5053,axiom,
    ! [VarCurr] :
      ( v19207(VarCurr)
    <=> ( v19208(VarCurr)
        | v19209(VarCurr) ) ) ).

fof(writeUnaryOperator_1539,axiom,
    ! [VarCurr] :
      ( ~ v19209(VarCurr)
    <=> v19072(VarCurr) ) ).

fof(writeUnaryOperator_1538,axiom,
    ! [VarCurr] :
      ( ~ v19208(VarCurr)
    <=> v19054(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5052,axiom,
    ! [VarCurr] :
      ( v19201(VarCurr)
    <=> ( v19202(VarCurr)
        & v19205(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5051,axiom,
    ! [VarCurr] :
      ( v19205(VarCurr)
    <=> ( v19052(VarCurr)
        | v19078(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5050,axiom,
    ! [VarCurr] :
      ( v19202(VarCurr)
    <=> ( v19203(VarCurr)
        | v19204(VarCurr) ) ) ).

fof(writeUnaryOperator_1537,axiom,
    ! [VarCurr] :
      ( ~ v19204(VarCurr)
    <=> v19078(VarCurr) ) ).

fof(writeUnaryOperator_1536,axiom,
    ! [VarCurr] :
      ( ~ v19203(VarCurr)
    <=> v19052(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5049,axiom,
    ! [VarCurr] :
      ( v19196(VarCurr)
    <=> ( v19197(VarCurr)
        & v19200(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5048,axiom,
    ! [VarCurr] :
      ( v19200(VarCurr)
    <=> ( v19050(VarCurr)
        | v19084(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5047,axiom,
    ! [VarCurr] :
      ( v19197(VarCurr)
    <=> ( v19198(VarCurr)
        | v19199(VarCurr) ) ) ).

fof(writeUnaryOperator_1535,axiom,
    ! [VarCurr] :
      ( ~ v19199(VarCurr)
    <=> v19084(VarCurr) ) ).

fof(writeUnaryOperator_1534,axiom,
    ! [VarCurr] :
      ( ~ v19198(VarCurr)
    <=> v19050(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5046,axiom,
    ! [VarCurr] :
      ( v19191(VarCurr)
    <=> ( v19192(VarCurr)
        & v19195(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5045,axiom,
    ! [VarCurr] :
      ( v19195(VarCurr)
    <=> ( v19048(VarCurr)
        | v19090(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5044,axiom,
    ! [VarCurr] :
      ( v19192(VarCurr)
    <=> ( v19193(VarCurr)
        | v19194(VarCurr) ) ) ).

fof(writeUnaryOperator_1533,axiom,
    ! [VarCurr] :
      ( ~ v19194(VarCurr)
    <=> v19090(VarCurr) ) ).

fof(writeUnaryOperator_1532,axiom,
    ! [VarCurr] :
      ( ~ v19193(VarCurr)
    <=> v19048(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5043,axiom,
    ! [VarCurr] :
      ( v19186(VarCurr)
    <=> ( v19187(VarCurr)
        & v19190(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5042,axiom,
    ! [VarCurr] :
      ( v19190(VarCurr)
    <=> ( v19046(VarCurr)
        | v19096(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5041,axiom,
    ! [VarCurr] :
      ( v19187(VarCurr)
    <=> ( v19188(VarCurr)
        | v19189(VarCurr) ) ) ).

fof(writeUnaryOperator_1531,axiom,
    ! [VarCurr] :
      ( ~ v19189(VarCurr)
    <=> v19096(VarCurr) ) ).

fof(writeUnaryOperator_1530,axiom,
    ! [VarCurr] :
      ( ~ v19188(VarCurr)
    <=> v19046(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5040,axiom,
    ! [VarCurr] :
      ( v19181(VarCurr)
    <=> ( v19182(VarCurr)
        & v19185(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5039,axiom,
    ! [VarCurr] :
      ( v19185(VarCurr)
    <=> ( v19044(VarCurr)
        | v19102(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5038,axiom,
    ! [VarCurr] :
      ( v19182(VarCurr)
    <=> ( v19183(VarCurr)
        | v19184(VarCurr) ) ) ).

fof(writeUnaryOperator_1529,axiom,
    ! [VarCurr] :
      ( ~ v19184(VarCurr)
    <=> v19102(VarCurr) ) ).

fof(writeUnaryOperator_1528,axiom,
    ! [VarCurr] :
      ( ~ v19183(VarCurr)
    <=> v19044(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5037,axiom,
    ! [VarCurr] :
      ( v19176(VarCurr)
    <=> ( v19177(VarCurr)
        & v19180(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5036,axiom,
    ! [VarCurr] :
      ( v19180(VarCurr)
    <=> ( v19042(VarCurr)
        | v19108(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5035,axiom,
    ! [VarCurr] :
      ( v19177(VarCurr)
    <=> ( v19178(VarCurr)
        | v19179(VarCurr) ) ) ).

fof(writeUnaryOperator_1527,axiom,
    ! [VarCurr] :
      ( ~ v19179(VarCurr)
    <=> v19108(VarCurr) ) ).

fof(writeUnaryOperator_1526,axiom,
    ! [VarCurr] :
      ( ~ v19178(VarCurr)
    <=> v19042(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5034,axiom,
    ! [VarCurr] :
      ( v19171(VarCurr)
    <=> ( v19172(VarCurr)
        & v19175(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5033,axiom,
    ! [VarCurr] :
      ( v19175(VarCurr)
    <=> ( v19040(VarCurr)
        | v19114(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5032,axiom,
    ! [VarCurr] :
      ( v19172(VarCurr)
    <=> ( v19173(VarCurr)
        | v19174(VarCurr) ) ) ).

fof(writeUnaryOperator_1525,axiom,
    ! [VarCurr] :
      ( ~ v19174(VarCurr)
    <=> v19114(VarCurr) ) ).

fof(writeUnaryOperator_1524,axiom,
    ! [VarCurr] :
      ( ~ v19173(VarCurr)
    <=> v19040(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5031,axiom,
    ! [VarCurr] :
      ( v19166(VarCurr)
    <=> ( v19167(VarCurr)
        & v19170(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5030,axiom,
    ! [VarCurr] :
      ( v19170(VarCurr)
    <=> ( v19038(VarCurr)
        | v19120(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5029,axiom,
    ! [VarCurr] :
      ( v19167(VarCurr)
    <=> ( v19168(VarCurr)
        | v19169(VarCurr) ) ) ).

fof(writeUnaryOperator_1523,axiom,
    ! [VarCurr] :
      ( ~ v19169(VarCurr)
    <=> v19120(VarCurr) ) ).

fof(writeUnaryOperator_1522,axiom,
    ! [VarCurr] :
      ( ~ v19168(VarCurr)
    <=> v19038(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5028,axiom,
    ! [VarCurr] :
      ( v19161(VarCurr)
    <=> ( v19162(VarCurr)
        & v19165(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5027,axiom,
    ! [VarCurr] :
      ( v19165(VarCurr)
    <=> ( v19036(VarCurr)
        | v19126(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5026,axiom,
    ! [VarCurr] :
      ( v19162(VarCurr)
    <=> ( v19163(VarCurr)
        | v19164(VarCurr) ) ) ).

fof(writeUnaryOperator_1521,axiom,
    ! [VarCurr] :
      ( ~ v19164(VarCurr)
    <=> v19126(VarCurr) ) ).

fof(writeUnaryOperator_1520,axiom,
    ! [VarCurr] :
      ( ~ v19163(VarCurr)
    <=> v19036(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5025,axiom,
    ! [VarCurr] :
      ( v19156(VarCurr)
    <=> ( v19157(VarCurr)
        & v19160(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5024,axiom,
    ! [VarCurr] :
      ( v19160(VarCurr)
    <=> ( v19034(VarCurr)
        | v19132(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5023,axiom,
    ! [VarCurr] :
      ( v19157(VarCurr)
    <=> ( v19158(VarCurr)
        | v19159(VarCurr) ) ) ).

fof(writeUnaryOperator_1519,axiom,
    ! [VarCurr] :
      ( ~ v19159(VarCurr)
    <=> v19132(VarCurr) ) ).

fof(writeUnaryOperator_1518,axiom,
    ! [VarCurr] :
      ( ~ v19158(VarCurr)
    <=> v19034(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5022,axiom,
    ! [VarCurr] :
      ( v19151(VarCurr)
    <=> ( v19152(VarCurr)
        & v19155(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5021,axiom,
    ! [VarCurr] :
      ( v19155(VarCurr)
    <=> ( v19032(VarCurr)
        | v19138(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5020,axiom,
    ! [VarCurr] :
      ( v19152(VarCurr)
    <=> ( v19153(VarCurr)
        | v19154(VarCurr) ) ) ).

fof(writeUnaryOperator_1517,axiom,
    ! [VarCurr] :
      ( ~ v19154(VarCurr)
    <=> v19138(VarCurr) ) ).

fof(writeUnaryOperator_1516,axiom,
    ! [VarCurr] :
      ( ~ v19153(VarCurr)
    <=> v19032(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5019,axiom,
    ! [VarCurr] :
      ( v19027(VarCurr)
    <=> ( v19028(VarCurr)
        & v19150(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5018,axiom,
    ! [VarCurr] :
      ( v19150(VarCurr)
    <=> ( v19030(VarCurr)
        | v19145(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5017,axiom,
    ! [VarCurr] :
      ( v19028(VarCurr)
    <=> ( v19029(VarCurr)
        | v19144(VarCurr) ) ) ).

fof(writeUnaryOperator_1515,axiom,
    ! [VarCurr] :
      ( ~ v19144(VarCurr)
    <=> v19145(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5016,axiom,
    ! [VarCurr] :
      ( v19145(VarCurr)
    <=> ( v19146(VarCurr)
        & v19149(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1628,axiom,
    ! [VarCurr] :
      ( v19149(VarCurr)
    <=> ( v19059(VarCurr,bitIndex15)
        | v19018(VarCurr,bitIndex16) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5015,axiom,
    ! [VarCurr] :
      ( v19146(VarCurr)
    <=> ( v19147(VarCurr)
        | v19148(VarCurr) ) ) ).

fof(writeUnaryOperator_1514,axiom,
    ! [VarCurr] :
      ( ~ v19148(VarCurr)
    <=> v19018(VarCurr,bitIndex16) ) ).

fof(writeUnaryOperator_1513,axiom,
    ! [VarCurr] :
      ( ~ v19147(VarCurr)
    <=> v19059(VarCurr,bitIndex15) ) ).

fof(writeUnaryOperator_1512,axiom,
    ! [VarCurr] :
      ( ~ v19029(VarCurr)
    <=> v19030(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5014,axiom,
    ! [VarCurr] :
      ( v19030(VarCurr)
    <=> ( v19031(VarCurr)
        | v19143(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1627,axiom,
    ! [VarCurr] :
      ( v19143(VarCurr)
    <=> ( v19059(VarCurr,bitIndex14)
        & v19018(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5013,axiom,
    ! [VarCurr] :
      ( v19031(VarCurr)
    <=> ( v19032(VarCurr)
        & v19138(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5012,axiom,
    ! [VarCurr] :
      ( v19138(VarCurr)
    <=> ( v19139(VarCurr)
        & v19142(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1626,axiom,
    ! [VarCurr] :
      ( v19142(VarCurr)
    <=> ( v19059(VarCurr,bitIndex14)
        | v19018(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5011,axiom,
    ! [VarCurr] :
      ( v19139(VarCurr)
    <=> ( v19140(VarCurr)
        | v19141(VarCurr) ) ) ).

fof(writeUnaryOperator_1511,axiom,
    ! [VarCurr] :
      ( ~ v19141(VarCurr)
    <=> v19018(VarCurr,bitIndex15) ) ).

fof(writeUnaryOperator_1510,axiom,
    ! [VarCurr] :
      ( ~ v19140(VarCurr)
    <=> v19059(VarCurr,bitIndex14) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5010,axiom,
    ! [VarCurr] :
      ( v19032(VarCurr)
    <=> ( v19033(VarCurr)
        | v19137(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1625,axiom,
    ! [VarCurr] :
      ( v19137(VarCurr)
    <=> ( v19059(VarCurr,bitIndex13)
        & v19018(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5009,axiom,
    ! [VarCurr] :
      ( v19033(VarCurr)
    <=> ( v19034(VarCurr)
        & v19132(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5008,axiom,
    ! [VarCurr] :
      ( v19132(VarCurr)
    <=> ( v19133(VarCurr)
        & v19136(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1624,axiom,
    ! [VarCurr] :
      ( v19136(VarCurr)
    <=> ( v19059(VarCurr,bitIndex13)
        | v19018(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5007,axiom,
    ! [VarCurr] :
      ( v19133(VarCurr)
    <=> ( v19134(VarCurr)
        | v19135(VarCurr) ) ) ).

fof(writeUnaryOperator_1509,axiom,
    ! [VarCurr] :
      ( ~ v19135(VarCurr)
    <=> v19018(VarCurr,bitIndex14) ) ).

fof(writeUnaryOperator_1508,axiom,
    ! [VarCurr] :
      ( ~ v19134(VarCurr)
    <=> v19059(VarCurr,bitIndex13) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5006,axiom,
    ! [VarCurr] :
      ( v19034(VarCurr)
    <=> ( v19035(VarCurr)
        | v19131(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1623,axiom,
    ! [VarCurr] :
      ( v19131(VarCurr)
    <=> ( v19059(VarCurr,bitIndex12)
        & v19018(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5005,axiom,
    ! [VarCurr] :
      ( v19035(VarCurr)
    <=> ( v19036(VarCurr)
        & v19126(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5004,axiom,
    ! [VarCurr] :
      ( v19126(VarCurr)
    <=> ( v19127(VarCurr)
        & v19130(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1622,axiom,
    ! [VarCurr] :
      ( v19130(VarCurr)
    <=> ( v19059(VarCurr,bitIndex12)
        | v19018(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5003,axiom,
    ! [VarCurr] :
      ( v19127(VarCurr)
    <=> ( v19128(VarCurr)
        | v19129(VarCurr) ) ) ).

fof(writeUnaryOperator_1507,axiom,
    ! [VarCurr] :
      ( ~ v19129(VarCurr)
    <=> v19018(VarCurr,bitIndex13) ) ).

fof(writeUnaryOperator_1506,axiom,
    ! [VarCurr] :
      ( ~ v19128(VarCurr)
    <=> v19059(VarCurr,bitIndex12) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5002,axiom,
    ! [VarCurr] :
      ( v19036(VarCurr)
    <=> ( v19037(VarCurr)
        | v19125(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1621,axiom,
    ! [VarCurr] :
      ( v19125(VarCurr)
    <=> ( v19059(VarCurr,bitIndex11)
        & v19018(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5001,axiom,
    ! [VarCurr] :
      ( v19037(VarCurr)
    <=> ( v19038(VarCurr)
        & v19120(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5000,axiom,
    ! [VarCurr] :
      ( v19120(VarCurr)
    <=> ( v19121(VarCurr)
        & v19124(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1620,axiom,
    ! [VarCurr] :
      ( v19124(VarCurr)
    <=> ( v19059(VarCurr,bitIndex11)
        | v19018(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4999,axiom,
    ! [VarCurr] :
      ( v19121(VarCurr)
    <=> ( v19122(VarCurr)
        | v19123(VarCurr) ) ) ).

fof(writeUnaryOperator_1505,axiom,
    ! [VarCurr] :
      ( ~ v19123(VarCurr)
    <=> v19018(VarCurr,bitIndex12) ) ).

fof(writeUnaryOperator_1504,axiom,
    ! [VarCurr] :
      ( ~ v19122(VarCurr)
    <=> v19059(VarCurr,bitIndex11) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4998,axiom,
    ! [VarCurr] :
      ( v19038(VarCurr)
    <=> ( v19039(VarCurr)
        | v19119(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1619,axiom,
    ! [VarCurr] :
      ( v19119(VarCurr)
    <=> ( v19059(VarCurr,bitIndex10)
        & v19018(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4997,axiom,
    ! [VarCurr] :
      ( v19039(VarCurr)
    <=> ( v19040(VarCurr)
        & v19114(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4996,axiom,
    ! [VarCurr] :
      ( v19114(VarCurr)
    <=> ( v19115(VarCurr)
        & v19118(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1618,axiom,
    ! [VarCurr] :
      ( v19118(VarCurr)
    <=> ( v19059(VarCurr,bitIndex10)
        | v19018(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4995,axiom,
    ! [VarCurr] :
      ( v19115(VarCurr)
    <=> ( v19116(VarCurr)
        | v19117(VarCurr) ) ) ).

fof(writeUnaryOperator_1503,axiom,
    ! [VarCurr] :
      ( ~ v19117(VarCurr)
    <=> v19018(VarCurr,bitIndex11) ) ).

fof(writeUnaryOperator_1502,axiom,
    ! [VarCurr] :
      ( ~ v19116(VarCurr)
    <=> v19059(VarCurr,bitIndex10) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4994,axiom,
    ! [VarCurr] :
      ( v19040(VarCurr)
    <=> ( v19041(VarCurr)
        | v19113(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1617,axiom,
    ! [VarCurr] :
      ( v19113(VarCurr)
    <=> ( v19059(VarCurr,bitIndex9)
        & v19018(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4993,axiom,
    ! [VarCurr] :
      ( v19041(VarCurr)
    <=> ( v19042(VarCurr)
        & v19108(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4992,axiom,
    ! [VarCurr] :
      ( v19108(VarCurr)
    <=> ( v19109(VarCurr)
        & v19112(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1616,axiom,
    ! [VarCurr] :
      ( v19112(VarCurr)
    <=> ( v19059(VarCurr,bitIndex9)
        | v19018(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4991,axiom,
    ! [VarCurr] :
      ( v19109(VarCurr)
    <=> ( v19110(VarCurr)
        | v19111(VarCurr) ) ) ).

fof(writeUnaryOperator_1501,axiom,
    ! [VarCurr] :
      ( ~ v19111(VarCurr)
    <=> v19018(VarCurr,bitIndex10) ) ).

fof(writeUnaryOperator_1500,axiom,
    ! [VarCurr] :
      ( ~ v19110(VarCurr)
    <=> v19059(VarCurr,bitIndex9) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4990,axiom,
    ! [VarCurr] :
      ( v19042(VarCurr)
    <=> ( v19043(VarCurr)
        | v19107(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1615,axiom,
    ! [VarCurr] :
      ( v19107(VarCurr)
    <=> ( v19059(VarCurr,bitIndex8)
        & v19018(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4989,axiom,
    ! [VarCurr] :
      ( v19043(VarCurr)
    <=> ( v19044(VarCurr)
        & v19102(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4988,axiom,
    ! [VarCurr] :
      ( v19102(VarCurr)
    <=> ( v19103(VarCurr)
        & v19106(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1614,axiom,
    ! [VarCurr] :
      ( v19106(VarCurr)
    <=> ( v19059(VarCurr,bitIndex8)
        | v19018(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4987,axiom,
    ! [VarCurr] :
      ( v19103(VarCurr)
    <=> ( v19104(VarCurr)
        | v19105(VarCurr) ) ) ).

fof(writeUnaryOperator_1499,axiom,
    ! [VarCurr] :
      ( ~ v19105(VarCurr)
    <=> v19018(VarCurr,bitIndex9) ) ).

fof(writeUnaryOperator_1498,axiom,
    ! [VarCurr] :
      ( ~ v19104(VarCurr)
    <=> v19059(VarCurr,bitIndex8) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4986,axiom,
    ! [VarCurr] :
      ( v19044(VarCurr)
    <=> ( v19045(VarCurr)
        | v19101(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1613,axiom,
    ! [VarCurr] :
      ( v19101(VarCurr)
    <=> ( v19059(VarCurr,bitIndex7)
        & v19018(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4985,axiom,
    ! [VarCurr] :
      ( v19045(VarCurr)
    <=> ( v19046(VarCurr)
        & v19096(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4984,axiom,
    ! [VarCurr] :
      ( v19096(VarCurr)
    <=> ( v19097(VarCurr)
        & v19100(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1612,axiom,
    ! [VarCurr] :
      ( v19100(VarCurr)
    <=> ( v19059(VarCurr,bitIndex7)
        | v19018(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4983,axiom,
    ! [VarCurr] :
      ( v19097(VarCurr)
    <=> ( v19098(VarCurr)
        | v19099(VarCurr) ) ) ).

fof(writeUnaryOperator_1497,axiom,
    ! [VarCurr] :
      ( ~ v19099(VarCurr)
    <=> v19018(VarCurr,bitIndex8) ) ).

fof(writeUnaryOperator_1496,axiom,
    ! [VarCurr] :
      ( ~ v19098(VarCurr)
    <=> v19059(VarCurr,bitIndex7) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4982,axiom,
    ! [VarCurr] :
      ( v19046(VarCurr)
    <=> ( v19047(VarCurr)
        | v19095(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1611,axiom,
    ! [VarCurr] :
      ( v19095(VarCurr)
    <=> ( v19059(VarCurr,bitIndex6)
        & v19018(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4981,axiom,
    ! [VarCurr] :
      ( v19047(VarCurr)
    <=> ( v19048(VarCurr)
        & v19090(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4980,axiom,
    ! [VarCurr] :
      ( v19090(VarCurr)
    <=> ( v19091(VarCurr)
        & v19094(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1610,axiom,
    ! [VarCurr] :
      ( v19094(VarCurr)
    <=> ( v19059(VarCurr,bitIndex6)
        | v19018(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4979,axiom,
    ! [VarCurr] :
      ( v19091(VarCurr)
    <=> ( v19092(VarCurr)
        | v19093(VarCurr) ) ) ).

fof(writeUnaryOperator_1495,axiom,
    ! [VarCurr] :
      ( ~ v19093(VarCurr)
    <=> v19018(VarCurr,bitIndex7) ) ).

fof(writeUnaryOperator_1494,axiom,
    ! [VarCurr] :
      ( ~ v19092(VarCurr)
    <=> v19059(VarCurr,bitIndex6) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4978,axiom,
    ! [VarCurr] :
      ( v19048(VarCurr)
    <=> ( v19049(VarCurr)
        | v19089(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1609,axiom,
    ! [VarCurr] :
      ( v19089(VarCurr)
    <=> ( v19059(VarCurr,bitIndex5)
        & v19018(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4977,axiom,
    ! [VarCurr] :
      ( v19049(VarCurr)
    <=> ( v19050(VarCurr)
        & v19084(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4976,axiom,
    ! [VarCurr] :
      ( v19084(VarCurr)
    <=> ( v19085(VarCurr)
        & v19088(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1608,axiom,
    ! [VarCurr] :
      ( v19088(VarCurr)
    <=> ( v19059(VarCurr,bitIndex5)
        | v19018(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4975,axiom,
    ! [VarCurr] :
      ( v19085(VarCurr)
    <=> ( v19086(VarCurr)
        | v19087(VarCurr) ) ) ).

fof(writeUnaryOperator_1493,axiom,
    ! [VarCurr] :
      ( ~ v19087(VarCurr)
    <=> v19018(VarCurr,bitIndex6) ) ).

fof(writeUnaryOperator_1492,axiom,
    ! [VarCurr] :
      ( ~ v19086(VarCurr)
    <=> v19059(VarCurr,bitIndex5) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4974,axiom,
    ! [VarCurr] :
      ( v19050(VarCurr)
    <=> ( v19051(VarCurr)
        | v19083(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1607,axiom,
    ! [VarCurr] :
      ( v19083(VarCurr)
    <=> ( v19059(VarCurr,bitIndex4)
        & v19018(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4973,axiom,
    ! [VarCurr] :
      ( v19051(VarCurr)
    <=> ( v19052(VarCurr)
        & v19078(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4972,axiom,
    ! [VarCurr] :
      ( v19078(VarCurr)
    <=> ( v19079(VarCurr)
        & v19082(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1606,axiom,
    ! [VarCurr] :
      ( v19082(VarCurr)
    <=> ( v19059(VarCurr,bitIndex4)
        | v19018(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4971,axiom,
    ! [VarCurr] :
      ( v19079(VarCurr)
    <=> ( v19080(VarCurr)
        | v19081(VarCurr) ) ) ).

fof(writeUnaryOperator_1491,axiom,
    ! [VarCurr] :
      ( ~ v19081(VarCurr)
    <=> v19018(VarCurr,bitIndex5) ) ).

fof(writeUnaryOperator_1490,axiom,
    ! [VarCurr] :
      ( ~ v19080(VarCurr)
    <=> v19059(VarCurr,bitIndex4) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4970,axiom,
    ! [VarCurr] :
      ( v19052(VarCurr)
    <=> ( v19053(VarCurr)
        | v19077(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1605,axiom,
    ! [VarCurr] :
      ( v19077(VarCurr)
    <=> ( v19059(VarCurr,bitIndex3)
        & v19018(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4969,axiom,
    ! [VarCurr] :
      ( v19053(VarCurr)
    <=> ( v19054(VarCurr)
        & v19072(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4968,axiom,
    ! [VarCurr] :
      ( v19072(VarCurr)
    <=> ( v19073(VarCurr)
        & v19076(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1604,axiom,
    ! [VarCurr] :
      ( v19076(VarCurr)
    <=> ( v19059(VarCurr,bitIndex3)
        | v19018(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4967,axiom,
    ! [VarCurr] :
      ( v19073(VarCurr)
    <=> ( v19074(VarCurr)
        | v19075(VarCurr) ) ) ).

fof(writeUnaryOperator_1489,axiom,
    ! [VarCurr] :
      ( ~ v19075(VarCurr)
    <=> v19018(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_1488,axiom,
    ! [VarCurr] :
      ( ~ v19074(VarCurr)
    <=> v19059(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4966,axiom,
    ! [VarCurr] :
      ( v19054(VarCurr)
    <=> ( v19055(VarCurr)
        | v19071(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1603,axiom,
    ! [VarCurr] :
      ( v19071(VarCurr)
    <=> ( v19059(VarCurr,bitIndex2)
        & v19018(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4965,axiom,
    ! [VarCurr] :
      ( v19055(VarCurr)
    <=> ( v19056(VarCurr)
        & v19066(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4964,axiom,
    ! [VarCurr] :
      ( v19066(VarCurr)
    <=> ( v19067(VarCurr)
        & v19070(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1602,axiom,
    ! [VarCurr] :
      ( v19070(VarCurr)
    <=> ( v19059(VarCurr,bitIndex2)
        | v19018(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4963,axiom,
    ! [VarCurr] :
      ( v19067(VarCurr)
    <=> ( v19068(VarCurr)
        | v19069(VarCurr) ) ) ).

fof(writeUnaryOperator_1487,axiom,
    ! [VarCurr] :
      ( ~ v19069(VarCurr)
    <=> v19018(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_1486,axiom,
    ! [VarCurr] :
      ( ~ v19068(VarCurr)
    <=> v19059(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4962,axiom,
    ! [VarCurr] :
      ( v19056(VarCurr)
    <=> ( v19057(VarCurr)
        | v19065(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1601,axiom,
    ! [VarCurr] :
      ( v19065(VarCurr)
    <=> ( v19059(VarCurr,bitIndex1)
        & v19018(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4961,axiom,
    ! [VarCurr] :
      ( v19057(VarCurr)
    <=> ( v19058(VarCurr)
        & v19060(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4960,axiom,
    ! [VarCurr] :
      ( v19060(VarCurr)
    <=> ( v19061(VarCurr)
        & v19064(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1600,axiom,
    ! [VarCurr] :
      ( v19064(VarCurr)
    <=> ( v19059(VarCurr,bitIndex1)
        | v19018(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4959,axiom,
    ! [VarCurr] :
      ( v19061(VarCurr)
    <=> ( v19062(VarCurr)
        | v19063(VarCurr) ) ) ).

fof(writeUnaryOperator_1485,axiom,
    ! [VarCurr] :
      ( ~ v19063(VarCurr)
    <=> v19018(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_1484,axiom,
    ! [VarCurr] :
      ( ~ v19062(VarCurr)
    <=> v19059(VarCurr,bitIndex1) ) ).

fof(writeBinaryOperatorShiftedRanges_1599,axiom,
    ! [VarCurr] :
      ( v19058(VarCurr)
    <=> ( v19059(VarCurr,bitIndex0)
        & v19018(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_2867,axiom,
    ! [VarCurr] :
      ( ( v19059(VarCurr,bitIndex14)
      <=> v18810(VarCurr,bitIndex15) )
      & ( v19059(VarCurr,bitIndex13)
      <=> v18810(VarCurr,bitIndex14) )
      & ( v19059(VarCurr,bitIndex12)
      <=> v18810(VarCurr,bitIndex13) )
      & ( v19059(VarCurr,bitIndex11)
      <=> v18810(VarCurr,bitIndex12) )
      & ( v19059(VarCurr,bitIndex10)
      <=> v18810(VarCurr,bitIndex11) )
      & ( v19059(VarCurr,bitIndex9)
      <=> v18810(VarCurr,bitIndex10) )
      & ( v19059(VarCurr,bitIndex8)
      <=> v18810(VarCurr,bitIndex9) )
      & ( v19059(VarCurr,bitIndex7)
      <=> v18810(VarCurr,bitIndex8) )
      & ( v19059(VarCurr,bitIndex6)
      <=> v18810(VarCurr,bitIndex7) )
      & ( v19059(VarCurr,bitIndex5)
      <=> v18810(VarCurr,bitIndex6) )
      & ( v19059(VarCurr,bitIndex4)
      <=> v18810(VarCurr,bitIndex5) )
      & ( v19059(VarCurr,bitIndex3)
      <=> v18810(VarCurr,bitIndex4) )
      & ( v19059(VarCurr,bitIndex2)
      <=> v18810(VarCurr,bitIndex3) )
      & ( v19059(VarCurr,bitIndex1)
      <=> v18810(VarCurr,bitIndex2) )
      & ( v19059(VarCurr,bitIndex0)
      <=> v18810(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_2866,axiom,
    ! [VarCurr] :
      ( v19059(VarCurr,bitIndex15)
    <=> $false ) ).

fof(addAssignment_2865,axiom,
    ! [VarCurr] :
      ( v18808(VarCurr,bitIndex0)
    <=> v18810(VarCurr,bitIndex0) ) ).

fof(addAssignment_2864,axiom,
    ! [VarCurr] :
      ( v19018(VarCurr,bitIndex3)
    <=> v19023(VarCurr,bitIndex3) ) ).

fof(addAssignment_2863,axiom,
    ! [VarCurr] :
      ( v19018(VarCurr,bitIndex2)
    <=> v19023(VarCurr,bitIndex2) ) ).

fof(addAssignment_2862,axiom,
    ! [VarCurr] :
      ( v19018(VarCurr,bitIndex1)
    <=> v19023(VarCurr,bitIndex1) ) ).

fof(addParallelCaseBooleanConditionEqualRanges8_6,axiom,
    ! [VarCurr] :
      ( ( ~ v19024(VarCurr)
        & ~ v18890(VarCurr)
        & ~ v18891(VarCurr)
        & ~ v18892(VarCurr)
        & ~ v18893(VarCurr)
        & ~ v18894(VarCurr)
        & ~ v18895(VarCurr)
        & ~ v18896(VarCurr) )
     => ! [B] :
          ( range_16_0(B)
         => ( v19023(VarCurr,B)
          <=> b00000000000001110(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges7_5,axiom,
    ! [VarCurr] :
      ( v18896(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v19023(VarCurr,B)
          <=> b00000000001000010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges6_5,axiom,
    ! [VarCurr] :
      ( v18895(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v19023(VarCurr,B)
          <=> b00000000000011010(B) ) ) ) ).

fof(bitBlastConstant_2576,axiom,
    ~ b00000000000011010(bitIndex16) ).

fof(bitBlastConstant_2575,axiom,
    ~ b00000000000011010(bitIndex15) ).

fof(bitBlastConstant_2574,axiom,
    ~ b00000000000011010(bitIndex14) ).

fof(bitBlastConstant_2573,axiom,
    ~ b00000000000011010(bitIndex13) ).

fof(bitBlastConstant_2572,axiom,
    ~ b00000000000011010(bitIndex12) ).

fof(bitBlastConstant_2571,axiom,
    ~ b00000000000011010(bitIndex11) ).

fof(bitBlastConstant_2570,axiom,
    ~ b00000000000011010(bitIndex10) ).

fof(bitBlastConstant_2569,axiom,
    ~ b00000000000011010(bitIndex9) ).

fof(bitBlastConstant_2568,axiom,
    ~ b00000000000011010(bitIndex8) ).

fof(bitBlastConstant_2567,axiom,
    ~ b00000000000011010(bitIndex7) ).

fof(bitBlastConstant_2566,axiom,
    ~ b00000000000011010(bitIndex6) ).

fof(bitBlastConstant_2565,axiom,
    ~ b00000000000011010(bitIndex5) ).

fof(bitBlastConstant_2564,axiom,
    b00000000000011010(bitIndex4) ).

fof(bitBlastConstant_2563,axiom,
    b00000000000011010(bitIndex3) ).

fof(bitBlastConstant_2562,axiom,
    ~ b00000000000011010(bitIndex2) ).

fof(bitBlastConstant_2561,axiom,
    b00000000000011010(bitIndex1) ).

fof(bitBlastConstant_2560,axiom,
    ~ b00000000000011010(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges5_5,axiom,
    ! [VarCurr] :
      ( v18894(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v19023(VarCurr,B)
          <=> b00000000000111110(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_12,axiom,
    ! [VarCurr] :
      ( v18893(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v19023(VarCurr,B)
          <=> b00000000000010110(B) ) ) ) ).

fof(bitBlastConstant_2559,axiom,
    ~ b00000000000010110(bitIndex16) ).

fof(bitBlastConstant_2558,axiom,
    ~ b00000000000010110(bitIndex15) ).

fof(bitBlastConstant_2557,axiom,
    ~ b00000000000010110(bitIndex14) ).

fof(bitBlastConstant_2556,axiom,
    ~ b00000000000010110(bitIndex13) ).

fof(bitBlastConstant_2555,axiom,
    ~ b00000000000010110(bitIndex12) ).

fof(bitBlastConstant_2554,axiom,
    ~ b00000000000010110(bitIndex11) ).

fof(bitBlastConstant_2553,axiom,
    ~ b00000000000010110(bitIndex10) ).

fof(bitBlastConstant_2552,axiom,
    ~ b00000000000010110(bitIndex9) ).

fof(bitBlastConstant_2551,axiom,
    ~ b00000000000010110(bitIndex8) ).

fof(bitBlastConstant_2550,axiom,
    ~ b00000000000010110(bitIndex7) ).

fof(bitBlastConstant_2549,axiom,
    ~ b00000000000010110(bitIndex6) ).

fof(bitBlastConstant_2548,axiom,
    ~ b00000000000010110(bitIndex5) ).

fof(bitBlastConstant_2547,axiom,
    b00000000000010110(bitIndex4) ).

fof(bitBlastConstant_2546,axiom,
    ~ b00000000000010110(bitIndex3) ).

fof(bitBlastConstant_2545,axiom,
    b00000000000010110(bitIndex2) ).

fof(bitBlastConstant_2544,axiom,
    b00000000000010110(bitIndex1) ).

fof(bitBlastConstant_2543,axiom,
    ~ b00000000000010110(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges3_13,axiom,
    ! [VarCurr] :
      ( v18892(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v19023(VarCurr,B)
          <=> b00000000000111010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_24,axiom,
    ! [VarCurr] :
      ( v18891(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v19023(VarCurr,B)
          <=> b00000000000010010(B) ) ) ) ).

fof(bitBlastConstant_2542,axiom,
    ~ b00000000000010010(bitIndex16) ).

fof(bitBlastConstant_2541,axiom,
    ~ b00000000000010010(bitIndex15) ).

fof(bitBlastConstant_2540,axiom,
    ~ b00000000000010010(bitIndex14) ).

fof(bitBlastConstant_2539,axiom,
    ~ b00000000000010010(bitIndex13) ).

fof(bitBlastConstant_2538,axiom,
    ~ b00000000000010010(bitIndex12) ).

fof(bitBlastConstant_2537,axiom,
    ~ b00000000000010010(bitIndex11) ).

fof(bitBlastConstant_2536,axiom,
    ~ b00000000000010010(bitIndex10) ).

fof(bitBlastConstant_2535,axiom,
    ~ b00000000000010010(bitIndex9) ).

fof(bitBlastConstant_2534,axiom,
    ~ b00000000000010010(bitIndex8) ).

fof(bitBlastConstant_2533,axiom,
    ~ b00000000000010010(bitIndex7) ).

fof(bitBlastConstant_2532,axiom,
    ~ b00000000000010010(bitIndex6) ).

fof(bitBlastConstant_2531,axiom,
    ~ b00000000000010010(bitIndex5) ).

fof(bitBlastConstant_2530,axiom,
    b00000000000010010(bitIndex4) ).

fof(bitBlastConstant_2529,axiom,
    ~ b00000000000010010(bitIndex3) ).

fof(bitBlastConstant_2528,axiom,
    ~ b00000000000010010(bitIndex2) ).

fof(bitBlastConstant_2527,axiom,
    b00000000000010010(bitIndex1) ).

fof(bitBlastConstant_2526,axiom,
    ~ b00000000000010010(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges1_35,axiom,
    ! [VarCurr] :
      ( v18890(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v19023(VarCurr,B)
          <=> b00000000000110110(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_38,axiom,
    ! [VarCurr] :
      ( v19024(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v19023(VarCurr,B)
          <=> b00000000000001110(B) ) ) ) ).

fof(bitBlastConstant_2525,axiom,
    ~ b00000000000001110(bitIndex16) ).

fof(bitBlastConstant_2524,axiom,
    ~ b00000000000001110(bitIndex15) ).

fof(bitBlastConstant_2523,axiom,
    ~ b00000000000001110(bitIndex14) ).

fof(bitBlastConstant_2522,axiom,
    ~ b00000000000001110(bitIndex13) ).

fof(bitBlastConstant_2521,axiom,
    ~ b00000000000001110(bitIndex12) ).

fof(bitBlastConstant_2520,axiom,
    ~ b00000000000001110(bitIndex11) ).

fof(bitBlastConstant_2519,axiom,
    ~ b00000000000001110(bitIndex10) ).

fof(bitBlastConstant_2518,axiom,
    ~ b00000000000001110(bitIndex9) ).

fof(bitBlastConstant_2517,axiom,
    ~ b00000000000001110(bitIndex8) ).

fof(bitBlastConstant_2516,axiom,
    ~ b00000000000001110(bitIndex7) ).

fof(bitBlastConstant_2515,axiom,
    ~ b00000000000001110(bitIndex6) ).

fof(bitBlastConstant_2514,axiom,
    ~ b00000000000001110(bitIndex5) ).

fof(bitBlastConstant_2513,axiom,
    ~ b00000000000001110(bitIndex4) ).

fof(bitBlastConstant_2512,axiom,
    b00000000000001110(bitIndex3) ).

fof(bitBlastConstant_2511,axiom,
    b00000000000001110(bitIndex2) ).

fof(bitBlastConstant_2510,axiom,
    b00000000000001110(bitIndex1) ).

fof(bitBlastConstant_2509,axiom,
    ~ b00000000000001110(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4958,axiom,
    ! [VarCurr] :
      ( v19024(VarCurr)
    <=> ( v18887(VarCurr)
        | v18889(VarCurr) ) ) ).

fof(addAssignment_2861,axiom,
    ! [VarCurr] :
      ( v18810(VarCurr,bitIndex3)
    <=> v18886(VarCurr,bitIndex3) ) ).

fof(addAssignment_2860,axiom,
    ! [VarCurr] :
      ( v8258(VarCurr,bitIndex19)
    <=> v8260(VarCurr,bitIndex19) ) ).

fof(addAssignment_2859,axiom,
    ! [VarCurr] :
      ( v8260(VarCurr,bitIndex19)
    <=> v9317(VarCurr,bitIndex19) ) ).

fof(addAssignment_2858,axiom,
    ! [VarCurr] :
      ( v8262(VarCurr,bitIndex107)
    <=> v8264(VarCurr,bitIndex107) ) ).

fof(addAssignment_2857,axiom,
    ! [VarNext] :
      ( v8264(VarNext,bitIndex107)
    <=> v19010(VarNext,bitIndex107) ) ).

fof(addCaseBooleanConditionEqualRanges1_151,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19011(VarNext)
       => ! [B] :
            ( range_145_0(B)
           => ( v19010(VarNext,B)
            <=> v8264(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_718,axiom,
    ! [VarNext] :
      ( v19011(VarNext)
     => ! [B] :
          ( range_145_0(B)
         => ( v19010(VarNext,B)
          <=> v8792(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4957,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19011(VarNext)
      <=> v19012(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4956,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19012(VarNext)
      <=> ( v19014(VarNext)
          & v98(VarNext) ) ) ) ).

fof(writeUnaryOperator_1483,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19014(VarNext)
      <=> v7677(VarNext) ) ) ).

fof(addAssignment_2856,axiom,
    ! [VarCurr] :
      ( v1214(VarCurr,bitIndex107)
    <=> v1216(VarCurr,bitIndex107) ) ).

fof(addAssignment_2855,axiom,
    ! [VarCurr] :
      ( v1216(VarCurr,bitIndex107)
    <=> v1218(VarCurr,bitIndex107) ) ).

fof(addAssignment_2854,axiom,
    ! [VarCurr] :
      ( v1218(VarCurr,bitIndex107)
    <=> v1220(VarCurr,bitIndex107) ) ).

fof(addAssignment_2853,axiom,
    ! [VarCurr] :
      ( v1220(VarCurr,bitIndex107)
    <=> v1222(VarCurr,bitIndex107) ) ).

fof(addAssignment_2852,axiom,
    ! [VarCurr] :
      ( v1222(VarCurr,bitIndex107)
    <=> v1224(VarCurr,bitIndex107) ) ).

fof(addAssignment_2851,axiom,
    ! [VarCurr] :
      ( v1224(VarCurr,bitIndex107)
    <=> v1226(VarCurr,bitIndex107) ) ).

fof(addAssignment_2850,axiom,
    ! [VarCurr] :
      ( v1226(VarCurr,bitIndex107)
    <=> v1228(VarCurr,bitIndex107) ) ).

fof(addAssignment_2849,axiom,
    ! [VarNext] :
      ( v1228(VarNext,bitIndex107)
    <=> v19008(VarNext,bitIndex107) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_175,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3569(VarNext)
       => ! [B] :
            ( range_147_0(B)
           => ( v19008(VarNext,B)
            <=> v1228(VarCurr,B) ) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_193,axiom,
    ! [VarNext] :
      ( v3569(VarNext)
     => ! [B] :
          ( range_147_0(B)
         => ( v19008(VarNext,B)
          <=> v3593(VarNext,B) ) ) ) ).

fof(addAssignment_2848,axiom,
    ! [VarCurr] :
      ( v8258(VarCurr,bitIndex51)
    <=> v8260(VarCurr,bitIndex51) ) ).

fof(addAssignment_2847,axiom,
    ! [VarCurr] :
      ( v8260(VarCurr,bitIndex51)
    <=> v9317(VarCurr,bitIndex51) ) ).

fof(addAssignment_2846,axiom,
    ! [VarCurr] :
      ( v8262(VarCurr,bitIndex75)
    <=> v8264(VarCurr,bitIndex75) ) ).

fof(addAssignment_2845,axiom,
    ! [VarNext] :
      ( v8264(VarNext,bitIndex75)
    <=> v19000(VarNext,bitIndex75) ) ).

fof(addCaseBooleanConditionEqualRanges1_150,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19001(VarNext)
       => ! [B] :
            ( range_145_0(B)
           => ( v19000(VarNext,B)
            <=> v8264(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_717,axiom,
    ! [VarNext] :
      ( v19001(VarNext)
     => ! [B] :
          ( range_145_0(B)
         => ( v19000(VarNext,B)
          <=> v8792(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4955,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19001(VarNext)
      <=> v19002(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4954,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v19002(VarNext)
      <=> ( v19004(VarNext)
          & v98(VarNext) ) ) ) ).

fof(writeUnaryOperator_1482,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v19004(VarNext)
      <=> v7677(VarNext) ) ) ).

fof(addAssignment_2844,axiom,
    ! [VarCurr] :
      ( v1214(VarCurr,bitIndex75)
    <=> v1216(VarCurr,bitIndex75) ) ).

fof(addAssignment_2843,axiom,
    ! [VarCurr] :
      ( v1216(VarCurr,bitIndex75)
    <=> v1218(VarCurr,bitIndex75) ) ).

fof(addAssignment_2842,axiom,
    ! [VarCurr] :
      ( v1218(VarCurr,bitIndex75)
    <=> v1220(VarCurr,bitIndex75) ) ).

fof(addAssignment_2841,axiom,
    ! [VarCurr] :
      ( v1220(VarCurr,bitIndex75)
    <=> v1222(VarCurr,bitIndex75) ) ).

fof(addAssignment_2840,axiom,
    ! [VarCurr] :
      ( v1222(VarCurr,bitIndex75)
    <=> v1224(VarCurr,bitIndex75) ) ).

fof(addAssignment_2839,axiom,
    ! [VarCurr] :
      ( v1224(VarCurr,bitIndex75)
    <=> v1226(VarCurr,bitIndex75) ) ).

fof(addAssignment_2838,axiom,
    ! [VarCurr] :
      ( v1226(VarCurr,bitIndex75)
    <=> v1228(VarCurr,bitIndex75) ) ).

fof(addAssignment_2837,axiom,
    ! [VarNext] :
      ( v1228(VarNext,bitIndex75)
    <=> v18998(VarNext,bitIndex75) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_174,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3569(VarNext)
       => ! [B] :
            ( range_147_0(B)
           => ( v18998(VarNext,B)
            <=> v1228(VarCurr,B) ) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_192,axiom,
    ! [VarNext] :
      ( v3569(VarNext)
     => ! [B] :
          ( range_147_0(B)
         => ( v18998(VarNext,B)
          <=> v3593(VarNext,B) ) ) ) ).

fof(addAssignment_2836,axiom,
    ! [VarCurr] :
      ( v8258(VarCurr,bitIndex83)
    <=> v8260(VarCurr,bitIndex83) ) ).

fof(addAssignment_2835,axiom,
    ! [VarCurr] :
      ( v8260(VarCurr,bitIndex83)
    <=> v9317(VarCurr,bitIndex83) ) ).

fof(addAssignment_2834,axiom,
    ! [VarCurr] :
      ( v8262(VarCurr,bitIndex43)
    <=> v8264(VarCurr,bitIndex43) ) ).

fof(addAssignment_2833,axiom,
    ! [VarNext] :
      ( v8264(VarNext,bitIndex43)
    <=> v18990(VarNext,bitIndex43) ) ).

fof(addCaseBooleanConditionEqualRanges1_149,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18991(VarNext)
       => ! [B] :
            ( range_145_0(B)
           => ( v18990(VarNext,B)
            <=> v8264(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_716,axiom,
    ! [VarNext] :
      ( v18991(VarNext)
     => ! [B] :
          ( range_145_0(B)
         => ( v18990(VarNext,B)
          <=> v8792(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4953,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18991(VarNext)
      <=> v18992(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4952,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18992(VarNext)
      <=> ( v18994(VarNext)
          & v98(VarNext) ) ) ) ).

fof(writeUnaryOperator_1481,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18994(VarNext)
      <=> v7677(VarNext) ) ) ).

fof(addAssignment_2832,axiom,
    ! [VarCurr] :
      ( v1214(VarCurr,bitIndex43)
    <=> v1216(VarCurr,bitIndex43) ) ).

fof(addAssignment_2831,axiom,
    ! [VarCurr] :
      ( v1216(VarCurr,bitIndex43)
    <=> v1218(VarCurr,bitIndex43) ) ).

fof(addAssignment_2830,axiom,
    ! [VarCurr] :
      ( v1218(VarCurr,bitIndex43)
    <=> v1220(VarCurr,bitIndex43) ) ).

fof(addAssignment_2829,axiom,
    ! [VarCurr] :
      ( v1220(VarCurr,bitIndex43)
    <=> v1222(VarCurr,bitIndex43) ) ).

fof(addAssignment_2828,axiom,
    ! [VarCurr] :
      ( v1222(VarCurr,bitIndex43)
    <=> v1224(VarCurr,bitIndex43) ) ).

fof(addAssignment_2827,axiom,
    ! [VarCurr] :
      ( v1224(VarCurr,bitIndex43)
    <=> v1226(VarCurr,bitIndex43) ) ).

fof(addAssignment_2826,axiom,
    ! [VarCurr] :
      ( v1226(VarCurr,bitIndex43)
    <=> v1228(VarCurr,bitIndex43) ) ).

fof(addAssignment_2825,axiom,
    ! [VarNext] :
      ( v1228(VarNext,bitIndex43)
    <=> v18988(VarNext,bitIndex43) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_173,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3569(VarNext)
       => ! [B] :
            ( range_147_0(B)
           => ( v18988(VarNext,B)
            <=> v1228(VarCurr,B) ) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_191,axiom,
    ! [VarNext] :
      ( v3569(VarNext)
     => ! [B] :
          ( range_147_0(B)
         => ( v18988(VarNext,B)
          <=> v3593(VarNext,B) ) ) ) ).

fof(addAssignment_2824,axiom,
    ! [VarCurr] :
      ( v8258(VarCurr,bitIndex115)
    <=> v8260(VarCurr,bitIndex115) ) ).

fof(addAssignment_2823,axiom,
    ! [VarCurr] :
      ( v8260(VarCurr,bitIndex115)
    <=> v9317(VarCurr,bitIndex115) ) ).

fof(addAssignment_2822,axiom,
    ! [VarCurr] :
      ( v8262(VarCurr,bitIndex11)
    <=> v8264(VarCurr,bitIndex11) ) ).

fof(addAssignment_2821,axiom,
    ! [VarNext] :
      ( v8264(VarNext,bitIndex11)
    <=> v18980(VarNext,bitIndex11) ) ).

fof(addCaseBooleanConditionEqualRanges1_148,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18981(VarNext)
       => ! [B] :
            ( range_145_0(B)
           => ( v18980(VarNext,B)
            <=> v8264(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_715,axiom,
    ! [VarNext] :
      ( v18981(VarNext)
     => ! [B] :
          ( range_145_0(B)
         => ( v18980(VarNext,B)
          <=> v8792(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4951,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18981(VarNext)
      <=> v18982(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4950,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18982(VarNext)
      <=> ( v18984(VarNext)
          & v98(VarNext) ) ) ) ).

fof(writeUnaryOperator_1480,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18984(VarNext)
      <=> v7677(VarNext) ) ) ).

fof(addAssignment_2820,axiom,
    ! [VarCurr] :
      ( v1214(VarCurr,bitIndex11)
    <=> v1216(VarCurr,bitIndex11) ) ).

fof(addAssignment_2819,axiom,
    ! [VarCurr] :
      ( v1216(VarCurr,bitIndex11)
    <=> v1218(VarCurr,bitIndex11) ) ).

fof(addAssignment_2818,axiom,
    ! [VarCurr] :
      ( v1218(VarCurr,bitIndex11)
    <=> v1220(VarCurr,bitIndex11) ) ).

fof(addAssignment_2817,axiom,
    ! [VarCurr] :
      ( v1220(VarCurr,bitIndex11)
    <=> v1222(VarCurr,bitIndex11) ) ).

fof(addAssignment_2816,axiom,
    ! [VarCurr] :
      ( v1222(VarCurr,bitIndex11)
    <=> v1224(VarCurr,bitIndex11) ) ).

fof(addAssignment_2815,axiom,
    ! [VarCurr] :
      ( v1224(VarCurr,bitIndex11)
    <=> v1226(VarCurr,bitIndex11) ) ).

fof(addAssignment_2814,axiom,
    ! [VarCurr] :
      ( v1226(VarCurr,bitIndex11)
    <=> v1228(VarCurr,bitIndex11) ) ).

fof(addAssignment_2813,axiom,
    ! [VarNext] :
      ( v1228(VarNext,bitIndex11)
    <=> v18978(VarNext,bitIndex11) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_172,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3569(VarNext)
       => ! [B] :
            ( range_147_0(B)
           => ( v18978(VarNext,B)
            <=> v1228(VarCurr,B) ) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_190,axiom,
    ! [VarNext] :
      ( v3569(VarNext)
     => ! [B] :
          ( range_147_0(B)
         => ( v18978(VarNext,B)
          <=> v3593(VarNext,B) ) ) ) ).

fof(addAssignment_2812,axiom,
    ! [VarCurr] :
      ( v18810(VarCurr,bitIndex2)
    <=> v18886(VarCurr,bitIndex2) ) ).

fof(addAssignment_2811,axiom,
    ! [VarCurr] :
      ( v8258(VarCurr,bitIndex18)
    <=> v8260(VarCurr,bitIndex18) ) ).

fof(addAssignment_2810,axiom,
    ! [VarCurr] :
      ( v8260(VarCurr,bitIndex18)
    <=> v9317(VarCurr,bitIndex18) ) ).

fof(addAssignment_2809,axiom,
    ! [VarCurr] :
      ( v8262(VarCurr,bitIndex106)
    <=> v8264(VarCurr,bitIndex106) ) ).

fof(addAssignment_2808,axiom,
    ! [VarNext] :
      ( v8264(VarNext,bitIndex106)
    <=> v18970(VarNext,bitIndex106) ) ).

fof(addCaseBooleanConditionEqualRanges1_147,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18971(VarNext)
       => ! [B] :
            ( range_145_0(B)
           => ( v18970(VarNext,B)
            <=> v8264(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_714,axiom,
    ! [VarNext] :
      ( v18971(VarNext)
     => ! [B] :
          ( range_145_0(B)
         => ( v18970(VarNext,B)
          <=> v8792(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4949,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18971(VarNext)
      <=> v18972(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4948,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18972(VarNext)
      <=> ( v18974(VarNext)
          & v98(VarNext) ) ) ) ).

fof(writeUnaryOperator_1479,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18974(VarNext)
      <=> v7677(VarNext) ) ) ).

fof(addAssignment_2807,axiom,
    ! [VarCurr] :
      ( v1214(VarCurr,bitIndex106)
    <=> v1216(VarCurr,bitIndex106) ) ).

fof(addAssignment_2806,axiom,
    ! [VarCurr] :
      ( v1216(VarCurr,bitIndex106)
    <=> v1218(VarCurr,bitIndex106) ) ).

fof(addAssignment_2805,axiom,
    ! [VarCurr] :
      ( v1218(VarCurr,bitIndex106)
    <=> v1220(VarCurr,bitIndex106) ) ).

fof(addAssignment_2804,axiom,
    ! [VarCurr] :
      ( v1220(VarCurr,bitIndex106)
    <=> v1222(VarCurr,bitIndex106) ) ).

fof(addAssignment_2803,axiom,
    ! [VarCurr] :
      ( v1222(VarCurr,bitIndex106)
    <=> v1224(VarCurr,bitIndex106) ) ).

fof(addAssignment_2802,axiom,
    ! [VarCurr] :
      ( v1224(VarCurr,bitIndex106)
    <=> v1226(VarCurr,bitIndex106) ) ).

fof(addAssignment_2801,axiom,
    ! [VarCurr] :
      ( v1226(VarCurr,bitIndex106)
    <=> v1228(VarCurr,bitIndex106) ) ).

fof(addAssignment_2800,axiom,
    ! [VarNext] :
      ( v1228(VarNext,bitIndex106)
    <=> v18968(VarNext,bitIndex106) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_171,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3569(VarNext)
       => ! [B] :
            ( range_147_0(B)
           => ( v18968(VarNext,B)
            <=> v1228(VarCurr,B) ) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_189,axiom,
    ! [VarNext] :
      ( v3569(VarNext)
     => ! [B] :
          ( range_147_0(B)
         => ( v18968(VarNext,B)
          <=> v3593(VarNext,B) ) ) ) ).

fof(addAssignment_2799,axiom,
    ! [VarCurr] :
      ( v8258(VarCurr,bitIndex50)
    <=> v8260(VarCurr,bitIndex50) ) ).

fof(addAssignment_2798,axiom,
    ! [VarCurr] :
      ( v8260(VarCurr,bitIndex50)
    <=> v9317(VarCurr,bitIndex50) ) ).

fof(addAssignment_2797,axiom,
    ! [VarCurr] :
      ( v8262(VarCurr,bitIndex74)
    <=> v8264(VarCurr,bitIndex74) ) ).

fof(addAssignment_2796,axiom,
    ! [VarNext] :
      ( v8264(VarNext,bitIndex74)
    <=> v18960(VarNext,bitIndex74) ) ).

fof(addCaseBooleanConditionEqualRanges1_146,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18961(VarNext)
       => ! [B] :
            ( range_145_0(B)
           => ( v18960(VarNext,B)
            <=> v8264(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_713,axiom,
    ! [VarNext] :
      ( v18961(VarNext)
     => ! [B] :
          ( range_145_0(B)
         => ( v18960(VarNext,B)
          <=> v8792(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4947,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18961(VarNext)
      <=> v18962(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4946,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18962(VarNext)
      <=> ( v18964(VarNext)
          & v98(VarNext) ) ) ) ).

fof(writeUnaryOperator_1478,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18964(VarNext)
      <=> v7677(VarNext) ) ) ).

fof(addAssignment_2795,axiom,
    ! [VarCurr] :
      ( v1214(VarCurr,bitIndex74)
    <=> v1216(VarCurr,bitIndex74) ) ).

fof(addAssignment_2794,axiom,
    ! [VarCurr] :
      ( v1216(VarCurr,bitIndex74)
    <=> v1218(VarCurr,bitIndex74) ) ).

fof(addAssignment_2793,axiom,
    ! [VarCurr] :
      ( v1218(VarCurr,bitIndex74)
    <=> v1220(VarCurr,bitIndex74) ) ).

fof(addAssignment_2792,axiom,
    ! [VarCurr] :
      ( v1220(VarCurr,bitIndex74)
    <=> v1222(VarCurr,bitIndex74) ) ).

fof(addAssignment_2791,axiom,
    ! [VarCurr] :
      ( v1222(VarCurr,bitIndex74)
    <=> v1224(VarCurr,bitIndex74) ) ).

fof(addAssignment_2790,axiom,
    ! [VarCurr] :
      ( v1224(VarCurr,bitIndex74)
    <=> v1226(VarCurr,bitIndex74) ) ).

fof(addAssignment_2789,axiom,
    ! [VarCurr] :
      ( v1226(VarCurr,bitIndex74)
    <=> v1228(VarCurr,bitIndex74) ) ).

fof(addAssignment_2788,axiom,
    ! [VarNext] :
      ( v1228(VarNext,bitIndex74)
    <=> v18958(VarNext,bitIndex74) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_170,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3569(VarNext)
       => ! [B] :
            ( range_147_0(B)
           => ( v18958(VarNext,B)
            <=> v1228(VarCurr,B) ) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_188,axiom,
    ! [VarNext] :
      ( v3569(VarNext)
     => ! [B] :
          ( range_147_0(B)
         => ( v18958(VarNext,B)
          <=> v3593(VarNext,B) ) ) ) ).

fof(addAssignment_2787,axiom,
    ! [VarCurr] :
      ( v8258(VarCurr,bitIndex82)
    <=> v8260(VarCurr,bitIndex82) ) ).

fof(addAssignment_2786,axiom,
    ! [VarCurr] :
      ( v8260(VarCurr,bitIndex82)
    <=> v9317(VarCurr,bitIndex82) ) ).

fof(addAssignment_2785,axiom,
    ! [VarCurr] :
      ( v8262(VarCurr,bitIndex42)
    <=> v8264(VarCurr,bitIndex42) ) ).

fof(addAssignment_2784,axiom,
    ! [VarNext] :
      ( v8264(VarNext,bitIndex42)
    <=> v18950(VarNext,bitIndex42) ) ).

fof(addCaseBooleanConditionEqualRanges1_145,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18951(VarNext)
       => ! [B] :
            ( range_145_0(B)
           => ( v18950(VarNext,B)
            <=> v8264(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_712,axiom,
    ! [VarNext] :
      ( v18951(VarNext)
     => ! [B] :
          ( range_145_0(B)
         => ( v18950(VarNext,B)
          <=> v8792(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4945,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18951(VarNext)
      <=> v18952(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4944,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18952(VarNext)
      <=> ( v18954(VarNext)
          & v98(VarNext) ) ) ) ).

fof(writeUnaryOperator_1477,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18954(VarNext)
      <=> v7677(VarNext) ) ) ).

fof(addAssignment_2783,axiom,
    ! [VarCurr] :
      ( v1214(VarCurr,bitIndex42)
    <=> v1216(VarCurr,bitIndex42) ) ).

fof(addAssignment_2782,axiom,
    ! [VarCurr] :
      ( v1216(VarCurr,bitIndex42)
    <=> v1218(VarCurr,bitIndex42) ) ).

fof(addAssignment_2781,axiom,
    ! [VarCurr] :
      ( v1218(VarCurr,bitIndex42)
    <=> v1220(VarCurr,bitIndex42) ) ).

fof(addAssignment_2780,axiom,
    ! [VarCurr] :
      ( v1220(VarCurr,bitIndex42)
    <=> v1222(VarCurr,bitIndex42) ) ).

fof(addAssignment_2779,axiom,
    ! [VarCurr] :
      ( v1222(VarCurr,bitIndex42)
    <=> v1224(VarCurr,bitIndex42) ) ).

fof(addAssignment_2778,axiom,
    ! [VarCurr] :
      ( v1224(VarCurr,bitIndex42)
    <=> v1226(VarCurr,bitIndex42) ) ).

fof(addAssignment_2777,axiom,
    ! [VarCurr] :
      ( v1226(VarCurr,bitIndex42)
    <=> v1228(VarCurr,bitIndex42) ) ).

fof(addAssignment_2776,axiom,
    ! [VarNext] :
      ( v1228(VarNext,bitIndex42)
    <=> v18948(VarNext,bitIndex42) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_169,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3569(VarNext)
       => ! [B] :
            ( range_147_0(B)
           => ( v18948(VarNext,B)
            <=> v1228(VarCurr,B) ) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_187,axiom,
    ! [VarNext] :
      ( v3569(VarNext)
     => ! [B] :
          ( range_147_0(B)
         => ( v18948(VarNext,B)
          <=> v3593(VarNext,B) ) ) ) ).

fof(addAssignment_2775,axiom,
    ! [VarCurr] :
      ( v8258(VarCurr,bitIndex114)
    <=> v8260(VarCurr,bitIndex114) ) ).

fof(addAssignment_2774,axiom,
    ! [VarCurr] :
      ( v8260(VarCurr,bitIndex114)
    <=> v9317(VarCurr,bitIndex114) ) ).

fof(addAssignment_2773,axiom,
    ! [VarCurr] :
      ( v8262(VarCurr,bitIndex10)
    <=> v8264(VarCurr,bitIndex10) ) ).

fof(addAssignment_2772,axiom,
    ! [VarNext] :
      ( v8264(VarNext,bitIndex10)
    <=> v18940(VarNext,bitIndex10) ) ).

fof(addCaseBooleanConditionEqualRanges1_144,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18941(VarNext)
       => ! [B] :
            ( range_145_0(B)
           => ( v18940(VarNext,B)
            <=> v8264(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_711,axiom,
    ! [VarNext] :
      ( v18941(VarNext)
     => ! [B] :
          ( range_145_0(B)
         => ( v18940(VarNext,B)
          <=> v8792(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4943,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18941(VarNext)
      <=> v18942(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4942,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18942(VarNext)
      <=> ( v18944(VarNext)
          & v98(VarNext) ) ) ) ).

fof(writeUnaryOperator_1476,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18944(VarNext)
      <=> v7677(VarNext) ) ) ).

fof(addAssignment_2771,axiom,
    ! [VarCurr] :
      ( v1214(VarCurr,bitIndex10)
    <=> v1216(VarCurr,bitIndex10) ) ).

fof(addAssignment_2770,axiom,
    ! [VarCurr] :
      ( v1216(VarCurr,bitIndex10)
    <=> v1218(VarCurr,bitIndex10) ) ).

fof(addAssignment_2769,axiom,
    ! [VarCurr] :
      ( v1218(VarCurr,bitIndex10)
    <=> v1220(VarCurr,bitIndex10) ) ).

fof(addAssignment_2768,axiom,
    ! [VarCurr] :
      ( v1220(VarCurr,bitIndex10)
    <=> v1222(VarCurr,bitIndex10) ) ).

fof(addAssignment_2767,axiom,
    ! [VarCurr] :
      ( v1222(VarCurr,bitIndex10)
    <=> v1224(VarCurr,bitIndex10) ) ).

fof(addAssignment_2766,axiom,
    ! [VarCurr] :
      ( v1224(VarCurr,bitIndex10)
    <=> v1226(VarCurr,bitIndex10) ) ).

fof(addAssignment_2765,axiom,
    ! [VarCurr] :
      ( v1226(VarCurr,bitIndex10)
    <=> v1228(VarCurr,bitIndex10) ) ).

fof(addAssignment_2764,axiom,
    ! [VarNext] :
      ( v1228(VarNext,bitIndex10)
    <=> v18938(VarNext,bitIndex10) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_168,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3569(VarNext)
       => ! [B] :
            ( range_147_0(B)
           => ( v18938(VarNext,B)
            <=> v1228(VarCurr,B) ) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_186,axiom,
    ! [VarNext] :
      ( v3569(VarNext)
     => ! [B] :
          ( range_147_0(B)
         => ( v18938(VarNext,B)
          <=> v3593(VarNext,B) ) ) ) ).

fof(addAssignment_2763,axiom,
    ! [VarCurr] :
      ( v18810(VarCurr,bitIndex1)
    <=> v18886(VarCurr,bitIndex1) ) ).

fof(addAssignment_2762,axiom,
    ! [VarCurr] :
      ( v8258(VarCurr,bitIndex17)
    <=> v8260(VarCurr,bitIndex17) ) ).

fof(addAssignment_2761,axiom,
    ! [VarCurr] :
      ( v8260(VarCurr,bitIndex17)
    <=> v9317(VarCurr,bitIndex17) ) ).

fof(addAssignment_2760,axiom,
    ! [VarCurr] :
      ( v8262(VarCurr,bitIndex105)
    <=> v8264(VarCurr,bitIndex105) ) ).

fof(addAssignment_2759,axiom,
    ! [VarNext] :
      ( v8264(VarNext,bitIndex105)
    <=> v18930(VarNext,bitIndex105) ) ).

fof(addCaseBooleanConditionEqualRanges1_143,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18931(VarNext)
       => ! [B] :
            ( range_145_0(B)
           => ( v18930(VarNext,B)
            <=> v8264(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_710,axiom,
    ! [VarNext] :
      ( v18931(VarNext)
     => ! [B] :
          ( range_145_0(B)
         => ( v18930(VarNext,B)
          <=> v8792(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4941,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18931(VarNext)
      <=> v18932(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4940,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18932(VarNext)
      <=> ( v18934(VarNext)
          & v98(VarNext) ) ) ) ).

fof(writeUnaryOperator_1475,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18934(VarNext)
      <=> v7677(VarNext) ) ) ).

fof(addAssignment_2758,axiom,
    ! [VarCurr] :
      ( v1214(VarCurr,bitIndex105)
    <=> v1216(VarCurr,bitIndex105) ) ).

fof(addAssignment_2757,axiom,
    ! [VarCurr] :
      ( v1216(VarCurr,bitIndex105)
    <=> v1218(VarCurr,bitIndex105) ) ).

fof(addAssignment_2756,axiom,
    ! [VarCurr] :
      ( v1218(VarCurr,bitIndex105)
    <=> v1220(VarCurr,bitIndex105) ) ).

fof(addAssignment_2755,axiom,
    ! [VarCurr] :
      ( v1220(VarCurr,bitIndex105)
    <=> v1222(VarCurr,bitIndex105) ) ).

fof(addAssignment_2754,axiom,
    ! [VarCurr] :
      ( v1222(VarCurr,bitIndex105)
    <=> v1224(VarCurr,bitIndex105) ) ).

fof(addAssignment_2753,axiom,
    ! [VarCurr] :
      ( v1224(VarCurr,bitIndex105)
    <=> v1226(VarCurr,bitIndex105) ) ).

fof(addAssignment_2752,axiom,
    ! [VarCurr] :
      ( v1226(VarCurr,bitIndex105)
    <=> v1228(VarCurr,bitIndex105) ) ).

fof(addAssignment_2751,axiom,
    ! [VarNext] :
      ( v1228(VarNext,bitIndex105)
    <=> v18928(VarNext,bitIndex105) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_167,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3569(VarNext)
       => ! [B] :
            ( range_147_0(B)
           => ( v18928(VarNext,B)
            <=> v1228(VarCurr,B) ) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_185,axiom,
    ! [VarNext] :
      ( v3569(VarNext)
     => ! [B] :
          ( range_147_0(B)
         => ( v18928(VarNext,B)
          <=> v3593(VarNext,B) ) ) ) ).

fof(addAssignment_2750,axiom,
    ! [VarCurr] :
      ( v8258(VarCurr,bitIndex49)
    <=> v8260(VarCurr,bitIndex49) ) ).

fof(addAssignment_2749,axiom,
    ! [VarCurr] :
      ( v8260(VarCurr,bitIndex49)
    <=> v9317(VarCurr,bitIndex49) ) ).

fof(addAssignment_2748,axiom,
    ! [VarCurr] :
      ( v8262(VarCurr,bitIndex73)
    <=> v8264(VarCurr,bitIndex73) ) ).

fof(addAssignment_2747,axiom,
    ! [VarNext] :
      ( v8264(VarNext,bitIndex73)
    <=> v18920(VarNext,bitIndex73) ) ).

fof(addCaseBooleanConditionEqualRanges1_142,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18921(VarNext)
       => ! [B] :
            ( range_145_0(B)
           => ( v18920(VarNext,B)
            <=> v8264(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_709,axiom,
    ! [VarNext] :
      ( v18921(VarNext)
     => ! [B] :
          ( range_145_0(B)
         => ( v18920(VarNext,B)
          <=> v8792(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4939,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18921(VarNext)
      <=> v18922(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4938,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18922(VarNext)
      <=> ( v18924(VarNext)
          & v98(VarNext) ) ) ) ).

fof(writeUnaryOperator_1474,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18924(VarNext)
      <=> v7677(VarNext) ) ) ).

fof(addAssignment_2746,axiom,
    ! [VarCurr] :
      ( v1214(VarCurr,bitIndex73)
    <=> v1216(VarCurr,bitIndex73) ) ).

fof(addAssignment_2745,axiom,
    ! [VarCurr] :
      ( v1216(VarCurr,bitIndex73)
    <=> v1218(VarCurr,bitIndex73) ) ).

fof(addAssignment_2744,axiom,
    ! [VarCurr] :
      ( v1218(VarCurr,bitIndex73)
    <=> v1220(VarCurr,bitIndex73) ) ).

fof(addAssignment_2743,axiom,
    ! [VarCurr] :
      ( v1220(VarCurr,bitIndex73)
    <=> v1222(VarCurr,bitIndex73) ) ).

fof(addAssignment_2742,axiom,
    ! [VarCurr] :
      ( v1222(VarCurr,bitIndex73)
    <=> v1224(VarCurr,bitIndex73) ) ).

fof(addAssignment_2741,axiom,
    ! [VarCurr] :
      ( v1224(VarCurr,bitIndex73)
    <=> v1226(VarCurr,bitIndex73) ) ).

fof(addAssignment_2740,axiom,
    ! [VarCurr] :
      ( v1226(VarCurr,bitIndex73)
    <=> v1228(VarCurr,bitIndex73) ) ).

fof(addAssignment_2739,axiom,
    ! [VarNext] :
      ( v1228(VarNext,bitIndex73)
    <=> v18918(VarNext,bitIndex73) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_166,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3569(VarNext)
       => ! [B] :
            ( range_147_0(B)
           => ( v18918(VarNext,B)
            <=> v1228(VarCurr,B) ) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_184,axiom,
    ! [VarNext] :
      ( v3569(VarNext)
     => ! [B] :
          ( range_147_0(B)
         => ( v18918(VarNext,B)
          <=> v3593(VarNext,B) ) ) ) ).

fof(addAssignment_2738,axiom,
    ! [VarCurr] :
      ( v8258(VarCurr,bitIndex81)
    <=> v8260(VarCurr,bitIndex81) ) ).

fof(addAssignment_2737,axiom,
    ! [VarCurr] :
      ( v8260(VarCurr,bitIndex81)
    <=> v9317(VarCurr,bitIndex81) ) ).

fof(addAssignment_2736,axiom,
    ! [VarCurr] :
      ( v8262(VarCurr,bitIndex41)
    <=> v8264(VarCurr,bitIndex41) ) ).

fof(addAssignment_2735,axiom,
    ! [VarNext] :
      ( v8264(VarNext,bitIndex41)
    <=> v18910(VarNext,bitIndex41) ) ).

fof(addCaseBooleanConditionEqualRanges1_141,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18911(VarNext)
       => ! [B] :
            ( range_145_0(B)
           => ( v18910(VarNext,B)
            <=> v8264(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_708,axiom,
    ! [VarNext] :
      ( v18911(VarNext)
     => ! [B] :
          ( range_145_0(B)
         => ( v18910(VarNext,B)
          <=> v8792(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4937,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18911(VarNext)
      <=> v18912(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4936,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18912(VarNext)
      <=> ( v18914(VarNext)
          & v98(VarNext) ) ) ) ).

fof(writeUnaryOperator_1473,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18914(VarNext)
      <=> v7677(VarNext) ) ) ).

fof(addAssignment_2734,axiom,
    ! [VarCurr] :
      ( v1214(VarCurr,bitIndex41)
    <=> v1216(VarCurr,bitIndex41) ) ).

fof(addAssignment_2733,axiom,
    ! [VarCurr] :
      ( v1216(VarCurr,bitIndex41)
    <=> v1218(VarCurr,bitIndex41) ) ).

fof(addAssignment_2732,axiom,
    ! [VarCurr] :
      ( v1218(VarCurr,bitIndex41)
    <=> v1220(VarCurr,bitIndex41) ) ).

fof(addAssignment_2731,axiom,
    ! [VarCurr] :
      ( v1220(VarCurr,bitIndex41)
    <=> v1222(VarCurr,bitIndex41) ) ).

fof(addAssignment_2730,axiom,
    ! [VarCurr] :
      ( v1222(VarCurr,bitIndex41)
    <=> v1224(VarCurr,bitIndex41) ) ).

fof(addAssignment_2729,axiom,
    ! [VarCurr] :
      ( v1224(VarCurr,bitIndex41)
    <=> v1226(VarCurr,bitIndex41) ) ).

fof(addAssignment_2728,axiom,
    ! [VarCurr] :
      ( v1226(VarCurr,bitIndex41)
    <=> v1228(VarCurr,bitIndex41) ) ).

fof(addAssignment_2727,axiom,
    ! [VarNext] :
      ( v1228(VarNext,bitIndex41)
    <=> v18908(VarNext,bitIndex41) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_165,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3569(VarNext)
       => ! [B] :
            ( range_147_0(B)
           => ( v18908(VarNext,B)
            <=> v1228(VarCurr,B) ) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_183,axiom,
    ! [VarNext] :
      ( v3569(VarNext)
     => ! [B] :
          ( range_147_0(B)
         => ( v18908(VarNext,B)
          <=> v3593(VarNext,B) ) ) ) ).

fof(addAssignment_2726,axiom,
    ! [VarCurr] :
      ( v8258(VarCurr,bitIndex113)
    <=> v8260(VarCurr,bitIndex113) ) ).

fof(addAssignment_2725,axiom,
    ! [VarCurr] :
      ( v8260(VarCurr,bitIndex113)
    <=> v9317(VarCurr,bitIndex113) ) ).

fof(addAssignment_2724,axiom,
    ! [VarCurr] :
      ( v8262(VarCurr,bitIndex9)
    <=> v8264(VarCurr,bitIndex9) ) ).

fof(addAssignment_2723,axiom,
    ! [VarNext] :
      ( v8264(VarNext,bitIndex9)
    <=> v18900(VarNext,bitIndex9) ) ).

fof(addCaseBooleanConditionEqualRanges1_140,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18901(VarNext)
       => ! [B] :
            ( range_145_0(B)
           => ( v18900(VarNext,B)
            <=> v8264(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_707,axiom,
    ! [VarNext] :
      ( v18901(VarNext)
     => ! [B] :
          ( range_145_0(B)
         => ( v18900(VarNext,B)
          <=> v8792(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4935,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18901(VarNext)
      <=> v18902(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4934,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18902(VarNext)
      <=> ( v18904(VarNext)
          & v98(VarNext) ) ) ) ).

fof(writeUnaryOperator_1472,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18904(VarNext)
      <=> v7677(VarNext) ) ) ).

fof(addAssignment_2722,axiom,
    ! [VarCurr] :
      ( v1214(VarCurr,bitIndex9)
    <=> v1216(VarCurr,bitIndex9) ) ).

fof(addAssignment_2721,axiom,
    ! [VarCurr] :
      ( v1216(VarCurr,bitIndex9)
    <=> v1218(VarCurr,bitIndex9) ) ).

fof(addAssignment_2720,axiom,
    ! [VarCurr] :
      ( v1218(VarCurr,bitIndex9)
    <=> v1220(VarCurr,bitIndex9) ) ).

fof(addAssignment_2719,axiom,
    ! [VarCurr] :
      ( v1220(VarCurr,bitIndex9)
    <=> v1222(VarCurr,bitIndex9) ) ).

fof(addAssignment_2718,axiom,
    ! [VarCurr] :
      ( v1222(VarCurr,bitIndex9)
    <=> v1224(VarCurr,bitIndex9) ) ).

fof(addAssignment_2717,axiom,
    ! [VarCurr] :
      ( v1224(VarCurr,bitIndex9)
    <=> v1226(VarCurr,bitIndex9) ) ).

fof(addAssignment_2716,axiom,
    ! [VarCurr] :
      ( v1226(VarCurr,bitIndex9)
    <=> v1228(VarCurr,bitIndex9) ) ).

fof(addAssignment_2715,axiom,
    ! [VarNext] :
      ( v1228(VarNext,bitIndex9)
    <=> v18898(VarNext,bitIndex9) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_164,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3569(VarNext)
       => ! [B] :
            ( range_147_0(B)
           => ( v18898(VarNext,B)
            <=> v1228(VarCurr,B) ) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_182,axiom,
    ! [VarNext] :
      ( v3569(VarNext)
     => ! [B] :
          ( range_147_0(B)
         => ( v18898(VarNext,B)
          <=> v3593(VarNext,B) ) ) ) ).

fof(addAssignment_2714,axiom,
    ! [VarCurr] :
      ( v18810(VarCurr,bitIndex0)
    <=> v18886(VarCurr,bitIndex0) ) ).

fof(addParallelCaseBooleanConditionEqualRanges9_4,axiom,
    ! [VarCurr] :
      ( ( ~ v18887(VarCurr)
        & ~ v18889(VarCurr)
        & ~ v18890(VarCurr)
        & ~ v18891(VarCurr)
        & ~ v18892(VarCurr)
        & ~ v18893(VarCurr)
        & ~ v18894(VarCurr)
        & ~ v18895(VarCurr)
        & ~ v18896(VarCurr) )
     => ! [B] :
          ( range_15_0(B)
         => ( v18886(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges8_5,axiom,
    ! [VarCurr] :
      ( v18896(VarCurr)
     => ! [B] :
          ( range_15_0(B)
         => ( v18886(VarCurr,B)
          <=> v8258(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges7_9,axiom,
    ! [VarCurr] :
      ( v18895(VarCurr)
     => ( ( v18886(VarCurr,bitIndex15)
        <=> v8258(VarCurr,bitIndex31) )
        & ( v18886(VarCurr,bitIndex14)
        <=> v8258(VarCurr,bitIndex30) )
        & ( v18886(VarCurr,bitIndex13)
        <=> v8258(VarCurr,bitIndex29) )
        & ( v18886(VarCurr,bitIndex12)
        <=> v8258(VarCurr,bitIndex28) )
        & ( v18886(VarCurr,bitIndex11)
        <=> v8258(VarCurr,bitIndex27) )
        & ( v18886(VarCurr,bitIndex10)
        <=> v8258(VarCurr,bitIndex26) )
        & ( v18886(VarCurr,bitIndex9)
        <=> v8258(VarCurr,bitIndex25) )
        & ( v18886(VarCurr,bitIndex8)
        <=> v8258(VarCurr,bitIndex24) )
        & ( v18886(VarCurr,bitIndex7)
        <=> v8258(VarCurr,bitIndex23) )
        & ( v18886(VarCurr,bitIndex6)
        <=> v8258(VarCurr,bitIndex22) )
        & ( v18886(VarCurr,bitIndex5)
        <=> v8258(VarCurr,bitIndex21) )
        & ( v18886(VarCurr,bitIndex4)
        <=> v8258(VarCurr,bitIndex20) )
        & ( v18886(VarCurr,bitIndex3)
        <=> v8258(VarCurr,bitIndex19) )
        & ( v18886(VarCurr,bitIndex2)
        <=> v8258(VarCurr,bitIndex18) )
        & ( v18886(VarCurr,bitIndex1)
        <=> v8258(VarCurr,bitIndex17) )
        & ( v18886(VarCurr,bitIndex0)
        <=> v8258(VarCurr,bitIndex16) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges6_9,axiom,
    ! [VarCurr] :
      ( v18894(VarCurr)
     => ( ( v18886(VarCurr,bitIndex15)
        <=> v8258(VarCurr,bitIndex47) )
        & ( v18886(VarCurr,bitIndex14)
        <=> v8258(VarCurr,bitIndex46) )
        & ( v18886(VarCurr,bitIndex13)
        <=> v8258(VarCurr,bitIndex45) )
        & ( v18886(VarCurr,bitIndex12)
        <=> v8258(VarCurr,bitIndex44) )
        & ( v18886(VarCurr,bitIndex11)
        <=> v8258(VarCurr,bitIndex43) )
        & ( v18886(VarCurr,bitIndex10)
        <=> v8258(VarCurr,bitIndex42) )
        & ( v18886(VarCurr,bitIndex9)
        <=> v8258(VarCurr,bitIndex41) )
        & ( v18886(VarCurr,bitIndex8)
        <=> v8258(VarCurr,bitIndex40) )
        & ( v18886(VarCurr,bitIndex7)
        <=> v8258(VarCurr,bitIndex39) )
        & ( v18886(VarCurr,bitIndex6)
        <=> v8258(VarCurr,bitIndex38) )
        & ( v18886(VarCurr,bitIndex5)
        <=> v8258(VarCurr,bitIndex37) )
        & ( v18886(VarCurr,bitIndex4)
        <=> v8258(VarCurr,bitIndex36) )
        & ( v18886(VarCurr,bitIndex3)
        <=> v8258(VarCurr,bitIndex35) )
        & ( v18886(VarCurr,bitIndex2)
        <=> v8258(VarCurr,bitIndex34) )
        & ( v18886(VarCurr,bitIndex1)
        <=> v8258(VarCurr,bitIndex33) )
        & ( v18886(VarCurr,bitIndex0)
        <=> v8258(VarCurr,bitIndex32) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges5_9,axiom,
    ! [VarCurr] :
      ( v18893(VarCurr)
     => ( ( v18886(VarCurr,bitIndex15)
        <=> v8258(VarCurr,bitIndex63) )
        & ( v18886(VarCurr,bitIndex14)
        <=> v8258(VarCurr,bitIndex62) )
        & ( v18886(VarCurr,bitIndex13)
        <=> v8258(VarCurr,bitIndex61) )
        & ( v18886(VarCurr,bitIndex12)
        <=> v8258(VarCurr,bitIndex60) )
        & ( v18886(VarCurr,bitIndex11)
        <=> v8258(VarCurr,bitIndex59) )
        & ( v18886(VarCurr,bitIndex10)
        <=> v8258(VarCurr,bitIndex58) )
        & ( v18886(VarCurr,bitIndex9)
        <=> v8258(VarCurr,bitIndex57) )
        & ( v18886(VarCurr,bitIndex8)
        <=> v8258(VarCurr,bitIndex56) )
        & ( v18886(VarCurr,bitIndex7)
        <=> v8258(VarCurr,bitIndex55) )
        & ( v18886(VarCurr,bitIndex6)
        <=> v8258(VarCurr,bitIndex54) )
        & ( v18886(VarCurr,bitIndex5)
        <=> v8258(VarCurr,bitIndex53) )
        & ( v18886(VarCurr,bitIndex4)
        <=> v8258(VarCurr,bitIndex52) )
        & ( v18886(VarCurr,bitIndex3)
        <=> v8258(VarCurr,bitIndex51) )
        & ( v18886(VarCurr,bitIndex2)
        <=> v8258(VarCurr,bitIndex50) )
        & ( v18886(VarCurr,bitIndex1)
        <=> v8258(VarCurr,bitIndex49) )
        & ( v18886(VarCurr,bitIndex0)
        <=> v8258(VarCurr,bitIndex48) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges4_9,axiom,
    ! [VarCurr] :
      ( v18892(VarCurr)
     => ( ( v18886(VarCurr,bitIndex15)
        <=> v8258(VarCurr,bitIndex79) )
        & ( v18886(VarCurr,bitIndex14)
        <=> v8258(VarCurr,bitIndex78) )
        & ( v18886(VarCurr,bitIndex13)
        <=> v8258(VarCurr,bitIndex77) )
        & ( v18886(VarCurr,bitIndex12)
        <=> v8258(VarCurr,bitIndex76) )
        & ( v18886(VarCurr,bitIndex11)
        <=> v8258(VarCurr,bitIndex75) )
        & ( v18886(VarCurr,bitIndex10)
        <=> v8258(VarCurr,bitIndex74) )
        & ( v18886(VarCurr,bitIndex9)
        <=> v8258(VarCurr,bitIndex73) )
        & ( v18886(VarCurr,bitIndex8)
        <=> v8258(VarCurr,bitIndex72) )
        & ( v18886(VarCurr,bitIndex7)
        <=> v8258(VarCurr,bitIndex71) )
        & ( v18886(VarCurr,bitIndex6)
        <=> v8258(VarCurr,bitIndex70) )
        & ( v18886(VarCurr,bitIndex5)
        <=> v8258(VarCurr,bitIndex69) )
        & ( v18886(VarCurr,bitIndex4)
        <=> v8258(VarCurr,bitIndex68) )
        & ( v18886(VarCurr,bitIndex3)
        <=> v8258(VarCurr,bitIndex67) )
        & ( v18886(VarCurr,bitIndex2)
        <=> v8258(VarCurr,bitIndex66) )
        & ( v18886(VarCurr,bitIndex1)
        <=> v8258(VarCurr,bitIndex65) )
        & ( v18886(VarCurr,bitIndex0)
        <=> v8258(VarCurr,bitIndex64) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges3_10,axiom,
    ! [VarCurr] :
      ( v18891(VarCurr)
     => ( ( v18886(VarCurr,bitIndex15)
        <=> v8258(VarCurr,bitIndex95) )
        & ( v18886(VarCurr,bitIndex14)
        <=> v8258(VarCurr,bitIndex94) )
        & ( v18886(VarCurr,bitIndex13)
        <=> v8258(VarCurr,bitIndex93) )
        & ( v18886(VarCurr,bitIndex12)
        <=> v8258(VarCurr,bitIndex92) )
        & ( v18886(VarCurr,bitIndex11)
        <=> v8258(VarCurr,bitIndex91) )
        & ( v18886(VarCurr,bitIndex10)
        <=> v8258(VarCurr,bitIndex90) )
        & ( v18886(VarCurr,bitIndex9)
        <=> v8258(VarCurr,bitIndex89) )
        & ( v18886(VarCurr,bitIndex8)
        <=> v8258(VarCurr,bitIndex88) )
        & ( v18886(VarCurr,bitIndex7)
        <=> v8258(VarCurr,bitIndex87) )
        & ( v18886(VarCurr,bitIndex6)
        <=> v8258(VarCurr,bitIndex86) )
        & ( v18886(VarCurr,bitIndex5)
        <=> v8258(VarCurr,bitIndex85) )
        & ( v18886(VarCurr,bitIndex4)
        <=> v8258(VarCurr,bitIndex84) )
        & ( v18886(VarCurr,bitIndex3)
        <=> v8258(VarCurr,bitIndex83) )
        & ( v18886(VarCurr,bitIndex2)
        <=> v8258(VarCurr,bitIndex82) )
        & ( v18886(VarCurr,bitIndex1)
        <=> v8258(VarCurr,bitIndex81) )
        & ( v18886(VarCurr,bitIndex0)
        <=> v8258(VarCurr,bitIndex80) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges2_10,axiom,
    ! [VarCurr] :
      ( v18890(VarCurr)
     => ( ( v18886(VarCurr,bitIndex15)
        <=> v8258(VarCurr,bitIndex111) )
        & ( v18886(VarCurr,bitIndex14)
        <=> v8258(VarCurr,bitIndex110) )
        & ( v18886(VarCurr,bitIndex13)
        <=> v8258(VarCurr,bitIndex109) )
        & ( v18886(VarCurr,bitIndex12)
        <=> v8258(VarCurr,bitIndex108) )
        & ( v18886(VarCurr,bitIndex11)
        <=> v8258(VarCurr,bitIndex107) )
        & ( v18886(VarCurr,bitIndex10)
        <=> v8258(VarCurr,bitIndex106) )
        & ( v18886(VarCurr,bitIndex9)
        <=> v8258(VarCurr,bitIndex105) )
        & ( v18886(VarCurr,bitIndex8)
        <=> v8258(VarCurr,bitIndex104) )
        & ( v18886(VarCurr,bitIndex7)
        <=> v8258(VarCurr,bitIndex103) )
        & ( v18886(VarCurr,bitIndex6)
        <=> v8258(VarCurr,bitIndex102) )
        & ( v18886(VarCurr,bitIndex5)
        <=> v8258(VarCurr,bitIndex101) )
        & ( v18886(VarCurr,bitIndex4)
        <=> v8258(VarCurr,bitIndex100) )
        & ( v18886(VarCurr,bitIndex3)
        <=> v8258(VarCurr,bitIndex99) )
        & ( v18886(VarCurr,bitIndex2)
        <=> v8258(VarCurr,bitIndex98) )
        & ( v18886(VarCurr,bitIndex1)
        <=> v8258(VarCurr,bitIndex97) )
        & ( v18886(VarCurr,bitIndex0)
        <=> v8258(VarCurr,bitIndex96) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges1_10,axiom,
    ! [VarCurr] :
      ( v18889(VarCurr)
     => ( ( v18886(VarCurr,bitIndex15)
        <=> v8258(VarCurr,bitIndex127) )
        & ( v18886(VarCurr,bitIndex14)
        <=> v8258(VarCurr,bitIndex126) )
        & ( v18886(VarCurr,bitIndex13)
        <=> v8258(VarCurr,bitIndex125) )
        & ( v18886(VarCurr,bitIndex12)
        <=> v8258(VarCurr,bitIndex124) )
        & ( v18886(VarCurr,bitIndex11)
        <=> v8258(VarCurr,bitIndex123) )
        & ( v18886(VarCurr,bitIndex10)
        <=> v8258(VarCurr,bitIndex122) )
        & ( v18886(VarCurr,bitIndex9)
        <=> v8258(VarCurr,bitIndex121) )
        & ( v18886(VarCurr,bitIndex8)
        <=> v8258(VarCurr,bitIndex120) )
        & ( v18886(VarCurr,bitIndex7)
        <=> v8258(VarCurr,bitIndex119) )
        & ( v18886(VarCurr,bitIndex6)
        <=> v8258(VarCurr,bitIndex118) )
        & ( v18886(VarCurr,bitIndex5)
        <=> v8258(VarCurr,bitIndex117) )
        & ( v18886(VarCurr,bitIndex4)
        <=> v8258(VarCurr,bitIndex116) )
        & ( v18886(VarCurr,bitIndex3)
        <=> v8258(VarCurr,bitIndex115) )
        & ( v18886(VarCurr,bitIndex2)
        <=> v8258(VarCurr,bitIndex114) )
        & ( v18886(VarCurr,bitIndex1)
        <=> v8258(VarCurr,bitIndex113) )
        & ( v18886(VarCurr,bitIndex0)
        <=> v8258(VarCurr,bitIndex112) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_37,axiom,
    ! [VarCurr] :
      ( v18887(VarCurr)
     => ! [B] :
          ( range_15_0(B)
         => ( v18886(VarCurr,B)
          <=> $false ) ) ) ).

fof(bitBlastConstant_2508,axiom,
    ~ b0000000000000000(bitIndex15) ).

fof(bitBlastConstant_2507,axiom,
    ~ b0000000000000000(bitIndex14) ).

fof(bitBlastConstant_2506,axiom,
    ~ b0000000000000000(bitIndex13) ).

fof(bitBlastConstant_2505,axiom,
    ~ b0000000000000000(bitIndex12) ).

fof(bitBlastConstant_2504,axiom,
    ~ b0000000000000000(bitIndex11) ).

fof(bitBlastConstant_2503,axiom,
    ~ b0000000000000000(bitIndex10) ).

fof(bitBlastConstant_2502,axiom,
    ~ b0000000000000000(bitIndex9) ).

fof(bitBlastConstant_2501,axiom,
    ~ b0000000000000000(bitIndex8) ).

fof(bitBlastConstant_2500,axiom,
    ~ b0000000000000000(bitIndex7) ).

fof(bitBlastConstant_2499,axiom,
    ~ b0000000000000000(bitIndex6) ).

fof(bitBlastConstant_2498,axiom,
    ~ b0000000000000000(bitIndex5) ).

fof(bitBlastConstant_2497,axiom,
    ~ b0000000000000000(bitIndex4) ).

fof(bitBlastConstant_2496,axiom,
    ~ b0000000000000000(bitIndex3) ).

fof(bitBlastConstant_2495,axiom,
    ~ b0000000000000000(bitIndex2) ).

fof(bitBlastConstant_2494,axiom,
    ~ b0000000000000000(bitIndex1) ).

fof(bitBlastConstant_2493,axiom,
    ~ b0000000000000000(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_1323,axiom,
    ! [VarCurr] :
      ( v18896(VarCurr)
    <=> ( ( v18888(VarCurr,bitIndex3)
        <=> $true )
        & ( v18888(VarCurr,bitIndex2)
        <=> $false )
        & ( v18888(VarCurr,bitIndex1)
        <=> $true )
        & ( v18888(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1322,axiom,
    ! [VarCurr] :
      ( v18895(VarCurr)
    <=> ( ( v18888(VarCurr,bitIndex3)
        <=> $false )
        & ( v18888(VarCurr,bitIndex2)
        <=> $true )
        & ( v18888(VarCurr,bitIndex1)
        <=> $true )
        & ( v18888(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1321,axiom,
    ! [VarCurr] :
      ( v18894(VarCurr)
    <=> ( ( v18888(VarCurr,bitIndex3)
        <=> $true )
        & ( v18888(VarCurr,bitIndex2)
        <=> $false )
        & ( v18888(VarCurr,bitIndex1)
        <=> $true )
        & ( v18888(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1320,axiom,
    ! [VarCurr] :
      ( v18893(VarCurr)
    <=> ( ( v18888(VarCurr,bitIndex3)
        <=> $false )
        & ( v18888(VarCurr,bitIndex2)
        <=> $true )
        & ( v18888(VarCurr,bitIndex1)
        <=> $true )
        & ( v18888(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1319,axiom,
    ! [VarCurr] :
      ( v18892(VarCurr)
    <=> ( ( v18888(VarCurr,bitIndex3)
        <=> $true )
        & ( v18888(VarCurr,bitIndex2)
        <=> $false )
        & ( v18888(VarCurr,bitIndex1)
        <=> $false )
        & ( v18888(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1318,axiom,
    ! [VarCurr] :
      ( v18891(VarCurr)
    <=> ( ( v18888(VarCurr,bitIndex3)
        <=> $false )
        & ( v18888(VarCurr,bitIndex2)
        <=> $true )
        & ( v18888(VarCurr,bitIndex1)
        <=> $false )
        & ( v18888(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1317,axiom,
    ! [VarCurr] :
      ( v18890(VarCurr)
    <=> ( ( v18888(VarCurr,bitIndex3)
        <=> $true )
        & ( v18888(VarCurr,bitIndex2)
        <=> $false )
        & ( v18888(VarCurr,bitIndex1)
        <=> $false )
        & ( v18888(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1316,axiom,
    ! [VarCurr] :
      ( v18889(VarCurr)
    <=> ( ( v18888(VarCurr,bitIndex3)
        <=> $false )
        & ( v18888(VarCurr,bitIndex2)
        <=> $true )
        & ( v18888(VarCurr,bitIndex1)
        <=> $false )
        & ( v18888(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1315,axiom,
    ! [VarCurr] :
      ( v18887(VarCurr)
    <=> ( ( v18888(VarCurr,bitIndex3)
        <=> $false )
        & ( v18888(VarCurr,bitIndex2)
        <=> $false )
        & ( v18888(VarCurr,bitIndex1)
        <=> $false )
        & ( v18888(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2713,axiom,
    ! [VarCurr,B] :
      ( range_1_0(B)
     => ( v18888(VarCurr,B)
      <=> v18812(VarCurr,B) ) ) ).

fof(addAssignment_2712,axiom,
    ! [VarCurr] :
      ( ( v18888(VarCurr,bitIndex3)
      <=> v7805(VarCurr,bitIndex1) )
      & ( v18888(VarCurr,bitIndex2)
      <=> v7805(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_2711,axiom,
    ! [VarCurr] :
      ( v8258(VarCurr,bitIndex16)
    <=> v8260(VarCurr,bitIndex16) ) ).

fof(addAssignment_2710,axiom,
    ! [VarCurr] :
      ( v8260(VarCurr,bitIndex16)
    <=> v9317(VarCurr,bitIndex16) ) ).

fof(addAssignment_2709,axiom,
    ! [VarCurr] :
      ( v8262(VarCurr,bitIndex104)
    <=> v8264(VarCurr,bitIndex104) ) ).

fof(addAssignment_2708,axiom,
    ! [VarNext] :
      ( v8264(VarNext,bitIndex104)
    <=> v18879(VarNext,bitIndex104) ) ).

fof(addCaseBooleanConditionEqualRanges1_139,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18880(VarNext)
       => ! [B] :
            ( range_145_0(B)
           => ( v18879(VarNext,B)
            <=> v8264(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_706,axiom,
    ! [VarNext] :
      ( v18880(VarNext)
     => ! [B] :
          ( range_145_0(B)
         => ( v18879(VarNext,B)
          <=> v8792(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4933,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18880(VarNext)
      <=> v18881(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4932,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18881(VarNext)
      <=> ( v18883(VarNext)
          & v98(VarNext) ) ) ) ).

fof(writeUnaryOperator_1471,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18883(VarNext)
      <=> v7677(VarNext) ) ) ).

fof(addAssignment_2707,axiom,
    ! [VarCurr] :
      ( v1214(VarCurr,bitIndex104)
    <=> v1216(VarCurr,bitIndex104) ) ).

fof(addAssignment_2706,axiom,
    ! [VarCurr] :
      ( v1216(VarCurr,bitIndex104)
    <=> v1218(VarCurr,bitIndex104) ) ).

fof(addAssignment_2705,axiom,
    ! [VarCurr] :
      ( v1218(VarCurr,bitIndex104)
    <=> v1220(VarCurr,bitIndex104) ) ).

fof(addAssignment_2704,axiom,
    ! [VarCurr] :
      ( v1220(VarCurr,bitIndex104)
    <=> v1222(VarCurr,bitIndex104) ) ).

fof(addAssignment_2703,axiom,
    ! [VarCurr] :
      ( v1222(VarCurr,bitIndex104)
    <=> v1224(VarCurr,bitIndex104) ) ).

fof(addAssignment_2702,axiom,
    ! [VarCurr] :
      ( v1224(VarCurr,bitIndex104)
    <=> v1226(VarCurr,bitIndex104) ) ).

fof(addAssignment_2701,axiom,
    ! [VarCurr] :
      ( v1226(VarCurr,bitIndex104)
    <=> v1228(VarCurr,bitIndex104) ) ).

fof(addAssignment_2700,axiom,
    ! [VarNext] :
      ( v1228(VarNext,bitIndex104)
    <=> v18877(VarNext,bitIndex104) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_163,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3569(VarNext)
       => ! [B] :
            ( range_147_0(B)
           => ( v18877(VarNext,B)
            <=> v1228(VarCurr,B) ) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_181,axiom,
    ! [VarNext] :
      ( v3569(VarNext)
     => ! [B] :
          ( range_147_0(B)
         => ( v18877(VarNext,B)
          <=> v3593(VarNext,B) ) ) ) ).

fof(addAssignment_2699,axiom,
    ! [VarCurr] :
      ( v8258(VarCurr,bitIndex48)
    <=> v8260(VarCurr,bitIndex48) ) ).

fof(addAssignment_2698,axiom,
    ! [VarCurr] :
      ( v8260(VarCurr,bitIndex48)
    <=> v9317(VarCurr,bitIndex48) ) ).

fof(addAssignment_2697,axiom,
    ! [VarCurr] :
      ( v8262(VarCurr,bitIndex72)
    <=> v8264(VarCurr,bitIndex72) ) ).

fof(addAssignment_2696,axiom,
    ! [VarNext] :
      ( v8264(VarNext,bitIndex72)
    <=> v18869(VarNext,bitIndex72) ) ).

fof(addCaseBooleanConditionEqualRanges1_138,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18870(VarNext)
       => ! [B] :
            ( range_145_0(B)
           => ( v18869(VarNext,B)
            <=> v8264(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_705,axiom,
    ! [VarNext] :
      ( v18870(VarNext)
     => ! [B] :
          ( range_145_0(B)
         => ( v18869(VarNext,B)
          <=> v8792(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4931,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18870(VarNext)
      <=> v18871(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4930,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18871(VarNext)
      <=> ( v18873(VarNext)
          & v98(VarNext) ) ) ) ).

fof(writeUnaryOperator_1470,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18873(VarNext)
      <=> v7677(VarNext) ) ) ).

fof(addAssignment_2695,axiom,
    ! [VarCurr] :
      ( v1214(VarCurr,bitIndex72)
    <=> v1216(VarCurr,bitIndex72) ) ).

fof(addAssignment_2694,axiom,
    ! [VarCurr] :
      ( v1216(VarCurr,bitIndex72)
    <=> v1218(VarCurr,bitIndex72) ) ).

fof(addAssignment_2693,axiom,
    ! [VarCurr] :
      ( v1218(VarCurr,bitIndex72)
    <=> v1220(VarCurr,bitIndex72) ) ).

fof(addAssignment_2692,axiom,
    ! [VarCurr] :
      ( v1220(VarCurr,bitIndex72)
    <=> v1222(VarCurr,bitIndex72) ) ).

fof(addAssignment_2691,axiom,
    ! [VarCurr] :
      ( v1222(VarCurr,bitIndex72)
    <=> v1224(VarCurr,bitIndex72) ) ).

fof(addAssignment_2690,axiom,
    ! [VarCurr] :
      ( v1224(VarCurr,bitIndex72)
    <=> v1226(VarCurr,bitIndex72) ) ).

fof(addAssignment_2689,axiom,
    ! [VarCurr] :
      ( v1226(VarCurr,bitIndex72)
    <=> v1228(VarCurr,bitIndex72) ) ).

fof(addAssignment_2688,axiom,
    ! [VarNext] :
      ( v1228(VarNext,bitIndex72)
    <=> v18867(VarNext,bitIndex72) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_162,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3569(VarNext)
       => ! [B] :
            ( range_147_0(B)
           => ( v18867(VarNext,B)
            <=> v1228(VarCurr,B) ) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_180,axiom,
    ! [VarNext] :
      ( v3569(VarNext)
     => ! [B] :
          ( range_147_0(B)
         => ( v18867(VarNext,B)
          <=> v3593(VarNext,B) ) ) ) ).

fof(addAssignment_2687,axiom,
    ! [VarCurr] :
      ( v8258(VarCurr,bitIndex80)
    <=> v8260(VarCurr,bitIndex80) ) ).

fof(addAssignment_2686,axiom,
    ! [VarCurr] :
      ( v8260(VarCurr,bitIndex80)
    <=> v9317(VarCurr,bitIndex80) ) ).

fof(addAssignment_2685,axiom,
    ! [VarCurr] :
      ( v8262(VarCurr,bitIndex40)
    <=> v8264(VarCurr,bitIndex40) ) ).

fof(addAssignment_2684,axiom,
    ! [VarNext] :
      ( v8264(VarNext,bitIndex40)
    <=> v18859(VarNext,bitIndex40) ) ).

fof(addCaseBooleanConditionEqualRanges1_137,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18860(VarNext)
       => ! [B] :
            ( range_145_0(B)
           => ( v18859(VarNext,B)
            <=> v8264(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_704,axiom,
    ! [VarNext] :
      ( v18860(VarNext)
     => ! [B] :
          ( range_145_0(B)
         => ( v18859(VarNext,B)
          <=> v8792(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4929,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18860(VarNext)
      <=> v18861(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4928,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18861(VarNext)
      <=> ( v18863(VarNext)
          & v98(VarNext) ) ) ) ).

fof(writeUnaryOperator_1469,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18863(VarNext)
      <=> v7677(VarNext) ) ) ).

fof(addAssignment_2683,axiom,
    ! [VarCurr] :
      ( v1214(VarCurr,bitIndex40)
    <=> v1216(VarCurr,bitIndex40) ) ).

fof(addAssignment_2682,axiom,
    ! [VarCurr] :
      ( v1216(VarCurr,bitIndex40)
    <=> v1218(VarCurr,bitIndex40) ) ).

fof(addAssignment_2681,axiom,
    ! [VarCurr] :
      ( v1218(VarCurr,bitIndex40)
    <=> v1220(VarCurr,bitIndex40) ) ).

fof(addAssignment_2680,axiom,
    ! [VarCurr] :
      ( v1220(VarCurr,bitIndex40)
    <=> v1222(VarCurr,bitIndex40) ) ).

fof(addAssignment_2679,axiom,
    ! [VarCurr] :
      ( v1222(VarCurr,bitIndex40)
    <=> v1224(VarCurr,bitIndex40) ) ).

fof(addAssignment_2678,axiom,
    ! [VarCurr] :
      ( v1224(VarCurr,bitIndex40)
    <=> v1226(VarCurr,bitIndex40) ) ).

fof(addAssignment_2677,axiom,
    ! [VarCurr] :
      ( v1226(VarCurr,bitIndex40)
    <=> v1228(VarCurr,bitIndex40) ) ).

fof(addAssignment_2676,axiom,
    ! [VarNext] :
      ( v1228(VarNext,bitIndex40)
    <=> v18857(VarNext,bitIndex40) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_161,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3569(VarNext)
       => ! [B] :
            ( range_147_0(B)
           => ( v18857(VarNext,B)
            <=> v1228(VarCurr,B) ) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_179,axiom,
    ! [VarNext] :
      ( v3569(VarNext)
     => ! [B] :
          ( range_147_0(B)
         => ( v18857(VarNext,B)
          <=> v3593(VarNext,B) ) ) ) ).

fof(addAssignment_2675,axiom,
    ! [VarCurr] :
      ( v8258(VarCurr,bitIndex112)
    <=> v8260(VarCurr,bitIndex112) ) ).

fof(addAssignment_2674,axiom,
    ! [VarCurr] :
      ( v8260(VarCurr,bitIndex112)
    <=> v9317(VarCurr,bitIndex112) ) ).

fof(addAssignment_2673,axiom,
    ! [VarCurr] :
      ( v8262(VarCurr,bitIndex8)
    <=> v8264(VarCurr,bitIndex8) ) ).

fof(addAssignment_2672,axiom,
    ! [VarNext] :
      ( v8264(VarNext,bitIndex8)
    <=> v18849(VarNext,bitIndex8) ) ).

fof(addCaseBooleanConditionEqualRanges1_136,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18850(VarNext)
       => ! [B] :
            ( range_145_0(B)
           => ( v18849(VarNext,B)
            <=> v8264(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_703,axiom,
    ! [VarNext] :
      ( v18850(VarNext)
     => ! [B] :
          ( range_145_0(B)
         => ( v18849(VarNext,B)
          <=> v8792(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4927,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18850(VarNext)
      <=> v18851(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4926,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18851(VarNext)
      <=> ( v18853(VarNext)
          & v98(VarNext) ) ) ) ).

fof(writeUnaryOperator_1468,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18853(VarNext)
      <=> v7677(VarNext) ) ) ).

fof(addAssignment_2671,axiom,
    ! [VarCurr] :
      ( v1214(VarCurr,bitIndex8)
    <=> v1216(VarCurr,bitIndex8) ) ).

fof(addAssignment_2670,axiom,
    ! [VarCurr] :
      ( v1216(VarCurr,bitIndex8)
    <=> v1218(VarCurr,bitIndex8) ) ).

fof(addAssignment_2669,axiom,
    ! [VarCurr] :
      ( v1218(VarCurr,bitIndex8)
    <=> v1220(VarCurr,bitIndex8) ) ).

fof(addAssignment_2668,axiom,
    ! [VarCurr] :
      ( v1220(VarCurr,bitIndex8)
    <=> v1222(VarCurr,bitIndex8) ) ).

fof(addAssignment_2667,axiom,
    ! [VarCurr] :
      ( v1222(VarCurr,bitIndex8)
    <=> v1224(VarCurr,bitIndex8) ) ).

fof(addAssignment_2666,axiom,
    ! [VarCurr] :
      ( v1224(VarCurr,bitIndex8)
    <=> v1226(VarCurr,bitIndex8) ) ).

fof(addAssignment_2665,axiom,
    ! [VarCurr] :
      ( v1226(VarCurr,bitIndex8)
    <=> v1228(VarCurr,bitIndex8) ) ).

fof(addAssignment_2664,axiom,
    ! [VarNext] :
      ( v1228(VarNext,bitIndex8)
    <=> v18847(VarNext,bitIndex8) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_160,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3569(VarNext)
       => ! [B] :
            ( range_147_0(B)
           => ( v18847(VarNext,B)
            <=> v1228(VarCurr,B) ) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_178,axiom,
    ! [VarNext] :
      ( v3569(VarNext)
     => ! [B] :
          ( range_147_0(B)
         => ( v18847(VarNext,B)
          <=> v3593(VarNext,B) ) ) ) ).

fof(addAssignment_2663,axiom,
    ! [VarCurr,B] :
      ( range_1_0(B)
     => ( v18812(VarCurr,B)
      <=> v18814(VarCurr,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_135,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18833(VarNext)
       => ! [B] :
            ( range_1_0(B)
           => ( v18814(VarNext,B)
            <=> v18814(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_702,axiom,
    ! [VarNext] :
      ( v18833(VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v18814(VarNext,B)
          <=> v18842(VarNext,B) ) ) ) ).

fof(addAssignment_2662,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v18842(VarNext,B)
          <=> v18816(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4925,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18833(VarNext)
      <=> v18834(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4924,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18834(VarNext)
      <=> ( v18835(VarNext)
          & v18830(VarNext) ) ) ) ).

fof(writeUnaryOperator_1467,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18835(VarNext)
      <=> v18837(VarNext) ) ) ).

fof(addAssignment_2661,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18837(VarNext)
      <=> v18830(VarCurr) ) ) ).

fof(addAssignment_2660,axiom,
    ! [VarCurr] :
      ( v18830(VarCurr)
    <=> v441(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_23,axiom,
    ! [VarCurr] :
      ( ( ~ v18824(VarCurr)
        & ~ v18826(VarCurr) )
     => ! [B] :
          ( range_1_0(B)
         => ( v18816(VarCurr,B)
          <=> v18814(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_34,axiom,
    ! [VarCurr] :
      ( v18826(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v18816(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_36,axiom,
    ! [VarCurr] :
      ( v18824(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v18816(VarCurr,B)
          <=> v18822(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4923,axiom,
    ! [VarCurr] :
      ( v18826(VarCurr)
    <=> ( v18827(VarCurr)
        | v18828(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_1314,axiom,
    ! [VarCurr] :
      ( v18828(VarCurr)
    <=> ( ( v18825(VarCurr,bitIndex1)
        <=> $true )
        & ( v18825(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1313,axiom,
    ! [VarCurr] :
      ( v18827(VarCurr)
    <=> ( ( v18825(VarCurr,bitIndex1)
        <=> $true )
        & ( v18825(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1312,axiom,
    ! [VarCurr] :
      ( v18824(VarCurr)
    <=> ( ( v18825(VarCurr,bitIndex1)
        <=> $false )
        & ( v18825(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2659,axiom,
    ! [VarCurr] :
      ( v18825(VarCurr,bitIndex0)
    <=> v18820(VarCurr) ) ).

fof(addAssignment_2658,axiom,
    ! [VarCurr] :
      ( v18825(VarCurr,bitIndex1)
    <=> v18818(VarCurr) ) ).

fof(addAssignment_2657,axiom,
    ! [VarCurr,B] :
      ( range_1_0(B)
     => ( v18822(VarCurr,B)
      <=> v7963(VarCurr,B) ) ) ).

fof(addAssignment_2656,axiom,
    ! [VarCurr] :
      ( v18820(VarCurr)
    <=> v7765(VarCurr) ) ).

fof(addAssignment_2655,axiom,
    ! [VarCurr] :
      ( v18818(VarCurr)
    <=> v7761(VarCurr) ) ).

fof(addAssignment_2654,axiom,
    ! [VarCurr] :
      ( v18801(VarCurr)
    <=> v18803(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_1598,axiom,
    ! [VarCurr] :
      ( v18803(VarCurr)
    <=> ( v6(VarCurr,bitIndex1)
        & v338(VarCurr) ) ) ).

fof(addAssignment_2653,axiom,
    ! [VarCurr] :
      ( v18799(VarCurr)
    <=> v7761(VarCurr) ) ).

fof(addAssignment_2652,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v12798(VarCurr,B)
      <=> v12800(VarCurr,B) ) ) ).

fof(addAssignment_2651,axiom,
    ! [VarNext,B] :
      ( range_3_0(B)
     => ( v12800(VarNext,B)
      <=> v18779(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_134,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18780(VarNext)
       => ! [B] :
            ( range_16_0(B)
           => ( v18779(VarNext,B)
            <=> v12800(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_701,axiom,
    ! [VarNext] :
      ( v18780(VarNext)
     => ! [B] :
          ( range_16_0(B)
         => ( v18779(VarNext,B)
          <=> v18789(VarNext,B) ) ) ) ).

fof(addAssignment_2650,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_16_0(B)
         => ( v18789(VarNext,B)
          <=> v12802(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4922,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18780(VarNext)
      <=> v18781(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4921,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18781(VarNext)
      <=> ( v18782(VarNext)
          & v18777(VarNext) ) ) ) ).

fof(writeUnaryOperator_1466,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18782(VarNext)
      <=> v18784(VarNext) ) ) ).

fof(addAssignment_2649,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18784(VarNext)
      <=> v18777(VarCurr) ) ) ).

fof(addAssignment_2648,axiom,
    ! [VarCurr] :
      ( v18777(VarCurr)
    <=> v441(VarCurr) ) ).

fof(addAssignment_2647,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v12802(VarCurr,B)
      <=> v18770(VarCurr,B) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_22,axiom,
    ! [VarCurr] :
      ( ( ~ v18771(VarCurr)
        & ~ v18773(VarCurr) )
     => ! [B] :
          ( range_16_0(B)
         => ( v18770(VarCurr,B)
          <=> v12800(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_33,axiom,
    ! [VarCurr] :
      ( v18773(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18770(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_35,axiom,
    ! [VarCurr] :
      ( v18771(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18770(VarCurr,B)
          <=> v18495(VarCurr,B) ) ) ) ).

fof(addAssignmentInitValueVector_14,axiom,
    ! [B] :
      ( range_16_0(B)
     => ( v12800(constB0,B)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4920,axiom,
    ! [VarCurr] :
      ( v18773(VarCurr)
    <=> ( v18774(VarCurr)
        | v18775(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_1311,axiom,
    ! [VarCurr] :
      ( v18775(VarCurr)
    <=> ( ( v18772(VarCurr,bitIndex1)
        <=> $true )
        & ( v18772(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1310,axiom,
    ! [VarCurr] :
      ( v18774(VarCurr)
    <=> ( ( v18772(VarCurr,bitIndex1)
        <=> $true )
        & ( v18772(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1309,axiom,
    ! [VarCurr] :
      ( v18771(VarCurr)
    <=> ( ( v18772(VarCurr,bitIndex1)
        <=> $false )
        & ( v18772(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2646,axiom,
    ! [VarCurr] :
      ( v18772(VarCurr,bitIndex0)
    <=> v12806(VarCurr) ) ).

fof(addAssignment_2645,axiom,
    ! [VarCurr] :
      ( v18772(VarCurr,bitIndex1)
    <=> v12804(VarCurr) ) ).

fof(addAssignment_2644,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v18495(VarCurr,B)
      <=> v18497(VarCurr,B) ) ) ).

fof(addAssignment_2643,axiom,
    ! [VarCurr] :
      ( ( v18497(VarCurr,bitIndex3)
      <=> v18569(VarCurr,bitIndex2) )
      & ( v18497(VarCurr,bitIndex2)
      <=> v18569(VarCurr,bitIndex1) )
      & ( v18497(VarCurr,bitIndex1)
      <=> v18569(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_2642,axiom,
    ! [VarCurr] :
      ( v18569(VarCurr,bitIndex0)
    <=> v18765(VarCurr) ) ).

fof(addAssignment_2641,axiom,
    ! [VarCurr] :
      ( v18569(VarCurr,bitIndex1)
    <=> v18760(VarCurr) ) ).

fof(addAssignment_2640,axiom,
    ! [VarCurr] :
      ( v18569(VarCurr,bitIndex2)
    <=> v18755(VarCurr) ) ).

fof(addAssignment_2639,axiom,
    ! [VarCurr] :
      ( v18569(VarCurr,bitIndex3)
    <=> v18750(VarCurr) ) ).

fof(addAssignment_2638,axiom,
    ! [VarCurr] :
      ( v18569(VarCurr,bitIndex4)
    <=> v18745(VarCurr) ) ).

fof(addAssignment_2637,axiom,
    ! [VarCurr] :
      ( v18569(VarCurr,bitIndex5)
    <=> v18740(VarCurr) ) ).

fof(addAssignment_2636,axiom,
    ! [VarCurr] :
      ( v18569(VarCurr,bitIndex6)
    <=> v18735(VarCurr) ) ).

fof(addAssignment_2635,axiom,
    ! [VarCurr] :
      ( v18569(VarCurr,bitIndex7)
    <=> v18730(VarCurr) ) ).

fof(addAssignment_2634,axiom,
    ! [VarCurr] :
      ( v18569(VarCurr,bitIndex8)
    <=> v18725(VarCurr) ) ).

fof(addAssignment_2633,axiom,
    ! [VarCurr] :
      ( v18569(VarCurr,bitIndex9)
    <=> v18720(VarCurr) ) ).

fof(addAssignment_2632,axiom,
    ! [VarCurr] :
      ( v18569(VarCurr,bitIndex10)
    <=> v18715(VarCurr) ) ).

fof(addAssignment_2631,axiom,
    ! [VarCurr] :
      ( v18569(VarCurr,bitIndex11)
    <=> v18710(VarCurr) ) ).

fof(addAssignment_2630,axiom,
    ! [VarCurr] :
      ( v18569(VarCurr,bitIndex12)
    <=> v18705(VarCurr) ) ).

fof(addAssignment_2629,axiom,
    ! [VarCurr] :
      ( v18569(VarCurr,bitIndex13)
    <=> v18700(VarCurr) ) ).

fof(addAssignment_2628,axiom,
    ! [VarCurr] :
      ( v18569(VarCurr,bitIndex14)
    <=> v18695(VarCurr) ) ).

fof(addAssignment_2627,axiom,
    ! [VarCurr] :
      ( v18569(VarCurr,bitIndex15)
    <=> v18571(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4919,axiom,
    ! [VarCurr] :
      ( v18765(VarCurr)
    <=> ( v18766(VarCurr)
        & v18769(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1597,axiom,
    ! [VarCurr] :
      ( v18769(VarCurr)
    <=> ( v18603(VarCurr,bitIndex0)
        | v18499(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4918,axiom,
    ! [VarCurr] :
      ( v18766(VarCurr)
    <=> ( v18767(VarCurr)
        | v18768(VarCurr) ) ) ).

fof(writeUnaryOperator_1465,axiom,
    ! [VarCurr] :
      ( ~ v18768(VarCurr)
    <=> v18499(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_1464,axiom,
    ! [VarCurr] :
      ( ~ v18767(VarCurr)
    <=> v18603(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4917,axiom,
    ! [VarCurr] :
      ( v18760(VarCurr)
    <=> ( v18761(VarCurr)
        & v18764(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4916,axiom,
    ! [VarCurr] :
      ( v18764(VarCurr)
    <=> ( v18602(VarCurr)
        | v18604(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4915,axiom,
    ! [VarCurr] :
      ( v18761(VarCurr)
    <=> ( v18762(VarCurr)
        | v18763(VarCurr) ) ) ).

fof(writeUnaryOperator_1463,axiom,
    ! [VarCurr] :
      ( ~ v18763(VarCurr)
    <=> v18604(VarCurr) ) ).

fof(writeUnaryOperator_1462,axiom,
    ! [VarCurr] :
      ( ~ v18762(VarCurr)
    <=> v18602(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4914,axiom,
    ! [VarCurr] :
      ( v18755(VarCurr)
    <=> ( v18756(VarCurr)
        & v18759(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4913,axiom,
    ! [VarCurr] :
      ( v18759(VarCurr)
    <=> ( v18600(VarCurr)
        | v18610(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4912,axiom,
    ! [VarCurr] :
      ( v18756(VarCurr)
    <=> ( v18757(VarCurr)
        | v18758(VarCurr) ) ) ).

fof(writeUnaryOperator_1461,axiom,
    ! [VarCurr] :
      ( ~ v18758(VarCurr)
    <=> v18610(VarCurr) ) ).

fof(writeUnaryOperator_1460,axiom,
    ! [VarCurr] :
      ( ~ v18757(VarCurr)
    <=> v18600(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4911,axiom,
    ! [VarCurr] :
      ( v18750(VarCurr)
    <=> ( v18751(VarCurr)
        & v18754(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4910,axiom,
    ! [VarCurr] :
      ( v18754(VarCurr)
    <=> ( v18598(VarCurr)
        | v18616(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4909,axiom,
    ! [VarCurr] :
      ( v18751(VarCurr)
    <=> ( v18752(VarCurr)
        | v18753(VarCurr) ) ) ).

fof(writeUnaryOperator_1459,axiom,
    ! [VarCurr] :
      ( ~ v18753(VarCurr)
    <=> v18616(VarCurr) ) ).

fof(writeUnaryOperator_1458,axiom,
    ! [VarCurr] :
      ( ~ v18752(VarCurr)
    <=> v18598(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4908,axiom,
    ! [VarCurr] :
      ( v18745(VarCurr)
    <=> ( v18746(VarCurr)
        & v18749(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4907,axiom,
    ! [VarCurr] :
      ( v18749(VarCurr)
    <=> ( v18596(VarCurr)
        | v18622(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4906,axiom,
    ! [VarCurr] :
      ( v18746(VarCurr)
    <=> ( v18747(VarCurr)
        | v18748(VarCurr) ) ) ).

fof(writeUnaryOperator_1457,axiom,
    ! [VarCurr] :
      ( ~ v18748(VarCurr)
    <=> v18622(VarCurr) ) ).

fof(writeUnaryOperator_1456,axiom,
    ! [VarCurr] :
      ( ~ v18747(VarCurr)
    <=> v18596(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4905,axiom,
    ! [VarCurr] :
      ( v18740(VarCurr)
    <=> ( v18741(VarCurr)
        & v18744(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4904,axiom,
    ! [VarCurr] :
      ( v18744(VarCurr)
    <=> ( v18594(VarCurr)
        | v18628(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4903,axiom,
    ! [VarCurr] :
      ( v18741(VarCurr)
    <=> ( v18742(VarCurr)
        | v18743(VarCurr) ) ) ).

fof(writeUnaryOperator_1455,axiom,
    ! [VarCurr] :
      ( ~ v18743(VarCurr)
    <=> v18628(VarCurr) ) ).

fof(writeUnaryOperator_1454,axiom,
    ! [VarCurr] :
      ( ~ v18742(VarCurr)
    <=> v18594(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4902,axiom,
    ! [VarCurr] :
      ( v18735(VarCurr)
    <=> ( v18736(VarCurr)
        & v18739(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4901,axiom,
    ! [VarCurr] :
      ( v18739(VarCurr)
    <=> ( v18592(VarCurr)
        | v18634(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4900,axiom,
    ! [VarCurr] :
      ( v18736(VarCurr)
    <=> ( v18737(VarCurr)
        | v18738(VarCurr) ) ) ).

fof(writeUnaryOperator_1453,axiom,
    ! [VarCurr] :
      ( ~ v18738(VarCurr)
    <=> v18634(VarCurr) ) ).

fof(writeUnaryOperator_1452,axiom,
    ! [VarCurr] :
      ( ~ v18737(VarCurr)
    <=> v18592(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4899,axiom,
    ! [VarCurr] :
      ( v18730(VarCurr)
    <=> ( v18731(VarCurr)
        & v18734(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4898,axiom,
    ! [VarCurr] :
      ( v18734(VarCurr)
    <=> ( v18590(VarCurr)
        | v18640(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4897,axiom,
    ! [VarCurr] :
      ( v18731(VarCurr)
    <=> ( v18732(VarCurr)
        | v18733(VarCurr) ) ) ).

fof(writeUnaryOperator_1451,axiom,
    ! [VarCurr] :
      ( ~ v18733(VarCurr)
    <=> v18640(VarCurr) ) ).

fof(writeUnaryOperator_1450,axiom,
    ! [VarCurr] :
      ( ~ v18732(VarCurr)
    <=> v18590(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4896,axiom,
    ! [VarCurr] :
      ( v18725(VarCurr)
    <=> ( v18726(VarCurr)
        & v18729(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4895,axiom,
    ! [VarCurr] :
      ( v18729(VarCurr)
    <=> ( v18588(VarCurr)
        | v18646(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4894,axiom,
    ! [VarCurr] :
      ( v18726(VarCurr)
    <=> ( v18727(VarCurr)
        | v18728(VarCurr) ) ) ).

fof(writeUnaryOperator_1449,axiom,
    ! [VarCurr] :
      ( ~ v18728(VarCurr)
    <=> v18646(VarCurr) ) ).

fof(writeUnaryOperator_1448,axiom,
    ! [VarCurr] :
      ( ~ v18727(VarCurr)
    <=> v18588(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4893,axiom,
    ! [VarCurr] :
      ( v18720(VarCurr)
    <=> ( v18721(VarCurr)
        & v18724(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4892,axiom,
    ! [VarCurr] :
      ( v18724(VarCurr)
    <=> ( v18586(VarCurr)
        | v18652(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4891,axiom,
    ! [VarCurr] :
      ( v18721(VarCurr)
    <=> ( v18722(VarCurr)
        | v18723(VarCurr) ) ) ).

fof(writeUnaryOperator_1447,axiom,
    ! [VarCurr] :
      ( ~ v18723(VarCurr)
    <=> v18652(VarCurr) ) ).

fof(writeUnaryOperator_1446,axiom,
    ! [VarCurr] :
      ( ~ v18722(VarCurr)
    <=> v18586(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4890,axiom,
    ! [VarCurr] :
      ( v18715(VarCurr)
    <=> ( v18716(VarCurr)
        & v18719(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4889,axiom,
    ! [VarCurr] :
      ( v18719(VarCurr)
    <=> ( v18584(VarCurr)
        | v18658(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4888,axiom,
    ! [VarCurr] :
      ( v18716(VarCurr)
    <=> ( v18717(VarCurr)
        | v18718(VarCurr) ) ) ).

fof(writeUnaryOperator_1445,axiom,
    ! [VarCurr] :
      ( ~ v18718(VarCurr)
    <=> v18658(VarCurr) ) ).

fof(writeUnaryOperator_1444,axiom,
    ! [VarCurr] :
      ( ~ v18717(VarCurr)
    <=> v18584(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4887,axiom,
    ! [VarCurr] :
      ( v18710(VarCurr)
    <=> ( v18711(VarCurr)
        & v18714(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4886,axiom,
    ! [VarCurr] :
      ( v18714(VarCurr)
    <=> ( v18582(VarCurr)
        | v18664(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4885,axiom,
    ! [VarCurr] :
      ( v18711(VarCurr)
    <=> ( v18712(VarCurr)
        | v18713(VarCurr) ) ) ).

fof(writeUnaryOperator_1443,axiom,
    ! [VarCurr] :
      ( ~ v18713(VarCurr)
    <=> v18664(VarCurr) ) ).

fof(writeUnaryOperator_1442,axiom,
    ! [VarCurr] :
      ( ~ v18712(VarCurr)
    <=> v18582(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4884,axiom,
    ! [VarCurr] :
      ( v18705(VarCurr)
    <=> ( v18706(VarCurr)
        & v18709(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4883,axiom,
    ! [VarCurr] :
      ( v18709(VarCurr)
    <=> ( v18580(VarCurr)
        | v18670(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4882,axiom,
    ! [VarCurr] :
      ( v18706(VarCurr)
    <=> ( v18707(VarCurr)
        | v18708(VarCurr) ) ) ).

fof(writeUnaryOperator_1441,axiom,
    ! [VarCurr] :
      ( ~ v18708(VarCurr)
    <=> v18670(VarCurr) ) ).

fof(writeUnaryOperator_1440,axiom,
    ! [VarCurr] :
      ( ~ v18707(VarCurr)
    <=> v18580(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4881,axiom,
    ! [VarCurr] :
      ( v18700(VarCurr)
    <=> ( v18701(VarCurr)
        & v18704(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4880,axiom,
    ! [VarCurr] :
      ( v18704(VarCurr)
    <=> ( v18578(VarCurr)
        | v18676(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4879,axiom,
    ! [VarCurr] :
      ( v18701(VarCurr)
    <=> ( v18702(VarCurr)
        | v18703(VarCurr) ) ) ).

fof(writeUnaryOperator_1439,axiom,
    ! [VarCurr] :
      ( ~ v18703(VarCurr)
    <=> v18676(VarCurr) ) ).

fof(writeUnaryOperator_1438,axiom,
    ! [VarCurr] :
      ( ~ v18702(VarCurr)
    <=> v18578(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4878,axiom,
    ! [VarCurr] :
      ( v18695(VarCurr)
    <=> ( v18696(VarCurr)
        & v18699(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4877,axiom,
    ! [VarCurr] :
      ( v18699(VarCurr)
    <=> ( v18576(VarCurr)
        | v18682(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4876,axiom,
    ! [VarCurr] :
      ( v18696(VarCurr)
    <=> ( v18697(VarCurr)
        | v18698(VarCurr) ) ) ).

fof(writeUnaryOperator_1437,axiom,
    ! [VarCurr] :
      ( ~ v18698(VarCurr)
    <=> v18682(VarCurr) ) ).

fof(writeUnaryOperator_1436,axiom,
    ! [VarCurr] :
      ( ~ v18697(VarCurr)
    <=> v18576(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4875,axiom,
    ! [VarCurr] :
      ( v18571(VarCurr)
    <=> ( v18572(VarCurr)
        & v18694(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4874,axiom,
    ! [VarCurr] :
      ( v18694(VarCurr)
    <=> ( v18574(VarCurr)
        | v18689(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4873,axiom,
    ! [VarCurr] :
      ( v18572(VarCurr)
    <=> ( v18573(VarCurr)
        | v18688(VarCurr) ) ) ).

fof(writeUnaryOperator_1435,axiom,
    ! [VarCurr] :
      ( ~ v18688(VarCurr)
    <=> v18689(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4872,axiom,
    ! [VarCurr] :
      ( v18689(VarCurr)
    <=> ( v18690(VarCurr)
        & v18693(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1596,axiom,
    ! [VarCurr] :
      ( v18693(VarCurr)
    <=> ( v18603(VarCurr,bitIndex15)
        | v18499(VarCurr,bitIndex16) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4871,axiom,
    ! [VarCurr] :
      ( v18690(VarCurr)
    <=> ( v18691(VarCurr)
        | v18692(VarCurr) ) ) ).

fof(writeUnaryOperator_1434,axiom,
    ! [VarCurr] :
      ( ~ v18692(VarCurr)
    <=> v18499(VarCurr,bitIndex16) ) ).

fof(writeUnaryOperator_1433,axiom,
    ! [VarCurr] :
      ( ~ v18691(VarCurr)
    <=> v18603(VarCurr,bitIndex15) ) ).

fof(writeUnaryOperator_1432,axiom,
    ! [VarCurr] :
      ( ~ v18573(VarCurr)
    <=> v18574(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4870,axiom,
    ! [VarCurr] :
      ( v18574(VarCurr)
    <=> ( v18575(VarCurr)
        | v18687(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1595,axiom,
    ! [VarCurr] :
      ( v18687(VarCurr)
    <=> ( v18603(VarCurr,bitIndex14)
        & v18499(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4869,axiom,
    ! [VarCurr] :
      ( v18575(VarCurr)
    <=> ( v18576(VarCurr)
        & v18682(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4868,axiom,
    ! [VarCurr] :
      ( v18682(VarCurr)
    <=> ( v18683(VarCurr)
        & v18686(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1594,axiom,
    ! [VarCurr] :
      ( v18686(VarCurr)
    <=> ( v18603(VarCurr,bitIndex14)
        | v18499(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4867,axiom,
    ! [VarCurr] :
      ( v18683(VarCurr)
    <=> ( v18684(VarCurr)
        | v18685(VarCurr) ) ) ).

fof(writeUnaryOperator_1431,axiom,
    ! [VarCurr] :
      ( ~ v18685(VarCurr)
    <=> v18499(VarCurr,bitIndex15) ) ).

fof(writeUnaryOperator_1430,axiom,
    ! [VarCurr] :
      ( ~ v18684(VarCurr)
    <=> v18603(VarCurr,bitIndex14) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4866,axiom,
    ! [VarCurr] :
      ( v18576(VarCurr)
    <=> ( v18577(VarCurr)
        | v18681(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1593,axiom,
    ! [VarCurr] :
      ( v18681(VarCurr)
    <=> ( v18603(VarCurr,bitIndex13)
        & v18499(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4865,axiom,
    ! [VarCurr] :
      ( v18577(VarCurr)
    <=> ( v18578(VarCurr)
        & v18676(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4864,axiom,
    ! [VarCurr] :
      ( v18676(VarCurr)
    <=> ( v18677(VarCurr)
        & v18680(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1592,axiom,
    ! [VarCurr] :
      ( v18680(VarCurr)
    <=> ( v18603(VarCurr,bitIndex13)
        | v18499(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4863,axiom,
    ! [VarCurr] :
      ( v18677(VarCurr)
    <=> ( v18678(VarCurr)
        | v18679(VarCurr) ) ) ).

fof(writeUnaryOperator_1429,axiom,
    ! [VarCurr] :
      ( ~ v18679(VarCurr)
    <=> v18499(VarCurr,bitIndex14) ) ).

fof(writeUnaryOperator_1428,axiom,
    ! [VarCurr] :
      ( ~ v18678(VarCurr)
    <=> v18603(VarCurr,bitIndex13) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4862,axiom,
    ! [VarCurr] :
      ( v18578(VarCurr)
    <=> ( v18579(VarCurr)
        | v18675(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1591,axiom,
    ! [VarCurr] :
      ( v18675(VarCurr)
    <=> ( v18603(VarCurr,bitIndex12)
        & v18499(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4861,axiom,
    ! [VarCurr] :
      ( v18579(VarCurr)
    <=> ( v18580(VarCurr)
        & v18670(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4860,axiom,
    ! [VarCurr] :
      ( v18670(VarCurr)
    <=> ( v18671(VarCurr)
        & v18674(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1590,axiom,
    ! [VarCurr] :
      ( v18674(VarCurr)
    <=> ( v18603(VarCurr,bitIndex12)
        | v18499(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4859,axiom,
    ! [VarCurr] :
      ( v18671(VarCurr)
    <=> ( v18672(VarCurr)
        | v18673(VarCurr) ) ) ).

fof(writeUnaryOperator_1427,axiom,
    ! [VarCurr] :
      ( ~ v18673(VarCurr)
    <=> v18499(VarCurr,bitIndex13) ) ).

fof(writeUnaryOperator_1426,axiom,
    ! [VarCurr] :
      ( ~ v18672(VarCurr)
    <=> v18603(VarCurr,bitIndex12) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4858,axiom,
    ! [VarCurr] :
      ( v18580(VarCurr)
    <=> ( v18581(VarCurr)
        | v18669(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1589,axiom,
    ! [VarCurr] :
      ( v18669(VarCurr)
    <=> ( v18603(VarCurr,bitIndex11)
        & v18499(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4857,axiom,
    ! [VarCurr] :
      ( v18581(VarCurr)
    <=> ( v18582(VarCurr)
        & v18664(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4856,axiom,
    ! [VarCurr] :
      ( v18664(VarCurr)
    <=> ( v18665(VarCurr)
        & v18668(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1588,axiom,
    ! [VarCurr] :
      ( v18668(VarCurr)
    <=> ( v18603(VarCurr,bitIndex11)
        | v18499(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4855,axiom,
    ! [VarCurr] :
      ( v18665(VarCurr)
    <=> ( v18666(VarCurr)
        | v18667(VarCurr) ) ) ).

fof(writeUnaryOperator_1425,axiom,
    ! [VarCurr] :
      ( ~ v18667(VarCurr)
    <=> v18499(VarCurr,bitIndex12) ) ).

fof(writeUnaryOperator_1424,axiom,
    ! [VarCurr] :
      ( ~ v18666(VarCurr)
    <=> v18603(VarCurr,bitIndex11) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4854,axiom,
    ! [VarCurr] :
      ( v18582(VarCurr)
    <=> ( v18583(VarCurr)
        | v18663(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1587,axiom,
    ! [VarCurr] :
      ( v18663(VarCurr)
    <=> ( v18603(VarCurr,bitIndex10)
        & v18499(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4853,axiom,
    ! [VarCurr] :
      ( v18583(VarCurr)
    <=> ( v18584(VarCurr)
        & v18658(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4852,axiom,
    ! [VarCurr] :
      ( v18658(VarCurr)
    <=> ( v18659(VarCurr)
        & v18662(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1586,axiom,
    ! [VarCurr] :
      ( v18662(VarCurr)
    <=> ( v18603(VarCurr,bitIndex10)
        | v18499(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4851,axiom,
    ! [VarCurr] :
      ( v18659(VarCurr)
    <=> ( v18660(VarCurr)
        | v18661(VarCurr) ) ) ).

fof(writeUnaryOperator_1423,axiom,
    ! [VarCurr] :
      ( ~ v18661(VarCurr)
    <=> v18499(VarCurr,bitIndex11) ) ).

fof(writeUnaryOperator_1422,axiom,
    ! [VarCurr] :
      ( ~ v18660(VarCurr)
    <=> v18603(VarCurr,bitIndex10) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4850,axiom,
    ! [VarCurr] :
      ( v18584(VarCurr)
    <=> ( v18585(VarCurr)
        | v18657(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1585,axiom,
    ! [VarCurr] :
      ( v18657(VarCurr)
    <=> ( v18603(VarCurr,bitIndex9)
        & v18499(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4849,axiom,
    ! [VarCurr] :
      ( v18585(VarCurr)
    <=> ( v18586(VarCurr)
        & v18652(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4848,axiom,
    ! [VarCurr] :
      ( v18652(VarCurr)
    <=> ( v18653(VarCurr)
        & v18656(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1584,axiom,
    ! [VarCurr] :
      ( v18656(VarCurr)
    <=> ( v18603(VarCurr,bitIndex9)
        | v18499(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4847,axiom,
    ! [VarCurr] :
      ( v18653(VarCurr)
    <=> ( v18654(VarCurr)
        | v18655(VarCurr) ) ) ).

fof(writeUnaryOperator_1421,axiom,
    ! [VarCurr] :
      ( ~ v18655(VarCurr)
    <=> v18499(VarCurr,bitIndex10) ) ).

fof(writeUnaryOperator_1420,axiom,
    ! [VarCurr] :
      ( ~ v18654(VarCurr)
    <=> v18603(VarCurr,bitIndex9) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4846,axiom,
    ! [VarCurr] :
      ( v18586(VarCurr)
    <=> ( v18587(VarCurr)
        | v18651(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1583,axiom,
    ! [VarCurr] :
      ( v18651(VarCurr)
    <=> ( v18603(VarCurr,bitIndex8)
        & v18499(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4845,axiom,
    ! [VarCurr] :
      ( v18587(VarCurr)
    <=> ( v18588(VarCurr)
        & v18646(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4844,axiom,
    ! [VarCurr] :
      ( v18646(VarCurr)
    <=> ( v18647(VarCurr)
        & v18650(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1582,axiom,
    ! [VarCurr] :
      ( v18650(VarCurr)
    <=> ( v18603(VarCurr,bitIndex8)
        | v18499(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4843,axiom,
    ! [VarCurr] :
      ( v18647(VarCurr)
    <=> ( v18648(VarCurr)
        | v18649(VarCurr) ) ) ).

fof(writeUnaryOperator_1419,axiom,
    ! [VarCurr] :
      ( ~ v18649(VarCurr)
    <=> v18499(VarCurr,bitIndex9) ) ).

fof(writeUnaryOperator_1418,axiom,
    ! [VarCurr] :
      ( ~ v18648(VarCurr)
    <=> v18603(VarCurr,bitIndex8) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4842,axiom,
    ! [VarCurr] :
      ( v18588(VarCurr)
    <=> ( v18589(VarCurr)
        | v18645(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1581,axiom,
    ! [VarCurr] :
      ( v18645(VarCurr)
    <=> ( v18603(VarCurr,bitIndex7)
        & v18499(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4841,axiom,
    ! [VarCurr] :
      ( v18589(VarCurr)
    <=> ( v18590(VarCurr)
        & v18640(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4840,axiom,
    ! [VarCurr] :
      ( v18640(VarCurr)
    <=> ( v18641(VarCurr)
        & v18644(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1580,axiom,
    ! [VarCurr] :
      ( v18644(VarCurr)
    <=> ( v18603(VarCurr,bitIndex7)
        | v18499(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4839,axiom,
    ! [VarCurr] :
      ( v18641(VarCurr)
    <=> ( v18642(VarCurr)
        | v18643(VarCurr) ) ) ).

fof(writeUnaryOperator_1417,axiom,
    ! [VarCurr] :
      ( ~ v18643(VarCurr)
    <=> v18499(VarCurr,bitIndex8) ) ).

fof(writeUnaryOperator_1416,axiom,
    ! [VarCurr] :
      ( ~ v18642(VarCurr)
    <=> v18603(VarCurr,bitIndex7) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4838,axiom,
    ! [VarCurr] :
      ( v18590(VarCurr)
    <=> ( v18591(VarCurr)
        | v18639(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1579,axiom,
    ! [VarCurr] :
      ( v18639(VarCurr)
    <=> ( v18603(VarCurr,bitIndex6)
        & v18499(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4837,axiom,
    ! [VarCurr] :
      ( v18591(VarCurr)
    <=> ( v18592(VarCurr)
        & v18634(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4836,axiom,
    ! [VarCurr] :
      ( v18634(VarCurr)
    <=> ( v18635(VarCurr)
        & v18638(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1578,axiom,
    ! [VarCurr] :
      ( v18638(VarCurr)
    <=> ( v18603(VarCurr,bitIndex6)
        | v18499(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4835,axiom,
    ! [VarCurr] :
      ( v18635(VarCurr)
    <=> ( v18636(VarCurr)
        | v18637(VarCurr) ) ) ).

fof(writeUnaryOperator_1415,axiom,
    ! [VarCurr] :
      ( ~ v18637(VarCurr)
    <=> v18499(VarCurr,bitIndex7) ) ).

fof(writeUnaryOperator_1414,axiom,
    ! [VarCurr] :
      ( ~ v18636(VarCurr)
    <=> v18603(VarCurr,bitIndex6) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4834,axiom,
    ! [VarCurr] :
      ( v18592(VarCurr)
    <=> ( v18593(VarCurr)
        | v18633(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1577,axiom,
    ! [VarCurr] :
      ( v18633(VarCurr)
    <=> ( v18603(VarCurr,bitIndex5)
        & v18499(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4833,axiom,
    ! [VarCurr] :
      ( v18593(VarCurr)
    <=> ( v18594(VarCurr)
        & v18628(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4832,axiom,
    ! [VarCurr] :
      ( v18628(VarCurr)
    <=> ( v18629(VarCurr)
        & v18632(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1576,axiom,
    ! [VarCurr] :
      ( v18632(VarCurr)
    <=> ( v18603(VarCurr,bitIndex5)
        | v18499(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4831,axiom,
    ! [VarCurr] :
      ( v18629(VarCurr)
    <=> ( v18630(VarCurr)
        | v18631(VarCurr) ) ) ).

fof(writeUnaryOperator_1413,axiom,
    ! [VarCurr] :
      ( ~ v18631(VarCurr)
    <=> v18499(VarCurr,bitIndex6) ) ).

fof(writeUnaryOperator_1412,axiom,
    ! [VarCurr] :
      ( ~ v18630(VarCurr)
    <=> v18603(VarCurr,bitIndex5) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4830,axiom,
    ! [VarCurr] :
      ( v18594(VarCurr)
    <=> ( v18595(VarCurr)
        | v18627(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1575,axiom,
    ! [VarCurr] :
      ( v18627(VarCurr)
    <=> ( v18603(VarCurr,bitIndex4)
        & v18499(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4829,axiom,
    ! [VarCurr] :
      ( v18595(VarCurr)
    <=> ( v18596(VarCurr)
        & v18622(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4828,axiom,
    ! [VarCurr] :
      ( v18622(VarCurr)
    <=> ( v18623(VarCurr)
        & v18626(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1574,axiom,
    ! [VarCurr] :
      ( v18626(VarCurr)
    <=> ( v18603(VarCurr,bitIndex4)
        | v18499(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4827,axiom,
    ! [VarCurr] :
      ( v18623(VarCurr)
    <=> ( v18624(VarCurr)
        | v18625(VarCurr) ) ) ).

fof(writeUnaryOperator_1411,axiom,
    ! [VarCurr] :
      ( ~ v18625(VarCurr)
    <=> v18499(VarCurr,bitIndex5) ) ).

fof(writeUnaryOperator_1410,axiom,
    ! [VarCurr] :
      ( ~ v18624(VarCurr)
    <=> v18603(VarCurr,bitIndex4) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4826,axiom,
    ! [VarCurr] :
      ( v18596(VarCurr)
    <=> ( v18597(VarCurr)
        | v18621(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1573,axiom,
    ! [VarCurr] :
      ( v18621(VarCurr)
    <=> ( v18603(VarCurr,bitIndex3)
        & v18499(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4825,axiom,
    ! [VarCurr] :
      ( v18597(VarCurr)
    <=> ( v18598(VarCurr)
        & v18616(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4824,axiom,
    ! [VarCurr] :
      ( v18616(VarCurr)
    <=> ( v18617(VarCurr)
        & v18620(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1572,axiom,
    ! [VarCurr] :
      ( v18620(VarCurr)
    <=> ( v18603(VarCurr,bitIndex3)
        | v18499(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4823,axiom,
    ! [VarCurr] :
      ( v18617(VarCurr)
    <=> ( v18618(VarCurr)
        | v18619(VarCurr) ) ) ).

fof(writeUnaryOperator_1409,axiom,
    ! [VarCurr] :
      ( ~ v18619(VarCurr)
    <=> v18499(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_1408,axiom,
    ! [VarCurr] :
      ( ~ v18618(VarCurr)
    <=> v18603(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4822,axiom,
    ! [VarCurr] :
      ( v18598(VarCurr)
    <=> ( v18599(VarCurr)
        | v18615(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1571,axiom,
    ! [VarCurr] :
      ( v18615(VarCurr)
    <=> ( v18603(VarCurr,bitIndex2)
        & v18499(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4821,axiom,
    ! [VarCurr] :
      ( v18599(VarCurr)
    <=> ( v18600(VarCurr)
        & v18610(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4820,axiom,
    ! [VarCurr] :
      ( v18610(VarCurr)
    <=> ( v18611(VarCurr)
        & v18614(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1570,axiom,
    ! [VarCurr] :
      ( v18614(VarCurr)
    <=> ( v18603(VarCurr,bitIndex2)
        | v18499(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4819,axiom,
    ! [VarCurr] :
      ( v18611(VarCurr)
    <=> ( v18612(VarCurr)
        | v18613(VarCurr) ) ) ).

fof(writeUnaryOperator_1407,axiom,
    ! [VarCurr] :
      ( ~ v18613(VarCurr)
    <=> v18499(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_1406,axiom,
    ! [VarCurr] :
      ( ~ v18612(VarCurr)
    <=> v18603(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4818,axiom,
    ! [VarCurr] :
      ( v18600(VarCurr)
    <=> ( v18601(VarCurr)
        | v18609(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1569,axiom,
    ! [VarCurr] :
      ( v18609(VarCurr)
    <=> ( v18603(VarCurr,bitIndex1)
        & v18499(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4817,axiom,
    ! [VarCurr] :
      ( v18601(VarCurr)
    <=> ( v18602(VarCurr)
        & v18604(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4816,axiom,
    ! [VarCurr] :
      ( v18604(VarCurr)
    <=> ( v18605(VarCurr)
        & v18608(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1568,axiom,
    ! [VarCurr] :
      ( v18608(VarCurr)
    <=> ( v18603(VarCurr,bitIndex1)
        | v18499(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4815,axiom,
    ! [VarCurr] :
      ( v18605(VarCurr)
    <=> ( v18606(VarCurr)
        | v18607(VarCurr) ) ) ).

fof(writeUnaryOperator_1405,axiom,
    ! [VarCurr] :
      ( ~ v18607(VarCurr)
    <=> v18499(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_1404,axiom,
    ! [VarCurr] :
      ( ~ v18606(VarCurr)
    <=> v18603(VarCurr,bitIndex1) ) ).

fof(writeBinaryOperatorShiftedRanges_1567,axiom,
    ! [VarCurr] :
      ( v18602(VarCurr)
    <=> ( v18603(VarCurr,bitIndex0)
        & v18499(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_2626,axiom,
    ! [VarCurr] :
      ( ( v18603(VarCurr,bitIndex14)
      <=> v7900(VarCurr,bitIndex15) )
      & ( v18603(VarCurr,bitIndex13)
      <=> v7900(VarCurr,bitIndex14) )
      & ( v18603(VarCurr,bitIndex12)
      <=> v7900(VarCurr,bitIndex13) )
      & ( v18603(VarCurr,bitIndex11)
      <=> v7900(VarCurr,bitIndex12) )
      & ( v18603(VarCurr,bitIndex10)
      <=> v7900(VarCurr,bitIndex11) )
      & ( v18603(VarCurr,bitIndex9)
      <=> v7900(VarCurr,bitIndex10) )
      & ( v18603(VarCurr,bitIndex8)
      <=> v7900(VarCurr,bitIndex9) )
      & ( v18603(VarCurr,bitIndex7)
      <=> v7900(VarCurr,bitIndex8) )
      & ( v18603(VarCurr,bitIndex6)
      <=> v7900(VarCurr,bitIndex7) )
      & ( v18603(VarCurr,bitIndex5)
      <=> v7900(VarCurr,bitIndex6) )
      & ( v18603(VarCurr,bitIndex4)
      <=> v7900(VarCurr,bitIndex5) )
      & ( v18603(VarCurr,bitIndex3)
      <=> v7900(VarCurr,bitIndex4) )
      & ( v18603(VarCurr,bitIndex2)
      <=> v7900(VarCurr,bitIndex3) )
      & ( v18603(VarCurr,bitIndex1)
      <=> v7900(VarCurr,bitIndex2) )
      & ( v18603(VarCurr,bitIndex0)
      <=> v7900(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_2625,axiom,
    ! [VarCurr] :
      ( v18603(VarCurr,bitIndex15)
    <=> $false ) ).

fof(addAssignment_2624,axiom,
    ! [VarCurr] :
      ( v18497(VarCurr,bitIndex0)
    <=> v7900(VarCurr,bitIndex0) ) ).

fof(addAssignment_2623,axiom,
    ! [VarCurr] :
      ( v18499(VarCurr,bitIndex3)
    <=> v18501(VarCurr,bitIndex3) ) ).

fof(addAssignment_2622,axiom,
    ! [VarNext] :
      ( v18501(VarNext,bitIndex3)
    <=> v18562(VarNext,bitIndex3) ) ).

fof(addCaseBooleanConditionEqualRanges1_133,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18563(VarNext)
       => ! [B] :
            ( range_16_0(B)
           => ( v18562(VarNext,B)
            <=> v18501(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_700,axiom,
    ! [VarNext] :
      ( v18563(VarNext)
     => ! [B] :
          ( range_16_0(B)
         => ( v18562(VarNext,B)
          <=> v18550(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4814,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18563(VarNext)
      <=> v18564(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4813,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18564(VarNext)
      <=> ( v18566(VarNext)
          & v18538(VarNext) ) ) ) ).

fof(writeUnaryOperator_1403,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18566(VarNext)
      <=> v18545(VarNext) ) ) ).

fof(addAssignment_2621,axiom,
    ! [VarCurr] :
      ( v18503(VarCurr,bitIndex3)
    <=> v18529(VarCurr,bitIndex3) ) ).

fof(addAssignment_2620,axiom,
    ! [VarCurr] :
      ( v18509(VarCurr,bitIndex3)
    <=> v18511(VarCurr,bitIndex3) ) ).

fof(addAssignment_2619,axiom,
    ! [VarCurr] :
      ( v18511(VarCurr,bitIndex3)
    <=> v18526(VarCurr,bitIndex3) ) ).

fof(addAssignment_2618,axiom,
    ! [VarCurr] :
      ( v18499(VarCurr,bitIndex2)
    <=> v18501(VarCurr,bitIndex2) ) ).

fof(addAssignment_2617,axiom,
    ! [VarNext] :
      ( v18501(VarNext,bitIndex2)
    <=> v18554(VarNext,bitIndex2) ) ).

fof(addCaseBooleanConditionEqualRanges1_132,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18555(VarNext)
       => ! [B] :
            ( range_16_0(B)
           => ( v18554(VarNext,B)
            <=> v18501(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_699,axiom,
    ! [VarNext] :
      ( v18555(VarNext)
     => ! [B] :
          ( range_16_0(B)
         => ( v18554(VarNext,B)
          <=> v18550(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4812,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18555(VarNext)
      <=> v18556(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4811,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18556(VarNext)
      <=> ( v18558(VarNext)
          & v18538(VarNext) ) ) ) ).

fof(writeUnaryOperator_1402,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18558(VarNext)
      <=> v18545(VarNext) ) ) ).

fof(addAssignment_2616,axiom,
    ! [VarCurr] :
      ( v18503(VarCurr,bitIndex2)
    <=> v18529(VarCurr,bitIndex2) ) ).

fof(addAssignment_2615,axiom,
    ! [VarCurr] :
      ( v18509(VarCurr,bitIndex2)
    <=> v18511(VarCurr,bitIndex2) ) ).

fof(addAssignment_2614,axiom,
    ! [VarCurr] :
      ( v18511(VarCurr,bitIndex2)
    <=> v18526(VarCurr,bitIndex2) ) ).

fof(addAssignment_2613,axiom,
    ! [VarCurr] :
      ( v18499(VarCurr,bitIndex1)
    <=> v18501(VarCurr,bitIndex1) ) ).

fof(addAssignment_2612,axiom,
    ! [VarNext] :
      ( v18501(VarNext,bitIndex1)
    <=> v18540(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_131,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18541(VarNext)
       => ! [B] :
            ( range_16_0(B)
           => ( v18540(VarNext,B)
            <=> v18501(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_698,axiom,
    ! [VarNext] :
      ( v18541(VarNext)
     => ! [B] :
          ( range_16_0(B)
         => ( v18540(VarNext,B)
          <=> v18550(VarNext,B) ) ) ) ).

fof(addAssignment_2611,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_16_0(B)
         => ( v18550(VarNext,B)
          <=> v18503(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4810,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18541(VarNext)
      <=> v18542(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4809,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18542(VarNext)
      <=> ( v18543(VarNext)
          & v18538(VarNext) ) ) ) ).

fof(writeUnaryOperator_1401,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v18543(VarNext)
      <=> v18545(VarNext) ) ) ).

fof(addAssignment_2610,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v18545(VarNext)
      <=> v18538(VarCurr) ) ) ).

fof(addAssignment_2609,axiom,
    ! [VarCurr] :
      ( v18538(VarCurr)
    <=> v441(VarCurr) ) ).

fof(addAssignment_2608,axiom,
    ! [VarCurr] :
      ( v18503(VarCurr,bitIndex1)
    <=> v18529(VarCurr,bitIndex1) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_21,axiom,
    ! [VarCurr] :
      ( ( ~ v18530(VarCurr)
        & ~ v18532(VarCurr) )
     => ! [B] :
          ( range_16_0(B)
         => ( v18529(VarCurr,B)
          <=> v18501(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_32,axiom,
    ! [VarCurr] :
      ( v18532(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18529(VarCurr,B)
          <=> $false ) ) ) ).

fof(bitBlastConstant_2492,axiom,
    ~ b00000000000000000(bitIndex16) ).

fof(bitBlastConstant_2491,axiom,
    ~ b00000000000000000(bitIndex15) ).

fof(bitBlastConstant_2490,axiom,
    ~ b00000000000000000(bitIndex14) ).

fof(bitBlastConstant_2489,axiom,
    ~ b00000000000000000(bitIndex13) ).

fof(bitBlastConstant_2488,axiom,
    ~ b00000000000000000(bitIndex12) ).

fof(bitBlastConstant_2487,axiom,
    ~ b00000000000000000(bitIndex11) ).

fof(bitBlastConstant_2486,axiom,
    ~ b00000000000000000(bitIndex10) ).

fof(bitBlastConstant_2485,axiom,
    ~ b00000000000000000(bitIndex9) ).

fof(bitBlastConstant_2484,axiom,
    ~ b00000000000000000(bitIndex8) ).

fof(bitBlastConstant_2483,axiom,
    ~ b00000000000000000(bitIndex7) ).

fof(bitBlastConstant_2482,axiom,
    ~ b00000000000000000(bitIndex6) ).

fof(bitBlastConstant_2481,axiom,
    ~ b00000000000000000(bitIndex5) ).

fof(bitBlastConstant_2480,axiom,
    ~ b00000000000000000(bitIndex4) ).

fof(bitBlastConstant_2479,axiom,
    ~ b00000000000000000(bitIndex3) ).

fof(bitBlastConstant_2478,axiom,
    ~ b00000000000000000(bitIndex2) ).

fof(bitBlastConstant_2477,axiom,
    ~ b00000000000000000(bitIndex1) ).

fof(bitBlastConstant_2476,axiom,
    ~ b00000000000000000(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges0_34,axiom,
    ! [VarCurr] :
      ( v18530(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18529(VarCurr,B)
          <=> v18509(VarCurr,B) ) ) ) ).

fof(addAssignmentInitValue_79,axiom,
    ~ v18501(constB0,bitIndex16) ).

fof(addAssignmentInitValue_78,axiom,
    ~ v18501(constB0,bitIndex15) ).

fof(addAssignmentInitValue_77,axiom,
    ~ v18501(constB0,bitIndex14) ).

fof(addAssignmentInitValue_76,axiom,
    ~ v18501(constB0,bitIndex13) ).

fof(addAssignmentInitValue_75,axiom,
    ~ v18501(constB0,bitIndex12) ).

fof(addAssignmentInitValue_74,axiom,
    ~ v18501(constB0,bitIndex11) ).

fof(addAssignmentInitValue_73,axiom,
    ~ v18501(constB0,bitIndex10) ).

fof(addAssignmentInitValue_72,axiom,
    ~ v18501(constB0,bitIndex9) ).

fof(addAssignmentInitValue_71,axiom,
    ~ v18501(constB0,bitIndex8) ).

fof(addAssignmentInitValue_70,axiom,
    ~ v18501(constB0,bitIndex7) ).

fof(addAssignmentInitValue_69,axiom,
    ~ v18501(constB0,bitIndex6) ).

fof(addAssignmentInitValue_68,axiom,
    ~ v18501(constB0,bitIndex5) ).

fof(addAssignmentInitValue_67,axiom,
    ~ v18501(constB0,bitIndex4) ).

fof(addAssignmentInitValue_66,axiom,
    ~ v18501(constB0,bitIndex3) ).

fof(addAssignmentInitValue_65,axiom,
    ~ v18501(constB0,bitIndex2) ).

fof(addAssignmentInitValue_64,axiom,
    ~ v18501(constB0,bitIndex1) ).

fof(bitBlastConstant_2475,axiom,
    ~ b0000000000000000x(bitIndex16) ).

fof(bitBlastConstant_2474,axiom,
    ~ b0000000000000000x(bitIndex15) ).

fof(bitBlastConstant_2473,axiom,
    ~ b0000000000000000x(bitIndex14) ).

fof(bitBlastConstant_2472,axiom,
    ~ b0000000000000000x(bitIndex13) ).

fof(bitBlastConstant_2471,axiom,
    ~ b0000000000000000x(bitIndex12) ).

fof(bitBlastConstant_2470,axiom,
    ~ b0000000000000000x(bitIndex11) ).

fof(bitBlastConstant_2469,axiom,
    ~ b0000000000000000x(bitIndex10) ).

fof(bitBlastConstant_2468,axiom,
    ~ b0000000000000000x(bitIndex9) ).

fof(bitBlastConstant_2467,axiom,
    ~ b0000000000000000x(bitIndex8) ).

fof(bitBlastConstant_2466,axiom,
    ~ b0000000000000000x(bitIndex7) ).

fof(bitBlastConstant_2465,axiom,
    ~ b0000000000000000x(bitIndex6) ).

fof(bitBlastConstant_2464,axiom,
    ~ b0000000000000000x(bitIndex5) ).

fof(bitBlastConstant_2463,axiom,
    ~ b0000000000000000x(bitIndex4) ).

fof(bitBlastConstant_2462,axiom,
    ~ b0000000000000000x(bitIndex3) ).

fof(bitBlastConstant_2461,axiom,
    ~ b0000000000000000x(bitIndex2) ).

fof(bitBlastConstant_2460,axiom,
    ~ b0000000000000000x(bitIndex1) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4808,axiom,
    ! [VarCurr] :
      ( v18532(VarCurr)
    <=> ( v18533(VarCurr)
        | v18534(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_1308,axiom,
    ! [VarCurr] :
      ( v18534(VarCurr)
    <=> ( ( v18531(VarCurr,bitIndex1)
        <=> $true )
        & ( v18531(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1307,axiom,
    ! [VarCurr] :
      ( v18533(VarCurr)
    <=> ( ( v18531(VarCurr,bitIndex1)
        <=> $true )
        & ( v18531(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_1306,axiom,
    ! [VarCurr] :
      ( v18530(VarCurr)
    <=> ( ( v18531(VarCurr,bitIndex1)
        <=> $false )
        & ( v18531(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2607,axiom,
    ! [VarCurr] :
      ( v18531(VarCurr,bitIndex0)
    <=> v18507(VarCurr) ) ).

fof(addAssignment_2606,axiom,
    ! [VarCurr] :
      ( v18531(VarCurr,bitIndex1)
    <=> v18505(VarCurr) ) ).

fof(addAssignment_2605,axiom,
    ! [VarCurr] :
      ( v18509(VarCurr,bitIndex1)
    <=> v18511(VarCurr,bitIndex1) ) ).

fof(addAssignment_2604,axiom,
    ! [VarCurr] :
      ( v18511(VarCurr,bitIndex1)
    <=> v18526(VarCurr,bitIndex1) ) ).

fof(addParallelCaseBooleanConditionEqualRanges48_2,axiom,
    ! [VarCurr] :
      ( ( ~ v18527(VarCurr)
        & ~ v8073(VarCurr)
        & ~ v8079(VarCurr)
        & ~ v8083(VarCurr)
        & ~ v8088(VarCurr)
        & ~ v8091(VarCurr)
        & ~ v8094(VarCurr)
        & ~ v8097(VarCurr)
        & ~ v8100(VarCurr)
        & ~ v8102(VarCurr)
        & ~ v8104(VarCurr)
        & ~ v8106(VarCurr)
        & ~ v8114(VarCurr)
        & ~ v8119(VarCurr)
        & ~ v8123(VarCurr)
        & ~ v8127(VarCurr)
        & ~ v8130(VarCurr)
        & ~ v8133(VarCurr)
        & ~ v8136(VarCurr)
        & ~ v8139(VarCurr)
        & ~ v8141(VarCurr)
        & ~ v8143(VarCurr)
        & ~ v8145(VarCurr)
        & ~ v8153(VarCurr)
        & ~ v8158(VarCurr)
        & ~ v8162(VarCurr)
        & ~ v8166(VarCurr)
        & ~ v8169(VarCurr)
        & ~ v8172(VarCurr)
        & ~ v8175(VarCurr)
        & ~ v8178(VarCurr)
        & ~ v8180(VarCurr)
        & ~ v8182(VarCurr)
        & ~ v8184(VarCurr)
        & ~ v8192(VarCurr)
        & ~ v8197(VarCurr)
        & ~ v8201(VarCurr)
        & ~ v8205(VarCurr)
        & ~ v8208(VarCurr)
        & ~ v8211(VarCurr)
        & ~ v8214(VarCurr)
        & ~ v8217(VarCurr)
        & ~ v8219(VarCurr)
        & ~ v8222(VarCurr)
        & ~ v8224(VarCurr)
        & ~ v8226(VarCurr)
        & ~ v8229(VarCurr)
        & ~ v8232(VarCurr) )
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000000100010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges47_2,axiom,
    ! [VarCurr] :
      ( v8232(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000001000010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges46_2,axiom,
    ! [VarCurr] :
      ( v8229(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000000111110(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges45_2,axiom,
    ! [VarCurr] :
      ( v8226(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000000111010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges44_2,axiom,
    ! [VarCurr] :
      ( v8224(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000000110110(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges43_2,axiom,
    ! [VarCurr] :
      ( v8222(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000001010110(B) ) ) ) ).

fof(bitBlastConstant_2459,axiom,
    ~ b00000000001010110(bitIndex16) ).

fof(bitBlastConstant_2458,axiom,
    ~ b00000000001010110(bitIndex15) ).

fof(bitBlastConstant_2457,axiom,
    ~ b00000000001010110(bitIndex14) ).

fof(bitBlastConstant_2456,axiom,
    ~ b00000000001010110(bitIndex13) ).

fof(bitBlastConstant_2455,axiom,
    ~ b00000000001010110(bitIndex12) ).

fof(bitBlastConstant_2454,axiom,
    ~ b00000000001010110(bitIndex11) ).

fof(bitBlastConstant_2453,axiom,
    ~ b00000000001010110(bitIndex10) ).

fof(bitBlastConstant_2452,axiom,
    ~ b00000000001010110(bitIndex9) ).

fof(bitBlastConstant_2451,axiom,
    ~ b00000000001010110(bitIndex8) ).

fof(bitBlastConstant_2450,axiom,
    ~ b00000000001010110(bitIndex7) ).

fof(bitBlastConstant_2449,axiom,
    b00000000001010110(bitIndex6) ).

fof(bitBlastConstant_2448,axiom,
    ~ b00000000001010110(bitIndex5) ).

fof(bitBlastConstant_2447,axiom,
    b00000000001010110(bitIndex4) ).

fof(bitBlastConstant_2446,axiom,
    ~ b00000000001010110(bitIndex3) ).

fof(bitBlastConstant_2445,axiom,
    b00000000001010110(bitIndex2) ).

fof(bitBlastConstant_2444,axiom,
    b00000000001010110(bitIndex1) ).

fof(bitBlastConstant_2443,axiom,
    ~ b00000000001010110(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges42_2,axiom,
    ! [VarCurr] :
      ( v8219(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000001010010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges41_2,axiom,
    ! [VarCurr] :
      ( v8217(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000001001110(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges40_2,axiom,
    ! [VarCurr] :
      ( v8214(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000001001010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges39_2,axiom,
    ! [VarCurr] :
      ( v8211(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000001000110(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges38_2,axiom,
    ! [VarCurr] :
      ( v8208(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000001000010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges37_2,axiom,
    ! [VarCurr] :
      ( v8205(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000000111110(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges36_2,axiom,
    ! [VarCurr] :
      ( v8201(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000000111010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges35_2,axiom,
    ! [VarCurr] :
      ( v8197(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000000110110(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges34_2,axiom,
    ! [VarCurr] :
      ( v8192(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000000110010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges33_2,axiom,
    ! [VarCurr] :
      ( v8184(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000000101110(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges32_2,axiom,
    ! [VarCurr] :
      ( v8182(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000001010010(B) ) ) ) ).

fof(bitBlastConstant_2442,axiom,
    ~ b00000000001010010(bitIndex16) ).

fof(bitBlastConstant_2441,axiom,
    ~ b00000000001010010(bitIndex15) ).

fof(bitBlastConstant_2440,axiom,
    ~ b00000000001010010(bitIndex14) ).

fof(bitBlastConstant_2439,axiom,
    ~ b00000000001010010(bitIndex13) ).

fof(bitBlastConstant_2438,axiom,
    ~ b00000000001010010(bitIndex12) ).

fof(bitBlastConstant_2437,axiom,
    ~ b00000000001010010(bitIndex11) ).

fof(bitBlastConstant_2436,axiom,
    ~ b00000000001010010(bitIndex10) ).

fof(bitBlastConstant_2435,axiom,
    ~ b00000000001010010(bitIndex9) ).

fof(bitBlastConstant_2434,axiom,
    ~ b00000000001010010(bitIndex8) ).

fof(bitBlastConstant_2433,axiom,
    ~ b00000000001010010(bitIndex7) ).

fof(bitBlastConstant_2432,axiom,
    b00000000001010010(bitIndex6) ).

fof(bitBlastConstant_2431,axiom,
    ~ b00000000001010010(bitIndex5) ).

fof(bitBlastConstant_2430,axiom,
    b00000000001010010(bitIndex4) ).

fof(bitBlastConstant_2429,axiom,
    ~ b00000000001010010(bitIndex3) ).

fof(bitBlastConstant_2428,axiom,
    ~ b00000000001010010(bitIndex2) ).

fof(bitBlastConstant_2427,axiom,
    b00000000001010010(bitIndex1) ).

fof(bitBlastConstant_2426,axiom,
    ~ b00000000001010010(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges31_2,axiom,
    ! [VarCurr] :
      ( v8180(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000001001110(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges30_2,axiom,
    ! [VarCurr] :
      ( v8178(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000001001010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges29_2,axiom,
    ! [VarCurr] :
      ( v8175(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000001000110(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges28_2,axiom,
    ! [VarCurr] :
      ( v8172(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000001000010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges27_2,axiom,
    ! [VarCurr] :
      ( v8169(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000000111110(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges26_2,axiom,
    ! [VarCurr] :
      ( v8166(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000000111010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges25_2,axiom,
    ! [VarCurr] :
      ( v8162(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000000110110(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges24_2,axiom,
    ! [VarCurr] :
      ( v8158(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000000110010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges23_2,axiom,
    ! [VarCurr] :
      ( v8153(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000000101110(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges22_2,axiom,
    ! [VarCurr] :
      ( v8145(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000000101010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges21_2,axiom,
    ! [VarCurr] :
      ( v8143(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000001001110(B) ) ) ) ).

fof(bitBlastConstant_2425,axiom,
    ~ b00000000001001110(bitIndex16) ).

fof(bitBlastConstant_2424,axiom,
    ~ b00000000001001110(bitIndex15) ).

fof(bitBlastConstant_2423,axiom,
    ~ b00000000001001110(bitIndex14) ).

fof(bitBlastConstant_2422,axiom,
    ~ b00000000001001110(bitIndex13) ).

fof(bitBlastConstant_2421,axiom,
    ~ b00000000001001110(bitIndex12) ).

fof(bitBlastConstant_2420,axiom,
    ~ b00000000001001110(bitIndex11) ).

fof(bitBlastConstant_2419,axiom,
    ~ b00000000001001110(bitIndex10) ).

fof(bitBlastConstant_2418,axiom,
    ~ b00000000001001110(bitIndex9) ).

fof(bitBlastConstant_2417,axiom,
    ~ b00000000001001110(bitIndex8) ).

fof(bitBlastConstant_2416,axiom,
    ~ b00000000001001110(bitIndex7) ).

fof(bitBlastConstant_2415,axiom,
    b00000000001001110(bitIndex6) ).

fof(bitBlastConstant_2414,axiom,
    ~ b00000000001001110(bitIndex5) ).

fof(bitBlastConstant_2413,axiom,
    ~ b00000000001001110(bitIndex4) ).

fof(bitBlastConstant_2412,axiom,
    b00000000001001110(bitIndex3) ).

fof(bitBlastConstant_2411,axiom,
    b00000000001001110(bitIndex2) ).

fof(bitBlastConstant_2410,axiom,
    b00000000001001110(bitIndex1) ).

fof(bitBlastConstant_2409,axiom,
    ~ b00000000001001110(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges20_2,axiom,
    ! [VarCurr] :
      ( v8141(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000001001010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges19_2,axiom,
    ! [VarCurr] :
      ( v8139(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000001000110(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges18_2,axiom,
    ! [VarCurr] :
      ( v8136(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000001000010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges17_2,axiom,
    ! [VarCurr] :
      ( v8133(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000000111110(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges16_2,axiom,
    ! [VarCurr] :
      ( v8130(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000000111010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges15_2,axiom,
    ! [VarCurr] :
      ( v8127(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000000110110(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges14_2,axiom,
    ! [VarCurr] :
      ( v8123(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000000110010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges13_2,axiom,
    ! [VarCurr] :
      ( v8119(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000000101110(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges12_3,axiom,
    ! [VarCurr] :
      ( v8114(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000000101010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges11_3,axiom,
    ! [VarCurr] :
      ( v8106(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000000100110(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges10_3,axiom,
    ! [VarCurr] :
      ( v8104(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000001001010(B) ) ) ) ).

fof(bitBlastConstant_2408,axiom,
    ~ b00000000001001010(bitIndex16) ).

fof(bitBlastConstant_2407,axiom,
    ~ b00000000001001010(bitIndex15) ).

fof(bitBlastConstant_2406,axiom,
    ~ b00000000001001010(bitIndex14) ).

fof(bitBlastConstant_2405,axiom,
    ~ b00000000001001010(bitIndex13) ).

fof(bitBlastConstant_2404,axiom,
    ~ b00000000001001010(bitIndex12) ).

fof(bitBlastConstant_2403,axiom,
    ~ b00000000001001010(bitIndex11) ).

fof(bitBlastConstant_2402,axiom,
    ~ b00000000001001010(bitIndex10) ).

fof(bitBlastConstant_2401,axiom,
    ~ b00000000001001010(bitIndex9) ).

fof(bitBlastConstant_2400,axiom,
    ~ b00000000001001010(bitIndex8) ).

fof(bitBlastConstant_2399,axiom,
    ~ b00000000001001010(bitIndex7) ).

fof(bitBlastConstant_2398,axiom,
    b00000000001001010(bitIndex6) ).

fof(bitBlastConstant_2397,axiom,
    ~ b00000000001001010(bitIndex5) ).

fof(bitBlastConstant_2396,axiom,
    ~ b00000000001001010(bitIndex4) ).

fof(bitBlastConstant_2395,axiom,
    b00000000001001010(bitIndex3) ).

fof(bitBlastConstant_2394,axiom,
    ~ b00000000001001010(bitIndex2) ).

fof(bitBlastConstant_2393,axiom,
    b00000000001001010(bitIndex1) ).

fof(bitBlastConstant_2392,axiom,
    ~ b00000000001001010(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges9_3,axiom,
    ! [VarCurr] :
      ( v8102(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000001000110(B) ) ) ) ).

fof(bitBlastConstant_2391,axiom,
    ~ b00000000001000110(bitIndex16) ).

fof(bitBlastConstant_2390,axiom,
    ~ b00000000001000110(bitIndex15) ).

fof(bitBlastConstant_2389,axiom,
    ~ b00000000001000110(bitIndex14) ).

fof(bitBlastConstant_2388,axiom,
    ~ b00000000001000110(bitIndex13) ).

fof(bitBlastConstant_2387,axiom,
    ~ b00000000001000110(bitIndex12) ).

fof(bitBlastConstant_2386,axiom,
    ~ b00000000001000110(bitIndex11) ).

fof(bitBlastConstant_2385,axiom,
    ~ b00000000001000110(bitIndex10) ).

fof(bitBlastConstant_2384,axiom,
    ~ b00000000001000110(bitIndex9) ).

fof(bitBlastConstant_2383,axiom,
    ~ b00000000001000110(bitIndex8) ).

fof(bitBlastConstant_2382,axiom,
    ~ b00000000001000110(bitIndex7) ).

fof(bitBlastConstant_2381,axiom,
    b00000000001000110(bitIndex6) ).

fof(bitBlastConstant_2380,axiom,
    ~ b00000000001000110(bitIndex5) ).

fof(bitBlastConstant_2379,axiom,
    ~ b00000000001000110(bitIndex4) ).

fof(bitBlastConstant_2378,axiom,
    ~ b00000000001000110(bitIndex3) ).

fof(bitBlastConstant_2377,axiom,
    b00000000001000110(bitIndex2) ).

fof(bitBlastConstant_2376,axiom,
    b00000000001000110(bitIndex1) ).

fof(bitBlastConstant_2375,axiom,
    ~ b00000000001000110(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges8_4,axiom,
    ! [VarCurr] :
      ( v8100(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000001000010(B) ) ) ) ).

fof(bitBlastConstant_2374,axiom,
    ~ b00000000001000010(bitIndex16) ).

fof(bitBlastConstant_2373,axiom,
    ~ b00000000001000010(bitIndex15) ).

fof(bitBlastConstant_2372,axiom,
    ~ b00000000001000010(bitIndex14) ).

fof(bitBlastConstant_2371,axiom,
    ~ b00000000001000010(bitIndex13) ).

fof(bitBlastConstant_2370,axiom,
    ~ b00000000001000010(bitIndex12) ).

fof(bitBlastConstant_2369,axiom,
    ~ b00000000001000010(bitIndex11) ).

fof(bitBlastConstant_2368,axiom,
    ~ b00000000001000010(bitIndex10) ).

fof(bitBlastConstant_2367,axiom,
    ~ b00000000001000010(bitIndex9) ).

fof(bitBlastConstant_2366,axiom,
    ~ b00000000001000010(bitIndex8) ).

fof(bitBlastConstant_2365,axiom,
    ~ b00000000001000010(bitIndex7) ).

fof(bitBlastConstant_2364,axiom,
    b00000000001000010(bitIndex6) ).

fof(bitBlastConstant_2363,axiom,
    ~ b00000000001000010(bitIndex5) ).

fof(bitBlastConstant_2362,axiom,
    ~ b00000000001000010(bitIndex4) ).

fof(bitBlastConstant_2361,axiom,
    ~ b00000000001000010(bitIndex3) ).

fof(bitBlastConstant_2360,axiom,
    ~ b00000000001000010(bitIndex2) ).

fof(bitBlastConstant_2359,axiom,
    b00000000001000010(bitIndex1) ).

fof(bitBlastConstant_2358,axiom,
    ~ b00000000001000010(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges7_4,axiom,
    ! [VarCurr] :
      ( v8097(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000000111110(B) ) ) ) ).

fof(bitBlastConstant_2357,axiom,
    ~ b00000000000111110(bitIndex16) ).

fof(bitBlastConstant_2356,axiom,
    ~ b00000000000111110(bitIndex15) ).

fof(bitBlastConstant_2355,axiom,
    ~ b00000000000111110(bitIndex14) ).

fof(bitBlastConstant_2354,axiom,
    ~ b00000000000111110(bitIndex13) ).

fof(bitBlastConstant_2353,axiom,
    ~ b00000000000111110(bitIndex12) ).

fof(bitBlastConstant_2352,axiom,
    ~ b00000000000111110(bitIndex11) ).

fof(bitBlastConstant_2351,axiom,
    ~ b00000000000111110(bitIndex10) ).

fof(bitBlastConstant_2350,axiom,
    ~ b00000000000111110(bitIndex9) ).

fof(bitBlastConstant_2349,axiom,
    ~ b00000000000111110(bitIndex8) ).

fof(bitBlastConstant_2348,axiom,
    ~ b00000000000111110(bitIndex7) ).

fof(bitBlastConstant_2347,axiom,
    ~ b00000000000111110(bitIndex6) ).

fof(bitBlastConstant_2346,axiom,
    b00000000000111110(bitIndex5) ).

fof(bitBlastConstant_2345,axiom,
    b00000000000111110(bitIndex4) ).

fof(bitBlastConstant_2344,axiom,
    b00000000000111110(bitIndex3) ).

fof(bitBlastConstant_2343,axiom,
    b00000000000111110(bitIndex2) ).

fof(bitBlastConstant_2342,axiom,
    b00000000000111110(bitIndex1) ).

fof(bitBlastConstant_2341,axiom,
    ~ b00000000000111110(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges6_4,axiom,
    ! [VarCurr] :
      ( v8094(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000000111010(B) ) ) ) ).

fof(bitBlastConstant_2340,axiom,
    ~ b00000000000111010(bitIndex16) ).

fof(bitBlastConstant_2339,axiom,
    ~ b00000000000111010(bitIndex15) ).

fof(bitBlastConstant_2338,axiom,
    ~ b00000000000111010(bitIndex14) ).

fof(bitBlastConstant_2337,axiom,
    ~ b00000000000111010(bitIndex13) ).

fof(bitBlastConstant_2336,axiom,
    ~ b00000000000111010(bitIndex12) ).

fof(bitBlastConstant_2335,axiom,
    ~ b00000000000111010(bitIndex11) ).

fof(bitBlastConstant_2334,axiom,
    ~ b00000000000111010(bitIndex10) ).

fof(bitBlastConstant_2333,axiom,
    ~ b00000000000111010(bitIndex9) ).

fof(bitBlastConstant_2332,axiom,
    ~ b00000000000111010(bitIndex8) ).

fof(bitBlastConstant_2331,axiom,
    ~ b00000000000111010(bitIndex7) ).

fof(bitBlastConstant_2330,axiom,
    ~ b00000000000111010(bitIndex6) ).

fof(bitBlastConstant_2329,axiom,
    b00000000000111010(bitIndex5) ).

fof(bitBlastConstant_2328,axiom,
    b00000000000111010(bitIndex4) ).

fof(bitBlastConstant_2327,axiom,
    b00000000000111010(bitIndex3) ).

fof(bitBlastConstant_2326,axiom,
    ~ b00000000000111010(bitIndex2) ).

fof(bitBlastConstant_2325,axiom,
    b00000000000111010(bitIndex1) ).

fof(bitBlastConstant_2324,axiom,
    ~ b00000000000111010(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges5_4,axiom,
    ! [VarCurr] :
      ( v8091(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000000110110(B) ) ) ) ).

fof(bitBlastConstant_2323,axiom,
    ~ b00000000000110110(bitIndex16) ).

fof(bitBlastConstant_2322,axiom,
    ~ b00000000000110110(bitIndex15) ).

fof(bitBlastConstant_2321,axiom,
    ~ b00000000000110110(bitIndex14) ).

fof(bitBlastConstant_2320,axiom,
    ~ b00000000000110110(bitIndex13) ).

fof(bitBlastConstant_2319,axiom,
    ~ b00000000000110110(bitIndex12) ).

fof(bitBlastConstant_2318,axiom,
    ~ b00000000000110110(bitIndex11) ).

fof(bitBlastConstant_2317,axiom,
    ~ b00000000000110110(bitIndex10) ).

fof(bitBlastConstant_2316,axiom,
    ~ b00000000000110110(bitIndex9) ).

fof(bitBlastConstant_2315,axiom,
    ~ b00000000000110110(bitIndex8) ).

fof(bitBlastConstant_2314,axiom,
    ~ b00000000000110110(bitIndex7) ).

fof(bitBlastConstant_2313,axiom,
    ~ b00000000000110110(bitIndex6) ).

fof(bitBlastConstant_2312,axiom,
    b00000000000110110(bitIndex5) ).

fof(bitBlastConstant_2311,axiom,
    b00000000000110110(bitIndex4) ).

fof(bitBlastConstant_2310,axiom,
    ~ b00000000000110110(bitIndex3) ).

fof(bitBlastConstant_2309,axiom,
    b00000000000110110(bitIndex2) ).

fof(bitBlastConstant_2308,axiom,
    b00000000000110110(bitIndex1) ).

fof(bitBlastConstant_2307,axiom,
    ~ b00000000000110110(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges4_11,axiom,
    ! [VarCurr] :
      ( v8088(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000000110010(B) ) ) ) ).

fof(bitBlastConstant_2306,axiom,
    ~ b00000000000110010(bitIndex16) ).

fof(bitBlastConstant_2305,axiom,
    ~ b00000000000110010(bitIndex15) ).

fof(bitBlastConstant_2304,axiom,
    ~ b00000000000110010(bitIndex14) ).

fof(bitBlastConstant_2303,axiom,
    ~ b00000000000110010(bitIndex13) ).

fof(bitBlastConstant_2302,axiom,
    ~ b00000000000110010(bitIndex12) ).

fof(bitBlastConstant_2301,axiom,
    ~ b00000000000110010(bitIndex11) ).

fof(bitBlastConstant_2300,axiom,
    ~ b00000000000110010(bitIndex10) ).

fof(bitBlastConstant_2299,axiom,
    ~ b00000000000110010(bitIndex9) ).

fof(bitBlastConstant_2298,axiom,
    ~ b00000000000110010(bitIndex8) ).

fof(bitBlastConstant_2297,axiom,
    ~ b00000000000110010(bitIndex7) ).

fof(bitBlastConstant_2296,axiom,
    ~ b00000000000110010(bitIndex6) ).

fof(bitBlastConstant_2295,axiom,
    b00000000000110010(bitIndex5) ).

fof(bitBlastConstant_2294,axiom,
    b00000000000110010(bitIndex4) ).

fof(bitBlastConstant_2293,axiom,
    ~ b00000000000110010(bitIndex3) ).

fof(bitBlastConstant_2292,axiom,
    ~ b00000000000110010(bitIndex2) ).

fof(bitBlastConstant_2291,axiom,
    b00000000000110010(bitIndex1) ).

fof(bitBlastConstant_2290,axiom,
    ~ b00000000000110010(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges3_12,axiom,
    ! [VarCurr] :
      ( v8083(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000000101110(B) ) ) ) ).

fof(bitBlastConstant_2289,axiom,
    ~ b00000000000101110(bitIndex16) ).

fof(bitBlastConstant_2288,axiom,
    ~ b00000000000101110(bitIndex15) ).

fof(bitBlastConstant_2287,axiom,
    ~ b00000000000101110(bitIndex14) ).

fof(bitBlastConstant_2286,axiom,
    ~ b00000000000101110(bitIndex13) ).

fof(bitBlastConstant_2285,axiom,
    ~ b00000000000101110(bitIndex12) ).

fof(bitBlastConstant_2284,axiom,
    ~ b00000000000101110(bitIndex11) ).

fof(bitBlastConstant_2283,axiom,
    ~ b00000000000101110(bitIndex10) ).

fof(bitBlastConstant_2282,axiom,
    ~ b00000000000101110(bitIndex9) ).

fof(bitBlastConstant_2281,axiom,
    ~ b00000000000101110(bitIndex8) ).

fof(bitBlastConstant_2280,axiom,
    ~ b00000000000101110(bitIndex7) ).

fof(bitBlastConstant_2279,axiom,
    ~ b00000000000101110(bitIndex6) ).

fof(bitBlastConstant_2278,axiom,
    b00000000000101110(bitIndex5) ).

fof(bitBlastConstant_2277,axiom,
    ~ b00000000000101110(bitIndex4) ).

fof(bitBlastConstant_2276,axiom,
    b00000000000101110(bitIndex3) ).

fof(bitBlastConstant_2275,axiom,
    b00000000000101110(bitIndex2) ).

fof(bitBlastConstant_2274,axiom,
    b00000000000101110(bitIndex1) ).

fof(bitBlastConstant_2273,axiom,
    ~ b00000000000101110(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges2_20,axiom,
    ! [VarCurr] :
      ( v8079(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000000101010(B) ) ) ) ).

fof(bitBlastConstant_2272,axiom,
    ~ b00000000000101010(bitIndex16) ).

fof(bitBlastConstant_2271,axiom,
    ~ b00000000000101010(bitIndex15) ).

fof(bitBlastConstant_2270,axiom,
    ~ b00000000000101010(bitIndex14) ).

fof(bitBlastConstant_2269,axiom,
    ~ b00000000000101010(bitIndex13) ).

fof(bitBlastConstant_2268,axiom,
    ~ b00000000000101010(bitIndex12) ).

fof(bitBlastConstant_2267,axiom,
    ~ b00000000000101010(bitIndex11) ).

fof(bitBlastConstant_2266,axiom,
    ~ b00000000000101010(bitIndex10) ).

fof(bitBlastConstant_2265,axiom,
    ~ b00000000000101010(bitIndex9) ).

fof(bitBlastConstant_2264,axiom,
    ~ b00000000000101010(bitIndex8) ).

fof(bitBlastConstant_2263,axiom,
    ~ b00000000000101010(bitIndex7) ).

fof(bitBlastConstant_2262,axiom,
    ~ b00000000000101010(bitIndex6) ).

fof(bitBlastConstant_2261,axiom,
    b00000000000101010(bitIndex5) ).

fof(bitBlastConstant_2260,axiom,
    ~ b00000000000101010(bitIndex4) ).

fof(bitBlastConstant_2259,axiom,
    b00000000000101010(bitIndex3) ).

fof(bitBlastConstant_2258,axiom,
    ~ b00000000000101010(bitIndex2) ).

fof(bitBlastConstant_2257,axiom,
    b00000000000101010(bitIndex1) ).

fof(bitBlastConstant_2256,axiom,
    ~ b00000000000101010(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges1_31,axiom,
    ! [VarCurr] :
      ( v8073(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000000100110(B) ) ) ) ).

fof(bitBlastConstant_2255,axiom,
    ~ b00000000000100110(bitIndex16) ).

fof(bitBlastConstant_2254,axiom,
    ~ b00000000000100110(bitIndex15) ).

fof(bitBlastConstant_2253,axiom,
    ~ b00000000000100110(bitIndex14) ).

fof(bitBlastConstant_2252,axiom,
    ~ b00000000000100110(bitIndex13) ).

fof(bitBlastConstant_2251,axiom,
    ~ b00000000000100110(bitIndex12) ).

fof(bitBlastConstant_2250,axiom,
    ~ b00000000000100110(bitIndex11) ).

fof(bitBlastConstant_2249,axiom,
    ~ b00000000000100110(bitIndex10) ).

fof(bitBlastConstant_2248,axiom,
    ~ b00000000000100110(bitIndex9) ).

fof(bitBlastConstant_2247,axiom,
    ~ b00000000000100110(bitIndex8) ).

fof(bitBlastConstant_2246,axiom,
    ~ b00000000000100110(bitIndex7) ).

fof(bitBlastConstant_2245,axiom,
    ~ b00000000000100110(bitIndex6) ).

fof(bitBlastConstant_2244,axiom,
    b00000000000100110(bitIndex5) ).

fof(bitBlastConstant_2243,axiom,
    ~ b00000000000100110(bitIndex4) ).

fof(bitBlastConstant_2242,axiom,
    ~ b00000000000100110(bitIndex3) ).

fof(bitBlastConstant_2241,axiom,
    b00000000000100110(bitIndex2) ).

fof(bitBlastConstant_2240,axiom,
    b00000000000100110(bitIndex1) ).

fof(bitBlastConstant_2239,axiom,
    ~ b00000000000100110(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges0_33,axiom,
    ! [VarCurr] :
      ( v18527(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v18526(VarCurr,B)
          <=> b00000000000100010(B) ) ) ) ).

fof(range_axiom_71,axiom,
    ! [B] :
      ( range_16_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B ) ) ).

fof(bitBlastConstant_2238,axiom,
    ~ b00000000000100010(bitIndex16) ).

fof(bitBlastConstant_2237,axiom,
    ~ b00000000000100010(bitIndex15) ).

fof(bitBlastConstant_2236,axiom,
    ~ b00000000000100010(bitIndex14) ).

fof(bitBlastConstant_2235,axiom,
    ~ b00000000000100010(bitIndex13) ).

fof(bitBlastConstant_2234,axiom,
    ~ b00000000000100010(bitIndex12) ).

fof(bitBlastConstant_2233,axiom,
    ~ b00000000000100010(bitIndex11) ).

fof(bitBlastConstant_2232,axiom,
    ~ b00000000000100010(bitIndex10) ).

fof(bitBlastConstant_2231,axiom,
    ~ b00000000000100010(bitIndex9) ).

fof(bitBlastConstant_2230,axiom,
    ~ b00000000000100010(bitIndex8) ).

fof(bitBlastConstant_2229,axiom,
    ~ b00000000000100010(bitIndex7) ).

fof(bitBlastConstant_2228,axiom,
    ~ b00000000000100010(bitIndex6) ).

fof(bitBlastConstant_2227,axiom,
    b00000000000100010(bitIndex5) ).

fof(bitBlastConstant_2226,axiom,
    ~ b00000000000100010(bitIndex4) ).

fof(bitBlastConstant_2225,axiom,
    ~ b00000000000100010(bitIndex3) ).

fof(bitBlastConstant_2224,axiom,
    ~ b00000000000100010(bitIndex2) ).

fof(bitBlastConstant_2223,axiom,
    b00000000000100010(bitIndex1) ).

fof(bitBlastConstant_2222,axiom,
    ~ b00000000000100010(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4807,axiom,
    ! [VarCurr] :
      ( v18527(VarCurr)
    <=> ( v8056(VarCurr)
        | v8064(VarCurr) ) ) ).

fof(addAssignment_2603,axiom,
    ! [VarCurr] :
      ( v18507(VarCurr)
    <=> v7765(VarCurr) ) ).

fof(addAssignment_2602,axiom,
    ! [VarCurr] :
      ( v18505(VarCurr)
    <=> v7761(VarCurr) ) ).

fof(addAssignment_2601,axiom,
    ! [VarCurr] :
      ( v12806(VarCurr)
    <=> v12808(VarCurr) ) ).

fof(addAssignment_2600,axiom,
    ! [VarCurr] :
      ( v12808(VarCurr)
    <=> v7857(VarCurr,bitIndex1) ) ).

fof(addAssignment_2599,axiom,
    ! [VarCurr] :
      ( v7857(VarCurr,bitIndex1)
    <=> v7859(VarCurr,bitIndex1) ) ).

fof(addAssignment_2598,axiom,
    ! [VarCurr] :
      ( v7859(VarCurr,bitIndex1)
    <=> v14000(VarCurr,bitIndex1) ) ).

fof(addParallelCaseBooleanConditionEqualRanges169,axiom,
    ! [VarCurr] :
      ( ( ~ v14001(VarCurr)
        & ~ v14128(VarCurr)
        & ~ v14165(VarCurr)
        & ~ v14229(VarCurr)
        & ~ v14249(VarCurr)
        & ~ v14286(VarCurr)
        & ~ v14305(VarCurr)
        & ~ v14337(VarCurr)
        & ~ v14373(VarCurr)
        & ~ v14403(VarCurr)
        & ~ v14412(VarCurr)
        & ~ v14427(VarCurr)
        & ~ v14468(VarCurr)
        & ~ v14477(VarCurr)
        & ~ v14521(VarCurr)
        & ~ v14569(VarCurr)
        & ~ v14577(VarCurr)
        & ~ v14609(VarCurr)
        & ~ v14618(VarCurr)
        & ~ v14656(VarCurr)
        & ~ v14664(VarCurr)
        & ~ v14680(VarCurr)
        & ~ v14698(VarCurr)
        & ~ v14735(VarCurr)
        & ~ v14738(VarCurr)
        & ~ v14750(VarCurr)
        & ~ v14791(VarCurr)
        & ~ v14800(VarCurr)
        & ~ v14844(VarCurr)
        & ~ v14889(VarCurr)
        & ~ v14897(VarCurr)
        & ~ v14929(VarCurr)
        & ~ v14938(VarCurr)
        & ~ v14976(VarCurr)
        & ~ v14984(VarCurr)
        & ~ v15000(VarCurr)
        & ~ v15018(VarCurr)
        & ~ v15054(VarCurr)
        & ~ v15057(VarCurr)
        & ~ v15068(VarCurr)
        & ~ v15128(VarCurr)
        & ~ v15155(VarCurr)
        & ~ v15187(VarCurr)
        & ~ v15223(VarCurr)
        & ~ v15259(VarCurr)
        & ~ v15270(VarCurr)
        & ~ v15279(VarCurr)
        & ~ v15319(VarCurr)
        & ~ v15328(VarCurr)
        & ~ v15372(VarCurr)
        & ~ v15422(VarCurr)
        & ~ v15430(VarCurr)
        & ~ v15462(VarCurr)
        & ~ v15471(VarCurr)
        & ~ v15509(VarCurr)
        & ~ v15517(VarCurr)
        & ~ v15533(VarCurr)
        & ~ v15551(VarCurr)
        & ~ v15588(VarCurr)
        & ~ v15591(VarCurr)
        & ~ v15600(VarCurr)
        & ~ v15641(VarCurr)
        & ~ v15650(VarCurr)
        & ~ v15694(VarCurr)
        & ~ v15744(VarCurr)
        & ~ v15752(VarCurr)
        & ~ v15784(VarCurr)
        & ~ v15793(VarCurr)
        & ~ v15831(VarCurr)
        & ~ v15839(VarCurr)
        & ~ v15855(VarCurr)
        & ~ v15873(VarCurr)
        & ~ v15909(VarCurr)
        & ~ v15912(VarCurr)
        & ~ v15921(VarCurr)
        & ~ v15961(VarCurr)
        & ~ v15970(VarCurr)
        & ~ v16014(VarCurr)
        & ~ v16077(VarCurr)
        & ~ v16094(VarCurr)
        & ~ v16102(VarCurr)
        & ~ v16150(VarCurr)
        & ~ v16159(VarCurr)
        & ~ v16203(VarCurr)
        & ~ v16248(VarCurr)
        & ~ v16256(VarCurr)
        & ~ v16288(VarCurr)
        & ~ v16297(VarCurr)
        & ~ v16343(VarCurr)
        & ~ v16351(VarCurr)
        & ~ v16367(VarCurr)
        & ~ v16385(VarCurr)
        & ~ v16421(VarCurr)
        & ~ v16424(VarCurr)
        & ~ v16432(VarCurr)
        & ~ v16473(VarCurr)
        & ~ v16482(VarCurr)
        & ~ v16526(VarCurr)
        & ~ v16575(VarCurr)
        & ~ v16583(VarCurr)
        & ~ v16615(VarCurr)
        & ~ v16624(VarCurr)
        & ~ v16670(VarCurr)
        & ~ v16678(VarCurr)
        & ~ v16694(VarCurr)
        & ~ v16712(VarCurr)
        & ~ v16747(VarCurr)
        & ~ v16750(VarCurr)
        & ~ v16758(VarCurr)
        & ~ v16798(VarCurr)
        & ~ v16807(VarCurr)
        & ~ v16851(VarCurr)
        & ~ v16901(VarCurr)
        & ~ v16909(VarCurr)
        & ~ v16941(VarCurr)
        & ~ v16950(VarCurr)
        & ~ v17022(VarCurr)
        & ~ v17034(VarCurr)
        & ~ v17078(VarCurr)
        & ~ v17135(VarCurr)
        & ~ v17144(VarCurr)
        & ~ v17176(VarCurr)
        & ~ v17185(VarCurr)
        & ~ v17231(VarCurr)
        & ~ v17239(VarCurr)
        & ~ v17255(VarCurr)
        & ~ v17273(VarCurr)
        & ~ v17318(VarCurr)
        & ~ v17322(VarCurr)
        & ~ v17330(VarCurr)
        & ~ v17371(VarCurr)
        & ~ v17380(VarCurr)
        & ~ v17424(VarCurr)
        & ~ v17473(VarCurr)
        & ~ v17481(VarCurr)
        & ~ v17513(VarCurr)
        & ~ v17522(VarCurr)
        & ~ v17568(VarCurr)
        & ~ v17576(VarCurr)
        & ~ v17592(VarCurr)
        & ~ v17610(VarCurr)
        & ~ v17655(VarCurr)
        & ~ v17658(VarCurr)
        & ~ v17666(VarCurr)
        & ~ v17706(VarCurr)
        & ~ v17715(VarCurr)
        & ~ v17759(VarCurr)
        & ~ v17807(VarCurr)
        & ~ v17815(VarCurr)
        & ~ v17847(VarCurr)
        & ~ v17856(VarCurr)
        & ~ v17900(VarCurr)
        & ~ v17908(VarCurr)
        & ~ v17924(VarCurr)
        & ~ v17942(VarCurr)
        & ~ v17994(VarCurr)
        & ~ v18017(VarCurr)
        & ~ v18049(VarCurr)
        & ~ v18085(VarCurr)
        & ~ v18129(VarCurr)
        & ~ v18140(VarCurr)
        & ~ v18143(VarCurr)
        & ~ v18195(VarCurr)
        & ~ v18202(VarCurr)
        & ~ v18246(VarCurr)
        & ~ v18314(VarCurr)
        & ~ v18337(VarCurr)
        & ~ v18401(VarCurr)
        & ~ v18421(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges168,axiom,
    ! [VarCurr] :
      ( v18421(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges167,axiom,
    ! [VarCurr] :
      ( v18401(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges166,axiom,
    ! [VarCurr] :
      ( v18337(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges165,axiom,
    ! [VarCurr] :
      ( v18314(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges164,axiom,
    ! [VarCurr] :
      ( v18246(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges163,axiom,
    ! [VarCurr] :
      ( v18202(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges162,axiom,
    ! [VarCurr] :
      ( v18195(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges161,axiom,
    ! [VarCurr] :
      ( v18143(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges160,axiom,
    ! [VarCurr] :
      ( v18140(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges159,axiom,
    ! [VarCurr] :
      ( v18129(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges158,axiom,
    ! [VarCurr] :
      ( v18085(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges157,axiom,
    ! [VarCurr] :
      ( v18049(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges156,axiom,
    ! [VarCurr] :
      ( v18017(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges155,axiom,
    ! [VarCurr] :
      ( v17994(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges154,axiom,
    ! [VarCurr] :
      ( v17942(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges153,axiom,
    ! [VarCurr] :
      ( v17924(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges152,axiom,
    ! [VarCurr] :
      ( v17908(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges151,axiom,
    ! [VarCurr] :
      ( v17900(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges150,axiom,
    ! [VarCurr] :
      ( v17856(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges149,axiom,
    ! [VarCurr] :
      ( v17847(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges148,axiom,
    ! [VarCurr] :
      ( v17815(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges147,axiom,
    ! [VarCurr] :
      ( v17807(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges146,axiom,
    ! [VarCurr] :
      ( v17759(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges145,axiom,
    ! [VarCurr] :
      ( v17715(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges144,axiom,
    ! [VarCurr] :
      ( v17706(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges143,axiom,
    ! [VarCurr] :
      ( v17666(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges142,axiom,
    ! [VarCurr] :
      ( v17658(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges141,axiom,
    ! [VarCurr] :
      ( v17655(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges140,axiom,
    ! [VarCurr] :
      ( v17610(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges139,axiom,
    ! [VarCurr] :
      ( v17592(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges138,axiom,
    ! [VarCurr] :
      ( v17576(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges137,axiom,
    ! [VarCurr] :
      ( v17568(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges136,axiom,
    ! [VarCurr] :
      ( v17522(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges135,axiom,
    ! [VarCurr] :
      ( v17513(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges134,axiom,
    ! [VarCurr] :
      ( v17481(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges133,axiom,
    ! [VarCurr] :
      ( v17473(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges132,axiom,
    ! [VarCurr] :
      ( v17424(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges131,axiom,
    ! [VarCurr] :
      ( v17380(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges130,axiom,
    ! [VarCurr] :
      ( v17371(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges129,axiom,
    ! [VarCurr] :
      ( v17330(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges128,axiom,
    ! [VarCurr] :
      ( v17322(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges127_8,axiom,
    ! [VarCurr] :
      ( v17318(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges126,axiom,
    ! [VarCurr] :
      ( v17273(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges125,axiom,
    ! [VarCurr] :
      ( v17255(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges124,axiom,
    ! [VarCurr] :
      ( v17239(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges123,axiom,
    ! [VarCurr] :
      ( v17231(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges122,axiom,
    ! [VarCurr] :
      ( v17185(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges121,axiom,
    ! [VarCurr] :
      ( v17176(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges120,axiom,
    ! [VarCurr] :
      ( v17144(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges119,axiom,
    ! [VarCurr] :
      ( v17135(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges118,axiom,
    ! [VarCurr] :
      ( v17078(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges117,axiom,
    ! [VarCurr] :
      ( v17034(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges116,axiom,
    ! [VarCurr] :
      ( v17022(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges115,axiom,
    ! [VarCurr] :
      ( v16950(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges114,axiom,
    ! [VarCurr] :
      ( v16941(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges113,axiom,
    ! [VarCurr] :
      ( v16909(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges112,axiom,
    ! [VarCurr] :
      ( v16901(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges111,axiom,
    ! [VarCurr] :
      ( v16851(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges110,axiom,
    ! [VarCurr] :
      ( v16807(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges109,axiom,
    ! [VarCurr] :
      ( v16798(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges108,axiom,
    ! [VarCurr] :
      ( v16758(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges107,axiom,
    ! [VarCurr] :
      ( v16750(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges106,axiom,
    ! [VarCurr] :
      ( v16747(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges105,axiom,
    ! [VarCurr] :
      ( v16712(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges104,axiom,
    ! [VarCurr] :
      ( v16694(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges103,axiom,
    ! [VarCurr] :
      ( v16678(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges102,axiom,
    ! [VarCurr] :
      ( v16670(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges101,axiom,
    ! [VarCurr] :
      ( v16624(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges100,axiom,
    ! [VarCurr] :
      ( v16615(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges99,axiom,
    ! [VarCurr] :
      ( v16583(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges98,axiom,
    ! [VarCurr] :
      ( v16575(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges97,axiom,
    ! [VarCurr] :
      ( v16526(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges96,axiom,
    ! [VarCurr] :
      ( v16482(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges95,axiom,
    ! [VarCurr] :
      ( v16473(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges94,axiom,
    ! [VarCurr] :
      ( v16432(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges93,axiom,
    ! [VarCurr] :
      ( v16424(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges92,axiom,
    ! [VarCurr] :
      ( v16421(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges91,axiom,
    ! [VarCurr] :
      ( v16385(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges90,axiom,
    ! [VarCurr] :
      ( v16367(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges89,axiom,
    ! [VarCurr] :
      ( v16351(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges88,axiom,
    ! [VarCurr] :
      ( v16343(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges87,axiom,
    ! [VarCurr] :
      ( v16297(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges86,axiom,
    ! [VarCurr] :
      ( v16288(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges85,axiom,
    ! [VarCurr] :
      ( v16256(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges84,axiom,
    ! [VarCurr] :
      ( v16248(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges83,axiom,
    ! [VarCurr] :
      ( v16203(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges82,axiom,
    ! [VarCurr] :
      ( v16159(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges81,axiom,
    ! [VarCurr] :
      ( v16150(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges80,axiom,
    ! [VarCurr] :
      ( v16102(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges79,axiom,
    ! [VarCurr] :
      ( v16094(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges78,axiom,
    ! [VarCurr] :
      ( v16077(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges77,axiom,
    ! [VarCurr] :
      ( v16014(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges76,axiom,
    ! [VarCurr] :
      ( v15970(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges75,axiom,
    ! [VarCurr] :
      ( v15961(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges74,axiom,
    ! [VarCurr] :
      ( v15921(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges73,axiom,
    ! [VarCurr] :
      ( v15912(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges72,axiom,
    ! [VarCurr] :
      ( v15909(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges71,axiom,
    ! [VarCurr] :
      ( v15873(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges70,axiom,
    ! [VarCurr] :
      ( v15855(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges69,axiom,
    ! [VarCurr] :
      ( v15839(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges68,axiom,
    ! [VarCurr] :
      ( v15831(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges67,axiom,
    ! [VarCurr] :
      ( v15793(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges66,axiom,
    ! [VarCurr] :
      ( v15784(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges65,axiom,
    ! [VarCurr] :
      ( v15752(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges64,axiom,
    ! [VarCurr] :
      ( v15744(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges63,axiom,
    ! [VarCurr] :
      ( v15694(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges62,axiom,
    ! [VarCurr] :
      ( v15650(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges61,axiom,
    ! [VarCurr] :
      ( v15641(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges60,axiom,
    ! [VarCurr] :
      ( v15600(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges59,axiom,
    ! [VarCurr] :
      ( v15591(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges58,axiom,
    ! [VarCurr] :
      ( v15588(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges57,axiom,
    ! [VarCurr] :
      ( v15551(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges56,axiom,
    ! [VarCurr] :
      ( v15533(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges55,axiom,
    ! [VarCurr] :
      ( v15517(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges54,axiom,
    ! [VarCurr] :
      ( v15509(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges53,axiom,
    ! [VarCurr] :
      ( v15471(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges52,axiom,
    ! [VarCurr] :
      ( v15462(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges51,axiom,
    ! [VarCurr] :
      ( v15430(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges50,axiom,
    ! [VarCurr] :
      ( v15422(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges49,axiom,
    ! [VarCurr] :
      ( v15372(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges48_1,axiom,
    ! [VarCurr] :
      ( v15328(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges47_1,axiom,
    ! [VarCurr] :
      ( v15319(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges46_1,axiom,
    ! [VarCurr] :
      ( v15279(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges45_1,axiom,
    ! [VarCurr] :
      ( v15270(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges44_1,axiom,
    ! [VarCurr] :
      ( v15259(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges43_1,axiom,
    ! [VarCurr] :
      ( v15223(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges42_1,axiom,
    ! [VarCurr] :
      ( v15187(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges41_1,axiom,
    ! [VarCurr] :
      ( v15155(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges40_1,axiom,
    ! [VarCurr] :
      ( v15128(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges39_1,axiom,
    ! [VarCurr] :
      ( v15068(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges38_1,axiom,
    ! [VarCurr] :
      ( v15057(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges37_1,axiom,
    ! [VarCurr] :
      ( v15054(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges36_1,axiom,
    ! [VarCurr] :
      ( v15018(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges35_1,axiom,
    ! [VarCurr] :
      ( v15000(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges34_1,axiom,
    ! [VarCurr] :
      ( v14984(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges33_1,axiom,
    ! [VarCurr] :
      ( v14976(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges32_1,axiom,
    ! [VarCurr] :
      ( v14938(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges31_1,axiom,
    ! [VarCurr] :
      ( v14929(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges30_1,axiom,
    ! [VarCurr] :
      ( v14897(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges29_1,axiom,
    ! [VarCurr] :
      ( v14889(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges28_1,axiom,
    ! [VarCurr] :
      ( v14844(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges27_1,axiom,
    ! [VarCurr] :
      ( v14800(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges26_1,axiom,
    ! [VarCurr] :
      ( v14791(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges25_1,axiom,
    ! [VarCurr] :
      ( v14750(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges24_1,axiom,
    ! [VarCurr] :
      ( v14738(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges23_1,axiom,
    ! [VarCurr] :
      ( v14735(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges22_1,axiom,
    ! [VarCurr] :
      ( v14698(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges21_1,axiom,
    ! [VarCurr] :
      ( v14680(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges20_1,axiom,
    ! [VarCurr] :
      ( v14664(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges19_1,axiom,
    ! [VarCurr] :
      ( v14656(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges18_1,axiom,
    ! [VarCurr] :
      ( v14618(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges17_1,axiom,
    ! [VarCurr] :
      ( v14609(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges16_1,axiom,
    ! [VarCurr] :
      ( v14577(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges15_1,axiom,
    ! [VarCurr] :
      ( v14569(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges14_1,axiom,
    ! [VarCurr] :
      ( v14521(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges13_1,axiom,
    ! [VarCurr] :
      ( v14477(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges12_2,axiom,
    ! [VarCurr] :
      ( v14468(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges11_2,axiom,
    ! [VarCurr] :
      ( v14427(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges10_2,axiom,
    ! [VarCurr] :
      ( v14412(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges9_2,axiom,
    ! [VarCurr] :
      ( v14403(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges8_3,axiom,
    ! [VarCurr] :
      ( v14373(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges7_3,axiom,
    ! [VarCurr] :
      ( v14337(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges6_3,axiom,
    ! [VarCurr] :
      ( v14305(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges5_3,axiom,
    ! [VarCurr] :
      ( v14286(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_10,axiom,
    ! [VarCurr] :
      ( v14249(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_11,axiom,
    ! [VarCurr] :
      ( v14229(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_19,axiom,
    ! [VarCurr] :
      ( v14165(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $true ) ) ) ).

fof(bitBlastConstant_2221,axiom,
    b111(bitIndex2) ).

fof(bitBlastConstant_2220,axiom,
    b111(bitIndex1) ).

fof(bitBlastConstant_2219,axiom,
    b111(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges1_30,axiom,
    ! [VarCurr] :
      ( v14128(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_32,axiom,
    ! [VarCurr] :
      ( v14001(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v14000(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4806,axiom,
    ! [VarCurr] :
      ( v18421(VarCurr)
    <=> ( v18423(VarCurr)
        | v18493(VarCurr) ) ) ).

fof(addAssignment_2597,axiom,
    ! [VarCurr] :
      ( v18493(VarCurr)
    <=> v12706(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4805,axiom,
    ! [VarCurr] :
      ( v18423(VarCurr)
    <=> ( v18424(VarCurr)
        | v18491(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1566,axiom,
    ! [VarCurr] :
      ( v18491(VarCurr)
    <=> ( v18476(VarCurr)
        & v12796(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4804,axiom,
    ! [VarCurr] :
      ( v18424(VarCurr)
    <=> ( v18425(VarCurr)
        | v18489(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1565,axiom,
    ! [VarCurr] :
      ( v18489(VarCurr)
    <=> ( v18473(VarCurr)
        & v12796(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4803,axiom,
    ! [VarCurr] :
      ( v18425(VarCurr)
    <=> ( v18426(VarCurr)
        | v18487(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1564,axiom,
    ! [VarCurr] :
      ( v18487(VarCurr)
    <=> ( v18470(VarCurr)
        & v12796(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4802,axiom,
    ! [VarCurr] :
      ( v18426(VarCurr)
    <=> ( v18427(VarCurr)
        | v18485(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1563,axiom,
    ! [VarCurr] :
      ( v18485(VarCurr)
    <=> ( v18467(VarCurr)
        & v12796(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4801,axiom,
    ! [VarCurr] :
      ( v18427(VarCurr)
    <=> ( v18428(VarCurr)
        | v18483(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1562,axiom,
    ! [VarCurr] :
      ( v18483(VarCurr)
    <=> ( v18463(VarCurr)
        & v12796(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4800,axiom,
    ! [VarCurr] :
      ( v18428(VarCurr)
    <=> ( v18429(VarCurr)
        | v18481(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1561,axiom,
    ! [VarCurr] :
      ( v18481(VarCurr)
    <=> ( v18459(VarCurr)
        & v12796(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4799,axiom,
    ! [VarCurr] :
      ( v18429(VarCurr)
    <=> ( v18430(VarCurr)
        | v18479(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1560,axiom,
    ! [VarCurr] :
      ( v18479(VarCurr)
    <=> ( v18454(VarCurr)
        & v12796(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4798,axiom,
    ! [VarCurr] :
      ( v18430(VarCurr)
    <=> ( v18431(VarCurr)
        | v18477(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1559,axiom,
    ! [VarCurr] :
      ( v18477(VarCurr)
    <=> ( v18444(VarCurr)
        & v12796(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4797,axiom,
    ! [VarCurr] :
      ( v18431(VarCurr)
    <=> ( v18432(VarCurr)
        | v18474(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4796,axiom,
    ! [VarCurr] :
      ( v18474(VarCurr)
    <=> ( v18476(VarCurr)
        & v18451(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1558,axiom,
    ! [VarCurr] :
      ( v18476(VarCurr)
    <=> ( v18464(VarCurr)
        & v12796(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4795,axiom,
    ! [VarCurr] :
      ( v18432(VarCurr)
    <=> ( v18433(VarCurr)
        | v18471(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4794,axiom,
    ! [VarCurr] :
      ( v18471(VarCurr)
    <=> ( v18473(VarCurr)
        & v18451(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1557,axiom,
    ! [VarCurr] :
      ( v18473(VarCurr)
    <=> ( v18460(VarCurr)
        & v12796(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4793,axiom,
    ! [VarCurr] :
      ( v18433(VarCurr)
    <=> ( v18434(VarCurr)
        | v18468(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4792,axiom,
    ! [VarCurr] :
      ( v18468(VarCurr)
    <=> ( v18470(VarCurr)
        & v18451(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1556,axiom,
    ! [VarCurr] :
      ( v18470(VarCurr)
    <=> ( v18455(VarCurr)
        & v12796(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4791,axiom,
    ! [VarCurr] :
      ( v18434(VarCurr)
    <=> ( v18435(VarCurr)
        | v18465(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4790,axiom,
    ! [VarCurr] :
      ( v18465(VarCurr)
    <=> ( v18467(VarCurr)
        & v18451(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1555,axiom,
    ! [VarCurr] :
      ( v18467(VarCurr)
    <=> ( v18445(VarCurr)
        & v12796(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4789,axiom,
    ! [VarCurr] :
      ( v18435(VarCurr)
    <=> ( v18436(VarCurr)
        | v18461(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4788,axiom,
    ! [VarCurr] :
      ( v18461(VarCurr)
    <=> ( v18463(VarCurr)
        & v18451(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4787,axiom,
    ! [VarCurr] :
      ( v18463(VarCurr)
    <=> ( v18464(VarCurr)
        & v18450(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1554,axiom,
    ! [VarCurr] :
      ( v18464(VarCurr)
    <=> ( v18456(VarCurr)
        & v12796(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4786,axiom,
    ! [VarCurr] :
      ( v18436(VarCurr)
    <=> ( v18437(VarCurr)
        | v18457(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4785,axiom,
    ! [VarCurr] :
      ( v18457(VarCurr)
    <=> ( v18459(VarCurr)
        & v18451(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4784,axiom,
    ! [VarCurr] :
      ( v18459(VarCurr)
    <=> ( v18460(VarCurr)
        & v18450(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1553,axiom,
    ! [VarCurr] :
      ( v18460(VarCurr)
    <=> ( v18446(VarCurr)
        & v12796(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4783,axiom,
    ! [VarCurr] :
      ( v18437(VarCurr)
    <=> ( v18438(VarCurr)
        | v18452(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4782,axiom,
    ! [VarCurr] :
      ( v18452(VarCurr)
    <=> ( v18454(VarCurr)
        & v18451(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4781,axiom,
    ! [VarCurr] :
      ( v18454(VarCurr)
    <=> ( v18455(VarCurr)
        & v18450(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4780,axiom,
    ! [VarCurr] :
      ( v18455(VarCurr)
    <=> ( v18456(VarCurr)
        & v18449(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4779,axiom,
    ! [VarCurr] :
      ( v18456(VarCurr)
    <=> ( v18447(VarCurr)
        & v12796(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4778,axiom,
    ! [VarCurr] :
      ( v18438(VarCurr)
    <=> ( v18439(VarCurr)
        | v18442(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4777,axiom,
    ! [VarCurr] :
      ( v18442(VarCurr)
    <=> ( v18444(VarCurr)
        & v18451(VarCurr) ) ) ).

fof(writeUnaryOperator_1400,axiom,
    ! [VarCurr] :
      ( ~ v18451(VarCurr)
    <=> v12796(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4776,axiom,
    ! [VarCurr] :
      ( v18444(VarCurr)
    <=> ( v18445(VarCurr)
        & v18450(VarCurr) ) ) ).

fof(writeUnaryOperator_1399,axiom,
    ! [VarCurr] :
      ( ~ v18450(VarCurr)
    <=> v12796(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4775,axiom,
    ! [VarCurr] :
      ( v18445(VarCurr)
    <=> ( v18446(VarCurr)
        & v18449(VarCurr) ) ) ).

fof(writeUnaryOperator_1398,axiom,
    ! [VarCurr] :
      ( ~ v18449(VarCurr)
    <=> v12796(VarCurr,bitIndex1) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4774,axiom,
    ! [VarCurr] :
      ( v18446(VarCurr)
    <=> ( v18447(VarCurr)
        & v18448(VarCurr) ) ) ).

fof(writeUnaryOperator_1397,axiom,
    ! [VarCurr] :
      ( ~ v18448(VarCurr)
    <=> v12796(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4773,axiom,
    ! [VarCurr] :
      ( v18447(VarCurr)
    <=> ( v14017(VarCurr)
        & v12794(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1552,axiom,
    ! [VarCurr] :
      ( v18439(VarCurr)
    <=> ( v18441(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1551,axiom,
    ! [VarCurr] :
      ( v18441(VarCurr)
    <=> ( v14016(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4772,axiom,
    ! [VarCurr] :
      ( v18401(VarCurr)
    <=> ( v18403(VarCurr)
        | v18417(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1550,axiom,
    ! [VarCurr] :
      ( v18417(VarCurr)
    <=> ( v18419(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4771,axiom,
    ! [VarCurr] :
      ( v18419(VarCurr)
    <=> ( v18420(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1549,axiom,
    ! [VarCurr] :
      ( v18420(VarCurr)
    <=> ( v18331(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4770,axiom,
    ! [VarCurr] :
      ( v18403(VarCurr)
    <=> ( v18404(VarCurr)
        | v18413(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1548,axiom,
    ! [VarCurr] :
      ( v18413(VarCurr)
    <=> ( v18415(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4769,axiom,
    ! [VarCurr] :
      ( v18415(VarCurr)
    <=> ( v18416(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1547,axiom,
    ! [VarCurr] :
      ( v18416(VarCurr)
    <=> ( v18320(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4768,axiom,
    ! [VarCurr] :
      ( v18404(VarCurr)
    <=> ( v18405(VarCurr)
        | v18409(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1546,axiom,
    ! [VarCurr] :
      ( v18409(VarCurr)
    <=> ( v18411(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4767,axiom,
    ! [VarCurr] :
      ( v18411(VarCurr)
    <=> ( v18412(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4766,axiom,
    ! [VarCurr] :
      ( v18412(VarCurr)
    <=> ( v18331(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1545,axiom,
    ! [VarCurr] :
      ( v18405(VarCurr)
    <=> ( v18407(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4765,axiom,
    ! [VarCurr] :
      ( v18407(VarCurr)
    <=> ( v18408(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4764,axiom,
    ! [VarCurr] :
      ( v18408(VarCurr)
    <=> ( v18320(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4763,axiom,
    ! [VarCurr] :
      ( v18337(VarCurr)
    <=> ( v18339(VarCurr)
        | v18398(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4762,axiom,
    ! [VarCurr] :
      ( v18398(VarCurr)
    <=> ( v18400(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1544,axiom,
    ! [VarCurr] :
      ( v18400(VarCurr)
    <=> ( v18376(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4761,axiom,
    ! [VarCurr] :
      ( v18339(VarCurr)
    <=> ( v18340(VarCurr)
        | v18395(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4760,axiom,
    ! [VarCurr] :
      ( v18395(VarCurr)
    <=> ( v18397(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1543,axiom,
    ! [VarCurr] :
      ( v18397(VarCurr)
    <=> ( v18372(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4759,axiom,
    ! [VarCurr] :
      ( v18340(VarCurr)
    <=> ( v18341(VarCurr)
        | v18392(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4758,axiom,
    ! [VarCurr] :
      ( v18392(VarCurr)
    <=> ( v18394(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1542,axiom,
    ! [VarCurr] :
      ( v18394(VarCurr)
    <=> ( v18368(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4757,axiom,
    ! [VarCurr] :
      ( v18341(VarCurr)
    <=> ( v18342(VarCurr)
        | v18389(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4756,axiom,
    ! [VarCurr] :
      ( v18389(VarCurr)
    <=> ( v18391(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1541,axiom,
    ! [VarCurr] :
      ( v18391(VarCurr)
    <=> ( v18364(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4755,axiom,
    ! [VarCurr] :
      ( v18342(VarCurr)
    <=> ( v18343(VarCurr)
        | v18386(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4754,axiom,
    ! [VarCurr] :
      ( v18386(VarCurr)
    <=> ( v18388(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1540,axiom,
    ! [VarCurr] :
      ( v18388(VarCurr)
    <=> ( v18359(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4753,axiom,
    ! [VarCurr] :
      ( v18343(VarCurr)
    <=> ( v18344(VarCurr)
        | v18383(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4752,axiom,
    ! [VarCurr] :
      ( v18383(VarCurr)
    <=> ( v18385(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1539,axiom,
    ! [VarCurr] :
      ( v18385(VarCurr)
    <=> ( v18354(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4751,axiom,
    ! [VarCurr] :
      ( v18344(VarCurr)
    <=> ( v18345(VarCurr)
        | v18380(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4750,axiom,
    ! [VarCurr] :
      ( v18380(VarCurr)
    <=> ( v18382(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1538,axiom,
    ! [VarCurr] :
      ( v18382(VarCurr)
    <=> ( v18329(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4749,axiom,
    ! [VarCurr] :
      ( v18345(VarCurr)
    <=> ( v18346(VarCurr)
        | v18377(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4748,axiom,
    ! [VarCurr] :
      ( v18377(VarCurr)
    <=> ( v18379(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1537,axiom,
    ! [VarCurr] :
      ( v18379(VarCurr)
    <=> ( v18318(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4747,axiom,
    ! [VarCurr] :
      ( v18346(VarCurr)
    <=> ( v18347(VarCurr)
        | v18373(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4746,axiom,
    ! [VarCurr] :
      ( v18373(VarCurr)
    <=> ( v18375(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4745,axiom,
    ! [VarCurr] :
      ( v18375(VarCurr)
    <=> ( v18376(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1536,axiom,
    ! [VarCurr] :
      ( v18376(VarCurr)
    <=> ( v18360(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4744,axiom,
    ! [VarCurr] :
      ( v18347(VarCurr)
    <=> ( v18348(VarCurr)
        | v18369(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4743,axiom,
    ! [VarCurr] :
      ( v18369(VarCurr)
    <=> ( v18371(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4742,axiom,
    ! [VarCurr] :
      ( v18371(VarCurr)
    <=> ( v18372(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1535,axiom,
    ! [VarCurr] :
      ( v18372(VarCurr)
    <=> ( v18355(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4741,axiom,
    ! [VarCurr] :
      ( v18348(VarCurr)
    <=> ( v18349(VarCurr)
        | v18365(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4740,axiom,
    ! [VarCurr] :
      ( v18365(VarCurr)
    <=> ( v18367(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4739,axiom,
    ! [VarCurr] :
      ( v18367(VarCurr)
    <=> ( v18368(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1534,axiom,
    ! [VarCurr] :
      ( v18368(VarCurr)
    <=> ( v18330(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4738,axiom,
    ! [VarCurr] :
      ( v18349(VarCurr)
    <=> ( v18350(VarCurr)
        | v18361(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4737,axiom,
    ! [VarCurr] :
      ( v18361(VarCurr)
    <=> ( v18363(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4736,axiom,
    ! [VarCurr] :
      ( v18363(VarCurr)
    <=> ( v18364(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1533,axiom,
    ! [VarCurr] :
      ( v18364(VarCurr)
    <=> ( v18319(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4735,axiom,
    ! [VarCurr] :
      ( v18350(VarCurr)
    <=> ( v18351(VarCurr)
        | v18356(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4734,axiom,
    ! [VarCurr] :
      ( v18356(VarCurr)
    <=> ( v18358(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4733,axiom,
    ! [VarCurr] :
      ( v18358(VarCurr)
    <=> ( v18359(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4732,axiom,
    ! [VarCurr] :
      ( v18359(VarCurr)
    <=> ( v18360(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4731,axiom,
    ! [VarCurr] :
      ( v18360(VarCurr)
    <=> ( v18331(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4730,axiom,
    ! [VarCurr] :
      ( v18351(VarCurr)
    <=> ( v18353(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4729,axiom,
    ! [VarCurr] :
      ( v18353(VarCurr)
    <=> ( v18354(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4728,axiom,
    ! [VarCurr] :
      ( v18354(VarCurr)
    <=> ( v18355(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4727,axiom,
    ! [VarCurr] :
      ( v18355(VarCurr)
    <=> ( v18320(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4726,axiom,
    ! [VarCurr] :
      ( v18314(VarCurr)
    <=> ( v18315(VarCurr)
        | v18326(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4725,axiom,
    ! [VarCurr] :
      ( v18326(VarCurr)
    <=> ( v18328(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4724,axiom,
    ! [VarCurr] :
      ( v18328(VarCurr)
    <=> ( v18329(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4723,axiom,
    ! [VarCurr] :
      ( v18329(VarCurr)
    <=> ( v18330(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4722,axiom,
    ! [VarCurr] :
      ( v18330(VarCurr)
    <=> ( v18331(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1532,axiom,
    ! [VarCurr] :
      ( v18331(VarCurr)
    <=> ( v18332(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4721,axiom,
    ! [VarCurr] :
      ( v18332(VarCurr)
    <=> ( v18333(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1531,axiom,
    ! [VarCurr] :
      ( v18333(VarCurr)
    <=> ( v18334(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4720,axiom,
    ! [VarCurr] :
      ( v18334(VarCurr)
    <=> ( v18335(VarCurr)
        & v12810(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1530,axiom,
    ! [VarCurr] :
      ( v18335(VarCurr)
    <=> ( v18336(VarCurr)
        & v13075(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4719,axiom,
    ! [VarCurr] :
      ( v18336(VarCurr)
    <=> ( v14164(VarCurr)
        & v14036(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4718,axiom,
    ! [VarCurr] :
      ( v18315(VarCurr)
    <=> ( v18317(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4717,axiom,
    ! [VarCurr] :
      ( v18317(VarCurr)
    <=> ( v18318(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4716,axiom,
    ! [VarCurr] :
      ( v18318(VarCurr)
    <=> ( v18319(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4715,axiom,
    ! [VarCurr] :
      ( v18319(VarCurr)
    <=> ( v18320(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1529,axiom,
    ! [VarCurr] :
      ( v18320(VarCurr)
    <=> ( v18321(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4714,axiom,
    ! [VarCurr] :
      ( v18321(VarCurr)
    <=> ( v18322(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1528,axiom,
    ! [VarCurr] :
      ( v18322(VarCurr)
    <=> ( v18323(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4713,axiom,
    ! [VarCurr] :
      ( v18323(VarCurr)
    <=> ( v18324(VarCurr)
        & v12810(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1527,axiom,
    ! [VarCurr] :
      ( v18324(VarCurr)
    <=> ( v18325(VarCurr)
        & v13075(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4712,axiom,
    ! [VarCurr] :
      ( v18325(VarCurr)
    <=> ( v14144(VarCurr)
        & v14036(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4711,axiom,
    ! [VarCurr] :
      ( v18246(VarCurr)
    <=> ( v18248(VarCurr)
        | v18310(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1526,axiom,
    ! [VarCurr] :
      ( v18310(VarCurr)
    <=> ( v18312(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4710,axiom,
    ! [VarCurr] :
      ( v18312(VarCurr)
    <=> ( v18313(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1525,axiom,
    ! [VarCurr] :
      ( v18313(VarCurr)
    <=> ( v18139(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4709,axiom,
    ! [VarCurr] :
      ( v18248(VarCurr)
    <=> ( v18249(VarCurr)
        | v18306(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1524,axiom,
    ! [VarCurr] :
      ( v18306(VarCurr)
    <=> ( v18308(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4708,axiom,
    ! [VarCurr] :
      ( v18308(VarCurr)
    <=> ( v18309(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1523,axiom,
    ! [VarCurr] :
      ( v18309(VarCurr)
    <=> ( v18134(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4707,axiom,
    ! [VarCurr] :
      ( v18249(VarCurr)
    <=> ( v18250(VarCurr)
        | v18303(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1522,axiom,
    ! [VarCurr] :
      ( v18303(VarCurr)
    <=> ( v18305(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4706,axiom,
    ! [VarCurr] :
      ( v18305(VarCurr)
    <=> ( v17021(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4705,axiom,
    ! [VarCurr] :
      ( v18250(VarCurr)
    <=> ( v18251(VarCurr)
        | v18300(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1521,axiom,
    ! [VarCurr] :
      ( v18300(VarCurr)
    <=> ( v18302(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4704,axiom,
    ! [VarCurr] :
      ( v18302(VarCurr)
    <=> ( v17013(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4703,axiom,
    ! [VarCurr] :
      ( v18251(VarCurr)
    <=> ( v18252(VarCurr)
        | v18297(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1520,axiom,
    ! [VarCurr] :
      ( v18297(VarCurr)
    <=> ( v18299(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4702,axiom,
    ! [VarCurr] :
      ( v18299(VarCurr)
    <=> ( v17005(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4701,axiom,
    ! [VarCurr] :
      ( v18252(VarCurr)
    <=> ( v18253(VarCurr)
        | v18294(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1519,axiom,
    ! [VarCurr] :
      ( v18294(VarCurr)
    <=> ( v18296(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4700,axiom,
    ! [VarCurr] :
      ( v18296(VarCurr)
    <=> ( v16997(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4699,axiom,
    ! [VarCurr] :
      ( v18253(VarCurr)
    <=> ( v18254(VarCurr)
        | v18287(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1518,axiom,
    ! [VarCurr] :
      ( v18287(VarCurr)
    <=> ( v18289(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4698,axiom,
    ! [VarCurr] :
      ( v18289(VarCurr)
    <=> ( v18290(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1517,axiom,
    ! [VarCurr] :
      ( v18290(VarCurr)
    <=> ( v18291(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4697,axiom,
    ! [VarCurr] :
      ( v18291(VarCurr)
    <=> ( v18292(VarCurr)
        & v12810(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1516,axiom,
    ! [VarCurr] :
      ( v18292(VarCurr)
    <=> ( v18293(VarCurr)
        & v13075(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4696,axiom,
    ! [VarCurr] :
      ( v18293(VarCurr)
    <=> ( v14097(VarCurr)
        & v14036(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4695,axiom,
    ! [VarCurr] :
      ( v18254(VarCurr)
    <=> ( v18255(VarCurr)
        | v18280(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1515,axiom,
    ! [VarCurr] :
      ( v18280(VarCurr)
    <=> ( v18282(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4694,axiom,
    ! [VarCurr] :
      ( v18282(VarCurr)
    <=> ( v18283(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1514,axiom,
    ! [VarCurr] :
      ( v18283(VarCurr)
    <=> ( v18284(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4693,axiom,
    ! [VarCurr] :
      ( v18284(VarCurr)
    <=> ( v18285(VarCurr)
        & v12810(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1513,axiom,
    ! [VarCurr] :
      ( v18285(VarCurr)
    <=> ( v18286(VarCurr)
        & v13075(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4692,axiom,
    ! [VarCurr] :
      ( v18286(VarCurr)
    <=> ( v14085(VarCurr)
        & v14036(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4691,axiom,
    ! [VarCurr] :
      ( v18255(VarCurr)
    <=> ( v18256(VarCurr)
        | v18276(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1512,axiom,
    ! [VarCurr] :
      ( v18276(VarCurr)
    <=> ( v18278(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4690,axiom,
    ! [VarCurr] :
      ( v18278(VarCurr)
    <=> ( v18279(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1511,axiom,
    ! [VarCurr] :
      ( v18279(VarCurr)
    <=> ( v18116(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4689,axiom,
    ! [VarCurr] :
      ( v18256(VarCurr)
    <=> ( v18257(VarCurr)
        | v18272(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1510,axiom,
    ! [VarCurr] :
      ( v18272(VarCurr)
    <=> ( v18274(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4688,axiom,
    ! [VarCurr] :
      ( v18274(VarCurr)
    <=> ( v18275(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1509,axiom,
    ! [VarCurr] :
      ( v18275(VarCurr)
    <=> ( v18111(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4687,axiom,
    ! [VarCurr] :
      ( v18257(VarCurr)
    <=> ( v18258(VarCurr)
        | v18269(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1508,axiom,
    ! [VarCurr] :
      ( v18269(VarCurr)
    <=> ( v18271(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4686,axiom,
    ! [VarCurr] :
      ( v18271(VarCurr)
    <=> ( v16989(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4685,axiom,
    ! [VarCurr] :
      ( v18258(VarCurr)
    <=> ( v18259(VarCurr)
        | v18266(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1507,axiom,
    ! [VarCurr] :
      ( v18266(VarCurr)
    <=> ( v18268(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4684,axiom,
    ! [VarCurr] :
      ( v18268(VarCurr)
    <=> ( v16981(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4683,axiom,
    ! [VarCurr] :
      ( v18259(VarCurr)
    <=> ( v18260(VarCurr)
        | v18263(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1506,axiom,
    ! [VarCurr] :
      ( v18263(VarCurr)
    <=> ( v18265(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4682,axiom,
    ! [VarCurr] :
      ( v18265(VarCurr)
    <=> ( v16973(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1505,axiom,
    ! [VarCurr] :
      ( v18260(VarCurr)
    <=> ( v18262(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4681,axiom,
    ! [VarCurr] :
      ( v18262(VarCurr)
    <=> ( v16965(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4680,axiom,
    ! [VarCurr] :
      ( v18202(VarCurr)
    <=> ( v18204(VarCurr)
        | v18244(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1504,axiom,
    ! [VarCurr] :
      ( v18244(VarCurr)
    <=> ( v18224(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4679,axiom,
    ! [VarCurr] :
      ( v18204(VarCurr)
    <=> ( v18205(VarCurr)
        | v18242(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1503,axiom,
    ! [VarCurr] :
      ( v18242(VarCurr)
    <=> ( v18220(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4678,axiom,
    ! [VarCurr] :
      ( v18205(VarCurr)
    <=> ( v18206(VarCurr)
        | v18240(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1502,axiom,
    ! [VarCurr] :
      ( v18240(VarCurr)
    <=> ( v18215(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4677,axiom,
    ! [VarCurr] :
      ( v18206(VarCurr)
    <=> ( v18207(VarCurr)
        | v18238(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1501,axiom,
    ! [VarCurr] :
      ( v18238(VarCurr)
    <=> ( v18197(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4676,axiom,
    ! [VarCurr] :
      ( v18207(VarCurr)
    <=> ( v18208(VarCurr)
        | v18235(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4675,axiom,
    ! [VarCurr] :
      ( v18235(VarCurr)
    <=> ( v18237(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1500,axiom,
    ! [VarCurr] :
      ( v18237(VarCurr)
    <=> ( v18225(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4674,axiom,
    ! [VarCurr] :
      ( v18208(VarCurr)
    <=> ( v18209(VarCurr)
        | v18232(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4673,axiom,
    ! [VarCurr] :
      ( v18232(VarCurr)
    <=> ( v18234(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1499,axiom,
    ! [VarCurr] :
      ( v18234(VarCurr)
    <=> ( v18221(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4672,axiom,
    ! [VarCurr] :
      ( v18209(VarCurr)
    <=> ( v18210(VarCurr)
        | v18229(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4671,axiom,
    ! [VarCurr] :
      ( v18229(VarCurr)
    <=> ( v18231(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1498,axiom,
    ! [VarCurr] :
      ( v18231(VarCurr)
    <=> ( v18216(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4670,axiom,
    ! [VarCurr] :
      ( v18210(VarCurr)
    <=> ( v18211(VarCurr)
        | v18226(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4669,axiom,
    ! [VarCurr] :
      ( v18226(VarCurr)
    <=> ( v18228(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1497,axiom,
    ! [VarCurr] :
      ( v18228(VarCurr)
    <=> ( v18198(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4668,axiom,
    ! [VarCurr] :
      ( v18211(VarCurr)
    <=> ( v18212(VarCurr)
        | v18222(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4667,axiom,
    ! [VarCurr] :
      ( v18222(VarCurr)
    <=> ( v18224(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4666,axiom,
    ! [VarCurr] :
      ( v18224(VarCurr)
    <=> ( v18225(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1496,axiom,
    ! [VarCurr] :
      ( v18225(VarCurr)
    <=> ( v18217(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4665,axiom,
    ! [VarCurr] :
      ( v18212(VarCurr)
    <=> ( v18213(VarCurr)
        | v18218(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4664,axiom,
    ! [VarCurr] :
      ( v18218(VarCurr)
    <=> ( v18220(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4663,axiom,
    ! [VarCurr] :
      ( v18220(VarCurr)
    <=> ( v18221(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1495,axiom,
    ! [VarCurr] :
      ( v18221(VarCurr)
    <=> ( v18199(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4662,axiom,
    ! [VarCurr] :
      ( v18213(VarCurr)
    <=> ( v18215(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4661,axiom,
    ! [VarCurr] :
      ( v18215(VarCurr)
    <=> ( v18216(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4660,axiom,
    ! [VarCurr] :
      ( v18216(VarCurr)
    <=> ( v18217(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4659,axiom,
    ! [VarCurr] :
      ( v18217(VarCurr)
    <=> ( v18200(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4658,axiom,
    ! [VarCurr] :
      ( v18195(VarCurr)
    <=> ( v18197(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4657,axiom,
    ! [VarCurr] :
      ( v18197(VarCurr)
    <=> ( v18198(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4656,axiom,
    ! [VarCurr] :
      ( v18198(VarCurr)
    <=> ( v18199(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4655,axiom,
    ! [VarCurr] :
      ( v18199(VarCurr)
    <=> ( v18200(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1494,axiom,
    ! [VarCurr] :
      ( v18200(VarCurr)
    <=> ( v18201(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4654,axiom,
    ! [VarCurr] :
      ( v18201(VarCurr)
    <=> ( v16431(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4653,axiom,
    ! [VarCurr] :
      ( v18143(VarCurr)
    <=> ( v18145(VarCurr)
        | v18191(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1493,axiom,
    ! [VarCurr] :
      ( v18191(VarCurr)
    <=> ( v18193(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4652,axiom,
    ! [VarCurr] :
      ( v18193(VarCurr)
    <=> ( v18194(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1492,axiom,
    ! [VarCurr] :
      ( v18194(VarCurr)
    <=> ( v18014(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4651,axiom,
    ! [VarCurr] :
      ( v18145(VarCurr)
    <=> ( v18146(VarCurr)
        | v18187(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1491,axiom,
    ! [VarCurr] :
      ( v18187(VarCurr)
    <=> ( v18189(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4650,axiom,
    ! [VarCurr] :
      ( v18189(VarCurr)
    <=> ( v18190(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1490,axiom,
    ! [VarCurr] :
      ( v18190(VarCurr)
    <=> ( v18003(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4649,axiom,
    ! [VarCurr] :
      ( v18146(VarCurr)
    <=> ( v18147(VarCurr)
        | v18184(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1489,axiom,
    ! [VarCurr] :
      ( v18184(VarCurr)
    <=> ( v18186(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4648,axiom,
    ! [VarCurr] :
      ( v18186(VarCurr)
    <=> ( v16093(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4647,axiom,
    ! [VarCurr] :
      ( v18147(VarCurr)
    <=> ( v18148(VarCurr)
        | v18181(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1488,axiom,
    ! [VarCurr] :
      ( v18181(VarCurr)
    <=> ( v18183(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4646,axiom,
    ! [VarCurr] :
      ( v18183(VarCurr)
    <=> ( v16085(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4645,axiom,
    ! [VarCurr] :
      ( v18148(VarCurr)
    <=> ( v18149(VarCurr)
        | v18178(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1487,axiom,
    ! [VarCurr] :
      ( v18178(VarCurr)
    <=> ( v18180(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4644,axiom,
    ! [VarCurr] :
      ( v18180(VarCurr)
    <=> ( v16076(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4643,axiom,
    ! [VarCurr] :
      ( v18149(VarCurr)
    <=> ( v18150(VarCurr)
        | v18175(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1486,axiom,
    ! [VarCurr] :
      ( v18175(VarCurr)
    <=> ( v18177(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4642,axiom,
    ! [VarCurr] :
      ( v18177(VarCurr)
    <=> ( v16068(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4641,axiom,
    ! [VarCurr] :
      ( v18150(VarCurr)
    <=> ( v18151(VarCurr)
        | v18171(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1485,axiom,
    ! [VarCurr] :
      ( v18171(VarCurr)
    <=> ( v18173(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4640,axiom,
    ! [VarCurr] :
      ( v18173(VarCurr)
    <=> ( v18174(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1484,axiom,
    ! [VarCurr] :
      ( v18174(VarCurr)
    <=> ( v17979(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4639,axiom,
    ! [VarCurr] :
      ( v18151(VarCurr)
    <=> ( v18152(VarCurr)
        | v18167(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1483,axiom,
    ! [VarCurr] :
      ( v18167(VarCurr)
    <=> ( v18169(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4638,axiom,
    ! [VarCurr] :
      ( v18169(VarCurr)
    <=> ( v18170(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1482,axiom,
    ! [VarCurr] :
      ( v18170(VarCurr)
    <=> ( v17972(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4637,axiom,
    ! [VarCurr] :
      ( v18152(VarCurr)
    <=> ( v18153(VarCurr)
        | v18164(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1481,axiom,
    ! [VarCurr] :
      ( v18164(VarCurr)
    <=> ( v18166(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4636,axiom,
    ! [VarCurr] :
      ( v18166(VarCurr)
    <=> ( v16052(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4635,axiom,
    ! [VarCurr] :
      ( v18153(VarCurr)
    <=> ( v18154(VarCurr)
        | v18161(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1480,axiom,
    ! [VarCurr] :
      ( v18161(VarCurr)
    <=> ( v18163(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4634,axiom,
    ! [VarCurr] :
      ( v18163(VarCurr)
    <=> ( v16044(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4633,axiom,
    ! [VarCurr] :
      ( v18154(VarCurr)
    <=> ( v18155(VarCurr)
        | v18158(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1479,axiom,
    ! [VarCurr] :
      ( v18158(VarCurr)
    <=> ( v18160(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4632,axiom,
    ! [VarCurr] :
      ( v18160(VarCurr)
    <=> ( v16036(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1478,axiom,
    ! [VarCurr] :
      ( v18155(VarCurr)
    <=> ( v18157(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4631,axiom,
    ! [VarCurr] :
      ( v18157(VarCurr)
    <=> ( v16028(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1477,axiom,
    ! [VarCurr] :
      ( v18140(VarCurr)
    <=> ( v18142(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4630,axiom,
    ! [VarCurr] :
      ( v18142(VarCurr)
    <=> ( v15598(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4629,axiom,
    ! [VarCurr] :
      ( v18129(VarCurr)
    <=> ( v18130(VarCurr)
        | v18135(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1476,axiom,
    ! [VarCurr] :
      ( v18135(VarCurr)
    <=> ( v18137(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4628,axiom,
    ! [VarCurr] :
      ( v18137(VarCurr)
    <=> ( v18138(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4627,axiom,
    ! [VarCurr] :
      ( v18138(VarCurr)
    <=> ( v18139(VarCurr)
        & v14056(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4626,axiom,
    ! [VarCurr] :
      ( v18139(VarCurr)
    <=> ( v18015(VarCurr)
        & v12810(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1475,axiom,
    ! [VarCurr] :
      ( v18130(VarCurr)
    <=> ( v18132(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4625,axiom,
    ! [VarCurr] :
      ( v18132(VarCurr)
    <=> ( v18133(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4624,axiom,
    ! [VarCurr] :
      ( v18133(VarCurr)
    <=> ( v18134(VarCurr)
        & v14056(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4623,axiom,
    ! [VarCurr] :
      ( v18134(VarCurr)
    <=> ( v18004(VarCurr)
        & v12810(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4622,axiom,
    ! [VarCurr] :
      ( v18085(VarCurr)
    <=> ( v18087(VarCurr)
        | v18126(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1474,axiom,
    ! [VarCurr] :
      ( v18126(VarCurr)
    <=> ( v18128(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4621,axiom,
    ! [VarCurr] :
      ( v18128(VarCurr)
    <=> ( v15153(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4620,axiom,
    ! [VarCurr] :
      ( v18087(VarCurr)
    <=> ( v18088(VarCurr)
        | v18123(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1473,axiom,
    ! [VarCurr] :
      ( v18123(VarCurr)
    <=> ( v18125(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4619,axiom,
    ! [VarCurr] :
      ( v18125(VarCurr)
    <=> ( v15140(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4618,axiom,
    ! [VarCurr] :
      ( v18088(VarCurr)
    <=> ( v18089(VarCurr)
        | v18120(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1472,axiom,
    ! [VarCurr] :
      ( v18120(VarCurr)
    <=> ( v18122(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4617,axiom,
    ! [VarCurr] :
      ( v18122(VarCurr)
    <=> ( v15126(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4616,axiom,
    ! [VarCurr] :
      ( v18089(VarCurr)
    <=> ( v18090(VarCurr)
        | v18117(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1471,axiom,
    ! [VarCurr] :
      ( v18117(VarCurr)
    <=> ( v18119(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4615,axiom,
    ! [VarCurr] :
      ( v18119(VarCurr)
    <=> ( v15117(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4614,axiom,
    ! [VarCurr] :
      ( v18090(VarCurr)
    <=> ( v18091(VarCurr)
        | v18112(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1470,axiom,
    ! [VarCurr] :
      ( v18112(VarCurr)
    <=> ( v18114(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4613,axiom,
    ! [VarCurr] :
      ( v18114(VarCurr)
    <=> ( v18115(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4612,axiom,
    ! [VarCurr] :
      ( v18115(VarCurr)
    <=> ( v18116(VarCurr)
        & v14056(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4611,axiom,
    ! [VarCurr] :
      ( v18116(VarCurr)
    <=> ( v17980(VarCurr)
        & v12810(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4610,axiom,
    ! [VarCurr] :
      ( v18091(VarCurr)
    <=> ( v18092(VarCurr)
        | v18107(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1469,axiom,
    ! [VarCurr] :
      ( v18107(VarCurr)
    <=> ( v18109(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4609,axiom,
    ! [VarCurr] :
      ( v18109(VarCurr)
    <=> ( v18110(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4608,axiom,
    ! [VarCurr] :
      ( v18110(VarCurr)
    <=> ( v18111(VarCurr)
        & v14056(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4607,axiom,
    ! [VarCurr] :
      ( v18111(VarCurr)
    <=> ( v17973(VarCurr)
        & v12810(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4606,axiom,
    ! [VarCurr] :
      ( v18092(VarCurr)
    <=> ( v18093(VarCurr)
        | v18104(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1468,axiom,
    ! [VarCurr] :
      ( v18104(VarCurr)
    <=> ( v18106(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4605,axiom,
    ! [VarCurr] :
      ( v18106(VarCurr)
    <=> ( v15108(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4604,axiom,
    ! [VarCurr] :
      ( v18093(VarCurr)
    <=> ( v18094(VarCurr)
        | v18101(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1467,axiom,
    ! [VarCurr] :
      ( v18101(VarCurr)
    <=> ( v18103(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4603,axiom,
    ! [VarCurr] :
      ( v18103(VarCurr)
    <=> ( v15099(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4602,axiom,
    ! [VarCurr] :
      ( v18094(VarCurr)
    <=> ( v18095(VarCurr)
        | v18098(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1466,axiom,
    ! [VarCurr] :
      ( v18098(VarCurr)
    <=> ( v18100(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4601,axiom,
    ! [VarCurr] :
      ( v18100(VarCurr)
    <=> ( v15090(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1465,axiom,
    ! [VarCurr] :
      ( v18095(VarCurr)
    <=> ( v18097(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4600,axiom,
    ! [VarCurr] :
      ( v18097(VarCurr)
    <=> ( v15081(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4599,axiom,
    ! [VarCurr] :
      ( v18049(VarCurr)
    <=> ( v18051(VarCurr)
        | v18082(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1464,axiom,
    ! [VarCurr] :
      ( v18082(VarCurr)
    <=> ( v18084(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4598,axiom,
    ! [VarCurr] :
      ( v18084(VarCurr)
    <=> ( v18072(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4597,axiom,
    ! [VarCurr] :
      ( v18051(VarCurr)
    <=> ( v18052(VarCurr)
        | v18079(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1463,axiom,
    ! [VarCurr] :
      ( v18079(VarCurr)
    <=> ( v18081(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4596,axiom,
    ! [VarCurr] :
      ( v18081(VarCurr)
    <=> ( v18068(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4595,axiom,
    ! [VarCurr] :
      ( v18052(VarCurr)
    <=> ( v18053(VarCurr)
        | v18076(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1462,axiom,
    ! [VarCurr] :
      ( v18076(VarCurr)
    <=> ( v18078(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4594,axiom,
    ! [VarCurr] :
      ( v18078(VarCurr)
    <=> ( v18064(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4593,axiom,
    ! [VarCurr] :
      ( v18053(VarCurr)
    <=> ( v18054(VarCurr)
        | v18073(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1461,axiom,
    ! [VarCurr] :
      ( v18073(VarCurr)
    <=> ( v18075(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4592,axiom,
    ! [VarCurr] :
      ( v18075(VarCurr)
    <=> ( v18060(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4591,axiom,
    ! [VarCurr] :
      ( v18054(VarCurr)
    <=> ( v18055(VarCurr)
        | v18069(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4590,axiom,
    ! [VarCurr] :
      ( v18069(VarCurr)
    <=> ( v18071(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1460,axiom,
    ! [VarCurr] :
      ( v18071(VarCurr)
    <=> ( v18072(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1459,axiom,
    ! [VarCurr] :
      ( v18072(VarCurr)
    <=> ( v18011(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4589,axiom,
    ! [VarCurr] :
      ( v18055(VarCurr)
    <=> ( v18056(VarCurr)
        | v18065(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4588,axiom,
    ! [VarCurr] :
      ( v18065(VarCurr)
    <=> ( v18067(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1458,axiom,
    ! [VarCurr] :
      ( v18067(VarCurr)
    <=> ( v18068(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1457,axiom,
    ! [VarCurr] :
      ( v18068(VarCurr)
    <=> ( v18000(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4587,axiom,
    ! [VarCurr] :
      ( v18056(VarCurr)
    <=> ( v18057(VarCurr)
        | v18061(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4586,axiom,
    ! [VarCurr] :
      ( v18061(VarCurr)
    <=> ( v18063(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1456,axiom,
    ! [VarCurr] :
      ( v18063(VarCurr)
    <=> ( v18064(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4585,axiom,
    ! [VarCurr] :
      ( v18064(VarCurr)
    <=> ( v18011(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4584,axiom,
    ! [VarCurr] :
      ( v18057(VarCurr)
    <=> ( v18059(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1455,axiom,
    ! [VarCurr] :
      ( v18059(VarCurr)
    <=> ( v18060(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4583,axiom,
    ! [VarCurr] :
      ( v18060(VarCurr)
    <=> ( v18000(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4582,axiom,
    ! [VarCurr] :
      ( v18017(VarCurr)
    <=> ( v18019(VarCurr)
        | v18045(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4581,axiom,
    ! [VarCurr] :
      ( v18045(VarCurr)
    <=> ( v18047(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4580,axiom,
    ! [VarCurr] :
      ( v18047(VarCurr)
    <=> ( v18048(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1454,axiom,
    ! [VarCurr] :
      ( v18048(VarCurr)
    <=> ( v18032(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4579,axiom,
    ! [VarCurr] :
      ( v18019(VarCurr)
    <=> ( v18020(VarCurr)
        | v18041(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4578,axiom,
    ! [VarCurr] :
      ( v18041(VarCurr)
    <=> ( v18043(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4577,axiom,
    ! [VarCurr] :
      ( v18043(VarCurr)
    <=> ( v18044(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1453,axiom,
    ! [VarCurr] :
      ( v18044(VarCurr)
    <=> ( v18027(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4576,axiom,
    ! [VarCurr] :
      ( v18020(VarCurr)
    <=> ( v18021(VarCurr)
        | v18037(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4575,axiom,
    ! [VarCurr] :
      ( v18037(VarCurr)
    <=> ( v18039(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4574,axiom,
    ! [VarCurr] :
      ( v18039(VarCurr)
    <=> ( v18040(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1452,axiom,
    ! [VarCurr] :
      ( v18040(VarCurr)
    <=> ( v18010(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4573,axiom,
    ! [VarCurr] :
      ( v18021(VarCurr)
    <=> ( v18022(VarCurr)
        | v18033(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4572,axiom,
    ! [VarCurr] :
      ( v18033(VarCurr)
    <=> ( v18035(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4571,axiom,
    ! [VarCurr] :
      ( v18035(VarCurr)
    <=> ( v18036(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1451,axiom,
    ! [VarCurr] :
      ( v18036(VarCurr)
    <=> ( v17999(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4570,axiom,
    ! [VarCurr] :
      ( v18022(VarCurr)
    <=> ( v18023(VarCurr)
        | v18028(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4569,axiom,
    ! [VarCurr] :
      ( v18028(VarCurr)
    <=> ( v18030(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4568,axiom,
    ! [VarCurr] :
      ( v18030(VarCurr)
    <=> ( v18031(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4567,axiom,
    ! [VarCurr] :
      ( v18031(VarCurr)
    <=> ( v18032(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4566,axiom,
    ! [VarCurr] :
      ( v18032(VarCurr)
    <=> ( v18011(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4565,axiom,
    ! [VarCurr] :
      ( v18023(VarCurr)
    <=> ( v18025(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4564,axiom,
    ! [VarCurr] :
      ( v18025(VarCurr)
    <=> ( v18026(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4563,axiom,
    ! [VarCurr] :
      ( v18026(VarCurr)
    <=> ( v18027(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4562,axiom,
    ! [VarCurr] :
      ( v18027(VarCurr)
    <=> ( v18000(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4561,axiom,
    ! [VarCurr] :
      ( v17994(VarCurr)
    <=> ( v17995(VarCurr)
        | v18006(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4560,axiom,
    ! [VarCurr] :
      ( v18006(VarCurr)
    <=> ( v18008(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4559,axiom,
    ! [VarCurr] :
      ( v18008(VarCurr)
    <=> ( v18009(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4558,axiom,
    ! [VarCurr] :
      ( v18009(VarCurr)
    <=> ( v18010(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4557,axiom,
    ! [VarCurr] :
      ( v18010(VarCurr)
    <=> ( v18011(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1450,axiom,
    ! [VarCurr] :
      ( v18011(VarCurr)
    <=> ( v18012(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4556,axiom,
    ! [VarCurr] :
      ( v18012(VarCurr)
    <=> ( v18013(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4555,axiom,
    ! [VarCurr] :
      ( v18013(VarCurr)
    <=> ( v18014(VarCurr)
        & v14056(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4554,axiom,
    ! [VarCurr] :
      ( v18014(VarCurr)
    <=> ( v18015(VarCurr)
        & v14055(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4553,axiom,
    ! [VarCurr] :
      ( v18015(VarCurr)
    <=> ( v18016(VarCurr)
        & v14037(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1449,axiom,
    ! [VarCurr] :
      ( v18016(VarCurr)
    <=> ( v14124(VarCurr)
        & v13075(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4552,axiom,
    ! [VarCurr] :
      ( v17995(VarCurr)
    <=> ( v17997(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4551,axiom,
    ! [VarCurr] :
      ( v17997(VarCurr)
    <=> ( v17998(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4550,axiom,
    ! [VarCurr] :
      ( v17998(VarCurr)
    <=> ( v17999(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4549,axiom,
    ! [VarCurr] :
      ( v17999(VarCurr)
    <=> ( v18000(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1448,axiom,
    ! [VarCurr] :
      ( v18000(VarCurr)
    <=> ( v18001(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4548,axiom,
    ! [VarCurr] :
      ( v18001(VarCurr)
    <=> ( v18002(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4547,axiom,
    ! [VarCurr] :
      ( v18002(VarCurr)
    <=> ( v18003(VarCurr)
        & v14056(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4546,axiom,
    ! [VarCurr] :
      ( v18003(VarCurr)
    <=> ( v18004(VarCurr)
        & v14055(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4545,axiom,
    ! [VarCurr] :
      ( v18004(VarCurr)
    <=> ( v18005(VarCurr)
        & v14037(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1447,axiom,
    ! [VarCurr] :
      ( v18005(VarCurr)
    <=> ( v14109(VarCurr)
        & v13075(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4544,axiom,
    ! [VarCurr] :
      ( v17942(VarCurr)
    <=> ( v17944(VarCurr)
        | v17991(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1446,axiom,
    ! [VarCurr] :
      ( v17991(VarCurr)
    <=> ( v17993(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4543,axiom,
    ! [VarCurr] :
      ( v17993(VarCurr)
    <=> ( v14160(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4542,axiom,
    ! [VarCurr] :
      ( v17944(VarCurr)
    <=> ( v17945(VarCurr)
        | v17988(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1445,axiom,
    ! [VarCurr] :
      ( v17988(VarCurr)
    <=> ( v17990(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4541,axiom,
    ! [VarCurr] :
      ( v17990(VarCurr)
    <=> ( v14140(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4540,axiom,
    ! [VarCurr] :
      ( v17945(VarCurr)
    <=> ( v17946(VarCurr)
        | v17985(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1444,axiom,
    ! [VarCurr] :
      ( v17985(VarCurr)
    <=> ( v17987(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4539,axiom,
    ! [VarCurr] :
      ( v17987(VarCurr)
    <=> ( v14120(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4538,axiom,
    ! [VarCurr] :
      ( v17946(VarCurr)
    <=> ( v17947(VarCurr)
        | v17982(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1443,axiom,
    ! [VarCurr] :
      ( v17982(VarCurr)
    <=> ( v17984(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4537,axiom,
    ! [VarCurr] :
      ( v17984(VarCurr)
    <=> ( v14105(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4536,axiom,
    ! [VarCurr] :
      ( v17947(VarCurr)
    <=> ( v17948(VarCurr)
        | v17975(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1442,axiom,
    ! [VarCurr] :
      ( v17975(VarCurr)
    <=> ( v17977(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4535,axiom,
    ! [VarCurr] :
      ( v17977(VarCurr)
    <=> ( v17978(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4534,axiom,
    ! [VarCurr] :
      ( v17978(VarCurr)
    <=> ( v17979(VarCurr)
        & v14056(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4533,axiom,
    ! [VarCurr] :
      ( v17979(VarCurr)
    <=> ( v17980(VarCurr)
        & v14055(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4532,axiom,
    ! [VarCurr] :
      ( v17980(VarCurr)
    <=> ( v17981(VarCurr)
        & v14037(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1441,axiom,
    ! [VarCurr] :
      ( v17981(VarCurr)
    <=> ( v14068(VarCurr)
        & v13075(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4531,axiom,
    ! [VarCurr] :
      ( v17948(VarCurr)
    <=> ( v17949(VarCurr)
        | v17968(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1440,axiom,
    ! [VarCurr] :
      ( v17968(VarCurr)
    <=> ( v17970(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4530,axiom,
    ! [VarCurr] :
      ( v17970(VarCurr)
    <=> ( v17971(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4529,axiom,
    ! [VarCurr] :
      ( v17971(VarCurr)
    <=> ( v17972(VarCurr)
        & v14056(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4528,axiom,
    ! [VarCurr] :
      ( v17972(VarCurr)
    <=> ( v17973(VarCurr)
        & v14055(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4527,axiom,
    ! [VarCurr] :
      ( v17973(VarCurr)
    <=> ( v17974(VarCurr)
        & v14037(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1439,axiom,
    ! [VarCurr] :
      ( v17974(VarCurr)
    <=> ( v14049(VarCurr)
        & v13075(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4526,axiom,
    ! [VarCurr] :
      ( v17949(VarCurr)
    <=> ( v17950(VarCurr)
        | v17965(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1438,axiom,
    ! [VarCurr] :
      ( v17965(VarCurr)
    <=> ( v17967(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4525,axiom,
    ! [VarCurr] :
      ( v17967(VarCurr)
    <=> ( v14093(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4524,axiom,
    ! [VarCurr] :
      ( v17950(VarCurr)
    <=> ( v17951(VarCurr)
        | v17962(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1437,axiom,
    ! [VarCurr] :
      ( v17962(VarCurr)
    <=> ( v17964(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4523,axiom,
    ! [VarCurr] :
      ( v17964(VarCurr)
    <=> ( v14081(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4522,axiom,
    ! [VarCurr] :
      ( v17951(VarCurr)
    <=> ( v17952(VarCurr)
        | v17959(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1436,axiom,
    ! [VarCurr] :
      ( v17959(VarCurr)
    <=> ( v17961(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4521,axiom,
    ! [VarCurr] :
      ( v17961(VarCurr)
    <=> ( v14064(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4520,axiom,
    ! [VarCurr] :
      ( v17952(VarCurr)
    <=> ( v17953(VarCurr)
        | v17956(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1435,axiom,
    ! [VarCurr] :
      ( v17956(VarCurr)
    <=> ( v17958(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4519,axiom,
    ! [VarCurr] :
      ( v17958(VarCurr)
    <=> ( v14045(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1434,axiom,
    ! [VarCurr] :
      ( v17953(VarCurr)
    <=> ( v17955(VarCurr)
        & v12810(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4518,axiom,
    ! [VarCurr] :
      ( v17955(VarCurr)
    <=> ( v14030(VarCurr)
        & v14019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4517,axiom,
    ! [VarCurr] :
      ( v17924(VarCurr)
    <=> ( v17926(VarCurr)
        | v17939(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1433,axiom,
    ! [VarCurr] :
      ( v17939(VarCurr)
    <=> ( v17941(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4516,axiom,
    ! [VarCurr] :
      ( v17941(VarCurr)
    <=> ( v17935(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4515,axiom,
    ! [VarCurr] :
      ( v17926(VarCurr)
    <=> ( v17927(VarCurr)
        | v17936(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1432,axiom,
    ! [VarCurr] :
      ( v17936(VarCurr)
    <=> ( v17938(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4514,axiom,
    ! [VarCurr] :
      ( v17938(VarCurr)
    <=> ( v17931(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4513,axiom,
    ! [VarCurr] :
      ( v17927(VarCurr)
    <=> ( v17928(VarCurr)
        | v17932(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4512,axiom,
    ! [VarCurr] :
      ( v17932(VarCurr)
    <=> ( v17934(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1431,axiom,
    ! [VarCurr] :
      ( v17934(VarCurr)
    <=> ( v17935(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1430,axiom,
    ! [VarCurr] :
      ( v17935(VarCurr)
    <=> ( v17905(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4511,axiom,
    ! [VarCurr] :
      ( v17928(VarCurr)
    <=> ( v17930(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1429,axiom,
    ! [VarCurr] :
      ( v17930(VarCurr)
    <=> ( v17931(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4510,axiom,
    ! [VarCurr] :
      ( v17931(VarCurr)
    <=> ( v17905(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4509,axiom,
    ! [VarCurr] :
      ( v17908(VarCurr)
    <=> ( v17910(VarCurr)
        | v17920(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4508,axiom,
    ! [VarCurr] :
      ( v17920(VarCurr)
    <=> ( v17922(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4507,axiom,
    ! [VarCurr] :
      ( v17922(VarCurr)
    <=> ( v17923(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1428,axiom,
    ! [VarCurr] :
      ( v17923(VarCurr)
    <=> ( v17915(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4506,axiom,
    ! [VarCurr] :
      ( v17910(VarCurr)
    <=> ( v17911(VarCurr)
        | v17916(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4505,axiom,
    ! [VarCurr] :
      ( v17916(VarCurr)
    <=> ( v17918(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4504,axiom,
    ! [VarCurr] :
      ( v17918(VarCurr)
    <=> ( v17919(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1427,axiom,
    ! [VarCurr] :
      ( v17919(VarCurr)
    <=> ( v17904(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4503,axiom,
    ! [VarCurr] :
      ( v17911(VarCurr)
    <=> ( v17913(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4502,axiom,
    ! [VarCurr] :
      ( v17913(VarCurr)
    <=> ( v17914(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4501,axiom,
    ! [VarCurr] :
      ( v17914(VarCurr)
    <=> ( v17915(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4500,axiom,
    ! [VarCurr] :
      ( v17915(VarCurr)
    <=> ( v17905(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4499,axiom,
    ! [VarCurr] :
      ( v17900(VarCurr)
    <=> ( v17902(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4498,axiom,
    ! [VarCurr] :
      ( v17902(VarCurr)
    <=> ( v17903(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4497,axiom,
    ! [VarCurr] :
      ( v17903(VarCurr)
    <=> ( v17904(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4496,axiom,
    ! [VarCurr] :
      ( v17904(VarCurr)
    <=> ( v17905(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1426,axiom,
    ! [VarCurr] :
      ( v17905(VarCurr)
    <=> ( v17906(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1425,axiom,
    ! [VarCurr] :
      ( v17906(VarCurr)
    <=> ( v17907(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1424,axiom,
    ! [VarCurr] :
      ( v17907(VarCurr)
    <=> ( v17714(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4495,axiom,
    ! [VarCurr] :
      ( v17856(VarCurr)
    <=> ( v17858(VarCurr)
        | v17897(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1423,axiom,
    ! [VarCurr] :
      ( v17897(VarCurr)
    <=> ( v17899(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1422,axiom,
    ! [VarCurr] :
      ( v17899(VarCurr)
    <=> ( v17575(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4494,axiom,
    ! [VarCurr] :
      ( v17858(VarCurr)
    <=> ( v17859(VarCurr)
        | v17895(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1421,axiom,
    ! [VarCurr] :
      ( v17895(VarCurr)
    <=> ( v17237(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4493,axiom,
    ! [VarCurr] :
      ( v17859(VarCurr)
    <=> ( v17860(VarCurr)
        | v17893(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1420,axiom,
    ! [VarCurr] :
      ( v17893(VarCurr)
    <=> ( v17229(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4492,axiom,
    ! [VarCurr] :
      ( v17860(VarCurr)
    <=> ( v17861(VarCurr)
        | v17891(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1419,axiom,
    ! [VarCurr] :
      ( v17891(VarCurr)
    <=> ( v17225(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4491,axiom,
    ! [VarCurr] :
      ( v17861(VarCurr)
    <=> ( v17862(VarCurr)
        | v17889(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1418,axiom,
    ! [VarCurr] :
      ( v17889(VarCurr)
    <=> ( v17221(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4490,axiom,
    ! [VarCurr] :
      ( v17862(VarCurr)
    <=> ( v17863(VarCurr)
        | v17887(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1417,axiom,
    ! [VarCurr] :
      ( v17887(VarCurr)
    <=> ( v17217(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4489,axiom,
    ! [VarCurr] :
      ( v17863(VarCurr)
    <=> ( v17864(VarCurr)
        | v17882(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1416,axiom,
    ! [VarCurr] :
      ( v17882(VarCurr)
    <=> ( v17884(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1415,axiom,
    ! [VarCurr] :
      ( v17884(VarCurr)
    <=> ( v17885(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1414,axiom,
    ! [VarCurr] :
      ( v17885(VarCurr)
    <=> ( v17886(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4488,axiom,
    ! [VarCurr] :
      ( v17886(VarCurr)
    <=> ( v17790(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4487,axiom,
    ! [VarCurr] :
      ( v17864(VarCurr)
    <=> ( v17865(VarCurr)
        | v17879(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1413,axiom,
    ! [VarCurr] :
      ( v17879(VarCurr)
    <=> ( v17881(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1412,axiom,
    ! [VarCurr] :
      ( v17881(VarCurr)
    <=> ( v17551(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4486,axiom,
    ! [VarCurr] :
      ( v17865(VarCurr)
    <=> ( v17866(VarCurr)
        | v17877(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1411,axiom,
    ! [VarCurr] :
      ( v17877(VarCurr)
    <=> ( v17212(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4485,axiom,
    ! [VarCurr] :
      ( v17866(VarCurr)
    <=> ( v17867(VarCurr)
        | v17875(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1410,axiom,
    ! [VarCurr] :
      ( v17875(VarCurr)
    <=> ( v17208(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4484,axiom,
    ! [VarCurr] :
      ( v17867(VarCurr)
    <=> ( v17868(VarCurr)
        | v17873(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1409,axiom,
    ! [VarCurr] :
      ( v17873(VarCurr)
    <=> ( v17204(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4483,axiom,
    ! [VarCurr] :
      ( v17868(VarCurr)
    <=> ( v17869(VarCurr)
        | v17871(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1408,axiom,
    ! [VarCurr] :
      ( v17871(VarCurr)
    <=> ( v17200(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1407,axiom,
    ! [VarCurr] :
      ( v17869(VarCurr)
    <=> ( v17196(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4482,axiom,
    ! [VarCurr] :
      ( v17847(VarCurr)
    <=> ( v17848(VarCurr)
        | v17852(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1406,axiom,
    ! [VarCurr] :
      ( v17852(VarCurr)
    <=> ( v17854(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4481,axiom,
    ! [VarCurr] :
      ( v17854(VarCurr)
    <=> ( v17855(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1405,axiom,
    ! [VarCurr] :
      ( v17855(VarCurr)
    <=> ( v17812(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1404,axiom,
    ! [VarCurr] :
      ( v17848(VarCurr)
    <=> ( v17850(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4480,axiom,
    ! [VarCurr] :
      ( v17850(VarCurr)
    <=> ( v17851(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4479,axiom,
    ! [VarCurr] :
      ( v17851(VarCurr)
    <=> ( v17812(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4478,axiom,
    ! [VarCurr] :
      ( v17815(VarCurr)
    <=> ( v17817(VarCurr)
        | v17844(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4477,axiom,
    ! [VarCurr] :
      ( v17844(VarCurr)
    <=> ( v17846(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1403,axiom,
    ! [VarCurr] :
      ( v17846(VarCurr)
    <=> ( v17834(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4476,axiom,
    ! [VarCurr] :
      ( v17817(VarCurr)
    <=> ( v17818(VarCurr)
        | v17841(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4475,axiom,
    ! [VarCurr] :
      ( v17841(VarCurr)
    <=> ( v17843(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1402,axiom,
    ! [VarCurr] :
      ( v17843(VarCurr)
    <=> ( v17830(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4474,axiom,
    ! [VarCurr] :
      ( v17818(VarCurr)
    <=> ( v17819(VarCurr)
        | v17838(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4473,axiom,
    ! [VarCurr] :
      ( v17838(VarCurr)
    <=> ( v17840(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1401,axiom,
    ! [VarCurr] :
      ( v17840(VarCurr)
    <=> ( v17825(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4472,axiom,
    ! [VarCurr] :
      ( v17819(VarCurr)
    <=> ( v17820(VarCurr)
        | v17835(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4471,axiom,
    ! [VarCurr] :
      ( v17835(VarCurr)
    <=> ( v17837(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1400,axiom,
    ! [VarCurr] :
      ( v17837(VarCurr)
    <=> ( v17810(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4470,axiom,
    ! [VarCurr] :
      ( v17820(VarCurr)
    <=> ( v17821(VarCurr)
        | v17831(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4469,axiom,
    ! [VarCurr] :
      ( v17831(VarCurr)
    <=> ( v17833(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4468,axiom,
    ! [VarCurr] :
      ( v17833(VarCurr)
    <=> ( v17834(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1399,axiom,
    ! [VarCurr] :
      ( v17834(VarCurr)
    <=> ( v17826(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4467,axiom,
    ! [VarCurr] :
      ( v17821(VarCurr)
    <=> ( v17822(VarCurr)
        | v17827(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4466,axiom,
    ! [VarCurr] :
      ( v17827(VarCurr)
    <=> ( v17829(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4465,axiom,
    ! [VarCurr] :
      ( v17829(VarCurr)
    <=> ( v17830(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1398,axiom,
    ! [VarCurr] :
      ( v17830(VarCurr)
    <=> ( v17811(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4464,axiom,
    ! [VarCurr] :
      ( v17822(VarCurr)
    <=> ( v17824(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4463,axiom,
    ! [VarCurr] :
      ( v17824(VarCurr)
    <=> ( v17825(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4462,axiom,
    ! [VarCurr] :
      ( v17825(VarCurr)
    <=> ( v17826(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4461,axiom,
    ! [VarCurr] :
      ( v17826(VarCurr)
    <=> ( v17812(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4460,axiom,
    ! [VarCurr] :
      ( v17807(VarCurr)
    <=> ( v17809(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4459,axiom,
    ! [VarCurr] :
      ( v17809(VarCurr)
    <=> ( v17810(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4458,axiom,
    ! [VarCurr] :
      ( v17810(VarCurr)
    <=> ( v17811(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4457,axiom,
    ! [VarCurr] :
      ( v17811(VarCurr)
    <=> ( v17812(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1397,axiom,
    ! [VarCurr] :
      ( v17812(VarCurr)
    <=> ( v17813(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1396,axiom,
    ! [VarCurr] :
      ( v17813(VarCurr)
    <=> ( v17814(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1395,axiom,
    ! [VarCurr] :
      ( v17814(VarCurr)
    <=> ( v17662(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4456,axiom,
    ! [VarCurr] :
      ( v17759(VarCurr)
    <=> ( v17761(VarCurr)
        | v17804(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1394,axiom,
    ! [VarCurr] :
      ( v17804(VarCurr)
    <=> ( v17806(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1393,axiom,
    ! [VarCurr] :
      ( v17806(VarCurr)
    <=> ( v17480(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4455,axiom,
    ! [VarCurr] :
      ( v17761(VarCurr)
    <=> ( v17762(VarCurr)
        | v17802(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1392,axiom,
    ! [VarCurr] :
      ( v17802(VarCurr)
    <=> ( v17141(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4454,axiom,
    ! [VarCurr] :
      ( v17762(VarCurr)
    <=> ( v17763(VarCurr)
        | v17800(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1391,axiom,
    ! [VarCurr] :
      ( v17800(VarCurr)
    <=> ( v17132(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4453,axiom,
    ! [VarCurr] :
      ( v17763(VarCurr)
    <=> ( v17764(VarCurr)
        | v17798(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1390,axiom,
    ! [VarCurr] :
      ( v17798(VarCurr)
    <=> ( v17127(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4452,axiom,
    ! [VarCurr] :
      ( v17764(VarCurr)
    <=> ( v17765(VarCurr)
        | v17796(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1389,axiom,
    ! [VarCurr] :
      ( v17796(VarCurr)
    <=> ( v17122(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4451,axiom,
    ! [VarCurr] :
      ( v17765(VarCurr)
    <=> ( v17766(VarCurr)
        | v17794(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1388,axiom,
    ! [VarCurr] :
      ( v17794(VarCurr)
    <=> ( v17117(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4450,axiom,
    ! [VarCurr] :
      ( v17766(VarCurr)
    <=> ( v17767(VarCurr)
        | v17785(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1387,axiom,
    ! [VarCurr] :
      ( v17785(VarCurr)
    <=> ( v17787(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1386,axiom,
    ! [VarCurr] :
      ( v17787(VarCurr)
    <=> ( v17788(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1385,axiom,
    ! [VarCurr] :
      ( v17788(VarCurr)
    <=> ( v17789(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4449,axiom,
    ! [VarCurr] :
      ( v17789(VarCurr)
    <=> ( v17790(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4448,axiom,
    ! [VarCurr] :
      ( v17790(VarCurr)
    <=> ( v17791(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1384,axiom,
    ! [VarCurr] :
      ( v17791(VarCurr)
    <=> ( v17792(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1383,axiom,
    ! [VarCurr] :
      ( v17792(VarCurr)
    <=> ( v17793(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4447,axiom,
    ! [VarCurr] :
      ( v17793(VarCurr)
    <=> ( v16886(VarCurr)
        & v12810(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4446,axiom,
    ! [VarCurr] :
      ( v17767(VarCurr)
    <=> ( v17768(VarCurr)
        | v17782(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1382,axiom,
    ! [VarCurr] :
      ( v17782(VarCurr)
    <=> ( v17784(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1381,axiom,
    ! [VarCurr] :
      ( v17784(VarCurr)
    <=> ( v17453(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4445,axiom,
    ! [VarCurr] :
      ( v17768(VarCurr)
    <=> ( v17769(VarCurr)
        | v17780(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1380,axiom,
    ! [VarCurr] :
      ( v17780(VarCurr)
    <=> ( v17109(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4444,axiom,
    ! [VarCurr] :
      ( v17769(VarCurr)
    <=> ( v17770(VarCurr)
        | v17778(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1379,axiom,
    ! [VarCurr] :
      ( v17778(VarCurr)
    <=> ( v17104(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4443,axiom,
    ! [VarCurr] :
      ( v17770(VarCurr)
    <=> ( v17771(VarCurr)
        | v17776(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1378,axiom,
    ! [VarCurr] :
      ( v17776(VarCurr)
    <=> ( v17099(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4442,axiom,
    ! [VarCurr] :
      ( v17771(VarCurr)
    <=> ( v17772(VarCurr)
        | v17774(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1377,axiom,
    ! [VarCurr] :
      ( v17774(VarCurr)
    <=> ( v17094(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1376,axiom,
    ! [VarCurr] :
      ( v17772(VarCurr)
    <=> ( v17089(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4441,axiom,
    ! [VarCurr] :
      ( v17715(VarCurr)
    <=> ( v17717(VarCurr)
        | v17757(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1375,axiom,
    ! [VarCurr] :
      ( v17757(VarCurr)
    <=> ( v17737(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4440,axiom,
    ! [VarCurr] :
      ( v17717(VarCurr)
    <=> ( v17718(VarCurr)
        | v17755(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1374,axiom,
    ! [VarCurr] :
      ( v17755(VarCurr)
    <=> ( v17733(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4439,axiom,
    ! [VarCurr] :
      ( v17718(VarCurr)
    <=> ( v17719(VarCurr)
        | v17753(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1373,axiom,
    ! [VarCurr] :
      ( v17753(VarCurr)
    <=> ( v17728(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4438,axiom,
    ! [VarCurr] :
      ( v17719(VarCurr)
    <=> ( v17720(VarCurr)
        | v17751(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1372,axiom,
    ! [VarCurr] :
      ( v17751(VarCurr)
    <=> ( v17708(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4437,axiom,
    ! [VarCurr] :
      ( v17720(VarCurr)
    <=> ( v17721(VarCurr)
        | v17748(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4436,axiom,
    ! [VarCurr] :
      ( v17748(VarCurr)
    <=> ( v17750(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1371,axiom,
    ! [VarCurr] :
      ( v17750(VarCurr)
    <=> ( v17738(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4435,axiom,
    ! [VarCurr] :
      ( v17721(VarCurr)
    <=> ( v17722(VarCurr)
        | v17745(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4434,axiom,
    ! [VarCurr] :
      ( v17745(VarCurr)
    <=> ( v17747(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1370,axiom,
    ! [VarCurr] :
      ( v17747(VarCurr)
    <=> ( v17734(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4433,axiom,
    ! [VarCurr] :
      ( v17722(VarCurr)
    <=> ( v17723(VarCurr)
        | v17742(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4432,axiom,
    ! [VarCurr] :
      ( v17742(VarCurr)
    <=> ( v17744(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1369,axiom,
    ! [VarCurr] :
      ( v17744(VarCurr)
    <=> ( v17729(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4431,axiom,
    ! [VarCurr] :
      ( v17723(VarCurr)
    <=> ( v17724(VarCurr)
        | v17739(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4430,axiom,
    ! [VarCurr] :
      ( v17739(VarCurr)
    <=> ( v17741(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1368,axiom,
    ! [VarCurr] :
      ( v17741(VarCurr)
    <=> ( v17709(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4429,axiom,
    ! [VarCurr] :
      ( v17724(VarCurr)
    <=> ( v17725(VarCurr)
        | v17735(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4428,axiom,
    ! [VarCurr] :
      ( v17735(VarCurr)
    <=> ( v17737(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4427,axiom,
    ! [VarCurr] :
      ( v17737(VarCurr)
    <=> ( v17738(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1367,axiom,
    ! [VarCurr] :
      ( v17738(VarCurr)
    <=> ( v17730(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4426,axiom,
    ! [VarCurr] :
      ( v17725(VarCurr)
    <=> ( v17726(VarCurr)
        | v17731(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4425,axiom,
    ! [VarCurr] :
      ( v17731(VarCurr)
    <=> ( v17733(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4424,axiom,
    ! [VarCurr] :
      ( v17733(VarCurr)
    <=> ( v17734(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1366,axiom,
    ! [VarCurr] :
      ( v17734(VarCurr)
    <=> ( v17710(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4423,axiom,
    ! [VarCurr] :
      ( v17726(VarCurr)
    <=> ( v17728(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4422,axiom,
    ! [VarCurr] :
      ( v17728(VarCurr)
    <=> ( v17729(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4421,axiom,
    ! [VarCurr] :
      ( v17729(VarCurr)
    <=> ( v17730(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4420,axiom,
    ! [VarCurr] :
      ( v17730(VarCurr)
    <=> ( v17711(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4419,axiom,
    ! [VarCurr] :
      ( v17706(VarCurr)
    <=> ( v17708(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4418,axiom,
    ! [VarCurr] :
      ( v17708(VarCurr)
    <=> ( v17709(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4417,axiom,
    ! [VarCurr] :
      ( v17709(VarCurr)
    <=> ( v17710(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4416,axiom,
    ! [VarCurr] :
      ( v17710(VarCurr)
    <=> ( v17711(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1365,axiom,
    ! [VarCurr] :
      ( v17711(VarCurr)
    <=> ( v17712(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1364,axiom,
    ! [VarCurr] :
      ( v17712(VarCurr)
    <=> ( v17713(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4415,axiom,
    ! [VarCurr] :
      ( v17713(VarCurr)
    <=> ( v17714(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4414,axiom,
    ! [VarCurr] :
      ( v17714(VarCurr)
    <=> ( v17663(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4413,axiom,
    ! [VarCurr] :
      ( v17666(VarCurr)
    <=> ( v17668(VarCurr)
        | v17703(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1363,axiom,
    ! [VarCurr] :
      ( v17703(VarCurr)
    <=> ( v17705(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1362,axiom,
    ! [VarCurr] :
      ( v17705(VarCurr)
    <=> ( v17378(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4412,axiom,
    ! [VarCurr] :
      ( v17668(VarCurr)
    <=> ( v17669(VarCurr)
        | v17701(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1361,axiom,
    ! [VarCurr] :
      ( v17701(VarCurr)
    <=> ( v17028(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4411,axiom,
    ! [VarCurr] :
      ( v17669(VarCurr)
    <=> ( v17670(VarCurr)
        | v17699(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1360,axiom,
    ! [VarCurr] :
      ( v17699(VarCurr)
    <=> ( v17016(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4410,axiom,
    ! [VarCurr] :
      ( v17670(VarCurr)
    <=> ( v17671(VarCurr)
        | v17697(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1359,axiom,
    ! [VarCurr] :
      ( v17697(VarCurr)
    <=> ( v17008(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4409,axiom,
    ! [VarCurr] :
      ( v17671(VarCurr)
    <=> ( v17672(VarCurr)
        | v17695(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1358,axiom,
    ! [VarCurr] :
      ( v17695(VarCurr)
    <=> ( v17000(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4408,axiom,
    ! [VarCurr] :
      ( v17672(VarCurr)
    <=> ( v17673(VarCurr)
        | v17693(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1357,axiom,
    ! [VarCurr] :
      ( v17693(VarCurr)
    <=> ( v16992(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4407,axiom,
    ! [VarCurr] :
      ( v17673(VarCurr)
    <=> ( v17674(VarCurr)
        | v17689(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1356,axiom,
    ! [VarCurr] :
      ( v17689(VarCurr)
    <=> ( v17691(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1355,axiom,
    ! [VarCurr] :
      ( v17691(VarCurr)
    <=> ( v17692(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4406,axiom,
    ! [VarCurr] :
      ( v17692(VarCurr)
    <=> ( v17552(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4405,axiom,
    ! [VarCurr] :
      ( v17674(VarCurr)
    <=> ( v17675(VarCurr)
        | v17686(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1354,axiom,
    ! [VarCurr] :
      ( v17686(VarCurr)
    <=> ( v17688(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1353,axiom,
    ! [VarCurr] :
      ( v17688(VarCurr)
    <=> ( v17355(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4404,axiom,
    ! [VarCurr] :
      ( v17675(VarCurr)
    <=> ( v17676(VarCurr)
        | v17684(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1352,axiom,
    ! [VarCurr] :
      ( v17684(VarCurr)
    <=> ( v16984(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4403,axiom,
    ! [VarCurr] :
      ( v17676(VarCurr)
    <=> ( v17677(VarCurr)
        | v17682(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1351,axiom,
    ! [VarCurr] :
      ( v17682(VarCurr)
    <=> ( v16976(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4402,axiom,
    ! [VarCurr] :
      ( v17677(VarCurr)
    <=> ( v17678(VarCurr)
        | v17680(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1350,axiom,
    ! [VarCurr] :
      ( v17680(VarCurr)
    <=> ( v16968(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1349,axiom,
    ! [VarCurr] :
      ( v17678(VarCurr)
    <=> ( v16960(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1348,axiom,
    ! [VarCurr] :
      ( v17658(VarCurr)
    <=> ( v17660(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1347,axiom,
    ! [VarCurr] :
      ( v17660(VarCurr)
    <=> ( v17661(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4401,axiom,
    ! [VarCurr] :
      ( v17661(VarCurr)
    <=> ( v17662(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4400,axiom,
    ! [VarCurr] :
      ( v17662(VarCurr)
    <=> ( v17663(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4399,axiom,
    ! [VarCurr] :
      ( v17663(VarCurr)
    <=> ( v17664(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1346,axiom,
    ! [VarCurr] :
      ( v17664(VarCurr)
    <=> ( v17665(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1345,axiom,
    ! [VarCurr] :
      ( v17665(VarCurr)
    <=> ( v15920(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1344,axiom,
    ! [VarCurr] :
      ( v17655(VarCurr)
    <=> ( v17657(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1343,axiom,
    ! [VarCurr] :
      ( v17657(VarCurr)
    <=> ( v17325(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4398,axiom,
    ! [VarCurr] :
      ( v17610(VarCurr)
    <=> ( v17612(VarCurr)
        | v17652(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1342,axiom,
    ! [VarCurr] :
      ( v17652(VarCurr)
    <=> ( v17654(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1341,axiom,
    ! [VarCurr] :
      ( v17654(VarCurr)
    <=> ( v17321(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4397,axiom,
    ! [VarCurr] :
      ( v17612(VarCurr)
    <=> ( v17613(VarCurr)
        | v17649(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1340,axiom,
    ! [VarCurr] :
      ( v17649(VarCurr)
    <=> ( v17651(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1339,axiom,
    ! [VarCurr] :
      ( v17651(VarCurr)
    <=> ( v17317(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4396,axiom,
    ! [VarCurr] :
      ( v17613(VarCurr)
    <=> ( v17614(VarCurr)
        | v17646(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1338,axiom,
    ! [VarCurr] :
      ( v17646(VarCurr)
    <=> ( v17648(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1337,axiom,
    ! [VarCurr] :
      ( v17648(VarCurr)
    <=> ( v17313(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4395,axiom,
    ! [VarCurr] :
      ( v17614(VarCurr)
    <=> ( v17615(VarCurr)
        | v17643(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1336,axiom,
    ! [VarCurr] :
      ( v17643(VarCurr)
    <=> ( v17645(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1335,axiom,
    ! [VarCurr] :
      ( v17645(VarCurr)
    <=> ( v17309(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4394,axiom,
    ! [VarCurr] :
      ( v17615(VarCurr)
    <=> ( v17616(VarCurr)
        | v17640(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1334,axiom,
    ! [VarCurr] :
      ( v17640(VarCurr)
    <=> ( v17642(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1333,axiom,
    ! [VarCurr] :
      ( v17642(VarCurr)
    <=> ( v17305(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4393,axiom,
    ! [VarCurr] :
      ( v17616(VarCurr)
    <=> ( v17617(VarCurr)
        | v17636(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1332,axiom,
    ! [VarCurr] :
      ( v17636(VarCurr)
    <=> ( v17638(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1331,axiom,
    ! [VarCurr] :
      ( v17638(VarCurr)
    <=> ( v17639(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4392,axiom,
    ! [VarCurr] :
      ( v17639(VarCurr)
    <=> ( v17454(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4391,axiom,
    ! [VarCurr] :
      ( v17617(VarCurr)
    <=> ( v17618(VarCurr)
        | v17633(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1330,axiom,
    ! [VarCurr] :
      ( v17633(VarCurr)
    <=> ( v17635(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1329,axiom,
    ! [VarCurr] :
      ( v17635(VarCurr)
    <=> ( v17301(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4390,axiom,
    ! [VarCurr] :
      ( v17618(VarCurr)
    <=> ( v17619(VarCurr)
        | v17630(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1328,axiom,
    ! [VarCurr] :
      ( v17630(VarCurr)
    <=> ( v17632(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1327,axiom,
    ! [VarCurr] :
      ( v17632(VarCurr)
    <=> ( v17297(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4389,axiom,
    ! [VarCurr] :
      ( v17619(VarCurr)
    <=> ( v17620(VarCurr)
        | v17627(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1326,axiom,
    ! [VarCurr] :
      ( v17627(VarCurr)
    <=> ( v17629(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1325,axiom,
    ! [VarCurr] :
      ( v17629(VarCurr)
    <=> ( v17293(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4388,axiom,
    ! [VarCurr] :
      ( v17620(VarCurr)
    <=> ( v17621(VarCurr)
        | v17624(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1324,axiom,
    ! [VarCurr] :
      ( v17624(VarCurr)
    <=> ( v17626(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1323,axiom,
    ! [VarCurr] :
      ( v17626(VarCurr)
    <=> ( v17289(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1322,axiom,
    ! [VarCurr] :
      ( v17621(VarCurr)
    <=> ( v17623(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1321,axiom,
    ! [VarCurr] :
      ( v17623(VarCurr)
    <=> ( v17285(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4387,axiom,
    ! [VarCurr] :
      ( v17592(VarCurr)
    <=> ( v17594(VarCurr)
        | v17607(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1320,axiom,
    ! [VarCurr] :
      ( v17607(VarCurr)
    <=> ( v17609(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4386,axiom,
    ! [VarCurr] :
      ( v17609(VarCurr)
    <=> ( v17603(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4385,axiom,
    ! [VarCurr] :
      ( v17594(VarCurr)
    <=> ( v17595(VarCurr)
        | v17604(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1319,axiom,
    ! [VarCurr] :
      ( v17604(VarCurr)
    <=> ( v17606(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4384,axiom,
    ! [VarCurr] :
      ( v17606(VarCurr)
    <=> ( v17599(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4383,axiom,
    ! [VarCurr] :
      ( v17595(VarCurr)
    <=> ( v17596(VarCurr)
        | v17600(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4382,axiom,
    ! [VarCurr] :
      ( v17600(VarCurr)
    <=> ( v17602(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1318,axiom,
    ! [VarCurr] :
      ( v17602(VarCurr)
    <=> ( v17603(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1317,axiom,
    ! [VarCurr] :
      ( v17603(VarCurr)
    <=> ( v17573(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4381,axiom,
    ! [VarCurr] :
      ( v17596(VarCurr)
    <=> ( v17598(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1316,axiom,
    ! [VarCurr] :
      ( v17598(VarCurr)
    <=> ( v17599(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4380,axiom,
    ! [VarCurr] :
      ( v17599(VarCurr)
    <=> ( v17573(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4379,axiom,
    ! [VarCurr] :
      ( v17576(VarCurr)
    <=> ( v17578(VarCurr)
        | v17588(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4378,axiom,
    ! [VarCurr] :
      ( v17588(VarCurr)
    <=> ( v17590(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4377,axiom,
    ! [VarCurr] :
      ( v17590(VarCurr)
    <=> ( v17591(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1315,axiom,
    ! [VarCurr] :
      ( v17591(VarCurr)
    <=> ( v17583(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4376,axiom,
    ! [VarCurr] :
      ( v17578(VarCurr)
    <=> ( v17579(VarCurr)
        | v17584(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4375,axiom,
    ! [VarCurr] :
      ( v17584(VarCurr)
    <=> ( v17586(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4374,axiom,
    ! [VarCurr] :
      ( v17586(VarCurr)
    <=> ( v17587(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1314,axiom,
    ! [VarCurr] :
      ( v17587(VarCurr)
    <=> ( v17572(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4373,axiom,
    ! [VarCurr] :
      ( v17579(VarCurr)
    <=> ( v17581(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4372,axiom,
    ! [VarCurr] :
      ( v17581(VarCurr)
    <=> ( v17582(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4371,axiom,
    ! [VarCurr] :
      ( v17582(VarCurr)
    <=> ( v17583(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4370,axiom,
    ! [VarCurr] :
      ( v17583(VarCurr)
    <=> ( v17573(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4369,axiom,
    ! [VarCurr] :
      ( v17568(VarCurr)
    <=> ( v17570(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4368,axiom,
    ! [VarCurr] :
      ( v17570(VarCurr)
    <=> ( v17571(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4367,axiom,
    ! [VarCurr] :
      ( v17571(VarCurr)
    <=> ( v17572(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4366,axiom,
    ! [VarCurr] :
      ( v17572(VarCurr)
    <=> ( v17573(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1313,axiom,
    ! [VarCurr] :
      ( v17573(VarCurr)
    <=> ( v17574(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4365,axiom,
    ! [VarCurr] :
      ( v17574(VarCurr)
    <=> ( v17575(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1312,axiom,
    ! [VarCurr] :
      ( v17575(VarCurr)
    <=> ( v17379(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4364,axiom,
    ! [VarCurr] :
      ( v17522(VarCurr)
    <=> ( v17524(VarCurr)
        | v17565(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1311,axiom,
    ! [VarCurr] :
      ( v17565(VarCurr)
    <=> ( v17567(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4363,axiom,
    ! [VarCurr] :
      ( v17567(VarCurr)
    <=> ( v17238(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4362,axiom,
    ! [VarCurr] :
      ( v17524(VarCurr)
    <=> ( v17525(VarCurr)
        | v17562(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1310,axiom,
    ! [VarCurr] :
      ( v17562(VarCurr)
    <=> ( v17564(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4361,axiom,
    ! [VarCurr] :
      ( v17564(VarCurr)
    <=> ( v17230(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4360,axiom,
    ! [VarCurr] :
      ( v17525(VarCurr)
    <=> ( v17526(VarCurr)
        | v17559(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1309,axiom,
    ! [VarCurr] :
      ( v17559(VarCurr)
    <=> ( v17561(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4359,axiom,
    ! [VarCurr] :
      ( v17561(VarCurr)
    <=> ( v17226(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4358,axiom,
    ! [VarCurr] :
      ( v17526(VarCurr)
    <=> ( v17527(VarCurr)
        | v17556(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1308,axiom,
    ! [VarCurr] :
      ( v17556(VarCurr)
    <=> ( v17558(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4357,axiom,
    ! [VarCurr] :
      ( v17558(VarCurr)
    <=> ( v17222(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4356,axiom,
    ! [VarCurr] :
      ( v17527(VarCurr)
    <=> ( v17528(VarCurr)
        | v17553(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1307,axiom,
    ! [VarCurr] :
      ( v17553(VarCurr)
    <=> ( v17555(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4355,axiom,
    ! [VarCurr] :
      ( v17555(VarCurr)
    <=> ( v17218(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4354,axiom,
    ! [VarCurr] :
      ( v17528(VarCurr)
    <=> ( v17529(VarCurr)
        | v17548(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1306,axiom,
    ! [VarCurr] :
      ( v17548(VarCurr)
    <=> ( v17550(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4353,axiom,
    ! [VarCurr] :
      ( v17550(VarCurr)
    <=> ( v17551(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1305,axiom,
    ! [VarCurr] :
      ( v17551(VarCurr)
    <=> ( v17552(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4352,axiom,
    ! [VarCurr] :
      ( v17552(VarCurr)
    <=> ( v17455(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4351,axiom,
    ! [VarCurr] :
      ( v17529(VarCurr)
    <=> ( v17530(VarCurr)
        | v17545(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1304,axiom,
    ! [VarCurr] :
      ( v17545(VarCurr)
    <=> ( v17547(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4350,axiom,
    ! [VarCurr] :
      ( v17547(VarCurr)
    <=> ( v17213(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4349,axiom,
    ! [VarCurr] :
      ( v17530(VarCurr)
    <=> ( v17531(VarCurr)
        | v17542(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1303,axiom,
    ! [VarCurr] :
      ( v17542(VarCurr)
    <=> ( v17544(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4348,axiom,
    ! [VarCurr] :
      ( v17544(VarCurr)
    <=> ( v17209(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4347,axiom,
    ! [VarCurr] :
      ( v17531(VarCurr)
    <=> ( v17532(VarCurr)
        | v17539(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1302,axiom,
    ! [VarCurr] :
      ( v17539(VarCurr)
    <=> ( v17541(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4346,axiom,
    ! [VarCurr] :
      ( v17541(VarCurr)
    <=> ( v17205(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4345,axiom,
    ! [VarCurr] :
      ( v17532(VarCurr)
    <=> ( v17533(VarCurr)
        | v17536(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1301,axiom,
    ! [VarCurr] :
      ( v17536(VarCurr)
    <=> ( v17538(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4344,axiom,
    ! [VarCurr] :
      ( v17538(VarCurr)
    <=> ( v17201(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1300,axiom,
    ! [VarCurr] :
      ( v17533(VarCurr)
    <=> ( v17535(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4343,axiom,
    ! [VarCurr] :
      ( v17535(VarCurr)
    <=> ( v17197(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4342,axiom,
    ! [VarCurr] :
      ( v17513(VarCurr)
    <=> ( v17514(VarCurr)
        | v17518(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1299,axiom,
    ! [VarCurr] :
      ( v17518(VarCurr)
    <=> ( v17520(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4341,axiom,
    ! [VarCurr] :
      ( v17520(VarCurr)
    <=> ( v17521(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1298,axiom,
    ! [VarCurr] :
      ( v17521(VarCurr)
    <=> ( v17478(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1297,axiom,
    ! [VarCurr] :
      ( v17514(VarCurr)
    <=> ( v17516(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4340,axiom,
    ! [VarCurr] :
      ( v17516(VarCurr)
    <=> ( v17517(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4339,axiom,
    ! [VarCurr] :
      ( v17517(VarCurr)
    <=> ( v17478(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4338,axiom,
    ! [VarCurr] :
      ( v17481(VarCurr)
    <=> ( v17483(VarCurr)
        | v17510(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4337,axiom,
    ! [VarCurr] :
      ( v17510(VarCurr)
    <=> ( v17512(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1296,axiom,
    ! [VarCurr] :
      ( v17512(VarCurr)
    <=> ( v17500(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4336,axiom,
    ! [VarCurr] :
      ( v17483(VarCurr)
    <=> ( v17484(VarCurr)
        | v17507(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4335,axiom,
    ! [VarCurr] :
      ( v17507(VarCurr)
    <=> ( v17509(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1295,axiom,
    ! [VarCurr] :
      ( v17509(VarCurr)
    <=> ( v17496(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4334,axiom,
    ! [VarCurr] :
      ( v17484(VarCurr)
    <=> ( v17485(VarCurr)
        | v17504(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4333,axiom,
    ! [VarCurr] :
      ( v17504(VarCurr)
    <=> ( v17506(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1294,axiom,
    ! [VarCurr] :
      ( v17506(VarCurr)
    <=> ( v17491(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4332,axiom,
    ! [VarCurr] :
      ( v17485(VarCurr)
    <=> ( v17486(VarCurr)
        | v17501(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4331,axiom,
    ! [VarCurr] :
      ( v17501(VarCurr)
    <=> ( v17503(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1293,axiom,
    ! [VarCurr] :
      ( v17503(VarCurr)
    <=> ( v17476(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4330,axiom,
    ! [VarCurr] :
      ( v17486(VarCurr)
    <=> ( v17487(VarCurr)
        | v17497(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4329,axiom,
    ! [VarCurr] :
      ( v17497(VarCurr)
    <=> ( v17499(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4328,axiom,
    ! [VarCurr] :
      ( v17499(VarCurr)
    <=> ( v17500(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1292,axiom,
    ! [VarCurr] :
      ( v17500(VarCurr)
    <=> ( v17492(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4327,axiom,
    ! [VarCurr] :
      ( v17487(VarCurr)
    <=> ( v17488(VarCurr)
        | v17493(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4326,axiom,
    ! [VarCurr] :
      ( v17493(VarCurr)
    <=> ( v17495(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4325,axiom,
    ! [VarCurr] :
      ( v17495(VarCurr)
    <=> ( v17496(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1291,axiom,
    ! [VarCurr] :
      ( v17496(VarCurr)
    <=> ( v17477(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4324,axiom,
    ! [VarCurr] :
      ( v17488(VarCurr)
    <=> ( v17490(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4323,axiom,
    ! [VarCurr] :
      ( v17490(VarCurr)
    <=> ( v17491(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4322,axiom,
    ! [VarCurr] :
      ( v17491(VarCurr)
    <=> ( v17492(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4321,axiom,
    ! [VarCurr] :
      ( v17492(VarCurr)
    <=> ( v17478(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4320,axiom,
    ! [VarCurr] :
      ( v17473(VarCurr)
    <=> ( v17475(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4319,axiom,
    ! [VarCurr] :
      ( v17475(VarCurr)
    <=> ( v17476(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4318,axiom,
    ! [VarCurr] :
      ( v17476(VarCurr)
    <=> ( v17477(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4317,axiom,
    ! [VarCurr] :
      ( v17477(VarCurr)
    <=> ( v17478(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1290,axiom,
    ! [VarCurr] :
      ( v17478(VarCurr)
    <=> ( v17479(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4316,axiom,
    ! [VarCurr] :
      ( v17479(VarCurr)
    <=> ( v17480(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1289,axiom,
    ! [VarCurr] :
      ( v17480(VarCurr)
    <=> ( v17326(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4315,axiom,
    ! [VarCurr] :
      ( v17424(VarCurr)
    <=> ( v17426(VarCurr)
        | v17470(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1288,axiom,
    ! [VarCurr] :
      ( v17470(VarCurr)
    <=> ( v17472(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4314,axiom,
    ! [VarCurr] :
      ( v17472(VarCurr)
    <=> ( v17142(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4313,axiom,
    ! [VarCurr] :
      ( v17426(VarCurr)
    <=> ( v17427(VarCurr)
        | v17467(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1287,axiom,
    ! [VarCurr] :
      ( v17467(VarCurr)
    <=> ( v17469(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4312,axiom,
    ! [VarCurr] :
      ( v17469(VarCurr)
    <=> ( v17133(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4311,axiom,
    ! [VarCurr] :
      ( v17427(VarCurr)
    <=> ( v17428(VarCurr)
        | v17464(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1286,axiom,
    ! [VarCurr] :
      ( v17464(VarCurr)
    <=> ( v17466(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4310,axiom,
    ! [VarCurr] :
      ( v17466(VarCurr)
    <=> ( v17128(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4309,axiom,
    ! [VarCurr] :
      ( v17428(VarCurr)
    <=> ( v17429(VarCurr)
        | v17461(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1285,axiom,
    ! [VarCurr] :
      ( v17461(VarCurr)
    <=> ( v17463(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4308,axiom,
    ! [VarCurr] :
      ( v17463(VarCurr)
    <=> ( v17123(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4307,axiom,
    ! [VarCurr] :
      ( v17429(VarCurr)
    <=> ( v17430(VarCurr)
        | v17458(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1284,axiom,
    ! [VarCurr] :
      ( v17458(VarCurr)
    <=> ( v17460(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4306,axiom,
    ! [VarCurr] :
      ( v17460(VarCurr)
    <=> ( v17118(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4305,axiom,
    ! [VarCurr] :
      ( v17430(VarCurr)
    <=> ( v17431(VarCurr)
        | v17450(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1283,axiom,
    ! [VarCurr] :
      ( v17450(VarCurr)
    <=> ( v17452(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4304,axiom,
    ! [VarCurr] :
      ( v17452(VarCurr)
    <=> ( v17453(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1282,axiom,
    ! [VarCurr] :
      ( v17453(VarCurr)
    <=> ( v17454(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4303,axiom,
    ! [VarCurr] :
      ( v17454(VarCurr)
    <=> ( v17455(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4302,axiom,
    ! [VarCurr] :
      ( v17455(VarCurr)
    <=> ( v17456(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1281,axiom,
    ! [VarCurr] :
      ( v17456(VarCurr)
    <=> ( v17457(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1280,axiom,
    ! [VarCurr] :
      ( v17457(VarCurr)
    <=> ( v15728(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4301,axiom,
    ! [VarCurr] :
      ( v17431(VarCurr)
    <=> ( v17432(VarCurr)
        | v17447(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1279,axiom,
    ! [VarCurr] :
      ( v17447(VarCurr)
    <=> ( v17449(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4300,axiom,
    ! [VarCurr] :
      ( v17449(VarCurr)
    <=> ( v17110(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4299,axiom,
    ! [VarCurr] :
      ( v17432(VarCurr)
    <=> ( v17433(VarCurr)
        | v17444(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1278,axiom,
    ! [VarCurr] :
      ( v17444(VarCurr)
    <=> ( v17446(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4298,axiom,
    ! [VarCurr] :
      ( v17446(VarCurr)
    <=> ( v17105(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4297,axiom,
    ! [VarCurr] :
      ( v17433(VarCurr)
    <=> ( v17434(VarCurr)
        | v17441(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1277,axiom,
    ! [VarCurr] :
      ( v17441(VarCurr)
    <=> ( v17443(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4296,axiom,
    ! [VarCurr] :
      ( v17443(VarCurr)
    <=> ( v17100(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4295,axiom,
    ! [VarCurr] :
      ( v17434(VarCurr)
    <=> ( v17435(VarCurr)
        | v17438(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1276,axiom,
    ! [VarCurr] :
      ( v17438(VarCurr)
    <=> ( v17440(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4294,axiom,
    ! [VarCurr] :
      ( v17440(VarCurr)
    <=> ( v17095(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1275,axiom,
    ! [VarCurr] :
      ( v17435(VarCurr)
    <=> ( v17437(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4293,axiom,
    ! [VarCurr] :
      ( v17437(VarCurr)
    <=> ( v17090(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4292,axiom,
    ! [VarCurr] :
      ( v17380(VarCurr)
    <=> ( v17382(VarCurr)
        | v17422(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1274,axiom,
    ! [VarCurr] :
      ( v17422(VarCurr)
    <=> ( v17402(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4291,axiom,
    ! [VarCurr] :
      ( v17382(VarCurr)
    <=> ( v17383(VarCurr)
        | v17420(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1273,axiom,
    ! [VarCurr] :
      ( v17420(VarCurr)
    <=> ( v17398(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4290,axiom,
    ! [VarCurr] :
      ( v17383(VarCurr)
    <=> ( v17384(VarCurr)
        | v17418(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1272,axiom,
    ! [VarCurr] :
      ( v17418(VarCurr)
    <=> ( v17393(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4289,axiom,
    ! [VarCurr] :
      ( v17384(VarCurr)
    <=> ( v17385(VarCurr)
        | v17416(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1271,axiom,
    ! [VarCurr] :
      ( v17416(VarCurr)
    <=> ( v17373(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4288,axiom,
    ! [VarCurr] :
      ( v17385(VarCurr)
    <=> ( v17386(VarCurr)
        | v17413(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4287,axiom,
    ! [VarCurr] :
      ( v17413(VarCurr)
    <=> ( v17415(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1270,axiom,
    ! [VarCurr] :
      ( v17415(VarCurr)
    <=> ( v17403(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4286,axiom,
    ! [VarCurr] :
      ( v17386(VarCurr)
    <=> ( v17387(VarCurr)
        | v17410(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4285,axiom,
    ! [VarCurr] :
      ( v17410(VarCurr)
    <=> ( v17412(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1269,axiom,
    ! [VarCurr] :
      ( v17412(VarCurr)
    <=> ( v17399(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4284,axiom,
    ! [VarCurr] :
      ( v17387(VarCurr)
    <=> ( v17388(VarCurr)
        | v17407(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4283,axiom,
    ! [VarCurr] :
      ( v17407(VarCurr)
    <=> ( v17409(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1268,axiom,
    ! [VarCurr] :
      ( v17409(VarCurr)
    <=> ( v17394(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4282,axiom,
    ! [VarCurr] :
      ( v17388(VarCurr)
    <=> ( v17389(VarCurr)
        | v17404(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4281,axiom,
    ! [VarCurr] :
      ( v17404(VarCurr)
    <=> ( v17406(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1267,axiom,
    ! [VarCurr] :
      ( v17406(VarCurr)
    <=> ( v17374(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4280,axiom,
    ! [VarCurr] :
      ( v17389(VarCurr)
    <=> ( v17390(VarCurr)
        | v17400(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4279,axiom,
    ! [VarCurr] :
      ( v17400(VarCurr)
    <=> ( v17402(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4278,axiom,
    ! [VarCurr] :
      ( v17402(VarCurr)
    <=> ( v17403(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1266,axiom,
    ! [VarCurr] :
      ( v17403(VarCurr)
    <=> ( v17395(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4277,axiom,
    ! [VarCurr] :
      ( v17390(VarCurr)
    <=> ( v17391(VarCurr)
        | v17396(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4276,axiom,
    ! [VarCurr] :
      ( v17396(VarCurr)
    <=> ( v17398(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4275,axiom,
    ! [VarCurr] :
      ( v17398(VarCurr)
    <=> ( v17399(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1265,axiom,
    ! [VarCurr] :
      ( v17399(VarCurr)
    <=> ( v17375(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4274,axiom,
    ! [VarCurr] :
      ( v17391(VarCurr)
    <=> ( v17393(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4273,axiom,
    ! [VarCurr] :
      ( v17393(VarCurr)
    <=> ( v17394(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4272,axiom,
    ! [VarCurr] :
      ( v17394(VarCurr)
    <=> ( v17395(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4271,axiom,
    ! [VarCurr] :
      ( v17395(VarCurr)
    <=> ( v17376(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4270,axiom,
    ! [VarCurr] :
      ( v17371(VarCurr)
    <=> ( v17373(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4269,axiom,
    ! [VarCurr] :
      ( v17373(VarCurr)
    <=> ( v17374(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4268,axiom,
    ! [VarCurr] :
      ( v17374(VarCurr)
    <=> ( v17375(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4267,axiom,
    ! [VarCurr] :
      ( v17375(VarCurr)
    <=> ( v17376(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1264,axiom,
    ! [VarCurr] :
      ( v17376(VarCurr)
    <=> ( v17377(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4266,axiom,
    ! [VarCurr] :
      ( v17377(VarCurr)
    <=> ( v17378(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4265,axiom,
    ! [VarCurr] :
      ( v17378(VarCurr)
    <=> ( v17379(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4264,axiom,
    ! [VarCurr] :
      ( v17379(VarCurr)
    <=> ( v17327(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4263,axiom,
    ! [VarCurr] :
      ( v17330(VarCurr)
    <=> ( v17332(VarCurr)
        | v17368(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1263,axiom,
    ! [VarCurr] :
      ( v17368(VarCurr)
    <=> ( v17370(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4262,axiom,
    ! [VarCurr] :
      ( v17370(VarCurr)
    <=> ( v17029(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4261,axiom,
    ! [VarCurr] :
      ( v17332(VarCurr)
    <=> ( v17333(VarCurr)
        | v17365(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1262,axiom,
    ! [VarCurr] :
      ( v17365(VarCurr)
    <=> ( v17367(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4260,axiom,
    ! [VarCurr] :
      ( v17367(VarCurr)
    <=> ( v17017(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4259,axiom,
    ! [VarCurr] :
      ( v17333(VarCurr)
    <=> ( v17334(VarCurr)
        | v17362(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1261,axiom,
    ! [VarCurr] :
      ( v17362(VarCurr)
    <=> ( v17364(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4258,axiom,
    ! [VarCurr] :
      ( v17364(VarCurr)
    <=> ( v17009(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4257,axiom,
    ! [VarCurr] :
      ( v17334(VarCurr)
    <=> ( v17335(VarCurr)
        | v17359(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1260,axiom,
    ! [VarCurr] :
      ( v17359(VarCurr)
    <=> ( v17361(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4256,axiom,
    ! [VarCurr] :
      ( v17361(VarCurr)
    <=> ( v17001(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4255,axiom,
    ! [VarCurr] :
      ( v17335(VarCurr)
    <=> ( v17336(VarCurr)
        | v17356(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1259,axiom,
    ! [VarCurr] :
      ( v17356(VarCurr)
    <=> ( v17358(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4254,axiom,
    ! [VarCurr] :
      ( v17358(VarCurr)
    <=> ( v16993(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4253,axiom,
    ! [VarCurr] :
      ( v17336(VarCurr)
    <=> ( v17337(VarCurr)
        | v17352(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1258,axiom,
    ! [VarCurr] :
      ( v17352(VarCurr)
    <=> ( v17354(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4252,axiom,
    ! [VarCurr] :
      ( v17354(VarCurr)
    <=> ( v17355(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4251,axiom,
    ! [VarCurr] :
      ( v17355(VarCurr)
    <=> ( v17214(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4250,axiom,
    ! [VarCurr] :
      ( v17337(VarCurr)
    <=> ( v17338(VarCurr)
        | v17349(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1257,axiom,
    ! [VarCurr] :
      ( v17349(VarCurr)
    <=> ( v17351(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4249,axiom,
    ! [VarCurr] :
      ( v17351(VarCurr)
    <=> ( v16985(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4248,axiom,
    ! [VarCurr] :
      ( v17338(VarCurr)
    <=> ( v17339(VarCurr)
        | v17346(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1256,axiom,
    ! [VarCurr] :
      ( v17346(VarCurr)
    <=> ( v17348(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4247,axiom,
    ! [VarCurr] :
      ( v17348(VarCurr)
    <=> ( v16977(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4246,axiom,
    ! [VarCurr] :
      ( v17339(VarCurr)
    <=> ( v17340(VarCurr)
        | v17343(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1255,axiom,
    ! [VarCurr] :
      ( v17343(VarCurr)
    <=> ( v17345(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4245,axiom,
    ! [VarCurr] :
      ( v17345(VarCurr)
    <=> ( v16969(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1254,axiom,
    ! [VarCurr] :
      ( v17340(VarCurr)
    <=> ( v17342(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4244,axiom,
    ! [VarCurr] :
      ( v17342(VarCurr)
    <=> ( v16961(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1253,axiom,
    ! [VarCurr] :
      ( v17322(VarCurr)
    <=> ( v17324(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4243,axiom,
    ! [VarCurr] :
      ( v17324(VarCurr)
    <=> ( v17325(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4242,axiom,
    ! [VarCurr] :
      ( v17325(VarCurr)
    <=> ( v17326(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4241,axiom,
    ! [VarCurr] :
      ( v17326(VarCurr)
    <=> ( v17327(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4240,axiom,
    ! [VarCurr] :
      ( v17327(VarCurr)
    <=> ( v17328(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1252,axiom,
    ! [VarCurr] :
      ( v17328(VarCurr)
    <=> ( v17329(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1251,axiom,
    ! [VarCurr] :
      ( v17329(VarCurr)
    <=> ( v15599(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1250,axiom,
    ! [VarCurr] :
      ( v17318(VarCurr)
    <=> ( v17320(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4239,axiom,
    ! [VarCurr] :
      ( v17320(VarCurr)
    <=> ( v17321(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4238,axiom,
    ! [VarCurr] :
      ( v17321(VarCurr)
    <=> ( v17143(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4237,axiom,
    ! [VarCurr] :
      ( v17273(VarCurr)
    <=> ( v17275(VarCurr)
        | v17314(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1249,axiom,
    ! [VarCurr] :
      ( v17314(VarCurr)
    <=> ( v17316(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4236,axiom,
    ! [VarCurr] :
      ( v17316(VarCurr)
    <=> ( v17317(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4235,axiom,
    ! [VarCurr] :
      ( v17317(VarCurr)
    <=> ( v17134(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4234,axiom,
    ! [VarCurr] :
      ( v17275(VarCurr)
    <=> ( v17276(VarCurr)
        | v17310(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1248,axiom,
    ! [VarCurr] :
      ( v17310(VarCurr)
    <=> ( v17312(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4233,axiom,
    ! [VarCurr] :
      ( v17312(VarCurr)
    <=> ( v17313(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4232,axiom,
    ! [VarCurr] :
      ( v17313(VarCurr)
    <=> ( v17129(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4231,axiom,
    ! [VarCurr] :
      ( v17276(VarCurr)
    <=> ( v17277(VarCurr)
        | v17306(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1247,axiom,
    ! [VarCurr] :
      ( v17306(VarCurr)
    <=> ( v17308(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4230,axiom,
    ! [VarCurr] :
      ( v17308(VarCurr)
    <=> ( v17309(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4229,axiom,
    ! [VarCurr] :
      ( v17309(VarCurr)
    <=> ( v17124(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4228,axiom,
    ! [VarCurr] :
      ( v17277(VarCurr)
    <=> ( v17278(VarCurr)
        | v17302(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1246,axiom,
    ! [VarCurr] :
      ( v17302(VarCurr)
    <=> ( v17304(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4227,axiom,
    ! [VarCurr] :
      ( v17304(VarCurr)
    <=> ( v17305(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4226,axiom,
    ! [VarCurr] :
      ( v17305(VarCurr)
    <=> ( v17119(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4225,axiom,
    ! [VarCurr] :
      ( v17278(VarCurr)
    <=> ( v17279(VarCurr)
        | v17298(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1245,axiom,
    ! [VarCurr] :
      ( v17298(VarCurr)
    <=> ( v17300(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4224,axiom,
    ! [VarCurr] :
      ( v17300(VarCurr)
    <=> ( v17301(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4223,axiom,
    ! [VarCurr] :
      ( v17301(VarCurr)
    <=> ( v17111(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4222,axiom,
    ! [VarCurr] :
      ( v17279(VarCurr)
    <=> ( v17280(VarCurr)
        | v17294(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1244,axiom,
    ! [VarCurr] :
      ( v17294(VarCurr)
    <=> ( v17296(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4221,axiom,
    ! [VarCurr] :
      ( v17296(VarCurr)
    <=> ( v17297(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4220,axiom,
    ! [VarCurr] :
      ( v17297(VarCurr)
    <=> ( v17106(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4219,axiom,
    ! [VarCurr] :
      ( v17280(VarCurr)
    <=> ( v17281(VarCurr)
        | v17290(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1243,axiom,
    ! [VarCurr] :
      ( v17290(VarCurr)
    <=> ( v17292(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4218,axiom,
    ! [VarCurr] :
      ( v17292(VarCurr)
    <=> ( v17293(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4217,axiom,
    ! [VarCurr] :
      ( v17293(VarCurr)
    <=> ( v17101(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4216,axiom,
    ! [VarCurr] :
      ( v17281(VarCurr)
    <=> ( v17282(VarCurr)
        | v17286(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1242,axiom,
    ! [VarCurr] :
      ( v17286(VarCurr)
    <=> ( v17288(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4215,axiom,
    ! [VarCurr] :
      ( v17288(VarCurr)
    <=> ( v17289(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4214,axiom,
    ! [VarCurr] :
      ( v17289(VarCurr)
    <=> ( v17096(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1241,axiom,
    ! [VarCurr] :
      ( v17282(VarCurr)
    <=> ( v17284(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4213,axiom,
    ! [VarCurr] :
      ( v17284(VarCurr)
    <=> ( v17285(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4212,axiom,
    ! [VarCurr] :
      ( v17285(VarCurr)
    <=> ( v17091(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4211,axiom,
    ! [VarCurr] :
      ( v17255(VarCurr)
    <=> ( v17257(VarCurr)
        | v17270(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1240,axiom,
    ! [VarCurr] :
      ( v17270(VarCurr)
    <=> ( v17272(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4210,axiom,
    ! [VarCurr] :
      ( v17272(VarCurr)
    <=> ( v17266(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4209,axiom,
    ! [VarCurr] :
      ( v17257(VarCurr)
    <=> ( v17258(VarCurr)
        | v17267(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1239,axiom,
    ! [VarCurr] :
      ( v17267(VarCurr)
    <=> ( v17269(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4208,axiom,
    ! [VarCurr] :
      ( v17269(VarCurr)
    <=> ( v17262(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4207,axiom,
    ! [VarCurr] :
      ( v17258(VarCurr)
    <=> ( v17259(VarCurr)
        | v17263(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4206,axiom,
    ! [VarCurr] :
      ( v17263(VarCurr)
    <=> ( v17265(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1238,axiom,
    ! [VarCurr] :
      ( v17265(VarCurr)
    <=> ( v17266(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1237,axiom,
    ! [VarCurr] :
      ( v17266(VarCurr)
    <=> ( v17236(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4205,axiom,
    ! [VarCurr] :
      ( v17259(VarCurr)
    <=> ( v17261(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1236,axiom,
    ! [VarCurr] :
      ( v17261(VarCurr)
    <=> ( v17262(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4204,axiom,
    ! [VarCurr] :
      ( v17262(VarCurr)
    <=> ( v17236(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4203,axiom,
    ! [VarCurr] :
      ( v17239(VarCurr)
    <=> ( v17241(VarCurr)
        | v17251(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4202,axiom,
    ! [VarCurr] :
      ( v17251(VarCurr)
    <=> ( v17253(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4201,axiom,
    ! [VarCurr] :
      ( v17253(VarCurr)
    <=> ( v17254(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1235,axiom,
    ! [VarCurr] :
      ( v17254(VarCurr)
    <=> ( v17246(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4200,axiom,
    ! [VarCurr] :
      ( v17241(VarCurr)
    <=> ( v17242(VarCurr)
        | v17247(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4199,axiom,
    ! [VarCurr] :
      ( v17247(VarCurr)
    <=> ( v17249(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4198,axiom,
    ! [VarCurr] :
      ( v17249(VarCurr)
    <=> ( v17250(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1234,axiom,
    ! [VarCurr] :
      ( v17250(VarCurr)
    <=> ( v17235(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4197,axiom,
    ! [VarCurr] :
      ( v17242(VarCurr)
    <=> ( v17244(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4196,axiom,
    ! [VarCurr] :
      ( v17244(VarCurr)
    <=> ( v17245(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4195,axiom,
    ! [VarCurr] :
      ( v17245(VarCurr)
    <=> ( v17246(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4194,axiom,
    ! [VarCurr] :
      ( v17246(VarCurr)
    <=> ( v17236(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4193,axiom,
    ! [VarCurr] :
      ( v17231(VarCurr)
    <=> ( v17233(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4192,axiom,
    ! [VarCurr] :
      ( v17233(VarCurr)
    <=> ( v17234(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4191,axiom,
    ! [VarCurr] :
      ( v17234(VarCurr)
    <=> ( v17235(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4190,axiom,
    ! [VarCurr] :
      ( v17235(VarCurr)
    <=> ( v17236(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4189,axiom,
    ! [VarCurr] :
      ( v17236(VarCurr)
    <=> ( v17237(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1233,axiom,
    ! [VarCurr] :
      ( v17237(VarCurr)
    <=> ( v17238(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1232,axiom,
    ! [VarCurr] :
      ( v17238(VarCurr)
    <=> ( v17030(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4188,axiom,
    ! [VarCurr] :
      ( v17185(VarCurr)
    <=> ( v17187(VarCurr)
        | v17227(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4187,axiom,
    ! [VarCurr] :
      ( v17227(VarCurr)
    <=> ( v17229(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1231,axiom,
    ! [VarCurr] :
      ( v17229(VarCurr)
    <=> ( v17230(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1230,axiom,
    ! [VarCurr] :
      ( v17230(VarCurr)
    <=> ( v17018(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4186,axiom,
    ! [VarCurr] :
      ( v17187(VarCurr)
    <=> ( v17188(VarCurr)
        | v17223(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4185,axiom,
    ! [VarCurr] :
      ( v17223(VarCurr)
    <=> ( v17225(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1229,axiom,
    ! [VarCurr] :
      ( v17225(VarCurr)
    <=> ( v17226(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1228,axiom,
    ! [VarCurr] :
      ( v17226(VarCurr)
    <=> ( v17010(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4184,axiom,
    ! [VarCurr] :
      ( v17188(VarCurr)
    <=> ( v17189(VarCurr)
        | v17219(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4183,axiom,
    ! [VarCurr] :
      ( v17219(VarCurr)
    <=> ( v17221(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1227,axiom,
    ! [VarCurr] :
      ( v17221(VarCurr)
    <=> ( v17222(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1226,axiom,
    ! [VarCurr] :
      ( v17222(VarCurr)
    <=> ( v17002(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4182,axiom,
    ! [VarCurr] :
      ( v17189(VarCurr)
    <=> ( v17190(VarCurr)
        | v17215(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4181,axiom,
    ! [VarCurr] :
      ( v17215(VarCurr)
    <=> ( v17217(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1225,axiom,
    ! [VarCurr] :
      ( v17217(VarCurr)
    <=> ( v17218(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1224,axiom,
    ! [VarCurr] :
      ( v17218(VarCurr)
    <=> ( v16994(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4180,axiom,
    ! [VarCurr] :
      ( v17190(VarCurr)
    <=> ( v17191(VarCurr)
        | v17210(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4179,axiom,
    ! [VarCurr] :
      ( v17210(VarCurr)
    <=> ( v17212(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1223,axiom,
    ! [VarCurr] :
      ( v17212(VarCurr)
    <=> ( v17213(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1222,axiom,
    ! [VarCurr] :
      ( v17213(VarCurr)
    <=> ( v17214(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4178,axiom,
    ! [VarCurr] :
      ( v17214(VarCurr)
    <=> ( v17112(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4177,axiom,
    ! [VarCurr] :
      ( v17191(VarCurr)
    <=> ( v17192(VarCurr)
        | v17206(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4176,axiom,
    ! [VarCurr] :
      ( v17206(VarCurr)
    <=> ( v17208(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1221,axiom,
    ! [VarCurr] :
      ( v17208(VarCurr)
    <=> ( v17209(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1220,axiom,
    ! [VarCurr] :
      ( v17209(VarCurr)
    <=> ( v16986(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4175,axiom,
    ! [VarCurr] :
      ( v17192(VarCurr)
    <=> ( v17193(VarCurr)
        | v17202(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4174,axiom,
    ! [VarCurr] :
      ( v17202(VarCurr)
    <=> ( v17204(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1219,axiom,
    ! [VarCurr] :
      ( v17204(VarCurr)
    <=> ( v17205(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1218,axiom,
    ! [VarCurr] :
      ( v17205(VarCurr)
    <=> ( v16978(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4173,axiom,
    ! [VarCurr] :
      ( v17193(VarCurr)
    <=> ( v17194(VarCurr)
        | v17198(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4172,axiom,
    ! [VarCurr] :
      ( v17198(VarCurr)
    <=> ( v17200(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1217,axiom,
    ! [VarCurr] :
      ( v17200(VarCurr)
    <=> ( v17201(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1216,axiom,
    ! [VarCurr] :
      ( v17201(VarCurr)
    <=> ( v16970(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4171,axiom,
    ! [VarCurr] :
      ( v17194(VarCurr)
    <=> ( v17196(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1215,axiom,
    ! [VarCurr] :
      ( v17196(VarCurr)
    <=> ( v17197(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1214,axiom,
    ! [VarCurr] :
      ( v17197(VarCurr)
    <=> ( v16962(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4170,axiom,
    ! [VarCurr] :
      ( v17176(VarCurr)
    <=> ( v17177(VarCurr)
        | v17181(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1213,axiom,
    ! [VarCurr] :
      ( v17181(VarCurr)
    <=> ( v17183(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4169,axiom,
    ! [VarCurr] :
      ( v17183(VarCurr)
    <=> ( v17184(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1212,axiom,
    ! [VarCurr] :
      ( v17184(VarCurr)
    <=> ( v17140(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1211,axiom,
    ! [VarCurr] :
      ( v17177(VarCurr)
    <=> ( v17179(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4168,axiom,
    ! [VarCurr] :
      ( v17179(VarCurr)
    <=> ( v17180(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4167,axiom,
    ! [VarCurr] :
      ( v17180(VarCurr)
    <=> ( v17140(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4166,axiom,
    ! [VarCurr] :
      ( v17144(VarCurr)
    <=> ( v17146(VarCurr)
        | v17173(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4165,axiom,
    ! [VarCurr] :
      ( v17173(VarCurr)
    <=> ( v17175(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1210,axiom,
    ! [VarCurr] :
      ( v17175(VarCurr)
    <=> ( v17163(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4164,axiom,
    ! [VarCurr] :
      ( v17146(VarCurr)
    <=> ( v17147(VarCurr)
        | v17170(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4163,axiom,
    ! [VarCurr] :
      ( v17170(VarCurr)
    <=> ( v17172(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1209,axiom,
    ! [VarCurr] :
      ( v17172(VarCurr)
    <=> ( v17159(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4162,axiom,
    ! [VarCurr] :
      ( v17147(VarCurr)
    <=> ( v17148(VarCurr)
        | v17167(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4161,axiom,
    ! [VarCurr] :
      ( v17167(VarCurr)
    <=> ( v17169(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1208,axiom,
    ! [VarCurr] :
      ( v17169(VarCurr)
    <=> ( v17154(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4160,axiom,
    ! [VarCurr] :
      ( v17148(VarCurr)
    <=> ( v17149(VarCurr)
        | v17164(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4159,axiom,
    ! [VarCurr] :
      ( v17164(VarCurr)
    <=> ( v17166(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1207,axiom,
    ! [VarCurr] :
      ( v17166(VarCurr)
    <=> ( v17138(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4158,axiom,
    ! [VarCurr] :
      ( v17149(VarCurr)
    <=> ( v17150(VarCurr)
        | v17160(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4157,axiom,
    ! [VarCurr] :
      ( v17160(VarCurr)
    <=> ( v17162(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4156,axiom,
    ! [VarCurr] :
      ( v17162(VarCurr)
    <=> ( v17163(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1206,axiom,
    ! [VarCurr] :
      ( v17163(VarCurr)
    <=> ( v17155(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4155,axiom,
    ! [VarCurr] :
      ( v17150(VarCurr)
    <=> ( v17151(VarCurr)
        | v17156(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4154,axiom,
    ! [VarCurr] :
      ( v17156(VarCurr)
    <=> ( v17158(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4153,axiom,
    ! [VarCurr] :
      ( v17158(VarCurr)
    <=> ( v17159(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1205,axiom,
    ! [VarCurr] :
      ( v17159(VarCurr)
    <=> ( v17139(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4152,axiom,
    ! [VarCurr] :
      ( v17151(VarCurr)
    <=> ( v17153(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4151,axiom,
    ! [VarCurr] :
      ( v17153(VarCurr)
    <=> ( v17154(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4150,axiom,
    ! [VarCurr] :
      ( v17154(VarCurr)
    <=> ( v17155(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4149,axiom,
    ! [VarCurr] :
      ( v17155(VarCurr)
    <=> ( v17140(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4148,axiom,
    ! [VarCurr] :
      ( v17135(VarCurr)
    <=> ( v17137(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4147,axiom,
    ! [VarCurr] :
      ( v17137(VarCurr)
    <=> ( v17138(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4146,axiom,
    ! [VarCurr] :
      ( v17138(VarCurr)
    <=> ( v17139(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4145,axiom,
    ! [VarCurr] :
      ( v17139(VarCurr)
    <=> ( v17140(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4144,axiom,
    ! [VarCurr] :
      ( v17140(VarCurr)
    <=> ( v17141(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1204,axiom,
    ! [VarCurr] :
      ( v17141(VarCurr)
    <=> ( v17142(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1203,axiom,
    ! [VarCurr] :
      ( v17142(VarCurr)
    <=> ( v17143(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4143,axiom,
    ! [VarCurr] :
      ( v17143(VarCurr)
    <=> ( v17031(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4142,axiom,
    ! [VarCurr] :
      ( v17078(VarCurr)
    <=> ( v17080(VarCurr)
        | v17130(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4141,axiom,
    ! [VarCurr] :
      ( v17130(VarCurr)
    <=> ( v17132(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1202,axiom,
    ! [VarCurr] :
      ( v17132(VarCurr)
    <=> ( v17133(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1201,axiom,
    ! [VarCurr] :
      ( v17133(VarCurr)
    <=> ( v17134(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4140,axiom,
    ! [VarCurr] :
      ( v17134(VarCurr)
    <=> ( v17019(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4139,axiom,
    ! [VarCurr] :
      ( v17080(VarCurr)
    <=> ( v17081(VarCurr)
        | v17125(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4138,axiom,
    ! [VarCurr] :
      ( v17125(VarCurr)
    <=> ( v17127(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1200,axiom,
    ! [VarCurr] :
      ( v17127(VarCurr)
    <=> ( v17128(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1199,axiom,
    ! [VarCurr] :
      ( v17128(VarCurr)
    <=> ( v17129(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4137,axiom,
    ! [VarCurr] :
      ( v17129(VarCurr)
    <=> ( v17011(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4136,axiom,
    ! [VarCurr] :
      ( v17081(VarCurr)
    <=> ( v17082(VarCurr)
        | v17120(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4135,axiom,
    ! [VarCurr] :
      ( v17120(VarCurr)
    <=> ( v17122(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1198,axiom,
    ! [VarCurr] :
      ( v17122(VarCurr)
    <=> ( v17123(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1197,axiom,
    ! [VarCurr] :
      ( v17123(VarCurr)
    <=> ( v17124(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4134,axiom,
    ! [VarCurr] :
      ( v17124(VarCurr)
    <=> ( v17003(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4133,axiom,
    ! [VarCurr] :
      ( v17082(VarCurr)
    <=> ( v17083(VarCurr)
        | v17115(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4132,axiom,
    ! [VarCurr] :
      ( v17115(VarCurr)
    <=> ( v17117(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1196,axiom,
    ! [VarCurr] :
      ( v17117(VarCurr)
    <=> ( v17118(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1195,axiom,
    ! [VarCurr] :
      ( v17118(VarCurr)
    <=> ( v17119(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4131,axiom,
    ! [VarCurr] :
      ( v17119(VarCurr)
    <=> ( v16995(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4130,axiom,
    ! [VarCurr] :
      ( v17083(VarCurr)
    <=> ( v17084(VarCurr)
        | v17107(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4129,axiom,
    ! [VarCurr] :
      ( v17107(VarCurr)
    <=> ( v17109(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1194,axiom,
    ! [VarCurr] :
      ( v17109(VarCurr)
    <=> ( v17110(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1193,axiom,
    ! [VarCurr] :
      ( v17110(VarCurr)
    <=> ( v17111(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4128,axiom,
    ! [VarCurr] :
      ( v17111(VarCurr)
    <=> ( v17112(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4127,axiom,
    ! [VarCurr] :
      ( v17112(VarCurr)
    <=> ( v17113(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1192,axiom,
    ! [VarCurr] :
      ( v17113(VarCurr)
    <=> ( v17114(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1191,axiom,
    ! [VarCurr] :
      ( v17114(VarCurr)
    <=> ( v15405(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4126,axiom,
    ! [VarCurr] :
      ( v17084(VarCurr)
    <=> ( v17085(VarCurr)
        | v17102(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4125,axiom,
    ! [VarCurr] :
      ( v17102(VarCurr)
    <=> ( v17104(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1190,axiom,
    ! [VarCurr] :
      ( v17104(VarCurr)
    <=> ( v17105(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1189,axiom,
    ! [VarCurr] :
      ( v17105(VarCurr)
    <=> ( v17106(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4124,axiom,
    ! [VarCurr] :
      ( v17106(VarCurr)
    <=> ( v16987(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4123,axiom,
    ! [VarCurr] :
      ( v17085(VarCurr)
    <=> ( v17086(VarCurr)
        | v17097(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4122,axiom,
    ! [VarCurr] :
      ( v17097(VarCurr)
    <=> ( v17099(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1188,axiom,
    ! [VarCurr] :
      ( v17099(VarCurr)
    <=> ( v17100(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1187,axiom,
    ! [VarCurr] :
      ( v17100(VarCurr)
    <=> ( v17101(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4121,axiom,
    ! [VarCurr] :
      ( v17101(VarCurr)
    <=> ( v16979(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4120,axiom,
    ! [VarCurr] :
      ( v17086(VarCurr)
    <=> ( v17087(VarCurr)
        | v17092(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4119,axiom,
    ! [VarCurr] :
      ( v17092(VarCurr)
    <=> ( v17094(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1186,axiom,
    ! [VarCurr] :
      ( v17094(VarCurr)
    <=> ( v17095(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1185,axiom,
    ! [VarCurr] :
      ( v17095(VarCurr)
    <=> ( v17096(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4118,axiom,
    ! [VarCurr] :
      ( v17096(VarCurr)
    <=> ( v16971(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4117,axiom,
    ! [VarCurr] :
      ( v17087(VarCurr)
    <=> ( v17089(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1184,axiom,
    ! [VarCurr] :
      ( v17089(VarCurr)
    <=> ( v17090(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1183,axiom,
    ! [VarCurr] :
      ( v17090(VarCurr)
    <=> ( v17091(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4116,axiom,
    ! [VarCurr] :
      ( v17091(VarCurr)
    <=> ( v16963(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4115,axiom,
    ! [VarCurr] :
      ( v17034(VarCurr)
    <=> ( v17036(VarCurr)
        | v17076(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1182,axiom,
    ! [VarCurr] :
      ( v17076(VarCurr)
    <=> ( v17056(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4114,axiom,
    ! [VarCurr] :
      ( v17036(VarCurr)
    <=> ( v17037(VarCurr)
        | v17074(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1181,axiom,
    ! [VarCurr] :
      ( v17074(VarCurr)
    <=> ( v17052(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4113,axiom,
    ! [VarCurr] :
      ( v17037(VarCurr)
    <=> ( v17038(VarCurr)
        | v17072(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1180,axiom,
    ! [VarCurr] :
      ( v17072(VarCurr)
    <=> ( v17047(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4112,axiom,
    ! [VarCurr] :
      ( v17038(VarCurr)
    <=> ( v17039(VarCurr)
        | v17070(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1179,axiom,
    ! [VarCurr] :
      ( v17070(VarCurr)
    <=> ( v17024(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4111,axiom,
    ! [VarCurr] :
      ( v17039(VarCurr)
    <=> ( v17040(VarCurr)
        | v17067(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4110,axiom,
    ! [VarCurr] :
      ( v17067(VarCurr)
    <=> ( v17069(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1178,axiom,
    ! [VarCurr] :
      ( v17069(VarCurr)
    <=> ( v17057(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4109,axiom,
    ! [VarCurr] :
      ( v17040(VarCurr)
    <=> ( v17041(VarCurr)
        | v17064(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4108,axiom,
    ! [VarCurr] :
      ( v17064(VarCurr)
    <=> ( v17066(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1177,axiom,
    ! [VarCurr] :
      ( v17066(VarCurr)
    <=> ( v17053(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4107,axiom,
    ! [VarCurr] :
      ( v17041(VarCurr)
    <=> ( v17042(VarCurr)
        | v17061(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4106,axiom,
    ! [VarCurr] :
      ( v17061(VarCurr)
    <=> ( v17063(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1176,axiom,
    ! [VarCurr] :
      ( v17063(VarCurr)
    <=> ( v17048(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4105,axiom,
    ! [VarCurr] :
      ( v17042(VarCurr)
    <=> ( v17043(VarCurr)
        | v17058(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4104,axiom,
    ! [VarCurr] :
      ( v17058(VarCurr)
    <=> ( v17060(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1175,axiom,
    ! [VarCurr] :
      ( v17060(VarCurr)
    <=> ( v17025(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4103,axiom,
    ! [VarCurr] :
      ( v17043(VarCurr)
    <=> ( v17044(VarCurr)
        | v17054(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4102,axiom,
    ! [VarCurr] :
      ( v17054(VarCurr)
    <=> ( v17056(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4101,axiom,
    ! [VarCurr] :
      ( v17056(VarCurr)
    <=> ( v17057(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1174,axiom,
    ! [VarCurr] :
      ( v17057(VarCurr)
    <=> ( v17049(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4100,axiom,
    ! [VarCurr] :
      ( v17044(VarCurr)
    <=> ( v17045(VarCurr)
        | v17050(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4099,axiom,
    ! [VarCurr] :
      ( v17050(VarCurr)
    <=> ( v17052(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4098,axiom,
    ! [VarCurr] :
      ( v17052(VarCurr)
    <=> ( v17053(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1173,axiom,
    ! [VarCurr] :
      ( v17053(VarCurr)
    <=> ( v17026(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4097,axiom,
    ! [VarCurr] :
      ( v17045(VarCurr)
    <=> ( v17047(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4096,axiom,
    ! [VarCurr] :
      ( v17047(VarCurr)
    <=> ( v17048(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4095,axiom,
    ! [VarCurr] :
      ( v17048(VarCurr)
    <=> ( v17049(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4094,axiom,
    ! [VarCurr] :
      ( v17049(VarCurr)
    <=> ( v17027(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4093,axiom,
    ! [VarCurr] :
      ( v17022(VarCurr)
    <=> ( v17024(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4092,axiom,
    ! [VarCurr] :
      ( v17024(VarCurr)
    <=> ( v17025(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4091,axiom,
    ! [VarCurr] :
      ( v17025(VarCurr)
    <=> ( v17026(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4090,axiom,
    ! [VarCurr] :
      ( v17026(VarCurr)
    <=> ( v17027(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4089,axiom,
    ! [VarCurr] :
      ( v17027(VarCurr)
    <=> ( v17028(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1172,axiom,
    ! [VarCurr] :
      ( v17028(VarCurr)
    <=> ( v17029(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4088,axiom,
    ! [VarCurr] :
      ( v17029(VarCurr)
    <=> ( v17030(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4087,axiom,
    ! [VarCurr] :
      ( v17030(VarCurr)
    <=> ( v17031(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4086,axiom,
    ! [VarCurr] :
      ( v17031(VarCurr)
    <=> ( v17032(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1171,axiom,
    ! [VarCurr] :
      ( v17032(VarCurr)
    <=> ( v17033(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1170,axiom,
    ! [VarCurr] :
      ( v17033(VarCurr)
    <=> ( v15278(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4085,axiom,
    ! [VarCurr] :
      ( v16950(VarCurr)
    <=> ( v16952(VarCurr)
        | v17014(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4084,axiom,
    ! [VarCurr] :
      ( v17014(VarCurr)
    <=> ( v17016(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1169,axiom,
    ! [VarCurr] :
      ( v17016(VarCurr)
    <=> ( v17017(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4083,axiom,
    ! [VarCurr] :
      ( v17017(VarCurr)
    <=> ( v17018(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4082,axiom,
    ! [VarCurr] :
      ( v17018(VarCurr)
    <=> ( v17019(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4081,axiom,
    ! [VarCurr] :
      ( v17019(VarCurr)
    <=> ( v17020(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1168,axiom,
    ! [VarCurr] :
      ( v17020(VarCurr)
    <=> ( v17021(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1167,axiom,
    ! [VarCurr] :
      ( v17021(VarCurr)
    <=> ( v15154(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4080,axiom,
    ! [VarCurr] :
      ( v16952(VarCurr)
    <=> ( v16953(VarCurr)
        | v17006(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4079,axiom,
    ! [VarCurr] :
      ( v17006(VarCurr)
    <=> ( v17008(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1166,axiom,
    ! [VarCurr] :
      ( v17008(VarCurr)
    <=> ( v17009(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4078,axiom,
    ! [VarCurr] :
      ( v17009(VarCurr)
    <=> ( v17010(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4077,axiom,
    ! [VarCurr] :
      ( v17010(VarCurr)
    <=> ( v17011(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4076,axiom,
    ! [VarCurr] :
      ( v17011(VarCurr)
    <=> ( v17012(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1165,axiom,
    ! [VarCurr] :
      ( v17012(VarCurr)
    <=> ( v17013(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1164,axiom,
    ! [VarCurr] :
      ( v17013(VarCurr)
    <=> ( v15141(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4075,axiom,
    ! [VarCurr] :
      ( v16953(VarCurr)
    <=> ( v16954(VarCurr)
        | v16998(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4074,axiom,
    ! [VarCurr] :
      ( v16998(VarCurr)
    <=> ( v17000(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1163,axiom,
    ! [VarCurr] :
      ( v17000(VarCurr)
    <=> ( v17001(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4073,axiom,
    ! [VarCurr] :
      ( v17001(VarCurr)
    <=> ( v17002(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4072,axiom,
    ! [VarCurr] :
      ( v17002(VarCurr)
    <=> ( v17003(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4071,axiom,
    ! [VarCurr] :
      ( v17003(VarCurr)
    <=> ( v17004(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1162,axiom,
    ! [VarCurr] :
      ( v17004(VarCurr)
    <=> ( v17005(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1161,axiom,
    ! [VarCurr] :
      ( v17005(VarCurr)
    <=> ( v15127(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4070,axiom,
    ! [VarCurr] :
      ( v16954(VarCurr)
    <=> ( v16955(VarCurr)
        | v16990(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4069,axiom,
    ! [VarCurr] :
      ( v16990(VarCurr)
    <=> ( v16992(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1160,axiom,
    ! [VarCurr] :
      ( v16992(VarCurr)
    <=> ( v16993(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4068,axiom,
    ! [VarCurr] :
      ( v16993(VarCurr)
    <=> ( v16994(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4067,axiom,
    ! [VarCurr] :
      ( v16994(VarCurr)
    <=> ( v16995(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4066,axiom,
    ! [VarCurr] :
      ( v16995(VarCurr)
    <=> ( v16996(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1159,axiom,
    ! [VarCurr] :
      ( v16996(VarCurr)
    <=> ( v16997(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1158,axiom,
    ! [VarCurr] :
      ( v16997(VarCurr)
    <=> ( v15118(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4065,axiom,
    ! [VarCurr] :
      ( v16955(VarCurr)
    <=> ( v16956(VarCurr)
        | v16982(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4064,axiom,
    ! [VarCurr] :
      ( v16982(VarCurr)
    <=> ( v16984(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1157,axiom,
    ! [VarCurr] :
      ( v16984(VarCurr)
    <=> ( v16985(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4063,axiom,
    ! [VarCurr] :
      ( v16985(VarCurr)
    <=> ( v16986(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4062,axiom,
    ! [VarCurr] :
      ( v16986(VarCurr)
    <=> ( v16987(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4061,axiom,
    ! [VarCurr] :
      ( v16987(VarCurr)
    <=> ( v16988(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1156,axiom,
    ! [VarCurr] :
      ( v16988(VarCurr)
    <=> ( v16989(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1155,axiom,
    ! [VarCurr] :
      ( v16989(VarCurr)
    <=> ( v15109(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4060,axiom,
    ! [VarCurr] :
      ( v16956(VarCurr)
    <=> ( v16957(VarCurr)
        | v16974(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4059,axiom,
    ! [VarCurr] :
      ( v16974(VarCurr)
    <=> ( v16976(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1154,axiom,
    ! [VarCurr] :
      ( v16976(VarCurr)
    <=> ( v16977(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4058,axiom,
    ! [VarCurr] :
      ( v16977(VarCurr)
    <=> ( v16978(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4057,axiom,
    ! [VarCurr] :
      ( v16978(VarCurr)
    <=> ( v16979(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4056,axiom,
    ! [VarCurr] :
      ( v16979(VarCurr)
    <=> ( v16980(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1153,axiom,
    ! [VarCurr] :
      ( v16980(VarCurr)
    <=> ( v16981(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1152,axiom,
    ! [VarCurr] :
      ( v16981(VarCurr)
    <=> ( v15100(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4055,axiom,
    ! [VarCurr] :
      ( v16957(VarCurr)
    <=> ( v16958(VarCurr)
        | v16966(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4054,axiom,
    ! [VarCurr] :
      ( v16966(VarCurr)
    <=> ( v16968(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1151,axiom,
    ! [VarCurr] :
      ( v16968(VarCurr)
    <=> ( v16969(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4053,axiom,
    ! [VarCurr] :
      ( v16969(VarCurr)
    <=> ( v16970(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4052,axiom,
    ! [VarCurr] :
      ( v16970(VarCurr)
    <=> ( v16971(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4051,axiom,
    ! [VarCurr] :
      ( v16971(VarCurr)
    <=> ( v16972(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1150,axiom,
    ! [VarCurr] :
      ( v16972(VarCurr)
    <=> ( v16973(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1149,axiom,
    ! [VarCurr] :
      ( v16973(VarCurr)
    <=> ( v15091(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4050,axiom,
    ! [VarCurr] :
      ( v16958(VarCurr)
    <=> ( v16960(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1148,axiom,
    ! [VarCurr] :
      ( v16960(VarCurr)
    <=> ( v16961(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4049,axiom,
    ! [VarCurr] :
      ( v16961(VarCurr)
    <=> ( v16962(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4048,axiom,
    ! [VarCurr] :
      ( v16962(VarCurr)
    <=> ( v16963(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4047,axiom,
    ! [VarCurr] :
      ( v16963(VarCurr)
    <=> ( v16964(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1147,axiom,
    ! [VarCurr] :
      ( v16964(VarCurr)
    <=> ( v16965(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1146,axiom,
    ! [VarCurr] :
      ( v16965(VarCurr)
    <=> ( v15082(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4046,axiom,
    ! [VarCurr] :
      ( v16941(VarCurr)
    <=> ( v16942(VarCurr)
        | v16946(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1145,axiom,
    ! [VarCurr] :
      ( v16946(VarCurr)
    <=> ( v16948(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4045,axiom,
    ! [VarCurr] :
      ( v16948(VarCurr)
    <=> ( v16949(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1144,axiom,
    ! [VarCurr] :
      ( v16949(VarCurr)
    <=> ( v16906(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1143,axiom,
    ! [VarCurr] :
      ( v16942(VarCurr)
    <=> ( v16944(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4044,axiom,
    ! [VarCurr] :
      ( v16944(VarCurr)
    <=> ( v16945(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4043,axiom,
    ! [VarCurr] :
      ( v16945(VarCurr)
    <=> ( v16906(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4042,axiom,
    ! [VarCurr] :
      ( v16909(VarCurr)
    <=> ( v16911(VarCurr)
        | v16938(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4041,axiom,
    ! [VarCurr] :
      ( v16938(VarCurr)
    <=> ( v16940(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1142,axiom,
    ! [VarCurr] :
      ( v16940(VarCurr)
    <=> ( v16928(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4040,axiom,
    ! [VarCurr] :
      ( v16911(VarCurr)
    <=> ( v16912(VarCurr)
        | v16935(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4039,axiom,
    ! [VarCurr] :
      ( v16935(VarCurr)
    <=> ( v16937(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1141,axiom,
    ! [VarCurr] :
      ( v16937(VarCurr)
    <=> ( v16924(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4038,axiom,
    ! [VarCurr] :
      ( v16912(VarCurr)
    <=> ( v16913(VarCurr)
        | v16932(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4037,axiom,
    ! [VarCurr] :
      ( v16932(VarCurr)
    <=> ( v16934(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1140,axiom,
    ! [VarCurr] :
      ( v16934(VarCurr)
    <=> ( v16919(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4036,axiom,
    ! [VarCurr] :
      ( v16913(VarCurr)
    <=> ( v16914(VarCurr)
        | v16929(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4035,axiom,
    ! [VarCurr] :
      ( v16929(VarCurr)
    <=> ( v16931(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1139,axiom,
    ! [VarCurr] :
      ( v16931(VarCurr)
    <=> ( v16904(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4034,axiom,
    ! [VarCurr] :
      ( v16914(VarCurr)
    <=> ( v16915(VarCurr)
        | v16925(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4033,axiom,
    ! [VarCurr] :
      ( v16925(VarCurr)
    <=> ( v16927(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4032,axiom,
    ! [VarCurr] :
      ( v16927(VarCurr)
    <=> ( v16928(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1138,axiom,
    ! [VarCurr] :
      ( v16928(VarCurr)
    <=> ( v16920(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4031,axiom,
    ! [VarCurr] :
      ( v16915(VarCurr)
    <=> ( v16916(VarCurr)
        | v16921(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4030,axiom,
    ! [VarCurr] :
      ( v16921(VarCurr)
    <=> ( v16923(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4029,axiom,
    ! [VarCurr] :
      ( v16923(VarCurr)
    <=> ( v16924(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1137,axiom,
    ! [VarCurr] :
      ( v16924(VarCurr)
    <=> ( v16905(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4028,axiom,
    ! [VarCurr] :
      ( v16916(VarCurr)
    <=> ( v16918(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4027,axiom,
    ! [VarCurr] :
      ( v16918(VarCurr)
    <=> ( v16919(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4026,axiom,
    ! [VarCurr] :
      ( v16919(VarCurr)
    <=> ( v16920(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4025,axiom,
    ! [VarCurr] :
      ( v16920(VarCurr)
    <=> ( v16906(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4024,axiom,
    ! [VarCurr] :
      ( v16901(VarCurr)
    <=> ( v16903(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4023,axiom,
    ! [VarCurr] :
      ( v16903(VarCurr)
    <=> ( v16904(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4022,axiom,
    ! [VarCurr] :
      ( v16904(VarCurr)
    <=> ( v16905(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4021,axiom,
    ! [VarCurr] :
      ( v16905(VarCurr)
    <=> ( v16906(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1136,axiom,
    ! [VarCurr] :
      ( v16906(VarCurr)
    <=> ( v16907(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1135,axiom,
    ! [VarCurr] :
      ( v16907(VarCurr)
    <=> ( v16908(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1134,axiom,
    ! [VarCurr] :
      ( v16908(VarCurr)
    <=> ( v16754(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4020,axiom,
    ! [VarCurr] :
      ( v16851(VarCurr)
    <=> ( v16853(VarCurr)
        | v16898(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1133,axiom,
    ! [VarCurr] :
      ( v16898(VarCurr)
    <=> ( v16900(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1132,axiom,
    ! [VarCurr] :
      ( v16900(VarCurr)
    <=> ( v16582(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4019,axiom,
    ! [VarCurr] :
      ( v16853(VarCurr)
    <=> ( v16854(VarCurr)
        | v16896(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1131,axiom,
    ! [VarCurr] :
      ( v16896(VarCurr)
    <=> ( v16254(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4018,axiom,
    ! [VarCurr] :
      ( v16854(VarCurr)
    <=> ( v16855(VarCurr)
        | v16894(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1130,axiom,
    ! [VarCurr] :
      ( v16894(VarCurr)
    <=> ( v16246(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4017,axiom,
    ! [VarCurr] :
      ( v16855(VarCurr)
    <=> ( v16856(VarCurr)
        | v16892(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1129,axiom,
    ! [VarCurr] :
      ( v16892(VarCurr)
    <=> ( v16242(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4016,axiom,
    ! [VarCurr] :
      ( v16856(VarCurr)
    <=> ( v16857(VarCurr)
        | v16890(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1128,axiom,
    ! [VarCurr] :
      ( v16890(VarCurr)
    <=> ( v16238(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4015,axiom,
    ! [VarCurr] :
      ( v16857(VarCurr)
    <=> ( v16858(VarCurr)
        | v16888(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1127,axiom,
    ! [VarCurr] :
      ( v16888(VarCurr)
    <=> ( v16234(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4014,axiom,
    ! [VarCurr] :
      ( v16858(VarCurr)
    <=> ( v16859(VarCurr)
        | v16877(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1126,axiom,
    ! [VarCurr] :
      ( v16877(VarCurr)
    <=> ( v16879(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1125,axiom,
    ! [VarCurr] :
      ( v16879(VarCurr)
    <=> ( v16880(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1124,axiom,
    ! [VarCurr] :
      ( v16880(VarCurr)
    <=> ( v16881(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4013,axiom,
    ! [VarCurr] :
      ( v16881(VarCurr)
    <=> ( v16882(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4012,axiom,
    ! [VarCurr] :
      ( v16882(VarCurr)
    <=> ( v16883(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1123,axiom,
    ! [VarCurr] :
      ( v16883(VarCurr)
    <=> ( v16884(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1122,axiom,
    ! [VarCurr] :
      ( v16884(VarCurr)
    <=> ( v16885(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4011,axiom,
    ! [VarCurr] :
      ( v16885(VarCurr)
    <=> ( v16886(VarCurr)
        & v14055(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1121,axiom,
    ! [VarCurr] :
      ( v16886(VarCurr)
    <=> ( v16887(VarCurr)
        & v13075(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4010,axiom,
    ! [VarCurr] :
      ( v16887(VarCurr)
    <=> ( v14553(VarCurr)
        & v14036(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4009,axiom,
    ! [VarCurr] :
      ( v16859(VarCurr)
    <=> ( v16860(VarCurr)
        | v16874(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1120,axiom,
    ! [VarCurr] :
      ( v16874(VarCurr)
    <=> ( v16876(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1119,axiom,
    ! [VarCurr] :
      ( v16876(VarCurr)
    <=> ( v16555(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4008,axiom,
    ! [VarCurr] :
      ( v16860(VarCurr)
    <=> ( v16861(VarCurr)
        | v16872(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1118,axiom,
    ! [VarCurr] :
      ( v16872(VarCurr)
    <=> ( v16230(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4007,axiom,
    ! [VarCurr] :
      ( v16861(VarCurr)
    <=> ( v16862(VarCurr)
        | v16870(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1117,axiom,
    ! [VarCurr] :
      ( v16870(VarCurr)
    <=> ( v16226(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4006,axiom,
    ! [VarCurr] :
      ( v16862(VarCurr)
    <=> ( v16863(VarCurr)
        | v16868(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1116,axiom,
    ! [VarCurr] :
      ( v16868(VarCurr)
    <=> ( v16222(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4005,axiom,
    ! [VarCurr] :
      ( v16863(VarCurr)
    <=> ( v16864(VarCurr)
        | v16866(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1115,axiom,
    ! [VarCurr] :
      ( v16866(VarCurr)
    <=> ( v16218(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1114,axiom,
    ! [VarCurr] :
      ( v16864(VarCurr)
    <=> ( v16214(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4004,axiom,
    ! [VarCurr] :
      ( v16807(VarCurr)
    <=> ( v16809(VarCurr)
        | v16849(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1113,axiom,
    ! [VarCurr] :
      ( v16849(VarCurr)
    <=> ( v16829(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4003,axiom,
    ! [VarCurr] :
      ( v16809(VarCurr)
    <=> ( v16810(VarCurr)
        | v16847(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1112,axiom,
    ! [VarCurr] :
      ( v16847(VarCurr)
    <=> ( v16825(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4002,axiom,
    ! [VarCurr] :
      ( v16810(VarCurr)
    <=> ( v16811(VarCurr)
        | v16845(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1111,axiom,
    ! [VarCurr] :
      ( v16845(VarCurr)
    <=> ( v16820(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4001,axiom,
    ! [VarCurr] :
      ( v16811(VarCurr)
    <=> ( v16812(VarCurr)
        | v16843(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1110,axiom,
    ! [VarCurr] :
      ( v16843(VarCurr)
    <=> ( v16800(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4000,axiom,
    ! [VarCurr] :
      ( v16812(VarCurr)
    <=> ( v16813(VarCurr)
        | v16840(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3999,axiom,
    ! [VarCurr] :
      ( v16840(VarCurr)
    <=> ( v16842(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1109,axiom,
    ! [VarCurr] :
      ( v16842(VarCurr)
    <=> ( v16830(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3998,axiom,
    ! [VarCurr] :
      ( v16813(VarCurr)
    <=> ( v16814(VarCurr)
        | v16837(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3997,axiom,
    ! [VarCurr] :
      ( v16837(VarCurr)
    <=> ( v16839(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1108,axiom,
    ! [VarCurr] :
      ( v16839(VarCurr)
    <=> ( v16826(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3996,axiom,
    ! [VarCurr] :
      ( v16814(VarCurr)
    <=> ( v16815(VarCurr)
        | v16834(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3995,axiom,
    ! [VarCurr] :
      ( v16834(VarCurr)
    <=> ( v16836(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1107,axiom,
    ! [VarCurr] :
      ( v16836(VarCurr)
    <=> ( v16821(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3994,axiom,
    ! [VarCurr] :
      ( v16815(VarCurr)
    <=> ( v16816(VarCurr)
        | v16831(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3993,axiom,
    ! [VarCurr] :
      ( v16831(VarCurr)
    <=> ( v16833(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1106,axiom,
    ! [VarCurr] :
      ( v16833(VarCurr)
    <=> ( v16801(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3992,axiom,
    ! [VarCurr] :
      ( v16816(VarCurr)
    <=> ( v16817(VarCurr)
        | v16827(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3991,axiom,
    ! [VarCurr] :
      ( v16827(VarCurr)
    <=> ( v16829(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3990,axiom,
    ! [VarCurr] :
      ( v16829(VarCurr)
    <=> ( v16830(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1105,axiom,
    ! [VarCurr] :
      ( v16830(VarCurr)
    <=> ( v16822(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3989,axiom,
    ! [VarCurr] :
      ( v16817(VarCurr)
    <=> ( v16818(VarCurr)
        | v16823(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3988,axiom,
    ! [VarCurr] :
      ( v16823(VarCurr)
    <=> ( v16825(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3987,axiom,
    ! [VarCurr] :
      ( v16825(VarCurr)
    <=> ( v16826(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1104,axiom,
    ! [VarCurr] :
      ( v16826(VarCurr)
    <=> ( v16802(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3986,axiom,
    ! [VarCurr] :
      ( v16818(VarCurr)
    <=> ( v16820(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3985,axiom,
    ! [VarCurr] :
      ( v16820(VarCurr)
    <=> ( v16821(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3984,axiom,
    ! [VarCurr] :
      ( v16821(VarCurr)
    <=> ( v16822(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3983,axiom,
    ! [VarCurr] :
      ( v16822(VarCurr)
    <=> ( v16803(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3982,axiom,
    ! [VarCurr] :
      ( v16798(VarCurr)
    <=> ( v16800(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3981,axiom,
    ! [VarCurr] :
      ( v16800(VarCurr)
    <=> ( v16801(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3980,axiom,
    ! [VarCurr] :
      ( v16801(VarCurr)
    <=> ( v16802(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3979,axiom,
    ! [VarCurr] :
      ( v16802(VarCurr)
    <=> ( v16803(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1103,axiom,
    ! [VarCurr] :
      ( v16803(VarCurr)
    <=> ( v16804(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1102,axiom,
    ! [VarCurr] :
      ( v16804(VarCurr)
    <=> ( v16805(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1101,axiom,
    ! [VarCurr] :
      ( v16805(VarCurr)
    <=> ( v16806(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3978,axiom,
    ! [VarCurr] :
      ( v16806(VarCurr)
    <=> ( v16755(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3977,axiom,
    ! [VarCurr] :
      ( v16758(VarCurr)
    <=> ( v16760(VarCurr)
        | v16795(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1100,axiom,
    ! [VarCurr] :
      ( v16795(VarCurr)
    <=> ( v16797(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1099,axiom,
    ! [VarCurr] :
      ( v16797(VarCurr)
    <=> ( v16480(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3976,axiom,
    ! [VarCurr] :
      ( v16760(VarCurr)
    <=> ( v16761(VarCurr)
        | v16793(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1098,axiom,
    ! [VarCurr] :
      ( v16793(VarCurr)
    <=> ( v16156(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3975,axiom,
    ! [VarCurr] :
      ( v16761(VarCurr)
    <=> ( v16762(VarCurr)
        | v16791(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1097,axiom,
    ! [VarCurr] :
      ( v16791(VarCurr)
    <=> ( v16147(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3974,axiom,
    ! [VarCurr] :
      ( v16762(VarCurr)
    <=> ( v16763(VarCurr)
        | v16789(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1096,axiom,
    ! [VarCurr] :
      ( v16789(VarCurr)
    <=> ( v16142(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3973,axiom,
    ! [VarCurr] :
      ( v16763(VarCurr)
    <=> ( v16764(VarCurr)
        | v16787(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1095,axiom,
    ! [VarCurr] :
      ( v16787(VarCurr)
    <=> ( v16137(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3972,axiom,
    ! [VarCurr] :
      ( v16764(VarCurr)
    <=> ( v16765(VarCurr)
        | v16785(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1094,axiom,
    ! [VarCurr] :
      ( v16785(VarCurr)
    <=> ( v16132(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3971,axiom,
    ! [VarCurr] :
      ( v16765(VarCurr)
    <=> ( v16766(VarCurr)
        | v16781(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1093,axiom,
    ! [VarCurr] :
      ( v16781(VarCurr)
    <=> ( v16783(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1092,axiom,
    ! [VarCurr] :
      ( v16783(VarCurr)
    <=> ( v16784(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1091,axiom,
    ! [VarCurr] :
      ( v16784(VarCurr)
    <=> ( v16654(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3970,axiom,
    ! [VarCurr] :
      ( v16766(VarCurr)
    <=> ( v16767(VarCurr)
        | v16778(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1090,axiom,
    ! [VarCurr] :
      ( v16778(VarCurr)
    <=> ( v16780(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1089,axiom,
    ! [VarCurr] :
      ( v16780(VarCurr)
    <=> ( v16457(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3969,axiom,
    ! [VarCurr] :
      ( v16767(VarCurr)
    <=> ( v16768(VarCurr)
        | v16776(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1088,axiom,
    ! [VarCurr] :
      ( v16776(VarCurr)
    <=> ( v16127(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3968,axiom,
    ! [VarCurr] :
      ( v16768(VarCurr)
    <=> ( v16769(VarCurr)
        | v16774(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1087,axiom,
    ! [VarCurr] :
      ( v16774(VarCurr)
    <=> ( v16122(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3967,axiom,
    ! [VarCurr] :
      ( v16769(VarCurr)
    <=> ( v16770(VarCurr)
        | v16772(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1086,axiom,
    ! [VarCurr] :
      ( v16772(VarCurr)
    <=> ( v16117(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1085,axiom,
    ! [VarCurr] :
      ( v16770(VarCurr)
    <=> ( v16112(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1084,axiom,
    ! [VarCurr] :
      ( v16750(VarCurr)
    <=> ( v16752(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1083,axiom,
    ! [VarCurr] :
      ( v16752(VarCurr)
    <=> ( v16753(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3966,axiom,
    ! [VarCurr] :
      ( v16753(VarCurr)
    <=> ( v16754(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3965,axiom,
    ! [VarCurr] :
      ( v16754(VarCurr)
    <=> ( v16755(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3964,axiom,
    ! [VarCurr] :
      ( v16755(VarCurr)
    <=> ( v16756(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1082,axiom,
    ! [VarCurr] :
      ( v16756(VarCurr)
    <=> ( v16757(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1081,axiom,
    ! [VarCurr] :
      ( v16757(VarCurr)
    <=> ( v15065(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1080,axiom,
    ! [VarCurr] :
      ( v16747(VarCurr)
    <=> ( v16749(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1079,axiom,
    ! [VarCurr] :
      ( v16749(VarCurr)
    <=> ( v16427(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3963,axiom,
    ! [VarCurr] :
      ( v16712(VarCurr)
    <=> ( v16714(VarCurr)
        | v16745(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1078,axiom,
    ! [VarCurr] :
      ( v16745(VarCurr)
    <=> ( v16096(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3962,axiom,
    ! [VarCurr] :
      ( v16714(VarCurr)
    <=> ( v16715(VarCurr)
        | v16743(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1077,axiom,
    ! [VarCurr] :
      ( v16743(VarCurr)
    <=> ( v16088(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3961,axiom,
    ! [VarCurr] :
      ( v16715(VarCurr)
    <=> ( v16716(VarCurr)
        | v16741(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1076,axiom,
    ! [VarCurr] :
      ( v16741(VarCurr)
    <=> ( v16080(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3960,axiom,
    ! [VarCurr] :
      ( v16716(VarCurr)
    <=> ( v16717(VarCurr)
        | v16739(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1075,axiom,
    ! [VarCurr] :
      ( v16739(VarCurr)
    <=> ( v16071(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3959,axiom,
    ! [VarCurr] :
      ( v16717(VarCurr)
    <=> ( v16718(VarCurr)
        | v16737(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1074,axiom,
    ! [VarCurr] :
      ( v16737(VarCurr)
    <=> ( v16063(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3958,axiom,
    ! [VarCurr] :
      ( v16718(VarCurr)
    <=> ( v16719(VarCurr)
        | v16733(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1073,axiom,
    ! [VarCurr] :
      ( v16733(VarCurr)
    <=> ( v16735(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1072,axiom,
    ! [VarCurr] :
      ( v16735(VarCurr)
    <=> ( v16736(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3957,axiom,
    ! [VarCurr] :
      ( v16736(VarCurr)
    <=> ( v16556(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3956,axiom,
    ! [VarCurr] :
      ( v16719(VarCurr)
    <=> ( v16720(VarCurr)
        | v16731(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1071,axiom,
    ! [VarCurr] :
      ( v16731(VarCurr)
    <=> ( v16055(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3955,axiom,
    ! [VarCurr] :
      ( v16720(VarCurr)
    <=> ( v16721(VarCurr)
        | v16729(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1070,axiom,
    ! [VarCurr] :
      ( v16729(VarCurr)
    <=> ( v16047(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3954,axiom,
    ! [VarCurr] :
      ( v16721(VarCurr)
    <=> ( v16722(VarCurr)
        | v16727(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1069,axiom,
    ! [VarCurr] :
      ( v16727(VarCurr)
    <=> ( v16039(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3953,axiom,
    ! [VarCurr] :
      ( v16722(VarCurr)
    <=> ( v16723(VarCurr)
        | v16725(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1068,axiom,
    ! [VarCurr] :
      ( v16725(VarCurr)
    <=> ( v16031(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1067,axiom,
    ! [VarCurr] :
      ( v16723(VarCurr)
    <=> ( v16023(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3952,axiom,
    ! [VarCurr] :
      ( v16694(VarCurr)
    <=> ( v16696(VarCurr)
        | v16709(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1066,axiom,
    ! [VarCurr] :
      ( v16709(VarCurr)
    <=> ( v16711(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3951,axiom,
    ! [VarCurr] :
      ( v16711(VarCurr)
    <=> ( v16705(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3950,axiom,
    ! [VarCurr] :
      ( v16696(VarCurr)
    <=> ( v16697(VarCurr)
        | v16706(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1065,axiom,
    ! [VarCurr] :
      ( v16706(VarCurr)
    <=> ( v16708(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3949,axiom,
    ! [VarCurr] :
      ( v16708(VarCurr)
    <=> ( v16701(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3948,axiom,
    ! [VarCurr] :
      ( v16697(VarCurr)
    <=> ( v16698(VarCurr)
        | v16702(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3947,axiom,
    ! [VarCurr] :
      ( v16702(VarCurr)
    <=> ( v16704(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1064,axiom,
    ! [VarCurr] :
      ( v16704(VarCurr)
    <=> ( v16705(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1063,axiom,
    ! [VarCurr] :
      ( v16705(VarCurr)
    <=> ( v16675(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3946,axiom,
    ! [VarCurr] :
      ( v16698(VarCurr)
    <=> ( v16700(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1062,axiom,
    ! [VarCurr] :
      ( v16700(VarCurr)
    <=> ( v16701(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3945,axiom,
    ! [VarCurr] :
      ( v16701(VarCurr)
    <=> ( v16675(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3944,axiom,
    ! [VarCurr] :
      ( v16678(VarCurr)
    <=> ( v16680(VarCurr)
        | v16690(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3943,axiom,
    ! [VarCurr] :
      ( v16690(VarCurr)
    <=> ( v16692(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3942,axiom,
    ! [VarCurr] :
      ( v16692(VarCurr)
    <=> ( v16693(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1061,axiom,
    ! [VarCurr] :
      ( v16693(VarCurr)
    <=> ( v16685(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3941,axiom,
    ! [VarCurr] :
      ( v16680(VarCurr)
    <=> ( v16681(VarCurr)
        | v16686(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3940,axiom,
    ! [VarCurr] :
      ( v16686(VarCurr)
    <=> ( v16688(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3939,axiom,
    ! [VarCurr] :
      ( v16688(VarCurr)
    <=> ( v16689(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1060,axiom,
    ! [VarCurr] :
      ( v16689(VarCurr)
    <=> ( v16674(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3938,axiom,
    ! [VarCurr] :
      ( v16681(VarCurr)
    <=> ( v16683(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3937,axiom,
    ! [VarCurr] :
      ( v16683(VarCurr)
    <=> ( v16684(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3936,axiom,
    ! [VarCurr] :
      ( v16684(VarCurr)
    <=> ( v16685(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3935,axiom,
    ! [VarCurr] :
      ( v16685(VarCurr)
    <=> ( v16675(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3934,axiom,
    ! [VarCurr] :
      ( v16670(VarCurr)
    <=> ( v16672(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3933,axiom,
    ! [VarCurr] :
      ( v16672(VarCurr)
    <=> ( v16673(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3932,axiom,
    ! [VarCurr] :
      ( v16673(VarCurr)
    <=> ( v16674(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3931,axiom,
    ! [VarCurr] :
      ( v16674(VarCurr)
    <=> ( v16675(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1059,axiom,
    ! [VarCurr] :
      ( v16675(VarCurr)
    <=> ( v16676(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1058,axiom,
    ! [VarCurr] :
      ( v16676(VarCurr)
    <=> ( v16677(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3930,axiom,
    ! [VarCurr] :
      ( v16677(VarCurr)
    <=> ( v16481(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3929,axiom,
    ! [VarCurr] :
      ( v16624(VarCurr)
    <=> ( v16626(VarCurr)
        | v16667(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1057,axiom,
    ! [VarCurr] :
      ( v16667(VarCurr)
    <=> ( v16669(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1056,axiom,
    ! [VarCurr] :
      ( v16669(VarCurr)
    <=> ( v16350(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3928,axiom,
    ! [VarCurr] :
      ( v16626(VarCurr)
    <=> ( v16627(VarCurr)
        | v16664(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1055,axiom,
    ! [VarCurr] :
      ( v16664(VarCurr)
    <=> ( v16666(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1054,axiom,
    ! [VarCurr] :
      ( v16666(VarCurr)
    <=> ( v16342(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3927,axiom,
    ! [VarCurr] :
      ( v16627(VarCurr)
    <=> ( v16628(VarCurr)
        | v16661(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1053,axiom,
    ! [VarCurr] :
      ( v16661(VarCurr)
    <=> ( v16663(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1052,axiom,
    ! [VarCurr] :
      ( v16663(VarCurr)
    <=> ( v16338(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3926,axiom,
    ! [VarCurr] :
      ( v16628(VarCurr)
    <=> ( v16629(VarCurr)
        | v16658(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1051,axiom,
    ! [VarCurr] :
      ( v16658(VarCurr)
    <=> ( v16660(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1050,axiom,
    ! [VarCurr] :
      ( v16660(VarCurr)
    <=> ( v16334(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3925,axiom,
    ! [VarCurr] :
      ( v16629(VarCurr)
    <=> ( v16630(VarCurr)
        | v16655(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1049,axiom,
    ! [VarCurr] :
      ( v16655(VarCurr)
    <=> ( v16657(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1048,axiom,
    ! [VarCurr] :
      ( v16657(VarCurr)
    <=> ( v16330(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3924,axiom,
    ! [VarCurr] :
      ( v16630(VarCurr)
    <=> ( v16631(VarCurr)
        | v16650(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1047,axiom,
    ! [VarCurr] :
      ( v16650(VarCurr)
    <=> ( v16652(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1046,axiom,
    ! [VarCurr] :
      ( v16652(VarCurr)
    <=> ( v16653(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3923,axiom,
    ! [VarCurr] :
      ( v16653(VarCurr)
    <=> ( v16654(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3922,axiom,
    ! [VarCurr] :
      ( v16654(VarCurr)
    <=> ( v16557(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3921,axiom,
    ! [VarCurr] :
      ( v16631(VarCurr)
    <=> ( v16632(VarCurr)
        | v16647(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1045,axiom,
    ! [VarCurr] :
      ( v16647(VarCurr)
    <=> ( v16649(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1044,axiom,
    ! [VarCurr] :
      ( v16649(VarCurr)
    <=> ( v16325(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3920,axiom,
    ! [VarCurr] :
      ( v16632(VarCurr)
    <=> ( v16633(VarCurr)
        | v16644(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1043,axiom,
    ! [VarCurr] :
      ( v16644(VarCurr)
    <=> ( v16646(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1042,axiom,
    ! [VarCurr] :
      ( v16646(VarCurr)
    <=> ( v16321(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3919,axiom,
    ! [VarCurr] :
      ( v16633(VarCurr)
    <=> ( v16634(VarCurr)
        | v16641(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1041,axiom,
    ! [VarCurr] :
      ( v16641(VarCurr)
    <=> ( v16643(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1040,axiom,
    ! [VarCurr] :
      ( v16643(VarCurr)
    <=> ( v16317(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3918,axiom,
    ! [VarCurr] :
      ( v16634(VarCurr)
    <=> ( v16635(VarCurr)
        | v16638(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1039,axiom,
    ! [VarCurr] :
      ( v16638(VarCurr)
    <=> ( v16640(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1038,axiom,
    ! [VarCurr] :
      ( v16640(VarCurr)
    <=> ( v16313(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1037,axiom,
    ! [VarCurr] :
      ( v16635(VarCurr)
    <=> ( v16637(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1036,axiom,
    ! [VarCurr] :
      ( v16637(VarCurr)
    <=> ( v16309(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3917,axiom,
    ! [VarCurr] :
      ( v16615(VarCurr)
    <=> ( v16616(VarCurr)
        | v16620(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1035,axiom,
    ! [VarCurr] :
      ( v16620(VarCurr)
    <=> ( v16622(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3916,axiom,
    ! [VarCurr] :
      ( v16622(VarCurr)
    <=> ( v16623(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1034,axiom,
    ! [VarCurr] :
      ( v16623(VarCurr)
    <=> ( v16580(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1033,axiom,
    ! [VarCurr] :
      ( v16616(VarCurr)
    <=> ( v16618(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3915,axiom,
    ! [VarCurr] :
      ( v16618(VarCurr)
    <=> ( v16619(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3914,axiom,
    ! [VarCurr] :
      ( v16619(VarCurr)
    <=> ( v16580(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3913,axiom,
    ! [VarCurr] :
      ( v16583(VarCurr)
    <=> ( v16585(VarCurr)
        | v16612(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3912,axiom,
    ! [VarCurr] :
      ( v16612(VarCurr)
    <=> ( v16614(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1032,axiom,
    ! [VarCurr] :
      ( v16614(VarCurr)
    <=> ( v16602(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3911,axiom,
    ! [VarCurr] :
      ( v16585(VarCurr)
    <=> ( v16586(VarCurr)
        | v16609(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3910,axiom,
    ! [VarCurr] :
      ( v16609(VarCurr)
    <=> ( v16611(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1031,axiom,
    ! [VarCurr] :
      ( v16611(VarCurr)
    <=> ( v16598(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3909,axiom,
    ! [VarCurr] :
      ( v16586(VarCurr)
    <=> ( v16587(VarCurr)
        | v16606(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3908,axiom,
    ! [VarCurr] :
      ( v16606(VarCurr)
    <=> ( v16608(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1030,axiom,
    ! [VarCurr] :
      ( v16608(VarCurr)
    <=> ( v16593(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3907,axiom,
    ! [VarCurr] :
      ( v16587(VarCurr)
    <=> ( v16588(VarCurr)
        | v16603(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3906,axiom,
    ! [VarCurr] :
      ( v16603(VarCurr)
    <=> ( v16605(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1029,axiom,
    ! [VarCurr] :
      ( v16605(VarCurr)
    <=> ( v16578(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3905,axiom,
    ! [VarCurr] :
      ( v16588(VarCurr)
    <=> ( v16589(VarCurr)
        | v16599(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3904,axiom,
    ! [VarCurr] :
      ( v16599(VarCurr)
    <=> ( v16601(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3903,axiom,
    ! [VarCurr] :
      ( v16601(VarCurr)
    <=> ( v16602(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1028,axiom,
    ! [VarCurr] :
      ( v16602(VarCurr)
    <=> ( v16594(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3902,axiom,
    ! [VarCurr] :
      ( v16589(VarCurr)
    <=> ( v16590(VarCurr)
        | v16595(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3901,axiom,
    ! [VarCurr] :
      ( v16595(VarCurr)
    <=> ( v16597(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3900,axiom,
    ! [VarCurr] :
      ( v16597(VarCurr)
    <=> ( v16598(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1027,axiom,
    ! [VarCurr] :
      ( v16598(VarCurr)
    <=> ( v16579(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3899,axiom,
    ! [VarCurr] :
      ( v16590(VarCurr)
    <=> ( v16592(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3898,axiom,
    ! [VarCurr] :
      ( v16592(VarCurr)
    <=> ( v16593(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3897,axiom,
    ! [VarCurr] :
      ( v16593(VarCurr)
    <=> ( v16594(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3896,axiom,
    ! [VarCurr] :
      ( v16594(VarCurr)
    <=> ( v16580(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3895,axiom,
    ! [VarCurr] :
      ( v16575(VarCurr)
    <=> ( v16577(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3894,axiom,
    ! [VarCurr] :
      ( v16577(VarCurr)
    <=> ( v16578(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3893,axiom,
    ! [VarCurr] :
      ( v16578(VarCurr)
    <=> ( v16579(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3892,axiom,
    ! [VarCurr] :
      ( v16579(VarCurr)
    <=> ( v16580(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1026,axiom,
    ! [VarCurr] :
      ( v16580(VarCurr)
    <=> ( v16581(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3891,axiom,
    ! [VarCurr] :
      ( v16581(VarCurr)
    <=> ( v16582(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1025,axiom,
    ! [VarCurr] :
      ( v16582(VarCurr)
    <=> ( v16428(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3890,axiom,
    ! [VarCurr] :
      ( v16526(VarCurr)
    <=> ( v16528(VarCurr)
        | v16572(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1024,axiom,
    ! [VarCurr] :
      ( v16572(VarCurr)
    <=> ( v16574(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3889,axiom,
    ! [VarCurr] :
      ( v16574(VarCurr)
    <=> ( v16255(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3888,axiom,
    ! [VarCurr] :
      ( v16528(VarCurr)
    <=> ( v16529(VarCurr)
        | v16569(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1023,axiom,
    ! [VarCurr] :
      ( v16569(VarCurr)
    <=> ( v16571(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3887,axiom,
    ! [VarCurr] :
      ( v16571(VarCurr)
    <=> ( v16247(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3886,axiom,
    ! [VarCurr] :
      ( v16529(VarCurr)
    <=> ( v16530(VarCurr)
        | v16566(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1022,axiom,
    ! [VarCurr] :
      ( v16566(VarCurr)
    <=> ( v16568(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3885,axiom,
    ! [VarCurr] :
      ( v16568(VarCurr)
    <=> ( v16243(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3884,axiom,
    ! [VarCurr] :
      ( v16530(VarCurr)
    <=> ( v16531(VarCurr)
        | v16563(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1021,axiom,
    ! [VarCurr] :
      ( v16563(VarCurr)
    <=> ( v16565(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3883,axiom,
    ! [VarCurr] :
      ( v16565(VarCurr)
    <=> ( v16239(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3882,axiom,
    ! [VarCurr] :
      ( v16531(VarCurr)
    <=> ( v16532(VarCurr)
        | v16560(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1020,axiom,
    ! [VarCurr] :
      ( v16560(VarCurr)
    <=> ( v16562(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3881,axiom,
    ! [VarCurr] :
      ( v16562(VarCurr)
    <=> ( v16235(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3880,axiom,
    ! [VarCurr] :
      ( v16532(VarCurr)
    <=> ( v16533(VarCurr)
        | v16552(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1019,axiom,
    ! [VarCurr] :
      ( v16552(VarCurr)
    <=> ( v16554(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3879,axiom,
    ! [VarCurr] :
      ( v16554(VarCurr)
    <=> ( v16555(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1018,axiom,
    ! [VarCurr] :
      ( v16555(VarCurr)
    <=> ( v16556(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3878,axiom,
    ! [VarCurr] :
      ( v16556(VarCurr)
    <=> ( v16557(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3877,axiom,
    ! [VarCurr] :
      ( v16557(VarCurr)
    <=> ( v16558(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1017,axiom,
    ! [VarCurr] :
      ( v16558(VarCurr)
    <=> ( v16559(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1016,axiom,
    ! [VarCurr] :
      ( v16559(VarCurr)
    <=> ( v14874(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3876,axiom,
    ! [VarCurr] :
      ( v16533(VarCurr)
    <=> ( v16534(VarCurr)
        | v16549(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1015,axiom,
    ! [VarCurr] :
      ( v16549(VarCurr)
    <=> ( v16551(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3875,axiom,
    ! [VarCurr] :
      ( v16551(VarCurr)
    <=> ( v16231(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3874,axiom,
    ! [VarCurr] :
      ( v16534(VarCurr)
    <=> ( v16535(VarCurr)
        | v16546(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1014,axiom,
    ! [VarCurr] :
      ( v16546(VarCurr)
    <=> ( v16548(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3873,axiom,
    ! [VarCurr] :
      ( v16548(VarCurr)
    <=> ( v16227(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3872,axiom,
    ! [VarCurr] :
      ( v16535(VarCurr)
    <=> ( v16536(VarCurr)
        | v16543(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1013,axiom,
    ! [VarCurr] :
      ( v16543(VarCurr)
    <=> ( v16545(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3871,axiom,
    ! [VarCurr] :
      ( v16545(VarCurr)
    <=> ( v16223(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3870,axiom,
    ! [VarCurr] :
      ( v16536(VarCurr)
    <=> ( v16537(VarCurr)
        | v16540(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1012,axiom,
    ! [VarCurr] :
      ( v16540(VarCurr)
    <=> ( v16542(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3869,axiom,
    ! [VarCurr] :
      ( v16542(VarCurr)
    <=> ( v16219(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1011,axiom,
    ! [VarCurr] :
      ( v16537(VarCurr)
    <=> ( v16539(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3868,axiom,
    ! [VarCurr] :
      ( v16539(VarCurr)
    <=> ( v16215(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3867,axiom,
    ! [VarCurr] :
      ( v16482(VarCurr)
    <=> ( v16484(VarCurr)
        | v16524(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1010,axiom,
    ! [VarCurr] :
      ( v16524(VarCurr)
    <=> ( v16504(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3866,axiom,
    ! [VarCurr] :
      ( v16484(VarCurr)
    <=> ( v16485(VarCurr)
        | v16522(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1009,axiom,
    ! [VarCurr] :
      ( v16522(VarCurr)
    <=> ( v16500(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3865,axiom,
    ! [VarCurr] :
      ( v16485(VarCurr)
    <=> ( v16486(VarCurr)
        | v16520(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1008,axiom,
    ! [VarCurr] :
      ( v16520(VarCurr)
    <=> ( v16495(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3864,axiom,
    ! [VarCurr] :
      ( v16486(VarCurr)
    <=> ( v16487(VarCurr)
        | v16518(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1007,axiom,
    ! [VarCurr] :
      ( v16518(VarCurr)
    <=> ( v16475(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3863,axiom,
    ! [VarCurr] :
      ( v16487(VarCurr)
    <=> ( v16488(VarCurr)
        | v16515(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3862,axiom,
    ! [VarCurr] :
      ( v16515(VarCurr)
    <=> ( v16517(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1006,axiom,
    ! [VarCurr] :
      ( v16517(VarCurr)
    <=> ( v16505(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3861,axiom,
    ! [VarCurr] :
      ( v16488(VarCurr)
    <=> ( v16489(VarCurr)
        | v16512(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3860,axiom,
    ! [VarCurr] :
      ( v16512(VarCurr)
    <=> ( v16514(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1005,axiom,
    ! [VarCurr] :
      ( v16514(VarCurr)
    <=> ( v16501(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3859,axiom,
    ! [VarCurr] :
      ( v16489(VarCurr)
    <=> ( v16490(VarCurr)
        | v16509(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3858,axiom,
    ! [VarCurr] :
      ( v16509(VarCurr)
    <=> ( v16511(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1004,axiom,
    ! [VarCurr] :
      ( v16511(VarCurr)
    <=> ( v16496(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3857,axiom,
    ! [VarCurr] :
      ( v16490(VarCurr)
    <=> ( v16491(VarCurr)
        | v16506(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3856,axiom,
    ! [VarCurr] :
      ( v16506(VarCurr)
    <=> ( v16508(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1003,axiom,
    ! [VarCurr] :
      ( v16508(VarCurr)
    <=> ( v16476(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3855,axiom,
    ! [VarCurr] :
      ( v16491(VarCurr)
    <=> ( v16492(VarCurr)
        | v16502(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3854,axiom,
    ! [VarCurr] :
      ( v16502(VarCurr)
    <=> ( v16504(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3853,axiom,
    ! [VarCurr] :
      ( v16504(VarCurr)
    <=> ( v16505(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1002,axiom,
    ! [VarCurr] :
      ( v16505(VarCurr)
    <=> ( v16497(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3852,axiom,
    ! [VarCurr] :
      ( v16492(VarCurr)
    <=> ( v16493(VarCurr)
        | v16498(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3851,axiom,
    ! [VarCurr] :
      ( v16498(VarCurr)
    <=> ( v16500(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3850,axiom,
    ! [VarCurr] :
      ( v16500(VarCurr)
    <=> ( v16501(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1001,axiom,
    ! [VarCurr] :
      ( v16501(VarCurr)
    <=> ( v16477(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3849,axiom,
    ! [VarCurr] :
      ( v16493(VarCurr)
    <=> ( v16495(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3848,axiom,
    ! [VarCurr] :
      ( v16495(VarCurr)
    <=> ( v16496(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3847,axiom,
    ! [VarCurr] :
      ( v16496(VarCurr)
    <=> ( v16497(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3846,axiom,
    ! [VarCurr] :
      ( v16497(VarCurr)
    <=> ( v16478(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3845,axiom,
    ! [VarCurr] :
      ( v16473(VarCurr)
    <=> ( v16475(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3844,axiom,
    ! [VarCurr] :
      ( v16475(VarCurr)
    <=> ( v16476(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3843,axiom,
    ! [VarCurr] :
      ( v16476(VarCurr)
    <=> ( v16477(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3842,axiom,
    ! [VarCurr] :
      ( v16477(VarCurr)
    <=> ( v16478(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1000,axiom,
    ! [VarCurr] :
      ( v16478(VarCurr)
    <=> ( v16479(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3841,axiom,
    ! [VarCurr] :
      ( v16479(VarCurr)
    <=> ( v16480(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_999,axiom,
    ! [VarCurr] :
      ( v16480(VarCurr)
    <=> ( v16481(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3840,axiom,
    ! [VarCurr] :
      ( v16481(VarCurr)
    <=> ( v16429(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3839,axiom,
    ! [VarCurr] :
      ( v16432(VarCurr)
    <=> ( v16434(VarCurr)
        | v16470(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_998,axiom,
    ! [VarCurr] :
      ( v16470(VarCurr)
    <=> ( v16472(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3838,axiom,
    ! [VarCurr] :
      ( v16472(VarCurr)
    <=> ( v16157(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3837,axiom,
    ! [VarCurr] :
      ( v16434(VarCurr)
    <=> ( v16435(VarCurr)
        | v16467(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_997,axiom,
    ! [VarCurr] :
      ( v16467(VarCurr)
    <=> ( v16469(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3836,axiom,
    ! [VarCurr] :
      ( v16469(VarCurr)
    <=> ( v16148(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3835,axiom,
    ! [VarCurr] :
      ( v16435(VarCurr)
    <=> ( v16436(VarCurr)
        | v16464(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_996,axiom,
    ! [VarCurr] :
      ( v16464(VarCurr)
    <=> ( v16466(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3834,axiom,
    ! [VarCurr] :
      ( v16466(VarCurr)
    <=> ( v16143(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3833,axiom,
    ! [VarCurr] :
      ( v16436(VarCurr)
    <=> ( v16437(VarCurr)
        | v16461(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_995,axiom,
    ! [VarCurr] :
      ( v16461(VarCurr)
    <=> ( v16463(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3832,axiom,
    ! [VarCurr] :
      ( v16463(VarCurr)
    <=> ( v16138(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3831,axiom,
    ! [VarCurr] :
      ( v16437(VarCurr)
    <=> ( v16438(VarCurr)
        | v16458(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_994,axiom,
    ! [VarCurr] :
      ( v16458(VarCurr)
    <=> ( v16460(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3830,axiom,
    ! [VarCurr] :
      ( v16460(VarCurr)
    <=> ( v16133(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3829,axiom,
    ! [VarCurr] :
      ( v16438(VarCurr)
    <=> ( v16439(VarCurr)
        | v16454(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_993,axiom,
    ! [VarCurr] :
      ( v16454(VarCurr)
    <=> ( v16456(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3828,axiom,
    ! [VarCurr] :
      ( v16456(VarCurr)
    <=> ( v16457(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_992,axiom,
    ! [VarCurr] :
      ( v16457(VarCurr)
    <=> ( v16326(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3827,axiom,
    ! [VarCurr] :
      ( v16439(VarCurr)
    <=> ( v16440(VarCurr)
        | v16451(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_991,axiom,
    ! [VarCurr] :
      ( v16451(VarCurr)
    <=> ( v16453(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3826,axiom,
    ! [VarCurr] :
      ( v16453(VarCurr)
    <=> ( v16128(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3825,axiom,
    ! [VarCurr] :
      ( v16440(VarCurr)
    <=> ( v16441(VarCurr)
        | v16448(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_990,axiom,
    ! [VarCurr] :
      ( v16448(VarCurr)
    <=> ( v16450(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3824,axiom,
    ! [VarCurr] :
      ( v16450(VarCurr)
    <=> ( v16123(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3823,axiom,
    ! [VarCurr] :
      ( v16441(VarCurr)
    <=> ( v16442(VarCurr)
        | v16445(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_989,axiom,
    ! [VarCurr] :
      ( v16445(VarCurr)
    <=> ( v16447(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3822,axiom,
    ! [VarCurr] :
      ( v16447(VarCurr)
    <=> ( v16118(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_988,axiom,
    ! [VarCurr] :
      ( v16442(VarCurr)
    <=> ( v16444(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3821,axiom,
    ! [VarCurr] :
      ( v16444(VarCurr)
    <=> ( v16113(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_987,axiom,
    ! [VarCurr] :
      ( v16424(VarCurr)
    <=> ( v16426(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3820,axiom,
    ! [VarCurr] :
      ( v16426(VarCurr)
    <=> ( v16427(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3819,axiom,
    ! [VarCurr] :
      ( v16427(VarCurr)
    <=> ( v16428(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3818,axiom,
    ! [VarCurr] :
      ( v16428(VarCurr)
    <=> ( v16429(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3817,axiom,
    ! [VarCurr] :
      ( v16429(VarCurr)
    <=> ( v16430(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_986,axiom,
    ! [VarCurr] :
      ( v16430(VarCurr)
    <=> ( v16431(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_985,axiom,
    ! [VarCurr] :
      ( v16431(VarCurr)
    <=> ( v14746(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_984,axiom,
    ! [VarCurr] :
      ( v16421(VarCurr)
    <=> ( v16423(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3816,axiom,
    ! [VarCurr] :
      ( v16423(VarCurr)
    <=> ( v16097(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3815,axiom,
    ! [VarCurr] :
      ( v16385(VarCurr)
    <=> ( v16387(VarCurr)
        | v16418(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_983,axiom,
    ! [VarCurr] :
      ( v16418(VarCurr)
    <=> ( v16420(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3814,axiom,
    ! [VarCurr] :
      ( v16420(VarCurr)
    <=> ( v16089(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3813,axiom,
    ! [VarCurr] :
      ( v16387(VarCurr)
    <=> ( v16388(VarCurr)
        | v16415(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_982,axiom,
    ! [VarCurr] :
      ( v16415(VarCurr)
    <=> ( v16417(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3812,axiom,
    ! [VarCurr] :
      ( v16417(VarCurr)
    <=> ( v16081(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3811,axiom,
    ! [VarCurr] :
      ( v16388(VarCurr)
    <=> ( v16389(VarCurr)
        | v16412(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_981,axiom,
    ! [VarCurr] :
      ( v16412(VarCurr)
    <=> ( v16414(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3810,axiom,
    ! [VarCurr] :
      ( v16414(VarCurr)
    <=> ( v16072(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3809,axiom,
    ! [VarCurr] :
      ( v16389(VarCurr)
    <=> ( v16390(VarCurr)
        | v16409(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_980,axiom,
    ! [VarCurr] :
      ( v16409(VarCurr)
    <=> ( v16411(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3808,axiom,
    ! [VarCurr] :
      ( v16411(VarCurr)
    <=> ( v16064(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3807,axiom,
    ! [VarCurr] :
      ( v16390(VarCurr)
    <=> ( v16391(VarCurr)
        | v16406(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_979,axiom,
    ! [VarCurr] :
      ( v16406(VarCurr)
    <=> ( v16408(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3806,axiom,
    ! [VarCurr] :
      ( v16408(VarCurr)
    <=> ( v16056(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3805,axiom,
    ! [VarCurr] :
      ( v16391(VarCurr)
    <=> ( v16392(VarCurr)
        | v16403(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_978,axiom,
    ! [VarCurr] :
      ( v16403(VarCurr)
    <=> ( v16405(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3804,axiom,
    ! [VarCurr] :
      ( v16405(VarCurr)
    <=> ( v16048(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3803,axiom,
    ! [VarCurr] :
      ( v16392(VarCurr)
    <=> ( v16393(VarCurr)
        | v16400(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_977,axiom,
    ! [VarCurr] :
      ( v16400(VarCurr)
    <=> ( v16402(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3802,axiom,
    ! [VarCurr] :
      ( v16402(VarCurr)
    <=> ( v16040(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3801,axiom,
    ! [VarCurr] :
      ( v16393(VarCurr)
    <=> ( v16394(VarCurr)
        | v16397(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_976,axiom,
    ! [VarCurr] :
      ( v16397(VarCurr)
    <=> ( v16399(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3800,axiom,
    ! [VarCurr] :
      ( v16399(VarCurr)
    <=> ( v16032(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_975,axiom,
    ! [VarCurr] :
      ( v16394(VarCurr)
    <=> ( v16396(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3799,axiom,
    ! [VarCurr] :
      ( v16396(VarCurr)
    <=> ( v16024(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3798,axiom,
    ! [VarCurr] :
      ( v16367(VarCurr)
    <=> ( v16369(VarCurr)
        | v16382(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_974,axiom,
    ! [VarCurr] :
      ( v16382(VarCurr)
    <=> ( v16384(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3797,axiom,
    ! [VarCurr] :
      ( v16384(VarCurr)
    <=> ( v16378(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3796,axiom,
    ! [VarCurr] :
      ( v16369(VarCurr)
    <=> ( v16370(VarCurr)
        | v16379(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_973,axiom,
    ! [VarCurr] :
      ( v16379(VarCurr)
    <=> ( v16381(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3795,axiom,
    ! [VarCurr] :
      ( v16381(VarCurr)
    <=> ( v16374(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3794,axiom,
    ! [VarCurr] :
      ( v16370(VarCurr)
    <=> ( v16371(VarCurr)
        | v16375(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3793,axiom,
    ! [VarCurr] :
      ( v16375(VarCurr)
    <=> ( v16377(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_972,axiom,
    ! [VarCurr] :
      ( v16377(VarCurr)
    <=> ( v16378(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_971,axiom,
    ! [VarCurr] :
      ( v16378(VarCurr)
    <=> ( v16348(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3792,axiom,
    ! [VarCurr] :
      ( v16371(VarCurr)
    <=> ( v16373(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_970,axiom,
    ! [VarCurr] :
      ( v16373(VarCurr)
    <=> ( v16374(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3791,axiom,
    ! [VarCurr] :
      ( v16374(VarCurr)
    <=> ( v16348(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3790,axiom,
    ! [VarCurr] :
      ( v16351(VarCurr)
    <=> ( v16353(VarCurr)
        | v16363(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3789,axiom,
    ! [VarCurr] :
      ( v16363(VarCurr)
    <=> ( v16365(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3788,axiom,
    ! [VarCurr] :
      ( v16365(VarCurr)
    <=> ( v16366(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_969,axiom,
    ! [VarCurr] :
      ( v16366(VarCurr)
    <=> ( v16358(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3787,axiom,
    ! [VarCurr] :
      ( v16353(VarCurr)
    <=> ( v16354(VarCurr)
        | v16359(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3786,axiom,
    ! [VarCurr] :
      ( v16359(VarCurr)
    <=> ( v16361(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3785,axiom,
    ! [VarCurr] :
      ( v16361(VarCurr)
    <=> ( v16362(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_968,axiom,
    ! [VarCurr] :
      ( v16362(VarCurr)
    <=> ( v16347(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3784,axiom,
    ! [VarCurr] :
      ( v16354(VarCurr)
    <=> ( v16356(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3783,axiom,
    ! [VarCurr] :
      ( v16356(VarCurr)
    <=> ( v16357(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3782,axiom,
    ! [VarCurr] :
      ( v16357(VarCurr)
    <=> ( v16358(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3781,axiom,
    ! [VarCurr] :
      ( v16358(VarCurr)
    <=> ( v16348(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3780,axiom,
    ! [VarCurr] :
      ( v16343(VarCurr)
    <=> ( v16345(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3779,axiom,
    ! [VarCurr] :
      ( v16345(VarCurr)
    <=> ( v16346(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3778,axiom,
    ! [VarCurr] :
      ( v16346(VarCurr)
    <=> ( v16347(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3777,axiom,
    ! [VarCurr] :
      ( v16347(VarCurr)
    <=> ( v16348(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_967,axiom,
    ! [VarCurr] :
      ( v16348(VarCurr)
    <=> ( v16349(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3776,axiom,
    ! [VarCurr] :
      ( v16349(VarCurr)
    <=> ( v16350(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3775,axiom,
    ! [VarCurr] :
      ( v16350(VarCurr)
    <=> ( v16158(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3774,axiom,
    ! [VarCurr] :
      ( v16297(VarCurr)
    <=> ( v16299(VarCurr)
        | v16339(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_966,axiom,
    ! [VarCurr] :
      ( v16339(VarCurr)
    <=> ( v16341(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3773,axiom,
    ! [VarCurr] :
      ( v16341(VarCurr)
    <=> ( v16342(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3772,axiom,
    ! [VarCurr] :
      ( v16342(VarCurr)
    <=> ( v16149(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3771,axiom,
    ! [VarCurr] :
      ( v16299(VarCurr)
    <=> ( v16300(VarCurr)
        | v16335(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_965,axiom,
    ! [VarCurr] :
      ( v16335(VarCurr)
    <=> ( v16337(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3770,axiom,
    ! [VarCurr] :
      ( v16337(VarCurr)
    <=> ( v16338(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3769,axiom,
    ! [VarCurr] :
      ( v16338(VarCurr)
    <=> ( v16144(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3768,axiom,
    ! [VarCurr] :
      ( v16300(VarCurr)
    <=> ( v16301(VarCurr)
        | v16331(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_964,axiom,
    ! [VarCurr] :
      ( v16331(VarCurr)
    <=> ( v16333(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3767,axiom,
    ! [VarCurr] :
      ( v16333(VarCurr)
    <=> ( v16334(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3766,axiom,
    ! [VarCurr] :
      ( v16334(VarCurr)
    <=> ( v16139(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3765,axiom,
    ! [VarCurr] :
      ( v16301(VarCurr)
    <=> ( v16302(VarCurr)
        | v16327(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_963,axiom,
    ! [VarCurr] :
      ( v16327(VarCurr)
    <=> ( v16329(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3764,axiom,
    ! [VarCurr] :
      ( v16329(VarCurr)
    <=> ( v16330(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3763,axiom,
    ! [VarCurr] :
      ( v16330(VarCurr)
    <=> ( v16134(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3762,axiom,
    ! [VarCurr] :
      ( v16302(VarCurr)
    <=> ( v16303(VarCurr)
        | v16322(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_962,axiom,
    ! [VarCurr] :
      ( v16322(VarCurr)
    <=> ( v16324(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3761,axiom,
    ! [VarCurr] :
      ( v16324(VarCurr)
    <=> ( v16325(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3760,axiom,
    ! [VarCurr] :
      ( v16325(VarCurr)
    <=> ( v16326(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3759,axiom,
    ! [VarCurr] :
      ( v16326(VarCurr)
    <=> ( v16058(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3758,axiom,
    ! [VarCurr] :
      ( v16303(VarCurr)
    <=> ( v16304(VarCurr)
        | v16318(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_961,axiom,
    ! [VarCurr] :
      ( v16318(VarCurr)
    <=> ( v16320(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3757,axiom,
    ! [VarCurr] :
      ( v16320(VarCurr)
    <=> ( v16321(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3756,axiom,
    ! [VarCurr] :
      ( v16321(VarCurr)
    <=> ( v16129(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3755,axiom,
    ! [VarCurr] :
      ( v16304(VarCurr)
    <=> ( v16305(VarCurr)
        | v16314(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_960,axiom,
    ! [VarCurr] :
      ( v16314(VarCurr)
    <=> ( v16316(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3754,axiom,
    ! [VarCurr] :
      ( v16316(VarCurr)
    <=> ( v16317(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3753,axiom,
    ! [VarCurr] :
      ( v16317(VarCurr)
    <=> ( v16124(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3752,axiom,
    ! [VarCurr] :
      ( v16305(VarCurr)
    <=> ( v16306(VarCurr)
        | v16310(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_959,axiom,
    ! [VarCurr] :
      ( v16310(VarCurr)
    <=> ( v16312(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3751,axiom,
    ! [VarCurr] :
      ( v16312(VarCurr)
    <=> ( v16313(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3750,axiom,
    ! [VarCurr] :
      ( v16313(VarCurr)
    <=> ( v16119(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_958,axiom,
    ! [VarCurr] :
      ( v16306(VarCurr)
    <=> ( v16308(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3749,axiom,
    ! [VarCurr] :
      ( v16308(VarCurr)
    <=> ( v16309(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3748,axiom,
    ! [VarCurr] :
      ( v16309(VarCurr)
    <=> ( v16114(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3747,axiom,
    ! [VarCurr] :
      ( v16288(VarCurr)
    <=> ( v16289(VarCurr)
        | v16293(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_957,axiom,
    ! [VarCurr] :
      ( v16293(VarCurr)
    <=> ( v16295(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3746,axiom,
    ! [VarCurr] :
      ( v16295(VarCurr)
    <=> ( v16296(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_956,axiom,
    ! [VarCurr] :
      ( v16296(VarCurr)
    <=> ( v16253(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_955,axiom,
    ! [VarCurr] :
      ( v16289(VarCurr)
    <=> ( v16291(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3745,axiom,
    ! [VarCurr] :
      ( v16291(VarCurr)
    <=> ( v16292(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3744,axiom,
    ! [VarCurr] :
      ( v16292(VarCurr)
    <=> ( v16253(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3743,axiom,
    ! [VarCurr] :
      ( v16256(VarCurr)
    <=> ( v16258(VarCurr)
        | v16285(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3742,axiom,
    ! [VarCurr] :
      ( v16285(VarCurr)
    <=> ( v16287(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_954,axiom,
    ! [VarCurr] :
      ( v16287(VarCurr)
    <=> ( v16275(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3741,axiom,
    ! [VarCurr] :
      ( v16258(VarCurr)
    <=> ( v16259(VarCurr)
        | v16282(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3740,axiom,
    ! [VarCurr] :
      ( v16282(VarCurr)
    <=> ( v16284(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_953,axiom,
    ! [VarCurr] :
      ( v16284(VarCurr)
    <=> ( v16271(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3739,axiom,
    ! [VarCurr] :
      ( v16259(VarCurr)
    <=> ( v16260(VarCurr)
        | v16279(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3738,axiom,
    ! [VarCurr] :
      ( v16279(VarCurr)
    <=> ( v16281(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_952,axiom,
    ! [VarCurr] :
      ( v16281(VarCurr)
    <=> ( v16266(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3737,axiom,
    ! [VarCurr] :
      ( v16260(VarCurr)
    <=> ( v16261(VarCurr)
        | v16276(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3736,axiom,
    ! [VarCurr] :
      ( v16276(VarCurr)
    <=> ( v16278(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_951,axiom,
    ! [VarCurr] :
      ( v16278(VarCurr)
    <=> ( v16251(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3735,axiom,
    ! [VarCurr] :
      ( v16261(VarCurr)
    <=> ( v16262(VarCurr)
        | v16272(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3734,axiom,
    ! [VarCurr] :
      ( v16272(VarCurr)
    <=> ( v16274(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3733,axiom,
    ! [VarCurr] :
      ( v16274(VarCurr)
    <=> ( v16275(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_950,axiom,
    ! [VarCurr] :
      ( v16275(VarCurr)
    <=> ( v16267(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3732,axiom,
    ! [VarCurr] :
      ( v16262(VarCurr)
    <=> ( v16263(VarCurr)
        | v16268(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3731,axiom,
    ! [VarCurr] :
      ( v16268(VarCurr)
    <=> ( v16270(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3730,axiom,
    ! [VarCurr] :
      ( v16270(VarCurr)
    <=> ( v16271(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_949,axiom,
    ! [VarCurr] :
      ( v16271(VarCurr)
    <=> ( v16252(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3729,axiom,
    ! [VarCurr] :
      ( v16263(VarCurr)
    <=> ( v16265(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3728,axiom,
    ! [VarCurr] :
      ( v16265(VarCurr)
    <=> ( v16266(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3727,axiom,
    ! [VarCurr] :
      ( v16266(VarCurr)
    <=> ( v16267(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3726,axiom,
    ! [VarCurr] :
      ( v16267(VarCurr)
    <=> ( v16253(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3725,axiom,
    ! [VarCurr] :
      ( v16248(VarCurr)
    <=> ( v16250(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3724,axiom,
    ! [VarCurr] :
      ( v16250(VarCurr)
    <=> ( v16251(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3723,axiom,
    ! [VarCurr] :
      ( v16251(VarCurr)
    <=> ( v16252(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3722,axiom,
    ! [VarCurr] :
      ( v16252(VarCurr)
    <=> ( v16253(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3721,axiom,
    ! [VarCurr] :
      ( v16253(VarCurr)
    <=> ( v16254(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_948,axiom,
    ! [VarCurr] :
      ( v16254(VarCurr)
    <=> ( v16255(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_947,axiom,
    ! [VarCurr] :
      ( v16255(VarCurr)
    <=> ( v16098(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3720,axiom,
    ! [VarCurr] :
      ( v16203(VarCurr)
    <=> ( v16205(VarCurr)
        | v16244(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3719,axiom,
    ! [VarCurr] :
      ( v16244(VarCurr)
    <=> ( v16246(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_946,axiom,
    ! [VarCurr] :
      ( v16246(VarCurr)
    <=> ( v16247(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_945,axiom,
    ! [VarCurr] :
      ( v16247(VarCurr)
    <=> ( v16090(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3718,axiom,
    ! [VarCurr] :
      ( v16205(VarCurr)
    <=> ( v16206(VarCurr)
        | v16240(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3717,axiom,
    ! [VarCurr] :
      ( v16240(VarCurr)
    <=> ( v16242(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_944,axiom,
    ! [VarCurr] :
      ( v16242(VarCurr)
    <=> ( v16243(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_943,axiom,
    ! [VarCurr] :
      ( v16243(VarCurr)
    <=> ( v16082(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3716,axiom,
    ! [VarCurr] :
      ( v16206(VarCurr)
    <=> ( v16207(VarCurr)
        | v16236(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3715,axiom,
    ! [VarCurr] :
      ( v16236(VarCurr)
    <=> ( v16238(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_942,axiom,
    ! [VarCurr] :
      ( v16238(VarCurr)
    <=> ( v16239(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_941,axiom,
    ! [VarCurr] :
      ( v16239(VarCurr)
    <=> ( v16073(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3714,axiom,
    ! [VarCurr] :
      ( v16207(VarCurr)
    <=> ( v16208(VarCurr)
        | v16232(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3713,axiom,
    ! [VarCurr] :
      ( v16232(VarCurr)
    <=> ( v16234(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_940,axiom,
    ! [VarCurr] :
      ( v16234(VarCurr)
    <=> ( v16235(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_939,axiom,
    ! [VarCurr] :
      ( v16235(VarCurr)
    <=> ( v16065(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3712,axiom,
    ! [VarCurr] :
      ( v16208(VarCurr)
    <=> ( v16209(VarCurr)
        | v16228(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3711,axiom,
    ! [VarCurr] :
      ( v16228(VarCurr)
    <=> ( v16230(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_938,axiom,
    ! [VarCurr] :
      ( v16230(VarCurr)
    <=> ( v16231(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_937,axiom,
    ! [VarCurr] :
      ( v16231(VarCurr)
    <=> ( v16057(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3710,axiom,
    ! [VarCurr] :
      ( v16209(VarCurr)
    <=> ( v16210(VarCurr)
        | v16224(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3709,axiom,
    ! [VarCurr] :
      ( v16224(VarCurr)
    <=> ( v16226(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_936,axiom,
    ! [VarCurr] :
      ( v16226(VarCurr)
    <=> ( v16227(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_935,axiom,
    ! [VarCurr] :
      ( v16227(VarCurr)
    <=> ( v16049(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3708,axiom,
    ! [VarCurr] :
      ( v16210(VarCurr)
    <=> ( v16211(VarCurr)
        | v16220(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3707,axiom,
    ! [VarCurr] :
      ( v16220(VarCurr)
    <=> ( v16222(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_934,axiom,
    ! [VarCurr] :
      ( v16222(VarCurr)
    <=> ( v16223(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_933,axiom,
    ! [VarCurr] :
      ( v16223(VarCurr)
    <=> ( v16041(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3706,axiom,
    ! [VarCurr] :
      ( v16211(VarCurr)
    <=> ( v16212(VarCurr)
        | v16216(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3705,axiom,
    ! [VarCurr] :
      ( v16216(VarCurr)
    <=> ( v16218(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_932,axiom,
    ! [VarCurr] :
      ( v16218(VarCurr)
    <=> ( v16219(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_931,axiom,
    ! [VarCurr] :
      ( v16219(VarCurr)
    <=> ( v16033(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3704,axiom,
    ! [VarCurr] :
      ( v16212(VarCurr)
    <=> ( v16214(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_930,axiom,
    ! [VarCurr] :
      ( v16214(VarCurr)
    <=> ( v16215(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_929,axiom,
    ! [VarCurr] :
      ( v16215(VarCurr)
    <=> ( v16025(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3703,axiom,
    ! [VarCurr] :
      ( v16159(VarCurr)
    <=> ( v16161(VarCurr)
        | v16201(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_928,axiom,
    ! [VarCurr] :
      ( v16201(VarCurr)
    <=> ( v16181(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3702,axiom,
    ! [VarCurr] :
      ( v16161(VarCurr)
    <=> ( v16162(VarCurr)
        | v16199(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_927,axiom,
    ! [VarCurr] :
      ( v16199(VarCurr)
    <=> ( v16177(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3701,axiom,
    ! [VarCurr] :
      ( v16162(VarCurr)
    <=> ( v16163(VarCurr)
        | v16197(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_926,axiom,
    ! [VarCurr] :
      ( v16197(VarCurr)
    <=> ( v16172(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3700,axiom,
    ! [VarCurr] :
      ( v16163(VarCurr)
    <=> ( v16164(VarCurr)
        | v16195(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_925,axiom,
    ! [VarCurr] :
      ( v16195(VarCurr)
    <=> ( v16152(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3699,axiom,
    ! [VarCurr] :
      ( v16164(VarCurr)
    <=> ( v16165(VarCurr)
        | v16192(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3698,axiom,
    ! [VarCurr] :
      ( v16192(VarCurr)
    <=> ( v16194(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_924,axiom,
    ! [VarCurr] :
      ( v16194(VarCurr)
    <=> ( v16182(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3697,axiom,
    ! [VarCurr] :
      ( v16165(VarCurr)
    <=> ( v16166(VarCurr)
        | v16189(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3696,axiom,
    ! [VarCurr] :
      ( v16189(VarCurr)
    <=> ( v16191(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_923,axiom,
    ! [VarCurr] :
      ( v16191(VarCurr)
    <=> ( v16178(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3695,axiom,
    ! [VarCurr] :
      ( v16166(VarCurr)
    <=> ( v16167(VarCurr)
        | v16186(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3694,axiom,
    ! [VarCurr] :
      ( v16186(VarCurr)
    <=> ( v16188(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_922,axiom,
    ! [VarCurr] :
      ( v16188(VarCurr)
    <=> ( v16173(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3693,axiom,
    ! [VarCurr] :
      ( v16167(VarCurr)
    <=> ( v16168(VarCurr)
        | v16183(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3692,axiom,
    ! [VarCurr] :
      ( v16183(VarCurr)
    <=> ( v16185(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_921,axiom,
    ! [VarCurr] :
      ( v16185(VarCurr)
    <=> ( v16153(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3691,axiom,
    ! [VarCurr] :
      ( v16168(VarCurr)
    <=> ( v16169(VarCurr)
        | v16179(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3690,axiom,
    ! [VarCurr] :
      ( v16179(VarCurr)
    <=> ( v16181(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3689,axiom,
    ! [VarCurr] :
      ( v16181(VarCurr)
    <=> ( v16182(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_920,axiom,
    ! [VarCurr] :
      ( v16182(VarCurr)
    <=> ( v16174(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3688,axiom,
    ! [VarCurr] :
      ( v16169(VarCurr)
    <=> ( v16170(VarCurr)
        | v16175(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3687,axiom,
    ! [VarCurr] :
      ( v16175(VarCurr)
    <=> ( v16177(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3686,axiom,
    ! [VarCurr] :
      ( v16177(VarCurr)
    <=> ( v16178(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_919,axiom,
    ! [VarCurr] :
      ( v16178(VarCurr)
    <=> ( v16154(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3685,axiom,
    ! [VarCurr] :
      ( v16170(VarCurr)
    <=> ( v16172(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3684,axiom,
    ! [VarCurr] :
      ( v16172(VarCurr)
    <=> ( v16173(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3683,axiom,
    ! [VarCurr] :
      ( v16173(VarCurr)
    <=> ( v16174(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3682,axiom,
    ! [VarCurr] :
      ( v16174(VarCurr)
    <=> ( v16155(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3681,axiom,
    ! [VarCurr] :
      ( v16150(VarCurr)
    <=> ( v16152(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3680,axiom,
    ! [VarCurr] :
      ( v16152(VarCurr)
    <=> ( v16153(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3679,axiom,
    ! [VarCurr] :
      ( v16153(VarCurr)
    <=> ( v16154(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3678,axiom,
    ! [VarCurr] :
      ( v16154(VarCurr)
    <=> ( v16155(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3677,axiom,
    ! [VarCurr] :
      ( v16155(VarCurr)
    <=> ( v16156(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_918,axiom,
    ! [VarCurr] :
      ( v16156(VarCurr)
    <=> ( v16157(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_917,axiom,
    ! [VarCurr] :
      ( v16157(VarCurr)
    <=> ( v16158(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3676,axiom,
    ! [VarCurr] :
      ( v16158(VarCurr)
    <=> ( v16099(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3675,axiom,
    ! [VarCurr] :
      ( v16102(VarCurr)
    <=> ( v16104(VarCurr)
        | v16145(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3674,axiom,
    ! [VarCurr] :
      ( v16145(VarCurr)
    <=> ( v16147(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_916,axiom,
    ! [VarCurr] :
      ( v16147(VarCurr)
    <=> ( v16148(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_915,axiom,
    ! [VarCurr] :
      ( v16148(VarCurr)
    <=> ( v16149(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3673,axiom,
    ! [VarCurr] :
      ( v16149(VarCurr)
    <=> ( v16091(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3672,axiom,
    ! [VarCurr] :
      ( v16104(VarCurr)
    <=> ( v16105(VarCurr)
        | v16140(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3671,axiom,
    ! [VarCurr] :
      ( v16140(VarCurr)
    <=> ( v16142(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_914,axiom,
    ! [VarCurr] :
      ( v16142(VarCurr)
    <=> ( v16143(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_913,axiom,
    ! [VarCurr] :
      ( v16143(VarCurr)
    <=> ( v16144(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3670,axiom,
    ! [VarCurr] :
      ( v16144(VarCurr)
    <=> ( v16083(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3669,axiom,
    ! [VarCurr] :
      ( v16105(VarCurr)
    <=> ( v16106(VarCurr)
        | v16135(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3668,axiom,
    ! [VarCurr] :
      ( v16135(VarCurr)
    <=> ( v16137(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_912,axiom,
    ! [VarCurr] :
      ( v16137(VarCurr)
    <=> ( v16138(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_911,axiom,
    ! [VarCurr] :
      ( v16138(VarCurr)
    <=> ( v16139(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3667,axiom,
    ! [VarCurr] :
      ( v16139(VarCurr)
    <=> ( v16074(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3666,axiom,
    ! [VarCurr] :
      ( v16106(VarCurr)
    <=> ( v16107(VarCurr)
        | v16130(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3665,axiom,
    ! [VarCurr] :
      ( v16130(VarCurr)
    <=> ( v16132(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_910,axiom,
    ! [VarCurr] :
      ( v16132(VarCurr)
    <=> ( v16133(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_909,axiom,
    ! [VarCurr] :
      ( v16133(VarCurr)
    <=> ( v16134(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3664,axiom,
    ! [VarCurr] :
      ( v16134(VarCurr)
    <=> ( v16066(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3663,axiom,
    ! [VarCurr] :
      ( v16107(VarCurr)
    <=> ( v16108(VarCurr)
        | v16125(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3662,axiom,
    ! [VarCurr] :
      ( v16125(VarCurr)
    <=> ( v16127(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_908,axiom,
    ! [VarCurr] :
      ( v16127(VarCurr)
    <=> ( v16128(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_907,axiom,
    ! [VarCurr] :
      ( v16128(VarCurr)
    <=> ( v16129(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3661,axiom,
    ! [VarCurr] :
      ( v16129(VarCurr)
    <=> ( v16050(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3660,axiom,
    ! [VarCurr] :
      ( v16108(VarCurr)
    <=> ( v16109(VarCurr)
        | v16120(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3659,axiom,
    ! [VarCurr] :
      ( v16120(VarCurr)
    <=> ( v16122(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_906,axiom,
    ! [VarCurr] :
      ( v16122(VarCurr)
    <=> ( v16123(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_905,axiom,
    ! [VarCurr] :
      ( v16123(VarCurr)
    <=> ( v16124(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3658,axiom,
    ! [VarCurr] :
      ( v16124(VarCurr)
    <=> ( v16042(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3657,axiom,
    ! [VarCurr] :
      ( v16109(VarCurr)
    <=> ( v16110(VarCurr)
        | v16115(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3656,axiom,
    ! [VarCurr] :
      ( v16115(VarCurr)
    <=> ( v16117(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_904,axiom,
    ! [VarCurr] :
      ( v16117(VarCurr)
    <=> ( v16118(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_903,axiom,
    ! [VarCurr] :
      ( v16118(VarCurr)
    <=> ( v16119(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3655,axiom,
    ! [VarCurr] :
      ( v16119(VarCurr)
    <=> ( v16034(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3654,axiom,
    ! [VarCurr] :
      ( v16110(VarCurr)
    <=> ( v16112(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_902,axiom,
    ! [VarCurr] :
      ( v16112(VarCurr)
    <=> ( v16113(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_901,axiom,
    ! [VarCurr] :
      ( v16113(VarCurr)
    <=> ( v16114(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3653,axiom,
    ! [VarCurr] :
      ( v16114(VarCurr)
    <=> ( v16026(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3652,axiom,
    ! [VarCurr] :
      ( v16094(VarCurr)
    <=> ( v16096(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_900,axiom,
    ! [VarCurr] :
      ( v16096(VarCurr)
    <=> ( v16097(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3651,axiom,
    ! [VarCurr] :
      ( v16097(VarCurr)
    <=> ( v16098(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3650,axiom,
    ! [VarCurr] :
      ( v16098(VarCurr)
    <=> ( v16099(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3649,axiom,
    ! [VarCurr] :
      ( v16099(VarCurr)
    <=> ( v16100(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_899,axiom,
    ! [VarCurr] :
      ( v16100(VarCurr)
    <=> ( v16101(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_898,axiom,
    ! [VarCurr] :
      ( v16101(VarCurr)
    <=> ( v14420(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3648,axiom,
    ! [VarCurr] :
      ( v16077(VarCurr)
    <=> ( v16078(VarCurr)
        | v16086(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3647,axiom,
    ! [VarCurr] :
      ( v16086(VarCurr)
    <=> ( v16088(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_897,axiom,
    ! [VarCurr] :
      ( v16088(VarCurr)
    <=> ( v16089(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3646,axiom,
    ! [VarCurr] :
      ( v16089(VarCurr)
    <=> ( v16090(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3645,axiom,
    ! [VarCurr] :
      ( v16090(VarCurr)
    <=> ( v16091(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3644,axiom,
    ! [VarCurr] :
      ( v16091(VarCurr)
    <=> ( v16092(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_896,axiom,
    ! [VarCurr] :
      ( v16092(VarCurr)
    <=> ( v16093(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_895,axiom,
    ! [VarCurr] :
      ( v16093(VarCurr)
    <=> ( v14161(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3643,axiom,
    ! [VarCurr] :
      ( v16078(VarCurr)
    <=> ( v16080(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_894,axiom,
    ! [VarCurr] :
      ( v16080(VarCurr)
    <=> ( v16081(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3642,axiom,
    ! [VarCurr] :
      ( v16081(VarCurr)
    <=> ( v16082(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3641,axiom,
    ! [VarCurr] :
      ( v16082(VarCurr)
    <=> ( v16083(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3640,axiom,
    ! [VarCurr] :
      ( v16083(VarCurr)
    <=> ( v16084(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_893,axiom,
    ! [VarCurr] :
      ( v16084(VarCurr)
    <=> ( v16085(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_892,axiom,
    ! [VarCurr] :
      ( v16085(VarCurr)
    <=> ( v14141(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3639,axiom,
    ! [VarCurr] :
      ( v16014(VarCurr)
    <=> ( v16016(VarCurr)
        | v16069(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3638,axiom,
    ! [VarCurr] :
      ( v16069(VarCurr)
    <=> ( v16071(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_891,axiom,
    ! [VarCurr] :
      ( v16071(VarCurr)
    <=> ( v16072(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3637,axiom,
    ! [VarCurr] :
      ( v16072(VarCurr)
    <=> ( v16073(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3636,axiom,
    ! [VarCurr] :
      ( v16073(VarCurr)
    <=> ( v16074(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3635,axiom,
    ! [VarCurr] :
      ( v16074(VarCurr)
    <=> ( v16075(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_890,axiom,
    ! [VarCurr] :
      ( v16075(VarCurr)
    <=> ( v16076(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_889,axiom,
    ! [VarCurr] :
      ( v16076(VarCurr)
    <=> ( v14121(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3634,axiom,
    ! [VarCurr] :
      ( v16016(VarCurr)
    <=> ( v16017(VarCurr)
        | v16061(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3633,axiom,
    ! [VarCurr] :
      ( v16061(VarCurr)
    <=> ( v16063(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_888,axiom,
    ! [VarCurr] :
      ( v16063(VarCurr)
    <=> ( v16064(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3632,axiom,
    ! [VarCurr] :
      ( v16064(VarCurr)
    <=> ( v16065(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3631,axiom,
    ! [VarCurr] :
      ( v16065(VarCurr)
    <=> ( v16066(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3630,axiom,
    ! [VarCurr] :
      ( v16066(VarCurr)
    <=> ( v16067(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_887,axiom,
    ! [VarCurr] :
      ( v16067(VarCurr)
    <=> ( v16068(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_886,axiom,
    ! [VarCurr] :
      ( v16068(VarCurr)
    <=> ( v14106(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3629,axiom,
    ! [VarCurr] :
      ( v16017(VarCurr)
    <=> ( v16018(VarCurr)
        | v16053(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3628,axiom,
    ! [VarCurr] :
      ( v16053(VarCurr)
    <=> ( v16055(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_885,axiom,
    ! [VarCurr] :
      ( v16055(VarCurr)
    <=> ( v16056(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3627,axiom,
    ! [VarCurr] :
      ( v16056(VarCurr)
    <=> ( v16057(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3626,axiom,
    ! [VarCurr] :
      ( v16057(VarCurr)
    <=> ( v16058(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3625,axiom,
    ! [VarCurr] :
      ( v16058(VarCurr)
    <=> ( v16059(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_884,axiom,
    ! [VarCurr] :
      ( v16059(VarCurr)
    <=> ( v16060(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_883,axiom,
    ! [VarCurr] :
      ( v16060(VarCurr)
    <=> ( v14550(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3624,axiom,
    ! [VarCurr] :
      ( v16018(VarCurr)
    <=> ( v16019(VarCurr)
        | v16045(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3623,axiom,
    ! [VarCurr] :
      ( v16045(VarCurr)
    <=> ( v16047(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_882,axiom,
    ! [VarCurr] :
      ( v16047(VarCurr)
    <=> ( v16048(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3622,axiom,
    ! [VarCurr] :
      ( v16048(VarCurr)
    <=> ( v16049(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3621,axiom,
    ! [VarCurr] :
      ( v16049(VarCurr)
    <=> ( v16050(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3620,axiom,
    ! [VarCurr] :
      ( v16050(VarCurr)
    <=> ( v16051(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_881,axiom,
    ! [VarCurr] :
      ( v16051(VarCurr)
    <=> ( v16052(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_880,axiom,
    ! [VarCurr] :
      ( v16052(VarCurr)
    <=> ( v14094(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3619,axiom,
    ! [VarCurr] :
      ( v16019(VarCurr)
    <=> ( v16020(VarCurr)
        | v16037(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3618,axiom,
    ! [VarCurr] :
      ( v16037(VarCurr)
    <=> ( v16039(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_879,axiom,
    ! [VarCurr] :
      ( v16039(VarCurr)
    <=> ( v16040(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3617,axiom,
    ! [VarCurr] :
      ( v16040(VarCurr)
    <=> ( v16041(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3616,axiom,
    ! [VarCurr] :
      ( v16041(VarCurr)
    <=> ( v16042(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3615,axiom,
    ! [VarCurr] :
      ( v16042(VarCurr)
    <=> ( v16043(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_878,axiom,
    ! [VarCurr] :
      ( v16043(VarCurr)
    <=> ( v16044(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_877,axiom,
    ! [VarCurr] :
      ( v16044(VarCurr)
    <=> ( v14082(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3614,axiom,
    ! [VarCurr] :
      ( v16020(VarCurr)
    <=> ( v16021(VarCurr)
        | v16029(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3613,axiom,
    ! [VarCurr] :
      ( v16029(VarCurr)
    <=> ( v16031(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_876,axiom,
    ! [VarCurr] :
      ( v16031(VarCurr)
    <=> ( v16032(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3612,axiom,
    ! [VarCurr] :
      ( v16032(VarCurr)
    <=> ( v16033(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3611,axiom,
    ! [VarCurr] :
      ( v16033(VarCurr)
    <=> ( v16034(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3610,axiom,
    ! [VarCurr] :
      ( v16034(VarCurr)
    <=> ( v16035(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_875,axiom,
    ! [VarCurr] :
      ( v16035(VarCurr)
    <=> ( v16036(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_874,axiom,
    ! [VarCurr] :
      ( v16036(VarCurr)
    <=> ( v14065(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3609,axiom,
    ! [VarCurr] :
      ( v16021(VarCurr)
    <=> ( v16023(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_873,axiom,
    ! [VarCurr] :
      ( v16023(VarCurr)
    <=> ( v16024(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3608,axiom,
    ! [VarCurr] :
      ( v16024(VarCurr)
    <=> ( v16025(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3607,axiom,
    ! [VarCurr] :
      ( v16025(VarCurr)
    <=> ( v16026(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3606,axiom,
    ! [VarCurr] :
      ( v16026(VarCurr)
    <=> ( v16027(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_872,axiom,
    ! [VarCurr] :
      ( v16027(VarCurr)
    <=> ( v16028(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_871,axiom,
    ! [VarCurr] :
      ( v16028(VarCurr)
    <=> ( v14046(VarCurr)
        & v12810(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3605,axiom,
    ! [VarCurr] :
      ( v15970(VarCurr)
    <=> ( v15972(VarCurr)
        | v16012(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_870,axiom,
    ! [VarCurr] :
      ( v16012(VarCurr)
    <=> ( v15992(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3604,axiom,
    ! [VarCurr] :
      ( v15972(VarCurr)
    <=> ( v15973(VarCurr)
        | v16010(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_869,axiom,
    ! [VarCurr] :
      ( v16010(VarCurr)
    <=> ( v15988(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3603,axiom,
    ! [VarCurr] :
      ( v15973(VarCurr)
    <=> ( v15974(VarCurr)
        | v16008(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_868,axiom,
    ! [VarCurr] :
      ( v16008(VarCurr)
    <=> ( v15983(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3602,axiom,
    ! [VarCurr] :
      ( v15974(VarCurr)
    <=> ( v15975(VarCurr)
        | v16006(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_867,axiom,
    ! [VarCurr] :
      ( v16006(VarCurr)
    <=> ( v15963(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3601,axiom,
    ! [VarCurr] :
      ( v15975(VarCurr)
    <=> ( v15976(VarCurr)
        | v16003(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3600,axiom,
    ! [VarCurr] :
      ( v16003(VarCurr)
    <=> ( v16005(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_866,axiom,
    ! [VarCurr] :
      ( v16005(VarCurr)
    <=> ( v15993(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3599,axiom,
    ! [VarCurr] :
      ( v15976(VarCurr)
    <=> ( v15977(VarCurr)
        | v16000(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3598,axiom,
    ! [VarCurr] :
      ( v16000(VarCurr)
    <=> ( v16002(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_865,axiom,
    ! [VarCurr] :
      ( v16002(VarCurr)
    <=> ( v15989(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3597,axiom,
    ! [VarCurr] :
      ( v15977(VarCurr)
    <=> ( v15978(VarCurr)
        | v15997(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3596,axiom,
    ! [VarCurr] :
      ( v15997(VarCurr)
    <=> ( v15999(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_864,axiom,
    ! [VarCurr] :
      ( v15999(VarCurr)
    <=> ( v15984(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3595,axiom,
    ! [VarCurr] :
      ( v15978(VarCurr)
    <=> ( v15979(VarCurr)
        | v15994(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3594,axiom,
    ! [VarCurr] :
      ( v15994(VarCurr)
    <=> ( v15996(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_863,axiom,
    ! [VarCurr] :
      ( v15996(VarCurr)
    <=> ( v15964(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3593,axiom,
    ! [VarCurr] :
      ( v15979(VarCurr)
    <=> ( v15980(VarCurr)
        | v15990(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3592,axiom,
    ! [VarCurr] :
      ( v15990(VarCurr)
    <=> ( v15992(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3591,axiom,
    ! [VarCurr] :
      ( v15992(VarCurr)
    <=> ( v15993(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_862,axiom,
    ! [VarCurr] :
      ( v15993(VarCurr)
    <=> ( v15985(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3590,axiom,
    ! [VarCurr] :
      ( v15980(VarCurr)
    <=> ( v15981(VarCurr)
        | v15986(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3589,axiom,
    ! [VarCurr] :
      ( v15986(VarCurr)
    <=> ( v15988(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3588,axiom,
    ! [VarCurr] :
      ( v15988(VarCurr)
    <=> ( v15989(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_861,axiom,
    ! [VarCurr] :
      ( v15989(VarCurr)
    <=> ( v15965(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3587,axiom,
    ! [VarCurr] :
      ( v15981(VarCurr)
    <=> ( v15983(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3586,axiom,
    ! [VarCurr] :
      ( v15983(VarCurr)
    <=> ( v15984(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3585,axiom,
    ! [VarCurr] :
      ( v15984(VarCurr)
    <=> ( v15985(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3584,axiom,
    ! [VarCurr] :
      ( v15985(VarCurr)
    <=> ( v15966(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3583,axiom,
    ! [VarCurr] :
      ( v15961(VarCurr)
    <=> ( v15963(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3582,axiom,
    ! [VarCurr] :
      ( v15963(VarCurr)
    <=> ( v15964(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3581,axiom,
    ! [VarCurr] :
      ( v15964(VarCurr)
    <=> ( v15965(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3580,axiom,
    ! [VarCurr] :
      ( v15965(VarCurr)
    <=> ( v15966(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_860,axiom,
    ! [VarCurr] :
      ( v15966(VarCurr)
    <=> ( v15967(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_859,axiom,
    ! [VarCurr] :
      ( v15967(VarCurr)
    <=> ( v15968(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_858,axiom,
    ! [VarCurr] :
      ( v15968(VarCurr)
    <=> ( v15969(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3579,axiom,
    ! [VarCurr] :
      ( v15969(VarCurr)
    <=> ( v15917(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3578,axiom,
    ! [VarCurr] :
      ( v15921(VarCurr)
    <=> ( v15923(VarCurr)
        | v15958(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_857,axiom,
    ! [VarCurr] :
      ( v15958(VarCurr)
    <=> ( v15960(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_856,axiom,
    ! [VarCurr] :
      ( v15960(VarCurr)
    <=> ( v15648(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3577,axiom,
    ! [VarCurr] :
      ( v15923(VarCurr)
    <=> ( v15924(VarCurr)
        | v15956(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_855,axiom,
    ! [VarCurr] :
      ( v15956(VarCurr)
    <=> ( v15325(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3576,axiom,
    ! [VarCurr] :
      ( v15924(VarCurr)
    <=> ( v15925(VarCurr)
        | v15954(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_854,axiom,
    ! [VarCurr] :
      ( v15954(VarCurr)
    <=> ( v15317(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3575,axiom,
    ! [VarCurr] :
      ( v15925(VarCurr)
    <=> ( v15926(VarCurr)
        | v15952(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_853,axiom,
    ! [VarCurr] :
      ( v15952(VarCurr)
    <=> ( v15313(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3574,axiom,
    ! [VarCurr] :
      ( v15926(VarCurr)
    <=> ( v15927(VarCurr)
        | v15950(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_852,axiom,
    ! [VarCurr] :
      ( v15950(VarCurr)
    <=> ( v15309(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3573,axiom,
    ! [VarCurr] :
      ( v15927(VarCurr)
    <=> ( v15928(VarCurr)
        | v15948(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_851,axiom,
    ! [VarCurr] :
      ( v15948(VarCurr)
    <=> ( v15305(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3572,axiom,
    ! [VarCurr] :
      ( v15928(VarCurr)
    <=> ( v15929(VarCurr)
        | v15944(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_850,axiom,
    ! [VarCurr] :
      ( v15944(VarCurr)
    <=> ( v15946(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_849,axiom,
    ! [VarCurr] :
      ( v15946(VarCurr)
    <=> ( v15947(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_848,axiom,
    ! [VarCurr] :
      ( v15947(VarCurr)
    <=> ( v15819(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3571,axiom,
    ! [VarCurr] :
      ( v15929(VarCurr)
    <=> ( v15930(VarCurr)
        | v15941(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_847,axiom,
    ! [VarCurr] :
      ( v15941(VarCurr)
    <=> ( v15943(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_846,axiom,
    ! [VarCurr] :
      ( v15943(VarCurr)
    <=> ( v15625(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3570,axiom,
    ! [VarCurr] :
      ( v15930(VarCurr)
    <=> ( v15931(VarCurr)
        | v15939(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_845,axiom,
    ! [VarCurr] :
      ( v15939(VarCurr)
    <=> ( v15301(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3569,axiom,
    ! [VarCurr] :
      ( v15931(VarCurr)
    <=> ( v15932(VarCurr)
        | v15937(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_844,axiom,
    ! [VarCurr] :
      ( v15937(VarCurr)
    <=> ( v15297(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3568,axiom,
    ! [VarCurr] :
      ( v15932(VarCurr)
    <=> ( v15933(VarCurr)
        | v15935(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_843,axiom,
    ! [VarCurr] :
      ( v15935(VarCurr)
    <=> ( v15293(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_842,axiom,
    ! [VarCurr] :
      ( v15933(VarCurr)
    <=> ( v15289(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_841,axiom,
    ! [VarCurr] :
      ( v15912(VarCurr)
    <=> ( v15914(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_840,axiom,
    ! [VarCurr] :
      ( v15914(VarCurr)
    <=> ( v15915(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_839,axiom,
    ! [VarCurr] :
      ( v15915(VarCurr)
    <=> ( v15916(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3567,axiom,
    ! [VarCurr] :
      ( v15916(VarCurr)
    <=> ( v15917(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3566,axiom,
    ! [VarCurr] :
      ( v15917(VarCurr)
    <=> ( v15918(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_838,axiom,
    ! [VarCurr] :
      ( v15918(VarCurr)
    <=> ( v15919(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3565,axiom,
    ! [VarCurr] :
      ( v15919(VarCurr)
    <=> ( v15920(VarCurr)
        & v14056(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3564,axiom,
    ! [VarCurr] :
      ( v15920(VarCurr)
    <=> ( v15066(VarCurr)
        & v12810(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_837,axiom,
    ! [VarCurr] :
      ( v15909(VarCurr)
    <=> ( v15911(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_836,axiom,
    ! [VarCurr] :
      ( v15911(VarCurr)
    <=> ( v15594(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3563,axiom,
    ! [VarCurr] :
      ( v15873(VarCurr)
    <=> ( v15875(VarCurr)
        | v15907(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_835,axiom,
    ! [VarCurr] :
      ( v15907(VarCurr)
    <=> ( v15272(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3562,axiom,
    ! [VarCurr] :
      ( v15875(VarCurr)
    <=> ( v15876(VarCurr)
        | v15905(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_834,axiom,
    ! [VarCurr] :
      ( v15905(VarCurr)
    <=> ( v15267(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3561,axiom,
    ! [VarCurr] :
      ( v15876(VarCurr)
    <=> ( v15877(VarCurr)
        | v15903(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_833,axiom,
    ! [VarCurr] :
      ( v15903(VarCurr)
    <=> ( v15262(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3560,axiom,
    ! [VarCurr] :
      ( v15877(VarCurr)
    <=> ( v15878(VarCurr)
        | v15901(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_832,axiom,
    ! [VarCurr] :
      ( v15901(VarCurr)
    <=> ( v15256(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3559,axiom,
    ! [VarCurr] :
      ( v15878(VarCurr)
    <=> ( v15879(VarCurr)
        | v15899(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_831,axiom,
    ! [VarCurr] :
      ( v15899(VarCurr)
    <=> ( v15251(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3558,axiom,
    ! [VarCurr] :
      ( v15879(VarCurr)
    <=> ( v15880(VarCurr)
        | v15895(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_830,axiom,
    ! [VarCurr] :
      ( v15895(VarCurr)
    <=> ( v15897(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_829,axiom,
    ! [VarCurr] :
      ( v15897(VarCurr)
    <=> ( v15898(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_828,axiom,
    ! [VarCurr] :
      ( v15898(VarCurr)
    <=> ( v15724(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3557,axiom,
    ! [VarCurr] :
      ( v15880(VarCurr)
    <=> ( v15881(VarCurr)
        | v15892(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_827,axiom,
    ! [VarCurr] :
      ( v15892(VarCurr)
    <=> ( v15894(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_826,axiom,
    ! [VarCurr] :
      ( v15894(VarCurr)
    <=> ( v15575(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3556,axiom,
    ! [VarCurr] :
      ( v15881(VarCurr)
    <=> ( v15882(VarCurr)
        | v15890(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_825,axiom,
    ! [VarCurr] :
      ( v15890(VarCurr)
    <=> ( v15246(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3555,axiom,
    ! [VarCurr] :
      ( v15882(VarCurr)
    <=> ( v15883(VarCurr)
        | v15888(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_824,axiom,
    ! [VarCurr] :
      ( v15888(VarCurr)
    <=> ( v15241(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3554,axiom,
    ! [VarCurr] :
      ( v15883(VarCurr)
    <=> ( v15884(VarCurr)
        | v15886(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_823,axiom,
    ! [VarCurr] :
      ( v15886(VarCurr)
    <=> ( v15236(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_822,axiom,
    ! [VarCurr] :
      ( v15884(VarCurr)
    <=> ( v15231(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3553,axiom,
    ! [VarCurr] :
      ( v15855(VarCurr)
    <=> ( v15857(VarCurr)
        | v15870(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_821,axiom,
    ! [VarCurr] :
      ( v15870(VarCurr)
    <=> ( v15872(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3552,axiom,
    ! [VarCurr] :
      ( v15872(VarCurr)
    <=> ( v15866(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3551,axiom,
    ! [VarCurr] :
      ( v15857(VarCurr)
    <=> ( v15858(VarCurr)
        | v15867(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_820,axiom,
    ! [VarCurr] :
      ( v15867(VarCurr)
    <=> ( v15869(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3550,axiom,
    ! [VarCurr] :
      ( v15869(VarCurr)
    <=> ( v15862(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3549,axiom,
    ! [VarCurr] :
      ( v15858(VarCurr)
    <=> ( v15859(VarCurr)
        | v15863(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3548,axiom,
    ! [VarCurr] :
      ( v15863(VarCurr)
    <=> ( v15865(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_819,axiom,
    ! [VarCurr] :
      ( v15865(VarCurr)
    <=> ( v15866(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_818,axiom,
    ! [VarCurr] :
      ( v15866(VarCurr)
    <=> ( v15836(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3547,axiom,
    ! [VarCurr] :
      ( v15859(VarCurr)
    <=> ( v15861(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_817,axiom,
    ! [VarCurr] :
      ( v15861(VarCurr)
    <=> ( v15862(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3546,axiom,
    ! [VarCurr] :
      ( v15862(VarCurr)
    <=> ( v15836(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3545,axiom,
    ! [VarCurr] :
      ( v15839(VarCurr)
    <=> ( v15841(VarCurr)
        | v15851(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3544,axiom,
    ! [VarCurr] :
      ( v15851(VarCurr)
    <=> ( v15853(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3543,axiom,
    ! [VarCurr] :
      ( v15853(VarCurr)
    <=> ( v15854(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_816,axiom,
    ! [VarCurr] :
      ( v15854(VarCurr)
    <=> ( v15846(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3542,axiom,
    ! [VarCurr] :
      ( v15841(VarCurr)
    <=> ( v15842(VarCurr)
        | v15847(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3541,axiom,
    ! [VarCurr] :
      ( v15847(VarCurr)
    <=> ( v15849(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3540,axiom,
    ! [VarCurr] :
      ( v15849(VarCurr)
    <=> ( v15850(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_815,axiom,
    ! [VarCurr] :
      ( v15850(VarCurr)
    <=> ( v15835(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3539,axiom,
    ! [VarCurr] :
      ( v15842(VarCurr)
    <=> ( v15844(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3538,axiom,
    ! [VarCurr] :
      ( v15844(VarCurr)
    <=> ( v15845(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3537,axiom,
    ! [VarCurr] :
      ( v15845(VarCurr)
    <=> ( v15846(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3536,axiom,
    ! [VarCurr] :
      ( v15846(VarCurr)
    <=> ( v15836(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3535,axiom,
    ! [VarCurr] :
      ( v15831(VarCurr)
    <=> ( v15833(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3534,axiom,
    ! [VarCurr] :
      ( v15833(VarCurr)
    <=> ( v15834(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3533,axiom,
    ! [VarCurr] :
      ( v15834(VarCurr)
    <=> ( v15835(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3532,axiom,
    ! [VarCurr] :
      ( v15835(VarCurr)
    <=> ( v15836(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_814,axiom,
    ! [VarCurr] :
      ( v15836(VarCurr)
    <=> ( v15837(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_813,axiom,
    ! [VarCurr] :
      ( v15837(VarCurr)
    <=> ( v15838(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3531,axiom,
    ! [VarCurr] :
      ( v15838(VarCurr)
    <=> ( v15649(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3530,axiom,
    ! [VarCurr] :
      ( v15793(VarCurr)
    <=> ( v15795(VarCurr)
        | v15828(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_812,axiom,
    ! [VarCurr] :
      ( v15828(VarCurr)
    <=> ( v15830(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_811,axiom,
    ! [VarCurr] :
      ( v15830(VarCurr)
    <=> ( v15516(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3529,axiom,
    ! [VarCurr] :
      ( v15795(VarCurr)
    <=> ( v15796(VarCurr)
        | v15826(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_810,axiom,
    ! [VarCurr] :
      ( v15826(VarCurr)
    <=> ( v15148(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3528,axiom,
    ! [VarCurr] :
      ( v15796(VarCurr)
    <=> ( v15797(VarCurr)
        | v15824(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_809,axiom,
    ! [VarCurr] :
      ( v15824(VarCurr)
    <=> ( v15135(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3527,axiom,
    ! [VarCurr] :
      ( v15797(VarCurr)
    <=> ( v15798(VarCurr)
        | v15822(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_808,axiom,
    ! [VarCurr] :
      ( v15822(VarCurr)
    <=> ( v15121(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3526,axiom,
    ! [VarCurr] :
      ( v15798(VarCurr)
    <=> ( v15799(VarCurr)
        | v15820(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_807,axiom,
    ! [VarCurr] :
      ( v15820(VarCurr)
    <=> ( v15112(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3525,axiom,
    ! [VarCurr] :
      ( v15799(VarCurr)
    <=> ( v15800(VarCurr)
        | v15815(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_806,axiom,
    ! [VarCurr] :
      ( v15815(VarCurr)
    <=> ( v15817(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_805,axiom,
    ! [VarCurr] :
      ( v15817(VarCurr)
    <=> ( v15818(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3524,axiom,
    ! [VarCurr] :
      ( v15818(VarCurr)
    <=> ( v15819(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3523,axiom,
    ! [VarCurr] :
      ( v15819(VarCurr)
    <=> ( v15725(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3522,axiom,
    ! [VarCurr] :
      ( v15800(VarCurr)
    <=> ( v15801(VarCurr)
        | v15812(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_804,axiom,
    ! [VarCurr] :
      ( v15812(VarCurr)
    <=> ( v15814(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_803,axiom,
    ! [VarCurr] :
      ( v15814(VarCurr)
    <=> ( v15495(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3521,axiom,
    ! [VarCurr] :
      ( v15801(VarCurr)
    <=> ( v15802(VarCurr)
        | v15810(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_802,axiom,
    ! [VarCurr] :
      ( v15810(VarCurr)
    <=> ( v15103(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3520,axiom,
    ! [VarCurr] :
      ( v15802(VarCurr)
    <=> ( v15803(VarCurr)
        | v15808(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_801,axiom,
    ! [VarCurr] :
      ( v15808(VarCurr)
    <=> ( v15094(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3519,axiom,
    ! [VarCurr] :
      ( v15803(VarCurr)
    <=> ( v15804(VarCurr)
        | v15806(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_800,axiom,
    ! [VarCurr] :
      ( v15806(VarCurr)
    <=> ( v15085(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_799,axiom,
    ! [VarCurr] :
      ( v15804(VarCurr)
    <=> ( v15076(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3518,axiom,
    ! [VarCurr] :
      ( v15784(VarCurr)
    <=> ( v15785(VarCurr)
        | v15789(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_798,axiom,
    ! [VarCurr] :
      ( v15789(VarCurr)
    <=> ( v15791(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3517,axiom,
    ! [VarCurr] :
      ( v15791(VarCurr)
    <=> ( v15792(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_797,axiom,
    ! [VarCurr] :
      ( v15792(VarCurr)
    <=> ( v15749(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_796,axiom,
    ! [VarCurr] :
      ( v15785(VarCurr)
    <=> ( v15787(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3516,axiom,
    ! [VarCurr] :
      ( v15787(VarCurr)
    <=> ( v15788(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3515,axiom,
    ! [VarCurr] :
      ( v15788(VarCurr)
    <=> ( v15749(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3514,axiom,
    ! [VarCurr] :
      ( v15752(VarCurr)
    <=> ( v15754(VarCurr)
        | v15781(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3513,axiom,
    ! [VarCurr] :
      ( v15781(VarCurr)
    <=> ( v15783(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_795,axiom,
    ! [VarCurr] :
      ( v15783(VarCurr)
    <=> ( v15771(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3512,axiom,
    ! [VarCurr] :
      ( v15754(VarCurr)
    <=> ( v15755(VarCurr)
        | v15778(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3511,axiom,
    ! [VarCurr] :
      ( v15778(VarCurr)
    <=> ( v15780(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_794,axiom,
    ! [VarCurr] :
      ( v15780(VarCurr)
    <=> ( v15767(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3510,axiom,
    ! [VarCurr] :
      ( v15755(VarCurr)
    <=> ( v15756(VarCurr)
        | v15775(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3509,axiom,
    ! [VarCurr] :
      ( v15775(VarCurr)
    <=> ( v15777(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_793,axiom,
    ! [VarCurr] :
      ( v15777(VarCurr)
    <=> ( v15762(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3508,axiom,
    ! [VarCurr] :
      ( v15756(VarCurr)
    <=> ( v15757(VarCurr)
        | v15772(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3507,axiom,
    ! [VarCurr] :
      ( v15772(VarCurr)
    <=> ( v15774(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_792,axiom,
    ! [VarCurr] :
      ( v15774(VarCurr)
    <=> ( v15747(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3506,axiom,
    ! [VarCurr] :
      ( v15757(VarCurr)
    <=> ( v15758(VarCurr)
        | v15768(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3505,axiom,
    ! [VarCurr] :
      ( v15768(VarCurr)
    <=> ( v15770(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3504,axiom,
    ! [VarCurr] :
      ( v15770(VarCurr)
    <=> ( v15771(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_791,axiom,
    ! [VarCurr] :
      ( v15771(VarCurr)
    <=> ( v15763(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3503,axiom,
    ! [VarCurr] :
      ( v15758(VarCurr)
    <=> ( v15759(VarCurr)
        | v15764(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3502,axiom,
    ! [VarCurr] :
      ( v15764(VarCurr)
    <=> ( v15766(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3501,axiom,
    ! [VarCurr] :
      ( v15766(VarCurr)
    <=> ( v15767(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_790,axiom,
    ! [VarCurr] :
      ( v15767(VarCurr)
    <=> ( v15748(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3500,axiom,
    ! [VarCurr] :
      ( v15759(VarCurr)
    <=> ( v15761(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3499,axiom,
    ! [VarCurr] :
      ( v15761(VarCurr)
    <=> ( v15762(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3498,axiom,
    ! [VarCurr] :
      ( v15762(VarCurr)
    <=> ( v15763(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3497,axiom,
    ! [VarCurr] :
      ( v15763(VarCurr)
    <=> ( v15749(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3496,axiom,
    ! [VarCurr] :
      ( v15744(VarCurr)
    <=> ( v15746(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3495,axiom,
    ! [VarCurr] :
      ( v15746(VarCurr)
    <=> ( v15747(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3494,axiom,
    ! [VarCurr] :
      ( v15747(VarCurr)
    <=> ( v15748(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3493,axiom,
    ! [VarCurr] :
      ( v15748(VarCurr)
    <=> ( v15749(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_789,axiom,
    ! [VarCurr] :
      ( v15749(VarCurr)
    <=> ( v15750(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_788,axiom,
    ! [VarCurr] :
      ( v15750(VarCurr)
    <=> ( v15751(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3492,axiom,
    ! [VarCurr] :
      ( v15751(VarCurr)
    <=> ( v15595(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3491,axiom,
    ! [VarCurr] :
      ( v15694(VarCurr)
    <=> ( v15696(VarCurr)
        | v15741(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_787,axiom,
    ! [VarCurr] :
      ( v15741(VarCurr)
    <=> ( v15743(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_786,axiom,
    ! [VarCurr] :
      ( v15743(VarCurr)
    <=> ( v15429(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3490,axiom,
    ! [VarCurr] :
      ( v15696(VarCurr)
    <=> ( v15697(VarCurr)
        | v15738(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_785,axiom,
    ! [VarCurr] :
      ( v15738(VarCurr)
    <=> ( v15740(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_784,axiom,
    ! [VarCurr] :
      ( v15740(VarCurr)
    <=> ( v15421(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3489,axiom,
    ! [VarCurr] :
      ( v15697(VarCurr)
    <=> ( v15698(VarCurr)
        | v15735(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_783,axiom,
    ! [VarCurr] :
      ( v15735(VarCurr)
    <=> ( v15737(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_782,axiom,
    ! [VarCurr] :
      ( v15737(VarCurr)
    <=> ( v15417(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3488,axiom,
    ! [VarCurr] :
      ( v15698(VarCurr)
    <=> ( v15699(VarCurr)
        | v15732(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_781,axiom,
    ! [VarCurr] :
      ( v15732(VarCurr)
    <=> ( v15734(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_780,axiom,
    ! [VarCurr] :
      ( v15734(VarCurr)
    <=> ( v15413(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3487,axiom,
    ! [VarCurr] :
      ( v15699(VarCurr)
    <=> ( v15700(VarCurr)
        | v15729(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_779,axiom,
    ! [VarCurr] :
      ( v15729(VarCurr)
    <=> ( v15731(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_778,axiom,
    ! [VarCurr] :
      ( v15731(VarCurr)
    <=> ( v15409(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3486,axiom,
    ! [VarCurr] :
      ( v15700(VarCurr)
    <=> ( v15701(VarCurr)
        | v15720(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_777,axiom,
    ! [VarCurr] :
      ( v15720(VarCurr)
    <=> ( v15722(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_776,axiom,
    ! [VarCurr] :
      ( v15722(VarCurr)
    <=> ( v15723(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3485,axiom,
    ! [VarCurr] :
      ( v15723(VarCurr)
    <=> ( v15724(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3484,axiom,
    ! [VarCurr] :
      ( v15724(VarCurr)
    <=> ( v15725(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3483,axiom,
    ! [VarCurr] :
      ( v15725(VarCurr)
    <=> ( v15726(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_775,axiom,
    ! [VarCurr] :
      ( v15726(VarCurr)
    <=> ( v15727(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3482,axiom,
    ! [VarCurr] :
      ( v15727(VarCurr)
    <=> ( v15728(VarCurr)
        & v14056(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3481,axiom,
    ! [VarCurr] :
      ( v15728(VarCurr)
    <=> ( v14875(VarCurr)
        & v12810(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3480,axiom,
    ! [VarCurr] :
      ( v15701(VarCurr)
    <=> ( v15702(VarCurr)
        | v15717(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_774,axiom,
    ! [VarCurr] :
      ( v15717(VarCurr)
    <=> ( v15719(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_773,axiom,
    ! [VarCurr] :
      ( v15719(VarCurr)
    <=> ( v15400(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3479,axiom,
    ! [VarCurr] :
      ( v15702(VarCurr)
    <=> ( v15703(VarCurr)
        | v15714(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_772,axiom,
    ! [VarCurr] :
      ( v15714(VarCurr)
    <=> ( v15716(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_771,axiom,
    ! [VarCurr] :
      ( v15716(VarCurr)
    <=> ( v15396(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3478,axiom,
    ! [VarCurr] :
      ( v15703(VarCurr)
    <=> ( v15704(VarCurr)
        | v15711(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_770,axiom,
    ! [VarCurr] :
      ( v15711(VarCurr)
    <=> ( v15713(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_769,axiom,
    ! [VarCurr] :
      ( v15713(VarCurr)
    <=> ( v15392(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3477,axiom,
    ! [VarCurr] :
      ( v15704(VarCurr)
    <=> ( v15705(VarCurr)
        | v15708(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_768,axiom,
    ! [VarCurr] :
      ( v15708(VarCurr)
    <=> ( v15710(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_767,axiom,
    ! [VarCurr] :
      ( v15710(VarCurr)
    <=> ( v15388(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_766,axiom,
    ! [VarCurr] :
      ( v15705(VarCurr)
    <=> ( v15707(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_765,axiom,
    ! [VarCurr] :
      ( v15707(VarCurr)
    <=> ( v15384(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3476,axiom,
    ! [VarCurr] :
      ( v15650(VarCurr)
    <=> ( v15652(VarCurr)
        | v15692(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_764,axiom,
    ! [VarCurr] :
      ( v15692(VarCurr)
    <=> ( v15672(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3475,axiom,
    ! [VarCurr] :
      ( v15652(VarCurr)
    <=> ( v15653(VarCurr)
        | v15690(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_763,axiom,
    ! [VarCurr] :
      ( v15690(VarCurr)
    <=> ( v15668(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3474,axiom,
    ! [VarCurr] :
      ( v15653(VarCurr)
    <=> ( v15654(VarCurr)
        | v15688(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_762,axiom,
    ! [VarCurr] :
      ( v15688(VarCurr)
    <=> ( v15663(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3473,axiom,
    ! [VarCurr] :
      ( v15654(VarCurr)
    <=> ( v15655(VarCurr)
        | v15686(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_761,axiom,
    ! [VarCurr] :
      ( v15686(VarCurr)
    <=> ( v15643(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3472,axiom,
    ! [VarCurr] :
      ( v15655(VarCurr)
    <=> ( v15656(VarCurr)
        | v15683(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3471,axiom,
    ! [VarCurr] :
      ( v15683(VarCurr)
    <=> ( v15685(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_760,axiom,
    ! [VarCurr] :
      ( v15685(VarCurr)
    <=> ( v15673(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3470,axiom,
    ! [VarCurr] :
      ( v15656(VarCurr)
    <=> ( v15657(VarCurr)
        | v15680(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3469,axiom,
    ! [VarCurr] :
      ( v15680(VarCurr)
    <=> ( v15682(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_759,axiom,
    ! [VarCurr] :
      ( v15682(VarCurr)
    <=> ( v15669(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3468,axiom,
    ! [VarCurr] :
      ( v15657(VarCurr)
    <=> ( v15658(VarCurr)
        | v15677(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3467,axiom,
    ! [VarCurr] :
      ( v15677(VarCurr)
    <=> ( v15679(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_758,axiom,
    ! [VarCurr] :
      ( v15679(VarCurr)
    <=> ( v15664(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3466,axiom,
    ! [VarCurr] :
      ( v15658(VarCurr)
    <=> ( v15659(VarCurr)
        | v15674(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3465,axiom,
    ! [VarCurr] :
      ( v15674(VarCurr)
    <=> ( v15676(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_757,axiom,
    ! [VarCurr] :
      ( v15676(VarCurr)
    <=> ( v15644(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3464,axiom,
    ! [VarCurr] :
      ( v15659(VarCurr)
    <=> ( v15660(VarCurr)
        | v15670(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3463,axiom,
    ! [VarCurr] :
      ( v15670(VarCurr)
    <=> ( v15672(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3462,axiom,
    ! [VarCurr] :
      ( v15672(VarCurr)
    <=> ( v15673(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_756,axiom,
    ! [VarCurr] :
      ( v15673(VarCurr)
    <=> ( v15665(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3461,axiom,
    ! [VarCurr] :
      ( v15660(VarCurr)
    <=> ( v15661(VarCurr)
        | v15666(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3460,axiom,
    ! [VarCurr] :
      ( v15666(VarCurr)
    <=> ( v15668(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3459,axiom,
    ! [VarCurr] :
      ( v15668(VarCurr)
    <=> ( v15669(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_755,axiom,
    ! [VarCurr] :
      ( v15669(VarCurr)
    <=> ( v15645(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3458,axiom,
    ! [VarCurr] :
      ( v15661(VarCurr)
    <=> ( v15663(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3457,axiom,
    ! [VarCurr] :
      ( v15663(VarCurr)
    <=> ( v15664(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3456,axiom,
    ! [VarCurr] :
      ( v15664(VarCurr)
    <=> ( v15665(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3455,axiom,
    ! [VarCurr] :
      ( v15665(VarCurr)
    <=> ( v15646(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3454,axiom,
    ! [VarCurr] :
      ( v15641(VarCurr)
    <=> ( v15643(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3453,axiom,
    ! [VarCurr] :
      ( v15643(VarCurr)
    <=> ( v15644(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3452,axiom,
    ! [VarCurr] :
      ( v15644(VarCurr)
    <=> ( v15645(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3451,axiom,
    ! [VarCurr] :
      ( v15645(VarCurr)
    <=> ( v15646(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_754,axiom,
    ! [VarCurr] :
      ( v15646(VarCurr)
    <=> ( v15647(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3450,axiom,
    ! [VarCurr] :
      ( v15647(VarCurr)
    <=> ( v15648(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_753,axiom,
    ! [VarCurr] :
      ( v15648(VarCurr)
    <=> ( v15649(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3449,axiom,
    ! [VarCurr] :
      ( v15649(VarCurr)
    <=> ( v15596(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3448,axiom,
    ! [VarCurr] :
      ( v15600(VarCurr)
    <=> ( v15602(VarCurr)
        | v15638(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_752,axiom,
    ! [VarCurr] :
      ( v15638(VarCurr)
    <=> ( v15640(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3447,axiom,
    ! [VarCurr] :
      ( v15640(VarCurr)
    <=> ( v15326(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3446,axiom,
    ! [VarCurr] :
      ( v15602(VarCurr)
    <=> ( v15603(VarCurr)
        | v15635(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_751,axiom,
    ! [VarCurr] :
      ( v15635(VarCurr)
    <=> ( v15637(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3445,axiom,
    ! [VarCurr] :
      ( v15637(VarCurr)
    <=> ( v15318(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3444,axiom,
    ! [VarCurr] :
      ( v15603(VarCurr)
    <=> ( v15604(VarCurr)
        | v15632(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_750,axiom,
    ! [VarCurr] :
      ( v15632(VarCurr)
    <=> ( v15634(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3443,axiom,
    ! [VarCurr] :
      ( v15634(VarCurr)
    <=> ( v15314(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3442,axiom,
    ! [VarCurr] :
      ( v15604(VarCurr)
    <=> ( v15605(VarCurr)
        | v15629(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_749,axiom,
    ! [VarCurr] :
      ( v15629(VarCurr)
    <=> ( v15631(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3441,axiom,
    ! [VarCurr] :
      ( v15631(VarCurr)
    <=> ( v15310(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3440,axiom,
    ! [VarCurr] :
      ( v15605(VarCurr)
    <=> ( v15606(VarCurr)
        | v15626(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_748,axiom,
    ! [VarCurr] :
      ( v15626(VarCurr)
    <=> ( v15628(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3439,axiom,
    ! [VarCurr] :
      ( v15628(VarCurr)
    <=> ( v15306(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3438,axiom,
    ! [VarCurr] :
      ( v15606(VarCurr)
    <=> ( v15607(VarCurr)
        | v15622(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_747,axiom,
    ! [VarCurr] :
      ( v15622(VarCurr)
    <=> ( v15624(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3437,axiom,
    ! [VarCurr] :
      ( v15624(VarCurr)
    <=> ( v15625(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_746,axiom,
    ! [VarCurr] :
      ( v15625(VarCurr)
    <=> ( v15496(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3436,axiom,
    ! [VarCurr] :
      ( v15607(VarCurr)
    <=> ( v15608(VarCurr)
        | v15619(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_745,axiom,
    ! [VarCurr] :
      ( v15619(VarCurr)
    <=> ( v15621(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3435,axiom,
    ! [VarCurr] :
      ( v15621(VarCurr)
    <=> ( v15302(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3434,axiom,
    ! [VarCurr] :
      ( v15608(VarCurr)
    <=> ( v15609(VarCurr)
        | v15616(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_744,axiom,
    ! [VarCurr] :
      ( v15616(VarCurr)
    <=> ( v15618(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3433,axiom,
    ! [VarCurr] :
      ( v15618(VarCurr)
    <=> ( v15298(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3432,axiom,
    ! [VarCurr] :
      ( v15609(VarCurr)
    <=> ( v15610(VarCurr)
        | v15613(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_743,axiom,
    ! [VarCurr] :
      ( v15613(VarCurr)
    <=> ( v15615(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3431,axiom,
    ! [VarCurr] :
      ( v15615(VarCurr)
    <=> ( v15294(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_742,axiom,
    ! [VarCurr] :
      ( v15610(VarCurr)
    <=> ( v15612(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3430,axiom,
    ! [VarCurr] :
      ( v15612(VarCurr)
    <=> ( v15290(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_741,axiom,
    ! [VarCurr] :
      ( v15591(VarCurr)
    <=> ( v15593(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3429,axiom,
    ! [VarCurr] :
      ( v15593(VarCurr)
    <=> ( v15594(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_740,axiom,
    ! [VarCurr] :
      ( v15594(VarCurr)
    <=> ( v15595(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3428,axiom,
    ! [VarCurr] :
      ( v15595(VarCurr)
    <=> ( v15596(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3427,axiom,
    ! [VarCurr] :
      ( v15596(VarCurr)
    <=> ( v15597(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_739,axiom,
    ! [VarCurr] :
      ( v15597(VarCurr)
    <=> ( v15598(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3426,axiom,
    ! [VarCurr] :
      ( v15598(VarCurr)
    <=> ( v15599(VarCurr)
        & v14056(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3425,axiom,
    ! [VarCurr] :
      ( v15599(VarCurr)
    <=> ( v14747(VarCurr)
        & v12810(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_738,axiom,
    ! [VarCurr] :
      ( v15588(VarCurr)
    <=> ( v15590(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3424,axiom,
    ! [VarCurr] :
      ( v15590(VarCurr)
    <=> ( v15273(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3423,axiom,
    ! [VarCurr] :
      ( v15551(VarCurr)
    <=> ( v15553(VarCurr)
        | v15585(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_737,axiom,
    ! [VarCurr] :
      ( v15585(VarCurr)
    <=> ( v15587(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3422,axiom,
    ! [VarCurr] :
      ( v15587(VarCurr)
    <=> ( v15268(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3421,axiom,
    ! [VarCurr] :
      ( v15553(VarCurr)
    <=> ( v15554(VarCurr)
        | v15582(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_736,axiom,
    ! [VarCurr] :
      ( v15582(VarCurr)
    <=> ( v15584(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3420,axiom,
    ! [VarCurr] :
      ( v15584(VarCurr)
    <=> ( v15263(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3419,axiom,
    ! [VarCurr] :
      ( v15554(VarCurr)
    <=> ( v15555(VarCurr)
        | v15579(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_735,axiom,
    ! [VarCurr] :
      ( v15579(VarCurr)
    <=> ( v15581(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3418,axiom,
    ! [VarCurr] :
      ( v15581(VarCurr)
    <=> ( v15257(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3417,axiom,
    ! [VarCurr] :
      ( v15555(VarCurr)
    <=> ( v15556(VarCurr)
        | v15576(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_734,axiom,
    ! [VarCurr] :
      ( v15576(VarCurr)
    <=> ( v15578(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3416,axiom,
    ! [VarCurr] :
      ( v15578(VarCurr)
    <=> ( v15252(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3415,axiom,
    ! [VarCurr] :
      ( v15556(VarCurr)
    <=> ( v15557(VarCurr)
        | v15572(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_733,axiom,
    ! [VarCurr] :
      ( v15572(VarCurr)
    <=> ( v15574(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3414,axiom,
    ! [VarCurr] :
      ( v15574(VarCurr)
    <=> ( v15575(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_732,axiom,
    ! [VarCurr] :
      ( v15575(VarCurr)
    <=> ( v15401(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3413,axiom,
    ! [VarCurr] :
      ( v15557(VarCurr)
    <=> ( v15558(VarCurr)
        | v15569(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_731,axiom,
    ! [VarCurr] :
      ( v15569(VarCurr)
    <=> ( v15571(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3412,axiom,
    ! [VarCurr] :
      ( v15571(VarCurr)
    <=> ( v15247(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3411,axiom,
    ! [VarCurr] :
      ( v15558(VarCurr)
    <=> ( v15559(VarCurr)
        | v15566(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_730,axiom,
    ! [VarCurr] :
      ( v15566(VarCurr)
    <=> ( v15568(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3410,axiom,
    ! [VarCurr] :
      ( v15568(VarCurr)
    <=> ( v15242(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3409,axiom,
    ! [VarCurr] :
      ( v15559(VarCurr)
    <=> ( v15560(VarCurr)
        | v15563(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_729,axiom,
    ! [VarCurr] :
      ( v15563(VarCurr)
    <=> ( v15565(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3408,axiom,
    ! [VarCurr] :
      ( v15565(VarCurr)
    <=> ( v15237(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_728,axiom,
    ! [VarCurr] :
      ( v15560(VarCurr)
    <=> ( v15562(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3407,axiom,
    ! [VarCurr] :
      ( v15562(VarCurr)
    <=> ( v15232(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3406,axiom,
    ! [VarCurr] :
      ( v15533(VarCurr)
    <=> ( v15535(VarCurr)
        | v15548(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_727,axiom,
    ! [VarCurr] :
      ( v15548(VarCurr)
    <=> ( v15550(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3405,axiom,
    ! [VarCurr] :
      ( v15550(VarCurr)
    <=> ( v15544(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3404,axiom,
    ! [VarCurr] :
      ( v15535(VarCurr)
    <=> ( v15536(VarCurr)
        | v15545(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_726,axiom,
    ! [VarCurr] :
      ( v15545(VarCurr)
    <=> ( v15547(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3403,axiom,
    ! [VarCurr] :
      ( v15547(VarCurr)
    <=> ( v15540(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3402,axiom,
    ! [VarCurr] :
      ( v15536(VarCurr)
    <=> ( v15537(VarCurr)
        | v15541(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3401,axiom,
    ! [VarCurr] :
      ( v15541(VarCurr)
    <=> ( v15543(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_725,axiom,
    ! [VarCurr] :
      ( v15543(VarCurr)
    <=> ( v15544(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_724,axiom,
    ! [VarCurr] :
      ( v15544(VarCurr)
    <=> ( v15514(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3400,axiom,
    ! [VarCurr] :
      ( v15537(VarCurr)
    <=> ( v15539(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_723,axiom,
    ! [VarCurr] :
      ( v15539(VarCurr)
    <=> ( v15540(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3399,axiom,
    ! [VarCurr] :
      ( v15540(VarCurr)
    <=> ( v15514(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3398,axiom,
    ! [VarCurr] :
      ( v15517(VarCurr)
    <=> ( v15519(VarCurr)
        | v15529(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3397,axiom,
    ! [VarCurr] :
      ( v15529(VarCurr)
    <=> ( v15531(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3396,axiom,
    ! [VarCurr] :
      ( v15531(VarCurr)
    <=> ( v15532(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_722,axiom,
    ! [VarCurr] :
      ( v15532(VarCurr)
    <=> ( v15524(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3395,axiom,
    ! [VarCurr] :
      ( v15519(VarCurr)
    <=> ( v15520(VarCurr)
        | v15525(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3394,axiom,
    ! [VarCurr] :
      ( v15525(VarCurr)
    <=> ( v15527(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3393,axiom,
    ! [VarCurr] :
      ( v15527(VarCurr)
    <=> ( v15528(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_721,axiom,
    ! [VarCurr] :
      ( v15528(VarCurr)
    <=> ( v15513(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3392,axiom,
    ! [VarCurr] :
      ( v15520(VarCurr)
    <=> ( v15522(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3391,axiom,
    ! [VarCurr] :
      ( v15522(VarCurr)
    <=> ( v15523(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3390,axiom,
    ! [VarCurr] :
      ( v15523(VarCurr)
    <=> ( v15524(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3389,axiom,
    ! [VarCurr] :
      ( v15524(VarCurr)
    <=> ( v15514(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3388,axiom,
    ! [VarCurr] :
      ( v15509(VarCurr)
    <=> ( v15511(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3387,axiom,
    ! [VarCurr] :
      ( v15511(VarCurr)
    <=> ( v15512(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3386,axiom,
    ! [VarCurr] :
      ( v15512(VarCurr)
    <=> ( v15513(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3385,axiom,
    ! [VarCurr] :
      ( v15513(VarCurr)
    <=> ( v15514(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_720,axiom,
    ! [VarCurr] :
      ( v15514(VarCurr)
    <=> ( v15515(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3384,axiom,
    ! [VarCurr] :
      ( v15515(VarCurr)
    <=> ( v15516(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3383,axiom,
    ! [VarCurr] :
      ( v15516(VarCurr)
    <=> ( v15327(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3382,axiom,
    ! [VarCurr] :
      ( v15471(VarCurr)
    <=> ( v15473(VarCurr)
        | v15506(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_719,axiom,
    ! [VarCurr] :
      ( v15506(VarCurr)
    <=> ( v15508(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3381,axiom,
    ! [VarCurr] :
      ( v15508(VarCurr)
    <=> ( v15149(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3380,axiom,
    ! [VarCurr] :
      ( v15473(VarCurr)
    <=> ( v15474(VarCurr)
        | v15503(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_718,axiom,
    ! [VarCurr] :
      ( v15503(VarCurr)
    <=> ( v15505(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3379,axiom,
    ! [VarCurr] :
      ( v15505(VarCurr)
    <=> ( v15136(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3378,axiom,
    ! [VarCurr] :
      ( v15474(VarCurr)
    <=> ( v15475(VarCurr)
        | v15500(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_717,axiom,
    ! [VarCurr] :
      ( v15500(VarCurr)
    <=> ( v15502(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3377,axiom,
    ! [VarCurr] :
      ( v15502(VarCurr)
    <=> ( v15122(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3376,axiom,
    ! [VarCurr] :
      ( v15475(VarCurr)
    <=> ( v15476(VarCurr)
        | v15497(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_716,axiom,
    ! [VarCurr] :
      ( v15497(VarCurr)
    <=> ( v15499(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3375,axiom,
    ! [VarCurr] :
      ( v15499(VarCurr)
    <=> ( v15113(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3374,axiom,
    ! [VarCurr] :
      ( v15476(VarCurr)
    <=> ( v15477(VarCurr)
        | v15492(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_715,axiom,
    ! [VarCurr] :
      ( v15492(VarCurr)
    <=> ( v15494(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3373,axiom,
    ! [VarCurr] :
      ( v15494(VarCurr)
    <=> ( v15495(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3372,axiom,
    ! [VarCurr] :
      ( v15495(VarCurr)
    <=> ( v15496(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3371,axiom,
    ! [VarCurr] :
      ( v15496(VarCurr)
    <=> ( v15402(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3370,axiom,
    ! [VarCurr] :
      ( v15477(VarCurr)
    <=> ( v15478(VarCurr)
        | v15489(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_714,axiom,
    ! [VarCurr] :
      ( v15489(VarCurr)
    <=> ( v15491(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3369,axiom,
    ! [VarCurr] :
      ( v15491(VarCurr)
    <=> ( v15104(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3368,axiom,
    ! [VarCurr] :
      ( v15478(VarCurr)
    <=> ( v15479(VarCurr)
        | v15486(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_713,axiom,
    ! [VarCurr] :
      ( v15486(VarCurr)
    <=> ( v15488(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3367,axiom,
    ! [VarCurr] :
      ( v15488(VarCurr)
    <=> ( v15095(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3366,axiom,
    ! [VarCurr] :
      ( v15479(VarCurr)
    <=> ( v15480(VarCurr)
        | v15483(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_712,axiom,
    ! [VarCurr] :
      ( v15483(VarCurr)
    <=> ( v15485(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3365,axiom,
    ! [VarCurr] :
      ( v15485(VarCurr)
    <=> ( v15086(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_711,axiom,
    ! [VarCurr] :
      ( v15480(VarCurr)
    <=> ( v15482(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3364,axiom,
    ! [VarCurr] :
      ( v15482(VarCurr)
    <=> ( v15077(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3363,axiom,
    ! [VarCurr] :
      ( v15462(VarCurr)
    <=> ( v15463(VarCurr)
        | v15467(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_710,axiom,
    ! [VarCurr] :
      ( v15467(VarCurr)
    <=> ( v15469(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3362,axiom,
    ! [VarCurr] :
      ( v15469(VarCurr)
    <=> ( v15470(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_709,axiom,
    ! [VarCurr] :
      ( v15470(VarCurr)
    <=> ( v15427(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_708,axiom,
    ! [VarCurr] :
      ( v15463(VarCurr)
    <=> ( v15465(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3361,axiom,
    ! [VarCurr] :
      ( v15465(VarCurr)
    <=> ( v15466(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3360,axiom,
    ! [VarCurr] :
      ( v15466(VarCurr)
    <=> ( v15427(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3359,axiom,
    ! [VarCurr] :
      ( v15430(VarCurr)
    <=> ( v15432(VarCurr)
        | v15459(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3358,axiom,
    ! [VarCurr] :
      ( v15459(VarCurr)
    <=> ( v15461(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_707,axiom,
    ! [VarCurr] :
      ( v15461(VarCurr)
    <=> ( v15449(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3357,axiom,
    ! [VarCurr] :
      ( v15432(VarCurr)
    <=> ( v15433(VarCurr)
        | v15456(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3356,axiom,
    ! [VarCurr] :
      ( v15456(VarCurr)
    <=> ( v15458(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_706,axiom,
    ! [VarCurr] :
      ( v15458(VarCurr)
    <=> ( v15445(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3355,axiom,
    ! [VarCurr] :
      ( v15433(VarCurr)
    <=> ( v15434(VarCurr)
        | v15453(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3354,axiom,
    ! [VarCurr] :
      ( v15453(VarCurr)
    <=> ( v15455(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_705,axiom,
    ! [VarCurr] :
      ( v15455(VarCurr)
    <=> ( v15440(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3353,axiom,
    ! [VarCurr] :
      ( v15434(VarCurr)
    <=> ( v15435(VarCurr)
        | v15450(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3352,axiom,
    ! [VarCurr] :
      ( v15450(VarCurr)
    <=> ( v15452(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_704,axiom,
    ! [VarCurr] :
      ( v15452(VarCurr)
    <=> ( v15425(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3351,axiom,
    ! [VarCurr] :
      ( v15435(VarCurr)
    <=> ( v15436(VarCurr)
        | v15446(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3350,axiom,
    ! [VarCurr] :
      ( v15446(VarCurr)
    <=> ( v15448(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3349,axiom,
    ! [VarCurr] :
      ( v15448(VarCurr)
    <=> ( v15449(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_703,axiom,
    ! [VarCurr] :
      ( v15449(VarCurr)
    <=> ( v15441(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3348,axiom,
    ! [VarCurr] :
      ( v15436(VarCurr)
    <=> ( v15437(VarCurr)
        | v15442(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3347,axiom,
    ! [VarCurr] :
      ( v15442(VarCurr)
    <=> ( v15444(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3346,axiom,
    ! [VarCurr] :
      ( v15444(VarCurr)
    <=> ( v15445(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_702,axiom,
    ! [VarCurr] :
      ( v15445(VarCurr)
    <=> ( v15426(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3345,axiom,
    ! [VarCurr] :
      ( v15437(VarCurr)
    <=> ( v15439(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3344,axiom,
    ! [VarCurr] :
      ( v15439(VarCurr)
    <=> ( v15440(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3343,axiom,
    ! [VarCurr] :
      ( v15440(VarCurr)
    <=> ( v15441(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3342,axiom,
    ! [VarCurr] :
      ( v15441(VarCurr)
    <=> ( v15427(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3341,axiom,
    ! [VarCurr] :
      ( v15422(VarCurr)
    <=> ( v15424(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3340,axiom,
    ! [VarCurr] :
      ( v15424(VarCurr)
    <=> ( v15425(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3339,axiom,
    ! [VarCurr] :
      ( v15425(VarCurr)
    <=> ( v15426(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3338,axiom,
    ! [VarCurr] :
      ( v15426(VarCurr)
    <=> ( v15427(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_701,axiom,
    ! [VarCurr] :
      ( v15427(VarCurr)
    <=> ( v15428(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3337,axiom,
    ! [VarCurr] :
      ( v15428(VarCurr)
    <=> ( v15429(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3336,axiom,
    ! [VarCurr] :
      ( v15429(VarCurr)
    <=> ( v15274(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3335,axiom,
    ! [VarCurr] :
      ( v15372(VarCurr)
    <=> ( v15374(VarCurr)
        | v15418(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_700,axiom,
    ! [VarCurr] :
      ( v15418(VarCurr)
    <=> ( v15420(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3334,axiom,
    ! [VarCurr] :
      ( v15420(VarCurr)
    <=> ( v15421(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3333,axiom,
    ! [VarCurr] :
      ( v15421(VarCurr)
    <=> ( v15269(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3332,axiom,
    ! [VarCurr] :
      ( v15374(VarCurr)
    <=> ( v15375(VarCurr)
        | v15414(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_699,axiom,
    ! [VarCurr] :
      ( v15414(VarCurr)
    <=> ( v15416(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3331,axiom,
    ! [VarCurr] :
      ( v15416(VarCurr)
    <=> ( v15417(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3330,axiom,
    ! [VarCurr] :
      ( v15417(VarCurr)
    <=> ( v15264(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3329,axiom,
    ! [VarCurr] :
      ( v15375(VarCurr)
    <=> ( v15376(VarCurr)
        | v15410(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_698,axiom,
    ! [VarCurr] :
      ( v15410(VarCurr)
    <=> ( v15412(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3328,axiom,
    ! [VarCurr] :
      ( v15412(VarCurr)
    <=> ( v15413(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3327,axiom,
    ! [VarCurr] :
      ( v15413(VarCurr)
    <=> ( v15258(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3326,axiom,
    ! [VarCurr] :
      ( v15376(VarCurr)
    <=> ( v15377(VarCurr)
        | v15406(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_697,axiom,
    ! [VarCurr] :
      ( v15406(VarCurr)
    <=> ( v15408(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3325,axiom,
    ! [VarCurr] :
      ( v15408(VarCurr)
    <=> ( v15409(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3324,axiom,
    ! [VarCurr] :
      ( v15409(VarCurr)
    <=> ( v15253(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3323,axiom,
    ! [VarCurr] :
      ( v15377(VarCurr)
    <=> ( v15378(VarCurr)
        | v15397(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_696,axiom,
    ! [VarCurr] :
      ( v15397(VarCurr)
    <=> ( v15399(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3322,axiom,
    ! [VarCurr] :
      ( v15399(VarCurr)
    <=> ( v15400(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3321,axiom,
    ! [VarCurr] :
      ( v15400(VarCurr)
    <=> ( v15401(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3320,axiom,
    ! [VarCurr] :
      ( v15401(VarCurr)
    <=> ( v15402(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3319,axiom,
    ! [VarCurr] :
      ( v15402(VarCurr)
    <=> ( v15403(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_695,axiom,
    ! [VarCurr] :
      ( v15403(VarCurr)
    <=> ( v15404(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3318,axiom,
    ! [VarCurr] :
      ( v15404(VarCurr)
    <=> ( v15405(VarCurr)
        & v14056(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3317,axiom,
    ! [VarCurr] :
      ( v15405(VarCurr)
    <=> ( v14551(VarCurr)
        & v12810(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3316,axiom,
    ! [VarCurr] :
      ( v15378(VarCurr)
    <=> ( v15379(VarCurr)
        | v15393(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_694,axiom,
    ! [VarCurr] :
      ( v15393(VarCurr)
    <=> ( v15395(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3315,axiom,
    ! [VarCurr] :
      ( v15395(VarCurr)
    <=> ( v15396(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3314,axiom,
    ! [VarCurr] :
      ( v15396(VarCurr)
    <=> ( v15248(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3313,axiom,
    ! [VarCurr] :
      ( v15379(VarCurr)
    <=> ( v15380(VarCurr)
        | v15389(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_693,axiom,
    ! [VarCurr] :
      ( v15389(VarCurr)
    <=> ( v15391(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3312,axiom,
    ! [VarCurr] :
      ( v15391(VarCurr)
    <=> ( v15392(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3311,axiom,
    ! [VarCurr] :
      ( v15392(VarCurr)
    <=> ( v15243(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3310,axiom,
    ! [VarCurr] :
      ( v15380(VarCurr)
    <=> ( v15381(VarCurr)
        | v15385(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_692,axiom,
    ! [VarCurr] :
      ( v15385(VarCurr)
    <=> ( v15387(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3309,axiom,
    ! [VarCurr] :
      ( v15387(VarCurr)
    <=> ( v15388(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3308,axiom,
    ! [VarCurr] :
      ( v15388(VarCurr)
    <=> ( v15238(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_691,axiom,
    ! [VarCurr] :
      ( v15381(VarCurr)
    <=> ( v15383(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3307,axiom,
    ! [VarCurr] :
      ( v15383(VarCurr)
    <=> ( v15384(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3306,axiom,
    ! [VarCurr] :
      ( v15384(VarCurr)
    <=> ( v15233(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3305,axiom,
    ! [VarCurr] :
      ( v15328(VarCurr)
    <=> ( v15330(VarCurr)
        | v15370(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_690,axiom,
    ! [VarCurr] :
      ( v15370(VarCurr)
    <=> ( v15350(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3304,axiom,
    ! [VarCurr] :
      ( v15330(VarCurr)
    <=> ( v15331(VarCurr)
        | v15368(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_689,axiom,
    ! [VarCurr] :
      ( v15368(VarCurr)
    <=> ( v15346(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3303,axiom,
    ! [VarCurr] :
      ( v15331(VarCurr)
    <=> ( v15332(VarCurr)
        | v15366(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_688,axiom,
    ! [VarCurr] :
      ( v15366(VarCurr)
    <=> ( v15341(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3302,axiom,
    ! [VarCurr] :
      ( v15332(VarCurr)
    <=> ( v15333(VarCurr)
        | v15364(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_687,axiom,
    ! [VarCurr] :
      ( v15364(VarCurr)
    <=> ( v15321(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3301,axiom,
    ! [VarCurr] :
      ( v15333(VarCurr)
    <=> ( v15334(VarCurr)
        | v15361(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3300,axiom,
    ! [VarCurr] :
      ( v15361(VarCurr)
    <=> ( v15363(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_686,axiom,
    ! [VarCurr] :
      ( v15363(VarCurr)
    <=> ( v15351(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3299,axiom,
    ! [VarCurr] :
      ( v15334(VarCurr)
    <=> ( v15335(VarCurr)
        | v15358(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3298,axiom,
    ! [VarCurr] :
      ( v15358(VarCurr)
    <=> ( v15360(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_685,axiom,
    ! [VarCurr] :
      ( v15360(VarCurr)
    <=> ( v15347(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3297,axiom,
    ! [VarCurr] :
      ( v15335(VarCurr)
    <=> ( v15336(VarCurr)
        | v15355(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3296,axiom,
    ! [VarCurr] :
      ( v15355(VarCurr)
    <=> ( v15357(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_684,axiom,
    ! [VarCurr] :
      ( v15357(VarCurr)
    <=> ( v15342(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3295,axiom,
    ! [VarCurr] :
      ( v15336(VarCurr)
    <=> ( v15337(VarCurr)
        | v15352(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3294,axiom,
    ! [VarCurr] :
      ( v15352(VarCurr)
    <=> ( v15354(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_683,axiom,
    ! [VarCurr] :
      ( v15354(VarCurr)
    <=> ( v15322(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3293,axiom,
    ! [VarCurr] :
      ( v15337(VarCurr)
    <=> ( v15338(VarCurr)
        | v15348(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3292,axiom,
    ! [VarCurr] :
      ( v15348(VarCurr)
    <=> ( v15350(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3291,axiom,
    ! [VarCurr] :
      ( v15350(VarCurr)
    <=> ( v15351(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_682,axiom,
    ! [VarCurr] :
      ( v15351(VarCurr)
    <=> ( v15343(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3290,axiom,
    ! [VarCurr] :
      ( v15338(VarCurr)
    <=> ( v15339(VarCurr)
        | v15344(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3289,axiom,
    ! [VarCurr] :
      ( v15344(VarCurr)
    <=> ( v15346(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3288,axiom,
    ! [VarCurr] :
      ( v15346(VarCurr)
    <=> ( v15347(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_681,axiom,
    ! [VarCurr] :
      ( v15347(VarCurr)
    <=> ( v15323(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3287,axiom,
    ! [VarCurr] :
      ( v15339(VarCurr)
    <=> ( v15341(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3286,axiom,
    ! [VarCurr] :
      ( v15341(VarCurr)
    <=> ( v15342(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3285,axiom,
    ! [VarCurr] :
      ( v15342(VarCurr)
    <=> ( v15343(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3284,axiom,
    ! [VarCurr] :
      ( v15343(VarCurr)
    <=> ( v15324(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3283,axiom,
    ! [VarCurr] :
      ( v15319(VarCurr)
    <=> ( v15321(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3282,axiom,
    ! [VarCurr] :
      ( v15321(VarCurr)
    <=> ( v15322(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3281,axiom,
    ! [VarCurr] :
      ( v15322(VarCurr)
    <=> ( v15323(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3280,axiom,
    ! [VarCurr] :
      ( v15323(VarCurr)
    <=> ( v15324(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3279,axiom,
    ! [VarCurr] :
      ( v15324(VarCurr)
    <=> ( v15325(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_680,axiom,
    ! [VarCurr] :
      ( v15325(VarCurr)
    <=> ( v15326(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_679,axiom,
    ! [VarCurr] :
      ( v15326(VarCurr)
    <=> ( v15327(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3278,axiom,
    ! [VarCurr] :
      ( v15327(VarCurr)
    <=> ( v15275(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3277,axiom,
    ! [VarCurr] :
      ( v15279(VarCurr)
    <=> ( v15281(VarCurr)
        | v15315(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3276,axiom,
    ! [VarCurr] :
      ( v15315(VarCurr)
    <=> ( v15317(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_678,axiom,
    ! [VarCurr] :
      ( v15317(VarCurr)
    <=> ( v15318(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_677,axiom,
    ! [VarCurr] :
      ( v15318(VarCurr)
    <=> ( v15150(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3275,axiom,
    ! [VarCurr] :
      ( v15281(VarCurr)
    <=> ( v15282(VarCurr)
        | v15311(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3274,axiom,
    ! [VarCurr] :
      ( v15311(VarCurr)
    <=> ( v15313(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_676,axiom,
    ! [VarCurr] :
      ( v15313(VarCurr)
    <=> ( v15314(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_675,axiom,
    ! [VarCurr] :
      ( v15314(VarCurr)
    <=> ( v15137(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3273,axiom,
    ! [VarCurr] :
      ( v15282(VarCurr)
    <=> ( v15283(VarCurr)
        | v15307(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3272,axiom,
    ! [VarCurr] :
      ( v15307(VarCurr)
    <=> ( v15309(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_674,axiom,
    ! [VarCurr] :
      ( v15309(VarCurr)
    <=> ( v15310(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_673,axiom,
    ! [VarCurr] :
      ( v15310(VarCurr)
    <=> ( v15123(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3271,axiom,
    ! [VarCurr] :
      ( v15283(VarCurr)
    <=> ( v15284(VarCurr)
        | v15303(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3270,axiom,
    ! [VarCurr] :
      ( v15303(VarCurr)
    <=> ( v15305(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_672,axiom,
    ! [VarCurr] :
      ( v15305(VarCurr)
    <=> ( v15306(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_671,axiom,
    ! [VarCurr] :
      ( v15306(VarCurr)
    <=> ( v15114(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3269,axiom,
    ! [VarCurr] :
      ( v15284(VarCurr)
    <=> ( v15285(VarCurr)
        | v15299(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3268,axiom,
    ! [VarCurr] :
      ( v15299(VarCurr)
    <=> ( v15301(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_670,axiom,
    ! [VarCurr] :
      ( v15301(VarCurr)
    <=> ( v15302(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_669,axiom,
    ! [VarCurr] :
      ( v15302(VarCurr)
    <=> ( v15105(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3267,axiom,
    ! [VarCurr] :
      ( v15285(VarCurr)
    <=> ( v15286(VarCurr)
        | v15295(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3266,axiom,
    ! [VarCurr] :
      ( v15295(VarCurr)
    <=> ( v15297(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_668,axiom,
    ! [VarCurr] :
      ( v15297(VarCurr)
    <=> ( v15298(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_667,axiom,
    ! [VarCurr] :
      ( v15298(VarCurr)
    <=> ( v15096(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3265,axiom,
    ! [VarCurr] :
      ( v15286(VarCurr)
    <=> ( v15287(VarCurr)
        | v15291(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3264,axiom,
    ! [VarCurr] :
      ( v15291(VarCurr)
    <=> ( v15293(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_666,axiom,
    ! [VarCurr] :
      ( v15293(VarCurr)
    <=> ( v15294(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_665,axiom,
    ! [VarCurr] :
      ( v15294(VarCurr)
    <=> ( v15087(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3263,axiom,
    ! [VarCurr] :
      ( v15287(VarCurr)
    <=> ( v15289(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_664,axiom,
    ! [VarCurr] :
      ( v15289(VarCurr)
    <=> ( v15290(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_663,axiom,
    ! [VarCurr] :
      ( v15290(VarCurr)
    <=> ( v15078(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3262,axiom,
    ! [VarCurr] :
      ( v15270(VarCurr)
    <=> ( v15272(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_662,axiom,
    ! [VarCurr] :
      ( v15272(VarCurr)
    <=> ( v15273(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_661,axiom,
    ! [VarCurr] :
      ( v15273(VarCurr)
    <=> ( v15274(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3261,axiom,
    ! [VarCurr] :
      ( v15274(VarCurr)
    <=> ( v15275(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3260,axiom,
    ! [VarCurr] :
      ( v15275(VarCurr)
    <=> ( v15276(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_660,axiom,
    ! [VarCurr] :
      ( v15276(VarCurr)
    <=> ( v15277(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3259,axiom,
    ! [VarCurr] :
      ( v15277(VarCurr)
    <=> ( v15278(VarCurr)
        & v14056(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3258,axiom,
    ! [VarCurr] :
      ( v15278(VarCurr)
    <=> ( v14421(VarCurr)
        & v12810(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3257,axiom,
    ! [VarCurr] :
      ( v15259(VarCurr)
    <=> ( v15260(VarCurr)
        | v15265(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3256,axiom,
    ! [VarCurr] :
      ( v15265(VarCurr)
    <=> ( v15267(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_659,axiom,
    ! [VarCurr] :
      ( v15267(VarCurr)
    <=> ( v15268(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_658,axiom,
    ! [VarCurr] :
      ( v15268(VarCurr)
    <=> ( v15269(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3255,axiom,
    ! [VarCurr] :
      ( v15269(VarCurr)
    <=> ( v15151(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3254,axiom,
    ! [VarCurr] :
      ( v15260(VarCurr)
    <=> ( v15262(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_657,axiom,
    ! [VarCurr] :
      ( v15262(VarCurr)
    <=> ( v15263(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_656,axiom,
    ! [VarCurr] :
      ( v15263(VarCurr)
    <=> ( v15264(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3253,axiom,
    ! [VarCurr] :
      ( v15264(VarCurr)
    <=> ( v15138(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3252,axiom,
    ! [VarCurr] :
      ( v15223(VarCurr)
    <=> ( v15225(VarCurr)
        | v15254(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3251,axiom,
    ! [VarCurr] :
      ( v15254(VarCurr)
    <=> ( v15256(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_655,axiom,
    ! [VarCurr] :
      ( v15256(VarCurr)
    <=> ( v15257(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_654,axiom,
    ! [VarCurr] :
      ( v15257(VarCurr)
    <=> ( v15258(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3250,axiom,
    ! [VarCurr] :
      ( v15258(VarCurr)
    <=> ( v15124(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3249,axiom,
    ! [VarCurr] :
      ( v15225(VarCurr)
    <=> ( v15226(VarCurr)
        | v15249(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3248,axiom,
    ! [VarCurr] :
      ( v15249(VarCurr)
    <=> ( v15251(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_653,axiom,
    ! [VarCurr] :
      ( v15251(VarCurr)
    <=> ( v15252(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_652,axiom,
    ! [VarCurr] :
      ( v15252(VarCurr)
    <=> ( v15253(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3247,axiom,
    ! [VarCurr] :
      ( v15253(VarCurr)
    <=> ( v15115(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3246,axiom,
    ! [VarCurr] :
      ( v15226(VarCurr)
    <=> ( v15227(VarCurr)
        | v15244(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3245,axiom,
    ! [VarCurr] :
      ( v15244(VarCurr)
    <=> ( v15246(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_651,axiom,
    ! [VarCurr] :
      ( v15246(VarCurr)
    <=> ( v15247(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_650,axiom,
    ! [VarCurr] :
      ( v15247(VarCurr)
    <=> ( v15248(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3244,axiom,
    ! [VarCurr] :
      ( v15248(VarCurr)
    <=> ( v15106(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3243,axiom,
    ! [VarCurr] :
      ( v15227(VarCurr)
    <=> ( v15228(VarCurr)
        | v15239(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3242,axiom,
    ! [VarCurr] :
      ( v15239(VarCurr)
    <=> ( v15241(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_649,axiom,
    ! [VarCurr] :
      ( v15241(VarCurr)
    <=> ( v15242(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_648,axiom,
    ! [VarCurr] :
      ( v15242(VarCurr)
    <=> ( v15243(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3241,axiom,
    ! [VarCurr] :
      ( v15243(VarCurr)
    <=> ( v15097(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3240,axiom,
    ! [VarCurr] :
      ( v15228(VarCurr)
    <=> ( v15229(VarCurr)
        | v15234(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3239,axiom,
    ! [VarCurr] :
      ( v15234(VarCurr)
    <=> ( v15236(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_647,axiom,
    ! [VarCurr] :
      ( v15236(VarCurr)
    <=> ( v15237(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_646,axiom,
    ! [VarCurr] :
      ( v15237(VarCurr)
    <=> ( v15238(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3238,axiom,
    ! [VarCurr] :
      ( v15238(VarCurr)
    <=> ( v15088(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3237,axiom,
    ! [VarCurr] :
      ( v15229(VarCurr)
    <=> ( v15231(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_645,axiom,
    ! [VarCurr] :
      ( v15231(VarCurr)
    <=> ( v15232(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_644,axiom,
    ! [VarCurr] :
      ( v15232(VarCurr)
    <=> ( v15233(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3236,axiom,
    ! [VarCurr] :
      ( v15233(VarCurr)
    <=> ( v15079(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3235,axiom,
    ! [VarCurr] :
      ( v15187(VarCurr)
    <=> ( v15189(VarCurr)
        | v15220(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_643,axiom,
    ! [VarCurr] :
      ( v15220(VarCurr)
    <=> ( v15222(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3234,axiom,
    ! [VarCurr] :
      ( v15222(VarCurr)
    <=> ( v15210(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3233,axiom,
    ! [VarCurr] :
      ( v15189(VarCurr)
    <=> ( v15190(VarCurr)
        | v15217(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_642,axiom,
    ! [VarCurr] :
      ( v15217(VarCurr)
    <=> ( v15219(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3232,axiom,
    ! [VarCurr] :
      ( v15219(VarCurr)
    <=> ( v15206(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3231,axiom,
    ! [VarCurr] :
      ( v15190(VarCurr)
    <=> ( v15191(VarCurr)
        | v15214(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_641,axiom,
    ! [VarCurr] :
      ( v15214(VarCurr)
    <=> ( v15216(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3230,axiom,
    ! [VarCurr] :
      ( v15216(VarCurr)
    <=> ( v15202(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3229,axiom,
    ! [VarCurr] :
      ( v15191(VarCurr)
    <=> ( v15192(VarCurr)
        | v15211(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_640,axiom,
    ! [VarCurr] :
      ( v15211(VarCurr)
    <=> ( v15213(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3228,axiom,
    ! [VarCurr] :
      ( v15213(VarCurr)
    <=> ( v15198(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3227,axiom,
    ! [VarCurr] :
      ( v15192(VarCurr)
    <=> ( v15193(VarCurr)
        | v15207(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3226,axiom,
    ! [VarCurr] :
      ( v15207(VarCurr)
    <=> ( v15209(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_639,axiom,
    ! [VarCurr] :
      ( v15209(VarCurr)
    <=> ( v15210(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_638,axiom,
    ! [VarCurr] :
      ( v15210(VarCurr)
    <=> ( v15147(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3225,axiom,
    ! [VarCurr] :
      ( v15193(VarCurr)
    <=> ( v15194(VarCurr)
        | v15203(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3224,axiom,
    ! [VarCurr] :
      ( v15203(VarCurr)
    <=> ( v15205(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_637,axiom,
    ! [VarCurr] :
      ( v15205(VarCurr)
    <=> ( v15206(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_636,axiom,
    ! [VarCurr] :
      ( v15206(VarCurr)
    <=> ( v15134(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3223,axiom,
    ! [VarCurr] :
      ( v15194(VarCurr)
    <=> ( v15195(VarCurr)
        | v15199(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3222,axiom,
    ! [VarCurr] :
      ( v15199(VarCurr)
    <=> ( v15201(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_635,axiom,
    ! [VarCurr] :
      ( v15201(VarCurr)
    <=> ( v15202(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3221,axiom,
    ! [VarCurr] :
      ( v15202(VarCurr)
    <=> ( v15147(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3220,axiom,
    ! [VarCurr] :
      ( v15195(VarCurr)
    <=> ( v15197(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_634,axiom,
    ! [VarCurr] :
      ( v15197(VarCurr)
    <=> ( v15198(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3219,axiom,
    ! [VarCurr] :
      ( v15198(VarCurr)
    <=> ( v15134(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3218,axiom,
    ! [VarCurr] :
      ( v15155(VarCurr)
    <=> ( v15157(VarCurr)
        | v15183(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3217,axiom,
    ! [VarCurr] :
      ( v15183(VarCurr)
    <=> ( v15185(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3216,axiom,
    ! [VarCurr] :
      ( v15185(VarCurr)
    <=> ( v15186(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_633,axiom,
    ! [VarCurr] :
      ( v15186(VarCurr)
    <=> ( v15170(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3215,axiom,
    ! [VarCurr] :
      ( v15157(VarCurr)
    <=> ( v15158(VarCurr)
        | v15179(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3214,axiom,
    ! [VarCurr] :
      ( v15179(VarCurr)
    <=> ( v15181(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3213,axiom,
    ! [VarCurr] :
      ( v15181(VarCurr)
    <=> ( v15182(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_632,axiom,
    ! [VarCurr] :
      ( v15182(VarCurr)
    <=> ( v15165(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3212,axiom,
    ! [VarCurr] :
      ( v15158(VarCurr)
    <=> ( v15159(VarCurr)
        | v15175(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3211,axiom,
    ! [VarCurr] :
      ( v15175(VarCurr)
    <=> ( v15177(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3210,axiom,
    ! [VarCurr] :
      ( v15177(VarCurr)
    <=> ( v15178(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_631,axiom,
    ! [VarCurr] :
      ( v15178(VarCurr)
    <=> ( v15146(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3209,axiom,
    ! [VarCurr] :
      ( v15159(VarCurr)
    <=> ( v15160(VarCurr)
        | v15171(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3208,axiom,
    ! [VarCurr] :
      ( v15171(VarCurr)
    <=> ( v15173(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3207,axiom,
    ! [VarCurr] :
      ( v15173(VarCurr)
    <=> ( v15174(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_630,axiom,
    ! [VarCurr] :
      ( v15174(VarCurr)
    <=> ( v15133(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3206,axiom,
    ! [VarCurr] :
      ( v15160(VarCurr)
    <=> ( v15161(VarCurr)
        | v15166(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3205,axiom,
    ! [VarCurr] :
      ( v15166(VarCurr)
    <=> ( v15168(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3204,axiom,
    ! [VarCurr] :
      ( v15168(VarCurr)
    <=> ( v15169(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3203,axiom,
    ! [VarCurr] :
      ( v15169(VarCurr)
    <=> ( v15170(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3202,axiom,
    ! [VarCurr] :
      ( v15170(VarCurr)
    <=> ( v15147(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3201,axiom,
    ! [VarCurr] :
      ( v15161(VarCurr)
    <=> ( v15163(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3200,axiom,
    ! [VarCurr] :
      ( v15163(VarCurr)
    <=> ( v15164(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3199,axiom,
    ! [VarCurr] :
      ( v15164(VarCurr)
    <=> ( v15165(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3198,axiom,
    ! [VarCurr] :
      ( v15165(VarCurr)
    <=> ( v15134(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3197,axiom,
    ! [VarCurr] :
      ( v15128(VarCurr)
    <=> ( v15129(VarCurr)
        | v15142(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3196,axiom,
    ! [VarCurr] :
      ( v15142(VarCurr)
    <=> ( v15144(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3195,axiom,
    ! [VarCurr] :
      ( v15144(VarCurr)
    <=> ( v15145(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3194,axiom,
    ! [VarCurr] :
      ( v15145(VarCurr)
    <=> ( v15146(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3193,axiom,
    ! [VarCurr] :
      ( v15146(VarCurr)
    <=> ( v15147(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3192,axiom,
    ! [VarCurr] :
      ( v15147(VarCurr)
    <=> ( v15148(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_629,axiom,
    ! [VarCurr] :
      ( v15148(VarCurr)
    <=> ( v15149(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3191,axiom,
    ! [VarCurr] :
      ( v15149(VarCurr)
    <=> ( v15150(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3190,axiom,
    ! [VarCurr] :
      ( v15150(VarCurr)
    <=> ( v15151(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3189,axiom,
    ! [VarCurr] :
      ( v15151(VarCurr)
    <=> ( v15152(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_628,axiom,
    ! [VarCurr] :
      ( v15152(VarCurr)
    <=> ( v15153(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3188,axiom,
    ! [VarCurr] :
      ( v15153(VarCurr)
    <=> ( v15154(VarCurr)
        & v14056(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3187,axiom,
    ! [VarCurr] :
      ( v15154(VarCurr)
    <=> ( v14162(VarCurr)
        & v12810(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3186,axiom,
    ! [VarCurr] :
      ( v15129(VarCurr)
    <=> ( v15131(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3185,axiom,
    ! [VarCurr] :
      ( v15131(VarCurr)
    <=> ( v15132(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3184,axiom,
    ! [VarCurr] :
      ( v15132(VarCurr)
    <=> ( v15133(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3183,axiom,
    ! [VarCurr] :
      ( v15133(VarCurr)
    <=> ( v15134(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3182,axiom,
    ! [VarCurr] :
      ( v15134(VarCurr)
    <=> ( v15135(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_627,axiom,
    ! [VarCurr] :
      ( v15135(VarCurr)
    <=> ( v15136(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3181,axiom,
    ! [VarCurr] :
      ( v15136(VarCurr)
    <=> ( v15137(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3180,axiom,
    ! [VarCurr] :
      ( v15137(VarCurr)
    <=> ( v15138(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3179,axiom,
    ! [VarCurr] :
      ( v15138(VarCurr)
    <=> ( v15139(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_626,axiom,
    ! [VarCurr] :
      ( v15139(VarCurr)
    <=> ( v15140(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3178,axiom,
    ! [VarCurr] :
      ( v15140(VarCurr)
    <=> ( v15141(VarCurr)
        & v14056(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3177,axiom,
    ! [VarCurr] :
      ( v15141(VarCurr)
    <=> ( v14142(VarCurr)
        & v12810(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3176,axiom,
    ! [VarCurr] :
      ( v15068(VarCurr)
    <=> ( v15070(VarCurr)
        | v15119(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3175,axiom,
    ! [VarCurr] :
      ( v15119(VarCurr)
    <=> ( v15121(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_625,axiom,
    ! [VarCurr] :
      ( v15121(VarCurr)
    <=> ( v15122(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3174,axiom,
    ! [VarCurr] :
      ( v15122(VarCurr)
    <=> ( v15123(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3173,axiom,
    ! [VarCurr] :
      ( v15123(VarCurr)
    <=> ( v15124(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3172,axiom,
    ! [VarCurr] :
      ( v15124(VarCurr)
    <=> ( v15125(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_624,axiom,
    ! [VarCurr] :
      ( v15125(VarCurr)
    <=> ( v15126(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3171,axiom,
    ! [VarCurr] :
      ( v15126(VarCurr)
    <=> ( v15127(VarCurr)
        & v14056(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3170,axiom,
    ! [VarCurr] :
      ( v15127(VarCurr)
    <=> ( v14122(VarCurr)
        & v12810(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3169,axiom,
    ! [VarCurr] :
      ( v15070(VarCurr)
    <=> ( v15071(VarCurr)
        | v15110(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3168,axiom,
    ! [VarCurr] :
      ( v15110(VarCurr)
    <=> ( v15112(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_623,axiom,
    ! [VarCurr] :
      ( v15112(VarCurr)
    <=> ( v15113(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3167,axiom,
    ! [VarCurr] :
      ( v15113(VarCurr)
    <=> ( v15114(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3166,axiom,
    ! [VarCurr] :
      ( v15114(VarCurr)
    <=> ( v15115(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3165,axiom,
    ! [VarCurr] :
      ( v15115(VarCurr)
    <=> ( v15116(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_622,axiom,
    ! [VarCurr] :
      ( v15116(VarCurr)
    <=> ( v15117(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3164,axiom,
    ! [VarCurr] :
      ( v15117(VarCurr)
    <=> ( v15118(VarCurr)
        & v14056(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3163,axiom,
    ! [VarCurr] :
      ( v15118(VarCurr)
    <=> ( v14107(VarCurr)
        & v12810(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3162,axiom,
    ! [VarCurr] :
      ( v15071(VarCurr)
    <=> ( v15072(VarCurr)
        | v15101(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3161,axiom,
    ! [VarCurr] :
      ( v15101(VarCurr)
    <=> ( v15103(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_621,axiom,
    ! [VarCurr] :
      ( v15103(VarCurr)
    <=> ( v15104(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3160,axiom,
    ! [VarCurr] :
      ( v15104(VarCurr)
    <=> ( v15105(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3159,axiom,
    ! [VarCurr] :
      ( v15105(VarCurr)
    <=> ( v15106(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3158,axiom,
    ! [VarCurr] :
      ( v15106(VarCurr)
    <=> ( v15107(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_620,axiom,
    ! [VarCurr] :
      ( v15107(VarCurr)
    <=> ( v15108(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3157,axiom,
    ! [VarCurr] :
      ( v15108(VarCurr)
    <=> ( v15109(VarCurr)
        & v14056(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3156,axiom,
    ! [VarCurr] :
      ( v15109(VarCurr)
    <=> ( v14095(VarCurr)
        & v12810(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3155,axiom,
    ! [VarCurr] :
      ( v15072(VarCurr)
    <=> ( v15073(VarCurr)
        | v15092(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3154,axiom,
    ! [VarCurr] :
      ( v15092(VarCurr)
    <=> ( v15094(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_619,axiom,
    ! [VarCurr] :
      ( v15094(VarCurr)
    <=> ( v15095(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3153,axiom,
    ! [VarCurr] :
      ( v15095(VarCurr)
    <=> ( v15096(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3152,axiom,
    ! [VarCurr] :
      ( v15096(VarCurr)
    <=> ( v15097(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3151,axiom,
    ! [VarCurr] :
      ( v15097(VarCurr)
    <=> ( v15098(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_618,axiom,
    ! [VarCurr] :
      ( v15098(VarCurr)
    <=> ( v15099(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3150,axiom,
    ! [VarCurr] :
      ( v15099(VarCurr)
    <=> ( v15100(VarCurr)
        & v14056(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3149,axiom,
    ! [VarCurr] :
      ( v15100(VarCurr)
    <=> ( v14083(VarCurr)
        & v12810(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3148,axiom,
    ! [VarCurr] :
      ( v15073(VarCurr)
    <=> ( v15074(VarCurr)
        | v15083(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3147,axiom,
    ! [VarCurr] :
      ( v15083(VarCurr)
    <=> ( v15085(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_617,axiom,
    ! [VarCurr] :
      ( v15085(VarCurr)
    <=> ( v15086(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3146,axiom,
    ! [VarCurr] :
      ( v15086(VarCurr)
    <=> ( v15087(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3145,axiom,
    ! [VarCurr] :
      ( v15087(VarCurr)
    <=> ( v15088(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3144,axiom,
    ! [VarCurr] :
      ( v15088(VarCurr)
    <=> ( v15089(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_616,axiom,
    ! [VarCurr] :
      ( v15089(VarCurr)
    <=> ( v15090(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3143,axiom,
    ! [VarCurr] :
      ( v15090(VarCurr)
    <=> ( v15091(VarCurr)
        & v14056(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3142,axiom,
    ! [VarCurr] :
      ( v15091(VarCurr)
    <=> ( v14066(VarCurr)
        & v12810(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3141,axiom,
    ! [VarCurr] :
      ( v15074(VarCurr)
    <=> ( v15076(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_615,axiom,
    ! [VarCurr] :
      ( v15076(VarCurr)
    <=> ( v15077(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3140,axiom,
    ! [VarCurr] :
      ( v15077(VarCurr)
    <=> ( v15078(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3139,axiom,
    ! [VarCurr] :
      ( v15078(VarCurr)
    <=> ( v15079(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3138,axiom,
    ! [VarCurr] :
      ( v15079(VarCurr)
    <=> ( v15080(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_614,axiom,
    ! [VarCurr] :
      ( v15080(VarCurr)
    <=> ( v15081(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3137,axiom,
    ! [VarCurr] :
      ( v15081(VarCurr)
    <=> ( v15082(VarCurr)
        & v14056(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3136,axiom,
    ! [VarCurr] :
      ( v15082(VarCurr)
    <=> ( v14047(VarCurr)
        & v12810(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_613,axiom,
    ! [VarCurr] :
      ( v15057(VarCurr)
    <=> ( v15059(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_612,axiom,
    ! [VarCurr] :
      ( v15059(VarCurr)
    <=> ( v15060(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_611,axiom,
    ! [VarCurr] :
      ( v15060(VarCurr)
    <=> ( v15061(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3135,axiom,
    ! [VarCurr] :
      ( v15061(VarCurr)
    <=> ( v15062(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3134,axiom,
    ! [VarCurr] :
      ( v15062(VarCurr)
    <=> ( v15063(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_610,axiom,
    ! [VarCurr] :
      ( v15063(VarCurr)
    <=> ( v15064(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3133,axiom,
    ! [VarCurr] :
      ( v15064(VarCurr)
    <=> ( v15065(VarCurr)
        & v14056(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3132,axiom,
    ! [VarCurr] :
      ( v15065(VarCurr)
    <=> ( v15066(VarCurr)
        & v14055(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_609,axiom,
    ! [VarCurr] :
      ( v15066(VarCurr)
    <=> ( v15067(VarCurr)
        & v13075(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3131,axiom,
    ! [VarCurr] :
      ( v15067(VarCurr)
    <=> ( v14423(VarCurr)
        & v14036(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_608,axiom,
    ! [VarCurr] :
      ( v15054(VarCurr)
    <=> ( v15056(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_607,axiom,
    ! [VarCurr] :
      ( v15056(VarCurr)
    <=> ( v14741(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3130,axiom,
    ! [VarCurr] :
      ( v15018(VarCurr)
    <=> ( v15020(VarCurr)
        | v15052(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_606,axiom,
    ! [VarCurr] :
      ( v15052(VarCurr)
    <=> ( v14414(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3129,axiom,
    ! [VarCurr] :
      ( v15020(VarCurr)
    <=> ( v15021(VarCurr)
        | v15050(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_605,axiom,
    ! [VarCurr] :
      ( v15050(VarCurr)
    <=> ( v14410(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3128,axiom,
    ! [VarCurr] :
      ( v15021(VarCurr)
    <=> ( v15022(VarCurr)
        | v15048(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_604,axiom,
    ! [VarCurr] :
      ( v15048(VarCurr)
    <=> ( v14406(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3127,axiom,
    ! [VarCurr] :
      ( v15022(VarCurr)
    <=> ( v15023(VarCurr)
        | v15046(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_603,axiom,
    ! [VarCurr] :
      ( v15046(VarCurr)
    <=> ( v14401(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3126,axiom,
    ! [VarCurr] :
      ( v15023(VarCurr)
    <=> ( v15024(VarCurr)
        | v15044(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_602,axiom,
    ! [VarCurr] :
      ( v15044(VarCurr)
    <=> ( v14397(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3125,axiom,
    ! [VarCurr] :
      ( v15024(VarCurr)
    <=> ( v15025(VarCurr)
        | v15040(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_601,axiom,
    ! [VarCurr] :
      ( v15040(VarCurr)
    <=> ( v15042(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_600,axiom,
    ! [VarCurr] :
      ( v15042(VarCurr)
    <=> ( v15043(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_599,axiom,
    ! [VarCurr] :
      ( v15043(VarCurr)
    <=> ( v14870(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3124,axiom,
    ! [VarCurr] :
      ( v15025(VarCurr)
    <=> ( v15026(VarCurr)
        | v15037(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_598,axiom,
    ! [VarCurr] :
      ( v15037(VarCurr)
    <=> ( v15039(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_597,axiom,
    ! [VarCurr] :
      ( v15039(VarCurr)
    <=> ( v14722(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3123,axiom,
    ! [VarCurr] :
      ( v15026(VarCurr)
    <=> ( v15027(VarCurr)
        | v15035(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_596,axiom,
    ! [VarCurr] :
      ( v15035(VarCurr)
    <=> ( v14393(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3122,axiom,
    ! [VarCurr] :
      ( v15027(VarCurr)
    <=> ( v15028(VarCurr)
        | v15033(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_595,axiom,
    ! [VarCurr] :
      ( v15033(VarCurr)
    <=> ( v14389(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3121,axiom,
    ! [VarCurr] :
      ( v15028(VarCurr)
    <=> ( v15029(VarCurr)
        | v15031(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_594,axiom,
    ! [VarCurr] :
      ( v15031(VarCurr)
    <=> ( v14385(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_593,axiom,
    ! [VarCurr] :
      ( v15029(VarCurr)
    <=> ( v14381(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3120,axiom,
    ! [VarCurr] :
      ( v15000(VarCurr)
    <=> ( v15002(VarCurr)
        | v15015(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_592,axiom,
    ! [VarCurr] :
      ( v15015(VarCurr)
    <=> ( v15017(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3119,axiom,
    ! [VarCurr] :
      ( v15017(VarCurr)
    <=> ( v15011(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3118,axiom,
    ! [VarCurr] :
      ( v15002(VarCurr)
    <=> ( v15003(VarCurr)
        | v15012(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_591,axiom,
    ! [VarCurr] :
      ( v15012(VarCurr)
    <=> ( v15014(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3117,axiom,
    ! [VarCurr] :
      ( v15014(VarCurr)
    <=> ( v15007(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3116,axiom,
    ! [VarCurr] :
      ( v15003(VarCurr)
    <=> ( v15004(VarCurr)
        | v15008(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3115,axiom,
    ! [VarCurr] :
      ( v15008(VarCurr)
    <=> ( v15010(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_590,axiom,
    ! [VarCurr] :
      ( v15010(VarCurr)
    <=> ( v15011(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_589,axiom,
    ! [VarCurr] :
      ( v15011(VarCurr)
    <=> ( v14981(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3114,axiom,
    ! [VarCurr] :
      ( v15004(VarCurr)
    <=> ( v15006(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_588,axiom,
    ! [VarCurr] :
      ( v15006(VarCurr)
    <=> ( v15007(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3113,axiom,
    ! [VarCurr] :
      ( v15007(VarCurr)
    <=> ( v14981(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3112,axiom,
    ! [VarCurr] :
      ( v14984(VarCurr)
    <=> ( v14986(VarCurr)
        | v14996(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3111,axiom,
    ! [VarCurr] :
      ( v14996(VarCurr)
    <=> ( v14998(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3110,axiom,
    ! [VarCurr] :
      ( v14998(VarCurr)
    <=> ( v14999(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_587,axiom,
    ! [VarCurr] :
      ( v14999(VarCurr)
    <=> ( v14991(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3109,axiom,
    ! [VarCurr] :
      ( v14986(VarCurr)
    <=> ( v14987(VarCurr)
        | v14992(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3108,axiom,
    ! [VarCurr] :
      ( v14992(VarCurr)
    <=> ( v14994(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3107,axiom,
    ! [VarCurr] :
      ( v14994(VarCurr)
    <=> ( v14995(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_586,axiom,
    ! [VarCurr] :
      ( v14995(VarCurr)
    <=> ( v14980(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3106,axiom,
    ! [VarCurr] :
      ( v14987(VarCurr)
    <=> ( v14989(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3105,axiom,
    ! [VarCurr] :
      ( v14989(VarCurr)
    <=> ( v14990(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3104,axiom,
    ! [VarCurr] :
      ( v14990(VarCurr)
    <=> ( v14991(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3103,axiom,
    ! [VarCurr] :
      ( v14991(VarCurr)
    <=> ( v14981(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3102,axiom,
    ! [VarCurr] :
      ( v14976(VarCurr)
    <=> ( v14978(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3101,axiom,
    ! [VarCurr] :
      ( v14978(VarCurr)
    <=> ( v14979(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3100,axiom,
    ! [VarCurr] :
      ( v14979(VarCurr)
    <=> ( v14980(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3099,axiom,
    ! [VarCurr] :
      ( v14980(VarCurr)
    <=> ( v14981(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_585,axiom,
    ! [VarCurr] :
      ( v14981(VarCurr)
    <=> ( v14982(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_584,axiom,
    ! [VarCurr] :
      ( v14982(VarCurr)
    <=> ( v14983(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_583,axiom,
    ! [VarCurr] :
      ( v14983(VarCurr)
    <=> ( v14799(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3098,axiom,
    ! [VarCurr] :
      ( v14938(VarCurr)
    <=> ( v14940(VarCurr)
        | v14973(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_582,axiom,
    ! [VarCurr] :
      ( v14973(VarCurr)
    <=> ( v14975(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_581,axiom,
    ! [VarCurr] :
      ( v14975(VarCurr)
    <=> ( v14663(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3097,axiom,
    ! [VarCurr] :
      ( v14940(VarCurr)
    <=> ( v14941(VarCurr)
        | v14971(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_580,axiom,
    ! [VarCurr] :
      ( v14971(VarCurr)
    <=> ( v14302(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3096,axiom,
    ! [VarCurr] :
      ( v14941(VarCurr)
    <=> ( v14942(VarCurr)
        | v14969(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_579,axiom,
    ! [VarCurr] :
      ( v14969(VarCurr)
    <=> ( v14293(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3095,axiom,
    ! [VarCurr] :
      ( v14942(VarCurr)
    <=> ( v14943(VarCurr)
        | v14967(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_578,axiom,
    ! [VarCurr] :
      ( v14967(VarCurr)
    <=> ( v14283(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3094,axiom,
    ! [VarCurr] :
      ( v14943(VarCurr)
    <=> ( v14944(VarCurr)
        | v14965(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_577,axiom,
    ! [VarCurr] :
      ( v14965(VarCurr)
    <=> ( v14278(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3093,axiom,
    ! [VarCurr] :
      ( v14944(VarCurr)
    <=> ( v14945(VarCurr)
        | v14960(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_576,axiom,
    ! [VarCurr] :
      ( v14960(VarCurr)
    <=> ( v14962(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_575,axiom,
    ! [VarCurr] :
      ( v14962(VarCurr)
    <=> ( v14963(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_574,axiom,
    ! [VarCurr] :
      ( v14963(VarCurr)
    <=> ( v14964(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3092,axiom,
    ! [VarCurr] :
      ( v14964(VarCurr)
    <=> ( v14871(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3091,axiom,
    ! [VarCurr] :
      ( v14945(VarCurr)
    <=> ( v14946(VarCurr)
        | v14957(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_573,axiom,
    ! [VarCurr] :
      ( v14957(VarCurr)
    <=> ( v14959(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_572,axiom,
    ! [VarCurr] :
      ( v14959(VarCurr)
    <=> ( v14642(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3090,axiom,
    ! [VarCurr] :
      ( v14946(VarCurr)
    <=> ( v14947(VarCurr)
        | v14955(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_571,axiom,
    ! [VarCurr] :
      ( v14955(VarCurr)
    <=> ( v14273(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3089,axiom,
    ! [VarCurr] :
      ( v14947(VarCurr)
    <=> ( v14948(VarCurr)
        | v14953(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_570,axiom,
    ! [VarCurr] :
      ( v14953(VarCurr)
    <=> ( v14268(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3088,axiom,
    ! [VarCurr] :
      ( v14948(VarCurr)
    <=> ( v14949(VarCurr)
        | v14951(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_569,axiom,
    ! [VarCurr] :
      ( v14951(VarCurr)
    <=> ( v14263(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_568,axiom,
    ! [VarCurr] :
      ( v14949(VarCurr)
    <=> ( v14257(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3087,axiom,
    ! [VarCurr] :
      ( v14929(VarCurr)
    <=> ( v14930(VarCurr)
        | v14934(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_567,axiom,
    ! [VarCurr] :
      ( v14934(VarCurr)
    <=> ( v14936(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3086,axiom,
    ! [VarCurr] :
      ( v14936(VarCurr)
    <=> ( v14937(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_566,axiom,
    ! [VarCurr] :
      ( v14937(VarCurr)
    <=> ( v14894(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_565,axiom,
    ! [VarCurr] :
      ( v14930(VarCurr)
    <=> ( v14932(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3085,axiom,
    ! [VarCurr] :
      ( v14932(VarCurr)
    <=> ( v14933(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3084,axiom,
    ! [VarCurr] :
      ( v14933(VarCurr)
    <=> ( v14894(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3083,axiom,
    ! [VarCurr] :
      ( v14897(VarCurr)
    <=> ( v14899(VarCurr)
        | v14926(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3082,axiom,
    ! [VarCurr] :
      ( v14926(VarCurr)
    <=> ( v14928(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_564,axiom,
    ! [VarCurr] :
      ( v14928(VarCurr)
    <=> ( v14916(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3081,axiom,
    ! [VarCurr] :
      ( v14899(VarCurr)
    <=> ( v14900(VarCurr)
        | v14923(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3080,axiom,
    ! [VarCurr] :
      ( v14923(VarCurr)
    <=> ( v14925(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_563,axiom,
    ! [VarCurr] :
      ( v14925(VarCurr)
    <=> ( v14912(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3079,axiom,
    ! [VarCurr] :
      ( v14900(VarCurr)
    <=> ( v14901(VarCurr)
        | v14920(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3078,axiom,
    ! [VarCurr] :
      ( v14920(VarCurr)
    <=> ( v14922(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_562,axiom,
    ! [VarCurr] :
      ( v14922(VarCurr)
    <=> ( v14907(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3077,axiom,
    ! [VarCurr] :
      ( v14901(VarCurr)
    <=> ( v14902(VarCurr)
        | v14917(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3076,axiom,
    ! [VarCurr] :
      ( v14917(VarCurr)
    <=> ( v14919(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_561,axiom,
    ! [VarCurr] :
      ( v14919(VarCurr)
    <=> ( v14892(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3075,axiom,
    ! [VarCurr] :
      ( v14902(VarCurr)
    <=> ( v14903(VarCurr)
        | v14913(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3074,axiom,
    ! [VarCurr] :
      ( v14913(VarCurr)
    <=> ( v14915(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3073,axiom,
    ! [VarCurr] :
      ( v14915(VarCurr)
    <=> ( v14916(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_560,axiom,
    ! [VarCurr] :
      ( v14916(VarCurr)
    <=> ( v14908(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3072,axiom,
    ! [VarCurr] :
      ( v14903(VarCurr)
    <=> ( v14904(VarCurr)
        | v14909(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3071,axiom,
    ! [VarCurr] :
      ( v14909(VarCurr)
    <=> ( v14911(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3070,axiom,
    ! [VarCurr] :
      ( v14911(VarCurr)
    <=> ( v14912(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_559,axiom,
    ! [VarCurr] :
      ( v14912(VarCurr)
    <=> ( v14893(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3069,axiom,
    ! [VarCurr] :
      ( v14904(VarCurr)
    <=> ( v14906(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3068,axiom,
    ! [VarCurr] :
      ( v14906(VarCurr)
    <=> ( v14907(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3067,axiom,
    ! [VarCurr] :
      ( v14907(VarCurr)
    <=> ( v14908(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3066,axiom,
    ! [VarCurr] :
      ( v14908(VarCurr)
    <=> ( v14894(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3065,axiom,
    ! [VarCurr] :
      ( v14889(VarCurr)
    <=> ( v14891(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3064,axiom,
    ! [VarCurr] :
      ( v14891(VarCurr)
    <=> ( v14892(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3063,axiom,
    ! [VarCurr] :
      ( v14892(VarCurr)
    <=> ( v14893(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3062,axiom,
    ! [VarCurr] :
      ( v14893(VarCurr)
    <=> ( v14894(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_558,axiom,
    ! [VarCurr] :
      ( v14894(VarCurr)
    <=> ( v14895(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_557,axiom,
    ! [VarCurr] :
      ( v14895(VarCurr)
    <=> ( v14896(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3061,axiom,
    ! [VarCurr] :
      ( v14896(VarCurr)
    <=> ( v14742(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3060,axiom,
    ! [VarCurr] :
      ( v14844(VarCurr)
    <=> ( v14846(VarCurr)
        | v14886(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_556,axiom,
    ! [VarCurr] :
      ( v14886(VarCurr)
    <=> ( v14888(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_555,axiom,
    ! [VarCurr] :
      ( v14888(VarCurr)
    <=> ( v14576(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3059,axiom,
    ! [VarCurr] :
      ( v14846(VarCurr)
    <=> ( v14847(VarCurr)
        | v14884(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_554,axiom,
    ! [VarCurr] :
      ( v14884(VarCurr)
    <=> ( v14155(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3058,axiom,
    ! [VarCurr] :
      ( v14847(VarCurr)
    <=> ( v14848(VarCurr)
        | v14882(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_553,axiom,
    ! [VarCurr] :
      ( v14882(VarCurr)
    <=> ( v14135(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3057,axiom,
    ! [VarCurr] :
      ( v14848(VarCurr)
    <=> ( v14849(VarCurr)
        | v14880(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_552,axiom,
    ! [VarCurr] :
      ( v14880(VarCurr)
    <=> ( v14115(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3056,axiom,
    ! [VarCurr] :
      ( v14849(VarCurr)
    <=> ( v14850(VarCurr)
        | v14878(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_551,axiom,
    ! [VarCurr] :
      ( v14878(VarCurr)
    <=> ( v14100(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3055,axiom,
    ! [VarCurr] :
      ( v14850(VarCurr)
    <=> ( v14851(VarCurr)
        | v14866(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_550,axiom,
    ! [VarCurr] :
      ( v14866(VarCurr)
    <=> ( v14868(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_549,axiom,
    ! [VarCurr] :
      ( v14868(VarCurr)
    <=> ( v14869(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3054,axiom,
    ! [VarCurr] :
      ( v14869(VarCurr)
    <=> ( v14870(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3053,axiom,
    ! [VarCurr] :
      ( v14870(VarCurr)
    <=> ( v14871(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3052,axiom,
    ! [VarCurr] :
      ( v14871(VarCurr)
    <=> ( v14872(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_548,axiom,
    ! [VarCurr] :
      ( v14872(VarCurr)
    <=> ( v14873(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3051,axiom,
    ! [VarCurr] :
      ( v14873(VarCurr)
    <=> ( v14874(VarCurr)
        & v14056(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3050,axiom,
    ! [VarCurr] :
      ( v14874(VarCurr)
    <=> ( v14875(VarCurr)
        & v14055(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_547,axiom,
    ! [VarCurr] :
      ( v14875(VarCurr)
    <=> ( v14876(VarCurr)
        & v13075(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3049,axiom,
    ! [VarCurr] :
      ( v14876(VarCurr)
    <=> ( v14877(VarCurr)
        & v14036(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3048,axiom,
    ! [VarCurr] :
      ( v14877(VarCurr)
    <=> ( v14554(VarCurr)
        & v14035(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3047,axiom,
    ! [VarCurr] :
      ( v14851(VarCurr)
    <=> ( v14852(VarCurr)
        | v14863(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_546,axiom,
    ! [VarCurr] :
      ( v14863(VarCurr)
    <=> ( v14865(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_545,axiom,
    ! [VarCurr] :
      ( v14865(VarCurr)
    <=> ( v14545(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3046,axiom,
    ! [VarCurr] :
      ( v14852(VarCurr)
    <=> ( v14853(VarCurr)
        | v14861(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_544,axiom,
    ! [VarCurr] :
      ( v14861(VarCurr)
    <=> ( v14088(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3045,axiom,
    ! [VarCurr] :
      ( v14853(VarCurr)
    <=> ( v14854(VarCurr)
        | v14859(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_543,axiom,
    ! [VarCurr] :
      ( v14859(VarCurr)
    <=> ( v14076(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3044,axiom,
    ! [VarCurr] :
      ( v14854(VarCurr)
    <=> ( v14855(VarCurr)
        | v14857(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_542,axiom,
    ! [VarCurr] :
      ( v14857(VarCurr)
    <=> ( v14059(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_541,axiom,
    ! [VarCurr] :
      ( v14855(VarCurr)
    <=> ( v14040(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3043,axiom,
    ! [VarCurr] :
      ( v14800(VarCurr)
    <=> ( v14802(VarCurr)
        | v14842(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_540,axiom,
    ! [VarCurr] :
      ( v14842(VarCurr)
    <=> ( v14822(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3042,axiom,
    ! [VarCurr] :
      ( v14802(VarCurr)
    <=> ( v14803(VarCurr)
        | v14840(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_539,axiom,
    ! [VarCurr] :
      ( v14840(VarCurr)
    <=> ( v14818(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3041,axiom,
    ! [VarCurr] :
      ( v14803(VarCurr)
    <=> ( v14804(VarCurr)
        | v14838(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_538,axiom,
    ! [VarCurr] :
      ( v14838(VarCurr)
    <=> ( v14813(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3040,axiom,
    ! [VarCurr] :
      ( v14804(VarCurr)
    <=> ( v14805(VarCurr)
        | v14836(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_537,axiom,
    ! [VarCurr] :
      ( v14836(VarCurr)
    <=> ( v14793(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3039,axiom,
    ! [VarCurr] :
      ( v14805(VarCurr)
    <=> ( v14806(VarCurr)
        | v14833(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3038,axiom,
    ! [VarCurr] :
      ( v14833(VarCurr)
    <=> ( v14835(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_536,axiom,
    ! [VarCurr] :
      ( v14835(VarCurr)
    <=> ( v14823(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3037,axiom,
    ! [VarCurr] :
      ( v14806(VarCurr)
    <=> ( v14807(VarCurr)
        | v14830(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3036,axiom,
    ! [VarCurr] :
      ( v14830(VarCurr)
    <=> ( v14832(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_535,axiom,
    ! [VarCurr] :
      ( v14832(VarCurr)
    <=> ( v14819(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3035,axiom,
    ! [VarCurr] :
      ( v14807(VarCurr)
    <=> ( v14808(VarCurr)
        | v14827(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3034,axiom,
    ! [VarCurr] :
      ( v14827(VarCurr)
    <=> ( v14829(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_534,axiom,
    ! [VarCurr] :
      ( v14829(VarCurr)
    <=> ( v14814(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3033,axiom,
    ! [VarCurr] :
      ( v14808(VarCurr)
    <=> ( v14809(VarCurr)
        | v14824(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3032,axiom,
    ! [VarCurr] :
      ( v14824(VarCurr)
    <=> ( v14826(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_533,axiom,
    ! [VarCurr] :
      ( v14826(VarCurr)
    <=> ( v14794(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3031,axiom,
    ! [VarCurr] :
      ( v14809(VarCurr)
    <=> ( v14810(VarCurr)
        | v14820(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3030,axiom,
    ! [VarCurr] :
      ( v14820(VarCurr)
    <=> ( v14822(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3029,axiom,
    ! [VarCurr] :
      ( v14822(VarCurr)
    <=> ( v14823(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_532,axiom,
    ! [VarCurr] :
      ( v14823(VarCurr)
    <=> ( v14815(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3028,axiom,
    ! [VarCurr] :
      ( v14810(VarCurr)
    <=> ( v14811(VarCurr)
        | v14816(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3027,axiom,
    ! [VarCurr] :
      ( v14816(VarCurr)
    <=> ( v14818(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3026,axiom,
    ! [VarCurr] :
      ( v14818(VarCurr)
    <=> ( v14819(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_531,axiom,
    ! [VarCurr] :
      ( v14819(VarCurr)
    <=> ( v14795(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3025,axiom,
    ! [VarCurr] :
      ( v14811(VarCurr)
    <=> ( v14813(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3024,axiom,
    ! [VarCurr] :
      ( v14813(VarCurr)
    <=> ( v14814(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3023,axiom,
    ! [VarCurr] :
      ( v14814(VarCurr)
    <=> ( v14815(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3022,axiom,
    ! [VarCurr] :
      ( v14815(VarCurr)
    <=> ( v14796(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3021,axiom,
    ! [VarCurr] :
      ( v14791(VarCurr)
    <=> ( v14793(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3020,axiom,
    ! [VarCurr] :
      ( v14793(VarCurr)
    <=> ( v14794(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3019,axiom,
    ! [VarCurr] :
      ( v14794(VarCurr)
    <=> ( v14795(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3018,axiom,
    ! [VarCurr] :
      ( v14795(VarCurr)
    <=> ( v14796(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_530,axiom,
    ! [VarCurr] :
      ( v14796(VarCurr)
    <=> ( v14797(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_529,axiom,
    ! [VarCurr] :
      ( v14797(VarCurr)
    <=> ( v14798(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3017,axiom,
    ! [VarCurr] :
      ( v14798(VarCurr)
    <=> ( v14799(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3016,axiom,
    ! [VarCurr] :
      ( v14799(VarCurr)
    <=> ( v14743(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3015,axiom,
    ! [VarCurr] :
      ( v14750(VarCurr)
    <=> ( v14752(VarCurr)
        | v14788(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_528,axiom,
    ! [VarCurr] :
      ( v14788(VarCurr)
    <=> ( v14790(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_527,axiom,
    ! [VarCurr] :
      ( v14790(VarCurr)
    <=> ( v14475(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3014,axiom,
    ! [VarCurr] :
      ( v14752(VarCurr)
    <=> ( v14753(VarCurr)
        | v14785(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_526,axiom,
    ! [VarCurr] :
      ( v14785(VarCurr)
    <=> ( v14787(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_525,axiom,
    ! [VarCurr] :
      ( v14787(VarCurr)
    <=> ( v14467(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3013,axiom,
    ! [VarCurr] :
      ( v14753(VarCurr)
    <=> ( v14754(VarCurr)
        | v14782(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_524,axiom,
    ! [VarCurr] :
      ( v14782(VarCurr)
    <=> ( v14784(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_523,axiom,
    ! [VarCurr] :
      ( v14784(VarCurr)
    <=> ( v14463(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3012,axiom,
    ! [VarCurr] :
      ( v14754(VarCurr)
    <=> ( v14755(VarCurr)
        | v14779(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_522,axiom,
    ! [VarCurr] :
      ( v14779(VarCurr)
    <=> ( v14781(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_521,axiom,
    ! [VarCurr] :
      ( v14781(VarCurr)
    <=> ( v14459(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3011,axiom,
    ! [VarCurr] :
      ( v14755(VarCurr)
    <=> ( v14756(VarCurr)
        | v14776(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_520,axiom,
    ! [VarCurr] :
      ( v14776(VarCurr)
    <=> ( v14778(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_519,axiom,
    ! [VarCurr] :
      ( v14778(VarCurr)
    <=> ( v14455(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3010,axiom,
    ! [VarCurr] :
      ( v14756(VarCurr)
    <=> ( v14757(VarCurr)
        | v14772(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_518,axiom,
    ! [VarCurr] :
      ( v14772(VarCurr)
    <=> ( v14774(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_517,axiom,
    ! [VarCurr] :
      ( v14774(VarCurr)
    <=> ( v14775(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3009,axiom,
    ! [VarCurr] :
      ( v14775(VarCurr)
    <=> ( v14643(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3008,axiom,
    ! [VarCurr] :
      ( v14757(VarCurr)
    <=> ( v14758(VarCurr)
        | v14769(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_516,axiom,
    ! [VarCurr] :
      ( v14769(VarCurr)
    <=> ( v14771(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_515,axiom,
    ! [VarCurr] :
      ( v14771(VarCurr)
    <=> ( v14451(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3007,axiom,
    ! [VarCurr] :
      ( v14758(VarCurr)
    <=> ( v14759(VarCurr)
        | v14766(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_514,axiom,
    ! [VarCurr] :
      ( v14766(VarCurr)
    <=> ( v14768(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_513,axiom,
    ! [VarCurr] :
      ( v14768(VarCurr)
    <=> ( v14447(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3006,axiom,
    ! [VarCurr] :
      ( v14759(VarCurr)
    <=> ( v14760(VarCurr)
        | v14763(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_512,axiom,
    ! [VarCurr] :
      ( v14763(VarCurr)
    <=> ( v14765(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_511,axiom,
    ! [VarCurr] :
      ( v14765(VarCurr)
    <=> ( v14443(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_510,axiom,
    ! [VarCurr] :
      ( v14760(VarCurr)
    <=> ( v14762(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_509,axiom,
    ! [VarCurr] :
      ( v14762(VarCurr)
    <=> ( v14438(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_508,axiom,
    ! [VarCurr] :
      ( v14738(VarCurr)
    <=> ( v14740(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3005,axiom,
    ! [VarCurr] :
      ( v14740(VarCurr)
    <=> ( v14741(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_507,axiom,
    ! [VarCurr] :
      ( v14741(VarCurr)
    <=> ( v14742(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3004,axiom,
    ! [VarCurr] :
      ( v14742(VarCurr)
    <=> ( v14743(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3003,axiom,
    ! [VarCurr] :
      ( v14743(VarCurr)
    <=> ( v14744(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_506,axiom,
    ! [VarCurr] :
      ( v14744(VarCurr)
    <=> ( v14745(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3002,axiom,
    ! [VarCurr] :
      ( v14745(VarCurr)
    <=> ( v14746(VarCurr)
        & v14056(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3001,axiom,
    ! [VarCurr] :
      ( v14746(VarCurr)
    <=> ( v14747(VarCurr)
        & v14055(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_505,axiom,
    ! [VarCurr] :
      ( v14747(VarCurr)
    <=> ( v14748(VarCurr)
        & v13075(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3000,axiom,
    ! [VarCurr] :
      ( v14748(VarCurr)
    <=> ( v14749(VarCurr)
        & v14036(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2999,axiom,
    ! [VarCurr] :
      ( v14749(VarCurr)
    <=> ( v14424(VarCurr)
        & v14035(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_504,axiom,
    ! [VarCurr] :
      ( v14735(VarCurr)
    <=> ( v14737(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2998,axiom,
    ! [VarCurr] :
      ( v14737(VarCurr)
    <=> ( v14415(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2997,axiom,
    ! [VarCurr] :
      ( v14698(VarCurr)
    <=> ( v14700(VarCurr)
        | v14732(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_503,axiom,
    ! [VarCurr] :
      ( v14732(VarCurr)
    <=> ( v14734(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2996,axiom,
    ! [VarCurr] :
      ( v14734(VarCurr)
    <=> ( v14411(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2995,axiom,
    ! [VarCurr] :
      ( v14700(VarCurr)
    <=> ( v14701(VarCurr)
        | v14729(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_502,axiom,
    ! [VarCurr] :
      ( v14729(VarCurr)
    <=> ( v14731(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2994,axiom,
    ! [VarCurr] :
      ( v14731(VarCurr)
    <=> ( v14407(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2993,axiom,
    ! [VarCurr] :
      ( v14701(VarCurr)
    <=> ( v14702(VarCurr)
        | v14726(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_501,axiom,
    ! [VarCurr] :
      ( v14726(VarCurr)
    <=> ( v14728(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2992,axiom,
    ! [VarCurr] :
      ( v14728(VarCurr)
    <=> ( v14402(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2991,axiom,
    ! [VarCurr] :
      ( v14702(VarCurr)
    <=> ( v14703(VarCurr)
        | v14723(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_500,axiom,
    ! [VarCurr] :
      ( v14723(VarCurr)
    <=> ( v14725(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2990,axiom,
    ! [VarCurr] :
      ( v14725(VarCurr)
    <=> ( v14398(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2989,axiom,
    ! [VarCurr] :
      ( v14703(VarCurr)
    <=> ( v14704(VarCurr)
        | v14719(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_499,axiom,
    ! [VarCurr] :
      ( v14719(VarCurr)
    <=> ( v14721(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2988,axiom,
    ! [VarCurr] :
      ( v14721(VarCurr)
    <=> ( v14722(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_498,axiom,
    ! [VarCurr] :
      ( v14722(VarCurr)
    <=> ( v14546(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2987,axiom,
    ! [VarCurr] :
      ( v14704(VarCurr)
    <=> ( v14705(VarCurr)
        | v14716(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_497,axiom,
    ! [VarCurr] :
      ( v14716(VarCurr)
    <=> ( v14718(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2986,axiom,
    ! [VarCurr] :
      ( v14718(VarCurr)
    <=> ( v14394(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2985,axiom,
    ! [VarCurr] :
      ( v14705(VarCurr)
    <=> ( v14706(VarCurr)
        | v14713(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_496,axiom,
    ! [VarCurr] :
      ( v14713(VarCurr)
    <=> ( v14715(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2984,axiom,
    ! [VarCurr] :
      ( v14715(VarCurr)
    <=> ( v14390(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2983,axiom,
    ! [VarCurr] :
      ( v14706(VarCurr)
    <=> ( v14707(VarCurr)
        | v14710(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_495,axiom,
    ! [VarCurr] :
      ( v14710(VarCurr)
    <=> ( v14712(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2982,axiom,
    ! [VarCurr] :
      ( v14712(VarCurr)
    <=> ( v14386(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_494,axiom,
    ! [VarCurr] :
      ( v14707(VarCurr)
    <=> ( v14709(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2981,axiom,
    ! [VarCurr] :
      ( v14709(VarCurr)
    <=> ( v14382(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2980,axiom,
    ! [VarCurr] :
      ( v14680(VarCurr)
    <=> ( v14682(VarCurr)
        | v14695(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_493,axiom,
    ! [VarCurr] :
      ( v14695(VarCurr)
    <=> ( v14697(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2979,axiom,
    ! [VarCurr] :
      ( v14697(VarCurr)
    <=> ( v14691(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2978,axiom,
    ! [VarCurr] :
      ( v14682(VarCurr)
    <=> ( v14683(VarCurr)
        | v14692(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_492,axiom,
    ! [VarCurr] :
      ( v14692(VarCurr)
    <=> ( v14694(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2977,axiom,
    ! [VarCurr] :
      ( v14694(VarCurr)
    <=> ( v14687(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2976,axiom,
    ! [VarCurr] :
      ( v14683(VarCurr)
    <=> ( v14684(VarCurr)
        | v14688(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2975,axiom,
    ! [VarCurr] :
      ( v14688(VarCurr)
    <=> ( v14690(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_491,axiom,
    ! [VarCurr] :
      ( v14690(VarCurr)
    <=> ( v14691(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_490,axiom,
    ! [VarCurr] :
      ( v14691(VarCurr)
    <=> ( v14661(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2974,axiom,
    ! [VarCurr] :
      ( v14684(VarCurr)
    <=> ( v14686(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_489,axiom,
    ! [VarCurr] :
      ( v14686(VarCurr)
    <=> ( v14687(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2973,axiom,
    ! [VarCurr] :
      ( v14687(VarCurr)
    <=> ( v14661(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2972,axiom,
    ! [VarCurr] :
      ( v14664(VarCurr)
    <=> ( v14666(VarCurr)
        | v14676(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2971,axiom,
    ! [VarCurr] :
      ( v14676(VarCurr)
    <=> ( v14678(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2970,axiom,
    ! [VarCurr] :
      ( v14678(VarCurr)
    <=> ( v14679(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_488,axiom,
    ! [VarCurr] :
      ( v14679(VarCurr)
    <=> ( v14671(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2969,axiom,
    ! [VarCurr] :
      ( v14666(VarCurr)
    <=> ( v14667(VarCurr)
        | v14672(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2968,axiom,
    ! [VarCurr] :
      ( v14672(VarCurr)
    <=> ( v14674(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2967,axiom,
    ! [VarCurr] :
      ( v14674(VarCurr)
    <=> ( v14675(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_487,axiom,
    ! [VarCurr] :
      ( v14675(VarCurr)
    <=> ( v14660(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2966,axiom,
    ! [VarCurr] :
      ( v14667(VarCurr)
    <=> ( v14669(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2965,axiom,
    ! [VarCurr] :
      ( v14669(VarCurr)
    <=> ( v14670(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2964,axiom,
    ! [VarCurr] :
      ( v14670(VarCurr)
    <=> ( v14671(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2963,axiom,
    ! [VarCurr] :
      ( v14671(VarCurr)
    <=> ( v14661(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2962,axiom,
    ! [VarCurr] :
      ( v14656(VarCurr)
    <=> ( v14658(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2961,axiom,
    ! [VarCurr] :
      ( v14658(VarCurr)
    <=> ( v14659(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2960,axiom,
    ! [VarCurr] :
      ( v14659(VarCurr)
    <=> ( v14660(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2959,axiom,
    ! [VarCurr] :
      ( v14660(VarCurr)
    <=> ( v14661(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_486,axiom,
    ! [VarCurr] :
      ( v14661(VarCurr)
    <=> ( v14662(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2958,axiom,
    ! [VarCurr] :
      ( v14662(VarCurr)
    <=> ( v14663(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_485,axiom,
    ! [VarCurr] :
      ( v14663(VarCurr)
    <=> ( v14476(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2957,axiom,
    ! [VarCurr] :
      ( v14618(VarCurr)
    <=> ( v14620(VarCurr)
        | v14653(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_484,axiom,
    ! [VarCurr] :
      ( v14653(VarCurr)
    <=> ( v14655(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2956,axiom,
    ! [VarCurr] :
      ( v14655(VarCurr)
    <=> ( v14303(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2955,axiom,
    ! [VarCurr] :
      ( v14620(VarCurr)
    <=> ( v14621(VarCurr)
        | v14650(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_483,axiom,
    ! [VarCurr] :
      ( v14650(VarCurr)
    <=> ( v14652(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2954,axiom,
    ! [VarCurr] :
      ( v14652(VarCurr)
    <=> ( v14294(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2953,axiom,
    ! [VarCurr] :
      ( v14621(VarCurr)
    <=> ( v14622(VarCurr)
        | v14647(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_482,axiom,
    ! [VarCurr] :
      ( v14647(VarCurr)
    <=> ( v14649(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2952,axiom,
    ! [VarCurr] :
      ( v14649(VarCurr)
    <=> ( v14284(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2951,axiom,
    ! [VarCurr] :
      ( v14622(VarCurr)
    <=> ( v14623(VarCurr)
        | v14644(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_481,axiom,
    ! [VarCurr] :
      ( v14644(VarCurr)
    <=> ( v14646(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2950,axiom,
    ! [VarCurr] :
      ( v14646(VarCurr)
    <=> ( v14279(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2949,axiom,
    ! [VarCurr] :
      ( v14623(VarCurr)
    <=> ( v14624(VarCurr)
        | v14639(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_480,axiom,
    ! [VarCurr] :
      ( v14639(VarCurr)
    <=> ( v14641(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2948,axiom,
    ! [VarCurr] :
      ( v14641(VarCurr)
    <=> ( v14642(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_479,axiom,
    ! [VarCurr] :
      ( v14642(VarCurr)
    <=> ( v14643(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2947,axiom,
    ! [VarCurr] :
      ( v14643(VarCurr)
    <=> ( v14547(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2946,axiom,
    ! [VarCurr] :
      ( v14624(VarCurr)
    <=> ( v14625(VarCurr)
        | v14636(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_478,axiom,
    ! [VarCurr] :
      ( v14636(VarCurr)
    <=> ( v14638(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2945,axiom,
    ! [VarCurr] :
      ( v14638(VarCurr)
    <=> ( v14274(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2944,axiom,
    ! [VarCurr] :
      ( v14625(VarCurr)
    <=> ( v14626(VarCurr)
        | v14633(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_477,axiom,
    ! [VarCurr] :
      ( v14633(VarCurr)
    <=> ( v14635(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2943,axiom,
    ! [VarCurr] :
      ( v14635(VarCurr)
    <=> ( v14269(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2942,axiom,
    ! [VarCurr] :
      ( v14626(VarCurr)
    <=> ( v14627(VarCurr)
        | v14630(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_476,axiom,
    ! [VarCurr] :
      ( v14630(VarCurr)
    <=> ( v14632(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2941,axiom,
    ! [VarCurr] :
      ( v14632(VarCurr)
    <=> ( v14264(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_475,axiom,
    ! [VarCurr] :
      ( v14627(VarCurr)
    <=> ( v14629(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2940,axiom,
    ! [VarCurr] :
      ( v14629(VarCurr)
    <=> ( v14258(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2939,axiom,
    ! [VarCurr] :
      ( v14609(VarCurr)
    <=> ( v14610(VarCurr)
        | v14614(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_474,axiom,
    ! [VarCurr] :
      ( v14614(VarCurr)
    <=> ( v14616(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2938,axiom,
    ! [VarCurr] :
      ( v14616(VarCurr)
    <=> ( v14617(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_473,axiom,
    ! [VarCurr] :
      ( v14617(VarCurr)
    <=> ( v14574(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_472,axiom,
    ! [VarCurr] :
      ( v14610(VarCurr)
    <=> ( v14612(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2937,axiom,
    ! [VarCurr] :
      ( v14612(VarCurr)
    <=> ( v14613(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2936,axiom,
    ! [VarCurr] :
      ( v14613(VarCurr)
    <=> ( v14574(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2935,axiom,
    ! [VarCurr] :
      ( v14577(VarCurr)
    <=> ( v14579(VarCurr)
        | v14606(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2934,axiom,
    ! [VarCurr] :
      ( v14606(VarCurr)
    <=> ( v14608(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_471,axiom,
    ! [VarCurr] :
      ( v14608(VarCurr)
    <=> ( v14596(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2933,axiom,
    ! [VarCurr] :
      ( v14579(VarCurr)
    <=> ( v14580(VarCurr)
        | v14603(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2932,axiom,
    ! [VarCurr] :
      ( v14603(VarCurr)
    <=> ( v14605(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_470,axiom,
    ! [VarCurr] :
      ( v14605(VarCurr)
    <=> ( v14592(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2931,axiom,
    ! [VarCurr] :
      ( v14580(VarCurr)
    <=> ( v14581(VarCurr)
        | v14600(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2930,axiom,
    ! [VarCurr] :
      ( v14600(VarCurr)
    <=> ( v14602(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_469,axiom,
    ! [VarCurr] :
      ( v14602(VarCurr)
    <=> ( v14587(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2929,axiom,
    ! [VarCurr] :
      ( v14581(VarCurr)
    <=> ( v14582(VarCurr)
        | v14597(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2928,axiom,
    ! [VarCurr] :
      ( v14597(VarCurr)
    <=> ( v14599(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_468,axiom,
    ! [VarCurr] :
      ( v14599(VarCurr)
    <=> ( v14572(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2927,axiom,
    ! [VarCurr] :
      ( v14582(VarCurr)
    <=> ( v14583(VarCurr)
        | v14593(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2926,axiom,
    ! [VarCurr] :
      ( v14593(VarCurr)
    <=> ( v14595(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2925,axiom,
    ! [VarCurr] :
      ( v14595(VarCurr)
    <=> ( v14596(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_467,axiom,
    ! [VarCurr] :
      ( v14596(VarCurr)
    <=> ( v14588(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2924,axiom,
    ! [VarCurr] :
      ( v14583(VarCurr)
    <=> ( v14584(VarCurr)
        | v14589(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2923,axiom,
    ! [VarCurr] :
      ( v14589(VarCurr)
    <=> ( v14591(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2922,axiom,
    ! [VarCurr] :
      ( v14591(VarCurr)
    <=> ( v14592(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_466,axiom,
    ! [VarCurr] :
      ( v14592(VarCurr)
    <=> ( v14573(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2921,axiom,
    ! [VarCurr] :
      ( v14584(VarCurr)
    <=> ( v14586(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2920,axiom,
    ! [VarCurr] :
      ( v14586(VarCurr)
    <=> ( v14587(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2919,axiom,
    ! [VarCurr] :
      ( v14587(VarCurr)
    <=> ( v14588(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2918,axiom,
    ! [VarCurr] :
      ( v14588(VarCurr)
    <=> ( v14574(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2917,axiom,
    ! [VarCurr] :
      ( v14569(VarCurr)
    <=> ( v14571(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2916,axiom,
    ! [VarCurr] :
      ( v14571(VarCurr)
    <=> ( v14572(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2915,axiom,
    ! [VarCurr] :
      ( v14572(VarCurr)
    <=> ( v14573(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2914,axiom,
    ! [VarCurr] :
      ( v14573(VarCurr)
    <=> ( v14574(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_465,axiom,
    ! [VarCurr] :
      ( v14574(VarCurr)
    <=> ( v14575(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2913,axiom,
    ! [VarCurr] :
      ( v14575(VarCurr)
    <=> ( v14576(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2912,axiom,
    ! [VarCurr] :
      ( v14576(VarCurr)
    <=> ( v14416(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2911,axiom,
    ! [VarCurr] :
      ( v14521(VarCurr)
    <=> ( v14523(VarCurr)
        | v14566(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_464,axiom,
    ! [VarCurr] :
      ( v14566(VarCurr)
    <=> ( v14568(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2910,axiom,
    ! [VarCurr] :
      ( v14568(VarCurr)
    <=> ( v14156(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2909,axiom,
    ! [VarCurr] :
      ( v14523(VarCurr)
    <=> ( v14524(VarCurr)
        | v14563(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_463,axiom,
    ! [VarCurr] :
      ( v14563(VarCurr)
    <=> ( v14565(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2908,axiom,
    ! [VarCurr] :
      ( v14565(VarCurr)
    <=> ( v14136(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2907,axiom,
    ! [VarCurr] :
      ( v14524(VarCurr)
    <=> ( v14525(VarCurr)
        | v14560(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_462,axiom,
    ! [VarCurr] :
      ( v14560(VarCurr)
    <=> ( v14562(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2906,axiom,
    ! [VarCurr] :
      ( v14562(VarCurr)
    <=> ( v14116(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2905,axiom,
    ! [VarCurr] :
      ( v14525(VarCurr)
    <=> ( v14526(VarCurr)
        | v14557(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_461,axiom,
    ! [VarCurr] :
      ( v14557(VarCurr)
    <=> ( v14559(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2904,axiom,
    ! [VarCurr] :
      ( v14559(VarCurr)
    <=> ( v14101(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2903,axiom,
    ! [VarCurr] :
      ( v14526(VarCurr)
    <=> ( v14527(VarCurr)
        | v14542(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_460,axiom,
    ! [VarCurr] :
      ( v14542(VarCurr)
    <=> ( v14544(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2902,axiom,
    ! [VarCurr] :
      ( v14544(VarCurr)
    <=> ( v14545(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2901,axiom,
    ! [VarCurr] :
      ( v14545(VarCurr)
    <=> ( v14546(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2900,axiom,
    ! [VarCurr] :
      ( v14546(VarCurr)
    <=> ( v14547(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2899,axiom,
    ! [VarCurr] :
      ( v14547(VarCurr)
    <=> ( v14548(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_459,axiom,
    ! [VarCurr] :
      ( v14548(VarCurr)
    <=> ( v14549(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2898,axiom,
    ! [VarCurr] :
      ( v14549(VarCurr)
    <=> ( v14550(VarCurr)
        & v14056(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2897,axiom,
    ! [VarCurr] :
      ( v14550(VarCurr)
    <=> ( v14551(VarCurr)
        & v14055(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2896,axiom,
    ! [VarCurr] :
      ( v14551(VarCurr)
    <=> ( v14552(VarCurr)
        & v14037(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_458,axiom,
    ! [VarCurr] :
      ( v14552(VarCurr)
    <=> ( v14553(VarCurr)
        & v13075(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2895,axiom,
    ! [VarCurr] :
      ( v14553(VarCurr)
    <=> ( v14554(VarCurr)
        & v13075(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2894,axiom,
    ! [VarCurr] :
      ( v14554(VarCurr)
    <=> ( v14555(VarCurr)
        & v14018(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2893,axiom,
    ! [VarCurr] :
      ( v14555(VarCurr)
    <=> ( v14556(VarCurr)
        & v12847(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2892,axiom,
    ! [VarCurr] :
      ( v14556(VarCurr)
    <=> ( v14017(VarCurr)
        & v14054(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2891,axiom,
    ! [VarCurr] :
      ( v14527(VarCurr)
    <=> ( v14528(VarCurr)
        | v14539(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_457,axiom,
    ! [VarCurr] :
      ( v14539(VarCurr)
    <=> ( v14541(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2890,axiom,
    ! [VarCurr] :
      ( v14541(VarCurr)
    <=> ( v14089(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2889,axiom,
    ! [VarCurr] :
      ( v14528(VarCurr)
    <=> ( v14529(VarCurr)
        | v14536(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_456,axiom,
    ! [VarCurr] :
      ( v14536(VarCurr)
    <=> ( v14538(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2888,axiom,
    ! [VarCurr] :
      ( v14538(VarCurr)
    <=> ( v14077(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2887,axiom,
    ! [VarCurr] :
      ( v14529(VarCurr)
    <=> ( v14530(VarCurr)
        | v14533(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_455,axiom,
    ! [VarCurr] :
      ( v14533(VarCurr)
    <=> ( v14535(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2886,axiom,
    ! [VarCurr] :
      ( v14535(VarCurr)
    <=> ( v14060(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_454,axiom,
    ! [VarCurr] :
      ( v14530(VarCurr)
    <=> ( v14532(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2885,axiom,
    ! [VarCurr] :
      ( v14532(VarCurr)
    <=> ( v14041(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2884,axiom,
    ! [VarCurr] :
      ( v14477(VarCurr)
    <=> ( v14479(VarCurr)
        | v14519(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_453,axiom,
    ! [VarCurr] :
      ( v14519(VarCurr)
    <=> ( v14499(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2883,axiom,
    ! [VarCurr] :
      ( v14479(VarCurr)
    <=> ( v14480(VarCurr)
        | v14517(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_452,axiom,
    ! [VarCurr] :
      ( v14517(VarCurr)
    <=> ( v14495(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2882,axiom,
    ! [VarCurr] :
      ( v14480(VarCurr)
    <=> ( v14481(VarCurr)
        | v14515(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_451,axiom,
    ! [VarCurr] :
      ( v14515(VarCurr)
    <=> ( v14490(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2881,axiom,
    ! [VarCurr] :
      ( v14481(VarCurr)
    <=> ( v14482(VarCurr)
        | v14513(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_450,axiom,
    ! [VarCurr] :
      ( v14513(VarCurr)
    <=> ( v14470(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2880,axiom,
    ! [VarCurr] :
      ( v14482(VarCurr)
    <=> ( v14483(VarCurr)
        | v14510(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2879,axiom,
    ! [VarCurr] :
      ( v14510(VarCurr)
    <=> ( v14512(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_449,axiom,
    ! [VarCurr] :
      ( v14512(VarCurr)
    <=> ( v14500(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2878,axiom,
    ! [VarCurr] :
      ( v14483(VarCurr)
    <=> ( v14484(VarCurr)
        | v14507(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2877,axiom,
    ! [VarCurr] :
      ( v14507(VarCurr)
    <=> ( v14509(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_448,axiom,
    ! [VarCurr] :
      ( v14509(VarCurr)
    <=> ( v14496(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2876,axiom,
    ! [VarCurr] :
      ( v14484(VarCurr)
    <=> ( v14485(VarCurr)
        | v14504(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2875,axiom,
    ! [VarCurr] :
      ( v14504(VarCurr)
    <=> ( v14506(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_447,axiom,
    ! [VarCurr] :
      ( v14506(VarCurr)
    <=> ( v14491(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2874,axiom,
    ! [VarCurr] :
      ( v14485(VarCurr)
    <=> ( v14486(VarCurr)
        | v14501(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2873,axiom,
    ! [VarCurr] :
      ( v14501(VarCurr)
    <=> ( v14503(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_446,axiom,
    ! [VarCurr] :
      ( v14503(VarCurr)
    <=> ( v14471(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2872,axiom,
    ! [VarCurr] :
      ( v14486(VarCurr)
    <=> ( v14487(VarCurr)
        | v14497(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2871,axiom,
    ! [VarCurr] :
      ( v14497(VarCurr)
    <=> ( v14499(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2870,axiom,
    ! [VarCurr] :
      ( v14499(VarCurr)
    <=> ( v14500(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_445,axiom,
    ! [VarCurr] :
      ( v14500(VarCurr)
    <=> ( v14492(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2869,axiom,
    ! [VarCurr] :
      ( v14487(VarCurr)
    <=> ( v14488(VarCurr)
        | v14493(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2868,axiom,
    ! [VarCurr] :
      ( v14493(VarCurr)
    <=> ( v14495(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2867,axiom,
    ! [VarCurr] :
      ( v14495(VarCurr)
    <=> ( v14496(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_444,axiom,
    ! [VarCurr] :
      ( v14496(VarCurr)
    <=> ( v14472(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2866,axiom,
    ! [VarCurr] :
      ( v14488(VarCurr)
    <=> ( v14490(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2865,axiom,
    ! [VarCurr] :
      ( v14490(VarCurr)
    <=> ( v14491(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2864,axiom,
    ! [VarCurr] :
      ( v14491(VarCurr)
    <=> ( v14492(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2863,axiom,
    ! [VarCurr] :
      ( v14492(VarCurr)
    <=> ( v14473(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2862,axiom,
    ! [VarCurr] :
      ( v14468(VarCurr)
    <=> ( v14470(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2861,axiom,
    ! [VarCurr] :
      ( v14470(VarCurr)
    <=> ( v14471(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2860,axiom,
    ! [VarCurr] :
      ( v14471(VarCurr)
    <=> ( v14472(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2859,axiom,
    ! [VarCurr] :
      ( v14472(VarCurr)
    <=> ( v14473(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_443,axiom,
    ! [VarCurr] :
      ( v14473(VarCurr)
    <=> ( v14474(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2858,axiom,
    ! [VarCurr] :
      ( v14474(VarCurr)
    <=> ( v14475(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2857,axiom,
    ! [VarCurr] :
      ( v14475(VarCurr)
    <=> ( v14476(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2856,axiom,
    ! [VarCurr] :
      ( v14476(VarCurr)
    <=> ( v14417(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2855,axiom,
    ! [VarCurr] :
      ( v14427(VarCurr)
    <=> ( v14429(VarCurr)
        | v14464(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_442,axiom,
    ! [VarCurr] :
      ( v14464(VarCurr)
    <=> ( v14466(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2854,axiom,
    ! [VarCurr] :
      ( v14466(VarCurr)
    <=> ( v14467(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2853,axiom,
    ! [VarCurr] :
      ( v14467(VarCurr)
    <=> ( v14304(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2852,axiom,
    ! [VarCurr] :
      ( v14429(VarCurr)
    <=> ( v14430(VarCurr)
        | v14460(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_441,axiom,
    ! [VarCurr] :
      ( v14460(VarCurr)
    <=> ( v14462(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2851,axiom,
    ! [VarCurr] :
      ( v14462(VarCurr)
    <=> ( v14463(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2850,axiom,
    ! [VarCurr] :
      ( v14463(VarCurr)
    <=> ( v14295(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2849,axiom,
    ! [VarCurr] :
      ( v14430(VarCurr)
    <=> ( v14431(VarCurr)
        | v14456(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_440,axiom,
    ! [VarCurr] :
      ( v14456(VarCurr)
    <=> ( v14458(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2848,axiom,
    ! [VarCurr] :
      ( v14458(VarCurr)
    <=> ( v14459(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2847,axiom,
    ! [VarCurr] :
      ( v14459(VarCurr)
    <=> ( v14285(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2846,axiom,
    ! [VarCurr] :
      ( v14431(VarCurr)
    <=> ( v14432(VarCurr)
        | v14452(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_439,axiom,
    ! [VarCurr] :
      ( v14452(VarCurr)
    <=> ( v14454(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2845,axiom,
    ! [VarCurr] :
      ( v14454(VarCurr)
    <=> ( v14455(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2844,axiom,
    ! [VarCurr] :
      ( v14455(VarCurr)
    <=> ( v14280(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2843,axiom,
    ! [VarCurr] :
      ( v14432(VarCurr)
    <=> ( v14433(VarCurr)
        | v14448(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_438,axiom,
    ! [VarCurr] :
      ( v14448(VarCurr)
    <=> ( v14450(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2842,axiom,
    ! [VarCurr] :
      ( v14450(VarCurr)
    <=> ( v14451(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2841,axiom,
    ! [VarCurr] :
      ( v14451(VarCurr)
    <=> ( v14275(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2840,axiom,
    ! [VarCurr] :
      ( v14433(VarCurr)
    <=> ( v14434(VarCurr)
        | v14444(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_437,axiom,
    ! [VarCurr] :
      ( v14444(VarCurr)
    <=> ( v14446(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2839,axiom,
    ! [VarCurr] :
      ( v14446(VarCurr)
    <=> ( v14447(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2838,axiom,
    ! [VarCurr] :
      ( v14447(VarCurr)
    <=> ( v14270(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2837,axiom,
    ! [VarCurr] :
      ( v14434(VarCurr)
    <=> ( v14435(VarCurr)
        | v14440(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_436,axiom,
    ! [VarCurr] :
      ( v14440(VarCurr)
    <=> ( v14442(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2836,axiom,
    ! [VarCurr] :
      ( v14442(VarCurr)
    <=> ( v14443(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2835,axiom,
    ! [VarCurr] :
      ( v14443(VarCurr)
    <=> ( v14265(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_435,axiom,
    ! [VarCurr] :
      ( v14435(VarCurr)
    <=> ( v14437(VarCurr)
        & v12672(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2834,axiom,
    ! [VarCurr] :
      ( v14437(VarCurr)
    <=> ( v14438(VarCurr)
        & v14439(VarCurr) ) ) ).

fof(writeUnaryOperator_1396,axiom,
    ! [VarCurr] :
      ( ~ v14439(VarCurr)
    <=> v12672(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2833,axiom,
    ! [VarCurr] :
      ( v14438(VarCurr)
    <=> ( v14259(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2832,axiom,
    ! [VarCurr] :
      ( v14412(VarCurr)
    <=> ( v14414(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_434,axiom,
    ! [VarCurr] :
      ( v14414(VarCurr)
    <=> ( v14415(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_433,axiom,
    ! [VarCurr] :
      ( v14415(VarCurr)
    <=> ( v14416(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2831,axiom,
    ! [VarCurr] :
      ( v14416(VarCurr)
    <=> ( v14417(VarCurr)
        & v12672(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2830,axiom,
    ! [VarCurr] :
      ( v14417(VarCurr)
    <=> ( v14418(VarCurr)
        & v14020(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_432,axiom,
    ! [VarCurr] :
      ( v14418(VarCurr)
    <=> ( v14419(VarCurr)
        & v12810(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2829,axiom,
    ! [VarCurr] :
      ( v14419(VarCurr)
    <=> ( v14420(VarCurr)
        & v14056(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2828,axiom,
    ! [VarCurr] :
      ( v14420(VarCurr)
    <=> ( v14421(VarCurr)
        & v14055(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2827,axiom,
    ! [VarCurr] :
      ( v14421(VarCurr)
    <=> ( v14422(VarCurr)
        & v14037(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_431,axiom,
    ! [VarCurr] :
      ( v14422(VarCurr)
    <=> ( v14423(VarCurr)
        & v13075(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2826,axiom,
    ! [VarCurr] :
      ( v14423(VarCurr)
    <=> ( v14424(VarCurr)
        & v13075(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2825,axiom,
    ! [VarCurr] :
      ( v14424(VarCurr)
    <=> ( v14425(VarCurr)
        & v14018(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2824,axiom,
    ! [VarCurr] :
      ( v14425(VarCurr)
    <=> ( v14426(VarCurr)
        & v12847(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2823,axiom,
    ! [VarCurr] :
      ( v14426(VarCurr)
    <=> ( v14017(VarCurr)
        & v7861(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2822,axiom,
    ! [VarCurr] :
      ( v14403(VarCurr)
    <=> ( v14404(VarCurr)
        | v14408(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2821,axiom,
    ! [VarCurr] :
      ( v14408(VarCurr)
    <=> ( v14410(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_430,axiom,
    ! [VarCurr] :
      ( v14410(VarCurr)
    <=> ( v14411(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_429,axiom,
    ! [VarCurr] :
      ( v14411(VarCurr)
    <=> ( v14157(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2820,axiom,
    ! [VarCurr] :
      ( v14404(VarCurr)
    <=> ( v14406(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_428,axiom,
    ! [VarCurr] :
      ( v14406(VarCurr)
    <=> ( v14407(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_427,axiom,
    ! [VarCurr] :
      ( v14407(VarCurr)
    <=> ( v14137(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2819,axiom,
    ! [VarCurr] :
      ( v14373(VarCurr)
    <=> ( v14375(VarCurr)
        | v14399(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2818,axiom,
    ! [VarCurr] :
      ( v14399(VarCurr)
    <=> ( v14401(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_426,axiom,
    ! [VarCurr] :
      ( v14401(VarCurr)
    <=> ( v14402(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_425,axiom,
    ! [VarCurr] :
      ( v14402(VarCurr)
    <=> ( v14117(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2817,axiom,
    ! [VarCurr] :
      ( v14375(VarCurr)
    <=> ( v14376(VarCurr)
        | v14395(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2816,axiom,
    ! [VarCurr] :
      ( v14395(VarCurr)
    <=> ( v14397(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_424,axiom,
    ! [VarCurr] :
      ( v14397(VarCurr)
    <=> ( v14398(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_423,axiom,
    ! [VarCurr] :
      ( v14398(VarCurr)
    <=> ( v14102(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2815,axiom,
    ! [VarCurr] :
      ( v14376(VarCurr)
    <=> ( v14377(VarCurr)
        | v14391(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2814,axiom,
    ! [VarCurr] :
      ( v14391(VarCurr)
    <=> ( v14393(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_422,axiom,
    ! [VarCurr] :
      ( v14393(VarCurr)
    <=> ( v14394(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_421,axiom,
    ! [VarCurr] :
      ( v14394(VarCurr)
    <=> ( v14090(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2813,axiom,
    ! [VarCurr] :
      ( v14377(VarCurr)
    <=> ( v14378(VarCurr)
        | v14387(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2812,axiom,
    ! [VarCurr] :
      ( v14387(VarCurr)
    <=> ( v14389(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_420,axiom,
    ! [VarCurr] :
      ( v14389(VarCurr)
    <=> ( v14390(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_419,axiom,
    ! [VarCurr] :
      ( v14390(VarCurr)
    <=> ( v14078(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2811,axiom,
    ! [VarCurr] :
      ( v14378(VarCurr)
    <=> ( v14379(VarCurr)
        | v14383(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2810,axiom,
    ! [VarCurr] :
      ( v14383(VarCurr)
    <=> ( v14385(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_418,axiom,
    ! [VarCurr] :
      ( v14385(VarCurr)
    <=> ( v14386(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_417,axiom,
    ! [VarCurr] :
      ( v14386(VarCurr)
    <=> ( v14061(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2809,axiom,
    ! [VarCurr] :
      ( v14379(VarCurr)
    <=> ( v14381(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_416,axiom,
    ! [VarCurr] :
      ( v14381(VarCurr)
    <=> ( v14382(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_415,axiom,
    ! [VarCurr] :
      ( v14382(VarCurr)
    <=> ( v14042(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2808,axiom,
    ! [VarCurr] :
      ( v14337(VarCurr)
    <=> ( v14339(VarCurr)
        | v14370(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_414,axiom,
    ! [VarCurr] :
      ( v14370(VarCurr)
    <=> ( v14372(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2807,axiom,
    ! [VarCurr] :
      ( v14372(VarCurr)
    <=> ( v14360(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2806,axiom,
    ! [VarCurr] :
      ( v14339(VarCurr)
    <=> ( v14340(VarCurr)
        | v14367(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_413,axiom,
    ! [VarCurr] :
      ( v14367(VarCurr)
    <=> ( v14369(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2805,axiom,
    ! [VarCurr] :
      ( v14369(VarCurr)
    <=> ( v14356(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2804,axiom,
    ! [VarCurr] :
      ( v14340(VarCurr)
    <=> ( v14341(VarCurr)
        | v14364(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_412,axiom,
    ! [VarCurr] :
      ( v14364(VarCurr)
    <=> ( v14366(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2803,axiom,
    ! [VarCurr] :
      ( v14366(VarCurr)
    <=> ( v14352(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2802,axiom,
    ! [VarCurr] :
      ( v14341(VarCurr)
    <=> ( v14342(VarCurr)
        | v14361(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_411,axiom,
    ! [VarCurr] :
      ( v14361(VarCurr)
    <=> ( v14363(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2801,axiom,
    ! [VarCurr] :
      ( v14363(VarCurr)
    <=> ( v14348(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2800,axiom,
    ! [VarCurr] :
      ( v14342(VarCurr)
    <=> ( v14343(VarCurr)
        | v14357(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2799,axiom,
    ! [VarCurr] :
      ( v14357(VarCurr)
    <=> ( v14359(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_410,axiom,
    ! [VarCurr] :
      ( v14359(VarCurr)
    <=> ( v14360(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_409,axiom,
    ! [VarCurr] :
      ( v14360(VarCurr)
    <=> ( v14301(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2798,axiom,
    ! [VarCurr] :
      ( v14343(VarCurr)
    <=> ( v14344(VarCurr)
        | v14353(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2797,axiom,
    ! [VarCurr] :
      ( v14353(VarCurr)
    <=> ( v14355(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_408,axiom,
    ! [VarCurr] :
      ( v14355(VarCurr)
    <=> ( v14356(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_407,axiom,
    ! [VarCurr] :
      ( v14356(VarCurr)
    <=> ( v14292(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2796,axiom,
    ! [VarCurr] :
      ( v14344(VarCurr)
    <=> ( v14345(VarCurr)
        | v14349(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2795,axiom,
    ! [VarCurr] :
      ( v14349(VarCurr)
    <=> ( v14351(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_406,axiom,
    ! [VarCurr] :
      ( v14351(VarCurr)
    <=> ( v14352(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2794,axiom,
    ! [VarCurr] :
      ( v14352(VarCurr)
    <=> ( v14301(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2793,axiom,
    ! [VarCurr] :
      ( v14345(VarCurr)
    <=> ( v14347(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_405,axiom,
    ! [VarCurr] :
      ( v14347(VarCurr)
    <=> ( v14348(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2792,axiom,
    ! [VarCurr] :
      ( v14348(VarCurr)
    <=> ( v14292(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2791,axiom,
    ! [VarCurr] :
      ( v14305(VarCurr)
    <=> ( v14307(VarCurr)
        | v14333(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2790,axiom,
    ! [VarCurr] :
      ( v14333(VarCurr)
    <=> ( v14335(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2789,axiom,
    ! [VarCurr] :
      ( v14335(VarCurr)
    <=> ( v14336(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_404,axiom,
    ! [VarCurr] :
      ( v14336(VarCurr)
    <=> ( v14320(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2788,axiom,
    ! [VarCurr] :
      ( v14307(VarCurr)
    <=> ( v14308(VarCurr)
        | v14329(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2787,axiom,
    ! [VarCurr] :
      ( v14329(VarCurr)
    <=> ( v14331(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2786,axiom,
    ! [VarCurr] :
      ( v14331(VarCurr)
    <=> ( v14332(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_403,axiom,
    ! [VarCurr] :
      ( v14332(VarCurr)
    <=> ( v14315(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2785,axiom,
    ! [VarCurr] :
      ( v14308(VarCurr)
    <=> ( v14309(VarCurr)
        | v14325(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2784,axiom,
    ! [VarCurr] :
      ( v14325(VarCurr)
    <=> ( v14327(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2783,axiom,
    ! [VarCurr] :
      ( v14327(VarCurr)
    <=> ( v14328(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_402,axiom,
    ! [VarCurr] :
      ( v14328(VarCurr)
    <=> ( v14300(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2782,axiom,
    ! [VarCurr] :
      ( v14309(VarCurr)
    <=> ( v14310(VarCurr)
        | v14321(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2781,axiom,
    ! [VarCurr] :
      ( v14321(VarCurr)
    <=> ( v14323(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2780,axiom,
    ! [VarCurr] :
      ( v14323(VarCurr)
    <=> ( v14324(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_401,axiom,
    ! [VarCurr] :
      ( v14324(VarCurr)
    <=> ( v14291(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2779,axiom,
    ! [VarCurr] :
      ( v14310(VarCurr)
    <=> ( v14311(VarCurr)
        | v14316(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2778,axiom,
    ! [VarCurr] :
      ( v14316(VarCurr)
    <=> ( v14318(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2777,axiom,
    ! [VarCurr] :
      ( v14318(VarCurr)
    <=> ( v14319(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2776,axiom,
    ! [VarCurr] :
      ( v14319(VarCurr)
    <=> ( v14320(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2775,axiom,
    ! [VarCurr] :
      ( v14320(VarCurr)
    <=> ( v14301(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2774,axiom,
    ! [VarCurr] :
      ( v14311(VarCurr)
    <=> ( v14313(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2773,axiom,
    ! [VarCurr] :
      ( v14313(VarCurr)
    <=> ( v14314(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2772,axiom,
    ! [VarCurr] :
      ( v14314(VarCurr)
    <=> ( v14315(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2771,axiom,
    ! [VarCurr] :
      ( v14315(VarCurr)
    <=> ( v14292(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2770,axiom,
    ! [VarCurr] :
      ( v14286(VarCurr)
    <=> ( v14287(VarCurr)
        | v14296(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2769,axiom,
    ! [VarCurr] :
      ( v14296(VarCurr)
    <=> ( v14298(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2768,axiom,
    ! [VarCurr] :
      ( v14298(VarCurr)
    <=> ( v14299(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2767,axiom,
    ! [VarCurr] :
      ( v14299(VarCurr)
    <=> ( v14300(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2766,axiom,
    ! [VarCurr] :
      ( v14300(VarCurr)
    <=> ( v14301(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2765,axiom,
    ! [VarCurr] :
      ( v14301(VarCurr)
    <=> ( v14302(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_400,axiom,
    ! [VarCurr] :
      ( v14302(VarCurr)
    <=> ( v14303(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_399,axiom,
    ! [VarCurr] :
      ( v14303(VarCurr)
    <=> ( v14304(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2764,axiom,
    ! [VarCurr] :
      ( v14304(VarCurr)
    <=> ( v14158(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2763,axiom,
    ! [VarCurr] :
      ( v14287(VarCurr)
    <=> ( v14289(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2762,axiom,
    ! [VarCurr] :
      ( v14289(VarCurr)
    <=> ( v14290(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2761,axiom,
    ! [VarCurr] :
      ( v14290(VarCurr)
    <=> ( v14291(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2760,axiom,
    ! [VarCurr] :
      ( v14291(VarCurr)
    <=> ( v14292(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2759,axiom,
    ! [VarCurr] :
      ( v14292(VarCurr)
    <=> ( v14293(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_398,axiom,
    ! [VarCurr] :
      ( v14293(VarCurr)
    <=> ( v14294(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_397,axiom,
    ! [VarCurr] :
      ( v14294(VarCurr)
    <=> ( v14295(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2758,axiom,
    ! [VarCurr] :
      ( v14295(VarCurr)
    <=> ( v14138(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2757,axiom,
    ! [VarCurr] :
      ( v14249(VarCurr)
    <=> ( v14251(VarCurr)
        | v14281(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2756,axiom,
    ! [VarCurr] :
      ( v14281(VarCurr)
    <=> ( v14283(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_396,axiom,
    ! [VarCurr] :
      ( v14283(VarCurr)
    <=> ( v14284(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_395,axiom,
    ! [VarCurr] :
      ( v14284(VarCurr)
    <=> ( v14285(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2755,axiom,
    ! [VarCurr] :
      ( v14285(VarCurr)
    <=> ( v14118(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2754,axiom,
    ! [VarCurr] :
      ( v14251(VarCurr)
    <=> ( v14252(VarCurr)
        | v14276(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2753,axiom,
    ! [VarCurr] :
      ( v14276(VarCurr)
    <=> ( v14278(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_394,axiom,
    ! [VarCurr] :
      ( v14278(VarCurr)
    <=> ( v14279(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_393,axiom,
    ! [VarCurr] :
      ( v14279(VarCurr)
    <=> ( v14280(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2752,axiom,
    ! [VarCurr] :
      ( v14280(VarCurr)
    <=> ( v14103(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2751,axiom,
    ! [VarCurr] :
      ( v14252(VarCurr)
    <=> ( v14253(VarCurr)
        | v14271(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2750,axiom,
    ! [VarCurr] :
      ( v14271(VarCurr)
    <=> ( v14273(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_392,axiom,
    ! [VarCurr] :
      ( v14273(VarCurr)
    <=> ( v14274(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_391,axiom,
    ! [VarCurr] :
      ( v14274(VarCurr)
    <=> ( v14275(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2749,axiom,
    ! [VarCurr] :
      ( v14275(VarCurr)
    <=> ( v14091(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2748,axiom,
    ! [VarCurr] :
      ( v14253(VarCurr)
    <=> ( v14254(VarCurr)
        | v14266(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2747,axiom,
    ! [VarCurr] :
      ( v14266(VarCurr)
    <=> ( v14268(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_390,axiom,
    ! [VarCurr] :
      ( v14268(VarCurr)
    <=> ( v14269(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_389,axiom,
    ! [VarCurr] :
      ( v14269(VarCurr)
    <=> ( v14270(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2746,axiom,
    ! [VarCurr] :
      ( v14270(VarCurr)
    <=> ( v14079(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2745,axiom,
    ! [VarCurr] :
      ( v14254(VarCurr)
    <=> ( v14255(VarCurr)
        | v14261(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2744,axiom,
    ! [VarCurr] :
      ( v14261(VarCurr)
    <=> ( v14263(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_388,axiom,
    ! [VarCurr] :
      ( v14263(VarCurr)
    <=> ( v14264(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_387,axiom,
    ! [VarCurr] :
      ( v14264(VarCurr)
    <=> ( v14265(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2743,axiom,
    ! [VarCurr] :
      ( v14265(VarCurr)
    <=> ( v14062(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2742,axiom,
    ! [VarCurr] :
      ( v14255(VarCurr)
    <=> ( v14257(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_386,axiom,
    ! [VarCurr] :
      ( v14257(VarCurr)
    <=> ( v14258(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_385,axiom,
    ! [VarCurr] :
      ( v14258(VarCurr)
    <=> ( v14259(VarCurr)
        & v12672(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2741,axiom,
    ! [VarCurr] :
      ( v14259(VarCurr)
    <=> ( v14043(VarCurr)
        & v14260(VarCurr) ) ) ).

fof(writeUnaryOperator_1395,axiom,
    ! [VarCurr] :
      ( ~ v14260(VarCurr)
    <=> v12672(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2740,axiom,
    ! [VarCurr] :
      ( v14229(VarCurr)
    <=> ( v14231(VarCurr)
        | v14245(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_384,axiom,
    ! [VarCurr] :
      ( v14245(VarCurr)
    <=> ( v14247(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2739,axiom,
    ! [VarCurr] :
      ( v14247(VarCurr)
    <=> ( v14248(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_383,axiom,
    ! [VarCurr] :
      ( v14248(VarCurr)
    <=> ( v14154(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2738,axiom,
    ! [VarCurr] :
      ( v14231(VarCurr)
    <=> ( v14232(VarCurr)
        | v14241(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_382,axiom,
    ! [VarCurr] :
      ( v14241(VarCurr)
    <=> ( v14243(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2737,axiom,
    ! [VarCurr] :
      ( v14243(VarCurr)
    <=> ( v14244(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_381,axiom,
    ! [VarCurr] :
      ( v14244(VarCurr)
    <=> ( v14134(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2736,axiom,
    ! [VarCurr] :
      ( v14232(VarCurr)
    <=> ( v14233(VarCurr)
        | v14237(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_380,axiom,
    ! [VarCurr] :
      ( v14237(VarCurr)
    <=> ( v14239(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2735,axiom,
    ! [VarCurr] :
      ( v14239(VarCurr)
    <=> ( v14240(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2734,axiom,
    ! [VarCurr] :
      ( v14240(VarCurr)
    <=> ( v14154(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_379,axiom,
    ! [VarCurr] :
      ( v14233(VarCurr)
    <=> ( v14235(VarCurr)
        & v7898(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2733,axiom,
    ! [VarCurr] :
      ( v14235(VarCurr)
    <=> ( v14236(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2732,axiom,
    ! [VarCurr] :
      ( v14236(VarCurr)
    <=> ( v14134(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2731,axiom,
    ! [VarCurr] :
      ( v14165(VarCurr)
    <=> ( v14167(VarCurr)
        | v14226(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2730,axiom,
    ! [VarCurr] :
      ( v14226(VarCurr)
    <=> ( v14228(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_378,axiom,
    ! [VarCurr] :
      ( v14228(VarCurr)
    <=> ( v14204(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2729,axiom,
    ! [VarCurr] :
      ( v14167(VarCurr)
    <=> ( v14168(VarCurr)
        | v14223(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2728,axiom,
    ! [VarCurr] :
      ( v14223(VarCurr)
    <=> ( v14225(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_377,axiom,
    ! [VarCurr] :
      ( v14225(VarCurr)
    <=> ( v14200(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2727,axiom,
    ! [VarCurr] :
      ( v14168(VarCurr)
    <=> ( v14169(VarCurr)
        | v14220(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2726,axiom,
    ! [VarCurr] :
      ( v14220(VarCurr)
    <=> ( v14222(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_376,axiom,
    ! [VarCurr] :
      ( v14222(VarCurr)
    <=> ( v14196(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2725,axiom,
    ! [VarCurr] :
      ( v14169(VarCurr)
    <=> ( v14170(VarCurr)
        | v14217(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2724,axiom,
    ! [VarCurr] :
      ( v14217(VarCurr)
    <=> ( v14219(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_375,axiom,
    ! [VarCurr] :
      ( v14219(VarCurr)
    <=> ( v14192(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2723,axiom,
    ! [VarCurr] :
      ( v14170(VarCurr)
    <=> ( v14171(VarCurr)
        | v14214(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2722,axiom,
    ! [VarCurr] :
      ( v14214(VarCurr)
    <=> ( v14216(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_374,axiom,
    ! [VarCurr] :
      ( v14216(VarCurr)
    <=> ( v14187(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2721,axiom,
    ! [VarCurr] :
      ( v14171(VarCurr)
    <=> ( v14172(VarCurr)
        | v14211(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2720,axiom,
    ! [VarCurr] :
      ( v14211(VarCurr)
    <=> ( v14213(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_373,axiom,
    ! [VarCurr] :
      ( v14213(VarCurr)
    <=> ( v14182(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2719,axiom,
    ! [VarCurr] :
      ( v14172(VarCurr)
    <=> ( v14173(VarCurr)
        | v14208(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2718,axiom,
    ! [VarCurr] :
      ( v14208(VarCurr)
    <=> ( v14210(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_372,axiom,
    ! [VarCurr] :
      ( v14210(VarCurr)
    <=> ( v14152(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2717,axiom,
    ! [VarCurr] :
      ( v14173(VarCurr)
    <=> ( v14174(VarCurr)
        | v14205(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2716,axiom,
    ! [VarCurr] :
      ( v14205(VarCurr)
    <=> ( v14207(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_371,axiom,
    ! [VarCurr] :
      ( v14207(VarCurr)
    <=> ( v14132(VarCurr)
        & v7898(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2715,axiom,
    ! [VarCurr] :
      ( v14174(VarCurr)
    <=> ( v14175(VarCurr)
        | v14201(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2714,axiom,
    ! [VarCurr] :
      ( v14201(VarCurr)
    <=> ( v14203(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2713,axiom,
    ! [VarCurr] :
      ( v14203(VarCurr)
    <=> ( v14204(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_370,axiom,
    ! [VarCurr] :
      ( v14204(VarCurr)
    <=> ( v14188(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2712,axiom,
    ! [VarCurr] :
      ( v14175(VarCurr)
    <=> ( v14176(VarCurr)
        | v14197(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2711,axiom,
    ! [VarCurr] :
      ( v14197(VarCurr)
    <=> ( v14199(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2710,axiom,
    ! [VarCurr] :
      ( v14199(VarCurr)
    <=> ( v14200(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_369,axiom,
    ! [VarCurr] :
      ( v14200(VarCurr)
    <=> ( v14183(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2709,axiom,
    ! [VarCurr] :
      ( v14176(VarCurr)
    <=> ( v14177(VarCurr)
        | v14193(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2708,axiom,
    ! [VarCurr] :
      ( v14193(VarCurr)
    <=> ( v14195(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2707,axiom,
    ! [VarCurr] :
      ( v14195(VarCurr)
    <=> ( v14196(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_368,axiom,
    ! [VarCurr] :
      ( v14196(VarCurr)
    <=> ( v14153(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2706,axiom,
    ! [VarCurr] :
      ( v14177(VarCurr)
    <=> ( v14178(VarCurr)
        | v14189(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2705,axiom,
    ! [VarCurr] :
      ( v14189(VarCurr)
    <=> ( v14191(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2704,axiom,
    ! [VarCurr] :
      ( v14191(VarCurr)
    <=> ( v14192(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_367,axiom,
    ! [VarCurr] :
      ( v14192(VarCurr)
    <=> ( v14133(VarCurr)
        & v7898(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2703,axiom,
    ! [VarCurr] :
      ( v14178(VarCurr)
    <=> ( v14179(VarCurr)
        | v14184(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2702,axiom,
    ! [VarCurr] :
      ( v14184(VarCurr)
    <=> ( v14186(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2701,axiom,
    ! [VarCurr] :
      ( v14186(VarCurr)
    <=> ( v14187(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2700,axiom,
    ! [VarCurr] :
      ( v14187(VarCurr)
    <=> ( v14188(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2699,axiom,
    ! [VarCurr] :
      ( v14188(VarCurr)
    <=> ( v14154(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2698,axiom,
    ! [VarCurr] :
      ( v14179(VarCurr)
    <=> ( v14181(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2697,axiom,
    ! [VarCurr] :
      ( v14181(VarCurr)
    <=> ( v14182(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2696,axiom,
    ! [VarCurr] :
      ( v14182(VarCurr)
    <=> ( v14183(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2695,axiom,
    ! [VarCurr] :
      ( v14183(VarCurr)
    <=> ( v14134(VarCurr)
        & v7898(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2694,axiom,
    ! [VarCurr] :
      ( v14128(VarCurr)
    <=> ( v14129(VarCurr)
        | v14149(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2693,axiom,
    ! [VarCurr] :
      ( v14149(VarCurr)
    <=> ( v14151(VarCurr)
        & v14148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2692,axiom,
    ! [VarCurr] :
      ( v14151(VarCurr)
    <=> ( v14152(VarCurr)
        & v14147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2691,axiom,
    ! [VarCurr] :
      ( v14152(VarCurr)
    <=> ( v14153(VarCurr)
        & v14146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2690,axiom,
    ! [VarCurr] :
      ( v14153(VarCurr)
    <=> ( v14154(VarCurr)
        & v14145(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2689,axiom,
    ! [VarCurr] :
      ( v14154(VarCurr)
    <=> ( v14155(VarCurr)
        & v14022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_366,axiom,
    ! [VarCurr] :
      ( v14155(VarCurr)
    <=> ( v14156(VarCurr)
        & v12672(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2688,axiom,
    ! [VarCurr] :
      ( v14156(VarCurr)
    <=> ( v14157(VarCurr)
        & v14021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2687,axiom,
    ! [VarCurr] :
      ( v14157(VarCurr)
    <=> ( v14158(VarCurr)
        & v12672(VarCurr,bitIndex0) ) )