%------------------------------------------------------------------------------
% File     : HWV114+1 : TPTP v9.2.0. Released v6.1.0.
% Domain   : Hardware Verification
% Problem  : dmu_rmu_rrm property 1 cone of influence 10_b20
% Version  : Especial.
% English  : Verification of a property of the SPARCT2 RTL hardware design.

% Refs     : [Kha14] Khasidashvili (2014), Email to Geoff Sutcliffe
% Source   : [Kha14]
% Names    : dmu_rmu_rrm_prop1_cone10_b20 [Kha14]

% Status   : CounterSatisfiable
% Rating   : 0.00 v6.3.0, 0.25 v6.2.0, 0.33 v6.1.0
% Syntax   : Number of formulae    : 1333 ( 388 unt;   0 def)
%            Number of atoms       : 6698 ( 139 equ)
%            Maximal formula atoms :  142 (   5 avg)
%            Number of connectives : 5894 ( 529   ~; 213   |;1830   &)
%                                         (2708 <=>; 614  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   75 (   5 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of predicates  :  692 ( 689 usr;   2 prp; 0-2 aty)
%            Number of functors    :  581 ( 581 usr; 581 con; 0-0 aty)
%            Number of variables   : 1326 (1326   !;   0   ?)
% SPC      : FOF_CSA_RFO_SEQ

% Comments : Copyright 2013 Moshe Emmer and Zurab Khasidashvili
%            Licensed under the Apache License, Version 2.0 (the "License");
%            you may not use this file except in compliance with the License.
%            You may obtain a copy of the License at
%                http://www.apache.org/licenses/LICENSE-2.0
%            Unless required by applicable law or agreed to in writing,
%            software distributed under the License is distributed on an "AS
%            IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
%            express or implied. See the License for the specific language
%            governing permissions and limitations under the License.
%------------------------------------------------------------------------------
fof(pathAxiom_8,axiom,
    nextState(constB8,constB9) ).

fof(pathAxiom_7,axiom,
    nextState(constB7,constB8) ).

fof(pathAxiom_6,axiom,
    nextState(constB6,constB7) ).

fof(pathAxiom_5,axiom,
    nextState(constB5,constB6) ).

fof(pathAxiom_4,axiom,
    nextState(constB4,constB5) ).

fof(pathAxiom_3,axiom,
    nextState(constB3,constB4) ).

fof(pathAxiom_2,axiom,
    nextState(constB2,constB3) ).

fof(pathAxiom_1,axiom,
    nextState(constB1,constB2) ).

fof(pathAxiom,axiom,
    nextState(constB0,constB1) ).

fof(reachableStateAxiom_22,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( reachableState(VarCurr)
        & reachableState(VarNext) ) ) ).

fof(reachableStateAxiom_21,axiom,
    ! [VarState] :
      ( reachableState(VarState)
     => ( constB0 = VarState
        | constB1 = VarState
        | constB2 = VarState
        | constB3 = VarState
        | constB4 = VarState
        | constB5 = VarState
        | constB6 = VarState
        | constB7 = VarState
        | constB8 = VarState
        | constB9 = VarState
        | constB10 = VarState
        | constB11 = VarState
        | constB12 = VarState
        | constB13 = VarState
        | constB14 = VarState
        | constB15 = VarState
        | constB16 = VarState
        | constB17 = VarState
        | constB18 = VarState
        | constB19 = VarState
        | constB20 = VarState ) ) ).

fof(reachableStateAxiom_20,axiom,
    reachableState(constB20) ).

fof(reachableStateAxiom_19,axiom,
    reachableState(constB19) ).

fof(reachableStateAxiom_18,axiom,
    reachableState(constB18) ).

fof(reachableStateAxiom_17,axiom,
    reachableState(constB17) ).

fof(reachableStateAxiom_16,axiom,
    reachableState(constB16) ).

fof(reachableStateAxiom_15,axiom,
    reachableState(constB15) ).

fof(reachableStateAxiom_14,axiom,
    reachableState(constB14) ).

fof(reachableStateAxiom_13,axiom,
    reachableState(constB13) ).

fof(reachableStateAxiom_12,axiom,
    reachableState(constB12) ).

fof(reachableStateAxiom_11,axiom,
    reachableState(constB11) ).

fof(reachableStateAxiom_10,axiom,
    reachableState(constB10) ).

fof(reachableStateAxiom_9,axiom,
    reachableState(constB9) ).

fof(reachableStateAxiom_8,axiom,
    reachableState(constB8) ).

fof(reachableStateAxiom_7,axiom,
    reachableState(constB7) ).

fof(reachableStateAxiom_6,axiom,
    reachableState(constB6) ).

fof(reachableStateAxiom_5,axiom,
    reachableState(constB5) ).

fof(reachableStateAxiom_4,axiom,
    reachableState(constB4) ).

fof(reachableStateAxiom_3,axiom,
    reachableState(constB3) ).

fof(reachableStateAxiom_2,axiom,
    reachableState(constB2) ).

fof(reachableStateAxiom_1,axiom,
    reachableState(constB1) ).

fof(reachableStateAxiom,axiom,
    reachableState(constB0) ).

fof(clock_toggling,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1(VarCurr)
      <=> ~ v1(VarNext) ) ) ).

fof(clock_pattern,axiom,
    ~ v1(constB0) ).

fof(addAssertion,conjecture,
    ! [VarCurr] :
      ( reachableState(VarCurr)
     => v4(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_212,axiom,
    ! [VarCurr] :
      ( v4(VarCurr)
    <=> ( v1057(VarCurr)
        & v1062(VarCurr) ) ) ).

fof(writeUnaryOperator_83,axiom,
    ! [VarCurr] :
      ( ~ v1062(VarCurr)
    <=> v1063(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_211,axiom,
    ! [VarCurr] :
      ( v1063(VarCurr)
    <=> ( v927(VarCurr)
        & v954(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_210,axiom,
    ! [VarCurr] :
      ( v1057(VarCurr)
    <=> ( v1058(VarCurr)
        & v1060(VarCurr) ) ) ).

fof(writeUnaryOperator_82,axiom,
    ! [VarCurr] :
      ( ~ v1060(VarCurr)
    <=> v1061(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_209,axiom,
    ! [VarCurr] :
      ( v1061(VarCurr)
    <=> ( v54(VarCurr)
        & v954(VarCurr) ) ) ).

fof(writeUnaryOperator_81,axiom,
    ! [VarCurr] :
      ( ~ v1058(VarCurr)
    <=> v1059(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_208,axiom,
    ! [VarCurr] :
      ( v1059(VarCurr)
    <=> ( v54(VarCurr)
        & v927(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_21,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1044(VarNext)
       => ( v7(VarNext,bitIndex0)
        <=> v7(VarCurr,bitIndex0) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_40,axiom,
    ! [VarNext] :
      ( v1044(VarNext)
     => ( v7(VarNext,bitIndex0)
      <=> v1052(VarNext) ) ) ).

fof(addAssignment_321,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1052(VarNext)
      <=> v1050(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_34,axiom,
    ! [VarCurr] :
      ( ~ v941(VarCurr)
     => ( v1050(VarCurr)
      <=> v13(VarCurr,bitIndex0) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_36,axiom,
    ! [VarCurr] :
      ( v941(VarCurr)
     => ( v1050(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_207,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1044(VarNext)
      <=> v1045(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_206,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1045(VarNext)
      <=> ( v1047(VarNext)
          & v112(VarNext) ) ) ) ).

fof(writeUnaryOperator_80,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1047(VarNext)
      <=> v934(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_33,axiom,
    ! [VarCurr] :
      ( ~ v1027(VarCurr)
     => ( v13(VarCurr,bitIndex0)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_35,axiom,
    ! [VarCurr] :
      ( v1027(VarCurr)
     => ( v13(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_205,axiom,
    ! [VarCurr] :
      ( v1027(VarCurr)
    <=> ( v1028(VarCurr)
        | v1040(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_204,axiom,
    ! [VarCurr] :
      ( v1040(VarCurr)
    <=> ( v1041(VarCurr)
        & v954(VarCurr) ) ) ).

fof(writeUnaryOperator_79,axiom,
    ! [VarCurr] :
      ( ~ v1041(VarCurr)
    <=> v15(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_203,axiom,
    ! [VarCurr] :
      ( v1028(VarCurr)
    <=> ( v1029(VarCurr)
        | v1039(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_202,axiom,
    ! [VarCurr] :
      ( v1039(VarCurr)
    <=> ( v971(VarCurr)
        & v927(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_201,axiom,
    ! [VarCurr] :
      ( v1029(VarCurr)
    <=> ( v1030(VarCurr)
        & v54(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_200,axiom,
    ! [VarCurr] :
      ( v1030(VarCurr)
    <=> ( v1031(VarCurr)
        | v1038(VarCurr) ) ) ).

fof(writeUnaryOperator_78,axiom,
    ! [VarCurr] :
      ( ~ v1038(VarCurr)
    <=> v53(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_199,axiom,
    ! [VarCurr] :
      ( v1031(VarCurr)
    <=> ( v1032(VarCurr)
        & v53(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_198,axiom,
    ! [VarCurr] :
      ( v1032(VarCurr)
    <=> ( v1033(VarCurr)
        | v1036(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_197,axiom,
    ! [VarCurr] :
      ( v1036(VarCurr)
    <=> ( v1037(VarCurr)
        & v623(VarCurr) ) ) ).

fof(writeUnaryOperator_77,axiom,
    ! [VarCurr] :
      ( ~ v1037(VarCurr)
    <=> v76(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_196,axiom,
    ! [VarCurr] :
      ( v1033(VarCurr)
    <=> ( v1034(VarCurr)
        | v648(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_195,axiom,
    ! [VarCurr] :
      ( v1034(VarCurr)
    <=> ( v1035(VarCurr)
        & v52(VarCurr) ) ) ).

fof(writeUnaryOperator_76,axiom,
    ! [VarCurr] :
      ( ~ v1035(VarCurr)
    <=> v15(VarCurr) ) ).

fof(writeUnaryOperator_75,axiom,
    ! [VarCurr] :
      ( ~ v15(VarCurr)
    <=> v1025(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_7,axiom,
    ! [VarCurr] :
      ( v1025(VarCurr)
    <=> ( v1003(VarCurr)
        | v17(VarCurr,bitIndex2) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_20,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1011(VarNext)
       => ! [B] :
            ( range_2_0(B)
           => ( v17(VarNext,B)
            <=> v17(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_39,axiom,
    ! [VarNext] :
      ( v1011(VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v17(VarNext,B)
          <=> v1019(VarNext,B) ) ) ) ).

fof(addAssignment_320,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v1019(VarNext,B)
          <=> v1017(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_32,axiom,
    ! [VarCurr] :
      ( ~ v1020(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v1017(VarCurr,B)
          <=> v20(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_34,axiom,
    ! [VarCurr] :
      ( v1020(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v1017(VarCurr,B)
          <=> b100(B) ) ) ) ).

fof(writeUnaryOperator_74,axiom,
    ! [VarCurr] :
      ( ~ v1020(VarCurr)
    <=> v9(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_194,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1011(VarNext)
      <=> v1012(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_193,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1012(VarNext)
      <=> ( v1013(VarNext)
          & v112(VarNext) ) ) ) ).

fof(writeUnaryOperator_73,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1013(VarNext)
      <=> v934(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_13,axiom,
    ! [VarCurr] :
      ( ( ~ v976(VarCurr)
        & ~ v992(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v20(VarCurr,B)
          <=> v17(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_21,axiom,
    ! [VarCurr] :
      ( v992(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v20(VarCurr,B)
          <=> v994(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_15,axiom,
    ! [VarCurr] :
      ( v976(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v20(VarCurr,B)
          <=> v978(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_192,axiom,
    ! [VarCurr] :
      ( v1004(VarCurr)
    <=> ( v1005(VarCurr)
        | v1007(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_74,axiom,
    ! [VarCurr] :
      ( v1007(VarCurr)
    <=> ( ( v1008(VarCurr,bitIndex1)
        <=> $true )
        & ( v1008(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_319,axiom,
    ! [VarCurr] :
      ( v1008(VarCurr,bitIndex0)
    <=> v26(VarCurr) ) ).

fof(addAssignment_318,axiom,
    ! [VarCurr] :
      ( v1008(VarCurr,bitIndex1)
    <=> v22(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_73,axiom,
    ! [VarCurr] :
      ( v1005(VarCurr)
    <=> ( ( v1006(VarCurr,bitIndex1)
        <=> $false )
        & ( v1006(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_317,axiom,
    ! [VarCurr] :
      ( v1006(VarCurr,bitIndex0)
    <=> v26(VarCurr) ) ).

fof(addAssignment_316,axiom,
    ! [VarCurr] :
      ( v1006(VarCurr,bitIndex1)
    <=> v22(VarCurr) ) ).

fof(addAssignment_315,axiom,
    ! [VarCurr] :
      ( v994(VarCurr,bitIndex0)
    <=> v990(VarCurr) ) ).

fof(addAssignment_314,axiom,
    ! [VarCurr] :
      ( v994(VarCurr,bitIndex1)
    <=> v1001(VarCurr) ) ).

fof(addAssignment_313,axiom,
    ! [VarCurr] :
      ( v994(VarCurr,bitIndex2)
    <=> v996(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_191,axiom,
    ! [VarCurr] :
      ( v1001(VarCurr)
    <=> ( v1002(VarCurr)
        & v1003(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_6,axiom,
    ! [VarCurr] :
      ( v1003(VarCurr)
    <=> ( v17(VarCurr,bitIndex0)
        | v17(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_190,axiom,
    ! [VarCurr] :
      ( v1002(VarCurr)
    <=> ( v990(VarCurr)
        | v985(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_189,axiom,
    ! [VarCurr] :
      ( v996(VarCurr)
    <=> ( v997(VarCurr)
        & v1000(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_5,axiom,
    ! [VarCurr] :
      ( v1000(VarCurr)
    <=> ( v17(VarCurr,bitIndex2)
        | v999(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_188,axiom,
    ! [VarCurr] :
      ( v997(VarCurr)
    <=> ( v987(VarCurr)
        | v998(VarCurr) ) ) ).

fof(writeUnaryOperator_72,axiom,
    ! [VarCurr] :
      ( ~ v998(VarCurr)
    <=> v999(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_4,axiom,
    ! [VarCurr] :
      ( v999(VarCurr)
    <=> ( v17(VarCurr,bitIndex0)
        & v17(VarCurr,bitIndex1) ) ) ).

fof(addBitVectorEqualityBitBlasted_72,axiom,
    ! [VarCurr] :
      ( v992(VarCurr)
    <=> ( ( v993(VarCurr,bitIndex1)
        <=> $true )
        & ( v993(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_312,axiom,
    ! [VarCurr] :
      ( v993(VarCurr,bitIndex0)
    <=> v26(VarCurr) ) ).

fof(addAssignment_311,axiom,
    ! [VarCurr] :
      ( v993(VarCurr,bitIndex1)
    <=> v22(VarCurr) ) ).

fof(addAssignment_310,axiom,
    ! [VarCurr] :
      ( v978(VarCurr,bitIndex0)
    <=> v990(VarCurr) ) ).

fof(addAssignment_309,axiom,
    ! [VarCurr] :
      ( v978(VarCurr,bitIndex1)
    <=> v988(VarCurr) ) ).

fof(addAssignment_308,axiom,
    ! [VarCurr] :
      ( v978(VarCurr,bitIndex2)
    <=> v980(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_187,axiom,
    ! [VarCurr] :
      ( v988(VarCurr)
    <=> ( v989(VarCurr)
        & v991(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_186,axiom,
    ! [VarCurr] :
      ( v991(VarCurr)
    <=> ( v17(VarCurr,bitIndex0)
        | v985(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3,axiom,
    ! [VarCurr] :
      ( v989(VarCurr)
    <=> ( v990(VarCurr)
        | v17(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_71,axiom,
    ! [VarCurr] :
      ( ~ v990(VarCurr)
    <=> v17(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_185,axiom,
    ! [VarCurr] :
      ( v980(VarCurr)
    <=> ( v981(VarCurr)
        & v986(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_184,axiom,
    ! [VarCurr] :
      ( v986(VarCurr)
    <=> ( v983(VarCurr)
        | v987(VarCurr) ) ) ).

fof(writeUnaryOperator_70,axiom,
    ! [VarCurr] :
      ( ~ v987(VarCurr)
    <=> v17(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges_2,axiom,
    ! [VarCurr] :
      ( v981(VarCurr)
    <=> ( v982(VarCurr)
        | v17(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_69,axiom,
    ! [VarCurr] :
      ( ~ v982(VarCurr)
    <=> v983(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_1,axiom,
    ! [VarCurr] :
      ( v983(VarCurr)
    <=> ( v17(VarCurr,bitIndex1)
        | v984(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_183,axiom,
    ! [VarCurr] :
      ( v984(VarCurr)
    <=> ( v17(VarCurr,bitIndex0)
        & v985(VarCurr) ) ) ).

fof(writeUnaryOperator_68,axiom,
    ! [VarCurr] :
      ( ~ v985(VarCurr)
    <=> v17(VarCurr,bitIndex1) ) ).

fof(addAssignmentInitValue_84,axiom,
    v17(constB0,bitIndex2) ).

fof(addAssignmentInitValue_83,axiom,
    ~ v17(constB0,bitIndex1) ).

fof(addAssignmentInitValue_82,axiom,
    ~ v17(constB0,bitIndex0) ).

fof(bitBlastConstant_271,axiom,
    b100(bitIndex2) ).

fof(bitBlastConstant_270,axiom,
    ~ b100(bitIndex1) ).

fof(bitBlastConstant_269,axiom,
    ~ b100(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_71,axiom,
    ! [VarCurr] :
      ( v976(VarCurr)
    <=> ( ( v977(VarCurr,bitIndex1)
        <=> $false )
        & ( v977(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_307,axiom,
    ! [VarCurr] :
      ( v977(VarCurr,bitIndex0)
    <=> v26(VarCurr) ) ).

fof(addAssignment_306,axiom,
    ! [VarCurr] :
      ( v977(VarCurr,bitIndex1)
    <=> v22(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_31,axiom,
    ! [VarCurr] :
      ( ~ v964(VarCurr)
     => ( v26(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_33,axiom,
    ! [VarCurr] :
      ( v964(VarCurr)
     => ( v26(VarCurr)
      <=> v968(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_12,axiom,
    ! [VarCurr] :
      ( ( ~ v966(VarCurr)
        & ~ v927(VarCurr) )
     => ( v968(VarCurr)
      <=> v973(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_20,axiom,
    ! [VarCurr] :
      ( v927(VarCurr)
     => ( v968(VarCurr)
      <=> v970(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_14,axiom,
    ! [VarCurr] :
      ( v966(VarCurr)
     => ( v968(VarCurr)
      <=> v969(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_30,axiom,
    ! [VarCurr] :
      ( ~ v15(VarCurr)
     => ( v973(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_32,axiom,
    ! [VarCurr] :
      ( v15(VarCurr)
     => ( v973(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_11,axiom,
    ! [VarCurr] :
      ( ( ~ v922(VarCurr)
        & ~ v971(VarCurr) )
     => ( v970(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_19,axiom,
    ! [VarCurr] :
      ( v971(VarCurr)
     => ( v970(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_13,axiom,
    ! [VarCurr] :
      ( v922(VarCurr)
     => ( v970(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_70,axiom,
    ! [VarCurr] :
      ( v971(VarCurr)
    <=> ( ( v972(VarCurr,bitIndex1)
        <=> $true )
        & ( v972(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_305,axiom,
    ! [VarCurr] :
      ( v972(VarCurr,bitIndex0)
    <=> v15(VarCurr) ) ).

fof(addAssignment_304,axiom,
    ! [VarCurr] :
      ( v972(VarCurr,bitIndex1)
    <=> v56(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_29,axiom,
    ! [VarCurr] :
      ( ~ v15(VarCurr)
     => ( v969(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_31,axiom,
    ! [VarCurr] :
      ( v15(VarCurr)
     => ( v969(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_182,axiom,
    ! [VarCurr] :
      ( v964(VarCurr)
    <=> ( v965(VarCurr)
        | v954(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_181,axiom,
    ! [VarCurr] :
      ( v965(VarCurr)
    <=> ( v966(VarCurr)
        | v927(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_180,axiom,
    ! [VarCurr] :
      ( v966(VarCurr)
    <=> ( v967(VarCurr)
        & v54(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_179,axiom,
    ! [VarCurr] :
      ( v967(VarCurr)
    <=> ( v52(VarCurr)
        & v53(VarCurr) ) ) ).

fof(addAssignment_303,axiom,
    ! [VarNext] :
      ( v7(VarNext,bitIndex1)
    <=> v956(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionShiftedRanges1_18,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v957(VarNext)
       => ( ( v956(VarNext,bitIndex1)
          <=> v7(VarCurr,bitIndex2) )
          & ( v956(VarNext,bitIndex0)
          <=> v7(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_38,axiom,
    ! [VarNext] :
      ( v957(VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v956(VarNext,B)
          <=> v940(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_178,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v957(VarNext)
      <=> v958(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_177,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v958(VarNext)
      <=> ( v960(VarNext)
          & v112(VarNext) ) ) ) ).

fof(writeUnaryOperator_67,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v960(VarNext)
      <=> v934(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_6,axiom,
    ! [VarCurr] :
      ( ~ v945(VarCurr)
     => ( v13(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_4,axiom,
    ! [VarCurr] :
      ( v945(VarCurr)
     => ( v13(VarCurr,bitIndex1)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_176,axiom,
    ! [VarCurr] :
      ( v945(VarCurr)
    <=> ( v946(VarCurr)
        | v953(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_175,axiom,
    ! [VarCurr] :
      ( v953(VarCurr)
    <=> ( v15(VarCurr)
        & v954(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_69,axiom,
    ! [VarCurr] :
      ( v954(VarCurr)
    <=> ( $true
      <=> v7(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_174,axiom,
    ! [VarCurr] :
      ( v946(VarCurr)
    <=> ( v947(VarCurr)
        | v950(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_173,axiom,
    ! [VarCurr] :
      ( v950(VarCurr)
    <=> ( v951(VarCurr)
        & v927(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_68,axiom,
    ! [VarCurr] :
      ( v951(VarCurr)
    <=> ( ( v952(VarCurr,bitIndex1)
        <=> $true )
        & ( v952(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_302,axiom,
    ! [VarCurr] :
      ( v952(VarCurr,bitIndex0)
    <=> v15(VarCurr) ) ).

fof(addAssignment_301,axiom,
    ! [VarCurr] :
      ( v952(VarCurr,bitIndex1)
    <=> v56(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_172,axiom,
    ! [VarCurr] :
      ( v947(VarCurr)
    <=> ( v948(VarCurr)
        & v54(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_171,axiom,
    ! [VarCurr] :
      ( v948(VarCurr)
    <=> ( v949(VarCurr)
        & v53(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_170,axiom,
    ! [VarCurr] :
      ( v949(VarCurr)
    <=> ( v15(VarCurr)
        & v52(VarCurr) ) ) ).

fof(addAssignment_300,axiom,
    ! [VarNext] :
      ( v7(VarNext,bitIndex2)
    <=> v929(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionShiftedRanges1_17,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v930(VarNext)
       => ( ( v929(VarNext,bitIndex1)
          <=> v7(VarCurr,bitIndex2) )
          & ( v929(VarNext,bitIndex0)
          <=> v7(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_37,axiom,
    ! [VarNext] :
      ( v930(VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v929(VarNext,B)
          <=> v940(VarNext,B) ) ) ) ).

fof(addAssignment_299,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v940(VarNext,B)
          <=> v938(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_5,axiom,
    ! [VarCurr] :
      ( ~ v941(VarCurr)
     => ( ( v938(VarCurr,bitIndex1)
        <=> v13(VarCurr,bitIndex2) )
        & ( v938(VarCurr,bitIndex0)
        <=> v13(VarCurr,bitIndex1) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_30,axiom,
    ! [VarCurr] :
      ( v941(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v938(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_66,axiom,
    ! [VarCurr] :
      ( ~ v941(VarCurr)
    <=> v9(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_169,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v930(VarNext)
      <=> v931(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_168,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v931(VarNext)
      <=> ( v932(VarNext)
          & v112(VarNext) ) ) ) ).

fof(writeUnaryOperator_65,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v932(VarNext)
      <=> v934(VarNext) ) ) ).

fof(addAssignment_298,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v934(VarNext)
      <=> v112(VarCurr) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_4,axiom,
    ! [VarCurr] :
      ( ~ v917(VarCurr)
     => ( v13(VarCurr,bitIndex2)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_3,axiom,
    ! [VarCurr] :
      ( v917(VarCurr)
     => ( v13(VarCurr,bitIndex2)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_167,axiom,
    ! [VarCurr] :
      ( v917(VarCurr)
    <=> ( v918(VarCurr)
        | v921(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_166,axiom,
    ! [VarCurr] :
      ( v921(VarCurr)
    <=> ( v922(VarCurr)
        & v927(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_67,axiom,
    ! [VarCurr] :
      ( v927(VarCurr)
    <=> ( $true
      <=> v7(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_165,axiom,
    ! [VarCurr] :
      ( v922(VarCurr)
    <=> ( v923(VarCurr)
        | v925(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_66,axiom,
    ! [VarCurr] :
      ( v925(VarCurr)
    <=> ( ( v926(VarCurr,bitIndex1)
        <=> $false )
        & ( v926(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_297,axiom,
    ! [VarCurr] :
      ( v926(VarCurr,bitIndex0)
    <=> v15(VarCurr) ) ).

fof(addAssignment_296,axiom,
    ! [VarCurr] :
      ( v926(VarCurr,bitIndex1)
    <=> v56(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_65,axiom,
    ! [VarCurr] :
      ( v923(VarCurr)
    <=> ( ( v924(VarCurr,bitIndex1)
        <=> $false )
        & ( v924(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_295,axiom,
    ! [VarCurr] :
      ( v924(VarCurr,bitIndex0)
    <=> v15(VarCurr) ) ).

fof(addAssignment_294,axiom,
    ! [VarCurr] :
      ( v924(VarCurr,bitIndex1)
    <=> v56(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_164,axiom,
    ! [VarCurr] :
      ( v918(VarCurr)
    <=> ( v919(VarCurr)
        & v54(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_163,axiom,
    ! [VarCurr] :
      ( v919(VarCurr)
    <=> ( v920(VarCurr)
        & v53(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_162,axiom,
    ! [VarCurr] :
      ( v920(VarCurr)
    <=> ( v76(VarCurr)
        & v623(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_28,axiom,
    ! [VarCurr] :
      ( ~ v30(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v28(VarCurr,B)
          <=> v888(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_29,axiom,
    ! [VarCurr] :
      ( v30(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v28(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_2,axiom,
    ! [VarCurr] :
      ( ( ~ v889(VarCurr)
        & ~ v909(VarCurr)
        & ~ v910(VarCurr) )
     => ! [B] :
          ( range_1_0(B)
         => ( v888(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_10,axiom,
    ! [VarCurr] :
      ( v910(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v888(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_18,axiom,
    ! [VarCurr] :
      ( v909(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v888(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_12,axiom,
    ! [VarCurr] :
      ( v889(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v888(VarCurr,B)
          <=> $false ) ) ) ).

fof(range_axiom_7,axiom,
    ! [B] :
      ( range_1_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_161,axiom,
    ! [VarCurr] :
      ( v910(VarCurr)
    <=> ( v912(VarCurr)
        | v915(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_64,axiom,
    ! [VarCurr] :
      ( v915(VarCurr)
    <=> ( ( v770(VarCurr,bitIndex6)
        <=> $true )
        & ( v770(VarCurr,bitIndex5)
        <=> $false )
        & ( v770(VarCurr,bitIndex4)
        <=> $false )
        & ( v770(VarCurr,bitIndex3)
        <=> $true )
        & ( v770(VarCurr,bitIndex2)
        <=> $false )
        & ( v770(VarCurr,bitIndex1)
        <=> $true )
        & ( v770(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_268,axiom,
    b1001010(bitIndex6) ).

fof(bitBlastConstant_267,axiom,
    ~ b1001010(bitIndex5) ).

fof(bitBlastConstant_266,axiom,
    ~ b1001010(bitIndex4) ).

fof(bitBlastConstant_265,axiom,
    b1001010(bitIndex3) ).

fof(bitBlastConstant_264,axiom,
    ~ b1001010(bitIndex2) ).

fof(bitBlastConstant_263,axiom,
    b1001010(bitIndex1) ).

fof(bitBlastConstant_262,axiom,
    ~ b1001010(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_160,axiom,
    ! [VarCurr] :
      ( v912(VarCurr)
    <=> ( v913(VarCurr)
        | v914(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_63,axiom,
    ! [VarCurr] :
      ( v914(VarCurr)
    <=> ( ( v770(VarCurr,bitIndex6)
        <=> $false )
        & ( v770(VarCurr,bitIndex5)
        <=> $false )
        & ( v770(VarCurr,bitIndex4)
        <=> $false )
        & ( v770(VarCurr,bitIndex3)
        <=> $true )
        & ( v770(VarCurr,bitIndex2)
        <=> $false )
        & ( v770(VarCurr,bitIndex1)
        <=> $true )
        & ( v770(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_261,axiom,
    ~ b0001011(bitIndex6) ).

fof(bitBlastConstant_260,axiom,
    ~ b0001011(bitIndex5) ).

fof(bitBlastConstant_259,axiom,
    ~ b0001011(bitIndex4) ).

fof(bitBlastConstant_258,axiom,
    b0001011(bitIndex3) ).

fof(bitBlastConstant_257,axiom,
    ~ b0001011(bitIndex2) ).

fof(bitBlastConstant_256,axiom,
    b0001011(bitIndex1) ).

fof(bitBlastConstant_255,axiom,
    b0001011(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_62,axiom,
    ! [VarCurr] :
      ( v913(VarCurr)
    <=> ( ( v770(VarCurr,bitIndex6)
        <=> $false )
        & ( v770(VarCurr,bitIndex5)
        <=> $false )
        & ( v770(VarCurr,bitIndex4)
        <=> $false )
        & ( v770(VarCurr,bitIndex3)
        <=> $true )
        & ( v770(VarCurr,bitIndex2)
        <=> $false )
        & ( v770(VarCurr,bitIndex1)
        <=> $true )
        & ( v770(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_254,axiom,
    ~ b0001010(bitIndex6) ).

fof(bitBlastConstant_253,axiom,
    ~ b0001010(bitIndex5) ).

fof(bitBlastConstant_252,axiom,
    ~ b0001010(bitIndex4) ).

fof(bitBlastConstant_251,axiom,
    b0001010(bitIndex3) ).

fof(bitBlastConstant_250,axiom,
    ~ b0001010(bitIndex2) ).

fof(bitBlastConstant_249,axiom,
    b0001010(bitIndex1) ).

fof(bitBlastConstant_248,axiom,
    ~ b0001010(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_61,axiom,
    ! [VarCurr] :
      ( v909(VarCurr)
    <=> ( ( v770(VarCurr,bitIndex6)
        <=> $true )
        & ( v770(VarCurr,bitIndex5)
        <=> $true )
        & ( v770(VarCurr,bitIndex4)
        <=> $true )
        & ( v770(VarCurr,bitIndex3)
        <=> $true )
        & ( v770(VarCurr,bitIndex2)
        <=> $false )
        & ( v770(VarCurr,bitIndex1)
        <=> $true )
        & ( v770(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_247,axiom,
    b1111010(bitIndex6) ).

fof(bitBlastConstant_246,axiom,
    b1111010(bitIndex5) ).

fof(bitBlastConstant_245,axiom,
    b1111010(bitIndex4) ).

fof(bitBlastConstant_244,axiom,
    b1111010(bitIndex3) ).

fof(bitBlastConstant_243,axiom,
    ~ b1111010(bitIndex2) ).

fof(bitBlastConstant_242,axiom,
    b1111010(bitIndex1) ).

fof(bitBlastConstant_241,axiom,
    ~ b1111010(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_159,axiom,
    ! [VarCurr] :
      ( v889(VarCurr)
    <=> ( v891(VarCurr)
        | v908(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_60,axiom,
    ! [VarCurr] :
      ( v908(VarCurr)
    <=> ( ( v770(VarCurr,bitIndex6)
        <=> $true )
        & ( v770(VarCurr,bitIndex5)
        <=> $false )
        & ( v770(VarCurr,bitIndex4)
        <=> $false )
        & ( v770(VarCurr,bitIndex3)
        <=> $false )
        & ( v770(VarCurr,bitIndex2)
        <=> $true )
        & ( v770(VarCurr,bitIndex1)
        <=> $false )
        & ( v770(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_240,axiom,
    b1000101(bitIndex6) ).

fof(bitBlastConstant_239,axiom,
    ~ b1000101(bitIndex5) ).

fof(bitBlastConstant_238,axiom,
    ~ b1000101(bitIndex4) ).

fof(bitBlastConstant_237,axiom,
    ~ b1000101(bitIndex3) ).

fof(bitBlastConstant_236,axiom,
    b1000101(bitIndex2) ).

fof(bitBlastConstant_235,axiom,
    ~ b1000101(bitIndex1) ).

fof(bitBlastConstant_234,axiom,
    b1000101(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_158,axiom,
    ! [VarCurr] :
      ( v891(VarCurr)
    <=> ( v892(VarCurr)
        | v907(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_59,axiom,
    ! [VarCurr] :
      ( v907(VarCurr)
    <=> ( ( v770(VarCurr,bitIndex6)
        <=> $true )
        & ( v770(VarCurr,bitIndex5)
        <=> $false )
        & ( v770(VarCurr,bitIndex4)
        <=> $false )
        & ( v770(VarCurr,bitIndex3)
        <=> $false )
        & ( v770(VarCurr,bitIndex2)
        <=> $true )
        & ( v770(VarCurr,bitIndex1)
        <=> $false )
        & ( v770(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_233,axiom,
    b1000100(bitIndex6) ).

fof(bitBlastConstant_232,axiom,
    ~ b1000100(bitIndex5) ).

fof(bitBlastConstant_231,axiom,
    ~ b1000100(bitIndex4) ).

fof(bitBlastConstant_230,axiom,
    ~ b1000100(bitIndex3) ).

fof(bitBlastConstant_229,axiom,
    b1000100(bitIndex2) ).

fof(bitBlastConstant_228,axiom,
    ~ b1000100(bitIndex1) ).

fof(bitBlastConstant_227,axiom,
    ~ b1000100(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_157,axiom,
    ! [VarCurr] :
      ( v892(VarCurr)
    <=> ( v893(VarCurr)
        | v906(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_58,axiom,
    ! [VarCurr] :
      ( v906(VarCurr)
    <=> ( ( v770(VarCurr,bitIndex6)
        <=> $true )
        & ( v770(VarCurr,bitIndex5)
        <=> $true )
        & ( v770(VarCurr,bitIndex4)
        <=> $false )
        & ( v770(VarCurr,bitIndex3)
        <=> $false )
        & ( v770(VarCurr,bitIndex2)
        <=> $false )
        & ( v770(VarCurr,bitIndex1)
        <=> $false )
        & ( v770(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_226,axiom,
    b1100000(bitIndex6) ).

fof(bitBlastConstant_225,axiom,
    b1100000(bitIndex5) ).

fof(bitBlastConstant_224,axiom,
    ~ b1100000(bitIndex4) ).

fof(bitBlastConstant_223,axiom,
    ~ b1100000(bitIndex3) ).

fof(bitBlastConstant_222,axiom,
    ~ b1100000(bitIndex2) ).

fof(bitBlastConstant_221,axiom,
    ~ b1100000(bitIndex1) ).

fof(bitBlastConstant_220,axiom,
    ~ b1100000(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_156,axiom,
    ! [VarCurr] :
      ( v893(VarCurr)
    <=> ( v894(VarCurr)
        | v905(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_57,axiom,
    ! [VarCurr] :
      ( v905(VarCurr)
    <=> ( ( v770(VarCurr,bitIndex6)
        <=> $true )
        & ( v770(VarCurr,bitIndex5)
        <=> $false )
        & ( v770(VarCurr,bitIndex4)
        <=> $false )
        & ( v770(VarCurr,bitIndex3)
        <=> $false )
        & ( v770(VarCurr,bitIndex2)
        <=> $false )
        & ( v770(VarCurr,bitIndex1)
        <=> $false )
        & ( v770(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_219,axiom,
    b1000000(bitIndex6) ).

fof(bitBlastConstant_218,axiom,
    ~ b1000000(bitIndex5) ).

fof(bitBlastConstant_217,axiom,
    ~ b1000000(bitIndex4) ).

fof(bitBlastConstant_216,axiom,
    ~ b1000000(bitIndex3) ).

fof(bitBlastConstant_215,axiom,
    ~ b1000000(bitIndex2) ).

fof(bitBlastConstant_214,axiom,
    ~ b1000000(bitIndex1) ).

fof(bitBlastConstant_213,axiom,
    ~ b1000000(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_155,axiom,
    ! [VarCurr] :
      ( v894(VarCurr)
    <=> ( v895(VarCurr)
        | v904(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_56,axiom,
    ! [VarCurr] :
      ( v904(VarCurr)
    <=> ( ( v770(VarCurr,bitIndex6)
        <=> $true )
        & ( v770(VarCurr,bitIndex5)
        <=> $false )
        & ( v770(VarCurr,bitIndex4)
        <=> $false )
        & ( v770(VarCurr,bitIndex3)
        <=> $false )
        & ( v770(VarCurr,bitIndex2)
        <=> $false )
        & ( v770(VarCurr,bitIndex1)
        <=> $true )
        & ( v770(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_212,axiom,
    b1000010(bitIndex6) ).

fof(bitBlastConstant_211,axiom,
    ~ b1000010(bitIndex5) ).

fof(bitBlastConstant_210,axiom,
    ~ b1000010(bitIndex4) ).

fof(bitBlastConstant_209,axiom,
    ~ b1000010(bitIndex3) ).

fof(bitBlastConstant_208,axiom,
    ~ b1000010(bitIndex2) ).

fof(bitBlastConstant_207,axiom,
    b1000010(bitIndex1) ).

fof(bitBlastConstant_206,axiom,
    ~ b1000010(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_154,axiom,
    ! [VarCurr] :
      ( v895(VarCurr)
    <=> ( v896(VarCurr)
        | v903(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_55,axiom,
    ! [VarCurr] :
      ( v903(VarCurr)
    <=> ( ( v770(VarCurr,bitIndex6)
        <=> $false )
        & ( v770(VarCurr,bitIndex5)
        <=> $false )
        & ( v770(VarCurr,bitIndex4)
        <=> $false )
        & ( v770(VarCurr,bitIndex3)
        <=> $false )
        & ( v770(VarCurr,bitIndex2)
        <=> $true )
        & ( v770(VarCurr,bitIndex1)
        <=> $false )
        & ( v770(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_205,axiom,
    ~ b0000101(bitIndex6) ).

fof(bitBlastConstant_204,axiom,
    ~ b0000101(bitIndex5) ).

fof(bitBlastConstant_203,axiom,
    ~ b0000101(bitIndex4) ).

fof(bitBlastConstant_202,axiom,
    ~ b0000101(bitIndex3) ).

fof(bitBlastConstant_201,axiom,
    b0000101(bitIndex2) ).

fof(bitBlastConstant_200,axiom,
    ~ b0000101(bitIndex1) ).

fof(bitBlastConstant_199,axiom,
    b0000101(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_153,axiom,
    ! [VarCurr] :
      ( v896(VarCurr)
    <=> ( v897(VarCurr)
        | v902(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_54,axiom,
    ! [VarCurr] :
      ( v902(VarCurr)
    <=> ( ( v770(VarCurr,bitIndex6)
        <=> $false )
        & ( v770(VarCurr,bitIndex5)
        <=> $false )
        & ( v770(VarCurr,bitIndex4)
        <=> $false )
        & ( v770(VarCurr,bitIndex3)
        <=> $false )
        & ( v770(VarCurr,bitIndex2)
        <=> $true )
        & ( v770(VarCurr,bitIndex1)
        <=> $false )
        & ( v770(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_198,axiom,
    ~ b0000100(bitIndex6) ).

fof(bitBlastConstant_197,axiom,
    ~ b0000100(bitIndex5) ).

fof(bitBlastConstant_196,axiom,
    ~ b0000100(bitIndex4) ).

fof(bitBlastConstant_195,axiom,
    ~ b0000100(bitIndex3) ).

fof(bitBlastConstant_194,axiom,
    b0000100(bitIndex2) ).

fof(bitBlastConstant_193,axiom,
    ~ b0000100(bitIndex1) ).

fof(bitBlastConstant_192,axiom,
    ~ b0000100(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_152,axiom,
    ! [VarCurr] :
      ( v897(VarCurr)
    <=> ( v898(VarCurr)
        | v901(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_53,axiom,
    ! [VarCurr] :
      ( v901(VarCurr)
    <=> ( ( v770(VarCurr,bitIndex6)
        <=> $false )
        & ( v770(VarCurr,bitIndex5)
        <=> $false )
        & ( v770(VarCurr,bitIndex4)
        <=> $false )
        & ( v770(VarCurr,bitIndex3)
        <=> $false )
        & ( v770(VarCurr,bitIndex2)
        <=> $false )
        & ( v770(VarCurr,bitIndex1)
        <=> $true )
        & ( v770(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_191,axiom,
    ~ b0000010(bitIndex6) ).

fof(bitBlastConstant_190,axiom,
    ~ b0000010(bitIndex5) ).

fof(bitBlastConstant_189,axiom,
    ~ b0000010(bitIndex4) ).

fof(bitBlastConstant_188,axiom,
    ~ b0000010(bitIndex3) ).

fof(bitBlastConstant_187,axiom,
    ~ b0000010(bitIndex2) ).

fof(bitBlastConstant_186,axiom,
    b0000010(bitIndex1) ).

fof(bitBlastConstant_185,axiom,
    ~ b0000010(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_151,axiom,
    ! [VarCurr] :
      ( v898(VarCurr)
    <=> ( v899(VarCurr)
        | v900(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_52,axiom,
    ! [VarCurr] :
      ( v900(VarCurr)
    <=> ( ( v770(VarCurr,bitIndex6)
        <=> $false )
        & ( v770(VarCurr,bitIndex5)
        <=> $true )
        & ( v770(VarCurr,bitIndex4)
        <=> $false )
        & ( v770(VarCurr,bitIndex3)
        <=> $false )
        & ( v770(VarCurr,bitIndex2)
        <=> $false )
        & ( v770(VarCurr,bitIndex1)
        <=> $false )
        & ( v770(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_184,axiom,
    ~ b0100000(bitIndex6) ).

fof(bitBlastConstant_183,axiom,
    b0100000(bitIndex5) ).

fof(bitBlastConstant_182,axiom,
    ~ b0100000(bitIndex4) ).

fof(bitBlastConstant_181,axiom,
    ~ b0100000(bitIndex3) ).

fof(bitBlastConstant_180,axiom,
    ~ b0100000(bitIndex2) ).

fof(bitBlastConstant_179,axiom,
    ~ b0100000(bitIndex1) ).

fof(bitBlastConstant_178,axiom,
    ~ b0100000(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_51,axiom,
    ! [VarCurr] :
      ( v899(VarCurr)
    <=> ( ( v770(VarCurr,bitIndex6)
        <=> $false )
        & ( v770(VarCurr,bitIndex5)
        <=> $false )
        & ( v770(VarCurr,bitIndex4)
        <=> $false )
        & ( v770(VarCurr,bitIndex3)
        <=> $false )
        & ( v770(VarCurr,bitIndex2)
        <=> $false )
        & ( v770(VarCurr,bitIndex1)
        <=> $false )
        & ( v770(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_177,axiom,
    ~ b0000000(bitIndex6) ).

fof(bitBlastConstant_176,axiom,
    ~ b0000000(bitIndex5) ).

fof(bitBlastConstant_175,axiom,
    ~ b0000000(bitIndex4) ).

fof(bitBlastConstant_174,axiom,
    ~ b0000000(bitIndex3) ).

fof(bitBlastConstant_173,axiom,
    ~ b0000000(bitIndex2) ).

fof(bitBlastConstant_172,axiom,
    ~ b0000000(bitIndex1) ).

fof(bitBlastConstant_171,axiom,
    ~ b0000000(bitIndex0) ).

fof(addAssignment_293,axiom,
    ! [VarCurr] :
      ( ( v770(VarCurr,bitIndex6)
      <=> v90(VarCurr,bitIndex69) )
      & ( v770(VarCurr,bitIndex5)
      <=> v90(VarCurr,bitIndex68) )
      & ( v770(VarCurr,bitIndex4)
      <=> v90(VarCurr,bitIndex67) )
      & ( v770(VarCurr,bitIndex3)
      <=> v90(VarCurr,bitIndex66) )
      & ( v770(VarCurr,bitIndex2)
      <=> v90(VarCurr,bitIndex65) )
      & ( v770(VarCurr,bitIndex1)
      <=> v90(VarCurr,bitIndex64) )
      & ( v770(VarCurr,bitIndex0)
      <=> v90(VarCurr,bitIndex63) ) ) ).

fof(addAssignment_292,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v90(VarCurr,B)
      <=> v92(VarCurr,B) ) ) ).

fof(addAssignment_291,axiom,
    ! [VarCurr] :
      ( ( v92(VarCurr,bitIndex69)
      <=> v94(VarCurr,bitIndex559) )
      & ( v92(VarCurr,bitIndex68)
      <=> v94(VarCurr,bitIndex558) )
      & ( v92(VarCurr,bitIndex67)
      <=> v94(VarCurr,bitIndex557) )
      & ( v92(VarCurr,bitIndex66)
      <=> v94(VarCurr,bitIndex556) )
      & ( v92(VarCurr,bitIndex65)
      <=> v94(VarCurr,bitIndex555) )
      & ( v92(VarCurr,bitIndex64)
      <=> v94(VarCurr,bitIndex554) )
      & ( v92(VarCurr,bitIndex63)
      <=> v94(VarCurr,bitIndex553) ) ) ).

fof(addAssignment_290,axiom,
    ! [VarNext] :
      ( ( v94(VarNext,bitIndex559)
      <=> v866(VarNext,bitIndex69) )
      & ( v94(VarNext,bitIndex558)
      <=> v866(VarNext,bitIndex68) )
      & ( v94(VarNext,bitIndex557)
      <=> v866(VarNext,bitIndex67) )
      & ( v94(VarNext,bitIndex556)
      <=> v866(VarNext,bitIndex66) )
      & ( v94(VarNext,bitIndex555)
      <=> v866(VarNext,bitIndex65) )
      & ( v94(VarNext,bitIndex554)
      <=> v866(VarNext,bitIndex64) )
      & ( v94(VarNext,bitIndex553)
      <=> v866(VarNext,bitIndex63) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_16,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v868(VarNext)
       => ( ( v866(VarNext,bitIndex69)
          <=> v94(VarCurr,bitIndex559) )
          & ( v866(VarNext,bitIndex68)
          <=> v94(VarCurr,bitIndex558) )
          & ( v866(VarNext,bitIndex67)
          <=> v94(VarCurr,bitIndex557) )
          & ( v866(VarNext,bitIndex66)
          <=> v94(VarCurr,bitIndex556) )
          & ( v866(VarNext,bitIndex65)
          <=> v94(VarCurr,bitIndex555) )
          & ( v866(VarNext,bitIndex64)
          <=> v94(VarCurr,bitIndex554) )
          & ( v866(VarNext,bitIndex63)
          <=> v94(VarCurr,bitIndex553) )
          & ( v866(VarNext,bitIndex62)
          <=> v94(VarCurr,bitIndex552) )
          & ( v866(VarNext,bitIndex61)
          <=> v94(VarCurr,bitIndex551) )
          & ( v866(VarNext,bitIndex60)
          <=> v94(VarCurr,bitIndex550) )
          & ( v866(VarNext,bitIndex59)
          <=> v94(VarCurr,bitIndex549) )
          & ( v866(VarNext,bitIndex58)
          <=> v94(VarCurr,bitIndex548) )
          & ( v866(VarNext,bitIndex57)
          <=> v94(VarCurr,bitIndex547) )
          & ( v866(VarNext,bitIndex56)
          <=> v94(VarCurr,bitIndex546) )
          & ( v866(VarNext,bitIndex55)
          <=> v94(VarCurr,bitIndex545) )
          & ( v866(VarNext,bitIndex54)
          <=> v94(VarCurr,bitIndex544) )
          & ( v866(VarNext,bitIndex53)
          <=> v94(VarCurr,bitIndex543) )
          & ( v866(VarNext,bitIndex52)
          <=> v94(VarCurr,bitIndex542) )
          & ( v866(VarNext,bitIndex51)
          <=> v94(VarCurr,bitIndex541) )
          & ( v866(VarNext,bitIndex50)
          <=> v94(VarCurr,bitIndex540) )
          & ( v866(VarNext,bitIndex49)
          <=> v94(VarCurr,bitIndex539) )
          & ( v866(VarNext,bitIndex48)
          <=> v94(VarCurr,bitIndex538) )
          & ( v866(VarNext,bitIndex47)
          <=> v94(VarCurr,bitIndex537) )
          & ( v866(VarNext,bitIndex46)
          <=> v94(VarCurr,bitIndex536) )
          & ( v866(VarNext,bitIndex45)
          <=> v94(VarCurr,bitIndex535) )
          & ( v866(VarNext,bitIndex44)
          <=> v94(VarCurr,bitIndex534) )
          & ( v866(VarNext,bitIndex43)
          <=> v94(VarCurr,bitIndex533) )
          & ( v866(VarNext,bitIndex42)
          <=> v94(VarCurr,bitIndex532) )
          & ( v866(VarNext,bitIndex41)
          <=> v94(VarCurr,bitIndex531) )
          & ( v866(VarNext,bitIndex40)
          <=> v94(VarCurr,bitIndex530) )
          & ( v866(VarNext,bitIndex39)
          <=> v94(VarCurr,bitIndex529) )
          & ( v866(VarNext,bitIndex38)
          <=> v94(VarCurr,bitIndex528) )
          & ( v866(VarNext,bitIndex37)
          <=> v94(VarCurr,bitIndex527) )
          & ( v866(VarNext,bitIndex36)
          <=> v94(VarCurr,bitIndex526) )
          & ( v866(VarNext,bitIndex35)
          <=> v94(VarCurr,bitIndex525) )
          & ( v866(VarNext,bitIndex34)
          <=> v94(VarCurr,bitIndex524) )
          & ( v866(VarNext,bitIndex33)
          <=> v94(VarCurr,bitIndex523) )
          & ( v866(VarNext,bitIndex32)
          <=> v94(VarCurr,bitIndex522) )
          & ( v866(VarNext,bitIndex31)
          <=> v94(VarCurr,bitIndex521) )
          & ( v866(VarNext,bitIndex30)
          <=> v94(VarCurr,bitIndex520) )
          & ( v866(VarNext,bitIndex29)
          <=> v94(VarCurr,bitIndex519) )
          & ( v866(VarNext,bitIndex28)
          <=> v94(VarCurr,bitIndex518) )
          & ( v866(VarNext,bitIndex27)
          <=> v94(VarCurr,bitIndex517) )
          & ( v866(VarNext,bitIndex26)
          <=> v94(VarCurr,bitIndex516) )
          & ( v866(VarNext,bitIndex25)
          <=> v94(VarCurr,bitIndex515) )
          & ( v866(VarNext,bitIndex24)
          <=> v94(VarCurr,bitIndex514) )
          & ( v866(VarNext,bitIndex23)
          <=> v94(VarCurr,bitIndex513) )
          & ( v866(VarNext,bitIndex22)
          <=> v94(VarCurr,bitIndex512) )
          & ( v866(VarNext,bitIndex21)
          <=> v94(VarCurr,bitIndex511) )
          & ( v866(VarNext,bitIndex20)
          <=> v94(VarCurr,bitIndex510) )
          & ( v866(VarNext,bitIndex19)
          <=> v94(VarCurr,bitIndex509) )
          & ( v866(VarNext,bitIndex18)
          <=> v94(VarCurr,bitIndex508) )
          & ( v866(VarNext,bitIndex17)
          <=> v94(VarCurr,bitIndex507) )
          & ( v866(VarNext,bitIndex16)
          <=> v94(VarCurr,bitIndex506) )
          & ( v866(VarNext,bitIndex15)
          <=> v94(VarCurr,bitIndex505) )
          & ( v866(VarNext,bitIndex14)
          <=> v94(VarCurr,bitIndex504) )
          & ( v866(VarNext,bitIndex13)
          <=> v94(VarCurr,bitIndex503) )
          & ( v866(VarNext,bitIndex12)
          <=> v94(VarCurr,bitIndex502) )
          & ( v866(VarNext,bitIndex11)
          <=> v94(VarCurr,bitIndex501) )
          & ( v866(VarNext,bitIndex10)
          <=> v94(VarCurr,bitIndex500) )
          & ( v866(VarNext,bitIndex9)
          <=> v94(VarCurr,bitIndex499) )
          & ( v866(VarNext,bitIndex8)
          <=> v94(VarCurr,bitIndex498) )
          & ( v866(VarNext,bitIndex7)
          <=> v94(VarCurr,bitIndex497) )
          & ( v866(VarNext,bitIndex6)
          <=> v94(VarCurr,bitIndex496) )
          & ( v866(VarNext,bitIndex5)
          <=> v94(VarCurr,bitIndex495) )
          & ( v866(VarNext,bitIndex4)
          <=> v94(VarCurr,bitIndex494) )
          & ( v866(VarNext,bitIndex3)
          <=> v94(VarCurr,bitIndex493) )
          & ( v866(VarNext,bitIndex2)
          <=> v94(VarCurr,bitIndex492) )
          & ( v866(VarNext,bitIndex1)
          <=> v94(VarCurr,bitIndex491) )
          & ( v866(VarNext,bitIndex0)
          <=> v94(VarCurr,bitIndex490) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_36,axiom,
    ! [VarNext] :
      ( v868(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v866(VarNext,B)
          <=> v548(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_150,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v868(VarNext)
      <=> ( v869(VarNext)
          & v530(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_149,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v869(VarNext)
      <=> ( v871(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_64,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v871(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_289,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v514(VarCurr,B)
      <=> v519(VarCurr,B) ) ) ).

fof(addAssignment_288,axiom,
    ! [VarCurr] :
      ( ( v518(VarCurr,bitIndex69)
      <=> v94(VarCurr,bitIndex489) )
      & ( v518(VarCurr,bitIndex68)
      <=> v94(VarCurr,bitIndex488) )
      & ( v518(VarCurr,bitIndex67)
      <=> v94(VarCurr,bitIndex487) )
      & ( v518(VarCurr,bitIndex66)
      <=> v94(VarCurr,bitIndex486) )
      & ( v518(VarCurr,bitIndex65)
      <=> v94(VarCurr,bitIndex485) )
      & ( v518(VarCurr,bitIndex64)
      <=> v94(VarCurr,bitIndex484) )
      & ( v518(VarCurr,bitIndex63)
      <=> v94(VarCurr,bitIndex483) ) ) ).

fof(addAssignment_287,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v507(VarCurr,B)
      <=> v512(VarCurr,B) ) ) ).

fof(addAssignment_286,axiom,
    ! [VarCurr] :
      ( ( v511(VarCurr,bitIndex69)
      <=> v94(VarCurr,bitIndex559) )
      & ( v511(VarCurr,bitIndex68)
      <=> v94(VarCurr,bitIndex558) )
      & ( v511(VarCurr,bitIndex67)
      <=> v94(VarCurr,bitIndex557) )
      & ( v511(VarCurr,bitIndex66)
      <=> v94(VarCurr,bitIndex556) )
      & ( v511(VarCurr,bitIndex65)
      <=> v94(VarCurr,bitIndex555) )
      & ( v511(VarCurr,bitIndex64)
      <=> v94(VarCurr,bitIndex554) )
      & ( v511(VarCurr,bitIndex63)
      <=> v94(VarCurr,bitIndex553) ) ) ).

fof(addAssignment_285,axiom,
    ! [VarNext] :
      ( ( v94(VarNext,bitIndex489)
      <=> v858(VarNext,bitIndex69) )
      & ( v94(VarNext,bitIndex488)
      <=> v858(VarNext,bitIndex68) )
      & ( v94(VarNext,bitIndex487)
      <=> v858(VarNext,bitIndex67) )
      & ( v94(VarNext,bitIndex486)
      <=> v858(VarNext,bitIndex66) )
      & ( v94(VarNext,bitIndex485)
      <=> v858(VarNext,bitIndex65) )
      & ( v94(VarNext,bitIndex484)
      <=> v858(VarNext,bitIndex64) )
      & ( v94(VarNext,bitIndex483)
      <=> v858(VarNext,bitIndex63) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_15,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v860(VarNext)
       => ( ( v858(VarNext,bitIndex69)
          <=> v94(VarCurr,bitIndex489) )
          & ( v858(VarNext,bitIndex68)
          <=> v94(VarCurr,bitIndex488) )
          & ( v858(VarNext,bitIndex67)
          <=> v94(VarCurr,bitIndex487) )
          & ( v858(VarNext,bitIndex66)
          <=> v94(VarCurr,bitIndex486) )
          & ( v858(VarNext,bitIndex65)
          <=> v94(VarCurr,bitIndex485) )
          & ( v858(VarNext,bitIndex64)
          <=> v94(VarCurr,bitIndex484) )
          & ( v858(VarNext,bitIndex63)
          <=> v94(VarCurr,bitIndex483) )
          & ( v858(VarNext,bitIndex62)
          <=> v94(VarCurr,bitIndex482) )
          & ( v858(VarNext,bitIndex61)
          <=> v94(VarCurr,bitIndex481) )
          & ( v858(VarNext,bitIndex60)
          <=> v94(VarCurr,bitIndex480) )
          & ( v858(VarNext,bitIndex59)
          <=> v94(VarCurr,bitIndex479) )
          & ( v858(VarNext,bitIndex58)
          <=> v94(VarCurr,bitIndex478) )
          & ( v858(VarNext,bitIndex57)
          <=> v94(VarCurr,bitIndex477) )
          & ( v858(VarNext,bitIndex56)
          <=> v94(VarCurr,bitIndex476) )
          & ( v858(VarNext,bitIndex55)
          <=> v94(VarCurr,bitIndex475) )
          & ( v858(VarNext,bitIndex54)
          <=> v94(VarCurr,bitIndex474) )
          & ( v858(VarNext,bitIndex53)
          <=> v94(VarCurr,bitIndex473) )
          & ( v858(VarNext,bitIndex52)
          <=> v94(VarCurr,bitIndex472) )
          & ( v858(VarNext,bitIndex51)
          <=> v94(VarCurr,bitIndex471) )
          & ( v858(VarNext,bitIndex50)
          <=> v94(VarCurr,bitIndex470) )
          & ( v858(VarNext,bitIndex49)
          <=> v94(VarCurr,bitIndex469) )
          & ( v858(VarNext,bitIndex48)
          <=> v94(VarCurr,bitIndex468) )
          & ( v858(VarNext,bitIndex47)
          <=> v94(VarCurr,bitIndex467) )
          & ( v858(VarNext,bitIndex46)
          <=> v94(VarCurr,bitIndex466) )
          & ( v858(VarNext,bitIndex45)
          <=> v94(VarCurr,bitIndex465) )
          & ( v858(VarNext,bitIndex44)
          <=> v94(VarCurr,bitIndex464) )
          & ( v858(VarNext,bitIndex43)
          <=> v94(VarCurr,bitIndex463) )
          & ( v858(VarNext,bitIndex42)
          <=> v94(VarCurr,bitIndex462) )
          & ( v858(VarNext,bitIndex41)
          <=> v94(VarCurr,bitIndex461) )
          & ( v858(VarNext,bitIndex40)
          <=> v94(VarCurr,bitIndex460) )
          & ( v858(VarNext,bitIndex39)
          <=> v94(VarCurr,bitIndex459) )
          & ( v858(VarNext,bitIndex38)
          <=> v94(VarCurr,bitIndex458) )
          & ( v858(VarNext,bitIndex37)
          <=> v94(VarCurr,bitIndex457) )
          & ( v858(VarNext,bitIndex36)
          <=> v94(VarCurr,bitIndex456) )
          & ( v858(VarNext,bitIndex35)
          <=> v94(VarCurr,bitIndex455) )
          & ( v858(VarNext,bitIndex34)
          <=> v94(VarCurr,bitIndex454) )
          & ( v858(VarNext,bitIndex33)
          <=> v94(VarCurr,bitIndex453) )
          & ( v858(VarNext,bitIndex32)
          <=> v94(VarCurr,bitIndex452) )
          & ( v858(VarNext,bitIndex31)
          <=> v94(VarCurr,bitIndex451) )
          & ( v858(VarNext,bitIndex30)
          <=> v94(VarCurr,bitIndex450) )
          & ( v858(VarNext,bitIndex29)
          <=> v94(VarCurr,bitIndex449) )
          & ( v858(VarNext,bitIndex28)
          <=> v94(VarCurr,bitIndex448) )
          & ( v858(VarNext,bitIndex27)
          <=> v94(VarCurr,bitIndex447) )
          & ( v858(VarNext,bitIndex26)
          <=> v94(VarCurr,bitIndex446) )
          & ( v858(VarNext,bitIndex25)
          <=> v94(VarCurr,bitIndex445) )
          & ( v858(VarNext,bitIndex24)
          <=> v94(VarCurr,bitIndex444) )
          & ( v858(VarNext,bitIndex23)
          <=> v94(VarCurr,bitIndex443) )
          & ( v858(VarNext,bitIndex22)
          <=> v94(VarCurr,bitIndex442) )
          & ( v858(VarNext,bitIndex21)
          <=> v94(VarCurr,bitIndex441) )
          & ( v858(VarNext,bitIndex20)
          <=> v94(VarCurr,bitIndex440) )
          & ( v858(VarNext,bitIndex19)
          <=> v94(VarCurr,bitIndex439) )
          & ( v858(VarNext,bitIndex18)
          <=> v94(VarCurr,bitIndex438) )
          & ( v858(VarNext,bitIndex17)
          <=> v94(VarCurr,bitIndex437) )
          & ( v858(VarNext,bitIndex16)
          <=> v94(VarCurr,bitIndex436) )
          & ( v858(VarNext,bitIndex15)
          <=> v94(VarCurr,bitIndex435) )
          & ( v858(VarNext,bitIndex14)
          <=> v94(VarCurr,bitIndex434) )
          & ( v858(VarNext,bitIndex13)
          <=> v94(VarCurr,bitIndex433) )
          & ( v858(VarNext,bitIndex12)
          <=> v94(VarCurr,bitIndex432) )
          & ( v858(VarNext,bitIndex11)
          <=> v94(VarCurr,bitIndex431) )
          & ( v858(VarNext,bitIndex10)
          <=> v94(VarCurr,bitIndex430) )
          & ( v858(VarNext,bitIndex9)
          <=> v94(VarCurr,bitIndex429) )
          & ( v858(VarNext,bitIndex8)
          <=> v94(VarCurr,bitIndex428) )
          & ( v858(VarNext,bitIndex7)
          <=> v94(VarCurr,bitIndex427) )
          & ( v858(VarNext,bitIndex6)
          <=> v94(VarCurr,bitIndex426) )
          & ( v858(VarNext,bitIndex5)
          <=> v94(VarCurr,bitIndex425) )
          & ( v858(VarNext,bitIndex4)
          <=> v94(VarCurr,bitIndex424) )
          & ( v858(VarNext,bitIndex3)
          <=> v94(VarCurr,bitIndex423) )
          & ( v858(VarNext,bitIndex2)
          <=> v94(VarCurr,bitIndex422) )
          & ( v858(VarNext,bitIndex1)
          <=> v94(VarCurr,bitIndex421) )
          & ( v858(VarNext,bitIndex0)
          <=> v94(VarCurr,bitIndex420) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_35,axiom,
    ! [VarNext] :
      ( v860(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v858(VarNext,B)
          <=> v502(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_148,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v860(VarNext)
      <=> ( v861(VarNext)
          & v484(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_147,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v861(VarNext)
      <=> ( v863(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_63,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v863(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_284,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v468(VarCurr,B)
      <=> v473(VarCurr,B) ) ) ).

fof(addAssignment_283,axiom,
    ! [VarCurr] :
      ( ( v472(VarCurr,bitIndex69)
      <=> v94(VarCurr,bitIndex419) )
      & ( v472(VarCurr,bitIndex68)
      <=> v94(VarCurr,bitIndex418) )
      & ( v472(VarCurr,bitIndex67)
      <=> v94(VarCurr,bitIndex417) )
      & ( v472(VarCurr,bitIndex66)
      <=> v94(VarCurr,bitIndex416) )
      & ( v472(VarCurr,bitIndex65)
      <=> v94(VarCurr,bitIndex415) )
      & ( v472(VarCurr,bitIndex64)
      <=> v94(VarCurr,bitIndex414) )
      & ( v472(VarCurr,bitIndex63)
      <=> v94(VarCurr,bitIndex413) ) ) ).

fof(addAssignment_282,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v461(VarCurr,B)
      <=> v466(VarCurr,B) ) ) ).

fof(addAssignment_281,axiom,
    ! [VarCurr] :
      ( ( v465(VarCurr,bitIndex69)
      <=> v94(VarCurr,bitIndex489) )
      & ( v465(VarCurr,bitIndex68)
      <=> v94(VarCurr,bitIndex488) )
      & ( v465(VarCurr,bitIndex67)
      <=> v94(VarCurr,bitIndex487) )
      & ( v465(VarCurr,bitIndex66)
      <=> v94(VarCurr,bitIndex486) )
      & ( v465(VarCurr,bitIndex65)
      <=> v94(VarCurr,bitIndex485) )
      & ( v465(VarCurr,bitIndex64)
      <=> v94(VarCurr,bitIndex484) )
      & ( v465(VarCurr,bitIndex63)
      <=> v94(VarCurr,bitIndex483) ) ) ).

fof(addAssignment_280,axiom,
    ! [VarNext] :
      ( ( v94(VarNext,bitIndex419)
      <=> v850(VarNext,bitIndex69) )
      & ( v94(VarNext,bitIndex418)
      <=> v850(VarNext,bitIndex68) )
      & ( v94(VarNext,bitIndex417)
      <=> v850(VarNext,bitIndex67) )
      & ( v94(VarNext,bitIndex416)
      <=> v850(VarNext,bitIndex66) )
      & ( v94(VarNext,bitIndex415)
      <=> v850(VarNext,bitIndex65) )
      & ( v94(VarNext,bitIndex414)
      <=> v850(VarNext,bitIndex64) )
      & ( v94(VarNext,bitIndex413)
      <=> v850(VarNext,bitIndex63) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_14,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v852(VarNext)
       => ( ( v850(VarNext,bitIndex69)
          <=> v94(VarCurr,bitIndex419) )
          & ( v850(VarNext,bitIndex68)
          <=> v94(VarCurr,bitIndex418) )
          & ( v850(VarNext,bitIndex67)
          <=> v94(VarCurr,bitIndex417) )
          & ( v850(VarNext,bitIndex66)
          <=> v94(VarCurr,bitIndex416) )
          & ( v850(VarNext,bitIndex65)
          <=> v94(VarCurr,bitIndex415) )
          & ( v850(VarNext,bitIndex64)
          <=> v94(VarCurr,bitIndex414) )
          & ( v850(VarNext,bitIndex63)
          <=> v94(VarCurr,bitIndex413) )
          & ( v850(VarNext,bitIndex62)
          <=> v94(VarCurr,bitIndex412) )
          & ( v850(VarNext,bitIndex61)
          <=> v94(VarCurr,bitIndex411) )
          & ( v850(VarNext,bitIndex60)
          <=> v94(VarCurr,bitIndex410) )
          & ( v850(VarNext,bitIndex59)
          <=> v94(VarCurr,bitIndex409) )
          & ( v850(VarNext,bitIndex58)
          <=> v94(VarCurr,bitIndex408) )
          & ( v850(VarNext,bitIndex57)
          <=> v94(VarCurr,bitIndex407) )
          & ( v850(VarNext,bitIndex56)
          <=> v94(VarCurr,bitIndex406) )
          & ( v850(VarNext,bitIndex55)
          <=> v94(VarCurr,bitIndex405) )
          & ( v850(VarNext,bitIndex54)
          <=> v94(VarCurr,bitIndex404) )
          & ( v850(VarNext,bitIndex53)
          <=> v94(VarCurr,bitIndex403) )
          & ( v850(VarNext,bitIndex52)
          <=> v94(VarCurr,bitIndex402) )
          & ( v850(VarNext,bitIndex51)
          <=> v94(VarCurr,bitIndex401) )
          & ( v850(VarNext,bitIndex50)
          <=> v94(VarCurr,bitIndex400) )
          & ( v850(VarNext,bitIndex49)
          <=> v94(VarCurr,bitIndex399) )
          & ( v850(VarNext,bitIndex48)
          <=> v94(VarCurr,bitIndex398) )
          & ( v850(VarNext,bitIndex47)
          <=> v94(VarCurr,bitIndex397) )
          & ( v850(VarNext,bitIndex46)
          <=> v94(VarCurr,bitIndex396) )
          & ( v850(VarNext,bitIndex45)
          <=> v94(VarCurr,bitIndex395) )
          & ( v850(VarNext,bitIndex44)
          <=> v94(VarCurr,bitIndex394) )
          & ( v850(VarNext,bitIndex43)
          <=> v94(VarCurr,bitIndex393) )
          & ( v850(VarNext,bitIndex42)
          <=> v94(VarCurr,bitIndex392) )
          & ( v850(VarNext,bitIndex41)
          <=> v94(VarCurr,bitIndex391) )
          & ( v850(VarNext,bitIndex40)
          <=> v94(VarCurr,bitIndex390) )
          & ( v850(VarNext,bitIndex39)
          <=> v94(VarCurr,bitIndex389) )
          & ( v850(VarNext,bitIndex38)
          <=> v94(VarCurr,bitIndex388) )
          & ( v850(VarNext,bitIndex37)
          <=> v94(VarCurr,bitIndex387) )
          & ( v850(VarNext,bitIndex36)
          <=> v94(VarCurr,bitIndex386) )
          & ( v850(VarNext,bitIndex35)
          <=> v94(VarCurr,bitIndex385) )
          & ( v850(VarNext,bitIndex34)
          <=> v94(VarCurr,bitIndex384) )
          & ( v850(VarNext,bitIndex33)
          <=> v94(VarCurr,bitIndex383) )
          & ( v850(VarNext,bitIndex32)
          <=> v94(VarCurr,bitIndex382) )
          & ( v850(VarNext,bitIndex31)
          <=> v94(VarCurr,bitIndex381) )
          & ( v850(VarNext,bitIndex30)
          <=> v94(VarCurr,bitIndex380) )
          & ( v850(VarNext,bitIndex29)
          <=> v94(VarCurr,bitIndex379) )
          & ( v850(VarNext,bitIndex28)
          <=> v94(VarCurr,bitIndex378) )
          & ( v850(VarNext,bitIndex27)
          <=> v94(VarCurr,bitIndex377) )
          & ( v850(VarNext,bitIndex26)
          <=> v94(VarCurr,bitIndex376) )
          & ( v850(VarNext,bitIndex25)
          <=> v94(VarCurr,bitIndex375) )
          & ( v850(VarNext,bitIndex24)
          <=> v94(VarCurr,bitIndex374) )
          & ( v850(VarNext,bitIndex23)
          <=> v94(VarCurr,bitIndex373) )
          & ( v850(VarNext,bitIndex22)
          <=> v94(VarCurr,bitIndex372) )
          & ( v850(VarNext,bitIndex21)
          <=> v94(VarCurr,bitIndex371) )
          & ( v850(VarNext,bitIndex20)
          <=> v94(VarCurr,bitIndex370) )
          & ( v850(VarNext,bitIndex19)
          <=> v94(VarCurr,bitIndex369) )
          & ( v850(VarNext,bitIndex18)
          <=> v94(VarCurr,bitIndex368) )
          & ( v850(VarNext,bitIndex17)
          <=> v94(VarCurr,bitIndex367) )
          & ( v850(VarNext,bitIndex16)
          <=> v94(VarCurr,bitIndex366) )
          & ( v850(VarNext,bitIndex15)
          <=> v94(VarCurr,bitIndex365) )
          & ( v850(VarNext,bitIndex14)
          <=> v94(VarCurr,bitIndex364) )
          & ( v850(VarNext,bitIndex13)
          <=> v94(VarCurr,bitIndex363) )
          & ( v850(VarNext,bitIndex12)
          <=> v94(VarCurr,bitIndex362) )
          & ( v850(VarNext,bitIndex11)
          <=> v94(VarCurr,bitIndex361) )
          & ( v850(VarNext,bitIndex10)
          <=> v94(VarCurr,bitIndex360) )
          & ( v850(VarNext,bitIndex9)
          <=> v94(VarCurr,bitIndex359) )
          & ( v850(VarNext,bitIndex8)
          <=> v94(VarCurr,bitIndex358) )
          & ( v850(VarNext,bitIndex7)
          <=> v94(VarCurr,bitIndex357) )
          & ( v850(VarNext,bitIndex6)
          <=> v94(VarCurr,bitIndex356) )
          & ( v850(VarNext,bitIndex5)
          <=> v94(VarCurr,bitIndex355) )
          & ( v850(VarNext,bitIndex4)
          <=> v94(VarCurr,bitIndex354) )
          & ( v850(VarNext,bitIndex3)
          <=> v94(VarCurr,bitIndex353) )
          & ( v850(VarNext,bitIndex2)
          <=> v94(VarCurr,bitIndex352) )
          & ( v850(VarNext,bitIndex1)
          <=> v94(VarCurr,bitIndex351) )
          & ( v850(VarNext,bitIndex0)
          <=> v94(VarCurr,bitIndex350) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_34,axiom,
    ! [VarNext] :
      ( v852(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v850(VarNext,B)
          <=> v456(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_146,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v852(VarNext)
      <=> ( v853(VarNext)
          & v438(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_145,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v853(VarNext)
      <=> ( v855(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_62,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v855(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_279,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v422(VarCurr,B)
      <=> v427(VarCurr,B) ) ) ).

fof(addAssignment_278,axiom,
    ! [VarCurr] :
      ( ( v426(VarCurr,bitIndex69)
      <=> v94(VarCurr,bitIndex349) )
      & ( v426(VarCurr,bitIndex68)
      <=> v94(VarCurr,bitIndex348) )
      & ( v426(VarCurr,bitIndex67)
      <=> v94(VarCurr,bitIndex347) )
      & ( v426(VarCurr,bitIndex66)
      <=> v94(VarCurr,bitIndex346) )
      & ( v426(VarCurr,bitIndex65)
      <=> v94(VarCurr,bitIndex345) )
      & ( v426(VarCurr,bitIndex64)
      <=> v94(VarCurr,bitIndex344) )
      & ( v426(VarCurr,bitIndex63)
      <=> v94(VarCurr,bitIndex343) ) ) ).

fof(addAssignment_277,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v415(VarCurr,B)
      <=> v420(VarCurr,B) ) ) ).

fof(addAssignment_276,axiom,
    ! [VarCurr] :
      ( ( v419(VarCurr,bitIndex69)
      <=> v94(VarCurr,bitIndex419) )
      & ( v419(VarCurr,bitIndex68)
      <=> v94(VarCurr,bitIndex418) )
      & ( v419(VarCurr,bitIndex67)
      <=> v94(VarCurr,bitIndex417) )
      & ( v419(VarCurr,bitIndex66)
      <=> v94(VarCurr,bitIndex416) )
      & ( v419(VarCurr,bitIndex65)
      <=> v94(VarCurr,bitIndex415) )
      & ( v419(VarCurr,bitIndex64)
      <=> v94(VarCurr,bitIndex414) )
      & ( v419(VarCurr,bitIndex63)
      <=> v94(VarCurr,bitIndex413) ) ) ).

fof(addAssignment_275,axiom,
    ! [VarNext] :
      ( ( v94(VarNext,bitIndex349)
      <=> v842(VarNext,bitIndex69) )
      & ( v94(VarNext,bitIndex348)
      <=> v842(VarNext,bitIndex68) )
      & ( v94(VarNext,bitIndex347)
      <=> v842(VarNext,bitIndex67) )
      & ( v94(VarNext,bitIndex346)
      <=> v842(VarNext,bitIndex66) )
      & ( v94(VarNext,bitIndex345)
      <=> v842(VarNext,bitIndex65) )
      & ( v94(VarNext,bitIndex344)
      <=> v842(VarNext,bitIndex64) )
      & ( v94(VarNext,bitIndex343)
      <=> v842(VarNext,bitIndex63) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_13,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v844(VarNext)
       => ( ( v842(VarNext,bitIndex69)
          <=> v94(VarCurr,bitIndex349) )
          & ( v842(VarNext,bitIndex68)
          <=> v94(VarCurr,bitIndex348) )
          & ( v842(VarNext,bitIndex67)
          <=> v94(VarCurr,bitIndex347) )
          & ( v842(VarNext,bitIndex66)
          <=> v94(VarCurr,bitIndex346) )
          & ( v842(VarNext,bitIndex65)
          <=> v94(VarCurr,bitIndex345) )
          & ( v842(VarNext,bitIndex64)
          <=> v94(VarCurr,bitIndex344) )
          & ( v842(VarNext,bitIndex63)
          <=> v94(VarCurr,bitIndex343) )
          & ( v842(VarNext,bitIndex62)
          <=> v94(VarCurr,bitIndex342) )
          & ( v842(VarNext,bitIndex61)
          <=> v94(VarCurr,bitIndex341) )
          & ( v842(VarNext,bitIndex60)
          <=> v94(VarCurr,bitIndex340) )
          & ( v842(VarNext,bitIndex59)
          <=> v94(VarCurr,bitIndex339) )
          & ( v842(VarNext,bitIndex58)
          <=> v94(VarCurr,bitIndex338) )
          & ( v842(VarNext,bitIndex57)
          <=> v94(VarCurr,bitIndex337) )
          & ( v842(VarNext,bitIndex56)
          <=> v94(VarCurr,bitIndex336) )
          & ( v842(VarNext,bitIndex55)
          <=> v94(VarCurr,bitIndex335) )
          & ( v842(VarNext,bitIndex54)
          <=> v94(VarCurr,bitIndex334) )
          & ( v842(VarNext,bitIndex53)
          <=> v94(VarCurr,bitIndex333) )
          & ( v842(VarNext,bitIndex52)
          <=> v94(VarCurr,bitIndex332) )
          & ( v842(VarNext,bitIndex51)
          <=> v94(VarCurr,bitIndex331) )
          & ( v842(VarNext,bitIndex50)
          <=> v94(VarCurr,bitIndex330) )
          & ( v842(VarNext,bitIndex49)
          <=> v94(VarCurr,bitIndex329) )
          & ( v842(VarNext,bitIndex48)
          <=> v94(VarCurr,bitIndex328) )
          & ( v842(VarNext,bitIndex47)
          <=> v94(VarCurr,bitIndex327) )
          & ( v842(VarNext,bitIndex46)
          <=> v94(VarCurr,bitIndex326) )
          & ( v842(VarNext,bitIndex45)
          <=> v94(VarCurr,bitIndex325) )
          & ( v842(VarNext,bitIndex44)
          <=> v94(VarCurr,bitIndex324) )
          & ( v842(VarNext,bitIndex43)
          <=> v94(VarCurr,bitIndex323) )
          & ( v842(VarNext,bitIndex42)
          <=> v94(VarCurr,bitIndex322) )
          & ( v842(VarNext,bitIndex41)
          <=> v94(VarCurr,bitIndex321) )
          & ( v842(VarNext,bitIndex40)
          <=> v94(VarCurr,bitIndex320) )
          & ( v842(VarNext,bitIndex39)
          <=> v94(VarCurr,bitIndex319) )
          & ( v842(VarNext,bitIndex38)
          <=> v94(VarCurr,bitIndex318) )
          & ( v842(VarNext,bitIndex37)
          <=> v94(VarCurr,bitIndex317) )
          & ( v842(VarNext,bitIndex36)
          <=> v94(VarCurr,bitIndex316) )
          & ( v842(VarNext,bitIndex35)
          <=> v94(VarCurr,bitIndex315) )
          & ( v842(VarNext,bitIndex34)
          <=> v94(VarCurr,bitIndex314) )
          & ( v842(VarNext,bitIndex33)
          <=> v94(VarCurr,bitIndex313) )
          & ( v842(VarNext,bitIndex32)
          <=> v94(VarCurr,bitIndex312) )
          & ( v842(VarNext,bitIndex31)
          <=> v94(VarCurr,bitIndex311) )
          & ( v842(VarNext,bitIndex30)
          <=> v94(VarCurr,bitIndex310) )
          & ( v842(VarNext,bitIndex29)
          <=> v94(VarCurr,bitIndex309) )
          & ( v842(VarNext,bitIndex28)
          <=> v94(VarCurr,bitIndex308) )
          & ( v842(VarNext,bitIndex27)
          <=> v94(VarCurr,bitIndex307) )
          & ( v842(VarNext,bitIndex26)
          <=> v94(VarCurr,bitIndex306) )
          & ( v842(VarNext,bitIndex25)
          <=> v94(VarCurr,bitIndex305) )
          & ( v842(VarNext,bitIndex24)
          <=> v94(VarCurr,bitIndex304) )
          & ( v842(VarNext,bitIndex23)
          <=> v94(VarCurr,bitIndex303) )
          & ( v842(VarNext,bitIndex22)
          <=> v94(VarCurr,bitIndex302) )
          & ( v842(VarNext,bitIndex21)
          <=> v94(VarCurr,bitIndex301) )
          & ( v842(VarNext,bitIndex20)
          <=> v94(VarCurr,bitIndex300) )
          & ( v842(VarNext,bitIndex19)
          <=> v94(VarCurr,bitIndex299) )
          & ( v842(VarNext,bitIndex18)
          <=> v94(VarCurr,bitIndex298) )
          & ( v842(VarNext,bitIndex17)
          <=> v94(VarCurr,bitIndex297) )
          & ( v842(VarNext,bitIndex16)
          <=> v94(VarCurr,bitIndex296) )
          & ( v842(VarNext,bitIndex15)
          <=> v94(VarCurr,bitIndex295) )
          & ( v842(VarNext,bitIndex14)
          <=> v94(VarCurr,bitIndex294) )
          & ( v842(VarNext,bitIndex13)
          <=> v94(VarCurr,bitIndex293) )
          & ( v842(VarNext,bitIndex12)
          <=> v94(VarCurr,bitIndex292) )
          & ( v842(VarNext,bitIndex11)
          <=> v94(VarCurr,bitIndex291) )
          & ( v842(VarNext,bitIndex10)
          <=> v94(VarCurr,bitIndex290) )
          & ( v842(VarNext,bitIndex9)
          <=> v94(VarCurr,bitIndex289) )
          & ( v842(VarNext,bitIndex8)
          <=> v94(VarCurr,bitIndex288) )
          & ( v842(VarNext,bitIndex7)
          <=> v94(VarCurr,bitIndex287) )
          & ( v842(VarNext,bitIndex6)
          <=> v94(VarCurr,bitIndex286) )
          & ( v842(VarNext,bitIndex5)
          <=> v94(VarCurr,bitIndex285) )
          & ( v842(VarNext,bitIndex4)
          <=> v94(VarCurr,bitIndex284) )
          & ( v842(VarNext,bitIndex3)
          <=> v94(VarCurr,bitIndex283) )
          & ( v842(VarNext,bitIndex2)
          <=> v94(VarCurr,bitIndex282) )
          & ( v842(VarNext,bitIndex1)
          <=> v94(VarCurr,bitIndex281) )
          & ( v842(VarNext,bitIndex0)
          <=> v94(VarCurr,bitIndex280) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_33,axiom,
    ! [VarNext] :
      ( v844(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v842(VarNext,B)
          <=> v410(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_144,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v844(VarNext)
      <=> ( v845(VarNext)
          & v392(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_143,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v845(VarNext)
      <=> ( v847(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_61,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v847(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_274,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v376(VarCurr,B)
      <=> v381(VarCurr,B) ) ) ).

fof(addAssignment_273,axiom,
    ! [VarCurr] :
      ( ( v380(VarCurr,bitIndex69)
      <=> v94(VarCurr,bitIndex279) )
      & ( v380(VarCurr,bitIndex68)
      <=> v94(VarCurr,bitIndex278) )
      & ( v380(VarCurr,bitIndex67)
      <=> v94(VarCurr,bitIndex277) )
      & ( v380(VarCurr,bitIndex66)
      <=> v94(VarCurr,bitIndex276) )
      & ( v380(VarCurr,bitIndex65)
      <=> v94(VarCurr,bitIndex275) )
      & ( v380(VarCurr,bitIndex64)
      <=> v94(VarCurr,bitIndex274) )
      & ( v380(VarCurr,bitIndex63)
      <=> v94(VarCurr,bitIndex273) ) ) ).

fof(addAssignment_272,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v369(VarCurr,B)
      <=> v374(VarCurr,B) ) ) ).

fof(addAssignment_271,axiom,
    ! [VarCurr] :
      ( ( v373(VarCurr,bitIndex69)
      <=> v94(VarCurr,bitIndex349) )
      & ( v373(VarCurr,bitIndex68)
      <=> v94(VarCurr,bitIndex348) )
      & ( v373(VarCurr,bitIndex67)
      <=> v94(VarCurr,bitIndex347) )
      & ( v373(VarCurr,bitIndex66)
      <=> v94(VarCurr,bitIndex346) )
      & ( v373(VarCurr,bitIndex65)
      <=> v94(VarCurr,bitIndex345) )
      & ( v373(VarCurr,bitIndex64)
      <=> v94(VarCurr,bitIndex344) )
      & ( v373(VarCurr,bitIndex63)
      <=> v94(VarCurr,bitIndex343) ) ) ).

fof(addAssignment_270,axiom,
    ! [VarNext] :
      ( ( v94(VarNext,bitIndex279)
      <=> v834(VarNext,bitIndex69) )
      & ( v94(VarNext,bitIndex278)
      <=> v834(VarNext,bitIndex68) )
      & ( v94(VarNext,bitIndex277)
      <=> v834(VarNext,bitIndex67) )
      & ( v94(VarNext,bitIndex276)
      <=> v834(VarNext,bitIndex66) )
      & ( v94(VarNext,bitIndex275)
      <=> v834(VarNext,bitIndex65) )
      & ( v94(VarNext,bitIndex274)
      <=> v834(VarNext,bitIndex64) )
      & ( v94(VarNext,bitIndex273)
      <=> v834(VarNext,bitIndex63) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_12,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v836(VarNext)
       => ( ( v834(VarNext,bitIndex69)
          <=> v94(VarCurr,bitIndex279) )
          & ( v834(VarNext,bitIndex68)
          <=> v94(VarCurr,bitIndex278) )
          & ( v834(VarNext,bitIndex67)
          <=> v94(VarCurr,bitIndex277) )
          & ( v834(VarNext,bitIndex66)
          <=> v94(VarCurr,bitIndex276) )
          & ( v834(VarNext,bitIndex65)
          <=> v94(VarCurr,bitIndex275) )
          & ( v834(VarNext,bitIndex64)
          <=> v94(VarCurr,bitIndex274) )
          & ( v834(VarNext,bitIndex63)
          <=> v94(VarCurr,bitIndex273) )
          & ( v834(VarNext,bitIndex62)
          <=> v94(VarCurr,bitIndex272) )
          & ( v834(VarNext,bitIndex61)
          <=> v94(VarCurr,bitIndex271) )
          & ( v834(VarNext,bitIndex60)
          <=> v94(VarCurr,bitIndex270) )
          & ( v834(VarNext,bitIndex59)
          <=> v94(VarCurr,bitIndex269) )
          & ( v834(VarNext,bitIndex58)
          <=> v94(VarCurr,bitIndex268) )
          & ( v834(VarNext,bitIndex57)
          <=> v94(VarCurr,bitIndex267) )
          & ( v834(VarNext,bitIndex56)
          <=> v94(VarCurr,bitIndex266) )
          & ( v834(VarNext,bitIndex55)
          <=> v94(VarCurr,bitIndex265) )
          & ( v834(VarNext,bitIndex54)
          <=> v94(VarCurr,bitIndex264) )
          & ( v834(VarNext,bitIndex53)
          <=> v94(VarCurr,bitIndex263) )
          & ( v834(VarNext,bitIndex52)
          <=> v94(VarCurr,bitIndex262) )
          & ( v834(VarNext,bitIndex51)
          <=> v94(VarCurr,bitIndex261) )
          & ( v834(VarNext,bitIndex50)
          <=> v94(VarCurr,bitIndex260) )
          & ( v834(VarNext,bitIndex49)
          <=> v94(VarCurr,bitIndex259) )
          & ( v834(VarNext,bitIndex48)
          <=> v94(VarCurr,bitIndex258) )
          & ( v834(VarNext,bitIndex47)
          <=> v94(VarCurr,bitIndex257) )
          & ( v834(VarNext,bitIndex46)
          <=> v94(VarCurr,bitIndex256) )
          & ( v834(VarNext,bitIndex45)
          <=> v94(VarCurr,bitIndex255) )
          & ( v834(VarNext,bitIndex44)
          <=> v94(VarCurr,bitIndex254) )
          & ( v834(VarNext,bitIndex43)
          <=> v94(VarCurr,bitIndex253) )
          & ( v834(VarNext,bitIndex42)
          <=> v94(VarCurr,bitIndex252) )
          & ( v834(VarNext,bitIndex41)
          <=> v94(VarCurr,bitIndex251) )
          & ( v834(VarNext,bitIndex40)
          <=> v94(VarCurr,bitIndex250) )
          & ( v834(VarNext,bitIndex39)
          <=> v94(VarCurr,bitIndex249) )
          & ( v834(VarNext,bitIndex38)
          <=> v94(VarCurr,bitIndex248) )
          & ( v834(VarNext,bitIndex37)
          <=> v94(VarCurr,bitIndex247) )
          & ( v834(VarNext,bitIndex36)
          <=> v94(VarCurr,bitIndex246) )
          & ( v834(VarNext,bitIndex35)
          <=> v94(VarCurr,bitIndex245) )
          & ( v834(VarNext,bitIndex34)
          <=> v94(VarCurr,bitIndex244) )
          & ( v834(VarNext,bitIndex33)
          <=> v94(VarCurr,bitIndex243) )
          & ( v834(VarNext,bitIndex32)
          <=> v94(VarCurr,bitIndex242) )
          & ( v834(VarNext,bitIndex31)
          <=> v94(VarCurr,bitIndex241) )
          & ( v834(VarNext,bitIndex30)
          <=> v94(VarCurr,bitIndex240) )
          & ( v834(VarNext,bitIndex29)
          <=> v94(VarCurr,bitIndex239) )
          & ( v834(VarNext,bitIndex28)
          <=> v94(VarCurr,bitIndex238) )
          & ( v834(VarNext,bitIndex27)
          <=> v94(VarCurr,bitIndex237) )
          & ( v834(VarNext,bitIndex26)
          <=> v94(VarCurr,bitIndex236) )
          & ( v834(VarNext,bitIndex25)
          <=> v94(VarCurr,bitIndex235) )
          & ( v834(VarNext,bitIndex24)
          <=> v94(VarCurr,bitIndex234) )
          & ( v834(VarNext,bitIndex23)
          <=> v94(VarCurr,bitIndex233) )
          & ( v834(VarNext,bitIndex22)
          <=> v94(VarCurr,bitIndex232) )
          & ( v834(VarNext,bitIndex21)
          <=> v94(VarCurr,bitIndex231) )
          & ( v834(VarNext,bitIndex20)
          <=> v94(VarCurr,bitIndex230) )
          & ( v834(VarNext,bitIndex19)
          <=> v94(VarCurr,bitIndex229) )
          & ( v834(VarNext,bitIndex18)
          <=> v94(VarCurr,bitIndex228) )
          & ( v834(VarNext,bitIndex17)
          <=> v94(VarCurr,bitIndex227) )
          & ( v834(VarNext,bitIndex16)
          <=> v94(VarCurr,bitIndex226) )
          & ( v834(VarNext,bitIndex15)
          <=> v94(VarCurr,bitIndex225) )
          & ( v834(VarNext,bitIndex14)
          <=> v94(VarCurr,bitIndex224) )
          & ( v834(VarNext,bitIndex13)
          <=> v94(VarCurr,bitIndex223) )
          & ( v834(VarNext,bitIndex12)
          <=> v94(VarCurr,bitIndex222) )
          & ( v834(VarNext,bitIndex11)
          <=> v94(VarCurr,bitIndex221) )
          & ( v834(VarNext,bitIndex10)
          <=> v94(VarCurr,bitIndex220) )
          & ( v834(VarNext,bitIndex9)
          <=> v94(VarCurr,bitIndex219) )
          & ( v834(VarNext,bitIndex8)
          <=> v94(VarCurr,bitIndex218) )
          & ( v834(VarNext,bitIndex7)
          <=> v94(VarCurr,bitIndex217) )
          & ( v834(VarNext,bitIndex6)
          <=> v94(VarCurr,bitIndex216) )
          & ( v834(VarNext,bitIndex5)
          <=> v94(VarCurr,bitIndex215) )
          & ( v834(VarNext,bitIndex4)
          <=> v94(VarCurr,bitIndex214) )
          & ( v834(VarNext,bitIndex3)
          <=> v94(VarCurr,bitIndex213) )
          & ( v834(VarNext,bitIndex2)
          <=> v94(VarCurr,bitIndex212) )
          & ( v834(VarNext,bitIndex1)
          <=> v94(VarCurr,bitIndex211) )
          & ( v834(VarNext,bitIndex0)
          <=> v94(VarCurr,bitIndex210) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_32,axiom,
    ! [VarNext] :
      ( v836(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v834(VarNext,B)
          <=> v364(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_142,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v836(VarNext)
      <=> ( v837(VarNext)
          & v346(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_141,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v837(VarNext)
      <=> ( v839(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_60,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v839(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_269,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v330(VarCurr,B)
      <=> v335(VarCurr,B) ) ) ).

fof(addAssignment_268,axiom,
    ! [VarCurr] :
      ( ( v334(VarCurr,bitIndex69)
      <=> v94(VarCurr,bitIndex209) )
      & ( v334(VarCurr,bitIndex68)
      <=> v94(VarCurr,bitIndex208) )
      & ( v334(VarCurr,bitIndex67)
      <=> v94(VarCurr,bitIndex207) )
      & ( v334(VarCurr,bitIndex66)
      <=> v94(VarCurr,bitIndex206) )
      & ( v334(VarCurr,bitIndex65)
      <=> v94(VarCurr,bitIndex205) )
      & ( v334(VarCurr,bitIndex64)
      <=> v94(VarCurr,bitIndex204) )
      & ( v334(VarCurr,bitIndex63)
      <=> v94(VarCurr,bitIndex203) ) ) ).

fof(addAssignment_267,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v323(VarCurr,B)
      <=> v328(VarCurr,B) ) ) ).

fof(addAssignment_266,axiom,
    ! [VarCurr] :
      ( ( v327(VarCurr,bitIndex69)
      <=> v94(VarCurr,bitIndex279) )
      & ( v327(VarCurr,bitIndex68)
      <=> v94(VarCurr,bitIndex278) )
      & ( v327(VarCurr,bitIndex67)
      <=> v94(VarCurr,bitIndex277) )
      & ( v327(VarCurr,bitIndex66)
      <=> v94(VarCurr,bitIndex276) )
      & ( v327(VarCurr,bitIndex65)
      <=> v94(VarCurr,bitIndex275) )
      & ( v327(VarCurr,bitIndex64)
      <=> v94(VarCurr,bitIndex274) )
      & ( v327(VarCurr,bitIndex63)
      <=> v94(VarCurr,bitIndex273) ) ) ).

fof(addAssignment_265,axiom,
    ! [VarNext] :
      ( ( v94(VarNext,bitIndex209)
      <=> v826(VarNext,bitIndex69) )
      & ( v94(VarNext,bitIndex208)
      <=> v826(VarNext,bitIndex68) )
      & ( v94(VarNext,bitIndex207)
      <=> v826(VarNext,bitIndex67) )
      & ( v94(VarNext,bitIndex206)
      <=> v826(VarNext,bitIndex66) )
      & ( v94(VarNext,bitIndex205)
      <=> v826(VarNext,bitIndex65) )
      & ( v94(VarNext,bitIndex204)
      <=> v826(VarNext,bitIndex64) )
      & ( v94(VarNext,bitIndex203)
      <=> v826(VarNext,bitIndex63) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_11,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v828(VarNext)
       => ( ( v826(VarNext,bitIndex69)
          <=> v94(VarCurr,bitIndex209) )
          & ( v826(VarNext,bitIndex68)
          <=> v94(VarCurr,bitIndex208) )
          & ( v826(VarNext,bitIndex67)
          <=> v94(VarCurr,bitIndex207) )
          & ( v826(VarNext,bitIndex66)
          <=> v94(VarCurr,bitIndex206) )
          & ( v826(VarNext,bitIndex65)
          <=> v94(VarCurr,bitIndex205) )
          & ( v826(VarNext,bitIndex64)
          <=> v94(VarCurr,bitIndex204) )
          & ( v826(VarNext,bitIndex63)
          <=> v94(VarCurr,bitIndex203) )
          & ( v826(VarNext,bitIndex62)
          <=> v94(VarCurr,bitIndex202) )
          & ( v826(VarNext,bitIndex61)
          <=> v94(VarCurr,bitIndex201) )
          & ( v826(VarNext,bitIndex60)
          <=> v94(VarCurr,bitIndex200) )
          & ( v826(VarNext,bitIndex59)
          <=> v94(VarCurr,bitIndex199) )
          & ( v826(VarNext,bitIndex58)
          <=> v94(VarCurr,bitIndex198) )
          & ( v826(VarNext,bitIndex57)
          <=> v94(VarCurr,bitIndex197) )
          & ( v826(VarNext,bitIndex56)
          <=> v94(VarCurr,bitIndex196) )
          & ( v826(VarNext,bitIndex55)
          <=> v94(VarCurr,bitIndex195) )
          & ( v826(VarNext,bitIndex54)
          <=> v94(VarCurr,bitIndex194) )
          & ( v826(VarNext,bitIndex53)
          <=> v94(VarCurr,bitIndex193) )
          & ( v826(VarNext,bitIndex52)
          <=> v94(VarCurr,bitIndex192) )
          & ( v826(VarNext,bitIndex51)
          <=> v94(VarCurr,bitIndex191) )
          & ( v826(VarNext,bitIndex50)
          <=> v94(VarCurr,bitIndex190) )
          & ( v826(VarNext,bitIndex49)
          <=> v94(VarCurr,bitIndex189) )
          & ( v826(VarNext,bitIndex48)
          <=> v94(VarCurr,bitIndex188) )
          & ( v826(VarNext,bitIndex47)
          <=> v94(VarCurr,bitIndex187) )
          & ( v826(VarNext,bitIndex46)
          <=> v94(VarCurr,bitIndex186) )
          & ( v826(VarNext,bitIndex45)
          <=> v94(VarCurr,bitIndex185) )
          & ( v826(VarNext,bitIndex44)
          <=> v94(VarCurr,bitIndex184) )
          & ( v826(VarNext,bitIndex43)
          <=> v94(VarCurr,bitIndex183) )
          & ( v826(VarNext,bitIndex42)
          <=> v94(VarCurr,bitIndex182) )
          & ( v826(VarNext,bitIndex41)
          <=> v94(VarCurr,bitIndex181) )
          & ( v826(VarNext,bitIndex40)
          <=> v94(VarCurr,bitIndex180) )
          & ( v826(VarNext,bitIndex39)
          <=> v94(VarCurr,bitIndex179) )
          & ( v826(VarNext,bitIndex38)
          <=> v94(VarCurr,bitIndex178) )
          & ( v826(VarNext,bitIndex37)
          <=> v94(VarCurr,bitIndex177) )
          & ( v826(VarNext,bitIndex36)
          <=> v94(VarCurr,bitIndex176) )
          & ( v826(VarNext,bitIndex35)
          <=> v94(VarCurr,bitIndex175) )
          & ( v826(VarNext,bitIndex34)
          <=> v94(VarCurr,bitIndex174) )
          & ( v826(VarNext,bitIndex33)
          <=> v94(VarCurr,bitIndex173) )
          & ( v826(VarNext,bitIndex32)
          <=> v94(VarCurr,bitIndex172) )
          & ( v826(VarNext,bitIndex31)
          <=> v94(VarCurr,bitIndex171) )
          & ( v826(VarNext,bitIndex30)
          <=> v94(VarCurr,bitIndex170) )
          & ( v826(VarNext,bitIndex29)
          <=> v94(VarCurr,bitIndex169) )
          & ( v826(VarNext,bitIndex28)
          <=> v94(VarCurr,bitIndex168) )
          & ( v826(VarNext,bitIndex27)
          <=> v94(VarCurr,bitIndex167) )
          & ( v826(VarNext,bitIndex26)
          <=> v94(VarCurr,bitIndex166) )
          & ( v826(VarNext,bitIndex25)
          <=> v94(VarCurr,bitIndex165) )
          & ( v826(VarNext,bitIndex24)
          <=> v94(VarCurr,bitIndex164) )
          & ( v826(VarNext,bitIndex23)
          <=> v94(VarCurr,bitIndex163) )
          & ( v826(VarNext,bitIndex22)
          <=> v94(VarCurr,bitIndex162) )
          & ( v826(VarNext,bitIndex21)
          <=> v94(VarCurr,bitIndex161) )
          & ( v826(VarNext,bitIndex20)
          <=> v94(VarCurr,bitIndex160) )
          & ( v826(VarNext,bitIndex19)
          <=> v94(VarCurr,bitIndex159) )
          & ( v826(VarNext,bitIndex18)
          <=> v94(VarCurr,bitIndex158) )
          & ( v826(VarNext,bitIndex17)
          <=> v94(VarCurr,bitIndex157) )
          & ( v826(VarNext,bitIndex16)
          <=> v94(VarCurr,bitIndex156) )
          & ( v826(VarNext,bitIndex15)
          <=> v94(VarCurr,bitIndex155) )
          & ( v826(VarNext,bitIndex14)
          <=> v94(VarCurr,bitIndex154) )
          & ( v826(VarNext,bitIndex13)
          <=> v94(VarCurr,bitIndex153) )
          & ( v826(VarNext,bitIndex12)
          <=> v94(VarCurr,bitIndex152) )
          & ( v826(VarNext,bitIndex11)
          <=> v94(VarCurr,bitIndex151) )
          & ( v826(VarNext,bitIndex10)
          <=> v94(VarCurr,bitIndex150) )
          & ( v826(VarNext,bitIndex9)
          <=> v94(VarCurr,bitIndex149) )
          & ( v826(VarNext,bitIndex8)
          <=> v94(VarCurr,bitIndex148) )
          & ( v826(VarNext,bitIndex7)
          <=> v94(VarCurr,bitIndex147) )
          & ( v826(VarNext,bitIndex6)
          <=> v94(VarCurr,bitIndex146) )
          & ( v826(VarNext,bitIndex5)
          <=> v94(VarCurr,bitIndex145) )
          & ( v826(VarNext,bitIndex4)
          <=> v94(VarCurr,bitIndex144) )
          & ( v826(VarNext,bitIndex3)
          <=> v94(VarCurr,bitIndex143) )
          & ( v826(VarNext,bitIndex2)
          <=> v94(VarCurr,bitIndex142) )
          & ( v826(VarNext,bitIndex1)
          <=> v94(VarCurr,bitIndex141) )
          & ( v826(VarNext,bitIndex0)
          <=> v94(VarCurr,bitIndex140) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_31,axiom,
    ! [VarNext] :
      ( v828(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v826(VarNext,B)
          <=> v318(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_140,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v828(VarNext)
      <=> ( v829(VarNext)
          & v300(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_139,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v829(VarNext)
      <=> ( v831(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_59,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v831(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_264,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v284(VarCurr,B)
      <=> v289(VarCurr,B) ) ) ).

fof(addAssignment_263,axiom,
    ! [VarCurr] :
      ( ( v288(VarCurr,bitIndex69)
      <=> v94(VarCurr,bitIndex139) )
      & ( v288(VarCurr,bitIndex68)
      <=> v94(VarCurr,bitIndex138) )
      & ( v288(VarCurr,bitIndex67)
      <=> v94(VarCurr,bitIndex137) )
      & ( v288(VarCurr,bitIndex66)
      <=> v94(VarCurr,bitIndex136) )
      & ( v288(VarCurr,bitIndex65)
      <=> v94(VarCurr,bitIndex135) )
      & ( v288(VarCurr,bitIndex64)
      <=> v94(VarCurr,bitIndex134) )
      & ( v288(VarCurr,bitIndex63)
      <=> v94(VarCurr,bitIndex133) ) ) ).

fof(addAssignment_262,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v277(VarCurr,B)
      <=> v282(VarCurr,B) ) ) ).

fof(addAssignment_261,axiom,
    ! [VarCurr] :
      ( ( v281(VarCurr,bitIndex69)
      <=> v94(VarCurr,bitIndex209) )
      & ( v281(VarCurr,bitIndex68)
      <=> v94(VarCurr,bitIndex208) )
      & ( v281(VarCurr,bitIndex67)
      <=> v94(VarCurr,bitIndex207) )
      & ( v281(VarCurr,bitIndex66)
      <=> v94(VarCurr,bitIndex206) )
      & ( v281(VarCurr,bitIndex65)
      <=> v94(VarCurr,bitIndex205) )
      & ( v281(VarCurr,bitIndex64)
      <=> v94(VarCurr,bitIndex204) )
      & ( v281(VarCurr,bitIndex63)
      <=> v94(VarCurr,bitIndex203) ) ) ).

fof(addAssignment_260,axiom,
    ! [VarNext] :
      ( ( v94(VarNext,bitIndex139)
      <=> v818(VarNext,bitIndex69) )
      & ( v94(VarNext,bitIndex138)
      <=> v818(VarNext,bitIndex68) )
      & ( v94(VarNext,bitIndex137)
      <=> v818(VarNext,bitIndex67) )
      & ( v94(VarNext,bitIndex136)
      <=> v818(VarNext,bitIndex66) )
      & ( v94(VarNext,bitIndex135)
      <=> v818(VarNext,bitIndex65) )
      & ( v94(VarNext,bitIndex134)
      <=> v818(VarNext,bitIndex64) )
      & ( v94(VarNext,bitIndex133)
      <=> v818(VarNext,bitIndex63) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_10,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v820(VarNext)
       => ( ( v818(VarNext,bitIndex69)
          <=> v94(VarCurr,bitIndex139) )
          & ( v818(VarNext,bitIndex68)
          <=> v94(VarCurr,bitIndex138) )
          & ( v818(VarNext,bitIndex67)
          <=> v94(VarCurr,bitIndex137) )
          & ( v818(VarNext,bitIndex66)
          <=> v94(VarCurr,bitIndex136) )
          & ( v818(VarNext,bitIndex65)
          <=> v94(VarCurr,bitIndex135) )
          & ( v818(VarNext,bitIndex64)
          <=> v94(VarCurr,bitIndex134) )
          & ( v818(VarNext,bitIndex63)
          <=> v94(VarCurr,bitIndex133) )
          & ( v818(VarNext,bitIndex62)
          <=> v94(VarCurr,bitIndex132) )
          & ( v818(VarNext,bitIndex61)
          <=> v94(VarCurr,bitIndex131) )
          & ( v818(VarNext,bitIndex60)
          <=> v94(VarCurr,bitIndex130) )
          & ( v818(VarNext,bitIndex59)
          <=> v94(VarCurr,bitIndex129) )
          & ( v818(VarNext,bitIndex58)
          <=> v94(VarCurr,bitIndex128) )
          & ( v818(VarNext,bitIndex57)
          <=> v94(VarCurr,bitIndex127) )
          & ( v818(VarNext,bitIndex56)
          <=> v94(VarCurr,bitIndex126) )
          & ( v818(VarNext,bitIndex55)
          <=> v94(VarCurr,bitIndex125) )
          & ( v818(VarNext,bitIndex54)
          <=> v94(VarCurr,bitIndex124) )
          & ( v818(VarNext,bitIndex53)
          <=> v94(VarCurr,bitIndex123) )
          & ( v818(VarNext,bitIndex52)
          <=> v94(VarCurr,bitIndex122) )
          & ( v818(VarNext,bitIndex51)
          <=> v94(VarCurr,bitIndex121) )
          & ( v818(VarNext,bitIndex50)
          <=> v94(VarCurr,bitIndex120) )
          & ( v818(VarNext,bitIndex49)
          <=> v94(VarCurr,bitIndex119) )
          & ( v818(VarNext,bitIndex48)
          <=> v94(VarCurr,bitIndex118) )
          & ( v818(VarNext,bitIndex47)
          <=> v94(VarCurr,bitIndex117) )
          & ( v818(VarNext,bitIndex46)
          <=> v94(VarCurr,bitIndex116) )
          & ( v818(VarNext,bitIndex45)
          <=> v94(VarCurr,bitIndex115) )
          & ( v818(VarNext,bitIndex44)
          <=> v94(VarCurr,bitIndex114) )
          & ( v818(VarNext,bitIndex43)
          <=> v94(VarCurr,bitIndex113) )
          & ( v818(VarNext,bitIndex42)
          <=> v94(VarCurr,bitIndex112) )
          & ( v818(VarNext,bitIndex41)
          <=> v94(VarCurr,bitIndex111) )
          & ( v818(VarNext,bitIndex40)
          <=> v94(VarCurr,bitIndex110) )
          & ( v818(VarNext,bitIndex39)
          <=> v94(VarCurr,bitIndex109) )
          & ( v818(VarNext,bitIndex38)
          <=> v94(VarCurr,bitIndex108) )
          & ( v818(VarNext,bitIndex37)
          <=> v94(VarCurr,bitIndex107) )
          & ( v818(VarNext,bitIndex36)
          <=> v94(VarCurr,bitIndex106) )
          & ( v818(VarNext,bitIndex35)
          <=> v94(VarCurr,bitIndex105) )
          & ( v818(VarNext,bitIndex34)
          <=> v94(VarCurr,bitIndex104) )
          & ( v818(VarNext,bitIndex33)
          <=> v94(VarCurr,bitIndex103) )
          & ( v818(VarNext,bitIndex32)
          <=> v94(VarCurr,bitIndex102) )
          & ( v818(VarNext,bitIndex31)
          <=> v94(VarCurr,bitIndex101) )
          & ( v818(VarNext,bitIndex30)
          <=> v94(VarCurr,bitIndex100) )
          & ( v818(VarNext,bitIndex29)
          <=> v94(VarCurr,bitIndex99) )
          & ( v818(VarNext,bitIndex28)
          <=> v94(VarCurr,bitIndex98) )
          & ( v818(VarNext,bitIndex27)
          <=> v94(VarCurr,bitIndex97) )
          & ( v818(VarNext,bitIndex26)
          <=> v94(VarCurr,bitIndex96) )
          & ( v818(VarNext,bitIndex25)
          <=> v94(VarCurr,bitIndex95) )
          & ( v818(VarNext,bitIndex24)
          <=> v94(VarCurr,bitIndex94) )
          & ( v818(VarNext,bitIndex23)
          <=> v94(VarCurr,bitIndex93) )
          & ( v818(VarNext,bitIndex22)
          <=> v94(VarCurr,bitIndex92) )
          & ( v818(VarNext,bitIndex21)
          <=> v94(VarCurr,bitIndex91) )
          & ( v818(VarNext,bitIndex20)
          <=> v94(VarCurr,bitIndex90) )
          & ( v818(VarNext,bitIndex19)
          <=> v94(VarCurr,bitIndex89) )
          & ( v818(VarNext,bitIndex18)
          <=> v94(VarCurr,bitIndex88) )
          & ( v818(VarNext,bitIndex17)
          <=> v94(VarCurr,bitIndex87) )
          & ( v818(VarNext,bitIndex16)
          <=> v94(VarCurr,bitIndex86) )
          & ( v818(VarNext,bitIndex15)
          <=> v94(VarCurr,bitIndex85) )
          & ( v818(VarNext,bitIndex14)
          <=> v94(VarCurr,bitIndex84) )
          & ( v818(VarNext,bitIndex13)
          <=> v94(VarCurr,bitIndex83) )
          & ( v818(VarNext,bitIndex12)
          <=> v94(VarCurr,bitIndex82) )
          & ( v818(VarNext,bitIndex11)
          <=> v94(VarCurr,bitIndex81) )
          & ( v818(VarNext,bitIndex10)
          <=> v94(VarCurr,bitIndex80) )
          & ( v818(VarNext,bitIndex9)
          <=> v94(VarCurr,bitIndex79) )
          & ( v818(VarNext,bitIndex8)
          <=> v94(VarCurr,bitIndex78) )
          & ( v818(VarNext,bitIndex7)
          <=> v94(VarCurr,bitIndex77) )
          & ( v818(VarNext,bitIndex6)
          <=> v94(VarCurr,bitIndex76) )
          & ( v818(VarNext,bitIndex5)
          <=> v94(VarCurr,bitIndex75) )
          & ( v818(VarNext,bitIndex4)
          <=> v94(VarCurr,bitIndex74) )
          & ( v818(VarNext,bitIndex3)
          <=> v94(VarCurr,bitIndex73) )
          & ( v818(VarNext,bitIndex2)
          <=> v94(VarCurr,bitIndex72) )
          & ( v818(VarNext,bitIndex1)
          <=> v94(VarCurr,bitIndex71) )
          & ( v818(VarNext,bitIndex0)
          <=> v94(VarCurr,bitIndex70) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_30,axiom,
    ! [VarNext] :
      ( v820(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v818(VarNext,B)
          <=> v272(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_138,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v820(VarNext)
      <=> ( v821(VarNext)
          & v253(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_137,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v821(VarNext)
      <=> ( v823(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_58,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v823(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_259,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v237(VarCurr,B)
      <=> v242(VarCurr,B) ) ) ).

fof(addAssignment_258,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v241(VarCurr,B)
      <=> v94(VarCurr,B) ) ) ).

fof(addAssignment_257,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v99(VarCurr,B)
      <=> v235(VarCurr,B) ) ) ).

fof(addAssignment_256,axiom,
    ! [VarCurr] :
      ( ( v218(VarCurr,bitIndex69)
      <=> v94(VarCurr,bitIndex139) )
      & ( v218(VarCurr,bitIndex68)
      <=> v94(VarCurr,bitIndex138) )
      & ( v218(VarCurr,bitIndex67)
      <=> v94(VarCurr,bitIndex137) )
      & ( v218(VarCurr,bitIndex66)
      <=> v94(VarCurr,bitIndex136) )
      & ( v218(VarCurr,bitIndex65)
      <=> v94(VarCurr,bitIndex135) )
      & ( v218(VarCurr,bitIndex64)
      <=> v94(VarCurr,bitIndex134) )
      & ( v218(VarCurr,bitIndex63)
      <=> v94(VarCurr,bitIndex133) ) ) ).

fof(addAssignment_255,axiom,
    ! [VarNext,B] :
      ( range_69_63(B)
     => ( v94(VarNext,B)
      <=> v786(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_19,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v787(VarNext)
       => ! [B] :
            ( range_69_0(B)
           => ( v786(VarNext,B)
            <=> v94(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_29,axiom,
    ! [VarNext] :
      ( v787(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v786(VarNext,B)
          <=> v813(VarNext,B) ) ) ) ).

fof(addAssignment_254,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v813(VarNext,B)
          <=> v811(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_17,axiom,
    ! [VarCurr] :
      ( ~ v255(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v811(VarCurr,B)
          <=> v814(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_11,axiom,
    ! [VarCurr] :
      ( v255(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v811(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_9,axiom,
    ! [VarCurr] :
      ( ( ~ v800(VarCurr)
        & ~ v802(VarCurr) )
     => ! [B] :
          ( range_69_0(B)
         => ( v814(VarCurr,B)
          <=> v779(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_16,axiom,
    ! [VarCurr] :
      ( v802(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v814(VarCurr,B)
          <=> v772(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_10,axiom,
    ! [VarCurr] :
      ( v800(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v814(VarCurr,B)
          <=> v212(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_136,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v787(VarNext)
      <=> ( v788(VarNext)
          & v795(VarNext) ) ) ) ).

fof(addAssignment_253,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v795(VarNext)
      <=> v793(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_135,axiom,
    ! [VarCurr] :
      ( v793(VarCurr)
    <=> ( v796(VarCurr)
        & v807(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_134,axiom,
    ! [VarCurr] :
      ( v807(VarCurr)
    <=> ( v808(VarCurr)
        | v255(VarCurr) ) ) ).

fof(writeUnaryOperator_57,axiom,
    ! [VarCurr] :
      ( ~ v808(VarCurr)
    <=> v809(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_50,axiom,
    ! [VarCurr] :
      ( v809(VarCurr)
    <=> ( ( v810(VarCurr,bitIndex1)
        <=> $false )
        & ( v810(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_252,axiom,
    ! [VarCurr] :
      ( v810(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_251,axiom,
    ! [VarCurr] :
      ( v810(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_133,axiom,
    ! [VarCurr] :
      ( v796(VarCurr)
    <=> ( v255(VarCurr)
        | v797(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_132,axiom,
    ! [VarCurr] :
      ( v797(VarCurr)
    <=> ( v798(VarCurr)
        & v806(VarCurr) ) ) ).

fof(writeUnaryOperator_56,axiom,
    ! [VarCurr] :
      ( ~ v806(VarCurr)
    <=> v255(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_131,axiom,
    ! [VarCurr] :
      ( v798(VarCurr)
    <=> ( v799(VarCurr)
        | v804(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_49,axiom,
    ! [VarCurr] :
      ( v804(VarCurr)
    <=> ( ( v805(VarCurr,bitIndex1)
        <=> $true )
        & ( v805(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_250,axiom,
    ! [VarCurr] :
      ( v805(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_249,axiom,
    ! [VarCurr] :
      ( v805(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_130,axiom,
    ! [VarCurr] :
      ( v799(VarCurr)
    <=> ( v800(VarCurr)
        | v802(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_48,axiom,
    ! [VarCurr] :
      ( v802(VarCurr)
    <=> ( ( v803(VarCurr,bitIndex1)
        <=> $true )
        & ( v803(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_248,axiom,
    ! [VarCurr] :
      ( v803(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_247,axiom,
    ! [VarCurr] :
      ( v803(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_47,axiom,
    ! [VarCurr] :
      ( v800(VarCurr)
    <=> ( ( v801(VarCurr,bitIndex1)
        <=> $false )
        & ( v801(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_246,axiom,
    ! [VarCurr] :
      ( v801(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_245,axiom,
    ! [VarCurr] :
      ( v801(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_129,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v788(VarNext)
      <=> ( v790(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_55,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v790(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_244,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v779(VarCurr,B)
      <=> v784(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_27,axiom,
    ! [VarCurr] :
      ( ~ v781(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v784(VarCurr,B)
          <=> v783(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_28,axiom,
    ! [VarCurr] :
      ( v781(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v784(VarCurr,B)
          <=> v212(VarCurr,B) ) ) ) ).

fof(addAssignment_243,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v783(VarCurr,B)
      <=> v94(VarCurr,B) ) ) ).

fof(addAssignment_242,axiom,
    ! [VarCurr] :
      ( v781(VarCurr)
    <=> v103(VarCurr,bitIndex8) ) ).

fof(addAssignment_241,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v772(VarCurr,B)
      <=> v777(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_26,axiom,
    ! [VarCurr] :
      ( ~ v774(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v777(VarCurr,B)
          <=> v776(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_27,axiom,
    ! [VarCurr] :
      ( v774(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v777(VarCurr,B)
          <=> v212(VarCurr,B) ) ) ) ).

fof(addAssignment_240,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v776(VarCurr,B)
      <=> v94(VarCurr,B) ) ) ).

fof(addAssignment_239,axiom,
    ! [VarCurr] :
      ( v774(VarCurr)
    <=> v103(VarCurr,bitIndex8) ) ).

fof(addAssignment_238,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v212(VarCurr,B)
      <=> v214(VarCurr,B) ) ) ).

fof(addAssignment_237,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v214(VarCurr,B)
      <=> v216(VarCurr,B) ) ) ).

fof(range_axiom_6,axiom,
    ! [B] :
      ( range_69_63(B)
    <=> ( $false
        | bitIndex63 = B
        | bitIndex64 = B
        | bitIndex65 = B
        | bitIndex66 = B
        | bitIndex67 = B
        | bitIndex68 = B
        | bitIndex69 = B ) ) ).

fof(addAssignment_236,axiom,
    ! [VarCurr] :
      ( v30(VarCurr)
    <=> v32(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_18,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v747(VarNext)
       => ( v32(VarNext)
        <=> v32(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_28,axiom,
    ! [VarNext] :
      ( v747(VarNext)
     => ( v32(VarNext)
      <=> v765(VarNext) ) ) ).

fof(addAssignment_235,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v765(VarNext)
      <=> v763(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_25,axiom,
    ! [VarCurr] :
      ( ~ v762(VarCurr)
     => ( v763(VarCurr)
      <=> v766(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_26,axiom,
    ! [VarCurr] :
      ( v762(VarCurr)
     => ( v763(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_24,axiom,
    ! [VarCurr] :
      ( ~ v36(VarCurr)
     => ( v766(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_25,axiom,
    ! [VarCurr] :
      ( v36(VarCurr)
     => ( v766(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_128,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v747(VarNext)
      <=> ( v748(VarNext)
          & v755(VarNext) ) ) ) ).

fof(addAssignment_234,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v755(VarNext)
      <=> v753(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_127,axiom,
    ! [VarCurr] :
      ( v753(VarCurr)
    <=> ( v756(VarCurr)
        | v762(VarCurr) ) ) ).

fof(writeUnaryOperator_54,axiom,
    ! [VarCurr] :
      ( ~ v762(VarCurr)
    <=> v34(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_126,axiom,
    ! [VarCurr] :
      ( v756(VarCurr)
    <=> ( v757(VarCurr)
        | v36(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_125,axiom,
    ! [VarCurr] :
      ( v757(VarCurr)
    <=> ( v758(VarCurr)
        & v761(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_46,axiom,
    ! [VarCurr] :
      ( v761(VarCurr)
    <=> ( v105(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_124,axiom,
    ! [VarCurr] :
      ( v758(VarCurr)
    <=> ( v759(VarCurr)
        & v760(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_45,axiom,
    ! [VarCurr] :
      ( v760(VarCurr)
    <=> ( v652(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_44,axiom,
    ! [VarCurr] :
      ( v759(VarCurr)
    <=> ( v43(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_123,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v748(VarNext)
      <=> ( v749(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_53,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v749(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_233,axiom,
    ! [VarCurr] :
      ( v105(VarCurr,bitIndex0)
    <=> v129(VarCurr,bitIndex0) ) ).

fof(addAssignment_232,axiom,
    ! [VarNext] :
      ( v652(VarNext,bitIndex1)
    <=> v738(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_17,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v739(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v738(VarNext,B)
            <=> v652(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_27,axiom,
    ! [VarNext] :
      ( v739(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v738(VarNext,B)
          <=> v686(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_122,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v739(VarNext)
      <=> v740(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_121,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v740(VarNext)
      <=> ( v742(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_52,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v742(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_231,axiom,
    ! [VarCurr] :
      ( v655(VarCurr,bitIndex1)
    <=> v662(VarCurr,bitIndex1) ) ).

fof(addAssignment_230,axiom,
    ! [VarCurr] :
      ( v657(VarCurr,bitIndex1)
    <=> v658(VarCurr,bitIndex1) ) ).

fof(addAssignment_229,axiom,
    ! [VarNext] :
      ( v652(VarNext,bitIndex0)
    <=> v730(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionEqualRanges1_16,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v731(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v730(VarNext,B)
            <=> v652(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_26,axiom,
    ! [VarNext] :
      ( v731(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v730(VarNext,B)
          <=> v686(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_120,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v731(VarNext)
      <=> v732(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_119,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v732(VarNext)
      <=> ( v734(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_51,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v734(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_228,axiom,
    ! [VarCurr] :
      ( v655(VarCurr,bitIndex0)
    <=> v662(VarCurr,bitIndex0) ) ).

fof(addAssignment_227,axiom,
    ! [VarNext] :
      ( v652(VarNext,bitIndex2)
    <=> v722(VarNext,bitIndex2) ) ).

fof(addCaseBooleanConditionEqualRanges1_15,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v723(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v722(VarNext,B)
            <=> v652(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_25,axiom,
    ! [VarNext] :
      ( v723(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v722(VarNext,B)
          <=> v686(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_118,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v723(VarNext)
      <=> v724(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_117,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v724(VarNext)
      <=> ( v726(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_50,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v726(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_226,axiom,
    ! [VarCurr] :
      ( v655(VarCurr,bitIndex2)
    <=> v662(VarCurr,bitIndex2) ) ).

fof(addAssignment_225,axiom,
    ! [VarCurr] :
      ( v657(VarCurr,bitIndex2)
    <=> v658(VarCurr,bitIndex2) ) ).

fof(addAssignment_224,axiom,
    ! [VarNext] :
      ( v652(VarNext,bitIndex3)
    <=> v714(VarNext,bitIndex3) ) ).

fof(addCaseBooleanConditionEqualRanges1_14,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v715(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v714(VarNext,B)
            <=> v652(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_24,axiom,
    ! [VarNext] :
      ( v715(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v714(VarNext,B)
          <=> v686(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_116,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v715(VarNext)
      <=> v716(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_115,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v716(VarNext)
      <=> ( v718(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_49,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v718(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_223,axiom,
    ! [VarCurr] :
      ( v655(VarCurr,bitIndex3)
    <=> v662(VarCurr,bitIndex3) ) ).

fof(addAssignment_222,axiom,
    ! [VarCurr] :
      ( v657(VarCurr,bitIndex3)
    <=> v658(VarCurr,bitIndex3) ) ).

fof(addAssignment_221,axiom,
    ! [VarNext] :
      ( v652(VarNext,bitIndex4)
    <=> v706(VarNext,bitIndex4) ) ).

fof(addCaseBooleanConditionEqualRanges1_13,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v707(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v706(VarNext,B)
            <=> v652(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_23,axiom,
    ! [VarNext] :
      ( v707(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v706(VarNext,B)
          <=> v686(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_114,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v707(VarNext)
      <=> v708(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_113,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v708(VarNext)
      <=> ( v710(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_48,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v710(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_220,axiom,
    ! [VarCurr] :
      ( v655(VarCurr,bitIndex4)
    <=> v662(VarCurr,bitIndex4) ) ).

fof(addAssignment_219,axiom,
    ! [VarCurr] :
      ( v657(VarCurr,bitIndex4)
    <=> v658(VarCurr,bitIndex4) ) ).

fof(addAssignment_218,axiom,
    ! [VarNext] :
      ( v652(VarNext,bitIndex5)
    <=> v698(VarNext,bitIndex5) ) ).

fof(addCaseBooleanConditionEqualRanges1_12,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v699(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v698(VarNext,B)
            <=> v652(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_22,axiom,
    ! [VarNext] :
      ( v699(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v698(VarNext,B)
          <=> v686(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_112,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v699(VarNext)
      <=> v700(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_111,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v700(VarNext)
      <=> ( v702(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_47,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v702(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_217,axiom,
    ! [VarCurr] :
      ( v655(VarCurr,bitIndex5)
    <=> v662(VarCurr,bitIndex5) ) ).

fof(addAssignment_216,axiom,
    ! [VarCurr] :
      ( v657(VarCurr,bitIndex5)
    <=> v658(VarCurr,bitIndex5) ) ).

fof(addAssignment_215,axiom,
    ! [VarNext] :
      ( v652(VarNext,bitIndex6)
    <=> v690(VarNext,bitIndex6) ) ).

fof(addCaseBooleanConditionEqualRanges1_11,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v691(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v690(VarNext,B)
            <=> v652(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_21,axiom,
    ! [VarNext] :
      ( v691(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v690(VarNext,B)
          <=> v686(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_110,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v691(VarNext)
      <=> v692(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_109,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v692(VarNext)
      <=> ( v694(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_46,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v694(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_214,axiom,
    ! [VarCurr] :
      ( v655(VarCurr,bitIndex6)
    <=> v662(VarCurr,bitIndex6) ) ).

fof(addAssignment_213,axiom,
    ! [VarCurr] :
      ( v657(VarCurr,bitIndex6)
    <=> v658(VarCurr,bitIndex6) ) ).

fof(addAssignment_212,axiom,
    ! [VarNext] :
      ( v652(VarNext,bitIndex7)
    <=> v677(VarNext,bitIndex7) ) ).

fof(addCaseBooleanConditionEqualRanges1_10,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v678(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v677(VarNext,B)
            <=> v652(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_20,axiom,
    ! [VarNext] :
      ( v678(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v677(VarNext,B)
          <=> v686(VarNext,B) ) ) ) ).

fof(addAssignment_211,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v686(VarNext,B)
          <=> v684(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_23,axiom,
    ! [VarCurr] :
      ( ~ v126(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v684(VarCurr,B)
          <=> v655(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_24,axiom,
    ! [VarCurr] :
      ( v126(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v684(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_108,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v678(VarNext)
      <=> v679(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_107,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v679(VarNext)
      <=> ( v681(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_45,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v681(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_210,axiom,
    ! [VarCurr] :
      ( v655(VarCurr,bitIndex7)
    <=> v662(VarCurr,bitIndex7) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_22,axiom,
    ! [VarCurr] :
      ( ~ v663(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v662(VarCurr,B)
          <=> v664(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_23,axiom,
    ! [VarCurr] :
      ( v663(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v662(VarCurr,B)
          <=> $false ) ) ) ).

fof(bitBlastConstant_170,axiom,
    ~ b00000000(bitIndex7) ).

fof(bitBlastConstant_169,axiom,
    ~ b00000000(bitIndex6) ).

fof(bitBlastConstant_168,axiom,
    ~ b00000000(bitIndex5) ).

fof(bitBlastConstant_167,axiom,
    ~ b00000000(bitIndex4) ).

fof(bitBlastConstant_166,axiom,
    ~ b00000000(bitIndex3) ).

fof(bitBlastConstant_165,axiom,
    ~ b00000000(bitIndex2) ).

fof(bitBlastConstant_164,axiom,
    ~ b00000000(bitIndex1) ).

fof(bitBlastConstant_163,axiom,
    ~ b00000000(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges3_1,axiom,
    ! [VarCurr] :
      ( ( ~ v665(VarCurr)
        & ~ v667(VarCurr)
        & ~ v671(VarCurr) )
     => ! [B] :
          ( range_7_0(B)
         => ( v664(VarCurr,B)
          <=> v652(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_8,axiom,
    ! [VarCurr] :
      ( v671(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v664(VarCurr,B)
          <=> v673(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_15,axiom,
    ! [VarCurr] :
      ( v667(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v664(VarCurr,B)
          <=> v669(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_9,axiom,
    ! [VarCurr] :
      ( v665(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v664(VarCurr,B)
          <=> v652(VarCurr,B) ) ) ) ).

fof(range_axiom_5,axiom,
    ! [B] :
      ( range_7_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B ) ) ).

fof(addBitVectorEqualityBitBlasted_43,axiom,
    ! [VarCurr] :
      ( v674(VarCurr)
    <=> ( ( v675(VarCurr,bitIndex1)
        <=> $true )
        & ( v675(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_209,axiom,
    ! [VarCurr] :
      ( v675(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_208,axiom,
    ! [VarCurr] :
      ( v675(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(addAssignment_207,axiom,
    ! [VarCurr] :
      ( v673(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_206,axiom,
    ! [VarCurr,B] :
      ( range_7_1(B)
     => ( v673(VarCurr,B)
      <=> v657(VarCurr,B) ) ) ).

fof(range_axiom_4,axiom,
    ! [B] :
      ( range_7_1(B)
    <=> ( $false
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B ) ) ).

fof(addBitVectorEqualityBitBlasted_42,axiom,
    ! [VarCurr] :
      ( v671(VarCurr)
    <=> ( ( v672(VarCurr,bitIndex1)
        <=> $true )
        & ( v672(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_205,axiom,
    ! [VarCurr] :
      ( v672(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_204,axiom,
    ! [VarCurr] :
      ( v672(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(addAssignment_203,axiom,
    ! [VarCurr] :
      ( ( v669(VarCurr,bitIndex6)
      <=> v652(VarCurr,bitIndex7) )
      & ( v669(VarCurr,bitIndex5)
      <=> v652(VarCurr,bitIndex6) )
      & ( v669(VarCurr,bitIndex4)
      <=> v652(VarCurr,bitIndex5) )
      & ( v669(VarCurr,bitIndex3)
      <=> v652(VarCurr,bitIndex4) )
      & ( v669(VarCurr,bitIndex2)
      <=> v652(VarCurr,bitIndex3) )
      & ( v669(VarCurr,bitIndex1)
      <=> v652(VarCurr,bitIndex2) )
      & ( v669(VarCurr,bitIndex0)
      <=> v652(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_202,axiom,
    ! [VarCurr] :
      ( v669(VarCurr,bitIndex7)
    <=> $false ) ).

fof(addBitVectorEqualityBitBlasted_41,axiom,
    ! [VarCurr] :
      ( v667(VarCurr)
    <=> ( ( v668(VarCurr,bitIndex1)
        <=> $false )
        & ( v668(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_201,axiom,
    ! [VarCurr] :
      ( v668(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_200,axiom,
    ! [VarCurr] :
      ( v668(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_40,axiom,
    ! [VarCurr] :
      ( v665(VarCurr)
    <=> ( ( v666(VarCurr,bitIndex1)
        <=> $false )
        & ( v666(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_199,axiom,
    ! [VarCurr] :
      ( v666(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_198,axiom,
    ! [VarCurr] :
      ( v666(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(writeUnaryOperator_44,axiom,
    ! [VarCurr] :
      ( ~ v663(VarCurr)
    <=> v34(VarCurr) ) ).

fof(addAssignment_197,axiom,
    ! [VarCurr] :
      ( v657(VarCurr,bitIndex7)
    <=> v658(VarCurr,bitIndex7) ) ).

fof(addAssignment_196,axiom,
    ! [VarCurr] :
      ( v658(VarCurr,bitIndex0)
    <=> $false ) ).

fof(addAssignment_195,axiom,
    ! [VarCurr] :
      ( ( v658(VarCurr,bitIndex7)
      <=> v652(VarCurr,bitIndex6) )
      & ( v658(VarCurr,bitIndex6)
      <=> v652(VarCurr,bitIndex5) )
      & ( v658(VarCurr,bitIndex5)
      <=> v652(VarCurr,bitIndex4) )
      & ( v658(VarCurr,bitIndex4)
      <=> v652(VarCurr,bitIndex3) )
      & ( v658(VarCurr,bitIndex3)
      <=> v652(VarCurr,bitIndex2) )
      & ( v658(VarCurr,bitIndex2)
      <=> v652(VarCurr,bitIndex1) )
      & ( v658(VarCurr,bitIndex1)
      <=> v652(VarCurr,bitIndex0) ) ) ).

fof(addAssignmentInitValue_81,axiom,
    ~ v652(constB0,bitIndex6) ).

fof(addAssignmentInitValue_80,axiom,
    ~ v652(constB0,bitIndex5) ).

fof(addAssignmentInitValue_79,axiom,
    ~ v652(constB0,bitIndex4) ).

fof(addAssignmentInitValue_78,axiom,
    ~ v652(constB0,bitIndex3) ).

fof(addAssignmentInitValue_77,axiom,
    ~ v652(constB0,bitIndex2) ).

fof(addAssignmentInitValue_76,axiom,
    ~ v652(constB0,bitIndex1) ).

fof(addAssignmentInitValue_75,axiom,
    ~ v652(constB0,bitIndex0) ).

fof(bitBlastConstant_162,axiom,
    ~ bx0000000(bitIndex6) ).

fof(bitBlastConstant_161,axiom,
    ~ bx0000000(bitIndex5) ).

fof(bitBlastConstant_160,axiom,
    ~ bx0000000(bitIndex4) ).

fof(bitBlastConstant_159,axiom,
    ~ bx0000000(bitIndex3) ).

fof(bitBlastConstant_158,axiom,
    ~ bx0000000(bitIndex2) ).

fof(bitBlastConstant_157,axiom,
    ~ bx0000000(bitIndex1) ).

fof(bitBlastConstant_156,axiom,
    ~ bx0000000(bitIndex0) ).

fof(addAssignment_194,axiom,
    ! [VarCurr] :
      ( v43(VarCurr)
    <=> v45(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_106,axiom,
    ! [VarCurr] :
      ( v45(VarCurr)
    <=> ( v650(VarCurr)
        | v644(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_105,axiom,
    ! [VarCurr] :
      ( v650(VarCurr)
    <=> ( v47(VarCurr)
        | v56(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_21,axiom,
    ! [VarCurr] :
      ( ~ v646(VarCurr)
     => ( v644(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_22,axiom,
    ! [VarCurr] :
      ( v646(VarCurr)
     => ( v644(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_104,axiom,
    ! [VarCurr] :
      ( v646(VarCurr)
    <=> ( v647(VarCurr)
        & v54(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_103,axiom,
    ! [VarCurr] :
      ( v647(VarCurr)
    <=> ( v648(VarCurr)
        & v53(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_39,axiom,
    ! [VarCurr] :
      ( v648(VarCurr)
    <=> ( ( v28(VarCurr,bitIndex1)
        <=> $false )
        & ( v28(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_193,axiom,
    ! [VarCurr] :
      ( v56(VarCurr)
    <=> v58(VarCurr) ) ).

fof(addAssignment_192,axiom,
    ! [VarCurr] :
      ( v58(VarCurr)
    <=> v60(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_102,axiom,
    ! [VarCurr] :
      ( v60(VarCurr)
    <=> ( v642(VarCurr)
        & v554(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges,axiom,
    ! [VarCurr] :
      ( v642(VarCurr)
    <=> ( v62(VarCurr,bitIndex2)
        | v62(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_191,axiom,
    ! [VarNext] :
      ( v62(VarNext,bitIndex2)
    <=> v634(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionShiftedRanges1_9,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v635(VarNext)
       => ( ( v634(VarNext,bitIndex2)
          <=> v62(VarCurr,bitIndex3) )
          & ( v634(VarNext,bitIndex1)
          <=> v62(VarCurr,bitIndex2) )
          & ( v634(VarNext,bitIndex0)
          <=> v62(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_19,axiom,
    ! [VarNext] :
      ( v635(VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v634(VarNext,B)
          <=> v578(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_101,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v635(VarNext)
      <=> v636(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_100,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v636(VarNext)
      <=> ( v638(VarNext)
          & v565(VarNext) ) ) ) ).

fof(writeUnaryOperator_43,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v638(VarNext)
      <=> v572(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_3,axiom,
    ! [VarCurr] :
      ( ~ v626(VarCurr)
     => ( v67(VarCurr,bitIndex2)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_2,axiom,
    ! [VarCurr] :
      ( v626(VarCurr)
     => ( v67(VarCurr,bitIndex2)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_99,axiom,
    ! [VarCurr] :
      ( v626(VarCurr)
    <=> ( v627(VarCurr)
        | v631(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_98,axiom,
    ! [VarCurr] :
      ( v631(VarCurr)
    <=> ( v632(VarCurr)
        & v560(VarCurr) ) ) ).

fof(writeUnaryOperator_42,axiom,
    ! [VarCurr] :
      ( ~ v632(VarCurr)
    <=> v554(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_97,axiom,
    ! [VarCurr] :
      ( v627(VarCurr)
    <=> ( v628(VarCurr)
        & v587(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_96,axiom,
    ! [VarCurr] :
      ( v628(VarCurr)
    <=> ( v69(VarCurr)
        & v630(VarCurr) ) ) ).

fof(writeUnaryOperator_41,axiom,
    ! [VarCurr] :
      ( ~ v630(VarCurr)
    <=> v82(VarCurr) ) ).

fof(addAssignment_190,axiom,
    ! [VarCurr] :
      ( v69(VarCurr)
    <=> v71(VarCurr) ) ).

fof(addAssignment_189,axiom,
    ! [VarCurr] :
      ( v71(VarCurr)
    <=> v73(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_20,axiom,
    ! [VarCurr] :
      ( ~ v621(VarCurr)
     => ( v73(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_21,axiom,
    ! [VarCurr] :
      ( v621(VarCurr)
     => ( v73(VarCurr)
      <=> v624(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_19,axiom,
    ! [VarCurr] :
      ( ~ v76(VarCurr)
     => ( v624(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_20,axiom,
    ! [VarCurr] :
      ( v76(VarCurr)
     => ( v624(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_95,axiom,
    ! [VarCurr] :
      ( v621(VarCurr)
    <=> ( v622(VarCurr)
        & v54(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_94,axiom,
    ! [VarCurr] :
      ( v622(VarCurr)
    <=> ( v623(VarCurr)
        & v53(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_38,axiom,
    ! [VarCurr] :
      ( v623(VarCurr)
    <=> ( ( v28(VarCurr,bitIndex1)
        <=> $true )
        & ( v28(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_188,axiom,
    ! [VarCurr] :
      ( v76(VarCurr)
    <=> v78(VarCurr) ) ).

fof(addAssignment_187,axiom,
    ! [VarCurr] :
      ( v78(VarCurr)
    <=> v80(VarCurr) ) ).

fof(addAssignment_186,axiom,
    ! [VarCurr] :
      ( v80(VarCurr)
    <=> v62(VarCurr,bitIndex0) ) ).

fof(addCaseBooleanConditionEqualRanges1_9,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v609(VarNext)
       => ( v62(VarNext,bitIndex0)
        <=> v62(VarCurr,bitIndex0) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_18,axiom,
    ! [VarNext] :
      ( v609(VarNext)
     => ( v62(VarNext,bitIndex0)
      <=> v617(VarNext) ) ) ).

fof(addAssignment_185,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v617(VarNext)
      <=> v615(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_18,axiom,
    ! [VarCurr] :
      ( ~ v579(VarCurr)
     => ( v615(VarCurr)
      <=> v67(VarCurr,bitIndex0) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_19,axiom,
    ! [VarCurr] :
      ( v579(VarCurr)
     => ( v615(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_93,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v609(VarNext)
      <=> v610(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_92,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v610(VarNext)
      <=> ( v612(VarNext)
          & v565(VarNext) ) ) ) ).

fof(writeUnaryOperator_40,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v612(VarNext)
      <=> v572(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_17,axiom,
    ! [VarCurr] :
      ( ~ v600(VarCurr)
     => ( v67(VarCurr,bitIndex0)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_18,axiom,
    ! [VarCurr] :
      ( v600(VarCurr)
     => ( v67(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_91,axiom,
    ! [VarCurr] :
      ( v600(VarCurr)
    <=> ( v601(VarCurr)
        | v606(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_90,axiom,
    ! [VarCurr] :
      ( v606(VarCurr)
    <=> ( v554(VarCurr)
        & v590(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_89,axiom,
    ! [VarCurr] :
      ( v601(VarCurr)
    <=> ( v602(VarCurr)
        | v605(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_88,axiom,
    ! [VarCurr] :
      ( v605(VarCurr)
    <=> ( v554(VarCurr)
        & v563(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_87,axiom,
    ! [VarCurr] :
      ( v602(VarCurr)
    <=> ( v603(VarCurr)
        & v587(VarCurr) ) ) ).

fof(writeUnaryOperator_39,axiom,
    ! [VarCurr] :
      ( ~ v603(VarCurr)
    <=> v69(VarCurr) ) ).

fof(addAssignment_184,axiom,
    ! [VarNext] :
      ( v62(VarNext,bitIndex1)
    <=> v592(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionShiftedRanges1_8,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v593(VarNext)
       => ( ( v592(VarNext,bitIndex2)
          <=> v62(VarCurr,bitIndex3) )
          & ( v592(VarNext,bitIndex1)
          <=> v62(VarCurr,bitIndex2) )
          & ( v592(VarNext,bitIndex0)
          <=> v62(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_17,axiom,
    ! [VarNext] :
      ( v593(VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v592(VarNext,B)
          <=> v578(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_86,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v593(VarNext)
      <=> v594(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_85,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v594(VarNext)
      <=> ( v596(VarNext)
          & v565(VarNext) ) ) ) ).

fof(writeUnaryOperator_38,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v596(VarNext)
      <=> v572(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_2,axiom,
    ! [VarCurr] :
      ( ~ v583(VarCurr)
     => ( v67(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_1,axiom,
    ! [VarCurr] :
      ( v583(VarCurr)
     => ( v67(VarCurr,bitIndex1)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_84,axiom,
    ! [VarCurr] :
      ( v583(VarCurr)
    <=> ( v584(VarCurr)
        | v588(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_83,axiom,
    ! [VarCurr] :
      ( v588(VarCurr)
    <=> ( v589(VarCurr)
        & v590(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_37,axiom,
    ! [VarCurr] :
      ( v590(VarCurr)
    <=> ( $true
      <=> v62(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_37,axiom,
    ! [VarCurr] :
      ( ~ v589(VarCurr)
    <=> v554(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_82,axiom,
    ! [VarCurr] :
      ( v584(VarCurr)
    <=> ( v585(VarCurr)
        & v587(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_36,axiom,
    ! [VarCurr] :
      ( v587(VarCurr)
    <=> ( $true
      <=> v62(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_81,axiom,
    ! [VarCurr] :
      ( v585(VarCurr)
    <=> ( v69(VarCurr)
        & v82(VarCurr) ) ) ).

fof(addAssignment_183,axiom,
    ! [VarNext] :
      ( v62(VarNext,bitIndex3)
    <=> v567(VarNext,bitIndex2) ) ).

fof(addCaseBooleanConditionShiftedRanges1_7,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v568(VarNext)
       => ( ( v567(VarNext,bitIndex2)
          <=> v62(VarCurr,bitIndex3) )
          & ( v567(VarNext,bitIndex1)
          <=> v62(VarCurr,bitIndex2) )
          & ( v567(VarNext,bitIndex0)
          <=> v62(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_16,axiom,
    ! [VarNext] :
      ( v568(VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v567(VarNext,B)
          <=> v578(VarNext,B) ) ) ) ).

fof(addAssignment_182,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v578(VarNext,B)
          <=> v576(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_1,axiom,
    ! [VarCurr] :
      ( ~ v579(VarCurr)
     => ( ( v576(VarCurr,bitIndex2)
        <=> v67(VarCurr,bitIndex3) )
        & ( v576(VarCurr,bitIndex1)
        <=> v67(VarCurr,bitIndex2) )
        & ( v576(VarCurr,bitIndex0)
        <=> v67(VarCurr,bitIndex1) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_17,axiom,
    ! [VarCurr] :
      ( v579(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v576(VarCurr,B)
          <=> $false ) ) ) ).

fof(range_axiom_3,axiom,
    ! [B] :
      ( range_2_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B ) ) ).

fof(writeUnaryOperator_36,axiom,
    ! [VarCurr] :
      ( ~ v579(VarCurr)
    <=> v64(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_80,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v568(VarNext)
      <=> v569(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_79,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v569(VarNext)
      <=> ( v570(VarNext)
          & v565(VarNext) ) ) ) ).

fof(writeUnaryOperator_35,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v570(VarNext)
      <=> v572(VarNext) ) ) ).

fof(addAssignment_181,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v572(VarNext)
      <=> v565(VarCurr) ) ) ).

fof(addAssignment_180,axiom,
    ! [VarCurr] :
      ( v565(VarCurr)
    <=> v1(VarCurr) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch,axiom,
    ! [VarCurr] :
      ( ~ v558(VarCurr)
     => ( v67(VarCurr,bitIndex3)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch,axiom,
    ! [VarCurr] :
      ( v558(VarCurr)
     => ( v67(VarCurr,bitIndex3)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_78,axiom,
    ! [VarCurr] :
      ( v558(VarCurr)
    <=> ( v559(VarCurr)
        | v561(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_77,axiom,
    ! [VarCurr] :
      ( v561(VarCurr)
    <=> ( v562(VarCurr)
        & v563(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_35,axiom,
    ! [VarCurr] :
      ( v563(VarCurr)
    <=> ( $true
      <=> v62(VarCurr,bitIndex3) ) ) ).

fof(writeUnaryOperator_34,axiom,
    ! [VarCurr] :
      ( ~ v562(VarCurr)
    <=> v554(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_76,axiom,
    ! [VarCurr] :
      ( v559(VarCurr)
    <=> ( v554(VarCurr)
        & v560(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_34,axiom,
    ! [VarCurr] :
      ( v560(VarCurr)
    <=> ( $true
      <=> v62(VarCurr,bitIndex2) ) ) ).

fof(addAssignmentInitValueVector_3,axiom,
    ( ( v62(constB0,bitIndex3)
    <=> $false )
    & ( v62(constB0,bitIndex2)
    <=> $false )
    & ( v62(constB0,bitIndex1)
    <=> $false ) ) ).

fof(bitBlastConstant_155,axiom,
    ~ b000(bitIndex2) ).

fof(bitBlastConstant_154,axiom,
    ~ b000(bitIndex1) ).

fof(bitBlastConstant_153,axiom,
    ~ b000(bitIndex0) ).

fof(addAssignmentInitValueVector_2,axiom,
    ( v62(constB0,bitIndex0)
  <=> $true ) ).

fof(addAssignment_179,axiom,
    ! [VarCurr] :
      ( v554(VarCurr)
    <=> v556(VarCurr) ) ).

fof(addAssignment_178,axiom,
    ! [VarCurr] :
      ( v82(VarCurr)
    <=> v84(VarCurr) ) ).

fof(addAssignment_177,axiom,
    ! [VarCurr] :
      ( v84(VarCurr)
    <=> v86(VarCurr) ) ).

fof(addAssignment_176,axiom,
    ! [VarCurr] :
      ( v86(VarCurr)
    <=> v88(VarCurr,bitIndex0) ) ).

fof(addAssignment_175,axiom,
    ! [VarCurr] :
      ( v88(VarCurr,bitIndex0)
    <=> v90(VarCurr,bitIndex49) ) ).

fof(addAssignment_174,axiom,
    ! [VarCurr] :
      ( v90(VarCurr,bitIndex49)
    <=> v92(VarCurr,bitIndex49) ) ).

fof(addAssignment_173,axiom,
    ! [VarCurr] :
      ( v92(VarCurr,bitIndex49)
    <=> v94(VarCurr,bitIndex539) ) ).

fof(addAssignment_172,axiom,
    ! [VarNext] :
      ( v94(VarNext,bitIndex539)
    <=> v521(VarNext,bitIndex49) ) ).

fof(addCaseBooleanConditionShiftedRanges1_6,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v522(VarNext)
       => ( ( v521(VarNext,bitIndex69)
          <=> v94(VarCurr,bitIndex559) )
          & ( v521(VarNext,bitIndex68)
          <=> v94(VarCurr,bitIndex558) )
          & ( v521(VarNext,bitIndex67)
          <=> v94(VarCurr,bitIndex557) )
          & ( v521(VarNext,bitIndex66)
          <=> v94(VarCurr,bitIndex556) )
          & ( v521(VarNext,bitIndex65)
          <=> v94(VarCurr,bitIndex555) )
          & ( v521(VarNext,bitIndex64)
          <=> v94(VarCurr,bitIndex554) )
          & ( v521(VarNext,bitIndex63)
          <=> v94(VarCurr,bitIndex553) )
          & ( v521(VarNext,bitIndex62)
          <=> v94(VarCurr,bitIndex552) )
          & ( v521(VarNext,bitIndex61)
          <=> v94(VarCurr,bitIndex551) )
          & ( v521(VarNext,bitIndex60)
          <=> v94(VarCurr,bitIndex550) )
          & ( v521(VarNext,bitIndex59)
          <=> v94(VarCurr,bitIndex549) )
          & ( v521(VarNext,bitIndex58)
          <=> v94(VarCurr,bitIndex548) )
          & ( v521(VarNext,bitIndex57)
          <=> v94(VarCurr,bitIndex547) )
          & ( v521(VarNext,bitIndex56)
          <=> v94(VarCurr,bitIndex546) )
          & ( v521(VarNext,bitIndex55)
          <=> v94(VarCurr,bitIndex545) )
          & ( v521(VarNext,bitIndex54)
          <=> v94(VarCurr,bitIndex544) )
          & ( v521(VarNext,bitIndex53)
          <=> v94(VarCurr,bitIndex543) )
          & ( v521(VarNext,bitIndex52)
          <=> v94(VarCurr,bitIndex542) )
          & ( v521(VarNext,bitIndex51)
          <=> v94(VarCurr,bitIndex541) )
          & ( v521(VarNext,bitIndex50)
          <=> v94(VarCurr,bitIndex540) )
          & ( v521(VarNext,bitIndex49)
          <=> v94(VarCurr,bitIndex539) )
          & ( v521(VarNext,bitIndex48)
          <=> v94(VarCurr,bitIndex538) )
          & ( v521(VarNext,bitIndex47)
          <=> v94(VarCurr,bitIndex537) )
          & ( v521(VarNext,bitIndex46)
          <=> v94(VarCurr,bitIndex536) )
          & ( v521(VarNext,bitIndex45)
          <=> v94(VarCurr,bitIndex535) )
          & ( v521(VarNext,bitIndex44)
          <=> v94(VarCurr,bitIndex534) )
          & ( v521(VarNext,bitIndex43)
          <=> v94(VarCurr,bitIndex533) )
          & ( v521(VarNext,bitIndex42)
          <=> v94(VarCurr,bitIndex532) )
          & ( v521(VarNext,bitIndex41)
          <=> v94(VarCurr,bitIndex531) )
          & ( v521(VarNext,bitIndex40)
          <=> v94(VarCurr,bitIndex530) )
          & ( v521(VarNext,bitIndex39)
          <=> v94(VarCurr,bitIndex529) )
          & ( v521(VarNext,bitIndex38)
          <=> v94(VarCurr,bitIndex528) )
          & ( v521(VarNext,bitIndex37)
          <=> v94(VarCurr,bitIndex527) )
          & ( v521(VarNext,bitIndex36)
          <=> v94(VarCurr,bitIndex526) )
          & ( v521(VarNext,bitIndex35)
          <=> v94(VarCurr,bitIndex525) )
          & ( v521(VarNext,bitIndex34)
          <=> v94(VarCurr,bitIndex524) )
          & ( v521(VarNext,bitIndex33)
          <=> v94(VarCurr,bitIndex523) )
          & ( v521(VarNext,bitIndex32)
          <=> v94(VarCurr,bitIndex522) )
          & ( v521(VarNext,bitIndex31)
          <=> v94(VarCurr,bitIndex521) )
          & ( v521(VarNext,bitIndex30)
          <=> v94(VarCurr,bitIndex520) )
          & ( v521(VarNext,bitIndex29)
          <=> v94(VarCurr,bitIndex519) )
          & ( v521(VarNext,bitIndex28)
          <=> v94(VarCurr,bitIndex518) )
          & ( v521(VarNext,bitIndex27)
          <=> v94(VarCurr,bitIndex517) )
          & ( v521(VarNext,bitIndex26)
          <=> v94(VarCurr,bitIndex516) )
          & ( v521(VarNext,bitIndex25)
          <=> v94(VarCurr,bitIndex515) )
          & ( v521(VarNext,bitIndex24)
          <=> v94(VarCurr,bitIndex514) )
          & ( v521(VarNext,bitIndex23)
          <=> v94(VarCurr,bitIndex513) )
          & ( v521(VarNext,bitIndex22)
          <=> v94(VarCurr,bitIndex512) )
          & ( v521(VarNext,bitIndex21)
          <=> v94(VarCurr,bitIndex511) )
          & ( v521(VarNext,bitIndex20)
          <=> v94(VarCurr,bitIndex510) )
          & ( v521(VarNext,bitIndex19)
          <=> v94(VarCurr,bitIndex509) )
          & ( v521(VarNext,bitIndex18)
          <=> v94(VarCurr,bitIndex508) )
          & ( v521(VarNext,bitIndex17)
          <=> v94(VarCurr,bitIndex507) )
          & ( v521(VarNext,bitIndex16)
          <=> v94(VarCurr,bitIndex506) )
          & ( v521(VarNext,bitIndex15)
          <=> v94(VarCurr,bitIndex505) )
          & ( v521(VarNext,bitIndex14)
          <=> v94(VarCurr,bitIndex504) )
          & ( v521(VarNext,bitIndex13)
          <=> v94(VarCurr,bitIndex503) )
          & ( v521(VarNext,bitIndex12)
          <=> v94(VarCurr,bitIndex502) )
          & ( v521(VarNext,bitIndex11)
          <=> v94(VarCurr,bitIndex501) )
          & ( v521(VarNext,bitIndex10)
          <=> v94(VarCurr,bitIndex500) )
          & ( v521(VarNext,bitIndex9)
          <=> v94(VarCurr,bitIndex499) )
          & ( v521(VarNext,bitIndex8)
          <=> v94(VarCurr,bitIndex498) )
          & ( v521(VarNext,bitIndex7)
          <=> v94(VarCurr,bitIndex497) )
          & ( v521(VarNext,bitIndex6)
          <=> v94(VarCurr,bitIndex496) )
          & ( v521(VarNext,bitIndex5)
          <=> v94(VarCurr,bitIndex495) )
          & ( v521(VarNext,bitIndex4)
          <=> v94(VarCurr,bitIndex494) )
          & ( v521(VarNext,bitIndex3)
          <=> v94(VarCurr,bitIndex493) )
          & ( v521(VarNext,bitIndex2)
          <=> v94(VarCurr,bitIndex492) )
          & ( v521(VarNext,bitIndex1)
          <=> v94(VarCurr,bitIndex491) )
          & ( v521(VarNext,bitIndex0)
          <=> v94(VarCurr,bitIndex490) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_15,axiom,
    ! [VarNext] :
      ( v522(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v521(VarNext,B)
          <=> v548(VarNext,B) ) ) ) ).

fof(addAssignment_171,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v548(VarNext,B)
          <=> v546(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_14,axiom,
    ! [VarCurr] :
      ( ~ v255(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v546(VarCurr,B)
          <=> v549(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_8,axiom,
    ! [VarCurr] :
      ( v255(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v546(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_7,axiom,
    ! [VarCurr] :
      ( ( ~ v535(VarCurr)
        & ~ v537(VarCurr) )
     => ! [B] :
          ( range_69_0(B)
         => ( v549(VarCurr,B)
          <=> v514(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_13,axiom,
    ! [VarCurr] :
      ( v537(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v549(VarCurr,B)
          <=> v507(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_5,axiom,
    ! [VarCurr] :
      ( v535(VarCurr)
     => ( ( v549(VarCurr,bitIndex69)
        <=> v94(VarCurr,bitIndex489) )
        & ( v549(VarCurr,bitIndex68)
        <=> v94(VarCurr,bitIndex488) )
        & ( v549(VarCurr,bitIndex67)
        <=> v94(VarCurr,bitIndex487) )
        & ( v549(VarCurr,bitIndex66)
        <=> v94(VarCurr,bitIndex486) )
        & ( v549(VarCurr,bitIndex65)
        <=> v94(VarCurr,bitIndex485) )
        & ( v549(VarCurr,bitIndex64)
        <=> v94(VarCurr,bitIndex484) )
        & ( v549(VarCurr,bitIndex63)
        <=> v94(VarCurr,bitIndex483) )
        & ( v549(VarCurr,bitIndex62)
        <=> v94(VarCurr,bitIndex482) )
        & ( v549(VarCurr,bitIndex61)
        <=> v94(VarCurr,bitIndex481) )
        & ( v549(VarCurr,bitIndex60)
        <=> v94(VarCurr,bitIndex480) )
        & ( v549(VarCurr,bitIndex59)
        <=> v94(VarCurr,bitIndex479) )
        & ( v549(VarCurr,bitIndex58)
        <=> v94(VarCurr,bitIndex478) )
        & ( v549(VarCurr,bitIndex57)
        <=> v94(VarCurr,bitIndex477) )
        & ( v549(VarCurr,bitIndex56)
        <=> v94(VarCurr,bitIndex476) )
        & ( v549(VarCurr,bitIndex55)
        <=> v94(VarCurr,bitIndex475) )
        & ( v549(VarCurr,bitIndex54)
        <=> v94(VarCurr,bitIndex474) )
        & ( v549(VarCurr,bitIndex53)
        <=> v94(VarCurr,bitIndex473) )
        & ( v549(VarCurr,bitIndex52)
        <=> v94(VarCurr,bitIndex472) )
        & ( v549(VarCurr,bitIndex51)
        <=> v94(VarCurr,bitIndex471) )
        & ( v549(VarCurr,bitIndex50)
        <=> v94(VarCurr,bitIndex470) )
        & ( v549(VarCurr,bitIndex49)
        <=> v94(VarCurr,bitIndex469) )
        & ( v549(VarCurr,bitIndex48)
        <=> v94(VarCurr,bitIndex468) )
        & ( v549(VarCurr,bitIndex47)
        <=> v94(VarCurr,bitIndex467) )
        & ( v549(VarCurr,bitIndex46)
        <=> v94(VarCurr,bitIndex466) )
        & ( v549(VarCurr,bitIndex45)
        <=> v94(VarCurr,bitIndex465) )
        & ( v549(VarCurr,bitIndex44)
        <=> v94(VarCurr,bitIndex464) )
        & ( v549(VarCurr,bitIndex43)
        <=> v94(VarCurr,bitIndex463) )
        & ( v549(VarCurr,bitIndex42)
        <=> v94(VarCurr,bitIndex462) )
        & ( v549(VarCurr,bitIndex41)
        <=> v94(VarCurr,bitIndex461) )
        & ( v549(VarCurr,bitIndex40)
        <=> v94(VarCurr,bitIndex460) )
        & ( v549(VarCurr,bitIndex39)
        <=> v94(VarCurr,bitIndex459) )
        & ( v549(VarCurr,bitIndex38)
        <=> v94(VarCurr,bitIndex458) )
        & ( v549(VarCurr,bitIndex37)
        <=> v94(VarCurr,bitIndex457) )
        & ( v549(VarCurr,bitIndex36)
        <=> v94(VarCurr,bitIndex456) )
        & ( v549(VarCurr,bitIndex35)
        <=> v94(VarCurr,bitIndex455) )
        & ( v549(VarCurr,bitIndex34)
        <=> v94(VarCurr,bitIndex454) )
        & ( v549(VarCurr,bitIndex33)
        <=> v94(VarCurr,bitIndex453) )
        & ( v549(VarCurr,bitIndex32)
        <=> v94(VarCurr,bitIndex452) )
        & ( v549(VarCurr,bitIndex31)
        <=> v94(VarCurr,bitIndex451) )
        & ( v549(VarCurr,bitIndex30)
        <=> v94(VarCurr,bitIndex450) )
        & ( v549(VarCurr,bitIndex29)
        <=> v94(VarCurr,bitIndex449) )
        & ( v549(VarCurr,bitIndex28)
        <=> v94(VarCurr,bitIndex448) )
        & ( v549(VarCurr,bitIndex27)
        <=> v94(VarCurr,bitIndex447) )
        & ( v549(VarCurr,bitIndex26)
        <=> v94(VarCurr,bitIndex446) )
        & ( v549(VarCurr,bitIndex25)
        <=> v94(VarCurr,bitIndex445) )
        & ( v549(VarCurr,bitIndex24)
        <=> v94(VarCurr,bitIndex444) )
        & ( v549(VarCurr,bitIndex23)
        <=> v94(VarCurr,bitIndex443) )
        & ( v549(VarCurr,bitIndex22)
        <=> v94(VarCurr,bitIndex442) )
        & ( v549(VarCurr,bitIndex21)
        <=> v94(VarCurr,bitIndex441) )
        & ( v549(VarCurr,bitIndex20)
        <=> v94(VarCurr,bitIndex440) )
        & ( v549(VarCurr,bitIndex19)
        <=> v94(VarCurr,bitIndex439) )
        & ( v549(VarCurr,bitIndex18)
        <=> v94(VarCurr,bitIndex438) )
        & ( v549(VarCurr,bitIndex17)
        <=> v94(VarCurr,bitIndex437) )
        & ( v549(VarCurr,bitIndex16)
        <=> v94(VarCurr,bitIndex436) )
        & ( v549(VarCurr,bitIndex15)
        <=> v94(VarCurr,bitIndex435) )
        & ( v549(VarCurr,bitIndex14)
        <=> v94(VarCurr,bitIndex434) )
        & ( v549(VarCurr,bitIndex13)
        <=> v94(VarCurr,bitIndex433) )
        & ( v549(VarCurr,bitIndex12)
        <=> v94(VarCurr,bitIndex432) )
        & ( v549(VarCurr,bitIndex11)
        <=> v94(VarCurr,bitIndex431) )
        & ( v549(VarCurr,bitIndex10)
        <=> v94(VarCurr,bitIndex430) )
        & ( v549(VarCurr,bitIndex9)
        <=> v94(VarCurr,bitIndex429) )
        & ( v549(VarCurr,bitIndex8)
        <=> v94(VarCurr,bitIndex428) )
        & ( v549(VarCurr,bitIndex7)
        <=> v94(VarCurr,bitIndex427) )
        & ( v549(VarCurr,bitIndex6)
        <=> v94(VarCurr,bitIndex426) )
        & ( v549(VarCurr,bitIndex5)
        <=> v94(VarCurr,bitIndex425) )
        & ( v549(VarCurr,bitIndex4)
        <=> v94(VarCurr,bitIndex424) )
        & ( v549(VarCurr,bitIndex3)
        <=> v94(VarCurr,bitIndex423) )
        & ( v549(VarCurr,bitIndex2)
        <=> v94(VarCurr,bitIndex422) )
        & ( v549(VarCurr,bitIndex1)
        <=> v94(VarCurr,bitIndex421) )
        & ( v549(VarCurr,bitIndex0)
        <=> v94(VarCurr,bitIndex420) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_75,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v522(VarNext)
      <=> ( v523(VarNext)
          & v530(VarNext) ) ) ) ).

fof(addAssignment_170,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v530(VarNext)
      <=> v528(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_74,axiom,
    ! [VarCurr] :
      ( v528(VarCurr)
    <=> ( v531(VarCurr)
        & v542(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_73,axiom,
    ! [VarCurr] :
      ( v542(VarCurr)
    <=> ( v543(VarCurr)
        | v255(VarCurr) ) ) ).

fof(writeUnaryOperator_33,axiom,
    ! [VarCurr] :
      ( ~ v543(VarCurr)
    <=> v544(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_33,axiom,
    ! [VarCurr] :
      ( v544(VarCurr)
    <=> ( ( v545(VarCurr,bitIndex1)
        <=> $false )
        & ( v545(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_169,axiom,
    ! [VarCurr] :
      ( v545(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_168,axiom,
    ! [VarCurr] :
      ( v545(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_72,axiom,
    ! [VarCurr] :
      ( v531(VarCurr)
    <=> ( v255(VarCurr)
        | v532(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_71,axiom,
    ! [VarCurr] :
      ( v532(VarCurr)
    <=> ( v533(VarCurr)
        & v541(VarCurr) ) ) ).

fof(writeUnaryOperator_32,axiom,
    ! [VarCurr] :
      ( ~ v541(VarCurr)
    <=> v255(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_70,axiom,
    ! [VarCurr] :
      ( v533(VarCurr)
    <=> ( v534(VarCurr)
        | v539(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_32,axiom,
    ! [VarCurr] :
      ( v539(VarCurr)
    <=> ( ( v540(VarCurr,bitIndex1)
        <=> $true )
        & ( v540(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_167,axiom,
    ! [VarCurr] :
      ( v540(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_166,axiom,
    ! [VarCurr] :
      ( v540(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_69,axiom,
    ! [VarCurr] :
      ( v534(VarCurr)
    <=> ( v535(VarCurr)
        | v537(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_31,axiom,
    ! [VarCurr] :
      ( v537(VarCurr)
    <=> ( ( v538(VarCurr,bitIndex1)
        <=> $true )
        & ( v538(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_165,axiom,
    ! [VarCurr] :
      ( v538(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_164,axiom,
    ! [VarCurr] :
      ( v538(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_30,axiom,
    ! [VarCurr] :
      ( v535(VarCurr)
    <=> ( ( v536(VarCurr,bitIndex1)
        <=> $false )
        & ( v536(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_163,axiom,
    ! [VarCurr] :
      ( v536(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_162,axiom,
    ! [VarCurr] :
      ( v536(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_68,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v523(VarNext)
      <=> ( v525(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_31,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v525(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_161,axiom,
    ! [VarCurr] :
      ( v514(VarCurr,bitIndex49)
    <=> v519(VarCurr,bitIndex49) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_16,axiom,
    ! [VarCurr] :
      ( ~ v516(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v519(VarCurr,B)
          <=> v518(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_16,axiom,
    ! [VarCurr] :
      ( v516(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v519(VarCurr,B)
          <=> v212(VarCurr,B) ) ) ) ).

fof(addAssignment_160,axiom,
    ! [VarCurr] :
      ( v518(VarCurr,bitIndex49)
    <=> v94(VarCurr,bitIndex469) ) ).

fof(addAssignment_159,axiom,
    ! [VarCurr] :
      ( v516(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_158,axiom,
    ! [VarCurr] :
      ( v507(VarCurr,bitIndex49)
    <=> v512(VarCurr,bitIndex49) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_15,axiom,
    ! [VarCurr] :
      ( ~ v509(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v512(VarCurr,B)
          <=> v511(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_15,axiom,
    ! [VarCurr] :
      ( v509(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v512(VarCurr,B)
          <=> v212(VarCurr,B) ) ) ) ).

fof(addAssignment_157,axiom,
    ! [VarCurr] :
      ( v511(VarCurr,bitIndex49)
    <=> v94(VarCurr,bitIndex539) ) ).

fof(addAssignment_156,axiom,
    ! [VarCurr] :
      ( v509(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_155,axiom,
    ! [VarNext] :
      ( v94(VarNext,bitIndex469)
    <=> v475(VarNext,bitIndex49) ) ).

fof(addCaseBooleanConditionShiftedRanges1_5,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v476(VarNext)
       => ( ( v475(VarNext,bitIndex69)
          <=> v94(VarCurr,bitIndex489) )
          & ( v475(VarNext,bitIndex68)
          <=> v94(VarCurr,bitIndex488) )
          & ( v475(VarNext,bitIndex67)
          <=> v94(VarCurr,bitIndex487) )
          & ( v475(VarNext,bitIndex66)
          <=> v94(VarCurr,bitIndex486) )
          & ( v475(VarNext,bitIndex65)
          <=> v94(VarCurr,bitIndex485) )
          & ( v475(VarNext,bitIndex64)
          <=> v94(VarCurr,bitIndex484) )
          & ( v475(VarNext,bitIndex63)
          <=> v94(VarCurr,bitIndex483) )
          & ( v475(VarNext,bitIndex62)
          <=> v94(VarCurr,bitIndex482) )
          & ( v475(VarNext,bitIndex61)
          <=> v94(VarCurr,bitIndex481) )
          & ( v475(VarNext,bitIndex60)
          <=> v94(VarCurr,bitIndex480) )
          & ( v475(VarNext,bitIndex59)
          <=> v94(VarCurr,bitIndex479) )
          & ( v475(VarNext,bitIndex58)
          <=> v94(VarCurr,bitIndex478) )
          & ( v475(VarNext,bitIndex57)
          <=> v94(VarCurr,bitIndex477) )
          & ( v475(VarNext,bitIndex56)
          <=> v94(VarCurr,bitIndex476) )
          & ( v475(VarNext,bitIndex55)
          <=> v94(VarCurr,bitIndex475) )
          & ( v475(VarNext,bitIndex54)
          <=> v94(VarCurr,bitIndex474) )
          & ( v475(VarNext,bitIndex53)
          <=> v94(VarCurr,bitIndex473) )
          & ( v475(VarNext,bitIndex52)
          <=> v94(VarCurr,bitIndex472) )
          & ( v475(VarNext,bitIndex51)
          <=> v94(VarCurr,bitIndex471) )
          & ( v475(VarNext,bitIndex50)
          <=> v94(VarCurr,bitIndex470) )
          & ( v475(VarNext,bitIndex49)
          <=> v94(VarCurr,bitIndex469) )
          & ( v475(VarNext,bitIndex48)
          <=> v94(VarCurr,bitIndex468) )
          & ( v475(VarNext,bitIndex47)
          <=> v94(VarCurr,bitIndex467) )
          & ( v475(VarNext,bitIndex46)
          <=> v94(VarCurr,bitIndex466) )
          & ( v475(VarNext,bitIndex45)
          <=> v94(VarCurr,bitIndex465) )
          & ( v475(VarNext,bitIndex44)
          <=> v94(VarCurr,bitIndex464) )
          & ( v475(VarNext,bitIndex43)
          <=> v94(VarCurr,bitIndex463) )
          & ( v475(VarNext,bitIndex42)
          <=> v94(VarCurr,bitIndex462) )
          & ( v475(VarNext,bitIndex41)
          <=> v94(VarCurr,bitIndex461) )
          & ( v475(VarNext,bitIndex40)
          <=> v94(VarCurr,bitIndex460) )
          & ( v475(VarNext,bitIndex39)
          <=> v94(VarCurr,bitIndex459) )
          & ( v475(VarNext,bitIndex38)
          <=> v94(VarCurr,bitIndex458) )
          & ( v475(VarNext,bitIndex37)
          <=> v94(VarCurr,bitIndex457) )
          & ( v475(VarNext,bitIndex36)
          <=> v94(VarCurr,bitIndex456) )
          & ( v475(VarNext,bitIndex35)
          <=> v94(VarCurr,bitIndex455) )
          & ( v475(VarNext,bitIndex34)
          <=> v94(VarCurr,bitIndex454) )
          & ( v475(VarNext,bitIndex33)
          <=> v94(VarCurr,bitIndex453) )
          & ( v475(VarNext,bitIndex32)
          <=> v94(VarCurr,bitIndex452) )
          & ( v475(VarNext,bitIndex31)
          <=> v94(VarCurr,bitIndex451) )
          & ( v475(VarNext,bitIndex30)
          <=> v94(VarCurr,bitIndex450) )
          & ( v475(VarNext,bitIndex29)
          <=> v94(VarCurr,bitIndex449) )
          & ( v475(VarNext,bitIndex28)
          <=> v94(VarCurr,bitIndex448) )
          & ( v475(VarNext,bitIndex27)
          <=> v94(VarCurr,bitIndex447) )
          & ( v475(VarNext,bitIndex26)
          <=> v94(VarCurr,bitIndex446) )
          & ( v475(VarNext,bitIndex25)
          <=> v94(VarCurr,bitIndex445) )
          & ( v475(VarNext,bitIndex24)
          <=> v94(VarCurr,bitIndex444) )
          & ( v475(VarNext,bitIndex23)
          <=> v94(VarCurr,bitIndex443) )
          & ( v475(VarNext,bitIndex22)
          <=> v94(VarCurr,bitIndex442) )
          & ( v475(VarNext,bitIndex21)
          <=> v94(VarCurr,bitIndex441) )
          & ( v475(VarNext,bitIndex20)
          <=> v94(VarCurr,bitIndex440) )
          & ( v475(VarNext,bitIndex19)
          <=> v94(VarCurr,bitIndex439) )
          & ( v475(VarNext,bitIndex18)
          <=> v94(VarCurr,bitIndex438) )
          & ( v475(VarNext,bitIndex17)
          <=> v94(VarCurr,bitIndex437) )
          & ( v475(VarNext,bitIndex16)
          <=> v94(VarCurr,bitIndex436) )
          & ( v475(VarNext,bitIndex15)
          <=> v94(VarCurr,bitIndex435) )
          & ( v475(VarNext,bitIndex14)
          <=> v94(VarCurr,bitIndex434) )
          & ( v475(VarNext,bitIndex13)
          <=> v94(VarCurr,bitIndex433) )
          & ( v475(VarNext,bitIndex12)
          <=> v94(VarCurr,bitIndex432) )
          & ( v475(VarNext,bitIndex11)
          <=> v94(VarCurr,bitIndex431) )
          & ( v475(VarNext,bitIndex10)
          <=> v94(VarCurr,bitIndex430) )
          & ( v475(VarNext,bitIndex9)
          <=> v94(VarCurr,bitIndex429) )
          & ( v475(VarNext,bitIndex8)
          <=> v94(VarCurr,bitIndex428) )
          & ( v475(VarNext,bitIndex7)
          <=> v94(VarCurr,bitIndex427) )
          & ( v475(VarNext,bitIndex6)
          <=> v94(VarCurr,bitIndex426) )
          & ( v475(VarNext,bitIndex5)
          <=> v94(VarCurr,bitIndex425) )
          & ( v475(VarNext,bitIndex4)
          <=> v94(VarCurr,bitIndex424) )
          & ( v475(VarNext,bitIndex3)
          <=> v94(VarCurr,bitIndex423) )
          & ( v475(VarNext,bitIndex2)
          <=> v94(VarCurr,bitIndex422) )
          & ( v475(VarNext,bitIndex1)
          <=> v94(VarCurr,bitIndex421) )
          & ( v475(VarNext,bitIndex0)
          <=> v94(VarCurr,bitIndex420) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_14,axiom,
    ! [VarNext] :
      ( v476(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v475(VarNext,B)
          <=> v502(VarNext,B) ) ) ) ).

fof(addAssignment_154,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v502(VarNext,B)
          <=> v500(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_12,axiom,
    ! [VarCurr] :
      ( ~ v255(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v500(VarCurr,B)
          <=> v503(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_7,axiom,
    ! [VarCurr] :
      ( v255(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v500(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_6,axiom,
    ! [VarCurr] :
      ( ( ~ v489(VarCurr)
        & ~ v491(VarCurr) )
     => ! [B] :
          ( range_69_0(B)
         => ( v503(VarCurr,B)
          <=> v468(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_11,axiom,
    ! [VarCurr] :
      ( v491(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v503(VarCurr,B)
          <=> v461(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_4,axiom,
    ! [VarCurr] :
      ( v489(VarCurr)
     => ( ( v503(VarCurr,bitIndex69)
        <=> v94(VarCurr,bitIndex419) )
        & ( v503(VarCurr,bitIndex68)
        <=> v94(VarCurr,bitIndex418) )
        & ( v503(VarCurr,bitIndex67)
        <=> v94(VarCurr,bitIndex417) )
        & ( v503(VarCurr,bitIndex66)
        <=> v94(VarCurr,bitIndex416) )
        & ( v503(VarCurr,bitIndex65)
        <=> v94(VarCurr,bitIndex415) )
        & ( v503(VarCurr,bitIndex64)
        <=> v94(VarCurr,bitIndex414) )
        & ( v503(VarCurr,bitIndex63)
        <=> v94(VarCurr,bitIndex413) )
        & ( v503(VarCurr,bitIndex62)
        <=> v94(VarCurr,bitIndex412) )
        & ( v503(VarCurr,bitIndex61)
        <=> v94(VarCurr,bitIndex411) )
        & ( v503(VarCurr,bitIndex60)
        <=> v94(VarCurr,bitIndex410) )
        & ( v503(VarCurr,bitIndex59)
        <=> v94(VarCurr,bitIndex409) )
        & ( v503(VarCurr,bitIndex58)
        <=> v94(VarCurr,bitIndex408) )
        & ( v503(VarCurr,bitIndex57)
        <=> v94(VarCurr,bitIndex407) )
        & ( v503(VarCurr,bitIndex56)
        <=> v94(VarCurr,bitIndex406) )
        & ( v503(VarCurr,bitIndex55)
        <=> v94(VarCurr,bitIndex405) )
        & ( v503(VarCurr,bitIndex54)
        <=> v94(VarCurr,bitIndex404) )
        & ( v503(VarCurr,bitIndex53)
        <=> v94(VarCurr,bitIndex403) )
        & ( v503(VarCurr,bitIndex52)
        <=> v94(VarCurr,bitIndex402) )
        & ( v503(VarCurr,bitIndex51)
        <=> v94(VarCurr,bitIndex401) )
        & ( v503(VarCurr,bitIndex50)
        <=> v94(VarCurr,bitIndex400) )
        & ( v503(VarCurr,bitIndex49)
        <=> v94(VarCurr,bitIndex399) )
        & ( v503(VarCurr,bitIndex48)
        <=> v94(VarCurr,bitIndex398) )
        & ( v503(VarCurr,bitIndex47)
        <=> v94(VarCurr,bitIndex397) )
        & ( v503(VarCurr,bitIndex46)
        <=> v94(VarCurr,bitIndex396) )
        & ( v503(VarCurr,bitIndex45)
        <=> v94(VarCurr,bitIndex395) )
        & ( v503(VarCurr,bitIndex44)
        <=> v94(VarCurr,bitIndex394) )
        & ( v503(VarCurr,bitIndex43)
        <=> v94(VarCurr,bitIndex393) )
        & ( v503(VarCurr,bitIndex42)
        <=> v94(VarCurr,bitIndex392) )
        & ( v503(VarCurr,bitIndex41)
        <=> v94(VarCurr,bitIndex391) )
        & ( v503(VarCurr,bitIndex40)
        <=> v94(VarCurr,bitIndex390) )
        & ( v503(VarCurr,bitIndex39)
        <=> v94(VarCurr,bitIndex389) )
        & ( v503(VarCurr,bitIndex38)
        <=> v94(VarCurr,bitIndex388) )
        & ( v503(VarCurr,bitIndex37)
        <=> v94(VarCurr,bitIndex387) )
        & ( v503(VarCurr,bitIndex36)
        <=> v94(VarCurr,bitIndex386) )
        & ( v503(VarCurr,bitIndex35)
        <=> v94(VarCurr,bitIndex385) )
        & ( v503(VarCurr,bitIndex34)
        <=> v94(VarCurr,bitIndex384) )
        & ( v503(VarCurr,bitIndex33)
        <=> v94(VarCurr,bitIndex383) )
        & ( v503(VarCurr,bitIndex32)
        <=> v94(VarCurr,bitIndex382) )
        & ( v503(VarCurr,bitIndex31)
        <=> v94(VarCurr,bitIndex381) )
        & ( v503(VarCurr,bitIndex30)
        <=> v94(VarCurr,bitIndex380) )
        & ( v503(VarCurr,bitIndex29)
        <=> v94(VarCurr,bitIndex379) )
        & ( v503(VarCurr,bitIndex28)
        <=> v94(VarCurr,bitIndex378) )
        & ( v503(VarCurr,bitIndex27)
        <=> v94(VarCurr,bitIndex377) )
        & ( v503(VarCurr,bitIndex26)
        <=> v94(VarCurr,bitIndex376) )
        & ( v503(VarCurr,bitIndex25)
        <=> v94(VarCurr,bitIndex375) )
        & ( v503(VarCurr,bitIndex24)
        <=> v94(VarCurr,bitIndex374) )
        & ( v503(VarCurr,bitIndex23)
        <=> v94(VarCurr,bitIndex373) )
        & ( v503(VarCurr,bitIndex22)
        <=> v94(VarCurr,bitIndex372) )
        & ( v503(VarCurr,bitIndex21)
        <=> v94(VarCurr,bitIndex371) )
        & ( v503(VarCurr,bitIndex20)
        <=> v94(VarCurr,bitIndex370) )
        & ( v503(VarCurr,bitIndex19)
        <=> v94(VarCurr,bitIndex369) )
        & ( v503(VarCurr,bitIndex18)
        <=> v94(VarCurr,bitIndex368) )
        & ( v503(VarCurr,bitIndex17)
        <=> v94(VarCurr,bitIndex367) )
        & ( v503(VarCurr,bitIndex16)
        <=> v94(VarCurr,bitIndex366) )
        & ( v503(VarCurr,bitIndex15)
        <=> v94(VarCurr,bitIndex365) )
        & ( v503(VarCurr,bitIndex14)
        <=> v94(VarCurr,bitIndex364) )
        & ( v503(VarCurr,bitIndex13)
        <=> v94(VarCurr,bitIndex363) )
        & ( v503(VarCurr,bitIndex12)
        <=> v94(VarCurr,bitIndex362) )
        & ( v503(VarCurr,bitIndex11)
        <=> v94(VarCurr,bitIndex361) )
        & ( v503(VarCurr,bitIndex10)
        <=> v94(VarCurr,bitIndex360) )
        & ( v503(VarCurr,bitIndex9)
        <=> v94(VarCurr,bitIndex359) )
        & ( v503(VarCurr,bitIndex8)
        <=> v94(VarCurr,bitIndex358) )
        & ( v503(VarCurr,bitIndex7)
        <=> v94(VarCurr,bitIndex357) )
        & ( v503(VarCurr,bitIndex6)
        <=> v94(VarCurr,bitIndex356) )
        & ( v503(VarCurr,bitIndex5)
        <=> v94(VarCurr,bitIndex355) )
        & ( v503(VarCurr,bitIndex4)
        <=> v94(VarCurr,bitIndex354) )
        & ( v503(VarCurr,bitIndex3)
        <=> v94(VarCurr,bitIndex353) )
        & ( v503(VarCurr,bitIndex2)
        <=> v94(VarCurr,bitIndex352) )
        & ( v503(VarCurr,bitIndex1)
        <=> v94(VarCurr,bitIndex351) )
        & ( v503(VarCurr,bitIndex0)
        <=> v94(VarCurr,bitIndex350) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_67,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v476(VarNext)
      <=> ( v477(VarNext)
          & v484(VarNext) ) ) ) ).

fof(addAssignment_153,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v484(VarNext)
      <=> v482(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_66,axiom,
    ! [VarCurr] :
      ( v482(VarCurr)
    <=> ( v485(VarCurr)
        & v496(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_65,axiom,
    ! [VarCurr] :
      ( v496(VarCurr)
    <=> ( v497(VarCurr)
        | v255(VarCurr) ) ) ).

fof(writeUnaryOperator_30,axiom,
    ! [VarCurr] :
      ( ~ v497(VarCurr)
    <=> v498(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_29,axiom,
    ! [VarCurr] :
      ( v498(VarCurr)
    <=> ( ( v499(VarCurr,bitIndex1)
        <=> $false )
        & ( v499(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_152,axiom,
    ! [VarCurr] :
      ( v499(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_151,axiom,
    ! [VarCurr] :
      ( v499(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_64,axiom,
    ! [VarCurr] :
      ( v485(VarCurr)
    <=> ( v255(VarCurr)
        | v486(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_63,axiom,
    ! [VarCurr] :
      ( v486(VarCurr)
    <=> ( v487(VarCurr)
        & v495(VarCurr) ) ) ).

fof(writeUnaryOperator_29,axiom,
    ! [VarCurr] :
      ( ~ v495(VarCurr)
    <=> v255(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_62,axiom,
    ! [VarCurr] :
      ( v487(VarCurr)
    <=> ( v488(VarCurr)
        | v493(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_28,axiom,
    ! [VarCurr] :
      ( v493(VarCurr)
    <=> ( ( v494(VarCurr,bitIndex1)
        <=> $true )
        & ( v494(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_150,axiom,
    ! [VarCurr] :
      ( v494(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_149,axiom,
    ! [VarCurr] :
      ( v494(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_61,axiom,
    ! [VarCurr] :
      ( v488(VarCurr)
    <=> ( v489(VarCurr)
        | v491(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_27,axiom,
    ! [VarCurr] :
      ( v491(VarCurr)
    <=> ( ( v492(VarCurr,bitIndex1)
        <=> $true )
        & ( v492(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_148,axiom,
    ! [VarCurr] :
      ( v492(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_147,axiom,
    ! [VarCurr] :
      ( v492(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_26,axiom,
    ! [VarCurr] :
      ( v489(VarCurr)
    <=> ( ( v490(VarCurr,bitIndex1)
        <=> $false )
        & ( v490(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_146,axiom,
    ! [VarCurr] :
      ( v490(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_145,axiom,
    ! [VarCurr] :
      ( v490(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_60,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v477(VarNext)
      <=> ( v479(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_28,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v479(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_144,axiom,
    ! [VarCurr] :
      ( v468(VarCurr,bitIndex49)
    <=> v473(VarCurr,bitIndex49) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_14,axiom,
    ! [VarCurr] :
      ( ~ v470(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v473(VarCurr,B)
          <=> v472(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_14,axiom,
    ! [VarCurr] :
      ( v470(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v473(VarCurr,B)
          <=> v212(VarCurr,B) ) ) ) ).

fof(addAssignment_143,axiom,
    ! [VarCurr] :
      ( v472(VarCurr,bitIndex49)
    <=> v94(VarCurr,bitIndex399) ) ).

fof(addAssignment_142,axiom,
    ! [VarCurr] :
      ( v470(VarCurr)
    <=> v103(VarCurr,bitIndex2) ) ).

fof(addAssignment_141,axiom,
    ! [VarCurr] :
      ( v461(VarCurr,bitIndex49)
    <=> v466(VarCurr,bitIndex49) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_13,axiom,
    ! [VarCurr] :
      ( ~ v463(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v466(VarCurr,B)
          <=> v465(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_13,axiom,
    ! [VarCurr] :
      ( v463(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v466(VarCurr,B)
          <=> v212(VarCurr,B) ) ) ) ).

fof(addAssignment_140,axiom,
    ! [VarCurr] :
      ( v465(VarCurr,bitIndex49)
    <=> v94(VarCurr,bitIndex469) ) ).

fof(addAssignment_139,axiom,
    ! [VarCurr] :
      ( v463(VarCurr)
    <=> v103(VarCurr,bitIndex2) ) ).

fof(addAssignment_138,axiom,
    ! [VarNext] :
      ( v94(VarNext,bitIndex399)
    <=> v429(VarNext,bitIndex49) ) ).

fof(addCaseBooleanConditionShiftedRanges1_4,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v430(VarNext)
       => ( ( v429(VarNext,bitIndex69)
          <=> v94(VarCurr,bitIndex419) )
          & ( v429(VarNext,bitIndex68)
          <=> v94(VarCurr,bitIndex418) )
          & ( v429(VarNext,bitIndex67)
          <=> v94(VarCurr,bitIndex417) )
          & ( v429(VarNext,bitIndex66)
          <=> v94(VarCurr,bitIndex416) )
          & ( v429(VarNext,bitIndex65)
          <=> v94(VarCurr,bitIndex415) )
          & ( v429(VarNext,bitIndex64)
          <=> v94(VarCurr,bitIndex414) )
          & ( v429(VarNext,bitIndex63)
          <=> v94(VarCurr,bitIndex413) )
          & ( v429(VarNext,bitIndex62)
          <=> v94(VarCurr,bitIndex412) )
          & ( v429(VarNext,bitIndex61)
          <=> v94(VarCurr,bitIndex411) )
          & ( v429(VarNext,bitIndex60)
          <=> v94(VarCurr,bitIndex410) )
          & ( v429(VarNext,bitIndex59)
          <=> v94(VarCurr,bitIndex409) )
          & ( v429(VarNext,bitIndex58)
          <=> v94(VarCurr,bitIndex408) )
          & ( v429(VarNext,bitIndex57)
          <=> v94(VarCurr,bitIndex407) )
          & ( v429(VarNext,bitIndex56)
          <=> v94(VarCurr,bitIndex406) )
          & ( v429(VarNext,bitIndex55)
          <=> v94(VarCurr,bitIndex405) )
          & ( v429(VarNext,bitIndex54)
          <=> v94(VarCurr,bitIndex404) )
          & ( v429(VarNext,bitIndex53)
          <=> v94(VarCurr,bitIndex403) )
          & ( v429(VarNext,bitIndex52)
          <=> v94(VarCurr,bitIndex402) )
          & ( v429(VarNext,bitIndex51)
          <=> v94(VarCurr,bitIndex401) )
          & ( v429(VarNext,bitIndex50)
          <=> v94(VarCurr,bitIndex400) )
          & ( v429(VarNext,bitIndex49)
          <=> v94(VarCurr,bitIndex399) )
          & ( v429(VarNext,bitIndex48)
          <=> v94(VarCurr,bitIndex398) )
          & ( v429(VarNext,bitIndex47)
          <=> v94(VarCurr,bitIndex397) )
          & ( v429(VarNext,bitIndex46)
          <=> v94(VarCurr,bitIndex396) )
          & ( v429(VarNext,bitIndex45)
          <=> v94(VarCurr,bitIndex395) )
          & ( v429(VarNext,bitIndex44)
          <=> v94(VarCurr,bitIndex394) )
          & ( v429(VarNext,bitIndex43)
          <=> v94(VarCurr,bitIndex393) )
          & ( v429(VarNext,bitIndex42)
          <=> v94(VarCurr,bitIndex392) )
          & ( v429(VarNext,bitIndex41)
          <=> v94(VarCurr,bitIndex391) )
          & ( v429(VarNext,bitIndex40)
          <=> v94(VarCurr,bitIndex390) )
          & ( v429(VarNext,bitIndex39)
          <=> v94(VarCurr,bitIndex389) )
          & ( v429(VarNext,bitIndex38)
          <=> v94(VarCurr,bitIndex388) )
          & ( v429(VarNext,bitIndex37)
          <=> v94(VarCurr,bitIndex387) )
          & ( v429(VarNext,bitIndex36)
          <=> v94(VarCurr,bitIndex386) )
          & ( v429(VarNext,bitIndex35)
          <=> v94(VarCurr,bitIndex385) )
          & ( v429(VarNext,bitIndex34)
          <=> v94(VarCurr,bitIndex384) )
          & ( v429(VarNext,bitIndex33)
          <=> v94(VarCurr,bitIndex383) )
          & ( v429(VarNext,bitIndex32)
          <=> v94(VarCurr,bitIndex382) )
          & ( v429(VarNext,bitIndex31)
          <=> v94(VarCurr,bitIndex381) )
          & ( v429(VarNext,bitIndex30)
          <=> v94(VarCurr,bitIndex380) )
          & ( v429(VarNext,bitIndex29)
          <=> v94(VarCurr,bitIndex379) )
          & ( v429(VarNext,bitIndex28)
          <=> v94(VarCurr,bitIndex378) )
          & ( v429(VarNext,bitIndex27)
          <=> v94(VarCurr,bitIndex377) )
          & ( v429(VarNext,bitIndex26)
          <=> v94(VarCurr,bitIndex376) )
          & ( v429(VarNext,bitIndex25)
          <=> v94(VarCurr,bitIndex375) )
          & ( v429(VarNext,bitIndex24)
          <=> v94(VarCurr,bitIndex374) )
          & ( v429(VarNext,bitIndex23)
          <=> v94(VarCurr,bitIndex373) )
          & ( v429(VarNext,bitIndex22)
          <=> v94(VarCurr,bitIndex372) )
          & ( v429(VarNext,bitIndex21)
          <=> v94(VarCurr,bitIndex371) )
          & ( v429(VarNext,bitIndex20)
          <=> v94(VarCurr,bitIndex370) )
          & ( v429(VarNext,bitIndex19)
          <=> v94(VarCurr,bitIndex369) )
          & ( v429(VarNext,bitIndex18)
          <=> v94(VarCurr,bitIndex368) )
          & ( v429(VarNext,bitIndex17)
          <=> v94(VarCurr,bitIndex367) )
          & ( v429(VarNext,bitIndex16)
          <=> v94(VarCurr,bitIndex366) )
          & ( v429(VarNext,bitIndex15)
          <=> v94(VarCurr,bitIndex365) )
          & ( v429(VarNext,bitIndex14)
          <=> v94(VarCurr,bitIndex364) )
          & ( v429(VarNext,bitIndex13)
          <=> v94(VarCurr,bitIndex363) )
          & ( v429(VarNext,bitIndex12)
          <=> v94(VarCurr,bitIndex362) )
          & ( v429(VarNext,bitIndex11)
          <=> v94(VarCurr,bitIndex361) )
          & ( v429(VarNext,bitIndex10)
          <=> v94(VarCurr,bitIndex360) )
          & ( v429(VarNext,bitIndex9)
          <=> v94(VarCurr,bitIndex359) )
          & ( v429(VarNext,bitIndex8)
          <=> v94(VarCurr,bitIndex358) )
          & ( v429(VarNext,bitIndex7)
          <=> v94(VarCurr,bitIndex357) )
          & ( v429(VarNext,bitIndex6)
          <=> v94(VarCurr,bitIndex356) )
          & ( v429(VarNext,bitIndex5)
          <=> v94(VarCurr,bitIndex355) )
          & ( v429(VarNext,bitIndex4)
          <=> v94(VarCurr,bitIndex354) )
          & ( v429(VarNext,bitIndex3)
          <=> v94(VarCurr,bitIndex353) )
          & ( v429(VarNext,bitIndex2)
          <=> v94(VarCurr,bitIndex352) )
          & ( v429(VarNext,bitIndex1)
          <=> v94(VarCurr,bitIndex351) )
          & ( v429(VarNext,bitIndex0)
          <=> v94(VarCurr,bitIndex350) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_13,axiom,
    ! [VarNext] :
      ( v430(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v429(VarNext,B)
          <=> v456(VarNext,B) ) ) ) ).

fof(addAssignment_137,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v456(VarNext,B)
          <=> v454(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_10,axiom,
    ! [VarCurr] :
      ( ~ v255(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v454(VarCurr,B)
          <=> v457(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_6,axiom,
    ! [VarCurr] :
      ( v255(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v454(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_5,axiom,
    ! [VarCurr] :
      ( ( ~ v443(VarCurr)
        & ~ v445(VarCurr) )
     => ! [B] :
          ( range_69_0(B)
         => ( v457(VarCurr,B)
          <=> v422(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_9,axiom,
    ! [VarCurr] :
      ( v445(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v457(VarCurr,B)
          <=> v415(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_3,axiom,
    ! [VarCurr] :
      ( v443(VarCurr)
     => ( ( v457(VarCurr,bitIndex69)
        <=> v94(VarCurr,bitIndex349) )
        & ( v457(VarCurr,bitIndex68)
        <=> v94(VarCurr,bitIndex348) )
        & ( v457(VarCurr,bitIndex67)
        <=> v94(VarCurr,bitIndex347) )
        & ( v457(VarCurr,bitIndex66)
        <=> v94(VarCurr,bitIndex346) )
        & ( v457(VarCurr,bitIndex65)
        <=> v94(VarCurr,bitIndex345) )
        & ( v457(VarCurr,bitIndex64)
        <=> v94(VarCurr,bitIndex344) )
        & ( v457(VarCurr,bitIndex63)
        <=> v94(VarCurr,bitIndex343) )
        & ( v457(VarCurr,bitIndex62)
        <=> v94(VarCurr,bitIndex342) )
        & ( v457(VarCurr,bitIndex61)
        <=> v94(VarCurr,bitIndex341) )
        & ( v457(VarCurr,bitIndex60)
        <=> v94(VarCurr,bitIndex340) )
        & ( v457(VarCurr,bitIndex59)
        <=> v94(VarCurr,bitIndex339) )
        & ( v457(VarCurr,bitIndex58)
        <=> v94(VarCurr,bitIndex338) )
        & ( v457(VarCurr,bitIndex57)
        <=> v94(VarCurr,bitIndex337) )
        & ( v457(VarCurr,bitIndex56)
        <=> v94(VarCurr,bitIndex336) )
        & ( v457(VarCurr,bitIndex55)
        <=> v94(VarCurr,bitIndex335) )
        & ( v457(VarCurr,bitIndex54)
        <=> v94(VarCurr,bitIndex334) )
        & ( v457(VarCurr,bitIndex53)
        <=> v94(VarCurr,bitIndex333) )
        & ( v457(VarCurr,bitIndex52)
        <=> v94(VarCurr,bitIndex332) )
        & ( v457(VarCurr,bitIndex51)
        <=> v94(VarCurr,bitIndex331) )
        & ( v457(VarCurr,bitIndex50)
        <=> v94(VarCurr,bitIndex330) )
        & ( v457(VarCurr,bitIndex49)
        <=> v94(VarCurr,bitIndex329) )
        & ( v457(VarCurr,bitIndex48)
        <=> v94(VarCurr,bitIndex328) )
        & ( v457(VarCurr,bitIndex47)
        <=> v94(VarCurr,bitIndex327) )
        & ( v457(VarCurr,bitIndex46)
        <=> v94(VarCurr,bitIndex326) )
        & ( v457(VarCurr,bitIndex45)
        <=> v94(VarCurr,bitIndex325) )
        & ( v457(VarCurr,bitIndex44)
        <=> v94(VarCurr,bitIndex324) )
        & ( v457(VarCurr,bitIndex43)
        <=> v94(VarCurr,bitIndex323) )
        & ( v457(VarCurr,bitIndex42)
        <=> v94(VarCurr,bitIndex322) )
        & ( v457(VarCurr,bitIndex41)
        <=> v94(VarCurr,bitIndex321) )
        & ( v457(VarCurr,bitIndex40)
        <=> v94(VarCurr,bitIndex320) )
        & ( v457(VarCurr,bitIndex39)
        <=> v94(VarCurr,bitIndex319) )
        & ( v457(VarCurr,bitIndex38)
        <=> v94(VarCurr,bitIndex318) )
        & ( v457(VarCurr,bitIndex37)
        <=> v94(VarCurr,bitIndex317) )
        & ( v457(VarCurr,bitIndex36)
        <=> v94(VarCurr,bitIndex316) )
        & ( v457(VarCurr,bitIndex35)
        <=> v94(VarCurr,bitIndex315) )
        & ( v457(VarCurr,bitIndex34)
        <=> v94(VarCurr,bitIndex314) )
        & ( v457(VarCurr,bitIndex33)
        <=> v94(VarCurr,bitIndex313) )
        & ( v457(VarCurr,bitIndex32)
        <=> v94(VarCurr,bitIndex312) )
        & ( v457(VarCurr,bitIndex31)
        <=> v94(VarCurr,bitIndex311) )
        & ( v457(VarCurr,bitIndex30)
        <=> v94(VarCurr,bitIndex310) )
        & ( v457(VarCurr,bitIndex29)
        <=> v94(VarCurr,bitIndex309) )
        & ( v457(VarCurr,bitIndex28)
        <=> v94(VarCurr,bitIndex308) )
        & ( v457(VarCurr,bitIndex27)
        <=> v94(VarCurr,bitIndex307) )
        & ( v457(VarCurr,bitIndex26)
        <=> v94(VarCurr,bitIndex306) )
        & ( v457(VarCurr,bitIndex25)
        <=> v94(VarCurr,bitIndex305) )
        & ( v457(VarCurr,bitIndex24)
        <=> v94(VarCurr,bitIndex304) )
        & ( v457(VarCurr,bitIndex23)
        <=> v94(VarCurr,bitIndex303) )
        & ( v457(VarCurr,bitIndex22)
        <=> v94(VarCurr,bitIndex302) )
        & ( v457(VarCurr,bitIndex21)
        <=> v94(VarCurr,bitIndex301) )
        & ( v457(VarCurr,bitIndex20)
        <=> v94(VarCurr,bitIndex300) )
        & ( v457(VarCurr,bitIndex19)
        <=> v94(VarCurr,bitIndex299) )
        & ( v457(VarCurr,bitIndex18)
        <=> v94(VarCurr,bitIndex298) )
        & ( v457(VarCurr,bitIndex17)
        <=> v94(VarCurr,bitIndex297) )
        & ( v457(VarCurr,bitIndex16)
        <=> v94(VarCurr,bitIndex296) )
        & ( v457(VarCurr,bitIndex15)
        <=> v94(VarCurr,bitIndex295) )
        & ( v457(VarCurr,bitIndex14)
        <=> v94(VarCurr,bitIndex294) )
        & ( v457(VarCurr,bitIndex13)
        <=> v94(VarCurr,bitIndex293) )
        & ( v457(VarCurr,bitIndex12)
        <=> v94(VarCurr,bitIndex292) )
        & ( v457(VarCurr,bitIndex11)
        <=> v94(VarCurr,bitIndex291) )
        & ( v457(VarCurr,bitIndex10)
        <=> v94(VarCurr,bitIndex290) )
        & ( v457(VarCurr,bitIndex9)
        <=> v94(VarCurr,bitIndex289) )
        & ( v457(VarCurr,bitIndex8)
        <=> v94(VarCurr,bitIndex288) )
        & ( v457(VarCurr,bitIndex7)
        <=> v94(VarCurr,bitIndex287) )
        & ( v457(VarCurr,bitIndex6)
        <=> v94(VarCurr,bitIndex286) )
        & ( v457(VarCurr,bitIndex5)
        <=> v94(VarCurr,bitIndex285) )
        & ( v457(VarCurr,bitIndex4)
        <=> v94(VarCurr,bitIndex284) )
        & ( v457(VarCurr,bitIndex3)
        <=> v94(VarCurr,bitIndex283) )
        & ( v457(VarCurr,bitIndex2)
        <=> v94(VarCurr,bitIndex282) )
        & ( v457(VarCurr,bitIndex1)
        <=> v94(VarCurr,bitIndex281) )
        & ( v457(VarCurr,bitIndex0)
        <=> v94(VarCurr,bitIndex280) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_59,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v430(VarNext)
      <=> ( v431(VarNext)
          & v438(VarNext) ) ) ) ).

fof(addAssignment_136,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v438(VarNext)
      <=> v436(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_58,axiom,
    ! [VarCurr] :
      ( v436(VarCurr)
    <=> ( v439(VarCurr)
        & v450(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_57,axiom,
    ! [VarCurr] :
      ( v450(VarCurr)
    <=> ( v451(VarCurr)
        | v255(VarCurr) ) ) ).

fof(writeUnaryOperator_27,axiom,
    ! [VarCurr] :
      ( ~ v451(VarCurr)
    <=> v452(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_25,axiom,
    ! [VarCurr] :
      ( v452(VarCurr)
    <=> ( ( v453(VarCurr,bitIndex1)
        <=> $false )
        & ( v453(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_135,axiom,
    ! [VarCurr] :
      ( v453(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_134,axiom,
    ! [VarCurr] :
      ( v453(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_56,axiom,
    ! [VarCurr] :
      ( v439(VarCurr)
    <=> ( v255(VarCurr)
        | v440(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_55,axiom,
    ! [VarCurr] :
      ( v440(VarCurr)
    <=> ( v441(VarCurr)
        & v449(VarCurr) ) ) ).

fof(writeUnaryOperator_26,axiom,
    ! [VarCurr] :
      ( ~ v449(VarCurr)
    <=> v255(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_54,axiom,
    ! [VarCurr] :
      ( v441(VarCurr)
    <=> ( v442(VarCurr)
        | v447(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_24,axiom,
    ! [VarCurr] :
      ( v447(VarCurr)
    <=> ( ( v448(VarCurr,bitIndex1)
        <=> $true )
        & ( v448(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_133,axiom,
    ! [VarCurr] :
      ( v448(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_132,axiom,
    ! [VarCurr] :
      ( v448(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_53,axiom,
    ! [VarCurr] :
      ( v442(VarCurr)
    <=> ( v443(VarCurr)
        | v445(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_23,axiom,
    ! [VarCurr] :
      ( v445(VarCurr)
    <=> ( ( v446(VarCurr,bitIndex1)
        <=> $true )
        & ( v446(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_131,axiom,
    ! [VarCurr] :
      ( v446(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_130,axiom,
    ! [VarCurr] :
      ( v446(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_22,axiom,
    ! [VarCurr] :
      ( v443(VarCurr)
    <=> ( ( v444(VarCurr,bitIndex1)
        <=> $false )
        & ( v444(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_129,axiom,
    ! [VarCurr] :
      ( v444(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_128,axiom,
    ! [VarCurr] :
      ( v444(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_52,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v431(VarNext)
      <=> ( v433(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_25,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v433(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_127,axiom,
    ! [VarCurr] :
      ( v422(VarCurr,bitIndex49)
    <=> v427(VarCurr,bitIndex49) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_12,axiom,
    ! [VarCurr] :
      ( ~ v424(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v427(VarCurr,B)
          <=> v426(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_12,axiom,
    ! [VarCurr] :
      ( v424(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v427(VarCurr,B)
          <=> v212(VarCurr,B) ) ) ) ).

fof(addAssignment_126,axiom,
    ! [VarCurr] :
      ( v426(VarCurr,bitIndex49)
    <=> v94(VarCurr,bitIndex329) ) ).

fof(addAssignment_125,axiom,
    ! [VarCurr] :
      ( v424(VarCurr)
    <=> v103(VarCurr,bitIndex3) ) ).

fof(addAssignment_124,axiom,
    ! [VarCurr] :
      ( v415(VarCurr,bitIndex49)
    <=> v420(VarCurr,bitIndex49) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_11,axiom,
    ! [VarCurr] :
      ( ~ v417(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v420(VarCurr,B)
          <=> v419(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_11,axiom,
    ! [VarCurr] :
      ( v417(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v420(VarCurr,B)
          <=> v212(VarCurr,B) ) ) ) ).

fof(addAssignment_123,axiom,
    ! [VarCurr] :
      ( v419(VarCurr,bitIndex49)
    <=> v94(VarCurr,bitIndex399) ) ).

fof(addAssignment_122,axiom,
    ! [VarCurr] :
      ( v417(VarCurr)
    <=> v103(VarCurr,bitIndex3) ) ).

fof(addAssignment_121,axiom,
    ! [VarNext] :
      ( v94(VarNext,bitIndex329)
    <=> v383(VarNext,bitIndex49) ) ).

fof(addCaseBooleanConditionShiftedRanges1_3,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v384(VarNext)
       => ( ( v383(VarNext,bitIndex69)
          <=> v94(VarCurr,bitIndex349) )
          & ( v383(VarNext,bitIndex68)
          <=> v94(VarCurr,bitIndex348) )
          & ( v383(VarNext,bitIndex67)
          <=> v94(VarCurr,bitIndex347) )
          & ( v383(VarNext,bitIndex66)
          <=> v94(VarCurr,bitIndex346) )
          & ( v383(VarNext,bitIndex65)
          <=> v94(VarCurr,bitIndex345) )
          & ( v383(VarNext,bitIndex64)
          <=> v94(VarCurr,bitIndex344) )
          & ( v383(VarNext,bitIndex63)
          <=> v94(VarCurr,bitIndex343) )
          & ( v383(VarNext,bitIndex62)
          <=> v94(VarCurr,bitIndex342) )
          & ( v383(VarNext,bitIndex61)
          <=> v94(VarCurr,bitIndex341) )
          & ( v383(VarNext,bitIndex60)
          <=> v94(VarCurr,bitIndex340) )
          & ( v383(VarNext,bitIndex59)
          <=> v94(VarCurr,bitIndex339) )
          & ( v383(VarNext,bitIndex58)
          <=> v94(VarCurr,bitIndex338) )
          & ( v383(VarNext,bitIndex57)
          <=> v94(VarCurr,bitIndex337) )
          & ( v383(VarNext,bitIndex56)
          <=> v94(VarCurr,bitIndex336) )
          & ( v383(VarNext,bitIndex55)
          <=> v94(VarCurr,bitIndex335) )
          & ( v383(VarNext,bitIndex54)
          <=> v94(VarCurr,bitIndex334) )
          & ( v383(VarNext,bitIndex53)
          <=> v94(VarCurr,bitIndex333) )
          & ( v383(VarNext,bitIndex52)
          <=> v94(VarCurr,bitIndex332) )
          & ( v383(VarNext,bitIndex51)
          <=> v94(VarCurr,bitIndex331) )
          & ( v383(VarNext,bitIndex50)
          <=> v94(VarCurr,bitIndex330) )
          & ( v383(VarNext,bitIndex49)
          <=> v94(VarCurr,bitIndex329) )
          & ( v383(VarNext,bitIndex48)
          <=> v94(VarCurr,bitIndex328) )
          & ( v383(VarNext,bitIndex47)
          <=> v94(VarCurr,bitIndex327) )
          & ( v383(VarNext,bitIndex46)
          <=> v94(VarCurr,bitIndex326) )
          & ( v383(VarNext,bitIndex45)
          <=> v94(VarCurr,bitIndex325) )
          & ( v383(VarNext,bitIndex44)
          <=> v94(VarCurr,bitIndex324) )
          & ( v383(VarNext,bitIndex43)
          <=> v94(VarCurr,bitIndex323) )
          & ( v383(VarNext,bitIndex42)
          <=> v94(VarCurr,bitIndex322) )
          & ( v383(VarNext,bitIndex41)
          <=> v94(VarCurr,bitIndex321) )
          & ( v383(VarNext,bitIndex40)
          <=> v94(VarCurr,bitIndex320) )
          & ( v383(VarNext,bitIndex39)
          <=> v94(VarCurr,bitIndex319) )
          & ( v383(VarNext,bitIndex38)
          <=> v94(VarCurr,bitIndex318) )
          & ( v383(VarNext,bitIndex37)
          <=> v94(VarCurr,bitIndex317) )
          & ( v383(VarNext,bitIndex36)
          <=> v94(VarCurr,bitIndex316) )
          & ( v383(VarNext,bitIndex35)
          <=> v94(VarCurr,bitIndex315) )
          & ( v383(VarNext,bitIndex34)
          <=> v94(VarCurr,bitIndex314) )
          & ( v383(VarNext,bitIndex33)
          <=> v94(VarCurr,bitIndex313) )
          & ( v383(VarNext,bitIndex32)
          <=> v94(VarCurr,bitIndex312) )
          & ( v383(VarNext,bitIndex31)
          <=> v94(VarCurr,bitIndex311) )
          & ( v383(VarNext,bitIndex30)
          <=> v94(VarCurr,bitIndex310) )
          & ( v383(VarNext,bitIndex29)
          <=> v94(VarCurr,bitIndex309) )
          & ( v383(VarNext,bitIndex28)
          <=> v94(VarCurr,bitIndex308) )
          & ( v383(VarNext,bitIndex27)
          <=> v94(VarCurr,bitIndex307) )
          & ( v383(VarNext,bitIndex26)
          <=> v94(VarCurr,bitIndex306) )
          & ( v383(VarNext,bitIndex25)
          <=> v94(VarCurr,bitIndex305) )
          & ( v383(VarNext,bitIndex24)
          <=> v94(VarCurr,bitIndex304) )
          & ( v383(VarNext,bitIndex23)
          <=> v94(VarCurr,bitIndex303) )
          & ( v383(VarNext,bitIndex22)
          <=> v94(VarCurr,bitIndex302) )
          & ( v383(VarNext,bitIndex21)
          <=> v94(VarCurr,bitIndex301) )
          & ( v383(VarNext,bitIndex20)
          <=> v94(VarCurr,bitIndex300) )
          & ( v383(VarNext,bitIndex19)
          <=> v94(VarCurr,bitIndex299) )
          & ( v383(VarNext,bitIndex18)
          <=> v94(VarCurr,bitIndex298) )
          & ( v383(VarNext,bitIndex17)
          <=> v94(VarCurr,bitIndex297) )
          & ( v383(VarNext,bitIndex16)
          <=> v94(VarCurr,bitIndex296) )
          & ( v383(VarNext,bitIndex15)
          <=> v94(VarCurr,bitIndex295) )
          & ( v383(VarNext,bitIndex14)
          <=> v94(VarCurr,bitIndex294) )
          & ( v383(VarNext,bitIndex13)
          <=> v94(VarCurr,bitIndex293) )
          & ( v383(VarNext,bitIndex12)
          <=> v94(VarCurr,bitIndex292) )
          & ( v383(VarNext,bitIndex11)
          <=> v94(VarCurr,bitIndex291) )
          & ( v383(VarNext,bitIndex10)
          <=> v94(VarCurr,bitIndex290) )
          & ( v383(VarNext,bitIndex9)
          <=> v94(VarCurr,bitIndex289) )
          & ( v383(VarNext,bitIndex8)
          <=> v94(VarCurr,bitIndex288) )
          & ( v383(VarNext,bitIndex7)
          <=> v94(VarCurr,bitIndex287) )
          & ( v383(VarNext,bitIndex6)
          <=> v94(VarCurr,bitIndex286) )
          & ( v383(VarNext,bitIndex5)
          <=> v94(VarCurr,bitIndex285) )
          & ( v383(VarNext,bitIndex4)
          <=> v94(VarCurr,bitIndex284) )
          & ( v383(VarNext,bitIndex3)
          <=> v94(VarCurr,bitIndex283) )
          & ( v383(VarNext,bitIndex2)
          <=> v94(VarCurr,bitIndex282) )
          & ( v383(VarNext,bitIndex1)
          <=> v94(VarCurr,bitIndex281) )
          & ( v383(VarNext,bitIndex0)
          <=> v94(VarCurr,bitIndex280) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_12,axiom,
    ! [VarNext] :
      ( v384(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v383(VarNext,B)
          <=> v410(VarNext,B) ) ) ) ).

fof(addAssignment_120,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v410(VarNext,B)
          <=> v408(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_8,axiom,
    ! [VarCurr] :
      ( ~ v255(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v408(VarCurr,B)
          <=> v411(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5,axiom,
    ! [VarCurr] :
      ( v255(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v408(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_4,axiom,
    ! [VarCurr] :
      ( ( ~ v397(VarCurr)
        & ~ v399(VarCurr) )
     => ! [B] :
          ( range_69_0(B)
         => ( v411(VarCurr,B)
          <=> v376(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_7,axiom,
    ! [VarCurr] :
      ( v399(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v411(VarCurr,B)
          <=> v369(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_2,axiom,
    ! [VarCurr] :
      ( v397(VarCurr)
     => ( ( v411(VarCurr,bitIndex69)
        <=> v94(VarCurr,bitIndex279) )
        & ( v411(VarCurr,bitIndex68)
        <=> v94(VarCurr,bitIndex278) )
        & ( v411(VarCurr,bitIndex67)
        <=> v94(VarCurr,bitIndex277) )
        & ( v411(VarCurr,bitIndex66)
        <=> v94(VarCurr,bitIndex276) )
        & ( v411(VarCurr,bitIndex65)
        <=> v94(VarCurr,bitIndex275) )
        & ( v411(VarCurr,bitIndex64)
        <=> v94(VarCurr,bitIndex274) )
        & ( v411(VarCurr,bitIndex63)
        <=> v94(VarCurr,bitIndex273) )
        & ( v411(VarCurr,bitIndex62)
        <=> v94(VarCurr,bitIndex272) )
        & ( v411(VarCurr,bitIndex61)
        <=> v94(VarCurr,bitIndex271) )
        & ( v411(VarCurr,bitIndex60)
        <=> v94(VarCurr,bitIndex270) )
        & ( v411(VarCurr,bitIndex59)
        <=> v94(VarCurr,bitIndex269) )
        & ( v411(VarCurr,bitIndex58)
        <=> v94(VarCurr,bitIndex268) )
        & ( v411(VarCurr,bitIndex57)
        <=> v94(VarCurr,bitIndex267) )
        & ( v411(VarCurr,bitIndex56)
        <=> v94(VarCurr,bitIndex266) )
        & ( v411(VarCurr,bitIndex55)
        <=> v94(VarCurr,bitIndex265) )
        & ( v411(VarCurr,bitIndex54)
        <=> v94(VarCurr,bitIndex264) )
        & ( v411(VarCurr,bitIndex53)
        <=> v94(VarCurr,bitIndex263) )
        & ( v411(VarCurr,bitIndex52)
        <=> v94(VarCurr,bitIndex262) )
        & ( v411(VarCurr,bitIndex51)
        <=> v94(VarCurr,bitIndex261) )
        & ( v411(VarCurr,bitIndex50)
        <=> v94(VarCurr,bitIndex260) )
        & ( v411(VarCurr,bitIndex49)
        <=> v94(VarCurr,bitIndex259) )
        & ( v411(VarCurr,bitIndex48)
        <=> v94(VarCurr,bitIndex258) )
        & ( v411(VarCurr,bitIndex47)
        <=> v94(VarCurr,bitIndex257) )
        & ( v411(VarCurr,bitIndex46)
        <=> v94(VarCurr,bitIndex256) )
        & ( v411(VarCurr,bitIndex45)
        <=> v94(VarCurr,bitIndex255) )
        & ( v411(VarCurr,bitIndex44)
        <=> v94(VarCurr,bitIndex254) )
        & ( v411(VarCurr,bitIndex43)
        <=> v94(VarCurr,bitIndex253) )
        & ( v411(VarCurr,bitIndex42)
        <=> v94(VarCurr,bitIndex252) )
        & ( v411(VarCurr,bitIndex41)
        <=> v94(VarCurr,bitIndex251) )
        & ( v411(VarCurr,bitIndex40)
        <=> v94(VarCurr,bitIndex250) )
        & ( v411(VarCurr,bitIndex39)
        <=> v94(VarCurr,bitIndex249) )
        & ( v411(VarCurr,bitIndex38)
        <=> v94(VarCurr,bitIndex248) )
        & ( v411(VarCurr,bitIndex37)
        <=> v94(VarCurr,bitIndex247) )
        & ( v411(VarCurr,bitIndex36)
        <=> v94(VarCurr,bitIndex246) )
        & ( v411(VarCurr,bitIndex35)
        <=> v94(VarCurr,bitIndex245) )
        & ( v411(VarCurr,bitIndex34)
        <=> v94(VarCurr,bitIndex244) )
        & ( v411(VarCurr,bitIndex33)
        <=> v94(VarCurr,bitIndex243) )
        & ( v411(VarCurr,bitIndex32)
        <=> v94(VarCurr,bitIndex242) )
        & ( v411(VarCurr,bitIndex31)
        <=> v94(VarCurr,bitIndex241) )
        & ( v411(VarCurr,bitIndex30)
        <=> v94(VarCurr,bitIndex240) )
        & ( v411(VarCurr,bitIndex29)
        <=> v94(VarCurr,bitIndex239) )
        & ( v411(VarCurr,bitIndex28)
        <=> v94(VarCurr,bitIndex238) )
        & ( v411(VarCurr,bitIndex27)
        <=> v94(VarCurr,bitIndex237) )
        & ( v411(VarCurr,bitIndex26)
        <=> v94(VarCurr,bitIndex236) )
        & ( v411(VarCurr,bitIndex25)
        <=> v94(VarCurr,bitIndex235) )
        & ( v411(VarCurr,bitIndex24)
        <=> v94(VarCurr,bitIndex234) )
        & ( v411(VarCurr,bitIndex23)
        <=> v94(VarCurr,bitIndex233) )
        & ( v411(VarCurr,bitIndex22)
        <=> v94(VarCurr,bitIndex232) )
        & ( v411(VarCurr,bitIndex21)
        <=> v94(VarCurr,bitIndex231) )
        & ( v411(VarCurr,bitIndex20)
        <=> v94(VarCurr,bitIndex230) )
        & ( v411(VarCurr,bitIndex19)
        <=> v94(VarCurr,bitIndex229) )
        & ( v411(VarCurr,bitIndex18)
        <=> v94(VarCurr,bitIndex228) )
        & ( v411(VarCurr,bitIndex17)
        <=> v94(VarCurr,bitIndex227) )
        & ( v411(VarCurr,bitIndex16)
        <=> v94(VarCurr,bitIndex226) )
        & ( v411(VarCurr,bitIndex15)
        <=> v94(VarCurr,bitIndex225) )
        & ( v411(VarCurr,bitIndex14)
        <=> v94(VarCurr,bitIndex224) )
        & ( v411(VarCurr,bitIndex13)
        <=> v94(VarCurr,bitIndex223) )
        & ( v411(VarCurr,bitIndex12)
        <=> v94(VarCurr,bitIndex222) )
        & ( v411(VarCurr,bitIndex11)
        <=> v94(VarCurr,bitIndex221) )
        & ( v411(VarCurr,bitIndex10)
        <=> v94(VarCurr,bitIndex220) )
        & ( v411(VarCurr,bitIndex9)
        <=> v94(VarCurr,bitIndex219) )
        & ( v411(VarCurr,bitIndex8)
        <=> v94(VarCurr,bitIndex218) )
        & ( v411(VarCurr,bitIndex7)
        <=> v94(VarCurr,bitIndex217) )
        & ( v411(VarCurr,bitIndex6)
        <=> v94(VarCurr,bitIndex216) )
        & ( v411(VarCurr,bitIndex5)
        <=> v94(VarCurr,bitIndex215) )
        & ( v411(VarCurr,bitIndex4)
        <=> v94(VarCurr,bitIndex214) )
        & ( v411(VarCurr,bitIndex3)
        <=> v94(VarCurr,bitIndex213) )
        & ( v411(VarCurr,bitIndex2)
        <=> v94(VarCurr,bitIndex212) )
        & ( v411(VarCurr,bitIndex1)
        <=> v94(VarCurr,bitIndex211) )
        & ( v411(VarCurr,bitIndex0)
        <=> v94(VarCurr,bitIndex210) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_51,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v384(VarNext)
      <=> ( v385(VarNext)
          & v392(VarNext) ) ) ) ).

fof(addAssignment_119,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v392(VarNext)
      <=> v390(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_50,axiom,
    ! [VarCurr] :
      ( v390(VarCurr)
    <=> ( v393(VarCurr)
        & v404(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_49,axiom,
    ! [VarCurr] :
      ( v404(VarCurr)
    <=> ( v405(VarCurr)
        | v255(VarCurr) ) ) ).

fof(writeUnaryOperator_24,axiom,
    ! [VarCurr] :
      ( ~ v405(VarCurr)
    <=> v406(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_21,axiom,
    ! [VarCurr] :
      ( v406(VarCurr)
    <=> ( ( v407(VarCurr,bitIndex1)
        <=> $false )
        & ( v407(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_118,axiom,
    ! [VarCurr] :
      ( v407(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_117,axiom,
    ! [VarCurr] :
      ( v407(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_48,axiom,
    ! [VarCurr] :
      ( v393(VarCurr)
    <=> ( v255(VarCurr)
        | v394(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_47,axiom,
    ! [VarCurr] :
      ( v394(VarCurr)
    <=> ( v395(VarCurr)
        & v403(VarCurr) ) ) ).

fof(writeUnaryOperator_23,axiom,
    ! [VarCurr] :
      ( ~ v403(VarCurr)
    <=> v255(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_46,axiom,
    ! [VarCurr] :
      ( v395(VarCurr)
    <=> ( v396(VarCurr)
        | v401(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_20,axiom,
    ! [VarCurr] :
      ( v401(VarCurr)
    <=> ( ( v402(VarCurr,bitIndex1)
        <=> $true )
        & ( v402(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_116,axiom,
    ! [VarCurr] :
      ( v402(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_115,axiom,
    ! [VarCurr] :
      ( v402(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_45,axiom,
    ! [VarCurr] :
      ( v396(VarCurr)
    <=> ( v397(VarCurr)
        | v399(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_19,axiom,
    ! [VarCurr] :
      ( v399(VarCurr)
    <=> ( ( v400(VarCurr,bitIndex1)
        <=> $true )
        & ( v400(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_114,axiom,
    ! [VarCurr] :
      ( v400(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_113,axiom,
    ! [VarCurr] :
      ( v400(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_18,axiom,
    ! [VarCurr] :
      ( v397(VarCurr)
    <=> ( ( v398(VarCurr,bitIndex1)
        <=> $false )
        & ( v398(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_112,axiom,
    ! [VarCurr] :
      ( v398(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_111,axiom,
    ! [VarCurr] :
      ( v398(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_44,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v385(VarNext)
      <=> ( v387(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_22,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v387(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_110,axiom,
    ! [VarCurr] :
      ( v376(VarCurr,bitIndex49)
    <=> v381(VarCurr,bitIndex49) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_10,axiom,
    ! [VarCurr] :
      ( ~ v378(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v381(VarCurr,B)
          <=> v380(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_10,axiom,
    ! [VarCurr] :
      ( v378(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v381(VarCurr,B)
          <=> v212(VarCurr,B) ) ) ) ).

fof(addAssignment_109,axiom,
    ! [VarCurr] :
      ( v380(VarCurr,bitIndex49)
    <=> v94(VarCurr,bitIndex259) ) ).

fof(addAssignment_108,axiom,
    ! [VarCurr] :
      ( v378(VarCurr)
    <=> v103(VarCurr,bitIndex4) ) ).

fof(addAssignment_107,axiom,
    ! [VarCurr] :
      ( v369(VarCurr,bitIndex49)
    <=> v374(VarCurr,bitIndex49) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_9,axiom,
    ! [VarCurr] :
      ( ~ v371(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v374(VarCurr,B)
          <=> v373(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_9,axiom,
    ! [VarCurr] :
      ( v371(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v374(VarCurr,B)
          <=> v212(VarCurr,B) ) ) ) ).

fof(addAssignment_106,axiom,
    ! [VarCurr] :
      ( v373(VarCurr,bitIndex49)
    <=> v94(VarCurr,bitIndex329) ) ).

fof(addAssignment_105,axiom,
    ! [VarCurr] :
      ( v371(VarCurr)
    <=> v103(VarCurr,bitIndex4) ) ).

fof(addAssignment_104,axiom,
    ! [VarNext] :
      ( v94(VarNext,bitIndex259)
    <=> v337(VarNext,bitIndex49) ) ).

fof(addCaseBooleanConditionShiftedRanges1_2,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v338(VarNext)
       => ( ( v337(VarNext,bitIndex69)
          <=> v94(VarCurr,bitIndex279) )
          & ( v337(VarNext,bitIndex68)
          <=> v94(VarCurr,bitIndex278) )
          & ( v337(VarNext,bitIndex67)
          <=> v94(VarCurr,bitIndex277) )
          & ( v337(VarNext,bitIndex66)
          <=> v94(VarCurr,bitIndex276) )
          & ( v337(VarNext,bitIndex65)
          <=> v94(VarCurr,bitIndex275) )
          & ( v337(VarNext,bitIndex64)
          <=> v94(VarCurr,bitIndex274) )
          & ( v337(VarNext,bitIndex63)
          <=> v94(VarCurr,bitIndex273) )
          & ( v337(VarNext,bitIndex62)
          <=> v94(VarCurr,bitIndex272) )
          & ( v337(VarNext,bitIndex61)
          <=> v94(VarCurr,bitIndex271) )
          & ( v337(VarNext,bitIndex60)
          <=> v94(VarCurr,bitIndex270) )
          & ( v337(VarNext,bitIndex59)
          <=> v94(VarCurr,bitIndex269) )
          & ( v337(VarNext,bitIndex58)
          <=> v94(VarCurr,bitIndex268) )
          & ( v337(VarNext,bitIndex57)
          <=> v94(VarCurr,bitIndex267) )
          & ( v337(VarNext,bitIndex56)
          <=> v94(VarCurr,bitIndex266) )
          & ( v337(VarNext,bitIndex55)
          <=> v94(VarCurr,bitIndex265) )
          & ( v337(VarNext,bitIndex54)
          <=> v94(VarCurr,bitIndex264) )
          & ( v337(VarNext,bitIndex53)
          <=> v94(VarCurr,bitIndex263) )
          & ( v337(VarNext,bitIndex52)
          <=> v94(VarCurr,bitIndex262) )
          & ( v337(VarNext,bitIndex51)
          <=> v94(VarCurr,bitIndex261) )
          & ( v337(VarNext,bitIndex50)
          <=> v94(VarCurr,bitIndex260) )
          & ( v337(VarNext,bitIndex49)
          <=> v94(VarCurr,bitIndex259) )
          & ( v337(VarNext,bitIndex48)
          <=> v94(VarCurr,bitIndex258) )
          & ( v337(VarNext,bitIndex47)
          <=> v94(VarCurr,bitIndex257) )
          & ( v337(VarNext,bitIndex46)
          <=> v94(VarCurr,bitIndex256) )
          & ( v337(VarNext,bitIndex45)
          <=> v94(VarCurr,bitIndex255) )
          & ( v337(VarNext,bitIndex44)
          <=> v94(VarCurr,bitIndex254) )
          & ( v337(VarNext,bitIndex43)
          <=> v94(VarCurr,bitIndex253) )
          & ( v337(VarNext,bitIndex42)
          <=> v94(VarCurr,bitIndex252) )
          & ( v337(VarNext,bitIndex41)
          <=> v94(VarCurr,bitIndex251) )
          & ( v337(VarNext,bitIndex40)
          <=> v94(VarCurr,bitIndex250) )
          & ( v337(VarNext,bitIndex39)
          <=> v94(VarCurr,bitIndex249) )
          & ( v337(VarNext,bitIndex38)
          <=> v94(VarCurr,bitIndex248) )
          & ( v337(VarNext,bitIndex37)
          <=> v94(VarCurr,bitIndex247) )
          & ( v337(VarNext,bitIndex36)
          <=> v94(VarCurr,bitIndex246) )
          & ( v337(VarNext,bitIndex35)
          <=> v94(VarCurr,bitIndex245) )
          & ( v337(VarNext,bitIndex34)
          <=> v94(VarCurr,bitIndex244) )
          & ( v337(VarNext,bitIndex33)
          <=> v94(VarCurr,bitIndex243) )
          & ( v337(VarNext,bitIndex32)
          <=> v94(VarCurr,bitIndex242) )
          & ( v337(VarNext,bitIndex31)
          <=> v94(VarCurr,bitIndex241) )
          & ( v337(VarNext,bitIndex30)
          <=> v94(VarCurr,bitIndex240) )
          & ( v337(VarNext,bitIndex29)
          <=> v94(VarCurr,bitIndex239) )
          & ( v337(VarNext,bitIndex28)
          <=> v94(VarCurr,bitIndex238) )
          & ( v337(VarNext,bitIndex27)
          <=> v94(VarCurr,bitIndex237) )
          & ( v337(VarNext,bitIndex26)
          <=> v94(VarCurr,bitIndex236) )
          & ( v337(VarNext,bitIndex25)
          <=> v94(VarCurr,bitIndex235) )
          & ( v337(VarNext,bitIndex24)
          <=> v94(VarCurr,bitIndex234) )
          & ( v337(VarNext,bitIndex23)
          <=> v94(VarCurr,bitIndex233) )
          & ( v337(VarNext,bitIndex22)
          <=> v94(VarCurr,bitIndex232) )
          & ( v337(VarNext,bitIndex21)
          <=> v94(VarCurr,bitIndex231) )
          & ( v337(VarNext,bitIndex20)
          <=> v94(VarCurr,bitIndex230) )
          & ( v337(VarNext,bitIndex19)
          <=> v94(VarCurr,bitIndex229) )
          & ( v337(VarNext,bitIndex18)
          <=> v94(VarCurr,bitIndex228) )
          & ( v337(VarNext,bitIndex17)
          <=> v94(VarCurr,bitIndex227) )
          & ( v337(VarNext,bitIndex16)
          <=> v94(VarCurr,bitIndex226) )
          & ( v337(VarNext,bitIndex15)
          <=> v94(VarCurr,bitIndex225) )
          & ( v337(VarNext,bitIndex14)
          <=> v94(VarCurr,bitIndex224) )
          & ( v337(VarNext,bitIndex13)
          <=> v94(VarCurr,bitIndex223) )
          & ( v337(VarNext,bitIndex12)
          <=> v94(VarCurr,bitIndex222) )
          & ( v337(VarNext,bitIndex11)
          <=> v94(VarCurr,bitIndex221) )
          & ( v337(VarNext,bitIndex10)
          <=> v94(VarCurr,bitIndex220) )
          & ( v337(VarNext,bitIndex9)
          <=> v94(VarCurr,bitIndex219) )
          & ( v337(VarNext,bitIndex8)
          <=> v94(VarCurr,bitIndex218) )
          & ( v337(VarNext,bitIndex7)
          <=> v94(VarCurr,bitIndex217) )
          & ( v337(VarNext,bitIndex6)
          <=> v94(VarCurr,bitIndex216) )
          & ( v337(VarNext,bitIndex5)
          <=> v94(VarCurr,bitIndex215) )
          & ( v337(VarNext,bitIndex4)
          <=> v94(VarCurr,bitIndex214) )
          & ( v337(VarNext,bitIndex3)
          <=> v94(VarCurr,bitIndex213) )
          & ( v337(VarNext,bitIndex2)
          <=> v94(VarCurr,bitIndex212) )
          & ( v337(VarNext,bitIndex1)
          <=> v94(VarCurr,bitIndex211) )
          & ( v337(VarNext,bitIndex0)
          <=> v94(VarCurr,bitIndex210) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_11,axiom,
    ! [VarNext] :
      ( v338(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v337(VarNext,B)
          <=> v364(VarNext,B) ) ) ) ).

fof(addAssignment_103,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v364(VarNext,B)
          <=> v362(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_6,axiom,
    ! [VarCurr] :
      ( ~ v255(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v362(VarCurr,B)
          <=> v365(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_4,axiom,
    ! [VarCurr] :
      ( v255(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v362(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_3,axiom,
    ! [VarCurr] :
      ( ( ~ v351(VarCurr)
        & ~ v353(VarCurr) )
     => ! [B] :
          ( range_69_0(B)
         => ( v365(VarCurr,B)
          <=> v330(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5,axiom,
    ! [VarCurr] :
      ( v353(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v365(VarCurr,B)
          <=> v323(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_1,axiom,
    ! [VarCurr] :
      ( v351(VarCurr)
     => ( ( v365(VarCurr,bitIndex69)
        <=> v94(VarCurr,bitIndex209) )
        & ( v365(VarCurr,bitIndex68)
        <=> v94(VarCurr,bitIndex208) )
        & ( v365(VarCurr,bitIndex67)
        <=> v94(VarCurr,bitIndex207) )
        & ( v365(VarCurr,bitIndex66)
        <=> v94(VarCurr,bitIndex206) )
        & ( v365(VarCurr,bitIndex65)
        <=> v94(VarCurr,bitIndex205) )
        & ( v365(VarCurr,bitIndex64)
        <=> v94(VarCurr,bitIndex204) )
        & ( v365(VarCurr,bitIndex63)
        <=> v94(VarCurr,bitIndex203) )
        & ( v365(VarCurr,bitIndex62)
        <=> v94(VarCurr,bitIndex202) )
        & ( v365(VarCurr,bitIndex61)
        <=> v94(VarCurr,bitIndex201) )
        & ( v365(VarCurr,bitIndex60)
        <=> v94(VarCurr,bitIndex200) )
        & ( v365(VarCurr,bitIndex59)
        <=> v94(VarCurr,bitIndex199) )
        & ( v365(VarCurr,bitIndex58)
        <=> v94(VarCurr,bitIndex198) )
        & ( v365(VarCurr,bitIndex57)
        <=> v94(VarCurr,bitIndex197) )
        & ( v365(VarCurr,bitIndex56)
        <=> v94(VarCurr,bitIndex196) )
        & ( v365(VarCurr,bitIndex55)
        <=> v94(VarCurr,bitIndex195) )
        & ( v365(VarCurr,bitIndex54)
        <=> v94(VarCurr,bitIndex194) )
        & ( v365(VarCurr,bitIndex53)
        <=> v94(VarCurr,bitIndex193) )
        & ( v365(VarCurr,bitIndex52)
        <=> v94(VarCurr,bitIndex192) )
        & ( v365(VarCurr,bitIndex51)
        <=> v94(VarCurr,bitIndex191) )
        & ( v365(VarCurr,bitIndex50)
        <=> v94(VarCurr,bitIndex190) )
        & ( v365(VarCurr,bitIndex49)
        <=> v94(VarCurr,bitIndex189) )
        & ( v365(VarCurr,bitIndex48)
        <=> v94(VarCurr,bitIndex188) )
        & ( v365(VarCurr,bitIndex47)
        <=> v94(VarCurr,bitIndex187) )
        & ( v365(VarCurr,bitIndex46)
        <=> v94(VarCurr,bitIndex186) )
        & ( v365(VarCurr,bitIndex45)
        <=> v94(VarCurr,bitIndex185) )
        & ( v365(VarCurr,bitIndex44)
        <=> v94(VarCurr,bitIndex184) )
        & ( v365(VarCurr,bitIndex43)
        <=> v94(VarCurr,bitIndex183) )
        & ( v365(VarCurr,bitIndex42)
        <=> v94(VarCurr,bitIndex182) )
        & ( v365(VarCurr,bitIndex41)
        <=> v94(VarCurr,bitIndex181) )
        & ( v365(VarCurr,bitIndex40)
        <=> v94(VarCurr,bitIndex180) )
        & ( v365(VarCurr,bitIndex39)
        <=> v94(VarCurr,bitIndex179) )
        & ( v365(VarCurr,bitIndex38)
        <=> v94(VarCurr,bitIndex178) )
        & ( v365(VarCurr,bitIndex37)
        <=> v94(VarCurr,bitIndex177) )
        & ( v365(VarCurr,bitIndex36)
        <=> v94(VarCurr,bitIndex176) )
        & ( v365(VarCurr,bitIndex35)
        <=> v94(VarCurr,bitIndex175) )
        & ( v365(VarCurr,bitIndex34)
        <=> v94(VarCurr,bitIndex174) )
        & ( v365(VarCurr,bitIndex33)
        <=> v94(VarCurr,bitIndex173) )
        & ( v365(VarCurr,bitIndex32)
        <=> v94(VarCurr,bitIndex172) )
        & ( v365(VarCurr,bitIndex31)
        <=> v94(VarCurr,bitIndex171) )
        & ( v365(VarCurr,bitIndex30)
        <=> v94(VarCurr,bitIndex170) )
        & ( v365(VarCurr,bitIndex29)
        <=> v94(VarCurr,bitIndex169) )
        & ( v365(VarCurr,bitIndex28)
        <=> v94(VarCurr,bitIndex168) )
        & ( v365(VarCurr,bitIndex27)
        <=> v94(VarCurr,bitIndex167) )
        & ( v365(VarCurr,bitIndex26)
        <=> v94(VarCurr,bitIndex166) )
        & ( v365(VarCurr,bitIndex25)
        <=> v94(VarCurr,bitIndex165) )
        & ( v365(VarCurr,bitIndex24)
        <=> v94(VarCurr,bitIndex164) )
        & ( v365(VarCurr,bitIndex23)
        <=> v94(VarCurr,bitIndex163) )
        & ( v365(VarCurr,bitIndex22)
        <=> v94(VarCurr,bitIndex162) )
        & ( v365(VarCurr,bitIndex21)
        <=> v94(VarCurr,bitIndex161) )
        & ( v365(VarCurr,bitIndex20)
        <=> v94(VarCurr,bitIndex160) )
        & ( v365(VarCurr,bitIndex19)
        <=> v94(VarCurr,bitIndex159) )
        & ( v365(VarCurr,bitIndex18)
        <=> v94(VarCurr,bitIndex158) )
        & ( v365(VarCurr,bitIndex17)
        <=> v94(VarCurr,bitIndex157) )
        & ( v365(VarCurr,bitIndex16)
        <=> v94(VarCurr,bitIndex156) )
        & ( v365(VarCurr,bitIndex15)
        <=> v94(VarCurr,bitIndex155) )
        & ( v365(VarCurr,bitIndex14)
        <=> v94(VarCurr,bitIndex154) )
        & ( v365(VarCurr,bitIndex13)
        <=> v94(VarCurr,bitIndex153) )
        & ( v365(VarCurr,bitIndex12)
        <=> v94(VarCurr,bitIndex152) )
        & ( v365(VarCurr,bitIndex11)
        <=> v94(VarCurr,bitIndex151) )
        & ( v365(VarCurr,bitIndex10)
        <=> v94(VarCurr,bitIndex150) )
        & ( v365(VarCurr,bitIndex9)
        <=> v94(VarCurr,bitIndex149) )
        & ( v365(VarCurr,bitIndex8)
        <=> v94(VarCurr,bitIndex148) )
        & ( v365(VarCurr,bitIndex7)
        <=> v94(VarCurr,bitIndex147) )
        & ( v365(VarCurr,bitIndex6)
        <=> v94(VarCurr,bitIndex146) )
        & ( v365(VarCurr,bitIndex5)
        <=> v94(VarCurr,bitIndex145) )
        & ( v365(VarCurr,bitIndex4)
        <=> v94(VarCurr,bitIndex144) )
        & ( v365(VarCurr,bitIndex3)
        <=> v94(VarCurr,bitIndex143) )
        & ( v365(VarCurr,bitIndex2)
        <=> v94(VarCurr,bitIndex142) )
        & ( v365(VarCurr,bitIndex1)
        <=> v94(VarCurr,bitIndex141) )
        & ( v365(VarCurr,bitIndex0)
        <=> v94(VarCurr,bitIndex140) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_43,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v338(VarNext)
      <=> ( v339(VarNext)
          & v346(VarNext) ) ) ) ).

fof(addAssignment_102,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v346(VarNext)
      <=> v344(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_42,axiom,
    ! [VarCurr] :
      ( v344(VarCurr)
    <=> ( v347(VarCurr)
        & v358(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_41,axiom,
    ! [VarCurr] :
      ( v358(VarCurr)
    <=> ( v359(VarCurr)
        | v255(VarCurr) ) ) ).

fof(writeUnaryOperator_21,axiom,
    ! [VarCurr] :
      ( ~ v359(VarCurr)
    <=> v360(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_17,axiom,
    ! [VarCurr] :
      ( v360(VarCurr)
    <=> ( ( v361(VarCurr,bitIndex1)
        <=> $false )
        & ( v361(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_101,axiom,
    ! [VarCurr] :
      ( v361(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_100,axiom,
    ! [VarCurr] :
      ( v361(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_40,axiom,
    ! [VarCurr] :
      ( v347(VarCurr)
    <=> ( v255(VarCurr)
        | v348(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_39,axiom,
    ! [VarCurr] :
      ( v348(VarCurr)
    <=> ( v349(VarCurr)
        & v357(VarCurr) ) ) ).

fof(writeUnaryOperator_20,axiom,
    ! [VarCurr] :
      ( ~ v357(VarCurr)
    <=> v255(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_38,axiom,
    ! [VarCurr] :
      ( v349(VarCurr)
    <=> ( v350(VarCurr)
        | v355(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_16,axiom,
    ! [VarCurr] :
      ( v355(VarCurr)
    <=> ( ( v356(VarCurr,bitIndex1)
        <=> $true )
        & ( v356(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_99,axiom,
    ! [VarCurr] :
      ( v356(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_98,axiom,
    ! [VarCurr] :
      ( v356(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_37,axiom,
    ! [VarCurr] :
      ( v350(VarCurr)
    <=> ( v351(VarCurr)
        | v353(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_15,axiom,
    ! [VarCurr] :
      ( v353(VarCurr)
    <=> ( ( v354(VarCurr,bitIndex1)
        <=> $true )
        & ( v354(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_97,axiom,
    ! [VarCurr] :
      ( v354(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_96,axiom,
    ! [VarCurr] :
      ( v354(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_14,axiom,
    ! [VarCurr] :
      ( v351(VarCurr)
    <=> ( ( v352(VarCurr,bitIndex1)
        <=> $false )
        & ( v352(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_95,axiom,
    ! [VarCurr] :
      ( v352(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_94,axiom,
    ! [VarCurr] :
      ( v352(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_36,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v339(VarNext)
      <=> ( v341(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_19,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v341(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_93,axiom,
    ! [VarCurr] :
      ( v330(VarCurr,bitIndex49)
    <=> v335(VarCurr,bitIndex49) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_8,axiom,
    ! [VarCurr] :
      ( ~ v332(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v335(VarCurr,B)
          <=> v334(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_8,axiom,
    ! [VarCurr] :
      ( v332(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v335(VarCurr,B)
          <=> v212(VarCurr,B) ) ) ) ).

fof(addAssignment_92,axiom,
    ! [VarCurr] :
      ( v334(VarCurr,bitIndex49)
    <=> v94(VarCurr,bitIndex189) ) ).

fof(addAssignment_91,axiom,
    ! [VarCurr] :
      ( v332(VarCurr)
    <=> v103(VarCurr,bitIndex5) ) ).

fof(addAssignment_90,axiom,
    ! [VarCurr] :
      ( v323(VarCurr,bitIndex49)
    <=> v328(VarCurr,bitIndex49) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_7,axiom,
    ! [VarCurr] :
      ( ~ v325(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v328(VarCurr,B)
          <=> v327(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_7,axiom,
    ! [VarCurr] :
      ( v325(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v328(VarCurr,B)
          <=> v212(VarCurr,B) ) ) ) ).

fof(addAssignment_89,axiom,
    ! [VarCurr] :
      ( v327(VarCurr,bitIndex49)
    <=> v94(VarCurr,bitIndex259) ) ).

fof(addAssignment_88,axiom,
    ! [VarCurr] :
      ( v325(VarCurr)
    <=> v103(VarCurr,bitIndex5) ) ).

fof(addAssignment_87,axiom,
    ! [VarNext] :
      ( v94(VarNext,bitIndex189)
    <=> v291(VarNext,bitIndex49) ) ).

fof(addCaseBooleanConditionShiftedRanges1_1,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v292(VarNext)
       => ( ( v291(VarNext,bitIndex69)
          <=> v94(VarCurr,bitIndex209) )
          & ( v291(VarNext,bitIndex68)
          <=> v94(VarCurr,bitIndex208) )
          & ( v291(VarNext,bitIndex67)
          <=> v94(VarCurr,bitIndex207) )
          & ( v291(VarNext,bitIndex66)
          <=> v94(VarCurr,bitIndex206) )
          & ( v291(VarNext,bitIndex65)
          <=> v94(VarCurr,bitIndex205) )
          & ( v291(VarNext,bitIndex64)
          <=> v94(VarCurr,bitIndex204) )
          & ( v291(VarNext,bitIndex63)
          <=> v94(VarCurr,bitIndex203) )
          & ( v291(VarNext,bitIndex62)
          <=> v94(VarCurr,bitIndex202) )
          & ( v291(VarNext,bitIndex61)
          <=> v94(VarCurr,bitIndex201) )
          & ( v291(VarNext,bitIndex60)
          <=> v94(VarCurr,bitIndex200) )
          & ( v291(VarNext,bitIndex59)
          <=> v94(VarCurr,bitIndex199) )
          & ( v291(VarNext,bitIndex58)
          <=> v94(VarCurr,bitIndex198) )
          & ( v291(VarNext,bitIndex57)
          <=> v94(VarCurr,bitIndex197) )
          & ( v291(VarNext,bitIndex56)
          <=> v94(VarCurr,bitIndex196) )
          & ( v291(VarNext,bitIndex55)
          <=> v94(VarCurr,bitIndex195) )
          & ( v291(VarNext,bitIndex54)
          <=> v94(VarCurr,bitIndex194) )
          & ( v291(VarNext,bitIndex53)
          <=> v94(VarCurr,bitIndex193) )
          & ( v291(VarNext,bitIndex52)
          <=> v94(VarCurr,bitIndex192) )
          & ( v291(VarNext,bitIndex51)
          <=> v94(VarCurr,bitIndex191) )
          & ( v291(VarNext,bitIndex50)
          <=> v94(VarCurr,bitIndex190) )
          & ( v291(VarNext,bitIndex49)
          <=> v94(VarCurr,bitIndex189) )
          & ( v291(VarNext,bitIndex48)
          <=> v94(VarCurr,bitIndex188) )
          & ( v291(VarNext,bitIndex47)
          <=> v94(VarCurr,bitIndex187) )
          & ( v291(VarNext,bitIndex46)
          <=> v94(VarCurr,bitIndex186) )
          & ( v291(VarNext,bitIndex45)
          <=> v94(VarCurr,bitIndex185) )
          & ( v291(VarNext,bitIndex44)
          <=> v94(VarCurr,bitIndex184) )
          & ( v291(VarNext,bitIndex43)
          <=> v94(VarCurr,bitIndex183) )
          & ( v291(VarNext,bitIndex42)
          <=> v94(VarCurr,bitIndex182) )
          & ( v291(VarNext,bitIndex41)
          <=> v94(VarCurr,bitIndex181) )
          & ( v291(VarNext,bitIndex40)
          <=> v94(VarCurr,bitIndex180) )
          & ( v291(VarNext,bitIndex39)
          <=> v94(VarCurr,bitIndex179) )
          & ( v291(VarNext,bitIndex38)
          <=> v94(VarCurr,bitIndex178) )
          & ( v291(VarNext,bitIndex37)
          <=> v94(VarCurr,bitIndex177) )
          & ( v291(VarNext,bitIndex36)
          <=> v94(VarCurr,bitIndex176) )
          & ( v291(VarNext,bitIndex35)
          <=> v94(VarCurr,bitIndex175) )
          & ( v291(VarNext,bitIndex34)
          <=> v94(VarCurr,bitIndex174) )
          & ( v291(VarNext,bitIndex33)
          <=> v94(VarCurr,bitIndex173) )
          & ( v291(VarNext,bitIndex32)
          <=> v94(VarCurr,bitIndex172) )
          & ( v291(VarNext,bitIndex31)
          <=> v94(VarCurr,bitIndex171) )
          & ( v291(VarNext,bitIndex30)
          <=> v94(VarCurr,bitIndex170) )
          & ( v291(VarNext,bitIndex29)
          <=> v94(VarCurr,bitIndex169) )
          & ( v291(VarNext,bitIndex28)
          <=> v94(VarCurr,bitIndex168) )
          & ( v291(VarNext,bitIndex27)
          <=> v94(VarCurr,bitIndex167) )
          & ( v291(VarNext,bitIndex26)
          <=> v94(VarCurr,bitIndex166) )
          & ( v291(VarNext,bitIndex25)
          <=> v94(VarCurr,bitIndex165) )
          & ( v291(VarNext,bitIndex24)
          <=> v94(VarCurr,bitIndex164) )
          & ( v291(VarNext,bitIndex23)
          <=> v94(VarCurr,bitIndex163) )
          & ( v291(VarNext,bitIndex22)
          <=> v94(VarCurr,bitIndex162) )
          & ( v291(VarNext,bitIndex21)
          <=> v94(VarCurr,bitIndex161) )
          & ( v291(VarNext,bitIndex20)
          <=> v94(VarCurr,bitIndex160) )
          & ( v291(VarNext,bitIndex19)
          <=> v94(VarCurr,bitIndex159) )
          & ( v291(VarNext,bitIndex18)
          <=> v94(VarCurr,bitIndex158) )
          & ( v291(VarNext,bitIndex17)
          <=> v94(VarCurr,bitIndex157) )
          & ( v291(VarNext,bitIndex16)
          <=> v94(VarCurr,bitIndex156) )
          & ( v291(VarNext,bitIndex15)
          <=> v94(VarCurr,bitIndex155) )
          & ( v291(VarNext,bitIndex14)
          <=> v94(VarCurr,bitIndex154) )
          & ( v291(VarNext,bitIndex13)
          <=> v94(VarCurr,bitIndex153) )
          & ( v291(VarNext,bitIndex12)
          <=> v94(VarCurr,bitIndex152) )
          & ( v291(VarNext,bitIndex11)
          <=> v94(VarCurr,bitIndex151) )
          & ( v291(VarNext,bitIndex10)
          <=> v94(VarCurr,bitIndex150) )
          & ( v291(VarNext,bitIndex9)
          <=> v94(VarCurr,bitIndex149) )
          & ( v291(VarNext,bitIndex8)
          <=> v94(VarCurr,bitIndex148) )
          & ( v291(VarNext,bitIndex7)
          <=> v94(VarCurr,bitIndex147) )
          & ( v291(VarNext,bitIndex6)
          <=> v94(VarCurr,bitIndex146) )
          & ( v291(VarNext,bitIndex5)
          <=> v94(VarCurr,bitIndex145) )
          & ( v291(VarNext,bitIndex4)
          <=> v94(VarCurr,bitIndex144) )
          & ( v291(VarNext,bitIndex3)
          <=> v94(VarCurr,bitIndex143) )
          & ( v291(VarNext,bitIndex2)
          <=> v94(VarCurr,bitIndex142) )
          & ( v291(VarNext,bitIndex1)
          <=> v94(VarCurr,bitIndex141) )
          & ( v291(VarNext,bitIndex0)
          <=> v94(VarCurr,bitIndex140) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_10,axiom,
    ! [VarNext] :
      ( v292(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v291(VarNext,B)
          <=> v318(VarNext,B) ) ) ) ).

fof(addAssignment_86,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v318(VarNext,B)
          <=> v316(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_4,axiom,
    ! [VarCurr] :
      ( ~ v255(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v316(VarCurr,B)
          <=> v319(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_3,axiom,
    ! [VarCurr] :
      ( v255(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v316(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_2,axiom,
    ! [VarCurr] :
      ( ( ~ v305(VarCurr)
        & ~ v307(VarCurr) )
     => ! [B] :
          ( range_69_0(B)
         => ( v319(VarCurr,B)
          <=> v284(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_3,axiom,
    ! [VarCurr] :
      ( v307(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v319(VarCurr,B)
          <=> v277(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0,axiom,
    ! [VarCurr] :
      ( v305(VarCurr)
     => ( ( v319(VarCurr,bitIndex69)
        <=> v94(VarCurr,bitIndex139) )
        & ( v319(VarCurr,bitIndex68)
        <=> v94(VarCurr,bitIndex138) )
        & ( v319(VarCurr,bitIndex67)
        <=> v94(VarCurr,bitIndex137) )
        & ( v319(VarCurr,bitIndex66)
        <=> v94(VarCurr,bitIndex136) )
        & ( v319(VarCurr,bitIndex65)
        <=> v94(VarCurr,bitIndex135) )
        & ( v319(VarCurr,bitIndex64)
        <=> v94(VarCurr,bitIndex134) )
        & ( v319(VarCurr,bitIndex63)
        <=> v94(VarCurr,bitIndex133) )
        & ( v319(VarCurr,bitIndex62)
        <=> v94(VarCurr,bitIndex132) )
        & ( v319(VarCurr,bitIndex61)
        <=> v94(VarCurr,bitIndex131) )
        & ( v319(VarCurr,bitIndex60)
        <=> v94(VarCurr,bitIndex130) )
        & ( v319(VarCurr,bitIndex59)
        <=> v94(VarCurr,bitIndex129) )
        & ( v319(VarCurr,bitIndex58)
        <=> v94(VarCurr,bitIndex128) )
        & ( v319(VarCurr,bitIndex57)
        <=> v94(VarCurr,bitIndex127) )
        & ( v319(VarCurr,bitIndex56)
        <=> v94(VarCurr,bitIndex126) )
        & ( v319(VarCurr,bitIndex55)
        <=> v94(VarCurr,bitIndex125) )
        & ( v319(VarCurr,bitIndex54)
        <=> v94(VarCurr,bitIndex124) )
        & ( v319(VarCurr,bitIndex53)
        <=> v94(VarCurr,bitIndex123) )
        & ( v319(VarCurr,bitIndex52)
        <=> v94(VarCurr,bitIndex122) )
        & ( v319(VarCurr,bitIndex51)
        <=> v94(VarCurr,bitIndex121) )
        & ( v319(VarCurr,bitIndex50)
        <=> v94(VarCurr,bitIndex120) )
        & ( v319(VarCurr,bitIndex49)
        <=> v94(VarCurr,bitIndex119) )
        & ( v319(VarCurr,bitIndex48)
        <=> v94(VarCurr,bitIndex118) )
        & ( v319(VarCurr,bitIndex47)
        <=> v94(VarCurr,bitIndex117) )
        & ( v319(VarCurr,bitIndex46)
        <=> v94(VarCurr,bitIndex116) )
        & ( v319(VarCurr,bitIndex45)
        <=> v94(VarCurr,bitIndex115) )
        & ( v319(VarCurr,bitIndex44)
        <=> v94(VarCurr,bitIndex114) )
        & ( v319(VarCurr,bitIndex43)
        <=> v94(VarCurr,bitIndex113) )
        & ( v319(VarCurr,bitIndex42)
        <=> v94(VarCurr,bitIndex112) )
        & ( v319(VarCurr,bitIndex41)
        <=> v94(VarCurr,bitIndex111) )
        & ( v319(VarCurr,bitIndex40)
        <=> v94(VarCurr,bitIndex110) )
        & ( v319(VarCurr,bitIndex39)
        <=> v94(VarCurr,bitIndex109) )
        & ( v319(VarCurr,bitIndex38)
        <=> v94(VarCurr,bitIndex108) )
        & ( v319(VarCurr,bitIndex37)
        <=> v94(VarCurr,bitIndex107) )
        & ( v319(VarCurr,bitIndex36)
        <=> v94(VarCurr,bitIndex106) )
        & ( v319(VarCurr,bitIndex35)
        <=> v94(VarCurr,bitIndex105) )
        & ( v319(VarCurr,bitIndex34)
        <=> v94(VarCurr,bitIndex104) )
        & ( v319(VarCurr,bitIndex33)
        <=> v94(VarCurr,bitIndex103) )
        & ( v319(VarCurr,bitIndex32)
        <=> v94(VarCurr,bitIndex102) )
        & ( v319(VarCurr,bitIndex31)
        <=> v94(VarCurr,bitIndex101) )
        & ( v319(VarCurr,bitIndex30)
        <=> v94(VarCurr,bitIndex100) )
        & ( v319(VarCurr,bitIndex29)
        <=> v94(VarCurr,bitIndex99) )
        & ( v319(VarCurr,bitIndex28)
        <=> v94(VarCurr,bitIndex98) )
        & ( v319(VarCurr,bitIndex27)
        <=> v94(VarCurr,bitIndex97) )
        & ( v319(VarCurr,bitIndex26)
        <=> v94(VarCurr,bitIndex96) )
        & ( v319(VarCurr,bitIndex25)
        <=> v94(VarCurr,bitIndex95) )
        & ( v319(VarCurr,bitIndex24)
        <=> v94(VarCurr,bitIndex94) )
        & ( v319(VarCurr,bitIndex23)
        <=> v94(VarCurr,bitIndex93) )
        & ( v319(VarCurr,bitIndex22)
        <=> v94(VarCurr,bitIndex92) )
        & ( v319(VarCurr,bitIndex21)
        <=> v94(VarCurr,bitIndex91) )
        & ( v319(VarCurr,bitIndex20)
        <=> v94(VarCurr,bitIndex90) )
        & ( v319(VarCurr,bitIndex19)
        <=> v94(VarCurr,bitIndex89) )
        & ( v319(VarCurr,bitIndex18)
        <=> v94(VarCurr,bitIndex88) )
        & ( v319(VarCurr,bitIndex17)
        <=> v94(VarCurr,bitIndex87) )
        & ( v319(VarCurr,bitIndex16)
        <=> v94(VarCurr,bitIndex86) )
        & ( v319(VarCurr,bitIndex15)
        <=> v94(VarCurr,bitIndex85) )
        & ( v319(VarCurr,bitIndex14)
        <=> v94(VarCurr,bitIndex84) )
        & ( v319(VarCurr,bitIndex13)
        <=> v94(VarCurr,bitIndex83) )
        & ( v319(VarCurr,bitIndex12)
        <=> v94(VarCurr,bitIndex82) )
        & ( v319(VarCurr,bitIndex11)
        <=> v94(VarCurr,bitIndex81) )
        & ( v319(VarCurr,bitIndex10)
        <=> v94(VarCurr,bitIndex80) )
        & ( v319(VarCurr,bitIndex9)
        <=> v94(VarCurr,bitIndex79) )
        & ( v319(VarCurr,bitIndex8)
        <=> v94(VarCurr,bitIndex78) )
        & ( v319(VarCurr,bitIndex7)
        <=> v94(VarCurr,bitIndex77) )
        & ( v319(VarCurr,bitIndex6)
        <=> v94(VarCurr,bitIndex76) )
        & ( v319(VarCurr,bitIndex5)
        <=> v94(VarCurr,bitIndex75) )
        & ( v319(VarCurr,bitIndex4)
        <=> v94(VarCurr,bitIndex74) )
        & ( v319(VarCurr,bitIndex3)
        <=> v94(VarCurr,bitIndex73) )
        & ( v319(VarCurr,bitIndex2)
        <=> v94(VarCurr,bitIndex72) )
        & ( v319(VarCurr,bitIndex1)
        <=> v94(VarCurr,bitIndex71) )
        & ( v319(VarCurr,bitIndex0)
        <=> v94(VarCurr,bitIndex70) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_35,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v292(VarNext)
      <=> ( v293(VarNext)
          & v300(VarNext) ) ) ) ).

fof(addAssignment_85,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v300(VarNext)
      <=> v298(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_34,axiom,
    ! [VarCurr] :
      ( v298(VarCurr)
    <=> ( v301(VarCurr)
        & v312(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_33,axiom,
    ! [VarCurr] :
      ( v312(VarCurr)
    <=> ( v313(VarCurr)
        | v255(VarCurr) ) ) ).

fof(writeUnaryOperator_18,axiom,
    ! [VarCurr] :
      ( ~ v313(VarCurr)
    <=> v314(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_13,axiom,
    ! [VarCurr] :
      ( v314(VarCurr)
    <=> ( ( v315(VarCurr,bitIndex1)
        <=> $false )
        & ( v315(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_84,axiom,
    ! [VarCurr] :
      ( v315(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_83,axiom,
    ! [VarCurr] :
      ( v315(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_32,axiom,
    ! [VarCurr] :
      ( v301(VarCurr)
    <=> ( v255(VarCurr)
        | v302(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_31,axiom,
    ! [VarCurr] :
      ( v302(VarCurr)
    <=> ( v303(VarCurr)
        & v311(VarCurr) ) ) ).

fof(writeUnaryOperator_17,axiom,
    ! [VarCurr] :
      ( ~ v311(VarCurr)
    <=> v255(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_30,axiom,
    ! [VarCurr] :
      ( v303(VarCurr)
    <=> ( v304(VarCurr)
        | v309(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_12,axiom,
    ! [VarCurr] :
      ( v309(VarCurr)
    <=> ( ( v310(VarCurr,bitIndex1)
        <=> $true )
        & ( v310(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_82,axiom,
    ! [VarCurr] :
      ( v310(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_81,axiom,
    ! [VarCurr] :
      ( v310(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_29,axiom,
    ! [VarCurr] :
      ( v304(VarCurr)
    <=> ( v305(VarCurr)
        | v307(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_11,axiom,
    ! [VarCurr] :
      ( v307(VarCurr)
    <=> ( ( v308(VarCurr,bitIndex1)
        <=> $true )
        & ( v308(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_80,axiom,
    ! [VarCurr] :
      ( v308(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_79,axiom,
    ! [VarCurr] :
      ( v308(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_10,axiom,
    ! [VarCurr] :
      ( v305(VarCurr)
    <=> ( ( v306(VarCurr,bitIndex1)
        <=> $false )
        & ( v306(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_78,axiom,
    ! [VarCurr] :
      ( v306(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_77,axiom,
    ! [VarCurr] :
      ( v306(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_28,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v293(VarNext)
      <=> ( v295(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_16,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v295(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_76,axiom,
    ! [VarCurr] :
      ( v284(VarCurr,bitIndex49)
    <=> v289(VarCurr,bitIndex49) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_6,axiom,
    ! [VarCurr] :
      ( ~ v286(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v289(VarCurr,B)
          <=> v288(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_6,axiom,
    ! [VarCurr] :
      ( v286(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v289(VarCurr,B)
          <=> v212(VarCurr,B) ) ) ) ).

fof(addAssignment_75,axiom,
    ! [VarCurr] :
      ( v288(VarCurr,bitIndex49)
    <=> v94(VarCurr,bitIndex119) ) ).

fof(addAssignment_74,axiom,
    ! [VarCurr] :
      ( v286(VarCurr)
    <=> v103(VarCurr,bitIndex6) ) ).

fof(addAssignment_73,axiom,
    ! [VarCurr] :
      ( v277(VarCurr,bitIndex49)
    <=> v282(VarCurr,bitIndex49) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_5,axiom,
    ! [VarCurr] :
      ( ~ v279(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v282(VarCurr,B)
          <=> v281(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_5,axiom,
    ! [VarCurr] :
      ( v279(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v282(VarCurr,B)
          <=> v212(VarCurr,B) ) ) ) ).

fof(addAssignment_72,axiom,
    ! [VarCurr] :
      ( v281(VarCurr,bitIndex49)
    <=> v94(VarCurr,bitIndex189) ) ).

fof(addAssignment_71,axiom,
    ! [VarCurr] :
      ( v279(VarCurr)
    <=> v103(VarCurr,bitIndex6) ) ).

fof(addAssignment_70,axiom,
    ! [VarNext] :
      ( v94(VarNext,bitIndex119)
    <=> v244(VarNext,bitIndex49) ) ).

fof(addCaseBooleanConditionShiftedRanges1,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v245(VarNext)
       => ( ( v244(VarNext,bitIndex69)
          <=> v94(VarCurr,bitIndex139) )
          & ( v244(VarNext,bitIndex68)
          <=> v94(VarCurr,bitIndex138) )
          & ( v244(VarNext,bitIndex67)
          <=> v94(VarCurr,bitIndex137) )
          & ( v244(VarNext,bitIndex66)
          <=> v94(VarCurr,bitIndex136) )
          & ( v244(VarNext,bitIndex65)
          <=> v94(VarCurr,bitIndex135) )
          & ( v244(VarNext,bitIndex64)
          <=> v94(VarCurr,bitIndex134) )
          & ( v244(VarNext,bitIndex63)
          <=> v94(VarCurr,bitIndex133) )
          & ( v244(VarNext,bitIndex62)
          <=> v94(VarCurr,bitIndex132) )
          & ( v244(VarNext,bitIndex61)
          <=> v94(VarCurr,bitIndex131) )
          & ( v244(VarNext,bitIndex60)
          <=> v94(VarCurr,bitIndex130) )
          & ( v244(VarNext,bitIndex59)
          <=> v94(VarCurr,bitIndex129) )
          & ( v244(VarNext,bitIndex58)
          <=> v94(VarCurr,bitIndex128) )
          & ( v244(VarNext,bitIndex57)
          <=> v94(VarCurr,bitIndex127) )
          & ( v244(VarNext,bitIndex56)
          <=> v94(VarCurr,bitIndex126) )
          & ( v244(VarNext,bitIndex55)
          <=> v94(VarCurr,bitIndex125) )
          & ( v244(VarNext,bitIndex54)
          <=> v94(VarCurr,bitIndex124) )
          & ( v244(VarNext,bitIndex53)
          <=> v94(VarCurr,bitIndex123) )
          & ( v244(VarNext,bitIndex52)
          <=> v94(VarCurr,bitIndex122) )
          & ( v244(VarNext,bitIndex51)
          <=> v94(VarCurr,bitIndex121) )
          & ( v244(VarNext,bitIndex50)
          <=> v94(VarCurr,bitIndex120) )
          & ( v244(VarNext,bitIndex49)
          <=> v94(VarCurr,bitIndex119) )
          & ( v244(VarNext,bitIndex48)
          <=> v94(VarCurr,bitIndex118) )
          & ( v244(VarNext,bitIndex47)
          <=> v94(VarCurr,bitIndex117) )
          & ( v244(VarNext,bitIndex46)
          <=> v94(VarCurr,bitIndex116) )
          & ( v244(VarNext,bitIndex45)
          <=> v94(VarCurr,bitIndex115) )
          & ( v244(VarNext,bitIndex44)
          <=> v94(VarCurr,bitIndex114) )
          & ( v244(VarNext,bitIndex43)
          <=> v94(VarCurr,bitIndex113) )
          & ( v244(VarNext,bitIndex42)
          <=> v94(VarCurr,bitIndex112) )
          & ( v244(VarNext,bitIndex41)
          <=> v94(VarCurr,bitIndex111) )
          & ( v244(VarNext,bitIndex40)
          <=> v94(VarCurr,bitIndex110) )
          & ( v244(VarNext,bitIndex39)
          <=> v94(VarCurr,bitIndex109) )
          & ( v244(VarNext,bitIndex38)
          <=> v94(VarCurr,bitIndex108) )
          & ( v244(VarNext,bitIndex37)
          <=> v94(VarCurr,bitIndex107) )
          & ( v244(VarNext,bitIndex36)
          <=> v94(VarCurr,bitIndex106) )
          & ( v244(VarNext,bitIndex35)
          <=> v94(VarCurr,bitIndex105) )
          & ( v244(VarNext,bitIndex34)
          <=> v94(VarCurr,bitIndex104) )
          & ( v244(VarNext,bitIndex33)
          <=> v94(VarCurr,bitIndex103) )
          & ( v244(VarNext,bitIndex32)
          <=> v94(VarCurr,bitIndex102) )
          & ( v244(VarNext,bitIndex31)
          <=> v94(VarCurr,bitIndex101) )
          & ( v244(VarNext,bitIndex30)
          <=> v94(VarCurr,bitIndex100) )
          & ( v244(VarNext,bitIndex29)
          <=> v94(VarCurr,bitIndex99) )
          & ( v244(VarNext,bitIndex28)
          <=> v94(VarCurr,bitIndex98) )
          & ( v244(VarNext,bitIndex27)
          <=> v94(VarCurr,bitIndex97) )
          & ( v244(VarNext,bitIndex26)
          <=> v94(VarCurr,bitIndex96) )
          & ( v244(VarNext,bitIndex25)
          <=> v94(VarCurr,bitIndex95) )
          & ( v244(VarNext,bitIndex24)
          <=> v94(VarCurr,bitIndex94) )
          & ( v244(VarNext,bitIndex23)
          <=> v94(VarCurr,bitIndex93) )
          & ( v244(VarNext,bitIndex22)
          <=> v94(VarCurr,bitIndex92) )
          & ( v244(VarNext,bitIndex21)
          <=> v94(VarCurr,bitIndex91) )
          & ( v244(VarNext,bitIndex20)
          <=> v94(VarCurr,bitIndex90) )
          & ( v244(VarNext,bitIndex19)
          <=> v94(VarCurr,bitIndex89) )
          & ( v244(VarNext,bitIndex18)
          <=> v94(VarCurr,bitIndex88) )
          & ( v244(VarNext,bitIndex17)
          <=> v94(VarCurr,bitIndex87) )
          & ( v244(VarNext,bitIndex16)
          <=> v94(VarCurr,bitIndex86) )
          & ( v244(VarNext,bitIndex15)
          <=> v94(VarCurr,bitIndex85) )
          & ( v244(VarNext,bitIndex14)
          <=> v94(VarCurr,bitIndex84) )
          & ( v244(VarNext,bitIndex13)
          <=> v94(VarCurr,bitIndex83) )
          & ( v244(VarNext,bitIndex12)
          <=> v94(VarCurr,bitIndex82) )
          & ( v244(VarNext,bitIndex11)
          <=> v94(VarCurr,bitIndex81) )
          & ( v244(VarNext,bitIndex10)
          <=> v94(VarCurr,bitIndex80) )
          & ( v244(VarNext,bitIndex9)
          <=> v94(VarCurr,bitIndex79) )
          & ( v244(VarNext,bitIndex8)
          <=> v94(VarCurr,bitIndex78) )
          & ( v244(VarNext,bitIndex7)
          <=> v94(VarCurr,bitIndex77) )
          & ( v244(VarNext,bitIndex6)
          <=> v94(VarCurr,bitIndex76) )
          & ( v244(VarNext,bitIndex5)
          <=> v94(VarCurr,bitIndex75) )
          & ( v244(VarNext,bitIndex4)
          <=> v94(VarCurr,bitIndex74) )
          & ( v244(VarNext,bitIndex3)
          <=> v94(VarCurr,bitIndex73) )
          & ( v244(VarNext,bitIndex2)
          <=> v94(VarCurr,bitIndex72) )
          & ( v244(VarNext,bitIndex1)
          <=> v94(VarCurr,bitIndex71) )
          & ( v244(VarNext,bitIndex0)
          <=> v94(VarCurr,bitIndex70) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_9,axiom,
    ! [VarNext] :
      ( v245(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v244(VarNext,B)
          <=> v272(VarNext,B) ) ) ) ).

fof(addAssignment_69,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v272(VarNext,B)
          <=> v270(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_2,axiom,
    ! [VarCurr] :
      ( ~ v255(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v270(VarCurr,B)
          <=> v273(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_2,axiom,
    ! [VarCurr] :
      ( v255(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v270(VarCurr,B)
          <=> $false ) ) ) ).

fof(bitBlastConstant_152,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex69) ).

fof(bitBlastConstant_151,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex68) ).

fof(bitBlastConstant_150,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex67) ).

fof(bitBlastConstant_149,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex66) ).

fof(bitBlastConstant_148,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex65) ).

fof(bitBlastConstant_147,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex64) ).

fof(bitBlastConstant_146,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex63) ).

fof(bitBlastConstant_145,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex62) ).

fof(bitBlastConstant_144,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex61) ).

fof(bitBlastConstant_143,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex60) ).

fof(bitBlastConstant_142,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex59) ).

fof(bitBlastConstant_141,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex58) ).

fof(bitBlastConstant_140,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex57) ).

fof(bitBlastConstant_139,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex56) ).

fof(bitBlastConstant_138,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex55) ).

fof(bitBlastConstant_137,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex54) ).

fof(bitBlastConstant_136,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex53) ).

fof(bitBlastConstant_135,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex52) ).

fof(bitBlastConstant_134,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex51) ).

fof(bitBlastConstant_133,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex50) ).

fof(bitBlastConstant_132,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex49) ).

fof(bitBlastConstant_131,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex48) ).

fof(bitBlastConstant_130,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex47) ).

fof(bitBlastConstant_129,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex46) ).

fof(bitBlastConstant_128,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex45) ).

fof(bitBlastConstant_127,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex44) ).

fof(bitBlastConstant_126,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex43) ).

fof(bitBlastConstant_125,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex42) ).

fof(bitBlastConstant_124,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex41) ).

fof(bitBlastConstant_123,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex40) ).

fof(bitBlastConstant_122,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex39) ).

fof(bitBlastConstant_121,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex38) ).

fof(bitBlastConstant_120,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex37) ).

fof(bitBlastConstant_119,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex36) ).

fof(bitBlastConstant_118,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex35) ).

fof(bitBlastConstant_117,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex34) ).

fof(bitBlastConstant_116,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex33) ).

fof(bitBlastConstant_115,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex32) ).

fof(bitBlastConstant_114,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex31) ).

fof(bitBlastConstant_113,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex30) ).

fof(bitBlastConstant_112,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex29) ).

fof(bitBlastConstant_111,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex28) ).

fof(bitBlastConstant_110,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex27) ).

fof(bitBlastConstant_109,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex26) ).

fof(bitBlastConstant_108,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex25) ).

fof(bitBlastConstant_107,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex24) ).

fof(bitBlastConstant_106,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex23) ).

fof(bitBlastConstant_105,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex22) ).

fof(bitBlastConstant_104,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex21) ).

fof(bitBlastConstant_103,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex20) ).

fof(bitBlastConstant_102,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex19) ).

fof(bitBlastConstant_101,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex18) ).

fof(bitBlastConstant_100,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex17) ).

fof(bitBlastConstant_99,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex16) ).

fof(bitBlastConstant_98,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex15) ).

fof(bitBlastConstant_97,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex14) ).

fof(bitBlastConstant_96,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex13) ).

fof(bitBlastConstant_95,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex12) ).

fof(bitBlastConstant_94,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex11) ).

fof(bitBlastConstant_93,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex10) ).

fof(bitBlastConstant_92,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex9) ).

fof(bitBlastConstant_91,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex8) ).

fof(bitBlastConstant_90,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex7) ).

fof(bitBlastConstant_89,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex6) ).

fof(bitBlastConstant_88,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex5) ).

fof(bitBlastConstant_87,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex4) ).

fof(bitBlastConstant_86,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex3) ).

fof(bitBlastConstant_85,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex2) ).

fof(bitBlastConstant_84,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex1) ).

fof(bitBlastConstant_83,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges2_1,axiom,
    ! [VarCurr] :
      ( ( ~ v259(VarCurr)
        & ~ v261(VarCurr) )
     => ! [B] :
          ( range_69_0(B)
         => ( v273(VarCurr,B)
          <=> v237(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1,axiom,
    ! [VarCurr] :
      ( v261(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v273(VarCurr,B)
          <=> v99(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1,axiom,
    ! [VarCurr] :
      ( v259(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v273(VarCurr,B)
          <=> v94(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_27,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v245(VarNext)
      <=> ( v246(VarNext)
          & v253(VarNext) ) ) ) ).

fof(addAssignment_68,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v253(VarNext)
      <=> v251(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26,axiom,
    ! [VarCurr] :
      ( v251(VarCurr)
    <=> ( v254(VarCurr)
        & v266(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_25,axiom,
    ! [VarCurr] :
      ( v266(VarCurr)
    <=> ( v267(VarCurr)
        | v255(VarCurr) ) ) ).

fof(writeUnaryOperator_15,axiom,
    ! [VarCurr] :
      ( ~ v267(VarCurr)
    <=> v268(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_9,axiom,
    ! [VarCurr] :
      ( v268(VarCurr)
    <=> ( ( v269(VarCurr,bitIndex1)
        <=> $false )
        & ( v269(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_67,axiom,
    ! [VarCurr] :
      ( v269(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_66,axiom,
    ! [VarCurr] :
      ( v269(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_24,axiom,
    ! [VarCurr] :
      ( v254(VarCurr)
    <=> ( v255(VarCurr)
        | v256(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_23,axiom,
    ! [VarCurr] :
      ( v256(VarCurr)
    <=> ( v257(VarCurr)
        & v265(VarCurr) ) ) ).

fof(writeUnaryOperator_14,axiom,
    ! [VarCurr] :
      ( ~ v265(VarCurr)
    <=> v255(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_22,axiom,
    ! [VarCurr] :
      ( v257(VarCurr)
    <=> ( v258(VarCurr)
        | v263(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_8,axiom,
    ! [VarCurr] :
      ( v263(VarCurr)
    <=> ( ( v264(VarCurr,bitIndex1)
        <=> $true )
        & ( v264(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_65,axiom,
    ! [VarCurr] :
      ( v264(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_64,axiom,
    ! [VarCurr] :
      ( v264(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_21,axiom,
    ! [VarCurr] :
      ( v258(VarCurr)
    <=> ( v259(VarCurr)
        | v261(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_7,axiom,
    ! [VarCurr] :
      ( v261(VarCurr)
    <=> ( ( v262(VarCurr,bitIndex1)
        <=> $true )
        & ( v262(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_63,axiom,
    ! [VarCurr] :
      ( v262(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_62,axiom,
    ! [VarCurr] :
      ( v262(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_6,axiom,
    ! [VarCurr] :
      ( v259(VarCurr)
    <=> ( ( v260(VarCurr,bitIndex1)
        <=> $false )
        & ( v260(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_61,axiom,
    ! [VarCurr] :
      ( v260(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_60,axiom,
    ! [VarCurr] :
      ( v260(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(writeUnaryOperator_13,axiom,
    ! [VarCurr] :
      ( ~ v255(VarCurr)
    <=> v34(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_20,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v246(VarNext)
      <=> ( v247(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_12,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v247(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_59,axiom,
    ! [VarCurr] :
      ( v237(VarCurr,bitIndex49)
    <=> v242(VarCurr,bitIndex49) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_4,axiom,
    ! [VarCurr] :
      ( ~ v239(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v242(VarCurr,B)
          <=> v241(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_4,axiom,
    ! [VarCurr] :
      ( v239(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v242(VarCurr,B)
          <=> v212(VarCurr,B) ) ) ) ).

fof(addAssignment_58,axiom,
    ! [VarCurr] :
      ( v241(VarCurr,bitIndex49)
    <=> v94(VarCurr,bitIndex49) ) ).

fof(addAssignment_57,axiom,
    ! [VarCurr] :
      ( v239(VarCurr)
    <=> v103(VarCurr,bitIndex7) ) ).

fof(addAssignment_56,axiom,
    ! [VarCurr] :
      ( v99(VarCurr,bitIndex49)
    <=> v235(VarCurr,bitIndex49) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3,axiom,
    ! [VarCurr] :
      ( ~ v101(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v235(VarCurr,B)
          <=> v218(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3,axiom,
    ! [VarCurr] :
      ( v101(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v235(VarCurr,B)
          <=> v212(VarCurr,B) ) ) ) ).

fof(range_axiom_2,axiom,
    ! [B] :
      ( range_69_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B
        | bitIndex30 = B
        | bitIndex31 = B
        | bitIndex32 = B
        | bitIndex33 = B
        | bitIndex34 = B
        | bitIndex35 = B
        | bitIndex36 = B
        | bitIndex37 = B
        | bitIndex38 = B
        | bitIndex39 = B
        | bitIndex40 = B
        | bitIndex41 = B
        | bitIndex42 = B
        | bitIndex43 = B
        | bitIndex44 = B
        | bitIndex45 = B
        | bitIndex46 = B
        | bitIndex47 = B
        | bitIndex48 = B
        | bitIndex49 = B
        | bitIndex50 = B
        | bitIndex51 = B
        | bitIndex52 = B
        | bitIndex53 = B
        | bitIndex54 = B
        | bitIndex55 = B
        | bitIndex56 = B
        | bitIndex57 = B
        | bitIndex58 = B
        | bitIndex59 = B
        | bitIndex60 = B
        | bitIndex61 = B
        | bitIndex62 = B
        | bitIndex63 = B
        | bitIndex64 = B
        | bitIndex65 = B
        | bitIndex66 = B
        | bitIndex67 = B
        | bitIndex68 = B
        | bitIndex69 = B ) ) ).

fof(addAssignment_55,axiom,
    ! [VarCurr] :
      ( v218(VarCurr,bitIndex49)
    <=> v94(VarCurr,bitIndex119) ) ).

fof(addAssignmentInitValue_74,axiom,
    ~ v94(constB0,bitIndex559) ).

fof(addAssignmentInitValue_73,axiom,
    ~ v94(constB0,bitIndex558) ).

fof(addAssignmentInitValue_72,axiom,
    ~ v94(constB0,bitIndex557) ).

fof(addAssignmentInitValue_71,axiom,
    ~ v94(constB0,bitIndex556) ).

fof(addAssignmentInitValue_70,axiom,
    ~ v94(constB0,bitIndex555) ).

fof(addAssignmentInitValue_69,axiom,
    ~ v94(constB0,bitIndex554) ).

fof(addAssignmentInitValue_68,axiom,
    ~ v94(constB0,bitIndex553) ).

fof(addAssignmentInitValue_67,axiom,
    ~ v94(constB0,bitIndex539) ).

fof(bitBlastConstant_82,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex69) ).

fof(bitBlastConstant_81,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex68) ).

fof(bitBlastConstant_80,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex67) ).

fof(bitBlastConstant_79,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex66) ).

fof(bitBlastConstant_78,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex65) ).

fof(bitBlastConstant_77,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex64) ).

fof(bitBlastConstant_76,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex63) ).

fof(bitBlastConstant_75,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex49) ).

fof(addAssignmentInitValue_66,axiom,
    ~ v94(constB0,bitIndex489) ).

fof(addAssignmentInitValue_65,axiom,
    ~ v94(constB0,bitIndex488) ).

fof(addAssignmentInitValue_64,axiom,
    ~ v94(constB0,bitIndex487) ).

fof(addAssignmentInitValue_63,axiom,
    ~ v94(constB0,bitIndex486) ).

fof(addAssignmentInitValue_62,axiom,
    ~ v94(constB0,bitIndex485) ).

fof(addAssignmentInitValue_61,axiom,
    ~ v94(constB0,bitIndex484) ).

fof(addAssignmentInitValue_60,axiom,
    ~ v94(constB0,bitIndex483) ).

fof(addAssignmentInitValue_59,axiom,
    ~ v94(constB0,bitIndex469) ).

fof(bitBlastConstant_74,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex69) ).

fof(bitBlastConstant_73,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex68) ).

fof(bitBlastConstant_72,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex67) ).

fof(bitBlastConstant_71,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex66) ).

fof(bitBlastConstant_70,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex65) ).

fof(bitBlastConstant_69,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex64) ).

fof(bitBlastConstant_68,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex63) ).

fof(bitBlastConstant_67,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex49) ).

fof(addAssignmentInitValue_58,axiom,
    ~ v94(constB0,bitIndex419) ).

fof(addAssignmentInitValue_57,axiom,
    ~ v94(constB0,bitIndex418) ).

fof(addAssignmentInitValue_56,axiom,
    ~ v94(constB0,bitIndex417) ).

fof(addAssignmentInitValue_55,axiom,
    ~ v94(constB0,bitIndex416) ).

fof(addAssignmentInitValue_54,axiom,
    ~ v94(constB0,bitIndex415) ).

fof(addAssignmentInitValue_53,axiom,
    ~ v94(constB0,bitIndex414) ).

fof(addAssignmentInitValue_52,axiom,
    ~ v94(constB0,bitIndex413) ).

fof(addAssignmentInitValue_51,axiom,
    ~ v94(constB0,bitIndex399) ).

fof(bitBlastConstant_66,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex69) ).

fof(bitBlastConstant_65,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex68) ).

fof(bitBlastConstant_64,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex67) ).

fof(bitBlastConstant_63,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex66) ).

fof(bitBlastConstant_62,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex65) ).

fof(bitBlastConstant_61,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex64) ).

fof(bitBlastConstant_60,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex63) ).

fof(bitBlastConstant_59,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex49) ).

fof(addAssignmentInitValue_50,axiom,
    ~ v94(constB0,bitIndex349) ).

fof(addAssignmentInitValue_49,axiom,
    ~ v94(constB0,bitIndex348) ).

fof(addAssignmentInitValue_48,axiom,
    ~ v94(constB0,bitIndex347) ).

fof(addAssignmentInitValue_47,axiom,
    ~ v94(constB0,bitIndex346) ).

fof(addAssignmentInitValue_46,axiom,
    ~ v94(constB0,bitIndex345) ).

fof(addAssignmentInitValue_45,axiom,
    ~ v94(constB0,bitIndex344) ).

fof(addAssignmentInitValue_44,axiom,
    ~ v94(constB0,bitIndex343) ).

fof(addAssignmentInitValue_43,axiom,
    ~ v94(constB0,bitIndex329) ).

fof(bitBlastConstant_58,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex69) ).

fof(bitBlastConstant_57,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex68) ).

fof(bitBlastConstant_56,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex67) ).

fof(bitBlastConstant_55,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex66) ).

fof(bitBlastConstant_54,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex65) ).

fof(bitBlastConstant_53,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex64) ).

fof(bitBlastConstant_52,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex63) ).

fof(bitBlastConstant_51,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex49) ).

fof(addAssignmentInitValue_42,axiom,
    ~ v94(constB0,bitIndex279) ).

fof(addAssignmentInitValue_41,axiom,
    ~ v94(constB0,bitIndex278) ).

fof(addAssignmentInitValue_40,axiom,
    ~ v94(constB0,bitIndex277) ).

fof(addAssignmentInitValue_39,axiom,
    ~ v94(constB0,bitIndex276) ).

fof(addAssignmentInitValue_38,axiom,
    ~ v94(constB0,bitIndex275) ).

fof(addAssignmentInitValue_37,axiom,
    ~ v94(constB0,bitIndex274) ).

fof(addAssignmentInitValue_36,axiom,
    ~ v94(constB0,bitIndex273) ).

fof(addAssignmentInitValue_35,axiom,
    ~ v94(constB0,bitIndex259) ).

fof(bitBlastConstant_50,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex69) ).

fof(bitBlastConstant_49,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex68) ).

fof(bitBlastConstant_48,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex67) ).

fof(bitBlastConstant_47,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex66) ).

fof(bitBlastConstant_46,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex65) ).

fof(bitBlastConstant_45,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex64) ).

fof(bitBlastConstant_44,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex63) ).

fof(bitBlastConstant_43,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex49) ).

fof(addAssignmentInitValue_34,axiom,
    ~ v94(constB0,bitIndex209) ).

fof(addAssignmentInitValue_33,axiom,
    ~ v94(constB0,bitIndex208) ).

fof(addAssignmentInitValue_32,axiom,
    ~ v94(constB0,bitIndex207) ).

fof(addAssignmentInitValue_31,axiom,
    ~ v94(constB0,bitIndex206) ).

fof(addAssignmentInitValue_30,axiom,
    ~ v94(constB0,bitIndex205) ).

fof(addAssignmentInitValue_29,axiom,
    ~ v94(constB0,bitIndex204) ).

fof(addAssignmentInitValue_28,axiom,
    ~ v94(constB0,bitIndex203) ).

fof(addAssignmentInitValue_27,axiom,
    ~ v94(constB0,bitIndex189) ).

fof(bitBlastConstant_42,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex69) ).

fof(bitBlastConstant_41,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex68) ).

fof(bitBlastConstant_40,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex67) ).

fof(bitBlastConstant_39,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex66) ).

fof(bitBlastConstant_38,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex65) ).

fof(bitBlastConstant_37,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex64) ).

fof(bitBlastConstant_36,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex63) ).

fof(bitBlastConstant_35,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex49) ).

fof(addAssignmentInitValue_26,axiom,
    ~ v94(constB0,bitIndex139) ).

fof(addAssignmentInitValue_25,axiom,
    ~ v94(constB0,bitIndex138) ).

fof(addAssignmentInitValue_24,axiom,
    ~ v94(constB0,bitIndex137) ).

fof(addAssignmentInitValue_23,axiom,
    ~ v94(constB0,bitIndex136) ).

fof(addAssignmentInitValue_22,axiom,
    ~ v94(constB0,bitIndex135) ).

fof(addAssignmentInitValue_21,axiom,
    ~ v94(constB0,bitIndex134) ).

fof(addAssignmentInitValue_20,axiom,
    ~ v94(constB0,bitIndex133) ).

fof(addAssignmentInitValue_19,axiom,
    ~ v94(constB0,bitIndex119) ).

fof(bitBlastConstant_34,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex69) ).

fof(bitBlastConstant_33,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex68) ).

fof(bitBlastConstant_32,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex67) ).

fof(bitBlastConstant_31,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex66) ).

fof(bitBlastConstant_30,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex65) ).

fof(bitBlastConstant_29,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex64) ).

fof(bitBlastConstant_28,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex63) ).

fof(bitBlastConstant_27,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex49) ).

fof(addAssignmentInitValue_18,axiom,
    ~ v94(constB0,bitIndex69) ).

fof(addAssignmentInitValue_17,axiom,
    ~ v94(constB0,bitIndex68) ).

fof(addAssignmentInitValue_16,axiom,
    ~ v94(constB0,bitIndex67) ).

fof(addAssignmentInitValue_15,axiom,
    ~ v94(constB0,bitIndex66) ).

fof(addAssignmentInitValue_14,axiom,
    ~ v94(constB0,bitIndex65) ).

fof(addAssignmentInitValue_13,axiom,
    ~ v94(constB0,bitIndex64) ).

fof(addAssignmentInitValue_12,axiom,
    ~ v94(constB0,bitIndex63) ).

fof(addAssignmentInitValue_11,axiom,
    ~ v94(constB0,bitIndex49) ).

fof(bitBlastConstant_26,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex69) ).

fof(bitBlastConstant_25,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex68) ).

fof(bitBlastConstant_24,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex67) ).

fof(bitBlastConstant_23,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex66) ).

fof(bitBlastConstant_22,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex65) ).

fof(bitBlastConstant_21,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex64) ).

fof(bitBlastConstant_20,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex63) ).

fof(bitBlastConstant_19,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex49) ).

fof(addAssignment_54,axiom,
    ! [VarCurr] :
      ( v212(VarCurr,bitIndex49)
    <=> v214(VarCurr,bitIndex49) ) ).

fof(addAssignment_53,axiom,
    ! [VarCurr] :
      ( v214(VarCurr,bitIndex49)
    <=> v216(VarCurr,bitIndex49) ) ).

fof(addAssignment_52,axiom,
    ! [VarCurr] :
      ( v101(VarCurr)
    <=> v103(VarCurr,bitIndex7) ) ).

fof(addAssignment_51,axiom,
    ! [VarCurr] :
      ( v103(VarCurr,bitIndex7)
    <=> v131(VarCurr,bitIndex7) ) ).

fof(addAssignment_50,axiom,
    ! [VarNext] :
      ( v107(VarNext,bitIndex6)
    <=> v204(VarNext,bitIndex6) ) ).

fof(addCaseBooleanConditionEqualRanges1_8,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v205(VarNext)
       => ! [B] :
            ( range_10_0(B)
           => ( v204(VarNext,B)
            <=> v107(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_8,axiom,
    ! [VarNext] :
      ( v205(VarNext)
     => ! [B] :
          ( range_10_0(B)
         => ( v204(VarNext,B)
          <=> v125(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_19,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v205(VarNext)
      <=> v206(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_18,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v206(VarNext)
      <=> ( v208(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_11,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v208(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_49,axiom,
    ! [VarCurr] :
      ( v103(VarCurr,bitIndex6)
    <=> v131(VarCurr,bitIndex6) ) ).

fof(addAssignment_48,axiom,
    ! [VarNext] :
      ( v107(VarNext,bitIndex5)
    <=> v196(VarNext,bitIndex5) ) ).

fof(addCaseBooleanConditionEqualRanges1_7,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v197(VarNext)
       => ! [B] :
            ( range_10_0(B)
           => ( v196(VarNext,B)
            <=> v107(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_7,axiom,
    ! [VarNext] :
      ( v197(VarNext)
     => ! [B] :
          ( range_10_0(B)
         => ( v196(VarNext,B)
          <=> v125(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_17,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v197(VarNext)
      <=> v198(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_16,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v198(VarNext)
      <=> ( v200(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_10,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v200(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_47,axiom,
    ! [VarCurr] :
      ( v103(VarCurr,bitIndex5)
    <=> v131(VarCurr,bitIndex5) ) ).

fof(addAssignment_46,axiom,
    ! [VarNext] :
      ( v107(VarNext,bitIndex4)
    <=> v188(VarNext,bitIndex4) ) ).

fof(addCaseBooleanConditionEqualRanges1_6,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v189(VarNext)
       => ! [B] :
            ( range_10_0(B)
           => ( v188(VarNext,B)
            <=> v107(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_6,axiom,
    ! [VarNext] :
      ( v189(VarNext)
     => ! [B] :
          ( range_10_0(B)
         => ( v188(VarNext,B)
          <=> v125(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_15,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v189(VarNext)
      <=> v190(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_14,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v190(VarNext)
      <=> ( v192(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_9,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v192(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_45,axiom,
    ! [VarCurr] :
      ( v103(VarCurr,bitIndex4)
    <=> v131(VarCurr,bitIndex4) ) ).

fof(addAssignment_44,axiom,
    ! [VarNext] :
      ( v107(VarNext,bitIndex3)
    <=> v180(VarNext,bitIndex3) ) ).

fof(addCaseBooleanConditionEqualRanges1_5,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v181(VarNext)
       => ! [B] :
            ( range_10_0(B)
           => ( v180(VarNext,B)
            <=> v107(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_5,axiom,
    ! [VarNext] :
      ( v181(VarNext)
     => ! [B] :
          ( range_10_0(B)
         => ( v180(VarNext,B)
          <=> v125(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_13,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v181(VarNext)
      <=> v182(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_12,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v182(VarNext)
      <=> ( v184(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_8,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v184(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_43,axiom,
    ! [VarCurr] :
      ( v103(VarCurr,bitIndex3)
    <=> v131(VarCurr,bitIndex3) ) ).

fof(addAssignment_42,axiom,
    ! [VarNext] :
      ( v107(VarNext,bitIndex2)
    <=> v172(VarNext,bitIndex2) ) ).

fof(addCaseBooleanConditionEqualRanges1_4,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v173(VarNext)
       => ! [B] :
            ( range_10_0(B)
           => ( v172(VarNext,B)
            <=> v107(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_4,axiom,
    ! [VarNext] :
      ( v173(VarNext)
     => ! [B] :
          ( range_10_0(B)
         => ( v172(VarNext,B)
          <=> v125(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v173(VarNext)
      <=> v174(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v174(VarNext)
      <=> ( v176(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_7,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v176(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_41,axiom,
    ! [VarCurr] :
      ( v103(VarCurr,bitIndex2)
    <=> v131(VarCurr,bitIndex2) ) ).

fof(addAssignment_40,axiom,
    ! [VarNext] :
      ( v107(VarNext,bitIndex1)
    <=> v164(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_3,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v165(VarNext)
       => ! [B] :
            ( range_10_0(B)
           => ( v164(VarNext,B)
            <=> v107(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_3,axiom,
    ! [VarNext] :
      ( v165(VarNext)
     => ! [B] :
          ( range_10_0(B)
         => ( v164(VarNext,B)
          <=> v125(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_9,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v165(VarNext)
      <=> v166(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_8,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v166(VarNext)
      <=> ( v168(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_6,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v168(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_39,axiom,
    ! [VarCurr] :
      ( v103(VarCurr,bitIndex1)
    <=> v131(VarCurr,bitIndex1) ) ).

fof(addAssignment_38,axiom,
    ! [VarNext] :
      ( v107(VarNext,bitIndex0)
    <=> v156(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionEqualRanges1_2,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v157(VarNext)
       => ! [B] :
            ( range_10_0(B)
           => ( v156(VarNext,B)
            <=> v107(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2,axiom,
    ! [VarNext] :
      ( v157(VarNext)
     => ! [B] :
          ( range_10_0(B)
         => ( v156(VarNext,B)
          <=> v125(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_7,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v157(VarNext)
      <=> v158(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_6,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v158(VarNext)
      <=> ( v160(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_5,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v160(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_37,axiom,
    ! [VarCurr] :
      ( v103(VarCurr,bitIndex0)
    <=> v131(VarCurr,bitIndex0) ) ).

fof(addAssignment_36,axiom,
    ! [VarCurr] :
      ( v105(VarCurr,bitIndex1)
    <=> v129(VarCurr,bitIndex1) ) ).

fof(addAssignment_35,axiom,
    ! [VarCurr] :
      ( v105(VarCurr,bitIndex2)
    <=> v129(VarCurr,bitIndex2) ) ).

fof(addAssignment_34,axiom,
    ! [VarCurr] :
      ( v105(VarCurr,bitIndex3)
    <=> v129(VarCurr,bitIndex3) ) ).

fof(addAssignment_33,axiom,
    ! [VarCurr] :
      ( v105(VarCurr,bitIndex4)
    <=> v129(VarCurr,bitIndex4) ) ).

fof(addAssignment_32,axiom,
    ! [VarCurr] :
      ( v105(VarCurr,bitIndex5)
    <=> v129(VarCurr,bitIndex5) ) ).

fof(addAssignment_31,axiom,
    ! [VarCurr] :
      ( v105(VarCurr,bitIndex6)
    <=> v129(VarCurr,bitIndex6) ) ).

fof(addAssignment_30,axiom,
    ! [VarNext] :
      ( v107(VarNext,bitIndex8)
    <=> v148(VarNext,bitIndex8) ) ).

fof(addCaseBooleanConditionEqualRanges1_1,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v149(VarNext)
       => ! [B] :
            ( range_10_0(B)
           => ( v148(VarNext,B)
            <=> v107(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1,axiom,
    ! [VarNext] :
      ( v149(VarNext)
     => ! [B] :
          ( range_10_0(B)
         => ( v148(VarNext,B)
          <=> v125(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v149(VarNext)
      <=> v150(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v150(VarNext)
      <=> ( v152(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_4,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v152(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_29,axiom,
    ! [VarCurr] :
      ( v103(VarCurr,bitIndex8)
    <=> v131(VarCurr,bitIndex8) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_2,axiom,
    ! [VarCurr] :
      ( ~ v132(VarCurr)
     => ! [B] :
          ( range_10_0(B)
         => ( v131(VarCurr,B)
          <=> v134(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2,axiom,
    ! [VarCurr] :
      ( v132(VarCurr)
     => ! [B] :
          ( range_10_0(B)
         => ( v131(VarCurr,B)
          <=> v133(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3,axiom,
    ! [VarCurr] :
      ( ( ~ v135(VarCurr)
        & ~ v137(VarCurr)
        & ~ v141(VarCurr) )
     => ! [B] :
          ( range_10_0(B)
         => ( v134(VarCurr,B)
          <=> v107(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2,axiom,
    ! [VarCurr] :
      ( v141(VarCurr)
     => ! [B] :
          ( range_10_0(B)
         => ( v134(VarCurr,B)
          <=> v143(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1,axiom,
    ! [VarCurr] :
      ( v137(VarCurr)
     => ! [B] :
          ( range_10_0(B)
         => ( v134(VarCurr,B)
          <=> v139(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0,axiom,
    ! [VarCurr] :
      ( v135(VarCurr)
     => ! [B] :
          ( range_10_0(B)
         => ( v134(VarCurr,B)
          <=> v107(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_5,axiom,
    ! [VarCurr] :
      ( v145(VarCurr)
    <=> ( ( v146(VarCurr,bitIndex1)
        <=> $true )
        & ( v146(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_18,axiom,
    b11(bitIndex1) ).

fof(bitBlastConstant_17,axiom,
    b11(bitIndex0) ).

fof(addAssignment_28,axiom,
    ! [VarCurr] :
      ( v146(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_27,axiom,
    ! [VarCurr] :
      ( v146(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(addAssignment_26,axiom,
    ! [VarCurr] :
      ( v143(VarCurr,bitIndex0)
    <=> $false ) ).

fof(addAssignment_25,axiom,
    ! [VarCurr] :
      ( ( v143(VarCurr,bitIndex10)
      <=> v107(VarCurr,bitIndex9) )
      & ( v143(VarCurr,bitIndex9)
      <=> v107(VarCurr,bitIndex8) )
      & ( v143(VarCurr,bitIndex8)
      <=> v107(VarCurr,bitIndex7) )
      & ( v143(VarCurr,bitIndex7)
      <=> v107(VarCurr,bitIndex6) )
      & ( v143(VarCurr,bitIndex6)
      <=> v107(VarCurr,bitIndex5) )
      & ( v143(VarCurr,bitIndex5)
      <=> v107(VarCurr,bitIndex4) )
      & ( v143(VarCurr,bitIndex4)
      <=> v107(VarCurr,bitIndex3) )
      & ( v143(VarCurr,bitIndex3)
      <=> v107(VarCurr,bitIndex2) )
      & ( v143(VarCurr,bitIndex2)
      <=> v107(VarCurr,bitIndex1) )
      & ( v143(VarCurr,bitIndex1)
      <=> v107(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_4,axiom,
    ! [VarCurr] :
      ( v141(VarCurr)
    <=> ( ( v142(VarCurr,bitIndex1)
        <=> $true )
        & ( v142(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_16,axiom,
    b10(bitIndex1) ).

fof(bitBlastConstant_15,axiom,
    ~ b10(bitIndex0) ).

fof(addAssignment_24,axiom,
    ! [VarCurr] :
      ( v142(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_23,axiom,
    ! [VarCurr] :
      ( v142(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(addAssignment_22,axiom,
    ! [VarCurr] :
      ( ( v139(VarCurr,bitIndex9)
      <=> v107(VarCurr,bitIndex10) )
      & ( v139(VarCurr,bitIndex8)
      <=> v107(VarCurr,bitIndex9) )
      & ( v139(VarCurr,bitIndex7)
      <=> v107(VarCurr,bitIndex8) )
      & ( v139(VarCurr,bitIndex6)
      <=> v107(VarCurr,bitIndex7) )
      & ( v139(VarCurr,bitIndex5)
      <=> v107(VarCurr,bitIndex6) )
      & ( v139(VarCurr,bitIndex4)
      <=> v107(VarCurr,bitIndex5) )
      & ( v139(VarCurr,bitIndex3)
      <=> v107(VarCurr,bitIndex4) )
      & ( v139(VarCurr,bitIndex2)
      <=> v107(VarCurr,bitIndex3) )
      & ( v139(VarCurr,bitIndex1)
      <=> v107(VarCurr,bitIndex2) )
      & ( v139(VarCurr,bitIndex0)
      <=> v107(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_21,axiom,
    ! [VarCurr] :
      ( v139(VarCurr,bitIndex10)
    <=> $false ) ).

fof(addBitVectorEqualityBitBlasted_3,axiom,
    ! [VarCurr] :
      ( v137(VarCurr)
    <=> ( ( v138(VarCurr,bitIndex1)
        <=> $false )
        & ( v138(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_14,axiom,
    ~ b01(bitIndex1) ).

fof(bitBlastConstant_13,axiom,
    b01(bitIndex0) ).

fof(addAssignment_20,axiom,
    ! [VarCurr] :
      ( v138(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_19,axiom,
    ! [VarCurr] :
      ( v138(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_2,axiom,
    ! [VarCurr] :
      ( v135(VarCurr)
    <=> ( ( v136(VarCurr,bitIndex1)
        <=> $false )
        & ( v136(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_18,axiom,
    ! [VarCurr] :
      ( v136(VarCurr,bitIndex0)
    <=> v43(VarCurr) ) ).

fof(addAssignment_17,axiom,
    ! [VarCurr] :
      ( v136(VarCurr,bitIndex1)
    <=> v36(VarCurr) ) ).

fof(addAssignment_16,axiom,
    ! [VarCurr] :
      ( v133(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_15,axiom,
    ! [VarCurr,B] :
      ( range_10_1(B)
     => ( v133(VarCurr,B)
      <=> v105(VarCurr,B) ) ) ).

fof(writeUnaryOperator_3,axiom,
    ! [VarCurr] :
      ( ~ v132(VarCurr)
    <=> v34(VarCurr) ) ).

fof(addAssignment_14,axiom,
    ! [VarCurr] :
      ( v105(VarCurr,bitIndex8)
    <=> v129(VarCurr,bitIndex8) ) ).

fof(addAssignment_13,axiom,
    ! [VarCurr] :
      ( v105(VarCurr,bitIndex7)
    <=> v129(VarCurr,bitIndex7) ) ).

fof(addAssignment_12,axiom,
    ! [VarCurr] :
      ( v129(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_11,axiom,
    ! [VarCurr,B] :
      ( range_10_1(B)
     => ( v129(VarCurr,B)
      <=> v107(VarCurr,B) ) ) ).

fof(range_axiom_1,axiom,
    ! [B] :
      ( range_10_1(B)
    <=> ( $false
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B ) ) ).

fof(addAssignment_10,axiom,
    ! [VarNext] :
      ( v107(VarNext,bitIndex7)
    <=> v114(VarNext,bitIndex7) ) ).

fof(addCaseBooleanConditionEqualRanges1,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v115(VarNext)
       => ! [B] :
            ( range_10_0(B)
           => ( v114(VarNext,B)
            <=> v107(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0,axiom,
    ! [VarNext] :
      ( v115(VarNext)
     => ! [B] :
          ( range_10_0(B)
         => ( v114(VarNext,B)
          <=> v125(VarNext,B) ) ) ) ).

fof(addAssignment_9,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_10_0(B)
         => ( v125(VarNext,B)
          <=> v123(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1,axiom,
    ! [VarCurr] :
      ( ~ v126(VarCurr)
     => ! [B] :
          ( range_10_0(B)
         => ( v123(VarCurr,B)
          <=> v103(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1,axiom,
    ! [VarCurr] :
      ( v126(VarCurr)
     => ! [B] :
          ( range_10_0(B)
         => ( v123(VarCurr,B)
          <=> b00000000001(B) ) ) ) ).

fof(range_axiom,axiom,
    ! [B] :
      ( range_10_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B ) ) ).

fof(writeUnaryOperator_2,axiom,
    ! [VarCurr] :
      ( ~ v126(VarCurr)
    <=> v34(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v115(VarNext)
      <=> v116(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v116(VarNext)
      <=> ( v117(VarNext)
          & v110(VarNext) ) ) ) ).

fof(writeUnaryOperator_1,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v117(VarNext)
      <=> v119(VarNext) ) ) ).

fof(addAssignment_8,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v119(VarNext)
      <=> v110(VarCurr) ) ) ).

fof(addAssignmentInitValue_10,axiom,
    ~ v107(constB0,bitIndex10) ).

fof(addAssignmentInitValue_9,axiom,
    ~ v107(constB0,bitIndex9) ).

fof(addAssignmentInitValue_8,axiom,
    ~ v107(constB0,bitIndex8) ).

fof(addAssignmentInitValue_7,axiom,
    ~ v107(constB0,bitIndex7) ).

fof(addAssignmentInitValue_6,axiom,
    ~ v107(constB0,bitIndex6) ).

fof(addAssignmentInitValue_5,axiom,
    ~ v107(constB0,bitIndex5) ).

fof(addAssignmentInitValue_4,axiom,
    ~ v107(constB0,bitIndex4) ).

fof(addAssignmentInitValue_3,axiom,
    ~ v107(constB0,bitIndex3) ).

fof(addAssignmentInitValue_2,axiom,
    ~ v107(constB0,bitIndex2) ).

fof(addAssignmentInitValue_1,axiom,
    ~ v107(constB0,bitIndex1) ).

fof(addAssignmentInitValue,axiom,
    v107(constB0,bitIndex0) ).

fof(bitBlastConstant_12,axiom,
    ~ b00000000001(bitIndex10) ).

fof(bitBlastConstant_11,axiom,
    ~ b00000000001(bitIndex9) ).

fof(bitBlastConstant_10,axiom,
    ~ b00000000001(bitIndex8) ).

fof(bitBlastConstant_9,axiom,
    ~ b00000000001(bitIndex7) ).

fof(bitBlastConstant_8,axiom,
    ~ b00000000001(bitIndex6) ).

fof(bitBlastConstant_7,axiom,
    ~ b00000000001(bitIndex5) ).

fof(bitBlastConstant_6,axiom,
    ~ b00000000001(bitIndex4) ).

fof(bitBlastConstant_5,axiom,
    ~ b00000000001(bitIndex3) ).

fof(bitBlastConstant_4,axiom,
    ~ b00000000001(bitIndex2) ).

fof(bitBlastConstant_3,axiom,
    ~ b00000000001(bitIndex1) ).

fof(bitBlastConstant_2,axiom,
    b00000000001(bitIndex0) ).

fof(addAssignment_7,axiom,
    ! [VarCurr] :
      ( v110(VarCurr)
    <=> v112(VarCurr) ) ).

fof(addAssignment_6,axiom,
    ! [VarCurr] :
      ( v112(VarCurr)
    <=> v1(VarCurr) ) ).

fof(addAssignment_5,axiom,
    ! [VarCurr] :
      ( v64(VarCurr)
    <=> v11(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch,axiom,
    ! [VarCurr] :
      ( ~ v50(VarCurr)
     => ( v47(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch,axiom,
    ! [VarCurr] :
      ( v50(VarCurr)
     => ( v47(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1,axiom,
    ! [VarCurr] :
      ( v50(VarCurr)
    <=> ( v51(VarCurr)
        & v54(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_1,axiom,
    ! [VarCurr] :
      ( v54(VarCurr)
    <=> ( $true
      <=> v7(VarCurr,bitIndex0) ) ) ).

fof(addAssignmentInitValueVector_1,axiom,
    ( ( v7(constB0,bitIndex2)
    <=> $false )
    & ( v7(constB0,bitIndex1)
    <=> $false ) ) ).

fof(addAssignmentInitValueVector,axiom,
    ( v7(constB0,bitIndex0)
  <=> $true ) ).

fof(writeBinaryOperatorEqualRangesSingleBits,axiom,
    ! [VarCurr] :
      ( v51(VarCurr)
    <=> ( v52(VarCurr)
        & v53(VarCurr) ) ) ).

fof(writeUnaryOperator,axiom,
    ! [VarCurr] :
      ( ~ v53(VarCurr)
    <=> v30(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted,axiom,
    ! [VarCurr] :
      ( v52(VarCurr)
    <=> ( ( v28(VarCurr,bitIndex1)
        <=> $false )
        & ( v28(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_1,axiom,
    ~ b00(bitIndex1) ).

fof(bitBlastConstant,axiom,
    ~ b00(bitIndex0) ).

fof(addAssignment_4,axiom,
    ! [VarCurr] :
      ( v36(VarCurr)
    <=> v38(VarCurr) ) ).

fof(addAssignment_3,axiom,
    ! [VarCurr] :
      ( v38(VarCurr)
    <=> v40(VarCurr) ) ).

fof(addAssignment_2,axiom,
    ! [VarCurr] :
      ( v34(VarCurr)
    <=> v9(VarCurr) ) ).

fof(addAssignment_1,axiom,
    ! [VarCurr] :
      ( v22(VarCurr)
    <=> v24(VarCurr) ) ).

fof(addAssignment,axiom,
    ! [VarCurr] :
      ( v9(VarCurr)
    <=> v11(VarCurr) ) ).

%------------------------------------------------------------------------------
