%------------------------------------------------------------------------------
% File     : HWV111_2 : TPTP v9.2.0. Bugfixed v6.2.0.
% Domain   : Hardware Verification
% Problem  : dmu_rmu_rrm property 1 cone of influence 5_b20
% Version  : Especial.
% English  : Verification of a property of the SPARCT2 RTL hardware design.

% Refs     : [Kha14] Khasidashvili (2014), Email to Geoff Sutcliffe
% Source   : [Kha14]
% Names    : dmu_rmu_rrm_prop1_cone5_b20 [Kha14]

% Status   : Theorem
% Rating   : 0.62 v9.1.0, 0.88 v9.0.0, 0.75 v8.2.0, 0.62 v7.5.0, 0.60 v7.4.0, 0.62 v7.3.0, 0.50 v7.0.0, 0.86 v6.4.0, 1.00 v6.3.0, 0.86 v6.2.0
% Syntax   : Number of formulae    : 1475 ( 399 unt; 484 typ;   0 def)
%            Number of atoms       : 3804 (  21 equ)
%            Maximal formula atoms :  142 (   2 avg)
%            Number of connectives : 3366 ( 553   ~;  75   |; 970   &)
%                                         (1421 <=>; 347  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   75 (   4 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number arithmetic     : 2601 ( 198 atm;   0 fun;2304 num;  99 var)
%            Number of types       :    3 (   1 usr;   1 ari)
%            Number of type conns  :  579 ( 461   >; 118   *;   0   +;   0  <<)
%            Number of predicates  :  466 ( 462 usr;   3 prp; 0-2 aty)
%            Number of functors    :  396 (  21 usr; 396 con; 0-0 aty)
%            Number of variables   :  791 ( 791   !;   0   ?; 791   :)
% SPC      : TF0_THM_EQU_ARI

% Comments : Copyright 2013 Moshe Emmer and Zurab Khasidashvili
%            Licensed under the Apache License, Version 2.0 (the "License");
%            you may not use this file except in compliance with the License.
%            You may obtain a copy of the License at
%                http://www.apache.org/licenses/LICENSE-2.0
%            Unless required by applicable law or agreed to in writing,
%            software distributed under the License is distributed on an "AS
%            IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
%            express or implied. See the License for the specific language
%            governing permissions and limitations under the License.
% Bugfixes : v6.2.0 - Fixed type declarations.
%------------------------------------------------------------------------------
tff(state_type,type,
    state_type: $tType ).

tff(v24_type,type,
    v24: state_type > $o ).

tff(v40_type,type,
    v40: state_type > $o ).

tff(v38_type,type,
    v38: state_type > $o ).

tff(v11_type,type,
    v11: state_type > $o ).

tff(v34_type,type,
    v34: state_type > $o ).

tff(v36_type,type,
    v36: state_type > $o ).

tff(v22_type,type,
    v22: state_type > $o ).

tff(v9_type,type,
    v9: state_type > $o ).

tff(constB0_type,type,
    constB0: state_type ).

tff(constB1_type,type,
    constB1: state_type ).

tff(constB2_type,type,
    constB2: state_type ).

tff(constB3_type,type,
    constB3: state_type ).

tff(constB4_type,type,
    constB4: state_type ).

tff(constB5_type,type,
    constB5: state_type ).

tff(constB6_type,type,
    constB6: state_type ).

tff(constB7_type,type,
    constB7: state_type ).

tff(constB8_type,type,
    constB8: state_type ).

tff(constB9_type,type,
    constB9: state_type ).

tff(constB10_type,type,
    constB10: state_type ).

tff(constB11_type,type,
    constB11: state_type ).

tff(constB12_type,type,
    constB12: state_type ).

tff(constB13_type,type,
    constB13: state_type ).

tff(constB14_type,type,
    constB14: state_type ).

tff(constB15_type,type,
    constB15: state_type ).

tff(constB16_type,type,
    constB16: state_type ).

tff(constB17_type,type,
    constB17: state_type ).

tff(constB18_type,type,
    constB18: state_type ).

tff(constB19_type,type,
    constB19: state_type ).

tff(constB20_type,type,
    constB20: state_type ).

tff(pred_def_9,type,
    b00: $int > $o ).

tff(pred_def_10,type,
    v28: ( state_type * $int ) > $o ).

tff(pred_def_11,type,
    v52: state_type > $o ).

tff(pred_def_12,type,
    v30: state_type > $o ).

tff(pred_def_13,type,
    v53: state_type > $o ).

tff(pred_def_14,type,
    v51: state_type > $o ).

tff(pred_def_15,type,
    v7: ( state_type * $int ) > $o ).

tff(pred_def_16,type,
    v54: state_type > $o ).

tff(pred_def_17,type,
    v50: state_type > $o ).

tff(pred_def_18,type,
    v47: state_type > $o ).

tff(pred_def_19,type,
    v64: state_type > $o ).

tff(pred_def_20,type,
    v112: state_type > $o ).

tff(pred_def_21,type,
    v1: state_type > $o ).

tff(pred_def_22,type,
    v110: state_type > $o ).

tff(pred_def_23,type,
    b00000000001: $int > $o ).

tff(pred_def_24,type,
    v107: ( state_type * $int ) > $o ).

tff(pred_def_25,type,
    v119: state_type > $o ).

tff(pred_def_26,type,
    nextState: ( state_type * state_type ) > $o ).

tff(pred_def_27,type,
    v117: state_type > $o ).

tff(pred_def_28,type,
    v116: state_type > $o ).

tff(pred_def_29,type,
    v115: state_type > $o ).

tff(pred_def_30,type,
    v126: state_type > $o ).

tff(pred_def_31,type,
    v123: ( state_type * $int ) > $o ).

tff(pred_def_33,type,
    v103: ( state_type * $int ) > $o ).

tff(pred_def_34,type,
    v125: ( state_type * $int ) > $o ).

tff(pred_def_35,type,
    v114: ( state_type * $int ) > $o ).

tff(pred_def_36,type,
    undeclared: $o ).

tff(pred_def_37,type,
    v129: ( state_type * $int ) > $o ).

tff(pred_def_38,type,
    v105: ( state_type * $int ) > $o ).

tff(pred_def_39,type,
    v132: state_type > $o ).

tff(pred_def_40,type,
    v133: ( state_type * $int ) > $o ).

tff(pred_def_41,type,
    v136: ( state_type * $int ) > $o ).

tff(pred_def_42,type,
    v43: state_type > $o ).

tff(pred_def_43,type,
    v135: state_type > $o ).

tff(pred_def_44,type,
    v138: ( state_type * $int ) > $o ).

tff(pred_def_45,type,
    b01: $int > $o ).

tff(pred_def_46,type,
    v137: state_type > $o ).

tff(pred_def_47,type,
    v139: ( state_type * $int ) > $o ).

tff(pred_def_48,type,
    v142: ( state_type * $int ) > $o ).

tff(pred_def_49,type,
    b10: $int > $o ).

tff(pred_def_50,type,
    v141: state_type > $o ).

tff(pred_def_51,type,
    v143: ( state_type * $int ) > $o ).

tff(pred_def_52,type,
    v146: ( state_type * $int ) > $o ).

tff(pred_def_53,type,
    b11: $int > $o ).

tff(pred_def_54,type,
    v145: state_type > $o ).

tff(pred_def_55,type,
    v134: ( state_type * $int ) > $o ).

tff(pred_def_56,type,
    v131: ( state_type * $int ) > $o ).

tff(pred_def_57,type,
    v152: state_type > $o ).

tff(pred_def_58,type,
    v150: state_type > $o ).

tff(pred_def_59,type,
    v149: state_type > $o ).

tff(pred_def_60,type,
    v148: ( state_type * $int ) > $o ).

tff(pred_def_61,type,
    v160: state_type > $o ).

tff(pred_def_62,type,
    v158: state_type > $o ).

tff(pred_def_63,type,
    v157: state_type > $o ).

tff(pred_def_64,type,
    v156: ( state_type * $int ) > $o ).

tff(pred_def_65,type,
    v168: state_type > $o ).

tff(pred_def_66,type,
    v166: state_type > $o ).

tff(pred_def_67,type,
    v165: state_type > $o ).

tff(pred_def_68,type,
    v164: ( state_type * $int ) > $o ).

tff(pred_def_69,type,
    v101: state_type > $o ).

tff(pred_def_70,type,
    v174: ( state_type * $int ) > $o ).

tff(pred_def_71,type,
    v176: ( state_type * $int ) > $o ).

tff(pred_def_72,type,
    v172: ( state_type * $int ) > $o ).

tff(pred_def_73,type,
    b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx: $int > $o ).

tff(pred_def_74,type,
    v94: ( state_type * $int ) > $o ).

tff(pred_def_75,type,
    v178: ( state_type * $int ) > $o ).

tff(pred_def_76,type,
    v195: ( state_type * $int ) > $o ).

tff(pred_def_77,type,
    v99: ( state_type * $int ) > $o ).

tff(pred_def_78,type,
    v199: state_type > $o ).

tff(pred_def_79,type,
    v201: ( state_type * $int ) > $o ).

tff(pred_def_80,type,
    v202: ( state_type * $int ) > $o ).

tff(pred_def_81,type,
    v197: ( state_type * $int ) > $o ).

tff(pred_def_82,type,
    v207: state_type > $o ).

tff(pred_def_83,type,
    v206: state_type > $o ).

tff(pred_def_84,type,
    v215: state_type > $o ).

tff(pred_def_85,type,
    v220: ( state_type * $int ) > $o ).

tff(pred_def_86,type,
    v219: state_type > $o ).

tff(pred_def_87,type,
    v222: ( state_type * $int ) > $o ).

tff(pred_def_88,type,
    v221: state_type > $o ).

tff(pred_def_89,type,
    v218: state_type > $o ).

tff(pred_def_90,type,
    v224: ( state_type * $int ) > $o ).

tff(pred_def_91,type,
    v223: state_type > $o ).

tff(pred_def_92,type,
    v217: state_type > $o ).

tff(pred_def_93,type,
    v225: state_type > $o ).

tff(pred_def_94,type,
    v216: state_type > $o ).

tff(pred_def_95,type,
    v214: state_type > $o ).

tff(pred_def_96,type,
    v229: ( state_type * $int ) > $o ).

tff(pred_def_97,type,
    v228: state_type > $o ).

tff(pred_def_98,type,
    v227: state_type > $o ).

tff(pred_def_99,type,
    v226: state_type > $o ).

tff(pred_def_100,type,
    v211: state_type > $o ).

tff(pred_def_101,type,
    v213: state_type > $o ).

tff(pred_def_102,type,
    v205: state_type > $o ).

tff(pred_def_103,type,
    v233: ( state_type * $int ) > $o ).

tff(pred_def_104,type,
    b0000000000000000000000000000000000000000000000000000000000000000000000: $int > $o ).

tff(pred_def_105,type,
    v230: ( state_type * $int ) > $o ).

tff(pred_def_106,type,
    v232: ( state_type * $int ) > $o ).

tff(pred_def_107,type,
    v204: ( state_type * $int ) > $o ).

tff(pred_def_108,type,
    v239: state_type > $o ).

tff(pred_def_109,type,
    v241: ( state_type * $int ) > $o ).

tff(pred_def_110,type,
    v242: ( state_type * $int ) > $o ).

tff(pred_def_111,type,
    v237: ( state_type * $int ) > $o ).

tff(pred_def_112,type,
    v246: state_type > $o ).

tff(pred_def_113,type,
    v248: ( state_type * $int ) > $o ).

tff(pred_def_114,type,
    v249: ( state_type * $int ) > $o ).

tff(pred_def_115,type,
    v244: ( state_type * $int ) > $o ).

tff(pred_def_116,type,
    v255: state_type > $o ).

tff(pred_def_117,type,
    v253: state_type > $o ).

tff(pred_def_118,type,
    v266: ( state_type * $int ) > $o ).

tff(pred_def_119,type,
    v265: state_type > $o ).

tff(pred_def_120,type,
    v268: ( state_type * $int ) > $o ).

tff(pred_def_121,type,
    v267: state_type > $o ).

tff(pred_def_122,type,
    v264: state_type > $o ).

tff(pred_def_123,type,
    v270: ( state_type * $int ) > $o ).

tff(pred_def_124,type,
    v269: state_type > $o ).

tff(pred_def_125,type,
    v263: state_type > $o ).

tff(pred_def_126,type,
    v271: state_type > $o ).

tff(pred_def_127,type,
    v262: state_type > $o ).

tff(pred_def_128,type,
    v261: state_type > $o ).

tff(pred_def_129,type,
    v275: ( state_type * $int ) > $o ).

tff(pred_def_130,type,
    v274: state_type > $o ).

tff(pred_def_131,type,
    v273: state_type > $o ).

tff(pred_def_132,type,
    v272: state_type > $o ).

tff(pred_def_133,type,
    v258: state_type > $o ).

tff(pred_def_134,type,
    v260: state_type > $o ).

tff(pred_def_135,type,
    v252: state_type > $o ).

tff(pred_def_136,type,
    v279: ( state_type * $int ) > $o ).

tff(pred_def_137,type,
    v276: ( state_type * $int ) > $o ).

tff(pred_def_138,type,
    v278: ( state_type * $int ) > $o ).

tff(pred_def_139,type,
    v251: ( state_type * $int ) > $o ).

tff(pred_def_140,type,
    v92: ( state_type * $int ) > $o ).

tff(pred_def_141,type,
    v90: ( state_type * $int ) > $o ).

tff(pred_def_142,type,
    v88: ( state_type * $int ) > $o ).

tff(pred_def_143,type,
    v86: state_type > $o ).

tff(pred_def_144,type,
    v84: state_type > $o ).

tff(pred_def_145,type,
    v82: state_type > $o ).

tff(pred_def_146,type,
    v284: state_type > $o ).

tff(pred_def_147,type,
    v286: state_type > $o ).

tff(pred_def_148,type,
    v62: ( state_type * $int ) > $o ).

tff(pred_def_149,type,
    b000: $int > $o ).

tff(pred_def_150,type,
    v290: state_type > $o ).

tff(pred_def_151,type,
    v289: state_type > $o ).

tff(pred_def_152,type,
    v292: state_type > $o ).

tff(pred_def_153,type,
    v293: state_type > $o ).

tff(pred_def_154,type,
    v291: state_type > $o ).

tff(pred_def_155,type,
    v288: state_type > $o ).

tff(pred_def_156,type,
    v67: ( state_type * $int ) > $o ).

tff(pred_def_157,type,
    v295: state_type > $o ).

tff(pred_def_158,type,
    v302: state_type > $o ).

tff(pred_def_159,type,
    v300: state_type > $o ).

tff(pred_def_160,type,
    v299: state_type > $o ).

tff(pred_def_161,type,
    v298: state_type > $o ).

tff(pred_def_162,type,
    v309: state_type > $o ).

tff(pred_def_163,type,
    v306: ( state_type * $int ) > $o ).

tff(pred_def_164,type,
    v308: ( state_type * $int ) > $o ).

tff(pred_def_165,type,
    v297: ( state_type * $int ) > $o ).

tff(pred_def_166,type,
    v69: state_type > $o ).

tff(pred_def_167,type,
    v315: state_type > $o ).

tff(pred_def_168,type,
    v317: state_type > $o ).

tff(pred_def_169,type,
    v314: state_type > $o ).

tff(pred_def_170,type,
    v319: state_type > $o ).

tff(pred_def_171,type,
    v320: state_type > $o ).

tff(pred_def_172,type,
    v318: state_type > $o ).

tff(pred_def_173,type,
    v313: state_type > $o ).

tff(pred_def_174,type,
    v326: state_type > $o ).

tff(pred_def_175,type,
    v324: state_type > $o ).

tff(pred_def_176,type,
    v323: state_type > $o ).

tff(pred_def_177,type,
    v322: ( state_type * $int ) > $o ).

tff(pred_def_178,type,
    v333: state_type > $o ).

tff(pred_def_179,type,
    v332: state_type > $o ).

tff(pred_def_180,type,
    v335: state_type > $o ).

tff(pred_def_181,type,
    v331: state_type > $o ).

tff(pred_def_182,type,
    v336: state_type > $o ).

tff(pred_def_183,type,
    v330: state_type > $o ).

tff(pred_def_184,type,
    v342: state_type > $o ).

tff(pred_def_185,type,
    v340: state_type > $o ).

tff(pred_def_186,type,
    v339: state_type > $o ).

tff(pred_def_187,type,
    v345: state_type > $o ).

tff(pred_def_188,type,
    v347: state_type > $o ).

tff(pred_def_189,type,
    v80: state_type > $o ).

tff(pred_def_190,type,
    v78: state_type > $o ).

tff(pred_def_191,type,
    v76: state_type > $o ).

tff(pred_def_192,type,
    v353: state_type > $o ).

tff(pred_def_193,type,
    v352: state_type > $o ).

tff(pred_def_194,type,
    v351: state_type > $o ).

tff(pred_def_195,type,
    v354: state_type > $o ).

tff(pred_def_196,type,
    v73: state_type > $o ).

tff(pred_def_197,type,
    v71: state_type > $o ).

tff(pred_def_198,type,
    v360: state_type > $o ).

tff(pred_def_199,type,
    v358: state_type > $o ).

tff(pred_def_200,type,
    v357: state_type > $o ).

tff(pred_def_201,type,
    v362: state_type > $o ).

tff(pred_def_202,type,
    v361: state_type > $o ).

tff(pred_def_203,type,
    v356: state_type > $o ).

tff(pred_def_204,type,
    v368: state_type > $o ).

tff(pred_def_205,type,
    v366: state_type > $o ).

tff(pred_def_206,type,
    v365: state_type > $o ).

tff(pred_def_207,type,
    v364: ( state_type * $int ) > $o ).

tff(pred_def_208,type,
    v372: state_type > $o ).

tff(pred_def_209,type,
    v60: state_type > $o ).

tff(pred_def_210,type,
    v58: state_type > $o ).

tff(pred_def_211,type,
    v56: state_type > $o ).

tff(pred_def_212,type,
    v378: state_type > $o ).

tff(pred_def_213,type,
    v377: state_type > $o ).

tff(pred_def_214,type,
    v376: state_type > $o ).

tff(pred_def_215,type,
    v374: state_type > $o ).

tff(pred_def_216,type,
    v380: state_type > $o ).

tff(pred_def_217,type,
    v45: state_type > $o ).

tff(pred_def_218,type,
    bx0000000: $int > $o ).

tff(pred_def_219,type,
    v382: ( state_type * $int ) > $o ).

tff(pred_def_220,type,
    v388: ( state_type * $int ) > $o ).

tff(pred_def_221,type,
    v387: ( state_type * $int ) > $o ).

tff(pred_def_222,type,
    v393: state_type > $o ).

tff(pred_def_223,type,
    v396: ( state_type * $int ) > $o ).

tff(pred_def_224,type,
    v395: state_type > $o ).

tff(pred_def_225,type,
    v398: ( state_type * $int ) > $o ).

tff(pred_def_226,type,
    v397: state_type > $o ).

tff(pred_def_227,type,
    v399: ( state_type * $int ) > $o ).

tff(pred_def_228,type,
    v402: ( state_type * $int ) > $o ).

tff(pred_def_229,type,
    v401: state_type > $o ).

tff(pred_def_230,type,
    v403: ( state_type * $int ) > $o ).

tff(pred_def_231,type,
    v405: ( state_type * $int ) > $o ).

tff(pred_def_232,type,
    v404: state_type > $o ).

tff(pred_def_233,type,
    v394: ( state_type * $int ) > $o ).

tff(pred_def_234,type,
    b00000000: $int > $o ).

tff(pred_def_235,type,
    v392: ( state_type * $int ) > $o ).

tff(pred_def_236,type,
    v385: ( state_type * $int ) > $o ).

tff(pred_def_237,type,
    v411: state_type > $o ).

tff(pred_def_238,type,
    v409: state_type > $o ).

tff(pred_def_239,type,
    v408: state_type > $o ).

tff(pred_def_240,type,
    v414: ( state_type * $int ) > $o ).

tff(pred_def_241,type,
    v416: ( state_type * $int ) > $o ).

tff(pred_def_242,type,
    v407: ( state_type * $int ) > $o ).

tff(pred_def_243,type,
    v424: state_type > $o ).

tff(pred_def_244,type,
    v422: state_type > $o ).

tff(pred_def_245,type,
    v421: state_type > $o ).

tff(pred_def_246,type,
    v420: ( state_type * $int ) > $o ).

tff(pred_def_247,type,
    v432: state_type > $o ).

tff(pred_def_248,type,
    v430: state_type > $o ).

tff(pred_def_249,type,
    v429: state_type > $o ).

tff(pred_def_250,type,
    v428: ( state_type * $int ) > $o ).

tff(pred_def_251,type,
    v439: state_type > $o ).

tff(pred_def_252,type,
    v438: state_type > $o ).

tff(pred_def_253,type,
    v449: state_type > $o ).

tff(pred_def_254,type,
    v450: state_type > $o ).

tff(pred_def_255,type,
    v448: state_type > $o ).

tff(pred_def_256,type,
    v451: state_type > $o ).

tff(pred_def_257,type,
    v447: state_type > $o ).

tff(pred_def_258,type,
    v446: state_type > $o ).

tff(pred_def_259,type,
    v452: state_type > $o ).

tff(pred_def_260,type,
    v443: state_type > $o ).

tff(pred_def_261,type,
    v445: state_type > $o ).

tff(pred_def_262,type,
    v437: state_type > $o ).

tff(pred_def_263,type,
    v456: state_type > $o ).

tff(pred_def_264,type,
    v453: state_type > $o ).

tff(pred_def_265,type,
    v455: state_type > $o ).

tff(pred_def_266,type,
    v32: state_type > $o ).

tff(pred_def_267,type,
    v464: state_type > $o ).

tff(pred_def_268,type,
    v466: ( state_type * $int ) > $o ).

tff(pred_def_269,type,
    v467: ( state_type * $int ) > $o ).

tff(pred_def_270,type,
    v462: ( state_type * $int ) > $o ).

tff(pred_def_271,type,
    v471: state_type > $o ).

tff(pred_def_272,type,
    v473: ( state_type * $int ) > $o ).

tff(pred_def_273,type,
    v474: ( state_type * $int ) > $o ).

tff(pred_def_274,type,
    v469: ( state_type * $int ) > $o ).

tff(pred_def_275,type,
    v480: state_type > $o ).

tff(pred_def_276,type,
    v478: state_type > $o ).

tff(pred_def_277,type,
    v491: ( state_type * $int ) > $o ).

tff(pred_def_278,type,
    v490: state_type > $o ).

tff(pred_def_279,type,
    v493: ( state_type * $int ) > $o ).

tff(pred_def_280,type,
    v492: state_type > $o ).

tff(pred_def_281,type,
    v489: state_type > $o ).

tff(pred_def_282,type,
    v495: ( state_type * $int ) > $o ).

tff(pred_def_283,type,
    v494: state_type > $o ).

tff(pred_def_284,type,
    v488: state_type > $o ).

tff(pred_def_285,type,
    v496: state_type > $o ).

tff(pred_def_286,type,
    v487: state_type > $o ).

tff(pred_def_287,type,
    v486: state_type > $o ).

tff(pred_def_288,type,
    v500: ( state_type * $int ) > $o ).

tff(pred_def_289,type,
    v499: state_type > $o ).

tff(pred_def_290,type,
    v498: state_type > $o ).

tff(pred_def_291,type,
    v497: state_type > $o ).

tff(pred_def_292,type,
    v483: state_type > $o ).

tff(pred_def_293,type,
    v485: state_type > $o ).

tff(pred_def_294,type,
    v477: state_type > $o ).

tff(pred_def_295,type,
    v504: ( state_type * $int ) > $o ).

tff(pred_def_296,type,
    v501: ( state_type * $int ) > $o ).

tff(pred_def_297,type,
    v503: ( state_type * $int ) > $o ).

tff(pred_def_298,type,
    v476: ( state_type * $int ) > $o ).

tff(pred_def_299,type,
    v513: state_type > $o ).

tff(pred_def_300,type,
    v511: state_type > $o ).

tff(pred_def_301,type,
    v510: state_type > $o ).

tff(pred_def_302,type,
    v508: ( state_type * $int ) > $o ).

tff(pred_def_303,type,
    v521: state_type > $o ).

tff(pred_def_304,type,
    v519: state_type > $o ).

tff(pred_def_305,type,
    v518: state_type > $o ).

tff(pred_def_306,type,
    v516: ( state_type * $int ) > $o ).

tff(pred_def_307,type,
    v460: ( state_type * $int ) > $o ).

tff(pred_def_308,type,
    b0000000: $int > $o ).

tff(pred_def_309,type,
    v549: state_type > $o ).

tff(pred_def_310,type,
    b0100000: $int > $o ).

tff(pred_def_311,type,
    v550: state_type > $o ).

tff(pred_def_312,type,
    v548: state_type > $o ).

tff(pred_def_313,type,
    b0000010: $int > $o ).

tff(pred_def_314,type,
    v551: state_type > $o ).

tff(pred_def_315,type,
    v547: state_type > $o ).

tff(pred_def_316,type,
    b0000100: $int > $o ).

tff(pred_def_317,type,
    v552: state_type > $o ).

tff(pred_def_318,type,
    v546: state_type > $o ).

tff(pred_def_319,type,
    b0000101: $int > $o ).

tff(pred_def_320,type,
    v553: state_type > $o ).

tff(pred_def_321,type,
    v545: state_type > $o ).

tff(pred_def_322,type,
    b1000010: $int > $o ).

tff(pred_def_323,type,
    v554: state_type > $o ).

tff(pred_def_324,type,
    v544: state_type > $o ).

tff(pred_def_325,type,
    b1000000: $int > $o ).

tff(pred_def_326,type,
    v555: state_type > $o ).

tff(pred_def_327,type,
    v543: state_type > $o ).

tff(pred_def_328,type,
    b1100000: $int > $o ).

tff(pred_def_329,type,
    v556: state_type > $o ).

tff(pred_def_330,type,
    v542: state_type > $o ).

tff(pred_def_331,type,
    b1000100: $int > $o ).

tff(pred_def_332,type,
    v557: state_type > $o ).

tff(pred_def_333,type,
    v541: state_type > $o ).

tff(pred_def_334,type,
    b1000101: $int > $o ).

tff(pred_def_335,type,
    v558: state_type > $o ).

tff(pred_def_336,type,
    v539: state_type > $o ).

tff(pred_def_337,type,
    b1111010: $int > $o ).

tff(pred_def_338,type,
    v559: state_type > $o ).

tff(pred_def_339,type,
    b0001010: $int > $o ).

tff(pred_def_340,type,
    v563: state_type > $o ).

tff(pred_def_341,type,
    b0001011: $int > $o ).

tff(pred_def_342,type,
    v564: state_type > $o ).

tff(pred_def_343,type,
    v562: state_type > $o ).

tff(pred_def_344,type,
    b1001010: $int > $o ).

tff(pred_def_345,type,
    v565: state_type > $o ).

tff(pred_def_346,type,
    v560: state_type > $o ).

tff(pred_def_347,type,
    v538: ( state_type * $int ) > $o ).

tff(pred_def_348,type,
    v570: state_type > $o ).

tff(pred_def_349,type,
    v569: state_type > $o ).

tff(pred_def_350,type,
    v568: state_type > $o ).

tff(pred_def_351,type,
    v574: ( state_type * $int ) > $o ).

tff(pred_def_352,type,
    v15: state_type > $o ).

tff(pred_def_353,type,
    v573: state_type > $o ).

tff(pred_def_354,type,
    v576: ( state_type * $int ) > $o ).

tff(pred_def_355,type,
    v575: state_type > $o ).

tff(pred_def_356,type,
    v572: state_type > $o ).

tff(pred_def_357,type,
    v577: state_type > $o ).

tff(pred_def_358,type,
    v571: state_type > $o ).

tff(pred_def_359,type,
    v567: state_type > $o ).

tff(pred_def_360,type,
    v13: ( state_type * $int ) > $o ).

tff(pred_def_361,type,
    v584: state_type > $o ).

tff(pred_def_362,type,
    v582: state_type > $o ).

tff(pred_def_363,type,
    v581: state_type > $o ).

tff(pred_def_364,type,
    v580: state_type > $o ).

tff(pred_def_365,type,
    v591: state_type > $o ).

tff(pred_def_366,type,
    v588: ( state_type * $int ) > $o ).

tff(pred_def_367,type,
    v590: ( state_type * $int ) > $o ).

tff(pred_def_368,type,
    v579: ( state_type * $int ) > $o ).

tff(pred_def_369,type,
    v599: state_type > $o ).

tff(pred_def_370,type,
    v598: state_type > $o ).

tff(pred_def_371,type,
    v597: state_type > $o ).

tff(pred_def_372,type,
    v602: ( state_type * $int ) > $o ).

tff(pred_def_373,type,
    v601: state_type > $o ).

tff(pred_def_374,type,
    v600: state_type > $o ).

tff(pred_def_375,type,
    v596: state_type > $o ).

tff(pred_def_376,type,
    v604: state_type > $o ).

tff(pred_def_377,type,
    v603: state_type > $o ).

tff(pred_def_378,type,
    v595: state_type > $o ).

tff(pred_def_379,type,
    v610: state_type > $o ).

tff(pred_def_380,type,
    v608: state_type > $o ).

tff(pred_def_381,type,
    v607: state_type > $o ).

tff(pred_def_382,type,
    v606: ( state_type * $int ) > $o ).

tff(pred_def_383,type,
    v617: state_type > $o ).

tff(pred_def_384,type,
    v616: state_type > $o ).

tff(pred_def_385,type,
    v615: state_type > $o ).

tff(pred_def_386,type,
    v614: state_type > $o ).

tff(pred_def_387,type,
    v619: state_type > $o ).

tff(pred_def_388,type,
    v622: ( state_type * $int ) > $o ).

tff(pred_def_389,type,
    v621: state_type > $o ).

tff(pred_def_390,type,
    v620: state_type > $o ).

tff(pred_def_391,type,
    v623: state_type > $o ).

tff(pred_def_392,type,
    v618: state_type > $o ).

tff(pred_def_393,type,
    v26: state_type > $o ).

tff(pred_def_394,type,
    v627: ( state_type * $int ) > $o ).

tff(pred_def_395,type,
    v626: state_type > $o ).

tff(pred_def_396,type,
    b100: $int > $o ).

tff(pred_def_397,type,
    v17: ( state_type * $int ) > $o ).

tff(pred_def_398,type,
    v635: state_type > $o ).

tff(pred_def_399,type,
    v634: state_type > $o ).

tff(pred_def_400,type,
    v633: state_type > $o ).

tff(pred_def_401,type,
    v632: state_type > $o ).

tff(pred_def_402,type,
    v631: state_type > $o ).

tff(pred_def_403,type,
    v637: state_type > $o ).

tff(pred_def_404,type,
    v636: state_type > $o ).

tff(pred_def_405,type,
    v630: state_type > $o ).

tff(pred_def_406,type,
    v640: state_type > $o ).

tff(pred_def_407,type,
    v639: state_type > $o ).

tff(pred_def_408,type,
    v641: state_type > $o ).

tff(pred_def_409,type,
    v638: state_type > $o ).

tff(pred_def_410,type,
    v628: ( state_type * $int ) > $o ).

tff(pred_def_411,type,
    v643: ( state_type * $int ) > $o ).

tff(pred_def_412,type,
    v642: state_type > $o ).

tff(pred_def_413,type,
    v649: state_type > $o ).

tff(pred_def_414,type,
    v648: state_type > $o ).

tff(pred_def_415,type,
    v647: state_type > $o ).

tff(pred_def_416,type,
    v650: state_type > $o ).

tff(pred_def_417,type,
    v646: state_type > $o ).

tff(pred_def_418,type,
    v652: state_type > $o ).

tff(pred_def_419,type,
    v653: state_type > $o ).

tff(pred_def_420,type,
    v651: state_type > $o ).

tff(pred_def_421,type,
    v644: ( state_type * $int ) > $o ).

tff(pred_def_422,type,
    v656: ( state_type * $int ) > $o ).

tff(pred_def_423,type,
    v655: state_type > $o ).

tff(pred_def_424,type,
    v658: ( state_type * $int ) > $o ).

tff(pred_def_425,type,
    v657: state_type > $o ).

tff(pred_def_426,type,
    v654: state_type > $o ).

tff(pred_def_427,type,
    v20: ( state_type * $int ) > $o ).

tff(pred_def_428,type,
    v663: state_type > $o ).

tff(pred_def_429,type,
    v662: state_type > $o ).

tff(pred_def_430,type,
    v661: state_type > $o ).

tff(pred_def_431,type,
    v670: state_type > $o ).

tff(pred_def_432,type,
    v667: ( state_type * $int ) > $o ).

tff(pred_def_433,type,
    v669: ( state_type * $int ) > $o ).

tff(pred_def_434,type,
    v675: state_type > $o ).

tff(pred_def_435,type,
    v685: state_type > $o ).

tff(pred_def_436,type,
    v684: state_type > $o ).

tff(pred_def_437,type,
    v683: state_type > $o ).

tff(pred_def_438,type,
    v687: state_type > $o ).

tff(pred_def_439,type,
    v686: state_type > $o ).

tff(pred_def_440,type,
    v682: state_type > $o ).

tff(pred_def_441,type,
    v681: state_type > $o ).

tff(pred_def_442,type,
    v688: state_type > $o ).

tff(pred_def_443,type,
    v680: state_type > $o ).

tff(pred_def_444,type,
    v679: state_type > $o ).

tff(pred_def_445,type,
    v689: state_type > $o ).

tff(pred_def_446,type,
    v678: state_type > $o ).

tff(pred_def_447,type,
    v691: state_type > $o ).

tff(pred_def_448,type,
    v690: state_type > $o ).

tff(pred_def_449,type,
    v677: state_type > $o ).

tff(pred_def_450,type,
    v697: state_type > $o ).

tff(pred_def_451,type,
    v695: state_type > $o ).

tff(pred_def_452,type,
    v694: state_type > $o ).

tff(pred_def_453,type,
    v700: state_type > $o ).

tff(pred_def_454,type,
    v702: state_type > $o ).

tff(pred_def_455,type,
    v709: state_type > $o ).

tff(pred_def_456,type,
    v708: state_type > $o ).

tff(pred_def_457,type,
    v711: state_type > $o ).

tff(pred_def_458,type,
    v710: state_type > $o ).

tff(pred_def_459,type,
    v707: state_type > $o ).

tff(pred_def_460,type,
    v713: state_type > $o ).

tff(pred_def_461,type,
    v712: state_type > $o ).

tff(pred_def_462,type,
    v4: state_type > $o ).

tff(pred_def_463,type,
    reachableState: state_type > $o ).

tff(pathAxiom_19,axiom,
    nextState(constB19,constB20) ).

tff(pathAxiom_18,axiom,
    nextState(constB18,constB19) ).

tff(pathAxiom_17,axiom,
    nextState(constB17,constB18) ).

tff(pathAxiom_16,axiom,
    nextState(constB16,constB17) ).

tff(pathAxiom_15,axiom,
    nextState(constB15,constB16) ).

tff(pathAxiom_14,axiom,
    nextState(constB14,constB15) ).

tff(pathAxiom_13,axiom,
    nextState(constB13,constB14) ).

tff(pathAxiom_12,axiom,
    nextState(constB12,constB13) ).

tff(pathAxiom_11,axiom,
    nextState(constB11,constB12) ).

tff(pathAxiom_10,axiom,
    nextState(constB10,constB11) ).

tff(pathAxiom_9,axiom,
    nextState(constB9,constB10) ).

tff(pathAxiom_8,axiom,
    nextState(constB8,constB9) ).

tff(pathAxiom_7,axiom,
    nextState(constB7,constB8) ).

tff(pathAxiom_6,axiom,
    nextState(constB6,constB7) ).

tff(pathAxiom_5,axiom,
    nextState(constB5,constB6) ).

tff(pathAxiom_4,axiom,
    nextState(constB4,constB5) ).

tff(pathAxiom_3,axiom,
    nextState(constB3,constB4) ).

tff(pathAxiom_2,axiom,
    nextState(constB2,constB3) ).

tff(pathAxiom_1,axiom,
    nextState(constB1,constB2) ).

tff(pathAxiom,axiom,
    nextState(constB0,constB1) ).

tff(reachableStateAxiom_22,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( reachableState(VarCurr)
        & reachableState(VarNext) ) ) ).

tff(reachableStateAxiom_21,axiom,
    ! [VarState: state_type] :
      ( reachableState(VarState)
     => ( ( constB0 = VarState )
        | ( constB1 = VarState )
        | ( constB2 = VarState )
        | ( constB3 = VarState )
        | ( constB4 = VarState )
        | ( constB5 = VarState )
        | ( constB6 = VarState )
        | ( constB7 = VarState )
        | ( constB8 = VarState )
        | ( constB9 = VarState )
        | ( constB10 = VarState )
        | ( constB11 = VarState )
        | ( constB12 = VarState )
        | ( constB13 = VarState )
        | ( constB14 = VarState )
        | ( constB15 = VarState )
        | ( constB16 = VarState )
        | ( constB17 = VarState )
        | ( constB18 = VarState )
        | ( constB19 = VarState )
        | ( constB20 = VarState ) ) ) ).

tff(reachableStateAxiom_20,axiom,
    reachableState(constB20) ).

tff(reachableStateAxiom_19,axiom,
    reachableState(constB19) ).

tff(reachableStateAxiom_18,axiom,
    reachableState(constB18) ).

tff(reachableStateAxiom_17,axiom,
    reachableState(constB17) ).

tff(reachableStateAxiom_16,axiom,
    reachableState(constB16) ).

tff(reachableStateAxiom_15,axiom,
    reachableState(constB15) ).

tff(reachableStateAxiom_14,axiom,
    reachableState(constB14) ).

tff(reachableStateAxiom_13,axiom,
    reachableState(constB13) ).

tff(reachableStateAxiom_12,axiom,
    reachableState(constB12) ).

tff(reachableStateAxiom_11,axiom,
    reachableState(constB11) ).

tff(reachableStateAxiom_10,axiom,
    reachableState(constB10) ).

tff(reachableStateAxiom_9,axiom,
    reachableState(constB9) ).

tff(reachableStateAxiom_8,axiom,
    reachableState(constB8) ).

tff(reachableStateAxiom_7,axiom,
    reachableState(constB7) ).

tff(reachableStateAxiom_6,axiom,
    reachableState(constB6) ).

tff(reachableStateAxiom_5,axiom,
    reachableState(constB5) ).

tff(reachableStateAxiom_4,axiom,
    reachableState(constB4) ).

tff(reachableStateAxiom_3,axiom,
    reachableState(constB3) ).

tff(reachableStateAxiom_2,axiom,
    reachableState(constB2) ).

tff(reachableStateAxiom_1,axiom,
    reachableState(constB1) ).

tff(reachableStateAxiom,axiom,
    reachableState(constB0) ).

tff(clock_toggling,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v1(VarCurr)
      <=> ~ v1(VarNext) ) ) ).

tff(clock_pattern,axiom,
    ~ v1(constB0) ).

tff(addAssertion,conjecture,
    ! [VarCurr: state_type] :
      ( reachableState(VarCurr)
     => v4(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_142,axiom,
    ! [VarCurr: state_type] :
      ( v4(VarCurr)
    <=> ( v707(VarCurr)
        & v712(VarCurr) ) ) ).

tff(writeUnaryOperator_53,axiom,
    ! [VarCurr: state_type] :
      ( ~ v712(VarCurr)
    <=> v713(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_141,axiom,
    ! [VarCurr: state_type] :
      ( v713(VarCurr)
    <=> ( v577(VarCurr)
        & v604(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_140,axiom,
    ! [VarCurr: state_type] :
      ( v707(VarCurr)
    <=> ( v708(VarCurr)
        & v710(VarCurr) ) ) ).

tff(writeUnaryOperator_52,axiom,
    ! [VarCurr: state_type] :
      ( ~ v710(VarCurr)
    <=> v711(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_139,axiom,
    ! [VarCurr: state_type] :
      ( v711(VarCurr)
    <=> ( v54(VarCurr)
        & v604(VarCurr) ) ) ).

tff(writeUnaryOperator_51,axiom,
    ! [VarCurr: state_type] :
      ( ~ v708(VarCurr)
    <=> v709(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_138,axiom,
    ! [VarCurr: state_type] :
      ( v709(VarCurr)
    <=> ( v54(VarCurr)
        & v577(VarCurr) ) ) ).

tff(addCaseBooleanConditionEqualRanges1_10,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v694(VarNext)
       => ( v7(VarNext,0)
        <=> v7(VarCurr,0) ) ) ) ).

tff(addCaseBooleanConditionEqualRanges0_20,axiom,
    ! [VarNext: state_type] :
      ( v694(VarNext)
     => ( v7(VarNext,0)
      <=> v702(VarNext) ) ) ).

tff(addAssignment_181,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v702(VarNext)
      <=> v700(VarCurr) ) ) ).

tff(aaddConditionBooleanCondEqualRangesElseBranch_24,axiom,
    ! [VarCurr: state_type] :
      ( ~ v591(VarCurr)
     => ( v700(VarCurr)
      <=> v13(VarCurr,0) ) ) ).

tff(addConditionBooleanCondEqualRangesThenBranch_26,axiom,
    ! [VarCurr: state_type] :
      ( v591(VarCurr)
     => ( v700(VarCurr)
      <=> $true ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_137,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v694(VarNext)
      <=> v695(VarNext) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_136,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v695(VarNext)
      <=> ( v697(VarNext)
          & v112(VarNext) ) ) ) ).

tff(writeUnaryOperator_50,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v697(VarNext)
      <=> v584(VarNext) ) ) ).

tff(aaddConditionBooleanCondEqualRangesElseBranch_23,axiom,
    ! [VarCurr: state_type] :
      ( ~ v677(VarCurr)
     => ( v13(VarCurr,0)
      <=> $false ) ) ).

tff(addConditionBooleanCondEqualRangesThenBranch_25,axiom,
    ! [VarCurr: state_type] :
      ( v677(VarCurr)
     => ( v13(VarCurr,0)
      <=> $true ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_135,axiom,
    ! [VarCurr: state_type] :
      ( v677(VarCurr)
    <=> ( v678(VarCurr)
        | v690(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_134,axiom,
    ! [VarCurr: state_type] :
      ( v690(VarCurr)
    <=> ( v691(VarCurr)
        & v604(VarCurr) ) ) ).

tff(writeUnaryOperator_49,axiom,
    ! [VarCurr: state_type] :
      ( ~ v691(VarCurr)
    <=> v15(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_133,axiom,
    ! [VarCurr: state_type] :
      ( v678(VarCurr)
    <=> ( v679(VarCurr)
        | v689(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_132,axiom,
    ! [VarCurr: state_type] :
      ( v689(VarCurr)
    <=> ( v621(VarCurr)
        & v577(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_131,axiom,
    ! [VarCurr: state_type] :
      ( v679(VarCurr)
    <=> ( v680(VarCurr)
        & v54(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_130,axiom,
    ! [VarCurr: state_type] :
      ( v680(VarCurr)
    <=> ( v681(VarCurr)
        | v688(VarCurr) ) ) ).

tff(writeUnaryOperator_48,axiom,
    ! [VarCurr: state_type] :
      ( ~ v688(VarCurr)
    <=> v53(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_129,axiom,
    ! [VarCurr: state_type] :
      ( v681(VarCurr)
    <=> ( v682(VarCurr)
        & v53(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_128,axiom,
    ! [VarCurr: state_type] :
      ( v682(VarCurr)
    <=> ( v683(VarCurr)
        | v686(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_127,axiom,
    ! [VarCurr: state_type] :
      ( v686(VarCurr)
    <=> ( v687(VarCurr)
        & v353(VarCurr) ) ) ).

tff(writeUnaryOperator_47,axiom,
    ! [VarCurr: state_type] :
      ( ~ v687(VarCurr)
    <=> v76(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_126,axiom,
    ! [VarCurr: state_type] :
      ( v683(VarCurr)
    <=> ( v684(VarCurr)
        | v378(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_125,axiom,
    ! [VarCurr: state_type] :
      ( v684(VarCurr)
    <=> ( v685(VarCurr)
        & v52(VarCurr) ) ) ).

tff(writeUnaryOperator_46,axiom,
    ! [VarCurr: state_type] :
      ( ~ v685(VarCurr)
    <=> v15(VarCurr) ) ).

tff(writeUnaryOperator_45,axiom,
    ! [VarCurr: state_type] :
      ( ~ v15(VarCurr)
    <=> v675(VarCurr) ) ).

tff(writeBinaryOperatorShiftedRanges_7,axiom,
    ! [VarCurr: state_type] :
      ( v675(VarCurr)
    <=> ( v653(VarCurr)
        | v17(VarCurr,2) ) ) ).

tff(addCaseBooleanConditionEqualRanges1_9,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v661(VarNext)
       => ! [B: $int] :
            ( ( $less(B,3)
              & ~ $less(B,0) )
           => ( v17(VarNext,B)
            <=> v17(VarCurr,B) ) ) ) ) ).

tff(addCaseBooleanConditionEqualRanges0_19,axiom,
    ! [VarNext: state_type] :
      ( v661(VarNext)
     => ! [B: $int] :
          ( ( $less(B,3)
            & ~ $less(B,0) )
         => ( v17(VarNext,B)
          <=> v669(VarNext,B) ) ) ) ).

tff(addAssignment_180,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ! [B: $int] :
          ( ( $less(B,3)
            & ~ $less(B,0) )
         => ( v669(VarNext,B)
          <=> v667(VarCurr,B) ) ) ) ).

tff(aaddConditionBooleanCondEqualRangesElseBranch_22,axiom,
    ! [VarCurr: state_type] :
      ( ~ v670(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,3)
            & ~ $less(B,0) )
         => ( v667(VarCurr,B)
          <=> v20(VarCurr,B) ) ) ) ).

tff(addConditionBooleanCondEqualRangesThenBranch_24,axiom,
    ! [VarCurr: state_type] :
      ( v670(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,3)
            & ~ $less(B,0) )
         => ( v667(VarCurr,B)
          <=> b100(B) ) ) ) ).

tff(writeUnaryOperator_44,axiom,
    ! [VarCurr: state_type] :
      ( ~ v670(VarCurr)
    <=> v9(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_124,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v661(VarNext)
      <=> v662(VarNext) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_123,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v662(VarNext)
      <=> ( v663(VarNext)
          & v112(VarNext) ) ) ) ).

tff(writeUnaryOperator_43,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v663(VarNext)
      <=> v584(VarNext) ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges2_8,axiom,
    ! [VarCurr: state_type] :
      ( ( ~ v626(VarCurr)
        & ~ v642(VarCurr) )
     => ! [B: $int] :
          ( ( $less(B,3)
            & ~ $less(B,0) )
         => ( v20(VarCurr,B)
          <=> v17(VarCurr,B) ) ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges1_11,axiom,
    ! [VarCurr: state_type] :
      ( v642(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,3)
            & ~ $less(B,0) )
         => ( v20(VarCurr,B)
          <=> v644(VarCurr,B) ) ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges0_8,axiom,
    ! [VarCurr: state_type] :
      ( v626(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,3)
            & ~ $less(B,0) )
         => ( v20(VarCurr,B)
          <=> v628(VarCurr,B) ) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_122,axiom,
    ! [VarCurr: state_type] :
      ( v654(VarCurr)
    <=> ( v655(VarCurr)
        | v657(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_54,axiom,
    ! [VarCurr: state_type] :
      ( v657(VarCurr)
    <=> ( ( v658(VarCurr,1)
        <=> $true )
        & ( v658(VarCurr,0)
        <=> $true ) ) ) ).

tff(addAssignment_179,axiom,
    ! [VarCurr: state_type] :
      ( v658(VarCurr,0)
    <=> v26(VarCurr) ) ).

tff(addAssignment_178,axiom,
    ! [VarCurr: state_type] :
      ( v658(VarCurr,1)
    <=> v22(VarCurr) ) ).

tff(addBitVectorEqualityBitBlasted_53,axiom,
    ! [VarCurr: state_type] :
      ( v655(VarCurr)
    <=> ( ( v656(VarCurr,1)
        <=> $false )
        & ( v656(VarCurr,0)
        <=> $false ) ) ) ).

tff(addAssignment_177,axiom,
    ! [VarCurr: state_type] :
      ( v656(VarCurr,0)
    <=> v26(VarCurr) ) ).

tff(addAssignment_176,axiom,
    ! [VarCurr: state_type] :
      ( v656(VarCurr,1)
    <=> v22(VarCurr) ) ).

tff(addAssignment_175,axiom,
    ! [VarCurr: state_type] :
      ( v644(VarCurr,0)
    <=> v640(VarCurr) ) ).

tff(addAssignment_174,axiom,
    ! [VarCurr: state_type] :
      ( v644(VarCurr,1)
    <=> v651(VarCurr) ) ).

tff(addAssignment_173,axiom,
    ! [VarCurr: state_type] :
      ( v644(VarCurr,2)
    <=> v646(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_121,axiom,
    ! [VarCurr: state_type] :
      ( v651(VarCurr)
    <=> ( v652(VarCurr)
        & v653(VarCurr) ) ) ).

tff(writeBinaryOperatorShiftedRanges_6,axiom,
    ! [VarCurr: state_type] :
      ( v653(VarCurr)
    <=> ( v17(VarCurr,0)
        | v17(VarCurr,1) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_120,axiom,
    ! [VarCurr: state_type] :
      ( v652(VarCurr)
    <=> ( v640(VarCurr)
        | v635(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_119,axiom,
    ! [VarCurr: state_type] :
      ( v646(VarCurr)
    <=> ( v647(VarCurr)
        & v650(VarCurr) ) ) ).

tff(writeBinaryOperatorShiftedRanges_5,axiom,
    ! [VarCurr: state_type] :
      ( v650(VarCurr)
    <=> ( v17(VarCurr,2)
        | v649(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_118,axiom,
    ! [VarCurr: state_type] :
      ( v647(VarCurr)
    <=> ( v637(VarCurr)
        | v648(VarCurr) ) ) ).

tff(writeUnaryOperator_42,axiom,
    ! [VarCurr: state_type] :
      ( ~ v648(VarCurr)
    <=> v649(VarCurr) ) ).

tff(writeBinaryOperatorShiftedRanges_4,axiom,
    ! [VarCurr: state_type] :
      ( v649(VarCurr)
    <=> ( v17(VarCurr,0)
        & v17(VarCurr,1) ) ) ).

tff(addBitVectorEqualityBitBlasted_52,axiom,
    ! [VarCurr: state_type] :
      ( v642(VarCurr)
    <=> ( ( v643(VarCurr,1)
        <=> $true )
        & ( v643(VarCurr,0)
        <=> $false ) ) ) ).

tff(addAssignment_172,axiom,
    ! [VarCurr: state_type] :
      ( v643(VarCurr,0)
    <=> v26(VarCurr) ) ).

tff(addAssignment_171,axiom,
    ! [VarCurr: state_type] :
      ( v643(VarCurr,1)
    <=> v22(VarCurr) ) ).

tff(addAssignment_170,axiom,
    ! [VarCurr: state_type] :
      ( v628(VarCurr,0)
    <=> v640(VarCurr) ) ).

tff(addAssignment_169,axiom,
    ! [VarCurr: state_type] :
      ( v628(VarCurr,1)
    <=> v638(VarCurr) ) ).

tff(addAssignment_168,axiom,
    ! [VarCurr: state_type] :
      ( v628(VarCurr,2)
    <=> v630(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_117,axiom,
    ! [VarCurr: state_type] :
      ( v638(VarCurr)
    <=> ( v639(VarCurr)
        & v641(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_116,axiom,
    ! [VarCurr: state_type] :
      ( v641(VarCurr)
    <=> ( v17(VarCurr,0)
        | v635(VarCurr) ) ) ).

tff(writeBinaryOperatorShiftedRanges_3,axiom,
    ! [VarCurr: state_type] :
      ( v639(VarCurr)
    <=> ( v640(VarCurr)
        | v17(VarCurr,1) ) ) ).

tff(writeUnaryOperator_41,axiom,
    ! [VarCurr: state_type] :
      ( ~ v640(VarCurr)
    <=> v17(VarCurr,0) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_115,axiom,
    ! [VarCurr: state_type] :
      ( v630(VarCurr)
    <=> ( v631(VarCurr)
        & v636(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_114,axiom,
    ! [VarCurr: state_type] :
      ( v636(VarCurr)
    <=> ( v633(VarCurr)
        | v637(VarCurr) ) ) ).

tff(writeUnaryOperator_40,axiom,
    ! [VarCurr: state_type] :
      ( ~ v637(VarCurr)
    <=> v17(VarCurr,2) ) ).

tff(writeBinaryOperatorShiftedRanges_2,axiom,
    ! [VarCurr: state_type] :
      ( v631(VarCurr)
    <=> ( v632(VarCurr)
        | v17(VarCurr,2) ) ) ).

tff(writeUnaryOperator_39,axiom,
    ! [VarCurr: state_type] :
      ( ~ v632(VarCurr)
    <=> v633(VarCurr) ) ).

tff(writeBinaryOperatorShiftedRanges_1,axiom,
    ! [VarCurr: state_type] :
      ( v633(VarCurr)
    <=> ( v17(VarCurr,1)
        | v634(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_113,axiom,
    ! [VarCurr: state_type] :
      ( v634(VarCurr)
    <=> ( v17(VarCurr,0)
        & v635(VarCurr) ) ) ).

tff(writeUnaryOperator_38,axiom,
    ! [VarCurr: state_type] :
      ( ~ v635(VarCurr)
    <=> v17(VarCurr,1) ) ).

tff(addAssignmentInitValue_84,axiom,
    v17(constB0,2) ).

tff(addAssignmentInitValue_83,axiom,
    ~ v17(constB0,1) ).

tff(addAssignmentInitValue_82,axiom,
    ~ v17(constB0,0) ).

tff(bitBlastConstant_271,axiom,
    b100(2) ).

tff(bitBlastConstant_270,axiom,
    ~ b100(1) ).

tff(bitBlastConstant_269,axiom,
    ~ b100(0) ).

tff(addBitVectorEqualityBitBlasted_51,axiom,
    ! [VarCurr: state_type] :
      ( v626(VarCurr)
    <=> ( ( v627(VarCurr,1)
        <=> $false )
        & ( v627(VarCurr,0)
        <=> $true ) ) ) ).

tff(addAssignment_167,axiom,
    ! [VarCurr: state_type] :
      ( v627(VarCurr,0)
    <=> v26(VarCurr) ) ).

tff(addAssignment_166,axiom,
    ! [VarCurr: state_type] :
      ( v627(VarCurr,1)
    <=> v22(VarCurr) ) ).

tff(aaddConditionBooleanCondEqualRangesElseBranch_21,axiom,
    ! [VarCurr: state_type] :
      ( ~ v614(VarCurr)
     => ( v26(VarCurr)
      <=> $false ) ) ).

tff(addConditionBooleanCondEqualRangesThenBranch_23,axiom,
    ! [VarCurr: state_type] :
      ( v614(VarCurr)
     => ( v26(VarCurr)
      <=> v618(VarCurr) ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges2_7,axiom,
    ! [VarCurr: state_type] :
      ( ( ~ v616(VarCurr)
        & ~ v577(VarCurr) )
     => ( v618(VarCurr)
      <=> v623(VarCurr) ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges1_10,axiom,
    ! [VarCurr: state_type] :
      ( v577(VarCurr)
     => ( v618(VarCurr)
      <=> v620(VarCurr) ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges0_7,axiom,
    ! [VarCurr: state_type] :
      ( v616(VarCurr)
     => ( v618(VarCurr)
      <=> v619(VarCurr) ) ) ).

tff(aaddConditionBooleanCondEqualRangesElseBranch_20,axiom,
    ! [VarCurr: state_type] :
      ( ~ v15(VarCurr)
     => ( v623(VarCurr)
      <=> $true ) ) ).

tff(addConditionBooleanCondEqualRangesThenBranch_22,axiom,
    ! [VarCurr: state_type] :
      ( v15(VarCurr)
     => ( v623(VarCurr)
      <=> $false ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges2_6,axiom,
    ! [VarCurr: state_type] :
      ( ( ~ v572(VarCurr)
        & ~ v621(VarCurr) )
     => ( v620(VarCurr)
      <=> $false ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges1_9,axiom,
    ! [VarCurr: state_type] :
      ( v621(VarCurr)
     => ( v620(VarCurr)
      <=> $true ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges0_6,axiom,
    ! [VarCurr: state_type] :
      ( v572(VarCurr)
     => ( v620(VarCurr)
      <=> $false ) ) ).

tff(addBitVectorEqualityBitBlasted_50,axiom,
    ! [VarCurr: state_type] :
      ( v621(VarCurr)
    <=> ( ( v622(VarCurr,1)
        <=> $true )
        & ( v622(VarCurr,0)
        <=> $false ) ) ) ).

tff(addAssignment_165,axiom,
    ! [VarCurr: state_type] :
      ( v622(VarCurr,0)
    <=> v15(VarCurr) ) ).

tff(addAssignment_164,axiom,
    ! [VarCurr: state_type] :
      ( v622(VarCurr,1)
    <=> v56(VarCurr) ) ).

tff(aaddConditionBooleanCondEqualRangesElseBranch_19,axiom,
    ! [VarCurr: state_type] :
      ( ~ v15(VarCurr)
     => ( v619(VarCurr)
      <=> $true ) ) ).

tff(addConditionBooleanCondEqualRangesThenBranch_21,axiom,
    ! [VarCurr: state_type] :
      ( v15(VarCurr)
     => ( v619(VarCurr)
      <=> $false ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_112,axiom,
    ! [VarCurr: state_type] :
      ( v614(VarCurr)
    <=> ( v615(VarCurr)
        | v604(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_111,axiom,
    ! [VarCurr: state_type] :
      ( v615(VarCurr)
    <=> ( v616(VarCurr)
        | v577(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_110,axiom,
    ! [VarCurr: state_type] :
      ( v616(VarCurr)
    <=> ( v617(VarCurr)
        & v54(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_109,axiom,
    ! [VarCurr: state_type] :
      ( v617(VarCurr)
    <=> ( v52(VarCurr)
        & v53(VarCurr) ) ) ).

tff(addAssignment_163,axiom,
    ! [VarNext: state_type] :
      ( v7(VarNext,1)
    <=> v606(VarNext,0) ) ).

tff(addCaseBooleanConditionShiftedRanges1_9,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v607(VarNext)
       => ( ( v606(VarNext,1)
          <=> v7(VarCurr,2) )
          & ( v606(VarNext,0)
          <=> v7(VarCurr,1) ) ) ) ) ).

tff(addCaseBooleanConditionEqualRanges0_18,axiom,
    ! [VarNext: state_type] :
      ( v607(VarNext)
     => ! [B: $int] :
          ( ( $less(B,2)
            & ~ $less(B,0) )
         => ( v606(VarNext,B)
          <=> v590(VarNext,B) ) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_108,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v607(VarNext)
      <=> v608(VarNext) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_107,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v608(VarNext)
      <=> ( v610(VarNext)
          & v112(VarNext) ) ) ) ).

tff(writeUnaryOperator_37,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v610(VarNext)
      <=> v584(VarNext) ) ) ).

tff(addConditionBooleanCondShiftedRangesElseBranch_6,axiom,
    ! [VarCurr: state_type] :
      ( ~ v595(VarCurr)
     => ( v13(VarCurr,1)
      <=> $false ) ) ).

tff(addConditionBooleanCondShiftedRangesThenBranch_4,axiom,
    ! [VarCurr: state_type] :
      ( v595(VarCurr)
     => ( v13(VarCurr,1)
      <=> $true ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_106,axiom,
    ! [VarCurr: state_type] :
      ( v595(VarCurr)
    <=> ( v596(VarCurr)
        | v603(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_105,axiom,
    ! [VarCurr: state_type] :
      ( v603(VarCurr)
    <=> ( v15(VarCurr)
        & v604(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_49,axiom,
    ! [VarCurr: state_type] :
      ( v604(VarCurr)
    <=> ( $true
      <=> v7(VarCurr,1) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_104,axiom,
    ! [VarCurr: state_type] :
      ( v596(VarCurr)
    <=> ( v597(VarCurr)
        | v600(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_103,axiom,
    ! [VarCurr: state_type] :
      ( v600(VarCurr)
    <=> ( v601(VarCurr)
        & v577(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_48,axiom,
    ! [VarCurr: state_type] :
      ( v601(VarCurr)
    <=> ( ( v602(VarCurr,1)
        <=> $true )
        & ( v602(VarCurr,0)
        <=> $true ) ) ) ).

tff(addAssignment_162,axiom,
    ! [VarCurr: state_type] :
      ( v602(VarCurr,0)
    <=> v15(VarCurr) ) ).

tff(addAssignment_161,axiom,
    ! [VarCurr: state_type] :
      ( v602(VarCurr,1)
    <=> v56(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_102,axiom,
    ! [VarCurr: state_type] :
      ( v597(VarCurr)
    <=> ( v598(VarCurr)
        & v54(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_101,axiom,
    ! [VarCurr: state_type] :
      ( v598(VarCurr)
    <=> ( v599(VarCurr)
        & v53(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_100,axiom,
    ! [VarCurr: state_type] :
      ( v599(VarCurr)
    <=> ( v15(VarCurr)
        & v52(VarCurr) ) ) ).

tff(addAssignment_160,axiom,
    ! [VarNext: state_type] :
      ( v7(VarNext,2)
    <=> v579(VarNext,1) ) ).

tff(addCaseBooleanConditionShiftedRanges1_8,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v580(VarNext)
       => ( ( v579(VarNext,1)
          <=> v7(VarCurr,2) )
          & ( v579(VarNext,0)
          <=> v7(VarCurr,1) ) ) ) ) ).

tff(addCaseBooleanConditionEqualRanges0_17,axiom,
    ! [VarNext: state_type] :
      ( v580(VarNext)
     => ! [B: $int] :
          ( ( $less(B,2)
            & ~ $less(B,0) )
         => ( v579(VarNext,B)
          <=> v590(VarNext,B) ) ) ) ).

tff(addAssignment_159,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ! [B: $int] :
          ( ( $less(B,2)
            & ~ $less(B,0) )
         => ( v590(VarNext,B)
          <=> v588(VarCurr,B) ) ) ) ).

tff(addConditionBooleanCondShiftedRangesElseBranch_5,axiom,
    ! [VarCurr: state_type] :
      ( ~ v591(VarCurr)
     => ( ( v588(VarCurr,1)
        <=> v13(VarCurr,2) )
        & ( v588(VarCurr,0)
        <=> v13(VarCurr,1) ) ) ) ).

tff(addConditionBooleanCondEqualRangesThenBranch_20,axiom,
    ! [VarCurr: state_type] :
      ( v591(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,2)
            & ~ $less(B,0) )
         => ( v588(VarCurr,B)
          <=> $false ) ) ) ).

tff(writeUnaryOperator_36,axiom,
    ! [VarCurr: state_type] :
      ( ~ v591(VarCurr)
    <=> v9(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_99,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v580(VarNext)
      <=> v581(VarNext) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_98,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v581(VarNext)
      <=> ( v582(VarNext)
          & v112(VarNext) ) ) ) ).

tff(writeUnaryOperator_35,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v582(VarNext)
      <=> v584(VarNext) ) ) ).

tff(addAssignment_158,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v584(VarNext)
      <=> v112(VarCurr) ) ) ).

tff(addConditionBooleanCondShiftedRangesElseBranch_4,axiom,
    ! [VarCurr: state_type] :
      ( ~ v567(VarCurr)
     => ( v13(VarCurr,2)
      <=> $false ) ) ).

tff(addConditionBooleanCondShiftedRangesThenBranch_3,axiom,
    ! [VarCurr: state_type] :
      ( v567(VarCurr)
     => ( v13(VarCurr,2)
      <=> $true ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_97,axiom,
    ! [VarCurr: state_type] :
      ( v567(VarCurr)
    <=> ( v568(VarCurr)
        | v571(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_96,axiom,
    ! [VarCurr: state_type] :
      ( v571(VarCurr)
    <=> ( v572(VarCurr)
        & v577(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_47,axiom,
    ! [VarCurr: state_type] :
      ( v577(VarCurr)
    <=> ( $true
      <=> v7(VarCurr,2) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_95,axiom,
    ! [VarCurr: state_type] :
      ( v572(VarCurr)
    <=> ( v573(VarCurr)
        | v575(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_46,axiom,
    ! [VarCurr: state_type] :
      ( v575(VarCurr)
    <=> ( ( v576(VarCurr,1)
        <=> $false )
        & ( v576(VarCurr,0)
        <=> $true ) ) ) ).

tff(addAssignment_157,axiom,
    ! [VarCurr: state_type] :
      ( v576(VarCurr,0)
    <=> v15(VarCurr) ) ).

tff(addAssignment_156,axiom,
    ! [VarCurr: state_type] :
      ( v576(VarCurr,1)
    <=> v56(VarCurr) ) ).

tff(addBitVectorEqualityBitBlasted_45,axiom,
    ! [VarCurr: state_type] :
      ( v573(VarCurr)
    <=> ( ( v574(VarCurr,1)
        <=> $false )
        & ( v574(VarCurr,0)
        <=> $false ) ) ) ).

tff(addAssignment_155,axiom,
    ! [VarCurr: state_type] :
      ( v574(VarCurr,0)
    <=> v15(VarCurr) ) ).

tff(addAssignment_154,axiom,
    ! [VarCurr: state_type] :
      ( v574(VarCurr,1)
    <=> v56(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_94,axiom,
    ! [VarCurr: state_type] :
      ( v568(VarCurr)
    <=> ( v569(VarCurr)
        & v54(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_93,axiom,
    ! [VarCurr: state_type] :
      ( v569(VarCurr)
    <=> ( v570(VarCurr)
        & v53(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_92,axiom,
    ! [VarCurr: state_type] :
      ( v570(VarCurr)
    <=> ( v76(VarCurr)
        & v353(VarCurr) ) ) ).

tff(aaddConditionBooleanCondEqualRangesElseBranch_18,axiom,
    ! [VarCurr: state_type] :
      ( ~ v30(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,2)
            & ~ $less(B,0) )
         => ( v28(VarCurr,B)
          <=> v538(VarCurr,B) ) ) ) ).

tff(addConditionBooleanCondEqualRangesThenBranch_19,axiom,
    ! [VarCurr: state_type] :
      ( v30(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,2)
            & ~ $less(B,0) )
         => ( v28(VarCurr,B)
          <=> $false ) ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges3_2,axiom,
    ! [VarCurr: state_type] :
      ( ( ~ v539(VarCurr)
        & ~ v559(VarCurr)
        & ~ v560(VarCurr) )
     => ! [B: $int] :
          ( ( $less(B,2)
            & ~ $less(B,0) )
         => ( v538(VarCurr,B)
          <=> $true ) ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges2_5,axiom,
    ! [VarCurr: state_type] :
      ( v560(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,2)
            & ~ $less(B,0) )
         => ( v538(VarCurr,B)
          <=> b10(B) ) ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges1_8,axiom,
    ! [VarCurr: state_type] :
      ( v559(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,2)
            & ~ $less(B,0) )
         => ( v538(VarCurr,B)
          <=> b01(B) ) ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges0_5,axiom,
    ! [VarCurr: state_type] :
      ( v539(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,2)
            & ~ $less(B,0) )
         => ( v538(VarCurr,B)
          <=> $false ) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_91,axiom,
    ! [VarCurr: state_type] :
      ( v560(VarCurr)
    <=> ( v562(VarCurr)
        | v565(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_44,axiom,
    ! [VarCurr: state_type] :
      ( v565(VarCurr)
    <=> ( ( v460(VarCurr,6)
        <=> $true )
        & ( v460(VarCurr,5)
        <=> $false )
        & ( v460(VarCurr,4)
        <=> $false )
        & ( v460(VarCurr,3)
        <=> $true )
        & ( v460(VarCurr,2)
        <=> $false )
        & ( v460(VarCurr,1)
        <=> $true )
        & ( v460(VarCurr,0)
        <=> $false ) ) ) ).

tff(bitBlastConstant_268,axiom,
    b1001010(6) ).

tff(bitBlastConstant_267,axiom,
    ~ b1001010(5) ).

tff(bitBlastConstant_266,axiom,
    ~ b1001010(4) ).

tff(bitBlastConstant_265,axiom,
    b1001010(3) ).

tff(bitBlastConstant_264,axiom,
    ~ b1001010(2) ).

tff(bitBlastConstant_263,axiom,
    b1001010(1) ).

tff(bitBlastConstant_262,axiom,
    ~ b1001010(0) ).

tff(writeBinaryOperatorEqualRangesSingleBits_90,axiom,
    ! [VarCurr: state_type] :
      ( v562(VarCurr)
    <=> ( v563(VarCurr)
        | v564(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_43,axiom,
    ! [VarCurr: state_type] :
      ( v564(VarCurr)
    <=> ( ( v460(VarCurr,6)
        <=> $false )
        & ( v460(VarCurr,5)
        <=> $false )
        & ( v460(VarCurr,4)
        <=> $false )
        & ( v460(VarCurr,3)
        <=> $true )
        & ( v460(VarCurr,2)
        <=> $false )
        & ( v460(VarCurr,1)
        <=> $true )
        & ( v460(VarCurr,0)
        <=> $true ) ) ) ).

tff(bitBlastConstant_261,axiom,
    ~ b0001011(6) ).

tff(bitBlastConstant_260,axiom,
    ~ b0001011(5) ).

tff(bitBlastConstant_259,axiom,
    ~ b0001011(4) ).

tff(bitBlastConstant_258,axiom,
    b0001011(3) ).

tff(bitBlastConstant_257,axiom,
    ~ b0001011(2) ).

tff(bitBlastConstant_256,axiom,
    b0001011(1) ).

tff(bitBlastConstant_255,axiom,
    b0001011(0) ).

tff(addBitVectorEqualityBitBlasted_42,axiom,
    ! [VarCurr: state_type] :
      ( v563(VarCurr)
    <=> ( ( v460(VarCurr,6)
        <=> $false )
        & ( v460(VarCurr,5)
        <=> $false )
        & ( v460(VarCurr,4)
        <=> $false )
        & ( v460(VarCurr,3)
        <=> $true )
        & ( v460(VarCurr,2)
        <=> $false )
        & ( v460(VarCurr,1)
        <=> $true )
        & ( v460(VarCurr,0)
        <=> $false ) ) ) ).

tff(bitBlastConstant_254,axiom,
    ~ b0001010(6) ).

tff(bitBlastConstant_253,axiom,
    ~ b0001010(5) ).

tff(bitBlastConstant_252,axiom,
    ~ b0001010(4) ).

tff(bitBlastConstant_251,axiom,
    b0001010(3) ).

tff(bitBlastConstant_250,axiom,
    ~ b0001010(2) ).

tff(bitBlastConstant_249,axiom,
    b0001010(1) ).

tff(bitBlastConstant_248,axiom,
    ~ b0001010(0) ).

tff(addBitVectorEqualityBitBlasted_41,axiom,
    ! [VarCurr: state_type] :
      ( v559(VarCurr)
    <=> ( ( v460(VarCurr,6)
        <=> $true )
        & ( v460(VarCurr,5)
        <=> $true )
        & ( v460(VarCurr,4)
        <=> $true )
        & ( v460(VarCurr,3)
        <=> $true )
        & ( v460(VarCurr,2)
        <=> $false )
        & ( v460(VarCurr,1)
        <=> $true )
        & ( v460(VarCurr,0)
        <=> $false ) ) ) ).

tff(bitBlastConstant_247,axiom,
    b1111010(6) ).

tff(bitBlastConstant_246,axiom,
    b1111010(5) ).

tff(bitBlastConstant_245,axiom,
    b1111010(4) ).

tff(bitBlastConstant_244,axiom,
    b1111010(3) ).

tff(bitBlastConstant_243,axiom,
    ~ b1111010(2) ).

tff(bitBlastConstant_242,axiom,
    b1111010(1) ).

tff(bitBlastConstant_241,axiom,
    ~ b1111010(0) ).

tff(writeBinaryOperatorEqualRangesSingleBits_89,axiom,
    ! [VarCurr: state_type] :
      ( v539(VarCurr)
    <=> ( v541(VarCurr)
        | v558(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_40,axiom,
    ! [VarCurr: state_type] :
      ( v558(VarCurr)
    <=> ( ( v460(VarCurr,6)
        <=> $true )
        & ( v460(VarCurr,5)
        <=> $false )
        & ( v460(VarCurr,4)
        <=> $false )
        & ( v460(VarCurr,3)
        <=> $false )
        & ( v460(VarCurr,2)
        <=> $true )
        & ( v460(VarCurr,1)
        <=> $false )
        & ( v460(VarCurr,0)
        <=> $true ) ) ) ).

tff(bitBlastConstant_240,axiom,
    b1000101(6) ).

tff(bitBlastConstant_239,axiom,
    ~ b1000101(5) ).

tff(bitBlastConstant_238,axiom,
    ~ b1000101(4) ).

tff(bitBlastConstant_237,axiom,
    ~ b1000101(3) ).

tff(bitBlastConstant_236,axiom,
    b1000101(2) ).

tff(bitBlastConstant_235,axiom,
    ~ b1000101(1) ).

tff(bitBlastConstant_234,axiom,
    b1000101(0) ).

tff(writeBinaryOperatorEqualRangesSingleBits_88,axiom,
    ! [VarCurr: state_type] :
      ( v541(VarCurr)
    <=> ( v542(VarCurr)
        | v557(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_39,axiom,
    ! [VarCurr: state_type] :
      ( v557(VarCurr)
    <=> ( ( v460(VarCurr,6)
        <=> $true )
        & ( v460(VarCurr,5)
        <=> $false )
        & ( v460(VarCurr,4)
        <=> $false )
        & ( v460(VarCurr,3)
        <=> $false )
        & ( v460(VarCurr,2)
        <=> $true )
        & ( v460(VarCurr,1)
        <=> $false )
        & ( v460(VarCurr,0)
        <=> $false ) ) ) ).

tff(bitBlastConstant_233,axiom,
    b1000100(6) ).

tff(bitBlastConstant_232,axiom,
    ~ b1000100(5) ).

tff(bitBlastConstant_231,axiom,
    ~ b1000100(4) ).

tff(bitBlastConstant_230,axiom,
    ~ b1000100(3) ).

tff(bitBlastConstant_229,axiom,
    b1000100(2) ).

tff(bitBlastConstant_228,axiom,
    ~ b1000100(1) ).

tff(bitBlastConstant_227,axiom,
    ~ b1000100(0) ).

tff(writeBinaryOperatorEqualRangesSingleBits_87,axiom,
    ! [VarCurr: state_type] :
      ( v542(VarCurr)
    <=> ( v543(VarCurr)
        | v556(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_38,axiom,
    ! [VarCurr: state_type] :
      ( v556(VarCurr)
    <=> ( ( v460(VarCurr,6)
        <=> $true )
        & ( v460(VarCurr,5)
        <=> $true )
        & ( v460(VarCurr,4)
        <=> $false )
        & ( v460(VarCurr,3)
        <=> $false )
        & ( v460(VarCurr,2)
        <=> $false )
        & ( v460(VarCurr,1)
        <=> $false )
        & ( v460(VarCurr,0)
        <=> $false ) ) ) ).

tff(bitBlastConstant_226,axiom,
    b1100000(6) ).

tff(bitBlastConstant_225,axiom,
    b1100000(5) ).

tff(bitBlastConstant_224,axiom,
    ~ b1100000(4) ).

tff(bitBlastConstant_223,axiom,
    ~ b1100000(3) ).

tff(bitBlastConstant_222,axiom,
    ~ b1100000(2) ).

tff(bitBlastConstant_221,axiom,
    ~ b1100000(1) ).

tff(bitBlastConstant_220,axiom,
    ~ b1100000(0) ).

tff(writeBinaryOperatorEqualRangesSingleBits_86,axiom,
    ! [VarCurr: state_type] :
      ( v543(VarCurr)
    <=> ( v544(VarCurr)
        | v555(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_37,axiom,
    ! [VarCurr: state_type] :
      ( v555(VarCurr)
    <=> ( ( v460(VarCurr,6)
        <=> $true )
        & ( v460(VarCurr,5)
        <=> $false )
        & ( v460(VarCurr,4)
        <=> $false )
        & ( v460(VarCurr,3)
        <=> $false )
        & ( v460(VarCurr,2)
        <=> $false )
        & ( v460(VarCurr,1)
        <=> $false )
        & ( v460(VarCurr,0)
        <=> $false ) ) ) ).

tff(bitBlastConstant_219,axiom,
    b1000000(6) ).

tff(bitBlastConstant_218,axiom,
    ~ b1000000(5) ).

tff(bitBlastConstant_217,axiom,
    ~ b1000000(4) ).

tff(bitBlastConstant_216,axiom,
    ~ b1000000(3) ).

tff(bitBlastConstant_215,axiom,
    ~ b1000000(2) ).

tff(bitBlastConstant_214,axiom,
    ~ b1000000(1) ).

tff(bitBlastConstant_213,axiom,
    ~ b1000000(0) ).

tff(writeBinaryOperatorEqualRangesSingleBits_85,axiom,
    ! [VarCurr: state_type] :
      ( v544(VarCurr)
    <=> ( v545(VarCurr)
        | v554(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_36,axiom,
    ! [VarCurr: state_type] :
      ( v554(VarCurr)
    <=> ( ( v460(VarCurr,6)
        <=> $true )
        & ( v460(VarCurr,5)
        <=> $false )
        & ( v460(VarCurr,4)
        <=> $false )
        & ( v460(VarCurr,3)
        <=> $false )
        & ( v460(VarCurr,2)
        <=> $false )
        & ( v460(VarCurr,1)
        <=> $true )
        & ( v460(VarCurr,0)
        <=> $false ) ) ) ).

tff(bitBlastConstant_212,axiom,
    b1000010(6) ).

tff(bitBlastConstant_211,axiom,
    ~ b1000010(5) ).

tff(bitBlastConstant_210,axiom,
    ~ b1000010(4) ).

tff(bitBlastConstant_209,axiom,
    ~ b1000010(3) ).

tff(bitBlastConstant_208,axiom,
    ~ b1000010(2) ).

tff(bitBlastConstant_207,axiom,
    b1000010(1) ).

tff(bitBlastConstant_206,axiom,
    ~ b1000010(0) ).

tff(writeBinaryOperatorEqualRangesSingleBits_84,axiom,
    ! [VarCurr: state_type] :
      ( v545(VarCurr)
    <=> ( v546(VarCurr)
        | v553(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_35,axiom,
    ! [VarCurr: state_type] :
      ( v553(VarCurr)
    <=> ( ( v460(VarCurr,6)
        <=> $false )
        & ( v460(VarCurr,5)
        <=> $false )
        & ( v460(VarCurr,4)
        <=> $false )
        & ( v460(VarCurr,3)
        <=> $false )
        & ( v460(VarCurr,2)
        <=> $true )
        & ( v460(VarCurr,1)
        <=> $false )
        & ( v460(VarCurr,0)
        <=> $true ) ) ) ).

tff(bitBlastConstant_205,axiom,
    ~ b0000101(6) ).

tff(bitBlastConstant_204,axiom,
    ~ b0000101(5) ).

tff(bitBlastConstant_203,axiom,
    ~ b0000101(4) ).

tff(bitBlastConstant_202,axiom,
    ~ b0000101(3) ).

tff(bitBlastConstant_201,axiom,
    b0000101(2) ).

tff(bitBlastConstant_200,axiom,
    ~ b0000101(1) ).

tff(bitBlastConstant_199,axiom,
    b0000101(0) ).

tff(writeBinaryOperatorEqualRangesSingleBits_83,axiom,
    ! [VarCurr: state_type] :
      ( v546(VarCurr)
    <=> ( v547(VarCurr)
        | v552(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_34,axiom,
    ! [VarCurr: state_type] :
      ( v552(VarCurr)
    <=> ( ( v460(VarCurr,6)
        <=> $false )
        & ( v460(VarCurr,5)
        <=> $false )
        & ( v460(VarCurr,4)
        <=> $false )
        & ( v460(VarCurr,3)
        <=> $false )
        & ( v460(VarCurr,2)
        <=> $true )
        & ( v460(VarCurr,1)
        <=> $false )
        & ( v460(VarCurr,0)
        <=> $false ) ) ) ).

tff(bitBlastConstant_198,axiom,
    ~ b0000100(6) ).

tff(bitBlastConstant_197,axiom,
    ~ b0000100(5) ).

tff(bitBlastConstant_196,axiom,
    ~ b0000100(4) ).

tff(bitBlastConstant_195,axiom,
    ~ b0000100(3) ).

tff(bitBlastConstant_194,axiom,
    b0000100(2) ).

tff(bitBlastConstant_193,axiom,
    ~ b0000100(1) ).

tff(bitBlastConstant_192,axiom,
    ~ b0000100(0) ).

tff(writeBinaryOperatorEqualRangesSingleBits_82,axiom,
    ! [VarCurr: state_type] :
      ( v547(VarCurr)
    <=> ( v548(VarCurr)
        | v551(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_33,axiom,
    ! [VarCurr: state_type] :
      ( v551(VarCurr)
    <=> ( ( v460(VarCurr,6)
        <=> $false )
        & ( v460(VarCurr,5)
        <=> $false )
        & ( v460(VarCurr,4)
        <=> $false )
        & ( v460(VarCurr,3)
        <=> $false )
        & ( v460(VarCurr,2)
        <=> $false )
        & ( v460(VarCurr,1)
        <=> $true )
        & ( v460(VarCurr,0)
        <=> $false ) ) ) ).

tff(bitBlastConstant_191,axiom,
    ~ b0000010(6) ).

tff(bitBlastConstant_190,axiom,
    ~ b0000010(5) ).

tff(bitBlastConstant_189,axiom,
    ~ b0000010(4) ).

tff(bitBlastConstant_188,axiom,
    ~ b0000010(3) ).

tff(bitBlastConstant_187,axiom,
    ~ b0000010(2) ).

tff(bitBlastConstant_186,axiom,
    b0000010(1) ).

tff(bitBlastConstant_185,axiom,
    ~ b0000010(0) ).

tff(writeBinaryOperatorEqualRangesSingleBits_81,axiom,
    ! [VarCurr: state_type] :
      ( v548(VarCurr)
    <=> ( v549(VarCurr)
        | v550(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_32,axiom,
    ! [VarCurr: state_type] :
      ( v550(VarCurr)
    <=> ( ( v460(VarCurr,6)
        <=> $false )
        & ( v460(VarCurr,5)
        <=> $true )
        & ( v460(VarCurr,4)
        <=> $false )
        & ( v460(VarCurr,3)
        <=> $false )
        & ( v460(VarCurr,2)
        <=> $false )
        & ( v460(VarCurr,1)
        <=> $false )
        & ( v460(VarCurr,0)
        <=> $false ) ) ) ).

tff(bitBlastConstant_184,axiom,
    ~ b0100000(6) ).

tff(bitBlastConstant_183,axiom,
    b0100000(5) ).

tff(bitBlastConstant_182,axiom,
    ~ b0100000(4) ).

tff(bitBlastConstant_181,axiom,
    ~ b0100000(3) ).

tff(bitBlastConstant_180,axiom,
    ~ b0100000(2) ).

tff(bitBlastConstant_179,axiom,
    ~ b0100000(1) ).

tff(bitBlastConstant_178,axiom,
    ~ b0100000(0) ).

tff(addBitVectorEqualityBitBlasted_31,axiom,
    ! [VarCurr: state_type] :
      ( v549(VarCurr)
    <=> ( ( v460(VarCurr,6)
        <=> $false )
        & ( v460(VarCurr,5)
        <=> $false )
        & ( v460(VarCurr,4)
        <=> $false )
        & ( v460(VarCurr,3)
        <=> $false )
        & ( v460(VarCurr,2)
        <=> $false )
        & ( v460(VarCurr,1)
        <=> $false )
        & ( v460(VarCurr,0)
        <=> $false ) ) ) ).

tff(bitBlastConstant_177,axiom,
    ~ b0000000(6) ).

tff(bitBlastConstant_176,axiom,
    ~ b0000000(5) ).

tff(bitBlastConstant_175,axiom,
    ~ b0000000(4) ).

tff(bitBlastConstant_174,axiom,
    ~ b0000000(3) ).

tff(bitBlastConstant_173,axiom,
    ~ b0000000(2) ).

tff(bitBlastConstant_172,axiom,
    ~ b0000000(1) ).

tff(bitBlastConstant_171,axiom,
    ~ b0000000(0) ).

tff(addAssignment_153,axiom,
    ! [VarCurr: state_type] :
      ( ( v460(VarCurr,6)
      <=> v90(VarCurr,69) )
      & ( v460(VarCurr,5)
      <=> v90(VarCurr,68) )
      & ( v460(VarCurr,4)
      <=> v90(VarCurr,67) )
      & ( v460(VarCurr,3)
      <=> v90(VarCurr,66) )
      & ( v460(VarCurr,2)
      <=> v90(VarCurr,65) )
      & ( v460(VarCurr,1)
      <=> v90(VarCurr,64) )
      & ( v460(VarCurr,0)
      <=> v90(VarCurr,63) ) ) ).

tff(addAssignment_152,axiom,
    ! [VarCurr: state_type,B: $int] :
      ( ( $less(B,70)
        & ~ $less(B,63) )
     => ( v90(VarCurr,B)
      <=> v92(VarCurr,B) ) ) ).

tff(addAssignment_151,axiom,
    ! [VarCurr: state_type] :
      ( ( v92(VarCurr,69)
      <=> v94(VarCurr,559) )
      & ( v92(VarCurr,68)
      <=> v94(VarCurr,558) )
      & ( v92(VarCurr,67)
      <=> v94(VarCurr,557) )
      & ( v92(VarCurr,66)
      <=> v94(VarCurr,556) )
      & ( v92(VarCurr,65)
      <=> v94(VarCurr,555) )
      & ( v92(VarCurr,64)
      <=> v94(VarCurr,554) )
      & ( v92(VarCurr,63)
      <=> v94(VarCurr,553) ) ) ).

tff(addAssignment_150,axiom,
    ! [VarNext: state_type] :
      ( ( v94(VarNext,559)
      <=> v516(VarNext,69) )
      & ( v94(VarNext,558)
      <=> v516(VarNext,68) )
      & ( v94(VarNext,557)
      <=> v516(VarNext,67) )
      & ( v94(VarNext,556)
      <=> v516(VarNext,66) )
      & ( v94(VarNext,555)
      <=> v516(VarNext,65) )
      & ( v94(VarNext,554)
      <=> v516(VarNext,64) )
      & ( v94(VarNext,553)
      <=> v516(VarNext,63) ) ) ).

tff(addCaseBooleanConditionShiftedRanges1_7,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v518(VarNext)
       => ( ( v516(VarNext,69)
          <=> v94(VarCurr,559) )
          & ( v516(VarNext,68)
          <=> v94(VarCurr,558) )
          & ( v516(VarNext,67)
          <=> v94(VarCurr,557) )
          & ( v516(VarNext,66)
          <=> v94(VarCurr,556) )
          & ( v516(VarNext,65)
          <=> v94(VarCurr,555) )
          & ( v516(VarNext,64)
          <=> v94(VarCurr,554) )
          & ( v516(VarNext,63)
          <=> v94(VarCurr,553) )
          & ( v516(VarNext,62)
          <=> v94(VarCurr,552) )
          & ( v516(VarNext,61)
          <=> v94(VarCurr,551) )
          & ( v516(VarNext,60)
          <=> v94(VarCurr,550) )
          & ( v516(VarNext,59)
          <=> v94(VarCurr,549) )
          & ( v516(VarNext,58)
          <=> v94(VarCurr,548) )
          & ( v516(VarNext,57)
          <=> v94(VarCurr,547) )
          & ( v516(VarNext,56)
          <=> v94(VarCurr,546) )
          & ( v516(VarNext,55)
          <=> v94(VarCurr,545) )
          & ( v516(VarNext,54)
          <=> v94(VarCurr,544) )
          & ( v516(VarNext,53)
          <=> v94(VarCurr,543) )
          & ( v516(VarNext,52)
          <=> v94(VarCurr,542) )
          & ( v516(VarNext,51)
          <=> v94(VarCurr,541) )
          & ( v516(VarNext,50)
          <=> v94(VarCurr,540) )
          & ( v516(VarNext,49)
          <=> v94(VarCurr,539) )
          & ( v516(VarNext,48)
          <=> v94(VarCurr,538) )
          & ( v516(VarNext,47)
          <=> v94(VarCurr,537) )
          & ( v516(VarNext,46)
          <=> v94(VarCurr,536) )
          & ( v516(VarNext,45)
          <=> v94(VarCurr,535) )
          & ( v516(VarNext,44)
          <=> v94(VarCurr,534) )
          & ( v516(VarNext,43)
          <=> v94(VarCurr,533) )
          & ( v516(VarNext,42)
          <=> v94(VarCurr,532) )
          & ( v516(VarNext,41)
          <=> v94(VarCurr,531) )
          & ( v516(VarNext,40)
          <=> v94(VarCurr,530) )
          & ( v516(VarNext,39)
          <=> v94(VarCurr,529) )
          & ( v516(VarNext,38)
          <=> v94(VarCurr,528) )
          & ( v516(VarNext,37)
          <=> v94(VarCurr,527) )
          & ( v516(VarNext,36)
          <=> v94(VarCurr,526) )
          & ( v516(VarNext,35)
          <=> v94(VarCurr,525) )
          & ( v516(VarNext,34)
          <=> v94(VarCurr,524) )
          & ( v516(VarNext,33)
          <=> v94(VarCurr,523) )
          & ( v516(VarNext,32)
          <=> v94(VarCurr,522) )
          & ( v516(VarNext,31)
          <=> v94(VarCurr,521) )
          & ( v516(VarNext,30)
          <=> v94(VarCurr,520) )
          & ( v516(VarNext,29)
          <=> v94(VarCurr,519) )
          & ( v516(VarNext,28)
          <=> v94(VarCurr,518) )
          & ( v516(VarNext,27)
          <=> v94(VarCurr,517) )
          & ( v516(VarNext,26)
          <=> v94(VarCurr,516) )
          & ( v516(VarNext,25)
          <=> v94(VarCurr,515) )
          & ( v516(VarNext,24)
          <=> v94(VarCurr,514) )
          & ( v516(VarNext,23)
          <=> v94(VarCurr,513) )
          & ( v516(VarNext,22)
          <=> v94(VarCurr,512) )
          & ( v516(VarNext,21)
          <=> v94(VarCurr,511) )
          & ( v516(VarNext,20)
          <=> v94(VarCurr,510) )
          & ( v516(VarNext,19)
          <=> v94(VarCurr,509) )
          & ( v516(VarNext,18)
          <=> v94(VarCurr,508) )
          & ( v516(VarNext,17)
          <=> v94(VarCurr,507) )
          & ( v516(VarNext,16)
          <=> v94(VarCurr,506) )
          & ( v516(VarNext,15)
          <=> v94(VarCurr,505) )
          & ( v516(VarNext,14)
          <=> v94(VarCurr,504) )
          & ( v516(VarNext,13)
          <=> v94(VarCurr,503) )
          & ( v516(VarNext,12)
          <=> v94(VarCurr,502) )
          & ( v516(VarNext,11)
          <=> v94(VarCurr,501) )
          & ( v516(VarNext,10)
          <=> v94(VarCurr,500) )
          & ( v516(VarNext,9)
          <=> v94(VarCurr,499) )
          & ( v516(VarNext,8)
          <=> v94(VarCurr,498) )
          & ( v516(VarNext,7)
          <=> v94(VarCurr,497) )
          & ( v516(VarNext,6)
          <=> v94(VarCurr,496) )
          & ( v516(VarNext,5)
          <=> v94(VarCurr,495) )
          & ( v516(VarNext,4)
          <=> v94(VarCurr,494) )
          & ( v516(VarNext,3)
          <=> v94(VarCurr,493) )
          & ( v516(VarNext,2)
          <=> v94(VarCurr,492) )
          & ( v516(VarNext,1)
          <=> v94(VarCurr,491) )
          & ( v516(VarNext,0)
          <=> v94(VarCurr,490) ) ) ) ) ).

tff(addCaseBooleanConditionEqualRanges0_16,axiom,
    ! [VarNext: state_type] :
      ( v518(VarNext)
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v516(VarNext,B)
          <=> v278(VarNext,B) ) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_80,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v518(VarNext)
      <=> ( v519(VarNext)
          & v260(VarNext) ) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_79,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v519(VarNext)
      <=> ( v521(VarNext)
          & v110(VarNext) ) ) ) ).

tff(writeUnaryOperator_34,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v521(VarNext)
      <=> v119(VarNext) ) ) ).

tff(addAssignment_149,axiom,
    ! [VarCurr: state_type,B: $int] :
      ( ( $less(B,70)
        & ~ $less(B,63) )
     => ( v244(VarCurr,B)
      <=> v249(VarCurr,B) ) ) ).

tff(addAssignment_148,axiom,
    ! [VarCurr: state_type] :
      ( ( v248(VarCurr,69)
      <=> v94(VarCurr,489) )
      & ( v248(VarCurr,68)
      <=> v94(VarCurr,488) )
      & ( v248(VarCurr,67)
      <=> v94(VarCurr,487) )
      & ( v248(VarCurr,66)
      <=> v94(VarCurr,486) )
      & ( v248(VarCurr,65)
      <=> v94(VarCurr,485) )
      & ( v248(VarCurr,64)
      <=> v94(VarCurr,484) )
      & ( v248(VarCurr,63)
      <=> v94(VarCurr,483) ) ) ).

tff(addAssignment_147,axiom,
    ! [VarCurr: state_type,B: $int] :
      ( ( $less(B,70)
        & ~ $less(B,63) )
     => ( v237(VarCurr,B)
      <=> v242(VarCurr,B) ) ) ).

tff(addAssignment_146,axiom,
    ! [VarCurr: state_type] :
      ( ( v241(VarCurr,69)
      <=> v94(VarCurr,559) )
      & ( v241(VarCurr,68)
      <=> v94(VarCurr,558) )
      & ( v241(VarCurr,67)
      <=> v94(VarCurr,557) )
      & ( v241(VarCurr,66)
      <=> v94(VarCurr,556) )
      & ( v241(VarCurr,65)
      <=> v94(VarCurr,555) )
      & ( v241(VarCurr,64)
      <=> v94(VarCurr,554) )
      & ( v241(VarCurr,63)
      <=> v94(VarCurr,553) ) ) ).

tff(addAssignment_145,axiom,
    ! [VarNext: state_type] :
      ( ( v94(VarNext,489)
      <=> v508(VarNext,69) )
      & ( v94(VarNext,488)
      <=> v508(VarNext,68) )
      & ( v94(VarNext,487)
      <=> v508(VarNext,67) )
      & ( v94(VarNext,486)
      <=> v508(VarNext,66) )
      & ( v94(VarNext,485)
      <=> v508(VarNext,65) )
      & ( v94(VarNext,484)
      <=> v508(VarNext,64) )
      & ( v94(VarNext,483)
      <=> v508(VarNext,63) ) ) ).

tff(addCaseBooleanConditionShiftedRanges1_6,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v510(VarNext)
       => ( ( v508(VarNext,69)
          <=> v94(VarCurr,489) )
          & ( v508(VarNext,68)
          <=> v94(VarCurr,488) )
          & ( v508(VarNext,67)
          <=> v94(VarCurr,487) )
          & ( v508(VarNext,66)
          <=> v94(VarCurr,486) )
          & ( v508(VarNext,65)
          <=> v94(VarCurr,485) )
          & ( v508(VarNext,64)
          <=> v94(VarCurr,484) )
          & ( v508(VarNext,63)
          <=> v94(VarCurr,483) )
          & ( v508(VarNext,62)
          <=> v94(VarCurr,482) )
          & ( v508(VarNext,61)
          <=> v94(VarCurr,481) )
          & ( v508(VarNext,60)
          <=> v94(VarCurr,480) )
          & ( v508(VarNext,59)
          <=> v94(VarCurr,479) )
          & ( v508(VarNext,58)
          <=> v94(VarCurr,478) )
          & ( v508(VarNext,57)
          <=> v94(VarCurr,477) )
          & ( v508(VarNext,56)
          <=> v94(VarCurr,476) )
          & ( v508(VarNext,55)
          <=> v94(VarCurr,475) )
          & ( v508(VarNext,54)
          <=> v94(VarCurr,474) )
          & ( v508(VarNext,53)
          <=> v94(VarCurr,473) )
          & ( v508(VarNext,52)
          <=> v94(VarCurr,472) )
          & ( v508(VarNext,51)
          <=> v94(VarCurr,471) )
          & ( v508(VarNext,50)
          <=> v94(VarCurr,470) )
          & ( v508(VarNext,49)
          <=> v94(VarCurr,469) )
          & ( v508(VarNext,48)
          <=> v94(VarCurr,468) )
          & ( v508(VarNext,47)
          <=> v94(VarCurr,467) )
          & ( v508(VarNext,46)
          <=> v94(VarCurr,466) )
          & ( v508(VarNext,45)
          <=> v94(VarCurr,465) )
          & ( v508(VarNext,44)
          <=> v94(VarCurr,464) )
          & ( v508(VarNext,43)
          <=> v94(VarCurr,463) )
          & ( v508(VarNext,42)
          <=> v94(VarCurr,462) )
          & ( v508(VarNext,41)
          <=> v94(VarCurr,461) )
          & ( v508(VarNext,40)
          <=> v94(VarCurr,460) )
          & ( v508(VarNext,39)
          <=> v94(VarCurr,459) )
          & ( v508(VarNext,38)
          <=> v94(VarCurr,458) )
          & ( v508(VarNext,37)
          <=> v94(VarCurr,457) )
          & ( v508(VarNext,36)
          <=> v94(VarCurr,456) )
          & ( v508(VarNext,35)
          <=> v94(VarCurr,455) )
          & ( v508(VarNext,34)
          <=> v94(VarCurr,454) )
          & ( v508(VarNext,33)
          <=> v94(VarCurr,453) )
          & ( v508(VarNext,32)
          <=> v94(VarCurr,452) )
          & ( v508(VarNext,31)
          <=> v94(VarCurr,451) )
          & ( v508(VarNext,30)
          <=> v94(VarCurr,450) )
          & ( v508(VarNext,29)
          <=> v94(VarCurr,449) )
          & ( v508(VarNext,28)
          <=> v94(VarCurr,448) )
          & ( v508(VarNext,27)
          <=> v94(VarCurr,447) )
          & ( v508(VarNext,26)
          <=> v94(VarCurr,446) )
          & ( v508(VarNext,25)
          <=> v94(VarCurr,445) )
          & ( v508(VarNext,24)
          <=> v94(VarCurr,444) )
          & ( v508(VarNext,23)
          <=> v94(VarCurr,443) )
          & ( v508(VarNext,22)
          <=> v94(VarCurr,442) )
          & ( v508(VarNext,21)
          <=> v94(VarCurr,441) )
          & ( v508(VarNext,20)
          <=> v94(VarCurr,440) )
          & ( v508(VarNext,19)
          <=> v94(VarCurr,439) )
          & ( v508(VarNext,18)
          <=> v94(VarCurr,438) )
          & ( v508(VarNext,17)
          <=> v94(VarCurr,437) )
          & ( v508(VarNext,16)
          <=> v94(VarCurr,436) )
          & ( v508(VarNext,15)
          <=> v94(VarCurr,435) )
          & ( v508(VarNext,14)
          <=> v94(VarCurr,434) )
          & ( v508(VarNext,13)
          <=> v94(VarCurr,433) )
          & ( v508(VarNext,12)
          <=> v94(VarCurr,432) )
          & ( v508(VarNext,11)
          <=> v94(VarCurr,431) )
          & ( v508(VarNext,10)
          <=> v94(VarCurr,430) )
          & ( v508(VarNext,9)
          <=> v94(VarCurr,429) )
          & ( v508(VarNext,8)
          <=> v94(VarCurr,428) )
          & ( v508(VarNext,7)
          <=> v94(VarCurr,427) )
          & ( v508(VarNext,6)
          <=> v94(VarCurr,426) )
          & ( v508(VarNext,5)
          <=> v94(VarCurr,425) )
          & ( v508(VarNext,4)
          <=> v94(VarCurr,424) )
          & ( v508(VarNext,3)
          <=> v94(VarCurr,423) )
          & ( v508(VarNext,2)
          <=> v94(VarCurr,422) )
          & ( v508(VarNext,1)
          <=> v94(VarCurr,421) )
          & ( v508(VarNext,0)
          <=> v94(VarCurr,420) ) ) ) ) ).

tff(addCaseBooleanConditionEqualRanges0_15,axiom,
    ! [VarNext: state_type] :
      ( v510(VarNext)
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v508(VarNext,B)
          <=> v232(VarNext,B) ) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_78,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v510(VarNext)
      <=> ( v511(VarNext)
          & v213(VarNext) ) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_77,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v511(VarNext)
      <=> ( v513(VarNext)
          & v110(VarNext) ) ) ) ).

tff(writeUnaryOperator_33,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v513(VarNext)
      <=> v119(VarNext) ) ) ).

tff(addAssignment_144,axiom,
    ! [VarCurr: state_type,B: $int] :
      ( ( $less(B,70)
        & ~ $less(B,63) )
     => ( v197(VarCurr,B)
      <=> v202(VarCurr,B) ) ) ).

tff(addAssignment_143,axiom,
    ! [VarCurr: state_type] :
      ( ( v201(VarCurr,69)
      <=> v94(VarCurr,419) )
      & ( v201(VarCurr,68)
      <=> v94(VarCurr,418) )
      & ( v201(VarCurr,67)
      <=> v94(VarCurr,417) )
      & ( v201(VarCurr,66)
      <=> v94(VarCurr,416) )
      & ( v201(VarCurr,65)
      <=> v94(VarCurr,415) )
      & ( v201(VarCurr,64)
      <=> v94(VarCurr,414) )
      & ( v201(VarCurr,63)
      <=> v94(VarCurr,413) ) ) ).

tff(addAssignment_142,axiom,
    ! [VarCurr: state_type,B: $int] :
      ( ( $less(B,70)
        & ~ $less(B,63) )
     => ( v99(VarCurr,B)
      <=> v195(VarCurr,B) ) ) ).

tff(addAssignment_141,axiom,
    ! [VarCurr: state_type] :
      ( ( v178(VarCurr,69)
      <=> v94(VarCurr,489) )
      & ( v178(VarCurr,68)
      <=> v94(VarCurr,488) )
      & ( v178(VarCurr,67)
      <=> v94(VarCurr,487) )
      & ( v178(VarCurr,66)
      <=> v94(VarCurr,486) )
      & ( v178(VarCurr,65)
      <=> v94(VarCurr,485) )
      & ( v178(VarCurr,64)
      <=> v94(VarCurr,484) )
      & ( v178(VarCurr,63)
      <=> v94(VarCurr,483) ) ) ).

tff(addAssignment_140,axiom,
    ! [VarNext: state_type] :
      ( ( v94(VarNext,419)
      <=> v476(VarNext,69) )
      & ( v94(VarNext,418)
      <=> v476(VarNext,68) )
      & ( v94(VarNext,417)
      <=> v476(VarNext,67) )
      & ( v94(VarNext,416)
      <=> v476(VarNext,66) )
      & ( v94(VarNext,415)
      <=> v476(VarNext,65) )
      & ( v94(VarNext,414)
      <=> v476(VarNext,64) )
      & ( v94(VarNext,413)
      <=> v476(VarNext,63) ) ) ).

tff(addCaseBooleanConditionShiftedRanges1_5,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v477(VarNext)
       => ( ( v476(VarNext,69)
          <=> v94(VarCurr,419) )
          & ( v476(VarNext,68)
          <=> v94(VarCurr,418) )
          & ( v476(VarNext,67)
          <=> v94(VarCurr,417) )
          & ( v476(VarNext,66)
          <=> v94(VarCurr,416) )
          & ( v476(VarNext,65)
          <=> v94(VarCurr,415) )
          & ( v476(VarNext,64)
          <=> v94(VarCurr,414) )
          & ( v476(VarNext,63)
          <=> v94(VarCurr,413) )
          & ( v476(VarNext,62)
          <=> v94(VarCurr,412) )
          & ( v476(VarNext,61)
          <=> v94(VarCurr,411) )
          & ( v476(VarNext,60)
          <=> v94(VarCurr,410) )
          & ( v476(VarNext,59)
          <=> v94(VarCurr,409) )
          & ( v476(VarNext,58)
          <=> v94(VarCurr,408) )
          & ( v476(VarNext,57)
          <=> v94(VarCurr,407) )
          & ( v476(VarNext,56)
          <=> v94(VarCurr,406) )
          & ( v476(VarNext,55)
          <=> v94(VarCurr,405) )
          & ( v476(VarNext,54)
          <=> v94(VarCurr,404) )
          & ( v476(VarNext,53)
          <=> v94(VarCurr,403) )
          & ( v476(VarNext,52)
          <=> v94(VarCurr,402) )
          & ( v476(VarNext,51)
          <=> v94(VarCurr,401) )
          & ( v476(VarNext,50)
          <=> v94(VarCurr,400) )
          & ( v476(VarNext,49)
          <=> v94(VarCurr,399) )
          & ( v476(VarNext,48)
          <=> v94(VarCurr,398) )
          & ( v476(VarNext,47)
          <=> v94(VarCurr,397) )
          & ( v476(VarNext,46)
          <=> v94(VarCurr,396) )
          & ( v476(VarNext,45)
          <=> v94(VarCurr,395) )
          & ( v476(VarNext,44)
          <=> v94(VarCurr,394) )
          & ( v476(VarNext,43)
          <=> v94(VarCurr,393) )
          & ( v476(VarNext,42)
          <=> v94(VarCurr,392) )
          & ( v476(VarNext,41)
          <=> v94(VarCurr,391) )
          & ( v476(VarNext,40)
          <=> v94(VarCurr,390) )
          & ( v476(VarNext,39)
          <=> v94(VarCurr,389) )
          & ( v476(VarNext,38)
          <=> v94(VarCurr,388) )
          & ( v476(VarNext,37)
          <=> v94(VarCurr,387) )
          & ( v476(VarNext,36)
          <=> v94(VarCurr,386) )
          & ( v476(VarNext,35)
          <=> v94(VarCurr,385) )
          & ( v476(VarNext,34)
          <=> v94(VarCurr,384) )
          & ( v476(VarNext,33)
          <=> v94(VarCurr,383) )
          & ( v476(VarNext,32)
          <=> v94(VarCurr,382) )
          & ( v476(VarNext,31)
          <=> v94(VarCurr,381) )
          & ( v476(VarNext,30)
          <=> v94(VarCurr,380) )
          & ( v476(VarNext,29)
          <=> v94(VarCurr,379) )
          & ( v476(VarNext,28)
          <=> v94(VarCurr,378) )
          & ( v476(VarNext,27)
          <=> v94(VarCurr,377) )
          & ( v476(VarNext,26)
          <=> v94(VarCurr,376) )
          & ( v476(VarNext,25)
          <=> v94(VarCurr,375) )
          & ( v476(VarNext,24)
          <=> v94(VarCurr,374) )
          & ( v476(VarNext,23)
          <=> v94(VarCurr,373) )
          & ( v476(VarNext,22)
          <=> v94(VarCurr,372) )
          & ( v476(VarNext,21)
          <=> v94(VarCurr,371) )
          & ( v476(VarNext,20)
          <=> v94(VarCurr,370) )
          & ( v476(VarNext,19)
          <=> v94(VarCurr,369) )
          & ( v476(VarNext,18)
          <=> v94(VarCurr,368) )
          & ( v476(VarNext,17)
          <=> v94(VarCurr,367) )
          & ( v476(VarNext,16)
          <=> v94(VarCurr,366) )
          & ( v476(VarNext,15)
          <=> v94(VarCurr,365) )
          & ( v476(VarNext,14)
          <=> v94(VarCurr,364) )
          & ( v476(VarNext,13)
          <=> v94(VarCurr,363) )
          & ( v476(VarNext,12)
          <=> v94(VarCurr,362) )
          & ( v476(VarNext,11)
          <=> v94(VarCurr,361) )
          & ( v476(VarNext,10)
          <=> v94(VarCurr,360) )
          & ( v476(VarNext,9)
          <=> v94(VarCurr,359) )
          & ( v476(VarNext,8)
          <=> v94(VarCurr,358) )
          & ( v476(VarNext,7)
          <=> v94(VarCurr,357) )
          & ( v476(VarNext,6)
          <=> v94(VarCurr,356) )
          & ( v476(VarNext,5)
          <=> v94(VarCurr,355) )
          & ( v476(VarNext,4)
          <=> v94(VarCurr,354) )
          & ( v476(VarNext,3)
          <=> v94(VarCurr,353) )
          & ( v476(VarNext,2)
          <=> v94(VarCurr,352) )
          & ( v476(VarNext,1)
          <=> v94(VarCurr,351) )
          & ( v476(VarNext,0)
          <=> v94(VarCurr,350) ) ) ) ) ).

tff(addCaseBooleanConditionEqualRanges0_14,axiom,
    ! [VarNext: state_type] :
      ( v477(VarNext)
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v476(VarNext,B)
          <=> v503(VarNext,B) ) ) ) ).

tff(addAssignment_139,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v503(VarNext,B)
          <=> v501(VarCurr,B) ) ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges1_7,axiom,
    ! [VarCurr: state_type] :
      ( ~ v215(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v501(VarCurr,B)
          <=> v504(VarCurr,B) ) ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges0_4,axiom,
    ! [VarCurr: state_type] :
      ( v215(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v501(VarCurr,B)
          <=> $false ) ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges2_4,axiom,
    ! [VarCurr: state_type] :
      ( ( ~ v490(VarCurr)
        & ~ v492(VarCurr) )
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v504(VarCurr,B)
          <=> v469(VarCurr,B) ) ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges1_6,axiom,
    ! [VarCurr: state_type] :
      ( v492(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v504(VarCurr,B)
          <=> v462(VarCurr,B) ) ) ) ).

tff(addParallelCaseBooleanConditionShiftedRanges0_2,axiom,
    ! [VarCurr: state_type] :
      ( v490(VarCurr)
     => ( ( v504(VarCurr,69)
        <=> v94(VarCurr,349) )
        & ( v504(VarCurr,68)
        <=> v94(VarCurr,348) )
        & ( v504(VarCurr,67)
        <=> v94(VarCurr,347) )
        & ( v504(VarCurr,66)
        <=> v94(VarCurr,346) )
        & ( v504(VarCurr,65)
        <=> v94(VarCurr,345) )
        & ( v504(VarCurr,64)
        <=> v94(VarCurr,344) )
        & ( v504(VarCurr,63)
        <=> v94(VarCurr,343) )
        & ( v504(VarCurr,62)
        <=> v94(VarCurr,342) )
        & ( v504(VarCurr,61)
        <=> v94(VarCurr,341) )
        & ( v504(VarCurr,60)
        <=> v94(VarCurr,340) )
        & ( v504(VarCurr,59)
        <=> v94(VarCurr,339) )
        & ( v504(VarCurr,58)
        <=> v94(VarCurr,338) )
        & ( v504(VarCurr,57)
        <=> v94(VarCurr,337) )
        & ( v504(VarCurr,56)
        <=> v94(VarCurr,336) )
        & ( v504(VarCurr,55)
        <=> v94(VarCurr,335) )
        & ( v504(VarCurr,54)
        <=> v94(VarCurr,334) )
        & ( v504(VarCurr,53)
        <=> v94(VarCurr,333) )
        & ( v504(VarCurr,52)
        <=> v94(VarCurr,332) )
        & ( v504(VarCurr,51)
        <=> v94(VarCurr,331) )
        & ( v504(VarCurr,50)
        <=> v94(VarCurr,330) )
        & ( v504(VarCurr,49)
        <=> v94(VarCurr,329) )
        & ( v504(VarCurr,48)
        <=> v94(VarCurr,328) )
        & ( v504(VarCurr,47)
        <=> v94(VarCurr,327) )
        & ( v504(VarCurr,46)
        <=> v94(VarCurr,326) )
        & ( v504(VarCurr,45)
        <=> v94(VarCurr,325) )
        & ( v504(VarCurr,44)
        <=> v94(VarCurr,324) )
        & ( v504(VarCurr,43)
        <=> v94(VarCurr,323) )
        & ( v504(VarCurr,42)
        <=> v94(VarCurr,322) )
        & ( v504(VarCurr,41)
        <=> v94(VarCurr,321) )
        & ( v504(VarCurr,40)
        <=> v94(VarCurr,320) )
        & ( v504(VarCurr,39)
        <=> v94(VarCurr,319) )
        & ( v504(VarCurr,38)
        <=> v94(VarCurr,318) )
        & ( v504(VarCurr,37)
        <=> v94(VarCurr,317) )
        & ( v504(VarCurr,36)
        <=> v94(VarCurr,316) )
        & ( v504(VarCurr,35)
        <=> v94(VarCurr,315) )
        & ( v504(VarCurr,34)
        <=> v94(VarCurr,314) )
        & ( v504(VarCurr,33)
        <=> v94(VarCurr,313) )
        & ( v504(VarCurr,32)
        <=> v94(VarCurr,312) )
        & ( v504(VarCurr,31)
        <=> v94(VarCurr,311) )
        & ( v504(VarCurr,30)
        <=> v94(VarCurr,310) )
        & ( v504(VarCurr,29)
        <=> v94(VarCurr,309) )
        & ( v504(VarCurr,28)
        <=> v94(VarCurr,308) )
        & ( v504(VarCurr,27)
        <=> v94(VarCurr,307) )
        & ( v504(VarCurr,26)
        <=> v94(VarCurr,306) )
        & ( v504(VarCurr,25)
        <=> v94(VarCurr,305) )
        & ( v504(VarCurr,24)
        <=> v94(VarCurr,304) )
        & ( v504(VarCurr,23)
        <=> v94(VarCurr,303) )
        & ( v504(VarCurr,22)
        <=> v94(VarCurr,302) )
        & ( v504(VarCurr,21)
        <=> v94(VarCurr,301) )
        & ( v504(VarCurr,20)
        <=> v94(VarCurr,300) )
        & ( v504(VarCurr,19)
        <=> v94(VarCurr,299) )
        & ( v504(VarCurr,18)
        <=> v94(VarCurr,298) )
        & ( v504(VarCurr,17)
        <=> v94(VarCurr,297) )
        & ( v504(VarCurr,16)
        <=> v94(VarCurr,296) )
        & ( v504(VarCurr,15)
        <=> v94(VarCurr,295) )
        & ( v504(VarCurr,14)
        <=> v94(VarCurr,294) )
        & ( v504(VarCurr,13)
        <=> v94(VarCurr,293) )
        & ( v504(VarCurr,12)
        <=> v94(VarCurr,292) )
        & ( v504(VarCurr,11)
        <=> v94(VarCurr,291) )
        & ( v504(VarCurr,10)
        <=> v94(VarCurr,290) )
        & ( v504(VarCurr,9)
        <=> v94(VarCurr,289) )
        & ( v504(VarCurr,8)
        <=> v94(VarCurr,288) )
        & ( v504(VarCurr,7)
        <=> v94(VarCurr,287) )
        & ( v504(VarCurr,6)
        <=> v94(VarCurr,286) )
        & ( v504(VarCurr,5)
        <=> v94(VarCurr,285) )
        & ( v504(VarCurr,4)
        <=> v94(VarCurr,284) )
        & ( v504(VarCurr,3)
        <=> v94(VarCurr,283) )
        & ( v504(VarCurr,2)
        <=> v94(VarCurr,282) )
        & ( v504(VarCurr,1)
        <=> v94(VarCurr,281) )
        & ( v504(VarCurr,0)
        <=> v94(VarCurr,280) ) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_76,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v477(VarNext)
      <=> ( v478(VarNext)
          & v485(VarNext) ) ) ) ).

tff(addAssignment_138,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v485(VarNext)
      <=> v483(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_75,axiom,
    ! [VarCurr: state_type] :
      ( v483(VarCurr)
    <=> ( v486(VarCurr)
        & v497(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_74,axiom,
    ! [VarCurr: state_type] :
      ( v497(VarCurr)
    <=> ( v498(VarCurr)
        | v215(VarCurr) ) ) ).

tff(writeUnaryOperator_32,axiom,
    ! [VarCurr: state_type] :
      ( ~ v498(VarCurr)
    <=> v499(VarCurr) ) ).

tff(addBitVectorEqualityBitBlasted_30,axiom,
    ! [VarCurr: state_type] :
      ( v499(VarCurr)
    <=> ( ( v500(VarCurr,1)
        <=> $false )
        & ( v500(VarCurr,0)
        <=> $false ) ) ) ).

tff(addAssignment_137,axiom,
    ! [VarCurr: state_type] :
      ( v500(VarCurr,0)
    <=> v43(VarCurr) ) ).

tff(addAssignment_136,axiom,
    ! [VarCurr: state_type] :
      ( v500(VarCurr,1)
    <=> v36(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_73,axiom,
    ! [VarCurr: state_type] :
      ( v486(VarCurr)
    <=> ( v215(VarCurr)
        | v487(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_72,axiom,
    ! [VarCurr: state_type] :
      ( v487(VarCurr)
    <=> ( v488(VarCurr)
        & v496(VarCurr) ) ) ).

tff(writeUnaryOperator_31,axiom,
    ! [VarCurr: state_type] :
      ( ~ v496(VarCurr)
    <=> v215(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_71,axiom,
    ! [VarCurr: state_type] :
      ( v488(VarCurr)
    <=> ( v489(VarCurr)
        | v494(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_29,axiom,
    ! [VarCurr: state_type] :
      ( v494(VarCurr)
    <=> ( ( v495(VarCurr,1)
        <=> $true )
        & ( v495(VarCurr,0)
        <=> $true ) ) ) ).

tff(addAssignment_135,axiom,
    ! [VarCurr: state_type] :
      ( v495(VarCurr,0)
    <=> v43(VarCurr) ) ).

tff(addAssignment_134,axiom,
    ! [VarCurr: state_type] :
      ( v495(VarCurr,1)
    <=> v36(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_70,axiom,
    ! [VarCurr: state_type] :
      ( v489(VarCurr)
    <=> ( v490(VarCurr)
        | v492(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_28,axiom,
    ! [VarCurr: state_type] :
      ( v492(VarCurr)
    <=> ( ( v493(VarCurr,1)
        <=> $true )
        & ( v493(VarCurr,0)
        <=> $false ) ) ) ).

tff(addAssignment_133,axiom,
    ! [VarCurr: state_type] :
      ( v493(VarCurr,0)
    <=> v43(VarCurr) ) ).

tff(addAssignment_132,axiom,
    ! [VarCurr: state_type] :
      ( v493(VarCurr,1)
    <=> v36(VarCurr) ) ).

tff(addBitVectorEqualityBitBlasted_27,axiom,
    ! [VarCurr: state_type] :
      ( v490(VarCurr)
    <=> ( ( v491(VarCurr,1)
        <=> $false )
        & ( v491(VarCurr,0)
        <=> $true ) ) ) ).

tff(addAssignment_131,axiom,
    ! [VarCurr: state_type] :
      ( v491(VarCurr,0)
    <=> v43(VarCurr) ) ).

tff(addAssignment_130,axiom,
    ! [VarCurr: state_type] :
      ( v491(VarCurr,1)
    <=> v36(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_69,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v478(VarNext)
      <=> ( v480(VarNext)
          & v110(VarNext) ) ) ) ).

tff(writeUnaryOperator_30,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v480(VarNext)
      <=> v119(VarNext) ) ) ).

tff(addAssignment_129,axiom,
    ! [VarCurr: state_type,B: $int] :
      ( ( $less(B,70)
        & ~ $less(B,63) )
     => ( v469(VarCurr,B)
      <=> v474(VarCurr,B) ) ) ).

tff(aaddConditionBooleanCondEqualRangesElseBranch_17,axiom,
    ! [VarCurr: state_type] :
      ( ~ v471(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v474(VarCurr,B)
          <=> v473(VarCurr,B) ) ) ) ).

tff(addConditionBooleanCondEqualRangesThenBranch_18,axiom,
    ! [VarCurr: state_type] :
      ( v471(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v474(VarCurr,B)
          <=> v172(VarCurr,B) ) ) ) ).

tff(addAssignment_128,axiom,
    ! [VarCurr: state_type] :
      ( ( v473(VarCurr,69)
      <=> v94(VarCurr,349) )
      & ( v473(VarCurr,68)
      <=> v94(VarCurr,348) )
      & ( v473(VarCurr,67)
      <=> v94(VarCurr,347) )
      & ( v473(VarCurr,66)
      <=> v94(VarCurr,346) )
      & ( v473(VarCurr,65)
      <=> v94(VarCurr,345) )
      & ( v473(VarCurr,64)
      <=> v94(VarCurr,344) )
      & ( v473(VarCurr,63)
      <=> v94(VarCurr,343) ) ) ).

tff(addAssignment_127,axiom,
    ! [VarCurr: state_type] :
      ( v471(VarCurr)
    <=> v103(VarCurr,3) ) ).

tff(addAssignment_126,axiom,
    ! [VarCurr: state_type,B: $int] :
      ( ( $less(B,70)
        & ~ $less(B,63) )
     => ( v462(VarCurr,B)
      <=> v467(VarCurr,B) ) ) ).

tff(aaddConditionBooleanCondEqualRangesElseBranch_16,axiom,
    ! [VarCurr: state_type] :
      ( ~ v464(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v467(VarCurr,B)
          <=> v466(VarCurr,B) ) ) ) ).

tff(addConditionBooleanCondEqualRangesThenBranch_17,axiom,
    ! [VarCurr: state_type] :
      ( v464(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v467(VarCurr,B)
          <=> v172(VarCurr,B) ) ) ) ).

tff(addAssignment_125,axiom,
    ! [VarCurr: state_type] :
      ( ( v466(VarCurr,69)
      <=> v94(VarCurr,419) )
      & ( v466(VarCurr,68)
      <=> v94(VarCurr,418) )
      & ( v466(VarCurr,67)
      <=> v94(VarCurr,417) )
      & ( v466(VarCurr,66)
      <=> v94(VarCurr,416) )
      & ( v466(VarCurr,65)
      <=> v94(VarCurr,415) )
      & ( v466(VarCurr,64)
      <=> v94(VarCurr,414) )
      & ( v466(VarCurr,63)
      <=> v94(VarCurr,413) ) ) ).

tff(addAssignment_124,axiom,
    ! [VarCurr: state_type,B: $int] :
      ( ( $less(B,70)
        & ~ $less(B,63) )
     => ( v172(VarCurr,B)
      <=> v174(VarCurr,B) ) ) ).

tff(addAssignment_123,axiom,
    ! [VarCurr: state_type,B: $int] :
      ( ( $less(B,70)
        & ~ $less(B,63) )
     => ( v174(VarCurr,B)
      <=> v176(VarCurr,B) ) ) ).

tff(addAssignment_122,axiom,
    ! [VarCurr: state_type] :
      ( v464(VarCurr)
    <=> v103(VarCurr,3) ) ).

tff(addAssignment_121,axiom,
    ! [VarCurr: state_type] :
      ( v30(VarCurr)
    <=> v32(VarCurr) ) ).

tff(addCaseBooleanConditionEqualRanges1_8,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v437(VarNext)
       => ( v32(VarNext)
        <=> v32(VarCurr) ) ) ) ).

tff(addCaseBooleanConditionEqualRanges0_13,axiom,
    ! [VarNext: state_type] :
      ( v437(VarNext)
     => ( v32(VarNext)
      <=> v455(VarNext) ) ) ).

tff(addAssignment_120,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v455(VarNext)
      <=> v453(VarCurr) ) ) ).

tff(aaddConditionBooleanCondEqualRangesElseBranch_15,axiom,
    ! [VarCurr: state_type] :
      ( ~ v452(VarCurr)
     => ( v453(VarCurr)
      <=> v456(VarCurr) ) ) ).

tff(addConditionBooleanCondEqualRangesThenBranch_16,axiom,
    ! [VarCurr: state_type] :
      ( v452(VarCurr)
     => ( v453(VarCurr)
      <=> $true ) ) ).

tff(aaddConditionBooleanCondEqualRangesElseBranch_14,axiom,
    ! [VarCurr: state_type] :
      ( ~ v36(VarCurr)
     => ( v456(VarCurr)
      <=> $true ) ) ).

tff(addConditionBooleanCondEqualRangesThenBranch_15,axiom,
    ! [VarCurr: state_type] :
      ( v36(VarCurr)
     => ( v456(VarCurr)
      <=> $false ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_68,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v437(VarNext)
      <=> ( v438(VarNext)
          & v445(VarNext) ) ) ) ).

tff(addAssignment_119,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v445(VarNext)
      <=> v443(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_67,axiom,
    ! [VarCurr: state_type] :
      ( v443(VarCurr)
    <=> ( v446(VarCurr)
        | v452(VarCurr) ) ) ).

tff(writeUnaryOperator_29,axiom,
    ! [VarCurr: state_type] :
      ( ~ v452(VarCurr)
    <=> v34(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_66,axiom,
    ! [VarCurr: state_type] :
      ( v446(VarCurr)
    <=> ( v447(VarCurr)
        | v36(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_65,axiom,
    ! [VarCurr: state_type] :
      ( v447(VarCurr)
    <=> ( v448(VarCurr)
        & v451(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_26,axiom,
    ! [VarCurr: state_type] :
      ( v451(VarCurr)
    <=> ( v105(VarCurr,0)
      <=> $true ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_64,axiom,
    ! [VarCurr: state_type] :
      ( v448(VarCurr)
    <=> ( v449(VarCurr)
        & v450(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_25,axiom,
    ! [VarCurr: state_type] :
      ( v450(VarCurr)
    <=> ( v382(VarCurr,1)
      <=> $false ) ) ).

tff(addBitVectorEqualityBitBlasted_24,axiom,
    ! [VarCurr: state_type] :
      ( v449(VarCurr)
    <=> ( v43(VarCurr)
      <=> $true ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_63,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v438(VarNext)
      <=> ( v439(VarNext)
          & v110(VarNext) ) ) ) ).

tff(writeUnaryOperator_28,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v439(VarNext)
      <=> v119(VarNext) ) ) ).

tff(addAssignment_118,axiom,
    ! [VarCurr: state_type] :
      ( v105(VarCurr,0)
    <=> v129(VarCurr,0) ) ).

tff(addAssignment_117,axiom,
    ! [VarNext: state_type] :
      ( v382(VarNext,1)
    <=> v428(VarNext,1) ) ).

tff(addCaseBooleanConditionEqualRanges1_7,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v429(VarNext)
       => ! [B: $int] :
            ( ( $less(B,8)
              & ~ $less(B,0) )
           => ( v428(VarNext,B)
            <=> v382(VarCurr,B) ) ) ) ) ).

tff(addCaseBooleanConditionEqualRanges0_12,axiom,
    ! [VarNext: state_type] :
      ( v429(VarNext)
     => ! [B: $int] :
          ( ( $less(B,8)
            & ~ $less(B,0) )
         => ( v428(VarNext,B)
          <=> v416(VarNext,B) ) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_62,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v429(VarNext)
      <=> v430(VarNext) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_61,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v430(VarNext)
      <=> ( v432(VarNext)
          & v110(VarNext) ) ) ) ).

tff(writeUnaryOperator_27,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v432(VarNext)
      <=> v119(VarNext) ) ) ).

tff(addAssignment_116,axiom,
    ! [VarCurr: state_type] :
      ( v385(VarCurr,1)
    <=> v392(VarCurr,1) ) ).

tff(addAssignment_115,axiom,
    ! [VarCurr: state_type] :
      ( v387(VarCurr,1)
    <=> v388(VarCurr,1) ) ).

tff(addAssignment_114,axiom,
    ! [VarNext: state_type] :
      ( v382(VarNext,0)
    <=> v420(VarNext,0) ) ).

tff(addCaseBooleanConditionEqualRanges1_6,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v421(VarNext)
       => ! [B: $int] :
            ( ( $less(B,8)
              & ~ $less(B,0) )
           => ( v420(VarNext,B)
            <=> v382(VarCurr,B) ) ) ) ) ).

tff(addCaseBooleanConditionEqualRanges0_11,axiom,
    ! [VarNext: state_type] :
      ( v421(VarNext)
     => ! [B: $int] :
          ( ( $less(B,8)
            & ~ $less(B,0) )
         => ( v420(VarNext,B)
          <=> v416(VarNext,B) ) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_60,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v421(VarNext)
      <=> v422(VarNext) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_59,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v422(VarNext)
      <=> ( v424(VarNext)
          & v110(VarNext) ) ) ) ).

tff(writeUnaryOperator_26,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v424(VarNext)
      <=> v119(VarNext) ) ) ).

tff(addAssignment_113,axiom,
    ! [VarCurr: state_type] :
      ( v385(VarCurr,0)
    <=> v392(VarCurr,0) ) ).

tff(addAssignment_112,axiom,
    ! [VarNext: state_type] :
      ( v382(VarNext,2)
    <=> v407(VarNext,2) ) ).

tff(addCaseBooleanConditionEqualRanges1_5,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v408(VarNext)
       => ! [B: $int] :
            ( ( $less(B,8)
              & ~ $less(B,0) )
           => ( v407(VarNext,B)
            <=> v382(VarCurr,B) ) ) ) ) ).

tff(addCaseBooleanConditionEqualRanges0_10,axiom,
    ! [VarNext: state_type] :
      ( v408(VarNext)
     => ! [B: $int] :
          ( ( $less(B,8)
            & ~ $less(B,0) )
         => ( v407(VarNext,B)
          <=> v416(VarNext,B) ) ) ) ).

tff(addAssignment_111,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ! [B: $int] :
          ( ( $less(B,8)
            & ~ $less(B,0) )
         => ( v416(VarNext,B)
          <=> v414(VarCurr,B) ) ) ) ).

tff(aaddConditionBooleanCondEqualRangesElseBranch_13,axiom,
    ! [VarCurr: state_type] :
      ( ~ v126(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,8)
            & ~ $less(B,0) )
         => ( v414(VarCurr,B)
          <=> v385(VarCurr,B) ) ) ) ).

tff(addConditionBooleanCondEqualRangesThenBranch_14,axiom,
    ! [VarCurr: state_type] :
      ( v126(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,8)
            & ~ $less(B,0) )
         => ( v414(VarCurr,B)
          <=> $false ) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_58,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v408(VarNext)
      <=> v409(VarNext) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_57,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v409(VarNext)
      <=> ( v411(VarNext)
          & v110(VarNext) ) ) ) ).

tff(writeUnaryOperator_25,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v411(VarNext)
      <=> v119(VarNext) ) ) ).

tff(addAssignment_110,axiom,
    ! [VarCurr: state_type] :
      ( v385(VarCurr,2)
    <=> v392(VarCurr,2) ) ).

tff(aaddConditionBooleanCondEqualRangesElseBranch_12,axiom,
    ! [VarCurr: state_type] :
      ( ~ v393(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,8)
            & ~ $less(B,0) )
         => ( v392(VarCurr,B)
          <=> v394(VarCurr,B) ) ) ) ).

tff(addConditionBooleanCondEqualRangesThenBranch_13,axiom,
    ! [VarCurr: state_type] :
      ( v393(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,8)
            & ~ $less(B,0) )
         => ( v392(VarCurr,B)
          <=> $false ) ) ) ).

tff(bitBlastConstant_170,axiom,
    ~ b00000000(7) ).

tff(bitBlastConstant_169,axiom,
    ~ b00000000(6) ).

tff(bitBlastConstant_168,axiom,
    ~ b00000000(5) ).

tff(bitBlastConstant_167,axiom,
    ~ b00000000(4) ).

tff(bitBlastConstant_166,axiom,
    ~ b00000000(3) ).

tff(bitBlastConstant_165,axiom,
    ~ b00000000(2) ).

tff(bitBlastConstant_164,axiom,
    ~ b00000000(1) ).

tff(bitBlastConstant_163,axiom,
    ~ b00000000(0) ).

tff(addParallelCaseBooleanConditionEqualRanges3_1,axiom,
    ! [VarCurr: state_type] :
      ( ( ~ v395(VarCurr)
        & ~ v397(VarCurr)
        & ~ v401(VarCurr) )
     => ! [B: $int] :
          ( ( $less(B,8)
            & ~ $less(B,0) )
         => ( v394(VarCurr,B)
          <=> v382(VarCurr,B) ) ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges2_3,axiom,
    ! [VarCurr: state_type] :
      ( v401(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,8)
            & ~ $less(B,0) )
         => ( v394(VarCurr,B)
          <=> v403(VarCurr,B) ) ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges1_5,axiom,
    ! [VarCurr: state_type] :
      ( v397(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,8)
            & ~ $less(B,0) )
         => ( v394(VarCurr,B)
          <=> v399(VarCurr,B) ) ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges0_3,axiom,
    ! [VarCurr: state_type] :
      ( v395(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,8)
            & ~ $less(B,0) )
         => ( v394(VarCurr,B)
          <=> v382(VarCurr,B) ) ) ) ).

tff(addBitVectorEqualityBitBlasted_23,axiom,
    ! [VarCurr: state_type] :
      ( v404(VarCurr)
    <=> ( ( v405(VarCurr,1)
        <=> $true )
        & ( v405(VarCurr,0)
        <=> $true ) ) ) ).

tff(addAssignment_109,axiom,
    ! [VarCurr: state_type] :
      ( v405(VarCurr,0)
    <=> v43(VarCurr) ) ).

tff(addAssignment_108,axiom,
    ! [VarCurr: state_type] :
      ( v405(VarCurr,1)
    <=> v36(VarCurr) ) ).

tff(addAssignment_107,axiom,
    ! [VarCurr: state_type] :
      ( v403(VarCurr,0)
    <=> $true ) ).

tff(addAssignment_106,axiom,
    ! [VarCurr: state_type,B: $int] :
      ( ( $less(B,8)
        & ~ $less(B,1) )
     => ( v403(VarCurr,B)
      <=> v387(VarCurr,B) ) ) ).

tff(addBitVectorEqualityBitBlasted_22,axiom,
    ! [VarCurr: state_type] :
      ( v401(VarCurr)
    <=> ( ( v402(VarCurr,1)
        <=> $true )
        & ( v402(VarCurr,0)
        <=> $false ) ) ) ).

tff(addAssignment_105,axiom,
    ! [VarCurr: state_type] :
      ( v402(VarCurr,0)
    <=> v43(VarCurr) ) ).

tff(addAssignment_104,axiom,
    ! [VarCurr: state_type] :
      ( v402(VarCurr,1)
    <=> v36(VarCurr) ) ).

tff(addAssignment_103,axiom,
    ! [VarCurr: state_type] :
      ( ( v399(VarCurr,6)
      <=> v382(VarCurr,7) )
      & ( v399(VarCurr,5)
      <=> v382(VarCurr,6) )
      & ( v399(VarCurr,4)
      <=> v382(VarCurr,5) )
      & ( v399(VarCurr,3)
      <=> v382(VarCurr,4) )
      & ( v399(VarCurr,2)
      <=> v382(VarCurr,3) )
      & ( v399(VarCurr,1)
      <=> v382(VarCurr,2) )
      & ( v399(VarCurr,0)
      <=> v382(VarCurr,1) ) ) ).

tff(addAssignment_102,axiom,
    ! [VarCurr: state_type] :
      ( v399(VarCurr,7)
    <=> $false ) ).

tff(addBitVectorEqualityBitBlasted_21,axiom,
    ! [VarCurr: state_type] :
      ( v397(VarCurr)
    <=> ( ( v398(VarCurr,1)
        <=> $false )
        & ( v398(VarCurr,0)
        <=> $true ) ) ) ).

tff(addAssignment_101,axiom,
    ! [VarCurr: state_type] :
      ( v398(VarCurr,0)
    <=> v43(VarCurr) ) ).

tff(addAssignment_100,axiom,
    ! [VarCurr: state_type] :
      ( v398(VarCurr,1)
    <=> v36(VarCurr) ) ).

tff(addBitVectorEqualityBitBlasted_20,axiom,
    ! [VarCurr: state_type] :
      ( v395(VarCurr)
    <=> ( ( v396(VarCurr,1)
        <=> $false )
        & ( v396(VarCurr,0)
        <=> $false ) ) ) ).

tff(addAssignment_99,axiom,
    ! [VarCurr: state_type] :
      ( v396(VarCurr,0)
    <=> v43(VarCurr) ) ).

tff(addAssignment_98,axiom,
    ! [VarCurr: state_type] :
      ( v396(VarCurr,1)
    <=> v36(VarCurr) ) ).

tff(writeUnaryOperator_24,axiom,
    ! [VarCurr: state_type] :
      ( ~ v393(VarCurr)
    <=> v34(VarCurr) ) ).

tff(addAssignment_97,axiom,
    ! [VarCurr: state_type] :
      ( v387(VarCurr,2)
    <=> v388(VarCurr,2) ) ).

tff(addAssignment_96,axiom,
    ! [VarCurr: state_type] :
      ( v388(VarCurr,0)
    <=> $false ) ).

tff(addAssignment_95,axiom,
    ! [VarCurr: state_type] :
      ( ( v388(VarCurr,7)
      <=> v382(VarCurr,6) )
      & ( v388(VarCurr,6)
      <=> v382(VarCurr,5) )
      & ( v388(VarCurr,5)
      <=> v382(VarCurr,4) )
      & ( v388(VarCurr,4)
      <=> v382(VarCurr,3) )
      & ( v388(VarCurr,3)
      <=> v382(VarCurr,2) )
      & ( v388(VarCurr,2)
      <=> v382(VarCurr,1) )
      & ( v388(VarCurr,1)
      <=> v382(VarCurr,0) ) ) ).

tff(addAssignmentInitValue_81,axiom,
    ~ v382(constB0,6) ).

tff(addAssignmentInitValue_80,axiom,
    ~ v382(constB0,5) ).

tff(addAssignmentInitValue_79,axiom,
    ~ v382(constB0,4) ).

tff(addAssignmentInitValue_78,axiom,
    ~ v382(constB0,3) ).

tff(addAssignmentInitValue_77,axiom,
    ~ v382(constB0,2) ).

tff(addAssignmentInitValue_76,axiom,
    ~ v382(constB0,1) ).

tff(addAssignmentInitValue_75,axiom,
    ~ v382(constB0,0) ).

tff(bitBlastConstant_162,axiom,
    ~ bx0000000(6) ).

tff(bitBlastConstant_161,axiom,
    ~ bx0000000(5) ).

tff(bitBlastConstant_160,axiom,
    ~ bx0000000(4) ).

tff(bitBlastConstant_159,axiom,
    ~ bx0000000(3) ).

tff(bitBlastConstant_158,axiom,
    ~ bx0000000(2) ).

tff(bitBlastConstant_157,axiom,
    ~ bx0000000(1) ).

tff(bitBlastConstant_156,axiom,
    ~ bx0000000(0) ).

tff(addAssignment_94,axiom,
    ! [VarCurr: state_type] :
      ( v43(VarCurr)
    <=> v45(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_56,axiom,
    ! [VarCurr: state_type] :
      ( v45(VarCurr)
    <=> ( v380(VarCurr)
        | v374(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_55,axiom,
    ! [VarCurr: state_type] :
      ( v380(VarCurr)
    <=> ( v47(VarCurr)
        | v56(VarCurr) ) ) ).

tff(aaddConditionBooleanCondEqualRangesElseBranch_11,axiom,
    ! [VarCurr: state_type] :
      ( ~ v376(VarCurr)
     => ( v374(VarCurr)
      <=> $false ) ) ).

tff(addConditionBooleanCondEqualRangesThenBranch_12,axiom,
    ! [VarCurr: state_type] :
      ( v376(VarCurr)
     => ( v374(VarCurr)
      <=> $true ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_54,axiom,
    ! [VarCurr: state_type] :
      ( v376(VarCurr)
    <=> ( v377(VarCurr)
        & v54(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_53,axiom,
    ! [VarCurr: state_type] :
      ( v377(VarCurr)
    <=> ( v378(VarCurr)
        & v53(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_19,axiom,
    ! [VarCurr: state_type] :
      ( v378(VarCurr)
    <=> ( ( v28(VarCurr,1)
        <=> $false )
        & ( v28(VarCurr,0)
        <=> $true ) ) ) ).

tff(addAssignment_93,axiom,
    ! [VarCurr: state_type] :
      ( v56(VarCurr)
    <=> v58(VarCurr) ) ).

tff(addAssignment_92,axiom,
    ! [VarCurr: state_type] :
      ( v58(VarCurr)
    <=> v60(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_52,axiom,
    ! [VarCurr: state_type] :
      ( v60(VarCurr)
    <=> ( v372(VarCurr)
        & v284(VarCurr) ) ) ).

tff(writeBinaryOperatorShiftedRanges,axiom,
    ! [VarCurr: state_type] :
      ( v372(VarCurr)
    <=> ( v62(VarCurr,2)
        | v62(VarCurr,1) ) ) ).

tff(addAssignment_91,axiom,
    ! [VarNext: state_type] :
      ( v62(VarNext,2)
    <=> v364(VarNext,1) ) ).

tff(addCaseBooleanConditionShiftedRanges1_4,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v365(VarNext)
       => ( ( v364(VarNext,2)
          <=> v62(VarCurr,3) )
          & ( v364(VarNext,1)
          <=> v62(VarCurr,2) )
          & ( v364(VarNext,0)
          <=> v62(VarCurr,1) ) ) ) ) ).

tff(addCaseBooleanConditionEqualRanges0_9,axiom,
    ! [VarNext: state_type] :
      ( v365(VarNext)
     => ! [B: $int] :
          ( ( $less(B,3)
            & ~ $less(B,0) )
         => ( v364(VarNext,B)
          <=> v308(VarNext,B) ) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_51,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v365(VarNext)
      <=> v366(VarNext) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_50,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v366(VarNext)
      <=> ( v368(VarNext)
          & v295(VarNext) ) ) ) ).

tff(writeUnaryOperator_23,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v368(VarNext)
      <=> v302(VarNext) ) ) ).

tff(addConditionBooleanCondShiftedRangesElseBranch_3,axiom,
    ! [VarCurr: state_type] :
      ( ~ v356(VarCurr)
     => ( v67(VarCurr,2)
      <=> $false ) ) ).

tff(addConditionBooleanCondShiftedRangesThenBranch_2,axiom,
    ! [VarCurr: state_type] :
      ( v356(VarCurr)
     => ( v67(VarCurr,2)
      <=> $true ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_49,axiom,
    ! [VarCurr: state_type] :
      ( v356(VarCurr)
    <=> ( v357(VarCurr)
        | v361(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_48,axiom,
    ! [VarCurr: state_type] :
      ( v361(VarCurr)
    <=> ( v362(VarCurr)
        & v290(VarCurr) ) ) ).

tff(writeUnaryOperator_22,axiom,
    ! [VarCurr: state_type] :
      ( ~ v362(VarCurr)
    <=> v284(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_47,axiom,
    ! [VarCurr: state_type] :
      ( v357(VarCurr)
    <=> ( v358(VarCurr)
        & v317(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_46,axiom,
    ! [VarCurr: state_type] :
      ( v358(VarCurr)
    <=> ( v69(VarCurr)
        & v360(VarCurr) ) ) ).

tff(writeUnaryOperator_21,axiom,
    ! [VarCurr: state_type] :
      ( ~ v360(VarCurr)
    <=> v82(VarCurr) ) ).

tff(addAssignment_90,axiom,
    ! [VarCurr: state_type] :
      ( v69(VarCurr)
    <=> v71(VarCurr) ) ).

tff(addAssignment_89,axiom,
    ! [VarCurr: state_type] :
      ( v71(VarCurr)
    <=> v73(VarCurr) ) ).

tff(aaddConditionBooleanCondEqualRangesElseBranch_10,axiom,
    ! [VarCurr: state_type] :
      ( ~ v351(VarCurr)
     => ( v73(VarCurr)
      <=> $false ) ) ).

tff(addConditionBooleanCondEqualRangesThenBranch_11,axiom,
    ! [VarCurr: state_type] :
      ( v351(VarCurr)
     => ( v73(VarCurr)
      <=> v354(VarCurr) ) ) ).

tff(aaddConditionBooleanCondEqualRangesElseBranch_9,axiom,
    ! [VarCurr: state_type] :
      ( ~ v76(VarCurr)
     => ( v354(VarCurr)
      <=> $false ) ) ).

tff(addConditionBooleanCondEqualRangesThenBranch_10,axiom,
    ! [VarCurr: state_type] :
      ( v76(VarCurr)
     => ( v354(VarCurr)
      <=> $true ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_45,axiom,
    ! [VarCurr: state_type] :
      ( v351(VarCurr)
    <=> ( v352(VarCurr)
        & v54(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_44,axiom,
    ! [VarCurr: state_type] :
      ( v352(VarCurr)
    <=> ( v353(VarCurr)
        & v53(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_18,axiom,
    ! [VarCurr: state_type] :
      ( v353(VarCurr)
    <=> ( ( v28(VarCurr,1)
        <=> $true )
        & ( v28(VarCurr,0)
        <=> $false ) ) ) ).

tff(addAssignment_88,axiom,
    ! [VarCurr: state_type] :
      ( v76(VarCurr)
    <=> v78(VarCurr) ) ).

tff(addAssignment_87,axiom,
    ! [VarCurr: state_type] :
      ( v78(VarCurr)
    <=> v80(VarCurr) ) ).

tff(addAssignment_86,axiom,
    ! [VarCurr: state_type] :
      ( v80(VarCurr)
    <=> v62(VarCurr,0) ) ).

tff(addCaseBooleanConditionEqualRanges1_4,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v339(VarNext)
       => ( v62(VarNext,0)
        <=> v62(VarCurr,0) ) ) ) ).

tff(addCaseBooleanConditionEqualRanges0_8,axiom,
    ! [VarNext: state_type] :
      ( v339(VarNext)
     => ( v62(VarNext,0)
      <=> v347(VarNext) ) ) ).

tff(addAssignment_85,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v347(VarNext)
      <=> v345(VarCurr) ) ) ).

tff(aaddConditionBooleanCondEqualRangesElseBranch_8,axiom,
    ! [VarCurr: state_type] :
      ( ~ v309(VarCurr)
     => ( v345(VarCurr)
      <=> v67(VarCurr,0) ) ) ).

tff(addConditionBooleanCondEqualRangesThenBranch_9,axiom,
    ! [VarCurr: state_type] :
      ( v309(VarCurr)
     => ( v345(VarCurr)
      <=> $true ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_43,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v339(VarNext)
      <=> v340(VarNext) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_42,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v340(VarNext)
      <=> ( v342(VarNext)
          & v295(VarNext) ) ) ) ).

tff(writeUnaryOperator_20,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v342(VarNext)
      <=> v302(VarNext) ) ) ).

tff(aaddConditionBooleanCondEqualRangesElseBranch_7,axiom,
    ! [VarCurr: state_type] :
      ( ~ v330(VarCurr)
     => ( v67(VarCurr,0)
      <=> $false ) ) ).

tff(addConditionBooleanCondEqualRangesThenBranch_8,axiom,
    ! [VarCurr: state_type] :
      ( v330(VarCurr)
     => ( v67(VarCurr,0)
      <=> $true ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_41,axiom,
    ! [VarCurr: state_type] :
      ( v330(VarCurr)
    <=> ( v331(VarCurr)
        | v336(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_40,axiom,
    ! [VarCurr: state_type] :
      ( v336(VarCurr)
    <=> ( v284(VarCurr)
        & v320(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_39,axiom,
    ! [VarCurr: state_type] :
      ( v331(VarCurr)
    <=> ( v332(VarCurr)
        | v335(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_38,axiom,
    ! [VarCurr: state_type] :
      ( v335(VarCurr)
    <=> ( v284(VarCurr)
        & v293(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_37,axiom,
    ! [VarCurr: state_type] :
      ( v332(VarCurr)
    <=> ( v333(VarCurr)
        & v317(VarCurr) ) ) ).

tff(writeUnaryOperator_19,axiom,
    ! [VarCurr: state_type] :
      ( ~ v333(VarCurr)
    <=> v69(VarCurr) ) ).

tff(addAssignment_84,axiom,
    ! [VarNext: state_type] :
      ( v62(VarNext,1)
    <=> v322(VarNext,0) ) ).

tff(addCaseBooleanConditionShiftedRanges1_3,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v323(VarNext)
       => ( ( v322(VarNext,2)
          <=> v62(VarCurr,3) )
          & ( v322(VarNext,1)
          <=> v62(VarCurr,2) )
          & ( v322(VarNext,0)
          <=> v62(VarCurr,1) ) ) ) ) ).

tff(addCaseBooleanConditionEqualRanges0_7,axiom,
    ! [VarNext: state_type] :
      ( v323(VarNext)
     => ! [B: $int] :
          ( ( $less(B,3)
            & ~ $less(B,0) )
         => ( v322(VarNext,B)
          <=> v308(VarNext,B) ) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_36,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v323(VarNext)
      <=> v324(VarNext) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_35,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v324(VarNext)
      <=> ( v326(VarNext)
          & v295(VarNext) ) ) ) ).

tff(writeUnaryOperator_18,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v326(VarNext)
      <=> v302(VarNext) ) ) ).

tff(addConditionBooleanCondShiftedRangesElseBranch_2,axiom,
    ! [VarCurr: state_type] :
      ( ~ v313(VarCurr)
     => ( v67(VarCurr,1)
      <=> $false ) ) ).

tff(addConditionBooleanCondShiftedRangesThenBranch_1,axiom,
    ! [VarCurr: state_type] :
      ( v313(VarCurr)
     => ( v67(VarCurr,1)
      <=> $true ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_34,axiom,
    ! [VarCurr: state_type] :
      ( v313(VarCurr)
    <=> ( v314(VarCurr)
        | v318(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_33,axiom,
    ! [VarCurr: state_type] :
      ( v318(VarCurr)
    <=> ( v319(VarCurr)
        & v320(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_17,axiom,
    ! [VarCurr: state_type] :
      ( v320(VarCurr)
    <=> ( $true
      <=> v62(VarCurr,1) ) ) ).

tff(writeUnaryOperator_17,axiom,
    ! [VarCurr: state_type] :
      ( ~ v319(VarCurr)
    <=> v284(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_32,axiom,
    ! [VarCurr: state_type] :
      ( v314(VarCurr)
    <=> ( v315(VarCurr)
        & v317(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_16,axiom,
    ! [VarCurr: state_type] :
      ( v317(VarCurr)
    <=> ( $true
      <=> v62(VarCurr,0) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_31,axiom,
    ! [VarCurr: state_type] :
      ( v315(VarCurr)
    <=> ( v69(VarCurr)
        & v82(VarCurr) ) ) ).

tff(addAssignment_83,axiom,
    ! [VarNext: state_type] :
      ( v62(VarNext,3)
    <=> v297(VarNext,2) ) ).

tff(addCaseBooleanConditionShiftedRanges1_2,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v298(VarNext)
       => ( ( v297(VarNext,2)
          <=> v62(VarCurr,3) )
          & ( v297(VarNext,1)
          <=> v62(VarCurr,2) )
          & ( v297(VarNext,0)
          <=> v62(VarCurr,1) ) ) ) ) ).

tff(addCaseBooleanConditionEqualRanges0_6,axiom,
    ! [VarNext: state_type] :
      ( v298(VarNext)
     => ! [B: $int] :
          ( ( $less(B,3)
            & ~ $less(B,0) )
         => ( v297(VarNext,B)
          <=> v308(VarNext,B) ) ) ) ).

tff(addAssignment_82,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ! [B: $int] :
          ( ( $less(B,3)
            & ~ $less(B,0) )
         => ( v308(VarNext,B)
          <=> v306(VarCurr,B) ) ) ) ).

tff(addConditionBooleanCondShiftedRangesElseBranch_1,axiom,
    ! [VarCurr: state_type] :
      ( ~ v309(VarCurr)
     => ( ( v306(VarCurr,2)
        <=> v67(VarCurr,3) )
        & ( v306(VarCurr,1)
        <=> v67(VarCurr,2) )
        & ( v306(VarCurr,0)
        <=> v67(VarCurr,1) ) ) ) ).

tff(addConditionBooleanCondEqualRangesThenBranch_7,axiom,
    ! [VarCurr: state_type] :
      ( v309(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,3)
            & ~ $less(B,0) )
         => ( v306(VarCurr,B)
          <=> $false ) ) ) ).

tff(writeUnaryOperator_16,axiom,
    ! [VarCurr: state_type] :
      ( ~ v309(VarCurr)
    <=> v64(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_30,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v298(VarNext)
      <=> v299(VarNext) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_29,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v299(VarNext)
      <=> ( v300(VarNext)
          & v295(VarNext) ) ) ) ).

tff(writeUnaryOperator_15,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v300(VarNext)
      <=> v302(VarNext) ) ) ).

tff(addAssignment_81,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v302(VarNext)
      <=> v295(VarCurr) ) ) ).

tff(addAssignment_80,axiom,
    ! [VarCurr: state_type] :
      ( v295(VarCurr)
    <=> v1(VarCurr) ) ).

tff(addConditionBooleanCondShiftedRangesElseBranch,axiom,
    ! [VarCurr: state_type] :
      ( ~ v288(VarCurr)
     => ( v67(VarCurr,3)
      <=> $false ) ) ).

tff(addConditionBooleanCondShiftedRangesThenBranch,axiom,
    ! [VarCurr: state_type] :
      ( v288(VarCurr)
     => ( v67(VarCurr,3)
      <=> $true ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_28,axiom,
    ! [VarCurr: state_type] :
      ( v288(VarCurr)
    <=> ( v289(VarCurr)
        | v291(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_27,axiom,
    ! [VarCurr: state_type] :
      ( v291(VarCurr)
    <=> ( v292(VarCurr)
        & v293(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_15,axiom,
    ! [VarCurr: state_type] :
      ( v293(VarCurr)
    <=> ( $true
      <=> v62(VarCurr,3) ) ) ).

tff(writeUnaryOperator_14,axiom,
    ! [VarCurr: state_type] :
      ( ~ v292(VarCurr)
    <=> v284(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_26,axiom,
    ! [VarCurr: state_type] :
      ( v289(VarCurr)
    <=> ( v284(VarCurr)
        & v290(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_14,axiom,
    ! [VarCurr: state_type] :
      ( v290(VarCurr)
    <=> ( $true
      <=> v62(VarCurr,2) ) ) ).

tff(addAssignmentInitValueVector_3,axiom,
    ( ( v62(constB0,3)
    <=> $false )
    & ( v62(constB0,2)
    <=> $false )
    & ( v62(constB0,1)
    <=> $false ) ) ).

tff(bitBlastConstant_155,axiom,
    ~ b000(2) ).

tff(bitBlastConstant_154,axiom,
    ~ b000(1) ).

tff(bitBlastConstant_153,axiom,
    ~ b000(0) ).

tff(addAssignmentInitValueVector_2,axiom,
    ( v62(constB0,0)
  <=> $true ) ).

tff(addAssignment_79,axiom,
    ! [VarCurr: state_type] :
      ( v284(VarCurr)
    <=> v286(VarCurr) ) ).

tff(addAssignment_78,axiom,
    ! [VarCurr: state_type] :
      ( v82(VarCurr)
    <=> v84(VarCurr) ) ).

tff(addAssignment_77,axiom,
    ! [VarCurr: state_type] :
      ( v84(VarCurr)
    <=> v86(VarCurr) ) ).

tff(addAssignment_76,axiom,
    ! [VarCurr: state_type] :
      ( v86(VarCurr)
    <=> v88(VarCurr,0) ) ).

tff(addAssignment_75,axiom,
    ! [VarCurr: state_type] :
      ( v88(VarCurr,0)
    <=> v90(VarCurr,49) ) ).

tff(addAssignment_74,axiom,
    ! [VarCurr: state_type] :
      ( v90(VarCurr,49)
    <=> v92(VarCurr,49) ) ).

tff(addAssignment_73,axiom,
    ! [VarCurr: state_type] :
      ( v92(VarCurr,49)
    <=> v94(VarCurr,539) ) ).

tff(addAssignment_72,axiom,
    ! [VarNext: state_type] :
      ( v94(VarNext,539)
    <=> v251(VarNext,49) ) ).

tff(addCaseBooleanConditionShiftedRanges1_1,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v252(VarNext)
       => ( ( v251(VarNext,69)
          <=> v94(VarCurr,559) )
          & ( v251(VarNext,68)
          <=> v94(VarCurr,558) )
          & ( v251(VarNext,67)
          <=> v94(VarCurr,557) )
          & ( v251(VarNext,66)
          <=> v94(VarCurr,556) )
          & ( v251(VarNext,65)
          <=> v94(VarCurr,555) )
          & ( v251(VarNext,64)
          <=> v94(VarCurr,554) )
          & ( v251(VarNext,63)
          <=> v94(VarCurr,553) )
          & ( v251(VarNext,62)
          <=> v94(VarCurr,552) )
          & ( v251(VarNext,61)
          <=> v94(VarCurr,551) )
          & ( v251(VarNext,60)
          <=> v94(VarCurr,550) )
          & ( v251(VarNext,59)
          <=> v94(VarCurr,549) )
          & ( v251(VarNext,58)
          <=> v94(VarCurr,548) )
          & ( v251(VarNext,57)
          <=> v94(VarCurr,547) )
          & ( v251(VarNext,56)
          <=> v94(VarCurr,546) )
          & ( v251(VarNext,55)
          <=> v94(VarCurr,545) )
          & ( v251(VarNext,54)
          <=> v94(VarCurr,544) )
          & ( v251(VarNext,53)
          <=> v94(VarCurr,543) )
          & ( v251(VarNext,52)
          <=> v94(VarCurr,542) )
          & ( v251(VarNext,51)
          <=> v94(VarCurr,541) )
          & ( v251(VarNext,50)
          <=> v94(VarCurr,540) )
          & ( v251(VarNext,49)
          <=> v94(VarCurr,539) )
          & ( v251(VarNext,48)
          <=> v94(VarCurr,538) )
          & ( v251(VarNext,47)
          <=> v94(VarCurr,537) )
          & ( v251(VarNext,46)
          <=> v94(VarCurr,536) )
          & ( v251(VarNext,45)
          <=> v94(VarCurr,535) )
          & ( v251(VarNext,44)
          <=> v94(VarCurr,534) )
          & ( v251(VarNext,43)
          <=> v94(VarCurr,533) )
          & ( v251(VarNext,42)
          <=> v94(VarCurr,532) )
          & ( v251(VarNext,41)
          <=> v94(VarCurr,531) )
          & ( v251(VarNext,40)
          <=> v94(VarCurr,530) )
          & ( v251(VarNext,39)
          <=> v94(VarCurr,529) )
          & ( v251(VarNext,38)
          <=> v94(VarCurr,528) )
          & ( v251(VarNext,37)
          <=> v94(VarCurr,527) )
          & ( v251(VarNext,36)
          <=> v94(VarCurr,526) )
          & ( v251(VarNext,35)
          <=> v94(VarCurr,525) )
          & ( v251(VarNext,34)
          <=> v94(VarCurr,524) )
          & ( v251(VarNext,33)
          <=> v94(VarCurr,523) )
          & ( v251(VarNext,32)
          <=> v94(VarCurr,522) )
          & ( v251(VarNext,31)
          <=> v94(VarCurr,521) )
          & ( v251(VarNext,30)
          <=> v94(VarCurr,520) )
          & ( v251(VarNext,29)
          <=> v94(VarCurr,519) )
          & ( v251(VarNext,28)
          <=> v94(VarCurr,518) )
          & ( v251(VarNext,27)
          <=> v94(VarCurr,517) )
          & ( v251(VarNext,26)
          <=> v94(VarCurr,516) )
          & ( v251(VarNext,25)
          <=> v94(VarCurr,515) )
          & ( v251(VarNext,24)
          <=> v94(VarCurr,514) )
          & ( v251(VarNext,23)
          <=> v94(VarCurr,513) )
          & ( v251(VarNext,22)
          <=> v94(VarCurr,512) )
          & ( v251(VarNext,21)
          <=> v94(VarCurr,511) )
          & ( v251(VarNext,20)
          <=> v94(VarCurr,510) )
          & ( v251(VarNext,19)
          <=> v94(VarCurr,509) )
          & ( v251(VarNext,18)
          <=> v94(VarCurr,508) )
          & ( v251(VarNext,17)
          <=> v94(VarCurr,507) )
          & ( v251(VarNext,16)
          <=> v94(VarCurr,506) )
          & ( v251(VarNext,15)
          <=> v94(VarCurr,505) )
          & ( v251(VarNext,14)
          <=> v94(VarCurr,504) )
          & ( v251(VarNext,13)
          <=> v94(VarCurr,503) )
          & ( v251(VarNext,12)
          <=> v94(VarCurr,502) )
          & ( v251(VarNext,11)
          <=> v94(VarCurr,501) )
          & ( v251(VarNext,10)
          <=> v94(VarCurr,500) )
          & ( v251(VarNext,9)
          <=> v94(VarCurr,499) )
          & ( v251(VarNext,8)
          <=> v94(VarCurr,498) )
          & ( v251(VarNext,7)
          <=> v94(VarCurr,497) )
          & ( v251(VarNext,6)
          <=> v94(VarCurr,496) )
          & ( v251(VarNext,5)
          <=> v94(VarCurr,495) )
          & ( v251(VarNext,4)
          <=> v94(VarCurr,494) )
          & ( v251(VarNext,3)
          <=> v94(VarCurr,493) )
          & ( v251(VarNext,2)
          <=> v94(VarCurr,492) )
          & ( v251(VarNext,1)
          <=> v94(VarCurr,491) )
          & ( v251(VarNext,0)
          <=> v94(VarCurr,490) ) ) ) ) ).

tff(addCaseBooleanConditionEqualRanges0_5,axiom,
    ! [VarNext: state_type] :
      ( v252(VarNext)
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v251(VarNext,B)
          <=> v278(VarNext,B) ) ) ) ).

tff(addAssignment_71,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v278(VarNext,B)
          <=> v276(VarCurr,B) ) ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges1_4,axiom,
    ! [VarCurr: state_type] :
      ( ~ v215(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v276(VarCurr,B)
          <=> v279(VarCurr,B) ) ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges0_2,axiom,
    ! [VarCurr: state_type] :
      ( v215(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v276(VarCurr,B)
          <=> $false ) ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges2_2,axiom,
    ! [VarCurr: state_type] :
      ( ( ~ v265(VarCurr)
        & ~ v267(VarCurr) )
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v279(VarCurr,B)
          <=> v244(VarCurr,B) ) ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges1_3,axiom,
    ! [VarCurr: state_type] :
      ( v267(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v279(VarCurr,B)
          <=> v237(VarCurr,B) ) ) ) ).

tff(addParallelCaseBooleanConditionShiftedRanges0_1,axiom,
    ! [VarCurr: state_type] :
      ( v265(VarCurr)
     => ( ( v279(VarCurr,69)
        <=> v94(VarCurr,489) )
        & ( v279(VarCurr,68)
        <=> v94(VarCurr,488) )
        & ( v279(VarCurr,67)
        <=> v94(VarCurr,487) )
        & ( v279(VarCurr,66)
        <=> v94(VarCurr,486) )
        & ( v279(VarCurr,65)
        <=> v94(VarCurr,485) )
        & ( v279(VarCurr,64)
        <=> v94(VarCurr,484) )
        & ( v279(VarCurr,63)
        <=> v94(VarCurr,483) )
        & ( v279(VarCurr,62)
        <=> v94(VarCurr,482) )
        & ( v279(VarCurr,61)
        <=> v94(VarCurr,481) )
        & ( v279(VarCurr,60)
        <=> v94(VarCurr,480) )
        & ( v279(VarCurr,59)
        <=> v94(VarCurr,479) )
        & ( v279(VarCurr,58)
        <=> v94(VarCurr,478) )
        & ( v279(VarCurr,57)
        <=> v94(VarCurr,477) )
        & ( v279(VarCurr,56)
        <=> v94(VarCurr,476) )
        & ( v279(VarCurr,55)
        <=> v94(VarCurr,475) )
        & ( v279(VarCurr,54)
        <=> v94(VarCurr,474) )
        & ( v279(VarCurr,53)
        <=> v94(VarCurr,473) )
        & ( v279(VarCurr,52)
        <=> v94(VarCurr,472) )
        & ( v279(VarCurr,51)
        <=> v94(VarCurr,471) )
        & ( v279(VarCurr,50)
        <=> v94(VarCurr,470) )
        & ( v279(VarCurr,49)
        <=> v94(VarCurr,469) )
        & ( v279(VarCurr,48)
        <=> v94(VarCurr,468) )
        & ( v279(VarCurr,47)
        <=> v94(VarCurr,467) )
        & ( v279(VarCurr,46)
        <=> v94(VarCurr,466) )
        & ( v279(VarCurr,45)
        <=> v94(VarCurr,465) )
        & ( v279(VarCurr,44)
        <=> v94(VarCurr,464) )
        & ( v279(VarCurr,43)
        <=> v94(VarCurr,463) )
        & ( v279(VarCurr,42)
        <=> v94(VarCurr,462) )
        & ( v279(VarCurr,41)
        <=> v94(VarCurr,461) )
        & ( v279(VarCurr,40)
        <=> v94(VarCurr,460) )
        & ( v279(VarCurr,39)
        <=> v94(VarCurr,459) )
        & ( v279(VarCurr,38)
        <=> v94(VarCurr,458) )
        & ( v279(VarCurr,37)
        <=> v94(VarCurr,457) )
        & ( v279(VarCurr,36)
        <=> v94(VarCurr,456) )
        & ( v279(VarCurr,35)
        <=> v94(VarCurr,455) )
        & ( v279(VarCurr,34)
        <=> v94(VarCurr,454) )
        & ( v279(VarCurr,33)
        <=> v94(VarCurr,453) )
        & ( v279(VarCurr,32)
        <=> v94(VarCurr,452) )
        & ( v279(VarCurr,31)
        <=> v94(VarCurr,451) )
        & ( v279(VarCurr,30)
        <=> v94(VarCurr,450) )
        & ( v279(VarCurr,29)
        <=> v94(VarCurr,449) )
        & ( v279(VarCurr,28)
        <=> v94(VarCurr,448) )
        & ( v279(VarCurr,27)
        <=> v94(VarCurr,447) )
        & ( v279(VarCurr,26)
        <=> v94(VarCurr,446) )
        & ( v279(VarCurr,25)
        <=> v94(VarCurr,445) )
        & ( v279(VarCurr,24)
        <=> v94(VarCurr,444) )
        & ( v279(VarCurr,23)
        <=> v94(VarCurr,443) )
        & ( v279(VarCurr,22)
        <=> v94(VarCurr,442) )
        & ( v279(VarCurr,21)
        <=> v94(VarCurr,441) )
        & ( v279(VarCurr,20)
        <=> v94(VarCurr,440) )
        & ( v279(VarCurr,19)
        <=> v94(VarCurr,439) )
        & ( v279(VarCurr,18)
        <=> v94(VarCurr,438) )
        & ( v279(VarCurr,17)
        <=> v94(VarCurr,437) )
        & ( v279(VarCurr,16)
        <=> v94(VarCurr,436) )
        & ( v279(VarCurr,15)
        <=> v94(VarCurr,435) )
        & ( v279(VarCurr,14)
        <=> v94(VarCurr,434) )
        & ( v279(VarCurr,13)
        <=> v94(VarCurr,433) )
        & ( v279(VarCurr,12)
        <=> v94(VarCurr,432) )
        & ( v279(VarCurr,11)
        <=> v94(VarCurr,431) )
        & ( v279(VarCurr,10)
        <=> v94(VarCurr,430) )
        & ( v279(VarCurr,9)
        <=> v94(VarCurr,429) )
        & ( v279(VarCurr,8)
        <=> v94(VarCurr,428) )
        & ( v279(VarCurr,7)
        <=> v94(VarCurr,427) )
        & ( v279(VarCurr,6)
        <=> v94(VarCurr,426) )
        & ( v279(VarCurr,5)
        <=> v94(VarCurr,425) )
        & ( v279(VarCurr,4)
        <=> v94(VarCurr,424) )
        & ( v279(VarCurr,3)
        <=> v94(VarCurr,423) )
        & ( v279(VarCurr,2)
        <=> v94(VarCurr,422) )
        & ( v279(VarCurr,1)
        <=> v94(VarCurr,421) )
        & ( v279(VarCurr,0)
        <=> v94(VarCurr,420) ) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_25,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v252(VarNext)
      <=> ( v253(VarNext)
          & v260(VarNext) ) ) ) ).

tff(addAssignment_70,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v260(VarNext)
      <=> v258(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_24,axiom,
    ! [VarCurr: state_type] :
      ( v258(VarCurr)
    <=> ( v261(VarCurr)
        & v272(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_23,axiom,
    ! [VarCurr: state_type] :
      ( v272(VarCurr)
    <=> ( v273(VarCurr)
        | v215(VarCurr) ) ) ).

tff(writeUnaryOperator_13,axiom,
    ! [VarCurr: state_type] :
      ( ~ v273(VarCurr)
    <=> v274(VarCurr) ) ).

tff(addBitVectorEqualityBitBlasted_13,axiom,
    ! [VarCurr: state_type] :
      ( v274(VarCurr)
    <=> ( ( v275(VarCurr,1)
        <=> $false )
        & ( v275(VarCurr,0)
        <=> $false ) ) ) ).

tff(addAssignment_69,axiom,
    ! [VarCurr: state_type] :
      ( v275(VarCurr,0)
    <=> v43(VarCurr) ) ).

tff(addAssignment_68,axiom,
    ! [VarCurr: state_type] :
      ( v275(VarCurr,1)
    <=> v36(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_22,axiom,
    ! [VarCurr: state_type] :
      ( v261(VarCurr)
    <=> ( v215(VarCurr)
        | v262(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_21,axiom,
    ! [VarCurr: state_type] :
      ( v262(VarCurr)
    <=> ( v263(VarCurr)
        & v271(VarCurr) ) ) ).

tff(writeUnaryOperator_12,axiom,
    ! [VarCurr: state_type] :
      ( ~ v271(VarCurr)
    <=> v215(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_20,axiom,
    ! [VarCurr: state_type] :
      ( v263(VarCurr)
    <=> ( v264(VarCurr)
        | v269(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_12,axiom,
    ! [VarCurr: state_type] :
      ( v269(VarCurr)
    <=> ( ( v270(VarCurr,1)
        <=> $true )
        & ( v270(VarCurr,0)
        <=> $true ) ) ) ).

tff(addAssignment_67,axiom,
    ! [VarCurr: state_type] :
      ( v270(VarCurr,0)
    <=> v43(VarCurr) ) ).

tff(addAssignment_66,axiom,
    ! [VarCurr: state_type] :
      ( v270(VarCurr,1)
    <=> v36(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_19,axiom,
    ! [VarCurr: state_type] :
      ( v264(VarCurr)
    <=> ( v265(VarCurr)
        | v267(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_11,axiom,
    ! [VarCurr: state_type] :
      ( v267(VarCurr)
    <=> ( ( v268(VarCurr,1)
        <=> $true )
        & ( v268(VarCurr,0)
        <=> $false ) ) ) ).

tff(addAssignment_65,axiom,
    ! [VarCurr: state_type] :
      ( v268(VarCurr,0)
    <=> v43(VarCurr) ) ).

tff(addAssignment_64,axiom,
    ! [VarCurr: state_type] :
      ( v268(VarCurr,1)
    <=> v36(VarCurr) ) ).

tff(addBitVectorEqualityBitBlasted_10,axiom,
    ! [VarCurr: state_type] :
      ( v265(VarCurr)
    <=> ( ( v266(VarCurr,1)
        <=> $false )
        & ( v266(VarCurr,0)
        <=> $true ) ) ) ).

tff(addAssignment_63,axiom,
    ! [VarCurr: state_type] :
      ( v266(VarCurr,0)
    <=> v43(VarCurr) ) ).

tff(addAssignment_62,axiom,
    ! [VarCurr: state_type] :
      ( v266(VarCurr,1)
    <=> v36(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_18,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v253(VarNext)
      <=> ( v255(VarNext)
          & v110(VarNext) ) ) ) ).

tff(writeUnaryOperator_11,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v255(VarNext)
      <=> v119(VarNext) ) ) ).

tff(addAssignment_61,axiom,
    ! [VarCurr: state_type] :
      ( v244(VarCurr,49)
    <=> v249(VarCurr,49) ) ).

tff(aaddConditionBooleanCondEqualRangesElseBranch_6,axiom,
    ! [VarCurr: state_type] :
      ( ~ v246(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v249(VarCurr,B)
          <=> v248(VarCurr,B) ) ) ) ).

tff(addConditionBooleanCondEqualRangesThenBranch_6,axiom,
    ! [VarCurr: state_type] :
      ( v246(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v249(VarCurr,B)
          <=> v172(VarCurr,B) ) ) ) ).

tff(addAssignment_60,axiom,
    ! [VarCurr: state_type] :
      ( v248(VarCurr,49)
    <=> v94(VarCurr,469) ) ).

tff(addAssignment_59,axiom,
    ! [VarCurr: state_type] :
      ( v246(VarCurr)
    <=> v103(VarCurr,1) ) ).

tff(addAssignment_58,axiom,
    ! [VarCurr: state_type] :
      ( v237(VarCurr,49)
    <=> v242(VarCurr,49) ) ).

tff(aaddConditionBooleanCondEqualRangesElseBranch_5,axiom,
    ! [VarCurr: state_type] :
      ( ~ v239(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v242(VarCurr,B)
          <=> v241(VarCurr,B) ) ) ) ).

tff(addConditionBooleanCondEqualRangesThenBranch_5,axiom,
    ! [VarCurr: state_type] :
      ( v239(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v242(VarCurr,B)
          <=> v172(VarCurr,B) ) ) ) ).

tff(addAssignment_57,axiom,
    ! [VarCurr: state_type] :
      ( v241(VarCurr,49)
    <=> v94(VarCurr,539) ) ).

tff(addAssignment_56,axiom,
    ! [VarCurr: state_type] :
      ( v239(VarCurr)
    <=> v103(VarCurr,1) ) ).

tff(addAssignment_55,axiom,
    ! [VarNext: state_type] :
      ( v94(VarNext,469)
    <=> v204(VarNext,49) ) ).

tff(addCaseBooleanConditionShiftedRanges1,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v205(VarNext)
       => ( ( v204(VarNext,69)
          <=> v94(VarCurr,489) )
          & ( v204(VarNext,68)
          <=> v94(VarCurr,488) )
          & ( v204(VarNext,67)
          <=> v94(VarCurr,487) )
          & ( v204(VarNext,66)
          <=> v94(VarCurr,486) )
          & ( v204(VarNext,65)
          <=> v94(VarCurr,485) )
          & ( v204(VarNext,64)
          <=> v94(VarCurr,484) )
          & ( v204(VarNext,63)
          <=> v94(VarCurr,483) )
          & ( v204(VarNext,62)
          <=> v94(VarCurr,482) )
          & ( v204(VarNext,61)
          <=> v94(VarCurr,481) )
          & ( v204(VarNext,60)
          <=> v94(VarCurr,480) )
          & ( v204(VarNext,59)
          <=> v94(VarCurr,479) )
          & ( v204(VarNext,58)
          <=> v94(VarCurr,478) )
          & ( v204(VarNext,57)
          <=> v94(VarCurr,477) )
          & ( v204(VarNext,56)
          <=> v94(VarCurr,476) )
          & ( v204(VarNext,55)
          <=> v94(VarCurr,475) )
          & ( v204(VarNext,54)
          <=> v94(VarCurr,474) )
          & ( v204(VarNext,53)
          <=> v94(VarCurr,473) )
          & ( v204(VarNext,52)
          <=> v94(VarCurr,472) )
          & ( v204(VarNext,51)
          <=> v94(VarCurr,471) )
          & ( v204(VarNext,50)
          <=> v94(VarCurr,470) )
          & ( v204(VarNext,49)
          <=> v94(VarCurr,469) )
          & ( v204(VarNext,48)
          <=> v94(VarCurr,468) )
          & ( v204(VarNext,47)
          <=> v94(VarCurr,467) )
          & ( v204(VarNext,46)
          <=> v94(VarCurr,466) )
          & ( v204(VarNext,45)
          <=> v94(VarCurr,465) )
          & ( v204(VarNext,44)
          <=> v94(VarCurr,464) )
          & ( v204(VarNext,43)
          <=> v94(VarCurr,463) )
          & ( v204(VarNext,42)
          <=> v94(VarCurr,462) )
          & ( v204(VarNext,41)
          <=> v94(VarCurr,461) )
          & ( v204(VarNext,40)
          <=> v94(VarCurr,460) )
          & ( v204(VarNext,39)
          <=> v94(VarCurr,459) )
          & ( v204(VarNext,38)
          <=> v94(VarCurr,458) )
          & ( v204(VarNext,37)
          <=> v94(VarCurr,457) )
          & ( v204(VarNext,36)
          <=> v94(VarCurr,456) )
          & ( v204(VarNext,35)
          <=> v94(VarCurr,455) )
          & ( v204(VarNext,34)
          <=> v94(VarCurr,454) )
          & ( v204(VarNext,33)
          <=> v94(VarCurr,453) )
          & ( v204(VarNext,32)
          <=> v94(VarCurr,452) )
          & ( v204(VarNext,31)
          <=> v94(VarCurr,451) )
          & ( v204(VarNext,30)
          <=> v94(VarCurr,450) )
          & ( v204(VarNext,29)
          <=> v94(VarCurr,449) )
          & ( v204(VarNext,28)
          <=> v94(VarCurr,448) )
          & ( v204(VarNext,27)
          <=> v94(VarCurr,447) )
          & ( v204(VarNext,26)
          <=> v94(VarCurr,446) )
          & ( v204(VarNext,25)
          <=> v94(VarCurr,445) )
          & ( v204(VarNext,24)
          <=> v94(VarCurr,444) )
          & ( v204(VarNext,23)
          <=> v94(VarCurr,443) )
          & ( v204(VarNext,22)
          <=> v94(VarCurr,442) )
          & ( v204(VarNext,21)
          <=> v94(VarCurr,441) )
          & ( v204(VarNext,20)
          <=> v94(VarCurr,440) )
          & ( v204(VarNext,19)
          <=> v94(VarCurr,439) )
          & ( v204(VarNext,18)
          <=> v94(VarCurr,438) )
          & ( v204(VarNext,17)
          <=> v94(VarCurr,437) )
          & ( v204(VarNext,16)
          <=> v94(VarCurr,436) )
          & ( v204(VarNext,15)
          <=> v94(VarCurr,435) )
          & ( v204(VarNext,14)
          <=> v94(VarCurr,434) )
          & ( v204(VarNext,13)
          <=> v94(VarCurr,433) )
          & ( v204(VarNext,12)
          <=> v94(VarCurr,432) )
          & ( v204(VarNext,11)
          <=> v94(VarCurr,431) )
          & ( v204(VarNext,10)
          <=> v94(VarCurr,430) )
          & ( v204(VarNext,9)
          <=> v94(VarCurr,429) )
          & ( v204(VarNext,8)
          <=> v94(VarCurr,428) )
          & ( v204(VarNext,7)
          <=> v94(VarCurr,427) )
          & ( v204(VarNext,6)
          <=> v94(VarCurr,426) )
          & ( v204(VarNext,5)
          <=> v94(VarCurr,425) )
          & ( v204(VarNext,4)
          <=> v94(VarCurr,424) )
          & ( v204(VarNext,3)
          <=> v94(VarCurr,423) )
          & ( v204(VarNext,2)
          <=> v94(VarCurr,422) )
          & ( v204(VarNext,1)
          <=> v94(VarCurr,421) )
          & ( v204(VarNext,0)
          <=> v94(VarCurr,420) ) ) ) ) ).

tff(addCaseBooleanConditionEqualRanges0_4,axiom,
    ! [VarNext: state_type] :
      ( v205(VarNext)
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v204(VarNext,B)
          <=> v232(VarNext,B) ) ) ) ).

tff(addAssignment_54,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v232(VarNext,B)
          <=> v230(VarCurr,B) ) ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges1_2,axiom,
    ! [VarCurr: state_type] :
      ( ~ v215(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v230(VarCurr,B)
          <=> v233(VarCurr,B) ) ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges0_1,axiom,
    ! [VarCurr: state_type] :
      ( v215(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v230(VarCurr,B)
          <=> $false ) ) ) ).

tff(bitBlastConstant_152,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(69) ).

tff(bitBlastConstant_151,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(68) ).

tff(bitBlastConstant_150,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(67) ).

tff(bitBlastConstant_149,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(66) ).

tff(bitBlastConstant_148,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(65) ).

tff(bitBlastConstant_147,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(64) ).

tff(bitBlastConstant_146,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(63) ).

tff(bitBlastConstant_145,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(62) ).

tff(bitBlastConstant_144,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(61) ).

tff(bitBlastConstant_143,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(60) ).

tff(bitBlastConstant_142,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(59) ).

tff(bitBlastConstant_141,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(58) ).

tff(bitBlastConstant_140,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(57) ).

tff(bitBlastConstant_139,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(56) ).

tff(bitBlastConstant_138,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(55) ).

tff(bitBlastConstant_137,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(54) ).

tff(bitBlastConstant_136,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(53) ).

tff(bitBlastConstant_135,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(52) ).

tff(bitBlastConstant_134,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(51) ).

tff(bitBlastConstant_133,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(50) ).

tff(bitBlastConstant_132,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(49) ).

tff(bitBlastConstant_131,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(48) ).

tff(bitBlastConstant_130,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(47) ).

tff(bitBlastConstant_129,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(46) ).

tff(bitBlastConstant_128,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(45) ).

tff(bitBlastConstant_127,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(44) ).

tff(bitBlastConstant_126,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(43) ).

tff(bitBlastConstant_125,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(42) ).

tff(bitBlastConstant_124,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(41) ).

tff(bitBlastConstant_123,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(40) ).

tff(bitBlastConstant_122,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(39) ).

tff(bitBlastConstant_121,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(38) ).

tff(bitBlastConstant_120,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(37) ).

tff(bitBlastConstant_119,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(36) ).

tff(bitBlastConstant_118,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(35) ).

tff(bitBlastConstant_117,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(34) ).

tff(bitBlastConstant_116,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(33) ).

tff(bitBlastConstant_115,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(32) ).

tff(bitBlastConstant_114,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(31) ).

tff(bitBlastConstant_113,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(30) ).

tff(bitBlastConstant_112,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(29) ).

tff(bitBlastConstant_111,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(28) ).

tff(bitBlastConstant_110,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(27) ).

tff(bitBlastConstant_109,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(26) ).

tff(bitBlastConstant_108,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(25) ).

tff(bitBlastConstant_107,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(24) ).

tff(bitBlastConstant_106,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(23) ).

tff(bitBlastConstant_105,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(22) ).

tff(bitBlastConstant_104,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(21) ).

tff(bitBlastConstant_103,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(20) ).

tff(bitBlastConstant_102,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(19) ).

tff(bitBlastConstant_101,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(18) ).

tff(bitBlastConstant_100,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(17) ).

tff(bitBlastConstant_99,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(16) ).

tff(bitBlastConstant_98,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(15) ).

tff(bitBlastConstant_97,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(14) ).

tff(bitBlastConstant_96,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(13) ).

tff(bitBlastConstant_95,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(12) ).

tff(bitBlastConstant_94,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(11) ).

tff(bitBlastConstant_93,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(10) ).

tff(bitBlastConstant_92,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(9) ).

tff(bitBlastConstant_91,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(8) ).

tff(bitBlastConstant_90,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(7) ).

tff(bitBlastConstant_89,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(6) ).

tff(bitBlastConstant_88,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(5) ).

tff(bitBlastConstant_87,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(4) ).

tff(bitBlastConstant_86,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(3) ).

tff(bitBlastConstant_85,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(2) ).

tff(bitBlastConstant_84,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(1) ).

tff(bitBlastConstant_83,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(0) ).

tff(addParallelCaseBooleanConditionEqualRanges2_1,axiom,
    ! [VarCurr: state_type] :
      ( ( ~ v219(VarCurr)
        & ~ v221(VarCurr) )
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v233(VarCurr,B)
          <=> v197(VarCurr,B) ) ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges1_1,axiom,
    ! [VarCurr: state_type] :
      ( v221(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v233(VarCurr,B)
          <=> v99(VarCurr,B) ) ) ) ).

tff(addParallelCaseBooleanConditionShiftedRanges0,axiom,
    ! [VarCurr: state_type] :
      ( v219(VarCurr)
     => ( ( v233(VarCurr,69)
        <=> v94(VarCurr,419) )
        & ( v233(VarCurr,68)
        <=> v94(VarCurr,418) )
        & ( v233(VarCurr,67)
        <=> v94(VarCurr,417) )
        & ( v233(VarCurr,66)
        <=> v94(VarCurr,416) )
        & ( v233(VarCurr,65)
        <=> v94(VarCurr,415) )
        & ( v233(VarCurr,64)
        <=> v94(VarCurr,414) )
        & ( v233(VarCurr,63)
        <=> v94(VarCurr,413) )
        & ( v233(VarCurr,62)
        <=> v94(VarCurr,412) )
        & ( v233(VarCurr,61)
        <=> v94(VarCurr,411) )
        & ( v233(VarCurr,60)
        <=> v94(VarCurr,410) )
        & ( v233(VarCurr,59)
        <=> v94(VarCurr,409) )
        & ( v233(VarCurr,58)
        <=> v94(VarCurr,408) )
        & ( v233(VarCurr,57)
        <=> v94(VarCurr,407) )
        & ( v233(VarCurr,56)
        <=> v94(VarCurr,406) )
        & ( v233(VarCurr,55)
        <=> v94(VarCurr,405) )
        & ( v233(VarCurr,54)
        <=> v94(VarCurr,404) )
        & ( v233(VarCurr,53)
        <=> v94(VarCurr,403) )
        & ( v233(VarCurr,52)
        <=> v94(VarCurr,402) )
        & ( v233(VarCurr,51)
        <=> v94(VarCurr,401) )
        & ( v233(VarCurr,50)
        <=> v94(VarCurr,400) )
        & ( v233(VarCurr,49)
        <=> v94(VarCurr,399) )
        & ( v233(VarCurr,48)
        <=> v94(VarCurr,398) )
        & ( v233(VarCurr,47)
        <=> v94(VarCurr,397) )
        & ( v233(VarCurr,46)
        <=> v94(VarCurr,396) )
        & ( v233(VarCurr,45)
        <=> v94(VarCurr,395) )
        & ( v233(VarCurr,44)
        <=> v94(VarCurr,394) )
        & ( v233(VarCurr,43)
        <=> v94(VarCurr,393) )
        & ( v233(VarCurr,42)
        <=> v94(VarCurr,392) )
        & ( v233(VarCurr,41)
        <=> v94(VarCurr,391) )
        & ( v233(VarCurr,40)
        <=> v94(VarCurr,390) )
        & ( v233(VarCurr,39)
        <=> v94(VarCurr,389) )
        & ( v233(VarCurr,38)
        <=> v94(VarCurr,388) )
        & ( v233(VarCurr,37)
        <=> v94(VarCurr,387) )
        & ( v233(VarCurr,36)
        <=> v94(VarCurr,386) )
        & ( v233(VarCurr,35)
        <=> v94(VarCurr,385) )
        & ( v233(VarCurr,34)
        <=> v94(VarCurr,384) )
        & ( v233(VarCurr,33)
        <=> v94(VarCurr,383) )
        & ( v233(VarCurr,32)
        <=> v94(VarCurr,382) )
        & ( v233(VarCurr,31)
        <=> v94(VarCurr,381) )
        & ( v233(VarCurr,30)
        <=> v94(VarCurr,380) )
        & ( v233(VarCurr,29)
        <=> v94(VarCurr,379) )
        & ( v233(VarCurr,28)
        <=> v94(VarCurr,378) )
        & ( v233(VarCurr,27)
        <=> v94(VarCurr,377) )
        & ( v233(VarCurr,26)
        <=> v94(VarCurr,376) )
        & ( v233(VarCurr,25)
        <=> v94(VarCurr,375) )
        & ( v233(VarCurr,24)
        <=> v94(VarCurr,374) )
        & ( v233(VarCurr,23)
        <=> v94(VarCurr,373) )
        & ( v233(VarCurr,22)
        <=> v94(VarCurr,372) )
        & ( v233(VarCurr,21)
        <=> v94(VarCurr,371) )
        & ( v233(VarCurr,20)
        <=> v94(VarCurr,370) )
        & ( v233(VarCurr,19)
        <=> v94(VarCurr,369) )
        & ( v233(VarCurr,18)
        <=> v94(VarCurr,368) )
        & ( v233(VarCurr,17)
        <=> v94(VarCurr,367) )
        & ( v233(VarCurr,16)
        <=> v94(VarCurr,366) )
        & ( v233(VarCurr,15)
        <=> v94(VarCurr,365) )
        & ( v233(VarCurr,14)
        <=> v94(VarCurr,364) )
        & ( v233(VarCurr,13)
        <=> v94(VarCurr,363) )
        & ( v233(VarCurr,12)
        <=> v94(VarCurr,362) )
        & ( v233(VarCurr,11)
        <=> v94(VarCurr,361) )
        & ( v233(VarCurr,10)
        <=> v94(VarCurr,360) )
        & ( v233(VarCurr,9)
        <=> v94(VarCurr,359) )
        & ( v233(VarCurr,8)
        <=> v94(VarCurr,358) )
        & ( v233(VarCurr,7)
        <=> v94(VarCurr,357) )
        & ( v233(VarCurr,6)
        <=> v94(VarCurr,356) )
        & ( v233(VarCurr,5)
        <=> v94(VarCurr,355) )
        & ( v233(VarCurr,4)
        <=> v94(VarCurr,354) )
        & ( v233(VarCurr,3)
        <=> v94(VarCurr,353) )
        & ( v233(VarCurr,2)
        <=> v94(VarCurr,352) )
        & ( v233(VarCurr,1)
        <=> v94(VarCurr,351) )
        & ( v233(VarCurr,0)
        <=> v94(VarCurr,350) ) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_17,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v205(VarNext)
      <=> ( v206(VarNext)
          & v213(VarNext) ) ) ) ).

tff(addAssignment_53,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v213(VarNext)
      <=> v211(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_16,axiom,
    ! [VarCurr: state_type] :
      ( v211(VarCurr)
    <=> ( v214(VarCurr)
        & v226(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_15,axiom,
    ! [VarCurr: state_type] :
      ( v226(VarCurr)
    <=> ( v227(VarCurr)
        | v215(VarCurr) ) ) ).

tff(writeUnaryOperator_10,axiom,
    ! [VarCurr: state_type] :
      ( ~ v227(VarCurr)
    <=> v228(VarCurr) ) ).

tff(addBitVectorEqualityBitBlasted_9,axiom,
    ! [VarCurr: state_type] :
      ( v228(VarCurr)
    <=> ( ( v229(VarCurr,1)
        <=> $false )
        & ( v229(VarCurr,0)
        <=> $false ) ) ) ).

tff(addAssignment_52,axiom,
    ! [VarCurr: state_type] :
      ( v229(VarCurr,0)
    <=> v43(VarCurr) ) ).

tff(addAssignment_51,axiom,
    ! [VarCurr: state_type] :
      ( v229(VarCurr,1)
    <=> v36(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_14,axiom,
    ! [VarCurr: state_type] :
      ( v214(VarCurr)
    <=> ( v215(VarCurr)
        | v216(VarCurr) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_13,axiom,
    ! [VarCurr: state_type] :
      ( v216(VarCurr)
    <=> ( v217(VarCurr)
        & v225(VarCurr) ) ) ).

tff(writeUnaryOperator_9,axiom,
    ! [VarCurr: state_type] :
      ( ~ v225(VarCurr)
    <=> v215(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_12,axiom,
    ! [VarCurr: state_type] :
      ( v217(VarCurr)
    <=> ( v218(VarCurr)
        | v223(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_8,axiom,
    ! [VarCurr: state_type] :
      ( v223(VarCurr)
    <=> ( ( v224(VarCurr,1)
        <=> $true )
        & ( v224(VarCurr,0)
        <=> $true ) ) ) ).

tff(addAssignment_50,axiom,
    ! [VarCurr: state_type] :
      ( v224(VarCurr,0)
    <=> v43(VarCurr) ) ).

tff(addAssignment_49,axiom,
    ! [VarCurr: state_type] :
      ( v224(VarCurr,1)
    <=> v36(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_11,axiom,
    ! [VarCurr: state_type] :
      ( v218(VarCurr)
    <=> ( v219(VarCurr)
        | v221(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_7,axiom,
    ! [VarCurr: state_type] :
      ( v221(VarCurr)
    <=> ( ( v222(VarCurr,1)
        <=> $true )
        & ( v222(VarCurr,0)
        <=> $false ) ) ) ).

tff(addAssignment_48,axiom,
    ! [VarCurr: state_type] :
      ( v222(VarCurr,0)
    <=> v43(VarCurr) ) ).

tff(addAssignment_47,axiom,
    ! [VarCurr: state_type] :
      ( v222(VarCurr,1)
    <=> v36(VarCurr) ) ).

tff(addBitVectorEqualityBitBlasted_6,axiom,
    ! [VarCurr: state_type] :
      ( v219(VarCurr)
    <=> ( ( v220(VarCurr,1)
        <=> $false )
        & ( v220(VarCurr,0)
        <=> $true ) ) ) ).

tff(addAssignment_46,axiom,
    ! [VarCurr: state_type] :
      ( v220(VarCurr,0)
    <=> v43(VarCurr) ) ).

tff(addAssignment_45,axiom,
    ! [VarCurr: state_type] :
      ( v220(VarCurr,1)
    <=> v36(VarCurr) ) ).

tff(writeUnaryOperator_8,axiom,
    ! [VarCurr: state_type] :
      ( ~ v215(VarCurr)
    <=> v34(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_10,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v206(VarNext)
      <=> ( v207(VarNext)
          & v110(VarNext) ) ) ) ).

tff(writeUnaryOperator_7,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v207(VarNext)
      <=> v119(VarNext) ) ) ).

tff(addAssignment_44,axiom,
    ! [VarCurr: state_type] :
      ( v197(VarCurr,49)
    <=> v202(VarCurr,49) ) ).

tff(aaddConditionBooleanCondEqualRangesElseBranch_4,axiom,
    ! [VarCurr: state_type] :
      ( ~ v199(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v202(VarCurr,B)
          <=> v201(VarCurr,B) ) ) ) ).

tff(addConditionBooleanCondEqualRangesThenBranch_4,axiom,
    ! [VarCurr: state_type] :
      ( v199(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v202(VarCurr,B)
          <=> v172(VarCurr,B) ) ) ) ).

tff(addAssignment_43,axiom,
    ! [VarCurr: state_type] :
      ( v201(VarCurr,49)
    <=> v94(VarCurr,399) ) ).

tff(addAssignment_42,axiom,
    ! [VarCurr: state_type] :
      ( v199(VarCurr)
    <=> v103(VarCurr,2) ) ).

tff(addAssignment_41,axiom,
    ! [VarCurr: state_type] :
      ( v99(VarCurr,49)
    <=> v195(VarCurr,49) ) ).

tff(aaddConditionBooleanCondEqualRangesElseBranch_3,axiom,
    ! [VarCurr: state_type] :
      ( ~ v101(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v195(VarCurr,B)
          <=> v178(VarCurr,B) ) ) ) ).

tff(addConditionBooleanCondEqualRangesThenBranch_3,axiom,
    ! [VarCurr: state_type] :
      ( v101(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,70)
            & ~ $less(B,0) )
         => ( v195(VarCurr,B)
          <=> v172(VarCurr,B) ) ) ) ).

tff(addAssignment_40,axiom,
    ! [VarCurr: state_type] :
      ( v178(VarCurr,49)
    <=> v94(VarCurr,469) ) ).

tff(addAssignmentInitValue_74,axiom,
    ~ v94(constB0,559) ).

tff(addAssignmentInitValue_73,axiom,
    ~ v94(constB0,558) ).

tff(addAssignmentInitValue_72,axiom,
    ~ v94(constB0,557) ).

tff(addAssignmentInitValue_71,axiom,
    ~ v94(constB0,556) ).

tff(addAssignmentInitValue_70,axiom,
    ~ v94(constB0,555) ).

tff(addAssignmentInitValue_69,axiom,
    ~ v94(constB0,554) ).

tff(addAssignmentInitValue_68,axiom,
    ~ v94(constB0,553) ).

tff(addAssignmentInitValue_67,axiom,
    ~ v94(constB0,539) ).

tff(bitBlastConstant_82,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(69) ).

tff(bitBlastConstant_81,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(68) ).

tff(bitBlastConstant_80,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(67) ).

tff(bitBlastConstant_79,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(66) ).

tff(bitBlastConstant_78,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(65) ).

tff(bitBlastConstant_77,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(64) ).

tff(bitBlastConstant_76,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(63) ).

tff(bitBlastConstant_75,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(49) ).

tff(addAssignmentInitValue_66,axiom,
    ~ v94(constB0,489) ).

tff(addAssignmentInitValue_65,axiom,
    ~ v94(constB0,488) ).

tff(addAssignmentInitValue_64,axiom,
    ~ v94(constB0,487) ).

tff(addAssignmentInitValue_63,axiom,
    ~ v94(constB0,486) ).

tff(addAssignmentInitValue_62,axiom,
    ~ v94(constB0,485) ).

tff(addAssignmentInitValue_61,axiom,
    ~ v94(constB0,484) ).

tff(addAssignmentInitValue_60,axiom,
    ~ v94(constB0,483) ).

tff(addAssignmentInitValue_59,axiom,
    ~ v94(constB0,469) ).

tff(bitBlastConstant_74,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(69) ).

tff(bitBlastConstant_73,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(68) ).

tff(bitBlastConstant_72,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(67) ).

tff(bitBlastConstant_71,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(66) ).

tff(bitBlastConstant_70,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(65) ).

tff(bitBlastConstant_69,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(64) ).

tff(bitBlastConstant_68,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(63) ).

tff(bitBlastConstant_67,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(49) ).

tff(addAssignmentInitValue_58,axiom,
    ~ v94(constB0,419) ).

tff(addAssignmentInitValue_57,axiom,
    ~ v94(constB0,418) ).

tff(addAssignmentInitValue_56,axiom,
    ~ v94(constB0,417) ).

tff(addAssignmentInitValue_55,axiom,
    ~ v94(constB0,416) ).

tff(addAssignmentInitValue_54,axiom,
    ~ v94(constB0,415) ).

tff(addAssignmentInitValue_53,axiom,
    ~ v94(constB0,414) ).

tff(addAssignmentInitValue_52,axiom,
    ~ v94(constB0,413) ).

tff(addAssignmentInitValue_51,axiom,
    ~ v94(constB0,399) ).

tff(bitBlastConstant_66,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(69) ).

tff(bitBlastConstant_65,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(68) ).

tff(bitBlastConstant_64,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(67) ).

tff(bitBlastConstant_63,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(66) ).

tff(bitBlastConstant_62,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(65) ).

tff(bitBlastConstant_61,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(64) ).

tff(bitBlastConstant_60,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(63) ).

tff(bitBlastConstant_59,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(49) ).

tff(addAssignmentInitValue_50,axiom,
    ~ v94(constB0,349) ).

tff(addAssignmentInitValue_49,axiom,
    ~ v94(constB0,348) ).

tff(addAssignmentInitValue_48,axiom,
    ~ v94(constB0,347) ).

tff(addAssignmentInitValue_47,axiom,
    ~ v94(constB0,346) ).

tff(addAssignmentInitValue_46,axiom,
    ~ v94(constB0,345) ).

tff(addAssignmentInitValue_45,axiom,
    ~ v94(constB0,344) ).

tff(addAssignmentInitValue_44,axiom,
    ~ v94(constB0,343) ).

tff(addAssignmentInitValue_43,axiom,
    ~ v94(constB0,329) ).

tff(bitBlastConstant_58,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(69) ).

tff(bitBlastConstant_57,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(68) ).

tff(bitBlastConstant_56,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(67) ).

tff(bitBlastConstant_55,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(66) ).

tff(bitBlastConstant_54,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(65) ).

tff(bitBlastConstant_53,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(64) ).

tff(bitBlastConstant_52,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(63) ).

tff(bitBlastConstant_51,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(49) ).

tff(addAssignmentInitValue_42,axiom,
    ~ v94(constB0,279) ).

tff(addAssignmentInitValue_41,axiom,
    ~ v94(constB0,278) ).

tff(addAssignmentInitValue_40,axiom,
    ~ v94(constB0,277) ).

tff(addAssignmentInitValue_39,axiom,
    ~ v94(constB0,276) ).

tff(addAssignmentInitValue_38,axiom,
    ~ v94(constB0,275) ).

tff(addAssignmentInitValue_37,axiom,
    ~ v94(constB0,274) ).

tff(addAssignmentInitValue_36,axiom,
    ~ v94(constB0,273) ).

tff(addAssignmentInitValue_35,axiom,
    ~ v94(constB0,259) ).

tff(bitBlastConstant_50,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(69) ).

tff(bitBlastConstant_49,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(68) ).

tff(bitBlastConstant_48,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(67) ).

tff(bitBlastConstant_47,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(66) ).

tff(bitBlastConstant_46,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(65) ).

tff(bitBlastConstant_45,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(64) ).

tff(bitBlastConstant_44,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(63) ).

tff(bitBlastConstant_43,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(49) ).

tff(addAssignmentInitValue_34,axiom,
    ~ v94(constB0,209) ).

tff(addAssignmentInitValue_33,axiom,
    ~ v94(constB0,208) ).

tff(addAssignmentInitValue_32,axiom,
    ~ v94(constB0,207) ).

tff(addAssignmentInitValue_31,axiom,
    ~ v94(constB0,206) ).

tff(addAssignmentInitValue_30,axiom,
    ~ v94(constB0,205) ).

tff(addAssignmentInitValue_29,axiom,
    ~ v94(constB0,204) ).

tff(addAssignmentInitValue_28,axiom,
    ~ v94(constB0,203) ).

tff(addAssignmentInitValue_27,axiom,
    ~ v94(constB0,189) ).

tff(bitBlastConstant_42,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(69) ).

tff(bitBlastConstant_41,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(68) ).

tff(bitBlastConstant_40,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(67) ).

tff(bitBlastConstant_39,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(66) ).

tff(bitBlastConstant_38,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(65) ).

tff(bitBlastConstant_37,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(64) ).

tff(bitBlastConstant_36,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(63) ).

tff(bitBlastConstant_35,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(49) ).

tff(addAssignmentInitValue_26,axiom,
    ~ v94(constB0,139) ).

tff(addAssignmentInitValue_25,axiom,
    ~ v94(constB0,138) ).

tff(addAssignmentInitValue_24,axiom,
    ~ v94(constB0,137) ).

tff(addAssignmentInitValue_23,axiom,
    ~ v94(constB0,136) ).

tff(addAssignmentInitValue_22,axiom,
    ~ v94(constB0,135) ).

tff(addAssignmentInitValue_21,axiom,
    ~ v94(constB0,134) ).

tff(addAssignmentInitValue_20,axiom,
    ~ v94(constB0,133) ).

tff(addAssignmentInitValue_19,axiom,
    ~ v94(constB0,119) ).

tff(bitBlastConstant_34,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(69) ).

tff(bitBlastConstant_33,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(68) ).

tff(bitBlastConstant_32,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(67) ).

tff(bitBlastConstant_31,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(66) ).

tff(bitBlastConstant_30,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(65) ).

tff(bitBlastConstant_29,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(64) ).

tff(bitBlastConstant_28,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(63) ).

tff(bitBlastConstant_27,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(49) ).

tff(addAssignmentInitValue_18,axiom,
    ~ v94(constB0,69) ).

tff(addAssignmentInitValue_17,axiom,
    ~ v94(constB0,68) ).

tff(addAssignmentInitValue_16,axiom,
    ~ v94(constB0,67) ).

tff(addAssignmentInitValue_15,axiom,
    ~ v94(constB0,66) ).

tff(addAssignmentInitValue_14,axiom,
    ~ v94(constB0,65) ).

tff(addAssignmentInitValue_13,axiom,
    ~ v94(constB0,64) ).

tff(addAssignmentInitValue_12,axiom,
    ~ v94(constB0,63) ).

tff(addAssignmentInitValue_11,axiom,
    ~ v94(constB0,49) ).

tff(bitBlastConstant_26,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(69) ).

tff(bitBlastConstant_25,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(68) ).

tff(bitBlastConstant_24,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(67) ).

tff(bitBlastConstant_23,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(66) ).

tff(bitBlastConstant_22,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(65) ).

tff(bitBlastConstant_21,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(64) ).

tff(bitBlastConstant_20,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(63) ).

tff(bitBlastConstant_19,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(49) ).

tff(addAssignment_39,axiom,
    ! [VarCurr: state_type] :
      ( v172(VarCurr,49)
    <=> v174(VarCurr,49) ) ).

tff(addAssignment_38,axiom,
    ! [VarCurr: state_type] :
      ( v174(VarCurr,49)
    <=> v176(VarCurr,49) ) ).

tff(addAssignment_37,axiom,
    ! [VarCurr: state_type] :
      ( v101(VarCurr)
    <=> v103(VarCurr,2) ) ).

tff(addAssignment_36,axiom,
    ! [VarCurr: state_type] :
      ( v103(VarCurr,2)
    <=> v131(VarCurr,2) ) ).

tff(addAssignment_35,axiom,
    ! [VarNext: state_type] :
      ( v107(VarNext,1)
    <=> v164(VarNext,1) ) ).

tff(addCaseBooleanConditionEqualRanges1_3,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v165(VarNext)
       => ! [B: $int] :
            ( ( $less(B,11)
              & ~ $less(B,0) )
           => ( v164(VarNext,B)
            <=> v107(VarCurr,B) ) ) ) ) ).

tff(addCaseBooleanConditionEqualRanges0_3,axiom,
    ! [VarNext: state_type] :
      ( v165(VarNext)
     => ! [B: $int] :
          ( ( $less(B,11)
            & ~ $less(B,0) )
         => ( v164(VarNext,B)
          <=> v125(VarNext,B) ) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_9,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v165(VarNext)
      <=> v166(VarNext) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_8,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v166(VarNext)
      <=> ( v168(VarNext)
          & v110(VarNext) ) ) ) ).

tff(writeUnaryOperator_6,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v168(VarNext)
      <=> v119(VarNext) ) ) ).

tff(addAssignment_34,axiom,
    ! [VarCurr: state_type] :
      ( v103(VarCurr,1)
    <=> v131(VarCurr,1) ) ).

tff(addAssignment_33,axiom,
    ! [VarNext: state_type] :
      ( v107(VarNext,0)
    <=> v156(VarNext,0) ) ).

tff(addCaseBooleanConditionEqualRanges1_2,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v157(VarNext)
       => ! [B: $int] :
            ( ( $less(B,11)
              & ~ $less(B,0) )
           => ( v156(VarNext,B)
            <=> v107(VarCurr,B) ) ) ) ) ).

tff(addCaseBooleanConditionEqualRanges0_2,axiom,
    ! [VarNext: state_type] :
      ( v157(VarNext)
     => ! [B: $int] :
          ( ( $less(B,11)
            & ~ $less(B,0) )
         => ( v156(VarNext,B)
          <=> v125(VarNext,B) ) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_7,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v157(VarNext)
      <=> v158(VarNext) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_6,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v158(VarNext)
      <=> ( v160(VarNext)
          & v110(VarNext) ) ) ) ).

tff(writeUnaryOperator_5,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v160(VarNext)
      <=> v119(VarNext) ) ) ).

tff(addAssignment_32,axiom,
    ! [VarCurr: state_type] :
      ( v103(VarCurr,0)
    <=> v131(VarCurr,0) ) ).

tff(addAssignment_31,axiom,
    ! [VarCurr: state_type] :
      ( v105(VarCurr,1)
    <=> v129(VarCurr,1) ) ).

tff(addAssignment_30,axiom,
    ! [VarNext: state_type] :
      ( v107(VarNext,3)
    <=> v148(VarNext,3) ) ).

tff(addCaseBooleanConditionEqualRanges1_1,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v149(VarNext)
       => ! [B: $int] :
            ( ( $less(B,11)
              & ~ $less(B,0) )
           => ( v148(VarNext,B)
            <=> v107(VarCurr,B) ) ) ) ) ).

tff(addCaseBooleanConditionEqualRanges0_1,axiom,
    ! [VarNext: state_type] :
      ( v149(VarNext)
     => ! [B: $int] :
          ( ( $less(B,11)
            & ~ $less(B,0) )
         => ( v148(VarNext,B)
          <=> v125(VarNext,B) ) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_5,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v149(VarNext)
      <=> v150(VarNext) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_4,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v150(VarNext)
      <=> ( v152(VarNext)
          & v110(VarNext) ) ) ) ).

tff(writeUnaryOperator_4,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v152(VarNext)
      <=> v119(VarNext) ) ) ).

tff(addAssignment_29,axiom,
    ! [VarCurr: state_type] :
      ( v103(VarCurr,3)
    <=> v131(VarCurr,3) ) ).

tff(aaddConditionBooleanCondEqualRangesElseBranch_2,axiom,
    ! [VarCurr: state_type] :
      ( ~ v132(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,11)
            & ~ $less(B,0) )
         => ( v131(VarCurr,B)
          <=> v134(VarCurr,B) ) ) ) ).

tff(addConditionBooleanCondEqualRangesThenBranch_2,axiom,
    ! [VarCurr: state_type] :
      ( v132(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,11)
            & ~ $less(B,0) )
         => ( v131(VarCurr,B)
          <=> v133(VarCurr,B) ) ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges3,axiom,
    ! [VarCurr: state_type] :
      ( ( ~ v135(VarCurr)
        & ~ v137(VarCurr)
        & ~ v141(VarCurr) )
     => ! [B: $int] :
          ( ( $less(B,11)
            & ~ $less(B,0) )
         => ( v134(VarCurr,B)
          <=> v107(VarCurr,B) ) ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges2,axiom,
    ! [VarCurr: state_type] :
      ( v141(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,11)
            & ~ $less(B,0) )
         => ( v134(VarCurr,B)
          <=> v143(VarCurr,B) ) ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges1,axiom,
    ! [VarCurr: state_type] :
      ( v137(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,11)
            & ~ $less(B,0) )
         => ( v134(VarCurr,B)
          <=> v139(VarCurr,B) ) ) ) ).

tff(addParallelCaseBooleanConditionEqualRanges0,axiom,
    ! [VarCurr: state_type] :
      ( v135(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,11)
            & ~ $less(B,0) )
         => ( v134(VarCurr,B)
          <=> v107(VarCurr,B) ) ) ) ).

tff(addBitVectorEqualityBitBlasted_5,axiom,
    ! [VarCurr: state_type] :
      ( v145(VarCurr)
    <=> ( ( v146(VarCurr,1)
        <=> $true )
        & ( v146(VarCurr,0)
        <=> $true ) ) ) ).

tff(bitBlastConstant_18,axiom,
    b11(1) ).

tff(bitBlastConstant_17,axiom,
    b11(0) ).

tff(addAssignment_28,axiom,
    ! [VarCurr: state_type] :
      ( v146(VarCurr,0)
    <=> v43(VarCurr) ) ).

tff(addAssignment_27,axiom,
    ! [VarCurr: state_type] :
      ( v146(VarCurr,1)
    <=> v36(VarCurr) ) ).

tff(addAssignment_26,axiom,
    ! [VarCurr: state_type] :
      ( v143(VarCurr,0)
    <=> $false ) ).

tff(addAssignment_25,axiom,
    ! [VarCurr: state_type] :
      ( ( v143(VarCurr,10)
      <=> v107(VarCurr,9) )
      & ( v143(VarCurr,9)
      <=> v107(VarCurr,8) )
      & ( v143(VarCurr,8)
      <=> v107(VarCurr,7) )
      & ( v143(VarCurr,7)
      <=> v107(VarCurr,6) )
      & ( v143(VarCurr,6)
      <=> v107(VarCurr,5) )
      & ( v143(VarCurr,5)
      <=> v107(VarCurr,4) )
      & ( v143(VarCurr,4)
      <=> v107(VarCurr,3) )
      & ( v143(VarCurr,3)
      <=> v107(VarCurr,2) )
      & ( v143(VarCurr,2)
      <=> v107(VarCurr,1) )
      & ( v143(VarCurr,1)
      <=> v107(VarCurr,0) ) ) ).

tff(addBitVectorEqualityBitBlasted_4,axiom,
    ! [VarCurr: state_type] :
      ( v141(VarCurr)
    <=> ( ( v142(VarCurr,1)
        <=> $true )
        & ( v142(VarCurr,0)
        <=> $false ) ) ) ).

tff(bitBlastConstant_16,axiom,
    b10(1) ).

tff(bitBlastConstant_15,axiom,
    ~ b10(0) ).

tff(addAssignment_24,axiom,
    ! [VarCurr: state_type] :
      ( v142(VarCurr,0)
    <=> v43(VarCurr) ) ).

tff(addAssignment_23,axiom,
    ! [VarCurr: state_type] :
      ( v142(VarCurr,1)
    <=> v36(VarCurr) ) ).

tff(addAssignment_22,axiom,
    ! [VarCurr: state_type] :
      ( ( v139(VarCurr,9)
      <=> v107(VarCurr,10) )
      & ( v139(VarCurr,8)
      <=> v107(VarCurr,9) )
      & ( v139(VarCurr,7)
      <=> v107(VarCurr,8) )
      & ( v139(VarCurr,6)
      <=> v107(VarCurr,7) )
      & ( v139(VarCurr,5)
      <=> v107(VarCurr,6) )
      & ( v139(VarCurr,4)
      <=> v107(VarCurr,5) )
      & ( v139(VarCurr,3)
      <=> v107(VarCurr,4) )
      & ( v139(VarCurr,2)
      <=> v107(VarCurr,3) )
      & ( v139(VarCurr,1)
      <=> v107(VarCurr,2) )
      & ( v139(VarCurr,0)
      <=> v107(VarCurr,1) ) ) ).

tff(addAssignment_21,axiom,
    ! [VarCurr: state_type] :
      ( v139(VarCurr,10)
    <=> $false ) ).

tff(addBitVectorEqualityBitBlasted_3,axiom,
    ! [VarCurr: state_type] :
      ( v137(VarCurr)
    <=> ( ( v138(VarCurr,1)
        <=> $false )
        & ( v138(VarCurr,0)
        <=> $true ) ) ) ).

tff(bitBlastConstant_14,axiom,
    ~ b01(1) ).

tff(bitBlastConstant_13,axiom,
    b01(0) ).

tff(addAssignment_20,axiom,
    ! [VarCurr: state_type] :
      ( v138(VarCurr,0)
    <=> v43(VarCurr) ) ).

tff(addAssignment_19,axiom,
    ! [VarCurr: state_type] :
      ( v138(VarCurr,1)
    <=> v36(VarCurr) ) ).

tff(addBitVectorEqualityBitBlasted_2,axiom,
    ! [VarCurr: state_type] :
      ( v135(VarCurr)
    <=> ( ( v136(VarCurr,1)
        <=> $false )
        & ( v136(VarCurr,0)
        <=> $false ) ) ) ).

tff(addAssignment_18,axiom,
    ! [VarCurr: state_type] :
      ( v136(VarCurr,0)
    <=> v43(VarCurr) ) ).

tff(addAssignment_17,axiom,
    ! [VarCurr: state_type] :
      ( v136(VarCurr,1)
    <=> v36(VarCurr) ) ).

tff(addAssignment_16,axiom,
    ! [VarCurr: state_type] :
      ( v133(VarCurr,0)
    <=> $true ) ).

tff(addAssignment_15,axiom,
    ! [VarCurr: state_type,B: $int] :
      ( ( $less(B,11)
        & ~ $less(B,1) )
     => ( v133(VarCurr,B)
      <=> v105(VarCurr,B) ) ) ).

tff(writeUnaryOperator_3,axiom,
    ! [VarCurr: state_type] :
      ( ~ v132(VarCurr)
    <=> v34(VarCurr) ) ).

tff(addAssignment_14,axiom,
    ! [VarCurr: state_type] :
      ( v105(VarCurr,3)
    <=> v129(VarCurr,3) ) ).

tff(addAssignment_13,axiom,
    ! [VarCurr: state_type] :
      ( v105(VarCurr,2)
    <=> v129(VarCurr,2) ) ).

tff(addAssignment_12,axiom,
    ! [VarCurr: state_type] :
      ( v129(VarCurr,0)
    <=> $true ) ).

tff(addAssignment_11,axiom,
    ! [VarCurr: state_type,B: $int] :
      ( ( $less(B,11)
        & ~ $less(B,1) )
     => ( v129(VarCurr,B)
      <=> v107(VarCurr,B) ) ) ).

tff(addAssignment_10,axiom,
    ! [VarNext: state_type] :
      ( v107(VarNext,2)
    <=> v114(VarNext,2) ) ).

tff(addCaseBooleanConditionEqualRanges1,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v115(VarNext)
       => ! [B: $int] :
            ( ( $less(B,11)
              & ~ $less(B,0) )
           => ( v114(VarNext,B)
            <=> v107(VarCurr,B) ) ) ) ) ).

tff(addCaseBooleanConditionEqualRanges0,axiom,
    ! [VarNext: state_type] :
      ( v115(VarNext)
     => ! [B: $int] :
          ( ( $less(B,11)
            & ~ $less(B,0) )
         => ( v114(VarNext,B)
          <=> v125(VarNext,B) ) ) ) ).

tff(addAssignment_9,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ! [B: $int] :
          ( ( $less(B,11)
            & ~ $less(B,0) )
         => ( v125(VarNext,B)
          <=> v123(VarCurr,B) ) ) ) ).

tff(aaddConditionBooleanCondEqualRangesElseBranch_1,axiom,
    ! [VarCurr: state_type] :
      ( ~ v126(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,11)
            & ~ $less(B,0) )
         => ( v123(VarCurr,B)
          <=> v103(VarCurr,B) ) ) ) ).

tff(addConditionBooleanCondEqualRangesThenBranch_1,axiom,
    ! [VarCurr: state_type] :
      ( v126(VarCurr)
     => ! [B: $int] :
          ( ( $less(B,11)
            & ~ $less(B,0) )
         => ( v123(VarCurr,B)
          <=> b00000000001(B) ) ) ) ).

tff(writeUnaryOperator_2,axiom,
    ! [VarCurr: state_type] :
      ( ~ v126(VarCurr)
    <=> v34(VarCurr) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_3,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v115(VarNext)
      <=> v116(VarNext) ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_2,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v116(VarNext)
      <=> ( v117(VarNext)
          & v110(VarNext) ) ) ) ).

tff(writeUnaryOperator_1,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v117(VarNext)
      <=> v119(VarNext) ) ) ).

tff(addAssignment_8,axiom,
    ! [VarNext: state_type,VarCurr: state_type] :
      ( nextState(VarCurr,VarNext)
     => ( v119(VarNext)
      <=> v110(VarCurr) ) ) ).

tff(addAssignmentInitValue_10,axiom,
    ~ v107(constB0,10) ).

tff(addAssignmentInitValue_9,axiom,
    ~ v107(constB0,9) ).

tff(addAssignmentInitValue_8,axiom,
    ~ v107(constB0,8) ).

tff(addAssignmentInitValue_7,axiom,
    ~ v107(constB0,7) ).

tff(addAssignmentInitValue_6,axiom,
    ~ v107(constB0,6) ).

tff(addAssignmentInitValue_5,axiom,
    ~ v107(constB0,5) ).

tff(addAssignmentInitValue_4,axiom,
    ~ v107(constB0,4) ).

tff(addAssignmentInitValue_3,axiom,
    ~ v107(constB0,3) ).

tff(addAssignmentInitValue_2,axiom,
    ~ v107(constB0,2) ).

tff(addAssignmentInitValue_1,axiom,
    ~ v107(constB0,1) ).

tff(addAssignmentInitValue,axiom,
    v107(constB0,0) ).

tff(bitBlastConstant_12,axiom,
    ~ b00000000001(10) ).

tff(bitBlastConstant_11,axiom,
    ~ b00000000001(9) ).

tff(bitBlastConstant_10,axiom,
    ~ b00000000001(8) ).

tff(bitBlastConstant_9,axiom,
    ~ b00000000001(7) ).

tff(bitBlastConstant_8,axiom,
    ~ b00000000001(6) ).

tff(bitBlastConstant_7,axiom,
    ~ b00000000001(5) ).

tff(bitBlastConstant_6,axiom,
    ~ b00000000001(4) ).

tff(bitBlastConstant_5,axiom,
    ~ b00000000001(3) ).

tff(bitBlastConstant_4,axiom,
    ~ b00000000001(2) ).

tff(bitBlastConstant_3,axiom,
    ~ b00000000001(1) ).

tff(bitBlastConstant_2,axiom,
    b00000000001(0) ).

tff(addAssignment_7,axiom,
    ! [VarCurr: state_type] :
      ( v110(VarCurr)
    <=> v112(VarCurr) ) ).

tff(addAssignment_6,axiom,
    ! [VarCurr: state_type] :
      ( v112(VarCurr)
    <=> v1(VarCurr) ) ).

tff(addAssignment_5,axiom,
    ! [VarCurr: state_type] :
      ( v64(VarCurr)
    <=> v11(VarCurr) ) ).

tff(aaddConditionBooleanCondEqualRangesElseBranch,axiom,
    ! [VarCurr: state_type] :
      ( ~ v50(VarCurr)
     => ( v47(VarCurr)
      <=> $false ) ) ).

tff(addConditionBooleanCondEqualRangesThenBranch,axiom,
    ! [VarCurr: state_type] :
      ( v50(VarCurr)
     => ( v47(VarCurr)
      <=> $true ) ) ).

tff(writeBinaryOperatorEqualRangesSingleBits_1,axiom,
    ! [VarCurr: state_type] :
      ( v50(VarCurr)
    <=> ( v51(VarCurr)
        & v54(VarCurr) ) ) ).

tff(addBitVectorEqualityBitBlasted_1,axiom,
    ! [VarCurr: state_type] :
      ( v54(VarCurr)
    <=> ( $true
      <=> v7(VarCurr,0) ) ) ).

tff(addAssignmentInitValueVector_1,axiom,
    ( ( v7(constB0,2)
    <=> $false )
    & ( v7(constB0,1)
    <=> $false ) ) ).

tff(addAssignmentInitValueVector,axiom,
    ( v7(constB0,0)
  <=> $true ) ).

tff(writeBinaryOperatorEqualRangesSingleBits,axiom,
    ! [VarCurr: state_type] :
      ( v51(VarCurr)
    <=> ( v52(VarCurr)
        & v53(VarCurr) ) ) ).

tff(writeUnaryOperator,axiom,
    ! [VarCurr: state_type] :
      ( ~ v53(VarCurr)
    <=> v30(VarCurr) ) ).

tff(addBitVectorEqualityBitBlasted,axiom,
    ! [VarCurr: state_type] :
      ( v52(VarCurr)
    <=> ( ( v28(VarCurr,1)
        <=> $false )
        & ( v28(VarCurr,0)
        <=> $false ) ) ) ).

tff(bitBlastConstant_1,axiom,
    ~ b00(1) ).

tff(bitBlastConstant,axiom,
    ~ b00(0) ).

tff(addAssignment_4,axiom,
    ! [VarCurr: state_type] :
      ( v36(VarCurr)
    <=> v38(VarCurr) ) ).

tff(addAssignment_3,axiom,
    ! [VarCurr: state_type] :
      ( v38(VarCurr)
    <=> v40(VarCurr) ) ).

tff(addAssignment_2,axiom,
    ! [VarCurr: state_type] :
      ( v34(VarCurr)
    <=> v9(VarCurr) ) ).

tff(addAssignment_1,axiom,
    ! [VarCurr: state_type] :
      ( v22(VarCurr)
    <=> v24(VarCurr) ) ).

tff(addAssignment,axiom,
    ! [VarCurr: state_type] :
      ( v9(VarCurr)
    <=> v11(VarCurr) ) ).

%------------------------------------------------------------------------------
