%------------------------------------------------------------------------------
% File     : HWV109+1 : TPTP v9.2.0. Released v6.1.0.
% Domain   : Hardware Verification
% Problem  : dmu_dmc property 19 cone of influence 3_b20
% Version  : Especial.
% English  : Verification of a property of the SPARCT2 RTL hardware design.

% Refs     : [Kha14] Khasidashvili (2014), Email to Geoff Sutcliffe
% Source   : [Kha14]
% Names    : dmu_dmc_prop19_cone3_b20 [Kha14]

% Status   : CounterSatisfiable
% Rating   : 0.00 v7.4.0, 0.33 v7.3.0, 0.50 v7.2.0, 0.33 v7.1.0, 0.67 v7.0.0, 0.50 v6.4.0, 0.67 v6.3.0, 1.00 v6.1.0
% Syntax   : Number of formulae    : 1277 ( 417 unt;   0 def)
%            Number of atoms       : 3557 ( 456 equ)
%            Maximal formula atoms :  299 (   2 avg)
%            Number of connectives : 2862 ( 582   ~; 704   |; 337   &)
%                                         (1043 <=>; 196  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  152 (   4 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of predicates  :  784 ( 781 usr;   2 prp; 0-3 aty)
%            Number of functors    :  212 ( 212 usr; 212 con; 0-0 aty)
%            Number of variables   : 1007 (1007   !;   0   ?)
% SPC      : FOF_CSA_RFO_SEQ

% Comments : Copyright 2013 Moshe Emmer and Zurab Khasidashvili
%            Licensed under the Apache License, Version 2.0 (the "License");
%            you may not use this file except in compliance with the License.
%            You may obtain a copy of the License at
%                http://www.apache.org/licenses/LICENSE-2.0
%            Unless required by applicable law or agreed to in writing,
%            software distributed under the License is distributed on an "AS
%            IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
%            express or implied. See the License for the specific language
%            governing permissions and limitations under the License.
%------------------------------------------------------------------------------
fof(pathAxiom_8,axiom,
    nextState(constB8,constB9) ).

fof(pathAxiom_7,axiom,
    nextState(constB7,constB8) ).

fof(pathAxiom_6,axiom,
    nextState(constB6,constB7) ).

fof(pathAxiom_5,axiom,
    nextState(constB5,constB6) ).

fof(pathAxiom_4,axiom,
    nextState(constB4,constB5) ).

fof(pathAxiom_3,axiom,
    nextState(constB3,constB4) ).

fof(pathAxiom_2,axiom,
    nextState(constB2,constB3) ).

fof(pathAxiom_1,axiom,
    nextState(constB1,constB2) ).

fof(pathAxiom,axiom,
    nextState(constB0,constB1) ).

fof(reachableStateAxiom_22,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( reachableState(VarCurr)
        & reachableState(VarNext) ) ) ).

fof(reachableStateAxiom_21,axiom,
    ! [VarState] :
      ( reachableState(VarState)
     => ( constB0 = VarState
        | constB1 = VarState
        | constB2 = VarState
        | constB3 = VarState
        | constB4 = VarState
        | constB5 = VarState
        | constB6 = VarState
        | constB7 = VarState
        | constB8 = VarState
        | constB9 = VarState
        | constB10 = VarState
        | constB11 = VarState
        | constB12 = VarState
        | constB13 = VarState
        | constB14 = VarState
        | constB15 = VarState
        | constB16 = VarState
        | constB17 = VarState
        | constB18 = VarState
        | constB19 = VarState
        | constB20 = VarState ) ) ).

fof(reachableStateAxiom_20,axiom,
    reachableState(constB20) ).

fof(reachableStateAxiom_19,axiom,
    reachableState(constB19) ).

fof(reachableStateAxiom_18,axiom,
    reachableState(constB18) ).

fof(reachableStateAxiom_17,axiom,
    reachableState(constB17) ).

fof(reachableStateAxiom_16,axiom,
    reachableState(constB16) ).

fof(reachableStateAxiom_15,axiom,
    reachableState(constB15) ).

fof(reachableStateAxiom_14,axiom,
    reachableState(constB14) ).

fof(reachableStateAxiom_13,axiom,
    reachableState(constB13) ).

fof(reachableStateAxiom_12,axiom,
    reachableState(constB12) ).

fof(reachableStateAxiom_11,axiom,
    reachableState(constB11) ).

fof(reachableStateAxiom_10,axiom,
    reachableState(constB10) ).

fof(reachableStateAxiom_9,axiom,
    reachableState(constB9) ).

fof(reachableStateAxiom_8,axiom,
    reachableState(constB8) ).

fof(reachableStateAxiom_7,axiom,
    reachableState(constB7) ).

fof(reachableStateAxiom_6,axiom,
    reachableState(constB6) ).

fof(reachableStateAxiom_5,axiom,
    reachableState(constB5) ).

fof(reachableStateAxiom_4,axiom,
    reachableState(constB4) ).

fof(reachableStateAxiom_3,axiom,
    reachableState(constB3) ).

fof(reachableStateAxiom_2,axiom,
    reachableState(constB2) ).

fof(reachableStateAxiom_1,axiom,
    reachableState(constB1) ).

fof(reachableStateAxiom,axiom,
    reachableState(constB0) ).

fof(clock_toggling,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1(VarCurr)
      <=> ~ v1(VarNext) ) ) ).

fof(clock_pattern,axiom,
    ~ v1(constB0) ).

fof(transient_address_definition_41,axiom,
    ! [B] :
      ( addressVal(v909_range_3_to_0_address_term_bound_20,B)
    <=> v909(constB20,B) ) ).

fof(is_address_41,axiom,
    address(v909_range_3_to_0_address_term_bound_20) ).

fof(address_association_41,axiom,
    v909_range_3_to_0_address_association(constB20,v909_range_3_to_0_address_term_bound_20) ).

fof(transient_address_definition_40,axiom,
    ! [B] :
      ( addressVal(v909_range_3_to_0_address_term_bound_19,B)
    <=> v909(constB19,B) ) ).

fof(is_address_40,axiom,
    address(v909_range_3_to_0_address_term_bound_19) ).

fof(address_association_40,axiom,
    v909_range_3_to_0_address_association(constB19,v909_range_3_to_0_address_term_bound_19) ).

fof(transient_address_definition_39,axiom,
    ! [B] :
      ( addressVal(v909_range_3_to_0_address_term_bound_18,B)
    <=> v909(constB18,B) ) ).

fof(is_address_39,axiom,
    address(v909_range_3_to_0_address_term_bound_18) ).

fof(address_association_39,axiom,
    v909_range_3_to_0_address_association(constB18,v909_range_3_to_0_address_term_bound_18) ).

fof(transient_address_definition_38,axiom,
    ! [B] :
      ( addressVal(v909_range_3_to_0_address_term_bound_17,B)
    <=> v909(constB17,B) ) ).

fof(is_address_38,axiom,
    address(v909_range_3_to_0_address_term_bound_17) ).

fof(address_association_38,axiom,
    v909_range_3_to_0_address_association(constB17,v909_range_3_to_0_address_term_bound_17) ).

fof(transient_address_definition_37,axiom,
    ! [B] :
      ( addressVal(v909_range_3_to_0_address_term_bound_16,B)
    <=> v909(constB16,B) ) ).

fof(is_address_37,axiom,
    address(v909_range_3_to_0_address_term_bound_16) ).

fof(address_association_37,axiom,
    v909_range_3_to_0_address_association(constB16,v909_range_3_to_0_address_term_bound_16) ).

fof(transient_address_definition_36,axiom,
    ! [B] :
      ( addressVal(v909_range_3_to_0_address_term_bound_15,B)
    <=> v909(constB15,B) ) ).

fof(is_address_36,axiom,
    address(v909_range_3_to_0_address_term_bound_15) ).

fof(address_association_36,axiom,
    v909_range_3_to_0_address_association(constB15,v909_range_3_to_0_address_term_bound_15) ).

fof(transient_address_definition_35,axiom,
    ! [B] :
      ( addressVal(v909_range_3_to_0_address_term_bound_14,B)
    <=> v909(constB14,B) ) ).

fof(is_address_35,axiom,
    address(v909_range_3_to_0_address_term_bound_14) ).

fof(address_association_35,axiom,
    v909_range_3_to_0_address_association(constB14,v909_range_3_to_0_address_term_bound_14) ).

fof(transient_address_definition_34,axiom,
    ! [B] :
      ( addressVal(v909_range_3_to_0_address_term_bound_13,B)
    <=> v909(constB13,B) ) ).

fof(is_address_34,axiom,
    address(v909_range_3_to_0_address_term_bound_13) ).

fof(address_association_34,axiom,
    v909_range_3_to_0_address_association(constB13,v909_range_3_to_0_address_term_bound_13) ).

fof(transient_address_definition_33,axiom,
    ! [B] :
      ( addressVal(v909_range_3_to_0_address_term_bound_12,B)
    <=> v909(constB12,B) ) ).

fof(is_address_33,axiom,
    address(v909_range_3_to_0_address_term_bound_12) ).

fof(address_association_33,axiom,
    v909_range_3_to_0_address_association(constB12,v909_range_3_to_0_address_term_bound_12) ).

fof(transient_address_definition_32,axiom,
    ! [B] :
      ( addressVal(v909_range_3_to_0_address_term_bound_11,B)
    <=> v909(constB11,B) ) ).

fof(is_address_32,axiom,
    address(v909_range_3_to_0_address_term_bound_11) ).

fof(address_association_32,axiom,
    v909_range_3_to_0_address_association(constB11,v909_range_3_to_0_address_term_bound_11) ).

fof(transient_address_definition_31,axiom,
    ! [B] :
      ( addressVal(v909_range_3_to_0_address_term_bound_10,B)
    <=> v909(constB10,B) ) ).

fof(is_address_31,axiom,
    address(v909_range_3_to_0_address_term_bound_10) ).

fof(address_association_31,axiom,
    v909_range_3_to_0_address_association(constB10,v909_range_3_to_0_address_term_bound_10) ).

fof(transient_address_definition_30,axiom,
    ! [B] :
      ( addressVal(v909_range_3_to_0_address_term_bound_9,B)
    <=> v909(constB9,B) ) ).

fof(is_address_30,axiom,
    address(v909_range_3_to_0_address_term_bound_9) ).

fof(address_association_30,axiom,
    v909_range_3_to_0_address_association(constB9,v909_range_3_to_0_address_term_bound_9) ).

fof(transient_address_definition_29,axiom,
    ! [B] :
      ( addressVal(v909_range_3_to_0_address_term_bound_8,B)
    <=> v909(constB8,B) ) ).

fof(is_address_29,axiom,
    address(v909_range_3_to_0_address_term_bound_8) ).

fof(address_association_29,axiom,
    v909_range_3_to_0_address_association(constB8,v909_range_3_to_0_address_term_bound_8) ).

fof(transient_address_definition_28,axiom,
    ! [B] :
      ( addressVal(v909_range_3_to_0_address_term_bound_7,B)
    <=> v909(constB7,B) ) ).

fof(is_address_28,axiom,
    address(v909_range_3_to_0_address_term_bound_7) ).

fof(address_association_28,axiom,
    v909_range_3_to_0_address_association(constB7,v909_range_3_to_0_address_term_bound_7) ).

fof(transient_address_definition_27,axiom,
    ! [B] :
      ( addressVal(v909_range_3_to_0_address_term_bound_6,B)
    <=> v909(constB6,B) ) ).

fof(is_address_27,axiom,
    address(v909_range_3_to_0_address_term_bound_6) ).

fof(address_association_27,axiom,
    v909_range_3_to_0_address_association(constB6,v909_range_3_to_0_address_term_bound_6) ).

fof(transient_address_definition_26,axiom,
    ! [B] :
      ( addressVal(v909_range_3_to_0_address_term_bound_5,B)
    <=> v909(constB5,B) ) ).

fof(is_address_26,axiom,
    address(v909_range_3_to_0_address_term_bound_5) ).

fof(address_association_26,axiom,
    v909_range_3_to_0_address_association(constB5,v909_range_3_to_0_address_term_bound_5) ).

fof(transient_address_definition_25,axiom,
    ! [B] :
      ( addressVal(v909_range_3_to_0_address_term_bound_4,B)
    <=> v909(constB4,B) ) ).

fof(is_address_25,axiom,
    address(v909_range_3_to_0_address_term_bound_4) ).

fof(address_association_25,axiom,
    v909_range_3_to_0_address_association(constB4,v909_range_3_to_0_address_term_bound_4) ).

fof(transient_address_definition_24,axiom,
    ! [B] :
      ( addressVal(v909_range_3_to_0_address_term_bound_3,B)
    <=> v909(constB3,B) ) ).

fof(is_address_24,axiom,
    address(v909_range_3_to_0_address_term_bound_3) ).

fof(address_association_24,axiom,
    v909_range_3_to_0_address_association(constB3,v909_range_3_to_0_address_term_bound_3) ).

fof(transient_address_definition_23,axiom,
    ! [B] :
      ( addressVal(v909_range_3_to_0_address_term_bound_2,B)
    <=> v909(constB2,B) ) ).

fof(is_address_23,axiom,
    address(v909_range_3_to_0_address_term_bound_2) ).

fof(address_association_23,axiom,
    v909_range_3_to_0_address_association(constB2,v909_range_3_to_0_address_term_bound_2) ).

fof(transient_address_definition_22,axiom,
    ! [B] :
      ( addressVal(v909_range_3_to_0_address_term_bound_1,B)
    <=> v909(constB1,B) ) ).

fof(is_address_22,axiom,
    address(v909_range_3_to_0_address_term_bound_1) ).

fof(address_association_22,axiom,
    v909_range_3_to_0_address_association(constB1,v909_range_3_to_0_address_term_bound_1) ).

fof(transient_address_definition_21,axiom,
    ! [B] :
      ( addressVal(v909_range_3_to_0_address_term_bound_0,B)
    <=> v909(constB0,B) ) ).

fof(is_address_21,axiom,
    address(v909_range_3_to_0_address_term_bound_0) ).

fof(address_association_21,axiom,
    v909_range_3_to_0_address_association(constB0,v909_range_3_to_0_address_term_bound_0) ).

fof(transient_address_definition_20,axiom,
    ! [B] :
      ( addressVal(v838_range_3_to_0_address_term_bound_20,B)
    <=> v838(constB20,B) ) ).

fof(is_address_20,axiom,
    address(v838_range_3_to_0_address_term_bound_20) ).

fof(address_association_20,axiom,
    v838_range_3_to_0_address_association(constB20,v838_range_3_to_0_address_term_bound_20) ).

fof(transient_address_definition_19,axiom,
    ! [B] :
      ( addressVal(v838_range_3_to_0_address_term_bound_19,B)
    <=> v838(constB19,B) ) ).

fof(is_address_19,axiom,
    address(v838_range_3_to_0_address_term_bound_19) ).

fof(address_association_19,axiom,
    v838_range_3_to_0_address_association(constB19,v838_range_3_to_0_address_term_bound_19) ).

fof(transient_address_definition_18,axiom,
    ! [B] :
      ( addressVal(v838_range_3_to_0_address_term_bound_18,B)
    <=> v838(constB18,B) ) ).

fof(is_address_18,axiom,
    address(v838_range_3_to_0_address_term_bound_18) ).

fof(address_association_18,axiom,
    v838_range_3_to_0_address_association(constB18,v838_range_3_to_0_address_term_bound_18) ).

fof(transient_address_definition_17,axiom,
    ! [B] :
      ( addressVal(v838_range_3_to_0_address_term_bound_17,B)
    <=> v838(constB17,B) ) ).

fof(is_address_17,axiom,
    address(v838_range_3_to_0_address_term_bound_17) ).

fof(address_association_17,axiom,
    v838_range_3_to_0_address_association(constB17,v838_range_3_to_0_address_term_bound_17) ).

fof(transient_address_definition_16,axiom,
    ! [B] :
      ( addressVal(v838_range_3_to_0_address_term_bound_16,B)
    <=> v838(constB16,B) ) ).

fof(is_address_16,axiom,
    address(v838_range_3_to_0_address_term_bound_16) ).

fof(address_association_16,axiom,
    v838_range_3_to_0_address_association(constB16,v838_range_3_to_0_address_term_bound_16) ).

fof(transient_address_definition_15,axiom,
    ! [B] :
      ( addressVal(v838_range_3_to_0_address_term_bound_15,B)
    <=> v838(constB15,B) ) ).

fof(is_address_15,axiom,
    address(v838_range_3_to_0_address_term_bound_15) ).

fof(address_association_15,axiom,
    v838_range_3_to_0_address_association(constB15,v838_range_3_to_0_address_term_bound_15) ).

fof(transient_address_definition_14,axiom,
    ! [B] :
      ( addressVal(v838_range_3_to_0_address_term_bound_14,B)
    <=> v838(constB14,B) ) ).

fof(is_address_14,axiom,
    address(v838_range_3_to_0_address_term_bound_14) ).

fof(address_association_14,axiom,
    v838_range_3_to_0_address_association(constB14,v838_range_3_to_0_address_term_bound_14) ).

fof(transient_address_definition_13,axiom,
    ! [B] :
      ( addressVal(v838_range_3_to_0_address_term_bound_13,B)
    <=> v838(constB13,B) ) ).

fof(is_address_13,axiom,
    address(v838_range_3_to_0_address_term_bound_13) ).

fof(address_association_13,axiom,
    v838_range_3_to_0_address_association(constB13,v838_range_3_to_0_address_term_bound_13) ).

fof(transient_address_definition_12,axiom,
    ! [B] :
      ( addressVal(v838_range_3_to_0_address_term_bound_12,B)
    <=> v838(constB12,B) ) ).

fof(is_address_12,axiom,
    address(v838_range_3_to_0_address_term_bound_12) ).

fof(address_association_12,axiom,
    v838_range_3_to_0_address_association(constB12,v838_range_3_to_0_address_term_bound_12) ).

fof(transient_address_definition_11,axiom,
    ! [B] :
      ( addressVal(v838_range_3_to_0_address_term_bound_11,B)
    <=> v838(constB11,B) ) ).

fof(is_address_11,axiom,
    address(v838_range_3_to_0_address_term_bound_11) ).

fof(address_association_11,axiom,
    v838_range_3_to_0_address_association(constB11,v838_range_3_to_0_address_term_bound_11) ).

fof(transient_address_definition_10,axiom,
    ! [B] :
      ( addressVal(v838_range_3_to_0_address_term_bound_10,B)
    <=> v838(constB10,B) ) ).

fof(is_address_10,axiom,
    address(v838_range_3_to_0_address_term_bound_10) ).

fof(address_association_10,axiom,
    v838_range_3_to_0_address_association(constB10,v838_range_3_to_0_address_term_bound_10) ).

fof(transient_address_definition_9,axiom,
    ! [B] :
      ( addressVal(v838_range_3_to_0_address_term_bound_9,B)
    <=> v838(constB9,B) ) ).

fof(is_address_9,axiom,
    address(v838_range_3_to_0_address_term_bound_9) ).

fof(address_association_9,axiom,
    v838_range_3_to_0_address_association(constB9,v838_range_3_to_0_address_term_bound_9) ).

fof(transient_address_definition_8,axiom,
    ! [B] :
      ( addressVal(v838_range_3_to_0_address_term_bound_8,B)
    <=> v838(constB8,B) ) ).

fof(is_address_8,axiom,
    address(v838_range_3_to_0_address_term_bound_8) ).

fof(address_association_8,axiom,
    v838_range_3_to_0_address_association(constB8,v838_range_3_to_0_address_term_bound_8) ).

fof(transient_address_definition_7,axiom,
    ! [B] :
      ( addressVal(v838_range_3_to_0_address_term_bound_7,B)
    <=> v838(constB7,B) ) ).

fof(is_address_7,axiom,
    address(v838_range_3_to_0_address_term_bound_7) ).

fof(address_association_7,axiom,
    v838_range_3_to_0_address_association(constB7,v838_range_3_to_0_address_term_bound_7) ).

fof(transient_address_definition_6,axiom,
    ! [B] :
      ( addressVal(v838_range_3_to_0_address_term_bound_6,B)
    <=> v838(constB6,B) ) ).

fof(is_address_6,axiom,
    address(v838_range_3_to_0_address_term_bound_6) ).

fof(address_association_6,axiom,
    v838_range_3_to_0_address_association(constB6,v838_range_3_to_0_address_term_bound_6) ).

fof(transient_address_definition_5,axiom,
    ! [B] :
      ( addressVal(v838_range_3_to_0_address_term_bound_5,B)
    <=> v838(constB5,B) ) ).

fof(is_address_5,axiom,
    address(v838_range_3_to_0_address_term_bound_5) ).

fof(address_association_5,axiom,
    v838_range_3_to_0_address_association(constB5,v838_range_3_to_0_address_term_bound_5) ).

fof(transient_address_definition_4,axiom,
    ! [B] :
      ( addressVal(v838_range_3_to_0_address_term_bound_4,B)
    <=> v838(constB4,B) ) ).

fof(is_address_4,axiom,
    address(v838_range_3_to_0_address_term_bound_4) ).

fof(address_association_4,axiom,
    v838_range_3_to_0_address_association(constB4,v838_range_3_to_0_address_term_bound_4) ).

fof(transient_address_definition_3,axiom,
    ! [B] :
      ( addressVal(v838_range_3_to_0_address_term_bound_3,B)
    <=> v838(constB3,B) ) ).

fof(is_address_3,axiom,
    address(v838_range_3_to_0_address_term_bound_3) ).

fof(address_association_3,axiom,
    v838_range_3_to_0_address_association(constB3,v838_range_3_to_0_address_term_bound_3) ).

fof(transient_address_definition_2,axiom,
    ! [B] :
      ( addressVal(v838_range_3_to_0_address_term_bound_2,B)
    <=> v838(constB2,B) ) ).

fof(is_address_2,axiom,
    address(v838_range_3_to_0_address_term_bound_2) ).

fof(address_association_2,axiom,
    v838_range_3_to_0_address_association(constB2,v838_range_3_to_0_address_term_bound_2) ).

fof(transient_address_definition_1,axiom,
    ! [B] :
      ( addressVal(v838_range_3_to_0_address_term_bound_1,B)
    <=> v838(constB1,B) ) ).

fof(is_address_1,axiom,
    address(v838_range_3_to_0_address_term_bound_1) ).

fof(address_association_1,axiom,
    v838_range_3_to_0_address_association(constB1,v838_range_3_to_0_address_term_bound_1) ).

fof(transient_address_definition,axiom,
    ! [B] :
      ( addressVal(v838_range_3_to_0_address_term_bound_0,B)
    <=> v838(constB0,B) ) ).

fof(is_address,axiom,
    address(v838_range_3_to_0_address_term_bound_0) ).

fof(address_association,axiom,
    v838_range_3_to_0_address_association(constB0,v838_range_3_to_0_address_term_bound_0) ).

fof(addressDiff,axiom,
    ! [B,A2,A1] :
      ( ( address(A1)
        & address(A2)
        & addressDiff(A1,A2,B) )
     => ( A1 = A2
        | ( addressVal(A1,B)
        <=> ~ addressVal(A2,B) ) ) ) ).

fof(addressDomain,axiom,
    ! [A1,A2] :
      ( addressDiff(A1,A2,bitIndex0)
      | addressDiff(A1,A2,bitIndex1)
      | addressDiff(A1,A2,bitIndex2)
      | addressDiff(A1,A2,bitIndex3) ) ).

fof(addAssertion,conjecture,
    ! [VarCurr] :
      ( reachableState(VarCurr)
     => v4(VarCurr) ) ).

fof(writeUnaryOperator_272,axiom,
    ! [VarCurr] :
      ( ~ v4(VarCurr)
    <=> v913(VarCurr) ) ).

fof(writeUnaryOperator_271,axiom,
    ! [VarCurr] :
      ( ~ v913(VarCurr)
    <=> v914(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_306,axiom,
    ! [VarCurr] :
      ( v914(VarCurr)
    <=> ( v916(VarCurr)
        & v925(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_97,axiom,
    ! [VarCurr] :
      ( v925(VarCurr)
    <=> ( v918(VarCurr,bitIndex0)
        | v918(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_270,axiom,
    ! [VarCurr] :
      ( ~ v916(VarCurr)
    <=> v917(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_96,axiom,
    ! [VarCurr] :
      ( v917(VarCurr)
    <=> ( v918(VarCurr,bitIndex0)
        & v918(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_70,axiom,
    ! [VarCurr] :
      ( v918(VarCurr,bitIndex0)
    <=> v919(VarCurr) ) ).

fof(addAssignment_69,axiom,
    ! [VarCurr] :
      ( v918(VarCurr,bitIndex1)
    <=> $false ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_305,axiom,
    ! [VarCurr] :
      ( v919(VarCurr)
    <=> ( v920(VarCurr)
        | v923(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted,axiom,
    ! [VarCurr] :
      ( v923(VarCurr)
    <=> ( ( v911(VarCurr,bitIndex148)
        <=> v924(VarCurr,bitIndex148) )
        & ( v911(VarCurr,bitIndex147)
        <=> v924(VarCurr,bitIndex147) )
        & ( v911(VarCurr,bitIndex146)
        <=> v924(VarCurr,bitIndex146) )
        & ( v911(VarCurr,bitIndex145)
        <=> v924(VarCurr,bitIndex145) )
        & ( v911(VarCurr,bitIndex144)
        <=> v924(VarCurr,bitIndex144) )
        & ( v911(VarCurr,bitIndex143)
        <=> v924(VarCurr,bitIndex143) )
        & ( v911(VarCurr,bitIndex142)
        <=> v924(VarCurr,bitIndex142) )
        & ( v911(VarCurr,bitIndex141)
        <=> v924(VarCurr,bitIndex141) )
        & ( v911(VarCurr,bitIndex140)
        <=> v924(VarCurr,bitIndex140) )
        & ( v911(VarCurr,bitIndex139)
        <=> v924(VarCurr,bitIndex139) )
        & ( v911(VarCurr,bitIndex138)
        <=> v924(VarCurr,bitIndex138) )
        & ( v911(VarCurr,bitIndex137)
        <=> v924(VarCurr,bitIndex137) )
        & ( v911(VarCurr,bitIndex136)
        <=> v924(VarCurr,bitIndex136) )
        & ( v911(VarCurr,bitIndex135)
        <=> v924(VarCurr,bitIndex135) )
        & ( v911(VarCurr,bitIndex134)
        <=> v924(VarCurr,bitIndex134) )
        & ( v911(VarCurr,bitIndex133)
        <=> v924(VarCurr,bitIndex133) )
        & ( v911(VarCurr,bitIndex132)
        <=> v924(VarCurr,bitIndex132) )
        & ( v911(VarCurr,bitIndex131)
        <=> v924(VarCurr,bitIndex131) )
        & ( v911(VarCurr,bitIndex130)
        <=> v924(VarCurr,bitIndex130) )
        & ( v911(VarCurr,bitIndex129)
        <=> v924(VarCurr,bitIndex129) )
        & ( v911(VarCurr,bitIndex128)
        <=> v924(VarCurr,bitIndex128) )
        & ( v911(VarCurr,bitIndex127)
        <=> v924(VarCurr,bitIndex127) )
        & ( v911(VarCurr,bitIndex126)
        <=> v924(VarCurr,bitIndex126) )
        & ( v911(VarCurr,bitIndex125)
        <=> v924(VarCurr,bitIndex125) )
        & ( v911(VarCurr,bitIndex124)
        <=> v924(VarCurr,bitIndex124) )
        & ( v911(VarCurr,bitIndex123)
        <=> v924(VarCurr,bitIndex123) )
        & ( v911(VarCurr,bitIndex122)
        <=> v924(VarCurr,bitIndex122) )
        & ( v911(VarCurr,bitIndex121)
        <=> v924(VarCurr,bitIndex121) )
        & ( v911(VarCurr,bitIndex120)
        <=> v924(VarCurr,bitIndex120) )
        & ( v911(VarCurr,bitIndex119)
        <=> v924(VarCurr,bitIndex119) )
        & ( v911(VarCurr,bitIndex118)
        <=> v924(VarCurr,bitIndex118) )
        & ( v911(VarCurr,bitIndex117)
        <=> v924(VarCurr,bitIndex117) )
        & ( v911(VarCurr,bitIndex116)
        <=> v924(VarCurr,bitIndex116) )
        & ( v911(VarCurr,bitIndex115)
        <=> v924(VarCurr,bitIndex115) )
        & ( v911(VarCurr,bitIndex114)
        <=> v924(VarCurr,bitIndex114) )
        & ( v911(VarCurr,bitIndex113)
        <=> v924(VarCurr,bitIndex113) )
        & ( v911(VarCurr,bitIndex112)
        <=> v924(VarCurr,bitIndex112) )
        & ( v911(VarCurr,bitIndex111)
        <=> v924(VarCurr,bitIndex111) )
        & ( v911(VarCurr,bitIndex110)
        <=> v924(VarCurr,bitIndex110) )
        & ( v911(VarCurr,bitIndex109)
        <=> v924(VarCurr,bitIndex109) )
        & ( v911(VarCurr,bitIndex108)
        <=> v924(VarCurr,bitIndex108) )
        & ( v911(VarCurr,bitIndex107)
        <=> v924(VarCurr,bitIndex107) )
        & ( v911(VarCurr,bitIndex106)
        <=> v924(VarCurr,bitIndex106) )
        & ( v911(VarCurr,bitIndex105)
        <=> v924(VarCurr,bitIndex105) )
        & ( v911(VarCurr,bitIndex104)
        <=> v924(VarCurr,bitIndex104) )
        & ( v911(VarCurr,bitIndex103)
        <=> v924(VarCurr,bitIndex103) )
        & ( v911(VarCurr,bitIndex102)
        <=> v924(VarCurr,bitIndex102) )
        & ( v911(VarCurr,bitIndex101)
        <=> v924(VarCurr,bitIndex101) )
        & ( v911(VarCurr,bitIndex100)
        <=> v924(VarCurr,bitIndex100) )
        & ( v911(VarCurr,bitIndex99)
        <=> v924(VarCurr,bitIndex99) )
        & ( v911(VarCurr,bitIndex98)
        <=> v924(VarCurr,bitIndex98) )
        & ( v911(VarCurr,bitIndex97)
        <=> v924(VarCurr,bitIndex97) )
        & ( v911(VarCurr,bitIndex96)
        <=> v924(VarCurr,bitIndex96) )
        & ( v911(VarCurr,bitIndex95)
        <=> v924(VarCurr,bitIndex95) )
        & ( v911(VarCurr,bitIndex94)
        <=> v924(VarCurr,bitIndex94) )
        & ( v911(VarCurr,bitIndex93)
        <=> v924(VarCurr,bitIndex93) )
        & ( v911(VarCurr,bitIndex92)
        <=> v924(VarCurr,bitIndex92) )
        & ( v911(VarCurr,bitIndex91)
        <=> v924(VarCurr,bitIndex91) )
        & ( v911(VarCurr,bitIndex90)
        <=> v924(VarCurr,bitIndex90) )
        & ( v911(VarCurr,bitIndex89)
        <=> v924(VarCurr,bitIndex89) )
        & ( v911(VarCurr,bitIndex88)
        <=> v924(VarCurr,bitIndex88) )
        & ( v911(VarCurr,bitIndex87)
        <=> v924(VarCurr,bitIndex87) )
        & ( v911(VarCurr,bitIndex86)
        <=> v924(VarCurr,bitIndex86) )
        & ( v911(VarCurr,bitIndex85)
        <=> v924(VarCurr,bitIndex85) )
        & ( v911(VarCurr,bitIndex84)
        <=> v924(VarCurr,bitIndex84) )
        & ( v911(VarCurr,bitIndex83)
        <=> v924(VarCurr,bitIndex83) )
        & ( v911(VarCurr,bitIndex82)
        <=> v924(VarCurr,bitIndex82) )
        & ( v911(VarCurr,bitIndex81)
        <=> v924(VarCurr,bitIndex81) )
        & ( v911(VarCurr,bitIndex80)
        <=> v924(VarCurr,bitIndex80) )
        & ( v911(VarCurr,bitIndex79)
        <=> v924(VarCurr,bitIndex79) )
        & ( v911(VarCurr,bitIndex78)
        <=> v924(VarCurr,bitIndex78) )
        & ( v911(VarCurr,bitIndex77)
        <=> v924(VarCurr,bitIndex77) )
        & ( v911(VarCurr,bitIndex76)
        <=> v924(VarCurr,bitIndex76) )
        & ( v911(VarCurr,bitIndex75)
        <=> v924(VarCurr,bitIndex75) )
        & ( v911(VarCurr,bitIndex74)
        <=> v924(VarCurr,bitIndex74) )
        & ( v911(VarCurr,bitIndex73)
        <=> v924(VarCurr,bitIndex73) )
        & ( v911(VarCurr,bitIndex72)
        <=> v924(VarCurr,bitIndex72) )
        & ( v911(VarCurr,bitIndex71)
        <=> v924(VarCurr,bitIndex71) )
        & ( v911(VarCurr,bitIndex70)
        <=> v924(VarCurr,bitIndex70) )
        & ( v911(VarCurr,bitIndex69)
        <=> v924(VarCurr,bitIndex69) )
        & ( v911(VarCurr,bitIndex68)
        <=> v924(VarCurr,bitIndex68) )
        & ( v911(VarCurr,bitIndex67)
        <=> v924(VarCurr,bitIndex67) )
        & ( v911(VarCurr,bitIndex66)
        <=> v924(VarCurr,bitIndex66) )
        & ( v911(VarCurr,bitIndex65)
        <=> v924(VarCurr,bitIndex65) )
        & ( v911(VarCurr,bitIndex64)
        <=> v924(VarCurr,bitIndex64) )
        & ( v911(VarCurr,bitIndex63)
        <=> v924(VarCurr,bitIndex63) )
        & ( v911(VarCurr,bitIndex62)
        <=> v924(VarCurr,bitIndex62) )
        & ( v911(VarCurr,bitIndex61)
        <=> v924(VarCurr,bitIndex61) )
        & ( v911(VarCurr,bitIndex60)
        <=> v924(VarCurr,bitIndex60) )
        & ( v911(VarCurr,bitIndex59)
        <=> v924(VarCurr,bitIndex59) )
        & ( v911(VarCurr,bitIndex58)
        <=> v924(VarCurr,bitIndex58) )
        & ( v911(VarCurr,bitIndex57)
        <=> v924(VarCurr,bitIndex57) )
        & ( v911(VarCurr,bitIndex56)
        <=> v924(VarCurr,bitIndex56) )
        & ( v911(VarCurr,bitIndex55)
        <=> v924(VarCurr,bitIndex55) )
        & ( v911(VarCurr,bitIndex54)
        <=> v924(VarCurr,bitIndex54) )
        & ( v911(VarCurr,bitIndex53)
        <=> v924(VarCurr,bitIndex53) )
        & ( v911(VarCurr,bitIndex52)
        <=> v924(VarCurr,bitIndex52) )
        & ( v911(VarCurr,bitIndex51)
        <=> v924(VarCurr,bitIndex51) )
        & ( v911(VarCurr,bitIndex50)
        <=> v924(VarCurr,bitIndex50) )
        & ( v911(VarCurr,bitIndex49)
        <=> v924(VarCurr,bitIndex49) )
        & ( v911(VarCurr,bitIndex48)
        <=> v924(VarCurr,bitIndex48) )
        & ( v911(VarCurr,bitIndex47)
        <=> v924(VarCurr,bitIndex47) )
        & ( v911(VarCurr,bitIndex46)
        <=> v924(VarCurr,bitIndex46) )
        & ( v911(VarCurr,bitIndex45)
        <=> v924(VarCurr,bitIndex45) )
        & ( v911(VarCurr,bitIndex44)
        <=> v924(VarCurr,bitIndex44) )
        & ( v911(VarCurr,bitIndex43)
        <=> v924(VarCurr,bitIndex43) )
        & ( v911(VarCurr,bitIndex42)
        <=> v924(VarCurr,bitIndex42) )
        & ( v911(VarCurr,bitIndex41)
        <=> v924(VarCurr,bitIndex41) )
        & ( v911(VarCurr,bitIndex40)
        <=> v924(VarCurr,bitIndex40) )
        & ( v911(VarCurr,bitIndex39)
        <=> v924(VarCurr,bitIndex39) )
        & ( v911(VarCurr,bitIndex38)
        <=> v924(VarCurr,bitIndex38) )
        & ( v911(VarCurr,bitIndex37)
        <=> v924(VarCurr,bitIndex37) )
        & ( v911(VarCurr,bitIndex36)
        <=> v924(VarCurr,bitIndex36) )
        & ( v911(VarCurr,bitIndex35)
        <=> v924(VarCurr,bitIndex35) )
        & ( v911(VarCurr,bitIndex34)
        <=> v924(VarCurr,bitIndex34) )
        & ( v911(VarCurr,bitIndex33)
        <=> v924(VarCurr,bitIndex33) )
        & ( v911(VarCurr,bitIndex32)
        <=> v924(VarCurr,bitIndex32) )
        & ( v911(VarCurr,bitIndex31)
        <=> v924(VarCurr,bitIndex31) )
        & ( v911(VarCurr,bitIndex30)
        <=> v924(VarCurr,bitIndex30) )
        & ( v911(VarCurr,bitIndex29)
        <=> v924(VarCurr,bitIndex29) )
        & ( v911(VarCurr,bitIndex28)
        <=> v924(VarCurr,bitIndex28) )
        & ( v911(VarCurr,bitIndex27)
        <=> v924(VarCurr,bitIndex27) )
        & ( v911(VarCurr,bitIndex26)
        <=> v924(VarCurr,bitIndex26) )
        & ( v911(VarCurr,bitIndex25)
        <=> v924(VarCurr,bitIndex25) )
        & ( v911(VarCurr,bitIndex24)
        <=> v924(VarCurr,bitIndex24) )
        & ( v911(VarCurr,bitIndex23)
        <=> v924(VarCurr,bitIndex23) )
        & ( v911(VarCurr,bitIndex22)
        <=> v924(VarCurr,bitIndex22) )
        & ( v911(VarCurr,bitIndex21)
        <=> v924(VarCurr,bitIndex21) )
        & ( v911(VarCurr,bitIndex20)
        <=> v924(VarCurr,bitIndex20) )
        & ( v911(VarCurr,bitIndex19)
        <=> v924(VarCurr,bitIndex19) )
        & ( v911(VarCurr,bitIndex18)
        <=> v924(VarCurr,bitIndex18) )
        & ( v911(VarCurr,bitIndex17)
        <=> v924(VarCurr,bitIndex17) )
        & ( v911(VarCurr,bitIndex16)
        <=> v924(VarCurr,bitIndex16) )
        & ( v911(VarCurr,bitIndex15)
        <=> v924(VarCurr,bitIndex15) )
        & ( v911(VarCurr,bitIndex14)
        <=> v924(VarCurr,bitIndex14) )
        & ( v911(VarCurr,bitIndex13)
        <=> v924(VarCurr,bitIndex13) )
        & ( v911(VarCurr,bitIndex12)
        <=> v924(VarCurr,bitIndex12) )
        & ( v911(VarCurr,bitIndex11)
        <=> v924(VarCurr,bitIndex11) )
        & ( v911(VarCurr,bitIndex10)
        <=> v924(VarCurr,bitIndex10) )
        & ( v911(VarCurr,bitIndex9)
        <=> v924(VarCurr,bitIndex9) )
        & ( v911(VarCurr,bitIndex8)
        <=> v924(VarCurr,bitIndex8) )
        & ( v911(VarCurr,bitIndex7)
        <=> v924(VarCurr,bitIndex7) )
        & ( v911(VarCurr,bitIndex6)
        <=> v924(VarCurr,bitIndex6) )
        & ( v911(VarCurr,bitIndex5)
        <=> v924(VarCurr,bitIndex5) )
        & ( v911(VarCurr,bitIndex4)
        <=> v924(VarCurr,bitIndex4) )
        & ( v911(VarCurr,bitIndex3)
        <=> v924(VarCurr,bitIndex3) )
        & ( v911(VarCurr,bitIndex2)
        <=> v924(VarCurr,bitIndex2) )
        & ( v911(VarCurr,bitIndex1)
        <=> v924(VarCurr,bitIndex1) )
        & ( v911(VarCurr,bitIndex0)
        <=> v924(VarCurr,bitIndex0) ) ) ) ).

fof(addAssignment_68,axiom,
    ! [VarCurr,B] :
      ( range_127_0(B)
     => ( v924(VarCurr,B)
      <=> v815(VarCurr,B) ) ) ).

fof(addAssignment_67,axiom,
    ! [VarCurr] :
      ( ( v924(VarCurr,bitIndex143)
      <=> v804(VarCurr,bitIndex15) )
      & ( v924(VarCurr,bitIndex142)
      <=> v804(VarCurr,bitIndex14) )
      & ( v924(VarCurr,bitIndex141)
      <=> v804(VarCurr,bitIndex13) )
      & ( v924(VarCurr,bitIndex140)
      <=> v804(VarCurr,bitIndex12) )
      & ( v924(VarCurr,bitIndex139)
      <=> v804(VarCurr,bitIndex11) )
      & ( v924(VarCurr,bitIndex138)
      <=> v804(VarCurr,bitIndex10) )
      & ( v924(VarCurr,bitIndex137)
      <=> v804(VarCurr,bitIndex9) )
      & ( v924(VarCurr,bitIndex136)
      <=> v804(VarCurr,bitIndex8) )
      & ( v924(VarCurr,bitIndex135)
      <=> v804(VarCurr,bitIndex7) )
      & ( v924(VarCurr,bitIndex134)
      <=> v804(VarCurr,bitIndex6) )
      & ( v924(VarCurr,bitIndex133)
      <=> v804(VarCurr,bitIndex5) )
      & ( v924(VarCurr,bitIndex132)
      <=> v804(VarCurr,bitIndex4) )
      & ( v924(VarCurr,bitIndex131)
      <=> v804(VarCurr,bitIndex3) )
      & ( v924(VarCurr,bitIndex130)
      <=> v804(VarCurr,bitIndex2) )
      & ( v924(VarCurr,bitIndex129)
      <=> v804(VarCurr,bitIndex1) )
      & ( v924(VarCurr,bitIndex128)
      <=> v804(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_66,axiom,
    ! [VarCurr] :
      ( ( v924(VarCurr,bitIndex148)
      <=> v95(VarCurr,bitIndex4) )
      & ( v924(VarCurr,bitIndex147)
      <=> v95(VarCurr,bitIndex3) )
      & ( v924(VarCurr,bitIndex146)
      <=> v95(VarCurr,bitIndex2) )
      & ( v924(VarCurr,bitIndex145)
      <=> v95(VarCurr,bitIndex1) )
      & ( v924(VarCurr,bitIndex144)
      <=> v95(VarCurr,bitIndex0) ) ) ).

fof(writeUnaryOperator_269,axiom,
    ! [VarCurr] :
      ( ~ v920(VarCurr)
    <=> v921(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_304,axiom,
    ! [VarCurr] :
      ( v921(VarCurr)
    <=> ( v922(VarCurr)
        & v36(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_303,axiom,
    ! [VarCurr] :
      ( v922(VarCurr)
    <=> ( v7(VarCurr)
        & v11(VarCurr) ) ) ).

fof(memoryReadIntoBuffer_1,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v838_range_3_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( address(A)
             => ! [B] :
                  ( A = AssociatedAddressVar
                 => ( range_148_0(B)
                   => ( v911(VarNext,B)
                    <=> v92_array(VarNext,A,B) ) ) ) ) ) ) ).

fof(memoryReadIntoBuffer,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v909_range_3_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( address(A)
             => ! [B] :
                  ( A = AssociatedAddressVar
                 => ( range_148_0(B)
                   => ( v907(VarNext,B)
                    <=> v92_array(VarNext,A,B) ) ) ) ) ) ) ).

fof(memoryConstantWriteDisabled,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( $true
              & v899(VarNext) )
         => ! [B] :
              ( range_148_0(B)
             => ( v92_array(VarNext,A,B)
              <=> v92_1__array(VarNext,A,B) ) ) ) ) ).

fof(memoryConstantWriteEnabledInsideRange,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( $true
            & v899(VarNext) )
         => ! [B] :
              ( range_148_0(B)
             => ( v92_array(VarNext,A,B)
              <=> b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(B) ) ) ) ) ).

fof(bitBlastConstant_301,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex148) ).

fof(bitBlastConstant_300,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex147) ).

fof(bitBlastConstant_299,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex146) ).

fof(bitBlastConstant_298,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex145) ).

fof(bitBlastConstant_297,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex144) ).

fof(bitBlastConstant_296,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex143) ).

fof(bitBlastConstant_295,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex142) ).

fof(bitBlastConstant_294,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex141) ).

fof(bitBlastConstant_293,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex140) ).

fof(bitBlastConstant_292,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex139) ).

fof(bitBlastConstant_291,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex138) ).

fof(bitBlastConstant_290,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex137) ).

fof(bitBlastConstant_289,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex136) ).

fof(bitBlastConstant_288,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex135) ).

fof(bitBlastConstant_287,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex134) ).

fof(bitBlastConstant_286,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex133) ).

fof(bitBlastConstant_285,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex132) ).

fof(bitBlastConstant_284,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex131) ).

fof(bitBlastConstant_283,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex130) ).

fof(bitBlastConstant_282,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex129) ).

fof(bitBlastConstant_281,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex128) ).

fof(bitBlastConstant_280,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex127) ).

fof(bitBlastConstant_279,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex126) ).

fof(bitBlastConstant_278,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex125) ).

fof(bitBlastConstant_277,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex124) ).

fof(bitBlastConstant_276,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex123) ).

fof(bitBlastConstant_275,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex122) ).

fof(bitBlastConstant_274,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex121) ).

fof(bitBlastConstant_273,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex120) ).

fof(bitBlastConstant_272,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex119) ).

fof(bitBlastConstant_271,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex118) ).

fof(bitBlastConstant_270,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex117) ).

fof(bitBlastConstant_269,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex116) ).

fof(bitBlastConstant_268,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex115) ).

fof(bitBlastConstant_267,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex114) ).

fof(bitBlastConstant_266,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex113) ).

fof(bitBlastConstant_265,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex112) ).

fof(bitBlastConstant_264,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex111) ).

fof(bitBlastConstant_263,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex110) ).

fof(bitBlastConstant_262,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex109) ).

fof(bitBlastConstant_261,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex108) ).

fof(bitBlastConstant_260,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex107) ).

fof(bitBlastConstant_259,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex106) ).

fof(bitBlastConstant_258,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex105) ).

fof(bitBlastConstant_257,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex104) ).

fof(bitBlastConstant_256,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex103) ).

fof(bitBlastConstant_255,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex102) ).

fof(bitBlastConstant_254,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex101) ).

fof(bitBlastConstant_253,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex100) ).

fof(bitBlastConstant_252,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex99) ).

fof(bitBlastConstant_251,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex98) ).

fof(bitBlastConstant_250,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex97) ).

fof(bitBlastConstant_249,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex96) ).

fof(bitBlastConstant_248,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex95) ).

fof(bitBlastConstant_247,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex94) ).

fof(bitBlastConstant_246,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex93) ).

fof(bitBlastConstant_245,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex92) ).

fof(bitBlastConstant_244,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex91) ).

fof(bitBlastConstant_243,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex90) ).

fof(bitBlastConstant_242,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex89) ).

fof(bitBlastConstant_241,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex88) ).

fof(bitBlastConstant_240,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex87) ).

fof(bitBlastConstant_239,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex86) ).

fof(bitBlastConstant_238,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex85) ).

fof(bitBlastConstant_237,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex84) ).

fof(bitBlastConstant_236,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex83) ).

fof(bitBlastConstant_235,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex82) ).

fof(bitBlastConstant_234,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex81) ).

fof(bitBlastConstant_233,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex80) ).

fof(bitBlastConstant_232,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex79) ).

fof(bitBlastConstant_231,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex78) ).

fof(bitBlastConstant_230,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex77) ).

fof(bitBlastConstant_229,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex76) ).

fof(bitBlastConstant_228,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex75) ).

fof(bitBlastConstant_227,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex74) ).

fof(bitBlastConstant_226,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex73) ).

fof(bitBlastConstant_225,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex72) ).

fof(bitBlastConstant_224,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex71) ).

fof(bitBlastConstant_223,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex70) ).

fof(bitBlastConstant_222,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex69) ).

fof(bitBlastConstant_221,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex68) ).

fof(bitBlastConstant_220,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex67) ).

fof(bitBlastConstant_219,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex66) ).

fof(bitBlastConstant_218,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex65) ).

fof(bitBlastConstant_217,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex64) ).

fof(bitBlastConstant_216,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex63) ).

fof(bitBlastConstant_215,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex62) ).

fof(bitBlastConstant_214,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex61) ).

fof(bitBlastConstant_213,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex60) ).

fof(bitBlastConstant_212,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex59) ).

fof(bitBlastConstant_211,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex58) ).

fof(bitBlastConstant_210,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex57) ).

fof(bitBlastConstant_209,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex56) ).

fof(bitBlastConstant_208,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex55) ).

fof(bitBlastConstant_207,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex54) ).

fof(bitBlastConstant_206,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex53) ).

fof(bitBlastConstant_205,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex52) ).

fof(bitBlastConstant_204,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex51) ).

fof(bitBlastConstant_203,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex50) ).

fof(bitBlastConstant_202,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex49) ).

fof(bitBlastConstant_201,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex48) ).

fof(bitBlastConstant_200,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex47) ).

fof(bitBlastConstant_199,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex46) ).

fof(bitBlastConstant_198,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex45) ).

fof(bitBlastConstant_197,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex44) ).

fof(bitBlastConstant_196,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex43) ).

fof(bitBlastConstant_195,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex42) ).

fof(bitBlastConstant_194,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex41) ).

fof(bitBlastConstant_193,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex40) ).

fof(bitBlastConstant_192,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex39) ).

fof(bitBlastConstant_191,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex38) ).

fof(bitBlastConstant_190,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex37) ).

fof(bitBlastConstant_189,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex36) ).

fof(bitBlastConstant_188,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex35) ).

fof(bitBlastConstant_187,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex34) ).

fof(bitBlastConstant_186,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex33) ).

fof(bitBlastConstant_185,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex32) ).

fof(bitBlastConstant_184,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex31) ).

fof(bitBlastConstant_183,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex30) ).

fof(bitBlastConstant_182,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex29) ).

fof(bitBlastConstant_181,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex28) ).

fof(bitBlastConstant_180,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex27) ).

fof(bitBlastConstant_179,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex26) ).

fof(bitBlastConstant_178,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex25) ).

fof(bitBlastConstant_177,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex24) ).

fof(bitBlastConstant_176,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex23) ).

fof(bitBlastConstant_175,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex22) ).

fof(bitBlastConstant_174,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex21) ).

fof(bitBlastConstant_173,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex20) ).

fof(bitBlastConstant_172,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex19) ).

fof(bitBlastConstant_171,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex18) ).

fof(bitBlastConstant_170,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex17) ).

fof(bitBlastConstant_169,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex16) ).

fof(bitBlastConstant_168,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex15) ).

fof(bitBlastConstant_167,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex14) ).

fof(bitBlastConstant_166,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex13) ).

fof(bitBlastConstant_165,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex12) ).

fof(bitBlastConstant_164,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex11) ).

fof(bitBlastConstant_163,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex10) ).

fof(bitBlastConstant_162,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex9) ).

fof(bitBlastConstant_161,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex8) ).

fof(bitBlastConstant_160,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex7) ).

fof(bitBlastConstant_159,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex6) ).

fof(bitBlastConstant_158,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex5) ).

fof(bitBlastConstant_157,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex4) ).

fof(bitBlastConstant_156,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex3) ).

fof(bitBlastConstant_155,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex2) ).

fof(bitBlastConstant_154,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex1) ).

fof(bitBlastConstant_153,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_302,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v899(VarNext)
      <=> ( v900(VarNext)
          & v905(VarNext) ) ) ) ).

fof(addAssignment_65,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v905(VarNext)
      <=> v894(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_301,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v900(VarNext)
      <=> ( v902(VarNext)
          & v7(VarNext) ) ) ) ).

fof(writeUnaryOperator_268,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v902(VarNext)
      <=> v26(VarNext) ) ) ).

fof(memoryWriteDisabled,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v838_range_3_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ~ ( A = AssociatedAddressVar
                  & v885(VarNext) )
             => ! [B] :
                  ( range_148_0(B)
                 => ( v92_1__array(VarNext,A,B)
                  <=> v92_array(VarCurr,A,B) ) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v838_range_3_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ( A = AssociatedAddressVar
                & v885(VarNext) )
             => ! [B] :
                  ( range_148_0(B)
                 => ( v92_1__array(VarNext,A,B)
                  <=> v896(VarNext,B) ) ) ) ) ) ).

fof(range_axiom_8,axiom,
    ! [B] :
      ( range_148_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B
        | bitIndex30 = B
        | bitIndex31 = B
        | bitIndex32 = B
        | bitIndex33 = B
        | bitIndex34 = B
        | bitIndex35 = B
        | bitIndex36 = B
        | bitIndex37 = B
        | bitIndex38 = B
        | bitIndex39 = B
        | bitIndex40 = B
        | bitIndex41 = B
        | bitIndex42 = B
        | bitIndex43 = B
        | bitIndex44 = B
        | bitIndex45 = B
        | bitIndex46 = B
        | bitIndex47 = B
        | bitIndex48 = B
        | bitIndex49 = B
        | bitIndex50 = B
        | bitIndex51 = B
        | bitIndex52 = B
        | bitIndex53 = B
        | bitIndex54 = B
        | bitIndex55 = B
        | bitIndex56 = B
        | bitIndex57 = B
        | bitIndex58 = B
        | bitIndex59 = B
        | bitIndex60 = B
        | bitIndex61 = B
        | bitIndex62 = B
        | bitIndex63 = B
        | bitIndex64 = B
        | bitIndex65 = B
        | bitIndex66 = B
        | bitIndex67 = B
        | bitIndex68 = B
        | bitIndex69 = B
        | bitIndex70 = B
        | bitIndex71 = B
        | bitIndex72 = B
        | bitIndex73 = B
        | bitIndex74 = B
        | bitIndex75 = B
        | bitIndex76 = B
        | bitIndex77 = B
        | bitIndex78 = B
        | bitIndex79 = B
        | bitIndex80 = B
        | bitIndex81 = B
        | bitIndex82 = B
        | bitIndex83 = B
        | bitIndex84 = B
        | bitIndex85 = B
        | bitIndex86 = B
        | bitIndex87 = B
        | bitIndex88 = B
        | bitIndex89 = B
        | bitIndex90 = B
        | bitIndex91 = B
        | bitIndex92 = B
        | bitIndex93 = B
        | bitIndex94 = B
        | bitIndex95 = B
        | bitIndex96 = B
        | bitIndex97 = B
        | bitIndex98 = B
        | bitIndex99 = B
        | bitIndex100 = B
        | bitIndex101 = B
        | bitIndex102 = B
        | bitIndex103 = B
        | bitIndex104 = B
        | bitIndex105 = B
        | bitIndex106 = B
        | bitIndex107 = B
        | bitIndex108 = B
        | bitIndex109 = B
        | bitIndex110 = B
        | bitIndex111 = B
        | bitIndex112 = B
        | bitIndex113 = B
        | bitIndex114 = B
        | bitIndex115 = B
        | bitIndex116 = B
        | bitIndex117 = B
        | bitIndex118 = B
        | bitIndex119 = B
        | bitIndex120 = B
        | bitIndex121 = B
        | bitIndex122 = B
        | bitIndex123 = B
        | bitIndex124 = B
        | bitIndex125 = B
        | bitIndex126 = B
        | bitIndex127 = B
        | bitIndex128 = B
        | bitIndex129 = B
        | bitIndex130 = B
        | bitIndex131 = B
        | bitIndex132 = B
        | bitIndex133 = B
        | bitIndex134 = B
        | bitIndex135 = B
        | bitIndex136 = B
        | bitIndex137 = B
        | bitIndex138 = B
        | bitIndex139 = B
        | bitIndex140 = B
        | bitIndex141 = B
        | bitIndex142 = B
        | bitIndex143 = B
        | bitIndex144 = B
        | bitIndex145 = B
        | bitIndex146 = B
        | bitIndex147 = B
        | bitIndex148 = B ) ) ).

fof(addAssignment_64,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_127_0(B)
         => ( v896(VarNext,B)
          <=> v815(VarNext,B) ) ) ) ).

fof(addAssignment_63,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ( v896(VarNext,bitIndex143)
        <=> v804(VarNext,bitIndex15) )
        & ( v896(VarNext,bitIndex142)
        <=> v804(VarNext,bitIndex14) )
        & ( v896(VarNext,bitIndex141)
        <=> v804(VarNext,bitIndex13) )
        & ( v896(VarNext,bitIndex140)
        <=> v804(VarNext,bitIndex12) )
        & ( v896(VarNext,bitIndex139)
        <=> v804(VarNext,bitIndex11) )
        & ( v896(VarNext,bitIndex138)
        <=> v804(VarNext,bitIndex10) )
        & ( v896(VarNext,bitIndex137)
        <=> v804(VarNext,bitIndex9) )
        & ( v896(VarNext,bitIndex136)
        <=> v804(VarNext,bitIndex8) )
        & ( v896(VarNext,bitIndex135)
        <=> v804(VarNext,bitIndex7) )
        & ( v896(VarNext,bitIndex134)
        <=> v804(VarNext,bitIndex6) )
        & ( v896(VarNext,bitIndex133)
        <=> v804(VarNext,bitIndex5) )
        & ( v896(VarNext,bitIndex132)
        <=> v804(VarNext,bitIndex4) )
        & ( v896(VarNext,bitIndex131)
        <=> v804(VarNext,bitIndex3) )
        & ( v896(VarNext,bitIndex130)
        <=> v804(VarNext,bitIndex2) )
        & ( v896(VarNext,bitIndex129)
        <=> v804(VarNext,bitIndex1) )
        & ( v896(VarNext,bitIndex128)
        <=> v804(VarNext,bitIndex0) ) ) ) ).

fof(addAssignment_62,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ( v896(VarNext,bitIndex148)
        <=> v95(VarNext,bitIndex4) )
        & ( v896(VarNext,bitIndex147)
        <=> v95(VarNext,bitIndex3) )
        & ( v896(VarNext,bitIndex146)
        <=> v95(VarNext,bitIndex2) )
        & ( v896(VarNext,bitIndex145)
        <=> v95(VarNext,bitIndex1) )
        & ( v896(VarNext,bitIndex144)
        <=> v95(VarNext,bitIndex0) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_300,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v885(VarNext)
      <=> ( v886(VarNext)
          & v892(VarNext) ) ) ) ).

fof(addAssignment_61,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v892(VarNext)
      <=> v890(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_299,axiom,
    ! [VarCurr] :
      ( v890(VarCurr)
    <=> ( v893(VarCurr)
        & v36(VarCurr) ) ) ).

fof(writeUnaryOperator_267,axiom,
    ! [VarCurr] :
      ( ~ v893(VarCurr)
    <=> v894(VarCurr) ) ).

fof(writeUnaryOperator_266,axiom,
    ! [VarCurr] :
      ( ~ v894(VarCurr)
    <=> v11(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_298,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v886(VarNext)
      <=> ( v887(VarNext)
          & v7(VarNext) ) ) ) ).

fof(writeUnaryOperator_265,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v887(VarNext)
      <=> v26(VarNext) ) ) ).

fof(addAssignment_60,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v838(VarCurr,B)
      <=> v840(VarCurr,B) ) ) ).

fof(addAssignment_59,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v840(VarCurr,B)
      <=> v842(VarCurr,B) ) ) ).

fof(addAssignment_58,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v842(VarCurr,B)
      <=> v844(VarCurr,B) ) ) ).

fof(addAssignment_57,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v844(VarCurr,B)
      <=> v846(VarCurr,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_10,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v871(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v846(VarNext,B)
            <=> v846(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_10,axiom,
    ! [VarNext] :
      ( v871(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v846(VarNext,B)
          <=> v879(VarNext,B) ) ) ) ).

fof(addAssignment_56,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v879(VarNext,B)
          <=> v877(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_6,axiom,
    ! [VarCurr] :
      ( ~ v88(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v877(VarCurr,B)
          <=> v849(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_6,axiom,
    ! [VarCurr] :
      ( v88(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v877(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_297,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v871(VarNext)
      <=> v873(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_296,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v873(VarNext)
      <=> ( v67(VarNext)
          & v874(VarNext) ) ) ) ).

fof(writeUnaryOperator_264,axiom,
    ! [VarCurr] :
      ( ~ v874(VarCurr)
    <=> v58(VarCurr) ) ).

fof(addAssignmentInitValueVector_10,axiom,
    ! [B] :
      ( range_3_0(B)
     => ( v846(constB0,B)
      <=> $false ) ) ).

fof(addCaseBooleanConditionEqualRanges1_9,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v858(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v849(VarNext,B)
            <=> v849(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_9,axiom,
    ! [VarNext] :
      ( v858(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v849(VarNext,B)
          <=> v866(VarNext,B) ) ) ) ).

fof(addAssignment_55,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v866(VarNext,B)
          <=> v864(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_5,axiom,
    ! [VarCurr] :
      ( ~ v74(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v864(VarCurr,B)
          <=> v851(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_5,axiom,
    ! [VarCurr] :
      ( v74(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v864(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_295,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v858(VarNext)
      <=> v859(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_294,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v859(VarNext)
      <=> ( v861(VarNext)
          & v58(VarNext) ) ) ) ).

fof(writeUnaryOperator_263,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v861(VarNext)
      <=> v67(VarNext) ) ) ).

fof(addAssignmentInitValueVector_9,axiom,
    ! [B] :
      ( range_3_0(B)
     => ( v849(constB0,B)
      <=> $false ) ) ).

fof(addAssignment_54,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v851(VarCurr,B)
      <=> v853(VarCurr,B) ) ) ).

fof(addAssignment_53,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v853(VarCurr,B)
      <=> v855(VarCurr,B) ) ) ).

fof(addAssignmentInitValueVector_8,axiom,
    ! [B] :
      ( range_3_0(B)
     => ( v855(constB0,B)
      <=> $false ) ) ).

fof(range_axiom_7,axiom,
    ! [B] :
      ( range_3_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B ) ) ).

fof(bitBlastConstant_152,axiom,
    ~ b0000(bitIndex3) ).

fof(bitBlastConstant_151,axiom,
    ~ b0000(bitIndex2) ).

fof(bitBlastConstant_150,axiom,
    ~ b0000(bitIndex1) ).

fof(bitBlastConstant_149,axiom,
    ~ b0000(bitIndex0) ).

fof(addAssignment_52,axiom,
    ! [VarCurr,B] :
      ( range_127_0(B)
     => ( v815(VarCurr,B)
      <=> v817(VarCurr,B) ) ) ).

fof(addAssignment_51,axiom,
    ! [VarCurr,B] :
      ( range_127_0(B)
     => ( v817(VarCurr,B)
      <=> v819(VarCurr,B) ) ) ).

fof(addAssignment_50,axiom,
    ! [VarCurr,B] :
      ( range_127_0(B)
     => ( v819(VarCurr,B)
      <=> v821(VarCurr,B) ) ) ).

fof(addAssignment_49,axiom,
    ! [VarCurr,B] :
      ( range_127_0(B)
     => ( v821(VarCurr,B)
      <=> v823(VarCurr,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_8,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v826(VarNext)
       => ! [B] :
            ( range_127_0(B)
           => ( v823(VarNext,B)
            <=> v823(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_8,axiom,
    ! [VarNext] :
      ( v826(VarNext)
     => ! [B] :
          ( range_127_0(B)
         => ( v823(VarNext,B)
          <=> v834(VarNext,B) ) ) ) ).

fof(addAssignment_48,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_127_0(B)
         => ( v834(VarNext,B)
          <=> v832(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_4,axiom,
    ! [VarCurr] :
      ( ~ v88(VarCurr)
     => ! [B] :
          ( range_127_0(B)
         => ( v832(VarCurr,B)
          <=> v110(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_4,axiom,
    ! [VarCurr] :
      ( v88(VarCurr)
     => ! [B] :
          ( range_127_0(B)
         => ( v832(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_293,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v826(VarNext)
      <=> v828(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_292,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v828(VarNext)
      <=> ( v67(VarNext)
          & v829(VarNext) ) ) ) ).

fof(writeUnaryOperator_262,axiom,
    ! [VarCurr] :
      ( ~ v829(VarCurr)
    <=> v58(VarCurr) ) ).

fof(addAssignmentInitValueVector_7,axiom,
    ! [B] :
      ( range_127_0(B)
     => ( v823(constB0,B)
      <=> $false ) ) ).

fof(addAssignment_47,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v804(VarCurr,B)
      <=> v806(VarCurr,B) ) ) ).

fof(addAssignment_46,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v806(VarCurr,B)
      <=> v808(VarCurr,B) ) ) ).

fof(addAssignment_45,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v808(VarCurr,B)
      <=> v810(VarCurr,B) ) ) ).

fof(addAssignment_44,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v810(VarCurr,B)
      <=> v812(VarCurr,B) ) ) ).

fof(addAssignment_43,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v812(VarCurr,B)
      <=> $true ) ) ).

fof(range_axiom_6,axiom,
    ! [B] :
      ( range_15_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B ) ) ).

fof(bitBlastConstant_148,axiom,
    b1111111111111111(bitIndex15) ).

fof(bitBlastConstant_147,axiom,
    b1111111111111111(bitIndex14) ).

fof(bitBlastConstant_146,axiom,
    b1111111111111111(bitIndex13) ).

fof(bitBlastConstant_145,axiom,
    b1111111111111111(bitIndex12) ).

fof(bitBlastConstant_144,axiom,
    b1111111111111111(bitIndex11) ).

fof(bitBlastConstant_143,axiom,
    b1111111111111111(bitIndex10) ).

fof(bitBlastConstant_142,axiom,
    b1111111111111111(bitIndex9) ).

fof(bitBlastConstant_141,axiom,
    b1111111111111111(bitIndex8) ).

fof(bitBlastConstant_140,axiom,
    b1111111111111111(bitIndex7) ).

fof(bitBlastConstant_139,axiom,
    b1111111111111111(bitIndex6) ).

fof(bitBlastConstant_138,axiom,
    b1111111111111111(bitIndex5) ).

fof(bitBlastConstant_137,axiom,
    b1111111111111111(bitIndex4) ).

fof(bitBlastConstant_136,axiom,
    b1111111111111111(bitIndex3) ).

fof(bitBlastConstant_135,axiom,
    b1111111111111111(bitIndex2) ).

fof(bitBlastConstant_134,axiom,
    b1111111111111111(bitIndex1) ).

fof(bitBlastConstant_133,axiom,
    b1111111111111111(bitIndex0) ).

fof(addAssignment_42,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v95(VarCurr,B)
      <=> v97(VarCurr,B) ) ) ).

fof(addAssignment_41,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v97(VarCurr,B)
      <=> v99(VarCurr,B) ) ) ).

fof(addAssignment_40,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v99(VarCurr,B)
      <=> v101(VarCurr,B) ) ) ).

fof(addAssignment_39,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v101(VarCurr,B)
      <=> v103(VarCurr,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_7,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v792(VarNext)
       => ! [B] :
            ( range_4_0(B)
           => ( v103(VarNext,B)
            <=> v103(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_7,axiom,
    ! [VarNext] :
      ( v792(VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v103(VarNext,B)
          <=> v800(VarNext,B) ) ) ) ).

fof(addAssignment_38,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v800(VarNext,B)
          <=> v798(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3,axiom,
    ! [VarCurr] :
      ( ~ v88(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v798(VarCurr,B)
          <=> v106(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3,axiom,
    ! [VarCurr] :
      ( v88(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v798(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_291,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v792(VarNext)
      <=> v794(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_290,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v794(VarNext)
      <=> ( v67(VarNext)
          & v795(VarNext) ) ) ) ).

fof(writeUnaryOperator_261,axiom,
    ! [VarCurr] :
      ( ~ v795(VarCurr)
    <=> v58(VarCurr) ) ).

fof(addAssignmentInitValueVector_6,axiom,
    ! [B] :
      ( range_4_0(B)
     => ( v103(constB0,B)
      <=> $false ) ) ).

fof(range_axiom_5,axiom,
    ! [B] :
      ( range_4_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B ) ) ).

fof(bitBlastConstant_132,axiom,
    ~ b00000(bitIndex4) ).

fof(bitBlastConstant_131,axiom,
    ~ b00000(bitIndex3) ).

fof(bitBlastConstant_130,axiom,
    ~ b00000(bitIndex2) ).

fof(bitBlastConstant_129,axiom,
    ~ b00000(bitIndex1) ).

fof(bitBlastConstant_128,axiom,
    ~ b00000(bitIndex0) ).

fof(addAssignment_37,axiom,
    ! [VarCurr] :
      ( v106(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_36,axiom,
    ! [VarCurr] :
      ( v106(VarCurr,bitIndex1)
    <=> v623(VarCurr) ) ).

fof(addAssignment_35,axiom,
    ! [VarCurr] :
      ( v106(VarCurr,bitIndex2)
    <=> v456(VarCurr) ) ).

fof(addAssignment_34,axiom,
    ! [VarCurr] :
      ( v106(VarCurr,bitIndex3)
    <=> v289(VarCurr) ) ).

fof(addAssignment_33,axiom,
    ! [VarCurr] :
      ( v106(VarCurr,bitIndex4)
    <=> v108(VarCurr) ) ).

fof(writeUnaryOperator_260,axiom,
    ! [VarCurr] :
      ( ~ v623(VarCurr)
    <=> v633(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_289,axiom,
    ! [VarCurr] :
      ( v633(VarCurr)
    <=> ( v635(VarCurr)
        & v788(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_288,axiom,
    ! [VarCurr] :
      ( v788(VarCurr)
    <=> ( v637(VarCurr)
        | v713(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_287,axiom,
    ! [VarCurr] :
      ( v635(VarCurr)
    <=> ( v636(VarCurr)
        | v712(VarCurr) ) ) ).

fof(writeUnaryOperator_259,axiom,
    ! [VarCurr] :
      ( ~ v712(VarCurr)
    <=> v713(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_286,axiom,
    ! [VarCurr] :
      ( v713(VarCurr)
    <=> ( v714(VarCurr)
        & v787(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_285,axiom,
    ! [VarCurr] :
      ( v787(VarCurr)
    <=> ( v716(VarCurr)
        | v732(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_284,axiom,
    ! [VarCurr] :
      ( v714(VarCurr)
    <=> ( v715(VarCurr)
        | v731(VarCurr) ) ) ).

fof(writeUnaryOperator_258,axiom,
    ! [VarCurr] :
      ( ~ v731(VarCurr)
    <=> v732(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_283,axiom,
    ! [VarCurr] :
      ( v732(VarCurr)
    <=> ( v733(VarCurr)
        & v786(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_282,axiom,
    ! [VarCurr] :
      ( v786(VarCurr)
    <=> ( v735(VarCurr)
        | v751(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_281,axiom,
    ! [VarCurr] :
      ( v733(VarCurr)
    <=> ( v734(VarCurr)
        | v750(VarCurr) ) ) ).

fof(writeUnaryOperator_257,axiom,
    ! [VarCurr] :
      ( ~ v750(VarCurr)
    <=> v751(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_280,axiom,
    ! [VarCurr] :
      ( v751(VarCurr)
    <=> ( v752(VarCurr)
        & v785(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_279,axiom,
    ! [VarCurr] :
      ( v785(VarCurr)
    <=> ( v754(VarCurr)
        | v770(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_278,axiom,
    ! [VarCurr] :
      ( v752(VarCurr)
    <=> ( v753(VarCurr)
        | v769(VarCurr) ) ) ).

fof(writeUnaryOperator_256,axiom,
    ! [VarCurr] :
      ( ~ v769(VarCurr)
    <=> v770(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_277,axiom,
    ! [VarCurr] :
      ( v770(VarCurr)
    <=> ( v771(VarCurr)
        & v784(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_95,axiom,
    ! [VarCurr] :
      ( v784(VarCurr)
    <=> ( v110(VarCurr,bitIndex23)
        | v774(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_276,axiom,
    ! [VarCurr] :
      ( v771(VarCurr)
    <=> ( v772(VarCurr)
        | v773(VarCurr) ) ) ).

fof(writeUnaryOperator_255,axiom,
    ! [VarCurr] :
      ( ~ v773(VarCurr)
    <=> v774(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_275,axiom,
    ! [VarCurr] :
      ( v774(VarCurr)
    <=> ( v775(VarCurr)
        & v783(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_94,axiom,
    ! [VarCurr] :
      ( v783(VarCurr)
    <=> ( v110(VarCurr,bitIndex22)
        | v778(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_274,axiom,
    ! [VarCurr] :
      ( v775(VarCurr)
    <=> ( v776(VarCurr)
        | v777(VarCurr) ) ) ).

fof(writeUnaryOperator_254,axiom,
    ! [VarCurr] :
      ( ~ v777(VarCurr)
    <=> v778(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_273,axiom,
    ! [VarCurr] :
      ( v778(VarCurr)
    <=> ( v779(VarCurr)
        & v782(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_93,axiom,
    ! [VarCurr] :
      ( v782(VarCurr)
    <=> ( v110(VarCurr,bitIndex20)
        | v110(VarCurr,bitIndex21) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_272,axiom,
    ! [VarCurr] :
      ( v779(VarCurr)
    <=> ( v780(VarCurr)
        | v781(VarCurr) ) ) ).

fof(writeUnaryOperator_253,axiom,
    ! [VarCurr] :
      ( ~ v781(VarCurr)
    <=> v110(VarCurr,bitIndex21) ) ).

fof(writeUnaryOperator_252,axiom,
    ! [VarCurr] :
      ( ~ v780(VarCurr)
    <=> v110(VarCurr,bitIndex20) ) ).

fof(writeUnaryOperator_251,axiom,
    ! [VarCurr] :
      ( ~ v776(VarCurr)
    <=> v110(VarCurr,bitIndex22) ) ).

fof(writeUnaryOperator_250,axiom,
    ! [VarCurr] :
      ( ~ v772(VarCurr)
    <=> v110(VarCurr,bitIndex23) ) ).

fof(writeUnaryOperator_249,axiom,
    ! [VarCurr] :
      ( ~ v753(VarCurr)
    <=> v754(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_271,axiom,
    ! [VarCurr] :
      ( v754(VarCurr)
    <=> ( v755(VarCurr)
        & v768(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_92,axiom,
    ! [VarCurr] :
      ( v768(VarCurr)
    <=> ( v110(VarCurr,bitIndex19)
        | v758(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_270,axiom,
    ! [VarCurr] :
      ( v755(VarCurr)
    <=> ( v756(VarCurr)
        | v757(VarCurr) ) ) ).

fof(writeUnaryOperator_248,axiom,
    ! [VarCurr] :
      ( ~ v757(VarCurr)
    <=> v758(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_269,axiom,
    ! [VarCurr] :
      ( v758(VarCurr)
    <=> ( v759(VarCurr)
        & v767(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_91,axiom,
    ! [VarCurr] :
      ( v767(VarCurr)
    <=> ( v110(VarCurr,bitIndex18)
        | v762(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_268,axiom,
    ! [VarCurr] :
      ( v759(VarCurr)
    <=> ( v760(VarCurr)
        | v761(VarCurr) ) ) ).

fof(writeUnaryOperator_247,axiom,
    ! [VarCurr] :
      ( ~ v761(VarCurr)
    <=> v762(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_267,axiom,
    ! [VarCurr] :
      ( v762(VarCurr)
    <=> ( v763(VarCurr)
        & v766(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_90,axiom,
    ! [VarCurr] :
      ( v766(VarCurr)
    <=> ( v110(VarCurr,bitIndex16)
        | v110(VarCurr,bitIndex17) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_266,axiom,
    ! [VarCurr] :
      ( v763(VarCurr)
    <=> ( v764(VarCurr)
        | v765(VarCurr) ) ) ).

fof(writeUnaryOperator_246,axiom,
    ! [VarCurr] :
      ( ~ v765(VarCurr)
    <=> v110(VarCurr,bitIndex17) ) ).

fof(writeUnaryOperator_245,axiom,
    ! [VarCurr] :
      ( ~ v764(VarCurr)
    <=> v110(VarCurr,bitIndex16) ) ).

fof(writeUnaryOperator_244,axiom,
    ! [VarCurr] :
      ( ~ v760(VarCurr)
    <=> v110(VarCurr,bitIndex18) ) ).

fof(writeUnaryOperator_243,axiom,
    ! [VarCurr] :
      ( ~ v756(VarCurr)
    <=> v110(VarCurr,bitIndex19) ) ).

fof(writeUnaryOperator_242,axiom,
    ! [VarCurr] :
      ( ~ v734(VarCurr)
    <=> v735(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_265,axiom,
    ! [VarCurr] :
      ( v735(VarCurr)
    <=> ( v736(VarCurr)
        & v749(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_89,axiom,
    ! [VarCurr] :
      ( v749(VarCurr)
    <=> ( v110(VarCurr,bitIndex27)
        | v739(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_264,axiom,
    ! [VarCurr] :
      ( v736(VarCurr)
    <=> ( v737(VarCurr)
        | v738(VarCurr) ) ) ).

fof(writeUnaryOperator_241,axiom,
    ! [VarCurr] :
      ( ~ v738(VarCurr)
    <=> v739(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_263,axiom,
    ! [VarCurr] :
      ( v739(VarCurr)
    <=> ( v740(VarCurr)
        & v748(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_88,axiom,
    ! [VarCurr] :
      ( v748(VarCurr)
    <=> ( v110(VarCurr,bitIndex26)
        | v743(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_262,axiom,
    ! [VarCurr] :
      ( v740(VarCurr)
    <=> ( v741(VarCurr)
        | v742(VarCurr) ) ) ).

fof(writeUnaryOperator_240,axiom,
    ! [VarCurr] :
      ( ~ v742(VarCurr)
    <=> v743(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_261,axiom,
    ! [VarCurr] :
      ( v743(VarCurr)
    <=> ( v744(VarCurr)
        & v747(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_87,axiom,
    ! [VarCurr] :
      ( v747(VarCurr)
    <=> ( v110(VarCurr,bitIndex24)
        | v110(VarCurr,bitIndex25) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_260,axiom,
    ! [VarCurr] :
      ( v744(VarCurr)
    <=> ( v745(VarCurr)
        | v746(VarCurr) ) ) ).

fof(writeUnaryOperator_239,axiom,
    ! [VarCurr] :
      ( ~ v746(VarCurr)
    <=> v110(VarCurr,bitIndex25) ) ).

fof(writeUnaryOperator_238,axiom,
    ! [VarCurr] :
      ( ~ v745(VarCurr)
    <=> v110(VarCurr,bitIndex24) ) ).

fof(writeUnaryOperator_237,axiom,
    ! [VarCurr] :
      ( ~ v741(VarCurr)
    <=> v110(VarCurr,bitIndex26) ) ).

fof(writeUnaryOperator_236,axiom,
    ! [VarCurr] :
      ( ~ v737(VarCurr)
    <=> v110(VarCurr,bitIndex27) ) ).

fof(writeUnaryOperator_235,axiom,
    ! [VarCurr] :
      ( ~ v715(VarCurr)
    <=> v716(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_259,axiom,
    ! [VarCurr] :
      ( v716(VarCurr)
    <=> ( v717(VarCurr)
        & v730(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_86,axiom,
    ! [VarCurr] :
      ( v730(VarCurr)
    <=> ( v110(VarCurr,bitIndex31)
        | v720(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_258,axiom,
    ! [VarCurr] :
      ( v717(VarCurr)
    <=> ( v718(VarCurr)
        | v719(VarCurr) ) ) ).

fof(writeUnaryOperator_234,axiom,
    ! [VarCurr] :
      ( ~ v719(VarCurr)
    <=> v720(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_257,axiom,
    ! [VarCurr] :
      ( v720(VarCurr)
    <=> ( v721(VarCurr)
        & v729(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_85,axiom,
    ! [VarCurr] :
      ( v729(VarCurr)
    <=> ( v110(VarCurr,bitIndex30)
        | v724(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_256,axiom,
    ! [VarCurr] :
      ( v721(VarCurr)
    <=> ( v722(VarCurr)
        | v723(VarCurr) ) ) ).

fof(writeUnaryOperator_233,axiom,
    ! [VarCurr] :
      ( ~ v723(VarCurr)
    <=> v724(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_255,axiom,
    ! [VarCurr] :
      ( v724(VarCurr)
    <=> ( v725(VarCurr)
        & v728(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_84,axiom,
    ! [VarCurr] :
      ( v728(VarCurr)
    <=> ( v110(VarCurr,bitIndex28)
        | v110(VarCurr,bitIndex29) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_254,axiom,
    ! [VarCurr] :
      ( v725(VarCurr)
    <=> ( v726(VarCurr)
        | v727(VarCurr) ) ) ).

fof(writeUnaryOperator_232,axiom,
    ! [VarCurr] :
      ( ~ v727(VarCurr)
    <=> v110(VarCurr,bitIndex29) ) ).

fof(writeUnaryOperator_231,axiom,
    ! [VarCurr] :
      ( ~ v726(VarCurr)
    <=> v110(VarCurr,bitIndex28) ) ).

fof(writeUnaryOperator_230,axiom,
    ! [VarCurr] :
      ( ~ v722(VarCurr)
    <=> v110(VarCurr,bitIndex30) ) ).

fof(writeUnaryOperator_229,axiom,
    ! [VarCurr] :
      ( ~ v718(VarCurr)
    <=> v110(VarCurr,bitIndex31) ) ).

fof(writeUnaryOperator_228,axiom,
    ! [VarCurr] :
      ( ~ v636(VarCurr)
    <=> v637(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_253,axiom,
    ! [VarCurr] :
      ( v637(VarCurr)
    <=> ( v638(VarCurr)
        & v711(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_252,axiom,
    ! [VarCurr] :
      ( v711(VarCurr)
    <=> ( v640(VarCurr)
        | v656(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_251,axiom,
    ! [VarCurr] :
      ( v638(VarCurr)
    <=> ( v639(VarCurr)
        | v655(VarCurr) ) ) ).

fof(writeUnaryOperator_227,axiom,
    ! [VarCurr] :
      ( ~ v655(VarCurr)
    <=> v656(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_250,axiom,
    ! [VarCurr] :
      ( v656(VarCurr)
    <=> ( v657(VarCurr)
        & v710(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_249,axiom,
    ! [VarCurr] :
      ( v710(VarCurr)
    <=> ( v659(VarCurr)
        | v675(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_248,axiom,
    ! [VarCurr] :
      ( v657(VarCurr)
    <=> ( v658(VarCurr)
        | v674(VarCurr) ) ) ).

fof(writeUnaryOperator_226,axiom,
    ! [VarCurr] :
      ( ~ v674(VarCurr)
    <=> v675(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_247,axiom,
    ! [VarCurr] :
      ( v675(VarCurr)
    <=> ( v676(VarCurr)
        & v709(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_246,axiom,
    ! [VarCurr] :
      ( v709(VarCurr)
    <=> ( v678(VarCurr)
        | v694(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_245,axiom,
    ! [VarCurr] :
      ( v676(VarCurr)
    <=> ( v677(VarCurr)
        | v693(VarCurr) ) ) ).

fof(writeUnaryOperator_225,axiom,
    ! [VarCurr] :
      ( ~ v693(VarCurr)
    <=> v694(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_244,axiom,
    ! [VarCurr] :
      ( v694(VarCurr)
    <=> ( v695(VarCurr)
        & v708(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_83,axiom,
    ! [VarCurr] :
      ( v708(VarCurr)
    <=> ( v110(VarCurr,bitIndex7)
        | v698(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_243,axiom,
    ! [VarCurr] :
      ( v695(VarCurr)
    <=> ( v696(VarCurr)
        | v697(VarCurr) ) ) ).

fof(writeUnaryOperator_224,axiom,
    ! [VarCurr] :
      ( ~ v697(VarCurr)
    <=> v698(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_242,axiom,
    ! [VarCurr] :
      ( v698(VarCurr)
    <=> ( v699(VarCurr)
        & v707(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_82,axiom,
    ! [VarCurr] :
      ( v707(VarCurr)
    <=> ( v110(VarCurr,bitIndex6)
        | v702(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_241,axiom,
    ! [VarCurr] :
      ( v699(VarCurr)
    <=> ( v700(VarCurr)
        | v701(VarCurr) ) ) ).

fof(writeUnaryOperator_223,axiom,
    ! [VarCurr] :
      ( ~ v701(VarCurr)
    <=> v702(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_240,axiom,
    ! [VarCurr] :
      ( v702(VarCurr)
    <=> ( v703(VarCurr)
        & v706(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_81,axiom,
    ! [VarCurr] :
      ( v706(VarCurr)
    <=> ( v110(VarCurr,bitIndex4)
        | v110(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_239,axiom,
    ! [VarCurr] :
      ( v703(VarCurr)
    <=> ( v704(VarCurr)
        | v705(VarCurr) ) ) ).

fof(writeUnaryOperator_222,axiom,
    ! [VarCurr] :
      ( ~ v705(VarCurr)
    <=> v110(VarCurr,bitIndex5) ) ).

fof(writeUnaryOperator_221,axiom,
    ! [VarCurr] :
      ( ~ v704(VarCurr)
    <=> v110(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_220,axiom,
    ! [VarCurr] :
      ( ~ v700(VarCurr)
    <=> v110(VarCurr,bitIndex6) ) ).

fof(writeUnaryOperator_219,axiom,
    ! [VarCurr] :
      ( ~ v696(VarCurr)
    <=> v110(VarCurr,bitIndex7) ) ).

fof(writeUnaryOperator_218,axiom,
    ! [VarCurr] :
      ( ~ v677(VarCurr)
    <=> v678(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_238,axiom,
    ! [VarCurr] :
      ( v678(VarCurr)
    <=> ( v679(VarCurr)
        & v692(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_80,axiom,
    ! [VarCurr] :
      ( v692(VarCurr)
    <=> ( v110(VarCurr,bitIndex3)
        | v682(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_237,axiom,
    ! [VarCurr] :
      ( v679(VarCurr)
    <=> ( v680(VarCurr)
        | v681(VarCurr) ) ) ).

fof(writeUnaryOperator_217,axiom,
    ! [VarCurr] :
      ( ~ v681(VarCurr)
    <=> v682(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_236,axiom,
    ! [VarCurr] :
      ( v682(VarCurr)
    <=> ( v683(VarCurr)
        & v691(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_79,axiom,
    ! [VarCurr] :
      ( v691(VarCurr)
    <=> ( v110(VarCurr,bitIndex2)
        | v686(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_235,axiom,
    ! [VarCurr] :
      ( v683(VarCurr)
    <=> ( v684(VarCurr)
        | v685(VarCurr) ) ) ).

fof(writeUnaryOperator_216,axiom,
    ! [VarCurr] :
      ( ~ v685(VarCurr)
    <=> v686(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_234,axiom,
    ! [VarCurr] :
      ( v686(VarCurr)
    <=> ( v687(VarCurr)
        & v690(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_78,axiom,
    ! [VarCurr] :
      ( v690(VarCurr)
    <=> ( v110(VarCurr,bitIndex0)
        | v110(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_233,axiom,
    ! [VarCurr] :
      ( v687(VarCurr)
    <=> ( v688(VarCurr)
        | v689(VarCurr) ) ) ).

fof(writeUnaryOperator_215,axiom,
    ! [VarCurr] :
      ( ~ v689(VarCurr)
    <=> v110(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_214,axiom,
    ! [VarCurr] :
      ( ~ v688(VarCurr)
    <=> v110(VarCurr,bitIndex0) ) ).

fof(writeUnaryOperator_213,axiom,
    ! [VarCurr] :
      ( ~ v684(VarCurr)
    <=> v110(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_212,axiom,
    ! [VarCurr] :
      ( ~ v680(VarCurr)
    <=> v110(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_211,axiom,
    ! [VarCurr] :
      ( ~ v658(VarCurr)
    <=> v659(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_232,axiom,
    ! [VarCurr] :
      ( v659(VarCurr)
    <=> ( v660(VarCurr)
        & v673(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_77,axiom,
    ! [VarCurr] :
      ( v673(VarCurr)
    <=> ( v110(VarCurr,bitIndex11)
        | v663(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_231,axiom,
    ! [VarCurr] :
      ( v660(VarCurr)
    <=> ( v661(VarCurr)
        | v662(VarCurr) ) ) ).

fof(writeUnaryOperator_210,axiom,
    ! [VarCurr] :
      ( ~ v662(VarCurr)
    <=> v663(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_230,axiom,
    ! [VarCurr] :
      ( v663(VarCurr)
    <=> ( v664(VarCurr)
        & v672(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_76,axiom,
    ! [VarCurr] :
      ( v672(VarCurr)
    <=> ( v110(VarCurr,bitIndex10)
        | v667(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_229,axiom,
    ! [VarCurr] :
      ( v664(VarCurr)
    <=> ( v665(VarCurr)
        | v666(VarCurr) ) ) ).

fof(writeUnaryOperator_209,axiom,
    ! [VarCurr] :
      ( ~ v666(VarCurr)
    <=> v667(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_228,axiom,
    ! [VarCurr] :
      ( v667(VarCurr)
    <=> ( v668(VarCurr)
        & v671(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_75,axiom,
    ! [VarCurr] :
      ( v671(VarCurr)
    <=> ( v110(VarCurr,bitIndex8)
        | v110(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_227,axiom,
    ! [VarCurr] :
      ( v668(VarCurr)
    <=> ( v669(VarCurr)
        | v670(VarCurr) ) ) ).

fof(writeUnaryOperator_208,axiom,
    ! [VarCurr] :
      ( ~ v670(VarCurr)
    <=> v110(VarCurr,bitIndex9) ) ).

fof(writeUnaryOperator_207,axiom,
    ! [VarCurr] :
      ( ~ v669(VarCurr)
    <=> v110(VarCurr,bitIndex8) ) ).

fof(writeUnaryOperator_206,axiom,
    ! [VarCurr] :
      ( ~ v665(VarCurr)
    <=> v110(VarCurr,bitIndex10) ) ).

fof(writeUnaryOperator_205,axiom,
    ! [VarCurr] :
      ( ~ v661(VarCurr)
    <=> v110(VarCurr,bitIndex11) ) ).

fof(writeUnaryOperator_204,axiom,
    ! [VarCurr] :
      ( ~ v639(VarCurr)
    <=> v640(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_226,axiom,
    ! [VarCurr] :
      ( v640(VarCurr)
    <=> ( v641(VarCurr)
        & v654(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_74,axiom,
    ! [VarCurr] :
      ( v654(VarCurr)
    <=> ( v110(VarCurr,bitIndex15)
        | v644(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_225,axiom,
    ! [VarCurr] :
      ( v641(VarCurr)
    <=> ( v642(VarCurr)
        | v643(VarCurr) ) ) ).

fof(writeUnaryOperator_203,axiom,
    ! [VarCurr] :
      ( ~ v643(VarCurr)
    <=> v644(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_224,axiom,
    ! [VarCurr] :
      ( v644(VarCurr)
    <=> ( v645(VarCurr)
        & v653(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_73,axiom,
    ! [VarCurr] :
      ( v653(VarCurr)
    <=> ( v110(VarCurr,bitIndex14)
        | v648(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_223,axiom,
    ! [VarCurr] :
      ( v645(VarCurr)
    <=> ( v646(VarCurr)
        | v647(VarCurr) ) ) ).

fof(writeUnaryOperator_202,axiom,
    ! [VarCurr] :
      ( ~ v647(VarCurr)
    <=> v648(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_222,axiom,
    ! [VarCurr] :
      ( v648(VarCurr)
    <=> ( v649(VarCurr)
        & v652(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_72,axiom,
    ! [VarCurr] :
      ( v652(VarCurr)
    <=> ( v110(VarCurr,bitIndex12)
        | v110(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_221,axiom,
    ! [VarCurr] :
      ( v649(VarCurr)
    <=> ( v650(VarCurr)
        | v651(VarCurr) ) ) ).

fof(writeUnaryOperator_201,axiom,
    ! [VarCurr] :
      ( ~ v651(VarCurr)
    <=> v110(VarCurr,bitIndex13) ) ).

fof(writeUnaryOperator_200,axiom,
    ! [VarCurr] :
      ( ~ v650(VarCurr)
    <=> v110(VarCurr,bitIndex12) ) ).

fof(writeUnaryOperator_199,axiom,
    ! [VarCurr] :
      ( ~ v646(VarCurr)
    <=> v110(VarCurr,bitIndex14) ) ).

fof(writeUnaryOperator_198,axiom,
    ! [VarCurr] :
      ( ~ v642(VarCurr)
    <=> v110(VarCurr,bitIndex15) ) ).

fof(addAssignment_32,axiom,
    ! [VarNext,B] :
      ( range_31_0(B)
     => ( v110(VarNext,B)
      <=> v625(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_6,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v626(VarNext)
       => ! [B] :
            ( range_127_0(B)
           => ( v625(VarNext,B)
            <=> v110(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_6,axiom,
    ! [VarNext] :
      ( v626(VarNext)
     => ! [B] :
          ( range_127_0(B)
         => ( v625(VarNext,B)
          <=> v128(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_220,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v626(VarNext)
      <=> v627(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_219,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v627(VarNext)
      <=> ( v629(VarNext)
          & v58(VarNext) ) ) ) ).

fof(writeUnaryOperator_197,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v629(VarNext)
      <=> v67(VarNext) ) ) ).

fof(addAssignment_31,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v113(VarCurr,B)
      <=> v115(VarCurr,B) ) ) ).

fof(addAssignment_30,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v115(VarCurr,B)
      <=> v117(VarCurr,B) ) ) ).

fof(range_axiom_4,axiom,
    ! [B] :
      ( range_31_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B
        | bitIndex30 = B
        | bitIndex31 = B ) ) ).

fof(writeUnaryOperator_196,axiom,
    ! [VarCurr] :
      ( ~ v456(VarCurr)
    <=> v466(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_218,axiom,
    ! [VarCurr] :
      ( v466(VarCurr)
    <=> ( v468(VarCurr)
        & v621(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_217,axiom,
    ! [VarCurr] :
      ( v621(VarCurr)
    <=> ( v470(VarCurr)
        | v546(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_216,axiom,
    ! [VarCurr] :
      ( v468(VarCurr)
    <=> ( v469(VarCurr)
        | v545(VarCurr) ) ) ).

fof(writeUnaryOperator_195,axiom,
    ! [VarCurr] :
      ( ~ v545(VarCurr)
    <=> v546(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_215,axiom,
    ! [VarCurr] :
      ( v546(VarCurr)
    <=> ( v547(VarCurr)
        & v620(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_214,axiom,
    ! [VarCurr] :
      ( v620(VarCurr)
    <=> ( v549(VarCurr)
        | v565(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_213,axiom,
    ! [VarCurr] :
      ( v547(VarCurr)
    <=> ( v548(VarCurr)
        | v564(VarCurr) ) ) ).

fof(writeUnaryOperator_194,axiom,
    ! [VarCurr] :
      ( ~ v564(VarCurr)
    <=> v565(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_212,axiom,
    ! [VarCurr] :
      ( v565(VarCurr)
    <=> ( v566(VarCurr)
        & v619(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_211,axiom,
    ! [VarCurr] :
      ( v619(VarCurr)
    <=> ( v568(VarCurr)
        | v584(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_210,axiom,
    ! [VarCurr] :
      ( v566(VarCurr)
    <=> ( v567(VarCurr)
        | v583(VarCurr) ) ) ).

fof(writeUnaryOperator_193,axiom,
    ! [VarCurr] :
      ( ~ v583(VarCurr)
    <=> v584(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_209,axiom,
    ! [VarCurr] :
      ( v584(VarCurr)
    <=> ( v585(VarCurr)
        & v618(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_208,axiom,
    ! [VarCurr] :
      ( v618(VarCurr)
    <=> ( v587(VarCurr)
        | v603(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_207,axiom,
    ! [VarCurr] :
      ( v585(VarCurr)
    <=> ( v586(VarCurr)
        | v602(VarCurr) ) ) ).

fof(writeUnaryOperator_192,axiom,
    ! [VarCurr] :
      ( ~ v602(VarCurr)
    <=> v603(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_206,axiom,
    ! [VarCurr] :
      ( v603(VarCurr)
    <=> ( v604(VarCurr)
        & v617(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_71,axiom,
    ! [VarCurr] :
      ( v617(VarCurr)
    <=> ( v110(VarCurr,bitIndex55)
        | v607(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_205,axiom,
    ! [VarCurr] :
      ( v604(VarCurr)
    <=> ( v605(VarCurr)
        | v606(VarCurr) ) ) ).

fof(writeUnaryOperator_191,axiom,
    ! [VarCurr] :
      ( ~ v606(VarCurr)
    <=> v607(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_204,axiom,
    ! [VarCurr] :
      ( v607(VarCurr)
    <=> ( v608(VarCurr)
        & v616(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_70,axiom,
    ! [VarCurr] :
      ( v616(VarCurr)
    <=> ( v110(VarCurr,bitIndex54)
        | v611(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_203,axiom,
    ! [VarCurr] :
      ( v608(VarCurr)
    <=> ( v609(VarCurr)
        | v610(VarCurr) ) ) ).

fof(writeUnaryOperator_190,axiom,
    ! [VarCurr] :
      ( ~ v610(VarCurr)
    <=> v611(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_202,axiom,
    ! [VarCurr] :
      ( v611(VarCurr)
    <=> ( v612(VarCurr)
        & v615(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_69,axiom,
    ! [VarCurr] :
      ( v615(VarCurr)
    <=> ( v110(VarCurr,bitIndex52)
        | v110(VarCurr,bitIndex53) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_201,axiom,
    ! [VarCurr] :
      ( v612(VarCurr)
    <=> ( v613(VarCurr)
        | v614(VarCurr) ) ) ).

fof(writeUnaryOperator_189,axiom,
    ! [VarCurr] :
      ( ~ v614(VarCurr)
    <=> v110(VarCurr,bitIndex53) ) ).

fof(writeUnaryOperator_188,axiom,
    ! [VarCurr] :
      ( ~ v613(VarCurr)
    <=> v110(VarCurr,bitIndex52) ) ).

fof(writeUnaryOperator_187,axiom,
    ! [VarCurr] :
      ( ~ v609(VarCurr)
    <=> v110(VarCurr,bitIndex54) ) ).

fof(writeUnaryOperator_186,axiom,
    ! [VarCurr] :
      ( ~ v605(VarCurr)
    <=> v110(VarCurr,bitIndex55) ) ).

fof(writeUnaryOperator_185,axiom,
    ! [VarCurr] :
      ( ~ v586(VarCurr)
    <=> v587(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_200,axiom,
    ! [VarCurr] :
      ( v587(VarCurr)
    <=> ( v588(VarCurr)
        & v601(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_68,axiom,
    ! [VarCurr] :
      ( v601(VarCurr)
    <=> ( v110(VarCurr,bitIndex51)
        | v591(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_199,axiom,
    ! [VarCurr] :
      ( v588(VarCurr)
    <=> ( v589(VarCurr)
        | v590(VarCurr) ) ) ).

fof(writeUnaryOperator_184,axiom,
    ! [VarCurr] :
      ( ~ v590(VarCurr)
    <=> v591(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_198,axiom,
    ! [VarCurr] :
      ( v591(VarCurr)
    <=> ( v592(VarCurr)
        & v600(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_67,axiom,
    ! [VarCurr] :
      ( v600(VarCurr)
    <=> ( v110(VarCurr,bitIndex50)
        | v595(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_197,axiom,
    ! [VarCurr] :
      ( v592(VarCurr)
    <=> ( v593(VarCurr)
        | v594(VarCurr) ) ) ).

fof(writeUnaryOperator_183,axiom,
    ! [VarCurr] :
      ( ~ v594(VarCurr)
    <=> v595(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_196,axiom,
    ! [VarCurr] :
      ( v595(VarCurr)
    <=> ( v596(VarCurr)
        & v599(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_66,axiom,
    ! [VarCurr] :
      ( v599(VarCurr)
    <=> ( v110(VarCurr,bitIndex48)
        | v110(VarCurr,bitIndex49) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_195,axiom,
    ! [VarCurr] :
      ( v596(VarCurr)
    <=> ( v597(VarCurr)
        | v598(VarCurr) ) ) ).

fof(writeUnaryOperator_182,axiom,
    ! [VarCurr] :
      ( ~ v598(VarCurr)
    <=> v110(VarCurr,bitIndex49) ) ).

fof(writeUnaryOperator_181,axiom,
    ! [VarCurr] :
      ( ~ v597(VarCurr)
    <=> v110(VarCurr,bitIndex48) ) ).

fof(writeUnaryOperator_180,axiom,
    ! [VarCurr] :
      ( ~ v593(VarCurr)
    <=> v110(VarCurr,bitIndex50) ) ).

fof(writeUnaryOperator_179,axiom,
    ! [VarCurr] :
      ( ~ v589(VarCurr)
    <=> v110(VarCurr,bitIndex51) ) ).

fof(writeUnaryOperator_178,axiom,
    ! [VarCurr] :
      ( ~ v567(VarCurr)
    <=> v568(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_194,axiom,
    ! [VarCurr] :
      ( v568(VarCurr)
    <=> ( v569(VarCurr)
        & v582(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_65,axiom,
    ! [VarCurr] :
      ( v582(VarCurr)
    <=> ( v110(VarCurr,bitIndex59)
        | v572(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_193,axiom,
    ! [VarCurr] :
      ( v569(VarCurr)
    <=> ( v570(VarCurr)
        | v571(VarCurr) ) ) ).

fof(writeUnaryOperator_177,axiom,
    ! [VarCurr] :
      ( ~ v571(VarCurr)
    <=> v572(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_192,axiom,
    ! [VarCurr] :
      ( v572(VarCurr)
    <=> ( v573(VarCurr)
        & v581(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_64,axiom,
    ! [VarCurr] :
      ( v581(VarCurr)
    <=> ( v110(VarCurr,bitIndex58)
        | v576(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_191,axiom,
    ! [VarCurr] :
      ( v573(VarCurr)
    <=> ( v574(VarCurr)
        | v575(VarCurr) ) ) ).

fof(writeUnaryOperator_176,axiom,
    ! [VarCurr] :
      ( ~ v575(VarCurr)
    <=> v576(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_190,axiom,
    ! [VarCurr] :
      ( v576(VarCurr)
    <=> ( v577(VarCurr)
        & v580(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_63,axiom,
    ! [VarCurr] :
      ( v580(VarCurr)
    <=> ( v110(VarCurr,bitIndex56)
        | v110(VarCurr,bitIndex57) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_189,axiom,
    ! [VarCurr] :
      ( v577(VarCurr)
    <=> ( v578(VarCurr)
        | v579(VarCurr) ) ) ).

fof(writeUnaryOperator_175,axiom,
    ! [VarCurr] :
      ( ~ v579(VarCurr)
    <=> v110(VarCurr,bitIndex57) ) ).

fof(writeUnaryOperator_174,axiom,
    ! [VarCurr] :
      ( ~ v578(VarCurr)
    <=> v110(VarCurr,bitIndex56) ) ).

fof(writeUnaryOperator_173,axiom,
    ! [VarCurr] :
      ( ~ v574(VarCurr)
    <=> v110(VarCurr,bitIndex58) ) ).

fof(writeUnaryOperator_172,axiom,
    ! [VarCurr] :
      ( ~ v570(VarCurr)
    <=> v110(VarCurr,bitIndex59) ) ).

fof(writeUnaryOperator_171,axiom,
    ! [VarCurr] :
      ( ~ v548(VarCurr)
    <=> v549(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_188,axiom,
    ! [VarCurr] :
      ( v549(VarCurr)
    <=> ( v550(VarCurr)
        & v563(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_62,axiom,
    ! [VarCurr] :
      ( v563(VarCurr)
    <=> ( v110(VarCurr,bitIndex63)
        | v553(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_187,axiom,
    ! [VarCurr] :
      ( v550(VarCurr)
    <=> ( v551(VarCurr)
        | v552(VarCurr) ) ) ).

fof(writeUnaryOperator_170,axiom,
    ! [VarCurr] :
      ( ~ v552(VarCurr)
    <=> v553(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_186,axiom,
    ! [VarCurr] :
      ( v553(VarCurr)
    <=> ( v554(VarCurr)
        & v562(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_61,axiom,
    ! [VarCurr] :
      ( v562(VarCurr)
    <=> ( v110(VarCurr,bitIndex62)
        | v557(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_185,axiom,
    ! [VarCurr] :
      ( v554(VarCurr)
    <=> ( v555(VarCurr)
        | v556(VarCurr) ) ) ).

fof(writeUnaryOperator_169,axiom,
    ! [VarCurr] :
      ( ~ v556(VarCurr)
    <=> v557(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_184,axiom,
    ! [VarCurr] :
      ( v557(VarCurr)
    <=> ( v558(VarCurr)
        & v561(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_60,axiom,
    ! [VarCurr] :
      ( v561(VarCurr)
    <=> ( v110(VarCurr,bitIndex60)
        | v110(VarCurr,bitIndex61) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_183,axiom,
    ! [VarCurr] :
      ( v558(VarCurr)
    <=> ( v559(VarCurr)
        | v560(VarCurr) ) ) ).

fof(writeUnaryOperator_168,axiom,
    ! [VarCurr] :
      ( ~ v560(VarCurr)
    <=> v110(VarCurr,bitIndex61) ) ).

fof(writeUnaryOperator_167,axiom,
    ! [VarCurr] :
      ( ~ v559(VarCurr)
    <=> v110(VarCurr,bitIndex60) ) ).

fof(writeUnaryOperator_166,axiom,
    ! [VarCurr] :
      ( ~ v555(VarCurr)
    <=> v110(VarCurr,bitIndex62) ) ).

fof(writeUnaryOperator_165,axiom,
    ! [VarCurr] :
      ( ~ v551(VarCurr)
    <=> v110(VarCurr,bitIndex63) ) ).

fof(writeUnaryOperator_164,axiom,
    ! [VarCurr] :
      ( ~ v469(VarCurr)
    <=> v470(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_182,axiom,
    ! [VarCurr] :
      ( v470(VarCurr)
    <=> ( v471(VarCurr)
        & v544(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_181,axiom,
    ! [VarCurr] :
      ( v544(VarCurr)
    <=> ( v473(VarCurr)
        | v489(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_180,axiom,
    ! [VarCurr] :
      ( v471(VarCurr)
    <=> ( v472(VarCurr)
        | v488(VarCurr) ) ) ).

fof(writeUnaryOperator_163,axiom,
    ! [VarCurr] :
      ( ~ v488(VarCurr)
    <=> v489(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_179,axiom,
    ! [VarCurr] :
      ( v489(VarCurr)
    <=> ( v490(VarCurr)
        & v543(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_178,axiom,
    ! [VarCurr] :
      ( v543(VarCurr)
    <=> ( v492(VarCurr)
        | v508(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_177,axiom,
    ! [VarCurr] :
      ( v490(VarCurr)
    <=> ( v491(VarCurr)
        | v507(VarCurr) ) ) ).

fof(writeUnaryOperator_162,axiom,
    ! [VarCurr] :
      ( ~ v507(VarCurr)
    <=> v508(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_176,axiom,
    ! [VarCurr] :
      ( v508(VarCurr)
    <=> ( v509(VarCurr)
        & v542(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_175,axiom,
    ! [VarCurr] :
      ( v542(VarCurr)
    <=> ( v511(VarCurr)
        | v527(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_174,axiom,
    ! [VarCurr] :
      ( v509(VarCurr)
    <=> ( v510(VarCurr)
        | v526(VarCurr) ) ) ).

fof(writeUnaryOperator_161,axiom,
    ! [VarCurr] :
      ( ~ v526(VarCurr)
    <=> v527(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_173,axiom,
    ! [VarCurr] :
      ( v527(VarCurr)
    <=> ( v528(VarCurr)
        & v541(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_59,axiom,
    ! [VarCurr] :
      ( v541(VarCurr)
    <=> ( v110(VarCurr,bitIndex39)
        | v531(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_172,axiom,
    ! [VarCurr] :
      ( v528(VarCurr)
    <=> ( v529(VarCurr)
        | v530(VarCurr) ) ) ).

fof(writeUnaryOperator_160,axiom,
    ! [VarCurr] :
      ( ~ v530(VarCurr)
    <=> v531(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_171,axiom,
    ! [VarCurr] :
      ( v531(VarCurr)
    <=> ( v532(VarCurr)
        & v540(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_58,axiom,
    ! [VarCurr] :
      ( v540(VarCurr)
    <=> ( v110(VarCurr,bitIndex38)
        | v535(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_170,axiom,
    ! [VarCurr] :
      ( v532(VarCurr)
    <=> ( v533(VarCurr)
        | v534(VarCurr) ) ) ).

fof(writeUnaryOperator_159,axiom,
    ! [VarCurr] :
      ( ~ v534(VarCurr)
    <=> v535(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_169,axiom,
    ! [VarCurr] :
      ( v535(VarCurr)
    <=> ( v536(VarCurr)
        & v539(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_57,axiom,
    ! [VarCurr] :
      ( v539(VarCurr)
    <=> ( v110(VarCurr,bitIndex36)
        | v110(VarCurr,bitIndex37) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_168,axiom,
    ! [VarCurr] :
      ( v536(VarCurr)
    <=> ( v537(VarCurr)
        | v538(VarCurr) ) ) ).

fof(writeUnaryOperator_158,axiom,
    ! [VarCurr] :
      ( ~ v538(VarCurr)
    <=> v110(VarCurr,bitIndex37) ) ).

fof(writeUnaryOperator_157,axiom,
    ! [VarCurr] :
      ( ~ v537(VarCurr)
    <=> v110(VarCurr,bitIndex36) ) ).

fof(writeUnaryOperator_156,axiom,
    ! [VarCurr] :
      ( ~ v533(VarCurr)
    <=> v110(VarCurr,bitIndex38) ) ).

fof(writeUnaryOperator_155,axiom,
    ! [VarCurr] :
      ( ~ v529(VarCurr)
    <=> v110(VarCurr,bitIndex39) ) ).

fof(writeUnaryOperator_154,axiom,
    ! [VarCurr] :
      ( ~ v510(VarCurr)
    <=> v511(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_167,axiom,
    ! [VarCurr] :
      ( v511(VarCurr)
    <=> ( v512(VarCurr)
        & v525(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_56,axiom,
    ! [VarCurr] :
      ( v525(VarCurr)
    <=> ( v110(VarCurr,bitIndex35)
        | v515(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_166,axiom,
    ! [VarCurr] :
      ( v512(VarCurr)
    <=> ( v513(VarCurr)
        | v514(VarCurr) ) ) ).

fof(writeUnaryOperator_153,axiom,
    ! [VarCurr] :
      ( ~ v514(VarCurr)
    <=> v515(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_165,axiom,
    ! [VarCurr] :
      ( v515(VarCurr)
    <=> ( v516(VarCurr)
        & v524(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_55,axiom,
    ! [VarCurr] :
      ( v524(VarCurr)
    <=> ( v110(VarCurr,bitIndex34)
        | v519(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_164,axiom,
    ! [VarCurr] :
      ( v516(VarCurr)
    <=> ( v517(VarCurr)
        | v518(VarCurr) ) ) ).

fof(writeUnaryOperator_152,axiom,
    ! [VarCurr] :
      ( ~ v518(VarCurr)
    <=> v519(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_163,axiom,
    ! [VarCurr] :
      ( v519(VarCurr)
    <=> ( v520(VarCurr)
        & v523(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_54,axiom,
    ! [VarCurr] :
      ( v523(VarCurr)
    <=> ( v110(VarCurr,bitIndex32)
        | v110(VarCurr,bitIndex33) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_162,axiom,
    ! [VarCurr] :
      ( v520(VarCurr)
    <=> ( v521(VarCurr)
        | v522(VarCurr) ) ) ).

fof(writeUnaryOperator_151,axiom,
    ! [VarCurr] :
      ( ~ v522(VarCurr)
    <=> v110(VarCurr,bitIndex33) ) ).

fof(writeUnaryOperator_150,axiom,
    ! [VarCurr] :
      ( ~ v521(VarCurr)
    <=> v110(VarCurr,bitIndex32) ) ).

fof(writeUnaryOperator_149,axiom,
    ! [VarCurr] :
      ( ~ v517(VarCurr)
    <=> v110(VarCurr,bitIndex34) ) ).

fof(writeUnaryOperator_148,axiom,
    ! [VarCurr] :
      ( ~ v513(VarCurr)
    <=> v110(VarCurr,bitIndex35) ) ).

fof(writeUnaryOperator_147,axiom,
    ! [VarCurr] :
      ( ~ v491(VarCurr)
    <=> v492(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_161,axiom,
    ! [VarCurr] :
      ( v492(VarCurr)
    <=> ( v493(VarCurr)
        & v506(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_53,axiom,
    ! [VarCurr] :
      ( v506(VarCurr)
    <=> ( v110(VarCurr,bitIndex43)
        | v496(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_160,axiom,
    ! [VarCurr] :
      ( v493(VarCurr)
    <=> ( v494(VarCurr)
        | v495(VarCurr) ) ) ).

fof(writeUnaryOperator_146,axiom,
    ! [VarCurr] :
      ( ~ v495(VarCurr)
    <=> v496(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_159,axiom,
    ! [VarCurr] :
      ( v496(VarCurr)
    <=> ( v497(VarCurr)
        & v505(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_52,axiom,
    ! [VarCurr] :
      ( v505(VarCurr)
    <=> ( v110(VarCurr,bitIndex42)
        | v500(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_158,axiom,
    ! [VarCurr] :
      ( v497(VarCurr)
    <=> ( v498(VarCurr)
        | v499(VarCurr) ) ) ).

fof(writeUnaryOperator_145,axiom,
    ! [VarCurr] :
      ( ~ v499(VarCurr)
    <=> v500(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_157,axiom,
    ! [VarCurr] :
      ( v500(VarCurr)
    <=> ( v501(VarCurr)
        & v504(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_51,axiom,
    ! [VarCurr] :
      ( v504(VarCurr)
    <=> ( v110(VarCurr,bitIndex40)
        | v110(VarCurr,bitIndex41) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_156,axiom,
    ! [VarCurr] :
      ( v501(VarCurr)
    <=> ( v502(VarCurr)
        | v503(VarCurr) ) ) ).

fof(writeUnaryOperator_144,axiom,
    ! [VarCurr] :
      ( ~ v503(VarCurr)
    <=> v110(VarCurr,bitIndex41) ) ).

fof(writeUnaryOperator_143,axiom,
    ! [VarCurr] :
      ( ~ v502(VarCurr)
    <=> v110(VarCurr,bitIndex40) ) ).

fof(writeUnaryOperator_142,axiom,
    ! [VarCurr] :
      ( ~ v498(VarCurr)
    <=> v110(VarCurr,bitIndex42) ) ).

fof(writeUnaryOperator_141,axiom,
    ! [VarCurr] :
      ( ~ v494(VarCurr)
    <=> v110(VarCurr,bitIndex43) ) ).

fof(writeUnaryOperator_140,axiom,
    ! [VarCurr] :
      ( ~ v472(VarCurr)
    <=> v473(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_155,axiom,
    ! [VarCurr] :
      ( v473(VarCurr)
    <=> ( v474(VarCurr)
        & v487(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_50,axiom,
    ! [VarCurr] :
      ( v487(VarCurr)
    <=> ( v110(VarCurr,bitIndex47)
        | v477(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_154,axiom,
    ! [VarCurr] :
      ( v474(VarCurr)
    <=> ( v475(VarCurr)
        | v476(VarCurr) ) ) ).

fof(writeUnaryOperator_139,axiom,
    ! [VarCurr] :
      ( ~ v476(VarCurr)
    <=> v477(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_153,axiom,
    ! [VarCurr] :
      ( v477(VarCurr)
    <=> ( v478(VarCurr)
        & v486(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_49,axiom,
    ! [VarCurr] :
      ( v486(VarCurr)
    <=> ( v110(VarCurr,bitIndex46)
        | v481(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_152,axiom,
    ! [VarCurr] :
      ( v478(VarCurr)
    <=> ( v479(VarCurr)
        | v480(VarCurr) ) ) ).

fof(writeUnaryOperator_138,axiom,
    ! [VarCurr] :
      ( ~ v480(VarCurr)
    <=> v481(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_151,axiom,
    ! [VarCurr] :
      ( v481(VarCurr)
    <=> ( v482(VarCurr)
        & v485(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_48,axiom,
    ! [VarCurr] :
      ( v485(VarCurr)
    <=> ( v110(VarCurr,bitIndex44)
        | v110(VarCurr,bitIndex45) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_150,axiom,
    ! [VarCurr] :
      ( v482(VarCurr)
    <=> ( v483(VarCurr)
        | v484(VarCurr) ) ) ).

fof(writeUnaryOperator_137,axiom,
    ! [VarCurr] :
      ( ~ v484(VarCurr)
    <=> v110(VarCurr,bitIndex45) ) ).

fof(writeUnaryOperator_136,axiom,
    ! [VarCurr] :
      ( ~ v483(VarCurr)
    <=> v110(VarCurr,bitIndex44) ) ).

fof(writeUnaryOperator_135,axiom,
    ! [VarCurr] :
      ( ~ v479(VarCurr)
    <=> v110(VarCurr,bitIndex46) ) ).

fof(writeUnaryOperator_134,axiom,
    ! [VarCurr] :
      ( ~ v475(VarCurr)
    <=> v110(VarCurr,bitIndex47) ) ).

fof(addAssignment_29,axiom,
    ! [VarNext,B] :
      ( range_63_32(B)
     => ( v110(VarNext,B)
      <=> v458(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_5,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v459(VarNext)
       => ! [B] :
            ( range_127_0(B)
           => ( v458(VarNext,B)
            <=> v110(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_5,axiom,
    ! [VarNext] :
      ( v459(VarNext)
     => ! [B] :
          ( range_127_0(B)
         => ( v458(VarNext,B)
          <=> v128(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_149,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v459(VarNext)
      <=> v460(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_148,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v460(VarNext)
      <=> ( v462(VarNext)
          & v58(VarNext) ) ) ) ).

fof(writeUnaryOperator_133,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v462(VarNext)
      <=> v67(VarNext) ) ) ).

fof(addAssignment_28,axiom,
    ! [VarCurr,B] :
      ( range_63_32(B)
     => ( v113(VarCurr,B)
      <=> v115(VarCurr,B) ) ) ).

fof(addAssignment_27,axiom,
    ! [VarCurr,B] :
      ( range_63_32(B)
     => ( v115(VarCurr,B)
      <=> v117(VarCurr,B) ) ) ).

fof(range_axiom_3,axiom,
    ! [B] :
      ( range_63_32(B)
    <=> ( $false
        | bitIndex32 = B
        | bitIndex33 = B
        | bitIndex34 = B
        | bitIndex35 = B
        | bitIndex36 = B
        | bitIndex37 = B
        | bitIndex38 = B
        | bitIndex39 = B
        | bitIndex40 = B
        | bitIndex41 = B
        | bitIndex42 = B
        | bitIndex43 = B
        | bitIndex44 = B
        | bitIndex45 = B
        | bitIndex46 = B
        | bitIndex47 = B
        | bitIndex48 = B
        | bitIndex49 = B
        | bitIndex50 = B
        | bitIndex51 = B
        | bitIndex52 = B
        | bitIndex53 = B
        | bitIndex54 = B
        | bitIndex55 = B
        | bitIndex56 = B
        | bitIndex57 = B
        | bitIndex58 = B
        | bitIndex59 = B
        | bitIndex60 = B
        | bitIndex61 = B
        | bitIndex62 = B
        | bitIndex63 = B ) ) ).

fof(writeUnaryOperator_132,axiom,
    ! [VarCurr] :
      ( ~ v289(VarCurr)
    <=> v299(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_147,axiom,
    ! [VarCurr] :
      ( v299(VarCurr)
    <=> ( v301(VarCurr)
        & v454(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_146,axiom,
    ! [VarCurr] :
      ( v454(VarCurr)
    <=> ( v303(VarCurr)
        | v379(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_145,axiom,
    ! [VarCurr] :
      ( v301(VarCurr)
    <=> ( v302(VarCurr)
        | v378(VarCurr) ) ) ).

fof(writeUnaryOperator_131,axiom,
    ! [VarCurr] :
      ( ~ v378(VarCurr)
    <=> v379(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_144,axiom,
    ! [VarCurr] :
      ( v379(VarCurr)
    <=> ( v380(VarCurr)
        & v453(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_143,axiom,
    ! [VarCurr] :
      ( v453(VarCurr)
    <=> ( v382(VarCurr)
        | v398(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_142,axiom,
    ! [VarCurr] :
      ( v380(VarCurr)
    <=> ( v381(VarCurr)
        | v397(VarCurr) ) ) ).

fof(writeUnaryOperator_130,axiom,
    ! [VarCurr] :
      ( ~ v397(VarCurr)
    <=> v398(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_141,axiom,
    ! [VarCurr] :
      ( v398(VarCurr)
    <=> ( v399(VarCurr)
        & v452(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_140,axiom,
    ! [VarCurr] :
      ( v452(VarCurr)
    <=> ( v401(VarCurr)
        | v417(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_139,axiom,
    ! [VarCurr] :
      ( v399(VarCurr)
    <=> ( v400(VarCurr)
        | v416(VarCurr) ) ) ).

fof(writeUnaryOperator_129,axiom,
    ! [VarCurr] :
      ( ~ v416(VarCurr)
    <=> v417(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_138,axiom,
    ! [VarCurr] :
      ( v417(VarCurr)
    <=> ( v418(VarCurr)
        & v451(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_137,axiom,
    ! [VarCurr] :
      ( v451(VarCurr)
    <=> ( v420(VarCurr)
        | v436(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_136,axiom,
    ! [VarCurr] :
      ( v418(VarCurr)
    <=> ( v419(VarCurr)
        | v435(VarCurr) ) ) ).

fof(writeUnaryOperator_128,axiom,
    ! [VarCurr] :
      ( ~ v435(VarCurr)
    <=> v436(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_135,axiom,
    ! [VarCurr] :
      ( v436(VarCurr)
    <=> ( v437(VarCurr)
        & v450(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_47,axiom,
    ! [VarCurr] :
      ( v450(VarCurr)
    <=> ( v110(VarCurr,bitIndex87)
        | v440(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_134,axiom,
    ! [VarCurr] :
      ( v437(VarCurr)
    <=> ( v438(VarCurr)
        | v439(VarCurr) ) ) ).

fof(writeUnaryOperator_127,axiom,
    ! [VarCurr] :
      ( ~ v439(VarCurr)
    <=> v440(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_133,axiom,
    ! [VarCurr] :
      ( v440(VarCurr)
    <=> ( v441(VarCurr)
        & v449(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_46,axiom,
    ! [VarCurr] :
      ( v449(VarCurr)
    <=> ( v110(VarCurr,bitIndex86)
        | v444(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_132,axiom,
    ! [VarCurr] :
      ( v441(VarCurr)
    <=> ( v442(VarCurr)
        | v443(VarCurr) ) ) ).

fof(writeUnaryOperator_126,axiom,
    ! [VarCurr] :
      ( ~ v443(VarCurr)
    <=> v444(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_131,axiom,
    ! [VarCurr] :
      ( v444(VarCurr)
    <=> ( v445(VarCurr)
        & v448(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_45,axiom,
    ! [VarCurr] :
      ( v448(VarCurr)
    <=> ( v110(VarCurr,bitIndex84)
        | v110(VarCurr,bitIndex85) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_130,axiom,
    ! [VarCurr] :
      ( v445(VarCurr)
    <=> ( v446(VarCurr)
        | v447(VarCurr) ) ) ).

fof(writeUnaryOperator_125,axiom,
    ! [VarCurr] :
      ( ~ v447(VarCurr)
    <=> v110(VarCurr,bitIndex85) ) ).

fof(writeUnaryOperator_124,axiom,
    ! [VarCurr] :
      ( ~ v446(VarCurr)
    <=> v110(VarCurr,bitIndex84) ) ).

fof(writeUnaryOperator_123,axiom,
    ! [VarCurr] :
      ( ~ v442(VarCurr)
    <=> v110(VarCurr,bitIndex86) ) ).

fof(writeUnaryOperator_122,axiom,
    ! [VarCurr] :
      ( ~ v438(VarCurr)
    <=> v110(VarCurr,bitIndex87) ) ).

fof(writeUnaryOperator_121,axiom,
    ! [VarCurr] :
      ( ~ v419(VarCurr)
    <=> v420(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_129,axiom,
    ! [VarCurr] :
      ( v420(VarCurr)
    <=> ( v421(VarCurr)
        & v434(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_44,axiom,
    ! [VarCurr] :
      ( v434(VarCurr)
    <=> ( v110(VarCurr,bitIndex83)
        | v424(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_128,axiom,
    ! [VarCurr] :
      ( v421(VarCurr)
    <=> ( v422(VarCurr)
        | v423(VarCurr) ) ) ).

fof(writeUnaryOperator_120,axiom,
    ! [VarCurr] :
      ( ~ v423(VarCurr)
    <=> v424(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_127,axiom,
    ! [VarCurr] :
      ( v424(VarCurr)
    <=> ( v425(VarCurr)
        & v433(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_43,axiom,
    ! [VarCurr] :
      ( v433(VarCurr)
    <=> ( v110(VarCurr,bitIndex82)
        | v428(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_126,axiom,
    ! [VarCurr] :
      ( v425(VarCurr)
    <=> ( v426(VarCurr)
        | v427(VarCurr) ) ) ).

fof(writeUnaryOperator_119,axiom,
    ! [VarCurr] :
      ( ~ v427(VarCurr)
    <=> v428(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_125,axiom,
    ! [VarCurr] :
      ( v428(VarCurr)
    <=> ( v429(VarCurr)
        & v432(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_42,axiom,
    ! [VarCurr] :
      ( v432(VarCurr)
    <=> ( v110(VarCurr,bitIndex80)
        | v110(VarCurr,bitIndex81) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_124,axiom,
    ! [VarCurr] :
      ( v429(VarCurr)
    <=> ( v430(VarCurr)
        | v431(VarCurr) ) ) ).

fof(writeUnaryOperator_118,axiom,
    ! [VarCurr] :
      ( ~ v431(VarCurr)
    <=> v110(VarCurr,bitIndex81) ) ).

fof(writeUnaryOperator_117,axiom,
    ! [VarCurr] :
      ( ~ v430(VarCurr)
    <=> v110(VarCurr,bitIndex80) ) ).

fof(writeUnaryOperator_116,axiom,
    ! [VarCurr] :
      ( ~ v426(VarCurr)
    <=> v110(VarCurr,bitIndex82) ) ).

fof(writeUnaryOperator_115,axiom,
    ! [VarCurr] :
      ( ~ v422(VarCurr)
    <=> v110(VarCurr,bitIndex83) ) ).

fof(writeUnaryOperator_114,axiom,
    ! [VarCurr] :
      ( ~ v400(VarCurr)
    <=> v401(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_123,axiom,
    ! [VarCurr] :
      ( v401(VarCurr)
    <=> ( v402(VarCurr)
        & v415(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_41,axiom,
    ! [VarCurr] :
      ( v415(VarCurr)
    <=> ( v110(VarCurr,bitIndex91)
        | v405(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_122,axiom,
    ! [VarCurr] :
      ( v402(VarCurr)
    <=> ( v403(VarCurr)
        | v404(VarCurr) ) ) ).

fof(writeUnaryOperator_113,axiom,
    ! [VarCurr] :
      ( ~ v404(VarCurr)
    <=> v405(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_121,axiom,
    ! [VarCurr] :
      ( v405(VarCurr)
    <=> ( v406(VarCurr)
        & v414(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_40,axiom,
    ! [VarCurr] :
      ( v414(VarCurr)
    <=> ( v110(VarCurr,bitIndex90)
        | v409(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_120,axiom,
    ! [VarCurr] :
      ( v406(VarCurr)
    <=> ( v407(VarCurr)
        | v408(VarCurr) ) ) ).

fof(writeUnaryOperator_112,axiom,
    ! [VarCurr] :
      ( ~ v408(VarCurr)
    <=> v409(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_119,axiom,
    ! [VarCurr] :
      ( v409(VarCurr)
    <=> ( v410(VarCurr)
        & v413(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_39,axiom,
    ! [VarCurr] :
      ( v413(VarCurr)
    <=> ( v110(VarCurr,bitIndex88)
        | v110(VarCurr,bitIndex89) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_118,axiom,
    ! [VarCurr] :
      ( v410(VarCurr)
    <=> ( v411(VarCurr)
        | v412(VarCurr) ) ) ).

fof(writeUnaryOperator_111,axiom,
    ! [VarCurr] :
      ( ~ v412(VarCurr)
    <=> v110(VarCurr,bitIndex89) ) ).

fof(writeUnaryOperator_110,axiom,
    ! [VarCurr] :
      ( ~ v411(VarCurr)
    <=> v110(VarCurr,bitIndex88) ) ).

fof(writeUnaryOperator_109,axiom,
    ! [VarCurr] :
      ( ~ v407(VarCurr)
    <=> v110(VarCurr,bitIndex90) ) ).

fof(writeUnaryOperator_108,axiom,
    ! [VarCurr] :
      ( ~ v403(VarCurr)
    <=> v110(VarCurr,bitIndex91) ) ).

fof(writeUnaryOperator_107,axiom,
    ! [VarCurr] :
      ( ~ v381(VarCurr)
    <=> v382(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_117,axiom,
    ! [VarCurr] :
      ( v382(VarCurr)
    <=> ( v383(VarCurr)
        & v396(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_38,axiom,
    ! [VarCurr] :
      ( v396(VarCurr)
    <=> ( v110(VarCurr,bitIndex95)
        | v386(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_116,axiom,
    ! [VarCurr] :
      ( v383(VarCurr)
    <=> ( v384(VarCurr)
        | v385(VarCurr) ) ) ).

fof(writeUnaryOperator_106,axiom,
    ! [VarCurr] :
      ( ~ v385(VarCurr)
    <=> v386(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_115,axiom,
    ! [VarCurr] :
      ( v386(VarCurr)
    <=> ( v387(VarCurr)
        & v395(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_37,axiom,
    ! [VarCurr] :
      ( v395(VarCurr)
    <=> ( v110(VarCurr,bitIndex94)
        | v390(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_114,axiom,
    ! [VarCurr] :
      ( v387(VarCurr)
    <=> ( v388(VarCurr)
        | v389(VarCurr) ) ) ).

fof(writeUnaryOperator_105,axiom,
    ! [VarCurr] :
      ( ~ v389(VarCurr)
    <=> v390(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_113,axiom,
    ! [VarCurr] :
      ( v390(VarCurr)
    <=> ( v391(VarCurr)
        & v394(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_36,axiom,
    ! [VarCurr] :
      ( v394(VarCurr)
    <=> ( v110(VarCurr,bitIndex92)
        | v110(VarCurr,bitIndex93) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_112,axiom,
    ! [VarCurr] :
      ( v391(VarCurr)
    <=> ( v392(VarCurr)
        | v393(VarCurr) ) ) ).

fof(writeUnaryOperator_104,axiom,
    ! [VarCurr] :
      ( ~ v393(VarCurr)
    <=> v110(VarCurr,bitIndex93) ) ).

fof(writeUnaryOperator_103,axiom,
    ! [VarCurr] :
      ( ~ v392(VarCurr)
    <=> v110(VarCurr,bitIndex92) ) ).

fof(writeUnaryOperator_102,axiom,
    ! [VarCurr] :
      ( ~ v388(VarCurr)
    <=> v110(VarCurr,bitIndex94) ) ).

fof(writeUnaryOperator_101,axiom,
    ! [VarCurr] :
      ( ~ v384(VarCurr)
    <=> v110(VarCurr,bitIndex95) ) ).

fof(writeUnaryOperator_100,axiom,
    ! [VarCurr] :
      ( ~ v302(VarCurr)
    <=> v303(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_111,axiom,
    ! [VarCurr] :
      ( v303(VarCurr)
    <=> ( v304(VarCurr)
        & v377(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_110,axiom,
    ! [VarCurr] :
      ( v377(VarCurr)
    <=> ( v306(VarCurr)
        | v322(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_109,axiom,
    ! [VarCurr] :
      ( v304(VarCurr)
    <=> ( v305(VarCurr)
        | v321(VarCurr) ) ) ).

fof(writeUnaryOperator_99,axiom,
    ! [VarCurr] :
      ( ~ v321(VarCurr)
    <=> v322(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_108,axiom,
    ! [VarCurr] :
      ( v322(VarCurr)
    <=> ( v323(VarCurr)
        & v376(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_107,axiom,
    ! [VarCurr] :
      ( v376(VarCurr)
    <=> ( v325(VarCurr)
        | v341(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_106,axiom,
    ! [VarCurr] :
      ( v323(VarCurr)
    <=> ( v324(VarCurr)
        | v340(VarCurr) ) ) ).

fof(writeUnaryOperator_98,axiom,
    ! [VarCurr] :
      ( ~ v340(VarCurr)
    <=> v341(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_105,axiom,
    ! [VarCurr] :
      ( v341(VarCurr)
    <=> ( v342(VarCurr)
        & v375(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_104,axiom,
    ! [VarCurr] :
      ( v375(VarCurr)
    <=> ( v344(VarCurr)
        | v360(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_103,axiom,
    ! [VarCurr] :
      ( v342(VarCurr)
    <=> ( v343(VarCurr)
        | v359(VarCurr) ) ) ).

fof(writeUnaryOperator_97,axiom,
    ! [VarCurr] :
      ( ~ v359(VarCurr)
    <=> v360(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_102,axiom,
    ! [VarCurr] :
      ( v360(VarCurr)
    <=> ( v361(VarCurr)
        & v374(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_35,axiom,
    ! [VarCurr] :
      ( v374(VarCurr)
    <=> ( v110(VarCurr,bitIndex71)
        | v364(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_101,axiom,
    ! [VarCurr] :
      ( v361(VarCurr)
    <=> ( v362(VarCurr)
        | v363(VarCurr) ) ) ).

fof(writeUnaryOperator_96,axiom,
    ! [VarCurr] :
      ( ~ v363(VarCurr)
    <=> v364(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_100,axiom,
    ! [VarCurr] :
      ( v364(VarCurr)
    <=> ( v365(VarCurr)
        & v373(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_34,axiom,
    ! [VarCurr] :
      ( v373(VarCurr)
    <=> ( v110(VarCurr,bitIndex70)
        | v368(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_99,axiom,
    ! [VarCurr] :
      ( v365(VarCurr)
    <=> ( v366(VarCurr)
        | v367(VarCurr) ) ) ).

fof(writeUnaryOperator_95,axiom,
    ! [VarCurr] :
      ( ~ v367(VarCurr)
    <=> v368(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_98,axiom,
    ! [VarCurr] :
      ( v368(VarCurr)
    <=> ( v369(VarCurr)
        & v372(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_33,axiom,
    ! [VarCurr] :
      ( v372(VarCurr)
    <=> ( v110(VarCurr,bitIndex68)
        | v110(VarCurr,bitIndex69) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_97,axiom,
    ! [VarCurr] :
      ( v369(VarCurr)
    <=> ( v370(VarCurr)
        | v371(VarCurr) ) ) ).

fof(writeUnaryOperator_94,axiom,
    ! [VarCurr] :
      ( ~ v371(VarCurr)
    <=> v110(VarCurr,bitIndex69) ) ).

fof(writeUnaryOperator_93,axiom,
    ! [VarCurr] :
      ( ~ v370(VarCurr)
    <=> v110(VarCurr,bitIndex68) ) ).

fof(writeUnaryOperator_92,axiom,
    ! [VarCurr] :
      ( ~ v366(VarCurr)
    <=> v110(VarCurr,bitIndex70) ) ).

fof(writeUnaryOperator_91,axiom,
    ! [VarCurr] :
      ( ~ v362(VarCurr)
    <=> v110(VarCurr,bitIndex71) ) ).

fof(writeUnaryOperator_90,axiom,
    ! [VarCurr] :
      ( ~ v343(VarCurr)
    <=> v344(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_96,axiom,
    ! [VarCurr] :
      ( v344(VarCurr)
    <=> ( v345(VarCurr)
        & v358(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_32,axiom,
    ! [VarCurr] :
      ( v358(VarCurr)
    <=> ( v110(VarCurr,bitIndex67)
        | v348(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_95,axiom,
    ! [VarCurr] :
      ( v345(VarCurr)
    <=> ( v346(VarCurr)
        | v347(VarCurr) ) ) ).

fof(writeUnaryOperator_89,axiom,
    ! [VarCurr] :
      ( ~ v347(VarCurr)
    <=> v348(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_94,axiom,
    ! [VarCurr] :
      ( v348(VarCurr)
    <=> ( v349(VarCurr)
        & v357(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_31,axiom,
    ! [VarCurr] :
      ( v357(VarCurr)
    <=> ( v110(VarCurr,bitIndex66)
        | v352(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_93,axiom,
    ! [VarCurr] :
      ( v349(VarCurr)
    <=> ( v350(VarCurr)
        | v351(VarCurr) ) ) ).

fof(writeUnaryOperator_88,axiom,
    ! [VarCurr] :
      ( ~ v351(VarCurr)
    <=> v352(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_92,axiom,
    ! [VarCurr] :
      ( v352(VarCurr)
    <=> ( v353(VarCurr)
        & v356(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_30,axiom,
    ! [VarCurr] :
      ( v356(VarCurr)
    <=> ( v110(VarCurr,bitIndex64)
        | v110(VarCurr,bitIndex65) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_91,axiom,
    ! [VarCurr] :
      ( v353(VarCurr)
    <=> ( v354(VarCurr)
        | v355(VarCurr) ) ) ).

fof(writeUnaryOperator_87,axiom,
    ! [VarCurr] :
      ( ~ v355(VarCurr)
    <=> v110(VarCurr,bitIndex65) ) ).

fof(writeUnaryOperator_86,axiom,
    ! [VarCurr] :
      ( ~ v354(VarCurr)
    <=> v110(VarCurr,bitIndex64) ) ).

fof(writeUnaryOperator_85,axiom,
    ! [VarCurr] :
      ( ~ v350(VarCurr)
    <=> v110(VarCurr,bitIndex66) ) ).

fof(writeUnaryOperator_84,axiom,
    ! [VarCurr] :
      ( ~ v346(VarCurr)
    <=> v110(VarCurr,bitIndex67) ) ).

fof(writeUnaryOperator_83,axiom,
    ! [VarCurr] :
      ( ~ v324(VarCurr)
    <=> v325(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_90,axiom,
    ! [VarCurr] :
      ( v325(VarCurr)
    <=> ( v326(VarCurr)
        & v339(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_29,axiom,
    ! [VarCurr] :
      ( v339(VarCurr)
    <=> ( v110(VarCurr,bitIndex75)
        | v329(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_89,axiom,
    ! [VarCurr] :
      ( v326(VarCurr)
    <=> ( v327(VarCurr)
        | v328(VarCurr) ) ) ).

fof(writeUnaryOperator_82,axiom,
    ! [VarCurr] :
      ( ~ v328(VarCurr)
    <=> v329(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_88,axiom,
    ! [VarCurr] :
      ( v329(VarCurr)
    <=> ( v330(VarCurr)
        & v338(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_28,axiom,
    ! [VarCurr] :
      ( v338(VarCurr)
    <=> ( v110(VarCurr,bitIndex74)
        | v333(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_87,axiom,
    ! [VarCurr] :
      ( v330(VarCurr)
    <=> ( v331(VarCurr)
        | v332(VarCurr) ) ) ).

fof(writeUnaryOperator_81,axiom,
    ! [VarCurr] :
      ( ~ v332(VarCurr)
    <=> v333(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_86,axiom,
    ! [VarCurr] :
      ( v333(VarCurr)
    <=> ( v334(VarCurr)
        & v337(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_27,axiom,
    ! [VarCurr] :
      ( v337(VarCurr)
    <=> ( v110(VarCurr,bitIndex72)
        | v110(VarCurr,bitIndex73) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_85,axiom,
    ! [VarCurr] :
      ( v334(VarCurr)
    <=> ( v335(VarCurr)
        | v336(VarCurr) ) ) ).

fof(writeUnaryOperator_80,axiom,
    ! [VarCurr] :
      ( ~ v336(VarCurr)
    <=> v110(VarCurr,bitIndex73) ) ).

fof(writeUnaryOperator_79,axiom,
    ! [VarCurr] :
      ( ~ v335(VarCurr)
    <=> v110(VarCurr,bitIndex72) ) ).

fof(writeUnaryOperator_78,axiom,
    ! [VarCurr] :
      ( ~ v331(VarCurr)
    <=> v110(VarCurr,bitIndex74) ) ).

fof(writeUnaryOperator_77,axiom,
    ! [VarCurr] :
      ( ~ v327(VarCurr)
    <=> v110(VarCurr,bitIndex75) ) ).

fof(writeUnaryOperator_76,axiom,
    ! [VarCurr] :
      ( ~ v305(VarCurr)
    <=> v306(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_84,axiom,
    ! [VarCurr] :
      ( v306(VarCurr)
    <=> ( v307(VarCurr)
        & v320(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_26,axiom,
    ! [VarCurr] :
      ( v320(VarCurr)
    <=> ( v110(VarCurr,bitIndex79)
        | v310(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_83,axiom,
    ! [VarCurr] :
      ( v307(VarCurr)
    <=> ( v308(VarCurr)
        | v309(VarCurr) ) ) ).

fof(writeUnaryOperator_75,axiom,
    ! [VarCurr] :
      ( ~ v309(VarCurr)
    <=> v310(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_82,axiom,
    ! [VarCurr] :
      ( v310(VarCurr)
    <=> ( v311(VarCurr)
        & v319(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_25,axiom,
    ! [VarCurr] :
      ( v319(VarCurr)
    <=> ( v110(VarCurr,bitIndex78)
        | v314(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_81,axiom,
    ! [VarCurr] :
      ( v311(VarCurr)
    <=> ( v312(VarCurr)
        | v313(VarCurr) ) ) ).

fof(writeUnaryOperator_74,axiom,
    ! [VarCurr] :
      ( ~ v313(VarCurr)
    <=> v314(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_80,axiom,
    ! [VarCurr] :
      ( v314(VarCurr)
    <=> ( v315(VarCurr)
        & v318(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_24,axiom,
    ! [VarCurr] :
      ( v318(VarCurr)
    <=> ( v110(VarCurr,bitIndex76)
        | v110(VarCurr,bitIndex77) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_79,axiom,
    ! [VarCurr] :
      ( v315(VarCurr)
    <=> ( v316(VarCurr)
        | v317(VarCurr) ) ) ).

fof(writeUnaryOperator_73,axiom,
    ! [VarCurr] :
      ( ~ v317(VarCurr)
    <=> v110(VarCurr,bitIndex77) ) ).

fof(writeUnaryOperator_72,axiom,
    ! [VarCurr] :
      ( ~ v316(VarCurr)
    <=> v110(VarCurr,bitIndex76) ) ).

fof(writeUnaryOperator_71,axiom,
    ! [VarCurr] :
      ( ~ v312(VarCurr)
    <=> v110(VarCurr,bitIndex78) ) ).

fof(writeUnaryOperator_70,axiom,
    ! [VarCurr] :
      ( ~ v308(VarCurr)
    <=> v110(VarCurr,bitIndex79) ) ).

fof(addAssignment_26,axiom,
    ! [VarNext,B] :
      ( range_95_64(B)
     => ( v110(VarNext,B)
      <=> v291(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_4,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v292(VarNext)
       => ! [B] :
            ( range_127_0(B)
           => ( v291(VarNext,B)
            <=> v110(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_4,axiom,
    ! [VarNext] :
      ( v292(VarNext)
     => ! [B] :
          ( range_127_0(B)
         => ( v291(VarNext,B)
          <=> v128(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_78,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v292(VarNext)
      <=> v293(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_77,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v293(VarNext)
      <=> ( v295(VarNext)
          & v58(VarNext) ) ) ) ).

fof(writeUnaryOperator_69,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v295(VarNext)
      <=> v67(VarNext) ) ) ).

fof(addAssignment_25,axiom,
    ! [VarCurr,B] :
      ( range_95_64(B)
     => ( v113(VarCurr,B)
      <=> v115(VarCurr,B) ) ) ).

fof(addAssignment_24,axiom,
    ! [VarCurr,B] :
      ( range_95_64(B)
     => ( v115(VarCurr,B)
      <=> v117(VarCurr,B) ) ) ).

fof(range_axiom_2,axiom,
    ! [B] :
      ( range_95_64(B)
    <=> ( $false
        | bitIndex64 = B
        | bitIndex65 = B
        | bitIndex66 = B
        | bitIndex67 = B
        | bitIndex68 = B
        | bitIndex69 = B
        | bitIndex70 = B
        | bitIndex71 = B
        | bitIndex72 = B
        | bitIndex73 = B
        | bitIndex74 = B
        | bitIndex75 = B
        | bitIndex76 = B
        | bitIndex77 = B
        | bitIndex78 = B
        | bitIndex79 = B
        | bitIndex80 = B
        | bitIndex81 = B
        | bitIndex82 = B
        | bitIndex83 = B
        | bitIndex84 = B
        | bitIndex85 = B
        | bitIndex86 = B
        | bitIndex87 = B
        | bitIndex88 = B
        | bitIndex89 = B
        | bitIndex90 = B
        | bitIndex91 = B
        | bitIndex92 = B
        | bitIndex93 = B
        | bitIndex94 = B
        | bitIndex95 = B ) ) ).

fof(writeUnaryOperator_68,axiom,
    ! [VarCurr] :
      ( ~ v108(VarCurr)
    <=> v132(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_76,axiom,
    ! [VarCurr] :
      ( v132(VarCurr)
    <=> ( v134(VarCurr)
        & v287(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_75,axiom,
    ! [VarCurr] :
      ( v287(VarCurr)
    <=> ( v136(VarCurr)
        | v212(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_74,axiom,
    ! [VarCurr] :
      ( v134(VarCurr)
    <=> ( v135(VarCurr)
        | v211(VarCurr) ) ) ).

fof(writeUnaryOperator_67,axiom,
    ! [VarCurr] :
      ( ~ v211(VarCurr)
    <=> v212(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_73,axiom,
    ! [VarCurr] :
      ( v212(VarCurr)
    <=> ( v213(VarCurr)
        & v286(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_72,axiom,
    ! [VarCurr] :
      ( v286(VarCurr)
    <=> ( v215(VarCurr)
        | v231(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_71,axiom,
    ! [VarCurr] :
      ( v213(VarCurr)
    <=> ( v214(VarCurr)
        | v230(VarCurr) ) ) ).

fof(writeUnaryOperator_66,axiom,
    ! [VarCurr] :
      ( ~ v230(VarCurr)
    <=> v231(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_70,axiom,
    ! [VarCurr] :
      ( v231(VarCurr)
    <=> ( v232(VarCurr)
        & v285(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_69,axiom,
    ! [VarCurr] :
      ( v285(VarCurr)
    <=> ( v234(VarCurr)
        | v250(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_68,axiom,
    ! [VarCurr] :
      ( v232(VarCurr)
    <=> ( v233(VarCurr)
        | v249(VarCurr) ) ) ).

fof(writeUnaryOperator_65,axiom,
    ! [VarCurr] :
      ( ~ v249(VarCurr)
    <=> v250(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_67,axiom,
    ! [VarCurr] :
      ( v250(VarCurr)
    <=> ( v251(VarCurr)
        & v284(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_66,axiom,
    ! [VarCurr] :
      ( v284(VarCurr)
    <=> ( v253(VarCurr)
        | v269(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_65,axiom,
    ! [VarCurr] :
      ( v251(VarCurr)
    <=> ( v252(VarCurr)
        | v268(VarCurr) ) ) ).

fof(writeUnaryOperator_64,axiom,
    ! [VarCurr] :
      ( ~ v268(VarCurr)
    <=> v269(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_64,axiom,
    ! [VarCurr] :
      ( v269(VarCurr)
    <=> ( v270(VarCurr)
        & v283(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_23,axiom,
    ! [VarCurr] :
      ( v283(VarCurr)
    <=> ( v110(VarCurr,bitIndex119)
        | v273(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_63,axiom,
    ! [VarCurr] :
      ( v270(VarCurr)
    <=> ( v271(VarCurr)
        | v272(VarCurr) ) ) ).

fof(writeUnaryOperator_63,axiom,
    ! [VarCurr] :
      ( ~ v272(VarCurr)
    <=> v273(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_62,axiom,
    ! [VarCurr] :
      ( v273(VarCurr)
    <=> ( v274(VarCurr)
        & v282(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_22,axiom,
    ! [VarCurr] :
      ( v282(VarCurr)
    <=> ( v110(VarCurr,bitIndex118)
        | v277(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_61,axiom,
    ! [VarCurr] :
      ( v274(VarCurr)
    <=> ( v275(VarCurr)
        | v276(VarCurr) ) ) ).

fof(writeUnaryOperator_62,axiom,
    ! [VarCurr] :
      ( ~ v276(VarCurr)
    <=> v277(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_60,axiom,
    ! [VarCurr] :
      ( v277(VarCurr)
    <=> ( v278(VarCurr)
        & v281(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_21,axiom,
    ! [VarCurr] :
      ( v281(VarCurr)
    <=> ( v110(VarCurr,bitIndex116)
        | v110(VarCurr,bitIndex117) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_59,axiom,
    ! [VarCurr] :
      ( v278(VarCurr)
    <=> ( v279(VarCurr)
        | v280(VarCurr) ) ) ).

fof(writeUnaryOperator_61,axiom,
    ! [VarCurr] :
      ( ~ v280(VarCurr)
    <=> v110(VarCurr,bitIndex117) ) ).

fof(writeUnaryOperator_60,axiom,
    ! [VarCurr] :
      ( ~ v279(VarCurr)
    <=> v110(VarCurr,bitIndex116) ) ).

fof(writeUnaryOperator_59,axiom,
    ! [VarCurr] :
      ( ~ v275(VarCurr)
    <=> v110(VarCurr,bitIndex118) ) ).

fof(writeUnaryOperator_58,axiom,
    ! [VarCurr] :
      ( ~ v271(VarCurr)
    <=> v110(VarCurr,bitIndex119) ) ).

fof(writeUnaryOperator_57,axiom,
    ! [VarCurr] :
      ( ~ v252(VarCurr)
    <=> v253(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_58,axiom,
    ! [VarCurr] :
      ( v253(VarCurr)
    <=> ( v254(VarCurr)
        & v267(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_20,axiom,
    ! [VarCurr] :
      ( v267(VarCurr)
    <=> ( v110(VarCurr,bitIndex115)
        | v257(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_57,axiom,
    ! [VarCurr] :
      ( v254(VarCurr)
    <=> ( v255(VarCurr)
        | v256(VarCurr) ) ) ).

fof(writeUnaryOperator_56,axiom,
    ! [VarCurr] :
      ( ~ v256(VarCurr)
    <=> v257(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_56,axiom,
    ! [VarCurr] :
      ( v257(VarCurr)
    <=> ( v258(VarCurr)
        & v266(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_19,axiom,
    ! [VarCurr] :
      ( v266(VarCurr)
    <=> ( v110(VarCurr,bitIndex114)
        | v261(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_55,axiom,
    ! [VarCurr] :
      ( v258(VarCurr)
    <=> ( v259(VarCurr)
        | v260(VarCurr) ) ) ).

fof(writeUnaryOperator_55,axiom,
    ! [VarCurr] :
      ( ~ v260(VarCurr)
    <=> v261(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_54,axiom,
    ! [VarCurr] :
      ( v261(VarCurr)
    <=> ( v262(VarCurr)
        & v265(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_18,axiom,
    ! [VarCurr] :
      ( v265(VarCurr)
    <=> ( v110(VarCurr,bitIndex112)
        | v110(VarCurr,bitIndex113) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_53,axiom,
    ! [VarCurr] :
      ( v262(VarCurr)
    <=> ( v263(VarCurr)
        | v264(VarCurr) ) ) ).

fof(writeUnaryOperator_54,axiom,
    ! [VarCurr] :
      ( ~ v264(VarCurr)
    <=> v110(VarCurr,bitIndex113) ) ).

fof(writeUnaryOperator_53,axiom,
    ! [VarCurr] :
      ( ~ v263(VarCurr)
    <=> v110(VarCurr,bitIndex112) ) ).

fof(writeUnaryOperator_52,axiom,
    ! [VarCurr] :
      ( ~ v259(VarCurr)
    <=> v110(VarCurr,bitIndex114) ) ).

fof(writeUnaryOperator_51,axiom,
    ! [VarCurr] :
      ( ~ v255(VarCurr)
    <=> v110(VarCurr,bitIndex115) ) ).

fof(writeUnaryOperator_50,axiom,
    ! [VarCurr] :
      ( ~ v233(VarCurr)
    <=> v234(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_52,axiom,
    ! [VarCurr] :
      ( v234(VarCurr)
    <=> ( v235(VarCurr)
        & v248(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_17,axiom,
    ! [VarCurr] :
      ( v248(VarCurr)
    <=> ( v110(VarCurr,bitIndex123)
        | v238(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_51,axiom,
    ! [VarCurr] :
      ( v235(VarCurr)
    <=> ( v236(VarCurr)
        | v237(VarCurr) ) ) ).

fof(writeUnaryOperator_49,axiom,
    ! [VarCurr] :
      ( ~ v237(VarCurr)
    <=> v238(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_50,axiom,
    ! [VarCurr] :
      ( v238(VarCurr)
    <=> ( v239(VarCurr)
        & v247(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_16,axiom,
    ! [VarCurr] :
      ( v247(VarCurr)
    <=> ( v110(VarCurr,bitIndex122)
        | v242(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_49,axiom,
    ! [VarCurr] :
      ( v239(VarCurr)
    <=> ( v240(VarCurr)
        | v241(VarCurr) ) ) ).

fof(writeUnaryOperator_48,axiom,
    ! [VarCurr] :
      ( ~ v241(VarCurr)
    <=> v242(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_48,axiom,
    ! [VarCurr] :
      ( v242(VarCurr)
    <=> ( v243(VarCurr)
        & v246(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_15,axiom,
    ! [VarCurr] :
      ( v246(VarCurr)
    <=> ( v110(VarCurr,bitIndex120)
        | v110(VarCurr,bitIndex121) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_47,axiom,
    ! [VarCurr] :
      ( v243(VarCurr)
    <=> ( v244(VarCurr)
        | v245(VarCurr) ) ) ).

fof(writeUnaryOperator_47,axiom,
    ! [VarCurr] :
      ( ~ v245(VarCurr)
    <=> v110(VarCurr,bitIndex121) ) ).

fof(writeUnaryOperator_46,axiom,
    ! [VarCurr] :
      ( ~ v244(VarCurr)
    <=> v110(VarCurr,bitIndex120) ) ).

fof(writeUnaryOperator_45,axiom,
    ! [VarCurr] :
      ( ~ v240(VarCurr)
    <=> v110(VarCurr,bitIndex122) ) ).

fof(writeUnaryOperator_44,axiom,
    ! [VarCurr] :
      ( ~ v236(VarCurr)
    <=> v110(VarCurr,bitIndex123) ) ).

fof(writeUnaryOperator_43,axiom,
    ! [VarCurr] :
      ( ~ v214(VarCurr)
    <=> v215(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_46,axiom,
    ! [VarCurr] :
      ( v215(VarCurr)
    <=> ( v216(VarCurr)
        & v229(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_14,axiom,
    ! [VarCurr] :
      ( v229(VarCurr)
    <=> ( v110(VarCurr,bitIndex127)
        | v219(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_45,axiom,
    ! [VarCurr] :
      ( v216(VarCurr)
    <=> ( v217(VarCurr)
        | v218(VarCurr) ) ) ).

fof(writeUnaryOperator_42,axiom,
    ! [VarCurr] :
      ( ~ v218(VarCurr)
    <=> v219(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_44,axiom,
    ! [VarCurr] :
      ( v219(VarCurr)
    <=> ( v220(VarCurr)
        & v228(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_13,axiom,
    ! [VarCurr] :
      ( v228(VarCurr)
    <=> ( v110(VarCurr,bitIndex126)
        | v223(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_43,axiom,
    ! [VarCurr] :
      ( v220(VarCurr)
    <=> ( v221(VarCurr)
        | v222(VarCurr) ) ) ).

fof(writeUnaryOperator_41,axiom,
    ! [VarCurr] :
      ( ~ v222(VarCurr)
    <=> v223(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_42,axiom,
    ! [VarCurr] :
      ( v223(VarCurr)
    <=> ( v224(VarCurr)
        & v227(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_12,axiom,
    ! [VarCurr] :
      ( v227(VarCurr)
    <=> ( v110(VarCurr,bitIndex124)
        | v110(VarCurr,bitIndex125) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_41,axiom,
    ! [VarCurr] :
      ( v224(VarCurr)
    <=> ( v225(VarCurr)
        | v226(VarCurr) ) ) ).

fof(writeUnaryOperator_40,axiom,
    ! [VarCurr] :
      ( ~ v226(VarCurr)
    <=> v110(VarCurr,bitIndex125) ) ).

fof(writeUnaryOperator_39,axiom,
    ! [VarCurr] :
      ( ~ v225(VarCurr)
    <=> v110(VarCurr,bitIndex124) ) ).

fof(writeUnaryOperator_38,axiom,
    ! [VarCurr] :
      ( ~ v221(VarCurr)
    <=> v110(VarCurr,bitIndex126) ) ).

fof(writeUnaryOperator_37,axiom,
    ! [VarCurr] :
      ( ~ v217(VarCurr)
    <=> v110(VarCurr,bitIndex127) ) ).

fof(writeUnaryOperator_36,axiom,
    ! [VarCurr] :
      ( ~ v135(VarCurr)
    <=> v136(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_40,axiom,
    ! [VarCurr] :
      ( v136(VarCurr)
    <=> ( v137(VarCurr)
        & v210(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_39,axiom,
    ! [VarCurr] :
      ( v210(VarCurr)
    <=> ( v139(VarCurr)
        | v155(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_38,axiom,
    ! [VarCurr] :
      ( v137(VarCurr)
    <=> ( v138(VarCurr)
        | v154(VarCurr) ) ) ).

fof(writeUnaryOperator_35,axiom,
    ! [VarCurr] :
      ( ~ v154(VarCurr)
    <=> v155(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_37,axiom,
    ! [VarCurr] :
      ( v155(VarCurr)
    <=> ( v156(VarCurr)
        & v209(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_36,axiom,
    ! [VarCurr] :
      ( v209(VarCurr)
    <=> ( v158(VarCurr)
        | v174(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_35,axiom,
    ! [VarCurr] :
      ( v156(VarCurr)
    <=> ( v157(VarCurr)
        | v173(VarCurr) ) ) ).

fof(writeUnaryOperator_34,axiom,
    ! [VarCurr] :
      ( ~ v173(VarCurr)
    <=> v174(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_34,axiom,
    ! [VarCurr] :
      ( v174(VarCurr)
    <=> ( v175(VarCurr)
        & v208(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_33,axiom,
    ! [VarCurr] :
      ( v208(VarCurr)
    <=> ( v177(VarCurr)
        | v193(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_32,axiom,
    ! [VarCurr] :
      ( v175(VarCurr)
    <=> ( v176(VarCurr)
        | v192(VarCurr) ) ) ).

fof(writeUnaryOperator_33,axiom,
    ! [VarCurr] :
      ( ~ v192(VarCurr)
    <=> v193(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_31,axiom,
    ! [VarCurr] :
      ( v193(VarCurr)
    <=> ( v194(VarCurr)
        & v207(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_11,axiom,
    ! [VarCurr] :
      ( v207(VarCurr)
    <=> ( v110(VarCurr,bitIndex103)
        | v197(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_30,axiom,
    ! [VarCurr] :
      ( v194(VarCurr)
    <=> ( v195(VarCurr)
        | v196(VarCurr) ) ) ).

fof(writeUnaryOperator_32,axiom,
    ! [VarCurr] :
      ( ~ v196(VarCurr)
    <=> v197(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_29,axiom,
    ! [VarCurr] :
      ( v197(VarCurr)
    <=> ( v198(VarCurr)
        & v206(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_10,axiom,
    ! [VarCurr] :
      ( v206(VarCurr)
    <=> ( v110(VarCurr,bitIndex102)
        | v201(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_28,axiom,
    ! [VarCurr] :
      ( v198(VarCurr)
    <=> ( v199(VarCurr)
        | v200(VarCurr) ) ) ).

fof(writeUnaryOperator_31,axiom,
    ! [VarCurr] :
      ( ~ v200(VarCurr)
    <=> v201(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_27,axiom,
    ! [VarCurr] :
      ( v201(VarCurr)
    <=> ( v202(VarCurr)
        & v205(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_9,axiom,
    ! [VarCurr] :
      ( v205(VarCurr)
    <=> ( v110(VarCurr,bitIndex100)
        | v110(VarCurr,bitIndex101) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26,axiom,
    ! [VarCurr] :
      ( v202(VarCurr)
    <=> ( v203(VarCurr)
        | v204(VarCurr) ) ) ).

fof(writeUnaryOperator_30,axiom,
    ! [VarCurr] :
      ( ~ v204(VarCurr)
    <=> v110(VarCurr,bitIndex101) ) ).

fof(writeUnaryOperator_29,axiom,
    ! [VarCurr] :
      ( ~ v203(VarCurr)
    <=> v110(VarCurr,bitIndex100) ) ).

fof(writeUnaryOperator_28,axiom,
    ! [VarCurr] :
      ( ~ v199(VarCurr)
    <=> v110(VarCurr,bitIndex102) ) ).

fof(writeUnaryOperator_27,axiom,
    ! [VarCurr] :
      ( ~ v195(VarCurr)
    <=> v110(VarCurr,bitIndex103) ) ).

fof(writeUnaryOperator_26,axiom,
    ! [VarCurr] :
      ( ~ v176(VarCurr)
    <=> v177(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_25,axiom,
    ! [VarCurr] :
      ( v177(VarCurr)
    <=> ( v178(VarCurr)
        & v191(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_8,axiom,
    ! [VarCurr] :
      ( v191(VarCurr)
    <=> ( v110(VarCurr,bitIndex99)
        | v181(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_24,axiom,
    ! [VarCurr] :
      ( v178(VarCurr)
    <=> ( v179(VarCurr)
        | v180(VarCurr) ) ) ).

fof(writeUnaryOperator_25,axiom,
    ! [VarCurr] :
      ( ~ v180(VarCurr)
    <=> v181(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_23,axiom,
    ! [VarCurr] :
      ( v181(VarCurr)
    <=> ( v182(VarCurr)
        & v190(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_7,axiom,
    ! [VarCurr] :
      ( v190(VarCurr)
    <=> ( v110(VarCurr,bitIndex98)
        | v185(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_22,axiom,
    ! [VarCurr] :
      ( v182(VarCurr)
    <=> ( v183(VarCurr)
        | v184(VarCurr) ) ) ).

fof(writeUnaryOperator_24,axiom,
    ! [VarCurr] :
      ( ~ v184(VarCurr)
    <=> v185(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_21,axiom,
    ! [VarCurr] :
      ( v185(VarCurr)
    <=> ( v186(VarCurr)
        & v189(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_6,axiom,
    ! [VarCurr] :
      ( v189(VarCurr)
    <=> ( v110(VarCurr,bitIndex96)
        | v110(VarCurr,bitIndex97) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_20,axiom,
    ! [VarCurr] :
      ( v186(VarCurr)
    <=> ( v187(VarCurr)
        | v188(VarCurr) ) ) ).

fof(writeUnaryOperator_23,axiom,
    ! [VarCurr] :
      ( ~ v188(VarCurr)
    <=> v110(VarCurr,bitIndex97) ) ).

fof(writeUnaryOperator_22,axiom,
    ! [VarCurr] :
      ( ~ v187(VarCurr)
    <=> v110(VarCurr,bitIndex96) ) ).

fof(writeUnaryOperator_21,axiom,
    ! [VarCurr] :
      ( ~ v183(VarCurr)
    <=> v110(VarCurr,bitIndex98) ) ).

fof(writeUnaryOperator_20,axiom,
    ! [VarCurr] :
      ( ~ v179(VarCurr)
    <=> v110(VarCurr,bitIndex99) ) ).

fof(writeUnaryOperator_19,axiom,
    ! [VarCurr] :
      ( ~ v157(VarCurr)
    <=> v158(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_19,axiom,
    ! [VarCurr] :
      ( v158(VarCurr)
    <=> ( v159(VarCurr)
        & v172(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_5,axiom,
    ! [VarCurr] :
      ( v172(VarCurr)
    <=> ( v110(VarCurr,bitIndex107)
        | v162(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_18,axiom,
    ! [VarCurr] :
      ( v159(VarCurr)
    <=> ( v160(VarCurr)
        | v161(VarCurr) ) ) ).

fof(writeUnaryOperator_18,axiom,
    ! [VarCurr] :
      ( ~ v161(VarCurr)
    <=> v162(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_17,axiom,
    ! [VarCurr] :
      ( v162(VarCurr)
    <=> ( v163(VarCurr)
        & v171(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_4,axiom,
    ! [VarCurr] :
      ( v171(VarCurr)
    <=> ( v110(VarCurr,bitIndex106)
        | v166(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_16,axiom,
    ! [VarCurr] :
      ( v163(VarCurr)
    <=> ( v164(VarCurr)
        | v165(VarCurr) ) ) ).

fof(writeUnaryOperator_17,axiom,
    ! [VarCurr] :
      ( ~ v165(VarCurr)
    <=> v166(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_15,axiom,
    ! [VarCurr] :
      ( v166(VarCurr)
    <=> ( v167(VarCurr)
        & v170(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3,axiom,
    ! [VarCurr] :
      ( v170(VarCurr)
    <=> ( v110(VarCurr,bitIndex104)
        | v110(VarCurr,bitIndex105) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_14,axiom,
    ! [VarCurr] :
      ( v167(VarCurr)
    <=> ( v168(VarCurr)
        | v169(VarCurr) ) ) ).

fof(writeUnaryOperator_16,axiom,
    ! [VarCurr] :
      ( ~ v169(VarCurr)
    <=> v110(VarCurr,bitIndex105) ) ).

fof(writeUnaryOperator_15,axiom,
    ! [VarCurr] :
      ( ~ v168(VarCurr)
    <=> v110(VarCurr,bitIndex104) ) ).

fof(writeUnaryOperator_14,axiom,
    ! [VarCurr] :
      ( ~ v164(VarCurr)
    <=> v110(VarCurr,bitIndex106) ) ).

fof(writeUnaryOperator_13,axiom,
    ! [VarCurr] :
      ( ~ v160(VarCurr)
    <=> v110(VarCurr,bitIndex107) ) ).

fof(writeUnaryOperator_12,axiom,
    ! [VarCurr] :
      ( ~ v138(VarCurr)
    <=> v139(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_13,axiom,
    ! [VarCurr] :
      ( v139(VarCurr)
    <=> ( v140(VarCurr)
        & v153(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2,axiom,
    ! [VarCurr] :
      ( v153(VarCurr)
    <=> ( v110(VarCurr,bitIndex111)
        | v143(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_12,axiom,
    ! [VarCurr] :
      ( v140(VarCurr)
    <=> ( v141(VarCurr)
        | v142(VarCurr) ) ) ).

fof(writeUnaryOperator_11,axiom,
    ! [VarCurr] :
      ( ~ v142(VarCurr)
    <=> v143(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11,axiom,
    ! [VarCurr] :
      ( v143(VarCurr)
    <=> ( v144(VarCurr)
        & v152(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1,axiom,
    ! [VarCurr] :
      ( v152(VarCurr)
    <=> ( v110(VarCurr,bitIndex110)
        | v147(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10,axiom,
    ! [VarCurr] :
      ( v144(VarCurr)
    <=> ( v145(VarCurr)
        | v146(VarCurr) ) ) ).

fof(writeUnaryOperator_10,axiom,
    ! [VarCurr] :
      ( ~ v146(VarCurr)
    <=> v147(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_9,axiom,
    ! [VarCurr] :
      ( v147(VarCurr)
    <=> ( v148(VarCurr)
        & v151(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges,axiom,
    ! [VarCurr] :
      ( v151(VarCurr)
    <=> ( v110(VarCurr,bitIndex108)
        | v110(VarCurr,bitIndex109) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_8,axiom,
    ! [VarCurr] :
      ( v148(VarCurr)
    <=> ( v149(VarCurr)
        | v150(VarCurr) ) ) ).

fof(writeUnaryOperator_9,axiom,
    ! [VarCurr] :
      ( ~ v150(VarCurr)
    <=> v110(VarCurr,bitIndex109) ) ).

fof(writeUnaryOperator_8,axiom,
    ! [VarCurr] :
      ( ~ v149(VarCurr)
    <=> v110(VarCurr,bitIndex108) ) ).

fof(writeUnaryOperator_7,axiom,
    ! [VarCurr] :
      ( ~ v145(VarCurr)
    <=> v110(VarCurr,bitIndex110) ) ).

fof(writeUnaryOperator_6,axiom,
    ! [VarCurr] :
      ( ~ v141(VarCurr)
    <=> v110(VarCurr,bitIndex111) ) ).

fof(addAssignment_23,axiom,
    ! [VarNext,B] :
      ( range_127_96(B)
     => ( v110(VarNext,B)
      <=> v119(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_3,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v120(VarNext)
       => ! [B] :
            ( range_127_0(B)
           => ( v119(VarNext,B)
            <=> v110(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_3,axiom,
    ! [VarNext] :
      ( v120(VarNext)
     => ! [B] :
          ( range_127_0(B)
         => ( v119(VarNext,B)
          <=> v128(VarNext,B) ) ) ) ).

fof(addAssignment_22,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_127_0(B)
         => ( v128(VarNext,B)
          <=> v126(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_2,axiom,
    ! [VarCurr] :
      ( ~ v74(VarCurr)
     => ! [B] :
          ( range_127_0(B)
         => ( v126(VarCurr,B)
          <=> v113(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2,axiom,
    ! [VarCurr] :
      ( v74(VarCurr)
     => ! [B] :
          ( range_127_0(B)
         => ( v126(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_7,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v120(VarNext)
      <=> v121(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_6,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v121(VarNext)
      <=> ( v123(VarNext)
          & v58(VarNext) ) ) ) ).

fof(writeUnaryOperator_5,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v123(VarNext)
      <=> v67(VarNext) ) ) ).

fof(addAssignmentInitValueVector_5,axiom,
    ! [B] :
      ( range_127_0(B)
     => ( v110(constB0,B)
      <=> $false ) ) ).

fof(addAssignment_21,axiom,
    ! [VarCurr,B] :
      ( range_127_96(B)
     => ( v113(VarCurr,B)
      <=> v115(VarCurr,B) ) ) ).

fof(addAssignment_20,axiom,
    ! [VarCurr,B] :
      ( range_127_96(B)
     => ( v115(VarCurr,B)
      <=> v117(VarCurr,B) ) ) ).

fof(range_axiom_1,axiom,
    ! [B] :
      ( range_127_96(B)
    <=> ( $false
        | bitIndex96 = B
        | bitIndex97 = B
        | bitIndex98 = B
        | bitIndex99 = B
        | bitIndex100 = B
        | bitIndex101 = B
        | bitIndex102 = B
        | bitIndex103 = B
        | bitIndex104 = B
        | bitIndex105 = B
        | bitIndex106 = B
        | bitIndex107 = B
        | bitIndex108 = B
        | bitIndex109 = B
        | bitIndex110 = B
        | bitIndex111 = B
        | bitIndex112 = B
        | bitIndex113 = B
        | bitIndex114 = B
        | bitIndex115 = B
        | bitIndex116 = B
        | bitIndex117 = B
        | bitIndex118 = B
        | bitIndex119 = B
        | bitIndex120 = B
        | bitIndex121 = B
        | bitIndex122 = B
        | bitIndex123 = B
        | bitIndex124 = B
        | bitIndex125 = B
        | bitIndex126 = B
        | bitIndex127 = B ) ) ).

fof(addAssignmentInitValueVector_4,axiom,
    ! [B] :
      ( range_127_0(B)
     => ( v117(constB0,B)
      <=> $false ) ) ).

fof(range_axiom,axiom,
    ! [B] :
      ( range_127_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B
        | bitIndex30 = B
        | bitIndex31 = B
        | bitIndex32 = B
        | bitIndex33 = B
        | bitIndex34 = B
        | bitIndex35 = B
        | bitIndex36 = B
        | bitIndex37 = B
        | bitIndex38 = B
        | bitIndex39 = B
        | bitIndex40 = B
        | bitIndex41 = B
        | bitIndex42 = B
        | bitIndex43 = B
        | bitIndex44 = B
        | bitIndex45 = B
        | bitIndex46 = B
        | bitIndex47 = B
        | bitIndex48 = B
        | bitIndex49 = B
        | bitIndex50 = B
        | bitIndex51 = B
        | bitIndex52 = B
        | bitIndex53 = B
        | bitIndex54 = B
        | bitIndex55 = B
        | bitIndex56 = B
        | bitIndex57 = B
        | bitIndex58 = B
        | bitIndex59 = B
        | bitIndex60 = B
        | bitIndex61 = B
        | bitIndex62 = B
        | bitIndex63 = B
        | bitIndex64 = B
        | bitIndex65 = B
        | bitIndex66 = B
        | bitIndex67 = B
        | bitIndex68 = B
        | bitIndex69 = B
        | bitIndex70 = B
        | bitIndex71 = B
        | bitIndex72 = B
        | bitIndex73 = B
        | bitIndex74 = B
        | bitIndex75 = B
        | bitIndex76 = B
        | bitIndex77 = B
        | bitIndex78 = B
        | bitIndex79 = B
        | bitIndex80 = B
        | bitIndex81 = B
        | bitIndex82 = B
        | bitIndex83 = B
        | bitIndex84 = B
        | bitIndex85 = B
        | bitIndex86 = B
        | bitIndex87 = B
        | bitIndex88 = B
        | bitIndex89 = B
        | bitIndex90 = B
        | bitIndex91 = B
        | bitIndex92 = B
        | bitIndex93 = B
        | bitIndex94 = B
        | bitIndex95 = B
        | bitIndex96 = B
        | bitIndex97 = B
        | bitIndex98 = B
        | bitIndex99 = B
        | bitIndex100 = B
        | bitIndex101 = B
        | bitIndex102 = B
        | bitIndex103 = B
        | bitIndex104 = B
        | bitIndex105 = B
        | bitIndex106 = B
        | bitIndex107 = B
        | bitIndex108 = B
        | bitIndex109 = B
        | bitIndex110 = B
        | bitIndex111 = B
        | bitIndex112 = B
        | bitIndex113 = B
        | bitIndex114 = B
        | bitIndex115 = B
        | bitIndex116 = B
        | bitIndex117 = B
        | bitIndex118 = B
        | bitIndex119 = B
        | bitIndex120 = B
        | bitIndex121 = B
        | bitIndex122 = B
        | bitIndex123 = B
        | bitIndex124 = B
        | bitIndex125 = B
        | bitIndex126 = B
        | bitIndex127 = B ) ) ).

fof(bitBlastConstant_127,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex127) ).

fof(bitBlastConstant_126,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex126) ).

fof(bitBlastConstant_125,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex125) ).

fof(bitBlastConstant_124,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex124) ).

fof(bitBlastConstant_123,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex123) ).

fof(bitBlastConstant_122,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex122) ).

fof(bitBlastConstant_121,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex121) ).

fof(bitBlastConstant_120,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex120) ).

fof(bitBlastConstant_119,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex119) ).

fof(bitBlastConstant_118,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex118) ).

fof(bitBlastConstant_117,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex117) ).

fof(bitBlastConstant_116,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex116) ).

fof(bitBlastConstant_115,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex115) ).

fof(bitBlastConstant_114,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex114) ).

fof(bitBlastConstant_113,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex113) ).

fof(bitBlastConstant_112,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex112) ).

fof(bitBlastConstant_111,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex111) ).

fof(bitBlastConstant_110,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex110) ).

fof(bitBlastConstant_109,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex109) ).

fof(bitBlastConstant_108,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex108) ).

fof(bitBlastConstant_107,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex107) ).

fof(bitBlastConstant_106,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex106) ).

fof(bitBlastConstant_105,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex105) ).

fof(bitBlastConstant_104,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex104) ).

fof(bitBlastConstant_103,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex103) ).

fof(bitBlastConstant_102,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex102) ).

fof(bitBlastConstant_101,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex101) ).

fof(bitBlastConstant_100,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex100) ).

fof(bitBlastConstant_99,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex99) ).

fof(bitBlastConstant_98,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex98) ).

fof(bitBlastConstant_97,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex97) ).

fof(bitBlastConstant_96,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex96) ).

fof(bitBlastConstant_95,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex95) ).

fof(bitBlastConstant_94,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex94) ).

fof(bitBlastConstant_93,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex93) ).

fof(bitBlastConstant_92,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex92) ).

fof(bitBlastConstant_91,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex91) ).

fof(bitBlastConstant_90,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex90) ).

fof(bitBlastConstant_89,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex89) ).

fof(bitBlastConstant_88,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex88) ).

fof(bitBlastConstant_87,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex87) ).

fof(bitBlastConstant_86,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex86) ).

fof(bitBlastConstant_85,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex85) ).

fof(bitBlastConstant_84,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex84) ).

fof(bitBlastConstant_83,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex83) ).

fof(bitBlastConstant_82,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex82) ).

fof(bitBlastConstant_81,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex81) ).

fof(bitBlastConstant_80,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex80) ).

fof(bitBlastConstant_79,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex79) ).

fof(bitBlastConstant_78,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex78) ).

fof(bitBlastConstant_77,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex77) ).

fof(bitBlastConstant_76,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex76) ).

fof(bitBlastConstant_75,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex75) ).

fof(bitBlastConstant_74,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex74) ).

fof(bitBlastConstant_73,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex73) ).

fof(bitBlastConstant_72,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex72) ).

fof(bitBlastConstant_71,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex71) ).

fof(bitBlastConstant_70,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex70) ).

fof(bitBlastConstant_69,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex69) ).

fof(bitBlastConstant_68,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex68) ).

fof(bitBlastConstant_67,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex67) ).

fof(bitBlastConstant_66,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex66) ).

fof(bitBlastConstant_65,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex65) ).

fof(bitBlastConstant_64,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex64) ).

fof(bitBlastConstant_63,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex63) ).

fof(bitBlastConstant_62,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex62) ).

fof(bitBlastConstant_61,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex61) ).

fof(bitBlastConstant_60,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex60) ).

fof(bitBlastConstant_59,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex59) ).

fof(bitBlastConstant_58,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex58) ).

fof(bitBlastConstant_57,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex57) ).

fof(bitBlastConstant_56,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex56) ).

fof(bitBlastConstant_55,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex55) ).

fof(bitBlastConstant_54,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex54) ).

fof(bitBlastConstant_53,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex53) ).

fof(bitBlastConstant_52,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex52) ).

fof(bitBlastConstant_51,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex51) ).

fof(bitBlastConstant_50,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex50) ).

fof(bitBlastConstant_49,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex49) ).

fof(bitBlastConstant_48,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex48) ).

fof(bitBlastConstant_47,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex47) ).

fof(bitBlastConstant_46,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex46) ).

fof(bitBlastConstant_45,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex45) ).

fof(bitBlastConstant_44,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex44) ).

fof(bitBlastConstant_43,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex43) ).

fof(bitBlastConstant_42,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex42) ).

fof(bitBlastConstant_41,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex41) ).

fof(bitBlastConstant_40,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex40) ).

fof(bitBlastConstant_39,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex39) ).

fof(bitBlastConstant_38,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex38) ).

fof(bitBlastConstant_37,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex37) ).

fof(bitBlastConstant_36,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex36) ).

fof(bitBlastConstant_35,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex35) ).

fof(bitBlastConstant_34,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex34) ).

fof(bitBlastConstant_33,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex33) ).

fof(bitBlastConstant_32,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex32) ).

fof(bitBlastConstant_31,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex31) ).

fof(bitBlastConstant_30,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex30) ).

fof(bitBlastConstant_29,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex29) ).

fof(bitBlastConstant_28,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex28) ).

fof(bitBlastConstant_27,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex27) ).

fof(bitBlastConstant_26,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex26) ).

fof(bitBlastConstant_25,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex25) ).

fof(bitBlastConstant_24,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex24) ).

fof(bitBlastConstant_23,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex23) ).

fof(bitBlastConstant_22,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex22) ).

fof(bitBlastConstant_21,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex21) ).

fof(bitBlastConstant_20,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex20) ).

fof(bitBlastConstant_19,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex19) ).

fof(bitBlastConstant_18,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex18) ).

fof(bitBlastConstant_17,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex17) ).

fof(bitBlastConstant_16,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex16) ).

fof(bitBlastConstant_15,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex15) ).

fof(bitBlastConstant_14,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex14) ).

fof(bitBlastConstant_13,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex13) ).

fof(bitBlastConstant_12,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex12) ).

fof(bitBlastConstant_11,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex11) ).

fof(bitBlastConstant_10,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex10) ).

fof(bitBlastConstant_9,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex9) ).

fof(bitBlastConstant_8,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex8) ).

fof(bitBlastConstant_7,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex7) ).

fof(bitBlastConstant_6,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex6) ).

fof(bitBlastConstant_5,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex5) ).

fof(bitBlastConstant_4,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex4) ).

fof(bitBlastConstant_3,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex3) ).

fof(bitBlastConstant_2,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex2) ).

fof(bitBlastConstant_1,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex1) ).

fof(bitBlastConstant,axiom,
    ~ b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex0) ).

fof(addAssignment_19,axiom,
    ! [VarCurr] :
      ( v36(VarCurr)
    <=> v38(VarCurr) ) ).

fof(addAssignment_18,axiom,
    ! [VarCurr] :
      ( v38(VarCurr)
    <=> v40(VarCurr) ) ).

fof(addAssignment_17,axiom,
    ! [VarCurr] :
      ( v40(VarCurr)
    <=> v42(VarCurr) ) ).

fof(addAssignment_16,axiom,
    ! [VarCurr] :
      ( v42(VarCurr)
    <=> v44(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_2,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v79(VarNext)
       => ( v44(VarNext)
        <=> v44(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2,axiom,
    ! [VarNext] :
      ( v79(VarNext)
     => ( v44(VarNext)
      <=> v87(VarNext) ) ) ).

fof(addAssignment_15,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v87(VarNext)
      <=> v85(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1,axiom,
    ! [VarCurr] :
      ( ~ v88(VarCurr)
     => ( v85(VarCurr)
      <=> v50(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1,axiom,
    ! [VarCurr] :
      ( v88(VarCurr)
     => ( v85(VarCurr)
      <=> $false ) ) ).

fof(writeUnaryOperator_4,axiom,
    ! [VarCurr] :
      ( ~ v88(VarCurr)
    <=> v46(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v79(VarNext)
      <=> v80(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v80(VarNext)
      <=> ( v67(VarNext)
          & v82(VarNext) ) ) ) ).

fof(writeUnaryOperator_3,axiom,
    ! [VarCurr] :
      ( ~ v82(VarCurr)
    <=> v58(VarCurr) ) ).

fof(addAssignmentInitValueVector_3,axiom,
    ( v44(constB0)
  <=> $false ) ).

fof(addCaseBooleanConditionEqualRanges1_1,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v63(VarNext)
       => ( v50(VarNext)
        <=> v50(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1,axiom,
    ! [VarNext] :
      ( v63(VarNext)
     => ( v50(VarNext)
      <=> v73(VarNext) ) ) ).

fof(addAssignment_14,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v73(VarNext)
      <=> v71(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch,axiom,
    ! [VarCurr] :
      ( ~ v74(VarCurr)
     => ( v71(VarCurr)
      <=> v52(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch,axiom,
    ! [VarCurr] :
      ( v74(VarCurr)
     => ( v71(VarCurr)
      <=> $false ) ) ).

fof(writeUnaryOperator_2,axiom,
    ! [VarCurr] :
      ( ~ v74(VarCurr)
    <=> v46(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v63(VarNext)
      <=> v64(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v64(VarNext)
      <=> ( v65(VarNext)
          & v58(VarNext) ) ) ) ).

fof(writeUnaryOperator_1,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v65(VarNext)
      <=> v67(VarNext) ) ) ).

fof(addAssignment_13,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v67(VarNext)
      <=> v58(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_2,axiom,
    ( v50(constB0)
  <=> $false ) ).

fof(addAssignment_12,axiom,
    ! [VarCurr] :
      ( v58(VarCurr)
    <=> v60(VarCurr) ) ).

fof(addAssignment_11,axiom,
    ! [VarCurr] :
      ( v60(VarCurr)
    <=> v1(VarCurr) ) ).

fof(addAssignment_10,axiom,
    ! [VarCurr] :
      ( v52(VarCurr)
    <=> v54(VarCurr) ) ).

fof(addAssignment_9,axiom,
    ! [VarCurr] :
      ( v54(VarCurr)
    <=> v56(VarCurr) ) ).

fof(addAssignmentInitValueVector_1,axiom,
    ( v56(constB0)
  <=> $false ) ).

fof(addAssignment_8,axiom,
    ! [VarCurr] :
      ( v46(VarCurr)
    <=> v48(VarCurr) ) ).

fof(addAssignment_7,axiom,
    ! [VarCurr] :
      ( v48(VarCurr)
    <=> v17(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v23(VarNext)
       => ( v11(VarNext)
        <=> v11(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0,axiom,
    ! [VarNext] :
      ( v23(VarNext)
     => ( v11(VarNext)
      <=> v32(VarNext) ) ) ).

fof(addAssignment_6,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v32(VarNext)
      <=> v13(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v23(VarNext)
      <=> v24(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v24(VarNext)
      <=> ( v26(VarNext)
          & v28(VarNext) ) ) ) ).

fof(writeUnaryOperator,axiom,
    ! [VarCurr] :
      ( ~ v28(VarCurr)
    <=> v7(VarCurr) ) ).

fof(addAssignment_5,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26(VarNext)
      <=> v7(VarCurr) ) ) ).

fof(addAssignmentInitValueVector,axiom,
    ( v11(constB0)
  <=> $false ) ).

fof(addAssignment_4,axiom,
    ! [VarCurr] :
      ( v13(VarCurr)
    <=> v15(VarCurr) ) ).

fof(addAssignment_3,axiom,
    ! [VarCurr] :
      ( v15(VarCurr)
    <=> v17(VarCurr) ) ).

fof(addAssignment_2,axiom,
    ! [VarCurr] :
      ( v17(VarCurr)
    <=> v19(VarCurr) ) ).

fof(addAssignment_1,axiom,
    ! [VarCurr] :
      ( v7(VarCurr)
    <=> v9(VarCurr) ) ).

fof(addAssignment,axiom,
    ! [VarCurr] :
      ( v9(VarCurr)
    <=> v1(VarCurr) ) ).

%------------------------------------------------------------------------------
