%------------------------------------------------------------------------------
% File     : HWV108+1 : TPTP v9.2.0. Released v6.1.0.
% Domain   : Hardware Verification
% Problem  : dmu_dmc property 18 cone of influence 5_b20
% Version  : Especial.
% English  : Verification of a property of the SPARCT2 RTL hardware design.

% Refs     : [Kha14] Khasidashvili (2014), Email to Geoff Sutcliffe
% Source   : [Kha14]
% Names    : dmu_dmc_prop18_cone5_b20 [Kha14]

% Status   : Theorem
% Rating   : 0.94 v9.0.0, 0.92 v8.2.0, 0.94 v8.1.0, 0.97 v7.5.0, 1.00 v7.4.0, 0.97 v7.1.0, 0.96 v7.0.0, 0.97 v6.4.0, 0.92 v6.3.0, 0.96 v6.2.0, 1.00 v6.1.0
% Syntax   : Number of formulae    : 34783 (3597 unt;   0 def)
%            Number of atoms       : 172970 (5223 equ)
%            Maximal formula atoms :  262 (   4 avg)
%            Number of connectives : 151110 (12923   ~;7451   |;46895   &)
%                                         (71509 <=>;12321  =>;   0  <=;  11 <~>)
%            Maximal formula depth :  134 (   5 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of predicates  : 17815 (17812 usr;   2 prp; 0-3 aty)
%            Number of functors    : 2175 (2175 usr;2175 con; 0-0 aty)
%            Number of variables   : 36397 (36397   !;   0   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : Copyright 2013 Moshe Emmer and Zurab Khasidashvili
%            Licensed under the Apache License, Version 2.0 (the "License");
%            you may not use this file except in compliance with the License.
%            You may obtain a copy of the License at
%                http://www.apache.org/licenses/LICENSE-2.0
%            Unless required by applicable law or agreed to in writing,
%            software distributed under the License is distributed on an "AS
%            IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
%            express or implied. See the License for the specific language
%            governing permissions and limitations under the License.
%------------------------------------------------------------------------------
fof(pathAxiom_8,axiom,
    nextState(constB8,constB9) ).

fof(pathAxiom_7,axiom,
    nextState(constB7,constB8) ).

fof(pathAxiom_6,axiom,
    nextState(constB6,constB7) ).

fof(pathAxiom_5,axiom,
    nextState(constB5,constB6) ).

fof(pathAxiom_4,axiom,
    nextState(constB4,constB5) ).

fof(pathAxiom_3,axiom,
    nextState(constB3,constB4) ).

fof(pathAxiom_2,axiom,
    nextState(constB2,constB3) ).

fof(pathAxiom_1,axiom,
    nextState(constB1,constB2) ).

fof(pathAxiom,axiom,
    nextState(constB0,constB1) ).

fof(reachableStateAxiom_22,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( reachableState(VarCurr)
        & reachableState(VarNext) ) ) ).

fof(reachableStateAxiom_21,axiom,
    ! [VarState] :
      ( reachableState(VarState)
     => ( constB0 = VarState
        | constB1 = VarState
        | constB2 = VarState
        | constB3 = VarState
        | constB4 = VarState
        | constB5 = VarState
        | constB6 = VarState
        | constB7 = VarState
        | constB8 = VarState
        | constB9 = VarState
        | constB10 = VarState
        | constB11 = VarState
        | constB12 = VarState
        | constB13 = VarState
        | constB14 = VarState
        | constB15 = VarState
        | constB16 = VarState
        | constB17 = VarState
        | constB18 = VarState
        | constB19 = VarState
        | constB20 = VarState ) ) ).

fof(reachableStateAxiom_20,axiom,
    reachableState(constB20) ).

fof(reachableStateAxiom_19,axiom,
    reachableState(constB19) ).

fof(reachableStateAxiom_18,axiom,
    reachableState(constB18) ).

fof(reachableStateAxiom_17,axiom,
    reachableState(constB17) ).

fof(reachableStateAxiom_16,axiom,
    reachableState(constB16) ).

fof(reachableStateAxiom_15,axiom,
    reachableState(constB15) ).

fof(reachableStateAxiom_14,axiom,
    reachableState(constB14) ).

fof(reachableStateAxiom_13,axiom,
    reachableState(constB13) ).

fof(reachableStateAxiom_12,axiom,
    reachableState(constB12) ).

fof(reachableStateAxiom_11,axiom,
    reachableState(constB11) ).

fof(reachableStateAxiom_10,axiom,
    reachableState(constB10) ).

fof(reachableStateAxiom_9,axiom,
    reachableState(constB9) ).

fof(reachableStateAxiom_8,axiom,
    reachableState(constB8) ).

fof(reachableStateAxiom_7,axiom,
    reachableState(constB7) ).

fof(reachableStateAxiom_6,axiom,
    reachableState(constB6) ).

fof(reachableStateAxiom_5,axiom,
    reachableState(constB5) ).

fof(reachableStateAxiom_4,axiom,
    reachableState(constB4) ).

fof(reachableStateAxiom_3,axiom,
    reachableState(constB3) ).

fof(reachableStateAxiom_2,axiom,
    reachableState(constB2) ).

fof(reachableStateAxiom_1,axiom,
    reachableState(constB1) ).

fof(reachableStateAxiom,axiom,
    reachableState(constB0) ).

fof(clock_toggling,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1(VarCurr)
      <=> ~ v1(VarNext) ) ) ).

fof(clock_pattern,axiom,
    ~ v1(constB0) ).

fof(transient_address_definition_41,axiom,
    ! [B] :
      ( addressVal(v26217_range_8_to_0_address_term_bound_20,B)
    <=> v26217(constB20,B) ) ).

fof(is_address_41,axiom,
    address(v26217_range_8_to_0_address_term_bound_20) ).

fof(address_association_41,axiom,
    v26217_range_8_to_0_address_association(constB20,v26217_range_8_to_0_address_term_bound_20) ).

fof(transient_address_definition_40,axiom,
    ! [B] :
      ( addressVal(v26217_range_8_to_0_address_term_bound_19,B)
    <=> v26217(constB19,B) ) ).

fof(is_address_40,axiom,
    address(v26217_range_8_to_0_address_term_bound_19) ).

fof(address_association_40,axiom,
    v26217_range_8_to_0_address_association(constB19,v26217_range_8_to_0_address_term_bound_19) ).

fof(transient_address_definition_39,axiom,
    ! [B] :
      ( addressVal(v26217_range_8_to_0_address_term_bound_18,B)
    <=> v26217(constB18,B) ) ).

fof(is_address_39,axiom,
    address(v26217_range_8_to_0_address_term_bound_18) ).

fof(address_association_39,axiom,
    v26217_range_8_to_0_address_association(constB18,v26217_range_8_to_0_address_term_bound_18) ).

fof(transient_address_definition_38,axiom,
    ! [B] :
      ( addressVal(v26217_range_8_to_0_address_term_bound_17,B)
    <=> v26217(constB17,B) ) ).

fof(is_address_38,axiom,
    address(v26217_range_8_to_0_address_term_bound_17) ).

fof(address_association_38,axiom,
    v26217_range_8_to_0_address_association(constB17,v26217_range_8_to_0_address_term_bound_17) ).

fof(transient_address_definition_37,axiom,
    ! [B] :
      ( addressVal(v26217_range_8_to_0_address_term_bound_16,B)
    <=> v26217(constB16,B) ) ).

fof(is_address_37,axiom,
    address(v26217_range_8_to_0_address_term_bound_16) ).

fof(address_association_37,axiom,
    v26217_range_8_to_0_address_association(constB16,v26217_range_8_to_0_address_term_bound_16) ).

fof(transient_address_definition_36,axiom,
    ! [B] :
      ( addressVal(v26217_range_8_to_0_address_term_bound_15,B)
    <=> v26217(constB15,B) ) ).

fof(is_address_36,axiom,
    address(v26217_range_8_to_0_address_term_bound_15) ).

fof(address_association_36,axiom,
    v26217_range_8_to_0_address_association(constB15,v26217_range_8_to_0_address_term_bound_15) ).

fof(transient_address_definition_35,axiom,
    ! [B] :
      ( addressVal(v26217_range_8_to_0_address_term_bound_14,B)
    <=> v26217(constB14,B) ) ).

fof(is_address_35,axiom,
    address(v26217_range_8_to_0_address_term_bound_14) ).

fof(address_association_35,axiom,
    v26217_range_8_to_0_address_association(constB14,v26217_range_8_to_0_address_term_bound_14) ).

fof(transient_address_definition_34,axiom,
    ! [B] :
      ( addressVal(v26217_range_8_to_0_address_term_bound_13,B)
    <=> v26217(constB13,B) ) ).

fof(is_address_34,axiom,
    address(v26217_range_8_to_0_address_term_bound_13) ).

fof(address_association_34,axiom,
    v26217_range_8_to_0_address_association(constB13,v26217_range_8_to_0_address_term_bound_13) ).

fof(transient_address_definition_33,axiom,
    ! [B] :
      ( addressVal(v26217_range_8_to_0_address_term_bound_12,B)
    <=> v26217(constB12,B) ) ).

fof(is_address_33,axiom,
    address(v26217_range_8_to_0_address_term_bound_12) ).

fof(address_association_33,axiom,
    v26217_range_8_to_0_address_association(constB12,v26217_range_8_to_0_address_term_bound_12) ).

fof(transient_address_definition_32,axiom,
    ! [B] :
      ( addressVal(v26217_range_8_to_0_address_term_bound_11,B)
    <=> v26217(constB11,B) ) ).

fof(is_address_32,axiom,
    address(v26217_range_8_to_0_address_term_bound_11) ).

fof(address_association_32,axiom,
    v26217_range_8_to_0_address_association(constB11,v26217_range_8_to_0_address_term_bound_11) ).

fof(transient_address_definition_31,axiom,
    ! [B] :
      ( addressVal(v26217_range_8_to_0_address_term_bound_10,B)
    <=> v26217(constB10,B) ) ).

fof(is_address_31,axiom,
    address(v26217_range_8_to_0_address_term_bound_10) ).

fof(address_association_31,axiom,
    v26217_range_8_to_0_address_association(constB10,v26217_range_8_to_0_address_term_bound_10) ).

fof(transient_address_definition_30,axiom,
    ! [B] :
      ( addressVal(v26217_range_8_to_0_address_term_bound_9,B)
    <=> v26217(constB9,B) ) ).

fof(is_address_30,axiom,
    address(v26217_range_8_to_0_address_term_bound_9) ).

fof(address_association_30,axiom,
    v26217_range_8_to_0_address_association(constB9,v26217_range_8_to_0_address_term_bound_9) ).

fof(transient_address_definition_29,axiom,
    ! [B] :
      ( addressVal(v26217_range_8_to_0_address_term_bound_8,B)
    <=> v26217(constB8,B) ) ).

fof(is_address_29,axiom,
    address(v26217_range_8_to_0_address_term_bound_8) ).

fof(address_association_29,axiom,
    v26217_range_8_to_0_address_association(constB8,v26217_range_8_to_0_address_term_bound_8) ).

fof(transient_address_definition_28,axiom,
    ! [B] :
      ( addressVal(v26217_range_8_to_0_address_term_bound_7,B)
    <=> v26217(constB7,B) ) ).

fof(is_address_28,axiom,
    address(v26217_range_8_to_0_address_term_bound_7) ).

fof(address_association_28,axiom,
    v26217_range_8_to_0_address_association(constB7,v26217_range_8_to_0_address_term_bound_7) ).

fof(transient_address_definition_27,axiom,
    ! [B] :
      ( addressVal(v26217_range_8_to_0_address_term_bound_6,B)
    <=> v26217(constB6,B) ) ).

fof(is_address_27,axiom,
    address(v26217_range_8_to_0_address_term_bound_6) ).

fof(address_association_27,axiom,
    v26217_range_8_to_0_address_association(constB6,v26217_range_8_to_0_address_term_bound_6) ).

fof(transient_address_definition_26,axiom,
    ! [B] :
      ( addressVal(v26217_range_8_to_0_address_term_bound_5,B)
    <=> v26217(constB5,B) ) ).

fof(is_address_26,axiom,
    address(v26217_range_8_to_0_address_term_bound_5) ).

fof(address_association_26,axiom,
    v26217_range_8_to_0_address_association(constB5,v26217_range_8_to_0_address_term_bound_5) ).

fof(transient_address_definition_25,axiom,
    ! [B] :
      ( addressVal(v26217_range_8_to_0_address_term_bound_4,B)
    <=> v26217(constB4,B) ) ).

fof(is_address_25,axiom,
    address(v26217_range_8_to_0_address_term_bound_4) ).

fof(address_association_25,axiom,
    v26217_range_8_to_0_address_association(constB4,v26217_range_8_to_0_address_term_bound_4) ).

fof(transient_address_definition_24,axiom,
    ! [B] :
      ( addressVal(v26217_range_8_to_0_address_term_bound_3,B)
    <=> v26217(constB3,B) ) ).

fof(is_address_24,axiom,
    address(v26217_range_8_to_0_address_term_bound_3) ).

fof(address_association_24,axiom,
    v26217_range_8_to_0_address_association(constB3,v26217_range_8_to_0_address_term_bound_3) ).

fof(transient_address_definition_23,axiom,
    ! [B] :
      ( addressVal(v26217_range_8_to_0_address_term_bound_2,B)
    <=> v26217(constB2,B) ) ).

fof(is_address_23,axiom,
    address(v26217_range_8_to_0_address_term_bound_2) ).

fof(address_association_23,axiom,
    v26217_range_8_to_0_address_association(constB2,v26217_range_8_to_0_address_term_bound_2) ).

fof(transient_address_definition_22,axiom,
    ! [B] :
      ( addressVal(v26217_range_8_to_0_address_term_bound_1,B)
    <=> v26217(constB1,B) ) ).

fof(is_address_22,axiom,
    address(v26217_range_8_to_0_address_term_bound_1) ).

fof(address_association_22,axiom,
    v26217_range_8_to_0_address_association(constB1,v26217_range_8_to_0_address_term_bound_1) ).

fof(transient_address_definition_21,axiom,
    ! [B] :
      ( addressVal(v26217_range_8_to_0_address_term_bound_0,B)
    <=> v26217(constB0,B) ) ).

fof(is_address_21,axiom,
    address(v26217_range_8_to_0_address_term_bound_0) ).

fof(address_association_21,axiom,
    v26217_range_8_to_0_address_association(constB0,v26217_range_8_to_0_address_term_bound_0) ).

fof(transient_address_definition_20,axiom,
    ! [B] :
      ( addressVal(v25768_range_8_to_0_address_term_bound_20,B)
    <=> v25768(constB20,B) ) ).

fof(is_address_20,axiom,
    address(v25768_range_8_to_0_address_term_bound_20) ).

fof(address_association_20,axiom,
    v25768_range_8_to_0_address_association(constB20,v25768_range_8_to_0_address_term_bound_20) ).

fof(transient_address_definition_19,axiom,
    ! [B] :
      ( addressVal(v25768_range_8_to_0_address_term_bound_19,B)
    <=> v25768(constB19,B) ) ).

fof(is_address_19,axiom,
    address(v25768_range_8_to_0_address_term_bound_19) ).

fof(address_association_19,axiom,
    v25768_range_8_to_0_address_association(constB19,v25768_range_8_to_0_address_term_bound_19) ).

fof(transient_address_definition_18,axiom,
    ! [B] :
      ( addressVal(v25768_range_8_to_0_address_term_bound_18,B)
    <=> v25768(constB18,B) ) ).

fof(is_address_18,axiom,
    address(v25768_range_8_to_0_address_term_bound_18) ).

fof(address_association_18,axiom,
    v25768_range_8_to_0_address_association(constB18,v25768_range_8_to_0_address_term_bound_18) ).

fof(transient_address_definition_17,axiom,
    ! [B] :
      ( addressVal(v25768_range_8_to_0_address_term_bound_17,B)
    <=> v25768(constB17,B) ) ).

fof(is_address_17,axiom,
    address(v25768_range_8_to_0_address_term_bound_17) ).

fof(address_association_17,axiom,
    v25768_range_8_to_0_address_association(constB17,v25768_range_8_to_0_address_term_bound_17) ).

fof(transient_address_definition_16,axiom,
    ! [B] :
      ( addressVal(v25768_range_8_to_0_address_term_bound_16,B)
    <=> v25768(constB16,B) ) ).

fof(is_address_16,axiom,
    address(v25768_range_8_to_0_address_term_bound_16) ).

fof(address_association_16,axiom,
    v25768_range_8_to_0_address_association(constB16,v25768_range_8_to_0_address_term_bound_16) ).

fof(transient_address_definition_15,axiom,
    ! [B] :
      ( addressVal(v25768_range_8_to_0_address_term_bound_15,B)
    <=> v25768(constB15,B) ) ).

fof(is_address_15,axiom,
    address(v25768_range_8_to_0_address_term_bound_15) ).

fof(address_association_15,axiom,
    v25768_range_8_to_0_address_association(constB15,v25768_range_8_to_0_address_term_bound_15) ).

fof(transient_address_definition_14,axiom,
    ! [B] :
      ( addressVal(v25768_range_8_to_0_address_term_bound_14,B)
    <=> v25768(constB14,B) ) ).

fof(is_address_14,axiom,
    address(v25768_range_8_to_0_address_term_bound_14) ).

fof(address_association_14,axiom,
    v25768_range_8_to_0_address_association(constB14,v25768_range_8_to_0_address_term_bound_14) ).

fof(transient_address_definition_13,axiom,
    ! [B] :
      ( addressVal(v25768_range_8_to_0_address_term_bound_13,B)
    <=> v25768(constB13,B) ) ).

fof(is_address_13,axiom,
    address(v25768_range_8_to_0_address_term_bound_13) ).

fof(address_association_13,axiom,
    v25768_range_8_to_0_address_association(constB13,v25768_range_8_to_0_address_term_bound_13) ).

fof(transient_address_definition_12,axiom,
    ! [B] :
      ( addressVal(v25768_range_8_to_0_address_term_bound_12,B)
    <=> v25768(constB12,B) ) ).

fof(is_address_12,axiom,
    address(v25768_range_8_to_0_address_term_bound_12) ).

fof(address_association_12,axiom,
    v25768_range_8_to_0_address_association(constB12,v25768_range_8_to_0_address_term_bound_12) ).

fof(transient_address_definition_11,axiom,
    ! [B] :
      ( addressVal(v25768_range_8_to_0_address_term_bound_11,B)
    <=> v25768(constB11,B) ) ).

fof(is_address_11,axiom,
    address(v25768_range_8_to_0_address_term_bound_11) ).

fof(address_association_11,axiom,
    v25768_range_8_to_0_address_association(constB11,v25768_range_8_to_0_address_term_bound_11) ).

fof(transient_address_definition_10,axiom,
    ! [B] :
      ( addressVal(v25768_range_8_to_0_address_term_bound_10,B)
    <=> v25768(constB10,B) ) ).

fof(is_address_10,axiom,
    address(v25768_range_8_to_0_address_term_bound_10) ).

fof(address_association_10,axiom,
    v25768_range_8_to_0_address_association(constB10,v25768_range_8_to_0_address_term_bound_10) ).

fof(transient_address_definition_9,axiom,
    ! [B] :
      ( addressVal(v25768_range_8_to_0_address_term_bound_9,B)
    <=> v25768(constB9,B) ) ).

fof(is_address_9,axiom,
    address(v25768_range_8_to_0_address_term_bound_9) ).

fof(address_association_9,axiom,
    v25768_range_8_to_0_address_association(constB9,v25768_range_8_to_0_address_term_bound_9) ).

fof(transient_address_definition_8,axiom,
    ! [B] :
      ( addressVal(v25768_range_8_to_0_address_term_bound_8,B)
    <=> v25768(constB8,B) ) ).

fof(is_address_8,axiom,
    address(v25768_range_8_to_0_address_term_bound_8) ).

fof(address_association_8,axiom,
    v25768_range_8_to_0_address_association(constB8,v25768_range_8_to_0_address_term_bound_8) ).

fof(transient_address_definition_7,axiom,
    ! [B] :
      ( addressVal(v25768_range_8_to_0_address_term_bound_7,B)
    <=> v25768(constB7,B) ) ).

fof(is_address_7,axiom,
    address(v25768_range_8_to_0_address_term_bound_7) ).

fof(address_association_7,axiom,
    v25768_range_8_to_0_address_association(constB7,v25768_range_8_to_0_address_term_bound_7) ).

fof(transient_address_definition_6,axiom,
    ! [B] :
      ( addressVal(v25768_range_8_to_0_address_term_bound_6,B)
    <=> v25768(constB6,B) ) ).

fof(is_address_6,axiom,
    address(v25768_range_8_to_0_address_term_bound_6) ).

fof(address_association_6,axiom,
    v25768_range_8_to_0_address_association(constB6,v25768_range_8_to_0_address_term_bound_6) ).

fof(transient_address_definition_5,axiom,
    ! [B] :
      ( addressVal(v25768_range_8_to_0_address_term_bound_5,B)
    <=> v25768(constB5,B) ) ).

fof(is_address_5,axiom,
    address(v25768_range_8_to_0_address_term_bound_5) ).

fof(address_association_5,axiom,
    v25768_range_8_to_0_address_association(constB5,v25768_range_8_to_0_address_term_bound_5) ).

fof(transient_address_definition_4,axiom,
    ! [B] :
      ( addressVal(v25768_range_8_to_0_address_term_bound_4,B)
    <=> v25768(constB4,B) ) ).

fof(is_address_4,axiom,
    address(v25768_range_8_to_0_address_term_bound_4) ).

fof(address_association_4,axiom,
    v25768_range_8_to_0_address_association(constB4,v25768_range_8_to_0_address_term_bound_4) ).

fof(transient_address_definition_3,axiom,
    ! [B] :
      ( addressVal(v25768_range_8_to_0_address_term_bound_3,B)
    <=> v25768(constB3,B) ) ).

fof(is_address_3,axiom,
    address(v25768_range_8_to_0_address_term_bound_3) ).

fof(address_association_3,axiom,
    v25768_range_8_to_0_address_association(constB3,v25768_range_8_to_0_address_term_bound_3) ).

fof(transient_address_definition_2,axiom,
    ! [B] :
      ( addressVal(v25768_range_8_to_0_address_term_bound_2,B)
    <=> v25768(constB2,B) ) ).

fof(is_address_2,axiom,
    address(v25768_range_8_to_0_address_term_bound_2) ).

fof(address_association_2,axiom,
    v25768_range_8_to_0_address_association(constB2,v25768_range_8_to_0_address_term_bound_2) ).

fof(transient_address_definition_1,axiom,
    ! [B] :
      ( addressVal(v25768_range_8_to_0_address_term_bound_1,B)
    <=> v25768(constB1,B) ) ).

fof(is_address_1,axiom,
    address(v25768_range_8_to_0_address_term_bound_1) ).

fof(address_association_1,axiom,
    v25768_range_8_to_0_address_association(constB1,v25768_range_8_to_0_address_term_bound_1) ).

fof(transient_address_definition,axiom,
    ! [B] :
      ( addressVal(v25768_range_8_to_0_address_term_bound_0,B)
    <=> v25768(constB0,B) ) ).

fof(is_address,axiom,
    address(v25768_range_8_to_0_address_term_bound_0) ).

fof(address_association,axiom,
    v25768_range_8_to_0_address_association(constB0,v25768_range_8_to_0_address_term_bound_0) ).

fof(addressDiff,axiom,
    ! [B,A2,A1] :
      ( ( address(A1)
        & address(A2)
        & addressDiff(A1,A2,B) )
     => ( A1 = A2
        | ( addressVal(A1,B)
        <=> ~ addressVal(A2,B) ) ) ) ).

fof(addressDomain,axiom,
    ! [A1,A2] :
      ( addressDiff(A1,A2,bitIndex0)
      | addressDiff(A1,A2,bitIndex1)
      | addressDiff(A1,A2,bitIndex2)
      | addressDiff(A1,A2,bitIndex3)
      | addressDiff(A1,A2,bitIndex4)
      | addressDiff(A1,A2,bitIndex5)
      | addressDiff(A1,A2,bitIndex6)
      | addressDiff(A1,A2,bitIndex7)
      | addressDiff(A1,A2,bitIndex8) ) ).

fof(addAssertion,conjecture,
    ! [VarCurr] :
      ( reachableState(VarCurr)
     => v4(VarCurr) ) ).

fof(writeUnaryOperator_2758,axiom,
    ! [VarCurr] :
      ( ~ v4(VarCurr)
    <=> v28953(VarCurr) ) ).

fof(writeUnaryOperator_2757,axiom,
    ! [VarCurr] :
      ( ~ v28953(VarCurr)
    <=> v28954(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4993,axiom,
    ! [VarCurr] :
      ( v28954(VarCurr)
    <=> ( v28956(VarCurr)
        & v28967(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1264,axiom,
    ! [VarCurr] :
      ( v28967(VarCurr)
    <=> ( v28958(VarCurr,bitIndex0)
        | v28958(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_2756,axiom,
    ! [VarCurr] :
      ( ~ v28956(VarCurr)
    <=> v28957(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_1263,axiom,
    ! [VarCurr] :
      ( v28957(VarCurr)
    <=> ( v28958(VarCurr,bitIndex0)
        & v28958(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_12446,axiom,
    ! [VarCurr] :
      ( v28958(VarCurr,bitIndex0)
    <=> v28959(VarCurr) ) ).

fof(addAssignment_12445,axiom,
    ! [VarCurr] :
      ( v28958(VarCurr,bitIndex1)
    <=> $false ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4992,axiom,
    ! [VarCurr] :
      ( v28959(VarCurr)
    <=> ( v28960(VarCurr)
        | v28966(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_2205,axiom,
    ! [VarCurr] :
      ( v28966(VarCurr)
    <=> ( ( v26522(VarCurr,bitIndex59)
        <=> v28941(VarCurr,bitIndex59) )
        & ( v26522(VarCurr,bitIndex58)
        <=> v28941(VarCurr,bitIndex58) )
        & ( v26522(VarCurr,bitIndex57)
        <=> v28941(VarCurr,bitIndex57) )
        & ( v26522(VarCurr,bitIndex56)
        <=> v28941(VarCurr,bitIndex56) )
        & ( v26522(VarCurr,bitIndex55)
        <=> v28941(VarCurr,bitIndex55) )
        & ( v26522(VarCurr,bitIndex54)
        <=> v28941(VarCurr,bitIndex54) )
        & ( v26522(VarCurr,bitIndex53)
        <=> v28941(VarCurr,bitIndex53) )
        & ( v26522(VarCurr,bitIndex52)
        <=> v28941(VarCurr,bitIndex52) )
        & ( v26522(VarCurr,bitIndex51)
        <=> v28941(VarCurr,bitIndex51) )
        & ( v26522(VarCurr,bitIndex50)
        <=> v28941(VarCurr,bitIndex50) )
        & ( v26522(VarCurr,bitIndex49)
        <=> v28941(VarCurr,bitIndex49) )
        & ( v26522(VarCurr,bitIndex48)
        <=> v28941(VarCurr,bitIndex48) )
        & ( v26522(VarCurr,bitIndex47)
        <=> v28941(VarCurr,bitIndex47) )
        & ( v26522(VarCurr,bitIndex46)
        <=> v28941(VarCurr,bitIndex46) )
        & ( v26522(VarCurr,bitIndex45)
        <=> v28941(VarCurr,bitIndex45) )
        & ( v26522(VarCurr,bitIndex44)
        <=> v28941(VarCurr,bitIndex44) )
        & ( v26522(VarCurr,bitIndex43)
        <=> v28941(VarCurr,bitIndex43) )
        & ( v26522(VarCurr,bitIndex42)
        <=> v28941(VarCurr,bitIndex42) )
        & ( v26522(VarCurr,bitIndex41)
        <=> v28941(VarCurr,bitIndex41) )
        & ( v26522(VarCurr,bitIndex40)
        <=> v28941(VarCurr,bitIndex40) )
        & ( v26522(VarCurr,bitIndex39)
        <=> v28941(VarCurr,bitIndex39) )
        & ( v26522(VarCurr,bitIndex38)
        <=> v28941(VarCurr,bitIndex38) )
        & ( v26522(VarCurr,bitIndex37)
        <=> v28941(VarCurr,bitIndex37) )
        & ( v26522(VarCurr,bitIndex36)
        <=> v28941(VarCurr,bitIndex36) )
        & ( v26522(VarCurr,bitIndex35)
        <=> v28941(VarCurr,bitIndex35) )
        & ( v26522(VarCurr,bitIndex34)
        <=> v28941(VarCurr,bitIndex34) )
        & ( v26522(VarCurr,bitIndex33)
        <=> v28941(VarCurr,bitIndex33) )
        & ( v26522(VarCurr,bitIndex32)
        <=> v28941(VarCurr,bitIndex32) )
        & ( v26522(VarCurr,bitIndex31)
        <=> v28941(VarCurr,bitIndex31) )
        & ( v26522(VarCurr,bitIndex30)
        <=> v28941(VarCurr,bitIndex30) )
        & ( v26522(VarCurr,bitIndex29)
        <=> v28941(VarCurr,bitIndex29) )
        & ( v26522(VarCurr,bitIndex28)
        <=> v28941(VarCurr,bitIndex28) )
        & ( v26522(VarCurr,bitIndex27)
        <=> v28941(VarCurr,bitIndex27) )
        & ( v26522(VarCurr,bitIndex26)
        <=> v28941(VarCurr,bitIndex26) )
        & ( v26522(VarCurr,bitIndex25)
        <=> v28941(VarCurr,bitIndex25) )
        & ( v26522(VarCurr,bitIndex24)
        <=> v28941(VarCurr,bitIndex24) )
        & ( v26522(VarCurr,bitIndex23)
        <=> v28941(VarCurr,bitIndex23) )
        & ( v26522(VarCurr,bitIndex22)
        <=> v28941(VarCurr,bitIndex22) )
        & ( v26522(VarCurr,bitIndex21)
        <=> v28941(VarCurr,bitIndex21) )
        & ( v26522(VarCurr,bitIndex20)
        <=> v28941(VarCurr,bitIndex20) )
        & ( v26522(VarCurr,bitIndex19)
        <=> v28941(VarCurr,bitIndex19) )
        & ( v26522(VarCurr,bitIndex18)
        <=> v28941(VarCurr,bitIndex18) )
        & ( v26522(VarCurr,bitIndex17)
        <=> v28941(VarCurr,bitIndex17) )
        & ( v26522(VarCurr,bitIndex16)
        <=> v28941(VarCurr,bitIndex16) )
        & ( v26522(VarCurr,bitIndex15)
        <=> v28941(VarCurr,bitIndex15) )
        & ( v26522(VarCurr,bitIndex14)
        <=> v28941(VarCurr,bitIndex14) )
        & ( v26522(VarCurr,bitIndex13)
        <=> v28941(VarCurr,bitIndex13) )
        & ( v26522(VarCurr,bitIndex12)
        <=> v28941(VarCurr,bitIndex12) )
        & ( v26522(VarCurr,bitIndex11)
        <=> v28941(VarCurr,bitIndex11) )
        & ( v26522(VarCurr,bitIndex10)
        <=> v28941(VarCurr,bitIndex10) )
        & ( v26522(VarCurr,bitIndex9)
        <=> v28941(VarCurr,bitIndex9) )
        & ( v26522(VarCurr,bitIndex8)
        <=> v28941(VarCurr,bitIndex8) )
        & ( v26522(VarCurr,bitIndex7)
        <=> v28941(VarCurr,bitIndex7) )
        & ( v26522(VarCurr,bitIndex6)
        <=> v28941(VarCurr,bitIndex6) )
        & ( v26522(VarCurr,bitIndex5)
        <=> v28941(VarCurr,bitIndex5) )
        & ( v26522(VarCurr,bitIndex4)
        <=> v28941(VarCurr,bitIndex4) )
        & ( v26522(VarCurr,bitIndex3)
        <=> v28941(VarCurr,bitIndex3) )
        & ( v26522(VarCurr,bitIndex2)
        <=> v28941(VarCurr,bitIndex2) )
        & ( v26522(VarCurr,bitIndex1)
        <=> v28941(VarCurr,bitIndex1) )
        & ( v26522(VarCurr,bitIndex0)
        <=> v28941(VarCurr,bitIndex0) ) ) ) ).

fof(writeUnaryOperator_2755,axiom,
    ! [VarCurr] :
      ( ~ v28960(VarCurr)
    <=> v28961(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4991,axiom,
    ! [VarCurr] :
      ( v28961(VarCurr)
    <=> ( v28962(VarCurr)
        & v28963(VarCurr) ) ) ).

fof(writeUnaryOperator_2754,axiom,
    ! [VarCurr] :
      ( ~ v28963(VarCurr)
    <=> v28964(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4990,axiom,
    ! [VarCurr] :
      ( v28964(VarCurr)
    <=> ( v25613(VarCurr)
        & v28965(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_2204,axiom,
    ! [VarCurr] :
      ( v28965(VarCurr)
    <=> ( ( v25768(VarCurr,bitIndex8)
        <=> v26217(VarCurr,bitIndex8) )
        & ( v25768(VarCurr,bitIndex7)
        <=> v26217(VarCurr,bitIndex7) )
        & ( v25768(VarCurr,bitIndex6)
        <=> v26217(VarCurr,bitIndex6) )
        & ( v25768(VarCurr,bitIndex5)
        <=> v26217(VarCurr,bitIndex5) )
        & ( v25768(VarCurr,bitIndex4)
        <=> v26217(VarCurr,bitIndex4) )
        & ( v25768(VarCurr,bitIndex3)
        <=> v26217(VarCurr,bitIndex3) )
        & ( v25768(VarCurr,bitIndex2)
        <=> v26217(VarCurr,bitIndex2) )
        & ( v25768(VarCurr,bitIndex1)
        <=> v26217(VarCurr,bitIndex1) )
        & ( v25768(VarCurr,bitIndex0)
        <=> v26217(VarCurr,bitIndex0) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4989,axiom,
    ! [VarCurr] :
      ( v28962(VarCurr)
    <=> ( v7(VarCurr)
        & v73(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_807,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7(VarNext)
       => ! [B] :
            ( range_59_0(B)
           => ( v26522(VarNext,B)
            <=> v26522(VarCurr,B) ) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_561,axiom,
    ! [VarNext] :
      ( v7(VarNext)
     => ! [B] :
          ( range_59_0(B)
         => ( v26522(VarNext,B)
          <=> v28945(VarNext,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_806,axiom,
    ! [VarCurr] :
      ( ~ v73(VarCurr)
     => ! [B] :
          ( range_59_0(B)
         => ( v28945(VarCurr,B)
          <=> $false ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_560,axiom,
    ! [VarCurr] :
      ( v73(VarCurr)
     => ! [B] :
          ( range_59_0(B)
         => ( v28945(VarCurr,B)
          <=> v28946(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_805,axiom,
    ! [VarCurr] :
      ( ~ v28947(VarCurr)
     => ! [B] :
          ( range_59_0(B)
         => ( v28946(VarCurr,B)
          <=> v28941(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_559,axiom,
    ! [VarCurr] :
      ( v28947(VarCurr)
     => ! [B] :
          ( range_59_0(B)
         => ( v28946(VarCurr,B)
          <=> bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4988,axiom,
    ! [VarCurr] :
      ( v28947(VarCurr)
    <=> ( v25613(VarCurr)
        & v28948(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_2203,axiom,
    ! [VarCurr] :
      ( v28948(VarCurr)
    <=> ( ( v25768(VarCurr,bitIndex8)
        <=> v26217(VarCurr,bitIndex8) )
        & ( v25768(VarCurr,bitIndex7)
        <=> v26217(VarCurr,bitIndex7) )
        & ( v25768(VarCurr,bitIndex6)
        <=> v26217(VarCurr,bitIndex6) )
        & ( v25768(VarCurr,bitIndex5)
        <=> v26217(VarCurr,bitIndex5) )
        & ( v25768(VarCurr,bitIndex4)
        <=> v26217(VarCurr,bitIndex4) )
        & ( v25768(VarCurr,bitIndex3)
        <=> v26217(VarCurr,bitIndex3) )
        & ( v25768(VarCurr,bitIndex2)
        <=> v26217(VarCurr,bitIndex2) )
        & ( v25768(VarCurr,bitIndex1)
        <=> v26217(VarCurr,bitIndex1) )
        & ( v25768(VarCurr,bitIndex0)
        <=> v26217(VarCurr,bitIndex0) ) ) ) ).

fof(addAssignmentInitValueVector_1037,axiom,
    ! [B] :
      ( range_59_0(B)
     => ( v26522(constB0,B)
      <=> $false ) ) ).

fof(bitBlastConstant_3481,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex59) ).

fof(bitBlastConstant_3480,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex58) ).

fof(bitBlastConstant_3479,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex57) ).

fof(bitBlastConstant_3478,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex56) ).

fof(bitBlastConstant_3477,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex55) ).

fof(bitBlastConstant_3476,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex54) ).

fof(bitBlastConstant_3475,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex53) ).

fof(bitBlastConstant_3474,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex52) ).

fof(bitBlastConstant_3473,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex51) ).

fof(bitBlastConstant_3472,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex50) ).

fof(bitBlastConstant_3471,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex49) ).

fof(bitBlastConstant_3470,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex48) ).

fof(bitBlastConstant_3469,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex47) ).

fof(bitBlastConstant_3468,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex46) ).

fof(bitBlastConstant_3467,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex45) ).

fof(bitBlastConstant_3466,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex44) ).

fof(bitBlastConstant_3465,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex43) ).

fof(bitBlastConstant_3464,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex42) ).

fof(bitBlastConstant_3463,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex41) ).

fof(bitBlastConstant_3462,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex40) ).

fof(bitBlastConstant_3461,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex39) ).

fof(bitBlastConstant_3460,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex38) ).

fof(bitBlastConstant_3459,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex37) ).

fof(bitBlastConstant_3458,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex36) ).

fof(bitBlastConstant_3457,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex35) ).

fof(bitBlastConstant_3456,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex34) ).

fof(bitBlastConstant_3455,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex33) ).

fof(bitBlastConstant_3454,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex32) ).

fof(bitBlastConstant_3453,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex31) ).

fof(bitBlastConstant_3452,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex30) ).

fof(bitBlastConstant_3451,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex29) ).

fof(bitBlastConstant_3450,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex28) ).

fof(bitBlastConstant_3449,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex27) ).

fof(bitBlastConstant_3448,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex26) ).

fof(bitBlastConstant_3447,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex25) ).

fof(bitBlastConstant_3446,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex24) ).

fof(bitBlastConstant_3445,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex23) ).

fof(bitBlastConstant_3444,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex22) ).

fof(bitBlastConstant_3443,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex21) ).

fof(bitBlastConstant_3442,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex20) ).

fof(bitBlastConstant_3441,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex19) ).

fof(bitBlastConstant_3440,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex18) ).

fof(bitBlastConstant_3439,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex17) ).

fof(bitBlastConstant_3438,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex16) ).

fof(bitBlastConstant_3437,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex15) ).

fof(bitBlastConstant_3436,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex14) ).

fof(bitBlastConstant_3435,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex13) ).

fof(bitBlastConstant_3434,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex12) ).

fof(bitBlastConstant_3433,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex11) ).

fof(bitBlastConstant_3432,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex10) ).

fof(bitBlastConstant_3431,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex9) ).

fof(bitBlastConstant_3430,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex8) ).

fof(bitBlastConstant_3429,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex7) ).

fof(bitBlastConstant_3428,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex6) ).

fof(bitBlastConstant_3427,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex5) ).

fof(bitBlastConstant_3426,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex4) ).

fof(bitBlastConstant_3425,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex3) ).

fof(bitBlastConstant_3424,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex2) ).

fof(bitBlastConstant_3423,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex1) ).

fof(bitBlastConstant_3422,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000(bitIndex0) ).

fof(memoryReadIntoBuffer,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v25768_range_8_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( address(A)
             => ! [B] :
                  ( A = AssociatedAddressVar
                 => ( range_59_0(B)
                   => ( v28941(VarNext,B)
                    <=> v26525_array(VarNext,A,B) ) ) ) ) ) ) ).

fof(memoryWriteDisabled,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v26217_range_8_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ~ ( A = AssociatedAddressVar
                  & v28937(VarNext) )
             => ! [B] :
                  ( range_59_0(B)
                 => ( v26525_array(VarNext,A,B)
                  <=> v26525_array(VarCurr,A,B) ) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v26217_range_8_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ( A = AssociatedAddressVar
                & v28937(VarNext) )
             => ! [B] :
                  ( range_59_0(B)
                 => ( v26525_array(VarNext,A,B)
                  <=> v26527(VarNext,B) ) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4987,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28937(VarNext)
      <=> ( v28938(VarNext)
          & v25613(VarNext) ) ) ) ).

fof(writeUnaryOperator_2753,axiom,
    ! [VarCurr] :
      ( ~ v28938(VarCurr)
    <=> v7(VarCurr) ) ).

fof(addAssignment_12444,axiom,
    ! [VarCurr,B] :
      ( range_59_0(B)
     => ( v26527(VarCurr,B)
      <=> v26529(VarCurr,B) ) ) ).

fof(addAssignment_12443,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex59)
    <=> v26531(VarCurr) ) ).

fof(addAssignment_12442,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex58)
    <=> v26559(VarCurr) ) ).

fof(addAssignment_12441,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex57)
    <=> v26587(VarCurr) ) ).

fof(addAssignment_12440,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex56)
    <=> v26615(VarCurr) ) ).

fof(addAssignment_12439,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex55)
    <=> v26643(VarCurr) ) ).

fof(addAssignment_12438,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex54)
    <=> v26671(VarCurr) ) ).

fof(addAssignment_12437,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex53)
    <=> v26699(VarCurr) ) ).

fof(addAssignment_12436,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex52)
    <=> v26727(VarCurr) ) ).

fof(addAssignment_12435,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex51)
    <=> v26755(VarCurr) ) ).

fof(addAssignment_12434,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex50)
    <=> v26907(VarCurr) ) ).

fof(addAssignment_12433,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex49)
    <=> v27185(VarCurr) ) ).

fof(addAssignment_12432,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex48)
    <=> v27334(VarCurr) ) ).

fof(addAssignment_12431,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex47)
    <=> v27619(VarCurr) ) ).

fof(addAssignment_12430,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex46)
    <=> v27647(VarCurr) ) ).

fof(addAssignment_12429,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex45)
    <=> v27675(VarCurr) ) ).

fof(addAssignment_12428,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex44)
    <=> v27703(VarCurr) ) ).

fof(addAssignment_12427,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex43)
    <=> v27731(VarCurr) ) ).

fof(addAssignment_12426,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex42)
    <=> v27759(VarCurr) ) ).

fof(addAssignment_12425,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex41)
    <=> v27787(VarCurr) ) ).

fof(addAssignment_12424,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex40)
    <=> v27815(VarCurr) ) ).

fof(addAssignment_12423,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex39)
    <=> v27843(VarCurr) ) ).

fof(addAssignment_12422,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex38)
    <=> v27871(VarCurr) ) ).

fof(addAssignment_12421,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex37)
    <=> v27899(VarCurr) ) ).

fof(addAssignment_12420,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex36)
    <=> v27927(VarCurr) ) ).

fof(addAssignment_12419,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex35)
    <=> v27955(VarCurr) ) ).

fof(addAssignment_12418,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex34)
    <=> v27983(VarCurr) ) ).

fof(addAssignment_12417,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex33)
    <=> v28011(VarCurr) ) ).

fof(addAssignment_12416,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex32)
    <=> v28039(VarCurr) ) ).

fof(addAssignment_12415,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex31)
    <=> v28067(VarCurr) ) ).

fof(addAssignment_12414,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex30)
    <=> v174(VarCurr) ) ).

fof(addAssignment_12413,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex29)
    <=> v28095(VarCurr) ) ).

fof(addAssignment_12412,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex28)
    <=> v28123(VarCurr) ) ).

fof(addAssignment_12411,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex27)
    <=> v28151(VarCurr) ) ).

fof(addAssignment_12410,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex26)
    <=> v28179(VarCurr) ) ).

fof(addAssignment_12409,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex25)
    <=> v28207(VarCurr) ) ).

fof(addAssignment_12408,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex24)
    <=> v28235(VarCurr) ) ).

fof(addAssignment_12407,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex23)
    <=> v28263(VarCurr) ) ).

fof(addAssignment_12406,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex22)
    <=> v28291(VarCurr) ) ).

fof(addAssignment_12405,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex21)
    <=> v28319(VarCurr) ) ).

fof(addAssignment_12404,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex20)
    <=> v28347(VarCurr) ) ).

fof(addAssignment_12403,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex19)
    <=> v28375(VarCurr) ) ).

fof(addAssignment_12402,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex18)
    <=> v28403(VarCurr) ) ).

fof(addAssignment_12401,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex17)
    <=> v28431(VarCurr) ) ).

fof(addAssignment_12400,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex16)
    <=> v28459(VarCurr) ) ).

fof(addAssignment_12399,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex15)
    <=> v28487(VarCurr) ) ).

fof(addAssignment_12398,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex14)
    <=> v28515(VarCurr) ) ).

fof(addAssignment_12397,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex13)
    <=> v28543(VarCurr) ) ).

fof(addAssignment_12396,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex12)
    <=> v28571(VarCurr) ) ).

fof(addAssignment_12395,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex11)
    <=> v28599(VarCurr) ) ).

fof(addAssignment_12394,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex10)
    <=> v28627(VarCurr) ) ).

fof(addAssignment_12393,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex9)
    <=> v28655(VarCurr) ) ).

fof(addAssignment_12392,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex8)
    <=> v28683(VarCurr) ) ).

fof(addAssignment_12391,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex7)
    <=> v28711(VarCurr) ) ).

fof(addAssignment_12390,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex6)
    <=> v28739(VarCurr) ) ).

fof(addAssignment_12389,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex5)
    <=> v28767(VarCurr) ) ).

fof(addAssignment_12388,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex4)
    <=> v28795(VarCurr) ) ).

fof(addAssignment_12387,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex3)
    <=> v28823(VarCurr) ) ).

fof(addAssignment_12386,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex2)
    <=> v28851(VarCurr) ) ).

fof(addAssignment_12385,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex1)
    <=> v28879(VarCurr) ) ).

fof(addAssignment_12384,axiom,
    ! [VarCurr] :
      ( v26529(VarCurr,bitIndex0)
    <=> v28907(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_540,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28918(VarNext)
       => ( v28907(VarNext)
        <=> v28907(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_535,axiom,
    ! [VarNext] :
      ( v28918(VarNext)
     => ( v28907(VarNext)
      <=> v28928(VarNext) ) ) ).

fof(addAssignment_12383,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28928(VarNext)
      <=> v28926(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_804,axiom,
    ! [VarCurr] :
      ( ~ v28929(VarCurr)
     => ( v28926(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_558,axiom,
    ! [VarCurr] :
      ( v28929(VarCurr)
     => ( v28926(VarCurr)
      <=> v28913(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4986,axiom,
    ! [VarCurr] :
      ( v28929(VarCurr)
    <=> ( v28930(VarCurr)
        & v28931(VarCurr) ) ) ).

fof(writeUnaryOperator_2752,axiom,
    ! [VarCurr] :
      ( ~ v28931(VarCurr)
    <=> v28911(VarCurr) ) ).

fof(writeUnaryOperator_2751,axiom,
    ! [VarCurr] :
      ( ~ v28930(VarCurr)
    <=> v28909(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4985,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28918(VarNext)
      <=> v28919(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4984,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28919(VarNext)
      <=> ( v28920(VarNext)
          & v28915(VarNext) ) ) ) ).

fof(writeUnaryOperator_2750,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28920(VarNext)
      <=> v28922(VarNext) ) ) ).

fof(addAssignment_12382,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28922(VarNext)
      <=> v28915(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1036,axiom,
    ( v28907(constB0)
  <=> $false ) ).

fof(addAssignment_12381,axiom,
    ! [VarCurr] :
      ( v28915(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12380,axiom,
    ! [VarCurr] :
      ( v28913(VarCurr)
    <=> v202(VarCurr,bitIndex0) ) ).

fof(addAssignment_12379,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex0)
    <=> v204(VarCurr,bitIndex0) ) ).

fof(addAssignment_12378,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex0)
    <=> v25523(VarCurr,bitIndex0) ) ).

fof(addAssignment_12377,axiom,
    ! [VarCurr] :
      ( v28911(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12376,axiom,
    ! [VarCurr] :
      ( v28909(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_539,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28890(VarNext)
       => ( v28879(VarNext)
        <=> v28879(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_534,axiom,
    ! [VarNext] :
      ( v28890(VarNext)
     => ( v28879(VarNext)
      <=> v28900(VarNext) ) ) ).

fof(addAssignment_12375,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28900(VarNext)
      <=> v28898(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_803,axiom,
    ! [VarCurr] :
      ( ~ v28901(VarCurr)
     => ( v28898(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_557,axiom,
    ! [VarCurr] :
      ( v28901(VarCurr)
     => ( v28898(VarCurr)
      <=> v28885(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4983,axiom,
    ! [VarCurr] :
      ( v28901(VarCurr)
    <=> ( v28902(VarCurr)
        & v28903(VarCurr) ) ) ).

fof(writeUnaryOperator_2749,axiom,
    ! [VarCurr] :
      ( ~ v28903(VarCurr)
    <=> v28883(VarCurr) ) ).

fof(writeUnaryOperator_2748,axiom,
    ! [VarCurr] :
      ( ~ v28902(VarCurr)
    <=> v28881(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4982,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28890(VarNext)
      <=> v28891(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4981,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28891(VarNext)
      <=> ( v28892(VarNext)
          & v28887(VarNext) ) ) ) ).

fof(writeUnaryOperator_2747,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28892(VarNext)
      <=> v28894(VarNext) ) ) ).

fof(addAssignment_12374,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28894(VarNext)
      <=> v28887(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1035,axiom,
    ( v28879(constB0)
  <=> $false ) ).

fof(addAssignment_12373,axiom,
    ! [VarCurr] :
      ( v28887(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12372,axiom,
    ! [VarCurr] :
      ( v28885(VarCurr)
    <=> v202(VarCurr,bitIndex1) ) ).

fof(addAssignment_12371,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex1)
    <=> v204(VarCurr,bitIndex1) ) ).

fof(addAssignment_12370,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex1)
    <=> v25523(VarCurr,bitIndex1) ) ).

fof(addAssignment_12369,axiom,
    ! [VarCurr] :
      ( v28883(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12368,axiom,
    ! [VarCurr] :
      ( v28881(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_538,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28862(VarNext)
       => ( v28851(VarNext)
        <=> v28851(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_533,axiom,
    ! [VarNext] :
      ( v28862(VarNext)
     => ( v28851(VarNext)
      <=> v28872(VarNext) ) ) ).

fof(addAssignment_12367,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28872(VarNext)
      <=> v28870(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_802,axiom,
    ! [VarCurr] :
      ( ~ v28873(VarCurr)
     => ( v28870(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_556,axiom,
    ! [VarCurr] :
      ( v28873(VarCurr)
     => ( v28870(VarCurr)
      <=> v28857(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4980,axiom,
    ! [VarCurr] :
      ( v28873(VarCurr)
    <=> ( v28874(VarCurr)
        & v28875(VarCurr) ) ) ).

fof(writeUnaryOperator_2746,axiom,
    ! [VarCurr] :
      ( ~ v28875(VarCurr)
    <=> v28855(VarCurr) ) ).

fof(writeUnaryOperator_2745,axiom,
    ! [VarCurr] :
      ( ~ v28874(VarCurr)
    <=> v28853(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4979,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28862(VarNext)
      <=> v28863(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4978,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28863(VarNext)
      <=> ( v28864(VarNext)
          & v28859(VarNext) ) ) ) ).

fof(writeUnaryOperator_2744,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28864(VarNext)
      <=> v28866(VarNext) ) ) ).

fof(addAssignment_12366,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28866(VarNext)
      <=> v28859(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1034,axiom,
    ( v28851(constB0)
  <=> $false ) ).

fof(addAssignment_12365,axiom,
    ! [VarCurr] :
      ( v28859(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12364,axiom,
    ! [VarCurr] :
      ( v28857(VarCurr)
    <=> v202(VarCurr,bitIndex2) ) ).

fof(addAssignment_12363,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex2)
    <=> v204(VarCurr,bitIndex2) ) ).

fof(addAssignment_12362,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex2)
    <=> v25523(VarCurr,bitIndex2) ) ).

fof(addAssignment_12361,axiom,
    ! [VarCurr] :
      ( v28855(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12360,axiom,
    ! [VarCurr] :
      ( v28853(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_537,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28834(VarNext)
       => ( v28823(VarNext)
        <=> v28823(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_532,axiom,
    ! [VarNext] :
      ( v28834(VarNext)
     => ( v28823(VarNext)
      <=> v28844(VarNext) ) ) ).

fof(addAssignment_12359,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28844(VarNext)
      <=> v28842(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_801,axiom,
    ! [VarCurr] :
      ( ~ v28845(VarCurr)
     => ( v28842(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_555,axiom,
    ! [VarCurr] :
      ( v28845(VarCurr)
     => ( v28842(VarCurr)
      <=> v28829(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4977,axiom,
    ! [VarCurr] :
      ( v28845(VarCurr)
    <=> ( v28846(VarCurr)
        & v28847(VarCurr) ) ) ).

fof(writeUnaryOperator_2743,axiom,
    ! [VarCurr] :
      ( ~ v28847(VarCurr)
    <=> v28827(VarCurr) ) ).

fof(writeUnaryOperator_2742,axiom,
    ! [VarCurr] :
      ( ~ v28846(VarCurr)
    <=> v28825(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4976,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28834(VarNext)
      <=> v28835(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4975,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28835(VarNext)
      <=> ( v28836(VarNext)
          & v28831(VarNext) ) ) ) ).

fof(writeUnaryOperator_2741,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28836(VarNext)
      <=> v28838(VarNext) ) ) ).

fof(addAssignment_12358,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28838(VarNext)
      <=> v28831(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1033,axiom,
    ( v28823(constB0)
  <=> $false ) ).

fof(addAssignment_12357,axiom,
    ! [VarCurr] :
      ( v28831(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12356,axiom,
    ! [VarCurr] :
      ( v28829(VarCurr)
    <=> v202(VarCurr,bitIndex3) ) ).

fof(addAssignment_12355,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex3)
    <=> v204(VarCurr,bitIndex3) ) ).

fof(addAssignment_12354,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex3)
    <=> v25523(VarCurr,bitIndex3) ) ).

fof(addAssignment_12353,axiom,
    ! [VarCurr] :
      ( v28827(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12352,axiom,
    ! [VarCurr] :
      ( v28825(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_536,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28806(VarNext)
       => ( v28795(VarNext)
        <=> v28795(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_531,axiom,
    ! [VarNext] :
      ( v28806(VarNext)
     => ( v28795(VarNext)
      <=> v28816(VarNext) ) ) ).

fof(addAssignment_12351,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28816(VarNext)
      <=> v28814(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_800,axiom,
    ! [VarCurr] :
      ( ~ v28817(VarCurr)
     => ( v28814(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_554,axiom,
    ! [VarCurr] :
      ( v28817(VarCurr)
     => ( v28814(VarCurr)
      <=> v28801(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4974,axiom,
    ! [VarCurr] :
      ( v28817(VarCurr)
    <=> ( v28818(VarCurr)
        & v28819(VarCurr) ) ) ).

fof(writeUnaryOperator_2740,axiom,
    ! [VarCurr] :
      ( ~ v28819(VarCurr)
    <=> v28799(VarCurr) ) ).

fof(writeUnaryOperator_2739,axiom,
    ! [VarCurr] :
      ( ~ v28818(VarCurr)
    <=> v28797(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4973,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28806(VarNext)
      <=> v28807(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4972,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28807(VarNext)
      <=> ( v28808(VarNext)
          & v28803(VarNext) ) ) ) ).

fof(writeUnaryOperator_2738,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28808(VarNext)
      <=> v28810(VarNext) ) ) ).

fof(addAssignment_12350,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28810(VarNext)
      <=> v28803(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1032,axiom,
    ( v28795(constB0)
  <=> $false ) ).

fof(addAssignment_12349,axiom,
    ! [VarCurr] :
      ( v28803(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12348,axiom,
    ! [VarCurr] :
      ( v28801(VarCurr)
    <=> v202(VarCurr,bitIndex4) ) ).

fof(addAssignment_12347,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex4)
    <=> v204(VarCurr,bitIndex4) ) ).

fof(addAssignment_12346,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex4)
    <=> v25523(VarCurr,bitIndex4) ) ).

fof(addAssignment_12345,axiom,
    ! [VarCurr] :
      ( v28799(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12344,axiom,
    ! [VarCurr] :
      ( v28797(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_535,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28778(VarNext)
       => ( v28767(VarNext)
        <=> v28767(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_530,axiom,
    ! [VarNext] :
      ( v28778(VarNext)
     => ( v28767(VarNext)
      <=> v28788(VarNext) ) ) ).

fof(addAssignment_12343,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28788(VarNext)
      <=> v28786(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_799,axiom,
    ! [VarCurr] :
      ( ~ v28789(VarCurr)
     => ( v28786(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_553,axiom,
    ! [VarCurr] :
      ( v28789(VarCurr)
     => ( v28786(VarCurr)
      <=> v28773(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4971,axiom,
    ! [VarCurr] :
      ( v28789(VarCurr)
    <=> ( v28790(VarCurr)
        & v28791(VarCurr) ) ) ).

fof(writeUnaryOperator_2737,axiom,
    ! [VarCurr] :
      ( ~ v28791(VarCurr)
    <=> v28771(VarCurr) ) ).

fof(writeUnaryOperator_2736,axiom,
    ! [VarCurr] :
      ( ~ v28790(VarCurr)
    <=> v28769(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4970,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28778(VarNext)
      <=> v28779(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4969,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28779(VarNext)
      <=> ( v28780(VarNext)
          & v28775(VarNext) ) ) ) ).

fof(writeUnaryOperator_2735,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28780(VarNext)
      <=> v28782(VarNext) ) ) ).

fof(addAssignment_12342,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28782(VarNext)
      <=> v28775(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1031,axiom,
    ( v28767(constB0)
  <=> $false ) ).

fof(addAssignment_12341,axiom,
    ! [VarCurr] :
      ( v28775(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12340,axiom,
    ! [VarCurr] :
      ( v28773(VarCurr)
    <=> v202(VarCurr,bitIndex5) ) ).

fof(addAssignment_12339,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex5)
    <=> v204(VarCurr,bitIndex5) ) ).

fof(addAssignment_12338,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex5)
    <=> v25523(VarCurr,bitIndex5) ) ).

fof(addAssignment_12337,axiom,
    ! [VarCurr] :
      ( v28771(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12336,axiom,
    ! [VarCurr] :
      ( v28769(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_534,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28750(VarNext)
       => ( v28739(VarNext)
        <=> v28739(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_529,axiom,
    ! [VarNext] :
      ( v28750(VarNext)
     => ( v28739(VarNext)
      <=> v28760(VarNext) ) ) ).

fof(addAssignment_12335,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28760(VarNext)
      <=> v28758(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_798,axiom,
    ! [VarCurr] :
      ( ~ v28761(VarCurr)
     => ( v28758(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_552,axiom,
    ! [VarCurr] :
      ( v28761(VarCurr)
     => ( v28758(VarCurr)
      <=> v28745(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4968,axiom,
    ! [VarCurr] :
      ( v28761(VarCurr)
    <=> ( v28762(VarCurr)
        & v28763(VarCurr) ) ) ).

fof(writeUnaryOperator_2734,axiom,
    ! [VarCurr] :
      ( ~ v28763(VarCurr)
    <=> v28743(VarCurr) ) ).

fof(writeUnaryOperator_2733,axiom,
    ! [VarCurr] :
      ( ~ v28762(VarCurr)
    <=> v28741(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4967,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28750(VarNext)
      <=> v28751(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4966,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28751(VarNext)
      <=> ( v28752(VarNext)
          & v28747(VarNext) ) ) ) ).

fof(writeUnaryOperator_2732,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28752(VarNext)
      <=> v28754(VarNext) ) ) ).

fof(addAssignment_12334,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28754(VarNext)
      <=> v28747(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1030,axiom,
    ( v28739(constB0)
  <=> $false ) ).

fof(addAssignment_12333,axiom,
    ! [VarCurr] :
      ( v28747(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12332,axiom,
    ! [VarCurr] :
      ( v28745(VarCurr)
    <=> v202(VarCurr,bitIndex6) ) ).

fof(addAssignment_12331,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex6)
    <=> v204(VarCurr,bitIndex6) ) ).

fof(addAssignment_12330,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex6)
    <=> v25523(VarCurr,bitIndex6) ) ).

fof(addAssignment_12329,axiom,
    ! [VarCurr] :
      ( v28743(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12328,axiom,
    ! [VarCurr] :
      ( v28741(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_533,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28722(VarNext)
       => ( v28711(VarNext)
        <=> v28711(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_528,axiom,
    ! [VarNext] :
      ( v28722(VarNext)
     => ( v28711(VarNext)
      <=> v28732(VarNext) ) ) ).

fof(addAssignment_12327,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28732(VarNext)
      <=> v28730(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_797,axiom,
    ! [VarCurr] :
      ( ~ v28733(VarCurr)
     => ( v28730(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_551,axiom,
    ! [VarCurr] :
      ( v28733(VarCurr)
     => ( v28730(VarCurr)
      <=> v28717(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4965,axiom,
    ! [VarCurr] :
      ( v28733(VarCurr)
    <=> ( v28734(VarCurr)
        & v28735(VarCurr) ) ) ).

fof(writeUnaryOperator_2731,axiom,
    ! [VarCurr] :
      ( ~ v28735(VarCurr)
    <=> v28715(VarCurr) ) ).

fof(writeUnaryOperator_2730,axiom,
    ! [VarCurr] :
      ( ~ v28734(VarCurr)
    <=> v28713(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4964,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28722(VarNext)
      <=> v28723(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4963,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28723(VarNext)
      <=> ( v28724(VarNext)
          & v28719(VarNext) ) ) ) ).

fof(writeUnaryOperator_2729,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28724(VarNext)
      <=> v28726(VarNext) ) ) ).

fof(addAssignment_12326,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28726(VarNext)
      <=> v28719(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1029,axiom,
    ( v28711(constB0)
  <=> $false ) ).

fof(addAssignment_12325,axiom,
    ! [VarCurr] :
      ( v28719(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12324,axiom,
    ! [VarCurr] :
      ( v28717(VarCurr)
    <=> v202(VarCurr,bitIndex7) ) ).

fof(addAssignment_12323,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex7)
    <=> v204(VarCurr,bitIndex7) ) ).

fof(addAssignment_12322,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex7)
    <=> v25523(VarCurr,bitIndex7) ) ).

fof(addAssignment_12321,axiom,
    ! [VarCurr] :
      ( v28715(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12320,axiom,
    ! [VarCurr] :
      ( v28713(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_532,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28694(VarNext)
       => ( v28683(VarNext)
        <=> v28683(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_527,axiom,
    ! [VarNext] :
      ( v28694(VarNext)
     => ( v28683(VarNext)
      <=> v28704(VarNext) ) ) ).

fof(addAssignment_12319,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28704(VarNext)
      <=> v28702(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_796,axiom,
    ! [VarCurr] :
      ( ~ v28705(VarCurr)
     => ( v28702(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_550,axiom,
    ! [VarCurr] :
      ( v28705(VarCurr)
     => ( v28702(VarCurr)
      <=> v28689(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4962,axiom,
    ! [VarCurr] :
      ( v28705(VarCurr)
    <=> ( v28706(VarCurr)
        & v28707(VarCurr) ) ) ).

fof(writeUnaryOperator_2728,axiom,
    ! [VarCurr] :
      ( ~ v28707(VarCurr)
    <=> v28687(VarCurr) ) ).

fof(writeUnaryOperator_2727,axiom,
    ! [VarCurr] :
      ( ~ v28706(VarCurr)
    <=> v28685(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4961,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28694(VarNext)
      <=> v28695(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4960,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28695(VarNext)
      <=> ( v28696(VarNext)
          & v28691(VarNext) ) ) ) ).

fof(writeUnaryOperator_2726,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28696(VarNext)
      <=> v28698(VarNext) ) ) ).

fof(addAssignment_12318,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28698(VarNext)
      <=> v28691(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1028,axiom,
    ( v28683(constB0)
  <=> $false ) ).

fof(addAssignment_12317,axiom,
    ! [VarCurr] :
      ( v28691(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12316,axiom,
    ! [VarCurr] :
      ( v28689(VarCurr)
    <=> v202(VarCurr,bitIndex8) ) ).

fof(addAssignment_12315,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex8)
    <=> v204(VarCurr,bitIndex8) ) ).

fof(addAssignment_12314,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex8)
    <=> v25523(VarCurr,bitIndex8) ) ).

fof(addAssignment_12313,axiom,
    ! [VarCurr] :
      ( v28687(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12312,axiom,
    ! [VarCurr] :
      ( v28685(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_531,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28666(VarNext)
       => ( v28655(VarNext)
        <=> v28655(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_526,axiom,
    ! [VarNext] :
      ( v28666(VarNext)
     => ( v28655(VarNext)
      <=> v28676(VarNext) ) ) ).

fof(addAssignment_12311,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28676(VarNext)
      <=> v28674(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_795,axiom,
    ! [VarCurr] :
      ( ~ v28677(VarCurr)
     => ( v28674(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_549,axiom,
    ! [VarCurr] :
      ( v28677(VarCurr)
     => ( v28674(VarCurr)
      <=> v28661(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4959,axiom,
    ! [VarCurr] :
      ( v28677(VarCurr)
    <=> ( v28678(VarCurr)
        & v28679(VarCurr) ) ) ).

fof(writeUnaryOperator_2725,axiom,
    ! [VarCurr] :
      ( ~ v28679(VarCurr)
    <=> v28659(VarCurr) ) ).

fof(writeUnaryOperator_2724,axiom,
    ! [VarCurr] :
      ( ~ v28678(VarCurr)
    <=> v28657(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4958,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28666(VarNext)
      <=> v28667(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4957,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28667(VarNext)
      <=> ( v28668(VarNext)
          & v28663(VarNext) ) ) ) ).

fof(writeUnaryOperator_2723,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28668(VarNext)
      <=> v28670(VarNext) ) ) ).

fof(addAssignment_12310,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28670(VarNext)
      <=> v28663(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1027,axiom,
    ( v28655(constB0)
  <=> $false ) ).

fof(addAssignment_12309,axiom,
    ! [VarCurr] :
      ( v28663(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12308,axiom,
    ! [VarCurr] :
      ( v28661(VarCurr)
    <=> v202(VarCurr,bitIndex9) ) ).

fof(addAssignment_12307,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex9)
    <=> v204(VarCurr,bitIndex9) ) ).

fof(addAssignment_12306,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex9)
    <=> v25523(VarCurr,bitIndex9) ) ).

fof(addAssignment_12305,axiom,
    ! [VarCurr] :
      ( v28659(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12304,axiom,
    ! [VarCurr] :
      ( v28657(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_530,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28638(VarNext)
       => ( v28627(VarNext)
        <=> v28627(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_525,axiom,
    ! [VarNext] :
      ( v28638(VarNext)
     => ( v28627(VarNext)
      <=> v28648(VarNext) ) ) ).

fof(addAssignment_12303,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28648(VarNext)
      <=> v28646(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_794,axiom,
    ! [VarCurr] :
      ( ~ v28649(VarCurr)
     => ( v28646(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_548,axiom,
    ! [VarCurr] :
      ( v28649(VarCurr)
     => ( v28646(VarCurr)
      <=> v28633(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4956,axiom,
    ! [VarCurr] :
      ( v28649(VarCurr)
    <=> ( v28650(VarCurr)
        & v28651(VarCurr) ) ) ).

fof(writeUnaryOperator_2722,axiom,
    ! [VarCurr] :
      ( ~ v28651(VarCurr)
    <=> v28631(VarCurr) ) ).

fof(writeUnaryOperator_2721,axiom,
    ! [VarCurr] :
      ( ~ v28650(VarCurr)
    <=> v28629(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4955,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28638(VarNext)
      <=> v28639(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4954,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28639(VarNext)
      <=> ( v28640(VarNext)
          & v28635(VarNext) ) ) ) ).

fof(writeUnaryOperator_2720,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28640(VarNext)
      <=> v28642(VarNext) ) ) ).

fof(addAssignment_12302,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28642(VarNext)
      <=> v28635(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1026,axiom,
    ( v28627(constB0)
  <=> $false ) ).

fof(addAssignment_12301,axiom,
    ! [VarCurr] :
      ( v28635(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12300,axiom,
    ! [VarCurr] :
      ( v28633(VarCurr)
    <=> v202(VarCurr,bitIndex10) ) ).

fof(addAssignment_12299,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex10)
    <=> v204(VarCurr,bitIndex10) ) ).

fof(addAssignment_12298,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex10)
    <=> v25523(VarCurr,bitIndex10) ) ).

fof(addAssignment_12297,axiom,
    ! [VarCurr] :
      ( v28631(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12296,axiom,
    ! [VarCurr] :
      ( v28629(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_529,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28610(VarNext)
       => ( v28599(VarNext)
        <=> v28599(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_524,axiom,
    ! [VarNext] :
      ( v28610(VarNext)
     => ( v28599(VarNext)
      <=> v28620(VarNext) ) ) ).

fof(addAssignment_12295,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28620(VarNext)
      <=> v28618(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_793,axiom,
    ! [VarCurr] :
      ( ~ v28621(VarCurr)
     => ( v28618(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_547,axiom,
    ! [VarCurr] :
      ( v28621(VarCurr)
     => ( v28618(VarCurr)
      <=> v28605(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4953,axiom,
    ! [VarCurr] :
      ( v28621(VarCurr)
    <=> ( v28622(VarCurr)
        & v28623(VarCurr) ) ) ).

fof(writeUnaryOperator_2719,axiom,
    ! [VarCurr] :
      ( ~ v28623(VarCurr)
    <=> v28603(VarCurr) ) ).

fof(writeUnaryOperator_2718,axiom,
    ! [VarCurr] :
      ( ~ v28622(VarCurr)
    <=> v28601(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4952,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28610(VarNext)
      <=> v28611(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4951,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28611(VarNext)
      <=> ( v28612(VarNext)
          & v28607(VarNext) ) ) ) ).

fof(writeUnaryOperator_2717,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28612(VarNext)
      <=> v28614(VarNext) ) ) ).

fof(addAssignment_12294,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28614(VarNext)
      <=> v28607(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1025,axiom,
    ( v28599(constB0)
  <=> $false ) ).

fof(addAssignment_12293,axiom,
    ! [VarCurr] :
      ( v28607(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12292,axiom,
    ! [VarCurr] :
      ( v28605(VarCurr)
    <=> v202(VarCurr,bitIndex11) ) ).

fof(addAssignment_12291,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex11)
    <=> v204(VarCurr,bitIndex11) ) ).

fof(addAssignment_12290,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex11)
    <=> v25523(VarCurr,bitIndex11) ) ).

fof(addAssignment_12289,axiom,
    ! [VarCurr] :
      ( v28603(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12288,axiom,
    ! [VarCurr] :
      ( v28601(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_528,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28582(VarNext)
       => ( v28571(VarNext)
        <=> v28571(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_523,axiom,
    ! [VarNext] :
      ( v28582(VarNext)
     => ( v28571(VarNext)
      <=> v28592(VarNext) ) ) ).

fof(addAssignment_12287,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28592(VarNext)
      <=> v28590(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_792,axiom,
    ! [VarCurr] :
      ( ~ v28593(VarCurr)
     => ( v28590(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_546,axiom,
    ! [VarCurr] :
      ( v28593(VarCurr)
     => ( v28590(VarCurr)
      <=> v28577(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4950,axiom,
    ! [VarCurr] :
      ( v28593(VarCurr)
    <=> ( v28594(VarCurr)
        & v28595(VarCurr) ) ) ).

fof(writeUnaryOperator_2716,axiom,
    ! [VarCurr] :
      ( ~ v28595(VarCurr)
    <=> v28575(VarCurr) ) ).

fof(writeUnaryOperator_2715,axiom,
    ! [VarCurr] :
      ( ~ v28594(VarCurr)
    <=> v28573(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4949,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28582(VarNext)
      <=> v28583(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4948,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28583(VarNext)
      <=> ( v28584(VarNext)
          & v28579(VarNext) ) ) ) ).

fof(writeUnaryOperator_2714,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28584(VarNext)
      <=> v28586(VarNext) ) ) ).

fof(addAssignment_12286,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28586(VarNext)
      <=> v28579(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1024,axiom,
    ( v28571(constB0)
  <=> $false ) ).

fof(addAssignment_12285,axiom,
    ! [VarCurr] :
      ( v28579(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12284,axiom,
    ! [VarCurr] :
      ( v28577(VarCurr)
    <=> v202(VarCurr,bitIndex12) ) ).

fof(addAssignment_12283,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex12)
    <=> v204(VarCurr,bitIndex12) ) ).

fof(addAssignment_12282,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex12)
    <=> v25523(VarCurr,bitIndex12) ) ).

fof(addAssignment_12281,axiom,
    ! [VarCurr] :
      ( v28575(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12280,axiom,
    ! [VarCurr] :
      ( v28573(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_527,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28554(VarNext)
       => ( v28543(VarNext)
        <=> v28543(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_522,axiom,
    ! [VarNext] :
      ( v28554(VarNext)
     => ( v28543(VarNext)
      <=> v28564(VarNext) ) ) ).

fof(addAssignment_12279,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28564(VarNext)
      <=> v28562(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_791,axiom,
    ! [VarCurr] :
      ( ~ v28565(VarCurr)
     => ( v28562(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_545,axiom,
    ! [VarCurr] :
      ( v28565(VarCurr)
     => ( v28562(VarCurr)
      <=> v28549(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4947,axiom,
    ! [VarCurr] :
      ( v28565(VarCurr)
    <=> ( v28566(VarCurr)
        & v28567(VarCurr) ) ) ).

fof(writeUnaryOperator_2713,axiom,
    ! [VarCurr] :
      ( ~ v28567(VarCurr)
    <=> v28547(VarCurr) ) ).

fof(writeUnaryOperator_2712,axiom,
    ! [VarCurr] :
      ( ~ v28566(VarCurr)
    <=> v28545(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4946,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28554(VarNext)
      <=> v28555(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4945,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28555(VarNext)
      <=> ( v28556(VarNext)
          & v28551(VarNext) ) ) ) ).

fof(writeUnaryOperator_2711,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28556(VarNext)
      <=> v28558(VarNext) ) ) ).

fof(addAssignment_12278,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28558(VarNext)
      <=> v28551(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1023,axiom,
    ( v28543(constB0)
  <=> $false ) ).

fof(addAssignment_12277,axiom,
    ! [VarCurr] :
      ( v28551(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12276,axiom,
    ! [VarCurr] :
      ( v28549(VarCurr)
    <=> v202(VarCurr,bitIndex13) ) ).

fof(addAssignment_12275,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex13)
    <=> v204(VarCurr,bitIndex13) ) ).

fof(addAssignment_12274,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex13)
    <=> v25523(VarCurr,bitIndex13) ) ).

fof(addAssignment_12273,axiom,
    ! [VarCurr] :
      ( v28547(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12272,axiom,
    ! [VarCurr] :
      ( v28545(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_526,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28526(VarNext)
       => ( v28515(VarNext)
        <=> v28515(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_521,axiom,
    ! [VarNext] :
      ( v28526(VarNext)
     => ( v28515(VarNext)
      <=> v28536(VarNext) ) ) ).

fof(addAssignment_12271,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28536(VarNext)
      <=> v28534(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_790,axiom,
    ! [VarCurr] :
      ( ~ v28537(VarCurr)
     => ( v28534(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_544,axiom,
    ! [VarCurr] :
      ( v28537(VarCurr)
     => ( v28534(VarCurr)
      <=> v28521(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4944,axiom,
    ! [VarCurr] :
      ( v28537(VarCurr)
    <=> ( v28538(VarCurr)
        & v28539(VarCurr) ) ) ).

fof(writeUnaryOperator_2710,axiom,
    ! [VarCurr] :
      ( ~ v28539(VarCurr)
    <=> v28519(VarCurr) ) ).

fof(writeUnaryOperator_2709,axiom,
    ! [VarCurr] :
      ( ~ v28538(VarCurr)
    <=> v28517(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4943,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28526(VarNext)
      <=> v28527(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4942,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28527(VarNext)
      <=> ( v28528(VarNext)
          & v28523(VarNext) ) ) ) ).

fof(writeUnaryOperator_2708,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28528(VarNext)
      <=> v28530(VarNext) ) ) ).

fof(addAssignment_12270,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28530(VarNext)
      <=> v28523(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1022,axiom,
    ( v28515(constB0)
  <=> $false ) ).

fof(addAssignment_12269,axiom,
    ! [VarCurr] :
      ( v28523(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12268,axiom,
    ! [VarCurr] :
      ( v28521(VarCurr)
    <=> v202(VarCurr,bitIndex14) ) ).

fof(addAssignment_12267,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex14)
    <=> v204(VarCurr,bitIndex14) ) ).

fof(addAssignment_12266,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex14)
    <=> v25523(VarCurr,bitIndex14) ) ).

fof(addAssignment_12265,axiom,
    ! [VarCurr] :
      ( v28519(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12264,axiom,
    ! [VarCurr] :
      ( v28517(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_525,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28498(VarNext)
       => ( v28487(VarNext)
        <=> v28487(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_520,axiom,
    ! [VarNext] :
      ( v28498(VarNext)
     => ( v28487(VarNext)
      <=> v28508(VarNext) ) ) ).

fof(addAssignment_12263,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28508(VarNext)
      <=> v28506(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_789,axiom,
    ! [VarCurr] :
      ( ~ v28509(VarCurr)
     => ( v28506(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_543,axiom,
    ! [VarCurr] :
      ( v28509(VarCurr)
     => ( v28506(VarCurr)
      <=> v28493(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4941,axiom,
    ! [VarCurr] :
      ( v28509(VarCurr)
    <=> ( v28510(VarCurr)
        & v28511(VarCurr) ) ) ).

fof(writeUnaryOperator_2707,axiom,
    ! [VarCurr] :
      ( ~ v28511(VarCurr)
    <=> v28491(VarCurr) ) ).

fof(writeUnaryOperator_2706,axiom,
    ! [VarCurr] :
      ( ~ v28510(VarCurr)
    <=> v28489(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4940,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28498(VarNext)
      <=> v28499(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4939,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28499(VarNext)
      <=> ( v28500(VarNext)
          & v28495(VarNext) ) ) ) ).

fof(writeUnaryOperator_2705,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28500(VarNext)
      <=> v28502(VarNext) ) ) ).

fof(addAssignment_12262,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28502(VarNext)
      <=> v28495(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1021,axiom,
    ( v28487(constB0)
  <=> $false ) ).

fof(addAssignment_12261,axiom,
    ! [VarCurr] :
      ( v28495(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12260,axiom,
    ! [VarCurr] :
      ( v28493(VarCurr)
    <=> v202(VarCurr,bitIndex15) ) ).

fof(addAssignment_12259,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex15)
    <=> v204(VarCurr,bitIndex15) ) ).

fof(addAssignment_12258,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex15)
    <=> v25523(VarCurr,bitIndex15) ) ).

fof(addAssignment_12257,axiom,
    ! [VarCurr] :
      ( v28491(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12256,axiom,
    ! [VarCurr] :
      ( v28489(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_524,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28470(VarNext)
       => ( v28459(VarNext)
        <=> v28459(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_519,axiom,
    ! [VarNext] :
      ( v28470(VarNext)
     => ( v28459(VarNext)
      <=> v28480(VarNext) ) ) ).

fof(addAssignment_12255,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28480(VarNext)
      <=> v28478(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_788,axiom,
    ! [VarCurr] :
      ( ~ v28481(VarCurr)
     => ( v28478(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_542,axiom,
    ! [VarCurr] :
      ( v28481(VarCurr)
     => ( v28478(VarCurr)
      <=> v28465(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4938,axiom,
    ! [VarCurr] :
      ( v28481(VarCurr)
    <=> ( v28482(VarCurr)
        & v28483(VarCurr) ) ) ).

fof(writeUnaryOperator_2704,axiom,
    ! [VarCurr] :
      ( ~ v28483(VarCurr)
    <=> v28463(VarCurr) ) ).

fof(writeUnaryOperator_2703,axiom,
    ! [VarCurr] :
      ( ~ v28482(VarCurr)
    <=> v28461(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4937,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28470(VarNext)
      <=> v28471(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4936,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28471(VarNext)
      <=> ( v28472(VarNext)
          & v28467(VarNext) ) ) ) ).

fof(writeUnaryOperator_2702,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28472(VarNext)
      <=> v28474(VarNext) ) ) ).

fof(addAssignment_12254,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28474(VarNext)
      <=> v28467(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1020,axiom,
    ( v28459(constB0)
  <=> $false ) ).

fof(addAssignment_12253,axiom,
    ! [VarCurr] :
      ( v28467(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12252,axiom,
    ! [VarCurr] :
      ( v28465(VarCurr)
    <=> v202(VarCurr,bitIndex16) ) ).

fof(addAssignment_12251,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex16)
    <=> v204(VarCurr,bitIndex16) ) ).

fof(addAssignment_12250,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex16)
    <=> v25523(VarCurr,bitIndex16) ) ).

fof(addAssignment_12249,axiom,
    ! [VarCurr] :
      ( v28463(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12248,axiom,
    ! [VarCurr] :
      ( v28461(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_523,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28442(VarNext)
       => ( v28431(VarNext)
        <=> v28431(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_518,axiom,
    ! [VarNext] :
      ( v28442(VarNext)
     => ( v28431(VarNext)
      <=> v28452(VarNext) ) ) ).

fof(addAssignment_12247,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28452(VarNext)
      <=> v28450(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_787,axiom,
    ! [VarCurr] :
      ( ~ v28453(VarCurr)
     => ( v28450(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_541,axiom,
    ! [VarCurr] :
      ( v28453(VarCurr)
     => ( v28450(VarCurr)
      <=> v28437(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4935,axiom,
    ! [VarCurr] :
      ( v28453(VarCurr)
    <=> ( v28454(VarCurr)
        & v28455(VarCurr) ) ) ).

fof(writeUnaryOperator_2701,axiom,
    ! [VarCurr] :
      ( ~ v28455(VarCurr)
    <=> v28435(VarCurr) ) ).

fof(writeUnaryOperator_2700,axiom,
    ! [VarCurr] :
      ( ~ v28454(VarCurr)
    <=> v28433(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4934,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28442(VarNext)
      <=> v28443(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4933,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28443(VarNext)
      <=> ( v28444(VarNext)
          & v28439(VarNext) ) ) ) ).

fof(writeUnaryOperator_2699,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28444(VarNext)
      <=> v28446(VarNext) ) ) ).

fof(addAssignment_12246,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28446(VarNext)
      <=> v28439(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1019,axiom,
    ( v28431(constB0)
  <=> $false ) ).

fof(addAssignment_12245,axiom,
    ! [VarCurr] :
      ( v28439(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12244,axiom,
    ! [VarCurr] :
      ( v28437(VarCurr)
    <=> v202(VarCurr,bitIndex17) ) ).

fof(addAssignment_12243,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex17)
    <=> v204(VarCurr,bitIndex17) ) ).

fof(addAssignment_12242,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex17)
    <=> v25523(VarCurr,bitIndex17) ) ).

fof(addAssignment_12241,axiom,
    ! [VarCurr] :
      ( v28435(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12240,axiom,
    ! [VarCurr] :
      ( v28433(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_522,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28414(VarNext)
       => ( v28403(VarNext)
        <=> v28403(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_517,axiom,
    ! [VarNext] :
      ( v28414(VarNext)
     => ( v28403(VarNext)
      <=> v28424(VarNext) ) ) ).

fof(addAssignment_12239,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28424(VarNext)
      <=> v28422(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_786,axiom,
    ! [VarCurr] :
      ( ~ v28425(VarCurr)
     => ( v28422(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_540,axiom,
    ! [VarCurr] :
      ( v28425(VarCurr)
     => ( v28422(VarCurr)
      <=> v28409(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4932,axiom,
    ! [VarCurr] :
      ( v28425(VarCurr)
    <=> ( v28426(VarCurr)
        & v28427(VarCurr) ) ) ).

fof(writeUnaryOperator_2698,axiom,
    ! [VarCurr] :
      ( ~ v28427(VarCurr)
    <=> v28407(VarCurr) ) ).

fof(writeUnaryOperator_2697,axiom,
    ! [VarCurr] :
      ( ~ v28426(VarCurr)
    <=> v28405(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4931,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28414(VarNext)
      <=> v28415(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4930,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28415(VarNext)
      <=> ( v28416(VarNext)
          & v28411(VarNext) ) ) ) ).

fof(writeUnaryOperator_2696,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28416(VarNext)
      <=> v28418(VarNext) ) ) ).

fof(addAssignment_12238,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28418(VarNext)
      <=> v28411(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1018,axiom,
    ( v28403(constB0)
  <=> $false ) ).

fof(addAssignment_12237,axiom,
    ! [VarCurr] :
      ( v28411(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12236,axiom,
    ! [VarCurr] :
      ( v28409(VarCurr)
    <=> v202(VarCurr,bitIndex18) ) ).

fof(addAssignment_12235,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex18)
    <=> v204(VarCurr,bitIndex18) ) ).

fof(addAssignment_12234,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex18)
    <=> v25523(VarCurr,bitIndex18) ) ).

fof(addAssignment_12233,axiom,
    ! [VarCurr] :
      ( v28407(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12232,axiom,
    ! [VarCurr] :
      ( v28405(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_521,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28386(VarNext)
       => ( v28375(VarNext)
        <=> v28375(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_516,axiom,
    ! [VarNext] :
      ( v28386(VarNext)
     => ( v28375(VarNext)
      <=> v28396(VarNext) ) ) ).

fof(addAssignment_12231,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28396(VarNext)
      <=> v28394(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_785,axiom,
    ! [VarCurr] :
      ( ~ v28397(VarCurr)
     => ( v28394(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_539,axiom,
    ! [VarCurr] :
      ( v28397(VarCurr)
     => ( v28394(VarCurr)
      <=> v28381(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4929,axiom,
    ! [VarCurr] :
      ( v28397(VarCurr)
    <=> ( v28398(VarCurr)
        & v28399(VarCurr) ) ) ).

fof(writeUnaryOperator_2695,axiom,
    ! [VarCurr] :
      ( ~ v28399(VarCurr)
    <=> v28379(VarCurr) ) ).

fof(writeUnaryOperator_2694,axiom,
    ! [VarCurr] :
      ( ~ v28398(VarCurr)
    <=> v28377(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4928,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28386(VarNext)
      <=> v28387(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4927,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28387(VarNext)
      <=> ( v28388(VarNext)
          & v28383(VarNext) ) ) ) ).

fof(writeUnaryOperator_2693,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28388(VarNext)
      <=> v28390(VarNext) ) ) ).

fof(addAssignment_12230,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28390(VarNext)
      <=> v28383(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1017,axiom,
    ( v28375(constB0)
  <=> $false ) ).

fof(addAssignment_12229,axiom,
    ! [VarCurr] :
      ( v28383(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12228,axiom,
    ! [VarCurr] :
      ( v28381(VarCurr)
    <=> v202(VarCurr,bitIndex19) ) ).

fof(addAssignment_12227,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex19)
    <=> v204(VarCurr,bitIndex19) ) ).

fof(addAssignment_12226,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex19)
    <=> v25523(VarCurr,bitIndex19) ) ).

fof(addAssignment_12225,axiom,
    ! [VarCurr] :
      ( v28379(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12224,axiom,
    ! [VarCurr] :
      ( v28377(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_520,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28358(VarNext)
       => ( v28347(VarNext)
        <=> v28347(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_515,axiom,
    ! [VarNext] :
      ( v28358(VarNext)
     => ( v28347(VarNext)
      <=> v28368(VarNext) ) ) ).

fof(addAssignment_12223,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28368(VarNext)
      <=> v28366(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_784,axiom,
    ! [VarCurr] :
      ( ~ v28369(VarCurr)
     => ( v28366(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_538,axiom,
    ! [VarCurr] :
      ( v28369(VarCurr)
     => ( v28366(VarCurr)
      <=> v28353(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4926,axiom,
    ! [VarCurr] :
      ( v28369(VarCurr)
    <=> ( v28370(VarCurr)
        & v28371(VarCurr) ) ) ).

fof(writeUnaryOperator_2692,axiom,
    ! [VarCurr] :
      ( ~ v28371(VarCurr)
    <=> v28351(VarCurr) ) ).

fof(writeUnaryOperator_2691,axiom,
    ! [VarCurr] :
      ( ~ v28370(VarCurr)
    <=> v28349(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4925,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28358(VarNext)
      <=> v28359(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4924,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28359(VarNext)
      <=> ( v28360(VarNext)
          & v28355(VarNext) ) ) ) ).

fof(writeUnaryOperator_2690,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28360(VarNext)
      <=> v28362(VarNext) ) ) ).

fof(addAssignment_12222,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28362(VarNext)
      <=> v28355(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1016,axiom,
    ( v28347(constB0)
  <=> $false ) ).

fof(addAssignment_12221,axiom,
    ! [VarCurr] :
      ( v28355(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12220,axiom,
    ! [VarCurr] :
      ( v28353(VarCurr)
    <=> v202(VarCurr,bitIndex20) ) ).

fof(addAssignment_12219,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex20)
    <=> v204(VarCurr,bitIndex20) ) ).

fof(addAssignment_12218,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex20)
    <=> v25523(VarCurr,bitIndex20) ) ).

fof(addAssignment_12217,axiom,
    ! [VarCurr] :
      ( v28351(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12216,axiom,
    ! [VarCurr] :
      ( v28349(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_519,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28330(VarNext)
       => ( v28319(VarNext)
        <=> v28319(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_514,axiom,
    ! [VarNext] :
      ( v28330(VarNext)
     => ( v28319(VarNext)
      <=> v28340(VarNext) ) ) ).

fof(addAssignment_12215,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28340(VarNext)
      <=> v28338(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_783,axiom,
    ! [VarCurr] :
      ( ~ v28341(VarCurr)
     => ( v28338(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_537,axiom,
    ! [VarCurr] :
      ( v28341(VarCurr)
     => ( v28338(VarCurr)
      <=> v28325(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4923,axiom,
    ! [VarCurr] :
      ( v28341(VarCurr)
    <=> ( v28342(VarCurr)
        & v28343(VarCurr) ) ) ).

fof(writeUnaryOperator_2689,axiom,
    ! [VarCurr] :
      ( ~ v28343(VarCurr)
    <=> v28323(VarCurr) ) ).

fof(writeUnaryOperator_2688,axiom,
    ! [VarCurr] :
      ( ~ v28342(VarCurr)
    <=> v28321(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4922,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28330(VarNext)
      <=> v28331(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4921,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28331(VarNext)
      <=> ( v28332(VarNext)
          & v28327(VarNext) ) ) ) ).

fof(writeUnaryOperator_2687,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28332(VarNext)
      <=> v28334(VarNext) ) ) ).

fof(addAssignment_12214,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28334(VarNext)
      <=> v28327(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1015,axiom,
    ( v28319(constB0)
  <=> $false ) ).

fof(addAssignment_12213,axiom,
    ! [VarCurr] :
      ( v28327(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12212,axiom,
    ! [VarCurr] :
      ( v28325(VarCurr)
    <=> v202(VarCurr,bitIndex21) ) ).

fof(addAssignment_12211,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex21)
    <=> v204(VarCurr,bitIndex21) ) ).

fof(addAssignment_12210,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex21)
    <=> v25523(VarCurr,bitIndex21) ) ).

fof(addAssignment_12209,axiom,
    ! [VarCurr] :
      ( v28323(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12208,axiom,
    ! [VarCurr] :
      ( v28321(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_518,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28302(VarNext)
       => ( v28291(VarNext)
        <=> v28291(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_513,axiom,
    ! [VarNext] :
      ( v28302(VarNext)
     => ( v28291(VarNext)
      <=> v28312(VarNext) ) ) ).

fof(addAssignment_12207,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28312(VarNext)
      <=> v28310(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_782,axiom,
    ! [VarCurr] :
      ( ~ v28313(VarCurr)
     => ( v28310(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_536,axiom,
    ! [VarCurr] :
      ( v28313(VarCurr)
     => ( v28310(VarCurr)
      <=> v28297(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4920,axiom,
    ! [VarCurr] :
      ( v28313(VarCurr)
    <=> ( v28314(VarCurr)
        & v28315(VarCurr) ) ) ).

fof(writeUnaryOperator_2686,axiom,
    ! [VarCurr] :
      ( ~ v28315(VarCurr)
    <=> v28295(VarCurr) ) ).

fof(writeUnaryOperator_2685,axiom,
    ! [VarCurr] :
      ( ~ v28314(VarCurr)
    <=> v28293(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4919,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28302(VarNext)
      <=> v28303(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4918,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28303(VarNext)
      <=> ( v28304(VarNext)
          & v28299(VarNext) ) ) ) ).

fof(writeUnaryOperator_2684,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28304(VarNext)
      <=> v28306(VarNext) ) ) ).

fof(addAssignment_12206,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28306(VarNext)
      <=> v28299(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1014,axiom,
    ( v28291(constB0)
  <=> $false ) ).

fof(addAssignment_12205,axiom,
    ! [VarCurr] :
      ( v28299(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12204,axiom,
    ! [VarCurr] :
      ( v28297(VarCurr)
    <=> v202(VarCurr,bitIndex22) ) ).

fof(addAssignment_12203,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex22)
    <=> v204(VarCurr,bitIndex22) ) ).

fof(addAssignment_12202,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex22)
    <=> v25523(VarCurr,bitIndex22) ) ).

fof(addAssignment_12201,axiom,
    ! [VarCurr] :
      ( v28295(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12200,axiom,
    ! [VarCurr] :
      ( v28293(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_517,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28274(VarNext)
       => ( v28263(VarNext)
        <=> v28263(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_512,axiom,
    ! [VarNext] :
      ( v28274(VarNext)
     => ( v28263(VarNext)
      <=> v28284(VarNext) ) ) ).

fof(addAssignment_12199,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28284(VarNext)
      <=> v28282(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_781,axiom,
    ! [VarCurr] :
      ( ~ v28285(VarCurr)
     => ( v28282(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_535,axiom,
    ! [VarCurr] :
      ( v28285(VarCurr)
     => ( v28282(VarCurr)
      <=> v28269(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4917,axiom,
    ! [VarCurr] :
      ( v28285(VarCurr)
    <=> ( v28286(VarCurr)
        & v28287(VarCurr) ) ) ).

fof(writeUnaryOperator_2683,axiom,
    ! [VarCurr] :
      ( ~ v28287(VarCurr)
    <=> v28267(VarCurr) ) ).

fof(writeUnaryOperator_2682,axiom,
    ! [VarCurr] :
      ( ~ v28286(VarCurr)
    <=> v28265(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4916,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28274(VarNext)
      <=> v28275(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4915,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28275(VarNext)
      <=> ( v28276(VarNext)
          & v28271(VarNext) ) ) ) ).

fof(writeUnaryOperator_2681,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28276(VarNext)
      <=> v28278(VarNext) ) ) ).

fof(addAssignment_12198,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28278(VarNext)
      <=> v28271(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1013,axiom,
    ( v28263(constB0)
  <=> $false ) ).

fof(addAssignment_12197,axiom,
    ! [VarCurr] :
      ( v28271(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12196,axiom,
    ! [VarCurr] :
      ( v28269(VarCurr)
    <=> v202(VarCurr,bitIndex23) ) ).

fof(addAssignment_12195,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex23)
    <=> v204(VarCurr,bitIndex23) ) ).

fof(addAssignment_12194,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex23)
    <=> v25523(VarCurr,bitIndex23) ) ).

fof(addAssignment_12193,axiom,
    ! [VarCurr] :
      ( v28267(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12192,axiom,
    ! [VarCurr] :
      ( v28265(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_516,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28246(VarNext)
       => ( v28235(VarNext)
        <=> v28235(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_511,axiom,
    ! [VarNext] :
      ( v28246(VarNext)
     => ( v28235(VarNext)
      <=> v28256(VarNext) ) ) ).

fof(addAssignment_12191,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28256(VarNext)
      <=> v28254(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_780,axiom,
    ! [VarCurr] :
      ( ~ v28257(VarCurr)
     => ( v28254(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_534,axiom,
    ! [VarCurr] :
      ( v28257(VarCurr)
     => ( v28254(VarCurr)
      <=> v28241(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4914,axiom,
    ! [VarCurr] :
      ( v28257(VarCurr)
    <=> ( v28258(VarCurr)
        & v28259(VarCurr) ) ) ).

fof(writeUnaryOperator_2680,axiom,
    ! [VarCurr] :
      ( ~ v28259(VarCurr)
    <=> v28239(VarCurr) ) ).

fof(writeUnaryOperator_2679,axiom,
    ! [VarCurr] :
      ( ~ v28258(VarCurr)
    <=> v28237(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4913,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28246(VarNext)
      <=> v28247(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4912,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28247(VarNext)
      <=> ( v28248(VarNext)
          & v28243(VarNext) ) ) ) ).

fof(writeUnaryOperator_2678,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28248(VarNext)
      <=> v28250(VarNext) ) ) ).

fof(addAssignment_12190,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28250(VarNext)
      <=> v28243(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1012,axiom,
    ( v28235(constB0)
  <=> $false ) ).

fof(addAssignment_12189,axiom,
    ! [VarCurr] :
      ( v28243(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12188,axiom,
    ! [VarCurr] :
      ( v28241(VarCurr)
    <=> v202(VarCurr,bitIndex24) ) ).

fof(addAssignment_12187,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex24)
    <=> v204(VarCurr,bitIndex24) ) ).

fof(addAssignment_12186,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex24)
    <=> v25523(VarCurr,bitIndex24) ) ).

fof(addAssignment_12185,axiom,
    ! [VarCurr] :
      ( v28239(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12184,axiom,
    ! [VarCurr] :
      ( v28237(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_515,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28218(VarNext)
       => ( v28207(VarNext)
        <=> v28207(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_510,axiom,
    ! [VarNext] :
      ( v28218(VarNext)
     => ( v28207(VarNext)
      <=> v28228(VarNext) ) ) ).

fof(addAssignment_12183,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28228(VarNext)
      <=> v28226(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_779,axiom,
    ! [VarCurr] :
      ( ~ v28229(VarCurr)
     => ( v28226(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_533,axiom,
    ! [VarCurr] :
      ( v28229(VarCurr)
     => ( v28226(VarCurr)
      <=> v28213(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4911,axiom,
    ! [VarCurr] :
      ( v28229(VarCurr)
    <=> ( v28230(VarCurr)
        & v28231(VarCurr) ) ) ).

fof(writeUnaryOperator_2677,axiom,
    ! [VarCurr] :
      ( ~ v28231(VarCurr)
    <=> v28211(VarCurr) ) ).

fof(writeUnaryOperator_2676,axiom,
    ! [VarCurr] :
      ( ~ v28230(VarCurr)
    <=> v28209(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4910,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28218(VarNext)
      <=> v28219(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4909,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28219(VarNext)
      <=> ( v28220(VarNext)
          & v28215(VarNext) ) ) ) ).

fof(writeUnaryOperator_2675,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28220(VarNext)
      <=> v28222(VarNext) ) ) ).

fof(addAssignment_12182,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28222(VarNext)
      <=> v28215(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1011,axiom,
    ( v28207(constB0)
  <=> $false ) ).

fof(addAssignment_12181,axiom,
    ! [VarCurr] :
      ( v28215(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12180,axiom,
    ! [VarCurr] :
      ( v28213(VarCurr)
    <=> v202(VarCurr,bitIndex25) ) ).

fof(addAssignment_12179,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex25)
    <=> v204(VarCurr,bitIndex25) ) ).

fof(addAssignment_12178,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex25)
    <=> v25523(VarCurr,bitIndex25) ) ).

fof(addAssignment_12177,axiom,
    ! [VarCurr] :
      ( v28211(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12176,axiom,
    ! [VarCurr] :
      ( v28209(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_514,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28190(VarNext)
       => ( v28179(VarNext)
        <=> v28179(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_509,axiom,
    ! [VarNext] :
      ( v28190(VarNext)
     => ( v28179(VarNext)
      <=> v28200(VarNext) ) ) ).

fof(addAssignment_12175,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28200(VarNext)
      <=> v28198(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_778,axiom,
    ! [VarCurr] :
      ( ~ v28201(VarCurr)
     => ( v28198(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_532,axiom,
    ! [VarCurr] :
      ( v28201(VarCurr)
     => ( v28198(VarCurr)
      <=> v28185(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4908,axiom,
    ! [VarCurr] :
      ( v28201(VarCurr)
    <=> ( v28202(VarCurr)
        & v28203(VarCurr) ) ) ).

fof(writeUnaryOperator_2674,axiom,
    ! [VarCurr] :
      ( ~ v28203(VarCurr)
    <=> v28183(VarCurr) ) ).

fof(writeUnaryOperator_2673,axiom,
    ! [VarCurr] :
      ( ~ v28202(VarCurr)
    <=> v28181(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4907,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28190(VarNext)
      <=> v28191(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4906,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28191(VarNext)
      <=> ( v28192(VarNext)
          & v28187(VarNext) ) ) ) ).

fof(writeUnaryOperator_2672,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28192(VarNext)
      <=> v28194(VarNext) ) ) ).

fof(addAssignment_12174,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28194(VarNext)
      <=> v28187(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1010,axiom,
    ( v28179(constB0)
  <=> $false ) ).

fof(addAssignment_12173,axiom,
    ! [VarCurr] :
      ( v28187(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12172,axiom,
    ! [VarCurr] :
      ( v28185(VarCurr)
    <=> v202(VarCurr,bitIndex26) ) ).

fof(addAssignment_12171,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex26)
    <=> v204(VarCurr,bitIndex26) ) ).

fof(addAssignment_12170,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex26)
    <=> v25523(VarCurr,bitIndex26) ) ).

fof(addAssignment_12169,axiom,
    ! [VarCurr] :
      ( v28183(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12168,axiom,
    ! [VarCurr] :
      ( v28181(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_513,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28162(VarNext)
       => ( v28151(VarNext)
        <=> v28151(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_508,axiom,
    ! [VarNext] :
      ( v28162(VarNext)
     => ( v28151(VarNext)
      <=> v28172(VarNext) ) ) ).

fof(addAssignment_12167,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28172(VarNext)
      <=> v28170(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_777,axiom,
    ! [VarCurr] :
      ( ~ v28173(VarCurr)
     => ( v28170(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_531,axiom,
    ! [VarCurr] :
      ( v28173(VarCurr)
     => ( v28170(VarCurr)
      <=> v28157(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4905,axiom,
    ! [VarCurr] :
      ( v28173(VarCurr)
    <=> ( v28174(VarCurr)
        & v28175(VarCurr) ) ) ).

fof(writeUnaryOperator_2671,axiom,
    ! [VarCurr] :
      ( ~ v28175(VarCurr)
    <=> v28155(VarCurr) ) ).

fof(writeUnaryOperator_2670,axiom,
    ! [VarCurr] :
      ( ~ v28174(VarCurr)
    <=> v28153(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4904,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28162(VarNext)
      <=> v28163(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4903,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28163(VarNext)
      <=> ( v28164(VarNext)
          & v28159(VarNext) ) ) ) ).

fof(writeUnaryOperator_2669,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28164(VarNext)
      <=> v28166(VarNext) ) ) ).

fof(addAssignment_12166,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28166(VarNext)
      <=> v28159(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1009,axiom,
    ( v28151(constB0)
  <=> $false ) ).

fof(addAssignment_12165,axiom,
    ! [VarCurr] :
      ( v28159(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12164,axiom,
    ! [VarCurr] :
      ( v28157(VarCurr)
    <=> v202(VarCurr,bitIndex27) ) ).

fof(addAssignment_12163,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex27)
    <=> v204(VarCurr,bitIndex27) ) ).

fof(addAssignment_12162,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex27)
    <=> v25523(VarCurr,bitIndex27) ) ).

fof(addAssignment_12161,axiom,
    ! [VarCurr] :
      ( v28155(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12160,axiom,
    ! [VarCurr] :
      ( v28153(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_512,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28134(VarNext)
       => ( v28123(VarNext)
        <=> v28123(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_507,axiom,
    ! [VarNext] :
      ( v28134(VarNext)
     => ( v28123(VarNext)
      <=> v28144(VarNext) ) ) ).

fof(addAssignment_12159,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28144(VarNext)
      <=> v28142(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_776,axiom,
    ! [VarCurr] :
      ( ~ v28145(VarCurr)
     => ( v28142(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_530,axiom,
    ! [VarCurr] :
      ( v28145(VarCurr)
     => ( v28142(VarCurr)
      <=> v28129(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4902,axiom,
    ! [VarCurr] :
      ( v28145(VarCurr)
    <=> ( v28146(VarCurr)
        & v28147(VarCurr) ) ) ).

fof(writeUnaryOperator_2668,axiom,
    ! [VarCurr] :
      ( ~ v28147(VarCurr)
    <=> v28127(VarCurr) ) ).

fof(writeUnaryOperator_2667,axiom,
    ! [VarCurr] :
      ( ~ v28146(VarCurr)
    <=> v28125(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4901,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28134(VarNext)
      <=> v28135(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4900,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28135(VarNext)
      <=> ( v28136(VarNext)
          & v28131(VarNext) ) ) ) ).

fof(writeUnaryOperator_2666,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28136(VarNext)
      <=> v28138(VarNext) ) ) ).

fof(addAssignment_12158,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28138(VarNext)
      <=> v28131(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1008,axiom,
    ( v28123(constB0)
  <=> $false ) ).

fof(addAssignment_12157,axiom,
    ! [VarCurr] :
      ( v28131(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12156,axiom,
    ! [VarCurr] :
      ( v28129(VarCurr)
    <=> v202(VarCurr,bitIndex28) ) ).

fof(addAssignment_12155,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex28)
    <=> v204(VarCurr,bitIndex28) ) ).

fof(addAssignment_12154,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex28)
    <=> v25523(VarCurr,bitIndex28) ) ).

fof(addAssignment_12153,axiom,
    ! [VarCurr] :
      ( v28127(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12152,axiom,
    ! [VarCurr] :
      ( v28125(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_511,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28106(VarNext)
       => ( v28095(VarNext)
        <=> v28095(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_506,axiom,
    ! [VarNext] :
      ( v28106(VarNext)
     => ( v28095(VarNext)
      <=> v28116(VarNext) ) ) ).

fof(addAssignment_12151,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28116(VarNext)
      <=> v28114(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_775,axiom,
    ! [VarCurr] :
      ( ~ v28117(VarCurr)
     => ( v28114(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_529,axiom,
    ! [VarCurr] :
      ( v28117(VarCurr)
     => ( v28114(VarCurr)
      <=> v28101(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4899,axiom,
    ! [VarCurr] :
      ( v28117(VarCurr)
    <=> ( v28118(VarCurr)
        & v28119(VarCurr) ) ) ).

fof(writeUnaryOperator_2665,axiom,
    ! [VarCurr] :
      ( ~ v28119(VarCurr)
    <=> v28099(VarCurr) ) ).

fof(writeUnaryOperator_2664,axiom,
    ! [VarCurr] :
      ( ~ v28118(VarCurr)
    <=> v28097(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4898,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28106(VarNext)
      <=> v28107(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4897,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28107(VarNext)
      <=> ( v28108(VarNext)
          & v28103(VarNext) ) ) ) ).

fof(writeUnaryOperator_2663,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28108(VarNext)
      <=> v28110(VarNext) ) ) ).

fof(addAssignment_12150,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28110(VarNext)
      <=> v28103(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1007,axiom,
    ( v28095(constB0)
  <=> $false ) ).

fof(addAssignment_12149,axiom,
    ! [VarCurr] :
      ( v28103(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12148,axiom,
    ! [VarCurr] :
      ( v28101(VarCurr)
    <=> v202(VarCurr,bitIndex29) ) ).

fof(addAssignment_12147,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex29)
    <=> v204(VarCurr,bitIndex29) ) ).

fof(addAssignment_12146,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex29)
    <=> v25523(VarCurr,bitIndex29) ) ).

fof(addAssignment_12145,axiom,
    ! [VarCurr] :
      ( v28099(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12144,axiom,
    ! [VarCurr] :
      ( v28097(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_510,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28078(VarNext)
       => ( v28067(VarNext)
        <=> v28067(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_505,axiom,
    ! [VarNext] :
      ( v28078(VarNext)
     => ( v28067(VarNext)
      <=> v28088(VarNext) ) ) ).

fof(addAssignment_12143,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28088(VarNext)
      <=> v28086(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_774,axiom,
    ! [VarCurr] :
      ( ~ v28089(VarCurr)
     => ( v28086(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_528,axiom,
    ! [VarCurr] :
      ( v28089(VarCurr)
     => ( v28086(VarCurr)
      <=> v28073(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4896,axiom,
    ! [VarCurr] :
      ( v28089(VarCurr)
    <=> ( v28090(VarCurr)
        & v28091(VarCurr) ) ) ).

fof(writeUnaryOperator_2662,axiom,
    ! [VarCurr] :
      ( ~ v28091(VarCurr)
    <=> v28071(VarCurr) ) ).

fof(writeUnaryOperator_2661,axiom,
    ! [VarCurr] :
      ( ~ v28090(VarCurr)
    <=> v28069(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4895,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28078(VarNext)
      <=> v28079(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4894,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28079(VarNext)
      <=> ( v28080(VarNext)
          & v28075(VarNext) ) ) ) ).

fof(writeUnaryOperator_2660,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28080(VarNext)
      <=> v28082(VarNext) ) ) ).

fof(addAssignment_12142,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28082(VarNext)
      <=> v28075(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1006,axiom,
    ( v28067(constB0)
  <=> $false ) ).

fof(addAssignment_12141,axiom,
    ! [VarCurr] :
      ( v28075(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12140,axiom,
    ! [VarCurr] :
      ( v28073(VarCurr)
    <=> v202(VarCurr,bitIndex31) ) ).

fof(addAssignment_12139,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex31)
    <=> v204(VarCurr,bitIndex31) ) ).

fof(addAssignment_12138,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex31)
    <=> v25523(VarCurr,bitIndex31) ) ).

fof(addAssignment_12137,axiom,
    ! [VarCurr] :
      ( v28071(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12136,axiom,
    ! [VarCurr] :
      ( v28069(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_509,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28050(VarNext)
       => ( v28039(VarNext)
        <=> v28039(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_504,axiom,
    ! [VarNext] :
      ( v28050(VarNext)
     => ( v28039(VarNext)
      <=> v28060(VarNext) ) ) ).

fof(addAssignment_12135,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28060(VarNext)
      <=> v28058(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_773,axiom,
    ! [VarCurr] :
      ( ~ v28061(VarCurr)
     => ( v28058(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_527,axiom,
    ! [VarCurr] :
      ( v28061(VarCurr)
     => ( v28058(VarCurr)
      <=> v28045(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4893,axiom,
    ! [VarCurr] :
      ( v28061(VarCurr)
    <=> ( v28062(VarCurr)
        & v28063(VarCurr) ) ) ).

fof(writeUnaryOperator_2659,axiom,
    ! [VarCurr] :
      ( ~ v28063(VarCurr)
    <=> v28043(VarCurr) ) ).

fof(writeUnaryOperator_2658,axiom,
    ! [VarCurr] :
      ( ~ v28062(VarCurr)
    <=> v28041(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4892,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28050(VarNext)
      <=> v28051(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4891,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28051(VarNext)
      <=> ( v28052(VarNext)
          & v28047(VarNext) ) ) ) ).

fof(writeUnaryOperator_2657,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28052(VarNext)
      <=> v28054(VarNext) ) ) ).

fof(addAssignment_12134,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28054(VarNext)
      <=> v28047(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1005,axiom,
    ( v28039(constB0)
  <=> $false ) ).

fof(addAssignment_12133,axiom,
    ! [VarCurr] :
      ( v28047(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12132,axiom,
    ! [VarCurr] :
      ( v28045(VarCurr)
    <=> v202(VarCurr,bitIndex32) ) ).

fof(addAssignment_12131,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex32)
    <=> v204(VarCurr,bitIndex32) ) ).

fof(addAssignment_12130,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex32)
    <=> v25523(VarCurr,bitIndex32) ) ).

fof(addAssignment_12129,axiom,
    ! [VarCurr] :
      ( v28043(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12128,axiom,
    ! [VarCurr] :
      ( v28041(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_508,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28022(VarNext)
       => ( v28011(VarNext)
        <=> v28011(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_503,axiom,
    ! [VarNext] :
      ( v28022(VarNext)
     => ( v28011(VarNext)
      <=> v28032(VarNext) ) ) ).

fof(addAssignment_12127,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28032(VarNext)
      <=> v28030(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_772,axiom,
    ! [VarCurr] :
      ( ~ v28033(VarCurr)
     => ( v28030(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_526,axiom,
    ! [VarCurr] :
      ( v28033(VarCurr)
     => ( v28030(VarCurr)
      <=> v28017(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4890,axiom,
    ! [VarCurr] :
      ( v28033(VarCurr)
    <=> ( v28034(VarCurr)
        & v28035(VarCurr) ) ) ).

fof(writeUnaryOperator_2656,axiom,
    ! [VarCurr] :
      ( ~ v28035(VarCurr)
    <=> v28015(VarCurr) ) ).

fof(writeUnaryOperator_2655,axiom,
    ! [VarCurr] :
      ( ~ v28034(VarCurr)
    <=> v28013(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4889,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28022(VarNext)
      <=> v28023(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4888,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28023(VarNext)
      <=> ( v28024(VarNext)
          & v28019(VarNext) ) ) ) ).

fof(writeUnaryOperator_2654,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v28024(VarNext)
      <=> v28026(VarNext) ) ) ).

fof(addAssignment_12126,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28026(VarNext)
      <=> v28019(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1004,axiom,
    ( v28011(constB0)
  <=> $false ) ).

fof(addAssignment_12125,axiom,
    ! [VarCurr] :
      ( v28019(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12124,axiom,
    ! [VarCurr] :
      ( v28017(VarCurr)
    <=> v202(VarCurr,bitIndex33) ) ).

fof(addAssignment_12123,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex33)
    <=> v204(VarCurr,bitIndex33) ) ).

fof(addAssignment_12122,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex33)
    <=> v25523(VarCurr,bitIndex33) ) ).

fof(addAssignment_12121,axiom,
    ! [VarCurr] :
      ( v28015(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12120,axiom,
    ! [VarCurr] :
      ( v28013(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_507,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27994(VarNext)
       => ( v27983(VarNext)
        <=> v27983(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_502,axiom,
    ! [VarNext] :
      ( v27994(VarNext)
     => ( v27983(VarNext)
      <=> v28004(VarNext) ) ) ).

fof(addAssignment_12119,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v28004(VarNext)
      <=> v28002(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_771,axiom,
    ! [VarCurr] :
      ( ~ v28005(VarCurr)
     => ( v28002(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_525,axiom,
    ! [VarCurr] :
      ( v28005(VarCurr)
     => ( v28002(VarCurr)
      <=> v27989(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4887,axiom,
    ! [VarCurr] :
      ( v28005(VarCurr)
    <=> ( v28006(VarCurr)
        & v28007(VarCurr) ) ) ).

fof(writeUnaryOperator_2653,axiom,
    ! [VarCurr] :
      ( ~ v28007(VarCurr)
    <=> v27987(VarCurr) ) ).

fof(writeUnaryOperator_2652,axiom,
    ! [VarCurr] :
      ( ~ v28006(VarCurr)
    <=> v27985(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4886,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27994(VarNext)
      <=> v27995(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4885,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27995(VarNext)
      <=> ( v27996(VarNext)
          & v27991(VarNext) ) ) ) ).

fof(writeUnaryOperator_2651,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27996(VarNext)
      <=> v27998(VarNext) ) ) ).

fof(addAssignment_12118,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27998(VarNext)
      <=> v27991(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1003,axiom,
    ( v27983(constB0)
  <=> $false ) ).

fof(addAssignment_12117,axiom,
    ! [VarCurr] :
      ( v27991(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12116,axiom,
    ! [VarCurr] :
      ( v27989(VarCurr)
    <=> v202(VarCurr,bitIndex34) ) ).

fof(addAssignment_12115,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex34)
    <=> v204(VarCurr,bitIndex34) ) ).

fof(addAssignment_12114,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex34)
    <=> v25523(VarCurr,bitIndex34) ) ).

fof(addAssignment_12113,axiom,
    ! [VarCurr] :
      ( v27987(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12112,axiom,
    ! [VarCurr] :
      ( v27985(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_506,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27966(VarNext)
       => ( v27955(VarNext)
        <=> v27955(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_501,axiom,
    ! [VarNext] :
      ( v27966(VarNext)
     => ( v27955(VarNext)
      <=> v27976(VarNext) ) ) ).

fof(addAssignment_12111,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27976(VarNext)
      <=> v27974(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_770,axiom,
    ! [VarCurr] :
      ( ~ v27977(VarCurr)
     => ( v27974(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_524,axiom,
    ! [VarCurr] :
      ( v27977(VarCurr)
     => ( v27974(VarCurr)
      <=> v27961(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4884,axiom,
    ! [VarCurr] :
      ( v27977(VarCurr)
    <=> ( v27978(VarCurr)
        & v27979(VarCurr) ) ) ).

fof(writeUnaryOperator_2650,axiom,
    ! [VarCurr] :
      ( ~ v27979(VarCurr)
    <=> v27959(VarCurr) ) ).

fof(writeUnaryOperator_2649,axiom,
    ! [VarCurr] :
      ( ~ v27978(VarCurr)
    <=> v27957(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4883,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27966(VarNext)
      <=> v27967(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4882,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27967(VarNext)
      <=> ( v27968(VarNext)
          & v27963(VarNext) ) ) ) ).

fof(writeUnaryOperator_2648,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27968(VarNext)
      <=> v27970(VarNext) ) ) ).

fof(addAssignment_12110,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27970(VarNext)
      <=> v27963(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1002,axiom,
    ( v27955(constB0)
  <=> $false ) ).

fof(addAssignment_12109,axiom,
    ! [VarCurr] :
      ( v27963(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12108,axiom,
    ! [VarCurr] :
      ( v27961(VarCurr)
    <=> v202(VarCurr,bitIndex35) ) ).

fof(addAssignment_12107,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex35)
    <=> v204(VarCurr,bitIndex35) ) ).

fof(addAssignment_12106,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex35)
    <=> v25523(VarCurr,bitIndex35) ) ).

fof(addAssignment_12105,axiom,
    ! [VarCurr] :
      ( v27959(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12104,axiom,
    ! [VarCurr] :
      ( v27957(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_505,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27938(VarNext)
       => ( v27927(VarNext)
        <=> v27927(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_500,axiom,
    ! [VarNext] :
      ( v27938(VarNext)
     => ( v27927(VarNext)
      <=> v27948(VarNext) ) ) ).

fof(addAssignment_12103,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27948(VarNext)
      <=> v27946(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_769,axiom,
    ! [VarCurr] :
      ( ~ v27949(VarCurr)
     => ( v27946(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_523,axiom,
    ! [VarCurr] :
      ( v27949(VarCurr)
     => ( v27946(VarCurr)
      <=> v27933(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4881,axiom,
    ! [VarCurr] :
      ( v27949(VarCurr)
    <=> ( v27950(VarCurr)
        & v27951(VarCurr) ) ) ).

fof(writeUnaryOperator_2647,axiom,
    ! [VarCurr] :
      ( ~ v27951(VarCurr)
    <=> v27931(VarCurr) ) ).

fof(writeUnaryOperator_2646,axiom,
    ! [VarCurr] :
      ( ~ v27950(VarCurr)
    <=> v27929(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4880,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27938(VarNext)
      <=> v27939(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4879,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27939(VarNext)
      <=> ( v27940(VarNext)
          & v27935(VarNext) ) ) ) ).

fof(writeUnaryOperator_2645,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27940(VarNext)
      <=> v27942(VarNext) ) ) ).

fof(addAssignment_12102,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27942(VarNext)
      <=> v27935(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1001,axiom,
    ( v27927(constB0)
  <=> $false ) ).

fof(addAssignment_12101,axiom,
    ! [VarCurr] :
      ( v27935(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12100,axiom,
    ! [VarCurr] :
      ( v27933(VarCurr)
    <=> v202(VarCurr,bitIndex36) ) ).

fof(addAssignment_12099,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex36)
    <=> v204(VarCurr,bitIndex36) ) ).

fof(addAssignment_12098,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex36)
    <=> v25523(VarCurr,bitIndex36) ) ).

fof(addAssignment_12097,axiom,
    ! [VarCurr] :
      ( v27931(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12096,axiom,
    ! [VarCurr] :
      ( v27929(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_504,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27910(VarNext)
       => ( v27899(VarNext)
        <=> v27899(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_499,axiom,
    ! [VarNext] :
      ( v27910(VarNext)
     => ( v27899(VarNext)
      <=> v27920(VarNext) ) ) ).

fof(addAssignment_12095,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27920(VarNext)
      <=> v27918(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_768,axiom,
    ! [VarCurr] :
      ( ~ v27921(VarCurr)
     => ( v27918(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_522,axiom,
    ! [VarCurr] :
      ( v27921(VarCurr)
     => ( v27918(VarCurr)
      <=> v27905(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4878,axiom,
    ! [VarCurr] :
      ( v27921(VarCurr)
    <=> ( v27922(VarCurr)
        & v27923(VarCurr) ) ) ).

fof(writeUnaryOperator_2644,axiom,
    ! [VarCurr] :
      ( ~ v27923(VarCurr)
    <=> v27903(VarCurr) ) ).

fof(writeUnaryOperator_2643,axiom,
    ! [VarCurr] :
      ( ~ v27922(VarCurr)
    <=> v27901(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4877,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27910(VarNext)
      <=> v27911(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4876,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27911(VarNext)
      <=> ( v27912(VarNext)
          & v27907(VarNext) ) ) ) ).

fof(writeUnaryOperator_2642,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27912(VarNext)
      <=> v27914(VarNext) ) ) ).

fof(addAssignment_12094,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27914(VarNext)
      <=> v27907(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_1000,axiom,
    ( v27899(constB0)
  <=> $false ) ).

fof(addAssignment_12093,axiom,
    ! [VarCurr] :
      ( v27907(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12092,axiom,
    ! [VarCurr] :
      ( v27905(VarCurr)
    <=> v202(VarCurr,bitIndex37) ) ).

fof(addAssignment_12091,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex37)
    <=> v204(VarCurr,bitIndex37) ) ).

fof(addAssignment_12090,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex37)
    <=> v25523(VarCurr,bitIndex37) ) ).

fof(addAssignment_12089,axiom,
    ! [VarCurr] :
      ( v27903(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12088,axiom,
    ! [VarCurr] :
      ( v27901(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_503,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27882(VarNext)
       => ( v27871(VarNext)
        <=> v27871(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_498,axiom,
    ! [VarNext] :
      ( v27882(VarNext)
     => ( v27871(VarNext)
      <=> v27892(VarNext) ) ) ).

fof(addAssignment_12087,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27892(VarNext)
      <=> v27890(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_767,axiom,
    ! [VarCurr] :
      ( ~ v27893(VarCurr)
     => ( v27890(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_521,axiom,
    ! [VarCurr] :
      ( v27893(VarCurr)
     => ( v27890(VarCurr)
      <=> v27877(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4875,axiom,
    ! [VarCurr] :
      ( v27893(VarCurr)
    <=> ( v27894(VarCurr)
        & v27895(VarCurr) ) ) ).

fof(writeUnaryOperator_2641,axiom,
    ! [VarCurr] :
      ( ~ v27895(VarCurr)
    <=> v27875(VarCurr) ) ).

fof(writeUnaryOperator_2640,axiom,
    ! [VarCurr] :
      ( ~ v27894(VarCurr)
    <=> v27873(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4874,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27882(VarNext)
      <=> v27883(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4873,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27883(VarNext)
      <=> ( v27884(VarNext)
          & v27879(VarNext) ) ) ) ).

fof(writeUnaryOperator_2639,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27884(VarNext)
      <=> v27886(VarNext) ) ) ).

fof(addAssignment_12086,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27886(VarNext)
      <=> v27879(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_999,axiom,
    ( v27871(constB0)
  <=> $false ) ).

fof(addAssignment_12085,axiom,
    ! [VarCurr] :
      ( v27879(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12084,axiom,
    ! [VarCurr] :
      ( v27877(VarCurr)
    <=> v202(VarCurr,bitIndex38) ) ).

fof(addAssignment_12083,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex38)
    <=> v204(VarCurr,bitIndex38) ) ).

fof(addAssignment_12082,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex38)
    <=> v25523(VarCurr,bitIndex38) ) ).

fof(addAssignment_12081,axiom,
    ! [VarCurr] :
      ( v27875(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12080,axiom,
    ! [VarCurr] :
      ( v27873(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_502,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27854(VarNext)
       => ( v27843(VarNext)
        <=> v27843(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_497,axiom,
    ! [VarNext] :
      ( v27854(VarNext)
     => ( v27843(VarNext)
      <=> v27864(VarNext) ) ) ).

fof(addAssignment_12079,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27864(VarNext)
      <=> v27862(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_766,axiom,
    ! [VarCurr] :
      ( ~ v27865(VarCurr)
     => ( v27862(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_520,axiom,
    ! [VarCurr] :
      ( v27865(VarCurr)
     => ( v27862(VarCurr)
      <=> v27849(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4872,axiom,
    ! [VarCurr] :
      ( v27865(VarCurr)
    <=> ( v27866(VarCurr)
        & v27867(VarCurr) ) ) ).

fof(writeUnaryOperator_2638,axiom,
    ! [VarCurr] :
      ( ~ v27867(VarCurr)
    <=> v27847(VarCurr) ) ).

fof(writeUnaryOperator_2637,axiom,
    ! [VarCurr] :
      ( ~ v27866(VarCurr)
    <=> v27845(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4871,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27854(VarNext)
      <=> v27855(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4870,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27855(VarNext)
      <=> ( v27856(VarNext)
          & v27851(VarNext) ) ) ) ).

fof(writeUnaryOperator_2636,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27856(VarNext)
      <=> v27858(VarNext) ) ) ).

fof(addAssignment_12078,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27858(VarNext)
      <=> v27851(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_998,axiom,
    ( v27843(constB0)
  <=> $false ) ).

fof(addAssignment_12077,axiom,
    ! [VarCurr] :
      ( v27851(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12076,axiom,
    ! [VarCurr] :
      ( v27849(VarCurr)
    <=> v202(VarCurr,bitIndex39) ) ).

fof(addAssignment_12075,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex39)
    <=> v204(VarCurr,bitIndex39) ) ).

fof(addAssignment_12074,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex39)
    <=> v25523(VarCurr,bitIndex39) ) ).

fof(addAssignment_12073,axiom,
    ! [VarCurr] :
      ( v27847(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12072,axiom,
    ! [VarCurr] :
      ( v27845(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_501,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27826(VarNext)
       => ( v27815(VarNext)
        <=> v27815(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_496,axiom,
    ! [VarNext] :
      ( v27826(VarNext)
     => ( v27815(VarNext)
      <=> v27836(VarNext) ) ) ).

fof(addAssignment_12071,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27836(VarNext)
      <=> v27834(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_765,axiom,
    ! [VarCurr] :
      ( ~ v27837(VarCurr)
     => ( v27834(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_519,axiom,
    ! [VarCurr] :
      ( v27837(VarCurr)
     => ( v27834(VarCurr)
      <=> v27821(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4869,axiom,
    ! [VarCurr] :
      ( v27837(VarCurr)
    <=> ( v27838(VarCurr)
        & v27839(VarCurr) ) ) ).

fof(writeUnaryOperator_2635,axiom,
    ! [VarCurr] :
      ( ~ v27839(VarCurr)
    <=> v27819(VarCurr) ) ).

fof(writeUnaryOperator_2634,axiom,
    ! [VarCurr] :
      ( ~ v27838(VarCurr)
    <=> v27817(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4868,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27826(VarNext)
      <=> v27827(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4867,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27827(VarNext)
      <=> ( v27828(VarNext)
          & v27823(VarNext) ) ) ) ).

fof(writeUnaryOperator_2633,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27828(VarNext)
      <=> v27830(VarNext) ) ) ).

fof(addAssignment_12070,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27830(VarNext)
      <=> v27823(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_997,axiom,
    ( v27815(constB0)
  <=> $false ) ).

fof(addAssignment_12069,axiom,
    ! [VarCurr] :
      ( v27823(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12068,axiom,
    ! [VarCurr] :
      ( v27821(VarCurr)
    <=> v202(VarCurr,bitIndex40) ) ).

fof(addAssignment_12067,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex40)
    <=> v204(VarCurr,bitIndex40) ) ).

fof(addAssignment_12066,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex40)
    <=> v25523(VarCurr,bitIndex40) ) ).

fof(addAssignment_12065,axiom,
    ! [VarCurr] :
      ( v27819(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12064,axiom,
    ! [VarCurr] :
      ( v27817(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_500,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27798(VarNext)
       => ( v27787(VarNext)
        <=> v27787(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_495,axiom,
    ! [VarNext] :
      ( v27798(VarNext)
     => ( v27787(VarNext)
      <=> v27808(VarNext) ) ) ).

fof(addAssignment_12063,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27808(VarNext)
      <=> v27806(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_764,axiom,
    ! [VarCurr] :
      ( ~ v27809(VarCurr)
     => ( v27806(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_518,axiom,
    ! [VarCurr] :
      ( v27809(VarCurr)
     => ( v27806(VarCurr)
      <=> v27793(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4866,axiom,
    ! [VarCurr] :
      ( v27809(VarCurr)
    <=> ( v27810(VarCurr)
        & v27811(VarCurr) ) ) ).

fof(writeUnaryOperator_2632,axiom,
    ! [VarCurr] :
      ( ~ v27811(VarCurr)
    <=> v27791(VarCurr) ) ).

fof(writeUnaryOperator_2631,axiom,
    ! [VarCurr] :
      ( ~ v27810(VarCurr)
    <=> v27789(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4865,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27798(VarNext)
      <=> v27799(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4864,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27799(VarNext)
      <=> ( v27800(VarNext)
          & v27795(VarNext) ) ) ) ).

fof(writeUnaryOperator_2630,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27800(VarNext)
      <=> v27802(VarNext) ) ) ).

fof(addAssignment_12062,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27802(VarNext)
      <=> v27795(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_996,axiom,
    ( v27787(constB0)
  <=> $false ) ).

fof(addAssignment_12061,axiom,
    ! [VarCurr] :
      ( v27795(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12060,axiom,
    ! [VarCurr] :
      ( v27793(VarCurr)
    <=> v202(VarCurr,bitIndex41) ) ).

fof(addAssignment_12059,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex41)
    <=> v204(VarCurr,bitIndex41) ) ).

fof(addAssignment_12058,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex41)
    <=> v25523(VarCurr,bitIndex41) ) ).

fof(addAssignment_12057,axiom,
    ! [VarCurr] :
      ( v27791(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12056,axiom,
    ! [VarCurr] :
      ( v27789(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_499,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27770(VarNext)
       => ( v27759(VarNext)
        <=> v27759(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_494,axiom,
    ! [VarNext] :
      ( v27770(VarNext)
     => ( v27759(VarNext)
      <=> v27780(VarNext) ) ) ).

fof(addAssignment_12055,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27780(VarNext)
      <=> v27778(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_763,axiom,
    ! [VarCurr] :
      ( ~ v27781(VarCurr)
     => ( v27778(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_517,axiom,
    ! [VarCurr] :
      ( v27781(VarCurr)
     => ( v27778(VarCurr)
      <=> v27765(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4863,axiom,
    ! [VarCurr] :
      ( v27781(VarCurr)
    <=> ( v27782(VarCurr)
        & v27783(VarCurr) ) ) ).

fof(writeUnaryOperator_2629,axiom,
    ! [VarCurr] :
      ( ~ v27783(VarCurr)
    <=> v27763(VarCurr) ) ).

fof(writeUnaryOperator_2628,axiom,
    ! [VarCurr] :
      ( ~ v27782(VarCurr)
    <=> v27761(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4862,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27770(VarNext)
      <=> v27771(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4861,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27771(VarNext)
      <=> ( v27772(VarNext)
          & v27767(VarNext) ) ) ) ).

fof(writeUnaryOperator_2627,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27772(VarNext)
      <=> v27774(VarNext) ) ) ).

fof(addAssignment_12054,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27774(VarNext)
      <=> v27767(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_995,axiom,
    ( v27759(constB0)
  <=> $false ) ).

fof(addAssignment_12053,axiom,
    ! [VarCurr] :
      ( v27767(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12052,axiom,
    ! [VarCurr] :
      ( v27765(VarCurr)
    <=> v202(VarCurr,bitIndex42) ) ).

fof(addAssignment_12051,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex42)
    <=> v204(VarCurr,bitIndex42) ) ).

fof(addAssignment_12050,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex42)
    <=> v25523(VarCurr,bitIndex42) ) ).

fof(addAssignment_12049,axiom,
    ! [VarCurr] :
      ( v27763(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12048,axiom,
    ! [VarCurr] :
      ( v27761(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_498,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27742(VarNext)
       => ( v27731(VarNext)
        <=> v27731(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_493,axiom,
    ! [VarNext] :
      ( v27742(VarNext)
     => ( v27731(VarNext)
      <=> v27752(VarNext) ) ) ).

fof(addAssignment_12047,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27752(VarNext)
      <=> v27750(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_762,axiom,
    ! [VarCurr] :
      ( ~ v27753(VarCurr)
     => ( v27750(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_516,axiom,
    ! [VarCurr] :
      ( v27753(VarCurr)
     => ( v27750(VarCurr)
      <=> v27737(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4860,axiom,
    ! [VarCurr] :
      ( v27753(VarCurr)
    <=> ( v27754(VarCurr)
        & v27755(VarCurr) ) ) ).

fof(writeUnaryOperator_2626,axiom,
    ! [VarCurr] :
      ( ~ v27755(VarCurr)
    <=> v27735(VarCurr) ) ).

fof(writeUnaryOperator_2625,axiom,
    ! [VarCurr] :
      ( ~ v27754(VarCurr)
    <=> v27733(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4859,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27742(VarNext)
      <=> v27743(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4858,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27743(VarNext)
      <=> ( v27744(VarNext)
          & v27739(VarNext) ) ) ) ).

fof(writeUnaryOperator_2624,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27744(VarNext)
      <=> v27746(VarNext) ) ) ).

fof(addAssignment_12046,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27746(VarNext)
      <=> v27739(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_994,axiom,
    ( v27731(constB0)
  <=> $false ) ).

fof(addAssignment_12045,axiom,
    ! [VarCurr] :
      ( v27739(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12044,axiom,
    ! [VarCurr] :
      ( v27737(VarCurr)
    <=> v202(VarCurr,bitIndex43) ) ).

fof(addAssignment_12043,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex43)
    <=> v204(VarCurr,bitIndex43) ) ).

fof(addAssignment_12042,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex43)
    <=> v25523(VarCurr,bitIndex43) ) ).

fof(addAssignment_12041,axiom,
    ! [VarCurr] :
      ( v27735(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12040,axiom,
    ! [VarCurr] :
      ( v27733(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_497,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27714(VarNext)
       => ( v27703(VarNext)
        <=> v27703(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_492,axiom,
    ! [VarNext] :
      ( v27714(VarNext)
     => ( v27703(VarNext)
      <=> v27724(VarNext) ) ) ).

fof(addAssignment_12039,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27724(VarNext)
      <=> v27722(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_761,axiom,
    ! [VarCurr] :
      ( ~ v27725(VarCurr)
     => ( v27722(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_515,axiom,
    ! [VarCurr] :
      ( v27725(VarCurr)
     => ( v27722(VarCurr)
      <=> v27709(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4857,axiom,
    ! [VarCurr] :
      ( v27725(VarCurr)
    <=> ( v27726(VarCurr)
        & v27727(VarCurr) ) ) ).

fof(writeUnaryOperator_2623,axiom,
    ! [VarCurr] :
      ( ~ v27727(VarCurr)
    <=> v27707(VarCurr) ) ).

fof(writeUnaryOperator_2622,axiom,
    ! [VarCurr] :
      ( ~ v27726(VarCurr)
    <=> v27705(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4856,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27714(VarNext)
      <=> v27715(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4855,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27715(VarNext)
      <=> ( v27716(VarNext)
          & v27711(VarNext) ) ) ) ).

fof(writeUnaryOperator_2621,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27716(VarNext)
      <=> v27718(VarNext) ) ) ).

fof(addAssignment_12038,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27718(VarNext)
      <=> v27711(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_993,axiom,
    ( v27703(constB0)
  <=> $false ) ).

fof(addAssignment_12037,axiom,
    ! [VarCurr] :
      ( v27711(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12036,axiom,
    ! [VarCurr] :
      ( v27709(VarCurr)
    <=> v202(VarCurr,bitIndex44) ) ).

fof(addAssignment_12035,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex44)
    <=> v204(VarCurr,bitIndex44) ) ).

fof(addAssignment_12034,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex44)
    <=> v25523(VarCurr,bitIndex44) ) ).

fof(addAssignment_12033,axiom,
    ! [VarCurr] :
      ( v27707(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12032,axiom,
    ! [VarCurr] :
      ( v27705(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_496,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27686(VarNext)
       => ( v27675(VarNext)
        <=> v27675(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_491,axiom,
    ! [VarNext] :
      ( v27686(VarNext)
     => ( v27675(VarNext)
      <=> v27696(VarNext) ) ) ).

fof(addAssignment_12031,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27696(VarNext)
      <=> v27694(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_760,axiom,
    ! [VarCurr] :
      ( ~ v27697(VarCurr)
     => ( v27694(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_514,axiom,
    ! [VarCurr] :
      ( v27697(VarCurr)
     => ( v27694(VarCurr)
      <=> v27681(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4854,axiom,
    ! [VarCurr] :
      ( v27697(VarCurr)
    <=> ( v27698(VarCurr)
        & v27699(VarCurr) ) ) ).

fof(writeUnaryOperator_2620,axiom,
    ! [VarCurr] :
      ( ~ v27699(VarCurr)
    <=> v27679(VarCurr) ) ).

fof(writeUnaryOperator_2619,axiom,
    ! [VarCurr] :
      ( ~ v27698(VarCurr)
    <=> v27677(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4853,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27686(VarNext)
      <=> v27687(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4852,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27687(VarNext)
      <=> ( v27688(VarNext)
          & v27683(VarNext) ) ) ) ).

fof(writeUnaryOperator_2618,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27688(VarNext)
      <=> v27690(VarNext) ) ) ).

fof(addAssignment_12030,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27690(VarNext)
      <=> v27683(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_992,axiom,
    ( v27675(constB0)
  <=> $false ) ).

fof(addAssignment_12029,axiom,
    ! [VarCurr] :
      ( v27683(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12028,axiom,
    ! [VarCurr] :
      ( v27681(VarCurr)
    <=> v202(VarCurr,bitIndex45) ) ).

fof(addAssignment_12027,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex45)
    <=> v204(VarCurr,bitIndex45) ) ).

fof(addAssignment_12026,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex45)
    <=> v25523(VarCurr,bitIndex45) ) ).

fof(addAssignment_12025,axiom,
    ! [VarCurr] :
      ( v27679(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12024,axiom,
    ! [VarCurr] :
      ( v27677(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_495,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27658(VarNext)
       => ( v27647(VarNext)
        <=> v27647(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_490,axiom,
    ! [VarNext] :
      ( v27658(VarNext)
     => ( v27647(VarNext)
      <=> v27668(VarNext) ) ) ).

fof(addAssignment_12023,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27668(VarNext)
      <=> v27666(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_759,axiom,
    ! [VarCurr] :
      ( ~ v27669(VarCurr)
     => ( v27666(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_513,axiom,
    ! [VarCurr] :
      ( v27669(VarCurr)
     => ( v27666(VarCurr)
      <=> v27653(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4851,axiom,
    ! [VarCurr] :
      ( v27669(VarCurr)
    <=> ( v27670(VarCurr)
        & v27671(VarCurr) ) ) ).

fof(writeUnaryOperator_2617,axiom,
    ! [VarCurr] :
      ( ~ v27671(VarCurr)
    <=> v27651(VarCurr) ) ).

fof(writeUnaryOperator_2616,axiom,
    ! [VarCurr] :
      ( ~ v27670(VarCurr)
    <=> v27649(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4850,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27658(VarNext)
      <=> v27659(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4849,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27659(VarNext)
      <=> ( v27660(VarNext)
          & v27655(VarNext) ) ) ) ).

fof(writeUnaryOperator_2615,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27660(VarNext)
      <=> v27662(VarNext) ) ) ).

fof(addAssignment_12022,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27662(VarNext)
      <=> v27655(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_991,axiom,
    ( v27647(constB0)
  <=> $false ) ).

fof(addAssignment_12021,axiom,
    ! [VarCurr] :
      ( v27655(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12020,axiom,
    ! [VarCurr] :
      ( v27653(VarCurr)
    <=> v202(VarCurr,bitIndex46) ) ).

fof(addAssignment_12019,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex46)
    <=> v204(VarCurr,bitIndex46) ) ).

fof(addAssignment_12018,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex46)
    <=> v25523(VarCurr,bitIndex46) ) ).

fof(addAssignment_12017,axiom,
    ! [VarCurr] :
      ( v27651(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12016,axiom,
    ! [VarCurr] :
      ( v27649(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_494,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27630(VarNext)
       => ( v27619(VarNext)
        <=> v27619(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_489,axiom,
    ! [VarNext] :
      ( v27630(VarNext)
     => ( v27619(VarNext)
      <=> v27640(VarNext) ) ) ).

fof(addAssignment_12015,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27640(VarNext)
      <=> v27638(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_758,axiom,
    ! [VarCurr] :
      ( ~ v27641(VarCurr)
     => ( v27638(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_512,axiom,
    ! [VarCurr] :
      ( v27641(VarCurr)
     => ( v27638(VarCurr)
      <=> v27625(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4848,axiom,
    ! [VarCurr] :
      ( v27641(VarCurr)
    <=> ( v27642(VarCurr)
        & v27643(VarCurr) ) ) ).

fof(writeUnaryOperator_2614,axiom,
    ! [VarCurr] :
      ( ~ v27643(VarCurr)
    <=> v27623(VarCurr) ) ).

fof(writeUnaryOperator_2613,axiom,
    ! [VarCurr] :
      ( ~ v27642(VarCurr)
    <=> v27621(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4847,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27630(VarNext)
      <=> v27631(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4846,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27631(VarNext)
      <=> ( v27632(VarNext)
          & v27627(VarNext) ) ) ) ).

fof(writeUnaryOperator_2612,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27632(VarNext)
      <=> v27634(VarNext) ) ) ).

fof(addAssignment_12014,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27634(VarNext)
      <=> v27627(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_990,axiom,
    ( v27619(constB0)
  <=> $false ) ).

fof(addAssignment_12013,axiom,
    ! [VarCurr] :
      ( v27627(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12012,axiom,
    ! [VarCurr] :
      ( v27625(VarCurr)
    <=> v202(VarCurr,bitIndex47) ) ).

fof(addAssignment_12011,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex47)
    <=> v204(VarCurr,bitIndex47) ) ).

fof(addAssignment_12010,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex47)
    <=> v25523(VarCurr,bitIndex47) ) ).

fof(addAssignment_12009,axiom,
    ! [VarCurr] :
      ( v27623(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_12008,axiom,
    ! [VarCurr] :
      ( v27621(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_493,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27602(VarNext)
       => ( v27334(VarNext)
        <=> v27334(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_488,axiom,
    ! [VarNext] :
      ( v27602(VarNext)
     => ( v27334(VarNext)
      <=> v27612(VarNext) ) ) ).

fof(addAssignment_12007,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27612(VarNext)
      <=> v27610(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_757,axiom,
    ! [VarCurr] :
      ( ~ v27613(VarCurr)
     => ( v27610(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_511,axiom,
    ! [VarCurr] :
      ( v27613(VarCurr)
     => ( v27610(VarCurr)
      <=> v27340(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4845,axiom,
    ! [VarCurr] :
      ( v27613(VarCurr)
    <=> ( v27614(VarCurr)
        & v27615(VarCurr) ) ) ).

fof(writeUnaryOperator_2611,axiom,
    ! [VarCurr] :
      ( ~ v27615(VarCurr)
    <=> v27338(VarCurr) ) ).

fof(writeUnaryOperator_2610,axiom,
    ! [VarCurr] :
      ( ~ v27614(VarCurr)
    <=> v27336(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4844,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27602(VarNext)
      <=> v27603(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4843,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27603(VarNext)
      <=> ( v27604(VarNext)
          & v27599(VarNext) ) ) ) ).

fof(writeUnaryOperator_2609,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27604(VarNext)
      <=> v27606(VarNext) ) ) ).

fof(addAssignment_12006,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27606(VarNext)
      <=> v27599(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_989,axiom,
    ( v27334(constB0)
  <=> $false ) ).

fof(addAssignment_12005,axiom,
    ! [VarCurr] :
      ( v27599(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_12004,axiom,
    ! [VarCurr] :
      ( v27340(VarCurr)
    <=> v202(VarCurr,bitIndex48) ) ).

fof(addAssignment_12003,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex48)
    <=> v204(VarCurr,bitIndex48) ) ).

fof(addAssignment_12002,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex48)
    <=> v25523(VarCurr,bitIndex48) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_550,axiom,
    ! [VarCurr] :
      ( ~ v26763(VarCurr,bitIndex0)
     => ( v212(VarCurr,bitIndex48)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_796,axiom,
    ! [VarCurr] :
      ( v26763(VarCurr,bitIndex0)
     => ( v212(VarCurr,bitIndex48)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4842,axiom,
    ! [VarCurr] :
      ( v26763(VarCurr,bitIndex0)
    <=> ( v27541(VarCurr)
        & v27596(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4841,axiom,
    ! [VarCurr] :
      ( v27596(VarCurr)
    <=> ( v27543(VarCurr)
        | v27561(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4840,axiom,
    ! [VarCurr] :
      ( v27541(VarCurr)
    <=> ( v27542(VarCurr)
        | v27560(VarCurr) ) ) ).

fof(writeUnaryOperator_2608,axiom,
    ! [VarCurr] :
      ( ~ v27560(VarCurr)
    <=> v27561(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4839,axiom,
    ! [VarCurr] :
      ( v27561(VarCurr)
    <=> ( v27562(VarCurr)
        & v27595(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4838,axiom,
    ! [VarCurr] :
      ( v27595(VarCurr)
    <=> ( v27564(VarCurr)
        | v27580(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4837,axiom,
    ! [VarCurr] :
      ( v27562(VarCurr)
    <=> ( v27563(VarCurr)
        | v27579(VarCurr) ) ) ).

fof(writeUnaryOperator_2607,axiom,
    ! [VarCurr] :
      ( ~ v27579(VarCurr)
    <=> v27580(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4836,axiom,
    ! [VarCurr] :
      ( v27580(VarCurr)
    <=> ( v27581(VarCurr)
        & v27594(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1262,axiom,
    ! [VarCurr] :
      ( v27594(VarCurr)
    <=> ( v27546(VarCurr,bitIndex7)
        | v27584(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4835,axiom,
    ! [VarCurr] :
      ( v27581(VarCurr)
    <=> ( v27582(VarCurr)
        | v27583(VarCurr) ) ) ).

fof(writeUnaryOperator_2606,axiom,
    ! [VarCurr] :
      ( ~ v27583(VarCurr)
    <=> v27584(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4834,axiom,
    ! [VarCurr] :
      ( v27584(VarCurr)
    <=> ( v27585(VarCurr)
        & v27593(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1261,axiom,
    ! [VarCurr] :
      ( v27593(VarCurr)
    <=> ( v27546(VarCurr,bitIndex6)
        | v27588(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4833,axiom,
    ! [VarCurr] :
      ( v27585(VarCurr)
    <=> ( v27586(VarCurr)
        | v27587(VarCurr) ) ) ).

fof(writeUnaryOperator_2605,axiom,
    ! [VarCurr] :
      ( ~ v27587(VarCurr)
    <=> v27588(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4832,axiom,
    ! [VarCurr] :
      ( v27588(VarCurr)
    <=> ( v27589(VarCurr)
        & v27592(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1260,axiom,
    ! [VarCurr] :
      ( v27592(VarCurr)
    <=> ( v27546(VarCurr,bitIndex4)
        | v27546(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4831,axiom,
    ! [VarCurr] :
      ( v27589(VarCurr)
    <=> ( v27590(VarCurr)
        | v27591(VarCurr) ) ) ).

fof(writeUnaryOperator_2604,axiom,
    ! [VarCurr] :
      ( ~ v27591(VarCurr)
    <=> v27546(VarCurr,bitIndex5) ) ).

fof(writeUnaryOperator_2603,axiom,
    ! [VarCurr] :
      ( ~ v27590(VarCurr)
    <=> v27546(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_2602,axiom,
    ! [VarCurr] :
      ( ~ v27586(VarCurr)
    <=> v27546(VarCurr,bitIndex6) ) ).

fof(writeUnaryOperator_2601,axiom,
    ! [VarCurr] :
      ( ~ v27582(VarCurr)
    <=> v27546(VarCurr,bitIndex7) ) ).

fof(writeUnaryOperator_2600,axiom,
    ! [VarCurr] :
      ( ~ v27563(VarCurr)
    <=> v27564(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4830,axiom,
    ! [VarCurr] :
      ( v27564(VarCurr)
    <=> ( v27565(VarCurr)
        & v27578(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1259,axiom,
    ! [VarCurr] :
      ( v27578(VarCurr)
    <=> ( v27546(VarCurr,bitIndex3)
        | v27568(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4829,axiom,
    ! [VarCurr] :
      ( v27565(VarCurr)
    <=> ( v27566(VarCurr)
        | v27567(VarCurr) ) ) ).

fof(writeUnaryOperator_2599,axiom,
    ! [VarCurr] :
      ( ~ v27567(VarCurr)
    <=> v27568(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4828,axiom,
    ! [VarCurr] :
      ( v27568(VarCurr)
    <=> ( v27569(VarCurr)
        & v27577(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1258,axiom,
    ! [VarCurr] :
      ( v27577(VarCurr)
    <=> ( v27546(VarCurr,bitIndex2)
        | v27572(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4827,axiom,
    ! [VarCurr] :
      ( v27569(VarCurr)
    <=> ( v27570(VarCurr)
        | v27571(VarCurr) ) ) ).

fof(writeUnaryOperator_2598,axiom,
    ! [VarCurr] :
      ( ~ v27571(VarCurr)
    <=> v27572(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4826,axiom,
    ! [VarCurr] :
      ( v27572(VarCurr)
    <=> ( v27573(VarCurr)
        & v27576(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1257,axiom,
    ! [VarCurr] :
      ( v27576(VarCurr)
    <=> ( v27546(VarCurr,bitIndex0)
        | v27546(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4825,axiom,
    ! [VarCurr] :
      ( v27573(VarCurr)
    <=> ( v27574(VarCurr)
        | v27575(VarCurr) ) ) ).

fof(writeUnaryOperator_2597,axiom,
    ! [VarCurr] :
      ( ~ v27575(VarCurr)
    <=> v27546(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_2596,axiom,
    ! [VarCurr] :
      ( ~ v27574(VarCurr)
    <=> v27546(VarCurr,bitIndex0) ) ).

fof(writeUnaryOperator_2595,axiom,
    ! [VarCurr] :
      ( ~ v27570(VarCurr)
    <=> v27546(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_2594,axiom,
    ! [VarCurr] :
      ( ~ v27566(VarCurr)
    <=> v27546(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_2593,axiom,
    ! [VarCurr] :
      ( ~ v27542(VarCurr)
    <=> v27543(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4824,axiom,
    ! [VarCurr] :
      ( v27543(VarCurr)
    <=> ( v27544(VarCurr)
        & v27559(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1256,axiom,
    ! [VarCurr] :
      ( v27559(VarCurr)
    <=> ( v27546(VarCurr,bitIndex11)
        | v27549(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4823,axiom,
    ! [VarCurr] :
      ( v27544(VarCurr)
    <=> ( v27545(VarCurr)
        | v27548(VarCurr) ) ) ).

fof(writeUnaryOperator_2592,axiom,
    ! [VarCurr] :
      ( ~ v27548(VarCurr)
    <=> v27549(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4822,axiom,
    ! [VarCurr] :
      ( v27549(VarCurr)
    <=> ( v27550(VarCurr)
        & v27558(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1255,axiom,
    ! [VarCurr] :
      ( v27558(VarCurr)
    <=> ( v27546(VarCurr,bitIndex10)
        | v27553(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4821,axiom,
    ! [VarCurr] :
      ( v27550(VarCurr)
    <=> ( v27551(VarCurr)
        | v27552(VarCurr) ) ) ).

fof(writeUnaryOperator_2591,axiom,
    ! [VarCurr] :
      ( ~ v27552(VarCurr)
    <=> v27553(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4820,axiom,
    ! [VarCurr] :
      ( v27553(VarCurr)
    <=> ( v27554(VarCurr)
        & v27557(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1254,axiom,
    ! [VarCurr] :
      ( v27557(VarCurr)
    <=> ( v27546(VarCurr,bitIndex8)
        | v27546(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4819,axiom,
    ! [VarCurr] :
      ( v27554(VarCurr)
    <=> ( v27555(VarCurr)
        | v27556(VarCurr) ) ) ).

fof(writeUnaryOperator_2590,axiom,
    ! [VarCurr] :
      ( ~ v27556(VarCurr)
    <=> v27546(VarCurr,bitIndex9) ) ).

fof(writeUnaryOperator_2589,axiom,
    ! [VarCurr] :
      ( ~ v27555(VarCurr)
    <=> v27546(VarCurr,bitIndex8) ) ).

fof(writeUnaryOperator_2588,axiom,
    ! [VarCurr] :
      ( ~ v27551(VarCurr)
    <=> v27546(VarCurr,bitIndex10) ) ).

fof(writeUnaryOperator_2587,axiom,
    ! [VarCurr] :
      ( ~ v27545(VarCurr)
    <=> v27546(VarCurr,bitIndex11) ) ).

fof(addAssignment_12001,axiom,
    ! [VarCurr] :
      ( v27546(VarCurr,bitIndex0)
    <=> v27547(VarCurr) ) ).

fof(addAssignment_12000,axiom,
    ! [VarCurr,B] :
      ( range_5_1(B)
     => ( v27546(VarCurr,B)
      <=> v212(VarCurr,B) ) ) ).

fof(addAssignment_11999,axiom,
    ! [VarCurr,B] :
      ( range_11_6(B)
     => ( v27546(VarCurr,B)
      <=> v212(VarCurr,B) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4818,axiom,
    ! [VarCurr] :
      ( v27547(VarCurr)
    <=> ( v212(VarCurr,bitIndex0)
      <~> v27534(VarCurr) ) ) ).

fof(addAssignment_11998,axiom,
    ! [VarCurr] :
      ( v27534(VarCurr)
    <=> v27536(VarCurr) ) ).

fof(addAssignment_11997,axiom,
    ! [VarCurr] :
      ( v27536(VarCurr)
    <=> v27538(VarCurr) ) ).

fof(addAssignment_11996,axiom,
    ! [VarCurr] :
      ( v212(VarCurr,bitIndex0)
    <=> v25522(VarCurr,bitIndex0) ) ).

fof(addAssignment_11995,axiom,
    ! [VarCurr] :
      ( v25515(VarCurr,bitIndex0)
    <=> v25517(VarCurr,bitIndex0) ) ).

fof(addAssignment_11994,axiom,
    ! [VarCurr] :
      ( v25517(VarCurr,bitIndex0)
    <=> v25519(VarCurr,bitIndex0) ) ).

fof(addAssignment_11993,axiom,
    ! [VarCurr] :
      ( v25519(VarCurr,bitIndex0)
    <=> v25521(VarCurr,bitIndex0) ) ).

fof(addAssignment_11992,axiom,
    ! [VarCurr] :
      ( v25521(VarCurr,bitIndex0)
    <=> v4847(VarCurr,bitIndex0) ) ).

fof(addAssignment_11991,axiom,
    ! [VarCurr] :
      ( v25236(VarCurr,bitIndex0)
    <=> v25238(VarCurr,bitIndex0) ) ).

fof(addAssignment_11990,axiom,
    ! [VarCurr] :
      ( v25238(VarCurr,bitIndex0)
    <=> v25240(VarCurr,bitIndex0) ) ).

fof(addAssignment_11989,axiom,
    ! [VarCurr] :
      ( v25240(VarCurr,bitIndex0)
    <=> v25242(VarCurr,bitIndex0) ) ).

fof(addAssignment_11988,axiom,
    ! [VarCurr] :
      ( v25242(VarCurr,bitIndex0)
    <=> v25504(VarCurr,bitIndex0) ) ).

fof(addAssignment_11987,axiom,
    ! [VarNext] :
      ( v25244(VarNext,bitIndex336)
    <=> v27526(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionShiftedRanges1_62,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27528(VarNext)
       => ( ( v27526(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex383) )
          & ( v27526(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex382) )
          & ( v27526(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex381) )
          & ( v27526(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex380) )
          & ( v27526(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex379) )
          & ( v27526(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex378) )
          & ( v27526(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex377) )
          & ( v27526(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex376) )
          & ( v27526(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex375) )
          & ( v27526(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex374) )
          & ( v27526(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex373) )
          & ( v27526(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex372) )
          & ( v27526(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex371) )
          & ( v27526(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex370) )
          & ( v27526(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex369) )
          & ( v27526(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex368) )
          & ( v27526(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex367) )
          & ( v27526(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex366) )
          & ( v27526(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex365) )
          & ( v27526(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex364) )
          & ( v27526(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex363) )
          & ( v27526(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex362) )
          & ( v27526(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex361) )
          & ( v27526(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex360) )
          & ( v27526(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex359) )
          & ( v27526(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex358) )
          & ( v27526(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex357) )
          & ( v27526(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex356) )
          & ( v27526(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex355) )
          & ( v27526(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex354) )
          & ( v27526(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex353) )
          & ( v27526(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex352) )
          & ( v27526(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex351) )
          & ( v27526(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex350) )
          & ( v27526(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex349) )
          & ( v27526(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex348) )
          & ( v27526(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex347) )
          & ( v27526(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex346) )
          & ( v27526(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex345) )
          & ( v27526(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex344) )
          & ( v27526(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex343) )
          & ( v27526(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex342) )
          & ( v27526(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex341) )
          & ( v27526(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex340) )
          & ( v27526(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex339) )
          & ( v27526(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex338) )
          & ( v27526(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex337) )
          & ( v27526(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex336) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_487,axiom,
    ! [VarNext] :
      ( v27528(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27526(VarNext,B)
          <=> v25410(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4817,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27528(VarNext)
      <=> ( v27529(VarNext)
          & v25405(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4816,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27529(VarNext)
      <=> ( v27531(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2586,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27531(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11986,axiom,
    ! [VarNext] :
      ( v25244(VarNext,bitIndex288)
    <=> v27518(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionShiftedRanges1_61,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27520(VarNext)
       => ( ( v27518(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex335) )
          & ( v27518(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex334) )
          & ( v27518(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex333) )
          & ( v27518(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex332) )
          & ( v27518(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex331) )
          & ( v27518(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex330) )
          & ( v27518(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex329) )
          & ( v27518(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex328) )
          & ( v27518(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex327) )
          & ( v27518(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex326) )
          & ( v27518(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex325) )
          & ( v27518(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex324) )
          & ( v27518(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex323) )
          & ( v27518(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex322) )
          & ( v27518(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex321) )
          & ( v27518(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex320) )
          & ( v27518(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex319) )
          & ( v27518(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex318) )
          & ( v27518(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex317) )
          & ( v27518(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex316) )
          & ( v27518(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex315) )
          & ( v27518(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex314) )
          & ( v27518(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex313) )
          & ( v27518(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex312) )
          & ( v27518(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex311) )
          & ( v27518(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex310) )
          & ( v27518(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex309) )
          & ( v27518(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex308) )
          & ( v27518(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex307) )
          & ( v27518(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex306) )
          & ( v27518(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex305) )
          & ( v27518(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex304) )
          & ( v27518(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex303) )
          & ( v27518(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex302) )
          & ( v27518(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex301) )
          & ( v27518(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex300) )
          & ( v27518(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex299) )
          & ( v27518(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex298) )
          & ( v27518(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex297) )
          & ( v27518(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex296) )
          & ( v27518(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex295) )
          & ( v27518(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex294) )
          & ( v27518(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex293) )
          & ( v27518(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex292) )
          & ( v27518(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex291) )
          & ( v27518(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex290) )
          & ( v27518(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex289) )
          & ( v27518(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex288) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_486,axiom,
    ! [VarNext] :
      ( v27520(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27518(VarNext,B)
          <=> v25392(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4815,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27520(VarNext)
      <=> ( v27521(VarNext)
          & v25387(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4814,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27521(VarNext)
      <=> ( v27523(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2585,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27523(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11985,axiom,
    ! [VarNext] :
      ( v25244(VarNext,bitIndex240)
    <=> v27510(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionShiftedRanges1_60,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27512(VarNext)
       => ( ( v27510(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex287) )
          & ( v27510(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex286) )
          & ( v27510(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex285) )
          & ( v27510(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex284) )
          & ( v27510(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex283) )
          & ( v27510(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex282) )
          & ( v27510(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex281) )
          & ( v27510(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex280) )
          & ( v27510(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex279) )
          & ( v27510(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex278) )
          & ( v27510(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex277) )
          & ( v27510(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex276) )
          & ( v27510(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex275) )
          & ( v27510(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex274) )
          & ( v27510(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex273) )
          & ( v27510(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex272) )
          & ( v27510(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex271) )
          & ( v27510(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex270) )
          & ( v27510(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex269) )
          & ( v27510(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex268) )
          & ( v27510(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex267) )
          & ( v27510(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex266) )
          & ( v27510(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex265) )
          & ( v27510(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex264) )
          & ( v27510(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex263) )
          & ( v27510(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex262) )
          & ( v27510(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex261) )
          & ( v27510(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex260) )
          & ( v27510(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex259) )
          & ( v27510(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex258) )
          & ( v27510(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex257) )
          & ( v27510(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex256) )
          & ( v27510(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex255) )
          & ( v27510(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex254) )
          & ( v27510(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex253) )
          & ( v27510(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex252) )
          & ( v27510(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex251) )
          & ( v27510(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex250) )
          & ( v27510(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex249) )
          & ( v27510(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex248) )
          & ( v27510(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex247) )
          & ( v27510(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex246) )
          & ( v27510(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex245) )
          & ( v27510(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex244) )
          & ( v27510(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex243) )
          & ( v27510(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex242) )
          & ( v27510(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex241) )
          & ( v27510(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex240) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_485,axiom,
    ! [VarNext] :
      ( v27512(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27510(VarNext,B)
          <=> v25374(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4813,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27512(VarNext)
      <=> ( v27513(VarNext)
          & v25369(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4812,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27513(VarNext)
      <=> ( v27515(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2584,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27515(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11984,axiom,
    ! [VarNext] :
      ( v25244(VarNext,bitIndex192)
    <=> v27502(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionShiftedRanges1_59,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27504(VarNext)
       => ( ( v27502(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex239) )
          & ( v27502(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex238) )
          & ( v27502(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex237) )
          & ( v27502(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex236) )
          & ( v27502(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex235) )
          & ( v27502(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex234) )
          & ( v27502(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex233) )
          & ( v27502(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex232) )
          & ( v27502(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex231) )
          & ( v27502(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex230) )
          & ( v27502(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex229) )
          & ( v27502(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex228) )
          & ( v27502(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex227) )
          & ( v27502(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex226) )
          & ( v27502(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex225) )
          & ( v27502(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex224) )
          & ( v27502(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex223) )
          & ( v27502(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex222) )
          & ( v27502(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex221) )
          & ( v27502(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex220) )
          & ( v27502(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex219) )
          & ( v27502(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex218) )
          & ( v27502(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex217) )
          & ( v27502(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex216) )
          & ( v27502(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex215) )
          & ( v27502(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex214) )
          & ( v27502(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex213) )
          & ( v27502(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex212) )
          & ( v27502(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex211) )
          & ( v27502(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex210) )
          & ( v27502(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex209) )
          & ( v27502(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex208) )
          & ( v27502(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex207) )
          & ( v27502(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex206) )
          & ( v27502(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex205) )
          & ( v27502(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex204) )
          & ( v27502(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex203) )
          & ( v27502(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex202) )
          & ( v27502(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex201) )
          & ( v27502(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex200) )
          & ( v27502(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex199) )
          & ( v27502(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex198) )
          & ( v27502(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex197) )
          & ( v27502(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex196) )
          & ( v27502(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex195) )
          & ( v27502(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex194) )
          & ( v27502(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex193) )
          & ( v27502(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex192) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_484,axiom,
    ! [VarNext] :
      ( v27504(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27502(VarNext,B)
          <=> v25356(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4811,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27504(VarNext)
      <=> ( v27505(VarNext)
          & v25351(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4810,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27505(VarNext)
      <=> ( v27507(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2583,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27507(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11983,axiom,
    ! [VarNext] :
      ( v25244(VarNext,bitIndex144)
    <=> v27494(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionShiftedRanges1_58,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27496(VarNext)
       => ( ( v27494(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex191) )
          & ( v27494(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex190) )
          & ( v27494(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex189) )
          & ( v27494(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex188) )
          & ( v27494(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex187) )
          & ( v27494(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex186) )
          & ( v27494(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex185) )
          & ( v27494(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex184) )
          & ( v27494(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex183) )
          & ( v27494(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex182) )
          & ( v27494(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex181) )
          & ( v27494(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex180) )
          & ( v27494(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex179) )
          & ( v27494(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex178) )
          & ( v27494(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex177) )
          & ( v27494(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex176) )
          & ( v27494(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex175) )
          & ( v27494(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex174) )
          & ( v27494(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex173) )
          & ( v27494(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex172) )
          & ( v27494(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex171) )
          & ( v27494(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex170) )
          & ( v27494(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex169) )
          & ( v27494(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex168) )
          & ( v27494(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex167) )
          & ( v27494(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex166) )
          & ( v27494(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex165) )
          & ( v27494(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex164) )
          & ( v27494(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex163) )
          & ( v27494(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex162) )
          & ( v27494(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex161) )
          & ( v27494(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex160) )
          & ( v27494(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex159) )
          & ( v27494(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex158) )
          & ( v27494(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex157) )
          & ( v27494(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex156) )
          & ( v27494(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex155) )
          & ( v27494(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex154) )
          & ( v27494(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex153) )
          & ( v27494(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex152) )
          & ( v27494(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex151) )
          & ( v27494(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex150) )
          & ( v27494(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex149) )
          & ( v27494(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex148) )
          & ( v27494(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex147) )
          & ( v27494(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex146) )
          & ( v27494(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex145) )
          & ( v27494(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex144) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_483,axiom,
    ! [VarNext] :
      ( v27496(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27494(VarNext,B)
          <=> v25338(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4809,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27496(VarNext)
      <=> ( v27497(VarNext)
          & v25333(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4808,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27497(VarNext)
      <=> ( v27499(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2582,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27499(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11982,axiom,
    ! [VarNext] :
      ( v25244(VarNext,bitIndex96)
    <=> v27486(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionShiftedRanges1_57,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27488(VarNext)
       => ( ( v27486(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex143) )
          & ( v27486(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex142) )
          & ( v27486(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex141) )
          & ( v27486(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex140) )
          & ( v27486(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex139) )
          & ( v27486(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex138) )
          & ( v27486(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex137) )
          & ( v27486(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex136) )
          & ( v27486(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex135) )
          & ( v27486(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex134) )
          & ( v27486(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex133) )
          & ( v27486(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex132) )
          & ( v27486(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex131) )
          & ( v27486(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex130) )
          & ( v27486(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex129) )
          & ( v27486(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex128) )
          & ( v27486(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex127) )
          & ( v27486(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex126) )
          & ( v27486(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex125) )
          & ( v27486(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex124) )
          & ( v27486(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex123) )
          & ( v27486(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex122) )
          & ( v27486(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex121) )
          & ( v27486(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex120) )
          & ( v27486(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex119) )
          & ( v27486(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex118) )
          & ( v27486(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex117) )
          & ( v27486(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex116) )
          & ( v27486(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex115) )
          & ( v27486(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex114) )
          & ( v27486(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex113) )
          & ( v27486(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex112) )
          & ( v27486(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex111) )
          & ( v27486(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex110) )
          & ( v27486(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex109) )
          & ( v27486(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex108) )
          & ( v27486(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex107) )
          & ( v27486(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex106) )
          & ( v27486(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex105) )
          & ( v27486(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex104) )
          & ( v27486(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex103) )
          & ( v27486(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex102) )
          & ( v27486(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex101) )
          & ( v27486(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex100) )
          & ( v27486(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex99) )
          & ( v27486(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex98) )
          & ( v27486(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex97) )
          & ( v27486(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex96) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_482,axiom,
    ! [VarNext] :
      ( v27488(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27486(VarNext,B)
          <=> v25320(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4807,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27488(VarNext)
      <=> ( v27489(VarNext)
          & v25315(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4806,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27489(VarNext)
      <=> ( v27491(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2581,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27491(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11981,axiom,
    ! [VarNext] :
      ( v25244(VarNext,bitIndex48)
    <=> v27478(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionShiftedRanges1_56,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27480(VarNext)
       => ( ( v27478(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex95) )
          & ( v27478(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex94) )
          & ( v27478(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex93) )
          & ( v27478(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex92) )
          & ( v27478(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex91) )
          & ( v27478(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex90) )
          & ( v27478(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex89) )
          & ( v27478(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex88) )
          & ( v27478(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex87) )
          & ( v27478(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex86) )
          & ( v27478(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex85) )
          & ( v27478(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex84) )
          & ( v27478(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex83) )
          & ( v27478(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex82) )
          & ( v27478(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex81) )
          & ( v27478(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex80) )
          & ( v27478(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex79) )
          & ( v27478(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex78) )
          & ( v27478(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex77) )
          & ( v27478(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex76) )
          & ( v27478(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex75) )
          & ( v27478(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex74) )
          & ( v27478(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex73) )
          & ( v27478(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex72) )
          & ( v27478(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex71) )
          & ( v27478(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex70) )
          & ( v27478(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex69) )
          & ( v27478(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex68) )
          & ( v27478(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex67) )
          & ( v27478(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex66) )
          & ( v27478(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex65) )
          & ( v27478(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex64) )
          & ( v27478(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex63) )
          & ( v27478(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex62) )
          & ( v27478(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex61) )
          & ( v27478(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex60) )
          & ( v27478(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex59) )
          & ( v27478(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex58) )
          & ( v27478(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex57) )
          & ( v27478(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex56) )
          & ( v27478(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex55) )
          & ( v27478(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex54) )
          & ( v27478(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex53) )
          & ( v27478(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex52) )
          & ( v27478(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex51) )
          & ( v27478(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex50) )
          & ( v27478(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex49) )
          & ( v27478(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex48) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_481,axiom,
    ! [VarNext] :
      ( v27480(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27478(VarNext,B)
          <=> v25302(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4805,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27480(VarNext)
      <=> ( v27481(VarNext)
          & v25297(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4804,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27481(VarNext)
      <=> ( v27483(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2580,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27483(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11980,axiom,
    ! [VarCurr] :
      ( v25280(VarCurr,bitIndex0)
    <=> v25282(VarCurr,bitIndex0) ) ).

fof(addAssignment_11979,axiom,
    ! [VarCurr] :
      ( v25282(VarCurr,bitIndex0)
    <=> v25284(VarCurr,bitIndex0) ) ).

fof(addAssignment_11978,axiom,
    ! [VarCurr] :
      ( v25284(VarCurr,bitIndex0)
    <=> v25286(VarCurr,bitIndex0) ) ).

fof(addAssignment_11977,axiom,
    ! [VarCurr] :
      ( v25286(VarCurr,bitIndex0)
    <=> v24386(VarCurr,bitIndex64) ) ).

fof(addAssignment_11976,axiom,
    ! [VarNext] :
      ( v25244(VarNext,bitIndex0)
    <=> v27470(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionEqualRanges1_492,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27472(VarNext)
       => ! [B] :
            ( range_47_0(B)
           => ( v27470(VarNext,B)
            <=> v25244(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_480,axiom,
    ! [VarNext] :
      ( v27472(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27470(VarNext,B)
          <=> v25276(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4803,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27472(VarNext)
      <=> ( v27473(VarNext)
          & v25270(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4802,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27473(VarNext)
      <=> ( v27475(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2579,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27475(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11975,axiom,
    ! [VarCurr] :
      ( v25255(VarCurr,bitIndex0)
    <=> v25257(VarCurr,bitIndex0) ) ).

fof(addAssignment_11974,axiom,
    ! [VarCurr] :
      ( v25257(VarCurr,bitIndex0)
    <=> v25259(VarCurr,bitIndex0) ) ).

fof(addAssignment_11973,axiom,
    ! [VarCurr] :
      ( v25259(VarCurr,bitIndex0)
    <=> v24386(VarCurr,bitIndex0) ) ).

fof(addAssignment_11972,axiom,
    ! [VarCurr,B] :
      ( range_5_1(B)
     => ( v212(VarCurr,B)
      <=> v25522(VarCurr,B) ) ) ).

fof(addAssignment_11971,axiom,
    ! [VarCurr,B] :
      ( range_5_1(B)
     => ( v25515(VarCurr,B)
      <=> v25517(VarCurr,B) ) ) ).

fof(addAssignment_11970,axiom,
    ! [VarCurr,B] :
      ( range_5_1(B)
     => ( v25517(VarCurr,B)
      <=> v25519(VarCurr,B) ) ) ).

fof(addAssignment_11969,axiom,
    ! [VarCurr,B] :
      ( range_5_1(B)
     => ( v25519(VarCurr,B)
      <=> v25521(VarCurr,B) ) ) ).

fof(addAssignment_11968,axiom,
    ! [VarCurr,B] :
      ( range_5_3(B)
     => ( v25521(VarCurr,B)
      <=> v4847(VarCurr,B) ) ) ).

fof(addAssignment_11967,axiom,
    ! [VarCurr] :
      ( v25521(VarCurr,bitIndex2)
    <=> v4847(VarCurr,bitIndex2) ) ).

fof(addAssignment_11966,axiom,
    ! [VarCurr] :
      ( v25521(VarCurr,bitIndex1)
    <=> v4847(VarCurr,bitIndex1) ) ).

fof(addAssignment_11965,axiom,
    ! [VarCurr,B] :
      ( range_5_1(B)
     => ( v25236(VarCurr,B)
      <=> v25238(VarCurr,B) ) ) ).

fof(addAssignment_11964,axiom,
    ! [VarCurr,B] :
      ( range_5_1(B)
     => ( v25238(VarCurr,B)
      <=> v25240(VarCurr,B) ) ) ).

fof(addAssignment_11963,axiom,
    ! [VarCurr,B] :
      ( range_5_1(B)
     => ( v25240(VarCurr,B)
      <=> v25242(VarCurr,B) ) ) ).

fof(addAssignment_11962,axiom,
    ! [VarCurr,B] :
      ( range_5_1(B)
     => ( v25242(VarCurr,B)
      <=> v25504(VarCurr,B) ) ) ).

fof(addAssignment_11961,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex341)
      <=> v27462(VarNext,bitIndex5) )
      & ( v25244(VarNext,bitIndex340)
      <=> v27462(VarNext,bitIndex4) )
      & ( v25244(VarNext,bitIndex339)
      <=> v27462(VarNext,bitIndex3) )
      & ( v25244(VarNext,bitIndex338)
      <=> v27462(VarNext,bitIndex2) )
      & ( v25244(VarNext,bitIndex337)
      <=> v27462(VarNext,bitIndex1) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_55,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27464(VarNext)
       => ( ( v27462(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex383) )
          & ( v27462(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex382) )
          & ( v27462(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex381) )
          & ( v27462(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex380) )
          & ( v27462(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex379) )
          & ( v27462(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex378) )
          & ( v27462(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex377) )
          & ( v27462(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex376) )
          & ( v27462(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex375) )
          & ( v27462(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex374) )
          & ( v27462(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex373) )
          & ( v27462(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex372) )
          & ( v27462(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex371) )
          & ( v27462(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex370) )
          & ( v27462(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex369) )
          & ( v27462(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex368) )
          & ( v27462(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex367) )
          & ( v27462(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex366) )
          & ( v27462(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex365) )
          & ( v27462(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex364) )
          & ( v27462(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex363) )
          & ( v27462(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex362) )
          & ( v27462(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex361) )
          & ( v27462(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex360) )
          & ( v27462(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex359) )
          & ( v27462(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex358) )
          & ( v27462(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex357) )
          & ( v27462(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex356) )
          & ( v27462(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex355) )
          & ( v27462(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex354) )
          & ( v27462(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex353) )
          & ( v27462(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex352) )
          & ( v27462(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex351) )
          & ( v27462(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex350) )
          & ( v27462(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex349) )
          & ( v27462(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex348) )
          & ( v27462(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex347) )
          & ( v27462(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex346) )
          & ( v27462(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex345) )
          & ( v27462(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex344) )
          & ( v27462(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex343) )
          & ( v27462(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex342) )
          & ( v27462(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex341) )
          & ( v27462(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex340) )
          & ( v27462(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex339) )
          & ( v27462(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex338) )
          & ( v27462(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex337) )
          & ( v27462(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex336) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_479,axiom,
    ! [VarNext] :
      ( v27464(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27462(VarNext,B)
          <=> v25410(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4801,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27464(VarNext)
      <=> ( v27465(VarNext)
          & v25405(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4800,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27465(VarNext)
      <=> ( v27467(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2578,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27467(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11960,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex293)
      <=> v27454(VarNext,bitIndex5) )
      & ( v25244(VarNext,bitIndex292)
      <=> v27454(VarNext,bitIndex4) )
      & ( v25244(VarNext,bitIndex291)
      <=> v27454(VarNext,bitIndex3) )
      & ( v25244(VarNext,bitIndex290)
      <=> v27454(VarNext,bitIndex2) )
      & ( v25244(VarNext,bitIndex289)
      <=> v27454(VarNext,bitIndex1) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_54,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27456(VarNext)
       => ( ( v27454(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex335) )
          & ( v27454(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex334) )
          & ( v27454(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex333) )
          & ( v27454(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex332) )
          & ( v27454(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex331) )
          & ( v27454(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex330) )
          & ( v27454(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex329) )
          & ( v27454(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex328) )
          & ( v27454(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex327) )
          & ( v27454(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex326) )
          & ( v27454(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex325) )
          & ( v27454(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex324) )
          & ( v27454(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex323) )
          & ( v27454(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex322) )
          & ( v27454(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex321) )
          & ( v27454(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex320) )
          & ( v27454(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex319) )
          & ( v27454(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex318) )
          & ( v27454(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex317) )
          & ( v27454(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex316) )
          & ( v27454(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex315) )
          & ( v27454(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex314) )
          & ( v27454(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex313) )
          & ( v27454(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex312) )
          & ( v27454(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex311) )
          & ( v27454(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex310) )
          & ( v27454(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex309) )
          & ( v27454(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex308) )
          & ( v27454(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex307) )
          & ( v27454(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex306) )
          & ( v27454(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex305) )
          & ( v27454(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex304) )
          & ( v27454(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex303) )
          & ( v27454(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex302) )
          & ( v27454(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex301) )
          & ( v27454(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex300) )
          & ( v27454(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex299) )
          & ( v27454(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex298) )
          & ( v27454(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex297) )
          & ( v27454(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex296) )
          & ( v27454(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex295) )
          & ( v27454(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex294) )
          & ( v27454(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex293) )
          & ( v27454(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex292) )
          & ( v27454(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex291) )
          & ( v27454(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex290) )
          & ( v27454(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex289) )
          & ( v27454(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex288) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_478,axiom,
    ! [VarNext] :
      ( v27456(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27454(VarNext,B)
          <=> v25392(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4799,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27456(VarNext)
      <=> ( v27457(VarNext)
          & v25387(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4798,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27457(VarNext)
      <=> ( v27459(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2577,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27459(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11959,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex245)
      <=> v27446(VarNext,bitIndex5) )
      & ( v25244(VarNext,bitIndex244)
      <=> v27446(VarNext,bitIndex4) )
      & ( v25244(VarNext,bitIndex243)
      <=> v27446(VarNext,bitIndex3) )
      & ( v25244(VarNext,bitIndex242)
      <=> v27446(VarNext,bitIndex2) )
      & ( v25244(VarNext,bitIndex241)
      <=> v27446(VarNext,bitIndex1) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_53,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27448(VarNext)
       => ( ( v27446(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex287) )
          & ( v27446(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex286) )
          & ( v27446(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex285) )
          & ( v27446(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex284) )
          & ( v27446(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex283) )
          & ( v27446(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex282) )
          & ( v27446(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex281) )
          & ( v27446(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex280) )
          & ( v27446(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex279) )
          & ( v27446(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex278) )
          & ( v27446(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex277) )
          & ( v27446(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex276) )
          & ( v27446(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex275) )
          & ( v27446(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex274) )
          & ( v27446(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex273) )
          & ( v27446(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex272) )
          & ( v27446(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex271) )
          & ( v27446(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex270) )
          & ( v27446(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex269) )
          & ( v27446(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex268) )
          & ( v27446(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex267) )
          & ( v27446(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex266) )
          & ( v27446(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex265) )
          & ( v27446(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex264) )
          & ( v27446(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex263) )
          & ( v27446(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex262) )
          & ( v27446(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex261) )
          & ( v27446(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex260) )
          & ( v27446(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex259) )
          & ( v27446(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex258) )
          & ( v27446(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex257) )
          & ( v27446(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex256) )
          & ( v27446(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex255) )
          & ( v27446(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex254) )
          & ( v27446(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex253) )
          & ( v27446(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex252) )
          & ( v27446(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex251) )
          & ( v27446(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex250) )
          & ( v27446(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex249) )
          & ( v27446(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex248) )
          & ( v27446(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex247) )
          & ( v27446(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex246) )
          & ( v27446(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex245) )
          & ( v27446(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex244) )
          & ( v27446(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex243) )
          & ( v27446(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex242) )
          & ( v27446(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex241) )
          & ( v27446(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex240) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_477,axiom,
    ! [VarNext] :
      ( v27448(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27446(VarNext,B)
          <=> v25374(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4797,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27448(VarNext)
      <=> ( v27449(VarNext)
          & v25369(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4796,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27449(VarNext)
      <=> ( v27451(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2576,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27451(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11958,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex197)
      <=> v27438(VarNext,bitIndex5) )
      & ( v25244(VarNext,bitIndex196)
      <=> v27438(VarNext,bitIndex4) )
      & ( v25244(VarNext,bitIndex195)
      <=> v27438(VarNext,bitIndex3) )
      & ( v25244(VarNext,bitIndex194)
      <=> v27438(VarNext,bitIndex2) )
      & ( v25244(VarNext,bitIndex193)
      <=> v27438(VarNext,bitIndex1) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_52,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27440(VarNext)
       => ( ( v27438(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex239) )
          & ( v27438(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex238) )
          & ( v27438(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex237) )
          & ( v27438(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex236) )
          & ( v27438(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex235) )
          & ( v27438(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex234) )
          & ( v27438(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex233) )
          & ( v27438(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex232) )
          & ( v27438(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex231) )
          & ( v27438(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex230) )
          & ( v27438(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex229) )
          & ( v27438(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex228) )
          & ( v27438(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex227) )
          & ( v27438(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex226) )
          & ( v27438(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex225) )
          & ( v27438(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex224) )
          & ( v27438(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex223) )
          & ( v27438(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex222) )
          & ( v27438(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex221) )
          & ( v27438(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex220) )
          & ( v27438(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex219) )
          & ( v27438(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex218) )
          & ( v27438(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex217) )
          & ( v27438(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex216) )
          & ( v27438(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex215) )
          & ( v27438(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex214) )
          & ( v27438(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex213) )
          & ( v27438(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex212) )
          & ( v27438(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex211) )
          & ( v27438(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex210) )
          & ( v27438(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex209) )
          & ( v27438(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex208) )
          & ( v27438(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex207) )
          & ( v27438(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex206) )
          & ( v27438(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex205) )
          & ( v27438(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex204) )
          & ( v27438(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex203) )
          & ( v27438(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex202) )
          & ( v27438(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex201) )
          & ( v27438(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex200) )
          & ( v27438(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex199) )
          & ( v27438(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex198) )
          & ( v27438(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex197) )
          & ( v27438(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex196) )
          & ( v27438(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex195) )
          & ( v27438(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex194) )
          & ( v27438(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex193) )
          & ( v27438(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex192) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_476,axiom,
    ! [VarNext] :
      ( v27440(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27438(VarNext,B)
          <=> v25356(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4795,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27440(VarNext)
      <=> ( v27441(VarNext)
          & v25351(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4794,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27441(VarNext)
      <=> ( v27443(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2575,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27443(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11957,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex149)
      <=> v27430(VarNext,bitIndex5) )
      & ( v25244(VarNext,bitIndex148)
      <=> v27430(VarNext,bitIndex4) )
      & ( v25244(VarNext,bitIndex147)
      <=> v27430(VarNext,bitIndex3) )
      & ( v25244(VarNext,bitIndex146)
      <=> v27430(VarNext,bitIndex2) )
      & ( v25244(VarNext,bitIndex145)
      <=> v27430(VarNext,bitIndex1) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_51,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27432(VarNext)
       => ( ( v27430(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex191) )
          & ( v27430(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex190) )
          & ( v27430(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex189) )
          & ( v27430(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex188) )
          & ( v27430(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex187) )
          & ( v27430(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex186) )
          & ( v27430(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex185) )
          & ( v27430(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex184) )
          & ( v27430(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex183) )
          & ( v27430(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex182) )
          & ( v27430(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex181) )
          & ( v27430(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex180) )
          & ( v27430(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex179) )
          & ( v27430(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex178) )
          & ( v27430(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex177) )
          & ( v27430(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex176) )
          & ( v27430(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex175) )
          & ( v27430(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex174) )
          & ( v27430(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex173) )
          & ( v27430(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex172) )
          & ( v27430(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex171) )
          & ( v27430(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex170) )
          & ( v27430(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex169) )
          & ( v27430(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex168) )
          & ( v27430(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex167) )
          & ( v27430(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex166) )
          & ( v27430(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex165) )
          & ( v27430(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex164) )
          & ( v27430(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex163) )
          & ( v27430(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex162) )
          & ( v27430(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex161) )
          & ( v27430(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex160) )
          & ( v27430(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex159) )
          & ( v27430(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex158) )
          & ( v27430(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex157) )
          & ( v27430(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex156) )
          & ( v27430(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex155) )
          & ( v27430(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex154) )
          & ( v27430(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex153) )
          & ( v27430(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex152) )
          & ( v27430(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex151) )
          & ( v27430(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex150) )
          & ( v27430(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex149) )
          & ( v27430(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex148) )
          & ( v27430(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex147) )
          & ( v27430(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex146) )
          & ( v27430(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex145) )
          & ( v27430(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex144) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_475,axiom,
    ! [VarNext] :
      ( v27432(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27430(VarNext,B)
          <=> v25338(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4793,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27432(VarNext)
      <=> ( v27433(VarNext)
          & v25333(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4792,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27433(VarNext)
      <=> ( v27435(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2574,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27435(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11956,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex101)
      <=> v27422(VarNext,bitIndex5) )
      & ( v25244(VarNext,bitIndex100)
      <=> v27422(VarNext,bitIndex4) )
      & ( v25244(VarNext,bitIndex99)
      <=> v27422(VarNext,bitIndex3) )
      & ( v25244(VarNext,bitIndex98)
      <=> v27422(VarNext,bitIndex2) )
      & ( v25244(VarNext,bitIndex97)
      <=> v27422(VarNext,bitIndex1) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_50,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27424(VarNext)
       => ( ( v27422(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex143) )
          & ( v27422(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex142) )
          & ( v27422(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex141) )
          & ( v27422(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex140) )
          & ( v27422(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex139) )
          & ( v27422(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex138) )
          & ( v27422(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex137) )
          & ( v27422(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex136) )
          & ( v27422(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex135) )
          & ( v27422(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex134) )
          & ( v27422(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex133) )
          & ( v27422(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex132) )
          & ( v27422(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex131) )
          & ( v27422(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex130) )
          & ( v27422(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex129) )
          & ( v27422(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex128) )
          & ( v27422(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex127) )
          & ( v27422(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex126) )
          & ( v27422(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex125) )
          & ( v27422(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex124) )
          & ( v27422(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex123) )
          & ( v27422(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex122) )
          & ( v27422(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex121) )
          & ( v27422(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex120) )
          & ( v27422(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex119) )
          & ( v27422(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex118) )
          & ( v27422(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex117) )
          & ( v27422(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex116) )
          & ( v27422(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex115) )
          & ( v27422(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex114) )
          & ( v27422(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex113) )
          & ( v27422(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex112) )
          & ( v27422(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex111) )
          & ( v27422(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex110) )
          & ( v27422(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex109) )
          & ( v27422(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex108) )
          & ( v27422(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex107) )
          & ( v27422(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex106) )
          & ( v27422(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex105) )
          & ( v27422(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex104) )
          & ( v27422(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex103) )
          & ( v27422(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex102) )
          & ( v27422(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex101) )
          & ( v27422(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex100) )
          & ( v27422(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex99) )
          & ( v27422(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex98) )
          & ( v27422(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex97) )
          & ( v27422(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex96) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_474,axiom,
    ! [VarNext] :
      ( v27424(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27422(VarNext,B)
          <=> v25320(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4791,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27424(VarNext)
      <=> ( v27425(VarNext)
          & v25315(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4790,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27425(VarNext)
      <=> ( v27427(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2573,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27427(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11955,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex53)
      <=> v27414(VarNext,bitIndex5) )
      & ( v25244(VarNext,bitIndex52)
      <=> v27414(VarNext,bitIndex4) )
      & ( v25244(VarNext,bitIndex51)
      <=> v27414(VarNext,bitIndex3) )
      & ( v25244(VarNext,bitIndex50)
      <=> v27414(VarNext,bitIndex2) )
      & ( v25244(VarNext,bitIndex49)
      <=> v27414(VarNext,bitIndex1) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_49,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27416(VarNext)
       => ( ( v27414(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex95) )
          & ( v27414(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex94) )
          & ( v27414(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex93) )
          & ( v27414(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex92) )
          & ( v27414(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex91) )
          & ( v27414(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex90) )
          & ( v27414(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex89) )
          & ( v27414(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex88) )
          & ( v27414(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex87) )
          & ( v27414(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex86) )
          & ( v27414(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex85) )
          & ( v27414(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex84) )
          & ( v27414(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex83) )
          & ( v27414(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex82) )
          & ( v27414(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex81) )
          & ( v27414(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex80) )
          & ( v27414(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex79) )
          & ( v27414(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex78) )
          & ( v27414(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex77) )
          & ( v27414(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex76) )
          & ( v27414(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex75) )
          & ( v27414(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex74) )
          & ( v27414(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex73) )
          & ( v27414(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex72) )
          & ( v27414(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex71) )
          & ( v27414(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex70) )
          & ( v27414(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex69) )
          & ( v27414(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex68) )
          & ( v27414(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex67) )
          & ( v27414(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex66) )
          & ( v27414(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex65) )
          & ( v27414(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex64) )
          & ( v27414(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex63) )
          & ( v27414(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex62) )
          & ( v27414(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex61) )
          & ( v27414(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex60) )
          & ( v27414(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex59) )
          & ( v27414(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex58) )
          & ( v27414(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex57) )
          & ( v27414(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex56) )
          & ( v27414(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex55) )
          & ( v27414(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex54) )
          & ( v27414(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex53) )
          & ( v27414(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex52) )
          & ( v27414(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex51) )
          & ( v27414(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex50) )
          & ( v27414(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex49) )
          & ( v27414(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex48) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_473,axiom,
    ! [VarNext] :
      ( v27416(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27414(VarNext,B)
          <=> v25302(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4789,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27416(VarNext)
      <=> ( v27417(VarNext)
          & v25297(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4788,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27417(VarNext)
      <=> ( v27419(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2572,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27419(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11954,axiom,
    ! [VarCurr,B] :
      ( range_5_1(B)
     => ( v25280(VarCurr,B)
      <=> v25282(VarCurr,B) ) ) ).

fof(addAssignment_11953,axiom,
    ! [VarCurr,B] :
      ( range_5_1(B)
     => ( v25282(VarCurr,B)
      <=> v25284(VarCurr,B) ) ) ).

fof(addAssignment_11952,axiom,
    ! [VarCurr,B] :
      ( range_5_3(B)
     => ( v25284(VarCurr,B)
      <=> v25286(VarCurr,B) ) ) ).

fof(addAssignment_11951,axiom,
    ! [VarCurr] :
      ( v25284(VarCurr,bitIndex2)
    <=> v25286(VarCurr,bitIndex2) ) ).

fof(addAssignment_11950,axiom,
    ! [VarCurr] :
      ( v25284(VarCurr,bitIndex1)
    <=> v25286(VarCurr,bitIndex1) ) ).

fof(addAssignment_11949,axiom,
    ! [VarCurr] :
      ( ( v25286(VarCurr,bitIndex5)
      <=> v24386(VarCurr,bitIndex69) )
      & ( v25286(VarCurr,bitIndex4)
      <=> v24386(VarCurr,bitIndex68) )
      & ( v25286(VarCurr,bitIndex3)
      <=> v24386(VarCurr,bitIndex67) ) ) ).

fof(addAssignment_11948,axiom,
    ! [VarCurr] :
      ( v25286(VarCurr,bitIndex2)
    <=> v24386(VarCurr,bitIndex66) ) ).

fof(addAssignment_11947,axiom,
    ! [VarCurr] :
      ( v25286(VarCurr,bitIndex1)
    <=> v24386(VarCurr,bitIndex65) ) ).

fof(addAssignment_11946,axiom,
    ! [VarNext,B] :
      ( range_5_1(B)
     => ( v25244(VarNext,B)
      <=> v27406(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_491,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27408(VarNext)
       => ! [B] :
            ( range_47_0(B)
           => ( v27406(VarNext,B)
            <=> v25244(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_472,axiom,
    ! [VarNext] :
      ( v27408(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27406(VarNext,B)
          <=> v25276(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4787,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27408(VarNext)
      <=> ( v27409(VarNext)
          & v25270(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4786,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27409(VarNext)
      <=> ( v27411(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2571,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27411(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11945,axiom,
    ! [VarCurr,B] :
      ( range_5_1(B)
     => ( v25255(VarCurr,B)
      <=> v25257(VarCurr,B) ) ) ).

fof(addAssignment_11944,axiom,
    ! [VarCurr,B] :
      ( range_5_1(B)
     => ( v25257(VarCurr,B)
      <=> v25259(VarCurr,B) ) ) ).

fof(range_axiom_226,axiom,
    ! [B] :
      ( range_5_1(B)
    <=> ( $false
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B ) ) ).

fof(addAssignment_11943,axiom,
    ! [VarCurr,B] :
      ( range_5_3(B)
     => ( v25259(VarCurr,B)
      <=> v24386(VarCurr,B) ) ) ).

fof(addAssignment_11942,axiom,
    ! [VarCurr] :
      ( v25259(VarCurr,bitIndex2)
    <=> v24386(VarCurr,bitIndex2) ) ).

fof(addAssignment_11941,axiom,
    ! [VarCurr] :
      ( v25259(VarCurr,bitIndex1)
    <=> v24386(VarCurr,bitIndex1) ) ).

fof(addAssignment_11940,axiom,
    ! [VarCurr,B] :
      ( range_11_6(B)
     => ( v212(VarCurr,B)
      <=> v25522(VarCurr,B) ) ) ).

fof(addAssignment_11939,axiom,
    ! [VarCurr,B] :
      ( range_11_6(B)
     => ( v25515(VarCurr,B)
      <=> v25517(VarCurr,B) ) ) ).

fof(addAssignment_11938,axiom,
    ! [VarCurr,B] :
      ( range_11_6(B)
     => ( v25517(VarCurr,B)
      <=> v25519(VarCurr,B) ) ) ).

fof(addAssignment_11937,axiom,
    ! [VarCurr,B] :
      ( range_11_6(B)
     => ( v25519(VarCurr,B)
      <=> v25521(VarCurr,B) ) ) ).

fof(addAssignment_11936,axiom,
    ! [VarCurr] :
      ( ( v25521(VarCurr,bitIndex11)
      <=> v4847(VarCurr,bitIndex18) )
      & ( v25521(VarCurr,bitIndex10)
      <=> v4847(VarCurr,bitIndex17) )
      & ( v25521(VarCurr,bitIndex9)
      <=> v4847(VarCurr,bitIndex16) )
      & ( v25521(VarCurr,bitIndex8)
      <=> v4847(VarCurr,bitIndex15) )
      & ( v25521(VarCurr,bitIndex7)
      <=> v4847(VarCurr,bitIndex14) )
      & ( v25521(VarCurr,bitIndex6)
      <=> v4847(VarCurr,bitIndex13) ) ) ).

fof(addAssignment_11935,axiom,
    ! [VarCurr,B] :
      ( range_11_6(B)
     => ( v25236(VarCurr,B)
      <=> v25238(VarCurr,B) ) ) ).

fof(addAssignment_11934,axiom,
    ! [VarCurr,B] :
      ( range_11_6(B)
     => ( v25238(VarCurr,B)
      <=> v25240(VarCurr,B) ) ) ).

fof(addAssignment_11933,axiom,
    ! [VarCurr,B] :
      ( range_11_6(B)
     => ( v25240(VarCurr,B)
      <=> v25242(VarCurr,B) ) ) ).

fof(addAssignment_11932,axiom,
    ! [VarCurr,B] :
      ( range_11_6(B)
     => ( v25242(VarCurr,B)
      <=> v25504(VarCurr,B) ) ) ).

fof(addAssignment_11931,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex347)
      <=> v27398(VarNext,bitIndex11) )
      & ( v25244(VarNext,bitIndex346)
      <=> v27398(VarNext,bitIndex10) )
      & ( v25244(VarNext,bitIndex345)
      <=> v27398(VarNext,bitIndex9) )
      & ( v25244(VarNext,bitIndex344)
      <=> v27398(VarNext,bitIndex8) )
      & ( v25244(VarNext,bitIndex343)
      <=> v27398(VarNext,bitIndex7) )
      & ( v25244(VarNext,bitIndex342)
      <=> v27398(VarNext,bitIndex6) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_48,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27400(VarNext)
       => ( ( v27398(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex383) )
          & ( v27398(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex382) )
          & ( v27398(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex381) )
          & ( v27398(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex380) )
          & ( v27398(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex379) )
          & ( v27398(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex378) )
          & ( v27398(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex377) )
          & ( v27398(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex376) )
          & ( v27398(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex375) )
          & ( v27398(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex374) )
          & ( v27398(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex373) )
          & ( v27398(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex372) )
          & ( v27398(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex371) )
          & ( v27398(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex370) )
          & ( v27398(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex369) )
          & ( v27398(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex368) )
          & ( v27398(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex367) )
          & ( v27398(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex366) )
          & ( v27398(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex365) )
          & ( v27398(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex364) )
          & ( v27398(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex363) )
          & ( v27398(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex362) )
          & ( v27398(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex361) )
          & ( v27398(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex360) )
          & ( v27398(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex359) )
          & ( v27398(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex358) )
          & ( v27398(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex357) )
          & ( v27398(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex356) )
          & ( v27398(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex355) )
          & ( v27398(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex354) )
          & ( v27398(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex353) )
          & ( v27398(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex352) )
          & ( v27398(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex351) )
          & ( v27398(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex350) )
          & ( v27398(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex349) )
          & ( v27398(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex348) )
          & ( v27398(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex347) )
          & ( v27398(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex346) )
          & ( v27398(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex345) )
          & ( v27398(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex344) )
          & ( v27398(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex343) )
          & ( v27398(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex342) )
          & ( v27398(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex341) )
          & ( v27398(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex340) )
          & ( v27398(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex339) )
          & ( v27398(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex338) )
          & ( v27398(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex337) )
          & ( v27398(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex336) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_471,axiom,
    ! [VarNext] :
      ( v27400(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27398(VarNext,B)
          <=> v25410(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4785,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27400(VarNext)
      <=> ( v27401(VarNext)
          & v25405(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4784,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27401(VarNext)
      <=> ( v27403(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2570,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27403(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11930,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex299)
      <=> v27390(VarNext,bitIndex11) )
      & ( v25244(VarNext,bitIndex298)
      <=> v27390(VarNext,bitIndex10) )
      & ( v25244(VarNext,bitIndex297)
      <=> v27390(VarNext,bitIndex9) )
      & ( v25244(VarNext,bitIndex296)
      <=> v27390(VarNext,bitIndex8) )
      & ( v25244(VarNext,bitIndex295)
      <=> v27390(VarNext,bitIndex7) )
      & ( v25244(VarNext,bitIndex294)
      <=> v27390(VarNext,bitIndex6) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_47,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27392(VarNext)
       => ( ( v27390(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex335) )
          & ( v27390(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex334) )
          & ( v27390(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex333) )
          & ( v27390(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex332) )
          & ( v27390(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex331) )
          & ( v27390(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex330) )
          & ( v27390(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex329) )
          & ( v27390(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex328) )
          & ( v27390(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex327) )
          & ( v27390(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex326) )
          & ( v27390(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex325) )
          & ( v27390(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex324) )
          & ( v27390(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex323) )
          & ( v27390(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex322) )
          & ( v27390(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex321) )
          & ( v27390(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex320) )
          & ( v27390(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex319) )
          & ( v27390(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex318) )
          & ( v27390(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex317) )
          & ( v27390(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex316) )
          & ( v27390(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex315) )
          & ( v27390(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex314) )
          & ( v27390(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex313) )
          & ( v27390(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex312) )
          & ( v27390(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex311) )
          & ( v27390(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex310) )
          & ( v27390(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex309) )
          & ( v27390(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex308) )
          & ( v27390(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex307) )
          & ( v27390(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex306) )
          & ( v27390(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex305) )
          & ( v27390(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex304) )
          & ( v27390(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex303) )
          & ( v27390(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex302) )
          & ( v27390(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex301) )
          & ( v27390(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex300) )
          & ( v27390(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex299) )
          & ( v27390(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex298) )
          & ( v27390(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex297) )
          & ( v27390(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex296) )
          & ( v27390(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex295) )
          & ( v27390(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex294) )
          & ( v27390(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex293) )
          & ( v27390(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex292) )
          & ( v27390(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex291) )
          & ( v27390(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex290) )
          & ( v27390(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex289) )
          & ( v27390(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex288) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_470,axiom,
    ! [VarNext] :
      ( v27392(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27390(VarNext,B)
          <=> v25392(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4783,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27392(VarNext)
      <=> ( v27393(VarNext)
          & v25387(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4782,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27393(VarNext)
      <=> ( v27395(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2569,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27395(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11929,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex251)
      <=> v27382(VarNext,bitIndex11) )
      & ( v25244(VarNext,bitIndex250)
      <=> v27382(VarNext,bitIndex10) )
      & ( v25244(VarNext,bitIndex249)
      <=> v27382(VarNext,bitIndex9) )
      & ( v25244(VarNext,bitIndex248)
      <=> v27382(VarNext,bitIndex8) )
      & ( v25244(VarNext,bitIndex247)
      <=> v27382(VarNext,bitIndex7) )
      & ( v25244(VarNext,bitIndex246)
      <=> v27382(VarNext,bitIndex6) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_46,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27384(VarNext)
       => ( ( v27382(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex287) )
          & ( v27382(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex286) )
          & ( v27382(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex285) )
          & ( v27382(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex284) )
          & ( v27382(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex283) )
          & ( v27382(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex282) )
          & ( v27382(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex281) )
          & ( v27382(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex280) )
          & ( v27382(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex279) )
          & ( v27382(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex278) )
          & ( v27382(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex277) )
          & ( v27382(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex276) )
          & ( v27382(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex275) )
          & ( v27382(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex274) )
          & ( v27382(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex273) )
          & ( v27382(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex272) )
          & ( v27382(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex271) )
          & ( v27382(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex270) )
          & ( v27382(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex269) )
          & ( v27382(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex268) )
          & ( v27382(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex267) )
          & ( v27382(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex266) )
          & ( v27382(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex265) )
          & ( v27382(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex264) )
          & ( v27382(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex263) )
          & ( v27382(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex262) )
          & ( v27382(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex261) )
          & ( v27382(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex260) )
          & ( v27382(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex259) )
          & ( v27382(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex258) )
          & ( v27382(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex257) )
          & ( v27382(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex256) )
          & ( v27382(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex255) )
          & ( v27382(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex254) )
          & ( v27382(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex253) )
          & ( v27382(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex252) )
          & ( v27382(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex251) )
          & ( v27382(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex250) )
          & ( v27382(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex249) )
          & ( v27382(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex248) )
          & ( v27382(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex247) )
          & ( v27382(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex246) )
          & ( v27382(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex245) )
          & ( v27382(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex244) )
          & ( v27382(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex243) )
          & ( v27382(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex242) )
          & ( v27382(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex241) )
          & ( v27382(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex240) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_469,axiom,
    ! [VarNext] :
      ( v27384(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27382(VarNext,B)
          <=> v25374(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4781,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27384(VarNext)
      <=> ( v27385(VarNext)
          & v25369(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4780,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27385(VarNext)
      <=> ( v27387(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2568,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27387(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11928,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex203)
      <=> v27374(VarNext,bitIndex11) )
      & ( v25244(VarNext,bitIndex202)
      <=> v27374(VarNext,bitIndex10) )
      & ( v25244(VarNext,bitIndex201)
      <=> v27374(VarNext,bitIndex9) )
      & ( v25244(VarNext,bitIndex200)
      <=> v27374(VarNext,bitIndex8) )
      & ( v25244(VarNext,bitIndex199)
      <=> v27374(VarNext,bitIndex7) )
      & ( v25244(VarNext,bitIndex198)
      <=> v27374(VarNext,bitIndex6) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_45,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27376(VarNext)
       => ( ( v27374(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex239) )
          & ( v27374(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex238) )
          & ( v27374(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex237) )
          & ( v27374(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex236) )
          & ( v27374(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex235) )
          & ( v27374(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex234) )
          & ( v27374(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex233) )
          & ( v27374(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex232) )
          & ( v27374(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex231) )
          & ( v27374(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex230) )
          & ( v27374(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex229) )
          & ( v27374(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex228) )
          & ( v27374(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex227) )
          & ( v27374(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex226) )
          & ( v27374(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex225) )
          & ( v27374(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex224) )
          & ( v27374(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex223) )
          & ( v27374(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex222) )
          & ( v27374(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex221) )
          & ( v27374(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex220) )
          & ( v27374(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex219) )
          & ( v27374(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex218) )
          & ( v27374(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex217) )
          & ( v27374(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex216) )
          & ( v27374(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex215) )
          & ( v27374(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex214) )
          & ( v27374(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex213) )
          & ( v27374(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex212) )
          & ( v27374(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex211) )
          & ( v27374(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex210) )
          & ( v27374(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex209) )
          & ( v27374(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex208) )
          & ( v27374(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex207) )
          & ( v27374(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex206) )
          & ( v27374(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex205) )
          & ( v27374(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex204) )
          & ( v27374(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex203) )
          & ( v27374(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex202) )
          & ( v27374(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex201) )
          & ( v27374(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex200) )
          & ( v27374(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex199) )
          & ( v27374(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex198) )
          & ( v27374(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex197) )
          & ( v27374(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex196) )
          & ( v27374(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex195) )
          & ( v27374(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex194) )
          & ( v27374(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex193) )
          & ( v27374(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex192) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_468,axiom,
    ! [VarNext] :
      ( v27376(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27374(VarNext,B)
          <=> v25356(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4779,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27376(VarNext)
      <=> ( v27377(VarNext)
          & v25351(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4778,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27377(VarNext)
      <=> ( v27379(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2567,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27379(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11927,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex155)
      <=> v27366(VarNext,bitIndex11) )
      & ( v25244(VarNext,bitIndex154)
      <=> v27366(VarNext,bitIndex10) )
      & ( v25244(VarNext,bitIndex153)
      <=> v27366(VarNext,bitIndex9) )
      & ( v25244(VarNext,bitIndex152)
      <=> v27366(VarNext,bitIndex8) )
      & ( v25244(VarNext,bitIndex151)
      <=> v27366(VarNext,bitIndex7) )
      & ( v25244(VarNext,bitIndex150)
      <=> v27366(VarNext,bitIndex6) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_44,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27368(VarNext)
       => ( ( v27366(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex191) )
          & ( v27366(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex190) )
          & ( v27366(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex189) )
          & ( v27366(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex188) )
          & ( v27366(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex187) )
          & ( v27366(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex186) )
          & ( v27366(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex185) )
          & ( v27366(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex184) )
          & ( v27366(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex183) )
          & ( v27366(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex182) )
          & ( v27366(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex181) )
          & ( v27366(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex180) )
          & ( v27366(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex179) )
          & ( v27366(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex178) )
          & ( v27366(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex177) )
          & ( v27366(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex176) )
          & ( v27366(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex175) )
          & ( v27366(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex174) )
          & ( v27366(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex173) )
          & ( v27366(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex172) )
          & ( v27366(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex171) )
          & ( v27366(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex170) )
          & ( v27366(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex169) )
          & ( v27366(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex168) )
          & ( v27366(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex167) )
          & ( v27366(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex166) )
          & ( v27366(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex165) )
          & ( v27366(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex164) )
          & ( v27366(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex163) )
          & ( v27366(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex162) )
          & ( v27366(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex161) )
          & ( v27366(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex160) )
          & ( v27366(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex159) )
          & ( v27366(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex158) )
          & ( v27366(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex157) )
          & ( v27366(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex156) )
          & ( v27366(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex155) )
          & ( v27366(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex154) )
          & ( v27366(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex153) )
          & ( v27366(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex152) )
          & ( v27366(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex151) )
          & ( v27366(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex150) )
          & ( v27366(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex149) )
          & ( v27366(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex148) )
          & ( v27366(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex147) )
          & ( v27366(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex146) )
          & ( v27366(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex145) )
          & ( v27366(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex144) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_467,axiom,
    ! [VarNext] :
      ( v27368(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27366(VarNext,B)
          <=> v25338(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4777,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27368(VarNext)
      <=> ( v27369(VarNext)
          & v25333(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4776,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27369(VarNext)
      <=> ( v27371(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2566,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27371(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11926,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex107)
      <=> v27358(VarNext,bitIndex11) )
      & ( v25244(VarNext,bitIndex106)
      <=> v27358(VarNext,bitIndex10) )
      & ( v25244(VarNext,bitIndex105)
      <=> v27358(VarNext,bitIndex9) )
      & ( v25244(VarNext,bitIndex104)
      <=> v27358(VarNext,bitIndex8) )
      & ( v25244(VarNext,bitIndex103)
      <=> v27358(VarNext,bitIndex7) )
      & ( v25244(VarNext,bitIndex102)
      <=> v27358(VarNext,bitIndex6) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_43,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27360(VarNext)
       => ( ( v27358(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex143) )
          & ( v27358(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex142) )
          & ( v27358(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex141) )
          & ( v27358(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex140) )
          & ( v27358(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex139) )
          & ( v27358(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex138) )
          & ( v27358(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex137) )
          & ( v27358(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex136) )
          & ( v27358(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex135) )
          & ( v27358(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex134) )
          & ( v27358(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex133) )
          & ( v27358(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex132) )
          & ( v27358(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex131) )
          & ( v27358(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex130) )
          & ( v27358(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex129) )
          & ( v27358(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex128) )
          & ( v27358(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex127) )
          & ( v27358(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex126) )
          & ( v27358(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex125) )
          & ( v27358(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex124) )
          & ( v27358(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex123) )
          & ( v27358(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex122) )
          & ( v27358(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex121) )
          & ( v27358(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex120) )
          & ( v27358(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex119) )
          & ( v27358(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex118) )
          & ( v27358(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex117) )
          & ( v27358(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex116) )
          & ( v27358(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex115) )
          & ( v27358(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex114) )
          & ( v27358(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex113) )
          & ( v27358(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex112) )
          & ( v27358(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex111) )
          & ( v27358(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex110) )
          & ( v27358(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex109) )
          & ( v27358(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex108) )
          & ( v27358(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex107) )
          & ( v27358(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex106) )
          & ( v27358(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex105) )
          & ( v27358(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex104) )
          & ( v27358(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex103) )
          & ( v27358(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex102) )
          & ( v27358(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex101) )
          & ( v27358(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex100) )
          & ( v27358(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex99) )
          & ( v27358(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex98) )
          & ( v27358(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex97) )
          & ( v27358(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex96) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_466,axiom,
    ! [VarNext] :
      ( v27360(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27358(VarNext,B)
          <=> v25320(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4775,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27360(VarNext)
      <=> ( v27361(VarNext)
          & v25315(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4774,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27361(VarNext)
      <=> ( v27363(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2565,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27363(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11925,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex59)
      <=> v27350(VarNext,bitIndex11) )
      & ( v25244(VarNext,bitIndex58)
      <=> v27350(VarNext,bitIndex10) )
      & ( v25244(VarNext,bitIndex57)
      <=> v27350(VarNext,bitIndex9) )
      & ( v25244(VarNext,bitIndex56)
      <=> v27350(VarNext,bitIndex8) )
      & ( v25244(VarNext,bitIndex55)
      <=> v27350(VarNext,bitIndex7) )
      & ( v25244(VarNext,bitIndex54)
      <=> v27350(VarNext,bitIndex6) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_42,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27352(VarNext)
       => ( ( v27350(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex95) )
          & ( v27350(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex94) )
          & ( v27350(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex93) )
          & ( v27350(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex92) )
          & ( v27350(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex91) )
          & ( v27350(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex90) )
          & ( v27350(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex89) )
          & ( v27350(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex88) )
          & ( v27350(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex87) )
          & ( v27350(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex86) )
          & ( v27350(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex85) )
          & ( v27350(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex84) )
          & ( v27350(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex83) )
          & ( v27350(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex82) )
          & ( v27350(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex81) )
          & ( v27350(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex80) )
          & ( v27350(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex79) )
          & ( v27350(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex78) )
          & ( v27350(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex77) )
          & ( v27350(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex76) )
          & ( v27350(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex75) )
          & ( v27350(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex74) )
          & ( v27350(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex73) )
          & ( v27350(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex72) )
          & ( v27350(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex71) )
          & ( v27350(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex70) )
          & ( v27350(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex69) )
          & ( v27350(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex68) )
          & ( v27350(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex67) )
          & ( v27350(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex66) )
          & ( v27350(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex65) )
          & ( v27350(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex64) )
          & ( v27350(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex63) )
          & ( v27350(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex62) )
          & ( v27350(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex61) )
          & ( v27350(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex60) )
          & ( v27350(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex59) )
          & ( v27350(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex58) )
          & ( v27350(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex57) )
          & ( v27350(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex56) )
          & ( v27350(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex55) )
          & ( v27350(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex54) )
          & ( v27350(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex53) )
          & ( v27350(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex52) )
          & ( v27350(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex51) )
          & ( v27350(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex50) )
          & ( v27350(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex49) )
          & ( v27350(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex48) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_465,axiom,
    ! [VarNext] :
      ( v27352(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27350(VarNext,B)
          <=> v25302(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4773,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27352(VarNext)
      <=> ( v27353(VarNext)
          & v25297(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4772,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27353(VarNext)
      <=> ( v27355(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2564,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27355(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11924,axiom,
    ! [VarCurr,B] :
      ( range_11_6(B)
     => ( v25280(VarCurr,B)
      <=> v25282(VarCurr,B) ) ) ).

fof(addAssignment_11923,axiom,
    ! [VarCurr,B] :
      ( range_11_6(B)
     => ( v25282(VarCurr,B)
      <=> v25284(VarCurr,B) ) ) ).

fof(addAssignment_11922,axiom,
    ! [VarCurr] :
      ( ( v25284(VarCurr,bitIndex11)
      <=> v25286(VarCurr,bitIndex18) )
      & ( v25284(VarCurr,bitIndex10)
      <=> v25286(VarCurr,bitIndex17) )
      & ( v25284(VarCurr,bitIndex9)
      <=> v25286(VarCurr,bitIndex16) )
      & ( v25284(VarCurr,bitIndex8)
      <=> v25286(VarCurr,bitIndex15) )
      & ( v25284(VarCurr,bitIndex7)
      <=> v25286(VarCurr,bitIndex14) )
      & ( v25284(VarCurr,bitIndex6)
      <=> v25286(VarCurr,bitIndex13) ) ) ).

fof(addAssignment_11921,axiom,
    ! [VarCurr] :
      ( ( v25286(VarCurr,bitIndex18)
      <=> v24386(VarCurr,bitIndex82) )
      & ( v25286(VarCurr,bitIndex17)
      <=> v24386(VarCurr,bitIndex81) )
      & ( v25286(VarCurr,bitIndex16)
      <=> v24386(VarCurr,bitIndex80) )
      & ( v25286(VarCurr,bitIndex15)
      <=> v24386(VarCurr,bitIndex79) )
      & ( v25286(VarCurr,bitIndex14)
      <=> v24386(VarCurr,bitIndex78) )
      & ( v25286(VarCurr,bitIndex13)
      <=> v24386(VarCurr,bitIndex77) ) ) ).

fof(addAssignment_11920,axiom,
    ! [VarNext,B] :
      ( range_11_6(B)
     => ( v25244(VarNext,B)
      <=> v27342(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_490,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27344(VarNext)
       => ! [B] :
            ( range_47_0(B)
           => ( v27342(VarNext,B)
            <=> v25244(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_464,axiom,
    ! [VarNext] :
      ( v27344(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27342(VarNext,B)
          <=> v25276(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4771,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27344(VarNext)
      <=> ( v27345(VarNext)
          & v25270(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4770,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27345(VarNext)
      <=> ( v27347(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2563,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27347(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11919,axiom,
    ! [VarCurr,B] :
      ( range_11_6(B)
     => ( v25255(VarCurr,B)
      <=> v25257(VarCurr,B) ) ) ).

fof(addAssignment_11918,axiom,
    ! [VarCurr,B] :
      ( range_11_6(B)
     => ( v25257(VarCurr,B)
      <=> v25259(VarCurr,B) ) ) ).

fof(addAssignment_11917,axiom,
    ! [VarCurr] :
      ( ( v25259(VarCurr,bitIndex11)
      <=> v24386(VarCurr,bitIndex18) )
      & ( v25259(VarCurr,bitIndex10)
      <=> v24386(VarCurr,bitIndex17) )
      & ( v25259(VarCurr,bitIndex9)
      <=> v24386(VarCurr,bitIndex16) )
      & ( v25259(VarCurr,bitIndex8)
      <=> v24386(VarCurr,bitIndex15) )
      & ( v25259(VarCurr,bitIndex7)
      <=> v24386(VarCurr,bitIndex14) )
      & ( v25259(VarCurr,bitIndex6)
      <=> v24386(VarCurr,bitIndex13) ) ) ).

fof(addAssignment_11916,axiom,
    ! [VarCurr] :
      ( v27338(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_11915,axiom,
    ! [VarCurr] :
      ( v27336(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_489,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27317(VarNext)
       => ( v27185(VarNext)
        <=> v27185(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_463,axiom,
    ! [VarNext] :
      ( v27317(VarNext)
     => ( v27185(VarNext)
      <=> v27327(VarNext) ) ) ).

fof(addAssignment_11914,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27327(VarNext)
      <=> v27325(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_756,axiom,
    ! [VarCurr] :
      ( ~ v27328(VarCurr)
     => ( v27325(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_510,axiom,
    ! [VarCurr] :
      ( v27328(VarCurr)
     => ( v27325(VarCurr)
      <=> v27191(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4769,axiom,
    ! [VarCurr] :
      ( v27328(VarCurr)
    <=> ( v27329(VarCurr)
        & v27330(VarCurr) ) ) ).

fof(writeUnaryOperator_2562,axiom,
    ! [VarCurr] :
      ( ~ v27330(VarCurr)
    <=> v27189(VarCurr) ) ).

fof(writeUnaryOperator_2561,axiom,
    ! [VarCurr] :
      ( ~ v27329(VarCurr)
    <=> v27187(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4768,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27317(VarNext)
      <=> v27318(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4767,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27318(VarNext)
      <=> ( v27319(VarNext)
          & v27314(VarNext) ) ) ) ).

fof(writeUnaryOperator_2560,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27319(VarNext)
      <=> v27321(VarNext) ) ) ).

fof(addAssignment_11913,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27321(VarNext)
      <=> v27314(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_988,axiom,
    ( v27185(constB0)
  <=> $false ) ).

fof(addAssignment_11912,axiom,
    ! [VarCurr] :
      ( v27314(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_11911,axiom,
    ! [VarCurr] :
      ( v27191(VarCurr)
    <=> v202(VarCurr,bitIndex49) ) ).

fof(addAssignment_11910,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex49)
    <=> v204(VarCurr,bitIndex49) ) ).

fof(addAssignment_11909,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex49)
    <=> v25523(VarCurr,bitIndex49) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_549,axiom,
    ! [VarCurr] :
      ( ~ v26763(VarCurr,bitIndex1)
     => ( v212(VarCurr,bitIndex49)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_795,axiom,
    ! [VarCurr] :
      ( v26763(VarCurr,bitIndex1)
     => ( v212(VarCurr,bitIndex49)
      <=> $false ) ) ).

fof(writeBinaryOperatorShiftedRanges_1253,axiom,
    ! [VarCurr] :
      ( v26763(VarCurr,bitIndex1)
    <=> ( v27258(VarCurr)
        & v27311(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4766,axiom,
    ! [VarCurr] :
      ( v27311(VarCurr)
    <=> ( v27260(VarCurr)
        | v27276(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4765,axiom,
    ! [VarCurr] :
      ( v27258(VarCurr)
    <=> ( v27259(VarCurr)
        | v27275(VarCurr) ) ) ).

fof(writeUnaryOperator_2559,axiom,
    ! [VarCurr] :
      ( ~ v27275(VarCurr)
    <=> v27276(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4764,axiom,
    ! [VarCurr] :
      ( v27276(VarCurr)
    <=> ( v27277(VarCurr)
        & v27310(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4763,axiom,
    ! [VarCurr] :
      ( v27310(VarCurr)
    <=> ( v27279(VarCurr)
        | v27295(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4762,axiom,
    ! [VarCurr] :
      ( v27277(VarCurr)
    <=> ( v27278(VarCurr)
        | v27294(VarCurr) ) ) ).

fof(writeUnaryOperator_2558,axiom,
    ! [VarCurr] :
      ( ~ v27294(VarCurr)
    <=> v27295(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4761,axiom,
    ! [VarCurr] :
      ( v27295(VarCurr)
    <=> ( v27296(VarCurr)
        & v27309(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1252,axiom,
    ! [VarCurr] :
      ( v27309(VarCurr)
    <=> ( v212(VarCurr,bitIndex19)
        | v27299(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4760,axiom,
    ! [VarCurr] :
      ( v27296(VarCurr)
    <=> ( v27297(VarCurr)
        | v27298(VarCurr) ) ) ).

fof(writeUnaryOperator_2557,axiom,
    ! [VarCurr] :
      ( ~ v27298(VarCurr)
    <=> v27299(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4759,axiom,
    ! [VarCurr] :
      ( v27299(VarCurr)
    <=> ( v27300(VarCurr)
        & v27308(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1251,axiom,
    ! [VarCurr] :
      ( v27308(VarCurr)
    <=> ( v212(VarCurr,bitIndex18)
        | v27303(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4758,axiom,
    ! [VarCurr] :
      ( v27300(VarCurr)
    <=> ( v27301(VarCurr)
        | v27302(VarCurr) ) ) ).

fof(writeUnaryOperator_2556,axiom,
    ! [VarCurr] :
      ( ~ v27302(VarCurr)
    <=> v27303(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4757,axiom,
    ! [VarCurr] :
      ( v27303(VarCurr)
    <=> ( v27304(VarCurr)
        & v27307(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1250,axiom,
    ! [VarCurr] :
      ( v27307(VarCurr)
    <=> ( v212(VarCurr,bitIndex16)
        | v212(VarCurr,bitIndex17) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4756,axiom,
    ! [VarCurr] :
      ( v27304(VarCurr)
    <=> ( v27305(VarCurr)
        | v27306(VarCurr) ) ) ).

fof(writeUnaryOperator_2555,axiom,
    ! [VarCurr] :
      ( ~ v27306(VarCurr)
    <=> v212(VarCurr,bitIndex17) ) ).

fof(writeUnaryOperator_2554,axiom,
    ! [VarCurr] :
      ( ~ v27305(VarCurr)
    <=> v212(VarCurr,bitIndex16) ) ).

fof(writeUnaryOperator_2553,axiom,
    ! [VarCurr] :
      ( ~ v27301(VarCurr)
    <=> v212(VarCurr,bitIndex18) ) ).

fof(writeUnaryOperator_2552,axiom,
    ! [VarCurr] :
      ( ~ v27297(VarCurr)
    <=> v212(VarCurr,bitIndex19) ) ).

fof(writeUnaryOperator_2551,axiom,
    ! [VarCurr] :
      ( ~ v27278(VarCurr)
    <=> v27279(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4755,axiom,
    ! [VarCurr] :
      ( v27279(VarCurr)
    <=> ( v27280(VarCurr)
        & v27293(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1249,axiom,
    ! [VarCurr] :
      ( v27293(VarCurr)
    <=> ( v212(VarCurr,bitIndex15)
        | v27283(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4754,axiom,
    ! [VarCurr] :
      ( v27280(VarCurr)
    <=> ( v27281(VarCurr)
        | v27282(VarCurr) ) ) ).

fof(writeUnaryOperator_2550,axiom,
    ! [VarCurr] :
      ( ~ v27282(VarCurr)
    <=> v27283(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4753,axiom,
    ! [VarCurr] :
      ( v27283(VarCurr)
    <=> ( v27284(VarCurr)
        & v27292(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1248,axiom,
    ! [VarCurr] :
      ( v27292(VarCurr)
    <=> ( v212(VarCurr,bitIndex14)
        | v27287(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4752,axiom,
    ! [VarCurr] :
      ( v27284(VarCurr)
    <=> ( v27285(VarCurr)
        | v27286(VarCurr) ) ) ).

fof(writeUnaryOperator_2549,axiom,
    ! [VarCurr] :
      ( ~ v27286(VarCurr)
    <=> v27287(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4751,axiom,
    ! [VarCurr] :
      ( v27287(VarCurr)
    <=> ( v27288(VarCurr)
        & v27291(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1247,axiom,
    ! [VarCurr] :
      ( v27291(VarCurr)
    <=> ( v212(VarCurr,bitIndex12)
        | v212(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4750,axiom,
    ! [VarCurr] :
      ( v27288(VarCurr)
    <=> ( v27289(VarCurr)
        | v27290(VarCurr) ) ) ).

fof(writeUnaryOperator_2548,axiom,
    ! [VarCurr] :
      ( ~ v27290(VarCurr)
    <=> v212(VarCurr,bitIndex13) ) ).

fof(writeUnaryOperator_2547,axiom,
    ! [VarCurr] :
      ( ~ v27289(VarCurr)
    <=> v212(VarCurr,bitIndex12) ) ).

fof(writeUnaryOperator_2546,axiom,
    ! [VarCurr] :
      ( ~ v27285(VarCurr)
    <=> v212(VarCurr,bitIndex14) ) ).

fof(writeUnaryOperator_2545,axiom,
    ! [VarCurr] :
      ( ~ v27281(VarCurr)
    <=> v212(VarCurr,bitIndex15) ) ).

fof(writeUnaryOperator_2544,axiom,
    ! [VarCurr] :
      ( ~ v27259(VarCurr)
    <=> v27260(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4749,axiom,
    ! [VarCurr] :
      ( v27260(VarCurr)
    <=> ( v27261(VarCurr)
        & v27274(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1246,axiom,
    ! [VarCurr] :
      ( v27274(VarCurr)
    <=> ( v212(VarCurr,bitIndex23)
        | v27264(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4748,axiom,
    ! [VarCurr] :
      ( v27261(VarCurr)
    <=> ( v27262(VarCurr)
        | v27263(VarCurr) ) ) ).

fof(writeUnaryOperator_2543,axiom,
    ! [VarCurr] :
      ( ~ v27263(VarCurr)
    <=> v27264(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4747,axiom,
    ! [VarCurr] :
      ( v27264(VarCurr)
    <=> ( v27265(VarCurr)
        & v27273(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1245,axiom,
    ! [VarCurr] :
      ( v27273(VarCurr)
    <=> ( v212(VarCurr,bitIndex22)
        | v27268(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4746,axiom,
    ! [VarCurr] :
      ( v27265(VarCurr)
    <=> ( v27266(VarCurr)
        | v27267(VarCurr) ) ) ).

fof(writeUnaryOperator_2542,axiom,
    ! [VarCurr] :
      ( ~ v27267(VarCurr)
    <=> v27268(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4745,axiom,
    ! [VarCurr] :
      ( v27268(VarCurr)
    <=> ( v27269(VarCurr)
        & v27272(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1244,axiom,
    ! [VarCurr] :
      ( v27272(VarCurr)
    <=> ( v212(VarCurr,bitIndex20)
        | v212(VarCurr,bitIndex21) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4744,axiom,
    ! [VarCurr] :
      ( v27269(VarCurr)
    <=> ( v27270(VarCurr)
        | v27271(VarCurr) ) ) ).

fof(writeUnaryOperator_2541,axiom,
    ! [VarCurr] :
      ( ~ v27271(VarCurr)
    <=> v212(VarCurr,bitIndex21) ) ).

fof(writeUnaryOperator_2540,axiom,
    ! [VarCurr] :
      ( ~ v27270(VarCurr)
    <=> v212(VarCurr,bitIndex20) ) ).

fof(writeUnaryOperator_2539,axiom,
    ! [VarCurr] :
      ( ~ v27266(VarCurr)
    <=> v212(VarCurr,bitIndex22) ) ).

fof(writeUnaryOperator_2538,axiom,
    ! [VarCurr] :
      ( ~ v27262(VarCurr)
    <=> v212(VarCurr,bitIndex23) ) ).

fof(addAssignment_11908,axiom,
    ! [VarCurr,B] :
      ( range_23_12(B)
     => ( v212(VarCurr,B)
      <=> v25522(VarCurr,B) ) ) ).

fof(addAssignment_11907,axiom,
    ! [VarCurr,B] :
      ( range_23_12(B)
     => ( v25515(VarCurr,B)
      <=> v25517(VarCurr,B) ) ) ).

fof(addAssignment_11906,axiom,
    ! [VarCurr,B] :
      ( range_23_12(B)
     => ( v25517(VarCurr,B)
      <=> v25519(VarCurr,B) ) ) ).

fof(addAssignment_11905,axiom,
    ! [VarCurr,B] :
      ( range_23_12(B)
     => ( v25519(VarCurr,B)
      <=> v25521(VarCurr,B) ) ) ).

fof(addAssignment_11904,axiom,
    ! [VarCurr] :
      ( ( v25521(VarCurr,bitIndex23)
      <=> v4847(VarCurr,bitIndex30) )
      & ( v25521(VarCurr,bitIndex22)
      <=> v4847(VarCurr,bitIndex29) )
      & ( v25521(VarCurr,bitIndex21)
      <=> v4847(VarCurr,bitIndex28) )
      & ( v25521(VarCurr,bitIndex20)
      <=> v4847(VarCurr,bitIndex27) )
      & ( v25521(VarCurr,bitIndex19)
      <=> v4847(VarCurr,bitIndex26) )
      & ( v25521(VarCurr,bitIndex18)
      <=> v4847(VarCurr,bitIndex25) )
      & ( v25521(VarCurr,bitIndex17)
      <=> v4847(VarCurr,bitIndex24) )
      & ( v25521(VarCurr,bitIndex16)
      <=> v4847(VarCurr,bitIndex23) )
      & ( v25521(VarCurr,bitIndex15)
      <=> v4847(VarCurr,bitIndex22) )
      & ( v25521(VarCurr,bitIndex14)
      <=> v4847(VarCurr,bitIndex21) )
      & ( v25521(VarCurr,bitIndex13)
      <=> v4847(VarCurr,bitIndex20) )
      & ( v25521(VarCurr,bitIndex12)
      <=> v4847(VarCurr,bitIndex19) ) ) ).

fof(addAssignment_11903,axiom,
    ! [VarCurr,B] :
      ( range_23_12(B)
     => ( v25236(VarCurr,B)
      <=> v25238(VarCurr,B) ) ) ).

fof(addAssignment_11902,axiom,
    ! [VarCurr,B] :
      ( range_23_12(B)
     => ( v25238(VarCurr,B)
      <=> v25240(VarCurr,B) ) ) ).

fof(addAssignment_11901,axiom,
    ! [VarCurr,B] :
      ( range_23_12(B)
     => ( v25240(VarCurr,B)
      <=> v25242(VarCurr,B) ) ) ).

fof(addAssignment_11900,axiom,
    ! [VarCurr,B] :
      ( range_23_12(B)
     => ( v25242(VarCurr,B)
      <=> v25504(VarCurr,B) ) ) ).

fof(addAssignment_11899,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex359)
      <=> v27249(VarNext,bitIndex23) )
      & ( v25244(VarNext,bitIndex358)
      <=> v27249(VarNext,bitIndex22) )
      & ( v25244(VarNext,bitIndex357)
      <=> v27249(VarNext,bitIndex21) )
      & ( v25244(VarNext,bitIndex356)
      <=> v27249(VarNext,bitIndex20) )
      & ( v25244(VarNext,bitIndex355)
      <=> v27249(VarNext,bitIndex19) )
      & ( v25244(VarNext,bitIndex354)
      <=> v27249(VarNext,bitIndex18) )
      & ( v25244(VarNext,bitIndex353)
      <=> v27249(VarNext,bitIndex17) )
      & ( v25244(VarNext,bitIndex352)
      <=> v27249(VarNext,bitIndex16) )
      & ( v25244(VarNext,bitIndex351)
      <=> v27249(VarNext,bitIndex15) )
      & ( v25244(VarNext,bitIndex350)
      <=> v27249(VarNext,bitIndex14) )
      & ( v25244(VarNext,bitIndex349)
      <=> v27249(VarNext,bitIndex13) )
      & ( v25244(VarNext,bitIndex348)
      <=> v27249(VarNext,bitIndex12) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_41,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27251(VarNext)
       => ( ( v27249(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex383) )
          & ( v27249(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex382) )
          & ( v27249(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex381) )
          & ( v27249(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex380) )
          & ( v27249(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex379) )
          & ( v27249(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex378) )
          & ( v27249(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex377) )
          & ( v27249(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex376) )
          & ( v27249(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex375) )
          & ( v27249(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex374) )
          & ( v27249(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex373) )
          & ( v27249(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex372) )
          & ( v27249(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex371) )
          & ( v27249(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex370) )
          & ( v27249(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex369) )
          & ( v27249(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex368) )
          & ( v27249(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex367) )
          & ( v27249(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex366) )
          & ( v27249(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex365) )
          & ( v27249(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex364) )
          & ( v27249(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex363) )
          & ( v27249(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex362) )
          & ( v27249(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex361) )
          & ( v27249(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex360) )
          & ( v27249(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex359) )
          & ( v27249(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex358) )
          & ( v27249(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex357) )
          & ( v27249(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex356) )
          & ( v27249(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex355) )
          & ( v27249(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex354) )
          & ( v27249(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex353) )
          & ( v27249(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex352) )
          & ( v27249(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex351) )
          & ( v27249(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex350) )
          & ( v27249(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex349) )
          & ( v27249(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex348) )
          & ( v27249(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex347) )
          & ( v27249(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex346) )
          & ( v27249(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex345) )
          & ( v27249(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex344) )
          & ( v27249(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex343) )
          & ( v27249(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex342) )
          & ( v27249(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex341) )
          & ( v27249(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex340) )
          & ( v27249(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex339) )
          & ( v27249(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex338) )
          & ( v27249(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex337) )
          & ( v27249(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex336) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_462,axiom,
    ! [VarNext] :
      ( v27251(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27249(VarNext,B)
          <=> v25410(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4743,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27251(VarNext)
      <=> ( v27252(VarNext)
          & v25405(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4742,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27252(VarNext)
      <=> ( v27254(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2537,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27254(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11898,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex311)
      <=> v27241(VarNext,bitIndex23) )
      & ( v25244(VarNext,bitIndex310)
      <=> v27241(VarNext,bitIndex22) )
      & ( v25244(VarNext,bitIndex309)
      <=> v27241(VarNext,bitIndex21) )
      & ( v25244(VarNext,bitIndex308)
      <=> v27241(VarNext,bitIndex20) )
      & ( v25244(VarNext,bitIndex307)
      <=> v27241(VarNext,bitIndex19) )
      & ( v25244(VarNext,bitIndex306)
      <=> v27241(VarNext,bitIndex18) )
      & ( v25244(VarNext,bitIndex305)
      <=> v27241(VarNext,bitIndex17) )
      & ( v25244(VarNext,bitIndex304)
      <=> v27241(VarNext,bitIndex16) )
      & ( v25244(VarNext,bitIndex303)
      <=> v27241(VarNext,bitIndex15) )
      & ( v25244(VarNext,bitIndex302)
      <=> v27241(VarNext,bitIndex14) )
      & ( v25244(VarNext,bitIndex301)
      <=> v27241(VarNext,bitIndex13) )
      & ( v25244(VarNext,bitIndex300)
      <=> v27241(VarNext,bitIndex12) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_40,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27243(VarNext)
       => ( ( v27241(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex335) )
          & ( v27241(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex334) )
          & ( v27241(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex333) )
          & ( v27241(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex332) )
          & ( v27241(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex331) )
          & ( v27241(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex330) )
          & ( v27241(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex329) )
          & ( v27241(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex328) )
          & ( v27241(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex327) )
          & ( v27241(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex326) )
          & ( v27241(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex325) )
          & ( v27241(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex324) )
          & ( v27241(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex323) )
          & ( v27241(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex322) )
          & ( v27241(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex321) )
          & ( v27241(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex320) )
          & ( v27241(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex319) )
          & ( v27241(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex318) )
          & ( v27241(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex317) )
          & ( v27241(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex316) )
          & ( v27241(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex315) )
          & ( v27241(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex314) )
          & ( v27241(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex313) )
          & ( v27241(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex312) )
          & ( v27241(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex311) )
          & ( v27241(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex310) )
          & ( v27241(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex309) )
          & ( v27241(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex308) )
          & ( v27241(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex307) )
          & ( v27241(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex306) )
          & ( v27241(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex305) )
          & ( v27241(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex304) )
          & ( v27241(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex303) )
          & ( v27241(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex302) )
          & ( v27241(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex301) )
          & ( v27241(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex300) )
          & ( v27241(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex299) )
          & ( v27241(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex298) )
          & ( v27241(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex297) )
          & ( v27241(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex296) )
          & ( v27241(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex295) )
          & ( v27241(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex294) )
          & ( v27241(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex293) )
          & ( v27241(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex292) )
          & ( v27241(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex291) )
          & ( v27241(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex290) )
          & ( v27241(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex289) )
          & ( v27241(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex288) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_461,axiom,
    ! [VarNext] :
      ( v27243(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27241(VarNext,B)
          <=> v25392(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4741,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27243(VarNext)
      <=> ( v27244(VarNext)
          & v25387(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4740,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27244(VarNext)
      <=> ( v27246(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2536,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27246(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11897,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex263)
      <=> v27233(VarNext,bitIndex23) )
      & ( v25244(VarNext,bitIndex262)
      <=> v27233(VarNext,bitIndex22) )
      & ( v25244(VarNext,bitIndex261)
      <=> v27233(VarNext,bitIndex21) )
      & ( v25244(VarNext,bitIndex260)
      <=> v27233(VarNext,bitIndex20) )
      & ( v25244(VarNext,bitIndex259)
      <=> v27233(VarNext,bitIndex19) )
      & ( v25244(VarNext,bitIndex258)
      <=> v27233(VarNext,bitIndex18) )
      & ( v25244(VarNext,bitIndex257)
      <=> v27233(VarNext,bitIndex17) )
      & ( v25244(VarNext,bitIndex256)
      <=> v27233(VarNext,bitIndex16) )
      & ( v25244(VarNext,bitIndex255)
      <=> v27233(VarNext,bitIndex15) )
      & ( v25244(VarNext,bitIndex254)
      <=> v27233(VarNext,bitIndex14) )
      & ( v25244(VarNext,bitIndex253)
      <=> v27233(VarNext,bitIndex13) )
      & ( v25244(VarNext,bitIndex252)
      <=> v27233(VarNext,bitIndex12) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_39,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27235(VarNext)
       => ( ( v27233(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex287) )
          & ( v27233(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex286) )
          & ( v27233(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex285) )
          & ( v27233(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex284) )
          & ( v27233(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex283) )
          & ( v27233(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex282) )
          & ( v27233(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex281) )
          & ( v27233(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex280) )
          & ( v27233(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex279) )
          & ( v27233(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex278) )
          & ( v27233(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex277) )
          & ( v27233(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex276) )
          & ( v27233(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex275) )
          & ( v27233(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex274) )
          & ( v27233(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex273) )
          & ( v27233(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex272) )
          & ( v27233(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex271) )
          & ( v27233(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex270) )
          & ( v27233(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex269) )
          & ( v27233(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex268) )
          & ( v27233(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex267) )
          & ( v27233(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex266) )
          & ( v27233(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex265) )
          & ( v27233(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex264) )
          & ( v27233(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex263) )
          & ( v27233(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex262) )
          & ( v27233(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex261) )
          & ( v27233(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex260) )
          & ( v27233(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex259) )
          & ( v27233(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex258) )
          & ( v27233(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex257) )
          & ( v27233(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex256) )
          & ( v27233(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex255) )
          & ( v27233(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex254) )
          & ( v27233(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex253) )
          & ( v27233(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex252) )
          & ( v27233(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex251) )
          & ( v27233(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex250) )
          & ( v27233(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex249) )
          & ( v27233(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex248) )
          & ( v27233(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex247) )
          & ( v27233(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex246) )
          & ( v27233(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex245) )
          & ( v27233(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex244) )
          & ( v27233(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex243) )
          & ( v27233(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex242) )
          & ( v27233(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex241) )
          & ( v27233(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex240) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_460,axiom,
    ! [VarNext] :
      ( v27235(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27233(VarNext,B)
          <=> v25374(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4739,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27235(VarNext)
      <=> ( v27236(VarNext)
          & v25369(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4738,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27236(VarNext)
      <=> ( v27238(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2535,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27238(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11896,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex215)
      <=> v27225(VarNext,bitIndex23) )
      & ( v25244(VarNext,bitIndex214)
      <=> v27225(VarNext,bitIndex22) )
      & ( v25244(VarNext,bitIndex213)
      <=> v27225(VarNext,bitIndex21) )
      & ( v25244(VarNext,bitIndex212)
      <=> v27225(VarNext,bitIndex20) )
      & ( v25244(VarNext,bitIndex211)
      <=> v27225(VarNext,bitIndex19) )
      & ( v25244(VarNext,bitIndex210)
      <=> v27225(VarNext,bitIndex18) )
      & ( v25244(VarNext,bitIndex209)
      <=> v27225(VarNext,bitIndex17) )
      & ( v25244(VarNext,bitIndex208)
      <=> v27225(VarNext,bitIndex16) )
      & ( v25244(VarNext,bitIndex207)
      <=> v27225(VarNext,bitIndex15) )
      & ( v25244(VarNext,bitIndex206)
      <=> v27225(VarNext,bitIndex14) )
      & ( v25244(VarNext,bitIndex205)
      <=> v27225(VarNext,bitIndex13) )
      & ( v25244(VarNext,bitIndex204)
      <=> v27225(VarNext,bitIndex12) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_38,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27227(VarNext)
       => ( ( v27225(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex239) )
          & ( v27225(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex238) )
          & ( v27225(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex237) )
          & ( v27225(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex236) )
          & ( v27225(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex235) )
          & ( v27225(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex234) )
          & ( v27225(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex233) )
          & ( v27225(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex232) )
          & ( v27225(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex231) )
          & ( v27225(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex230) )
          & ( v27225(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex229) )
          & ( v27225(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex228) )
          & ( v27225(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex227) )
          & ( v27225(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex226) )
          & ( v27225(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex225) )
          & ( v27225(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex224) )
          & ( v27225(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex223) )
          & ( v27225(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex222) )
          & ( v27225(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex221) )
          & ( v27225(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex220) )
          & ( v27225(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex219) )
          & ( v27225(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex218) )
          & ( v27225(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex217) )
          & ( v27225(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex216) )
          & ( v27225(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex215) )
          & ( v27225(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex214) )
          & ( v27225(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex213) )
          & ( v27225(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex212) )
          & ( v27225(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex211) )
          & ( v27225(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex210) )
          & ( v27225(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex209) )
          & ( v27225(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex208) )
          & ( v27225(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex207) )
          & ( v27225(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex206) )
          & ( v27225(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex205) )
          & ( v27225(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex204) )
          & ( v27225(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex203) )
          & ( v27225(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex202) )
          & ( v27225(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex201) )
          & ( v27225(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex200) )
          & ( v27225(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex199) )
          & ( v27225(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex198) )
          & ( v27225(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex197) )
          & ( v27225(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex196) )
          & ( v27225(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex195) )
          & ( v27225(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex194) )
          & ( v27225(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex193) )
          & ( v27225(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex192) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_459,axiom,
    ! [VarNext] :
      ( v27227(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27225(VarNext,B)
          <=> v25356(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4737,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27227(VarNext)
      <=> ( v27228(VarNext)
          & v25351(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4736,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27228(VarNext)
      <=> ( v27230(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2534,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27230(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11895,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex167)
      <=> v27217(VarNext,bitIndex23) )
      & ( v25244(VarNext,bitIndex166)
      <=> v27217(VarNext,bitIndex22) )
      & ( v25244(VarNext,bitIndex165)
      <=> v27217(VarNext,bitIndex21) )
      & ( v25244(VarNext,bitIndex164)
      <=> v27217(VarNext,bitIndex20) )
      & ( v25244(VarNext,bitIndex163)
      <=> v27217(VarNext,bitIndex19) )
      & ( v25244(VarNext,bitIndex162)
      <=> v27217(VarNext,bitIndex18) )
      & ( v25244(VarNext,bitIndex161)
      <=> v27217(VarNext,bitIndex17) )
      & ( v25244(VarNext,bitIndex160)
      <=> v27217(VarNext,bitIndex16) )
      & ( v25244(VarNext,bitIndex159)
      <=> v27217(VarNext,bitIndex15) )
      & ( v25244(VarNext,bitIndex158)
      <=> v27217(VarNext,bitIndex14) )
      & ( v25244(VarNext,bitIndex157)
      <=> v27217(VarNext,bitIndex13) )
      & ( v25244(VarNext,bitIndex156)
      <=> v27217(VarNext,bitIndex12) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_37,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27219(VarNext)
       => ( ( v27217(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex191) )
          & ( v27217(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex190) )
          & ( v27217(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex189) )
          & ( v27217(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex188) )
          & ( v27217(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex187) )
          & ( v27217(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex186) )
          & ( v27217(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex185) )
          & ( v27217(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex184) )
          & ( v27217(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex183) )
          & ( v27217(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex182) )
          & ( v27217(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex181) )
          & ( v27217(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex180) )
          & ( v27217(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex179) )
          & ( v27217(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex178) )
          & ( v27217(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex177) )
          & ( v27217(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex176) )
          & ( v27217(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex175) )
          & ( v27217(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex174) )
          & ( v27217(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex173) )
          & ( v27217(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex172) )
          & ( v27217(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex171) )
          & ( v27217(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex170) )
          & ( v27217(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex169) )
          & ( v27217(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex168) )
          & ( v27217(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex167) )
          & ( v27217(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex166) )
          & ( v27217(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex165) )
          & ( v27217(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex164) )
          & ( v27217(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex163) )
          & ( v27217(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex162) )
          & ( v27217(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex161) )
          & ( v27217(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex160) )
          & ( v27217(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex159) )
          & ( v27217(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex158) )
          & ( v27217(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex157) )
          & ( v27217(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex156) )
          & ( v27217(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex155) )
          & ( v27217(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex154) )
          & ( v27217(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex153) )
          & ( v27217(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex152) )
          & ( v27217(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex151) )
          & ( v27217(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex150) )
          & ( v27217(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex149) )
          & ( v27217(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex148) )
          & ( v27217(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex147) )
          & ( v27217(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex146) )
          & ( v27217(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex145) )
          & ( v27217(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex144) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_458,axiom,
    ! [VarNext] :
      ( v27219(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27217(VarNext,B)
          <=> v25338(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4735,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27219(VarNext)
      <=> ( v27220(VarNext)
          & v25333(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4734,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27220(VarNext)
      <=> ( v27222(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2533,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27222(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11894,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex119)
      <=> v27209(VarNext,bitIndex23) )
      & ( v25244(VarNext,bitIndex118)
      <=> v27209(VarNext,bitIndex22) )
      & ( v25244(VarNext,bitIndex117)
      <=> v27209(VarNext,bitIndex21) )
      & ( v25244(VarNext,bitIndex116)
      <=> v27209(VarNext,bitIndex20) )
      & ( v25244(VarNext,bitIndex115)
      <=> v27209(VarNext,bitIndex19) )
      & ( v25244(VarNext,bitIndex114)
      <=> v27209(VarNext,bitIndex18) )
      & ( v25244(VarNext,bitIndex113)
      <=> v27209(VarNext,bitIndex17) )
      & ( v25244(VarNext,bitIndex112)
      <=> v27209(VarNext,bitIndex16) )
      & ( v25244(VarNext,bitIndex111)
      <=> v27209(VarNext,bitIndex15) )
      & ( v25244(VarNext,bitIndex110)
      <=> v27209(VarNext,bitIndex14) )
      & ( v25244(VarNext,bitIndex109)
      <=> v27209(VarNext,bitIndex13) )
      & ( v25244(VarNext,bitIndex108)
      <=> v27209(VarNext,bitIndex12) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_36,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27211(VarNext)
       => ( ( v27209(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex143) )
          & ( v27209(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex142) )
          & ( v27209(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex141) )
          & ( v27209(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex140) )
          & ( v27209(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex139) )
          & ( v27209(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex138) )
          & ( v27209(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex137) )
          & ( v27209(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex136) )
          & ( v27209(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex135) )
          & ( v27209(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex134) )
          & ( v27209(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex133) )
          & ( v27209(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex132) )
          & ( v27209(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex131) )
          & ( v27209(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex130) )
          & ( v27209(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex129) )
          & ( v27209(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex128) )
          & ( v27209(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex127) )
          & ( v27209(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex126) )
          & ( v27209(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex125) )
          & ( v27209(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex124) )
          & ( v27209(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex123) )
          & ( v27209(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex122) )
          & ( v27209(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex121) )
          & ( v27209(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex120) )
          & ( v27209(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex119) )
          & ( v27209(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex118) )
          & ( v27209(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex117) )
          & ( v27209(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex116) )
          & ( v27209(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex115) )
          & ( v27209(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex114) )
          & ( v27209(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex113) )
          & ( v27209(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex112) )
          & ( v27209(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex111) )
          & ( v27209(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex110) )
          & ( v27209(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex109) )
          & ( v27209(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex108) )
          & ( v27209(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex107) )
          & ( v27209(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex106) )
          & ( v27209(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex105) )
          & ( v27209(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex104) )
          & ( v27209(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex103) )
          & ( v27209(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex102) )
          & ( v27209(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex101) )
          & ( v27209(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex100) )
          & ( v27209(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex99) )
          & ( v27209(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex98) )
          & ( v27209(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex97) )
          & ( v27209(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex96) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_457,axiom,
    ! [VarNext] :
      ( v27211(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27209(VarNext,B)
          <=> v25320(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4733,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27211(VarNext)
      <=> ( v27212(VarNext)
          & v25315(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4732,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27212(VarNext)
      <=> ( v27214(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2532,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27214(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11893,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex71)
      <=> v27201(VarNext,bitIndex23) )
      & ( v25244(VarNext,bitIndex70)
      <=> v27201(VarNext,bitIndex22) )
      & ( v25244(VarNext,bitIndex69)
      <=> v27201(VarNext,bitIndex21) )
      & ( v25244(VarNext,bitIndex68)
      <=> v27201(VarNext,bitIndex20) )
      & ( v25244(VarNext,bitIndex67)
      <=> v27201(VarNext,bitIndex19) )
      & ( v25244(VarNext,bitIndex66)
      <=> v27201(VarNext,bitIndex18) )
      & ( v25244(VarNext,bitIndex65)
      <=> v27201(VarNext,bitIndex17) )
      & ( v25244(VarNext,bitIndex64)
      <=> v27201(VarNext,bitIndex16) )
      & ( v25244(VarNext,bitIndex63)
      <=> v27201(VarNext,bitIndex15) )
      & ( v25244(VarNext,bitIndex62)
      <=> v27201(VarNext,bitIndex14) )
      & ( v25244(VarNext,bitIndex61)
      <=> v27201(VarNext,bitIndex13) )
      & ( v25244(VarNext,bitIndex60)
      <=> v27201(VarNext,bitIndex12) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_35,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27203(VarNext)
       => ( ( v27201(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex95) )
          & ( v27201(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex94) )
          & ( v27201(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex93) )
          & ( v27201(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex92) )
          & ( v27201(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex91) )
          & ( v27201(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex90) )
          & ( v27201(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex89) )
          & ( v27201(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex88) )
          & ( v27201(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex87) )
          & ( v27201(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex86) )
          & ( v27201(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex85) )
          & ( v27201(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex84) )
          & ( v27201(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex83) )
          & ( v27201(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex82) )
          & ( v27201(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex81) )
          & ( v27201(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex80) )
          & ( v27201(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex79) )
          & ( v27201(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex78) )
          & ( v27201(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex77) )
          & ( v27201(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex76) )
          & ( v27201(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex75) )
          & ( v27201(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex74) )
          & ( v27201(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex73) )
          & ( v27201(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex72) )
          & ( v27201(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex71) )
          & ( v27201(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex70) )
          & ( v27201(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex69) )
          & ( v27201(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex68) )
          & ( v27201(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex67) )
          & ( v27201(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex66) )
          & ( v27201(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex65) )
          & ( v27201(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex64) )
          & ( v27201(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex63) )
          & ( v27201(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex62) )
          & ( v27201(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex61) )
          & ( v27201(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex60) )
          & ( v27201(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex59) )
          & ( v27201(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex58) )
          & ( v27201(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex57) )
          & ( v27201(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex56) )
          & ( v27201(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex55) )
          & ( v27201(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex54) )
          & ( v27201(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex53) )
          & ( v27201(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex52) )
          & ( v27201(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex51) )
          & ( v27201(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex50) )
          & ( v27201(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex49) )
          & ( v27201(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex48) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_456,axiom,
    ! [VarNext] :
      ( v27203(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27201(VarNext,B)
          <=> v25302(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4731,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27203(VarNext)
      <=> ( v27204(VarNext)
          & v25297(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4730,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27204(VarNext)
      <=> ( v27206(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2531,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27206(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11892,axiom,
    ! [VarCurr,B] :
      ( range_23_12(B)
     => ( v25280(VarCurr,B)
      <=> v25282(VarCurr,B) ) ) ).

fof(addAssignment_11891,axiom,
    ! [VarCurr,B] :
      ( range_23_12(B)
     => ( v25282(VarCurr,B)
      <=> v25284(VarCurr,B) ) ) ).

fof(addAssignment_11890,axiom,
    ! [VarCurr] :
      ( ( v25284(VarCurr,bitIndex23)
      <=> v25286(VarCurr,bitIndex30) )
      & ( v25284(VarCurr,bitIndex22)
      <=> v25286(VarCurr,bitIndex29) )
      & ( v25284(VarCurr,bitIndex21)
      <=> v25286(VarCurr,bitIndex28) )
      & ( v25284(VarCurr,bitIndex20)
      <=> v25286(VarCurr,bitIndex27) )
      & ( v25284(VarCurr,bitIndex19)
      <=> v25286(VarCurr,bitIndex26) )
      & ( v25284(VarCurr,bitIndex18)
      <=> v25286(VarCurr,bitIndex25) )
      & ( v25284(VarCurr,bitIndex17)
      <=> v25286(VarCurr,bitIndex24) )
      & ( v25284(VarCurr,bitIndex16)
      <=> v25286(VarCurr,bitIndex23) )
      & ( v25284(VarCurr,bitIndex15)
      <=> v25286(VarCurr,bitIndex22) )
      & ( v25284(VarCurr,bitIndex14)
      <=> v25286(VarCurr,bitIndex21) )
      & ( v25284(VarCurr,bitIndex13)
      <=> v25286(VarCurr,bitIndex20) )
      & ( v25284(VarCurr,bitIndex12)
      <=> v25286(VarCurr,bitIndex19) ) ) ).

fof(addAssignment_11889,axiom,
    ! [VarCurr] :
      ( ( v25286(VarCurr,bitIndex30)
      <=> v24386(VarCurr,bitIndex94) )
      & ( v25286(VarCurr,bitIndex29)
      <=> v24386(VarCurr,bitIndex93) )
      & ( v25286(VarCurr,bitIndex28)
      <=> v24386(VarCurr,bitIndex92) )
      & ( v25286(VarCurr,bitIndex27)
      <=> v24386(VarCurr,bitIndex91) )
      & ( v25286(VarCurr,bitIndex26)
      <=> v24386(VarCurr,bitIndex90) )
      & ( v25286(VarCurr,bitIndex25)
      <=> v24386(VarCurr,bitIndex89) )
      & ( v25286(VarCurr,bitIndex24)
      <=> v24386(VarCurr,bitIndex88) )
      & ( v25286(VarCurr,bitIndex23)
      <=> v24386(VarCurr,bitIndex87) )
      & ( v25286(VarCurr,bitIndex22)
      <=> v24386(VarCurr,bitIndex86) )
      & ( v25286(VarCurr,bitIndex21)
      <=> v24386(VarCurr,bitIndex85) )
      & ( v25286(VarCurr,bitIndex20)
      <=> v24386(VarCurr,bitIndex84) )
      & ( v25286(VarCurr,bitIndex19)
      <=> v24386(VarCurr,bitIndex83) ) ) ).

fof(addAssignment_11888,axiom,
    ! [VarNext,B] :
      ( range_23_12(B)
     => ( v25244(VarNext,B)
      <=> v27193(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_488,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27195(VarNext)
       => ! [B] :
            ( range_47_0(B)
           => ( v27193(VarNext,B)
            <=> v25244(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_455,axiom,
    ! [VarNext] :
      ( v27195(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27193(VarNext,B)
          <=> v25276(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4729,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27195(VarNext)
      <=> ( v27196(VarNext)
          & v25270(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4728,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27196(VarNext)
      <=> ( v27198(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2530,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27198(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11887,axiom,
    ! [VarCurr,B] :
      ( range_23_12(B)
     => ( v25255(VarCurr,B)
      <=> v25257(VarCurr,B) ) ) ).

fof(addAssignment_11886,axiom,
    ! [VarCurr,B] :
      ( range_23_12(B)
     => ( v25257(VarCurr,B)
      <=> v25259(VarCurr,B) ) ) ).

fof(range_axiom_225,axiom,
    ! [B] :
      ( range_23_12(B)
    <=> ( $false
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B ) ) ).

fof(addAssignment_11885,axiom,
    ! [VarCurr] :
      ( ( v25259(VarCurr,bitIndex23)
      <=> v24386(VarCurr,bitIndex30) )
      & ( v25259(VarCurr,bitIndex22)
      <=> v24386(VarCurr,bitIndex29) )
      & ( v25259(VarCurr,bitIndex21)
      <=> v24386(VarCurr,bitIndex28) )
      & ( v25259(VarCurr,bitIndex20)
      <=> v24386(VarCurr,bitIndex27) )
      & ( v25259(VarCurr,bitIndex19)
      <=> v24386(VarCurr,bitIndex26) )
      & ( v25259(VarCurr,bitIndex18)
      <=> v24386(VarCurr,bitIndex25) )
      & ( v25259(VarCurr,bitIndex17)
      <=> v24386(VarCurr,bitIndex24) )
      & ( v25259(VarCurr,bitIndex16)
      <=> v24386(VarCurr,bitIndex23) )
      & ( v25259(VarCurr,bitIndex15)
      <=> v24386(VarCurr,bitIndex22) )
      & ( v25259(VarCurr,bitIndex14)
      <=> v24386(VarCurr,bitIndex21) )
      & ( v25259(VarCurr,bitIndex13)
      <=> v24386(VarCurr,bitIndex20) )
      & ( v25259(VarCurr,bitIndex12)
      <=> v24386(VarCurr,bitIndex19) ) ) ).

fof(addAssignment_11884,axiom,
    ! [VarCurr] :
      ( v27189(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_11883,axiom,
    ! [VarCurr] :
      ( v27187(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_487,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27168(VarNext)
       => ( v26907(VarNext)
        <=> v26907(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_454,axiom,
    ! [VarNext] :
      ( v27168(VarNext)
     => ( v26907(VarNext)
      <=> v27178(VarNext) ) ) ).

fof(addAssignment_11882,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27178(VarNext)
      <=> v27176(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_755,axiom,
    ! [VarCurr] :
      ( ~ v27179(VarCurr)
     => ( v27176(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_509,axiom,
    ! [VarCurr] :
      ( v27179(VarCurr)
     => ( v27176(VarCurr)
      <=> v26913(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4727,axiom,
    ! [VarCurr] :
      ( v27179(VarCurr)
    <=> ( v27180(VarCurr)
        & v27181(VarCurr) ) ) ).

fof(writeUnaryOperator_2529,axiom,
    ! [VarCurr] :
      ( ~ v27181(VarCurr)
    <=> v26911(VarCurr) ) ).

fof(writeUnaryOperator_2528,axiom,
    ! [VarCurr] :
      ( ~ v27180(VarCurr)
    <=> v26909(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4726,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27168(VarNext)
      <=> v27169(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4725,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27169(VarNext)
      <=> ( v27170(VarNext)
          & v27165(VarNext) ) ) ) ).

fof(writeUnaryOperator_2527,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27170(VarNext)
      <=> v27172(VarNext) ) ) ).

fof(addAssignment_11881,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27172(VarNext)
      <=> v27165(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_987,axiom,
    ( v26907(constB0)
  <=> $false ) ).

fof(addAssignment_11880,axiom,
    ! [VarCurr] :
      ( v27165(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_11879,axiom,
    ! [VarCurr] :
      ( v26913(VarCurr)
    <=> v202(VarCurr,bitIndex50) ) ).

fof(addAssignment_11878,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex50)
    <=> v204(VarCurr,bitIndex50) ) ).

fof(addAssignment_11877,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex50)
    <=> v25523(VarCurr,bitIndex50) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_548,axiom,
    ! [VarCurr] :
      ( ~ v26763(VarCurr,bitIndex2)
     => ( v212(VarCurr,bitIndex50)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_794,axiom,
    ! [VarCurr] :
      ( v26763(VarCurr,bitIndex2)
     => ( v212(VarCurr,bitIndex50)
      <=> $false ) ) ).

fof(writeBinaryOperatorShiftedRanges_1243,axiom,
    ! [VarCurr] :
      ( v26763(VarCurr,bitIndex2)
    <=> ( v27108(VarCurr)
        & v27162(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4724,axiom,
    ! [VarCurr] :
      ( v27162(VarCurr)
    <=> ( v27110(VarCurr)
        | v27127(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4723,axiom,
    ! [VarCurr] :
      ( v27108(VarCurr)
    <=> ( v27109(VarCurr)
        | v27126(VarCurr) ) ) ).

fof(writeUnaryOperator_2526,axiom,
    ! [VarCurr] :
      ( ~ v27126(VarCurr)
    <=> v27127(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4722,axiom,
    ! [VarCurr] :
      ( v27127(VarCurr)
    <=> ( v27128(VarCurr)
        & v27161(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4721,axiom,
    ! [VarCurr] :
      ( v27161(VarCurr)
    <=> ( v27130(VarCurr)
        | v27146(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4720,axiom,
    ! [VarCurr] :
      ( v27128(VarCurr)
    <=> ( v27129(VarCurr)
        | v27145(VarCurr) ) ) ).

fof(writeUnaryOperator_2525,axiom,
    ! [VarCurr] :
      ( ~ v27145(VarCurr)
    <=> v27146(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4719,axiom,
    ! [VarCurr] :
      ( v27146(VarCurr)
    <=> ( v27147(VarCurr)
        & v27160(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1242,axiom,
    ! [VarCurr] :
      ( v27160(VarCurr)
    <=> ( v27113(VarCurr,bitIndex7)
        | v27150(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4718,axiom,
    ! [VarCurr] :
      ( v27147(VarCurr)
    <=> ( v27148(VarCurr)
        | v27149(VarCurr) ) ) ).

fof(writeUnaryOperator_2524,axiom,
    ! [VarCurr] :
      ( ~ v27149(VarCurr)
    <=> v27150(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4717,axiom,
    ! [VarCurr] :
      ( v27150(VarCurr)
    <=> ( v27151(VarCurr)
        & v27159(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1241,axiom,
    ! [VarCurr] :
      ( v27159(VarCurr)
    <=> ( v27113(VarCurr,bitIndex6)
        | v27154(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4716,axiom,
    ! [VarCurr] :
      ( v27151(VarCurr)
    <=> ( v27152(VarCurr)
        | v27153(VarCurr) ) ) ).

fof(writeUnaryOperator_2523,axiom,
    ! [VarCurr] :
      ( ~ v27153(VarCurr)
    <=> v27154(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4715,axiom,
    ! [VarCurr] :
      ( v27154(VarCurr)
    <=> ( v27155(VarCurr)
        & v27158(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1240,axiom,
    ! [VarCurr] :
      ( v27158(VarCurr)
    <=> ( v27113(VarCurr,bitIndex4)
        | v27113(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4714,axiom,
    ! [VarCurr] :
      ( v27155(VarCurr)
    <=> ( v27156(VarCurr)
        | v27157(VarCurr) ) ) ).

fof(writeUnaryOperator_2522,axiom,
    ! [VarCurr] :
      ( ~ v27157(VarCurr)
    <=> v27113(VarCurr,bitIndex5) ) ).

fof(writeUnaryOperator_2521,axiom,
    ! [VarCurr] :
      ( ~ v27156(VarCurr)
    <=> v27113(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_2520,axiom,
    ! [VarCurr] :
      ( ~ v27152(VarCurr)
    <=> v27113(VarCurr,bitIndex6) ) ).

fof(writeUnaryOperator_2519,axiom,
    ! [VarCurr] :
      ( ~ v27148(VarCurr)
    <=> v27113(VarCurr,bitIndex7) ) ).

fof(writeUnaryOperator_2518,axiom,
    ! [VarCurr] :
      ( ~ v27129(VarCurr)
    <=> v27130(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4713,axiom,
    ! [VarCurr] :
      ( v27130(VarCurr)
    <=> ( v27131(VarCurr)
        & v27144(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1239,axiom,
    ! [VarCurr] :
      ( v27144(VarCurr)
    <=> ( v27113(VarCurr,bitIndex3)
        | v27134(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4712,axiom,
    ! [VarCurr] :
      ( v27131(VarCurr)
    <=> ( v27132(VarCurr)
        | v27133(VarCurr) ) ) ).

fof(writeUnaryOperator_2517,axiom,
    ! [VarCurr] :
      ( ~ v27133(VarCurr)
    <=> v27134(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4711,axiom,
    ! [VarCurr] :
      ( v27134(VarCurr)
    <=> ( v27135(VarCurr)
        & v27143(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1238,axiom,
    ! [VarCurr] :
      ( v27143(VarCurr)
    <=> ( v27113(VarCurr,bitIndex2)
        | v27138(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4710,axiom,
    ! [VarCurr] :
      ( v27135(VarCurr)
    <=> ( v27136(VarCurr)
        | v27137(VarCurr) ) ) ).

fof(writeUnaryOperator_2516,axiom,
    ! [VarCurr] :
      ( ~ v27137(VarCurr)
    <=> v27138(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4709,axiom,
    ! [VarCurr] :
      ( v27138(VarCurr)
    <=> ( v27139(VarCurr)
        & v27142(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1237,axiom,
    ! [VarCurr] :
      ( v27142(VarCurr)
    <=> ( v27113(VarCurr,bitIndex0)
        | v27113(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4708,axiom,
    ! [VarCurr] :
      ( v27139(VarCurr)
    <=> ( v27140(VarCurr)
        | v27141(VarCurr) ) ) ).

fof(writeUnaryOperator_2515,axiom,
    ! [VarCurr] :
      ( ~ v27141(VarCurr)
    <=> v27113(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_2514,axiom,
    ! [VarCurr] :
      ( ~ v27140(VarCurr)
    <=> v27113(VarCurr,bitIndex0) ) ).

fof(writeUnaryOperator_2513,axiom,
    ! [VarCurr] :
      ( ~ v27136(VarCurr)
    <=> v27113(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_2512,axiom,
    ! [VarCurr] :
      ( ~ v27132(VarCurr)
    <=> v27113(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_2511,axiom,
    ! [VarCurr] :
      ( ~ v27109(VarCurr)
    <=> v27110(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4707,axiom,
    ! [VarCurr] :
      ( v27110(VarCurr)
    <=> ( v27111(VarCurr)
        & v27125(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1236,axiom,
    ! [VarCurr] :
      ( v27125(VarCurr)
    <=> ( v27113(VarCurr,bitIndex11)
        | v27115(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4706,axiom,
    ! [VarCurr] :
      ( v27111(VarCurr)
    <=> ( v27112(VarCurr)
        | v27114(VarCurr) ) ) ).

fof(writeUnaryOperator_2510,axiom,
    ! [VarCurr] :
      ( ~ v27114(VarCurr)
    <=> v27115(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4705,axiom,
    ! [VarCurr] :
      ( v27115(VarCurr)
    <=> ( v27116(VarCurr)
        & v27124(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1235,axiom,
    ! [VarCurr] :
      ( v27124(VarCurr)
    <=> ( v27113(VarCurr,bitIndex10)
        | v27119(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4704,axiom,
    ! [VarCurr] :
      ( v27116(VarCurr)
    <=> ( v27117(VarCurr)
        | v27118(VarCurr) ) ) ).

fof(writeUnaryOperator_2509,axiom,
    ! [VarCurr] :
      ( ~ v27118(VarCurr)
    <=> v27119(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4703,axiom,
    ! [VarCurr] :
      ( v27119(VarCurr)
    <=> ( v27120(VarCurr)
        & v27123(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1234,axiom,
    ! [VarCurr] :
      ( v27123(VarCurr)
    <=> ( v27113(VarCurr,bitIndex8)
        | v27113(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4702,axiom,
    ! [VarCurr] :
      ( v27120(VarCurr)
    <=> ( v27121(VarCurr)
        | v27122(VarCurr) ) ) ).

fof(writeUnaryOperator_2508,axiom,
    ! [VarCurr] :
      ( ~ v27122(VarCurr)
    <=> v27113(VarCurr,bitIndex9) ) ).

fof(writeUnaryOperator_2507,axiom,
    ! [VarCurr] :
      ( ~ v27121(VarCurr)
    <=> v27113(VarCurr,bitIndex8) ) ).

fof(writeUnaryOperator_2506,axiom,
    ! [VarCurr] :
      ( ~ v27117(VarCurr)
    <=> v27113(VarCurr,bitIndex10) ) ).

fof(writeUnaryOperator_2505,axiom,
    ! [VarCurr] :
      ( ~ v27112(VarCurr)
    <=> v27113(VarCurr,bitIndex11) ) ).

fof(addAssignment_11876,axiom,
    ! [VarCurr] :
      ( ( v27113(VarCurr,bitIndex7)
      <=> v212(VarCurr,bitIndex31) )
      & ( v27113(VarCurr,bitIndex6)
      <=> v212(VarCurr,bitIndex30) )
      & ( v27113(VarCurr,bitIndex5)
      <=> v212(VarCurr,bitIndex29) )
      & ( v27113(VarCurr,bitIndex4)
      <=> v212(VarCurr,bitIndex28) )
      & ( v27113(VarCurr,bitIndex3)
      <=> v212(VarCurr,bitIndex27) )
      & ( v27113(VarCurr,bitIndex2)
      <=> v212(VarCurr,bitIndex26) )
      & ( v27113(VarCurr,bitIndex1)
      <=> v212(VarCurr,bitIndex25) )
      & ( v27113(VarCurr,bitIndex0)
      <=> v212(VarCurr,bitIndex24) ) ) ).

fof(addAssignment_11875,axiom,
    ! [VarCurr] :
      ( ( v27113(VarCurr,bitIndex11)
      <=> v212(VarCurr,bitIndex35) )
      & ( v27113(VarCurr,bitIndex10)
      <=> v212(VarCurr,bitIndex34) )
      & ( v27113(VarCurr,bitIndex9)
      <=> v212(VarCurr,bitIndex33) )
      & ( v27113(VarCurr,bitIndex8)
      <=> v212(VarCurr,bitIndex32) ) ) ).

fof(addAssignment_11874,axiom,
    ! [VarCurr] :
      ( v212(VarCurr,bitIndex31)
    <=> v25522(VarCurr,bitIndex31) ) ).

fof(addAssignment_11873,axiom,
    ! [VarCurr,B] :
      ( range_29_24(B)
     => ( v212(VarCurr,B)
      <=> v25522(VarCurr,B) ) ) ).

fof(addAssignment_11872,axiom,
    ! [VarCurr] :
      ( v25515(VarCurr,bitIndex31)
    <=> v25517(VarCurr,bitIndex31) ) ).

fof(addAssignment_11871,axiom,
    ! [VarCurr] :
      ( v25517(VarCurr,bitIndex31)
    <=> v25519(VarCurr,bitIndex31) ) ).

fof(addAssignment_11870,axiom,
    ! [VarCurr] :
      ( v25519(VarCurr,bitIndex31)
    <=> v25521(VarCurr,bitIndex31) ) ).

fof(addAssignment_11869,axiom,
    ! [VarCurr] :
      ( v25521(VarCurr,bitIndex31)
    <=> v4847(VarCurr,bitIndex38) ) ).

fof(addAssignment_11868,axiom,
    ! [VarCurr] :
      ( v25236(VarCurr,bitIndex31)
    <=> v25238(VarCurr,bitIndex31) ) ).

fof(addAssignment_11867,axiom,
    ! [VarCurr] :
      ( v25238(VarCurr,bitIndex31)
    <=> v25240(VarCurr,bitIndex31) ) ).

fof(addAssignment_11866,axiom,
    ! [VarCurr] :
      ( v25240(VarCurr,bitIndex31)
    <=> v25242(VarCurr,bitIndex31) ) ).

fof(addAssignment_11865,axiom,
    ! [VarCurr] :
      ( v25242(VarCurr,bitIndex31)
    <=> v25504(VarCurr,bitIndex31) ) ).

fof(addAssignment_11864,axiom,
    ! [VarNext] :
      ( v25244(VarNext,bitIndex367)
    <=> v27099(VarNext,bitIndex31) ) ).

fof(addCaseBooleanConditionShiftedRanges1_34,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27101(VarNext)
       => ( ( v27099(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex383) )
          & ( v27099(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex382) )
          & ( v27099(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex381) )
          & ( v27099(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex380) )
          & ( v27099(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex379) )
          & ( v27099(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex378) )
          & ( v27099(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex377) )
          & ( v27099(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex376) )
          & ( v27099(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex375) )
          & ( v27099(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex374) )
          & ( v27099(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex373) )
          & ( v27099(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex372) )
          & ( v27099(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex371) )
          & ( v27099(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex370) )
          & ( v27099(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex369) )
          & ( v27099(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex368) )
          & ( v27099(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex367) )
          & ( v27099(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex366) )
          & ( v27099(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex365) )
          & ( v27099(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex364) )
          & ( v27099(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex363) )
          & ( v27099(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex362) )
          & ( v27099(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex361) )
          & ( v27099(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex360) )
          & ( v27099(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex359) )
          & ( v27099(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex358) )
          & ( v27099(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex357) )
          & ( v27099(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex356) )
          & ( v27099(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex355) )
          & ( v27099(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex354) )
          & ( v27099(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex353) )
          & ( v27099(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex352) )
          & ( v27099(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex351) )
          & ( v27099(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex350) )
          & ( v27099(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex349) )
          & ( v27099(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex348) )
          & ( v27099(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex347) )
          & ( v27099(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex346) )
          & ( v27099(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex345) )
          & ( v27099(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex344) )
          & ( v27099(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex343) )
          & ( v27099(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex342) )
          & ( v27099(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex341) )
          & ( v27099(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex340) )
          & ( v27099(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex339) )
          & ( v27099(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex338) )
          & ( v27099(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex337) )
          & ( v27099(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex336) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_453,axiom,
    ! [VarNext] :
      ( v27101(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27099(VarNext,B)
          <=> v25410(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4701,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27101(VarNext)
      <=> ( v27102(VarNext)
          & v25405(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4700,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27102(VarNext)
      <=> ( v27104(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2504,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27104(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11863,axiom,
    ! [VarNext] :
      ( v25244(VarNext,bitIndex319)
    <=> v27091(VarNext,bitIndex31) ) ).

fof(addCaseBooleanConditionShiftedRanges1_33,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27093(VarNext)
       => ( ( v27091(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex335) )
          & ( v27091(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex334) )
          & ( v27091(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex333) )
          & ( v27091(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex332) )
          & ( v27091(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex331) )
          & ( v27091(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex330) )
          & ( v27091(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex329) )
          & ( v27091(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex328) )
          & ( v27091(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex327) )
          & ( v27091(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex326) )
          & ( v27091(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex325) )
          & ( v27091(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex324) )
          & ( v27091(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex323) )
          & ( v27091(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex322) )
          & ( v27091(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex321) )
          & ( v27091(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex320) )
          & ( v27091(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex319) )
          & ( v27091(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex318) )
          & ( v27091(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex317) )
          & ( v27091(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex316) )
          & ( v27091(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex315) )
          & ( v27091(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex314) )
          & ( v27091(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex313) )
          & ( v27091(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex312) )
          & ( v27091(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex311) )
          & ( v27091(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex310) )
          & ( v27091(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex309) )
          & ( v27091(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex308) )
          & ( v27091(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex307) )
          & ( v27091(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex306) )
          & ( v27091(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex305) )
          & ( v27091(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex304) )
          & ( v27091(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex303) )
          & ( v27091(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex302) )
          & ( v27091(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex301) )
          & ( v27091(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex300) )
          & ( v27091(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex299) )
          & ( v27091(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex298) )
          & ( v27091(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex297) )
          & ( v27091(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex296) )
          & ( v27091(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex295) )
          & ( v27091(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex294) )
          & ( v27091(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex293) )
          & ( v27091(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex292) )
          & ( v27091(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex291) )
          & ( v27091(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex290) )
          & ( v27091(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex289) )
          & ( v27091(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex288) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_452,axiom,
    ! [VarNext] :
      ( v27093(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27091(VarNext,B)
          <=> v25392(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4699,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27093(VarNext)
      <=> ( v27094(VarNext)
          & v25387(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4698,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27094(VarNext)
      <=> ( v27096(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2503,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27096(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11862,axiom,
    ! [VarNext] :
      ( v25244(VarNext,bitIndex271)
    <=> v27083(VarNext,bitIndex31) ) ).

fof(addCaseBooleanConditionShiftedRanges1_32,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27085(VarNext)
       => ( ( v27083(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex287) )
          & ( v27083(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex286) )
          & ( v27083(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex285) )
          & ( v27083(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex284) )
          & ( v27083(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex283) )
          & ( v27083(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex282) )
          & ( v27083(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex281) )
          & ( v27083(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex280) )
          & ( v27083(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex279) )
          & ( v27083(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex278) )
          & ( v27083(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex277) )
          & ( v27083(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex276) )
          & ( v27083(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex275) )
          & ( v27083(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex274) )
          & ( v27083(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex273) )
          & ( v27083(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex272) )
          & ( v27083(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex271) )
          & ( v27083(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex270) )
          & ( v27083(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex269) )
          & ( v27083(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex268) )
          & ( v27083(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex267) )
          & ( v27083(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex266) )
          & ( v27083(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex265) )
          & ( v27083(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex264) )
          & ( v27083(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex263) )
          & ( v27083(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex262) )
          & ( v27083(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex261) )
          & ( v27083(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex260) )
          & ( v27083(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex259) )
          & ( v27083(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex258) )
          & ( v27083(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex257) )
          & ( v27083(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex256) )
          & ( v27083(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex255) )
          & ( v27083(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex254) )
          & ( v27083(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex253) )
          & ( v27083(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex252) )
          & ( v27083(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex251) )
          & ( v27083(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex250) )
          & ( v27083(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex249) )
          & ( v27083(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex248) )
          & ( v27083(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex247) )
          & ( v27083(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex246) )
          & ( v27083(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex245) )
          & ( v27083(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex244) )
          & ( v27083(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex243) )
          & ( v27083(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex242) )
          & ( v27083(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex241) )
          & ( v27083(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex240) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_451,axiom,
    ! [VarNext] :
      ( v27085(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27083(VarNext,B)
          <=> v25374(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4697,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27085(VarNext)
      <=> ( v27086(VarNext)
          & v25369(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4696,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27086(VarNext)
      <=> ( v27088(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2502,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27088(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11861,axiom,
    ! [VarNext] :
      ( v25244(VarNext,bitIndex223)
    <=> v27075(VarNext,bitIndex31) ) ).

fof(addCaseBooleanConditionShiftedRanges1_31,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27077(VarNext)
       => ( ( v27075(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex239) )
          & ( v27075(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex238) )
          & ( v27075(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex237) )
          & ( v27075(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex236) )
          & ( v27075(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex235) )
          & ( v27075(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex234) )
          & ( v27075(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex233) )
          & ( v27075(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex232) )
          & ( v27075(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex231) )
          & ( v27075(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex230) )
          & ( v27075(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex229) )
          & ( v27075(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex228) )
          & ( v27075(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex227) )
          & ( v27075(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex226) )
          & ( v27075(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex225) )
          & ( v27075(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex224) )
          & ( v27075(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex223) )
          & ( v27075(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex222) )
          & ( v27075(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex221) )
          & ( v27075(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex220) )
          & ( v27075(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex219) )
          & ( v27075(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex218) )
          & ( v27075(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex217) )
          & ( v27075(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex216) )
          & ( v27075(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex215) )
          & ( v27075(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex214) )
          & ( v27075(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex213) )
          & ( v27075(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex212) )
          & ( v27075(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex211) )
          & ( v27075(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex210) )
          & ( v27075(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex209) )
          & ( v27075(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex208) )
          & ( v27075(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex207) )
          & ( v27075(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex206) )
          & ( v27075(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex205) )
          & ( v27075(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex204) )
          & ( v27075(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex203) )
          & ( v27075(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex202) )
          & ( v27075(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex201) )
          & ( v27075(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex200) )
          & ( v27075(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex199) )
          & ( v27075(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex198) )
          & ( v27075(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex197) )
          & ( v27075(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex196) )
          & ( v27075(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex195) )
          & ( v27075(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex194) )
          & ( v27075(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex193) )
          & ( v27075(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex192) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_450,axiom,
    ! [VarNext] :
      ( v27077(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27075(VarNext,B)
          <=> v25356(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4695,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27077(VarNext)
      <=> ( v27078(VarNext)
          & v25351(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4694,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27078(VarNext)
      <=> ( v27080(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2501,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27080(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11860,axiom,
    ! [VarNext] :
      ( v25244(VarNext,bitIndex175)
    <=> v27067(VarNext,bitIndex31) ) ).

fof(addCaseBooleanConditionShiftedRanges1_30,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27069(VarNext)
       => ( ( v27067(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex191) )
          & ( v27067(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex190) )
          & ( v27067(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex189) )
          & ( v27067(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex188) )
          & ( v27067(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex187) )
          & ( v27067(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex186) )
          & ( v27067(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex185) )
          & ( v27067(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex184) )
          & ( v27067(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex183) )
          & ( v27067(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex182) )
          & ( v27067(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex181) )
          & ( v27067(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex180) )
          & ( v27067(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex179) )
          & ( v27067(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex178) )
          & ( v27067(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex177) )
          & ( v27067(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex176) )
          & ( v27067(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex175) )
          & ( v27067(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex174) )
          & ( v27067(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex173) )
          & ( v27067(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex172) )
          & ( v27067(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex171) )
          & ( v27067(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex170) )
          & ( v27067(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex169) )
          & ( v27067(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex168) )
          & ( v27067(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex167) )
          & ( v27067(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex166) )
          & ( v27067(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex165) )
          & ( v27067(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex164) )
          & ( v27067(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex163) )
          & ( v27067(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex162) )
          & ( v27067(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex161) )
          & ( v27067(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex160) )
          & ( v27067(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex159) )
          & ( v27067(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex158) )
          & ( v27067(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex157) )
          & ( v27067(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex156) )
          & ( v27067(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex155) )
          & ( v27067(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex154) )
          & ( v27067(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex153) )
          & ( v27067(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex152) )
          & ( v27067(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex151) )
          & ( v27067(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex150) )
          & ( v27067(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex149) )
          & ( v27067(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex148) )
          & ( v27067(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex147) )
          & ( v27067(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex146) )
          & ( v27067(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex145) )
          & ( v27067(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex144) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_449,axiom,
    ! [VarNext] :
      ( v27069(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27067(VarNext,B)
          <=> v25338(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4693,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27069(VarNext)
      <=> ( v27070(VarNext)
          & v25333(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4692,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27070(VarNext)
      <=> ( v27072(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2500,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27072(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11859,axiom,
    ! [VarNext] :
      ( v25244(VarNext,bitIndex127)
    <=> v27059(VarNext,bitIndex31) ) ).

fof(addCaseBooleanConditionShiftedRanges1_29,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27061(VarNext)
       => ( ( v27059(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex143) )
          & ( v27059(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex142) )
          & ( v27059(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex141) )
          & ( v27059(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex140) )
          & ( v27059(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex139) )
          & ( v27059(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex138) )
          & ( v27059(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex137) )
          & ( v27059(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex136) )
          & ( v27059(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex135) )
          & ( v27059(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex134) )
          & ( v27059(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex133) )
          & ( v27059(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex132) )
          & ( v27059(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex131) )
          & ( v27059(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex130) )
          & ( v27059(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex129) )
          & ( v27059(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex128) )
          & ( v27059(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex127) )
          & ( v27059(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex126) )
          & ( v27059(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex125) )
          & ( v27059(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex124) )
          & ( v27059(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex123) )
          & ( v27059(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex122) )
          & ( v27059(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex121) )
          & ( v27059(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex120) )
          & ( v27059(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex119) )
          & ( v27059(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex118) )
          & ( v27059(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex117) )
          & ( v27059(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex116) )
          & ( v27059(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex115) )
          & ( v27059(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex114) )
          & ( v27059(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex113) )
          & ( v27059(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex112) )
          & ( v27059(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex111) )
          & ( v27059(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex110) )
          & ( v27059(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex109) )
          & ( v27059(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex108) )
          & ( v27059(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex107) )
          & ( v27059(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex106) )
          & ( v27059(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex105) )
          & ( v27059(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex104) )
          & ( v27059(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex103) )
          & ( v27059(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex102) )
          & ( v27059(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex101) )
          & ( v27059(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex100) )
          & ( v27059(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex99) )
          & ( v27059(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex98) )
          & ( v27059(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex97) )
          & ( v27059(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex96) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_448,axiom,
    ! [VarNext] :
      ( v27061(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27059(VarNext,B)
          <=> v25320(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4691,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27061(VarNext)
      <=> ( v27062(VarNext)
          & v25315(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4690,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27062(VarNext)
      <=> ( v27064(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2499,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27064(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11858,axiom,
    ! [VarNext] :
      ( v25244(VarNext,bitIndex79)
    <=> v27051(VarNext,bitIndex31) ) ).

fof(addCaseBooleanConditionShiftedRanges1_28,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27053(VarNext)
       => ( ( v27051(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex95) )
          & ( v27051(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex94) )
          & ( v27051(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex93) )
          & ( v27051(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex92) )
          & ( v27051(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex91) )
          & ( v27051(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex90) )
          & ( v27051(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex89) )
          & ( v27051(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex88) )
          & ( v27051(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex87) )
          & ( v27051(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex86) )
          & ( v27051(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex85) )
          & ( v27051(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex84) )
          & ( v27051(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex83) )
          & ( v27051(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex82) )
          & ( v27051(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex81) )
          & ( v27051(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex80) )
          & ( v27051(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex79) )
          & ( v27051(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex78) )
          & ( v27051(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex77) )
          & ( v27051(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex76) )
          & ( v27051(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex75) )
          & ( v27051(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex74) )
          & ( v27051(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex73) )
          & ( v27051(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex72) )
          & ( v27051(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex71) )
          & ( v27051(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex70) )
          & ( v27051(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex69) )
          & ( v27051(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex68) )
          & ( v27051(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex67) )
          & ( v27051(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex66) )
          & ( v27051(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex65) )
          & ( v27051(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex64) )
          & ( v27051(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex63) )
          & ( v27051(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex62) )
          & ( v27051(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex61) )
          & ( v27051(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex60) )
          & ( v27051(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex59) )
          & ( v27051(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex58) )
          & ( v27051(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex57) )
          & ( v27051(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex56) )
          & ( v27051(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex55) )
          & ( v27051(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex54) )
          & ( v27051(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex53) )
          & ( v27051(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex52) )
          & ( v27051(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex51) )
          & ( v27051(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex50) )
          & ( v27051(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex49) )
          & ( v27051(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex48) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_447,axiom,
    ! [VarNext] :
      ( v27053(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27051(VarNext,B)
          <=> v25302(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4689,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27053(VarNext)
      <=> ( v27054(VarNext)
          & v25297(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4688,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27054(VarNext)
      <=> ( v27056(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2498,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27056(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11857,axiom,
    ! [VarCurr] :
      ( v25280(VarCurr,bitIndex31)
    <=> v25282(VarCurr,bitIndex31) ) ).

fof(addAssignment_11856,axiom,
    ! [VarCurr] :
      ( v25282(VarCurr,bitIndex31)
    <=> v25284(VarCurr,bitIndex31) ) ).

fof(addAssignment_11855,axiom,
    ! [VarCurr] :
      ( v25284(VarCurr,bitIndex31)
    <=> v25286(VarCurr,bitIndex38) ) ).

fof(addAssignment_11854,axiom,
    ! [VarCurr] :
      ( v25286(VarCurr,bitIndex38)
    <=> v24386(VarCurr,bitIndex102) ) ).

fof(addAssignment_11853,axiom,
    ! [VarNext] :
      ( v25244(VarNext,bitIndex31)
    <=> v27043(VarNext,bitIndex31) ) ).

fof(addCaseBooleanConditionEqualRanges1_486,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27045(VarNext)
       => ! [B] :
            ( range_47_0(B)
           => ( v27043(VarNext,B)
            <=> v25244(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_446,axiom,
    ! [VarNext] :
      ( v27045(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27043(VarNext,B)
          <=> v25276(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4687,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27045(VarNext)
      <=> ( v27046(VarNext)
          & v25270(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4686,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27046(VarNext)
      <=> ( v27048(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2497,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27048(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11852,axiom,
    ! [VarCurr] :
      ( v25255(VarCurr,bitIndex31)
    <=> v25257(VarCurr,bitIndex31) ) ).

fof(addAssignment_11851,axiom,
    ! [VarCurr] :
      ( v25257(VarCurr,bitIndex31)
    <=> v25259(VarCurr,bitIndex31) ) ).

fof(addAssignment_11850,axiom,
    ! [VarCurr] :
      ( v25259(VarCurr,bitIndex31)
    <=> v24386(VarCurr,bitIndex38) ) ).

fof(addAssignment_11849,axiom,
    ! [VarCurr,B] :
      ( range_29_24(B)
     => ( v25515(VarCurr,B)
      <=> v25517(VarCurr,B) ) ) ).

fof(addAssignment_11848,axiom,
    ! [VarCurr,B] :
      ( range_29_24(B)
     => ( v25517(VarCurr,B)
      <=> v25519(VarCurr,B) ) ) ).

fof(addAssignment_11847,axiom,
    ! [VarCurr,B] :
      ( range_29_24(B)
     => ( v25519(VarCurr,B)
      <=> v25521(VarCurr,B) ) ) ).

fof(addAssignment_11846,axiom,
    ! [VarCurr] :
      ( ( v25521(VarCurr,bitIndex29)
      <=> v4847(VarCurr,bitIndex36) )
      & ( v25521(VarCurr,bitIndex28)
      <=> v4847(VarCurr,bitIndex35) )
      & ( v25521(VarCurr,bitIndex27)
      <=> v4847(VarCurr,bitIndex34) )
      & ( v25521(VarCurr,bitIndex26)
      <=> v4847(VarCurr,bitIndex33) )
      & ( v25521(VarCurr,bitIndex25)
      <=> v4847(VarCurr,bitIndex32) )
      & ( v25521(VarCurr,bitIndex24)
      <=> v4847(VarCurr,bitIndex31) ) ) ).

fof(addAssignment_11845,axiom,
    ! [VarCurr,B] :
      ( range_29_24(B)
     => ( v25236(VarCurr,B)
      <=> v25238(VarCurr,B) ) ) ).

fof(addAssignment_11844,axiom,
    ! [VarCurr,B] :
      ( range_29_24(B)
     => ( v25238(VarCurr,B)
      <=> v25240(VarCurr,B) ) ) ).

fof(addAssignment_11843,axiom,
    ! [VarCurr,B] :
      ( range_29_24(B)
     => ( v25240(VarCurr,B)
      <=> v25242(VarCurr,B) ) ) ).

fof(addAssignment_11842,axiom,
    ! [VarCurr,B] :
      ( range_29_24(B)
     => ( v25242(VarCurr,B)
      <=> v25504(VarCurr,B) ) ) ).

fof(addAssignment_11841,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex365)
      <=> v27035(VarNext,bitIndex29) )
      & ( v25244(VarNext,bitIndex364)
      <=> v27035(VarNext,bitIndex28) )
      & ( v25244(VarNext,bitIndex363)
      <=> v27035(VarNext,bitIndex27) )
      & ( v25244(VarNext,bitIndex362)
      <=> v27035(VarNext,bitIndex26) )
      & ( v25244(VarNext,bitIndex361)
      <=> v27035(VarNext,bitIndex25) )
      & ( v25244(VarNext,bitIndex360)
      <=> v27035(VarNext,bitIndex24) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_27,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27037(VarNext)
       => ( ( v27035(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex383) )
          & ( v27035(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex382) )
          & ( v27035(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex381) )
          & ( v27035(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex380) )
          & ( v27035(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex379) )
          & ( v27035(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex378) )
          & ( v27035(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex377) )
          & ( v27035(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex376) )
          & ( v27035(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex375) )
          & ( v27035(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex374) )
          & ( v27035(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex373) )
          & ( v27035(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex372) )
          & ( v27035(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex371) )
          & ( v27035(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex370) )
          & ( v27035(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex369) )
          & ( v27035(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex368) )
          & ( v27035(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex367) )
          & ( v27035(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex366) )
          & ( v27035(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex365) )
          & ( v27035(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex364) )
          & ( v27035(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex363) )
          & ( v27035(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex362) )
          & ( v27035(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex361) )
          & ( v27035(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex360) )
          & ( v27035(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex359) )
          & ( v27035(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex358) )
          & ( v27035(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex357) )
          & ( v27035(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex356) )
          & ( v27035(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex355) )
          & ( v27035(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex354) )
          & ( v27035(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex353) )
          & ( v27035(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex352) )
          & ( v27035(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex351) )
          & ( v27035(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex350) )
          & ( v27035(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex349) )
          & ( v27035(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex348) )
          & ( v27035(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex347) )
          & ( v27035(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex346) )
          & ( v27035(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex345) )
          & ( v27035(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex344) )
          & ( v27035(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex343) )
          & ( v27035(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex342) )
          & ( v27035(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex341) )
          & ( v27035(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex340) )
          & ( v27035(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex339) )
          & ( v27035(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex338) )
          & ( v27035(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex337) )
          & ( v27035(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex336) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_445,axiom,
    ! [VarNext] :
      ( v27037(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27035(VarNext,B)
          <=> v25410(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4685,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27037(VarNext)
      <=> ( v27038(VarNext)
          & v25405(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4684,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27038(VarNext)
      <=> ( v27040(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2496,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27040(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11840,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex317)
      <=> v27027(VarNext,bitIndex29) )
      & ( v25244(VarNext,bitIndex316)
      <=> v27027(VarNext,bitIndex28) )
      & ( v25244(VarNext,bitIndex315)
      <=> v27027(VarNext,bitIndex27) )
      & ( v25244(VarNext,bitIndex314)
      <=> v27027(VarNext,bitIndex26) )
      & ( v25244(VarNext,bitIndex313)
      <=> v27027(VarNext,bitIndex25) )
      & ( v25244(VarNext,bitIndex312)
      <=> v27027(VarNext,bitIndex24) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_26,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27029(VarNext)
       => ( ( v27027(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex335) )
          & ( v27027(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex334) )
          & ( v27027(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex333) )
          & ( v27027(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex332) )
          & ( v27027(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex331) )
          & ( v27027(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex330) )
          & ( v27027(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex329) )
          & ( v27027(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex328) )
          & ( v27027(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex327) )
          & ( v27027(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex326) )
          & ( v27027(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex325) )
          & ( v27027(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex324) )
          & ( v27027(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex323) )
          & ( v27027(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex322) )
          & ( v27027(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex321) )
          & ( v27027(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex320) )
          & ( v27027(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex319) )
          & ( v27027(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex318) )
          & ( v27027(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex317) )
          & ( v27027(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex316) )
          & ( v27027(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex315) )
          & ( v27027(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex314) )
          & ( v27027(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex313) )
          & ( v27027(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex312) )
          & ( v27027(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex311) )
          & ( v27027(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex310) )
          & ( v27027(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex309) )
          & ( v27027(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex308) )
          & ( v27027(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex307) )
          & ( v27027(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex306) )
          & ( v27027(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex305) )
          & ( v27027(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex304) )
          & ( v27027(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex303) )
          & ( v27027(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex302) )
          & ( v27027(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex301) )
          & ( v27027(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex300) )
          & ( v27027(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex299) )
          & ( v27027(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex298) )
          & ( v27027(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex297) )
          & ( v27027(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex296) )
          & ( v27027(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex295) )
          & ( v27027(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex294) )
          & ( v27027(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex293) )
          & ( v27027(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex292) )
          & ( v27027(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex291) )
          & ( v27027(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex290) )
          & ( v27027(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex289) )
          & ( v27027(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex288) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_444,axiom,
    ! [VarNext] :
      ( v27029(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27027(VarNext,B)
          <=> v25392(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4683,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27029(VarNext)
      <=> ( v27030(VarNext)
          & v25387(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4682,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27030(VarNext)
      <=> ( v27032(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2495,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27032(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11839,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex269)
      <=> v27019(VarNext,bitIndex29) )
      & ( v25244(VarNext,bitIndex268)
      <=> v27019(VarNext,bitIndex28) )
      & ( v25244(VarNext,bitIndex267)
      <=> v27019(VarNext,bitIndex27) )
      & ( v25244(VarNext,bitIndex266)
      <=> v27019(VarNext,bitIndex26) )
      & ( v25244(VarNext,bitIndex265)
      <=> v27019(VarNext,bitIndex25) )
      & ( v25244(VarNext,bitIndex264)
      <=> v27019(VarNext,bitIndex24) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_25,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27021(VarNext)
       => ( ( v27019(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex287) )
          & ( v27019(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex286) )
          & ( v27019(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex285) )
          & ( v27019(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex284) )
          & ( v27019(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex283) )
          & ( v27019(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex282) )
          & ( v27019(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex281) )
          & ( v27019(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex280) )
          & ( v27019(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex279) )
          & ( v27019(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex278) )
          & ( v27019(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex277) )
          & ( v27019(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex276) )
          & ( v27019(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex275) )
          & ( v27019(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex274) )
          & ( v27019(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex273) )
          & ( v27019(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex272) )
          & ( v27019(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex271) )
          & ( v27019(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex270) )
          & ( v27019(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex269) )
          & ( v27019(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex268) )
          & ( v27019(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex267) )
          & ( v27019(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex266) )
          & ( v27019(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex265) )
          & ( v27019(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex264) )
          & ( v27019(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex263) )
          & ( v27019(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex262) )
          & ( v27019(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex261) )
          & ( v27019(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex260) )
          & ( v27019(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex259) )
          & ( v27019(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex258) )
          & ( v27019(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex257) )
          & ( v27019(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex256) )
          & ( v27019(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex255) )
          & ( v27019(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex254) )
          & ( v27019(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex253) )
          & ( v27019(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex252) )
          & ( v27019(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex251) )
          & ( v27019(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex250) )
          & ( v27019(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex249) )
          & ( v27019(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex248) )
          & ( v27019(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex247) )
          & ( v27019(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex246) )
          & ( v27019(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex245) )
          & ( v27019(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex244) )
          & ( v27019(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex243) )
          & ( v27019(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex242) )
          & ( v27019(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex241) )
          & ( v27019(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex240) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_443,axiom,
    ! [VarNext] :
      ( v27021(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27019(VarNext,B)
          <=> v25374(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4681,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27021(VarNext)
      <=> ( v27022(VarNext)
          & v25369(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4680,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27022(VarNext)
      <=> ( v27024(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2494,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27024(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11838,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex221)
      <=> v27011(VarNext,bitIndex29) )
      & ( v25244(VarNext,bitIndex220)
      <=> v27011(VarNext,bitIndex28) )
      & ( v25244(VarNext,bitIndex219)
      <=> v27011(VarNext,bitIndex27) )
      & ( v25244(VarNext,bitIndex218)
      <=> v27011(VarNext,bitIndex26) )
      & ( v25244(VarNext,bitIndex217)
      <=> v27011(VarNext,bitIndex25) )
      & ( v25244(VarNext,bitIndex216)
      <=> v27011(VarNext,bitIndex24) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_24,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27013(VarNext)
       => ( ( v27011(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex239) )
          & ( v27011(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex238) )
          & ( v27011(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex237) )
          & ( v27011(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex236) )
          & ( v27011(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex235) )
          & ( v27011(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex234) )
          & ( v27011(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex233) )
          & ( v27011(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex232) )
          & ( v27011(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex231) )
          & ( v27011(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex230) )
          & ( v27011(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex229) )
          & ( v27011(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex228) )
          & ( v27011(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex227) )
          & ( v27011(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex226) )
          & ( v27011(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex225) )
          & ( v27011(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex224) )
          & ( v27011(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex223) )
          & ( v27011(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex222) )
          & ( v27011(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex221) )
          & ( v27011(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex220) )
          & ( v27011(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex219) )
          & ( v27011(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex218) )
          & ( v27011(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex217) )
          & ( v27011(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex216) )
          & ( v27011(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex215) )
          & ( v27011(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex214) )
          & ( v27011(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex213) )
          & ( v27011(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex212) )
          & ( v27011(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex211) )
          & ( v27011(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex210) )
          & ( v27011(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex209) )
          & ( v27011(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex208) )
          & ( v27011(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex207) )
          & ( v27011(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex206) )
          & ( v27011(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex205) )
          & ( v27011(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex204) )
          & ( v27011(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex203) )
          & ( v27011(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex202) )
          & ( v27011(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex201) )
          & ( v27011(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex200) )
          & ( v27011(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex199) )
          & ( v27011(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex198) )
          & ( v27011(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex197) )
          & ( v27011(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex196) )
          & ( v27011(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex195) )
          & ( v27011(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex194) )
          & ( v27011(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex193) )
          & ( v27011(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex192) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_442,axiom,
    ! [VarNext] :
      ( v27013(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27011(VarNext,B)
          <=> v25356(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4679,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27013(VarNext)
      <=> ( v27014(VarNext)
          & v25351(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4678,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27014(VarNext)
      <=> ( v27016(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2493,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27016(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11837,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex173)
      <=> v27003(VarNext,bitIndex29) )
      & ( v25244(VarNext,bitIndex172)
      <=> v27003(VarNext,bitIndex28) )
      & ( v25244(VarNext,bitIndex171)
      <=> v27003(VarNext,bitIndex27) )
      & ( v25244(VarNext,bitIndex170)
      <=> v27003(VarNext,bitIndex26) )
      & ( v25244(VarNext,bitIndex169)
      <=> v27003(VarNext,bitIndex25) )
      & ( v25244(VarNext,bitIndex168)
      <=> v27003(VarNext,bitIndex24) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_23,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27005(VarNext)
       => ( ( v27003(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex191) )
          & ( v27003(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex190) )
          & ( v27003(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex189) )
          & ( v27003(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex188) )
          & ( v27003(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex187) )
          & ( v27003(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex186) )
          & ( v27003(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex185) )
          & ( v27003(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex184) )
          & ( v27003(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex183) )
          & ( v27003(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex182) )
          & ( v27003(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex181) )
          & ( v27003(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex180) )
          & ( v27003(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex179) )
          & ( v27003(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex178) )
          & ( v27003(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex177) )
          & ( v27003(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex176) )
          & ( v27003(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex175) )
          & ( v27003(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex174) )
          & ( v27003(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex173) )
          & ( v27003(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex172) )
          & ( v27003(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex171) )
          & ( v27003(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex170) )
          & ( v27003(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex169) )
          & ( v27003(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex168) )
          & ( v27003(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex167) )
          & ( v27003(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex166) )
          & ( v27003(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex165) )
          & ( v27003(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex164) )
          & ( v27003(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex163) )
          & ( v27003(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex162) )
          & ( v27003(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex161) )
          & ( v27003(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex160) )
          & ( v27003(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex159) )
          & ( v27003(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex158) )
          & ( v27003(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex157) )
          & ( v27003(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex156) )
          & ( v27003(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex155) )
          & ( v27003(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex154) )
          & ( v27003(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex153) )
          & ( v27003(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex152) )
          & ( v27003(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex151) )
          & ( v27003(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex150) )
          & ( v27003(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex149) )
          & ( v27003(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex148) )
          & ( v27003(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex147) )
          & ( v27003(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex146) )
          & ( v27003(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex145) )
          & ( v27003(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex144) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_441,axiom,
    ! [VarNext] :
      ( v27005(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v27003(VarNext,B)
          <=> v25338(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4677,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27005(VarNext)
      <=> ( v27006(VarNext)
          & v25333(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4676,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v27006(VarNext)
      <=> ( v27008(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2492,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27008(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11836,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex125)
      <=> v26995(VarNext,bitIndex29) )
      & ( v25244(VarNext,bitIndex124)
      <=> v26995(VarNext,bitIndex28) )
      & ( v25244(VarNext,bitIndex123)
      <=> v26995(VarNext,bitIndex27) )
      & ( v25244(VarNext,bitIndex122)
      <=> v26995(VarNext,bitIndex26) )
      & ( v25244(VarNext,bitIndex121)
      <=> v26995(VarNext,bitIndex25) )
      & ( v25244(VarNext,bitIndex120)
      <=> v26995(VarNext,bitIndex24) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_22,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26997(VarNext)
       => ( ( v26995(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex143) )
          & ( v26995(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex142) )
          & ( v26995(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex141) )
          & ( v26995(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex140) )
          & ( v26995(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex139) )
          & ( v26995(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex138) )
          & ( v26995(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex137) )
          & ( v26995(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex136) )
          & ( v26995(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex135) )
          & ( v26995(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex134) )
          & ( v26995(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex133) )
          & ( v26995(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex132) )
          & ( v26995(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex131) )
          & ( v26995(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex130) )
          & ( v26995(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex129) )
          & ( v26995(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex128) )
          & ( v26995(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex127) )
          & ( v26995(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex126) )
          & ( v26995(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex125) )
          & ( v26995(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex124) )
          & ( v26995(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex123) )
          & ( v26995(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex122) )
          & ( v26995(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex121) )
          & ( v26995(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex120) )
          & ( v26995(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex119) )
          & ( v26995(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex118) )
          & ( v26995(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex117) )
          & ( v26995(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex116) )
          & ( v26995(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex115) )
          & ( v26995(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex114) )
          & ( v26995(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex113) )
          & ( v26995(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex112) )
          & ( v26995(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex111) )
          & ( v26995(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex110) )
          & ( v26995(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex109) )
          & ( v26995(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex108) )
          & ( v26995(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex107) )
          & ( v26995(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex106) )
          & ( v26995(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex105) )
          & ( v26995(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex104) )
          & ( v26995(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex103) )
          & ( v26995(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex102) )
          & ( v26995(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex101) )
          & ( v26995(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex100) )
          & ( v26995(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex99) )
          & ( v26995(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex98) )
          & ( v26995(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex97) )
          & ( v26995(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex96) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_440,axiom,
    ! [VarNext] :
      ( v26997(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v26995(VarNext,B)
          <=> v25320(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4675,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26997(VarNext)
      <=> ( v26998(VarNext)
          & v25315(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4674,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26998(VarNext)
      <=> ( v27000(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2491,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v27000(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11835,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex77)
      <=> v26987(VarNext,bitIndex29) )
      & ( v25244(VarNext,bitIndex76)
      <=> v26987(VarNext,bitIndex28) )
      & ( v25244(VarNext,bitIndex75)
      <=> v26987(VarNext,bitIndex27) )
      & ( v25244(VarNext,bitIndex74)
      <=> v26987(VarNext,bitIndex26) )
      & ( v25244(VarNext,bitIndex73)
      <=> v26987(VarNext,bitIndex25) )
      & ( v25244(VarNext,bitIndex72)
      <=> v26987(VarNext,bitIndex24) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_21,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26989(VarNext)
       => ( ( v26987(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex95) )
          & ( v26987(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex94) )
          & ( v26987(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex93) )
          & ( v26987(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex92) )
          & ( v26987(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex91) )
          & ( v26987(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex90) )
          & ( v26987(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex89) )
          & ( v26987(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex88) )
          & ( v26987(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex87) )
          & ( v26987(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex86) )
          & ( v26987(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex85) )
          & ( v26987(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex84) )
          & ( v26987(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex83) )
          & ( v26987(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex82) )
          & ( v26987(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex81) )
          & ( v26987(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex80) )
          & ( v26987(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex79) )
          & ( v26987(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex78) )
          & ( v26987(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex77) )
          & ( v26987(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex76) )
          & ( v26987(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex75) )
          & ( v26987(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex74) )
          & ( v26987(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex73) )
          & ( v26987(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex72) )
          & ( v26987(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex71) )
          & ( v26987(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex70) )
          & ( v26987(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex69) )
          & ( v26987(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex68) )
          & ( v26987(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex67) )
          & ( v26987(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex66) )
          & ( v26987(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex65) )
          & ( v26987(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex64) )
          & ( v26987(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex63) )
          & ( v26987(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex62) )
          & ( v26987(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex61) )
          & ( v26987(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex60) )
          & ( v26987(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex59) )
          & ( v26987(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex58) )
          & ( v26987(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex57) )
          & ( v26987(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex56) )
          & ( v26987(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex55) )
          & ( v26987(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex54) )
          & ( v26987(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex53) )
          & ( v26987(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex52) )
          & ( v26987(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex51) )
          & ( v26987(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex50) )
          & ( v26987(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex49) )
          & ( v26987(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex48) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_439,axiom,
    ! [VarNext] :
      ( v26989(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v26987(VarNext,B)
          <=> v25302(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4673,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26989(VarNext)
      <=> ( v26990(VarNext)
          & v25297(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4672,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26990(VarNext)
      <=> ( v26992(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2490,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26992(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11834,axiom,
    ! [VarCurr,B] :
      ( range_29_24(B)
     => ( v25280(VarCurr,B)
      <=> v25282(VarCurr,B) ) ) ).

fof(addAssignment_11833,axiom,
    ! [VarCurr,B] :
      ( range_29_24(B)
     => ( v25282(VarCurr,B)
      <=> v25284(VarCurr,B) ) ) ).

fof(addAssignment_11832,axiom,
    ! [VarCurr] :
      ( ( v25284(VarCurr,bitIndex29)
      <=> v25286(VarCurr,bitIndex36) )
      & ( v25284(VarCurr,bitIndex28)
      <=> v25286(VarCurr,bitIndex35) )
      & ( v25284(VarCurr,bitIndex27)
      <=> v25286(VarCurr,bitIndex34) )
      & ( v25284(VarCurr,bitIndex26)
      <=> v25286(VarCurr,bitIndex33) )
      & ( v25284(VarCurr,bitIndex25)
      <=> v25286(VarCurr,bitIndex32) )
      & ( v25284(VarCurr,bitIndex24)
      <=> v25286(VarCurr,bitIndex31) ) ) ).

fof(addAssignment_11831,axiom,
    ! [VarCurr] :
      ( ( v25286(VarCurr,bitIndex36)
      <=> v24386(VarCurr,bitIndex100) )
      & ( v25286(VarCurr,bitIndex35)
      <=> v24386(VarCurr,bitIndex99) )
      & ( v25286(VarCurr,bitIndex34)
      <=> v24386(VarCurr,bitIndex98) )
      & ( v25286(VarCurr,bitIndex33)
      <=> v24386(VarCurr,bitIndex97) )
      & ( v25286(VarCurr,bitIndex32)
      <=> v24386(VarCurr,bitIndex96) )
      & ( v25286(VarCurr,bitIndex31)
      <=> v24386(VarCurr,bitIndex95) ) ) ).

fof(addAssignment_11830,axiom,
    ! [VarNext,B] :
      ( range_29_24(B)
     => ( v25244(VarNext,B)
      <=> v26979(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_485,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26981(VarNext)
       => ! [B] :
            ( range_47_0(B)
           => ( v26979(VarNext,B)
            <=> v25244(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_438,axiom,
    ! [VarNext] :
      ( v26981(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v26979(VarNext,B)
          <=> v25276(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4671,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26981(VarNext)
      <=> ( v26982(VarNext)
          & v25270(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4670,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26982(VarNext)
      <=> ( v26984(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2489,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26984(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11829,axiom,
    ! [VarCurr,B] :
      ( range_29_24(B)
     => ( v25255(VarCurr,B)
      <=> v25257(VarCurr,B) ) ) ).

fof(addAssignment_11828,axiom,
    ! [VarCurr,B] :
      ( range_29_24(B)
     => ( v25257(VarCurr,B)
      <=> v25259(VarCurr,B) ) ) ).

fof(range_axiom_224,axiom,
    ! [B] :
      ( range_29_24(B)
    <=> ( $false
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B ) ) ).

fof(addAssignment_11827,axiom,
    ! [VarCurr] :
      ( ( v25259(VarCurr,bitIndex29)
      <=> v24386(VarCurr,bitIndex36) )
      & ( v25259(VarCurr,bitIndex28)
      <=> v24386(VarCurr,bitIndex35) )
      & ( v25259(VarCurr,bitIndex27)
      <=> v24386(VarCurr,bitIndex34) )
      & ( v25259(VarCurr,bitIndex26)
      <=> v24386(VarCurr,bitIndex33) )
      & ( v25259(VarCurr,bitIndex25)
      <=> v24386(VarCurr,bitIndex32) )
      & ( v25259(VarCurr,bitIndex24)
      <=> v24386(VarCurr,bitIndex31) ) ) ).

fof(addAssignment_11826,axiom,
    ! [VarCurr,B] :
      ( range_35_32(B)
     => ( v212(VarCurr,B)
      <=> v25522(VarCurr,B) ) ) ).

fof(addAssignment_11825,axiom,
    ! [VarCurr,B] :
      ( range_35_32(B)
     => ( v25515(VarCurr,B)
      <=> v25517(VarCurr,B) ) ) ).

fof(addAssignment_11824,axiom,
    ! [VarCurr,B] :
      ( range_35_32(B)
     => ( v25517(VarCurr,B)
      <=> v25519(VarCurr,B) ) ) ).

fof(addAssignment_11823,axiom,
    ! [VarCurr,B] :
      ( range_35_32(B)
     => ( v25519(VarCurr,B)
      <=> v25521(VarCurr,B) ) ) ).

fof(addAssignment_11822,axiom,
    ! [VarCurr] :
      ( ( v25521(VarCurr,bitIndex35)
      <=> v4847(VarCurr,bitIndex51) )
      & ( v25521(VarCurr,bitIndex34)
      <=> v4847(VarCurr,bitIndex50) )
      & ( v25521(VarCurr,bitIndex33)
      <=> v4847(VarCurr,bitIndex49) )
      & ( v25521(VarCurr,bitIndex32)
      <=> v4847(VarCurr,bitIndex48) ) ) ).

fof(addAssignment_11821,axiom,
    ! [VarCurr,B] :
      ( range_35_32(B)
     => ( v25236(VarCurr,B)
      <=> v25238(VarCurr,B) ) ) ).

fof(addAssignment_11820,axiom,
    ! [VarCurr,B] :
      ( range_35_32(B)
     => ( v25238(VarCurr,B)
      <=> v25240(VarCurr,B) ) ) ).

fof(addAssignment_11819,axiom,
    ! [VarCurr,B] :
      ( range_35_32(B)
     => ( v25240(VarCurr,B)
      <=> v25242(VarCurr,B) ) ) ).

fof(addAssignment_11818,axiom,
    ! [VarCurr,B] :
      ( range_35_32(B)
     => ( v25242(VarCurr,B)
      <=> v25504(VarCurr,B) ) ) ).

fof(addAssignment_11817,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex371)
      <=> v26971(VarNext,bitIndex35) )
      & ( v25244(VarNext,bitIndex370)
      <=> v26971(VarNext,bitIndex34) )
      & ( v25244(VarNext,bitIndex369)
      <=> v26971(VarNext,bitIndex33) )
      & ( v25244(VarNext,bitIndex368)
      <=> v26971(VarNext,bitIndex32) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_20,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26973(VarNext)
       => ( ( v26971(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex383) )
          & ( v26971(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex382) )
          & ( v26971(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex381) )
          & ( v26971(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex380) )
          & ( v26971(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex379) )
          & ( v26971(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex378) )
          & ( v26971(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex377) )
          & ( v26971(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex376) )
          & ( v26971(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex375) )
          & ( v26971(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex374) )
          & ( v26971(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex373) )
          & ( v26971(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex372) )
          & ( v26971(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex371) )
          & ( v26971(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex370) )
          & ( v26971(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex369) )
          & ( v26971(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex368) )
          & ( v26971(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex367) )
          & ( v26971(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex366) )
          & ( v26971(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex365) )
          & ( v26971(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex364) )
          & ( v26971(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex363) )
          & ( v26971(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex362) )
          & ( v26971(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex361) )
          & ( v26971(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex360) )
          & ( v26971(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex359) )
          & ( v26971(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex358) )
          & ( v26971(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex357) )
          & ( v26971(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex356) )
          & ( v26971(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex355) )
          & ( v26971(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex354) )
          & ( v26971(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex353) )
          & ( v26971(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex352) )
          & ( v26971(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex351) )
          & ( v26971(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex350) )
          & ( v26971(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex349) )
          & ( v26971(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex348) )
          & ( v26971(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex347) )
          & ( v26971(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex346) )
          & ( v26971(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex345) )
          & ( v26971(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex344) )
          & ( v26971(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex343) )
          & ( v26971(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex342) )
          & ( v26971(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex341) )
          & ( v26971(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex340) )
          & ( v26971(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex339) )
          & ( v26971(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex338) )
          & ( v26971(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex337) )
          & ( v26971(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex336) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_437,axiom,
    ! [VarNext] :
      ( v26973(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v26971(VarNext,B)
          <=> v25410(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4669,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26973(VarNext)
      <=> ( v26974(VarNext)
          & v25405(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4668,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26974(VarNext)
      <=> ( v26976(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2488,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26976(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11816,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex323)
      <=> v26963(VarNext,bitIndex35) )
      & ( v25244(VarNext,bitIndex322)
      <=> v26963(VarNext,bitIndex34) )
      & ( v25244(VarNext,bitIndex321)
      <=> v26963(VarNext,bitIndex33) )
      & ( v25244(VarNext,bitIndex320)
      <=> v26963(VarNext,bitIndex32) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_19,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26965(VarNext)
       => ( ( v26963(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex335) )
          & ( v26963(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex334) )
          & ( v26963(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex333) )
          & ( v26963(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex332) )
          & ( v26963(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex331) )
          & ( v26963(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex330) )
          & ( v26963(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex329) )
          & ( v26963(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex328) )
          & ( v26963(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex327) )
          & ( v26963(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex326) )
          & ( v26963(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex325) )
          & ( v26963(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex324) )
          & ( v26963(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex323) )
          & ( v26963(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex322) )
          & ( v26963(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex321) )
          & ( v26963(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex320) )
          & ( v26963(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex319) )
          & ( v26963(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex318) )
          & ( v26963(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex317) )
          & ( v26963(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex316) )
          & ( v26963(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex315) )
          & ( v26963(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex314) )
          & ( v26963(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex313) )
          & ( v26963(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex312) )
          & ( v26963(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex311) )
          & ( v26963(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex310) )
          & ( v26963(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex309) )
          & ( v26963(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex308) )
          & ( v26963(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex307) )
          & ( v26963(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex306) )
          & ( v26963(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex305) )
          & ( v26963(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex304) )
          & ( v26963(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex303) )
          & ( v26963(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex302) )
          & ( v26963(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex301) )
          & ( v26963(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex300) )
          & ( v26963(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex299) )
          & ( v26963(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex298) )
          & ( v26963(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex297) )
          & ( v26963(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex296) )
          & ( v26963(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex295) )
          & ( v26963(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex294) )
          & ( v26963(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex293) )
          & ( v26963(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex292) )
          & ( v26963(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex291) )
          & ( v26963(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex290) )
          & ( v26963(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex289) )
          & ( v26963(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex288) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_436,axiom,
    ! [VarNext] :
      ( v26965(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v26963(VarNext,B)
          <=> v25392(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4667,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26965(VarNext)
      <=> ( v26966(VarNext)
          & v25387(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4666,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26966(VarNext)
      <=> ( v26968(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2487,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26968(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11815,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex275)
      <=> v26955(VarNext,bitIndex35) )
      & ( v25244(VarNext,bitIndex274)
      <=> v26955(VarNext,bitIndex34) )
      & ( v25244(VarNext,bitIndex273)
      <=> v26955(VarNext,bitIndex33) )
      & ( v25244(VarNext,bitIndex272)
      <=> v26955(VarNext,bitIndex32) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_18,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26957(VarNext)
       => ( ( v26955(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex287) )
          & ( v26955(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex286) )
          & ( v26955(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex285) )
          & ( v26955(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex284) )
          & ( v26955(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex283) )
          & ( v26955(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex282) )
          & ( v26955(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex281) )
          & ( v26955(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex280) )
          & ( v26955(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex279) )
          & ( v26955(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex278) )
          & ( v26955(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex277) )
          & ( v26955(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex276) )
          & ( v26955(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex275) )
          & ( v26955(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex274) )
          & ( v26955(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex273) )
          & ( v26955(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex272) )
          & ( v26955(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex271) )
          & ( v26955(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex270) )
          & ( v26955(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex269) )
          & ( v26955(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex268) )
          & ( v26955(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex267) )
          & ( v26955(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex266) )
          & ( v26955(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex265) )
          & ( v26955(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex264) )
          & ( v26955(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex263) )
          & ( v26955(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex262) )
          & ( v26955(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex261) )
          & ( v26955(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex260) )
          & ( v26955(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex259) )
          & ( v26955(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex258) )
          & ( v26955(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex257) )
          & ( v26955(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex256) )
          & ( v26955(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex255) )
          & ( v26955(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex254) )
          & ( v26955(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex253) )
          & ( v26955(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex252) )
          & ( v26955(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex251) )
          & ( v26955(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex250) )
          & ( v26955(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex249) )
          & ( v26955(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex248) )
          & ( v26955(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex247) )
          & ( v26955(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex246) )
          & ( v26955(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex245) )
          & ( v26955(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex244) )
          & ( v26955(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex243) )
          & ( v26955(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex242) )
          & ( v26955(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex241) )
          & ( v26955(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex240) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_435,axiom,
    ! [VarNext] :
      ( v26957(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v26955(VarNext,B)
          <=> v25374(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4665,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26957(VarNext)
      <=> ( v26958(VarNext)
          & v25369(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4664,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26958(VarNext)
      <=> ( v26960(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2486,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26960(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11814,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex227)
      <=> v26947(VarNext,bitIndex35) )
      & ( v25244(VarNext,bitIndex226)
      <=> v26947(VarNext,bitIndex34) )
      & ( v25244(VarNext,bitIndex225)
      <=> v26947(VarNext,bitIndex33) )
      & ( v25244(VarNext,bitIndex224)
      <=> v26947(VarNext,bitIndex32) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_17,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26949(VarNext)
       => ( ( v26947(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex239) )
          & ( v26947(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex238) )
          & ( v26947(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex237) )
          & ( v26947(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex236) )
          & ( v26947(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex235) )
          & ( v26947(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex234) )
          & ( v26947(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex233) )
          & ( v26947(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex232) )
          & ( v26947(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex231) )
          & ( v26947(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex230) )
          & ( v26947(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex229) )
          & ( v26947(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex228) )
          & ( v26947(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex227) )
          & ( v26947(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex226) )
          & ( v26947(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex225) )
          & ( v26947(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex224) )
          & ( v26947(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex223) )
          & ( v26947(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex222) )
          & ( v26947(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex221) )
          & ( v26947(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex220) )
          & ( v26947(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex219) )
          & ( v26947(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex218) )
          & ( v26947(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex217) )
          & ( v26947(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex216) )
          & ( v26947(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex215) )
          & ( v26947(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex214) )
          & ( v26947(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex213) )
          & ( v26947(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex212) )
          & ( v26947(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex211) )
          & ( v26947(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex210) )
          & ( v26947(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex209) )
          & ( v26947(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex208) )
          & ( v26947(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex207) )
          & ( v26947(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex206) )
          & ( v26947(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex205) )
          & ( v26947(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex204) )
          & ( v26947(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex203) )
          & ( v26947(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex202) )
          & ( v26947(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex201) )
          & ( v26947(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex200) )
          & ( v26947(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex199) )
          & ( v26947(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex198) )
          & ( v26947(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex197) )
          & ( v26947(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex196) )
          & ( v26947(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex195) )
          & ( v26947(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex194) )
          & ( v26947(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex193) )
          & ( v26947(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex192) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_434,axiom,
    ! [VarNext] :
      ( v26949(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v26947(VarNext,B)
          <=> v25356(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4663,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26949(VarNext)
      <=> ( v26950(VarNext)
          & v25351(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4662,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26950(VarNext)
      <=> ( v26952(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2485,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26952(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11813,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex179)
      <=> v26939(VarNext,bitIndex35) )
      & ( v25244(VarNext,bitIndex178)
      <=> v26939(VarNext,bitIndex34) )
      & ( v25244(VarNext,bitIndex177)
      <=> v26939(VarNext,bitIndex33) )
      & ( v25244(VarNext,bitIndex176)
      <=> v26939(VarNext,bitIndex32) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_16,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26941(VarNext)
       => ( ( v26939(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex191) )
          & ( v26939(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex190) )
          & ( v26939(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex189) )
          & ( v26939(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex188) )
          & ( v26939(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex187) )
          & ( v26939(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex186) )
          & ( v26939(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex185) )
          & ( v26939(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex184) )
          & ( v26939(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex183) )
          & ( v26939(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex182) )
          & ( v26939(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex181) )
          & ( v26939(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex180) )
          & ( v26939(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex179) )
          & ( v26939(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex178) )
          & ( v26939(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex177) )
          & ( v26939(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex176) )
          & ( v26939(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex175) )
          & ( v26939(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex174) )
          & ( v26939(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex173) )
          & ( v26939(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex172) )
          & ( v26939(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex171) )
          & ( v26939(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex170) )
          & ( v26939(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex169) )
          & ( v26939(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex168) )
          & ( v26939(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex167) )
          & ( v26939(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex166) )
          & ( v26939(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex165) )
          & ( v26939(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex164) )
          & ( v26939(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex163) )
          & ( v26939(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex162) )
          & ( v26939(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex161) )
          & ( v26939(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex160) )
          & ( v26939(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex159) )
          & ( v26939(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex158) )
          & ( v26939(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex157) )
          & ( v26939(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex156) )
          & ( v26939(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex155) )
          & ( v26939(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex154) )
          & ( v26939(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex153) )
          & ( v26939(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex152) )
          & ( v26939(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex151) )
          & ( v26939(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex150) )
          & ( v26939(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex149) )
          & ( v26939(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex148) )
          & ( v26939(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex147) )
          & ( v26939(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex146) )
          & ( v26939(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex145) )
          & ( v26939(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex144) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_433,axiom,
    ! [VarNext] :
      ( v26941(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v26939(VarNext,B)
          <=> v25338(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4661,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26941(VarNext)
      <=> ( v26942(VarNext)
          & v25333(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4660,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26942(VarNext)
      <=> ( v26944(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2484,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26944(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11812,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex131)
      <=> v26931(VarNext,bitIndex35) )
      & ( v25244(VarNext,bitIndex130)
      <=> v26931(VarNext,bitIndex34) )
      & ( v25244(VarNext,bitIndex129)
      <=> v26931(VarNext,bitIndex33) )
      & ( v25244(VarNext,bitIndex128)
      <=> v26931(VarNext,bitIndex32) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_15,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26933(VarNext)
       => ( ( v26931(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex143) )
          & ( v26931(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex142) )
          & ( v26931(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex141) )
          & ( v26931(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex140) )
          & ( v26931(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex139) )
          & ( v26931(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex138) )
          & ( v26931(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex137) )
          & ( v26931(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex136) )
          & ( v26931(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex135) )
          & ( v26931(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex134) )
          & ( v26931(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex133) )
          & ( v26931(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex132) )
          & ( v26931(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex131) )
          & ( v26931(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex130) )
          & ( v26931(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex129) )
          & ( v26931(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex128) )
          & ( v26931(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex127) )
          & ( v26931(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex126) )
          & ( v26931(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex125) )
          & ( v26931(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex124) )
          & ( v26931(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex123) )
          & ( v26931(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex122) )
          & ( v26931(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex121) )
          & ( v26931(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex120) )
          & ( v26931(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex119) )
          & ( v26931(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex118) )
          & ( v26931(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex117) )
          & ( v26931(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex116) )
          & ( v26931(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex115) )
          & ( v26931(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex114) )
          & ( v26931(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex113) )
          & ( v26931(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex112) )
          & ( v26931(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex111) )
          & ( v26931(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex110) )
          & ( v26931(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex109) )
          & ( v26931(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex108) )
          & ( v26931(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex107) )
          & ( v26931(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex106) )
          & ( v26931(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex105) )
          & ( v26931(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex104) )
          & ( v26931(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex103) )
          & ( v26931(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex102) )
          & ( v26931(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex101) )
          & ( v26931(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex100) )
          & ( v26931(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex99) )
          & ( v26931(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex98) )
          & ( v26931(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex97) )
          & ( v26931(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex96) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_432,axiom,
    ! [VarNext] :
      ( v26933(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v26931(VarNext,B)
          <=> v25320(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4659,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26933(VarNext)
      <=> ( v26934(VarNext)
          & v25315(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4658,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26934(VarNext)
      <=> ( v26936(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2483,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26936(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11811,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex83)
      <=> v26923(VarNext,bitIndex35) )
      & ( v25244(VarNext,bitIndex82)
      <=> v26923(VarNext,bitIndex34) )
      & ( v25244(VarNext,bitIndex81)
      <=> v26923(VarNext,bitIndex33) )
      & ( v25244(VarNext,bitIndex80)
      <=> v26923(VarNext,bitIndex32) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_14,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26925(VarNext)
       => ( ( v26923(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex95) )
          & ( v26923(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex94) )
          & ( v26923(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex93) )
          & ( v26923(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex92) )
          & ( v26923(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex91) )
          & ( v26923(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex90) )
          & ( v26923(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex89) )
          & ( v26923(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex88) )
          & ( v26923(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex87) )
          & ( v26923(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex86) )
          & ( v26923(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex85) )
          & ( v26923(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex84) )
          & ( v26923(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex83) )
          & ( v26923(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex82) )
          & ( v26923(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex81) )
          & ( v26923(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex80) )
          & ( v26923(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex79) )
          & ( v26923(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex78) )
          & ( v26923(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex77) )
          & ( v26923(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex76) )
          & ( v26923(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex75) )
          & ( v26923(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex74) )
          & ( v26923(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex73) )
          & ( v26923(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex72) )
          & ( v26923(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex71) )
          & ( v26923(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex70) )
          & ( v26923(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex69) )
          & ( v26923(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex68) )
          & ( v26923(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex67) )
          & ( v26923(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex66) )
          & ( v26923(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex65) )
          & ( v26923(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex64) )
          & ( v26923(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex63) )
          & ( v26923(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex62) )
          & ( v26923(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex61) )
          & ( v26923(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex60) )
          & ( v26923(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex59) )
          & ( v26923(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex58) )
          & ( v26923(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex57) )
          & ( v26923(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex56) )
          & ( v26923(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex55) )
          & ( v26923(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex54) )
          & ( v26923(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex53) )
          & ( v26923(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex52) )
          & ( v26923(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex51) )
          & ( v26923(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex50) )
          & ( v26923(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex49) )
          & ( v26923(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex48) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_431,axiom,
    ! [VarNext] :
      ( v26925(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v26923(VarNext,B)
          <=> v25302(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4657,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26925(VarNext)
      <=> ( v26926(VarNext)
          & v25297(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4656,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26926(VarNext)
      <=> ( v26928(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2482,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26928(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11810,axiom,
    ! [VarCurr,B] :
      ( range_35_32(B)
     => ( v25280(VarCurr,B)
      <=> v25282(VarCurr,B) ) ) ).

fof(addAssignment_11809,axiom,
    ! [VarCurr,B] :
      ( range_35_32(B)
     => ( v25282(VarCurr,B)
      <=> v25284(VarCurr,B) ) ) ).

fof(addAssignment_11808,axiom,
    ! [VarCurr] :
      ( ( v25284(VarCurr,bitIndex35)
      <=> v25286(VarCurr,bitIndex51) )
      & ( v25284(VarCurr,bitIndex34)
      <=> v25286(VarCurr,bitIndex50) )
      & ( v25284(VarCurr,bitIndex33)
      <=> v25286(VarCurr,bitIndex49) )
      & ( v25284(VarCurr,bitIndex32)
      <=> v25286(VarCurr,bitIndex48) ) ) ).

fof(addAssignment_11807,axiom,
    ! [VarCurr] :
      ( ( v25286(VarCurr,bitIndex51)
      <=> v24386(VarCurr,bitIndex115) )
      & ( v25286(VarCurr,bitIndex50)
      <=> v24386(VarCurr,bitIndex114) )
      & ( v25286(VarCurr,bitIndex49)
      <=> v24386(VarCurr,bitIndex113) )
      & ( v25286(VarCurr,bitIndex48)
      <=> v24386(VarCurr,bitIndex112) ) ) ).

fof(addAssignment_11806,axiom,
    ! [VarNext,B] :
      ( range_35_32(B)
     => ( v25244(VarNext,B)
      <=> v26915(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_484,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26917(VarNext)
       => ! [B] :
            ( range_47_0(B)
           => ( v26915(VarNext,B)
            <=> v25244(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_430,axiom,
    ! [VarNext] :
      ( v26917(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v26915(VarNext,B)
          <=> v25276(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4655,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26917(VarNext)
      <=> ( v26918(VarNext)
          & v25270(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4654,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26918(VarNext)
      <=> ( v26920(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2481,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26920(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11805,axiom,
    ! [VarCurr,B] :
      ( range_35_32(B)
     => ( v25255(VarCurr,B)
      <=> v25257(VarCurr,B) ) ) ).

fof(addAssignment_11804,axiom,
    ! [VarCurr,B] :
      ( range_35_32(B)
     => ( v25257(VarCurr,B)
      <=> v25259(VarCurr,B) ) ) ).

fof(range_axiom_223,axiom,
    ! [B] :
      ( range_35_32(B)
    <=> ( $false
        | bitIndex32 = B
        | bitIndex33 = B
        | bitIndex34 = B
        | bitIndex35 = B ) ) ).

fof(addAssignment_11803,axiom,
    ! [VarCurr] :
      ( ( v25259(VarCurr,bitIndex35)
      <=> v24386(VarCurr,bitIndex51) )
      & ( v25259(VarCurr,bitIndex34)
      <=> v24386(VarCurr,bitIndex50) )
      & ( v25259(VarCurr,bitIndex33)
      <=> v24386(VarCurr,bitIndex49) )
      & ( v25259(VarCurr,bitIndex32)
      <=> v24386(VarCurr,bitIndex48) ) ) ).

fof(addAssignment_11802,axiom,
    ! [VarCurr] :
      ( v26911(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_11801,axiom,
    ! [VarCurr] :
      ( v26909(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_483,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26890(VarNext)
       => ( v26755(VarNext)
        <=> v26755(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_429,axiom,
    ! [VarNext] :
      ( v26890(VarNext)
     => ( v26755(VarNext)
      <=> v26900(VarNext) ) ) ).

fof(addAssignment_11800,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26900(VarNext)
      <=> v26898(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_754,axiom,
    ! [VarCurr] :
      ( ~ v26901(VarCurr)
     => ( v26898(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_508,axiom,
    ! [VarCurr] :
      ( v26901(VarCurr)
     => ( v26898(VarCurr)
      <=> v26761(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4653,axiom,
    ! [VarCurr] :
      ( v26901(VarCurr)
    <=> ( v26902(VarCurr)
        & v26903(VarCurr) ) ) ).

fof(writeUnaryOperator_2480,axiom,
    ! [VarCurr] :
      ( ~ v26903(VarCurr)
    <=> v26759(VarCurr) ) ).

fof(writeUnaryOperator_2479,axiom,
    ! [VarCurr] :
      ( ~ v26902(VarCurr)
    <=> v26757(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4652,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26890(VarNext)
      <=> v26891(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4651,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26891(VarNext)
      <=> ( v26892(VarNext)
          & v26887(VarNext) ) ) ) ).

fof(writeUnaryOperator_2478,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26892(VarNext)
      <=> v26894(VarNext) ) ) ).

fof(addAssignment_11799,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26894(VarNext)
      <=> v26887(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_986,axiom,
    ( v26755(constB0)
  <=> $false ) ).

fof(addAssignment_11798,axiom,
    ! [VarCurr] :
      ( v26887(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_11797,axiom,
    ! [VarCurr] :
      ( v26761(VarCurr)
    <=> v202(VarCurr,bitIndex51) ) ).

fof(addAssignment_11796,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex51)
    <=> v204(VarCurr,bitIndex51) ) ).

fof(addAssignment_11795,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex51)
    <=> v25523(VarCurr,bitIndex51) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_547,axiom,
    ! [VarCurr] :
      ( ~ v26763(VarCurr,bitIndex3)
     => ( v212(VarCurr,bitIndex51)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_793,axiom,
    ! [VarCurr] :
      ( v26763(VarCurr,bitIndex3)
     => ( v212(VarCurr,bitIndex51)
      <=> $false ) ) ).

fof(writeBinaryOperatorShiftedRanges_1233,axiom,
    ! [VarCurr] :
      ( v26763(VarCurr,bitIndex3)
    <=> ( v26830(VarCurr)
        & v26884(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4650,axiom,
    ! [VarCurr] :
      ( v26884(VarCurr)
    <=> ( v26832(VarCurr)
        | v26849(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4649,axiom,
    ! [VarCurr] :
      ( v26830(VarCurr)
    <=> ( v26831(VarCurr)
        | v26848(VarCurr) ) ) ).

fof(writeUnaryOperator_2477,axiom,
    ! [VarCurr] :
      ( ~ v26848(VarCurr)
    <=> v26849(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4648,axiom,
    ! [VarCurr] :
      ( v26849(VarCurr)
    <=> ( v26850(VarCurr)
        & v26883(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4647,axiom,
    ! [VarCurr] :
      ( v26883(VarCurr)
    <=> ( v26852(VarCurr)
        | v26868(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4646,axiom,
    ! [VarCurr] :
      ( v26850(VarCurr)
    <=> ( v26851(VarCurr)
        | v26867(VarCurr) ) ) ).

fof(writeUnaryOperator_2476,axiom,
    ! [VarCurr] :
      ( ~ v26867(VarCurr)
    <=> v26868(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4645,axiom,
    ! [VarCurr] :
      ( v26868(VarCurr)
    <=> ( v26869(VarCurr)
        & v26882(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1232,axiom,
    ! [VarCurr] :
      ( v26882(VarCurr)
    <=> ( v26835(VarCurr,bitIndex7)
        | v26872(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4644,axiom,
    ! [VarCurr] :
      ( v26869(VarCurr)
    <=> ( v26870(VarCurr)
        | v26871(VarCurr) ) ) ).

fof(writeUnaryOperator_2475,axiom,
    ! [VarCurr] :
      ( ~ v26871(VarCurr)
    <=> v26872(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4643,axiom,
    ! [VarCurr] :
      ( v26872(VarCurr)
    <=> ( v26873(VarCurr)
        & v26881(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1231,axiom,
    ! [VarCurr] :
      ( v26881(VarCurr)
    <=> ( v26835(VarCurr,bitIndex6)
        | v26876(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4642,axiom,
    ! [VarCurr] :
      ( v26873(VarCurr)
    <=> ( v26874(VarCurr)
        | v26875(VarCurr) ) ) ).

fof(writeUnaryOperator_2474,axiom,
    ! [VarCurr] :
      ( ~ v26875(VarCurr)
    <=> v26876(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4641,axiom,
    ! [VarCurr] :
      ( v26876(VarCurr)
    <=> ( v26877(VarCurr)
        & v26880(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1230,axiom,
    ! [VarCurr] :
      ( v26880(VarCurr)
    <=> ( v26835(VarCurr,bitIndex4)
        | v26835(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4640,axiom,
    ! [VarCurr] :
      ( v26877(VarCurr)
    <=> ( v26878(VarCurr)
        | v26879(VarCurr) ) ) ).

fof(writeUnaryOperator_2473,axiom,
    ! [VarCurr] :
      ( ~ v26879(VarCurr)
    <=> v26835(VarCurr,bitIndex5) ) ).

fof(writeUnaryOperator_2472,axiom,
    ! [VarCurr] :
      ( ~ v26878(VarCurr)
    <=> v26835(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_2471,axiom,
    ! [VarCurr] :
      ( ~ v26874(VarCurr)
    <=> v26835(VarCurr,bitIndex6) ) ).

fof(writeUnaryOperator_2470,axiom,
    ! [VarCurr] :
      ( ~ v26870(VarCurr)
    <=> v26835(VarCurr,bitIndex7) ) ).

fof(writeUnaryOperator_2469,axiom,
    ! [VarCurr] :
      ( ~ v26851(VarCurr)
    <=> v26852(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4639,axiom,
    ! [VarCurr] :
      ( v26852(VarCurr)
    <=> ( v26853(VarCurr)
        & v26866(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1229,axiom,
    ! [VarCurr] :
      ( v26866(VarCurr)
    <=> ( v26835(VarCurr,bitIndex3)
        | v26856(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4638,axiom,
    ! [VarCurr] :
      ( v26853(VarCurr)
    <=> ( v26854(VarCurr)
        | v26855(VarCurr) ) ) ).

fof(writeUnaryOperator_2468,axiom,
    ! [VarCurr] :
      ( ~ v26855(VarCurr)
    <=> v26856(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4637,axiom,
    ! [VarCurr] :
      ( v26856(VarCurr)
    <=> ( v26857(VarCurr)
        & v26865(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1228,axiom,
    ! [VarCurr] :
      ( v26865(VarCurr)
    <=> ( v26835(VarCurr,bitIndex2)
        | v26860(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4636,axiom,
    ! [VarCurr] :
      ( v26857(VarCurr)
    <=> ( v26858(VarCurr)
        | v26859(VarCurr) ) ) ).

fof(writeUnaryOperator_2467,axiom,
    ! [VarCurr] :
      ( ~ v26859(VarCurr)
    <=> v26860(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4635,axiom,
    ! [VarCurr] :
      ( v26860(VarCurr)
    <=> ( v26861(VarCurr)
        & v26864(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1227,axiom,
    ! [VarCurr] :
      ( v26864(VarCurr)
    <=> ( v26835(VarCurr,bitIndex0)
        | v26835(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4634,axiom,
    ! [VarCurr] :
      ( v26861(VarCurr)
    <=> ( v26862(VarCurr)
        | v26863(VarCurr) ) ) ).

fof(writeUnaryOperator_2466,axiom,
    ! [VarCurr] :
      ( ~ v26863(VarCurr)
    <=> v26835(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_2465,axiom,
    ! [VarCurr] :
      ( ~ v26862(VarCurr)
    <=> v26835(VarCurr,bitIndex0) ) ).

fof(writeUnaryOperator_2464,axiom,
    ! [VarCurr] :
      ( ~ v26858(VarCurr)
    <=> v26835(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_2463,axiom,
    ! [VarCurr] :
      ( ~ v26854(VarCurr)
    <=> v26835(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_2462,axiom,
    ! [VarCurr] :
      ( ~ v26831(VarCurr)
    <=> v26832(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4633,axiom,
    ! [VarCurr] :
      ( v26832(VarCurr)
    <=> ( v26833(VarCurr)
        & v26847(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1226,axiom,
    ! [VarCurr] :
      ( v26847(VarCurr)
    <=> ( v26835(VarCurr,bitIndex11)
        | v26837(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4632,axiom,
    ! [VarCurr] :
      ( v26833(VarCurr)
    <=> ( v26834(VarCurr)
        | v26836(VarCurr) ) ) ).

fof(writeUnaryOperator_2461,axiom,
    ! [VarCurr] :
      ( ~ v26836(VarCurr)
    <=> v26837(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4631,axiom,
    ! [VarCurr] :
      ( v26837(VarCurr)
    <=> ( v26838(VarCurr)
        & v26846(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1225,axiom,
    ! [VarCurr] :
      ( v26846(VarCurr)
    <=> ( v26835(VarCurr,bitIndex10)
        | v26841(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4630,axiom,
    ! [VarCurr] :
      ( v26838(VarCurr)
    <=> ( v26839(VarCurr)
        | v26840(VarCurr) ) ) ).

fof(writeUnaryOperator_2460,axiom,
    ! [VarCurr] :
      ( ~ v26840(VarCurr)
    <=> v26841(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4629,axiom,
    ! [VarCurr] :
      ( v26841(VarCurr)
    <=> ( v26842(VarCurr)
        & v26845(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1224,axiom,
    ! [VarCurr] :
      ( v26845(VarCurr)
    <=> ( v26835(VarCurr,bitIndex8)
        | v26835(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4628,axiom,
    ! [VarCurr] :
      ( v26842(VarCurr)
    <=> ( v26843(VarCurr)
        | v26844(VarCurr) ) ) ).

fof(writeUnaryOperator_2459,axiom,
    ! [VarCurr] :
      ( ~ v26844(VarCurr)
    <=> v26835(VarCurr,bitIndex9) ) ).

fof(writeUnaryOperator_2458,axiom,
    ! [VarCurr] :
      ( ~ v26843(VarCurr)
    <=> v26835(VarCurr,bitIndex8) ) ).

fof(writeUnaryOperator_2457,axiom,
    ! [VarCurr] :
      ( ~ v26839(VarCurr)
    <=> v26835(VarCurr,bitIndex10) ) ).

fof(writeUnaryOperator_2456,axiom,
    ! [VarCurr] :
      ( ~ v26834(VarCurr)
    <=> v26835(VarCurr,bitIndex11) ) ).

fof(addAssignment_11794,axiom,
    ! [VarCurr] :
      ( ( v26835(VarCurr,bitIndex11)
      <=> v212(VarCurr,bitIndex47) )
      & ( v26835(VarCurr,bitIndex10)
      <=> v212(VarCurr,bitIndex46) )
      & ( v26835(VarCurr,bitIndex9)
      <=> v212(VarCurr,bitIndex45) )
      & ( v26835(VarCurr,bitIndex8)
      <=> v212(VarCurr,bitIndex44) )
      & ( v26835(VarCurr,bitIndex7)
      <=> v212(VarCurr,bitIndex43) )
      & ( v26835(VarCurr,bitIndex6)
      <=> v212(VarCurr,bitIndex42) )
      & ( v26835(VarCurr,bitIndex5)
      <=> v212(VarCurr,bitIndex41) )
      & ( v26835(VarCurr,bitIndex4)
      <=> v212(VarCurr,bitIndex40) )
      & ( v26835(VarCurr,bitIndex3)
      <=> v212(VarCurr,bitIndex39) )
      & ( v26835(VarCurr,bitIndex2)
      <=> v212(VarCurr,bitIndex38) )
      & ( v26835(VarCurr,bitIndex1)
      <=> v212(VarCurr,bitIndex37) )
      & ( v26835(VarCurr,bitIndex0)
      <=> v212(VarCurr,bitIndex36) ) ) ).

fof(addAssignment_11793,axiom,
    ! [VarCurr,B] :
      ( range_47_36(B)
     => ( v212(VarCurr,B)
      <=> v25522(VarCurr,B) ) ) ).

fof(addAssignment_11792,axiom,
    ! [VarCurr,B] :
      ( range_47_36(B)
     => ( v25515(VarCurr,B)
      <=> v25517(VarCurr,B) ) ) ).

fof(addAssignment_11791,axiom,
    ! [VarCurr,B] :
      ( range_47_36(B)
     => ( v25517(VarCurr,B)
      <=> v25519(VarCurr,B) ) ) ).

fof(addAssignment_11790,axiom,
    ! [VarCurr,B] :
      ( range_47_36(B)
     => ( v25519(VarCurr,B)
      <=> v25521(VarCurr,B) ) ) ).

fof(addAssignment_11789,axiom,
    ! [VarCurr] :
      ( ( v25521(VarCurr,bitIndex47)
      <=> v4847(VarCurr,bitIndex63) )
      & ( v25521(VarCurr,bitIndex46)
      <=> v4847(VarCurr,bitIndex62) )
      & ( v25521(VarCurr,bitIndex45)
      <=> v4847(VarCurr,bitIndex61) )
      & ( v25521(VarCurr,bitIndex44)
      <=> v4847(VarCurr,bitIndex60) )
      & ( v25521(VarCurr,bitIndex43)
      <=> v4847(VarCurr,bitIndex59) )
      & ( v25521(VarCurr,bitIndex42)
      <=> v4847(VarCurr,bitIndex58) )
      & ( v25521(VarCurr,bitIndex41)
      <=> v4847(VarCurr,bitIndex57) )
      & ( v25521(VarCurr,bitIndex40)
      <=> v4847(VarCurr,bitIndex56) )
      & ( v25521(VarCurr,bitIndex39)
      <=> v4847(VarCurr,bitIndex55) )
      & ( v25521(VarCurr,bitIndex38)
      <=> v4847(VarCurr,bitIndex54) )
      & ( v25521(VarCurr,bitIndex37)
      <=> v4847(VarCurr,bitIndex53) )
      & ( v25521(VarCurr,bitIndex36)
      <=> v4847(VarCurr,bitIndex52) ) ) ).

fof(addAssignment_11788,axiom,
    ! [VarCurr,B] :
      ( range_47_36(B)
     => ( v25236(VarCurr,B)
      <=> v25238(VarCurr,B) ) ) ).

fof(addAssignment_11787,axiom,
    ! [VarCurr,B] :
      ( range_47_36(B)
     => ( v25238(VarCurr,B)
      <=> v25240(VarCurr,B) ) ) ).

fof(addAssignment_11786,axiom,
    ! [VarCurr,B] :
      ( range_47_36(B)
     => ( v25240(VarCurr,B)
      <=> v25242(VarCurr,B) ) ) ).

fof(addAssignment_11785,axiom,
    ! [VarCurr,B] :
      ( range_47_36(B)
     => ( v25242(VarCurr,B)
      <=> v25504(VarCurr,B) ) ) ).

fof(addAssignment_11784,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex383)
      <=> v26821(VarNext,bitIndex47) )
      & ( v25244(VarNext,bitIndex382)
      <=> v26821(VarNext,bitIndex46) )
      & ( v25244(VarNext,bitIndex381)
      <=> v26821(VarNext,bitIndex45) )
      & ( v25244(VarNext,bitIndex380)
      <=> v26821(VarNext,bitIndex44) )
      & ( v25244(VarNext,bitIndex379)
      <=> v26821(VarNext,bitIndex43) )
      & ( v25244(VarNext,bitIndex378)
      <=> v26821(VarNext,bitIndex42) )
      & ( v25244(VarNext,bitIndex377)
      <=> v26821(VarNext,bitIndex41) )
      & ( v25244(VarNext,bitIndex376)
      <=> v26821(VarNext,bitIndex40) )
      & ( v25244(VarNext,bitIndex375)
      <=> v26821(VarNext,bitIndex39) )
      & ( v25244(VarNext,bitIndex374)
      <=> v26821(VarNext,bitIndex38) )
      & ( v25244(VarNext,bitIndex373)
      <=> v26821(VarNext,bitIndex37) )
      & ( v25244(VarNext,bitIndex372)
      <=> v26821(VarNext,bitIndex36) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_13,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26823(VarNext)
       => ( ( v26821(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex383) )
          & ( v26821(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex382) )
          & ( v26821(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex381) )
          & ( v26821(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex380) )
          & ( v26821(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex379) )
          & ( v26821(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex378) )
          & ( v26821(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex377) )
          & ( v26821(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex376) )
          & ( v26821(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex375) )
          & ( v26821(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex374) )
          & ( v26821(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex373) )
          & ( v26821(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex372) )
          & ( v26821(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex371) )
          & ( v26821(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex370) )
          & ( v26821(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex369) )
          & ( v26821(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex368) )
          & ( v26821(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex367) )
          & ( v26821(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex366) )
          & ( v26821(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex365) )
          & ( v26821(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex364) )
          & ( v26821(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex363) )
          & ( v26821(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex362) )
          & ( v26821(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex361) )
          & ( v26821(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex360) )
          & ( v26821(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex359) )
          & ( v26821(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex358) )
          & ( v26821(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex357) )
          & ( v26821(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex356) )
          & ( v26821(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex355) )
          & ( v26821(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex354) )
          & ( v26821(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex353) )
          & ( v26821(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex352) )
          & ( v26821(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex351) )
          & ( v26821(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex350) )
          & ( v26821(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex349) )
          & ( v26821(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex348) )
          & ( v26821(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex347) )
          & ( v26821(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex346) )
          & ( v26821(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex345) )
          & ( v26821(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex344) )
          & ( v26821(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex343) )
          & ( v26821(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex342) )
          & ( v26821(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex341) )
          & ( v26821(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex340) )
          & ( v26821(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex339) )
          & ( v26821(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex338) )
          & ( v26821(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex337) )
          & ( v26821(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex336) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_428,axiom,
    ! [VarNext] :
      ( v26823(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v26821(VarNext,B)
          <=> v25410(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4627,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26823(VarNext)
      <=> ( v26824(VarNext)
          & v25405(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4626,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26824(VarNext)
      <=> ( v26826(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2455,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26826(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11783,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex335)
      <=> v26813(VarNext,bitIndex47) )
      & ( v25244(VarNext,bitIndex334)
      <=> v26813(VarNext,bitIndex46) )
      & ( v25244(VarNext,bitIndex333)
      <=> v26813(VarNext,bitIndex45) )
      & ( v25244(VarNext,bitIndex332)
      <=> v26813(VarNext,bitIndex44) )
      & ( v25244(VarNext,bitIndex331)
      <=> v26813(VarNext,bitIndex43) )
      & ( v25244(VarNext,bitIndex330)
      <=> v26813(VarNext,bitIndex42) )
      & ( v25244(VarNext,bitIndex329)
      <=> v26813(VarNext,bitIndex41) )
      & ( v25244(VarNext,bitIndex328)
      <=> v26813(VarNext,bitIndex40) )
      & ( v25244(VarNext,bitIndex327)
      <=> v26813(VarNext,bitIndex39) )
      & ( v25244(VarNext,bitIndex326)
      <=> v26813(VarNext,bitIndex38) )
      & ( v25244(VarNext,bitIndex325)
      <=> v26813(VarNext,bitIndex37) )
      & ( v25244(VarNext,bitIndex324)
      <=> v26813(VarNext,bitIndex36) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_12,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26815(VarNext)
       => ( ( v26813(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex335) )
          & ( v26813(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex334) )
          & ( v26813(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex333) )
          & ( v26813(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex332) )
          & ( v26813(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex331) )
          & ( v26813(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex330) )
          & ( v26813(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex329) )
          & ( v26813(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex328) )
          & ( v26813(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex327) )
          & ( v26813(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex326) )
          & ( v26813(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex325) )
          & ( v26813(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex324) )
          & ( v26813(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex323) )
          & ( v26813(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex322) )
          & ( v26813(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex321) )
          & ( v26813(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex320) )
          & ( v26813(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex319) )
          & ( v26813(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex318) )
          & ( v26813(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex317) )
          & ( v26813(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex316) )
          & ( v26813(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex315) )
          & ( v26813(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex314) )
          & ( v26813(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex313) )
          & ( v26813(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex312) )
          & ( v26813(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex311) )
          & ( v26813(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex310) )
          & ( v26813(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex309) )
          & ( v26813(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex308) )
          & ( v26813(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex307) )
          & ( v26813(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex306) )
          & ( v26813(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex305) )
          & ( v26813(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex304) )
          & ( v26813(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex303) )
          & ( v26813(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex302) )
          & ( v26813(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex301) )
          & ( v26813(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex300) )
          & ( v26813(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex299) )
          & ( v26813(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex298) )
          & ( v26813(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex297) )
          & ( v26813(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex296) )
          & ( v26813(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex295) )
          & ( v26813(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex294) )
          & ( v26813(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex293) )
          & ( v26813(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex292) )
          & ( v26813(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex291) )
          & ( v26813(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex290) )
          & ( v26813(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex289) )
          & ( v26813(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex288) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_427,axiom,
    ! [VarNext] :
      ( v26815(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v26813(VarNext,B)
          <=> v25392(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4625,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26815(VarNext)
      <=> ( v26816(VarNext)
          & v25387(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4624,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26816(VarNext)
      <=> ( v26818(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2454,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26818(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11782,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex287)
      <=> v26805(VarNext,bitIndex47) )
      & ( v25244(VarNext,bitIndex286)
      <=> v26805(VarNext,bitIndex46) )
      & ( v25244(VarNext,bitIndex285)
      <=> v26805(VarNext,bitIndex45) )
      & ( v25244(VarNext,bitIndex284)
      <=> v26805(VarNext,bitIndex44) )
      & ( v25244(VarNext,bitIndex283)
      <=> v26805(VarNext,bitIndex43) )
      & ( v25244(VarNext,bitIndex282)
      <=> v26805(VarNext,bitIndex42) )
      & ( v25244(VarNext,bitIndex281)
      <=> v26805(VarNext,bitIndex41) )
      & ( v25244(VarNext,bitIndex280)
      <=> v26805(VarNext,bitIndex40) )
      & ( v25244(VarNext,bitIndex279)
      <=> v26805(VarNext,bitIndex39) )
      & ( v25244(VarNext,bitIndex278)
      <=> v26805(VarNext,bitIndex38) )
      & ( v25244(VarNext,bitIndex277)
      <=> v26805(VarNext,bitIndex37) )
      & ( v25244(VarNext,bitIndex276)
      <=> v26805(VarNext,bitIndex36) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_11,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26807(VarNext)
       => ( ( v26805(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex287) )
          & ( v26805(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex286) )
          & ( v26805(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex285) )
          & ( v26805(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex284) )
          & ( v26805(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex283) )
          & ( v26805(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex282) )
          & ( v26805(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex281) )
          & ( v26805(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex280) )
          & ( v26805(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex279) )
          & ( v26805(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex278) )
          & ( v26805(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex277) )
          & ( v26805(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex276) )
          & ( v26805(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex275) )
          & ( v26805(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex274) )
          & ( v26805(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex273) )
          & ( v26805(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex272) )
          & ( v26805(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex271) )
          & ( v26805(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex270) )
          & ( v26805(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex269) )
          & ( v26805(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex268) )
          & ( v26805(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex267) )
          & ( v26805(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex266) )
          & ( v26805(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex265) )
          & ( v26805(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex264) )
          & ( v26805(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex263) )
          & ( v26805(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex262) )
          & ( v26805(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex261) )
          & ( v26805(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex260) )
          & ( v26805(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex259) )
          & ( v26805(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex258) )
          & ( v26805(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex257) )
          & ( v26805(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex256) )
          & ( v26805(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex255) )
          & ( v26805(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex254) )
          & ( v26805(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex253) )
          & ( v26805(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex252) )
          & ( v26805(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex251) )
          & ( v26805(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex250) )
          & ( v26805(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex249) )
          & ( v26805(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex248) )
          & ( v26805(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex247) )
          & ( v26805(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex246) )
          & ( v26805(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex245) )
          & ( v26805(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex244) )
          & ( v26805(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex243) )
          & ( v26805(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex242) )
          & ( v26805(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex241) )
          & ( v26805(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex240) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_426,axiom,
    ! [VarNext] :
      ( v26807(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v26805(VarNext,B)
          <=> v25374(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4623,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26807(VarNext)
      <=> ( v26808(VarNext)
          & v25369(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4622,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26808(VarNext)
      <=> ( v26810(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2453,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26810(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11781,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex239)
      <=> v26797(VarNext,bitIndex47) )
      & ( v25244(VarNext,bitIndex238)
      <=> v26797(VarNext,bitIndex46) )
      & ( v25244(VarNext,bitIndex237)
      <=> v26797(VarNext,bitIndex45) )
      & ( v25244(VarNext,bitIndex236)
      <=> v26797(VarNext,bitIndex44) )
      & ( v25244(VarNext,bitIndex235)
      <=> v26797(VarNext,bitIndex43) )
      & ( v25244(VarNext,bitIndex234)
      <=> v26797(VarNext,bitIndex42) )
      & ( v25244(VarNext,bitIndex233)
      <=> v26797(VarNext,bitIndex41) )
      & ( v25244(VarNext,bitIndex232)
      <=> v26797(VarNext,bitIndex40) )
      & ( v25244(VarNext,bitIndex231)
      <=> v26797(VarNext,bitIndex39) )
      & ( v25244(VarNext,bitIndex230)
      <=> v26797(VarNext,bitIndex38) )
      & ( v25244(VarNext,bitIndex229)
      <=> v26797(VarNext,bitIndex37) )
      & ( v25244(VarNext,bitIndex228)
      <=> v26797(VarNext,bitIndex36) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_10,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26799(VarNext)
       => ( ( v26797(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex239) )
          & ( v26797(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex238) )
          & ( v26797(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex237) )
          & ( v26797(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex236) )
          & ( v26797(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex235) )
          & ( v26797(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex234) )
          & ( v26797(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex233) )
          & ( v26797(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex232) )
          & ( v26797(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex231) )
          & ( v26797(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex230) )
          & ( v26797(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex229) )
          & ( v26797(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex228) )
          & ( v26797(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex227) )
          & ( v26797(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex226) )
          & ( v26797(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex225) )
          & ( v26797(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex224) )
          & ( v26797(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex223) )
          & ( v26797(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex222) )
          & ( v26797(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex221) )
          & ( v26797(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex220) )
          & ( v26797(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex219) )
          & ( v26797(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex218) )
          & ( v26797(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex217) )
          & ( v26797(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex216) )
          & ( v26797(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex215) )
          & ( v26797(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex214) )
          & ( v26797(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex213) )
          & ( v26797(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex212) )
          & ( v26797(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex211) )
          & ( v26797(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex210) )
          & ( v26797(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex209) )
          & ( v26797(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex208) )
          & ( v26797(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex207) )
          & ( v26797(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex206) )
          & ( v26797(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex205) )
          & ( v26797(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex204) )
          & ( v26797(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex203) )
          & ( v26797(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex202) )
          & ( v26797(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex201) )
          & ( v26797(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex200) )
          & ( v26797(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex199) )
          & ( v26797(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex198) )
          & ( v26797(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex197) )
          & ( v26797(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex196) )
          & ( v26797(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex195) )
          & ( v26797(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex194) )
          & ( v26797(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex193) )
          & ( v26797(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex192) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_425,axiom,
    ! [VarNext] :
      ( v26799(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v26797(VarNext,B)
          <=> v25356(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4621,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26799(VarNext)
      <=> ( v26800(VarNext)
          & v25351(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4620,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26800(VarNext)
      <=> ( v26802(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2452,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26802(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11780,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex191)
      <=> v26789(VarNext,bitIndex47) )
      & ( v25244(VarNext,bitIndex190)
      <=> v26789(VarNext,bitIndex46) )
      & ( v25244(VarNext,bitIndex189)
      <=> v26789(VarNext,bitIndex45) )
      & ( v25244(VarNext,bitIndex188)
      <=> v26789(VarNext,bitIndex44) )
      & ( v25244(VarNext,bitIndex187)
      <=> v26789(VarNext,bitIndex43) )
      & ( v25244(VarNext,bitIndex186)
      <=> v26789(VarNext,bitIndex42) )
      & ( v25244(VarNext,bitIndex185)
      <=> v26789(VarNext,bitIndex41) )
      & ( v25244(VarNext,bitIndex184)
      <=> v26789(VarNext,bitIndex40) )
      & ( v25244(VarNext,bitIndex183)
      <=> v26789(VarNext,bitIndex39) )
      & ( v25244(VarNext,bitIndex182)
      <=> v26789(VarNext,bitIndex38) )
      & ( v25244(VarNext,bitIndex181)
      <=> v26789(VarNext,bitIndex37) )
      & ( v25244(VarNext,bitIndex180)
      <=> v26789(VarNext,bitIndex36) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_9,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26791(VarNext)
       => ( ( v26789(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex191) )
          & ( v26789(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex190) )
          & ( v26789(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex189) )
          & ( v26789(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex188) )
          & ( v26789(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex187) )
          & ( v26789(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex186) )
          & ( v26789(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex185) )
          & ( v26789(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex184) )
          & ( v26789(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex183) )
          & ( v26789(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex182) )
          & ( v26789(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex181) )
          & ( v26789(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex180) )
          & ( v26789(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex179) )
          & ( v26789(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex178) )
          & ( v26789(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex177) )
          & ( v26789(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex176) )
          & ( v26789(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex175) )
          & ( v26789(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex174) )
          & ( v26789(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex173) )
          & ( v26789(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex172) )
          & ( v26789(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex171) )
          & ( v26789(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex170) )
          & ( v26789(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex169) )
          & ( v26789(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex168) )
          & ( v26789(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex167) )
          & ( v26789(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex166) )
          & ( v26789(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex165) )
          & ( v26789(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex164) )
          & ( v26789(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex163) )
          & ( v26789(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex162) )
          & ( v26789(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex161) )
          & ( v26789(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex160) )
          & ( v26789(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex159) )
          & ( v26789(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex158) )
          & ( v26789(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex157) )
          & ( v26789(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex156) )
          & ( v26789(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex155) )
          & ( v26789(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex154) )
          & ( v26789(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex153) )
          & ( v26789(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex152) )
          & ( v26789(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex151) )
          & ( v26789(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex150) )
          & ( v26789(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex149) )
          & ( v26789(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex148) )
          & ( v26789(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex147) )
          & ( v26789(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex146) )
          & ( v26789(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex145) )
          & ( v26789(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex144) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_424,axiom,
    ! [VarNext] :
      ( v26791(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v26789(VarNext,B)
          <=> v25338(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4619,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26791(VarNext)
      <=> ( v26792(VarNext)
          & v25333(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4618,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26792(VarNext)
      <=> ( v26794(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2451,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26794(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11779,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex143)
      <=> v26781(VarNext,bitIndex47) )
      & ( v25244(VarNext,bitIndex142)
      <=> v26781(VarNext,bitIndex46) )
      & ( v25244(VarNext,bitIndex141)
      <=> v26781(VarNext,bitIndex45) )
      & ( v25244(VarNext,bitIndex140)
      <=> v26781(VarNext,bitIndex44) )
      & ( v25244(VarNext,bitIndex139)
      <=> v26781(VarNext,bitIndex43) )
      & ( v25244(VarNext,bitIndex138)
      <=> v26781(VarNext,bitIndex42) )
      & ( v25244(VarNext,bitIndex137)
      <=> v26781(VarNext,bitIndex41) )
      & ( v25244(VarNext,bitIndex136)
      <=> v26781(VarNext,bitIndex40) )
      & ( v25244(VarNext,bitIndex135)
      <=> v26781(VarNext,bitIndex39) )
      & ( v25244(VarNext,bitIndex134)
      <=> v26781(VarNext,bitIndex38) )
      & ( v25244(VarNext,bitIndex133)
      <=> v26781(VarNext,bitIndex37) )
      & ( v25244(VarNext,bitIndex132)
      <=> v26781(VarNext,bitIndex36) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_8,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26783(VarNext)
       => ( ( v26781(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex143) )
          & ( v26781(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex142) )
          & ( v26781(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex141) )
          & ( v26781(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex140) )
          & ( v26781(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex139) )
          & ( v26781(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex138) )
          & ( v26781(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex137) )
          & ( v26781(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex136) )
          & ( v26781(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex135) )
          & ( v26781(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex134) )
          & ( v26781(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex133) )
          & ( v26781(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex132) )
          & ( v26781(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex131) )
          & ( v26781(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex130) )
          & ( v26781(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex129) )
          & ( v26781(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex128) )
          & ( v26781(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex127) )
          & ( v26781(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex126) )
          & ( v26781(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex125) )
          & ( v26781(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex124) )
          & ( v26781(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex123) )
          & ( v26781(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex122) )
          & ( v26781(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex121) )
          & ( v26781(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex120) )
          & ( v26781(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex119) )
          & ( v26781(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex118) )
          & ( v26781(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex117) )
          & ( v26781(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex116) )
          & ( v26781(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex115) )
          & ( v26781(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex114) )
          & ( v26781(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex113) )
          & ( v26781(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex112) )
          & ( v26781(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex111) )
          & ( v26781(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex110) )
          & ( v26781(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex109) )
          & ( v26781(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex108) )
          & ( v26781(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex107) )
          & ( v26781(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex106) )
          & ( v26781(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex105) )
          & ( v26781(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex104) )
          & ( v26781(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex103) )
          & ( v26781(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex102) )
          & ( v26781(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex101) )
          & ( v26781(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex100) )
          & ( v26781(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex99) )
          & ( v26781(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex98) )
          & ( v26781(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex97) )
          & ( v26781(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex96) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_423,axiom,
    ! [VarNext] :
      ( v26783(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v26781(VarNext,B)
          <=> v25320(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4617,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26783(VarNext)
      <=> ( v26784(VarNext)
          & v25315(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4616,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26784(VarNext)
      <=> ( v26786(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2450,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26786(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11778,axiom,
    ! [VarNext] :
      ( ( v25244(VarNext,bitIndex95)
      <=> v26773(VarNext,bitIndex47) )
      & ( v25244(VarNext,bitIndex94)
      <=> v26773(VarNext,bitIndex46) )
      & ( v25244(VarNext,bitIndex93)
      <=> v26773(VarNext,bitIndex45) )
      & ( v25244(VarNext,bitIndex92)
      <=> v26773(VarNext,bitIndex44) )
      & ( v25244(VarNext,bitIndex91)
      <=> v26773(VarNext,bitIndex43) )
      & ( v25244(VarNext,bitIndex90)
      <=> v26773(VarNext,bitIndex42) )
      & ( v25244(VarNext,bitIndex89)
      <=> v26773(VarNext,bitIndex41) )
      & ( v25244(VarNext,bitIndex88)
      <=> v26773(VarNext,bitIndex40) )
      & ( v25244(VarNext,bitIndex87)
      <=> v26773(VarNext,bitIndex39) )
      & ( v25244(VarNext,bitIndex86)
      <=> v26773(VarNext,bitIndex38) )
      & ( v25244(VarNext,bitIndex85)
      <=> v26773(VarNext,bitIndex37) )
      & ( v25244(VarNext,bitIndex84)
      <=> v26773(VarNext,bitIndex36) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_7,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26775(VarNext)
       => ( ( v26773(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex95) )
          & ( v26773(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex94) )
          & ( v26773(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex93) )
          & ( v26773(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex92) )
          & ( v26773(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex91) )
          & ( v26773(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex90) )
          & ( v26773(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex89) )
          & ( v26773(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex88) )
          & ( v26773(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex87) )
          & ( v26773(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex86) )
          & ( v26773(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex85) )
          & ( v26773(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex84) )
          & ( v26773(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex83) )
          & ( v26773(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex82) )
          & ( v26773(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex81) )
          & ( v26773(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex80) )
          & ( v26773(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex79) )
          & ( v26773(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex78) )
          & ( v26773(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex77) )
          & ( v26773(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex76) )
          & ( v26773(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex75) )
          & ( v26773(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex74) )
          & ( v26773(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex73) )
          & ( v26773(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex72) )
          & ( v26773(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex71) )
          & ( v26773(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex70) )
          & ( v26773(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex69) )
          & ( v26773(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex68) )
          & ( v26773(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex67) )
          & ( v26773(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex66) )
          & ( v26773(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex65) )
          & ( v26773(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex64) )
          & ( v26773(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex63) )
          & ( v26773(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex62) )
          & ( v26773(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex61) )
          & ( v26773(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex60) )
          & ( v26773(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex59) )
          & ( v26773(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex58) )
          & ( v26773(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex57) )
          & ( v26773(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex56) )
          & ( v26773(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex55) )
          & ( v26773(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex54) )
          & ( v26773(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex53) )
          & ( v26773(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex52) )
          & ( v26773(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex51) )
          & ( v26773(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex50) )
          & ( v26773(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex49) )
          & ( v26773(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex48) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_422,axiom,
    ! [VarNext] :
      ( v26775(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v26773(VarNext,B)
          <=> v25302(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4615,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26775(VarNext)
      <=> ( v26776(VarNext)
          & v25297(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4614,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26776(VarNext)
      <=> ( v26778(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2449,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26778(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11777,axiom,
    ! [VarCurr,B] :
      ( range_47_36(B)
     => ( v25280(VarCurr,B)
      <=> v25282(VarCurr,B) ) ) ).

fof(addAssignment_11776,axiom,
    ! [VarCurr,B] :
      ( range_47_36(B)
     => ( v25282(VarCurr,B)
      <=> v25284(VarCurr,B) ) ) ).

fof(addAssignment_11775,axiom,
    ! [VarCurr] :
      ( ( v25284(VarCurr,bitIndex47)
      <=> v25286(VarCurr,bitIndex63) )
      & ( v25284(VarCurr,bitIndex46)
      <=> v25286(VarCurr,bitIndex62) )
      & ( v25284(VarCurr,bitIndex45)
      <=> v25286(VarCurr,bitIndex61) )
      & ( v25284(VarCurr,bitIndex44)
      <=> v25286(VarCurr,bitIndex60) )
      & ( v25284(VarCurr,bitIndex43)
      <=> v25286(VarCurr,bitIndex59) )
      & ( v25284(VarCurr,bitIndex42)
      <=> v25286(VarCurr,bitIndex58) )
      & ( v25284(VarCurr,bitIndex41)
      <=> v25286(VarCurr,bitIndex57) )
      & ( v25284(VarCurr,bitIndex40)
      <=> v25286(VarCurr,bitIndex56) )
      & ( v25284(VarCurr,bitIndex39)
      <=> v25286(VarCurr,bitIndex55) )
      & ( v25284(VarCurr,bitIndex38)
      <=> v25286(VarCurr,bitIndex54) )
      & ( v25284(VarCurr,bitIndex37)
      <=> v25286(VarCurr,bitIndex53) )
      & ( v25284(VarCurr,bitIndex36)
      <=> v25286(VarCurr,bitIndex52) ) ) ).

fof(addAssignment_11774,axiom,
    ! [VarCurr] :
      ( ( v25286(VarCurr,bitIndex63)
      <=> v24386(VarCurr,bitIndex127) )
      & ( v25286(VarCurr,bitIndex62)
      <=> v24386(VarCurr,bitIndex126) )
      & ( v25286(VarCurr,bitIndex61)
      <=> v24386(VarCurr,bitIndex125) )
      & ( v25286(VarCurr,bitIndex60)
      <=> v24386(VarCurr,bitIndex124) )
      & ( v25286(VarCurr,bitIndex59)
      <=> v24386(VarCurr,bitIndex123) )
      & ( v25286(VarCurr,bitIndex58)
      <=> v24386(VarCurr,bitIndex122) )
      & ( v25286(VarCurr,bitIndex57)
      <=> v24386(VarCurr,bitIndex121) )
      & ( v25286(VarCurr,bitIndex56)
      <=> v24386(VarCurr,bitIndex120) )
      & ( v25286(VarCurr,bitIndex55)
      <=> v24386(VarCurr,bitIndex119) )
      & ( v25286(VarCurr,bitIndex54)
      <=> v24386(VarCurr,bitIndex118) )
      & ( v25286(VarCurr,bitIndex53)
      <=> v24386(VarCurr,bitIndex117) )
      & ( v25286(VarCurr,bitIndex52)
      <=> v24386(VarCurr,bitIndex116) ) ) ).

fof(addAssignment_11773,axiom,
    ! [VarNext,B] :
      ( range_47_36(B)
     => ( v25244(VarNext,B)
      <=> v26765(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_482,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26767(VarNext)
       => ! [B] :
            ( range_47_0(B)
           => ( v26765(VarNext,B)
            <=> v25244(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_421,axiom,
    ! [VarNext] :
      ( v26767(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v26765(VarNext,B)
          <=> v25276(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4613,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26767(VarNext)
      <=> ( v26768(VarNext)
          & v25270(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4612,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26768(VarNext)
      <=> ( v26770(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2448,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26770(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11772,axiom,
    ! [VarCurr,B] :
      ( range_47_36(B)
     => ( v25255(VarCurr,B)
      <=> v25257(VarCurr,B) ) ) ).

fof(addAssignment_11771,axiom,
    ! [VarCurr,B] :
      ( range_47_36(B)
     => ( v25257(VarCurr,B)
      <=> v25259(VarCurr,B) ) ) ).

fof(range_axiom_222,axiom,
    ! [B] :
      ( range_47_36(B)
    <=> ( $false
        | bitIndex36 = B
        | bitIndex37 = B
        | bitIndex38 = B
        | bitIndex39 = B
        | bitIndex40 = B
        | bitIndex41 = B
        | bitIndex42 = B
        | bitIndex43 = B
        | bitIndex44 = B
        | bitIndex45 = B
        | bitIndex46 = B
        | bitIndex47 = B ) ) ).

fof(addAssignment_11770,axiom,
    ! [VarCurr] :
      ( ( v25259(VarCurr,bitIndex47)
      <=> v24386(VarCurr,bitIndex63) )
      & ( v25259(VarCurr,bitIndex46)
      <=> v24386(VarCurr,bitIndex62) )
      & ( v25259(VarCurr,bitIndex45)
      <=> v24386(VarCurr,bitIndex61) )
      & ( v25259(VarCurr,bitIndex44)
      <=> v24386(VarCurr,bitIndex60) )
      & ( v25259(VarCurr,bitIndex43)
      <=> v24386(VarCurr,bitIndex59) )
      & ( v25259(VarCurr,bitIndex42)
      <=> v24386(VarCurr,bitIndex58) )
      & ( v25259(VarCurr,bitIndex41)
      <=> v24386(VarCurr,bitIndex57) )
      & ( v25259(VarCurr,bitIndex40)
      <=> v24386(VarCurr,bitIndex56) )
      & ( v25259(VarCurr,bitIndex39)
      <=> v24386(VarCurr,bitIndex55) )
      & ( v25259(VarCurr,bitIndex38)
      <=> v24386(VarCurr,bitIndex54) )
      & ( v25259(VarCurr,bitIndex37)
      <=> v24386(VarCurr,bitIndex53) )
      & ( v25259(VarCurr,bitIndex36)
      <=> v24386(VarCurr,bitIndex52) ) ) ).

fof(addAssignment_11769,axiom,
    ! [VarCurr] :
      ( v26759(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_11768,axiom,
    ! [VarCurr] :
      ( v26757(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_481,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26738(VarNext)
       => ( v26727(VarNext)
        <=> v26727(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_420,axiom,
    ! [VarNext] :
      ( v26738(VarNext)
     => ( v26727(VarNext)
      <=> v26748(VarNext) ) ) ).

fof(addAssignment_11767,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26748(VarNext)
      <=> v26746(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_753,axiom,
    ! [VarCurr] :
      ( ~ v26749(VarCurr)
     => ( v26746(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_507,axiom,
    ! [VarCurr] :
      ( v26749(VarCurr)
     => ( v26746(VarCurr)
      <=> v26733(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4611,axiom,
    ! [VarCurr] :
      ( v26749(VarCurr)
    <=> ( v26750(VarCurr)
        & v26751(VarCurr) ) ) ).

fof(writeUnaryOperator_2447,axiom,
    ! [VarCurr] :
      ( ~ v26751(VarCurr)
    <=> v26731(VarCurr) ) ).

fof(writeUnaryOperator_2446,axiom,
    ! [VarCurr] :
      ( ~ v26750(VarCurr)
    <=> v26729(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4610,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26738(VarNext)
      <=> v26739(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4609,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26739(VarNext)
      <=> ( v26740(VarNext)
          & v26735(VarNext) ) ) ) ).

fof(writeUnaryOperator_2445,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26740(VarNext)
      <=> v26742(VarNext) ) ) ).

fof(addAssignment_11766,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26742(VarNext)
      <=> v26735(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_985,axiom,
    ( v26727(constB0)
  <=> $false ) ).

fof(addAssignment_11765,axiom,
    ! [VarCurr] :
      ( v26735(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_11764,axiom,
    ! [VarCurr] :
      ( v26733(VarCurr)
    <=> v202(VarCurr,bitIndex52) ) ).

fof(addAssignment_11763,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex52)
    <=> v204(VarCurr,bitIndex52) ) ).

fof(addAssignment_11762,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex52)
    <=> v25523(VarCurr,bitIndex52) ) ).

fof(addAssignment_11761,axiom,
    ! [VarCurr] :
      ( v206(VarCurr,bitIndex4)
    <=> v208(VarCurr,bitIndex4) ) ).

fof(addAssignment_11760,axiom,
    ! [VarCurr] :
      ( v208(VarCurr,bitIndex4)
    <=> v210(VarCurr,bitIndex4) ) ).

fof(addAssignment_11759,axiom,
    ! [VarCurr] :
      ( v26731(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_11758,axiom,
    ! [VarCurr] :
      ( v26729(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_480,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26710(VarNext)
       => ( v26699(VarNext)
        <=> v26699(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_419,axiom,
    ! [VarNext] :
      ( v26710(VarNext)
     => ( v26699(VarNext)
      <=> v26720(VarNext) ) ) ).

fof(addAssignment_11757,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26720(VarNext)
      <=> v26718(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_752,axiom,
    ! [VarCurr] :
      ( ~ v26721(VarCurr)
     => ( v26718(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_506,axiom,
    ! [VarCurr] :
      ( v26721(VarCurr)
     => ( v26718(VarCurr)
      <=> v26705(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4608,axiom,
    ! [VarCurr] :
      ( v26721(VarCurr)
    <=> ( v26722(VarCurr)
        & v26723(VarCurr) ) ) ).

fof(writeUnaryOperator_2444,axiom,
    ! [VarCurr] :
      ( ~ v26723(VarCurr)
    <=> v26703(VarCurr) ) ).

fof(writeUnaryOperator_2443,axiom,
    ! [VarCurr] :
      ( ~ v26722(VarCurr)
    <=> v26701(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4607,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26710(VarNext)
      <=> v26711(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4606,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26711(VarNext)
      <=> ( v26712(VarNext)
          & v26707(VarNext) ) ) ) ).

fof(writeUnaryOperator_2442,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26712(VarNext)
      <=> v26714(VarNext) ) ) ).

fof(addAssignment_11756,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26714(VarNext)
      <=> v26707(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_984,axiom,
    ( v26699(constB0)
  <=> $false ) ).

fof(addAssignment_11755,axiom,
    ! [VarCurr] :
      ( v26707(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_11754,axiom,
    ! [VarCurr] :
      ( v26705(VarCurr)
    <=> v202(VarCurr,bitIndex53) ) ).

fof(addAssignment_11753,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex53)
    <=> v204(VarCurr,bitIndex53) ) ).

fof(addAssignment_11752,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex53)
    <=> v25523(VarCurr,bitIndex53) ) ).

fof(addAssignment_11751,axiom,
    ! [VarCurr] :
      ( v206(VarCurr,bitIndex5)
    <=> v208(VarCurr,bitIndex5) ) ).

fof(addAssignment_11750,axiom,
    ! [VarCurr] :
      ( v208(VarCurr,bitIndex5)
    <=> v210(VarCurr,bitIndex5) ) ).

fof(addAssignment_11749,axiom,
    ! [VarCurr] :
      ( v26703(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_11748,axiom,
    ! [VarCurr] :
      ( v26701(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_479,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26682(VarNext)
       => ( v26671(VarNext)
        <=> v26671(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_418,axiom,
    ! [VarNext] :
      ( v26682(VarNext)
     => ( v26671(VarNext)
      <=> v26692(VarNext) ) ) ).

fof(addAssignment_11747,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26692(VarNext)
      <=> v26690(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_751,axiom,
    ! [VarCurr] :
      ( ~ v26693(VarCurr)
     => ( v26690(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_505,axiom,
    ! [VarCurr] :
      ( v26693(VarCurr)
     => ( v26690(VarCurr)
      <=> v26677(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4605,axiom,
    ! [VarCurr] :
      ( v26693(VarCurr)
    <=> ( v26694(VarCurr)
        & v26695(VarCurr) ) ) ).

fof(writeUnaryOperator_2441,axiom,
    ! [VarCurr] :
      ( ~ v26695(VarCurr)
    <=> v26675(VarCurr) ) ).

fof(writeUnaryOperator_2440,axiom,
    ! [VarCurr] :
      ( ~ v26694(VarCurr)
    <=> v26673(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4604,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26682(VarNext)
      <=> v26683(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4603,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26683(VarNext)
      <=> ( v26684(VarNext)
          & v26679(VarNext) ) ) ) ).

fof(writeUnaryOperator_2439,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26684(VarNext)
      <=> v26686(VarNext) ) ) ).

fof(addAssignment_11746,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26686(VarNext)
      <=> v26679(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_983,axiom,
    ( v26671(constB0)
  <=> $false ) ).

fof(addAssignment_11745,axiom,
    ! [VarCurr] :
      ( v26679(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_11744,axiom,
    ! [VarCurr] :
      ( v26677(VarCurr)
    <=> v202(VarCurr,bitIndex54) ) ).

fof(addAssignment_11743,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex54)
    <=> v204(VarCurr,bitIndex54) ) ).

fof(addAssignment_11742,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex54)
    <=> v25523(VarCurr,bitIndex54) ) ).

fof(addAssignment_11741,axiom,
    ! [VarCurr] :
      ( v26675(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_11740,axiom,
    ! [VarCurr] :
      ( v26673(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_478,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26654(VarNext)
       => ( v26643(VarNext)
        <=> v26643(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_417,axiom,
    ! [VarNext] :
      ( v26654(VarNext)
     => ( v26643(VarNext)
      <=> v26664(VarNext) ) ) ).

fof(addAssignment_11739,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26664(VarNext)
      <=> v26662(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_750,axiom,
    ! [VarCurr] :
      ( ~ v26665(VarCurr)
     => ( v26662(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_504,axiom,
    ! [VarCurr] :
      ( v26665(VarCurr)
     => ( v26662(VarCurr)
      <=> v26649(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4602,axiom,
    ! [VarCurr] :
      ( v26665(VarCurr)
    <=> ( v26666(VarCurr)
        & v26667(VarCurr) ) ) ).

fof(writeUnaryOperator_2438,axiom,
    ! [VarCurr] :
      ( ~ v26667(VarCurr)
    <=> v26647(VarCurr) ) ).

fof(writeUnaryOperator_2437,axiom,
    ! [VarCurr] :
      ( ~ v26666(VarCurr)
    <=> v26645(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4601,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26654(VarNext)
      <=> v26655(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4600,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26655(VarNext)
      <=> ( v26656(VarNext)
          & v26651(VarNext) ) ) ) ).

fof(writeUnaryOperator_2436,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26656(VarNext)
      <=> v26658(VarNext) ) ) ).

fof(addAssignment_11738,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26658(VarNext)
      <=> v26651(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_982,axiom,
    ( v26643(constB0)
  <=> $false ) ).

fof(addAssignment_11737,axiom,
    ! [VarCurr] :
      ( v26651(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_11736,axiom,
    ! [VarCurr] :
      ( v26649(VarCurr)
    <=> v202(VarCurr,bitIndex55) ) ).

fof(addAssignment_11735,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex55)
    <=> v204(VarCurr,bitIndex55) ) ).

fof(addAssignment_11734,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex55)
    <=> v25523(VarCurr,bitIndex55) ) ).

fof(addAssignment_11733,axiom,
    ! [VarCurr] :
      ( v206(VarCurr,bitIndex7)
    <=> v208(VarCurr,bitIndex7) ) ).

fof(addAssignment_11732,axiom,
    ! [VarCurr] :
      ( v208(VarCurr,bitIndex7)
    <=> v210(VarCurr,bitIndex7) ) ).

fof(addAssignment_11731,axiom,
    ! [VarCurr] :
      ( v26647(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_11730,axiom,
    ! [VarCurr] :
      ( v26645(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_477,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26626(VarNext)
       => ( v26615(VarNext)
        <=> v26615(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_416,axiom,
    ! [VarNext] :
      ( v26626(VarNext)
     => ( v26615(VarNext)
      <=> v26636(VarNext) ) ) ).

fof(addAssignment_11729,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26636(VarNext)
      <=> v26634(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_749,axiom,
    ! [VarCurr] :
      ( ~ v26637(VarCurr)
     => ( v26634(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_503,axiom,
    ! [VarCurr] :
      ( v26637(VarCurr)
     => ( v26634(VarCurr)
      <=> v26621(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4599,axiom,
    ! [VarCurr] :
      ( v26637(VarCurr)
    <=> ( v26638(VarCurr)
        & v26639(VarCurr) ) ) ).

fof(writeUnaryOperator_2435,axiom,
    ! [VarCurr] :
      ( ~ v26639(VarCurr)
    <=> v26619(VarCurr) ) ).

fof(writeUnaryOperator_2434,axiom,
    ! [VarCurr] :
      ( ~ v26638(VarCurr)
    <=> v26617(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4598,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26626(VarNext)
      <=> v26627(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4597,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26627(VarNext)
      <=> ( v26628(VarNext)
          & v26623(VarNext) ) ) ) ).

fof(writeUnaryOperator_2433,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26628(VarNext)
      <=> v26630(VarNext) ) ) ).

fof(addAssignment_11728,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26630(VarNext)
      <=> v26623(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_981,axiom,
    ( v26615(constB0)
  <=> $false ) ).

fof(addAssignment_11727,axiom,
    ! [VarCurr] :
      ( v26623(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_11726,axiom,
    ! [VarCurr] :
      ( v26621(VarCurr)
    <=> v202(VarCurr,bitIndex56) ) ).

fof(addAssignment_11725,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex56)
    <=> v204(VarCurr,bitIndex56) ) ).

fof(addAssignment_11724,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex56)
    <=> v25523(VarCurr,bitIndex56) ) ).

fof(addAssignment_11723,axiom,
    ! [VarCurr] :
      ( v206(VarCurr,bitIndex0)
    <=> v208(VarCurr,bitIndex0) ) ).

fof(addAssignment_11722,axiom,
    ! [VarCurr] :
      ( v208(VarCurr,bitIndex0)
    <=> v210(VarCurr,bitIndex0) ) ).

fof(addAssignment_11721,axiom,
    ! [VarCurr] :
      ( v26619(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_11720,axiom,
    ! [VarCurr] :
      ( v26617(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_476,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26598(VarNext)
       => ( v26587(VarNext)
        <=> v26587(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_415,axiom,
    ! [VarNext] :
      ( v26598(VarNext)
     => ( v26587(VarNext)
      <=> v26608(VarNext) ) ) ).

fof(addAssignment_11719,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26608(VarNext)
      <=> v26606(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_748,axiom,
    ! [VarCurr] :
      ( ~ v26609(VarCurr)
     => ( v26606(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_502,axiom,
    ! [VarCurr] :
      ( v26609(VarCurr)
     => ( v26606(VarCurr)
      <=> v26593(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4596,axiom,
    ! [VarCurr] :
      ( v26609(VarCurr)
    <=> ( v26610(VarCurr)
        & v26611(VarCurr) ) ) ).

fof(writeUnaryOperator_2432,axiom,
    ! [VarCurr] :
      ( ~ v26611(VarCurr)
    <=> v26591(VarCurr) ) ).

fof(writeUnaryOperator_2431,axiom,
    ! [VarCurr] :
      ( ~ v26610(VarCurr)
    <=> v26589(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4595,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26598(VarNext)
      <=> v26599(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4594,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26599(VarNext)
      <=> ( v26600(VarNext)
          & v26595(VarNext) ) ) ) ).

fof(writeUnaryOperator_2430,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26600(VarNext)
      <=> v26602(VarNext) ) ) ).

fof(addAssignment_11718,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26602(VarNext)
      <=> v26595(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_980,axiom,
    ( v26587(constB0)
  <=> $false ) ).

fof(addAssignment_11717,axiom,
    ! [VarCurr] :
      ( v26595(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_11716,axiom,
    ! [VarCurr] :
      ( v26593(VarCurr)
    <=> v202(VarCurr,bitIndex57) ) ).

fof(addAssignment_11715,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex57)
    <=> v204(VarCurr,bitIndex57) ) ).

fof(addAssignment_11714,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex57)
    <=> v25523(VarCurr,bitIndex57) ) ).

fof(addAssignment_11713,axiom,
    ! [VarCurr] :
      ( v206(VarCurr,bitIndex1)
    <=> v208(VarCurr,bitIndex1) ) ).

fof(addAssignment_11712,axiom,
    ! [VarCurr] :
      ( v208(VarCurr,bitIndex1)
    <=> v210(VarCurr,bitIndex1) ) ).

fof(addAssignment_11711,axiom,
    ! [VarCurr] :
      ( v26591(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_11710,axiom,
    ! [VarCurr] :
      ( v26589(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_475,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26570(VarNext)
       => ( v26559(VarNext)
        <=> v26559(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_414,axiom,
    ! [VarNext] :
      ( v26570(VarNext)
     => ( v26559(VarNext)
      <=> v26580(VarNext) ) ) ).

fof(addAssignment_11709,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26580(VarNext)
      <=> v26578(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_747,axiom,
    ! [VarCurr] :
      ( ~ v26581(VarCurr)
     => ( v26578(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_501,axiom,
    ! [VarCurr] :
      ( v26581(VarCurr)
     => ( v26578(VarCurr)
      <=> v26565(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4593,axiom,
    ! [VarCurr] :
      ( v26581(VarCurr)
    <=> ( v26582(VarCurr)
        & v26583(VarCurr) ) ) ).

fof(writeUnaryOperator_2429,axiom,
    ! [VarCurr] :
      ( ~ v26583(VarCurr)
    <=> v26563(VarCurr) ) ).

fof(writeUnaryOperator_2428,axiom,
    ! [VarCurr] :
      ( ~ v26582(VarCurr)
    <=> v26561(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4592,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26570(VarNext)
      <=> v26571(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4591,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26571(VarNext)
      <=> ( v26572(VarNext)
          & v26567(VarNext) ) ) ) ).

fof(writeUnaryOperator_2427,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26572(VarNext)
      <=> v26574(VarNext) ) ) ).

fof(addAssignment_11708,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26574(VarNext)
      <=> v26567(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_979,axiom,
    ( v26559(constB0)
  <=> $false ) ).

fof(addAssignment_11707,axiom,
    ! [VarCurr] :
      ( v26567(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_11706,axiom,
    ! [VarCurr] :
      ( v26565(VarCurr)
    <=> v202(VarCurr,bitIndex58) ) ).

fof(addAssignment_11705,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex58)
    <=> v204(VarCurr,bitIndex58) ) ).

fof(addAssignment_11704,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex58)
    <=> v25523(VarCurr,bitIndex58) ) ).

fof(addAssignment_11703,axiom,
    ! [VarCurr] :
      ( v206(VarCurr,bitIndex2)
    <=> v208(VarCurr,bitIndex2) ) ).

fof(addAssignment_11702,axiom,
    ! [VarCurr] :
      ( v208(VarCurr,bitIndex2)
    <=> v210(VarCurr,bitIndex2) ) ).

fof(addAssignment_11701,axiom,
    ! [VarCurr] :
      ( v26563(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_11700,axiom,
    ! [VarCurr] :
      ( v26561(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_474,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26542(VarNext)
       => ( v26531(VarNext)
        <=> v26531(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_413,axiom,
    ! [VarNext] :
      ( v26542(VarNext)
     => ( v26531(VarNext)
      <=> v26552(VarNext) ) ) ).

fof(addAssignment_11699,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26552(VarNext)
      <=> v26550(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_746,axiom,
    ! [VarCurr] :
      ( ~ v26553(VarCurr)
     => ( v26550(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_500,axiom,
    ! [VarCurr] :
      ( v26553(VarCurr)
     => ( v26550(VarCurr)
      <=> v26537(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4590,axiom,
    ! [VarCurr] :
      ( v26553(VarCurr)
    <=> ( v26554(VarCurr)
        & v26555(VarCurr) ) ) ).

fof(writeUnaryOperator_2426,axiom,
    ! [VarCurr] :
      ( ~ v26555(VarCurr)
    <=> v26535(VarCurr) ) ).

fof(writeUnaryOperator_2425,axiom,
    ! [VarCurr] :
      ( ~ v26554(VarCurr)
    <=> v26533(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4589,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26542(VarNext)
      <=> v26543(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4588,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26543(VarNext)
      <=> ( v26544(VarNext)
          & v26539(VarNext) ) ) ) ).

fof(writeUnaryOperator_2424,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26544(VarNext)
      <=> v26546(VarNext) ) ) ).

fof(addAssignment_11698,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26546(VarNext)
      <=> v26539(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_978,axiom,
    ( v26531(constB0)
  <=> $false ) ).

fof(addAssignment_11697,axiom,
    ! [VarCurr] :
      ( v26539(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_11696,axiom,
    ! [VarCurr] :
      ( v26537(VarCurr)
    <=> v202(VarCurr,bitIndex59) ) ).

fof(addAssignment_11695,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex59)
    <=> v204(VarCurr,bitIndex59) ) ).

fof(addAssignment_11694,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex59)
    <=> v25523(VarCurr,bitIndex59) ) ).

fof(addAssignment_11693,axiom,
    ! [VarCurr] :
      ( v206(VarCurr,bitIndex3)
    <=> v208(VarCurr,bitIndex3) ) ).

fof(addAssignment_11692,axiom,
    ! [VarCurr] :
      ( v208(VarCurr,bitIndex3)
    <=> v210(VarCurr,bitIndex3) ) ).

fof(addAssignment_11691,axiom,
    ! [VarCurr] :
      ( v26535(VarCurr)
    <=> v184(VarCurr,bitIndex1) ) ).

fof(addAssignment_11690,axiom,
    ! [VarCurr] :
      ( v26533(VarCurr)
    <=> v85(VarCurr,bitIndex1) ) ).

fof(addAssignment_11689,axiom,
    ! [VarCurr,B] :
      ( range_8_0(B)
     => ( v26217(VarCurr,B)
      <=> v26219(VarCurr,B) ) ) ).

fof(addAssignment_11688,axiom,
    ! [VarCurr] :
      ( v26219(VarCurr,bitIndex8)
    <=> v26221(VarCurr) ) ).

fof(addAssignment_11687,axiom,
    ! [VarCurr] :
      ( v26219(VarCurr,bitIndex7)
    <=> v26282(VarCurr) ) ).

fof(addAssignment_11686,axiom,
    ! [VarCurr] :
      ( v26219(VarCurr,bitIndex6)
    <=> v26318(VarCurr) ) ).

fof(addAssignment_11685,axiom,
    ! [VarCurr] :
      ( v26219(VarCurr,bitIndex5)
    <=> v26354(VarCurr) ) ).

fof(addAssignment_11684,axiom,
    ! [VarCurr] :
      ( v26219(VarCurr,bitIndex4)
    <=> v26382(VarCurr) ) ).

fof(addAssignment_11683,axiom,
    ! [VarCurr] :
      ( v26219(VarCurr,bitIndex3)
    <=> v26410(VarCurr) ) ).

fof(addAssignment_11682,axiom,
    ! [VarCurr] :
      ( v26219(VarCurr,bitIndex2)
    <=> v26438(VarCurr) ) ).

fof(addAssignment_11681,axiom,
    ! [VarCurr] :
      ( v26219(VarCurr,bitIndex1)
    <=> v26466(VarCurr) ) ).

fof(addAssignment_11680,axiom,
    ! [VarCurr] :
      ( v26219(VarCurr,bitIndex0)
    <=> v26494(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_473,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26505(VarNext)
       => ( v26494(VarNext)
        <=> v26494(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_412,axiom,
    ! [VarNext] :
      ( v26505(VarNext)
     => ( v26494(VarNext)
      <=> v26515(VarNext) ) ) ).

fof(addAssignment_11679,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26515(VarNext)
      <=> v26513(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_745,axiom,
    ! [VarCurr] :
      ( ~ v26516(VarCurr)
     => ( v26513(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_499,axiom,
    ! [VarCurr] :
      ( v26516(VarCurr)
     => ( v26513(VarCurr)
      <=> v26500(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4587,axiom,
    ! [VarCurr] :
      ( v26516(VarCurr)
    <=> ( v26517(VarCurr)
        & v26518(VarCurr) ) ) ).

fof(writeUnaryOperator_2423,axiom,
    ! [VarCurr] :
      ( ~ v26518(VarCurr)
    <=> v26498(VarCurr) ) ).

fof(writeUnaryOperator_2422,axiom,
    ! [VarCurr] :
      ( ~ v26517(VarCurr)
    <=> v26496(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4586,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26505(VarNext)
      <=> v26506(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4585,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26506(VarNext)
      <=> ( v26507(VarNext)
          & v26502(VarNext) ) ) ) ).

fof(writeUnaryOperator_2421,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26507(VarNext)
      <=> v26509(VarNext) ) ) ).

fof(addAssignment_11678,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26509(VarNext)
      <=> v26502(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_977,axiom,
    ( v26494(constB0)
  <=> $false ) ).

fof(addAssignment_11677,axiom,
    ! [VarCurr] :
      ( v26502(VarCurr)
    <=> v103(VarCurr,bitIndex0) ) ).

fof(addAssignment_11676,axiom,
    ! [VarCurr] :
      ( v26500(VarCurr)
    <=> v26229(VarCurr,bitIndex0) ) ).

fof(addAssignment_11675,axiom,
    ! [VarCurr] :
      ( v26229(VarCurr,bitIndex0)
    <=> v26231(VarCurr,bitIndex0) ) ).

fof(addAssignment_11674,axiom,
    ! [VarCurr] :
      ( v26231(VarCurr,bitIndex0)
    <=> v26260(VarCurr,bitIndex0) ) ).

fof(addAssignment_11673,axiom,
    ! [VarCurr] :
      ( v26233(VarCurr,bitIndex0)
    <=> v26259(VarCurr,bitIndex0) ) ).

fof(addAssignment_11672,axiom,
    ! [VarCurr] :
      ( v26244(VarCurr,bitIndex0)
    <=> v26246(VarCurr,bitIndex0) ) ).

fof(addAssignment_11671,axiom,
    ! [VarCurr] :
      ( v26246(VarCurr,bitIndex0)
    <=> v26248(VarCurr,bitIndex0) ) ).

fof(addAssignment_11670,axiom,
    ! [VarCurr] :
      ( v26248(VarCurr,bitIndex0)
    <=> v26250(VarCurr,bitIndex0) ) ).

fof(addAssignment_11669,axiom,
    ! [VarCurr] :
      ( v26250(VarCurr,bitIndex0)
    <=> v12022(VarCurr,bitIndex0) ) ).

fof(addAssignment_11668,axiom,
    ! [VarCurr] :
      ( v26235(VarCurr,bitIndex0)
    <=> v26237(VarCurr,bitIndex0) ) ).

fof(addAssignment_11667,axiom,
    ! [VarCurr] :
      ( v26237(VarCurr,bitIndex0)
    <=> v26239(VarCurr,bitIndex0) ) ).

fof(addAssignment_11666,axiom,
    ! [VarCurr] :
      ( v26239(VarCurr,bitIndex0)
    <=> v26241(VarCurr,bitIndex0) ) ).

fof(addAssignment_11665,axiom,
    ! [VarCurr] :
      ( v26241(VarCurr,bitIndex0)
    <=> v26242(VarCurr,bitIndex0) ) ).

fof(addAssignment_11664,axiom,
    ! [VarCurr] :
      ( v26498(VarCurr)
    <=> v184(VarCurr,bitIndex0) ) ).

fof(addAssignment_11663,axiom,
    ! [VarCurr] :
      ( v26496(VarCurr)
    <=> v85(VarCurr,bitIndex0) ) ).

fof(addCaseBooleanConditionEqualRanges1_472,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26477(VarNext)
       => ( v26466(VarNext)
        <=> v26466(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_411,axiom,
    ! [VarNext] :
      ( v26477(VarNext)
     => ( v26466(VarNext)
      <=> v26487(VarNext) ) ) ).

fof(addAssignment_11662,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26487(VarNext)
      <=> v26485(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_744,axiom,
    ! [VarCurr] :
      ( ~ v26488(VarCurr)
     => ( v26485(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_498,axiom,
    ! [VarCurr] :
      ( v26488(VarCurr)
     => ( v26485(VarCurr)
      <=> v26472(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4584,axiom,
    ! [VarCurr] :
      ( v26488(VarCurr)
    <=> ( v26489(VarCurr)
        & v26490(VarCurr) ) ) ).

fof(writeUnaryOperator_2420,axiom,
    ! [VarCurr] :
      ( ~ v26490(VarCurr)
    <=> v26470(VarCurr) ) ).

fof(writeUnaryOperator_2419,axiom,
    ! [VarCurr] :
      ( ~ v26489(VarCurr)
    <=> v26468(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4583,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26477(VarNext)
      <=> v26478(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4582,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26478(VarNext)
      <=> ( v26479(VarNext)
          & v26474(VarNext) ) ) ) ).

fof(writeUnaryOperator_2418,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26479(VarNext)
      <=> v26481(VarNext) ) ) ).

fof(addAssignment_11661,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26481(VarNext)
      <=> v26474(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_976,axiom,
    ( v26466(constB0)
  <=> $false ) ).

fof(addAssignment_11660,axiom,
    ! [VarCurr] :
      ( v26474(VarCurr)
    <=> v103(VarCurr,bitIndex0) ) ).

fof(addAssignment_11659,axiom,
    ! [VarCurr] :
      ( v26472(VarCurr)
    <=> v26229(VarCurr,bitIndex1) ) ).

fof(addAssignment_11658,axiom,
    ! [VarCurr] :
      ( v26229(VarCurr,bitIndex1)
    <=> v26231(VarCurr,bitIndex1) ) ).

fof(addAssignment_11657,axiom,
    ! [VarCurr] :
      ( v26231(VarCurr,bitIndex1)
    <=> v26260(VarCurr,bitIndex1) ) ).

fof(addAssignment_11656,axiom,
    ! [VarCurr] :
      ( v26233(VarCurr,bitIndex1)
    <=> v26259(VarCurr,bitIndex1) ) ).

fof(addAssignment_11655,axiom,
    ! [VarCurr] :
      ( v26244(VarCurr,bitIndex1)
    <=> v26246(VarCurr,bitIndex1) ) ).

fof(addAssignment_11654,axiom,
    ! [VarCurr] :
      ( v26246(VarCurr,bitIndex1)
    <=> v26248(VarCurr,bitIndex1) ) ).

fof(addAssignment_11653,axiom,
    ! [VarCurr] :
      ( v26248(VarCurr,bitIndex1)
    <=> v26250(VarCurr,bitIndex1) ) ).

fof(addAssignment_11652,axiom,
    ! [VarCurr] :
      ( v26250(VarCurr,bitIndex1)
    <=> v12022(VarCurr,bitIndex1) ) ).

fof(addAssignment_11651,axiom,
    ! [VarCurr] :
      ( v26235(VarCurr,bitIndex1)
    <=> v26237(VarCurr,bitIndex1) ) ).

fof(addAssignment_11650,axiom,
    ! [VarCurr] :
      ( v26237(VarCurr,bitIndex1)
    <=> v26239(VarCurr,bitIndex1) ) ).

fof(addAssignment_11649,axiom,
    ! [VarCurr] :
      ( v26239(VarCurr,bitIndex1)
    <=> v26241(VarCurr,bitIndex1) ) ).

fof(addAssignment_11648,axiom,
    ! [VarCurr] :
      ( v26241(VarCurr,bitIndex1)
    <=> v26242(VarCurr,bitIndex1) ) ).

fof(addAssignment_11647,axiom,
    ! [VarCurr] :
      ( v26470(VarCurr)
    <=> v184(VarCurr,bitIndex0) ) ).

fof(addAssignment_11646,axiom,
    ! [VarCurr] :
      ( v26468(VarCurr)
    <=> v85(VarCurr,bitIndex0) ) ).

fof(addCaseBooleanConditionEqualRanges1_471,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26449(VarNext)
       => ( v26438(VarNext)
        <=> v26438(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_410,axiom,
    ! [VarNext] :
      ( v26449(VarNext)
     => ( v26438(VarNext)
      <=> v26459(VarNext) ) ) ).

fof(addAssignment_11645,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26459(VarNext)
      <=> v26457(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_743,axiom,
    ! [VarCurr] :
      ( ~ v26460(VarCurr)
     => ( v26457(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_497,axiom,
    ! [VarCurr] :
      ( v26460(VarCurr)
     => ( v26457(VarCurr)
      <=> v26444(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4581,axiom,
    ! [VarCurr] :
      ( v26460(VarCurr)
    <=> ( v26461(VarCurr)
        & v26462(VarCurr) ) ) ).

fof(writeUnaryOperator_2417,axiom,
    ! [VarCurr] :
      ( ~ v26462(VarCurr)
    <=> v26442(VarCurr) ) ).

fof(writeUnaryOperator_2416,axiom,
    ! [VarCurr] :
      ( ~ v26461(VarCurr)
    <=> v26440(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4580,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26449(VarNext)
      <=> v26450(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4579,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26450(VarNext)
      <=> ( v26451(VarNext)
          & v26446(VarNext) ) ) ) ).

fof(writeUnaryOperator_2415,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26451(VarNext)
      <=> v26453(VarNext) ) ) ).

fof(addAssignment_11644,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26453(VarNext)
      <=> v26446(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_975,axiom,
    ( v26438(constB0)
  <=> $false ) ).

fof(addAssignment_11643,axiom,
    ! [VarCurr] :
      ( v26446(VarCurr)
    <=> v103(VarCurr,bitIndex0) ) ).

fof(addAssignment_11642,axiom,
    ! [VarCurr] :
      ( v26444(VarCurr)
    <=> v26229(VarCurr,bitIndex2) ) ).

fof(addAssignment_11641,axiom,
    ! [VarCurr] :
      ( v26229(VarCurr,bitIndex2)
    <=> v26231(VarCurr,bitIndex2) ) ).

fof(addAssignment_11640,axiom,
    ! [VarCurr] :
      ( v26231(VarCurr,bitIndex2)
    <=> v26260(VarCurr,bitIndex2) ) ).

fof(addAssignment_11639,axiom,
    ! [VarCurr] :
      ( v26233(VarCurr,bitIndex2)
    <=> v26259(VarCurr,bitIndex2) ) ).

fof(addAssignment_11638,axiom,
    ! [VarCurr] :
      ( v26244(VarCurr,bitIndex2)
    <=> v26246(VarCurr,bitIndex2) ) ).

fof(addAssignment_11637,axiom,
    ! [VarCurr] :
      ( v26246(VarCurr,bitIndex2)
    <=> v26248(VarCurr,bitIndex2) ) ).

fof(addAssignment_11636,axiom,
    ! [VarCurr] :
      ( v26248(VarCurr,bitIndex2)
    <=> v26250(VarCurr,bitIndex2) ) ).

fof(addAssignment_11635,axiom,
    ! [VarCurr] :
      ( v26250(VarCurr,bitIndex2)
    <=> v12022(VarCurr,bitIndex2) ) ).

fof(addAssignment_11634,axiom,
    ! [VarCurr] :
      ( v26235(VarCurr,bitIndex2)
    <=> v26237(VarCurr,bitIndex2) ) ).

fof(addAssignment_11633,axiom,
    ! [VarCurr] :
      ( v26237(VarCurr,bitIndex2)
    <=> v26239(VarCurr,bitIndex2) ) ).

fof(addAssignment_11632,axiom,
    ! [VarCurr] :
      ( v26239(VarCurr,bitIndex2)
    <=> v26241(VarCurr,bitIndex2) ) ).

fof(addAssignment_11631,axiom,
    ! [VarCurr] :
      ( v26241(VarCurr,bitIndex2)
    <=> v26242(VarCurr,bitIndex2) ) ).

fof(addAssignment_11630,axiom,
    ! [VarCurr] :
      ( v26442(VarCurr)
    <=> v184(VarCurr,bitIndex0) ) ).

fof(addAssignment_11629,axiom,
    ! [VarCurr] :
      ( v26440(VarCurr)
    <=> v85(VarCurr,bitIndex0) ) ).

fof(addCaseBooleanConditionEqualRanges1_470,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26421(VarNext)
       => ( v26410(VarNext)
        <=> v26410(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_409,axiom,
    ! [VarNext] :
      ( v26421(VarNext)
     => ( v26410(VarNext)
      <=> v26431(VarNext) ) ) ).

fof(addAssignment_11628,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26431(VarNext)
      <=> v26429(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_742,axiom,
    ! [VarCurr] :
      ( ~ v26432(VarCurr)
     => ( v26429(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_496,axiom,
    ! [VarCurr] :
      ( v26432(VarCurr)
     => ( v26429(VarCurr)
      <=> v26416(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4578,axiom,
    ! [VarCurr] :
      ( v26432(VarCurr)
    <=> ( v26433(VarCurr)
        & v26434(VarCurr) ) ) ).

fof(writeUnaryOperator_2414,axiom,
    ! [VarCurr] :
      ( ~ v26434(VarCurr)
    <=> v26414(VarCurr) ) ).

fof(writeUnaryOperator_2413,axiom,
    ! [VarCurr] :
      ( ~ v26433(VarCurr)
    <=> v26412(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4577,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26421(VarNext)
      <=> v26422(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4576,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26422(VarNext)
      <=> ( v26423(VarNext)
          & v26418(VarNext) ) ) ) ).

fof(writeUnaryOperator_2412,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26423(VarNext)
      <=> v26425(VarNext) ) ) ).

fof(addAssignment_11627,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26425(VarNext)
      <=> v26418(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_974,axiom,
    ( v26410(constB0)
  <=> $false ) ).

fof(addAssignment_11626,axiom,
    ! [VarCurr] :
      ( v26418(VarCurr)
    <=> v103(VarCurr,bitIndex0) ) ).

fof(addAssignment_11625,axiom,
    ! [VarCurr] :
      ( v26416(VarCurr)
    <=> v26229(VarCurr,bitIndex3) ) ).

fof(addAssignment_11624,axiom,
    ! [VarCurr] :
      ( v26229(VarCurr,bitIndex3)
    <=> v26231(VarCurr,bitIndex3) ) ).

fof(addAssignment_11623,axiom,
    ! [VarCurr] :
      ( v26231(VarCurr,bitIndex3)
    <=> v26260(VarCurr,bitIndex3) ) ).

fof(addAssignment_11622,axiom,
    ! [VarCurr] :
      ( v26233(VarCurr,bitIndex3)
    <=> v26259(VarCurr,bitIndex3) ) ).

fof(addAssignment_11621,axiom,
    ! [VarCurr] :
      ( v26244(VarCurr,bitIndex3)
    <=> v26246(VarCurr,bitIndex3) ) ).

fof(addAssignment_11620,axiom,
    ! [VarCurr] :
      ( v26246(VarCurr,bitIndex3)
    <=> v26248(VarCurr,bitIndex3) ) ).

fof(addAssignment_11619,axiom,
    ! [VarCurr] :
      ( v26248(VarCurr,bitIndex3)
    <=> v26250(VarCurr,bitIndex3) ) ).

fof(addAssignment_11618,axiom,
    ! [VarCurr] :
      ( v26250(VarCurr,bitIndex3)
    <=> v12022(VarCurr,bitIndex3) ) ).

fof(addAssignment_11617,axiom,
    ! [VarCurr] :
      ( v26235(VarCurr,bitIndex3)
    <=> v26237(VarCurr,bitIndex3) ) ).

fof(addAssignment_11616,axiom,
    ! [VarCurr] :
      ( v26237(VarCurr,bitIndex3)
    <=> v26239(VarCurr,bitIndex3) ) ).

fof(addAssignment_11615,axiom,
    ! [VarCurr] :
      ( v26239(VarCurr,bitIndex3)
    <=> v26241(VarCurr,bitIndex3) ) ).

fof(addAssignment_11614,axiom,
    ! [VarCurr] :
      ( v26241(VarCurr,bitIndex3)
    <=> v26242(VarCurr,bitIndex3) ) ).

fof(addAssignment_11613,axiom,
    ! [VarCurr] :
      ( v26414(VarCurr)
    <=> v184(VarCurr,bitIndex0) ) ).

fof(addAssignment_11612,axiom,
    ! [VarCurr] :
      ( v26412(VarCurr)
    <=> v85(VarCurr,bitIndex0) ) ).

fof(addCaseBooleanConditionEqualRanges1_469,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26393(VarNext)
       => ( v26382(VarNext)
        <=> v26382(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_408,axiom,
    ! [VarNext] :
      ( v26393(VarNext)
     => ( v26382(VarNext)
      <=> v26403(VarNext) ) ) ).

fof(addAssignment_11611,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26403(VarNext)
      <=> v26401(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_741,axiom,
    ! [VarCurr] :
      ( ~ v26404(VarCurr)
     => ( v26401(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_495,axiom,
    ! [VarCurr] :
      ( v26404(VarCurr)
     => ( v26401(VarCurr)
      <=> v26388(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4575,axiom,
    ! [VarCurr] :
      ( v26404(VarCurr)
    <=> ( v26405(VarCurr)
        & v26406(VarCurr) ) ) ).

fof(writeUnaryOperator_2411,axiom,
    ! [VarCurr] :
      ( ~ v26406(VarCurr)
    <=> v26386(VarCurr) ) ).

fof(writeUnaryOperator_2410,axiom,
    ! [VarCurr] :
      ( ~ v26405(VarCurr)
    <=> v26384(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4574,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26393(VarNext)
      <=> v26394(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4573,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26394(VarNext)
      <=> ( v26395(VarNext)
          & v26390(VarNext) ) ) ) ).

fof(writeUnaryOperator_2409,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26395(VarNext)
      <=> v26397(VarNext) ) ) ).

fof(addAssignment_11610,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26397(VarNext)
      <=> v26390(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_973,axiom,
    ( v26382(constB0)
  <=> $false ) ).

fof(addAssignment_11609,axiom,
    ! [VarCurr] :
      ( v26390(VarCurr)
    <=> v103(VarCurr,bitIndex0) ) ).

fof(addAssignment_11608,axiom,
    ! [VarCurr] :
      ( v26388(VarCurr)
    <=> v26229(VarCurr,bitIndex4) ) ).

fof(addAssignment_11607,axiom,
    ! [VarCurr] :
      ( v26229(VarCurr,bitIndex4)
    <=> v26231(VarCurr,bitIndex4) ) ).

fof(addAssignment_11606,axiom,
    ! [VarCurr] :
      ( v26231(VarCurr,bitIndex4)
    <=> v26260(VarCurr,bitIndex4) ) ).

fof(addAssignment_11605,axiom,
    ! [VarCurr] :
      ( v26233(VarCurr,bitIndex4)
    <=> v26259(VarCurr,bitIndex4) ) ).

fof(addAssignment_11604,axiom,
    ! [VarCurr] :
      ( v26244(VarCurr,bitIndex4)
    <=> v26246(VarCurr,bitIndex4) ) ).

fof(addAssignment_11603,axiom,
    ! [VarCurr] :
      ( v26246(VarCurr,bitIndex4)
    <=> v26248(VarCurr,bitIndex4) ) ).

fof(addAssignment_11602,axiom,
    ! [VarCurr] :
      ( v26248(VarCurr,bitIndex4)
    <=> v26250(VarCurr,bitIndex4) ) ).

fof(addAssignment_11601,axiom,
    ! [VarCurr] :
      ( v26250(VarCurr,bitIndex4)
    <=> v12022(VarCurr,bitIndex4) ) ).

fof(addAssignment_11600,axiom,
    ! [VarCurr] :
      ( v26235(VarCurr,bitIndex4)
    <=> v26237(VarCurr,bitIndex4) ) ).

fof(addAssignment_11599,axiom,
    ! [VarCurr] :
      ( v26237(VarCurr,bitIndex4)
    <=> v26239(VarCurr,bitIndex4) ) ).

fof(addAssignment_11598,axiom,
    ! [VarCurr] :
      ( v26239(VarCurr,bitIndex4)
    <=> v26241(VarCurr,bitIndex4) ) ).

fof(addAssignment_11597,axiom,
    ! [VarCurr] :
      ( v26241(VarCurr,bitIndex4)
    <=> v26242(VarCurr,bitIndex4) ) ).

fof(addAssignment_11596,axiom,
    ! [VarCurr] :
      ( v26386(VarCurr)
    <=> v184(VarCurr,bitIndex0) ) ).

fof(addAssignment_11595,axiom,
    ! [VarCurr] :
      ( v26384(VarCurr)
    <=> v85(VarCurr,bitIndex0) ) ).

fof(addCaseBooleanConditionEqualRanges1_468,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26365(VarNext)
       => ( v26354(VarNext)
        <=> v26354(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_407,axiom,
    ! [VarNext] :
      ( v26365(VarNext)
     => ( v26354(VarNext)
      <=> v26375(VarNext) ) ) ).

fof(addAssignment_11594,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26375(VarNext)
      <=> v26373(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_740,axiom,
    ! [VarCurr] :
      ( ~ v26376(VarCurr)
     => ( v26373(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_494,axiom,
    ! [VarCurr] :
      ( v26376(VarCurr)
     => ( v26373(VarCurr)
      <=> v26360(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4572,axiom,
    ! [VarCurr] :
      ( v26376(VarCurr)
    <=> ( v26377(VarCurr)
        & v26378(VarCurr) ) ) ).

fof(writeUnaryOperator_2408,axiom,
    ! [VarCurr] :
      ( ~ v26378(VarCurr)
    <=> v26358(VarCurr) ) ).

fof(writeUnaryOperator_2407,axiom,
    ! [VarCurr] :
      ( ~ v26377(VarCurr)
    <=> v26356(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4571,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26365(VarNext)
      <=> v26366(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4570,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26366(VarNext)
      <=> ( v26367(VarNext)
          & v26362(VarNext) ) ) ) ).

fof(writeUnaryOperator_2406,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26367(VarNext)
      <=> v26369(VarNext) ) ) ).

fof(addAssignment_11593,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26369(VarNext)
      <=> v26362(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_972,axiom,
    ( v26354(constB0)
  <=> $false ) ).

fof(addAssignment_11592,axiom,
    ! [VarCurr] :
      ( v26362(VarCurr)
    <=> v103(VarCurr,bitIndex0) ) ).

fof(addAssignment_11591,axiom,
    ! [VarCurr] :
      ( v26360(VarCurr)
    <=> v26229(VarCurr,bitIndex5) ) ).

fof(addAssignment_11590,axiom,
    ! [VarCurr] :
      ( v26229(VarCurr,bitIndex5)
    <=> v26231(VarCurr,bitIndex5) ) ).

fof(addAssignment_11589,axiom,
    ! [VarCurr] :
      ( v26231(VarCurr,bitIndex5)
    <=> v26260(VarCurr,bitIndex5) ) ).

fof(addAssignment_11588,axiom,
    ! [VarCurr] :
      ( v26233(VarCurr,bitIndex5)
    <=> v26259(VarCurr,bitIndex5) ) ).

fof(addAssignment_11587,axiom,
    ! [VarCurr] :
      ( v26244(VarCurr,bitIndex5)
    <=> v26246(VarCurr,bitIndex5) ) ).

fof(addAssignment_11586,axiom,
    ! [VarCurr] :
      ( v26246(VarCurr,bitIndex5)
    <=> v26248(VarCurr,bitIndex5) ) ).

fof(addAssignment_11585,axiom,
    ! [VarCurr] :
      ( v26248(VarCurr,bitIndex5)
    <=> v26250(VarCurr,bitIndex5) ) ).

fof(addAssignment_11584,axiom,
    ! [VarCurr] :
      ( v26250(VarCurr,bitIndex5)
    <=> v12022(VarCurr,bitIndex5) ) ).

fof(addAssignment_11583,axiom,
    ! [VarCurr] :
      ( v26235(VarCurr,bitIndex5)
    <=> v26237(VarCurr,bitIndex5) ) ).

fof(addAssignment_11582,axiom,
    ! [VarCurr] :
      ( v26237(VarCurr,bitIndex5)
    <=> v26239(VarCurr,bitIndex5) ) ).

fof(addAssignment_11581,axiom,
    ! [VarCurr] :
      ( v26239(VarCurr,bitIndex5)
    <=> v26241(VarCurr,bitIndex5) ) ).

fof(addAssignment_11580,axiom,
    ! [VarCurr] :
      ( v26241(VarCurr,bitIndex5)
    <=> v26242(VarCurr,bitIndex5) ) ).

fof(addAssignment_11579,axiom,
    ! [VarCurr] :
      ( v26358(VarCurr)
    <=> v184(VarCurr,bitIndex0) ) ).

fof(addAssignment_11578,axiom,
    ! [VarCurr] :
      ( v26356(VarCurr)
    <=> v85(VarCurr,bitIndex0) ) ).

fof(addCaseBooleanConditionEqualRanges1_467,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26337(VarNext)
       => ( v26318(VarNext)
        <=> v26318(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_406,axiom,
    ! [VarNext] :
      ( v26337(VarNext)
     => ( v26318(VarNext)
      <=> v26347(VarNext) ) ) ).

fof(addAssignment_11577,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26347(VarNext)
      <=> v26345(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_739,axiom,
    ! [VarCurr] :
      ( ~ v26348(VarCurr)
     => ( v26345(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_493,axiom,
    ! [VarCurr] :
      ( v26348(VarCurr)
     => ( v26345(VarCurr)
      <=> v26324(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4569,axiom,
    ! [VarCurr] :
      ( v26348(VarCurr)
    <=> ( v26349(VarCurr)
        & v26350(VarCurr) ) ) ).

fof(writeUnaryOperator_2405,axiom,
    ! [VarCurr] :
      ( ~ v26350(VarCurr)
    <=> v26322(VarCurr) ) ).

fof(writeUnaryOperator_2404,axiom,
    ! [VarCurr] :
      ( ~ v26349(VarCurr)
    <=> v26320(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4568,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26337(VarNext)
      <=> v26338(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4567,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26338(VarNext)
      <=> ( v26339(VarNext)
          & v26334(VarNext) ) ) ) ).

fof(writeUnaryOperator_2403,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26339(VarNext)
      <=> v26341(VarNext) ) ) ).

fof(addAssignment_11576,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26341(VarNext)
      <=> v26334(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_971,axiom,
    ( v26318(constB0)
  <=> $false ) ).

fof(addAssignment_11575,axiom,
    ! [VarCurr] :
      ( v26334(VarCurr)
    <=> v103(VarCurr,bitIndex0) ) ).

fof(addAssignment_11574,axiom,
    ! [VarCurr] :
      ( v26324(VarCurr)
    <=> v26229(VarCurr,bitIndex6) ) ).

fof(addAssignment_11573,axiom,
    ! [VarCurr] :
      ( v26229(VarCurr,bitIndex6)
    <=> v26231(VarCurr,bitIndex6) ) ).

fof(addAssignment_11572,axiom,
    ! [VarCurr] :
      ( v26231(VarCurr,bitIndex6)
    <=> v26260(VarCurr,bitIndex6) ) ).

fof(addAssignment_11571,axiom,
    ! [VarCurr] :
      ( v26233(VarCurr,bitIndex6)
    <=> v26259(VarCurr,bitIndex6) ) ).

fof(addAssignment_11570,axiom,
    ! [VarCurr] :
      ( v26244(VarCurr,bitIndex6)
    <=> v26246(VarCurr,bitIndex6) ) ).

fof(addAssignment_11569,axiom,
    ! [VarCurr] :
      ( v26246(VarCurr,bitIndex6)
    <=> v26248(VarCurr,bitIndex6) ) ).

fof(addAssignment_11568,axiom,
    ! [VarCurr] :
      ( v26248(VarCurr,bitIndex6)
    <=> v26250(VarCurr,bitIndex6) ) ).

fof(addAssignment_11567,axiom,
    ! [VarCurr] :
      ( v26250(VarCurr,bitIndex6)
    <=> v12022(VarCurr,bitIndex6) ) ).

fof(addAssignment_11566,axiom,
    ! [VarNext] :
      ( v12022(VarNext,bitIndex6)
    <=> v26326(VarNext,bitIndex6) ) ).

fof(addCaseBooleanConditionEqualRanges1_466,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26327(VarNext)
       => ! [B] :
            ( range_8_0(B)
           => ( v26326(VarNext,B)
            <=> v12022(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_405,axiom,
    ! [VarNext] :
      ( v26327(VarNext)
     => ! [B] :
          ( range_8_0(B)
         => ( v26326(VarNext,B)
          <=> v12055(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4566,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26327(VarNext)
      <=> v26328(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4565,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26328(VarNext)
      <=> ( v26330(VarNext)
          & v2967(VarNext) ) ) ) ).

fof(writeUnaryOperator_2402,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26330(VarNext)
      <=> v2974(VarNext) ) ) ).

fof(addAssignment_11565,axiom,
    ! [VarCurr] :
      ( v26235(VarCurr,bitIndex6)
    <=> v26237(VarCurr,bitIndex6) ) ).

fof(addAssignment_11564,axiom,
    ! [VarCurr] :
      ( v26237(VarCurr,bitIndex6)
    <=> v26239(VarCurr,bitIndex6) ) ).

fof(addAssignment_11563,axiom,
    ! [VarCurr] :
      ( v26239(VarCurr,bitIndex6)
    <=> v26241(VarCurr,bitIndex6) ) ).

fof(addAssignment_11562,axiom,
    ! [VarCurr] :
      ( v26241(VarCurr,bitIndex6)
    <=> v26242(VarCurr,bitIndex6) ) ).

fof(addAssignment_11561,axiom,
    ! [VarCurr] :
      ( v26322(VarCurr)
    <=> v184(VarCurr,bitIndex0) ) ).

fof(addAssignment_11560,axiom,
    ! [VarCurr] :
      ( v26320(VarCurr)
    <=> v85(VarCurr,bitIndex0) ) ).

fof(addCaseBooleanConditionEqualRanges1_465,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26301(VarNext)
       => ( v26282(VarNext)
        <=> v26282(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_404,axiom,
    ! [VarNext] :
      ( v26301(VarNext)
     => ( v26282(VarNext)
      <=> v26311(VarNext) ) ) ).

fof(addAssignment_11559,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26311(VarNext)
      <=> v26309(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_738,axiom,
    ! [VarCurr] :
      ( ~ v26312(VarCurr)
     => ( v26309(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_492,axiom,
    ! [VarCurr] :
      ( v26312(VarCurr)
     => ( v26309(VarCurr)
      <=> v26288(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4564,axiom,
    ! [VarCurr] :
      ( v26312(VarCurr)
    <=> ( v26313(VarCurr)
        & v26314(VarCurr) ) ) ).

fof(writeUnaryOperator_2401,axiom,
    ! [VarCurr] :
      ( ~ v26314(VarCurr)
    <=> v26286(VarCurr) ) ).

fof(writeUnaryOperator_2400,axiom,
    ! [VarCurr] :
      ( ~ v26313(VarCurr)
    <=> v26284(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4563,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26301(VarNext)
      <=> v26302(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4562,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26302(VarNext)
      <=> ( v26303(VarNext)
          & v26298(VarNext) ) ) ) ).

fof(writeUnaryOperator_2399,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26303(VarNext)
      <=> v26305(VarNext) ) ) ).

fof(addAssignment_11558,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26305(VarNext)
      <=> v26298(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_970,axiom,
    ( v26282(constB0)
  <=> $false ) ).

fof(addAssignment_11557,axiom,
    ! [VarCurr] :
      ( v26298(VarCurr)
    <=> v103(VarCurr,bitIndex0) ) ).

fof(addAssignment_11556,axiom,
    ! [VarCurr] :
      ( v26288(VarCurr)
    <=> v26229(VarCurr,bitIndex7) ) ).

fof(addAssignment_11555,axiom,
    ! [VarCurr] :
      ( v26229(VarCurr,bitIndex7)
    <=> v26231(VarCurr,bitIndex7) ) ).

fof(addAssignment_11554,axiom,
    ! [VarCurr] :
      ( v26231(VarCurr,bitIndex7)
    <=> v26260(VarCurr,bitIndex7) ) ).

fof(addAssignment_11553,axiom,
    ! [VarCurr] :
      ( v26233(VarCurr,bitIndex7)
    <=> v26259(VarCurr,bitIndex7) ) ).

fof(addAssignment_11552,axiom,
    ! [VarCurr] :
      ( v26244(VarCurr,bitIndex7)
    <=> v26246(VarCurr,bitIndex7) ) ).

fof(addAssignment_11551,axiom,
    ! [VarCurr] :
      ( v26246(VarCurr,bitIndex7)
    <=> v26248(VarCurr,bitIndex7) ) ).

fof(addAssignment_11550,axiom,
    ! [VarCurr] :
      ( v26248(VarCurr,bitIndex7)
    <=> v26250(VarCurr,bitIndex7) ) ).

fof(addAssignment_11549,axiom,
    ! [VarCurr] :
      ( v26250(VarCurr,bitIndex7)
    <=> v12022(VarCurr,bitIndex7) ) ).

fof(addAssignment_11548,axiom,
    ! [VarNext] :
      ( v12022(VarNext,bitIndex7)
    <=> v26290(VarNext,bitIndex7) ) ).

fof(addCaseBooleanConditionEqualRanges1_464,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26291(VarNext)
       => ! [B] :
            ( range_8_0(B)
           => ( v26290(VarNext,B)
            <=> v12022(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_403,axiom,
    ! [VarNext] :
      ( v26291(VarNext)
     => ! [B] :
          ( range_8_0(B)
         => ( v26290(VarNext,B)
          <=> v12055(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4561,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26291(VarNext)
      <=> v26292(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4560,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26292(VarNext)
      <=> ( v26294(VarNext)
          & v2967(VarNext) ) ) ) ).

fof(writeUnaryOperator_2398,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26294(VarNext)
      <=> v2974(VarNext) ) ) ).

fof(addAssignment_11547,axiom,
    ! [VarCurr] :
      ( v26235(VarCurr,bitIndex7)
    <=> v26237(VarCurr,bitIndex7) ) ).

fof(addAssignment_11546,axiom,
    ! [VarCurr] :
      ( v26237(VarCurr,bitIndex7)
    <=> v26239(VarCurr,bitIndex7) ) ).

fof(addAssignment_11545,axiom,
    ! [VarCurr] :
      ( v26239(VarCurr,bitIndex7)
    <=> v26241(VarCurr,bitIndex7) ) ).

fof(addAssignment_11544,axiom,
    ! [VarCurr] :
      ( v26241(VarCurr,bitIndex7)
    <=> v26242(VarCurr,bitIndex7) ) ).

fof(addAssignment_11543,axiom,
    ! [VarCurr] :
      ( v26286(VarCurr)
    <=> v184(VarCurr,bitIndex0) ) ).

fof(addAssignment_11542,axiom,
    ! [VarCurr] :
      ( v26284(VarCurr)
    <=> v85(VarCurr,bitIndex0) ) ).

fof(addCaseBooleanConditionEqualRanges1_463,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26265(VarNext)
       => ( v26221(VarNext)
        <=> v26221(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_402,axiom,
    ! [VarNext] :
      ( v26265(VarNext)
     => ( v26221(VarNext)
      <=> v26275(VarNext) ) ) ).

fof(addAssignment_11541,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26275(VarNext)
      <=> v26273(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_737,axiom,
    ! [VarCurr] :
      ( ~ v26276(VarCurr)
     => ( v26273(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_491,axiom,
    ! [VarCurr] :
      ( v26276(VarCurr)
     => ( v26273(VarCurr)
      <=> v26227(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4559,axiom,
    ! [VarCurr] :
      ( v26276(VarCurr)
    <=> ( v26277(VarCurr)
        & v26278(VarCurr) ) ) ).

fof(writeUnaryOperator_2397,axiom,
    ! [VarCurr] :
      ( ~ v26278(VarCurr)
    <=> v26225(VarCurr) ) ).

fof(writeUnaryOperator_2396,axiom,
    ! [VarCurr] :
      ( ~ v26277(VarCurr)
    <=> v26223(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4558,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26265(VarNext)
      <=> v26266(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4557,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26266(VarNext)
      <=> ( v26267(VarNext)
          & v26262(VarNext) ) ) ) ).

fof(writeUnaryOperator_2395,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26267(VarNext)
      <=> v26269(VarNext) ) ) ).

fof(addAssignment_11540,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26269(VarNext)
      <=> v26262(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_969,axiom,
    ( v26221(constB0)
  <=> $false ) ).

fof(addAssignment_11539,axiom,
    ! [VarCurr] :
      ( v26262(VarCurr)
    <=> v103(VarCurr,bitIndex0) ) ).

fof(addAssignment_11538,axiom,
    ! [VarCurr] :
      ( v26227(VarCurr)
    <=> v26229(VarCurr,bitIndex8) ) ).

fof(addAssignment_11537,axiom,
    ! [VarCurr] :
      ( v26229(VarCurr,bitIndex8)
    <=> v26231(VarCurr,bitIndex8) ) ).

fof(addAssignment_11536,axiom,
    ! [VarCurr] :
      ( v26231(VarCurr,bitIndex8)
    <=> v26260(VarCurr,bitIndex8) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_736,axiom,
    ! [VarCurr] :
      ( ~ v154(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v26260(VarCurr,B)
          <=> v26233(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_490,axiom,
    ! [VarCurr] :
      ( v154(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v26260(VarCurr,B)
          <=> v25786(VarCurr,B) ) ) ) ).

fof(addAssignment_11535,axiom,
    ! [VarCurr] :
      ( v26233(VarCurr,bitIndex8)
    <=> v26259(VarCurr,bitIndex8) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_735,axiom,
    ! [VarCurr] :
      ( ~ v214(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v26259(VarCurr,B)
          <=> v26244(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_489,axiom,
    ! [VarCurr] :
      ( v214(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v26259(VarCurr,B)
          <=> v26235(VarCurr,B) ) ) ) ).

fof(addAssignment_11534,axiom,
    ! [VarCurr] :
      ( v26244(VarCurr,bitIndex8)
    <=> v26246(VarCurr,bitIndex8) ) ).

fof(addAssignment_11533,axiom,
    ! [VarCurr] :
      ( v26246(VarCurr,bitIndex8)
    <=> v26248(VarCurr,bitIndex8) ) ).

fof(addAssignment_11532,axiom,
    ! [VarCurr] :
      ( v26248(VarCurr,bitIndex8)
    <=> v26250(VarCurr,bitIndex8) ) ).

fof(addAssignment_11531,axiom,
    ! [VarCurr] :
      ( v26250(VarCurr,bitIndex8)
    <=> v12022(VarCurr,bitIndex8) ) ).

fof(addAssignment_11530,axiom,
    ! [VarNext] :
      ( v12022(VarNext,bitIndex8)
    <=> v26252(VarNext,bitIndex8) ) ).

fof(addCaseBooleanConditionEqualRanges1_462,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26253(VarNext)
       => ! [B] :
            ( range_8_0(B)
           => ( v26252(VarNext,B)
            <=> v12022(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_401,axiom,
    ! [VarNext] :
      ( v26253(VarNext)
     => ! [B] :
          ( range_8_0(B)
         => ( v26252(VarNext,B)
          <=> v12055(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4556,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26253(VarNext)
      <=> v26254(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4555,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26254(VarNext)
      <=> ( v26256(VarNext)
          & v2967(VarNext) ) ) ) ).

fof(writeUnaryOperator_2394,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26256(VarNext)
      <=> v2974(VarNext) ) ) ).

fof(addAssignment_11529,axiom,
    ! [VarCurr] :
      ( v26235(VarCurr,bitIndex8)
    <=> v26237(VarCurr,bitIndex8) ) ).

fof(addAssignment_11528,axiom,
    ! [VarCurr] :
      ( v26237(VarCurr,bitIndex8)
    <=> v26239(VarCurr,bitIndex8) ) ).

fof(addAssignment_11527,axiom,
    ! [VarCurr] :
      ( v26239(VarCurr,bitIndex8)
    <=> v26241(VarCurr,bitIndex8) ) ).

fof(addAssignment_11526,axiom,
    ! [VarCurr] :
      ( v26241(VarCurr,bitIndex8)
    <=> v26242(VarCurr,bitIndex8) ) ).

fof(addAssignment_11525,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v26242(VarCurr,B)
      <=> v24172(VarCurr,B) ) ) ).

fof(addAssignment_11524,axiom,
    ! [VarCurr] :
      ( ( v26242(VarCurr,bitIndex8)
      <=> v24283(VarCurr,bitIndex5) )
      & ( v26242(VarCurr,bitIndex7)
      <=> v24283(VarCurr,bitIndex4) )
      & ( v26242(VarCurr,bitIndex6)
      <=> v24283(VarCurr,bitIndex3) )
      & ( v26242(VarCurr,bitIndex5)
      <=> v24283(VarCurr,bitIndex2) )
      & ( v26242(VarCurr,bitIndex4)
      <=> v24283(VarCurr,bitIndex1) )
      & ( v26242(VarCurr,bitIndex3)
      <=> v24283(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_11523,axiom,
    ! [VarCurr] :
      ( v26225(VarCurr)
    <=> v184(VarCurr,bitIndex0) ) ).

fof(addAssignment_11522,axiom,
    ! [VarCurr] :
      ( v26223(VarCurr)
    <=> v85(VarCurr,bitIndex0) ) ).

fof(addAssignment_11521,axiom,
    ! [VarCurr,B] :
      ( range_8_0(B)
     => ( v25768(VarCurr,B)
      <=> v25770(VarCurr,B) ) ) ).

fof(addAssignment_11520,axiom,
    ! [VarCurr] :
      ( v25770(VarCurr,bitIndex8)
    <=> v25772(VarCurr) ) ).

fof(addAssignment_11519,axiom,
    ! [VarCurr] :
      ( v25770(VarCurr,bitIndex7)
    <=> v25855(VarCurr) ) ).

fof(addAssignment_11518,axiom,
    ! [VarCurr] :
      ( v25770(VarCurr,bitIndex6)
    <=> v25902(VarCurr) ) ).

fof(addAssignment_11517,axiom,
    ! [VarCurr] :
      ( v25770(VarCurr,bitIndex5)
    <=> v25947(VarCurr) ) ).

fof(addAssignment_11516,axiom,
    ! [VarCurr] :
      ( v25770(VarCurr,bitIndex4)
    <=> v25992(VarCurr) ) ).

fof(addAssignment_11515,axiom,
    ! [VarCurr] :
      ( v25770(VarCurr,bitIndex3)
    <=> v26037(VarCurr) ) ).

fof(addAssignment_11514,axiom,
    ! [VarCurr] :
      ( v25770(VarCurr,bitIndex2)
    <=> v26082(VarCurr) ) ).

fof(addAssignment_11513,axiom,
    ! [VarCurr] :
      ( v25770(VarCurr,bitIndex1)
    <=> v26127(VarCurr) ) ).

fof(addAssignment_11512,axiom,
    ! [VarCurr] :
      ( v25770(VarCurr,bitIndex0)
    <=> v26172(VarCurr) ) ).

fof(addAssignment_11511,axiom,
    ! [VarCurr] :
      ( v26172(VarCurr)
    <=> v26174(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_734,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26198(VarNext)
       => ( v26174(VarNext)
        <=> v26174(VarCurr) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_488,axiom,
    ! [VarNext] :
      ( v26198(VarNext)
     => ( v26174(VarNext)
      <=> v26210(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_605,axiom,
    ! [VarCurr] :
      ( ~ v26199(VarCurr)
     => ( v26210(VarCurr)
      <=> v26211(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_611,axiom,
    ! [VarCurr] :
      ( v26199(VarCurr)
     => ( v26210(VarCurr)
      <=> v26180(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_604,axiom,
    ! [VarCurr] :
      ( ~ v26204(VarCurr)
     => ( v26211(VarCurr)
      <=> v26182(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_610,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26204(VarCurr)
       => ( v26211(VarCurr)
        <=> x166(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4554,axiom,
    ! [VarCurr] :
      ( v26198(VarCurr)
    <=> ( v26199(VarCurr)
        | v26202(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4553,axiom,
    ! [VarCurr] :
      ( v26202(VarCurr)
    <=> ( v26203(VarCurr)
        & v26209(VarCurr) ) ) ).

fof(writeUnaryOperator_2393,axiom,
    ! [VarCurr] :
      ( ~ v26209(VarCurr)
    <=> v26199(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4552,axiom,
    ! [VarCurr] :
      ( v26203(VarCurr)
    <=> ( v26204(VarCurr)
        | v26206(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4551,axiom,
    ! [VarCurr] :
      ( v26206(VarCurr)
    <=> ( v26207(VarCurr)
        & v26208(VarCurr) ) ) ).

fof(writeUnaryOperator_2392,axiom,
    ! [VarCurr] :
      ( ~ v26208(VarCurr)
    <=> v26204(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4550,axiom,
    ! [VarCurr] :
      ( v26207(VarCurr)
    <=> ( v26176(VarCurr)
        & v26178(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4549,axiom,
    ! [VarCurr] :
      ( v26204(VarCurr)
    <=> ( v26176(VarCurr)
        & v26205(VarCurr) ) ) ).

fof(writeUnaryOperator_2391,axiom,
    ! [VarCurr] :
      ( ~ v26205(VarCurr)
    <=> v26178(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4548,axiom,
    ! [VarCurr] :
      ( v26199(VarCurr)
    <=> ( v26200(VarCurr)
        & v26201(VarCurr) ) ) ).

fof(writeUnaryOperator_2390,axiom,
    ! [VarCurr] :
      ( ~ v26201(VarCurr)
    <=> v26178(VarCurr) ) ).

fof(writeUnaryOperator_2389,axiom,
    ! [VarCurr] :
      ( ~ v26200(VarCurr)
    <=> v26176(VarCurr) ) ).

fof(addAssignmentInitValueVector_968,axiom,
    ( v26174(constB0)
  <=> $false ) ).

fof(addAssignment_11510,axiom,
    ! [VarCurr] :
      ( v26182(VarCurr)
    <=> v25867(VarCurr,bitIndex1) ) ).

fof(addAssignment_11509,axiom,
    ! [VarCurr] :
      ( v25867(VarCurr,bitIndex1)
    <=> v26184(VarCurr) ) ).

fof(addAssignment_11508,axiom,
    ! [VarCurr] :
      ( v26184(VarCurr)
    <=> v26186(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_733,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26191(VarNext)
       => ( v26186(VarNext)
        <=> v26186(VarCurr) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_487,axiom,
    ! [VarNext] :
      ( v26191(VarNext)
     => ( v26186(VarNext)
      <=> v26129(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4547,axiom,
    ! [VarCurr] :
      ( v26191(VarCurr)
    <=> ( v26133(VarCurr)
        & v26192(VarCurr) ) ) ).

fof(writeUnaryOperator_2388,axiom,
    ! [VarCurr] :
      ( ~ v26192(VarCurr)
    <=> v26188(VarCurr) ) ).

fof(addAssignmentInitValueVector_967,axiom,
    ( v26186(constB0)
  <=> $false ) ).

fof(addAssignment_11507,axiom,
    ! [VarCurr] :
      ( v26188(VarCurr)
    <=> v184(VarCurr,bitIndex0) ) ).

fof(addAssignment_11506,axiom,
    ! [VarCurr] :
      ( v26180(VarCurr)
    <=> v25782(VarCurr,bitIndex0) ) ).

fof(addAssignment_11505,axiom,
    ! [VarCurr] :
      ( v25782(VarCurr,bitIndex0)
    <=> v25784(VarCurr,bitIndex0) ) ).

fof(addAssignment_11504,axiom,
    ! [VarCurr] :
      ( v25784(VarCurr,bitIndex0)
    <=> v25816(VarCurr,bitIndex0) ) ).

fof(addAssignment_11503,axiom,
    ! [VarCurr] :
      ( v25792(VarCurr,bitIndex0)
    <=> v25815(VarCurr,bitIndex0) ) ).

fof(addAssignment_11502,axiom,
    ! [VarCurr] :
      ( v25808(VarCurr,bitIndex0)
    <=> v25810(VarCurr,bitIndex0) ) ).

fof(addAssignment_11501,axiom,
    ! [VarCurr] :
      ( v25810(VarCurr,bitIndex0)
    <=> v25812(VarCurr,bitIndex0) ) ).

fof(addAssignment_11500,axiom,
    ! [VarCurr] :
      ( v25812(VarCurr,bitIndex0)
    <=> v25814(VarCurr,bitIndex0) ) ).

fof(addAssignment_11499,axiom,
    ! [VarCurr] :
      ( v25814(VarCurr,bitIndex0)
    <=> v12024(VarCurr,bitIndex0) ) ).

fof(addAssignment_11498,axiom,
    ! [VarCurr] :
      ( v25794(VarCurr,bitIndex0)
    <=> v25796(VarCurr,bitIndex0) ) ).

fof(addAssignment_11497,axiom,
    ! [VarCurr] :
      ( v25796(VarCurr,bitIndex0)
    <=> v25798(VarCurr,bitIndex0) ) ).

fof(addAssignment_11496,axiom,
    ! [VarCurr] :
      ( v25798(VarCurr,bitIndex0)
    <=> v25453(VarCurr,bitIndex0) ) ).

fof(addAssignment_11495,axiom,
    ! [VarCurr] :
      ( v25786(VarCurr,bitIndex0)
    <=> v25788(VarCurr,bitIndex0) ) ).

fof(addAssignment_11494,axiom,
    ! [VarCurr] :
      ( v25788(VarCurr,bitIndex0)
    <=> v25790(VarCurr,bitIndex0) ) ).

fof(addAssignment_11493,axiom,
    ! [VarCurr] :
      ( v26178(VarCurr)
    <=> v103(VarCurr,bitIndex0) ) ).

fof(addAssignment_11492,axiom,
    ! [VarCurr] :
      ( v26176(VarCurr)
    <=> v85(VarCurr,bitIndex0) ) ).

fof(addAssignment_11491,axiom,
    ! [VarCurr] :
      ( v26127(VarCurr)
    <=> v26129(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_732,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26153(VarNext)
       => ( v26129(VarNext)
        <=> v26129(VarCurr) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_486,axiom,
    ! [VarNext] :
      ( v26153(VarNext)
     => ( v26129(VarNext)
      <=> v26165(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_603,axiom,
    ! [VarCurr] :
      ( ~ v26154(VarCurr)
     => ( v26165(VarCurr)
      <=> v26166(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_609,axiom,
    ! [VarCurr] :
      ( v26154(VarCurr)
     => ( v26165(VarCurr)
      <=> v26135(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_602,axiom,
    ! [VarCurr] :
      ( ~ v26159(VarCurr)
     => ( v26166(VarCurr)
      <=> v26137(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_608,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26159(VarCurr)
       => ( v26166(VarCurr)
        <=> x166(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4546,axiom,
    ! [VarCurr] :
      ( v26153(VarCurr)
    <=> ( v26154(VarCurr)
        | v26157(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4545,axiom,
    ! [VarCurr] :
      ( v26157(VarCurr)
    <=> ( v26158(VarCurr)
        & v26164(VarCurr) ) ) ).

fof(writeUnaryOperator_2387,axiom,
    ! [VarCurr] :
      ( ~ v26164(VarCurr)
    <=> v26154(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4544,axiom,
    ! [VarCurr] :
      ( v26158(VarCurr)
    <=> ( v26159(VarCurr)
        | v26161(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4543,axiom,
    ! [VarCurr] :
      ( v26161(VarCurr)
    <=> ( v26162(VarCurr)
        & v26163(VarCurr) ) ) ).

fof(writeUnaryOperator_2386,axiom,
    ! [VarCurr] :
      ( ~ v26163(VarCurr)
    <=> v26159(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4542,axiom,
    ! [VarCurr] :
      ( v26162(VarCurr)
    <=> ( v26131(VarCurr)
        & v26133(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4541,axiom,
    ! [VarCurr] :
      ( v26159(VarCurr)
    <=> ( v26131(VarCurr)
        & v26160(VarCurr) ) ) ).

fof(writeUnaryOperator_2385,axiom,
    ! [VarCurr] :
      ( ~ v26160(VarCurr)
    <=> v26133(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4540,axiom,
    ! [VarCurr] :
      ( v26154(VarCurr)
    <=> ( v26155(VarCurr)
        & v26156(VarCurr) ) ) ).

fof(writeUnaryOperator_2384,axiom,
    ! [VarCurr] :
      ( ~ v26156(VarCurr)
    <=> v26133(VarCurr) ) ).

fof(writeUnaryOperator_2383,axiom,
    ! [VarCurr] :
      ( ~ v26155(VarCurr)
    <=> v26131(VarCurr) ) ).

fof(addAssignmentInitValueVector_966,axiom,
    ( v26129(constB0)
  <=> $false ) ).

fof(addAssignment_11490,axiom,
    ! [VarCurr] :
      ( v26137(VarCurr)
    <=> v25867(VarCurr,bitIndex2) ) ).

fof(addAssignment_11489,axiom,
    ! [VarCurr] :
      ( v25867(VarCurr,bitIndex2)
    <=> v26139(VarCurr) ) ).

fof(addAssignment_11488,axiom,
    ! [VarCurr] :
      ( v26139(VarCurr)
    <=> v26141(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_731,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26146(VarNext)
       => ( v26141(VarNext)
        <=> v26141(VarCurr) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_485,axiom,
    ! [VarNext] :
      ( v26146(VarNext)
     => ( v26141(VarNext)
      <=> v26084(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4539,axiom,
    ! [VarCurr] :
      ( v26146(VarCurr)
    <=> ( v26088(VarCurr)
        & v26147(VarCurr) ) ) ).

fof(writeUnaryOperator_2382,axiom,
    ! [VarCurr] :
      ( ~ v26147(VarCurr)
    <=> v26143(VarCurr) ) ).

fof(addAssignmentInitValueVector_965,axiom,
    ( v26141(constB0)
  <=> $false ) ).

fof(addAssignment_11487,axiom,
    ! [VarCurr] :
      ( v26143(VarCurr)
    <=> v184(VarCurr,bitIndex0) ) ).

fof(addAssignment_11486,axiom,
    ! [VarCurr] :
      ( v26135(VarCurr)
    <=> v25782(VarCurr,bitIndex1) ) ).

fof(addAssignment_11485,axiom,
    ! [VarCurr] :
      ( v25782(VarCurr,bitIndex1)
    <=> v25784(VarCurr,bitIndex1) ) ).

fof(addAssignment_11484,axiom,
    ! [VarCurr] :
      ( v25784(VarCurr,bitIndex1)
    <=> v25816(VarCurr,bitIndex1) ) ).

fof(addAssignment_11483,axiom,
    ! [VarCurr] :
      ( v25792(VarCurr,bitIndex1)
    <=> v25815(VarCurr,bitIndex1) ) ).

fof(addAssignment_11482,axiom,
    ! [VarCurr] :
      ( v25808(VarCurr,bitIndex1)
    <=> v25810(VarCurr,bitIndex1) ) ).

fof(addAssignment_11481,axiom,
    ! [VarCurr] :
      ( v25810(VarCurr,bitIndex1)
    <=> v25812(VarCurr,bitIndex1) ) ).

fof(addAssignment_11480,axiom,
    ! [VarCurr] :
      ( v25812(VarCurr,bitIndex1)
    <=> v25814(VarCurr,bitIndex1) ) ).

fof(addAssignment_11479,axiom,
    ! [VarCurr] :
      ( v25814(VarCurr,bitIndex1)
    <=> v12024(VarCurr,bitIndex1) ) ).

fof(addAssignment_11478,axiom,
    ! [VarCurr] :
      ( v25794(VarCurr,bitIndex1)
    <=> v25796(VarCurr,bitIndex1) ) ).

fof(addAssignment_11477,axiom,
    ! [VarCurr] :
      ( v25796(VarCurr,bitIndex1)
    <=> v25798(VarCurr,bitIndex1) ) ).

fof(addAssignment_11476,axiom,
    ! [VarCurr] :
      ( v25798(VarCurr,bitIndex1)
    <=> v25453(VarCurr,bitIndex1) ) ).

fof(addAssignment_11475,axiom,
    ! [VarCurr] :
      ( v25786(VarCurr,bitIndex1)
    <=> v25788(VarCurr,bitIndex1) ) ).

fof(addAssignment_11474,axiom,
    ! [VarCurr] :
      ( v25788(VarCurr,bitIndex1)
    <=> v25790(VarCurr,bitIndex1) ) ).

fof(addAssignment_11473,axiom,
    ! [VarCurr] :
      ( v26133(VarCurr)
    <=> v103(VarCurr,bitIndex0) ) ).

fof(addAssignment_11472,axiom,
    ! [VarCurr] :
      ( v26131(VarCurr)
    <=> v85(VarCurr,bitIndex0) ) ).

fof(addAssignment_11471,axiom,
    ! [VarCurr] :
      ( v26082(VarCurr)
    <=> v26084(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_730,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26108(VarNext)
       => ( v26084(VarNext)
        <=> v26084(VarCurr) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_484,axiom,
    ! [VarNext] :
      ( v26108(VarNext)
     => ( v26084(VarNext)
      <=> v26120(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_601,axiom,
    ! [VarCurr] :
      ( ~ v26109(VarCurr)
     => ( v26120(VarCurr)
      <=> v26121(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_607,axiom,
    ! [VarCurr] :
      ( v26109(VarCurr)
     => ( v26120(VarCurr)
      <=> v26090(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_600,axiom,
    ! [VarCurr] :
      ( ~ v26114(VarCurr)
     => ( v26121(VarCurr)
      <=> v26092(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_606,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26114(VarCurr)
       => ( v26121(VarCurr)
        <=> x166(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4538,axiom,
    ! [VarCurr] :
      ( v26108(VarCurr)
    <=> ( v26109(VarCurr)
        | v26112(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4537,axiom,
    ! [VarCurr] :
      ( v26112(VarCurr)
    <=> ( v26113(VarCurr)
        & v26119(VarCurr) ) ) ).

fof(writeUnaryOperator_2381,axiom,
    ! [VarCurr] :
      ( ~ v26119(VarCurr)
    <=> v26109(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4536,axiom,
    ! [VarCurr] :
      ( v26113(VarCurr)
    <=> ( v26114(VarCurr)
        | v26116(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4535,axiom,
    ! [VarCurr] :
      ( v26116(VarCurr)
    <=> ( v26117(VarCurr)
        & v26118(VarCurr) ) ) ).

fof(writeUnaryOperator_2380,axiom,
    ! [VarCurr] :
      ( ~ v26118(VarCurr)
    <=> v26114(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4534,axiom,
    ! [VarCurr] :
      ( v26117(VarCurr)
    <=> ( v26086(VarCurr)
        & v26088(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4533,axiom,
    ! [VarCurr] :
      ( v26114(VarCurr)
    <=> ( v26086(VarCurr)
        & v26115(VarCurr) ) ) ).

fof(writeUnaryOperator_2379,axiom,
    ! [VarCurr] :
      ( ~ v26115(VarCurr)
    <=> v26088(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4532,axiom,
    ! [VarCurr] :
      ( v26109(VarCurr)
    <=> ( v26110(VarCurr)
        & v26111(VarCurr) ) ) ).

fof(writeUnaryOperator_2378,axiom,
    ! [VarCurr] :
      ( ~ v26111(VarCurr)
    <=> v26088(VarCurr) ) ).

fof(writeUnaryOperator_2377,axiom,
    ! [VarCurr] :
      ( ~ v26110(VarCurr)
    <=> v26086(VarCurr) ) ).

fof(addAssignmentInitValueVector_964,axiom,
    ( v26084(constB0)
  <=> $false ) ).

fof(addAssignment_11470,axiom,
    ! [VarCurr] :
      ( v26092(VarCurr)
    <=> v25867(VarCurr,bitIndex3) ) ).

fof(addAssignment_11469,axiom,
    ! [VarCurr] :
      ( v25867(VarCurr,bitIndex3)
    <=> v26094(VarCurr) ) ).

fof(addAssignment_11468,axiom,
    ! [VarCurr] :
      ( v26094(VarCurr)
    <=> v26096(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_729,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26101(VarNext)
       => ( v26096(VarNext)
        <=> v26096(VarCurr) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_483,axiom,
    ! [VarNext] :
      ( v26101(VarNext)
     => ( v26096(VarNext)
      <=> v26039(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4531,axiom,
    ! [VarCurr] :
      ( v26101(VarCurr)
    <=> ( v26043(VarCurr)
        & v26102(VarCurr) ) ) ).

fof(writeUnaryOperator_2376,axiom,
    ! [VarCurr] :
      ( ~ v26102(VarCurr)
    <=> v26098(VarCurr) ) ).

fof(addAssignmentInitValueVector_963,axiom,
    ( v26096(constB0)
  <=> $false ) ).

fof(addAssignment_11467,axiom,
    ! [VarCurr] :
      ( v26098(VarCurr)
    <=> v184(VarCurr,bitIndex0) ) ).

fof(addAssignment_11466,axiom,
    ! [VarCurr] :
      ( v26090(VarCurr)
    <=> v25782(VarCurr,bitIndex2) ) ).

fof(addAssignment_11465,axiom,
    ! [VarCurr] :
      ( v25782(VarCurr,bitIndex2)
    <=> v25784(VarCurr,bitIndex2) ) ).

fof(addAssignment_11464,axiom,
    ! [VarCurr] :
      ( v25784(VarCurr,bitIndex2)
    <=> v25816(VarCurr,bitIndex2) ) ).

fof(addAssignment_11463,axiom,
    ! [VarCurr] :
      ( v25792(VarCurr,bitIndex2)
    <=> v25815(VarCurr,bitIndex2) ) ).

fof(addAssignment_11462,axiom,
    ! [VarCurr] :
      ( v25808(VarCurr,bitIndex2)
    <=> v25810(VarCurr,bitIndex2) ) ).

fof(addAssignment_11461,axiom,
    ! [VarCurr] :
      ( v25810(VarCurr,bitIndex2)
    <=> v25812(VarCurr,bitIndex2) ) ).

fof(addAssignment_11460,axiom,
    ! [VarCurr] :
      ( v25812(VarCurr,bitIndex2)
    <=> v25814(VarCurr,bitIndex2) ) ).

fof(addAssignment_11459,axiom,
    ! [VarCurr] :
      ( v25814(VarCurr,bitIndex2)
    <=> v12024(VarCurr,bitIndex2) ) ).

fof(addAssignment_11458,axiom,
    ! [VarCurr] :
      ( v25794(VarCurr,bitIndex2)
    <=> v25796(VarCurr,bitIndex2) ) ).

fof(addAssignment_11457,axiom,
    ! [VarCurr] :
      ( v25796(VarCurr,bitIndex2)
    <=> v25798(VarCurr,bitIndex2) ) ).

fof(addAssignment_11456,axiom,
    ! [VarCurr] :
      ( v25798(VarCurr,bitIndex2)
    <=> v25453(VarCurr,bitIndex2) ) ).

fof(addAssignment_11455,axiom,
    ! [VarCurr] :
      ( v25786(VarCurr,bitIndex2)
    <=> v25788(VarCurr,bitIndex2) ) ).

fof(addAssignment_11454,axiom,
    ! [VarCurr] :
      ( v25788(VarCurr,bitIndex2)
    <=> v25790(VarCurr,bitIndex2) ) ).

fof(addAssignment_11453,axiom,
    ! [VarCurr] :
      ( v26088(VarCurr)
    <=> v103(VarCurr,bitIndex0) ) ).

fof(addAssignment_11452,axiom,
    ! [VarCurr] :
      ( v26086(VarCurr)
    <=> v85(VarCurr,bitIndex0) ) ).

fof(addAssignment_11451,axiom,
    ! [VarCurr] :
      ( v26037(VarCurr)
    <=> v26039(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_728,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26063(VarNext)
       => ( v26039(VarNext)
        <=> v26039(VarCurr) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_482,axiom,
    ! [VarNext] :
      ( v26063(VarNext)
     => ( v26039(VarNext)
      <=> v26075(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_599,axiom,
    ! [VarCurr] :
      ( ~ v26064(VarCurr)
     => ( v26075(VarCurr)
      <=> v26076(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_605,axiom,
    ! [VarCurr] :
      ( v26064(VarCurr)
     => ( v26075(VarCurr)
      <=> v26045(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_598,axiom,
    ! [VarCurr] :
      ( ~ v26069(VarCurr)
     => ( v26076(VarCurr)
      <=> v26047(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_604,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26069(VarCurr)
       => ( v26076(VarCurr)
        <=> x166(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4530,axiom,
    ! [VarCurr] :
      ( v26063(VarCurr)
    <=> ( v26064(VarCurr)
        | v26067(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4529,axiom,
    ! [VarCurr] :
      ( v26067(VarCurr)
    <=> ( v26068(VarCurr)
        & v26074(VarCurr) ) ) ).

fof(writeUnaryOperator_2375,axiom,
    ! [VarCurr] :
      ( ~ v26074(VarCurr)
    <=> v26064(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4528,axiom,
    ! [VarCurr] :
      ( v26068(VarCurr)
    <=> ( v26069(VarCurr)
        | v26071(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4527,axiom,
    ! [VarCurr] :
      ( v26071(VarCurr)
    <=> ( v26072(VarCurr)
        & v26073(VarCurr) ) ) ).

fof(writeUnaryOperator_2374,axiom,
    ! [VarCurr] :
      ( ~ v26073(VarCurr)
    <=> v26069(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4526,axiom,
    ! [VarCurr] :
      ( v26072(VarCurr)
    <=> ( v26041(VarCurr)
        & v26043(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4525,axiom,
    ! [VarCurr] :
      ( v26069(VarCurr)
    <=> ( v26041(VarCurr)
        & v26070(VarCurr) ) ) ).

fof(writeUnaryOperator_2373,axiom,
    ! [VarCurr] :
      ( ~ v26070(VarCurr)
    <=> v26043(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4524,axiom,
    ! [VarCurr] :
      ( v26064(VarCurr)
    <=> ( v26065(VarCurr)
        & v26066(VarCurr) ) ) ).

fof(writeUnaryOperator_2372,axiom,
    ! [VarCurr] :
      ( ~ v26066(VarCurr)
    <=> v26043(VarCurr) ) ).

fof(writeUnaryOperator_2371,axiom,
    ! [VarCurr] :
      ( ~ v26065(VarCurr)
    <=> v26041(VarCurr) ) ).

fof(addAssignmentInitValueVector_962,axiom,
    ( v26039(constB0)
  <=> $false ) ).

fof(addAssignment_11450,axiom,
    ! [VarCurr] :
      ( v26047(VarCurr)
    <=> v25867(VarCurr,bitIndex4) ) ).

fof(addAssignment_11449,axiom,
    ! [VarCurr] :
      ( v25867(VarCurr,bitIndex4)
    <=> v26049(VarCurr) ) ).

fof(addAssignment_11448,axiom,
    ! [VarCurr] :
      ( v26049(VarCurr)
    <=> v26051(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_727,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26056(VarNext)
       => ( v26051(VarNext)
        <=> v26051(VarCurr) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_481,axiom,
    ! [VarNext] :
      ( v26056(VarNext)
     => ( v26051(VarNext)
      <=> v25994(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4523,axiom,
    ! [VarCurr] :
      ( v26056(VarCurr)
    <=> ( v25998(VarCurr)
        & v26057(VarCurr) ) ) ).

fof(writeUnaryOperator_2370,axiom,
    ! [VarCurr] :
      ( ~ v26057(VarCurr)
    <=> v26053(VarCurr) ) ).

fof(addAssignmentInitValueVector_961,axiom,
    ( v26051(constB0)
  <=> $false ) ).

fof(addAssignment_11447,axiom,
    ! [VarCurr] :
      ( v26053(VarCurr)
    <=> v184(VarCurr,bitIndex0) ) ).

fof(addAssignment_11446,axiom,
    ! [VarCurr] :
      ( v26045(VarCurr)
    <=> v25782(VarCurr,bitIndex3) ) ).

fof(addAssignment_11445,axiom,
    ! [VarCurr] :
      ( v25782(VarCurr,bitIndex3)
    <=> v25784(VarCurr,bitIndex3) ) ).

fof(addAssignment_11444,axiom,
    ! [VarCurr] :
      ( v25784(VarCurr,bitIndex3)
    <=> v25816(VarCurr,bitIndex3) ) ).

fof(addAssignment_11443,axiom,
    ! [VarCurr] :
      ( v25792(VarCurr,bitIndex3)
    <=> v25815(VarCurr,bitIndex3) ) ).

fof(addAssignment_11442,axiom,
    ! [VarCurr] :
      ( v25808(VarCurr,bitIndex3)
    <=> v25810(VarCurr,bitIndex3) ) ).

fof(addAssignment_11441,axiom,
    ! [VarCurr] :
      ( v25810(VarCurr,bitIndex3)
    <=> v25812(VarCurr,bitIndex3) ) ).

fof(addAssignment_11440,axiom,
    ! [VarCurr] :
      ( v25812(VarCurr,bitIndex3)
    <=> v25814(VarCurr,bitIndex3) ) ).

fof(addAssignment_11439,axiom,
    ! [VarCurr] :
      ( v25814(VarCurr,bitIndex3)
    <=> v12024(VarCurr,bitIndex3) ) ).

fof(addAssignment_11438,axiom,
    ! [VarCurr] :
      ( v25794(VarCurr,bitIndex3)
    <=> v25796(VarCurr,bitIndex3) ) ).

fof(addAssignment_11437,axiom,
    ! [VarCurr] :
      ( v25796(VarCurr,bitIndex3)
    <=> v25798(VarCurr,bitIndex3) ) ).

fof(addAssignment_11436,axiom,
    ! [VarCurr] :
      ( v25798(VarCurr,bitIndex3)
    <=> v25453(VarCurr,bitIndex3) ) ).

fof(addAssignment_11435,axiom,
    ! [VarCurr] :
      ( v25453(VarCurr,bitIndex3)
    <=> v25483(VarCurr,bitIndex3) ) ).

fof(addAssignment_11434,axiom,
    ! [VarCurr] :
      ( v25484(VarCurr,bitIndex0)
    <=> v25801(VarCurr,bitIndex0) ) ).

fof(addAssignment_11433,axiom,
    ! [VarCurr] :
      ( v25801(VarCurr,bitIndex0)
    <=> v25803(VarCurr,bitIndex0) ) ).

fof(addAssignment_11432,axiom,
    ! [VarCurr] :
      ( v25803(VarCurr,bitIndex0)
    <=> v25806(VarCurr,bitIndex0) ) ).

fof(addAssignment_11431,axiom,
    ! [VarCurr] :
      ( v25786(VarCurr,bitIndex3)
    <=> v25788(VarCurr,bitIndex3) ) ).

fof(addAssignment_11430,axiom,
    ! [VarCurr] :
      ( v25788(VarCurr,bitIndex3)
    <=> v25790(VarCurr,bitIndex3) ) ).

fof(addAssignment_11429,axiom,
    ! [VarCurr] :
      ( v26043(VarCurr)
    <=> v103(VarCurr,bitIndex0) ) ).

fof(addAssignment_11428,axiom,
    ! [VarCurr] :
      ( v26041(VarCurr)
    <=> v85(VarCurr,bitIndex0) ) ).

fof(addAssignment_11427,axiom,
    ! [VarCurr] :
      ( v25992(VarCurr)
    <=> v25994(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_726,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26018(VarNext)
       => ( v25994(VarNext)
        <=> v25994(VarCurr) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_480,axiom,
    ! [VarNext] :
      ( v26018(VarNext)
     => ( v25994(VarNext)
      <=> v26030(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_597,axiom,
    ! [VarCurr] :
      ( ~ v26019(VarCurr)
     => ( v26030(VarCurr)
      <=> v26031(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_603,axiom,
    ! [VarCurr] :
      ( v26019(VarCurr)
     => ( v26030(VarCurr)
      <=> v26000(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_596,axiom,
    ! [VarCurr] :
      ( ~ v26024(VarCurr)
     => ( v26031(VarCurr)
      <=> v26002(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_602,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v26024(VarCurr)
       => ( v26031(VarCurr)
        <=> x166(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4522,axiom,
    ! [VarCurr] :
      ( v26018(VarCurr)
    <=> ( v26019(VarCurr)
        | v26022(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4521,axiom,
    ! [VarCurr] :
      ( v26022(VarCurr)
    <=> ( v26023(VarCurr)
        & v26029(VarCurr) ) ) ).

fof(writeUnaryOperator_2369,axiom,
    ! [VarCurr] :
      ( ~ v26029(VarCurr)
    <=> v26019(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4520,axiom,
    ! [VarCurr] :
      ( v26023(VarCurr)
    <=> ( v26024(VarCurr)
        | v26026(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4519,axiom,
    ! [VarCurr] :
      ( v26026(VarCurr)
    <=> ( v26027(VarCurr)
        & v26028(VarCurr) ) ) ).

fof(writeUnaryOperator_2368,axiom,
    ! [VarCurr] :
      ( ~ v26028(VarCurr)
    <=> v26024(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4518,axiom,
    ! [VarCurr] :
      ( v26027(VarCurr)
    <=> ( v25996(VarCurr)
        & v25998(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4517,axiom,
    ! [VarCurr] :
      ( v26024(VarCurr)
    <=> ( v25996(VarCurr)
        & v26025(VarCurr) ) ) ).

fof(writeUnaryOperator_2367,axiom,
    ! [VarCurr] :
      ( ~ v26025(VarCurr)
    <=> v25998(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4516,axiom,
    ! [VarCurr] :
      ( v26019(VarCurr)
    <=> ( v26020(VarCurr)
        & v26021(VarCurr) ) ) ).

fof(writeUnaryOperator_2366,axiom,
    ! [VarCurr] :
      ( ~ v26021(VarCurr)
    <=> v25998(VarCurr) ) ).

fof(writeUnaryOperator_2365,axiom,
    ! [VarCurr] :
      ( ~ v26020(VarCurr)
    <=> v25996(VarCurr) ) ).

fof(addAssignmentInitValueVector_960,axiom,
    ( v25994(constB0)
  <=> $false ) ).

fof(addAssignment_11426,axiom,
    ! [VarCurr] :
      ( v26002(VarCurr)
    <=> v25867(VarCurr,bitIndex5) ) ).

fof(addAssignment_11425,axiom,
    ! [VarCurr] :
      ( v25867(VarCurr,bitIndex5)
    <=> v26004(VarCurr) ) ).

fof(addAssignment_11424,axiom,
    ! [VarCurr] :
      ( v26004(VarCurr)
    <=> v26006(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_725,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v26011(VarNext)
       => ( v26006(VarNext)
        <=> v26006(VarCurr) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_479,axiom,
    ! [VarNext] :
      ( v26011(VarNext)
     => ( v26006(VarNext)
      <=> v25949(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4515,axiom,
    ! [VarCurr] :
      ( v26011(VarCurr)
    <=> ( v25953(VarCurr)
        & v26012(VarCurr) ) ) ).

fof(writeUnaryOperator_2364,axiom,
    ! [VarCurr] :
      ( ~ v26012(VarCurr)
    <=> v26008(VarCurr) ) ).

fof(addAssignmentInitValueVector_959,axiom,
    ( v26006(constB0)
  <=> $false ) ).

fof(addAssignment_11423,axiom,
    ! [VarCurr] :
      ( v26008(VarCurr)
    <=> v184(VarCurr,bitIndex0) ) ).

fof(addAssignment_11422,axiom,
    ! [VarCurr] :
      ( v26000(VarCurr)
    <=> v25782(VarCurr,bitIndex4) ) ).

fof(addAssignment_11421,axiom,
    ! [VarCurr] :
      ( v25782(VarCurr,bitIndex4)
    <=> v25784(VarCurr,bitIndex4) ) ).

fof(addAssignment_11420,axiom,
    ! [VarCurr] :
      ( v25784(VarCurr,bitIndex4)
    <=> v25816(VarCurr,bitIndex4) ) ).

fof(addAssignment_11419,axiom,
    ! [VarCurr] :
      ( v25792(VarCurr,bitIndex4)
    <=> v25815(VarCurr,bitIndex4) ) ).

fof(addAssignment_11418,axiom,
    ! [VarCurr] :
      ( v25808(VarCurr,bitIndex4)
    <=> v25810(VarCurr,bitIndex4) ) ).

fof(addAssignment_11417,axiom,
    ! [VarCurr] :
      ( v25810(VarCurr,bitIndex4)
    <=> v25812(VarCurr,bitIndex4) ) ).

fof(addAssignment_11416,axiom,
    ! [VarCurr] :
      ( v25812(VarCurr,bitIndex4)
    <=> v25814(VarCurr,bitIndex4) ) ).

fof(addAssignment_11415,axiom,
    ! [VarCurr] :
      ( v25814(VarCurr,bitIndex4)
    <=> v12024(VarCurr,bitIndex4) ) ).

fof(addAssignment_11414,axiom,
    ! [VarCurr] :
      ( v25794(VarCurr,bitIndex4)
    <=> v25796(VarCurr,bitIndex4) ) ).

fof(addAssignment_11413,axiom,
    ! [VarCurr] :
      ( v25796(VarCurr,bitIndex4)
    <=> v25798(VarCurr,bitIndex4) ) ).

fof(addAssignment_11412,axiom,
    ! [VarCurr] :
      ( v25798(VarCurr,bitIndex4)
    <=> v25453(VarCurr,bitIndex4) ) ).

fof(addAssignment_11411,axiom,
    ! [VarCurr] :
      ( v25453(VarCurr,bitIndex4)
    <=> v25483(VarCurr,bitIndex4) ) ).

fof(addAssignment_11410,axiom,
    ! [VarCurr] :
      ( v25484(VarCurr,bitIndex1)
    <=> v25801(VarCurr,bitIndex1) ) ).

fof(addAssignment_11409,axiom,
    ! [VarCurr] :
      ( v25801(VarCurr,bitIndex1)
    <=> v25803(VarCurr,bitIndex1) ) ).

fof(addAssignment_11408,axiom,
    ! [VarCurr] :
      ( v25803(VarCurr,bitIndex1)
    <=> v25806(VarCurr,bitIndex1) ) ).

fof(addAssignment_11407,axiom,
    ! [VarCurr] :
      ( v25786(VarCurr,bitIndex4)
    <=> v25788(VarCurr,bitIndex4) ) ).

fof(addAssignment_11406,axiom,
    ! [VarCurr] :
      ( v25788(VarCurr,bitIndex4)
    <=> v25790(VarCurr,bitIndex4) ) ).

fof(addAssignment_11405,axiom,
    ! [VarCurr] :
      ( v25998(VarCurr)
    <=> v103(VarCurr,bitIndex0) ) ).

fof(addAssignment_11404,axiom,
    ! [VarCurr] :
      ( v25996(VarCurr)
    <=> v85(VarCurr,bitIndex0) ) ).

fof(addAssignment_11403,axiom,
    ! [VarCurr] :
      ( v25947(VarCurr)
    <=> v25949(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_724,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25973(VarNext)
       => ( v25949(VarNext)
        <=> v25949(VarCurr) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_478,axiom,
    ! [VarNext] :
      ( v25973(VarNext)
     => ( v25949(VarNext)
      <=> v25985(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_595,axiom,
    ! [VarCurr] :
      ( ~ v25974(VarCurr)
     => ( v25985(VarCurr)
      <=> v25986(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_601,axiom,
    ! [VarCurr] :
      ( v25974(VarCurr)
     => ( v25985(VarCurr)
      <=> v25955(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_594,axiom,
    ! [VarCurr] :
      ( ~ v25979(VarCurr)
     => ( v25986(VarCurr)
      <=> v25957(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_600,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25979(VarCurr)
       => ( v25986(VarCurr)
        <=> x166(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4514,axiom,
    ! [VarCurr] :
      ( v25973(VarCurr)
    <=> ( v25974(VarCurr)
        | v25977(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4513,axiom,
    ! [VarCurr] :
      ( v25977(VarCurr)
    <=> ( v25978(VarCurr)
        & v25984(VarCurr) ) ) ).

fof(writeUnaryOperator_2363,axiom,
    ! [VarCurr] :
      ( ~ v25984(VarCurr)
    <=> v25974(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4512,axiom,
    ! [VarCurr] :
      ( v25978(VarCurr)
    <=> ( v25979(VarCurr)
        | v25981(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4511,axiom,
    ! [VarCurr] :
      ( v25981(VarCurr)
    <=> ( v25982(VarCurr)
        & v25983(VarCurr) ) ) ).

fof(writeUnaryOperator_2362,axiom,
    ! [VarCurr] :
      ( ~ v25983(VarCurr)
    <=> v25979(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4510,axiom,
    ! [VarCurr] :
      ( v25982(VarCurr)
    <=> ( v25951(VarCurr)
        & v25953(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4509,axiom,
    ! [VarCurr] :
      ( v25979(VarCurr)
    <=> ( v25951(VarCurr)
        & v25980(VarCurr) ) ) ).

fof(writeUnaryOperator_2361,axiom,
    ! [VarCurr] :
      ( ~ v25980(VarCurr)
    <=> v25953(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4508,axiom,
    ! [VarCurr] :
      ( v25974(VarCurr)
    <=> ( v25975(VarCurr)
        & v25976(VarCurr) ) ) ).

fof(writeUnaryOperator_2360,axiom,
    ! [VarCurr] :
      ( ~ v25976(VarCurr)
    <=> v25953(VarCurr) ) ).

fof(writeUnaryOperator_2359,axiom,
    ! [VarCurr] :
      ( ~ v25975(VarCurr)
    <=> v25951(VarCurr) ) ).

fof(addAssignmentInitValueVector_958,axiom,
    ( v25949(constB0)
  <=> $false ) ).

fof(addAssignment_11402,axiom,
    ! [VarCurr] :
      ( v25957(VarCurr)
    <=> v25867(VarCurr,bitIndex6) ) ).

fof(addAssignment_11401,axiom,
    ! [VarCurr] :
      ( v25867(VarCurr,bitIndex6)
    <=> v25959(VarCurr) ) ).

fof(addAssignment_11400,axiom,
    ! [VarCurr] :
      ( v25959(VarCurr)
    <=> v25961(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_723,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25966(VarNext)
       => ( v25961(VarNext)
        <=> v25961(VarCurr) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_477,axiom,
    ! [VarNext] :
      ( v25966(VarNext)
     => ( v25961(VarNext)
      <=> v25904(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4507,axiom,
    ! [VarCurr] :
      ( v25966(VarCurr)
    <=> ( v25908(VarCurr)
        & v25967(VarCurr) ) ) ).

fof(writeUnaryOperator_2358,axiom,
    ! [VarCurr] :
      ( ~ v25967(VarCurr)
    <=> v25963(VarCurr) ) ).

fof(addAssignmentInitValueVector_957,axiom,
    ( v25961(constB0)
  <=> $false ) ).

fof(addAssignment_11399,axiom,
    ! [VarCurr] :
      ( v25963(VarCurr)
    <=> v184(VarCurr,bitIndex0) ) ).

fof(addAssignment_11398,axiom,
    ! [VarCurr] :
      ( v25955(VarCurr)
    <=> v25782(VarCurr,bitIndex5) ) ).

fof(addAssignment_11397,axiom,
    ! [VarCurr] :
      ( v25782(VarCurr,bitIndex5)
    <=> v25784(VarCurr,bitIndex5) ) ).

fof(addAssignment_11396,axiom,
    ! [VarCurr] :
      ( v25784(VarCurr,bitIndex5)
    <=> v25816(VarCurr,bitIndex5) ) ).

fof(addAssignment_11395,axiom,
    ! [VarCurr] :
      ( v25792(VarCurr,bitIndex5)
    <=> v25815(VarCurr,bitIndex5) ) ).

fof(addAssignment_11394,axiom,
    ! [VarCurr] :
      ( v25808(VarCurr,bitIndex5)
    <=> v25810(VarCurr,bitIndex5) ) ).

fof(addAssignment_11393,axiom,
    ! [VarCurr] :
      ( v25810(VarCurr,bitIndex5)
    <=> v25812(VarCurr,bitIndex5) ) ).

fof(addAssignment_11392,axiom,
    ! [VarCurr] :
      ( v25812(VarCurr,bitIndex5)
    <=> v25814(VarCurr,bitIndex5) ) ).

fof(addAssignment_11391,axiom,
    ! [VarCurr] :
      ( v25814(VarCurr,bitIndex5)
    <=> v12024(VarCurr,bitIndex5) ) ).

fof(addAssignment_11390,axiom,
    ! [VarCurr] :
      ( v25794(VarCurr,bitIndex5)
    <=> v25796(VarCurr,bitIndex5) ) ).

fof(addAssignment_11389,axiom,
    ! [VarCurr] :
      ( v25796(VarCurr,bitIndex5)
    <=> v25798(VarCurr,bitIndex5) ) ).

fof(addAssignment_11388,axiom,
    ! [VarCurr] :
      ( v25798(VarCurr,bitIndex5)
    <=> v25453(VarCurr,bitIndex5) ) ).

fof(addAssignment_11387,axiom,
    ! [VarCurr] :
      ( v25453(VarCurr,bitIndex5)
    <=> v25483(VarCurr,bitIndex5) ) ).

fof(addAssignment_11386,axiom,
    ! [VarCurr] :
      ( v25484(VarCurr,bitIndex2)
    <=> v25801(VarCurr,bitIndex2) ) ).

fof(addAssignment_11385,axiom,
    ! [VarCurr] :
      ( v25801(VarCurr,bitIndex2)
    <=> v25803(VarCurr,bitIndex2) ) ).

fof(addAssignment_11384,axiom,
    ! [VarCurr] :
      ( v25803(VarCurr,bitIndex2)
    <=> v25806(VarCurr,bitIndex2) ) ).

fof(addAssignment_11383,axiom,
    ! [VarCurr] :
      ( v25786(VarCurr,bitIndex5)
    <=> v25788(VarCurr,bitIndex5) ) ).

fof(addAssignment_11382,axiom,
    ! [VarCurr] :
      ( v25788(VarCurr,bitIndex5)
    <=> v25790(VarCurr,bitIndex5) ) ).

fof(addAssignment_11381,axiom,
    ! [VarCurr] :
      ( v25953(VarCurr)
    <=> v103(VarCurr,bitIndex0) ) ).

fof(addAssignment_11380,axiom,
    ! [VarCurr] :
      ( v25951(VarCurr)
    <=> v85(VarCurr,bitIndex0) ) ).

fof(addAssignment_11379,axiom,
    ! [VarCurr] :
      ( v25902(VarCurr)
    <=> v25904(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_722,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25928(VarNext)
       => ( v25904(VarNext)
        <=> v25904(VarCurr) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_476,axiom,
    ! [VarNext] :
      ( v25928(VarNext)
     => ( v25904(VarNext)
      <=> v25940(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_593,axiom,
    ! [VarCurr] :
      ( ~ v25929(VarCurr)
     => ( v25940(VarCurr)
      <=> v25941(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_599,axiom,
    ! [VarCurr] :
      ( v25929(VarCurr)
     => ( v25940(VarCurr)
      <=> v25910(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_592,axiom,
    ! [VarCurr] :
      ( ~ v25934(VarCurr)
     => ( v25941(VarCurr)
      <=> v25912(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_598,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25934(VarCurr)
       => ( v25941(VarCurr)
        <=> x166(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4506,axiom,
    ! [VarCurr] :
      ( v25928(VarCurr)
    <=> ( v25929(VarCurr)
        | v25932(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4505,axiom,
    ! [VarCurr] :
      ( v25932(VarCurr)
    <=> ( v25933(VarCurr)
        & v25939(VarCurr) ) ) ).

fof(writeUnaryOperator_2357,axiom,
    ! [VarCurr] :
      ( ~ v25939(VarCurr)
    <=> v25929(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4504,axiom,
    ! [VarCurr] :
      ( v25933(VarCurr)
    <=> ( v25934(VarCurr)
        | v25936(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4503,axiom,
    ! [VarCurr] :
      ( v25936(VarCurr)
    <=> ( v25937(VarCurr)
        & v25938(VarCurr) ) ) ).

fof(writeUnaryOperator_2356,axiom,
    ! [VarCurr] :
      ( ~ v25938(VarCurr)
    <=> v25934(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4502,axiom,
    ! [VarCurr] :
      ( v25937(VarCurr)
    <=> ( v25906(VarCurr)
        & v25908(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4501,axiom,
    ! [VarCurr] :
      ( v25934(VarCurr)
    <=> ( v25906(VarCurr)
        & v25935(VarCurr) ) ) ).

fof(writeUnaryOperator_2355,axiom,
    ! [VarCurr] :
      ( ~ v25935(VarCurr)
    <=> v25908(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4500,axiom,
    ! [VarCurr] :
      ( v25929(VarCurr)
    <=> ( v25930(VarCurr)
        & v25931(VarCurr) ) ) ).

fof(writeUnaryOperator_2354,axiom,
    ! [VarCurr] :
      ( ~ v25931(VarCurr)
    <=> v25908(VarCurr) ) ).

fof(writeUnaryOperator_2353,axiom,
    ! [VarCurr] :
      ( ~ v25930(VarCurr)
    <=> v25906(VarCurr) ) ).

fof(addAssignmentInitValueVector_956,axiom,
    ( v25904(constB0)
  <=> $false ) ).

fof(addAssignment_11378,axiom,
    ! [VarCurr] :
      ( v25912(VarCurr)
    <=> v25867(VarCurr,bitIndex7) ) ).

fof(addAssignment_11377,axiom,
    ! [VarCurr] :
      ( v25867(VarCurr,bitIndex7)
    <=> v25914(VarCurr) ) ).

fof(addAssignment_11376,axiom,
    ! [VarCurr] :
      ( v25914(VarCurr)
    <=> v25916(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_721,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25921(VarNext)
       => ( v25916(VarNext)
        <=> v25916(VarCurr) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_475,axiom,
    ! [VarNext] :
      ( v25921(VarNext)
     => ( v25916(VarNext)
      <=> v25857(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4499,axiom,
    ! [VarCurr] :
      ( v25921(VarCurr)
    <=> ( v25861(VarCurr)
        & v25922(VarCurr) ) ) ).

fof(writeUnaryOperator_2352,axiom,
    ! [VarCurr] :
      ( ~ v25922(VarCurr)
    <=> v25918(VarCurr) ) ).

fof(addAssignmentInitValueVector_955,axiom,
    ( v25916(constB0)
  <=> $false ) ).

fof(addAssignment_11375,axiom,
    ! [VarCurr] :
      ( v25918(VarCurr)
    <=> v184(VarCurr,bitIndex0) ) ).

fof(addAssignment_11374,axiom,
    ! [VarCurr] :
      ( v25910(VarCurr)
    <=> v25782(VarCurr,bitIndex6) ) ).

fof(addAssignment_11373,axiom,
    ! [VarCurr] :
      ( v25782(VarCurr,bitIndex6)
    <=> v25784(VarCurr,bitIndex6) ) ).

fof(addAssignment_11372,axiom,
    ! [VarCurr] :
      ( v25784(VarCurr,bitIndex6)
    <=> v25816(VarCurr,bitIndex6) ) ).

fof(addAssignment_11371,axiom,
    ! [VarCurr] :
      ( v25792(VarCurr,bitIndex6)
    <=> v25815(VarCurr,bitIndex6) ) ).

fof(addAssignment_11370,axiom,
    ! [VarCurr] :
      ( v25808(VarCurr,bitIndex6)
    <=> v25810(VarCurr,bitIndex6) ) ).

fof(addAssignment_11369,axiom,
    ! [VarCurr] :
      ( v25810(VarCurr,bitIndex6)
    <=> v25812(VarCurr,bitIndex6) ) ).

fof(addAssignment_11368,axiom,
    ! [VarCurr] :
      ( v25812(VarCurr,bitIndex6)
    <=> v25814(VarCurr,bitIndex6) ) ).

fof(addAssignment_11367,axiom,
    ! [VarCurr] :
      ( v25814(VarCurr,bitIndex6)
    <=> v12024(VarCurr,bitIndex6) ) ).

fof(addAssignment_11366,axiom,
    ! [VarCurr] :
      ( v12024(VarCurr,bitIndex6)
    <=> v12026(VarCurr,bitIndex6) ) ).

fof(addAssignment_11365,axiom,
    ! [VarCurr] :
      ( v12026(VarCurr,bitIndex6)
    <=> v12028(VarCurr,bitIndex6) ) ).

fof(addAssignment_11364,axiom,
    ! [VarCurr] :
      ( v12028(VarCurr,bitIndex6)
    <=> v12030(VarCurr,bitIndex6) ) ).

fof(addAssignment_11363,axiom,
    ! [VarCurr] :
      ( v12030(VarCurr,bitIndex6)
    <=> v12032(VarCurr,bitIndex6) ) ).

fof(addAssignment_11362,axiom,
    ! [VarCurr] :
      ( v12032(VarCurr,bitIndex6)
    <=> v12034(VarCurr,bitIndex6) ) ).

fof(addAssignment_11361,axiom,
    ! [VarCurr] :
      ( v12034(VarCurr,bitIndex6)
    <=> v12036(VarCurr,bitIndex6) ) ).

fof(addAssignment_11360,axiom,
    ! [VarCurr] :
      ( v12036(VarCurr,bitIndex6)
    <=> v12038(VarCurr,bitIndex6) ) ).

fof(addAssignment_11359,axiom,
    ! [VarCurr] :
      ( v12038(VarCurr,bitIndex6)
    <=> v12040(VarCurr,bitIndex6) ) ).

fof(addAssignment_11358,axiom,
    ! [VarCurr] :
      ( v12040(VarCurr,bitIndex6)
    <=> v12042(VarCurr,bitIndex6) ) ).

fof(addAssignment_11357,axiom,
    ! [VarCurr] :
      ( v12042(VarCurr,bitIndex6)
    <=> v12044(VarCurr,bitIndex6) ) ).

fof(addAssignment_11356,axiom,
    ! [VarCurr] :
      ( v12044(VarCurr,bitIndex6)
    <=> v1119(VarCurr,bitIndex6) ) ).

fof(addAssignment_11355,axiom,
    ! [VarCurr] :
      ( v25794(VarCurr,bitIndex6)
    <=> v25796(VarCurr,bitIndex6) ) ).

fof(addAssignment_11354,axiom,
    ! [VarCurr] :
      ( v25796(VarCurr,bitIndex6)
    <=> v25798(VarCurr,bitIndex6) ) ).

fof(addAssignment_11353,axiom,
    ! [VarCurr] :
      ( v25798(VarCurr,bitIndex6)
    <=> v25453(VarCurr,bitIndex6) ) ).

fof(addAssignment_11352,axiom,
    ! [VarCurr] :
      ( v25453(VarCurr,bitIndex6)
    <=> v25483(VarCurr,bitIndex6) ) ).

fof(addAssignment_11351,axiom,
    ! [VarCurr] :
      ( v25484(VarCurr,bitIndex3)
    <=> v25801(VarCurr,bitIndex3) ) ).

fof(addAssignment_11350,axiom,
    ! [VarCurr] :
      ( v25801(VarCurr,bitIndex3)
    <=> v25803(VarCurr,bitIndex3) ) ).

fof(addAssignment_11349,axiom,
    ! [VarCurr] :
      ( v25803(VarCurr,bitIndex3)
    <=> v25806(VarCurr,bitIndex3) ) ).

fof(addAssignment_11348,axiom,
    ! [VarCurr] :
      ( v25786(VarCurr,bitIndex6)
    <=> v25788(VarCurr,bitIndex6) ) ).

fof(addAssignment_11347,axiom,
    ! [VarCurr] :
      ( v25788(VarCurr,bitIndex6)
    <=> v25790(VarCurr,bitIndex6) ) ).

fof(addAssignment_11346,axiom,
    ! [VarCurr] :
      ( v25908(VarCurr)
    <=> v103(VarCurr,bitIndex0) ) ).

fof(addAssignment_11345,axiom,
    ! [VarCurr] :
      ( v25906(VarCurr)
    <=> v85(VarCurr,bitIndex0) ) ).

fof(addAssignment_11344,axiom,
    ! [VarCurr] :
      ( v25855(VarCurr)
    <=> v25857(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_720,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25883(VarNext)
       => ( v25857(VarNext)
        <=> v25857(VarCurr) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_474,axiom,
    ! [VarNext] :
      ( v25883(VarNext)
     => ( v25857(VarNext)
      <=> v25895(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_591,axiom,
    ! [VarCurr] :
      ( ~ v25884(VarCurr)
     => ( v25895(VarCurr)
      <=> v25896(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_597,axiom,
    ! [VarCurr] :
      ( v25884(VarCurr)
     => ( v25895(VarCurr)
      <=> v25863(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_590,axiom,
    ! [VarCurr] :
      ( ~ v25889(VarCurr)
     => ( v25896(VarCurr)
      <=> v25865(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_596,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25889(VarCurr)
       => ( v25896(VarCurr)
        <=> x166(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4498,axiom,
    ! [VarCurr] :
      ( v25883(VarCurr)
    <=> ( v25884(VarCurr)
        | v25887(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4497,axiom,
    ! [VarCurr] :
      ( v25887(VarCurr)
    <=> ( v25888(VarCurr)
        & v25894(VarCurr) ) ) ).

fof(writeUnaryOperator_2351,axiom,
    ! [VarCurr] :
      ( ~ v25894(VarCurr)
    <=> v25884(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4496,axiom,
    ! [VarCurr] :
      ( v25888(VarCurr)
    <=> ( v25889(VarCurr)
        | v25891(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4495,axiom,
    ! [VarCurr] :
      ( v25891(VarCurr)
    <=> ( v25892(VarCurr)
        & v25893(VarCurr) ) ) ).

fof(writeUnaryOperator_2350,axiom,
    ! [VarCurr] :
      ( ~ v25893(VarCurr)
    <=> v25889(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4494,axiom,
    ! [VarCurr] :
      ( v25892(VarCurr)
    <=> ( v25859(VarCurr)
        & v25861(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4493,axiom,
    ! [VarCurr] :
      ( v25889(VarCurr)
    <=> ( v25859(VarCurr)
        & v25890(VarCurr) ) ) ).

fof(writeUnaryOperator_2349,axiom,
    ! [VarCurr] :
      ( ~ v25890(VarCurr)
    <=> v25861(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4492,axiom,
    ! [VarCurr] :
      ( v25884(VarCurr)
    <=> ( v25885(VarCurr)
        & v25886(VarCurr) ) ) ).

fof(writeUnaryOperator_2348,axiom,
    ! [VarCurr] :
      ( ~ v25886(VarCurr)
    <=> v25861(VarCurr) ) ).

fof(writeUnaryOperator_2347,axiom,
    ! [VarCurr] :
      ( ~ v25885(VarCurr)
    <=> v25859(VarCurr) ) ).

fof(addAssignmentInitValueVector_954,axiom,
    ( v25857(constB0)
  <=> $false ) ).

fof(addAssignment_11343,axiom,
    ! [VarCurr] :
      ( v25865(VarCurr)
    <=> v25867(VarCurr,bitIndex8) ) ).

fof(addAssignment_11342,axiom,
    ! [VarCurr] :
      ( v25867(VarCurr,bitIndex8)
    <=> v25869(VarCurr) ) ).

fof(addAssignment_11341,axiom,
    ! [VarCurr] :
      ( v25869(VarCurr)
    <=> v25871(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_719,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25876(VarNext)
       => ( v25871(VarNext)
        <=> v25871(VarCurr) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_473,axiom,
    ! [VarNext] :
      ( v25876(VarNext)
     => ( v25871(VarNext)
      <=> v25774(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4491,axiom,
    ! [VarCurr] :
      ( v25876(VarCurr)
    <=> ( v25778(VarCurr)
        & v25877(VarCurr) ) ) ).

fof(writeUnaryOperator_2346,axiom,
    ! [VarCurr] :
      ( ~ v25877(VarCurr)
    <=> v25873(VarCurr) ) ).

fof(addAssignmentInitValueVector_953,axiom,
    ( v25871(constB0)
  <=> $false ) ).

fof(addAssignment_11340,axiom,
    ! [VarCurr] :
      ( v25873(VarCurr)
    <=> v184(VarCurr,bitIndex0) ) ).

fof(addAssignment_11339,axiom,
    ! [VarCurr] :
      ( v25863(VarCurr)
    <=> v25782(VarCurr,bitIndex7) ) ).

fof(addAssignment_11338,axiom,
    ! [VarCurr] :
      ( v25782(VarCurr,bitIndex7)
    <=> v25784(VarCurr,bitIndex7) ) ).

fof(addAssignment_11337,axiom,
    ! [VarCurr] :
      ( v25784(VarCurr,bitIndex7)
    <=> v25816(VarCurr,bitIndex7) ) ).

fof(addAssignment_11336,axiom,
    ! [VarCurr] :
      ( v25792(VarCurr,bitIndex7)
    <=> v25815(VarCurr,bitIndex7) ) ).

fof(addAssignment_11335,axiom,
    ! [VarCurr] :
      ( v25808(VarCurr,bitIndex7)
    <=> v25810(VarCurr,bitIndex7) ) ).

fof(addAssignment_11334,axiom,
    ! [VarCurr] :
      ( v25810(VarCurr,bitIndex7)
    <=> v25812(VarCurr,bitIndex7) ) ).

fof(addAssignment_11333,axiom,
    ! [VarCurr] :
      ( v25812(VarCurr,bitIndex7)
    <=> v25814(VarCurr,bitIndex7) ) ).

fof(addAssignment_11332,axiom,
    ! [VarCurr] :
      ( v25814(VarCurr,bitIndex7)
    <=> v12024(VarCurr,bitIndex7) ) ).

fof(addAssignment_11331,axiom,
    ! [VarCurr] :
      ( v12024(VarCurr,bitIndex7)
    <=> v12026(VarCurr,bitIndex7) ) ).

fof(addAssignment_11330,axiom,
    ! [VarCurr] :
      ( v12026(VarCurr,bitIndex7)
    <=> v12028(VarCurr,bitIndex7) ) ).

fof(addAssignment_11329,axiom,
    ! [VarCurr] :
      ( v12028(VarCurr,bitIndex7)
    <=> v12030(VarCurr,bitIndex7) ) ).

fof(addAssignment_11328,axiom,
    ! [VarCurr] :
      ( v12030(VarCurr,bitIndex7)
    <=> v12032(VarCurr,bitIndex7) ) ).

fof(addAssignment_11327,axiom,
    ! [VarCurr] :
      ( v12032(VarCurr,bitIndex7)
    <=> v12034(VarCurr,bitIndex7) ) ).

fof(addAssignment_11326,axiom,
    ! [VarCurr] :
      ( v12034(VarCurr,bitIndex7)
    <=> v12036(VarCurr,bitIndex7) ) ).

fof(addAssignment_11325,axiom,
    ! [VarCurr] :
      ( v12036(VarCurr,bitIndex7)
    <=> v12038(VarCurr,bitIndex7) ) ).

fof(addAssignment_11324,axiom,
    ! [VarCurr] :
      ( v12038(VarCurr,bitIndex7)
    <=> v12040(VarCurr,bitIndex7) ) ).

fof(addAssignment_11323,axiom,
    ! [VarCurr] :
      ( v12040(VarCurr,bitIndex7)
    <=> v12042(VarCurr,bitIndex7) ) ).

fof(addAssignment_11322,axiom,
    ! [VarCurr] :
      ( v12042(VarCurr,bitIndex7)
    <=> v12044(VarCurr,bitIndex7) ) ).

fof(addAssignment_11321,axiom,
    ! [VarCurr] :
      ( v12044(VarCurr,bitIndex7)
    <=> v1119(VarCurr,bitIndex7) ) ).

fof(addAssignment_11320,axiom,
    ! [VarCurr] :
      ( v25794(VarCurr,bitIndex7)
    <=> v25796(VarCurr,bitIndex7) ) ).

fof(addAssignment_11319,axiom,
    ! [VarCurr] :
      ( v25796(VarCurr,bitIndex7)
    <=> v25798(VarCurr,bitIndex7) ) ).

fof(addAssignment_11318,axiom,
    ! [VarCurr] :
      ( v25798(VarCurr,bitIndex7)
    <=> v25453(VarCurr,bitIndex7) ) ).

fof(addAssignment_11317,axiom,
    ! [VarCurr] :
      ( v25453(VarCurr,bitIndex7)
    <=> v25483(VarCurr,bitIndex7) ) ).

fof(addAssignment_11316,axiom,
    ! [VarCurr] :
      ( v25484(VarCurr,bitIndex4)
    <=> v25801(VarCurr,bitIndex4) ) ).

fof(addAssignment_11315,axiom,
    ! [VarCurr] :
      ( v25801(VarCurr,bitIndex4)
    <=> v25803(VarCurr,bitIndex4) ) ).

fof(addAssignment_11314,axiom,
    ! [VarCurr] :
      ( v25803(VarCurr,bitIndex4)
    <=> v25806(VarCurr,bitIndex4) ) ).

fof(addAssignment_11313,axiom,
    ! [VarCurr] :
      ( v25786(VarCurr,bitIndex7)
    <=> v25788(VarCurr,bitIndex7) ) ).

fof(addAssignment_11312,axiom,
    ! [VarCurr] :
      ( v25788(VarCurr,bitIndex7)
    <=> v25790(VarCurr,bitIndex7) ) ).

fof(addAssignment_11311,axiom,
    ! [VarCurr] :
      ( v25861(VarCurr)
    <=> v103(VarCurr,bitIndex0) ) ).

fof(addAssignment_11310,axiom,
    ! [VarCurr] :
      ( v25859(VarCurr)
    <=> v85(VarCurr,bitIndex0) ) ).

fof(addAssignment_11309,axiom,
    ! [VarCurr] :
      ( v25772(VarCurr)
    <=> v25774(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_718,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25836(VarNext)
       => ( v25774(VarNext)
        <=> v25774(VarCurr) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_472,axiom,
    ! [VarNext] :
      ( v25836(VarNext)
     => ( v25774(VarNext)
      <=> v25848(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_589,axiom,
    ! [VarCurr] :
      ( ~ v25837(VarCurr)
     => ( v25848(VarCurr)
      <=> v25849(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_595,axiom,
    ! [VarCurr] :
      ( v25837(VarCurr)
     => ( v25848(VarCurr)
      <=> v25780(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_588,axiom,
    ! [VarCurr] :
      ( ~ v25842(VarCurr)
     => ( v25849(VarCurr)
      <=> v25818(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_594,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25842(VarCurr)
       => ( v25849(VarCurr)
        <=> x166(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4490,axiom,
    ! [VarCurr] :
      ( v25836(VarCurr)
    <=> ( v25837(VarCurr)
        | v25840(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4489,axiom,
    ! [VarCurr] :
      ( v25840(VarCurr)
    <=> ( v25841(VarCurr)
        & v25847(VarCurr) ) ) ).

fof(writeUnaryOperator_2345,axiom,
    ! [VarCurr] :
      ( ~ v25847(VarCurr)
    <=> v25837(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4488,axiom,
    ! [VarCurr] :
      ( v25841(VarCurr)
    <=> ( v25842(VarCurr)
        | v25844(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4487,axiom,
    ! [VarCurr] :
      ( v25844(VarCurr)
    <=> ( v25845(VarCurr)
        & v25846(VarCurr) ) ) ).

fof(writeUnaryOperator_2344,axiom,
    ! [VarCurr] :
      ( ~ v25846(VarCurr)
    <=> v25842(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4486,axiom,
    ! [VarCurr] :
      ( v25845(VarCurr)
    <=> ( v25776(VarCurr)
        & v25778(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4485,axiom,
    ! [VarCurr] :
      ( v25842(VarCurr)
    <=> ( v25776(VarCurr)
        & v25843(VarCurr) ) ) ).

fof(writeUnaryOperator_2343,axiom,
    ! [VarCurr] :
      ( ~ v25843(VarCurr)
    <=> v25778(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4484,axiom,
    ! [VarCurr] :
      ( v25837(VarCurr)
    <=> ( v25838(VarCurr)
        & v25839(VarCurr) ) ) ).

fof(writeUnaryOperator_2342,axiom,
    ! [VarCurr] :
      ( ~ v25839(VarCurr)
    <=> v25778(VarCurr) ) ).

fof(writeUnaryOperator_2341,axiom,
    ! [VarCurr] :
      ( ~ v25838(VarCurr)
    <=> v25776(VarCurr) ) ).

fof(addAssignmentInitValueVector_952,axiom,
    ( v25774(constB0)
  <=> $false ) ).

fof(addAssignment_11308,axiom,
    ! [VarCurr] :
      ( v25818(VarCurr)
    <=> v25820(VarCurr) ) ).

fof(addAssignment_11307,axiom,
    ! [VarCurr] :
      ( v25820(VarCurr)
    <=> v25822(VarCurr) ) ).

fof(addAssignment_11306,axiom,
    ! [VarCurr] :
      ( v25822(VarCurr)
    <=> v25824(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_717,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25829(VarNext)
       => ( v25824(VarNext)
        <=> v25824(VarCurr) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_471,axiom,
    ! [VarNext] :
      ( v25829(VarNext)
     => ( v25824(VarNext)
      <=> v81(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4483,axiom,
    ! [VarCurr] :
      ( v25829(VarCurr)
    <=> ( v101(VarCurr)
        & v25830(VarCurr) ) ) ).

fof(writeUnaryOperator_2340,axiom,
    ! [VarCurr] :
      ( ~ v25830(VarCurr)
    <=> v25826(VarCurr) ) ).

fof(addAssignmentInitValueVector_951,axiom,
    ( v25824(constB0)
  <=> $false ) ).

fof(addAssignment_11305,axiom,
    ! [VarCurr] :
      ( v25826(VarCurr)
    <=> v184(VarCurr,bitIndex0) ) ).

fof(addAssignment_11304,axiom,
    ! [VarCurr] :
      ( v25780(VarCurr)
    <=> v25782(VarCurr,bitIndex8) ) ).

fof(addAssignment_11303,axiom,
    ! [VarCurr] :
      ( v25782(VarCurr,bitIndex8)
    <=> v25784(VarCurr,bitIndex8) ) ).

fof(addAssignment_11302,axiom,
    ! [VarCurr] :
      ( v25784(VarCurr,bitIndex8)
    <=> v25816(VarCurr,bitIndex8) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_716,axiom,
    ! [VarCurr] :
      ( ~ v154(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v25816(VarCurr,B)
          <=> v25792(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_470,axiom,
    ! [VarCurr] :
      ( v154(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v25816(VarCurr,B)
          <=> v25786(VarCurr,B) ) ) ) ).

fof(addAssignment_11301,axiom,
    ! [VarCurr] :
      ( v25792(VarCurr,bitIndex8)
    <=> v25815(VarCurr,bitIndex8) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_715,axiom,
    ! [VarCurr] :
      ( ~ v214(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v25815(VarCurr,B)
          <=> v25808(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_469,axiom,
    ! [VarCurr] :
      ( v214(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v25815(VarCurr,B)
          <=> v25794(VarCurr,B) ) ) ) ).

fof(addAssignment_11300,axiom,
    ! [VarCurr] :
      ( v25808(VarCurr,bitIndex8)
    <=> v25810(VarCurr,bitIndex8) ) ).

fof(addAssignment_11299,axiom,
    ! [VarCurr] :
      ( v25810(VarCurr,bitIndex8)
    <=> v25812(VarCurr,bitIndex8) ) ).

fof(addAssignment_11298,axiom,
    ! [VarCurr] :
      ( v25812(VarCurr,bitIndex8)
    <=> v25814(VarCurr,bitIndex8) ) ).

fof(addAssignment_11297,axiom,
    ! [VarCurr] :
      ( v25814(VarCurr,bitIndex8)
    <=> v12024(VarCurr,bitIndex8) ) ).

fof(addAssignment_11296,axiom,
    ! [VarCurr] :
      ( v12024(VarCurr,bitIndex8)
    <=> v12026(VarCurr,bitIndex8) ) ).

fof(addAssignment_11295,axiom,
    ! [VarCurr] :
      ( v12026(VarCurr,bitIndex8)
    <=> v12028(VarCurr,bitIndex8) ) ).

fof(addAssignment_11294,axiom,
    ! [VarCurr] :
      ( v12028(VarCurr,bitIndex8)
    <=> v12030(VarCurr,bitIndex8) ) ).

fof(addAssignment_11293,axiom,
    ! [VarCurr] :
      ( v12030(VarCurr,bitIndex8)
    <=> v12032(VarCurr,bitIndex8) ) ).

fof(addAssignment_11292,axiom,
    ! [VarCurr] :
      ( v12032(VarCurr,bitIndex8)
    <=> v12034(VarCurr,bitIndex8) ) ).

fof(addAssignment_11291,axiom,
    ! [VarCurr] :
      ( v12034(VarCurr,bitIndex8)
    <=> v12036(VarCurr,bitIndex8) ) ).

fof(addAssignment_11290,axiom,
    ! [VarCurr] :
      ( v12036(VarCurr,bitIndex8)
    <=> v12038(VarCurr,bitIndex8) ) ).

fof(addAssignment_11289,axiom,
    ! [VarCurr] :
      ( v12038(VarCurr,bitIndex8)
    <=> v12040(VarCurr,bitIndex8) ) ).

fof(addAssignment_11288,axiom,
    ! [VarCurr] :
      ( v12040(VarCurr,bitIndex8)
    <=> v12042(VarCurr,bitIndex8) ) ).

fof(addAssignment_11287,axiom,
    ! [VarCurr] :
      ( v12042(VarCurr,bitIndex8)
    <=> v12044(VarCurr,bitIndex8) ) ).

fof(addAssignment_11286,axiom,
    ! [VarCurr] :
      ( v12044(VarCurr,bitIndex8)
    <=> v1119(VarCurr,bitIndex8) ) ).

fof(addAssignment_11285,axiom,
    ! [VarCurr] :
      ( v25794(VarCurr,bitIndex8)
    <=> v25796(VarCurr,bitIndex8) ) ).

fof(addAssignment_11284,axiom,
    ! [VarCurr] :
      ( v25796(VarCurr,bitIndex8)
    <=> v25798(VarCurr,bitIndex8) ) ).

fof(addAssignment_11283,axiom,
    ! [VarCurr] :
      ( v25798(VarCurr,bitIndex8)
    <=> v25453(VarCurr,bitIndex8) ) ).

fof(addAssignment_11282,axiom,
    ! [VarCurr] :
      ( v25453(VarCurr,bitIndex8)
    <=> v25483(VarCurr,bitIndex8) ) ).

fof(addAssignment_11281,axiom,
    ! [VarCurr] :
      ( v25484(VarCurr,bitIndex5)
    <=> v25801(VarCurr,bitIndex5) ) ).

fof(addAssignment_11280,axiom,
    ! [VarCurr] :
      ( v25801(VarCurr,bitIndex5)
    <=> v25803(VarCurr,bitIndex5) ) ).

fof(addAssignment_11279,axiom,
    ! [VarCurr] :
      ( v25803(VarCurr,bitIndex5)
    <=> v25806(VarCurr,bitIndex5) ) ).

fof(addCaseBooleanConditionEqualRanges63_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & ~ v25805(VarCurr,bitIndex30)
        & ~ v25805(VarCurr,bitIndex29)
        & ~ v25805(VarCurr,bitIndex28)
        & ~ v25805(VarCurr,bitIndex27)
        & ~ v25805(VarCurr,bitIndex26)
        & ~ v25805(VarCurr,bitIndex25)
        & ~ v25805(VarCurr,bitIndex24)
        & ~ v25805(VarCurr,bitIndex23)
        & ~ v25805(VarCurr,bitIndex22)
        & ~ v25805(VarCurr,bitIndex21)
        & ~ v25805(VarCurr,bitIndex20)
        & ~ v25805(VarCurr,bitIndex19)
        & ~ v25805(VarCurr,bitIndex18)
        & ~ v25805(VarCurr,bitIndex17)
        & ~ v25805(VarCurr,bitIndex16)
        & ~ v25805(VarCurr,bitIndex15)
        & ~ v25805(VarCurr,bitIndex14)
        & ~ v25805(VarCurr,bitIndex13)
        & ~ v25805(VarCurr,bitIndex12)
        & ~ v25805(VarCurr,bitIndex11)
        & ~ v25805(VarCurr,bitIndex10)
        & ~ v25805(VarCurr,bitIndex9)
        & ~ v25805(VarCurr,bitIndex8)
        & ~ v25805(VarCurr,bitIndex7)
        & ~ v25805(VarCurr,bitIndex6)
        & ~ v25805(VarCurr,bitIndex5)
        & ~ v25805(VarCurr,bitIndex4)
        & ~ v25805(VarCurr,bitIndex3)
        & ~ v25805(VarCurr,bitIndex2)
        & ~ v25805(VarCurr,bitIndex1) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> $false ) ) ) ).

fof(addCaseBooleanConditionEqualRanges62_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & ~ v25805(VarCurr,bitIndex30)
        & ~ v25805(VarCurr,bitIndex29)
        & ~ v25805(VarCurr,bitIndex28)
        & ~ v25805(VarCurr,bitIndex27)
        & ~ v25805(VarCurr,bitIndex26)
        & ~ v25805(VarCurr,bitIndex25)
        & ~ v25805(VarCurr,bitIndex24)
        & ~ v25805(VarCurr,bitIndex23)
        & ~ v25805(VarCurr,bitIndex22)
        & ~ v25805(VarCurr,bitIndex21)
        & ~ v25805(VarCurr,bitIndex20)
        & ~ v25805(VarCurr,bitIndex19)
        & ~ v25805(VarCurr,bitIndex18)
        & ~ v25805(VarCurr,bitIndex17)
        & ~ v25805(VarCurr,bitIndex16)
        & ~ v25805(VarCurr,bitIndex15)
        & ~ v25805(VarCurr,bitIndex14)
        & ~ v25805(VarCurr,bitIndex13)
        & ~ v25805(VarCurr,bitIndex12)
        & ~ v25805(VarCurr,bitIndex11)
        & ~ v25805(VarCurr,bitIndex10)
        & ~ v25805(VarCurr,bitIndex9)
        & ~ v25805(VarCurr,bitIndex8)
        & ~ v25805(VarCurr,bitIndex7)
        & ~ v25805(VarCurr,bitIndex6)
        & ~ v25805(VarCurr,bitIndex5)
        & ~ v25805(VarCurr,bitIndex4)
        & ~ v25805(VarCurr,bitIndex3)
        & ~ v25805(VarCurr,bitIndex2)
        & v25805(VarCurr,bitIndex1) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b000001(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges61_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & ~ v25805(VarCurr,bitIndex30)
        & ~ v25805(VarCurr,bitIndex29)
        & ~ v25805(VarCurr,bitIndex28)
        & ~ v25805(VarCurr,bitIndex27)
        & ~ v25805(VarCurr,bitIndex26)
        & ~ v25805(VarCurr,bitIndex25)
        & ~ v25805(VarCurr,bitIndex24)
        & ~ v25805(VarCurr,bitIndex23)
        & ~ v25805(VarCurr,bitIndex22)
        & ~ v25805(VarCurr,bitIndex21)
        & ~ v25805(VarCurr,bitIndex20)
        & ~ v25805(VarCurr,bitIndex19)
        & ~ v25805(VarCurr,bitIndex18)
        & ~ v25805(VarCurr,bitIndex17)
        & ~ v25805(VarCurr,bitIndex16)
        & ~ v25805(VarCurr,bitIndex15)
        & ~ v25805(VarCurr,bitIndex14)
        & ~ v25805(VarCurr,bitIndex13)
        & ~ v25805(VarCurr,bitIndex12)
        & ~ v25805(VarCurr,bitIndex11)
        & ~ v25805(VarCurr,bitIndex10)
        & ~ v25805(VarCurr,bitIndex9)
        & ~ v25805(VarCurr,bitIndex8)
        & ~ v25805(VarCurr,bitIndex7)
        & ~ v25805(VarCurr,bitIndex6)
        & ~ v25805(VarCurr,bitIndex5)
        & ~ v25805(VarCurr,bitIndex4)
        & ~ v25805(VarCurr,bitIndex3)
        & v25805(VarCurr,bitIndex2) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b000010(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges60_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & ~ v25805(VarCurr,bitIndex30)
        & ~ v25805(VarCurr,bitIndex29)
        & ~ v25805(VarCurr,bitIndex28)
        & ~ v25805(VarCurr,bitIndex27)
        & ~ v25805(VarCurr,bitIndex26)
        & ~ v25805(VarCurr,bitIndex25)
        & ~ v25805(VarCurr,bitIndex24)
        & ~ v25805(VarCurr,bitIndex23)
        & ~ v25805(VarCurr,bitIndex22)
        & ~ v25805(VarCurr,bitIndex21)
        & ~ v25805(VarCurr,bitIndex20)
        & ~ v25805(VarCurr,bitIndex19)
        & ~ v25805(VarCurr,bitIndex18)
        & ~ v25805(VarCurr,bitIndex17)
        & ~ v25805(VarCurr,bitIndex16)
        & ~ v25805(VarCurr,bitIndex15)
        & ~ v25805(VarCurr,bitIndex14)
        & ~ v25805(VarCurr,bitIndex13)
        & ~ v25805(VarCurr,bitIndex12)
        & ~ v25805(VarCurr,bitIndex11)
        & ~ v25805(VarCurr,bitIndex10)
        & ~ v25805(VarCurr,bitIndex9)
        & ~ v25805(VarCurr,bitIndex8)
        & ~ v25805(VarCurr,bitIndex7)
        & ~ v25805(VarCurr,bitIndex6)
        & ~ v25805(VarCurr,bitIndex5)
        & ~ v25805(VarCurr,bitIndex4)
        & v25805(VarCurr,bitIndex3) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b000011(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges59_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & ~ v25805(VarCurr,bitIndex30)
        & ~ v25805(VarCurr,bitIndex29)
        & ~ v25805(VarCurr,bitIndex28)
        & ~ v25805(VarCurr,bitIndex27)
        & ~ v25805(VarCurr,bitIndex26)
        & ~ v25805(VarCurr,bitIndex25)
        & ~ v25805(VarCurr,bitIndex24)
        & ~ v25805(VarCurr,bitIndex23)
        & ~ v25805(VarCurr,bitIndex22)
        & ~ v25805(VarCurr,bitIndex21)
        & ~ v25805(VarCurr,bitIndex20)
        & ~ v25805(VarCurr,bitIndex19)
        & ~ v25805(VarCurr,bitIndex18)
        & ~ v25805(VarCurr,bitIndex17)
        & ~ v25805(VarCurr,bitIndex16)
        & ~ v25805(VarCurr,bitIndex15)
        & ~ v25805(VarCurr,bitIndex14)
        & ~ v25805(VarCurr,bitIndex13)
        & ~ v25805(VarCurr,bitIndex12)
        & ~ v25805(VarCurr,bitIndex11)
        & ~ v25805(VarCurr,bitIndex10)
        & ~ v25805(VarCurr,bitIndex9)
        & ~ v25805(VarCurr,bitIndex8)
        & ~ v25805(VarCurr,bitIndex7)
        & ~ v25805(VarCurr,bitIndex6)
        & ~ v25805(VarCurr,bitIndex5)
        & v25805(VarCurr,bitIndex4) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b000100(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges58_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & ~ v25805(VarCurr,bitIndex30)
        & ~ v25805(VarCurr,bitIndex29)
        & ~ v25805(VarCurr,bitIndex28)
        & ~ v25805(VarCurr,bitIndex27)
        & ~ v25805(VarCurr,bitIndex26)
        & ~ v25805(VarCurr,bitIndex25)
        & ~ v25805(VarCurr,bitIndex24)
        & ~ v25805(VarCurr,bitIndex23)
        & ~ v25805(VarCurr,bitIndex22)
        & ~ v25805(VarCurr,bitIndex21)
        & ~ v25805(VarCurr,bitIndex20)
        & ~ v25805(VarCurr,bitIndex19)
        & ~ v25805(VarCurr,bitIndex18)
        & ~ v25805(VarCurr,bitIndex17)
        & ~ v25805(VarCurr,bitIndex16)
        & ~ v25805(VarCurr,bitIndex15)
        & ~ v25805(VarCurr,bitIndex14)
        & ~ v25805(VarCurr,bitIndex13)
        & ~ v25805(VarCurr,bitIndex12)
        & ~ v25805(VarCurr,bitIndex11)
        & ~ v25805(VarCurr,bitIndex10)
        & ~ v25805(VarCurr,bitIndex9)
        & ~ v25805(VarCurr,bitIndex8)
        & ~ v25805(VarCurr,bitIndex7)
        & ~ v25805(VarCurr,bitIndex6)
        & v25805(VarCurr,bitIndex5) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b000101(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges57_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & ~ v25805(VarCurr,bitIndex30)
        & ~ v25805(VarCurr,bitIndex29)
        & ~ v25805(VarCurr,bitIndex28)
        & ~ v25805(VarCurr,bitIndex27)
        & ~ v25805(VarCurr,bitIndex26)
        & ~ v25805(VarCurr,bitIndex25)
        & ~ v25805(VarCurr,bitIndex24)
        & ~ v25805(VarCurr,bitIndex23)
        & ~ v25805(VarCurr,bitIndex22)
        & ~ v25805(VarCurr,bitIndex21)
        & ~ v25805(VarCurr,bitIndex20)
        & ~ v25805(VarCurr,bitIndex19)
        & ~ v25805(VarCurr,bitIndex18)
        & ~ v25805(VarCurr,bitIndex17)
        & ~ v25805(VarCurr,bitIndex16)
        & ~ v25805(VarCurr,bitIndex15)
        & ~ v25805(VarCurr,bitIndex14)
        & ~ v25805(VarCurr,bitIndex13)
        & ~ v25805(VarCurr,bitIndex12)
        & ~ v25805(VarCurr,bitIndex11)
        & ~ v25805(VarCurr,bitIndex10)
        & ~ v25805(VarCurr,bitIndex9)
        & ~ v25805(VarCurr,bitIndex8)
        & ~ v25805(VarCurr,bitIndex7)
        & v25805(VarCurr,bitIndex6) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b000110(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges56_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & ~ v25805(VarCurr,bitIndex30)
        & ~ v25805(VarCurr,bitIndex29)
        & ~ v25805(VarCurr,bitIndex28)
        & ~ v25805(VarCurr,bitIndex27)
        & ~ v25805(VarCurr,bitIndex26)
        & ~ v25805(VarCurr,bitIndex25)
        & ~ v25805(VarCurr,bitIndex24)
        & ~ v25805(VarCurr,bitIndex23)
        & ~ v25805(VarCurr,bitIndex22)
        & ~ v25805(VarCurr,bitIndex21)
        & ~ v25805(VarCurr,bitIndex20)
        & ~ v25805(VarCurr,bitIndex19)
        & ~ v25805(VarCurr,bitIndex18)
        & ~ v25805(VarCurr,bitIndex17)
        & ~ v25805(VarCurr,bitIndex16)
        & ~ v25805(VarCurr,bitIndex15)
        & ~ v25805(VarCurr,bitIndex14)
        & ~ v25805(VarCurr,bitIndex13)
        & ~ v25805(VarCurr,bitIndex12)
        & ~ v25805(VarCurr,bitIndex11)
        & ~ v25805(VarCurr,bitIndex10)
        & ~ v25805(VarCurr,bitIndex9)
        & ~ v25805(VarCurr,bitIndex8)
        & v25805(VarCurr,bitIndex7) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b000111(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges55_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & ~ v25805(VarCurr,bitIndex30)
        & ~ v25805(VarCurr,bitIndex29)
        & ~ v25805(VarCurr,bitIndex28)
        & ~ v25805(VarCurr,bitIndex27)
        & ~ v25805(VarCurr,bitIndex26)
        & ~ v25805(VarCurr,bitIndex25)
        & ~ v25805(VarCurr,bitIndex24)
        & ~ v25805(VarCurr,bitIndex23)
        & ~ v25805(VarCurr,bitIndex22)
        & ~ v25805(VarCurr,bitIndex21)
        & ~ v25805(VarCurr,bitIndex20)
        & ~ v25805(VarCurr,bitIndex19)
        & ~ v25805(VarCurr,bitIndex18)
        & ~ v25805(VarCurr,bitIndex17)
        & ~ v25805(VarCurr,bitIndex16)
        & ~ v25805(VarCurr,bitIndex15)
        & ~ v25805(VarCurr,bitIndex14)
        & ~ v25805(VarCurr,bitIndex13)
        & ~ v25805(VarCurr,bitIndex12)
        & ~ v25805(VarCurr,bitIndex11)
        & ~ v25805(VarCurr,bitIndex10)
        & ~ v25805(VarCurr,bitIndex9)
        & v25805(VarCurr,bitIndex8) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b001000(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges54_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & ~ v25805(VarCurr,bitIndex30)
        & ~ v25805(VarCurr,bitIndex29)
        & ~ v25805(VarCurr,bitIndex28)
        & ~ v25805(VarCurr,bitIndex27)
        & ~ v25805(VarCurr,bitIndex26)
        & ~ v25805(VarCurr,bitIndex25)
        & ~ v25805(VarCurr,bitIndex24)
        & ~ v25805(VarCurr,bitIndex23)
        & ~ v25805(VarCurr,bitIndex22)
        & ~ v25805(VarCurr,bitIndex21)
        & ~ v25805(VarCurr,bitIndex20)
        & ~ v25805(VarCurr,bitIndex19)
        & ~ v25805(VarCurr,bitIndex18)
        & ~ v25805(VarCurr,bitIndex17)
        & ~ v25805(VarCurr,bitIndex16)
        & ~ v25805(VarCurr,bitIndex15)
        & ~ v25805(VarCurr,bitIndex14)
        & ~ v25805(VarCurr,bitIndex13)
        & ~ v25805(VarCurr,bitIndex12)
        & ~ v25805(VarCurr,bitIndex11)
        & ~ v25805(VarCurr,bitIndex10)
        & v25805(VarCurr,bitIndex9) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b001001(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges53_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & ~ v25805(VarCurr,bitIndex30)
        & ~ v25805(VarCurr,bitIndex29)
        & ~ v25805(VarCurr,bitIndex28)
        & ~ v25805(VarCurr,bitIndex27)
        & ~ v25805(VarCurr,bitIndex26)
        & ~ v25805(VarCurr,bitIndex25)
        & ~ v25805(VarCurr,bitIndex24)
        & ~ v25805(VarCurr,bitIndex23)
        & ~ v25805(VarCurr,bitIndex22)
        & ~ v25805(VarCurr,bitIndex21)
        & ~ v25805(VarCurr,bitIndex20)
        & ~ v25805(VarCurr,bitIndex19)
        & ~ v25805(VarCurr,bitIndex18)
        & ~ v25805(VarCurr,bitIndex17)
        & ~ v25805(VarCurr,bitIndex16)
        & ~ v25805(VarCurr,bitIndex15)
        & ~ v25805(VarCurr,bitIndex14)
        & ~ v25805(VarCurr,bitIndex13)
        & ~ v25805(VarCurr,bitIndex12)
        & ~ v25805(VarCurr,bitIndex11)
        & v25805(VarCurr,bitIndex10) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b001010(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges52_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & ~ v25805(VarCurr,bitIndex30)
        & ~ v25805(VarCurr,bitIndex29)
        & ~ v25805(VarCurr,bitIndex28)
        & ~ v25805(VarCurr,bitIndex27)
        & ~ v25805(VarCurr,bitIndex26)
        & ~ v25805(VarCurr,bitIndex25)
        & ~ v25805(VarCurr,bitIndex24)
        & ~ v25805(VarCurr,bitIndex23)
        & ~ v25805(VarCurr,bitIndex22)
        & ~ v25805(VarCurr,bitIndex21)
        & ~ v25805(VarCurr,bitIndex20)
        & ~ v25805(VarCurr,bitIndex19)
        & ~ v25805(VarCurr,bitIndex18)
        & ~ v25805(VarCurr,bitIndex17)
        & ~ v25805(VarCurr,bitIndex16)
        & ~ v25805(VarCurr,bitIndex15)
        & ~ v25805(VarCurr,bitIndex14)
        & ~ v25805(VarCurr,bitIndex13)
        & ~ v25805(VarCurr,bitIndex12)
        & v25805(VarCurr,bitIndex11) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b001011(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges51_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & ~ v25805(VarCurr,bitIndex30)
        & ~ v25805(VarCurr,bitIndex29)
        & ~ v25805(VarCurr,bitIndex28)
        & ~ v25805(VarCurr,bitIndex27)
        & ~ v25805(VarCurr,bitIndex26)
        & ~ v25805(VarCurr,bitIndex25)
        & ~ v25805(VarCurr,bitIndex24)
        & ~ v25805(VarCurr,bitIndex23)
        & ~ v25805(VarCurr,bitIndex22)
        & ~ v25805(VarCurr,bitIndex21)
        & ~ v25805(VarCurr,bitIndex20)
        & ~ v25805(VarCurr,bitIndex19)
        & ~ v25805(VarCurr,bitIndex18)
        & ~ v25805(VarCurr,bitIndex17)
        & ~ v25805(VarCurr,bitIndex16)
        & ~ v25805(VarCurr,bitIndex15)
        & ~ v25805(VarCurr,bitIndex14)
        & ~ v25805(VarCurr,bitIndex13)
        & v25805(VarCurr,bitIndex12) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b001100(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges50_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & ~ v25805(VarCurr,bitIndex30)
        & ~ v25805(VarCurr,bitIndex29)
        & ~ v25805(VarCurr,bitIndex28)
        & ~ v25805(VarCurr,bitIndex27)
        & ~ v25805(VarCurr,bitIndex26)
        & ~ v25805(VarCurr,bitIndex25)
        & ~ v25805(VarCurr,bitIndex24)
        & ~ v25805(VarCurr,bitIndex23)
        & ~ v25805(VarCurr,bitIndex22)
        & ~ v25805(VarCurr,bitIndex21)
        & ~ v25805(VarCurr,bitIndex20)
        & ~ v25805(VarCurr,bitIndex19)
        & ~ v25805(VarCurr,bitIndex18)
        & ~ v25805(VarCurr,bitIndex17)
        & ~ v25805(VarCurr,bitIndex16)
        & ~ v25805(VarCurr,bitIndex15)
        & ~ v25805(VarCurr,bitIndex14)
        & v25805(VarCurr,bitIndex13) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b001101(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges49_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & ~ v25805(VarCurr,bitIndex30)
        & ~ v25805(VarCurr,bitIndex29)
        & ~ v25805(VarCurr,bitIndex28)
        & ~ v25805(VarCurr,bitIndex27)
        & ~ v25805(VarCurr,bitIndex26)
        & ~ v25805(VarCurr,bitIndex25)
        & ~ v25805(VarCurr,bitIndex24)
        & ~ v25805(VarCurr,bitIndex23)
        & ~ v25805(VarCurr,bitIndex22)
        & ~ v25805(VarCurr,bitIndex21)
        & ~ v25805(VarCurr,bitIndex20)
        & ~ v25805(VarCurr,bitIndex19)
        & ~ v25805(VarCurr,bitIndex18)
        & ~ v25805(VarCurr,bitIndex17)
        & ~ v25805(VarCurr,bitIndex16)
        & ~ v25805(VarCurr,bitIndex15)
        & v25805(VarCurr,bitIndex14) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b001110(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges48_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & ~ v25805(VarCurr,bitIndex30)
        & ~ v25805(VarCurr,bitIndex29)
        & ~ v25805(VarCurr,bitIndex28)
        & ~ v25805(VarCurr,bitIndex27)
        & ~ v25805(VarCurr,bitIndex26)
        & ~ v25805(VarCurr,bitIndex25)
        & ~ v25805(VarCurr,bitIndex24)
        & ~ v25805(VarCurr,bitIndex23)
        & ~ v25805(VarCurr,bitIndex22)
        & ~ v25805(VarCurr,bitIndex21)
        & ~ v25805(VarCurr,bitIndex20)
        & ~ v25805(VarCurr,bitIndex19)
        & ~ v25805(VarCurr,bitIndex18)
        & ~ v25805(VarCurr,bitIndex17)
        & ~ v25805(VarCurr,bitIndex16)
        & v25805(VarCurr,bitIndex15) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b001111(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges47_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & ~ v25805(VarCurr,bitIndex30)
        & ~ v25805(VarCurr,bitIndex29)
        & ~ v25805(VarCurr,bitIndex28)
        & ~ v25805(VarCurr,bitIndex27)
        & ~ v25805(VarCurr,bitIndex26)
        & ~ v25805(VarCurr,bitIndex25)
        & ~ v25805(VarCurr,bitIndex24)
        & ~ v25805(VarCurr,bitIndex23)
        & ~ v25805(VarCurr,bitIndex22)
        & ~ v25805(VarCurr,bitIndex21)
        & ~ v25805(VarCurr,bitIndex20)
        & ~ v25805(VarCurr,bitIndex19)
        & ~ v25805(VarCurr,bitIndex18)
        & ~ v25805(VarCurr,bitIndex17)
        & v25805(VarCurr,bitIndex16) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b010000(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges46_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & ~ v25805(VarCurr,bitIndex30)
        & ~ v25805(VarCurr,bitIndex29)
        & ~ v25805(VarCurr,bitIndex28)
        & ~ v25805(VarCurr,bitIndex27)
        & ~ v25805(VarCurr,bitIndex26)
        & ~ v25805(VarCurr,bitIndex25)
        & ~ v25805(VarCurr,bitIndex24)
        & ~ v25805(VarCurr,bitIndex23)
        & ~ v25805(VarCurr,bitIndex22)
        & ~ v25805(VarCurr,bitIndex21)
        & ~ v25805(VarCurr,bitIndex20)
        & ~ v25805(VarCurr,bitIndex19)
        & ~ v25805(VarCurr,bitIndex18)
        & v25805(VarCurr,bitIndex17) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b010001(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges45_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & ~ v25805(VarCurr,bitIndex30)
        & ~ v25805(VarCurr,bitIndex29)
        & ~ v25805(VarCurr,bitIndex28)
        & ~ v25805(VarCurr,bitIndex27)
        & ~ v25805(VarCurr,bitIndex26)
        & ~ v25805(VarCurr,bitIndex25)
        & ~ v25805(VarCurr,bitIndex24)
        & ~ v25805(VarCurr,bitIndex23)
        & ~ v25805(VarCurr,bitIndex22)
        & ~ v25805(VarCurr,bitIndex21)
        & ~ v25805(VarCurr,bitIndex20)
        & ~ v25805(VarCurr,bitIndex19)
        & v25805(VarCurr,bitIndex18) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b010010(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges44_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & ~ v25805(VarCurr,bitIndex30)
        & ~ v25805(VarCurr,bitIndex29)
        & ~ v25805(VarCurr,bitIndex28)
        & ~ v25805(VarCurr,bitIndex27)
        & ~ v25805(VarCurr,bitIndex26)
        & ~ v25805(VarCurr,bitIndex25)
        & ~ v25805(VarCurr,bitIndex24)
        & ~ v25805(VarCurr,bitIndex23)
        & ~ v25805(VarCurr,bitIndex22)
        & ~ v25805(VarCurr,bitIndex21)
        & ~ v25805(VarCurr,bitIndex20)
        & v25805(VarCurr,bitIndex19) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b010011(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges43_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & ~ v25805(VarCurr,bitIndex30)
        & ~ v25805(VarCurr,bitIndex29)
        & ~ v25805(VarCurr,bitIndex28)
        & ~ v25805(VarCurr,bitIndex27)
        & ~ v25805(VarCurr,bitIndex26)
        & ~ v25805(VarCurr,bitIndex25)
        & ~ v25805(VarCurr,bitIndex24)
        & ~ v25805(VarCurr,bitIndex23)
        & ~ v25805(VarCurr,bitIndex22)
        & ~ v25805(VarCurr,bitIndex21)
        & v25805(VarCurr,bitIndex20) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b010100(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges42_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & ~ v25805(VarCurr,bitIndex30)
        & ~ v25805(VarCurr,bitIndex29)
        & ~ v25805(VarCurr,bitIndex28)
        & ~ v25805(VarCurr,bitIndex27)
        & ~ v25805(VarCurr,bitIndex26)
        & ~ v25805(VarCurr,bitIndex25)
        & ~ v25805(VarCurr,bitIndex24)
        & ~ v25805(VarCurr,bitIndex23)
        & ~ v25805(VarCurr,bitIndex22)
        & v25805(VarCurr,bitIndex21) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b010101(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges41_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & ~ v25805(VarCurr,bitIndex30)
        & ~ v25805(VarCurr,bitIndex29)
        & ~ v25805(VarCurr,bitIndex28)
        & ~ v25805(VarCurr,bitIndex27)
        & ~ v25805(VarCurr,bitIndex26)
        & ~ v25805(VarCurr,bitIndex25)
        & ~ v25805(VarCurr,bitIndex24)
        & ~ v25805(VarCurr,bitIndex23)
        & v25805(VarCurr,bitIndex22) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b010110(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges40_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & ~ v25805(VarCurr,bitIndex30)
        & ~ v25805(VarCurr,bitIndex29)
        & ~ v25805(VarCurr,bitIndex28)
        & ~ v25805(VarCurr,bitIndex27)
        & ~ v25805(VarCurr,bitIndex26)
        & ~ v25805(VarCurr,bitIndex25)
        & ~ v25805(VarCurr,bitIndex24)
        & v25805(VarCurr,bitIndex23) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b010111(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges39_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & ~ v25805(VarCurr,bitIndex30)
        & ~ v25805(VarCurr,bitIndex29)
        & ~ v25805(VarCurr,bitIndex28)
        & ~ v25805(VarCurr,bitIndex27)
        & ~ v25805(VarCurr,bitIndex26)
        & ~ v25805(VarCurr,bitIndex25)
        & v25805(VarCurr,bitIndex24) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b011000(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges38_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & ~ v25805(VarCurr,bitIndex30)
        & ~ v25805(VarCurr,bitIndex29)
        & ~ v25805(VarCurr,bitIndex28)
        & ~ v25805(VarCurr,bitIndex27)
        & ~ v25805(VarCurr,bitIndex26)
        & v25805(VarCurr,bitIndex25) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b011001(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges37_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & ~ v25805(VarCurr,bitIndex30)
        & ~ v25805(VarCurr,bitIndex29)
        & ~ v25805(VarCurr,bitIndex28)
        & ~ v25805(VarCurr,bitIndex27)
        & v25805(VarCurr,bitIndex26) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b011010(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges36_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & ~ v25805(VarCurr,bitIndex30)
        & ~ v25805(VarCurr,bitIndex29)
        & ~ v25805(VarCurr,bitIndex28)
        & v25805(VarCurr,bitIndex27) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b011011(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges35_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & ~ v25805(VarCurr,bitIndex30)
        & ~ v25805(VarCurr,bitIndex29)
        & v25805(VarCurr,bitIndex28) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b011100(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges34_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & ~ v25805(VarCurr,bitIndex30)
        & v25805(VarCurr,bitIndex29) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b011101(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges33_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & ~ v25805(VarCurr,bitIndex31)
        & v25805(VarCurr,bitIndex30) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b011110(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges32_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & ~ v25805(VarCurr,bitIndex32)
        & v25805(VarCurr,bitIndex31) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b011111(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges31_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & ~ v25805(VarCurr,bitIndex33)
        & v25805(VarCurr,bitIndex32) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b100000(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges30_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & ~ v25805(VarCurr,bitIndex34)
        & v25805(VarCurr,bitIndex33) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b100001(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges29_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & ~ v25805(VarCurr,bitIndex35)
        & v25805(VarCurr,bitIndex34) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b100010(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges28_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & ~ v25805(VarCurr,bitIndex36)
        & v25805(VarCurr,bitIndex35) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b100011(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges27_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & ~ v25805(VarCurr,bitIndex37)
        & v25805(VarCurr,bitIndex36) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b100100(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges26_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & ~ v25805(VarCurr,bitIndex38)
        & v25805(VarCurr,bitIndex37) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b100101(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges25_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & ~ v25805(VarCurr,bitIndex39)
        & v25805(VarCurr,bitIndex38) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b100110(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges24_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & ~ v25805(VarCurr,bitIndex40)
        & v25805(VarCurr,bitIndex39) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b100111(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges23_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & ~ v25805(VarCurr,bitIndex41)
        & v25805(VarCurr,bitIndex40) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b101000(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges22_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & ~ v25805(VarCurr,bitIndex42)
        & v25805(VarCurr,bitIndex41) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b101001(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges21_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & ~ v25805(VarCurr,bitIndex43)
        & v25805(VarCurr,bitIndex42) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b101010(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges20_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & ~ v25805(VarCurr,bitIndex44)
        & v25805(VarCurr,bitIndex43) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b101011(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges19_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & ~ v25805(VarCurr,bitIndex45)
        & v25805(VarCurr,bitIndex44) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b101100(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges18_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & ~ v25805(VarCurr,bitIndex46)
        & v25805(VarCurr,bitIndex45) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b101101(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges17_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & ~ v25805(VarCurr,bitIndex47)
        & v25805(VarCurr,bitIndex46) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b101110(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges16_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & ~ v25805(VarCurr,bitIndex48)
        & v25805(VarCurr,bitIndex47) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b101111(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges15_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & ~ v25805(VarCurr,bitIndex49)
        & v25805(VarCurr,bitIndex48) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b110000(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges14_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & ~ v25805(VarCurr,bitIndex50)
        & v25805(VarCurr,bitIndex49) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b110001(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges13_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & ~ v25805(VarCurr,bitIndex51)
        & v25805(VarCurr,bitIndex50) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b110010(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges12_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & ~ v25805(VarCurr,bitIndex52)
        & v25805(VarCurr,bitIndex51) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b110011(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges11_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & ~ v25805(VarCurr,bitIndex53)
        & v25805(VarCurr,bitIndex52) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b110100(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges10_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & ~ v25805(VarCurr,bitIndex54)
        & v25805(VarCurr,bitIndex53) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b110101(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges9_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & ~ v25805(VarCurr,bitIndex55)
        & v25805(VarCurr,bitIndex54) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b110110(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges8_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & ~ v25805(VarCurr,bitIndex56)
        & v25805(VarCurr,bitIndex55) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b110111(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges7_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & ~ v25805(VarCurr,bitIndex57)
        & v25805(VarCurr,bitIndex56) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b111000(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges6_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & ~ v25805(VarCurr,bitIndex58)
        & v25805(VarCurr,bitIndex57) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b111001(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges5_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & ~ v25805(VarCurr,bitIndex59)
        & v25805(VarCurr,bitIndex58) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b111010(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges4_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & ~ v25805(VarCurr,bitIndex60)
        & v25805(VarCurr,bitIndex59) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b111011(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges3_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & ~ v25805(VarCurr,bitIndex61)
        & v25805(VarCurr,bitIndex60) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b111100(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges2_1,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & ~ v25805(VarCurr,bitIndex62)
        & v25805(VarCurr,bitIndex61) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b111101(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_461,axiom,
    ! [VarCurr] :
      ( ( ~ v25805(VarCurr,bitIndex63)
        & v25805(VarCurr,bitIndex62) )
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> b111110(B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_400,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex63)
     => ! [B] :
          ( range_5_0(B)
         => ( v25806(VarCurr,B)
          <=> $true ) ) ) ).

fof(addAssignment_11278,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex1)
    <=> v11907(VarCurr,bitIndex1) ) ).

fof(addAssignment_11277,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex2)
    <=> v11907(VarCurr,bitIndex2) ) ).

fof(addAssignment_11276,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex3)
    <=> v11907(VarCurr,bitIndex3) ) ).

fof(addAssignment_11275,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex4)
    <=> v11907(VarCurr,bitIndex4) ) ).

fof(addAssignment_11274,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex5)
    <=> v11907(VarCurr,bitIndex5) ) ).

fof(addAssignment_11273,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex6)
    <=> v11907(VarCurr,bitIndex6) ) ).

fof(addAssignment_11272,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex7)
    <=> v11907(VarCurr,bitIndex7) ) ).

fof(addAssignment_11271,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex8)
    <=> v11907(VarCurr,bitIndex8) ) ).

fof(addAssignment_11270,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex9)
    <=> v11907(VarCurr,bitIndex9) ) ).

fof(addAssignment_11269,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex10)
    <=> v11907(VarCurr,bitIndex10) ) ).

fof(addAssignment_11268,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex11)
    <=> v11907(VarCurr,bitIndex11) ) ).

fof(addAssignment_11267,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex12)
    <=> v11907(VarCurr,bitIndex12) ) ).

fof(addAssignment_11266,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex13)
    <=> v11907(VarCurr,bitIndex13) ) ).

fof(addAssignment_11265,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex14)
    <=> v11907(VarCurr,bitIndex14) ) ).

fof(addAssignment_11264,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex15)
    <=> v11907(VarCurr,bitIndex15) ) ).

fof(addAssignment_11263,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex16)
    <=> v11907(VarCurr,bitIndex16) ) ).

fof(addAssignment_11262,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex17)
    <=> v11907(VarCurr,bitIndex17) ) ).

fof(addAssignment_11261,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex18)
    <=> v11907(VarCurr,bitIndex18) ) ).

fof(addAssignment_11260,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex19)
    <=> v11907(VarCurr,bitIndex19) ) ).

fof(addAssignment_11259,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex20)
    <=> v11907(VarCurr,bitIndex20) ) ).

fof(addAssignment_11258,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex21)
    <=> v11907(VarCurr,bitIndex21) ) ).

fof(addAssignment_11257,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex22)
    <=> v11907(VarCurr,bitIndex22) ) ).

fof(addAssignment_11256,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex23)
    <=> v11907(VarCurr,bitIndex23) ) ).

fof(addAssignment_11255,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex24)
    <=> v11907(VarCurr,bitIndex24) ) ).

fof(addAssignment_11254,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex25)
    <=> v11907(VarCurr,bitIndex25) ) ).

fof(addAssignment_11253,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex26)
    <=> v11907(VarCurr,bitIndex26) ) ).

fof(addAssignment_11252,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex27)
    <=> v11907(VarCurr,bitIndex27) ) ).

fof(addAssignment_11251,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex28)
    <=> v11907(VarCurr,bitIndex28) ) ).

fof(addAssignment_11250,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex29)
    <=> v11907(VarCurr,bitIndex29) ) ).

fof(addAssignment_11249,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex30)
    <=> v11907(VarCurr,bitIndex30) ) ).

fof(addAssignment_11248,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex31)
    <=> v11907(VarCurr,bitIndex31) ) ).

fof(addAssignment_11247,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex32)
    <=> v11907(VarCurr,bitIndex32) ) ).

fof(addAssignment_11246,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex33)
    <=> v11907(VarCurr,bitIndex33) ) ).

fof(addAssignment_11245,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex34)
    <=> v11907(VarCurr,bitIndex34) ) ).

fof(addAssignment_11244,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex35)
    <=> v11907(VarCurr,bitIndex35) ) ).

fof(addAssignment_11243,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex36)
    <=> v11907(VarCurr,bitIndex36) ) ).

fof(addAssignment_11242,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex37)
    <=> v11907(VarCurr,bitIndex37) ) ).

fof(addAssignment_11241,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex38)
    <=> v11907(VarCurr,bitIndex38) ) ).

fof(addAssignment_11240,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex39)
    <=> v11907(VarCurr,bitIndex39) ) ).

fof(addAssignment_11239,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex40)
    <=> v11907(VarCurr,bitIndex40) ) ).

fof(addAssignment_11238,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex41)
    <=> v11907(VarCurr,bitIndex41) ) ).

fof(addAssignment_11237,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex42)
    <=> v11907(VarCurr,bitIndex42) ) ).

fof(addAssignment_11236,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex43)
    <=> v11907(VarCurr,bitIndex43) ) ).

fof(addAssignment_11235,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex44)
    <=> v11907(VarCurr,bitIndex44) ) ).

fof(addAssignment_11234,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex45)
    <=> v11907(VarCurr,bitIndex45) ) ).

fof(addAssignment_11233,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex46)
    <=> v11907(VarCurr,bitIndex46) ) ).

fof(addAssignment_11232,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex47)
    <=> v11907(VarCurr,bitIndex47) ) ).

fof(addAssignment_11231,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex48)
    <=> v11907(VarCurr,bitIndex48) ) ).

fof(addAssignment_11230,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex49)
    <=> v11907(VarCurr,bitIndex49) ) ).

fof(addAssignment_11229,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex50)
    <=> v11907(VarCurr,bitIndex50) ) ).

fof(addAssignment_11228,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex51)
    <=> v11907(VarCurr,bitIndex51) ) ).

fof(addAssignment_11227,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex52)
    <=> v11907(VarCurr,bitIndex52) ) ).

fof(addAssignment_11226,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex53)
    <=> v11907(VarCurr,bitIndex53) ) ).

fof(addAssignment_11225,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex54)
    <=> v11907(VarCurr,bitIndex54) ) ).

fof(addAssignment_11224,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex55)
    <=> v11907(VarCurr,bitIndex55) ) ).

fof(addAssignment_11223,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex56)
    <=> v11907(VarCurr,bitIndex56) ) ).

fof(addAssignment_11222,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex57)
    <=> v11907(VarCurr,bitIndex57) ) ).

fof(addAssignment_11221,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex58)
    <=> v11907(VarCurr,bitIndex58) ) ).

fof(addAssignment_11220,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex59)
    <=> v11907(VarCurr,bitIndex59) ) ).

fof(addAssignment_11219,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex60)
    <=> v11907(VarCurr,bitIndex60) ) ).

fof(addAssignment_11218,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex61)
    <=> v11907(VarCurr,bitIndex61) ) ).

fof(addAssignment_11217,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex62)
    <=> v11907(VarCurr,bitIndex62) ) ).

fof(addAssignment_11216,axiom,
    ! [VarCurr] :
      ( v25805(VarCurr,bitIndex63)
    <=> v11907(VarCurr,bitIndex63) ) ).

fof(addAssignment_11215,axiom,
    ! [VarCurr] :
      ( v25786(VarCurr,bitIndex8)
    <=> v25788(VarCurr,bitIndex8) ) ).

fof(addAssignment_11214,axiom,
    ! [VarCurr] :
      ( v25788(VarCurr,bitIndex8)
    <=> v25790(VarCurr,bitIndex8) ) ).

fof(addAssignment_11213,axiom,
    ! [VarCurr] :
      ( v25778(VarCurr)
    <=> v103(VarCurr,bitIndex0) ) ).

fof(addAssignment_11212,axiom,
    ! [VarCurr] :
      ( v25776(VarCurr)
    <=> v85(VarCurr,bitIndex0) ) ).

fof(addAssignment_11211,axiom,
    ! [VarCurr] :
      ( v25613(VarCurr)
    <=> v25615(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4482,axiom,
    ! [VarCurr] :
      ( v25615(VarCurr)
    <=> ( v25617(VarCurr)
        & v25603(VarCurr) ) ) ).

fof(addAssignment_11210,axiom,
    ! [VarCurr] :
      ( v25617(VarCurr)
    <=> v25619(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_460,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25750(VarNext)
       => ( v25619(VarNext)
        <=> v25619(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_399,axiom,
    ! [VarNext] :
      ( v25750(VarNext)
     => ( v25619(VarNext)
      <=> v25760(VarNext) ) ) ).

fof(addAssignment_11209,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25760(VarNext)
      <=> v25758(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_714,axiom,
    ! [VarCurr] :
      ( ~ v25761(VarCurr)
     => ( v25758(VarCurr)
      <=> x19156(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_468,axiom,
    ! [VarCurr] :
      ( v25761(VarCurr)
     => ( v25758(VarCurr)
      <=> v25629(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4481,axiom,
    ! [VarCurr] :
      ( v25761(VarCurr)
    <=> ( v25762(VarCurr)
        & v25763(VarCurr) ) ) ).

fof(writeUnaryOperator_2339,axiom,
    ! [VarCurr] :
      ( ~ v25763(VarCurr)
    <=> v25623(VarCurr) ) ).

fof(writeUnaryOperator_2338,axiom,
    ! [VarCurr] :
      ( ~ v25762(VarCurr)
    <=> v25621(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4480,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25750(VarNext)
      <=> v25751(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4479,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25751(VarNext)
      <=> ( v25752(VarNext)
          & v25747(VarNext) ) ) ) ).

fof(writeUnaryOperator_2337,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25752(VarNext)
      <=> v25754(VarNext) ) ) ).

fof(addAssignment_11208,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25754(VarNext)
      <=> v25747(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_950,axiom,
    ( v25619(constB0)
  <=> $false ) ).

fof(addAssignment_11207,axiom,
    ! [VarCurr] :
      ( v25747(VarCurr)
    <=> v103(VarCurr,bitIndex0) ) ).

fof(addAssignment_11206,axiom,
    ! [VarCurr] :
      ( v25629(VarCurr)
    <=> v25631(VarCurr) ) ).

fof(addAssignment_11205,axiom,
    ! [VarCurr] :
      ( v25631(VarCurr)
    <=> v25633(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_713,axiom,
    ! [VarCurr] :
      ( ~ v154(VarCurr)
     => ( v25633(VarCurr)
      <=> v25641(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_467,axiom,
    ! [VarCurr] :
      ( v154(VarCurr)
     => ( v25633(VarCurr)
      <=> v25635(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_712,axiom,
    ! [VarCurr] :
      ( ~ v214(VarCurr)
     => ( v25641(VarCurr)
      <=> v25653(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_466,axiom,
    ! [VarCurr] :
      ( v214(VarCurr)
     => ( v25641(VarCurr)
      <=> v25643(VarCurr) ) ) ).

fof(addAssignment_11204,axiom,
    ! [VarCurr] :
      ( v25653(VarCurr)
    <=> v25655(VarCurr) ) ).

fof(addAssignment_11203,axiom,
    ! [VarCurr] :
      ( v25655(VarCurr)
    <=> v25657(VarCurr) ) ).

fof(addAssignment_11202,axiom,
    ! [VarCurr] :
      ( v25657(VarCurr)
    <=> v25659(VarCurr) ) ).

fof(addAssignment_11201,axiom,
    ! [VarCurr] :
      ( v25659(VarCurr)
    <=> v25661(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_459,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25732(VarNext)
       => ( v25661(VarNext)
        <=> v25661(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_398,axiom,
    ! [VarNext] :
      ( v25732(VarNext)
     => ( v25661(VarNext)
      <=> v25740(VarNext) ) ) ).

fof(addAssignment_11200,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25740(VarNext)
      <=> v25738(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_711,axiom,
    ! [VarCurr] :
      ( ~ v2981(VarCurr)
     => ( v25738(VarCurr)
      <=> v25741(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_465,axiom,
    ! [VarCurr] :
      ( v2981(VarCurr)
     => ( v25738(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4478,axiom,
    ! [VarCurr] :
      ( v25741(VarCurr)
    <=> ( v2945(VarCurr)
        & v25663(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4477,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25732(VarNext)
      <=> v25733(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4476,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25733(VarNext)
      <=> ( v25735(VarNext)
          & v2967(VarNext) ) ) ) ).

fof(writeUnaryOperator_2336,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25735(VarNext)
      <=> v2974(VarNext) ) ) ).

fof(addAssignmentInitValueVector_949,axiom,
    ( v25661(constB0)
  <=> $false ) ).

fof(addAssignment_11199,axiom,
    ! [VarCurr] :
      ( v25663(VarCurr)
    <=> v25665(VarCurr) ) ).

fof(addAssignment_11198,axiom,
    ! [VarCurr] :
      ( v25665(VarCurr)
    <=> v25667(VarCurr) ) ).

fof(addAssignment_11197,axiom,
    ! [VarCurr] :
      ( v25667(VarCurr)
    <=> v25669(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4475,axiom,
    ! [VarCurr] :
      ( v25669(VarCurr)
    <=> ( v25671(VarCurr)
        & v25729(VarCurr) ) ) ).

fof(writeUnaryOperator_2335,axiom,
    ! [VarCurr] :
      ( ~ v25729(VarCurr)
    <=> v25714(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_458,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25717(VarNext)
       => ( v25714(VarNext)
        <=> v25714(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_397,axiom,
    ! [VarNext] :
      ( v25717(VarNext)
     => ( v25714(VarNext)
      <=> v25725(VarNext) ) ) ).

fof(addAssignment_11196,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25725(VarNext)
      <=> v25723(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_710,axiom,
    ! [VarCurr] :
      ( ~ v1637(VarCurr)
     => ( v25723(VarCurr)
      <=> v25671(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_464,axiom,
    ! [VarCurr] :
      ( v1637(VarCurr)
     => ( v25723(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4474,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25717(VarNext)
      <=> v25718(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4473,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25718(VarNext)
      <=> ( v25720(VarNext)
          & v1623(VarNext) ) ) ) ).

fof(writeUnaryOperator_2334,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25720(VarNext)
      <=> v1630(VarNext) ) ) ).

fof(addAssignmentInitValueVector_948,axiom,
    ( v25714(constB0)
  <=> $false ) ).

fof(addCaseBooleanConditionEqualRanges1_457,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25702(VarNext)
       => ( v25671(VarNext)
        <=> v25671(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_396,axiom,
    ! [VarNext] :
      ( v25702(VarNext)
     => ( v25671(VarNext)
      <=> v25710(VarNext) ) ) ).

fof(addAssignment_11195,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25710(VarNext)
      <=> v25708(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_709,axiom,
    ! [VarCurr] :
      ( ~ v1637(VarCurr)
     => ( v25708(VarCurr)
      <=> v25673(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_463,axiom,
    ! [VarCurr] :
      ( v1637(VarCurr)
     => ( v25708(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4472,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25702(VarNext)
      <=> v25703(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4471,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25703(VarNext)
      <=> ( v25705(VarNext)
          & v1623(VarNext) ) ) ) ).

fof(writeUnaryOperator_2333,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25705(VarNext)
      <=> v1630(VarNext) ) ) ).

fof(addAssignmentInitValueVector_947,axiom,
    ( v25671(constB0)
  <=> $false ) ).

fof(addAssignment_11194,axiom,
    ! [VarCurr] :
      ( v25673(VarCurr)
    <=> v25675(VarCurr) ) ).

fof(addAssignment_11193,axiom,
    ! [VarCurr] :
      ( v25675(VarCurr)
    <=> v25677(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_456,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25690(VarNext)
       => ( v25677(VarNext)
        <=> v25677(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_395,axiom,
    ! [VarNext] :
      ( v25690(VarNext)
     => ( v25677(VarNext)
      <=> v25697(VarNext) ) ) ).

fof(addAssignment_11192,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25697(VarNext)
      <=> v25679(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4470,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25690(VarNext)
      <=> v25691(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4469,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25691(VarNext)
      <=> ( v25693(VarNext)
          & v1642(VarNext) ) ) ) ).

fof(writeUnaryOperator_2332,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25693(VarNext)
      <=> v1649(VarNext) ) ) ).

fof(addAssignmentInitValueVector_946,axiom,
    ( v25677(constB0)
  <=> $false ) ).

fof(addAssignment_11191,axiom,
    ! [VarCurr] :
      ( v25679(VarCurr)
    <=> v25681(VarCurr) ) ).

fof(addAssignment_11190,axiom,
    ! [VarCurr] :
      ( v25681(VarCurr)
    <=> v25683(VarCurr) ) ).

fof(addAssignment_11189,axiom,
    ! [VarCurr] :
      ( v25683(VarCurr)
    <=> v25685(VarCurr) ) ).

fof(addAssignment_11188,axiom,
    ! [VarCurr] :
      ( v25685(VarCurr)
    <=> v25687(VarCurr) ) ).

fof(addAssignment_11187,axiom,
    ! [VarCurr] :
      ( v25687(VarCurr)
    <=> v1547(VarCurr) ) ).

fof(addAssignment_11186,axiom,
    ! [VarCurr] :
      ( v25643(VarCurr)
    <=> v25645(VarCurr) ) ).

fof(addAssignment_11185,axiom,
    ! [VarCurr] :
      ( v25645(VarCurr)
    <=> v25647(VarCurr) ) ).

fof(addAssignment_11184,axiom,
    ! [VarCurr] :
      ( v25647(VarCurr)
    <=> v25649(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_114,axiom,
    ! [VarCurr] :
      ( ( ~ v25651(VarCurr)
        & ~ v24179(VarCurr) )
     => ( v25649(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_587,axiom,
    ! [VarCurr] :
      ( v24179(VarCurr)
     => ( v25649(VarCurr)
      <=> v24213(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_593,axiom,
    ! [VarCurr] :
      ( v25651(VarCurr)
     => ( v25649(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4468,axiom,
    ! [VarCurr] :
      ( v25651(VarCurr)
    <=> ( v24177(VarCurr)
        | v24178(VarCurr) ) ) ).

fof(addAssignment_11183,axiom,
    ! [VarCurr] :
      ( v25635(VarCurr)
    <=> v25637(VarCurr) ) ).

fof(addAssignment_11182,axiom,
    ! [VarCurr] :
      ( v25637(VarCurr)
    <=> v25639(VarCurr) ) ).

fof(addAssignment_11181,axiom,
    ! [VarCurr] :
      ( v25623(VarCurr)
    <=> v184(VarCurr,bitIndex0) ) ).

fof(addAssignment_11180,axiom,
    ! [VarCurr] :
      ( v184(VarCurr,bitIndex0)
    <=> v25625(VarCurr) ) ).

fof(addAssignment_11179,axiom,
    ! [VarCurr] :
      ( v25625(VarCurr)
    <=> v25627(VarCurr) ) ).

fof(addAssignment_11178,axiom,
    ! [VarCurr] :
      ( v25627(VarCurr)
    <=> v190(VarCurr) ) ).

fof(addAssignment_11177,axiom,
    ! [VarCurr] :
      ( v25621(VarCurr)
    <=> v85(VarCurr,bitIndex0) ) ).

fof(addAssignment_11176,axiom,
    ! [VarCurr] :
      ( v73(VarCurr)
    <=> v75(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4467,axiom,
    ! [VarCurr] :
      ( v75(VarCurr)
    <=> ( v77(VarCurr)
        & v25603(VarCurr) ) ) ).

fof(writeUnaryOperator_2331,axiom,
    ! [VarCurr] :
      ( ~ v25603(VarCurr)
    <=> v25605(VarCurr) ) ).

fof(addAssignment_11175,axiom,
    ! [VarCurr] :
      ( v25605(VarCurr)
    <=> v25607(VarCurr) ) ).

fof(addAssignment_11174,axiom,
    ! [VarCurr] :
      ( v25607(VarCurr)
    <=> v25609(VarCurr) ) ).

fof(addAssignment_11173,axiom,
    ! [VarCurr] :
      ( v25609(VarCurr)
    <=> v4912(VarCurr) ) ).

fof(addAssignment_11172,axiom,
    ! [VarCurr] :
      ( v77(VarCurr)
    <=> v79(VarCurr) ) ).

fof(addAssignment_11171,axiom,
    ! [VarCurr] :
      ( v79(VarCurr)
    <=> v81(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_708,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25584(VarNext)
       => ( v81(VarNext)
        <=> v81(VarCurr) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_462,axiom,
    ! [VarNext] :
      ( v25584(VarNext)
     => ( v81(VarNext)
      <=> v25596(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_586,axiom,
    ! [VarCurr] :
      ( ~ v25585(VarCurr)
     => ( v25596(VarCurr)
      <=> v25597(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_592,axiom,
    ! [VarCurr] :
      ( v25585(VarCurr)
     => ( v25596(VarCurr)
      <=> v148(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_585,axiom,
    ! [VarCurr] :
      ( ~ v25590(VarCurr)
     => ( v25597(VarCurr)
      <=> v168(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_591,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25590(VarCurr)
       => ( v25597(VarCurr)
        <=> x166(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4466,axiom,
    ! [VarCurr] :
      ( v25584(VarCurr)
    <=> ( v25585(VarCurr)
        | v25588(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4465,axiom,
    ! [VarCurr] :
      ( v25588(VarCurr)
    <=> ( v25589(VarCurr)
        & v25595(VarCurr) ) ) ).

fof(writeUnaryOperator_2330,axiom,
    ! [VarCurr] :
      ( ~ v25595(VarCurr)
    <=> v25585(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4464,axiom,
    ! [VarCurr] :
      ( v25589(VarCurr)
    <=> ( v25590(VarCurr)
        | v25592(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4463,axiom,
    ! [VarCurr] :
      ( v25592(VarCurr)
    <=> ( v25593(VarCurr)
        & v25594(VarCurr) ) ) ).

fof(writeUnaryOperator_2329,axiom,
    ! [VarCurr] :
      ( ~ v25594(VarCurr)
    <=> v25590(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4462,axiom,
    ! [VarCurr] :
      ( v25593(VarCurr)
    <=> ( v83(VarCurr)
        & v101(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4461,axiom,
    ! [VarCurr] :
      ( v25590(VarCurr)
    <=> ( v83(VarCurr)
        & v25591(VarCurr) ) ) ).

fof(writeUnaryOperator_2328,axiom,
    ! [VarCurr] :
      ( ~ v25591(VarCurr)
    <=> v101(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4460,axiom,
    ! [VarCurr] :
      ( v25585(VarCurr)
    <=> ( v25586(VarCurr)
        & v25587(VarCurr) ) ) ).

fof(writeUnaryOperator_2327,axiom,
    ! [VarCurr] :
      ( ~ v25587(VarCurr)
    <=> v101(VarCurr) ) ).

fof(writeUnaryOperator_2326,axiom,
    ! [VarCurr] :
      ( ~ v25586(VarCurr)
    <=> v83(VarCurr) ) ).

fof(addAssignmentInitValueVector_945,axiom,
    ( v81(constB0)
  <=> $false ) ).

fof(addAssignment_11170,axiom,
    ! [VarCurr] :
      ( v168(VarCurr)
    <=> v170(VarCurr,bitIndex29) ) ).

fof(addAssignment_11169,axiom,
    ! [VarCurr] :
      ( v170(VarCurr,bitIndex29)
    <=> v172(VarCurr) ) ).

fof(addAssignment_11168,axiom,
    ! [VarCurr] :
      ( v172(VarCurr)
    <=> v174(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_455,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25566(VarNext)
       => ( v174(VarNext)
        <=> v174(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_394,axiom,
    ! [VarNext] :
      ( v25566(VarNext)
     => ( v174(VarNext)
      <=> v25576(VarNext) ) ) ).

fof(addAssignment_11167,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25576(VarNext)
      <=> v25574(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_707,axiom,
    ! [VarCurr] :
      ( ~ v25577(VarCurr)
     => ( v25574(VarCurr)
      <=> x25528(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_461,axiom,
    ! [VarCurr] :
      ( v25577(VarCurr)
     => ( v25574(VarCurr)
      <=> v200(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4459,axiom,
    ! [VarCurr] :
      ( v25577(VarCurr)
    <=> ( v25578(VarCurr)
        & v25579(VarCurr) ) ) ).

fof(writeUnaryOperator_2325,axiom,
    ! [VarCurr] :
      ( ~ v25579(VarCurr)
    <=> v182(VarCurr) ) ).

fof(writeUnaryOperator_2324,axiom,
    ! [VarCurr] :
      ( ~ v25578(VarCurr)
    <=> v176(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4458,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25566(VarNext)
      <=> v25567(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4457,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25567(VarNext)
      <=> ( v25568(VarNext)
          & v25530(VarNext) ) ) ) ).

fof(writeUnaryOperator_2323,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25568(VarNext)
      <=> v25570(VarNext) ) ) ).

fof(addAssignment_11166,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25570(VarNext)
      <=> v25530(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_944,axiom,
    ( v174(constB0)
  <=> $false ) ).

fof(addAssignment_11165,axiom,
    ! [VarCurr] :
      ( v25530(VarCurr)
    <=> v103(VarCurr,bitIndex1) ) ).

fof(addAssignment_11164,axiom,
    ! [VarCurr] :
      ( v103(VarCurr,bitIndex1)
    <=> v25532(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4456,axiom,
    ! [VarCurr] :
      ( v25532(VarCurr)
    <=> ( v25563(VarCurr)
        | v25561(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4455,axiom,
    ! [VarCurr] :
      ( v25563(VarCurr)
    <=> ( v25534(VarCurr)
        & v25536(VarCurr) ) ) ).

fof(addAssignment_11163,axiom,
    ! [VarCurr] :
      ( v25561(VarCurr)
    <=> v136(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_454,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25545(VarNext)
       => ( v25536(VarNext)
        <=> v25536(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_393,axiom,
    ! [VarNext] :
      ( v25545(VarNext)
     => ( v25536(VarNext)
      <=> v25555(VarNext) ) ) ).

fof(addAssignment_11162,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25555(VarNext)
      <=> v25553(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4454,axiom,
    ! [VarCurr] :
      ( v25553(VarCurr)
    <=> ( v25556(VarCurr)
        & v25557(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4453,axiom,
    ! [VarCurr] :
      ( v25557(VarCurr)
    <=> ( v25540(VarCurr)
        | v25542(VarCurr) ) ) ).

fof(writeUnaryOperator_2322,axiom,
    ! [VarCurr] :
      ( ~ v25556(VarCurr)
    <=> v25538(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4452,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25545(VarNext)
      <=> v25546(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4451,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25546(VarNext)
      <=> ( v25548(VarNext)
          & v25550(VarNext) ) ) ) ).

fof(writeUnaryOperator_2321,axiom,
    ! [VarCurr] :
      ( ~ v25550(VarCurr)
    <=> v25534(VarCurr) ) ).

fof(addAssignment_11161,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25548(VarNext)
      <=> v25534(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_943,axiom,
    ( v25536(constB0)
  <=> $false ) ).

fof(addAssignment_11160,axiom,
    ! [VarCurr] :
      ( v25542(VarCurr)
    <=> v34(VarCurr) ) ).

fof(addAssignment_11159,axiom,
    ! [VarCurr] :
      ( v25540(VarCurr)
    <=> v29(VarCurr) ) ).

fof(addAssignment_11158,axiom,
    ! [VarCurr] :
      ( v25538(VarCurr)
    <=> $false ) ).

fof(addAssignment_11157,axiom,
    ! [VarCurr] :
      ( v25534(VarCurr)
    <=> v15(VarCurr) ) ).

fof(addAssignment_11156,axiom,
    ! [VarCurr] :
      ( v200(VarCurr)
    <=> v202(VarCurr,bitIndex30) ) ).

fof(addAssignment_11155,axiom,
    ! [VarCurr] :
      ( v202(VarCurr,bitIndex30)
    <=> v204(VarCurr,bitIndex30) ) ).

fof(addAssignment_11154,axiom,
    ! [VarCurr] :
      ( v204(VarCurr,bitIndex30)
    <=> v25523(VarCurr,bitIndex30) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_706,axiom,
    ! [VarCurr] :
      ( ~ v154(VarCurr)
     => ! [B] :
          ( range_59_0(B)
         => ( v25523(VarCurr,B)
          <=> v25527(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_460,axiom,
    ! [VarCurr] :
      ( v154(VarCurr)
     => ! [B] :
          ( range_59_0(B)
         => ( v25523(VarCurr,B)
          <=> v25524(VarCurr,B) ) ) ) ).

fof(range_axiom_221,axiom,
    ! [B] :
      ( range_59_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B
        | bitIndex30 = B
        | bitIndex31 = B
        | bitIndex32 = B
        | bitIndex33 = B
        | bitIndex34 = B
        | bitIndex35 = B
        | bitIndex36 = B
        | bitIndex37 = B
        | bitIndex38 = B
        | bitIndex39 = B
        | bitIndex40 = B
        | bitIndex41 = B
        | bitIndex42 = B
        | bitIndex43 = B
        | bitIndex44 = B
        | bitIndex45 = B
        | bitIndex46 = B
        | bitIndex47 = B
        | bitIndex48 = B
        | bitIndex49 = B
        | bitIndex50 = B
        | bitIndex51 = B
        | bitIndex52 = B
        | bitIndex53 = B
        | bitIndex54 = B
        | bitIndex55 = B
        | bitIndex56 = B
        | bitIndex57 = B
        | bitIndex58 = B
        | bitIndex59 = B ) ) ).

fof(addAssignment_11153,axiom,
    ! [VarCurr,B] :
      ( range_51_0(B)
     => ( v25527(VarCurr,B)
      <=> v212(VarCurr,B) ) ) ).

fof(range_axiom_220,axiom,
    ! [B] :
      ( range_51_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B
        | bitIndex30 = B
        | bitIndex31 = B
        | bitIndex32 = B
        | bitIndex33 = B
        | bitIndex34 = B
        | bitIndex35 = B
        | bitIndex36 = B
        | bitIndex37 = B
        | bitIndex38 = B
        | bitIndex39 = B
        | bitIndex40 = B
        | bitIndex41 = B
        | bitIndex42 = B
        | bitIndex43 = B
        | bitIndex44 = B
        | bitIndex45 = B
        | bitIndex46 = B
        | bitIndex47 = B
        | bitIndex48 = B
        | bitIndex49 = B
        | bitIndex50 = B
        | bitIndex51 = B ) ) ).

fof(addAssignment_11152,axiom,
    ! [VarCurr] :
      ( ( v25527(VarCurr,bitIndex59)
      <=> $false )
      & ( v25527(VarCurr,bitIndex58)
      <=> $false )
      & ( v25527(VarCurr,bitIndex57)
      <=> $false )
      & ( v25527(VarCurr,bitIndex56)
      <=> $false )
      & ( v25527(VarCurr,bitIndex55)
      <=> $false )
      & ( v25527(VarCurr,bitIndex54)
      <=> $false )
      & ( v25527(VarCurr,bitIndex53)
      <=> $false )
      & ( v25527(VarCurr,bitIndex52)
      <=> $false ) ) ).

fof(addAssignment_11151,axiom,
    ! [VarCurr,B] :
      ( range_55_0(B)
     => ( v25524(VarCurr,B)
      <=> v25525(VarCurr,B) ) ) ).

fof(range_axiom_219,axiom,
    ! [B] :
      ( range_55_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B
        | bitIndex30 = B
        | bitIndex31 = B
        | bitIndex32 = B
        | bitIndex33 = B
        | bitIndex34 = B
        | bitIndex35 = B
        | bitIndex36 = B
        | bitIndex37 = B
        | bitIndex38 = B
        | bitIndex39 = B
        | bitIndex40 = B
        | bitIndex41 = B
        | bitIndex42 = B
        | bitIndex43 = B
        | bitIndex44 = B
        | bitIndex45 = B
        | bitIndex46 = B
        | bitIndex47 = B
        | bitIndex48 = B
        | bitIndex49 = B
        | bitIndex50 = B
        | bitIndex51 = B
        | bitIndex52 = B
        | bitIndex53 = B
        | bitIndex54 = B
        | bitIndex55 = B ) ) ).

fof(addAssignment_11150,axiom,
    ! [VarCurr] :
      ( ( v25524(VarCurr,bitIndex59)
      <=> v206(VarCurr,bitIndex3) )
      & ( v25524(VarCurr,bitIndex58)
      <=> v206(VarCurr,bitIndex2) )
      & ( v25524(VarCurr,bitIndex57)
      <=> v206(VarCurr,bitIndex1) )
      & ( v25524(VarCurr,bitIndex56)
      <=> v206(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_11149,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v25525(VarCurr,B)
      <=> v25526(VarCurr,B) ) ) ).

fof(addAssignment_11148,axiom,
    ! [VarCurr] :
      ( ( v25525(VarCurr,bitIndex15)
      <=> v25526(VarCurr,bitIndex7) )
      & ( v25525(VarCurr,bitIndex14)
      <=> v25526(VarCurr,bitIndex6) )
      & ( v25525(VarCurr,bitIndex13)
      <=> v25526(VarCurr,bitIndex5) )
      & ( v25525(VarCurr,bitIndex12)
      <=> v25526(VarCurr,bitIndex4) )
      & ( v25525(VarCurr,bitIndex11)
      <=> v25526(VarCurr,bitIndex3) )
      & ( v25525(VarCurr,bitIndex10)
      <=> v25526(VarCurr,bitIndex2) )
      & ( v25525(VarCurr,bitIndex9)
      <=> v25526(VarCurr,bitIndex1) )
      & ( v25525(VarCurr,bitIndex8)
      <=> v25526(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_11147,axiom,
    ! [VarCurr] :
      ( ( v25525(VarCurr,bitIndex23)
      <=> v25526(VarCurr,bitIndex7) )
      & ( v25525(VarCurr,bitIndex22)
      <=> v25526(VarCurr,bitIndex6) )
      & ( v25525(VarCurr,bitIndex21)
      <=> v25526(VarCurr,bitIndex5) )
      & ( v25525(VarCurr,bitIndex20)
      <=> v25526(VarCurr,bitIndex4) )
      & ( v25525(VarCurr,bitIndex19)
      <=> v25526(VarCurr,bitIndex3) )
      & ( v25525(VarCurr,bitIndex18)
      <=> v25526(VarCurr,bitIndex2) )
      & ( v25525(VarCurr,bitIndex17)
      <=> v25526(VarCurr,bitIndex1) )
      & ( v25525(VarCurr,bitIndex16)
      <=> v25526(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_11146,axiom,
    ! [VarCurr] :
      ( ( v25525(VarCurr,bitIndex31)
      <=> v25526(VarCurr,bitIndex7) )
      & ( v25525(VarCurr,bitIndex30)
      <=> v25526(VarCurr,bitIndex6) )
      & ( v25525(VarCurr,bitIndex29)
      <=> v25526(VarCurr,bitIndex5) )
      & ( v25525(VarCurr,bitIndex28)
      <=> v25526(VarCurr,bitIndex4) )
      & ( v25525(VarCurr,bitIndex27)
      <=> v25526(VarCurr,bitIndex3) )
      & ( v25525(VarCurr,bitIndex26)
      <=> v25526(VarCurr,bitIndex2) )
      & ( v25525(VarCurr,bitIndex25)
      <=> v25526(VarCurr,bitIndex1) )
      & ( v25525(VarCurr,bitIndex24)
      <=> v25526(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_11145,axiom,
    ! [VarCurr] :
      ( ( v25525(VarCurr,bitIndex39)
      <=> v25526(VarCurr,bitIndex7) )
      & ( v25525(VarCurr,bitIndex38)
      <=> v25526(VarCurr,bitIndex6) )
      & ( v25525(VarCurr,bitIndex37)
      <=> v25526(VarCurr,bitIndex5) )
      & ( v25525(VarCurr,bitIndex36)
      <=> v25526(VarCurr,bitIndex4) )
      & ( v25525(VarCurr,bitIndex35)
      <=> v25526(VarCurr,bitIndex3) )
      & ( v25525(VarCurr,bitIndex34)
      <=> v25526(VarCurr,bitIndex2) )
      & ( v25525(VarCurr,bitIndex33)
      <=> v25526(VarCurr,bitIndex1) )
      & ( v25525(VarCurr,bitIndex32)
      <=> v25526(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_11144,axiom,
    ! [VarCurr] :
      ( ( v25525(VarCurr,bitIndex47)
      <=> v25526(VarCurr,bitIndex7) )
      & ( v25525(VarCurr,bitIndex46)
      <=> v25526(VarCurr,bitIndex6) )
      & ( v25525(VarCurr,bitIndex45)
      <=> v25526(VarCurr,bitIndex5) )
      & ( v25525(VarCurr,bitIndex44)
      <=> v25526(VarCurr,bitIndex4) )
      & ( v25525(VarCurr,bitIndex43)
      <=> v25526(VarCurr,bitIndex3) )
      & ( v25525(VarCurr,bitIndex42)
      <=> v25526(VarCurr,bitIndex2) )
      & ( v25525(VarCurr,bitIndex41)
      <=> v25526(VarCurr,bitIndex1) )
      & ( v25525(VarCurr,bitIndex40)
      <=> v25526(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_11143,axiom,
    ! [VarCurr] :
      ( ( v25525(VarCurr,bitIndex55)
      <=> v25526(VarCurr,bitIndex7) )
      & ( v25525(VarCurr,bitIndex54)
      <=> v25526(VarCurr,bitIndex6) )
      & ( v25525(VarCurr,bitIndex53)
      <=> v25526(VarCurr,bitIndex5) )
      & ( v25525(VarCurr,bitIndex52)
      <=> v25526(VarCurr,bitIndex4) )
      & ( v25525(VarCurr,bitIndex51)
      <=> v25526(VarCurr,bitIndex3) )
      & ( v25525(VarCurr,bitIndex50)
      <=> v25526(VarCurr,bitIndex2) )
      & ( v25525(VarCurr,bitIndex49)
      <=> v25526(VarCurr,bitIndex1) )
      & ( v25525(VarCurr,bitIndex48)
      <=> v25526(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_11142,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v25526(VarCurr,B)
      <=> v206(VarCurr,B) ) ) ).

fof(addAssignment_11141,axiom,
    ! [VarCurr] :
      ( v212(VarCurr,bitIndex30)
    <=> v25522(VarCurr,bitIndex30) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_705,axiom,
    ! [VarCurr] :
      ( ~ v214(VarCurr)
     => ! [B] :
          ( range_47_0(B)
         => ( v25522(VarCurr,B)
          <=> v25515(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_459,axiom,
    ! [VarCurr] :
      ( v214(VarCurr)
     => ! [B] :
          ( range_47_0(B)
         => ( v25522(VarCurr,B)
          <=> v25236(VarCurr,B) ) ) ) ).

fof(addAssignment_11140,axiom,
    ! [VarCurr] :
      ( v25515(VarCurr,bitIndex30)
    <=> v25517(VarCurr,bitIndex30) ) ).

fof(addAssignment_11139,axiom,
    ! [VarCurr] :
      ( v25517(VarCurr,bitIndex30)
    <=> v25519(VarCurr,bitIndex30) ) ).

fof(addAssignment_11138,axiom,
    ! [VarCurr] :
      ( v25519(VarCurr,bitIndex30)
    <=> v25521(VarCurr,bitIndex30) ) ).

fof(addAssignment_11137,axiom,
    ! [VarCurr] :
      ( v25521(VarCurr,bitIndex30)
    <=> v4847(VarCurr,bitIndex37) ) ).

fof(addAssignment_11136,axiom,
    ! [VarCurr] :
      ( v25236(VarCurr,bitIndex30)
    <=> v25238(VarCurr,bitIndex30) ) ).

fof(addAssignment_11135,axiom,
    ! [VarCurr] :
      ( v25238(VarCurr,bitIndex30)
    <=> v25240(VarCurr,bitIndex30) ) ).

fof(addAssignment_11134,axiom,
    ! [VarCurr] :
      ( v25240(VarCurr,bitIndex30)
    <=> v25242(VarCurr,bitIndex30) ) ).

fof(addAssignment_11133,axiom,
    ! [VarCurr] :
      ( v25242(VarCurr,bitIndex30)
    <=> v25504(VarCurr,bitIndex30) ) ).

fof(addParallelCaseBooleanConditionEqualRanges7_14,axiom,
    ! [VarCurr] :
      ( ( ~ v25506(VarCurr)
        & ~ v25507(VarCurr)
        & ~ v25508(VarCurr)
        & ~ v25509(VarCurr)
        & ~ v25510(VarCurr)
        & ~ v25511(VarCurr)
        & ~ v25512(VarCurr) )
     => ! [B] :
          ( range_47_0(B)
         => ( v25504(VarCurr,B)
          <=> v25244(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges6_13,axiom,
    ! [VarCurr] :
      ( v25512(VarCurr)
     => ( ( v25504(VarCurr,bitIndex47)
        <=> v25244(VarCurr,bitIndex95) )
        & ( v25504(VarCurr,bitIndex46)
        <=> v25244(VarCurr,bitIndex94) )
        & ( v25504(VarCurr,bitIndex45)
        <=> v25244(VarCurr,bitIndex93) )
        & ( v25504(VarCurr,bitIndex44)
        <=> v25244(VarCurr,bitIndex92) )
        & ( v25504(VarCurr,bitIndex43)
        <=> v25244(VarCurr,bitIndex91) )
        & ( v25504(VarCurr,bitIndex42)
        <=> v25244(VarCurr,bitIndex90) )
        & ( v25504(VarCurr,bitIndex41)
        <=> v25244(VarCurr,bitIndex89) )
        & ( v25504(VarCurr,bitIndex40)
        <=> v25244(VarCurr,bitIndex88) )
        & ( v25504(VarCurr,bitIndex39)
        <=> v25244(VarCurr,bitIndex87) )
        & ( v25504(VarCurr,bitIndex38)
        <=> v25244(VarCurr,bitIndex86) )
        & ( v25504(VarCurr,bitIndex37)
        <=> v25244(VarCurr,bitIndex85) )
        & ( v25504(VarCurr,bitIndex36)
        <=> v25244(VarCurr,bitIndex84) )
        & ( v25504(VarCurr,bitIndex35)
        <=> v25244(VarCurr,bitIndex83) )
        & ( v25504(VarCurr,bitIndex34)
        <=> v25244(VarCurr,bitIndex82) )
        & ( v25504(VarCurr,bitIndex33)
        <=> v25244(VarCurr,bitIndex81) )
        & ( v25504(VarCurr,bitIndex32)
        <=> v25244(VarCurr,bitIndex80) )
        & ( v25504(VarCurr,bitIndex31)
        <=> v25244(VarCurr,bitIndex79) )
        & ( v25504(VarCurr,bitIndex30)
        <=> v25244(VarCurr,bitIndex78) )
        & ( v25504(VarCurr,bitIndex29)
        <=> v25244(VarCurr,bitIndex77) )
        & ( v25504(VarCurr,bitIndex28)
        <=> v25244(VarCurr,bitIndex76) )
        & ( v25504(VarCurr,bitIndex27)
        <=> v25244(VarCurr,bitIndex75) )
        & ( v25504(VarCurr,bitIndex26)
        <=> v25244(VarCurr,bitIndex74) )
        & ( v25504(VarCurr,bitIndex25)
        <=> v25244(VarCurr,bitIndex73) )
        & ( v25504(VarCurr,bitIndex24)
        <=> v25244(VarCurr,bitIndex72) )
        & ( v25504(VarCurr,bitIndex23)
        <=> v25244(VarCurr,bitIndex71) )
        & ( v25504(VarCurr,bitIndex22)
        <=> v25244(VarCurr,bitIndex70) )
        & ( v25504(VarCurr,bitIndex21)
        <=> v25244(VarCurr,bitIndex69) )
        & ( v25504(VarCurr,bitIndex20)
        <=> v25244(VarCurr,bitIndex68) )
        & ( v25504(VarCurr,bitIndex19)
        <=> v25244(VarCurr,bitIndex67) )
        & ( v25504(VarCurr,bitIndex18)
        <=> v25244(VarCurr,bitIndex66) )
        & ( v25504(VarCurr,bitIndex17)
        <=> v25244(VarCurr,bitIndex65) )
        & ( v25504(VarCurr,bitIndex16)
        <=> v25244(VarCurr,bitIndex64) )
        & ( v25504(VarCurr,bitIndex15)
        <=> v25244(VarCurr,bitIndex63) )
        & ( v25504(VarCurr,bitIndex14)
        <=> v25244(VarCurr,bitIndex62) )
        & ( v25504(VarCurr,bitIndex13)
        <=> v25244(VarCurr,bitIndex61) )
        & ( v25504(VarCurr,bitIndex12)
        <=> v25244(VarCurr,bitIndex60) )
        & ( v25504(VarCurr,bitIndex11)
        <=> v25244(VarCurr,bitIndex59) )
        & ( v25504(VarCurr,bitIndex10)
        <=> v25244(VarCurr,bitIndex58) )
        & ( v25504(VarCurr,bitIndex9)
        <=> v25244(VarCurr,bitIndex57) )
        & ( v25504(VarCurr,bitIndex8)
        <=> v25244(VarCurr,bitIndex56) )
        & ( v25504(VarCurr,bitIndex7)
        <=> v25244(VarCurr,bitIndex55) )
        & ( v25504(VarCurr,bitIndex6)
        <=> v25244(VarCurr,bitIndex54) )
        & ( v25504(VarCurr,bitIndex5)
        <=> v25244(VarCurr,bitIndex53) )
        & ( v25504(VarCurr,bitIndex4)
        <=> v25244(VarCurr,bitIndex52) )
        & ( v25504(VarCurr,bitIndex3)
        <=> v25244(VarCurr,bitIndex51) )
        & ( v25504(VarCurr,bitIndex2)
        <=> v25244(VarCurr,bitIndex50) )
        & ( v25504(VarCurr,bitIndex1)
        <=> v25244(VarCurr,bitIndex49) )
        & ( v25504(VarCurr,bitIndex0)
        <=> v25244(VarCurr,bitIndex48) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges5_12,axiom,
    ! [VarCurr] :
      ( v25511(VarCurr)
     => ( ( v25504(VarCurr,bitIndex47)
        <=> v25244(VarCurr,bitIndex143) )
        & ( v25504(VarCurr,bitIndex46)
        <=> v25244(VarCurr,bitIndex142) )
        & ( v25504(VarCurr,bitIndex45)
        <=> v25244(VarCurr,bitIndex141) )
        & ( v25504(VarCurr,bitIndex44)
        <=> v25244(VarCurr,bitIndex140) )
        & ( v25504(VarCurr,bitIndex43)
        <=> v25244(VarCurr,bitIndex139) )
        & ( v25504(VarCurr,bitIndex42)
        <=> v25244(VarCurr,bitIndex138) )
        & ( v25504(VarCurr,bitIndex41)
        <=> v25244(VarCurr,bitIndex137) )
        & ( v25504(VarCurr,bitIndex40)
        <=> v25244(VarCurr,bitIndex136) )
        & ( v25504(VarCurr,bitIndex39)
        <=> v25244(VarCurr,bitIndex135) )
        & ( v25504(VarCurr,bitIndex38)
        <=> v25244(VarCurr,bitIndex134) )
        & ( v25504(VarCurr,bitIndex37)
        <=> v25244(VarCurr,bitIndex133) )
        & ( v25504(VarCurr,bitIndex36)
        <=> v25244(VarCurr,bitIndex132) )
        & ( v25504(VarCurr,bitIndex35)
        <=> v25244(VarCurr,bitIndex131) )
        & ( v25504(VarCurr,bitIndex34)
        <=> v25244(VarCurr,bitIndex130) )
        & ( v25504(VarCurr,bitIndex33)
        <=> v25244(VarCurr,bitIndex129) )
        & ( v25504(VarCurr,bitIndex32)
        <=> v25244(VarCurr,bitIndex128) )
        & ( v25504(VarCurr,bitIndex31)
        <=> v25244(VarCurr,bitIndex127) )
        & ( v25504(VarCurr,bitIndex30)
        <=> v25244(VarCurr,bitIndex126) )
        & ( v25504(VarCurr,bitIndex29)
        <=> v25244(VarCurr,bitIndex125) )
        & ( v25504(VarCurr,bitIndex28)
        <=> v25244(VarCurr,bitIndex124) )
        & ( v25504(VarCurr,bitIndex27)
        <=> v25244(VarCurr,bitIndex123) )
        & ( v25504(VarCurr,bitIndex26)
        <=> v25244(VarCurr,bitIndex122) )
        & ( v25504(VarCurr,bitIndex25)
        <=> v25244(VarCurr,bitIndex121) )
        & ( v25504(VarCurr,bitIndex24)
        <=> v25244(VarCurr,bitIndex120) )
        & ( v25504(VarCurr,bitIndex23)
        <=> v25244(VarCurr,bitIndex119) )
        & ( v25504(VarCurr,bitIndex22)
        <=> v25244(VarCurr,bitIndex118) )
        & ( v25504(VarCurr,bitIndex21)
        <=> v25244(VarCurr,bitIndex117) )
        & ( v25504(VarCurr,bitIndex20)
        <=> v25244(VarCurr,bitIndex116) )
        & ( v25504(VarCurr,bitIndex19)
        <=> v25244(VarCurr,bitIndex115) )
        & ( v25504(VarCurr,bitIndex18)
        <=> v25244(VarCurr,bitIndex114) )
        & ( v25504(VarCurr,bitIndex17)
        <=> v25244(VarCurr,bitIndex113) )
        & ( v25504(VarCurr,bitIndex16)
        <=> v25244(VarCurr,bitIndex112) )
        & ( v25504(VarCurr,bitIndex15)
        <=> v25244(VarCurr,bitIndex111) )
        & ( v25504(VarCurr,bitIndex14)
        <=> v25244(VarCurr,bitIndex110) )
        & ( v25504(VarCurr,bitIndex13)
        <=> v25244(VarCurr,bitIndex109) )
        & ( v25504(VarCurr,bitIndex12)
        <=> v25244(VarCurr,bitIndex108) )
        & ( v25504(VarCurr,bitIndex11)
        <=> v25244(VarCurr,bitIndex107) )
        & ( v25504(VarCurr,bitIndex10)
        <=> v25244(VarCurr,bitIndex106) )
        & ( v25504(VarCurr,bitIndex9)
        <=> v25244(VarCurr,bitIndex105) )
        & ( v25504(VarCurr,bitIndex8)
        <=> v25244(VarCurr,bitIndex104) )
        & ( v25504(VarCurr,bitIndex7)
        <=> v25244(VarCurr,bitIndex103) )
        & ( v25504(VarCurr,bitIndex6)
        <=> v25244(VarCurr,bitIndex102) )
        & ( v25504(VarCurr,bitIndex5)
        <=> v25244(VarCurr,bitIndex101) )
        & ( v25504(VarCurr,bitIndex4)
        <=> v25244(VarCurr,bitIndex100) )
        & ( v25504(VarCurr,bitIndex3)
        <=> v25244(VarCurr,bitIndex99) )
        & ( v25504(VarCurr,bitIndex2)
        <=> v25244(VarCurr,bitIndex98) )
        & ( v25504(VarCurr,bitIndex1)
        <=> v25244(VarCurr,bitIndex97) )
        & ( v25504(VarCurr,bitIndex0)
        <=> v25244(VarCurr,bitIndex96) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges4_14,axiom,
    ! [VarCurr] :
      ( v25510(VarCurr)
     => ( ( v25504(VarCurr,bitIndex47)
        <=> v25244(VarCurr,bitIndex191) )
        & ( v25504(VarCurr,bitIndex46)
        <=> v25244(VarCurr,bitIndex190) )
        & ( v25504(VarCurr,bitIndex45)
        <=> v25244(VarCurr,bitIndex189) )
        & ( v25504(VarCurr,bitIndex44)
        <=> v25244(VarCurr,bitIndex188) )
        & ( v25504(VarCurr,bitIndex43)
        <=> v25244(VarCurr,bitIndex187) )
        & ( v25504(VarCurr,bitIndex42)
        <=> v25244(VarCurr,bitIndex186) )
        & ( v25504(VarCurr,bitIndex41)
        <=> v25244(VarCurr,bitIndex185) )
        & ( v25504(VarCurr,bitIndex40)
        <=> v25244(VarCurr,bitIndex184) )
        & ( v25504(VarCurr,bitIndex39)
        <=> v25244(VarCurr,bitIndex183) )
        & ( v25504(VarCurr,bitIndex38)
        <=> v25244(VarCurr,bitIndex182) )
        & ( v25504(VarCurr,bitIndex37)
        <=> v25244(VarCurr,bitIndex181) )
        & ( v25504(VarCurr,bitIndex36)
        <=> v25244(VarCurr,bitIndex180) )
        & ( v25504(VarCurr,bitIndex35)
        <=> v25244(VarCurr,bitIndex179) )
        & ( v25504(VarCurr,bitIndex34)
        <=> v25244(VarCurr,bitIndex178) )
        & ( v25504(VarCurr,bitIndex33)
        <=> v25244(VarCurr,bitIndex177) )
        & ( v25504(VarCurr,bitIndex32)
        <=> v25244(VarCurr,bitIndex176) )
        & ( v25504(VarCurr,bitIndex31)
        <=> v25244(VarCurr,bitIndex175) )
        & ( v25504(VarCurr,bitIndex30)
        <=> v25244(VarCurr,bitIndex174) )
        & ( v25504(VarCurr,bitIndex29)
        <=> v25244(VarCurr,bitIndex173) )
        & ( v25504(VarCurr,bitIndex28)
        <=> v25244(VarCurr,bitIndex172) )
        & ( v25504(VarCurr,bitIndex27)
        <=> v25244(VarCurr,bitIndex171) )
        & ( v25504(VarCurr,bitIndex26)
        <=> v25244(VarCurr,bitIndex170) )
        & ( v25504(VarCurr,bitIndex25)
        <=> v25244(VarCurr,bitIndex169) )
        & ( v25504(VarCurr,bitIndex24)
        <=> v25244(VarCurr,bitIndex168) )
        & ( v25504(VarCurr,bitIndex23)
        <=> v25244(VarCurr,bitIndex167) )
        & ( v25504(VarCurr,bitIndex22)
        <=> v25244(VarCurr,bitIndex166) )
        & ( v25504(VarCurr,bitIndex21)
        <=> v25244(VarCurr,bitIndex165) )
        & ( v25504(VarCurr,bitIndex20)
        <=> v25244(VarCurr,bitIndex164) )
        & ( v25504(VarCurr,bitIndex19)
        <=> v25244(VarCurr,bitIndex163) )
        & ( v25504(VarCurr,bitIndex18)
        <=> v25244(VarCurr,bitIndex162) )
        & ( v25504(VarCurr,bitIndex17)
        <=> v25244(VarCurr,bitIndex161) )
        & ( v25504(VarCurr,bitIndex16)
        <=> v25244(VarCurr,bitIndex160) )
        & ( v25504(VarCurr,bitIndex15)
        <=> v25244(VarCurr,bitIndex159) )
        & ( v25504(VarCurr,bitIndex14)
        <=> v25244(VarCurr,bitIndex158) )
        & ( v25504(VarCurr,bitIndex13)
        <=> v25244(VarCurr,bitIndex157) )
        & ( v25504(VarCurr,bitIndex12)
        <=> v25244(VarCurr,bitIndex156) )
        & ( v25504(VarCurr,bitIndex11)
        <=> v25244(VarCurr,bitIndex155) )
        & ( v25504(VarCurr,bitIndex10)
        <=> v25244(VarCurr,bitIndex154) )
        & ( v25504(VarCurr,bitIndex9)
        <=> v25244(VarCurr,bitIndex153) )
        & ( v25504(VarCurr,bitIndex8)
        <=> v25244(VarCurr,bitIndex152) )
        & ( v25504(VarCurr,bitIndex7)
        <=> v25244(VarCurr,bitIndex151) )
        & ( v25504(VarCurr,bitIndex6)
        <=> v25244(VarCurr,bitIndex150) )
        & ( v25504(VarCurr,bitIndex5)
        <=> v25244(VarCurr,bitIndex149) )
        & ( v25504(VarCurr,bitIndex4)
        <=> v25244(VarCurr,bitIndex148) )
        & ( v25504(VarCurr,bitIndex3)
        <=> v25244(VarCurr,bitIndex147) )
        & ( v25504(VarCurr,bitIndex2)
        <=> v25244(VarCurr,bitIndex146) )
        & ( v25504(VarCurr,bitIndex1)
        <=> v25244(VarCurr,bitIndex145) )
        & ( v25504(VarCurr,bitIndex0)
        <=> v25244(VarCurr,bitIndex144) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges3_12,axiom,
    ! [VarCurr] :
      ( v25509(VarCurr)
     => ( ( v25504(VarCurr,bitIndex47)
        <=> v25244(VarCurr,bitIndex239) )
        & ( v25504(VarCurr,bitIndex46)
        <=> v25244(VarCurr,bitIndex238) )
        & ( v25504(VarCurr,bitIndex45)
        <=> v25244(VarCurr,bitIndex237) )
        & ( v25504(VarCurr,bitIndex44)
        <=> v25244(VarCurr,bitIndex236) )
        & ( v25504(VarCurr,bitIndex43)
        <=> v25244(VarCurr,bitIndex235) )
        & ( v25504(VarCurr,bitIndex42)
        <=> v25244(VarCurr,bitIndex234) )
        & ( v25504(VarCurr,bitIndex41)
        <=> v25244(VarCurr,bitIndex233) )
        & ( v25504(VarCurr,bitIndex40)
        <=> v25244(VarCurr,bitIndex232) )
        & ( v25504(VarCurr,bitIndex39)
        <=> v25244(VarCurr,bitIndex231) )
        & ( v25504(VarCurr,bitIndex38)
        <=> v25244(VarCurr,bitIndex230) )
        & ( v25504(VarCurr,bitIndex37)
        <=> v25244(VarCurr,bitIndex229) )
        & ( v25504(VarCurr,bitIndex36)
        <=> v25244(VarCurr,bitIndex228) )
        & ( v25504(VarCurr,bitIndex35)
        <=> v25244(VarCurr,bitIndex227) )
        & ( v25504(VarCurr,bitIndex34)
        <=> v25244(VarCurr,bitIndex226) )
        & ( v25504(VarCurr,bitIndex33)
        <=> v25244(VarCurr,bitIndex225) )
        & ( v25504(VarCurr,bitIndex32)
        <=> v25244(VarCurr,bitIndex224) )
        & ( v25504(VarCurr,bitIndex31)
        <=> v25244(VarCurr,bitIndex223) )
        & ( v25504(VarCurr,bitIndex30)
        <=> v25244(VarCurr,bitIndex222) )
        & ( v25504(VarCurr,bitIndex29)
        <=> v25244(VarCurr,bitIndex221) )
        & ( v25504(VarCurr,bitIndex28)
        <=> v25244(VarCurr,bitIndex220) )
        & ( v25504(VarCurr,bitIndex27)
        <=> v25244(VarCurr,bitIndex219) )
        & ( v25504(VarCurr,bitIndex26)
        <=> v25244(VarCurr,bitIndex218) )
        & ( v25504(VarCurr,bitIndex25)
        <=> v25244(VarCurr,bitIndex217) )
        & ( v25504(VarCurr,bitIndex24)
        <=> v25244(VarCurr,bitIndex216) )
        & ( v25504(VarCurr,bitIndex23)
        <=> v25244(VarCurr,bitIndex215) )
        & ( v25504(VarCurr,bitIndex22)
        <=> v25244(VarCurr,bitIndex214) )
        & ( v25504(VarCurr,bitIndex21)
        <=> v25244(VarCurr,bitIndex213) )
        & ( v25504(VarCurr,bitIndex20)
        <=> v25244(VarCurr,bitIndex212) )
        & ( v25504(VarCurr,bitIndex19)
        <=> v25244(VarCurr,bitIndex211) )
        & ( v25504(VarCurr,bitIndex18)
        <=> v25244(VarCurr,bitIndex210) )
        & ( v25504(VarCurr,bitIndex17)
        <=> v25244(VarCurr,bitIndex209) )
        & ( v25504(VarCurr,bitIndex16)
        <=> v25244(VarCurr,bitIndex208) )
        & ( v25504(VarCurr,bitIndex15)
        <=> v25244(VarCurr,bitIndex207) )
        & ( v25504(VarCurr,bitIndex14)
        <=> v25244(VarCurr,bitIndex206) )
        & ( v25504(VarCurr,bitIndex13)
        <=> v25244(VarCurr,bitIndex205) )
        & ( v25504(VarCurr,bitIndex12)
        <=> v25244(VarCurr,bitIndex204) )
        & ( v25504(VarCurr,bitIndex11)
        <=> v25244(VarCurr,bitIndex203) )
        & ( v25504(VarCurr,bitIndex10)
        <=> v25244(VarCurr,bitIndex202) )
        & ( v25504(VarCurr,bitIndex9)
        <=> v25244(VarCurr,bitIndex201) )
        & ( v25504(VarCurr,bitIndex8)
        <=> v25244(VarCurr,bitIndex200) )
        & ( v25504(VarCurr,bitIndex7)
        <=> v25244(VarCurr,bitIndex199) )
        & ( v25504(VarCurr,bitIndex6)
        <=> v25244(VarCurr,bitIndex198) )
        & ( v25504(VarCurr,bitIndex5)
        <=> v25244(VarCurr,bitIndex197) )
        & ( v25504(VarCurr,bitIndex4)
        <=> v25244(VarCurr,bitIndex196) )
        & ( v25504(VarCurr,bitIndex3)
        <=> v25244(VarCurr,bitIndex195) )
        & ( v25504(VarCurr,bitIndex2)
        <=> v25244(VarCurr,bitIndex194) )
        & ( v25504(VarCurr,bitIndex1)
        <=> v25244(VarCurr,bitIndex193) )
        & ( v25504(VarCurr,bitIndex0)
        <=> v25244(VarCurr,bitIndex192) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges2_17,axiom,
    ! [VarCurr] :
      ( v25508(VarCurr)
     => ( ( v25504(VarCurr,bitIndex47)
        <=> v25244(VarCurr,bitIndex287) )
        & ( v25504(VarCurr,bitIndex46)
        <=> v25244(VarCurr,bitIndex286) )
        & ( v25504(VarCurr,bitIndex45)
        <=> v25244(VarCurr,bitIndex285) )
        & ( v25504(VarCurr,bitIndex44)
        <=> v25244(VarCurr,bitIndex284) )
        & ( v25504(VarCurr,bitIndex43)
        <=> v25244(VarCurr,bitIndex283) )
        & ( v25504(VarCurr,bitIndex42)
        <=> v25244(VarCurr,bitIndex282) )
        & ( v25504(VarCurr,bitIndex41)
        <=> v25244(VarCurr,bitIndex281) )
        & ( v25504(VarCurr,bitIndex40)
        <=> v25244(VarCurr,bitIndex280) )
        & ( v25504(VarCurr,bitIndex39)
        <=> v25244(VarCurr,bitIndex279) )
        & ( v25504(VarCurr,bitIndex38)
        <=> v25244(VarCurr,bitIndex278) )
        & ( v25504(VarCurr,bitIndex37)
        <=> v25244(VarCurr,bitIndex277) )
        & ( v25504(VarCurr,bitIndex36)
        <=> v25244(VarCurr,bitIndex276) )
        & ( v25504(VarCurr,bitIndex35)
        <=> v25244(VarCurr,bitIndex275) )
        & ( v25504(VarCurr,bitIndex34)
        <=> v25244(VarCurr,bitIndex274) )
        & ( v25504(VarCurr,bitIndex33)
        <=> v25244(VarCurr,bitIndex273) )
        & ( v25504(VarCurr,bitIndex32)
        <=> v25244(VarCurr,bitIndex272) )
        & ( v25504(VarCurr,bitIndex31)
        <=> v25244(VarCurr,bitIndex271) )
        & ( v25504(VarCurr,bitIndex30)
        <=> v25244(VarCurr,bitIndex270) )
        & ( v25504(VarCurr,bitIndex29)
        <=> v25244(VarCurr,bitIndex269) )
        & ( v25504(VarCurr,bitIndex28)
        <=> v25244(VarCurr,bitIndex268) )
        & ( v25504(VarCurr,bitIndex27)
        <=> v25244(VarCurr,bitIndex267) )
        & ( v25504(VarCurr,bitIndex26)
        <=> v25244(VarCurr,bitIndex266) )
        & ( v25504(VarCurr,bitIndex25)
        <=> v25244(VarCurr,bitIndex265) )
        & ( v25504(VarCurr,bitIndex24)
        <=> v25244(VarCurr,bitIndex264) )
        & ( v25504(VarCurr,bitIndex23)
        <=> v25244(VarCurr,bitIndex263) )
        & ( v25504(VarCurr,bitIndex22)
        <=> v25244(VarCurr,bitIndex262) )
        & ( v25504(VarCurr,bitIndex21)
        <=> v25244(VarCurr,bitIndex261) )
        & ( v25504(VarCurr,bitIndex20)
        <=> v25244(VarCurr,bitIndex260) )
        & ( v25504(VarCurr,bitIndex19)
        <=> v25244(VarCurr,bitIndex259) )
        & ( v25504(VarCurr,bitIndex18)
        <=> v25244(VarCurr,bitIndex258) )
        & ( v25504(VarCurr,bitIndex17)
        <=> v25244(VarCurr,bitIndex257) )
        & ( v25504(VarCurr,bitIndex16)
        <=> v25244(VarCurr,bitIndex256) )
        & ( v25504(VarCurr,bitIndex15)
        <=> v25244(VarCurr,bitIndex255) )
        & ( v25504(VarCurr,bitIndex14)
        <=> v25244(VarCurr,bitIndex254) )
        & ( v25504(VarCurr,bitIndex13)
        <=> v25244(VarCurr,bitIndex253) )
        & ( v25504(VarCurr,bitIndex12)
        <=> v25244(VarCurr,bitIndex252) )
        & ( v25504(VarCurr,bitIndex11)
        <=> v25244(VarCurr,bitIndex251) )
        & ( v25504(VarCurr,bitIndex10)
        <=> v25244(VarCurr,bitIndex250) )
        & ( v25504(VarCurr,bitIndex9)
        <=> v25244(VarCurr,bitIndex249) )
        & ( v25504(VarCurr,bitIndex8)
        <=> v25244(VarCurr,bitIndex248) )
        & ( v25504(VarCurr,bitIndex7)
        <=> v25244(VarCurr,bitIndex247) )
        & ( v25504(VarCurr,bitIndex6)
        <=> v25244(VarCurr,bitIndex246) )
        & ( v25504(VarCurr,bitIndex5)
        <=> v25244(VarCurr,bitIndex245) )
        & ( v25504(VarCurr,bitIndex4)
        <=> v25244(VarCurr,bitIndex244) )
        & ( v25504(VarCurr,bitIndex3)
        <=> v25244(VarCurr,bitIndex243) )
        & ( v25504(VarCurr,bitIndex2)
        <=> v25244(VarCurr,bitIndex242) )
        & ( v25504(VarCurr,bitIndex1)
        <=> v25244(VarCurr,bitIndex241) )
        & ( v25504(VarCurr,bitIndex0)
        <=> v25244(VarCurr,bitIndex240) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges1_22,axiom,
    ! [VarCurr] :
      ( v25507(VarCurr)
     => ( ( v25504(VarCurr,bitIndex47)
        <=> v25244(VarCurr,bitIndex335) )
        & ( v25504(VarCurr,bitIndex46)
        <=> v25244(VarCurr,bitIndex334) )
        & ( v25504(VarCurr,bitIndex45)
        <=> v25244(VarCurr,bitIndex333) )
        & ( v25504(VarCurr,bitIndex44)
        <=> v25244(VarCurr,bitIndex332) )
        & ( v25504(VarCurr,bitIndex43)
        <=> v25244(VarCurr,bitIndex331) )
        & ( v25504(VarCurr,bitIndex42)
        <=> v25244(VarCurr,bitIndex330) )
        & ( v25504(VarCurr,bitIndex41)
        <=> v25244(VarCurr,bitIndex329) )
        & ( v25504(VarCurr,bitIndex40)
        <=> v25244(VarCurr,bitIndex328) )
        & ( v25504(VarCurr,bitIndex39)
        <=> v25244(VarCurr,bitIndex327) )
        & ( v25504(VarCurr,bitIndex38)
        <=> v25244(VarCurr,bitIndex326) )
        & ( v25504(VarCurr,bitIndex37)
        <=> v25244(VarCurr,bitIndex325) )
        & ( v25504(VarCurr,bitIndex36)
        <=> v25244(VarCurr,bitIndex324) )
        & ( v25504(VarCurr,bitIndex35)
        <=> v25244(VarCurr,bitIndex323) )
        & ( v25504(VarCurr,bitIndex34)
        <=> v25244(VarCurr,bitIndex322) )
        & ( v25504(VarCurr,bitIndex33)
        <=> v25244(VarCurr,bitIndex321) )
        & ( v25504(VarCurr,bitIndex32)
        <=> v25244(VarCurr,bitIndex320) )
        & ( v25504(VarCurr,bitIndex31)
        <=> v25244(VarCurr,bitIndex319) )
        & ( v25504(VarCurr,bitIndex30)
        <=> v25244(VarCurr,bitIndex318) )
        & ( v25504(VarCurr,bitIndex29)
        <=> v25244(VarCurr,bitIndex317) )
        & ( v25504(VarCurr,bitIndex28)
        <=> v25244(VarCurr,bitIndex316) )
        & ( v25504(VarCurr,bitIndex27)
        <=> v25244(VarCurr,bitIndex315) )
        & ( v25504(VarCurr,bitIndex26)
        <=> v25244(VarCurr,bitIndex314) )
        & ( v25504(VarCurr,bitIndex25)
        <=> v25244(VarCurr,bitIndex313) )
        & ( v25504(VarCurr,bitIndex24)
        <=> v25244(VarCurr,bitIndex312) )
        & ( v25504(VarCurr,bitIndex23)
        <=> v25244(VarCurr,bitIndex311) )
        & ( v25504(VarCurr,bitIndex22)
        <=> v25244(VarCurr,bitIndex310) )
        & ( v25504(VarCurr,bitIndex21)
        <=> v25244(VarCurr,bitIndex309) )
        & ( v25504(VarCurr,bitIndex20)
        <=> v25244(VarCurr,bitIndex308) )
        & ( v25504(VarCurr,bitIndex19)
        <=> v25244(VarCurr,bitIndex307) )
        & ( v25504(VarCurr,bitIndex18)
        <=> v25244(VarCurr,bitIndex306) )
        & ( v25504(VarCurr,bitIndex17)
        <=> v25244(VarCurr,bitIndex305) )
        & ( v25504(VarCurr,bitIndex16)
        <=> v25244(VarCurr,bitIndex304) )
        & ( v25504(VarCurr,bitIndex15)
        <=> v25244(VarCurr,bitIndex303) )
        & ( v25504(VarCurr,bitIndex14)
        <=> v25244(VarCurr,bitIndex302) )
        & ( v25504(VarCurr,bitIndex13)
        <=> v25244(VarCurr,bitIndex301) )
        & ( v25504(VarCurr,bitIndex12)
        <=> v25244(VarCurr,bitIndex300) )
        & ( v25504(VarCurr,bitIndex11)
        <=> v25244(VarCurr,bitIndex299) )
        & ( v25504(VarCurr,bitIndex10)
        <=> v25244(VarCurr,bitIndex298) )
        & ( v25504(VarCurr,bitIndex9)
        <=> v25244(VarCurr,bitIndex297) )
        & ( v25504(VarCurr,bitIndex8)
        <=> v25244(VarCurr,bitIndex296) )
        & ( v25504(VarCurr,bitIndex7)
        <=> v25244(VarCurr,bitIndex295) )
        & ( v25504(VarCurr,bitIndex6)
        <=> v25244(VarCurr,bitIndex294) )
        & ( v25504(VarCurr,bitIndex5)
        <=> v25244(VarCurr,bitIndex293) )
        & ( v25504(VarCurr,bitIndex4)
        <=> v25244(VarCurr,bitIndex292) )
        & ( v25504(VarCurr,bitIndex3)
        <=> v25244(VarCurr,bitIndex291) )
        & ( v25504(VarCurr,bitIndex2)
        <=> v25244(VarCurr,bitIndex290) )
        & ( v25504(VarCurr,bitIndex1)
        <=> v25244(VarCurr,bitIndex289) )
        & ( v25504(VarCurr,bitIndex0)
        <=> v25244(VarCurr,bitIndex288) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_16,axiom,
    ! [VarCurr] :
      ( v25506(VarCurr)
     => ( ( v25504(VarCurr,bitIndex47)
        <=> v25244(VarCurr,bitIndex383) )
        & ( v25504(VarCurr,bitIndex46)
        <=> v25244(VarCurr,bitIndex382) )
        & ( v25504(VarCurr,bitIndex45)
        <=> v25244(VarCurr,bitIndex381) )
        & ( v25504(VarCurr,bitIndex44)
        <=> v25244(VarCurr,bitIndex380) )
        & ( v25504(VarCurr,bitIndex43)
        <=> v25244(VarCurr,bitIndex379) )
        & ( v25504(VarCurr,bitIndex42)
        <=> v25244(VarCurr,bitIndex378) )
        & ( v25504(VarCurr,bitIndex41)
        <=> v25244(VarCurr,bitIndex377) )
        & ( v25504(VarCurr,bitIndex40)
        <=> v25244(VarCurr,bitIndex376) )
        & ( v25504(VarCurr,bitIndex39)
        <=> v25244(VarCurr,bitIndex375) )
        & ( v25504(VarCurr,bitIndex38)
        <=> v25244(VarCurr,bitIndex374) )
        & ( v25504(VarCurr,bitIndex37)
        <=> v25244(VarCurr,bitIndex373) )
        & ( v25504(VarCurr,bitIndex36)
        <=> v25244(VarCurr,bitIndex372) )
        & ( v25504(VarCurr,bitIndex35)
        <=> v25244(VarCurr,bitIndex371) )
        & ( v25504(VarCurr,bitIndex34)
        <=> v25244(VarCurr,bitIndex370) )
        & ( v25504(VarCurr,bitIndex33)
        <=> v25244(VarCurr,bitIndex369) )
        & ( v25504(VarCurr,bitIndex32)
        <=> v25244(VarCurr,bitIndex368) )
        & ( v25504(VarCurr,bitIndex31)
        <=> v25244(VarCurr,bitIndex367) )
        & ( v25504(VarCurr,bitIndex30)
        <=> v25244(VarCurr,bitIndex366) )
        & ( v25504(VarCurr,bitIndex29)
        <=> v25244(VarCurr,bitIndex365) )
        & ( v25504(VarCurr,bitIndex28)
        <=> v25244(VarCurr,bitIndex364) )
        & ( v25504(VarCurr,bitIndex27)
        <=> v25244(VarCurr,bitIndex363) )
        & ( v25504(VarCurr,bitIndex26)
        <=> v25244(VarCurr,bitIndex362) )
        & ( v25504(VarCurr,bitIndex25)
        <=> v25244(VarCurr,bitIndex361) )
        & ( v25504(VarCurr,bitIndex24)
        <=> v25244(VarCurr,bitIndex360) )
        & ( v25504(VarCurr,bitIndex23)
        <=> v25244(VarCurr,bitIndex359) )
        & ( v25504(VarCurr,bitIndex22)
        <=> v25244(VarCurr,bitIndex358) )
        & ( v25504(VarCurr,bitIndex21)
        <=> v25244(VarCurr,bitIndex357) )
        & ( v25504(VarCurr,bitIndex20)
        <=> v25244(VarCurr,bitIndex356) )
        & ( v25504(VarCurr,bitIndex19)
        <=> v25244(VarCurr,bitIndex355) )
        & ( v25504(VarCurr,bitIndex18)
        <=> v25244(VarCurr,bitIndex354) )
        & ( v25504(VarCurr,bitIndex17)
        <=> v25244(VarCurr,bitIndex353) )
        & ( v25504(VarCurr,bitIndex16)
        <=> v25244(VarCurr,bitIndex352) )
        & ( v25504(VarCurr,bitIndex15)
        <=> v25244(VarCurr,bitIndex351) )
        & ( v25504(VarCurr,bitIndex14)
        <=> v25244(VarCurr,bitIndex350) )
        & ( v25504(VarCurr,bitIndex13)
        <=> v25244(VarCurr,bitIndex349) )
        & ( v25504(VarCurr,bitIndex12)
        <=> v25244(VarCurr,bitIndex348) )
        & ( v25504(VarCurr,bitIndex11)
        <=> v25244(VarCurr,bitIndex347) )
        & ( v25504(VarCurr,bitIndex10)
        <=> v25244(VarCurr,bitIndex346) )
        & ( v25504(VarCurr,bitIndex9)
        <=> v25244(VarCurr,bitIndex345) )
        & ( v25504(VarCurr,bitIndex8)
        <=> v25244(VarCurr,bitIndex344) )
        & ( v25504(VarCurr,bitIndex7)
        <=> v25244(VarCurr,bitIndex343) )
        & ( v25504(VarCurr,bitIndex6)
        <=> v25244(VarCurr,bitIndex342) )
        & ( v25504(VarCurr,bitIndex5)
        <=> v25244(VarCurr,bitIndex341) )
        & ( v25504(VarCurr,bitIndex4)
        <=> v25244(VarCurr,bitIndex340) )
        & ( v25504(VarCurr,bitIndex3)
        <=> v25244(VarCurr,bitIndex339) )
        & ( v25504(VarCurr,bitIndex2)
        <=> v25244(VarCurr,bitIndex338) )
        & ( v25504(VarCurr,bitIndex1)
        <=> v25244(VarCurr,bitIndex337) )
        & ( v25504(VarCurr,bitIndex0)
        <=> v25244(VarCurr,bitIndex336) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_2202,axiom,
    ! [VarCurr] :
      ( v25513(VarCurr)
    <=> ( ( v25414(VarCurr,bitIndex2)
        <=> $true )
        & ( v25414(VarCurr,bitIndex1)
        <=> $true )
        & ( v25414(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_2201,axiom,
    ! [VarCurr] :
      ( v25512(VarCurr)
    <=> ( ( v25414(VarCurr,bitIndex2)
        <=> $true )
        & ( v25414(VarCurr,bitIndex1)
        <=> $true )
        & ( v25414(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_2200,axiom,
    ! [VarCurr] :
      ( v25511(VarCurr)
    <=> ( ( v25414(VarCurr,bitIndex2)
        <=> $true )
        & ( v25414(VarCurr,bitIndex1)
        <=> $false )
        & ( v25414(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_2199,axiom,
    ! [VarCurr] :
      ( v25510(VarCurr)
    <=> ( ( v25414(VarCurr,bitIndex2)
        <=> $true )
        & ( v25414(VarCurr,bitIndex1)
        <=> $false )
        & ( v25414(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_2198,axiom,
    ! [VarCurr] :
      ( v25509(VarCurr)
    <=> ( ( v25414(VarCurr,bitIndex2)
        <=> $false )
        & ( v25414(VarCurr,bitIndex1)
        <=> $true )
        & ( v25414(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_2197,axiom,
    ! [VarCurr] :
      ( v25508(VarCurr)
    <=> ( ( v25414(VarCurr,bitIndex2)
        <=> $false )
        & ( v25414(VarCurr,bitIndex1)
        <=> $true )
        & ( v25414(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_2196,axiom,
    ! [VarCurr] :
      ( v25507(VarCurr)
    <=> ( ( v25414(VarCurr,bitIndex2)
        <=> $false )
        & ( v25414(VarCurr,bitIndex1)
        <=> $false )
        & ( v25414(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_2195,axiom,
    ! [VarCurr] :
      ( v25506(VarCurr)
    <=> ( ( v25414(VarCurr,bitIndex2)
        <=> $false )
        & ( v25414(VarCurr,bitIndex1)
        <=> $false )
        & ( v25414(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_704,axiom,
    ! [VarCurr] :
      ( ~ v25416(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v25414(VarCurr,B)
          <=> v25443(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_458,axiom,
    ! [VarCurr] :
      ( v25416(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v25414(VarCurr,B)
          <=> v25426(VarCurr,B) ) ) ) ).

fof(addAssignment_11132,axiom,
    ! [VarNext,B] :
      ( range_2_0(B)
     => ( v25443(VarNext,B)
      <=> v25486(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_453,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25487(VarNext)
       => ! [B] :
            ( range_8_0(B)
           => ( v25486(VarNext,B)
            <=> v25443(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_392,axiom,
    ! [VarNext] :
      ( v25487(VarNext)
     => ! [B] :
          ( range_8_0(B)
         => ( v25486(VarNext,B)
          <=> v25500(VarNext,B) ) ) ) ).

fof(addAssignment_11131,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_8_0(B)
         => ( v25500(VarNext,B)
          <=> v25498(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_584,axiom,
    ! [VarCurr] :
      ( ~ v8598(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v25498(VarCurr,B)
          <=> v25445(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_590,axiom,
    ! [VarCurr] :
      ( v8598(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v25498(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4450,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25487(VarNext)
      <=> ( v25488(VarNext)
          & v25495(VarNext) ) ) ) ).

fof(addAssignment_11130,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25495(VarNext)
      <=> v25493(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4449,axiom,
    ! [VarCurr] :
      ( v25493(VarCurr)
    <=> ( v8598(VarCurr)
        | v25496(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4448,axiom,
    ! [VarCurr] :
      ( v25496(VarCurr)
    <=> ( v8600(VarCurr)
        & v25497(VarCurr) ) ) ).

fof(writeUnaryOperator_2320,axiom,
    ! [VarCurr] :
      ( ~ v25497(VarCurr)
    <=> v8598(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4447,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25488(VarNext)
      <=> ( v25490(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2319,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25490(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignmentInitValueVector_942,axiom,
    ! [B] :
      ( range_8_0(B)
     => ( v25443(constB0,B)
      <=> $false ) ) ).

fof(addAssignment_11129,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v25445(VarCurr,B)
      <=> v25447(VarCurr,B) ) ) ).

fof(addAssignment_11128,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v25447(VarCurr,B)
      <=> v25449(VarCurr,B) ) ) ).

fof(addAssignment_11127,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v25449(VarCurr,B)
      <=> v25451(VarCurr,B) ) ) ).

fof(addAssignment_11126,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v25451(VarCurr,B)
      <=> v25453(VarCurr,B) ) ) ).

fof(addAssignment_11125,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v25453(VarCurr,B)
      <=> v25483(VarCurr,B) ) ) ).

fof(addAssignment_11124,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v25483(VarCurr,B)
      <=> v25455(VarCurr,B) ) ) ).

fof(addAssignment_11123,axiom,
    ! [VarCurr] :
      ( ( v25483(VarCurr,bitIndex8)
      <=> v25484(VarCurr,bitIndex5) )
      & ( v25483(VarCurr,bitIndex7)
      <=> v25484(VarCurr,bitIndex4) )
      & ( v25483(VarCurr,bitIndex6)
      <=> v25484(VarCurr,bitIndex3) )
      & ( v25483(VarCurr,bitIndex5)
      <=> v25484(VarCurr,bitIndex2) )
      & ( v25483(VarCurr,bitIndex4)
      <=> v25484(VarCurr,bitIndex1) )
      & ( v25483(VarCurr,bitIndex3)
      <=> v25484(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_11122,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v25455(VarCurr,B)
      <=> v25457(VarCurr,B) ) ) ).

fof(addAssignment_11121,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v25457(VarCurr,B)
      <=> v25459(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_703,axiom,
    ! [VarCurr] :
      ( ~ v25481(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v25459(VarCurr,B)
          <=> v25469(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_457,axiom,
    ! [VarCurr] :
      ( v25481(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v25459(VarCurr,B)
          <=> v25482(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_546,axiom,
    ! [VarCurr] :
      ( ~ v4328(VarCurr)
     => ( ( v25482(VarCurr,bitIndex2)
        <=> v4813(VarCurr,bitIndex13) )
        & ( v25482(VarCurr,bitIndex1)
        <=> v4813(VarCurr,bitIndex12) )
        & ( v25482(VarCurr,bitIndex0)
        <=> v4813(VarCurr,bitIndex11) ) ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_792,axiom,
    ! [VarCurr] :
      ( v4328(VarCurr)
     => ( ( v25482(VarCurr,bitIndex2)
        <=> v4813(VarCurr,bitIndex16) )
        & ( v25482(VarCurr,bitIndex1)
        <=> v4813(VarCurr,bitIndex15) )
        & ( v25482(VarCurr,bitIndex0)
        <=> v4813(VarCurr,bitIndex14) ) ) ) ).

fof(writeUnaryOperator_2318,axiom,
    ! [VarCurr] :
      ( ~ v25481(VarCurr)
    <=> v4193(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges7_13,axiom,
    ! [VarCurr] :
      ( ( ~ v25471(VarCurr)
        & ~ v25472(VarCurr)
        & ~ v25473(VarCurr)
        & ~ v25474(VarCurr)
        & ~ v25475(VarCurr)
        & ~ v25476(VarCurr)
        & ~ v25477(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v25469(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges6_15,axiom,
    ! [VarCurr] :
      ( v25477(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v25469(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges5_11,axiom,
    ! [VarCurr] :
      ( v25476(VarCurr)
     => ( ( v25469(VarCurr,bitIndex2)
        <=> v4813(VarCurr,bitIndex28) )
        & ( v25469(VarCurr,bitIndex1)
        <=> v4813(VarCurr,bitIndex27) )
        & ( v25469(VarCurr,bitIndex0)
        <=> v4813(VarCurr,bitIndex26) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_16,axiom,
    ! [VarCurr] :
      ( v25475(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v25469(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges3_11,axiom,
    ! [VarCurr] :
      ( v25474(VarCurr)
     => ( ( v25469(VarCurr,bitIndex2)
        <=> v4813(VarCurr,bitIndex22) )
        & ( v25469(VarCurr,bitIndex1)
        <=> v4813(VarCurr,bitIndex21) )
        & ( v25469(VarCurr,bitIndex0)
        <=> v4813(VarCurr,bitIndex20) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_113,axiom,
    ! [VarCurr] :
      ( v25473(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v25469(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges1_21,axiom,
    ! [VarCurr] :
      ( v25472(VarCurr)
     => ( ( v25469(VarCurr,bitIndex2)
        <=> v4813(VarCurr,bitIndex16) )
        & ( v25469(VarCurr,bitIndex1)
        <=> v4813(VarCurr,bitIndex15) )
        & ( v25469(VarCurr,bitIndex0)
        <=> v4813(VarCurr,bitIndex14) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_15,axiom,
    ! [VarCurr] :
      ( v25471(VarCurr)
     => ( ( v25469(VarCurr,bitIndex2)
        <=> v4813(VarCurr,bitIndex13) )
        & ( v25469(VarCurr,bitIndex1)
        <=> v4813(VarCurr,bitIndex12) )
        & ( v25469(VarCurr,bitIndex0)
        <=> v4813(VarCurr,bitIndex11) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4446,axiom,
    ! [VarCurr] :
      ( v25477(VarCurr)
    <=> ( v25478(VarCurr)
        | v25479(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_2194,axiom,
    ! [VarCurr] :
      ( v25479(VarCurr)
    <=> ( ( v8676(VarCurr,bitIndex2)
        <=> $true )
        & ( v8676(VarCurr,bitIndex1)
        <=> $true )
        & ( v8676(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_2193,axiom,
    ! [VarCurr] :
      ( v25478(VarCurr)
    <=> ( ( v8676(VarCurr,bitIndex2)
        <=> $true )
        & ( v8676(VarCurr,bitIndex1)
        <=> $true )
        & ( v8676(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_2192,axiom,
    ! [VarCurr] :
      ( v25476(VarCurr)
    <=> ( ( v8676(VarCurr,bitIndex2)
        <=> $true )
        & ( v8676(VarCurr,bitIndex1)
        <=> $false )
        & ( v8676(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_2191,axiom,
    ! [VarCurr] :
      ( v25475(VarCurr)
    <=> ( ( v8676(VarCurr,bitIndex2)
        <=> $true )
        & ( v8676(VarCurr,bitIndex1)
        <=> $false )
        & ( v8676(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_2190,axiom,
    ! [VarCurr] :
      ( v25474(VarCurr)
    <=> ( ( v8676(VarCurr,bitIndex2)
        <=> $false )
        & ( v8676(VarCurr,bitIndex1)
        <=> $true )
        & ( v8676(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_2189,axiom,
    ! [VarCurr] :
      ( v25473(VarCurr)
    <=> ( ( v8676(VarCurr,bitIndex2)
        <=> $false )
        & ( v8676(VarCurr,bitIndex1)
        <=> $true )
        & ( v8676(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_2188,axiom,
    ! [VarCurr] :
      ( v25472(VarCurr)
    <=> ( ( v8676(VarCurr,bitIndex2)
        <=> $false )
        & ( v8676(VarCurr,bitIndex1)
        <=> $false )
        & ( v8676(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_2187,axiom,
    ! [VarCurr] :
      ( v25471(VarCurr)
    <=> ( ( v8676(VarCurr,bitIndex2)
        <=> $false )
        & ( v8676(VarCurr,bitIndex1)
        <=> $false )
        & ( v8676(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_11120,axiom,
    ! [VarNext,B] :
      ( range_13_11(B)
     => ( v4813(VarNext,B)
      <=> v25461(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_452,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25463(VarNext)
       => ! [B] :
            ( range_61_0(B)
           => ( v25461(VarNext,B)
            <=> v4813(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_391,axiom,
    ! [VarNext] :
      ( v25463(VarNext)
     => ! [B] :
          ( range_61_0(B)
         => ( v25461(VarNext,B)
          <=> v7291(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4445,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25463(VarNext)
      <=> ( v25464(VarNext)
          & v7284(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4444,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25464(VarNext)
      <=> ( v25466(VarNext)
          & v7271(VarNext) ) ) ) ).

fof(writeUnaryOperator_2317,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25466(VarNext)
      <=> v7278(VarNext) ) ) ).

fof(addAssignment_11119,axiom,
    ! [VarCurr,B] :
      ( range_13_11(B)
     => ( v4826(VarCurr,B)
      <=> v4197(VarCurr,B) ) ) ).

fof(addAssignment_11118,axiom,
    ! [VarCurr,B] :
      ( range_13_11(B)
     => ( v4197(VarCurr,B)
      <=> v4199(VarCurr,B) ) ) ).

fof(addAssignment_11117,axiom,
    ! [VarCurr,B] :
      ( range_13_11(B)
     => ( v4199(VarCurr,B)
      <=> v4201(VarCurr,B) ) ) ).

fof(addAssignment_11116,axiom,
    ! [VarCurr,B] :
      ( range_13_11(B)
     => ( v4201(VarCurr,B)
      <=> v4210(VarCurr,B) ) ) ).

fof(range_axiom_218,axiom,
    ! [B] :
      ( range_13_11(B)
    <=> ( $false
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B ) ) ).

fof(addAssignment_11115,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v4214(VarCurr,B)
      <=> v7257(VarCurr,B) ) ) ).

fof(addAssignment_11114,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v25426(VarCurr,B)
      <=> v25428(VarCurr,B) ) ) ).

fof(addAssignment_11113,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v25428(VarCurr,B)
      <=> v25430(VarCurr,B) ) ) ).

fof(addAssignment_11112,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v25430(VarCurr,B)
      <=> v25432(VarCurr,B) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges7_12,axiom,
    ! [VarCurr] :
      ( ( ~ v25434(VarCurr)
        & ~ v25435(VarCurr)
        & ~ v25436(VarCurr)
        & ~ v25437(VarCurr)
        & ~ v25438(VarCurr)
        & ~ v25439(VarCurr)
        & ~ v25440(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v25432(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges6_14,axiom,
    ! [VarCurr] :
      ( v25440(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v25432(VarCurr,B)
          <=> b110(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges5_18,axiom,
    ! [VarCurr] :
      ( v25439(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v25432(VarCurr,B)
          <=> b101(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_15,axiom,
    ! [VarCurr] :
      ( v25438(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v25432(VarCurr,B)
          <=> b100(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_47,axiom,
    ! [VarCurr] :
      ( v25437(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v25432(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_112,axiom,
    ! [VarCurr] :
      ( v25436(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v25432(VarCurr,B)
          <=> b100(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_583,axiom,
    ! [VarCurr] :
      ( v25435(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v25432(VarCurr,B)
          <=> b101(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_589,axiom,
    ! [VarCurr] :
      ( v25434(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v25432(VarCurr,B)
          <=> b110(B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_2186,axiom,
    ! [VarCurr] :
      ( v25441(VarCurr)
    <=> ( ( v24172(VarCurr,bitIndex2)
        <=> $true )
        & ( v24172(VarCurr,bitIndex1)
        <=> $true )
        & ( v24172(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_2185,axiom,
    ! [VarCurr] :
      ( v25440(VarCurr)
    <=> ( ( v24172(VarCurr,bitIndex2)
        <=> $true )
        & ( v24172(VarCurr,bitIndex1)
        <=> $true )
        & ( v24172(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_2184,axiom,
    ! [VarCurr] :
      ( v25439(VarCurr)
    <=> ( ( v24172(VarCurr,bitIndex2)
        <=> $true )
        & ( v24172(VarCurr,bitIndex1)
        <=> $false )
        & ( v24172(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_2183,axiom,
    ! [VarCurr] :
      ( v25438(VarCurr)
    <=> ( ( v24172(VarCurr,bitIndex2)
        <=> $true )
        & ( v24172(VarCurr,bitIndex1)
        <=> $false )
        & ( v24172(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_2182,axiom,
    ! [VarCurr] :
      ( v25437(VarCurr)
    <=> ( ( v24172(VarCurr,bitIndex2)
        <=> $false )
        & ( v24172(VarCurr,bitIndex1)
        <=> $true )
        & ( v24172(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_2181,axiom,
    ! [VarCurr] :
      ( v25436(VarCurr)
    <=> ( ( v24172(VarCurr,bitIndex2)
        <=> $false )
        & ( v24172(VarCurr,bitIndex1)
        <=> $true )
        & ( v24172(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_2180,axiom,
    ! [VarCurr] :
      ( v25435(VarCurr)
    <=> ( ( v24172(VarCurr,bitIndex2)
        <=> $false )
        & ( v24172(VarCurr,bitIndex1)
        <=> $false )
        & ( v24172(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_2179,axiom,
    ! [VarCurr] :
      ( v25434(VarCurr)
    <=> ( ( v24172(VarCurr,bitIndex2)
        <=> $false )
        & ( v24172(VarCurr,bitIndex1)
        <=> $false )
        & ( v24172(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_11111,axiom,
    ! [VarCurr] :
      ( v25416(VarCurr)
    <=> v25418(VarCurr) ) ).

fof(addAssignment_11110,axiom,
    ! [VarCurr] :
      ( v25418(VarCurr)
    <=> v25420(VarCurr) ) ).

fof(addAssignment_11109,axiom,
    ! [VarCurr] :
      ( v25420(VarCurr)
    <=> v25422(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_111,axiom,
    ! [VarCurr] :
      ( ( ~ v25424(VarCurr)
        & ~ v24179(VarCurr) )
     => ( v25422(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_582,axiom,
    ! [VarCurr] :
      ( v24179(VarCurr)
     => ( v25422(VarCurr)
      <=> v24213(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_588,axiom,
    ! [VarCurr] :
      ( v25424(VarCurr)
     => ( v25422(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4443,axiom,
    ! [VarCurr] :
      ( v25424(VarCurr)
    <=> ( v24177(VarCurr)
        | v24178(VarCurr) ) ) ).

fof(addAssignment_11108,axiom,
    ! [VarNext] :
      ( v25244(VarNext,bitIndex366)
    <=> v25396(VarNext,bitIndex30) ) ).

fof(addCaseBooleanConditionShiftedRanges1_6,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25397(VarNext)
       => ( ( v25396(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex383) )
          & ( v25396(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex382) )
          & ( v25396(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex381) )
          & ( v25396(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex380) )
          & ( v25396(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex379) )
          & ( v25396(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex378) )
          & ( v25396(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex377) )
          & ( v25396(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex376) )
          & ( v25396(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex375) )
          & ( v25396(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex374) )
          & ( v25396(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex373) )
          & ( v25396(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex372) )
          & ( v25396(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex371) )
          & ( v25396(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex370) )
          & ( v25396(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex369) )
          & ( v25396(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex368) )
          & ( v25396(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex367) )
          & ( v25396(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex366) )
          & ( v25396(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex365) )
          & ( v25396(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex364) )
          & ( v25396(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex363) )
          & ( v25396(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex362) )
          & ( v25396(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex361) )
          & ( v25396(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex360) )
          & ( v25396(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex359) )
          & ( v25396(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex358) )
          & ( v25396(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex357) )
          & ( v25396(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex356) )
          & ( v25396(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex355) )
          & ( v25396(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex354) )
          & ( v25396(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex353) )
          & ( v25396(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex352) )
          & ( v25396(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex351) )
          & ( v25396(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex350) )
          & ( v25396(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex349) )
          & ( v25396(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex348) )
          & ( v25396(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex347) )
          & ( v25396(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex346) )
          & ( v25396(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex345) )
          & ( v25396(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex344) )
          & ( v25396(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex343) )
          & ( v25396(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex342) )
          & ( v25396(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex341) )
          & ( v25396(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex340) )
          & ( v25396(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex339) )
          & ( v25396(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex338) )
          & ( v25396(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex337) )
          & ( v25396(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex336) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_390,axiom,
    ! [VarNext] :
      ( v25397(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v25396(VarNext,B)
          <=> v25410(VarNext,B) ) ) ) ).

fof(addAssignment_11107,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v25410(VarNext,B)
          <=> v25408(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges1_20,axiom,
    ! [VarCurr] :
      ( ~ v25271(VarCurr)
     => ( ( v25408(VarCurr,bitIndex47)
        <=> v25244(VarCurr,bitIndex287) )
        & ( v25408(VarCurr,bitIndex46)
        <=> v25244(VarCurr,bitIndex286) )
        & ( v25408(VarCurr,bitIndex45)
        <=> v25244(VarCurr,bitIndex285) )
        & ( v25408(VarCurr,bitIndex44)
        <=> v25244(VarCurr,bitIndex284) )
        & ( v25408(VarCurr,bitIndex43)
        <=> v25244(VarCurr,bitIndex283) )
        & ( v25408(VarCurr,bitIndex42)
        <=> v25244(VarCurr,bitIndex282) )
        & ( v25408(VarCurr,bitIndex41)
        <=> v25244(VarCurr,bitIndex281) )
        & ( v25408(VarCurr,bitIndex40)
        <=> v25244(VarCurr,bitIndex280) )
        & ( v25408(VarCurr,bitIndex39)
        <=> v25244(VarCurr,bitIndex279) )
        & ( v25408(VarCurr,bitIndex38)
        <=> v25244(VarCurr,bitIndex278) )
        & ( v25408(VarCurr,bitIndex37)
        <=> v25244(VarCurr,bitIndex277) )
        & ( v25408(VarCurr,bitIndex36)
        <=> v25244(VarCurr,bitIndex276) )
        & ( v25408(VarCurr,bitIndex35)
        <=> v25244(VarCurr,bitIndex275) )
        & ( v25408(VarCurr,bitIndex34)
        <=> v25244(VarCurr,bitIndex274) )
        & ( v25408(VarCurr,bitIndex33)
        <=> v25244(VarCurr,bitIndex273) )
        & ( v25408(VarCurr,bitIndex32)
        <=> v25244(VarCurr,bitIndex272) )
        & ( v25408(VarCurr,bitIndex31)
        <=> v25244(VarCurr,bitIndex271) )
        & ( v25408(VarCurr,bitIndex30)
        <=> v25244(VarCurr,bitIndex270) )
        & ( v25408(VarCurr,bitIndex29)
        <=> v25244(VarCurr,bitIndex269) )
        & ( v25408(VarCurr,bitIndex28)
        <=> v25244(VarCurr,bitIndex268) )
        & ( v25408(VarCurr,bitIndex27)
        <=> v25244(VarCurr,bitIndex267) )
        & ( v25408(VarCurr,bitIndex26)
        <=> v25244(VarCurr,bitIndex266) )
        & ( v25408(VarCurr,bitIndex25)
        <=> v25244(VarCurr,bitIndex265) )
        & ( v25408(VarCurr,bitIndex24)
        <=> v25244(VarCurr,bitIndex264) )
        & ( v25408(VarCurr,bitIndex23)
        <=> v25244(VarCurr,bitIndex263) )
        & ( v25408(VarCurr,bitIndex22)
        <=> v25244(VarCurr,bitIndex262) )
        & ( v25408(VarCurr,bitIndex21)
        <=> v25244(VarCurr,bitIndex261) )
        & ( v25408(VarCurr,bitIndex20)
        <=> v25244(VarCurr,bitIndex260) )
        & ( v25408(VarCurr,bitIndex19)
        <=> v25244(VarCurr,bitIndex259) )
        & ( v25408(VarCurr,bitIndex18)
        <=> v25244(VarCurr,bitIndex258) )
        & ( v25408(VarCurr,bitIndex17)
        <=> v25244(VarCurr,bitIndex257) )
        & ( v25408(VarCurr,bitIndex16)
        <=> v25244(VarCurr,bitIndex256) )
        & ( v25408(VarCurr,bitIndex15)
        <=> v25244(VarCurr,bitIndex255) )
        & ( v25408(VarCurr,bitIndex14)
        <=> v25244(VarCurr,bitIndex254) )
        & ( v25408(VarCurr,bitIndex13)
        <=> v25244(VarCurr,bitIndex253) )
        & ( v25408(VarCurr,bitIndex12)
        <=> v25244(VarCurr,bitIndex252) )
        & ( v25408(VarCurr,bitIndex11)
        <=> v25244(VarCurr,bitIndex251) )
        & ( v25408(VarCurr,bitIndex10)
        <=> v25244(VarCurr,bitIndex250) )
        & ( v25408(VarCurr,bitIndex9)
        <=> v25244(VarCurr,bitIndex249) )
        & ( v25408(VarCurr,bitIndex8)
        <=> v25244(VarCurr,bitIndex248) )
        & ( v25408(VarCurr,bitIndex7)
        <=> v25244(VarCurr,bitIndex247) )
        & ( v25408(VarCurr,bitIndex6)
        <=> v25244(VarCurr,bitIndex246) )
        & ( v25408(VarCurr,bitIndex5)
        <=> v25244(VarCurr,bitIndex245) )
        & ( v25408(VarCurr,bitIndex4)
        <=> v25244(VarCurr,bitIndex244) )
        & ( v25408(VarCurr,bitIndex3)
        <=> v25244(VarCurr,bitIndex243) )
        & ( v25408(VarCurr,bitIndex2)
        <=> v25244(VarCurr,bitIndex242) )
        & ( v25408(VarCurr,bitIndex1)
        <=> v25244(VarCurr,bitIndex241) )
        & ( v25408(VarCurr,bitIndex0)
        <=> v25244(VarCurr,bitIndex240) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_587,axiom,
    ! [VarCurr] :
      ( v25271(VarCurr)
     => ! [B] :
          ( range_47_0(B)
         => ( v25408(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4442,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25397(VarNext)
      <=> ( v25398(VarNext)
          & v25405(VarNext) ) ) ) ).

fof(addAssignment_11106,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25405(VarNext)
      <=> v25403(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4441,axiom,
    ! [VarCurr] :
      ( v25403(VarCurr)
    <=> ( v25271(VarCurr)
        | v25406(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4440,axiom,
    ! [VarCurr] :
      ( v25406(VarCurr)
    <=> ( v25247(VarCurr)
        & v25407(VarCurr) ) ) ).

fof(writeUnaryOperator_2316,axiom,
    ! [VarCurr] :
      ( ~ v25407(VarCurr)
    <=> v25271(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4439,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25398(VarNext)
      <=> ( v25400(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2315,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25400(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11105,axiom,
    ! [VarNext] :
      ( v25244(VarNext,bitIndex318)
    <=> v25378(VarNext,bitIndex30) ) ).

fof(addCaseBooleanConditionShiftedRanges1_5,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25379(VarNext)
       => ( ( v25378(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex335) )
          & ( v25378(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex334) )
          & ( v25378(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex333) )
          & ( v25378(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex332) )
          & ( v25378(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex331) )
          & ( v25378(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex330) )
          & ( v25378(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex329) )
          & ( v25378(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex328) )
          & ( v25378(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex327) )
          & ( v25378(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex326) )
          & ( v25378(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex325) )
          & ( v25378(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex324) )
          & ( v25378(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex323) )
          & ( v25378(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex322) )
          & ( v25378(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex321) )
          & ( v25378(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex320) )
          & ( v25378(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex319) )
          & ( v25378(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex318) )
          & ( v25378(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex317) )
          & ( v25378(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex316) )
          & ( v25378(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex315) )
          & ( v25378(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex314) )
          & ( v25378(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex313) )
          & ( v25378(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex312) )
          & ( v25378(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex311) )
          & ( v25378(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex310) )
          & ( v25378(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex309) )
          & ( v25378(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex308) )
          & ( v25378(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex307) )
          & ( v25378(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex306) )
          & ( v25378(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex305) )
          & ( v25378(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex304) )
          & ( v25378(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex303) )
          & ( v25378(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex302) )
          & ( v25378(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex301) )
          & ( v25378(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex300) )
          & ( v25378(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex299) )
          & ( v25378(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex298) )
          & ( v25378(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex297) )
          & ( v25378(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex296) )
          & ( v25378(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex295) )
          & ( v25378(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex294) )
          & ( v25378(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex293) )
          & ( v25378(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex292) )
          & ( v25378(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex291) )
          & ( v25378(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex290) )
          & ( v25378(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex289) )
          & ( v25378(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex288) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_389,axiom,
    ! [VarNext] :
      ( v25379(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v25378(VarNext,B)
          <=> v25392(VarNext,B) ) ) ) ).

fof(addAssignment_11104,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v25392(VarNext,B)
          <=> v25390(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges1_19,axiom,
    ! [VarCurr] :
      ( ~ v25271(VarCurr)
     => ( ( v25390(VarCurr,bitIndex47)
        <=> v25244(VarCurr,bitIndex239) )
        & ( v25390(VarCurr,bitIndex46)
        <=> v25244(VarCurr,bitIndex238) )
        & ( v25390(VarCurr,bitIndex45)
        <=> v25244(VarCurr,bitIndex237) )
        & ( v25390(VarCurr,bitIndex44)
        <=> v25244(VarCurr,bitIndex236) )
        & ( v25390(VarCurr,bitIndex43)
        <=> v25244(VarCurr,bitIndex235) )
        & ( v25390(VarCurr,bitIndex42)
        <=> v25244(VarCurr,bitIndex234) )
        & ( v25390(VarCurr,bitIndex41)
        <=> v25244(VarCurr,bitIndex233) )
        & ( v25390(VarCurr,bitIndex40)
        <=> v25244(VarCurr,bitIndex232) )
        & ( v25390(VarCurr,bitIndex39)
        <=> v25244(VarCurr,bitIndex231) )
        & ( v25390(VarCurr,bitIndex38)
        <=> v25244(VarCurr,bitIndex230) )
        & ( v25390(VarCurr,bitIndex37)
        <=> v25244(VarCurr,bitIndex229) )
        & ( v25390(VarCurr,bitIndex36)
        <=> v25244(VarCurr,bitIndex228) )
        & ( v25390(VarCurr,bitIndex35)
        <=> v25244(VarCurr,bitIndex227) )
        & ( v25390(VarCurr,bitIndex34)
        <=> v25244(VarCurr,bitIndex226) )
        & ( v25390(VarCurr,bitIndex33)
        <=> v25244(VarCurr,bitIndex225) )
        & ( v25390(VarCurr,bitIndex32)
        <=> v25244(VarCurr,bitIndex224) )
        & ( v25390(VarCurr,bitIndex31)
        <=> v25244(VarCurr,bitIndex223) )
        & ( v25390(VarCurr,bitIndex30)
        <=> v25244(VarCurr,bitIndex222) )
        & ( v25390(VarCurr,bitIndex29)
        <=> v25244(VarCurr,bitIndex221) )
        & ( v25390(VarCurr,bitIndex28)
        <=> v25244(VarCurr,bitIndex220) )
        & ( v25390(VarCurr,bitIndex27)
        <=> v25244(VarCurr,bitIndex219) )
        & ( v25390(VarCurr,bitIndex26)
        <=> v25244(VarCurr,bitIndex218) )
        & ( v25390(VarCurr,bitIndex25)
        <=> v25244(VarCurr,bitIndex217) )
        & ( v25390(VarCurr,bitIndex24)
        <=> v25244(VarCurr,bitIndex216) )
        & ( v25390(VarCurr,bitIndex23)
        <=> v25244(VarCurr,bitIndex215) )
        & ( v25390(VarCurr,bitIndex22)
        <=> v25244(VarCurr,bitIndex214) )
        & ( v25390(VarCurr,bitIndex21)
        <=> v25244(VarCurr,bitIndex213) )
        & ( v25390(VarCurr,bitIndex20)
        <=> v25244(VarCurr,bitIndex212) )
        & ( v25390(VarCurr,bitIndex19)
        <=> v25244(VarCurr,bitIndex211) )
        & ( v25390(VarCurr,bitIndex18)
        <=> v25244(VarCurr,bitIndex210) )
        & ( v25390(VarCurr,bitIndex17)
        <=> v25244(VarCurr,bitIndex209) )
        & ( v25390(VarCurr,bitIndex16)
        <=> v25244(VarCurr,bitIndex208) )
        & ( v25390(VarCurr,bitIndex15)
        <=> v25244(VarCurr,bitIndex207) )
        & ( v25390(VarCurr,bitIndex14)
        <=> v25244(VarCurr,bitIndex206) )
        & ( v25390(VarCurr,bitIndex13)
        <=> v25244(VarCurr,bitIndex205) )
        & ( v25390(VarCurr,bitIndex12)
        <=> v25244(VarCurr,bitIndex204) )
        & ( v25390(VarCurr,bitIndex11)
        <=> v25244(VarCurr,bitIndex203) )
        & ( v25390(VarCurr,bitIndex10)
        <=> v25244(VarCurr,bitIndex202) )
        & ( v25390(VarCurr,bitIndex9)
        <=> v25244(VarCurr,bitIndex201) )
        & ( v25390(VarCurr,bitIndex8)
        <=> v25244(VarCurr,bitIndex200) )
        & ( v25390(VarCurr,bitIndex7)
        <=> v25244(VarCurr,bitIndex199) )
        & ( v25390(VarCurr,bitIndex6)
        <=> v25244(VarCurr,bitIndex198) )
        & ( v25390(VarCurr,bitIndex5)
        <=> v25244(VarCurr,bitIndex197) )
        & ( v25390(VarCurr,bitIndex4)
        <=> v25244(VarCurr,bitIndex196) )
        & ( v25390(VarCurr,bitIndex3)
        <=> v25244(VarCurr,bitIndex195) )
        & ( v25390(VarCurr,bitIndex2)
        <=> v25244(VarCurr,bitIndex194) )
        & ( v25390(VarCurr,bitIndex1)
        <=> v25244(VarCurr,bitIndex193) )
        & ( v25390(VarCurr,bitIndex0)
        <=> v25244(VarCurr,bitIndex192) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_586,axiom,
    ! [VarCurr] :
      ( v25271(VarCurr)
     => ! [B] :
          ( range_47_0(B)
         => ( v25390(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4438,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25379(VarNext)
      <=> ( v25380(VarNext)
          & v25387(VarNext) ) ) ) ).

fof(addAssignment_11103,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25387(VarNext)
      <=> v25385(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4437,axiom,
    ! [VarCurr] :
      ( v25385(VarCurr)
    <=> ( v25271(VarCurr)
        | v25388(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4436,axiom,
    ! [VarCurr] :
      ( v25388(VarCurr)
    <=> ( v25247(VarCurr)
        & v25389(VarCurr) ) ) ).

fof(writeUnaryOperator_2314,axiom,
    ! [VarCurr] :
      ( ~ v25389(VarCurr)
    <=> v25271(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4435,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25380(VarNext)
      <=> ( v25382(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2313,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25382(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11102,axiom,
    ! [VarNext] :
      ( v25244(VarNext,bitIndex270)
    <=> v25360(VarNext,bitIndex30) ) ).

fof(addCaseBooleanConditionShiftedRanges1_4,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25361(VarNext)
       => ( ( v25360(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex287) )
          & ( v25360(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex286) )
          & ( v25360(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex285) )
          & ( v25360(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex284) )
          & ( v25360(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex283) )
          & ( v25360(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex282) )
          & ( v25360(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex281) )
          & ( v25360(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex280) )
          & ( v25360(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex279) )
          & ( v25360(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex278) )
          & ( v25360(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex277) )
          & ( v25360(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex276) )
          & ( v25360(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex275) )
          & ( v25360(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex274) )
          & ( v25360(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex273) )
          & ( v25360(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex272) )
          & ( v25360(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex271) )
          & ( v25360(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex270) )
          & ( v25360(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex269) )
          & ( v25360(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex268) )
          & ( v25360(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex267) )
          & ( v25360(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex266) )
          & ( v25360(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex265) )
          & ( v25360(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex264) )
          & ( v25360(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex263) )
          & ( v25360(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex262) )
          & ( v25360(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex261) )
          & ( v25360(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex260) )
          & ( v25360(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex259) )
          & ( v25360(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex258) )
          & ( v25360(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex257) )
          & ( v25360(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex256) )
          & ( v25360(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex255) )
          & ( v25360(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex254) )
          & ( v25360(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex253) )
          & ( v25360(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex252) )
          & ( v25360(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex251) )
          & ( v25360(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex250) )
          & ( v25360(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex249) )
          & ( v25360(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex248) )
          & ( v25360(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex247) )
          & ( v25360(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex246) )
          & ( v25360(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex245) )
          & ( v25360(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex244) )
          & ( v25360(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex243) )
          & ( v25360(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex242) )
          & ( v25360(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex241) )
          & ( v25360(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex240) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_388,axiom,
    ! [VarNext] :
      ( v25361(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v25360(VarNext,B)
          <=> v25374(VarNext,B) ) ) ) ).

fof(addAssignment_11101,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v25374(VarNext,B)
          <=> v25372(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges1_18,axiom,
    ! [VarCurr] :
      ( ~ v25271(VarCurr)
     => ( ( v25372(VarCurr,bitIndex47)
        <=> v25244(VarCurr,bitIndex191) )
        & ( v25372(VarCurr,bitIndex46)
        <=> v25244(VarCurr,bitIndex190) )
        & ( v25372(VarCurr,bitIndex45)
        <=> v25244(VarCurr,bitIndex189) )
        & ( v25372(VarCurr,bitIndex44)
        <=> v25244(VarCurr,bitIndex188) )
        & ( v25372(VarCurr,bitIndex43)
        <=> v25244(VarCurr,bitIndex187) )
        & ( v25372(VarCurr,bitIndex42)
        <=> v25244(VarCurr,bitIndex186) )
        & ( v25372(VarCurr,bitIndex41)
        <=> v25244(VarCurr,bitIndex185) )
        & ( v25372(VarCurr,bitIndex40)
        <=> v25244(VarCurr,bitIndex184) )
        & ( v25372(VarCurr,bitIndex39)
        <=> v25244(VarCurr,bitIndex183) )
        & ( v25372(VarCurr,bitIndex38)
        <=> v25244(VarCurr,bitIndex182) )
        & ( v25372(VarCurr,bitIndex37)
        <=> v25244(VarCurr,bitIndex181) )
        & ( v25372(VarCurr,bitIndex36)
        <=> v25244(VarCurr,bitIndex180) )
        & ( v25372(VarCurr,bitIndex35)
        <=> v25244(VarCurr,bitIndex179) )
        & ( v25372(VarCurr,bitIndex34)
        <=> v25244(VarCurr,bitIndex178) )
        & ( v25372(VarCurr,bitIndex33)
        <=> v25244(VarCurr,bitIndex177) )
        & ( v25372(VarCurr,bitIndex32)
        <=> v25244(VarCurr,bitIndex176) )
        & ( v25372(VarCurr,bitIndex31)
        <=> v25244(VarCurr,bitIndex175) )
        & ( v25372(VarCurr,bitIndex30)
        <=> v25244(VarCurr,bitIndex174) )
        & ( v25372(VarCurr,bitIndex29)
        <=> v25244(VarCurr,bitIndex173) )
        & ( v25372(VarCurr,bitIndex28)
        <=> v25244(VarCurr,bitIndex172) )
        & ( v25372(VarCurr,bitIndex27)
        <=> v25244(VarCurr,bitIndex171) )
        & ( v25372(VarCurr,bitIndex26)
        <=> v25244(VarCurr,bitIndex170) )
        & ( v25372(VarCurr,bitIndex25)
        <=> v25244(VarCurr,bitIndex169) )
        & ( v25372(VarCurr,bitIndex24)
        <=> v25244(VarCurr,bitIndex168) )
        & ( v25372(VarCurr,bitIndex23)
        <=> v25244(VarCurr,bitIndex167) )
        & ( v25372(VarCurr,bitIndex22)
        <=> v25244(VarCurr,bitIndex166) )
        & ( v25372(VarCurr,bitIndex21)
        <=> v25244(VarCurr,bitIndex165) )
        & ( v25372(VarCurr,bitIndex20)
        <=> v25244(VarCurr,bitIndex164) )
        & ( v25372(VarCurr,bitIndex19)
        <=> v25244(VarCurr,bitIndex163) )
        & ( v25372(VarCurr,bitIndex18)
        <=> v25244(VarCurr,bitIndex162) )
        & ( v25372(VarCurr,bitIndex17)
        <=> v25244(VarCurr,bitIndex161) )
        & ( v25372(VarCurr,bitIndex16)
        <=> v25244(VarCurr,bitIndex160) )
        & ( v25372(VarCurr,bitIndex15)
        <=> v25244(VarCurr,bitIndex159) )
        & ( v25372(VarCurr,bitIndex14)
        <=> v25244(VarCurr,bitIndex158) )
        & ( v25372(VarCurr,bitIndex13)
        <=> v25244(VarCurr,bitIndex157) )
        & ( v25372(VarCurr,bitIndex12)
        <=> v25244(VarCurr,bitIndex156) )
        & ( v25372(VarCurr,bitIndex11)
        <=> v25244(VarCurr,bitIndex155) )
        & ( v25372(VarCurr,bitIndex10)
        <=> v25244(VarCurr,bitIndex154) )
        & ( v25372(VarCurr,bitIndex9)
        <=> v25244(VarCurr,bitIndex153) )
        & ( v25372(VarCurr,bitIndex8)
        <=> v25244(VarCurr,bitIndex152) )
        & ( v25372(VarCurr,bitIndex7)
        <=> v25244(VarCurr,bitIndex151) )
        & ( v25372(VarCurr,bitIndex6)
        <=> v25244(VarCurr,bitIndex150) )
        & ( v25372(VarCurr,bitIndex5)
        <=> v25244(VarCurr,bitIndex149) )
        & ( v25372(VarCurr,bitIndex4)
        <=> v25244(VarCurr,bitIndex148) )
        & ( v25372(VarCurr,bitIndex3)
        <=> v25244(VarCurr,bitIndex147) )
        & ( v25372(VarCurr,bitIndex2)
        <=> v25244(VarCurr,bitIndex146) )
        & ( v25372(VarCurr,bitIndex1)
        <=> v25244(VarCurr,bitIndex145) )
        & ( v25372(VarCurr,bitIndex0)
        <=> v25244(VarCurr,bitIndex144) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_585,axiom,
    ! [VarCurr] :
      ( v25271(VarCurr)
     => ! [B] :
          ( range_47_0(B)
         => ( v25372(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4434,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25361(VarNext)
      <=> ( v25362(VarNext)
          & v25369(VarNext) ) ) ) ).

fof(addAssignment_11100,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25369(VarNext)
      <=> v25367(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4433,axiom,
    ! [VarCurr] :
      ( v25367(VarCurr)
    <=> ( v25271(VarCurr)
        | v25370(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4432,axiom,
    ! [VarCurr] :
      ( v25370(VarCurr)
    <=> ( v25247(VarCurr)
        & v25371(VarCurr) ) ) ).

fof(writeUnaryOperator_2312,axiom,
    ! [VarCurr] :
      ( ~ v25371(VarCurr)
    <=> v25271(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4431,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25362(VarNext)
      <=> ( v25364(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2311,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25364(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11099,axiom,
    ! [VarNext] :
      ( v25244(VarNext,bitIndex222)
    <=> v25342(VarNext,bitIndex30) ) ).

fof(addCaseBooleanConditionShiftedRanges1_3,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25343(VarNext)
       => ( ( v25342(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex239) )
          & ( v25342(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex238) )
          & ( v25342(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex237) )
          & ( v25342(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex236) )
          & ( v25342(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex235) )
          & ( v25342(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex234) )
          & ( v25342(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex233) )
          & ( v25342(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex232) )
          & ( v25342(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex231) )
          & ( v25342(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex230) )
          & ( v25342(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex229) )
          & ( v25342(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex228) )
          & ( v25342(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex227) )
          & ( v25342(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex226) )
          & ( v25342(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex225) )
          & ( v25342(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex224) )
          & ( v25342(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex223) )
          & ( v25342(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex222) )
          & ( v25342(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex221) )
          & ( v25342(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex220) )
          & ( v25342(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex219) )
          & ( v25342(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex218) )
          & ( v25342(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex217) )
          & ( v25342(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex216) )
          & ( v25342(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex215) )
          & ( v25342(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex214) )
          & ( v25342(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex213) )
          & ( v25342(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex212) )
          & ( v25342(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex211) )
          & ( v25342(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex210) )
          & ( v25342(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex209) )
          & ( v25342(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex208) )
          & ( v25342(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex207) )
          & ( v25342(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex206) )
          & ( v25342(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex205) )
          & ( v25342(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex204) )
          & ( v25342(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex203) )
          & ( v25342(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex202) )
          & ( v25342(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex201) )
          & ( v25342(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex200) )
          & ( v25342(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex199) )
          & ( v25342(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex198) )
          & ( v25342(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex197) )
          & ( v25342(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex196) )
          & ( v25342(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex195) )
          & ( v25342(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex194) )
          & ( v25342(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex193) )
          & ( v25342(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex192) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_387,axiom,
    ! [VarNext] :
      ( v25343(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v25342(VarNext,B)
          <=> v25356(VarNext,B) ) ) ) ).

fof(addAssignment_11098,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v25356(VarNext,B)
          <=> v25354(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges1_17,axiom,
    ! [VarCurr] :
      ( ~ v25271(VarCurr)
     => ( ( v25354(VarCurr,bitIndex47)
        <=> v25244(VarCurr,bitIndex143) )
        & ( v25354(VarCurr,bitIndex46)
        <=> v25244(VarCurr,bitIndex142) )
        & ( v25354(VarCurr,bitIndex45)
        <=> v25244(VarCurr,bitIndex141) )
        & ( v25354(VarCurr,bitIndex44)
        <=> v25244(VarCurr,bitIndex140) )
        & ( v25354(VarCurr,bitIndex43)
        <=> v25244(VarCurr,bitIndex139) )
        & ( v25354(VarCurr,bitIndex42)
        <=> v25244(VarCurr,bitIndex138) )
        & ( v25354(VarCurr,bitIndex41)
        <=> v25244(VarCurr,bitIndex137) )
        & ( v25354(VarCurr,bitIndex40)
        <=> v25244(VarCurr,bitIndex136) )
        & ( v25354(VarCurr,bitIndex39)
        <=> v25244(VarCurr,bitIndex135) )
        & ( v25354(VarCurr,bitIndex38)
        <=> v25244(VarCurr,bitIndex134) )
        & ( v25354(VarCurr,bitIndex37)
        <=> v25244(VarCurr,bitIndex133) )
        & ( v25354(VarCurr,bitIndex36)
        <=> v25244(VarCurr,bitIndex132) )
        & ( v25354(VarCurr,bitIndex35)
        <=> v25244(VarCurr,bitIndex131) )
        & ( v25354(VarCurr,bitIndex34)
        <=> v25244(VarCurr,bitIndex130) )
        & ( v25354(VarCurr,bitIndex33)
        <=> v25244(VarCurr,bitIndex129) )
        & ( v25354(VarCurr,bitIndex32)
        <=> v25244(VarCurr,bitIndex128) )
        & ( v25354(VarCurr,bitIndex31)
        <=> v25244(VarCurr,bitIndex127) )
        & ( v25354(VarCurr,bitIndex30)
        <=> v25244(VarCurr,bitIndex126) )
        & ( v25354(VarCurr,bitIndex29)
        <=> v25244(VarCurr,bitIndex125) )
        & ( v25354(VarCurr,bitIndex28)
        <=> v25244(VarCurr,bitIndex124) )
        & ( v25354(VarCurr,bitIndex27)
        <=> v25244(VarCurr,bitIndex123) )
        & ( v25354(VarCurr,bitIndex26)
        <=> v25244(VarCurr,bitIndex122) )
        & ( v25354(VarCurr,bitIndex25)
        <=> v25244(VarCurr,bitIndex121) )
        & ( v25354(VarCurr,bitIndex24)
        <=> v25244(VarCurr,bitIndex120) )
        & ( v25354(VarCurr,bitIndex23)
        <=> v25244(VarCurr,bitIndex119) )
        & ( v25354(VarCurr,bitIndex22)
        <=> v25244(VarCurr,bitIndex118) )
        & ( v25354(VarCurr,bitIndex21)
        <=> v25244(VarCurr,bitIndex117) )
        & ( v25354(VarCurr,bitIndex20)
        <=> v25244(VarCurr,bitIndex116) )
        & ( v25354(VarCurr,bitIndex19)
        <=> v25244(VarCurr,bitIndex115) )
        & ( v25354(VarCurr,bitIndex18)
        <=> v25244(VarCurr,bitIndex114) )
        & ( v25354(VarCurr,bitIndex17)
        <=> v25244(VarCurr,bitIndex113) )
        & ( v25354(VarCurr,bitIndex16)
        <=> v25244(VarCurr,bitIndex112) )
        & ( v25354(VarCurr,bitIndex15)
        <=> v25244(VarCurr,bitIndex111) )
        & ( v25354(VarCurr,bitIndex14)
        <=> v25244(VarCurr,bitIndex110) )
        & ( v25354(VarCurr,bitIndex13)
        <=> v25244(VarCurr,bitIndex109) )
        & ( v25354(VarCurr,bitIndex12)
        <=> v25244(VarCurr,bitIndex108) )
        & ( v25354(VarCurr,bitIndex11)
        <=> v25244(VarCurr,bitIndex107) )
        & ( v25354(VarCurr,bitIndex10)
        <=> v25244(VarCurr,bitIndex106) )
        & ( v25354(VarCurr,bitIndex9)
        <=> v25244(VarCurr,bitIndex105) )
        & ( v25354(VarCurr,bitIndex8)
        <=> v25244(VarCurr,bitIndex104) )
        & ( v25354(VarCurr,bitIndex7)
        <=> v25244(VarCurr,bitIndex103) )
        & ( v25354(VarCurr,bitIndex6)
        <=> v25244(VarCurr,bitIndex102) )
        & ( v25354(VarCurr,bitIndex5)
        <=> v25244(VarCurr,bitIndex101) )
        & ( v25354(VarCurr,bitIndex4)
        <=> v25244(VarCurr,bitIndex100) )
        & ( v25354(VarCurr,bitIndex3)
        <=> v25244(VarCurr,bitIndex99) )
        & ( v25354(VarCurr,bitIndex2)
        <=> v25244(VarCurr,bitIndex98) )
        & ( v25354(VarCurr,bitIndex1)
        <=> v25244(VarCurr,bitIndex97) )
        & ( v25354(VarCurr,bitIndex0)
        <=> v25244(VarCurr,bitIndex96) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_584,axiom,
    ! [VarCurr] :
      ( v25271(VarCurr)
     => ! [B] :
          ( range_47_0(B)
         => ( v25354(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4430,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25343(VarNext)
      <=> ( v25344(VarNext)
          & v25351(VarNext) ) ) ) ).

fof(addAssignment_11097,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25351(VarNext)
      <=> v25349(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4429,axiom,
    ! [VarCurr] :
      ( v25349(VarCurr)
    <=> ( v25271(VarCurr)
        | v25352(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4428,axiom,
    ! [VarCurr] :
      ( v25352(VarCurr)
    <=> ( v25247(VarCurr)
        & v25353(VarCurr) ) ) ).

fof(writeUnaryOperator_2310,axiom,
    ! [VarCurr] :
      ( ~ v25353(VarCurr)
    <=> v25271(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4427,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25344(VarNext)
      <=> ( v25346(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2309,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25346(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11096,axiom,
    ! [VarNext] :
      ( v25244(VarNext,bitIndex174)
    <=> v25324(VarNext,bitIndex30) ) ).

fof(addCaseBooleanConditionShiftedRanges1_2,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25325(VarNext)
       => ( ( v25324(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex191) )
          & ( v25324(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex190) )
          & ( v25324(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex189) )
          & ( v25324(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex188) )
          & ( v25324(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex187) )
          & ( v25324(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex186) )
          & ( v25324(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex185) )
          & ( v25324(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex184) )
          & ( v25324(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex183) )
          & ( v25324(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex182) )
          & ( v25324(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex181) )
          & ( v25324(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex180) )
          & ( v25324(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex179) )
          & ( v25324(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex178) )
          & ( v25324(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex177) )
          & ( v25324(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex176) )
          & ( v25324(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex175) )
          & ( v25324(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex174) )
          & ( v25324(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex173) )
          & ( v25324(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex172) )
          & ( v25324(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex171) )
          & ( v25324(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex170) )
          & ( v25324(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex169) )
          & ( v25324(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex168) )
          & ( v25324(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex167) )
          & ( v25324(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex166) )
          & ( v25324(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex165) )
          & ( v25324(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex164) )
          & ( v25324(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex163) )
          & ( v25324(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex162) )
          & ( v25324(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex161) )
          & ( v25324(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex160) )
          & ( v25324(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex159) )
          & ( v25324(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex158) )
          & ( v25324(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex157) )
          & ( v25324(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex156) )
          & ( v25324(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex155) )
          & ( v25324(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex154) )
          & ( v25324(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex153) )
          & ( v25324(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex152) )
          & ( v25324(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex151) )
          & ( v25324(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex150) )
          & ( v25324(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex149) )
          & ( v25324(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex148) )
          & ( v25324(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex147) )
          & ( v25324(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex146) )
          & ( v25324(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex145) )
          & ( v25324(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex144) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_386,axiom,
    ! [VarNext] :
      ( v25325(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v25324(VarNext,B)
          <=> v25338(VarNext,B) ) ) ) ).

fof(addAssignment_11095,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v25338(VarNext,B)
          <=> v25336(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges1_16,axiom,
    ! [VarCurr] :
      ( ~ v25271(VarCurr)
     => ( ( v25336(VarCurr,bitIndex47)
        <=> v25244(VarCurr,bitIndex95) )
        & ( v25336(VarCurr,bitIndex46)
        <=> v25244(VarCurr,bitIndex94) )
        & ( v25336(VarCurr,bitIndex45)
        <=> v25244(VarCurr,bitIndex93) )
        & ( v25336(VarCurr,bitIndex44)
        <=> v25244(VarCurr,bitIndex92) )
        & ( v25336(VarCurr,bitIndex43)
        <=> v25244(VarCurr,bitIndex91) )
        & ( v25336(VarCurr,bitIndex42)
        <=> v25244(VarCurr,bitIndex90) )
        & ( v25336(VarCurr,bitIndex41)
        <=> v25244(VarCurr,bitIndex89) )
        & ( v25336(VarCurr,bitIndex40)
        <=> v25244(VarCurr,bitIndex88) )
        & ( v25336(VarCurr,bitIndex39)
        <=> v25244(VarCurr,bitIndex87) )
        & ( v25336(VarCurr,bitIndex38)
        <=> v25244(VarCurr,bitIndex86) )
        & ( v25336(VarCurr,bitIndex37)
        <=> v25244(VarCurr,bitIndex85) )
        & ( v25336(VarCurr,bitIndex36)
        <=> v25244(VarCurr,bitIndex84) )
        & ( v25336(VarCurr,bitIndex35)
        <=> v25244(VarCurr,bitIndex83) )
        & ( v25336(VarCurr,bitIndex34)
        <=> v25244(VarCurr,bitIndex82) )
        & ( v25336(VarCurr,bitIndex33)
        <=> v25244(VarCurr,bitIndex81) )
        & ( v25336(VarCurr,bitIndex32)
        <=> v25244(VarCurr,bitIndex80) )
        & ( v25336(VarCurr,bitIndex31)
        <=> v25244(VarCurr,bitIndex79) )
        & ( v25336(VarCurr,bitIndex30)
        <=> v25244(VarCurr,bitIndex78) )
        & ( v25336(VarCurr,bitIndex29)
        <=> v25244(VarCurr,bitIndex77) )
        & ( v25336(VarCurr,bitIndex28)
        <=> v25244(VarCurr,bitIndex76) )
        & ( v25336(VarCurr,bitIndex27)
        <=> v25244(VarCurr,bitIndex75) )
        & ( v25336(VarCurr,bitIndex26)
        <=> v25244(VarCurr,bitIndex74) )
        & ( v25336(VarCurr,bitIndex25)
        <=> v25244(VarCurr,bitIndex73) )
        & ( v25336(VarCurr,bitIndex24)
        <=> v25244(VarCurr,bitIndex72) )
        & ( v25336(VarCurr,bitIndex23)
        <=> v25244(VarCurr,bitIndex71) )
        & ( v25336(VarCurr,bitIndex22)
        <=> v25244(VarCurr,bitIndex70) )
        & ( v25336(VarCurr,bitIndex21)
        <=> v25244(VarCurr,bitIndex69) )
        & ( v25336(VarCurr,bitIndex20)
        <=> v25244(VarCurr,bitIndex68) )
        & ( v25336(VarCurr,bitIndex19)
        <=> v25244(VarCurr,bitIndex67) )
        & ( v25336(VarCurr,bitIndex18)
        <=> v25244(VarCurr,bitIndex66) )
        & ( v25336(VarCurr,bitIndex17)
        <=> v25244(VarCurr,bitIndex65) )
        & ( v25336(VarCurr,bitIndex16)
        <=> v25244(VarCurr,bitIndex64) )
        & ( v25336(VarCurr,bitIndex15)
        <=> v25244(VarCurr,bitIndex63) )
        & ( v25336(VarCurr,bitIndex14)
        <=> v25244(VarCurr,bitIndex62) )
        & ( v25336(VarCurr,bitIndex13)
        <=> v25244(VarCurr,bitIndex61) )
        & ( v25336(VarCurr,bitIndex12)
        <=> v25244(VarCurr,bitIndex60) )
        & ( v25336(VarCurr,bitIndex11)
        <=> v25244(VarCurr,bitIndex59) )
        & ( v25336(VarCurr,bitIndex10)
        <=> v25244(VarCurr,bitIndex58) )
        & ( v25336(VarCurr,bitIndex9)
        <=> v25244(VarCurr,bitIndex57) )
        & ( v25336(VarCurr,bitIndex8)
        <=> v25244(VarCurr,bitIndex56) )
        & ( v25336(VarCurr,bitIndex7)
        <=> v25244(VarCurr,bitIndex55) )
        & ( v25336(VarCurr,bitIndex6)
        <=> v25244(VarCurr,bitIndex54) )
        & ( v25336(VarCurr,bitIndex5)
        <=> v25244(VarCurr,bitIndex53) )
        & ( v25336(VarCurr,bitIndex4)
        <=> v25244(VarCurr,bitIndex52) )
        & ( v25336(VarCurr,bitIndex3)
        <=> v25244(VarCurr,bitIndex51) )
        & ( v25336(VarCurr,bitIndex2)
        <=> v25244(VarCurr,bitIndex50) )
        & ( v25336(VarCurr,bitIndex1)
        <=> v25244(VarCurr,bitIndex49) )
        & ( v25336(VarCurr,bitIndex0)
        <=> v25244(VarCurr,bitIndex48) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_583,axiom,
    ! [VarCurr] :
      ( v25271(VarCurr)
     => ! [B] :
          ( range_47_0(B)
         => ( v25336(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4426,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25325(VarNext)
      <=> ( v25326(VarNext)
          & v25333(VarNext) ) ) ) ).

fof(addAssignment_11094,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25333(VarNext)
      <=> v25331(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4425,axiom,
    ! [VarCurr] :
      ( v25331(VarCurr)
    <=> ( v25271(VarCurr)
        | v25334(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4424,axiom,
    ! [VarCurr] :
      ( v25334(VarCurr)
    <=> ( v25247(VarCurr)
        & v25335(VarCurr) ) ) ).

fof(writeUnaryOperator_2308,axiom,
    ! [VarCurr] :
      ( ~ v25335(VarCurr)
    <=> v25271(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4423,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25326(VarNext)
      <=> ( v25328(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2307,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25328(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11093,axiom,
    ! [VarNext] :
      ( v25244(VarNext,bitIndex126)
    <=> v25306(VarNext,bitIndex30) ) ).

fof(addCaseBooleanConditionShiftedRanges1_1,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25307(VarNext)
       => ( ( v25306(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex143) )
          & ( v25306(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex142) )
          & ( v25306(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex141) )
          & ( v25306(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex140) )
          & ( v25306(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex139) )
          & ( v25306(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex138) )
          & ( v25306(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex137) )
          & ( v25306(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex136) )
          & ( v25306(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex135) )
          & ( v25306(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex134) )
          & ( v25306(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex133) )
          & ( v25306(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex132) )
          & ( v25306(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex131) )
          & ( v25306(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex130) )
          & ( v25306(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex129) )
          & ( v25306(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex128) )
          & ( v25306(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex127) )
          & ( v25306(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex126) )
          & ( v25306(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex125) )
          & ( v25306(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex124) )
          & ( v25306(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex123) )
          & ( v25306(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex122) )
          & ( v25306(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex121) )
          & ( v25306(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex120) )
          & ( v25306(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex119) )
          & ( v25306(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex118) )
          & ( v25306(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex117) )
          & ( v25306(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex116) )
          & ( v25306(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex115) )
          & ( v25306(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex114) )
          & ( v25306(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex113) )
          & ( v25306(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex112) )
          & ( v25306(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex111) )
          & ( v25306(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex110) )
          & ( v25306(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex109) )
          & ( v25306(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex108) )
          & ( v25306(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex107) )
          & ( v25306(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex106) )
          & ( v25306(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex105) )
          & ( v25306(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex104) )
          & ( v25306(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex103) )
          & ( v25306(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex102) )
          & ( v25306(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex101) )
          & ( v25306(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex100) )
          & ( v25306(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex99) )
          & ( v25306(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex98) )
          & ( v25306(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex97) )
          & ( v25306(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex96) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_385,axiom,
    ! [VarNext] :
      ( v25307(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v25306(VarNext,B)
          <=> v25320(VarNext,B) ) ) ) ).

fof(addAssignment_11092,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v25320(VarNext,B)
          <=> v25318(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_581,axiom,
    ! [VarCurr] :
      ( ~ v25271(VarCurr)
     => ! [B] :
          ( range_47_0(B)
         => ( v25318(VarCurr,B)
          <=> v25244(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_582,axiom,
    ! [VarCurr] :
      ( v25271(VarCurr)
     => ! [B] :
          ( range_47_0(B)
         => ( v25318(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4422,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25307(VarNext)
      <=> ( v25308(VarNext)
          & v25315(VarNext) ) ) ) ).

fof(addAssignment_11091,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25315(VarNext)
      <=> v25313(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4421,axiom,
    ! [VarCurr] :
      ( v25313(VarCurr)
    <=> ( v25271(VarCurr)
        | v25316(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4420,axiom,
    ! [VarCurr] :
      ( v25316(VarCurr)
    <=> ( v25247(VarCurr)
        & v25317(VarCurr) ) ) ).

fof(writeUnaryOperator_2306,axiom,
    ! [VarCurr] :
      ( ~ v25317(VarCurr)
    <=> v25271(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4419,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25308(VarNext)
      <=> ( v25310(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2305,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25310(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11090,axiom,
    ! [VarNext] :
      ( v25244(VarNext,bitIndex78)
    <=> v25288(VarNext,bitIndex30) ) ).

fof(addCaseBooleanConditionShiftedRanges1,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25289(VarNext)
       => ( ( v25288(VarNext,bitIndex47)
          <=> v25244(VarCurr,bitIndex95) )
          & ( v25288(VarNext,bitIndex46)
          <=> v25244(VarCurr,bitIndex94) )
          & ( v25288(VarNext,bitIndex45)
          <=> v25244(VarCurr,bitIndex93) )
          & ( v25288(VarNext,bitIndex44)
          <=> v25244(VarCurr,bitIndex92) )
          & ( v25288(VarNext,bitIndex43)
          <=> v25244(VarCurr,bitIndex91) )
          & ( v25288(VarNext,bitIndex42)
          <=> v25244(VarCurr,bitIndex90) )
          & ( v25288(VarNext,bitIndex41)
          <=> v25244(VarCurr,bitIndex89) )
          & ( v25288(VarNext,bitIndex40)
          <=> v25244(VarCurr,bitIndex88) )
          & ( v25288(VarNext,bitIndex39)
          <=> v25244(VarCurr,bitIndex87) )
          & ( v25288(VarNext,bitIndex38)
          <=> v25244(VarCurr,bitIndex86) )
          & ( v25288(VarNext,bitIndex37)
          <=> v25244(VarCurr,bitIndex85) )
          & ( v25288(VarNext,bitIndex36)
          <=> v25244(VarCurr,bitIndex84) )
          & ( v25288(VarNext,bitIndex35)
          <=> v25244(VarCurr,bitIndex83) )
          & ( v25288(VarNext,bitIndex34)
          <=> v25244(VarCurr,bitIndex82) )
          & ( v25288(VarNext,bitIndex33)
          <=> v25244(VarCurr,bitIndex81) )
          & ( v25288(VarNext,bitIndex32)
          <=> v25244(VarCurr,bitIndex80) )
          & ( v25288(VarNext,bitIndex31)
          <=> v25244(VarCurr,bitIndex79) )
          & ( v25288(VarNext,bitIndex30)
          <=> v25244(VarCurr,bitIndex78) )
          & ( v25288(VarNext,bitIndex29)
          <=> v25244(VarCurr,bitIndex77) )
          & ( v25288(VarNext,bitIndex28)
          <=> v25244(VarCurr,bitIndex76) )
          & ( v25288(VarNext,bitIndex27)
          <=> v25244(VarCurr,bitIndex75) )
          & ( v25288(VarNext,bitIndex26)
          <=> v25244(VarCurr,bitIndex74) )
          & ( v25288(VarNext,bitIndex25)
          <=> v25244(VarCurr,bitIndex73) )
          & ( v25288(VarNext,bitIndex24)
          <=> v25244(VarCurr,bitIndex72) )
          & ( v25288(VarNext,bitIndex23)
          <=> v25244(VarCurr,bitIndex71) )
          & ( v25288(VarNext,bitIndex22)
          <=> v25244(VarCurr,bitIndex70) )
          & ( v25288(VarNext,bitIndex21)
          <=> v25244(VarCurr,bitIndex69) )
          & ( v25288(VarNext,bitIndex20)
          <=> v25244(VarCurr,bitIndex68) )
          & ( v25288(VarNext,bitIndex19)
          <=> v25244(VarCurr,bitIndex67) )
          & ( v25288(VarNext,bitIndex18)
          <=> v25244(VarCurr,bitIndex66) )
          & ( v25288(VarNext,bitIndex17)
          <=> v25244(VarCurr,bitIndex65) )
          & ( v25288(VarNext,bitIndex16)
          <=> v25244(VarCurr,bitIndex64) )
          & ( v25288(VarNext,bitIndex15)
          <=> v25244(VarCurr,bitIndex63) )
          & ( v25288(VarNext,bitIndex14)
          <=> v25244(VarCurr,bitIndex62) )
          & ( v25288(VarNext,bitIndex13)
          <=> v25244(VarCurr,bitIndex61) )
          & ( v25288(VarNext,bitIndex12)
          <=> v25244(VarCurr,bitIndex60) )
          & ( v25288(VarNext,bitIndex11)
          <=> v25244(VarCurr,bitIndex59) )
          & ( v25288(VarNext,bitIndex10)
          <=> v25244(VarCurr,bitIndex58) )
          & ( v25288(VarNext,bitIndex9)
          <=> v25244(VarCurr,bitIndex57) )
          & ( v25288(VarNext,bitIndex8)
          <=> v25244(VarCurr,bitIndex56) )
          & ( v25288(VarNext,bitIndex7)
          <=> v25244(VarCurr,bitIndex55) )
          & ( v25288(VarNext,bitIndex6)
          <=> v25244(VarCurr,bitIndex54) )
          & ( v25288(VarNext,bitIndex5)
          <=> v25244(VarCurr,bitIndex53) )
          & ( v25288(VarNext,bitIndex4)
          <=> v25244(VarCurr,bitIndex52) )
          & ( v25288(VarNext,bitIndex3)
          <=> v25244(VarCurr,bitIndex51) )
          & ( v25288(VarNext,bitIndex2)
          <=> v25244(VarCurr,bitIndex50) )
          & ( v25288(VarNext,bitIndex1)
          <=> v25244(VarCurr,bitIndex49) )
          & ( v25288(VarNext,bitIndex0)
          <=> v25244(VarCurr,bitIndex48) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_384,axiom,
    ! [VarNext] :
      ( v25289(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v25288(VarNext,B)
          <=> v25302(VarNext,B) ) ) ) ).

fof(addAssignment_11089,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v25302(VarNext,B)
          <=> v25300(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_580,axiom,
    ! [VarCurr] :
      ( ~ v25271(VarCurr)
     => ! [B] :
          ( range_47_0(B)
         => ( v25300(VarCurr,B)
          <=> v25280(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_581,axiom,
    ! [VarCurr] :
      ( v25271(VarCurr)
     => ! [B] :
          ( range_47_0(B)
         => ( v25300(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4418,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25289(VarNext)
      <=> ( v25290(VarNext)
          & v25297(VarNext) ) ) ) ).

fof(addAssignment_11088,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25297(VarNext)
      <=> v25295(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4417,axiom,
    ! [VarCurr] :
      ( v25295(VarCurr)
    <=> ( v25271(VarCurr)
        | v25298(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4416,axiom,
    ! [VarCurr] :
      ( v25298(VarCurr)
    <=> ( v25247(VarCurr)
        & v25299(VarCurr) ) ) ).

fof(writeUnaryOperator_2304,axiom,
    ! [VarCurr] :
      ( ~ v25299(VarCurr)
    <=> v25271(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4415,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25290(VarNext)
      <=> ( v25292(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2303,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25292(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignment_11087,axiom,
    ! [VarCurr] :
      ( v25280(VarCurr,bitIndex30)
    <=> v25282(VarCurr,bitIndex30) ) ).

fof(addAssignment_11086,axiom,
    ! [VarCurr] :
      ( v25282(VarCurr,bitIndex30)
    <=> v25284(VarCurr,bitIndex30) ) ).

fof(addAssignment_11085,axiom,
    ! [VarCurr] :
      ( v25284(VarCurr,bitIndex30)
    <=> v25286(VarCurr,bitIndex37) ) ).

fof(addAssignment_11084,axiom,
    ! [VarCurr] :
      ( v25286(VarCurr,bitIndex37)
    <=> v24386(VarCurr,bitIndex101) ) ).

fof(addAssignment_11083,axiom,
    ! [VarNext] :
      ( v25244(VarNext,bitIndex30)
    <=> v25261(VarNext,bitIndex30) ) ).

fof(addCaseBooleanConditionEqualRanges1_451,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25262(VarNext)
       => ! [B] :
            ( range_47_0(B)
           => ( v25261(VarNext,B)
            <=> v25244(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_383,axiom,
    ! [VarNext] :
      ( v25262(VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v25261(VarNext,B)
          <=> v25276(VarNext,B) ) ) ) ).

fof(addAssignment_11082,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_47_0(B)
         => ( v25276(VarNext,B)
          <=> v25274(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_579,axiom,
    ! [VarCurr] :
      ( ~ v25271(VarCurr)
     => ! [B] :
          ( range_47_0(B)
         => ( v25274(VarCurr,B)
          <=> v25255(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_580,axiom,
    ! [VarCurr] :
      ( v25271(VarCurr)
     => ! [B] :
          ( range_47_0(B)
         => ( v25274(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4414,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25262(VarNext)
      <=> ( v25263(VarNext)
          & v25270(VarNext) ) ) ) ).

fof(addAssignment_11081,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25270(VarNext)
      <=> v25268(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4413,axiom,
    ! [VarCurr] :
      ( v25268(VarCurr)
    <=> ( v25271(VarCurr)
        | v25272(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4412,axiom,
    ! [VarCurr] :
      ( v25272(VarCurr)
    <=> ( v25247(VarCurr)
        & v25273(VarCurr) ) ) ).

fof(writeUnaryOperator_2302,axiom,
    ! [VarCurr] :
      ( ~ v25273(VarCurr)
    <=> v25271(VarCurr) ) ).

fof(writeUnaryOperator_2301,axiom,
    ! [VarCurr] :
      ( ~ v25271(VarCurr)
    <=> v8531(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4411,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25263(VarNext)
      <=> ( v25264(VarNext)
          & v8584(VarNext) ) ) ) ).

fof(writeUnaryOperator_2300,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25264(VarNext)
      <=> v8591(VarNext) ) ) ).

fof(addAssignmentInitValueVector_941,axiom,
    ( ( v25244(constB0,bitIndex383)
    <=> $false )
    & ( v25244(constB0,bitIndex382)
    <=> $false )
    & ( v25244(constB0,bitIndex381)
    <=> $false )
    & ( v25244(constB0,bitIndex380)
    <=> $false )
    & ( v25244(constB0,bitIndex379)
    <=> $false )
    & ( v25244(constB0,bitIndex378)
    <=> $false )
    & ( v25244(constB0,bitIndex377)
    <=> $false )
    & ( v25244(constB0,bitIndex376)
    <=> $false )
    & ( v25244(constB0,bitIndex375)
    <=> $false )
    & ( v25244(constB0,bitIndex374)
    <=> $false )
    & ( v25244(constB0,bitIndex373)
    <=> $false )
    & ( v25244(constB0,bitIndex372)
    <=> $false )
    & ( v25244(constB0,bitIndex371)
    <=> $false )
    & ( v25244(constB0,bitIndex370)
    <=> $false )
    & ( v25244(constB0,bitIndex369)
    <=> $false )
    & ( v25244(constB0,bitIndex368)
    <=> $false )
    & ( v25244(constB0,bitIndex367)
    <=> $false )
    & ( v25244(constB0,bitIndex366)
    <=> $false )
    & ( v25244(constB0,bitIndex365)
    <=> $false )
    & ( v25244(constB0,bitIndex364)
    <=> $false )
    & ( v25244(constB0,bitIndex363)
    <=> $false )
    & ( v25244(constB0,bitIndex362)
    <=> $false )
    & ( v25244(constB0,bitIndex361)
    <=> $false )
    & ( v25244(constB0,bitIndex360)
    <=> $false )
    & ( v25244(constB0,bitIndex359)
    <=> $false )
    & ( v25244(constB0,bitIndex358)
    <=> $false )
    & ( v25244(constB0,bitIndex357)
    <=> $false )
    & ( v25244(constB0,bitIndex356)
    <=> $false )
    & ( v25244(constB0,bitIndex355)
    <=> $false )
    & ( v25244(constB0,bitIndex354)
    <=> $false )
    & ( v25244(constB0,bitIndex353)
    <=> $false )
    & ( v25244(constB0,bitIndex352)
    <=> $false )
    & ( v25244(constB0,bitIndex351)
    <=> $false )
    & ( v25244(constB0,bitIndex350)
    <=> $false )
    & ( v25244(constB0,bitIndex349)
    <=> $false )
    & ( v25244(constB0,bitIndex348)
    <=> $false )
    & ( v25244(constB0,bitIndex347)
    <=> $false )
    & ( v25244(constB0,bitIndex346)
    <=> $false )
    & ( v25244(constB0,bitIndex345)
    <=> $false )
    & ( v25244(constB0,bitIndex344)
    <=> $false )
    & ( v25244(constB0,bitIndex343)
    <=> $false )
    & ( v25244(constB0,bitIndex342)
    <=> $false )
    & ( v25244(constB0,bitIndex341)
    <=> $false )
    & ( v25244(constB0,bitIndex340)
    <=> $false )
    & ( v25244(constB0,bitIndex339)
    <=> $false )
    & ( v25244(constB0,bitIndex338)
    <=> $false )
    & ( v25244(constB0,bitIndex337)
    <=> $false )
    & ( v25244(constB0,bitIndex336)
    <=> $false ) ) ).

fof(addAssignmentInitValueVector_940,axiom,
    ( ( v25244(constB0,bitIndex335)
    <=> $false )
    & ( v25244(constB0,bitIndex334)
    <=> $false )
    & ( v25244(constB0,bitIndex333)
    <=> $false )
    & ( v25244(constB0,bitIndex332)
    <=> $false )
    & ( v25244(constB0,bitIndex331)
    <=> $false )
    & ( v25244(constB0,bitIndex330)
    <=> $false )
    & ( v25244(constB0,bitIndex329)
    <=> $false )
    & ( v25244(constB0,bitIndex328)
    <=> $false )
    & ( v25244(constB0,bitIndex327)
    <=> $false )
    & ( v25244(constB0,bitIndex326)
    <=> $false )
    & ( v25244(constB0,bitIndex325)
    <=> $false )
    & ( v25244(constB0,bitIndex324)
    <=> $false )
    & ( v25244(constB0,bitIndex323)
    <=> $false )
    & ( v25244(constB0,bitIndex322)
    <=> $false )
    & ( v25244(constB0,bitIndex321)
    <=> $false )
    & ( v25244(constB0,bitIndex320)
    <=> $false )
    & ( v25244(constB0,bitIndex319)
    <=> $false )
    & ( v25244(constB0,bitIndex318)
    <=> $false )
    & ( v25244(constB0,bitIndex317)
    <=> $false )
    & ( v25244(constB0,bitIndex316)
    <=> $false )
    & ( v25244(constB0,bitIndex315)
    <=> $false )
    & ( v25244(constB0,bitIndex314)
    <=> $false )
    & ( v25244(constB0,bitIndex313)
    <=> $false )
    & ( v25244(constB0,bitIndex312)
    <=> $false )
    & ( v25244(constB0,bitIndex311)
    <=> $false )
    & ( v25244(constB0,bitIndex310)
    <=> $false )
    & ( v25244(constB0,bitIndex309)
    <=> $false )
    & ( v25244(constB0,bitIndex308)
    <=> $false )
    & ( v25244(constB0,bitIndex307)
    <=> $false )
    & ( v25244(constB0,bitIndex306)
    <=> $false )
    & ( v25244(constB0,bitIndex305)
    <=> $false )
    & ( v25244(constB0,bitIndex304)
    <=> $false )
    & ( v25244(constB0,bitIndex303)
    <=> $false )
    & ( v25244(constB0,bitIndex302)
    <=> $false )
    & ( v25244(constB0,bitIndex301)
    <=> $false )
    & ( v25244(constB0,bitIndex300)
    <=> $false )
    & ( v25244(constB0,bitIndex299)
    <=> $false )
    & ( v25244(constB0,bitIndex298)
    <=> $false )
    & ( v25244(constB0,bitIndex297)
    <=> $false )
    & ( v25244(constB0,bitIndex296)
    <=> $false )
    & ( v25244(constB0,bitIndex295)
    <=> $false )
    & ( v25244(constB0,bitIndex294)
    <=> $false )
    & ( v25244(constB0,bitIndex293)
    <=> $false )
    & ( v25244(constB0,bitIndex292)
    <=> $false )
    & ( v25244(constB0,bitIndex291)
    <=> $false )
    & ( v25244(constB0,bitIndex290)
    <=> $false )
    & ( v25244(constB0,bitIndex289)
    <=> $false )
    & ( v25244(constB0,bitIndex288)
    <=> $false ) ) ).

fof(addAssignmentInitValueVector_939,axiom,
    ( ( v25244(constB0,bitIndex287)
    <=> $false )
    & ( v25244(constB0,bitIndex286)
    <=> $false )
    & ( v25244(constB0,bitIndex285)
    <=> $false )
    & ( v25244(constB0,bitIndex284)
    <=> $false )
    & ( v25244(constB0,bitIndex283)
    <=> $false )
    & ( v25244(constB0,bitIndex282)
    <=> $false )
    & ( v25244(constB0,bitIndex281)
    <=> $false )
    & ( v25244(constB0,bitIndex280)
    <=> $false )
    & ( v25244(constB0,bitIndex279)
    <=> $false )
    & ( v25244(constB0,bitIndex278)
    <=> $false )
    & ( v25244(constB0,bitIndex277)
    <=> $false )
    & ( v25244(constB0,bitIndex276)
    <=> $false )
    & ( v25244(constB0,bitIndex275)
    <=> $false )
    & ( v25244(constB0,bitIndex274)
    <=> $false )
    & ( v25244(constB0,bitIndex273)
    <=> $false )
    & ( v25244(constB0,bitIndex272)
    <=> $false )
    & ( v25244(constB0,bitIndex271)
    <=> $false )
    & ( v25244(constB0,bitIndex270)
    <=> $false )
    & ( v25244(constB0,bitIndex269)
    <=> $false )
    & ( v25244(constB0,bitIndex268)
    <=> $false )
    & ( v25244(constB0,bitIndex267)
    <=> $false )
    & ( v25244(constB0,bitIndex266)
    <=> $false )
    & ( v25244(constB0,bitIndex265)
    <=> $false )
    & ( v25244(constB0,bitIndex264)
    <=> $false )
    & ( v25244(constB0,bitIndex263)
    <=> $false )
    & ( v25244(constB0,bitIndex262)
    <=> $false )
    & ( v25244(constB0,bitIndex261)
    <=> $false )
    & ( v25244(constB0,bitIndex260)
    <=> $false )
    & ( v25244(constB0,bitIndex259)
    <=> $false )
    & ( v25244(constB0,bitIndex258)
    <=> $false )
    & ( v25244(constB0,bitIndex257)
    <=> $false )
    & ( v25244(constB0,bitIndex256)
    <=> $false )
    & ( v25244(constB0,bitIndex255)
    <=> $false )
    & ( v25244(constB0,bitIndex254)
    <=> $false )
    & ( v25244(constB0,bitIndex253)
    <=> $false )
    & ( v25244(constB0,bitIndex252)
    <=> $false )
    & ( v25244(constB0,bitIndex251)
    <=> $false )
    & ( v25244(constB0,bitIndex250)
    <=> $false )
    & ( v25244(constB0,bitIndex249)
    <=> $false )
    & ( v25244(constB0,bitIndex248)
    <=> $false )
    & ( v25244(constB0,bitIndex247)
    <=> $false )
    & ( v25244(constB0,bitIndex246)
    <=> $false )
    & ( v25244(constB0,bitIndex245)
    <=> $false )
    & ( v25244(constB0,bitIndex244)
    <=> $false )
    & ( v25244(constB0,bitIndex243)
    <=> $false )
    & ( v25244(constB0,bitIndex242)
    <=> $false )
    & ( v25244(constB0,bitIndex241)
    <=> $false )
    & ( v25244(constB0,bitIndex240)
    <=> $false ) ) ).

fof(addAssignmentInitValueVector_938,axiom,
    ( ( v25244(constB0,bitIndex239)
    <=> $false )
    & ( v25244(constB0,bitIndex238)
    <=> $false )
    & ( v25244(constB0,bitIndex237)
    <=> $false )
    & ( v25244(constB0,bitIndex236)
    <=> $false )
    & ( v25244(constB0,bitIndex235)
    <=> $false )
    & ( v25244(constB0,bitIndex234)
    <=> $false )
    & ( v25244(constB0,bitIndex233)
    <=> $false )
    & ( v25244(constB0,bitIndex232)
    <=> $false )
    & ( v25244(constB0,bitIndex231)
    <=> $false )
    & ( v25244(constB0,bitIndex230)
    <=> $false )
    & ( v25244(constB0,bitIndex229)
    <=> $false )
    & ( v25244(constB0,bitIndex228)
    <=> $false )
    & ( v25244(constB0,bitIndex227)
    <=> $false )
    & ( v25244(constB0,bitIndex226)
    <=> $false )
    & ( v25244(constB0,bitIndex225)
    <=> $false )
    & ( v25244(constB0,bitIndex224)
    <=> $false )
    & ( v25244(constB0,bitIndex223)
    <=> $false )
    & ( v25244(constB0,bitIndex222)
    <=> $false )
    & ( v25244(constB0,bitIndex221)
    <=> $false )
    & ( v25244(constB0,bitIndex220)
    <=> $false )
    & ( v25244(constB0,bitIndex219)
    <=> $false )
    & ( v25244(constB0,bitIndex218)
    <=> $false )
    & ( v25244(constB0,bitIndex217)
    <=> $false )
    & ( v25244(constB0,bitIndex216)
    <=> $false )
    & ( v25244(constB0,bitIndex215)
    <=> $false )
    & ( v25244(constB0,bitIndex214)
    <=> $false )
    & ( v25244(constB0,bitIndex213)
    <=> $false )
    & ( v25244(constB0,bitIndex212)
    <=> $false )
    & ( v25244(constB0,bitIndex211)
    <=> $false )
    & ( v25244(constB0,bitIndex210)
    <=> $false )
    & ( v25244(constB0,bitIndex209)
    <=> $false )
    & ( v25244(constB0,bitIndex208)
    <=> $false )
    & ( v25244(constB0,bitIndex207)
    <=> $false )
    & ( v25244(constB0,bitIndex206)
    <=> $false )
    & ( v25244(constB0,bitIndex205)
    <=> $false )
    & ( v25244(constB0,bitIndex204)
    <=> $false )
    & ( v25244(constB0,bitIndex203)
    <=> $false )
    & ( v25244(constB0,bitIndex202)
    <=> $false )
    & ( v25244(constB0,bitIndex201)
    <=> $false )
    & ( v25244(constB0,bitIndex200)
    <=> $false )
    & ( v25244(constB0,bitIndex199)
    <=> $false )
    & ( v25244(constB0,bitIndex198)
    <=> $false )
    & ( v25244(constB0,bitIndex197)
    <=> $false )
    & ( v25244(constB0,bitIndex196)
    <=> $false )
    & ( v25244(constB0,bitIndex195)
    <=> $false )
    & ( v25244(constB0,bitIndex194)
    <=> $false )
    & ( v25244(constB0,bitIndex193)
    <=> $false )
    & ( v25244(constB0,bitIndex192)
    <=> $false ) ) ).

fof(addAssignmentInitValueVector_937,axiom,
    ( ( v25244(constB0,bitIndex191)
    <=> $false )
    & ( v25244(constB0,bitIndex190)
    <=> $false )
    & ( v25244(constB0,bitIndex189)
    <=> $false )
    & ( v25244(constB0,bitIndex188)
    <=> $false )
    & ( v25244(constB0,bitIndex187)
    <=> $false )
    & ( v25244(constB0,bitIndex186)
    <=> $false )
    & ( v25244(constB0,bitIndex185)
    <=> $false )
    & ( v25244(constB0,bitIndex184)
    <=> $false )
    & ( v25244(constB0,bitIndex183)
    <=> $false )
    & ( v25244(constB0,bitIndex182)
    <=> $false )
    & ( v25244(constB0,bitIndex181)
    <=> $false )
    & ( v25244(constB0,bitIndex180)
    <=> $false )
    & ( v25244(constB0,bitIndex179)
    <=> $false )
    & ( v25244(constB0,bitIndex178)
    <=> $false )
    & ( v25244(constB0,bitIndex177)
    <=> $false )
    & ( v25244(constB0,bitIndex176)
    <=> $false )
    & ( v25244(constB0,bitIndex175)
    <=> $false )
    & ( v25244(constB0,bitIndex174)
    <=> $false )
    & ( v25244(constB0,bitIndex173)
    <=> $false )
    & ( v25244(constB0,bitIndex172)
    <=> $false )
    & ( v25244(constB0,bitIndex171)
    <=> $false )
    & ( v25244(constB0,bitIndex170)
    <=> $false )
    & ( v25244(constB0,bitIndex169)
    <=> $false )
    & ( v25244(constB0,bitIndex168)
    <=> $false )
    & ( v25244(constB0,bitIndex167)
    <=> $false )
    & ( v25244(constB0,bitIndex166)
    <=> $false )
    & ( v25244(constB0,bitIndex165)
    <=> $false )
    & ( v25244(constB0,bitIndex164)
    <=> $false )
    & ( v25244(constB0,bitIndex163)
    <=> $false )
    & ( v25244(constB0,bitIndex162)
    <=> $false )
    & ( v25244(constB0,bitIndex161)
    <=> $false )
    & ( v25244(constB0,bitIndex160)
    <=> $false )
    & ( v25244(constB0,bitIndex159)
    <=> $false )
    & ( v25244(constB0,bitIndex158)
    <=> $false )
    & ( v25244(constB0,bitIndex157)
    <=> $false )
    & ( v25244(constB0,bitIndex156)
    <=> $false )
    & ( v25244(constB0,bitIndex155)
    <=> $false )
    & ( v25244(constB0,bitIndex154)
    <=> $false )
    & ( v25244(constB0,bitIndex153)
    <=> $false )
    & ( v25244(constB0,bitIndex152)
    <=> $false )
    & ( v25244(constB0,bitIndex151)
    <=> $false )
    & ( v25244(constB0,bitIndex150)
    <=> $false )
    & ( v25244(constB0,bitIndex149)
    <=> $false )
    & ( v25244(constB0,bitIndex148)
    <=> $false )
    & ( v25244(constB0,bitIndex147)
    <=> $false )
    & ( v25244(constB0,bitIndex146)
    <=> $false )
    & ( v25244(constB0,bitIndex145)
    <=> $false )
    & ( v25244(constB0,bitIndex144)
    <=> $false ) ) ).

fof(addAssignmentInitValueVector_936,axiom,
    ( ( v25244(constB0,bitIndex143)
    <=> $false )
    & ( v25244(constB0,bitIndex142)
    <=> $false )
    & ( v25244(constB0,bitIndex141)
    <=> $false )
    & ( v25244(constB0,bitIndex140)
    <=> $false )
    & ( v25244(constB0,bitIndex139)
    <=> $false )
    & ( v25244(constB0,bitIndex138)
    <=> $false )
    & ( v25244(constB0,bitIndex137)
    <=> $false )
    & ( v25244(constB0,bitIndex136)
    <=> $false )
    & ( v25244(constB0,bitIndex135)
    <=> $false )
    & ( v25244(constB0,bitIndex134)
    <=> $false )
    & ( v25244(constB0,bitIndex133)
    <=> $false )
    & ( v25244(constB0,bitIndex132)
    <=> $false )
    & ( v25244(constB0,bitIndex131)
    <=> $false )
    & ( v25244(constB0,bitIndex130)
    <=> $false )
    & ( v25244(constB0,bitIndex129)
    <=> $false )
    & ( v25244(constB0,bitIndex128)
    <=> $false )
    & ( v25244(constB0,bitIndex127)
    <=> $false )
    & ( v25244(constB0,bitIndex126)
    <=> $false )
    & ( v25244(constB0,bitIndex125)
    <=> $false )
    & ( v25244(constB0,bitIndex124)
    <=> $false )
    & ( v25244(constB0,bitIndex123)
    <=> $false )
    & ( v25244(constB0,bitIndex122)
    <=> $false )
    & ( v25244(constB0,bitIndex121)
    <=> $false )
    & ( v25244(constB0,bitIndex120)
    <=> $false )
    & ( v25244(constB0,bitIndex119)
    <=> $false )
    & ( v25244(constB0,bitIndex118)
    <=> $false )
    & ( v25244(constB0,bitIndex117)
    <=> $false )
    & ( v25244(constB0,bitIndex116)
    <=> $false )
    & ( v25244(constB0,bitIndex115)
    <=> $false )
    & ( v25244(constB0,bitIndex114)
    <=> $false )
    & ( v25244(constB0,bitIndex113)
    <=> $false )
    & ( v25244(constB0,bitIndex112)
    <=> $false )
    & ( v25244(constB0,bitIndex111)
    <=> $false )
    & ( v25244(constB0,bitIndex110)
    <=> $false )
    & ( v25244(constB0,bitIndex109)
    <=> $false )
    & ( v25244(constB0,bitIndex108)
    <=> $false )
    & ( v25244(constB0,bitIndex107)
    <=> $false )
    & ( v25244(constB0,bitIndex106)
    <=> $false )
    & ( v25244(constB0,bitIndex105)
    <=> $false )
    & ( v25244(constB0,bitIndex104)
    <=> $false )
    & ( v25244(constB0,bitIndex103)
    <=> $false )
    & ( v25244(constB0,bitIndex102)
    <=> $false )
    & ( v25244(constB0,bitIndex101)
    <=> $false )
    & ( v25244(constB0,bitIndex100)
    <=> $false )
    & ( v25244(constB0,bitIndex99)
    <=> $false )
    & ( v25244(constB0,bitIndex98)
    <=> $false )
    & ( v25244(constB0,bitIndex97)
    <=> $false )
    & ( v25244(constB0,bitIndex96)
    <=> $false ) ) ).

fof(addAssignmentInitValueVector_935,axiom,
    ( ( v25244(constB0,bitIndex95)
    <=> $false )
    & ( v25244(constB0,bitIndex94)
    <=> $false )
    & ( v25244(constB0,bitIndex93)
    <=> $false )
    & ( v25244(constB0,bitIndex92)
    <=> $false )
    & ( v25244(constB0,bitIndex91)
    <=> $false )
    & ( v25244(constB0,bitIndex90)
    <=> $false )
    & ( v25244(constB0,bitIndex89)
    <=> $false )
    & ( v25244(constB0,bitIndex88)
    <=> $false )
    & ( v25244(constB0,bitIndex87)
    <=> $false )
    & ( v25244(constB0,bitIndex86)
    <=> $false )
    & ( v25244(constB0,bitIndex85)
    <=> $false )
    & ( v25244(constB0,bitIndex84)
    <=> $false )
    & ( v25244(constB0,bitIndex83)
    <=> $false )
    & ( v25244(constB0,bitIndex82)
    <=> $false )
    & ( v25244(constB0,bitIndex81)
    <=> $false )
    & ( v25244(constB0,bitIndex80)
    <=> $false )
    & ( v25244(constB0,bitIndex79)
    <=> $false )
    & ( v25244(constB0,bitIndex78)
    <=> $false )
    & ( v25244(constB0,bitIndex77)
    <=> $false )
    & ( v25244(constB0,bitIndex76)
    <=> $false )
    & ( v25244(constB0,bitIndex75)
    <=> $false )
    & ( v25244(constB0,bitIndex74)
    <=> $false )
    & ( v25244(constB0,bitIndex73)
    <=> $false )
    & ( v25244(constB0,bitIndex72)
    <=> $false )
    & ( v25244(constB0,bitIndex71)
    <=> $false )
    & ( v25244(constB0,bitIndex70)
    <=> $false )
    & ( v25244(constB0,bitIndex69)
    <=> $false )
    & ( v25244(constB0,bitIndex68)
    <=> $false )
    & ( v25244(constB0,bitIndex67)
    <=> $false )
    & ( v25244(constB0,bitIndex66)
    <=> $false )
    & ( v25244(constB0,bitIndex65)
    <=> $false )
    & ( v25244(constB0,bitIndex64)
    <=> $false )
    & ( v25244(constB0,bitIndex63)
    <=> $false )
    & ( v25244(constB0,bitIndex62)
    <=> $false )
    & ( v25244(constB0,bitIndex61)
    <=> $false )
    & ( v25244(constB0,bitIndex60)
    <=> $false )
    & ( v25244(constB0,bitIndex59)
    <=> $false )
    & ( v25244(constB0,bitIndex58)
    <=> $false )
    & ( v25244(constB0,bitIndex57)
    <=> $false )
    & ( v25244(constB0,bitIndex56)
    <=> $false )
    & ( v25244(constB0,bitIndex55)
    <=> $false )
    & ( v25244(constB0,bitIndex54)
    <=> $false )
    & ( v25244(constB0,bitIndex53)
    <=> $false )
    & ( v25244(constB0,bitIndex52)
    <=> $false )
    & ( v25244(constB0,bitIndex51)
    <=> $false )
    & ( v25244(constB0,bitIndex50)
    <=> $false )
    & ( v25244(constB0,bitIndex49)
    <=> $false )
    & ( v25244(constB0,bitIndex48)
    <=> $false ) ) ).

fof(addAssignmentInitValueVector_934,axiom,
    ! [B] :
      ( range_47_0(B)
     => ( v25244(constB0,B)
      <=> $false ) ) ).

fof(range_axiom_217,axiom,
    ! [B] :
      ( range_47_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B
        | bitIndex30 = B
        | bitIndex31 = B
        | bitIndex32 = B
        | bitIndex33 = B
        | bitIndex34 = B
        | bitIndex35 = B
        | bitIndex36 = B
        | bitIndex37 = B
        | bitIndex38 = B
        | bitIndex39 = B
        | bitIndex40 = B
        | bitIndex41 = B
        | bitIndex42 = B
        | bitIndex43 = B
        | bitIndex44 = B
        | bitIndex45 = B
        | bitIndex46 = B
        | bitIndex47 = B ) ) ).

fof(bitBlastConstant_3421,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex47) ).

fof(bitBlastConstant_3420,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex46) ).

fof(bitBlastConstant_3419,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex45) ).

fof(bitBlastConstant_3418,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex44) ).

fof(bitBlastConstant_3417,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex43) ).

fof(bitBlastConstant_3416,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex42) ).

fof(bitBlastConstant_3415,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex41) ).

fof(bitBlastConstant_3414,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex40) ).

fof(bitBlastConstant_3413,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex39) ).

fof(bitBlastConstant_3412,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex38) ).

fof(bitBlastConstant_3411,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex37) ).

fof(bitBlastConstant_3410,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex36) ).

fof(bitBlastConstant_3409,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex35) ).

fof(bitBlastConstant_3408,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex34) ).

fof(bitBlastConstant_3407,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex33) ).

fof(bitBlastConstant_3406,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex32) ).

fof(bitBlastConstant_3405,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex31) ).

fof(bitBlastConstant_3404,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex30) ).

fof(bitBlastConstant_3403,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex29) ).

fof(bitBlastConstant_3402,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex28) ).

fof(bitBlastConstant_3401,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex27) ).

fof(bitBlastConstant_3400,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex26) ).

fof(bitBlastConstant_3399,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex25) ).

fof(bitBlastConstant_3398,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex24) ).

fof(bitBlastConstant_3397,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex23) ).

fof(bitBlastConstant_3396,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex22) ).

fof(bitBlastConstant_3395,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex21) ).

fof(bitBlastConstant_3394,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex20) ).

fof(bitBlastConstant_3393,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex19) ).

fof(bitBlastConstant_3392,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex18) ).

fof(bitBlastConstant_3391,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex17) ).

fof(bitBlastConstant_3390,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex16) ).

fof(bitBlastConstant_3389,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex15) ).

fof(bitBlastConstant_3388,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex14) ).

fof(bitBlastConstant_3387,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex13) ).

fof(bitBlastConstant_3386,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex12) ).

fof(bitBlastConstant_3385,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex11) ).

fof(bitBlastConstant_3384,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex10) ).

fof(bitBlastConstant_3383,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex9) ).

fof(bitBlastConstant_3382,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex8) ).

fof(bitBlastConstant_3381,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex7) ).

fof(bitBlastConstant_3380,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex6) ).

fof(bitBlastConstant_3379,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex5) ).

fof(bitBlastConstant_3378,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex4) ).

fof(bitBlastConstant_3377,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex3) ).

fof(bitBlastConstant_3376,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex2) ).

fof(bitBlastConstant_3375,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex1) ).

fof(bitBlastConstant_3374,axiom,
    ~ b000000000000000000000000000000000000000000000000(bitIndex0) ).

fof(addAssignment_11080,axiom,
    ! [VarCurr] :
      ( v25255(VarCurr,bitIndex30)
    <=> v25257(VarCurr,bitIndex30) ) ).

fof(addAssignment_11079,axiom,
    ! [VarCurr] :
      ( v25257(VarCurr,bitIndex30)
    <=> v25259(VarCurr,bitIndex30) ) ).

fof(addAssignment_11078,axiom,
    ! [VarCurr] :
      ( v25259(VarCurr,bitIndex30)
    <=> v24386(VarCurr,bitIndex37) ) ).

fof(addAssignment_11077,axiom,
    ! [VarCurr] :
      ( v25247(VarCurr)
    <=> v25249(VarCurr) ) ).

fof(addAssignment_11076,axiom,
    ! [VarCurr] :
      ( v25249(VarCurr)
    <=> v25251(VarCurr) ) ).

fof(addAssignment_11075,axiom,
    ! [VarCurr] :
      ( v25251(VarCurr)
    <=> v25253(VarCurr) ) ).

fof(addAssignment_11074,axiom,
    ! [VarCurr] :
      ( v25253(VarCurr)
    <=> v24016(VarCurr) ) ).

fof(addAssignment_11073,axiom,
    ! [VarCurr] :
      ( v214(VarCurr)
    <=> v216(VarCurr) ) ).

fof(addAssignment_11072,axiom,
    ! [VarCurr] :
      ( v216(VarCurr)
    <=> v218(VarCurr) ) ).

fof(addAssignment_11071,axiom,
    ! [VarCurr] :
      ( v218(VarCurr)
    <=> v220(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_1223,axiom,
    ! [VarCurr] :
      ( v220(VarCurr)
    <=> ( v222(VarCurr,bitIndex0)
        | v222(VarCurr,bitIndex1) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_450,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25223(VarNext)
       => ! [B] :
            ( range_1_0(B)
           => ( v222(VarNext,B)
            <=> v222(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_382,axiom,
    ! [VarNext] :
      ( v25223(VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v222(VarNext,B)
          <=> v25231(VarNext,B) ) ) ) ).

fof(addAssignment_11070,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v25231(VarNext,B)
          <=> v25229(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_702,axiom,
    ! [VarCurr] :
      ( ~ v11894(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v25229(VarCurr,B)
          <=> v235(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_456,axiom,
    ! [VarCurr] :
      ( v11894(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v25229(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4410,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25223(VarNext)
      <=> v25224(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4409,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25224(VarNext)
      <=> ( v25226(VarNext)
          & v11880(VarNext) ) ) ) ).

fof(writeUnaryOperator_2299,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25226(VarNext)
      <=> v11887(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_701,axiom,
    ! [VarCurr] :
      ( ~ v11874(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v235(VarCurr,B)
          <=> v222(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_455,axiom,
    ! [VarCurr] :
      ( v11874(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v235(VarCurr,B)
          <=> v25219(VarCurr,B) ) ) ) ).

fof(addAssignment_11069,axiom,
    ! [VarCurr,B] :
      ( range_1_0(B)
     => ( v25219(VarCurr,B)
      <=> v252(VarCurr,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_449,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25207(VarNext)
       => ! [B] :
            ( range_2_0(B)
           => ( v237(VarNext,B)
            <=> v237(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_381,axiom,
    ! [VarNext] :
      ( v25207(VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v237(VarNext,B)
          <=> v25215(VarNext,B) ) ) ) ).

fof(addAssignment_11068,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v25215(VarNext,B)
          <=> v25213(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_700,axiom,
    ! [VarCurr] :
      ( ~ v11894(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v25213(VarCurr,B)
          <=> v240(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_454,axiom,
    ! [VarCurr] :
      ( v11894(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v25213(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4408,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25207(VarNext)
      <=> v25208(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4407,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25208(VarNext)
      <=> ( v25210(VarNext)
          & v11880(VarNext) ) ) ) ).

fof(writeUnaryOperator_2298,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25210(VarNext)
      <=> v11887(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges6_13,axiom,
    ! [VarCurr] :
      ( ( ~ v25158(VarCurr)
        & ~ v25162(VarCurr)
        & ~ v25163(VarCurr)
        & ~ v25169(VarCurr)
        & ~ v25184(VarCurr)
        & ~ v25201(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v240(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges5_17,axiom,
    ! [VarCurr] :
      ( v25201(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v240(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_14,axiom,
    ! [VarCurr] :
      ( v25184(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v240(VarCurr,B)
          <=> v25185(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_46,axiom,
    ! [VarCurr] :
      ( v25169(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v240(VarCurr,B)
          <=> v25170(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_110,axiom,
    ! [VarCurr] :
      ( v25163(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v240(VarCurr,B)
          <=> v25164(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_578,axiom,
    ! [VarCurr] :
      ( v25162(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v240(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_579,axiom,
    ! [VarCurr] :
      ( v25158(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v240(VarCurr,B)
          <=> v25159(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4406,axiom,
    ! [VarCurr] :
      ( v25202(VarCurr)
    <=> ( v25203(VarCurr)
        | v25204(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_2178,axiom,
    ! [VarCurr] :
      ( v25204(VarCurr)
    <=> ( ( v237(VarCurr,bitIndex2)
        <=> $true )
        & ( v237(VarCurr,bitIndex1)
        <=> $true )
        & ( v237(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_2177,axiom,
    ! [VarCurr] :
      ( v25203(VarCurr)
    <=> ( ( v237(VarCurr,bitIndex2)
        <=> $true )
        & ( v237(VarCurr,bitIndex1)
        <=> $true )
        & ( v237(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_2176,axiom,
    ! [VarCurr] :
      ( v25201(VarCurr)
    <=> ( ( v237(VarCurr,bitIndex2)
        <=> $true )
        & ( v237(VarCurr,bitIndex1)
        <=> $false )
        & ( v237(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_45,axiom,
    ! [VarCurr] :
      ( ( ~ v25186(VarCurr)
        & ~ v25191(VarCurr)
        & ~ v25196(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v25185(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_109,axiom,
    ! [VarCurr] :
      ( v25196(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v25185(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_577,axiom,
    ! [VarCurr] :
      ( v25191(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v25185(VarCurr,B)
          <=> b101(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_578,axiom,
    ! [VarCurr] :
      ( v25186(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v25185(VarCurr,B)
          <=> b100(B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4405,axiom,
    ! [VarCurr] :
      ( v25196(VarCurr)
    <=> ( v25197(VarCurr)
        | v25199(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_2175,axiom,
    ! [VarCurr] :
      ( v25199(VarCurr)
    <=> ( ( v25200(VarCurr,bitIndex2)
        <=> $true )
        & ( v25200(VarCurr,bitIndex1)
        <=> $true )
        & ( v25200(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_11067,axiom,
    ! [VarCurr] :
      ( v25200(VarCurr,bitIndex0)
    <=> v8873(VarCurr) ) ).

fof(addAssignment_11066,axiom,
    ! [VarCurr] :
      ( v25200(VarCurr,bitIndex1)
    <=> v24271(VarCurr) ) ).

fof(addAssignment_11065,axiom,
    ! [VarCurr] :
      ( v25200(VarCurr,bitIndex2)
    <=> v23997(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_2174,axiom,
    ! [VarCurr] :
      ( v25197(VarCurr)
    <=> ( ( v25198(VarCurr,bitIndex2)
        <=> $true )
        & ( v25198(VarCurr,bitIndex1)
        <=> $true )
        & ( v25198(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_11064,axiom,
    ! [VarCurr] :
      ( v25198(VarCurr,bitIndex0)
    <=> v8873(VarCurr) ) ).

fof(addAssignment_11063,axiom,
    ! [VarCurr] :
      ( v25198(VarCurr,bitIndex1)
    <=> v24271(VarCurr) ) ).

fof(addAssignment_11062,axiom,
    ! [VarCurr] :
      ( v25198(VarCurr,bitIndex2)
    <=> v23997(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4404,axiom,
    ! [VarCurr] :
      ( v25191(VarCurr)
    <=> ( v25192(VarCurr)
        | v25194(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_2173,axiom,
    ! [VarCurr] :
      ( v25194(VarCurr)
    <=> ( ( v25195(VarCurr,bitIndex2)
        <=> $true )
        & ( v25195(VarCurr,bitIndex1)
        <=> $false )
        & ( v25195(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_11061,axiom,
    ! [VarCurr] :
      ( v25195(VarCurr,bitIndex0)
    <=> v8873(VarCurr) ) ).

fof(addAssignment_11060,axiom,
    ! [VarCurr] :
      ( v25195(VarCurr,bitIndex1)
    <=> v24271(VarCurr) ) ).

fof(addAssignment_11059,axiom,
    ! [VarCurr] :
      ( v25195(VarCurr,bitIndex2)
    <=> v23997(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_2172,axiom,
    ! [VarCurr] :
      ( v25192(VarCurr)
    <=> ( ( v25193(VarCurr,bitIndex2)
        <=> $true )
        & ( v25193(VarCurr,bitIndex1)
        <=> $false )
        & ( v25193(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_11058,axiom,
    ! [VarCurr] :
      ( v25193(VarCurr,bitIndex0)
    <=> v8873(VarCurr) ) ).

fof(addAssignment_11057,axiom,
    ! [VarCurr] :
      ( v25193(VarCurr,bitIndex1)
    <=> v24271(VarCurr) ) ).

fof(addAssignment_11056,axiom,
    ! [VarCurr] :
      ( v25193(VarCurr,bitIndex2)
    <=> v23997(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4403,axiom,
    ! [VarCurr] :
      ( v25186(VarCurr)
    <=> ( v25187(VarCurr)
        | v25189(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_2171,axiom,
    ! [VarCurr] :
      ( v25189(VarCurr)
    <=> ( ( v25190(VarCurr,bitIndex2)
        <=> $false )
        & ( v25190(VarCurr,bitIndex1)
        <=> $false )
        & ( v25190(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_11055,axiom,
    ! [VarCurr] :
      ( v25190(VarCurr,bitIndex0)
    <=> v8873(VarCurr) ) ).

fof(addAssignment_11054,axiom,
    ! [VarCurr] :
      ( v25190(VarCurr,bitIndex1)
    <=> v24271(VarCurr) ) ).

fof(addAssignment_11053,axiom,
    ! [VarCurr] :
      ( v25190(VarCurr,bitIndex2)
    <=> v23997(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_2170,axiom,
    ! [VarCurr] :
      ( v25187(VarCurr)
    <=> ( ( v25188(VarCurr,bitIndex2)
        <=> $false )
        & ( v25188(VarCurr,bitIndex1)
        <=> $false )
        & ( v25188(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_11052,axiom,
    ! [VarCurr] :
      ( v25188(VarCurr,bitIndex0)
    <=> v8873(VarCurr) ) ).

fof(addAssignment_11051,axiom,
    ! [VarCurr] :
      ( v25188(VarCurr,bitIndex1)
    <=> v24271(VarCurr) ) ).

fof(addAssignment_11050,axiom,
    ! [VarCurr] :
      ( v25188(VarCurr,bitIndex2)
    <=> v23997(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_2169,axiom,
    ! [VarCurr] :
      ( v25184(VarCurr)
    <=> ( ( v237(VarCurr,bitIndex2)
        <=> $true )
        & ( v237(VarCurr,bitIndex1)
        <=> $false )
        & ( v237(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges5_16,axiom,
    ! [VarCurr] :
      ( ( ~ v25171(VarCurr)
        & ~ v25173(VarCurr)
        & ~ v25175(VarCurr)
        & ~ v25177(VarCurr)
        & ~ v25179(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v25170(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_13,axiom,
    ! [VarCurr] :
      ( v25179(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v25170(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_44,axiom,
    ! [VarCurr] :
      ( v25177(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v25170(VarCurr,B)
          <=> b101(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_108,axiom,
    ! [VarCurr] :
      ( v25175(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v25170(VarCurr,B)
          <=> b110(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_576,axiom,
    ! [VarCurr] :
      ( v25173(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v25170(VarCurr,B)
          <=> b100(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_577,axiom,
    ! [VarCurr] :
      ( v25171(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v25170(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4402,axiom,
    ! [VarCurr] :
      ( v25179(VarCurr)
    <=> ( v25180(VarCurr)
        | v25182(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_2168,axiom,
    ! [VarCurr] :
      ( v25182(VarCurr)
    <=> ( ( v25183(VarCurr,bitIndex2)
        <=> $true )
        & ( v25183(VarCurr,bitIndex1)
        <=> $true )
        & ( v25183(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_11049,axiom,
    ! [VarCurr] :
      ( v25183(VarCurr,bitIndex0)
    <=> v8873(VarCurr) ) ).

fof(addAssignment_11048,axiom,
    ! [VarCurr] :
      ( v25183(VarCurr,bitIndex1)
    <=> v24271(VarCurr) ) ).

fof(addAssignment_11047,axiom,
    ! [VarCurr] :
      ( v25183(VarCurr,bitIndex2)
    <=> v23997(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_2167,axiom,
    ! [VarCurr] :
      ( v25180(VarCurr)
    <=> ( ( v25181(VarCurr,bitIndex2)
        <=> $true )
        & ( v25181(VarCurr,bitIndex1)
        <=> $true )
        & ( v25181(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_11046,axiom,
    ! [VarCurr] :
      ( v25181(VarCurr,bitIndex0)
    <=> v8873(VarCurr) ) ).

fof(addAssignment_11045,axiom,
    ! [VarCurr] :
      ( v25181(VarCurr,bitIndex1)
    <=> v24271(VarCurr) ) ).

fof(addAssignment_11044,axiom,
    ! [VarCurr] :
      ( v25181(VarCurr,bitIndex2)
    <=> v23997(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_2166,axiom,
    ! [VarCurr] :
      ( v25177(VarCurr)
    <=> ( ( v25178(VarCurr,bitIndex2)
        <=> $true )
        & ( v25178(VarCurr,bitIndex1)
        <=> $false )
        & ( v25178(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_11043,axiom,
    ! [VarCurr] :
      ( v25178(VarCurr,bitIndex0)
    <=> v8873(VarCurr) ) ).

fof(addAssignment_11042,axiom,
    ! [VarCurr] :
      ( v25178(VarCurr,bitIndex1)
    <=> v24271(VarCurr) ) ).

fof(addAssignment_11041,axiom,
    ! [VarCurr] :
      ( v25178(VarCurr,bitIndex2)
    <=> v23997(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_2165,axiom,
    ! [VarCurr] :
      ( v25175(VarCurr)
    <=> ( ( v25176(VarCurr,bitIndex2)
        <=> $true )
        & ( v25176(VarCurr,bitIndex1)
        <=> $false )
        & ( v25176(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_11040,axiom,
    ! [VarCurr] :
      ( v25176(VarCurr,bitIndex0)
    <=> v8873(VarCurr) ) ).

fof(addAssignment_11039,axiom,
    ! [VarCurr] :
      ( v25176(VarCurr,bitIndex1)
    <=> v24271(VarCurr) ) ).

fof(addAssignment_11038,axiom,
    ! [VarCurr] :
      ( v25176(VarCurr,bitIndex2)
    <=> v23997(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_2164,axiom,
    ! [VarCurr] :
      ( v25173(VarCurr)
    <=> ( ( v25174(VarCurr,bitIndex2)
        <=> $false )
        & ( v25174(VarCurr,bitIndex1)
        <=> $false )
        & ( v25174(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_11037,axiom,
    ! [VarCurr] :
      ( v25174(VarCurr,bitIndex0)
    <=> v8873(VarCurr) ) ).

fof(addAssignment_11036,axiom,
    ! [VarCurr] :
      ( v25174(VarCurr,bitIndex1)
    <=> v24271(VarCurr) ) ).

fof(addAssignment_11035,axiom,
    ! [VarCurr] :
      ( v25174(VarCurr,bitIndex2)
    <=> v23997(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_2163,axiom,
    ! [VarCurr] :
      ( v25171(VarCurr)
    <=> ( ( v25172(VarCurr,bitIndex2)
        <=> $false )
        & ( v25172(VarCurr,bitIndex1)
        <=> $false )
        & ( v25172(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_11034,axiom,
    ! [VarCurr] :
      ( v25172(VarCurr,bitIndex0)
    <=> v8873(VarCurr) ) ).

fof(addAssignment_11033,axiom,
    ! [VarCurr] :
      ( v25172(VarCurr,bitIndex1)
    <=> v24271(VarCurr) ) ).

fof(addAssignment_11032,axiom,
    ! [VarCurr] :
      ( v25172(VarCurr,bitIndex2)
    <=> v23997(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_2162,axiom,
    ! [VarCurr] :
      ( v25169(VarCurr)
    <=> ( ( v237(VarCurr,bitIndex2)
        <=> $false )
        & ( v237(VarCurr,bitIndex1)
        <=> $true )
        & ( v237(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_575,axiom,
    ! [VarCurr] :
      ( ~ v25165(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v25164(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_576,axiom,
    ! [VarCurr] :
      ( v25165(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v25164(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_2161,axiom,
    ! [VarCurr] :
      ( v25167(VarCurr)
    <=> ( v25168(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4401,axiom,
    ! [VarCurr] :
      ( v25168(VarCurr)
    <=> ( v23280(VarCurr)
      <~> v23300(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_2160,axiom,
    ! [VarCurr] :
      ( v25165(VarCurr)
    <=> ( v25166(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4400,axiom,
    ! [VarCurr] :
      ( v25166(VarCurr)
    <=> ( v23280(VarCurr)
      <~> v23300(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_2159,axiom,
    ! [VarCurr] :
      ( v25163(VarCurr)
    <=> ( ( v237(VarCurr,bitIndex2)
        <=> $false )
        & ( v237(VarCurr,bitIndex1)
        <=> $true )
        & ( v237(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_2158,axiom,
    ! [VarCurr] :
      ( v25162(VarCurr)
    <=> ( ( v237(VarCurr,bitIndex2)
        <=> $false )
        & ( v237(VarCurr,bitIndex1)
        <=> $false )
        & ( v237(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_574,axiom,
    ! [VarCurr] :
      ( ~ v25160(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v25159(VarCurr,B)
          <=> b001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_575,axiom,
    ! [VarCurr] :
      ( v25160(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v25159(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_2157,axiom,
    ! [VarCurr] :
      ( v25161(VarCurr)
    <=> ( v242(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_2156,axiom,
    ! [VarCurr] :
      ( v25160(VarCurr)
    <=> ( v242(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_2155,axiom,
    ! [VarCurr] :
      ( v25158(VarCurr)
    <=> ( ( v237(VarCurr,bitIndex2)
        <=> $false )
        & ( v237(VarCurr,bitIndex1)
        <=> $false )
        & ( v237(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_11031,axiom,
    ! [VarCurr] :
      ( v24271(VarCurr)
    <=> v24273(VarCurr) ) ).

fof(addAssignment_11030,axiom,
    ! [VarCurr] :
      ( v24273(VarCurr)
    <=> v24275(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4399,axiom,
    ! [VarCurr] :
      ( v24275(VarCurr)
    <=> ( v25153(VarCurr)
        & v24001(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1222,axiom,
    ! [VarCurr] :
      ( v25153(VarCurr)
    <=> ( v25155(VarCurr)
        | v25156(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1221,axiom,
    ! [VarCurr] :
      ( v25155(VarCurr)
    <=> ( v25156(VarCurr,bitIndex0)
        | v25156(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_127,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v25156(VarCurr,B)
      <=> ( v24277(VarCurr,B)
          | v24120(VarCurr,B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_448,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25141(VarNext)
       => ! [B] :
            ( range_2_0(B)
           => ( v24277(VarNext,B)
            <=> v24277(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_380,axiom,
    ! [VarNext] :
      ( v25141(VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v24277(VarNext,B)
          <=> v25149(VarNext,B) ) ) ) ).

fof(addAssignment_11029,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v25149(VarNext,B)
          <=> v25147(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_699,axiom,
    ! [VarCurr] :
      ( ~ v24209(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v25147(VarCurr,B)
          <=> v24279(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_453,axiom,
    ! [VarCurr] :
      ( v24209(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v25147(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4398,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25141(VarNext)
      <=> v25142(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4397,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v25142(VarNext)
      <=> ( v25144(VarNext)
          & v24195(VarNext) ) ) ) ).

fof(writeUnaryOperator_2297,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v25144(VarNext)
      <=> v24202(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_43,axiom,
    ! [VarCurr] :
      ( ( ~ v24177(VarCurr)
        & ~ v24178(VarCurr)
        & ~ v24179(VarCurr) )
     => ( v24279(VarCurr,bitIndex2)
      <=> v24277(VarCurr,bitIndex2) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges2_16,axiom,
    ! [VarCurr] :
      ( v24179(VarCurr)
     => ( v24279(VarCurr,bitIndex2)
      <=> v25138(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges1_15,axiom,
    ! [VarCurr] :
      ( v24178(VarCurr)
     => ( v24279(VarCurr,bitIndex2)
      <=> v25137(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_14,axiom,
    ! [VarCurr] :
      ( v24177(VarCurr)
     => ( v24279(VarCurr,bitIndex2)
      <=> $false ) ) ).

fof(writeBinaryOperatorShiftedRanges_1220,axiom,
    ! [VarCurr] :
      ( v25138(VarCurr)
    <=> ( v24277(VarCurr,bitIndex2)
        | v24120(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1219,axiom,
    ! [VarCurr] :
      ( v25137(VarCurr)
    <=> ( v24277(VarCurr,bitIndex2)
        | v24120(VarCurr,bitIndex2) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_42,axiom,
    ! [VarCurr] :
      ( ( ~ v24177(VarCurr)
        & ~ v24178(VarCurr)
        & ~ v24179(VarCurr) )
     => ( v24279(VarCurr,bitIndex1)
      <=> v24277(VarCurr,bitIndex1) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges2_15,axiom,
    ! [VarCurr] :
      ( v24179(VarCurr)
     => ( v24279(VarCurr,bitIndex1)
      <=> v25135(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges1_14,axiom,
    ! [VarCurr] :
      ( v24178(VarCurr)
     => ( v24279(VarCurr,bitIndex1)
      <=> v25132(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_13,axiom,
    ! [VarCurr] :
      ( v24177(VarCurr)
     => ( v24279(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(writeBinaryOperatorShiftedRanges_1218,axiom,
    ! [VarCurr] :
      ( v25135(VarCurr)
    <=> ( v24277(VarCurr,bitIndex1)
        | v24120(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1217,axiom,
    ! [VarCurr] :
      ( v25132(VarCurr)
    <=> ( v24277(VarCurr,bitIndex1)
        | v25133(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1216,axiom,
    ! [VarCurr] :
      ( v25133(VarCurr)
    <=> ( v24120(VarCurr,bitIndex0)
        | v24120(VarCurr,bitIndex1) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_41,axiom,
    ! [VarCurr] :
      ( ( ~ v24177(VarCurr)
        & ~ v24178(VarCurr)
        & ~ v24179(VarCurr) )
     => ( v24279(VarCurr,bitIndex0)
      <=> v24277(VarCurr,bitIndex0) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_107,axiom,
    ! [VarCurr] :
      ( v24179(VarCurr)
     => ( v24279(VarCurr,bitIndex0)
      <=> v25130(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_573,axiom,
    ! [VarCurr] :
      ( v24178(VarCurr)
     => ( v24279(VarCurr,bitIndex0)
      <=> v25129(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_574,axiom,
    ! [VarCurr] :
      ( v24177(VarCurr)
     => ( v24279(VarCurr,bitIndex0)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4396,axiom,
    ! [VarCurr] :
      ( v25130(VarCurr)
    <=> ( v24277(VarCurr,bitIndex0)
        | v24120(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4395,axiom,
    ! [VarCurr] :
      ( v25129(VarCurr)
    <=> ( v24277(VarCurr,bitIndex0)
        | v24281(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_933,axiom,
    ! [B] :
      ( range_2_0(B)
     => ( v24277(constB0,B)
      <=> $false ) ) ).

fof(addAssignment_11028,axiom,
    ! [VarCurr] :
      ( v24120(VarCurr,bitIndex2)
    <=> v24170(VarCurr,bitIndex2) ) ).

fof(addAssignment_11027,axiom,
    ! [VarCurr] :
      ( v24122(VarCurr,bitIndex2)
    <=> v24124(VarCurr,bitIndex2) ) ).

fof(addAssignment_11026,axiom,
    ! [VarCurr] :
      ( v24124(VarCurr,bitIndex2)
    <=> v24126(VarCurr,bitIndex2) ) ).

fof(addAssignment_11025,axiom,
    ! [VarCurr] :
      ( v24126(VarCurr,bitIndex2)
    <=> v24128(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges_1215,axiom,
    ! [VarCurr] :
      ( v24128(VarCurr,bitIndex2)
    <=> ( v25126(VarCurr)
        | v24384(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1214,axiom,
    ! [VarCurr] :
      ( v25126(VarCurr)
    <=> ( v25127(VarCurr)
        | v24384(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1213,axiom,
    ! [VarCurr] :
      ( v25127(VarCurr)
    <=> ( v24384(VarCurr,bitIndex0)
        | v24384(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1212,axiom,
    ! [VarCurr] :
      ( v24384(VarCurr,bitIndex3)
    <=> ( v24967(VarCurr)
      <~> v25123(VarCurr) ) ) ).

fof(writeUnaryOperator_2296,axiom,
    ! [VarCurr] :
      ( ~ v25123(VarCurr)
    <=> v24416(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4394,axiom,
    ! [VarCurr] :
      ( v24967(VarCurr)
    <=> ( v24969(VarCurr)
        & v25122(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4393,axiom,
    ! [VarCurr] :
      ( v25122(VarCurr)
    <=> ( v24971(VarCurr)
        | v25047(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4392,axiom,
    ! [VarCurr] :
      ( v24969(VarCurr)
    <=> ( v24970(VarCurr)
        | v25046(VarCurr) ) ) ).

fof(writeUnaryOperator_2295,axiom,
    ! [VarCurr] :
      ( ~ v25046(VarCurr)
    <=> v25047(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4391,axiom,
    ! [VarCurr] :
      ( v25047(VarCurr)
    <=> ( v25048(VarCurr)
        & v25121(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4390,axiom,
    ! [VarCurr] :
      ( v25121(VarCurr)
    <=> ( v25050(VarCurr)
        | v25066(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4389,axiom,
    ! [VarCurr] :
      ( v25048(VarCurr)
    <=> ( v25049(VarCurr)
        | v25065(VarCurr) ) ) ).

fof(writeUnaryOperator_2294,axiom,
    ! [VarCurr] :
      ( ~ v25065(VarCurr)
    <=> v25066(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4388,axiom,
    ! [VarCurr] :
      ( v25066(VarCurr)
    <=> ( v25067(VarCurr)
        & v25120(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4387,axiom,
    ! [VarCurr] :
      ( v25120(VarCurr)
    <=> ( v25069(VarCurr)
        | v25085(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4386,axiom,
    ! [VarCurr] :
      ( v25067(VarCurr)
    <=> ( v25068(VarCurr)
        | v25084(VarCurr) ) ) ).

fof(writeUnaryOperator_2293,axiom,
    ! [VarCurr] :
      ( ~ v25084(VarCurr)
    <=> v25085(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4385,axiom,
    ! [VarCurr] :
      ( v25085(VarCurr)
    <=> ( v25086(VarCurr)
        & v25119(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4384,axiom,
    ! [VarCurr] :
      ( v25119(VarCurr)
    <=> ( v25088(VarCurr)
        | v25104(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4383,axiom,
    ! [VarCurr] :
      ( v25086(VarCurr)
    <=> ( v25087(VarCurr)
        | v25103(VarCurr) ) ) ).

fof(writeUnaryOperator_2292,axiom,
    ! [VarCurr] :
      ( ~ v25103(VarCurr)
    <=> v25104(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4382,axiom,
    ! [VarCurr] :
      ( v25104(VarCurr)
    <=> ( v25105(VarCurr)
        & v25118(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1211,axiom,
    ! [VarCurr] :
      ( v25118(VarCurr)
    <=> ( v24386(VarCurr,bitIndex119)
        | v25108(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4381,axiom,
    ! [VarCurr] :
      ( v25105(VarCurr)
    <=> ( v25106(VarCurr)
        | v25107(VarCurr) ) ) ).

fof(writeUnaryOperator_2291,axiom,
    ! [VarCurr] :
      ( ~ v25107(VarCurr)
    <=> v25108(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4380,axiom,
    ! [VarCurr] :
      ( v25108(VarCurr)
    <=> ( v25109(VarCurr)
        & v25117(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1210,axiom,
    ! [VarCurr] :
      ( v25117(VarCurr)
    <=> ( v24386(VarCurr,bitIndex118)
        | v25112(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4379,axiom,
    ! [VarCurr] :
      ( v25109(VarCurr)
    <=> ( v25110(VarCurr)
        | v25111(VarCurr) ) ) ).

fof(writeUnaryOperator_2290,axiom,
    ! [VarCurr] :
      ( ~ v25111(VarCurr)
    <=> v25112(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4378,axiom,
    ! [VarCurr] :
      ( v25112(VarCurr)
    <=> ( v25113(VarCurr)
        & v25116(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1209,axiom,
    ! [VarCurr] :
      ( v25116(VarCurr)
    <=> ( v24386(VarCurr,bitIndex116)
        | v24386(VarCurr,bitIndex117) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4377,axiom,
    ! [VarCurr] :
      ( v25113(VarCurr)
    <=> ( v25114(VarCurr)
        | v25115(VarCurr) ) ) ).

fof(writeUnaryOperator_2289,axiom,
    ! [VarCurr] :
      ( ~ v25115(VarCurr)
    <=> v24386(VarCurr,bitIndex117) ) ).

fof(writeUnaryOperator_2288,axiom,
    ! [VarCurr] :
      ( ~ v25114(VarCurr)
    <=> v24386(VarCurr,bitIndex116) ) ).

fof(writeUnaryOperator_2287,axiom,
    ! [VarCurr] :
      ( ~ v25110(VarCurr)
    <=> v24386(VarCurr,bitIndex118) ) ).

fof(writeUnaryOperator_2286,axiom,
    ! [VarCurr] :
      ( ~ v25106(VarCurr)
    <=> v24386(VarCurr,bitIndex119) ) ).

fof(writeUnaryOperator_2285,axiom,
    ! [VarCurr] :
      ( ~ v25087(VarCurr)
    <=> v25088(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4376,axiom,
    ! [VarCurr] :
      ( v25088(VarCurr)
    <=> ( v25089(VarCurr)
        & v25102(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1208,axiom,
    ! [VarCurr] :
      ( v25102(VarCurr)
    <=> ( v24386(VarCurr,bitIndex115)
        | v25092(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4375,axiom,
    ! [VarCurr] :
      ( v25089(VarCurr)
    <=> ( v25090(VarCurr)
        | v25091(VarCurr) ) ) ).

fof(writeUnaryOperator_2284,axiom,
    ! [VarCurr] :
      ( ~ v25091(VarCurr)
    <=> v25092(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4374,axiom,
    ! [VarCurr] :
      ( v25092(VarCurr)
    <=> ( v25093(VarCurr)
        & v25101(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1207,axiom,
    ! [VarCurr] :
      ( v25101(VarCurr)
    <=> ( v24386(VarCurr,bitIndex114)
        | v25096(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4373,axiom,
    ! [VarCurr] :
      ( v25093(VarCurr)
    <=> ( v25094(VarCurr)
        | v25095(VarCurr) ) ) ).

fof(writeUnaryOperator_2283,axiom,
    ! [VarCurr] :
      ( ~ v25095(VarCurr)
    <=> v25096(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4372,axiom,
    ! [VarCurr] :
      ( v25096(VarCurr)
    <=> ( v25097(VarCurr)
        & v25100(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1206,axiom,
    ! [VarCurr] :
      ( v25100(VarCurr)
    <=> ( v24386(VarCurr,bitIndex112)
        | v24386(VarCurr,bitIndex113) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4371,axiom,
    ! [VarCurr] :
      ( v25097(VarCurr)
    <=> ( v25098(VarCurr)
        | v25099(VarCurr) ) ) ).

fof(writeUnaryOperator_2282,axiom,
    ! [VarCurr] :
      ( ~ v25099(VarCurr)
    <=> v24386(VarCurr,bitIndex113) ) ).

fof(writeUnaryOperator_2281,axiom,
    ! [VarCurr] :
      ( ~ v25098(VarCurr)
    <=> v24386(VarCurr,bitIndex112) ) ).

fof(writeUnaryOperator_2280,axiom,
    ! [VarCurr] :
      ( ~ v25094(VarCurr)
    <=> v24386(VarCurr,bitIndex114) ) ).

fof(writeUnaryOperator_2279,axiom,
    ! [VarCurr] :
      ( ~ v25090(VarCurr)
    <=> v24386(VarCurr,bitIndex115) ) ).

fof(writeUnaryOperator_2278,axiom,
    ! [VarCurr] :
      ( ~ v25068(VarCurr)
    <=> v25069(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4370,axiom,
    ! [VarCur