%------------------------------------------------------------------------------
% File     : HWV105+1 : TPTP v9.2.0. Released v6.1.0.
% Domain   : Hardware Verification
% Problem  : dmu_dmc property 17 cone of influence 5_b20
% Version  : Especial.
% English  : Verification of a property of the SPARCT2 RTL hardware design.

% Refs     : [Kha14] Khasidashvili (2014), Email to Geoff Sutcliffe
% Source   : [Kha14]
% Names    : dmu_dmc_prop17_cone5_b20 [Kha14]

% Status   : CounterSatisfiable
% Rating   : 0.67 v8.2.0, 0.33 v7.4.0, 0.67 v7.3.0, 1.00 v6.1.0
% Syntax   : Number of formulae    : 6490 (2027 unt;   0 def)
%            Number of atoms       : 23461 ( 989 equ)
%            Maximal formula atoms :  264 (   3 avg)
%            Number of connectives : 19437 (2466   ~;1507   |;4697   &)
%                                         (8858 <=>;1906  =>;   0  <=;   3 <~>)
%            Maximal formula depth :  136 (   4 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of predicates  : 3429 (3426 usr;   2 prp; 0-3 aty)
%            Number of functors    :  809 ( 809 usr; 809 con; 0-0 aty)
%            Number of variables   : 5463 (5463   !;   0   ?)
% SPC      : FOF_CSA_RFO_SEQ

% Comments : Copyright 2013 Moshe Emmer and Zurab Khasidashvili
%            Licensed under the Apache License, Version 2.0 (the "License");
%            you may not use this file except in compliance with the License.
%            You may obtain a copy of the License at
%                http://www.apache.org/licenses/LICENSE-2.0
%            Unless required by applicable law or agreed to in writing,
%            software distributed under the License is distributed on an "AS
%            IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
%            express or implied. See the License for the specific language
%            governing permissions and limitations under the License.
%------------------------------------------------------------------------------
fof(pathAxiom_8,axiom,
    nextState(constB8,constB9) ).

fof(pathAxiom_7,axiom,
    nextState(constB7,constB8) ).

fof(pathAxiom_6,axiom,
    nextState(constB6,constB7) ).

fof(pathAxiom_5,axiom,
    nextState(constB5,constB6) ).

fof(pathAxiom_4,axiom,
    nextState(constB4,constB5) ).

fof(pathAxiom_3,axiom,
    nextState(constB3,constB4) ).

fof(pathAxiom_2,axiom,
    nextState(constB2,constB3) ).

fof(pathAxiom_1,axiom,
    nextState(constB1,constB2) ).

fof(pathAxiom,axiom,
    nextState(constB0,constB1) ).

fof(reachableStateAxiom_22,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( reachableState(VarCurr)
        & reachableState(VarNext) ) ) ).

fof(reachableStateAxiom_21,axiom,
    ! [VarState] :
      ( reachableState(VarState)
     => ( constB0 = VarState
        | constB1 = VarState
        | constB2 = VarState
        | constB3 = VarState
        | constB4 = VarState
        | constB5 = VarState
        | constB6 = VarState
        | constB7 = VarState
        | constB8 = VarState
        | constB9 = VarState
        | constB10 = VarState
        | constB11 = VarState
        | constB12 = VarState
        | constB13 = VarState
        | constB14 = VarState
        | constB15 = VarState
        | constB16 = VarState
        | constB17 = VarState
        | constB18 = VarState
        | constB19 = VarState
        | constB20 = VarState ) ) ).

fof(reachableStateAxiom_20,axiom,
    reachableState(constB20) ).

fof(reachableStateAxiom_19,axiom,
    reachableState(constB19) ).

fof(reachableStateAxiom_18,axiom,
    reachableState(constB18) ).

fof(reachableStateAxiom_17,axiom,
    reachableState(constB17) ).

fof(reachableStateAxiom_16,axiom,
    reachableState(constB16) ).

fof(reachableStateAxiom_15,axiom,
    reachableState(constB15) ).

fof(reachableStateAxiom_14,axiom,
    reachableState(constB14) ).

fof(reachableStateAxiom_13,axiom,
    reachableState(constB13) ).

fof(reachableStateAxiom_12,axiom,
    reachableState(constB12) ).

fof(reachableStateAxiom_11,axiom,
    reachableState(constB11) ).

fof(reachableStateAxiom_10,axiom,
    reachableState(constB10) ).

fof(reachableStateAxiom_9,axiom,
    reachableState(constB9) ).

fof(reachableStateAxiom_8,axiom,
    reachableState(constB8) ).

fof(reachableStateAxiom_7,axiom,
    reachableState(constB7) ).

fof(reachableStateAxiom_6,axiom,
    reachableState(constB6) ).

fof(reachableStateAxiom_5,axiom,
    reachableState(constB5) ).

fof(reachableStateAxiom_4,axiom,
    reachableState(constB4) ).

fof(reachableStateAxiom_3,axiom,
    reachableState(constB3) ).

fof(reachableStateAxiom_2,axiom,
    reachableState(constB2) ).

fof(reachableStateAxiom_1,axiom,
    reachableState(constB1) ).

fof(reachableStateAxiom,axiom,
    reachableState(constB0) ).

fof(clock_toggling,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1(VarCurr)
      <=> ~ v1(VarNext) ) ) ).

fof(clock_pattern,axiom,
    ~ v1(constB0) ).

fof(transient_address_definition_41,axiom,
    ! [B] :
      ( addressVal(v1045_range_2_to_0_address_term_bound_20,B)
    <=> v1045(constB20,B) ) ).

fof(is_address_49,axiom,
    address(v1045_range_2_to_0_address_term_bound_20) ).

fof(address_association_41,axiom,
    v1045_range_2_to_0_address_association(constB20,v1045_range_2_to_0_address_term_bound_20) ).

fof(transient_address_definition_40,axiom,
    ! [B] :
      ( addressVal(v1045_range_2_to_0_address_term_bound_19,B)
    <=> v1045(constB19,B) ) ).

fof(is_address_48,axiom,
    address(v1045_range_2_to_0_address_term_bound_19) ).

fof(address_association_40,axiom,
    v1045_range_2_to_0_address_association(constB19,v1045_range_2_to_0_address_term_bound_19) ).

fof(transient_address_definition_39,axiom,
    ! [B] :
      ( addressVal(v1045_range_2_to_0_address_term_bound_18,B)
    <=> v1045(constB18,B) ) ).

fof(is_address_47,axiom,
    address(v1045_range_2_to_0_address_term_bound_18) ).

fof(address_association_39,axiom,
    v1045_range_2_to_0_address_association(constB18,v1045_range_2_to_0_address_term_bound_18) ).

fof(transient_address_definition_38,axiom,
    ! [B] :
      ( addressVal(v1045_range_2_to_0_address_term_bound_17,B)
    <=> v1045(constB17,B) ) ).

fof(is_address_46,axiom,
    address(v1045_range_2_to_0_address_term_bound_17) ).

fof(address_association_38,axiom,
    v1045_range_2_to_0_address_association(constB17,v1045_range_2_to_0_address_term_bound_17) ).

fof(transient_address_definition_37,axiom,
    ! [B] :
      ( addressVal(v1045_range_2_to_0_address_term_bound_16,B)
    <=> v1045(constB16,B) ) ).

fof(is_address_45,axiom,
    address(v1045_range_2_to_0_address_term_bound_16) ).

fof(address_association_37,axiom,
    v1045_range_2_to_0_address_association(constB16,v1045_range_2_to_0_address_term_bound_16) ).

fof(transient_address_definition_36,axiom,
    ! [B] :
      ( addressVal(v1045_range_2_to_0_address_term_bound_15,B)
    <=> v1045(constB15,B) ) ).

fof(is_address_44,axiom,
    address(v1045_range_2_to_0_address_term_bound_15) ).

fof(address_association_36,axiom,
    v1045_range_2_to_0_address_association(constB15,v1045_range_2_to_0_address_term_bound_15) ).

fof(transient_address_definition_35,axiom,
    ! [B] :
      ( addressVal(v1045_range_2_to_0_address_term_bound_14,B)
    <=> v1045(constB14,B) ) ).

fof(is_address_43,axiom,
    address(v1045_range_2_to_0_address_term_bound_14) ).

fof(address_association_35,axiom,
    v1045_range_2_to_0_address_association(constB14,v1045_range_2_to_0_address_term_bound_14) ).

fof(transient_address_definition_34,axiom,
    ! [B] :
      ( addressVal(v1045_range_2_to_0_address_term_bound_13,B)
    <=> v1045(constB13,B) ) ).

fof(is_address_42,axiom,
    address(v1045_range_2_to_0_address_term_bound_13) ).

fof(address_association_34,axiom,
    v1045_range_2_to_0_address_association(constB13,v1045_range_2_to_0_address_term_bound_13) ).

fof(transient_address_definition_33,axiom,
    ! [B] :
      ( addressVal(v1045_range_2_to_0_address_term_bound_12,B)
    <=> v1045(constB12,B) ) ).

fof(is_address_41,axiom,
    address(v1045_range_2_to_0_address_term_bound_12) ).

fof(address_association_33,axiom,
    v1045_range_2_to_0_address_association(constB12,v1045_range_2_to_0_address_term_bound_12) ).

fof(transient_address_definition_32,axiom,
    ! [B] :
      ( addressVal(v1045_range_2_to_0_address_term_bound_11,B)
    <=> v1045(constB11,B) ) ).

fof(is_address_40,axiom,
    address(v1045_range_2_to_0_address_term_bound_11) ).

fof(address_association_32,axiom,
    v1045_range_2_to_0_address_association(constB11,v1045_range_2_to_0_address_term_bound_11) ).

fof(transient_address_definition_31,axiom,
    ! [B] :
      ( addressVal(v1045_range_2_to_0_address_term_bound_10,B)
    <=> v1045(constB10,B) ) ).

fof(is_address_39,axiom,
    address(v1045_range_2_to_0_address_term_bound_10) ).

fof(address_association_31,axiom,
    v1045_range_2_to_0_address_association(constB10,v1045_range_2_to_0_address_term_bound_10) ).

fof(transient_address_definition_30,axiom,
    ! [B] :
      ( addressVal(v1045_range_2_to_0_address_term_bound_9,B)
    <=> v1045(constB9,B) ) ).

fof(is_address_38,axiom,
    address(v1045_range_2_to_0_address_term_bound_9) ).

fof(address_association_30,axiom,
    v1045_range_2_to_0_address_association(constB9,v1045_range_2_to_0_address_term_bound_9) ).

fof(transient_address_definition_29,axiom,
    ! [B] :
      ( addressVal(v1045_range_2_to_0_address_term_bound_8,B)
    <=> v1045(constB8,B) ) ).

fof(is_address_37,axiom,
    address(v1045_range_2_to_0_address_term_bound_8) ).

fof(address_association_29,axiom,
    v1045_range_2_to_0_address_association(constB8,v1045_range_2_to_0_address_term_bound_8) ).

fof(transient_address_definition_28,axiom,
    ! [B] :
      ( addressVal(v1045_range_2_to_0_address_term_bound_7,B)
    <=> v1045(constB7,B) ) ).

fof(is_address_36,axiom,
    address(v1045_range_2_to_0_address_term_bound_7) ).

fof(address_association_28,axiom,
    v1045_range_2_to_0_address_association(constB7,v1045_range_2_to_0_address_term_bound_7) ).

fof(transient_address_definition_27,axiom,
    ! [B] :
      ( addressVal(v1045_range_2_to_0_address_term_bound_6,B)
    <=> v1045(constB6,B) ) ).

fof(is_address_35,axiom,
    address(v1045_range_2_to_0_address_term_bound_6) ).

fof(address_association_27,axiom,
    v1045_range_2_to_0_address_association(constB6,v1045_range_2_to_0_address_term_bound_6) ).

fof(transient_address_definition_26,axiom,
    ! [B] :
      ( addressVal(v1045_range_2_to_0_address_term_bound_5,B)
    <=> v1045(constB5,B) ) ).

fof(is_address_34,axiom,
    address(v1045_range_2_to_0_address_term_bound_5) ).

fof(address_association_26,axiom,
    v1045_range_2_to_0_address_association(constB5,v1045_range_2_to_0_address_term_bound_5) ).

fof(transient_address_definition_25,axiom,
    ! [B] :
      ( addressVal(v1045_range_2_to_0_address_term_bound_4,B)
    <=> v1045(constB4,B) ) ).

fof(is_address_33,axiom,
    address(v1045_range_2_to_0_address_term_bound_4) ).

fof(address_association_25,axiom,
    v1045_range_2_to_0_address_association(constB4,v1045_range_2_to_0_address_term_bound_4) ).

fof(transient_address_definition_24,axiom,
    ! [B] :
      ( addressVal(v1045_range_2_to_0_address_term_bound_3,B)
    <=> v1045(constB3,B) ) ).

fof(is_address_32,axiom,
    address(v1045_range_2_to_0_address_term_bound_3) ).

fof(address_association_24,axiom,
    v1045_range_2_to_0_address_association(constB3,v1045_range_2_to_0_address_term_bound_3) ).

fof(transient_address_definition_23,axiom,
    ! [B] :
      ( addressVal(v1045_range_2_to_0_address_term_bound_2,B)
    <=> v1045(constB2,B) ) ).

fof(is_address_31,axiom,
    address(v1045_range_2_to_0_address_term_bound_2) ).

fof(address_association_23,axiom,
    v1045_range_2_to_0_address_association(constB2,v1045_range_2_to_0_address_term_bound_2) ).

fof(transient_address_definition_22,axiom,
    ! [B] :
      ( addressVal(v1045_range_2_to_0_address_term_bound_1,B)
    <=> v1045(constB1,B) ) ).

fof(is_address_30,axiom,
    address(v1045_range_2_to_0_address_term_bound_1) ).

fof(address_association_22,axiom,
    v1045_range_2_to_0_address_association(constB1,v1045_range_2_to_0_address_term_bound_1) ).

fof(transient_address_definition_21,axiom,
    ! [B] :
      ( addressVal(v1045_range_2_to_0_address_term_bound_0,B)
    <=> v1045(constB0,B) ) ).

fof(is_address_29,axiom,
    address(v1045_range_2_to_0_address_term_bound_0) ).

fof(address_association_21,axiom,
    v1045_range_2_to_0_address_association(constB0,v1045_range_2_to_0_address_term_bound_0) ).

fof(is_address_28,axiom,
    address(b110_address_term) ).

fof(constant_address_definition_7,axiom,
    ! [B] :
      ( addressVal(b110_address_term,B)
    <=> b110(B) ) ).

fof(is_address_27,axiom,
    address(b101_address_term) ).

fof(constant_address_definition_6,axiom,
    ! [B] :
      ( addressVal(b101_address_term,B)
    <=> b101(B) ) ).

fof(is_address_26,axiom,
    address(b100_address_term) ).

fof(constant_address_definition_5,axiom,
    ! [B] :
      ( addressVal(b100_address_term,B)
    <=> b100(B) ) ).

fof(is_address_25,axiom,
    address(b011_address_term) ).

fof(constant_address_definition_4,axiom,
    ! [B] :
      ( addressVal(b011_address_term,B)
    <=> b011(B) ) ).

fof(is_address_24,axiom,
    address(b010_address_term) ).

fof(constant_address_definition_3,axiom,
    ! [B] :
      ( addressVal(b010_address_term,B)
    <=> b010(B) ) ).

fof(is_address_23,axiom,
    address(b001_address_term) ).

fof(constant_address_definition_2,axiom,
    ! [B] :
      ( addressVal(b001_address_term,B)
    <=> b001(B) ) ).

fof(is_address_22,axiom,
    address(b111_address_term) ).

fof(constant_address_definition_1,axiom,
    ! [B] :
      ( addressVal(b111_address_term,B)
    <=> b111(B) ) ).

fof(transient_address_definition_20,axiom,
    ! [B] :
      ( addressVal(v977_range_2_to_0_address_term_bound_20,B)
    <=> v977(constB20,B) ) ).

fof(is_address_21,axiom,
    address(v977_range_2_to_0_address_term_bound_20) ).

fof(address_association_20,axiom,
    v977_range_2_to_0_address_association(constB20,v977_range_2_to_0_address_term_bound_20) ).

fof(transient_address_definition_19,axiom,
    ! [B] :
      ( addressVal(v977_range_2_to_0_address_term_bound_19,B)
    <=> v977(constB19,B) ) ).

fof(is_address_20,axiom,
    address(v977_range_2_to_0_address_term_bound_19) ).

fof(address_association_19,axiom,
    v977_range_2_to_0_address_association(constB19,v977_range_2_to_0_address_term_bound_19) ).

fof(transient_address_definition_18,axiom,
    ! [B] :
      ( addressVal(v977_range_2_to_0_address_term_bound_18,B)
    <=> v977(constB18,B) ) ).

fof(is_address_19,axiom,
    address(v977_range_2_to_0_address_term_bound_18) ).

fof(address_association_18,axiom,
    v977_range_2_to_0_address_association(constB18,v977_range_2_to_0_address_term_bound_18) ).

fof(transient_address_definition_17,axiom,
    ! [B] :
      ( addressVal(v977_range_2_to_0_address_term_bound_17,B)
    <=> v977(constB17,B) ) ).

fof(is_address_18,axiom,
    address(v977_range_2_to_0_address_term_bound_17) ).

fof(address_association_17,axiom,
    v977_range_2_to_0_address_association(constB17,v977_range_2_to_0_address_term_bound_17) ).

fof(transient_address_definition_16,axiom,
    ! [B] :
      ( addressVal(v977_range_2_to_0_address_term_bound_16,B)
    <=> v977(constB16,B) ) ).

fof(is_address_17,axiom,
    address(v977_range_2_to_0_address_term_bound_16) ).

fof(address_association_16,axiom,
    v977_range_2_to_0_address_association(constB16,v977_range_2_to_0_address_term_bound_16) ).

fof(transient_address_definition_15,axiom,
    ! [B] :
      ( addressVal(v977_range_2_to_0_address_term_bound_15,B)
    <=> v977(constB15,B) ) ).

fof(is_address_16,axiom,
    address(v977_range_2_to_0_address_term_bound_15) ).

fof(address_association_15,axiom,
    v977_range_2_to_0_address_association(constB15,v977_range_2_to_0_address_term_bound_15) ).

fof(transient_address_definition_14,axiom,
    ! [B] :
      ( addressVal(v977_range_2_to_0_address_term_bound_14,B)
    <=> v977(constB14,B) ) ).

fof(is_address_15,axiom,
    address(v977_range_2_to_0_address_term_bound_14) ).

fof(address_association_14,axiom,
    v977_range_2_to_0_address_association(constB14,v977_range_2_to_0_address_term_bound_14) ).

fof(transient_address_definition_13,axiom,
    ! [B] :
      ( addressVal(v977_range_2_to_0_address_term_bound_13,B)
    <=> v977(constB13,B) ) ).

fof(is_address_14,axiom,
    address(v977_range_2_to_0_address_term_bound_13) ).

fof(address_association_13,axiom,
    v977_range_2_to_0_address_association(constB13,v977_range_2_to_0_address_term_bound_13) ).

fof(transient_address_definition_12,axiom,
    ! [B] :
      ( addressVal(v977_range_2_to_0_address_term_bound_12,B)
    <=> v977(constB12,B) ) ).

fof(is_address_13,axiom,
    address(v977_range_2_to_0_address_term_bound_12) ).

fof(address_association_12,axiom,
    v977_range_2_to_0_address_association(constB12,v977_range_2_to_0_address_term_bound_12) ).

fof(transient_address_definition_11,axiom,
    ! [B] :
      ( addressVal(v977_range_2_to_0_address_term_bound_11,B)
    <=> v977(constB11,B) ) ).

fof(is_address_12,axiom,
    address(v977_range_2_to_0_address_term_bound_11) ).

fof(address_association_11,axiom,
    v977_range_2_to_0_address_association(constB11,v977_range_2_to_0_address_term_bound_11) ).

fof(transient_address_definition_10,axiom,
    ! [B] :
      ( addressVal(v977_range_2_to_0_address_term_bound_10,B)
    <=> v977(constB10,B) ) ).

fof(is_address_11,axiom,
    address(v977_range_2_to_0_address_term_bound_10) ).

fof(address_association_10,axiom,
    v977_range_2_to_0_address_association(constB10,v977_range_2_to_0_address_term_bound_10) ).

fof(transient_address_definition_9,axiom,
    ! [B] :
      ( addressVal(v977_range_2_to_0_address_term_bound_9,B)
    <=> v977(constB9,B) ) ).

fof(is_address_10,axiom,
    address(v977_range_2_to_0_address_term_bound_9) ).

fof(address_association_9,axiom,
    v977_range_2_to_0_address_association(constB9,v977_range_2_to_0_address_term_bound_9) ).

fof(transient_address_definition_8,axiom,
    ! [B] :
      ( addressVal(v977_range_2_to_0_address_term_bound_8,B)
    <=> v977(constB8,B) ) ).

fof(is_address_9,axiom,
    address(v977_range_2_to_0_address_term_bound_8) ).

fof(address_association_8,axiom,
    v977_range_2_to_0_address_association(constB8,v977_range_2_to_0_address_term_bound_8) ).

fof(transient_address_definition_7,axiom,
    ! [B] :
      ( addressVal(v977_range_2_to_0_address_term_bound_7,B)
    <=> v977(constB7,B) ) ).

fof(is_address_8,axiom,
    address(v977_range_2_to_0_address_term_bound_7) ).

fof(address_association_7,axiom,
    v977_range_2_to_0_address_association(constB7,v977_range_2_to_0_address_term_bound_7) ).

fof(transient_address_definition_6,axiom,
    ! [B] :
      ( addressVal(v977_range_2_to_0_address_term_bound_6,B)
    <=> v977(constB6,B) ) ).

fof(is_address_7,axiom,
    address(v977_range_2_to_0_address_term_bound_6) ).

fof(address_association_6,axiom,
    v977_range_2_to_0_address_association(constB6,v977_range_2_to_0_address_term_bound_6) ).

fof(transient_address_definition_5,axiom,
    ! [B] :
      ( addressVal(v977_range_2_to_0_address_term_bound_5,B)
    <=> v977(constB5,B) ) ).

fof(is_address_6,axiom,
    address(v977_range_2_to_0_address_term_bound_5) ).

fof(address_association_5,axiom,
    v977_range_2_to_0_address_association(constB5,v977_range_2_to_0_address_term_bound_5) ).

fof(transient_address_definition_4,axiom,
    ! [B] :
      ( addressVal(v977_range_2_to_0_address_term_bound_4,B)
    <=> v977(constB4,B) ) ).

fof(is_address_5,axiom,
    address(v977_range_2_to_0_address_term_bound_4) ).

fof(address_association_4,axiom,
    v977_range_2_to_0_address_association(constB4,v977_range_2_to_0_address_term_bound_4) ).

fof(transient_address_definition_3,axiom,
    ! [B] :
      ( addressVal(v977_range_2_to_0_address_term_bound_3,B)
    <=> v977(constB3,B) ) ).

fof(is_address_4,axiom,
    address(v977_range_2_to_0_address_term_bound_3) ).

fof(address_association_3,axiom,
    v977_range_2_to_0_address_association(constB3,v977_range_2_to_0_address_term_bound_3) ).

fof(transient_address_definition_2,axiom,
    ! [B] :
      ( addressVal(v977_range_2_to_0_address_term_bound_2,B)
    <=> v977(constB2,B) ) ).

fof(is_address_3,axiom,
    address(v977_range_2_to_0_address_term_bound_2) ).

fof(address_association_2,axiom,
    v977_range_2_to_0_address_association(constB2,v977_range_2_to_0_address_term_bound_2) ).

fof(transient_address_definition_1,axiom,
    ! [B] :
      ( addressVal(v977_range_2_to_0_address_term_bound_1,B)
    <=> v977(constB1,B) ) ).

fof(is_address_2,axiom,
    address(v977_range_2_to_0_address_term_bound_1) ).

fof(address_association_1,axiom,
    v977_range_2_to_0_address_association(constB1,v977_range_2_to_0_address_term_bound_1) ).

fof(transient_address_definition,axiom,
    ! [B] :
      ( addressVal(v977_range_2_to_0_address_term_bound_0,B)
    <=> v977(constB0,B) ) ).

fof(is_address_1,axiom,
    address(v977_range_2_to_0_address_term_bound_0) ).

fof(address_association,axiom,
    v977_range_2_to_0_address_association(constB0,v977_range_2_to_0_address_term_bound_0) ).

fof(is_address,axiom,
    address(b000_address_term) ).

fof(constant_address_definition,axiom,
    ! [B] :
      ( addressVal(b000_address_term,B)
    <=> b000(B) ) ).

fof(addressDiff,axiom,
    ! [B,A2,A1] :
      ( ( address(A1)
        & address(A2)
        & addressDiff(A1,A2,B) )
     => ( A1 = A2
        | ( addressVal(A1,B)
        <=> ~ addressVal(A2,B) ) ) ) ).

fof(addressDomain,axiom,
    ! [A1,A2] :
      ( addressDiff(A1,A2,bitIndex0)
      | addressDiff(A1,A2,bitIndex1)
      | addressDiff(A1,A2,bitIndex2) ) ).

fof(addAssertion,conjecture,
    ! [VarCurr] :
      ( reachableState(VarCurr)
     => v4(VarCurr) ) ).

fof(writeUnaryOperator_395,axiom,
    ! [VarCurr] :
      ( ~ v4(VarCurr)
    <=> v5182(VarCurr) ) ).

fof(writeUnaryOperator_394,axiom,
    ! [VarCurr] :
      ( ~ v5182(VarCurr)
    <=> v5183(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_813,axiom,
    ! [VarCurr] :
      ( v5183(VarCurr)
    <=> ( v5185(VarCurr)
        & v5207(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_287,axiom,
    ! [VarCurr] :
      ( v5207(VarCurr)
    <=> ( v5208(VarCurr)
        | v6(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_286,axiom,
    ! [VarCurr] :
      ( v5208(VarCurr)
    <=> ( v5209(VarCurr)
        | v6(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_285,axiom,
    ! [VarCurr] :
      ( v5209(VarCurr)
    <=> ( v5210(VarCurr)
        | v6(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_284,axiom,
    ! [VarCurr] :
      ( v5210(VarCurr)
    <=> ( v6(VarCurr,bitIndex0)
        | v6(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_812,axiom,
    ! [VarCurr] :
      ( v5185(VarCurr)
    <=> ( v5186(VarCurr)
        | v5195(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_811,axiom,
    ! [VarCurr] :
      ( v5195(VarCurr)
    <=> ( v5196(VarCurr)
        | v5197(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_810,axiom,
    ! [VarCurr] :
      ( v5197(VarCurr)
    <=> ( v5187(VarCurr)
        & v5198(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_809,axiom,
    ! [VarCurr] :
      ( v5198(VarCurr)
    <=> ( v5199(VarCurr)
        | v5200(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_808,axiom,
    ! [VarCurr] :
      ( v5200(VarCurr)
    <=> ( v5189(VarCurr)
        & v5201(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_807,axiom,
    ! [VarCurr] :
      ( v5201(VarCurr)
    <=> ( v5202(VarCurr)
        | v5203(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_806,axiom,
    ! [VarCurr] :
      ( v5203(VarCurr)
    <=> ( v5191(VarCurr)
        & v5204(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_805,axiom,
    ! [VarCurr] :
      ( v5204(VarCurr)
    <=> ( v5205(VarCurr)
        | v5206(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_804,axiom,
    ! [VarCurr] :
      ( v5206(VarCurr)
    <=> ( v6(VarCurr,bitIndex0)
        & v5194(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_283,axiom,
    ! [VarCurr] :
      ( v5205(VarCurr)
    <=> ( v5193(VarCurr)
        & v6(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_282,axiom,
    ! [VarCurr] :
      ( v5202(VarCurr)
    <=> ( v6(VarCurr,bitIndex2)
        & v5192(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_281,axiom,
    ! [VarCurr] :
      ( v5199(VarCurr)
    <=> ( v6(VarCurr,bitIndex3)
        & v5190(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_280,axiom,
    ! [VarCurr] :
      ( v5196(VarCurr)
    <=> ( v6(VarCurr,bitIndex4)
        & v5188(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_803,axiom,
    ! [VarCurr] :
      ( v5186(VarCurr)
    <=> ( v5187(VarCurr)
        & v5188(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_802,axiom,
    ! [VarCurr] :
      ( v5188(VarCurr)
    <=> ( v5189(VarCurr)
        & v5190(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_801,axiom,
    ! [VarCurr] :
      ( v5190(VarCurr)
    <=> ( v5191(VarCurr)
        & v5192(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_800,axiom,
    ! [VarCurr] :
      ( v5192(VarCurr)
    <=> ( v5193(VarCurr)
        & v5194(VarCurr) ) ) ).

fof(writeUnaryOperator_393,axiom,
    ! [VarCurr] :
      ( ~ v5194(VarCurr)
    <=> v6(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_392,axiom,
    ! [VarCurr] :
      ( ~ v5193(VarCurr)
    <=> v6(VarCurr,bitIndex0) ) ).

fof(writeUnaryOperator_391,axiom,
    ! [VarCurr] :
      ( ~ v5191(VarCurr)
    <=> v6(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_390,axiom,
    ! [VarCurr] :
      ( ~ v5189(VarCurr)
    <=> v6(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_389,axiom,
    ! [VarCurr] :
      ( ~ v5187(VarCurr)
    <=> v6(VarCurr,bitIndex4) ) ).

fof(addCaseBooleanConditionEqualRanges1_66,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5170(VarNext)
       => ! [B] :
            ( range_4_1(B)
           => ( v6(VarNext,B)
            <=> v6(VarCurr,B) ) ) ) ) ).

fof(range_axiom_38,axiom,
    ! [B] :
      ( range_4_1(B)
    <=> ( $false
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B ) ) ).

fof(addCaseBooleanConditionShiftedRanges0_3,axiom,
    ! [VarNext] :
      ( v5170(VarNext)
     => ( ( v6(VarNext,bitIndex4)
        <=> v5178(VarNext,bitIndex3) )
        & ( v6(VarNext,bitIndex3)
        <=> v5178(VarNext,bitIndex2) )
        & ( v6(VarNext,bitIndex2)
        <=> v5178(VarNext,bitIndex1) )
        & ( v6(VarNext,bitIndex1)
        <=> v5178(VarNext,bitIndex0) ) ) ) ).

fof(addAssignment_1554,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v5178(VarNext,B)
          <=> v5176(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_41,axiom,
    ! [VarCurr] :
      ( ~ v5165(VarCurr)
     => ( ( v5176(VarCurr,bitIndex3)
        <=> v19(VarCurr,bitIndex4) )
        & ( v5176(VarCurr,bitIndex2)
        <=> v19(VarCurr,bitIndex3) )
        & ( v5176(VarCurr,bitIndex1)
        <=> v19(VarCurr,bitIndex2) )
        & ( v5176(VarCurr,bitIndex0)
        <=> v19(VarCurr,bitIndex1) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_170,axiom,
    ! [VarCurr] :
      ( v5165(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v5176(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_799,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5170(VarNext)
      <=> v5171(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_798,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5171(VarNext)
      <=> ( v5173(VarNext)
          & v1252(VarNext) ) ) ) ).

fof(writeUnaryOperator_388,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5173(VarNext)
      <=> v1259(VarNext) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_65,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5156(VarNext)
       => ( v6(VarNext,bitIndex0)
        <=> v6(VarCurr,bitIndex0) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_73,axiom,
    ! [VarNext] :
      ( v5156(VarNext)
     => ( v6(VarNext,bitIndex0)
      <=> v5164(VarNext) ) ) ).

fof(addAssignment_1553,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5164(VarNext)
      <=> v5162(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_138,axiom,
    ! [VarCurr] :
      ( ~ v5165(VarCurr)
     => ( v5162(VarCurr)
      <=> v19(VarCurr,bitIndex0) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_169,axiom,
    ! [VarCurr] :
      ( v5165(VarCurr)
     => ( v5162(VarCurr)
      <=> $true ) ) ).

fof(writeUnaryOperator_387,axiom,
    ! [VarCurr] :
      ( ~ v5165(VarCurr)
    <=> v8(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_797,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5156(VarNext)
      <=> v5157(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_796,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5157(VarNext)
      <=> ( v5158(VarNext)
          & v1252(VarNext) ) ) ) ).

fof(writeUnaryOperator_386,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5158(VarNext)
      <=> v1259(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_40,axiom,
    ! [VarCurr] :
      ( ~ v5144(VarCurr)
     => ( v19(VarCurr,bitIndex4)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_9,axiom,
    ! [VarCurr] :
      ( v5144(VarCurr)
     => ( v19(VarCurr,bitIndex4)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_795,axiom,
    ! [VarCurr] :
      ( v5144(VarCurr)
    <=> ( v5145(VarCurr)
        | v5148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_794,axiom,
    ! [VarCurr] :
      ( v5148(VarCurr)
    <=> ( v5149(VarCurr)
        & v1348(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_793,axiom,
    ! [VarCurr] :
      ( v5149(VarCurr)
    <=> ( v5150(VarCurr)
        | v5152(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_339,axiom,
    ! [VarCurr] :
      ( v5152(VarCurr)
    <=> ( ( v5153(VarCurr,bitIndex1)
        <=> $false )
        & ( v5153(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1552,axiom,
    ! [VarCurr] :
      ( v5153(VarCurr,bitIndex0)
    <=> v1308(VarCurr) ) ).

fof(addAssignment_1551,axiom,
    ! [VarCurr] :
      ( v5153(VarCurr,bitIndex1)
    <=> v1193(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_338,axiom,
    ! [VarCurr] :
      ( v5150(VarCurr)
    <=> ( ( v5151(VarCurr,bitIndex1)
        <=> $false )
        & ( v5151(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1550,axiom,
    ! [VarCurr] :
      ( v5151(VarCurr,bitIndex0)
    <=> v1308(VarCurr) ) ).

fof(addAssignment_1549,axiom,
    ! [VarCurr] :
      ( v5151(VarCurr,bitIndex1)
    <=> v1193(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_792,axiom,
    ! [VarCurr] :
      ( v5145(VarCurr)
    <=> ( v5146(VarCurr)
        & v1344(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_337,axiom,
    ! [VarCurr] :
      ( v5146(VarCurr)
    <=> ( ( v5147(VarCurr,bitIndex1)
        <=> $true )
        & ( v5147(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1548,axiom,
    ! [VarCurr] :
      ( v5147(VarCurr,bitIndex0)
    <=> v1193(VarCurr) ) ).

fof(addAssignment_1547,axiom,
    ! [VarCurr] :
      ( v5147(VarCurr,bitIndex1)
    <=> v1272(VarCurr) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_39,axiom,
    ! [VarCurr] :
      ( ~ v5139(VarCurr)
     => ( v19(VarCurr,bitIndex3)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_8,axiom,
    ! [VarCurr] :
      ( v5139(VarCurr)
     => ( v19(VarCurr,bitIndex3)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_791,axiom,
    ! [VarCurr] :
      ( v5139(VarCurr)
    <=> ( v5140(VarCurr)
        | v5142(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_790,axiom,
    ! [VarCurr] :
      ( v5142(VarCurr)
    <=> ( v1336(VarCurr)
        & v1344(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_789,axiom,
    ! [VarCurr] :
      ( v5140(VarCurr)
    <=> ( v5141(VarCurr)
        & v1323(VarCurr) ) ) ).

fof(writeUnaryOperator_385,axiom,
    ! [VarCurr] :
      ( ~ v5141(VarCurr)
    <=> v1193(VarCurr) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_38,axiom,
    ! [VarCurr] :
      ( ~ v5135(VarCurr)
     => ( v19(VarCurr,bitIndex2)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_7,axiom,
    ! [VarCurr] :
      ( v5135(VarCurr)
     => ( v19(VarCurr,bitIndex2)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_788,axiom,
    ! [VarCurr] :
      ( v5135(VarCurr)
    <=> ( v5136(VarCurr)
        | v5137(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_787,axiom,
    ! [VarCurr] :
      ( v5137(VarCurr)
    <=> ( v1326(VarCurr)
        & v1333(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_786,axiom,
    ! [VarCurr] :
      ( v5136(VarCurr)
    <=> ( v1193(VarCurr)
        & v1323(VarCurr) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_37,axiom,
    ! [VarCurr] :
      ( ~ v5125(VarCurr)
     => ( v19(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_6,axiom,
    ! [VarCurr] :
      ( v5125(VarCurr)
     => ( v19(VarCurr,bitIndex1)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_785,axiom,
    ! [VarCurr] :
      ( v5125(VarCurr)
    <=> ( v5126(VarCurr)
        | v5133(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_784,axiom,
    ! [VarCurr] :
      ( v5133(VarCurr)
    <=> ( v1346(VarCurr)
        & v1348(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_783,axiom,
    ! [VarCurr] :
      ( v5126(VarCurr)
    <=> ( v5127(VarCurr)
        | v5131(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_782,axiom,
    ! [VarCurr] :
      ( v5131(VarCurr)
    <=> ( v5132(VarCurr)
        & v1344(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_781,axiom,
    ! [VarCurr] :
      ( v5132(VarCurr)
    <=> ( v1308(VarCurr)
        & v1342(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_780,axiom,
    ! [VarCurr] :
      ( v5127(VarCurr)
    <=> ( v5128(VarCurr)
        | v5130(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_779,axiom,
    ! [VarCurr] :
      ( v5130(VarCurr)
    <=> ( v1331(VarCurr)
        & v1333(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_778,axiom,
    ! [VarCurr] :
      ( v5128(VarCurr)
    <=> ( v5129(VarCurr)
        & v1322(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_777,axiom,
    ! [VarCurr] :
      ( v5129(VarCurr)
    <=> ( v1317(VarCurr)
        & v1320(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_137,axiom,
    ! [VarCurr] :
      ( ~ v5112(VarCurr)
     => ( v19(VarCurr,bitIndex0)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_168,axiom,
    ! [VarCurr] :
      ( v5112(VarCurr)
     => ( v19(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_776,axiom,
    ! [VarCurr] :
      ( v5112(VarCurr)
    <=> ( v5113(VarCurr)
        | v5123(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_775,axiom,
    ! [VarCurr] :
      ( v5123(VarCurr)
    <=> ( v2061(VarCurr)
        & v1348(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_774,axiom,
    ! [VarCurr] :
      ( v5113(VarCurr)
    <=> ( v5114(VarCurr)
        | v5120(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_773,axiom,
    ! [VarCurr] :
      ( v5120(VarCurr)
    <=> ( v5121(VarCurr)
        & v1344(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_772,axiom,
    ! [VarCurr] :
      ( v5121(VarCurr)
    <=> ( v5122(VarCurr)
        & v1342(VarCurr) ) ) ).

fof(writeUnaryOperator_384,axiom,
    ! [VarCurr] :
      ( ~ v5122(VarCurr)
    <=> v1308(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_771,axiom,
    ! [VarCurr] :
      ( v5114(VarCurr)
    <=> ( v5115(VarCurr)
        | v5119(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_770,axiom,
    ! [VarCurr] :
      ( v5119(VarCurr)
    <=> ( v2056(VarCurr)
        & v1333(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_769,axiom,
    ! [VarCurr] :
      ( v5115(VarCurr)
    <=> ( v5116(VarCurr)
        & v1322(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_768,axiom,
    ! [VarCurr] :
      ( v5116(VarCurr)
    <=> ( v5117(VarCurr)
        | v5118(VarCurr) ) ) ).

fof(writeUnaryOperator_383,axiom,
    ! [VarCurr] :
      ( ~ v5118(VarCurr)
    <=> v1320(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_767,axiom,
    ! [VarCurr] :
      ( v5117(VarCurr)
    <=> ( v2053(VarCurr)
        & v1320(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_136,axiom,
    ! [VarCurr] :
      ( ~ v23(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v21(VarCurr,B)
          <=> v5093(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_167,axiom,
    ! [VarCurr] :
      ( v23(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v21(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_25,axiom,
    ! [VarCurr] :
      ( ( ~ v5094(VarCurr)
        & ~ v5102(VarCurr)
        & ~ v5103(VarCurr) )
     => ! [B] :
          ( range_1_0(B)
         => ( v5093(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_42,axiom,
    ! [VarCurr] :
      ( v5103(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v5093(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_72,axiom,
    ! [VarCurr] :
      ( v5102(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v5093(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_67,axiom,
    ! [VarCurr] :
      ( v5094(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v5093(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_766,axiom,
    ! [VarCurr] :
      ( v5103(VarCurr)
    <=> ( v5105(VarCurr)
        | v5110(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_336,axiom,
    ! [VarCurr] :
      ( v5110(VarCurr)
    <=> ( ( v2339(VarCurr,bitIndex6)
        <=> $false )
        & ( v2339(VarCurr,bitIndex5)
        <=> $false )
        & ( v2339(VarCurr,bitIndex4)
        <=> $false )
        & ( v2339(VarCurr,bitIndex3)
        <=> $true )
        & ( v2339(VarCurr,bitIndex2)
        <=> $false )
        & ( v2339(VarCurr,bitIndex1)
        <=> $true )
        & ( v2339(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_765,axiom,
    ! [VarCurr] :
      ( v5105(VarCurr)
    <=> ( v5106(VarCurr)
        | v5109(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_335,axiom,
    ! [VarCurr] :
      ( v5109(VarCurr)
    <=> ( ( v2339(VarCurr,bitIndex6)
        <=> $true )
        & ( v2339(VarCurr,bitIndex5)
        <=> $false )
        & ( v2339(VarCurr,bitIndex4)
        <=> $false )
        & ( v2339(VarCurr,bitIndex3)
        <=> $true )
        & ( v2339(VarCurr,bitIndex2)
        <=> $false )
        & ( v2339(VarCurr,bitIndex1)
        <=> $true )
        & ( v2339(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_764,axiom,
    ! [VarCurr] :
      ( v5106(VarCurr)
    <=> ( v5107(VarCurr)
        | v5108(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_334,axiom,
    ! [VarCurr] :
      ( v5108(VarCurr)
    <=> ( ( v2339(VarCurr,bitIndex6)
        <=> $true )
        & ( v2339(VarCurr,bitIndex5)
        <=> $true )
        & ( v2339(VarCurr,bitIndex4)
        <=> $false )
        & ( v2339(VarCurr,bitIndex3)
        <=> $false )
        & ( v2339(VarCurr,bitIndex2)
        <=> $false )
        & ( v2339(VarCurr,bitIndex1)
        <=> $false )
        & ( v2339(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_333,axiom,
    ! [VarCurr] :
      ( v5107(VarCurr)
    <=> ( ( v2339(VarCurr,bitIndex6)
        <=> $true )
        & ( v2339(VarCurr,bitIndex5)
        <=> $false )
        & ( v2339(VarCurr,bitIndex4)
        <=> $false )
        & ( v2339(VarCurr,bitIndex3)
        <=> $false )
        & ( v2339(VarCurr,bitIndex2)
        <=> $false )
        & ( v2339(VarCurr,bitIndex1)
        <=> $false )
        & ( v2339(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_332,axiom,
    ! [VarCurr] :
      ( v5102(VarCurr)
    <=> ( ( v2339(VarCurr,bitIndex6)
        <=> $false )
        & ( v2339(VarCurr,bitIndex5)
        <=> $false )
        & ( v2339(VarCurr,bitIndex4)
        <=> $false )
        & ( v2339(VarCurr,bitIndex3)
        <=> $true )
        & ( v2339(VarCurr,bitIndex2)
        <=> $false )
        & ( v2339(VarCurr,bitIndex1)
        <=> $false )
        & ( v2339(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_1555,axiom,
    ~ b0001001(bitIndex6) ).

fof(bitBlastConstant_1554,axiom,
    ~ b0001001(bitIndex5) ).

fof(bitBlastConstant_1553,axiom,
    ~ b0001001(bitIndex4) ).

fof(bitBlastConstant_1552,axiom,
    b0001001(bitIndex3) ).

fof(bitBlastConstant_1551,axiom,
    ~ b0001001(bitIndex2) ).

fof(bitBlastConstant_1550,axiom,
    ~ b0001001(bitIndex1) ).

fof(bitBlastConstant_1549,axiom,
    b0001001(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_763,axiom,
    ! [VarCurr] :
      ( v5094(VarCurr)
    <=> ( v5096(VarCurr)
        | v5101(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_331,axiom,
    ! [VarCurr] :
      ( v5101(VarCurr)
    <=> ( ( v2339(VarCurr,bitIndex6)
        <=> $false )
        & ( v2339(VarCurr,bitIndex5)
        <=> $true )
        & ( v2339(VarCurr,bitIndex4)
        <=> $false )
        & ( v2339(VarCurr,bitIndex3)
        <=> $false )
        & ( v2339(VarCurr,bitIndex2)
        <=> $false )
        & ( v2339(VarCurr,bitIndex1)
        <=> $false )
        & ( v2339(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_1548,axiom,
    ~ b0100001(bitIndex6) ).

fof(bitBlastConstant_1547,axiom,
    b0100001(bitIndex5) ).

fof(bitBlastConstant_1546,axiom,
    ~ b0100001(bitIndex4) ).

fof(bitBlastConstant_1545,axiom,
    ~ b0100001(bitIndex3) ).

fof(bitBlastConstant_1544,axiom,
    ~ b0100001(bitIndex2) ).

fof(bitBlastConstant_1543,axiom,
    ~ b0100001(bitIndex1) ).

fof(bitBlastConstant_1542,axiom,
    b0100001(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_762,axiom,
    ! [VarCurr] :
      ( v5096(VarCurr)
    <=> ( v5097(VarCurr)
        | v5100(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_330,axiom,
    ! [VarCurr] :
      ( v5100(VarCurr)
    <=> ( ( v2339(VarCurr,bitIndex6)
        <=> $false )
        & ( v2339(VarCurr,bitIndex5)
        <=> $false )
        & ( v2339(VarCurr,bitIndex4)
        <=> $false )
        & ( v2339(VarCurr,bitIndex3)
        <=> $false )
        & ( v2339(VarCurr,bitIndex2)
        <=> $false )
        & ( v2339(VarCurr,bitIndex1)
        <=> $false )
        & ( v2339(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_761,axiom,
    ! [VarCurr] :
      ( v5097(VarCurr)
    <=> ( v5098(VarCurr)
        | v5099(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_329,axiom,
    ! [VarCurr] :
      ( v5099(VarCurr)
    <=> ( ( v2339(VarCurr,bitIndex6)
        <=> $false )
        & ( v2339(VarCurr,bitIndex5)
        <=> $true )
        & ( v2339(VarCurr,bitIndex4)
        <=> $false )
        & ( v2339(VarCurr,bitIndex3)
        <=> $false )
        & ( v2339(VarCurr,bitIndex2)
        <=> $false )
        & ( v2339(VarCurr,bitIndex1)
        <=> $false )
        & ( v2339(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_328,axiom,
    ! [VarCurr] :
      ( v5098(VarCurr)
    <=> ( ( v2339(VarCurr,bitIndex6)
        <=> $false )
        & ( v2339(VarCurr,bitIndex5)
        <=> $false )
        & ( v2339(VarCurr,bitIndex4)
        <=> $false )
        & ( v2339(VarCurr,bitIndex3)
        <=> $false )
        & ( v2339(VarCurr,bitIndex2)
        <=> $false )
        & ( v2339(VarCurr,bitIndex1)
        <=> $false )
        & ( v2339(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1546,axiom,
    ! [VarCurr] :
      ( ( v2339(VarCurr,bitIndex6)
      <=> v2149(VarCurr,bitIndex130) )
      & ( v2339(VarCurr,bitIndex5)
      <=> v2149(VarCurr,bitIndex129) )
      & ( v2339(VarCurr,bitIndex4)
      <=> v2149(VarCurr,bitIndex128) )
      & ( v2339(VarCurr,bitIndex3)
      <=> v2149(VarCurr,bitIndex127) )
      & ( v2339(VarCurr,bitIndex2)
      <=> v2149(VarCurr,bitIndex126) )
      & ( v2339(VarCurr,bitIndex1)
      <=> v2149(VarCurr,bitIndex125) )
      & ( v2339(VarCurr,bitIndex0)
      <=> v2149(VarCurr,bitIndex124) ) ) ).

fof(addAssignment_1545,axiom,
    ! [VarCurr,B] :
      ( range_130_124(B)
     => ( v2149(VarCurr,B)
      <=> v2151(VarCurr,B) ) ) ).

fof(addAssignment_1544,axiom,
    ! [VarCurr] :
      ( ( v2151(VarCurr,bitIndex130)
      <=> v2153(VarCurr,bitIndex523) )
      & ( v2151(VarCurr,bitIndex129)
      <=> v2153(VarCurr,bitIndex522) )
      & ( v2151(VarCurr,bitIndex128)
      <=> v2153(VarCurr,bitIndex521) )
      & ( v2151(VarCurr,bitIndex127)
      <=> v2153(VarCurr,bitIndex520) )
      & ( v2151(VarCurr,bitIndex126)
      <=> v2153(VarCurr,bitIndex519) )
      & ( v2151(VarCurr,bitIndex125)
      <=> v2153(VarCurr,bitIndex518) )
      & ( v2151(VarCurr,bitIndex124)
      <=> v2153(VarCurr,bitIndex517) ) ) ).

fof(addAssignment_1543,axiom,
    ! [VarNext] :
      ( ( v2153(VarNext,bitIndex523)
      <=> v5085(VarNext,bitIndex130) )
      & ( v2153(VarNext,bitIndex522)
      <=> v5085(VarNext,bitIndex129) )
      & ( v2153(VarNext,bitIndex521)
      <=> v5085(VarNext,bitIndex128) )
      & ( v2153(VarNext,bitIndex520)
      <=> v5085(VarNext,bitIndex127) )
      & ( v2153(VarNext,bitIndex519)
      <=> v5085(VarNext,bitIndex126) )
      & ( v2153(VarNext,bitIndex518)
      <=> v5085(VarNext,bitIndex125) )
      & ( v2153(VarNext,bitIndex517)
      <=> v5085(VarNext,bitIndex124) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_10,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5087(VarNext)
       => ( ( v5085(VarNext,bitIndex130)
          <=> v2153(VarCurr,bitIndex523) )
          & ( v5085(VarNext,bitIndex129)
          <=> v2153(VarCurr,bitIndex522) )
          & ( v5085(VarNext,bitIndex128)
          <=> v2153(VarCurr,bitIndex521) )
          & ( v5085(VarNext,bitIndex127)
          <=> v2153(VarCurr,bitIndex520) )
          & ( v5085(VarNext,bitIndex126)
          <=> v2153(VarCurr,bitIndex519) )
          & ( v5085(VarNext,bitIndex125)
          <=> v2153(VarCurr,bitIndex518) )
          & ( v5085(VarNext,bitIndex124)
          <=> v2153(VarCurr,bitIndex517) )
          & ( v5085(VarNext,bitIndex123)
          <=> v2153(VarCurr,bitIndex516) )
          & ( v5085(VarNext,bitIndex122)
          <=> v2153(VarCurr,bitIndex515) )
          & ( v5085(VarNext,bitIndex121)
          <=> v2153(VarCurr,bitIndex514) )
          & ( v5085(VarNext,bitIndex120)
          <=> v2153(VarCurr,bitIndex513) )
          & ( v5085(VarNext,bitIndex119)
          <=> v2153(VarCurr,bitIndex512) )
          & ( v5085(VarNext,bitIndex118)
          <=> v2153(VarCurr,bitIndex511) )
          & ( v5085(VarNext,bitIndex117)
          <=> v2153(VarCurr,bitIndex510) )
          & ( v5085(VarNext,bitIndex116)
          <=> v2153(VarCurr,bitIndex509) )
          & ( v5085(VarNext,bitIndex115)
          <=> v2153(VarCurr,bitIndex508) )
          & ( v5085(VarNext,bitIndex114)
          <=> v2153(VarCurr,bitIndex507) )
          & ( v5085(VarNext,bitIndex113)
          <=> v2153(VarCurr,bitIndex506) )
          & ( v5085(VarNext,bitIndex112)
          <=> v2153(VarCurr,bitIndex505) )
          & ( v5085(VarNext,bitIndex111)
          <=> v2153(VarCurr,bitIndex504) )
          & ( v5085(VarNext,bitIndex110)
          <=> v2153(VarCurr,bitIndex503) )
          & ( v5085(VarNext,bitIndex109)
          <=> v2153(VarCurr,bitIndex502) )
          & ( v5085(VarNext,bitIndex108)
          <=> v2153(VarCurr,bitIndex501) )
          & ( v5085(VarNext,bitIndex107)
          <=> v2153(VarCurr,bitIndex500) )
          & ( v5085(VarNext,bitIndex106)
          <=> v2153(VarCurr,bitIndex499) )
          & ( v5085(VarNext,bitIndex105)
          <=> v2153(VarCurr,bitIndex498) )
          & ( v5085(VarNext,bitIndex104)
          <=> v2153(VarCurr,bitIndex497) )
          & ( v5085(VarNext,bitIndex103)
          <=> v2153(VarCurr,bitIndex496) )
          & ( v5085(VarNext,bitIndex102)
          <=> v2153(VarCurr,bitIndex495) )
          & ( v5085(VarNext,bitIndex101)
          <=> v2153(VarCurr,bitIndex494) )
          & ( v5085(VarNext,bitIndex100)
          <=> v2153(VarCurr,bitIndex493) )
          & ( v5085(VarNext,bitIndex99)
          <=> v2153(VarCurr,bitIndex492) )
          & ( v5085(VarNext,bitIndex98)
          <=> v2153(VarCurr,bitIndex491) )
          & ( v5085(VarNext,bitIndex97)
          <=> v2153(VarCurr,bitIndex490) )
          & ( v5085(VarNext,bitIndex96)
          <=> v2153(VarCurr,bitIndex489) )
          & ( v5085(VarNext,bitIndex95)
          <=> v2153(VarCurr,bitIndex488) )
          & ( v5085(VarNext,bitIndex94)
          <=> v2153(VarCurr,bitIndex487) )
          & ( v5085(VarNext,bitIndex93)
          <=> v2153(VarCurr,bitIndex486) )
          & ( v5085(VarNext,bitIndex92)
          <=> v2153(VarCurr,bitIndex485) )
          & ( v5085(VarNext,bitIndex91)
          <=> v2153(VarCurr,bitIndex484) )
          & ( v5085(VarNext,bitIndex90)
          <=> v2153(VarCurr,bitIndex483) )
          & ( v5085(VarNext,bitIndex89)
          <=> v2153(VarCurr,bitIndex482) )
          & ( v5085(VarNext,bitIndex88)
          <=> v2153(VarCurr,bitIndex481) )
          & ( v5085(VarNext,bitIndex87)
          <=> v2153(VarCurr,bitIndex480) )
          & ( v5085(VarNext,bitIndex86)
          <=> v2153(VarCurr,bitIndex479) )
          & ( v5085(VarNext,bitIndex85)
          <=> v2153(VarCurr,bitIndex478) )
          & ( v5085(VarNext,bitIndex84)
          <=> v2153(VarCurr,bitIndex477) )
          & ( v5085(VarNext,bitIndex83)
          <=> v2153(VarCurr,bitIndex476) )
          & ( v5085(VarNext,bitIndex82)
          <=> v2153(VarCurr,bitIndex475) )
          & ( v5085(VarNext,bitIndex81)
          <=> v2153(VarCurr,bitIndex474) )
          & ( v5085(VarNext,bitIndex80)
          <=> v2153(VarCurr,bitIndex473) )
          & ( v5085(VarNext,bitIndex79)
          <=> v2153(VarCurr,bitIndex472) )
          & ( v5085(VarNext,bitIndex78)
          <=> v2153(VarCurr,bitIndex471) )
          & ( v5085(VarNext,bitIndex77)
          <=> v2153(VarCurr,bitIndex470) )
          & ( v5085(VarNext,bitIndex76)
          <=> v2153(VarCurr,bitIndex469) )
          & ( v5085(VarNext,bitIndex75)
          <=> v2153(VarCurr,bitIndex468) )
          & ( v5085(VarNext,bitIndex74)
          <=> v2153(VarCurr,bitIndex467) )
          & ( v5085(VarNext,bitIndex73)
          <=> v2153(VarCurr,bitIndex466) )
          & ( v5085(VarNext,bitIndex72)
          <=> v2153(VarCurr,bitIndex465) )
          & ( v5085(VarNext,bitIndex71)
          <=> v2153(VarCurr,bitIndex464) )
          & ( v5085(VarNext,bitIndex70)
          <=> v2153(VarCurr,bitIndex463) )
          & ( v5085(VarNext,bitIndex69)
          <=> v2153(VarCurr,bitIndex462) )
          & ( v5085(VarNext,bitIndex68)
          <=> v2153(VarCurr,bitIndex461) )
          & ( v5085(VarNext,bitIndex67)
          <=> v2153(VarCurr,bitIndex460) )
          & ( v5085(VarNext,bitIndex66)
          <=> v2153(VarCurr,bitIndex459) )
          & ( v5085(VarNext,bitIndex65)
          <=> v2153(VarCurr,bitIndex458) )
          & ( v5085(VarNext,bitIndex64)
          <=> v2153(VarCurr,bitIndex457) )
          & ( v5085(VarNext,bitIndex63)
          <=> v2153(VarCurr,bitIndex456) )
          & ( v5085(VarNext,bitIndex62)
          <=> v2153(VarCurr,bitIndex455) )
          & ( v5085(VarNext,bitIndex61)
          <=> v2153(VarCurr,bitIndex454) )
          & ( v5085(VarNext,bitIndex60)
          <=> v2153(VarCurr,bitIndex453) )
          & ( v5085(VarNext,bitIndex59)
          <=> v2153(VarCurr,bitIndex452) )
          & ( v5085(VarNext,bitIndex58)
          <=> v2153(VarCurr,bitIndex451) )
          & ( v5085(VarNext,bitIndex57)
          <=> v2153(VarCurr,bitIndex450) )
          & ( v5085(VarNext,bitIndex56)
          <=> v2153(VarCurr,bitIndex449) )
          & ( v5085(VarNext,bitIndex55)
          <=> v2153(VarCurr,bitIndex448) )
          & ( v5085(VarNext,bitIndex54)
          <=> v2153(VarCurr,bitIndex447) )
          & ( v5085(VarNext,bitIndex53)
          <=> v2153(VarCurr,bitIndex446) )
          & ( v5085(VarNext,bitIndex52)
          <=> v2153(VarCurr,bitIndex445) )
          & ( v5085(VarNext,bitIndex51)
          <=> v2153(VarCurr,bitIndex444) )
          & ( v5085(VarNext,bitIndex50)
          <=> v2153(VarCurr,bitIndex443) )
          & ( v5085(VarNext,bitIndex49)
          <=> v2153(VarCurr,bitIndex442) )
          & ( v5085(VarNext,bitIndex48)
          <=> v2153(VarCurr,bitIndex441) )
          & ( v5085(VarNext,bitIndex47)
          <=> v2153(VarCurr,bitIndex440) )
          & ( v5085(VarNext,bitIndex46)
          <=> v2153(VarCurr,bitIndex439) )
          & ( v5085(VarNext,bitIndex45)
          <=> v2153(VarCurr,bitIndex438) )
          & ( v5085(VarNext,bitIndex44)
          <=> v2153(VarCurr,bitIndex437) )
          & ( v5085(VarNext,bitIndex43)
          <=> v2153(VarCurr,bitIndex436) )
          & ( v5085(VarNext,bitIndex42)
          <=> v2153(VarCurr,bitIndex435) )
          & ( v5085(VarNext,bitIndex41)
          <=> v2153(VarCurr,bitIndex434) )
          & ( v5085(VarNext,bitIndex40)
          <=> v2153(VarCurr,bitIndex433) )
          & ( v5085(VarNext,bitIndex39)
          <=> v2153(VarCurr,bitIndex432) )
          & ( v5085(VarNext,bitIndex38)
          <=> v2153(VarCurr,bitIndex431) )
          & ( v5085(VarNext,bitIndex37)
          <=> v2153(VarCurr,bitIndex430) )
          & ( v5085(VarNext,bitIndex36)
          <=> v2153(VarCurr,bitIndex429) )
          & ( v5085(VarNext,bitIndex35)
          <=> v2153(VarCurr,bitIndex428) )
          & ( v5085(VarNext,bitIndex34)
          <=> v2153(VarCurr,bitIndex427) )
          & ( v5085(VarNext,bitIndex33)
          <=> v2153(VarCurr,bitIndex426) )
          & ( v5085(VarNext,bitIndex32)
          <=> v2153(VarCurr,bitIndex425) )
          & ( v5085(VarNext,bitIndex31)
          <=> v2153(VarCurr,bitIndex424) )
          & ( v5085(VarNext,bitIndex30)
          <=> v2153(VarCurr,bitIndex423) )
          & ( v5085(VarNext,bitIndex29)
          <=> v2153(VarCurr,bitIndex422) )
          & ( v5085(VarNext,bitIndex28)
          <=> v2153(VarCurr,bitIndex421) )
          & ( v5085(VarNext,bitIndex27)
          <=> v2153(VarCurr,bitIndex420) )
          & ( v5085(VarNext,bitIndex26)
          <=> v2153(VarCurr,bitIndex419) )
          & ( v5085(VarNext,bitIndex25)
          <=> v2153(VarCurr,bitIndex418) )
          & ( v5085(VarNext,bitIndex24)
          <=> v2153(VarCurr,bitIndex417) )
          & ( v5085(VarNext,bitIndex23)
          <=> v2153(VarCurr,bitIndex416) )
          & ( v5085(VarNext,bitIndex22)
          <=> v2153(VarCurr,bitIndex415) )
          & ( v5085(VarNext,bitIndex21)
          <=> v2153(VarCurr,bitIndex414) )
          & ( v5085(VarNext,bitIndex20)
          <=> v2153(VarCurr,bitIndex413) )
          & ( v5085(VarNext,bitIndex19)
          <=> v2153(VarCurr,bitIndex412) )
          & ( v5085(VarNext,bitIndex18)
          <=> v2153(VarCurr,bitIndex411) )
          & ( v5085(VarNext,bitIndex17)
          <=> v2153(VarCurr,bitIndex410) )
          & ( v5085(VarNext,bitIndex16)
          <=> v2153(VarCurr,bitIndex409) )
          & ( v5085(VarNext,bitIndex15)
          <=> v2153(VarCurr,bitIndex408) )
          & ( v5085(VarNext,bitIndex14)
          <=> v2153(VarCurr,bitIndex407) )
          & ( v5085(VarNext,bitIndex13)
          <=> v2153(VarCurr,bitIndex406) )
          & ( v5085(VarNext,bitIndex12)
          <=> v2153(VarCurr,bitIndex405) )
          & ( v5085(VarNext,bitIndex11)
          <=> v2153(VarCurr,bitIndex404) )
          & ( v5085(VarNext,bitIndex10)
          <=> v2153(VarCurr,bitIndex403) )
          & ( v5085(VarNext,bitIndex9)
          <=> v2153(VarCurr,bitIndex402) )
          & ( v5085(VarNext,bitIndex8)
          <=> v2153(VarCurr,bitIndex401) )
          & ( v5085(VarNext,bitIndex7)
          <=> v2153(VarCurr,bitIndex400) )
          & ( v5085(VarNext,bitIndex6)
          <=> v2153(VarCurr,bitIndex399) )
          & ( v5085(VarNext,bitIndex5)
          <=> v2153(VarCurr,bitIndex398) )
          & ( v5085(VarNext,bitIndex4)
          <=> v2153(VarCurr,bitIndex397) )
          & ( v5085(VarNext,bitIndex3)
          <=> v2153(VarCurr,bitIndex396) )
          & ( v5085(VarNext,bitIndex2)
          <=> v2153(VarCurr,bitIndex395) )
          & ( v5085(VarNext,bitIndex1)
          <=> v2153(VarCurr,bitIndex394) )
          & ( v5085(VarNext,bitIndex0)
          <=> v2153(VarCurr,bitIndex393) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_72,axiom,
    ! [VarNext] :
      ( v5087(VarNext)
     => ! [B] :
          ( range_130_0(B)
         => ( v5085(VarNext,B)
          <=> v2292(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_760,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5087(VarNext)
      <=> ( v5088(VarNext)
          & v2273(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_759,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5088(VarNext)
      <=> ( v5090(VarNext)
          & v2173(VarNext) ) ) ) ).

fof(writeUnaryOperator_382,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5090(VarNext)
      <=> v2182(VarNext) ) ) ).

fof(addAssignment_1542,axiom,
    ! [VarCurr,B] :
      ( range_130_124(B)
     => ( v2257(VarCurr,B)
      <=> v2262(VarCurr,B) ) ) ).

fof(addAssignment_1541,axiom,
    ! [VarCurr] :
      ( ( v2261(VarCurr,bitIndex130)
      <=> v2153(VarCurr,bitIndex392) )
      & ( v2261(VarCurr,bitIndex129)
      <=> v2153(VarCurr,bitIndex391) )
      & ( v2261(VarCurr,bitIndex128)
      <=> v2153(VarCurr,bitIndex390) )
      & ( v2261(VarCurr,bitIndex127)
      <=> v2153(VarCurr,bitIndex389) )
      & ( v2261(VarCurr,bitIndex126)
      <=> v2153(VarCurr,bitIndex388) )
      & ( v2261(VarCurr,bitIndex125)
      <=> v2153(VarCurr,bitIndex387) )
      & ( v2261(VarCurr,bitIndex124)
      <=> v2153(VarCurr,bitIndex386) ) ) ).

fof(addAssignment_1540,axiom,
    ! [VarCurr,B] :
      ( range_130_124(B)
     => ( v2163(VarCurr,B)
      <=> v2255(VarCurr,B) ) ) ).

fof(addAssignment_1539,axiom,
    ! [VarCurr] :
      ( ( v2246(VarCurr,bitIndex130)
      <=> v2153(VarCurr,bitIndex523) )
      & ( v2246(VarCurr,bitIndex129)
      <=> v2153(VarCurr,bitIndex522) )
      & ( v2246(VarCurr,bitIndex128)
      <=> v2153(VarCurr,bitIndex521) )
      & ( v2246(VarCurr,bitIndex127)
      <=> v2153(VarCurr,bitIndex520) )
      & ( v2246(VarCurr,bitIndex126)
      <=> v2153(VarCurr,bitIndex519) )
      & ( v2246(VarCurr,bitIndex125)
      <=> v2153(VarCurr,bitIndex518) )
      & ( v2246(VarCurr,bitIndex124)
      <=> v2153(VarCurr,bitIndex517) ) ) ).

fof(addAssignment_1538,axiom,
    ! [VarNext] :
      ( ( v2153(VarNext,bitIndex392)
      <=> v5053(VarNext,bitIndex130) )
      & ( v2153(VarNext,bitIndex391)
      <=> v5053(VarNext,bitIndex129) )
      & ( v2153(VarNext,bitIndex390)
      <=> v5053(VarNext,bitIndex128) )
      & ( v2153(VarNext,bitIndex389)
      <=> v5053(VarNext,bitIndex127) )
      & ( v2153(VarNext,bitIndex388)
      <=> v5053(VarNext,bitIndex126) )
      & ( v2153(VarNext,bitIndex387)
      <=> v5053(VarNext,bitIndex125) )
      & ( v2153(VarNext,bitIndex386)
      <=> v5053(VarNext,bitIndex124) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_9,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5054(VarNext)
       => ( ( v5053(VarNext,bitIndex130)
          <=> v2153(VarCurr,bitIndex392) )
          & ( v5053(VarNext,bitIndex129)
          <=> v2153(VarCurr,bitIndex391) )
          & ( v5053(VarNext,bitIndex128)
          <=> v2153(VarCurr,bitIndex390) )
          & ( v5053(VarNext,bitIndex127)
          <=> v2153(VarCurr,bitIndex389) )
          & ( v5053(VarNext,bitIndex126)
          <=> v2153(VarCurr,bitIndex388) )
          & ( v5053(VarNext,bitIndex125)
          <=> v2153(VarCurr,bitIndex387) )
          & ( v5053(VarNext,bitIndex124)
          <=> v2153(VarCurr,bitIndex386) )
          & ( v5053(VarNext,bitIndex123)
          <=> v2153(VarCurr,bitIndex385) )
          & ( v5053(VarNext,bitIndex122)
          <=> v2153(VarCurr,bitIndex384) )
          & ( v5053(VarNext,bitIndex121)
          <=> v2153(VarCurr,bitIndex383) )
          & ( v5053(VarNext,bitIndex120)
          <=> v2153(VarCurr,bitIndex382) )
          & ( v5053(VarNext,bitIndex119)
          <=> v2153(VarCurr,bitIndex381) )
          & ( v5053(VarNext,bitIndex118)
          <=> v2153(VarCurr,bitIndex380) )
          & ( v5053(VarNext,bitIndex117)
          <=> v2153(VarCurr,bitIndex379) )
          & ( v5053(VarNext,bitIndex116)
          <=> v2153(VarCurr,bitIndex378) )
          & ( v5053(VarNext,bitIndex115)
          <=> v2153(VarCurr,bitIndex377) )
          & ( v5053(VarNext,bitIndex114)
          <=> v2153(VarCurr,bitIndex376) )
          & ( v5053(VarNext,bitIndex113)
          <=> v2153(VarCurr,bitIndex375) )
          & ( v5053(VarNext,bitIndex112)
          <=> v2153(VarCurr,bitIndex374) )
          & ( v5053(VarNext,bitIndex111)
          <=> v2153(VarCurr,bitIndex373) )
          & ( v5053(VarNext,bitIndex110)
          <=> v2153(VarCurr,bitIndex372) )
          & ( v5053(VarNext,bitIndex109)
          <=> v2153(VarCurr,bitIndex371) )
          & ( v5053(VarNext,bitIndex108)
          <=> v2153(VarCurr,bitIndex370) )
          & ( v5053(VarNext,bitIndex107)
          <=> v2153(VarCurr,bitIndex369) )
          & ( v5053(VarNext,bitIndex106)
          <=> v2153(VarCurr,bitIndex368) )
          & ( v5053(VarNext,bitIndex105)
          <=> v2153(VarCurr,bitIndex367) )
          & ( v5053(VarNext,bitIndex104)
          <=> v2153(VarCurr,bitIndex366) )
          & ( v5053(VarNext,bitIndex103)
          <=> v2153(VarCurr,bitIndex365) )
          & ( v5053(VarNext,bitIndex102)
          <=> v2153(VarCurr,bitIndex364) )
          & ( v5053(VarNext,bitIndex101)
          <=> v2153(VarCurr,bitIndex363) )
          & ( v5053(VarNext,bitIndex100)
          <=> v2153(VarCurr,bitIndex362) )
          & ( v5053(VarNext,bitIndex99)
          <=> v2153(VarCurr,bitIndex361) )
          & ( v5053(VarNext,bitIndex98)
          <=> v2153(VarCurr,bitIndex360) )
          & ( v5053(VarNext,bitIndex97)
          <=> v2153(VarCurr,bitIndex359) )
          & ( v5053(VarNext,bitIndex96)
          <=> v2153(VarCurr,bitIndex358) )
          & ( v5053(VarNext,bitIndex95)
          <=> v2153(VarCurr,bitIndex357) )
          & ( v5053(VarNext,bitIndex94)
          <=> v2153(VarCurr,bitIndex356) )
          & ( v5053(VarNext,bitIndex93)
          <=> v2153(VarCurr,bitIndex355) )
          & ( v5053(VarNext,bitIndex92)
          <=> v2153(VarCurr,bitIndex354) )
          & ( v5053(VarNext,bitIndex91)
          <=> v2153(VarCurr,bitIndex353) )
          & ( v5053(VarNext,bitIndex90)
          <=> v2153(VarCurr,bitIndex352) )
          & ( v5053(VarNext,bitIndex89)
          <=> v2153(VarCurr,bitIndex351) )
          & ( v5053(VarNext,bitIndex88)
          <=> v2153(VarCurr,bitIndex350) )
          & ( v5053(VarNext,bitIndex87)
          <=> v2153(VarCurr,bitIndex349) )
          & ( v5053(VarNext,bitIndex86)
          <=> v2153(VarCurr,bitIndex348) )
          & ( v5053(VarNext,bitIndex85)
          <=> v2153(VarCurr,bitIndex347) )
          & ( v5053(VarNext,bitIndex84)
          <=> v2153(VarCurr,bitIndex346) )
          & ( v5053(VarNext,bitIndex83)
          <=> v2153(VarCurr,bitIndex345) )
          & ( v5053(VarNext,bitIndex82)
          <=> v2153(VarCurr,bitIndex344) )
          & ( v5053(VarNext,bitIndex81)
          <=> v2153(VarCurr,bitIndex343) )
          & ( v5053(VarNext,bitIndex80)
          <=> v2153(VarCurr,bitIndex342) )
          & ( v5053(VarNext,bitIndex79)
          <=> v2153(VarCurr,bitIndex341) )
          & ( v5053(VarNext,bitIndex78)
          <=> v2153(VarCurr,bitIndex340) )
          & ( v5053(VarNext,bitIndex77)
          <=> v2153(VarCurr,bitIndex339) )
          & ( v5053(VarNext,bitIndex76)
          <=> v2153(VarCurr,bitIndex338) )
          & ( v5053(VarNext,bitIndex75)
          <=> v2153(VarCurr,bitIndex337) )
          & ( v5053(VarNext,bitIndex74)
          <=> v2153(VarCurr,bitIndex336) )
          & ( v5053(VarNext,bitIndex73)
          <=> v2153(VarCurr,bitIndex335) )
          & ( v5053(VarNext,bitIndex72)
          <=> v2153(VarCurr,bitIndex334) )
          & ( v5053(VarNext,bitIndex71)
          <=> v2153(VarCurr,bitIndex333) )
          & ( v5053(VarNext,bitIndex70)
          <=> v2153(VarCurr,bitIndex332) )
          & ( v5053(VarNext,bitIndex69)
          <=> v2153(VarCurr,bitIndex331) )
          & ( v5053(VarNext,bitIndex68)
          <=> v2153(VarCurr,bitIndex330) )
          & ( v5053(VarNext,bitIndex67)
          <=> v2153(VarCurr,bitIndex329) )
          & ( v5053(VarNext,bitIndex66)
          <=> v2153(VarCurr,bitIndex328) )
          & ( v5053(VarNext,bitIndex65)
          <=> v2153(VarCurr,bitIndex327) )
          & ( v5053(VarNext,bitIndex64)
          <=> v2153(VarCurr,bitIndex326) )
          & ( v5053(VarNext,bitIndex63)
          <=> v2153(VarCurr,bitIndex325) )
          & ( v5053(VarNext,bitIndex62)
          <=> v2153(VarCurr,bitIndex324) )
          & ( v5053(VarNext,bitIndex61)
          <=> v2153(VarCurr,bitIndex323) )
          & ( v5053(VarNext,bitIndex60)
          <=> v2153(VarCurr,bitIndex322) )
          & ( v5053(VarNext,bitIndex59)
          <=> v2153(VarCurr,bitIndex321) )
          & ( v5053(VarNext,bitIndex58)
          <=> v2153(VarCurr,bitIndex320) )
          & ( v5053(VarNext,bitIndex57)
          <=> v2153(VarCurr,bitIndex319) )
          & ( v5053(VarNext,bitIndex56)
          <=> v2153(VarCurr,bitIndex318) )
          & ( v5053(VarNext,bitIndex55)
          <=> v2153(VarCurr,bitIndex317) )
          & ( v5053(VarNext,bitIndex54)
          <=> v2153(VarCurr,bitIndex316) )
          & ( v5053(VarNext,bitIndex53)
          <=> v2153(VarCurr,bitIndex315) )
          & ( v5053(VarNext,bitIndex52)
          <=> v2153(VarCurr,bitIndex314) )
          & ( v5053(VarNext,bitIndex51)
          <=> v2153(VarCurr,bitIndex313) )
          & ( v5053(VarNext,bitIndex50)
          <=> v2153(VarCurr,bitIndex312) )
          & ( v5053(VarNext,bitIndex49)
          <=> v2153(VarCurr,bitIndex311) )
          & ( v5053(VarNext,bitIndex48)
          <=> v2153(VarCurr,bitIndex310) )
          & ( v5053(VarNext,bitIndex47)
          <=> v2153(VarCurr,bitIndex309) )
          & ( v5053(VarNext,bitIndex46)
          <=> v2153(VarCurr,bitIndex308) )
          & ( v5053(VarNext,bitIndex45)
          <=> v2153(VarCurr,bitIndex307) )
          & ( v5053(VarNext,bitIndex44)
          <=> v2153(VarCurr,bitIndex306) )
          & ( v5053(VarNext,bitIndex43)
          <=> v2153(VarCurr,bitIndex305) )
          & ( v5053(VarNext,bitIndex42)
          <=> v2153(VarCurr,bitIndex304) )
          & ( v5053(VarNext,bitIndex41)
          <=> v2153(VarCurr,bitIndex303) )
          & ( v5053(VarNext,bitIndex40)
          <=> v2153(VarCurr,bitIndex302) )
          & ( v5053(VarNext,bitIndex39)
          <=> v2153(VarCurr,bitIndex301) )
          & ( v5053(VarNext,bitIndex38)
          <=> v2153(VarCurr,bitIndex300) )
          & ( v5053(VarNext,bitIndex37)
          <=> v2153(VarCurr,bitIndex299) )
          & ( v5053(VarNext,bitIndex36)
          <=> v2153(VarCurr,bitIndex298) )
          & ( v5053(VarNext,bitIndex35)
          <=> v2153(VarCurr,bitIndex297) )
          & ( v5053(VarNext,bitIndex34)
          <=> v2153(VarCurr,bitIndex296) )
          & ( v5053(VarNext,bitIndex33)
          <=> v2153(VarCurr,bitIndex295) )
          & ( v5053(VarNext,bitIndex32)
          <=> v2153(VarCurr,bitIndex294) )
          & ( v5053(VarNext,bitIndex31)
          <=> v2153(VarCurr,bitIndex293) )
          & ( v5053(VarNext,bitIndex30)
          <=> v2153(VarCurr,bitIndex292) )
          & ( v5053(VarNext,bitIndex29)
          <=> v2153(VarCurr,bitIndex291) )
          & ( v5053(VarNext,bitIndex28)
          <=> v2153(VarCurr,bitIndex290) )
          & ( v5053(VarNext,bitIndex27)
          <=> v2153(VarCurr,bitIndex289) )
          & ( v5053(VarNext,bitIndex26)
          <=> v2153(VarCurr,bitIndex288) )
          & ( v5053(VarNext,bitIndex25)
          <=> v2153(VarCurr,bitIndex287) )
          & ( v5053(VarNext,bitIndex24)
          <=> v2153(VarCurr,bitIndex286) )
          & ( v5053(VarNext,bitIndex23)
          <=> v2153(VarCurr,bitIndex285) )
          & ( v5053(VarNext,bitIndex22)
          <=> v2153(VarCurr,bitIndex284) )
          & ( v5053(VarNext,bitIndex21)
          <=> v2153(VarCurr,bitIndex283) )
          & ( v5053(VarNext,bitIndex20)
          <=> v2153(VarCurr,bitIndex282) )
          & ( v5053(VarNext,bitIndex19)
          <=> v2153(VarCurr,bitIndex281) )
          & ( v5053(VarNext,bitIndex18)
          <=> v2153(VarCurr,bitIndex280) )
          & ( v5053(VarNext,bitIndex17)
          <=> v2153(VarCurr,bitIndex279) )
          & ( v5053(VarNext,bitIndex16)
          <=> v2153(VarCurr,bitIndex278) )
          & ( v5053(VarNext,bitIndex15)
          <=> v2153(VarCurr,bitIndex277) )
          & ( v5053(VarNext,bitIndex14)
          <=> v2153(VarCurr,bitIndex276) )
          & ( v5053(VarNext,bitIndex13)
          <=> v2153(VarCurr,bitIndex275) )
          & ( v5053(VarNext,bitIndex12)
          <=> v2153(VarCurr,bitIndex274) )
          & ( v5053(VarNext,bitIndex11)
          <=> v2153(VarCurr,bitIndex273) )
          & ( v5053(VarNext,bitIndex10)
          <=> v2153(VarCurr,bitIndex272) )
          & ( v5053(VarNext,bitIndex9)
          <=> v2153(VarCurr,bitIndex271) )
          & ( v5053(VarNext,bitIndex8)
          <=> v2153(VarCurr,bitIndex270) )
          & ( v5053(VarNext,bitIndex7)
          <=> v2153(VarCurr,bitIndex269) )
          & ( v5053(VarNext,bitIndex6)
          <=> v2153(VarCurr,bitIndex268) )
          & ( v5053(VarNext,bitIndex5)
          <=> v2153(VarCurr,bitIndex267) )
          & ( v5053(VarNext,bitIndex4)
          <=> v2153(VarCurr,bitIndex266) )
          & ( v5053(VarNext,bitIndex3)
          <=> v2153(VarCurr,bitIndex265) )
          & ( v5053(VarNext,bitIndex2)
          <=> v2153(VarCurr,bitIndex264) )
          & ( v5053(VarNext,bitIndex1)
          <=> v2153(VarCurr,bitIndex263) )
          & ( v5053(VarNext,bitIndex0)
          <=> v2153(VarCurr,bitIndex262) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_71,axiom,
    ! [VarNext] :
      ( v5054(VarNext)
     => ! [B] :
          ( range_130_0(B)
         => ( v5053(VarNext,B)
          <=> v5080(VarNext,B) ) ) ) ).

fof(addAssignment_1537,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_130_0(B)
         => ( v5080(VarNext,B)
          <=> v5078(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_71,axiom,
    ! [VarCurr] :
      ( ~ v2275(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v5078(VarCurr,B)
          <=> v5081(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_66,axiom,
    ! [VarCurr] :
      ( v2275(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v5078(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_41,axiom,
    ! [VarCurr] :
      ( ( ~ v5067(VarCurr)
        & ~ v5069(VarCurr) )
     => ! [B] :
          ( range_130_0(B)
         => ( v5081(VarCurr,B)
          <=> v5046(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_70,axiom,
    ! [VarCurr] :
      ( v5069(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v5081(VarCurr,B)
          <=> v5039(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_7,axiom,
    ! [VarCurr] :
      ( v5067(VarCurr)
     => ( ( v5081(VarCurr,bitIndex130)
        <=> v2153(VarCurr,bitIndex261) )
        & ( v5081(VarCurr,bitIndex129)
        <=> v2153(VarCurr,bitIndex260) )
        & ( v5081(VarCurr,bitIndex128)
        <=> v2153(VarCurr,bitIndex259) )
        & ( v5081(VarCurr,bitIndex127)
        <=> v2153(VarCurr,bitIndex258) )
        & ( v5081(VarCurr,bitIndex126)
        <=> v2153(VarCurr,bitIndex257) )
        & ( v5081(VarCurr,bitIndex125)
        <=> v2153(VarCurr,bitIndex256) )
        & ( v5081(VarCurr,bitIndex124)
        <=> v2153(VarCurr,bitIndex255) )
        & ( v5081(VarCurr,bitIndex123)
        <=> v2153(VarCurr,bitIndex254) )
        & ( v5081(VarCurr,bitIndex122)
        <=> v2153(VarCurr,bitIndex253) )
        & ( v5081(VarCurr,bitIndex121)
        <=> v2153(VarCurr,bitIndex252) )
        & ( v5081(VarCurr,bitIndex120)
        <=> v2153(VarCurr,bitIndex251) )
        & ( v5081(VarCurr,bitIndex119)
        <=> v2153(VarCurr,bitIndex250) )
        & ( v5081(VarCurr,bitIndex118)
        <=> v2153(VarCurr,bitIndex249) )
        & ( v5081(VarCurr,bitIndex117)
        <=> v2153(VarCurr,bitIndex248) )
        & ( v5081(VarCurr,bitIndex116)
        <=> v2153(VarCurr,bitIndex247) )
        & ( v5081(VarCurr,bitIndex115)
        <=> v2153(VarCurr,bitIndex246) )
        & ( v5081(VarCurr,bitIndex114)
        <=> v2153(VarCurr,bitIndex245) )
        & ( v5081(VarCurr,bitIndex113)
        <=> v2153(VarCurr,bitIndex244) )
        & ( v5081(VarCurr,bitIndex112)
        <=> v2153(VarCurr,bitIndex243) )
        & ( v5081(VarCurr,bitIndex111)
        <=> v2153(VarCurr,bitIndex242) )
        & ( v5081(VarCurr,bitIndex110)
        <=> v2153(VarCurr,bitIndex241) )
        & ( v5081(VarCurr,bitIndex109)
        <=> v2153(VarCurr,bitIndex240) )
        & ( v5081(VarCurr,bitIndex108)
        <=> v2153(VarCurr,bitIndex239) )
        & ( v5081(VarCurr,bitIndex107)
        <=> v2153(VarCurr,bitIndex238) )
        & ( v5081(VarCurr,bitIndex106)
        <=> v2153(VarCurr,bitIndex237) )
        & ( v5081(VarCurr,bitIndex105)
        <=> v2153(VarCurr,bitIndex236) )
        & ( v5081(VarCurr,bitIndex104)
        <=> v2153(VarCurr,bitIndex235) )
        & ( v5081(VarCurr,bitIndex103)
        <=> v2153(VarCurr,bitIndex234) )
        & ( v5081(VarCurr,bitIndex102)
        <=> v2153(VarCurr,bitIndex233) )
        & ( v5081(VarCurr,bitIndex101)
        <=> v2153(VarCurr,bitIndex232) )
        & ( v5081(VarCurr,bitIndex100)
        <=> v2153(VarCurr,bitIndex231) )
        & ( v5081(VarCurr,bitIndex99)
        <=> v2153(VarCurr,bitIndex230) )
        & ( v5081(VarCurr,bitIndex98)
        <=> v2153(VarCurr,bitIndex229) )
        & ( v5081(VarCurr,bitIndex97)
        <=> v2153(VarCurr,bitIndex228) )
        & ( v5081(VarCurr,bitIndex96)
        <=> v2153(VarCurr,bitIndex227) )
        & ( v5081(VarCurr,bitIndex95)
        <=> v2153(VarCurr,bitIndex226) )
        & ( v5081(VarCurr,bitIndex94)
        <=> v2153(VarCurr,bitIndex225) )
        & ( v5081(VarCurr,bitIndex93)
        <=> v2153(VarCurr,bitIndex224) )
        & ( v5081(VarCurr,bitIndex92)
        <=> v2153(VarCurr,bitIndex223) )
        & ( v5081(VarCurr,bitIndex91)
        <=> v2153(VarCurr,bitIndex222) )
        & ( v5081(VarCurr,bitIndex90)
        <=> v2153(VarCurr,bitIndex221) )
        & ( v5081(VarCurr,bitIndex89)
        <=> v2153(VarCurr,bitIndex220) )
        & ( v5081(VarCurr,bitIndex88)
        <=> v2153(VarCurr,bitIndex219) )
        & ( v5081(VarCurr,bitIndex87)
        <=> v2153(VarCurr,bitIndex218) )
        & ( v5081(VarCurr,bitIndex86)
        <=> v2153(VarCurr,bitIndex217) )
        & ( v5081(VarCurr,bitIndex85)
        <=> v2153(VarCurr,bitIndex216) )
        & ( v5081(VarCurr,bitIndex84)
        <=> v2153(VarCurr,bitIndex215) )
        & ( v5081(VarCurr,bitIndex83)
        <=> v2153(VarCurr,bitIndex214) )
        & ( v5081(VarCurr,bitIndex82)
        <=> v2153(VarCurr,bitIndex213) )
        & ( v5081(VarCurr,bitIndex81)
        <=> v2153(VarCurr,bitIndex212) )
        & ( v5081(VarCurr,bitIndex80)
        <=> v2153(VarCurr,bitIndex211) )
        & ( v5081(VarCurr,bitIndex79)
        <=> v2153(VarCurr,bitIndex210) )
        & ( v5081(VarCurr,bitIndex78)
        <=> v2153(VarCurr,bitIndex209) )
        & ( v5081(VarCurr,bitIndex77)
        <=> v2153(VarCurr,bitIndex208) )
        & ( v5081(VarCurr,bitIndex76)
        <=> v2153(VarCurr,bitIndex207) )
        & ( v5081(VarCurr,bitIndex75)
        <=> v2153(VarCurr,bitIndex206) )
        & ( v5081(VarCurr,bitIndex74)
        <=> v2153(VarCurr,bitIndex205) )
        & ( v5081(VarCurr,bitIndex73)
        <=> v2153(VarCurr,bitIndex204) )
        & ( v5081(VarCurr,bitIndex72)
        <=> v2153(VarCurr,bitIndex203) )
        & ( v5081(VarCurr,bitIndex71)
        <=> v2153(VarCurr,bitIndex202) )
        & ( v5081(VarCurr,bitIndex70)
        <=> v2153(VarCurr,bitIndex201) )
        & ( v5081(VarCurr,bitIndex69)
        <=> v2153(VarCurr,bitIndex200) )
        & ( v5081(VarCurr,bitIndex68)
        <=> v2153(VarCurr,bitIndex199) )
        & ( v5081(VarCurr,bitIndex67)
        <=> v2153(VarCurr,bitIndex198) )
        & ( v5081(VarCurr,bitIndex66)
        <=> v2153(VarCurr,bitIndex197) )
        & ( v5081(VarCurr,bitIndex65)
        <=> v2153(VarCurr,bitIndex196) )
        & ( v5081(VarCurr,bitIndex64)
        <=> v2153(VarCurr,bitIndex195) )
        & ( v5081(VarCurr,bitIndex63)
        <=> v2153(VarCurr,bitIndex194) )
        & ( v5081(VarCurr,bitIndex62)
        <=> v2153(VarCurr,bitIndex193) )
        & ( v5081(VarCurr,bitIndex61)
        <=> v2153(VarCurr,bitIndex192) )
        & ( v5081(VarCurr,bitIndex60)
        <=> v2153(VarCurr,bitIndex191) )
        & ( v5081(VarCurr,bitIndex59)
        <=> v2153(VarCurr,bitIndex190) )
        & ( v5081(VarCurr,bitIndex58)
        <=> v2153(VarCurr,bitIndex189) )
        & ( v5081(VarCurr,bitIndex57)
        <=> v2153(VarCurr,bitIndex188) )
        & ( v5081(VarCurr,bitIndex56)
        <=> v2153(VarCurr,bitIndex187) )
        & ( v5081(VarCurr,bitIndex55)
        <=> v2153(VarCurr,bitIndex186) )
        & ( v5081(VarCurr,bitIndex54)
        <=> v2153(VarCurr,bitIndex185) )
        & ( v5081(VarCurr,bitIndex53)
        <=> v2153(VarCurr,bitIndex184) )
        & ( v5081(VarCurr,bitIndex52)
        <=> v2153(VarCurr,bitIndex183) )
        & ( v5081(VarCurr,bitIndex51)
        <=> v2153(VarCurr,bitIndex182) )
        & ( v5081(VarCurr,bitIndex50)
        <=> v2153(VarCurr,bitIndex181) )
        & ( v5081(VarCurr,bitIndex49)
        <=> v2153(VarCurr,bitIndex180) )
        & ( v5081(VarCurr,bitIndex48)
        <=> v2153(VarCurr,bitIndex179) )
        & ( v5081(VarCurr,bitIndex47)
        <=> v2153(VarCurr,bitIndex178) )
        & ( v5081(VarCurr,bitIndex46)
        <=> v2153(VarCurr,bitIndex177) )
        & ( v5081(VarCurr,bitIndex45)
        <=> v2153(VarCurr,bitIndex176) )
        & ( v5081(VarCurr,bitIndex44)
        <=> v2153(VarCurr,bitIndex175) )
        & ( v5081(VarCurr,bitIndex43)
        <=> v2153(VarCurr,bitIndex174) )
        & ( v5081(VarCurr,bitIndex42)
        <=> v2153(VarCurr,bitIndex173) )
        & ( v5081(VarCurr,bitIndex41)
        <=> v2153(VarCurr,bitIndex172) )
        & ( v5081(VarCurr,bitIndex40)
        <=> v2153(VarCurr,bitIndex171) )
        & ( v5081(VarCurr,bitIndex39)
        <=> v2153(VarCurr,bitIndex170) )
        & ( v5081(VarCurr,bitIndex38)
        <=> v2153(VarCurr,bitIndex169) )
        & ( v5081(VarCurr,bitIndex37)
        <=> v2153(VarCurr,bitIndex168) )
        & ( v5081(VarCurr,bitIndex36)
        <=> v2153(VarCurr,bitIndex167) )
        & ( v5081(VarCurr,bitIndex35)
        <=> v2153(VarCurr,bitIndex166) )
        & ( v5081(VarCurr,bitIndex34)
        <=> v2153(VarCurr,bitIndex165) )
        & ( v5081(VarCurr,bitIndex33)
        <=> v2153(VarCurr,bitIndex164) )
        & ( v5081(VarCurr,bitIndex32)
        <=> v2153(VarCurr,bitIndex163) )
        & ( v5081(VarCurr,bitIndex31)
        <=> v2153(VarCurr,bitIndex162) )
        & ( v5081(VarCurr,bitIndex30)
        <=> v2153(VarCurr,bitIndex161) )
        & ( v5081(VarCurr,bitIndex29)
        <=> v2153(VarCurr,bitIndex160) )
        & ( v5081(VarCurr,bitIndex28)
        <=> v2153(VarCurr,bitIndex159) )
        & ( v5081(VarCurr,bitIndex27)
        <=> v2153(VarCurr,bitIndex158) )
        & ( v5081(VarCurr,bitIndex26)
        <=> v2153(VarCurr,bitIndex157) )
        & ( v5081(VarCurr,bitIndex25)
        <=> v2153(VarCurr,bitIndex156) )
        & ( v5081(VarCurr,bitIndex24)
        <=> v2153(VarCurr,bitIndex155) )
        & ( v5081(VarCurr,bitIndex23)
        <=> v2153(VarCurr,bitIndex154) )
        & ( v5081(VarCurr,bitIndex22)
        <=> v2153(VarCurr,bitIndex153) )
        & ( v5081(VarCurr,bitIndex21)
        <=> v2153(VarCurr,bitIndex152) )
        & ( v5081(VarCurr,bitIndex20)
        <=> v2153(VarCurr,bitIndex151) )
        & ( v5081(VarCurr,bitIndex19)
        <=> v2153(VarCurr,bitIndex150) )
        & ( v5081(VarCurr,bitIndex18)
        <=> v2153(VarCurr,bitIndex149) )
        & ( v5081(VarCurr,bitIndex17)
        <=> v2153(VarCurr,bitIndex148) )
        & ( v5081(VarCurr,bitIndex16)
        <=> v2153(VarCurr,bitIndex147) )
        & ( v5081(VarCurr,bitIndex15)
        <=> v2153(VarCurr,bitIndex146) )
        & ( v5081(VarCurr,bitIndex14)
        <=> v2153(VarCurr,bitIndex145) )
        & ( v5081(VarCurr,bitIndex13)
        <=> v2153(VarCurr,bitIndex144) )
        & ( v5081(VarCurr,bitIndex12)
        <=> v2153(VarCurr,bitIndex143) )
        & ( v5081(VarCurr,bitIndex11)
        <=> v2153(VarCurr,bitIndex142) )
        & ( v5081(VarCurr,bitIndex10)
        <=> v2153(VarCurr,bitIndex141) )
        & ( v5081(VarCurr,bitIndex9)
        <=> v2153(VarCurr,bitIndex140) )
        & ( v5081(VarCurr,bitIndex8)
        <=> v2153(VarCurr,bitIndex139) )
        & ( v5081(VarCurr,bitIndex7)
        <=> v2153(VarCurr,bitIndex138) )
        & ( v5081(VarCurr,bitIndex6)
        <=> v2153(VarCurr,bitIndex137) )
        & ( v5081(VarCurr,bitIndex5)
        <=> v2153(VarCurr,bitIndex136) )
        & ( v5081(VarCurr,bitIndex4)
        <=> v2153(VarCurr,bitIndex135) )
        & ( v5081(VarCurr,bitIndex3)
        <=> v2153(VarCurr,bitIndex134) )
        & ( v5081(VarCurr,bitIndex2)
        <=> v2153(VarCurr,bitIndex133) )
        & ( v5081(VarCurr,bitIndex1)
        <=> v2153(VarCurr,bitIndex132) )
        & ( v5081(VarCurr,bitIndex0)
        <=> v2153(VarCurr,bitIndex131) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_758,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5054(VarNext)
      <=> ( v5055(VarNext)
          & v5062(VarNext) ) ) ) ).

fof(addAssignment_1536,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5062(VarNext)
      <=> v5060(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_757,axiom,
    ! [VarCurr] :
      ( v5060(VarCurr)
    <=> ( v5063(VarCurr)
        & v5074(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_756,axiom,
    ! [VarCurr] :
      ( v5074(VarCurr)
    <=> ( v5075(VarCurr)
        | v2275(VarCurr) ) ) ).

fof(writeUnaryOperator_381,axiom,
    ! [VarCurr] :
      ( ~ v5075(VarCurr)
    <=> v5076(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_327,axiom,
    ! [VarCurr] :
      ( v5076(VarCurr)
    <=> ( ( v5077(VarCurr,bitIndex1)
        <=> $false )
        & ( v5077(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1535,axiom,
    ! [VarCurr] :
      ( v5077(VarCurr,bitIndex0)
    <=> v2155(VarCurr) ) ).

fof(addAssignment_1534,axiom,
    ! [VarCurr] :
      ( v5077(VarCurr,bitIndex1)
    <=> v29(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_755,axiom,
    ! [VarCurr] :
      ( v5063(VarCurr)
    <=> ( v2275(VarCurr)
        | v5064(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_754,axiom,
    ! [VarCurr] :
      ( v5064(VarCurr)
    <=> ( v5065(VarCurr)
        & v5073(VarCurr) ) ) ).

fof(writeUnaryOperator_380,axiom,
    ! [VarCurr] :
      ( ~ v5073(VarCurr)
    <=> v2275(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_753,axiom,
    ! [VarCurr] :
      ( v5065(VarCurr)
    <=> ( v5066(VarCurr)
        | v5071(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_326,axiom,
    ! [VarCurr] :
      ( v5071(VarCurr)
    <=> ( ( v5072(VarCurr,bitIndex1)
        <=> $true )
        & ( v5072(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1533,axiom,
    ! [VarCurr] :
      ( v5072(VarCurr,bitIndex0)
    <=> v2155(VarCurr) ) ).

fof(addAssignment_1532,axiom,
    ! [VarCurr] :
      ( v5072(VarCurr,bitIndex1)
    <=> v29(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_752,axiom,
    ! [VarCurr] :
      ( v5066(VarCurr)
    <=> ( v5067(VarCurr)
        | v5069(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_325,axiom,
    ! [VarCurr] :
      ( v5069(VarCurr)
    <=> ( ( v5070(VarCurr,bitIndex1)
        <=> $true )
        & ( v5070(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1531,axiom,
    ! [VarCurr] :
      ( v5070(VarCurr,bitIndex0)
    <=> v2155(VarCurr) ) ).

fof(addAssignment_1530,axiom,
    ! [VarCurr] :
      ( v5070(VarCurr,bitIndex1)
    <=> v29(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_324,axiom,
    ! [VarCurr] :
      ( v5067(VarCurr)
    <=> ( ( v5068(VarCurr,bitIndex1)
        <=> $false )
        & ( v5068(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1529,axiom,
    ! [VarCurr] :
      ( v5068(VarCurr,bitIndex0)
    <=> v2155(VarCurr) ) ).

fof(addAssignment_1528,axiom,
    ! [VarCurr] :
      ( v5068(VarCurr,bitIndex1)
    <=> v29(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_751,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5055(VarNext)
      <=> ( v5057(VarNext)
          & v2173(VarNext) ) ) ) ).

fof(writeUnaryOperator_379,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5057(VarNext)
      <=> v2182(VarNext) ) ) ).

fof(addAssignment_1527,axiom,
    ! [VarCurr,B] :
      ( range_130_124(B)
     => ( v5046(VarCurr,B)
      <=> v5051(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_135,axiom,
    ! [VarCurr] :
      ( ~ v5048(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v5051(VarCurr,B)
          <=> v5050(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_166,axiom,
    ! [VarCurr] :
      ( v5048(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v5051(VarCurr,B)
          <=> v2234(VarCurr,B) ) ) ) ).

fof(addAssignment_1526,axiom,
    ! [VarCurr] :
      ( ( v5050(VarCurr,bitIndex130)
      <=> v2153(VarCurr,bitIndex261) )
      & ( v5050(VarCurr,bitIndex129)
      <=> v2153(VarCurr,bitIndex260) )
      & ( v5050(VarCurr,bitIndex128)
      <=> v2153(VarCurr,bitIndex259) )
      & ( v5050(VarCurr,bitIndex127)
      <=> v2153(VarCurr,bitIndex258) )
      & ( v5050(VarCurr,bitIndex126)
      <=> v2153(VarCurr,bitIndex257) )
      & ( v5050(VarCurr,bitIndex125)
      <=> v2153(VarCurr,bitIndex256) )
      & ( v5050(VarCurr,bitIndex124)
      <=> v2153(VarCurr,bitIndex255) ) ) ).

fof(addAssignment_1525,axiom,
    ! [VarCurr] :
      ( v5048(VarCurr)
    <=> v2167(VarCurr,bitIndex2) ) ).

fof(addAssignment_1524,axiom,
    ! [VarCurr,B] :
      ( range_130_124(B)
     => ( v5039(VarCurr,B)
      <=> v5044(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_134,axiom,
    ! [VarCurr] :
      ( ~ v5041(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v5044(VarCurr,B)
          <=> v5043(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_165,axiom,
    ! [VarCurr] :
      ( v5041(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v5044(VarCurr,B)
          <=> v2234(VarCurr,B) ) ) ) ).

fof(addAssignment_1523,axiom,
    ! [VarCurr] :
      ( ( v5043(VarCurr,bitIndex130)
      <=> v2153(VarCurr,bitIndex392) )
      & ( v5043(VarCurr,bitIndex129)
      <=> v2153(VarCurr,bitIndex391) )
      & ( v5043(VarCurr,bitIndex128)
      <=> v2153(VarCurr,bitIndex390) )
      & ( v5043(VarCurr,bitIndex127)
      <=> v2153(VarCurr,bitIndex389) )
      & ( v5043(VarCurr,bitIndex126)
      <=> v2153(VarCurr,bitIndex388) )
      & ( v5043(VarCurr,bitIndex125)
      <=> v2153(VarCurr,bitIndex387) )
      & ( v5043(VarCurr,bitIndex124)
      <=> v2153(VarCurr,bitIndex386) ) ) ).

fof(addAssignment_1522,axiom,
    ! [VarCurr] :
      ( v5041(VarCurr)
    <=> v2167(VarCurr,bitIndex2) ) ).

fof(addAssignment_1521,axiom,
    ! [VarNext] :
      ( ( v2153(VarNext,bitIndex261)
      <=> v5007(VarNext,bitIndex130) )
      & ( v2153(VarNext,bitIndex260)
      <=> v5007(VarNext,bitIndex129) )
      & ( v2153(VarNext,bitIndex259)
      <=> v5007(VarNext,bitIndex128) )
      & ( v2153(VarNext,bitIndex258)
      <=> v5007(VarNext,bitIndex127) )
      & ( v2153(VarNext,bitIndex257)
      <=> v5007(VarNext,bitIndex126) )
      & ( v2153(VarNext,bitIndex256)
      <=> v5007(VarNext,bitIndex125) )
      & ( v2153(VarNext,bitIndex255)
      <=> v5007(VarNext,bitIndex124) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_8,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5008(VarNext)
       => ( ( v5007(VarNext,bitIndex130)
          <=> v2153(VarCurr,bitIndex261) )
          & ( v5007(VarNext,bitIndex129)
          <=> v2153(VarCurr,bitIndex260) )
          & ( v5007(VarNext,bitIndex128)
          <=> v2153(VarCurr,bitIndex259) )
          & ( v5007(VarNext,bitIndex127)
          <=> v2153(VarCurr,bitIndex258) )
          & ( v5007(VarNext,bitIndex126)
          <=> v2153(VarCurr,bitIndex257) )
          & ( v5007(VarNext,bitIndex125)
          <=> v2153(VarCurr,bitIndex256) )
          & ( v5007(VarNext,bitIndex124)
          <=> v2153(VarCurr,bitIndex255) )
          & ( v5007(VarNext,bitIndex123)
          <=> v2153(VarCurr,bitIndex254) )
          & ( v5007(VarNext,bitIndex122)
          <=> v2153(VarCurr,bitIndex253) )
          & ( v5007(VarNext,bitIndex121)
          <=> v2153(VarCurr,bitIndex252) )
          & ( v5007(VarNext,bitIndex120)
          <=> v2153(VarCurr,bitIndex251) )
          & ( v5007(VarNext,bitIndex119)
          <=> v2153(VarCurr,bitIndex250) )
          & ( v5007(VarNext,bitIndex118)
          <=> v2153(VarCurr,bitIndex249) )
          & ( v5007(VarNext,bitIndex117)
          <=> v2153(VarCurr,bitIndex248) )
          & ( v5007(VarNext,bitIndex116)
          <=> v2153(VarCurr,bitIndex247) )
          & ( v5007(VarNext,bitIndex115)
          <=> v2153(VarCurr,bitIndex246) )
          & ( v5007(VarNext,bitIndex114)
          <=> v2153(VarCurr,bitIndex245) )
          & ( v5007(VarNext,bitIndex113)
          <=> v2153(VarCurr,bitIndex244) )
          & ( v5007(VarNext,bitIndex112)
          <=> v2153(VarCurr,bitIndex243) )
          & ( v5007(VarNext,bitIndex111)
          <=> v2153(VarCurr,bitIndex242) )
          & ( v5007(VarNext,bitIndex110)
          <=> v2153(VarCurr,bitIndex241) )
          & ( v5007(VarNext,bitIndex109)
          <=> v2153(VarCurr,bitIndex240) )
          & ( v5007(VarNext,bitIndex108)
          <=> v2153(VarCurr,bitIndex239) )
          & ( v5007(VarNext,bitIndex107)
          <=> v2153(VarCurr,bitIndex238) )
          & ( v5007(VarNext,bitIndex106)
          <=> v2153(VarCurr,bitIndex237) )
          & ( v5007(VarNext,bitIndex105)
          <=> v2153(VarCurr,bitIndex236) )
          & ( v5007(VarNext,bitIndex104)
          <=> v2153(VarCurr,bitIndex235) )
          & ( v5007(VarNext,bitIndex103)
          <=> v2153(VarCurr,bitIndex234) )
          & ( v5007(VarNext,bitIndex102)
          <=> v2153(VarCurr,bitIndex233) )
          & ( v5007(VarNext,bitIndex101)
          <=> v2153(VarCurr,bitIndex232) )
          & ( v5007(VarNext,bitIndex100)
          <=> v2153(VarCurr,bitIndex231) )
          & ( v5007(VarNext,bitIndex99)
          <=> v2153(VarCurr,bitIndex230) )
          & ( v5007(VarNext,bitIndex98)
          <=> v2153(VarCurr,bitIndex229) )
          & ( v5007(VarNext,bitIndex97)
          <=> v2153(VarCurr,bitIndex228) )
          & ( v5007(VarNext,bitIndex96)
          <=> v2153(VarCurr,bitIndex227) )
          & ( v5007(VarNext,bitIndex95)
          <=> v2153(VarCurr,bitIndex226) )
          & ( v5007(VarNext,bitIndex94)
          <=> v2153(VarCurr,bitIndex225) )
          & ( v5007(VarNext,bitIndex93)
          <=> v2153(VarCurr,bitIndex224) )
          & ( v5007(VarNext,bitIndex92)
          <=> v2153(VarCurr,bitIndex223) )
          & ( v5007(VarNext,bitIndex91)
          <=> v2153(VarCurr,bitIndex222) )
          & ( v5007(VarNext,bitIndex90)
          <=> v2153(VarCurr,bitIndex221) )
          & ( v5007(VarNext,bitIndex89)
          <=> v2153(VarCurr,bitIndex220) )
          & ( v5007(VarNext,bitIndex88)
          <=> v2153(VarCurr,bitIndex219) )
          & ( v5007(VarNext,bitIndex87)
          <=> v2153(VarCurr,bitIndex218) )
          & ( v5007(VarNext,bitIndex86)
          <=> v2153(VarCurr,bitIndex217) )
          & ( v5007(VarNext,bitIndex85)
          <=> v2153(VarCurr,bitIndex216) )
          & ( v5007(VarNext,bitIndex84)
          <=> v2153(VarCurr,bitIndex215) )
          & ( v5007(VarNext,bitIndex83)
          <=> v2153(VarCurr,bitIndex214) )
          & ( v5007(VarNext,bitIndex82)
          <=> v2153(VarCurr,bitIndex213) )
          & ( v5007(VarNext,bitIndex81)
          <=> v2153(VarCurr,bitIndex212) )
          & ( v5007(VarNext,bitIndex80)
          <=> v2153(VarCurr,bitIndex211) )
          & ( v5007(VarNext,bitIndex79)
          <=> v2153(VarCurr,bitIndex210) )
          & ( v5007(VarNext,bitIndex78)
          <=> v2153(VarCurr,bitIndex209) )
          & ( v5007(VarNext,bitIndex77)
          <=> v2153(VarCurr,bitIndex208) )
          & ( v5007(VarNext,bitIndex76)
          <=> v2153(VarCurr,bitIndex207) )
          & ( v5007(VarNext,bitIndex75)
          <=> v2153(VarCurr,bitIndex206) )
          & ( v5007(VarNext,bitIndex74)
          <=> v2153(VarCurr,bitIndex205) )
          & ( v5007(VarNext,bitIndex73)
          <=> v2153(VarCurr,bitIndex204) )
          & ( v5007(VarNext,bitIndex72)
          <=> v2153(VarCurr,bitIndex203) )
          & ( v5007(VarNext,bitIndex71)
          <=> v2153(VarCurr,bitIndex202) )
          & ( v5007(VarNext,bitIndex70)
          <=> v2153(VarCurr,bitIndex201) )
          & ( v5007(VarNext,bitIndex69)
          <=> v2153(VarCurr,bitIndex200) )
          & ( v5007(VarNext,bitIndex68)
          <=> v2153(VarCurr,bitIndex199) )
          & ( v5007(VarNext,bitIndex67)
          <=> v2153(VarCurr,bitIndex198) )
          & ( v5007(VarNext,bitIndex66)
          <=> v2153(VarCurr,bitIndex197) )
          & ( v5007(VarNext,bitIndex65)
          <=> v2153(VarCurr,bitIndex196) )
          & ( v5007(VarNext,bitIndex64)
          <=> v2153(VarCurr,bitIndex195) )
          & ( v5007(VarNext,bitIndex63)
          <=> v2153(VarCurr,bitIndex194) )
          & ( v5007(VarNext,bitIndex62)
          <=> v2153(VarCurr,bitIndex193) )
          & ( v5007(VarNext,bitIndex61)
          <=> v2153(VarCurr,bitIndex192) )
          & ( v5007(VarNext,bitIndex60)
          <=> v2153(VarCurr,bitIndex191) )
          & ( v5007(VarNext,bitIndex59)
          <=> v2153(VarCurr,bitIndex190) )
          & ( v5007(VarNext,bitIndex58)
          <=> v2153(VarCurr,bitIndex189) )
          & ( v5007(VarNext,bitIndex57)
          <=> v2153(VarCurr,bitIndex188) )
          & ( v5007(VarNext,bitIndex56)
          <=> v2153(VarCurr,bitIndex187) )
          & ( v5007(VarNext,bitIndex55)
          <=> v2153(VarCurr,bitIndex186) )
          & ( v5007(VarNext,bitIndex54)
          <=> v2153(VarCurr,bitIndex185) )
          & ( v5007(VarNext,bitIndex53)
          <=> v2153(VarCurr,bitIndex184) )
          & ( v5007(VarNext,bitIndex52)
          <=> v2153(VarCurr,bitIndex183) )
          & ( v5007(VarNext,bitIndex51)
          <=> v2153(VarCurr,bitIndex182) )
          & ( v5007(VarNext,bitIndex50)
          <=> v2153(VarCurr,bitIndex181) )
          & ( v5007(VarNext,bitIndex49)
          <=> v2153(VarCurr,bitIndex180) )
          & ( v5007(VarNext,bitIndex48)
          <=> v2153(VarCurr,bitIndex179) )
          & ( v5007(VarNext,bitIndex47)
          <=> v2153(VarCurr,bitIndex178) )
          & ( v5007(VarNext,bitIndex46)
          <=> v2153(VarCurr,bitIndex177) )
          & ( v5007(VarNext,bitIndex45)
          <=> v2153(VarCurr,bitIndex176) )
          & ( v5007(VarNext,bitIndex44)
          <=> v2153(VarCurr,bitIndex175) )
          & ( v5007(VarNext,bitIndex43)
          <=> v2153(VarCurr,bitIndex174) )
          & ( v5007(VarNext,bitIndex42)
          <=> v2153(VarCurr,bitIndex173) )
          & ( v5007(VarNext,bitIndex41)
          <=> v2153(VarCurr,bitIndex172) )
          & ( v5007(VarNext,bitIndex40)
          <=> v2153(VarCurr,bitIndex171) )
          & ( v5007(VarNext,bitIndex39)
          <=> v2153(VarCurr,bitIndex170) )
          & ( v5007(VarNext,bitIndex38)
          <=> v2153(VarCurr,bitIndex169) )
          & ( v5007(VarNext,bitIndex37)
          <=> v2153(VarCurr,bitIndex168) )
          & ( v5007(VarNext,bitIndex36)
          <=> v2153(VarCurr,bitIndex167) )
          & ( v5007(VarNext,bitIndex35)
          <=> v2153(VarCurr,bitIndex166) )
          & ( v5007(VarNext,bitIndex34)
          <=> v2153(VarCurr,bitIndex165) )
          & ( v5007(VarNext,bitIndex33)
          <=> v2153(VarCurr,bitIndex164) )
          & ( v5007(VarNext,bitIndex32)
          <=> v2153(VarCurr,bitIndex163) )
          & ( v5007(VarNext,bitIndex31)
          <=> v2153(VarCurr,bitIndex162) )
          & ( v5007(VarNext,bitIndex30)
          <=> v2153(VarCurr,bitIndex161) )
          & ( v5007(VarNext,bitIndex29)
          <=> v2153(VarCurr,bitIndex160) )
          & ( v5007(VarNext,bitIndex28)
          <=> v2153(VarCurr,bitIndex159) )
          & ( v5007(VarNext,bitIndex27)
          <=> v2153(VarCurr,bitIndex158) )
          & ( v5007(VarNext,bitIndex26)
          <=> v2153(VarCurr,bitIndex157) )
          & ( v5007(VarNext,bitIndex25)
          <=> v2153(VarCurr,bitIndex156) )
          & ( v5007(VarNext,bitIndex24)
          <=> v2153(VarCurr,bitIndex155) )
          & ( v5007(VarNext,bitIndex23)
          <=> v2153(VarCurr,bitIndex154) )
          & ( v5007(VarNext,bitIndex22)
          <=> v2153(VarCurr,bitIndex153) )
          & ( v5007(VarNext,bitIndex21)
          <=> v2153(VarCurr,bitIndex152) )
          & ( v5007(VarNext,bitIndex20)
          <=> v2153(VarCurr,bitIndex151) )
          & ( v5007(VarNext,bitIndex19)
          <=> v2153(VarCurr,bitIndex150) )
          & ( v5007(VarNext,bitIndex18)
          <=> v2153(VarCurr,bitIndex149) )
          & ( v5007(VarNext,bitIndex17)
          <=> v2153(VarCurr,bitIndex148) )
          & ( v5007(VarNext,bitIndex16)
          <=> v2153(VarCurr,bitIndex147) )
          & ( v5007(VarNext,bitIndex15)
          <=> v2153(VarCurr,bitIndex146) )
          & ( v5007(VarNext,bitIndex14)
          <=> v2153(VarCurr,bitIndex145) )
          & ( v5007(VarNext,bitIndex13)
          <=> v2153(VarCurr,bitIndex144) )
          & ( v5007(VarNext,bitIndex12)
          <=> v2153(VarCurr,bitIndex143) )
          & ( v5007(VarNext,bitIndex11)
          <=> v2153(VarCurr,bitIndex142) )
          & ( v5007(VarNext,bitIndex10)
          <=> v2153(VarCurr,bitIndex141) )
          & ( v5007(VarNext,bitIndex9)
          <=> v2153(VarCurr,bitIndex140) )
          & ( v5007(VarNext,bitIndex8)
          <=> v2153(VarCurr,bitIndex139) )
          & ( v5007(VarNext,bitIndex7)
          <=> v2153(VarCurr,bitIndex138) )
          & ( v5007(VarNext,bitIndex6)
          <=> v2153(VarCurr,bitIndex137) )
          & ( v5007(VarNext,bitIndex5)
          <=> v2153(VarCurr,bitIndex136) )
          & ( v5007(VarNext,bitIndex4)
          <=> v2153(VarCurr,bitIndex135) )
          & ( v5007(VarNext,bitIndex3)
          <=> v2153(VarCurr,bitIndex134) )
          & ( v5007(VarNext,bitIndex2)
          <=> v2153(VarCurr,bitIndex133) )
          & ( v5007(VarNext,bitIndex1)
          <=> v2153(VarCurr,bitIndex132) )
          & ( v5007(VarNext,bitIndex0)
          <=> v2153(VarCurr,bitIndex131) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_70,axiom,
    ! [VarNext] :
      ( v5008(VarNext)
     => ! [B] :
          ( range_130_0(B)
         => ( v5007(VarNext,B)
          <=> v5034(VarNext,B) ) ) ) ).

fof(addAssignment_1520,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_130_0(B)
         => ( v5034(VarNext,B)
          <=> v5032(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_69,axiom,
    ! [VarCurr] :
      ( ~ v2275(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v5032(VarCurr,B)
          <=> v5035(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_65,axiom,
    ! [VarCurr] :
      ( v2275(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v5032(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_40,axiom,
    ! [VarCurr] :
      ( ( ~ v5021(VarCurr)
        & ~ v5023(VarCurr) )
     => ! [B] :
          ( range_130_0(B)
         => ( v5035(VarCurr,B)
          <=> v5000(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_68,axiom,
    ! [VarCurr] :
      ( v5023(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v5035(VarCurr,B)
          <=> v4993(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_64,axiom,
    ! [VarCurr] :
      ( v5021(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v5035(VarCurr,B)
          <=> v2153(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_750,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5008(VarNext)
      <=> ( v5009(VarNext)
          & v5016(VarNext) ) ) ) ).

fof(addAssignment_1519,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5016(VarNext)
      <=> v5014(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_749,axiom,
    ! [VarCurr] :
      ( v5014(VarCurr)
    <=> ( v5017(VarCurr)
        & v5028(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_748,axiom,
    ! [VarCurr] :
      ( v5028(VarCurr)
    <=> ( v5029(VarCurr)
        | v2275(VarCurr) ) ) ).

fof(writeUnaryOperator_378,axiom,
    ! [VarCurr] :
      ( ~ v5029(VarCurr)
    <=> v5030(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_323,axiom,
    ! [VarCurr] :
      ( v5030(VarCurr)
    <=> ( ( v5031(VarCurr,bitIndex1)
        <=> $false )
        & ( v5031(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1518,axiom,
    ! [VarCurr] :
      ( v5031(VarCurr,bitIndex0)
    <=> v2155(VarCurr) ) ).

fof(addAssignment_1517,axiom,
    ! [VarCurr] :
      ( v5031(VarCurr,bitIndex1)
    <=> v29(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_747,axiom,
    ! [VarCurr] :
      ( v5017(VarCurr)
    <=> ( v2275(VarCurr)
        | v5018(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_746,axiom,
    ! [VarCurr] :
      ( v5018(VarCurr)
    <=> ( v5019(VarCurr)
        & v5027(VarCurr) ) ) ).

fof(writeUnaryOperator_377,axiom,
    ! [VarCurr] :
      ( ~ v5027(VarCurr)
    <=> v2275(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_745,axiom,
    ! [VarCurr] :
      ( v5019(VarCurr)
    <=> ( v5020(VarCurr)
        | v5025(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_322,axiom,
    ! [VarCurr] :
      ( v5025(VarCurr)
    <=> ( ( v5026(VarCurr,bitIndex1)
        <=> $true )
        & ( v5026(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1516,axiom,
    ! [VarCurr] :
      ( v5026(VarCurr,bitIndex0)
    <=> v2155(VarCurr) ) ).

fof(addAssignment_1515,axiom,
    ! [VarCurr] :
      ( v5026(VarCurr,bitIndex1)
    <=> v29(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_744,axiom,
    ! [VarCurr] :
      ( v5020(VarCurr)
    <=> ( v5021(VarCurr)
        | v5023(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_321,axiom,
    ! [VarCurr] :
      ( v5023(VarCurr)
    <=> ( ( v5024(VarCurr,bitIndex1)
        <=> $true )
        & ( v5024(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1514,axiom,
    ! [VarCurr] :
      ( v5024(VarCurr,bitIndex0)
    <=> v2155(VarCurr) ) ).

fof(addAssignment_1513,axiom,
    ! [VarCurr] :
      ( v5024(VarCurr,bitIndex1)
    <=> v29(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_320,axiom,
    ! [VarCurr] :
      ( v5021(VarCurr)
    <=> ( ( v5022(VarCurr,bitIndex1)
        <=> $false )
        & ( v5022(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1512,axiom,
    ! [VarCurr] :
      ( v5022(VarCurr,bitIndex0)
    <=> v2155(VarCurr) ) ).

fof(addAssignment_1511,axiom,
    ! [VarCurr] :
      ( v5022(VarCurr,bitIndex1)
    <=> v29(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_743,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5009(VarNext)
      <=> ( v5011(VarNext)
          & v2173(VarNext) ) ) ) ).

fof(writeUnaryOperator_376,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5011(VarNext)
      <=> v2182(VarNext) ) ) ).

fof(addAssignment_1510,axiom,
    ! [VarCurr,B] :
      ( range_130_124(B)
     => ( v5000(VarCurr,B)
      <=> v5005(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_133,axiom,
    ! [VarCurr] :
      ( ~ v5002(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v5005(VarCurr,B)
          <=> v5004(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_164,axiom,
    ! [VarCurr] :
      ( v5002(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v5005(VarCurr,B)
          <=> v2234(VarCurr,B) ) ) ) ).

fof(addAssignment_1509,axiom,
    ! [VarCurr,B] :
      ( range_130_124(B)
     => ( v5004(VarCurr,B)
      <=> v2153(VarCurr,B) ) ) ).

fof(addAssignment_1508,axiom,
    ! [VarCurr] :
      ( v5002(VarCurr)
    <=> v2167(VarCurr,bitIndex3) ) ).

fof(addAssignment_1507,axiom,
    ! [VarCurr,B] :
      ( range_130_124(B)
     => ( v4993(VarCurr,B)
      <=> v4998(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_132,axiom,
    ! [VarCurr] :
      ( ~ v4995(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v4998(VarCurr,B)
          <=> v4997(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_163,axiom,
    ! [VarCurr] :
      ( v4995(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v4998(VarCurr,B)
          <=> v2234(VarCurr,B) ) ) ) ).

fof(addAssignment_1506,axiom,
    ! [VarCurr] :
      ( ( v4997(VarCurr,bitIndex130)
      <=> v2153(VarCurr,bitIndex261) )
      & ( v4997(VarCurr,bitIndex129)
      <=> v2153(VarCurr,bitIndex260) )
      & ( v4997(VarCurr,bitIndex128)
      <=> v2153(VarCurr,bitIndex259) )
      & ( v4997(VarCurr,bitIndex127)
      <=> v2153(VarCurr,bitIndex258) )
      & ( v4997(VarCurr,bitIndex126)
      <=> v2153(VarCurr,bitIndex257) )
      & ( v4997(VarCurr,bitIndex125)
      <=> v2153(VarCurr,bitIndex256) )
      & ( v4997(VarCurr,bitIndex124)
      <=> v2153(VarCurr,bitIndex255) ) ) ).

fof(addAssignment_1505,axiom,
    ! [VarCurr,B] :
      ( range_130_124(B)
     => ( v2234(VarCurr,B)
      <=> v2236(VarCurr,B) ) ) ).

fof(addAssignment_1504,axiom,
    ! [VarCurr,B] :
      ( range_130_124(B)
     => ( v2236(VarCurr,B)
      <=> v2238(VarCurr,B) ) ) ).

fof(addAssignment_1503,axiom,
    ! [VarCurr,B] :
      ( range_130_124(B)
     => ( v2238(VarCurr,B)
      <=> v2240(VarCurr,B) ) ) ).

fof(addAssignment_1502,axiom,
    ! [VarCurr,B] :
      ( range_130_124(B)
     => ( v2240(VarCurr,B)
      <=> v2243(VarCurr,B) ) ) ).

fof(range_axiom_37,axiom,
    ! [B] :
      ( range_130_124(B)
    <=> ( $false
        | bitIndex124 = B
        | bitIndex125 = B
        | bitIndex126 = B
        | bitIndex127 = B
        | bitIndex128 = B
        | bitIndex129 = B
        | bitIndex130 = B ) ) ).

fof(addAssignment_1501,axiom,
    ! [VarCurr] :
      ( v4995(VarCurr)
    <=> v2167(VarCurr,bitIndex3) ) ).

fof(addAssignment_1500,axiom,
    ! [VarCurr] :
      ( v23(VarCurr)
    <=> v25(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_64,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4969(VarNext)
       => ( v25(VarNext)
        <=> v25(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_69,axiom,
    ! [VarNext] :
      ( v4969(VarNext)
     => ( v25(VarNext)
      <=> v4987(VarNext) ) ) ).

fof(addAssignment_1499,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4987(VarNext)
      <=> v4985(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_131,axiom,
    ! [VarCurr] :
      ( ~ v4984(VarCurr)
     => ( v4985(VarCurr)
      <=> v4988(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_162,axiom,
    ! [VarCurr] :
      ( v4984(VarCurr)
     => ( v4985(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_130,axiom,
    ! [VarCurr] :
      ( ~ v29(VarCurr)
     => ( v4988(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_161,axiom,
    ! [VarCurr] :
      ( v29(VarCurr)
     => ( v4988(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_742,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4969(VarNext)
      <=> ( v4970(VarNext)
          & v4977(VarNext) ) ) ) ).

fof(addAssignment_1498,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4977(VarNext)
      <=> v4975(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_741,axiom,
    ! [VarCurr] :
      ( v4975(VarCurr)
    <=> ( v4978(VarCurr)
        | v4984(VarCurr) ) ) ).

fof(writeUnaryOperator_375,axiom,
    ! [VarCurr] :
      ( ~ v4984(VarCurr)
    <=> v27(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_740,axiom,
    ! [VarCurr] :
      ( v4978(VarCurr)
    <=> ( v4979(VarCurr)
        | v29(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_739,axiom,
    ! [VarCurr] :
      ( v4979(VarCurr)
    <=> ( v4980(VarCurr)
        & v4983(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_319,axiom,
    ! [VarCurr] :
      ( v4983(VarCurr)
    <=> ( v2169(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_738,axiom,
    ! [VarCurr] :
      ( v4980(VarCurr)
    <=> ( v4981(VarCurr)
        & v4982(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_318,axiom,
    ! [VarCurr] :
      ( v4982(VarCurr)
    <=> ( v4917(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_317,axiom,
    ! [VarCurr] :
      ( v4981(VarCurr)
    <=> ( v2155(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_737,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4970(VarNext)
      <=> ( v4971(VarNext)
          & v2173(VarNext) ) ) ) ).

fof(writeUnaryOperator_374,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4971(VarNext)
      <=> v2182(VarNext) ) ) ).

fof(addAssignment_1497,axiom,
    ! [VarCurr] :
      ( v2169(VarCurr,bitIndex0)
    <=> v2192(VarCurr,bitIndex0) ) ).

fof(addAssignment_1496,axiom,
    ! [VarNext] :
      ( v4917(VarNext,bitIndex1)
    <=> v4960(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_63,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4961(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v4960(VarNext,B)
            <=> v4917(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_68,axiom,
    ! [VarNext] :
      ( v4961(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v4960(VarNext,B)
          <=> v4948(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_736,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4961(VarNext)
      <=> v4962(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_735,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4962(VarNext)
      <=> ( v4964(VarNext)
          & v2173(VarNext) ) ) ) ).

fof(writeUnaryOperator_373,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4964(VarNext)
      <=> v2182(VarNext) ) ) ).

fof(addAssignment_1495,axiom,
    ! [VarCurr] :
      ( v4919(VarCurr,bitIndex1)
    <=> v4924(VarCurr,bitIndex1) ) ).

fof(addAssignment_1494,axiom,
    ! [VarCurr] :
      ( v4921(VarCurr,bitIndex1)
    <=> v4922(VarCurr,bitIndex1) ) ).

fof(addAssignment_1493,axiom,
    ! [VarNext] :
      ( v4917(VarNext,bitIndex0)
    <=> v4952(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionEqualRanges1_62,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4953(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v4952(VarNext,B)
            <=> v4917(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_67,axiom,
    ! [VarNext] :
      ( v4953(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v4952(VarNext,B)
          <=> v4948(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_734,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4953(VarNext)
      <=> v4954(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_733,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4954(VarNext)
      <=> ( v4956(VarNext)
          & v2173(VarNext) ) ) ) ).

fof(writeUnaryOperator_372,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4956(VarNext)
      <=> v2182(VarNext) ) ) ).

fof(addAssignment_1492,axiom,
    ! [VarCurr] :
      ( v4919(VarCurr,bitIndex0)
    <=> v4924(VarCurr,bitIndex0) ) ).

fof(addAssignment_1491,axiom,
    ! [VarNext] :
      ( v4917(VarNext,bitIndex2)
    <=> v4939(VarNext,bitIndex2) ) ).

fof(addCaseBooleanConditionEqualRanges1_61,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4940(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v4939(VarNext,B)
            <=> v4917(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_66,axiom,
    ! [VarNext] :
      ( v4940(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v4939(VarNext,B)
          <=> v4948(VarNext,B) ) ) ) ).

fof(addAssignment_1490,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v4948(VarNext,B)
          <=> v4946(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_129,axiom,
    ! [VarCurr] :
      ( ~ v2189(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v4946(VarCurr,B)
          <=> v4919(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_160,axiom,
    ! [VarCurr] :
      ( v2189(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v4946(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_732,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4940(VarNext)
      <=> v4941(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_731,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4941(VarNext)
      <=> ( v4943(VarNext)
          & v2173(VarNext) ) ) ) ).

fof(writeUnaryOperator_371,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4943(VarNext)
      <=> v2182(VarNext) ) ) ).

fof(addAssignment_1489,axiom,
    ! [VarCurr] :
      ( v4919(VarCurr,bitIndex2)
    <=> v4924(VarCurr,bitIndex2) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_128,axiom,
    ! [VarCurr] :
      ( ~ v4925(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v4924(VarCurr,B)
          <=> v4926(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_159,axiom,
    ! [VarCurr] :
      ( v4925(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v4924(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_24,axiom,
    ! [VarCurr] :
      ( ( ~ v4927(VarCurr)
        & ~ v4929(VarCurr)
        & ~ v4933(VarCurr) )
     => ! [B] :
          ( range_3_0(B)
         => ( v4926(VarCurr,B)
          <=> v4917(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_39,axiom,
    ! [VarCurr] :
      ( v4933(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v4926(VarCurr,B)
          <=> v4935(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_67,axiom,
    ! [VarCurr] :
      ( v4929(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v4926(VarCurr,B)
          <=> v4931(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_63,axiom,
    ! [VarCurr] :
      ( v4927(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v4926(VarCurr,B)
          <=> v4917(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_316,axiom,
    ! [VarCurr] :
      ( v4936(VarCurr)
    <=> ( ( v4937(VarCurr,bitIndex1)
        <=> $true )
        & ( v4937(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1488,axiom,
    ! [VarCurr] :
      ( v4937(VarCurr,bitIndex0)
    <=> v2155(VarCurr) ) ).

fof(addAssignment_1487,axiom,
    ! [VarCurr] :
      ( v4937(VarCurr,bitIndex1)
    <=> v29(VarCurr) ) ).

fof(addAssignment_1486,axiom,
    ! [VarCurr] :
      ( v4935(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_1485,axiom,
    ! [VarCurr,B] :
      ( range_3_1(B)
     => ( v4935(VarCurr,B)
      <=> v4921(VarCurr,B) ) ) ).

fof(addBitVectorEqualityBitBlasted_315,axiom,
    ! [VarCurr] :
      ( v4933(VarCurr)
    <=> ( ( v4934(VarCurr,bitIndex1)
        <=> $true )
        & ( v4934(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1484,axiom,
    ! [VarCurr] :
      ( v4934(VarCurr,bitIndex0)
    <=> v2155(VarCurr) ) ).

fof(addAssignment_1483,axiom,
    ! [VarCurr] :
      ( v4934(VarCurr,bitIndex1)
    <=> v29(VarCurr) ) ).

fof(addAssignment_1482,axiom,
    ! [VarCurr] :
      ( ( v4931(VarCurr,bitIndex2)
      <=> v4917(VarCurr,bitIndex3) )
      & ( v4931(VarCurr,bitIndex1)
      <=> v4917(VarCurr,bitIndex2) )
      & ( v4931(VarCurr,bitIndex0)
      <=> v4917(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_1481,axiom,
    ! [VarCurr] :
      ( v4931(VarCurr,bitIndex3)
    <=> $false ) ).

fof(addBitVectorEqualityBitBlasted_314,axiom,
    ! [VarCurr] :
      ( v4929(VarCurr)
    <=> ( ( v4930(VarCurr,bitIndex1)
        <=> $false )
        & ( v4930(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1480,axiom,
    ! [VarCurr] :
      ( v4930(VarCurr,bitIndex0)
    <=> v2155(VarCurr) ) ).

fof(addAssignment_1479,axiom,
    ! [VarCurr] :
      ( v4930(VarCurr,bitIndex1)
    <=> v29(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_313,axiom,
    ! [VarCurr] :
      ( v4927(VarCurr)
    <=> ( ( v4928(VarCurr,bitIndex1)
        <=> $false )
        & ( v4928(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1478,axiom,
    ! [VarCurr] :
      ( v4928(VarCurr,bitIndex0)
    <=> v2155(VarCurr) ) ).

fof(addAssignment_1477,axiom,
    ! [VarCurr] :
      ( v4928(VarCurr,bitIndex1)
    <=> v29(VarCurr) ) ).

fof(writeUnaryOperator_370,axiom,
    ! [VarCurr] :
      ( ~ v4925(VarCurr)
    <=> v27(VarCurr) ) ).

fof(addAssignment_1476,axiom,
    ! [VarCurr] :
      ( v4921(VarCurr,bitIndex2)
    <=> v4922(VarCurr,bitIndex2) ) ).

fof(addAssignment_1475,axiom,
    ! [VarCurr] :
      ( v4922(VarCurr,bitIndex0)
    <=> $false ) ).

fof(addAssignment_1474,axiom,
    ! [VarCurr] :
      ( ( v4922(VarCurr,bitIndex3)
      <=> v4917(VarCurr,bitIndex2) )
      & ( v4922(VarCurr,bitIndex2)
      <=> v4917(VarCurr,bitIndex1) )
      & ( v4922(VarCurr,bitIndex1)
      <=> v4917(VarCurr,bitIndex0) ) ) ).

fof(addAssignmentInitValueVector_132,axiom,
    ! [B] :
      ( range_3_0(B)
     => ( v4917(constB0,B)
      <=> $false ) ) ).

fof(addAssignment_1473,axiom,
    ! [VarCurr] :
      ( v29(VarCurr)
    <=> v31(VarCurr) ) ).

fof(addAssignment_1472,axiom,
    ! [VarCurr] :
      ( v31(VarCurr)
    <=> v33(VarCurr) ) ).

fof(addAssignment_1471,axiom,
    ! [VarCurr] :
      ( v33(VarCurr)
    <=> v35(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_127,axiom,
    ! [VarCurr] :
      ( ~ v4909(VarCurr)
     => ( v35(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_158,axiom,
    ! [VarCurr] :
      ( v4909(VarCurr)
     => ( v35(VarCurr)
      <=> v4914(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_66,axiom,
    ! [VarCurr] :
      ( ~ v4911(VarCurr)
     => ( v4914(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_62,axiom,
    ! [VarCurr] :
      ( v4911(VarCurr)
     => ( v4914(VarCurr)
      <=> v4915(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_126,axiom,
    ! [VarCurr] :
      ( ~ v4421(VarCurr)
     => ( v4915(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_157,axiom,
    ! [VarCurr] :
      ( v4421(VarCurr)
     => ( v4915(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_730,axiom,
    ! [VarCurr] :
      ( v4909(VarCurr)
    <=> ( v4910(VarCurr)
        & v4913(VarCurr) ) ) ).

fof(writeUnaryOperator_369,axiom,
    ! [VarCurr] :
      ( ~ v4913(VarCurr)
    <=> v4274(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_729,axiom,
    ! [VarCurr] :
      ( v4910(VarCurr)
    <=> ( v4911(VarCurr)
        | v4912(VarCurr) ) ) ).

fof(writeUnaryOperator_368,axiom,
    ! [VarCurr] :
      ( ~ v4912(VarCurr)
    <=> v4271(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_728,axiom,
    ! [VarCurr] :
      ( v4911(VarCurr)
    <=> ( v4486(VarCurr)
        & v4271(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_125,axiom,
    ! [VarCurr] :
      ( ~ v39(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v37(VarCurr,B)
          <=> v4839(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_156,axiom,
    ! [VarCurr] :
      ( v39(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v37(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_3,axiom,
    ! [VarCurr] :
      ( ( ~ v4840(VarCurr)
        & ~ v4877(VarCurr)
        & ~ v4885(VarCurr)
        & ~ v4893(VarCurr) )
     => ! [B] :
          ( range_1_0(B)
         => ( v4839(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_23,axiom,
    ! [VarCurr] :
      ( v4893(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v4839(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_38,axiom,
    ! [VarCurr] :
      ( v4885(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v4839(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_65,axiom,
    ! [VarCurr] :
      ( v4877(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v4839(VarCurr,B)
          <=> v4884(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_61,axiom,
    ! [VarCurr] :
      ( v4840(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v4839(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_727,axiom,
    ! [VarCurr] :
      ( v4893(VarCurr)
    <=> ( v4895(VarCurr)
        | v4904(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_726,axiom,
    ! [VarCurr] :
      ( v4904(VarCurr)
    <=> ( v4906(VarCurr)
        & v4859(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_279,axiom,
    ! [VarCurr] :
      ( v4906(VarCurr)
    <=> ( v4907(VarCurr)
        & v4564(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_278,axiom,
    ! [VarCurr] :
      ( v4907(VarCurr)
    <=> ( v4856(VarCurr)
        & v4564(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_725,axiom,
    ! [VarCurr] :
      ( v4895(VarCurr)
    <=> ( v4896(VarCurr)
        | v4901(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_277,axiom,
    ! [VarCurr] :
      ( v4901(VarCurr)
    <=> ( v4903(VarCurr)
        & v4564(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_276,axiom,
    ! [VarCurr] :
      ( v4903(VarCurr)
    <=> ( v4899(VarCurr)
        & v4564(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_275,axiom,
    ! [VarCurr] :
      ( v4896(VarCurr)
    <=> ( v4898(VarCurr)
        & v4564(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_724,axiom,
    ! [VarCurr] :
      ( v4898(VarCurr)
    <=> ( v4899(VarCurr)
        & v4858(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_274,axiom,
    ! [VarCurr] :
      ( v4899(VarCurr)
    <=> ( v4900(VarCurr)
        & v4564(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_273,axiom,
    ! [VarCurr] :
      ( v4900(VarCurr)
    <=> ( v4851(VarCurr)
        & v4564(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_723,axiom,
    ! [VarCurr] :
      ( v4885(VarCurr)
    <=> ( v4886(VarCurr)
        | v4888(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_722,axiom,
    ! [VarCurr] :
      ( v4888(VarCurr)
    <=> ( v4890(VarCurr)
        & v4859(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_721,axiom,
    ! [VarCurr] :
      ( v4890(VarCurr)
    <=> ( v4891(VarCurr)
        & v4858(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_720,axiom,
    ! [VarCurr] :
      ( v4891(VarCurr)
    <=> ( v4892(VarCurr)
        & v4857(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_272,axiom,
    ! [VarCurr] :
      ( v4892(VarCurr)
    <=> ( v4868(VarCurr)
        & v4564(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_271,axiom,
    ! [VarCurr] :
      ( v4886(VarCurr)
    <=> ( v4879(VarCurr)
        & v4564(VarCurr,bitIndex6) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_124,axiom,
    ! [VarCurr] :
      ( ~ v4777(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v4884(VarCurr,B)
          <=> $false ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_155,axiom,
    ! [VarCurr] :
      ( v4777(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v4884(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_719,axiom,
    ! [VarCurr] :
      ( v4877(VarCurr)
    <=> ( v4879(VarCurr)
        & v4859(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_718,axiom,
    ! [VarCurr] :
      ( v4879(VarCurr)
    <=> ( v4880(VarCurr)
        & v4858(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_717,axiom,
    ! [VarCurr] :
      ( v4880(VarCurr)
    <=> ( v4881(VarCurr)
        & v4857(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_270,axiom,
    ! [VarCurr] :
      ( v4881(VarCurr)
    <=> ( v4882(VarCurr)
        & v4564(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_716,axiom,
    ! [VarCurr] :
      ( v4882(VarCurr)
    <=> ( v4883(VarCurr)
        & v4855(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_269,axiom,
    ! [VarCurr] :
      ( v4883(VarCurr)
    <=> ( v4853(VarCurr)
        & v4564(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_715,axiom,
    ! [VarCurr] :
      ( v4840(VarCurr)
    <=> ( v4842(VarCurr)
        | v4875(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_268,axiom,
    ! [VarCurr] :
      ( v4875(VarCurr)
    <=> ( v4862(VarCurr)
        & v4564(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_714,axiom,
    ! [VarCurr] :
      ( v4842(VarCurr)
    <=> ( v4843(VarCurr)
        | v4873(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_267,axiom,
    ! [VarCurr] :
      ( v4873(VarCurr)
    <=> ( v4848(VarCurr)
        & v4564(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_713,axiom,
    ! [VarCurr] :
      ( v4843(VarCurr)
    <=> ( v4844(VarCurr)
        | v4870(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_712,axiom,
    ! [VarCurr] :
      ( v4870(VarCurr)
    <=> ( v4872(VarCurr)
        & v4859(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_266,axiom,
    ! [VarCurr] :
      ( v4872(VarCurr)
    <=> ( v4866(VarCurr)
        & v4564(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_711,axiom,
    ! [VarCurr] :
      ( v4844(VarCurr)
    <=> ( v4845(VarCurr)
        | v4863(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_710,axiom,
    ! [VarCurr] :
      ( v4863(VarCurr)
    <=> ( v4865(VarCurr)
        & v4859(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_709,axiom,
    ! [VarCurr] :
      ( v4865(VarCurr)
    <=> ( v4866(VarCurr)
        & v4858(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_708,axiom,
    ! [VarCurr] :
      ( v4866(VarCurr)
    <=> ( v4867(VarCurr)
        & v4857(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_707,axiom,
    ! [VarCurr] :
      ( v4867(VarCurr)
    <=> ( v4868(VarCurr)
        & v4856(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_706,axiom,
    ! [VarCurr] :
      ( v4868(VarCurr)
    <=> ( v4869(VarCurr)
        & v4855(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_705,axiom,
    ! [VarCurr] :
      ( v4869(VarCurr)
    <=> ( v4564(VarCurr,bitIndex0)
        & v4854(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_704,axiom,
    ! [VarCurr] :
      ( v4845(VarCurr)
    <=> ( v4846(VarCurr)
        | v4860(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_703,axiom,
    ! [VarCurr] :
      ( v4860(VarCurr)
    <=> ( v4862(VarCurr)
        & v4859(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_265,axiom,
    ! [VarCurr] :
      ( v4862(VarCurr)
    <=> ( v4849(VarCurr)
        & v4564(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_702,axiom,
    ! [VarCurr] :
      ( v4846(VarCurr)
    <=> ( v4848(VarCurr)
        & v4859(VarCurr) ) ) ).

fof(writeUnaryOperator_367,axiom,
    ! [VarCurr] :
      ( ~ v4859(VarCurr)
    <=> v4564(VarCurr,bitIndex6) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_701,axiom,
    ! [VarCurr] :
      ( v4848(VarCurr)
    <=> ( v4849(VarCurr)
        & v4858(VarCurr) ) ) ).

fof(writeUnaryOperator_366,axiom,
    ! [VarCurr] :
      ( ~ v4858(VarCurr)
    <=> v4564(VarCurr,bitIndex5) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_700,axiom,
    ! [VarCurr] :
      ( v4849(VarCurr)
    <=> ( v4850(VarCurr)
        & v4857(VarCurr) ) ) ).

fof(writeUnaryOperator_365,axiom,
    ! [VarCurr] :
      ( ~ v4857(VarCurr)
    <=> v4564(VarCurr,bitIndex4) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_699,axiom,
    ! [VarCurr] :
      ( v4850(VarCurr)
    <=> ( v4851(VarCurr)
        & v4856(VarCurr) ) ) ).

fof(writeUnaryOperator_364,axiom,
    ! [VarCurr] :
      ( ~ v4856(VarCurr)
    <=> v4564(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_698,axiom,
    ! [VarCurr] :
      ( v4851(VarCurr)
    <=> ( v4852(VarCurr)
        & v4855(VarCurr) ) ) ).

fof(writeUnaryOperator_363,axiom,
    ! [VarCurr] :
      ( ~ v4855(VarCurr)
    <=> v4564(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_697,axiom,
    ! [VarCurr] :
      ( v4852(VarCurr)
    <=> ( v4853(VarCurr)
        & v4854(VarCurr) ) ) ).

fof(writeUnaryOperator_362,axiom,
    ! [VarCurr] :
      ( ~ v4854(VarCurr)
    <=> v4564(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_361,axiom,
    ! [VarCurr] :
      ( ~ v4853(VarCurr)
    <=> v4564(VarCurr,bitIndex0) ) ).

fof(addAssignment_1470,axiom,
    ! [VarCurr] :
      ( v4777(VarCurr)
    <=> v2244(VarCurr,bitIndex81) ) ).

fof(addAssignment_1469,axiom,
    ! [VarCurr] :
      ( v2244(VarCurr,bitIndex81)
    <=> v4567(VarCurr,bitIndex81) ) ).

fof(addAssignment_1468,axiom,
    ! [VarCurr] :
      ( v4567(VarCurr,bitIndex81)
    <=> v4569(VarCurr,bitIndex696) ) ).

fof(addAssignment_1467,axiom,
    ! [VarNext] :
      ( v4569(VarNext,bitIndex696)
    <=> v4831(VarNext,bitIndex81) ) ).

fof(addCaseBooleanConditionShiftedRanges1_7,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4833(VarNext)
       => ( ( v4831(VarNext,bitIndex122)
          <=> v4569(VarCurr,bitIndex737) )
          & ( v4831(VarNext,bitIndex121)
          <=> v4569(VarCurr,bitIndex736) )
          & ( v4831(VarNext,bitIndex120)
          <=> v4569(VarCurr,bitIndex735) )
          & ( v4831(VarNext,bitIndex119)
          <=> v4569(VarCurr,bitIndex734) )
          & ( v4831(VarNext,bitIndex118)
          <=> v4569(VarCurr,bitIndex733) )
          & ( v4831(VarNext,bitIndex117)
          <=> v4569(VarCurr,bitIndex732) )
          & ( v4831(VarNext,bitIndex116)
          <=> v4569(VarCurr,bitIndex731) )
          & ( v4831(VarNext,bitIndex115)
          <=> v4569(VarCurr,bitIndex730) )
          & ( v4831(VarNext,bitIndex114)
          <=> v4569(VarCurr,bitIndex729) )
          & ( v4831(VarNext,bitIndex113)
          <=> v4569(VarCurr,bitIndex728) )
          & ( v4831(VarNext,bitIndex112)
          <=> v4569(VarCurr,bitIndex727) )
          & ( v4831(VarNext,bitIndex111)
          <=> v4569(VarCurr,bitIndex726) )
          & ( v4831(VarNext,bitIndex110)
          <=> v4569(VarCurr,bitIndex725) )
          & ( v4831(VarNext,bitIndex109)
          <=> v4569(VarCurr,bitIndex724) )
          & ( v4831(VarNext,bitIndex108)
          <=> v4569(VarCurr,bitIndex723) )
          & ( v4831(VarNext,bitIndex107)
          <=> v4569(VarCurr,bitIndex722) )
          & ( v4831(VarNext,bitIndex106)
          <=> v4569(VarCurr,bitIndex721) )
          & ( v4831(VarNext,bitIndex105)
          <=> v4569(VarCurr,bitIndex720) )
          & ( v4831(VarNext,bitIndex104)
          <=> v4569(VarCurr,bitIndex719) )
          & ( v4831(VarNext,bitIndex103)
          <=> v4569(VarCurr,bitIndex718) )
          & ( v4831(VarNext,bitIndex102)
          <=> v4569(VarCurr,bitIndex717) )
          & ( v4831(VarNext,bitIndex101)
          <=> v4569(VarCurr,bitIndex716) )
          & ( v4831(VarNext,bitIndex100)
          <=> v4569(VarCurr,bitIndex715) )
          & ( v4831(VarNext,bitIndex99)
          <=> v4569(VarCurr,bitIndex714) )
          & ( v4831(VarNext,bitIndex98)
          <=> v4569(VarCurr,bitIndex713) )
          & ( v4831(VarNext,bitIndex97)
          <=> v4569(VarCurr,bitIndex712) )
          & ( v4831(VarNext,bitIndex96)
          <=> v4569(VarCurr,bitIndex711) )
          & ( v4831(VarNext,bitIndex95)
          <=> v4569(VarCurr,bitIndex710) )
          & ( v4831(VarNext,bitIndex94)
          <=> v4569(VarCurr,bitIndex709) )
          & ( v4831(VarNext,bitIndex93)
          <=> v4569(VarCurr,bitIndex708) )
          & ( v4831(VarNext,bitIndex92)
          <=> v4569(VarCurr,bitIndex707) )
          & ( v4831(VarNext,bitIndex91)
          <=> v4569(VarCurr,bitIndex706) )
          & ( v4831(VarNext,bitIndex90)
          <=> v4569(VarCurr,bitIndex705) )
          & ( v4831(VarNext,bitIndex89)
          <=> v4569(VarCurr,bitIndex704) )
          & ( v4831(VarNext,bitIndex88)
          <=> v4569(VarCurr,bitIndex703) )
          & ( v4831(VarNext,bitIndex87)
          <=> v4569(VarCurr,bitIndex702) )
          & ( v4831(VarNext,bitIndex86)
          <=> v4569(VarCurr,bitIndex701) )
          & ( v4831(VarNext,bitIndex85)
          <=> v4569(VarCurr,bitIndex700) )
          & ( v4831(VarNext,bitIndex84)
          <=> v4569(VarCurr,bitIndex699) )
          & ( v4831(VarNext,bitIndex83)
          <=> v4569(VarCurr,bitIndex698) )
          & ( v4831(VarNext,bitIndex82)
          <=> v4569(VarCurr,bitIndex697) )
          & ( v4831(VarNext,bitIndex81)
          <=> v4569(VarCurr,bitIndex696) )
          & ( v4831(VarNext,bitIndex80)
          <=> v4569(VarCurr,bitIndex695) )
          & ( v4831(VarNext,bitIndex79)
          <=> v4569(VarCurr,bitIndex694) )
          & ( v4831(VarNext,bitIndex78)
          <=> v4569(VarCurr,bitIndex693) )
          & ( v4831(VarNext,bitIndex77)
          <=> v4569(VarCurr,bitIndex692) )
          & ( v4831(VarNext,bitIndex76)
          <=> v4569(VarCurr,bitIndex691) )
          & ( v4831(VarNext,bitIndex75)
          <=> v4569(VarCurr,bitIndex690) )
          & ( v4831(VarNext,bitIndex74)
          <=> v4569(VarCurr,bitIndex689) )
          & ( v4831(VarNext,bitIndex73)
          <=> v4569(VarCurr,bitIndex688) )
          & ( v4831(VarNext,bitIndex72)
          <=> v4569(VarCurr,bitIndex687) )
          & ( v4831(VarNext,bitIndex71)
          <=> v4569(VarCurr,bitIndex686) )
          & ( v4831(VarNext,bitIndex70)
          <=> v4569(VarCurr,bitIndex685) )
          & ( v4831(VarNext,bitIndex69)
          <=> v4569(VarCurr,bitIndex684) )
          & ( v4831(VarNext,bitIndex68)
          <=> v4569(VarCurr,bitIndex683) )
          & ( v4831(VarNext,bitIndex67)
          <=> v4569(VarCurr,bitIndex682) )
          & ( v4831(VarNext,bitIndex66)
          <=> v4569(VarCurr,bitIndex681) )
          & ( v4831(VarNext,bitIndex65)
          <=> v4569(VarCurr,bitIndex680) )
          & ( v4831(VarNext,bitIndex64)
          <=> v4569(VarCurr,bitIndex679) )
          & ( v4831(VarNext,bitIndex63)
          <=> v4569(VarCurr,bitIndex678) )
          & ( v4831(VarNext,bitIndex62)
          <=> v4569(VarCurr,bitIndex677) )
          & ( v4831(VarNext,bitIndex61)
          <=> v4569(VarCurr,bitIndex676) )
          & ( v4831(VarNext,bitIndex60)
          <=> v4569(VarCurr,bitIndex675) )
          & ( v4831(VarNext,bitIndex59)
          <=> v4569(VarCurr,bitIndex674) )
          & ( v4831(VarNext,bitIndex58)
          <=> v4569(VarCurr,bitIndex673) )
          & ( v4831(VarNext,bitIndex57)
          <=> v4569(VarCurr,bitIndex672) )
          & ( v4831(VarNext,bitIndex56)
          <=> v4569(VarCurr,bitIndex671) )
          & ( v4831(VarNext,bitIndex55)
          <=> v4569(VarCurr,bitIndex670) )
          & ( v4831(VarNext,bitIndex54)
          <=> v4569(VarCurr,bitIndex669) )
          & ( v4831(VarNext,bitIndex53)
          <=> v4569(VarCurr,bitIndex668) )
          & ( v4831(VarNext,bitIndex52)
          <=> v4569(VarCurr,bitIndex667) )
          & ( v4831(VarNext,bitIndex51)
          <=> v4569(VarCurr,bitIndex666) )
          & ( v4831(VarNext,bitIndex50)
          <=> v4569(VarCurr,bitIndex665) )
          & ( v4831(VarNext,bitIndex49)
          <=> v4569(VarCurr,bitIndex664) )
          & ( v4831(VarNext,bitIndex48)
          <=> v4569(VarCurr,bitIndex663) )
          & ( v4831(VarNext,bitIndex47)
          <=> v4569(VarCurr,bitIndex662) )
          & ( v4831(VarNext,bitIndex46)
          <=> v4569(VarCurr,bitIndex661) )
          & ( v4831(VarNext,bitIndex45)
          <=> v4569(VarCurr,bitIndex660) )
          & ( v4831(VarNext,bitIndex44)
          <=> v4569(VarCurr,bitIndex659) )
          & ( v4831(VarNext,bitIndex43)
          <=> v4569(VarCurr,bitIndex658) )
          & ( v4831(VarNext,bitIndex42)
          <=> v4569(VarCurr,bitIndex657) )
          & ( v4831(VarNext,bitIndex41)
          <=> v4569(VarCurr,bitIndex656) )
          & ( v4831(VarNext,bitIndex40)
          <=> v4569(VarCurr,bitIndex655) )
          & ( v4831(VarNext,bitIndex39)
          <=> v4569(VarCurr,bitIndex654) )
          & ( v4831(VarNext,bitIndex38)
          <=> v4569(VarCurr,bitIndex653) )
          & ( v4831(VarNext,bitIndex37)
          <=> v4569(VarCurr,bitIndex652) )
          & ( v4831(VarNext,bitIndex36)
          <=> v4569(VarCurr,bitIndex651) )
          & ( v4831(VarNext,bitIndex35)
          <=> v4569(VarCurr,bitIndex650) )
          & ( v4831(VarNext,bitIndex34)
          <=> v4569(VarCurr,bitIndex649) )
          & ( v4831(VarNext,bitIndex33)
          <=> v4569(VarCurr,bitIndex648) )
          & ( v4831(VarNext,bitIndex32)
          <=> v4569(VarCurr,bitIndex647) )
          & ( v4831(VarNext,bitIndex31)
          <=> v4569(VarCurr,bitIndex646) )
          & ( v4831(VarNext,bitIndex30)
          <=> v4569(VarCurr,bitIndex645) )
          & ( v4831(VarNext,bitIndex29)
          <=> v4569(VarCurr,bitIndex644) )
          & ( v4831(VarNext,bitIndex28)
          <=> v4569(VarCurr,bitIndex643) )
          & ( v4831(VarNext,bitIndex27)
          <=> v4569(VarCurr,bitIndex642) )
          & ( v4831(VarNext,bitIndex26)
          <=> v4569(VarCurr,bitIndex641) )
          & ( v4831(VarNext,bitIndex25)
          <=> v4569(VarCurr,bitIndex640) )
          & ( v4831(VarNext,bitIndex24)
          <=> v4569(VarCurr,bitIndex639) )
          & ( v4831(VarNext,bitIndex23)
          <=> v4569(VarCurr,bitIndex638) )
          & ( v4831(VarNext,bitIndex22)
          <=> v4569(VarCurr,bitIndex637) )
          & ( v4831(VarNext,bitIndex21)
          <=> v4569(VarCurr,bitIndex636) )
          & ( v4831(VarNext,bitIndex20)
          <=> v4569(VarCurr,bitIndex635) )
          & ( v4831(VarNext,bitIndex19)
          <=> v4569(VarCurr,bitIndex634) )
          & ( v4831(VarNext,bitIndex18)
          <=> v4569(VarCurr,bitIndex633) )
          & ( v4831(VarNext,bitIndex17)
          <=> v4569(VarCurr,bitIndex632) )
          & ( v4831(VarNext,bitIndex16)
          <=> v4569(VarCurr,bitIndex631) )
          & ( v4831(VarNext,bitIndex15)
          <=> v4569(VarCurr,bitIndex630) )
          & ( v4831(VarNext,bitIndex14)
          <=> v4569(VarCurr,bitIndex629) )
          & ( v4831(VarNext,bitIndex13)
          <=> v4569(VarCurr,bitIndex628) )
          & ( v4831(VarNext,bitIndex12)
          <=> v4569(VarCurr,bitIndex627) )
          & ( v4831(VarNext,bitIndex11)
          <=> v4569(VarCurr,bitIndex626) )
          & ( v4831(VarNext,bitIndex10)
          <=> v4569(VarCurr,bitIndex625) )
          & ( v4831(VarNext,bitIndex9)
          <=> v4569(VarCurr,bitIndex624) )
          & ( v4831(VarNext,bitIndex8)
          <=> v4569(VarCurr,bitIndex623) )
          & ( v4831(VarNext,bitIndex7)
          <=> v4569(VarCurr,bitIndex622) )
          & ( v4831(VarNext,bitIndex6)
          <=> v4569(VarCurr,bitIndex621) )
          & ( v4831(VarNext,bitIndex5)
          <=> v4569(VarCurr,bitIndex620) )
          & ( v4831(VarNext,bitIndex4)
          <=> v4569(VarCurr,bitIndex619) )
          & ( v4831(VarNext,bitIndex3)
          <=> v4569(VarCurr,bitIndex618) )
          & ( v4831(VarNext,bitIndex2)
          <=> v4569(VarCurr,bitIndex617) )
          & ( v4831(VarNext,bitIndex1)
          <=> v4569(VarCurr,bitIndex616) )
          & ( v4831(VarNext,bitIndex0)
          <=> v4569(VarCurr,bitIndex615) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_65,axiom,
    ! [VarNext] :
      ( v4833(VarNext)
     => ! [B] :
          ( range_122_0(B)
         => ( v4831(VarNext,B)
          <=> v4771(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_696,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4833(VarNext)
      <=> ( v4834(VarNext)
          & v4753(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_695,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4834(VarNext)
      <=> ( v4836(VarNext)
          & v4515(VarNext) ) ) ) ).

fof(writeUnaryOperator_360,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4836(VarNext)
      <=> v4522(VarNext) ) ) ).

fof(addAssignment_1466,axiom,
    ! [VarCurr] :
      ( v4737(VarCurr,bitIndex81)
    <=> v4742(VarCurr,bitIndex81) ) ).

fof(addAssignment_1465,axiom,
    ! [VarCurr] :
      ( v4741(VarCurr,bitIndex81)
    <=> v4569(VarCurr,bitIndex573) ) ).

fof(addAssignment_1464,axiom,
    ! [VarCurr] :
      ( v4730(VarCurr,bitIndex81)
    <=> v4735(VarCurr,bitIndex81) ) ).

fof(addAssignment_1463,axiom,
    ! [VarCurr] :
      ( v4734(VarCurr,bitIndex81)
    <=> v4569(VarCurr,bitIndex696) ) ).

fof(addAssignment_1462,axiom,
    ! [VarNext] :
      ( v4569(VarNext,bitIndex573)
    <=> v4823(VarNext,bitIndex81) ) ).

fof(addCaseBooleanConditionShiftedRanges1_6,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4825(VarNext)
       => ( ( v4823(VarNext,bitIndex122)
          <=> v4569(VarCurr,bitIndex614) )
          & ( v4823(VarNext,bitIndex121)
          <=> v4569(VarCurr,bitIndex613) )
          & ( v4823(VarNext,bitIndex120)
          <=> v4569(VarCurr,bitIndex612) )
          & ( v4823(VarNext,bitIndex119)
          <=> v4569(VarCurr,bitIndex611) )
          & ( v4823(VarNext,bitIndex118)
          <=> v4569(VarCurr,bitIndex610) )
          & ( v4823(VarNext,bitIndex117)
          <=> v4569(VarCurr,bitIndex609) )
          & ( v4823(VarNext,bitIndex116)
          <=> v4569(VarCurr,bitIndex608) )
          & ( v4823(VarNext,bitIndex115)
          <=> v4569(VarCurr,bitIndex607) )
          & ( v4823(VarNext,bitIndex114)
          <=> v4569(VarCurr,bitIndex606) )
          & ( v4823(VarNext,bitIndex113)
          <=> v4569(VarCurr,bitIndex605) )
          & ( v4823(VarNext,bitIndex112)
          <=> v4569(VarCurr,bitIndex604) )
          & ( v4823(VarNext,bitIndex111)
          <=> v4569(VarCurr,bitIndex603) )
          & ( v4823(VarNext,bitIndex110)
          <=> v4569(VarCurr,bitIndex602) )
          & ( v4823(VarNext,bitIndex109)
          <=> v4569(VarCurr,bitIndex601) )
          & ( v4823(VarNext,bitIndex108)
          <=> v4569(VarCurr,bitIndex600) )
          & ( v4823(VarNext,bitIndex107)
          <=> v4569(VarCurr,bitIndex599) )
          & ( v4823(VarNext,bitIndex106)
          <=> v4569(VarCurr,bitIndex598) )
          & ( v4823(VarNext,bitIndex105)
          <=> v4569(VarCurr,bitIndex597) )
          & ( v4823(VarNext,bitIndex104)
          <=> v4569(VarCurr,bitIndex596) )
          & ( v4823(VarNext,bitIndex103)
          <=> v4569(VarCurr,bitIndex595) )
          & ( v4823(VarNext,bitIndex102)
          <=> v4569(VarCurr,bitIndex594) )
          & ( v4823(VarNext,bitIndex101)
          <=> v4569(VarCurr,bitIndex593) )
          & ( v4823(VarNext,bitIndex100)
          <=> v4569(VarCurr,bitIndex592) )
          & ( v4823(VarNext,bitIndex99)
          <=> v4569(VarCurr,bitIndex591) )
          & ( v4823(VarNext,bitIndex98)
          <=> v4569(VarCurr,bitIndex590) )
          & ( v4823(VarNext,bitIndex97)
          <=> v4569(VarCurr,bitIndex589) )
          & ( v4823(VarNext,bitIndex96)
          <=> v4569(VarCurr,bitIndex588) )
          & ( v4823(VarNext,bitIndex95)
          <=> v4569(VarCurr,bitIndex587) )
          & ( v4823(VarNext,bitIndex94)
          <=> v4569(VarCurr,bitIndex586) )
          & ( v4823(VarNext,bitIndex93)
          <=> v4569(VarCurr,bitIndex585) )
          & ( v4823(VarNext,bitIndex92)
          <=> v4569(VarCurr,bitIndex584) )
          & ( v4823(VarNext,bitIndex91)
          <=> v4569(VarCurr,bitIndex583) )
          & ( v4823(VarNext,bitIndex90)
          <=> v4569(VarCurr,bitIndex582) )
          & ( v4823(VarNext,bitIndex89)
          <=> v4569(VarCurr,bitIndex581) )
          & ( v4823(VarNext,bitIndex88)
          <=> v4569(VarCurr,bitIndex580) )
          & ( v4823(VarNext,bitIndex87)
          <=> v4569(VarCurr,bitIndex579) )
          & ( v4823(VarNext,bitIndex86)
          <=> v4569(VarCurr,bitIndex578) )
          & ( v4823(VarNext,bitIndex85)
          <=> v4569(VarCurr,bitIndex577) )
          & ( v4823(VarNext,bitIndex84)
          <=> v4569(VarCurr,bitIndex576) )
          & ( v4823(VarNext,bitIndex83)
          <=> v4569(VarCurr,bitIndex575) )
          & ( v4823(VarNext,bitIndex82)
          <=> v4569(VarCurr,bitIndex574) )
          & ( v4823(VarNext,bitIndex81)
          <=> v4569(VarCurr,bitIndex573) )
          & ( v4823(VarNext,bitIndex80)
          <=> v4569(VarCurr,bitIndex572) )
          & ( v4823(VarNext,bitIndex79)
          <=> v4569(VarCurr,bitIndex571) )
          & ( v4823(VarNext,bitIndex78)
          <=> v4569(VarCurr,bitIndex570) )
          & ( v4823(VarNext,bitIndex77)
          <=> v4569(VarCurr,bitIndex569) )
          & ( v4823(VarNext,bitIndex76)
          <=> v4569(VarCurr,bitIndex568) )
          & ( v4823(VarNext,bitIndex75)
          <=> v4569(VarCurr,bitIndex567) )
          & ( v4823(VarNext,bitIndex74)
          <=> v4569(VarCurr,bitIndex566) )
          & ( v4823(VarNext,bitIndex73)
          <=> v4569(VarCurr,bitIndex565) )
          & ( v4823(VarNext,bitIndex72)
          <=> v4569(VarCurr,bitIndex564) )
          & ( v4823(VarNext,bitIndex71)
          <=> v4569(VarCurr,bitIndex563) )
          & ( v4823(VarNext,bitIndex70)
          <=> v4569(VarCurr,bitIndex562) )
          & ( v4823(VarNext,bitIndex69)
          <=> v4569(VarCurr,bitIndex561) )
          & ( v4823(VarNext,bitIndex68)
          <=> v4569(VarCurr,bitIndex560) )
          & ( v4823(VarNext,bitIndex67)
          <=> v4569(VarCurr,bitIndex559) )
          & ( v4823(VarNext,bitIndex66)
          <=> v4569(VarCurr,bitIndex558) )
          & ( v4823(VarNext,bitIndex65)
          <=> v4569(VarCurr,bitIndex557) )
          & ( v4823(VarNext,bitIndex64)
          <=> v4569(VarCurr,bitIndex556) )
          & ( v4823(VarNext,bitIndex63)
          <=> v4569(VarCurr,bitIndex555) )
          & ( v4823(VarNext,bitIndex62)
          <=> v4569(VarCurr,bitIndex554) )
          & ( v4823(VarNext,bitIndex61)
          <=> v4569(VarCurr,bitIndex553) )
          & ( v4823(VarNext,bitIndex60)
          <=> v4569(VarCurr,bitIndex552) )
          & ( v4823(VarNext,bitIndex59)
          <=> v4569(VarCurr,bitIndex551) )
          & ( v4823(VarNext,bitIndex58)
          <=> v4569(VarCurr,bitIndex550) )
          & ( v4823(VarNext,bitIndex57)
          <=> v4569(VarCurr,bitIndex549) )
          & ( v4823(VarNext,bitIndex56)
          <=> v4569(VarCurr,bitIndex548) )
          & ( v4823(VarNext,bitIndex55)
          <=> v4569(VarCurr,bitIndex547) )
          & ( v4823(VarNext,bitIndex54)
          <=> v4569(VarCurr,bitIndex546) )
          & ( v4823(VarNext,bitIndex53)
          <=> v4569(VarCurr,bitIndex545) )
          & ( v4823(VarNext,bitIndex52)
          <=> v4569(VarCurr,bitIndex544) )
          & ( v4823(VarNext,bitIndex51)
          <=> v4569(VarCurr,bitIndex543) )
          & ( v4823(VarNext,bitIndex50)
          <=> v4569(VarCurr,bitIndex542) )
          & ( v4823(VarNext,bitIndex49)
          <=> v4569(VarCurr,bitIndex541) )
          & ( v4823(VarNext,bitIndex48)
          <=> v4569(VarCurr,bitIndex540) )
          & ( v4823(VarNext,bitIndex47)
          <=> v4569(VarCurr,bitIndex539) )
          & ( v4823(VarNext,bitIndex46)
          <=> v4569(VarCurr,bitIndex538) )
          & ( v4823(VarNext,bitIndex45)
          <=> v4569(VarCurr,bitIndex537) )
          & ( v4823(VarNext,bitIndex44)
          <=> v4569(VarCurr,bitIndex536) )
          & ( v4823(VarNext,bitIndex43)
          <=> v4569(VarCurr,bitIndex535) )
          & ( v4823(VarNext,bitIndex42)
          <=> v4569(VarCurr,bitIndex534) )
          & ( v4823(VarNext,bitIndex41)
          <=> v4569(VarCurr,bitIndex533) )
          & ( v4823(VarNext,bitIndex40)
          <=> v4569(VarCurr,bitIndex532) )
          & ( v4823(VarNext,bitIndex39)
          <=> v4569(VarCurr,bitIndex531) )
          & ( v4823(VarNext,bitIndex38)
          <=> v4569(VarCurr,bitIndex530) )
          & ( v4823(VarNext,bitIndex37)
          <=> v4569(VarCurr,bitIndex529) )
          & ( v4823(VarNext,bitIndex36)
          <=> v4569(VarCurr,bitIndex528) )
          & ( v4823(VarNext,bitIndex35)
          <=> v4569(VarCurr,bitIndex527) )
          & ( v4823(VarNext,bitIndex34)
          <=> v4569(VarCurr,bitIndex526) )
          & ( v4823(VarNext,bitIndex33)
          <=> v4569(VarCurr,bitIndex525) )
          & ( v4823(VarNext,bitIndex32)
          <=> v4569(VarCurr,bitIndex524) )
          & ( v4823(VarNext,bitIndex31)
          <=> v4569(VarCurr,bitIndex523) )
          & ( v4823(VarNext,bitIndex30)
          <=> v4569(VarCurr,bitIndex522) )
          & ( v4823(VarNext,bitIndex29)
          <=> v4569(VarCurr,bitIndex521) )
          & ( v4823(VarNext,bitIndex28)
          <=> v4569(VarCurr,bitIndex520) )
          & ( v4823(VarNext,bitIndex27)
          <=> v4569(VarCurr,bitIndex519) )
          & ( v4823(VarNext,bitIndex26)
          <=> v4569(VarCurr,bitIndex518) )
          & ( v4823(VarNext,bitIndex25)
          <=> v4569(VarCurr,bitIndex517) )
          & ( v4823(VarNext,bitIndex24)
          <=> v4569(VarCurr,bitIndex516) )
          & ( v4823(VarNext,bitIndex23)
          <=> v4569(VarCurr,bitIndex515) )
          & ( v4823(VarNext,bitIndex22)
          <=> v4569(VarCurr,bitIndex514) )
          & ( v4823(VarNext,bitIndex21)
          <=> v4569(VarCurr,bitIndex513) )
          & ( v4823(VarNext,bitIndex20)
          <=> v4569(VarCurr,bitIndex512) )
          & ( v4823(VarNext,bitIndex19)
          <=> v4569(VarCurr,bitIndex511) )
          & ( v4823(VarNext,bitIndex18)
          <=> v4569(VarCurr,bitIndex510) )
          & ( v4823(VarNext,bitIndex17)
          <=> v4569(VarCurr,bitIndex509) )
          & ( v4823(VarNext,bitIndex16)
          <=> v4569(VarCurr,bitIndex508) )
          & ( v4823(VarNext,bitIndex15)
          <=> v4569(VarCurr,bitIndex507) )
          & ( v4823(VarNext,bitIndex14)
          <=> v4569(VarCurr,bitIndex506) )
          & ( v4823(VarNext,bitIndex13)
          <=> v4569(VarCurr,bitIndex505) )
          & ( v4823(VarNext,bitIndex12)
          <=> v4569(VarCurr,bitIndex504) )
          & ( v4823(VarNext,bitIndex11)
          <=> v4569(VarCurr,bitIndex503) )
          & ( v4823(VarNext,bitIndex10)
          <=> v4569(VarCurr,bitIndex502) )
          & ( v4823(VarNext,bitIndex9)
          <=> v4569(VarCurr,bitIndex501) )
          & ( v4823(VarNext,bitIndex8)
          <=> v4569(VarCurr,bitIndex500) )
          & ( v4823(VarNext,bitIndex7)
          <=> v4569(VarCurr,bitIndex499) )
          & ( v4823(VarNext,bitIndex6)
          <=> v4569(VarCurr,bitIndex498) )
          & ( v4823(VarNext,bitIndex5)
          <=> v4569(VarCurr,bitIndex497) )
          & ( v4823(VarNext,bitIndex4)
          <=> v4569(VarCurr,bitIndex496) )
          & ( v4823(VarNext,bitIndex3)
          <=> v4569(VarCurr,bitIndex495) )
          & ( v4823(VarNext,bitIndex2)
          <=> v4569(VarCurr,bitIndex494) )
          & ( v4823(VarNext,bitIndex1)
          <=> v4569(VarCurr,bitIndex493) )
          & ( v4823(VarNext,bitIndex0)
          <=> v4569(VarCurr,bitIndex492) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_64,axiom,
    ! [VarNext] :
      ( v4825(VarNext)
     => ! [B] :
          ( range_122_0(B)
         => ( v4823(VarNext,B)
          <=> v4725(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_694,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4825(VarNext)
      <=> ( v4826(VarNext)
          & v4706(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_693,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4826(VarNext)
      <=> ( v4828(VarNext)
          & v4515(VarNext) ) ) ) ).

fof(writeUnaryOperator_359,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4828(VarNext)
      <=> v4522(VarNext) ) ) ).

fof(addAssignment_1461,axiom,
    ! [VarCurr] :
      ( v4690(VarCurr,bitIndex81)
    <=> v4695(VarCurr,bitIndex81) ) ).

fof(addAssignment_1460,axiom,
    ! [VarCurr] :
      ( v4694(VarCurr,bitIndex81)
    <=> v4569(VarCurr,bitIndex450) ) ).

fof(addAssignment_1459,axiom,
    ! [VarCurr] :
      ( v4572(VarCurr,bitIndex81)
    <=> v4688(VarCurr,bitIndex81) ) ).

fof(addAssignment_1458,axiom,
    ! [VarCurr] :
      ( v4681(VarCurr,bitIndex81)
    <=> v4569(VarCurr,bitIndex573) ) ).

fof(addAssignment_1457,axiom,
    ! [VarCurr] :
      ( v4624(VarCurr,bitIndex81)
    <=> v4626(VarCurr,bitIndex81) ) ).

fof(addAssignment_1456,axiom,
    ! [VarCurr] :
      ( v4626(VarCurr,bitIndex81)
    <=> v4628(VarCurr,bitIndex81) ) ).

fof(addAssignment_1455,axiom,
    ! [VarCurr] :
      ( v4628(VarCurr,bitIndex81)
    <=> v4630(VarCurr,bitIndex81) ) ).

fof(addAssignment_1454,axiom,
    ! [VarCurr] :
      ( v4630(VarCurr,bitIndex81)
    <=> v4632(VarCurr,bitIndex81) ) ).

fof(addAssignment_1453,axiom,
    ! [VarCurr] :
      ( v4632(VarCurr,bitIndex81)
    <=> v4634(VarCurr,bitIndex81) ) ).

fof(addAssignment_1452,axiom,
    ! [VarCurr] :
      ( v4634(VarCurr,bitIndex81)
    <=> v4636(VarCurr,bitIndex81) ) ).

fof(addAssignment_1451,axiom,
    ! [VarCurr] :
      ( v4636(VarCurr,bitIndex81)
    <=> v4638(VarCurr,bitIndex81) ) ).

fof(addAssignment_1450,axiom,
    ! [VarNext] :
      ( v4638(VarNext,bitIndex81)
    <=> v4815(VarNext,bitIndex81) ) ).

fof(addCaseBooleanConditionEqualRanges1_60,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4816(VarNext)
       => ! [B] :
            ( range_122_0(B)
           => ( v4815(VarNext,B)
            <=> v4638(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_63,axiom,
    ! [VarNext] :
      ( v4816(VarNext)
     => ! [B] :
          ( range_122_0(B)
         => ( v4815(VarNext,B)
          <=> v4676(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_692,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4816(VarNext)
      <=> v4817(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_691,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4817(VarNext)
      <=> ( v4819(VarNext)
          & v4663(VarNext) ) ) ) ).

fof(writeUnaryOperator_358,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4819(VarNext)
      <=> v4670(VarNext) ) ) ).

fof(addAssignment_1449,axiom,
    ! [VarCurr] :
      ( v4642(VarCurr,bitIndex81)
    <=> v4652(VarCurr,bitIndex81) ) ).

fof(addAssignment_1448,axiom,
    ! [VarCurr] :
      ( v4657(VarCurr,bitIndex4)
    <=> v4812(VarCurr,bitIndex4) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_123,axiom,
    ! [VarCurr] :
      ( ~ v4813(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v4812(VarCurr,B)
          <=> v4811(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_5,axiom,
    ! [VarCurr] :
      ( v4813(VarCurr)
     => ( ( v4812(VarCurr,bitIndex7)
        <=> v103(VarCurr,bitIndex13) )
        & ( v4812(VarCurr,bitIndex6)
        <=> v103(VarCurr,bitIndex12) )
        & ( v4812(VarCurr,bitIndex5)
        <=> v103(VarCurr,bitIndex11) )
        & ( v4812(VarCurr,bitIndex4)
        <=> v103(VarCurr,bitIndex10) )
        & ( v4812(VarCurr,bitIndex3)
        <=> v103(VarCurr,bitIndex9) )
        & ( v4812(VarCurr,bitIndex2)
        <=> v103(VarCurr,bitIndex8) )
        & ( v4812(VarCurr,bitIndex1)
        <=> v103(VarCurr,bitIndex7) )
        & ( v4812(VarCurr,bitIndex0)
        <=> v103(VarCurr,bitIndex6) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_690,axiom,
    ! [VarCurr] :
      ( v4813(VarCurr)
    <=> ( v4780(VarCurr)
        | v490(VarCurr) ) ) ).

fof(addAssignment_1447,axiom,
    ! [VarCurr] :
      ( v4811(VarCurr,bitIndex4)
    <=> v105(VarCurr,bitIndex74) ) ).

fof(addAssignment_1446,axiom,
    ! [VarCurr] :
      ( v105(VarCurr,bitIndex74)
    <=> v107(VarCurr,bitIndex74) ) ).

fof(addAssignment_1445,axiom,
    ! [VarCurr] :
      ( v107(VarCurr,bitIndex74)
    <=> v109(VarCurr,bitIndex74) ) ).

fof(addAssignment_1444,axiom,
    ! [VarCurr] :
      ( v109(VarCurr,bitIndex74)
    <=> v111(VarCurr,bitIndex654) ) ).

fof(addAssignment_1443,axiom,
    ! [VarCurr] :
      ( v103(VarCurr,bitIndex10)
    <=> v105(VarCurr,bitIndex10) ) ).

fof(addAssignment_1442,axiom,
    ! [VarCurr] :
      ( v105(VarCurr,bitIndex10)
    <=> v107(VarCurr,bitIndex10) ) ).

fof(addAssignment_1441,axiom,
    ! [VarCurr] :
      ( v107(VarCurr,bitIndex10)
    <=> v109(VarCurr,bitIndex10) ) ).

fof(addAssignment_1440,axiom,
    ! [VarCurr] :
      ( v109(VarCurr,bitIndex10)
    <=> v111(VarCurr,bitIndex590) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_122,axiom,
    ! [VarCurr] :
      ( ~ v4783(VarCurr)
     => ( v4780(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_154,axiom,
    ! [VarCurr] :
      ( v4783(VarCurr)
     => ( v4780(VarCurr)
      <=> v4809(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_64,axiom,
    ! [VarCurr] :
      ( ~ v4784(VarCurr)
     => ( v4809(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_60,axiom,
    ! [VarCurr] :
      ( v4784(VarCurr)
     => ( v4809(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_689,axiom,
    ! [VarCurr] :
      ( v4783(VarCurr)
    <=> ( v4784(VarCurr)
        | v4786(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_688,axiom,
    ! [VarCurr] :
      ( v4786(VarCurr)
    <=> ( v4787(VarCurr)
        | v4804(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_687,axiom,
    ! [VarCurr] :
      ( v4804(VarCurr)
    <=> ( v4806(VarCurr)
        & v417(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_686,axiom,
    ! [VarCurr] :
      ( v4806(VarCurr)
    <=> ( v4807(VarCurr)
        & v367(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_685,axiom,
    ! [VarCurr] :
      ( v4807(VarCurr)
    <=> ( v4808(VarCurr)
        & v366(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_264,axiom,
    ! [VarCurr] :
      ( v4808(VarCurr)
    <=> ( v4799(VarCurr)
        & v170(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_684,axiom,
    ! [VarCurr] :
      ( v4787(VarCurr)
    <=> ( v4788(VarCurr)
        | v4801(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_683,axiom,
    ! [VarCurr] :
      ( v4801(VarCurr)
    <=> ( v4803(VarCurr)
        & v417(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_263,axiom,
    ! [VarCurr] :
      ( v4803(VarCurr)
    <=> ( v4797(VarCurr)
        & v170(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_682,axiom,
    ! [VarCurr] :
      ( v4788(VarCurr)
    <=> ( v4789(VarCurr)
        | v4794(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_681,axiom,
    ! [VarCurr] :
      ( v4794(VarCurr)
    <=> ( v4796(VarCurr)
        & v417(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_680,axiom,
    ! [VarCurr] :
      ( v4796(VarCurr)
    <=> ( v4797(VarCurr)
        & v367(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_679,axiom,
    ! [VarCurr] :
      ( v4797(VarCurr)
    <=> ( v4798(VarCurr)
        & v366(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_678,axiom,
    ! [VarCurr] :
      ( v4798(VarCurr)
    <=> ( v4799(VarCurr)
        & v365(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_677,axiom,
    ! [VarCurr] :
      ( v4799(VarCurr)
    <=> ( v4800(VarCurr)
        & v364(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_676,axiom,
    ! [VarCurr] :
      ( v4800(VarCurr)
    <=> ( v170(VarCurr,bitIndex0)
        & v363(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_675,axiom,
    ! [VarCurr] :
      ( v4789(VarCurr)
    <=> ( v4790(VarCurr)
        | v4792(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_674,axiom,
    ! [VarCurr] :
      ( v4792(VarCurr)
    <=> ( v372(VarCurr)
        & v417(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_673,axiom,
    ! [VarCurr] :
      ( v4790(VarCurr)
    <=> ( v357(VarCurr)
        & v417(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_672,axiom,
    ! [VarCurr] :
      ( v4784(VarCurr)
    <=> ( v495(VarCurr)
        & v417(VarCurr) ) ) ).

fof(addAssignment_1439,axiom,
    ! [VarCurr] :
      ( ( v4564(VarCurr,bitIndex6)
      <=> v2244(VarCurr,bitIndex122) )
      & ( v4564(VarCurr,bitIndex5)
      <=> v2244(VarCurr,bitIndex121) )
      & ( v4564(VarCurr,bitIndex4)
      <=> v2244(VarCurr,bitIndex120) )
      & ( v4564(VarCurr,bitIndex3)
      <=> v2244(VarCurr,bitIndex119) )
      & ( v4564(VarCurr,bitIndex2)
      <=> v2244(VarCurr,bitIndex118) )
      & ( v4564(VarCurr,bitIndex1)
      <=> v2244(VarCurr,bitIndex117) )
      & ( v4564(VarCurr,bitIndex0)
      <=> v2244(VarCurr,bitIndex116) ) ) ).

fof(addAssignment_1438,axiom,
    ! [VarCurr,B] :
      ( range_122_116(B)
     => ( v2244(VarCurr,B)
      <=> v4567(VarCurr,B) ) ) ).

fof(addAssignment_1437,axiom,
    ! [VarCurr] :
      ( ( v4567(VarCurr,bitIndex122)
      <=> v4569(VarCurr,bitIndex737) )
      & ( v4567(VarCurr,bitIndex121)
      <=> v4569(VarCurr,bitIndex736) )
      & ( v4567(VarCurr,bitIndex120)
      <=> v4569(VarCurr,bitIndex735) )
      & ( v4567(VarCurr,bitIndex119)
      <=> v4569(VarCurr,bitIndex734) )
      & ( v4567(VarCurr,bitIndex118)
      <=> v4569(VarCurr,bitIndex733) )
      & ( v4567(VarCurr,bitIndex117)
      <=> v4569(VarCurr,bitIndex732) )
      & ( v4567(VarCurr,bitIndex116)
      <=> v4569(VarCurr,bitIndex731) ) ) ).

fof(addAssignment_1436,axiom,
    ! [VarNext] :
      ( ( v4569(VarNext,bitIndex737)
      <=> v4744(VarNext,bitIndex122) )
      & ( v4569(VarNext,bitIndex736)
      <=> v4744(VarNext,bitIndex121) )
      & ( v4569(VarNext,bitIndex735)
      <=> v4744(VarNext,bitIndex120) )
      & ( v4569(VarNext,bitIndex734)
      <=> v4744(VarNext,bitIndex119) )
      & ( v4569(VarNext,bitIndex733)
      <=> v4744(VarNext,bitIndex118) )
      & ( v4569(VarNext,bitIndex732)
      <=> v4744(VarNext,bitIndex117) )
      & ( v4569(VarNext,bitIndex731)
      <=> v4744(VarNext,bitIndex116) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_5,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4745(VarNext)
       => ( ( v4744(VarNext,bitIndex122)
          <=> v4569(VarCurr,bitIndex737) )
          & ( v4744(VarNext,bitIndex121)
          <=> v4569(VarCurr,bitIndex736) )
          & ( v4744(VarNext,bitIndex120)
          <=> v4569(VarCurr,bitIndex735) )
          & ( v4744(VarNext,bitIndex119)
          <=> v4569(VarCurr,bitIndex734) )
          & ( v4744(VarNext,bitIndex118)
          <=> v4569(VarCurr,bitIndex733) )
          & ( v4744(VarNext,bitIndex117)
          <=> v4569(VarCurr,bitIndex732) )
          & ( v4744(VarNext,bitIndex116)
          <=> v4569(VarCurr,bitIndex731) )
          & ( v4744(VarNext,bitIndex115)
          <=> v4569(VarCurr,bitIndex730) )
          & ( v4744(VarNext,bitIndex114)
          <=> v4569(VarCurr,bitIndex729) )
          & ( v4744(VarNext,bitIndex113)
          <=> v4569(VarCurr,bitIndex728) )
          & ( v4744(VarNext,bitIndex112)
          <=> v4569(VarCurr,bitIndex727) )
          & ( v4744(VarNext,bitIndex111)
          <=> v4569(VarCurr,bitIndex726) )
          & ( v4744(VarNext,bitIndex110)
          <=> v4569(VarCurr,bitIndex725) )
          & ( v4744(VarNext,bitIndex109)
          <=> v4569(VarCurr,bitIndex724) )
          & ( v4744(VarNext,bitIndex108)
          <=> v4569(VarCurr,bitIndex723) )
          & ( v4744(VarNext,bitIndex107)
          <=> v4569(VarCurr,bitIndex722) )
          & ( v4744(VarNext,bitIndex106)
          <=> v4569(VarCurr,bitIndex721) )
          & ( v4744(VarNext,bitIndex105)
          <=> v4569(VarCurr,bitIndex720) )
          & ( v4744(VarNext,bitIndex104)
          <=> v4569(VarCurr,bitIndex719) )
          & ( v4744(VarNext,bitIndex103)
          <=> v4569(VarCurr,bitIndex718) )
          & ( v4744(VarNext,bitIndex102)
          <=> v4569(VarCurr,bitIndex717) )
          & ( v4744(VarNext,bitIndex101)
          <=> v4569(VarCurr,bitIndex716) )
          & ( v4744(VarNext,bitIndex100)
          <=> v4569(VarCurr,bitIndex715) )
          & ( v4744(VarNext,bitIndex99)
          <=> v4569(VarCurr,bitIndex714) )
          & ( v4744(VarNext,bitIndex98)
          <=> v4569(VarCurr,bitIndex713) )
          & ( v4744(VarNext,bitIndex97)
          <=> v4569(VarCurr,bitIndex712) )
          & ( v4744(VarNext,bitIndex96)
          <=> v4569(VarCurr,bitIndex711) )
          & ( v4744(VarNext,bitIndex95)
          <=> v4569(VarCurr,bitIndex710) )
          & ( v4744(VarNext,bitIndex94)
          <=> v4569(VarCurr,bitIndex709) )
          & ( v4744(VarNext,bitIndex93)
          <=> v4569(VarCurr,bitIndex708) )
          & ( v4744(VarNext,bitIndex92)
          <=> v4569(VarCurr,bitIndex707) )
          & ( v4744(VarNext,bitIndex91)
          <=> v4569(VarCurr,bitIndex706) )
          & ( v4744(VarNext,bitIndex90)
          <=> v4569(VarCurr,bitIndex705) )
          & ( v4744(VarNext,bitIndex89)
          <=> v4569(VarCurr,bitIndex704) )
          & ( v4744(VarNext,bitIndex88)
          <=> v4569(VarCurr,bitIndex703) )
          & ( v4744(VarNext,bitIndex87)
          <=> v4569(VarCurr,bitIndex702) )
          & ( v4744(VarNext,bitIndex86)
          <=> v4569(VarCurr,bitIndex701) )
          & ( v4744(VarNext,bitIndex85)
          <=> v4569(VarCurr,bitIndex700) )
          & ( v4744(VarNext,bitIndex84)
          <=> v4569(VarCurr,bitIndex699) )
          & ( v4744(VarNext,bitIndex83)
          <=> v4569(VarCurr,bitIndex698) )
          & ( v4744(VarNext,bitIndex82)
          <=> v4569(VarCurr,bitIndex697) )
          & ( v4744(VarNext,bitIndex81)
          <=> v4569(VarCurr,bitIndex696) )
          & ( v4744(VarNext,bitIndex80)
          <=> v4569(VarCurr,bitIndex695) )
          & ( v4744(VarNext,bitIndex79)
          <=> v4569(VarCurr,bitIndex694) )
          & ( v4744(VarNext,bitIndex78)
          <=> v4569(VarCurr,bitIndex693) )
          & ( v4744(VarNext,bitIndex77)
          <=> v4569(VarCurr,bitIndex692) )
          & ( v4744(VarNext,bitIndex76)
          <=> v4569(VarCurr,bitIndex691) )
          & ( v4744(VarNext,bitIndex75)
          <=> v4569(VarCurr,bitIndex690) )
          & ( v4744(VarNext,bitIndex74)
          <=> v4569(VarCurr,bitIndex689) )
          & ( v4744(VarNext,bitIndex73)
          <=> v4569(VarCurr,bitIndex688) )
          & ( v4744(VarNext,bitIndex72)
          <=> v4569(VarCurr,bitIndex687) )
          & ( v4744(VarNext,bitIndex71)
          <=> v4569(VarCurr,bitIndex686) )
          & ( v4744(VarNext,bitIndex70)
          <=> v4569(VarCurr,bitIndex685) )
          & ( v4744(VarNext,bitIndex69)
          <=> v4569(VarCurr,bitIndex684) )
          & ( v4744(VarNext,bitIndex68)
          <=> v4569(VarCurr,bitIndex683) )
          & ( v4744(VarNext,bitIndex67)
          <=> v4569(VarCurr,bitIndex682) )
          & ( v4744(VarNext,bitIndex66)
          <=> v4569(VarCurr,bitIndex681) )
          & ( v4744(VarNext,bitIndex65)
          <=> v4569(VarCurr,bitIndex680) )
          & ( v4744(VarNext,bitIndex64)
          <=> v4569(VarCurr,bitIndex679) )
          & ( v4744(VarNext,bitIndex63)
          <=> v4569(VarCurr,bitIndex678) )
          & ( v4744(VarNext,bitIndex62)
          <=> v4569(VarCurr,bitIndex677) )
          & ( v4744(VarNext,bitIndex61)
          <=> v4569(VarCurr,bitIndex676) )
          & ( v4744(VarNext,bitIndex60)
          <=> v4569(VarCurr,bitIndex675) )
          & ( v4744(VarNext,bitIndex59)
          <=> v4569(VarCurr,bitIndex674) )
          & ( v4744(VarNext,bitIndex58)
          <=> v4569(VarCurr,bitIndex673) )
          & ( v4744(VarNext,bitIndex57)
          <=> v4569(VarCurr,bitIndex672) )
          & ( v4744(VarNext,bitIndex56)
          <=> v4569(VarCurr,bitIndex671) )
          & ( v4744(VarNext,bitIndex55)
          <=> v4569(VarCurr,bitIndex670) )
          & ( v4744(VarNext,bitIndex54)
          <=> v4569(VarCurr,bitIndex669) )
          & ( v4744(VarNext,bitIndex53)
          <=> v4569(VarCurr,bitIndex668) )
          & ( v4744(VarNext,bitIndex52)
          <=> v4569(VarCurr,bitIndex667) )
          & ( v4744(VarNext,bitIndex51)
          <=> v4569(VarCurr,bitIndex666) )
          & ( v4744(VarNext,bitIndex50)
          <=> v4569(VarCurr,bitIndex665) )
          & ( v4744(VarNext,bitIndex49)
          <=> v4569(VarCurr,bitIndex664) )
          & ( v4744(VarNext,bitIndex48)
          <=> v4569(VarCurr,bitIndex663) )
          & ( v4744(VarNext,bitIndex47)
          <=> v4569(VarCurr,bitIndex662) )
          & ( v4744(VarNext,bitIndex46)
          <=> v4569(VarCurr,bitIndex661) )
          & ( v4744(VarNext,bitIndex45)
          <=> v4569(VarCurr,bitIndex660) )
          & ( v4744(VarNext,bitIndex44)
          <=> v4569(VarCurr,bitIndex659) )
          & ( v4744(VarNext,bitIndex43)
          <=> v4569(VarCurr,bitIndex658) )
          & ( v4744(VarNext,bitIndex42)
          <=> v4569(VarCurr,bitIndex657) )
          & ( v4744(VarNext,bitIndex41)
          <=> v4569(VarCurr,bitIndex656) )
          & ( v4744(VarNext,bitIndex40)
          <=> v4569(VarCurr,bitIndex655) )
          & ( v4744(VarNext,bitIndex39)
          <=> v4569(VarCurr,bitIndex654) )
          & ( v4744(VarNext,bitIndex38)
          <=> v4569(VarCurr,bitIndex653) )
          & ( v4744(VarNext,bitIndex37)
          <=> v4569(VarCurr,bitIndex652) )
          & ( v4744(VarNext,bitIndex36)
          <=> v4569(VarCurr,bitIndex651) )
          & ( v4744(VarNext,bitIndex35)
          <=> v4569(VarCurr,bitIndex650) )
          & ( v4744(VarNext,bitIndex34)
          <=> v4569(VarCurr,bitIndex649) )
          & ( v4744(VarNext,bitIndex33)
          <=> v4569(VarCurr,bitIndex648) )
          & ( v4744(VarNext,bitIndex32)
          <=> v4569(VarCurr,bitIndex647) )
          & ( v4744(VarNext,bitIndex31)
          <=> v4569(VarCurr,bitIndex646) )
          & ( v4744(VarNext,bitIndex30)
          <=> v4569(VarCurr,bitIndex645) )
          & ( v4744(VarNext,bitIndex29)
          <=> v4569(VarCurr,bitIndex644) )
          & ( v4744(VarNext,bitIndex28)
          <=> v4569(VarCurr,bitIndex643) )
          & ( v4744(VarNext,bitIndex27)
          <=> v4569(VarCurr,bitIndex642) )
          & ( v4744(VarNext,bitIndex26)
          <=> v4569(VarCurr,bitIndex641) )
          & ( v4744(VarNext,bitIndex25)
          <=> v4569(VarCurr,bitIndex640) )
          & ( v4744(VarNext,bitIndex24)
          <=> v4569(VarCurr,bitIndex639) )
          & ( v4744(VarNext,bitIndex23)
          <=> v4569(VarCurr,bitIndex638) )
          & ( v4744(VarNext,bitIndex22)
          <=> v4569(VarCurr,bitIndex637) )
          & ( v4744(VarNext,bitIndex21)
          <=> v4569(VarCurr,bitIndex636) )
          & ( v4744(VarNext,bitIndex20)
          <=> v4569(VarCurr,bitIndex635) )
          & ( v4744(VarNext,bitIndex19)
          <=> v4569(VarCurr,bitIndex634) )
          & ( v4744(VarNext,bitIndex18)
          <=> v4569(VarCurr,bitIndex633) )
          & ( v4744(VarNext,bitIndex17)
          <=> v4569(VarCurr,bitIndex632) )
          & ( v4744(VarNext,bitIndex16)
          <=> v4569(VarCurr,bitIndex631) )
          & ( v4744(VarNext,bitIndex15)
          <=> v4569(VarCurr,bitIndex630) )
          & ( v4744(VarNext,bitIndex14)
          <=> v4569(VarCurr,bitIndex629) )
          & ( v4744(VarNext,bitIndex13)
          <=> v4569(VarCurr,bitIndex628) )
          & ( v4744(VarNext,bitIndex12)
          <=> v4569(VarCurr,bitIndex627) )
          & ( v4744(VarNext,bitIndex11)
          <=> v4569(VarCurr,bitIndex626) )
          & ( v4744(VarNext,bitIndex10)
          <=> v4569(VarCurr,bitIndex625) )
          & ( v4744(VarNext,bitIndex9)
          <=> v4569(VarCurr,bitIndex624) )
          & ( v4744(VarNext,bitIndex8)
          <=> v4569(VarCurr,bitIndex623) )
          & ( v4744(VarNext,bitIndex7)
          <=> v4569(VarCurr,bitIndex622) )
          & ( v4744(VarNext,bitIndex6)
          <=> v4569(VarCurr,bitIndex621) )
          & ( v4744(VarNext,bitIndex5)
          <=> v4569(VarCurr,bitIndex620) )
          & ( v4744(VarNext,bitIndex4)
          <=> v4569(VarCurr,bitIndex619) )
          & ( v4744(VarNext,bitIndex3)
          <=> v4569(VarCurr,bitIndex618) )
          & ( v4744(VarNext,bitIndex2)
          <=> v4569(VarCurr,bitIndex617) )
          & ( v4744(VarNext,bitIndex1)
          <=> v4569(VarCurr,bitIndex616) )
          & ( v4744(VarNext,bitIndex0)
          <=> v4569(VarCurr,bitIndex615) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_62,axiom,
    ! [VarNext] :
      ( v4745(VarNext)
     => ! [B] :
          ( range_122_0(B)
         => ( v4744(VarNext,B)
          <=> v4771(VarNext,B) ) ) ) ).

fof(addAssignment_1435,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_122_0(B)
         => ( v4771(VarNext,B)
          <=> v4769(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_63,axiom,
    ! [VarCurr] :
      ( ~ v4708(VarCurr)
     => ! [B] :
          ( range_122_0(B)
         => ( v4769(VarCurr,B)
          <=> v4772(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_59,axiom,
    ! [VarCurr] :
      ( v4708(VarCurr)
     => ! [B] :
          ( range_122_0(B)
         => ( v4769(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_37,axiom,
    ! [VarCurr] :
      ( ( ~ v4758(VarCurr)
        & ~ v4760(VarCurr) )
     => ! [B] :
          ( range_122_0(B)
         => ( v4772(VarCurr,B)
          <=> v4737(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_62,axiom,
    ! [VarCurr] :
      ( v4760(VarCurr)
     => ! [B] :
          ( range_122_0(B)
         => ( v4772(VarCurr,B)
          <=> v4730(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_6,axiom,
    ! [VarCurr] :
      ( v4758(VarCurr)
     => ( ( v4772(VarCurr,bitIndex122)
        <=> v4569(VarCurr,bitIndex614) )
        & ( v4772(VarCurr,bitIndex121)
        <=> v4569(VarCurr,bitIndex613) )
        & ( v4772(VarCurr,bitIndex120)
        <=> v4569(VarCurr,bitIndex612) )
        & ( v4772(VarCurr,bitIndex119)
        <=> v4569(VarCurr,bitIndex611) )
        & ( v4772(VarCurr,bitIndex118)
        <=> v4569(VarCurr,bitIndex610) )
        & ( v4772(VarCurr,bitIndex117)
        <=> v4569(VarCurr,bitIndex609) )
        & ( v4772(VarCurr,bitIndex116)
        <=> v4569(VarCurr,bitIndex608) )
        & ( v4772(VarCurr,bitIndex115)
        <=> v4569(VarCurr,bitIndex607) )
        & ( v4772(VarCurr,bitIndex114)
        <=> v4569(VarCurr,bitIndex606) )
        & ( v4772(VarCurr,bitIndex113)
        <=> v4569(VarCurr,bitIndex605) )
        & ( v4772(VarCurr,bitIndex112)
        <=> v4569(VarCurr,bitIndex604) )
        & ( v4772(VarCurr,bitIndex111)
        <=> v4569(VarCurr,bitIndex603) )
        & ( v4772(VarCurr,bitIndex110)
        <=> v4569(VarCurr,bitIndex602) )
        & ( v4772(VarCurr,bitIndex109)
        <=> v4569(VarCurr,bitIndex601) )
        & ( v4772(VarCurr,bitIndex108)
        <=> v4569(VarCurr,bitIndex600) )
        & ( v4772(VarCurr,bitIndex107)
        <=> v4569(VarCurr,bitIndex599) )
        & ( v4772(VarCurr,bitIndex106)
        <=> v4569(VarCurr,bitIndex598) )
        & ( v4772(VarCurr,bitIndex105)
        <=> v4569(VarCurr,bitIndex597) )
        & ( v4772(VarCurr,bitIndex104)
        <=> v4569(VarCurr,bitIndex596) )
        & ( v4772(VarCurr,bitIndex103)
        <=> v4569(VarCurr,bitIndex595) )
        & ( v4772(VarCurr,bitIndex102)
        <=> v4569(VarCurr,bitIndex594) )
        & ( v4772(VarCurr,bitIndex101)
        <=> v4569(VarCurr,bitIndex593) )
        & ( v4772(VarCurr,bitIndex100)
        <=> v4569(VarCurr,bitIndex592) )
        & ( v4772(VarCurr,bitIndex99)
        <=> v4569(VarCurr,bitIndex591) )
        & ( v4772(VarCurr,bitIndex98)
        <=> v4569(VarCurr,bitIndex590) )
        & ( v4772(VarCurr,bitIndex97)
        <=> v4569(VarCurr,bitIndex589) )
        & ( v4772(VarCurr,bitIndex96)
        <=> v4569(VarCurr,bitIndex588) )
        & ( v4772(VarCurr,bitIndex95)
        <=> v4569(VarCurr,bitIndex587) )
        & ( v4772(VarCurr,bitIndex94)
        <=> v4569(VarCurr,bitIndex586) )
        & ( v4772(VarCurr,bitIndex93)
        <=> v4569(VarCurr,bitIndex585) )
        & ( v4772(VarCurr,bitIndex92)
        <=> v4569(VarCurr,bitIndex584) )
        & ( v4772(VarCurr,bitIndex91)
        <=> v4569(VarCurr,bitIndex583) )
        & ( v4772(VarCurr,bitIndex90)
        <=> v4569(VarCurr,bitIndex582) )
        & ( v4772(VarCurr,bitIndex89)
        <=> v4569(VarCurr,bitIndex581) )
        & ( v4772(VarCurr,bitIndex88)
        <=> v4569(VarCurr,bitIndex580) )
        & ( v4772(VarCurr,bitIndex87)
        <=> v4569(VarCurr,bitIndex579) )
        & ( v4772(VarCurr,bitIndex86)
        <=> v4569(VarCurr,bitIndex578) )
        & ( v4772(VarCurr,bitIndex85)
        <=> v4569(VarCurr,bitIndex577) )
        & ( v4772(VarCurr,bitIndex84)
        <=> v4569(VarCurr,bitIndex576) )
        & ( v4772(VarCurr,bitIndex83)
        <=> v4569(VarCurr,bitIndex575) )
        & ( v4772(VarCurr,bitIndex82)
        <=> v4569(VarCurr,bitIndex574) )
        & ( v4772(VarCurr,bitIndex81)
        <=> v4569(VarCurr,bitIndex573) )
        & ( v4772(VarCurr,bitIndex80)
        <=> v4569(VarCurr,bitIndex572) )
        & ( v4772(VarCurr,bitIndex79)
        <=> v4569(VarCurr,bitIndex571) )
        & ( v4772(VarCurr,bitIndex78)
        <=> v4569(VarCurr,bitIndex570) )
        & ( v4772(VarCurr,bitIndex77)
        <=> v4569(VarCurr,bitIndex569) )
        & ( v4772(VarCurr,bitIndex76)
        <=> v4569(VarCurr,bitIndex568) )
        & ( v4772(VarCurr,bitIndex75)
        <=> v4569(VarCurr,bitIndex567) )
        & ( v4772(VarCurr,bitIndex74)
        <=> v4569(VarCurr,bitIndex566) )
        & ( v4772(VarCurr,bitIndex73)
        <=> v4569(VarCurr,bitIndex565) )
        & ( v4772(VarCurr,bitIndex72)
        <=> v4569(VarCurr,bitIndex564) )
        & ( v4772(VarCurr,bitIndex71)
        <=> v4569(VarCurr,bitIndex563) )
        & ( v4772(VarCurr,bitIndex70)
        <=> v4569(VarCurr,bitIndex562) )
        & ( v4772(VarCurr,bitIndex69)
        <=> v4569(VarCurr,bitIndex561) )
        & ( v4772(VarCurr,bitIndex68)
        <=> v4569(VarCurr,bitIndex560) )
        & ( v4772(VarCurr,bitIndex67)
        <=> v4569(VarCurr,bitIndex559) )
        & ( v4772(VarCurr,bitIndex66)
        <=> v4569(VarCurr,bitIndex558) )
        & ( v4772(VarCurr,bitIndex65)
        <=> v4569(VarCurr,bitIndex557) )
        & ( v4772(VarCurr,bitIndex64)
        <=> v4569(VarCurr,bitIndex556) )
        & ( v4772(VarCurr,bitIndex63)
        <=> v4569(VarCurr,bitIndex555) )
        & ( v4772(VarCurr,bitIndex62)
        <=> v4569(VarCurr,bitIndex554) )
        & ( v4772(VarCurr,bitIndex61)
        <=> v4569(VarCurr,bitIndex553) )
        & ( v4772(VarCurr,bitIndex60)
        <=> v4569(VarCurr,bitIndex552) )
        & ( v4772(VarCurr,bitIndex59)
        <=> v4569(VarCurr,bitIndex551) )
        & ( v4772(VarCurr,bitIndex58)
        <=> v4569(VarCurr,bitIndex550) )
        & ( v4772(VarCurr,bitIndex57)
        <=> v4569(VarCurr,bitIndex549) )
        & ( v4772(VarCurr,bitIndex56)
        <=> v4569(VarCurr,bitIndex548) )
        & ( v4772(VarCurr,bitIndex55)
        <=> v4569(VarCurr,bitIndex547) )
        & ( v4772(VarCurr,bitIndex54)
        <=> v4569(VarCurr,bitIndex546) )
        & ( v4772(VarCurr,bitIndex53)
        <=> v4569(VarCurr,bitIndex545) )
        & ( v4772(VarCurr,bitIndex52)
        <=> v4569(VarCurr,bitIndex544) )
        & ( v4772(VarCurr,bitIndex51)
        <=> v4569(VarCurr,bitIndex543) )
        & ( v4772(VarCurr,bitIndex50)
        <=> v4569(VarCurr,bitIndex542) )
        & ( v4772(VarCurr,bitIndex49)
        <=> v4569(VarCurr,bitIndex541) )
        & ( v4772(VarCurr,bitIndex48)
        <=> v4569(VarCurr,bitIndex540) )
        & ( v4772(VarCurr,bitIndex47)
        <=> v4569(VarCurr,bitIndex539) )
        & ( v4772(VarCurr,bitIndex46)
        <=> v4569(VarCurr,bitIndex538) )
        & ( v4772(VarCurr,bitIndex45)
        <=> v4569(VarCurr,bitIndex537) )
        & ( v4772(VarCurr,bitIndex44)
        <=> v4569(VarCurr,bitIndex536) )
        & ( v4772(VarCurr,bitIndex43)
        <=> v4569(VarCurr,bitIndex535) )
        & ( v4772(VarCurr,bitIndex42)
        <=> v4569(VarCurr,bitIndex534) )
        & ( v4772(VarCurr,bitIndex41)
        <=> v4569(VarCurr,bitIndex533) )
        & ( v4772(VarCurr,bitIndex40)
        <=> v4569(VarCurr,bitIndex532) )
        & ( v4772(VarCurr,bitIndex39)
        <=> v4569(VarCurr,bitIndex531) )
        & ( v4772(VarCurr,bitIndex38)
        <=> v4569(VarCurr,bitIndex530) )
        & ( v4772(VarCurr,bitIndex37)
        <=> v4569(VarCurr,bitIndex529) )
        & ( v4772(VarCurr,bitIndex36)
        <=> v4569(VarCurr,bitIndex528) )
        & ( v4772(VarCurr,bitIndex35)
        <=> v4569(VarCurr,bitIndex527) )
        & ( v4772(VarCurr,bitIndex34)
        <=> v4569(VarCurr,bitIndex526) )
        & ( v4772(VarCurr,bitIndex33)
        <=> v4569(VarCurr,bitIndex525) )
        & ( v4772(VarCurr,bitIndex32)
        <=> v4569(VarCurr,bitIndex524) )
        & ( v4772(VarCurr,bitIndex31)
        <=> v4569(VarCurr,bitIndex523) )
        & ( v4772(VarCurr,bitIndex30)
        <=> v4569(VarCurr,bitIndex522) )
        & ( v4772(VarCurr,bitIndex29)
        <=> v4569(VarCurr,bitIndex521) )
        & ( v4772(VarCurr,bitIndex28)
        <=> v4569(VarCurr,bitIndex520) )
        & ( v4772(VarCurr,bitIndex27)
        <=> v4569(VarCurr,bitIndex519) )
        & ( v4772(VarCurr,bitIndex26)
        <=> v4569(VarCurr,bitIndex518) )
        & ( v4772(VarCurr,bitIndex25)
        <=> v4569(VarCurr,bitIndex517) )
        & ( v4772(VarCurr,bitIndex24)
        <=> v4569(VarCurr,bitIndex516) )
        & ( v4772(VarCurr,bitIndex23)
        <=> v4569(VarCurr,bitIndex515) )
        & ( v4772(VarCurr,bitIndex22)
        <=> v4569(VarCurr,bitIndex514) )
        & ( v4772(VarCurr,bitIndex21)
        <=> v4569(VarCurr,bitIndex513) )
        & ( v4772(VarCurr,bitIndex20)
        <=> v4569(VarCurr,bitIndex512) )
        & ( v4772(VarCurr,bitIndex19)
        <=> v4569(VarCurr,bitIndex511) )
        & ( v4772(VarCurr,bitIndex18)
        <=> v4569(VarCurr,bitIndex510) )
        & ( v4772(VarCurr,bitIndex17)
        <=> v4569(VarCurr,bitIndex509) )
        & ( v4772(VarCurr,bitIndex16)
        <=> v4569(VarCurr,bitIndex508) )
        & ( v4772(VarCurr,bitIndex15)
        <=> v4569(VarCurr,bitIndex507) )
        & ( v4772(VarCurr,bitIndex14)
        <=> v4569(VarCurr,bitIndex506) )
        & ( v4772(VarCurr,bitIndex13)
        <=> v4569(VarCurr,bitIndex505) )
        & ( v4772(VarCurr,bitIndex12)
        <=> v4569(VarCurr,bitIndex504) )
        & ( v4772(VarCurr,bitIndex11)
        <=> v4569(VarCurr,bitIndex503) )
        & ( v4772(VarCurr,bitIndex10)
        <=> v4569(VarCurr,bitIndex502) )
        & ( v4772(VarCurr,bitIndex9)
        <=> v4569(VarCurr,bitIndex501) )
        & ( v4772(VarCurr,bitIndex8)
        <=> v4569(VarCurr,bitIndex500) )
        & ( v4772(VarCurr,bitIndex7)
        <=> v4569(VarCurr,bitIndex499) )
        & ( v4772(VarCurr,bitIndex6)
        <=> v4569(VarCurr,bitIndex498) )
        & ( v4772(VarCurr,bitIndex5)
        <=> v4569(VarCurr,bitIndex497) )
        & ( v4772(VarCurr,bitIndex4)
        <=> v4569(VarCurr,bitIndex496) )
        & ( v4772(VarCurr,bitIndex3)
        <=> v4569(VarCurr,bitIndex495) )
        & ( v4772(VarCurr,bitIndex2)
        <=> v4569(VarCurr,bitIndex494) )
        & ( v4772(VarCurr,bitIndex1)
        <=> v4569(VarCurr,bitIndex493) )
        & ( v4772(VarCurr,bitIndex0)
        <=> v4569(VarCurr,bitIndex492) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_671,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4745(VarNext)
      <=> ( v4746(VarNext)
          & v4753(VarNext) ) ) ) ).

fof(addAssignment_1434,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4753(VarNext)
      <=> v4751(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_670,axiom,
    ! [VarCurr] :
      ( v4751(VarCurr)
    <=> ( v4754(VarCurr)
        & v4765(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_669,axiom,
    ! [VarCurr] :
      ( v4765(VarCurr)
    <=> ( v4766(VarCurr)
        | v4708(VarCurr) ) ) ).

fof(writeUnaryOperator_357,axiom,
    ! [VarCurr] :
      ( ~ v4766(VarCurr)
    <=> v4767(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_312,axiom,
    ! [VarCurr] :
      ( v4767(VarCurr)
    <=> ( ( v4768(VarCurr,bitIndex1)
        <=> $false )
        & ( v4768(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1433,axiom,
    ! [VarCurr] :
      ( v4768(VarCurr,bitIndex0)
    <=> v554(VarCurr) ) ).

fof(addAssignment_1432,axiom,
    ! [VarCurr] :
      ( v4768(VarCurr,bitIndex1)
    <=> v47(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_668,axiom,
    ! [VarCurr] :
      ( v4754(VarCurr)
    <=> ( v4708(VarCurr)
        | v4755(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_667,axiom,
    ! [VarCurr] :
      ( v4755(VarCurr)
    <=> ( v4756(VarCurr)
        & v4764(VarCurr) ) ) ).

fof(writeUnaryOperator_356,axiom,
    ! [VarCurr] :
      ( ~ v4764(VarCurr)
    <=> v4708(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_666,axiom,
    ! [VarCurr] :
      ( v4756(VarCurr)
    <=> ( v4757(VarCurr)
        | v4762(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_311,axiom,
    ! [VarCurr] :
      ( v4762(VarCurr)
    <=> ( ( v4763(VarCurr,bitIndex1)
        <=> $true )
        & ( v4763(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1431,axiom,
    ! [VarCurr] :
      ( v4763(VarCurr,bitIndex0)
    <=> v554(VarCurr) ) ).

fof(addAssignment_1430,axiom,
    ! [VarCurr] :
      ( v4763(VarCurr,bitIndex1)
    <=> v47(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_665,axiom,
    ! [VarCurr] :
      ( v4757(VarCurr)
    <=> ( v4758(VarCurr)
        | v4760(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_310,axiom,
    ! [VarCurr] :
      ( v4760(VarCurr)
    <=> ( ( v4761(VarCurr,bitIndex1)
        <=> $true )
        & ( v4761(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1429,axiom,
    ! [VarCurr] :
      ( v4761(VarCurr,bitIndex0)
    <=> v554(VarCurr) ) ).

fof(addAssignment_1428,axiom,
    ! [VarCurr] :
      ( v4761(VarCurr,bitIndex1)
    <=> v47(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_309,axiom,
    ! [VarCurr] :
      ( v4758(VarCurr)
    <=> ( ( v4759(VarCurr,bitIndex1)
        <=> $false )
        & ( v4759(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1427,axiom,
    ! [VarCurr] :
      ( v4759(VarCurr,bitIndex0)
    <=> v554(VarCurr) ) ).

fof(addAssignment_1426,axiom,
    ! [VarCurr] :
      ( v4759(VarCurr,bitIndex1)
    <=> v47(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_664,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4746(VarNext)
      <=> ( v4748(VarNext)
          & v4515(VarNext) ) ) ) ).

fof(writeUnaryOperator_355,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4748(VarNext)
      <=> v4522(VarNext) ) ) ).

fof(addAssignment_1425,axiom,
    ! [VarCurr,B] :
      ( range_122_116(B)
     => ( v4737(VarCurr,B)
      <=> v4742(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_121,axiom,
    ! [VarCurr] :
      ( ~ v4739(VarCurr)
     => ! [B] :
          ( range_122_0(B)
         => ( v4742(VarCurr,B)
          <=> v4741(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_153,axiom,
    ! [VarCurr] :
      ( v4739(VarCurr)
     => ! [B] :
          ( range_122_0(B)
         => ( v4742(VarCurr,B)
          <=> v4624(VarCurr,B) ) ) ) ).

fof(addAssignment_1424,axiom,
    ! [VarCurr] :
      ( ( v4741(VarCurr,bitIndex122)
      <=> v4569(VarCurr,bitIndex614) )
      & ( v4741(VarCurr,bitIndex121)
      <=> v4569(VarCurr,bitIndex613) )
      & ( v4741(VarCurr,bitIndex120)
      <=> v4569(VarCurr,bitIndex612) )
      & ( v4741(VarCurr,bitIndex119)
      <=> v4569(VarCurr,bitIndex611) )
      & ( v4741(VarCurr,bitIndex118)
      <=> v4569(VarCurr,bitIndex610) )
      & ( v4741(VarCurr,bitIndex117)
      <=> v4569(VarCurr,bitIndex609) )
      & ( v4741(VarCurr,bitIndex116)
      <=> v4569(VarCurr,bitIndex608) ) ) ).

fof(addAssignment_1423,axiom,
    ! [VarCurr] :
      ( v4739(VarCurr)
    <=> v4576(VarCurr,bitIndex1) ) ).

fof(addAssignment_1422,axiom,
    ! [VarCurr,B] :
      ( range_122_116(B)
     => ( v4730(VarCurr,B)
      <=> v4735(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_120,axiom,
    ! [VarCurr] :
      ( ~ v4732(VarCurr)
     => ! [B] :
          ( range_122_0(B)
         => ( v4735(VarCurr,B)
          <=> v4734(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_152,axiom,
    ! [VarCurr] :
      ( v4732(VarCurr)
     => ! [B] :
          ( range_122_0(B)
         => ( v4735(VarCurr,B)
          <=> v4624(VarCurr,B) ) ) ) ).

fof(addAssignment_1421,axiom,
    ! [VarCurr] :
      ( ( v4734(VarCurr,bitIndex122)
      <=> v4569(VarCurr,bitIndex737) )
      & ( v4734(VarCurr,bitIndex121)
      <=> v4569(VarCurr,bitIndex736) )
      & ( v4734(VarCurr,bitIndex120)
      <=> v4569(VarCurr,bitIndex735) )
      & ( v4734(VarCurr,bitIndex119)
      <=> v4569(VarCurr,bitIndex734) )
      & ( v4734(VarCurr,bitIndex118)
      <=> v4569(VarCurr,bitIndex733) )
      & ( v4734(VarCurr,bitIndex117)
      <=> v4569(VarCurr,bitIndex732) )
      & ( v4734(VarCurr,bitIndex116)
      <=> v4569(VarCurr,bitIndex731) ) ) ).

fof(addAssignment_1420,axiom,
    ! [VarCurr] :
      ( v4732(VarCurr)
    <=> v4576(VarCurr,bitIndex1) ) ).

fof(addAssignment_1419,axiom,
    ! [VarNext] :
      ( ( v4569(VarNext,bitIndex614)
      <=> v4697(VarNext,bitIndex122) )
      & ( v4569(VarNext,bitIndex613)
      <=> v4697(VarNext,bitIndex121) )
      & ( v4569(VarNext,bitIndex612)
      <=> v4697(VarNext,bitIndex120) )
      & ( v4569(VarNext,bitIndex611)
      <=> v4697(VarNext,bitIndex119) )
      & ( v4569(VarNext,bitIndex610)
      <=> v4697(VarNext,bitIndex118) )
      & ( v4569(VarNext,bitIndex609)
      <=> v4697(VarNext,bitIndex117) )
      & ( v4569(VarNext,bitIndex608)
      <=> v4697(VarNext,bitIndex116) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_4,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4698(VarNext)
       => ( ( v4697(VarNext,bitIndex122)
          <=> v4569(VarCurr,bitIndex614) )
          & ( v4697(VarNext,bitIndex121)
          <=> v4569(VarCurr,bitIndex613) )
          & ( v4697(VarNext,bitIndex120)
          <=> v4569(VarCurr,bitIndex612) )
          & ( v4697(VarNext,bitIndex119)
          <=> v4569(VarCurr,bitIndex611) )
          & ( v4697(VarNext,bitIndex118)
          <=> v4569(VarCurr,bitIndex610) )
          & ( v4697(VarNext,bitIndex117)
          <=> v4569(VarCurr,bitIndex609) )
          & ( v4697(VarNext,bitIndex116)
          <=> v4569(VarCurr,bitIndex608) )
          & ( v4697(VarNext,bitIndex115)
          <=> v4569(VarCurr,bitIndex607) )
          & ( v4697(VarNext,bitIndex114)
          <=> v4569(VarCurr,bitIndex606) )
          & ( v4697(VarNext,bitIndex113)
          <=> v4569(VarCurr,bitIndex605) )
          & ( v4697(VarNext,bitIndex112)
          <=> v4569(VarCurr,bitIndex604) )
          & ( v4697(VarNext,bitIndex111)
          <=> v4569(VarCurr,bitIndex603) )
          & ( v4697(VarNext,bitIndex110)
          <=> v4569(VarCurr,bitIndex602) )
          & ( v4697(VarNext,bitIndex109)
          <=> v4569(VarCurr,bitIndex601) )
          & ( v4697(VarNext,bitIndex108)
          <=> v4569(VarCurr,bitIndex600) )
          & ( v4697(VarNext,bitIndex107)
          <=> v4569(VarCurr,bitIndex599) )
          & ( v4697(VarNext,bitIndex106)
          <=> v4569(VarCurr,bitIndex598) )
          & ( v4697(VarNext,bitIndex105)
          <=> v4569(VarCurr,bitIndex597) )
          & ( v4697(VarNext,bitIndex104)
          <=> v4569(VarCurr,bitIndex596) )
          & ( v4697(VarNext,bitIndex103)
          <=> v4569(VarCurr,bitIndex595) )
          & ( v4697(VarNext,bitIndex102)
          <=> v4569(VarCurr,bitIndex594) )
          & ( v4697(VarNext,bitIndex101)
          <=> v4569(VarCurr,bitIndex593) )
          & ( v4697(VarNext,bitIndex100)
          <=> v4569(VarCurr,bitIndex592) )
          & ( v4697(VarNext,bitIndex99)
          <=> v4569(VarCurr,bitIndex591) )
          & ( v4697(VarNext,bitIndex98)
          <=> v4569(VarCurr,bitIndex590) )
          & ( v4697(VarNext,bitIndex97)
          <=> v4569(VarCurr,bitIndex589) )
          & ( v4697(VarNext,bitIndex96)
          <=> v4569(VarCurr,bitIndex588) )
          & ( v4697(VarNext,bitIndex95)
          <=> v4569(VarCurr,bitIndex587) )
          & ( v4697(VarNext,bitIndex94)
          <=> v4569(VarCurr,bitIndex586) )
          & ( v4697(VarNext,bitIndex93)
          <=> v4569(VarCurr,bitIndex585) )
          & ( v4697(VarNext,bitIndex92)
          <=> v4569(VarCurr,bitIndex584) )
          & ( v4697(VarNext,bitIndex91)
          <=> v4569(VarCurr,bitIndex583) )
          & ( v4697(VarNext,bitIndex90)
          <=> v4569(VarCurr,bitIndex582) )
          & ( v4697(VarNext,bitIndex89)
          <=> v4569(VarCurr,bitIndex581) )
          & ( v4697(VarNext,bitIndex88)
          <=> v4569(VarCurr,bitIndex580) )
          & ( v4697(VarNext,bitIndex87)
          <=> v4569(VarCurr,bitIndex579) )
          & ( v4697(VarNext,bitIndex86)
          <=> v4569(VarCurr,bitIndex578) )
          & ( v4697(VarNext,bitIndex85)
          <=> v4569(VarCurr,bitIndex577) )
          & ( v4697(VarNext,bitIndex84)
          <=> v4569(VarCurr,bitIndex576) )
          & ( v4697(VarNext,bitIndex83)
          <=> v4569(VarCurr,bitIndex575) )
          & ( v4697(VarNext,bitIndex82)
          <=> v4569(VarCurr,bitIndex574) )
          & ( v4697(VarNext,bitIndex81)
          <=> v4569(VarCurr,bitIndex573) )
          & ( v4697(VarNext,bitIndex80)
          <=> v4569(VarCurr,bitIndex572) )
          & ( v4697(VarNext,bitIndex79)
          <=> v4569(VarCurr,bitIndex571) )
          & ( v4697(VarNext,bitIndex78)
          <=> v4569(VarCurr,bitIndex570) )
          & ( v4697(VarNext,bitIndex77)
          <=> v4569(VarCurr,bitIndex569) )
          & ( v4697(VarNext,bitIndex76)
          <=> v4569(VarCurr,bitIndex568) )
          & ( v4697(VarNext,bitIndex75)
          <=> v4569(VarCurr,bitIndex567) )
          & ( v4697(VarNext,bitIndex74)
          <=> v4569(VarCurr,bitIndex566) )
          & ( v4697(VarNext,bitIndex73)
          <=> v4569(VarCurr,bitIndex565) )
          & ( v4697(VarNext,bitIndex72)
          <=> v4569(VarCurr,bitIndex564) )
          & ( v4697(VarNext,bitIndex71)
          <=> v4569(VarCurr,bitIndex563) )
          & ( v4697(VarNext,bitIndex70)
          <=> v4569(VarCurr,bitIndex562) )
          & ( v4697(VarNext,bitIndex69)
          <=> v4569(VarCurr,bitIndex561) )
          & ( v4697(VarNext,bitIndex68)
          <=> v4569(VarCurr,bitIndex560) )
          & ( v4697(VarNext,bitIndex67)
          <=> v4569(VarCurr,bitIndex559) )
          & ( v4697(VarNext,bitIndex66)
          <=> v4569(VarCurr,bitIndex558) )
          & ( v4697(VarNext,bitIndex65)
          <=> v4569(VarCurr,bitIndex557) )
          & ( v4697(VarNext,bitIndex64)
          <=> v4569(VarCurr,bitIndex556) )
          & ( v4697(VarNext,bitIndex63)
          <=> v4569(VarCurr,bitIndex555) )
          & ( v4697(VarNext,bitIndex62)
          <=> v4569(VarCurr,bitIndex554) )
          & ( v4697(VarNext,bitIndex61)
          <=> v4569(VarCurr,bitIndex553) )
          & ( v4697(VarNext,bitIndex60)
          <=> v4569(VarCurr,bitIndex552) )
          & ( v4697(VarNext,bitIndex59)
          <=> v4569(VarCurr,bitIndex551) )
          & ( v4697(VarNext,bitIndex58)
          <=> v4569(VarCurr,bitIndex550) )
          & ( v4697(VarNext,bitIndex57)
          <=> v4569(VarCurr,bitIndex549) )
          & ( v4697(VarNext,bitIndex56)
          <=> v4569(VarCurr,bitIndex548) )
          & ( v4697(VarNext,bitIndex55)
          <=> v4569(VarCurr,bitIndex547) )
          & ( v4697(VarNext,bitIndex54)
          <=> v4569(VarCurr,bitIndex546) )
          & ( v4697(VarNext,bitIndex53)
          <=> v4569(VarCurr,bitIndex545) )
          & ( v4697(VarNext,bitIndex52)
          <=> v4569(VarCurr,bitIndex544) )
          & ( v4697(VarNext,bitIndex51)
          <=> v4569(VarCurr,bitIndex543) )
          & ( v4697(VarNext,bitIndex50)
          <=> v4569(VarCurr,bitIndex542) )
          & ( v4697(VarNext,bitIndex49)
          <=> v4569(VarCurr,bitIndex541) )
          & ( v4697(VarNext,bitIndex48)
          <=> v4569(VarCurr,bitIndex540) )
          & ( v4697(VarNext,bitIndex47)
          <=> v4569(VarCurr,bitIndex539) )
          & ( v4697(VarNext,bitIndex46)
          <=> v4569(VarCurr,bitIndex538) )
          & ( v4697(VarNext,bitIndex45)
          <=> v4569(VarCurr,bitIndex537) )
          & ( v4697(VarNext,bitIndex44)
          <=> v4569(VarCurr,bitIndex536) )
          & ( v4697(VarNext,bitIndex43)
          <=> v4569(VarCurr,bitIndex535) )
          & ( v4697(VarNext,bitIndex42)
          <=> v4569(VarCurr,bitIndex534) )
          & ( v4697(VarNext,bitIndex41)
          <=> v4569(VarCurr,bitIndex533) )
          & ( v4697(VarNext,bitIndex40)
          <=> v4569(VarCurr,bitIndex532) )
          & ( v4697(VarNext,bitIndex39)
          <=> v4569(VarCurr,bitIndex531) )
          & ( v4697(VarNext,bitIndex38)
          <=> v4569(VarCurr,bitIndex530) )
          & ( v4697(VarNext,bitIndex37)
          <=> v4569(VarCurr,bitIndex529) )
          & ( v4697(VarNext,bitIndex36)
          <=> v4569(VarCurr,bitIndex528) )
          & ( v4697(VarNext,bitIndex35)
          <=> v4569(VarCurr,bitIndex527) )
          & ( v4697(VarNext,bitIndex34)
          <=> v4569(VarCurr,bitIndex526) )
          & ( v4697(VarNext,bitIndex33)
          <=> v4569(VarCurr,bitIndex525) )
          & ( v4697(VarNext,bitIndex32)
          <=> v4569(VarCurr,bitIndex524) )
          & ( v4697(VarNext,bitIndex31)
          <=> v4569(VarCurr,bitIndex523) )
          & ( v4697(VarNext,bitIndex30)
          <=> v4569(VarCurr,bitIndex522) )
          & ( v4697(VarNext,bitIndex29)
          <=> v4569(VarCurr,bitIndex521) )
          & ( v4697(VarNext,bitIndex28)
          <=> v4569(VarCurr,bitIndex520) )
          & ( v4697(VarNext,bitIndex27)
          <=> v4569(VarCurr,bitIndex519) )
          & ( v4697(VarNext,bitIndex26)
          <=> v4569(VarCurr,bitIndex518) )
          & ( v4697(VarNext,bitIndex25)
          <=> v4569(VarCurr,bitIndex517) )
          & ( v4697(VarNext,bitIndex24)
          <=> v4569(VarCurr,bitIndex516) )
          & ( v4697(VarNext,bitIndex23)
          <=> v4569(VarCurr,bitIndex515) )
          & ( v4697(VarNext,bitIndex22)
          <=> v4569(VarCurr,bitIndex514) )
          & ( v4697(VarNext,bitIndex21)
          <=> v4569(VarCurr,bitIndex513) )
          & ( v4697(VarNext,bitIndex20)
          <=> v4569(VarCurr,bitIndex512) )
          & ( v4697(VarNext,bitIndex19)
          <=> v4569(VarCurr,bitIndex511) )
          & ( v4697(VarNext,bitIndex18)
          <=> v4569(VarCurr,bitIndex510) )
          & ( v4697(VarNext,bitIndex17)
          <=> v4569(VarCurr,bitIndex509) )
          & ( v4697(VarNext,bitIndex16)
          <=> v4569(VarCurr,bitIndex508) )
          & ( v4697(VarNext,bitIndex15)
          <=> v4569(VarCurr,bitIndex507) )
          & ( v4697(VarNext,bitIndex14)
          <=> v4569(VarCurr,bitIndex506) )
          & ( v4697(VarNext,bitIndex13)
          <=> v4569(VarCurr,bitIndex505) )
          & ( v4697(VarNext,bitIndex12)
          <=> v4569(VarCurr,bitIndex504) )
          & ( v4697(VarNext,bitIndex11)
          <=> v4569(VarCurr,bitIndex503) )
          & ( v4697(VarNext,bitIndex10)
          <=> v4569(VarCurr,bitIndex502) )
          & ( v4697(VarNext,bitIndex9)
          <=> v4569(VarCurr,bitIndex501) )
          & ( v4697(VarNext,bitIndex8)
          <=> v4569(VarCurr,bitIndex500) )
          & ( v4697(VarNext,bitIndex7)
          <=> v4569(VarCurr,bitIndex499) )
          & ( v4697(VarNext,bitIndex6)
          <=> v4569(VarCurr,bitIndex498) )
          & ( v4697(VarNext,bitIndex5)
          <=> v4569(VarCurr,bitIndex497) )
          & ( v4697(VarNext,bitIndex4)
          <=> v4569(VarCurr,bitIndex496) )
          & ( v4697(VarNext,bitIndex3)
          <=> v4569(VarCurr,bitIndex495) )
          & ( v4697(VarNext,bitIndex2)
          <=> v4569(VarCurr,bitIndex494) )
          & ( v4697(VarNext,bitIndex1)
          <=> v4569(VarCurr,bitIndex493) )
          & ( v4697(VarNext,bitIndex0)
          <=> v4569(VarCurr,bitIndex492) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_61,axiom,
    ! [VarNext] :
      ( v4698(VarNext)
     => ! [B] :
          ( range_122_0(B)
         => ( v4697(VarNext,B)
          <=> v4725(VarNext,B) ) ) ) ).

fof(addAssignment_1418,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_122_0(B)
         => ( v4725(VarNext,B)
          <=> v4723(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_61,axiom,
    ! [VarCurr] :
      ( ~ v4708(VarCurr)
     => ! [B] :
          ( range_122_0(B)
         => ( v4723(VarCurr,B)
          <=> v4726(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_58,axiom,
    ! [VarCurr] :
      ( v4708(VarCurr)
     => ! [B] :
          ( range_122_0(B)
         => ( v4723(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_36,axiom,
    ! [VarCurr] :
      ( ( ~ v4712(VarCurr)
        & ~ v4714(VarCurr) )
     => ! [B] :
          ( range_122_0(B)
         => ( v4726(VarCurr,B)
          <=> v4690(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_60,axiom,
    ! [VarCurr] :
      ( v4714(VarCurr)
     => ! [B] :
          ( range_122_0(B)
         => ( v4726(VarCurr,B)
          <=> v4572(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_5,axiom,
    ! [VarCurr] :
      ( v4712(VarCurr)
     => ( ( v4726(VarCurr,bitIndex122)
        <=> v4569(VarCurr,bitIndex491) )
        & ( v4726(VarCurr,bitIndex121)
        <=> v4569(VarCurr,bitIndex490) )
        & ( v4726(VarCurr,bitIndex120)
        <=> v4569(VarCurr,bitIndex489) )
        & ( v4726(VarCurr,bitIndex119)
        <=> v4569(VarCurr,bitIndex488) )
        & ( v4726(VarCurr,bitIndex118)
        <=> v4569(VarCurr,bitIndex487) )
        & ( v4726(VarCurr,bitIndex117)
        <=> v4569(VarCurr,bitIndex486) )
        & ( v4726(VarCurr,bitIndex116)
        <=> v4569(VarCurr,bitIndex485) )
        & ( v4726(VarCurr,bitIndex115)
        <=> v4569(VarCurr,bitIndex484) )
        & ( v4726(VarCurr,bitIndex114)
        <=> v4569(VarCurr,bitIndex483) )
        & ( v4726(VarCurr,bitIndex113)
        <=> v4569(VarCurr,bitIndex482) )
        & ( v4726(VarCurr,bitIndex112)
        <=> v4569(VarCurr,bitIndex481) )
        & ( v4726(VarCurr,bitIndex111)
        <=> v4569(VarCurr,bitIndex480) )
        & ( v4726(VarCurr,bitIndex110)
        <=> v4569(VarCurr,bitIndex479) )
        & ( v4726(VarCurr,bitIndex109)
        <=> v4569(VarCurr,bitIndex478) )
        & ( v4726(VarCurr,bitIndex108)
        <=> v4569(VarCurr,bitIndex477) )
        & ( v4726(VarCurr,bitIndex107)
        <=> v4569(VarCurr,bitIndex476) )
        & ( v4726(VarCurr,bitIndex106)
        <=> v4569(VarCurr,bitIndex475) )
        & ( v4726(VarCurr,bitIndex105)
        <=> v4569(VarCurr,bitIndex474) )
        & ( v4726(VarCurr,bitIndex104)
        <=> v4569(VarCurr,bitIndex473) )
        & ( v4726(VarCurr,bitIndex103)
        <=> v4569(VarCurr,bitIndex472) )
        & ( v4726(VarCurr,bitIndex102)
        <=> v4569(VarCurr,bitIndex471) )
        & ( v4726(VarCurr,bitIndex101)
        <=> v4569(VarCurr,bitIndex470) )
        & ( v4726(VarCurr,bitIndex100)
        <=> v4569(VarCurr,bitIndex469) )
        & ( v4726(VarCurr,bitIndex99)
        <=> v4569(VarCurr,bitIndex468) )
        & ( v4726(VarCurr,bitIndex98)
        <=> v4569(VarCurr,bitIndex467) )
        & ( v4726(VarCurr,bitIndex97)
        <=> v4569(VarCurr,bitIndex466) )
        & ( v4726(VarCurr,bitIndex96)
        <=> v4569(VarCurr,bitIndex465) )
        & ( v4726(VarCurr,bitIndex95)
        <=> v4569(VarCurr,bitIndex464) )
        & ( v4726(VarCurr,bitIndex94)
        <=> v4569(VarCurr,bitIndex463) )
        & ( v4726(VarCurr,bitIndex93)
        <=> v4569(VarCurr,bitIndex462) )
        & ( v4726(VarCurr,bitIndex92)
        <=> v4569(VarCurr,bitIndex461) )
        & ( v4726(VarCurr,bitIndex91)
        <=> v4569(VarCurr,bitIndex460) )
        & ( v4726(VarCurr,bitIndex90)
        <=> v4569(VarCurr,bitIndex459) )
        & ( v4726(VarCurr,bitIndex89)
        <=> v4569(VarCurr,bitIndex458) )
        & ( v4726(VarCurr,bitIndex88)
        <=> v4569(VarCurr,bitIndex457) )
        & ( v4726(VarCurr,bitIndex87)
        <=> v4569(VarCurr,bitIndex456) )
        & ( v4726(VarCurr,bitIndex86)
        <=> v4569(VarCurr,bitIndex455) )
        & ( v4726(VarCurr,bitIndex85)
        <=> v4569(VarCurr,bitIndex454) )
        & ( v4726(VarCurr,bitIndex84)
        <=> v4569(VarCurr,bitIndex453) )
        & ( v4726(VarCurr,bitIndex83)
        <=> v4569(VarCurr,bitIndex452) )
        & ( v4726(VarCurr,bitIndex82)
        <=> v4569(VarCurr,bitIndex451) )
        & ( v4726(VarCurr,bitIndex81)
        <=> v4569(VarCurr,bitIndex450) )
        & ( v4726(VarCurr,bitIndex80)
        <=> v4569(VarCurr,bitIndex449) )
        & ( v4726(VarCurr,bitIndex79)
        <=> v4569(VarCurr,bitIndex448) )
        & ( v4726(VarCurr,bitIndex78)
        <=> v4569(VarCurr,bitIndex447) )
        & ( v4726(VarCurr,bitIndex77)
        <=> v4569(VarCurr,bitIndex446) )
        & ( v4726(VarCurr,bitIndex76)
        <=> v4569(VarCurr,bitIndex445) )
        & ( v4726(VarCurr,bitIndex75)
        <=> v4569(VarCurr,bitIndex444) )
        & ( v4726(VarCurr,bitIndex74)
        <=> v4569(VarCurr,bitIndex443) )
        & ( v4726(VarCurr,bitIndex73)
        <=> v4569(VarCurr,bitIndex442) )
        & ( v4726(VarCurr,bitIndex72)
        <=> v4569(VarCurr,bitIndex441) )
        & ( v4726(VarCurr,bitIndex71)
        <=> v4569(VarCurr,bitIndex440) )
        & ( v4726(VarCurr,bitIndex70)
        <=> v4569(VarCurr,bitIndex439) )
        & ( v4726(VarCurr,bitIndex69)
        <=> v4569(VarCurr,bitIndex438) )
        & ( v4726(VarCurr,bitIndex68)
        <=> v4569(VarCurr,bitIndex437) )
        & ( v4726(VarCurr,bitIndex67)
        <=> v4569(VarCurr,bitIndex436) )
        & ( v4726(VarCurr,bitIndex66)
        <=> v4569(VarCurr,bitIndex435) )
        & ( v4726(VarCurr,bitIndex65)
        <=> v4569(VarCurr,bitIndex434) )
        & ( v4726(VarCurr,bitIndex64)
        <=> v4569(VarCurr,bitIndex433) )
        & ( v4726(VarCurr,bitIndex63)
        <=> v4569(VarCurr,bitIndex432) )
        & ( v4726(VarCurr,bitIndex62)
        <=> v4569(VarCurr,bitIndex431) )
        & ( v4726(VarCurr,bitIndex61)
        <=> v4569(VarCurr,bitIndex430) )
        & ( v4726(VarCurr,bitIndex60)
        <=> v4569(VarCurr,bitIndex429) )
        & ( v4726(VarCurr,bitIndex59)
        <=> v4569(VarCurr,bitIndex428) )
        & ( v4726(VarCurr,bitIndex58)
        <=> v4569(VarCurr,bitIndex427) )
        & ( v4726(VarCurr,bitIndex57)
        <=> v4569(VarCurr,bitIndex426) )
        & ( v4726(VarCurr,bitIndex56)
        <=> v4569(VarCurr,bitIndex425) )
        & ( v4726(VarCurr,bitIndex55)
        <=> v4569(VarCurr,bitIndex424) )
        & ( v4726(VarCurr,bitIndex54)
        <=> v4569(VarCurr,bitIndex423) )
        & ( v4726(VarCurr,bitIndex53)
        <=> v4569(VarCurr,bitIndex422) )
        & ( v4726(VarCurr,bitIndex52)
        <=> v4569(VarCurr,bitIndex421) )
        & ( v4726(VarCurr,bitIndex51)
        <=> v4569(VarCurr,bitIndex420) )
        & ( v4726(VarCurr,bitIndex50)
        <=> v4569(VarCurr,bitIndex419) )
        & ( v4726(VarCurr,bitIndex49)
        <=> v4569(VarCurr,bitIndex418) )
        & ( v4726(VarCurr,bitIndex48)
        <=> v4569(VarCurr,bitIndex417) )
        & ( v4726(VarCurr,bitIndex47)
        <=> v4569(VarCurr,bitIndex416) )
        & ( v4726(VarCurr,bitIndex46)
        <=> v4569(VarCurr,bitIndex415) )
        & ( v4726(VarCurr,bitIndex45)
        <=> v4569(VarCurr,bitIndex414) )
        & ( v4726(VarCurr,bitIndex44)
        <=> v4569(VarCurr,bitIndex413) )
        & ( v4726(VarCurr,bitIndex43)
        <=> v4569(VarCurr,bitIndex412) )
        & ( v4726(VarCurr,bitIndex42)
        <=> v4569(VarCurr,bitIndex411) )
        & ( v4726(VarCurr,bitIndex41)
        <=> v4569(VarCurr,bitIndex410) )
        & ( v4726(VarCurr,bitIndex40)
        <=> v4569(VarCurr,bitIndex409) )
        & ( v4726(VarCurr,bitIndex39)
        <=> v4569(VarCurr,bitIndex408) )
        & ( v4726(VarCurr,bitIndex38)
        <=> v4569(VarCurr,bitIndex407) )
        & ( v4726(VarCurr,bitIndex37)
        <=> v4569(VarCurr,bitIndex406) )
        & ( v4726(VarCurr,bitIndex36)
        <=> v4569(VarCurr,bitIndex405) )
        & ( v4726(VarCurr,bitIndex35)
        <=> v4569(VarCurr,bitIndex404) )
        & ( v4726(VarCurr,bitIndex34)
        <=> v4569(VarCurr,bitIndex403) )
        & ( v4726(VarCurr,bitIndex33)
        <=> v4569(VarCurr,bitIndex402) )
        & ( v4726(VarCurr,bitIndex32)
        <=> v4569(VarCurr,bitIndex401) )
        & ( v4726(VarCurr,bitIndex31)
        <=> v4569(VarCurr,bitIndex400) )
        & ( v4726(VarCurr,bitIndex30)
        <=> v4569(VarCurr,bitIndex399) )
        & ( v4726(VarCurr,bitIndex29)
        <=> v4569(VarCurr,bitIndex398) )
        & ( v4726(VarCurr,bitIndex28)
        <=> v4569(VarCurr,bitIndex397) )
        & ( v4726(VarCurr,bitIndex27)
        <=> v4569(VarCurr,bitIndex396) )
        & ( v4726(VarCurr,bitIndex26)
        <=> v4569(VarCurr,bitIndex395) )
        & ( v4726(VarCurr,bitIndex25)
        <=> v4569(VarCurr,bitIndex394) )
        & ( v4726(VarCurr,bitIndex24)
        <=> v4569(VarCurr,bitIndex393) )
        & ( v4726(VarCurr,bitIndex23)
        <=> v4569(VarCurr,bitIndex392) )
        & ( v4726(VarCurr,bitIndex22)
        <=> v4569(VarCurr,bitIndex391) )
        & ( v4726(VarCurr,bitIndex21)
        <=> v4569(VarCurr,bitIndex390) )
        & ( v4726(VarCurr,bitIndex20)
        <=> v4569(VarCurr,bitIndex389) )
        & ( v4726(VarCurr,bitIndex19)
        <=> v4569(VarCurr,bitIndex388) )
        & ( v4726(VarCurr,bitIndex18)
        <=> v4569(VarCurr,bitIndex387) )
        & ( v4726(VarCurr,bitIndex17)
        <=> v4569(VarCurr,bitIndex386) )
        & ( v4726(VarCurr,bitIndex16)
        <=> v4569(VarCurr,bitIndex385) )
        & ( v4726(VarCurr,bitIndex15)
        <=> v4569(VarCurr,bitIndex384) )
        & ( v4726(VarCurr,bitIndex14)
        <=> v4569(VarCurr,bitIndex383) )
        & ( v4726(VarCurr,bitIndex13)
        <=> v4569(VarCurr,bitIndex382) )
        & ( v4726(VarCurr,bitIndex12)
        <=> v4569(VarCurr,bitIndex381) )
        & ( v4726(VarCurr,bitIndex11)
        <=> v4569(VarCurr,bitIndex380) )
        & ( v4726(VarCurr,bitIndex10)
        <=> v4569(VarCurr,bitIndex379) )
        & ( v4726(VarCurr,bitIndex9)
        <=> v4569(VarCurr,bitIndex378) )
        & ( v4726(VarCurr,bitIndex8)
        <=> v4569(VarCurr,bitIndex377) )
        & ( v4726(VarCurr,bitIndex7)
        <=> v4569(VarCurr,bitIndex376) )
        & ( v4726(VarCurr,bitIndex6)
        <=> v4569(VarCurr,bitIndex375) )
        & ( v4726(VarCurr,bitIndex5)
        <=> v4569(VarCurr,bitIndex374) )
        & ( v4726(VarCurr,bitIndex4)
        <=> v4569(VarCurr,bitIndex373) )
        & ( v4726(VarCurr,bitIndex3)
        <=> v4569(VarCurr,bitIndex372) )
        & ( v4726(VarCurr,bitIndex2)
        <=> v4569(VarCurr,bitIndex371) )
        & ( v4726(VarCurr,bitIndex1)
        <=> v4569(VarCurr,bitIndex370) )
        & ( v4726(VarCurr,bitIndex0)
        <=> v4569(VarCurr,bitIndex369) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_663,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4698(VarNext)
      <=> ( v4699(VarNext)
          & v4706(VarNext) ) ) ) ).

fof(addAssignment_1417,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4706(VarNext)
      <=> v4704(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_662,axiom,
    ! [VarCurr] :
      ( v4704(VarCurr)
    <=> ( v4707(VarCurr)
        & v4719(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_661,axiom,
    ! [VarCurr] :
      ( v4719(VarCurr)
    <=> ( v4720(VarCurr)
        | v4708(VarCurr) ) ) ).

fof(writeUnaryOperator_354,axiom,
    ! [VarCurr] :
      ( ~ v4720(VarCurr)
    <=> v4721(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_308,axiom,
    ! [VarCurr] :
      ( v4721(VarCurr)
    <=> ( ( v4722(VarCurr,bitIndex1)
        <=> $false )
        & ( v4722(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1416,axiom,
    ! [VarCurr] :
      ( v4722(VarCurr,bitIndex0)
    <=> v554(VarCurr) ) ).

fof(addAssignment_1415,axiom,
    ! [VarCurr] :
      ( v4722(VarCurr,bitIndex1)
    <=> v47(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_660,axiom,
    ! [VarCurr] :
      ( v4707(VarCurr)
    <=> ( v4708(VarCurr)
        | v4709(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_659,axiom,
    ! [VarCurr] :
      ( v4709(VarCurr)
    <=> ( v4710(VarCurr)
        & v4718(VarCurr) ) ) ).

fof(writeUnaryOperator_353,axiom,
    ! [VarCurr] :
      ( ~ v4718(VarCurr)
    <=> v4708(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_658,axiom,
    ! [VarCurr] :
      ( v4710(VarCurr)
    <=> ( v4711(VarCurr)
        | v4716(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_307,axiom,
    ! [VarCurr] :
      ( v4716(VarCurr)
    <=> ( ( v4717(VarCurr,bitIndex1)
        <=> $true )
        & ( v4717(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1414,axiom,
    ! [VarCurr] :
      ( v4717(VarCurr,bitIndex0)
    <=> v554(VarCurr) ) ).

fof(addAssignment_1413,axiom,
    ! [VarCurr] :
      ( v4717(VarCurr,bitIndex1)
    <=> v47(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_657,axiom,
    ! [VarCurr] :
      ( v4711(VarCurr)
    <=> ( v4712(VarCurr)
        | v4714(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_306,axiom,
    ! [VarCurr] :
      ( v4714(VarCurr)
    <=> ( ( v4715(VarCurr,bitIndex1)
        <=> $true )
        & ( v4715(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1412,axiom,
    ! [VarCurr] :
      ( v4715(VarCurr,bitIndex0)
    <=> v554(VarCurr) ) ).

fof(addAssignment_1411,axiom,
    ! [VarCurr] :
      ( v4715(VarCurr,bitIndex1)
    <=> v47(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_305,axiom,
    ! [VarCurr] :
      ( v4712(VarCurr)
    <=> ( ( v4713(VarCurr,bitIndex1)
        <=> $false )
        & ( v4713(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1410,axiom,
    ! [VarCurr] :
      ( v4713(VarCurr,bitIndex0)
    <=> v554(VarCurr) ) ).

fof(addAssignment_1409,axiom,
    ! [VarCurr] :
      ( v4713(VarCurr,bitIndex1)
    <=> v47(VarCurr) ) ).

fof(writeUnaryOperator_352,axiom,
    ! [VarCurr] :
      ( ~ v4708(VarCurr)
    <=> v43(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_656,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4699(VarNext)
      <=> ( v4700(VarNext)
          & v4515(VarNext) ) ) ) ).

fof(writeUnaryOperator_351,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4700(VarNext)
      <=> v4522(VarNext) ) ) ).

fof(addAssignment_1408,axiom,
    ! [VarCurr,B] :
      ( range_122_116(B)
     => ( v4690(VarCurr,B)
      <=> v4695(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_119,axiom,
    ! [VarCurr] :
      ( ~ v4692(VarCurr)
     => ! [B] :
          ( range_122_0(B)
         => ( v4695(VarCurr,B)
          <=> v4694(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_151,axiom,
    ! [VarCurr] :
      ( v4692(VarCurr)
     => ! [B] :
          ( range_122_0(B)
         => ( v4695(VarCurr,B)
          <=> v4624(VarCurr,B) ) ) ) ).

fof(addAssignment_1407,axiom,
    ! [VarCurr] :
      ( ( v4694(VarCurr,bitIndex122)
      <=> v4569(VarCurr,bitIndex491) )
      & ( v4694(VarCurr,bitIndex121)
      <=> v4569(VarCurr,bitIndex490) )
      & ( v4694(VarCurr,bitIndex120)
      <=> v4569(VarCurr,bitIndex489) )
      & ( v4694(VarCurr,bitIndex119)
      <=> v4569(VarCurr,bitIndex488) )
      & ( v4694(VarCurr,bitIndex118)
      <=> v4569(VarCurr,bitIndex487) )
      & ( v4694(VarCurr,bitIndex117)
      <=> v4569(VarCurr,bitIndex486) )
      & ( v4694(VarCurr,bitIndex116)
      <=> v4569(VarCurr,bitIndex485) ) ) ).

fof(addAssignment_1406,axiom,
    ! [VarCurr] :
      ( v4692(VarCurr)
    <=> v4576(VarCurr,bitIndex2) ) ).

fof(addAssignment_1405,axiom,
    ! [VarCurr,B] :
      ( range_122_116(B)
     => ( v4572(VarCurr,B)
      <=> v4688(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_118,axiom,
    ! [VarCurr] :
      ( ~ v4574(VarCurr)
     => ! [B] :
          ( range_122_0(B)
         => ( v4688(VarCurr,B)
          <=> v4681(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_150,axiom,
    ! [VarCurr] :
      ( v4574(VarCurr)
     => ! [B] :
          ( range_122_0(B)
         => ( v4688(VarCurr,B)
          <=> v4624(VarCurr,B) ) ) ) ).

fof(addAssignment_1404,axiom,
    ! [VarCurr] :
      ( ( v4681(VarCurr,bitIndex122)
      <=> v4569(VarCurr,bitIndex614) )
      & ( v4681(VarCurr,bitIndex121)
      <=> v4569(VarCurr,bitIndex613) )
      & ( v4681(VarCurr,bitIndex120)
      <=> v4569(VarCurr,bitIndex612) )
      & ( v4681(VarCurr,bitIndex119)
      <=> v4569(VarCurr,bitIndex611) )
      & ( v4681(VarCurr,bitIndex118)
      <=> v4569(VarCurr,bitIndex610) )
      & ( v4681(VarCurr,bitIndex117)
      <=> v4569(VarCurr,bitIndex609) )
      & ( v4681(VarCurr,bitIndex116)
      <=> v4569(VarCurr,bitIndex608) ) ) ).

fof(addAssignmentInitValue_281,axiom,
    ~ v4569(constB0,bitIndex737) ).

fof(addAssignmentInitValue_280,axiom,
    ~ v4569(constB0,bitIndex736) ).

fof(addAssignmentInitValue_279,axiom,
    ~ v4569(constB0,bitIndex735) ).

fof(addAssignmentInitValue_278,axiom,
    ~ v4569(constB0,bitIndex734) ).

fof(addAssignmentInitValue_277,axiom,
    ~ v4569(constB0,bitIndex733) ).

fof(addAssignmentInitValue_276,axiom,
    ~ v4569(constB0,bitIndex732) ).

fof(addAssignmentInitValue_275,axiom,
    ~ v4569(constB0,bitIndex731) ).

fof(addAssignmentInitValue_274,axiom,
    ~ v4569(constB0,bitIndex696) ).

fof(bitBlastConstant_1541,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex122) ).

fof(bitBlastConstant_1540,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex121) ).

fof(bitBlastConstant_1539,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex120) ).

fof(bitBlastConstant_1538,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex119) ).

fof(bitBlastConstant_1537,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex118) ).

fof(bitBlastConstant_1536,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex117) ).

fof(bitBlastConstant_1535,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex116) ).

fof(bitBlastConstant_1534,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex81) ).

fof(addAssignmentInitValue_273,axiom,
    ~ v4569(constB0,bitIndex614) ).

fof(addAssignmentInitValue_272,axiom,
    ~ v4569(constB0,bitIndex613) ).

fof(addAssignmentInitValue_271,axiom,
    ~ v4569(constB0,bitIndex612) ).

fof(addAssignmentInitValue_270,axiom,
    ~ v4569(constB0,bitIndex611) ).

fof(addAssignmentInitValue_269,axiom,
    ~ v4569(constB0,bitIndex610) ).

fof(addAssignmentInitValue_268,axiom,
    ~ v4569(constB0,bitIndex609) ).

fof(addAssignmentInitValue_267,axiom,
    ~ v4569(constB0,bitIndex608) ).

fof(addAssignmentInitValue_266,axiom,
    ~ v4569(constB0,bitIndex573) ).

fof(bitBlastConstant_1533,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex122) ).

fof(bitBlastConstant_1532,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex121) ).

fof(bitBlastConstant_1531,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex120) ).

fof(bitBlastConstant_1530,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex119) ).

fof(bitBlastConstant_1529,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex118) ).

fof(bitBlastConstant_1528,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex117) ).

fof(bitBlastConstant_1527,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex116) ).

fof(bitBlastConstant_1526,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex81) ).

fof(addAssignmentInitValue_265,axiom,
    ~ v4569(constB0,bitIndex491) ).

fof(addAssignmentInitValue_264,axiom,
    ~ v4569(constB0,bitIndex490) ).

fof(addAssignmentInitValue_263,axiom,
    ~ v4569(constB0,bitIndex489) ).

fof(addAssignmentInitValue_262,axiom,
    ~ v4569(constB0,bitIndex488) ).

fof(addAssignmentInitValue_261,axiom,
    ~ v4569(constB0,bitIndex487) ).

fof(addAssignmentInitValue_260,axiom,
    ~ v4569(constB0,bitIndex486) ).

fof(addAssignmentInitValue_259,axiom,
    ~ v4569(constB0,bitIndex485) ).

fof(addAssignmentInitValue_258,axiom,
    ~ v4569(constB0,bitIndex450) ).

fof(bitBlastConstant_1525,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex122) ).

fof(bitBlastConstant_1524,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex121) ).

fof(bitBlastConstant_1523,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex120) ).

fof(bitBlastConstant_1522,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex119) ).

fof(bitBlastConstant_1521,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex118) ).

fof(bitBlastConstant_1520,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex117) ).

fof(bitBlastConstant_1519,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex116) ).

fof(bitBlastConstant_1518,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex81) ).

fof(addAssignment_1403,axiom,
    ! [VarCurr,B] :
      ( range_122_116(B)
     => ( v4624(VarCurr,B)
      <=> v4626(VarCurr,B) ) ) ).

fof(addAssignment_1402,axiom,
    ! [VarCurr,B] :
      ( range_122_116(B)
     => ( v4626(VarCurr,B)
      <=> v4628(VarCurr,B) ) ) ).

fof(addAssignment_1401,axiom,
    ! [VarCurr,B] :
      ( range_122_116(B)
     => ( v4628(VarCurr,B)
      <=> v4630(VarCurr,B) ) ) ).

fof(addAssignment_1400,axiom,
    ! [VarCurr,B] :
      ( range_122_116(B)
     => ( v4630(VarCurr,B)
      <=> v4632(VarCurr,B) ) ) ).

fof(addAssignment_1399,axiom,
    ! [VarCurr,B] :
      ( range_122_116(B)
     => ( v4632(VarCurr,B)
      <=> v4634(VarCurr,B) ) ) ).

fof(addAssignment_1398,axiom,
    ! [VarCurr,B] :
      ( range_122_116(B)
     => ( v4634(VarCurr,B)
      <=> v4636(VarCurr,B) ) ) ).

fof(addAssignment_1397,axiom,
    ! [VarCurr,B] :
      ( range_122_116(B)
     => ( v4636(VarCurr,B)
      <=> v4638(VarCurr,B) ) ) ).

fof(addAssignment_1396,axiom,
    ! [VarNext,B] :
      ( range_122_116(B)
     => ( v4638(VarNext,B)
      <=> v4665(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_59,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4666(VarNext)
       => ! [B] :
            ( range_122_0(B)
           => ( v4665(VarNext,B)
            <=> v4638(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_60,axiom,
    ! [VarNext] :
      ( v4666(VarNext)
     => ! [B] :
          ( range_122_0(B)
         => ( v4665(VarNext,B)
          <=> v4676(VarNext,B) ) ) ) ).

fof(addAssignment_1395,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_122_0(B)
         => ( v4676(VarNext,B)
          <=> v4674(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_117,axiom,
    ! [VarCurr] :
      ( ~ v4677(VarCurr)
     => ! [B] :
          ( range_122_0(B)
         => ( v4674(VarCurr,B)
          <=> v4642(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_149,axiom,
    ! [VarCurr] :
      ( v4677(VarCurr)
     => ! [B] :
          ( range_122_0(B)
         => ( v4674(VarCurr,B)
          <=> $false ) ) ) ).

fof(range_axiom_36,axiom,
    ! [B] :
      ( range_122_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B
        | bitIndex30 = B
        | bitIndex31 = B
        | bitIndex32 = B
        | bitIndex33 = B
        | bitIndex34 = B
        | bitIndex35 = B
        | bitIndex36 = B
        | bitIndex37 = B
        | bitIndex38 = B
        | bitIndex39 = B
        | bitIndex40 = B
        | bitIndex41 = B
        | bitIndex42 = B
        | bitIndex43 = B
        | bitIndex44 = B
        | bitIndex45 = B
        | bitIndex46 = B
        | bitIndex47 = B
        | bitIndex48 = B
        | bitIndex49 = B
        | bitIndex50 = B
        | bitIndex51 = B
        | bitIndex52 = B
        | bitIndex53 = B
        | bitIndex54 = B
        | bitIndex55 = B
        | bitIndex56 = B
        | bitIndex57 = B
        | bitIndex58 = B
        | bitIndex59 = B
        | bitIndex60 = B
        | bitIndex61 = B
        | bitIndex62 = B
        | bitIndex63 = B
        | bitIndex64 = B
        | bitIndex65 = B
        | bitIndex66 = B
        | bitIndex67 = B
        | bitIndex68 = B
        | bitIndex69 = B
        | bitIndex70 = B
        | bitIndex71 = B
        | bitIndex72 = B
        | bitIndex73 = B
        | bitIndex74 = B
        | bitIndex75 = B
        | bitIndex76 = B
        | bitIndex77 = B
        | bitIndex78 = B
        | bitIndex79 = B
        | bitIndex80 = B
        | bitIndex81 = B
        | bitIndex82 = B
        | bitIndex83 = B
        | bitIndex84 = B
        | bitIndex85 = B
        | bitIndex86 = B
        | bitIndex87 = B
        | bitIndex88 = B
        | bitIndex89 = B
        | bitIndex90 = B
        | bitIndex91 = B
        | bitIndex92 = B
        | bitIndex93 = B
        | bitIndex94 = B
        | bitIndex95 = B
        | bitIndex96 = B
        | bitIndex97 = B
        | bitIndex98 = B
        | bitIndex99 = B
        | bitIndex100 = B
        | bitIndex101 = B
        | bitIndex102 = B
        | bitIndex103 = B
        | bitIndex104 = B
        | bitIndex105 = B
        | bitIndex106 = B
        | bitIndex107 = B
        | bitIndex108 = B
        | bitIndex109 = B
        | bitIndex110 = B
        | bitIndex111 = B
        | bitIndex112 = B
        | bitIndex113 = B
        | bitIndex114 = B
        | bitIndex115 = B
        | bitIndex116 = B
        | bitIndex117 = B
        | bitIndex118 = B
        | bitIndex119 = B
        | bitIndex120 = B
        | bitIndex121 = B
        | bitIndex122 = B ) ) ).

fof(bitBlastConstant_1517,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex122) ).

fof(bitBlastConstant_1516,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex121) ).

fof(bitBlastConstant_1515,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex120) ).

fof(bitBlastConstant_1514,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex119) ).

fof(bitBlastConstant_1513,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex118) ).

fof(bitBlastConstant_1512,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex117) ).

fof(bitBlastConstant_1511,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex116) ).

fof(bitBlastConstant_1510,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex115) ).

fof(bitBlastConstant_1509,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex114) ).

fof(bitBlastConstant_1508,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex113) ).

fof(bitBlastConstant_1507,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex112) ).

fof(bitBlastConstant_1506,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex111) ).

fof(bitBlastConstant_1505,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex110) ).

fof(bitBlastConstant_1504,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex109) ).

fof(bitBlastConstant_1503,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex108) ).

fof(bitBlastConstant_1502,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex107) ).

fof(bitBlastConstant_1501,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex106) ).

fof(bitBlastConstant_1500,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex105) ).

fof(bitBlastConstant_1499,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex104) ).

fof(bitBlastConstant_1498,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex103) ).

fof(bitBlastConstant_1497,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex102) ).

fof(bitBlastConstant_1496,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex101) ).

fof(bitBlastConstant_1495,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex100) ).

fof(bitBlastConstant_1494,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex99) ).

fof(bitBlastConstant_1493,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex98) ).

fof(bitBlastConstant_1492,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex97) ).

fof(bitBlastConstant_1491,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex96) ).

fof(bitBlastConstant_1490,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex95) ).

fof(bitBlastConstant_1489,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex94) ).

fof(bitBlastConstant_1488,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex93) ).

fof(bitBlastConstant_1487,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex92) ).

fof(bitBlastConstant_1486,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex91) ).

fof(bitBlastConstant_1485,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex90) ).

fof(bitBlastConstant_1484,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex89) ).

fof(bitBlastConstant_1483,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex88) ).

fof(bitBlastConstant_1482,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex87) ).

fof(bitBlastConstant_1481,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex86) ).

fof(bitBlastConstant_1480,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex85) ).

fof(bitBlastConstant_1479,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex84) ).

fof(bitBlastConstant_1478,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex83) ).

fof(bitBlastConstant_1477,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex82) ).

fof(bitBlastConstant_1476,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex81) ).

fof(bitBlastConstant_1475,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex80) ).

fof(bitBlastConstant_1474,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex79) ).

fof(bitBlastConstant_1473,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex78) ).

fof(bitBlastConstant_1472,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex77) ).

fof(bitBlastConstant_1471,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex76) ).

fof(bitBlastConstant_1470,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex75) ).

fof(bitBlastConstant_1469,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex74) ).

fof(bitBlastConstant_1468,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex73) ).

fof(bitBlastConstant_1467,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex72) ).

fof(bitBlastConstant_1466,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex71) ).

fof(bitBlastConstant_1465,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex70) ).

fof(bitBlastConstant_1464,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex69) ).

fof(bitBlastConstant_1463,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex68) ).

fof(bitBlastConstant_1462,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex67) ).

fof(bitBlastConstant_1461,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex66) ).

fof(bitBlastConstant_1460,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex65) ).

fof(bitBlastConstant_1459,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex64) ).

fof(bitBlastConstant_1458,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex63) ).

fof(bitBlastConstant_1457,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex62) ).

fof(bitBlastConstant_1456,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex61) ).

fof(bitBlastConstant_1455,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex60) ).

fof(bitBlastConstant_1454,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex59) ).

fof(bitBlastConstant_1453,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex58) ).

fof(bitBlastConstant_1452,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex57) ).

fof(bitBlastConstant_1451,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex56) ).

fof(bitBlastConstant_1450,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex55) ).

fof(bitBlastConstant_1449,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex54) ).

fof(bitBlastConstant_1448,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex53) ).

fof(bitBlastConstant_1447,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex52) ).

fof(bitBlastConstant_1446,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex51) ).

fof(bitBlastConstant_1445,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex50) ).

fof(bitBlastConstant_1444,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex49) ).

fof(bitBlastConstant_1443,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex48) ).

fof(bitBlastConstant_1442,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex47) ).

fof(bitBlastConstant_1441,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex46) ).

fof(bitBlastConstant_1440,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex45) ).

fof(bitBlastConstant_1439,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex44) ).

fof(bitBlastConstant_1438,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex43) ).

fof(bitBlastConstant_1437,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex42) ).

fof(bitBlastConstant_1436,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex41) ).

fof(bitBlastConstant_1435,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex40) ).

fof(bitBlastConstant_1434,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex39) ).

fof(bitBlastConstant_1433,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex38) ).

fof(bitBlastConstant_1432,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex37) ).

fof(bitBlastConstant_1431,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex36) ).

fof(bitBlastConstant_1430,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex35) ).

fof(bitBlastConstant_1429,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex34) ).

fof(bitBlastConstant_1428,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex33) ).

fof(bitBlastConstant_1427,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex32) ).

fof(bitBlastConstant_1426,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex31) ).

fof(bitBlastConstant_1425,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex30) ).

fof(bitBlastConstant_1424,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex29) ).

fof(bitBlastConstant_1423,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex28) ).

fof(bitBlastConstant_1422,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex27) ).

fof(bitBlastConstant_1421,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex26) ).

fof(bitBlastConstant_1420,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex25) ).

fof(bitBlastConstant_1419,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex24) ).

fof(bitBlastConstant_1418,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex23) ).

fof(bitBlastConstant_1417,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex22) ).

fof(bitBlastConstant_1416,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex21) ).

fof(bitBlastConstant_1415,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex20) ).

fof(bitBlastConstant_1414,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex19) ).

fof(bitBlastConstant_1413,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex18) ).

fof(bitBlastConstant_1412,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex17) ).

fof(bitBlastConstant_1411,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex16) ).

fof(bitBlastConstant_1410,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex15) ).

fof(bitBlastConstant_1409,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex14) ).

fof(bitBlastConstant_1408,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex13) ).

fof(bitBlastConstant_1407,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex12) ).

fof(bitBlastConstant_1406,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex11) ).

fof(bitBlastConstant_1405,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex10) ).

fof(bitBlastConstant_1404,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex9) ).

fof(bitBlastConstant_1403,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex8) ).

fof(bitBlastConstant_1402,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex7) ).

fof(bitBlastConstant_1401,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex6) ).

fof(bitBlastConstant_1400,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex5) ).

fof(bitBlastConstant_1399,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex4) ).

fof(bitBlastConstant_1398,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex3) ).

fof(bitBlastConstant_1397,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex2) ).

fof(bitBlastConstant_1396,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex1) ).

fof(bitBlastConstant_1395,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex0) ).

fof(writeUnaryOperator_350,axiom,
    ! [VarCurr] :
      ( ~ v4677(VarCurr)
    <=> v4640(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_655,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4666(VarNext)
      <=> v4667(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_654,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4667(VarNext)
      <=> ( v4668(VarNext)
          & v4663(VarNext) ) ) ) ).

fof(writeUnaryOperator_349,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4668(VarNext)
      <=> v4670(VarNext) ) ) ).

fof(addAssignment_1394,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4670(VarNext)
      <=> v4663(VarCurr) ) ) ).

fof(addAssignment_1393,axiom,
    ! [VarCurr] :
      ( v4663(VarCurr)
    <=> v534(VarCurr) ) ).

fof(addAssignment_1392,axiom,
    ! [VarCurr,B] :
      ( range_122_116(B)
     => ( v4642(VarCurr,B)
      <=> v4652(VarCurr,B) ) ) ).

fof(range_axiom_35,axiom,
    ! [B] :
      ( range_122_116(B)
    <=> ( $false
        | bitIndex116 = B
        | bitIndex117 = B
        | bitIndex118 = B
        | bitIndex119 = B
        | bitIndex120 = B
        | bitIndex121 = B
        | bitIndex122 = B ) ) ).

fof(addAssignment_1391,axiom,
    ! [VarCurr,B] :
      ( range_6_0(B)
     => ( v4652(VarCurr,B)
      <=> v4661(VarCurr,B) ) ) ).

fof(addAssignment_1390,axiom,
    ! [VarCurr] :
      ( ( v4652(VarCurr,bitIndex68)
      <=> v4660(VarCurr,bitIndex61) )
      & ( v4652(VarCurr,bitIndex67)
      <=> v4660(VarCurr,bitIndex60) )
      & ( v4652(VarCurr,bitIndex66)
      <=> v4660(VarCurr,bitIndex59) )
      & ( v4652(VarCurr,bitIndex65)
      <=> v4660(VarCurr,bitIndex58) )
      & ( v4652(VarCurr,bitIndex64)
      <=> v4660(VarCurr,bitIndex57) )
      & ( v4652(VarCurr,bitIndex63)
      <=> v4660(VarCurr,bitIndex56) )
      & ( v4652(VarCurr,bitIndex62)
      <=> v4660(VarCurr,bitIndex55) )
      & ( v4652(VarCurr,bitIndex61)
      <=> v4660(VarCurr,bitIndex54) )
      & ( v4652(VarCurr,bitIndex60)
      <=> v4660(VarCurr,bitIndex53) )
      & ( v4652(VarCurr,bitIndex59)
      <=> v4660(VarCurr,bitIndex52) )
      & ( v4652(VarCurr,bitIndex58)
      <=> v4660(VarCurr,bitIndex51) )
      & ( v4652(VarCurr,bitIndex57)
      <=> v4660(VarCurr,bitIndex50) )
      & ( v4652(VarCurr,bitIndex56)
      <=> v4660(VarCurr,bitIndex49) )
      & ( v4652(VarCurr,bitIndex55)
      <=> v4660(VarCurr,bitIndex48) )
      & ( v4652(VarCurr,bitIndex54)
      <=> v4660(VarCurr,bitIndex47) )
      & ( v4652(VarCurr,bitIndex53)
      <=> v4660(VarCurr,bitIndex46) )
      & ( v4652(VarCurr,bitIndex52)
      <=> v4660(VarCurr,bitIndex45) )
      & ( v4652(VarCurr,bitIndex51)
      <=> v4660(VarCurr,bitIndex44) )
      & ( v4652(VarCurr,bitIndex50)
      <=> v4660(VarCurr,bitIndex43) )
      & ( v4652(VarCurr,bitIndex49)
      <=> v4660(VarCurr,bitIndex42) )
      & ( v4652(VarCurr,bitIndex48)
      <=> v4660(VarCurr,bitIndex41) )
      & ( v4652(VarCurr,bitIndex47)
      <=> v4660(VarCurr,bitIndex40) )
      & ( v4652(VarCurr,bitIndex46)
      <=> v4660(VarCurr,bitIndex39) )
      & ( v4652(VarCurr,bitIndex45)
      <=> v4660(VarCurr,bitIndex38) )
      & ( v4652(VarCurr,bitIndex44)
      <=> v4660(VarCurr,bitIndex37) )
      & ( v4652(VarCurr,bitIndex43)
      <=> v4660(VarCurr,bitIndex36) )
      & ( v4652(VarCurr,bitIndex42)
      <=> v4660(VarCurr,bitIndex35) )
      & ( v4652(VarCurr,bitIndex41)
      <=> v4660(VarCurr,bitIndex34) )
      & ( v4652(VarCurr,bitIndex40)
      <=> v4660(VarCurr,bitIndex33) )
      & ( v4652(VarCurr,bitIndex39)
      <=> v4660(VarCurr,bitIndex32) )
      & ( v4652(VarCurr,bitIndex38)
      <=> v4660(VarCurr,bitIndex31) )
      & ( v4652(VarCurr,bitIndex37)
      <=> v4660(VarCurr,bitIndex30) )
      & ( v4652(VarCurr,bitIndex36)
      <=> v4660(VarCurr,bitIndex29) )
      & ( v4652(VarCurr,bitIndex35)
      <=> v4660(VarCurr,bitIndex28) )
      & ( v4652(VarCurr,bitIndex34)
      <=> v4660(VarCurr,bitIndex27) )
      & ( v4652(VarCurr,bitIndex33)
      <=> v4660(VarCurr,bitIndex26) )
      & ( v4652(VarCurr,bitIndex32)
      <=> v4660(VarCurr,bitIndex25) )
      & ( v4652(VarCurr,bitIndex31)
      <=> v4660(VarCurr,bitIndex24) )
      & ( v4652(VarCurr,bitIndex30)
      <=> v4660(VarCurr,bitIndex23) )
      & ( v4652(VarCurr,bitIndex29)
      <=> v4660(VarCurr,bitIndex22) )
      & ( v4652(VarCurr,bitIndex28)
      <=> v4660(VarCurr,bitIndex21) )
      & ( v4652(VarCurr,bitIndex27)
      <=> v4660(VarCurr,bitIndex20) )
      & ( v4652(VarCurr,bitIndex26)
      <=> v4660(VarCurr,bitIndex19) )
      & ( v4652(VarCurr,bitIndex25)
      <=> v4660(VarCurr,bitIndex18) )
      & ( v4652(VarCurr,bitIndex24)
      <=> v4660(VarCurr,bitIndex17) )
      & ( v4652(VarCurr,bitIndex23)
      <=> v4660(VarCurr,bitIndex16) )
      & ( v4652(VarCurr,bitIndex22)
      <=> v4660(VarCurr,bitIndex15) )
      & ( v4652(VarCurr,bitIndex21)
      <=> v4660(VarCurr,bitIndex14) )
      & ( v4652(VarCurr,bitIndex20)
      <=> v4660(VarCurr,bitIndex13) )
      & ( v4652(VarCurr,bitIndex19)
      <=> v4660(VarCurr,bitIndex12) )
      & ( v4652(VarCurr,bitIndex18)
      <=> v4660(VarCurr,bitIndex11) )
      & ( v4652(VarCurr,bitIndex17)
      <=> v4660(VarCurr,bitIndex10) )
      & ( v4652(VarCurr,bitIndex16)
      <=> v4660(VarCurr,bitIndex9) )
      & ( v4652(VarCurr,bitIndex15)
      <=> v4660(VarCurr,bitIndex8) )
      & ( v4652(VarCurr,bitIndex14)
      <=> v4660(VarCurr,bitIndex7) )
      & ( v4652(VarCurr,bitIndex13)
      <=> v4660(VarCurr,bitIndex6) )
      & ( v4652(VarCurr,bitIndex12)
      <=> v4660(VarCurr,bitIndex5) )
      & ( v4652(VarCurr,bitIndex11)
      <=> v4660(VarCurr,bitIndex4) )
      & ( v4652(VarCurr,bitIndex10)
      <=> v4660(VarCurr,bitIndex3) )
      & ( v4652(VarCurr,bitIndex9)
      <=> v4660(VarCurr,bitIndex2) )
      & ( v4652(VarCurr,bitIndex8)
      <=> v4660(VarCurr,bitIndex1) )
      & ( v4652(VarCurr,bitIndex7)
      <=> v4660(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_1389,axiom,
    ! [VarCurr] :
      ( ( v4652(VarCurr,bitIndex72)
      <=> v4659(VarCurr,bitIndex3) )
      & ( v4652(VarCurr,bitIndex71)
      <=> v4659(VarCurr,bitIndex2) )
      & ( v4652(VarCurr,bitIndex70)
      <=> v4659(VarCurr,bitIndex1) )
      & ( v4652(VarCurr,bitIndex69)
      <=> v4659(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_1388,axiom,
    ! [VarCurr] :
      ( ( v4652(VarCurr,bitIndex76)
      <=> v4658(VarCurr,bitIndex3) )
      & ( v4652(VarCurr,bitIndex75)
      <=> v4658(VarCurr,bitIndex2) )
      & ( v4652(VarCurr,bitIndex74)
      <=> v4658(VarCurr,bitIndex1) )
      & ( v4652(VarCurr,bitIndex73)
      <=> v4658(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_1387,axiom,
    ! [VarCurr] :
      ( ( v4652(VarCurr,bitIndex84)
      <=> v4657(VarCurr,bitIndex7) )
      & ( v4652(VarCurr,bitIndex83)
      <=> v4657(VarCurr,bitIndex6) )
      & ( v4652(VarCurr,bitIndex82)
      <=> v4657(VarCurr,bitIndex5) )
      & ( v4652(VarCurr,bitIndex81)
      <=> v4657(VarCurr,bitIndex4) )
      & ( v4652(VarCurr,bitIndex80)
      <=> v4657(VarCurr,bitIndex3) )
      & ( v4652(VarCurr,bitIndex79)
      <=> v4657(VarCurr,bitIndex2) )
      & ( v4652(VarCurr,bitIndex78)
      <=> v4657(VarCurr,bitIndex1) )
      & ( v4652(VarCurr,bitIndex77)
      <=> v4657(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_1386,axiom,
    ! [VarCurr] :
      ( ( v4652(VarCurr,bitIndex100)
      <=> v4656(VarCurr,bitIndex15) )
      & ( v4652(VarCurr,bitIndex99)
      <=> v4656(VarCurr,bitIndex14) )
      & ( v4652(VarCurr,bitIndex98)
      <=> v4656(VarCurr,bitIndex13) )
      & ( v4652(VarCurr,bitIndex97)
      <=> v4656(VarCurr,bitIndex12) )
      & ( v4652(VarCurr,bitIndex96)
      <=> v4656(VarCurr,bitIndex11) )
      & ( v4652(VarCurr,bitIndex95)
      <=> v4656(VarCurr,bitIndex10) )
      & ( v4652(VarCurr,bitIndex94)
      <=> v4656(VarCurr,bitIndex9) )
      & ( v4652(VarCurr,bitIndex93)
      <=> v4656(VarCurr,bitIndex8) )
      & ( v4652(VarCurr,bitIndex92)
      <=> v4656(VarCurr,bitIndex7) )
      & ( v4652(VarCurr,bitIndex91)
      <=> v4656(VarCurr,bitIndex6) )
      & ( v4652(VarCurr,bitIndex90)
      <=> v4656(VarCurr,bitIndex5) )
      & ( v4652(VarCurr,bitIndex89)
      <=> v4656(VarCurr,bitIndex4) )
      & ( v4652(VarCurr,bitIndex88)
      <=> v4656(VarCurr,bitIndex3) )
      & ( v4652(VarCurr,bitIndex87)
      <=> v4656(VarCurr,bitIndex2) )
      & ( v4652(VarCurr,bitIndex86)
      <=> v4656(VarCurr,bitIndex1) )
      & ( v4652(VarCurr,bitIndex85)
      <=> v4656(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_1385,axiom,
    ! [VarCurr] :
      ( ( v4652(VarCurr,bitIndex110)
      <=> v4655(VarCurr,bitIndex9) )
      & ( v4652(VarCurr,bitIndex109)
      <=> v4655(VarCurr,bitIndex8) )
      & ( v4652(VarCurr,bitIndex108)
      <=> v4655(VarCurr,bitIndex7) )
      & ( v4652(VarCurr,bitIndex107)
      <=> v4655(VarCurr,bitIndex6) )
      & ( v4652(VarCurr,bitIndex106)
      <=> v4655(VarCurr,bitIndex5) )
      & ( v4652(VarCurr,bitIndex105)
      <=> v4655(VarCurr,bitIndex4) )
      & ( v4652(VarCurr,bitIndex104)
      <=> v4655(VarCurr,bitIndex3) )
      & ( v4652(VarCurr,bitIndex103)
      <=> v4655(VarCurr,bitIndex2) )
      & ( v4652(VarCurr,bitIndex102)
      <=> v4655(VarCurr,bitIndex1) )
      & ( v4652(VarCurr,bitIndex101)
      <=> v4655(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_1384,axiom,
    ! [VarCurr] :
      ( ( v4652(VarCurr,bitIndex112)
      <=> v4654(VarCurr,bitIndex1) )
      & ( v4652(VarCurr,bitIndex111)
      <=> v4654(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_1383,axiom,
    ! [VarCurr] :
      ( ( v4652(VarCurr,bitIndex115)
      <=> v4653(VarCurr,bitIndex2) )
      & ( v4652(VarCurr,bitIndex114)
      <=> v4653(VarCurr,bitIndex1) )
      & ( v4652(VarCurr,bitIndex113)
      <=> v4653(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_1382,axiom,
    ! [VarCurr] :
      ( ( v4652(VarCurr,bitIndex122)
      <=> v4644(VarCurr,bitIndex6) )
      & ( v4652(VarCurr,bitIndex121)
      <=> v4644(VarCurr,bitIndex5) )
      & ( v4652(VarCurr,bitIndex120)
      <=> v4644(VarCurr,bitIndex4) )
      & ( v4652(VarCurr,bitIndex119)
      <=> v4644(VarCurr,bitIndex3) )
      & ( v4652(VarCurr,bitIndex118)
      <=> v4644(VarCurr,bitIndex2) )
      & ( v4652(VarCurr,bitIndex117)
      <=> v4644(VarCurr,bitIndex1) )
      & ( v4652(VarCurr,bitIndex116)
      <=> v4644(VarCurr,bitIndex0) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_116,axiom,
    ! [VarCurr] :
      ( ~ v4648(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v4644(VarCurr,B)
          <=> v170(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_148,axiom,
    ! [VarCurr] :
      ( v4648(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v4644(VarCurr,B)
          <=> v4651(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_59,axiom,
    ! [VarCurr] :
      ( ~ v4649(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v4651(VarCurr,B)
          <=> b1111000(B) ) ) ) ).

fof(bitBlastConstant_1394,axiom,
    b1111000(bitIndex6) ).

fof(bitBlastConstant_1393,axiom,
    b1111000(bitIndex5) ).

fof(bitBlastConstant_1392,axiom,
    b1111000(bitIndex4) ).

fof(bitBlastConstant_1391,axiom,
    b1111000(bitIndex3) ).

fof(bitBlastConstant_1390,axiom,
    ~ b1111000(bitIndex2) ).

fof(bitBlastConstant_1389,axiom,
    ~ b1111000(bitIndex1) ).

fof(bitBlastConstant_1388,axiom,
    ~ b1111000(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges0_57,axiom,
    ! [VarCurr] :
      ( v4649(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v4651(VarCurr,B)
          <=> b1011000(B) ) ) ) ).

fof(bitBlastConstant_1387,axiom,
    b1011000(bitIndex6) ).

fof(bitBlastConstant_1386,axiom,
    ~ b1011000(bitIndex5) ).

fof(bitBlastConstant_1385,axiom,
    b1011000(bitIndex4) ).

fof(bitBlastConstant_1384,axiom,
    b1011000(bitIndex3) ).

fof(bitBlastConstant_1383,axiom,
    ~ b1011000(bitIndex2) ).

fof(bitBlastConstant_1382,axiom,
    ~ b1011000(bitIndex1) ).

fof(bitBlastConstant_1381,axiom,
    ~ b1011000(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_653,axiom,
    ! [VarCurr] :
      ( v4648(VarCurr)
    <=> ( v4649(VarCurr)
        | v4650(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_652,axiom,
    ! [VarCurr] :
      ( v4650(VarCurr)
    <=> ( v173(VarCurr)
        & v370(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_651,axiom,
    ! [VarCurr] :
      ( v4649(VarCurr)
    <=> ( v101(VarCurr)
        & v355(VarCurr) ) ) ).

fof(addAssignment_1381,axiom,
    ! [VarCurr] :
      ( v4640(VarCurr)
    <=> v67(VarCurr) ) ).

fof(addAssignment_1380,axiom,
    ! [VarCurr] :
      ( v4574(VarCurr)
    <=> v4576(VarCurr,bitIndex2) ) ).

fof(addAssignment_1379,axiom,
    ! [VarCurr] :
      ( v4576(VarCurr,bitIndex2)
    <=> v4591(VarCurr,bitIndex2) ) ).

fof(addAssignment_1378,axiom,
    ! [VarNext] :
      ( v4535(VarNext,bitIndex1)
    <=> v4616(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_58,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4617(VarNext)
       => ! [B] :
            ( range_8_0(B)
           => ( v4616(VarNext,B)
            <=> v4535(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_59,axiom,
    ! [VarNext] :
      ( v4617(VarNext)
     => ! [B] :
          ( range_8_0(B)
         => ( v4616(VarNext,B)
          <=> v4588(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_650,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4617(VarNext)
      <=> v4618(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_649,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4618(VarNext)
      <=> ( v4620(VarNext)
          & v4515(VarNext) ) ) ) ).

fof(writeUnaryOperator_348,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4620(VarNext)
      <=> v4522(VarNext) ) ) ).

fof(addAssignment_1377,axiom,
    ! [VarCurr] :
      ( v4576(VarCurr,bitIndex1)
    <=> v4591(VarCurr,bitIndex1) ) ).

fof(addAssignment_1376,axiom,
    ! [VarNext] :
      ( v4535(VarNext,bitIndex0)
    <=> v4608(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionEqualRanges1_57,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4609(VarNext)
       => ! [B] :
            ( range_8_0(B)
           => ( v4608(VarNext,B)
            <=> v4535(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_58,axiom,
    ! [VarNext] :
      ( v4609(VarNext)
     => ! [B] :
          ( range_8_0(B)
         => ( v4608(VarNext,B)
          <=> v4588(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_648,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4609(VarNext)
      <=> v4610(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_647,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4610(VarNext)
      <=> ( v4612(VarNext)
          & v4515(VarNext) ) ) ) ).

fof(writeUnaryOperator_347,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4612(VarNext)
      <=> v4522(VarNext) ) ) ).

fof(addAssignment_1375,axiom,
    ! [VarCurr] :
      ( v4576(VarCurr,bitIndex0)
    <=> v4591(VarCurr,bitIndex0) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_115,axiom,
    ! [VarCurr] :
      ( ~ v4592(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v4591(VarCurr,B)
          <=> v4594(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_147,axiom,
    ! [VarCurr] :
      ( v4592(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v4591(VarCurr,B)
          <=> v4593(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_22,axiom,
    ! [VarCurr] :
      ( ( ~ v4595(VarCurr)
        & ~ v4597(VarCurr)
        & ~ v4601(VarCurr) )
     => ! [B] :
          ( range_8_0(B)
         => ( v4594(VarCurr,B)
          <=> v4535(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_35,axiom,
    ! [VarCurr] :
      ( v4601(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v4594(VarCurr,B)
          <=> v4603(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_58,axiom,
    ! [VarCurr] :
      ( v4597(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v4594(VarCurr,B)
          <=> v4599(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_56,axiom,
    ! [VarCurr] :
      ( v4595(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v4594(VarCurr,B)
          <=> v4535(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_304,axiom,
    ! [VarCurr] :
      ( v4605(VarCurr)
    <=> ( ( v4606(VarCurr,bitIndex1)
        <=> $true )
        & ( v4606(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1374,axiom,
    ! [VarCurr] :
      ( v4606(VarCurr,bitIndex0)
    <=> v554(VarCurr) ) ).

fof(addAssignment_1373,axiom,
    ! [VarCurr] :
      ( v4606(VarCurr,bitIndex1)
    <=> v47(VarCurr) ) ).

fof(addAssignment_1372,axiom,
    ! [VarCurr] :
      ( v4603(VarCurr,bitIndex0)
    <=> $false ) ).

fof(addAssignment_1371,axiom,
    ! [VarCurr] :
      ( ( v4603(VarCurr,bitIndex8)
      <=> v4535(VarCurr,bitIndex7) )
      & ( v4603(VarCurr,bitIndex7)
      <=> v4535(VarCurr,bitIndex6) )
      & ( v4603(VarCurr,bitIndex6)
      <=> v4535(VarCurr,bitIndex5) )
      & ( v4603(VarCurr,bitIndex5)
      <=> v4535(VarCurr,bitIndex4) )
      & ( v4603(VarCurr,bitIndex4)
      <=> v4535(VarCurr,bitIndex3) )
      & ( v4603(VarCurr,bitIndex3)
      <=> v4535(VarCurr,bitIndex2) )
      & ( v4603(VarCurr,bitIndex2)
      <=> v4535(VarCurr,bitIndex1) )
      & ( v4603(VarCurr,bitIndex1)
      <=> v4535(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_303,axiom,
    ! [VarCurr] :
      ( v4601(VarCurr)
    <=> ( ( v4602(VarCurr,bitIndex1)
        <=> $true )
        & ( v4602(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1370,axiom,
    ! [VarCurr] :
      ( v4602(VarCurr,bitIndex0)
    <=> v554(VarCurr) ) ).

fof(addAssignment_1369,axiom,
    ! [VarCurr] :
      ( v4602(VarCurr,bitIndex1)
    <=> v47(VarCurr) ) ).

fof(addAssignment_1368,axiom,
    ! [VarCurr] :
      ( ( v4599(VarCurr,bitIndex7)
      <=> v4535(VarCurr,bitIndex8) )
      & ( v4599(VarCurr,bitIndex6)
      <=> v4535(VarCurr,bitIndex7) )
      & ( v4599(VarCurr,bitIndex5)
      <=> v4535(VarCurr,bitIndex6) )
      & ( v4599(VarCurr,bitIndex4)
      <=> v4535(VarCurr,bitIndex5) )
      & ( v4599(VarCurr,bitIndex3)
      <=> v4535(VarCurr,bitIndex4) )
      & ( v4599(VarCurr,bitIndex2)
      <=> v4535(VarCurr,bitIndex3) )
      & ( v4599(VarCurr,bitIndex1)
      <=> v4535(VarCurr,bitIndex2) )
      & ( v4599(VarCurr,bitIndex0)
      <=> v4535(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_1367,axiom,
    ! [VarCurr] :
      ( v4599(VarCurr,bitIndex8)
    <=> $false ) ).

fof(addBitVectorEqualityBitBlasted_302,axiom,
    ! [VarCurr] :
      ( v4597(VarCurr)
    <=> ( ( v4598(VarCurr,bitIndex1)
        <=> $false )
        & ( v4598(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1366,axiom,
    ! [VarCurr] :
      ( v4598(VarCurr,bitIndex0)
    <=> v554(VarCurr) ) ).

fof(addAssignment_1365,axiom,
    ! [VarCurr] :
      ( v4598(VarCurr,bitIndex1)
    <=> v47(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_301,axiom,
    ! [VarCurr] :
      ( v4595(VarCurr)
    <=> ( ( v4596(VarCurr,bitIndex1)
        <=> $false )
        & ( v4596(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1364,axiom,
    ! [VarCurr] :
      ( v4596(VarCurr,bitIndex0)
    <=> v554(VarCurr) ) ).

fof(addAssignment_1363,axiom,
    ! [VarCurr] :
      ( v4596(VarCurr,bitIndex1)
    <=> v47(VarCurr) ) ).

fof(addAssignment_1362,axiom,
    ! [VarCurr] :
      ( v4593(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_1361,axiom,
    ! [VarCurr,B] :
      ( range_8_1(B)
     => ( v4593(VarCurr,B)
      <=> v4533(VarCurr,B) ) ) ).

fof(writeUnaryOperator_346,axiom,
    ! [VarCurr] :
      ( ~ v4592(VarCurr)
    <=> v43(VarCurr) ) ).

fof(addAssignment_1360,axiom,
    ! [VarCurr] :
      ( v4533(VarCurr,bitIndex1)
    <=> v4534(VarCurr,bitIndex1) ) ).

fof(addAssignment_1359,axiom,
    ! [VarCurr] :
      ( v4533(VarCurr,bitIndex2)
    <=> v4534(VarCurr,bitIndex2) ) ).

fof(addAssignment_1358,axiom,
    ! [VarNext] :
      ( v4535(VarNext,bitIndex2)
    <=> v4579(VarNext,bitIndex2) ) ).

fof(addCaseBooleanConditionEqualRanges1_56,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4580(VarNext)
       => ! [B] :
            ( range_8_0(B)
           => ( v4579(VarNext,B)
            <=> v4535(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_57,axiom,
    ! [VarNext] :
      ( v4580(VarNext)
     => ! [B] :
          ( range_8_0(B)
         => ( v4579(VarNext,B)
          <=> v4588(VarNext,B) ) ) ) ).

fof(addAssignment_1357,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_8_0(B)
         => ( v4588(VarNext,B)
          <=> v4586(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_114,axiom,
    ! [VarCurr] :
      ( ~ v4529(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v4586(VarCurr,B)
          <=> v4576(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_146,axiom,
    ! [VarCurr] :
      ( v4529(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v4586(VarCurr,B)
          <=> b000000001(B) ) ) ) ).

fof(bitBlastConstant_1380,axiom,
    ~ b000000001(bitIndex8) ).

fof(bitBlastConstant_1379,axiom,
    ~ b000000001(bitIndex7) ).

fof(bitBlastConstant_1378,axiom,
    ~ b000000001(bitIndex6) ).

fof(bitBlastConstant_1377,axiom,
    ~ b000000001(bitIndex5) ).

fof(bitBlastConstant_1376,axiom,
    ~ b000000001(bitIndex4) ).

fof(bitBlastConstant_1375,axiom,
    ~ b000000001(bitIndex3) ).

fof(bitBlastConstant_1374,axiom,
    ~ b000000001(bitIndex2) ).

fof(bitBlastConstant_1373,axiom,
    ~ b000000001(bitIndex1) ).

fof(bitBlastConstant_1372,axiom,
    b000000001(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_646,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4580(VarNext)
      <=> v4581(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_645,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4581(VarNext)
      <=> ( v4583(VarNext)
          & v4515(VarNext) ) ) ) ).

fof(writeUnaryOperator_345,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4583(VarNext)
      <=> v4522(VarNext) ) ) ).

fof(addAssignment_1356,axiom,
    ! [VarCurr] :
      ( v39(VarCurr)
    <=> v41(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_55,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4541(VarNext)
       => ( v41(VarNext)
        <=> v41(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_56,axiom,
    ! [VarNext] :
      ( v4541(VarNext)
     => ( v41(VarNext)
      <=> v4559(VarNext) ) ) ).

fof(addAssignment_1355,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4559(VarNext)
      <=> v4557(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_113,axiom,
    ! [VarCurr] :
      ( ~ v4556(VarCurr)
     => ( v4557(VarCurr)
      <=> v4560(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_145,axiom,
    ! [VarCurr] :
      ( v4556(VarCurr)
     => ( v4557(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_112,axiom,
    ! [VarCurr] :
      ( ~ v47(VarCurr)
     => ( v4560(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_144,axiom,
    ! [VarCurr] :
      ( v47(VarCurr)
     => ( v4560(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_644,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4541(VarNext)
      <=> ( v4542(VarNext)
          & v4549(VarNext) ) ) ) ).

fof(addAssignment_1354,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4549(VarNext)
      <=> v4547(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_643,axiom,
    ! [VarCurr] :
      ( v4547(VarCurr)
    <=> ( v4550(VarCurr)
        | v4556(VarCurr) ) ) ).

fof(writeUnaryOperator_344,axiom,
    ! [VarCurr] :
      ( ~ v4556(VarCurr)
    <=> v43(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_642,axiom,
    ! [VarCurr] :
      ( v4550(VarCurr)
    <=> ( v4551(VarCurr)
        | v47(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_641,axiom,
    ! [VarCurr] :
      ( v4551(VarCurr)
    <=> ( v4552(VarCurr)
        & v4555(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_300,axiom,
    ! [VarCurr] :
      ( v4555(VarCurr)
    <=> ( v4533(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_640,axiom,
    ! [VarCurr] :
      ( v4552(VarCurr)
    <=> ( v4553(VarCurr)
        & v4554(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_299,axiom,
    ! [VarCurr] :
      ( v4554(VarCurr)
    <=> ( v480(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_298,axiom,
    ! [VarCurr] :
      ( v4553(VarCurr)
    <=> ( v554(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_639,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4542(VarNext)
      <=> ( v4543(VarNext)
          & v4515(VarNext) ) ) ) ).

fof(writeUnaryOperator_343,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4543(VarNext)
      <=> v4522(VarNext) ) ) ).

fof(addAssignment_1353,axiom,
    ! [VarCurr] :
      ( v4533(VarCurr,bitIndex0)
    <=> v4534(VarCurr,bitIndex0) ) ).

fof(addAssignment_1352,axiom,
    ! [VarCurr] :
      ( v4534(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_1351,axiom,
    ! [VarCurr,B] :
      ( range_8_1(B)
     => ( v4534(VarCurr,B)
      <=> v4535(VarCurr,B) ) ) ).

fof(range_axiom_34,axiom,
    ! [B] :
      ( range_8_1(B)
    <=> ( $false
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B ) ) ).

fof(addAssignmentInitValue_257,axiom,
    ~ v4535(constB0,bitIndex3) ).

fof(addAssignmentInitValue_256,axiom,
    ~ v4535(constB0,bitIndex2) ).

fof(addAssignmentInitValue_255,axiom,
    ~ v4535(constB0,bitIndex1) ).

fof(addAssignmentInitValue_254,axiom,
    v4535(constB0,bitIndex0) ).

fof(bitBlastConstant_1371,axiom,
    ~ bxxxxx0001(bitIndex3) ).

fof(bitBlastConstant_1370,axiom,
    ~ bxxxxx0001(bitIndex2) ).

fof(bitBlastConstant_1369,axiom,
    ~ bxxxxx0001(bitIndex1) ).

fof(bitBlastConstant_1368,axiom,
    bxxxxx0001(bitIndex0) ).

fof(addAssignment_1350,axiom,
    ! [VarNext] :
      ( v480(VarNext,bitIndex1)
    <=> v4517(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_54,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4518(VarNext)
       => ! [B] :
            ( range_5_0(B)
           => ( v4517(VarNext,B)
            <=> v480(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_55,axiom,
    ! [VarNext] :
      ( v4518(VarNext)
     => ! [B] :
          ( range_5_0(B)
         => ( v4517(VarNext,B)
          <=> v4528(VarNext,B) ) ) ) ).

fof(addAssignment_1349,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_5_0(B)
         => ( v4528(VarNext,B)
          <=> v4526(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_111,axiom,
    ! [VarCurr] :
      ( ~ v4529(VarCurr)
     => ! [B] :
          ( range_5_0(B)
         => ( v4526(VarCurr,B)
          <=> v4495(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_143,axiom,
    ! [VarCurr] :
      ( v4529(VarCurr)
     => ! [B] :
          ( range_5_0(B)
         => ( v4526(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_342,axiom,
    ! [VarCurr] :
      ( ~ v4529(VarCurr)
    <=> v43(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_638,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4518(VarNext)
      <=> v4519(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_637,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4519(VarNext)
      <=> ( v4520(VarNext)
          & v4515(VarNext) ) ) ) ).

fof(writeUnaryOperator_341,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4520(VarNext)
      <=> v4522(VarNext) ) ) ).

fof(addAssignment_1348,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4522(VarNext)
      <=> v4515(VarCurr) ) ) ).

fof(addAssignment_1347,axiom,
    ! [VarCurr] :
      ( v4515(VarCurr)
    <=> v4326(VarCurr) ) ).

fof(addAssignment_1346,axiom,
    ! [VarCurr] :
      ( v4495(VarCurr,bitIndex1)
    <=> v4500(VarCurr,bitIndex1) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_110,axiom,
    ! [VarCurr] :
      ( ~ v4501(VarCurr)
     => ! [B] :
          ( range_5_0(B)
         => ( v4500(VarCurr,B)
          <=> v4502(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_142,axiom,
    ! [VarCurr] :
      ( v4501(VarCurr)
     => ! [B] :
          ( range_5_0(B)
         => ( v4500(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_21,axiom,
    ! [VarCurr] :
      ( ( ~ v4503(VarCurr)
        & ~ v4505(VarCurr)
        & ~ v4509(VarCurr) )
     => ! [B] :
          ( range_5_0(B)
         => ( v4502(VarCurr,B)
          <=> v480(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_34,axiom,
    ! [VarCurr] :
      ( v4509(VarCurr)
     => ! [B] :
          ( range_5_0(B)
         => ( v4502(VarCurr,B)
          <=> v4511(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_57,axiom,
    ! [VarCurr] :
      ( v4505(VarCurr)
     => ! [B] :
          ( range_5_0(B)
         => ( v4502(VarCurr,B)
          <=> v4507(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_55,axiom,
    ! [VarCurr] :
      ( v4503(VarCurr)
     => ! [B] :
          ( range_5_0(B)
         => ( v4502(VarCurr,B)
          <=> v480(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_297,axiom,
    ! [VarCurr] :
      ( v4512(VarCurr)
    <=> ( ( v4513(VarCurr,bitIndex1)
        <=> $true )
        & ( v4513(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1345,axiom,
    ! [VarCurr] :
      ( v4513(VarCurr,bitIndex0)
    <=> v554(VarCurr) ) ).

fof(addAssignment_1344,axiom,
    ! [VarCurr] :
      ( v4513(VarCurr,bitIndex1)
    <=> v47(VarCurr) ) ).

fof(addAssignment_1343,axiom,
    ! [VarCurr] :
      ( v4511(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_1342,axiom,
    ! [VarCurr,B] :
      ( range_5_1(B)
     => ( v4511(VarCurr,B)
      <=> v4497(VarCurr,B) ) ) ).

fof(range_axiom_33,axiom,
    ! [B] :
      ( range_5_1(B)
    <=> ( $false
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B ) ) ).

fof(addBitVectorEqualityBitBlasted_296,axiom,
    ! [VarCurr] :
      ( v4509(VarCurr)
    <=> ( ( v4510(VarCurr,bitIndex1)
        <=> $true )
        & ( v4510(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1341,axiom,
    ! [VarCurr] :
      ( v4510(VarCurr,bitIndex0)
    <=> v554(VarCurr) ) ).

fof(addAssignment_1340,axiom,
    ! [VarCurr] :
      ( v4510(VarCurr,bitIndex1)
    <=> v47(VarCurr) ) ).

fof(addAssignment_1339,axiom,
    ! [VarCurr] :
      ( ( v4507(VarCurr,bitIndex4)
      <=> v480(VarCurr,bitIndex5) )
      & ( v4507(VarCurr,bitIndex3)
      <=> v480(VarCurr,bitIndex4) )
      & ( v4507(VarCurr,bitIndex2)
      <=> v480(VarCurr,bitIndex3) )
      & ( v4507(VarCurr,bitIndex1)
      <=> v480(VarCurr,bitIndex2) )
      & ( v4507(VarCurr,bitIndex0)
      <=> v480(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_1338,axiom,
    ! [VarCurr] :
      ( v4507(VarCurr,bitIndex5)
    <=> $false ) ).

fof(addBitVectorEqualityBitBlasted_295,axiom,
    ! [VarCurr] :
      ( v4505(VarCurr)
    <=> ( ( v4506(VarCurr,bitIndex1)
        <=> $false )
        & ( v4506(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1337,axiom,
    ! [VarCurr] :
      ( v4506(VarCurr,bitIndex0)
    <=> v554(VarCurr) ) ).

fof(addAssignment_1336,axiom,
    ! [VarCurr] :
      ( v4506(VarCurr,bitIndex1)
    <=> v47(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_294,axiom,
    ! [VarCurr] :
      ( v4503(VarCurr)
    <=> ( ( v4504(VarCurr,bitIndex1)
        <=> $false )
        & ( v4504(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1335,axiom,
    ! [VarCurr] :
      ( v4504(VarCurr,bitIndex0)
    <=> v554(VarCurr) ) ).

fof(addAssignment_1334,axiom,
    ! [VarCurr] :
      ( v4504(VarCurr,bitIndex1)
    <=> v47(VarCurr) ) ).

fof(writeUnaryOperator_340,axiom,
    ! [VarCurr] :
      ( ~ v4501(VarCurr)
    <=> v43(VarCurr) ) ).

fof(addAssignment_1333,axiom,
    ! [VarCurr] :
      ( v4497(VarCurr,bitIndex1)
    <=> v4498(VarCurr,bitIndex1) ) ).

fof(addAssignment_1332,axiom,
    ! [VarCurr] :
      ( v4498(VarCurr,bitIndex0)
    <=> $false ) ).

fof(addAssignment_1331,axiom,
    ! [VarCurr] :
      ( ( v4498(VarCurr,bitIndex5)
      <=> v480(VarCurr,bitIndex4) )
      & ( v4498(VarCurr,bitIndex4)
      <=> v480(VarCurr,bitIndex3) )
      & ( v4498(VarCurr,bitIndex3)
      <=> v480(VarCurr,bitIndex2) )
      & ( v4498(VarCurr,bitIndex2)
      <=> v480(VarCurr,bitIndex1) )
      & ( v4498(VarCurr,bitIndex1)
      <=> v480(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_1330,axiom,
    ! [VarCurr] :
      ( v554(VarCurr)
    <=> v556(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_109,axiom,
    ! [VarCurr] :
      ( ~ v4481(VarCurr)
     => ( v556(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_141,axiom,
    ! [VarCurr] :
      ( v4481(VarCurr)
     => ( v556(VarCurr)
      <=> v4490(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_56,axiom,
    ! [VarCurr] :
      ( ~ v4483(VarCurr)
     => ( v4490(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_54,axiom,
    ! [VarCurr] :
      ( v4483(VarCurr)
     => ( v4490(VarCurr)
      <=> v4491(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_33,axiom,
    ! [VarCurr] :
      ( ( ~ v4486(VarCurr)
        & ~ v4270(VarCurr) )
     => ( v4491(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_55,axiom,
    ! [VarCurr] :
      ( v4270(VarCurr)
     => ( v4491(VarCurr)
      <=> v4493(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_53,axiom,
    ! [VarCurr] :
      ( v4486(VarCurr)
     => ( v4491(VarCurr)
      <=> v4492(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_108,axiom,
    ! [VarCurr] :
      ( ~ v666(VarCurr)
     => ( v4493(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_140,axiom,
    ! [VarCurr] :
      ( v666(VarCurr)
     => ( v4493(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_107,axiom,
    ! [VarCurr] :
      ( ~ v4421(VarCurr)
     => ( v4492(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_139,axiom,
    ! [VarCurr] :
      ( v4421(VarCurr)
     => ( v4492(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_636,axiom,
    ! [VarCurr] :
      ( v4481(VarCurr)
    <=> ( v4482(VarCurr)
        & v4489(VarCurr) ) ) ).

fof(writeUnaryOperator_339,axiom,
    ! [VarCurr] :
      ( ~ v4489(VarCurr)
    <=> v4274(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_635,axiom,
    ! [VarCurr] :
      ( v4482(VarCurr)
    <=> ( v4483(VarCurr)
        | v4488(VarCurr) ) ) ).

fof(writeUnaryOperator_338,axiom,
    ! [VarCurr] :
      ( ~ v4488(VarCurr)
    <=> v4271(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_634,axiom,
    ! [VarCurr] :
      ( v4483(VarCurr)
    <=> ( v4484(VarCurr)
        & v4271(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_633,axiom,
    ! [VarCurr] :
      ( v4484(VarCurr)
    <=> ( v4485(VarCurr)
        | v4487(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_293,axiom,
    ! [VarCurr] :
      ( v4487(VarCurr)
    <=> ( ( v37(VarCurr,bitIndex1)
        <=> $true )
        & ( v37(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_632,axiom,
    ! [VarCurr] :
      ( v4485(VarCurr)
    <=> ( v4486(VarCurr)
        | v4270(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_292,axiom,
    ! [VarCurr] :
      ( v4486(VarCurr)
    <=> ( ( v37(VarCurr,bitIndex1)
        <=> $false )
        & ( v37(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorShiftedRanges_262,axiom,
    ! [VarCurr] :
      ( v4421(VarCurr)
    <=> ( v4458(VarCurr)
        | v4423(VarCurr,bitIndex2) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_53,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4466(VarNext)
       => ! [B] :
            ( range_2_0(B)
           => ( v4423(VarNext,B)
            <=> v4423(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_54,axiom,
    ! [VarNext] :
      ( v4466(VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v4423(VarNext,B)
          <=> v4474(VarNext,B) ) ) ) ).

fof(addAssignment_1329,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v4474(VarNext,B)
          <=> v4472(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_106,axiom,
    ! [VarCurr] :
      ( ~ v4475(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v4472(VarCurr,B)
          <=> v4425(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_138,axiom,
    ! [VarCurr] :
      ( v4475(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v4472(VarCurr,B)
          <=> b100(B) ) ) ) ).

fof(writeUnaryOperator_337,axiom,
    ! [VarCurr] :
      ( ~ v4475(VarCurr)
    <=> v45(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_631,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4466(VarNext)
      <=> v4467(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_630,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4467(VarNext)
      <=> ( v4468(VarNext)
          & v4326(VarNext) ) ) ) ).

fof(writeUnaryOperator_336,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4468(VarNext)
      <=> v4333(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_32,axiom,
    ! [VarCurr] :
      ( ( ~ v4431(VarCurr)
        & ~ v4447(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v4425(VarCurr,B)
          <=> v4423(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_54,axiom,
    ! [VarCurr] :
      ( v4447(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v4425(VarCurr,B)
          <=> v4449(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_52,axiom,
    ! [VarCurr] :
      ( v4431(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v4425(VarCurr,B)
          <=> v4433(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_629,axiom,
    ! [VarCurr] :
      ( v4459(VarCurr)
    <=> ( v4460(VarCurr)
        | v4462(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_291,axiom,
    ! [VarCurr] :
      ( v4462(VarCurr)
    <=> ( ( v4463(VarCurr,bitIndex1)
        <=> $true )
        & ( v4463(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1328,axiom,
    ! [VarCurr] :
      ( v4463(VarCurr,bitIndex0)
    <=> v35(VarCurr) ) ).

fof(addAssignment_1327,axiom,
    ! [VarCurr] :
      ( v4463(VarCurr,bitIndex1)
    <=> v4427(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_290,axiom,
    ! [VarCurr] :
      ( v4460(VarCurr)
    <=> ( ( v4461(VarCurr,bitIndex1)
        <=> $false )
        & ( v4461(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1326,axiom,
    ! [VarCurr] :
      ( v4461(VarCurr,bitIndex0)
    <=> v35(VarCurr) ) ).

fof(addAssignment_1325,axiom,
    ! [VarCurr] :
      ( v4461(VarCurr,bitIndex1)
    <=> v4427(VarCurr) ) ).

fof(addAssignment_1324,axiom,
    ! [VarCurr] :
      ( v4449(VarCurr,bitIndex0)
    <=> v4445(VarCurr) ) ).

fof(addAssignment_1323,axiom,
    ! [VarCurr] :
      ( v4449(VarCurr,bitIndex1)
    <=> v4456(VarCurr) ) ).

fof(addAssignment_1322,axiom,
    ! [VarCurr] :
      ( v4449(VarCurr,bitIndex2)
    <=> v4451(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_628,axiom,
    ! [VarCurr] :
      ( v4456(VarCurr)
    <=> ( v4457(VarCurr)
        & v4458(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_261,axiom,
    ! [VarCurr] :
      ( v4458(VarCurr)
    <=> ( v4423(VarCurr,bitIndex0)
        | v4423(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_627,axiom,
    ! [VarCurr] :
      ( v4457(VarCurr)
    <=> ( v4445(VarCurr)
        | v4440(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_626,axiom,
    ! [VarCurr] :
      ( v4451(VarCurr)
    <=> ( v4452(VarCurr)
        & v4455(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_260,axiom,
    ! [VarCurr] :
      ( v4455(VarCurr)
    <=> ( v4423(VarCurr,bitIndex2)
        | v4454(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_625,axiom,
    ! [VarCurr] :
      ( v4452(VarCurr)
    <=> ( v4442(VarCurr)
        | v4453(VarCurr) ) ) ).

fof(writeUnaryOperator_335,axiom,
    ! [VarCurr] :
      ( ~ v4453(VarCurr)
    <=> v4454(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_259,axiom,
    ! [VarCurr] :
      ( v4454(VarCurr)
    <=> ( v4423(VarCurr,bitIndex0)
        & v4423(VarCurr,bitIndex1) ) ) ).

fof(addBitVectorEqualityBitBlasted_289,axiom,
    ! [VarCurr] :
      ( v4447(VarCurr)
    <=> ( ( v4448(VarCurr,bitIndex1)
        <=> $true )
        & ( v4448(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1321,axiom,
    ! [VarCurr] :
      ( v4448(VarCurr,bitIndex0)
    <=> v35(VarCurr) ) ).

fof(addAssignment_1320,axiom,
    ! [VarCurr] :
      ( v4448(VarCurr,bitIndex1)
    <=> v4427(VarCurr) ) ).

fof(addAssignment_1319,axiom,
    ! [VarCurr] :
      ( v4433(VarCurr,bitIndex0)
    <=> v4445(VarCurr) ) ).

fof(addAssignment_1318,axiom,
    ! [VarCurr] :
      ( v4433(VarCurr,bitIndex1)
    <=> v4443(VarCurr) ) ).

fof(addAssignment_1317,axiom,
    ! [VarCurr] :
      ( v4433(VarCurr,bitIndex2)
    <=> v4435(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_624,axiom,
    ! [VarCurr] :
      ( v4443(VarCurr)
    <=> ( v4444(VarCurr)
        & v4446(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_623,axiom,
    ! [VarCurr] :
      ( v4446(VarCurr)
    <=> ( v4423(VarCurr,bitIndex0)
        | v4440(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_258,axiom,
    ! [VarCurr] :
      ( v4444(VarCurr)
    <=> ( v4445(VarCurr)
        | v4423(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_334,axiom,
    ! [VarCurr] :
      ( ~ v4445(VarCurr)
    <=> v4423(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_622,axiom,
    ! [VarCurr] :
      ( v4435(VarCurr)
    <=> ( v4436(VarCurr)
        & v4441(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_621,axiom,
    ! [VarCurr] :
      ( v4441(VarCurr)
    <=> ( v4438(VarCurr)
        | v4442(VarCurr) ) ) ).

fof(writeUnaryOperator_333,axiom,
    ! [VarCurr] :
      ( ~ v4442(VarCurr)
    <=> v4423(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges_257,axiom,
    ! [VarCurr] :
      ( v4436(VarCurr)
    <=> ( v4437(VarCurr)
        | v4423(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_332,axiom,
    ! [VarCurr] :
      ( ~ v4437(VarCurr)
    <=> v4438(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_256,axiom,
    ! [VarCurr] :
      ( v4438(VarCurr)
    <=> ( v4423(VarCurr,bitIndex1)
        | v4439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_620,axiom,
    ! [VarCurr] :
      ( v4439(VarCurr)
    <=> ( v4423(VarCurr,bitIndex0)
        & v4440(VarCurr) ) ) ).

fof(writeUnaryOperator_331,axiom,
    ! [VarCurr] :
      ( ~ v4440(VarCurr)
    <=> v4423(VarCurr,bitIndex1) ) ).

fof(addAssignmentInitValue_253,axiom,
    v4423(constB0,bitIndex2) ).

fof(addAssignmentInitValue_252,axiom,
    ~ v4423(constB0,bitIndex1) ).

fof(addAssignmentInitValue_251,axiom,
    ~ v4423(constB0,bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_288,axiom,
    ! [VarCurr] :
      ( v4431(VarCurr)
    <=> ( ( v4432(VarCurr,bitIndex1)
        <=> $false )
        & ( v4432(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1316,axiom,
    ! [VarCurr] :
      ( v4432(VarCurr,bitIndex0)
    <=> v35(VarCurr) ) ).

fof(addAssignment_1315,axiom,
    ! [VarCurr] :
      ( v4432(VarCurr,bitIndex1)
    <=> v4427(VarCurr) ) ).

fof(addAssignment_1314,axiom,
    ! [VarCurr] :
      ( v4427(VarCurr)
    <=> v4429(VarCurr) ) ).

fof(addAssignment_1313,axiom,
    ! [VarCurr] :
      ( v4429(VarCurr)
    <=> v2157(VarCurr) ) ).

fof(addAssignment_1312,axiom,
    ! [VarCurr] :
      ( v560(VarCurr)
    <=> v562(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_287,axiom,
    ! [VarCurr] :
      ( v562(VarCurr)
    <=> ( ( v564(VarCurr,bitIndex2)
        <=> $false )
        & ( v564(VarCurr,bitIndex1)
        <=> $false )
        & ( v564(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_52,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4405(VarNext)
       => ! [B] :
            ( range_2_0(B)
           => ( v564(VarNext,B)
            <=> v564(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_53,axiom,
    ! [VarNext] :
      ( v4405(VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v564(VarNext,B)
          <=> v4415(VarNext,B) ) ) ) ).

fof(addAssignment_1311,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v4415(VarNext,B)
          <=> v4413(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_105,axiom,
    ! [VarCurr] :
      ( ~ v4416(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v4413(VarCurr,B)
          <=> v569(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_137,axiom,
    ! [VarCurr] :
      ( v4416(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v4413(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_330,axiom,
    ! [VarCurr] :
      ( ~ v4416(VarCurr)
    <=> v566(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_619,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4405(VarNext)
      <=> v4406(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_618,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4406(VarNext)
      <=> ( v4407(VarNext)
          & v4402(VarNext) ) ) ) ).

fof(writeUnaryOperator_329,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4407(VarNext)
      <=> v4409(VarNext) ) ) ).

fof(addAssignment_1310,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4409(VarNext)
      <=> v4402(VarCurr) ) ) ).

fof(addAssignment_1309,axiom,
    ! [VarCurr] :
      ( v4402(VarCurr)
    <=> v4326(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_20,axiom,
    ! [VarCurr] :
      ( ( ~ v4353(VarCurr)
        & ~ v4355(VarCurr)
        & ~ v4382(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v569(VarCurr,B)
          <=> v564(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_31,axiom,
    ! [VarCurr] :
      ( v4382(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v569(VarCurr,B)
          <=> v4384(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_53,axiom,
    ! [VarCurr] :
      ( v4355(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v569(VarCurr,B)
          <=> v4357(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_51,axiom,
    ! [VarCurr] :
      ( v4353(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v569(VarCurr,B)
          <=> v564(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_286,axiom,
    ! [VarCurr] :
      ( v4399(VarCurr)
    <=> ( ( v4400(VarCurr,bitIndex1)
        <=> $true )
        & ( v4400(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1308,axiom,
    ! [VarCurr] :
      ( v4400(VarCurr,bitIndex0)
    <=> v660(VarCurr) ) ).

fof(addAssignment_1307,axiom,
    ! [VarCurr] :
      ( v4400(VarCurr,bitIndex1)
    <=> v571(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_104,axiom,
    ! [VarCurr] :
      ( ~ v4385(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v4384(VarCurr,B)
          <=> v4386(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_136,axiom,
    ! [VarCurr] :
      ( v4385(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v4384(VarCurr,B)
          <=> b100(B) ) ) ) ).

fof(addAssignment_1306,axiom,
    ! [VarCurr] :
      ( v4386(VarCurr,bitIndex0)
    <=> v4396(VarCurr) ) ).

fof(addAssignment_1305,axiom,
    ! [VarCurr] :
      ( v4386(VarCurr,bitIndex1)
    <=> v4394(VarCurr) ) ).

fof(addAssignment_1304,axiom,
    ! [VarCurr] :
      ( v4386(VarCurr,bitIndex2)
    <=> v4388(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_617,axiom,
    ! [VarCurr] :
      ( v4394(VarCurr)
    <=> ( v4395(VarCurr)
        & v4398(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_255,axiom,
    ! [VarCurr] :
      ( v4398(VarCurr)
    <=> ( v564(VarCurr,bitIndex0)
        | v564(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_616,axiom,
    ! [VarCurr] :
      ( v4395(VarCurr)
    <=> ( v4396(VarCurr)
        | v4397(VarCurr) ) ) ).

fof(writeUnaryOperator_328,axiom,
    ! [VarCurr] :
      ( ~ v4397(VarCurr)
    <=> v564(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_327,axiom,
    ! [VarCurr] :
      ( ~ v4396(VarCurr)
    <=> v564(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_615,axiom,
    ! [VarCurr] :
      ( v4388(VarCurr)
    <=> ( v4389(VarCurr)
        & v4393(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_254,axiom,
    ! [VarCurr] :
      ( v4393(VarCurr)
    <=> ( v4391(VarCurr)
        | v564(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_614,axiom,
    ! [VarCurr] :
      ( v4389(VarCurr)
    <=> ( v4390(VarCurr)
        | v4392(VarCurr) ) ) ).

fof(writeUnaryOperator_326,axiom,
    ! [VarCurr] :
      ( ~ v4392(VarCurr)
    <=> v564(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_325,axiom,
    ! [VarCurr] :
      ( ~ v4390(VarCurr)
    <=> v4391(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_253,axiom,
    ! [VarCurr] :
      ( v4391(VarCurr)
    <=> ( v564(VarCurr,bitIndex0)
        & v564(VarCurr,bitIndex1) ) ) ).

fof(addBitVectorEqualityBitBlasted_285,axiom,
    ! [VarCurr] :
      ( v4385(VarCurr)
    <=> ( ( v564(VarCurr,bitIndex2)
        <=> $true )
        & ( v564(VarCurr,bitIndex1)
        <=> $false )
        & ( v564(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_284,axiom,
    ! [VarCurr] :
      ( v4382(VarCurr)
    <=> ( ( v4383(VarCurr,bitIndex1)
        <=> $true )
        & ( v4383(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1303,axiom,
    ! [VarCurr] :
      ( v4383(VarCurr,bitIndex0)
    <=> v660(VarCurr) ) ).

fof(addAssignment_1302,axiom,
    ! [VarCurr] :
      ( v4383(VarCurr,bitIndex1)
    <=> v571(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_103,axiom,
    ! [VarCurr] :
      ( ~ v4358(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v4357(VarCurr,B)
          <=> v4359(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_135,axiom,
    ! [VarCurr] :
      ( v4358(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v4357(VarCurr,B)
          <=> $false ) ) ) ).

fof(addSignExtensionConstraint_54,axiom,
    ! [VarCurr] :
      ( v4359(VarCurr,bitIndex4)
    <=> v4360(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_53,axiom,
    ! [VarCurr] :
      ( v4359(VarCurr,bitIndex5)
    <=> v4360(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_52,axiom,
    ! [VarCurr] :
      ( v4359(VarCurr,bitIndex6)
    <=> v4360(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_51,axiom,
    ! [VarCurr] :
      ( v4359(VarCurr,bitIndex7)
    <=> v4360(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_50,axiom,
    ! [VarCurr] :
      ( v4359(VarCurr,bitIndex8)
    <=> v4360(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_49,axiom,
    ! [VarCurr] :
      ( v4359(VarCurr,bitIndex9)
    <=> v4360(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_48,axiom,
    ! [VarCurr] :
      ( v4359(VarCurr,bitIndex10)
    <=> v4360(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_47,axiom,
    ! [VarCurr] :
      ( v4359(VarCurr,bitIndex11)
    <=> v4360(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_46,axiom,
    ! [VarCurr] :
      ( v4359(VarCurr,bitIndex12)
    <=> v4360(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_45,axiom,
    ! [VarCurr] :
      ( v4359(VarCurr,bitIndex13)
    <=> v4360(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_44,axiom,
    ! [VarCurr] :
      ( v4359(VarCurr,bitIndex14)
    <=> v4360(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_43,axiom,
    ! [VarCurr] :
      ( v4359(VarCurr,bitIndex15)
    <=> v4360(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_42,axiom,
    ! [VarCurr] :
      ( v4359(VarCurr,bitIndex16)
    <=> v4360(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_41,axiom,
    ! [VarCurr] :
      ( v4359(VarCurr,bitIndex17)
    <=> v4360(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_40,axiom,
    ! [VarCurr] :
      ( v4359(VarCurr,bitIndex18)
    <=> v4360(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_39,axiom,
    ! [VarCurr] :
      ( v4359(VarCurr,bitIndex19)
    <=> v4360(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_38,axiom,
    ! [VarCurr] :
      ( v4359(VarCurr,bitIndex20)
    <=> v4360(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_37,axiom,
    ! [VarCurr] :
      ( v4359(VarCurr,bitIndex21)
    <=> v4360(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_36,axiom,
    ! [VarCurr] :
      ( v4359(VarCurr,bitIndex22)
    <=> v4360(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_35,axiom,
    ! [VarCurr] :
      ( v4359(VarCurr,bitIndex23)
    <=> v4360(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_34,axiom,
    ! [VarCurr] :
      ( v4359(VarCurr,bitIndex24)
    <=> v4360(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_33,axiom,
    ! [VarCurr] :
      ( v4359(VarCurr,bitIndex25)
    <=> v4360(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_32,axiom,
    ! [VarCurr] :
      ( v4359(VarCurr,bitIndex26)
    <=> v4360(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_31,axiom,
    ! [VarCurr] :
      ( v4359(VarCurr,bitIndex27)
    <=> v4360(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_30,axiom,
    ! [VarCurr] :
      ( v4359(VarCurr,bitIndex28)
    <=> v4360(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_29,axiom,
    ! [VarCurr] :
      ( v4359(VarCurr,bitIndex29)
    <=> v4360(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_28,axiom,
    ! [VarCurr] :
      ( v4359(VarCurr,bitIndex30)
    <=> v4360(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_27,axiom,
    ! [VarCurr] :
      ( v4359(VarCurr,bitIndex31)
    <=> v4360(VarCurr,bitIndex3) ) ).

fof(addAssignment_1301,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v4359(VarCurr,B)
      <=> v4360(VarCurr,B) ) ) ).

fof(addAssignment_1300,axiom,
    ! [VarCurr] :
      ( v4360(VarCurr,bitIndex0)
    <=> v4380(VarCurr) ) ).

fof(addAssignment_1299,axiom,
    ! [VarCurr] :
      ( v4360(VarCurr,bitIndex1)
    <=> v4378(VarCurr) ) ).

fof(addAssignment_1298,axiom,
    ! [VarCurr] :
      ( v4360(VarCurr,bitIndex2)
    <=> v4374(VarCurr) ) ).

fof(addAssignment_1297,axiom,
    ! [VarCurr] :
      ( v4360(VarCurr,bitIndex3)
    <=> v4362(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_613,axiom,
    ! [VarCurr] :
      ( v4378(VarCurr)
    <=> ( v4379(VarCurr)
        & v4381(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_612,axiom,
    ! [VarCurr] :
      ( v4381(VarCurr)
    <=> ( v4366(VarCurr,bitIndex0)
        | v4370(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_252,axiom,
    ! [VarCurr] :
      ( v4379(VarCurr)
    <=> ( v4380(VarCurr)
        | v4366(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_324,axiom,
    ! [VarCurr] :
      ( ~ v4380(VarCurr)
    <=> v4366(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_611,axiom,
    ! [VarCurr] :
      ( v4374(VarCurr)
    <=> ( v4375(VarCurr)
        & v4377(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_610,axiom,
    ! [VarCurr] :
      ( v4377(VarCurr)
    <=> ( v4368(VarCurr)
        | v4371(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_251,axiom,
    ! [VarCurr] :
      ( v4375(VarCurr)
    <=> ( v4376(VarCurr)
        | v4366(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_323,axiom,
    ! [VarCurr] :
      ( ~ v4376(VarCurr)
    <=> v4368(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_609,axiom,
    ! [VarCurr] :
      ( v4362(VarCurr)
    <=> ( v4363(VarCurr)
        & v4372(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_608,axiom,
    ! [VarCurr] :
      ( v4372(VarCurr)
    <=> ( v4365(VarCurr)
        | v4373(VarCurr) ) ) ).

fof(writeUnaryOperator_322,axiom,
    ! [VarCurr] :
      ( ~ v4373(VarCurr)
    <=> v4366(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorShiftedRanges_250,axiom,
    ! [VarCurr] :
      ( v4363(VarCurr)
    <=> ( v4364(VarCurr)
        | v4366(VarCurr,bitIndex3) ) ) ).

fof(writeUnaryOperator_321,axiom,
    ! [VarCurr] :
      ( ~ v4364(VarCurr)
    <=> v4365(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_249,axiom,
    ! [VarCurr] :
      ( v4365(VarCurr)
    <=> ( v4366(VarCurr,bitIndex2)
        | v4367(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_607,axiom,
    ! [VarCurr] :
      ( v4367(VarCurr)
    <=> ( v4368(VarCurr)
        & v4371(VarCurr) ) ) ).

fof(writeUnaryOperator_320,axiom,
    ! [VarCurr] :
      ( ~ v4371(VarCurr)
    <=> v4366(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges_248,axiom,
    ! [VarCurr] :
      ( v4368(VarCurr)
    <=> ( v4366(VarCurr,bitIndex1)
        | v4369(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_606,axiom,
    ! [VarCurr] :
      ( v4369(VarCurr)
    <=> ( v4366(VarCurr,bitIndex0)
        & v4370(VarCurr) ) ) ).

fof(writeUnaryOperator_319,axiom,
    ! [VarCurr] :
      ( ~ v4370(VarCurr)
    <=> v4366(VarCurr,bitIndex1) ) ).

fof(addZeroExtensionConstraint_1,axiom,
    ! [VarCurr] : ~ v4366(VarCurr,bitIndex3) ).

fof(addAssignment_1296,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v4366(VarCurr,B)
      <=> v564(VarCurr,B) ) ) ).

fof(addBitVectorEqualityBitBlasted_283,axiom,
    ! [VarCurr] :
      ( v4358(VarCurr)
    <=> ( ( v564(VarCurr,bitIndex2)
        <=> $false )
        & ( v564(VarCurr,bitIndex1)
        <=> $false )
        & ( v564(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_282,axiom,
    ! [VarCurr] :
      ( v4355(VarCurr)
    <=> ( ( v4356(VarCurr,bitIndex1)
        <=> $false )
        & ( v4356(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1295,axiom,
    ! [VarCurr] :
      ( v4356(VarCurr,bitIndex0)
    <=> v660(VarCurr) ) ).

fof(addAssignment_1294,axiom,
    ! [VarCurr] :
      ( v4356(VarCurr,bitIndex1)
    <=> v571(VarCurr) ) ).

fof(addAssignmentInitValueVector_131,axiom,
    ! [B] :
      ( range_2_0(B)
     => ( v564(constB0,B)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_281,axiom,
    ! [VarCurr] :
      ( v4353(VarCurr)
    <=> ( ( v4354(VarCurr,bitIndex1)
        <=> $false )
        & ( v4354(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1293,axiom,
    ! [VarCurr] :
      ( v4354(VarCurr,bitIndex0)
    <=> v660(VarCurr) ) ).

fof(addAssignment_1292,axiom,
    ! [VarCurr] :
      ( v4354(VarCurr,bitIndex1)
    <=> v571(VarCurr) ) ).

fof(addAssignment_1291,axiom,
    ! [VarCurr] :
      ( v660(VarCurr)
    <=> v662(VarCurr) ) ).

fof(addAssignment_1290,axiom,
    ! [VarCurr] :
      ( v662(VarCurr)
    <=> v664(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_102,axiom,
    ! [VarCurr] :
      ( ~ v4347(VarCurr)
     => ( v664(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_134,axiom,
    ! [VarCurr] :
      ( v4347(VarCurr)
     => ( v664(VarCurr)
      <=> v4351(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_52,axiom,
    ! [VarCurr] :
      ( ~ v4274(VarCurr)
     => ( v4351(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_50,axiom,
    ! [VarCurr] :
      ( v4274(VarCurr)
     => ( v4351(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_605,axiom,
    ! [VarCurr] :
      ( v4347(VarCurr)
    <=> ( v4274(VarCurr)
        | v4348(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_604,axiom,
    ! [VarCurr] :
      ( v4348(VarCurr)
    <=> ( v4349(VarCurr)
        & v4350(VarCurr) ) ) ).

fof(writeUnaryOperator_318,axiom,
    ! [VarCurr] :
      ( ~ v4350(VarCurr)
    <=> v4274(VarCurr) ) ).

fof(writeUnaryOperator_317,axiom,
    ! [VarCurr] :
      ( ~ v4349(VarCurr)
    <=> v4271(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_247,axiom,
    ! [VarCurr] :
      ( v666(VarCurr)
    <=> ( v4345(VarCurr)
        | v668(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_246,axiom,
    ! [VarCurr] :
      ( v4345(VarCurr)
    <=> ( v4319(VarCurr)
        | v668(VarCurr,bitIndex2) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_51,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4329(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v668(VarNext,B)
            <=> v668(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_52,axiom,
    ! [VarNext] :
      ( v4329(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v668(VarNext,B)
          <=> v4339(VarNext,B) ) ) ) ).

fof(addAssignment_1289,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v4339(VarNext,B)
          <=> v4337(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_101,axiom,
    ! [VarCurr] :
      ( ~ v4340(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v4337(VarCurr,B)
          <=> v671(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_133,axiom,
    ! [VarCurr] :
      ( v4340(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v4337(VarCurr,B)
          <=> b1000(B) ) ) ) ).

fof(writeUnaryOperator_316,axiom,
    ! [VarCurr] :
      ( ~ v4340(VarCurr)
    <=> v45(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_603,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4329(VarNext)
      <=> v4330(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_602,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4330(VarNext)
      <=> ( v4331(VarNext)
          & v4326(VarNext) ) ) ) ).

fof(writeUnaryOperator_315,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4331(VarNext)
      <=> v4333(VarNext) ) ) ).

fof(addAssignment_1288,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4333(VarNext)
      <=> v4326(VarCurr) ) ) ).

fof(addAssignment_1287,axiom,
    ! [VarCurr] :
      ( v4326(VarCurr)
    <=> v803(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_30,axiom,
    ! [VarCurr] :
      ( ( ~ v4280(VarCurr)
        & ~ v4303(VarCurr) )
     => ! [B] :
          ( range_3_0(B)
         => ( v671(VarCurr,B)
          <=> v668(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_51,axiom,
    ! [VarCurr] :
      ( v4303(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v671(VarCurr,B)
          <=> v4305(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_49,axiom,
    ! [VarCurr] :
      ( v4280(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v671(VarCurr,B)
          <=> v4282(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_601,axiom,
    ! [VarCurr] :
      ( v4320(VarCurr)
    <=> ( v4321(VarCurr)
        | v4323(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_280,axiom,
    ! [VarCurr] :
      ( v4323(VarCurr)
    <=> ( ( v4324(VarCurr,bitIndex1)
        <=> $true )
        & ( v4324(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1286,axiom,
    ! [VarCurr] :
      ( v4324(VarCurr,bitIndex0)
    <=> v4263(VarCurr) ) ).

fof(addAssignment_1285,axiom,
    ! [VarCurr] :
      ( v4324(VarCurr,bitIndex1)
    <=> v673(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_279,axiom,
    ! [VarCurr] :
      ( v4321(VarCurr)
    <=> ( ( v4322(VarCurr,bitIndex1)
        <=> $false )
        & ( v4322(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1284,axiom,
    ! [VarCurr] :
      ( v4322(VarCurr,bitIndex0)
    <=> v4263(VarCurr) ) ).

fof(addAssignment_1283,axiom,
    ! [VarCurr] :
      ( v4322(VarCurr,bitIndex1)
    <=> v673(VarCurr) ) ).

fof(addAssignment_1282,axiom,
    ! [VarCurr] :
      ( v4305(VarCurr,bitIndex0)
    <=> v4301(VarCurr) ) ).

fof(addAssignment_1281,axiom,
    ! [VarCurr] :
      ( v4305(VarCurr,bitIndex1)
    <=> v4317(VarCurr) ) ).

fof(addAssignment_1280,axiom,
    ! [VarCurr] :
      ( v4305(VarCurr,bitIndex2)
    <=> v4313(VarCurr) ) ).

fof(addAssignment_1279,axiom,
    ! [VarCurr] :
      ( v4305(VarCurr,bitIndex3)
    <=> v4307(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_600,axiom,
    ! [VarCurr] :
      ( v4317(VarCurr)
    <=> ( v4318(VarCurr)
        & v4319(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_245,axiom,
    ! [VarCurr] :
      ( v4319(VarCurr)
    <=> ( v668(VarCurr,bitIndex0)
        | v668(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_599,axiom,
    ! [VarCurr] :
      ( v4318(VarCurr)
    <=> ( v4301(VarCurr)
        | v4291(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_598,axiom,
    ! [VarCurr] :
      ( v4313(VarCurr)
    <=> ( v4314(VarCurr)
        & v4316(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_244,axiom,
    ! [VarCurr] :
      ( v4316(VarCurr)
    <=> ( v668(VarCurr,bitIndex2)
        | v4311(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_597,axiom,
    ! [VarCurr] :
      ( v4314(VarCurr)
    <=> ( v4292(VarCurr)
        | v4315(VarCurr) ) ) ).

fof(writeUnaryOperator_314,axiom,
    ! [VarCurr] :
      ( ~ v4315(VarCurr)
    <=> v4311(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_596,axiom,
    ! [VarCurr] :
      ( v4307(VarCurr)
    <=> ( v4308(VarCurr)
        & v4312(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_243,axiom,
    ! [VarCurr] :
      ( v4312(VarCurr)
    <=> ( v668(VarCurr,bitIndex3)
        | v4310(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_595,axiom,
    ! [VarCurr] :
      ( v4308(VarCurr)
    <=> ( v4294(VarCurr)
        | v4309(VarCurr) ) ) ).

fof(writeUnaryOperator_313,axiom,
    ! [VarCurr] :
      ( ~ v4309(VarCurr)
    <=> v4310(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_242,axiom,
    ! [VarCurr] :
      ( v4310(VarCurr)
    <=> ( v668(VarCurr,bitIndex2)
        & v4311(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_241,axiom,
    ! [VarCurr] :
      ( v4311(VarCurr)
    <=> ( v668(VarCurr,bitIndex0)
        & v668(VarCurr,bitIndex1) ) ) ).

fof(addBitVectorEqualityBitBlasted_278,axiom,
    ! [VarCurr] :
      ( v4303(VarCurr)
    <=> ( ( v4304(VarCurr,bitIndex1)
        <=> $true )
        & ( v4304(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1278,axiom,
    ! [VarCurr] :
      ( v4304(VarCurr,bitIndex0)
    <=> v4263(VarCurr) ) ).

fof(addAssignment_1277,axiom,
    ! [VarCurr] :
      ( v4304(VarCurr,bitIndex1)
    <=> v673(VarCurr) ) ).

fof(addAssignment_1276,axiom,
    ! [VarCurr] :
      ( v4282(VarCurr,bitIndex0)
    <=> v4301(VarCurr) ) ).

fof(addAssignment_1275,axiom,
    ! [VarCurr] :
      ( v4282(VarCurr,bitIndex1)
    <=> v4299(VarCurr) ) ).

fof(addAssignment_1274,axiom,
    ! [VarCurr] :
      ( v4282(VarCurr,bitIndex2)
    <=> v4295(VarCurr) ) ).

fof(addAssignment_1273,axiom,
    ! [VarCurr] :
      ( v4282(VarCurr,bitIndex3)
    <=> v4284(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_594,axiom,
    ! [VarCurr] :
      ( v4299(VarCurr)
    <=> ( v4300(VarCurr)
        & v4302(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_593,axiom,
    ! [VarCurr] :
      ( v4302(VarCurr)
    <=> ( v668(VarCurr,bitIndex0)
        | v4291(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_240,axiom,
    ! [VarCurr] :
      ( v4300(VarCurr)
    <=> ( v4301(VarCurr)
        | v668(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_312,axiom,
    ! [VarCurr] :
      ( ~ v4301(VarCurr)
    <=> v668(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_592,axiom,
    ! [VarCurr] :
      ( v4295(VarCurr)
    <=> ( v4296(VarCurr)
        & v4298(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_591,axiom,
    ! [VarCurr] :
      ( v4298(VarCurr)
    <=> ( v4289(VarCurr)
        | v4292(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_239,axiom,
    ! [VarCurr] :
      ( v4296(VarCurr)
    <=> ( v4297(VarCurr)
        | v668(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_311,axiom,
    ! [VarCurr] :
      ( ~ v4297(VarCurr)
    <=> v4289(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_590,axiom,
    ! [VarCurr] :
      ( v4284(VarCurr)
    <=> ( v4285(VarCurr)
        & v4293(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_589,axiom,
    ! [VarCurr] :
      ( v4293(VarCurr)
    <=> ( v4287(VarCurr)
        | v4294(VarCurr) ) ) ).

fof(writeUnaryOperator_310,axiom,
    ! [VarCurr] :
      ( ~ v4294(VarCurr)
    <=> v668(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorShiftedRanges_238,axiom,
    ! [VarCurr] :
      ( v4285(VarCurr)
    <=> ( v4286(VarCurr)
        | v668(VarCurr,bitIndex3) ) ) ).

fof(writeUnaryOperator_309,axiom,
    ! [VarCurr] :
      ( ~ v4286(VarCurr)
    <=> v4287(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_237,axiom,
    ! [VarCurr] :
      ( v4287(VarCurr)
    <=> ( v668(VarCurr,bitIndex2)
        | v4288(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_588,axiom,
    ! [VarCurr] :
      ( v4288(VarCurr)
    <=> ( v4289(VarCurr)
        & v4292(VarCurr) ) ) ).

fof(writeUnaryOperator_308,axiom,
    ! [VarCurr] :
      ( ~ v4292(VarCurr)
    <=> v668(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges_236,axiom,
    ! [VarCurr] :
      ( v4289(VarCurr)
    <=> ( v668(VarCurr,bitIndex1)
        | v4290(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_587,axiom,
    ! [VarCurr] :
      ( v4290(VarCurr)
    <=> ( v668(VarCurr,bitIndex0)
        & v4291(VarCurr) ) ) ).

fof(writeUnaryOperator_307,axiom,
    ! [VarCurr] :
      ( ~ v4291(VarCurr)
    <=> v668(VarCurr,bitIndex1) ) ).

fof(addAssignmentInitValue_250,axiom,
    v668(constB0,bitIndex3) ).

fof(addAssignmentInitValue_249,axiom,
    ~ v668(constB0,bitIndex2) ).

fof(addAssignmentInitValue_248,axiom,
    ~ v668(constB0,bitIndex1) ).

fof(addAssignmentInitValue_247,axiom,
    ~ v668(constB0,bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_277,axiom,
    ! [VarCurr] :
      ( v4280(VarCurr)
    <=> ( ( v4281(VarCurr,bitIndex1)
        <=> $false )
        & ( v4281(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1272,axiom,
    ! [VarCurr] :
      ( v4281(VarCurr,bitIndex0)
    <=> v4263(VarCurr) ) ).

fof(addAssignment_1271,axiom,
    ! [VarCurr] :
      ( v4281(VarCurr,bitIndex1)
    <=> v673(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_586,axiom,
    ! [VarCurr] :
      ( v4263(VarCurr)
    <=> ( v664(VarCurr)
        | v4265(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_100,axiom,
    ! [VarCurr] :
      ( ~ v4267(VarCurr)
     => ( v4265(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_132,axiom,
    ! [VarCurr] :
      ( v4267(VarCurr)
     => ( v4265(VarCurr)
      <=> v4276(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_50,axiom,
    ! [VarCurr] :
      ( ~ v4269(VarCurr)
     => ( v4276(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_48,axiom,
    ! [VarCurr] :
      ( v4269(VarCurr)
     => ( v4276(VarCurr)
      <=> v4277(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_99,axiom,
    ! [VarCurr] :
      ( ~ v666(VarCurr)
     => ( v4277(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_131,axiom,
    ! [VarCurr] :
      ( v666(VarCurr)
     => ( v4277(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_585,axiom,
    ! [VarCurr] :
      ( v4267(VarCurr)
    <=> ( v4268(VarCurr)
        & v4273(VarCurr) ) ) ).

fof(writeUnaryOperator_306,axiom,
    ! [VarCurr] :
      ( ~ v4273(VarCurr)
    <=> v4274(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_584,axiom,
    ! [VarCurr] :
      ( v4274(VarCurr)
    <=> ( v4275(VarCurr)
        & v666(VarCurr) ) ) ).

fof(writeUnaryOperator_305,axiom,
    ! [VarCurr] :
      ( ~ v4275(VarCurr)
    <=> v560(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_583,axiom,
    ! [VarCurr] :
      ( v4268(VarCurr)
    <=> ( v4269(VarCurr)
        | v4272(VarCurr) ) ) ).

fof(writeUnaryOperator_304,axiom,
    ! [VarCurr] :
      ( ~ v4272(VarCurr)
    <=> v4271(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_582,axiom,
    ! [VarCurr] :
      ( v4269(VarCurr)
    <=> ( v4270(VarCurr)
        & v4271(VarCurr) ) ) ).

fof(writeUnaryOperator_303,axiom,
    ! [VarCurr] :
      ( ~ v4271(VarCurr)
    <=> v39(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_276,axiom,
    ! [VarCurr] :
      ( v4270(VarCurr)
    <=> ( ( v37(VarCurr,bitIndex1)
        <=> $false )
        & ( v37(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1270,axiom,
    ! [VarCurr] :
      ( v673(VarCurr)
    <=> v675(VarCurr) ) ).

fof(addAssignment_1269,axiom,
    ! [VarCurr] :
      ( v675(VarCurr)
    <=> v677(VarCurr) ) ).

fof(addAssignment_1268,axiom,
    ! [VarCurr] :
      ( v677(VarCurr)
    <=> v679(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_98,axiom,
    ! [VarCurr] :
      ( ~ v4258(VarCurr)
     => ( v679(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_130,axiom,
    ! [VarCurr] :
      ( v4258(VarCurr)
     => ( v679(VarCurr)
      <=> v4261(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_49,axiom,
    ! [VarCurr] :
      ( ~ v1214(VarCurr)
     => ( v4261(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_47,axiom,
    ! [VarCurr] :
      ( v1214(VarCurr)
     => ( v4261(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_581,axiom,
    ! [VarCurr] :
      ( v4258(VarCurr)
    <=> ( v1214(VarCurr)
        | v4259(VarCurr) ) ) ).

fof(writeUnaryOperator_302,axiom,
    ! [VarCurr] :
      ( ~ v4259(VarCurr)
    <=> v4260(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_580,axiom,
    ! [VarCurr] :
      ( v4260(VarCurr)
    <=> ( v1210(VarCurr)
        | v1214(VarCurr) ) ) ).

fof(addAssignment_1267,axiom,
    ! [VarCurr] :
      ( v681(VarCurr)
    <=> v683(VarCurr) ) ).

fof(addAssignment_1266,axiom,
    ! [VarCurr] :
      ( v683(VarCurr)
    <=> v685(VarCurr) ) ).

fof(addAssignment_1265,axiom,
    ! [VarCurr] :
      ( v685(VarCurr)
    <=> v687(VarCurr) ) ).

fof(addAssignment_1264,axiom,
    ! [VarCurr] :
      ( v687(VarCurr)
    <=> v689(VarCurr) ) ).

fof(addAssignment_1263,axiom,
    ! [VarCurr] :
      ( v689(VarCurr)
    <=> v691(VarCurr) ) ).

fof(addAssignment_1262,axiom,
    ! [VarCurr] :
      ( v691(VarCurr)
    <=> v693(VarCurr) ) ).

fof(addAssignment_1261,axiom,
    ! [VarCurr] :
      ( v693(VarCurr)
    <=> v695(VarCurr) ) ).

fof(addAssignment_1260,axiom,
    ! [VarCurr] :
      ( v695(VarCurr)
    <=> v697(VarCurr) ) ).

fof(addAssignment_1259,axiom,
    ! [VarCurr] :
      ( v697(VarCurr)
    <=> v699(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_579,axiom,
    ! [VarCurr] :
      ( v699(VarCurr)
    <=> ( v701(VarCurr)
        | v4186(VarCurr) ) ) ).

fof(addAssignment_1258,axiom,
    ! [VarCurr] :
      ( v4186(VarCurr)
    <=> v4188(VarCurr,bitIndex6) ) ).

fof(addAssignment_1257,axiom,
    ! [VarCurr] :
      ( v4188(VarCurr,bitIndex6)
    <=> v4190(VarCurr,bitIndex6) ) ).

fof(addAssignment_1256,axiom,
    ! [VarCurr] :
      ( v4190(VarCurr,bitIndex6)
    <=> v4192(VarCurr,bitIndex6) ) ).

fof(addAssignment_1255,axiom,
    ! [VarNext] :
      ( v4192(VarNext,bitIndex6)
    <=> v4249(VarNext,bitIndex6) ) ).

fof(addCaseBooleanConditionEqualRanges1_50,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4250(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v4249(VarNext,B)
            <=> v4192(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_51,axiom,
    ! [VarNext] :
      ( v4250(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v4249(VarNext,B)
          <=> v4236(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_578,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4250(VarNext)
      <=> v4251(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_577,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4251(VarNext)
      <=> ( v4253(VarNext)
          & v4223(VarNext) ) ) ) ).

fof(writeUnaryOperator_301,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4253(VarNext)
      <=> v4230(VarNext) ) ) ).

fof(addAssignment_1254,axiom,
    ! [VarCurr] :
      ( v4196(VarCurr,bitIndex6)
    <=> v4209(VarCurr,bitIndex6) ) ).

fof(addAssignment_1253,axiom,
    ! [VarNext] :
      ( v4192(VarNext,bitIndex5)
    <=> v4241(VarNext,bitIndex5) ) ).

fof(addCaseBooleanConditionEqualRanges1_49,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4242(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v4241(VarNext,B)
            <=> v4192(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_50,axiom,
    ! [VarNext] :
      ( v4242(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v4241(VarNext,B)
          <=> v4236(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_576,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4242(VarNext)
      <=> v4243(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_575,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4243(VarNext)
      <=> ( v4245(VarNext)
          & v4223(VarNext) ) ) ) ).

fof(writeUnaryOperator_300,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4245(VarNext)
      <=> v4230(VarNext) ) ) ).

fof(addAssignment_1252,axiom,
    ! [VarCurr] :
      ( v4196(VarCurr,bitIndex5)
    <=> v4209(VarCurr,bitIndex5) ) ).

fof(addAssignment_1251,axiom,
    ! [VarNext] :
      ( v4192(VarNext,bitIndex7)
    <=> v4225(VarNext,bitIndex7) ) ).

fof(addCaseBooleanConditionEqualRanges1_48,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4226(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v4225(VarNext,B)
            <=> v4192(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_49,axiom,
    ! [VarNext] :
      ( v4226(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v4225(VarNext,B)
          <=> v4236(VarNext,B) ) ) ) ).

fof(addAssignment_1250,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v4236(VarNext,B)
          <=> v4234(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_97,axiom,
    ! [VarCurr] :
      ( ~ v4237(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v4234(VarCurr,B)
          <=> v4196(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_129,axiom,
    ! [VarCurr] :
      ( v4237(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v4234(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_299,axiom,
    ! [VarCurr] :
      ( ~ v4237(VarCurr)
    <=> v4194(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_574,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4226(VarNext)
      <=> v4227(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_573,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4227(VarNext)
      <=> ( v4228(VarNext)
          & v4223(VarNext) ) ) ) ).

fof(writeUnaryOperator_298,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4228(VarNext)
      <=> v4230(VarNext) ) ) ).

fof(addAssignment_1249,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4230(VarNext)
      <=> v4223(VarCurr) ) ) ).

fof(addAssignment_1248,axiom,
    ! [VarCurr] :
      ( v4223(VarCurr)
    <=> v2549(VarCurr) ) ).

fof(addAssignment_1247,axiom,
    ! [VarCurr] :
      ( v4196(VarCurr,bitIndex7)
    <=> v4209(VarCurr,bitIndex7) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_19,axiom,
    ! [VarCurr] :
      ( ( ~ v4210(VarCurr)
        & ~ v4214(VarCurr)
        & ~ v4217(VarCurr) )
     => ! [B] :
          ( range_7_0(B)
         => ( v4209(VarCurr,B)
          <=> v4192(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_29,axiom,
    ! [VarCurr] :
      ( v4217(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v4209(VarCurr,B)
          <=> v4219(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_48,axiom,
    ! [VarCurr] :
      ( v4214(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v4209(VarCurr,B)
          <=> v4216(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_46,axiom,
    ! [VarCurr] :
      ( v4210(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v4209(VarCurr,B)
          <=> v4192(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_275,axiom,
    ! [VarCurr] :
      ( v4220(VarCurr)
    <=> ( ( v4221(VarCurr,bitIndex1)
        <=> $true )
        & ( v4221(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1246,axiom,
    ! [VarCurr] :
      ( v4221(VarCurr,bitIndex0)
    <=> v4204(VarCurr) ) ).

fof(addAssignment_1245,axiom,
    ! [VarCurr] :
      ( v4221(VarCurr,bitIndex1)
    <=> v4198(VarCurr) ) ).

fof(addAssignment_1244,axiom,
    ! [VarCurr] :
      ( v4219(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_1243,axiom,
    ! [VarCurr] :
      ( ( v4219(VarCurr,bitIndex7)
      <=> v4192(VarCurr,bitIndex6) )
      & ( v4219(VarCurr,bitIndex6)
      <=> v4192(VarCurr,bitIndex5) )
      & ( v4219(VarCurr,bitIndex5)
      <=> v4192(VarCurr,bitIndex4) )
      & ( v4219(VarCurr,bitIndex4)
      <=> v4192(VarCurr,bitIndex3) )
      & ( v4219(VarCurr,bitIndex3)
      <=> v4192(VarCurr,bitIndex2) )
      & ( v4219(VarCurr,bitIndex2)
      <=> v4192(VarCurr,bitIndex1) )
      & ( v4219(VarCurr,bitIndex1)
      <=> v4192(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_274,axiom,
    ! [VarCurr] :
      ( v4217(VarCurr)
    <=> ( ( v4218(VarCurr,bitIndex1)
        <=> $true )
        & ( v4218(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1242,axiom,
    ! [VarCurr] :
      ( v4218(VarCurr,bitIndex0)
    <=> v4204(VarCurr) ) ).

fof(addAssignment_1241,axiom,
    ! [VarCurr] :
      ( v4218(VarCurr,bitIndex1)
    <=> v4198(VarCurr) ) ).

fof(addAssignment_1240,axiom,
    ! [VarCurr] :
      ( ( v4216(VarCurr,bitIndex6)
      <=> v4192(VarCurr,bitIndex7) )
      & ( v4216(VarCurr,bitIndex5)
      <=> v4192(VarCurr,bitIndex6) )
      & ( v4216(VarCurr,bitIndex4)
      <=> v4192(VarCurr,bitIndex5) )
      & ( v4216(VarCurr,bitIndex3)
      <=> v4192(VarCurr,bitIndex4) )
      & ( v4216(VarCurr,bitIndex2)
      <=> v4192(VarCurr,bitIndex3) )
      & ( v4216(VarCurr,bitIndex1)
      <=> v4192(VarCurr,bitIndex2) )
      & ( v4216(VarCurr,bitIndex0)
      <=> v4192(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_1239,axiom,
    ! [VarCurr] :
      ( v4216(VarCurr,bitIndex7)
    <=> $false ) ).

fof(addBitVectorEqualityBitBlasted_273,axiom,
    ! [VarCurr] :
      ( v4214(VarCurr)
    <=> ( ( v4215(VarCurr,bitIndex1)
        <=> $false )
        & ( v4215(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1238,axiom,
    ! [VarCurr] :
      ( v4215(VarCurr,bitIndex0)
    <=> v4204(VarCurr) ) ).

fof(addAssignment_1237,axiom,
    ! [VarCurr] :
      ( v4215(VarCurr,bitIndex1)
    <=> v4198(VarCurr) ) ).

fof(addAssignmentInitValue_246,axiom,
    ~ v4192(constB0,bitIndex7) ).

fof(addAssignmentInitValue_245,axiom,
    ~ v4192(constB0,bitIndex6) ).

fof(addAssignmentInitValue_244,axiom,
    ~ v4192(constB0,bitIndex5) ).

fof(addAssignmentInitValue_243,axiom,
    ~ v4192(constB0,bitIndex4) ).

fof(bitBlastConstant_1367,axiom,
    ~ b0000xxxx(bitIndex7) ).

fof(bitBlastConstant_1366,axiom,
    ~ b0000xxxx(bitIndex6) ).

fof(bitBlastConstant_1365,axiom,
    ~ b0000xxxx(bitIndex5) ).

fof(bitBlastConstant_1364,axiom,
    ~ b0000xxxx(bitIndex4) ).

fof(addBitVectorEqualityBitBlasted_272,axiom,
    ! [VarCurr] :
      ( v4210(VarCurr)
    <=> ( ( v4211(VarCurr,bitIndex1)
        <=> $false )
        & ( v4211(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1236,axiom,
    ! [VarCurr] :
      ( v4211(VarCurr,bitIndex0)
    <=> v4204(VarCurr) ) ).

fof(addAssignment_1235,axiom,
    ! [VarCurr] :
      ( v4211(VarCurr,bitIndex1)
    <=> v4198(VarCurr) ) ).

fof(addAssignment_1234,axiom,
    ! [VarCurr] :
      ( v4204(VarCurr)
    <=> v4206(VarCurr) ) ).

fof(addAssignment_1233,axiom,
    ! [VarCurr] :
      ( v4206(VarCurr)
    <=> v4208(VarCurr) ) ).

fof(addAssignment_1232,axiom,
    ! [VarCurr] :
      ( v4208(VarCurr)
    <=> v3263(VarCurr) ) ).

fof(addAssignment_1231,axiom,
    ! [VarCurr] :
      ( v4198(VarCurr)
    <=> v4200(VarCurr) ) ).

fof(addAssignment_1230,axiom,
    ! [VarCurr] :
      ( v4200(VarCurr)
    <=> v4202(VarCurr) ) ).

fof(addAssignment_1229,axiom,
    ! [VarCurr] :
      ( v4202(VarCurr)
    <=> v723(VarCurr) ) ).

fof(addAssignment_1228,axiom,
    ! [VarCurr] :
      ( v4194(VarCurr)
    <=> v711(VarCurr) ) ).

fof(addAssignment_1227,axiom,
    ! [VarCurr] :
      ( v701(VarCurr)
    <=> v703(VarCurr,bitIndex2) ) ).

fof(addAssignment_1226,axiom,
    ! [VarCurr] :
      ( v703(VarCurr,bitIndex2)
    <=> v705(VarCurr,bitIndex2) ) ).

fof(addAssignment_1225,axiom,
    ! [VarCurr] :
      ( v705(VarCurr,bitIndex2)
    <=> v707(VarCurr,bitIndex2) ) ).

fof(addAssignment_1224,axiom,
    ! [VarNext] :
      ( v707(VarNext,bitIndex2)
    <=> v4178(VarNext,bitIndex2) ) ).

fof(addCaseBooleanConditionEqualRanges1_47,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4179(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v4178(VarNext,B)
            <=> v707(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_48,axiom,
    ! [VarNext] :
      ( v4179(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v4178(VarNext,B)
          <=> v2564(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_572,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4179(VarNext)
      <=> v4180(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_571,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4180(VarNext)
      <=> ( v4182(VarNext)
          & v2547(VarNext) ) ) ) ).

fof(writeUnaryOperator_297,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4182(VarNext)
      <=> v2558(VarNext) ) ) ).

fof(addAssignment_1223,axiom,
    ! [VarCurr] :
      ( v715(VarCurr,bitIndex2)
    <=> v2535(VarCurr,bitIndex2) ) ).

fof(addAssignment_1222,axiom,
    ! [VarNext] :
      ( v707(VarNext,bitIndex3)
    <=> v4170(VarNext,bitIndex3) ) ).

fof(addCaseBooleanConditionEqualRanges1_46,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4171(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v4170(VarNext,B)
            <=> v707(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_47,axiom,
    ! [VarNext] :
      ( v4171(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v4170(VarNext,B)
          <=> v2564(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_570,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4171(VarNext)
      <=> v4172(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_569,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4172(VarNext)
      <=> ( v4174(VarNext)
          & v2547(VarNext) ) ) ) ).

fof(writeUnaryOperator_296,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4174(VarNext)
      <=> v2558(VarNext) ) ) ).

fof(addAssignment_1221,axiom,
    ! [VarCurr] :
      ( v715(VarCurr,bitIndex3)
    <=> v2535(VarCurr,bitIndex3) ) ).

fof(addAssignment_1220,axiom,
    ! [VarCurr] :
      ( v2530(VarCurr)
    <=> v2532(VarCurr) ) ).

fof(addAssignment_1219,axiom,
    ! [VarCurr] :
      ( v2532(VarCurr)
    <=> v2534(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_568,axiom,
    ! [VarCurr] :
      ( v2534(VarCurr)
    <=> ( v703(VarCurr,bitIndex0)
        & v4168(VarCurr) ) ) ).

fof(writeUnaryOperator_295,axiom,
    ! [VarCurr] :
      ( ~ v4168(VarCurr)
    <=> v2577(VarCurr) ) ).

fof(addAssignment_1218,axiom,
    ! [VarCurr] :
      ( v2577(VarCurr)
    <=> v2579(VarCurr) ) ).

fof(addAssignment_1217,axiom,
    ! [VarCurr] :
      ( v2579(VarCurr)
    <=> v2581(VarCurr) ) ).

fof(addAssignment_1216,axiom,
    ! [VarCurr] :
      ( v2581(VarCurr)
    <=> v2583(VarCurr) ) ).

fof(addAssignment_1215,axiom,
    ! [VarCurr] :
      ( v2583(VarCurr)
    <=> v2585(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_567,axiom,
    ! [VarCurr] :
      ( v2585(VarCurr)
    <=> ( v4164(VarCurr)
        | v4165(VarCurr) ) ) ).

fof(writeUnaryOperator_294,axiom,
    ! [VarCurr] :
      ( ~ v4165(VarCurr)
    <=> v4166(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_566,axiom,
    ! [VarCurr] :
      ( v4166(VarCurr)
    <=> ( v2992(VarCurr)
        & v3153(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_565,axiom,
    ! [VarCurr] :
      ( v4164(VarCurr)
    <=> ( v2587(VarCurr,bitIndex0)
        | v2810(VarCurr) ) ) ).

fof(addAssignment_1214,axiom,
    ! [VarCurr] :
      ( v2587(VarCurr,bitIndex0)
    <=> v2770(VarCurr,bitIndex0) ) ).

fof(addCaseBooleanConditionEqualRanges1_45,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4152(VarNext)
       => ! [B] :
            ( range_1_0(B)
           => ( v2589(VarNext,B)
            <=> v2589(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_46,axiom,
    ! [VarNext] :
      ( v4152(VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v2589(VarNext,B)
          <=> v4160(VarNext,B) ) ) ) ).

fof(addAssignment_1213,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v4160(VarNext,B)
          <=> v4158(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_96,axiom,
    ! [VarCurr] :
      ( ~ v4079(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v4158(VarCurr,B)
          <=> v2595(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_128,axiom,
    ! [VarCurr] :
      ( v4079(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v4158(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_564,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4152(VarNext)
      <=> v4153(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_563,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4153(VarNext)
      <=> ( v4155(VarNext)
          & v3155(VarNext) ) ) ) ).

fof(writeUnaryOperator_293,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4155(VarNext)
      <=> v3164(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_18,axiom,
    ! [VarCurr] :
      ( ( ~ v4110(VarCurr)
        & ~ v4120(VarCurr)
        & ~ v4130(VarCurr) )
     => ! [B] :
          ( range_1_0(B)
         => ( v2595(VarCurr,B)
          <=> v4141(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_28,axiom,
    ! [VarCurr] :
      ( v4130(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v2595(VarCurr,B)
          <=> v4131(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_47,axiom,
    ! [VarCurr] :
      ( v4120(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v2595(VarCurr,B)
          <=> v4121(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_45,axiom,
    ! [VarCurr] :
      ( v4110(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v2595(VarCurr,B)
          <=> v4111(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_17,axiom,
    ! [VarCurr] :
      ( ( ~ v4142(VarCurr)
        & ~ v4144(VarCurr)
        & ~ v4146(VarCurr) )
     => ! [B] :
          ( range_1_0(B)
         => ( v4141(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_27,axiom,
    ! [VarCurr] :
      ( v4146(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v4141(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_46,axiom,
    ! [VarCurr] :
      ( v4144(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v4141(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_44,axiom,
    ! [VarCurr] :
      ( v4142(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v4141(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_271,axiom,
    ! [VarCurr] :
      ( v4148(VarCurr)
    <=> ( ( v4149(VarCurr,bitIndex1)
        <=> $true )
        & ( v4149(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1212,axiom,
    ! [VarCurr] :
      ( v4149(VarCurr,bitIndex0)
    <=> v4083(VarCurr) ) ).

fof(addAssignment_1211,axiom,
    ! [VarCurr] :
      ( v4149(VarCurr,bitIndex1)
    <=> v2597(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_270,axiom,
    ! [VarCurr] :
      ( v4146(VarCurr)
    <=> ( ( v4147(VarCurr,bitIndex1)
        <=> $true )
        & ( v4147(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1210,axiom,
    ! [VarCurr] :
      ( v4147(VarCurr,bitIndex0)
    <=> v4083(VarCurr) ) ).

fof(addAssignment_1209,axiom,
    ! [VarCurr] :
      ( v4147(VarCurr,bitIndex1)
    <=> v2597(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_269,axiom,
    ! [VarCurr] :
      ( v4144(VarCurr)
    <=> ( ( v4145(VarCurr,bitIndex1)
        <=> $false )
        & ( v4145(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1208,axiom,
    ! [VarCurr] :
      ( v4145(VarCurr,bitIndex0)
    <=> v4083(VarCurr) ) ).

fof(addAssignment_1207,axiom,
    ! [VarCurr] :
      ( v4145(VarCurr,bitIndex1)
    <=> v2597(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_268,axiom,
    ! [VarCurr] :
      ( v4142(VarCurr)
    <=> ( ( v4143(VarCurr,bitIndex1)
        <=> $false )
        & ( v4143(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1206,axiom,
    ! [VarCurr] :
      ( v4143(VarCurr,bitIndex0)
    <=> v4083(VarCurr) ) ).

fof(addAssignment_1205,axiom,
    ! [VarCurr] :
      ( v4143(VarCurr,bitIndex1)
    <=> v2597(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_267,axiom,
    ! [VarCurr] :
      ( v4140(VarCurr)
    <=> ( ( v2589(VarCurr,bitIndex1)
        <=> $true )
        & ( v2589(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_16,axiom,
    ! [VarCurr] :
      ( ( ~ v4132(VarCurr)
        & ~ v4134(VarCurr)
        & ~ v4136(VarCurr) )
     => ! [B] :
          ( range_1_0(B)
         => ( v4131(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_26,axiom,
    ! [VarCurr] :
      ( v4136(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v4131(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_45,axiom,
    ! [VarCurr] :
      ( v4134(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v4131(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_43,axiom,
    ! [VarCurr] :
      ( v4132(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v4131(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_266,axiom,
    ! [VarCurr] :
      ( v4138(VarCurr)
    <=> ( ( v4139(VarCurr,bitIndex1)
        <=> $true )
        & ( v4139(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1204,axiom,
    ! [VarCurr] :
      ( v4139(VarCurr,bitIndex0)
    <=> v3359(VarCurr) ) ).

fof(addAssignment_1203,axiom,
    ! [VarCurr] :
      ( v4139(VarCurr,bitIndex1)
    <=> v2597(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_265,axiom,
    ! [VarCurr] :
      ( v4136(VarCurr)
    <=> ( ( v4137(VarCurr,bitIndex1)
        <=> $true )
        & ( v4137(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1202,axiom,
    ! [VarCurr] :
      ( v4137(VarCurr,bitIndex0)
    <=> v3359(VarCurr) ) ).

fof(addAssignment_1201,axiom,
    ! [VarCurr] :
      ( v4137(VarCurr,bitIndex1)
    <=> v2597(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_264,axiom,
    ! [VarCurr] :
      ( v4134(VarCurr)
    <=> ( ( v4135(VarCurr,bitIndex1)
        <=> $false )
        & ( v4135(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1200,axiom,
    ! [VarCurr] :
      ( v4135(VarCurr,bitIndex0)
    <=> v3359(VarCurr) ) ).

fof(addAssignment_1199,axiom,
    ! [VarCurr] :
      ( v4135(VarCurr,bitIndex1)
    <=> v2597(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_263,axiom,
    ! [VarCurr] :
      ( v4132(VarCurr)
    <=> ( ( v4133(VarCurr,bitIndex1)
        <=> $false )
        & ( v4133(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1198,axiom,
    ! [VarCurr] :
      ( v4133(VarCurr,bitIndex0)
    <=> v3359(VarCurr) ) ).

fof(addAssignment_1197,axiom,
    ! [VarCurr] :
      ( v4133(VarCurr,bitIndex1)
    <=> v2597(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_262,axiom,
    ! [VarCurr] :
      ( v4130(VarCurr)
    <=> ( ( v2589(VarCurr,bitIndex1)
        <=> $true )
        & ( v2589(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_15,axiom,
    ! [VarCurr] :
      ( ( ~ v4122(VarCurr)
        & ~ v4124(VarCurr)
        & ~ v4126(VarCurr) )
     => ! [B] :
          ( range_1_0(B)
         => ( v4121(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_25,axiom,
    ! [VarCurr] :
      ( v4126(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v4121(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_44,axiom,
    ! [VarCurr] :
      ( v4124(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v4121(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_42,axiom,
    ! [VarCurr] :
      ( v4122(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v4121(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_261,axiom,
    ! [VarCurr] :
      ( v4128(VarCurr)
    <=> ( ( v4129(VarCurr,bitIndex1)
        <=> $true )
        & ( v4129(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1196,axiom,
    ! [VarCurr] :
      ( v4129(VarCurr,bitIndex0)
    <=> v4083(VarCurr) ) ).

fof(addAssignment_1195,axiom,
    ! [VarCurr] :
      ( v4129(VarCurr,bitIndex1)
    <=> v2597(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_260,axiom,
    ! [VarCurr] :
      ( v4126(VarCurr)
    <=> ( ( v4127(VarCurr,bitIndex1)
        <=> $true )
        & ( v4127(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1194,axiom,
    ! [VarCurr] :
      ( v4127(VarCurr,bitIndex0)
    <=> v4083(VarCurr) ) ).

fof(addAssignment_1193,axiom,
    ! [VarCurr] :
      ( v4127(VarCurr,bitIndex1)
    <=> v2597(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_259,axiom,
    ! [VarCurr] :
      ( v4124(VarCurr)
    <=> ( ( v4125(VarCurr,bitIndex1)
        <=> $false )
        & ( v4125(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1192,axiom,
    ! [VarCurr] :
      ( v4125(VarCurr,bitIndex0)
    <=> v4083(VarCurr) ) ).

fof(addAssignment_1191,axiom,
    ! [VarCurr] :
      ( v4125(VarCurr,bitIndex1)
    <=> v2597(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_258,axiom,
    ! [VarCurr] :
      ( v4122(VarCurr)
    <=> ( ( v4123(VarCurr,bitIndex1)
        <=> $false )
        & ( v4123(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1190,axiom,
    ! [VarCurr] :
      ( v4123(VarCurr,bitIndex0)
    <=> v4083(VarCurr) ) ).

fof(addAssignment_1189,axiom,
    ! [VarCurr] :
      ( v4123(VarCurr,bitIndex1)
    <=> v2597(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_257,axiom,
    ! [VarCurr] :
      ( v4120(VarCurr)
    <=> ( ( v2589(VarCurr,bitIndex1)
        <=> $false )
        & ( v2589(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_14,axiom,
    ! [VarCurr] :
      ( ( ~ v4112(VarCurr)
        & ~ v4114(VarCurr)
        & ~ v4116(VarCurr) )
     => ! [B] :
          ( range_1_0(B)
         => ( v4111(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_24,axiom,
    ! [VarCurr] :
      ( v4116(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v4111(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_43,axiom,
    ! [VarCurr] :
      ( v4114(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v4111(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_41,axiom,
    ! [VarCurr] :
      ( v4112(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v4111(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_256,axiom,
    ! [VarCurr] :
      ( v4118(VarCurr)
    <=> ( ( v4119(VarCurr,bitIndex1)
        <=> $true )
        & ( v4119(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1188,axiom,
    ! [VarCurr] :
      ( v4119(VarCurr,bitIndex0)
    <=> v3359(VarCurr) ) ).

fof(addAssignment_1187,axiom,
    ! [VarCurr] :
      ( v4119(VarCurr,bitIndex1)
    <=> v2597(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_255,axiom,
    ! [VarCurr] :
      ( v4116(VarCurr)
    <=> ( ( v4117(VarCurr,bitIndex1)
        <=> $true )
        & ( v4117(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1186,axiom,
    ! [VarCurr] :
      ( v4117(VarCurr,bitIndex0)
    <=> v3359(VarCurr) ) ).

fof(addAssignment_1185,axiom,
    ! [VarCurr] :
      ( v4117(VarCurr,bitIndex1)
    <=> v2597(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_254,axiom,
    ! [VarCurr] :
      ( v4114(VarCurr)
    <=> ( ( v4115(VarCurr,bitIndex1)
        <=> $false )
        & ( v4115(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1184,axiom,
    ! [VarCurr] :
      ( v4115(VarCurr,bitIndex0)
    <=> v3359(VarCurr) ) ).

fof(addAssignment_1183,axiom,
    ! [VarCurr] :
      ( v4115(VarCurr,bitIndex1)
    <=> v2597(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_253,axiom,
    ! [VarCurr] :
      ( v4112(VarCurr)
    <=> ( ( v4113(VarCurr,bitIndex1)
        <=> $false )
        & ( v4113(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1182,axiom,
    ! [VarCurr] :
      ( v4113(VarCurr,bitIndex0)
    <=> v3359(VarCurr) ) ).

fof(addAssignment_1181,axiom,
    ! [VarCurr] :
      ( v4113(VarCurr,bitIndex1)
    <=> v2597(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_252,axiom,
    ! [VarCurr] :
      ( v4110(VarCurr)
    <=> ( ( v2589(VarCurr,bitIndex1)
        <=> $false )
        & ( v2589(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_44,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4098(VarNext)
       => ( v4083(VarNext)
        <=> v4083(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_45,axiom,
    ! [VarNext] :
      ( v4098(VarNext)
     => ( v4083(VarNext)
      <=> v4106(VarNext) ) ) ).

fof(addAssignment_1180,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4106(VarNext)
      <=> v4104(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_95,axiom,
    ! [VarCurr] :
      ( ~ v4079(VarCurr)
     => ( v4104(VarCurr)
      <=> v4085(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_127,axiom,
    ! [VarCurr] :
      ( v4079(VarCurr)
     => ( v4104(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_562,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4098(VarNext)
      <=> v4099(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_561,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4099(VarNext)
      <=> ( v4101(VarNext)
          & v3155(VarNext) ) ) ) ).

fof(writeUnaryOperator_292,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4101(VarNext)
      <=> v3164(VarNext) ) ) ).

fof(addAssignmentInitValueVector_130,axiom,
    ( v4083(constB0)
  <=> $false ) ).

fof(addAssignment_1179,axiom,
    ! [VarCurr] :
      ( v4085(VarCurr)
    <=> v4087(VarCurr) ) ).

fof(addAssignment_1178,axiom,
    ! [VarCurr] :
      ( v4087(VarCurr)
    <=> v4089(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_94,axiom,
    ! [VarCurr] :
      ( ~ v4093(VarCurr)
     => ( v4089(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_126,axiom,
    ! [VarCurr] :
      ( v4093(VarCurr)
     => ( v4089(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_560,axiom,
    ! [VarCurr] :
      ( v4093(VarCurr)
    <=> ( v4094(VarCurr)
        | v4095(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_251,axiom,
    ! [VarCurr] :
      ( v4095(VarCurr)
    <=> ( ( v4091(VarCurr,bitIndex2)
        <=> $true )
        & ( v4091(VarCurr,bitIndex1)
        <=> $true )
        & ( v4091(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_250,axiom,
    ! [VarCurr] :
      ( v4094(VarCurr)
    <=> ( ( v4091(VarCurr,bitIndex2)
        <=> $true )
        & ( v4091(VarCurr,bitIndex1)
        <=> $true )
        & ( v4091(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignmentInitValueVector_129,axiom,
    ! [B] :
      ( range_2_0(B)
     => ( v4091(constB0,B)
      <=> $false ) ) ).

fof(addCaseBooleanConditionEqualRanges1_43,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4070(VarNext)
       => ( v3359(VarNext)
        <=> v3359(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_44,axiom,
    ! [VarNext] :
      ( v4070(VarNext)
     => ( v3359(VarNext)
      <=> v4078(VarNext) ) ) ).

fof(addAssignment_1177,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4078(VarNext)
      <=> v4076(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_93,axiom,
    ! [VarCurr] :
      ( ~ v4079(VarCurr)
     => ( v4076(VarCurr)
      <=> v3361(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_125,axiom,
    ! [VarCurr] :
      ( v4079(VarCurr)
     => ( v4076(VarCurr)
      <=> $false ) ) ).

fof(writeUnaryOperator_291,axiom,
    ! [VarCurr] :
      ( ~ v4079(VarCurr)
    <=> v2591(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_559,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4070(VarNext)
      <=> v4071(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_558,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4071(VarNext)
      <=> ( v4072(VarNext)
          & v3155(VarNext) ) ) ) ).

fof(writeUnaryOperator_290,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4072(VarNext)
      <=> v3164(VarNext) ) ) ).

fof(addAssignmentInitValueVector_128,axiom,
    ( v3359(constB0)
  <=> $false ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_23,axiom,
    ! [VarCurr] :
      ( ( ~ v4058(VarCurr)
        & ~ v4061(VarCurr) )
     => ( v3361(VarCurr)
      <=> v4065(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_42,axiom,
    ! [VarCurr] :
      ( v4061(VarCurr)
     => ( v3361(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_40,axiom,
    ! [VarCurr] :
      ( v4058(VarCurr)
     => ( v3361(VarCurr)
      <=> v4059(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_557,axiom,
    ! [VarCurr] :
      ( v4065(VarCurr)
    <=> ( v3387(VarCurr)
        & v4066(VarCurr) ) ) ).

fof(writeUnaryOperator_289,axiom,
    ! [VarCurr] :
      ( ~ v4066(VarCurr)
    <=> v4067(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_556,axiom,
    ! [VarCurr] :
      ( v4067(VarCurr)
    <=> ( v3873(VarCurr)
        | v3963(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_555,axiom,
    ! [VarCurr] :
      ( v4062(VarCurr)
    <=> ( v4063(VarCurr)
        | v4064(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_249,axiom,
    ! [VarCurr] :
      ( v4064(VarCurr)
    <=> ( ( v3363(VarCurr,bitIndex1)
        <=> $true )
        & ( v3363(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_248,axiom,
    ! [VarCurr] :
      ( v4063(VarCurr)
    <=> ( ( v3363(VarCurr,bitIndex1)
        <=> $true )
        & ( v3363(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_247,axiom,
    ! [VarCurr] :
      ( v4061(VarCurr)
    <=> ( ( v3363(VarCurr,bitIndex1)
        <=> $false )
        & ( v3363(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_554,axiom,
    ! [VarCurr] :
      ( v4059(VarCurr)
    <=> ( v3387(VarCurr)
        & v4060(VarCurr) ) ) ).

fof(writeUnaryOperator_288,axiom,
    ! [VarCurr] :
      ( ~ v4060(VarCurr)
    <=> v3873(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_246,axiom,
    ! [VarCurr] :
      ( v4058(VarCurr)
    <=> ( ( v3363(VarCurr,bitIndex1)
        <=> $false )
        & ( v3363(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1176,axiom,
    ! [VarCurr] :
      ( v3963(VarCurr)
    <=> v3965(VarCurr) ) ).

fof(addAssignment_1175,axiom,
    ! [VarCurr] :
      ( v3965(VarCurr)
    <=> v3967(VarCurr) ) ).

fof(addAssignment_1174,axiom,
    ! [VarCurr] :
      ( v3967(VarCurr)
    <=> v3969(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_553,axiom,
    ! [VarCurr] :
      ( v3969(VarCurr)
    <=> ( v3993(VarCurr)
        | v4026(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_552,axiom,
    ! [VarCurr] :
      ( v4026(VarCurr)
    <=> ( v4027(VarCurr)
        | v4042(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_551,axiom,
    ! [VarCurr] :
      ( v4042(VarCurr)
    <=> ( v4043(VarCurr)
        | v4050(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_550,axiom,
    ! [VarCurr] :
      ( v4050(VarCurr)
    <=> ( v4051(VarCurr)
        | v4054(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_549,axiom,
    ! [VarCurr] :
      ( v4054(VarCurr)
    <=> ( v4055(VarCurr)
        | v4056(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_235,axiom,
    ! [VarCurr] :
      ( v4056(VarCurr)
    <=> ( v3998(VarCurr,bitIndex62)
        | v3998(VarCurr,bitIndex63) ) ) ).

fof(writeBinaryOperatorShiftedRanges_234,axiom,
    ! [VarCurr] :
      ( v4055(VarCurr)
    <=> ( v3998(VarCurr,bitIndex60)
        | v3998(VarCurr,bitIndex61) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_548,axiom,
    ! [VarCurr] :
      ( v4051(VarCurr)
    <=> ( v4052(VarCurr)
        | v4053(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_233,axiom,
    ! [VarCurr] :
      ( v4053(VarCurr)
    <=> ( v3998(VarCurr,bitIndex58)
        | v3998(VarCurr,bitIndex59) ) ) ).

fof(writeBinaryOperatorShiftedRanges_232,axiom,
    ! [VarCurr] :
      ( v4052(VarCurr)
    <=> ( v3998(VarCurr,bitIndex56)
        | v3998(VarCurr,bitIndex57) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_547,axiom,
    ! [VarCurr] :
      ( v4043(VarCurr)
    <=> ( v4044(VarCurr)
        | v4047(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_546,axiom,
    ! [VarCurr] :
      ( v4047(VarCurr)
    <=> ( v4048(VarCurr)
        | v4049(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_231,axiom,
    ! [VarCurr] :
      ( v4049(VarCurr)
    <=> ( v3998(VarCurr,bitIndex54)
        | v3998(VarCurr,bitIndex55) ) ) ).

fof(writeBinaryOperatorShiftedRanges_230,axiom,
    ! [VarCurr] :
      ( v4048(VarCurr)
    <=> ( v3998(VarCurr,bitIndex52)
        | v3998(VarCurr,bitIndex53) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_545,axiom,
    ! [VarCurr] :
      ( v4044(VarCurr)
    <=> ( v4045(VarCurr)
        | v4046(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_229,axiom,
    ! [VarCurr] :
      ( v4046(VarCurr)
    <=> ( v3998(VarCurr,bitIndex50)
        | v3998(VarCurr,bitIndex51) ) ) ).

fof(writeBinaryOperatorShiftedRanges_228,axiom,
    ! [VarCurr] :
      ( v4045(VarCurr)
    <=> ( v3998(VarCurr,bitIndex48)
        | v3998(VarCurr,bitIndex49) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_544,axiom,
    ! [VarCurr] :
      ( v4027(VarCurr)
    <=> ( v4028(VarCurr)
        | v4035(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_543,axiom,
    ! [VarCurr] :
      ( v4035(VarCurr)
    <=> ( v4036(VarCurr)
        | v4039(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_542,axiom,
    ! [VarCurr] :
      ( v4039(VarCurr)
    <=> ( v4040(VarCurr)
        | v4041(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_227,axiom,
    ! [VarCurr] :
      ( v4041(VarCurr)
    <=> ( v3998(VarCurr,bitIndex46)
        | v3998(VarCurr,bitIndex47) ) ) ).

fof(writeBinaryOperatorShiftedRanges_226,axiom,
    ! [VarCurr] :
      ( v4040(VarCurr)
    <=> ( v3998(VarCurr,bitIndex44)
        | v3998(VarCurr,bitIndex45) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_541,axiom,
    ! [VarCurr] :
      ( v4036(VarCurr)
    <=> ( v4037(VarCurr)
        | v4038(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_225,axiom,
    ! [VarCurr] :
      ( v4038(VarCurr)
    <=> ( v3998(VarCurr,bitIndex42)
        | v3998(VarCurr,bitIndex43) ) ) ).

fof(writeBinaryOperatorShiftedRanges_224,axiom,
    ! [VarCurr] :
      ( v4037(VarCurr)
    <=> ( v3998(VarCurr,bitIndex40)
        | v3998(VarCurr,bitIndex41) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_540,axiom,
    ! [VarCurr] :
      ( v4028(VarCurr)
    <=> ( v4029(VarCurr)
        | v4032(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_539,axiom,
    ! [VarCurr] :
      ( v4032(VarCurr)
    <=> ( v4033(VarCurr)
        | v4034(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_223,axiom,
    ! [VarCurr] :
      ( v4034(VarCurr)
    <=> ( v3998(VarCurr,bitIndex38)
        | v3998(VarCurr,bitIndex39) ) ) ).

fof(writeBinaryOperatorShiftedRanges_222,axiom,
    ! [VarCurr] :
      ( v4033(VarCurr)
    <=> ( v3998(VarCurr,bitIndex36)
        | v3998(VarCurr,bitIndex37) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_538,axiom,
    ! [VarCurr] :
      ( v4029(VarCurr)
    <=> ( v4030(VarCurr)
        | v4031(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_221,axiom,
    ! [VarCurr] :
      ( v4031(VarCurr)
    <=> ( v3998(VarCurr,bitIndex34)
        | v3998(VarCurr,bitIndex35) ) ) ).

fof(writeBinaryOperatorShiftedRanges_220,axiom,
    ! [VarCurr] :
      ( v4030(VarCurr)
    <=> ( v3998(VarCurr,bitIndex32)
        | v3998(VarCurr,bitIndex33) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_537,axiom,
    ! [VarCurr] :
      ( v3993(VarCurr)
    <=> ( v3994(VarCurr)
        | v4011(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_536,axiom,
    ! [VarCurr] :
      ( v4011(VarCurr)
    <=> ( v4012(VarCurr)
        | v4019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_535,axiom,
    ! [VarCurr] :
      ( v4019(VarCurr)
    <=> ( v4020(VarCurr)
        | v4023(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_534,axiom,
    ! [VarCurr] :
      ( v4023(VarCurr)
    <=> ( v4024(VarCurr)
        | v4025(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_219,axiom,
    ! [VarCurr] :
      ( v4025(VarCurr)
    <=> ( v3998(VarCurr,bitIndex30)
        | v3998(VarCurr,bitIndex31) ) ) ).

fof(writeBinaryOperatorShiftedRanges_218,axiom,
    ! [VarCurr] :
      ( v4024(VarCurr)
    <=> ( v3998(VarCurr,bitIndex28)
        | v3998(VarCurr,bitIndex29) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_533,axiom,
    ! [VarCurr] :
      ( v4020(VarCurr)
    <=> ( v4021(VarCurr)
        | v4022(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_217,axiom,
    ! [VarCurr] :
      ( v4022(VarCurr)
    <=> ( v3998(VarCurr,bitIndex26)
        | v3998(VarCurr,bitIndex27) ) ) ).

fof(writeBinaryOperatorShiftedRanges_216,axiom,
    ! [VarCurr] :
      ( v4021(VarCurr)
    <=> ( v3998(VarCurr,bitIndex24)
        | v3998(VarCurr,bitIndex25) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_532,axiom,
    ! [VarCurr] :
      ( v4012(VarCurr)
    <=> ( v4013(VarCurr)
        | v4016(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_531,axiom,
    ! [VarCurr] :
      ( v4016(VarCurr)
    <=> ( v4017(VarCurr)
        | v4018(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_215,axiom,
    ! [VarCurr] :
      ( v4018(VarCurr)
    <=> ( v3998(VarCurr,bitIndex22)
        | v3998(VarCurr,bitIndex23) ) ) ).

fof(writeBinaryOperatorShiftedRanges_214,axiom,
    ! [VarCurr] :
      ( v4017(VarCurr)
    <=> ( v3998(VarCurr,bitIndex20)
        | v3998(VarCurr,bitIndex21) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_530,axiom,
    ! [VarCurr] :
      ( v4013(VarCurr)
    <=> ( v4014(VarCurr)
        | v4015(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_213,axiom,
    ! [VarCurr] :
      ( v4015(VarCurr)
    <=> ( v3998(VarCurr,bitIndex18)
        | v3998(VarCurr,bitIndex19) ) ) ).

fof(writeBinaryOperatorShiftedRanges_212,axiom,
    ! [VarCurr] :
      ( v4014(VarCurr)
    <=> ( v3998(VarCurr,bitIndex16)
        | v3998(VarCurr,bitIndex17) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_529,axiom,
    ! [VarCurr] :
      ( v3994(VarCurr)
    <=> ( v3995(VarCurr)
        | v4004(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_528,axiom,
    ! [VarCurr] :
      ( v4004(VarCurr)
    <=> ( v4005(VarCurr)
        | v4008(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_527,axiom,
    ! [VarCurr] :
      ( v4008(VarCurr)
    <=> ( v4009(VarCurr)
        | v4010(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_211,axiom,
    ! [VarCurr] :
      ( v4010(VarCurr)
    <=> ( v3998(VarCurr,bitIndex14)
        | v3998(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorShiftedRanges_210,axiom,
    ! [VarCurr] :
      ( v4009(VarCurr)
    <=> ( v3998(VarCurr,bitIndex12)
        | v3998(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_526,axiom,
    ! [VarCurr] :
      ( v4005(VarCurr)
    <=> ( v4006(VarCurr)
        | v4007(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_209,axiom,
    ! [VarCurr] :
      ( v4007(VarCurr)
    <=> ( v3998(VarCurr,bitIndex10)
        | v3998(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_208,axiom,
    ! [VarCurr] :
      ( v4006(VarCurr)
    <=> ( v3998(VarCurr,bitIndex8)
        | v3998(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_525,axiom,
    ! [VarCurr] :
      ( v3995(VarCurr)
    <=> ( v3996(VarCurr)
        | v4001(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_524,axiom,
    ! [VarCurr] :
      ( v4001(VarCurr)
    <=> ( v4002(VarCurr)
        | v4003(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_207,axiom,
    ! [VarCurr] :
      ( v4003(VarCurr)
    <=> ( v3998(VarCurr,bitIndex6)
        | v3998(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_206,axiom,
    ! [VarCurr] :
      ( v4002(VarCurr)
    <=> ( v3998(VarCurr,bitIndex4)
        | v3998(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_523,axiom,
    ! [VarCurr] :
      ( v3996(VarCurr)
    <=> ( v3997(VarCurr)
        | v4000(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_205,axiom,
    ! [VarCurr] :
      ( v4000(VarCurr)
    <=> ( v3998(VarCurr,bitIndex2)
        | v3998(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_204,axiom,
    ! [VarCurr] :
      ( v3997(VarCurr)
    <=> ( v3998(VarCurr,bitIndex0)
        | v3998(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_7,axiom,
    ! [VarCurr,B] :
      ( range_63_0(B)
     => ( v3998(VarCurr,B)
      <=> ( v3971(VarCurr,B)
          & v3999(VarCurr,B) ) ) ) ).

fof(writeUnaryOperator_287,axiom,
    ! [VarCurr,B] :
      ( range_63_0(B)
     => ( v3999(VarCurr,B)
      <=> ~ v3990(VarCurr,B) ) ) ).

fof(addAssignmentInitValueVector_127,axiom,
    ! [B] :
      ( range_63_0(B)
     => ( v3990(constB0,B)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_6,axiom,
    ! [VarCurr,B] :
      ( range_63_0(B)
     => ( v3971(VarCurr,B)
      <=> ( v3973(VarCurr,B)
          & v3987(VarCurr,B) ) ) ) ).

fof(addAssignmentInitValueVector_126,axiom,
    ! [B] :
      ( range_63_0(B)
     => ( v3987(constB0,B)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_5,axiom,
    ! [VarCurr,B] :
      ( range_63_0(B)
     => ( v3973(VarCurr,B)
      <=> ( v3975(VarCurr,B)
          & v3977(VarCurr,B) ) ) ) ).

fof(addAssignmentInitValueVector_125,axiom,
    ! [B] :
      ( range_63_0(B)
     => ( v3975(constB0,B)
      <=> $false ) ) ).

fof(bitBlastConstant_1363,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex63) ).

fof(bitBlastConstant_1362,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex62) ).

fof(bitBlastConstant_1361,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex61) ).

fof(bitBlastConstant_1360,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex60) ).

fof(bitBlastConstant_1359,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex59) ).

fof(bitBlastConstant_1358,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex58) ).

fof(bitBlastConstant_1357,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex57) ).

fof(bitBlastConstant_1356,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex56) ).

fof(bitBlastConstant_1355,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex55) ).

fof(bitBlastConstant_1354,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex54) ).

fof(bitBlastConstant_1353,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex53) ).

fof(bitBlastConstant_1352,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex52) ).

fof(bitBlastConstant_1351,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex51) ).

fof(bitBlastConstant_1350,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex50) ).

fof(bitBlastConstant_1349,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex49) ).

fof(bitBlastConstant_1348,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex48) ).

fof(bitBlastConstant_1347,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex47) ).

fof(bitBlastConstant_1346,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex46) ).

fof(bitBlastConstant_1345,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex45) ).

fof(bitBlastConstant_1344,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex44) ).

fof(bitBlastConstant_1343,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex43) ).

fof(bitBlastConstant_1342,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex42) ).

fof(bitBlastConstant_1341,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex41) ).

fof(bitBlastConstant_1340,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex40) ).

fof(bitBlastConstant_1339,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex39) ).

fof(bitBlastConstant_1338,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex38) ).

fof(bitBlastConstant_1337,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex37) ).

fof(bitBlastConstant_1336,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex36) ).

fof(bitBlastConstant_1335,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex35) ).

fof(bitBlastConstant_1334,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex34) ).

fof(bitBlastConstant_1333,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex33) ).

fof(bitBlastConstant_1332,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex32) ).

fof(bitBlastConstant_1331,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex31) ).

fof(bitBlastConstant_1330,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex30) ).

fof(bitBlastConstant_1329,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex29) ).

fof(bitBlastConstant_1328,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex28) ).

fof(bitBlastConstant_1327,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex27) ).

fof(bitBlastConstant_1326,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex26) ).

fof(bitBlastConstant_1325,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex25) ).

fof(bitBlastConstant_1324,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex24) ).

fof(bitBlastConstant_1323,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex23) ).

fof(bitBlastConstant_1322,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex22) ).

fof(bitBlastConstant_1321,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex21) ).

fof(bitBlastConstant_1320,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex20) ).

fof(bitBlastConstant_1319,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex19) ).

fof(bitBlastConstant_1318,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex18) ).

fof(bitBlastConstant_1317,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex17) ).

fof(bitBlastConstant_1316,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex16) ).

fof(bitBlastConstant_1315,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex15) ).

fof(bitBlastConstant_1314,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex14) ).

fof(bitBlastConstant_1313,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex13) ).

fof(bitBlastConstant_1312,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex12) ).

fof(bitBlastConstant_1311,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex11) ).

fof(bitBlastConstant_1310,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex10) ).

fof(bitBlastConstant_1309,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex9) ).

fof(bitBlastConstant_1308,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex8) ).

fof(bitBlastConstant_1307,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex7) ).

fof(bitBlastConstant_1306,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex6) ).

fof(bitBlastConstant_1305,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex5) ).

fof(bitBlastConstant_1304,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex4) ).

fof(bitBlastConstant_1303,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex3) ).

fof(bitBlastConstant_1302,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex2) ).

fof(bitBlastConstant_1301,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex1) ).

fof(bitBlastConstant_1300,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex0) ).

fof(addAssignment_1173,axiom,
    ! [VarCurr,B] :
      ( range_63_0(B)
     => ( v3977(VarCurr,B)
      <=> v3979(VarCurr,B) ) ) ).

fof(addAssignment_1172,axiom,
    ! [VarCurr,B] :
      ( range_63_0(B)
     => ( v3979(VarCurr,B)
      <=> v3981(VarCurr,B) ) ) ).

fof(addAssignment_1171,axiom,
    ! [VarCurr,B] :
      ( range_63_0(B)
     => ( v3981(VarCurr,B)
      <=> v3983(VarCurr,B) ) ) ).

fof(range_axiom_32,axiom,
    ! [B] :
      ( range_63_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B
        | bitIndex30 = B
        | bitIndex31 = B
        | bitIndex32 = B
        | bitIndex33 = B
        | bitIndex34 = B
        | bitIndex35 = B
        | bitIndex36 = B
        | bitIndex37 = B
        | bitIndex38 = B
        | bitIndex39 = B
        | bitIndex40 = B
        | bitIndex41 = B
        | bitIndex42 = B
        | bitIndex43 = B
        | bitIndex44 = B
        | bitIndex45 = B
        | bitIndex46 = B
        | bitIndex47 = B
        | bitIndex48 = B
        | bitIndex49 = B
        | bitIndex50 = B
        | bitIndex51 = B
        | bitIndex52 = B
        | bitIndex53 = B
        | bitIndex54 = B
        | bitIndex55 = B
        | bitIndex56 = B
        | bitIndex57 = B
        | bitIndex58 = B
        | bitIndex59 = B
        | bitIndex60 = B
        | bitIndex61 = B
        | bitIndex62 = B
        | bitIndex63 = B ) ) ).

fof(addAssignmentInitValueVector_124,axiom,
    ( v3983(constB0,bitIndex63)
  <=> $false ) ).

fof(addAssignmentInitValueVector_123,axiom,
    ( v3983(constB0,bitIndex62)
  <=> $false ) ).

fof(addAssignmentInitValueVector_122,axiom,
    ( v3983(constB0,bitIndex61)
  <=> $false ) ).

fof(addAssignmentInitValueVector_121,axiom,
    ( v3983(constB0,bitIndex60)
  <=> $false ) ).

fof(addAssignmentInitValueVector_120,axiom,
    ( v3983(constB0,bitIndex59)
  <=> $false ) ).

fof(addAssignmentInitValueVector_119,axiom,
    ( v3983(constB0,bitIndex58)
  <=> $false ) ).

fof(addAssignmentInitValueVector_118,axiom,
    ( v3983(constB0,bitIndex57)
  <=> $false ) ).

fof(addAssignmentInitValueVector_117,axiom,
    ( v3983(constB0,bitIndex56)
  <=> $false ) ).

fof(addAssignmentInitValueVector_116,axiom,
    ( v3983(constB0,bitIndex55)
  <=> $false ) ).

fof(addAssignmentInitValueVector_115,axiom,
    ( v3983(constB0,bitIndex54)
  <=> $false ) ).

fof(addAssignmentInitValueVector_114,axiom,
    ( v3983(constB0,bitIndex53)
  <=> $false ) ).

fof(addAssignmentInitValueVector_113,axiom,
    ( v3983(constB0,bitIndex52)
  <=> $false ) ).

fof(addAssignmentInitValueVector_112,axiom,
    ( v3983(constB0,bitIndex51)
  <=> $false ) ).

fof(addAssignmentInitValueVector_111,axiom,
    ( v3983(constB0,bitIndex50)
  <=> $false ) ).

fof(addAssignmentInitValueVector_110,axiom,
    ( v3983(constB0,bitIndex49)
  <=> $false ) ).

fof(addAssignmentInitValueVector_109,axiom,
    ( v3983(constB0,bitIndex48)
  <=> $false ) ).

fof(addAssignmentInitValueVector_108,axiom,
    ( v3983(constB0,bitIndex47)
  <=> $false ) ).

fof(addAssignmentInitValueVector_107,axiom,
    ( v3983(constB0,bitIndex46)
  <=> $false ) ).

fof(addAssignmentInitValueVector_106,axiom,
    ( v3983(constB0,bitIndex45)
  <=> $false ) ).

fof(addAssignmentInitValueVector_105,axiom,
    ( v3983(constB0,bitIndex44)
  <=> $false ) ).

fof(addAssignmentInitValueVector_104,axiom,
    ( v3983(constB0,bitIndex43)
  <=> $false ) ).

fof(addAssignmentInitValueVector_103,axiom,
    ( v3983(constB0,bitIndex42)
  <=> $false ) ).

fof(addAssignmentInitValueVector_102,axiom,
    ( v3983(constB0,bitIndex41)
  <=> $false ) ).

fof(addAssignmentInitValueVector_101,axiom,
    ( v3983(constB0,bitIndex40)
  <=> $false ) ).

fof(addAssignmentInitValueVector_100,axiom,
    ( v3983(constB0,bitIndex39)
  <=> $false ) ).

fof(addAssignmentInitValueVector_99,axiom,
    ( v3983(constB0,bitIndex38)
  <=> $false ) ).

fof(addAssignmentInitValueVector_98,axiom,
    ( v3983(constB0,bitIndex37)
  <=> $false ) ).

fof(addAssignmentInitValueVector_97,axiom,
    ( v3983(constB0,bitIndex36)
  <=> $false ) ).

fof(addAssignmentInitValueVector_96,axiom,
    ( v3983(constB0,bitIndex35)
  <=> $false ) ).

fof(addAssignmentInitValueVector_95,axiom,
    ( v3983(constB0,bitIndex34)
  <=> $false ) ).

fof(addAssignmentInitValueVector_94,axiom,
    ( v3983(constB0,bitIndex33)
  <=> $false ) ).

fof(addAssignmentInitValueVector_93,axiom,
    ( v3983(constB0,bitIndex32)
  <=> $false ) ).

fof(addAssignmentInitValueVector_92,axiom,
    ( v3983(constB0,bitIndex31)
  <=> $false ) ).

fof(addAssignmentInitValueVector_91,axiom,
    ( v3983(constB0,bitIndex30)
  <=> $false ) ).

fof(addAssignmentInitValueVector_90,axiom,
    ( v3983(constB0,bitIndex29)
  <=> $false ) ).

fof(addAssignmentInitValueVector_89,axiom,
    ( v3983(constB0,bitIndex28)
  <=> $false ) ).

fof(addAssignmentInitValueVector_88,axiom,
    ( v3983(constB0,bitIndex27)
  <=> $false ) ).

fof(addAssignmentInitValueVector_87,axiom,
    ( v3983(constB0,bitIndex26)
  <=> $false ) ).

fof(addAssignmentInitValueVector_86,axiom,
    ( v3983(constB0,bitIndex25)
  <=> $false ) ).

fof(addAssignmentInitValueVector_85,axiom,
    ( v3983(constB0,bitIndex24)
  <=> $false ) ).

fof(addAssignmentInitValueVector_84,axiom,
    ( v3983(constB0,bitIndex23)
  <=> $false ) ).

fof(addAssignmentInitValueVector_83,axiom,
    ( v3983(constB0,bitIndex22)
  <=> $false ) ).

fof(addAssignmentInitValueVector_82,axiom,
    ( v3983(constB0,bitIndex21)
  <=> $false ) ).

fof(addAssignmentInitValueVector_81,axiom,
    ( v3983(constB0,bitIndex20)
  <=> $false ) ).

fof(addAssignmentInitValueVector_80,axiom,
    ( v3983(constB0,bitIndex19)
  <=> $false ) ).

fof(addAssignmentInitValueVector_79,axiom,
    ( v3983(constB0,bitIndex18)
  <=> $false ) ).

fof(addAssignmentInitValueVector_78,axiom,
    ( v3983(constB0,bitIndex17)
  <=> $false ) ).

fof(addAssignmentInitValueVector_77,axiom,
    ( v3983(constB0,bitIndex16)
  <=> $false ) ).

fof(addAssignmentInitValueVector_76,axiom,
    ( v3983(constB0,bitIndex15)
  <=> $false ) ).

fof(addAssignmentInitValueVector_75,axiom,
    ( v3983(constB0,bitIndex14)
  <=> $false ) ).

fof(addAssignmentInitValueVector_74,axiom,
    ( v3983(constB0,bitIndex13)
  <=> $false ) ).

fof(addAssignmentInitValueVector_73,axiom,
    ( v3983(constB0,bitIndex12)
  <=> $false ) ).

fof(addAssignmentInitValueVector_72,axiom,
    ( v3983(constB0,bitIndex11)
  <=> $false ) ).

fof(addAssignmentInitValueVector_71,axiom,
    ( v3983(constB0,bitIndex10)
  <=> $false ) ).

fof(addAssignmentInitValueVector_70,axiom,
    ( v3983(constB0,bitIndex9)
  <=> $false ) ).

fof(addAssignmentInitValueVector_69,axiom,
    ( v3983(constB0,bitIndex8)
  <=> $false ) ).

fof(addAssignmentInitValueVector_68,axiom,
    ( v3983(constB0,bitIndex7)
  <=> $false ) ).

fof(addAssignmentInitValueVector_67,axiom,
    ( v3983(constB0,bitIndex6)
  <=> $false ) ).

fof(addAssignmentInitValueVector_66,axiom,
    ( v3983(constB0,bitIndex5)
  <=> $false ) ).

fof(addAssignmentInitValueVector_65,axiom,
    ( v3983(constB0,bitIndex4)
  <=> $false ) ).

fof(addAssignmentInitValueVector_64,axiom,
    ( v3983(constB0,bitIndex3)
  <=> $false ) ).

fof(addAssignmentInitValueVector_63,axiom,
    ( v3983(constB0,bitIndex2)
  <=> $false ) ).

fof(addAssignmentInitValueVector_62,axiom,
    ( v3983(constB0,bitIndex1)
  <=> $false ) ).

fof(addAssignmentInitValueVector_61,axiom,
    ( v3983(constB0,bitIndex0)
  <=> $false ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_522,axiom,
    ! [VarCurr] :
      ( v3873(VarCurr)
    <=> ( v3875(VarCurr)
        & v3954(VarCurr) ) ) ).

fof(addAssignment_1170,axiom,
    ! [VarCurr] :
      ( v3954(VarCurr)
    <=> v3956(VarCurr) ) ).

fof(addAssignment_1169,axiom,
    ! [VarCurr] :
      ( v3956(VarCurr)
    <=> v3958(VarCurr) ) ).

fof(addAssignment_1168,axiom,
    ! [VarCurr] :
      ( v3958(VarCurr)
    <=> v3960(VarCurr) ) ).

fof(addAssignmentInitValueVector_60,axiom,
    ( v3960(constB0)
  <=> $false ) ).

fof(addAssignment_1167,axiom,
    ! [VarCurr] :
      ( v3875(VarCurr)
    <=> v3877(VarCurr) ) ).

fof(addAssignment_1166,axiom,
    ! [VarCurr] :
      ( v3877(VarCurr)
    <=> v3879(VarCurr) ) ).

fof(addAssignment_1165,axiom,
    ! [VarCurr] :
      ( v3879(VarCurr)
    <=> v3881(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_92,axiom,
    ! [VarCurr] :
      ( ~ v3883(VarCurr)
     => ( v3881(VarCurr)
      <=> v3952(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_124,axiom,
    ! [VarCurr] :
      ( v3883(VarCurr)
     => ( v3881(VarCurr)
      <=> v3948(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_245,axiom,
    ! [VarCurr] :
      ( v3952(VarCurr)
    <=> ( ( v3885(VarCurr,bitIndex23)
        <=> v3887(VarCurr,bitIndex23) )
        & ( v3885(VarCurr,bitIndex22)
        <=> v3887(VarCurr,bitIndex22) )
        & ( v3885(VarCurr,bitIndex21)
        <=> v3887(VarCurr,bitIndex21) )
        & ( v3885(VarCurr,bitIndex20)
        <=> v3887(VarCurr,bitIndex20) )
        & ( v3885(VarCurr,bitIndex19)
        <=> v3887(VarCurr,bitIndex19) )
        & ( v3885(VarCurr,bitIndex18)
        <=> v3887(VarCurr,bitIndex18) )
        & ( v3885(VarCurr,bitIndex17)
        <=> v3887(VarCurr,bitIndex17) )
        & ( v3885(VarCurr,bitIndex16)
        <=> v3887(VarCurr,bitIndex16) )
        & ( v3885(VarCurr,bitIndex15)
        <=> v3887(VarCurr,bitIndex15) )
        & ( v3885(VarCurr,bitIndex14)
        <=> v3887(VarCurr,bitIndex14) )
        & ( v3885(VarCurr,bitIndex13)
        <=> v3887(VarCurr,bitIndex13) )
        & ( v3885(VarCurr,bitIndex12)
        <=> v3887(VarCurr,bitIndex12) )
        & ( v3885(VarCurr,bitIndex11)
        <=> v3887(VarCurr,bitIndex11) )
        & ( v3885(VarCurr,bitIndex10)
        <=> v3887(VarCurr,bitIndex10) )
        & ( v3885(VarCurr,bitIndex9)
        <=> v3887(VarCurr,bitIndex9) )
        & ( v3885(VarCurr,bitIndex8)
        <=> v3887(VarCurr,bitIndex8) )
        & ( v3885(VarCurr,bitIndex7)
        <=> v3887(VarCurr,bitIndex7) )
        & ( v3885(VarCurr,bitIndex6)
        <=> v3887(VarCurr,bitIndex6) )
        & ( v3885(VarCurr,bitIndex5)
        <=> v3887(VarCurr,bitIndex5) )
        & ( v3885(VarCurr,bitIndex4)
        <=> v3887(VarCurr,bitIndex4) )
        & ( v3885(VarCurr,bitIndex3)
        <=> v3887(VarCurr,bitIndex3) )
        & ( v3885(VarCurr,bitIndex2)
        <=> v3887(VarCurr,bitIndex2) )
        & ( v3885(VarCurr,bitIndex1)
        <=> v3887(VarCurr,bitIndex1) )
        & ( v3885(VarCurr,bitIndex0)
        <=> v3887(VarCurr,bitIndex0) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_521,axiom,
    ! [VarCurr] :
      ( v3948(VarCurr)
    <=> ( v3949(VarCurr)
        & v3951(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_244,axiom,
    ! [VarCurr] :
      ( v3951(VarCurr)
    <=> ( ( v3936(VarCurr,bitIndex4)
        <=> v3938(VarCurr,bitIndex4) )
        & ( v3936(VarCurr,bitIndex3)
        <=> v3938(VarCurr,bitIndex3) )
        & ( v3936(VarCurr,bitIndex2)
        <=> v3938(VarCurr,bitIndex2) )
        & ( v3936(VarCurr,bitIndex1)
        <=> v3938(VarCurr,bitIndex1) )
        & ( v3936(VarCurr,bitIndex0)
        <=> v3938(VarCurr,bitIndex0) ) ) ) ).

fof(addAssignmentInitValueVector_59,axiom,
    ! [B] :
      ( range_4_0(B)
     => ( v3936(constB0,B)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_243,axiom,
    ! [VarCurr] :
      ( v3949(VarCurr)
    <=> ( ( v3885(VarCurr,bitIndex23)
        <=> v3887(VarCurr,bitIndex23) )
        & ( v3885(VarCurr,bitIndex22)
        <=> v3887(VarCurr,bitIndex22) )
        & ( v3885(VarCurr,bitIndex21)
        <=> v3887(VarCurr,bitIndex21) )
        & ( v3885(VarCurr,bitIndex20)
        <=> v3887(VarCurr,bitIndex20) )
        & ( v3885(VarCurr,bitIndex19)
        <=> v3887(VarCurr,bitIndex19) )
        & ( v3885(VarCurr,bitIndex18)
        <=> v3887(VarCurr,bitIndex18) )
        & ( v3885(VarCurr,bitIndex17)
        <=> v3887(VarCurr,bitIndex17) )
        & ( v3885(VarCurr,bitIndex16)
        <=> v3887(VarCurr,bitIndex16) )
        & ( v3885(VarCurr,bitIndex15)
        <=> v3887(VarCurr,bitIndex15) )
        & ( v3885(VarCurr,bitIndex14)
        <=> v3887(VarCurr,bitIndex14) )
        & ( v3885(VarCurr,bitIndex13)
        <=> v3887(VarCurr,bitIndex13) )
        & ( v3885(VarCurr,bitIndex12)
        <=> v3887(VarCurr,bitIndex12) )
        & ( v3885(VarCurr,bitIndex11)
        <=> v3887(VarCurr,bitIndex11) )
        & ( v3885(VarCurr,bitIndex10)
        <=> v3887(VarCurr,bitIndex10) )
        & ( v3885(VarCurr,bitIndex9)
        <=> v3887(VarCurr,bitIndex9) )
        & ( v3885(VarCurr,bitIndex8)
        <=> v3887(VarCurr,bitIndex8) )
        & ( v3885(VarCurr,bitIndex7)
        <=> v3887(VarCurr,bitIndex7) )
        & ( v3885(VarCurr,bitIndex6)
        <=> v3887(VarCurr,bitIndex6) )
        & ( v3885(VarCurr,bitIndex5)
        <=> v3887(VarCurr,bitIndex5) )
        & ( v3885(VarCurr,bitIndex4)
        <=> v3887(VarCurr,bitIndex4) )
        & ( v3885(VarCurr,bitIndex3)
        <=> v3887(VarCurr,bitIndex3) )
        & ( v3885(VarCurr,bitIndex2)
        <=> v3887(VarCurr,bitIndex2) )
        & ( v3885(VarCurr,bitIndex1)
        <=> v3887(VarCurr,bitIndex1) )
        & ( v3885(VarCurr,bitIndex0)
        <=> v3887(VarCurr,bitIndex0) ) ) ) ).

fof(addAssignmentInitValueVector_58,axiom,
    ! [B] :
      ( range_23_0(B)
     => ( v3885(constB0,B)
      <=> $false ) ) ).

fof(bitBlastConstant_1299,axiom,
    ~ b000000000000000000000000(bitIndex23) ).

fof(bitBlastConstant_1298,axiom,
    ~ b000000000000000000000000(bitIndex22) ).

fof(bitBlastConstant_1297,axiom,
    ~ b000000000000000000000000(bitIndex21) ).

fof(bitBlastConstant_1296,axiom,
    ~ b000000000000000000000000(bitIndex20) ).

fof(bitBlastConstant_1295,axiom,
    ~ b000000000000000000000000(bitIndex19) ).

fof(bitBlastConstant_1294,axiom,
    ~ b000000000000000000000000(bitIndex18) ).

fof(bitBlastConstant_1293,axiom,
    ~ b000000000000000000000000(bitIndex17) ).

fof(bitBlastConstant_1292,axiom,
    ~ b000000000000000000000000(bitIndex16) ).

fof(bitBlastConstant_1291,axiom,
    ~ b000000000000000000000000(bitIndex15) ).

fof(bitBlastConstant_1290,axiom,
    ~ b000000000000000000000000(bitIndex14) ).

fof(bitBlastConstant_1289,axiom,
    ~ b000000000000000000000000(bitIndex13) ).

fof(bitBlastConstant_1288,axiom,
    ~ b000000000000000000000000(bitIndex12) ).

fof(bitBlastConstant_1287,axiom,
    ~ b000000000000000000000000(bitIndex11) ).

fof(bitBlastConstant_1286,axiom,
    ~ b000000000000000000000000(bitIndex10) ).

fof(bitBlastConstant_1285,axiom,
    ~ b000000000000000000000000(bitIndex9) ).

fof(bitBlastConstant_1284,axiom,
    ~ b000000000000000000000000(bitIndex8) ).

fof(bitBlastConstant_1283,axiom,
    ~ b000000000000000000000000(bitIndex7) ).

fof(bitBlastConstant_1282,axiom,
    ~ b000000000000000000000000(bitIndex6) ).

fof(bitBlastConstant_1281,axiom,
    ~ b000000000000000000000000(bitIndex5) ).

fof(bitBlastConstant_1280,axiom,
    ~ b000000000000000000000000(bitIndex4) ).

fof(bitBlastConstant_1279,axiom,
    ~ b000000000000000000000000(bitIndex3) ).

fof(bitBlastConstant_1278,axiom,
    ~ b000000000000000000000000(bitIndex2) ).

fof(bitBlastConstant_1277,axiom,
    ~ b000000000000000000000000(bitIndex1) ).

fof(bitBlastConstant_1276,axiom,
    ~ b000000000000000000000000(bitIndex0) ).

fof(addAssignment_1164,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v3938(VarCurr,B)
      <=> v3940(VarCurr,B) ) ) ).

fof(addAssignment_1163,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v3940(VarCurr,B)
      <=> v3942(VarCurr,B) ) ) ).

fof(addAssignment_1162,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v3942(VarCurr,B)
      <=> v3944(VarCurr,B) ) ) ).

fof(addAssignment_1161,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v3944(VarCurr,B)
      <=> v3946(VarCurr,B) ) ) ).

fof(addAssignmentInitValueVector_57,axiom,
    ! [B] :
      ( range_4_0(B)
     => ( v3946(constB0,B)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_91,axiom,
    ! [VarCurr] :
      ( ~ v3932(VarCurr)
     => ! [B] :
          ( range_23_3(B)
         => ( v3887(VarCurr,B)
          <=> v3905(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_4,axiom,
    ! [VarCurr] :
      ( v3932(VarCurr)
     => ( ( v3887(VarCurr,bitIndex23)
        <=> v3897(VarCurr,bitIndex37) )
        & ( v3887(VarCurr,bitIndex22)
        <=> v3897(VarCurr,bitIndex36) )
        & ( v3887(VarCurr,bitIndex21)
        <=> v3897(VarCurr,bitIndex35) )
        & ( v3887(VarCurr,bitIndex20)
        <=> v3897(VarCurr,bitIndex34) )
        & ( v3887(VarCurr,bitIndex19)
        <=> v3897(VarCurr,bitIndex33) )
        & ( v3887(VarCurr,bitIndex18)
        <=> v3897(VarCurr,bitIndex32) )
        & ( v3887(VarCurr,bitIndex17)
        <=> v3897(VarCurr,bitIndex31) )
        & ( v3887(VarCurr,bitIndex16)
        <=> v3897(VarCurr,bitIndex30) )
        & ( v3887(VarCurr,bitIndex15)
        <=> v3897(VarCurr,bitIndex29) )
        & ( v3887(VarCurr,bitIndex14)
        <=> v3897(VarCurr,bitIndex28) )
        & ( v3887(VarCurr,bitIndex13)
        <=> v3897(VarCurr,bitIndex27) )
        & ( v3887(VarCurr,bitIndex12)
        <=> v3897(VarCurr,bitIndex26) )
        & ( v3887(VarCurr,bitIndex11)
        <=> v3897(VarCurr,bitIndex25) )
        & ( v3887(VarCurr,bitIndex10)
        <=> v3897(VarCurr,bitIndex24) )
        & ( v3887(VarCurr,bitIndex9)
        <=> v3897(VarCurr,bitIndex23) )
        & ( v3887(VarCurr,bitIndex8)
        <=> v3897(VarCurr,bitIndex22) )
        & ( v3887(VarCurr,bitIndex7)
        <=> v3897(VarCurr,bitIndex21) )
        & ( v3887(VarCurr,bitIndex6)
        <=> v3897(VarCurr,bitIndex20) )
        & ( v3887(VarCurr,bitIndex5)
        <=> v3897(VarCurr,bitIndex19) )
        & ( v3887(VarCurr,bitIndex4)
        <=> v3897(VarCurr,bitIndex18) )
        & ( v3887(VarCurr,bitIndex3)
        <=> v3897(VarCurr,bitIndex17) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_90,axiom,
    ! [VarCurr] :
      ( ~ v3932(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3887(VarCurr,B)
          <=> v3905(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_123,axiom,
    ! [VarCurr] :
      ( v3932(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3887(VarCurr,B)
          <=> v3933(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_36,axiom,
    ! [VarCurr] :
      ( ~ v3889(VarCurr)
     => ( ( v3933(VarCurr,bitIndex2)
        <=> v3897(VarCurr,bitIndex16) )
        & ( v3933(VarCurr,bitIndex1)
        <=> v3897(VarCurr,bitIndex15) )
        & ( v3933(VarCurr,bitIndex0)
        <=> v3897(VarCurr,bitIndex14) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_122,axiom,
    ! [VarCurr] :
      ( v3889(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3933(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_286,axiom,
    ! [VarCurr] :
      ( ~ v3932(VarCurr)
    <=> v3883(VarCurr) ) ).

fof(addAssignment_1160,axiom,
    ! [VarCurr,B] :
      ( range_23_3(B)
     => ( v3905(VarCurr,B)
      <=> v3918(VarCurr,B) ) ) ).

fof(range_axiom_31,axiom,
    ! [B] :
      ( range_23_3(B)
    <=> ( $false
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B ) ) ).

fof(addAssignment_1159,axiom,
    ! [VarCurr,B] :
      ( range_37_17(B)
     => ( v3897(VarCurr,B)
      <=> v3899(VarCurr,B) ) ) ).

fof(addAssignment_1158,axiom,
    ! [VarCurr,B] :
      ( range_37_17(B)
     => ( v3899(VarCurr,B)
      <=> v3901(VarCurr,B) ) ) ).

fof(addAssignment_1157,axiom,
    ! [VarCurr,B] :
      ( range_37_17(B)
     => ( v3901(VarCurr,B)
      <=> v3903(VarCurr,B) ) ) ).

fof(addAssignment_1156,axiom,
    ! [VarCurr,B] :
      ( range_37_17(B)
     => ( v3903(VarCurr,B)
      <=> v3474(VarCurr,B) ) ) ).

fof(range_axiom_30,axiom,
    ! [B] :
      ( range_37_17(B)
    <=> ( $false
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B
        | bitIndex30 = B
        | bitIndex31 = B
        | bitIndex32 = B
        | bitIndex33 = B
        | bitIndex34 = B
        | bitIndex35 = B
        | bitIndex36 = B
        | bitIndex37 = B ) ) ).

fof(addAssignment_1155,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v3905(VarCurr,B)
      <=> v3918(VarCurr,B) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges7_1,axiom,
    ! [VarCurr] :
      ( ( ~ v3919(VarCurr)
        & ~ v3920(VarCurr)
        & ~ v3922(VarCurr)
        & ~ v3923(VarCurr)
        & ~ v3925(VarCurr)
        & ~ v3926(VarCurr)
        & ~ v3928(VarCurr) )
     => ( ( v3918(VarCurr,bitIndex23)
        <=> v3897(VarCurr,bitIndex37) )
        & ( v3918(VarCurr,bitIndex22)
        <=> v3897(VarCurr,bitIndex36) )
        & ( v3918(VarCurr,bitIndex21)
        <=> v3897(VarCurr,bitIndex35) )
        & ( v3918(VarCurr,bitIndex20)
        <=> v3897(VarCurr,bitIndex34) )
        & ( v3918(VarCurr,bitIndex19)
        <=> v3897(VarCurr,bitIndex33) )
        & ( v3918(VarCurr,bitIndex18)
        <=> v3897(VarCurr,bitIndex32) )
        & ( v3918(VarCurr,bitIndex17)
        <=> v3897(VarCurr,bitIndex31) )
        & ( v3918(VarCurr,bitIndex16)
        <=> v3897(VarCurr,bitIndex30) )
        & ( v3918(VarCurr,bitIndex15)
        <=> v3897(VarCurr,bitIndex29) )
        & ( v3918(VarCurr,bitIndex14)
        <=> v3897(VarCurr,bitIndex28) )
        & ( v3918(VarCurr,bitIndex13)
        <=> v3897(VarCurr,bitIndex27) )
        & ( v3918(VarCurr,bitIndex12)
        <=> v3897(VarCurr,bitIndex26) )
        & ( v3918(VarCurr,bitIndex11)
        <=> v3897(VarCurr,bitIndex25) )
        & ( v3918(VarCurr,bitIndex10)
        <=> v3897(VarCurr,bitIndex24) )
        & ( v3918(VarCurr,bitIndex9)
        <=> v3897(VarCurr,bitIndex23) )
        & ( v3918(VarCurr,bitIndex8)
        <=> v3897(VarCurr,bitIndex22) )
        & ( v3918(VarCurr,bitIndex7)
        <=> v3897(VarCurr,bitIndex21) )
        & ( v3918(VarCurr,bitIndex6)
        <=> v3897(VarCurr,bitIndex20) )
        & ( v3918(VarCurr,bitIndex5)
        <=> v3897(VarCurr,bitIndex19) )
        & ( v3918(VarCurr,bitIndex4)
        <=> v3897(VarCurr,bitIndex18) )
        & ( v3918(VarCurr,bitIndex3)
        <=> v3897(VarCurr,bitIndex17) )
        & ( v3918(VarCurr,bitIndex2)
        <=> v3897(VarCurr,bitIndex16) )
        & ( v3918(VarCurr,bitIndex1)
        <=> v3897(VarCurr,bitIndex15) )
        & ( v3918(VarCurr,bitIndex0)
        <=> v3897(VarCurr,bitIndex14) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges6_1,axiom,
    ! [VarCurr] :
      ( v3928(VarCurr)
     => ( ( v3918(VarCurr,bitIndex23)
        <=> v3897(VarCurr,bitIndex37) )
        & ( v3918(VarCurr,bitIndex22)
        <=> v3897(VarCurr,bitIndex36) )
        & ( v3918(VarCurr,bitIndex21)
        <=> v3897(VarCurr,bitIndex35) )
        & ( v3918(VarCurr,bitIndex20)
        <=> v3897(VarCurr,bitIndex34) )
        & ( v3918(VarCurr,bitIndex19)
        <=> v3897(VarCurr,bitIndex33) )
        & ( v3918(VarCurr,bitIndex18)
        <=> v3897(VarCurr,bitIndex32) )
        & ( v3918(VarCurr,bitIndex17)
        <=> v3897(VarCurr,bitIndex31) )
        & ( v3918(VarCurr,bitIndex16)
        <=> v3897(VarCurr,bitIndex30) )
        & ( v3918(VarCurr,bitIndex15)
        <=> v3897(VarCurr,bitIndex29) )
        & ( v3918(VarCurr,bitIndex14)
        <=> v3897(VarCurr,bitIndex28) )
        & ( v3918(VarCurr,bitIndex13)
        <=> v3897(VarCurr,bitIndex27) )
        & ( v3918(VarCurr,bitIndex12)
        <=> v3897(VarCurr,bitIndex26) )
        & ( v3918(VarCurr,bitIndex11)
        <=> v3897(VarCurr,bitIndex25) )
        & ( v3918(VarCurr,bitIndex10)
        <=> v3897(VarCurr,bitIndex24) )
        & ( v3918(VarCurr,bitIndex9)
        <=> v3897(VarCurr,bitIndex23) )
        & ( v3918(VarCurr,bitIndex8)
        <=> v3897(VarCurr,bitIndex22) )
        & ( v3918(VarCurr,bitIndex7)
        <=> v3897(VarCurr,bitIndex21) )
        & ( v3918(VarCurr,bitIndex6)
        <=> v3897(VarCurr,bitIndex20) )
        & ( v3918(VarCurr,bitIndex5)
        <=> v3897(VarCurr,bitIndex19) )
        & ( v3918(VarCurr,bitIndex4)
        <=> v3897(VarCurr,bitIndex18) )
        & ( v3918(VarCurr,bitIndex3)
        <=> v3897(VarCurr,bitIndex17) )
        & ( v3918(VarCurr,bitIndex2)
        <=> v3897(VarCurr,bitIndex16) )
        & ( v3918(VarCurr,bitIndex1)
        <=> v3897(VarCurr,bitIndex15) )
        & ( v3918(VarCurr,bitIndex0)
        <=> v3897(VarCurr,bitIndex14) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges5_3,axiom,
    ! [VarCurr] :
      ( v3926(VarCurr)
     => ! [B] :
          ( range_23_0(B)
         => ( v3918(VarCurr,B)
          <=> v3927(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges4_2,axiom,
    ! [VarCurr] :
      ( v3925(VarCurr)
     => ( ( v3918(VarCurr,bitIndex23)
        <=> v3897(VarCurr,bitIndex37) )
        & ( v3918(VarCurr,bitIndex22)
        <=> v3897(VarCurr,bitIndex36) )
        & ( v3918(VarCurr,bitIndex21)
        <=> v3897(VarCurr,bitIndex35) )
        & ( v3918(VarCurr,bitIndex20)
        <=> v3897(VarCurr,bitIndex34) )
        & ( v3918(VarCurr,bitIndex19)
        <=> v3897(VarCurr,bitIndex33) )
        & ( v3918(VarCurr,bitIndex18)
        <=> v3897(VarCurr,bitIndex32) )
        & ( v3918(VarCurr,bitIndex17)
        <=> v3897(VarCurr,bitIndex31) )
        & ( v3918(VarCurr,bitIndex16)
        <=> v3897(VarCurr,bitIndex30) )
        & ( v3918(VarCurr,bitIndex15)
        <=> v3897(VarCurr,bitIndex29) )
        & ( v3918(VarCurr,bitIndex14)
        <=> v3897(VarCurr,bitIndex28) )
        & ( v3918(VarCurr,bitIndex13)
        <=> v3897(VarCurr,bitIndex27) )
        & ( v3918(VarCurr,bitIndex12)
        <=> v3897(VarCurr,bitIndex26) )
        & ( v3918(VarCurr,bitIndex11)
        <=> v3897(VarCurr,bitIndex25) )
        & ( v3918(VarCurr,bitIndex10)
        <=> v3897(VarCurr,bitIndex24) )
        & ( v3918(VarCurr,bitIndex9)
        <=> v3897(VarCurr,bitIndex23) )
        & ( v3918(VarCurr,bitIndex8)
        <=> v3897(VarCurr,bitIndex22) )
        & ( v3918(VarCurr,bitIndex7)
        <=> v3897(VarCurr,bitIndex21) )
        & ( v3918(VarCurr,bitIndex6)
        <=> v3897(VarCurr,bitIndex20) )
        & ( v3918(VarCurr,bitIndex5)
        <=> v3897(VarCurr,bitIndex19) )
        & ( v3918(VarCurr,bitIndex4)
        <=> v3897(VarCurr,bitIndex18) )
        & ( v3918(VarCurr,bitIndex3)
        <=> v3897(VarCurr,bitIndex17) )
        & ( v3918(VarCurr,bitIndex2)
        <=> v3897(VarCurr,bitIndex16) )
        & ( v3918(VarCurr,bitIndex1)
        <=> v3897(VarCurr,bitIndex15) )
        & ( v3918(VarCurr,bitIndex0)
        <=> v3897(VarCurr,bitIndex14) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_13,axiom,
    ! [VarCurr] :
      ( v3923(VarCurr)
     => ! [B] :
          ( range_23_0(B)
         => ( v3918(VarCurr,B)
          <=> v3924(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges2_2,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( ( v3918(VarCurr,bitIndex23)
        <=> v3897(VarCurr,bitIndex37) )
        & ( v3918(VarCurr,bitIndex22)
        <=> v3897(VarCurr,bitIndex36) )
        & ( v3918(VarCurr,bitIndex21)
        <=> v3897(VarCurr,bitIndex35) )
        & ( v3918(VarCurr,bitIndex20)
        <=> v3897(VarCurr,bitIndex34) )
        & ( v3918(VarCurr,bitIndex19)
        <=> v3897(VarCurr,bitIndex33) )
        & ( v3918(VarCurr,bitIndex18)
        <=> v3897(VarCurr,bitIndex32) )
        & ( v3918(VarCurr,bitIndex17)
        <=> v3897(VarCurr,bitIndex31) )
        & ( v3918(VarCurr,bitIndex16)
        <=> v3897(VarCurr,bitIndex30) )
        & ( v3918(VarCurr,bitIndex15)
        <=> v3897(VarCurr,bitIndex29) )
        & ( v3918(VarCurr,bitIndex14)
        <=> v3897(VarCurr,bitIndex28) )
        & ( v3918(VarCurr,bitIndex13)
        <=> v3897(VarCurr,bitIndex27) )
        & ( v3918(VarCurr,bitIndex12)
        <=> v3897(VarCurr,bitIndex26) )
        & ( v3918(VarCurr,bitIndex11)
        <=> v3897(VarCurr,bitIndex25) )
        & ( v3918(VarCurr,bitIndex10)
        <=> v3897(VarCurr,bitIndex24) )
        & ( v3918(VarCurr,bitIndex9)
        <=> v3897(VarCurr,bitIndex23) )
        & ( v3918(VarCurr,bitIndex8)
        <=> v3897(VarCurr,bitIndex22) )
        & ( v3918(VarCurr,bitIndex7)
        <=> v3897(VarCurr,bitIndex21) )
        & ( v3918(VarCurr,bitIndex6)
        <=> v3897(VarCurr,bitIndex20) )
        & ( v3918(VarCurr,bitIndex5)
        <=> v3897(VarCurr,bitIndex19) )
        & ( v3918(VarCurr,bitIndex4)
        <=> v3897(VarCurr,bitIndex18) )
        & ( v3918(VarCurr,bitIndex3)
        <=> v3897(VarCurr,bitIndex17) )
        & ( v3918(VarCurr,bitIndex2)
        <=> v3897(VarCurr,bitIndex16) )
        & ( v3918(VarCurr,bitIndex1)
        <=> v3897(VarCurr,bitIndex15) )
        & ( v3918(VarCurr,bitIndex0)
        <=> v3897(VarCurr,bitIndex14) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_41,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ! [B] :
          ( range_23_0(B)
         => ( v3918(VarCurr,B)
          <=> v3921(VarCurr,B) ) ) ) ).

fof(range_axiom_29,axiom,
    ! [B] :
      ( range_23_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_4,axiom,
    ! [VarCurr] :
      ( v3919(VarCurr)
     => ( ( v3918(VarCurr,bitIndex23)
        <=> v3897(VarCurr,bitIndex37) )
        & ( v3918(VarCurr,bitIndex22)
        <=> v3897(VarCurr,bitIndex36) )
        & ( v3918(VarCurr,bitIndex21)
        <=> v3897(VarCurr,bitIndex35) )
        & ( v3918(VarCurr,bitIndex20)
        <=> v3897(VarCurr,bitIndex34) )
        & ( v3918(VarCurr,bitIndex19)
        <=> v3897(VarCurr,bitIndex33) )
        & ( v3918(VarCurr,bitIndex18)
        <=> v3897(VarCurr,bitIndex32) )
        & ( v3918(VarCurr,bitIndex17)
        <=> v3897(VarCurr,bitIndex31) )
        & ( v3918(VarCurr,bitIndex16)
        <=> v3897(VarCurr,bitIndex30) )
        & ( v3918(VarCurr,bitIndex15)
        <=> v3897(VarCurr,bitIndex29) )
        & ( v3918(VarCurr,bitIndex14)
        <=> v3897(VarCurr,bitIndex28) )
        & ( v3918(VarCurr,bitIndex13)
        <=> v3897(VarCurr,bitIndex27) )
        & ( v3918(VarCurr,bitIndex12)
        <=> v3897(VarCurr,bitIndex26) )
        & ( v3918(VarCurr,bitIndex11)
        <=> v3897(VarCurr,bitIndex25) )
        & ( v3918(VarCurr,bitIndex10)
        <=> v3897(VarCurr,bitIndex24) )
        & ( v3918(VarCurr,bitIndex9)
        <=> v3897(VarCurr,bitIndex23) )
        & ( v3918(VarCurr,bitIndex8)
        <=> v3897(VarCurr,bitIndex22) )
        & ( v3918(VarCurr,bitIndex7)
        <=> v3897(VarCurr,bitIndex21) )
        & ( v3918(VarCurr,bitIndex6)
        <=> v3897(VarCurr,bitIndex20) )
        & ( v3918(VarCurr,bitIndex5)
        <=> v3897(VarCurr,bitIndex19) )
        & ( v3918(VarCurr,bitIndex4)
        <=> v3897(VarCurr,bitIndex18) )
        & ( v3918(VarCurr,bitIndex3)
        <=> v3897(VarCurr,bitIndex17) )
        & ( v3918(VarCurr,bitIndex2)
        <=> v3897(VarCurr,bitIndex16) )
        & ( v3918(VarCurr,bitIndex1)
        <=> v3897(VarCurr,bitIndex15) )
        & ( v3918(VarCurr,bitIndex0)
        <=> v3897(VarCurr,bitIndex14) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_520,axiom,
    ! [VarCurr] :
      ( v3928(VarCurr)
    <=> ( v3929(VarCurr)
        | v3930(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_242,axiom,
    ! [VarCurr] :
      ( v3930(VarCurr)
    <=> ( ( v3907(VarCurr,bitIndex2)
        <=> $true )
        & ( v3907(VarCurr,bitIndex1)
        <=> $true )
        & ( v3907(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_241,axiom,
    ! [VarCurr] :
      ( v3929(VarCurr)
    <=> ( ( v3907(VarCurr,bitIndex2)
        <=> $true )
        & ( v3907(VarCurr,bitIndex1)
        <=> $true )
        & ( v3907(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1154,axiom,
    ! [VarCurr,B] :
      ( range_14_0(B)
     => ( v3927(VarCurr,B)
      <=> $false ) ) ).

fof(bitBlastConstant_1275,axiom,
    ~ b000000000000000(bitIndex14) ).

fof(bitBlastConstant_1274,axiom,
    ~ b000000000000000(bitIndex13) ).

fof(bitBlastConstant_1273,axiom,
    ~ b000000000000000(bitIndex12) ).

fof(bitBlastConstant_1272,axiom,
    ~ b000000000000000(bitIndex11) ).

fof(bitBlastConstant_1271,axiom,
    ~ b000000000000000(bitIndex10) ).

fof(bitBlastConstant_1270,axiom,
    ~ b000000000000000(bitIndex9) ).

fof(bitBlastConstant_1269,axiom,
    ~ b000000000000000(bitIndex8) ).

fof(bitBlastConstant_1268,axiom,
    ~ b000000000000000(bitIndex7) ).

fof(bitBlastConstant_1267,axiom,
    ~ b000000000000000(bitIndex6) ).

fof(bitBlastConstant_1266,axiom,
    ~ b000000000000000(bitIndex5) ).

fof(bitBlastConstant_1265,axiom,
    ~ b000000000000000(bitIndex4) ).

fof(bitBlastConstant_1264,axiom,
    ~ b000000000000000(bitIndex3) ).

fof(bitBlastConstant_1263,axiom,
    ~ b000000000000000(bitIndex2) ).

fof(bitBlastConstant_1262,axiom,
    ~ b000000000000000(bitIndex1) ).

fof(bitBlastConstant_1261,axiom,
    ~ b000000000000000(bitIndex0) ).

fof(addAssignment_1153,axiom,
    ! [VarCurr] :
      ( ( v3927(VarCurr,bitIndex23)
      <=> v3897(VarCurr,bitIndex37) )
      & ( v3927(VarCurr,bitIndex22)
      <=> v3897(VarCurr,bitIndex36) )
      & ( v3927(VarCurr,bitIndex21)
      <=> v3897(VarCurr,bitIndex35) )
      & ( v3927(VarCurr,bitIndex20)
      <=> v3897(VarCurr,bitIndex34) )
      & ( v3927(VarCurr,bitIndex19)
      <=> v3897(VarCurr,bitIndex33) )
      & ( v3927(VarCurr,bitIndex18)
      <=> v3897(VarCurr,bitIndex32) )
      & ( v3927(VarCurr,bitIndex17)
      <=> v3897(VarCurr,bitIndex31) )
      & ( v3927(VarCurr,bitIndex16)
      <=> v3897(VarCurr,bitIndex30) )
      & ( v3927(VarCurr,bitIndex15)
      <=> v3897(VarCurr,bitIndex29) ) ) ).

fof(addBitVectorEqualityBitBlasted_240,axiom,
    ! [VarCurr] :
      ( v3926(VarCurr)
    <=> ( ( v3907(VarCurr,bitIndex2)
        <=> $true )
        & ( v3907(VarCurr,bitIndex1)
        <=> $false )
        & ( v3907(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_239,axiom,
    ! [VarCurr] :
      ( v3925(VarCurr)
    <=> ( ( v3907(VarCurr,bitIndex2)
        <=> $true )
        & ( v3907(VarCurr,bitIndex1)
        <=> $false )
        & ( v3907(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1152,axiom,
    ! [VarCurr,B] :
      ( range_8_0(B)
     => ( v3924(VarCurr,B)
      <=> $false ) ) ).

fof(range_axiom_28,axiom,
    ! [B] :
      ( range_8_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B ) ) ).

fof(bitBlastConstant_1260,axiom,
    ~ b000000000(bitIndex8) ).

fof(bitBlastConstant_1259,axiom,
    ~ b000000000(bitIndex7) ).

fof(bitBlastConstant_1258,axiom,
    ~ b000000000(bitIndex6) ).

fof(bitBlastConstant_1257,axiom,
    ~ b000000000(bitIndex5) ).

fof(bitBlastConstant_1256,axiom,
    ~ b000000000(bitIndex4) ).

fof(bitBlastConstant_1255,axiom,
    ~ b000000000(bitIndex3) ).

fof(bitBlastConstant_1254,axiom,
    ~ b000000000(bitIndex2) ).

fof(bitBlastConstant_1253,axiom,
    ~ b000000000(bitIndex1) ).

fof(bitBlastConstant_1252,axiom,
    ~ b000000000(bitIndex0) ).

fof(addAssignment_1151,axiom,
    ! [VarCurr] :
      ( ( v3924(VarCurr,bitIndex23)
      <=> v3897(VarCurr,bitIndex37) )
      & ( v3924(VarCurr,bitIndex22)
      <=> v3897(VarCurr,bitIndex36) )
      & ( v3924(VarCurr,bitIndex21)
      <=> v3897(VarCurr,bitIndex35) )
      & ( v3924(VarCurr,bitIndex20)
      <=> v3897(VarCurr,bitIndex34) )
      & ( v3924(VarCurr,bitIndex19)
      <=> v3897(VarCurr,bitIndex33) )
      & ( v3924(VarCurr,bitIndex18)
      <=> v3897(VarCurr,bitIndex32) )
      & ( v3924(VarCurr,bitIndex17)
      <=> v3897(VarCurr,bitIndex31) )
      & ( v3924(VarCurr,bitIndex16)
      <=> v3897(VarCurr,bitIndex30) )
      & ( v3924(VarCurr,bitIndex15)
      <=> v3897(VarCurr,bitIndex29) )
      & ( v3924(VarCurr,bitIndex14)
      <=> v3897(VarCurr,bitIndex28) )
      & ( v3924(VarCurr,bitIndex13)
      <=> v3897(VarCurr,bitIndex27) )
      & ( v3924(VarCurr,bitIndex12)
      <=> v3897(VarCurr,bitIndex26) )
      & ( v3924(VarCurr,bitIndex11)
      <=> v3897(VarCurr,bitIndex25) )
      & ( v3924(VarCurr,bitIndex10)
      <=> v3897(VarCurr,bitIndex24) )
      & ( v3924(VarCurr,bitIndex9)
      <=> v3897(VarCurr,bitIndex23) ) ) ).

fof(addBitVectorEqualityBitBlasted_238,axiom,
    ! [VarCurr] :
      ( v3923(VarCurr)
    <=> ( ( v3907(VarCurr,bitIndex2)
        <=> $false )
        & ( v3907(VarCurr,bitIndex1)
        <=> $true )
        & ( v3907(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_237,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
    <=> ( ( v3907(VarCurr,bitIndex2)
        <=> $false )
        & ( v3907(VarCurr,bitIndex1)
        <=> $true )
        & ( v3907(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1150,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v3921(VarCurr,B)
      <=> $false ) ) ).

fof(addAssignment_1149,axiom,
    ! [VarCurr] :
      ( ( v3921(VarCurr,bitIndex23)
      <=> v3897(VarCurr,bitIndex37) )
      & ( v3921(VarCurr,bitIndex22)
      <=> v3897(VarCurr,bitIndex36) )
      & ( v3921(VarCurr,bitIndex21)
      <=> v3897(VarCurr,bitIndex35) )
      & ( v3921(VarCurr,bitIndex20)
      <=> v3897(VarCurr,bitIndex34) )
      & ( v3921(VarCurr,bitIndex19)
      <=> v3897(VarCurr,bitIndex33) )
      & ( v3921(VarCurr,bitIndex18)
      <=> v3897(VarCurr,bitIndex32) )
      & ( v3921(VarCurr,bitIndex17)
      <=> v3897(VarCurr,bitIndex31) )
      & ( v3921(VarCurr,bitIndex16)
      <=> v3897(VarCurr,bitIndex30) )
      & ( v3921(VarCurr,bitIndex15)
      <=> v3897(VarCurr,bitIndex29) )
      & ( v3921(VarCurr,bitIndex14)
      <=> v3897(VarCurr,bitIndex28) )
      & ( v3921(VarCurr,bitIndex13)
      <=> v3897(VarCurr,bitIndex27) )
      & ( v3921(VarCurr,bitIndex12)
      <=> v3897(VarCurr,bitIndex26) )
      & ( v3921(VarCurr,bitIndex11)
      <=> v3897(VarCurr,bitIndex25) )
      & ( v3921(VarCurr,bitIndex10)
      <=> v3897(VarCurr,bitIndex24) )
      & ( v3921(VarCurr,bitIndex9)
      <=> v3897(VarCurr,bitIndex23) )
      & ( v3921(VarCurr,bitIndex8)
      <=> v3897(VarCurr,bitIndex22) )
      & ( v3921(VarCurr,bitIndex7)
      <=> v3897(VarCurr,bitIndex21) )
      & ( v3921(VarCurr,bitIndex6)
      <=> v3897(VarCurr,bitIndex20) )
      & ( v3921(VarCurr,bitIndex5)
      <=> v3897(VarCurr,bitIndex19) )
      & ( v3921(VarCurr,bitIndex4)
      <=> v3897(VarCurr,bitIndex18) )
      & ( v3921(VarCurr,bitIndex3)
      <=> v3897(VarCurr,bitIndex17) ) ) ).

fof(addBitVectorEqualityBitBlasted_236,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
    <=> ( ( v3907(VarCurr,bitIndex2)
        <=> $false )
        & ( v3907(VarCurr,bitIndex1)
        <=> $false )
        & ( v3907(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_235,axiom,
    ! [VarCurr] :
      ( v3919(VarCurr)
    <=> ( ( v3907(VarCurr,bitIndex2)
        <=> $false )
        & ( v3907(VarCurr,bitIndex1)
        <=> $false )
        & ( v3907(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1148,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v3907(VarCurr,B)
      <=> v3909(VarCurr,B) ) ) ).

fof(addAssignment_1147,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v3909(VarCurr,B)
      <=> v3911(VarCurr,B) ) ) ).

fof(addAssignment_1146,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v3911(VarCurr,B)
      <=> v3913(VarCurr,B) ) ) ).

fof(addAssignment_1145,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v3913(VarCurr,B)
      <=> v3915(VarCurr,B) ) ) ).

fof(addAssignmentInitValueVector_56,axiom,
    ! [B] :
      ( range_2_0(B)
     => ( v3915(constB0,B)
      <=> $false ) ) ).

fof(addAssignment_1144,axiom,
    ! [VarCurr,B] :
      ( range_16_14(B)
     => ( v3897(VarCurr,B)
      <=> v3899(VarCurr,B) ) ) ).

fof(addAssignment_1143,axiom,
    ! [VarCurr,B] :
      ( range_16_14(B)
     => ( v3899(VarCurr,B)
      <=> v3901(VarCurr,B) ) ) ).

fof(addAssignment_1142,axiom,
    ! [VarCurr,B] :
      ( range_16_14(B)
     => ( v3901(VarCurr,B)
      <=> v3903(VarCurr,B) ) ) ).

fof(addAssignment_1141,axiom,
    ! [VarCurr,B] :
      ( range_16_14(B)
     => ( v3903(VarCurr,B)
      <=> v3474(VarCurr,B) ) ) ).

fof(range_axiom_27,axiom,
    ! [B] :
      ( range_16_14(B)
    <=> ( $false
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B ) ) ).

fof(addAssignment_1140,axiom,
    ! [VarCurr] :
      ( v3889(VarCurr)
    <=> v3891(VarCurr) ) ).

fof(addAssignment_1139,axiom,
    ! [VarCurr] :
      ( v3891(VarCurr)
    <=> v3893(VarCurr) ) ).

fof(addAssignment_1138,axiom,
    ! [VarCurr] :
      ( v3893(VarCurr)
    <=> v3895(VarCurr) ) ).

fof(addAssignment_1137,axiom,
    ! [VarCurr] :
      ( v3895(VarCurr)
    <=> v3411(VarCurr) ) ).

fof(addAssignment_1136,axiom,
    ! [VarCurr] :
      ( v3883(VarCurr)
    <=> v183(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_519,axiom,
    ! [VarCurr] :
      ( v3387(VarCurr)
    <=> ( v3859(VarCurr)
        & v3861(VarCurr) ) ) ).

fof(writeUnaryOperator_285,axiom,
    ! [VarCurr] :
      ( ~ v3861(VarCurr)
    <=> v3862(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_518,axiom,
    ! [VarCurr] :
      ( v3862(VarCurr)
    <=> ( v3863(VarCurr)
        | v3865(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_517,axiom,
    ! [VarCurr] :
      ( v3865(VarCurr)
    <=> ( v3866(VarCurr)
        | v3845(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_516,axiom,
    ! [VarCurr] :
      ( v3866(VarCurr)
    <=> ( v3867(VarCurr)
        | v3548(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_203,axiom,
    ! [VarCurr] :
      ( v3867(VarCurr)
    <=> ( v3868(VarCurr)
        | v3546(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_202,axiom,
    ! [VarCurr] :
      ( v3868(VarCurr)
    <=> ( v3869(VarCurr)
        | v3546(VarCurr,bitIndex16) ) ) ).

fof(writeBinaryOperatorShiftedRanges_201,axiom,
    ! [VarCurr] :
      ( v3869(VarCurr)
    <=> ( v3546(VarCurr,bitIndex18)
        | v3546(VarCurr,bitIndex17) ) ) ).

fof(addAssignmentInitValue_242,axiom,
    ~ v3546(constB0,bitIndex18) ).

fof(addAssignmentInitValue_241,axiom,
    ~ v3546(constB0,bitIndex17) ).

fof(addAssignmentInitValue_240,axiom,
    ~ v3546(constB0,bitIndex16) ).

fof(addAssignmentInitValue_239,axiom,
    ~ v3546(constB0,bitIndex2) ).

fof(bitBlastConstant_1251,axiom,
    ~ bxx000xxxxxxxxxxxxx0xx(bitIndex18) ).

fof(bitBlastConstant_1250,axiom,
    ~ bxx000xxxxxxxxxxxxx0xx(bitIndex17) ).

fof(bitBlastConstant_1249,axiom,
    ~ bxx000xxxxxxxxxxxxx0xx(bitIndex16) ).

fof(bitBlastConstant_1248,axiom,
    ~ bxx000xxxxxxxxxxxxx0xx(bitIndex2) ).

fof(writeBinaryOperatorShiftedRanges_200,axiom,
    ! [VarCurr] :
      ( v3863(VarCurr)
    <=> ( v3391(VarCurr,bitIndex1)
        & v3864(VarCurr) ) ) ).

fof(writeUnaryOperator_284,axiom,
    ! [VarCurr] :
      ( ~ v3864(VarCurr)
    <=> v3542(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_199,axiom,
    ! [VarCurr] :
      ( v3859(VarCurr)
    <=> ( v3389(VarCurr,bitIndex1)
        & v3860(VarCurr) ) ) ).

fof(writeUnaryOperator_283,axiom,
    ! [VarCurr] :
      ( ~ v3860(VarCurr)
    <=> v2587(VarCurr,bitIndex1) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_515,axiom,
    ! [VarCurr] :
      ( v3845(VarCurr)
    <=> ( v3856(VarCurr)
        & v3847(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_198,axiom,
    ! [VarCurr] :
      ( v3856(VarCurr)
    <=> ( v3389(VarCurr,bitIndex1)
        & v3857(VarCurr) ) ) ).

fof(writeUnaryOperator_282,axiom,
    ! [VarCurr] :
      ( ~ v3857(VarCurr)
    <=> v2587(VarCurr,bitIndex1) ) ).

fof(addAssignment_1135,axiom,
    ! [VarCurr] :
      ( v3847(VarCurr)
    <=> v3849(VarCurr) ) ).

fof(addAssignment_1134,axiom,
    ! [VarCurr] :
      ( v3849(VarCurr)
    <=> v3851(VarCurr) ) ).

fof(addAssignment_1133,axiom,
    ! [VarCurr] :
      ( v3851(VarCurr)
    <=> v3853(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_197,axiom,
    ! [VarCurr] :
      ( v3853(VarCurr)
    <=> ( v3560(VarCurr,bitIndex27)
        & v3535(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_514,axiom,
    ! [VarCurr] :
      ( v3548(VarCurr)
    <=> ( v3842(VarCurr)
        & v3550(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_196,axiom,
    ! [VarCurr] :
      ( v3842(VarCurr)
    <=> ( v3389(VarCurr,bitIndex1)
        & v3843(VarCurr) ) ) ).

fof(writeUnaryOperator_281,axiom,
    ! [VarCurr] :
      ( ~ v3843(VarCurr)
    <=> v2587(VarCurr,bitIndex1) ) ).

fof(addAssignmentInitValueVector_55,axiom,
    ( v3389(constB0,bitIndex1)
  <=> $false ) ).

fof(addAssignment_1132,axiom,
    ! [VarCurr] :
      ( v3550(VarCurr)
    <=> v3552(VarCurr) ) ).

fof(addAssignment_1131,axiom,
    ! [VarCurr] :
      ( v3552(VarCurr)
    <=> v3554(VarCurr) ) ).

fof(addAssignment_1130,axiom,
    ! [VarCurr] :
      ( v3554(VarCurr)
    <=> v3556(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_513,axiom,
    ! [VarCurr] :
      ( v3556(VarCurr)
    <=> ( v3558(VarCurr)
        & v3535(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_89,axiom,
    ! [VarCurr] :
      ( ~ v3601(VarCurr)
     => ( v3558(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_121,axiom,
    ! [VarCurr] :
      ( v3601(VarCurr)
     => ( v3558(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_512,axiom,
    ! [VarCurr] :
      ( v3601(VarCurr)
    <=> ( v3603(VarCurr)
        | v3839(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_195,axiom,
    ! [VarCurr] :
      ( v3839(VarCurr)
    <=> ( v3836(VarCurr)
        & v3562(VarCurr,bitIndex26) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_511,axiom,
    ! [VarCurr] :
      ( v3603(VarCurr)
    <=> ( v3604(VarCurr)
        & v3833(VarCurr) ) ) ).

fof(writeUnaryOperator_280,axiom,
    ! [VarCurr] :
      ( ~ v3833(VarCurr)
    <=> v3834(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_510,axiom,
    ! [VarCurr] :
      ( v3834(VarCurr)
    <=> ( v3835(VarCurr)
        & v3838(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_194,axiom,
    ! [VarCurr] :
      ( v3838(VarCurr)
    <=> ( v3560(VarCurr,bitIndex26)
        | v3562(VarCurr,bitIndex26) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_509,axiom,
    ! [VarCurr] :
      ( v3835(VarCurr)
    <=> ( v3836(VarCurr)
        | v3837(VarCurr) ) ) ).

fof(writeUnaryOperator_279,axiom,
    ! [VarCurr] :
      ( ~ v3837(VarCurr)
    <=> v3562(VarCurr,bitIndex26) ) ).

fof(writeUnaryOperator_278,axiom,
    ! [VarCurr] :
      ( ~ v3836(VarCurr)
    <=> v3560(VarCurr,bitIndex26) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_508,axiom,
    ! [VarCurr] :
      ( v3604(VarCurr)
    <=> ( v3605(VarCurr)
        | v3832(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_193,axiom,
    ! [VarCurr] :
      ( v3832(VarCurr)
    <=> ( v3829(VarCurr)
        & v3562(VarCurr,bitIndex25) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_507,axiom,
    ! [VarCurr] :
      ( v3605(VarCurr)
    <=> ( v3606(VarCurr)
        & v3826(VarCurr) ) ) ).

fof(writeUnaryOperator_277,axiom,
    ! [VarCurr] :
      ( ~ v3826(VarCurr)
    <=> v3827(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_506,axiom,
    ! [VarCurr] :
      ( v3827(VarCurr)
    <=> ( v3828(VarCurr)
        & v3831(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_192,axiom,
    ! [VarCurr] :
      ( v3831(VarCurr)
    <=> ( v3560(VarCurr,bitIndex25)
        | v3562(VarCurr,bitIndex25) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_505,axiom,
    ! [VarCurr] :
      ( v3828(VarCurr)
    <=> ( v3829(VarCurr)
        | v3830(VarCurr) ) ) ).

fof(writeUnaryOperator_276,axiom,
    ! [VarCurr] :
      ( ~ v3830(VarCurr)
    <=> v3562(VarCurr,bitIndex25) ) ).

fof(writeUnaryOperator_275,axiom,
    ! [VarCurr] :
      ( ~ v3829(VarCurr)
    <=> v3560(VarCurr,bitIndex25) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_504,axiom,
    ! [VarCurr] :
      ( v3606(VarCurr)
    <=> ( v3607(VarCurr)
        | v3825(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_191,axiom,
    ! [VarCurr] :
      ( v3825(VarCurr)
    <=> ( v3822(VarCurr)
        & v3562(VarCurr,bitIndex24) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_503,axiom,
    ! [VarCurr] :
      ( v3607(VarCurr)
    <=> ( v3608(VarCurr)
        & v3819(VarCurr) ) ) ).

fof(writeUnaryOperator_274,axiom,
    ! [VarCurr] :
      ( ~ v3819(VarCurr)
    <=> v3820(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_502,axiom,
    ! [VarCurr] :
      ( v3820(VarCurr)
    <=> ( v3821(VarCurr)
        & v3824(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_190,axiom,
    ! [VarCurr] :
      ( v3824(VarCurr)
    <=> ( v3560(VarCurr,bitIndex24)
        | v3562(VarCurr,bitIndex24) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_501,axiom,
    ! [VarCurr] :
      ( v3821(VarCurr)
    <=> ( v3822(VarCurr)
        | v3823(VarCurr) ) ) ).

fof(writeUnaryOperator_273,axiom,
    ! [VarCurr] :
      ( ~ v3823(VarCurr)
    <=> v3562(VarCurr,bitIndex24) ) ).

fof(writeUnaryOperator_272,axiom,
    ! [VarCurr] :
      ( ~ v3822(VarCurr)
    <=> v3560(VarCurr,bitIndex24) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_500,axiom,
    ! [VarCurr] :
      ( v3608(VarCurr)
    <=> ( v3609(VarCurr)
        | v3818(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_189,axiom,
    ! [VarCurr] :
      ( v3818(VarCurr)
    <=> ( v3815(VarCurr)
        & v3562(VarCurr,bitIndex23) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_499,axiom,
    ! [VarCurr] :
      ( v3609(VarCurr)
    <=> ( v3610(VarCurr)
        & v3812(VarCurr) ) ) ).

fof(writeUnaryOperator_271,axiom,
    ! [VarCurr] :
      ( ~ v3812(VarCurr)
    <=> v3813(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_498,axiom,
    ! [VarCurr] :
      ( v3813(VarCurr)
    <=> ( v3814(VarCurr)
        & v3817(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_188,axiom,
    ! [VarCurr] :
      ( v3817(VarCurr)
    <=> ( v3560(VarCurr,bitIndex23)
        | v3562(VarCurr,bitIndex23) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_497,axiom,
    ! [VarCurr] :
      ( v3814(VarCurr)
    <=> ( v3815(VarCurr)
        | v3816(VarCurr) ) ) ).

fof(writeUnaryOperator_270,axiom,
    ! [VarCurr] :
      ( ~ v3816(VarCurr)
    <=> v3562(VarCurr,bitIndex23) ) ).

fof(writeUnaryOperator_269,axiom,
    ! [VarCurr] :
      ( ~ v3815(VarCurr)
    <=> v3560(VarCurr,bitIndex23) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_496,axiom,
    ! [VarCurr] :
      ( v3610(VarCurr)
    <=> ( v3611(VarCurr)
        | v3811(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_187,axiom,
    ! [VarCurr] :
      ( v3811(VarCurr)
    <=> ( v3808(VarCurr)
        & v3562(VarCurr,bitIndex22) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_495,axiom,
    ! [VarCurr] :
      ( v3611(VarCurr)
    <=> ( v3612(VarCurr)
        & v3805(VarCurr) ) ) ).

fof(writeUnaryOperator_268,axiom,
    ! [VarCurr] :
      ( ~ v3805(VarCurr)
    <=> v3806(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_494,axiom,
    ! [VarCurr] :
      ( v3806(VarCurr)
    <=> ( v3807(VarCurr)
        & v3810(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_186,axiom,
    ! [VarCurr] :
      ( v3810(VarCurr)
    <=> ( v3560(VarCurr,bitIndex22)
        | v3562(VarCurr,bitIndex22) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_493,axiom,
    ! [VarCurr] :
      ( v3807(VarCurr)
    <=> ( v3808(VarCurr)
        | v3809(VarCurr) ) ) ).

fof(writeUnaryOperator_267,axiom,
    ! [VarCurr] :
      ( ~ v3809(VarCurr)
    <=> v3562(VarCurr,bitIndex22) ) ).

fof(writeUnaryOperator_266,axiom,
    ! [VarCurr] :
      ( ~ v3808(VarCurr)
    <=> v3560(VarCurr,bitIndex22) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_492,axiom,
    ! [VarCurr] :
      ( v3612(VarCurr)
    <=> ( v3613(VarCurr)
        | v3804(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_185,axiom,
    ! [VarCurr] :
      ( v3804(VarCurr)
    <=> ( v3801(VarCurr)
        & v3562(VarCurr,bitIndex21) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_491,axiom,
    ! [VarCurr] :
      ( v3613(VarCurr)
    <=> ( v3614(VarCurr)
        & v3798(VarCurr) ) ) ).

fof(writeUnaryOperator_265,axiom,
    ! [VarCurr] :
      ( ~ v3798(VarCurr)
    <=> v3799(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_490,axiom,
    ! [VarCurr] :
      ( v3799(VarCurr)
    <=> ( v3800(VarCurr)
        & v3803(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_184,axiom,
    ! [VarCurr] :
      ( v3803(VarCurr)
    <=> ( v3560(VarCurr,bitIndex21)
        | v3562(VarCurr,bitIndex21) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_489,axiom,
    ! [VarCurr] :
      ( v3800(VarCurr)
    <=> ( v3801(VarCurr)
        | v3802(VarCurr) ) ) ).

fof(writeUnaryOperator_264,axiom,
    ! [VarCurr] :
      ( ~ v3802(VarCurr)
    <=> v3562(VarCurr,bitIndex21) ) ).

fof(writeUnaryOperator_263,axiom,
    ! [VarCurr] :
      ( ~ v3801(VarCurr)
    <=> v3560(VarCurr,bitIndex21) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_488,axiom,
    ! [VarCurr] :
      ( v3614(VarCurr)
    <=> ( v3615(VarCurr)
        | v3797(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_183,axiom,
    ! [VarCurr] :
      ( v3797(VarCurr)
    <=> ( v3794(VarCurr)
        & v3562(VarCurr,bitIndex20) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_487,axiom,
    ! [VarCurr] :
      ( v3615(VarCurr)
    <=> ( v3616(VarCurr)
        & v3791(VarCurr) ) ) ).

fof(writeUnaryOperator_262,axiom,
    ! [VarCurr] :
      ( ~ v3791(VarCurr)
    <=> v3792(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_486,axiom,
    ! [VarCurr] :
      ( v3792(VarCurr)
    <=> ( v3793(VarCurr)
        & v3796(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_182,axiom,
    ! [VarCurr] :
      ( v3796(VarCurr)
    <=> ( v3560(VarCurr,bitIndex20)
        | v3562(VarCurr,bitIndex20) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_485,axiom,
    ! [VarCurr] :
      ( v3793(VarCurr)
    <=> ( v3794(VarCurr)
        | v3795(VarCurr) ) ) ).

fof(writeUnaryOperator_261,axiom,
    ! [VarCurr] :
      ( ~ v3795(VarCurr)
    <=> v3562(VarCurr,bitIndex20) ) ).

fof(writeUnaryOperator_260,axiom,
    ! [VarCurr] :
      ( ~ v3794(VarCurr)
    <=> v3560(VarCurr,bitIndex20) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_484,axiom,
    ! [VarCurr] :
      ( v3616(VarCurr)
    <=> ( v3617(VarCurr)
        | v3790(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_181,axiom,
    ! [VarCurr] :
      ( v3790(VarCurr)
    <=> ( v3787(VarCurr)
        & v3562(VarCurr,bitIndex19) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_483,axiom,
    ! [VarCurr] :
      ( v3617(VarCurr)
    <=> ( v3618(VarCurr)
        & v3784(VarCurr) ) ) ).

fof(writeUnaryOperator_259,axiom,
    ! [VarCurr] :
      ( ~ v3784(VarCurr)
    <=> v3785(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_482,axiom,
    ! [VarCurr] :
      ( v3785(VarCurr)
    <=> ( v3786(VarCurr)
        & v3789(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_180,axiom,
    ! [VarCurr] :
      ( v3789(VarCurr)
    <=> ( v3560(VarCurr,bitIndex19)
        | v3562(VarCurr,bitIndex19) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_481,axiom,
    ! [VarCurr] :
      ( v3786(VarCurr)
    <=> ( v3787(VarCurr)
        | v3788(VarCurr) ) ) ).

fof(writeUnaryOperator_258,axiom,
    ! [VarCurr] :
      ( ~ v3788(VarCurr)
    <=> v3562(VarCurr,bitIndex19) ) ).

fof(writeUnaryOperator_257,axiom,
    ! [VarCurr] :
      ( ~ v3787(VarCurr)
    <=> v3560(VarCurr,bitIndex19) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_480,axiom,
    ! [VarCurr] :
      ( v3618(VarCurr)
    <=> ( v3619(VarCurr)
        | v3783(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_179,axiom,
    ! [VarCurr] :
      ( v3783(VarCurr)
    <=> ( v3780(VarCurr)
        & v3562(VarCurr,bitIndex18) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_479,axiom,
    ! [VarCurr] :
      ( v3619(VarCurr)
    <=> ( v3620(VarCurr)
        & v3777(VarCurr) ) ) ).

fof(writeUnaryOperator_256,axiom,
    ! [VarCurr] :
      ( ~ v3777(VarCurr)
    <=> v3778(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_478,axiom,
    ! [VarCurr] :
      ( v3778(VarCurr)
    <=> ( v3779(VarCurr)
        & v3782(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_178,axiom,
    ! [VarCurr] :
      ( v3782(VarCurr)
    <=> ( v3560(VarCurr,bitIndex18)
        | v3562(VarCurr,bitIndex18) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_477,axiom,
    ! [VarCurr] :
      ( v3779(VarCurr)
    <=> ( v3780(VarCurr)
        | v3781(VarCurr) ) ) ).

fof(writeUnaryOperator_255,axiom,
    ! [VarCurr] :
      ( ~ v3781(VarCurr)
    <=> v3562(VarCurr,bitIndex18) ) ).

fof(writeUnaryOperator_254,axiom,
    ! [VarCurr] :
      ( ~ v3780(VarCurr)
    <=> v3560(VarCurr,bitIndex18) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_476,axiom,
    ! [VarCurr] :
      ( v3620(VarCurr)
    <=> ( v3621(VarCurr)
        | v3776(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_177,axiom,
    ! [VarCurr] :
      ( v3776(VarCurr)
    <=> ( v3773(VarCurr)
        & v3562(VarCurr,bitIndex17) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_475,axiom,
    ! [VarCurr] :
      ( v3621(VarCurr)
    <=> ( v3622(VarCurr)
        & v3770(VarCurr) ) ) ).

fof(writeUnaryOperator_253,axiom,
    ! [VarCurr] :
      ( ~ v3770(VarCurr)
    <=> v3771(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_474,axiom,
    ! [VarCurr] :
      ( v3771(VarCurr)
    <=> ( v3772(VarCurr)
        & v3775(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_176,axiom,
    ! [VarCurr] :
      ( v3775(VarCurr)
    <=> ( v3560(VarCurr,bitIndex17)
        | v3562(VarCurr,bitIndex17) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_473,axiom,
    ! [VarCurr] :
      ( v3772(VarCurr)
    <=> ( v3773(VarCurr)
        | v3774(VarCurr) ) ) ).

fof(writeUnaryOperator_252,axiom,
    ! [VarCurr] :
      ( ~ v3774(VarCurr)
    <=> v3562(VarCurr,bitIndex17) ) ).

fof(writeUnaryOperator_251,axiom,
    ! [VarCurr] :
      ( ~ v3773(VarCurr)
    <=> v3560(VarCurr,bitIndex17) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_472,axiom,
    ! [VarCurr] :
      ( v3622(VarCurr)
    <=> ( v3623(VarCurr)
        | v3769(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_175,axiom,
    ! [VarCurr] :
      ( v3769(VarCurr)
    <=> ( v3766(VarCurr)
        & v3562(VarCurr,bitIndex16) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_471,axiom,
    ! [VarCurr] :
      ( v3623(VarCurr)
    <=> ( v3624(VarCurr)
        & v3763(VarCurr) ) ) ).

fof(writeUnaryOperator_250,axiom,
    ! [VarCurr] :
      ( ~ v3763(VarCurr)
    <=> v3764(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_470,axiom,
    ! [VarCurr] :
      ( v3764(VarCurr)
    <=> ( v3765(VarCurr)
        & v3768(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_174,axiom,
    ! [VarCurr] :
      ( v3768(VarCurr)
    <=> ( v3560(VarCurr,bitIndex16)
        | v3562(VarCurr,bitIndex16) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_469,axiom,
    ! [VarCurr] :
      ( v3765(VarCurr)
    <=> ( v3766(VarCurr)
        | v3767(VarCurr) ) ) ).

fof(writeUnaryOperator_249,axiom,
    ! [VarCurr] :
      ( ~ v3767(VarCurr)
    <=> v3562(VarCurr,bitIndex16) ) ).

fof(writeUnaryOperator_248,axiom,
    ! [VarCurr] :
      ( ~ v3766(VarCurr)
    <=> v3560(VarCurr,bitIndex16) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_468,axiom,
    ! [VarCurr] :
      ( v3624(VarCurr)
    <=> ( v3625(VarCurr)
        | v3762(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_173,axiom,
    ! [VarCurr] :
      ( v3762(VarCurr)
    <=> ( v3759(VarCurr)
        & v3562(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_467,axiom,
    ! [VarCurr] :
      ( v3625(VarCurr)
    <=> ( v3626(VarCurr)
        & v3756(VarCurr) ) ) ).

fof(writeUnaryOperator_247,axiom,
    ! [VarCurr] :
      ( ~ v3756(VarCurr)
    <=> v3757(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_466,axiom,
    ! [VarCurr] :
      ( v3757(VarCurr)
    <=> ( v3758(VarCurr)
        & v3761(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_172,axiom,
    ! [VarCurr] :
      ( v3761(VarCurr)
    <=> ( v3560(VarCurr,bitIndex15)
        | v3562(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_465,axiom,
    ! [VarCurr] :
      ( v3758(VarCurr)
    <=> ( v3759(VarCurr)
        | v3760(VarCurr) ) ) ).

fof(writeUnaryOperator_246,axiom,
    ! [VarCurr] :
      ( ~ v3760(VarCurr)
    <=> v3562(VarCurr,bitIndex15) ) ).

fof(writeUnaryOperator_245,axiom,
    ! [VarCurr] :
      ( ~ v3759(VarCurr)
    <=> v3560(VarCurr,bitIndex15) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_464,axiom,
    ! [VarCurr] :
      ( v3626(VarCurr)
    <=> ( v3627(VarCurr)
        | v3755(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_171,axiom,
    ! [VarCurr] :
      ( v3755(VarCurr)
    <=> ( v3752(VarCurr)
        & v3562(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_463,axiom,
    ! [VarCurr] :
      ( v3627(VarCurr)
    <=> ( v3628(VarCurr)
        & v3749(VarCurr) ) ) ).

fof(writeUnaryOperator_244,axiom,
    ! [VarCurr] :
      ( ~ v3749(VarCurr)
    <=> v3750(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_462,axiom,
    ! [VarCurr] :
      ( v3750(VarCurr)
    <=> ( v3751(VarCurr)
        & v3754(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_170,axiom,
    ! [VarCurr] :
      ( v3754(VarCurr)
    <=> ( v3560(VarCurr,bitIndex14)
        | v3562(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_461,axiom,
    ! [VarCurr] :
      ( v3751(VarCurr)
    <=> ( v3752(VarCurr)
        | v3753(VarCurr) ) ) ).

fof(writeUnaryOperator_243,axiom,
    ! [VarCurr] :
      ( ~ v3753(VarCurr)
    <=> v3562(VarCurr,bitIndex14) ) ).

fof(writeUnaryOperator_242,axiom,
    ! [VarCurr] :
      ( ~ v3752(VarCurr)
    <=> v3560(VarCurr,bitIndex14) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_460,axiom,
    ! [VarCurr] :
      ( v3628(VarCurr)
    <=> ( v3629(VarCurr)
        | v3748(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_169,axiom,
    ! [VarCurr] :
      ( v3748(VarCurr)
    <=> ( v3745(VarCurr)
        & v3562(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_459,axiom,
    ! [VarCurr] :
      ( v3629(VarCurr)
    <=> ( v3630(VarCurr)
        & v3742(VarCurr) ) ) ).

fof(writeUnaryOperator_241,axiom,
    ! [VarCurr] :
      ( ~ v3742(VarCurr)
    <=> v3743(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_458,axiom,
    ! [VarCurr] :
      ( v3743(VarCurr)
    <=> ( v3744(VarCurr)
        & v3747(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_168,axiom,
    ! [VarCurr] :
      ( v3747(VarCurr)
    <=> ( v3560(VarCurr,bitIndex13)
        | v3562(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_457,axiom,
    ! [VarCurr] :
      ( v3744(VarCurr)
    <=> ( v3745(VarCurr)
        | v3746(VarCurr) ) ) ).

fof(writeUnaryOperator_240,axiom,
    ! [VarCurr] :
      ( ~ v3746(VarCurr)
    <=> v3562(VarCurr,bitIndex13) ) ).

fof(writeUnaryOperator_239,axiom,
    ! [VarCurr] :
      ( ~ v3745(VarCurr)
    <=> v3560(VarCurr,bitIndex13) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_456,axiom,
    ! [VarCurr] :
      ( v3630(VarCurr)
    <=> ( v3631(VarCurr)
        | v3741(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_167,axiom,
    ! [VarCurr] :
      ( v3741(VarCurr)
    <=> ( v3738(VarCurr)
        & v3562(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_455,axiom,
    ! [VarCurr] :
      ( v3631(VarCurr)
    <=> ( v3632(VarCurr)
        & v3735(VarCurr) ) ) ).

fof(writeUnaryOperator_238,axiom,
    ! [VarCurr] :
      ( ~ v3735(VarCurr)
    <=> v3736(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_454,axiom,
    ! [VarCurr] :
      ( v3736(VarCurr)
    <=> ( v3737(VarCurr)
        & v3740(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_166,axiom,
    ! [VarCurr] :
      ( v3740(VarCurr)
    <=> ( v3560(VarCurr,bitIndex12)
        | v3562(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_453,axiom,
    ! [VarCurr] :
      ( v3737(VarCurr)
    <=> ( v3738(VarCurr)
        | v3739(VarCurr) ) ) ).

fof(writeUnaryOperator_237,axiom,
    ! [VarCurr] :
      ( ~ v3739(VarCurr)
    <=> v3562(VarCurr,bitIndex12) ) ).

fof(writeUnaryOperator_236,axiom,
    ! [VarCurr] :
      ( ~ v3738(VarCurr)
    <=> v3560(VarCurr,bitIndex12) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_452,axiom,
    ! [VarCurr] :
      ( v3632(VarCurr)
    <=> ( v3633(VarCurr)
        | v3734(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_165,axiom,
    ! [VarCurr] :
      ( v3734(VarCurr)
    <=> ( v3731(VarCurr)
        & v3562(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_451,axiom,
    ! [VarCurr] :
      ( v3633(VarCurr)
    <=> ( v3634(VarCurr)
        & v3728(VarCurr) ) ) ).

fof(writeUnaryOperator_235,axiom,
    ! [VarCurr] :
      ( ~ v3728(VarCurr)
    <=> v3729(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_450,axiom,
    ! [VarCurr] :
      ( v3729(VarCurr)
    <=> ( v3730(VarCurr)
        & v3733(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_164,axiom,
    ! [VarCurr] :
      ( v3733(VarCurr)
    <=> ( v3560(VarCurr,bitIndex11)
        | v3562(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_449,axiom,
    ! [VarCurr] :
      ( v3730(VarCurr)
    <=> ( v3731(VarCurr)
        | v3732(VarCurr) ) ) ).

fof(writeUnaryOperator_234,axiom,
    ! [VarCurr] :
      ( ~ v3732(VarCurr)
    <=> v3562(VarCurr,bitIndex11) ) ).

fof(writeUnaryOperator_233,axiom,
    ! [VarCurr] :
      ( ~ v3731(VarCurr)
    <=> v3560(VarCurr,bitIndex11) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_448,axiom,
    ! [VarCurr] :
      ( v3634(VarCurr)
    <=> ( v3635(VarCurr)
        | v3727(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_163,axiom,
    ! [VarCurr] :
      ( v3727(VarCurr)
    <=> ( v3724(VarCurr)
        & v3562(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_447,axiom,
    ! [VarCurr] :
      ( v3635(VarCurr)
    <=> ( v3636(VarCurr)
        & v3721(VarCurr) ) ) ).

fof(writeUnaryOperator_232,axiom,
    ! [VarCurr] :
      ( ~ v3721(VarCurr)
    <=> v3722(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_446,axiom,
    ! [VarCurr] :
      ( v3722(VarCurr)
    <=> ( v3723(VarCurr)
        & v3726(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_162,axiom,
    ! [VarCurr] :
      ( v3726(VarCurr)
    <=> ( v3560(VarCurr,bitIndex10)
        | v3562(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_445,axiom,
    ! [VarCurr] :
      ( v3723(VarCurr)
    <=> ( v3724(VarCurr)
        | v3725(VarCurr) ) ) ).

fof(writeUnaryOperator_231,axiom,
    ! [VarCurr] :
      ( ~ v3725(VarCurr)
    <=> v3562(VarCurr,bitIndex10) ) ).

fof(writeUnaryOperator_230,axiom,
    ! [VarCurr] :
      ( ~ v3724(VarCurr)
    <=> v3560(VarCurr,bitIndex10) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_444,axiom,
    ! [VarCurr] :
      ( v3636(VarCurr)
    <=> ( v3637(VarCurr)
        | v3720(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_161,axiom,
    ! [VarCurr] :
      ( v3720(VarCurr)
    <=> ( v3717(VarCurr)
        & v3562(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_443,axiom,
    ! [VarCurr] :
      ( v3637(VarCurr)
    <=> ( v3638(VarCurr)
        & v3714(VarCurr) ) ) ).

fof(writeUnaryOperator_229,axiom,
    ! [VarCurr] :
      ( ~ v3714(VarCurr)
    <=> v3715(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_442,axiom,
    ! [VarCurr] :
      ( v3715(VarCurr)
    <=> ( v3716(VarCurr)
        & v3719(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_160,axiom,
    ! [VarCurr] :
      ( v3719(VarCurr)
    <=> ( v3560(VarCurr,bitIndex9)
        | v3562(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_441,axiom,
    ! [VarCurr] :
      ( v3716(VarCurr)
    <=> ( v3717(VarCurr)
        | v3718(VarCurr) ) ) ).

fof(writeUnaryOperator_228,axiom,
    ! [VarCurr] :
      ( ~ v3718(VarCurr)
    <=> v3562(VarCurr,bitIndex9) ) ).

fof(writeUnaryOperator_227,axiom,
    ! [VarCurr] :
      ( ~ v3717(VarCurr)
    <=> v3560(VarCurr,bitIndex9) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_440,axiom,
    ! [VarCurr] :
      ( v3638(VarCurr)
    <=> ( v3639(VarCurr)
        | v3713(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_159,axiom,
    ! [VarCurr] :
      ( v3713(VarCurr)
    <=> ( v3710(VarCurr)
        & v3562(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_439,axiom,
    ! [VarCurr] :
      ( v3639(VarCurr)
    <=> ( v3640(VarCurr)
        & v3707(VarCurr) ) ) ).

fof(writeUnaryOperator_226,axiom,
    ! [VarCurr] :
      ( ~ v3707(VarCurr)
    <=> v3708(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_438,axiom,
    ! [VarCurr] :
      ( v3708(VarCurr)
    <=> ( v3709(VarCurr)
        & v3712(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_158,axiom,
    ! [VarCurr] :
      ( v3712(VarCurr)
    <=> ( v3560(VarCurr,bitIndex8)
        | v3562(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_437,axiom,
    ! [VarCurr] :
      ( v3709(VarCurr)
    <=> ( v3710(VarCurr)
        | v3711(VarCurr) ) ) ).

fof(writeUnaryOperator_225,axiom,
    ! [VarCurr] :
      ( ~ v3711(VarCurr)
    <=> v3562(VarCurr,bitIndex8) ) ).

fof(writeUnaryOperator_224,axiom,
    ! [VarCurr] :
      ( ~ v3710(VarCurr)
    <=> v3560(VarCurr,bitIndex8) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_436,axiom,
    ! [VarCurr] :
      ( v3640(VarCurr)
    <=> ( v3641(VarCurr)
        | v3706(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_157,axiom,
    ! [VarCurr] :
      ( v3706(VarCurr)
    <=> ( v3703(VarCurr)
        & v3562(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_435,axiom,
    ! [VarCurr] :
      ( v3641(VarCurr)
    <=> ( v3642(VarCurr)
        & v3700(VarCurr) ) ) ).

fof(writeUnaryOperator_223,axiom,
    ! [VarCurr] :
      ( ~ v3700(VarCurr)
    <=> v3701(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_434,axiom,
    ! [VarCurr] :
      ( v3701(VarCurr)
    <=> ( v3702(VarCurr)
        & v3705(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_156,axiom,
    ! [VarCurr] :
      ( v3705(VarCurr)
    <=> ( v3560(VarCurr,bitIndex7)
        | v3562(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_433,axiom,
    ! [VarCurr] :
      ( v3702(VarCurr)
    <=> ( v3703(VarCurr)
        | v3704(VarCurr) ) ) ).

fof(writeUnaryOperator_222,axiom,
    ! [VarCurr] :
      ( ~ v3704(VarCurr)
    <=> v3562(VarCurr,bitIndex7) ) ).

fof(writeUnaryOperator_221,axiom,
    ! [VarCurr] :
      ( ~ v3703(VarCurr)
    <=> v3560(VarCurr,bitIndex7) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_432,axiom,
    ! [VarCurr] :
      ( v3642(VarCurr)
    <=> ( v3643(VarCurr)
        | v3699(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_155,axiom,
    ! [VarCurr] :
      ( v3699(VarCurr)
    <=> ( v3696(VarCurr)
        & v3562(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_431,axiom,
    ! [VarCurr] :
      ( v3643(VarCurr)
    <=> ( v3644(VarCurr)
        & v3693(VarCurr) ) ) ).

fof(writeUnaryOperator_220,axiom,
    ! [VarCurr] :
      ( ~ v3693(VarCurr)
    <=> v3694(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_430,axiom,
    ! [VarCurr] :
      ( v3694(VarCurr)
    <=> ( v3695(VarCurr)
        & v3698(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_154,axiom,
    ! [VarCurr] :
      ( v3698(VarCurr)
    <=> ( v3560(VarCurr,bitIndex6)
        | v3562(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_429,axiom,
    ! [VarCurr] :
      ( v3695(VarCurr)
    <=> ( v3696(VarCurr)
        | v3697(VarCurr) ) ) ).

fof(writeUnaryOperator_219,axiom,
    ! [VarCurr] :
      ( ~ v3697(VarCurr)
    <=> v3562(VarCurr,bitIndex6) ) ).

fof(writeUnaryOperator_218,axiom,
    ! [VarCurr] :
      ( ~ v3696(VarCurr)
    <=> v3560(VarCurr,bitIndex6) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_428,axiom,
    ! [VarCurr] :
      ( v3644(VarCurr)
    <=> ( v3645(VarCurr)
        | v3692(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_153,axiom,
    ! [VarCurr] :
      ( v3692(VarCurr)
    <=> ( v3689(VarCurr)
        & v3562(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_427,axiom,
    ! [VarCurr] :
      ( v3645(VarCurr)
    <=> ( v3646(VarCurr)
        & v3686(VarCurr) ) ) ).

fof(writeUnaryOperator_217,axiom,
    ! [VarCurr] :
      ( ~ v3686(VarCurr)
    <=> v3687(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_426,axiom,
    ! [VarCurr] :
      ( v3687(VarCurr)
    <=> ( v3688(VarCurr)
        & v3691(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_152,axiom,
    ! [VarCurr] :
      ( v3691(VarCurr)
    <=> ( v3560(VarCurr,bitIndex5)
        | v3562(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_425,axiom,
    ! [VarCurr] :
      ( v3688(VarCurr)
    <=> ( v3689(VarCurr)
        | v3690(VarCurr) ) ) ).

fof(writeUnaryOperator_216,axiom,
    ! [VarCurr] :
      ( ~ v3690(VarCurr)
    <=> v3562(VarCurr,bitIndex5) ) ).

fof(writeUnaryOperator_215,axiom,
    ! [VarCurr] :
      ( ~ v3689(VarCurr)
    <=> v3560(VarCurr,bitIndex5) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_424,axiom,
    ! [VarCurr] :
      ( v3646(VarCurr)
    <=> ( v3647(VarCurr)
        | v3685(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_151,axiom,
    ! [VarCurr] :
      ( v3685(VarCurr)
    <=> ( v3682(VarCurr)
        & v3562(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_423,axiom,
    ! [VarCurr] :
      ( v3647(VarCurr)
    <=> ( v3648(VarCurr)
        & v3679(VarCurr) ) ) ).

fof(writeUnaryOperator_214,axiom,
    ! [VarCurr] :
      ( ~ v3679(VarCurr)
    <=> v3680(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_422,axiom,
    ! [VarCurr] :
      ( v3680(VarCurr)
    <=> ( v3681(VarCurr)
        & v3684(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_150,axiom,
    ! [VarCurr] :
      ( v3684(VarCurr)
    <=> ( v3560(VarCurr,bitIndex4)
        | v3562(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_421,axiom,
    ! [VarCurr] :
      ( v3681(VarCurr)
    <=> ( v3682(VarCurr)
        | v3683(VarCurr) ) ) ).

fof(writeUnaryOperator_213,axiom,
    ! [VarCurr] :
      ( ~ v3683(VarCurr)
    <=> v3562(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_212,axiom,
    ! [VarCurr] :
      ( ~ v3682(VarCurr)
    <=> v3560(VarCurr,bitIndex4) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_420,axiom,
    ! [VarCurr] :
      ( v3648(VarCurr)
    <=> ( v3649(VarCurr)
        | v3678(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_149,axiom,
    ! [VarCurr] :
      ( v3678(VarCurr)
    <=> ( v3675(VarCurr)
        & v3562(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_419,axiom,
    ! [VarCurr] :
      ( v3649(VarCurr)
    <=> ( v3650(VarCurr)
        & v3672(VarCurr) ) ) ).

fof(writeUnaryOperator_211,axiom,
    ! [VarCurr] :
      ( ~ v3672(VarCurr)
    <=> v3673(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_418,axiom,
    ! [VarCurr] :
      ( v3673(VarCurr)
    <=> ( v3674(VarCurr)
        & v3677(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_148,axiom,
    ! [VarCurr] :
      ( v3677(VarCurr)
    <=> ( v3560(VarCurr,bitIndex3)
        | v3562(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_417,axiom,
    ! [VarCurr] :
      ( v3674(VarCurr)
    <=> ( v3675(VarCurr)
        | v3676(VarCurr) ) ) ).

fof(writeUnaryOperator_210,axiom,
    ! [VarCurr] :
      ( ~ v3676(VarCurr)
    <=> v3562(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_209,axiom,
    ! [VarCurr] :
      ( ~ v3675(VarCurr)
    <=> v3560(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_416,axiom,
    ! [VarCurr] :
      ( v3650(VarCurr)
    <=> ( v3651(VarCurr)
        | v3671(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_147,axiom,
    ! [VarCurr] :
      ( v3671(VarCurr)
    <=> ( v3668(VarCurr)
        & v3562(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_415,axiom,
    ! [VarCurr] :
      ( v3651(VarCurr)
    <=> ( v3652(VarCurr)
        & v3665(VarCurr) ) ) ).

fof(writeUnaryOperator_208,axiom,
    ! [VarCurr] :
      ( ~ v3665(VarCurr)
    <=> v3666(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_414,axiom,
    ! [VarCurr] :
      ( v3666(VarCurr)
    <=> ( v3667(VarCurr)
        & v3670(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_146,axiom,
    ! [VarCurr] :
      ( v3670(VarCurr)
    <=> ( v3560(VarCurr,bitIndex2)
        | v3562(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_413,axiom,
    ! [VarCurr] :
      ( v3667(VarCurr)
    <=> ( v3668(VarCurr)
        | v3669(VarCurr) ) ) ).

fof(writeUnaryOperator_207,axiom,
    ! [VarCurr] :
      ( ~ v3669(VarCurr)
    <=> v3562(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_206,axiom,
    ! [VarCurr] :
      ( ~ v3668(VarCurr)
    <=> v3560(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_412,axiom,
    ! [VarCurr] :
      ( v3652(VarCurr)
    <=> ( v3653(VarCurr)
        | v3664(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_145,axiom,
    ! [VarCurr] :
      ( v3664(VarCurr)
    <=> ( v3661(VarCurr)
        & v3562(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_411,axiom,
    ! [VarCurr] :
      ( v3653(VarCurr)
    <=> ( v3654(VarCurr)
        & v3658(VarCurr) ) ) ).

fof(writeUnaryOperator_205,axiom,
    ! [VarCurr] :
      ( ~ v3658(VarCurr)
    <=> v3659(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_410,axiom,
    ! [VarCurr] :
      ( v3659(VarCurr)
    <=> ( v3660(VarCurr)
        & v3663(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_144,axiom,
    ! [VarCurr] :
      ( v3663(VarCurr)
    <=> ( v3560(VarCurr,bitIndex1)
        | v3562(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_409,axiom,
    ! [VarCurr] :
      ( v3660(VarCurr)
    <=> ( v3661(VarCurr)
        | v3662(VarCurr) ) ) ).

fof(writeUnaryOperator_204,axiom,
    ! [VarCurr] :
      ( ~ v3662(VarCurr)
    <=> v3562(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_203,axiom,
    ! [VarCurr] :
      ( ~ v3661(VarCurr)
    <=> v3560(VarCurr,bitIndex1) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_408,axiom,
    ! [VarCurr] :
      ( v3654(VarCurr)
    <=> ( v3655(VarCurr)
        & v3562(VarCurr,bitIndex0) ) ) ).

fof(writeUnaryOperator_202,axiom,
    ! [VarCurr] :
      ( ~ v3655(VarCurr)
    <=> v3560(VarCurr,bitIndex0) ) ).

fof(addAssignmentInitValue_238,axiom,
    ~ v3560(constB0,bitIndex27) ).

fof(addAssignmentInitValue_237,axiom,
    ~ v3560(constB0,bitIndex26) ).

fof(addAssignmentInitValue_236,axiom,
    ~ v3560(constB0,bitIndex25) ).

fof(addAssignmentInitValue_235,axiom,
    ~ v3560(constB0,bitIndex24) ).

fof(addAssignmentInitValue_234,axiom,
    ~ v3560(constB0,bitIndex23) ).

fof(addAssignmentInitValue_233,axiom,
    ~ v3560(constB0,bitIndex22) ).

fof(addAssignmentInitValue_232,axiom,
    ~ v3560(constB0,bitIndex21) ).

fof(addAssignmentInitValue_231,axiom,
    ~ v3560(constB0,bitIndex20) ).

fof(addAssignmentInitValue_230,axiom,
    ~ v3560(constB0,bitIndex19) ).

fof(addAssignmentInitValue_229,axiom,
    ~ v3560(constB0,bitIndex18) ).

fof(addAssignmentInitValue_228,axiom,
    ~ v3560(constB0,bitIndex17) ).

fof(addAssignmentInitValue_227,axiom,
    ~ v3560(constB0,bitIndex16) ).

fof(addAssignmentInitValue_226,axiom,
    ~ v3560(constB0,bitIndex15) ).

fof(addAssignmentInitValue_225,axiom,
    ~ v3560(constB0,bitIndex14) ).

fof(addAssignmentInitValue_224,axiom,
    ~ v3560(constB0,bitIndex13) ).

fof(addAssignmentInitValue_223,axiom,
    ~ v3560(constB0,bitIndex12) ).

fof(addAssignmentInitValue_222,axiom,
    ~ v3560(constB0,bitIndex11) ).

fof(addAssignmentInitValue_221,axiom,
    ~ v3560(constB0,bitIndex10) ).

fof(bitBlastConstant_1247,axiom,
    ~ b000000000000000000xxxxxxxxxx(bitIndex27) ).

fof(bitBlastConstant_1246,axiom,
    ~ b000000000000000000xxxxxxxxxx(bitIndex26) ).

fof(bitBlastConstant_1245,axiom,
    ~ b000000000000000000xxxxxxxxxx(bitIndex25) ).

fof(bitBlastConstant_1244,axiom,
    ~ b000000000000000000xxxxxxxxxx(bitIndex24) ).

fof(bitBlastConstant_1243,axiom,
    ~ b000000000000000000xxxxxxxxxx(bitIndex23) ).

fof(bitBlastConstant_1242,axiom,
    ~ b000000000000000000xxxxxxxxxx(bitIndex22) ).

fof(bitBlastConstant_1241,axiom,
    ~ b000000000000000000xxxxxxxxxx(bitIndex21) ).

fof(bitBlastConstant_1240,axiom,
    ~ b000000000000000000xxxxxxxxxx(bitIndex20) ).

fof(bitBlastConstant_1239,axiom,
    ~ b000000000000000000xxxxxxxxxx(bitIndex19) ).

fof(bitBlastConstant_1238,axiom,
    ~ b000000000000000000xxxxxxxxxx(bitIndex18) ).

fof(bitBlastConstant_1237,axiom,
    ~ b000000000000000000xxxxxxxxxx(bitIndex17) ).

fof(bitBlastConstant_1236,axiom,
    ~ b000000000000000000xxxxxxxxxx(bitIndex16) ).

fof(bitBlastConstant_1235,axiom,
    ~ b000000000000000000xxxxxxxxxx(bitIndex15) ).

fof(bitBlastConstant_1234,axiom,
    ~ b000000000000000000xxxxxxxxxx(bitIndex14) ).

fof(bitBlastConstant_1233,axiom,
    ~ b000000000000000000xxxxxxxxxx(bitIndex13) ).

fof(bitBlastConstant_1232,axiom,
    ~ b000000000000000000xxxxxxxxxx(bitIndex12) ).

fof(bitBlastConstant_1231,axiom,
    ~ b000000000000000000xxxxxxxxxx(bitIndex11) ).

fof(bitBlastConstant_1230,axiom,
    ~ b000000000000000000xxxxxxxxxx(bitIndex10) ).

fof(addParallelCaseBooleanConditionEqualRanges15,axiom,
    ! [VarCurr] :
      ( ( ~ v3584(VarCurr)
        & ~ v3585(VarCurr)
        & ~ v3586(VarCurr)
        & ~ v3587(VarCurr)
        & ~ v3588(VarCurr)
        & ~ v3589(VarCurr)
        & ~ v3590(VarCurr)
        & ~ v3591(VarCurr)
        & ~ v3592(VarCurr)
        & ~ v3593(VarCurr)
        & ~ v3594(VarCurr)
        & ~ v3595(VarCurr)
        & ~ v3596(VarCurr)
        & ~ v3597(VarCurr)
        & ~ v3598(VarCurr) )
     => ! [B] :
          ( range_26_0(B)
         => ( v3562(VarCurr,B)
          <=> b010000000000000000000000000(B) ) ) ) ).

fof(bitBlastConstant_1229,axiom,
    ~ b010000000000000000000000000(bitIndex26) ).

fof(bitBlastConstant_1228,axiom,
    b010000000000000000000000000(bitIndex25) ).

fof(bitBlastConstant_1227,axiom,
    ~ b010000000000000000000000000(bitIndex24) ).

fof(bitBlastConstant_1226,axiom,
    ~ b010000000000000000000000000(bitIndex23) ).

fof(bitBlastConstant_1225,axiom,
    ~ b010000000000000000000000000(bitIndex22) ).

fof(bitBlastConstant_1224,axiom,
    ~ b010000000000000000000000000(bitIndex21) ).

fof(bitBlastConstant_1223,axiom,
    ~ b010000000000000000000000000(bitIndex20) ).

fof(bitBlastConstant_1222,axiom,
    ~ b010000000000000000000000000(bitIndex19) ).

fof(bitBlastConstant_1221,axiom,
    ~ b010000000000000000000000000(bitIndex18) ).

fof(bitBlastConstant_1220,axiom,
    ~ b010000000000000000000000000(bitIndex17) ).

fof(bitBlastConstant_1219,axiom,
    ~ b010000000000000000000000000(bitIndex16) ).

fof(bitBlastConstant_1218,axiom,
    ~ b010000000000000000000000000(bitIndex15) ).

fof(bitBlastConstant_1217,axiom,
    ~ b010000000000000000000000000(bitIndex14) ).

fof(bitBlastConstant_1216,axiom,
    ~ b010000000000000000000000000(bitIndex13) ).

fof(bitBlastConstant_1215,axiom,
    ~ b010000000000000000000000000(bitIndex12) ).

fof(bitBlastConstant_1214,axiom,
    ~ b010000000000000000000000000(bitIndex11) ).

fof(bitBlastConstant_1213,axiom,
    ~ b010000000000000000000000000(bitIndex10) ).

fof(bitBlastConstant_1212,axiom,
    ~ b010000000000000000000000000(bitIndex9) ).

fof(bitBlastConstant_1211,axiom,
    ~ b010000000000000000000000000(bitIndex8) ).

fof(bitBlastConstant_1210,axiom,
    ~ b010000000000000000000000000(bitIndex7) ).

fof(bitBlastConstant_1209,axiom,
    ~ b010000000000000000000000000(bitIndex6) ).

fof(bitBlastConstant_1208,axiom,
    ~ b010000000000000000000000000(bitIndex5) ).

fof(bitBlastConstant_1207,axiom,
    ~ b010000000000000000000000000(bitIndex4) ).

fof(bitBlastConstant_1206,axiom,
    ~ b010000000000000000000000000(bitIndex3) ).

fof(bitBlastConstant_1205,axiom,
    ~ b010000000000000000000000000(bitIndex2) ).

fof(bitBlastConstant_1204,axiom,
    ~ b010000000000000000000000000(bitIndex1) ).

fof(bitBlastConstant_1203,axiom,
    ~ b010000000000000000000000000(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges14,axiom,
    ! [VarCurr] :
      ( v3598(VarCurr)
     => ! [B] :
          ( range_26_0(B)
         => ( v3562(VarCurr,B)
          <=> b001000000000000000000000000(B) ) ) ) ).

fof(bitBlastConstant_1202,axiom,
    ~ b001000000000000000000000000(bitIndex26) ).

fof(bitBlastConstant_1201,axiom,
    ~ b001000000000000000000000000(bitIndex25) ).

fof(bitBlastConstant_1200,axiom,
    b001000000000000000000000000(bitIndex24) ).

fof(bitBlastConstant_1199,axiom,
    ~ b001000000000000000000000000(bitIndex23) ).

fof(bitBlastConstant_1198,axiom,
    ~ b001000000000000000000000000(bitIndex22) ).

fof(bitBlastConstant_1197,axiom,
    ~ b001000000000000000000000000(bitIndex21) ).

fof(bitBlastConstant_1196,axiom,
    ~ b001000000000000000000000000(bitIndex20) ).

fof(bitBlastConstant_1195,axiom,
    ~ b001000000000000000000000000(bitIndex19) ).

fof(bitBlastConstant_1194,axiom,
    ~ b001000000000000000000000000(bitIndex18) ).

fof(bitBlastConstant_1193,axiom,
    ~ b001000000000000000000000000(bitIndex17) ).

fof(bitBlastConstant_1192,axiom,
    ~ b001000000000000000000000000(bitIndex16) ).

fof(bitBlastConstant_1191,axiom,
    ~ b001000000000000000000000000(bitIndex15) ).

fof(bitBlastConstant_1190,axiom,
    ~ b001000000000000000000000000(bitIndex14) ).

fof(bitBlastConstant_1189,axiom,
    ~ b001000000000000000000000000(bitIndex13) ).

fof(bitBlastConstant_1188,axiom,
    ~ b001000000000000000000000000(bitIndex12) ).

fof(bitBlastConstant_1187,axiom,
    ~ b001000000000000000000000000(bitIndex11) ).

fof(bitBlastConstant_1186,axiom,
    ~ b001000000000000000000000000(bitIndex10) ).

fof(bitBlastConstant_1185,axiom,
    ~ b001000000000000000000000000(bitIndex9) ).

fof(bitBlastConstant_1184,axiom,
    ~ b001000000000000000000000000(bitIndex8) ).

fof(bitBlastConstant_1183,axiom,
    ~ b001000000000000000000000000(bitIndex7) ).

fof(bitBlastConstant_1182,axiom,
    ~ b001000000000000000000000000(bitIndex6) ).

fof(bitBlastConstant_1181,axiom,
    ~ b001000000000000000000000000(bitIndex5) ).

fof(bitBlastConstant_1180,axiom,
    ~ b001000000000000000000000000(bitIndex4) ).

fof(bitBlastConstant_1179,axiom,
    ~ b001000000000000000000000000(bitIndex3) ).

fof(bitBlastConstant_1178,axiom,
    ~ b001000000000000000000000000(bitIndex2) ).

fof(bitBlastConstant_1177,axiom,
    ~ b001000000000000000000000000(bitIndex1) ).

fof(bitBlastConstant_1176,axiom,
    ~ b001000000000000000000000000(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges13,axiom,
    ! [VarCurr] :
      ( v3597(VarCurr)
     => ! [B] :
          ( range_26_0(B)
         => ( v3562(VarCurr,B)
          <=> b000100000000000000000000000(B) ) ) ) ).

fof(bitBlastConstant_1175,axiom,
    ~ b000100000000000000000000000(bitIndex26) ).

fof(bitBlastConstant_1174,axiom,
    ~ b000100000000000000000000000(bitIndex25) ).

fof(bitBlastConstant_1173,axiom,
    ~ b000100000000000000000000000(bitIndex24) ).

fof(bitBlastConstant_1172,axiom,
    b000100000000000000000000000(bitIndex23) ).

fof(bitBlastConstant_1171,axiom,
    ~ b000100000000000000000000000(bitIndex22) ).

fof(bitBlastConstant_1170,axiom,
    ~ b000100000000000000000000000(bitIndex21) ).

fof(bitBlastConstant_1169,axiom,
    ~ b000100000000000000000000000(bitIndex20) ).

fof(bitBlastConstant_1168,axiom,
    ~ b000100000000000000000000000(bitIndex19) ).

fof(bitBlastConstant_1167,axiom,
    ~ b000100000000000000000000000(bitIndex18) ).

fof(bitBlastConstant_1166,axiom,
    ~ b000100000000000000000000000(bitIndex17) ).

fof(bitBlastConstant_1165,axiom,
    ~ b000100000000000000000000000(bitIndex16) ).

fof(bitBlastConstant_1164,axiom,
    ~ b000100000000000000000000000(bitIndex15) ).

fof(bitBlastConstant_1163,axiom,
    ~ b000100000000000000000000000(bitIndex14) ).

fof(bitBlastConstant_1162,axiom,
    ~ b000100000000000000000000000(bitIndex13) ).

fof(bitBlastConstant_1161,axiom,
    ~ b000100000000000000000000000(bitIndex12) ).

fof(bitBlastConstant_1160,axiom,
    ~ b000100000000000000000000000(bitIndex11) ).

fof(bitBlastConstant_1159,axiom,
    ~ b000100000000000000000000000(bitIndex10) ).

fof(bitBlastConstant_1158,axiom,
    ~ b000100000000000000000000000(bitIndex9) ).

fof(bitBlastConstant_1157,axiom,
    ~ b000100000000000000000000000(bitIndex8) ).

fof(bitBlastConstant_1156,axiom,
    ~ b000100000000000000000000000(bitIndex7) ).

fof(bitBlastConstant_1155,axiom,
    ~ b000100000000000000000000000(bitIndex6) ).

fof(bitBlastConstant_1154,axiom,
    ~ b000100000000000000000000000(bitIndex5) ).

fof(bitBlastConstant_1153,axiom,
    ~ b000100000000000000000000000(bitIndex4) ).

fof(bitBlastConstant_1152,axiom,
    ~ b000100000000000000000000000(bitIndex3) ).

fof(bitBlastConstant_1151,axiom,
    ~ b000100000000000000000000000(bitIndex2) ).

fof(bitBlastConstant_1150,axiom,
    ~ b000100000000000000000000000(bitIndex1) ).

fof(bitBlastConstant_1149,axiom,
    ~ b000100000000000000000000000(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges12,axiom,
    ! [VarCurr] :
      ( v3596(VarCurr)
     => ! [B] :
          ( range_26_0(B)
         => ( v3562(VarCurr,B)
          <=> b000010000000000000000000000(B) ) ) ) ).

fof(bitBlastConstant_1148,axiom,
    ~ b000010000000000000000000000(bitIndex26) ).

fof(bitBlastConstant_1147,axiom,
    ~ b000010000000000000000000000(bitIndex25) ).

fof(bitBlastConstant_1146,axiom,
    ~ b000010000000000000000000000(bitIndex24) ).

fof(bitBlastConstant_1145,axiom,
    ~ b000010000000000000000000000(bitIndex23) ).

fof(bitBlastConstant_1144,axiom,
    b000010000000000000000000000(bitIndex22) ).

fof(bitBlastConstant_1143,axiom,
    ~ b000010000000000000000000000(bitIndex21) ).

fof(bitBlastConstant_1142,axiom,
    ~ b000010000000000000000000000(bitIndex20) ).

fof(bitBlastConstant_1141,axiom,
    ~ b000010000000000000000000000(bitIndex19) ).

fof(bitBlastConstant_1140,axiom,
    ~ b000010000000000000000000000(bitIndex18) ).

fof(bitBlastConstant_1139,axiom,
    ~ b000010000000000000000000000(bitIndex17) ).

fof(bitBlastConstant_1138,axiom,
    ~ b000010000000000000000000000(bitIndex16) ).

fof(bitBlastConstant_1137,axiom,
    ~ b000010000000000000000000000(bitIndex15) ).

fof(bitBlastConstant_1136,axiom,
    ~ b000010000000000000000000000(bitIndex14) ).

fof(bitBlastConstant_1135,axiom,
    ~ b000010000000000000000000000(bitIndex13) ).

fof(bitBlastConstant_1134,axiom,
    ~ b000010000000000000000000000(bitIndex12) ).

fof(bitBlastConstant_1133,axiom,
    ~ b000010000000000000000000000(bitIndex11) ).

fof(bitBlastConstant_1132,axiom,
    ~ b000010000000000000000000000(bitIndex10) ).

fof(bitBlastConstant_1131,axiom,
    ~ b000010000000000000000000000(bitIndex9) ).

fof(bitBlastConstant_1130,axiom,
    ~ b000010000000000000000000000(bitIndex8) ).

fof(bitBlastConstant_1129,axiom,
    ~ b000010000000000000000000000(bitIndex7) ).

fof(bitBlastConstant_1128,axiom,
    ~ b000010000000000000000000000(bitIndex6) ).

fof(bitBlastConstant_1127,axiom,
    ~ b000010000000000000000000000(bitIndex5) ).

fof(bitBlastConstant_1126,axiom,
    ~ b000010000000000000000000000(bitIndex4) ).

fof(bitBlastConstant_1125,axiom,
    ~ b000010000000000000000000000(bitIndex3) ).

fof(bitBlastConstant_1124,axiom,
    ~ b000010000000000000000000000(bitIndex2) ).

fof(bitBlastConstant_1123,axiom,
    ~ b000010000000000000000000000(bitIndex1) ).

fof(bitBlastConstant_1122,axiom,
    ~ b000010000000000000000000000(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges11,axiom,
    ! [VarCurr] :
      ( v3595(VarCurr)
     => ! [B] :
          ( range_26_0(B)
         => ( v3562(VarCurr,B)
          <=> b000001000000000000000000000(B) ) ) ) ).

fof(bitBlastConstant_1121,axiom,
    ~ b000001000000000000000000000(bitIndex26) ).

fof(bitBlastConstant_1120,axiom,
    ~ b000001000000000000000000000(bitIndex25) ).

fof(bitBlastConstant_1119,axiom,
    ~ b000001000000000000000000000(bitIndex24) ).

fof(bitBlastConstant_1118,axiom,
    ~ b000001000000000000000000000(bitIndex23) ).

fof(bitBlastConstant_1117,axiom,
    ~ b000001000000000000000000000(bitIndex22) ).

fof(bitBlastConstant_1116,axiom,
    b000001000000000000000000000(bitIndex21) ).

fof(bitBlastConstant_1115,axiom,
    ~ b000001000000000000000000000(bitIndex20) ).

fof(bitBlastConstant_1114,axiom,
    ~ b000001000000000000000000000(bitIndex19) ).

fof(bitBlastConstant_1113,axiom,
    ~ b000001000000000000000000000(bitIndex18) ).

fof(bitBlastConstant_1112,axiom,
    ~ b000001000000000000000000000(bitIndex17) ).

fof(bitBlastConstant_1111,axiom,
    ~ b000001000000000000000000000(bitIndex16) ).

fof(bitBlastConstant_1110,axiom,
    ~ b000001000000000000000000000(bitIndex15) ).

fof(bitBlastConstant_1109,axiom,
    ~ b000001000000000000000000000(bitIndex14) ).

fof(bitBlastConstant_1108,axiom,
    ~ b000001000000000000000000000(bitIndex13) ).

fof(bitBlastConstant_1107,axiom,
    ~ b000001000000000000000000000(bitIndex12) ).

fof(bitBlastConstant_1106,axiom,
    ~ b000001000000000000000000000(bitIndex11) ).

fof(bitBlastConstant_1105,axiom,
    ~ b000001000000000000000000000(bitIndex10) ).

fof(bitBlastConstant_1104,axiom,
    ~ b000001000000000000000000000(bitIndex9) ).

fof(bitBlastConstant_1103,axiom,
    ~ b000001000000000000000000000(bitIndex8) ).

fof(bitBlastConstant_1102,axiom,
    ~ b000001000000000000000000000(bitIndex7) ).

fof(bitBlastConstant_1101,axiom,
    ~ b000001000000000000000000000(bitIndex6) ).

fof(bitBlastConstant_1100,axiom,
    ~ b000001000000000000000000000(bitIndex5) ).

fof(bitBlastConstant_1099,axiom,
    ~ b000001000000000000000000000(bitIndex4) ).

fof(bitBlastConstant_1098,axiom,
    ~ b000001000000000000000000000(bitIndex3) ).

fof(bitBlastConstant_1097,axiom,
    ~ b000001000000000000000000000(bitIndex2) ).

fof(bitBlastConstant_1096,axiom,
    ~ b000001000000000000000000000(bitIndex1) ).

fof(bitBlastConstant_1095,axiom,
    ~ b000001000000000000000000000(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges10,axiom,
    ! [VarCurr] :
      ( v3594(VarCurr)
     => ! [B] :
          ( range_26_0(B)
         => ( v3562(VarCurr,B)
          <=> b000000100000000000000000000(B) ) ) ) ).

fof(bitBlastConstant_1094,axiom,
    ~ b000000100000000000000000000(bitIndex26) ).

fof(bitBlastConstant_1093,axiom,
    ~ b000000100000000000000000000(bitIndex25) ).

fof(bitBlastConstant_1092,axiom,
    ~ b000000100000000000000000000(bitIndex24) ).

fof(bitBlastConstant_1091,axiom,
    ~ b000000100000000000000000000(bitIndex23) ).

fof(bitBlastConstant_1090,axiom,
    ~ b000000100000000000000000000(bitIndex22) ).

fof(bitBlastConstant_1089,axiom,
    ~ b000000100000000000000000000(bitIndex21) ).

fof(bitBlastConstant_1088,axiom,
    b000000100000000000000000000(bitIndex20) ).

fof(bitBlastConstant_1087,axiom,
    ~ b000000100000000000000000000(bitIndex19) ).

fof(bitBlastConstant_1086,axiom,
    ~ b000000100000000000000000000(bitIndex18) ).

fof(bitBlastConstant_1085,axiom,
    ~ b000000100000000000000000000(bitIndex17) ).

fof(bitBlastConstant_1084,axiom,
    ~ b000000100000000000000000000(bitIndex16) ).

fof(bitBlastConstant_1083,axiom,
    ~ b000000100000000000000000000(bitIndex15) ).

fof(bitBlastConstant_1082,axiom,
    ~ b000000100000000000000000000(bitIndex14) ).

fof(bitBlastConstant_1081,axiom,
    ~ b000000100000000000000000000(bitIndex13) ).

fof(bitBlastConstant_1080,axiom,
    ~ b000000100000000000000000000(bitIndex12) ).

fof(bitBlastConstant_1079,axiom,
    ~ b000000100000000000000000000(bitIndex11) ).

fof(bitBlastConstant_1078,axiom,
    ~ b000000100000000000000000000(bitIndex10) ).

fof(bitBlastConstant_1077,axiom,
    ~ b000000100000000000000000000(bitIndex9) ).

fof(bitBlastConstant_1076,axiom,
    ~ b000000100000000000000000000(bitIndex8) ).

fof(bitBlastConstant_1075,axiom,
    ~ b000000100000000000000000000(bitIndex7) ).

fof(bitBlastConstant_1074,axiom,
    ~ b000000100000000000000000000(bitIndex6) ).

fof(bitBlastConstant_1073,axiom,
    ~ b000000100000000000000000000(bitIndex5) ).

fof(bitBlastConstant_1072,axiom,
    ~ b000000100000000000000000000(bitIndex4) ).

fof(bitBlastConstant_1071,axiom,
    ~ b000000100000000000000000000(bitIndex3) ).

fof(bitBlastConstant_1070,axiom,
    ~ b000000100000000000000000000(bitIndex2) ).

fof(bitBlastConstant_1069,axiom,
    ~ b000000100000000000000000000(bitIndex1) ).

fof(bitBlastConstant_1068,axiom,
    ~ b000000100000000000000000000(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges9,axiom,
    ! [VarCurr] :
      ( v3593(VarCurr)
     => ! [B] :
          ( range_26_0(B)
         => ( v3562(VarCurr,B)
          <=> b000000010000000000000000000(B) ) ) ) ).

fof(bitBlastConstant_1067,axiom,
    ~ b000000010000000000000000000(bitIndex26) ).

fof(bitBlastConstant_1066,axiom,
    ~ b000000010000000000000000000(bitIndex25) ).

fof(bitBlastConstant_1065,axiom,
    ~ b000000010000000000000000000(bitIndex24) ).

fof(bitBlastConstant_1064,axiom,
    ~ b000000010000000000000000000(bitIndex23) ).

fof(bitBlastConstant_1063,axiom,
    ~ b000000010000000000000000000(bitIndex22) ).

fof(bitBlastConstant_1062,axiom,
    ~ b000000010000000000000000000(bitIndex21) ).

fof(bitBlastConstant_1061,axiom,
    ~ b000000010000000000000000000(bitIndex20) ).

fof(bitBlastConstant_1060,axiom,
    b000000010000000000000000000(bitIndex19) ).

fof(bitBlastConstant_1059,axiom,
    ~ b000000010000000000000000000(bitIndex18) ).

fof(bitBlastConstant_1058,axiom,
    ~ b000000010000000000000000000(bitIndex17) ).

fof(bitBlastConstant_1057,axiom,
    ~ b000000010000000000000000000(bitIndex16) ).

fof(bitBlastConstant_1056,axiom,
    ~ b000000010000000000000000000(bitIndex15) ).

fof(bitBlastConstant_1055,axiom,
    ~ b000000010000000000000000000(bitIndex14) ).

fof(bitBlastConstant_1054,axiom,
    ~ b000000010000000000000000000(bitIndex13) ).

fof(bitBlastConstant_1053,axiom,
    ~ b000000010000000000000000000(bitIndex12) ).

fof(bitBlastConstant_1052,axiom,
    ~ b000000010000000000000000000(bitIndex11) ).

fof(bitBlastConstant_1051,axiom,
    ~ b000000010000000000000000000(bitIndex10) ).

fof(bitBlastConstant_1050,axiom,
    ~ b000000010000000000000000000(bitIndex9) ).

fof(bitBlastConstant_1049,axiom,
    ~ b000000010000000000000000000(bitIndex8) ).

fof(bitBlastConstant_1048,axiom,
    ~ b000000010000000000000000000(bitIndex7) ).

fof(bitBlastConstant_1047,axiom,
    ~ b000000010000000000000000000(bitIndex6) ).

fof(bitBlastConstant_1046,axiom,
    ~ b000000010000000000000000000(bitIndex5) ).

fof(bitBlastConstant_1045,axiom,
    ~ b000000010000000000000000000(bitIndex4) ).

fof(bitBlastConstant_1044,axiom,
    ~ b000000010000000000000000000(bitIndex3) ).

fof(bitBlastConstant_1043,axiom,
    ~ b000000010000000000000000000(bitIndex2) ).

fof(bitBlastConstant_1042,axiom,
    ~ b000000010000000000000000000(bitIndex1) ).

fof(bitBlastConstant_1041,axiom,
    ~ b000000010000000000000000000(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges8,axiom,
    ! [VarCurr] :
      ( v3592(VarCurr)
     => ! [B] :
          ( range_26_0(B)
         => ( v3562(VarCurr,B)
          <=> b000000001000000000000000000(B) ) ) ) ).

fof(bitBlastConstant_1040,axiom,
    ~ b000000001000000000000000000(bitIndex26) ).

fof(bitBlastConstant_1039,axiom,
    ~ b000000001000000000000000000(bitIndex25) ).

fof(bitBlastConstant_1038,axiom,
    ~ b000000001000000000000000000(bitIndex24) ).

fof(bitBlastConstant_1037,axiom,
    ~ b000000001000000000000000000(bitIndex23) ).

fof(bitBlastConstant_1036,axiom,
    ~ b000000001000000000000000000(bitIndex22) ).

fof(bitBlastConstant_1035,axiom,
    ~ b000000001000000000000000000(bitIndex21) ).

fof(bitBlastConstant_1034,axiom,
    ~ b000000001000000000000000000(bitIndex20) ).

fof(bitBlastConstant_1033,axiom,
    ~ b000000001000000000000000000(bitIndex19) ).

fof(bitBlastConstant_1032,axiom,
    b000000001000000000000000000(bitIndex18) ).

fof(bitBlastConstant_1031,axiom,
    ~ b000000001000000000000000000(bitIndex17) ).

fof(bitBlastConstant_1030,axiom,
    ~ b000000001000000000000000000(bitIndex16) ).

fof(bitBlastConstant_1029,axiom,
    ~ b000000001000000000000000000(bitIndex15) ).

fof(bitBlastConstant_1028,axiom,
    ~ b000000001000000000000000000(bitIndex14) ).

fof(bitBlastConstant_1027,axiom,
    ~ b000000001000000000000000000(bitIndex13) ).

fof(bitBlastConstant_1026,axiom,
    ~ b000000001000000000000000000(bitIndex12) ).

fof(bitBlastConstant_1025,axiom,
    ~ b000000001000000000000000000(bitIndex11) ).

fof(bitBlastConstant_1024,axiom,
    ~ b000000001000000000000000000(bitIndex10) ).

fof(bitBlastConstant_1023,axiom,
    ~ b000000001000000000000000000(bitIndex9) ).

fof(bitBlastConstant_1022,axiom,
    ~ b000000001000000000000000000(bitIndex8) ).

fof(bitBlastConstant_1021,axiom,
    ~ b000000001000000000000000000(bitIndex7) ).

fof(bitBlastConstant_1020,axiom,
    ~ b000000001000000000000000000(bitIndex6) ).

fof(bitBlastConstant_1019,axiom,
    ~ b000000001000000000000000000(bitIndex5) ).

fof(bitBlastConstant_1018,axiom,
    ~ b000000001000000000000000000(bitIndex4) ).

fof(bitBlastConstant_1017,axiom,
    ~ b000000001000000000000000000(bitIndex3) ).

fof(bitBlastConstant_1016,axiom,
    ~ b000000001000000000000000000(bitIndex2) ).

fof(bitBlastConstant_1015,axiom,
    ~ b000000001000000000000000000(bitIndex1) ).

fof(bitBlastConstant_1014,axiom,
    ~ b000000001000000000000000000(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges7,axiom,
    ! [VarCurr] :
      ( v3591(VarCurr)
     => ! [B] :
          ( range_26_0(B)
         => ( v3562(VarCurr,B)
          <=> b000000000100000000000000000(B) ) ) ) ).

fof(bitBlastConstant_1013,axiom,
    ~ b000000000100000000000000000(bitIndex26) ).

fof(bitBlastConstant_1012,axiom,
    ~ b000000000100000000000000000(bitIndex25) ).

fof(bitBlastConstant_1011,axiom,
    ~ b000000000100000000000000000(bitIndex24) ).

fof(bitBlastConstant_1010,axiom,
    ~ b000000000100000000000000000(bitIndex23) ).

fof(bitBlastConstant_1009,axiom,
    ~ b000000000100000000000000000(bitIndex22) ).

fof(bitBlastConstant_1008,axiom,
    ~ b000000000100000000000000000(bitIndex21) ).

fof(bitBlastConstant_1007,axiom,
    ~ b000000000100000000000000000(bitIndex20) ).

fof(bitBlastConstant_1006,axiom,
    ~ b000000000100000000000000000(bitIndex19) ).

fof(bitBlastConstant_1005,axiom,
    ~ b000000000100000000000000000(bitIndex18) ).

fof(bitBlastConstant_1004,axiom,
    b000000000100000000000000000(bitIndex17) ).

fof(bitBlastConstant_1003,axiom,
    ~ b000000000100000000000000000(bitIndex16) ).

fof(bitBlastConstant_1002,axiom,
    ~ b000000000100000000000000000(bitIndex15) ).

fof(bitBlastConstant_1001,axiom,
    ~ b000000000100000000000000000(bitIndex14) ).

fof(bitBlastConstant_1000,axiom,
    ~ b000000000100000000000000000(bitIndex13) ).

fof(bitBlastConstant_999,axiom,
    ~ b000000000100000000000000000(bitIndex12) ).

fof(bitBlastConstant_998,axiom,
    ~ b000000000100000000000000000(bitIndex11) ).

fof(bitBlastConstant_997,axiom,
    ~ b000000000100000000000000000(bitIndex10) ).

fof(bitBlastConstant_996,axiom,
    ~ b000000000100000000000000000(bitIndex9) ).

fof(bitBlastConstant_995,axiom,
    ~ b000000000100000000000000000(bitIndex8) ).

fof(bitBlastConstant_994,axiom,
    ~ b000000000100000000000000000(bitIndex7) ).

fof(bitBlastConstant_993,axiom,
    ~ b000000000100000000000000000(bitIndex6) ).

fof(bitBlastConstant_992,axiom,
    ~ b000000000100000000000000000(bitIndex5) ).

fof(bitBlastConstant_991,axiom,
    ~ b000000000100000000000000000(bitIndex4) ).

fof(bitBlastConstant_990,axiom,
    ~ b000000000100000000000000000(bitIndex3) ).

fof(bitBlastConstant_989,axiom,
    ~ b000000000100000000000000000(bitIndex2) ).

fof(bitBlastConstant_988,axiom,
    ~ b000000000100000000000000000(bitIndex1) ).

fof(bitBlastConstant_987,axiom,
    ~ b000000000100000000000000000(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges6,axiom,
    ! [VarCurr] :
      ( v3590(VarCurr)
     => ! [B] :
          ( range_26_0(B)
         => ( v3562(VarCurr,B)
          <=> b000000000010000000000000000(B) ) ) ) ).

fof(bitBlastConstant_986,axiom,
    ~ b000000000010000000000000000(bitIndex26) ).

fof(bitBlastConstant_985,axiom,
    ~ b000000000010000000000000000(bitIndex25) ).

fof(bitBlastConstant_984,axiom,
    ~ b000000000010000000000000000(bitIndex24) ).

fof(bitBlastConstant_983,axiom,
    ~ b000000000010000000000000000(bitIndex23) ).

fof(bitBlastConstant_982,axiom,
    ~ b000000000010000000000000000(bitIndex22) ).

fof(bitBlastConstant_981,axiom,
    ~ b000000000010000000000000000(bitIndex21) ).

fof(bitBlastConstant_980,axiom,
    ~ b000000000010000000000000000(bitIndex20) ).

fof(bitBlastConstant_979,axiom,
    ~ b000000000010000000000000000(bitIndex19) ).

fof(bitBlastConstant_978,axiom,
    ~ b000000000010000000000000000(bitIndex18) ).

fof(bitBlastConstant_977,axiom,
    ~ b000000000010000000000000000(bitIndex17) ).

fof(bitBlastConstant_976,axiom,
    b000000000010000000000000000(bitIndex16) ).

fof(bitBlastConstant_975,axiom,
    ~ b000000000010000000000000000(bitIndex15) ).

fof(bitBlastConstant_974,axiom,
    ~ b000000000010000000000000000(bitIndex14) ).

fof(bitBlastConstant_973,axiom,
    ~ b000000000010000000000000000(bitIndex13) ).

fof(bitBlastConstant_972,axiom,
    ~ b000000000010000000000000000(bitIndex12) ).

fof(bitBlastConstant_971,axiom,
    ~ b000000000010000000000000000(bitIndex11) ).

fof(bitBlastConstant_970,axiom,
    ~ b000000000010000000000000000(bitIndex10) ).

fof(bitBlastConstant_969,axiom,
    ~ b000000000010000000000000000(bitIndex9) ).

fof(bitBlastConstant_968,axiom,
    ~ b000000000010000000000000000(bitIndex8) ).

fof(bitBlastConstant_967,axiom,
    ~ b000000000010000000000000000(bitIndex7) ).

fof(bitBlastConstant_966,axiom,
    ~ b000000000010000000000000000(bitIndex6) ).

fof(bitBlastConstant_965,axiom,
    ~ b000000000010000000000000000(bitIndex5) ).

fof(bitBlastConstant_964,axiom,
    ~ b000000000010000000000000000(bitIndex4) ).

fof(bitBlastConstant_963,axiom,
    ~ b000000000010000000000000000(bitIndex3) ).

fof(bitBlastConstant_962,axiom,
    ~ b000000000010000000000000000(bitIndex2) ).

fof(bitBlastConstant_961,axiom,
    ~ b000000000010000000000000000(bitIndex1) ).

fof(bitBlastConstant_960,axiom,
    ~ b000000000010000000000000000(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges5_2,axiom,
    ! [VarCurr] :
      ( v3589(VarCurr)
     => ! [B] :
          ( range_26_0(B)
         => ( v3562(VarCurr,B)
          <=> b000000000001000000000000000(B) ) ) ) ).

fof(bitBlastConstant_959,axiom,
    ~ b000000000001000000000000000(bitIndex26) ).

fof(bitBlastConstant_958,axiom,
    ~ b000000000001000000000000000(bitIndex25) ).

fof(bitBlastConstant_957,axiom,
    ~ b000000000001000000000000000(bitIndex24) ).

fof(bitBlastConstant_956,axiom,
    ~ b000000000001000000000000000(bitIndex23) ).

fof(bitBlastConstant_955,axiom,
    ~ b000000000001000000000000000(bitIndex22) ).

fof(bitBlastConstant_954,axiom,
    ~ b000000000001000000000000000(bitIndex21) ).

fof(bitBlastConstant_953,axiom,
    ~ b000000000001000000000000000(bitIndex20) ).

fof(bitBlastConstant_952,axiom,
    ~ b000000000001000000000000000(bitIndex19) ).

fof(bitBlastConstant_951,axiom,
    ~ b000000000001000000000000000(bitIndex18) ).

fof(bitBlastConstant_950,axiom,
    ~ b000000000001000000000000000(bitIndex17) ).

fof(bitBlastConstant_949,axiom,
    ~ b000000000001000000000000000(bitIndex16) ).

fof(bitBlastConstant_948,axiom,
    b000000000001000000000000000(bitIndex15) ).

fof(bitBlastConstant_947,axiom,
    ~ b000000000001000000000000000(bitIndex14) ).

fof(bitBlastConstant_946,axiom,
    ~ b000000000001000000000000000(bitIndex13) ).

fof(bitBlastConstant_945,axiom,
    ~ b000000000001000000000000000(bitIndex12) ).

fof(bitBlastConstant_944,axiom,
    ~ b000000000001000000000000000(bitIndex11) ).

fof(bitBlastConstant_943,axiom,
    ~ b000000000001000000000000000(bitIndex10) ).

fof(bitBlastConstant_942,axiom,
    ~ b000000000001000000000000000(bitIndex9) ).

fof(bitBlastConstant_941,axiom,
    ~ b000000000001000000000000000(bitIndex8) ).

fof(bitBlastConstant_940,axiom,
    ~ b000000000001000000000000000(bitIndex7) ).

fof(bitBlastConstant_939,axiom,
    ~ b000000000001000000000000000(bitIndex6) ).

fof(bitBlastConstant_938,axiom,
    ~ b000000000001000000000000000(bitIndex5) ).

fof(bitBlastConstant_937,axiom,
    ~ b000000000001000000000000000(bitIndex4) ).

fof(bitBlastConstant_936,axiom,
    ~ b000000000001000000000000000(bitIndex3) ).

fof(bitBlastConstant_935,axiom,
    ~ b000000000001000000000000000(bitIndex2) ).

fof(bitBlastConstant_934,axiom,
    ~ b000000000001000000000000000(bitIndex1) ).

fof(bitBlastConstant_933,axiom,
    ~ b000000000001000000000000000(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges4_2,axiom,
    ! [VarCurr] :
      ( v3588(VarCurr)
     => ! [B] :
          ( range_26_0(B)
         => ( v3562(VarCurr,B)
          <=> b000000000000100000000000000(B) ) ) ) ).

fof(bitBlastConstant_932,axiom,
    ~ b000000000000100000000000000(bitIndex26) ).

fof(bitBlastConstant_931,axiom,
    ~ b000000000000100000000000000(bitIndex25) ).

fof(bitBlastConstant_930,axiom,
    ~ b000000000000100000000000000(bitIndex24) ).

fof(bitBlastConstant_929,axiom,
    ~ b000000000000100000000000000(bitIndex23) ).

fof(bitBlastConstant_928,axiom,
    ~ b000000000000100000000000000(bitIndex22) ).

fof(bitBlastConstant_927,axiom,
    ~ b000000000000100000000000000(bitIndex21) ).

fof(bitBlastConstant_926,axiom,
    ~ b000000000000100000000000000(bitIndex20) ).

fof(bitBlastConstant_925,axiom,
    ~ b000000000000100000000000000(bitIndex19) ).

fof(bitBlastConstant_924,axiom,
    ~ b000000000000100000000000000(bitIndex18) ).

fof(bitBlastConstant_923,axiom,
    ~ b000000000000100000000000000(bitIndex17) ).

fof(bitBlastConstant_922,axiom,
    ~ b000000000000100000000000000(bitIndex16) ).

fof(bitBlastConstant_921,axiom,
    ~ b000000000000100000000000000(bitIndex15) ).

fof(bitBlastConstant_920,axiom,
    b000000000000100000000000000(bitIndex14) ).

fof(bitBlastConstant_919,axiom,
    ~ b000000000000100000000000000(bitIndex13) ).

fof(bitBlastConstant_918,axiom,
    ~ b000000000000100000000000000(bitIndex12) ).

fof(bitBlastConstant_917,axiom,
    ~ b000000000000100000000000000(bitIndex11) ).

fof(bitBlastConstant_916,axiom,
    ~ b000000000000100000000000000(bitIndex10) ).

fof(bitBlastConstant_915,axiom,
    ~ b000000000000100000000000000(bitIndex9) ).

fof(bitBlastConstant_914,axiom,
    ~ b000000000000100000000000000(bitIndex8) ).

fof(bitBlastConstant_913,axiom,
    ~ b000000000000100000000000000(bitIndex7) ).

fof(bitBlastConstant_912,axiom,
    ~ b000000000000100000000000000(bitIndex6) ).

fof(bitBlastConstant_911,axiom,
    ~ b000000000000100000000000000(bitIndex5) ).

fof(bitBlastConstant_910,axiom,
    ~ b000000000000100000000000000(bitIndex4) ).

fof(bitBlastConstant_909,axiom,
    ~ b000000000000100000000000000(bitIndex3) ).

fof(bitBlastConstant_908,axiom,
    ~ b000000000000100000000000000(bitIndex2) ).

fof(bitBlastConstant_907,axiom,
    ~ b000000000000100000000000000(bitIndex1) ).

fof(bitBlastConstant_906,axiom,
    ~ b000000000000100000000000000(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges3_12,axiom,
    ! [VarCurr] :
      ( v3587(VarCurr)
     => ! [B] :
          ( range_26_0(B)
         => ( v3562(VarCurr,B)
          <=> b000000000000010000000000000(B) ) ) ) ).

fof(bitBlastConstant_905,axiom,
    ~ b000000000000010000000000000(bitIndex26) ).

fof(bitBlastConstant_904,axiom,
    ~ b000000000000010000000000000(bitIndex25) ).

fof(bitBlastConstant_903,axiom,
    ~ b000000000000010000000000000(bitIndex24) ).

fof(bitBlastConstant_902,axiom,
    ~ b000000000000010000000000000(bitIndex23) ).

fof(bitBlastConstant_901,axiom,
    ~ b000000000000010000000000000(bitIndex22) ).

fof(bitBlastConstant_900,axiom,
    ~ b000000000000010000000000000(bitIndex21) ).

fof(bitBlastConstant_899,axiom,
    ~ b000000000000010000000000000(bitIndex20) ).

fof(bitBlastConstant_898,axiom,
    ~ b000000000000010000000000000(bitIndex19) ).

fof(bitBlastConstant_897,axiom,
    ~ b000000000000010000000000000(bitIndex18) ).

fof(bitBlastConstant_896,axiom,
    ~ b000000000000010000000000000(bitIndex17) ).

fof(bitBlastConstant_895,axiom,
    ~ b000000000000010000000000000(bitIndex16) ).

fof(bitBlastConstant_894,axiom,
    ~ b000000000000010000000000000(bitIndex15) ).

fof(bitBlastConstant_893,axiom,
    ~ b000000000000010000000000000(bitIndex14) ).

fof(bitBlastConstant_892,axiom,
    b000000000000010000000000000(bitIndex13) ).

fof(bitBlastConstant_891,axiom,
    ~ b000000000000010000000000000(bitIndex12) ).

fof(bitBlastConstant_890,axiom,
    ~ b000000000000010000000000000(bitIndex11) ).

fof(bitBlastConstant_889,axiom,
    ~ b000000000000010000000000000(bitIndex10) ).

fof(bitBlastConstant_888,axiom,
    ~ b000000000000010000000000000(bitIndex9) ).

fof(bitBlastConstant_887,axiom,
    ~ b000000000000010000000000000(bitIndex8) ).

fof(bitBlastConstant_886,axiom,
    ~ b000000000000010000000000000(bitIndex7) ).

fof(bitBlastConstant_885,axiom,
    ~ b000000000000010000000000000(bitIndex6) ).

fof(bitBlastConstant_884,axiom,
    ~ b000000000000010000000000000(bitIndex5) ).

fof(bitBlastConstant_883,axiom,
    ~ b000000000000010000000000000(bitIndex4) ).

fof(bitBlastConstant_882,axiom,
    ~ b000000000000010000000000000(bitIndex3) ).

fof(bitBlastConstant_881,axiom,
    ~ b000000000000010000000000000(bitIndex2) ).

fof(bitBlastConstant_880,axiom,
    ~ b000000000000010000000000000(bitIndex1) ).

fof(bitBlastConstant_879,axiom,
    ~ b000000000000010000000000000(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges2_22,axiom,
    ! [VarCurr] :
      ( v3586(VarCurr)
     => ! [B] :
          ( range_26_0(B)
         => ( v3562(VarCurr,B)
          <=> b000000000000001000000000000(B) ) ) ) ).

fof(bitBlastConstant_878,axiom,
    ~ b000000000000001000000000000(bitIndex26) ).

fof(bitBlastConstant_877,axiom,
    ~ b000000000000001000000000000(bitIndex25) ).

fof(bitBlastConstant_876,axiom,
    ~ b000000000000001000000000000(bitIndex24) ).

fof(bitBlastConstant_875,axiom,
    ~ b000000000000001000000000000(bitIndex23) ).

fof(bitBlastConstant_874,axiom,
    ~ b000000000000001000000000000(bitIndex22) ).

fof(bitBlastConstant_873,axiom,
    ~ b000000000000001000000000000(bitIndex21) ).

fof(bitBlastConstant_872,axiom,
    ~ b000000000000001000000000000(bitIndex20) ).

fof(bitBlastConstant_871,axiom,
    ~ b000000000000001000000000000(bitIndex19) ).

fof(bitBlastConstant_870,axiom,
    ~ b000000000000001000000000000(bitIndex18) ).

fof(bitBlastConstant_869,axiom,
    ~ b000000000000001000000000000(bitIndex17) ).

fof(bitBlastConstant_868,axiom,
    ~ b000000000000001000000000000(bitIndex16) ).

fof(bitBlastConstant_867,axiom,
    ~ b000000000000001000000000000(bitIndex15) ).

fof(bitBlastConstant_866,axiom,
    ~ b000000000000001000000000000(bitIndex14) ).

fof(bitBlastConstant_865,axiom,
    ~ b000000000000001000000000000(bitIndex13) ).

fof(bitBlastConstant_864,axiom,
    b000000000000001000000000000(bitIndex12) ).

fof(bitBlastConstant_863,axiom,
    ~ b000000000000001000000000000(bitIndex11) ).

fof(bitBlastConstant_862,axiom,
    ~ b000000000000001000000000000(bitIndex10) ).

fof(bitBlastConstant_861,axiom,
    ~ b000000000000001000000000000(bitIndex9) ).

fof(bitBlastConstant_860,axiom,
    ~ b000000000000001000000000000(bitIndex8) ).

fof(bitBlastConstant_859,axiom,
    ~ b000000000000001000000000000(bitIndex7) ).

fof(bitBlastConstant_858,axiom,
    ~ b000000000000001000000000000(bitIndex6) ).

fof(bitBlastConstant_857,axiom,
    ~ b000000000000001000000000000(bitIndex5) ).

fof(bitBlastConstant_856,axiom,
    ~ b000000000000001000000000000(bitIndex4) ).

fof(bitBlastConstant_855,axiom,
    ~ b000000000000001000000000000(bitIndex3) ).

fof(bitBlastConstant_854,axiom,
    ~ b000000000000001000000000000(bitIndex2) ).

fof(bitBlastConstant_853,axiom,
    ~ b000000000000001000000000000(bitIndex1) ).

fof(bitBlastConstant_852,axiom,
    ~ b000000000000001000000000000(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges1_40,axiom,
    ! [VarCurr] :
      ( v3585(VarCurr)
     => ! [B] :
          ( range_26_0(B)
         => ( v3562(VarCurr,B)
          <=> b000000000000000100000000000(B) ) ) ) ).

fof(bitBlastConstant_851,axiom,
    ~ b000000000000000100000000000(bitIndex26) ).

fof(bitBlastConstant_850,axiom,
    ~ b000000000000000100000000000(bitIndex25) ).

fof(bitBlastConstant_849,axiom,
    ~ b000000000000000100000000000(bitIndex24) ).

fof(bitBlastConstant_848,axiom,
    ~ b000000000000000100000000000(bitIndex23) ).

fof(bitBlastConstant_847,axiom,
    ~ b000000000000000100000000000(bitIndex22) ).

fof(bitBlastConstant_846,axiom,
    ~ b000000000000000100000000000(bitIndex21) ).

fof(bitBlastConstant_845,axiom,
    ~ b000000000000000100000000000(bitIndex20) ).

fof(bitBlastConstant_844,axiom,
    ~ b000000000000000100000000000(bitIndex19) ).

fof(bitBlastConstant_843,axiom,
    ~ b000000000000000100000000000(bitIndex18) ).

fof(bitBlastConstant_842,axiom,
    ~ b000000000000000100000000000(bitIndex17) ).

fof(bitBlastConstant_841,axiom,
    ~ b000000000000000100000000000(bitIndex16) ).

fof(bitBlastConstant_840,axiom,
    ~ b000000000000000100000000000(bitIndex15) ).

fof(bitBlastConstant_839,axiom,
    ~ b000000000000000100000000000(bitIndex14) ).

fof(bitBlastConstant_838,axiom,
    ~ b000000000000000100000000000(bitIndex13) ).

fof(bitBlastConstant_837,axiom,
    ~ b000000000000000100000000000(bitIndex12) ).

fof(bitBlastConstant_836,axiom,
    b000000000000000100000000000(bitIndex11) ).

fof(bitBlastConstant_835,axiom,
    ~ b000000000000000100000000000(bitIndex10) ).

fof(bitBlastConstant_834,axiom,
    ~ b000000000000000100000000000(bitIndex9) ).

fof(bitBlastConstant_833,axiom,
    ~ b000000000000000100000000000(bitIndex8) ).

fof(bitBlastConstant_832,axiom,
    ~ b000000000000000100000000000(bitIndex7) ).

fof(bitBlastConstant_831,axiom,
    ~ b000000000000000100000000000(bitIndex6) ).

fof(bitBlastConstant_830,axiom,
    ~ b000000000000000100000000000(bitIndex5) ).

fof(bitBlastConstant_829,axiom,
    ~ b000000000000000100000000000(bitIndex4) ).

fof(bitBlastConstant_828,axiom,
    ~ b000000000000000100000000000(bitIndex3) ).

fof(bitBlastConstant_827,axiom,
    ~ b000000000000000100000000000(bitIndex2) ).

fof(bitBlastConstant_826,axiom,
    ~ b000000000000000100000000000(bitIndex1) ).

fof(bitBlastConstant_825,axiom,
    ~ b000000000000000100000000000(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges0_39,axiom,
    ! [VarCurr] :
      ( v3584(VarCurr)
     => ! [B] :
          ( range_26_0(B)
         => ( v3562(VarCurr,B)
          <=> b000000000000000010000000000(B) ) ) ) ).

fof(range_axiom_26,axiom,
    ! [B] :
      ( range_26_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B ) ) ).

fof(bitBlastConstant_824,axiom,
    ~ b000000000000000010000000000(bitIndex26) ).

fof(bitBlastConstant_823,axiom,
    ~ b000000000000000010000000000(bitIndex25) ).

fof(bitBlastConstant_822,axiom,
    ~ b000000000000000010000000000(bitIndex24) ).

fof(bitBlastConstant_821,axiom,
    ~ b000000000000000010000000000(bitIndex23) ).

fof(bitBlastConstant_820,axiom,
    ~ b000000000000000010000000000(bitIndex22) ).

fof(bitBlastConstant_819,axiom,
    ~ b000000000000000010000000000(bitIndex21) ).

fof(bitBlastConstant_818,axiom,
    ~ b000000000000000010000000000(bitIndex20) ).

fof(bitBlastConstant_817,axiom,
    ~ b000000000000000010000000000(bitIndex19) ).

fof(bitBlastConstant_816,axiom,
    ~ b000000000000000010000000000(bitIndex18) ).

fof(bitBlastConstant_815,axiom,
    ~ b000000000000000010000000000(bitIndex17) ).

fof(bitBlastConstant_814,axiom,
    ~ b000000000000000010000000000(bitIndex16) ).

fof(bitBlastConstant_813,axiom,
    ~ b000000000000000010000000000(bitIndex15) ).

fof(bitBlastConstant_812,axiom,
    ~ b000000000000000010000000000(bitIndex14) ).

fof(bitBlastConstant_811,axiom,
    ~ b000000000000000010000000000(bitIndex13) ).

fof(bitBlastConstant_810,axiom,
    ~ b000000000000000010000000000(bitIndex12) ).

fof(bitBlastConstant_809,axiom,
    ~ b000000000000000010000000000(bitIndex11) ).

fof(bitBlastConstant_808,axiom,
    b000000000000000010000000000(bitIndex10) ).

fof(bitBlastConstant_807,axiom,
    ~ b000000000000000010000000000(bitIndex9) ).

fof(bitBlastConstant_806,axiom,
    ~ b000000000000000010000000000(bitIndex8) ).

fof(bitBlastConstant_805,axiom,
    ~ b000000000000000010000000000(bitIndex7) ).

fof(bitBlastConstant_804,axiom,
    ~ b000000000000000010000000000(bitIndex6) ).

fof(bitBlastConstant_803,axiom,
    ~ b000000000000000010000000000(bitIndex5) ).

fof(bitBlastConstant_802,axiom,
    ~ b000000000000000010000000000(bitIndex4) ).

fof(bitBlastConstant_801,axiom,
    ~ b000000000000000010000000000(bitIndex3) ).

fof(bitBlastConstant_800,axiom,
    ~ b000000000000000010000000000(bitIndex2) ).

fof(bitBlastConstant_799,axiom,
    ~ b000000000000000010000000000(bitIndex1) ).

fof(bitBlastConstant_798,axiom,
    ~ b000000000000000010000000000(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_234,axiom,
    ! [VarCurr] :
      ( v3599(VarCurr)
    <=> ( ( v3564(VarCurr,bitIndex3)
        <=> $true )
        & ( v3564(VarCurr,bitIndex2)
        <=> $true )
        & ( v3564(VarCurr,bitIndex1)
        <=> $true )
        & ( v3564(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_797,axiom,
    b1111(bitIndex3) ).

fof(bitBlastConstant_796,axiom,
    b1111(bitIndex2) ).

fof(bitBlastConstant_795,axiom,
    b1111(bitIndex1) ).

fof(bitBlastConstant_794,axiom,
    b1111(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_233,axiom,
    ! [VarCurr] :
      ( v3598(VarCurr)
    <=> ( ( v3564(VarCurr,bitIndex3)
        <=> $true )
        & ( v3564(VarCurr,bitIndex2)
        <=> $true )
        & ( v3564(VarCurr,bitIndex1)
        <=> $true )
        & ( v3564(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_793,axiom,
    b1110(bitIndex3) ).

fof(bitBlastConstant_792,axiom,
    b1110(bitIndex2) ).

fof(bitBlastConstant_791,axiom,
    b1110(bitIndex1) ).

fof(bitBlastConstant_790,axiom,
    ~ b1110(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_232,axiom,
    ! [VarCurr] :
      ( v3597(VarCurr)
    <=> ( ( v3564(VarCurr,bitIndex3)
        <=> $true )
        & ( v3564(VarCurr,bitIndex2)
        <=> $true )
        & ( v3564(VarCurr,bitIndex1)
        <=> $false )
        & ( v3564(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_231,axiom,
    ! [VarCurr] :
      ( v3596(VarCurr)
    <=> ( ( v3564(VarCurr,bitIndex3)
        <=> $true )
        & ( v3564(VarCurr,bitIndex2)
        <=> $true )
        & ( v3564(VarCurr,bitIndex1)
        <=> $false )
        & ( v3564(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_230,axiom,
    ! [VarCurr] :
      ( v3595(VarCurr)
    <=> ( ( v3564(VarCurr,bitIndex3)
        <=> $true )
        & ( v3564(VarCurr,bitIndex2)
        <=> $false )
        & ( v3564(VarCurr,bitIndex1)
        <=> $true )
        & ( v3564(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_229,axiom,
    ! [VarCurr] :
      ( v3594(VarCurr)
    <=> ( ( v3564(VarCurr,bitIndex3)
        <=> $true )
        & ( v3564(VarCurr,bitIndex2)
        <=> $false )
        & ( v3564(VarCurr,bitIndex1)
        <=> $true )
        & ( v3564(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_228,axiom,
    ! [VarCurr] :
      ( v3593(VarCurr)
    <=> ( ( v3564(VarCurr,bitIndex3)
        <=> $true )
        & ( v3564(VarCurr,bitIndex2)
        <=> $false )
        & ( v3564(VarCurr,bitIndex1)
        <=> $false )
        & ( v3564(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_227,axiom,
    ! [VarCurr] :
      ( v3592(VarCurr)
    <=> ( ( v3564(VarCurr,bitIndex3)
        <=> $true )
        & ( v3564(VarCurr,bitIndex2)
        <=> $false )
        & ( v3564(VarCurr,bitIndex1)
        <=> $false )
        & ( v3564(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_226,axiom,
    ! [VarCurr] :
      ( v3591(VarCurr)
    <=> ( ( v3564(VarCurr,bitIndex3)
        <=> $false )
        & ( v3564(VarCurr,bitIndex2)
        <=> $true )
        & ( v3564(VarCurr,bitIndex1)
        <=> $true )
        & ( v3564(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_225,axiom,
    ! [VarCurr] :
      ( v3590(VarCurr)
    <=> ( ( v3564(VarCurr,bitIndex3)
        <=> $false )
        & ( v3564(VarCurr,bitIndex2)
        <=> $true )
        & ( v3564(VarCurr,bitIndex1)
        <=> $true )
        & ( v3564(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_224,axiom,
    ! [VarCurr] :
      ( v3589(VarCurr)
    <=> ( ( v3564(VarCurr,bitIndex3)
        <=> $false )
        & ( v3564(VarCurr,bitIndex2)
        <=> $true )
        & ( v3564(VarCurr,bitIndex1)
        <=> $false )
        & ( v3564(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_223,axiom,
    ! [VarCurr] :
      ( v3588(VarCurr)
    <=> ( ( v3564(VarCurr,bitIndex3)
        <=> $false )
        & ( v3564(VarCurr,bitIndex2)
        <=> $true )
        & ( v3564(VarCurr,bitIndex1)
        <=> $false )
        & ( v3564(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_222,axiom,
    ! [VarCurr] :
      ( v3587(VarCurr)
    <=> ( ( v3564(VarCurr,bitIndex3)
        <=> $false )
        & ( v3564(VarCurr,bitIndex2)
        <=> $false )
        & ( v3564(VarCurr,bitIndex1)
        <=> $true )
        & ( v3564(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_221,axiom,
    ! [VarCurr] :
      ( v3586(VarCurr)
    <=> ( ( v3564(VarCurr,bitIndex3)
        <=> $false )
        & ( v3564(VarCurr,bitIndex2)
        <=> $false )
        & ( v3564(VarCurr,bitIndex1)
        <=> $true )
        & ( v3564(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_220,axiom,
    ! [VarCurr] :
      ( v3585(VarCurr)
    <=> ( ( v3564(VarCurr,bitIndex3)
        <=> $false )
        & ( v3564(VarCurr,bitIndex2)
        <=> $false )
        & ( v3564(VarCurr,bitIndex1)
        <=> $false )
        & ( v3564(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_219,axiom,
    ! [VarCurr] :
      ( v3584(VarCurr)
    <=> ( ( v3564(VarCurr,bitIndex3)
        <=> $false )
        & ( v3564(VarCurr,bitIndex2)
        <=> $false )
        & ( v3564(VarCurr,bitIndex1)
        <=> $false )
        & ( v3564(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignmentInitValueVector_54,axiom,
    ! [B] :
      ( range_3_0(B)
     => ( v3564(constB0,B)
      <=> $false ) ) ).

fof(addAssignment_1129,axiom,
    ! [VarCurr] :
      ( v3542(VarCurr)
    <=> v3544(VarCurr) ) ).

fof(addAssignment_1128,axiom,
    ! [VarCurr] :
      ( v3544(VarCurr)
    <=> v183(VarCurr) ) ).

fof(addAssignment_1127,axiom,
    ! [VarCurr] :
      ( v3391(VarCurr,bitIndex1)
    <=> v3393(VarCurr,bitIndex1) ) ).

fof(addAssignment_1126,axiom,
    ! [VarCurr] :
      ( v3393(VarCurr,bitIndex1)
    <=> v3395(VarCurr,bitIndex1) ) ).

fof(addAssignment_1125,axiom,
    ! [VarCurr] :
      ( v3395(VarCurr,bitIndex1)
    <=> v3397(VarCurr,bitIndex1) ) ).

fof(addAssignment_1124,axiom,
    ! [VarCurr] :
      ( v3397(VarCurr,bitIndex1)
    <=> v3536(VarCurr,bitIndex1) ) ).

fof(addAssignment_1123,axiom,
    ! [VarCurr] :
      ( v3536(VarCurr,bitIndex0)
    <=> v3540(VarCurr) ) ).

fof(addAssignment_1122,axiom,
    ! [VarCurr] :
      ( v3536(VarCurr,bitIndex1)
    <=> v3537(VarCurr) ) ).

fof(writeUnaryOperator_201,axiom,
    ! [VarCurr] :
      ( ~ v3540(VarCurr)
    <=> v3399(VarCurr,bitIndex0) ) ).

fof(writeUnaryOperator_200,axiom,
    ! [VarCurr] :
      ( ~ v3537(VarCurr)
    <=> v3538(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_143,axiom,
    ! [VarCurr] :
      ( v3538(VarCurr)
    <=> ( v3399(VarCurr,bitIndex1)
        & v3539(VarCurr) ) ) ).

fof(writeUnaryOperator_199,axiom,
    ! [VarCurr] :
      ( ~ v3539(VarCurr)
    <=> v3535(VarCurr) ) ).

fof(addAssignment_1121,axiom,
    ! [VarCurr] :
      ( v3535(VarCurr)
    <=> v183(VarCurr) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges10,axiom,
    ! [VarCurr] :
      ( ( ~ v3478(VarCurr)
        & ~ v3490(VarCurr)
        & ~ v3499(VarCurr)
        & ~ v3507(VarCurr)
        & ~ v3514(VarCurr)
        & ~ v3520(VarCurr)
        & ~ v3525(VarCurr)
        & ~ v3529(VarCurr)
        & ~ v3532(VarCurr)
        & ~ v3533(VarCurr) )
     => ( v3399(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges9,axiom,
    ! [VarCurr] :
      ( v3533(VarCurr)
     => ( v3399(VarCurr,bitIndex1)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges8,axiom,
    ! [VarCurr] :
      ( v3532(VarCurr)
     => ( v3399(VarCurr,bitIndex1)
      <=> v3474(VarCurr,bitIndex29) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges7,axiom,
    ! [VarCurr] :
      ( v3529(VarCurr)
     => ( v3399(VarCurr,bitIndex1)
      <=> v3530(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges6,axiom,
    ! [VarCurr] :
      ( v3525(VarCurr)
     => ( v3399(VarCurr,bitIndex1)
      <=> v3526(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges5_1,axiom,
    ! [VarCurr] :
      ( v3520(VarCurr)
     => ( v3399(VarCurr,bitIndex1)
      <=> v3521(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges4_1,axiom,
    ! [VarCurr] :
      ( v3514(VarCurr)
     => ( v3399(VarCurr,bitIndex1)
      <=> v3515(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges3_1,axiom,
    ! [VarCurr] :
      ( v3507(VarCurr)
     => ( v3399(VarCurr,bitIndex1)
      <=> v3508(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges2_1,axiom,
    ! [VarCurr] :
      ( v3499(VarCurr)
     => ( v3399(VarCurr,bitIndex1)
      <=> v3500(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges1_2,axiom,
    ! [VarCurr] :
      ( v3490(VarCurr)
     => ( v3399(VarCurr,bitIndex1)
      <=> v3491(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_3,axiom,
    ! [VarCurr] :
      ( v3478(VarCurr)
     => ( v3399(VarCurr,bitIndex1)
      <=> v3479(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_218,axiom,
    ! [VarCurr] :
      ( v3533(VarCurr)
    <=> ( ( v3401(VarCurr,bitIndex3)
        <=> $true )
        & ( v3401(VarCurr,bitIndex2)
        <=> $false )
        & ( v3401(VarCurr,bitIndex1)
        <=> $false )
        & ( v3401(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_217,axiom,
    ! [VarCurr] :
      ( v3532(VarCurr)
    <=> ( ( v3401(VarCurr,bitIndex3)
        <=> $true )
        & ( v3401(VarCurr,bitIndex2)
        <=> $false )
        & ( v3401(VarCurr,bitIndex1)
        <=> $false )
        & ( v3401(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorShiftedRanges_142,axiom,
    ! [VarCurr] :
      ( v3530(VarCurr)
    <=> ( v3474(VarCurr,bitIndex28)
        & v3474(VarCurr,bitIndex29) ) ) ).

fof(addBitVectorEqualityBitBlasted_216,axiom,
    ! [VarCurr] :
      ( v3529(VarCurr)
    <=> ( ( v3401(VarCurr,bitIndex3)
        <=> $false )
        & ( v3401(VarCurr,bitIndex2)
        <=> $true )
        & ( v3401(VarCurr,bitIndex1)
        <=> $true )
        & ( v3401(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_789,axiom,
    ~ b0111(bitIndex3) ).

fof(bitBlastConstant_788,axiom,
    b0111(bitIndex2) ).

fof(bitBlastConstant_787,axiom,
    b0111(bitIndex1) ).

fof(bitBlastConstant_786,axiom,
    b0111(bitIndex0) ).

fof(writeBinaryOperatorShiftedRanges_141,axiom,
    ! [VarCurr] :
      ( v3526(VarCurr)
    <=> ( v3528(VarCurr)
        & v3474(VarCurr,bitIndex29) ) ) ).

fof(writeBinaryOperatorShiftedRanges_140,axiom,
    ! [VarCurr] :
      ( v3528(VarCurr)
    <=> ( v3474(VarCurr,bitIndex27)
        & v3474(VarCurr,bitIndex28) ) ) ).

fof(addBitVectorEqualityBitBlasted_215,axiom,
    ! [VarCurr] :
      ( v3525(VarCurr)
    <=> ( ( v3401(VarCurr,bitIndex3)
        <=> $false )
        & ( v3401(VarCurr,bitIndex2)
        <=> $true )
        & ( v3401(VarCurr,bitIndex1)
        <=> $true )
        & ( v3401(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_785,axiom,
    ~ b0110(bitIndex3) ).

fof(bitBlastConstant_784,axiom,
    b0110(bitIndex2) ).

fof(bitBlastConstant_783,axiom,
    b0110(bitIndex1) ).

fof(bitBlastConstant_782,axiom,
    ~ b0110(bitIndex0) ).

fof(writeBinaryOperatorShiftedRanges_139,axiom,
    ! [VarCurr] :
      ( v3521(VarCurr)
    <=> ( v3523(VarCurr)
        & v3474(VarCurr,bitIndex29) ) ) ).

fof(writeBinaryOperatorShiftedRanges_138,axiom,
    ! [VarCurr] :
      ( v3523(VarCurr)
    <=> ( v3524(VarCurr)
        & v3474(VarCurr,bitIndex28) ) ) ).

fof(writeBinaryOperatorShiftedRanges_137,axiom,
    ! [VarCurr] :
      ( v3524(VarCurr)
    <=> ( v3474(VarCurr,bitIndex26)
        & v3474(VarCurr,bitIndex27) ) ) ).

fof(addBitVectorEqualityBitBlasted_214,axiom,
    ! [VarCurr] :
      ( v3520(VarCurr)
    <=> ( ( v3401(VarCurr,bitIndex3)
        <=> $false )
        & ( v3401(VarCurr,bitIndex2)
        <=> $true )
        & ( v3401(VarCurr,bitIndex1)
        <=> $false )
        & ( v3401(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorShiftedRanges_136,axiom,
    ! [VarCurr] :
      ( v3515(VarCurr)
    <=> ( v3517(VarCurr)
        & v3474(VarCurr,bitIndex29) ) ) ).

fof(writeBinaryOperatorShiftedRanges_135,axiom,
    ! [VarCurr] :
      ( v3517(VarCurr)
    <=> ( v3518(VarCurr)
        & v3474(VarCurr,bitIndex28) ) ) ).

fof(writeBinaryOperatorShiftedRanges_134,axiom,
    ! [VarCurr] :
      ( v3518(VarCurr)
    <=> ( v3519(VarCurr)
        & v3474(VarCurr,bitIndex27) ) ) ).

fof(writeBinaryOperatorShiftedRanges_133,axiom,
    ! [VarCurr] :
      ( v3519(VarCurr)
    <=> ( v3474(VarCurr,bitIndex25)
        & v3474(VarCurr,bitIndex26) ) ) ).

fof(addBitVectorEqualityBitBlasted_213,axiom,
    ! [VarCurr] :
      ( v3514(VarCurr)
    <=> ( ( v3401(VarCurr,bitIndex3)
        <=> $false )
        & ( v3401(VarCurr,bitIndex2)
        <=> $true )
        & ( v3401(VarCurr,bitIndex1)
        <=> $false )
        & ( v3401(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorShiftedRanges_132,axiom,
    ! [VarCurr] :
      ( v3508(VarCurr)
    <=> ( v3510(VarCurr)
        & v3474(VarCurr,bitIndex29) ) ) ).

fof(writeBinaryOperatorShiftedRanges_131,axiom,
    ! [VarCurr] :
      ( v3510(VarCurr)
    <=> ( v3511(VarCurr)
        & v3474(VarCurr,bitIndex28) ) ) ).

fof(writeBinaryOperatorShiftedRanges_130,axiom,
    ! [VarCurr] :
      ( v3511(VarCurr)
    <=> ( v3512(VarCurr)
        & v3474(VarCurr,bitIndex27) ) ) ).

fof(writeBinaryOperatorShiftedRanges_129,axiom,
    ! [VarCurr] :
      ( v3512(VarCurr)
    <=> ( v3513(VarCurr)
        & v3474(VarCurr,bitIndex26) ) ) ).

fof(writeBinaryOperatorShiftedRanges_128,axiom,
    ! [VarCurr] :
      ( v3513(VarCurr)
    <=> ( v3474(VarCurr,bitIndex24)
        & v3474(VarCurr,bitIndex25) ) ) ).

fof(addBitVectorEqualityBitBlasted_212,axiom,
    ! [VarCurr] :
      ( v3507(VarCurr)
    <=> ( ( v3401(VarCurr,bitIndex3)
        <=> $false )
        & ( v3401(VarCurr,bitIndex2)
        <=> $false )
        & ( v3401(VarCurr,bitIndex1)
        <=> $true )
        & ( v3401(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorShiftedRanges_127,axiom,
    ! [VarCurr] :
      ( v3500(VarCurr)
    <=> ( v3502(VarCurr)
        & v3474(VarCurr,bitIndex29) ) ) ).

fof(writeBinaryOperatorShiftedRanges_126,axiom,
    ! [VarCurr] :
      ( v3502(VarCurr)
    <=> ( v3503(VarCurr)
        & v3474(VarCurr,bitIndex28) ) ) ).

fof(writeBinaryOperatorShiftedRanges_125,axiom,
    ! [VarCurr] :
      ( v3503(VarCurr)
    <=> ( v3504(VarCurr)
        & v3474(VarCurr,bitIndex27) ) ) ).

fof(writeBinaryOperatorShiftedRanges_124,axiom,
    ! [VarCurr] :
      ( v3504(VarCurr)
    <=> ( v3505(VarCurr)
        & v3474(VarCurr,bitIndex26) ) ) ).

fof(writeBinaryOperatorShiftedRanges_123,axiom,
    ! [VarCurr] :
      ( v3505(VarCurr)
    <=> ( v3506(VarCurr)
        & v3474(VarCurr,bitIndex25) ) ) ).

fof(writeBinaryOperatorShiftedRanges_122,axiom,
    ! [VarCurr] :
      ( v3506(VarCurr)
    <=> ( v3474(VarCurr,bitIndex23)
        & v3474(VarCurr,bitIndex24) ) ) ).

fof(addBitVectorEqualityBitBlasted_211,axiom,
    ! [VarCurr] :
      ( v3499(VarCurr)
    <=> ( ( v3401(VarCurr,bitIndex3)
        <=> $false )
        & ( v3401(VarCurr,bitIndex2)
        <=> $false )
        & ( v3401(VarCurr,bitIndex1)
        <=> $true )
        & ( v3401(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorShiftedRanges_121,axiom,
    ! [VarCurr] :
      ( v3491(VarCurr)
    <=> ( v3493(VarCurr)
        & v3474(VarCurr,bitIndex29) ) ) ).

fof(writeBinaryOperatorShiftedRanges_120,axiom,
    ! [VarCurr] :
      ( v3493(VarCurr)
    <=> ( v3494(VarCurr)
        & v3474(VarCurr,bitIndex28) ) ) ).

fof(writeBinaryOperatorShiftedRanges_119,axiom,
    ! [VarCurr] :
      ( v3494(VarCurr)
    <=> ( v3495(VarCurr)
        & v3474(VarCurr,bitIndex27) ) ) ).

fof(writeBinaryOperatorShiftedRanges_118,axiom,
    ! [VarCurr] :
      ( v3495(VarCurr)
    <=> ( v3496(VarCurr)
        & v3474(VarCurr,bitIndex26) ) ) ).

fof(writeBinaryOperatorShiftedRanges_117,axiom,
    ! [VarCurr] :
      ( v3496(VarCurr)
    <=> ( v3497(VarCurr)
        & v3474(VarCurr,bitIndex25) ) ) ).

fof(writeBinaryOperatorShiftedRanges_116,axiom,
    ! [VarCurr] :
      ( v3497(VarCurr)
    <=> ( v3498(VarCurr)
        & v3474(VarCurr,bitIndex24) ) ) ).

fof(writeBinaryOperatorShiftedRanges_115,axiom,
    ! [VarCurr] :
      ( v3498(VarCurr)
    <=> ( v3474(VarCurr,bitIndex22)
        & v3474(VarCurr,bitIndex23) ) ) ).

fof(addBitVectorEqualityBitBlasted_210,axiom,
    ! [VarCurr] :
      ( v3490(VarCurr)
    <=> ( ( v3401(VarCurr,bitIndex3)
        <=> $false )
        & ( v3401(VarCurr,bitIndex2)
        <=> $false )
        & ( v3401(VarCurr,bitIndex1)
        <=> $false )
        & ( v3401(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorShiftedRanges_114,axiom,
    ! [VarCurr] :
      ( v3479(VarCurr)
    <=> ( v3481(VarCurr)
        & v3474(VarCurr,bitIndex29) ) ) ).

fof(writeBinaryOperatorShiftedRanges_113,axiom,
    ! [VarCurr] :
      ( v3481(VarCurr)
    <=> ( v3482(VarCurr)
        & v3474(VarCurr,bitIndex28) ) ) ).

fof(writeBinaryOperatorShiftedRanges_112,axiom,
    ! [VarCurr] :
      ( v3482(VarCurr)
    <=> ( v3483(VarCurr)
        & v3474(VarCurr,bitIndex27) ) ) ).

fof(writeBinaryOperatorShiftedRanges_111,axiom,
    ! [VarCurr] :
      ( v3483(VarCurr)
    <=> ( v3484(VarCurr)
        & v3474(VarCurr,bitIndex26) ) ) ).

fof(writeBinaryOperatorShiftedRanges_110,axiom,
    ! [VarCurr] :
      ( v3484(VarCurr)
    <=> ( v3485(VarCurr)
        & v3474(VarCurr,bitIndex25) ) ) ).

fof(writeBinaryOperatorShiftedRanges_109,axiom,
    ! [VarCurr] :
      ( v3485(VarCurr)
    <=> ( v3486(VarCurr)
        & v3474(VarCurr,bitIndex24) ) ) ).

fof(writeBinaryOperatorShiftedRanges_108,axiom,
    ! [VarCurr] :
      ( v3486(VarCurr)
    <=> ( v3487(VarCurr)
        & v3474(VarCurr,bitIndex23) ) ) ).

fof(writeBinaryOperatorShiftedRanges_107,axiom,
    ! [VarCurr] :
      ( v3487(VarCurr)
    <=> ( v3474(VarCurr,bitIndex21)
        & v3474(VarCurr,bitIndex22) ) ) ).

fof(addAssignmentInitValue_220,axiom,
    ~ v3474(constB0,bitIndex37) ).

fof(addAssignmentInitValue_219,axiom,
    ~ v3474(constB0,bitIndex36) ).

fof(addAssignmentInitValue_218,axiom,
    ~ v3474(constB0,bitIndex35) ).

fof(addAssignmentInitValue_217,axiom,
    ~ v3474(constB0,bitIndex34) ).

fof(addAssignmentInitValue_216,axiom,
    ~ v3474(constB0,bitIndex33) ).

fof(addAssignmentInitValue_215,axiom,
    ~ v3474(constB0,bitIndex32) ).

fof(addAssignmentInitValue_214,axiom,
    ~ v3474(constB0,bitIndex31) ).

fof(addAssignmentInitValue_213,axiom,
    ~ v3474(constB0,bitIndex30) ).

fof(addAssignmentInitValue_212,axiom,
    ~ v3474(constB0,bitIndex29) ).

fof(addAssignmentInitValue_211,axiom,
    ~ v3474(constB0,bitIndex28) ).

fof(addAssignmentInitValue_210,axiom,
    ~ v3474(constB0,bitIndex27) ).

fof(addAssignmentInitValue_209,axiom,
    ~ v3474(constB0,bitIndex26) ).

fof(addAssignmentInitValue_208,axiom,
    ~ v3474(constB0,bitIndex25) ).

fof(addAssignmentInitValue_207,axiom,
    ~ v3474(constB0,bitIndex24) ).

fof(addAssignmentInitValue_206,axiom,
    ~ v3474(constB0,bitIndex23) ).

fof(addAssignmentInitValue_205,axiom,
    ~ v3474(constB0,bitIndex22) ).

fof(addAssignmentInitValue_204,axiom,
    ~ v3474(constB0,bitIndex21) ).

fof(addAssignmentInitValue_203,axiom,
    ~ v3474(constB0,bitIndex20) ).

fof(addAssignmentInitValue_202,axiom,
    ~ v3474(constB0,bitIndex19) ).

fof(addAssignmentInitValue_201,axiom,
    ~ v3474(constB0,bitIndex18) ).

fof(addAssignmentInitValue_200,axiom,
    ~ v3474(constB0,bitIndex17) ).

fof(addAssignmentInitValue_199,axiom,
    ~ v3474(constB0,bitIndex16) ).

fof(addAssignmentInitValue_198,axiom,
    ~ v3474(constB0,bitIndex15) ).

fof(addAssignmentInitValue_197,axiom,
    ~ v3474(constB0,bitIndex14) ).

fof(bitBlastConstant_781,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxx000000000000000000000000xxxxxxxxxxxxxx(bitIndex37) ).

fof(bitBlastConstant_780,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxx000000000000000000000000xxxxxxxxxxxxxx(bitIndex36) ).

fof(bitBlastConstant_779,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxx000000000000000000000000xxxxxxxxxxxxxx(bitIndex35) ).

fof(bitBlastConstant_778,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxx000000000000000000000000xxxxxxxxxxxxxx(bitIndex34) ).

fof(bitBlastConstant_777,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxx000000000000000000000000xxxxxxxxxxxxxx(bitIndex33) ).

fof(bitBlastConstant_776,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxx000000000000000000000000xxxxxxxxxxxxxx(bitIndex32) ).

fof(bitBlastConstant_775,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxx000000000000000000000000xxxxxxxxxxxxxx(bitIndex31) ).

fof(bitBlastConstant_774,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxx000000000000000000000000xxxxxxxxxxxxxx(bitIndex30) ).

fof(bitBlastConstant_773,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxx000000000000000000000000xxxxxxxxxxxxxx(bitIndex29) ).

fof(bitBlastConstant_772,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxx000000000000000000000000xxxxxxxxxxxxxx(bitIndex28) ).

fof(bitBlastConstant_771,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxx000000000000000000000000xxxxxxxxxxxxxx(bitIndex27) ).

fof(bitBlastConstant_770,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxx000000000000000000000000xxxxxxxxxxxxxx(bitIndex26) ).

fof(bitBlastConstant_769,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxx000000000000000000000000xxxxxxxxxxxxxx(bitIndex25) ).

fof(bitBlastConstant_768,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxx000000000000000000000000xxxxxxxxxxxxxx(bitIndex24) ).

fof(bitBlastConstant_767,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxx000000000000000000000000xxxxxxxxxxxxxx(bitIndex23) ).

fof(bitBlastConstant_766,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxx000000000000000000000000xxxxxxxxxxxxxx(bitIndex22) ).

fof(bitBlastConstant_765,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxx000000000000000000000000xxxxxxxxxxxxxx(bitIndex21) ).

fof(bitBlastConstant_764,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxx000000000000000000000000xxxxxxxxxxxxxx(bitIndex20) ).

fof(bitBlastConstant_763,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxx000000000000000000000000xxxxxxxxxxxxxx(bitIndex19) ).

fof(bitBlastConstant_762,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxx000000000000000000000000xxxxxxxxxxxxxx(bitIndex18) ).

fof(bitBlastConstant_761,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxx000000000000000000000000xxxxxxxxxxxxxx(bitIndex17) ).

fof(bitBlastConstant_760,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxx000000000000000000000000xxxxxxxxxxxxxx(bitIndex16) ).

fof(bitBlastConstant_759,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxx000000000000000000000000xxxxxxxxxxxxxx(bitIndex15) ).

fof(bitBlastConstant_758,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxx000000000000000000000000xxxxxxxxxxxxxx(bitIndex14) ).

fof(addBitVectorEqualityBitBlasted_209,axiom,
    ! [VarCurr] :
      ( v3478(VarCurr)
    <=> ( ( v3401(VarCurr,bitIndex3)
        <=> $false )
        & ( v3401(VarCurr,bitIndex2)
        <=> $false )
        & ( v3401(VarCurr,bitIndex1)
        <=> $false )
        & ( v3401(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_88,axiom,
    ! [VarCurr] :
      ( ~ v3403(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v3401(VarCurr,B)
          <=> v3427(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_120,axiom,
    ! [VarCurr] :
      ( v3403(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v3401(VarCurr,B)
          <=> v3453(VarCurr,B) ) ) ) ).

fof(addAssignment_1120,axiom,
    ! [VarCurr] :
      ( v3453(VarCurr,bitIndex0)
    <=> v3471(VarCurr) ) ).

fof(addAssignment_1119,axiom,
    ! [VarCurr] :
      ( v3453(VarCurr,bitIndex1)
    <=> v3469(VarCurr) ) ).

fof(addAssignment_1118,axiom,
    ! [VarCurr] :
      ( v3453(VarCurr,bitIndex2)
    <=> v3464(VarCurr) ) ).

fof(addAssignment_1117,axiom,
    ! [VarCurr] :
      ( v3453(VarCurr,bitIndex3)
    <=> v3455(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_407,axiom,
    ! [VarCurr] :
      ( v3469(VarCurr)
    <=> ( v3470(VarCurr)
        & v3472(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_406,axiom,
    ! [VarCurr] :
      ( v3472(VarCurr)
    <=> ( v3427(VarCurr,bitIndex0)
        | v3461(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_106,axiom,
    ! [VarCurr] :
      ( v3470(VarCurr)
    <=> ( v3471(VarCurr)
        | v3427(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_198,axiom,
    ! [VarCurr] :
      ( ~ v3471(VarCurr)
    <=> v3427(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_405,axiom,
    ! [VarCurr] :
      ( v3464(VarCurr)
    <=> ( v3465(VarCurr)
        & v3468(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_105,axiom,
    ! [VarCurr] :
      ( v3468(VarCurr)
    <=> ( v3459(VarCurr)
        | v3427(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_404,axiom,
    ! [VarCurr] :
      ( v3465(VarCurr)
    <=> ( v3466(VarCurr)
        | v3467(VarCurr) ) ) ).

fof(writeUnaryOperator_197,axiom,
    ! [VarCurr] :
      ( ~ v3467(VarCurr)
    <=> v3427(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_196,axiom,
    ! [VarCurr] :
      ( ~ v3466(VarCurr)
    <=> v3459(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_403,axiom,
    ! [VarCurr] :
      ( v3455(VarCurr)
    <=> ( v3456(VarCurr)
        & v3463(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_104,axiom,
    ! [VarCurr] :
      ( v3463(VarCurr)
    <=> ( v3458(VarCurr)
        | v3427(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_402,axiom,
    ! [VarCurr] :
      ( v3456(VarCurr)
    <=> ( v3457(VarCurr)
        | v3462(VarCurr) ) ) ).

fof(writeUnaryOperator_195,axiom,
    ! [VarCurr] :
      ( ~ v3462(VarCurr)
    <=> v3427(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_194,axiom,
    ! [VarCurr] :
      ( ~ v3457(VarCurr)
    <=> v3458(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_103,axiom,
    ! [VarCurr] :
      ( v3458(VarCurr)
    <=> ( v3459(VarCurr)
        & v3427(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_102,axiom,
    ! [VarCurr] :
      ( v3459(VarCurr)
    <=> ( v3427(VarCurr,bitIndex1)
        | v3460(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_401,axiom,
    ! [VarCurr] :
      ( v3460(VarCurr)
    <=> ( v3427(VarCurr,bitIndex0)
        & v3461(VarCurr) ) ) ).

fof(writeUnaryOperator_193,axiom,
    ! [VarCurr] :
      ( ~ v3461(VarCurr)
    <=> v3427(VarCurr,bitIndex1) ) ).

fof(addAssignment_1116,axiom,
    ! [VarCurr] :
      ( v3427(VarCurr,bitIndex3)
    <=> v3429(VarCurr,bitIndex3) ) ).

fof(addAssignment_1115,axiom,
    ! [VarCurr] :
      ( v3429(VarCurr,bitIndex3)
    <=> v3431(VarCurr,bitIndex3) ) ).

fof(addAssignment_1114,axiom,
    ! [VarCurr] :
      ( v3431(VarCurr,bitIndex3)
    <=> v3433(VarCurr,bitIndex3) ) ).

fof(addAssignment_1113,axiom,
    ! [VarCurr] :
      ( v3433(VarCurr,bitIndex3)
    <=> v3435(VarCurr,bitIndex3) ) ).

fof(addAssignment_1112,axiom,
    ! [VarCurr] :
      ( v3435(VarCurr,bitIndex3)
    <=> v3437(VarCurr,bitIndex3) ) ).

fof(addAssignment_1111,axiom,
    ! [VarCurr] :
      ( v3437(VarCurr,bitIndex3)
    <=> v3439(VarCurr,bitIndex3) ) ).

fof(addAssignment_1110,axiom,
    ! [VarCurr] :
      ( v3439(VarCurr,bitIndex3)
    <=> v3441(VarCurr,bitIndex3) ) ).

fof(addAssignment_1109,axiom,
    ! [VarCurr] :
      ( v3441(VarCurr,bitIndex3)
    <=> v3443(VarCurr,bitIndex3) ) ).

fof(addAssignment_1108,axiom,
    ! [VarCurr] :
      ( v3443(VarCurr,bitIndex3)
    <=> v3421(VarCurr,bitIndex3) ) ).

fof(addAssignment_1107,axiom,
    ! [VarCurr] :
      ( v3421(VarCurr,bitIndex3)
    <=> v3423(VarCurr,bitIndex3) ) ).

fof(addAssignment_1106,axiom,
    ! [VarCurr] :
      ( v3423(VarCurr,bitIndex3)
    <=> v3451(VarCurr) ) ).

fof(addAssignment_1105,axiom,
    ! [VarCurr] :
      ( v3427(VarCurr,bitIndex2)
    <=> v3429(VarCurr,bitIndex2) ) ).

fof(addAssignment_1104,axiom,
    ! [VarCurr] :
      ( v3429(VarCurr,bitIndex2)
    <=> v3431(VarCurr,bitIndex2) ) ).

fof(addAssignment_1103,axiom,
    ! [VarCurr] :
      ( v3431(VarCurr,bitIndex2)
    <=> v3433(VarCurr,bitIndex2) ) ).

fof(addAssignment_1102,axiom,
    ! [VarCurr] :
      ( v3433(VarCurr,bitIndex2)
    <=> v3435(VarCurr,bitIndex2) ) ).

fof(addAssignment_1101,axiom,
    ! [VarCurr] :
      ( v3435(VarCurr,bitIndex2)
    <=> v3437(VarCurr,bitIndex2) ) ).

fof(addAssignment_1100,axiom,
    ! [VarCurr] :
      ( v3437(VarCurr,bitIndex2)
    <=> v3439(VarCurr,bitIndex2) ) ).

fof(addAssignment_1099,axiom,
    ! [VarCurr] :
      ( v3439(VarCurr,bitIndex2)
    <=> v3441(VarCurr,bitIndex2) ) ).

fof(addAssignment_1098,axiom,
    ! [VarCurr] :
      ( v3441(VarCurr,bitIndex2)
    <=> v3443(VarCurr,bitIndex2) ) ).

fof(addAssignment_1097,axiom,
    ! [VarCurr] :
      ( v3443(VarCurr,bitIndex2)
    <=> v3421(VarCurr,bitIndex2) ) ).

fof(addAssignment_1096,axiom,
    ! [VarCurr] :
      ( v3421(VarCurr,bitIndex2)
    <=> v3423(VarCurr,bitIndex2) ) ).

fof(addAssignment_1095,axiom,
    ! [VarCurr] :
      ( v3423(VarCurr,bitIndex2)
    <=> v3449(VarCurr) ) ).

fof(addAssignment_1094,axiom,
    ! [VarCurr] :
      ( v3427(VarCurr,bitIndex1)
    <=> v3429(VarCurr,bitIndex1) ) ).

fof(addAssignment_1093,axiom,
    ! [VarCurr] :
      ( v3429(VarCurr,bitIndex1)
    <=> v3431(VarCurr,bitIndex1) ) ).

fof(addAssignment_1092,axiom,
    ! [VarCurr] :
      ( v3431(VarCurr,bitIndex1)
    <=> v3433(VarCurr,bitIndex1) ) ).

fof(addAssignment_1091,axiom,
    ! [VarCurr] :
      ( v3433(VarCurr,bitIndex1)
    <=> v3435(VarCurr,bitIndex1) ) ).

fof(addAssignment_1090,axiom,
    ! [VarCurr] :
      ( v3435(VarCurr,bitIndex1)
    <=> v3437(VarCurr,bitIndex1) ) ).

fof(addAssignment_1089,axiom,
    ! [VarCurr] :
      ( v3437(VarCurr,bitIndex1)
    <=> v3439(VarCurr,bitIndex1) ) ).

fof(addAssignment_1088,axiom,
    ! [VarCurr] :
      ( v3439(VarCurr,bitIndex1)
    <=> v3441(VarCurr,bitIndex1) ) ).

fof(addAssignment_1087,axiom,
    ! [VarCurr] :
      ( v3441(VarCurr,bitIndex1)
    <=> v3443(VarCurr,bitIndex1) ) ).

fof(addAssignment_1086,axiom,
    ! [VarCurr] :
      ( v3443(VarCurr,bitIndex1)
    <=> v3421(VarCurr,bitIndex1) ) ).

fof(addAssignment_1085,axiom,
    ! [VarCurr] :
      ( v3421(VarCurr,bitIndex1)
    <=> v3423(VarCurr,bitIndex1) ) ).

fof(addAssignment_1084,axiom,
    ! [VarCurr] :
      ( v3423(VarCurr,bitIndex1)
    <=> v3447(VarCurr) ) ).

fof(addAssignment_1083,axiom,
    ! [VarCurr] :
      ( v3427(VarCurr,bitIndex0)
    <=> v3429(VarCurr,bitIndex0) ) ).

fof(addAssignment_1082,axiom,
    ! [VarCurr] :
      ( v3429(VarCurr,bitIndex0)
    <=> v3431(VarCurr,bitIndex0) ) ).

fof(addAssignment_1081,axiom,
    ! [VarCurr] :
      ( v3431(VarCurr,bitIndex0)
    <=> v3433(VarCurr,bitIndex0) ) ).

fof(addAssignment_1080,axiom,
    ! [VarCurr] :
      ( v3433(VarCurr,bitIndex0)
    <=> v3435(VarCurr,bitIndex0) ) ).

fof(addAssignment_1079,axiom,
    ! [VarCurr] :
      ( v3435(VarCurr,bitIndex0)
    <=> v3437(VarCurr,bitIndex0) ) ).

fof(addAssignment_1078,axiom,
    ! [VarCurr] :
      ( v3437(VarCurr,bitIndex0)
    <=> v3439(VarCurr,bitIndex0) ) ).

fof(addAssignment_1077,axiom,
    ! [VarCurr] :
      ( v3439(VarCurr,bitIndex0)
    <=> v3441(VarCurr,bitIndex0) ) ).

fof(addAssignment_1076,axiom,
    ! [VarCurr] :
      ( v3441(VarCurr,bitIndex0)
    <=> v3443(VarCurr,bitIndex0) ) ).

fof(addAssignment_1075,axiom,
    ! [VarCurr] :
      ( v3443(VarCurr,bitIndex0)
    <=> v3421(VarCurr,bitIndex0) ) ).

fof(addAssignment_1074,axiom,
    ! [VarCurr] :
      ( v3421(VarCurr,bitIndex0)
    <=> v3423(VarCurr,bitIndex0) ) ).

fof(addAssignment_1073,axiom,
    ! [VarCurr] :
      ( v3423(VarCurr,bitIndex0)
    <=> v3445(VarCurr) ) ).

fof(addAssignment_1072,axiom,
    ! [VarCurr] :
      ( v3403(VarCurr)
    <=> v3405(VarCurr) ) ).

fof(addAssignment_1071,axiom,
    ! [VarCurr] :
      ( v3405(VarCurr)
    <=> v3407(VarCurr) ) ).

fof(addAssignment_1070,axiom,
    ! [VarCurr] :
      ( v3407(VarCurr)
    <=> v3409(VarCurr) ) ).

fof(addAssignment_1069,axiom,
    ! [VarCurr] :
      ( v3409(VarCurr)
    <=> v3411(VarCurr) ) ).

fof(addAssignment_1068,axiom,
    ! [VarCurr] :
      ( v3411(VarCurr)
    <=> v3413(VarCurr) ) ).

fof(addAssignment_1067,axiom,
    ! [VarCurr] :
      ( v3413(VarCurr)
    <=> v3415(VarCurr) ) ).

fof(addAssignment_1066,axiom,
    ! [VarCurr] :
      ( v3415(VarCurr)
    <=> v3417(VarCurr) ) ).

fof(addAssignment_1065,axiom,
    ! [VarCurr] :
      ( v3417(VarCurr)
    <=> v3419(VarCurr) ) ).

fof(addAssignment_1064,axiom,
    ! [VarCurr] :
      ( v3419(VarCurr)
    <=> v3421(VarCurr,bitIndex8) ) ).

fof(addAssignment_1063,axiom,
    ! [VarCurr] :
      ( v3421(VarCurr,bitIndex8)
    <=> v3423(VarCurr,bitIndex8) ) ).

fof(addAssignment_1062,axiom,
    ! [VarCurr] :
      ( v3423(VarCurr,bitIndex8)
    <=> v3425(VarCurr) ) ).

fof(addAssignment_1061,axiom,
    ! [VarCurr,B] :
      ( range_1_0(B)
     => ( v3363(VarCurr,B)
      <=> v3365(VarCurr,B) ) ) ).

fof(addAssignment_1060,axiom,
    ! [VarCurr,B] :
      ( range_1_0(B)
     => ( v3365(VarCurr,B)
      <=> v3367(VarCurr,B) ) ) ).

fof(addAssignment_1059,axiom,
    ! [VarCurr,B] :
      ( range_1_0(B)
     => ( v3367(VarCurr,B)
      <=> v3369(VarCurr,B) ) ) ).

fof(addAssignment_1058,axiom,
    ! [VarCurr,B] :
      ( range_1_0(B)
     => ( v3369(VarCurr,B)
      <=> v3371(VarCurr,B) ) ) ).

fof(addAssignment_1057,axiom,
    ! [VarCurr,B] :
      ( range_1_0(B)
     => ( v3371(VarCurr,B)
      <=> v3373(VarCurr,B) ) ) ).

fof(addAssignment_1056,axiom,
    ! [VarCurr,B] :
      ( range_1_0(B)
     => ( v3373(VarCurr,B)
      <=> v3375(VarCurr,B) ) ) ).

fof(addAssignment_1055,axiom,
    ! [VarCurr,B] :
      ( range_1_0(B)
     => ( v3375(VarCurr,B)
      <=> v3377(VarCurr,B) ) ) ).

fof(addAssignment_1054,axiom,
    ! [VarCurr,B] :
      ( range_1_0(B)
     => ( v3377(VarCurr,B)
      <=> v3379(VarCurr,B) ) ) ).

fof(addAssignment_1053,axiom,
    ! [VarCurr,B] :
      ( range_1_0(B)
     => ( v3379(VarCurr,B)
      <=> v3381(VarCurr,B) ) ) ).

fof(addAssignment_1052,axiom,
    ! [VarCurr] :
      ( ( v3381(VarCurr,bitIndex1)
      <=> v193(VarCurr,bitIndex9) )
      & ( v3381(VarCurr,bitIndex0)
      <=> v193(VarCurr,bitIndex8) ) ) ).

fof(addAssignment_1051,axiom,
    ! [VarCurr,B] :
      ( range_9_8(B)
     => ( v193(VarCurr,B)
      <=> v195(VarCurr,B) ) ) ).

fof(range_axiom_25,axiom,
    ! [B] :
      ( range_9_8(B)
    <=> ( $false
        | bitIndex8 = B
        | bitIndex9 = B ) ) ).

fof(addAssignment_1050,axiom,
    ! [VarCurr] :
      ( v195(VarCurr,bitIndex9)
    <=> v3385(VarCurr) ) ).

fof(addAssignment_1049,axiom,
    ! [VarCurr] :
      ( v195(VarCurr,bitIndex8)
    <=> v3383(VarCurr) ) ).

fof(addAssignment_1048,axiom,
    ! [VarCurr] :
      ( v2597(VarCurr)
    <=> v2599(VarCurr) ) ).

fof(addAssignment_1047,axiom,
    ! [VarCurr] :
      ( v2599(VarCurr)
    <=> v2601(VarCurr) ) ).

fof(addAssignment_1046,axiom,
    ! [VarCurr] :
      ( v2601(VarCurr)
    <=> v2603(VarCurr) ) ).

fof(addAssignment_1045,axiom,
    ! [VarCurr] :
      ( v2603(VarCurr)
    <=> v2605(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_87,axiom,
    ! [VarCurr] :
      ( ~ v3346(VarCurr)
     => ( v2605(VarCurr)
      <=> v3347(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_119,axiom,
    ! [VarCurr] :
      ( v3346(VarCurr)
     => ( v2605(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges5,axiom,
    ! [VarCurr] :
      ( ( ~ v3348(VarCurr)
        & ~ v3349(VarCurr)
        & ~ v3352(VarCurr)
        & ~ v3353(VarCurr)
        & ~ v3354(VarCurr) )
     => ( v3347(VarCurr)
      <=> v3239(VarCurr,bitIndex1) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges4,axiom,
    ! [VarCurr] :
      ( v3354(VarCurr)
     => ( v3347(VarCurr)
      <=> v3239(VarCurr,bitIndex2) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges3,axiom,
    ! [VarCurr] :
      ( v3353(VarCurr)
     => ( v3347(VarCurr)
      <=> v3239(VarCurr,bitIndex3) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges2,axiom,
    ! [VarCurr] :
      ( v3352(VarCurr)
     => ( v3347(VarCurr)
      <=> v3239(VarCurr,bitIndex2) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges1_1,axiom,
    ! [VarCurr] :
      ( v3349(VarCurr)
     => ( v3347(VarCurr)
      <=> v3239(VarCurr,bitIndex3) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_38,axiom,
    ! [VarCurr] :
      ( v3348(VarCurr)
     => ( v3347(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_208,axiom,
    ! [VarCurr] :
      ( v3357(VarCurr)
    <=> ( ( v2758(VarCurr,bitIndex2)
        <=> $true )
        & ( v2758(VarCurr,bitIndex1)
        <=> $true )
        & ( v2758(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_400,axiom,
    ! [VarCurr] :
      ( v3354(VarCurr)
    <=> ( v3355(VarCurr)
        | v3356(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_207,axiom,
    ! [VarCurr] :
      ( v3356(VarCurr)
    <=> ( ( v2758(VarCurr,bitIndex2)
        <=> $true )
        & ( v2758(VarCurr,bitIndex1)
        <=> $true )
        & ( v2758(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_757,axiom,
    b110(bitIndex2) ).

fof(bitBlastConstant_756,axiom,
    b110(bitIndex1) ).

fof(bitBlastConstant_755,axiom,
    ~ b110(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_206,axiom,
    ! [VarCurr] :
      ( v3355(VarCurr)
    <=> ( ( v2758(VarCurr,bitIndex2)
        <=> $true )
        & ( v2758(VarCurr,bitIndex1)
        <=> $false )
        & ( v2758(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_754,axiom,
    b101(bitIndex2) ).

fof(bitBlastConstant_753,axiom,
    ~ b101(bitIndex1) ).

fof(bitBlastConstant_752,axiom,
    b101(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_205,axiom,
    ! [VarCurr] :
      ( v3353(VarCurr)
    <=> ( ( v2758(VarCurr,bitIndex2)
        <=> $true )
        & ( v2758(VarCurr,bitIndex1)
        <=> $false )
        & ( v2758(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_204,axiom,
    ! [VarCurr] :
      ( v3352(VarCurr)
    <=> ( ( v2758(VarCurr,bitIndex2)
        <=> $false )
        & ( v2758(VarCurr,bitIndex1)
        <=> $true )
        & ( v2758(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_399,axiom,
    ! [VarCurr] :
      ( v3349(VarCurr)
    <=> ( v3350(VarCurr)
        | v3351(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_203,axiom,
    ! [VarCurr] :
      ( v3351(VarCurr)
    <=> ( ( v2758(VarCurr,bitIndex2)
        <=> $false )
        & ( v2758(VarCurr,bitIndex1)
        <=> $true )
        & ( v2758(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_202,axiom,
    ! [VarCurr] :
      ( v3350(VarCurr)
    <=> ( ( v2758(VarCurr,bitIndex2)
        <=> $false )
        & ( v2758(VarCurr,bitIndex1)
        <=> $false )
        & ( v2758(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_201,axiom,
    ! [VarCurr] :
      ( v3348(VarCurr)
    <=> ( ( v2758(VarCurr,bitIndex2)
        <=> $false )
        & ( v2758(VarCurr,bitIndex1)
        <=> $false )
        & ( v2758(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeUnaryOperator_192,axiom,
    ! [VarCurr] :
      ( ~ v3346(VarCurr)
    <=> v2607(VarCurr) ) ).

fof(addAssignment_1044,axiom,
    ! [VarCurr] :
      ( v3239(VarCurr,bitIndex2)
    <=> v3241(VarCurr,bitIndex2) ) ).

fof(addAssignment_1043,axiom,
    ! [VarCurr] :
      ( v3241(VarCurr,bitIndex2)
    <=> v3243(VarCurr,bitIndex2) ) ).

fof(addAssignment_1042,axiom,
    ! [VarCurr] :
      ( v3239(VarCurr,bitIndex3)
    <=> v3241(VarCurr,bitIndex3) ) ).

fof(addAssignment_1041,axiom,
    ! [VarCurr] :
      ( v3241(VarCurr,bitIndex3)
    <=> v3243(VarCurr,bitIndex3) ) ).

fof(addAssignment_1040,axiom,
    ! [VarNext] :
      ( v3243(VarNext,bitIndex3)
    <=> v3336(VarNext,bitIndex3) ) ).

fof(addCaseBooleanConditionEqualRanges1_42,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3337(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v3336(VarNext,B)
            <=> v3243(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_43,axiom,
    ! [VarNext] :
      ( v3337(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v3336(VarNext,B)
          <=> v3293(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_398,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3337(VarNext)
      <=> v3338(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_397,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3338(VarNext)
      <=> ( v3340(VarNext)
          & v3280(VarNext) ) ) ) ).

fof(writeUnaryOperator_191,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3340(VarNext)
      <=> v3287(VarNext) ) ) ).

fof(addAssignment_1039,axiom,
    ! [VarCurr] :
      ( v3247(VarCurr,bitIndex3)
    <=> v3268(VarCurr,bitIndex3) ) ).

fof(addAssignment_1038,axiom,
    ! [VarCurr] :
      ( v3257(VarCurr)
    <=> v3259(VarCurr) ) ).

fof(addAssignment_1037,axiom,
    ! [VarCurr] :
      ( v3259(VarCurr)
    <=> v3261(VarCurr) ) ).

fof(addAssignment_1036,axiom,
    ! [VarCurr] :
      ( v3261(VarCurr)
    <=> v3263(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_41,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3321(VarNext)
       => ( v3263(VarNext)
        <=> v3263(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_42,axiom,
    ! [VarNext] :
      ( v3321(VarNext)
     => ( v3263(VarNext)
      <=> v3331(VarNext) ) ) ).

fof(addAssignment_1035,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3331(VarNext)
      <=> v3329(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_86,axiom,
    ! [VarCurr] :
      ( ~ v3332(VarCurr)
     => ( v3329(VarCurr)
      <=> v3267(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_118,axiom,
    ! [VarCurr] :
      ( v3332(VarCurr)
     => ( v3329(VarCurr)
      <=> $false ) ) ).

fof(writeUnaryOperator_190,axiom,
    ! [VarCurr] :
      ( ~ v3332(VarCurr)
    <=> v3265(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_396,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3321(VarNext)
      <=> v3322(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_395,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3322(VarNext)
      <=> ( v3323(VarNext)
          & v3318(VarNext) ) ) ) ).

fof(writeUnaryOperator_189,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3323(VarNext)
      <=> v3325(VarNext) ) ) ).

fof(addAssignment_1034,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3325(VarNext)
      <=> v3318(VarCurr) ) ) ).

fof(addAssignment_1033,axiom,
    ! [VarCurr] :
      ( v3318(VarCurr)
    <=> v2549(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_21,axiom,
    ! [VarCurr] :
      ( ( ~ v3306(VarCurr)
        & ~ v3310(VarCurr) )
     => ( v3267(VarCurr)
      <=> v3316(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_39,axiom,
    ! [VarCurr] :
      ( v3310(VarCurr)
     => ( v3267(VarCurr)
      <=> v3311(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_37,axiom,
    ! [VarCurr] :
      ( v3306(VarCurr)
     => ( v3267(VarCurr)
      <=> v3308(VarCurr) ) ) ).

fof(writeUnaryOperator_188,axiom,
    ! [VarCurr] :
      ( ~ v3316(VarCurr)
    <=> v2607(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_394,axiom,
    ! [VarCurr] :
      ( v3313(VarCurr)
    <=> ( v3314(VarCurr)
        | v3315(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_200,axiom,
    ! [VarCurr] :
      ( v3315(VarCurr)
    <=> ( ( v3307(VarCurr,bitIndex1)
        <=> $true )
        & ( v3307(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_199,axiom,
    ! [VarCurr] :
      ( v3314(VarCurr)
    <=> ( ( v3307(VarCurr,bitIndex1)
        <=> $true )
        & ( v3307(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorShiftedRanges_101,axiom,
    ! [VarCurr] :
      ( v3311(VarCurr)
    <=> ( v3239(VarCurr,bitIndex1)
        & v3312(VarCurr) ) ) ).

fof(writeUnaryOperator_187,axiom,
    ! [VarCurr] :
      ( ~ v3312(VarCurr)
    <=> v2607(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_198,axiom,
    ! [VarCurr] :
      ( v3310(VarCurr)
    <=> ( ( v3307(VarCurr,bitIndex1)
        <=> $false )
        & ( v3307(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_393,axiom,
    ! [VarCurr] :
      ( v3308(VarCurr)
    <=> ( v3239(VarCurr,bitIndex0)
        & v3309(VarCurr) ) ) ).

fof(writeUnaryOperator_186,axiom,
    ! [VarCurr] :
      ( ~ v3309(VarCurr)
    <=> v2607(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_197,axiom,
    ! [VarCurr] :
      ( v3306(VarCurr)
    <=> ( ( v3307(VarCurr,bitIndex1)
        <=> $false )
        & ( v3307(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1032,axiom,
    ! [VarCurr] :
      ( v3307(VarCurr,bitIndex0)
    <=> v3263(VarCurr) ) ).

fof(addAssignment_1031,axiom,
    ! [VarCurr] :
      ( v3307(VarCurr,bitIndex1)
    <=> v3255(VarCurr) ) ).

fof(addAssignmentInitValueVector_53,axiom,
    ( v3263(constB0)
  <=> $false ) ).

fof(addAssignment_1030,axiom,
    ! [VarCurr] :
      ( v3239(VarCurr,bitIndex1)
    <=> v3241(VarCurr,bitIndex1) ) ).

fof(addAssignment_1029,axiom,
    ! [VarCurr] :
      ( v3241(VarCurr,bitIndex1)
    <=> v3243(VarCurr,bitIndex1) ) ).

fof(addAssignment_1028,axiom,
    ! [VarNext] :
      ( v3243(VarNext,bitIndex1)
    <=> v3298(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_40,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3299(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v3298(VarNext,B)
            <=> v3243(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_41,axiom,
    ! [VarNext] :
      ( v3299(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v3298(VarNext,B)
          <=> v3293(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_392,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3299(VarNext)
      <=> v3300(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_391,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3300(VarNext)
      <=> ( v3302(VarNext)
          & v3280(VarNext) ) ) ) ).

fof(writeUnaryOperator_185,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3302(VarNext)
      <=> v3287(VarNext) ) ) ).

fof(addAssignment_1027,axiom,
    ! [VarCurr] :
      ( v3247(VarCurr,bitIndex1)
    <=> v3268(VarCurr,bitIndex1) ) ).

fof(addAssignment_1026,axiom,
    ! [VarNext] :
      ( v3243(VarNext,bitIndex2)
    <=> v3282(VarNext,bitIndex2) ) ).

fof(addCaseBooleanConditionEqualRanges1_39,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3283(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v3282(VarNext,B)
            <=> v3243(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_40,axiom,
    ! [VarNext] :
      ( v3283(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v3282(VarNext,B)
          <=> v3293(VarNext,B) ) ) ) ).

fof(addAssignment_1025,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v3293(VarNext,B)
          <=> v3291(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_85,axiom,
    ! [VarCurr] :
      ( ~ v3294(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v3291(VarCurr,B)
          <=> v3247(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_117,axiom,
    ! [VarCurr] :
      ( v3294(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v3291(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_184,axiom,
    ! [VarCurr] :
      ( ~ v3294(VarCurr)
    <=> v3245(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_390,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3283(VarNext)
      <=> v3284(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_389,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3284(VarNext)
      <=> ( v3285(VarNext)
          & v3280(VarNext) ) ) ) ).

fof(writeUnaryOperator_183,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3285(VarNext)
      <=> v3287(VarNext) ) ) ).

fof(addAssignment_1024,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3287(VarNext)
      <=> v3280(VarCurr) ) ) ).

fof(addAssignment_1023,axiom,
    ! [VarCurr] :
      ( v3280(VarCurr)
    <=> v2549(VarCurr) ) ).

fof(addAssignment_1022,axiom,
    ! [VarCurr] :
      ( v3247(VarCurr,bitIndex2)
    <=> v3268(VarCurr,bitIndex2) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_11,axiom,
    ! [VarCurr] :
      ( ( ~ v3269(VarCurr)
        & ~ v3271(VarCurr)
        & ~ v3274(VarCurr) )
     => ! [B] :
          ( range_3_0(B)
         => ( v3268(VarCurr,B)
          <=> v3243(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_20,axiom,
    ! [VarCurr] :
      ( v3274(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v3268(VarCurr,B)
          <=> v3276(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_38,axiom,
    ! [VarCurr] :
      ( v3271(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v3268(VarCurr,B)
          <=> v3273(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_36,axiom,
    ! [VarCurr] :
      ( v3269(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v3268(VarCurr,B)
          <=> v3243(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_196,axiom,
    ! [VarCurr] :
      ( v3277(VarCurr)
    <=> ( ( v3278(VarCurr,bitIndex1)
        <=> $true )
        & ( v3278(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1021,axiom,
    ! [VarCurr] :
      ( v3278(VarCurr,bitIndex0)
    <=> v3257(VarCurr) ) ).

fof(addAssignment_1020,axiom,
    ! [VarCurr] :
      ( v3278(VarCurr,bitIndex1)
    <=> v3249(VarCurr) ) ).

fof(addAssignment_1019,axiom,
    ! [VarCurr] :
      ( v3276(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_1018,axiom,
    ! [VarCurr] :
      ( ( v3276(VarCurr,bitIndex3)
      <=> v3243(VarCurr,bitIndex2) )
      & ( v3276(VarCurr,bitIndex2)
      <=> v3243(VarCurr,bitIndex1) )
      & ( v3276(VarCurr,bitIndex1)
      <=> v3243(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_195,axiom,
    ! [VarCurr] :
      ( v3274(VarCurr)
    <=> ( ( v3275(VarCurr,bitIndex1)
        <=> $true )
        & ( v3275(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1017,axiom,
    ! [VarCurr] :
      ( v3275(VarCurr,bitIndex0)
    <=> v3257(VarCurr) ) ).

fof(addAssignment_1016,axiom,
    ! [VarCurr] :
      ( v3275(VarCurr,bitIndex1)
    <=> v3249(VarCurr) ) ).

fof(addAssignment_1015,axiom,
    ! [VarCurr] :
      ( ( v3273(VarCurr,bitIndex2)
      <=> v3243(VarCurr,bitIndex3) )
      & ( v3273(VarCurr,bitIndex1)
      <=> v3243(VarCurr,bitIndex2) )
      & ( v3273(VarCurr,bitIndex0)
      <=> v3243(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_1014,axiom,
    ! [VarCurr] :
      ( v3273(VarCurr,bitIndex3)
    <=> $false ) ).

fof(addBitVectorEqualityBitBlasted_194,axiom,
    ! [VarCurr] :
      ( v3271(VarCurr)
    <=> ( ( v3272(VarCurr,bitIndex1)
        <=> $false )
        & ( v3272(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1013,axiom,
    ! [VarCurr] :
      ( v3272(VarCurr,bitIndex0)
    <=> v3257(VarCurr) ) ).

fof(addAssignment_1012,axiom,
    ! [VarCurr] :
      ( v3272(VarCurr,bitIndex1)
    <=> v3249(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_193,axiom,
    ! [VarCurr] :
      ( v3269(VarCurr)
    <=> ( ( v3270(VarCurr,bitIndex1)
        <=> $false )
        & ( v3270(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1011,axiom,
    ! [VarCurr] :
      ( v3270(VarCurr,bitIndex0)
    <=> v3257(VarCurr) ) ).

fof(addAssignment_1010,axiom,
    ! [VarCurr] :
      ( v3270(VarCurr,bitIndex1)
    <=> v3249(VarCurr) ) ).

fof(addAssignment_1009,axiom,
    ! [VarCurr] :
      ( v3239(VarCurr,bitIndex0)
    <=> v3241(VarCurr,bitIndex0) ) ).

fof(addAssignment_1008,axiom,
    ! [VarCurr] :
      ( v3241(VarCurr,bitIndex0)
    <=> v3243(VarCurr,bitIndex0) ) ).

fof(addAssignmentInitValueVector_52,axiom,
    ! [B] :
      ( range_3_0(B)
     => ( v3243(constB0,B)
      <=> $false ) ) ).

fof(addAssignment_1007,axiom,
    ! [VarCurr] :
      ( v3265(VarCurr)
    <=> v711(VarCurr) ) ).

fof(addAssignment_1006,axiom,
    ! [VarCurr] :
      ( v3249(VarCurr)
    <=> v3251(VarCurr) ) ).

fof(addAssignment_1005,axiom,
    ! [VarCurr] :
      ( v3251(VarCurr)
    <=> v3253(VarCurr) ) ).

fof(addAssignment_1004,axiom,
    ! [VarCurr] :
      ( v3253(VarCurr)
    <=> v3255(VarCurr) ) ).

fof(addAssignment_1003,axiom,
    ! [VarCurr] :
      ( v3255(VarCurr)
    <=> v2758(VarCurr,bitIndex2) ) ).

fof(addAssignment_1002,axiom,
    ! [VarCurr] :
      ( v3245(VarCurr)
    <=> v711(VarCurr) ) ).

fof(addAssignment_1001,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v2758(VarCurr,B)
      <=> v2760(VarCurr,B) ) ) ).

fof(addAssignment_1000,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v2760(VarCurr,B)
      <=> v2762(VarCurr,B) ) ) ).

fof(addAssignment_999,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v2762(VarCurr,B)
      <=> v2764(VarCurr,B) ) ) ).

fof(addAssignment_998,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v2764(VarCurr,B)
      <=> v2766(VarCurr,B) ) ) ).

fof(addAssignment_997,axiom,
    ! [VarCurr] :
      ( ( v2766(VarCurr,bitIndex2)
      <=> v2768(VarCurr,bitIndex3) )
      & ( v2766(VarCurr,bitIndex1)
      <=> v2768(VarCurr,bitIndex2) )
      & ( v2766(VarCurr,bitIndex0)
      <=> v2768(VarCurr,bitIndex1) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_38,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3226(VarNext)
       => ( v2768(VarNext,bitIndex3)
        <=> v2768(VarCurr,bitIndex3) ) ) ) ).

fof(addCaseBooleanConditionShiftedRanges0_2,axiom,
    ! [VarNext] :
      ( v3226(VarNext)
     => ( v2768(VarNext,bitIndex3)
      <=> v3234(VarNext) ) ) ).

fof(addAssignment_996,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3234(VarNext)
      <=> v3232(VarCurr) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_35,axiom,
    ! [VarCurr] :
      ( ~ v3235(VarCurr)
     => ( v3232(VarCurr)
      <=> v2796(VarCurr,bitIndex2) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_116,axiom,
    ! [VarCurr] :
      ( v3235(VarCurr)
     => ( v3232(VarCurr)
      <=> $false ) ) ).

fof(writeUnaryOperator_182,axiom,
    ! [VarCurr] :
      ( ~ v3235(VarCurr)
    <=> v2591(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_388,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3226(VarNext)
      <=> v3227(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_387,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3227(VarNext)
      <=> ( v3228(VarNext)
          & v3155(VarNext) ) ) ) ).

fof(writeUnaryOperator_181,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3228(VarNext)
      <=> v3164(VarNext) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_37,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3206(VarNext)
       => ( v2768(VarNext,bitIndex2)
        <=> v2768(VarCurr,bitIndex2) ) ) ) ).

fof(addCaseBooleanConditionShiftedRanges0_1,axiom,
    ! [VarNext] :
      ( v3206(VarNext)
     => ( v2768(VarNext,bitIndex2)
      <=> v3221(VarNext) ) ) ).

fof(addAssignment_995,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3221(VarNext)
      <=> v3219(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges1,axiom,
    ! [VarCurr] :
      ( ~ v3215(VarCurr)
     => ( v3219(VarCurr)
      <=> v2796(VarCurr,bitIndex1) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_35,axiom,
    ! [VarCurr] :
      ( v3215(VarCurr)
     => ( v3219(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_386,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3206(VarNext)
      <=> ( v3207(VarNext)
          & v3214(VarNext) ) ) ) ).

fof(addAssignment_994,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3214(VarNext)
      <=> v3212(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_385,axiom,
    ! [VarCurr] :
      ( v3212(VarCurr)
    <=> ( v3215(VarCurr)
        | v3216(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_384,axiom,
    ! [VarCurr] :
      ( v3216(VarCurr)
    <=> ( v3217(VarCurr)
        & v3218(VarCurr) ) ) ).

fof(writeUnaryOperator_180,axiom,
    ! [VarCurr] :
      ( ~ v3218(VarCurr)
    <=> v3215(VarCurr) ) ).

fof(writeUnaryOperator_179,axiom,
    ! [VarCurr] :
      ( ~ v3217(VarCurr)
    <=> v2587(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_178,axiom,
    ! [VarCurr] :
      ( ~ v3215(VarCurr)
    <=> v2591(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_383,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3207(VarNext)
      <=> ( v3208(VarNext)
          & v3155(VarNext) ) ) ) ).

fof(writeUnaryOperator_177,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3208(VarNext)
      <=> v3164(VarNext) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_36,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3186(VarNext)
       => ( v2768(VarNext,bitIndex1)
        <=> v2768(VarCurr,bitIndex1) ) ) ) ).

fof(addCaseBooleanConditionShiftedRanges0,axiom,
    ! [VarNext] :
      ( v3186(VarNext)
     => ( v2768(VarNext,bitIndex1)
      <=> v3201(VarNext) ) ) ).

fof(addAssignment_993,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3201(VarNext)
      <=> v3199(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_37,axiom,
    ! [VarCurr] :
      ( ~ v3195(VarCurr)
     => ( v3199(VarCurr)
      <=> v2796(VarCurr,bitIndex0) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_34,axiom,
    ! [VarCurr] :
      ( v3195(VarCurr)
     => ( v3199(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_382,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3186(VarNext)
      <=> ( v3187(VarNext)
          & v3194(VarNext) ) ) ) ).

fof(addAssignment_992,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3194(VarNext)
      <=> v3192(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_381,axiom,
    ! [VarCurr] :
      ( v3192(VarCurr)
    <=> ( v3195(VarCurr)
        | v3196(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_380,axiom,
    ! [VarCurr] :
      ( v3196(VarCurr)
    <=> ( v3197(VarCurr)
        & v3198(VarCurr) ) ) ).

fof(writeUnaryOperator_176,axiom,
    ! [VarCurr] :
      ( ~ v3198(VarCurr)
    <=> v3195(VarCurr) ) ).

fof(writeUnaryOperator_175,axiom,
    ! [VarCurr] :
      ( ~ v3197(VarCurr)
    <=> v2587(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_174,axiom,
    ! [VarCurr] :
      ( ~ v3195(VarCurr)
    <=> v2591(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_379,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3187(VarNext)
      <=> ( v3188(VarNext)
          & v3155(VarNext) ) ) ) ).

fof(writeUnaryOperator_173,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3188(VarNext)
      <=> v3164(VarNext) ) ) ).

fof(writeBinaryOperatorShiftedRanges_100,axiom,
    ! [VarCurr] :
      ( v2796(VarCurr,bitIndex2)
    <=> ( v2768(VarCurr,bitIndex2)
        & v3183(VarCurr) ) ) ).

fof(writeUnaryOperator_172,axiom,
    ! [VarCurr] :
      ( ~ v3183(VarCurr)
    <=> v2587(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges_99,axiom,
    ! [VarCurr] :
      ( v2796(VarCurr,bitIndex1)
    <=> ( v2768(VarCurr,bitIndex1)
        & v3181(VarCurr) ) ) ).

fof(writeUnaryOperator_171,axiom,
    ! [VarCurr] :
      ( ~ v3181(VarCurr)
    <=> v2587(VarCurr,bitIndex1) ) ).

fof(addAssignment_991,axiom,
    ! [VarCurr] :
      ( v2587(VarCurr,bitIndex2)
    <=> v2770(VarCurr,bitIndex2) ) ).

fof(addAssignment_990,axiom,
    ! [VarCurr] :
      ( v2796(VarCurr,bitIndex0)
    <=> v2768(VarCurr,bitIndex0) ) ).

fof(addAssignment_989,axiom,
    ! [VarCurr] :
      ( v2768(VarCurr,bitIndex0)
    <=> v2798(VarCurr) ) ).

fof(addAssignmentInitValueVector_51,axiom,
    ( v2768(constB0,bitIndex3)
  <=> $false ) ).

fof(addAssignmentInitValueVector_50,axiom,
    ( v2768(constB0,bitIndex2)
  <=> $false ) ).

fof(addAssignmentInitValueVector_49,axiom,
    ( v2768(constB0,bitIndex1)
  <=> $false ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_378,axiom,
    ! [VarCurr] :
      ( v2798(VarCurr)
    <=> ( v3175(VarCurr)
        & v3179(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_377,axiom,
    ! [VarCurr] :
      ( v3179(VarCurr)
    <=> ( v2992(VarCurr)
        & v3153(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_376,axiom,
    ! [VarCurr] :
      ( v3175(VarCurr)
    <=> ( v3176(VarCurr)
        & v3178(VarCurr) ) ) ).

fof(writeUnaryOperator_170,axiom,
    ! [VarCurr] :
      ( ~ v3178(VarCurr)
    <=> v2587(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_375,axiom,
    ! [VarCurr] :
      ( v3176(VarCurr)
    <=> ( v2800(VarCurr)
        & v3177(VarCurr) ) ) ).

fof(writeUnaryOperator_169,axiom,
    ! [VarCurr] :
      ( ~ v3177(VarCurr)
    <=> v2810(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_35,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3160(VarNext)
       => ( v3153(VarNext)
        <=> v3153(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_39,axiom,
    ! [VarNext] :
      ( v3160(VarNext)
     => ( v3153(VarNext)
      <=> v3170(VarNext) ) ) ).

fof(addAssignment_988,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3170(VarNext)
      <=> v3168(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_84,axiom,
    ! [VarCurr] :
      ( ~ v3171(VarCurr)
     => ( v3168(VarCurr)
      <=> v2992(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_115,axiom,
    ! [VarCurr] :
      ( v3171(VarCurr)
     => ( v3168(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_192,axiom,
    ! [VarCurr] :
      ( v3171(VarCurr)
    <=> ( v2591(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_374,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3160(VarNext)
      <=> v3161(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_373,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3161(VarNext)
      <=> ( v3162(VarNext)
          & v3155(VarNext) ) ) ) ).

fof(writeUnaryOperator_168,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3162(VarNext)
      <=> v3164(VarNext) ) ) ).

fof(addAssignment_987,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3164(VarNext)
      <=> v3155(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_48,axiom,
    ( v3153(constB0)
  <=> $false ) ).

fof(addAssignment_986,axiom,
    ! [VarCurr] :
      ( v3155(VarCurr)
    <=> v3157(VarCurr) ) ).

fof(addAssignment_985,axiom,
    ! [VarCurr] :
      ( v3157(VarCurr)
    <=> v2551(VarCurr) ) ).

fof(addAssignment_984,axiom,
    ! [VarCurr] :
      ( v2992(VarCurr)
    <=> v2994(VarCurr) ) ).

fof(addAssignment_983,axiom,
    ! [VarCurr] :
      ( v2994(VarCurr)
    <=> v2996(VarCurr) ) ).

fof(addAssignment_982,axiom,
    ! [VarCurr] :
      ( v2996(VarCurr)
    <=> v2998(VarCurr) ) ).

fof(addAssignment_981,axiom,
    ! [VarCurr] :
      ( v2998(VarCurr)
    <=> v3000(VarCurr) ) ).

fof(addAssignment_980,axiom,
    ! [VarCurr] :
      ( v3000(VarCurr)
    <=> v3002(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_83,axiom,
    ! [VarCurr] :
      ( ~ v3004(VarCurr)
     => ( v3002(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_114,axiom,
    ! [VarCurr] :
      ( v3004(VarCurr)
     => ( v3002(VarCurr)
      <=> $false ) ) ).

fof(addAssignment_979,axiom,
    ! [VarCurr] :
      ( v3004(VarCurr)
    <=> v3006(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_372,axiom,
    ! [VarCurr] :
      ( v3006(VarCurr)
    <=> ( v3149(VarCurr)
        | v3125(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_371,axiom,
    ! [VarCurr] :
      ( v3149(VarCurr)
    <=> ( v3150(VarCurr)
        | v3086(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_370,axiom,
    ! [VarCurr] :
      ( v3150(VarCurr)
    <=> ( v3008(VarCurr)
        | v3062(VarCurr) ) ) ).

fof(addAssignment_978,axiom,
    ! [VarCurr] :
      ( v3125(VarCurr)
    <=> v3127(VarCurr) ) ).

fof(addAssignment_977,axiom,
    ! [VarCurr] :
      ( v3127(VarCurr)
    <=> v3129(VarCurr) ) ).

fof(addAssignment_976,axiom,
    ! [VarCurr] :
      ( v3129(VarCurr)
    <=> v3131(VarCurr) ) ).

fof(addAssignment_975,axiom,
    ! [VarCurr] :
      ( v3131(VarCurr)
    <=> v3133(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_34,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3136(VarNext)
       => ( v3133(VarNext)
        <=> v3133(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_38,axiom,
    ! [VarNext] :
      ( v3136(VarNext)
     => ( v3133(VarNext)
      <=> v3144(VarNext) ) ) ).

fof(addAssignment_974,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3144(VarNext)
      <=> v3142(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_82,axiom,
    ! [VarCurr] :
      ( ~ v3056(VarCurr)
     => ( v3142(VarCurr)
      <=> v3145(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_113,axiom,
    ! [VarCurr] :
      ( v3056(VarCurr)
     => ( v3142(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_369,axiom,
    ! [VarCurr] :
      ( v3145(VarCurr)
    <=> ( v3020(VarCurr)
        & v3096(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_368,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3136(VarNext)
      <=> v3137(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_367,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3137(VarNext)
      <=> ( v3139(VarNext)
          & v3042(VarNext) ) ) ) ).

fof(writeUnaryOperator_167,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3139(VarNext)
      <=> v3049(VarNext) ) ) ).

fof(addAssignmentInitValueVector_47,axiom,
    ( v3133(constB0)
  <=> $false ) ).

fof(addAssignment_973,axiom,
    ! [VarCurr] :
      ( v3086(VarCurr)
    <=> v3088(VarCurr) ) ).

fof(addAssignment_972,axiom,
    ! [VarCurr] :
      ( v3088(VarCurr)
    <=> v3090(VarCurr) ) ).

fof(addAssignment_971,axiom,
    ! [VarCurr] :
      ( v3090(VarCurr)
    <=> v3092(VarCurr) ) ).

fof(addAssignment_970,axiom,
    ! [VarCurr] :
      ( v3092(VarCurr)
    <=> v3094(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_33,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3111(VarNext)
       => ( v3094(VarNext)
        <=> v3094(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_37,axiom,
    ! [VarNext] :
      ( v3111(VarNext)
     => ( v3094(VarNext)
      <=> v3119(VarNext) ) ) ).

fof(addAssignment_969,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3119(VarNext)
      <=> v3117(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_81,axiom,
    ! [VarCurr] :
      ( ~ v3056(VarCurr)
     => ( v3117(VarCurr)
      <=> v3120(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_112,axiom,
    ! [VarCurr] :
      ( v3056(VarCurr)
     => ( v3117(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_366,axiom,
    ! [VarCurr] :
      ( v3120(VarCurr)
    <=> ( v3121(VarCurr)
        & v3096(VarCurr) ) ) ).

fof(writeUnaryOperator_166,axiom,
    ! [VarCurr] :
      ( ~ v3121(VarCurr)
    <=> v3020(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_365,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3111(VarNext)
      <=> v3112(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_364,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3112(VarNext)
      <=> ( v3114(VarNext)
          & v3042(VarNext) ) ) ) ).

fof(writeUnaryOperator_165,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3114(VarNext)
      <=> v3049(VarNext) ) ) ).

fof(addAssignmentInitValueVector_46,axiom,
    ( v3094(constB0)
  <=> $false ) ).

fof(addAssignment_968,axiom,
    ! [VarCurr] :
      ( v3096(VarCurr)
    <=> v3098(VarCurr) ) ).

fof(addAssignment_967,axiom,
    ! [VarCurr] :
      ( v3098(VarCurr)
    <=> v3100(VarCurr) ) ).

fof(addAssignment_966,axiom,
    ! [VarCurr] :
      ( v3100(VarCurr)
    <=> v3102(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_363,axiom,
    ! [VarCurr] :
      ( v3102(VarCurr)
    <=> ( v3104(VarCurr)
        & v3108(VarCurr) ) ) ).

fof(writeUnaryOperator_164,axiom,
    ! [VarCurr] :
      ( ~ v3108(VarCurr)
    <=> v3106(VarCurr) ) ).

fof(addAssignmentInitValueVector_45,axiom,
    ( v3106(constB0)
  <=> $false ) ).

fof(addAssignmentInitValueVector_44,axiom,
    ( v3104(constB0)
  <=> $false ) ).

fof(addAssignment_965,axiom,
    ! [VarCurr] :
      ( v3062(VarCurr)
    <=> v3064(VarCurr) ) ).

fof(addAssignment_964,axiom,
    ! [VarCurr] :
      ( v3064(VarCurr)
    <=> v3066(VarCurr) ) ).

fof(addAssignment_963,axiom,
    ! [VarCurr] :
      ( v3066(VarCurr)
    <=> v3068(VarCurr) ) ).

fof(addAssignment_962,axiom,
    ! [VarCurr] :
      ( v3068(VarCurr)
    <=> v3070(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_32,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3073(VarNext)
       => ( v3070(VarNext)
        <=> v3070(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_36,axiom,
    ! [VarNext] :
      ( v3073(VarNext)
     => ( v3070(VarNext)
      <=> v3081(VarNext) ) ) ).

fof(addAssignment_961,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3081(VarNext)
      <=> v3079(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_80,axiom,
    ! [VarCurr] :
      ( ~ v3056(VarCurr)
     => ( v3079(VarCurr)
      <=> v3082(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_111,axiom,
    ! [VarCurr] :
      ( v3056(VarCurr)
     => ( v3079(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_362,axiom,
    ! [VarCurr] :
      ( v3082(VarCurr)
    <=> ( v3020(VarCurr)
        & v3028(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_361,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3073(VarNext)
      <=> v3074(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_360,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3074(VarNext)
      <=> ( v3076(VarNext)
          & v3042(VarNext) ) ) ) ).

fof(writeUnaryOperator_163,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3076(VarNext)
      <=> v3049(VarNext) ) ) ).

fof(addAssignmentInitValueVector_43,axiom,
    ( v3070(constB0)
  <=> $false ) ).

fof(addAssignment_960,axiom,
    ! [VarCurr] :
      ( v3008(VarCurr)
    <=> v3010(VarCurr) ) ).

fof(addAssignment_959,axiom,
    ! [VarCurr] :
      ( v3010(VarCurr)
    <=> v3012(VarCurr) ) ).

fof(addAssignment_958,axiom,
    ! [VarCurr] :
      ( v3012(VarCurr)
    <=> v3014(VarCurr) ) ).

fof(addAssignment_957,axiom,
    ! [VarCurr] :
      ( v3014(VarCurr)
    <=> v3016(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_31,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3045(VarNext)
       => ( v3016(VarNext)
        <=> v3016(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_35,axiom,
    ! [VarNext] :
      ( v3045(VarNext)
     => ( v3016(VarNext)
      <=> v3055(VarNext) ) ) ).

fof(addAssignment_956,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3055(VarNext)
      <=> v3053(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_79,axiom,
    ! [VarCurr] :
      ( ~ v3056(VarCurr)
     => ( v3053(VarCurr)
      <=> v3057(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_110,axiom,
    ! [VarCurr] :
      ( v3056(VarCurr)
     => ( v3053(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_359,axiom,
    ! [VarCurr] :
      ( v3057(VarCurr)
    <=> ( v3058(VarCurr)
        & v3028(VarCurr) ) ) ).

fof(writeUnaryOperator_162,axiom,
    ! [VarCurr] :
      ( ~ v3058(VarCurr)
    <=> v3020(VarCurr) ) ).

fof(writeUnaryOperator_161,axiom,
    ! [VarCurr] :
      ( ~ v3056(VarCurr)
    <=> v3018(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_358,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3045(VarNext)
      <=> v3046(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_357,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3046(VarNext)
      <=> ( v3047(VarNext)
          & v3042(VarNext) ) ) ) ).

fof(writeUnaryOperator_160,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3047(VarNext)
      <=> v3049(VarNext) ) ) ).

fof(addAssignment_955,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3049(VarNext)
      <=> v3042(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_42,axiom,
    ( v3016(constB0)
  <=> $false ) ).

fof(addAssignment_954,axiom,
    ! [VarCurr] :
      ( v3042(VarCurr)
    <=> v2944(VarCurr) ) ).

fof(addAssignment_953,axiom,
    ! [VarCurr] :
      ( v3028(VarCurr)
    <=> v3030(VarCurr) ) ).

fof(addAssignment_952,axiom,
    ! [VarCurr] :
      ( v3030(VarCurr)
    <=> v3032(VarCurr) ) ).

fof(addAssignment_951,axiom,
    ! [VarCurr] :
      ( v3032(VarCurr)
    <=> v3034(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_356,axiom,
    ! [VarCurr] :
      ( v3034(VarCurr)
    <=> ( v3036(VarCurr)
        & v3040(VarCurr) ) ) ).

fof(writeUnaryOperator_159,axiom,
    ! [VarCurr] :
      ( ~ v3040(VarCurr)
    <=> v3038(VarCurr) ) ).

fof(addAssignmentInitValueVector_41,axiom,
    ( v3038(constB0)
  <=> $false ) ).

fof(addAssignmentInitValueVector_40,axiom,
    ( v3036(constB0)
  <=> $false ) ).

fof(addAssignment_950,axiom,
    ! [VarCurr] :
      ( v3020(VarCurr)
    <=> v3022(VarCurr) ) ).

fof(addAssignment_949,axiom,
    ! [VarCurr] :
      ( v3022(VarCurr)
    <=> v3024(VarCurr) ) ).

fof(addAssignment_948,axiom,
    ! [VarCurr] :
      ( v3024(VarCurr)
    <=> v3026(VarCurr) ) ).

fof(addAssignment_947,axiom,
    ! [VarCurr] :
      ( v3026(VarCurr)
    <=> v2913(VarCurr) ) ).

fof(addAssignment_946,axiom,
    ! [VarCurr] :
      ( v3018(VarCurr)
    <=> v2856(VarCurr) ) ).

fof(addAssignment_945,axiom,
    ! [VarCurr] :
      ( v2810(VarCurr)
    <=> v2812(VarCurr) ) ).

fof(addAssignment_944,axiom,
    ! [VarCurr] :
      ( v2812(VarCurr)
    <=> v2814(VarCurr) ) ).

fof(addAssignment_943,axiom,
    ! [VarCurr] :
      ( v2814(VarCurr)
    <=> v2816(VarCurr) ) ).

fof(addAssignment_942,axiom,
    ! [VarCurr] :
      ( v2816(VarCurr)
    <=> v2818(VarCurr) ) ).

fof(addAssignment_941,axiom,
    ! [VarCurr] :
      ( v2818(VarCurr)
    <=> v2820(VarCurr) ) ).

fof(addAssignment_940,axiom,
    ! [VarCurr] :
      ( v2820(VarCurr)
    <=> v2822(VarCurr) ) ).

fof(addAssignment_939,axiom,
    ! [VarCurr] :
      ( v2822(VarCurr)
    <=> v2824(VarCurr) ) ).

fof(addAssignment_938,axiom,
    ! [VarCurr] :
      ( v2824(VarCurr)
    <=> v2826(VarCurr) ) ).

fof(addAssignment_937,axiom,
    ! [VarCurr] :
      ( v2826(VarCurr)
    <=> v2828(VarCurr) ) ).

fof(addAssignment_936,axiom,
    ! [VarCurr] :
      ( v2828(VarCurr)
    <=> v193(VarCurr,bitIndex12) ) ).

fof(addAssignment_935,axiom,
    ! [VarCurr] :
      ( v193(VarCurr,bitIndex12)
    <=> v195(VarCurr,bitIndex12) ) ).

fof(addAssignment_934,axiom,
    ! [VarCurr] :
      ( v195(VarCurr,bitIndex12)
    <=> v2830(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_30,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2947(VarNext)
       => ( v2830(VarNext)
        <=> v2830(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_34,axiom,
    ! [VarNext] :
      ( v2947(VarNext)
     => ( v2830(VarNext)
      <=> v2982(VarNext) ) ) ).

fof(addAssignment_933,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2982(VarNext)
      <=> v2980(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_36,axiom,
    ! [VarCurr] :
      ( ~ v2832(VarCurr)
     => ( v2980(VarCurr)
      <=> v2983(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_33,axiom,
    ! [VarCurr] :
      ( v2832(VarCurr)
     => ( v2980(VarCurr)
      <=> v2859(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_35,axiom,
    ! [VarCurr] :
      ( ~ v2960(VarCurr)
     => ( v2983(VarCurr)
      <=> v2932(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_32,axiom,
    ! [VarCurr] :
      ( v2960(VarCurr)
     => ( v2983(VarCurr)
      <=> v2984(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_19,axiom,
    ! [VarCurr] :
      ( ( ~ v2963(VarCurr)
        & ~ v2965(VarCurr) )
     => ( v2984(VarCurr)
      <=> v2988(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_34,axiom,
    ! [VarCurr] :
      ( v2965(VarCurr)
     => ( v2984(VarCurr)
      <=> v2987(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_31,axiom,
    ! [VarCurr] :
      ( v2963(VarCurr)
     => ( v2984(VarCurr)
      <=> v2985(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_33,axiom,
    ! [VarCurr] :
      ( ~ v2973(VarCurr)
     => ( v2988(VarCurr)
      <=> v2932(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_30,axiom,
    ! [VarCurr] :
      ( v2973(VarCurr)
     => ( v2988(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_32,axiom,
    ! [VarCurr] :
      ( ~ v2967(VarCurr)
     => ( v2987(VarCurr)
      <=> v2932(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_29,axiom,
    ! [VarCurr] :
      ( v2967(VarCurr)
     => ( v2987(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_78,axiom,
    ! [VarCurr] :
      ( ~ v2986(VarCurr)
     => ( v2985(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_109,axiom,
    ! [VarCurr] :
      ( v2986(VarCurr)
     => ( v2985(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_191,axiom,
    ! [VarCurr] :
      ( v2986(VarCurr)
    <=> ( v2867(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_355,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2947(VarNext)
      <=> ( v2948(VarNext)
          & v2957(VarNext) ) ) ) ).

fof(addAssignment_932,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2957(VarNext)
      <=> v2955(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_354,axiom,
    ! [VarCurr] :
      ( v2955(VarCurr)
    <=> ( v2832(VarCurr)
        | v2958(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_353,axiom,
    ! [VarCurr] :
      ( v2958(VarCurr)
    <=> ( v2959(VarCurr)
        & v2979(VarCurr) ) ) ).

fof(writeUnaryOperator_158,axiom,
    ! [VarCurr] :
      ( ~ v2979(VarCurr)
    <=> v2832(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_352,axiom,
    ! [VarCurr] :
      ( v2959(VarCurr)
    <=> ( v2960(VarCurr)
        | v2977(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_351,axiom,
    ! [VarCurr] :
      ( v2977(VarCurr)
    <=> ( v2895(VarCurr)
        & v2978(VarCurr) ) ) ).

fof(writeUnaryOperator_157,axiom,
    ! [VarCurr] :
      ( ~ v2978(VarCurr)
    <=> v2897(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_350,axiom,
    ! [VarCurr] :
      ( v2960(VarCurr)
    <=> ( v2961(VarCurr)
        & v2897(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_349,axiom,
    ! [VarCurr] :
      ( v2961(VarCurr)
    <=> ( v2962(VarCurr)
        | v2971(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_348,axiom,
    ! [VarCurr] :
      ( v2971(VarCurr)
    <=> ( v2972(VarCurr)
        & v2976(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_190,axiom,
    ! [VarCurr] :
      ( v2976(VarCurr)
    <=> ( ( v2964(VarCurr,bitIndex2)
        <=> $false )
        & ( v2964(VarCurr,bitIndex1)
        <=> $false )
        & ( v2964(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_347,axiom,
    ! [VarCurr] :
      ( v2972(VarCurr)
    <=> ( v2973(VarCurr)
        | v2974(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_346,axiom,
    ! [VarCurr] :
      ( v2974(VarCurr)
    <=> ( v2895(VarCurr)
        & v2975(VarCurr) ) ) ).

fof(writeUnaryOperator_156,axiom,
    ! [VarCurr] :
      ( ~ v2975(VarCurr)
    <=> v2973(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_189,axiom,
    ! [VarCurr] :
      ( v2973(VarCurr)
    <=> ( v2867(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_345,axiom,
    ! [VarCurr] :
      ( v2962(VarCurr)
    <=> ( v2963(VarCurr)
        | v2965(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_344,axiom,
    ! [VarCurr] :
      ( v2965(VarCurr)
    <=> ( v2966(VarCurr)
        & v2970(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_188,axiom,
    ! [VarCurr] :
      ( v2970(VarCurr)
    <=> ( ( v2964(VarCurr,bitIndex2)
        <=> $false )
        & ( v2964(VarCurr,bitIndex1)
        <=> $true )
        & ( v2964(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_343,axiom,
    ! [VarCurr] :
      ( v2966(VarCurr)
    <=> ( v2967(VarCurr)
        | v2968(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_342,axiom,
    ! [VarCurr] :
      ( v2968(VarCurr)
    <=> ( v2895(VarCurr)
        & v2969(VarCurr) ) ) ).

fof(writeUnaryOperator_155,axiom,
    ! [VarCurr] :
      ( ~ v2969(VarCurr)
    <=> v2967(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_187,axiom,
    ! [VarCurr] :
      ( v2967(VarCurr)
    <=> ( v2867(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_186,axiom,
    ! [VarCurr] :
      ( v2963(VarCurr)
    <=> ( ( v2964(VarCurr,bitIndex2)
        <=> $true )
        & ( v2964(VarCurr,bitIndex1)
        <=> $false )
        & ( v2964(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_931,axiom,
    ! [VarCurr] :
      ( v2964(VarCurr,bitIndex0)
    <=> v2865(VarCurr) ) ).

fof(addAssignment_930,axiom,
    ! [VarCurr] :
      ( v2964(VarCurr,bitIndex1)
    <=> v2863(VarCurr) ) ).

fof(addAssignment_929,axiom,
    ! [VarCurr] :
      ( v2964(VarCurr,bitIndex2)
    <=> v2861(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_341,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2948(VarNext)
      <=> ( v2949(VarNext)
          & v2934(VarNext) ) ) ) ).

fof(writeUnaryOperator_154,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2949(VarNext)
      <=> v2951(VarNext) ) ) ).

fof(addAssignment_928,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2951(VarNext)
      <=> v2934(VarCurr) ) ) ).

fof(addAssignment_927,axiom,
    ! [VarCurr] :
      ( v2934(VarCurr)
    <=> v2936(VarCurr) ) ).

fof(addAssignment_926,axiom,
    ! [VarCurr] :
      ( v2936(VarCurr)
    <=> v2938(VarCurr) ) ).

fof(addAssignment_925,axiom,
    ! [VarCurr] :
      ( v2938(VarCurr)
    <=> v2940(VarCurr) ) ).

fof(addAssignment_924,axiom,
    ! [VarCurr] :
      ( v2940(VarCurr)
    <=> v2942(VarCurr) ) ).

fof(addAssignment_923,axiom,
    ! [VarCurr] :
      ( v2942(VarCurr)
    <=> v2944(VarCurr) ) ).

fof(addAssignment_922,axiom,
    ! [VarCurr] :
      ( v2944(VarCurr)
    <=> v2551(VarCurr) ) ).

fof(addAssignment_921,axiom,
    ! [VarCurr] :
      ( v2932(VarCurr)
    <=> $false ) ).

fof(addAssignment_920,axiom,
    ! [VarCurr] :
      ( v2897(VarCurr)
    <=> v2899(VarCurr) ) ).

fof(addAssignment_919,axiom,
    ! [VarCurr] :
      ( v2899(VarCurr)
    <=> v2901(VarCurr) ) ).

fof(addAssignment_918,axiom,
    ! [VarCurr] :
      ( v2901(VarCurr)
    <=> v2903(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_340,axiom,
    ! [VarCurr] :
      ( v2903(VarCurr)
    <=> ( v2905(VarCurr)
        & v2911(VarCurr) ) ) ).

fof(addAssignment_917,axiom,
    ! [VarCurr] :
      ( v2911(VarCurr)
    <=> v2913(VarCurr) ) ).

fof(addAssignment_916,axiom,
    ! [VarCurr] :
      ( v2913(VarCurr)
    <=> v2915(VarCurr) ) ).

fof(addAssignment_915,axiom,
    ! [VarCurr] :
      ( v2915(VarCurr)
    <=> v2917(VarCurr) ) ).

fof(addAssignment_914,axiom,
    ! [VarCurr] :
      ( v2917(VarCurr)
    <=> v2919(VarCurr) ) ).

fof(addAssignment_913,axiom,
    ! [VarCurr] :
      ( v2919(VarCurr)
    <=> v2921(VarCurr) ) ).

fof(addAssignment_912,axiom,
    ! [VarCurr] :
      ( v2921(VarCurr)
    <=> v2923(VarCurr) ) ).

fof(addAssignment_911,axiom,
    ! [VarCurr] :
      ( v2923(VarCurr)
    <=> v2925(VarCurr) ) ).

fof(addAssignment_910,axiom,
    ! [VarCurr] :
      ( v2925(VarCurr)
    <=> v2927(VarCurr) ) ).

fof(addAssignment_909,axiom,
    ! [VarCurr] :
      ( v2927(VarCurr)
    <=> v2929(VarCurr) ) ).

fof(addAssignmentInitValueVector_39,axiom,
    ( v2929(constB0)
  <=> $false ) ).

fof(addAssignment_908,axiom,
    ! [VarCurr] :
      ( v2905(VarCurr)
    <=> v2907(VarCurr) ) ).

fof(addAssignment_907,axiom,
    ! [VarCurr] :
      ( v2907(VarCurr)
    <=> v2909(VarCurr) ) ).

fof(addAssignmentInitValueVector_38,axiom,
    ( v2909(constB0)
  <=> $false ) ).

fof(addAssignment_906,axiom,
    ! [VarCurr] :
      ( v2895(VarCurr)
    <=> $false ) ).

fof(addAssignment_905,axiom,
    ! [VarCurr] :
      ( v2867(VarCurr)
    <=> v2869(VarCurr,bitIndex12) ) ).

fof(addAssignment_904,axiom,
    ! [VarCurr] :
      ( v2869(VarCurr,bitIndex12)
    <=> v2871(VarCurr,bitIndex12) ) ).

fof(addAssignment_903,axiom,
    ! [VarCurr] :
      ( v2871(VarCurr,bitIndex12)
    <=> v2873(VarCurr,bitIndex12) ) ).

fof(addAssignment_902,axiom,
    ! [VarCurr] :
      ( v2873(VarCurr,bitIndex12)
    <=> v2875(VarCurr,bitIndex12) ) ).

fof(addAssignment_901,axiom,
    ! [VarCurr] :
      ( v2875(VarCurr,bitIndex12)
    <=> v2877(VarCurr,bitIndex12) ) ).

fof(addAssignment_900,axiom,
    ! [VarCurr] :
      ( v2877(VarCurr,bitIndex12)
    <=> v2879(VarCurr,bitIndex12) ) ).

fof(addAssignment_899,axiom,
    ! [VarCurr] :
      ( v2879(VarCurr,bitIndex12)
    <=> v2881(VarCurr,bitIndex12) ) ).

fof(addAssignment_898,axiom,
    ! [VarCurr] :
      ( v2881(VarCurr,bitIndex12)
    <=> v2883(VarCurr,bitIndex12) ) ).

fof(addAssignment_897,axiom,
    ! [VarCurr] :
      ( v2883(VarCurr,bitIndex12)
    <=> v2885(VarCurr,bitIndex12) ) ).

fof(addAssignment_896,axiom,
    ! [VarCurr] :
      ( v2885(VarCurr,bitIndex12)
    <=> v2887(VarCurr,bitIndex12) ) ).

fof(addAssignment_895,axiom,
    ! [VarCurr] :
      ( v2887(VarCurr,bitIndex12)
    <=> v2889(VarCurr,bitIndex12) ) ).

fof(addAssignment_894,axiom,
    ! [VarCurr] :
      ( v2889(VarCurr,bitIndex12)
    <=> v2891(VarCurr,bitIndex12) ) ).

fof(addAssignmentInitValue_196,axiom,
    ~ v2891(constB0,bitIndex12) ).

fof(bitBlastConstant_751,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xxxxxxxxxxxx(bitIndex12) ).

fof(addAssignment_893,axiom,
    ! [VarCurr] :
      ( v2865(VarCurr)
    <=> $false ) ).

fof(addAssignment_892,axiom,
    ! [VarCurr] :
      ( v2863(VarCurr)
    <=> $false ) ).

fof(addAssignment_891,axiom,
    ! [VarCurr] :
      ( v2861(VarCurr)
    <=> $true ) ).

fof(addAssignment_890,axiom,
    ! [VarCurr] :
      ( v2859(VarCurr)
    <=> $false ) ).

fof(addAssignment_889,axiom,
    ! [VarCurr] :
      ( v2832(VarCurr)
    <=> v2834(VarCurr) ) ).

fof(writeUnaryOperator_153,axiom,
    ! [VarCurr] :
      ( ~ v2834(VarCurr)
    <=> v2836(VarCurr) ) ).

fof(addAssignment_888,axiom,
    ! [VarCurr] :
      ( v2836(VarCurr)
    <=> v2838(VarCurr) ) ).

fof(addAssignment_887,axiom,
    ! [VarCurr] :
      ( v2838(VarCurr)
    <=> v2840(VarCurr) ) ).

fof(addAssignment_886,axiom,
    ! [VarCurr] :
      ( v2840(VarCurr)
    <=> v2842(VarCurr) ) ).

fof(addAssignment_885,axiom,
    ! [VarCurr] :
      ( v2842(VarCurr)
    <=> v2844(VarCurr) ) ).

fof(addAssignment_884,axiom,
    ! [VarCurr] :
      ( v2844(VarCurr)
    <=> v2846(VarCurr) ) ).

fof(addAssignment_883,axiom,
    ! [VarCurr] :
      ( v2846(VarCurr)
    <=> v2848(VarCurr) ) ).

fof(addAssignment_882,axiom,
    ! [VarCurr] :
      ( v2848(VarCurr)
    <=> v2850(VarCurr) ) ).

fof(addAssignment_881,axiom,
    ! [VarCurr] :
      ( v2850(VarCurr)
    <=> v2852(VarCurr) ) ).

fof(addAssignment_880,axiom,
    ! [VarCurr] :
      ( v2852(VarCurr)
    <=> v2854(VarCurr) ) ).

fof(addAssignment_879,axiom,
    ! [VarCurr] :
      ( v2854(VarCurr)
    <=> v2856(VarCurr) ) ).

fof(addAssignment_878,axiom,
    ! [VarCurr] :
      ( v2856(VarCurr)
    <=> v713(VarCurr) ) ).

fof(addAssignment_877,axiom,
    ! [VarCurr] :
      ( v2800(VarCurr)
    <=> v2802(VarCurr) ) ).

fof(addAssignment_876,axiom,
    ! [VarCurr] :
      ( v2802(VarCurr)
    <=> v2804(VarCurr) ) ).

fof(addAssignment_875,axiom,
    ! [VarCurr] :
      ( v2804(VarCurr)
    <=> v2806(VarCurr) ) ).

fof(addAssignment_874,axiom,
    ! [VarCurr] :
      ( v2806(VarCurr)
    <=> v2808(VarCurr) ) ).

fof(addAssignment_873,axiom,
    ! [VarCurr] :
      ( v2808(VarCurr)
    <=> v703(VarCurr,bitIndex0) ) ).

fof(addAssignment_872,axiom,
    ! [VarCurr] :
      ( v2587(VarCurr,bitIndex1)
    <=> v2770(VarCurr,bitIndex1) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_18,axiom,
    ! [VarCurr] :
      ( ( ~ v2771(VarCurr)
        & ~ v2779(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v2770(VarCurr,B)
          <=> v2787(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_31,axiom,
    ! [VarCurr] :
      ( v2779(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2770(VarCurr,B)
          <=> v2780(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_28,axiom,
    ! [VarCurr] :
      ( v2771(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2770(VarCurr,B)
          <=> v2774(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_30,axiom,
    ! [VarCurr] :
      ( ~ v2788(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2787(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_27,axiom,
    ! [VarCurr] :
      ( v2788(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2787(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_339,axiom,
    ! [VarCurr] :
      ( v2789(VarCurr)
    <=> ( v2791(VarCurr)
        | v2794(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_185,axiom,
    ! [VarCurr] :
      ( v2794(VarCurr)
    <=> ( ( v2595(VarCurr,bitIndex1)
        <=> $true )
        & ( v2595(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_338,axiom,
    ! [VarCurr] :
      ( v2791(VarCurr)
    <=> ( v2792(VarCurr)
        | v2793(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_184,axiom,
    ! [VarCurr] :
      ( v2793(VarCurr)
    <=> ( ( v2595(VarCurr,bitIndex1)
        <=> $true )
        & ( v2595(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_183,axiom,
    ! [VarCurr] :
      ( v2792(VarCurr)
    <=> ( ( v2595(VarCurr,bitIndex1)
        <=> $false )
        & ( v2595(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_182,axiom,
    ! [VarCurr] :
      ( v2788(VarCurr)
    <=> ( ( v2595(VarCurr,bitIndex1)
        <=> $false )
        & ( v2595(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_181,axiom,
    ! [VarCurr] :
      ( v2786(VarCurr)
    <=> ( ( v2589(VarCurr,bitIndex1)
        <=> $true )
        & ( v2589(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_17,axiom,
    ! [VarCurr] :
      ( ( ~ v2781(VarCurr)
        & ~ v2784(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v2780(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_29,axiom,
    ! [VarCurr] :
      ( v2784(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2780(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_26,axiom,
    ! [VarCurr] :
      ( v2781(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2780(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_180,axiom,
    ! [VarCurr] :
      ( v2785(VarCurr)
    <=> ( ( v2595(VarCurr,bitIndex1)
        <=> $true )
        & ( v2595(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_179,axiom,
    ! [VarCurr] :
      ( v2784(VarCurr)
    <=> ( ( v2595(VarCurr,bitIndex1)
        <=> $true )
        & ( v2595(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_337,axiom,
    ! [VarCurr] :
      ( v2781(VarCurr)
    <=> ( v2782(VarCurr)
        | v2783(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_178,axiom,
    ! [VarCurr] :
      ( v2783(VarCurr)
    <=> ( ( v2595(VarCurr,bitIndex1)
        <=> $false )
        & ( v2595(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_177,axiom,
    ! [VarCurr] :
      ( v2782(VarCurr)
    <=> ( ( v2595(VarCurr,bitIndex1)
        <=> $false )
        & ( v2595(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_176,axiom,
    ! [VarCurr] :
      ( v2779(VarCurr)
    <=> ( ( v2589(VarCurr,bitIndex1)
        <=> $true )
        & ( v2589(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_10,axiom,
    ! [VarCurr] :
      ( ( ~ v2775(VarCurr)
        & ~ v2776(VarCurr)
        & ~ v2777(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v2774(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_16,axiom,
    ! [VarCurr] :
      ( v2777(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2774(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(bitBlastConstant_750,axiom,
    ~ b011(bitIndex2) ).

fof(bitBlastConstant_749,axiom,
    b011(bitIndex1) ).

fof(bitBlastConstant_748,axiom,
    b011(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges1_28,axiom,
    ! [VarCurr] :
      ( v2776(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2774(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_25,axiom,
    ! [VarCurr] :
      ( v2775(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2774(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_175,axiom,
    ! [VarCurr] :
      ( v2778(VarCurr)
    <=> ( ( v2595(VarCurr,bitIndex1)
        <=> $true )
        & ( v2595(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_174,axiom,
    ! [VarCurr] :
      ( v2777(VarCurr)
    <=> ( ( v2595(VarCurr,bitIndex1)
        <=> $true )
        & ( v2595(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_173,axiom,
    ! [VarCurr] :
      ( v2776(VarCurr)
    <=> ( ( v2595(VarCurr,bitIndex1)
        <=> $false )
        & ( v2595(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_172,axiom,
    ! [VarCurr] :
      ( v2775(VarCurr)
    <=> ( ( v2595(VarCurr,bitIndex1)
        <=> $false )
        & ( v2595(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_336,axiom,
    ! [VarCurr] :
      ( v2771(VarCurr)
    <=> ( v2772(VarCurr)
        | v2773(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_171,axiom,
    ! [VarCurr] :
      ( v2773(VarCurr)
    <=> ( ( v2589(VarCurr,bitIndex1)
        <=> $false )
        & ( v2589(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_170,axiom,
    ! [VarCurr] :
      ( v2772(VarCurr)
    <=> ( ( v2589(VarCurr,bitIndex1)
        <=> $false )
        & ( v2589(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignmentInitValueVector_37,axiom,
    ! [B] :
      ( range_1_0(B)
     => ( v2589(constB0,B)
      <=> $false ) ) ).

fof(addAssignment_871,axiom,
    ! [VarCurr] :
      ( v2607(VarCurr)
    <=> v2609(VarCurr) ) ).

fof(addAssignment_870,axiom,
    ! [VarCurr] :
      ( v2609(VarCurr)
    <=> v2611(VarCurr) ) ).

fof(addAssignment_869,axiom,
    ! [VarCurr] :
      ( v2611(VarCurr)
    <=> v2613(VarCurr) ) ).

fof(addAssignment_868,axiom,
    ! [VarCurr] :
      ( v2613(VarCurr)
    <=> v2615(VarCurr) ) ).

fof(addAssignment_867,axiom,
    ! [VarCurr] :
      ( v2615(VarCurr)
    <=> v2617(VarCurr) ) ).

fof(addAssignment_866,axiom,
    ! [VarCurr] :
      ( v2617(VarCurr)
    <=> v2619(VarCurr) ) ).

fof(addAssignment_865,axiom,
    ! [VarCurr] :
      ( v2619(VarCurr)
    <=> v2621(VarCurr) ) ).

fof(addAssignment_864,axiom,
    ! [VarCurr] :
      ( v2621(VarCurr)
    <=> v2623(VarCurr) ) ).

fof(addAssignment_863,axiom,
    ! [VarCurr] :
      ( v2623(VarCurr)
    <=> v2625(VarCurr) ) ).

fof(addAssignment_862,axiom,
    ! [VarCurr] :
      ( v2625(VarCurr)
    <=> v2627(VarCurr) ) ).

fof(addAssignment_861,axiom,
    ! [VarCurr] :
      ( v2627(VarCurr)
    <=> v2629(VarCurr) ) ).

fof(addAssignment_860,axiom,
    ! [VarCurr] :
      ( v2629(VarCurr)
    <=> v2631(VarCurr,bitIndex2) ) ).

fof(addAssignment_859,axiom,
    ! [VarNext] :
      ( v2631(VarNext,bitIndex2)
    <=> v2742(VarNext,bitIndex2) ) ).

fof(addCaseBooleanConditionEqualRanges1_29,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2743(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v2742(VarNext,B)
            <=> v2631(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_33,axiom,
    ! [VarNext] :
      ( v2743(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v2742(VarNext,B)
          <=> v2753(VarNext,B) ) ) ) ).

fof(addAssignment_858,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v2753(VarNext,B)
          <=> v2751(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_77,axiom,
    ! [VarCurr] :
      ( ~ v2754(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2751(VarCurr,B)
          <=> v2641(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_108,axiom,
    ! [VarCurr] :
      ( v2754(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2751(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_152,axiom,
    ! [VarCurr] :
      ( ~ v2754(VarCurr)
    <=> v2633(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_335,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2743(VarNext)
      <=> v2744(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_334,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2744(VarNext)
      <=> ( v2745(VarNext)
          & v2734(VarNext) ) ) ) ).

fof(writeUnaryOperator_151,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2745(VarNext)
      <=> v2747(VarNext) ) ) ).

fof(addAssignment_857,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2747(VarNext)
      <=> v2734(VarCurr) ) ) ).

fof(addAssignment_856,axiom,
    ! [VarCurr] :
      ( v2734(VarCurr)
    <=> v2736(VarCurr) ) ).

fof(addAssignment_855,axiom,
    ! [VarCurr] :
      ( v2736(VarCurr)
    <=> v2738(VarCurr) ) ).

fof(addAssignment_854,axiom,
    ! [VarCurr] :
      ( v2738(VarCurr)
    <=> v2740(VarCurr) ) ).

fof(addAssignment_853,axiom,
    ! [VarCurr] :
      ( v2740(VarCurr)
    <=> v1(VarCurr) ) ).

fof(addAssignment_852,axiom,
    ! [VarCurr] :
      ( v2641(VarCurr,bitIndex2)
    <=> v2719(VarCurr,bitIndex2) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_76,axiom,
    ! [VarCurr] :
      ( ~ v2720(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2719(VarCurr,B)
          <=> v2721(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_107,axiom,
    ! [VarCurr] :
      ( v2720(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2719(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_9,axiom,
    ! [VarCurr] :
      ( ( ~ v2722(VarCurr)
        & ~ v2724(VarCurr)
        & ~ v2728(VarCurr) )
     => ! [B] :
          ( range_3_0(B)
         => ( v2721(VarCurr,B)
          <=> v2631(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_15,axiom,
    ! [VarCurr] :
      ( v2728(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2721(VarCurr,B)
          <=> v2730(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_27,axiom,
    ! [VarCurr] :
      ( v2724(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2721(VarCurr,B)
          <=> v2726(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_24,axiom,
    ! [VarCurr] :
      ( v2722(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2721(VarCurr,B)
          <=> v2631(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_169,axiom,
    ! [VarCurr] :
      ( v2731(VarCurr)
    <=> ( ( v2732(VarCurr,bitIndex1)
        <=> $true )
        & ( v2732(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_851,axiom,
    ! [VarCurr] :
      ( v2732(VarCurr,bitIndex0)
    <=> v2665(VarCurr) ) ).

fof(addAssignment_850,axiom,
    ! [VarCurr] :
      ( v2732(VarCurr,bitIndex1)
    <=> v2643(VarCurr) ) ).

fof(addAssignment_849,axiom,
    ! [VarCurr] :
      ( v2730(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_848,axiom,
    ! [VarCurr,B] :
      ( range_3_1(B)
     => ( v2730(VarCurr,B)
      <=> v2714(VarCurr,B) ) ) ).

fof(addBitVectorEqualityBitBlasted_168,axiom,
    ! [VarCurr] :
      ( v2728(VarCurr)
    <=> ( ( v2729(VarCurr,bitIndex1)
        <=> $true )
        & ( v2729(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_847,axiom,
    ! [VarCurr] :
      ( v2729(VarCurr,bitIndex0)
    <=> v2665(VarCurr) ) ).

fof(addAssignment_846,axiom,
    ! [VarCurr] :
      ( v2729(VarCurr,bitIndex1)
    <=> v2643(VarCurr) ) ).

fof(addAssignment_845,axiom,
    ! [VarCurr] :
      ( ( v2726(VarCurr,bitIndex2)
      <=> v2631(VarCurr,bitIndex3) )
      & ( v2726(VarCurr,bitIndex1)
      <=> v2631(VarCurr,bitIndex2) )
      & ( v2726(VarCurr,bitIndex0)
      <=> v2631(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_844,axiom,
    ! [VarCurr] :
      ( v2726(VarCurr,bitIndex3)
    <=> $false ) ).

fof(addBitVectorEqualityBitBlasted_167,axiom,
    ! [VarCurr] :
      ( v2724(VarCurr)
    <=> ( ( v2725(VarCurr,bitIndex1)
        <=> $false )
        & ( v2725(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_843,axiom,
    ! [VarCurr] :
      ( v2725(VarCurr,bitIndex0)
    <=> v2665(VarCurr) ) ).

fof(addAssignment_842,axiom,
    ! [VarCurr] :
      ( v2725(VarCurr,bitIndex1)
    <=> v2643(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_166,axiom,
    ! [VarCurr] :
      ( v2722(VarCurr)
    <=> ( ( v2723(VarCurr,bitIndex1)
        <=> $false )
        & ( v2723(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_841,axiom,
    ! [VarCurr] :
      ( v2723(VarCurr,bitIndex0)
    <=> v2665(VarCurr) ) ).

fof(addAssignment_840,axiom,
    ! [VarCurr] :
      ( v2723(VarCurr,bitIndex1)
    <=> v2643(VarCurr) ) ).

fof(writeUnaryOperator_150,axiom,
    ! [VarCurr] :
      ( ~ v2720(VarCurr)
    <=> v2633(VarCurr) ) ).

fof(addAssignment_839,axiom,
    ! [VarCurr] :
      ( v2714(VarCurr,bitIndex2)
    <=> v2715(VarCurr,bitIndex2) ) ).

fof(addAssignment_838,axiom,
    ! [VarCurr] :
      ( v2715(VarCurr,bitIndex0)
    <=> $false ) ).

fof(addAssignment_837,axiom,
    ! [VarCurr] :
      ( ( v2715(VarCurr,bitIndex3)
      <=> v2631(VarCurr,bitIndex2) )
      & ( v2715(VarCurr,bitIndex2)
      <=> v2631(VarCurr,bitIndex1) )
      & ( v2715(VarCurr,bitIndex1)
      <=> v2631(VarCurr,bitIndex0) ) ) ).

fof(addAssignmentInitValue_195,axiom,
    ~ v2631(constB0,bitIndex3) ).

fof(addAssignmentInitValue_194,axiom,
    ~ v2631(constB0,bitIndex2) ).

fof(addAssignmentInitValue_193,axiom,
    ~ v2631(constB0,bitIndex1) ).

fof(bitBlastConstant_747,axiom,
    ~ b000x(bitIndex3) ).

fof(bitBlastConstant_746,axiom,
    ~ b000x(bitIndex2) ).

fof(bitBlastConstant_745,axiom,
    ~ b000x(bitIndex1) ).

fof(addAssignment_836,axiom,
    ! [VarCurr] :
      ( v2665(VarCurr)
    <=> v2667(VarCurr) ) ).

fof(addAssignment_835,axiom,
    ! [VarCurr] :
      ( v2667(VarCurr)
    <=> v2669(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_14,axiom,
    ! [VarCurr] :
      ( ( ~ v2706(VarCurr)
        & ~ v2709(VarCurr) )
     => ( v2669(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_26,axiom,
    ! [VarCurr] :
      ( v2709(VarCurr)
     => ( v2669(VarCurr)
      <=> v2710(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_23,axiom,
    ! [VarCurr] :
      ( v2706(VarCurr)
     => ( v2669(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_25,axiom,
    ! [VarCurr] :
      ( ~ v2711(VarCurr)
     => ( v2710(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_22,axiom,
    ! [VarCurr] :
      ( v2711(VarCurr)
     => ( v2710(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_165,axiom,
    ! [VarCurr] :
      ( v2712(VarCurr)
    <=> ( v2673(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_164,axiom,
    ! [VarCurr] :
      ( v2711(VarCurr)
    <=> ( v2673(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_163,axiom,
    ! [VarCurr] :
      ( v2709(VarCurr)
    <=> ( ( v2671(VarCurr,bitIndex1)
        <=> $true )
        & ( v2671(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_333,axiom,
    ! [VarCurr] :
      ( v2706(VarCurr)
    <=> ( v2707(VarCurr)
        | v2708(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_162,axiom,
    ! [VarCurr] :
      ( v2708(VarCurr)
    <=> ( ( v2671(VarCurr,bitIndex1)
        <=> $false )
        & ( v2671(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_161,axiom,
    ! [VarCurr] :
      ( v2707(VarCurr)
    <=> ( ( v2671(VarCurr,bitIndex1)
        <=> $false )
        & ( v2671(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignmentInitValueVector_36,axiom,
    ! [B] :
      ( range_1_0(B)
     => ( v2671(constB0,B)
      <=> $false ) ) ).

fof(addAssignment_834,axiom,
    ! [VarCurr] :
      ( v2673(VarCurr)
    <=> v2675(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_332,axiom,
    ! [VarCurr] :
      ( v2675(VarCurr)
    <=> ( v2701(VarCurr)
        & v2697(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_331,axiom,
    ! [VarCurr] :
      ( v2701(VarCurr)
    <=> ( v2702(VarCurr)
        & v2693(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_330,axiom,
    ! [VarCurr] :
      ( v2702(VarCurr)
    <=> ( v2703(VarCurr)
        & v2689(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_329,axiom,
    ! [VarCurr] :
      ( v2703(VarCurr)
    <=> ( v2704(VarCurr)
        & v2685(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_328,axiom,
    ! [VarCurr] :
      ( v2704(VarCurr)
    <=> ( v2677(VarCurr)
        & v2681(VarCurr) ) ) ).

fof(addAssignment_833,axiom,
    ! [VarCurr] :
      ( v2697(VarCurr)
    <=> v2699(VarCurr) ) ).

fof(addAssignmentInitValueVector_35,axiom,
    ( v2699(constB0)
  <=> $true ) ).

fof(addAssignment_832,axiom,
    ! [VarCurr] :
      ( v2693(VarCurr)
    <=> v2695(VarCurr) ) ).

fof(addAssignmentInitValueVector_34,axiom,
    ( v2695(constB0)
  <=> $true ) ).

fof(addAssignment_831,axiom,
    ! [VarCurr] :
      ( v2689(VarCurr)
    <=> v2691(VarCurr) ) ).

fof(addAssignmentInitValueVector_33,axiom,
    ( v2691(constB0)
  <=> $true ) ).

fof(addAssignment_830,axiom,
    ! [VarCurr] :
      ( v2685(VarCurr)
    <=> v2687(VarCurr) ) ).

fof(addAssignmentInitValueVector_32,axiom,
    ( v2687(constB0)
  <=> $true ) ).

fof(addAssignment_829,axiom,
    ! [VarCurr] :
      ( v2681(VarCurr)
    <=> v2683(VarCurr) ) ).

fof(addAssignmentInitValueVector_31,axiom,
    ( v2683(constB0)
  <=> $true ) ).

fof(addAssignment_828,axiom,
    ! [VarCurr] :
      ( v2677(VarCurr)
    <=> v2679(VarCurr) ) ).

fof(addAssignmentInitValueVector_30,axiom,
    ( v2679(constB0)
  <=> $true ) ).

fof(addAssignment_827,axiom,
    ! [VarCurr] :
      ( v2643(VarCurr)
    <=> v2645(VarCurr) ) ).

fof(addAssignment_826,axiom,
    ! [VarCurr] :
      ( v2645(VarCurr)
    <=> v2647(VarCurr) ) ).

fof(addAssignment_825,axiom,
    ! [VarCurr] :
      ( v2647(VarCurr)
    <=> v2649(VarCurr) ) ).

fof(addAssignment_824,axiom,
    ! [VarCurr] :
      ( v2649(VarCurr)
    <=> v2651(VarCurr) ) ).

fof(addAssignment_823,axiom,
    ! [VarCurr] :
      ( v2651(VarCurr)
    <=> v2653(VarCurr) ) ).

fof(addAssignment_822,axiom,
    ! [VarCurr] :
      ( v2653(VarCurr)
    <=> v2655(VarCurr) ) ).

fof(addAssignment_821,axiom,
    ! [VarCurr] :
      ( v2655(VarCurr)
    <=> v2657(VarCurr) ) ).

fof(addAssignment_820,axiom,
    ! [VarCurr] :
      ( v2657(VarCurr)
    <=> v2659(VarCurr) ) ).

fof(addAssignment_819,axiom,
    ! [VarCurr] :
      ( v2659(VarCurr)
    <=> v2661(VarCurr) ) ).

fof(addAssignment_818,axiom,
    ! [VarCurr] :
      ( v2661(VarCurr)
    <=> v2663(VarCurr) ) ).

fof(addAssignment_817,axiom,
    ! [VarCurr] :
      ( v2633(VarCurr)
    <=> v2635(VarCurr) ) ).

fof(addAssignment_816,axiom,
    ! [VarCurr] :
      ( v2635(VarCurr)
    <=> v2637(VarCurr) ) ).

fof(addAssignment_815,axiom,
    ! [VarCurr] :
      ( v2637(VarCurr)
    <=> v2639(VarCurr) ) ).

fof(addAssignment_814,axiom,
    ! [VarCurr] :
      ( v2639(VarCurr)
    <=> v14(VarCurr) ) ).

fof(addAssignment_813,axiom,
    ! [VarCurr] :
      ( v2591(VarCurr)
    <=> v2593(VarCurr) ) ).

fof(addAssignment_812,axiom,
    ! [VarCurr] :
      ( v2593(VarCurr)
    <=> v713(VarCurr) ) ).

fof(addAssignment_811,axiom,
    ! [VarCurr] :
      ( v703(VarCurr,bitIndex0)
    <=> v705(VarCurr,bitIndex0) ) ).

fof(addAssignment_810,axiom,
    ! [VarCurr] :
      ( v705(VarCurr,bitIndex0)
    <=> v707(VarCurr,bitIndex0) ) ).

fof(addAssignment_809,axiom,
    ! [VarNext] :
      ( v707(VarNext,bitIndex0)
    <=> v2569(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionEqualRanges1_28,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2570(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v2569(VarNext,B)
            <=> v707(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_32,axiom,
    ! [VarNext] :
      ( v2570(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v2569(VarNext,B)
          <=> v2564(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_327,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2570(VarNext)
      <=> v2571(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_326,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2571(VarNext)
      <=> ( v2573(VarNext)
          & v2547(VarNext) ) ) ) ).

fof(writeUnaryOperator_149,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2573(VarNext)
      <=> v2558(VarNext) ) ) ).

fof(addAssignment_808,axiom,
    ! [VarCurr] :
      ( v715(VarCurr,bitIndex0)
    <=> v2535(VarCurr,bitIndex0) ) ).

fof(addAssignment_807,axiom,
    ! [VarNext] :
      ( v707(VarNext,bitIndex1)
    <=> v2553(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_27,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2554(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v2553(VarNext,B)
            <=> v707(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_31,axiom,
    ! [VarNext] :
      ( v2554(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v2553(VarNext,B)
          <=> v2564(VarNext,B) ) ) ) ).

fof(addAssignment_806,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v2564(VarNext,B)
          <=> v2562(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_75,axiom,
    ! [VarCurr] :
      ( ~ v2565(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2562(VarCurr,B)
          <=> v715(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_106,axiom,
    ! [VarCurr] :
      ( v2565(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2562(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_148,axiom,
    ! [VarCurr] :
      ( ~ v2565(VarCurr)
    <=> v709(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_325,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2554(VarNext)
      <=> v2555(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_324,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2555(VarNext)
      <=> ( v2556(VarNext)
          & v2547(VarNext) ) ) ) ).

fof(writeUnaryOperator_147,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2556(VarNext)
      <=> v2558(VarNext) ) ) ).

fof(addAssignment_805,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2558(VarNext)
      <=> v2547(VarCurr) ) ) ).

fof(addAssignment_804,axiom,
    ! [VarCurr] :
      ( v2547(VarCurr)
    <=> v2549(VarCurr) ) ).

fof(addAssignment_803,axiom,
    ! [VarCurr] :
      ( v2549(VarCurr)
    <=> v2551(VarCurr) ) ).

fof(addAssignment_802,axiom,
    ! [VarCurr] :
      ( v2551(VarCurr)
    <=> v1(VarCurr) ) ).

fof(addAssignment_801,axiom,
    ! [VarCurr] :
      ( v715(VarCurr,bitIndex1)
    <=> v2535(VarCurr,bitIndex1) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_8,axiom,
    ! [VarCurr] :
      ( ( ~ v2536(VarCurr)
        & ~ v2538(VarCurr)
        & ~ v2541(VarCurr) )
     => ! [B] :
          ( range_3_0(B)
         => ( v2535(VarCurr,B)
          <=> v707(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_13,axiom,
    ! [VarCurr] :
      ( v2541(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2535(VarCurr,B)
          <=> v2543(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_24,axiom,
    ! [VarCurr] :
      ( v2538(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2535(VarCurr,B)
          <=> v2540(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_21,axiom,
    ! [VarCurr] :
      ( v2536(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2535(VarCurr,B)
          <=> v707(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_160,axiom,
    ! [VarCurr] :
      ( v2544(VarCurr)
    <=> ( ( v2545(VarCurr,bitIndex1)
        <=> $true )
        & ( v2545(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_800,axiom,
    ! [VarCurr] :
      ( v2545(VarCurr,bitIndex0)
    <=> v2530(VarCurr) ) ).

fof(addAssignment_799,axiom,
    ! [VarCurr] :
      ( v2545(VarCurr,bitIndex1)
    <=> v717(VarCurr) ) ).

fof(addAssignment_798,axiom,
    ! [VarCurr] :
      ( v2543(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_797,axiom,
    ! [VarCurr] :
      ( ( v2543(VarCurr,bitIndex3)
      <=> v707(VarCurr,bitIndex2) )
      & ( v2543(VarCurr,bitIndex2)
      <=> v707(VarCurr,bitIndex1) )
      & ( v2543(VarCurr,bitIndex1)
      <=> v707(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_159,axiom,
    ! [VarCurr] :
      ( v2541(VarCurr)
    <=> ( ( v2542(VarCurr,bitIndex1)
        <=> $true )
        & ( v2542(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_796,axiom,
    ! [VarCurr] :
      ( v2542(VarCurr,bitIndex0)
    <=> v2530(VarCurr) ) ).

fof(addAssignment_795,axiom,
    ! [VarCurr] :
      ( v2542(VarCurr,bitIndex1)
    <=> v717(VarCurr) ) ).

fof(addAssignment_794,axiom,
    ! [VarCurr] :
      ( ( v2540(VarCurr,bitIndex2)
      <=> v707(VarCurr,bitIndex3) )
      & ( v2540(VarCurr,bitIndex1)
      <=> v707(VarCurr,bitIndex2) )
      & ( v2540(VarCurr,bitIndex0)
      <=> v707(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_793,axiom,
    ! [VarCurr] :
      ( v2540(VarCurr,bitIndex3)
    <=> $false ) ).

fof(addBitVectorEqualityBitBlasted_158,axiom,
    ! [VarCurr] :
      ( v2538(VarCurr)
    <=> ( ( v2539(VarCurr,bitIndex1)
        <=> $false )
        & ( v2539(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_792,axiom,
    ! [VarCurr] :
      ( v2539(VarCurr,bitIndex0)
    <=> v2530(VarCurr) ) ).

fof(addAssignment_791,axiom,
    ! [VarCurr] :
      ( v2539(VarCurr,bitIndex1)
    <=> v717(VarCurr) ) ).

fof(addAssignmentInitValueVector_29,axiom,
    ! [B] :
      ( range_3_0(B)
     => ( v707(constB0,B)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_157,axiom,
    ! [VarCurr] :
      ( v2536(VarCurr)
    <=> ( ( v2537(VarCurr,bitIndex1)
        <=> $false )
        & ( v2537(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_790,axiom,
    ! [VarCurr] :
      ( v2537(VarCurr,bitIndex0)
    <=> v2530(VarCurr) ) ).

fof(addAssignment_789,axiom,
    ! [VarCurr] :
      ( v2537(VarCurr,bitIndex1)
    <=> v717(VarCurr) ) ).

fof(addAssignment_788,axiom,
    ! [VarCurr] :
      ( v717(VarCurr)
    <=> v719(VarCurr) ) ).

fof(addAssignment_787,axiom,
    ! [VarCurr] :
      ( v719(VarCurr)
    <=> v721(VarCurr) ) ).

fof(addAssignment_786,axiom,
    ! [VarCurr] :
      ( v721(VarCurr)
    <=> v723(VarCurr) ) ).

fof(addAssignment_785,axiom,
    ! [VarCurr] :
      ( v723(VarCurr)
    <=> v725(VarCurr) ) ).

fof(addAssignment_784,axiom,
    ! [VarCurr] :
      ( v725(VarCurr)
    <=> v727(VarCurr) ) ).

fof(addAssignment_783,axiom,
    ! [VarCurr] :
      ( v727(VarCurr)
    <=> v729(VarCurr) ) ).

fof(addAssignment_782,axiom,
    ! [VarCurr] :
      ( v729(VarCurr)
    <=> v731(VarCurr) ) ).

fof(addAssignment_781,axiom,
    ! [VarCurr] :
      ( v731(VarCurr)
    <=> v733(VarCurr) ) ).

fof(addAssignment_780,axiom,
    ! [VarCurr] :
      ( v733(VarCurr)
    <=> v735(VarCurr) ) ).

fof(addAssignment_779,axiom,
    ! [VarCurr] :
      ( v735(VarCurr)
    <=> v737(VarCurr) ) ).

fof(addAssignment_778,axiom,
    ! [VarCurr] :
      ( v737(VarCurr)
    <=> v739(VarCurr) ) ).

fof(addAssignment_777,axiom,
    ! [VarCurr] :
      ( v739(VarCurr)
    <=> v741(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_26,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2517(VarNext)
       => ( v741(VarNext)
        <=> v741(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_30,axiom,
    ! [VarNext] :
      ( v2517(VarNext)
     => ( v741(VarNext)
      <=> v2525(VarNext) ) ) ).

fof(addAssignment_776,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2525(VarNext)
      <=> v2523(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_74,axiom,
    ! [VarCurr] :
      ( ~ v2526(VarCurr)
     => ( v2523(VarCurr)
      <=> v745(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_105,axiom,
    ! [VarCurr] :
      ( v2526(VarCurr)
     => ( v2523(VarCurr)
      <=> $false ) ) ).

fof(writeUnaryOperator_146,axiom,
    ! [VarCurr] :
      ( ~ v2526(VarCurr)
    <=> v743(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_323,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2517(VarNext)
      <=> v2518(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_322,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2518(VarNext)
      <=> ( v2519(VarNext)
          & v801(VarNext) ) ) ) ).

fof(writeUnaryOperator_145,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2519(VarNext)
      <=> v812(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_23,axiom,
    ! [VarCurr] :
      ( ~ v2514(VarCurr)
     => ( v745(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_20,axiom,
    ! [VarCurr] :
      ( v2514(VarCurr)
     => ( v745(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_321,axiom,
    ! [VarCurr] :
      ( v2514(VarCurr)
    <=> ( v1210(VarCurr)
        | v1214(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_320,axiom,
    ! [VarCurr] :
      ( v1173(VarCurr)
    <=> ( v2511(VarCurr)
        & v2512(VarCurr) ) ) ).

fof(writeUnaryOperator_144,axiom,
    ! [VarCurr] :
      ( ~ v2512(VarCurr)
    <=> v2446(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_156,axiom,
    ! [VarCurr] :
      ( v2511(VarCurr)
    <=> ( ( v749(VarCurr,bitIndex7)
        <=> v1175(VarCurr,bitIndex7) )
        & ( v749(VarCurr,bitIndex6)
        <=> v1175(VarCurr,bitIndex6) )
        & ( v749(VarCurr,bitIndex5)
        <=> v1175(VarCurr,bitIndex5) )
        & ( v749(VarCurr,bitIndex4)
        <=> v1175(VarCurr,bitIndex4) )
        & ( v749(VarCurr,bitIndex3)
        <=> v1175(VarCurr,bitIndex3) )
        & ( v749(VarCurr,bitIndex2)
        <=> v1175(VarCurr,bitIndex2) )
        & ( v749(VarCurr,bitIndex1)
        <=> v1175(VarCurr,bitIndex1) )
        & ( v749(VarCurr,bitIndex0)
        <=> v1175(VarCurr,bitIndex0) ) ) ) ).

fof(addAssignment_775,axiom,
    ! [VarCurr] :
      ( v2446(VarCurr)
    <=> v2448(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_25,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2488(VarNext)
       => ( v2448(VarNext)
        <=> v2448(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_29,axiom,
    ! [VarNext] :
      ( v2488(VarNext)
     => ( v2448(VarNext)
      <=> v2506(VarNext) ) ) ).

fof(addAssignment_774,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2506(VarNext)
      <=> v2504(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_73,axiom,
    ! [VarCurr] :
      ( ~ v2503(VarCurr)
     => ( v2504(VarCurr)
      <=> v2507(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_104,axiom,
    ! [VarCurr] :
      ( v2503(VarCurr)
     => ( v2504(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_72,axiom,
    ! [VarCurr] :
      ( ~ v1185(VarCurr)
     => ( v2507(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_103,axiom,
    ! [VarCurr] :
      ( v1185(VarCurr)
     => ( v2507(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_319,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2488(VarNext)
      <=> ( v2489(VarNext)
          & v2496(VarNext) ) ) ) ).

fof(addAssignment_773,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2496(VarNext)
      <=> v2494(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_318,axiom,
    ! [VarCurr] :
      ( v2494(VarCurr)
    <=> ( v2497(VarCurr)
        | v2503(VarCurr) ) ) ).

fof(writeUnaryOperator_143,axiom,
    ! [VarCurr] :
      ( ~ v2503(VarCurr)
    <=> v1183(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_317,axiom,
    ! [VarCurr] :
      ( v2497(VarCurr)
    <=> ( v2498(VarCurr)
        | v1185(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_316,axiom,
    ! [VarCurr] :
      ( v2498(VarCurr)
    <=> ( v2499(VarCurr)
        & v2502(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_155,axiom,
    ! [VarCurr] :
      ( v2502(VarCurr)
    <=> ( v2072(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_315,axiom,
    ! [VarCurr] :
      ( v2499(VarCurr)
    <=> ( v2500(VarCurr)
        & v2501(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_154,axiom,
    ! [VarCurr] :
      ( v2501(VarCurr)
    <=> ( v2450(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_153,axiom,
    ! [VarCurr] :
      ( v2500(VarCurr)
    <=> ( v2064(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_314,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2489(VarNext)
      <=> ( v2490(VarNext)
          & v2077(VarNext) ) ) ) ).

fof(writeUnaryOperator_142,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2490(VarNext)
      <=> v2086(VarNext) ) ) ).

fof(addAssignment_772,axiom,
    ! [VarCurr] :
      ( v2072(VarCurr,bitIndex0)
    <=> v2096(VarCurr,bitIndex0) ) ).

fof(addAssignment_771,axiom,
    ! [VarNext] :
      ( v2450(VarNext,bitIndex1)
    <=> v2474(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_24,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2475(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v2474(VarNext,B)
            <=> v2450(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_28,axiom,
    ! [VarNext] :
      ( v2475(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v2474(VarNext,B)
          <=> v2483(VarNext,B) ) ) ) ).

fof(addAssignment_770,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v2483(VarNext,B)
          <=> v2481(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_71,axiom,
    ! [VarCurr] :
      ( ~ v2093(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2481(VarCurr,B)
          <=> v2452(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_102,axiom,
    ! [VarCurr] :
      ( v2093(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2481(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_313,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2475(VarNext)
      <=> v2476(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_312,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2476(VarNext)
      <=> ( v2478(VarNext)
          & v2077(VarNext) ) ) ) ).

fof(writeUnaryOperator_141,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2478(VarNext)
      <=> v2086(VarNext) ) ) ).

fof(addAssignment_769,axiom,
    ! [VarCurr] :
      ( v2452(VarCurr,bitIndex1)
    <=> v2459(VarCurr,bitIndex1) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_70,axiom,
    ! [VarCurr] :
      ( ~ v2460(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2459(VarCurr,B)
          <=> v2461(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_101,axiom,
    ! [VarCurr] :
      ( v2460(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2459(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_7,axiom,
    ! [VarCurr] :
      ( ( ~ v2462(VarCurr)
        & ~ v2464(VarCurr)
        & ~ v2468(VarCurr) )
     => ! [B] :
          ( range_3_0(B)
         => ( v2461(VarCurr,B)
          <=> v2450(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_12,axiom,
    ! [VarCurr] :
      ( v2468(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2461(VarCurr,B)
          <=> v2470(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_22,axiom,
    ! [VarCurr] :
      ( v2464(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2461(VarCurr,B)
          <=> v2466(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_19,axiom,
    ! [VarCurr] :
      ( v2462(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2461(VarCurr,B)
          <=> v2450(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_152,axiom,
    ! [VarCurr] :
      ( v2471(VarCurr)
    <=> ( ( v2472(VarCurr,bitIndex1)
        <=> $true )
        & ( v2472(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_768,axiom,
    ! [VarCurr] :
      ( v2472(VarCurr,bitIndex0)
    <=> v2064(VarCurr) ) ).

fof(addAssignment_767,axiom,
    ! [VarCurr] :
      ( v2472(VarCurr,bitIndex1)
    <=> v1185(VarCurr) ) ).

fof(addAssignment_766,axiom,
    ! [VarCurr] :
      ( v2470(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_765,axiom,
    ! [VarCurr,B] :
      ( range_3_1(B)
     => ( v2470(VarCurr,B)
      <=> v2454(VarCurr,B) ) ) ).

fof(range_axiom_24,axiom,
    ! [B] :
      ( range_3_1(B)
    <=> ( $false
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B ) ) ).

fof(addBitVectorEqualityBitBlasted_151,axiom,
    ! [VarCurr] :
      ( v2468(VarCurr)
    <=> ( ( v2469(VarCurr,bitIndex1)
        <=> $true )
        & ( v2469(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_764,axiom,
    ! [VarCurr] :
      ( v2469(VarCurr,bitIndex0)
    <=> v2064(VarCurr) ) ).

fof(addAssignment_763,axiom,
    ! [VarCurr] :
      ( v2469(VarCurr,bitIndex1)
    <=> v1185(VarCurr) ) ).

fof(addAssignment_762,axiom,
    ! [VarCurr] :
      ( ( v2466(VarCurr,bitIndex2)
      <=> v2450(VarCurr,bitIndex3) )
      & ( v2466(VarCurr,bitIndex1)
      <=> v2450(VarCurr,bitIndex2) )
      & ( v2466(VarCurr,bitIndex0)
      <=> v2450(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_761,axiom,
    ! [VarCurr] :
      ( v2466(VarCurr,bitIndex3)
    <=> $false ) ).

fof(addBitVectorEqualityBitBlasted_150,axiom,
    ! [VarCurr] :
      ( v2464(VarCurr)
    <=> ( ( v2465(VarCurr,bitIndex1)
        <=> $false )
        & ( v2465(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_760,axiom,
    ! [VarCurr] :
      ( v2465(VarCurr,bitIndex0)
    <=> v2064(VarCurr) ) ).

fof(addAssignment_759,axiom,
    ! [VarCurr] :
      ( v2465(VarCurr,bitIndex1)
    <=> v1185(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_149,axiom,
    ! [VarCurr] :
      ( v2462(VarCurr)
    <=> ( ( v2463(VarCurr,bitIndex1)
        <=> $false )
        & ( v2463(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_758,axiom,
    ! [VarCurr] :
      ( v2463(VarCurr,bitIndex0)
    <=> v2064(VarCurr) ) ).

fof(addAssignment_757,axiom,
    ! [VarCurr] :
      ( v2463(VarCurr,bitIndex1)
    <=> v1185(VarCurr) ) ).

fof(writeUnaryOperator_140,axiom,
    ! [VarCurr] :
      ( ~ v2460(VarCurr)
    <=> v1183(VarCurr) ) ).

fof(addAssignment_756,axiom,
    ! [VarCurr] :
      ( v2454(VarCurr,bitIndex1)
    <=> v2455(VarCurr,bitIndex1) ) ).

fof(addAssignment_755,axiom,
    ! [VarCurr] :
      ( v2455(VarCurr,bitIndex0)
    <=> $false ) ).

fof(addAssignment_754,axiom,
    ! [VarCurr] :
      ( ( v2455(VarCurr,bitIndex3)
      <=> v2450(VarCurr,bitIndex2) )
      & ( v2455(VarCurr,bitIndex2)
      <=> v2450(VarCurr,bitIndex1) )
      & ( v2455(VarCurr,bitIndex1)
      <=> v2450(VarCurr,bitIndex0) ) ) ).

fof(addAssignmentInitValue_192,axiom,
    ~ v2450(constB0,bitIndex2) ).

fof(addAssignmentInitValue_191,axiom,
    ~ v2450(constB0,bitIndex1) ).

fof(addAssignmentInitValue_190,axiom,
    ~ v2450(constB0,bitIndex0) ).

fof(bitBlastConstant_744,axiom,
    ~ bx000(bitIndex2) ).

fof(bitBlastConstant_743,axiom,
    ~ bx000(bitIndex1) ).

fof(bitBlastConstant_742,axiom,
    ~ bx000(bitIndex0) ).

fof(addAssignment_753,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v1175(VarCurr,B)
      <=> v1177(VarCurr,B) ) ) ).

fof(addAssignment_752,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v1177(VarCurr,B)
      <=> v1179(VarCurr,B) ) ) ).

fof(addAssignment_751,axiom,
    ! [VarCurr] :
      ( ( v1179(VarCurr,bitIndex7)
      <=> v1181(VarCurr,bitIndex400) )
      & ( v1179(VarCurr,bitIndex6)
      <=> v1181(VarCurr,bitIndex399) )
      & ( v1179(VarCurr,bitIndex5)
      <=> v1181(VarCurr,bitIndex398) )
      & ( v1179(VarCurr,bitIndex4)
      <=> v1181(VarCurr,bitIndex397) )
      & ( v1179(VarCurr,bitIndex3)
      <=> v1181(VarCurr,bitIndex396) )
      & ( v1179(VarCurr,bitIndex2)
      <=> v1181(VarCurr,bitIndex395) )
      & ( v1179(VarCurr,bitIndex1)
      <=> v1181(VarCurr,bitIndex394) )
      & ( v1179(VarCurr,bitIndex0)
      <=> v1181(VarCurr,bitIndex393) ) ) ).

fof(addAssignment_750,axiom,
    ! [VarNext] :
      ( ( v1181(VarNext,bitIndex400)
      <=> v2414(VarNext,bitIndex7) )
      & ( v1181(VarNext,bitIndex399)
      <=> v2414(VarNext,bitIndex6) )
      & ( v1181(VarNext,bitIndex398)
      <=> v2414(VarNext,bitIndex5) )
      & ( v1181(VarNext,bitIndex397)
      <=> v2414(VarNext,bitIndex4) )
      & ( v1181(VarNext,bitIndex396)
      <=> v2414(VarNext,bitIndex3) )
      & ( v1181(VarNext,bitIndex395)
      <=> v2414(VarNext,bitIndex2) )
      & ( v1181(VarNext,bitIndex394)
      <=> v2414(VarNext,bitIndex1) )
      & ( v1181(VarNext,bitIndex393)
      <=> v2414(VarNext,bitIndex0) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_3,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2415(VarNext)
       => ( ( v2414(VarNext,bitIndex130)
          <=> v1181(VarCurr,bitIndex523) )
          & ( v2414(VarNext,bitIndex129)
          <=> v1181(VarCurr,bitIndex522) )
          & ( v2414(VarNext,bitIndex128)
          <=> v1181(VarCurr,bitIndex521) )
          & ( v2414(VarNext,bitIndex127)
          <=> v1181(VarCurr,bitIndex520) )
          & ( v2414(VarNext,bitIndex126)
          <=> v1181(VarCurr,bitIndex519) )
          & ( v2414(VarNext,bitIndex125)
          <=> v1181(VarCurr,bitIndex518) )
          & ( v2414(VarNext,bitIndex124)
          <=> v1181(VarCurr,bitIndex517) )
          & ( v2414(VarNext,bitIndex123)
          <=> v1181(VarCurr,bitIndex516) )
          & ( v2414(VarNext,bitIndex122)
          <=> v1181(VarCurr,bitIndex515) )
          & ( v2414(VarNext,bitIndex121)
          <=> v1181(VarCurr,bitIndex514) )
          & ( v2414(VarNext,bitIndex120)
          <=> v1181(VarCurr,bitIndex513) )
          & ( v2414(VarNext,bitIndex119)
          <=> v1181(VarCurr,bitIndex512) )
          & ( v2414(VarNext,bitIndex118)
          <=> v1181(VarCurr,bitIndex511) )
          & ( v2414(VarNext,bitIndex117)
          <=> v1181(VarCurr,bitIndex510) )
          & ( v2414(VarNext,bitIndex116)
          <=> v1181(VarCurr,bitIndex509) )
          & ( v2414(VarNext,bitIndex115)
          <=> v1181(VarCurr,bitIndex508) )
          & ( v2414(VarNext,bitIndex114)
          <=> v1181(VarCurr,bitIndex507) )
          & ( v2414(VarNext,bitIndex113)
          <=> v1181(VarCurr,bitIndex506) )
          & ( v2414(VarNext,bitIndex112)
          <=> v1181(VarCurr,bitIndex505) )
          & ( v2414(VarNext,bitIndex111)
          <=> v1181(VarCurr,bitIndex504) )
          & ( v2414(VarNext,bitIndex110)
          <=> v1181(VarCurr,bitIndex503) )
          & ( v2414(VarNext,bitIndex109)
          <=> v1181(VarCurr,bitIndex502) )
          & ( v2414(VarNext,bitIndex108)
          <=> v1181(VarCurr,bitIndex501) )
          & ( v2414(VarNext,bitIndex107)
          <=> v1181(VarCurr,bitIndex500) )
          & ( v2414(VarNext,bitIndex106)
          <=> v1181(VarCurr,bitIndex499) )
          & ( v2414(VarNext,bitIndex105)
          <=> v1181(VarCurr,bitIndex498) )
          & ( v2414(VarNext,bitIndex104)
          <=> v1181(VarCurr,bitIndex497) )
          & ( v2414(VarNext,bitIndex103)
          <=> v1181(VarCurr,bitIndex496) )
          & ( v2414(VarNext,bitIndex102)
          <=> v1181(VarCurr,bitIndex495) )
          & ( v2414(VarNext,bitIndex101)
          <=> v1181(VarCurr,bitIndex494) )
          & ( v2414(VarNext,bitIndex100)
          <=> v1181(VarCurr,bitIndex493) )
          & ( v2414(VarNext,bitIndex99)
          <=> v1181(VarCurr,bitIndex492) )
          & ( v2414(VarNext,bitIndex98)
          <=> v1181(VarCurr,bitIndex491) )
          & ( v2414(VarNext,bitIndex97)
          <=> v1181(VarCurr,bitIndex490) )
          & ( v2414(VarNext,bitIndex96)
          <=> v1181(VarCurr,bitIndex489) )
          & ( v2414(VarNext,bitIndex95)
          <=> v1181(VarCurr,bitIndex488) )
          & ( v2414(VarNext,bitIndex94)
          <=> v1181(VarCurr,bitIndex487) )
          & ( v2414(VarNext,bitIndex93)
          <=> v1181(VarCurr,bitIndex486) )
          & ( v2414(VarNext,bitIndex92)
          <=> v1181(VarCurr,bitIndex485) )
          & ( v2414(VarNext,bitIndex91)
          <=> v1181(VarCurr,bitIndex484) )
          & ( v2414(VarNext,bitIndex90)
          <=> v1181(VarCurr,bitIndex483) )
          & ( v2414(VarNext,bitIndex89)
          <=> v1181(VarCurr,bitIndex482) )
          & ( v2414(VarNext,bitIndex88)
          <=> v1181(VarCurr,bitIndex481) )
          & ( v2414(VarNext,bitIndex87)
          <=> v1181(VarCurr,bitIndex480) )
          & ( v2414(VarNext,bitIndex86)
          <=> v1181(VarCurr,bitIndex479) )
          & ( v2414(VarNext,bitIndex85)
          <=> v1181(VarCurr,bitIndex478) )
          & ( v2414(VarNext,bitIndex84)
          <=> v1181(VarCurr,bitIndex477) )
          & ( v2414(VarNext,bitIndex83)
          <=> v1181(VarCurr,bitIndex476) )
          & ( v2414(VarNext,bitIndex82)
          <=> v1181(VarCurr,bitIndex475) )
          & ( v2414(VarNext,bitIndex81)
          <=> v1181(VarCurr,bitIndex474) )
          & ( v2414(VarNext,bitIndex80)
          <=> v1181(VarCurr,bitIndex473) )
          & ( v2414(VarNext,bitIndex79)
          <=> v1181(VarCurr,bitIndex472) )
          & ( v2414(VarNext,bitIndex78)
          <=> v1181(VarCurr,bitIndex471) )
          & ( v2414(VarNext,bitIndex77)
          <=> v1181(VarCurr,bitIndex470) )
          & ( v2414(VarNext,bitIndex76)
          <=> v1181(VarCurr,bitIndex469) )
          & ( v2414(VarNext,bitIndex75)
          <=> v1181(VarCurr,bitIndex468) )
          & ( v2414(VarNext,bitIndex74)
          <=> v1181(VarCurr,bitIndex467) )
          & ( v2414(VarNext,bitIndex73)
          <=> v1181(VarCurr,bitIndex466) )
          & ( v2414(VarNext,bitIndex72)
          <=> v1181(VarCurr,bitIndex465) )
          & ( v2414(VarNext,bitIndex71)
          <=> v1181(VarCurr,bitIndex464) )
          & ( v2414(VarNext,bitIndex70)
          <=> v1181(VarCurr,bitIndex463) )
          & ( v2414(VarNext,bitIndex69)
          <=> v1181(VarCurr,bitIndex462) )
          & ( v2414(VarNext,bitIndex68)
          <=> v1181(VarCurr,bitIndex461) )
          & ( v2414(VarNext,bitIndex67)
          <=> v1181(VarCurr,bitIndex460) )
          & ( v2414(VarNext,bitIndex66)
          <=> v1181(VarCurr,bitIndex459) )
          & ( v2414(VarNext,bitIndex65)
          <=> v1181(VarCurr,bitIndex458) )
          & ( v2414(VarNext,bitIndex64)
          <=> v1181(VarCurr,bitIndex457) )
          & ( v2414(VarNext,bitIndex63)
          <=> v1181(VarCurr,bitIndex456) )
          & ( v2414(VarNext,bitIndex62)
          <=> v1181(VarCurr,bitIndex455) )
          & ( v2414(VarNext,bitIndex61)
          <=> v1181(VarCurr,bitIndex454) )
          & ( v2414(VarNext,bitIndex60)
          <=> v1181(VarCurr,bitIndex453) )
          & ( v2414(VarNext,bitIndex59)
          <=> v1181(VarCurr,bitIndex452) )
          & ( v2414(VarNext,bitIndex58)
          <=> v1181(VarCurr,bitIndex451) )
          & ( v2414(VarNext,bitIndex57)
          <=> v1181(VarCurr,bitIndex450) )
          & ( v2414(VarNext,bitIndex56)
          <=> v1181(VarCurr,bitIndex449) )
          & ( v2414(VarNext,bitIndex55)
          <=> v1181(VarCurr,bitIndex448) )
          & ( v2414(VarNext,bitIndex54)
          <=> v1181(VarCurr,bitIndex447) )
          & ( v2414(VarNext,bitIndex53)
          <=> v1181(VarCurr,bitIndex446) )
          & ( v2414(VarNext,bitIndex52)
          <=> v1181(VarCurr,bitIndex445) )
          & ( v2414(VarNext,bitIndex51)
          <=> v1181(VarCurr,bitIndex444) )
          & ( v2414(VarNext,bitIndex50)
          <=> v1181(VarCurr,bitIndex443) )
          & ( v2414(VarNext,bitIndex49)
          <=> v1181(VarCurr,bitIndex442) )
          & ( v2414(VarNext,bitIndex48)
          <=> v1181(VarCurr,bitIndex441) )
          & ( v2414(VarNext,bitIndex47)
          <=> v1181(VarCurr,bitIndex440) )
          & ( v2414(VarNext,bitIndex46)
          <=> v1181(VarCurr,bitIndex439) )
          & ( v2414(VarNext,bitIndex45)
          <=> v1181(VarCurr,bitIndex438) )
          & ( v2414(VarNext,bitIndex44)
          <=> v1181(VarCurr,bitIndex437) )
          & ( v2414(VarNext,bitIndex43)
          <=> v1181(VarCurr,bitIndex436) )
          & ( v2414(VarNext,bitIndex42)
          <=> v1181(VarCurr,bitIndex435) )
          & ( v2414(VarNext,bitIndex41)
          <=> v1181(VarCurr,bitIndex434) )
          & ( v2414(VarNext,bitIndex40)
          <=> v1181(VarCurr,bitIndex433) )
          & ( v2414(VarNext,bitIndex39)
          <=> v1181(VarCurr,bitIndex432) )
          & ( v2414(VarNext,bitIndex38)
          <=> v1181(VarCurr,bitIndex431) )
          & ( v2414(VarNext,bitIndex37)
          <=> v1181(VarCurr,bitIndex430) )
          & ( v2414(VarNext,bitIndex36)
          <=> v1181(VarCurr,bitIndex429) )
          & ( v2414(VarNext,bitIndex35)
          <=> v1181(VarCurr,bitIndex428) )
          & ( v2414(VarNext,bitIndex34)
          <=> v1181(VarCurr,bitIndex427) )
          & ( v2414(VarNext,bitIndex33)
          <=> v1181(VarCurr,bitIndex426) )
          & ( v2414(VarNext,bitIndex32)
          <=> v1181(VarCurr,bitIndex425) )
          & ( v2414(VarNext,bitIndex31)
          <=> v1181(VarCurr,bitIndex424) )
          & ( v2414(VarNext,bitIndex30)
          <=> v1181(VarCurr,bitIndex423) )
          & ( v2414(VarNext,bitIndex29)
          <=> v1181(VarCurr,bitIndex422) )
          & ( v2414(VarNext,bitIndex28)
          <=> v1181(VarCurr,bitIndex421) )
          & ( v2414(VarNext,bitIndex27)
          <=> v1181(VarCurr,bitIndex420) )
          & ( v2414(VarNext,bitIndex26)
          <=> v1181(VarCurr,bitIndex419) )
          & ( v2414(VarNext,bitIndex25)
          <=> v1181(VarCurr,bitIndex418) )
          & ( v2414(VarNext,bitIndex24)
          <=> v1181(VarCurr,bitIndex417) )
          & ( v2414(VarNext,bitIndex23)
          <=> v1181(VarCurr,bitIndex416) )
          & ( v2414(VarNext,bitIndex22)
          <=> v1181(VarCurr,bitIndex415) )
          & ( v2414(VarNext,bitIndex21)
          <=> v1181(VarCurr,bitIndex414) )
          & ( v2414(VarNext,bitIndex20)
          <=> v1181(VarCurr,bitIndex413) )
          & ( v2414(VarNext,bitIndex19)
          <=> v1181(VarCurr,bitIndex412) )
          & ( v2414(VarNext,bitIndex18)
          <=> v1181(VarCurr,bitIndex411) )
          & ( v2414(VarNext,bitIndex17)
          <=> v1181(VarCurr,bitIndex410) )
          & ( v2414(VarNext,bitIndex16)
          <=> v1181(VarCurr,bitIndex409) )
          & ( v2414(VarNext,bitIndex15)
          <=> v1181(VarCurr,bitIndex408) )
          & ( v2414(VarNext,bitIndex14)
          <=> v1181(VarCurr,bitIndex407) )
          & ( v2414(VarNext,bitIndex13)
          <=> v1181(VarCurr,bitIndex406) )
          & ( v2414(VarNext,bitIndex12)
          <=> v1181(VarCurr,bitIndex405) )
          & ( v2414(VarNext,bitIndex11)
          <=> v1181(VarCurr,bitIndex404) )
          & ( v2414(VarNext,bitIndex10)
          <=> v1181(VarCurr,bitIndex403) )
          & ( v2414(VarNext,bitIndex9)
          <=> v1181(VarCurr,bitIndex402) )
          & ( v2414(VarNext,bitIndex8)
          <=> v1181(VarCurr,bitIndex401) )
          & ( v2414(VarNext,bitIndex7)
          <=> v1181(VarCurr,bitIndex400) )
          & ( v2414(VarNext,bitIndex6)
          <=> v1181(VarCurr,bitIndex399) )
          & ( v2414(VarNext,bitIndex5)
          <=> v1181(VarCurr,bitIndex398) )
          & ( v2414(VarNext,bitIndex4)
          <=> v1181(VarCurr,bitIndex397) )
          & ( v2414(VarNext,bitIndex3)
          <=> v1181(VarCurr,bitIndex396) )
          & ( v2414(VarNext,bitIndex2)
          <=> v1181(VarCurr,bitIndex395) )
          & ( v2414(VarNext,bitIndex1)
          <=> v1181(VarCurr,bitIndex394) )
          & ( v2414(VarNext,bitIndex0)
          <=> v1181(VarCurr,bitIndex393) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_27,axiom,
    ! [VarNext] :
      ( v2415(VarNext)
     => ! [B] :
          ( range_130_0(B)
         => ( v2414(VarNext,B)
          <=> v2441(VarNext,B) ) ) ) ).

fof(addAssignment_749,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_130_0(B)
         => ( v2441(VarNext,B)
          <=> v2439(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_21,axiom,
    ! [VarCurr] :
      ( ~ v2378(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v2439(VarCurr,B)
          <=> v2442(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_18,axiom,
    ! [VarCurr] :
      ( v2378(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v2439(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_11,axiom,
    ! [VarCurr] :
      ( ( ~ v2428(VarCurr)
        & ~ v2430(VarCurr) )
     => ! [B] :
          ( range_130_0(B)
         => ( v2442(VarCurr,B)
          <=> v2407(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_20,axiom,
    ! [VarCurr] :
      ( v2430(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v2442(VarCurr,B)
          <=> v2400(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_2,axiom,
    ! [VarCurr] :
      ( v2428(VarCurr)
     => ( ( v2442(VarCurr,bitIndex130)
        <=> v1181(VarCurr,bitIndex392) )
        & ( v2442(VarCurr,bitIndex129)
        <=> v1181(VarCurr,bitIndex391) )
        & ( v2442(VarCurr,bitIndex128)
        <=> v1181(VarCurr,bitIndex390) )
        & ( v2442(VarCurr,bitIndex127)
        <=> v1181(VarCurr,bitIndex389) )
        & ( v2442(VarCurr,bitIndex126)
        <=> v1181(VarCurr,bitIndex388) )
        & ( v2442(VarCurr,bitIndex125)
        <=> v1181(VarCurr,bitIndex387) )
        & ( v2442(VarCurr,bitIndex124)
        <=> v1181(VarCurr,bitIndex386) )
        & ( v2442(VarCurr,bitIndex123)
        <=> v1181(VarCurr,bitIndex385) )
        & ( v2442(VarCurr,bitIndex122)
        <=> v1181(VarCurr,bitIndex384) )
        & ( v2442(VarCurr,bitIndex121)
        <=> v1181(VarCurr,bitIndex383) )
        & ( v2442(VarCurr,bitIndex120)
        <=> v1181(VarCurr,bitIndex382) )
        & ( v2442(VarCurr,bitIndex119)
        <=> v1181(VarCurr,bitIndex381) )
        & ( v2442(VarCurr,bitIndex118)
        <=> v1181(VarCurr,bitIndex380) )
        & ( v2442(VarCurr,bitIndex117)
        <=> v1181(VarCurr,bitIndex379) )
        & ( v2442(VarCurr,bitIndex116)
        <=> v1181(VarCurr,bitIndex378) )
        & ( v2442(VarCurr,bitIndex115)
        <=> v1181(VarCurr,bitIndex377) )
        & ( v2442(VarCurr,bitIndex114)
        <=> v1181(VarCurr,bitIndex376) )
        & ( v2442(VarCurr,bitIndex113)
        <=> v1181(VarCurr,bitIndex375) )
        & ( v2442(VarCurr,bitIndex112)
        <=> v1181(VarCurr,bitIndex374) )
        & ( v2442(VarCurr,bitIndex111)
        <=> v1181(VarCurr,bitIndex373) )
        & ( v2442(VarCurr,bitIndex110)
        <=> v1181(VarCurr,bitIndex372) )
        & ( v2442(VarCurr,bitIndex109)
        <=> v1181(VarCurr,bitIndex371) )
        & ( v2442(VarCurr,bitIndex108)
        <=> v1181(VarCurr,bitIndex370) )
        & ( v2442(VarCurr,bitIndex107)
        <=> v1181(VarCurr,bitIndex369) )
        & ( v2442(VarCurr,bitIndex106)
        <=> v1181(VarCurr,bitIndex368) )
        & ( v2442(VarCurr,bitIndex105)
        <=> v1181(VarCurr,bitIndex367) )
        & ( v2442(VarCurr,bitIndex104)
        <=> v1181(VarCurr,bitIndex366) )
        & ( v2442(VarCurr,bitIndex103)
        <=> v1181(VarCurr,bitIndex365) )
        & ( v2442(VarCurr,bitIndex102)
        <=> v1181(VarCurr,bitIndex364) )
        & ( v2442(VarCurr,bitIndex101)
        <=> v1181(VarCurr,bitIndex363) )
        & ( v2442(VarCurr,bitIndex100)
        <=> v1181(VarCurr,bitIndex362) )
        & ( v2442(VarCurr,bitIndex99)
        <=> v1181(VarCurr,bitIndex361) )
        & ( v2442(VarCurr,bitIndex98)
        <=> v1181(VarCurr,bitIndex360) )
        & ( v2442(VarCurr,bitIndex97)
        <=> v1181(VarCurr,bitIndex359) )
        & ( v2442(VarCurr,bitIndex96)
        <=> v1181(VarCurr,bitIndex358) )
        & ( v2442(VarCurr,bitIndex95)
        <=> v1181(VarCurr,bitIndex357) )
        & ( v2442(VarCurr,bitIndex94)
        <=> v1181(VarCurr,bitIndex356) )
        & ( v2442(VarCurr,bitIndex93)
        <=> v1181(VarCurr,bitIndex355) )
        & ( v2442(VarCurr,bitIndex92)
        <=> v1181(VarCurr,bitIndex354) )
        & ( v2442(VarCurr,bitIndex91)
        <=> v1181(VarCurr,bitIndex353) )
        & ( v2442(VarCurr,bitIndex90)
        <=> v1181(VarCurr,bitIndex352) )
        & ( v2442(VarCurr,bitIndex89)
        <=> v1181(VarCurr,bitIndex351) )
        & ( v2442(VarCurr,bitIndex88)
        <=> v1181(VarCurr,bitIndex350) )
        & ( v2442(VarCurr,bitIndex87)
        <=> v1181(VarCurr,bitIndex349) )
        & ( v2442(VarCurr,bitIndex86)
        <=> v1181(VarCurr,bitIndex348) )
        & ( v2442(VarCurr,bitIndex85)
        <=> v1181(VarCurr,bitIndex347) )
        & ( v2442(VarCurr,bitIndex84)
        <=> v1181(VarCurr,bitIndex346) )
        & ( v2442(VarCurr,bitIndex83)
        <=> v1181(VarCurr,bitIndex345) )
        & ( v2442(VarCurr,bitIndex82)
        <=> v1181(VarCurr,bitIndex344) )
        & ( v2442(VarCurr,bitIndex81)
        <=> v1181(VarCurr,bitIndex343) )
        & ( v2442(VarCurr,bitIndex80)
        <=> v1181(VarCurr,bitIndex342) )
        & ( v2442(VarCurr,bitIndex79)
        <=> v1181(VarCurr,bitIndex341) )
        & ( v2442(VarCurr,bitIndex78)
        <=> v1181(VarCurr,bitIndex340) )
        & ( v2442(VarCurr,bitIndex77)
        <=> v1181(VarCurr,bitIndex339) )
        & ( v2442(VarCurr,bitIndex76)
        <=> v1181(VarCurr,bitIndex338) )
        & ( v2442(VarCurr,bitIndex75)
        <=> v1181(VarCurr,bitIndex337) )
        & ( v2442(VarCurr,bitIndex74)
        <=> v1181(VarCurr,bitIndex336) )
        & ( v2442(VarCurr,bitIndex73)
        <=> v1181(VarCurr,bitIndex335) )
        & ( v2442(VarCurr,bitIndex72)
        <=> v1181(VarCurr,bitIndex334) )
        & ( v2442(VarCurr,bitIndex71)
        <=> v1181(VarCurr,bitIndex333) )
        & ( v2442(VarCurr,bitIndex70)
        <=> v1181(VarCurr,bitIndex332) )
        & ( v2442(VarCurr,bitIndex69)
        <=> v1181(VarCurr,bitIndex331) )
        & ( v2442(VarCurr,bitIndex68)
        <=> v1181(VarCurr,bitIndex330) )
        & ( v2442(VarCurr,bitIndex67)
        <=> v1181(VarCurr,bitIndex329) )
        & ( v2442(VarCurr,bitIndex66)
        <=> v1181(VarCurr,bitIndex328) )
        & ( v2442(VarCurr,bitIndex65)
        <=> v1181(VarCurr,bitIndex327) )
        & ( v2442(VarCurr,bitIndex64)
        <=> v1181(VarCurr,bitIndex326) )
        & ( v2442(VarCurr,bitIndex63)
        <=> v1181(VarCurr,bitIndex325) )
        & ( v2442(VarCurr,bitIndex62)
        <=> v1181(VarCurr,bitIndex324) )
        & ( v2442(VarCurr,bitIndex61)
        <=> v1181(VarCurr,bitIndex323) )
        & ( v2442(VarCurr,bitIndex60)
        <=> v1181(VarCurr,bitIndex322) )
        & ( v2442(VarCurr,bitIndex59)
        <=> v1181(VarCurr,bitIndex321) )
        & ( v2442(VarCurr,bitIndex58)
        <=> v1181(VarCurr,bitIndex320) )
        & ( v2442(VarCurr,bitIndex57)
        <=> v1181(VarCurr,bitIndex319) )
        & ( v2442(VarCurr,bitIndex56)
        <=> v1181(VarCurr,bitIndex318) )
        & ( v2442(VarCurr,bitIndex55)
        <=> v1181(VarCurr,bitIndex317) )
        & ( v2442(VarCurr,bitIndex54)
        <=> v1181(VarCurr,bitIndex316) )
        & ( v2442(VarCurr,bitIndex53)
        <=> v1181(VarCurr,bitIndex315) )
        & ( v2442(VarCurr,bitIndex52)
        <=> v1181(VarCurr,bitIndex314) )
        & ( v2442(VarCurr,bitIndex51)
        <=> v1181(VarCurr,bitIndex313) )
        & ( v2442(VarCurr,bitIndex50)
        <=> v1181(VarCurr,bitIndex312) )
        & ( v2442(VarCurr,bitIndex49)
        <=> v1181(VarCurr,bitIndex311) )
        & ( v2442(VarCurr,bitIndex48)
        <=> v1181(VarCurr,bitIndex310) )
        & ( v2442(VarCurr,bitIndex47)
        <=> v1181(VarCurr,bitIndex309) )
        & ( v2442(VarCurr,bitIndex46)
        <=> v1181(VarCurr,bitIndex308) )
        & ( v2442(VarCurr,bitIndex45)
        <=> v1181(VarCurr,bitIndex307) )
        & ( v2442(VarCurr,bitIndex44)
        <=> v1181(VarCurr,bitIndex306) )
        & ( v2442(VarCurr,bitIndex43)
        <=> v1181(VarCurr,bitIndex305) )
        & ( v2442(VarCurr,bitIndex42)
        <=> v1181(VarCurr,bitIndex304) )
        & ( v2442(VarCurr,bitIndex41)
        <=> v1181(VarCurr,bitIndex303) )
        & ( v2442(VarCurr,bitIndex40)
        <=> v1181(VarCurr,bitIndex302) )
        & ( v2442(VarCurr,bitIndex39)
        <=> v1181(VarCurr,bitIndex301) )
        & ( v2442(VarCurr,bitIndex38)
        <=> v1181(VarCurr,bitIndex300) )
        & ( v2442(VarCurr,bitIndex37)
        <=> v1181(VarCurr,bitIndex299) )
        & ( v2442(VarCurr,bitIndex36)
        <=> v1181(VarCurr,bitIndex298) )
        & ( v2442(VarCurr,bitIndex35)
        <=> v1181(VarCurr,bitIndex297) )
        & ( v2442(VarCurr,bitIndex34)
        <=> v1181(VarCurr,bitIndex296) )
        & ( v2442(VarCurr,bitIndex33)
        <=> v1181(VarCurr,bitIndex295) )
        & ( v2442(VarCurr,bitIndex32)
        <=> v1181(VarCurr,bitIndex294) )
        & ( v2442(VarCurr,bitIndex31)
        <=> v1181(VarCurr,bitIndex293) )
        & ( v2442(VarCurr,bitIndex30)
        <=> v1181(VarCurr,bitIndex292) )
        & ( v2442(VarCurr,bitIndex29)
        <=> v1181(VarCurr,bitIndex291) )
        & ( v2442(VarCurr,bitIndex28)
        <=> v1181(VarCurr,bitIndex290) )
        & ( v2442(VarCurr,bitIndex27)
        <=> v1181(VarCurr,bitIndex289) )
        & ( v2442(VarCurr,bitIndex26)
        <=> v1181(VarCurr,bitIndex288) )
        & ( v2442(VarCurr,bitIndex25)
        <=> v1181(VarCurr,bitIndex287) )
        & ( v2442(VarCurr,bitIndex24)
        <=> v1181(VarCurr,bitIndex286) )
        & ( v2442(VarCurr,bitIndex23)
        <=> v1181(VarCurr,bitIndex285) )
        & ( v2442(VarCurr,bitIndex22)
        <=> v1181(VarCurr,bitIndex284) )
        & ( v2442(VarCurr,bitIndex21)
        <=> v1181(VarCurr,bitIndex283) )
        & ( v2442(VarCurr,bitIndex20)
        <=> v1181(VarCurr,bitIndex282) )
        & ( v2442(VarCurr,bitIndex19)
        <=> v1181(VarCurr,bitIndex281) )
        & ( v2442(VarCurr,bitIndex18)
        <=> v1181(VarCurr,bitIndex280) )
        & ( v2442(VarCurr,bitIndex17)
        <=> v1181(VarCurr,bitIndex279) )
        & ( v2442(VarCurr,bitIndex16)
        <=> v1181(VarCurr,bitIndex278) )
        & ( v2442(VarCurr,bitIndex15)
        <=> v1181(VarCurr,bitIndex277) )
        & ( v2442(VarCurr,bitIndex14)
        <=> v1181(VarCurr,bitIndex276) )
        & ( v2442(VarCurr,bitIndex13)
        <=> v1181(VarCurr,bitIndex275) )
        & ( v2442(VarCurr,bitIndex12)
        <=> v1181(VarCurr,bitIndex274) )
        & ( v2442(VarCurr,bitIndex11)
        <=> v1181(VarCurr,bitIndex273) )
        & ( v2442(VarCurr,bitIndex10)
        <=> v1181(VarCurr,bitIndex272) )
        & ( v2442(VarCurr,bitIndex9)
        <=> v1181(VarCurr,bitIndex271) )
        & ( v2442(VarCurr,bitIndex8)
        <=> v1181(VarCurr,bitIndex270) )
        & ( v2442(VarCurr,bitIndex7)
        <=> v1181(VarCurr,bitIndex269) )
        & ( v2442(VarCurr,bitIndex6)
        <=> v1181(VarCurr,bitIndex268) )
        & ( v2442(VarCurr,bitIndex5)
        <=> v1181(VarCurr,bitIndex267) )
        & ( v2442(VarCurr,bitIndex4)
        <=> v1181(VarCurr,bitIndex266) )
        & ( v2442(VarCurr,bitIndex3)
        <=> v1181(VarCurr,bitIndex265) )
        & ( v2442(VarCurr,bitIndex2)
        <=> v1181(VarCurr,bitIndex264) )
        & ( v2442(VarCurr,bitIndex1)
        <=> v1181(VarCurr,bitIndex263) )
        & ( v2442(VarCurr,bitIndex0)
        <=> v1181(VarCurr,bitIndex262) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_311,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2415(VarNext)
      <=> ( v2416(VarNext)
          & v2423(VarNext) ) ) ) ).

fof(addAssignment_748,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2423(VarNext)
      <=> v2421(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_310,axiom,
    ! [VarCurr] :
      ( v2421(VarCurr)
    <=> ( v2424(VarCurr)
        & v2435(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_309,axiom,
    ! [VarCurr] :
      ( v2435(VarCurr)
    <=> ( v2436(VarCurr)
        | v2378(VarCurr) ) ) ).

fof(writeUnaryOperator_139,axiom,
    ! [VarCurr] :
      ( ~ v2436(VarCurr)
    <=> v2437(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_148,axiom,
    ! [VarCurr] :
      ( v2437(VarCurr)
    <=> ( ( v2438(VarCurr,bitIndex1)
        <=> $false )
        & ( v2438(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_747,axiom,
    ! [VarCurr] :
      ( v2438(VarCurr,bitIndex0)
    <=> v2064(VarCurr) ) ).

fof(addAssignment_746,axiom,
    ! [VarCurr] :
      ( v2438(VarCurr,bitIndex1)
    <=> v1185(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_308,axiom,
    ! [VarCurr] :
      ( v2424(VarCurr)
    <=> ( v2378(VarCurr)
        | v2425(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_307,axiom,
    ! [VarCurr] :
      ( v2425(VarCurr)
    <=> ( v2426(VarCurr)
        & v2434(VarCurr) ) ) ).

fof(writeUnaryOperator_138,axiom,
    ! [VarCurr] :
      ( ~ v2434(VarCurr)
    <=> v2378(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_306,axiom,
    ! [VarCurr] :
      ( v2426(VarCurr)
    <=> ( v2427(VarCurr)
        | v2432(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_147,axiom,
    ! [VarCurr] :
      ( v2432(VarCurr)
    <=> ( ( v2433(VarCurr,bitIndex1)
        <=> $true )
        & ( v2433(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_745,axiom,
    ! [VarCurr] :
      ( v2433(VarCurr,bitIndex0)
    <=> v2064(VarCurr) ) ).

fof(addAssignment_744,axiom,
    ! [VarCurr] :
      ( v2433(VarCurr,bitIndex1)
    <=> v1185(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_305,axiom,
    ! [VarCurr] :
      ( v2427(VarCurr)
    <=> ( v2428(VarCurr)
        | v2430(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_146,axiom,
    ! [VarCurr] :
      ( v2430(VarCurr)
    <=> ( ( v2431(VarCurr,bitIndex1)
        <=> $true )
        & ( v2431(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_743,axiom,
    ! [VarCurr] :
      ( v2431(VarCurr,bitIndex0)
    <=> v2064(VarCurr) ) ).

fof(addAssignment_742,axiom,
    ! [VarCurr] :
      ( v2431(VarCurr,bitIndex1)
    <=> v1185(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_145,axiom,
    ! [VarCurr] :
      ( v2428(VarCurr)
    <=> ( ( v2429(VarCurr,bitIndex1)
        <=> $false )
        & ( v2429(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_741,axiom,
    ! [VarCurr] :
      ( v2429(VarCurr,bitIndex0)
    <=> v2064(VarCurr) ) ).

fof(addAssignment_740,axiom,
    ! [VarCurr] :
      ( v2429(VarCurr,bitIndex1)
    <=> v1185(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_304,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2416(VarNext)
      <=> ( v2418(VarNext)
          & v2077(VarNext) ) ) ) ).

fof(writeUnaryOperator_137,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2418(VarNext)
      <=> v2086(VarNext) ) ) ).

fof(addAssignment_739,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v2407(VarCurr,B)
      <=> v2412(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_69,axiom,
    ! [VarCurr] :
      ( ~ v2409(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v2412(VarCurr,B)
          <=> v2411(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_100,axiom,
    ! [VarCurr] :
      ( v2409(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v2412(VarCurr,B)
          <=> v2131(VarCurr,B) ) ) ) ).

fof(addAssignment_738,axiom,
    ! [VarCurr] :
      ( ( v2411(VarCurr,bitIndex7)
      <=> v1181(VarCurr,bitIndex269) )
      & ( v2411(VarCurr,bitIndex6)
      <=> v1181(VarCurr,bitIndex268) )
      & ( v2411(VarCurr,bitIndex5)
      <=> v1181(VarCurr,bitIndex267) )
      & ( v2411(VarCurr,bitIndex4)
      <=> v1181(VarCurr,bitIndex266) )
      & ( v2411(VarCurr,bitIndex3)
      <=> v1181(VarCurr,bitIndex265) )
      & ( v2411(VarCurr,bitIndex2)
      <=> v1181(VarCurr,bitIndex264) )
      & ( v2411(VarCurr,bitIndex1)
      <=> v1181(VarCurr,bitIndex263) )
      & ( v2411(VarCurr,bitIndex0)
      <=> v1181(VarCurr,bitIndex262) ) ) ).

fof(addAssignment_737,axiom,
    ! [VarCurr] :
      ( v2409(VarCurr)
    <=> v2070(VarCurr,bitIndex1) ) ).

fof(addAssignment_736,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v2400(VarCurr,B)
      <=> v2405(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_68,axiom,
    ! [VarCurr] :
      ( ~ v2402(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v2405(VarCurr,B)
          <=> v2404(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_99,axiom,
    ! [VarCurr] :
      ( v2402(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v2405(VarCurr,B)
          <=> v2131(VarCurr,B) ) ) ) ).

fof(addAssignment_735,axiom,
    ! [VarCurr] :
      ( ( v2404(VarCurr,bitIndex7)
      <=> v1181(VarCurr,bitIndex400) )
      & ( v2404(VarCurr,bitIndex6)
      <=> v1181(VarCurr,bitIndex399) )
      & ( v2404(VarCurr,bitIndex5)
      <=> v1181(VarCurr,bitIndex398) )
      & ( v2404(VarCurr,bitIndex4)
      <=> v1181(VarCurr,bitIndex397) )
      & ( v2404(VarCurr,bitIndex3)
      <=> v1181(VarCurr,bitIndex396) )
      & ( v2404(VarCurr,bitIndex2)
      <=> v1181(VarCurr,bitIndex395) )
      & ( v2404(VarCurr,bitIndex1)
      <=> v1181(VarCurr,bitIndex394) )
      & ( v2404(VarCurr,bitIndex0)
      <=> v1181(VarCurr,bitIndex393) ) ) ).

fof(addAssignment_734,axiom,
    ! [VarCurr] :
      ( v2402(VarCurr)
    <=> v2070(VarCurr,bitIndex1) ) ).

fof(addAssignment_733,axiom,
    ! [VarNext] :
      ( ( v1181(VarNext,bitIndex269)
      <=> v2367(VarNext,bitIndex7) )
      & ( v1181(VarNext,bitIndex268)
      <=> v2367(VarNext,bitIndex6) )
      & ( v1181(VarNext,bitIndex267)
      <=> v2367(VarNext,bitIndex5) )
      & ( v1181(VarNext,bitIndex266)
      <=> v2367(VarNext,bitIndex4) )
      & ( v1181(VarNext,bitIndex265)
      <=> v2367(VarNext,bitIndex3) )
      & ( v1181(VarNext,bitIndex264)
      <=> v2367(VarNext,bitIndex2) )
      & ( v1181(VarNext,bitIndex263)
      <=> v2367(VarNext,bitIndex1) )
      & ( v1181(VarNext,bitIndex262)
      <=> v2367(VarNext,bitIndex0) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_2,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2368(VarNext)
       => ( ( v2367(VarNext,bitIndex130)
          <=> v1181(VarCurr,bitIndex392) )
          & ( v2367(VarNext,bitIndex129)
          <=> v1181(VarCurr,bitIndex391) )
          & ( v2367(VarNext,bitIndex128)
          <=> v1181(VarCurr,bitIndex390) )
          & ( v2367(VarNext,bitIndex127)
          <=> v1181(VarCurr,bitIndex389) )
          & ( v2367(VarNext,bitIndex126)
          <=> v1181(VarCurr,bitIndex388) )
          & ( v2367(VarNext,bitIndex125)
          <=> v1181(VarCurr,bitIndex387) )
          & ( v2367(VarNext,bitIndex124)
          <=> v1181(VarCurr,bitIndex386) )
          & ( v2367(VarNext,bitIndex123)
          <=> v1181(VarCurr,bitIndex385) )
          & ( v2367(VarNext,bitIndex122)
          <=> v1181(VarCurr,bitIndex384) )
          & ( v2367(VarNext,bitIndex121)
          <=> v1181(VarCurr,bitIndex383) )
          & ( v2367(VarNext,bitIndex120)
          <=> v1181(VarCurr,bitIndex382) )
          & ( v2367(VarNext,bitIndex119)
          <=> v1181(VarCurr,bitIndex381) )
          & ( v2367(VarNext,bitIndex118)
          <=> v1181(VarCurr,bitIndex380) )
          & ( v2367(VarNext,bitIndex117)
          <=> v1181(VarCurr,bitIndex379) )
          & ( v2367(VarNext,bitIndex116)
          <=> v1181(VarCurr,bitIndex378) )
          & ( v2367(VarNext,bitIndex115)
          <=> v1181(VarCurr,bitIndex377) )
          & ( v2367(VarNext,bitIndex114)
          <=> v1181(VarCurr,bitIndex376) )
          & ( v2367(VarNext,bitIndex113)
          <=> v1181(VarCurr,bitIndex375) )
          & ( v2367(VarNext,bitIndex112)
          <=> v1181(VarCurr,bitIndex374) )
          & ( v2367(VarNext,bitIndex111)
          <=> v1181(VarCurr,bitIndex373) )
          & ( v2367(VarNext,bitIndex110)
          <=> v1181(VarCurr,bitIndex372) )
          & ( v2367(VarNext,bitIndex109)
          <=> v1181(VarCurr,bitIndex371) )
          & ( v2367(VarNext,bitIndex108)
          <=> v1181(VarCurr,bitIndex370) )
          & ( v2367(VarNext,bitIndex107)
          <=> v1181(VarCurr,bitIndex369) )
          & ( v2367(VarNext,bitIndex106)
          <=> v1181(VarCurr,bitIndex368) )
          & ( v2367(VarNext,bitIndex105)
          <=> v1181(VarCurr,bitIndex367) )
          & ( v2367(VarNext,bitIndex104)
          <=> v1181(VarCurr,bitIndex366) )
          & ( v2367(VarNext,bitIndex103)
          <=> v1181(VarCurr,bitIndex365) )
          & ( v2367(VarNext,bitIndex102)
          <=> v1181(VarCurr,bitIndex364) )
          & ( v2367(VarNext,bitIndex101)
          <=> v1181(VarCurr,bitIndex363) )
          & ( v2367(VarNext,bitIndex100)
          <=> v1181(VarCurr,bitIndex362) )
          & ( v2367(VarNext,bitIndex99)
          <=> v1181(VarCurr,bitIndex361) )
          & ( v2367(VarNext,bitIndex98)
          <=> v1181(VarCurr,bitIndex360) )
          & ( v2367(VarNext,bitIndex97)
          <=> v1181(VarCurr,bitIndex359) )
          & ( v2367(VarNext,bitIndex96)
          <=> v1181(VarCurr,bitIndex358) )
          & ( v2367(VarNext,bitIndex95)
          <=> v1181(VarCurr,bitIndex357) )
          & ( v2367(VarNext,bitIndex94)
          <=> v1181(VarCurr,bitIndex356) )
          & ( v2367(VarNext,bitIndex93)
          <=> v1181(VarCurr,bitIndex355) )
          & ( v2367(VarNext,bitIndex92)
          <=> v1181(VarCurr,bitIndex354) )
          & ( v2367(VarNext,bitIndex91)
          <=> v1181(VarCurr,bitIndex353) )
          & ( v2367(VarNext,bitIndex90)
          <=> v1181(VarCurr,bitIndex352) )
          & ( v2367(VarNext,bitIndex89)
          <=> v1181(VarCurr,bitIndex351) )
          & ( v2367(VarNext,bitIndex88)
          <=> v1181(VarCurr,bitIndex350) )
          & ( v2367(VarNext,bitIndex87)
          <=> v1181(VarCurr,bitIndex349) )
          & ( v2367(VarNext,bitIndex86)
          <=> v1181(VarCurr,bitIndex348) )
          & ( v2367(VarNext,bitIndex85)
          <=> v1181(VarCurr,bitIndex347) )
          & ( v2367(VarNext,bitIndex84)
          <=> v1181(VarCurr,bitIndex346) )
          & ( v2367(VarNext,bitIndex83)
          <=> v1181(VarCurr,bitIndex345) )
          & ( v2367(VarNext,bitIndex82)
          <=> v1181(VarCurr,bitIndex344) )
          & ( v2367(VarNext,bitIndex81)
          <=> v1181(VarCurr,bitIndex343) )
          & ( v2367(VarNext,bitIndex80)
          <=> v1181(VarCurr,bitIndex342) )
          & ( v2367(VarNext,bitIndex79)
          <=> v1181(VarCurr,bitIndex341) )
          & ( v2367(VarNext,bitIndex78)
          <=> v1181(VarCurr,bitIndex340) )
          & ( v2367(VarNext,bitIndex77)
          <=> v1181(VarCurr,bitIndex339) )
          & ( v2367(VarNext,bitIndex76)
          <=> v1181(VarCurr,bitIndex338) )
          & ( v2367(VarNext,bitIndex75)
          <=> v1181(VarCurr,bitIndex337) )
          & ( v2367(VarNext,bitIndex74)
          <=> v1181(VarCurr,bitIndex336) )
          & ( v2367(VarNext,bitIndex73)
          <=> v1181(VarCurr,bitIndex335) )
          & ( v2367(VarNext,bitIndex72)
          <=> v1181(VarCurr,bitIndex334) )
          & ( v2367(VarNext,bitIndex71)
          <=> v1181(VarCurr,bitIndex333) )
          & ( v2367(VarNext,bitIndex70)
          <=> v1181(VarCurr,bitIndex332) )
          & ( v2367(VarNext,bitIndex69)
          <=> v1181(VarCurr,bitIndex331) )
          & ( v2367(VarNext,bitIndex68)
          <=> v1181(VarCurr,bitIndex330) )
          & ( v2367(VarNext,bitIndex67)
          <=> v1181(VarCurr,bitIndex329) )
          & ( v2367(VarNext,bitIndex66)
          <=> v1181(VarCurr,bitIndex328) )
          & ( v2367(VarNext,bitIndex65)
          <=> v1181(VarCurr,bitIndex327) )
          & ( v2367(VarNext,bitIndex64)
          <=> v1181(VarCurr,bitIndex326) )
          & ( v2367(VarNext,bitIndex63)
          <=> v1181(VarCurr,bitIndex325) )
          & ( v2367(VarNext,bitIndex62)
          <=> v1181(VarCurr,bitIndex324) )
          & ( v2367(VarNext,bitIndex61)
          <=> v1181(VarCurr,bitIndex323) )
          & ( v2367(VarNext,bitIndex60)
          <=> v1181(VarCurr,bitIndex322) )
          & ( v2367(VarNext,bitIndex59)
          <=> v1181(VarCurr,bitIndex321) )
          & ( v2367(VarNext,bitIndex58)
          <=> v1181(VarCurr,bitIndex320) )
          & ( v2367(VarNext,bitIndex57)
          <=> v1181(VarCurr,bitIndex319) )
          & ( v2367(VarNext,bitIndex56)
          <=> v1181(VarCurr,bitIndex318) )
          & ( v2367(VarNext,bitIndex55)
          <=> v1181(VarCurr,bitIndex317) )
          & ( v2367(VarNext,bitIndex54)
          <=> v1181(VarCurr,bitIndex316) )
          & ( v2367(VarNext,bitIndex53)
          <=> v1181(VarCurr,bitIndex315) )
          & ( v2367(VarNext,bitIndex52)
          <=> v1181(VarCurr,bitIndex314) )
          & ( v2367(VarNext,bitIndex51)
          <=> v1181(VarCurr,bitIndex313) )
          & ( v2367(VarNext,bitIndex50)
          <=> v1181(VarCurr,bitIndex312) )
          & ( v2367(VarNext,bitIndex49)
          <=> v1181(VarCurr,bitIndex311) )
          & ( v2367(VarNext,bitIndex48)
          <=> v1181(VarCurr,bitIndex310) )
          & ( v2367(VarNext,bitIndex47)
          <=> v1181(VarCurr,bitIndex309) )
          & ( v2367(VarNext,bitIndex46)
          <=> v1181(VarCurr,bitIndex308) )
          & ( v2367(VarNext,bitIndex45)
          <=> v1181(VarCurr,bitIndex307) )
          & ( v2367(VarNext,bitIndex44)
          <=> v1181(VarCurr,bitIndex306) )
          & ( v2367(VarNext,bitIndex43)
          <=> v1181(VarCurr,bitIndex305) )
          & ( v2367(VarNext,bitIndex42)
          <=> v1181(VarCurr,bitIndex304) )
          & ( v2367(VarNext,bitIndex41)
          <=> v1181(VarCurr,bitIndex303) )
          & ( v2367(VarNext,bitIndex40)
          <=> v1181(VarCurr,bitIndex302) )
          & ( v2367(VarNext,bitIndex39)
          <=> v1181(VarCurr,bitIndex301) )
          & ( v2367(VarNext,bitIndex38)
          <=> v1181(VarCurr,bitIndex300) )
          & ( v2367(VarNext,bitIndex37)
          <=> v1181(VarCurr,bitIndex299) )
          & ( v2367(VarNext,bitIndex36)
          <=> v1181(VarCurr,bitIndex298) )
          & ( v2367(VarNext,bitIndex35)
          <=> v1181(VarCurr,bitIndex297) )
          & ( v2367(VarNext,bitIndex34)
          <=> v1181(VarCurr,bitIndex296) )
          & ( v2367(VarNext,bitIndex33)
          <=> v1181(VarCurr,bitIndex295) )
          & ( v2367(VarNext,bitIndex32)
          <=> v1181(VarCurr,bitIndex294) )
          & ( v2367(VarNext,bitIndex31)
          <=> v1181(VarCurr,bitIndex293) )
          & ( v2367(VarNext,bitIndex30)
          <=> v1181(VarCurr,bitIndex292) )
          & ( v2367(VarNext,bitIndex29)
          <=> v1181(VarCurr,bitIndex291) )
          & ( v2367(VarNext,bitIndex28)
          <=> v1181(VarCurr,bitIndex290) )
          & ( v2367(VarNext,bitIndex27)
          <=> v1181(VarCurr,bitIndex289) )
          & ( v2367(VarNext,bitIndex26)
          <=> v1181(VarCurr,bitIndex288) )
          & ( v2367(VarNext,bitIndex25)
          <=> v1181(VarCurr,bitIndex287) )
          & ( v2367(VarNext,bitIndex24)
          <=> v1181(VarCurr,bitIndex286) )
          & ( v2367(VarNext,bitIndex23)
          <=> v1181(VarCurr,bitIndex285) )
          & ( v2367(VarNext,bitIndex22)
          <=> v1181(VarCurr,bitIndex284) )
          & ( v2367(VarNext,bitIndex21)
          <=> v1181(VarCurr,bitIndex283) )
          & ( v2367(VarNext,bitIndex20)
          <=> v1181(VarCurr,bitIndex282) )
          & ( v2367(VarNext,bitIndex19)
          <=> v1181(VarCurr,bitIndex281) )
          & ( v2367(VarNext,bitIndex18)
          <=> v1181(VarCurr,bitIndex280) )
          & ( v2367(VarNext,bitIndex17)
          <=> v1181(VarCurr,bitIndex279) )
          & ( v2367(VarNext,bitIndex16)
          <=> v1181(VarCurr,bitIndex278) )
          & ( v2367(VarNext,bitIndex15)
          <=> v1181(VarCurr,bitIndex277) )
          & ( v2367(VarNext,bitIndex14)
          <=> v1181(VarCurr,bitIndex276) )
          & ( v2367(VarNext,bitIndex13)
          <=> v1181(VarCurr,bitIndex275) )
          & ( v2367(VarNext,bitIndex12)
          <=> v1181(VarCurr,bitIndex274) )
          & ( v2367(VarNext,bitIndex11)
          <=> v1181(VarCurr,bitIndex273) )
          & ( v2367(VarNext,bitIndex10)
          <=> v1181(VarCurr,bitIndex272) )
          & ( v2367(VarNext,bitIndex9)
          <=> v1181(VarCurr,bitIndex271) )
          & ( v2367(VarNext,bitIndex8)
          <=> v1181(VarCurr,bitIndex270) )
          & ( v2367(VarNext,bitIndex7)
          <=> v1181(VarCurr,bitIndex269) )
          & ( v2367(VarNext,bitIndex6)
          <=> v1181(VarCurr,bitIndex268) )
          & ( v2367(VarNext,bitIndex5)
          <=> v1181(VarCurr,bitIndex267) )
          & ( v2367(VarNext,bitIndex4)
          <=> v1181(VarCurr,bitIndex266) )
          & ( v2367(VarNext,bitIndex3)
          <=> v1181(VarCurr,bitIndex265) )
          & ( v2367(VarNext,bitIndex2)
          <=> v1181(VarCurr,bitIndex264) )
          & ( v2367(VarNext,bitIndex1)
          <=> v1181(VarCurr,bitIndex263) )
          & ( v2367(VarNext,bitIndex0)
          <=> v1181(VarCurr,bitIndex262) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_26,axiom,
    ! [VarNext] :
      ( v2368(VarNext)
     => ! [B] :
          ( range_130_0(B)
         => ( v2367(VarNext,B)
          <=> v2395(VarNext,B) ) ) ) ).

fof(addAssignment_732,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_130_0(B)
         => ( v2395(VarNext,B)
          <=> v2393(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_19,axiom,
    ! [VarCurr] :
      ( ~ v2378(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v2393(VarCurr,B)
          <=> v2396(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_17,axiom,
    ! [VarCurr] :
      ( v2378(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v2393(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_10,axiom,
    ! [VarCurr] :
      ( ( ~ v2382(VarCurr)
        & ~ v2384(VarCurr) )
     => ! [B] :
          ( range_130_0(B)
         => ( v2396(VarCurr,B)
          <=> v2360(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_18,axiom,
    ! [VarCurr] :
      ( v2384(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v2396(VarCurr,B)
          <=> v2066(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_1,axiom,
    ! [VarCurr] :
      ( v2382(VarCurr)
     => ( ( v2396(VarCurr,bitIndex130)
        <=> v1181(VarCurr,bitIndex261) )
        & ( v2396(VarCurr,bitIndex129)
        <=> v1181(VarCurr,bitIndex260) )
        & ( v2396(VarCurr,bitIndex128)
        <=> v1181(VarCurr,bitIndex259) )
        & ( v2396(VarCurr,bitIndex127)
        <=> v1181(VarCurr,bitIndex258) )
        & ( v2396(VarCurr,bitIndex126)
        <=> v1181(VarCurr,bitIndex257) )
        & ( v2396(VarCurr,bitIndex125)
        <=> v1181(VarCurr,bitIndex256) )
        & ( v2396(VarCurr,bitIndex124)
        <=> v1181(VarCurr,bitIndex255) )
        & ( v2396(VarCurr,bitIndex123)
        <=> v1181(VarCurr,bitIndex254) )
        & ( v2396(VarCurr,bitIndex122)
        <=> v1181(VarCurr,bitIndex253) )
        & ( v2396(VarCurr,bitIndex121)
        <=> v1181(VarCurr,bitIndex252) )
        & ( v2396(VarCurr,bitIndex120)
        <=> v1181(VarCurr,bitIndex251) )
        & ( v2396(VarCurr,bitIndex119)
        <=> v1181(VarCurr,bitIndex250) )
        & ( v2396(VarCurr,bitIndex118)
        <=> v1181(VarCurr,bitIndex249) )
        & ( v2396(VarCurr,bitIndex117)
        <=> v1181(VarCurr,bitIndex248) )
        & ( v2396(VarCurr,bitIndex116)
        <=> v1181(VarCurr,bitIndex247) )
        & ( v2396(VarCurr,bitIndex115)
        <=> v1181(VarCurr,bitIndex246) )
        & ( v2396(VarCurr,bitIndex114)
        <=> v1181(VarCurr,bitIndex245) )
        & ( v2396(VarCurr,bitIndex113)
        <=> v1181(VarCurr,bitIndex244) )
        & ( v2396(VarCurr,bitIndex112)
        <=> v1181(VarCurr,bitIndex243) )
        & ( v2396(VarCurr,bitIndex111)
        <=> v1181(VarCurr,bitIndex242) )
        & ( v2396(VarCurr,bitIndex110)
        <=> v1181(VarCurr,bitIndex241) )
        & ( v2396(VarCurr,bitIndex109)
        <=> v1181(VarCurr,bitIndex240) )
        & ( v2396(VarCurr,bitIndex108)
        <=> v1181(VarCurr,bitIndex239) )
        & ( v2396(VarCurr,bitIndex107)
        <=> v1181(VarCurr,bitIndex238) )
        & ( v2396(VarCurr,bitIndex106)
        <=> v1181(VarCurr,bitIndex237) )
        & ( v2396(VarCurr,bitIndex105)
        <=> v1181(VarCurr,bitIndex236) )
        & ( v2396(VarCurr,bitIndex104)
        <=> v1181(VarCurr,bitIndex235) )
        & ( v2396(VarCurr,bitIndex103)
        <=> v1181(VarCurr,bitIndex234) )
        & ( v2396(VarCurr,bitIndex102)
        <=> v1181(VarCurr,bitIndex233) )
        & ( v2396(VarCurr,bitIndex101)
        <=> v1181(VarCurr,bitIndex232) )
        & ( v2396(VarCurr,bitIndex100)
        <=> v1181(VarCurr,bitIndex231) )
        & ( v2396(VarCurr,bitIndex99)
        <=> v1181(VarCurr,bitIndex230) )
        & ( v2396(VarCurr,bitIndex98)
        <=> v1181(VarCurr,bitIndex229) )
        & ( v2396(VarCurr,bitIndex97)
        <=> v1181(VarCurr,bitIndex228) )
        & ( v2396(VarCurr,bitIndex96)
        <=> v1181(VarCurr,bitIndex227) )
        & ( v2396(VarCurr,bitIndex95)
        <=> v1181(VarCurr,bitIndex226) )
        & ( v2396(VarCurr,bitIndex94)
        <=> v1181(VarCurr,bitIndex225) )
        & ( v2396(VarCurr,bitIndex93)
        <=> v1181(VarCurr,bitIndex224) )
        & ( v2396(VarCurr,bitIndex92)
        <=> v1181(VarCurr,bitIndex223) )
        & ( v2396(VarCurr,bitIndex91)
        <=> v1181(VarCurr,bitIndex222) )
        & ( v2396(VarCurr,bitIndex90)
        <=> v1181(VarCurr,bitIndex221) )
        & ( v2396(VarCurr,bitIndex89)
        <=> v1181(VarCurr,bitIndex220) )
        & ( v2396(VarCurr,bitIndex88)
        <=> v1181(VarCurr,bitIndex219) )
        & ( v2396(VarCurr,bitIndex87)
        <=> v1181(VarCurr,bitIndex218) )
        & ( v2396(VarCurr,bitIndex86)
        <=> v1181(VarCurr,bitIndex217) )
        & ( v2396(VarCurr,bitIndex85)
        <=> v1181(VarCurr,bitIndex216) )
        & ( v2396(VarCurr,bitIndex84)
        <=> v1181(VarCurr,bitIndex215) )
        & ( v2396(VarCurr,bitIndex83)
        <=> v1181(VarCurr,bitIndex214) )
        & ( v2396(VarCurr,bitIndex82)
        <=> v1181(VarCurr,bitIndex213) )
        & ( v2396(VarCurr,bitIndex81)
        <=> v1181(VarCurr,bitIndex212) )
        & ( v2396(VarCurr,bitIndex80)
        <=> v1181(VarCurr,bitIndex211) )
        & ( v2396(VarCurr,bitIndex79)
        <=> v1181(VarCurr,bitIndex210) )
        & ( v2396(VarCurr,bitIndex78)
        <=> v1181(VarCurr,bitIndex209) )
        & ( v2396(VarCurr,bitIndex77)
        <=> v1181(VarCurr,bitIndex208) )
        & ( v2396(VarCurr,bitIndex76)
        <=> v1181(VarCurr,bitIndex207) )
        & ( v2396(VarCurr,bitIndex75)
        <=> v1181(VarCurr,bitIndex206) )
        & ( v2396(VarCurr,bitIndex74)
        <=> v1181(VarCurr,bitIndex205) )
        & ( v2396(VarCurr,bitIndex73)
        <=> v1181(VarCurr,bitIndex204) )
        & ( v2396(VarCurr,bitIndex72)
        <=> v1181(VarCurr,bitIndex203) )
        & ( v2396(VarCurr,bitIndex71)
        <=> v1181(VarCurr,bitIndex202) )
        & ( v2396(VarCurr,bitIndex70)
        <=> v1181(VarCurr,bitIndex201) )
        & ( v2396(VarCurr,bitIndex69)
        <=> v1181(VarCurr,bitIndex200) )
        & ( v2396(VarCurr,bitIndex68)
        <=> v1181(VarCurr,bitIndex199) )
        & ( v2396(VarCurr,bitIndex67)
        <=> v1181(VarCurr,bitIndex198) )
        & ( v2396(VarCurr,bitIndex66)
        <=> v1181(VarCurr,bitIndex197) )
        & ( v2396(VarCurr,bitIndex65)
        <=> v1181(VarCurr,bitIndex196) )
        & ( v2396(VarCurr,bitIndex64)
        <=> v1181(VarCurr,bitIndex195) )
        & ( v2396(VarCurr,bitIndex63)
        <=> v1181(VarCurr,bitIndex194) )
        & ( v2396(VarCurr,bitIndex62)
        <=> v1181(VarCurr,bitIndex193) )
        & ( v2396(VarCurr,bitIndex61)
        <=> v1181(VarCurr,bitIndex192) )
        & ( v2396(VarCurr,bitIndex60)
        <=> v1181(VarCurr,bitIndex191) )
        & ( v2396(VarCurr,bitIndex59)
        <=> v1181(VarCurr,bitIndex190) )
        & ( v2396(VarCurr,bitIndex58)
        <=> v1181(VarCurr,bitIndex189) )
        & ( v2396(VarCurr,bitIndex57)
        <=> v1181(VarCurr,bitIndex188) )
        & ( v2396(VarCurr,bitIndex56)
        <=> v1181(VarCurr,bitIndex187) )
        & ( v2396(VarCurr,bitIndex55)
        <=> v1181(VarCurr,bitIndex186) )
        & ( v2396(VarCurr,bitIndex54)
        <=> v1181(VarCurr,bitIndex185) )
        & ( v2396(VarCurr,bitIndex53)
        <=> v1181(VarCurr,bitIndex184) )
        & ( v2396(VarCurr,bitIndex52)
        <=> v1181(VarCurr,bitIndex183) )
        & ( v2396(VarCurr,bitIndex51)
        <=> v1181(VarCurr,bitIndex182) )
        & ( v2396(VarCurr,bitIndex50)
        <=> v1181(VarCurr,bitIndex181) )
        & ( v2396(VarCurr,bitIndex49)
        <=> v1181(VarCurr,bitIndex180) )
        & ( v2396(VarCurr,bitIndex48)
        <=> v1181(VarCurr,bitIndex179) )
        & ( v2396(VarCurr,bitIndex47)
        <=> v1181(VarCurr,bitIndex178) )
        & ( v2396(VarCurr,bitIndex46)
        <=> v1181(VarCurr,bitIndex177) )
        & ( v2396(VarCurr,bitIndex45)
        <=> v1181(VarCurr,bitIndex176) )
        & ( v2396(VarCurr,bitIndex44)
        <=> v1181(VarCurr,bitIndex175) )
        & ( v2396(VarCurr,bitIndex43)
        <=> v1181(VarCurr,bitIndex174) )
        & ( v2396(VarCurr,bitIndex42)
        <=> v1181(VarCurr,bitIndex173) )
        & ( v2396(VarCurr,bitIndex41)
        <=> v1181(VarCurr,bitIndex172) )
        & ( v2396(VarCurr,bitIndex40)
        <=> v1181(VarCurr,bitIndex171) )
        & ( v2396(VarCurr,bitIndex39)
        <=> v1181(VarCurr,bitIndex170) )
        & ( v2396(VarCurr,bitIndex38)
        <=> v1181(VarCurr,bitIndex169) )
        & ( v2396(VarCurr,bitIndex37)
        <=> v1181(VarCurr,bitIndex168) )
        & ( v2396(VarCurr,bitIndex36)
        <=> v1181(VarCurr,bitIndex167) )
        & ( v2396(VarCurr,bitIndex35)
        <=> v1181(VarCurr,bitIndex166) )
        & ( v2396(VarCurr,bitIndex34)
        <=> v1181(VarCurr,bitIndex165) )
        & ( v2396(VarCurr,bitIndex33)
        <=> v1181(VarCurr,bitIndex164) )
        & ( v2396(VarCurr,bitIndex32)
        <=> v1181(VarCurr,bitIndex163) )
        & ( v2396(VarCurr,bitIndex31)
        <=> v1181(VarCurr,bitIndex162) )
        & ( v2396(VarCurr,bitIndex30)
        <=> v1181(VarCurr,bitIndex161) )
        & ( v2396(VarCurr,bitIndex29)
        <=> v1181(VarCurr,bitIndex160) )
        & ( v2396(VarCurr,bitIndex28)
        <=> v1181(VarCurr,bitIndex159) )
        & ( v2396(VarCurr,bitIndex27)
        <=> v1181(VarCurr,bitIndex158) )
        & ( v2396(VarCurr,bitIndex26)
        <=> v1181(VarCurr,bitIndex157) )
        & ( v2396(VarCurr,bitIndex25)
        <=> v1181(VarCurr,bitIndex156) )
        & ( v2396(VarCurr,bitIndex24)
        <=> v1181(VarCurr,bitIndex155) )
        & ( v2396(VarCurr,bitIndex23)
        <=> v1181(VarCurr,bitIndex154) )
        & ( v2396(VarCurr,bitIndex22)
        <=> v1181(VarCurr,bitIndex153) )
        & ( v2396(VarCurr,bitIndex21)
        <=> v1181(VarCurr,bitIndex152) )
        & ( v2396(VarCurr,bitIndex20)
        <=> v1181(VarCurr,bitIndex151) )
        & ( v2396(VarCurr,bitIndex19)
        <=> v1181(VarCurr,bitIndex150) )
        & ( v2396(VarCurr,bitIndex18)
        <=> v1181(VarCurr,bitIndex149) )
        & ( v2396(VarCurr,bitIndex17)
        <=> v1181(VarCurr,bitIndex148) )
        & ( v2396(VarCurr,bitIndex16)
        <=> v1181(VarCurr,bitIndex147) )
        & ( v2396(VarCurr,bitIndex15)
        <=> v1181(VarCurr,bitIndex146) )
        & ( v2396(VarCurr,bitIndex14)
        <=> v1181(VarCurr,bitIndex145) )
        & ( v2396(VarCurr,bitIndex13)
        <=> v1181(VarCurr,bitIndex144) )
        & ( v2396(VarCurr,bitIndex12)
        <=> v1181(VarCurr,bitIndex143) )
        & ( v2396(VarCurr,bitIndex11)
        <=> v1181(VarCurr,bitIndex142) )
        & ( v2396(VarCurr,bitIndex10)
        <=> v1181(VarCurr,bitIndex141) )
        & ( v2396(VarCurr,bitIndex9)
        <=> v1181(VarCurr,bitIndex140) )
        & ( v2396(VarCurr,bitIndex8)
        <=> v1181(VarCurr,bitIndex139) )
        & ( v2396(VarCurr,bitIndex7)
        <=> v1181(VarCurr,bitIndex138) )
        & ( v2396(VarCurr,bitIndex6)
        <=> v1181(VarCurr,bitIndex137) )
        & ( v2396(VarCurr,bitIndex5)
        <=> v1181(VarCurr,bitIndex136) )
        & ( v2396(VarCurr,bitIndex4)
        <=> v1181(VarCurr,bitIndex135) )
        & ( v2396(VarCurr,bitIndex3)
        <=> v1181(VarCurr,bitIndex134) )
        & ( v2396(VarCurr,bitIndex2)
        <=> v1181(VarCurr,bitIndex133) )
        & ( v2396(VarCurr,bitIndex1)
        <=> v1181(VarCurr,bitIndex132) )
        & ( v2396(VarCurr,bitIndex0)
        <=> v1181(VarCurr,bitIndex131) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_303,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2368(VarNext)
      <=> ( v2369(VarNext)
          & v2376(VarNext) ) ) ) ).

fof(addAssignment_731,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2376(VarNext)
      <=> v2374(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_302,axiom,
    ! [VarCurr] :
      ( v2374(VarCurr)
    <=> ( v2377(VarCurr)
        & v2389(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_301,axiom,
    ! [VarCurr] :
      ( v2389(VarCurr)
    <=> ( v2390(VarCurr)
        | v2378(VarCurr) ) ) ).

fof(writeUnaryOperator_136,axiom,
    ! [VarCurr] :
      ( ~ v2390(VarCurr)
    <=> v2391(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_144,axiom,
    ! [VarCurr] :
      ( v2391(VarCurr)
    <=> ( ( v2392(VarCurr,bitIndex1)
        <=> $false )
        & ( v2392(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_730,axiom,
    ! [VarCurr] :
      ( v2392(VarCurr,bitIndex0)
    <=> v2064(VarCurr) ) ).

fof(addAssignment_729,axiom,
    ! [VarCurr] :
      ( v2392(VarCurr,bitIndex1)
    <=> v1185(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_300,axiom,
    ! [VarCurr] :
      ( v2377(VarCurr)
    <=> ( v2378(VarCurr)
        | v2379(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_299,axiom,
    ! [VarCurr] :
      ( v2379(VarCurr)
    <=> ( v2380(VarCurr)
        & v2388(VarCurr) ) ) ).

fof(writeUnaryOperator_135,axiom,
    ! [VarCurr] :
      ( ~ v2388(VarCurr)
    <=> v2378(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_298,axiom,
    ! [VarCurr] :
      ( v2380(VarCurr)
    <=> ( v2381(VarCurr)
        | v2386(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_143,axiom,
    ! [VarCurr] :
      ( v2386(VarCurr)
    <=> ( ( v2387(VarCurr,bitIndex1)
        <=> $true )
        & ( v2387(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_728,axiom,
    ! [VarCurr] :
      ( v2387(VarCurr,bitIndex0)
    <=> v2064(VarCurr) ) ).

fof(addAssignment_727,axiom,
    ! [VarCurr] :
      ( v2387(VarCurr,bitIndex1)
    <=> v1185(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_297,axiom,
    ! [VarCurr] :
      ( v2381(VarCurr)
    <=> ( v2382(VarCurr)
        | v2384(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_142,axiom,
    ! [VarCurr] :
      ( v2384(VarCurr)
    <=> ( ( v2385(VarCurr,bitIndex1)
        <=> $true )
        & ( v2385(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_726,axiom,
    ! [VarCurr] :
      ( v2385(VarCurr,bitIndex0)
    <=> v2064(VarCurr) ) ).

fof(addAssignment_725,axiom,
    ! [VarCurr] :
      ( v2385(VarCurr,bitIndex1)
    <=> v1185(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_141,axiom,
    ! [VarCurr] :
      ( v2382(VarCurr)
    <=> ( ( v2383(VarCurr,bitIndex1)
        <=> $false )
        & ( v2383(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_724,axiom,
    ! [VarCurr] :
      ( v2383(VarCurr,bitIndex0)
    <=> v2064(VarCurr) ) ).

fof(addAssignment_723,axiom,
    ! [VarCurr] :
      ( v2383(VarCurr,bitIndex1)
    <=> v1185(VarCurr) ) ).

fof(writeUnaryOperator_134,axiom,
    ! [VarCurr] :
      ( ~ v2378(VarCurr)
    <=> v1183(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_296,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2369(VarNext)
      <=> ( v2370(VarNext)
          & v2077(VarNext) ) ) ) ).

fof(writeUnaryOperator_133,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2370(VarNext)
      <=> v2086(VarNext) ) ) ).

fof(addAssignment_722,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v2360(VarCurr,B)
      <=> v2365(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_67,axiom,
    ! [VarCurr] :
      ( ~ v2362(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v2365(VarCurr,B)
          <=> v2364(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_98,axiom,
    ! [VarCurr] :
      ( v2362(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v2365(VarCurr,B)
          <=> v2131(VarCurr,B) ) ) ) ).

fof(addAssignment_721,axiom,
    ! [VarCurr] :
      ( ( v2364(VarCurr,bitIndex7)
      <=> v1181(VarCurr,bitIndex138) )
      & ( v2364(VarCurr,bitIndex6)
      <=> v1181(VarCurr,bitIndex137) )
      & ( v2364(VarCurr,bitIndex5)
      <=> v1181(VarCurr,bitIndex136) )
      & ( v2364(VarCurr,bitIndex4)
      <=> v1181(VarCurr,bitIndex135) )
      & ( v2364(VarCurr,bitIndex3)
      <=> v1181(VarCurr,bitIndex134) )
      & ( v2364(VarCurr,bitIndex2)
      <=> v1181(VarCurr,bitIndex133) )
      & ( v2364(VarCurr,bitIndex1)
      <=> v1181(VarCurr,bitIndex132) )
      & ( v2364(VarCurr,bitIndex0)
      <=> v1181(VarCurr,bitIndex131) ) ) ).

fof(addAssignment_720,axiom,
    ! [VarCurr] :
      ( v2362(VarCurr)
    <=> v2070(VarCurr,bitIndex2) ) ).

fof(addAssignment_719,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v2066(VarCurr,B)
      <=> v2358(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_66,axiom,
    ! [VarCurr] :
      ( ~ v2068(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v2358(VarCurr,B)
          <=> v2351(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_97,axiom,
    ! [VarCurr] :
      ( v2068(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v2358(VarCurr,B)
          <=> v2131(VarCurr,B) ) ) ) ).

fof(addAssignment_718,axiom,
    ! [VarCurr] :
      ( ( v2351(VarCurr,bitIndex7)
      <=> v1181(VarCurr,bitIndex269) )
      & ( v2351(VarCurr,bitIndex6)
      <=> v1181(VarCurr,bitIndex268) )
      & ( v2351(VarCurr,bitIndex5)
      <=> v1181(VarCurr,bitIndex267) )
      & ( v2351(VarCurr,bitIndex4)
      <=> v1181(VarCurr,bitIndex266) )
      & ( v2351(VarCurr,bitIndex3)
      <=> v1181(VarCurr,bitIndex265) )
      & ( v2351(VarCurr,bitIndex2)
      <=> v1181(VarCurr,bitIndex264) )
      & ( v2351(VarCurr,bitIndex1)
      <=> v1181(VarCurr,bitIndex263) )
      & ( v2351(VarCurr,bitIndex0)
      <=> v1181(VarCurr,bitIndex262) ) ) ).

fof(addAssignmentInitValue_189,axiom,
    ~ v1181(constB0,bitIndex400) ).

fof(addAssignmentInitValue_188,axiom,
    ~ v1181(constB0,bitIndex399) ).

fof(addAssignmentInitValue_187,axiom,
    ~ v1181(constB0,bitIndex398) ).

fof(addAssignmentInitValue_186,axiom,
    ~ v1181(constB0,bitIndex397) ).

fof(addAssignmentInitValue_185,axiom,
    ~ v1181(constB0,bitIndex396) ).

fof(addAssignmentInitValue_184,axiom,
    ~ v1181(constB0,bitIndex395) ).

fof(addAssignmentInitValue_183,axiom,
    ~ v1181(constB0,bitIndex394) ).

fof(addAssignmentInitValue_182,axiom,
    ~ v1181(constB0,bitIndex393) ).

fof(bitBlastConstant_741,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex7) ).

fof(bitBlastConstant_740,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex6) ).

fof(bitBlastConstant_739,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex5) ).

fof(bitBlastConstant_738,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex4) ).

fof(bitBlastConstant_737,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex3) ).

fof(bitBlastConstant_736,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex2) ).

fof(bitBlastConstant_735,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex1) ).

fof(bitBlastConstant_734,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex0) ).

fof(addAssignmentInitValue_181,axiom,
    ~ v1181(constB0,bitIndex269) ).

fof(addAssignmentInitValue_180,axiom,
    ~ v1181(constB0,bitIndex268) ).

fof(addAssignmentInitValue_179,axiom,
    ~ v1181(constB0,bitIndex267) ).

fof(addAssignmentInitValue_178,axiom,
    ~ v1181(constB0,bitIndex266) ).

fof(addAssignmentInitValue_177,axiom,
    ~ v1181(constB0,bitIndex265) ).

fof(addAssignmentInitValue_176,axiom,
    ~ v1181(constB0,bitIndex264) ).

fof(addAssignmentInitValue_175,axiom,
    ~ v1181(constB0,bitIndex263) ).

fof(addAssignmentInitValue_174,axiom,
    ~ v1181(constB0,bitIndex262) ).

fof(bitBlastConstant_733,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex7) ).

fof(bitBlastConstant_732,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex6) ).

fof(bitBlastConstant_731,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex5) ).

fof(bitBlastConstant_730,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex4) ).

fof(bitBlastConstant_729,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex3) ).

fof(bitBlastConstant_728,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex2) ).

fof(bitBlastConstant_727,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex1) ).

fof(bitBlastConstant_726,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex0) ).

fof(addAssignmentInitValue_173,axiom,
    ~ v1181(constB0,bitIndex138) ).

fof(addAssignmentInitValue_172,axiom,
    ~ v1181(constB0,bitIndex137) ).

fof(addAssignmentInitValue_171,axiom,
    ~ v1181(constB0,bitIndex136) ).

fof(addAssignmentInitValue_170,axiom,
    ~ v1181(constB0,bitIndex135) ).

fof(addAssignmentInitValue_169,axiom,
    ~ v1181(constB0,bitIndex134) ).

fof(addAssignmentInitValue_168,axiom,
    ~ v1181(constB0,bitIndex133) ).

fof(addAssignmentInitValue_167,axiom,
    ~ v1181(constB0,bitIndex132) ).

fof(addAssignmentInitValue_166,axiom,
    ~ v1181(constB0,bitIndex131) ).

fof(bitBlastConstant_725,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex7) ).

fof(bitBlastConstant_724,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex6) ).

fof(bitBlastConstant_723,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex5) ).

fof(bitBlastConstant_722,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex4) ).

fof(bitBlastConstant_721,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex3) ).

fof(bitBlastConstant_720,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex2) ).

fof(bitBlastConstant_719,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex1) ).

fof(bitBlastConstant_718,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex0) ).

fof(addAssignment_717,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v2131(VarCurr,B)
      <=> v2133(VarCurr,B) ) ) ).

fof(addAssignment_716,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v2133(VarCurr,B)
      <=> v2135(VarCurr,B) ) ) ).

fof(addAssignment_715,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v2135(VarCurr,B)
      <=> v2137(VarCurr,B) ) ) ).

fof(addAssignment_714,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v2137(VarCurr,B)
      <=> v2349(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_65,axiom,
    ! [VarCurr] :
      ( ~ v2139(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v2349(VarCurr,B)
          <=> v2337(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_96,axiom,
    ! [VarCurr] :
      ( v2139(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v2349(VarCurr,B)
          <=> v2143(VarCurr,B) ) ) ) ).

fof(addAssignment_713,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v2337(VarCurr,B)
      <=> v2338(VarCurr,B) ) ) ).

fof(addAssignment_712,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v2338(VarCurr,B)
      <=> v2147(VarCurr,B) ) ) ).

fof(addAssignment_711,axiom,
    ! [VarCurr] :
      ( ( v2338(VarCurr,bitIndex14)
      <=> v2348(VarCurr,bitIndex6) )
      & ( v2338(VarCurr,bitIndex13)
      <=> v2348(VarCurr,bitIndex5) )
      & ( v2338(VarCurr,bitIndex12)
      <=> v2348(VarCurr,bitIndex4) )
      & ( v2338(VarCurr,bitIndex11)
      <=> v2348(VarCurr,bitIndex3) )
      & ( v2338(VarCurr,bitIndex10)
      <=> v2348(VarCurr,bitIndex2) )
      & ( v2338(VarCurr,bitIndex9)
      <=> v2348(VarCurr,bitIndex1) )
      & ( v2338(VarCurr,bitIndex8)
      <=> v2348(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_710,axiom,
    ! [VarCurr] :
      ( ( v2338(VarCurr,bitIndex76)
      <=> v2347(VarCurr,bitIndex61) )
      & ( v2338(VarCurr,bitIndex75)
      <=> v2347(VarCurr,bitIndex60) )
      & ( v2338(VarCurr,bitIndex74)
      <=> v2347(VarCurr,bitIndex59) )
      & ( v2338(VarCurr,bitIndex73)
      <=> v2347(VarCurr,bitIndex58) )
      & ( v2338(VarCurr,bitIndex72)
      <=> v2347(VarCurr,bitIndex57) )
      & ( v2338(VarCurr,bitIndex71)
      <=> v2347(VarCurr,bitIndex56) )
      & ( v2338(VarCurr,bitIndex70)
      <=> v2347(VarCurr,bitIndex55) )
      & ( v2338(VarCurr,bitIndex69)
      <=> v2347(VarCurr,bitIndex54) )
      & ( v2338(VarCurr,bitIndex68)
      <=> v2347(VarCurr,bitIndex53) )
      & ( v2338(VarCurr,bitIndex67)
      <=> v2347(VarCurr,bitIndex52) )
      & ( v2338(VarCurr,bitIndex66)
      <=> v2347(VarCurr,bitIndex51) )
      & ( v2338(VarCurr,bitIndex65)
      <=> v2347(VarCurr,bitIndex50) )
      & ( v2338(VarCurr,bitIndex64)
      <=> v2347(VarCurr,bitIndex49) )
      & ( v2338(VarCurr,bitIndex63)
      <=> v2347(VarCurr,bitIndex48) )
      & ( v2338(VarCurr,bitIndex62)
      <=> v2347(VarCurr,bitIndex47) )
      & ( v2338(VarCurr,bitIndex61)
      <=> v2347(VarCurr,bitIndex46) )
      & ( v2338(VarCurr,bitIndex60)
      <=> v2347(VarCurr,bitIndex45) )
      & ( v2338(VarCurr,bitIndex59)
      <=> v2347(VarCurr,bitIndex44) )
      & ( v2338(VarCurr,bitIndex58)
      <=> v2347(VarCurr,bitIndex43) )
      & ( v2338(VarCurr,bitIndex57)
      <=> v2347(VarCurr,bitIndex42) )
      & ( v2338(VarCurr,bitIndex56)
      <=> v2347(VarCurr,bitIndex41) )
      & ( v2338(VarCurr,bitIndex55)
      <=> v2347(VarCurr,bitIndex40) )
      & ( v2338(VarCurr,bitIndex54)
      <=> v2347(VarCurr,bitIndex39) )
      & ( v2338(VarCurr,bitIndex53)
      <=> v2347(VarCurr,bitIndex38) )
      & ( v2338(VarCurr,bitIndex52)
      <=> v2347(VarCurr,bitIndex37) )
      & ( v2338(VarCurr,bitIndex51)
      <=> v2347(VarCurr,bitIndex36) )
      & ( v2338(VarCurr,bitIndex50)
      <=> v2347(VarCurr,bitIndex35) )
      & ( v2338(VarCurr,bitIndex49)
      <=> v2347(VarCurr,bitIndex34) )
      & ( v2338(VarCurr,bitIndex48)
      <=> v2347(VarCurr,bitIndex33) )
      & ( v2338(VarCurr,bitIndex47)
      <=> v2347(VarCurr,bitIndex32) )
      & ( v2338(VarCurr,bitIndex46)
      <=> v2347(VarCurr,bitIndex31) )
      & ( v2338(VarCurr,bitIndex45)
      <=> v2347(VarCurr,bitIndex30) )
      & ( v2338(VarCurr,bitIndex44)
      <=> v2347(VarCurr,bitIndex29) )
      & ( v2338(VarCurr,bitIndex43)
      <=> v2347(VarCurr,bitIndex28) )
      & ( v2338(VarCurr,bitIndex42)
      <=> v2347(VarCurr,bitIndex27) )
      & ( v2338(VarCurr,bitIndex41)
      <=> v2347(VarCurr,bitIndex26) )
      & ( v2338(VarCurr,bitIndex40)
      <=> v2347(VarCurr,bitIndex25) )
      & ( v2338(VarCurr,bitIndex39)
      <=> v2347(VarCurr,bitIndex24) )
      & ( v2338(VarCurr,bitIndex38)
      <=> v2347(VarCurr,bitIndex23) )
      & ( v2338(VarCurr,bitIndex37)
      <=> v2347(VarCurr,bitIndex22) )
      & ( v2338(VarCurr,bitIndex36)
      <=> v2347(VarCurr,bitIndex21) )
      & ( v2338(VarCurr,bitIndex35)
      <=> v2347(VarCurr,bitIndex20) )
      & ( v2338(VarCurr,bitIndex34)
      <=> v2347(VarCurr,bitIndex19) )
      & ( v2338(VarCurr,bitIndex33)
      <=> v2347(VarCurr,bitIndex18) )
      & ( v2338(VarCurr,bitIndex32)
      <=> v2347(VarCurr,bitIndex17) )
      & ( v2338(VarCurr,bitIndex31)
      <=> v2347(VarCurr,bitIndex16) )
      & ( v2338(VarCurr,bitIndex30)
      <=> v2347(VarCurr,bitIndex15) )
      & ( v2338(VarCurr,bitIndex29)
      <=> v2347(VarCurr,bitIndex14) )
      & ( v2338(VarCurr,bitIndex28)
      <=> v2347(VarCurr,bitIndex13) )
      & ( v2338(VarCurr,bitIndex27)
      <=> v2347(VarCurr,bitIndex12) )
      & ( v2338(VarCurr,bitIndex26)
      <=> v2347(VarCurr,bitIndex11) )
      & ( v2338(VarCurr,bitIndex25)
      <=> v2347(VarCurr,bitIndex10) )
      & ( v2338(VarCurr,bitIndex24)
      <=> v2347(VarCurr,bitIndex9) )
      & ( v2338(VarCurr,bitIndex23)
      <=> v2347(VarCurr,bitIndex8) )
      & ( v2338(VarCurr,bitIndex22)
      <=> v2347(VarCurr,bitIndex7) )
      & ( v2338(VarCurr,bitIndex21)
      <=> v2347(VarCurr,bitIndex6) )
      & ( v2338(VarCurr,bitIndex20)
      <=> v2347(VarCurr,bitIndex5) )
      & ( v2338(VarCurr,bitIndex19)
      <=> v2347(VarCurr,bitIndex4) )
      & ( v2338(VarCurr,bitIndex18)
      <=> v2347(VarCurr,bitIndex3) )
      & ( v2338(VarCurr,bitIndex17)
      <=> v2347(VarCurr,bitIndex2) )
      & ( v2338(VarCurr,bitIndex16)
      <=> v2347(VarCurr,bitIndex1) )
      & ( v2338(VarCurr,bitIndex15)
      <=> v2347(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_709,axiom,
    ! [VarCurr] :
      ( ( v2338(VarCurr,bitIndex80)
      <=> v2346(VarCurr,bitIndex3) )
      & ( v2338(VarCurr,bitIndex79)
      <=> v2346(VarCurr,bitIndex2) )
      & ( v2338(VarCurr,bitIndex78)
      <=> v2346(VarCurr,bitIndex1) )
      & ( v2338(VarCurr,bitIndex77)
      <=> v2346(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_708,axiom,
    ! [VarCurr] :
      ( ( v2338(VarCurr,bitIndex84)
      <=> v2345(VarCurr,bitIndex3) )
      & ( v2338(VarCurr,bitIndex83)
      <=> v2345(VarCurr,bitIndex2) )
      & ( v2338(VarCurr,bitIndex82)
      <=> v2345(VarCurr,bitIndex1) )
      & ( v2338(VarCurr,bitIndex81)
      <=> v2345(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_707,axiom,
    ! [VarCurr] :
      ( ( v2338(VarCurr,bitIndex92)
      <=> v2344(VarCurr,bitIndex7) )
      & ( v2338(VarCurr,bitIndex91)
      <=> v2344(VarCurr,bitIndex6) )
      & ( v2338(VarCurr,bitIndex90)
      <=> v2344(VarCurr,bitIndex5) )
      & ( v2338(VarCurr,bitIndex89)
      <=> v2344(VarCurr,bitIndex4) )
      & ( v2338(VarCurr,bitIndex88)
      <=> v2344(VarCurr,bitIndex3) )
      & ( v2338(VarCurr,bitIndex87)
      <=> v2344(VarCurr,bitIndex2) )
      & ( v2338(VarCurr,bitIndex86)
      <=> v2344(VarCurr,bitIndex1) )
      & ( v2338(VarCurr,bitIndex85)
      <=> v2344(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_706,axiom,
    ! [VarCurr] :
      ( ( v2338(VarCurr,bitIndex108)
      <=> v2343(VarCurr,bitIndex15) )
      & ( v2338(VarCurr,bitIndex107)
      <=> v2343(VarCurr,bitIndex14) )
      & ( v2338(VarCurr,bitIndex106)
      <=> v2343(VarCurr,bitIndex13) )
      & ( v2338(VarCurr,bitIndex105)
      <=> v2343(VarCurr,bitIndex12) )
      & ( v2338(VarCurr,bitIndex104)
      <=> v2343(VarCurr,bitIndex11) )
      & ( v2338(VarCurr,bitIndex103)
      <=> v2343(VarCurr,bitIndex10) )
      & ( v2338(VarCurr,bitIndex102)
      <=> v2343(VarCurr,bitIndex9) )
      & ( v2338(VarCurr,bitIndex101)
      <=> v2343(VarCurr,bitIndex8) )
      & ( v2338(VarCurr,bitIndex100)
      <=> v2343(VarCurr,bitIndex7) )
      & ( v2338(VarCurr,bitIndex99)
      <=> v2343(VarCurr,bitIndex6) )
      & ( v2338(VarCurr,bitIndex98)
      <=> v2343(VarCurr,bitIndex5) )
      & ( v2338(VarCurr,bitIndex97)
      <=> v2343(VarCurr,bitIndex4) )
      & ( v2338(VarCurr,bitIndex96)
      <=> v2343(VarCurr,bitIndex3) )
      & ( v2338(VarCurr,bitIndex95)
      <=> v2343(VarCurr,bitIndex2) )
      & ( v2338(VarCurr,bitIndex94)
      <=> v2343(VarCurr,bitIndex1) )
      & ( v2338(VarCurr,bitIndex93)
      <=> v2343(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_705,axiom,
    ! [VarCurr] :
      ( ( v2338(VarCurr,bitIndex118)
      <=> v2342(VarCurr,bitIndex9) )
      & ( v2338(VarCurr,bitIndex117)
      <=> v2342(VarCurr,bitIndex8) )
      & ( v2338(VarCurr,bitIndex116)
      <=> v2342(VarCurr,bitIndex7) )
      & ( v2338(VarCurr,bitIndex115)
      <=> v2342(VarCurr,bitIndex6) )
      & ( v2338(VarCurr,bitIndex114)
      <=> v2342(VarCurr,bitIndex5) )
      & ( v2338(VarCurr,bitIndex113)
      <=> v2342(VarCurr,bitIndex4) )
      & ( v2338(VarCurr,bitIndex112)
      <=> v2342(VarCurr,bitIndex3) )
      & ( v2338(VarCurr,bitIndex111)
      <=> v2342(VarCurr,bitIndex2) )
      & ( v2338(VarCurr,bitIndex110)
      <=> v2342(VarCurr,bitIndex1) )
      & ( v2338(VarCurr,bitIndex109)
      <=> v2342(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_704,axiom,
    ! [VarCurr] :
      ( ( v2338(VarCurr,bitIndex120)
      <=> v2341(VarCurr,bitIndex1) )
      & ( v2338(VarCurr,bitIndex119)
      <=> v2341(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_703,axiom,
    ! [VarCurr] :
      ( ( v2338(VarCurr,bitIndex123)
      <=> v2340(VarCurr,bitIndex2) )
      & ( v2338(VarCurr,bitIndex122)
      <=> v2340(VarCurr,bitIndex1) )
      & ( v2338(VarCurr,bitIndex121)
      <=> v2340(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_702,axiom,
    ! [VarCurr] :
      ( ( v2338(VarCurr,bitIndex130)
      <=> v2339(VarCurr,bitIndex6) )
      & ( v2338(VarCurr,bitIndex129)
      <=> v2339(VarCurr,bitIndex5) )
      & ( v2338(VarCurr,bitIndex128)
      <=> v2339(VarCurr,bitIndex4) )
      & ( v2338(VarCurr,bitIndex127)
      <=> v2339(VarCurr,bitIndex3) )
      & ( v2338(VarCurr,bitIndex126)
      <=> v2339(VarCurr,bitIndex2) )
      & ( v2338(VarCurr,bitIndex125)
      <=> v2339(VarCurr,bitIndex1) )
      & ( v2338(VarCurr,bitIndex124)
      <=> v2339(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_701,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v2143(VarCurr,B)
      <=> v2315(VarCurr,B) ) ) ).

fof(addAssignment_700,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v2315(VarCurr,B)
      <=> v2145(VarCurr,B) ) ) ).

fof(addAssignment_699,axiom,
    ! [VarCurr] :
      ( ( v2315(VarCurr,bitIndex14)
      <=> v2334(VarCurr,bitIndex6) )
      & ( v2315(VarCurr,bitIndex13)
      <=> v2334(VarCurr,bitIndex5) )
      & ( v2315(VarCurr,bitIndex12)
      <=> v2334(VarCurr,bitIndex4) )
      & ( v2315(VarCurr,bitIndex11)
      <=> v2334(VarCurr,bitIndex3) )
      & ( v2315(VarCurr,bitIndex10)
      <=> v2334(VarCurr,bitIndex2) )
      & ( v2315(VarCurr,bitIndex9)
      <=> v2334(VarCurr,bitIndex1) )
      & ( v2315(VarCurr,bitIndex8)
      <=> v2334(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_698,axiom,
    ! [VarCurr] :
      ( ( v2315(VarCurr,bitIndex76)
      <=> v2332(VarCurr,bitIndex61) )
      & ( v2315(VarCurr,bitIndex75)
      <=> v2332(VarCurr,bitIndex60) )
      & ( v2315(VarCurr,bitIndex74)
      <=> v2332(VarCurr,bitIndex59) )
      & ( v2315(VarCurr,bitIndex73)
      <=> v2332(VarCurr,bitIndex58) )
      & ( v2315(VarCurr,bitIndex72)
      <=> v2332(VarCurr,bitIndex57) )
      & ( v2315(VarCurr,bitIndex71)
      <=> v2332(VarCurr,bitIndex56) )
      & ( v2315(VarCurr,bitIndex70)
      <=> v2332(VarCurr,bitIndex55) )
      & ( v2315(VarCurr,bitIndex69)
      <=> v2332(VarCurr,bitIndex54) )
      & ( v2315(VarCurr,bitIndex68)
      <=> v2332(VarCurr,bitIndex53) )
      & ( v2315(VarCurr,bitIndex67)
      <=> v2332(VarCurr,bitIndex52) )
      & ( v2315(VarCurr,bitIndex66)
      <=> v2332(VarCurr,bitIndex51) )
      & ( v2315(VarCurr,bitIndex65)
      <=> v2332(VarCurr,bitIndex50) )
      & ( v2315(VarCurr,bitIndex64)
      <=> v2332(VarCurr,bitIndex49) )
      & ( v2315(VarCurr,bitIndex63)
      <=> v2332(VarCurr,bitIndex48) )
      & ( v2315(VarCurr,bitIndex62)
      <=> v2332(VarCurr,bitIndex47) )
      & ( v2315(VarCurr,bitIndex61)
      <=> v2332(VarCurr,bitIndex46) )
      & ( v2315(VarCurr,bitIndex60)
      <=> v2332(VarCurr,bitIndex45) )
      & ( v2315(VarCurr,bitIndex59)
      <=> v2332(VarCurr,bitIndex44) )
      & ( v2315(VarCurr,bitIndex58)
      <=> v2332(VarCurr,bitIndex43) )
      & ( v2315(VarCurr,bitIndex57)
      <=> v2332(VarCurr,bitIndex42) )
      & ( v2315(VarCurr,bitIndex56)
      <=> v2332(VarCurr,bitIndex41) )
      & ( v2315(VarCurr,bitIndex55)
      <=> v2332(VarCurr,bitIndex40) )
      & ( v2315(VarCurr,bitIndex54)
      <=> v2332(VarCurr,bitIndex39) )
      & ( v2315(VarCurr,bitIndex53)
      <=> v2332(VarCurr,bitIndex38) )
      & ( v2315(VarCurr,bitIndex52)
      <=> v2332(VarCurr,bitIndex37) )
      & ( v2315(VarCurr,bitIndex51)
      <=> v2332(VarCurr,bitIndex36) )
      & ( v2315(VarCurr,bitIndex50)
      <=> v2332(VarCurr,bitIndex35) )
      & ( v2315(VarCurr,bitIndex49)
      <=> v2332(VarCurr,bitIndex34) )
      & ( v2315(VarCurr,bitIndex48)
      <=> v2332(VarCurr,bitIndex33) )
      & ( v2315(VarCurr,bitIndex47)
      <=> v2332(VarCurr,bitIndex32) )
      & ( v2315(VarCurr,bitIndex46)
      <=> v2332(VarCurr,bitIndex31) )
      & ( v2315(VarCurr,bitIndex45)
      <=> v2332(VarCurr,bitIndex30) )
      & ( v2315(VarCurr,bitIndex44)
      <=> v2332(VarCurr,bitIndex29) )
      & ( v2315(VarCurr,bitIndex43)
      <=> v2332(VarCurr,bitIndex28) )
      & ( v2315(VarCurr,bitIndex42)
      <=> v2332(VarCurr,bitIndex27) )
      & ( v2315(VarCurr,bitIndex41)
      <=> v2332(VarCurr,bitIndex26) )
      & ( v2315(VarCurr,bitIndex40)
      <=> v2332(VarCurr,bitIndex25) )
      & ( v2315(VarCurr,bitIndex39)
      <=> v2332(VarCurr,bitIndex24) )
      & ( v2315(VarCurr,bitIndex38)
      <=> v2332(VarCurr,bitIndex23) )
      & ( v2315(VarCurr,bitIndex37)
      <=> v2332(VarCurr,bitIndex22) )
      & ( v2315(VarCurr,bitIndex36)
      <=> v2332(VarCurr,bitIndex21) )
      & ( v2315(VarCurr,bitIndex35)
      <=> v2332(VarCurr,bitIndex20) )
      & ( v2315(VarCurr,bitIndex34)
      <=> v2332(VarCurr,bitIndex19) )
      & ( v2315(VarCurr,bitIndex33)
      <=> v2332(VarCurr,bitIndex18) )
      & ( v2315(VarCurr,bitIndex32)
      <=> v2332(VarCurr,bitIndex17) )
      & ( v2315(VarCurr,bitIndex31)
      <=> v2332(VarCurr,bitIndex16) )
      & ( v2315(VarCurr,bitIndex30)
      <=> v2332(VarCurr,bitIndex15) )
      & ( v2315(VarCurr,bitIndex29)
      <=> v2332(VarCurr,bitIndex14) )
      & ( v2315(VarCurr,bitIndex28)
      <=> v2332(VarCurr,bitIndex13) )
      & ( v2315(VarCurr,bitIndex27)
      <=> v2332(VarCurr,bitIndex12) )
      & ( v2315(VarCurr,bitIndex26)
      <=> v2332(VarCurr,bitIndex11) )
      & ( v2315(VarCurr,bitIndex25)
      <=> v2332(VarCurr,bitIndex10) )
      & ( v2315(VarCurr,bitIndex24)
      <=> v2332(VarCurr,bitIndex9) )
      & ( v2315(VarCurr,bitIndex23)
      <=> v2332(VarCurr,bitIndex8) )
      & ( v2315(VarCurr,bitIndex22)
      <=> v2332(VarCurr,bitIndex7) )
      & ( v2315(VarCurr,bitIndex21)
      <=> v2332(VarCurr,bitIndex6) )
      & ( v2315(VarCurr,bitIndex20)
      <=> v2332(VarCurr,bitIndex5) )
      & ( v2315(VarCurr,bitIndex19)
      <=> v2332(VarCurr,bitIndex4) )
      & ( v2315(VarCurr,bitIndex18)
      <=> v2332(VarCurr,bitIndex3) )
      & ( v2315(VarCurr,bitIndex17)
      <=> v2332(VarCurr,bitIndex2) )
      & ( v2315(VarCurr,bitIndex16)
      <=> v2332(VarCurr,bitIndex1) )
      & ( v2315(VarCurr,bitIndex15)
      <=> v2332(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_697,axiom,
    ! [VarCurr] :
      ( ( v2315(VarCurr,bitIndex80)
      <=> v2330(VarCurr,bitIndex3) )
      & ( v2315(VarCurr,bitIndex79)
      <=> v2330(VarCurr,bitIndex2) )
      & ( v2315(VarCurr,bitIndex78)
      <=> v2330(VarCurr,bitIndex1) )
      & ( v2315(VarCurr,bitIndex77)
      <=> v2330(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_696,axiom,
    ! [VarCurr] :
      ( ( v2315(VarCurr,bitIndex84)
      <=> v2328(VarCurr,bitIndex3) )
      & ( v2315(VarCurr,bitIndex83)
      <=> v2328(VarCurr,bitIndex2) )
      & ( v2315(VarCurr,bitIndex82)
      <=> v2328(VarCurr,bitIndex1) )
      & ( v2315(VarCurr,bitIndex81)
      <=> v2328(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_695,axiom,
    ! [VarCurr] :
      ( ( v2315(VarCurr,bitIndex92)
      <=> v2326(VarCurr,bitIndex7) )
      & ( v2315(VarCurr,bitIndex91)
      <=> v2326(VarCurr,bitIndex6) )
      & ( v2315(VarCurr,bitIndex90)
      <=> v2326(VarCurr,bitIndex5) )
      & ( v2315(VarCurr,bitIndex89)
      <=> v2326(VarCurr,bitIndex4) )
      & ( v2315(VarCurr,bitIndex88)
      <=> v2326(VarCurr,bitIndex3) )
      & ( v2315(VarCurr,bitIndex87)
      <=> v2326(VarCurr,bitIndex2) )
      & ( v2315(VarCurr,bitIndex86)
      <=> v2326(VarCurr,bitIndex1) )
      & ( v2315(VarCurr,bitIndex85)
      <=> v2326(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_694,axiom,
    ! [VarCurr] :
      ( ( v2315(VarCurr,bitIndex108)
      <=> v2324(VarCurr,bitIndex15) )
      & ( v2315(VarCurr,bitIndex107)
      <=> v2324(VarCurr,bitIndex14) )
      & ( v2315(VarCurr,bitIndex106)
      <=> v2324(VarCurr,bitIndex13) )
      & ( v2315(VarCurr,bitIndex105)
      <=> v2324(VarCurr,bitIndex12) )
      & ( v2315(VarCurr,bitIndex104)
      <=> v2324(VarCurr,bitIndex11) )
      & ( v2315(VarCurr,bitIndex103)
      <=> v2324(VarCurr,bitIndex10) )
      & ( v2315(VarCurr,bitIndex102)
      <=> v2324(VarCurr,bitIndex9) )
      & ( v2315(VarCurr,bitIndex101)
      <=> v2324(VarCurr,bitIndex8) )
      & ( v2315(VarCurr,bitIndex100)
      <=> v2324(VarCurr,bitIndex7) )
      & ( v2315(VarCurr,bitIndex99)
      <=> v2324(VarCurr,bitIndex6) )
      & ( v2315(VarCurr,bitIndex98)
      <=> v2324(VarCurr,bitIndex5) )
      & ( v2315(VarCurr,bitIndex97)
      <=> v2324(VarCurr,bitIndex4) )
      & ( v2315(VarCurr,bitIndex96)
      <=> v2324(VarCurr,bitIndex3) )
      & ( v2315(VarCurr,bitIndex95)
      <=> v2324(VarCurr,bitIndex2) )
      & ( v2315(VarCurr,bitIndex94)
      <=> v2324(VarCurr,bitIndex1) )
      & ( v2315(VarCurr,bitIndex93)
      <=> v2324(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_693,axiom,
    ! [VarCurr] :
      ( ( v2315(VarCurr,bitIndex118)
      <=> v2322(VarCurr,bitIndex9) )
      & ( v2315(VarCurr,bitIndex117)
      <=> v2322(VarCurr,bitIndex8) )
      & ( v2315(VarCurr,bitIndex116)
      <=> v2322(VarCurr,bitIndex7) )
      & ( v2315(VarCurr,bitIndex115)
      <=> v2322(VarCurr,bitIndex6) )
      & ( v2315(VarCurr,bitIndex114)
      <=> v2322(VarCurr,bitIndex5) )
      & ( v2315(VarCurr,bitIndex113)
      <=> v2322(VarCurr,bitIndex4) )
      & ( v2315(VarCurr,bitIndex112)
      <=> v2322(VarCurr,bitIndex3) )
      & ( v2315(VarCurr,bitIndex111)
      <=> v2322(VarCurr,bitIndex2) )
      & ( v2315(VarCurr,bitIndex110)
      <=> v2322(VarCurr,bitIndex1) )
      & ( v2315(VarCurr,bitIndex109)
      <=> v2322(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_692,axiom,
    ! [VarCurr] :
      ( ( v2315(VarCurr,bitIndex120)
      <=> v2320(VarCurr,bitIndex1) )
      & ( v2315(VarCurr,bitIndex119)
      <=> v2320(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_691,axiom,
    ! [VarCurr] :
      ( ( v2315(VarCurr,bitIndex123)
      <=> v2318(VarCurr,bitIndex2) )
      & ( v2315(VarCurr,bitIndex122)
      <=> v2318(VarCurr,bitIndex1) )
      & ( v2315(VarCurr,bitIndex121)
      <=> v2318(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_690,axiom,
    ! [VarCurr] :
      ( ( v2315(VarCurr,bitIndex130)
      <=> v2316(VarCurr,bitIndex6) )
      & ( v2315(VarCurr,bitIndex129)
      <=> v2316(VarCurr,bitIndex5) )
      & ( v2315(VarCurr,bitIndex128)
      <=> v2316(VarCurr,bitIndex4) )
      & ( v2315(VarCurr,bitIndex127)
      <=> v2316(VarCurr,bitIndex3) )
      & ( v2315(VarCurr,bitIndex126)
      <=> v2316(VarCurr,bitIndex2) )
      & ( v2315(VarCurr,bitIndex125)
      <=> v2316(VarCurr,bitIndex1) )
      & ( v2315(VarCurr,bitIndex124)
      <=> v2316(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_689,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v2326(VarCurr,B)
      <=> v2327(VarCurr,B) ) ) ).

fof(addAssignment_688,axiom,
    ! [VarCurr] :
      ( ( v2326(VarCurr,bitIndex7)
      <=> $false )
      & ( v2326(VarCurr,bitIndex6)
      <=> $false )
      & ( v2326(VarCurr,bitIndex5)
      <=> $false ) ) ).

fof(addCaseBooleanConditionEqualRanges1_23,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2300(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v2145(VarNext,B)
            <=> v2145(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_25,axiom,
    ! [VarNext] :
      ( v2300(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v2145(VarNext,B)
          <=> v2312(VarNext,B) ) ) ) ).

fof(addAssignment_687,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v2312(VarNext,B)
          <=> v2310(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_64,axiom,
    ! [VarCurr] :
      ( ~ v2309(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v2310(VarCurr,B)
          <=> v2147(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_95,axiom,
    ! [VarCurr] :
      ( v2309(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v2310(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_295,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2300(VarNext)
      <=> ( v2301(VarNext)
          & v2308(VarNext) ) ) ) ).

fof(addAssignment_686,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2308(VarNext)
      <=> v2306(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_294,axiom,
    ! [VarCurr] :
      ( v2306(VarCurr)
    <=> ( v2297(VarCurr)
        | v2309(VarCurr) ) ) ).

fof(writeUnaryOperator_132,axiom,
    ! [VarCurr] :
      ( ~ v2309(VarCurr)
    <=> v8(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_293,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2301(VarNext)
      <=> ( v2302(VarNext)
          & v1252(VarNext) ) ) ) ).

fof(writeUnaryOperator_131,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2302(VarNext)
      <=> v1259(VarNext) ) ) ).

fof(addAssignmentInitValueVector_28,axiom,
    ! [B] :
      ( range_7_0(B)
     => ( v2145(constB0,B)
      <=> $false ) ) ).

fof(addAssignment_685,axiom,
    ! [VarCurr] :
      ( v2297(VarCurr)
    <=> v6(VarCurr,bitIndex1) ) ).

fof(addAssignment_684,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v2147(VarCurr,B)
      <=> v2149(VarCurr,B) ) ) ).

fof(addAssignment_683,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v2149(VarCurr,B)
      <=> v2151(VarCurr,B) ) ) ).

fof(addAssignment_682,axiom,
    ! [VarCurr] :
      ( ( v2151(VarCurr,bitIndex7)
      <=> v2153(VarCurr,bitIndex400) )
      & ( v2151(VarCurr,bitIndex6)
      <=> v2153(VarCurr,bitIndex399) )
      & ( v2151(VarCurr,bitIndex5)
      <=> v2153(VarCurr,bitIndex398) )
      & ( v2151(VarCurr,bitIndex4)
      <=> v2153(VarCurr,bitIndex397) )
      & ( v2151(VarCurr,bitIndex3)
      <=> v2153(VarCurr,bitIndex396) )
      & ( v2151(VarCurr,bitIndex2)
      <=> v2153(VarCurr,bitIndex395) )
      & ( v2151(VarCurr,bitIndex1)
      <=> v2153(VarCurr,bitIndex394) )
      & ( v2151(VarCurr,bitIndex0)
      <=> v2153(VarCurr,bitIndex393) ) ) ).

fof(addAssignment_681,axiom,
    ! [VarNext] :
      ( ( v2153(VarNext,bitIndex400)
      <=> v2264(VarNext,bitIndex7) )
      & ( v2153(VarNext,bitIndex399)
      <=> v2264(VarNext,bitIndex6) )
      & ( v2153(VarNext,bitIndex398)
      <=> v2264(VarNext,bitIndex5) )
      & ( v2153(VarNext,bitIndex397)
      <=> v2264(VarNext,bitIndex4) )
      & ( v2153(VarNext,bitIndex396)
      <=> v2264(VarNext,bitIndex3) )
      & ( v2153(VarNext,bitIndex395)
      <=> v2264(VarNext,bitIndex2) )
      & ( v2153(VarNext,bitIndex394)
      <=> v2264(VarNext,bitIndex1) )
      & ( v2153(VarNext,bitIndex393)
      <=> v2264(VarNext,bitIndex0) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_1,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2265(VarNext)
       => ( ( v2264(VarNext,bitIndex130)
          <=> v2153(VarCurr,bitIndex523) )
          & ( v2264(VarNext,bitIndex129)
          <=> v2153(VarCurr,bitIndex522) )
          & ( v2264(VarNext,bitIndex128)
          <=> v2153(VarCurr,bitIndex521) )
          & ( v2264(VarNext,bitIndex127)
          <=> v2153(VarCurr,bitIndex520) )
          & ( v2264(VarNext,bitIndex126)
          <=> v2153(VarCurr,bitIndex519) )
          & ( v2264(VarNext,bitIndex125)
          <=> v2153(VarCurr,bitIndex518) )
          & ( v2264(VarNext,bitIndex124)
          <=> v2153(VarCurr,bitIndex517) )
          & ( v2264(VarNext,bitIndex123)
          <=> v2153(VarCurr,bitIndex516) )
          & ( v2264(VarNext,bitIndex122)
          <=> v2153(VarCurr,bitIndex515) )
          & ( v2264(VarNext,bitIndex121)
          <=> v2153(VarCurr,bitIndex514) )
          & ( v2264(VarNext,bitIndex120)
          <=> v2153(VarCurr,bitIndex513) )
          & ( v2264(VarNext,bitIndex119)
          <=> v2153(VarCurr,bitIndex512) )
          & ( v2264(VarNext,bitIndex118)
          <=> v2153(VarCurr,bitIndex511) )
          & ( v2264(VarNext,bitIndex117)
          <=> v2153(VarCurr,bitIndex510) )
          & ( v2264(VarNext,bitIndex116)
          <=> v2153(VarCurr,bitIndex509) )
          & ( v2264(VarNext,bitIndex115)
          <=> v2153(VarCurr,bitIndex508) )
          & ( v2264(VarNext,bitIndex114)
          <=> v2153(VarCurr,bitIndex507) )
          & ( v2264(VarNext,bitIndex113)
          <=> v2153(VarCurr,bitIndex506) )
          & ( v2264(VarNext,bitIndex112)
          <=> v2153(VarCurr,bitIndex505) )
          & ( v2264(VarNext,bitIndex111)
          <=> v2153(VarCurr,bitIndex504) )
          & ( v2264(VarNext,bitIndex110)
          <=> v2153(VarCurr,bitIndex503) )
          & ( v2264(VarNext,bitIndex109)
          <=> v2153(VarCurr,bitIndex502) )
          & ( v2264(VarNext,bitIndex108)
          <=> v2153(VarCurr,bitIndex501) )
          & ( v2264(VarNext,bitIndex107)
          <=> v2153(VarCurr,bitIndex500) )
          & ( v2264(VarNext,bitIndex106)
          <=> v2153(VarCurr,bitIndex499) )
          & ( v2264(VarNext,bitIndex105)
          <=> v2153(VarCurr,bitIndex498) )
          & ( v2264(VarNext,bitIndex104)
          <=> v2153(VarCurr,bitIndex497) )
          & ( v2264(VarNext,bitIndex103)
          <=> v2153(VarCurr,bitIndex496) )
          & ( v2264(VarNext,bitIndex102)
          <=> v2153(VarCurr,bitIndex495) )
          & ( v2264(VarNext,bitIndex101)
          <=> v2153(VarCurr,bitIndex494) )
          & ( v2264(VarNext,bitIndex100)
          <=> v2153(VarCurr,bitIndex493) )
          & ( v2264(VarNext,bitIndex99)
          <=> v2153(VarCurr,bitIndex492) )
          & ( v2264(VarNext,bitIndex98)
          <=> v2153(VarCurr,bitIndex491) )
          & ( v2264(VarNext,bitIndex97)
          <=> v2153(VarCurr,bitIndex490) )
          & ( v2264(VarNext,bitIndex96)
          <=> v2153(VarCurr,bitIndex489) )
          & ( v2264(VarNext,bitIndex95)
          <=> v2153(VarCurr,bitIndex488) )
          & ( v2264(VarNext,bitIndex94)
          <=> v2153(VarCurr,bitIndex487) )
          & ( v2264(VarNext,bitIndex93)
          <=> v2153(VarCurr,bitIndex486) )
          & ( v2264(VarNext,bitIndex92)
          <=> v2153(VarCurr,bitIndex485) )
          & ( v2264(VarNext,bitIndex91)
          <=> v2153(VarCurr,bitIndex484) )
          & ( v2264(VarNext,bitIndex90)
          <=> v2153(VarCurr,bitIndex483) )
          & ( v2264(VarNext,bitIndex89)
          <=> v2153(VarCurr,bitIndex482) )
          & ( v2264(VarNext,bitIndex88)
          <=> v2153(VarCurr,bitIndex481) )
          & ( v2264(VarNext,bitIndex87)
          <=> v2153(VarCurr,bitIndex480) )
          & ( v2264(VarNext,bitIndex86)
          <=> v2153(VarCurr,bitIndex479) )
          & ( v2264(VarNext,bitIndex85)
          <=> v2153(VarCurr,bitIndex478) )
          & ( v2264(VarNext,bitIndex84)
          <=> v2153(VarCurr,bitIndex477) )
          & ( v2264(VarNext,bitIndex83)
          <=> v2153(VarCurr,bitIndex476) )
          & ( v2264(VarNext,bitIndex82)
          <=> v2153(VarCurr,bitIndex475) )
          & ( v2264(VarNext,bitIndex81)
          <=> v2153(VarCurr,bitIndex474) )
          & ( v2264(VarNext,bitIndex80)
          <=> v2153(VarCurr,bitIndex473) )
          & ( v2264(VarNext,bitIndex79)
          <=> v2153(VarCurr,bitIndex472) )
          & ( v2264(VarNext,bitIndex78)
          <=> v2153(VarCurr,bitIndex471) )
          & ( v2264(VarNext,bitIndex77)
          <=> v2153(VarCurr,bitIndex470) )
          & ( v2264(VarNext,bitIndex76)
          <=> v2153(VarCurr,bitIndex469) )
          & ( v2264(VarNext,bitIndex75)
          <=> v2153(VarCurr,bitIndex468) )
          & ( v2264(VarNext,bitIndex74)
          <=> v2153(VarCurr,bitIndex467) )
          & ( v2264(VarNext,bitIndex73)
          <=> v2153(VarCurr,bitIndex466) )
          & ( v2264(VarNext,bitIndex72)
          <=> v2153(VarCurr,bitIndex465) )
          & ( v2264(VarNext,bitIndex71)
          <=> v2153(VarCurr,bitIndex464) )
          & ( v2264(VarNext,bitIndex70)
          <=> v2153(VarCurr,bitIndex463) )
          & ( v2264(VarNext,bitIndex69)
          <=> v2153(VarCurr,bitIndex462) )
          & ( v2264(VarNext,bitIndex68)
          <=> v2153(VarCurr,bitIndex461) )
          & ( v2264(VarNext,bitIndex67)
          <=> v2153(VarCurr,bitIndex460) )
          & ( v2264(VarNext,bitIndex66)
          <=> v2153(VarCurr,bitIndex459) )
          & ( v2264(VarNext,bitIndex65)
          <=> v2153(VarCurr,bitIndex458) )
          & ( v2264(VarNext,bitIndex64)
          <=> v2153(VarCurr,bitIndex457) )
          & ( v2264(VarNext,bitIndex63)
          <=> v2153(VarCurr,bitIndex456) )
          & ( v2264(VarNext,bitIndex62)
          <=> v2153(VarCurr,bitIndex455) )
          & ( v2264(VarNext,bitIndex61)
          <=> v2153(VarCurr,bitIndex454) )
          & ( v2264(VarNext,bitIndex60)
          <=> v2153(VarCurr,bitIndex453) )
          & ( v2264(VarNext,bitIndex59)
          <=> v2153(VarCurr,bitIndex452) )
          & ( v2264(VarNext,bitIndex58)
          <=> v2153(VarCurr,bitIndex451) )
          & ( v2264(VarNext,bitIndex57)
          <=> v2153(VarCurr,bitIndex450) )
          & ( v2264(VarNext,bitIndex56)
          <=> v2153(VarCurr,bitIndex449) )
          & ( v2264(VarNext,bitIndex55)
          <=> v2153(VarCurr,bitIndex448) )
          & ( v2264(VarNext,bitIndex54)
          <=> v2153(VarCurr,bitIndex447) )
          & ( v2264(VarNext,bitIndex53)
          <=> v2153(VarCurr,bitIndex446) )
          & ( v2264(VarNext,bitIndex52)
          <=> v2153(VarCurr,bitIndex445) )
          & ( v2264(VarNext,bitIndex51)
          <=> v2153(VarCurr,bitIndex444) )
          & ( v2264(VarNext,bitIndex50)
          <=> v2153(VarCurr,bitIndex443) )
          & ( v2264(VarNext,bitIndex49)
          <=> v2153(VarCurr,bitIndex442) )
          & ( v2264(VarNext,bitIndex48)
          <=> v2153(VarCurr,bitIndex441) )
          & ( v2264(VarNext,bitIndex47)
          <=> v2153(VarCurr,bitIndex440) )
          & ( v2264(VarNext,bitIndex46)
          <=> v2153(VarCurr,bitIndex439) )
          & ( v2264(VarNext,bitIndex45)
          <=> v2153(VarCurr,bitIndex438) )
          & ( v2264(VarNext,bitIndex44)
          <=> v2153(VarCurr,bitIndex437) )
          & ( v2264(VarNext,bitIndex43)
          <=> v2153(VarCurr,bitIndex436) )
          & ( v2264(VarNext,bitIndex42)
          <=> v2153(VarCurr,bitIndex435) )
          & ( v2264(VarNext,bitIndex41)
          <=> v2153(VarCurr,bitIndex434) )
          & ( v2264(VarNext,bitIndex40)
          <=> v2153(VarCurr,bitIndex433) )
          & ( v2264(VarNext,bitIndex39)
          <=> v2153(VarCurr,bitIndex432) )
          & ( v2264(VarNext,bitIndex38)
          <=> v2153(VarCurr,bitIndex431) )
          & ( v2264(VarNext,bitIndex37)
          <=> v2153(VarCurr,bitIndex430) )
          & ( v2264(VarNext,bitIndex36)
          <=> v2153(VarCurr,bitIndex429) )
          & ( v2264(VarNext,bitIndex35)
          <=> v2153(VarCurr,bitIndex428) )
          & ( v2264(VarNext,bitIndex34)
          <=> v2153(VarCurr,bitIndex427) )
          & ( v2264(VarNext,bitIndex33)
          <=> v2153(VarCurr,bitIndex426) )
          & ( v2264(VarNext,bitIndex32)
          <=> v2153(VarCurr,bitIndex425) )
          & ( v2264(VarNext,bitIndex31)
          <=> v2153(VarCurr,bitIndex424) )
          & ( v2264(VarNext,bitIndex30)
          <=> v2153(VarCurr,bitIndex423) )
          & ( v2264(VarNext,bitIndex29)
          <=> v2153(VarCurr,bitIndex422) )
          & ( v2264(VarNext,bitIndex28)
          <=> v2153(VarCurr,bitIndex421) )
          & ( v2264(VarNext,bitIndex27)
          <=> v2153(VarCurr,bitIndex420) )
          & ( v2264(VarNext,bitIndex26)
          <=> v2153(VarCurr,bitIndex419) )
          & ( v2264(VarNext,bitIndex25)
          <=> v2153(VarCurr,bitIndex418) )
          & ( v2264(VarNext,bitIndex24)
          <=> v2153(VarCurr,bitIndex417) )
          & ( v2264(VarNext,bitIndex23)
          <=> v2153(VarCurr,bitIndex416) )
          & ( v2264(VarNext,bitIndex22)
          <=> v2153(VarCurr,bitIndex415) )
          & ( v2264(VarNext,bitIndex21)
          <=> v2153(VarCurr,bitIndex414) )
          & ( v2264(VarNext,bitIndex20)
          <=> v2153(VarCurr,bitIndex413) )
          & ( v2264(VarNext,bitIndex19)
          <=> v2153(VarCurr,bitIndex412) )
          & ( v2264(VarNext,bitIndex18)
          <=> v2153(VarCurr,bitIndex411) )
          & ( v2264(VarNext,bitIndex17)
          <=> v2153(VarCurr,bitIndex410) )
          & ( v2264(VarNext,bitIndex16)
          <=> v2153(VarCurr,bitIndex409) )
          & ( v2264(VarNext,bitIndex15)
          <=> v2153(VarCurr,bitIndex408) )
          & ( v2264(VarNext,bitIndex14)
          <=> v2153(VarCurr,bitIndex407) )
          & ( v2264(VarNext,bitIndex13)
          <=> v2153(VarCurr,bitIndex406) )
          & ( v2264(VarNext,bitIndex12)
          <=> v2153(VarCurr,bitIndex405) )
          & ( v2264(VarNext,bitIndex11)
          <=> v2153(VarCurr,bitIndex404) )
          & ( v2264(VarNext,bitIndex10)
          <=> v2153(VarCurr,bitIndex403) )
          & ( v2264(VarNext,bitIndex9)
          <=> v2153(VarCurr,bitIndex402) )
          & ( v2264(VarNext,bitIndex8)
          <=> v2153(VarCurr,bitIndex401) )
          & ( v2264(VarNext,bitIndex7)
          <=> v2153(VarCurr,bitIndex400) )
          & ( v2264(VarNext,bitIndex6)
          <=> v2153(VarCurr,bitIndex399) )
          & ( v2264(VarNext,bitIndex5)
          <=> v2153(VarCurr,bitIndex398) )
          & ( v2264(VarNext,bitIndex4)
          <=> v2153(VarCurr,bitIndex397) )
          & ( v2264(VarNext,bitIndex3)
          <=> v2153(VarCurr,bitIndex396) )
          & ( v2264(VarNext,bitIndex2)
          <=> v2153(VarCurr,bitIndex395) )
          & ( v2264(VarNext,bitIndex1)
          <=> v2153(VarCurr,bitIndex394) )
          & ( v2264(VarNext,bitIndex0)
          <=> v2153(VarCurr,bitIndex393) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_24,axiom,
    ! [VarNext] :
      ( v2265(VarNext)
     => ! [B] :
          ( range_130_0(B)
         => ( v2264(VarNext,B)
          <=> v2292(VarNext,B) ) ) ) ).

fof(addAssignment_680,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_130_0(B)
         => ( v2292(VarNext,B)
          <=> v2290(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_17,axiom,
    ! [VarCurr] :
      ( ~ v2275(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v2290(VarCurr,B)
          <=> v2293(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_16,axiom,
    ! [VarCurr] :
      ( v2275(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v2290(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_9,axiom,
    ! [VarCurr] :
      ( ( ~ v2279(VarCurr)
        & ~ v2281(VarCurr) )
     => ! [B] :
          ( range_130_0(B)
         => ( v2293(VarCurr,B)
          <=> v2257(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_16,axiom,
    ! [VarCurr] :
      ( v2281(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v2293(VarCurr,B)
          <=> v2163(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0,axiom,
    ! [VarCurr] :
      ( v2279(VarCurr)
     => ( ( v2293(VarCurr,bitIndex130)
        <=> v2153(VarCurr,bitIndex392) )
        & ( v2293(VarCurr,bitIndex129)
        <=> v2153(VarCurr,bitIndex391) )
        & ( v2293(VarCurr,bitIndex128)
        <=> v2153(VarCurr,bitIndex390) )
        & ( v2293(VarCurr,bitIndex127)
        <=> v2153(VarCurr,bitIndex389) )
        & ( v2293(VarCurr,bitIndex126)
        <=> v2153(VarCurr,bitIndex388) )
        & ( v2293(VarCurr,bitIndex125)
        <=> v2153(VarCurr,bitIndex387) )
        & ( v2293(VarCurr,bitIndex124)
        <=> v2153(VarCurr,bitIndex386) )
        & ( v2293(VarCurr,bitIndex123)
        <=> v2153(VarCurr,bitIndex385) )
        & ( v2293(VarCurr,bitIndex122)
        <=> v2153(VarCurr,bitIndex384) )
        & ( v2293(VarCurr,bitIndex121)
        <=> v2153(VarCurr,bitIndex383) )
        & ( v2293(VarCurr,bitIndex120)
        <=> v2153(VarCurr,bitIndex382) )
        & ( v2293(VarCurr,bitIndex119)
        <=> v2153(VarCurr,bitIndex381) )
        & ( v2293(VarCurr,bitIndex118)
        <=> v2153(VarCurr,bitIndex380) )
        & ( v2293(VarCurr,bitIndex117)
        <=> v2153(VarCurr,bitIndex379) )
        & ( v2293(VarCurr,bitIndex116)
        <=> v2153(VarCurr,bitIndex378) )
        & ( v2293(VarCurr,bitIndex115)
        <=> v2153(VarCurr,bitIndex377) )
        & ( v2293(VarCurr,bitIndex114)
        <=> v2153(VarCurr,bitIndex376) )
        & ( v2293(VarCurr,bitIndex113)
        <=> v2153(VarCurr,bitIndex375) )
        & ( v2293(VarCurr,bitIndex112)
        <=> v2153(VarCurr,bitIndex374) )
        & ( v2293(VarCurr,bitIndex111)
        <=> v2153(VarCurr,bitIndex373) )
        & ( v2293(VarCurr,bitIndex110)
        <=> v2153(VarCurr,bitIndex372) )
        & ( v2293(VarCurr,bitIndex109)
        <=> v2153(VarCurr,bitIndex371) )
        & ( v2293(VarCurr,bitIndex108)
        <=> v2153(VarCurr,bitIndex370) )
        & ( v2293(VarCurr,bitIndex107)
        <=> v2153(VarCurr,bitIndex369) )
        & ( v2293(VarCurr,bitIndex106)
        <=> v2153(VarCurr,bitIndex368) )
        & ( v2293(VarCurr,bitIndex105)
        <=> v2153(VarCurr,bitIndex367) )
        & ( v2293(VarCurr,bitIndex104)
        <=> v2153(VarCurr,bitIndex366) )
        & ( v2293(VarCurr,bitIndex103)
        <=> v2153(VarCurr,bitIndex365) )
        & ( v2293(VarCurr,bitIndex102)
        <=> v2153(VarCurr,bitIndex364) )
        & ( v2293(VarCurr,bitIndex101)
        <=> v2153(VarCurr,bitIndex363) )
        & ( v2293(VarCurr,bitIndex100)
        <=> v2153(VarCurr,bitIndex362) )
        & ( v2293(VarCurr,bitIndex99)
        <=> v2153(VarCurr,bitIndex361) )
        & ( v2293(VarCurr,bitIndex98)
        <=> v2153(VarCurr,bitIndex360) )
        & ( v2293(VarCurr,bitIndex97)
        <=> v2153(VarCurr,bitIndex359) )
        & ( v2293(VarCurr,bitIndex96)
        <=> v2153(VarCurr,bitIndex358) )
        & ( v2293(VarCurr,bitIndex95)
        <=> v2153(VarCurr,bitIndex357) )
        & ( v2293(VarCurr,bitIndex94)
        <=> v2153(VarCurr,bitIndex356) )
        & ( v2293(VarCurr,bitIndex93)
        <=> v2153(VarCurr,bitIndex355) )
        & ( v2293(VarCurr,bitIndex92)
        <=> v2153(VarCurr,bitIndex354) )
        & ( v2293(VarCurr,bitIndex91)
        <=> v2153(VarCurr,bitIndex353) )
        & ( v2293(VarCurr,bitIndex90)
        <=> v2153(VarCurr,bitIndex352) )
        & ( v2293(VarCurr,bitIndex89)
        <=> v2153(VarCurr,bitIndex351) )
        & ( v2293(VarCurr,bitIndex88)
        <=> v2153(VarCurr,bitIndex350) )
        & ( v2293(VarCurr,bitIndex87)
        <=> v2153(VarCurr,bitIndex349) )
        & ( v2293(VarCurr,bitIndex86)
        <=> v2153(VarCurr,bitIndex348) )
        & ( v2293(VarCurr,bitIndex85)
        <=> v2153(VarCurr,bitIndex347) )
        & ( v2293(VarCurr,bitIndex84)
        <=> v2153(VarCurr,bitIndex346) )
        & ( v2293(VarCurr,bitIndex83)
        <=> v2153(VarCurr,bitIndex345) )
        & ( v2293(VarCurr,bitIndex82)
        <=> v2153(VarCurr,bitIndex344) )
        & ( v2293(VarCurr,bitIndex81)
        <=> v2153(VarCurr,bitIndex343) )
        & ( v2293(VarCurr,bitIndex80)
        <=> v2153(VarCurr,bitIndex342) )
        & ( v2293(VarCurr,bitIndex79)
        <=> v2153(VarCurr,bitIndex341) )
        & ( v2293(VarCurr,bitIndex78)
        <=> v2153(VarCurr,bitIndex340) )
        & ( v2293(VarCurr,bitIndex77)
        <=> v2153(VarCurr,bitIndex339) )
        & ( v2293(VarCurr,bitIndex76)
        <=> v2153(VarCurr,bitIndex338) )
        & ( v2293(VarCurr,bitIndex75)
        <=> v2153(VarCurr,bitIndex337) )
        & ( v2293(VarCurr,bitIndex74)
        <=> v2153(VarCurr,bitIndex336) )
        & ( v2293(VarCurr,bitIndex73)
        <=> v2153(VarCurr,bitIndex335) )
        & ( v2293(VarCurr,bitIndex72)
        <=> v2153(VarCurr,bitIndex334) )
        & ( v2293(VarCurr,bitIndex71)
        <=> v2153(VarCurr,bitIndex333) )
        & ( v2293(VarCurr,bitIndex70)
        <=> v2153(VarCurr,bitIndex332) )
        & ( v2293(VarCurr,bitIndex69)
        <=> v2153(VarCurr,bitIndex331) )
        & ( v2293(VarCurr,bitIndex68)
        <=> v2153(VarCurr,bitIndex330) )
        & ( v2293(VarCurr,bitIndex67)
        <=> v2153(VarCurr,bitIndex329) )
        & ( v2293(VarCurr,bitIndex66)
        <=> v2153(VarCurr,bitIndex328) )
        & ( v2293(VarCurr,bitIndex65)
        <=> v2153(VarCurr,bitIndex327) )
        & ( v2293(VarCurr,bitIndex64)
        <=> v2153(VarCurr,bitIndex326) )
        & ( v2293(VarCurr,bitIndex63)
        <=> v2153(VarCurr,bitIndex325) )
        & ( v2293(VarCurr,bitIndex62)
        <=> v2153(VarCurr,bitIndex324) )
        & ( v2293(VarCurr,bitIndex61)
        <=> v2153(VarCurr,bitIndex323) )
        & ( v2293(VarCurr,bitIndex60)
        <=> v2153(VarCurr,bitIndex322) )
        & ( v2293(VarCurr,bitIndex59)
        <=> v2153(VarCurr,bitIndex321) )
        & ( v2293(VarCurr,bitIndex58)
        <=> v2153(VarCurr,bitIndex320) )
        & ( v2293(VarCurr,bitIndex57)
        <=> v2153(VarCurr,bitIndex319) )
        & ( v2293(VarCurr,bitIndex56)
        <=> v2153(VarCurr,bitIndex318) )
        & ( v2293(VarCurr,bitIndex55)
        <=> v2153(VarCurr,bitIndex317) )
        & ( v2293(VarCurr,bitIndex54)
        <=> v2153(VarCurr,bitIndex316) )
        & ( v2293(VarCurr,bitIndex53)
        <=> v2153(VarCurr,bitIndex315) )
        & ( v2293(VarCurr,bitIndex52)
        <=> v2153(VarCurr,bitIndex314) )
        & ( v2293(VarCurr,bitIndex51)
        <=> v2153(VarCurr,bitIndex313) )
        & ( v2293(VarCurr,bitIndex50)
        <=> v2153(VarCurr,bitIndex312) )
        & ( v2293(VarCurr,bitIndex49)
        <=> v2153(VarCurr,bitIndex311) )
        & ( v2293(VarCurr,bitIndex48)
        <=> v2153(VarCurr,bitIndex310) )
        & ( v2293(VarCurr,bitIndex47)
        <=> v2153(VarCurr,bitIndex309) )
        & ( v2293(VarCurr,bitIndex46)
        <=> v2153(VarCurr,bitIndex308) )
        & ( v2293(VarCurr,bitIndex45)
        <=> v2153(VarCurr,bitIndex307) )
        & ( v2293(VarCurr,bitIndex44)
        <=> v2153(VarCurr,bitIndex306) )
        & ( v2293(VarCurr,bitIndex43)
        <=> v2153(VarCurr,bitIndex305) )
        & ( v2293(VarCurr,bitIndex42)
        <=> v2153(VarCurr,bitIndex304) )
        & ( v2293(VarCurr,bitIndex41)
        <=> v2153(VarCurr,bitIndex303) )
        & ( v2293(VarCurr,bitIndex40)
        <=> v2153(VarCurr,bitIndex302) )
        & ( v2293(VarCurr,bitIndex39)
        <=> v2153(VarCurr,bitIndex301) )
        & ( v2293(VarCurr,bitIndex38)
        <=> v2153(VarCurr,bitIndex300) )
        & ( v2293(VarCurr,bitIndex37)
        <=> v2153(VarCurr,bitIndex299) )
        & ( v2293(VarCurr,bitIndex36)
        <=> v2153(VarCurr,bitIndex298) )
        & ( v2293(VarCurr,bitIndex35)
        <=> v2153(VarCurr,bitIndex297) )
        & ( v2293(VarCurr,bitIndex34)
        <=> v2153(VarCurr,bitIndex296) )
        & ( v2293(VarCurr,bitIndex33)
        <=> v2153(VarCurr,bitIndex295) )
        & ( v2293(VarCurr,bitIndex32)
        <=> v2153(VarCurr,bitIndex294) )
        & ( v2293(VarCurr,bitIndex31)
        <=> v2153(VarCurr,bitIndex293) )
        & ( v2293(VarCurr,bitIndex30)
        <=> v2153(VarCurr,bitIndex292) )
        & ( v2293(VarCurr,bitIndex29)
        <=> v2153(VarCurr,bitIndex291) )
        & ( v2293(VarCurr,bitIndex28)
        <=> v2153(VarCurr,bitIndex290) )
        & ( v2293(VarCurr,bitIndex27)
        <=> v2153(VarCurr,bitIndex289) )
        & ( v2293(VarCurr,bitIndex26)
        <=> v2153(VarCurr,bitIndex288) )
        & ( v2293(VarCurr,bitIndex25)
        <=> v2153(VarCurr,bitIndex287) )
        & ( v2293(VarCurr,bitIndex24)
        <=> v2153(VarCurr,bitIndex286) )
        & ( v2293(VarCurr,bitIndex23)
        <=> v2153(VarCurr,bitIndex285) )
        & ( v2293(VarCurr,bitIndex22)
        <=> v2153(VarCurr,bitIndex284) )
        & ( v2293(VarCurr,bitIndex21)
        <=> v2153(VarCurr,bitIndex283) )
        & ( v2293(VarCurr,bitIndex20)
        <=> v2153(VarCurr,bitIndex282) )
        & ( v2293(VarCurr,bitIndex19)
        <=> v2153(VarCurr,bitIndex281) )
        & ( v2293(VarCurr,bitIndex18)
        <=> v2153(VarCurr,bitIndex280) )
        & ( v2293(VarCurr,bitIndex17)
        <=> v2153(VarCurr,bitIndex279) )
        & ( v2293(VarCurr,bitIndex16)
        <=> v2153(VarCurr,bitIndex278) )
        & ( v2293(VarCurr,bitIndex15)
        <=> v2153(VarCurr,bitIndex277) )
        & ( v2293(VarCurr,bitIndex14)
        <=> v2153(VarCurr,bitIndex276) )
        & ( v2293(VarCurr,bitIndex13)
        <=> v2153(VarCurr,bitIndex275) )
        & ( v2293(VarCurr,bitIndex12)
        <=> v2153(VarCurr,bitIndex274) )
        & ( v2293(VarCurr,bitIndex11)
        <=> v2153(VarCurr,bitIndex273) )
        & ( v2293(VarCurr,bitIndex10)
        <=> v2153(VarCurr,bitIndex272) )
        & ( v2293(VarCurr,bitIndex9)
        <=> v2153(VarCurr,bitIndex271) )
        & ( v2293(VarCurr,bitIndex8)
        <=> v2153(VarCurr,bitIndex270) )
        & ( v2293(VarCurr,bitIndex7)
        <=> v2153(VarCurr,bitIndex269) )
        & ( v2293(VarCurr,bitIndex6)
        <=> v2153(VarCurr,bitIndex268) )
        & ( v2293(VarCurr,bitIndex5)
        <=> v2153(VarCurr,bitIndex267) )
        & ( v2293(VarCurr,bitIndex4)
        <=> v2153(VarCurr,bitIndex266) )
        & ( v2293(VarCurr,bitIndex3)
        <=> v2153(VarCurr,bitIndex265) )
        & ( v2293(VarCurr,bitIndex2)
        <=> v2153(VarCurr,bitIndex264) )
        & ( v2293(VarCurr,bitIndex1)
        <=> v2153(VarCurr,bitIndex263) )
        & ( v2293(VarCurr,bitIndex0)
        <=> v2153(VarCurr,bitIndex262) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_292,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2265(VarNext)
      <=> ( v2266(VarNext)
          & v2273(VarNext) ) ) ) ).

fof(addAssignment_679,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2273(VarNext)
      <=> v2271(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_291,axiom,
    ! [VarCurr] :
      ( v2271(VarCurr)
    <=> ( v2274(VarCurr)
        & v2286(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_290,axiom,
    ! [VarCurr] :
      ( v2286(VarCurr)
    <=> ( v2287(VarCurr)
        | v2275(VarCurr) ) ) ).

fof(writeUnaryOperator_130,axiom,
    ! [VarCurr] :
      ( ~ v2287(VarCurr)
    <=> v2288(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_140,axiom,
    ! [VarCurr] :
      ( v2288(VarCurr)
    <=> ( ( v2289(VarCurr,bitIndex1)
        <=> $false )
        & ( v2289(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_678,axiom,
    ! [VarCurr] :
      ( v2289(VarCurr,bitIndex0)
    <=> v2155(VarCurr) ) ).

fof(addAssignment_677,axiom,
    ! [VarCurr] :
      ( v2289(VarCurr,bitIndex1)
    <=> v29(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_289,axiom,
    ! [VarCurr] :
      ( v2274(VarCurr)
    <=> ( v2275(VarCurr)
        | v2276(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_288,axiom,
    ! [VarCurr] :
      ( v2276(VarCurr)
    <=> ( v2277(VarCurr)
        & v2285(VarCurr) ) ) ).

fof(writeUnaryOperator_129,axiom,
    ! [VarCurr] :
      ( ~ v2285(VarCurr)
    <=> v2275(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_287,axiom,
    ! [VarCurr] :
      ( v2277(VarCurr)
    <=> ( v2278(VarCurr)
        | v2283(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_139,axiom,
    ! [VarCurr] :
      ( v2283(VarCurr)
    <=> ( ( v2284(VarCurr,bitIndex1)
        <=> $true )
        & ( v2284(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_676,axiom,
    ! [VarCurr] :
      ( v2284(VarCurr,bitIndex0)
    <=> v2155(VarCurr) ) ).

fof(addAssignment_675,axiom,
    ! [VarCurr] :
      ( v2284(VarCurr,bitIndex1)
    <=> v29(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_286,axiom,
    ! [VarCurr] :
      ( v2278(VarCurr)
    <=> ( v2279(VarCurr)
        | v2281(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_138,axiom,
    ! [VarCurr] :
      ( v2281(VarCurr)
    <=> ( ( v2282(VarCurr,bitIndex1)
        <=> $true )
        & ( v2282(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_674,axiom,
    ! [VarCurr] :
      ( v2282(VarCurr,bitIndex0)
    <=> v2155(VarCurr) ) ).

fof(addAssignment_673,axiom,
    ! [VarCurr] :
      ( v2282(VarCurr,bitIndex1)
    <=> v29(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_137,axiom,
    ! [VarCurr] :
      ( v2279(VarCurr)
    <=> ( ( v2280(VarCurr,bitIndex1)
        <=> $false )
        & ( v2280(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_672,axiom,
    ! [VarCurr] :
      ( v2280(VarCurr,bitIndex0)
    <=> v2155(VarCurr) ) ).

fof(addAssignment_671,axiom,
    ! [VarCurr] :
      ( v2280(VarCurr,bitIndex1)
    <=> v29(VarCurr) ) ).

fof(writeUnaryOperator_128,axiom,
    ! [VarCurr] :
      ( ~ v2275(VarCurr)
    <=> v27(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_285,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2266(VarNext)
      <=> ( v2267(VarNext)
          & v2173(VarNext) ) ) ) ).

fof(writeUnaryOperator_127,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2267(VarNext)
      <=> v2182(VarNext) ) ) ).

fof(addAssignment_670,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v2257(VarCurr,B)
      <=> v2262(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_63,axiom,
    ! [VarCurr] :
      ( ~ v2259(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v2262(VarCurr,B)
          <=> v2261(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_94,axiom,
    ! [VarCurr] :
      ( v2259(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v2262(VarCurr,B)
          <=> v2234(VarCurr,B) ) ) ) ).

fof(addAssignment_669,axiom,
    ! [VarCurr] :
      ( ( v2261(VarCurr,bitIndex7)
      <=> v2153(VarCurr,bitIndex269) )
      & ( v2261(VarCurr,bitIndex6)
      <=> v2153(VarCurr,bitIndex268) )
      & ( v2261(VarCurr,bitIndex5)
      <=> v2153(VarCurr,bitIndex267) )
      & ( v2261(VarCurr,bitIndex4)
      <=> v2153(VarCurr,bitIndex266) )
      & ( v2261(VarCurr,bitIndex3)
      <=> v2153(VarCurr,bitIndex265) )
      & ( v2261(VarCurr,bitIndex2)
      <=> v2153(VarCurr,bitIndex264) )
      & ( v2261(VarCurr,bitIndex1)
      <=> v2153(VarCurr,bitIndex263) )
      & ( v2261(VarCurr,bitIndex0)
      <=> v2153(VarCurr,bitIndex262) ) ) ).

fof(addAssignment_668,axiom,
    ! [VarCurr] :
      ( v2259(VarCurr)
    <=> v2167(VarCurr,bitIndex1) ) ).

fof(addAssignment_667,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v2163(VarCurr,B)
      <=> v2255(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_62,axiom,
    ! [VarCurr] :
      ( ~ v2165(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v2255(VarCurr,B)
          <=> v2246(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_93,axiom,
    ! [VarCurr] :
      ( v2165(VarCurr)
     => ! [B] :
          ( range_130_0(B)
         => ( v2255(VarCurr,B)
          <=> v2234(VarCurr,B) ) ) ) ).

fof(addAssignment_666,axiom,
    ! [VarCurr] :
      ( ( v2246(VarCurr,bitIndex7)
      <=> v2153(VarCurr,bitIndex400) )
      & ( v2246(VarCurr,bitIndex6)
      <=> v2153(VarCurr,bitIndex399) )
      & ( v2246(VarCurr,bitIndex5)
      <=> v2153(VarCurr,bitIndex398) )
      & ( v2246(VarCurr,bitIndex4)
      <=> v2153(VarCurr,bitIndex397) )
      & ( v2246(VarCurr,bitIndex3)
      <=> v2153(VarCurr,bitIndex396) )
      & ( v2246(VarCurr,bitIndex2)
      <=> v2153(VarCurr,bitIndex395) )
      & ( v2246(VarCurr,bitIndex1)
      <=> v2153(VarCurr,bitIndex394) )
      & ( v2246(VarCurr,bitIndex0)
      <=> v2153(VarCurr,bitIndex393) ) ) ).

fof(addAssignmentInitValue_165,axiom,
    ~ v2153(constB0,bitIndex523) ).

fof(addAssignmentInitValue_164,axiom,
    ~ v2153(constB0,bitIndex522) ).

fof(addAssignmentInitValue_163,axiom,
    ~ v2153(constB0,bitIndex521) ).

fof(addAssignmentInitValue_162,axiom,
    ~ v2153(constB0,bitIndex520) ).

fof(addAssignmentInitValue_161,axiom,
    ~ v2153(constB0,bitIndex519) ).

fof(addAssignmentInitValue_160,axiom,
    ~ v2153(constB0,bitIndex518) ).

fof(addAssignmentInitValue_159,axiom,
    ~ v2153(constB0,bitIndex517) ).

fof(addAssignmentInitValue_158,axiom,
    ~ v2153(constB0,bitIndex400) ).

fof(addAssignmentInitValue_157,axiom,
    ~ v2153(constB0,bitIndex399) ).

fof(addAssignmentInitValue_156,axiom,
    ~ v2153(constB0,bitIndex398) ).

fof(addAssignmentInitValue_155,axiom,
    ~ v2153(constB0,bitIndex397) ).

fof(addAssignmentInitValue_154,axiom,
    ~ v2153(constB0,bitIndex396) ).

fof(addAssignmentInitValue_153,axiom,
    ~ v2153(constB0,bitIndex395) ).

fof(addAssignmentInitValue_152,axiom,
    ~ v2153(constB0,bitIndex394) ).

fof(addAssignmentInitValue_151,axiom,
    ~ v2153(constB0,bitIndex393) ).

fof(bitBlastConstant_717,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex130) ).

fof(bitBlastConstant_716,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex129) ).

fof(bitBlastConstant_715,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex128) ).

fof(bitBlastConstant_714,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex127) ).

fof(bitBlastConstant_713,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex126) ).

fof(bitBlastConstant_712,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex125) ).

fof(bitBlastConstant_711,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex124) ).

fof(bitBlastConstant_710,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex7) ).

fof(bitBlastConstant_709,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex6) ).

fof(bitBlastConstant_708,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex5) ).

fof(bitBlastConstant_707,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex4) ).

fof(bitBlastConstant_706,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex3) ).

fof(bitBlastConstant_705,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex2) ).

fof(bitBlastConstant_704,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex1) ).

fof(bitBlastConstant_703,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex0) ).

fof(addAssignmentInitValue_150,axiom,
    ~ v2153(constB0,bitIndex392) ).

fof(addAssignmentInitValue_149,axiom,
    ~ v2153(constB0,bitIndex391) ).

fof(addAssignmentInitValue_148,axiom,
    ~ v2153(constB0,bitIndex390) ).

fof(addAssignmentInitValue_147,axiom,
    ~ v2153(constB0,bitIndex389) ).

fof(addAssignmentInitValue_146,axiom,
    ~ v2153(constB0,bitIndex388) ).

fof(addAssignmentInitValue_145,axiom,
    ~ v2153(constB0,bitIndex387) ).

fof(addAssignmentInitValue_144,axiom,
    ~ v2153(constB0,bitIndex386) ).

fof(addAssignmentInitValue_143,axiom,
    ~ v2153(constB0,bitIndex269) ).

fof(addAssignmentInitValue_142,axiom,
    ~ v2153(constB0,bitIndex268) ).

fof(addAssignmentInitValue_141,axiom,
    ~ v2153(constB0,bitIndex267) ).

fof(addAssignmentInitValue_140,axiom,
    ~ v2153(constB0,bitIndex266) ).

fof(addAssignmentInitValue_139,axiom,
    ~ v2153(constB0,bitIndex265) ).

fof(addAssignmentInitValue_138,axiom,
    ~ v2153(constB0,bitIndex264) ).

fof(addAssignmentInitValue_137,axiom,
    ~ v2153(constB0,bitIndex263) ).

fof(addAssignmentInitValue_136,axiom,
    ~ v2153(constB0,bitIndex262) ).

fof(bitBlastConstant_702,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex130) ).

fof(bitBlastConstant_701,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex129) ).

fof(bitBlastConstant_700,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex128) ).

fof(bitBlastConstant_699,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex127) ).

fof(bitBlastConstant_698,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex126) ).

fof(bitBlastConstant_697,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex125) ).

fof(bitBlastConstant_696,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex124) ).

fof(bitBlastConstant_695,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex7) ).

fof(bitBlastConstant_694,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex6) ).

fof(bitBlastConstant_693,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex5) ).

fof(bitBlastConstant_692,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex4) ).

fof(bitBlastConstant_691,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex3) ).

fof(bitBlastConstant_690,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex2) ).

fof(bitBlastConstant_689,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex1) ).

fof(bitBlastConstant_688,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00000000(bitIndex0) ).

fof(addAssignmentInitValue_135,axiom,
    ~ v2153(constB0,bitIndex261) ).

fof(addAssignmentInitValue_134,axiom,
    ~ v2153(constB0,bitIndex260) ).

fof(addAssignmentInitValue_133,axiom,
    ~ v2153(constB0,bitIndex259) ).

fof(addAssignmentInitValue_132,axiom,
    ~ v2153(constB0,bitIndex258) ).

fof(addAssignmentInitValue_131,axiom,
    ~ v2153(constB0,bitIndex257) ).

fof(addAssignmentInitValue_130,axiom,
    ~ v2153(constB0,bitIndex256) ).

fof(addAssignmentInitValue_129,axiom,
    ~ v2153(constB0,bitIndex255) ).

fof(bitBlastConstant_687,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex130) ).

fof(bitBlastConstant_686,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex129) ).

fof(bitBlastConstant_685,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex128) ).

fof(bitBlastConstant_684,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex127) ).

fof(bitBlastConstant_683,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex126) ).

fof(bitBlastConstant_682,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex125) ).

fof(bitBlastConstant_681,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex124) ).

fof(addAssignmentInitValue_128,axiom,
    ~ v2153(constB0,bitIndex130) ).

fof(addAssignmentInitValue_127,axiom,
    ~ v2153(constB0,bitIndex129) ).

fof(addAssignmentInitValue_126,axiom,
    ~ v2153(constB0,bitIndex128) ).

fof(addAssignmentInitValue_125,axiom,
    ~ v2153(constB0,bitIndex127) ).

fof(addAssignmentInitValue_124,axiom,
    ~ v2153(constB0,bitIndex126) ).

fof(addAssignmentInitValue_123,axiom,
    ~ v2153(constB0,bitIndex125) ).

fof(addAssignmentInitValue_122,axiom,
    ~ v2153(constB0,bitIndex124) ).

fof(bitBlastConstant_680,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex130) ).

fof(bitBlastConstant_679,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex129) ).

fof(bitBlastConstant_678,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex128) ).

fof(bitBlastConstant_677,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex127) ).

fof(bitBlastConstant_676,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex126) ).

fof(bitBlastConstant_675,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex125) ).

fof(bitBlastConstant_674,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex124) ).

fof(addAssignment_665,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v2234(VarCurr,B)
      <=> v2236(VarCurr,B) ) ) ).

fof(addAssignment_664,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v2236(VarCurr,B)
      <=> v2238(VarCurr,B) ) ) ).

fof(addAssignment_663,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v2238(VarCurr,B)
      <=> v2240(VarCurr,B) ) ) ).

fof(addAssignment_662,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v2240(VarCurr,B)
      <=> v2243(VarCurr,B) ) ) ).

fof(addAssignment_661,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v2243(VarCurr,B)
      <=> v2242(VarCurr,B) ) ) ).

fof(addAssignment_660,axiom,
    ! [VarCurr] :
      ( ( v2243(VarCurr,bitIndex130)
      <=> v2244(VarCurr,bitIndex122) )
      & ( v2243(VarCurr,bitIndex129)
      <=> v2244(VarCurr,bitIndex121) )
      & ( v2243(VarCurr,bitIndex128)
      <=> v2244(VarCurr,bitIndex120) )
      & ( v2243(VarCurr,bitIndex127)
      <=> v2244(VarCurr,bitIndex119) )
      & ( v2243(VarCurr,bitIndex126)
      <=> v2244(VarCurr,bitIndex118) )
      & ( v2243(VarCurr,bitIndex125)
      <=> v2244(VarCurr,bitIndex117) )
      & ( v2243(VarCurr,bitIndex124)
      <=> v2244(VarCurr,bitIndex116) )
      & ( v2243(VarCurr,bitIndex123)
      <=> v2244(VarCurr,bitIndex115) )
      & ( v2243(VarCurr,bitIndex122)
      <=> v2244(VarCurr,bitIndex114) )
      & ( v2243(VarCurr,bitIndex121)
      <=> v2244(VarCurr,bitIndex113) )
      & ( v2243(VarCurr,bitIndex120)
      <=> v2244(VarCurr,bitIndex112) )
      & ( v2243(VarCurr,bitIndex119)
      <=> v2244(VarCurr,bitIndex111) )
      & ( v2243(VarCurr,bitIndex118)
      <=> v2244(VarCurr,bitIndex110) )
      & ( v2243(VarCurr,bitIndex117)
      <=> v2244(VarCurr,bitIndex109) )
      & ( v2243(VarCurr,bitIndex116)
      <=> v2244(VarCurr,bitIndex108) )
      & ( v2243(VarCurr,bitIndex115)
      <=> v2244(VarCurr,bitIndex107) )
      & ( v2243(VarCurr,bitIndex114)
      <=> v2244(VarCurr,bitIndex106) )
      & ( v2243(VarCurr,bitIndex113)
      <=> v2244(VarCurr,bitIndex105) )
      & ( v2243(VarCurr,bitIndex112)
      <=> v2244(VarCurr,bitIndex104) )
      & ( v2243(VarCurr,bitIndex111)
      <=> v2244(VarCurr,bitIndex103) )
      & ( v2243(VarCurr,bitIndex110)
      <=> v2244(VarCurr,bitIndex102) )
      & ( v2243(VarCurr,bitIndex109)
      <=> v2244(VarCurr,bitIndex101) )
      & ( v2243(VarCurr,bitIndex108)
      <=> v2244(VarCurr,bitIndex100) )
      & ( v2243(VarCurr,bitIndex107)
      <=> v2244(VarCurr,bitIndex99) )
      & ( v2243(VarCurr,bitIndex106)
      <=> v2244(VarCurr,bitIndex98) )
      & ( v2243(VarCurr,bitIndex105)
      <=> v2244(VarCurr,bitIndex97) )
      & ( v2243(VarCurr,bitIndex104)
      <=> v2244(VarCurr,bitIndex96) )
      & ( v2243(VarCurr,bitIndex103)
      <=> v2244(VarCurr,bitIndex95) )
      & ( v2243(VarCurr,bitIndex102)
      <=> v2244(VarCurr,bitIndex94) )
      & ( v2243(VarCurr,bitIndex101)
      <=> v2244(VarCurr,bitIndex93) )
      & ( v2243(VarCurr,bitIndex100)
      <=> v2244(VarCurr,bitIndex92) )
      & ( v2243(VarCurr,bitIndex99)
      <=> v2244(VarCurr,bitIndex91) )
      & ( v2243(VarCurr,bitIndex98)
      <=> v2244(VarCurr,bitIndex90) )
      & ( v2243(VarCurr,bitIndex97)
      <=> v2244(VarCurr,bitIndex89) )
      & ( v2243(VarCurr,bitIndex96)
      <=> v2244(VarCurr,bitIndex88) )
      & ( v2243(VarCurr,bitIndex95)
      <=> v2244(VarCurr,bitIndex87) )
      & ( v2243(VarCurr,bitIndex94)
      <=> v2244(VarCurr,bitIndex86) )
      & ( v2243(VarCurr,bitIndex93)
      <=> v2244(VarCurr,bitIndex85) )
      & ( v2243(VarCurr,bitIndex92)
      <=> v2244(VarCurr,bitIndex84) )
      & ( v2243(VarCurr,bitIndex91)
      <=> v2244(VarCurr,bitIndex83) )
      & ( v2243(VarCurr,bitIndex90)
      <=> v2244(VarCurr,bitIndex82) )
      & ( v2243(VarCurr,bitIndex89)
      <=> v2244(VarCurr,bitIndex81) )
      & ( v2243(VarCurr,bitIndex88)
      <=> v2244(VarCurr,bitIndex80) )
      & ( v2243(VarCurr,bitIndex87)
      <=> v2244(VarCurr,bitIndex79) )
      & ( v2243(VarCurr,bitIndex86)
      <=> v2244(VarCurr,bitIndex78) )
      & ( v2243(VarCurr,bitIndex85)
      <=> v2244(VarCurr,bitIndex77) )
      & ( v2243(VarCurr,bitIndex84)
      <=> v2244(VarCurr,bitIndex76) )
      & ( v2243(VarCurr,bitIndex83)
      <=> v2244(VarCurr,bitIndex75) )
      & ( v2243(VarCurr,bitIndex82)
      <=> v2244(VarCurr,bitIndex74) )
      & ( v2243(VarCurr,bitIndex81)
      <=> v2244(VarCurr,bitIndex73) )
      & ( v2243(VarCurr,bitIndex80)
      <=> v2244(VarCurr,bitIndex72) )
      & ( v2243(VarCurr,bitIndex79)
      <=> v2244(VarCurr,bitIndex71) )
      & ( v2243(VarCurr,bitIndex78)
      <=> v2244(VarCurr,bitIndex70) )
      & ( v2243(VarCurr,bitIndex77)
      <=> v2244(VarCurr,bitIndex69) )
      & ( v2243(VarCurr,bitIndex76)
      <=> v2244(VarCurr,bitIndex68) )
      & ( v2243(VarCurr,bitIndex75)
      <=> v2244(VarCurr,bitIndex67) )
      & ( v2243(VarCurr,bitIndex74)
      <=> v2244(VarCurr,bitIndex66) )
      & ( v2243(VarCurr,bitIndex73)
      <=> v2244(VarCurr,bitIndex65) )
      & ( v2243(VarCurr,bitIndex72)
      <=> v2244(VarCurr,bitIndex64) )
      & ( v2243(VarCurr,bitIndex71)
      <=> v2244(VarCurr,bitIndex63) )
      & ( v2243(VarCurr,bitIndex70)
      <=> v2244(VarCurr,bitIndex62) )
      & ( v2243(VarCurr,bitIndex69)
      <=> v2244(VarCurr,bitIndex61) )
      & ( v2243(VarCurr,bitIndex68)
      <=> v2244(VarCurr,bitIndex60) )
      & ( v2243(VarCurr,bitIndex67)
      <=> v2244(VarCurr,bitIndex59) )
      & ( v2243(VarCurr,bitIndex66)
      <=> v2244(VarCurr,bitIndex58) )
      & ( v2243(VarCurr,bitIndex65)
      <=> v2244(VarCurr,bitIndex57) )
      & ( v2243(VarCurr,bitIndex64)
      <=> v2244(VarCurr,bitIndex56) )
      & ( v2243(VarCurr,bitIndex63)
      <=> v2244(VarCurr,bitIndex55) )
      & ( v2243(VarCurr,bitIndex62)
      <=> v2244(VarCurr,bitIndex54) )
      & ( v2243(VarCurr,bitIndex61)
      <=> v2244(VarCurr,bitIndex53) )
      & ( v2243(VarCurr,bitIndex60)
      <=> v2244(VarCurr,bitIndex52) )
      & ( v2243(VarCurr,bitIndex59)
      <=> v2244(VarCurr,bitIndex51) )
      & ( v2243(VarCurr,bitIndex58)
      <=> v2244(VarCurr,bitIndex50) )
      & ( v2243(VarCurr,bitIndex57)
      <=> v2244(VarCurr,bitIndex49) )
      & ( v2243(VarCurr,bitIndex56)
      <=> v2244(VarCurr,bitIndex48) )
      & ( v2243(VarCurr,bitIndex55)
      <=> v2244(VarCurr,bitIndex47) )
      & ( v2243(VarCurr,bitIndex54)
      <=> v2244(VarCurr,bitIndex46) )
      & ( v2243(VarCurr,bitIndex53)
      <=> v2244(VarCurr,bitIndex45) )
      & ( v2243(VarCurr,bitIndex52)
      <=> v2244(VarCurr,bitIndex44) )
      & ( v2243(VarCurr,bitIndex51)
      <=> v2244(VarCurr,bitIndex43) )
      & ( v2243(VarCurr,bitIndex50)
      <=> v2244(VarCurr,bitIndex42) )
      & ( v2243(VarCurr,bitIndex49)
      <=> v2244(VarCurr,bitIndex41) )
      & ( v2243(VarCurr,bitIndex48)
      <=> v2244(VarCurr,bitIndex40) )
      & ( v2243(VarCurr,bitIndex47)
      <=> v2244(VarCurr,bitIndex39) )
      & ( v2243(VarCurr,bitIndex46)
      <=> v2244(VarCurr,bitIndex38) )
      & ( v2243(VarCurr,bitIndex45)
      <=> v2244(VarCurr,bitIndex37) )
      & ( v2243(VarCurr,bitIndex44)
      <=> v2244(VarCurr,bitIndex36) )
      & ( v2243(VarCurr,bitIndex43)
      <=> v2244(VarCurr,bitIndex35) )
      & ( v2243(VarCurr,bitIndex42)
      <=> v2244(VarCurr,bitIndex34) )
      & ( v2243(VarCurr,bitIndex41)
      <=> v2244(VarCurr,bitIndex33) )
      & ( v2243(VarCurr,bitIndex40)
      <=> v2244(VarCurr,bitIndex32) )
      & ( v2243(VarCurr,bitIndex39)
      <=> v2244(VarCurr,bitIndex31) )
      & ( v2243(VarCurr,bitIndex38)
      <=> v2244(VarCurr,bitIndex30) )
      & ( v2243(VarCurr,bitIndex37)
      <=> v2244(VarCurr,bitIndex29) )
      & ( v2243(VarCurr,bitIndex36)
      <=> v2244(VarCurr,bitIndex28) )
      & ( v2243(VarCurr,bitIndex35)
      <=> v2244(VarCurr,bitIndex27) )
      & ( v2243(VarCurr,bitIndex34)
      <=> v2244(VarCurr,bitIndex26) )
      & ( v2243(VarCurr,bitIndex33)
      <=> v2244(VarCurr,bitIndex25) )
      & ( v2243(VarCurr,bitIndex32)
      <=> v2244(VarCurr,bitIndex24) )
      & ( v2243(VarCurr,bitIndex31)
      <=> v2244(VarCurr,bitIndex23) )
      & ( v2243(VarCurr,bitIndex30)
      <=> v2244(VarCurr,bitIndex22) )
      & ( v2243(VarCurr,bitIndex29)
      <=> v2244(VarCurr,bitIndex21) )
      & ( v2243(VarCurr,bitIndex28)
      <=> v2244(VarCurr,bitIndex20) )
      & ( v2243(VarCurr,bitIndex27)
      <=> v2244(VarCurr,bitIndex19) )
      & ( v2243(VarCurr,bitIndex26)
      <=> v2244(VarCurr,bitIndex18) )
      & ( v2243(VarCurr,bitIndex25)
      <=> v2244(VarCurr,bitIndex17) )
      & ( v2243(VarCurr,bitIndex24)
      <=> v2244(VarCurr,bitIndex16) )
      & ( v2243(VarCurr,bitIndex23)
      <=> v2244(VarCurr,bitIndex15) )
      & ( v2243(VarCurr,bitIndex22)
      <=> v2244(VarCurr,bitIndex14) )
      & ( v2243(VarCurr,bitIndex21)
      <=> v2244(VarCurr,bitIndex13) )
      & ( v2243(VarCurr,bitIndex20)
      <=> v2244(VarCurr,bitIndex12) )
      & ( v2243(VarCurr,bitIndex19)
      <=> v2244(VarCurr,bitIndex11) )
      & ( v2243(VarCurr,bitIndex18)
      <=> v2244(VarCurr,bitIndex10) )
      & ( v2243(VarCurr,bitIndex17)
      <=> v2244(VarCurr,bitIndex9) )
      & ( v2243(VarCurr,bitIndex16)
      <=> v2244(VarCurr,bitIndex8) )
      & ( v2243(VarCurr,bitIndex15)
      <=> v2244(VarCurr,bitIndex7) )
      & ( v2243(VarCurr,bitIndex14)
      <=> v2244(VarCurr,bitIndex6) )
      & ( v2243(VarCurr,bitIndex13)
      <=> v2244(VarCurr,bitIndex5) )
      & ( v2243(VarCurr,bitIndex12)
      <=> v2244(VarCurr,bitIndex4) )
      & ( v2243(VarCurr,bitIndex11)
      <=> v2244(VarCurr,bitIndex3) )
      & ( v2243(VarCurr,bitIndex10)
      <=> v2244(VarCurr,bitIndex2) )
      & ( v2243(VarCurr,bitIndex9)
      <=> v2244(VarCurr,bitIndex1) )
      & ( v2243(VarCurr,bitIndex8)
      <=> v2244(VarCurr,bitIndex0) ) ) ).

fof(addAssignmentInitValueVector_27,axiom,
    ! [B] :
      ( range_7_0(B)
     => ( v2242(constB0,B)
      <=> $false ) ) ).

fof(addAssignment_659,axiom,
    ! [VarCurr] :
      ( v2165(VarCurr)
    <=> v2167(VarCurr,bitIndex1) ) ).

fof(addAssignment_658,axiom,
    ! [VarCurr] :
      ( v2167(VarCurr,bitIndex1)
    <=> v2193(VarCurr,bitIndex1) ) ).

fof(addAssignment_657,axiom,
    ! [VarNext] :
      ( v2171(VarNext,bitIndex0)
    <=> v2226(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionEqualRanges1_22,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2227(VarNext)
       => ! [B] :
            ( range_6_0(B)
           => ( v2226(VarNext,B)
            <=> v2171(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_23,axiom,
    ! [VarNext] :
      ( v2227(VarNext)
     => ! [B] :
          ( range_6_0(B)
         => ( v2226(VarNext,B)
          <=> v2188(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_284,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2227(VarNext)
      <=> v2228(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_283,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2228(VarNext)
      <=> ( v2230(VarNext)
          & v2173(VarNext) ) ) ) ).

fof(writeUnaryOperator_126,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2230(VarNext)
      <=> v2182(VarNext) ) ) ).

fof(addAssignment_656,axiom,
    ! [VarCurr] :
      ( v2167(VarCurr,bitIndex0)
    <=> v2193(VarCurr,bitIndex0) ) ).

fof(addAssignment_655,axiom,
    ! [VarNext] :
      ( v2171(VarNext,bitIndex2)
    <=> v2218(VarNext,bitIndex2) ) ).

fof(addCaseBooleanConditionEqualRanges1_21,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2219(VarNext)
       => ! [B] :
            ( range_6_0(B)
           => ( v2218(VarNext,B)
            <=> v2171(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_22,axiom,
    ! [VarNext] :
      ( v2219(VarNext)
     => ! [B] :
          ( range_6_0(B)
         => ( v2218(VarNext,B)
          <=> v2188(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_282,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2219(VarNext)
      <=> v2220(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_281,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2220(VarNext)
      <=> ( v2222(VarNext)
          & v2173(VarNext) ) ) ) ).

fof(writeUnaryOperator_125,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2222(VarNext)
      <=> v2182(VarNext) ) ) ).

fof(addAssignment_654,axiom,
    ! [VarCurr] :
      ( v2167(VarCurr,bitIndex2)
    <=> v2193(VarCurr,bitIndex2) ) ).

fof(addAssignment_653,axiom,
    ! [VarNext] :
      ( v2171(VarNext,bitIndex3)
    <=> v2210(VarNext,bitIndex3) ) ).

fof(addCaseBooleanConditionEqualRanges1_20,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2211(VarNext)
       => ! [B] :
            ( range_6_0(B)
           => ( v2210(VarNext,B)
            <=> v2171(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_21,axiom,
    ! [VarNext] :
      ( v2211(VarNext)
     => ! [B] :
          ( range_6_0(B)
         => ( v2210(VarNext,B)
          <=> v2188(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_280,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2211(VarNext)
      <=> v2212(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_279,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2212(VarNext)
      <=> ( v2214(VarNext)
          & v2173(VarNext) ) ) ) ).

fof(writeUnaryOperator_124,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2214(VarNext)
      <=> v2182(VarNext) ) ) ).

fof(addAssignment_652,axiom,
    ! [VarCurr] :
      ( v2167(VarCurr,bitIndex3)
    <=> v2193(VarCurr,bitIndex3) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_61,axiom,
    ! [VarCurr] :
      ( ~ v2194(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v2193(VarCurr,B)
          <=> v2196(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_92,axiom,
    ! [VarCurr] :
      ( v2194(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v2193(VarCurr,B)
          <=> v2195(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_6,axiom,
    ! [VarCurr] :
      ( ( ~ v2197(VarCurr)
        & ~ v2199(VarCurr)
        & ~ v2203(VarCurr) )
     => ! [B] :
          ( range_6_0(B)
         => ( v2196(VarCurr,B)
          <=> v2171(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_8,axiom,
    ! [VarCurr] :
      ( v2203(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v2196(VarCurr,B)
          <=> v2205(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_15,axiom,
    ! [VarCurr] :
      ( v2199(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v2196(VarCurr,B)
          <=> v2201(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_15,axiom,
    ! [VarCurr] :
      ( v2197(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v2196(VarCurr,B)
          <=> v2171(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_136,axiom,
    ! [VarCurr] :
      ( v2207(VarCurr)
    <=> ( ( v2208(VarCurr,bitIndex1)
        <=> $true )
        & ( v2208(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_651,axiom,
    ! [VarCurr] :
      ( v2208(VarCurr,bitIndex0)
    <=> v2155(VarCurr) ) ).

fof(addAssignment_650,axiom,
    ! [VarCurr] :
      ( v2208(VarCurr,bitIndex1)
    <=> v29(VarCurr) ) ).

fof(addAssignment_649,axiom,
    ! [VarCurr] :
      ( v2205(VarCurr,bitIndex0)
    <=> $false ) ).

fof(addAssignment_648,axiom,
    ! [VarCurr] :
      ( ( v2205(VarCurr,bitIndex6)
      <=> v2171(VarCurr,bitIndex5) )
      & ( v2205(VarCurr,bitIndex5)
      <=> v2171(VarCurr,bitIndex4) )
      & ( v2205(VarCurr,bitIndex4)
      <=> v2171(VarCurr,bitIndex3) )
      & ( v2205(VarCurr,bitIndex3)
      <=> v2171(VarCurr,bitIndex2) )
      & ( v2205(VarCurr,bitIndex2)
      <=> v2171(VarCurr,bitIndex1) )
      & ( v2205(VarCurr,bitIndex1)
      <=> v2171(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_135,axiom,
    ! [VarCurr] :
      ( v2203(VarCurr)
    <=> ( ( v2204(VarCurr,bitIndex1)
        <=> $true )
        & ( v2204(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_647,axiom,
    ! [VarCurr] :
      ( v2204(VarCurr,bitIndex0)
    <=> v2155(VarCurr) ) ).

fof(addAssignment_646,axiom,
    ! [VarCurr] :
      ( v2204(VarCurr,bitIndex1)
    <=> v29(VarCurr) ) ).

fof(addAssignment_645,axiom,
    ! [VarCurr] :
      ( ( v2201(VarCurr,bitIndex5)
      <=> v2171(VarCurr,bitIndex6) )
      & ( v2201(VarCurr,bitIndex4)
      <=> v2171(VarCurr,bitIndex5) )
      & ( v2201(VarCurr,bitIndex3)
      <=> v2171(VarCurr,bitIndex4) )
      & ( v2201(VarCurr,bitIndex2)
      <=> v2171(VarCurr,bitIndex3) )
      & ( v2201(VarCurr,bitIndex1)
      <=> v2171(VarCurr,bitIndex2) )
      & ( v2201(VarCurr,bitIndex0)
      <=> v2171(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_644,axiom,
    ! [VarCurr] :
      ( v2201(VarCurr,bitIndex6)
    <=> $false ) ).

fof(addBitVectorEqualityBitBlasted_134,axiom,
    ! [VarCurr] :
      ( v2199(VarCurr)
    <=> ( ( v2200(VarCurr,bitIndex1)
        <=> $false )
        & ( v2200(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_643,axiom,
    ! [VarCurr] :
      ( v2200(VarCurr,bitIndex0)
    <=> v2155(VarCurr) ) ).

fof(addAssignment_642,axiom,
    ! [VarCurr] :
      ( v2200(VarCurr,bitIndex1)
    <=> v29(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_133,axiom,
    ! [VarCurr] :
      ( v2197(VarCurr)
    <=> ( ( v2198(VarCurr,bitIndex1)
        <=> $false )
        & ( v2198(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_641,axiom,
    ! [VarCurr] :
      ( v2198(VarCurr,bitIndex0)
    <=> v2155(VarCurr) ) ).

fof(addAssignment_640,axiom,
    ! [VarCurr] :
      ( v2198(VarCurr,bitIndex1)
    <=> v29(VarCurr) ) ).

fof(addAssignment_639,axiom,
    ! [VarCurr] :
      ( v2195(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_638,axiom,
    ! [VarCurr,B] :
      ( range_6_1(B)
     => ( v2195(VarCurr,B)
      <=> v2169(VarCurr,B) ) ) ).

fof(writeUnaryOperator_123,axiom,
    ! [VarCurr] :
      ( ~ v2194(VarCurr)
    <=> v27(VarCurr) ) ).

fof(addAssignment_637,axiom,
    ! [VarCurr] :
      ( v2169(VarCurr,bitIndex3)
    <=> v2192(VarCurr,bitIndex3) ) ).

fof(addAssignment_636,axiom,
    ! [VarCurr] :
      ( v2169(VarCurr,bitIndex2)
    <=> v2192(VarCurr,bitIndex2) ) ).

fof(addAssignment_635,axiom,
    ! [VarCurr] :
      ( v2169(VarCurr,bitIndex1)
    <=> v2192(VarCurr,bitIndex1) ) ).

fof(addAssignment_634,axiom,
    ! [VarCurr] :
      ( v2192(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_633,axiom,
    ! [VarCurr,B] :
      ( range_6_1(B)
     => ( v2192(VarCurr,B)
      <=> v2171(VarCurr,B) ) ) ).

fof(addAssignment_632,axiom,
    ! [VarNext] :
      ( v2171(VarNext,bitIndex1)
    <=> v2177(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_19,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2178(VarNext)
       => ! [B] :
            ( range_6_0(B)
           => ( v2177(VarNext,B)
            <=> v2171(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_20,axiom,
    ! [VarNext] :
      ( v2178(VarNext)
     => ! [B] :
          ( range_6_0(B)
         => ( v2177(VarNext,B)
          <=> v2188(VarNext,B) ) ) ) ).

fof(addAssignment_631,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_6_0(B)
         => ( v2188(VarNext,B)
          <=> v2186(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_60,axiom,
    ! [VarCurr] :
      ( ~ v2189(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v2186(VarCurr,B)
          <=> v2167(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_91,axiom,
    ! [VarCurr] :
      ( v2189(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v2186(VarCurr,B)
          <=> b0000001(B) ) ) ) ).

fof(writeUnaryOperator_122,axiom,
    ! [VarCurr] :
      ( ~ v2189(VarCurr)
    <=> v27(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_278,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2178(VarNext)
      <=> v2179(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_277,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2179(VarNext)
      <=> ( v2180(VarNext)
          & v2173(VarNext) ) ) ) ).

fof(writeUnaryOperator_121,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2180(VarNext)
      <=> v2182(VarNext) ) ) ).

fof(addAssignment_630,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2182(VarNext)
      <=> v2173(VarCurr) ) ) ).

fof(addAssignmentInitValue_121,axiom,
    ~ v2171(constB0,bitIndex4) ).

fof(addAssignmentInitValue_120,axiom,
    ~ v2171(constB0,bitIndex3) ).

fof(addAssignmentInitValue_119,axiom,
    ~ v2171(constB0,bitIndex2) ).

fof(addAssignmentInitValue_118,axiom,
    ~ v2171(constB0,bitIndex1) ).

fof(addAssignmentInitValue_117,axiom,
    v2171(constB0,bitIndex0) ).

fof(bitBlastConstant_673,axiom,
    ~ bxx00001(bitIndex4) ).

fof(bitBlastConstant_672,axiom,
    ~ bxx00001(bitIndex3) ).

fof(bitBlastConstant_671,axiom,
    ~ bxx00001(bitIndex2) ).

fof(bitBlastConstant_670,axiom,
    ~ bxx00001(bitIndex1) ).

fof(bitBlastConstant_669,axiom,
    bxx00001(bitIndex0) ).

fof(addAssignment_629,axiom,
    ! [VarCurr] :
      ( v2173(VarCurr)
    <=> v1252(VarCurr) ) ).

fof(addAssignment_628,axiom,
    ! [VarCurr] :
      ( v2155(VarCurr)
    <=> v2157(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_59,axiom,
    ! [VarCurr] :
      ( ~ v2159(VarCurr)
     => ( v2157(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_90,axiom,
    ! [VarCurr] :
      ( v2159(VarCurr)
     => ( v2157(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_276,axiom,
    ! [VarCurr] :
      ( v2159(VarCurr)
    <=> ( v2160(VarCurr)
        | v1323(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_275,axiom,
    ! [VarCurr] :
      ( v2160(VarCurr)
    <=> ( v2161(VarCurr)
        & v1322(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_274,axiom,
    ! [VarCurr] :
      ( v2161(VarCurr)
    <=> ( v2053(VarCurr)
        & v1320(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_98,axiom,
    ! [VarCurr] :
      ( v2139(VarCurr)
    <=> ( v2141(VarCurr)
        | v6(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_97,axiom,
    ! [VarCurr] :
      ( v2141(VarCurr)
    <=> ( v6(VarCurr,bitIndex2)
        | v6(VarCurr,bitIndex3) ) ) ).

fof(addAssignment_627,axiom,
    ! [VarCurr] :
      ( v2068(VarCurr)
    <=> v2070(VarCurr,bitIndex2) ) ).

fof(addAssignment_626,axiom,
    ! [VarCurr] :
      ( v2070(VarCurr,bitIndex2)
    <=> v2098(VarCurr,bitIndex2) ) ).

fof(addAssignment_625,axiom,
    ! [VarNext] :
      ( v2074(VarNext,bitIndex1)
    <=> v2123(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_18,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2124(VarNext)
       => ! [B] :
            ( range_6_0(B)
           => ( v2123(VarNext,B)
            <=> v2074(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_19,axiom,
    ! [VarNext] :
      ( v2124(VarNext)
     => ! [B] :
          ( range_6_0(B)
         => ( v2123(VarNext,B)
          <=> v2092(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_273,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2124(VarNext)
      <=> v2125(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_272,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2125(VarNext)
      <=> ( v2127(VarNext)
          & v2077(VarNext) ) ) ) ).

fof(writeUnaryOperator_120,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2127(VarNext)
      <=> v2086(VarNext) ) ) ).

fof(addAssignment_624,axiom,
    ! [VarCurr] :
      ( v2070(VarCurr,bitIndex1)
    <=> v2098(VarCurr,bitIndex1) ) ).

fof(addAssignment_623,axiom,
    ! [VarNext] :
      ( v2074(VarNext,bitIndex0)
    <=> v2115(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionEqualRanges1_17,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2116(VarNext)
       => ! [B] :
            ( range_6_0(B)
           => ( v2115(VarNext,B)
            <=> v2074(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_18,axiom,
    ! [VarNext] :
      ( v2116(VarNext)
     => ! [B] :
          ( range_6_0(B)
         => ( v2115(VarNext,B)
          <=> v2092(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_271,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2116(VarNext)
      <=> v2117(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_270,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2117(VarNext)
      <=> ( v2119(VarNext)
          & v2077(VarNext) ) ) ) ).

fof(writeUnaryOperator_119,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2119(VarNext)
      <=> v2086(VarNext) ) ) ).

fof(addAssignment_622,axiom,
    ! [VarCurr] :
      ( v2070(VarCurr,bitIndex0)
    <=> v2098(VarCurr,bitIndex0) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_58,axiom,
    ! [VarCurr] :
      ( ~ v2099(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v2098(VarCurr,B)
          <=> v2101(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_89,axiom,
    ! [VarCurr] :
      ( v2099(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v2098(VarCurr,B)
          <=> v2100(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_5,axiom,
    ! [VarCurr] :
      ( ( ~ v2102(VarCurr)
        & ~ v2104(VarCurr)
        & ~ v2108(VarCurr) )
     => ! [B] :
          ( range_6_0(B)
         => ( v2101(VarCurr,B)
          <=> v2074(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_7,axiom,
    ! [VarCurr] :
      ( v2108(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v2101(VarCurr,B)
          <=> v2110(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_14,axiom,
    ! [VarCurr] :
      ( v2104(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v2101(VarCurr,B)
          <=> v2106(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_14,axiom,
    ! [VarCurr] :
      ( v2102(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v2101(VarCurr,B)
          <=> v2074(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_132,axiom,
    ! [VarCurr] :
      ( v2112(VarCurr)
    <=> ( ( v2113(VarCurr,bitIndex1)
        <=> $true )
        & ( v2113(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_621,axiom,
    ! [VarCurr] :
      ( v2113(VarCurr,bitIndex0)
    <=> v2064(VarCurr) ) ).

fof(addAssignment_620,axiom,
    ! [VarCurr] :
      ( v2113(VarCurr,bitIndex1)
    <=> v1185(VarCurr) ) ).

fof(addAssignment_619,axiom,
    ! [VarCurr] :
      ( v2110(VarCurr,bitIndex0)
    <=> $false ) ).

fof(addAssignment_618,axiom,
    ! [VarCurr] :
      ( ( v2110(VarCurr,bitIndex6)
      <=> v2074(VarCurr,bitIndex5) )
      & ( v2110(VarCurr,bitIndex5)
      <=> v2074(VarCurr,bitIndex4) )
      & ( v2110(VarCurr,bitIndex4)
      <=> v2074(VarCurr,bitIndex3) )
      & ( v2110(VarCurr,bitIndex3)
      <=> v2074(VarCurr,bitIndex2) )
      & ( v2110(VarCurr,bitIndex2)
      <=> v2074(VarCurr,bitIndex1) )
      & ( v2110(VarCurr,bitIndex1)
      <=> v2074(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_131,axiom,
    ! [VarCurr] :
      ( v2108(VarCurr)
    <=> ( ( v2109(VarCurr,bitIndex1)
        <=> $true )
        & ( v2109(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_617,axiom,
    ! [VarCurr] :
      ( v2109(VarCurr,bitIndex0)
    <=> v2064(VarCurr) ) ).

fof(addAssignment_616,axiom,
    ! [VarCurr] :
      ( v2109(VarCurr,bitIndex1)
    <=> v1185(VarCurr) ) ).

fof(addAssignment_615,axiom,
    ! [VarCurr] :
      ( ( v2106(VarCurr,bitIndex5)
      <=> v2074(VarCurr,bitIndex6) )
      & ( v2106(VarCurr,bitIndex4)
      <=> v2074(VarCurr,bitIndex5) )
      & ( v2106(VarCurr,bitIndex3)
      <=> v2074(VarCurr,bitIndex4) )
      & ( v2106(VarCurr,bitIndex2)
      <=> v2074(VarCurr,bitIndex3) )
      & ( v2106(VarCurr,bitIndex1)
      <=> v2074(VarCurr,bitIndex2) )
      & ( v2106(VarCurr,bitIndex0)
      <=> v2074(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_614,axiom,
    ! [VarCurr] :
      ( v2106(VarCurr,bitIndex6)
    <=> $false ) ).

fof(addBitVectorEqualityBitBlasted_130,axiom,
    ! [VarCurr] :
      ( v2104(VarCurr)
    <=> ( ( v2105(VarCurr,bitIndex1)
        <=> $false )
        & ( v2105(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_613,axiom,
    ! [VarCurr] :
      ( v2105(VarCurr,bitIndex0)
    <=> v2064(VarCurr) ) ).

fof(addAssignment_612,axiom,
    ! [VarCurr] :
      ( v2105(VarCurr,bitIndex1)
    <=> v1185(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_129,axiom,
    ! [VarCurr] :
      ( v2102(VarCurr)
    <=> ( ( v2103(VarCurr,bitIndex1)
        <=> $false )
        & ( v2103(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_611,axiom,
    ! [VarCurr] :
      ( v2103(VarCurr,bitIndex0)
    <=> v2064(VarCurr) ) ).

fof(addAssignment_610,axiom,
    ! [VarCurr] :
      ( v2103(VarCurr,bitIndex1)
    <=> v1185(VarCurr) ) ).

fof(addAssignment_609,axiom,
    ! [VarCurr] :
      ( v2100(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_608,axiom,
    ! [VarCurr,B] :
      ( range_6_1(B)
     => ( v2100(VarCurr,B)
      <=> v2072(VarCurr,B) ) ) ).

fof(writeUnaryOperator_118,axiom,
    ! [VarCurr] :
      ( ~ v2099(VarCurr)
    <=> v1183(VarCurr) ) ).

fof(addAssignment_607,axiom,
    ! [VarCurr] :
      ( v2072(VarCurr,bitIndex1)
    <=> v2096(VarCurr,bitIndex1) ) ).

fof(addAssignment_606,axiom,
    ! [VarCurr] :
      ( v2072(VarCurr,bitIndex2)
    <=> v2096(VarCurr,bitIndex2) ) ).

fof(addAssignment_605,axiom,
    ! [VarCurr] :
      ( v2096(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_604,axiom,
    ! [VarCurr,B] :
      ( range_6_1(B)
     => ( v2096(VarCurr,B)
      <=> v2074(VarCurr,B) ) ) ).

fof(range_axiom_23,axiom,
    ! [B] :
      ( range_6_1(B)
    <=> ( $false
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B ) ) ).

fof(addAssignment_603,axiom,
    ! [VarNext] :
      ( v2074(VarNext,bitIndex2)
    <=> v2081(VarNext,bitIndex2) ) ).

fof(addCaseBooleanConditionEqualRanges1_16,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2082(VarNext)
       => ! [B] :
            ( range_6_0(B)
           => ( v2081(VarNext,B)
            <=> v2074(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_17,axiom,
    ! [VarNext] :
      ( v2082(VarNext)
     => ! [B] :
          ( range_6_0(B)
         => ( v2081(VarNext,B)
          <=> v2092(VarNext,B) ) ) ) ).

fof(addAssignment_602,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_6_0(B)
         => ( v2092(VarNext,B)
          <=> v2090(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_57,axiom,
    ! [VarCurr] :
      ( ~ v2093(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v2090(VarCurr,B)
          <=> v2070(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_88,axiom,
    ! [VarCurr] :
      ( v2093(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v2090(VarCurr,B)
          <=> b0000001(B) ) ) ) ).

fof(bitBlastConstant_668,axiom,
    ~ b0000001(bitIndex6) ).

fof(bitBlastConstant_667,axiom,
    ~ b0000001(bitIndex5) ).

fof(bitBlastConstant_666,axiom,
    ~ b0000001(bitIndex4) ).

fof(bitBlastConstant_665,axiom,
    ~ b0000001(bitIndex3) ).

fof(bitBlastConstant_664,axiom,
    ~ b0000001(bitIndex2) ).

fof(bitBlastConstant_663,axiom,
    ~ b0000001(bitIndex1) ).

fof(bitBlastConstant_662,axiom,
    b0000001(bitIndex0) ).

fof(writeUnaryOperator_117,axiom,
    ! [VarCurr] :
      ( ~ v2093(VarCurr)
    <=> v1183(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_269,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2082(VarNext)
      <=> v2083(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_268,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2083(VarNext)
      <=> ( v2084(VarNext)
          & v2077(VarNext) ) ) ) ).

fof(writeUnaryOperator_116,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2084(VarNext)
      <=> v2086(VarNext) ) ) ).

fof(addAssignment_601,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2086(VarNext)
      <=> v2077(VarCurr) ) ) ).

fof(addAssignmentInitValue_116,axiom,
    ~ v2074(constB0,bitIndex3) ).

fof(addAssignmentInitValue_115,axiom,
    ~ v2074(constB0,bitIndex2) ).

fof(addAssignmentInitValue_114,axiom,
    ~ v2074(constB0,bitIndex1) ).

fof(addAssignmentInitValue_113,axiom,
    v2074(constB0,bitIndex0) ).

fof(bitBlastConstant_661,axiom,
    ~ bxxx0001(bitIndex3) ).

fof(bitBlastConstant_660,axiom,
    ~ bxxx0001(bitIndex2) ).

fof(bitBlastConstant_659,axiom,
    ~ bxxx0001(bitIndex1) ).

fof(bitBlastConstant_658,axiom,
    bxxx0001(bitIndex0) ).

fof(addAssignment_600,axiom,
    ! [VarCurr] :
      ( v2077(VarCurr)
    <=> v801(VarCurr) ) ).

fof(addAssignment_599,axiom,
    ! [VarCurr] :
      ( v2064(VarCurr)
    <=> v1204(VarCurr) ) ).

fof(addAssignment_598,axiom,
    ! [VarCurr] :
      ( v1185(VarCurr)
    <=> v1187(VarCurr) ) ).

fof(addAssignment_597,axiom,
    ! [VarCurr] :
      ( v1187(VarCurr)
    <=> v1189(VarCurr) ) ).

fof(addAssignment_596,axiom,
    ! [VarCurr] :
      ( v1189(VarCurr)
    <=> v1191(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_56,axiom,
    ! [VarCurr] :
      ( ~ v2048(VarCurr)
     => ( v1191(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_87,axiom,
    ! [VarCurr] :
      ( v2048(VarCurr)
     => ( v1191(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_267,axiom,
    ! [VarCurr] :
      ( v2048(VarCurr)
    <=> ( v2049(VarCurr)
        | v2059(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_266,axiom,
    ! [VarCurr] :
      ( v2059(VarCurr)
    <=> ( v2060(VarCurr)
        & v1348(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_265,axiom,
    ! [VarCurr] :
      ( v2060(VarCurr)
    <=> ( v2061(VarCurr)
        | v1346(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_128,axiom,
    ! [VarCurr] :
      ( v2061(VarCurr)
    <=> ( ( v2062(VarCurr,bitIndex1)
        <=> $true )
        & ( v2062(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_595,axiom,
    ! [VarCurr] :
      ( v2062(VarCurr,bitIndex0)
    <=> v1308(VarCurr) ) ).

fof(addAssignment_594,axiom,
    ! [VarCurr] :
      ( v2062(VarCurr,bitIndex1)
    <=> v1193(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_264,axiom,
    ! [VarCurr] :
      ( v2049(VarCurr)
    <=> ( v2050(VarCurr)
        | v2058(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_263,axiom,
    ! [VarCurr] :
      ( v2058(VarCurr)
    <=> ( v1342(VarCurr)
        & v1344(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_262,axiom,
    ! [VarCurr] :
      ( v2050(VarCurr)
    <=> ( v2051(VarCurr)
        | v2054(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_261,axiom,
    ! [VarCurr] :
      ( v2054(VarCurr)
    <=> ( v2055(VarCurr)
        & v1333(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_260,axiom,
    ! [VarCurr] :
      ( v2055(VarCurr)
    <=> ( v2056(VarCurr)
        | v1331(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_127,axiom,
    ! [VarCurr] :
      ( v2056(VarCurr)
    <=> ( ( v2057(VarCurr,bitIndex1)
        <=> $true )
        & ( v2057(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_593,axiom,
    ! [VarCurr] :
      ( v2057(VarCurr,bitIndex0)
    <=> v1308(VarCurr) ) ).

fof(addAssignment_592,axiom,
    ! [VarCurr] :
      ( v2057(VarCurr,bitIndex1)
    <=> v1272(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_259,axiom,
    ! [VarCurr] :
      ( v2051(VarCurr)
    <=> ( v2052(VarCurr)
        & v1322(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_258,axiom,
    ! [VarCurr] :
      ( v2052(VarCurr)
    <=> ( v2053(VarCurr)
        & v1320(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_126,axiom,
    ! [VarCurr] :
      ( v2053(VarCurr)
    <=> ( ( v21(VarCurr,bitIndex1)
        <=> $false )
        & ( v21(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_591,axiom,
    ! [VarCurr] :
      ( v1272(VarCurr)
    <=> v1274(VarCurr) ) ).

fof(addAssignment_590,axiom,
    ! [VarCurr] :
      ( v1274(VarCurr)
    <=> v1276(VarCurr) ) ).

fof(addAssignment_589,axiom,
    ! [VarCurr] :
      ( v1276(VarCurr)
    <=> v1278(VarCurr) ) ).

fof(addAssignment_588,axiom,
    ! [VarCurr] :
      ( v1278(VarCurr)
    <=> v1280(VarCurr) ) ).

fof(addAssignment_587,axiom,
    ! [VarCurr] :
      ( v1280(VarCurr)
    <=> v1282(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_15,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2035(VarNext)
       => ( v1282(VarNext)
        <=> v1282(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_16,axiom,
    ! [VarNext] :
      ( v2035(VarNext)
     => ( v1282(VarNext)
      <=> v2043(VarNext) ) ) ).

fof(addAssignment_586,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2043(VarNext)
      <=> v2041(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_55,axiom,
    ! [VarCurr] :
      ( ~ v2044(VarCurr)
     => ( v2041(VarCurr)
      <=> v1288(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_86,axiom,
    ! [VarCurr] :
      ( v2044(VarCurr)
     => ( v2041(VarCurr)
      <=> $false ) ) ).

fof(writeUnaryOperator_115,axiom,
    ! [VarCurr] :
      ( ~ v2044(VarCurr)
    <=> v1284(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_257,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2035(VarNext)
      <=> v2036(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_256,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2036(VarNext)
      <=> ( v2037(VarNext)
          & v1942(VarNext) ) ) ) ).

fof(writeUnaryOperator_114,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2037(VarNext)
      <=> v1949(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_54,axiom,
    ! [VarCurr] :
      ( ~ v1994(VarCurr)
     => ( v1288(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_85,axiom,
    ! [VarCurr] :
      ( v1994(VarCurr)
     => ( v1288(VarCurr)
      <=> v2018(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_13,axiom,
    ! [VarCurr] :
      ( ~ v1400(VarCurr)
     => ( v2018(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_13,axiom,
    ! [VarCurr] :
      ( v1400(VarCurr)
     => ( v2018(VarCurr)
      <=> v2019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_255,axiom,
    ! [VarCurr] :
      ( v2025(VarCurr)
    <=> ( v2027(VarCurr)
        | v2007(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_254,axiom,
    ! [VarCurr] :
      ( v2027(VarCurr)
    <=> ( v2028(VarCurr)
        | v2006(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_253,axiom,
    ! [VarCurr] :
      ( v2028(VarCurr)
    <=> ( v2029(VarCurr)
        | v2005(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_252,axiom,
    ! [VarCurr] :
      ( v2029(VarCurr)
    <=> ( v2030(VarCurr)
        | v1977(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_251,axiom,
    ! [VarCurr] :
      ( v2030(VarCurr)
    <=> ( v2031(VarCurr)
        | v1976(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_250,axiom,
    ! [VarCurr] :
      ( v2031(VarCurr)
    <=> ( v2032(VarCurr)
        | v1975(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_249,axiom,
    ! [VarCurr] :
      ( v2032(VarCurr)
    <=> ( v1962(VarCurr)
        | v1974(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_248,axiom,
    ! [VarCurr] :
      ( v1962(VarCurr)
    <=> ( v1963(VarCurr)
        | v1968(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_53,axiom,
    ! [VarCurr] :
      ( ~ v1294(VarCurr)
     => ( v2019(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_84,axiom,
    ! [VarCurr] :
      ( v1294(VarCurr)
     => ( v2019(VarCurr)
      <=> v2020(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_52,axiom,
    ! [VarCurr] :
      ( ~ v2021(VarCurr)
     => ( v2020(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_83,axiom,
    ! [VarCurr] :
      ( v2021(VarCurr)
     => ( v2020(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_247,axiom,
    ! [VarCurr] :
      ( v2021(VarCurr)
    <=> ( v2022(VarCurr)
        & v1381(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_246,axiom,
    ! [VarCurr] :
      ( v2022(VarCurr)
    <=> ( v2023(VarCurr)
        | v2024(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_125,axiom,
    ! [VarCurr] :
      ( v2024(VarCurr)
    <=> ( ( v1364(VarCurr,bitIndex3)
        <=> $true )
        & ( v1364(VarCurr,bitIndex2)
        <=> $true )
        & ( v1364(VarCurr,bitIndex1)
        <=> $false )
        & ( v1364(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_124,axiom,
    ! [VarCurr] :
      ( v2023(VarCurr)
    <=> ( ( v1364(VarCurr,bitIndex3)
        <=> $false )
        & ( v1364(VarCurr,bitIndex2)
        <=> $true )
        & ( v1364(VarCurr,bitIndex1)
        <=> $false )
        & ( v1364(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_245,axiom,
    ! [VarCurr] :
      ( v1994(VarCurr)
    <=> ( v1995(VarCurr)
        | v2007(VarCurr) ) ) ).

fof(writeUnaryOperator_113,axiom,
    ! [VarCurr] :
      ( ~ v2007(VarCurr)
    <=> v2008(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_244,axiom,
    ! [VarCurr] :
      ( v2008(VarCurr)
    <=> ( v2009(VarCurr)
        | v1406(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_243,axiom,
    ! [VarCurr] :
      ( v2009(VarCurr)
    <=> ( v2010(VarCurr)
        | v1977(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_242,axiom,
    ! [VarCurr] :
      ( v2010(VarCurr)
    <=> ( v2011(VarCurr)
        | v1976(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_241,axiom,
    ! [VarCurr] :
      ( v2011(VarCurr)
    <=> ( v2012(VarCurr)
        | v1975(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_240,axiom,
    ! [VarCurr] :
      ( v2012(VarCurr)
    <=> ( v2013(VarCurr)
        | v1974(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_239,axiom,
    ! [VarCurr] :
      ( v2013(VarCurr)
    <=> ( v2014(VarCurr)
        | v1403(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_238,axiom,
    ! [VarCurr] :
      ( v2014(VarCurr)
    <=> ( v2015(VarCurr)
        | v1968(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_237,axiom,
    ! [VarCurr] :
      ( v2015(VarCurr)
    <=> ( v2016(VarCurr)
        | v1967(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_236,axiom,
    ! [VarCurr] :
      ( v2016(VarCurr)
    <=> ( v2017(VarCurr)
        | v1966(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_235,axiom,
    ! [VarCurr] :
      ( v2017(VarCurr)
    <=> ( v1400(VarCurr)
        | v1965(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_234,axiom,
    ! [VarCurr] :
      ( v1995(VarCurr)
    <=> ( v1996(VarCurr)
        | v2006(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_233,axiom,
    ! [VarCurr] :
      ( v2006(VarCurr)
    <=> ( v1405(VarCurr)
        & v1406(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_232,axiom,
    ! [VarCurr] :
      ( v1996(VarCurr)
    <=> ( v1997(VarCurr)
        | v1977(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_231,axiom,
    ! [VarCurr] :
      ( v1997(VarCurr)
    <=> ( v1998(VarCurr)
        | v1976(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_230,axiom,
    ! [VarCurr] :
      ( v1998(VarCurr)
    <=> ( v1999(VarCurr)
        | v1975(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_229,axiom,
    ! [VarCurr] :
      ( v1999(VarCurr)
    <=> ( v2000(VarCurr)
        | v1974(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_228,axiom,
    ! [VarCurr] :
      ( v2000(VarCurr)
    <=> ( v2001(VarCurr)
        | v2005(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_227,axiom,
    ! [VarCurr] :
      ( v2005(VarCurr)
    <=> ( v1402(VarCurr)
        & v1403(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_226,axiom,
    ! [VarCurr] :
      ( v2001(VarCurr)
    <=> ( v2002(VarCurr)
        | v1968(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_225,axiom,
    ! [VarCurr] :
      ( v2002(VarCurr)
    <=> ( v2003(VarCurr)
        | v1967(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_224,axiom,
    ! [VarCurr] :
      ( v2003(VarCurr)
    <=> ( v2004(VarCurr)
        | v1966(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_223,axiom,
    ! [VarCurr] :
      ( v2004(VarCurr)
    <=> ( v1400(VarCurr)
        | v1965(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_14,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1981(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v1290(VarNext,B)
            <=> v1290(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_15,axiom,
    ! [VarNext] :
      ( v1981(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v1290(VarNext,B)
          <=> v1989(VarNext,B) ) ) ) ).

fof(addAssignment_585,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v1989(VarNext,B)
          <=> v1987(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_51,axiom,
    ! [VarCurr] :
      ( ~ v1990(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1987(VarCurr,B)
          <=> v1292(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_82,axiom,
    ! [VarCurr] :
      ( v1990(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1987(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_112,axiom,
    ! [VarCurr] :
      ( ~ v1990(VarCurr)
    <=> v1284(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_222,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1981(VarNext)
      <=> v1982(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_221,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1982(VarNext)
      <=> ( v1983(VarNext)
          & v1942(VarNext) ) ) ) ).

fof(writeUnaryOperator_111,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1983(VarNext)
      <=> v1949(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges5_1,axiom,
    ! [VarCurr] :
      ( ( ~ v1400(VarCurr)
        & ~ v1961(VarCurr)
        & ~ v1403(VarCurr)
        & ~ v1970(VarCurr)
        & ~ v1406(VarCurr) )
     => ! [B] :
          ( range_3_0(B)
         => ( v1292(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_1,axiom,
    ! [VarCurr] :
      ( v1406(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1292(VarCurr,B)
          <=> v1978(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_4,axiom,
    ! [VarCurr] :
      ( v1970(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1292(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_6,axiom,
    ! [VarCurr] :
      ( v1403(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1292(VarCurr,B)
          <=> v1969(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_12,axiom,
    ! [VarCurr] :
      ( v1961(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1292(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_12,axiom,
    ! [VarCurr] :
      ( v1400(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1292(VarCurr,B)
          <=> v1960(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_50,axiom,
    ! [VarCurr] :
      ( ~ v1405(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1978(VarCurr,B)
          <=> $false ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_81,axiom,
    ! [VarCurr] :
      ( v1405(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1978(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_220,axiom,
    ! [VarCurr] :
      ( v1970(VarCurr)
    <=> ( v1972(VarCurr)
        | v1977(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_123,axiom,
    ! [VarCurr] :
      ( v1977(VarCurr)
    <=> ( ( v1290(VarCurr,bitIndex3)
        <=> $true )
        & ( v1290(VarCurr,bitIndex2)
        <=> $true )
        & ( v1290(VarCurr,bitIndex1)
        <=> $false )
        & ( v1290(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_219,axiom,
    ! [VarCurr] :
      ( v1972(VarCurr)
    <=> ( v1973(VarCurr)
        | v1976(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_122,axiom,
    ! [VarCurr] :
      ( v1976(VarCurr)
    <=> ( ( v1290(VarCurr,bitIndex3)
        <=> $true )
        & ( v1290(VarCurr,bitIndex2)
        <=> $false )
        & ( v1290(VarCurr,bitIndex1)
        <=> $true )
        & ( v1290(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_218,axiom,
    ! [VarCurr] :
      ( v1973(VarCurr)
    <=> ( v1974(VarCurr)
        | v1975(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_121,axiom,
    ! [VarCurr] :
      ( v1975(VarCurr)
    <=> ( ( v1290(VarCurr,bitIndex3)
        <=> $true )
        & ( v1290(VarCurr,bitIndex2)
        <=> $false )
        & ( v1290(VarCurr,bitIndex1)
        <=> $true )
        & ( v1290(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_120,axiom,
    ! [VarCurr] :
      ( v1974(VarCurr)
    <=> ( ( v1290(VarCurr,bitIndex3)
        <=> $true )
        & ( v1290(VarCurr,bitIndex2)
        <=> $false )
        & ( v1290(VarCurr,bitIndex1)
        <=> $false )
        & ( v1290(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_49,axiom,
    ! [VarCurr] :
      ( ~ v1402(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1969(VarCurr,B)
          <=> $false ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_80,axiom,
    ! [VarCurr] :
      ( v1402(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1969(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_217,axiom,
    ! [VarCurr] :
      ( v1961(VarCurr)
    <=> ( v1963(VarCurr)
        | v1968(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_119,axiom,
    ! [VarCurr] :
      ( v1968(VarCurr)
    <=> ( ( v1290(VarCurr,bitIndex3)
        <=> $false )
        & ( v1290(VarCurr,bitIndex2)
        <=> $true )
        & ( v1290(VarCurr,bitIndex1)
        <=> $false )
        & ( v1290(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_216,axiom,
    ! [VarCurr] :
      ( v1963(VarCurr)
    <=> ( v1964(VarCurr)
        | v1967(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_118,axiom,
    ! [VarCurr] :
      ( v1967(VarCurr)
    <=> ( ( v1290(VarCurr,bitIndex3)
        <=> $false )
        & ( v1290(VarCurr,bitIndex2)
        <=> $false )
        & ( v1290(VarCurr,bitIndex1)
        <=> $true )
        & ( v1290(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_215,axiom,
    ! [VarCurr] :
      ( v1964(VarCurr)
    <=> ( v1965(VarCurr)
        | v1966(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_117,axiom,
    ! [VarCurr] :
      ( v1966(VarCurr)
    <=> ( ( v1290(VarCurr,bitIndex3)
        <=> $false )
        & ( v1290(VarCurr,bitIndex2)
        <=> $false )
        & ( v1290(VarCurr,bitIndex1)
        <=> $true )
        & ( v1290(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_116,axiom,
    ! [VarCurr] :
      ( v1965(VarCurr)
    <=> ( ( v1290(VarCurr,bitIndex3)
        <=> $false )
        & ( v1290(VarCurr,bitIndex2)
        <=> $false )
        & ( v1290(VarCurr,bitIndex1)
        <=> $false )
        & ( v1290(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_48,axiom,
    ! [VarCurr] :
      ( ~ v1294(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1960(VarCurr,B)
          <=> $false ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_79,axiom,
    ! [VarCurr] :
      ( v1294(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1960(VarCurr,B)
          <=> v1364(VarCurr,B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_13,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1945(VarNext)
       => ( v1379(VarNext)
        <=> v1379(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_14,axiom,
    ! [VarNext] :
      ( v1945(VarNext)
     => ( v1379(VarNext)
      <=> v1955(VarNext) ) ) ).

fof(addAssignment_584,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1955(VarNext)
      <=> v1953(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_47,axiom,
    ! [VarCurr] :
      ( ~ v1956(VarCurr)
     => ( v1953(VarCurr)
      <=> v1381(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_78,axiom,
    ! [VarCurr] :
      ( v1956(VarCurr)
     => ( v1953(VarCurr)
      <=> $false ) ) ).

fof(writeUnaryOperator_110,axiom,
    ! [VarCurr] :
      ( ~ v1956(VarCurr)
    <=> v1284(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_214,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1945(VarNext)
      <=> v1946(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_213,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1946(VarNext)
      <=> ( v1947(VarNext)
          & v1942(VarNext) ) ) ) ).

fof(writeUnaryOperator_109,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1947(VarNext)
      <=> v1949(VarNext) ) ) ).

fof(addAssignment_583,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1949(VarNext)
      <=> v1942(VarCurr) ) ) ).

fof(addAssignment_582,axiom,
    ! [VarCurr] :
      ( v1942(VarCurr)
    <=> v1624(VarCurr) ) ).

fof(addAssignment_581,axiom,
    ! [VarCurr] :
      ( v1381(VarCurr)
    <=> v1383(VarCurr) ) ).

fof(addAssignment_580,axiom,
    ! [VarCurr] :
      ( v1383(VarCurr)
    <=> v1385(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_12,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1920(VarNext)
       => ( v1385(VarNext)
        <=> v1385(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_13,axiom,
    ! [VarNext] :
      ( v1920(VarNext)
     => ( v1385(VarNext)
      <=> v1937(VarNext) ) ) ).

fof(addAssignment_579,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1937(VarNext)
      <=> v1935(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_11,axiom,
    ! [VarCurr] :
      ( ~ v1929(VarCurr)
     => ( v1935(VarCurr)
      <=> v1938(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_11,axiom,
    ! [VarCurr] :
      ( v1929(VarCurr)
     => ( v1935(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_10,axiom,
    ! [VarCurr] :
      ( ~ v1389(VarCurr)
     => ( v1938(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_10,axiom,
    ! [VarCurr] :
      ( v1389(VarCurr)
     => ( v1938(VarCurr)
      <=> v1654(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_212,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1920(VarNext)
      <=> ( v1921(VarNext)
          & v1928(VarNext) ) ) ) ).

fof(addAssignment_578,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1928(VarNext)
      <=> v1926(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_211,axiom,
    ! [VarCurr] :
      ( v1926(VarCurr)
    <=> ( v1929(VarCurr)
        | v1930(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_210,axiom,
    ! [VarCurr] :
      ( v1930(VarCurr)
    <=> ( v1931(VarCurr)
        & v1934(VarCurr) ) ) ).

fof(writeUnaryOperator_108,axiom,
    ! [VarCurr] :
      ( ~ v1934(VarCurr)
    <=> v1929(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_209,axiom,
    ! [VarCurr] :
      ( v1931(VarCurr)
    <=> ( v1389(VarCurr)
        | v1932(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_208,axiom,
    ! [VarCurr] :
      ( v1932(VarCurr)
    <=> ( v1410(VarCurr)
        & v1933(VarCurr) ) ) ).

fof(writeUnaryOperator_107,axiom,
    ! [VarCurr] :
      ( ~ v1933(VarCurr)
    <=> v1389(VarCurr) ) ).

fof(writeUnaryOperator_106,axiom,
    ! [VarCurr] :
      ( ~ v1929(VarCurr)
    <=> v1387(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_207,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1921(VarNext)
      <=> ( v1922(VarNext)
          & v1868(VarNext) ) ) ) ).

fof(writeUnaryOperator_105,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1922(VarNext)
      <=> v1875(VarNext) ) ) ).

fof(writeUnaryOperator_104,axiom,
    ! [VarCurr] :
      ( ~ v1654(VarCurr)
    <=> v1886(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_206,axiom,
    ! [VarCurr] :
      ( v1886(VarCurr)
    <=> ( v1888(VarCurr)
        | v1903(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_205,axiom,
    ! [VarCurr] :
      ( v1903(VarCurr)
    <=> ( v1904(VarCurr)
        | v1911(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_204,axiom,
    ! [VarCurr] :
      ( v1911(VarCurr)
    <=> ( v1912(VarCurr)
        | v1915(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_203,axiom,
    ! [VarCurr] :
      ( v1915(VarCurr)
    <=> ( v1916(VarCurr)
        | v1917(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_96,axiom,
    ! [VarCurr] :
      ( v1917(VarCurr)
    <=> ( v1656(VarCurr,bitIndex30)
        | v1656(VarCurr,bitIndex31) ) ) ).

fof(writeBinaryOperatorShiftedRanges_95,axiom,
    ! [VarCurr] :
      ( v1916(VarCurr)
    <=> ( v1656(VarCurr,bitIndex28)
        | v1656(VarCurr,bitIndex29) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_202,axiom,
    ! [VarCurr] :
      ( v1912(VarCurr)
    <=> ( v1913(VarCurr)
        | v1914(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_94,axiom,
    ! [VarCurr] :
      ( v1914(VarCurr)
    <=> ( v1656(VarCurr,bitIndex26)
        | v1656(VarCurr,bitIndex27) ) ) ).

fof(writeBinaryOperatorShiftedRanges_93,axiom,
    ! [VarCurr] :
      ( v1913(VarCurr)
    <=> ( v1656(VarCurr,bitIndex24)
        | v1656(VarCurr,bitIndex25) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_201,axiom,
    ! [VarCurr] :
      ( v1904(VarCurr)
    <=> ( v1905(VarCurr)
        | v1908(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_200,axiom,
    ! [VarCurr] :
      ( v1908(VarCurr)
    <=> ( v1909(VarCurr)
        | v1910(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_92,axiom,
    ! [VarCurr] :
      ( v1910(VarCurr)
    <=> ( v1656(VarCurr,bitIndex22)
        | v1656(VarCurr,bitIndex23) ) ) ).

fof(writeBinaryOperatorShiftedRanges_91,axiom,
    ! [VarCurr] :
      ( v1909(VarCurr)
    <=> ( v1656(VarCurr,bitIndex20)
        | v1656(VarCurr,bitIndex21) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_199,axiom,
    ! [VarCurr] :
      ( v1905(VarCurr)
    <=> ( v1906(VarCurr)
        | v1907(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_90,axiom,
    ! [VarCurr] :
      ( v1907(VarCurr)
    <=> ( v1656(VarCurr,bitIndex18)
        | v1656(VarCurr,bitIndex19) ) ) ).

fof(writeBinaryOperatorShiftedRanges_89,axiom,
    ! [VarCurr] :
      ( v1906(VarCurr)
    <=> ( v1656(VarCurr,bitIndex16)
        | v1656(VarCurr,bitIndex17) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_198,axiom,
    ! [VarCurr] :
      ( v1888(VarCurr)
    <=> ( v1889(VarCurr)
        | v1896(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_197,axiom,
    ! [VarCurr] :
      ( v1896(VarCurr)
    <=> ( v1897(VarCurr)
        | v1900(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_196,axiom,
    ! [VarCurr] :
      ( v1900(VarCurr)
    <=> ( v1901(VarCurr)
        | v1902(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_88,axiom,
    ! [VarCurr] :
      ( v1902(VarCurr)
    <=> ( v1656(VarCurr,bitIndex14)
        | v1656(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorShiftedRanges_87,axiom,
    ! [VarCurr] :
      ( v1901(VarCurr)
    <=> ( v1656(VarCurr,bitIndex12)
        | v1656(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_195,axiom,
    ! [VarCurr] :
      ( v1897(VarCurr)
    <=> ( v1898(VarCurr)
        | v1899(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_86,axiom,
    ! [VarCurr] :
      ( v1899(VarCurr)
    <=> ( v1656(VarCurr,bitIndex10)
        | v1656(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_85,axiom,
    ! [VarCurr] :
      ( v1898(VarCurr)
    <=> ( v1656(VarCurr,bitIndex8)
        | v1656(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_194,axiom,
    ! [VarCurr] :
      ( v1889(VarCurr)
    <=> ( v1890(VarCurr)
        | v1893(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_193,axiom,
    ! [VarCurr] :
      ( v1893(VarCurr)
    <=> ( v1894(VarCurr)
        | v1895(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_84,axiom,
    ! [VarCurr] :
      ( v1895(VarCurr)
    <=> ( v1656(VarCurr,bitIndex6)
        | v1656(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_83,axiom,
    ! [VarCurr] :
      ( v1894(VarCurr)
    <=> ( v1656(VarCurr,bitIndex4)
        | v1656(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_192,axiom,
    ! [VarCurr] :
      ( v1890(VarCurr)
    <=> ( v1891(VarCurr)
        | v1892(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_82,axiom,
    ! [VarCurr] :
      ( v1892(VarCurr)
    <=> ( v1656(VarCurr,bitIndex2)
        | v1656(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_81,axiom,
    ! [VarCurr] :
      ( v1891(VarCurr)
    <=> ( v1656(VarCurr,bitIndex0)
        | v1656(VarCurr,bitIndex1) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_11,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1871(VarNext)
       => ! [B] :
            ( range_31_0(B)
           => ( v1656(VarNext,B)
            <=> v1656(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_12,axiom,
    ! [VarNext] :
      ( v1871(VarNext)
     => ! [B] :
          ( range_31_0(B)
         => ( v1656(VarNext,B)
          <=> v1881(VarNext,B) ) ) ) ).

fof(addAssignment_577,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_31_0(B)
         => ( v1881(VarNext,B)
          <=> v1879(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_46,axiom,
    ! [VarCurr] :
      ( ~ v1882(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v1879(VarCurr,B)
          <=> v1659(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_77,axiom,
    ! [VarCurr] :
      ( v1882(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v1879(VarCurr,B)
          <=> b11111111111111111111111111111110(B) ) ) ) ).

fof(writeUnaryOperator_103,axiom,
    ! [VarCurr] :
      ( ~ v1882(VarCurr)
    <=> v1387(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_191,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1871(VarNext)
      <=> v1872(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_190,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1872(VarNext)
      <=> ( v1873(VarNext)
          & v1868(VarNext) ) ) ) ).

fof(writeUnaryOperator_102,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1873(VarNext)
      <=> v1875(VarNext) ) ) ).

fof(addAssignment_576,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1875(VarNext)
      <=> v1868(VarCurr) ) ) ).

fof(addAssignment_575,axiom,
    ! [VarCurr] :
      ( v1868(VarCurr)
    <=> v1624(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_4,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v1659(VarCurr,B)
      <=> ( v1865(VarCurr,B)
          & v1866(VarCurr,B) ) ) ) ).

fof(writeUnaryOperator_101,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v1866(VarCurr,B)
      <=> ~ v1853(VarCurr,B) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_3,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v1865(VarCurr,B)
      <=> ( v1661(VarCurr,B)
          | v1656(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_2,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v1853(VarCurr,B)
      <=> ( v1855(VarCurr,B)
          & v1862(VarCurr,B) ) ) ) ).

fof(addAssignment_574,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex0)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_573,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex1)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_572,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex2)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_571,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex3)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_570,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex4)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_569,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex5)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_568,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex6)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_567,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex7)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_566,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex8)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_565,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex9)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_564,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex10)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_563,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex11)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_562,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex12)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_561,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex13)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_560,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex14)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_559,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex15)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_558,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex16)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_557,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex17)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_556,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex18)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_555,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex19)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_554,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex20)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_553,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex21)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_552,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex22)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_551,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex23)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_550,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex24)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_549,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex25)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_548,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex26)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_547,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex27)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_546,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex28)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_545,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex29)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_544,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex30)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_543,axiom,
    ! [VarCurr] :
      ( v1862(VarCurr,bitIndex31)
    <=> v1863(VarCurr) ) ).

fof(addAssignment_542,axiom,
    ! [VarCurr] :
      ( v1863(VarCurr)
    <=> v1389(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_1,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v1855(VarCurr,B)
      <=> ( v1656(VarCurr,B)
          & v1860(VarCurr,B) ) ) ) ).

fof(writeUnaryOperator_100,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v1860(VarCurr,B)
      <=> ~ v1857(VarCurr,B) ) ) ).

fof(writeBinaryOperatorShiftedRanges_80,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex1)
    <=> ( v1857(VarCurr,bitIndex0)
        | v1656(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_79,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex2)
    <=> ( v1857(VarCurr,bitIndex1)
        | v1656(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_78,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex3)
    <=> ( v1857(VarCurr,bitIndex2)
        | v1656(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_77,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex4)
    <=> ( v1857(VarCurr,bitIndex3)
        | v1656(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_76,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex5)
    <=> ( v1857(VarCurr,bitIndex4)
        | v1656(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_75,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex6)
    <=> ( v1857(VarCurr,bitIndex5)
        | v1656(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_74,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex7)
    <=> ( v1857(VarCurr,bitIndex6)
        | v1656(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_73,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex8)
    <=> ( v1857(VarCurr,bitIndex7)
        | v1656(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_72,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex9)
    <=> ( v1857(VarCurr,bitIndex8)
        | v1656(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_71,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex10)
    <=> ( v1857(VarCurr,bitIndex9)
        | v1656(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_70,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex11)
    <=> ( v1857(VarCurr,bitIndex10)
        | v1656(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_69,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex12)
    <=> ( v1857(VarCurr,bitIndex11)
        | v1656(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_68,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex13)
    <=> ( v1857(VarCurr,bitIndex12)
        | v1656(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorShiftedRanges_67,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex14)
    <=> ( v1857(VarCurr,bitIndex13)
        | v1656(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorShiftedRanges_66,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex15)
    <=> ( v1857(VarCurr,bitIndex14)
        | v1656(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorShiftedRanges_65,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex16)
    <=> ( v1857(VarCurr,bitIndex15)
        | v1656(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorShiftedRanges_64,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex17)
    <=> ( v1857(VarCurr,bitIndex16)
        | v1656(VarCurr,bitIndex16) ) ) ).

fof(writeBinaryOperatorShiftedRanges_63,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex18)
    <=> ( v1857(VarCurr,bitIndex17)
        | v1656(VarCurr,bitIndex17) ) ) ).

fof(writeBinaryOperatorShiftedRanges_62,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex19)
    <=> ( v1857(VarCurr,bitIndex18)
        | v1656(VarCurr,bitIndex18) ) ) ).

fof(writeBinaryOperatorShiftedRanges_61,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex20)
    <=> ( v1857(VarCurr,bitIndex19)
        | v1656(VarCurr,bitIndex19) ) ) ).

fof(writeBinaryOperatorShiftedRanges_60,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex21)
    <=> ( v1857(VarCurr,bitIndex20)
        | v1656(VarCurr,bitIndex20) ) ) ).

fof(writeBinaryOperatorShiftedRanges_59,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex22)
    <=> ( v1857(VarCurr,bitIndex21)
        | v1656(VarCurr,bitIndex21) ) ) ).

fof(writeBinaryOperatorShiftedRanges_58,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex23)
    <=> ( v1857(VarCurr,bitIndex22)
        | v1656(VarCurr,bitIndex22) ) ) ).

fof(writeBinaryOperatorShiftedRanges_57,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex24)
    <=> ( v1857(VarCurr,bitIndex23)
        | v1656(VarCurr,bitIndex23) ) ) ).

fof(writeBinaryOperatorShiftedRanges_56,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex25)
    <=> ( v1857(VarCurr,bitIndex24)
        | v1656(VarCurr,bitIndex24) ) ) ).

fof(writeBinaryOperatorShiftedRanges_55,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex26)
    <=> ( v1857(VarCurr,bitIndex25)
        | v1656(VarCurr,bitIndex25) ) ) ).

fof(writeBinaryOperatorShiftedRanges_54,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex27)
    <=> ( v1857(VarCurr,bitIndex26)
        | v1656(VarCurr,bitIndex26) ) ) ).

fof(writeBinaryOperatorShiftedRanges_53,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex28)
    <=> ( v1857(VarCurr,bitIndex27)
        | v1656(VarCurr,bitIndex27) ) ) ).

fof(writeBinaryOperatorShiftedRanges_52,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex29)
    <=> ( v1857(VarCurr,bitIndex28)
        | v1656(VarCurr,bitIndex28) ) ) ).

fof(writeBinaryOperatorShiftedRanges_51,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex30)
    <=> ( v1857(VarCurr,bitIndex29)
        | v1656(VarCurr,bitIndex29) ) ) ).

fof(writeBinaryOperatorShiftedRanges_50,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex31)
    <=> ( v1857(VarCurr,bitIndex30)
        | v1656(VarCurr,bitIndex30) ) ) ).

fof(addAssignmentInitValue_112,axiom,
    v1656(constB0,bitIndex31) ).

fof(addAssignmentInitValue_111,axiom,
    v1656(constB0,bitIndex30) ).

fof(addAssignmentInitValue_110,axiom,
    v1656(constB0,bitIndex29) ).

fof(addAssignmentInitValue_109,axiom,
    v1656(constB0,bitIndex28) ).

fof(addAssignmentInitValue_108,axiom,
    v1656(constB0,bitIndex27) ).

fof(addAssignmentInitValue_107,axiom,
    v1656(constB0,bitIndex26) ).

fof(addAssignmentInitValue_106,axiom,
    v1656(constB0,bitIndex25) ).

fof(addAssignmentInitValue_105,axiom,
    v1656(constB0,bitIndex24) ).

fof(addAssignmentInitValue_104,axiom,
    v1656(constB0,bitIndex23) ).

fof(addAssignmentInitValue_103,axiom,
    v1656(constB0,bitIndex22) ).

fof(addAssignmentInitValue_102,axiom,
    v1656(constB0,bitIndex21) ).

fof(addAssignmentInitValue_101,axiom,
    v1656(constB0,bitIndex20) ).

fof(addAssignmentInitValue_100,axiom,
    v1656(constB0,bitIndex19) ).

fof(addAssignmentInitValue_99,axiom,
    v1656(constB0,bitIndex18) ).

fof(addAssignmentInitValue_98,axiom,
    v1656(constB0,bitIndex17) ).

fof(addAssignmentInitValue_97,axiom,
    v1656(constB0,bitIndex16) ).

fof(addAssignmentInitValue_96,axiom,
    v1656(constB0,bitIndex15) ).

fof(addAssignmentInitValue_95,axiom,
    v1656(constB0,bitIndex14) ).

fof(addAssignmentInitValue_94,axiom,
    v1656(constB0,bitIndex13) ).

fof(addAssignmentInitValue_93,axiom,
    v1656(constB0,bitIndex12) ).

fof(addAssignmentInitValue_92,axiom,
    v1656(constB0,bitIndex11) ).

fof(addAssignmentInitValue_91,axiom,
    v1656(constB0,bitIndex10) ).

fof(addAssignmentInitValue_90,axiom,
    v1656(constB0,bitIndex9) ).

fof(addAssignmentInitValue_89,axiom,
    v1656(constB0,bitIndex8) ).

fof(addAssignmentInitValue_88,axiom,
    v1656(constB0,bitIndex7) ).

fof(addAssignmentInitValue_87,axiom,
    v1656(constB0,bitIndex6) ).

fof(addAssignmentInitValue_86,axiom,
    v1656(constB0,bitIndex5) ).

fof(addAssignmentInitValue_85,axiom,
    v1656(constB0,bitIndex4) ).

fof(addAssignmentInitValue_84,axiom,
    v1656(constB0,bitIndex3) ).

fof(addAssignmentInitValue_83,axiom,
    v1656(constB0,bitIndex2) ).

fof(addAssignmentInitValue_82,axiom,
    v1656(constB0,bitIndex1) ).

fof(addAssignmentInitValue_81,axiom,
    ~ v1656(constB0,bitIndex0) ).

fof(bitBlastConstant_657,axiom,
    b11111111111111111111111111111110(bitIndex31) ).

fof(bitBlastConstant_656,axiom,
    b11111111111111111111111111111110(bitIndex30) ).

fof(bitBlastConstant_655,axiom,
    b11111111111111111111111111111110(bitIndex29) ).

fof(bitBlastConstant_654,axiom,
    b11111111111111111111111111111110(bitIndex28) ).

fof(bitBlastConstant_653,axiom,
    b11111111111111111111111111111110(bitIndex27) ).

fof(bitBlastConstant_652,axiom,
    b11111111111111111111111111111110(bitIndex26) ).

fof(bitBlastConstant_651,axiom,
    b11111111111111111111111111111110(bitIndex25) ).

fof(bitBlastConstant_650,axiom,
    b11111111111111111111111111111110(bitIndex24) ).

fof(bitBlastConstant_649,axiom,
    b11111111111111111111111111111110(bitIndex23) ).

fof(bitBlastConstant_648,axiom,
    b11111111111111111111111111111110(bitIndex22) ).

fof(bitBlastConstant_647,axiom,
    b11111111111111111111111111111110(bitIndex21) ).

fof(bitBlastConstant_646,axiom,
    b11111111111111111111111111111110(bitIndex20) ).

fof(bitBlastConstant_645,axiom,
    b11111111111111111111111111111110(bitIndex19) ).

fof(bitBlastConstant_644,axiom,
    b11111111111111111111111111111110(bitIndex18) ).

fof(bitBlastConstant_643,axiom,
    b11111111111111111111111111111110(bitIndex17) ).

fof(bitBlastConstant_642,axiom,
    b11111111111111111111111111111110(bitIndex16) ).

fof(bitBlastConstant_641,axiom,
    b11111111111111111111111111111110(bitIndex15) ).

fof(bitBlastConstant_640,axiom,
    b11111111111111111111111111111110(bitIndex14) ).

fof(bitBlastConstant_639,axiom,
    b11111111111111111111111111111110(bitIndex13) ).

fof(bitBlastConstant_638,axiom,
    b11111111111111111111111111111110(bitIndex12) ).

fof(bitBlastConstant_637,axiom,
    b11111111111111111111111111111110(bitIndex11) ).

fof(bitBlastConstant_636,axiom,
    b11111111111111111111111111111110(bitIndex10) ).

fof(bitBlastConstant_635,axiom,
    b11111111111111111111111111111110(bitIndex9) ).

fof(bitBlastConstant_634,axiom,
    b11111111111111111111111111111110(bitIndex8) ).

fof(bitBlastConstant_633,axiom,
    b11111111111111111111111111111110(bitIndex7) ).

fof(bitBlastConstant_632,axiom,
    b11111111111111111111111111111110(bitIndex6) ).

fof(bitBlastConstant_631,axiom,
    b11111111111111111111111111111110(bitIndex5) ).

fof(bitBlastConstant_630,axiom,
    b11111111111111111111111111111110(bitIndex4) ).

fof(bitBlastConstant_629,axiom,
    b11111111111111111111111111111110(bitIndex3) ).

fof(bitBlastConstant_628,axiom,
    b11111111111111111111111111111110(bitIndex2) ).

fof(bitBlastConstant_627,axiom,
    b11111111111111111111111111111110(bitIndex1) ).

fof(bitBlastConstant_626,axiom,
    ~ b11111111111111111111111111111110(bitIndex0) ).

fof(addAssignment_541,axiom,
    ! [VarCurr] :
      ( v1857(VarCurr,bitIndex0)
    <=> $false ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_45,axiom,
    ! [VarCurr] :
      ( ~ v1848(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v1661(VarCurr,B)
          <=> v1849(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_76,axiom,
    ! [VarCurr] :
      ( v1848(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v1661(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v1849(VarCurr,B)
      <=> ( v1663(VarCurr,B)
          & v1850(VarCurr,B) ) ) ) ).

fof(addAssignment_540,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex0)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_539,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex1)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_538,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex2)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_537,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex3)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_536,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex4)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_535,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex5)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_534,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex6)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_533,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex7)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_532,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex8)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_531,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex9)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_530,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex10)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_529,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex11)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_528,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex12)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_527,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex13)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_526,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex14)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_525,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex15)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_524,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex16)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_523,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex17)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_522,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex18)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_521,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex19)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_520,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex20)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_519,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex21)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_518,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex22)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_517,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex23)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_516,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex24)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_515,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex25)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_514,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex26)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_513,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex27)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_512,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex28)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_511,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex29)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_510,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex30)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_509,axiom,
    ! [VarCurr] :
      ( v1850(VarCurr,bitIndex31)
    <=> v1851(VarCurr) ) ).

fof(addAssignment_508,axiom,
    ! [VarCurr] :
      ( v1851(VarCurr)
    <=> v1410(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_189,axiom,
    ! [VarCurr] :
      ( v1848(VarCurr)
    <=> ( v1385(VarCurr)
        & v1410(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_26,axiom,
    ( v1385(constB0)
  <=> $false ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_34,axiom,
    ! [VarCurr] :
      ( ~ v1846(VarCurr)
     => ( v1663(VarCurr,bitIndex31)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_75,axiom,
    ! [VarCurr] :
      ( v1846(VarCurr)
     => ( v1663(VarCurr,bitIndex31)
      <=> v1782(VarCurr,bitIndex31) ) ) ).

fof(addBitVectorEqualityBitBlasted_115,axiom,
    ! [VarCurr] :
      ( v1846(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $true )
        & ( v1665(VarCurr,bitIndex3)
        <=> $true )
        & ( v1665(VarCurr,bitIndex2)
        <=> $true )
        & ( v1665(VarCurr,bitIndex1)
        <=> $true )
        & ( v1665(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_625,axiom,
    b11111(bitIndex4) ).

fof(bitBlastConstant_624,axiom,
    b11111(bitIndex3) ).

fof(bitBlastConstant_623,axiom,
    b11111(bitIndex2) ).

fof(bitBlastConstant_622,axiom,
    b11111(bitIndex1) ).

fof(bitBlastConstant_621,axiom,
    b11111(bitIndex0) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_33,axiom,
    ! [VarCurr] :
      ( ~ v1844(VarCurr)
     => ( v1663(VarCurr,bitIndex30)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_74,axiom,
    ! [VarCurr] :
      ( v1844(VarCurr)
     => ( v1663(VarCurr,bitIndex30)
      <=> v1779(VarCurr,bitIndex30) ) ) ).

fof(addBitVectorEqualityBitBlasted_114,axiom,
    ! [VarCurr] :
      ( v1844(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $true )
        & ( v1665(VarCurr,bitIndex3)
        <=> $true )
        & ( v1665(VarCurr,bitIndex2)
        <=> $true )
        & ( v1665(VarCurr,bitIndex1)
        <=> $true )
        & ( v1665(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_620,axiom,
    b11110(bitIndex4) ).

fof(bitBlastConstant_619,axiom,
    b11110(bitIndex3) ).

fof(bitBlastConstant_618,axiom,
    b11110(bitIndex2) ).

fof(bitBlastConstant_617,axiom,
    b11110(bitIndex1) ).

fof(bitBlastConstant_616,axiom,
    ~ b11110(bitIndex0) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_32,axiom,
    ! [VarCurr] :
      ( ~ v1842(VarCurr)
     => ( v1663(VarCurr,bitIndex29)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_73,axiom,
    ! [VarCurr] :
      ( v1842(VarCurr)
     => ( v1663(VarCurr,bitIndex29)
      <=> v1776(VarCurr,bitIndex29) ) ) ).

fof(addBitVectorEqualityBitBlasted_113,axiom,
    ! [VarCurr] :
      ( v1842(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $true )
        & ( v1665(VarCurr,bitIndex3)
        <=> $true )
        & ( v1665(VarCurr,bitIndex2)
        <=> $true )
        & ( v1665(VarCurr,bitIndex1)
        <=> $false )
        & ( v1665(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_615,axiom,
    b11101(bitIndex4) ).

fof(bitBlastConstant_614,axiom,
    b11101(bitIndex3) ).

fof(bitBlastConstant_613,axiom,
    b11101(bitIndex2) ).

fof(bitBlastConstant_612,axiom,
    ~ b11101(bitIndex1) ).

fof(bitBlastConstant_611,axiom,
    b11101(bitIndex0) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_31,axiom,
    ! [VarCurr] :
      ( ~ v1840(VarCurr)
     => ( v1663(VarCurr,bitIndex28)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_72,axiom,
    ! [VarCurr] :
      ( v1840(VarCurr)
     => ( v1663(VarCurr,bitIndex28)
      <=> v1773(VarCurr,bitIndex28) ) ) ).

fof(addBitVectorEqualityBitBlasted_112,axiom,
    ! [VarCurr] :
      ( v1840(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $true )
        & ( v1665(VarCurr,bitIndex3)
        <=> $true )
        & ( v1665(VarCurr,bitIndex2)
        <=> $true )
        & ( v1665(VarCurr,bitIndex1)
        <=> $false )
        & ( v1665(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_610,axiom,
    b11100(bitIndex4) ).

fof(bitBlastConstant_609,axiom,
    b11100(bitIndex3) ).

fof(bitBlastConstant_608,axiom,
    b11100(bitIndex2) ).

fof(bitBlastConstant_607,axiom,
    ~ b11100(bitIndex1) ).

fof(bitBlastConstant_606,axiom,
    ~ b11100(bitIndex0) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_30,axiom,
    ! [VarCurr] :
      ( ~ v1838(VarCurr)
     => ( v1663(VarCurr,bitIndex27)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_71,axiom,
    ! [VarCurr] :
      ( v1838(VarCurr)
     => ( v1663(VarCurr,bitIndex27)
      <=> v1770(VarCurr,bitIndex27) ) ) ).

fof(addBitVectorEqualityBitBlasted_111,axiom,
    ! [VarCurr] :
      ( v1838(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $true )
        & ( v1665(VarCurr,bitIndex3)
        <=> $true )
        & ( v1665(VarCurr,bitIndex2)
        <=> $false )
        & ( v1665(VarCurr,bitIndex1)
        <=> $true )
        & ( v1665(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_605,axiom,
    b11011(bitIndex4) ).

fof(bitBlastConstant_604,axiom,
    b11011(bitIndex3) ).

fof(bitBlastConstant_603,axiom,
    ~ b11011(bitIndex2) ).

fof(bitBlastConstant_602,axiom,
    b11011(bitIndex1) ).

fof(bitBlastConstant_601,axiom,
    b11011(bitIndex0) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_29,axiom,
    ! [VarCurr] :
      ( ~ v1836(VarCurr)
     => ( v1663(VarCurr,bitIndex26)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_70,axiom,
    ! [VarCurr] :
      ( v1836(VarCurr)
     => ( v1663(VarCurr,bitIndex26)
      <=> v1767(VarCurr,bitIndex26) ) ) ).

fof(addBitVectorEqualityBitBlasted_110,axiom,
    ! [VarCurr] :
      ( v1836(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $true )
        & ( v1665(VarCurr,bitIndex3)
        <=> $true )
        & ( v1665(VarCurr,bitIndex2)
        <=> $false )
        & ( v1665(VarCurr,bitIndex1)
        <=> $true )
        & ( v1665(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_600,axiom,
    b11010(bitIndex4) ).

fof(bitBlastConstant_599,axiom,
    b11010(bitIndex3) ).

fof(bitBlastConstant_598,axiom,
    ~ b11010(bitIndex2) ).

fof(bitBlastConstant_597,axiom,
    b11010(bitIndex1) ).

fof(bitBlastConstant_596,axiom,
    ~ b11010(bitIndex0) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_28,axiom,
    ! [VarCurr] :
      ( ~ v1834(VarCurr)
     => ( v1663(VarCurr,bitIndex25)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_69,axiom,
    ! [VarCurr] :
      ( v1834(VarCurr)
     => ( v1663(VarCurr,bitIndex25)
      <=> v1764(VarCurr,bitIndex25) ) ) ).

fof(addBitVectorEqualityBitBlasted_109,axiom,
    ! [VarCurr] :
      ( v1834(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $true )
        & ( v1665(VarCurr,bitIndex3)
        <=> $true )
        & ( v1665(VarCurr,bitIndex2)
        <=> $false )
        & ( v1665(VarCurr,bitIndex1)
        <=> $false )
        & ( v1665(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_595,axiom,
    b11001(bitIndex4) ).

fof(bitBlastConstant_594,axiom,
    b11001(bitIndex3) ).

fof(bitBlastConstant_593,axiom,
    ~ b11001(bitIndex2) ).

fof(bitBlastConstant_592,axiom,
    ~ b11001(bitIndex1) ).

fof(bitBlastConstant_591,axiom,
    b11001(bitIndex0) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_27,axiom,
    ! [VarCurr] :
      ( ~ v1832(VarCurr)
     => ( v1663(VarCurr,bitIndex24)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_68,axiom,
    ! [VarCurr] :
      ( v1832(VarCurr)
     => ( v1663(VarCurr,bitIndex24)
      <=> v1761(VarCurr,bitIndex24) ) ) ).

fof(addBitVectorEqualityBitBlasted_108,axiom,
    ! [VarCurr] :
      ( v1832(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $true )
        & ( v1665(VarCurr,bitIndex3)
        <=> $true )
        & ( v1665(VarCurr,bitIndex2)
        <=> $false )
        & ( v1665(VarCurr,bitIndex1)
        <=> $false )
        & ( v1665(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_590,axiom,
    b11000(bitIndex4) ).

fof(bitBlastConstant_589,axiom,
    b11000(bitIndex3) ).

fof(bitBlastConstant_588,axiom,
    ~ b11000(bitIndex2) ).

fof(bitBlastConstant_587,axiom,
    ~ b11000(bitIndex1) ).

fof(bitBlastConstant_586,axiom,
    ~ b11000(bitIndex0) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_26,axiom,
    ! [VarCurr] :
      ( ~ v1830(VarCurr)
     => ( v1663(VarCurr,bitIndex23)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_67,axiom,
    ! [VarCurr] :
      ( v1830(VarCurr)
     => ( v1663(VarCurr,bitIndex23)
      <=> v1758(VarCurr,bitIndex23) ) ) ).

fof(addBitVectorEqualityBitBlasted_107,axiom,
    ! [VarCurr] :
      ( v1830(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $true )
        & ( v1665(VarCurr,bitIndex3)
        <=> $false )
        & ( v1665(VarCurr,bitIndex2)
        <=> $true )
        & ( v1665(VarCurr,bitIndex1)
        <=> $true )
        & ( v1665(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_585,axiom,
    b10111(bitIndex4) ).

fof(bitBlastConstant_584,axiom,
    ~ b10111(bitIndex3) ).

fof(bitBlastConstant_583,axiom,
    b10111(bitIndex2) ).

fof(bitBlastConstant_582,axiom,
    b10111(bitIndex1) ).

fof(bitBlastConstant_581,axiom,
    b10111(bitIndex0) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_25,axiom,
    ! [VarCurr] :
      ( ~ v1828(VarCurr)
     => ( v1663(VarCurr,bitIndex22)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_66,axiom,
    ! [VarCurr] :
      ( v1828(VarCurr)
     => ( v1663(VarCurr,bitIndex22)
      <=> v1755(VarCurr,bitIndex22) ) ) ).

fof(addBitVectorEqualityBitBlasted_106,axiom,
    ! [VarCurr] :
      ( v1828(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $true )
        & ( v1665(VarCurr,bitIndex3)
        <=> $false )
        & ( v1665(VarCurr,bitIndex2)
        <=> $true )
        & ( v1665(VarCurr,bitIndex1)
        <=> $true )
        & ( v1665(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_580,axiom,
    b10110(bitIndex4) ).

fof(bitBlastConstant_579,axiom,
    ~ b10110(bitIndex3) ).

fof(bitBlastConstant_578,axiom,
    b10110(bitIndex2) ).

fof(bitBlastConstant_577,axiom,
    b10110(bitIndex1) ).

fof(bitBlastConstant_576,axiom,
    ~ b10110(bitIndex0) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_24,axiom,
    ! [VarCurr] :
      ( ~ v1826(VarCurr)
     => ( v1663(VarCurr,bitIndex21)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_65,axiom,
    ! [VarCurr] :
      ( v1826(VarCurr)
     => ( v1663(VarCurr,bitIndex21)
      <=> v1752(VarCurr,bitIndex21) ) ) ).

fof(addBitVectorEqualityBitBlasted_105,axiom,
    ! [VarCurr] :
      ( v1826(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $true )
        & ( v1665(VarCurr,bitIndex3)
        <=> $false )
        & ( v1665(VarCurr,bitIndex2)
        <=> $true )
        & ( v1665(VarCurr,bitIndex1)
        <=> $false )
        & ( v1665(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_575,axiom,
    b10101(bitIndex4) ).

fof(bitBlastConstant_574,axiom,
    ~ b10101(bitIndex3) ).

fof(bitBlastConstant_573,axiom,
    b10101(bitIndex2) ).

fof(bitBlastConstant_572,axiom,
    ~ b10101(bitIndex1) ).

fof(bitBlastConstant_571,axiom,
    b10101(bitIndex0) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_23,axiom,
    ! [VarCurr] :
      ( ~ v1824(VarCurr)
     => ( v1663(VarCurr,bitIndex20)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_64,axiom,
    ! [VarCurr] :
      ( v1824(VarCurr)
     => ( v1663(VarCurr,bitIndex20)
      <=> v1749(VarCurr,bitIndex20) ) ) ).

fof(addBitVectorEqualityBitBlasted_104,axiom,
    ! [VarCurr] :
      ( v1824(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $true )
        & ( v1665(VarCurr,bitIndex3)
        <=> $false )
        & ( v1665(VarCurr,bitIndex2)
        <=> $true )
        & ( v1665(VarCurr,bitIndex1)
        <=> $false )
        & ( v1665(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_570,axiom,
    b10100(bitIndex4) ).

fof(bitBlastConstant_569,axiom,
    ~ b10100(bitIndex3) ).

fof(bitBlastConstant_568,axiom,
    b10100(bitIndex2) ).

fof(bitBlastConstant_567,axiom,
    ~ b10100(bitIndex1) ).

fof(bitBlastConstant_566,axiom,
    ~ b10100(bitIndex0) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_22,axiom,
    ! [VarCurr] :
      ( ~ v1822(VarCurr)
     => ( v1663(VarCurr,bitIndex19)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_63,axiom,
    ! [VarCurr] :
      ( v1822(VarCurr)
     => ( v1663(VarCurr,bitIndex19)
      <=> v1746(VarCurr,bitIndex19) ) ) ).

fof(addBitVectorEqualityBitBlasted_103,axiom,
    ! [VarCurr] :
      ( v1822(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $true )
        & ( v1665(VarCurr,bitIndex3)
        <=> $false )
        & ( v1665(VarCurr,bitIndex2)
        <=> $false )
        & ( v1665(VarCurr,bitIndex1)
        <=> $true )
        & ( v1665(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_565,axiom,
    b10011(bitIndex4) ).

fof(bitBlastConstant_564,axiom,
    ~ b10011(bitIndex3) ).

fof(bitBlastConstant_563,axiom,
    ~ b10011(bitIndex2) ).

fof(bitBlastConstant_562,axiom,
    b10011(bitIndex1) ).

fof(bitBlastConstant_561,axiom,
    b10011(bitIndex0) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_21,axiom,
    ! [VarCurr] :
      ( ~ v1820(VarCurr)
     => ( v1663(VarCurr,bitIndex18)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_62,axiom,
    ! [VarCurr] :
      ( v1820(VarCurr)
     => ( v1663(VarCurr,bitIndex18)
      <=> v1743(VarCurr,bitIndex18) ) ) ).

fof(addBitVectorEqualityBitBlasted_102,axiom,
    ! [VarCurr] :
      ( v1820(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $true )
        & ( v1665(VarCurr,bitIndex3)
        <=> $false )
        & ( v1665(VarCurr,bitIndex2)
        <=> $false )
        & ( v1665(VarCurr,bitIndex1)
        <=> $true )
        & ( v1665(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_560,axiom,
    b10010(bitIndex4) ).

fof(bitBlastConstant_559,axiom,
    ~ b10010(bitIndex3) ).

fof(bitBlastConstant_558,axiom,
    ~ b10010(bitIndex2) ).

fof(bitBlastConstant_557,axiom,
    b10010(bitIndex1) ).

fof(bitBlastConstant_556,axiom,
    ~ b10010(bitIndex0) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_20,axiom,
    ! [VarCurr] :
      ( ~ v1818(VarCurr)
     => ( v1663(VarCurr,bitIndex17)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_61,axiom,
    ! [VarCurr] :
      ( v1818(VarCurr)
     => ( v1663(VarCurr,bitIndex17)
      <=> v1740(VarCurr,bitIndex17) ) ) ).

fof(addBitVectorEqualityBitBlasted_101,axiom,
    ! [VarCurr] :
      ( v1818(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $true )
        & ( v1665(VarCurr,bitIndex3)
        <=> $false )
        & ( v1665(VarCurr,bitIndex2)
        <=> $false )
        & ( v1665(VarCurr,bitIndex1)
        <=> $false )
        & ( v1665(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_555,axiom,
    b10001(bitIndex4) ).

fof(bitBlastConstant_554,axiom,
    ~ b10001(bitIndex3) ).

fof(bitBlastConstant_553,axiom,
    ~ b10001(bitIndex2) ).

fof(bitBlastConstant_552,axiom,
    ~ b10001(bitIndex1) ).

fof(bitBlastConstant_551,axiom,
    b10001(bitIndex0) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_19,axiom,
    ! [VarCurr] :
      ( ~ v1816(VarCurr)
     => ( v1663(VarCurr,bitIndex16)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_60,axiom,
    ! [VarCurr] :
      ( v1816(VarCurr)
     => ( v1663(VarCurr,bitIndex16)
      <=> v1737(VarCurr,bitIndex16) ) ) ).

fof(addBitVectorEqualityBitBlasted_100,axiom,
    ! [VarCurr] :
      ( v1816(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $true )
        & ( v1665(VarCurr,bitIndex3)
        <=> $false )
        & ( v1665(VarCurr,bitIndex2)
        <=> $false )
        & ( v1665(VarCurr,bitIndex1)
        <=> $false )
        & ( v1665(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_550,axiom,
    b10000(bitIndex4) ).

fof(bitBlastConstant_549,axiom,
    ~ b10000(bitIndex3) ).

fof(bitBlastConstant_548,axiom,
    ~ b10000(bitIndex2) ).

fof(bitBlastConstant_547,axiom,
    ~ b10000(bitIndex1) ).

fof(bitBlastConstant_546,axiom,
    ~ b10000(bitIndex0) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_18,axiom,
    ! [VarCurr] :
      ( ~ v1814(VarCurr)
     => ( v1663(VarCurr,bitIndex15)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_59,axiom,
    ! [VarCurr] :
      ( v1814(VarCurr)
     => ( v1663(VarCurr,bitIndex15)
      <=> v1734(VarCurr,bitIndex15) ) ) ).

fof(addBitVectorEqualityBitBlasted_99,axiom,
    ! [VarCurr] :
      ( v1814(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $false )
        & ( v1665(VarCurr,bitIndex3)
        <=> $true )
        & ( v1665(VarCurr,bitIndex2)
        <=> $true )
        & ( v1665(VarCurr,bitIndex1)
        <=> $true )
        & ( v1665(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_545,axiom,
    ~ b01111(bitIndex4) ).

fof(bitBlastConstant_544,axiom,
    b01111(bitIndex3) ).

fof(bitBlastConstant_543,axiom,
    b01111(bitIndex2) ).

fof(bitBlastConstant_542,axiom,
    b01111(bitIndex1) ).

fof(bitBlastConstant_541,axiom,
    b01111(bitIndex0) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_17,axiom,
    ! [VarCurr] :
      ( ~ v1812(VarCurr)
     => ( v1663(VarCurr,bitIndex14)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_58,axiom,
    ! [VarCurr] :
      ( v1812(VarCurr)
     => ( v1663(VarCurr,bitIndex14)
      <=> v1731(VarCurr,bitIndex14) ) ) ).

fof(addBitVectorEqualityBitBlasted_98,axiom,
    ! [VarCurr] :
      ( v1812(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $false )
        & ( v1665(VarCurr,bitIndex3)
        <=> $true )
        & ( v1665(VarCurr,bitIndex2)
        <=> $true )
        & ( v1665(VarCurr,bitIndex1)
        <=> $true )
        & ( v1665(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_540,axiom,
    ~ b01110(bitIndex4) ).

fof(bitBlastConstant_539,axiom,
    b01110(bitIndex3) ).

fof(bitBlastConstant_538,axiom,
    b01110(bitIndex2) ).

fof(bitBlastConstant_537,axiom,
    b01110(bitIndex1) ).

fof(bitBlastConstant_536,axiom,
    ~ b01110(bitIndex0) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_16,axiom,
    ! [VarCurr] :
      ( ~ v1810(VarCurr)
     => ( v1663(VarCurr,bitIndex13)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_57,axiom,
    ! [VarCurr] :
      ( v1810(VarCurr)
     => ( v1663(VarCurr,bitIndex13)
      <=> v1728(VarCurr,bitIndex13) ) ) ).

fof(addBitVectorEqualityBitBlasted_97,axiom,
    ! [VarCurr] :
      ( v1810(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $false )
        & ( v1665(VarCurr,bitIndex3)
        <=> $true )
        & ( v1665(VarCurr,bitIndex2)
        <=> $true )
        & ( v1665(VarCurr,bitIndex1)
        <=> $false )
        & ( v1665(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_535,axiom,
    ~ b01101(bitIndex4) ).

fof(bitBlastConstant_534,axiom,
    b01101(bitIndex3) ).

fof(bitBlastConstant_533,axiom,
    b01101(bitIndex2) ).

fof(bitBlastConstant_532,axiom,
    ~ b01101(bitIndex1) ).

fof(bitBlastConstant_531,axiom,
    b01101(bitIndex0) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_15,axiom,
    ! [VarCurr] :
      ( ~ v1808(VarCurr)
     => ( v1663(VarCurr,bitIndex12)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_56,axiom,
    ! [VarCurr] :
      ( v1808(VarCurr)
     => ( v1663(VarCurr,bitIndex12)
      <=> v1725(VarCurr,bitIndex12) ) ) ).

fof(addBitVectorEqualityBitBlasted_96,axiom,
    ! [VarCurr] :
      ( v1808(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $false )
        & ( v1665(VarCurr,bitIndex3)
        <=> $true )
        & ( v1665(VarCurr,bitIndex2)
        <=> $true )
        & ( v1665(VarCurr,bitIndex1)
        <=> $false )
        & ( v1665(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_530,axiom,
    ~ b01100(bitIndex4) ).

fof(bitBlastConstant_529,axiom,
    b01100(bitIndex3) ).

fof(bitBlastConstant_528,axiom,
    b01100(bitIndex2) ).

fof(bitBlastConstant_527,axiom,
    ~ b01100(bitIndex1) ).

fof(bitBlastConstant_526,axiom,
    ~ b01100(bitIndex0) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_14,axiom,
    ! [VarCurr] :
      ( ~ v1806(VarCurr)
     => ( v1663(VarCurr,bitIndex11)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_55,axiom,
    ! [VarCurr] :
      ( v1806(VarCurr)
     => ( v1663(VarCurr,bitIndex11)
      <=> v1722(VarCurr,bitIndex11) ) ) ).

fof(addBitVectorEqualityBitBlasted_95,axiom,
    ! [VarCurr] :
      ( v1806(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $false )
        & ( v1665(VarCurr,bitIndex3)
        <=> $true )
        & ( v1665(VarCurr,bitIndex2)
        <=> $false )
        & ( v1665(VarCurr,bitIndex1)
        <=> $true )
        & ( v1665(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_525,axiom,
    ~ b01011(bitIndex4) ).

fof(bitBlastConstant_524,axiom,
    b01011(bitIndex3) ).

fof(bitBlastConstant_523,axiom,
    ~ b01011(bitIndex2) ).

fof(bitBlastConstant_522,axiom,
    b01011(bitIndex1) ).

fof(bitBlastConstant_521,axiom,
    b01011(bitIndex0) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_13,axiom,
    ! [VarCurr] :
      ( ~ v1804(VarCurr)
     => ( v1663(VarCurr,bitIndex10)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_54,axiom,
    ! [VarCurr] :
      ( v1804(VarCurr)
     => ( v1663(VarCurr,bitIndex10)
      <=> v1719(VarCurr,bitIndex10) ) ) ).

fof(addBitVectorEqualityBitBlasted_94,axiom,
    ! [VarCurr] :
      ( v1804(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $false )
        & ( v1665(VarCurr,bitIndex3)
        <=> $true )
        & ( v1665(VarCurr,bitIndex2)
        <=> $false )
        & ( v1665(VarCurr,bitIndex1)
        <=> $true )
        & ( v1665(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_520,axiom,
    ~ b01010(bitIndex4) ).

fof(bitBlastConstant_519,axiom,
    b01010(bitIndex3) ).

fof(bitBlastConstant_518,axiom,
    ~ b01010(bitIndex2) ).

fof(bitBlastConstant_517,axiom,
    b01010(bitIndex1) ).

fof(bitBlastConstant_516,axiom,
    ~ b01010(bitIndex0) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_12,axiom,
    ! [VarCurr] :
      ( ~ v1802(VarCurr)
     => ( v1663(VarCurr,bitIndex9)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_53,axiom,
    ! [VarCurr] :
      ( v1802(VarCurr)
     => ( v1663(VarCurr,bitIndex9)
      <=> v1716(VarCurr,bitIndex9) ) ) ).

fof(addBitVectorEqualityBitBlasted_93,axiom,
    ! [VarCurr] :
      ( v1802(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $false )
        & ( v1665(VarCurr,bitIndex3)
        <=> $true )
        & ( v1665(VarCurr,bitIndex2)
        <=> $false )
        & ( v1665(VarCurr,bitIndex1)
        <=> $false )
        & ( v1665(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_515,axiom,
    ~ b01001(bitIndex4) ).

fof(bitBlastConstant_514,axiom,
    b01001(bitIndex3) ).

fof(bitBlastConstant_513,axiom,
    ~ b01001(bitIndex2) ).

fof(bitBlastConstant_512,axiom,
    ~ b01001(bitIndex1) ).

fof(bitBlastConstant_511,axiom,
    b01001(bitIndex0) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_11,axiom,
    ! [VarCurr] :
      ( ~ v1800(VarCurr)
     => ( v1663(VarCurr,bitIndex8)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_52,axiom,
    ! [VarCurr] :
      ( v1800(VarCurr)
     => ( v1663(VarCurr,bitIndex8)
      <=> v1713(VarCurr,bitIndex8) ) ) ).

fof(addBitVectorEqualityBitBlasted_92,axiom,
    ! [VarCurr] :
      ( v1800(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $false )
        & ( v1665(VarCurr,bitIndex3)
        <=> $true )
        & ( v1665(VarCurr,bitIndex2)
        <=> $false )
        & ( v1665(VarCurr,bitIndex1)
        <=> $false )
        & ( v1665(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_510,axiom,
    ~ b01000(bitIndex4) ).

fof(bitBlastConstant_509,axiom,
    b01000(bitIndex3) ).

fof(bitBlastConstant_508,axiom,
    ~ b01000(bitIndex2) ).

fof(bitBlastConstant_507,axiom,
    ~ b01000(bitIndex1) ).

fof(bitBlastConstant_506,axiom,
    ~ b01000(bitIndex0) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_10,axiom,
    ! [VarCurr] :
      ( ~ v1798(VarCurr)
     => ( v1663(VarCurr,bitIndex7)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_51,axiom,
    ! [VarCurr] :
      ( v1798(VarCurr)
     => ( v1663(VarCurr,bitIndex7)
      <=> v1710(VarCurr,bitIndex7) ) ) ).

fof(addBitVectorEqualityBitBlasted_91,axiom,
    ! [VarCurr] :
      ( v1798(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $false )
        & ( v1665(VarCurr,bitIndex3)
        <=> $false )
        & ( v1665(VarCurr,bitIndex2)
        <=> $true )
        & ( v1665(VarCurr,bitIndex1)
        <=> $true )
        & ( v1665(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_505,axiom,
    ~ b00111(bitIndex4) ).

fof(bitBlastConstant_504,axiom,
    ~ b00111(bitIndex3) ).

fof(bitBlastConstant_503,axiom,
    b00111(bitIndex2) ).

fof(bitBlastConstant_502,axiom,
    b00111(bitIndex1) ).

fof(bitBlastConstant_501,axiom,
    b00111(bitIndex0) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_9,axiom,
    ! [VarCurr] :
      ( ~ v1796(VarCurr)
     => ( v1663(VarCurr,bitIndex6)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_50,axiom,
    ! [VarCurr] :
      ( v1796(VarCurr)
     => ( v1663(VarCurr,bitIndex6)
      <=> v1707(VarCurr,bitIndex6) ) ) ).

fof(addBitVectorEqualityBitBlasted_90,axiom,
    ! [VarCurr] :
      ( v1796(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $false )
        & ( v1665(VarCurr,bitIndex3)
        <=> $false )
        & ( v1665(VarCurr,bitIndex2)
        <=> $true )
        & ( v1665(VarCurr,bitIndex1)
        <=> $true )
        & ( v1665(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_500,axiom,
    ~ b00110(bitIndex4) ).

fof(bitBlastConstant_499,axiom,
    ~ b00110(bitIndex3) ).

fof(bitBlastConstant_498,axiom,
    b00110(bitIndex2) ).

fof(bitBlastConstant_497,axiom,
    b00110(bitIndex1) ).

fof(bitBlastConstant_496,axiom,
    ~ b00110(bitIndex0) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_8,axiom,
    ! [VarCurr] :
      ( ~ v1794(VarCurr)
     => ( v1663(VarCurr,bitIndex5)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_49,axiom,
    ! [VarCurr] :
      ( v1794(VarCurr)
     => ( v1663(VarCurr,bitIndex5)
      <=> v1704(VarCurr,bitIndex5) ) ) ).

fof(addBitVectorEqualityBitBlasted_89,axiom,
    ! [VarCurr] :
      ( v1794(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $false )
        & ( v1665(VarCurr,bitIndex3)
        <=> $false )
        & ( v1665(VarCurr,bitIndex2)
        <=> $true )
        & ( v1665(VarCurr,bitIndex1)
        <=> $false )
        & ( v1665(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_495,axiom,
    ~ b00101(bitIndex4) ).

fof(bitBlastConstant_494,axiom,
    ~ b00101(bitIndex3) ).

fof(bitBlastConstant_493,axiom,
    b00101(bitIndex2) ).

fof(bitBlastConstant_492,axiom,
    ~ b00101(bitIndex1) ).

fof(bitBlastConstant_491,axiom,
    b00101(bitIndex0) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_7,axiom,
    ! [VarCurr] :
      ( ~ v1792(VarCurr)
     => ( v1663(VarCurr,bitIndex4)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_48,axiom,
    ! [VarCurr] :
      ( v1792(VarCurr)
     => ( v1663(VarCurr,bitIndex4)
      <=> v1701(VarCurr,bitIndex4) ) ) ).

fof(addBitVectorEqualityBitBlasted_88,axiom,
    ! [VarCurr] :
      ( v1792(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $false )
        & ( v1665(VarCurr,bitIndex3)
        <=> $false )
        & ( v1665(VarCurr,bitIndex2)
        <=> $true )
        & ( v1665(VarCurr,bitIndex1)
        <=> $false )
        & ( v1665(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_490,axiom,
    ~ b00100(bitIndex4) ).

fof(bitBlastConstant_489,axiom,
    ~ b00100(bitIndex3) ).

fof(bitBlastConstant_488,axiom,
    b00100(bitIndex2) ).

fof(bitBlastConstant_487,axiom,
    ~ b00100(bitIndex1) ).

fof(bitBlastConstant_486,axiom,
    ~ b00100(bitIndex0) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_6,axiom,
    ! [VarCurr] :
      ( ~ v1790(VarCurr)
     => ( v1663(VarCurr,bitIndex3)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_47,axiom,
    ! [VarCurr] :
      ( v1790(VarCurr)
     => ( v1663(VarCurr,bitIndex3)
      <=> v1698(VarCurr,bitIndex3) ) ) ).

fof(addBitVectorEqualityBitBlasted_87,axiom,
    ! [VarCurr] :
      ( v1790(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $false )
        & ( v1665(VarCurr,bitIndex3)
        <=> $false )
        & ( v1665(VarCurr,bitIndex2)
        <=> $false )
        & ( v1665(VarCurr,bitIndex1)
        <=> $true )
        & ( v1665(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_485,axiom,
    ~ b00011(bitIndex4) ).

fof(bitBlastConstant_484,axiom,
    ~ b00011(bitIndex3) ).

fof(bitBlastConstant_483,axiom,
    ~ b00011(bitIndex2) ).

fof(bitBlastConstant_482,axiom,
    b00011(bitIndex1) ).

fof(bitBlastConstant_481,axiom,
    b00011(bitIndex0) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_5,axiom,
    ! [VarCurr] :
      ( ~ v1788(VarCurr)
     => ( v1663(VarCurr,bitIndex2)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_46,axiom,
    ! [VarCurr] :
      ( v1788(VarCurr)
     => ( v1663(VarCurr,bitIndex2)
      <=> v1695(VarCurr,bitIndex2) ) ) ).

fof(addBitVectorEqualityBitBlasted_86,axiom,
    ! [VarCurr] :
      ( v1788(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $false )
        & ( v1665(VarCurr,bitIndex3)
        <=> $false )
        & ( v1665(VarCurr,bitIndex2)
        <=> $false )
        & ( v1665(VarCurr,bitIndex1)
        <=> $true )
        & ( v1665(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_480,axiom,
    ~ b00010(bitIndex4) ).

fof(bitBlastConstant_479,axiom,
    ~ b00010(bitIndex3) ).

fof(bitBlastConstant_478,axiom,
    ~ b00010(bitIndex2) ).

fof(bitBlastConstant_477,axiom,
    b00010(bitIndex1) ).

fof(bitBlastConstant_476,axiom,
    ~ b00010(bitIndex0) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_4,axiom,
    ! [VarCurr] :
      ( ~ v1786(VarCurr)
     => ( v1663(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_45,axiom,
    ! [VarCurr] :
      ( v1786(VarCurr)
     => ( v1663(VarCurr,bitIndex1)
      <=> v1693(VarCurr,bitIndex1) ) ) ).

fof(addBitVectorEqualityBitBlasted_85,axiom,
    ! [VarCurr] :
      ( v1786(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $false )
        & ( v1665(VarCurr,bitIndex3)
        <=> $false )
        & ( v1665(VarCurr,bitIndex2)
        <=> $false )
        & ( v1665(VarCurr,bitIndex1)
        <=> $false )
        & ( v1665(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_475,axiom,
    ~ b00001(bitIndex4) ).

fof(bitBlastConstant_474,axiom,
    ~ b00001(bitIndex3) ).

fof(bitBlastConstant_473,axiom,
    ~ b00001(bitIndex2) ).

fof(bitBlastConstant_472,axiom,
    ~ b00001(bitIndex1) ).

fof(bitBlastConstant_471,axiom,
    b00001(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_44,axiom,
    ! [VarCurr] :
      ( ~ v1784(VarCurr)
     => ( v1663(VarCurr,bitIndex0)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_44,axiom,
    ! [VarCurr] :
      ( v1784(VarCurr)
     => ( v1663(VarCurr,bitIndex0)
      <=> v1691(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_84,axiom,
    ! [VarCurr] :
      ( v1784(VarCurr)
    <=> ( ( v1665(VarCurr,bitIndex4)
        <=> $false )
        & ( v1665(VarCurr,bitIndex3)
        <=> $false )
        & ( v1665(VarCurr,bitIndex2)
        <=> $false )
        & ( v1665(VarCurr,bitIndex1)
        <=> $false )
        & ( v1665(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_507,axiom,
    ! [VarCurr] :
      ( v1782(VarCurr,bitIndex31)
    <=> $true ) ).

fof(addAssignment_506,axiom,
    ! [VarCurr] :
      ( v1779(VarCurr,bitIndex30)
    <=> $true ) ).

fof(addAssignment_505,axiom,
    ! [VarCurr] :
      ( v1776(VarCurr,bitIndex29)
    <=> $true ) ).

fof(addAssignment_504,axiom,
    ! [VarCurr] :
      ( v1773(VarCurr,bitIndex28)
    <=> $true ) ).

fof(addAssignment_503,axiom,
    ! [VarCurr] :
      ( v1770(VarCurr,bitIndex27)
    <=> $true ) ).

fof(addAssignment_502,axiom,
    ! [VarCurr] :
      ( v1767(VarCurr,bitIndex26)
    <=> $true ) ).

fof(addAssignment_501,axiom,
    ! [VarCurr] :
      ( v1764(VarCurr,bitIndex25)
    <=> $true ) ).

fof(addAssignment_500,axiom,
    ! [VarCurr] :
      ( v1761(VarCurr,bitIndex24)
    <=> $true ) ).

fof(addAssignment_499,axiom,
    ! [VarCurr] :
      ( v1758(VarCurr,bitIndex23)
    <=> $true ) ).

fof(addAssignment_498,axiom,
    ! [VarCurr] :
      ( v1755(VarCurr,bitIndex22)
    <=> $true ) ).

fof(addAssignment_497,axiom,
    ! [VarCurr] :
      ( v1752(VarCurr,bitIndex21)
    <=> $true ) ).

fof(addAssignment_496,axiom,
    ! [VarCurr] :
      ( v1749(VarCurr,bitIndex20)
    <=> $true ) ).

fof(addAssignment_495,axiom,
    ! [VarCurr] :
      ( v1746(VarCurr,bitIndex19)
    <=> $true ) ).

fof(addAssignment_494,axiom,
    ! [VarCurr] :
      ( v1743(VarCurr,bitIndex18)
    <=> $true ) ).

fof(addAssignment_493,axiom,
    ! [VarCurr] :
      ( v1740(VarCurr,bitIndex17)
    <=> $true ) ).

fof(addAssignment_492,axiom,
    ! [VarCurr] :
      ( v1737(VarCurr,bitIndex16)
    <=> $true ) ).

fof(addAssignment_491,axiom,
    ! [VarCurr] :
      ( v1734(VarCurr,bitIndex15)
    <=> $true ) ).

fof(addAssignment_490,axiom,
    ! [VarCurr] :
      ( v1731(VarCurr,bitIndex14)
    <=> $true ) ).

fof(addAssignment_489,axiom,
    ! [VarCurr] :
      ( v1728(VarCurr,bitIndex13)
    <=> $true ) ).

fof(addAssignment_488,axiom,
    ! [VarCurr] :
      ( v1725(VarCurr,bitIndex12)
    <=> $true ) ).

fof(addAssignment_487,axiom,
    ! [VarCurr] :
      ( v1722(VarCurr,bitIndex11)
    <=> $true ) ).

fof(addAssignment_486,axiom,
    ! [VarCurr] :
      ( v1719(VarCurr,bitIndex10)
    <=> $true ) ).

fof(addAssignment_485,axiom,
    ! [VarCurr] :
      ( v1716(VarCurr,bitIndex9)
    <=> $true ) ).

fof(addAssignment_484,axiom,
    ! [VarCurr] :
      ( v1713(VarCurr,bitIndex8)
    <=> $true ) ).

fof(addAssignment_483,axiom,
    ! [VarCurr] :
      ( v1710(VarCurr,bitIndex7)
    <=> $true ) ).

fof(addAssignment_482,axiom,
    ! [VarCurr] :
      ( v1707(VarCurr,bitIndex6)
    <=> $true ) ).

fof(addAssignment_481,axiom,
    ! [VarCurr] :
      ( v1704(VarCurr,bitIndex5)
    <=> $true ) ).

fof(addAssignment_480,axiom,
    ! [VarCurr] :
      ( v1701(VarCurr,bitIndex4)
    <=> $true ) ).

fof(addAssignment_479,axiom,
    ! [VarCurr] :
      ( v1698(VarCurr,bitIndex3)
    <=> $true ) ).

fof(addAssignment_478,axiom,
    ! [VarCurr] :
      ( v1695(VarCurr,bitIndex2)
    <=> $true ) ).

fof(addAssignment_477,axiom,
    ! [VarCurr] :
      ( v1693(VarCurr,bitIndex1)
    <=> $true ) ).

fof(addAssignment_476,axiom,
    ! [VarCurr] :
      ( v1691(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_475,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v1665(VarCurr,B)
      <=> v1667(VarCurr,B) ) ) ).

fof(addAssignment_474,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v1667(VarCurr,B)
      <=> v1669(VarCurr,B) ) ) ).

fof(addAssignment_473,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v1669(VarCurr,B)
      <=> v1671(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_43,axiom,
    ! [VarCurr] :
      ( ~ v1687(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v1671(VarCurr,B)
          <=> v1675(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_43,axiom,
    ! [VarCurr] :
      ( v1687(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v1671(VarCurr,B)
          <=> v1673(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_188,axiom,
    ! [VarCurr] :
      ( v1687(VarCurr)
    <=> ( v1688(VarCurr)
        | v1689(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_83,axiom,
    ! [VarCurr] :
      ( v1689(VarCurr)
    <=> ( ( v1579(VarCurr,bitIndex3)
        <=> $true )
        & ( v1579(VarCurr,bitIndex2)
        <=> $true )
        & ( v1579(VarCurr,bitIndex1)
        <=> $false )
        & ( v1579(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_82,axiom,
    ! [VarCurr] :
      ( v1688(VarCurr)
    <=> ( ( v1579(VarCurr,bitIndex3)
        <=> $false )
        & ( v1579(VarCurr,bitIndex2)
        <=> $true )
        & ( v1579(VarCurr,bitIndex1)
        <=> $false )
        & ( v1579(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_472,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v1675(VarCurr,B)
      <=> v1677(VarCurr,B) ) ) ).

fof(addAssignment_471,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v1677(VarCurr,B)
      <=> v1679(VarCurr,B) ) ) ).

fof(addAssignment_470,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v1679(VarCurr,B)
      <=> v1681(VarCurr,B) ) ) ).

fof(addAssignment_469,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v1681(VarCurr,B)
      <=> v1683(VarCurr,B) ) ) ).

fof(addAssignment_468,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v1683(VarCurr,B)
      <=> v1685(VarCurr,B) ) ) ).

fof(addAssignment_467,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v1673(VarCurr,B)
      <=> $false ) ) ).

fof(addAssignment_466,axiom,
    ! [VarCurr] :
      ( v1410(VarCurr)
    <=> v1412(VarCurr) ) ).

fof(addAssignment_465,axiom,
    ! [VarCurr] :
      ( v1412(VarCurr)
    <=> v1414(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_42,axiom,
    ! [VarCurr] :
      ( ~ v1642(VarCurr)
     => ( v1414(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_42,axiom,
    ! [VarCurr] :
      ( v1642(VarCurr)
     => ( v1414(VarCurr)
      <=> v1648(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_9,axiom,
    ! [VarCurr] :
      ( ~ v1646(VarCurr)
     => ( v1648(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_9,axiom,
    ! [VarCurr] :
      ( v1646(VarCurr)
     => ( v1648(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_187,axiom,
    ! [VarCurr] :
      ( v1649(VarCurr)
    <=> ( v1651(VarCurr)
        | v1616(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_186,axiom,
    ! [VarCurr] :
      ( v1651(VarCurr)
    <=> ( v1652(VarCurr)
        | v1615(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_185,axiom,
    ! [VarCurr] :
      ( v1652(VarCurr)
    <=> ( v1604(VarCurr)
        | v1605(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_184,axiom,
    ! [VarCurr] :
      ( v1642(VarCurr)
    <=> ( v1643(VarCurr)
        | v1616(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_183,axiom,
    ! [VarCurr] :
      ( v1643(VarCurr)
    <=> ( v1644(VarCurr)
        | v1615(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_182,axiom,
    ! [VarCurr] :
      ( v1644(VarCurr)
    <=> ( v1645(VarCurr)
        | v1605(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_181,axiom,
    ! [VarCurr] :
      ( v1645(VarCurr)
    <=> ( v1646(VarCurr)
        | v1604(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_180,axiom,
    ! [VarCurr] :
      ( v1646(VarCurr)
    <=> ( v1647(VarCurr)
        & v1597(VarCurr) ) ) ).

fof(writeUnaryOperator_99,axiom,
    ! [VarCurr] :
      ( ~ v1647(VarCurr)
    <=> v1416(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_10,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1627(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v1573(VarNext,B)
            <=> v1573(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_11,axiom,
    ! [VarNext] :
      ( v1627(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v1573(VarNext,B)
          <=> v1637(VarNext,B) ) ) ) ).

fof(addAssignment_464,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v1637(VarNext,B)
          <=> v1635(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_41,axiom,
    ! [VarCurr] :
      ( ~ v1638(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1635(VarCurr,B)
          <=> v1577(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_41,axiom,
    ! [VarCurr] :
      ( v1638(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1635(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_98,axiom,
    ! [VarCurr] :
      ( ~ v1638(VarCurr)
    <=> v1575(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_179,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1627(VarNext)
      <=> v1628(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_178,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1628(VarNext)
      <=> ( v1629(VarNext)
          & v1622(VarNext) ) ) ) ).

fof(writeUnaryOperator_97,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1629(VarNext)
      <=> v1631(VarNext) ) ) ).

fof(addAssignment_463,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1631(VarNext)
      <=> v1622(VarCurr) ) ) ).

fof(addAssignment_462,axiom,
    ! [VarCurr] :
      ( v1622(VarCurr)
    <=> v1624(VarCurr) ) ).

fof(addAssignment_461,axiom,
    ! [VarCurr] :
      ( v1624(VarCurr)
    <=> v1(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges5,axiom,
    ! [VarCurr] :
      ( ( ~ v1597(VarCurr)
        & ~ v1599(VarCurr)
        & ~ v1607(VarCurr)
        & ~ v1610(VarCurr)
        & ~ v1618(VarCurr) )
     => ! [B] :
          ( range_3_0(B)
         => ( v1577(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4,axiom,
    ! [VarCurr] :
      ( v1618(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1577(VarCurr,B)
          <=> v1619(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_3,axiom,
    ! [VarCurr] :
      ( v1610(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1577(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_5,axiom,
    ! [VarCurr] :
      ( v1607(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1577(VarCurr,B)
          <=> v1608(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_8,axiom,
    ! [VarCurr] :
      ( v1599(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1577(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_8,axiom,
    ! [VarCurr] :
      ( v1597(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1577(VarCurr,B)
          <=> v1598(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_40,axiom,
    ! [VarCurr] :
      ( ~ v1620(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1619(VarCurr,B)
          <=> $false ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_40,axiom,
    ! [VarCurr] :
      ( v1620(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1619(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_96,axiom,
    ! [VarCurr] :
      ( ~ v1620(VarCurr)
    <=> v1591(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_81,axiom,
    ! [VarCurr] :
      ( v1618(VarCurr)
    <=> ( ( v1573(VarCurr,bitIndex3)
        <=> $true )
        & ( v1573(VarCurr,bitIndex2)
        <=> $true )
        & ( v1573(VarCurr,bitIndex1)
        <=> $false )
        & ( v1573(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_177,axiom,
    ! [VarCurr] :
      ( v1610(VarCurr)
    <=> ( v1612(VarCurr)
        | v1617(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_80,axiom,
    ! [VarCurr] :
      ( v1617(VarCurr)
    <=> ( ( v1573(VarCurr,bitIndex3)
        <=> $true )
        & ( v1573(VarCurr,bitIndex2)
        <=> $true )
        & ( v1573(VarCurr,bitIndex1)
        <=> $false )
        & ( v1573(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_470,axiom,
    b1100(bitIndex3) ).

fof(bitBlastConstant_469,axiom,
    b1100(bitIndex2) ).

fof(bitBlastConstant_468,axiom,
    ~ b1100(bitIndex1) ).

fof(bitBlastConstant_467,axiom,
    ~ b1100(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_176,axiom,
    ! [VarCurr] :
      ( v1612(VarCurr)
    <=> ( v1613(VarCurr)
        | v1616(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_79,axiom,
    ! [VarCurr] :
      ( v1616(VarCurr)
    <=> ( ( v1573(VarCurr,bitIndex3)
        <=> $true )
        & ( v1573(VarCurr,bitIndex2)
        <=> $false )
        & ( v1573(VarCurr,bitIndex1)
        <=> $true )
        & ( v1573(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_466,axiom,
    b1011(bitIndex3) ).

fof(bitBlastConstant_465,axiom,
    ~ b1011(bitIndex2) ).

fof(bitBlastConstant_464,axiom,
    b1011(bitIndex1) ).

fof(bitBlastConstant_463,axiom,
    b1011(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_175,axiom,
    ! [VarCurr] :
      ( v1613(VarCurr)
    <=> ( v1614(VarCurr)
        | v1615(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_78,axiom,
    ! [VarCurr] :
      ( v1615(VarCurr)
    <=> ( ( v1573(VarCurr,bitIndex3)
        <=> $true )
        & ( v1573(VarCurr,bitIndex2)
        <=> $false )
        & ( v1573(VarCurr,bitIndex1)
        <=> $true )
        & ( v1573(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_462,axiom,
    b1010(bitIndex3) ).

fof(bitBlastConstant_461,axiom,
    ~ b1010(bitIndex2) ).

fof(bitBlastConstant_460,axiom,
    b1010(bitIndex1) ).

fof(bitBlastConstant_459,axiom,
    ~ b1010(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_77,axiom,
    ! [VarCurr] :
      ( v1614(VarCurr)
    <=> ( ( v1573(VarCurr,bitIndex3)
        <=> $true )
        & ( v1573(VarCurr,bitIndex2)
        <=> $false )
        & ( v1573(VarCurr,bitIndex1)
        <=> $false )
        & ( v1573(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_458,axiom,
    b1001(bitIndex3) ).

fof(bitBlastConstant_457,axiom,
    ~ b1001(bitIndex2) ).

fof(bitBlastConstant_456,axiom,
    ~ b1001(bitIndex1) ).

fof(bitBlastConstant_455,axiom,
    b1001(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_39,axiom,
    ! [VarCurr] :
      ( ~ v1609(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1608(VarCurr,B)
          <=> $false ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_39,axiom,
    ! [VarCurr] :
      ( v1609(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1608(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_95,axiom,
    ! [VarCurr] :
      ( ~ v1609(VarCurr)
    <=> v1591(VarCurr) ) ).

fof(addAssignmentInitValueVector_25,axiom,
    ( v1591(constB0)
  <=> $false ) ).

fof(addBitVectorEqualityBitBlasted_76,axiom,
    ! [VarCurr] :
      ( v1607(VarCurr)
    <=> ( ( v1573(VarCurr,bitIndex3)
        <=> $false )
        & ( v1573(VarCurr,bitIndex2)
        <=> $true )
        & ( v1573(VarCurr,bitIndex1)
        <=> $false )
        & ( v1573(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_174,axiom,
    ! [VarCurr] :
      ( v1599(VarCurr)
    <=> ( v1601(VarCurr)
        | v1606(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_75,axiom,
    ! [VarCurr] :
      ( v1606(VarCurr)
    <=> ( ( v1573(VarCurr,bitIndex3)
        <=> $false )
        & ( v1573(VarCurr,bitIndex2)
        <=> $true )
        & ( v1573(VarCurr,bitIndex1)
        <=> $false )
        & ( v1573(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_454,axiom,
    ~ b0100(bitIndex3) ).

fof(bitBlastConstant_453,axiom,
    b0100(bitIndex2) ).

fof(bitBlastConstant_452,axiom,
    ~ b0100(bitIndex1) ).

fof(bitBlastConstant_451,axiom,
    ~ b0100(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_173,axiom,
    ! [VarCurr] :
      ( v1601(VarCurr)
    <=> ( v1602(VarCurr)
        | v1605(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_74,axiom,
    ! [VarCurr] :
      ( v1605(VarCurr)
    <=> ( ( v1573(VarCurr,bitIndex3)
        <=> $false )
        & ( v1573(VarCurr,bitIndex2)
        <=> $false )
        & ( v1573(VarCurr,bitIndex1)
        <=> $true )
        & ( v1573(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_450,axiom,
    ~ b0011(bitIndex3) ).

fof(bitBlastConstant_449,axiom,
    ~ b0011(bitIndex2) ).

fof(bitBlastConstant_448,axiom,
    b0011(bitIndex1) ).

fof(bitBlastConstant_447,axiom,
    b0011(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_172,axiom,
    ! [VarCurr] :
      ( v1602(VarCurr)
    <=> ( v1603(VarCurr)
        | v1604(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_73,axiom,
    ! [VarCurr] :
      ( v1604(VarCurr)
    <=> ( ( v1573(VarCurr,bitIndex3)
        <=> $false )
        & ( v1573(VarCurr,bitIndex2)
        <=> $false )
        & ( v1573(VarCurr,bitIndex1)
        <=> $true )
        & ( v1573(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_446,axiom,
    ~ b0010(bitIndex3) ).

fof(bitBlastConstant_445,axiom,
    ~ b0010(bitIndex2) ).

fof(bitBlastConstant_444,axiom,
    b0010(bitIndex1) ).

fof(bitBlastConstant_443,axiom,
    ~ b0010(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_72,axiom,
    ! [VarCurr] :
      ( v1603(VarCurr)
    <=> ( ( v1573(VarCurr,bitIndex3)
        <=> $false )
        & ( v1573(VarCurr,bitIndex2)
        <=> $false )
        & ( v1573(VarCurr,bitIndex1)
        <=> $false )
        & ( v1573(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_442,axiom,
    ~ b0001(bitIndex3) ).

fof(bitBlastConstant_441,axiom,
    ~ b0001(bitIndex2) ).

fof(bitBlastConstant_440,axiom,
    ~ b0001(bitIndex1) ).

fof(bitBlastConstant_439,axiom,
    b0001(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_38,axiom,
    ! [VarCurr] :
      ( ~ v1416(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1598(VarCurr,B)
          <=> $false ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_38,axiom,
    ! [VarCurr] :
      ( v1416(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1598(VarCurr,B)
          <=> v1579(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_71,axiom,
    ! [VarCurr] :
      ( v1597(VarCurr)
    <=> ( ( v1573(VarCurr,bitIndex3)
        <=> $false )
        & ( v1573(VarCurr,bitIndex2)
        <=> $false )
        & ( v1573(VarCurr,bitIndex1)
        <=> $false )
        & ( v1573(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignmentInitValueVector_24,axiom,
    ! [B] :
      ( range_3_0(B)
     => ( v1573(constB0,B)
      <=> $false ) ) ).

fof(addAssignment_460,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v1579(VarCurr,B)
      <=> v1581(VarCurr,B) ) ) ).

fof(addAssignment_459,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v1581(VarCurr,B)
      <=> v1583(VarCurr,B) ) ) ).

fof(addAssignment_458,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v1583(VarCurr,B)
      <=> v1585(VarCurr,B) ) ) ).

fof(addAssignment_457,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v1585(VarCurr,B)
      <=> v1587(VarCurr,B) ) ) ).

fof(addAssignment_456,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v1587(VarCurr,B)
      <=> v1589(VarCurr,B) ) ) ).

fof(addAssignment_455,axiom,
    ! [VarCurr] :
      ( v1575(VarCurr)
    <=> v1286(VarCurr) ) ).

fof(addAssignment_454,axiom,
    ! [VarCurr] :
      ( v1416(VarCurr)
    <=> v1418(VarCurr) ) ).

fof(addAssignment_453,axiom,
    ! [VarCurr] :
      ( v1418(VarCurr)
    <=> v1420(VarCurr) ) ).

fof(addAssignment_452,axiom,
    ! [VarCurr] :
      ( v1420(VarCurr)
    <=> v1422(VarCurr) ) ).

fof(addAssignment_451,axiom,
    ! [VarCurr] :
      ( v1422(VarCurr)
    <=> v1424(VarCurr) ) ).

fof(addAssignment_450,axiom,
    ! [VarCurr] :
      ( v1424(VarCurr)
    <=> v1426(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_9,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1558(VarNext)
       => ( v1426(VarNext)
        <=> v1426(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_10,axiom,
    ! [VarNext] :
      ( v1558(VarNext)
     => ( v1426(VarNext)
      <=> v1568(VarNext) ) ) ).

fof(addAssignment_449,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1568(VarNext)
      <=> v1566(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_37,axiom,
    ! [VarCurr] :
      ( ~ v1569(VarCurr)
     => ( v1566(VarCurr)
      <=> v1432(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_37,axiom,
    ! [VarCurr] :
      ( v1569(VarCurr)
     => ( v1566(VarCurr)
      <=> $false ) ) ).

fof(writeUnaryOperator_94,axiom,
    ! [VarCurr] :
      ( ~ v1569(VarCurr)
    <=> v1428(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_171,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1558(VarNext)
      <=> v1559(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_170,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1559(VarNext)
      <=> ( v1560(VarNext)
          & v1553(VarNext) ) ) ) ).

fof(writeUnaryOperator_93,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1560(VarNext)
      <=> v1562(VarNext) ) ) ).

fof(addAssignment_448,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1562(VarNext)
      <=> v1553(VarCurr) ) ) ).

fof(addAssignment_447,axiom,
    ! [VarCurr] :
      ( v1553(VarCurr)
    <=> v1555(VarCurr) ) ).

fof(addAssignment_446,axiom,
    ! [VarCurr] :
      ( v1555(VarCurr)
    <=> v805(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_36,axiom,
    ! [VarCurr] :
      ( ~ v1533(VarCurr)
     => ( v1432(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_36,axiom,
    ! [VarCurr] :
      ( v1533(VarCurr)
     => ( v1432(VarCurr)
      <=> v1540(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_4,axiom,
    ! [VarCurr] :
      ( ( ~ v1536(VarCurr)
        & ~ v1537(VarCurr) )
     => ( v1540(VarCurr)
      <=> v1551(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_7,axiom,
    ! [VarCurr] :
      ( v1537(VarCurr)
     => ( v1540(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_7,axiom,
    ! [VarCurr] :
      ( v1536(VarCurr)
     => ( v1540(VarCurr)
      <=> v1541(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_35,axiom,
    ! [VarCurr] :
      ( ~ v1521(VarCurr)
     => ( v1551(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_35,axiom,
    ! [VarCurr] :
      ( v1521(VarCurr)
     => ( v1551(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_169,axiom,
    ! [VarCurr] :
      ( v1550(VarCurr)
    <=> ( v1538(VarCurr)
        | v1539(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_6,axiom,
    ! [VarCurr] :
      ( ~ v1542(VarCurr)
     => ( v1541(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_6,axiom,
    ! [VarCurr] :
      ( v1542(VarCurr)
     => ( v1541(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_168,axiom,
    ! [VarCurr] :
      ( v1544(VarCurr)
    <=> ( v1545(VarCurr)
        | v1548(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_167,axiom,
    ! [VarCurr] :
      ( v1548(VarCurr)
    <=> ( v1436(VarCurr)
        & v1512(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_166,axiom,
    ! [VarCurr] :
      ( v1545(VarCurr)
    <=> ( v1436(VarCurr)
        & v1547(VarCurr) ) ) ).

fof(writeUnaryOperator_92,axiom,
    ! [VarCurr] :
      ( ~ v1547(VarCurr)
    <=> v1512(VarCurr) ) ).

fof(writeUnaryOperator_91,axiom,
    ! [VarCurr] :
      ( ~ v1542(VarCurr)
    <=> v1436(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_165,axiom,
    ! [VarCurr] :
      ( v1533(VarCurr)
    <=> ( v1534(VarCurr)
        | v1539(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_70,axiom,
    ! [VarCurr] :
      ( v1539(VarCurr)
    <=> ( $true
      <=> v1434(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_164,axiom,
    ! [VarCurr] :
      ( v1534(VarCurr)
    <=> ( v1535(VarCurr)
        | v1538(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_69,axiom,
    ! [VarCurr] :
      ( v1538(VarCurr)
    <=> ( $true
      <=> v1434(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_163,axiom,
    ! [VarCurr] :
      ( v1535(VarCurr)
    <=> ( v1536(VarCurr)
        | v1537(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_68,axiom,
    ! [VarCurr] :
      ( v1537(VarCurr)
    <=> ( $true
      <=> v1434(VarCurr,bitIndex2) ) ) ).

fof(addBitVectorEqualityBitBlasted_67,axiom,
    ! [VarCurr] :
      ( v1536(VarCurr)
    <=> ( $true
      <=> v1434(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_445,axiom,
    ! [VarCurr] :
      ( v1521(VarCurr)
    <=> v1523(VarCurr) ) ).

fof(addAssignment_444,axiom,
    ! [VarCurr] :
      ( v1523(VarCurr)
    <=> v1525(VarCurr) ) ).

fof(addAssignment_443,axiom,
    ! [VarCurr] :
      ( v1525(VarCurr)
    <=> v1527(VarCurr) ) ).

fof(addAssignment_442,axiom,
    ! [VarCurr] :
      ( v1527(VarCurr)
    <=> v1529(VarCurr) ) ).

fof(addAssignment_441,axiom,
    ! [VarCurr] :
      ( v1529(VarCurr)
    <=> v1531(VarCurr) ) ).

fof(addAssignment_440,axiom,
    ! [VarCurr] :
      ( v1512(VarCurr)
    <=> v1514(VarCurr) ) ).

fof(addAssignment_439,axiom,
    ! [VarCurr] :
      ( v1514(VarCurr)
    <=> v1516(VarCurr) ) ).

fof(addAssignment_438,axiom,
    ! [VarCurr] :
      ( v1516(VarCurr)
    <=> v1518(VarCurr,bitIndex0) ) ).

fof(addAssignment_437,axiom,
    ! [VarCurr] :
      ( v1518(VarCurr,bitIndex0)
    <=> v1450(VarCurr,bitIndex49) ) ).

fof(addAssignment_436,axiom,
    ! [VarCurr] :
      ( v1450(VarCurr,bitIndex49)
    <=> v1452(VarCurr,bitIndex49) ) ).

fof(addAssignment_435,axiom,
    ! [VarCurr] :
      ( v1452(VarCurr,bitIndex49)
    <=> v1454(VarCurr,bitIndex539) ) ).

fof(addAssignment_434,axiom,
    ! [VarCurr] :
      ( v1436(VarCurr)
    <=> v1438(VarCurr) ) ).

fof(addAssignment_433,axiom,
    ! [VarCurr] :
      ( v1438(VarCurr)
    <=> v1440(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_34,axiom,
    ! [VarCurr] :
      ( ~ v1505(VarCurr)
     => ( v1440(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_34,axiom,
    ! [VarCurr] :
      ( v1505(VarCurr)
     => ( v1440(VarCurr)
      <=> v1510(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_33,axiom,
    ! [VarCurr] :
      ( ~ v1499(VarCurr)
     => ( v1510(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_33,axiom,
    ! [VarCurr] :
      ( v1499(VarCurr)
     => ( v1510(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_162,axiom,
    ! [VarCurr] :
      ( v1505(VarCurr)
    <=> ( v1506(VarCurr)
        & v1509(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_66,axiom,
    ! [VarCurr] :
      ( v1509(VarCurr)
    <=> ( $true
      <=> v1497(VarCurr,bitIndex0) ) ) ).

fof(addAssignmentInitValueVector_23,axiom,
    ( v1497(constB0,bitIndex0)
  <=> $true ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_161,axiom,
    ! [VarCurr] :
      ( v1506(VarCurr)
    <=> ( v1507(VarCurr)
        & v1508(VarCurr) ) ) ).

fof(writeUnaryOperator_90,axiom,
    ! [VarCurr] :
      ( ~ v1508(VarCurr)
    <=> v1444(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_65,axiom,
    ! [VarCurr] :
      ( v1507(VarCurr)
    <=> ( ( v1442(VarCurr,bitIndex1)
        <=> $true )
        & ( v1442(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_432,axiom,
    ! [VarCurr] :
      ( v1499(VarCurr)
    <=> v1501(VarCurr) ) ).

fof(addAssignment_431,axiom,
    ! [VarCurr] :
      ( v1501(VarCurr)
    <=> v1503(VarCurr) ) ).

fof(addAssignment_430,axiom,
    ! [VarCurr] :
      ( v1503(VarCurr)
    <=> v1434(VarCurr,bitIndex0) ) ).

fof(addAssignmentInitValueVector_22,axiom,
    ( ( v1434(constB0,bitIndex3)
    <=> $false )
    & ( v1434(constB0,bitIndex2)
    <=> $false )
    & ( v1434(constB0,bitIndex1)
    <=> $false ) ) ).

fof(addAssignmentInitValueVector_21,axiom,
    ( v1434(constB0,bitIndex0)
  <=> $true ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_32,axiom,
    ! [VarCurr] :
      ( ~ v1444(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v1442(VarCurr,B)
          <=> v1468(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_32,axiom,
    ! [VarCurr] :
      ( v1444(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v1442(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_2,axiom,
    ! [VarCurr] :
      ( ( ~ v1469(VarCurr)
        & ~ v1489(VarCurr)
        & ~ v1490(VarCurr) )
     => ! [B] :
          ( range_1_0(B)
         => ( v1468(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_3,axiom,
    ! [VarCurr] :
      ( v1490(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v1468(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5,axiom,
    ! [VarCurr] :
      ( v1489(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v1468(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5,axiom,
    ! [VarCurr] :
      ( v1469(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v1468(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_160,axiom,
    ! [VarCurr] :
      ( v1490(VarCurr)
    <=> ( v1492(VarCurr)
        | v1495(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_64,axiom,
    ! [VarCurr] :
      ( v1495(VarCurr)
    <=> ( ( v1448(VarCurr,bitIndex6)
        <=> $true )
        & ( v1448(VarCurr,bitIndex5)
        <=> $false )
        & ( v1448(VarCurr,bitIndex4)
        <=> $false )
        & ( v1448(VarCurr,bitIndex3)
        <=> $true )
        & ( v1448(VarCurr,bitIndex2)
        <=> $false )
        & ( v1448(VarCurr,bitIndex1)
        <=> $true )
        & ( v1448(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_438,axiom,
    b1001010(bitIndex6) ).

fof(bitBlastConstant_437,axiom,
    ~ b1001010(bitIndex5) ).

fof(bitBlastConstant_436,axiom,
    ~ b1001010(bitIndex4) ).

fof(bitBlastConstant_435,axiom,
    b1001010(bitIndex3) ).

fof(bitBlastConstant_434,axiom,
    ~ b1001010(bitIndex2) ).

fof(bitBlastConstant_433,axiom,
    b1001010(bitIndex1) ).

fof(bitBlastConstant_432,axiom,
    ~ b1001010(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_159,axiom,
    ! [VarCurr] :
      ( v1492(VarCurr)
    <=> ( v1493(VarCurr)
        | v1494(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_63,axiom,
    ! [VarCurr] :
      ( v1494(VarCurr)
    <=> ( ( v1448(VarCurr,bitIndex6)
        <=> $false )
        & ( v1448(VarCurr,bitIndex5)
        <=> $false )
        & ( v1448(VarCurr,bitIndex4)
        <=> $false )
        & ( v1448(VarCurr,bitIndex3)
        <=> $true )
        & ( v1448(VarCurr,bitIndex2)
        <=> $false )
        & ( v1448(VarCurr,bitIndex1)
        <=> $true )
        & ( v1448(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_431,axiom,
    ~ b0001011(bitIndex6) ).

fof(bitBlastConstant_430,axiom,
    ~ b0001011(bitIndex5) ).

fof(bitBlastConstant_429,axiom,
    ~ b0001011(bitIndex4) ).

fof(bitBlastConstant_428,axiom,
    b0001011(bitIndex3) ).

fof(bitBlastConstant_427,axiom,
    ~ b0001011(bitIndex2) ).

fof(bitBlastConstant_426,axiom,
    b0001011(bitIndex1) ).

fof(bitBlastConstant_425,axiom,
    b0001011(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_62,axiom,
    ! [VarCurr] :
      ( v1493(VarCurr)
    <=> ( ( v1448(VarCurr,bitIndex6)
        <=> $false )
        & ( v1448(VarCurr,bitIndex5)
        <=> $false )
        & ( v1448(VarCurr,bitIndex4)
        <=> $false )
        & ( v1448(VarCurr,bitIndex3)
        <=> $true )
        & ( v1448(VarCurr,bitIndex2)
        <=> $false )
        & ( v1448(VarCurr,bitIndex1)
        <=> $true )
        & ( v1448(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_424,axiom,
    ~ b0001010(bitIndex6) ).

fof(bitBlastConstant_423,axiom,
    ~ b0001010(bitIndex5) ).

fof(bitBlastConstant_422,axiom,
    ~ b0001010(bitIndex4) ).

fof(bitBlastConstant_421,axiom,
    b0001010(bitIndex3) ).

fof(bitBlastConstant_420,axiom,
    ~ b0001010(bitIndex2) ).

fof(bitBlastConstant_419,axiom,
    b0001010(bitIndex1) ).

fof(bitBlastConstant_418,axiom,
    ~ b0001010(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_61,axiom,
    ! [VarCurr] :
      ( v1489(VarCurr)
    <=> ( ( v1448(VarCurr,bitIndex6)
        <=> $true )
        & ( v1448(VarCurr,bitIndex5)
        <=> $true )
        & ( v1448(VarCurr,bitIndex4)
        <=> $true )
        & ( v1448(VarCurr,bitIndex3)
        <=> $true )
        & ( v1448(VarCurr,bitIndex2)
        <=> $false )
        & ( v1448(VarCurr,bitIndex1)
        <=> $true )
        & ( v1448(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_417,axiom,
    b1111010(bitIndex6) ).

fof(bitBlastConstant_416,axiom,
    b1111010(bitIndex5) ).

fof(bitBlastConstant_415,axiom,
    b1111010(bitIndex4) ).

fof(bitBlastConstant_414,axiom,
    b1111010(bitIndex3) ).

fof(bitBlastConstant_413,axiom,
    ~ b1111010(bitIndex2) ).

fof(bitBlastConstant_412,axiom,
    b1111010(bitIndex1) ).

fof(bitBlastConstant_411,axiom,
    ~ b1111010(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_158,axiom,
    ! [VarCurr] :
      ( v1469(VarCurr)
    <=> ( v1471(VarCurr)
        | v1488(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_60,axiom,
    ! [VarCurr] :
      ( v1488(VarCurr)
    <=> ( ( v1448(VarCurr,bitIndex6)
        <=> $true )
        & ( v1448(VarCurr,bitIndex5)
        <=> $false )
        & ( v1448(VarCurr,bitIndex4)
        <=> $false )
        & ( v1448(VarCurr,bitIndex3)
        <=> $false )
        & ( v1448(VarCurr,bitIndex2)
        <=> $true )
        & ( v1448(VarCurr,bitIndex1)
        <=> $false )
        & ( v1448(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_410,axiom,
    b1000101(bitIndex6) ).

fof(bitBlastConstant_409,axiom,
    ~ b1000101(bitIndex5) ).

fof(bitBlastConstant_408,axiom,
    ~ b1000101(bitIndex4) ).

fof(bitBlastConstant_407,axiom,
    ~ b1000101(bitIndex3) ).

fof(bitBlastConstant_406,axiom,
    b1000101(bitIndex2) ).

fof(bitBlastConstant_405,axiom,
    ~ b1000101(bitIndex1) ).

fof(bitBlastConstant_404,axiom,
    b1000101(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_157,axiom,
    ! [VarCurr] :
      ( v1471(VarCurr)
    <=> ( v1472(VarCurr)
        | v1487(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_59,axiom,
    ! [VarCurr] :
      ( v1487(VarCurr)
    <=> ( ( v1448(VarCurr,bitIndex6)
        <=> $true )
        & ( v1448(VarCurr,bitIndex5)
        <=> $false )
        & ( v1448(VarCurr,bitIndex4)
        <=> $false )
        & ( v1448(VarCurr,bitIndex3)
        <=> $false )
        & ( v1448(VarCurr,bitIndex2)
        <=> $true )
        & ( v1448(VarCurr,bitIndex1)
        <=> $false )
        & ( v1448(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_403,axiom,
    b1000100(bitIndex6) ).

fof(bitBlastConstant_402,axiom,
    ~ b1000100(bitIndex5) ).

fof(bitBlastConstant_401,axiom,
    ~ b1000100(bitIndex4) ).

fof(bitBlastConstant_400,axiom,
    ~ b1000100(bitIndex3) ).

fof(bitBlastConstant_399,axiom,
    b1000100(bitIndex2) ).

fof(bitBlastConstant_398,axiom,
    ~ b1000100(bitIndex1) ).

fof(bitBlastConstant_397,axiom,
    ~ b1000100(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_156,axiom,
    ! [VarCurr] :
      ( v1472(VarCurr)
    <=> ( v1473(VarCurr)
        | v1486(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_58,axiom,
    ! [VarCurr] :
      ( v1486(VarCurr)
    <=> ( ( v1448(VarCurr,bitIndex6)
        <=> $true )
        & ( v1448(VarCurr,bitIndex5)
        <=> $true )
        & ( v1448(VarCurr,bitIndex4)
        <=> $false )
        & ( v1448(VarCurr,bitIndex3)
        <=> $false )
        & ( v1448(VarCurr,bitIndex2)
        <=> $false )
        & ( v1448(VarCurr,bitIndex1)
        <=> $false )
        & ( v1448(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_396,axiom,
    b1100000(bitIndex6) ).

fof(bitBlastConstant_395,axiom,
    b1100000(bitIndex5) ).

fof(bitBlastConstant_394,axiom,
    ~ b1100000(bitIndex4) ).

fof(bitBlastConstant_393,axiom,
    ~ b1100000(bitIndex3) ).

fof(bitBlastConstant_392,axiom,
    ~ b1100000(bitIndex2) ).

fof(bitBlastConstant_391,axiom,
    ~ b1100000(bitIndex1) ).

fof(bitBlastConstant_390,axiom,
    ~ b1100000(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_155,axiom,
    ! [VarCurr] :
      ( v1473(VarCurr)
    <=> ( v1474(VarCurr)
        | v1485(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_57,axiom,
    ! [VarCurr] :
      ( v1485(VarCurr)
    <=> ( ( v1448(VarCurr,bitIndex6)
        <=> $true )
        & ( v1448(VarCurr,bitIndex5)
        <=> $false )
        & ( v1448(VarCurr,bitIndex4)
        <=> $false )
        & ( v1448(VarCurr,bitIndex3)
        <=> $false )
        & ( v1448(VarCurr,bitIndex2)
        <=> $false )
        & ( v1448(VarCurr,bitIndex1)
        <=> $false )
        & ( v1448(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_389,axiom,
    b1000000(bitIndex6) ).

fof(bitBlastConstant_388,axiom,
    ~ b1000000(bitIndex5) ).

fof(bitBlastConstant_387,axiom,
    ~ b1000000(bitIndex4) ).

fof(bitBlastConstant_386,axiom,
    ~ b1000000(bitIndex3) ).

fof(bitBlastConstant_385,axiom,
    ~ b1000000(bitIndex2) ).

fof(bitBlastConstant_384,axiom,
    ~ b1000000(bitIndex1) ).

fof(bitBlastConstant_383,axiom,
    ~ b1000000(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_154,axiom,
    ! [VarCurr] :
      ( v1474(VarCurr)
    <=> ( v1475(VarCurr)
        | v1484(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_56,axiom,
    ! [VarCurr] :
      ( v1484(VarCurr)
    <=> ( ( v1448(VarCurr,bitIndex6)
        <=> $true )
        & ( v1448(VarCurr,bitIndex5)
        <=> $false )
        & ( v1448(VarCurr,bitIndex4)
        <=> $false )
        & ( v1448(VarCurr,bitIndex3)
        <=> $false )
        & ( v1448(VarCurr,bitIndex2)
        <=> $false )
        & ( v1448(VarCurr,bitIndex1)
        <=> $true )
        & ( v1448(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_382,axiom,
    b1000010(bitIndex6) ).

fof(bitBlastConstant_381,axiom,
    ~ b1000010(bitIndex5) ).

fof(bitBlastConstant_380,axiom,
    ~ b1000010(bitIndex4) ).

fof(bitBlastConstant_379,axiom,
    ~ b1000010(bitIndex3) ).

fof(bitBlastConstant_378,axiom,
    ~ b1000010(bitIndex2) ).

fof(bitBlastConstant_377,axiom,
    b1000010(bitIndex1) ).

fof(bitBlastConstant_376,axiom,
    ~ b1000010(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_153,axiom,
    ! [VarCurr] :
      ( v1475(VarCurr)
    <=> ( v1476(VarCurr)
        | v1483(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_55,axiom,
    ! [VarCurr] :
      ( v1483(VarCurr)
    <=> ( ( v1448(VarCurr,bitIndex6)
        <=> $false )
        & ( v1448(VarCurr,bitIndex5)
        <=> $false )
        & ( v1448(VarCurr,bitIndex4)
        <=> $false )
        & ( v1448(VarCurr,bitIndex3)
        <=> $false )
        & ( v1448(VarCurr,bitIndex2)
        <=> $true )
        & ( v1448(VarCurr,bitIndex1)
        <=> $false )
        & ( v1448(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_375,axiom,
    ~ b0000101(bitIndex6) ).

fof(bitBlastConstant_374,axiom,
    ~ b0000101(bitIndex5) ).

fof(bitBlastConstant_373,axiom,
    ~ b0000101(bitIndex4) ).

fof(bitBlastConstant_372,axiom,
    ~ b0000101(bitIndex3) ).

fof(bitBlastConstant_371,axiom,
    b0000101(bitIndex2) ).

fof(bitBlastConstant_370,axiom,
    ~ b0000101(bitIndex1) ).

fof(bitBlastConstant_369,axiom,
    b0000101(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_152,axiom,
    ! [VarCurr] :
      ( v1476(VarCurr)
    <=> ( v1477(VarCurr)
        | v1482(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_54,axiom,
    ! [VarCurr] :
      ( v1482(VarCurr)
    <=> ( ( v1448(VarCurr,bitIndex6)
        <=> $false )
        & ( v1448(VarCurr,bitIndex5)
        <=> $false )
        & ( v1448(VarCurr,bitIndex4)
        <=> $false )
        & ( v1448(VarCurr,bitIndex3)
        <=> $false )
        & ( v1448(VarCurr,bitIndex2)
        <=> $true )
        & ( v1448(VarCurr,bitIndex1)
        <=> $false )
        & ( v1448(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_368,axiom,
    ~ b0000100(bitIndex6) ).

fof(bitBlastConstant_367,axiom,
    ~ b0000100(bitIndex5) ).

fof(bitBlastConstant_366,axiom,
    ~ b0000100(bitIndex4) ).

fof(bitBlastConstant_365,axiom,
    ~ b0000100(bitIndex3) ).

fof(bitBlastConstant_364,axiom,
    b0000100(bitIndex2) ).

fof(bitBlastConstant_363,axiom,
    ~ b0000100(bitIndex1) ).

fof(bitBlastConstant_362,axiom,
    ~ b0000100(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_151,axiom,
    ! [VarCurr] :
      ( v1477(VarCurr)
    <=> ( v1478(VarCurr)
        | v1481(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_53,axiom,
    ! [VarCurr] :
      ( v1481(VarCurr)
    <=> ( ( v1448(VarCurr,bitIndex6)
        <=> $false )
        & ( v1448(VarCurr,bitIndex5)
        <=> $false )
        & ( v1448(VarCurr,bitIndex4)
        <=> $false )
        & ( v1448(VarCurr,bitIndex3)
        <=> $false )
        & ( v1448(VarCurr,bitIndex2)
        <=> $false )
        & ( v1448(VarCurr,bitIndex1)
        <=> $true )
        & ( v1448(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_361,axiom,
    ~ b0000010(bitIndex6) ).

fof(bitBlastConstant_360,axiom,
    ~ b0000010(bitIndex5) ).

fof(bitBlastConstant_359,axiom,
    ~ b0000010(bitIndex4) ).

fof(bitBlastConstant_358,axiom,
    ~ b0000010(bitIndex3) ).

fof(bitBlastConstant_357,axiom,
    ~ b0000010(bitIndex2) ).

fof(bitBlastConstant_356,axiom,
    b0000010(bitIndex1) ).

fof(bitBlastConstant_355,axiom,
    ~ b0000010(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_150,axiom,
    ! [VarCurr] :
      ( v1478(VarCurr)
    <=> ( v1479(VarCurr)
        | v1480(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_52,axiom,
    ! [VarCurr] :
      ( v1480(VarCurr)
    <=> ( ( v1448(VarCurr,bitIndex6)
        <=> $false )
        & ( v1448(VarCurr,bitIndex5)
        <=> $true )
        & ( v1448(VarCurr,bitIndex4)
        <=> $false )
        & ( v1448(VarCurr,bitIndex3)
        <=> $false )
        & ( v1448(VarCurr,bitIndex2)
        <=> $false )
        & ( v1448(VarCurr,bitIndex1)
        <=> $false )
        & ( v1448(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_354,axiom,
    ~ b0100000(bitIndex6) ).

fof(bitBlastConstant_353,axiom,
    b0100000(bitIndex5) ).

fof(bitBlastConstant_352,axiom,
    ~ b0100000(bitIndex4) ).

fof(bitBlastConstant_351,axiom,
    ~ b0100000(bitIndex3) ).

fof(bitBlastConstant_350,axiom,
    ~ b0100000(bitIndex2) ).

fof(bitBlastConstant_349,axiom,
    ~ b0100000(bitIndex1) ).

fof(bitBlastConstant_348,axiom,
    ~ b0100000(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_51,axiom,
    ! [VarCurr] :
      ( v1479(VarCurr)
    <=> ( ( v1448(VarCurr,bitIndex6)
        <=> $false )
        & ( v1448(VarCurr,bitIndex5)
        <=> $false )
        & ( v1448(VarCurr,bitIndex4)
        <=> $false )
        & ( v1448(VarCurr,bitIndex3)
        <=> $false )
        & ( v1448(VarCurr,bitIndex2)
        <=> $false )
        & ( v1448(VarCurr,bitIndex1)
        <=> $false )
        & ( v1448(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_347,axiom,
    ~ b0000000(bitIndex6) ).

fof(bitBlastConstant_346,axiom,
    ~ b0000000(bitIndex5) ).

fof(bitBlastConstant_345,axiom,
    ~ b0000000(bitIndex4) ).

fof(bitBlastConstant_344,axiom,
    ~ b0000000(bitIndex3) ).

fof(bitBlastConstant_343,axiom,
    ~ b0000000(bitIndex2) ).

fof(bitBlastConstant_342,axiom,
    ~ b0000000(bitIndex1) ).

fof(bitBlastConstant_341,axiom,
    ~ b0000000(bitIndex0) ).

fof(addAssignment_429,axiom,
    ! [VarCurr] :
      ( ( v1448(VarCurr,bitIndex6)
      <=> v1450(VarCurr,bitIndex69) )
      & ( v1448(VarCurr,bitIndex5)
      <=> v1450(VarCurr,bitIndex68) )
      & ( v1448(VarCurr,bitIndex4)
      <=> v1450(VarCurr,bitIndex67) )
      & ( v1448(VarCurr,bitIndex3)
      <=> v1450(VarCurr,bitIndex66) )
      & ( v1448(VarCurr,bitIndex2)
      <=> v1450(VarCurr,bitIndex65) )
      & ( v1448(VarCurr,bitIndex1)
      <=> v1450(VarCurr,bitIndex64) )
      & ( v1448(VarCurr,bitIndex0)
      <=> v1450(VarCurr,bitIndex63) ) ) ).

fof(addAssignment_428,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v1450(VarCurr,B)
      <=> v1452(VarCurr,B) ) ) ).

fof(range_axiom_22,axiom,
    ! [B] :
      ( range_69_63(B)
    <=> ( $false
        | bitIndex63 = B
        | bitIndex64 = B
        | bitIndex65 = B
        | bitIndex66 = B
        | bitIndex67 = B
        | bitIndex68 = B
        | bitIndex69 = B ) ) ).

fof(addAssignment_427,axiom,
    ! [VarCurr] :
      ( ( v1452(VarCurr,bitIndex69)
      <=> v1454(VarCurr,bitIndex559) )
      & ( v1452(VarCurr,bitIndex68)
      <=> v1454(VarCurr,bitIndex558) )
      & ( v1452(VarCurr,bitIndex67)
      <=> v1454(VarCurr,bitIndex557) )
      & ( v1452(VarCurr,bitIndex66)
      <=> v1454(VarCurr,bitIndex556) )
      & ( v1452(VarCurr,bitIndex65)
      <=> v1454(VarCurr,bitIndex555) )
      & ( v1452(VarCurr,bitIndex64)
      <=> v1454(VarCurr,bitIndex554) )
      & ( v1452(VarCurr,bitIndex63)
      <=> v1454(VarCurr,bitIndex553) ) ) ).

fof(addAssignmentInitValue_80,axiom,
    ~ v1454(constB0,bitIndex559) ).

fof(addAssignmentInitValue_79,axiom,
    ~ v1454(constB0,bitIndex558) ).

fof(addAssignmentInitValue_78,axiom,
    ~ v1454(constB0,bitIndex557) ).

fof(addAssignmentInitValue_77,axiom,
    ~ v1454(constB0,bitIndex556) ).

fof(addAssignmentInitValue_76,axiom,
    ~ v1454(constB0,bitIndex555) ).

fof(addAssignmentInitValue_75,axiom,
    ~ v1454(constB0,bitIndex554) ).

fof(addAssignmentInitValue_74,axiom,
    ~ v1454(constB0,bitIndex553) ).

fof(addAssignmentInitValue_73,axiom,
    ~ v1454(constB0,bitIndex539) ).

fof(bitBlastConstant_340,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex69) ).

fof(bitBlastConstant_339,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex68) ).

fof(bitBlastConstant_338,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex67) ).

fof(bitBlastConstant_337,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex66) ).

fof(bitBlastConstant_336,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex65) ).

fof(bitBlastConstant_335,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex64) ).

fof(bitBlastConstant_334,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex63) ).

fof(bitBlastConstant_333,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex49) ).

fof(addAssignment_426,axiom,
    ! [VarCurr] :
      ( v1444(VarCurr)
    <=> v1446(VarCurr) ) ).

fof(addAssignment_425,axiom,
    ! [VarCurr] :
      ( v1428(VarCurr)
    <=> v1430(VarCurr) ) ).

fof(addAssignment_424,axiom,
    ! [VarCurr] :
      ( v1430(VarCurr)
    <=> v12(VarCurr) ) ).

fof(addAssignment_423,axiom,
    ! [VarCurr] :
      ( v1389(VarCurr)
    <=> v1391(VarCurr) ) ).

fof(addAssignment_422,axiom,
    ! [VarCurr] :
      ( v1391(VarCurr)
    <=> v1393(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_31,axiom,
    ! [VarCurr] :
      ( ~ v1396(VarCurr)
     => ( v1393(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_31,axiom,
    ! [VarCurr] :
      ( v1396(VarCurr)
     => ( v1393(VarCurr)
      <=> v1407(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_4,axiom,
    ! [VarCurr] :
      ( ~ v1398(VarCurr)
     => ( v1407(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_4,axiom,
    ! [VarCurr] :
      ( v1398(VarCurr)
     => ( v1407(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_149,axiom,
    ! [VarCurr] :
      ( v1408(VarCurr)
    <=> ( v1401(VarCurr)
        | v1404(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_148,axiom,
    ! [VarCurr] :
      ( v1396(VarCurr)
    <=> ( v1397(VarCurr)
        | v1404(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_147,axiom,
    ! [VarCurr] :
      ( v1404(VarCurr)
    <=> ( v1405(VarCurr)
        & v1406(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_50,axiom,
    ! [VarCurr] :
      ( v1406(VarCurr)
    <=> ( ( v1290(VarCurr,bitIndex3)
        <=> $true )
        & ( v1290(VarCurr,bitIndex2)
        <=> $true )
        & ( v1290(VarCurr,bitIndex1)
        <=> $false )
        & ( v1290(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_332,axiom,
    b1101(bitIndex3) ).

fof(bitBlastConstant_331,axiom,
    b1101(bitIndex2) ).

fof(bitBlastConstant_330,axiom,
    ~ b1101(bitIndex1) ).

fof(bitBlastConstant_329,axiom,
    b1101(bitIndex0) ).

fof(writeUnaryOperator_89,axiom,
    ! [VarCurr] :
      ( ~ v1405(VarCurr)
    <=> v1379(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_146,axiom,
    ! [VarCurr] :
      ( v1397(VarCurr)
    <=> ( v1398(VarCurr)
        | v1401(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_145,axiom,
    ! [VarCurr] :
      ( v1401(VarCurr)
    <=> ( v1402(VarCurr)
        & v1403(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_49,axiom,
    ! [VarCurr] :
      ( v1403(VarCurr)
    <=> ( ( v1290(VarCurr,bitIndex3)
        <=> $false )
        & ( v1290(VarCurr,bitIndex2)
        <=> $true )
        & ( v1290(VarCurr,bitIndex1)
        <=> $false )
        & ( v1290(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeUnaryOperator_88,axiom,
    ! [VarCurr] :
      ( ~ v1402(VarCurr)
    <=> v1379(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_144,axiom,
    ! [VarCurr] :
      ( v1398(VarCurr)
    <=> ( v1399(VarCurr)
        & v1400(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_48,axiom,
    ! [VarCurr] :
      ( v1400(VarCurr)
    <=> ( ( v1290(VarCurr,bitIndex3)
        <=> $false )
        & ( v1290(VarCurr,bitIndex2)
        <=> $false )
        & ( v1290(VarCurr,bitIndex1)
        <=> $false )
        & ( v1290(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignmentInitValueVector_20,axiom,
    ! [B] :
      ( range_3_0(B)
     => ( v1290(constB0,B)
      <=> $false ) ) ).

fof(writeUnaryOperator_87,axiom,
    ! [VarCurr] :
      ( ~ v1399(VarCurr)
    <=> v1294(VarCurr) ) ).

fof(addAssignment_421,axiom,
    ! [VarCurr] :
      ( v1387(VarCurr)
    <=> v1286(VarCurr) ) ).

fof(addAssignment_420,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v1364(VarCurr,B)
      <=> v1366(VarCurr,B) ) ) ).

fof(addAssignment_419,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v1366(VarCurr,B)
      <=> v1368(VarCurr,B) ) ) ).

fof(addAssignment_418,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v1368(VarCurr,B)
      <=> v1370(VarCurr,B) ) ) ).

fof(addAssignment_417,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v1370(VarCurr,B)
      <=> v1372(VarCurr,B) ) ) ).

fof(addAssignment_416,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v1372(VarCurr,B)
      <=> v1374(VarCurr,B) ) ) ).

fof(addAssignment_415,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v1374(VarCurr,B)
      <=> b0101(B) ) ) ).

fof(bitBlastConstant_328,axiom,
    ~ b0101(bitIndex3) ).

fof(bitBlastConstant_327,axiom,
    b0101(bitIndex2) ).

fof(bitBlastConstant_326,axiom,
    ~ b0101(bitIndex1) ).

fof(bitBlastConstant_325,axiom,
    b0101(bitIndex0) ).

fof(addAssignment_414,axiom,
    ! [VarCurr] :
      ( v1294(VarCurr)
    <=> v1296(VarCurr) ) ).

fof(addAssignment_413,axiom,
    ! [VarCurr] :
      ( v1296(VarCurr)
    <=> v1298(VarCurr) ) ).

fof(addAssignment_412,axiom,
    ! [VarCurr] :
      ( v1298(VarCurr)
    <=> v1300(VarCurr) ) ).

fof(addAssignment_411,axiom,
    ! [VarCurr] :
      ( v1300(VarCurr)
    <=> v1302(VarCurr) ) ).

fof(addAssignment_410,axiom,
    ! [VarCurr] :
      ( v1302(VarCurr)
    <=> v1304(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_8,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1351(VarNext)
       => ( v1304(VarNext)
        <=> v1304(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_9,axiom,
    ! [VarNext] :
      ( v1351(VarNext)
     => ( v1304(VarNext)
      <=> v1359(VarNext) ) ) ).

fof(addAssignment_409,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1359(VarNext)
      <=> v1357(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_30,axiom,
    ! [VarCurr] :
      ( ~ v1360(VarCurr)
     => ( v1357(VarCurr)
      <=> v1306(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_30,axiom,
    ! [VarCurr] :
      ( v1360(VarCurr)
     => ( v1357(VarCurr)
      <=> $false ) ) ).

fof(writeUnaryOperator_86,axiom,
    ! [VarCurr] :
      ( ~ v1360(VarCurr)
    <=> v8(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_143,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1351(VarNext)
      <=> v1352(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_142,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1352(VarNext)
      <=> ( v1353(VarNext)
          & v1252(VarNext) ) ) ) ).

fof(writeUnaryOperator_85,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1353(VarNext)
      <=> v1259(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_29,axiom,
    ! [VarCurr] :
      ( ~ v1311(VarCurr)
     => ( v1306(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_29,axiom,
    ! [VarCurr] :
      ( v1311(VarCurr)
     => ( v1306(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_141,axiom,
    ! [VarCurr] :
      ( v1311(VarCurr)
    <=> ( v1312(VarCurr)
        | v1345(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_140,axiom,
    ! [VarCurr] :
      ( v1345(VarCurr)
    <=> ( v1346(VarCurr)
        & v1348(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_47,axiom,
    ! [VarCurr] :
      ( v1348(VarCurr)
    <=> ( $true
      <=> v6(VarCurr,bitIndex4) ) ) ).

fof(addBitVectorEqualityBitBlasted_46,axiom,
    ! [VarCurr] :
      ( v1346(VarCurr)
    <=> ( ( v1347(VarCurr,bitIndex1)
        <=> $true )
        & ( v1347(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_408,axiom,
    ! [VarCurr] :
      ( v1347(VarCurr,bitIndex0)
    <=> v1308(VarCurr) ) ).

fof(addAssignment_407,axiom,
    ! [VarCurr] :
      ( v1347(VarCurr,bitIndex1)
    <=> v1193(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_139,axiom,
    ! [VarCurr] :
      ( v1312(VarCurr)
    <=> ( v1313(VarCurr)
        | v1334(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_138,axiom,
    ! [VarCurr] :
      ( v1334(VarCurr)
    <=> ( v1335(VarCurr)
        & v1344(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_45,axiom,
    ! [VarCurr] :
      ( v1344(VarCurr)
    <=> ( $true
      <=> v6(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_137,axiom,
    ! [VarCurr] :
      ( v1335(VarCurr)
    <=> ( v1336(VarCurr)
        | v1341(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_136,axiom,
    ! [VarCurr] :
      ( v1341(VarCurr)
    <=> ( v1308(VarCurr)
        & v1342(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_44,axiom,
    ! [VarCurr] :
      ( v1342(VarCurr)
    <=> ( ( v1343(VarCurr,bitIndex1)
        <=> $true )
        & ( v1343(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_406,axiom,
    ! [VarCurr] :
      ( v1343(VarCurr,bitIndex0)
    <=> v1193(VarCurr) ) ).

fof(addAssignment_405,axiom,
    ! [VarCurr] :
      ( v1343(VarCurr,bitIndex1)
    <=> v1272(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_135,axiom,
    ! [VarCurr] :
      ( v1336(VarCurr)
    <=> ( v1337(VarCurr)
        | v1339(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_43,axiom,
    ! [VarCurr] :
      ( v1339(VarCurr)
    <=> ( ( v1340(VarCurr,bitIndex1)
        <=> $false )
        & ( v1340(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_404,axiom,
    ! [VarCurr] :
      ( v1340(VarCurr,bitIndex0)
    <=> v1193(VarCurr) ) ).

fof(addAssignment_403,axiom,
    ! [VarCurr] :
      ( v1340(VarCurr,bitIndex1)
    <=> v1272(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_42,axiom,
    ! [VarCurr] :
      ( v1337(VarCurr)
    <=> ( ( v1338(VarCurr,bitIndex1)
        <=> $false )
        & ( v1338(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_402,axiom,
    ! [VarCurr] :
      ( v1338(VarCurr,bitIndex0)
    <=> v1193(VarCurr) ) ).

fof(addAssignment_401,axiom,
    ! [VarCurr] :
      ( v1338(VarCurr,bitIndex1)
    <=> v1272(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_134,axiom,
    ! [VarCurr] :
      ( v1313(VarCurr)
    <=> ( v1314(VarCurr)
        | v1324(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_133,axiom,
    ! [VarCurr] :
      ( v1324(VarCurr)
    <=> ( v1325(VarCurr)
        & v1333(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_41,axiom,
    ! [VarCurr] :
      ( v1333(VarCurr)
    <=> ( $true
      <=> v6(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_132,axiom,
    ! [VarCurr] :
      ( v1325(VarCurr)
    <=> ( v1326(VarCurr)
        | v1331(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_40,axiom,
    ! [VarCurr] :
      ( v1331(VarCurr)
    <=> ( ( v1332(VarCurr,bitIndex1)
        <=> $true )
        & ( v1332(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_400,axiom,
    ! [VarCurr] :
      ( v1332(VarCurr,bitIndex0)
    <=> v1308(VarCurr) ) ).

fof(addAssignment_399,axiom,
    ! [VarCurr] :
      ( v1332(VarCurr,bitIndex1)
    <=> v1272(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_131,axiom,
    ! [VarCurr] :
      ( v1326(VarCurr)
    <=> ( v1327(VarCurr)
        | v1329(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_39,axiom,
    ! [VarCurr] :
      ( v1329(VarCurr)
    <=> ( ( v1330(VarCurr,bitIndex1)
        <=> $false )
        & ( v1330(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_398,axiom,
    ! [VarCurr] :
      ( v1330(VarCurr,bitIndex0)
    <=> v1308(VarCurr) ) ).

fof(addAssignment_397,axiom,
    ! [VarCurr] :
      ( v1330(VarCurr,bitIndex1)
    <=> v1272(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_38,axiom,
    ! [VarCurr] :
      ( v1327(VarCurr)
    <=> ( ( v1328(VarCurr,bitIndex1)
        <=> $false )
        & ( v1328(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_396,axiom,
    ! [VarCurr] :
      ( v1328(VarCurr,bitIndex0)
    <=> v1308(VarCurr) ) ).

fof(addAssignment_395,axiom,
    ! [VarCurr] :
      ( v1328(VarCurr,bitIndex1)
    <=> v1272(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_130,axiom,
    ! [VarCurr] :
      ( v1314(VarCurr)
    <=> ( v1315(VarCurr)
        | v1323(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_37,axiom,
    ! [VarCurr] :
      ( v1323(VarCurr)
    <=> ( $true
      <=> v6(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_129,axiom,
    ! [VarCurr] :
      ( v1315(VarCurr)
    <=> ( v1316(VarCurr)
        & v1322(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_36,axiom,
    ! [VarCurr] :
      ( v1322(VarCurr)
    <=> ( $true
      <=> v6(VarCurr,bitIndex0) ) ) ).

fof(addAssignmentInitValueVector_19,axiom,
    ( ( v6(constB0,bitIndex4)
    <=> $false )
    & ( v6(constB0,bitIndex3)
    <=> $false )
    & ( v6(constB0,bitIndex2)
    <=> $false )
    & ( v6(constB0,bitIndex1)
    <=> $false ) ) ).

fof(addAssignmentInitValueVector_18,axiom,
    ( v6(constB0,bitIndex0)
  <=> $true ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_128,axiom,
    ! [VarCurr] :
      ( v1316(VarCurr)
    <=> ( v1317(VarCurr)
        & v1320(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_127,axiom,
    ! [VarCurr] :
      ( v1320(VarCurr)
    <=> ( v1321(VarCurr)
        & v1193(VarCurr) ) ) ).

fof(writeUnaryOperator_84,axiom,
    ! [VarCurr] :
      ( ~ v1321(VarCurr)
    <=> v23(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_126,axiom,
    ! [VarCurr] :
      ( v1317(VarCurr)
    <=> ( v1318(VarCurr)
        | v1319(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_35,axiom,
    ! [VarCurr] :
      ( v1319(VarCurr)
    <=> ( ( v21(VarCurr,bitIndex1)
        <=> $true )
        & ( v21(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_34,axiom,
    ! [VarCurr] :
      ( v1318(VarCurr)
    <=> ( ( v21(VarCurr,bitIndex1)
        <=> $false )
        & ( v21(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorShiftedRanges_49,axiom,
    ! [VarCurr] :
      ( v1308(VarCurr)
    <=> ( v21(VarCurr,bitIndex1)
      <~> v21(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_394,axiom,
    ! [VarCurr] :
      ( v1284(VarCurr)
    <=> v1286(VarCurr) ) ).

fof(addAssignment_393,axiom,
    ! [VarCurr] :
      ( v1286(VarCurr)
    <=> v14(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_48,axiom,
    ! [VarCurr] :
      ( v1193(VarCurr)
    <=> ( v1245(VarCurr)
        | v1195(VarCurr,bitIndex2) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_7,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1255(VarNext)
       => ! [B] :
            ( range_2_0(B)
           => ( v1195(VarNext,B)
            <=> v1195(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_8,axiom,
    ! [VarNext] :
      ( v1255(VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v1195(VarNext,B)
          <=> v1265(VarNext,B) ) ) ) ).

fof(addAssignment_392,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v1265(VarNext,B)
          <=> v1263(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_28,axiom,
    ! [VarCurr] :
      ( ~ v1266(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v1263(VarCurr,B)
          <=> v1198(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_28,axiom,
    ! [VarCurr] :
      ( v1266(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v1263(VarCurr,B)
          <=> b100(B) ) ) ) ).

fof(writeUnaryOperator_83,axiom,
    ! [VarCurr] :
      ( ~ v1266(VarCurr)
    <=> v8(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_125,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1255(VarNext)
      <=> v1256(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_124,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1256(VarNext)
      <=> ( v1257(VarNext)
          & v1252(VarNext) ) ) ) ).

fof(writeUnaryOperator_82,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1257(VarNext)
      <=> v1259(VarNext) ) ) ).

fof(addAssignment_391,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1259(VarNext)
      <=> v1252(VarCurr) ) ) ).

fof(addAssignment_390,axiom,
    ! [VarCurr] :
      ( v1252(VarCurr)
    <=> v803(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_2,axiom,
    ! [VarCurr] :
      ( ( ~ v1218(VarCurr)
        & ~ v1234(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v1198(VarCurr,B)
          <=> v1195(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_3,axiom,
    ! [VarCurr] :
      ( v1234(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v1198(VarCurr,B)
          <=> v1236(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_3,axiom,
    ! [VarCurr] :
      ( v1218(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v1198(VarCurr,B)
          <=> v1220(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_123,axiom,
    ! [VarCurr] :
      ( v1246(VarCurr)
    <=> ( v1247(VarCurr)
        | v1249(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_33,axiom,
    ! [VarCurr] :
      ( v1249(VarCurr)
    <=> ( ( v1250(VarCurr,bitIndex1)
        <=> $true )
        & ( v1250(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_389,axiom,
    ! [VarCurr] :
      ( v1250(VarCurr,bitIndex0)
    <=> v1191(VarCurr) ) ).

fof(addAssignment_388,axiom,
    ! [VarCurr] :
      ( v1250(VarCurr,bitIndex1)
    <=> v1200(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_32,axiom,
    ! [VarCurr] :
      ( v1247(VarCurr)
    <=> ( ( v1248(VarCurr,bitIndex1)
        <=> $false )
        & ( v1248(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_387,axiom,
    ! [VarCurr] :
      ( v1248(VarCurr,bitIndex0)
    <=> v1191(VarCurr) ) ).

fof(addAssignment_386,axiom,
    ! [VarCurr] :
      ( v1248(VarCurr,bitIndex1)
    <=> v1200(VarCurr) ) ).

fof(addAssignment_385,axiom,
    ! [VarCurr] :
      ( v1236(VarCurr,bitIndex0)
    <=> v1232(VarCurr) ) ).

fof(addAssignment_384,axiom,
    ! [VarCurr] :
      ( v1236(VarCurr,bitIndex1)
    <=> v1243(VarCurr) ) ).

fof(addAssignment_383,axiom,
    ! [VarCurr] :
      ( v1236(VarCurr,bitIndex2)
    <=> v1238(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_122,axiom,
    ! [VarCurr] :
      ( v1243(VarCurr)
    <=> ( v1244(VarCurr)
        & v1245(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_47,axiom,
    ! [VarCurr] :
      ( v1245(VarCurr)
    <=> ( v1195(VarCurr,bitIndex0)
        | v1195(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_121,axiom,
    ! [VarCurr] :
      ( v1244(VarCurr)
    <=> ( v1232(VarCurr)
        | v1227(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_120,axiom,
    ! [VarCurr] :
      ( v1238(VarCurr)
    <=> ( v1239(VarCurr)
        & v1242(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_46,axiom,
    ! [VarCurr] :
      ( v1242(VarCurr)
    <=> ( v1195(VarCurr,bitIndex2)
        | v1241(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_119,axiom,
    ! [VarCurr] :
      ( v1239(VarCurr)
    <=> ( v1229(VarCurr)
        | v1240(VarCurr) ) ) ).

fof(writeUnaryOperator_81,axiom,
    ! [VarCurr] :
      ( ~ v1240(VarCurr)
    <=> v1241(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_45,axiom,
    ! [VarCurr] :
      ( v1241(VarCurr)
    <=> ( v1195(VarCurr,bitIndex0)
        & v1195(VarCurr,bitIndex1) ) ) ).

fof(addBitVectorEqualityBitBlasted_31,axiom,
    ! [VarCurr] :
      ( v1234(VarCurr)
    <=> ( ( v1235(VarCurr,bitIndex1)
        <=> $true )
        & ( v1235(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_382,axiom,
    ! [VarCurr] :
      ( v1235(VarCurr,bitIndex0)
    <=> v1191(VarCurr) ) ).

fof(addAssignment_381,axiom,
    ! [VarCurr] :
      ( v1235(VarCurr,bitIndex1)
    <=> v1200(VarCurr) ) ).

fof(addAssignment_380,axiom,
    ! [VarCurr] :
      ( v1220(VarCurr,bitIndex0)
    <=> v1232(VarCurr) ) ).

fof(addAssignment_379,axiom,
    ! [VarCurr] :
      ( v1220(VarCurr,bitIndex1)
    <=> v1230(VarCurr) ) ).

fof(addAssignment_378,axiom,
    ! [VarCurr] :
      ( v1220(VarCurr,bitIndex2)
    <=> v1222(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_118,axiom,
    ! [VarCurr] :
      ( v1230(VarCurr)
    <=> ( v1231(VarCurr)
        & v1233(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_117,axiom,
    ! [VarCurr] :
      ( v1233(VarCurr)
    <=> ( v1195(VarCurr,bitIndex0)
        | v1227(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_44,axiom,
    ! [VarCurr] :
      ( v1231(VarCurr)
    <=> ( v1232(VarCurr)
        | v1195(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_80,axiom,
    ! [VarCurr] :
      ( ~ v1232(VarCurr)
    <=> v1195(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_116,axiom,
    ! [VarCurr] :
      ( v1222(VarCurr)
    <=> ( v1223(VarCurr)
        & v1228(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_115,axiom,
    ! [VarCurr] :
      ( v1228(VarCurr)
    <=> ( v1225(VarCurr)
        | v1229(VarCurr) ) ) ).

fof(writeUnaryOperator_79,axiom,
    ! [VarCurr] :
      ( ~ v1229(VarCurr)
    <=> v1195(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges_43,axiom,
    ! [VarCurr] :
      ( v1223(VarCurr)
    <=> ( v1224(VarCurr)
        | v1195(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_78,axiom,
    ! [VarCurr] :
      ( ~ v1224(VarCurr)
    <=> v1225(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_42,axiom,
    ! [VarCurr] :
      ( v1225(VarCurr)
    <=> ( v1195(VarCurr,bitIndex1)
        | v1226(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_114,axiom,
    ! [VarCurr] :
      ( v1226(VarCurr)
    <=> ( v1195(VarCurr,bitIndex0)
        & v1227(VarCurr) ) ) ).

fof(writeUnaryOperator_77,axiom,
    ! [VarCurr] :
      ( ~ v1227(VarCurr)
    <=> v1195(VarCurr,bitIndex1) ) ).

fof(addAssignmentInitValue_72,axiom,
    v1195(constB0,bitIndex2) ).

fof(addAssignmentInitValue_71,axiom,
    ~ v1195(constB0,bitIndex1) ).

fof(addAssignmentInitValue_70,axiom,
    ~ v1195(constB0,bitIndex0) ).

fof(bitBlastConstant_324,axiom,
    b100(bitIndex2) ).

fof(bitBlastConstant_323,axiom,
    ~ b100(bitIndex1) ).

fof(bitBlastConstant_322,axiom,
    ~ b100(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_30,axiom,
    ! [VarCurr] :
      ( v1218(VarCurr)
    <=> ( ( v1219(VarCurr,bitIndex1)
        <=> $false )
        & ( v1219(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_377,axiom,
    ! [VarCurr] :
      ( v1219(VarCurr,bitIndex0)
    <=> v1191(VarCurr) ) ).

fof(addAssignment_376,axiom,
    ! [VarCurr] :
      ( v1219(VarCurr,bitIndex1)
    <=> v1200(VarCurr) ) ).

fof(addAssignment_375,axiom,
    ! [VarCurr] :
      ( v1200(VarCurr)
    <=> v1202(VarCurr) ) ).

fof(addAssignment_374,axiom,
    ! [VarCurr] :
      ( v1202(VarCurr)
    <=> v1204(VarCurr) ) ).

fof(addAssignment_373,axiom,
    ! [VarCurr] :
      ( v1204(VarCurr)
    <=> v1206(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_27,axiom,
    ! [VarCurr] :
      ( ~ v1209(VarCurr)
     => ( v1206(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_27,axiom,
    ! [VarCurr] :
      ( v1209(VarCurr)
     => ( v1206(VarCurr)
      <=> v1216(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_2,axiom,
    ! [VarCurr] :
      ( ~ v1210(VarCurr)
     => ( v1216(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_2,axiom,
    ! [VarCurr] :
      ( v1210(VarCurr)
     => ( v1216(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_113,axiom,
    ! [VarCurr] :
      ( v1209(VarCurr)
    <=> ( v1210(VarCurr)
        | v1212(VarCurr) ) ) ).

fof(writeUnaryOperator_76,axiom,
    ! [VarCurr] :
      ( ~ v1212(VarCurr)
    <=> v1213(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_112,axiom,
    ! [VarCurr] :
      ( v1213(VarCurr)
    <=> ( v1210(VarCurr)
        | v1214(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_29,axiom,
    ! [VarCurr] :
      ( v1214(VarCurr)
    <=> ( ( v1215(VarCurr,bitIndex2)
        <=> $false )
        & ( v1215(VarCurr,bitIndex1)
        <=> $true )
        & ( v1215(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_321,axiom,
    ~ b010(bitIndex2) ).

fof(bitBlastConstant_320,axiom,
    b010(bitIndex1) ).

fof(bitBlastConstant_319,axiom,
    ~ b010(bitIndex0) ).

fof(addAssignment_372,axiom,
    ! [VarCurr] :
      ( v1215(VarCurr,bitIndex0)
    <=> v1173(VarCurr) ) ).

fof(addAssignment_371,axiom,
    ! [VarCurr] :
      ( v1215(VarCurr,bitIndex1)
    <=> v747(VarCurr) ) ).

fof(addAssignment_370,axiom,
    ! [VarCurr] :
      ( v1215(VarCurr,bitIndex2)
    <=> v681(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_28,axiom,
    ! [VarCurr] :
      ( v1210(VarCurr)
    <=> ( ( v1211(VarCurr,bitIndex2)
        <=> $false )
        & ( v1211(VarCurr,bitIndex1)
        <=> $false )
        & ( v1211(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_318,axiom,
    ~ b001(bitIndex2) ).

fof(bitBlastConstant_317,axiom,
    ~ b001(bitIndex1) ).

fof(bitBlastConstant_316,axiom,
    b001(bitIndex0) ).

fof(addAssignment_369,axiom,
    ! [VarCurr] :
      ( v1211(VarCurr,bitIndex0)
    <=> v1173(VarCurr) ) ).

fof(addAssignment_368,axiom,
    ! [VarCurr] :
      ( v1211(VarCurr,bitIndex1)
    <=> v747(VarCurr) ) ).

fof(addAssignment_367,axiom,
    ! [VarCurr] :
      ( v1211(VarCurr,bitIndex2)
    <=> v681(VarCurr) ) ).

fof(addAssignment_366,axiom,
    ! [VarCurr] :
      ( v1183(VarCurr)
    <=> v743(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_111,axiom,
    ! [VarCurr] :
      ( v747(VarCurr)
    <=> ( v1170(VarCurr)
        & v1171(VarCurr) ) ) ).

fof(writeUnaryOperator_75,axiom,
    ! [VarCurr] :
      ( ~ v1171(VarCurr)
    <=> v1080(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_27,axiom,
    ! [VarCurr] :
      ( v1170(VarCurr)
    <=> ( ( v749(VarCurr,bitIndex7)
        <=> v823(VarCurr,bitIndex7) )
        & ( v749(VarCurr,bitIndex6)
        <=> v823(VarCurr,bitIndex6) )
        & ( v749(VarCurr,bitIndex5)
        <=> v823(VarCurr,bitIndex5) )
        & ( v749(VarCurr,bitIndex4)
        <=> v823(VarCurr,bitIndex4) )
        & ( v749(VarCurr,bitIndex3)
        <=> v823(VarCurr,bitIndex3) )
        & ( v749(VarCurr,bitIndex2)
        <=> v823(VarCurr,bitIndex2) )
        & ( v749(VarCurr,bitIndex1)
        <=> v823(VarCurr,bitIndex1) )
        & ( v749(VarCurr,bitIndex0)
        <=> v823(VarCurr,bitIndex0) ) ) ) ).

fof(addAssignment_365,axiom,
    ! [VarCurr] :
      ( v1080(VarCurr)
    <=> v1082(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_26,axiom,
    ! [VarCurr] :
      ( v1082(VarCurr)
    <=> ( ( v1084(VarCurr,bitIndex3)
        <=> $false )
        & ( v1084(VarCurr,bitIndex2)
        <=> $false )
        & ( v1084(VarCurr,bitIndex1)
        <=> $false )
        & ( v1084(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_6,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1156(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v1084(VarNext,B)
            <=> v1084(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_7,axiom,
    ! [VarNext] :
      ( v1156(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v1084(VarNext,B)
          <=> v1164(VarNext,B) ) ) ) ).

fof(addAssignment_364,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v1164(VarNext,B)
          <=> v1162(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_26,axiom,
    ! [VarCurr] :
      ( ~ v1165(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1162(VarCurr,B)
          <=> v1086(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_26,axiom,
    ! [VarCurr] :
      ( v1165(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1162(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_74,axiom,
    ! [VarCurr] :
      ( ~ v1165(VarCurr)
    <=> v834(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_110,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1156(VarNext)
      <=> v1157(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_109,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1157(VarNext)
      <=> ( v1158(VarNext)
          & v831(VarNext) ) ) ) ).

fof(writeUnaryOperator_73,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1158(VarNext)
      <=> v1004(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_1,axiom,
    ! [VarCurr] :
      ( ( ~ v1091(VarCurr)
        & ~ v1093(VarCurr)
        & ~ v1129(VarCurr) )
     => ! [B] :
          ( range_3_0(B)
         => ( v1086(VarCurr,B)
          <=> v1084(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_1,axiom,
    ! [VarCurr] :
      ( v1129(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1086(VarCurr,B)
          <=> v1131(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1,axiom,
    ! [VarCurr] :
      ( v1093(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1086(VarCurr,B)
          <=> v1095(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1,axiom,
    ! [VarCurr] :
      ( v1091(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1086(VarCurr,B)
          <=> v1084(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_25,axiom,
    ! [VarCurr] :
      ( v1152(VarCurr)
    <=> ( ( v1153(VarCurr,bitIndex1)
        <=> $true )
        & ( v1153(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_363,axiom,
    ! [VarCurr] :
      ( v1153(VarCurr,bitIndex0)
    <=> v1049(VarCurr) ) ).

fof(addAssignment_362,axiom,
    ! [VarCurr] :
      ( v1153(VarCurr,bitIndex1)
    <=> v944(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_25,axiom,
    ! [VarCurr] :
      ( ~ v1132(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1131(VarCurr,B)
          <=> v1133(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_25,axiom,
    ! [VarCurr] :
      ( v1132(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1131(VarCurr,B)
          <=> b1000(B) ) ) ) ).

fof(addAssignment_361,axiom,
    ! [VarCurr] :
      ( v1133(VarCurr,bitIndex0)
    <=> v1149(VarCurr) ) ).

fof(addAssignment_360,axiom,
    ! [VarCurr] :
      ( v1133(VarCurr,bitIndex1)
    <=> v1147(VarCurr) ) ).

fof(addAssignment_359,axiom,
    ! [VarCurr] :
      ( v1133(VarCurr,bitIndex2)
    <=> v1142(VarCurr) ) ).

fof(addAssignment_358,axiom,
    ! [VarCurr] :
      ( v1133(VarCurr,bitIndex3)
    <=> v1135(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_108,axiom,
    ! [VarCurr] :
      ( v1147(VarCurr)
    <=> ( v1148(VarCurr)
        & v1151(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_41,axiom,
    ! [VarCurr] :
      ( v1151(VarCurr)
    <=> ( v1084(VarCurr,bitIndex0)
        | v1084(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_107,axiom,
    ! [VarCurr] :
      ( v1148(VarCurr)
    <=> ( v1149(VarCurr)
        | v1150(VarCurr) ) ) ).

fof(writeUnaryOperator_72,axiom,
    ! [VarCurr] :
      ( ~ v1150(VarCurr)
    <=> v1084(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_71,axiom,
    ! [VarCurr] :
      ( ~ v1149(VarCurr)
    <=> v1084(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_106,axiom,
    ! [VarCurr] :
      ( v1142(VarCurr)
    <=> ( v1143(VarCurr)
        & v1146(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_40,axiom,
    ! [VarCurr] :
      ( v1146(VarCurr)
    <=> ( v1139(VarCurr)
        | v1084(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_105,axiom,
    ! [VarCurr] :
      ( v1143(VarCurr)
    <=> ( v1144(VarCurr)
        | v1145(VarCurr) ) ) ).

fof(writeUnaryOperator_70,axiom,
    ! [VarCurr] :
      ( ~ v1145(VarCurr)
    <=> v1084(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_69,axiom,
    ! [VarCurr] :
      ( ~ v1144(VarCurr)
    <=> v1139(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_104,axiom,
    ! [VarCurr] :
      ( v1135(VarCurr)
    <=> ( v1136(VarCurr)
        & v1141(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_39,axiom,
    ! [VarCurr] :
      ( v1141(VarCurr)
    <=> ( v1138(VarCurr)
        | v1084(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_103,axiom,
    ! [VarCurr] :
      ( v1136(VarCurr)
    <=> ( v1137(VarCurr)
        | v1140(VarCurr) ) ) ).

fof(writeUnaryOperator_68,axiom,
    ! [VarCurr] :
      ( ~ v1140(VarCurr)
    <=> v1084(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_67,axiom,
    ! [VarCurr] :
      ( ~ v1137(VarCurr)
    <=> v1138(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_38,axiom,
    ! [VarCurr] :
      ( v1138(VarCurr)
    <=> ( v1139(VarCurr)
        & v1084(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_37,axiom,
    ! [VarCurr] :
      ( v1139(VarCurr)
    <=> ( v1084(VarCurr,bitIndex0)
        & v1084(VarCurr,bitIndex1) ) ) ).

fof(addBitVectorEqualityBitBlasted_24,axiom,
    ! [VarCurr] :
      ( v1132(VarCurr)
    <=> ( ( v1084(VarCurr,bitIndex3)
        <=> $true )
        & ( v1084(VarCurr,bitIndex2)
        <=> $false )
        & ( v1084(VarCurr,bitIndex1)
        <=> $false )
        & ( v1084(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_315,axiom,
    b1000(bitIndex3) ).

fof(bitBlastConstant_314,axiom,
    ~ b1000(bitIndex2) ).

fof(bitBlastConstant_313,axiom,
    ~ b1000(bitIndex1) ).

fof(bitBlastConstant_312,axiom,
    ~ b1000(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_23,axiom,
    ! [VarCurr] :
      ( v1129(VarCurr)
    <=> ( ( v1130(VarCurr,bitIndex1)
        <=> $true )
        & ( v1130(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_357,axiom,
    ! [VarCurr] :
      ( v1130(VarCurr,bitIndex0)
    <=> v1049(VarCurr) ) ).

fof(addAssignment_356,axiom,
    ! [VarCurr] :
      ( v1130(VarCurr,bitIndex1)
    <=> v944(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_24,axiom,
    ! [VarCurr] :
      ( ~ v1096(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v1095(VarCurr,B)
          <=> v1097(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_24,axiom,
    ! [VarCurr] :
      ( v1096(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v1095(VarCurr,B)
          <=> $false ) ) ) ).

fof(range_axiom_21,axiom,
    ! [B] :
      ( range_31_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B
        | bitIndex30 = B
        | bitIndex31 = B ) ) ).

fof(bitBlastConstant_311,axiom,
    ~ b00000000000000000000000000000000(bitIndex31) ).

fof(bitBlastConstant_310,axiom,
    ~ b00000000000000000000000000000000(bitIndex30) ).

fof(bitBlastConstant_309,axiom,
    ~ b00000000000000000000000000000000(bitIndex29) ).

fof(bitBlastConstant_308,axiom,
    ~ b00000000000000000000000000000000(bitIndex28) ).

fof(bitBlastConstant_307,axiom,
    ~ b00000000000000000000000000000000(bitIndex27) ).

fof(bitBlastConstant_306,axiom,
    ~ b00000000000000000000000000000000(bitIndex26) ).

fof(bitBlastConstant_305,axiom,
    ~ b00000000000000000000000000000000(bitIndex25) ).

fof(bitBlastConstant_304,axiom,
    ~ b00000000000000000000000000000000(bitIndex24) ).

fof(bitBlastConstant_303,axiom,
    ~ b00000000000000000000000000000000(bitIndex23) ).

fof(bitBlastConstant_302,axiom,
    ~ b00000000000000000000000000000000(bitIndex22) ).

fof(bitBlastConstant_301,axiom,
    ~ b00000000000000000000000000000000(bitIndex21) ).

fof(bitBlastConstant_300,axiom,
    ~ b00000000000000000000000000000000(bitIndex20) ).

fof(bitBlastConstant_299,axiom,
    ~ b00000000000000000000000000000000(bitIndex19) ).

fof(bitBlastConstant_298,axiom,
    ~ b00000000000000000000000000000000(bitIndex18) ).

fof(bitBlastConstant_297,axiom,
    ~ b00000000000000000000000000000000(bitIndex17) ).

fof(bitBlastConstant_296,axiom,
    ~ b00000000000000000000000000000000(bitIndex16) ).

fof(bitBlastConstant_295,axiom,
    ~ b00000000000000000000000000000000(bitIndex15) ).

fof(bitBlastConstant_294,axiom,
    ~ b00000000000000000000000000000000(bitIndex14) ).

fof(bitBlastConstant_293,axiom,
    ~ b00000000000000000000000000000000(bitIndex13) ).

fof(bitBlastConstant_292,axiom,
    ~ b00000000000000000000000000000000(bitIndex12) ).

fof(bitBlastConstant_291,axiom,
    ~ b00000000000000000000000000000000(bitIndex11) ).

fof(bitBlastConstant_290,axiom,
    ~ b00000000000000000000000000000000(bitIndex10) ).

fof(bitBlastConstant_289,axiom,
    ~ b00000000000000000000000000000000(bitIndex9) ).

fof(bitBlastConstant_288,axiom,
    ~ b00000000000000000000000000000000(bitIndex8) ).

fof(bitBlastConstant_287,axiom,
    ~ b00000000000000000000000000000000(bitIndex7) ).

fof(bitBlastConstant_286,axiom,
    ~ b00000000000000000000000000000000(bitIndex6) ).

fof(bitBlastConstant_285,axiom,
    ~ b00000000000000000000000000000000(bitIndex5) ).

fof(bitBlastConstant_284,axiom,
    ~ b00000000000000000000000000000000(bitIndex4) ).

fof(bitBlastConstant_283,axiom,
    ~ b00000000000000000000000000000000(bitIndex3) ).

fof(bitBlastConstant_282,axiom,
    ~ b00000000000000000000000000000000(bitIndex2) ).

fof(bitBlastConstant_281,axiom,
    ~ b00000000000000000000000000000000(bitIndex1) ).

fof(bitBlastConstant_280,axiom,
    ~ b00000000000000000000000000000000(bitIndex0) ).

fof(addSignExtensionConstraint_26,axiom,
    ! [VarCurr] :
      ( v1097(VarCurr,bitIndex5)
    <=> v1098(VarCurr,bitIndex4) ) ).

fof(addSignExtensionConstraint_25,axiom,
    ! [VarCurr] :
      ( v1097(VarCurr,bitIndex6)
    <=> v1098(VarCurr,bitIndex4) ) ).

fof(addSignExtensionConstraint_24,axiom,
    ! [VarCurr] :
      ( v1097(VarCurr,bitIndex7)
    <=> v1098(VarCurr,bitIndex4) ) ).

fof(addSignExtensionConstraint_23,axiom,
    ! [VarCurr] :
      ( v1097(VarCurr,bitIndex8)
    <=> v1098(VarCurr,bitIndex4) ) ).

fof(addSignExtensionConstraint_22,axiom,
    ! [VarCurr] :
      ( v1097(VarCurr,bitIndex9)
    <=> v1098(VarCurr,bitIndex4) ) ).

fof(addSignExtensionConstraint_21,axiom,
    ! [VarCurr] :
      ( v1097(VarCurr,bitIndex10)
    <=> v1098(VarCurr,bitIndex4) ) ).

fof(addSignExtensionConstraint_20,axiom,
    ! [VarCurr] :
      ( v1097(VarCurr,bitIndex11)
    <=> v1098(VarCurr,bitIndex4) ) ).

fof(addSignExtensionConstraint_19,axiom,
    ! [VarCurr] :
      ( v1097(VarCurr,bitIndex12)
    <=> v1098(VarCurr,bitIndex4) ) ).

fof(addSignExtensionConstraint_18,axiom,
    ! [VarCurr] :
      ( v1097(VarCurr,bitIndex13)
    <=> v1098(VarCurr,bitIndex4) ) ).

fof(addSignExtensionConstraint_17,axiom,
    ! [VarCurr] :
      ( v1097(VarCurr,bitIndex14)
    <=> v1098(VarCurr,bitIndex4) ) ).

fof(addSignExtensionConstraint_16,axiom,
    ! [VarCurr] :
      ( v1097(VarCurr,bitIndex15)
    <=> v1098(VarCurr,bitIndex4) ) ).

fof(addSignExtensionConstraint_15,axiom,
    ! [VarCurr] :
      ( v1097(VarCurr,bitIndex16)
    <=> v1098(VarCurr,bitIndex4) ) ).

fof(addSignExtensionConstraint_14,axiom,
    ! [VarCurr] :
      ( v1097(VarCurr,bitIndex17)
    <=> v1098(VarCurr,bitIndex4) ) ).

fof(addSignExtensionConstraint_13,axiom,
    ! [VarCurr] :
      ( v1097(VarCurr,bitIndex18)
    <=> v1098(VarCurr,bitIndex4) ) ).

fof(addSignExtensionConstraint_12,axiom,
    ! [VarCurr] :
      ( v1097(VarCurr,bitIndex19)
    <=> v1098(VarCurr,bitIndex4) ) ).

fof(addSignExtensionConstraint_11,axiom,
    ! [VarCurr] :
      ( v1097(VarCurr,bitIndex20)
    <=> v1098(VarCurr,bitIndex4) ) ).

fof(addSignExtensionConstraint_10,axiom,
    ! [VarCurr] :
      ( v1097(VarCurr,bitIndex21)
    <=> v1098(VarCurr,bitIndex4) ) ).

fof(addSignExtensionConstraint_9,axiom,
    ! [VarCurr] :
      ( v1097(VarCurr,bitIndex22)
    <=> v1098(VarCurr,bitIndex4) ) ).

fof(addSignExtensionConstraint_8,axiom,
    ! [VarCurr] :
      ( v1097(VarCurr,bitIndex23)
    <=> v1098(VarCurr,bitIndex4) ) ).

fof(addSignExtensionConstraint_7,axiom,
    ! [VarCurr] :
      ( v1097(VarCurr,bitIndex24)
    <=> v1098(VarCurr,bitIndex4) ) ).

fof(addSignExtensionConstraint_6,axiom,
    ! [VarCurr] :
      ( v1097(VarCurr,bitIndex25)
    <=> v1098(VarCurr,bitIndex4) ) ).

fof(addSignExtensionConstraint_5,axiom,
    ! [VarCurr] :
      ( v1097(VarCurr,bitIndex26)
    <=> v1098(VarCurr,bitIndex4) ) ).

fof(addSignExtensionConstraint_4,axiom,
    ! [VarCurr] :
      ( v1097(VarCurr,bitIndex27)
    <=> v1098(VarCurr,bitIndex4) ) ).

fof(addSignExtensionConstraint_3,axiom,
    ! [VarCurr] :
      ( v1097(VarCurr,bitIndex28)
    <=> v1098(VarCurr,bitIndex4) ) ).

fof(addSignExtensionConstraint_2,axiom,
    ! [VarCurr] :
      ( v1097(VarCurr,bitIndex29)
    <=> v1098(VarCurr,bitIndex4) ) ).

fof(addSignExtensionConstraint_1,axiom,
    ! [VarCurr] :
      ( v1097(VarCurr,bitIndex30)
    <=> v1098(VarCurr,bitIndex4) ) ).

fof(addSignExtensionConstraint,axiom,
    ! [VarCurr] :
      ( v1097(VarCurr,bitIndex31)
    <=> v1098(VarCurr,bitIndex4) ) ).

fof(addAssignment_355,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v1097(VarCurr,B)
      <=> v1098(VarCurr,B) ) ) ).

fof(addAssignment_354,axiom,
    ! [VarCurr] :
      ( v1098(VarCurr,bitIndex0)
    <=> v1126(VarCurr) ) ).

fof(addAssignment_353,axiom,
    ! [VarCurr] :
      ( v1098(VarCurr,bitIndex1)
    <=> v1124(VarCurr) ) ).

fof(addAssignment_352,axiom,
    ! [VarCurr] :
      ( v1098(VarCurr,bitIndex2)
    <=> v1120(VarCurr) ) ).

fof(addAssignment_351,axiom,
    ! [VarCurr] :
      ( v1098(VarCurr,bitIndex3)
    <=> v1116(VarCurr) ) ).

fof(addAssignment_350,axiom,
    ! [VarCurr] :
      ( v1098(VarCurr,bitIndex4)
    <=> v1100(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_102,axiom,
    ! [VarCurr] :
      ( v1124(VarCurr)
    <=> ( v1125(VarCurr)
        & v1127(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_101,axiom,
    ! [VarCurr] :
      ( v1127(VarCurr)
    <=> ( v1104(VarCurr,bitIndex0)
        | v1111(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_36,axiom,
    ! [VarCurr] :
      ( v1125(VarCurr)
    <=> ( v1126(VarCurr)
        | v1104(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_66,axiom,
    ! [VarCurr] :
      ( ~ v1126(VarCurr)
    <=> v1104(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_100,axiom,
    ! [VarCurr] :
      ( v1120(VarCurr)
    <=> ( v1121(VarCurr)
        & v1123(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_99,axiom,
    ! [VarCurr] :
      ( v1123(VarCurr)
    <=> ( v1109(VarCurr)
        | v1112(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_35,axiom,
    ! [VarCurr] :
      ( v1121(VarCurr)
    <=> ( v1122(VarCurr)
        | v1104(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_65,axiom,
    ! [VarCurr] :
      ( ~ v1122(VarCurr)
    <=> v1109(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_98,axiom,
    ! [VarCurr] :
      ( v1116(VarCurr)
    <=> ( v1117(VarCurr)
        & v1119(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_97,axiom,
    ! [VarCurr] :
      ( v1119(VarCurr)
    <=> ( v1107(VarCurr)
        | v1113(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_34,axiom,
    ! [VarCurr] :
      ( v1117(VarCurr)
    <=> ( v1118(VarCurr)
        | v1104(VarCurr,bitIndex3) ) ) ).

fof(writeUnaryOperator_64,axiom,
    ! [VarCurr] :
      ( ~ v1118(VarCurr)
    <=> v1107(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_96,axiom,
    ! [VarCurr] :
      ( v1100(VarCurr)
    <=> ( v1101(VarCurr)
        & v1114(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_95,axiom,
    ! [VarCurr] :
      ( v1114(VarCurr)
    <=> ( v1103(VarCurr)
        | v1115(VarCurr) ) ) ).

fof(writeUnaryOperator_63,axiom,
    ! [VarCurr] :
      ( ~ v1115(VarCurr)
    <=> v1104(VarCurr,bitIndex4) ) ).

fof(writeBinaryOperatorShiftedRanges_33,axiom,
    ! [VarCurr] :
      ( v1101(VarCurr)
    <=> ( v1102(VarCurr)
        | v1104(VarCurr,bitIndex4) ) ) ).

fof(writeUnaryOperator_62,axiom,
    ! [VarCurr] :
      ( ~ v1102(VarCurr)
    <=> v1103(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_32,axiom,
    ! [VarCurr] :
      ( v1103(VarCurr)
    <=> ( v1104(VarCurr,bitIndex3)
        | v1106(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_94,axiom,
    ! [VarCurr] :
      ( v1106(VarCurr)
    <=> ( v1107(VarCurr)
        & v1113(VarCurr) ) ) ).

fof(writeUnaryOperator_61,axiom,
    ! [VarCurr] :
      ( ~ v1113(VarCurr)
    <=> v1104(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorShiftedRanges_31,axiom,
    ! [VarCurr] :
      ( v1107(VarCurr)
    <=> ( v1104(VarCurr,bitIndex2)
        | v1108(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_93,axiom,
    ! [VarCurr] :
      ( v1108(VarCurr)
    <=> ( v1109(VarCurr)
        & v1112(VarCurr) ) ) ).

fof(writeUnaryOperator_60,axiom,
    ! [VarCurr] :
      ( ~ v1112(VarCurr)
    <=> v1104(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges_30,axiom,
    ! [VarCurr] :
      ( v1109(VarCurr)
    <=> ( v1104(VarCurr,bitIndex1)
        | v1110(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_92,axiom,
    ! [VarCurr] :
      ( v1110(VarCurr)
    <=> ( v1104(VarCurr,bitIndex0)
        & v1111(VarCurr) ) ) ).

fof(writeUnaryOperator_59,axiom,
    ! [VarCurr] :
      ( ~ v1111(VarCurr)
    <=> v1104(VarCurr,bitIndex1) ) ).

fof(addZeroExtensionConstraint,axiom,
    ! [VarCurr] : ~ v1104(VarCurr,bitIndex4) ).

fof(addAssignment_349,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v1104(VarCurr,B)
      <=> v1084(VarCurr,B) ) ) ).

fof(addBitVectorEqualityBitBlasted_22,axiom,
    ! [VarCurr] :
      ( v1096(VarCurr)
    <=> ( ( v1084(VarCurr,bitIndex3)
        <=> $false )
        & ( v1084(VarCurr,bitIndex2)
        <=> $false )
        & ( v1084(VarCurr,bitIndex1)
        <=> $false )
        & ( v1084(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_21,axiom,
    ! [VarCurr] :
      ( v1093(VarCurr)
    <=> ( ( v1094(VarCurr,bitIndex1)
        <=> $false )
        & ( v1094(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_348,axiom,
    ! [VarCurr] :
      ( v1094(VarCurr,bitIndex0)
    <=> v1049(VarCurr) ) ).

fof(addAssignment_347,axiom,
    ! [VarCurr] :
      ( v1094(VarCurr,bitIndex1)
    <=> v944(VarCurr) ) ).

fof(addAssignmentInitValueVector_17,axiom,
    ! [B] :
      ( range_3_0(B)
     => ( v1084(constB0,B)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_20,axiom,
    ! [VarCurr] :
      ( v1091(VarCurr)
    <=> ( ( v1092(VarCurr,bitIndex1)
        <=> $false )
        & ( v1092(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_346,axiom,
    ! [VarCurr] :
      ( v1092(VarCurr,bitIndex0)
    <=> v1049(VarCurr) ) ).

fof(addAssignment_345,axiom,
    ! [VarCurr] :
      ( v1092(VarCurr,bitIndex1)
    <=> v944(VarCurr) ) ).

fof(addAssignment_344,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v823(VarCurr,B)
      <=> v825(VarCurr,B) ) ) ).

fof(addAssignment_343,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v825(VarCurr,B)
      <=> v827(VarCurr,B) ) ) ).

fof(addAssignment_342,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v827(VarCurr,B)
      <=> v1043(VarCurr,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_5,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1068(VarNext)
       => ! [B] :
            ( range_2_0(B)
           => ( v1045(VarNext,B)
            <=> v1045(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_6,axiom,
    ! [VarNext] :
      ( v1068(VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v1045(VarNext,B)
          <=> v1076(VarNext,B) ) ) ) ).

fof(addAssignment_341,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v1076(VarNext,B)
          <=> v1074(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_23,axiom,
    ! [VarCurr] :
      ( ~ v1011(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v1074(VarCurr,B)
          <=> v1047(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_23,axiom,
    ! [VarCurr] :
      ( v1011(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v1074(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_91,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1068(VarNext)
      <=> v1069(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_90,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1069(VarNext)
      <=> ( v1071(VarNext)
          & v831(VarNext) ) ) ) ).

fof(writeUnaryOperator_58,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1071(VarNext)
      <=> v1004(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_22,axiom,
    ! [VarCurr] :
      ( ~ v1049(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v1047(VarCurr,B)
          <=> v1045(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_22,axiom,
    ! [VarCurr] :
      ( v1049(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v1047(VarCurr,B)
          <=> v1051(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_21,axiom,
    ! [VarCurr] :
      ( ~ v1052(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v1051(VarCurr,B)
          <=> v1053(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_21,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v1051(VarCurr,B)
          <=> $false ) ) ) ).

fof(addAssignment_340,axiom,
    ! [VarCurr] :
      ( v1053(VarCurr,bitIndex0)
    <=> v1063(VarCurr) ) ).

fof(addAssignment_339,axiom,
    ! [VarCurr] :
      ( v1053(VarCurr,bitIndex1)
    <=> v1061(VarCurr) ) ).

fof(addAssignment_338,axiom,
    ! [VarCurr] :
      ( v1053(VarCurr,bitIndex2)
    <=> v1055(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_89,axiom,
    ! [VarCurr] :
      ( v1061(VarCurr)
    <=> ( v1062(VarCurr)
        & v1065(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_29,axiom,
    ! [VarCurr] :
      ( v1065(VarCurr)
    <=> ( v1045(VarCurr,bitIndex0)
        | v1045(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_88,axiom,
    ! [VarCurr] :
      ( v1062(VarCurr)
    <=> ( v1063(VarCurr)
        | v1064(VarCurr) ) ) ).

fof(writeUnaryOperator_57,axiom,
    ! [VarCurr] :
      ( ~ v1064(VarCurr)
    <=> v1045(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_56,axiom,
    ! [VarCurr] :
      ( ~ v1063(VarCurr)
    <=> v1045(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_87,axiom,
    ! [VarCurr] :
      ( v1055(VarCurr)
    <=> ( v1056(VarCurr)
        & v1060(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_28,axiom,
    ! [VarCurr] :
      ( v1060(VarCurr)
    <=> ( v1058(VarCurr)
        | v1045(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_86,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr)
    <=> ( v1057(VarCurr)
        | v1059(VarCurr) ) ) ).

fof(writeUnaryOperator_55,axiom,
    ! [VarCurr] :
      ( ~ v1059(VarCurr)
    <=> v1045(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_54,axiom,
    ! [VarCurr] :
      ( ~ v1057(VarCurr)
    <=> v1058(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_27,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr)
    <=> ( v1045(VarCurr,bitIndex0)
        & v1045(VarCurr,bitIndex1) ) ) ).

fof(addBitVectorEqualityBitBlasted_19,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr)
    <=> ( ( v1045(VarCurr,bitIndex2)
        <=> $true )
        & ( v1045(VarCurr,bitIndex1)
        <=> $true )
        & ( v1045(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_337,axiom,
    ! [VarCurr] :
      ( v1049(VarCurr)
    <=> v677(VarCurr) ) ).

fof(memoryReadIntoBuffer,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v1045_range_2_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( address(A)
             => ! [B] :
                  ( A = AssociatedAddressVar
                 => ( range_130_0(B)
                   => ( v1043(VarNext,B)
                    <=> v829_array(VarNext,A,B) ) ) ) ) ) ) ).

fof(addAssignmentInitValueVector_16,axiom,
    ! [B] :
      ( range_2_0(B)
     => ( v1045(constB0,B)
      <=> $false ) ) ).

fof(memoryConstantWriteDisabled,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( $true
              & v1035(VarNext) )
         => ! [B] :
              ( range_130_0(B)
             => ( v829_array(VarNext,A,B)
              <=> v829_1__array(VarNext,A,B) ) ) ) ) ).

fof(memoryConstantWriteEnabledInsideRange,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( $true
            & v1035(VarNext) )
         => ! [B] :
              ( range_130_0(B)
             => ( v829_array(VarNext,A,B)
              <=> b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(B) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_85,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1035(VarNext)
      <=> ( v1036(VarNext)
          & v1041(VarNext) ) ) ) ).

fof(addAssignment_336,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1041(VarNext)
      <=> v1032(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_84,axiom,
    ! [VarNext,V