%------------------------------------------------------------------------------
% File     : HWV103+1 : TPTP v9.2.0. Released v6.1.0.
% Domain   : Hardware Verification
% Problem  : dmu_dmc property 15 cone of influence 5_b20
% Version  : Especial.
% English  : Verification of a property of the SPARCT2 RTL hardware design.

% Refs     : [Kha14] Khasidashvili (2014), Email to Geoff Sutcliffe
% Source   : [Kha14]
% Names    : dmu_dmc_prop15_cone5_b20 [Kha14]

% Status   : Theorem
% Rating   : 1.00 v6.1.0
% Syntax   : Number of formulae    : 5807 (2587 unt;   0 def)
%            Number of atoms       : 20478 ( 453 equ)
%            Maximal formula atoms :  142 (   3 avg)
%            Number of connectives : 17497 (2826   ~; 589   |;4504   &)
%                                         (7404 <=>;2174  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   75 (   4 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of predicates  : 2298 (2295 usr;   2 prp; 0-3 aty)
%            Number of functors    : 1540 (1540 usr;1540 con; 0-0 aty)
%            Number of variables   : 4535 (4535   !;   0   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : Copyright 2013 Moshe Emmer and Zurab Khasidashvili
%            Licensed under the Apache License, Version 2.0 (the "License");
%            you may not use this file except in compliance with the License.
%            You may obtain a copy of the License at
%                http://www.apache.org/licenses/LICENSE-2.0
%            Unless required by applicable law or agreed to in writing,
%            software distributed under the License is distributed on an "AS
%            IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
%            express or implied. See the License for the specific language
%            governing permissions and limitations under the License.
%------------------------------------------------------------------------------
fof(pathAxiom_8,axiom,
    nextState(constB8,constB9) ).

fof(pathAxiom_7,axiom,
    nextState(constB7,constB8) ).

fof(pathAxiom_6,axiom,
    nextState(constB6,constB7) ).

fof(pathAxiom_5,axiom,
    nextState(constB5,constB6) ).

fof(pathAxiom_4,axiom,
    nextState(constB4,constB5) ).

fof(pathAxiom_3,axiom,
    nextState(constB3,constB4) ).

fof(pathAxiom_2,axiom,
    nextState(constB2,constB3) ).

fof(pathAxiom_1,axiom,
    nextState(constB1,constB2) ).

fof(pathAxiom,axiom,
    nextState(constB0,constB1) ).

fof(reachableStateAxiom_22,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( reachableState(VarCurr)
        & reachableState(VarNext) ) ) ).

fof(reachableStateAxiom_21,axiom,
    ! [VarState] :
      ( reachableState(VarState)
     => ( constB0 = VarState
        | constB1 = VarState
        | constB2 = VarState
        | constB3 = VarState
        | constB4 = VarState
        | constB5 = VarState
        | constB6 = VarState
        | constB7 = VarState
        | constB8 = VarState
        | constB9 = VarState
        | constB10 = VarState
        | constB11 = VarState
        | constB12 = VarState
        | constB13 = VarState
        | constB14 = VarState
        | constB15 = VarState
        | constB16 = VarState
        | constB17 = VarState
        | constB18 = VarState
        | constB19 = VarState
        | constB20 = VarState ) ) ).

fof(reachableStateAxiom_20,axiom,
    reachableState(constB20) ).

fof(reachableStateAxiom_19,axiom,
    reachableState(constB19) ).

fof(reachableStateAxiom_18,axiom,
    reachableState(constB18) ).

fof(reachableStateAxiom_17,axiom,
    reachableState(constB17) ).

fof(reachableStateAxiom_16,axiom,
    reachableState(constB16) ).

fof(reachableStateAxiom_15,axiom,
    reachableState(constB15) ).

fof(reachableStateAxiom_14,axiom,
    reachableState(constB14) ).

fof(reachableStateAxiom_13,axiom,
    reachableState(constB13) ).

fof(reachableStateAxiom_12,axiom,
    reachableState(constB12) ).

fof(reachableStateAxiom_11,axiom,
    reachableState(constB11) ).

fof(reachableStateAxiom_10,axiom,
    reachableState(constB10) ).

fof(reachableStateAxiom_9,axiom,
    reachableState(constB9) ).

fof(reachableStateAxiom_8,axiom,
    reachableState(constB8) ).

fof(reachableStateAxiom_7,axiom,
    reachableState(constB7) ).

fof(reachableStateAxiom_6,axiom,
    reachableState(constB6) ).

fof(reachableStateAxiom_5,axiom,
    reachableState(constB5) ).

fof(reachableStateAxiom_4,axiom,
    reachableState(constB4) ).

fof(reachableStateAxiom_3,axiom,
    reachableState(constB3) ).

fof(reachableStateAxiom_2,axiom,
    reachableState(constB2) ).

fof(reachableStateAxiom_1,axiom,
    reachableState(constB1) ).

fof(reachableStateAxiom,axiom,
    reachableState(constB0) ).

fof(clock_toggling,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1(VarCurr)
      <=> ~ v1(VarNext) ) ) ).

fof(clock_pattern,axiom,
    ~ v1(constB0) ).

fof(address_false_msb_47,axiom,
    ~ addressVal(b1111_address_term,bitIndex4) ).

fof(is_address_152,axiom,
    address(b1111_address_term) ).

fof(constant_address_definition_89,axiom,
    ! [B] :
      ( addressVal(b1111_address_term,B)
    <=> b1111(B) ) ).

fof(address_false_msb_46,axiom,
    ~ addressVal(b1110_address_term,bitIndex4) ).

fof(is_address_151,axiom,
    address(b1110_address_term) ).

fof(constant_address_definition_88,axiom,
    ! [B] :
      ( addressVal(b1110_address_term,B)
    <=> b1110(B) ) ).

fof(address_false_msb_45,axiom,
    ~ addressVal(b1101_address_term,bitIndex4) ).

fof(is_address_150,axiom,
    address(b1101_address_term) ).

fof(constant_address_definition_87,axiom,
    ! [B] :
      ( addressVal(b1101_address_term,B)
    <=> b1101(B) ) ).

fof(address_false_msb_44,axiom,
    ~ addressVal(b1100_address_term,bitIndex4) ).

fof(is_address_149,axiom,
    address(b1100_address_term) ).

fof(constant_address_definition_86,axiom,
    ! [B] :
      ( addressVal(b1100_address_term,B)
    <=> b1100(B) ) ).

fof(address_false_msb_43,axiom,
    ~ addressVal(b1011_address_term,bitIndex4) ).

fof(is_address_148,axiom,
    address(b1011_address_term) ).

fof(constant_address_definition_85,axiom,
    ! [B] :
      ( addressVal(b1011_address_term,B)
    <=> b1011(B) ) ).

fof(address_false_msb_42,axiom,
    ~ addressVal(b1010_address_term,bitIndex4) ).

fof(is_address_147,axiom,
    address(b1010_address_term) ).

fof(constant_address_definition_84,axiom,
    ! [B] :
      ( addressVal(b1010_address_term,B)
    <=> b1010(B) ) ).

fof(address_false_msb_41,axiom,
    ~ addressVal(b1001_address_term,bitIndex4) ).

fof(is_address_146,axiom,
    address(b1001_address_term) ).

fof(constant_address_definition_83,axiom,
    ! [B] :
      ( addressVal(b1001_address_term,B)
    <=> b1001(B) ) ).

fof(address_false_msb_40,axiom,
    ~ addressVal(b1000_address_term,bitIndex4) ).

fof(is_address_145,axiom,
    address(b1000_address_term) ).

fof(constant_address_definition_82,axiom,
    ! [B] :
      ( addressVal(b1000_address_term,B)
    <=> b1000(B) ) ).

fof(address_false_msb_39,axiom,
    ~ addressVal(b0111_address_term,bitIndex4) ).

fof(is_address_144,axiom,
    address(b0111_address_term) ).

fof(constant_address_definition_81,axiom,
    ! [B] :
      ( addressVal(b0111_address_term,B)
    <=> b0111(B) ) ).

fof(address_false_msb_38,axiom,
    ~ addressVal(b0110_address_term,bitIndex4) ).

fof(is_address_143,axiom,
    address(b0110_address_term) ).

fof(constant_address_definition_80,axiom,
    ! [B] :
      ( addressVal(b0110_address_term,B)
    <=> b0110(B) ) ).

fof(address_false_msb_37,axiom,
    ~ addressVal(b0001_address_term,bitIndex4) ).

fof(is_address_142,axiom,
    address(b0001_address_term) ).

fof(constant_address_definition_79,axiom,
    ! [B] :
      ( addressVal(b0001_address_term,B)
    <=> b0001(B) ) ).

fof(address_false_msb_36,axiom,
    ~ addressVal(b1111_address_term,bitIndex4) ).

fof(is_address_141,axiom,
    address(b1111_address_term) ).

fof(constant_address_definition_78,axiom,
    ! [B] :
      ( addressVal(b1111_address_term,B)
    <=> b1111(B) ) ).

fof(address_false_msb_35,axiom,
    ~ addressVal(b1110_address_term,bitIndex4) ).

fof(is_address_140,axiom,
    address(b1110_address_term) ).

fof(constant_address_definition_77,axiom,
    ! [B] :
      ( addressVal(b1110_address_term,B)
    <=> b1110(B) ) ).

fof(address_false_msb_34,axiom,
    ~ addressVal(b1101_address_term,bitIndex4) ).

fof(is_address_139,axiom,
    address(b1101_address_term) ).

fof(constant_address_definition_76,axiom,
    ! [B] :
      ( addressVal(b1101_address_term,B)
    <=> b1101(B) ) ).

fof(address_false_msb_33,axiom,
    ~ addressVal(b1100_address_term,bitIndex4) ).

fof(is_address_138,axiom,
    address(b1100_address_term) ).

fof(constant_address_definition_75,axiom,
    ! [B] :
      ( addressVal(b1100_address_term,B)
    <=> b1100(B) ) ).

fof(address_false_msb_32,axiom,
    ~ addressVal(b1011_address_term,bitIndex4) ).

fof(is_address_137,axiom,
    address(b1011_address_term) ).

fof(constant_address_definition_74,axiom,
    ! [B] :
      ( addressVal(b1011_address_term,B)
    <=> b1011(B) ) ).

fof(address_false_msb_31,axiom,
    ~ addressVal(b1010_address_term,bitIndex4) ).

fof(is_address_136,axiom,
    address(b1010_address_term) ).

fof(constant_address_definition_73,axiom,
    ! [B] :
      ( addressVal(b1010_address_term,B)
    <=> b1010(B) ) ).

fof(address_false_msb_30,axiom,
    ~ addressVal(b1001_address_term,bitIndex4) ).

fof(is_address_135,axiom,
    address(b1001_address_term) ).

fof(constant_address_definition_72,axiom,
    ! [B] :
      ( addressVal(b1001_address_term,B)
    <=> b1001(B) ) ).

fof(address_false_msb_29,axiom,
    ~ addressVal(b1000_address_term,bitIndex4) ).

fof(is_address_134,axiom,
    address(b1000_address_term) ).

fof(constant_address_definition_71,axiom,
    ! [B] :
      ( addressVal(b1000_address_term,B)
    <=> b1000(B) ) ).

fof(address_false_msb_28,axiom,
    ~ addressVal(b0111_address_term,bitIndex4) ).

fof(is_address_133,axiom,
    address(b0111_address_term) ).

fof(constant_address_definition_70,axiom,
    ! [B] :
      ( addressVal(b0111_address_term,B)
    <=> b0111(B) ) ).

fof(address_false_msb_27,axiom,
    ~ addressVal(b0110_address_term,bitIndex4) ).

fof(is_address_132,axiom,
    address(b0110_address_term) ).

fof(constant_address_definition_69,axiom,
    ! [B] :
      ( addressVal(b0110_address_term,B)
    <=> b0110(B) ) ).

fof(address_false_msb_26,axiom,
    ~ addressVal(b0001_address_term,bitIndex4) ).

fof(is_address_131,axiom,
    address(b0001_address_term) ).

fof(constant_address_definition_68,axiom,
    ! [B] :
      ( addressVal(b0001_address_term,B)
    <=> b0001(B) ) ).

fof(address_false_msb_25,axiom,
    ~ addressVal(b0100_address_term,bitIndex4) ).

fof(is_address_130,axiom,
    address(b0100_address_term) ).

fof(constant_address_definition_67,axiom,
    ! [B] :
      ( addressVal(b0100_address_term,B)
    <=> b0100(B) ) ).

fof(address_false_msb_24,axiom,
    ~ addressVal(b0010_address_term,bitIndex4) ).

fof(is_address_129,axiom,
    address(b0010_address_term) ).

fof(constant_address_definition_66,axiom,
    ! [B] :
      ( addressVal(b0010_address_term,B)
    <=> b0010(B) ) ).

fof(address_false_msb_23,axiom,
    ~ addressVal(v1834_range_3_to_0_address_term_bound_20,bitIndex4) ).

fof(transient_address_definition_62,axiom,
    ( $true
    & ( addressVal(v1834_range_3_to_0_address_term_bound_20,bitIndex0)
    <=> v1834(constB20,bitIndex0) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_20,bitIndex1)
    <=> v1834(constB20,bitIndex1) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_20,bitIndex2)
    <=> v1834(constB20,bitIndex2) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_20,bitIndex3)
    <=> v1834(constB20,bitIndex3) ) ) ).

fof(is_address_128,axiom,
    address(v1834_range_3_to_0_address_term_bound_20) ).

fof(address_association_62,axiom,
    v1834_range_3_to_0_address_association(constB20,v1834_range_3_to_0_address_term_bound_20) ).

fof(address_false_msb_22,axiom,
    ~ addressVal(v1834_range_3_to_0_address_term_bound_19,bitIndex4) ).

fof(transient_address_definition_61,axiom,
    ( $true
    & ( addressVal(v1834_range_3_to_0_address_term_bound_19,bitIndex0)
    <=> v1834(constB19,bitIndex0) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_19,bitIndex1)
    <=> v1834(constB19,bitIndex1) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_19,bitIndex2)
    <=> v1834(constB19,bitIndex2) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_19,bitIndex3)
    <=> v1834(constB19,bitIndex3) ) ) ).

fof(is_address_127,axiom,
    address(v1834_range_3_to_0_address_term_bound_19) ).

fof(address_association_61,axiom,
    v1834_range_3_to_0_address_association(constB19,v1834_range_3_to_0_address_term_bound_19) ).

fof(address_false_msb_21,axiom,
    ~ addressVal(v1834_range_3_to_0_address_term_bound_18,bitIndex4) ).

fof(transient_address_definition_60,axiom,
    ( $true
    & ( addressVal(v1834_range_3_to_0_address_term_bound_18,bitIndex0)
    <=> v1834(constB18,bitIndex0) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_18,bitIndex1)
    <=> v1834(constB18,bitIndex1) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_18,bitIndex2)
    <=> v1834(constB18,bitIndex2) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_18,bitIndex3)
    <=> v1834(constB18,bitIndex3) ) ) ).

fof(is_address_126,axiom,
    address(v1834_range_3_to_0_address_term_bound_18) ).

fof(address_association_60,axiom,
    v1834_range_3_to_0_address_association(constB18,v1834_range_3_to_0_address_term_bound_18) ).

fof(address_false_msb_20,axiom,
    ~ addressVal(v1834_range_3_to_0_address_term_bound_17,bitIndex4) ).

fof(transient_address_definition_59,axiom,
    ( $true
    & ( addressVal(v1834_range_3_to_0_address_term_bound_17,bitIndex0)
    <=> v1834(constB17,bitIndex0) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_17,bitIndex1)
    <=> v1834(constB17,bitIndex1) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_17,bitIndex2)
    <=> v1834(constB17,bitIndex2) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_17,bitIndex3)
    <=> v1834(constB17,bitIndex3) ) ) ).

fof(is_address_125,axiom,
    address(v1834_range_3_to_0_address_term_bound_17) ).

fof(address_association_59,axiom,
    v1834_range_3_to_0_address_association(constB17,v1834_range_3_to_0_address_term_bound_17) ).

fof(address_false_msb_19,axiom,
    ~ addressVal(v1834_range_3_to_0_address_term_bound_16,bitIndex4) ).

fof(transient_address_definition_58,axiom,
    ( $true
    & ( addressVal(v1834_range_3_to_0_address_term_bound_16,bitIndex0)
    <=> v1834(constB16,bitIndex0) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_16,bitIndex1)
    <=> v1834(constB16,bitIndex1) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_16,bitIndex2)
    <=> v1834(constB16,bitIndex2) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_16,bitIndex3)
    <=> v1834(constB16,bitIndex3) ) ) ).

fof(is_address_124,axiom,
    address(v1834_range_3_to_0_address_term_bound_16) ).

fof(address_association_58,axiom,
    v1834_range_3_to_0_address_association(constB16,v1834_range_3_to_0_address_term_bound_16) ).

fof(address_false_msb_18,axiom,
    ~ addressVal(v1834_range_3_to_0_address_term_bound_15,bitIndex4) ).

fof(transient_address_definition_57,axiom,
    ( $true
    & ( addressVal(v1834_range_3_to_0_address_term_bound_15,bitIndex0)
    <=> v1834(constB15,bitIndex0) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_15,bitIndex1)
    <=> v1834(constB15,bitIndex1) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_15,bitIndex2)
    <=> v1834(constB15,bitIndex2) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_15,bitIndex3)
    <=> v1834(constB15,bitIndex3) ) ) ).

fof(is_address_123,axiom,
    address(v1834_range_3_to_0_address_term_bound_15) ).

fof(address_association_57,axiom,
    v1834_range_3_to_0_address_association(constB15,v1834_range_3_to_0_address_term_bound_15) ).

fof(address_false_msb_17,axiom,
    ~ addressVal(v1834_range_3_to_0_address_term_bound_14,bitIndex4) ).

fof(transient_address_definition_56,axiom,
    ( $true
    & ( addressVal(v1834_range_3_to_0_address_term_bound_14,bitIndex0)
    <=> v1834(constB14,bitIndex0) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_14,bitIndex1)
    <=> v1834(constB14,bitIndex1) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_14,bitIndex2)
    <=> v1834(constB14,bitIndex2) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_14,bitIndex3)
    <=> v1834(constB14,bitIndex3) ) ) ).

fof(is_address_122,axiom,
    address(v1834_range_3_to_0_address_term_bound_14) ).

fof(address_association_56,axiom,
    v1834_range_3_to_0_address_association(constB14,v1834_range_3_to_0_address_term_bound_14) ).

fof(address_false_msb_16,axiom,
    ~ addressVal(v1834_range_3_to_0_address_term_bound_13,bitIndex4) ).

fof(transient_address_definition_55,axiom,
    ( $true
    & ( addressVal(v1834_range_3_to_0_address_term_bound_13,bitIndex0)
    <=> v1834(constB13,bitIndex0) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_13,bitIndex1)
    <=> v1834(constB13,bitIndex1) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_13,bitIndex2)
    <=> v1834(constB13,bitIndex2) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_13,bitIndex3)
    <=> v1834(constB13,bitIndex3) ) ) ).

fof(is_address_121,axiom,
    address(v1834_range_3_to_0_address_term_bound_13) ).

fof(address_association_55,axiom,
    v1834_range_3_to_0_address_association(constB13,v1834_range_3_to_0_address_term_bound_13) ).

fof(address_false_msb_15,axiom,
    ~ addressVal(v1834_range_3_to_0_address_term_bound_12,bitIndex4) ).

fof(transient_address_definition_54,axiom,
    ( $true
    & ( addressVal(v1834_range_3_to_0_address_term_bound_12,bitIndex0)
    <=> v1834(constB12,bitIndex0) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_12,bitIndex1)
    <=> v1834(constB12,bitIndex1) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_12,bitIndex2)
    <=> v1834(constB12,bitIndex2) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_12,bitIndex3)
    <=> v1834(constB12,bitIndex3) ) ) ).

fof(is_address_120,axiom,
    address(v1834_range_3_to_0_address_term_bound_12) ).

fof(address_association_54,axiom,
    v1834_range_3_to_0_address_association(constB12,v1834_range_3_to_0_address_term_bound_12) ).

fof(address_false_msb_14,axiom,
    ~ addressVal(v1834_range_3_to_0_address_term_bound_11,bitIndex4) ).

fof(transient_address_definition_53,axiom,
    ( $true
    & ( addressVal(v1834_range_3_to_0_address_term_bound_11,bitIndex0)
    <=> v1834(constB11,bitIndex0) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_11,bitIndex1)
    <=> v1834(constB11,bitIndex1) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_11,bitIndex2)
    <=> v1834(constB11,bitIndex2) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_11,bitIndex3)
    <=> v1834(constB11,bitIndex3) ) ) ).

fof(is_address_119,axiom,
    address(v1834_range_3_to_0_address_term_bound_11) ).

fof(address_association_53,axiom,
    v1834_range_3_to_0_address_association(constB11,v1834_range_3_to_0_address_term_bound_11) ).

fof(address_false_msb_13,axiom,
    ~ addressVal(v1834_range_3_to_0_address_term_bound_10,bitIndex4) ).

fof(transient_address_definition_52,axiom,
    ( $true
    & ( addressVal(v1834_range_3_to_0_address_term_bound_10,bitIndex0)
    <=> v1834(constB10,bitIndex0) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_10,bitIndex1)
    <=> v1834(constB10,bitIndex1) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_10,bitIndex2)
    <=> v1834(constB10,bitIndex2) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_10,bitIndex3)
    <=> v1834(constB10,bitIndex3) ) ) ).

fof(is_address_118,axiom,
    address(v1834_range_3_to_0_address_term_bound_10) ).

fof(address_association_52,axiom,
    v1834_range_3_to_0_address_association(constB10,v1834_range_3_to_0_address_term_bound_10) ).

fof(address_false_msb_12,axiom,
    ~ addressVal(v1834_range_3_to_0_address_term_bound_9,bitIndex4) ).

fof(transient_address_definition_51,axiom,
    ( $true
    & ( addressVal(v1834_range_3_to_0_address_term_bound_9,bitIndex0)
    <=> v1834(constB9,bitIndex0) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_9,bitIndex1)
    <=> v1834(constB9,bitIndex1) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_9,bitIndex2)
    <=> v1834(constB9,bitIndex2) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_9,bitIndex3)
    <=> v1834(constB9,bitIndex3) ) ) ).

fof(is_address_117,axiom,
    address(v1834_range_3_to_0_address_term_bound_9) ).

fof(address_association_51,axiom,
    v1834_range_3_to_0_address_association(constB9,v1834_range_3_to_0_address_term_bound_9) ).

fof(address_false_msb_11,axiom,
    ~ addressVal(v1834_range_3_to_0_address_term_bound_8,bitIndex4) ).

fof(transient_address_definition_50,axiom,
    ( $true
    & ( addressVal(v1834_range_3_to_0_address_term_bound_8,bitIndex0)
    <=> v1834(constB8,bitIndex0) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_8,bitIndex1)
    <=> v1834(constB8,bitIndex1) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_8,bitIndex2)
    <=> v1834(constB8,bitIndex2) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_8,bitIndex3)
    <=> v1834(constB8,bitIndex3) ) ) ).

fof(is_address_116,axiom,
    address(v1834_range_3_to_0_address_term_bound_8) ).

fof(address_association_50,axiom,
    v1834_range_3_to_0_address_association(constB8,v1834_range_3_to_0_address_term_bound_8) ).

fof(address_false_msb_10,axiom,
    ~ addressVal(v1834_range_3_to_0_address_term_bound_7,bitIndex4) ).

fof(transient_address_definition_49,axiom,
    ( $true
    & ( addressVal(v1834_range_3_to_0_address_term_bound_7,bitIndex0)
    <=> v1834(constB7,bitIndex0) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_7,bitIndex1)
    <=> v1834(constB7,bitIndex1) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_7,bitIndex2)
    <=> v1834(constB7,bitIndex2) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_7,bitIndex3)
    <=> v1834(constB7,bitIndex3) ) ) ).

fof(is_address_115,axiom,
    address(v1834_range_3_to_0_address_term_bound_7) ).

fof(address_association_49,axiom,
    v1834_range_3_to_0_address_association(constB7,v1834_range_3_to_0_address_term_bound_7) ).

fof(address_false_msb_9,axiom,
    ~ addressVal(v1834_range_3_to_0_address_term_bound_6,bitIndex4) ).

fof(transient_address_definition_48,axiom,
    ( $true
    & ( addressVal(v1834_range_3_to_0_address_term_bound_6,bitIndex0)
    <=> v1834(constB6,bitIndex0) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_6,bitIndex1)
    <=> v1834(constB6,bitIndex1) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_6,bitIndex2)
    <=> v1834(constB6,bitIndex2) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_6,bitIndex3)
    <=> v1834(constB6,bitIndex3) ) ) ).

fof(is_address_114,axiom,
    address(v1834_range_3_to_0_address_term_bound_6) ).

fof(address_association_48,axiom,
    v1834_range_3_to_0_address_association(constB6,v1834_range_3_to_0_address_term_bound_6) ).

fof(address_false_msb_8,axiom,
    ~ addressVal(v1834_range_3_to_0_address_term_bound_5,bitIndex4) ).

fof(transient_address_definition_47,axiom,
    ( $true
    & ( addressVal(v1834_range_3_to_0_address_term_bound_5,bitIndex0)
    <=> v1834(constB5,bitIndex0) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_5,bitIndex1)
    <=> v1834(constB5,bitIndex1) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_5,bitIndex2)
    <=> v1834(constB5,bitIndex2) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_5,bitIndex3)
    <=> v1834(constB5,bitIndex3) ) ) ).

fof(is_address_113,axiom,
    address(v1834_range_3_to_0_address_term_bound_5) ).

fof(address_association_47,axiom,
    v1834_range_3_to_0_address_association(constB5,v1834_range_3_to_0_address_term_bound_5) ).

fof(address_false_msb_7,axiom,
    ~ addressVal(v1834_range_3_to_0_address_term_bound_4,bitIndex4) ).

fof(transient_address_definition_46,axiom,
    ( $true
    & ( addressVal(v1834_range_3_to_0_address_term_bound_4,bitIndex0)
    <=> v1834(constB4,bitIndex0) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_4,bitIndex1)
    <=> v1834(constB4,bitIndex1) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_4,bitIndex2)
    <=> v1834(constB4,bitIndex2) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_4,bitIndex3)
    <=> v1834(constB4,bitIndex3) ) ) ).

fof(is_address_112,axiom,
    address(v1834_range_3_to_0_address_term_bound_4) ).

fof(address_association_46,axiom,
    v1834_range_3_to_0_address_association(constB4,v1834_range_3_to_0_address_term_bound_4) ).

fof(address_false_msb_6,axiom,
    ~ addressVal(v1834_range_3_to_0_address_term_bound_3,bitIndex4) ).

fof(transient_address_definition_45,axiom,
    ( $true
    & ( addressVal(v1834_range_3_to_0_address_term_bound_3,bitIndex0)
    <=> v1834(constB3,bitIndex0) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_3,bitIndex1)
    <=> v1834(constB3,bitIndex1) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_3,bitIndex2)
    <=> v1834(constB3,bitIndex2) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_3,bitIndex3)
    <=> v1834(constB3,bitIndex3) ) ) ).

fof(is_address_111,axiom,
    address(v1834_range_3_to_0_address_term_bound_3) ).

fof(address_association_45,axiom,
    v1834_range_3_to_0_address_association(constB3,v1834_range_3_to_0_address_term_bound_3) ).

fof(address_false_msb_5,axiom,
    ~ addressVal(v1834_range_3_to_0_address_term_bound_2,bitIndex4) ).

fof(transient_address_definition_44,axiom,
    ( $true
    & ( addressVal(v1834_range_3_to_0_address_term_bound_2,bitIndex0)
    <=> v1834(constB2,bitIndex0) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_2,bitIndex1)
    <=> v1834(constB2,bitIndex1) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_2,bitIndex2)
    <=> v1834(constB2,bitIndex2) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_2,bitIndex3)
    <=> v1834(constB2,bitIndex3) ) ) ).

fof(is_address_110,axiom,
    address(v1834_range_3_to_0_address_term_bound_2) ).

fof(address_association_44,axiom,
    v1834_range_3_to_0_address_association(constB2,v1834_range_3_to_0_address_term_bound_2) ).

fof(address_false_msb_4,axiom,
    ~ addressVal(v1834_range_3_to_0_address_term_bound_1,bitIndex4) ).

fof(transient_address_definition_43,axiom,
    ( $true
    & ( addressVal(v1834_range_3_to_0_address_term_bound_1,bitIndex0)
    <=> v1834(constB1,bitIndex0) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_1,bitIndex1)
    <=> v1834(constB1,bitIndex1) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_1,bitIndex2)
    <=> v1834(constB1,bitIndex2) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_1,bitIndex3)
    <=> v1834(constB1,bitIndex3) ) ) ).

fof(is_address_109,axiom,
    address(v1834_range_3_to_0_address_term_bound_1) ).

fof(address_association_43,axiom,
    v1834_range_3_to_0_address_association(constB1,v1834_range_3_to_0_address_term_bound_1) ).

fof(address_false_msb_3,axiom,
    ~ addressVal(v1834_range_3_to_0_address_term_bound_0,bitIndex4) ).

fof(transient_address_definition_42,axiom,
    ( $true
    & ( addressVal(v1834_range_3_to_0_address_term_bound_0,bitIndex0)
    <=> v1834(constB0,bitIndex0) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_0,bitIndex1)
    <=> v1834(constB0,bitIndex1) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_0,bitIndex2)
    <=> v1834(constB0,bitIndex2) )
    & ( addressVal(v1834_range_3_to_0_address_term_bound_0,bitIndex3)
    <=> v1834(constB0,bitIndex3) ) ) ).

fof(is_address_108,axiom,
    address(v1834_range_3_to_0_address_term_bound_0) ).

fof(address_association_42,axiom,
    v1834_range_3_to_0_address_association(constB0,v1834_range_3_to_0_address_term_bound_0) ).

fof(is_address_107,axiom,
    address(b11111_address_term) ).

fof(constant_address_definition_65,axiom,
    ! [B] :
      ( addressVal(b11111_address_term,B)
    <=> b11111(B) ) ).

fof(is_address_106,axiom,
    address(b11110_address_term) ).

fof(constant_address_definition_64,axiom,
    ! [B] :
      ( addressVal(b11110_address_term,B)
    <=> b11110(B) ) ).

fof(is_address_105,axiom,
    address(b11101_address_term) ).

fof(constant_address_definition_63,axiom,
    ! [B] :
      ( addressVal(b11101_address_term,B)
    <=> b11101(B) ) ).

fof(is_address_104,axiom,
    address(b11100_address_term) ).

fof(constant_address_definition_62,axiom,
    ! [B] :
      ( addressVal(b11100_address_term,B)
    <=> b11100(B) ) ).

fof(is_address_103,axiom,
    address(b11011_address_term) ).

fof(constant_address_definition_61,axiom,
    ! [B] :
      ( addressVal(b11011_address_term,B)
    <=> b11011(B) ) ).

fof(is_address_102,axiom,
    address(b11010_address_term) ).

fof(constant_address_definition_60,axiom,
    ! [B] :
      ( addressVal(b11010_address_term,B)
    <=> b11010(B) ) ).

fof(is_address_101,axiom,
    address(b11001_address_term) ).

fof(constant_address_definition_59,axiom,
    ! [B] :
      ( addressVal(b11001_address_term,B)
    <=> b11001(B) ) ).

fof(is_address_100,axiom,
    address(b11000_address_term) ).

fof(constant_address_definition_58,axiom,
    ! [B] :
      ( addressVal(b11000_address_term,B)
    <=> b11000(B) ) ).

fof(is_address_99,axiom,
    address(b10111_address_term) ).

fof(constant_address_definition_57,axiom,
    ! [B] :
      ( addressVal(b10111_address_term,B)
    <=> b10111(B) ) ).

fof(is_address_98,axiom,
    address(b10110_address_term) ).

fof(constant_address_definition_56,axiom,
    ! [B] :
      ( addressVal(b10110_address_term,B)
    <=> b10110(B) ) ).

fof(is_address_97,axiom,
    address(b10101_address_term) ).

fof(constant_address_definition_55,axiom,
    ! [B] :
      ( addressVal(b10101_address_term,B)
    <=> b10101(B) ) ).

fof(is_address_96,axiom,
    address(b10100_address_term) ).

fof(constant_address_definition_54,axiom,
    ! [B] :
      ( addressVal(b10100_address_term,B)
    <=> b10100(B) ) ).

fof(is_address_95,axiom,
    address(b10011_address_term) ).

fof(constant_address_definition_53,axiom,
    ! [B] :
      ( addressVal(b10011_address_term,B)
    <=> b10011(B) ) ).

fof(is_address_94,axiom,
    address(b10010_address_term) ).

fof(constant_address_definition_52,axiom,
    ! [B] :
      ( addressVal(b10010_address_term,B)
    <=> b10010(B) ) ).

fof(is_address_93,axiom,
    address(b10001_address_term) ).

fof(constant_address_definition_51,axiom,
    ! [B] :
      ( addressVal(b10001_address_term,B)
    <=> b10001(B) ) ).

fof(is_address_92,axiom,
    address(b10000_address_term) ).

fof(constant_address_definition_50,axiom,
    ! [B] :
      ( addressVal(b10000_address_term,B)
    <=> b10000(B) ) ).

fof(is_address_91,axiom,
    address(b01111_address_term) ).

fof(constant_address_definition_49,axiom,
    ! [B] :
      ( addressVal(b01111_address_term,B)
    <=> b01111(B) ) ).

fof(is_address_90,axiom,
    address(b01110_address_term) ).

fof(constant_address_definition_48,axiom,
    ! [B] :
      ( addressVal(b01110_address_term,B)
    <=> b01110(B) ) ).

fof(is_address_89,axiom,
    address(b01101_address_term) ).

fof(constant_address_definition_47,axiom,
    ! [B] :
      ( addressVal(b01101_address_term,B)
    <=> b01101(B) ) ).

fof(is_address_88,axiom,
    address(b01100_address_term) ).

fof(constant_address_definition_46,axiom,
    ! [B] :
      ( addressVal(b01100_address_term,B)
    <=> b01100(B) ) ).

fof(is_address_87,axiom,
    address(b01011_address_term) ).

fof(constant_address_definition_45,axiom,
    ! [B] :
      ( addressVal(b01011_address_term,B)
    <=> b01011(B) ) ).

fof(is_address_86,axiom,
    address(b01010_address_term) ).

fof(constant_address_definition_44,axiom,
    ! [B] :
      ( addressVal(b01010_address_term,B)
    <=> b01010(B) ) ).

fof(is_address_85,axiom,
    address(b01001_address_term) ).

fof(constant_address_definition_43,axiom,
    ! [B] :
      ( addressVal(b01001_address_term,B)
    <=> b01001(B) ) ).

fof(is_address_84,axiom,
    address(b01000_address_term) ).

fof(constant_address_definition_42,axiom,
    ! [B] :
      ( addressVal(b01000_address_term,B)
    <=> b01000(B) ) ).

fof(is_address_83,axiom,
    address(b00111_address_term) ).

fof(constant_address_definition_41,axiom,
    ! [B] :
      ( addressVal(b00111_address_term,B)
    <=> b00111(B) ) ).

fof(is_address_82,axiom,
    address(b00110_address_term) ).

fof(constant_address_definition_40,axiom,
    ! [B] :
      ( addressVal(b00110_address_term,B)
    <=> b00110(B) ) ).

fof(is_address_81,axiom,
    address(b00101_address_term) ).

fof(constant_address_definition_39,axiom,
    ! [B] :
      ( addressVal(b00101_address_term,B)
    <=> b00101(B) ) ).

fof(is_address_80,axiom,
    address(b00100_address_term) ).

fof(constant_address_definition_38,axiom,
    ! [B] :
      ( addressVal(b00100_address_term,B)
    <=> b00100(B) ) ).

fof(is_address_79,axiom,
    address(b00011_address_term) ).

fof(constant_address_definition_37,axiom,
    ! [B] :
      ( addressVal(b00011_address_term,B)
    <=> b00011(B) ) ).

fof(is_address_78,axiom,
    address(b00010_address_term) ).

fof(constant_address_definition_36,axiom,
    ! [B] :
      ( addressVal(b00010_address_term,B)
    <=> b00010(B) ) ).

fof(is_address_77,axiom,
    address(b00001_address_term) ).

fof(constant_address_definition_35,axiom,
    ! [B] :
      ( addressVal(b00001_address_term,B)
    <=> b00001(B) ) ).

fof(is_address_76,axiom,
    address(b11111_address_term) ).

fof(constant_address_definition_34,axiom,
    ! [B] :
      ( addressVal(b11111_address_term,B)
    <=> b11111(B) ) ).

fof(is_address_75,axiom,
    address(b11110_address_term) ).

fof(constant_address_definition_33,axiom,
    ! [B] :
      ( addressVal(b11110_address_term,B)
    <=> b11110(B) ) ).

fof(is_address_74,axiom,
    address(b11101_address_term) ).

fof(constant_address_definition_32,axiom,
    ! [B] :
      ( addressVal(b11101_address_term,B)
    <=> b11101(B) ) ).

fof(is_address_73,axiom,
    address(b11100_address_term) ).

fof(constant_address_definition_31,axiom,
    ! [B] :
      ( addressVal(b11100_address_term,B)
    <=> b11100(B) ) ).

fof(is_address_72,axiom,
    address(b11011_address_term) ).

fof(constant_address_definition_30,axiom,
    ! [B] :
      ( addressVal(b11011_address_term,B)
    <=> b11011(B) ) ).

fof(is_address_71,axiom,
    address(b11010_address_term) ).

fof(constant_address_definition_29,axiom,
    ! [B] :
      ( addressVal(b11010_address_term,B)
    <=> b11010(B) ) ).

fof(is_address_70,axiom,
    address(b11001_address_term) ).

fof(constant_address_definition_28,axiom,
    ! [B] :
      ( addressVal(b11001_address_term,B)
    <=> b11001(B) ) ).

fof(is_address_69,axiom,
    address(b11000_address_term) ).

fof(constant_address_definition_27,axiom,
    ! [B] :
      ( addressVal(b11000_address_term,B)
    <=> b11000(B) ) ).

fof(is_address_68,axiom,
    address(b10111_address_term) ).

fof(constant_address_definition_26,axiom,
    ! [B] :
      ( addressVal(b10111_address_term,B)
    <=> b10111(B) ) ).

fof(is_address_67,axiom,
    address(b10110_address_term) ).

fof(constant_address_definition_25,axiom,
    ! [B] :
      ( addressVal(b10110_address_term,B)
    <=> b10110(B) ) ).

fof(is_address_66,axiom,
    address(b10101_address_term) ).

fof(constant_address_definition_24,axiom,
    ! [B] :
      ( addressVal(b10101_address_term,B)
    <=> b10101(B) ) ).

fof(is_address_65,axiom,
    address(b10100_address_term) ).

fof(constant_address_definition_23,axiom,
    ! [B] :
      ( addressVal(b10100_address_term,B)
    <=> b10100(B) ) ).

fof(is_address_64,axiom,
    address(b10011_address_term) ).

fof(constant_address_definition_22,axiom,
    ! [B] :
      ( addressVal(b10011_address_term,B)
    <=> b10011(B) ) ).

fof(is_address_63,axiom,
    address(b10010_address_term) ).

fof(constant_address_definition_21,axiom,
    ! [B] :
      ( addressVal(b10010_address_term,B)
    <=> b10010(B) ) ).

fof(is_address_62,axiom,
    address(b10001_address_term) ).

fof(constant_address_definition_20,axiom,
    ! [B] :
      ( addressVal(b10001_address_term,B)
    <=> b10001(B) ) ).

fof(is_address_61,axiom,
    address(b10000_address_term) ).

fof(constant_address_definition_19,axiom,
    ! [B] :
      ( addressVal(b10000_address_term,B)
    <=> b10000(B) ) ).

fof(is_address_60,axiom,
    address(b01111_address_term) ).

fof(constant_address_definition_18,axiom,
    ! [B] :
      ( addressVal(b01111_address_term,B)
    <=> b01111(B) ) ).

fof(is_address_59,axiom,
    address(b01110_address_term) ).

fof(constant_address_definition_17,axiom,
    ! [B] :
      ( addressVal(b01110_address_term,B)
    <=> b01110(B) ) ).

fof(is_address_58,axiom,
    address(b01101_address_term) ).

fof(constant_address_definition_16,axiom,
    ! [B] :
      ( addressVal(b01101_address_term,B)
    <=> b01101(B) ) ).

fof(is_address_57,axiom,
    address(b01100_address_term) ).

fof(constant_address_definition_15,axiom,
    ! [B] :
      ( addressVal(b01100_address_term,B)
    <=> b01100(B) ) ).

fof(is_address_56,axiom,
    address(b01011_address_term) ).

fof(constant_address_definition_14,axiom,
    ! [B] :
      ( addressVal(b01011_address_term,B)
    <=> b01011(B) ) ).

fof(is_address_55,axiom,
    address(b01010_address_term) ).

fof(constant_address_definition_13,axiom,
    ! [B] :
      ( addressVal(b01010_address_term,B)
    <=> b01010(B) ) ).

fof(is_address_54,axiom,
    address(b01001_address_term) ).

fof(constant_address_definition_12,axiom,
    ! [B] :
      ( addressVal(b01001_address_term,B)
    <=> b01001(B) ) ).

fof(is_address_53,axiom,
    address(b01000_address_term) ).

fof(constant_address_definition_11,axiom,
    ! [B] :
      ( addressVal(b01000_address_term,B)
    <=> b01000(B) ) ).

fof(is_address_52,axiom,
    address(b00111_address_term) ).

fof(constant_address_definition_10,axiom,
    ! [B] :
      ( addressVal(b00111_address_term,B)
    <=> b00111(B) ) ).

fof(is_address_51,axiom,
    address(b00110_address_term) ).

fof(constant_address_definition_9,axiom,
    ! [B] :
      ( addressVal(b00110_address_term,B)
    <=> b00110(B) ) ).

fof(is_address_50,axiom,
    address(b00101_address_term) ).

fof(constant_address_definition_8,axiom,
    ! [B] :
      ( addressVal(b00101_address_term,B)
    <=> b00101(B) ) ).

fof(is_address_49,axiom,
    address(b00100_address_term) ).

fof(constant_address_definition_7,axiom,
    ! [B] :
      ( addressVal(b00100_address_term,B)
    <=> b00100(B) ) ).

fof(is_address_48,axiom,
    address(b00011_address_term) ).

fof(constant_address_definition_6,axiom,
    ! [B] :
      ( addressVal(b00011_address_term,B)
    <=> b00011(B) ) ).

fof(is_address_47,axiom,
    address(b00010_address_term) ).

fof(constant_address_definition_5,axiom,
    ! [B] :
      ( addressVal(b00010_address_term,B)
    <=> b00010(B) ) ).

fof(is_address_46,axiom,
    address(b00001_address_term) ).

fof(constant_address_definition_4,axiom,
    ! [B] :
      ( addressVal(b00001_address_term,B)
    <=> b00001(B) ) ).

fof(transient_address_definition_41,axiom,
    ! [B] :
      ( addressVal(v1115_range_4_to_0_address_term_bound_20,B)
    <=> v1115(constB20,B) ) ).

fof(is_address_45,axiom,
    address(v1115_range_4_to_0_address_term_bound_20) ).

fof(address_association_41,axiom,
    v1115_range_4_to_0_address_association(constB20,v1115_range_4_to_0_address_term_bound_20) ).

fof(transient_address_definition_40,axiom,
    ! [B] :
      ( addressVal(v1115_range_4_to_0_address_term_bound_19,B)
    <=> v1115(constB19,B) ) ).

fof(is_address_44,axiom,
    address(v1115_range_4_to_0_address_term_bound_19) ).

fof(address_association_40,axiom,
    v1115_range_4_to_0_address_association(constB19,v1115_range_4_to_0_address_term_bound_19) ).

fof(transient_address_definition_39,axiom,
    ! [B] :
      ( addressVal(v1115_range_4_to_0_address_term_bound_18,B)
    <=> v1115(constB18,B) ) ).

fof(is_address_43,axiom,
    address(v1115_range_4_to_0_address_term_bound_18) ).

fof(address_association_39,axiom,
    v1115_range_4_to_0_address_association(constB18,v1115_range_4_to_0_address_term_bound_18) ).

fof(transient_address_definition_38,axiom,
    ! [B] :
      ( addressVal(v1115_range_4_to_0_address_term_bound_17,B)
    <=> v1115(constB17,B) ) ).

fof(is_address_42,axiom,
    address(v1115_range_4_to_0_address_term_bound_17) ).

fof(address_association_38,axiom,
    v1115_range_4_to_0_address_association(constB17,v1115_range_4_to_0_address_term_bound_17) ).

fof(transient_address_definition_37,axiom,
    ! [B] :
      ( addressVal(v1115_range_4_to_0_address_term_bound_16,B)
    <=> v1115(constB16,B) ) ).

fof(is_address_41,axiom,
    address(v1115_range_4_to_0_address_term_bound_16) ).

fof(address_association_37,axiom,
    v1115_range_4_to_0_address_association(constB16,v1115_range_4_to_0_address_term_bound_16) ).

fof(transient_address_definition_36,axiom,
    ! [B] :
      ( addressVal(v1115_range_4_to_0_address_term_bound_15,B)
    <=> v1115(constB15,B) ) ).

fof(is_address_40,axiom,
    address(v1115_range_4_to_0_address_term_bound_15) ).

fof(address_association_36,axiom,
    v1115_range_4_to_0_address_association(constB15,v1115_range_4_to_0_address_term_bound_15) ).

fof(transient_address_definition_35,axiom,
    ! [B] :
      ( addressVal(v1115_range_4_to_0_address_term_bound_14,B)
    <=> v1115(constB14,B) ) ).

fof(is_address_39,axiom,
    address(v1115_range_4_to_0_address_term_bound_14) ).

fof(address_association_35,axiom,
    v1115_range_4_to_0_address_association(constB14,v1115_range_4_to_0_address_term_bound_14) ).

fof(transient_address_definition_34,axiom,
    ! [B] :
      ( addressVal(v1115_range_4_to_0_address_term_bound_13,B)
    <=> v1115(constB13,B) ) ).

fof(is_address_38,axiom,
    address(v1115_range_4_to_0_address_term_bound_13) ).

fof(address_association_34,axiom,
    v1115_range_4_to_0_address_association(constB13,v1115_range_4_to_0_address_term_bound_13) ).

fof(transient_address_definition_33,axiom,
    ! [B] :
      ( addressVal(v1115_range_4_to_0_address_term_bound_12,B)
    <=> v1115(constB12,B) ) ).

fof(is_address_37,axiom,
    address(v1115_range_4_to_0_address_term_bound_12) ).

fof(address_association_33,axiom,
    v1115_range_4_to_0_address_association(constB12,v1115_range_4_to_0_address_term_bound_12) ).

fof(transient_address_definition_32,axiom,
    ! [B] :
      ( addressVal(v1115_range_4_to_0_address_term_bound_11,B)
    <=> v1115(constB11,B) ) ).

fof(is_address_36,axiom,
    address(v1115_range_4_to_0_address_term_bound_11) ).

fof(address_association_32,axiom,
    v1115_range_4_to_0_address_association(constB11,v1115_range_4_to_0_address_term_bound_11) ).

fof(transient_address_definition_31,axiom,
    ! [B] :
      ( addressVal(v1115_range_4_to_0_address_term_bound_10,B)
    <=> v1115(constB10,B) ) ).

fof(is_address_35,axiom,
    address(v1115_range_4_to_0_address_term_bound_10) ).

fof(address_association_31,axiom,
    v1115_range_4_to_0_address_association(constB10,v1115_range_4_to_0_address_term_bound_10) ).

fof(transient_address_definition_30,axiom,
    ! [B] :
      ( addressVal(v1115_range_4_to_0_address_term_bound_9,B)
    <=> v1115(constB9,B) ) ).

fof(is_address_34,axiom,
    address(v1115_range_4_to_0_address_term_bound_9) ).

fof(address_association_30,axiom,
    v1115_range_4_to_0_address_association(constB9,v1115_range_4_to_0_address_term_bound_9) ).

fof(transient_address_definition_29,axiom,
    ! [B] :
      ( addressVal(v1115_range_4_to_0_address_term_bound_8,B)
    <=> v1115(constB8,B) ) ).

fof(is_address_33,axiom,
    address(v1115_range_4_to_0_address_term_bound_8) ).

fof(address_association_29,axiom,
    v1115_range_4_to_0_address_association(constB8,v1115_range_4_to_0_address_term_bound_8) ).

fof(transient_address_definition_28,axiom,
    ! [B] :
      ( addressVal(v1115_range_4_to_0_address_term_bound_7,B)
    <=> v1115(constB7,B) ) ).

fof(is_address_32,axiom,
    address(v1115_range_4_to_0_address_term_bound_7) ).

fof(address_association_28,axiom,
    v1115_range_4_to_0_address_association(constB7,v1115_range_4_to_0_address_term_bound_7) ).

fof(transient_address_definition_27,axiom,
    ! [B] :
      ( addressVal(v1115_range_4_to_0_address_term_bound_6,B)
    <=> v1115(constB6,B) ) ).

fof(is_address_31,axiom,
    address(v1115_range_4_to_0_address_term_bound_6) ).

fof(address_association_27,axiom,
    v1115_range_4_to_0_address_association(constB6,v1115_range_4_to_0_address_term_bound_6) ).

fof(transient_address_definition_26,axiom,
    ! [B] :
      ( addressVal(v1115_range_4_to_0_address_term_bound_5,B)
    <=> v1115(constB5,B) ) ).

fof(is_address_30,axiom,
    address(v1115_range_4_to_0_address_term_bound_5) ).

fof(address_association_26,axiom,
    v1115_range_4_to_0_address_association(constB5,v1115_range_4_to_0_address_term_bound_5) ).

fof(transient_address_definition_25,axiom,
    ! [B] :
      ( addressVal(v1115_range_4_to_0_address_term_bound_4,B)
    <=> v1115(constB4,B) ) ).

fof(is_address_29,axiom,
    address(v1115_range_4_to_0_address_term_bound_4) ).

fof(address_association_25,axiom,
    v1115_range_4_to_0_address_association(constB4,v1115_range_4_to_0_address_term_bound_4) ).

fof(transient_address_definition_24,axiom,
    ! [B] :
      ( addressVal(v1115_range_4_to_0_address_term_bound_3,B)
    <=> v1115(constB3,B) ) ).

fof(is_address_28,axiom,
    address(v1115_range_4_to_0_address_term_bound_3) ).

fof(address_association_24,axiom,
    v1115_range_4_to_0_address_association(constB3,v1115_range_4_to_0_address_term_bound_3) ).

fof(transient_address_definition_23,axiom,
    ! [B] :
      ( addressVal(v1115_range_4_to_0_address_term_bound_2,B)
    <=> v1115(constB2,B) ) ).

fof(is_address_27,axiom,
    address(v1115_range_4_to_0_address_term_bound_2) ).

fof(address_association_23,axiom,
    v1115_range_4_to_0_address_association(constB2,v1115_range_4_to_0_address_term_bound_2) ).

fof(transient_address_definition_22,axiom,
    ! [B] :
      ( addressVal(v1115_range_4_to_0_address_term_bound_1,B)
    <=> v1115(constB1,B) ) ).

fof(is_address_26,axiom,
    address(v1115_range_4_to_0_address_term_bound_1) ).

fof(address_association_22,axiom,
    v1115_range_4_to_0_address_association(constB1,v1115_range_4_to_0_address_term_bound_1) ).

fof(transient_address_definition_21,axiom,
    ! [B] :
      ( addressVal(v1115_range_4_to_0_address_term_bound_0,B)
    <=> v1115(constB0,B) ) ).

fof(is_address_25,axiom,
    address(v1115_range_4_to_0_address_term_bound_0) ).

fof(address_association_21,axiom,
    v1115_range_4_to_0_address_association(constB0,v1115_range_4_to_0_address_term_bound_0) ).

fof(transient_address_definition_20,axiom,
    ! [B] :
      ( addressVal(v1097_range_4_to_0_address_term_bound_20,B)
    <=> v1097(constB20,B) ) ).

fof(is_address_24,axiom,
    address(v1097_range_4_to_0_address_term_bound_20) ).

fof(address_association_20,axiom,
    v1097_range_4_to_0_address_association(constB20,v1097_range_4_to_0_address_term_bound_20) ).

fof(transient_address_definition_19,axiom,
    ! [B] :
      ( addressVal(v1097_range_4_to_0_address_term_bound_19,B)
    <=> v1097(constB19,B) ) ).

fof(is_address_23,axiom,
    address(v1097_range_4_to_0_address_term_bound_19) ).

fof(address_association_19,axiom,
    v1097_range_4_to_0_address_association(constB19,v1097_range_4_to_0_address_term_bound_19) ).

fof(transient_address_definition_18,axiom,
    ! [B] :
      ( addressVal(v1097_range_4_to_0_address_term_bound_18,B)
    <=> v1097(constB18,B) ) ).

fof(is_address_22,axiom,
    address(v1097_range_4_to_0_address_term_bound_18) ).

fof(address_association_18,axiom,
    v1097_range_4_to_0_address_association(constB18,v1097_range_4_to_0_address_term_bound_18) ).

fof(transient_address_definition_17,axiom,
    ! [B] :
      ( addressVal(v1097_range_4_to_0_address_term_bound_17,B)
    <=> v1097(constB17,B) ) ).

fof(is_address_21,axiom,
    address(v1097_range_4_to_0_address_term_bound_17) ).

fof(address_association_17,axiom,
    v1097_range_4_to_0_address_association(constB17,v1097_range_4_to_0_address_term_bound_17) ).

fof(transient_address_definition_16,axiom,
    ! [B] :
      ( addressVal(v1097_range_4_to_0_address_term_bound_16,B)
    <=> v1097(constB16,B) ) ).

fof(is_address_20,axiom,
    address(v1097_range_4_to_0_address_term_bound_16) ).

fof(address_association_16,axiom,
    v1097_range_4_to_0_address_association(constB16,v1097_range_4_to_0_address_term_bound_16) ).

fof(transient_address_definition_15,axiom,
    ! [B] :
      ( addressVal(v1097_range_4_to_0_address_term_bound_15,B)
    <=> v1097(constB15,B) ) ).

fof(is_address_19,axiom,
    address(v1097_range_4_to_0_address_term_bound_15) ).

fof(address_association_15,axiom,
    v1097_range_4_to_0_address_association(constB15,v1097_range_4_to_0_address_term_bound_15) ).

fof(transient_address_definition_14,axiom,
    ! [B] :
      ( addressVal(v1097_range_4_to_0_address_term_bound_14,B)
    <=> v1097(constB14,B) ) ).

fof(is_address_18,axiom,
    address(v1097_range_4_to_0_address_term_bound_14) ).

fof(address_association_14,axiom,
    v1097_range_4_to_0_address_association(constB14,v1097_range_4_to_0_address_term_bound_14) ).

fof(transient_address_definition_13,axiom,
    ! [B] :
      ( addressVal(v1097_range_4_to_0_address_term_bound_13,B)
    <=> v1097(constB13,B) ) ).

fof(is_address_17,axiom,
    address(v1097_range_4_to_0_address_term_bound_13) ).

fof(address_association_13,axiom,
    v1097_range_4_to_0_address_association(constB13,v1097_range_4_to_0_address_term_bound_13) ).

fof(transient_address_definition_12,axiom,
    ! [B] :
      ( addressVal(v1097_range_4_to_0_address_term_bound_12,B)
    <=> v1097(constB12,B) ) ).

fof(is_address_16,axiom,
    address(v1097_range_4_to_0_address_term_bound_12) ).

fof(address_association_12,axiom,
    v1097_range_4_to_0_address_association(constB12,v1097_range_4_to_0_address_term_bound_12) ).

fof(transient_address_definition_11,axiom,
    ! [B] :
      ( addressVal(v1097_range_4_to_0_address_term_bound_11,B)
    <=> v1097(constB11,B) ) ).

fof(is_address_15,axiom,
    address(v1097_range_4_to_0_address_term_bound_11) ).

fof(address_association_11,axiom,
    v1097_range_4_to_0_address_association(constB11,v1097_range_4_to_0_address_term_bound_11) ).

fof(transient_address_definition_10,axiom,
    ! [B] :
      ( addressVal(v1097_range_4_to_0_address_term_bound_10,B)
    <=> v1097(constB10,B) ) ).

fof(is_address_14,axiom,
    address(v1097_range_4_to_0_address_term_bound_10) ).

fof(address_association_10,axiom,
    v1097_range_4_to_0_address_association(constB10,v1097_range_4_to_0_address_term_bound_10) ).

fof(transient_address_definition_9,axiom,
    ! [B] :
      ( addressVal(v1097_range_4_to_0_address_term_bound_9,B)
    <=> v1097(constB9,B) ) ).

fof(is_address_13,axiom,
    address(v1097_range_4_to_0_address_term_bound_9) ).

fof(address_association_9,axiom,
    v1097_range_4_to_0_address_association(constB9,v1097_range_4_to_0_address_term_bound_9) ).

fof(transient_address_definition_8,axiom,
    ! [B] :
      ( addressVal(v1097_range_4_to_0_address_term_bound_8,B)
    <=> v1097(constB8,B) ) ).

fof(is_address_12,axiom,
    address(v1097_range_4_to_0_address_term_bound_8) ).

fof(address_association_8,axiom,
    v1097_range_4_to_0_address_association(constB8,v1097_range_4_to_0_address_term_bound_8) ).

fof(transient_address_definition_7,axiom,
    ! [B] :
      ( addressVal(v1097_range_4_to_0_address_term_bound_7,B)
    <=> v1097(constB7,B) ) ).

fof(is_address_11,axiom,
    address(v1097_range_4_to_0_address_term_bound_7) ).

fof(address_association_7,axiom,
    v1097_range_4_to_0_address_association(constB7,v1097_range_4_to_0_address_term_bound_7) ).

fof(transient_address_definition_6,axiom,
    ! [B] :
      ( addressVal(v1097_range_4_to_0_address_term_bound_6,B)
    <=> v1097(constB6,B) ) ).

fof(is_address_10,axiom,
    address(v1097_range_4_to_0_address_term_bound_6) ).

fof(address_association_6,axiom,
    v1097_range_4_to_0_address_association(constB6,v1097_range_4_to_0_address_term_bound_6) ).

fof(transient_address_definition_5,axiom,
    ! [B] :
      ( addressVal(v1097_range_4_to_0_address_term_bound_5,B)
    <=> v1097(constB5,B) ) ).

fof(is_address_9,axiom,
    address(v1097_range_4_to_0_address_term_bound_5) ).

fof(address_association_5,axiom,
    v1097_range_4_to_0_address_association(constB5,v1097_range_4_to_0_address_term_bound_5) ).

fof(transient_address_definition_4,axiom,
    ! [B] :
      ( addressVal(v1097_range_4_to_0_address_term_bound_4,B)
    <=> v1097(constB4,B) ) ).

fof(is_address_8,axiom,
    address(v1097_range_4_to_0_address_term_bound_4) ).

fof(address_association_4,axiom,
    v1097_range_4_to_0_address_association(constB4,v1097_range_4_to_0_address_term_bound_4) ).

fof(transient_address_definition_3,axiom,
    ! [B] :
      ( addressVal(v1097_range_4_to_0_address_term_bound_3,B)
    <=> v1097(constB3,B) ) ).

fof(is_address_7,axiom,
    address(v1097_range_4_to_0_address_term_bound_3) ).

fof(address_association_3,axiom,
    v1097_range_4_to_0_address_association(constB3,v1097_range_4_to_0_address_term_bound_3) ).

fof(transient_address_definition_2,axiom,
    ! [B] :
      ( addressVal(v1097_range_4_to_0_address_term_bound_2,B)
    <=> v1097(constB2,B) ) ).

fof(is_address_6,axiom,
    address(v1097_range_4_to_0_address_term_bound_2) ).

fof(address_association_2,axiom,
    v1097_range_4_to_0_address_association(constB2,v1097_range_4_to_0_address_term_bound_2) ).

fof(transient_address_definition_1,axiom,
    ! [B] :
      ( addressVal(v1097_range_4_to_0_address_term_bound_1,B)
    <=> v1097(constB1,B) ) ).

fof(is_address_5,axiom,
    address(v1097_range_4_to_0_address_term_bound_1) ).

fof(address_association_1,axiom,
    v1097_range_4_to_0_address_association(constB1,v1097_range_4_to_0_address_term_bound_1) ).

fof(transient_address_definition,axiom,
    ! [B] :
      ( addressVal(v1097_range_4_to_0_address_term_bound_0,B)
    <=> v1097(constB0,B) ) ).

fof(is_address_4,axiom,
    address(v1097_range_4_to_0_address_term_bound_0) ).

fof(address_association,axiom,
    v1097_range_4_to_0_address_association(constB0,v1097_range_4_to_0_address_term_bound_0) ).

fof(is_address_3,axiom,
    address(b00000_address_term) ).

fof(constant_address_definition_3,axiom,
    ! [B] :
      ( addressVal(b00000_address_term,B)
    <=> b00000(B) ) ).

fof(address_false_msb_2,axiom,
    ~ addressVal(b0101_address_term,bitIndex4) ).

fof(is_address_2,axiom,
    address(b0101_address_term) ).

fof(constant_address_definition_2,axiom,
    ! [B] :
      ( addressVal(b0101_address_term,B)
    <=> b0101(B) ) ).

fof(address_false_msb_1,axiom,
    ~ addressVal(b0011_address_term,bitIndex4) ).

fof(is_address_1,axiom,
    address(b0011_address_term) ).

fof(constant_address_definition_1,axiom,
    ! [B] :
      ( addressVal(b0011_address_term,B)
    <=> b0011(B) ) ).

fof(address_false_msb,axiom,
    ~ addressVal(b0000_address_term,bitIndex4) ).

fof(is_address,axiom,
    address(b0000_address_term) ).

fof(constant_address_definition,axiom,
    ! [B] :
      ( addressVal(b0000_address_term,B)
    <=> b0000(B) ) ).

fof(addressDiff,axiom,
    ! [B,A2,A1] :
      ( ( address(A1)
        & address(A2)
        & addressDiff(A1,A2,B) )
     => ( A1 = A2
        | ( addressVal(A1,B)
        <=> ~ addressVal(A2,B) ) ) ) ).

fof(addressDomain,axiom,
    ! [A1,A2] :
      ( addressDiff(A1,A2,bitIndex0)
      | addressDiff(A1,A2,bitIndex1)
      | addressDiff(A1,A2,bitIndex2)
      | addressDiff(A1,A2,bitIndex3)
      | addressDiff(A1,A2,bitIndex4) ) ).

fof(addAssertion,conjecture,
    ! [VarCurr] :
      ( reachableState(VarCurr)
     => v4(VarCurr) ) ).

fof(writeUnaryOperator_250,axiom,
    ! [VarCurr] :
      ( ~ v4(VarCurr)
    <=> v3471(VarCurr) ) ).

fof(writeUnaryOperator_249,axiom,
    ! [VarCurr] :
      ( ~ v3471(VarCurr)
    <=> v3472(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_635,axiom,
    ! [VarCurr] :
      ( v3472(VarCurr)
    <=> ( v3474(VarCurr)
        & v3491(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_54,axiom,
    ! [VarCurr] :
      ( v3491(VarCurr)
    <=> ( v3492(VarCurr)
        | v6(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_53,axiom,
    ! [VarCurr] :
      ( v3492(VarCurr)
    <=> ( v3493(VarCurr)
        | v6(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_52,axiom,
    ! [VarCurr] :
      ( v3493(VarCurr)
    <=> ( v6(VarCurr,bitIndex0)
        | v6(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_634,axiom,
    ! [VarCurr] :
      ( v3474(VarCurr)
    <=> ( v3475(VarCurr)
        | v3482(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_633,axiom,
    ! [VarCurr] :
      ( v3482(VarCurr)
    <=> ( v3483(VarCurr)
        | v3484(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_632,axiom,
    ! [VarCurr] :
      ( v3484(VarCurr)
    <=> ( v3476(VarCurr)
        & v3485(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_631,axiom,
    ! [VarCurr] :
      ( v3485(VarCurr)
    <=> ( v3486(VarCurr)
        | v3487(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_630,axiom,
    ! [VarCurr] :
      ( v3487(VarCurr)
    <=> ( v3478(VarCurr)
        & v3488(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_629,axiom,
    ! [VarCurr] :
      ( v3488(VarCurr)
    <=> ( v3489(VarCurr)
        | v3490(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_628,axiom,
    ! [VarCurr] :
      ( v3490(VarCurr)
    <=> ( v6(VarCurr,bitIndex0)
        & v3481(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_51,axiom,
    ! [VarCurr] :
      ( v3489(VarCurr)
    <=> ( v3480(VarCurr)
        & v6(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_50,axiom,
    ! [VarCurr] :
      ( v3486(VarCurr)
    <=> ( v6(VarCurr,bitIndex2)
        & v3479(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_49,axiom,
    ! [VarCurr] :
      ( v3483(VarCurr)
    <=> ( v6(VarCurr,bitIndex3)
        & v3477(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_627,axiom,
    ! [VarCurr] :
      ( v3475(VarCurr)
    <=> ( v3476(VarCurr)
        & v3477(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_626,axiom,
    ! [VarCurr] :
      ( v3477(VarCurr)
    <=> ( v3478(VarCurr)
        & v3479(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_625,axiom,
    ! [VarCurr] :
      ( v3479(VarCurr)
    <=> ( v3480(VarCurr)
        & v3481(VarCurr) ) ) ).

fof(writeUnaryOperator_248,axiom,
    ! [VarCurr] :
      ( ~ v3481(VarCurr)
    <=> v6(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_247,axiom,
    ! [VarCurr] :
      ( ~ v3480(VarCurr)
    <=> v6(VarCurr,bitIndex0) ) ).

fof(writeUnaryOperator_246,axiom,
    ! [VarCurr] :
      ( ~ v3478(VarCurr)
    <=> v6(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_245,axiom,
    ! [VarCurr] :
      ( ~ v3476(VarCurr)
    <=> v6(VarCurr,bitIndex3) ) ).

fof(addCaseBooleanConditionEqualRanges1_47,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3459(VarNext)
       => ! [B] :
            ( range_3_1(B)
           => ( v6(VarNext,B)
            <=> v6(VarCurr,B) ) ) ) ) ).

fof(range_axiom_20,axiom,
    ! [B] :
      ( range_3_1(B)
    <=> ( $false
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B ) ) ).

fof(addCaseBooleanConditionShiftedRanges0_1,axiom,
    ! [VarNext] :
      ( v3459(VarNext)
     => ( ( v6(VarNext,bitIndex3)
        <=> v3467(VarNext,bitIndex2) )
        & ( v6(VarNext,bitIndex2)
        <=> v3467(VarNext,bitIndex1) )
        & ( v6(VarNext,bitIndex1)
        <=> v3467(VarNext,bitIndex0) ) ) ) ).

fof(addAssignment_810,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v3467(VarNext,B)
          <=> v3465(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_7,axiom,
    ! [VarCurr] :
      ( ~ v2766(VarCurr)
     => ( ( v3465(VarCurr,bitIndex2)
        <=> v19(VarCurr,bitIndex3) )
        & ( v3465(VarCurr,bitIndex1)
        <=> v19(VarCurr,bitIndex2) )
        & ( v3465(VarCurr,bitIndex0)
        <=> v19(VarCurr,bitIndex1) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_99,axiom,
    ! [VarCurr] :
      ( v2766(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3465(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_624,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3459(VarNext)
      <=> v3460(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_623,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3460(VarNext)
      <=> ( v3462(VarNext)
          & v2752(VarNext) ) ) ) ).

fof(writeUnaryOperator_244,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3462(VarNext)
      <=> v2759(VarNext) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_46,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3446(VarNext)
       => ( v6(VarNext,bitIndex0)
        <=> v6(VarCurr,bitIndex0) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_54,axiom,
    ! [VarNext] :
      ( v3446(VarNext)
     => ( v6(VarNext,bitIndex0)
      <=> v3454(VarNext) ) ) ).

fof(addAssignment_809,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3454(VarNext)
      <=> v3452(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_96,axiom,
    ! [VarCurr] :
      ( ~ v2766(VarCurr)
     => ( v3452(VarCurr)
      <=> v19(VarCurr,bitIndex0) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_98,axiom,
    ! [VarCurr] :
      ( v2766(VarCurr)
     => ( v3452(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_622,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3446(VarNext)
      <=> v3447(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_621,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3447(VarNext)
      <=> ( v3449(VarNext)
          & v2752(VarNext) ) ) ) ).

fof(writeUnaryOperator_243,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3449(VarNext)
      <=> v2759(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_6,axiom,
    ! [VarCurr] :
      ( ~ v3440(VarCurr)
     => ( v19(VarCurr,bitIndex3)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_4,axiom,
    ! [VarCurr] :
      ( v3440(VarCurr)
     => ( v19(VarCurr,bitIndex3)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_620,axiom,
    ! [VarCurr] :
      ( v3440(VarCurr)
    <=> ( v3441(VarCurr)
        | v3442(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_619,axiom,
    ! [VarCurr] :
      ( v3442(VarCurr)
    <=> ( v3443(VarCurr)
        & v2737(VarCurr) ) ) ).

fof(writeUnaryOperator_242,axiom,
    ! [VarCurr] :
      ( ~ v3443(VarCurr)
    <=> v554(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_618,axiom,
    ! [VarCurr] :
      ( v3441(VarCurr)
    <=> ( v554(VarCurr)
        & v2736(VarCurr) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_5,axiom,
    ! [VarCurr] :
      ( ~ v3435(VarCurr)
     => ( v19(VarCurr,bitIndex2)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_3,axiom,
    ! [VarCurr] :
      ( v3435(VarCurr)
     => ( v19(VarCurr,bitIndex2)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_617,axiom,
    ! [VarCurr] :
      ( v3435(VarCurr)
    <=> ( v3436(VarCurr)
        | v3437(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_616,axiom,
    ! [VarCurr] :
      ( v3437(VarCurr)
    <=> ( v3438(VarCurr)
        & v2736(VarCurr) ) ) ).

fof(writeUnaryOperator_241,axiom,
    ! [VarCurr] :
      ( ~ v3438(VarCurr)
    <=> v554(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_615,axiom,
    ! [VarCurr] :
      ( v3436(VarCurr)
    <=> ( v2744(VarCurr)
        & v2735(VarCurr) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_4,axiom,
    ! [VarCurr] :
      ( ~ v3430(VarCurr)
     => ( v19(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_2,axiom,
    ! [VarCurr] :
      ( v3430(VarCurr)
     => ( v19(VarCurr,bitIndex1)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_614,axiom,
    ! [VarCurr] :
      ( v3430(VarCurr)
    <=> ( v3431(VarCurr)
        | v3432(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_613,axiom,
    ! [VarCurr] :
      ( v3432(VarCurr)
    <=> ( v3433(VarCurr)
        & v2738(VarCurr) ) ) ).

fof(writeUnaryOperator_240,axiom,
    ! [VarCurr] :
      ( ~ v3433(VarCurr)
    <=> v554(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_612,axiom,
    ! [VarCurr] :
      ( v3431(VarCurr)
    <=> ( v2747(VarCurr)
        & v2735(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_95,axiom,
    ! [VarCurr] :
      ( ~ v3424(VarCurr)
     => ( v19(VarCurr,bitIndex0)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_97,axiom,
    ! [VarCurr] :
      ( v3424(VarCurr)
     => ( v19(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_611,axiom,
    ! [VarCurr] :
      ( v3424(VarCurr)
    <=> ( v3425(VarCurr)
        | v3428(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_610,axiom,
    ! [VarCurr] :
      ( v3428(VarCurr)
    <=> ( v554(VarCurr)
        & v2738(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_609,axiom,
    ! [VarCurr] :
      ( v3425(VarCurr)
    <=> ( v3426(VarCurr)
        | v3427(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_608,axiom,
    ! [VarCurr] :
      ( v3427(VarCurr)
    <=> ( v554(VarCurr)
        & v2737(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_607,axiom,
    ! [VarCurr] :
      ( v3426(VarCurr)
    <=> ( v2741(VarCurr)
        & v2735(VarCurr) ) ) ).

fof(addAssignment_808,axiom,
    ! [VarCurr] :
      ( v21(VarCurr)
    <=> v23(VarCurr) ) ).

fof(addAssignment_807,axiom,
    ! [VarCurr] :
      ( v23(VarCurr)
    <=> v25(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_94,axiom,
    ! [VarCurr] :
      ( ~ v3420(VarCurr)
     => ( v25(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_96,axiom,
    ! [VarCurr] :
      ( v3420(VarCurr)
     => ( v25(VarCurr)
      <=> v3422(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_93,axiom,
    ! [VarCurr] :
      ( ~ v541(VarCurr)
     => ( v3422(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_95,axiom,
    ! [VarCurr] :
      ( v541(VarCurr)
     => ( v3422(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_606,axiom,
    ! [VarCurr] :
      ( v3420(VarCurr)
    <=> ( v3421(VarCurr)
        & v2931(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_605,axiom,
    ! [VarCurr] :
      ( v3421(VarCurr)
    <=> ( v2929(VarCurr)
        & v2930(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_92,axiom,
    ! [VarCurr] :
      ( ~ v29(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v27(VarCurr,B)
          <=> v3391(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_94,axiom,
    ! [VarCurr] :
      ( v29(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v27(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_25,axiom,
    ! [VarCurr] :
      ( ( ~ v3392(VarCurr)
        & ~ v3412(VarCurr)
        & ~ v3413(VarCurr) )
     => ! [B] :
          ( range_1_0(B)
         => ( v3391(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_51,axiom,
    ! [VarCurr] :
      ( v3413(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v3391(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_130,axiom,
    ! [VarCurr] :
      ( v3412(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v3391(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_128,axiom,
    ! [VarCurr] :
      ( v3392(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v3391(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_604,axiom,
    ! [VarCurr] :
      ( v3413(VarCurr)
    <=> ( v3415(VarCurr)
        | v3418(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_338,axiom,
    ! [VarCurr] :
      ( v3418(VarCurr)
    <=> ( ( v3308(VarCurr,bitIndex6)
        <=> $true )
        & ( v3308(VarCurr,bitIndex5)
        <=> $false )
        & ( v3308(VarCurr,bitIndex4)
        <=> $false )
        & ( v3308(VarCurr,bitIndex3)
        <=> $true )
        & ( v3308(VarCurr,bitIndex2)
        <=> $false )
        & ( v3308(VarCurr,bitIndex1)
        <=> $true )
        & ( v3308(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_603,axiom,
    ! [VarCurr] :
      ( v3415(VarCurr)
    <=> ( v3416(VarCurr)
        | v3417(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_337,axiom,
    ! [VarCurr] :
      ( v3417(VarCurr)
    <=> ( ( v3308(VarCurr,bitIndex6)
        <=> $false )
        & ( v3308(VarCurr,bitIndex5)
        <=> $false )
        & ( v3308(VarCurr,bitIndex4)
        <=> $false )
        & ( v3308(VarCurr,bitIndex3)
        <=> $true )
        & ( v3308(VarCurr,bitIndex2)
        <=> $false )
        & ( v3308(VarCurr,bitIndex1)
        <=> $true )
        & ( v3308(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_336,axiom,
    ! [VarCurr] :
      ( v3416(VarCurr)
    <=> ( ( v3308(VarCurr,bitIndex6)
        <=> $false )
        & ( v3308(VarCurr,bitIndex5)
        <=> $false )
        & ( v3308(VarCurr,bitIndex4)
        <=> $false )
        & ( v3308(VarCurr,bitIndex3)
        <=> $true )
        & ( v3308(VarCurr,bitIndex2)
        <=> $false )
        & ( v3308(VarCurr,bitIndex1)
        <=> $true )
        & ( v3308(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_335,axiom,
    ! [VarCurr] :
      ( v3412(VarCurr)
    <=> ( ( v3308(VarCurr,bitIndex6)
        <=> $true )
        & ( v3308(VarCurr,bitIndex5)
        <=> $true )
        & ( v3308(VarCurr,bitIndex4)
        <=> $true )
        & ( v3308(VarCurr,bitIndex3)
        <=> $true )
        & ( v3308(VarCurr,bitIndex2)
        <=> $false )
        & ( v3308(VarCurr,bitIndex1)
        <=> $true )
        & ( v3308(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_602,axiom,
    ! [VarCurr] :
      ( v3392(VarCurr)
    <=> ( v3394(VarCurr)
        | v3411(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_334,axiom,
    ! [VarCurr] :
      ( v3411(VarCurr)
    <=> ( ( v3308(VarCurr,bitIndex6)
        <=> $true )
        & ( v3308(VarCurr,bitIndex5)
        <=> $false )
        & ( v3308(VarCurr,bitIndex4)
        <=> $false )
        & ( v3308(VarCurr,bitIndex3)
        <=> $false )
        & ( v3308(VarCurr,bitIndex2)
        <=> $true )
        & ( v3308(VarCurr,bitIndex1)
        <=> $false )
        & ( v3308(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_601,axiom,
    ! [VarCurr] :
      ( v3394(VarCurr)
    <=> ( v3395(VarCurr)
        | v3410(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_333,axiom,
    ! [VarCurr] :
      ( v3410(VarCurr)
    <=> ( ( v3308(VarCurr,bitIndex6)
        <=> $true )
        & ( v3308(VarCurr,bitIndex5)
        <=> $false )
        & ( v3308(VarCurr,bitIndex4)
        <=> $false )
        & ( v3308(VarCurr,bitIndex3)
        <=> $false )
        & ( v3308(VarCurr,bitIndex2)
        <=> $true )
        & ( v3308(VarCurr,bitIndex1)
        <=> $false )
        & ( v3308(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_600,axiom,
    ! [VarCurr] :
      ( v3395(VarCurr)
    <=> ( v3396(VarCurr)
        | v3409(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_332,axiom,
    ! [VarCurr] :
      ( v3409(VarCurr)
    <=> ( ( v3308(VarCurr,bitIndex6)
        <=> $true )
        & ( v3308(VarCurr,bitIndex5)
        <=> $true )
        & ( v3308(VarCurr,bitIndex4)
        <=> $false )
        & ( v3308(VarCurr,bitIndex3)
        <=> $false )
        & ( v3308(VarCurr,bitIndex2)
        <=> $false )
        & ( v3308(VarCurr,bitIndex1)
        <=> $false )
        & ( v3308(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_599,axiom,
    ! [VarCurr] :
      ( v3396(VarCurr)
    <=> ( v3397(VarCurr)
        | v3408(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_331,axiom,
    ! [VarCurr] :
      ( v3408(VarCurr)
    <=> ( ( v3308(VarCurr,bitIndex6)
        <=> $true )
        & ( v3308(VarCurr,bitIndex5)
        <=> $false )
        & ( v3308(VarCurr,bitIndex4)
        <=> $false )
        & ( v3308(VarCurr,bitIndex3)
        <=> $false )
        & ( v3308(VarCurr,bitIndex2)
        <=> $false )
        & ( v3308(VarCurr,bitIndex1)
        <=> $false )
        & ( v3308(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_598,axiom,
    ! [VarCurr] :
      ( v3397(VarCurr)
    <=> ( v3398(VarCurr)
        | v3407(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_330,axiom,
    ! [VarCurr] :
      ( v3407(VarCurr)
    <=> ( ( v3308(VarCurr,bitIndex6)
        <=> $true )
        & ( v3308(VarCurr,bitIndex5)
        <=> $false )
        & ( v3308(VarCurr,bitIndex4)
        <=> $false )
        & ( v3308(VarCurr,bitIndex3)
        <=> $false )
        & ( v3308(VarCurr,bitIndex2)
        <=> $false )
        & ( v3308(VarCurr,bitIndex1)
        <=> $true )
        & ( v3308(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_597,axiom,
    ! [VarCurr] :
      ( v3398(VarCurr)
    <=> ( v3399(VarCurr)
        | v3406(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_329,axiom,
    ! [VarCurr] :
      ( v3406(VarCurr)
    <=> ( ( v3308(VarCurr,bitIndex6)
        <=> $false )
        & ( v3308(VarCurr,bitIndex5)
        <=> $false )
        & ( v3308(VarCurr,bitIndex4)
        <=> $false )
        & ( v3308(VarCurr,bitIndex3)
        <=> $false )
        & ( v3308(VarCurr,bitIndex2)
        <=> $true )
        & ( v3308(VarCurr,bitIndex1)
        <=> $false )
        & ( v3308(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_596,axiom,
    ! [VarCurr] :
      ( v3399(VarCurr)
    <=> ( v3400(VarCurr)
        | v3405(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_328,axiom,
    ! [VarCurr] :
      ( v3405(VarCurr)
    <=> ( ( v3308(VarCurr,bitIndex6)
        <=> $false )
        & ( v3308(VarCurr,bitIndex5)
        <=> $false )
        & ( v3308(VarCurr,bitIndex4)
        <=> $false )
        & ( v3308(VarCurr,bitIndex3)
        <=> $false )
        & ( v3308(VarCurr,bitIndex2)
        <=> $true )
        & ( v3308(VarCurr,bitIndex1)
        <=> $false )
        & ( v3308(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_595,axiom,
    ! [VarCurr] :
      ( v3400(VarCurr)
    <=> ( v3401(VarCurr)
        | v3404(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_327,axiom,
    ! [VarCurr] :
      ( v3404(VarCurr)
    <=> ( ( v3308(VarCurr,bitIndex6)
        <=> $false )
        & ( v3308(VarCurr,bitIndex5)
        <=> $false )
        & ( v3308(VarCurr,bitIndex4)
        <=> $false )
        & ( v3308(VarCurr,bitIndex3)
        <=> $false )
        & ( v3308(VarCurr,bitIndex2)
        <=> $false )
        & ( v3308(VarCurr,bitIndex1)
        <=> $true )
        & ( v3308(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_594,axiom,
    ! [VarCurr] :
      ( v3401(VarCurr)
    <=> ( v3402(VarCurr)
        | v3403(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_326,axiom,
    ! [VarCurr] :
      ( v3403(VarCurr)
    <=> ( ( v3308(VarCurr,bitIndex6)
        <=> $false )
        & ( v3308(VarCurr,bitIndex5)
        <=> $true )
        & ( v3308(VarCurr,bitIndex4)
        <=> $false )
        & ( v3308(VarCurr,bitIndex3)
        <=> $false )
        & ( v3308(VarCurr,bitIndex2)
        <=> $false )
        & ( v3308(VarCurr,bitIndex1)
        <=> $false )
        & ( v3308(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_325,axiom,
    ! [VarCurr] :
      ( v3402(VarCurr)
    <=> ( ( v3308(VarCurr,bitIndex6)
        <=> $false )
        & ( v3308(VarCurr,bitIndex5)
        <=> $false )
        & ( v3308(VarCurr,bitIndex4)
        <=> $false )
        & ( v3308(VarCurr,bitIndex3)
        <=> $false )
        & ( v3308(VarCurr,bitIndex2)
        <=> $false )
        & ( v3308(VarCurr,bitIndex1)
        <=> $false )
        & ( v3308(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_806,axiom,
    ! [VarCurr] :
      ( ( v3308(VarCurr,bitIndex6)
      <=> v599(VarCurr,bitIndex69) )
      & ( v3308(VarCurr,bitIndex5)
      <=> v599(VarCurr,bitIndex68) )
      & ( v3308(VarCurr,bitIndex4)
      <=> v599(VarCurr,bitIndex67) )
      & ( v3308(VarCurr,bitIndex3)
      <=> v599(VarCurr,bitIndex66) )
      & ( v3308(VarCurr,bitIndex2)
      <=> v599(VarCurr,bitIndex65) )
      & ( v3308(VarCurr,bitIndex1)
      <=> v599(VarCurr,bitIndex64) )
      & ( v3308(VarCurr,bitIndex0)
      <=> v599(VarCurr,bitIndex63) ) ) ).

fof(addAssignment_805,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v599(VarCurr,B)
      <=> v601(VarCurr,B) ) ) ).

fof(addAssignment_804,axiom,
    ! [VarCurr] :
      ( ( v601(VarCurr,bitIndex69)
      <=> v603(VarCurr,bitIndex559) )
      & ( v601(VarCurr,bitIndex68)
      <=> v603(VarCurr,bitIndex558) )
      & ( v601(VarCurr,bitIndex67)
      <=> v603(VarCurr,bitIndex557) )
      & ( v601(VarCurr,bitIndex66)
      <=> v603(VarCurr,bitIndex556) )
      & ( v601(VarCurr,bitIndex65)
      <=> v603(VarCurr,bitIndex555) )
      & ( v601(VarCurr,bitIndex64)
      <=> v603(VarCurr,bitIndex554) )
      & ( v601(VarCurr,bitIndex63)
      <=> v603(VarCurr,bitIndex553) ) ) ).

fof(addAssignment_803,axiom,
    ! [VarNext] :
      ( ( v603(VarNext,bitIndex559)
      <=> v3383(VarNext,bitIndex69) )
      & ( v603(VarNext,bitIndex558)
      <=> v3383(VarNext,bitIndex68) )
      & ( v603(VarNext,bitIndex557)
      <=> v3383(VarNext,bitIndex67) )
      & ( v603(VarNext,bitIndex556)
      <=> v3383(VarNext,bitIndex66) )
      & ( v603(VarNext,bitIndex555)
      <=> v3383(VarNext,bitIndex65) )
      & ( v603(VarNext,bitIndex554)
      <=> v3383(VarNext,bitIndex64) )
      & ( v603(VarNext,bitIndex553)
      <=> v3383(VarNext,bitIndex63) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_8,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3385(VarNext)
       => ( ( v3383(VarNext,bitIndex69)
          <=> v603(VarCurr,bitIndex559) )
          & ( v3383(VarNext,bitIndex68)
          <=> v603(VarCurr,bitIndex558) )
          & ( v3383(VarNext,bitIndex67)
          <=> v603(VarCurr,bitIndex557) )
          & ( v3383(VarNext,bitIndex66)
          <=> v603(VarCurr,bitIndex556) )
          & ( v3383(VarNext,bitIndex65)
          <=> v603(VarCurr,bitIndex555) )
          & ( v3383(VarNext,bitIndex64)
          <=> v603(VarCurr,bitIndex554) )
          & ( v3383(VarNext,bitIndex63)
          <=> v603(VarCurr,bitIndex553) )
          & ( v3383(VarNext,bitIndex62)
          <=> v603(VarCurr,bitIndex552) )
          & ( v3383(VarNext,bitIndex61)
          <=> v603(VarCurr,bitIndex551) )
          & ( v3383(VarNext,bitIndex60)
          <=> v603(VarCurr,bitIndex550) )
          & ( v3383(VarNext,bitIndex59)
          <=> v603(VarCurr,bitIndex549) )
          & ( v3383(VarNext,bitIndex58)
          <=> v603(VarCurr,bitIndex548) )
          & ( v3383(VarNext,bitIndex57)
          <=> v603(VarCurr,bitIndex547) )
          & ( v3383(VarNext,bitIndex56)
          <=> v603(VarCurr,bitIndex546) )
          & ( v3383(VarNext,bitIndex55)
          <=> v603(VarCurr,bitIndex545) )
          & ( v3383(VarNext,bitIndex54)
          <=> v603(VarCurr,bitIndex544) )
          & ( v3383(VarNext,bitIndex53)
          <=> v603(VarCurr,bitIndex543) )
          & ( v3383(VarNext,bitIndex52)
          <=> v603(VarCurr,bitIndex542) )
          & ( v3383(VarNext,bitIndex51)
          <=> v603(VarCurr,bitIndex541) )
          & ( v3383(VarNext,bitIndex50)
          <=> v603(VarCurr,bitIndex540) )
          & ( v3383(VarNext,bitIndex49)
          <=> v603(VarCurr,bitIndex539) )
          & ( v3383(VarNext,bitIndex48)
          <=> v603(VarCurr,bitIndex538) )
          & ( v3383(VarNext,bitIndex47)
          <=> v603(VarCurr,bitIndex537) )
          & ( v3383(VarNext,bitIndex46)
          <=> v603(VarCurr,bitIndex536) )
          & ( v3383(VarNext,bitIndex45)
          <=> v603(VarCurr,bitIndex535) )
          & ( v3383(VarNext,bitIndex44)
          <=> v603(VarCurr,bitIndex534) )
          & ( v3383(VarNext,bitIndex43)
          <=> v603(VarCurr,bitIndex533) )
          & ( v3383(VarNext,bitIndex42)
          <=> v603(VarCurr,bitIndex532) )
          & ( v3383(VarNext,bitIndex41)
          <=> v603(VarCurr,bitIndex531) )
          & ( v3383(VarNext,bitIndex40)
          <=> v603(VarCurr,bitIndex530) )
          & ( v3383(VarNext,bitIndex39)
          <=> v603(VarCurr,bitIndex529) )
          & ( v3383(VarNext,bitIndex38)
          <=> v603(VarCurr,bitIndex528) )
          & ( v3383(VarNext,bitIndex37)
          <=> v603(VarCurr,bitIndex527) )
          & ( v3383(VarNext,bitIndex36)
          <=> v603(VarCurr,bitIndex526) )
          & ( v3383(VarNext,bitIndex35)
          <=> v603(VarCurr,bitIndex525) )
          & ( v3383(VarNext,bitIndex34)
          <=> v603(VarCurr,bitIndex524) )
          & ( v3383(VarNext,bitIndex33)
          <=> v603(VarCurr,bitIndex523) )
          & ( v3383(VarNext,bitIndex32)
          <=> v603(VarCurr,bitIndex522) )
          & ( v3383(VarNext,bitIndex31)
          <=> v603(VarCurr,bitIndex521) )
          & ( v3383(VarNext,bitIndex30)
          <=> v603(VarCurr,bitIndex520) )
          & ( v3383(VarNext,bitIndex29)
          <=> v603(VarCurr,bitIndex519) )
          & ( v3383(VarNext,bitIndex28)
          <=> v603(VarCurr,bitIndex518) )
          & ( v3383(VarNext,bitIndex27)
          <=> v603(VarCurr,bitIndex517) )
          & ( v3383(VarNext,bitIndex26)
          <=> v603(VarCurr,bitIndex516) )
          & ( v3383(VarNext,bitIndex25)
          <=> v603(VarCurr,bitIndex515) )
          & ( v3383(VarNext,bitIndex24)
          <=> v603(VarCurr,bitIndex514) )
          & ( v3383(VarNext,bitIndex23)
          <=> v603(VarCurr,bitIndex513) )
          & ( v3383(VarNext,bitIndex22)
          <=> v603(VarCurr,bitIndex512) )
          & ( v3383(VarNext,bitIndex21)
          <=> v603(VarCurr,bitIndex511) )
          & ( v3383(VarNext,bitIndex20)
          <=> v603(VarCurr,bitIndex510) )
          & ( v3383(VarNext,bitIndex19)
          <=> v603(VarCurr,bitIndex509) )
          & ( v3383(VarNext,bitIndex18)
          <=> v603(VarCurr,bitIndex508) )
          & ( v3383(VarNext,bitIndex17)
          <=> v603(VarCurr,bitIndex507) )
          & ( v3383(VarNext,bitIndex16)
          <=> v603(VarCurr,bitIndex506) )
          & ( v3383(VarNext,bitIndex15)
          <=> v603(VarCurr,bitIndex505) )
          & ( v3383(VarNext,bitIndex14)
          <=> v603(VarCurr,bitIndex504) )
          & ( v3383(VarNext,bitIndex13)
          <=> v603(VarCurr,bitIndex503) )
          & ( v3383(VarNext,bitIndex12)
          <=> v603(VarCurr,bitIndex502) )
          & ( v3383(VarNext,bitIndex11)
          <=> v603(VarCurr,bitIndex501) )
          & ( v3383(VarNext,bitIndex10)
          <=> v603(VarCurr,bitIndex500) )
          & ( v3383(VarNext,bitIndex9)
          <=> v603(VarCurr,bitIndex499) )
          & ( v3383(VarNext,bitIndex8)
          <=> v603(VarCurr,bitIndex498) )
          & ( v3383(VarNext,bitIndex7)
          <=> v603(VarCurr,bitIndex497) )
          & ( v3383(VarNext,bitIndex6)
          <=> v603(VarCurr,bitIndex496) )
          & ( v3383(VarNext,bitIndex5)
          <=> v603(VarCurr,bitIndex495) )
          & ( v3383(VarNext,bitIndex4)
          <=> v603(VarCurr,bitIndex494) )
          & ( v3383(VarNext,bitIndex3)
          <=> v603(VarCurr,bitIndex493) )
          & ( v3383(VarNext,bitIndex2)
          <=> v603(VarCurr,bitIndex492) )
          & ( v3383(VarNext,bitIndex1)
          <=> v603(VarCurr,bitIndex491) )
          & ( v3383(VarNext,bitIndex0)
          <=> v603(VarCurr,bitIndex490) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_53,axiom,
    ! [VarNext] :
      ( v3385(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v3383(VarNext,B)
          <=> v2726(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_593,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3385(VarNext)
      <=> ( v3386(VarNext)
          & v2708(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_592,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3386(VarNext)
      <=> ( v3388(VarNext)
          & v618(VarNext) ) ) ) ).

fof(writeUnaryOperator_239,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3388(VarNext)
      <=> v633(VarNext) ) ) ).

fof(addAssignment_802,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v2692(VarCurr,B)
      <=> v2697(VarCurr,B) ) ) ).

fof(addAssignment_801,axiom,
    ! [VarCurr] :
      ( ( v2696(VarCurr,bitIndex69)
      <=> v603(VarCurr,bitIndex489) )
      & ( v2696(VarCurr,bitIndex68)
      <=> v603(VarCurr,bitIndex488) )
      & ( v2696(VarCurr,bitIndex67)
      <=> v603(VarCurr,bitIndex487) )
      & ( v2696(VarCurr,bitIndex66)
      <=> v603(VarCurr,bitIndex486) )
      & ( v2696(VarCurr,bitIndex65)
      <=> v603(VarCurr,bitIndex485) )
      & ( v2696(VarCurr,bitIndex64)
      <=> v603(VarCurr,bitIndex484) )
      & ( v2696(VarCurr,bitIndex63)
      <=> v603(VarCurr,bitIndex483) ) ) ).

fof(addAssignment_800,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v2685(VarCurr,B)
      <=> v2690(VarCurr,B) ) ) ).

fof(addAssignment_799,axiom,
    ! [VarCurr] :
      ( ( v2689(VarCurr,bitIndex69)
      <=> v603(VarCurr,bitIndex559) )
      & ( v2689(VarCurr,bitIndex68)
      <=> v603(VarCurr,bitIndex558) )
      & ( v2689(VarCurr,bitIndex67)
      <=> v603(VarCurr,bitIndex557) )
      & ( v2689(VarCurr,bitIndex66)
      <=> v603(VarCurr,bitIndex556) )
      & ( v2689(VarCurr,bitIndex65)
      <=> v603(VarCurr,bitIndex555) )
      & ( v2689(VarCurr,bitIndex64)
      <=> v603(VarCurr,bitIndex554) )
      & ( v2689(VarCurr,bitIndex63)
      <=> v603(VarCurr,bitIndex553) ) ) ).

fof(addAssignment_798,axiom,
    ! [VarNext] :
      ( ( v603(VarNext,bitIndex489)
      <=> v3375(VarNext,bitIndex69) )
      & ( v603(VarNext,bitIndex488)
      <=> v3375(VarNext,bitIndex68) )
      & ( v603(VarNext,bitIndex487)
      <=> v3375(VarNext,bitIndex67) )
      & ( v603(VarNext,bitIndex486)
      <=> v3375(VarNext,bitIndex66) )
      & ( v603(VarNext,bitIndex485)
      <=> v3375(VarNext,bitIndex65) )
      & ( v603(VarNext,bitIndex484)
      <=> v3375(VarNext,bitIndex64) )
      & ( v603(VarNext,bitIndex483)
      <=> v3375(VarNext,bitIndex63) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_7,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3377(VarNext)
       => ( ( v3375(VarNext,bitIndex69)
          <=> v603(VarCurr,bitIndex489) )
          & ( v3375(VarNext,bitIndex68)
          <=> v603(VarCurr,bitIndex488) )
          & ( v3375(VarNext,bitIndex67)
          <=> v603(VarCurr,bitIndex487) )
          & ( v3375(VarNext,bitIndex66)
          <=> v603(VarCurr,bitIndex486) )
          & ( v3375(VarNext,bitIndex65)
          <=> v603(VarCurr,bitIndex485) )
          & ( v3375(VarNext,bitIndex64)
          <=> v603(VarCurr,bitIndex484) )
          & ( v3375(VarNext,bitIndex63)
          <=> v603(VarCurr,bitIndex483) )
          & ( v3375(VarNext,bitIndex62)
          <=> v603(VarCurr,bitIndex482) )
          & ( v3375(VarNext,bitIndex61)
          <=> v603(VarCurr,bitIndex481) )
          & ( v3375(VarNext,bitIndex60)
          <=> v603(VarCurr,bitIndex480) )
          & ( v3375(VarNext,bitIndex59)
          <=> v603(VarCurr,bitIndex479) )
          & ( v3375(VarNext,bitIndex58)
          <=> v603(VarCurr,bitIndex478) )
          & ( v3375(VarNext,bitIndex57)
          <=> v603(VarCurr,bitIndex477) )
          & ( v3375(VarNext,bitIndex56)
          <=> v603(VarCurr,bitIndex476) )
          & ( v3375(VarNext,bitIndex55)
          <=> v603(VarCurr,bitIndex475) )
          & ( v3375(VarNext,bitIndex54)
          <=> v603(VarCurr,bitIndex474) )
          & ( v3375(VarNext,bitIndex53)
          <=> v603(VarCurr,bitIndex473) )
          & ( v3375(VarNext,bitIndex52)
          <=> v603(VarCurr,bitIndex472) )
          & ( v3375(VarNext,bitIndex51)
          <=> v603(VarCurr,bitIndex471) )
          & ( v3375(VarNext,bitIndex50)
          <=> v603(VarCurr,bitIndex470) )
          & ( v3375(VarNext,bitIndex49)
          <=> v603(VarCurr,bitIndex469) )
          & ( v3375(VarNext,bitIndex48)
          <=> v603(VarCurr,bitIndex468) )
          & ( v3375(VarNext,bitIndex47)
          <=> v603(VarCurr,bitIndex467) )
          & ( v3375(VarNext,bitIndex46)
          <=> v603(VarCurr,bitIndex466) )
          & ( v3375(VarNext,bitIndex45)
          <=> v603(VarCurr,bitIndex465) )
          & ( v3375(VarNext,bitIndex44)
          <=> v603(VarCurr,bitIndex464) )
          & ( v3375(VarNext,bitIndex43)
          <=> v603(VarCurr,bitIndex463) )
          & ( v3375(VarNext,bitIndex42)
          <=> v603(VarCurr,bitIndex462) )
          & ( v3375(VarNext,bitIndex41)
          <=> v603(VarCurr,bitIndex461) )
          & ( v3375(VarNext,bitIndex40)
          <=> v603(VarCurr,bitIndex460) )
          & ( v3375(VarNext,bitIndex39)
          <=> v603(VarCurr,bitIndex459) )
          & ( v3375(VarNext,bitIndex38)
          <=> v603(VarCurr,bitIndex458) )
          & ( v3375(VarNext,bitIndex37)
          <=> v603(VarCurr,bitIndex457) )
          & ( v3375(VarNext,bitIndex36)
          <=> v603(VarCurr,bitIndex456) )
          & ( v3375(VarNext,bitIndex35)
          <=> v603(VarCurr,bitIndex455) )
          & ( v3375(VarNext,bitIndex34)
          <=> v603(VarCurr,bitIndex454) )
          & ( v3375(VarNext,bitIndex33)
          <=> v603(VarCurr,bitIndex453) )
          & ( v3375(VarNext,bitIndex32)
          <=> v603(VarCurr,bitIndex452) )
          & ( v3375(VarNext,bitIndex31)
          <=> v603(VarCurr,bitIndex451) )
          & ( v3375(VarNext,bitIndex30)
          <=> v603(VarCurr,bitIndex450) )
          & ( v3375(VarNext,bitIndex29)
          <=> v603(VarCurr,bitIndex449) )
          & ( v3375(VarNext,bitIndex28)
          <=> v603(VarCurr,bitIndex448) )
          & ( v3375(VarNext,bitIndex27)
          <=> v603(VarCurr,bitIndex447) )
          & ( v3375(VarNext,bitIndex26)
          <=> v603(VarCurr,bitIndex446) )
          & ( v3375(VarNext,bitIndex25)
          <=> v603(VarCurr,bitIndex445) )
          & ( v3375(VarNext,bitIndex24)
          <=> v603(VarCurr,bitIndex444) )
          & ( v3375(VarNext,bitIndex23)
          <=> v603(VarCurr,bitIndex443) )
          & ( v3375(VarNext,bitIndex22)
          <=> v603(VarCurr,bitIndex442) )
          & ( v3375(VarNext,bitIndex21)
          <=> v603(VarCurr,bitIndex441) )
          & ( v3375(VarNext,bitIndex20)
          <=> v603(VarCurr,bitIndex440) )
          & ( v3375(VarNext,bitIndex19)
          <=> v603(VarCurr,bitIndex439) )
          & ( v3375(VarNext,bitIndex18)
          <=> v603(VarCurr,bitIndex438) )
          & ( v3375(VarNext,bitIndex17)
          <=> v603(VarCurr,bitIndex437) )
          & ( v3375(VarNext,bitIndex16)
          <=> v603(VarCurr,bitIndex436) )
          & ( v3375(VarNext,bitIndex15)
          <=> v603(VarCurr,bitIndex435) )
          & ( v3375(VarNext,bitIndex14)
          <=> v603(VarCurr,bitIndex434) )
          & ( v3375(VarNext,bitIndex13)
          <=> v603(VarCurr,bitIndex433) )
          & ( v3375(VarNext,bitIndex12)
          <=> v603(VarCurr,bitIndex432) )
          & ( v3375(VarNext,bitIndex11)
          <=> v603(VarCurr,bitIndex431) )
          & ( v3375(VarNext,bitIndex10)
          <=> v603(VarCurr,bitIndex430) )
          & ( v3375(VarNext,bitIndex9)
          <=> v603(VarCurr,bitIndex429) )
          & ( v3375(VarNext,bitIndex8)
          <=> v603(VarCurr,bitIndex428) )
          & ( v3375(VarNext,bitIndex7)
          <=> v603(VarCurr,bitIndex427) )
          & ( v3375(VarNext,bitIndex6)
          <=> v603(VarCurr,bitIndex426) )
          & ( v3375(VarNext,bitIndex5)
          <=> v603(VarCurr,bitIndex425) )
          & ( v3375(VarNext,bitIndex4)
          <=> v603(VarCurr,bitIndex424) )
          & ( v3375(VarNext,bitIndex3)
          <=> v603(VarCurr,bitIndex423) )
          & ( v3375(VarNext,bitIndex2)
          <=> v603(VarCurr,bitIndex422) )
          & ( v3375(VarNext,bitIndex1)
          <=> v603(VarCurr,bitIndex421) )
          & ( v3375(VarNext,bitIndex0)
          <=> v603(VarCurr,bitIndex420) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_52,axiom,
    ! [VarNext] :
      ( v3377(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v3375(VarNext,B)
          <=> v2680(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_591,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3377(VarNext)
      <=> ( v3378(VarNext)
          & v2662(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_590,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3378(VarNext)
      <=> ( v3380(VarNext)
          & v618(VarNext) ) ) ) ).

fof(writeUnaryOperator_238,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3380(VarNext)
      <=> v633(VarNext) ) ) ).

fof(addAssignment_797,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v2646(VarCurr,B)
      <=> v2651(VarCurr,B) ) ) ).

fof(addAssignment_796,axiom,
    ! [VarCurr] :
      ( ( v2650(VarCurr,bitIndex69)
      <=> v603(VarCurr,bitIndex419) )
      & ( v2650(VarCurr,bitIndex68)
      <=> v603(VarCurr,bitIndex418) )
      & ( v2650(VarCurr,bitIndex67)
      <=> v603(VarCurr,bitIndex417) )
      & ( v2650(VarCurr,bitIndex66)
      <=> v603(VarCurr,bitIndex416) )
      & ( v2650(VarCurr,bitIndex65)
      <=> v603(VarCurr,bitIndex415) )
      & ( v2650(VarCurr,bitIndex64)
      <=> v603(VarCurr,bitIndex414) )
      & ( v2650(VarCurr,bitIndex63)
      <=> v603(VarCurr,bitIndex413) ) ) ).

fof(addAssignment_795,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v2639(VarCurr,B)
      <=> v2644(VarCurr,B) ) ) ).

fof(addAssignment_794,axiom,
    ! [VarCurr] :
      ( ( v2643(VarCurr,bitIndex69)
      <=> v603(VarCurr,bitIndex489) )
      & ( v2643(VarCurr,bitIndex68)
      <=> v603(VarCurr,bitIndex488) )
      & ( v2643(VarCurr,bitIndex67)
      <=> v603(VarCurr,bitIndex487) )
      & ( v2643(VarCurr,bitIndex66)
      <=> v603(VarCurr,bitIndex486) )
      & ( v2643(VarCurr,bitIndex65)
      <=> v603(VarCurr,bitIndex485) )
      & ( v2643(VarCurr,bitIndex64)
      <=> v603(VarCurr,bitIndex484) )
      & ( v2643(VarCurr,bitIndex63)
      <=> v603(VarCurr,bitIndex483) ) ) ).

fof(addAssignment_793,axiom,
    ! [VarNext] :
      ( ( v603(VarNext,bitIndex419)
      <=> v3367(VarNext,bitIndex69) )
      & ( v603(VarNext,bitIndex418)
      <=> v3367(VarNext,bitIndex68) )
      & ( v603(VarNext,bitIndex417)
      <=> v3367(VarNext,bitIndex67) )
      & ( v603(VarNext,bitIndex416)
      <=> v3367(VarNext,bitIndex66) )
      & ( v603(VarNext,bitIndex415)
      <=> v3367(VarNext,bitIndex65) )
      & ( v603(VarNext,bitIndex414)
      <=> v3367(VarNext,bitIndex64) )
      & ( v603(VarNext,bitIndex413)
      <=> v3367(VarNext,bitIndex63) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_6,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3369(VarNext)
       => ( ( v3367(VarNext,bitIndex69)
          <=> v603(VarCurr,bitIndex419) )
          & ( v3367(VarNext,bitIndex68)
          <=> v603(VarCurr,bitIndex418) )
          & ( v3367(VarNext,bitIndex67)
          <=> v603(VarCurr,bitIndex417) )
          & ( v3367(VarNext,bitIndex66)
          <=> v603(VarCurr,bitIndex416) )
          & ( v3367(VarNext,bitIndex65)
          <=> v603(VarCurr,bitIndex415) )
          & ( v3367(VarNext,bitIndex64)
          <=> v603(VarCurr,bitIndex414) )
          & ( v3367(VarNext,bitIndex63)
          <=> v603(VarCurr,bitIndex413) )
          & ( v3367(VarNext,bitIndex62)
          <=> v603(VarCurr,bitIndex412) )
          & ( v3367(VarNext,bitIndex61)
          <=> v603(VarCurr,bitIndex411) )
          & ( v3367(VarNext,bitIndex60)
          <=> v603(VarCurr,bitIndex410) )
          & ( v3367(VarNext,bitIndex59)
          <=> v603(VarCurr,bitIndex409) )
          & ( v3367(VarNext,bitIndex58)
          <=> v603(VarCurr,bitIndex408) )
          & ( v3367(VarNext,bitIndex57)
          <=> v603(VarCurr,bitIndex407) )
          & ( v3367(VarNext,bitIndex56)
          <=> v603(VarCurr,bitIndex406) )
          & ( v3367(VarNext,bitIndex55)
          <=> v603(VarCurr,bitIndex405) )
          & ( v3367(VarNext,bitIndex54)
          <=> v603(VarCurr,bitIndex404) )
          & ( v3367(VarNext,bitIndex53)
          <=> v603(VarCurr,bitIndex403) )
          & ( v3367(VarNext,bitIndex52)
          <=> v603(VarCurr,bitIndex402) )
          & ( v3367(VarNext,bitIndex51)
          <=> v603(VarCurr,bitIndex401) )
          & ( v3367(VarNext,bitIndex50)
          <=> v603(VarCurr,bitIndex400) )
          & ( v3367(VarNext,bitIndex49)
          <=> v603(VarCurr,bitIndex399) )
          & ( v3367(VarNext,bitIndex48)
          <=> v603(VarCurr,bitIndex398) )
          & ( v3367(VarNext,bitIndex47)
          <=> v603(VarCurr,bitIndex397) )
          & ( v3367(VarNext,bitIndex46)
          <=> v603(VarCurr,bitIndex396) )
          & ( v3367(VarNext,bitIndex45)
          <=> v603(VarCurr,bitIndex395) )
          & ( v3367(VarNext,bitIndex44)
          <=> v603(VarCurr,bitIndex394) )
          & ( v3367(VarNext,bitIndex43)
          <=> v603(VarCurr,bitIndex393) )
          & ( v3367(VarNext,bitIndex42)
          <=> v603(VarCurr,bitIndex392) )
          & ( v3367(VarNext,bitIndex41)
          <=> v603(VarCurr,bitIndex391) )
          & ( v3367(VarNext,bitIndex40)
          <=> v603(VarCurr,bitIndex390) )
          & ( v3367(VarNext,bitIndex39)
          <=> v603(VarCurr,bitIndex389) )
          & ( v3367(VarNext,bitIndex38)
          <=> v603(VarCurr,bitIndex388) )
          & ( v3367(VarNext,bitIndex37)
          <=> v603(VarCurr,bitIndex387) )
          & ( v3367(VarNext,bitIndex36)
          <=> v603(VarCurr,bitIndex386) )
          & ( v3367(VarNext,bitIndex35)
          <=> v603(VarCurr,bitIndex385) )
          & ( v3367(VarNext,bitIndex34)
          <=> v603(VarCurr,bitIndex384) )
          & ( v3367(VarNext,bitIndex33)
          <=> v603(VarCurr,bitIndex383) )
          & ( v3367(VarNext,bitIndex32)
          <=> v603(VarCurr,bitIndex382) )
          & ( v3367(VarNext,bitIndex31)
          <=> v603(VarCurr,bitIndex381) )
          & ( v3367(VarNext,bitIndex30)
          <=> v603(VarCurr,bitIndex380) )
          & ( v3367(VarNext,bitIndex29)
          <=> v603(VarCurr,bitIndex379) )
          & ( v3367(VarNext,bitIndex28)
          <=> v603(VarCurr,bitIndex378) )
          & ( v3367(VarNext,bitIndex27)
          <=> v603(VarCurr,bitIndex377) )
          & ( v3367(VarNext,bitIndex26)
          <=> v603(VarCurr,bitIndex376) )
          & ( v3367(VarNext,bitIndex25)
          <=> v603(VarCurr,bitIndex375) )
          & ( v3367(VarNext,bitIndex24)
          <=> v603(VarCurr,bitIndex374) )
          & ( v3367(VarNext,bitIndex23)
          <=> v603(VarCurr,bitIndex373) )
          & ( v3367(VarNext,bitIndex22)
          <=> v603(VarCurr,bitIndex372) )
          & ( v3367(VarNext,bitIndex21)
          <=> v603(VarCurr,bitIndex371) )
          & ( v3367(VarNext,bitIndex20)
          <=> v603(VarCurr,bitIndex370) )
          & ( v3367(VarNext,bitIndex19)
          <=> v603(VarCurr,bitIndex369) )
          & ( v3367(VarNext,bitIndex18)
          <=> v603(VarCurr,bitIndex368) )
          & ( v3367(VarNext,bitIndex17)
          <=> v603(VarCurr,bitIndex367) )
          & ( v3367(VarNext,bitIndex16)
          <=> v603(VarCurr,bitIndex366) )
          & ( v3367(VarNext,bitIndex15)
          <=> v603(VarCurr,bitIndex365) )
          & ( v3367(VarNext,bitIndex14)
          <=> v603(VarCurr,bitIndex364) )
          & ( v3367(VarNext,bitIndex13)
          <=> v603(VarCurr,bitIndex363) )
          & ( v3367(VarNext,bitIndex12)
          <=> v603(VarCurr,bitIndex362) )
          & ( v3367(VarNext,bitIndex11)
          <=> v603(VarCurr,bitIndex361) )
          & ( v3367(VarNext,bitIndex10)
          <=> v603(VarCurr,bitIndex360) )
          & ( v3367(VarNext,bitIndex9)
          <=> v603(VarCurr,bitIndex359) )
          & ( v3367(VarNext,bitIndex8)
          <=> v603(VarCurr,bitIndex358) )
          & ( v3367(VarNext,bitIndex7)
          <=> v603(VarCurr,bitIndex357) )
          & ( v3367(VarNext,bitIndex6)
          <=> v603(VarCurr,bitIndex356) )
          & ( v3367(VarNext,bitIndex5)
          <=> v603(VarCurr,bitIndex355) )
          & ( v3367(VarNext,bitIndex4)
          <=> v603(VarCurr,bitIndex354) )
          & ( v3367(VarNext,bitIndex3)
          <=> v603(VarCurr,bitIndex353) )
          & ( v3367(VarNext,bitIndex2)
          <=> v603(VarCurr,bitIndex352) )
          & ( v3367(VarNext,bitIndex1)
          <=> v603(VarCurr,bitIndex351) )
          & ( v3367(VarNext,bitIndex0)
          <=> v603(VarCurr,bitIndex350) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_51,axiom,
    ! [VarNext] :
      ( v3369(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v3367(VarNext,B)
          <=> v2634(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_589,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3369(VarNext)
      <=> ( v3370(VarNext)
          & v2615(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_588,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3370(VarNext)
      <=> ( v3372(VarNext)
          & v618(VarNext) ) ) ) ).

fof(writeUnaryOperator_237,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3372(VarNext)
      <=> v633(VarNext) ) ) ).

fof(addAssignment_792,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v2599(VarCurr,B)
      <=> v2604(VarCurr,B) ) ) ).

fof(addAssignment_791,axiom,
    ! [VarCurr] :
      ( ( v2603(VarCurr,bitIndex69)
      <=> v603(VarCurr,bitIndex349) )
      & ( v2603(VarCurr,bitIndex68)
      <=> v603(VarCurr,bitIndex348) )
      & ( v2603(VarCurr,bitIndex67)
      <=> v603(VarCurr,bitIndex347) )
      & ( v2603(VarCurr,bitIndex66)
      <=> v603(VarCurr,bitIndex346) )
      & ( v2603(VarCurr,bitIndex65)
      <=> v603(VarCurr,bitIndex345) )
      & ( v2603(VarCurr,bitIndex64)
      <=> v603(VarCurr,bitIndex344) )
      & ( v2603(VarCurr,bitIndex63)
      <=> v603(VarCurr,bitIndex343) ) ) ).

fof(addAssignment_790,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v607(VarCurr,B)
      <=> v2597(VarCurr,B) ) ) ).

fof(addAssignment_789,axiom,
    ! [VarCurr] :
      ( ( v2588(VarCurr,bitIndex69)
      <=> v603(VarCurr,bitIndex419) )
      & ( v2588(VarCurr,bitIndex68)
      <=> v603(VarCurr,bitIndex418) )
      & ( v2588(VarCurr,bitIndex67)
      <=> v603(VarCurr,bitIndex417) )
      & ( v2588(VarCurr,bitIndex66)
      <=> v603(VarCurr,bitIndex416) )
      & ( v2588(VarCurr,bitIndex65)
      <=> v603(VarCurr,bitIndex415) )
      & ( v2588(VarCurr,bitIndex64)
      <=> v603(VarCurr,bitIndex414) )
      & ( v2588(VarCurr,bitIndex63)
      <=> v603(VarCurr,bitIndex413) ) ) ).

fof(addAssignment_788,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v686(VarCurr,B)
      <=> v688(VarCurr,B) ) ) ).

fof(addAssignment_787,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v688(VarCurr,B)
      <=> v690(VarCurr,B) ) ) ).

fof(addAssignment_786,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v690(VarCurr,B)
      <=> v692(VarCurr,B) ) ) ).

fof(addAssignment_785,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v692(VarCurr,B)
      <=> v694(VarCurr,B) ) ) ).

fof(addAssignment_784,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v694(VarCurr,B)
      <=> v696(VarCurr,B) ) ) ).

fof(addAssignment_783,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v696(VarCurr,B)
      <=> v698(VarCurr,B) ) ) ).

fof(addAssignment_782,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v698(VarCurr,B)
      <=> v2576(VarCurr,B) ) ) ).

fof(range_axiom_19,axiom,
    ! [B] :
      ( range_69_63(B)
    <=> ( $false
        | bitIndex63 = B
        | bitIndex64 = B
        | bitIndex65 = B
        | bitIndex66 = B
        | bitIndex67 = B
        | bitIndex68 = B
        | bitIndex69 = B ) ) ).

fof(addCaseBooleanConditionEqualRanges1_45,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3334(VarNext)
       => ! [B] :
            ( range_6_0(B)
           => ( v2577(VarNext,B)
            <=> v2577(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_50,axiom,
    ! [VarNext] :
      ( v3334(VarNext)
     => ! [B] :
          ( range_6_0(B)
         => ( v2577(VarNext,B)
          <=> v3361(VarNext,B) ) ) ) ).

fof(addAssignment_781,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_6_0(B)
         => ( v3361(VarNext,B)
          <=> v3359(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_129,axiom,
    ! [VarCurr] :
      ( ~ v2541(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v3359(VarCurr,B)
          <=> v3362(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_127,axiom,
    ! [VarCurr] :
      ( v2541(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v3359(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_128,axiom,
    ! [VarCurr] :
      ( ~ v2544(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v3362(VarCurr,B)
          <=> v3310(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_126,axiom,
    ! [VarCurr] :
      ( v2544(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v3362(VarCurr,B)
          <=> v3363(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges1_2,axiom,
    ! [VarCurr] :
      ( ~ v2555(VarCurr)
     => ( ( v3363(VarCurr,bitIndex6)
        <=> v1824(VarCurr,bitIndex53) )
        & ( v3363(VarCurr,bitIndex5)
        <=> v1824(VarCurr,bitIndex52) )
        & ( v3363(VarCurr,bitIndex4)
        <=> v1824(VarCurr,bitIndex51) )
        & ( v3363(VarCurr,bitIndex3)
        <=> v1824(VarCurr,bitIndex50) )
        & ( v3363(VarCurr,bitIndex2)
        <=> v1824(VarCurr,bitIndex49) )
        & ( v3363(VarCurr,bitIndex1)
        <=> v1824(VarCurr,bitIndex48) )
        & ( v3363(VarCurr,bitIndex0)
        <=> v1824(VarCurr,bitIndex47) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_125,axiom,
    ! [VarCurr] :
      ( v2555(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v3363(VarCurr,B)
          <=> v3310(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_587,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3334(VarNext)
      <=> ( v3335(VarNext)
          & v3342(VarNext) ) ) ) ).

fof(addAssignment_780,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3342(VarNext)
      <=> v3340(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_586,axiom,
    ! [VarCurr] :
      ( v3340(VarCurr)
    <=> ( v3343(VarCurr)
        & v3347(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_585,axiom,
    ! [VarCurr] :
      ( v3347(VarCurr)
    <=> ( v3348(VarCurr)
        | v2541(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_584,axiom,
    ! [VarCurr] :
      ( v3348(VarCurr)
    <=> ( v3349(VarCurr)
        & v3357(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_583,axiom,
    ! [VarCurr] :
      ( v3357(VarCurr)
    <=> ( v3358(VarCurr)
        | v2545(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_582,axiom,
    ! [VarCurr] :
      ( v3358(VarCurr)
    <=> ( v2552(VarCurr)
        | v2544(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_581,axiom,
    ! [VarCurr] :
      ( v3349(VarCurr)
    <=> ( v3350(VarCurr)
        & v3355(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_580,axiom,
    ! [VarCurr] :
      ( v3355(VarCurr)
    <=> ( v56(VarCurr)
        | v3356(VarCurr) ) ) ).

fof(writeUnaryOperator_236,axiom,
    ! [VarCurr] :
      ( ~ v3356(VarCurr)
    <=> v2545(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_579,axiom,
    ! [VarCurr] :
      ( v3350(VarCurr)
    <=> ( v3351(VarCurr)
        & v3352(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_578,axiom,
    ! [VarCurr] :
      ( v3352(VarCurr)
    <=> ( v3353(VarCurr)
        | v3354(VarCurr) ) ) ).

fof(writeUnaryOperator_235,axiom,
    ! [VarCurr] :
      ( ~ v3354(VarCurr)
    <=> v2544(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_577,axiom,
    ! [VarCurr] :
      ( v3353(VarCurr)
    <=> ( v2555(VarCurr)
        | v2557(VarCurr) ) ) ).

fof(writeUnaryOperator_234,axiom,
    ! [VarCurr] :
      ( ~ v3351(VarCurr)
    <=> v2552(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_576,axiom,
    ! [VarCurr] :
      ( v3343(VarCurr)
    <=> ( v2541(VarCurr)
        | v3344(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_575,axiom,
    ! [VarCurr] :
      ( v3344(VarCurr)
    <=> ( v3345(VarCurr)
        & v3346(VarCurr) ) ) ).

fof(writeUnaryOperator_233,axiom,
    ! [VarCurr] :
      ( ~ v3346(VarCurr)
    <=> v2541(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_574,axiom,
    ! [VarCurr] :
      ( v3345(VarCurr)
    <=> ( v2544(VarCurr)
        | v2545(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_573,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3335(VarNext)
      <=> ( v3337(VarNext)
          & v125(VarNext) ) ) ) ).

fof(writeUnaryOperator_232,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3337(VarNext)
      <=> v990(VarNext) ) ) ).

fof(addAssignment_779,axiom,
    ! [VarCurr,B] :
      ( range_53_47(B)
     => ( v1824(VarCurr,B)
      <=> v1826(VarCurr,B) ) ) ).

fof(addAssignment_778,axiom,
    ! [VarCurr,B] :
      ( range_53_47(B)
     => ( v1826(VarCurr,B)
      <=> v1828(VarCurr,B) ) ) ).

fof(addAssignment_777,axiom,
    ! [VarCurr,B] :
      ( range_53_47(B)
     => ( v1828(VarCurr,B)
      <=> v1830(VarCurr,B) ) ) ).

fof(addAssignment_776,axiom,
    ! [VarCurr,B] :
      ( range_53_47(B)
     => ( v1830(VarCurr,B)
      <=> v1879(VarCurr,B) ) ) ).

fof(range_axiom_18,axiom,
    ! [B] :
      ( range_53_47(B)
    <=> ( $false
        | bitIndex47 = B
        | bitIndex48 = B
        | bitIndex49 = B
        | bitIndex50 = B
        | bitIndex51 = B
        | bitIndex52 = B
        | bitIndex53 = B ) ) ).

fof(addCaseBooleanConditionEqualRanges1_44,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3318(VarNext)
       => ! [B] :
            ( range_6_0(B)
           => ( v3310(VarNext,B)
            <=> v3310(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_49,axiom,
    ! [VarNext] :
      ( v3318(VarNext)
     => ! [B] :
          ( range_6_0(B)
         => ( v3310(VarNext,B)
          <=> v3329(VarNext,B) ) ) ) ).

fof(addAssignment_775,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_6_0(B)
         => ( v3329(VarNext,B)
          <=> v3327(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_91,axiom,
    ! [VarCurr] :
      ( ~ v997(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v3327(VarCurr,B)
          <=> v3312(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_93,axiom,
    ! [VarCurr] :
      ( v997(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v3327(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_572,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3318(VarNext)
      <=> ( v3319(VarNext)
          & v3326(VarNext) ) ) ) ).

fof(addAssignment_774,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3326(VarNext)
      <=> v3324(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_571,axiom,
    ! [VarCurr] :
      ( v3324(VarCurr)
    <=> ( v67(VarCurr)
        | v997(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_570,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3319(VarNext)
      <=> ( v3321(VarNext)
          & v125(VarNext) ) ) ) ).

fof(writeUnaryOperator_231,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3321(VarNext)
      <=> v990(VarNext) ) ) ).

fof(addAssignmentInitValueVector_44,axiom,
    ! [B] :
      ( range_6_0(B)
     => ( v3310(constB0,B)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_127,axiom,
    ! [VarCurr] :
      ( ~ v3314(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v3312(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_124,axiom,
    ! [VarCurr] :
      ( v3314(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v3312(VarCurr,B)
          <=> v720(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_569,axiom,
    ! [VarCurr] :
      ( v3314(VarCurr)
    <=> ( v2506(VarCurr)
        | v1032(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_568,axiom,
    ! [VarCurr] :
      ( v2506(VarCurr)
    <=> ( v2507(VarCurr)
        | v1029(VarCurr) ) ) ).

fof(addAssignment_773,axiom,
    ! [VarCurr] :
      ( v29(VarCurr)
    <=> v31(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_43,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3285(VarNext)
       => ( v31(VarNext)
        <=> v31(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_48,axiom,
    ! [VarNext] :
      ( v3285(VarNext)
     => ( v31(VarNext)
      <=> v3303(VarNext) ) ) ).

fof(addAssignment_772,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3303(VarNext)
      <=> v3301(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_90,axiom,
    ! [VarCurr] :
      ( ~ v3300(VarCurr)
     => ( v3301(VarCurr)
      <=> v3304(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_92,axiom,
    ! [VarCurr] :
      ( v3300(VarCurr)
     => ( v3301(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_89,axiom,
    ! [VarCurr] :
      ( ~ v37(VarCurr)
     => ( v3304(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_91,axiom,
    ! [VarCurr] :
      ( v37(VarCurr)
     => ( v3304(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_567,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3285(VarNext)
      <=> ( v3286(VarNext)
          & v3293(VarNext) ) ) ) ).

fof(addAssignment_771,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3293(VarNext)
      <=> v3291(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_566,axiom,
    ! [VarCurr] :
      ( v3291(VarCurr)
    <=> ( v3294(VarCurr)
        | v3300(VarCurr) ) ) ).

fof(writeUnaryOperator_230,axiom,
    ! [VarCurr] :
      ( ~ v3300(VarCurr)
    <=> v33(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_565,axiom,
    ! [VarCurr] :
      ( v3294(VarCurr)
    <=> ( v3295(VarCurr)
        | v37(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_564,axiom,
    ! [VarCurr] :
      ( v3295(VarCurr)
    <=> ( v3296(VarCurr)
        & v3299(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_324,axiom,
    ! [VarCurr] :
      ( v3299(VarCurr)
    <=> ( v613(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_563,axiom,
    ! [VarCurr] :
      ( v3296(VarCurr)
    <=> ( v3297(VarCurr)
        & v3298(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_323,axiom,
    ! [VarCurr] :
      ( v3298(VarCurr)
    <=> ( v509(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_322,axiom,
    ! [VarCurr] :
      ( v3297(VarCurr)
    <=> ( v514(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_562,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3286(VarNext)
      <=> ( v3287(VarNext)
          & v618(VarNext) ) ) ) ).

fof(writeUnaryOperator_229,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3287(VarNext)
      <=> v633(VarNext) ) ) ).

fof(addAssignment_770,axiom,
    ! [VarCurr] :
      ( v613(VarCurr,bitIndex0)
    <=> v643(VarCurr,bitIndex0) ) ).

fof(addAssignment_769,axiom,
    ! [VarNext] :
      ( v509(VarNext,bitIndex1)
    <=> v3276(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_42,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3277(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v3276(VarNext,B)
            <=> v509(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_47,axiom,
    ! [VarNext] :
      ( v3277(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v3276(VarNext,B)
          <=> v3107(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_561,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3277(VarNext)
      <=> v3278(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_560,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3278(VarNext)
      <=> ( v3280(VarNext)
          & v618(VarNext) ) ) ) ).

fof(writeUnaryOperator_228,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3280(VarNext)
      <=> v633(VarNext) ) ) ).

fof(addAssignment_768,axiom,
    ! [VarCurr] :
      ( v512(VarCurr,bitIndex1)
    <=> v3083(VarCurr,bitIndex1) ) ).

fof(addAssignment_767,axiom,
    ! [VarCurr] :
      ( v3078(VarCurr,bitIndex1)
    <=> v3079(VarCurr,bitIndex1) ) ).

fof(addAssignment_766,axiom,
    ! [VarNext] :
      ( v509(VarNext,bitIndex0)
    <=> v3268(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionEqualRanges1_41,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3269(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v3268(VarNext,B)
            <=> v509(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_46,axiom,
    ! [VarNext] :
      ( v3269(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v3268(VarNext,B)
          <=> v3107(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_559,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3269(VarNext)
      <=> v3270(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_558,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3270(VarNext)
      <=> ( v3272(VarNext)
          & v618(VarNext) ) ) ) ).

fof(writeUnaryOperator_227,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3272(VarNext)
      <=> v633(VarNext) ) ) ).

fof(addAssignment_765,axiom,
    ! [VarCurr] :
      ( v512(VarCurr,bitIndex0)
    <=> v3083(VarCurr,bitIndex0) ) ).

fof(addAssignment_764,axiom,
    ! [VarNext] :
      ( v509(VarNext,bitIndex2)
    <=> v3260(VarNext,bitIndex2) ) ).

fof(addCaseBooleanConditionEqualRanges1_40,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3261(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v3260(VarNext,B)
            <=> v509(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_45,axiom,
    ! [VarNext] :
      ( v3261(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v3260(VarNext,B)
          <=> v3107(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_557,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3261(VarNext)
      <=> v3262(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_556,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3262(VarNext)
      <=> ( v3264(VarNext)
          & v618(VarNext) ) ) ) ).

fof(writeUnaryOperator_226,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3264(VarNext)
      <=> v633(VarNext) ) ) ).

fof(addAssignment_763,axiom,
    ! [VarCurr] :
      ( v512(VarCurr,bitIndex2)
    <=> v3083(VarCurr,bitIndex2) ) ).

fof(addAssignment_762,axiom,
    ! [VarCurr] :
      ( v3078(VarCurr,bitIndex2)
    <=> v3079(VarCurr,bitIndex2) ) ).

fof(addAssignment_761,axiom,
    ! [VarCurr] :
      ( v37(VarCurr)
    <=> v39(VarCurr) ) ).

fof(addAssignment_760,axiom,
    ! [VarCurr] :
      ( v39(VarCurr)
    <=> v41(VarCurr) ) ).

fof(addAssignment_759,axiom,
    ! [VarCurr] :
      ( v41(VarCurr)
    <=> v43(VarCurr) ) ).

fof(addAssignment_758,axiom,
    ! [VarCurr] :
      ( v43(VarCurr)
    <=> v45(VarCurr) ) ).

fof(addAssignment_757,axiom,
    ! [VarCurr] :
      ( v45(VarCurr)
    <=> v47(VarCurr) ) ).

fof(addAssignment_756,axiom,
    ! [VarCurr] :
      ( v47(VarCurr)
    <=> v49(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_39,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3248(VarNext)
       => ( v49(VarNext)
        <=> v49(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_44,axiom,
    ! [VarNext] :
      ( v3248(VarNext)
     => ( v49(VarNext)
      <=> v3256(VarNext) ) ) ).

fof(addAssignment_755,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3256(VarNext)
      <=> v3254(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_88,axiom,
    ! [VarCurr] :
      ( ~ v1156(VarCurr)
     => ( v3254(VarCurr)
      <=> v56(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_90,axiom,
    ! [VarCurr] :
      ( v1156(VarCurr)
     => ( v3254(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_555,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3248(VarNext)
      <=> v3249(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_554,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3249(VarNext)
      <=> ( v3251(VarNext)
          & v125(VarNext) ) ) ) ).

fof(writeUnaryOperator_225,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3251(VarNext)
      <=> v990(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_24,axiom,
    ! [VarCurr] :
      ( ( ~ v2246(VarCurr)
        & ~ v2247(VarCurr)
        & ~ v2278(VarCurr) )
     => ( v56(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_50,axiom,
    ! [VarCurr] :
      ( v2278(VarCurr)
     => ( v56(VarCurr)
      <=> v3245(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_126,axiom,
    ! [VarCurr] :
      ( v2247(VarCurr)
     => ( v56(VarCurr)
      <=> v3239(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_123,axiom,
    ! [VarCurr] :
      ( v2246(VarCurr)
     => ( v56(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_125,axiom,
    ! [VarCurr] :
      ( ~ v3151(VarCurr)
     => ( v3245(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_122,axiom,
    ! [VarCurr] :
      ( v3151(VarCurr)
     => ( v3245(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_124,axiom,
    ! [VarCurr] :
      ( ~ v2249(VarCurr)
     => ( v3239(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_121,axiom,
    ! [VarCurr] :
      ( v2249(VarCurr)
     => ( v3239(VarCurr)
      <=> v3240(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_23,axiom,
    ! [VarCurr] :
      ( ( ~ v2251(VarCurr)
        & ~ v2253(VarCurr)
        & ~ v2267(VarCurr) )
     => ( v3240(VarCurr)
      <=> v3243(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_49,axiom,
    ! [VarCurr] :
      ( v2267(VarCurr)
     => ( v3240(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_123,axiom,
    ! [VarCurr] :
      ( v2253(VarCurr)
     => ( v3240(VarCurr)
      <=> v3241(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_120,axiom,
    ! [VarCurr] :
      ( v2251(VarCurr)
     => ( v3240(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_122,axiom,
    ! [VarCurr] :
      ( ~ v2272(VarCurr)
     => ( v3243(VarCurr)
      <=> v3244(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_119,axiom,
    ! [VarCurr] :
      ( v2272(VarCurr)
     => ( v3243(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_121,axiom,
    ! [VarCurr] :
      ( ~ v2275(VarCurr)
     => ( v3244(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_118,axiom,
    ! [VarCurr] :
      ( v2275(VarCurr)
     => ( v3244(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_120,axiom,
    ! [VarCurr] :
      ( ~ v3242(VarCurr)
     => ( v3241(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_117,axiom,
    ! [VarCurr] :
      ( v3242(VarCurr)
     => ( v3241(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_553,axiom,
    ! [VarCurr] :
      ( v3242(VarCurr)
    <=> ( v2257(VarCurr)
        | v2262(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_38,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3226(VarNext)
       => ! [B] :
            ( range_2_0(B)
           => ( v58(VarNext,B)
            <=> v58(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_43,axiom,
    ! [VarNext] :
      ( v3226(VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v58(VarNext,B)
          <=> v3234(VarNext,B) ) ) ) ).

fof(addAssignment_754,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v3234(VarNext,B)
          <=> v3232(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_87,axiom,
    ! [VarCurr] :
      ( ~ v3235(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3232(VarCurr,B)
          <=> v61(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_89,axiom,
    ! [VarCurr] :
      ( v3235(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3232(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_321,axiom,
    ! [VarCurr] :
      ( v3235(VarCurr)
    <=> ( v51(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_552,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3226(VarNext)
      <=> v3227(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_551,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3227(VarNext)
      <=> ( v3228(VarNext)
          & v125(VarNext) ) ) ) ).

fof(writeUnaryOperator_224,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3228(VarNext)
      <=> v990(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_22,axiom,
    ! [VarCurr] :
      ( ( ~ v3171(VarCurr)
        & ~ v3184(VarCurr)
        & ~ v3220(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v61(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_48,axiom,
    ! [VarCurr] :
      ( v3220(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v61(VarCurr,B)
          <=> v3221(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_119,axiom,
    ! [VarCurr] :
      ( v3184(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v61(VarCurr,B)
          <=> v3185(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_116,axiom,
    ! [VarCurr] :
      ( v3171(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v61(VarCurr,B)
          <=> v3172(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_118,axiom,
    ! [VarCurr] :
      ( ~ v3222(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3221(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_115,axiom,
    ! [VarCurr] :
      ( v3222(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3221(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_320,axiom,
    ! [VarCurr] :
      ( v3223(VarCurr)
    <=> ( v495(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_319,axiom,
    ! [VarCurr] :
      ( v3222(VarCurr)
    <=> ( v495(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_318,axiom,
    ! [VarCurr] :
      ( v3220(VarCurr)
    <=> ( ( v58(VarCurr,bitIndex2)
        <=> $false )
        & ( v58(VarCurr,bitIndex1)
        <=> $true )
        & ( v58(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_117,axiom,
    ! [VarCurr] :
      ( ~ v3186(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3185(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_114,axiom,
    ! [VarCurr] :
      ( v3186(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3185(VarCurr,B)
          <=> v3187(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_317,axiom,
    ! [VarCurr] :
      ( v3219(VarCurr)
    <=> ( v495(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_21,axiom,
    ! [VarCurr] :
      ( ( ~ v3188(VarCurr)
        & ~ v3193(VarCurr)
        & ~ v3206(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v3187(VarCurr,B)
          <=> v3213(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_47,axiom,
    ! [VarCurr] :
      ( v3206(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3187(VarCurr,B)
          <=> v3208(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_116,axiom,
    ! [VarCurr] :
      ( v3193(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3187(VarCurr,B)
          <=> v3195(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_113,axiom,
    ! [VarCurr] :
      ( v3188(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3187(VarCurr,B)
          <=> v3190(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_115,axiom,
    ! [VarCurr] :
      ( ~ v3214(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3213(VarCurr,B)
          <=> v3216(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_112,axiom,
    ! [VarCurr] :
      ( v3214(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3213(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_114,axiom,
    ! [VarCurr] :
      ( ~ v3217(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3216(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_111,axiom,
    ! [VarCurr] :
      ( v3217(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3216(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_316,axiom,
    ! [VarCurr] :
      ( v3218(VarCurr)
    <=> ( v2206(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_315,axiom,
    ! [VarCurr] :
      ( v3217(VarCurr)
    <=> ( v2206(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_314,axiom,
    ! [VarCurr] :
      ( v3215(VarCurr)
    <=> ( v1818(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_313,axiom,
    ! [VarCurr] :
      ( v3214(VarCurr)
    <=> ( v1818(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_312,axiom,
    ! [VarCurr] :
      ( v3211(VarCurr)
    <=> ( ( v3212(VarCurr,bitIndex1)
        <=> $true )
        & ( v3212(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_753,axiom,
    ! [VarCurr] :
      ( v3212(VarCurr,bitIndex0)
    <=> v2237(VarCurr) ) ).

fof(addAssignment_752,axiom,
    ! [VarCurr] :
      ( v3212(VarCurr,bitIndex1)
    <=> v706(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_113,axiom,
    ! [VarCurr] :
      ( ~ v3209(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3208(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_110,axiom,
    ! [VarCurr] :
      ( v3209(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3208(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_311,axiom,
    ! [VarCurr] :
      ( v3210(VarCurr)
    <=> ( v2206(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_310,axiom,
    ! [VarCurr] :
      ( v3209(VarCurr)
    <=> ( v2206(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_309,axiom,
    ! [VarCurr] :
      ( v3206(VarCurr)
    <=> ( ( v3207(VarCurr,bitIndex1)
        <=> $true )
        & ( v3207(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_751,axiom,
    ! [VarCurr] :
      ( v3207(VarCurr,bitIndex0)
    <=> v2237(VarCurr) ) ).

fof(addAssignment_750,axiom,
    ! [VarCurr] :
      ( v3207(VarCurr,bitIndex1)
    <=> v706(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_46,axiom,
    ! [VarCurr] :
      ( ( ~ v3196(VarCurr)
        & ~ v3201(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v3195(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_112,axiom,
    ! [VarCurr] :
      ( v3201(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3195(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_109,axiom,
    ! [VarCurr] :
      ( v3196(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3195(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_550,axiom,
    ! [VarCurr] :
      ( v3201(VarCurr)
    <=> ( v3202(VarCurr)
        | v3204(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_308,axiom,
    ! [VarCurr] :
      ( v3204(VarCurr)
    <=> ( ( v3205(VarCurr,bitIndex3)
        <=> $false )
        & ( v3205(VarCurr,bitIndex2)
        <=> $true )
        & ( v3205(VarCurr,bitIndex1)
        <=> $false )
        & ( v3205(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_749,axiom,
    ! [VarCurr] :
      ( v3205(VarCurr,bitIndex0)
    <=> v2006(VarCurr) ) ).

fof(addAssignment_748,axiom,
    ! [VarCurr] :
      ( ( v3205(VarCurr,bitIndex3)
      <=> v983(VarCurr,bitIndex2) )
      & ( v3205(VarCurr,bitIndex2)
      <=> v983(VarCurr,bitIndex1) )
      & ( v3205(VarCurr,bitIndex1)
      <=> v983(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_307,axiom,
    ! [VarCurr] :
      ( v3202(VarCurr)
    <=> ( ( v3203(VarCurr,bitIndex3)
        <=> $false )
        & ( v3203(VarCurr,bitIndex2)
        <=> $false )
        & ( v3203(VarCurr,bitIndex1)
        <=> $true )
        & ( v3203(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_747,axiom,
    ! [VarCurr] :
      ( v3203(VarCurr,bitIndex0)
    <=> v2006(VarCurr) ) ).

fof(addAssignment_746,axiom,
    ! [VarCurr] :
      ( ( v3203(VarCurr,bitIndex3)
      <=> v983(VarCurr,bitIndex2) )
      & ( v3203(VarCurr,bitIndex2)
      <=> v983(VarCurr,bitIndex1) )
      & ( v3203(VarCurr,bitIndex1)
      <=> v983(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_549,axiom,
    ! [VarCurr] :
      ( v3196(VarCurr)
    <=> ( v3197(VarCurr)
        | v3199(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_306,axiom,
    ! [VarCurr] :
      ( v3199(VarCurr)
    <=> ( ( v3200(VarCurr,bitIndex3)
        <=> $false )
        & ( v3200(VarCurr,bitIndex2)
        <=> $true )
        & ( v3200(VarCurr,bitIndex1)
        <=> $false )
        & ( v3200(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_745,axiom,
    ! [VarCurr] :
      ( v3200(VarCurr,bitIndex0)
    <=> v2006(VarCurr) ) ).

fof(addAssignment_744,axiom,
    ! [VarCurr] :
      ( ( v3200(VarCurr,bitIndex3)
      <=> v983(VarCurr,bitIndex2) )
      & ( v3200(VarCurr,bitIndex2)
      <=> v983(VarCurr,bitIndex1) )
      & ( v3200(VarCurr,bitIndex1)
      <=> v983(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_305,axiom,
    ! [VarCurr] :
      ( v3197(VarCurr)
    <=> ( ( v3198(VarCurr,bitIndex3)
        <=> $false )
        & ( v3198(VarCurr,bitIndex2)
        <=> $false )
        & ( v3198(VarCurr,bitIndex1)
        <=> $true )
        & ( v3198(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_743,axiom,
    ! [VarCurr] :
      ( v3198(VarCurr,bitIndex0)
    <=> v2006(VarCurr) ) ).

fof(addAssignment_742,axiom,
    ! [VarCurr] :
      ( ( v3198(VarCurr,bitIndex3)
      <=> v983(VarCurr,bitIndex2) )
      & ( v3198(VarCurr,bitIndex2)
      <=> v983(VarCurr,bitIndex1) )
      & ( v3198(VarCurr,bitIndex1)
      <=> v983(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_304,axiom,
    ! [VarCurr] :
      ( v3193(VarCurr)
    <=> ( ( v3194(VarCurr,bitIndex1)
        <=> $false )
        & ( v3194(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_741,axiom,
    ! [VarCurr] :
      ( v3194(VarCurr,bitIndex0)
    <=> v2237(VarCurr) ) ).

fof(addAssignment_740,axiom,
    ! [VarCurr] :
      ( v3194(VarCurr,bitIndex1)
    <=> v706(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_111,axiom,
    ! [VarCurr] :
      ( ~ v3191(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3190(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_108,axiom,
    ! [VarCurr] :
      ( v3191(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3190(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_303,axiom,
    ! [VarCurr] :
      ( v3192(VarCurr)
    <=> ( v2206(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_302,axiom,
    ! [VarCurr] :
      ( v3191(VarCurr)
    <=> ( v2206(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_301,axiom,
    ! [VarCurr] :
      ( v3188(VarCurr)
    <=> ( ( v3189(VarCurr,bitIndex1)
        <=> $false )
        & ( v3189(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_739,axiom,
    ! [VarCurr] :
      ( v3189(VarCurr,bitIndex0)
    <=> v2237(VarCurr) ) ).

fof(addAssignment_738,axiom,
    ! [VarCurr] :
      ( v3189(VarCurr,bitIndex1)
    <=> v706(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_300,axiom,
    ! [VarCurr] :
      ( v3186(VarCurr)
    <=> ( v495(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_299,axiom,
    ! [VarCurr] :
      ( v3184(VarCurr)
    <=> ( ( v58(VarCurr,bitIndex2)
        <=> $false )
        & ( v58(VarCurr,bitIndex1)
        <=> $true )
        & ( v58(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_110,axiom,
    ! [VarCurr] :
      ( ~ v3173(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3172(VarCurr,B)
          <=> v3175(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_107,axiom,
    ! [VarCurr] :
      ( v3173(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3172(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_45,axiom,
    ! [VarCurr] :
      ( ( ~ v3176(VarCurr)
        & ~ v3181(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v3175(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_109,axiom,
    ! [VarCurr] :
      ( v3181(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3175(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_106,axiom,
    ! [VarCurr] :
      ( v3176(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3175(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_548,axiom,
    ! [VarCurr] :
      ( v3181(VarCurr)
    <=> ( v3182(VarCurr)
        | v3183(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_298,axiom,
    ! [VarCurr] :
      ( v3183(VarCurr)
    <=> ( ( v983(VarCurr,bitIndex2)
        <=> $false )
        & ( v983(VarCurr,bitIndex1)
        <=> $true )
        & ( v983(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_297,axiom,
    ! [VarCurr] :
      ( v3182(VarCurr)
    <=> ( ( v983(VarCurr,bitIndex2)
        <=> $false )
        & ( v983(VarCurr,bitIndex1)
        <=> $false )
        & ( v983(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_547,axiom,
    ! [VarCurr] :
      ( v3176(VarCurr)
    <=> ( v3177(VarCurr)
        | v3180(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_296,axiom,
    ! [VarCurr] :
      ( v3180(VarCurr)
    <=> ( ( v983(VarCurr,bitIndex2)
        <=> $true )
        & ( v983(VarCurr,bitIndex1)
        <=> $false )
        & ( v983(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_546,axiom,
    ! [VarCurr] :
      ( v3177(VarCurr)
    <=> ( v3178(VarCurr)
        | v3179(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_295,axiom,
    ! [VarCurr] :
      ( v3179(VarCurr)
    <=> ( ( v983(VarCurr,bitIndex2)
        <=> $false )
        & ( v983(VarCurr,bitIndex1)
        <=> $true )
        & ( v983(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_294,axiom,
    ! [VarCurr] :
      ( v3178(VarCurr)
    <=> ( ( v983(VarCurr,bitIndex2)
        <=> $true )
        & ( v983(VarCurr,bitIndex1)
        <=> $false )
        & ( v983(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_293,axiom,
    ! [VarCurr] :
      ( v3174(VarCurr)
    <=> ( v63(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_292,axiom,
    ! [VarCurr] :
      ( v3173(VarCurr)
    <=> ( v63(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_291,axiom,
    ! [VarCurr] :
      ( v3171(VarCurr)
    <=> ( ( v58(VarCurr,bitIndex2)
        <=> $false )
        & ( v58(VarCurr,bitIndex1)
        <=> $false )
        & ( v58(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeUnaryOperator_223,axiom,
    ! [VarCurr] :
      ( ~ v63(VarCurr)
    <=> v65(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_37,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3155(VarNext)
       => ( v65(VarNext)
        <=> v65(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_42,axiom,
    ! [VarNext] :
      ( v3155(VarNext)
     => ( v65(VarNext)
      <=> v3163(VarNext) ) ) ).

fof(addAssignment_737,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3163(VarNext)
      <=> v3161(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_86,axiom,
    ! [VarCurr] :
      ( ~ v1156(VarCurr)
     => ( v3161(VarCurr)
      <=> v3164(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_88,axiom,
    ! [VarCurr] :
      ( v1156(VarCurr)
     => ( v3161(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_85,axiom,
    ! [VarCurr] :
      ( ~ v67(VarCurr)
     => ( v3164(VarCurr)
      <=> v3165(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_87,axiom,
    ! [VarCurr] :
      ( v67(VarCurr)
     => ( v3164(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_545,axiom,
    ! [VarCurr] :
      ( v3165(VarCurr)
    <=> ( v3166(VarCurr)
        & v65(VarCurr) ) ) ).

fof(writeUnaryOperator_222,axiom,
    ! [VarCurr] :
      ( ~ v3166(VarCurr)
    <=> v3139(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_544,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3155(VarNext)
      <=> v3156(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_543,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3156(VarNext)
      <=> ( v3158(VarNext)
          & v125(VarNext) ) ) ) ).

fof(writeUnaryOperator_221,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3158(VarNext)
      <=> v990(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_20,axiom,
    ! [VarCurr] :
      ( ( ~ v2246(VarCurr)
        & ~ v2247(VarCurr)
        & ~ v2278(VarCurr) )
     => ( v3139(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_44,axiom,
    ! [VarCurr] :
      ( v2278(VarCurr)
     => ( v3139(VarCurr)
      <=> v3150(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_108,axiom,
    ! [VarCurr] :
      ( v2247(VarCurr)
     => ( v3139(VarCurr)
      <=> v3141(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_105,axiom,
    ! [VarCurr] :
      ( v2246(VarCurr)
     => ( v3139(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_107,axiom,
    ! [VarCurr] :
      ( ~ v3151(VarCurr)
     => ( v3150(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_104,axiom,
    ! [VarCurr] :
      ( v3151(VarCurr)
     => ( v3150(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_290,axiom,
    ! [VarCurr] :
      ( v3152(VarCurr)
    <=> ( v495(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_289,axiom,
    ! [VarCurr] :
      ( v3151(VarCurr)
    <=> ( v495(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_106,axiom,
    ! [VarCurr] :
      ( ~ v2249(VarCurr)
     => ( v3141(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_103,axiom,
    ! [VarCurr] :
      ( v2249(VarCurr)
     => ( v3141(VarCurr)
      <=> v3142(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_19,axiom,
    ! [VarCurr] :
      ( ( ~ v2251(VarCurr)
        & ~ v2253(VarCurr)
        & ~ v2267(VarCurr) )
     => ( v3142(VarCurr)
      <=> v3148(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_43,axiom,
    ! [VarCurr] :
      ( v2267(VarCurr)
     => ( v3142(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_105,axiom,
    ! [VarCurr] :
      ( v2253(VarCurr)
     => ( v3142(VarCurr)
      <=> v3146(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_102,axiom,
    ! [VarCurr] :
      ( v2251(VarCurr)
     => ( v3142(VarCurr)
      <=> v3143(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_104,axiom,
    ! [VarCurr] :
      ( ~ v2272(VarCurr)
     => ( v3148(VarCurr)
      <=> v3149(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_101,axiom,
    ! [VarCurr] :
      ( v2272(VarCurr)
     => ( v3148(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_103,axiom,
    ! [VarCurr] :
      ( ~ v2275(VarCurr)
     => ( v3149(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_100,axiom,
    ! [VarCurr] :
      ( v2275(VarCurr)
     => ( v3149(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_102,axiom,
    ! [VarCurr] :
      ( ~ v3147(VarCurr)
     => ( v3146(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_99,axiom,
    ! [VarCurr] :
      ( v3147(VarCurr)
     => ( v3146(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_542,axiom,
    ! [VarCurr] :
      ( v3147(VarCurr)
    <=> ( v2257(VarCurr)
        | v2262(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_101,axiom,
    ! [VarCurr] :
      ( ~ v3144(VarCurr)
     => ( v3143(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_98,axiom,
    ! [VarCurr] :
      ( v3144(VarCurr)
     => ( v3143(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_288,axiom,
    ! [VarCurr] :
      ( v3145(VarCurr)
    <=> ( v2206(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_287,axiom,
    ! [VarCurr] :
      ( v3144(VarCurr)
    <=> ( v2206(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_42,axiom,
    ! [VarCurr] :
      ( ( ~ v109(VarCurr)
        & ~ v110(VarCurr) )
     => ( v67(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_100,axiom,
    ! [VarCurr] :
      ( v110(VarCurr)
     => ( v67(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_97,axiom,
    ! [VarCurr] :
      ( v109(VarCurr)
     => ( v67(VarCurr)
      <=> v3136(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_99,axiom,
    ! [VarCurr] :
      ( ~ v960(VarCurr)
     => ( v3136(VarCurr)
      <=> v3137(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_96,axiom,
    ! [VarCurr] :
      ( v960(VarCurr)
     => ( v3136(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_98,axiom,
    ! [VarCurr] :
      ( ~ v963(VarCurr)
     => ( v3137(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_95,axiom,
    ! [VarCurr] :
      ( v963(VarCurr)
     => ( v3137(VarCurr)
      <=> $false ) ) ).

fof(addCaseBooleanConditionEqualRanges1_36,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3123(VarNext)
       => ! [B] :
            ( range_1_0(B)
           => ( v69(VarNext,B)
            <=> v69(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_41,axiom,
    ! [VarNext] :
      ( v3123(VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v69(VarNext,B)
          <=> v3131(VarNext,B) ) ) ) ).

fof(addAssignment_736,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v3131(VarNext,B)
          <=> v3129(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_84,axiom,
    ! [VarCurr] :
      ( ~ v3132(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v3129(VarCurr,B)
          <=> v72(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_86,axiom,
    ! [VarCurr] :
      ( v3132(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v3129(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_286,axiom,
    ! [VarCurr] :
      ( v3132(VarCurr)
    <=> ( v51(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_541,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3123(VarNext)
      <=> v3124(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_540,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3124(VarNext)
      <=> ( v3125(VarNext)
          & v125(VarNext) ) ) ) ).

fof(writeUnaryOperator_220,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3125(VarNext)
      <=> v990(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_41,axiom,
    ! [VarCurr] :
      ( ( ~ v3111(VarCurr)
        & ~ v3120(VarCurr) )
     => ! [B] :
          ( range_1_0(B)
         => ( v72(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_97,axiom,
    ! [VarCurr] :
      ( v3120(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v72(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_94,axiom,
    ! [VarCurr] :
      ( v3111(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v72(VarCurr,B)
          <=> v3112(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_285,axiom,
    ! [VarCurr] :
      ( v3120(VarCurr)
    <=> ( ( v69(VarCurr,bitIndex1)
        <=> $false )
        & ( v69(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_96,axiom,
    ! [VarCurr] :
      ( ~ v3113(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v3112(VarCurr,B)
          <=> v3115(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_93,axiom,
    ! [VarCurr] :
      ( v3113(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v3112(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_95,axiom,
    ! [VarCurr] :
      ( ~ v3116(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v3115(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_92,axiom,
    ! [VarCurr] :
      ( v3116(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v3115(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_284,axiom,
    ! [VarCurr] :
      ( v3118(VarCurr)
    <=> ( v3119(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_539,axiom,
    ! [VarCurr] :
      ( v3119(VarCurr)
    <=> ( v65(VarCurr)
        | v495(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_283,axiom,
    ! [VarCurr] :
      ( v3116(VarCurr)
    <=> ( v3117(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_538,axiom,
    ! [VarCurr] :
      ( v3117(VarCurr)
    <=> ( v65(VarCurr)
        | v495(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_282,axiom,
    ! [VarCurr] :
      ( v3114(VarCurr)
    <=> ( v74(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_281,axiom,
    ! [VarCurr] :
      ( v3113(VarCurr)
    <=> ( v74(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_280,axiom,
    ! [VarCurr] :
      ( v3111(VarCurr)
    <=> ( ( v69(VarCurr,bitIndex1)
        <=> $false )
        & ( v69(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_735,axiom,
    ! [VarCurr] :
      ( v495(VarCurr)
    <=> v497(VarCurr) ) ).

fof(addAssignment_734,axiom,
    ! [VarCurr] :
      ( v497(VarCurr)
    <=> v499(VarCurr) ) ).

fof(addAssignment_733,axiom,
    ! [VarCurr] :
      ( v499(VarCurr)
    <=> v501(VarCurr) ) ).

fof(addAssignment_732,axiom,
    ! [VarCurr] :
      ( v501(VarCurr)
    <=> v503(VarCurr) ) ).

fof(addAssignment_731,axiom,
    ! [VarCurr] :
      ( v503(VarCurr)
    <=> v505(VarCurr) ) ).

fof(addAssignment_730,axiom,
    ! [VarCurr] :
      ( v505(VarCurr)
    <=> v507(VarCurr) ) ).

fof(addAssignment_729,axiom,
    ! [VarCurr] :
      ( v507(VarCurr)
    <=> v509(VarCurr,bitIndex6) ) ).

fof(addAssignment_728,axiom,
    ! [VarNext] :
      ( v509(VarNext,bitIndex6)
    <=> v3098(VarNext,bitIndex6) ) ).

fof(addCaseBooleanConditionEqualRanges1_35,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3099(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v3098(VarNext,B)
            <=> v509(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_40,axiom,
    ! [VarNext] :
      ( v3099(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v3098(VarNext,B)
          <=> v3107(VarNext,B) ) ) ) ).

fof(addAssignment_727,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v3107(VarNext,B)
          <=> v3105(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_83,axiom,
    ! [VarCurr] :
      ( ~ v640(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v3105(VarCurr,B)
          <=> v512(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_85,axiom,
    ! [VarCurr] :
      ( v640(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v3105(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_537,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3099(VarNext)
      <=> v3100(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_536,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3100(VarNext)
      <=> ( v3102(VarNext)
          & v618(VarNext) ) ) ) ).

fof(writeUnaryOperator_219,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3102(VarNext)
      <=> v633(VarNext) ) ) ).

fof(addAssignment_726,axiom,
    ! [VarCurr] :
      ( v512(VarCurr,bitIndex6)
    <=> v3083(VarCurr,bitIndex6) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_82,axiom,
    ! [VarCurr] :
      ( ~ v3084(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v3083(VarCurr,B)
          <=> v3085(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_84,axiom,
    ! [VarCurr] :
      ( v3084(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v3083(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_18,axiom,
    ! [VarCurr] :
      ( ( ~ v3086(VarCurr)
        & ~ v3088(VarCurr)
        & ~ v3092(VarCurr) )
     => ! [B] :
          ( range_7_0(B)
         => ( v3085(VarCurr,B)
          <=> v509(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_40,axiom,
    ! [VarCurr] :
      ( v3092(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v3085(VarCurr,B)
          <=> v3094(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_94,axiom,
    ! [VarCurr] :
      ( v3088(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v3085(VarCurr,B)
          <=> v3090(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_91,axiom,
    ! [VarCurr] :
      ( v3086(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v3085(VarCurr,B)
          <=> v509(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_279,axiom,
    ! [VarCurr] :
      ( v3095(VarCurr)
    <=> ( ( v3096(VarCurr,bitIndex1)
        <=> $true )
        & ( v3096(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_725,axiom,
    ! [VarCurr] :
      ( v3096(VarCurr,bitIndex0)
    <=> v514(VarCurr) ) ).

fof(addAssignment_724,axiom,
    ! [VarCurr] :
      ( v3096(VarCurr,bitIndex1)
    <=> v37(VarCurr) ) ).

fof(addAssignment_723,axiom,
    ! [VarCurr] :
      ( v3094(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_722,axiom,
    ! [VarCurr,B] :
      ( range_7_1(B)
     => ( v3094(VarCurr,B)
      <=> v3078(VarCurr,B) ) ) ).

fof(range_axiom_17,axiom,
    ! [B] :
      ( range_7_1(B)
    <=> ( $false
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B ) ) ).

fof(addBitVectorEqualityBitBlasted_278,axiom,
    ! [VarCurr] :
      ( v3092(VarCurr)
    <=> ( ( v3093(VarCurr,bitIndex1)
        <=> $true )
        & ( v3093(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_721,axiom,
    ! [VarCurr] :
      ( v3093(VarCurr,bitIndex0)
    <=> v514(VarCurr) ) ).

fof(addAssignment_720,axiom,
    ! [VarCurr] :
      ( v3093(VarCurr,bitIndex1)
    <=> v37(VarCurr) ) ).

fof(addAssignment_719,axiom,
    ! [VarCurr] :
      ( ( v3090(VarCurr,bitIndex6)
      <=> v509(VarCurr,bitIndex7) )
      & ( v3090(VarCurr,bitIndex5)
      <=> v509(VarCurr,bitIndex6) )
      & ( v3090(VarCurr,bitIndex4)
      <=> v509(VarCurr,bitIndex5) )
      & ( v3090(VarCurr,bitIndex3)
      <=> v509(VarCurr,bitIndex4) )
      & ( v3090(VarCurr,bitIndex2)
      <=> v509(VarCurr,bitIndex3) )
      & ( v3090(VarCurr,bitIndex1)
      <=> v509(VarCurr,bitIndex2) )
      & ( v3090(VarCurr,bitIndex0)
      <=> v509(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_718,axiom,
    ! [VarCurr] :
      ( v3090(VarCurr,bitIndex7)
    <=> $false ) ).

fof(addBitVectorEqualityBitBlasted_277,axiom,
    ! [VarCurr] :
      ( v3088(VarCurr)
    <=> ( ( v3089(VarCurr,bitIndex1)
        <=> $false )
        & ( v3089(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_717,axiom,
    ! [VarCurr] :
      ( v3089(VarCurr,bitIndex0)
    <=> v514(VarCurr) ) ).

fof(addAssignment_716,axiom,
    ! [VarCurr] :
      ( v3089(VarCurr,bitIndex1)
    <=> v37(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_276,axiom,
    ! [VarCurr] :
      ( v3086(VarCurr)
    <=> ( ( v3087(VarCurr,bitIndex1)
        <=> $false )
        & ( v3087(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_715,axiom,
    ! [VarCurr] :
      ( v3087(VarCurr,bitIndex0)
    <=> v514(VarCurr) ) ).

fof(addAssignment_714,axiom,
    ! [VarCurr] :
      ( v3087(VarCurr,bitIndex1)
    <=> v37(VarCurr) ) ).

fof(writeUnaryOperator_218,axiom,
    ! [VarCurr] :
      ( ~ v3084(VarCurr)
    <=> v33(VarCurr) ) ).

fof(addAssignment_713,axiom,
    ! [VarCurr] :
      ( v3078(VarCurr,bitIndex6)
    <=> v3079(VarCurr,bitIndex6) ) ).

fof(addAssignment_712,axiom,
    ! [VarCurr] :
      ( v3079(VarCurr,bitIndex0)
    <=> $false ) ).

fof(addAssignment_711,axiom,
    ! [VarCurr] :
      ( ( v3079(VarCurr,bitIndex7)
      <=> v509(VarCurr,bitIndex6) )
      & ( v3079(VarCurr,bitIndex6)
      <=> v509(VarCurr,bitIndex5) )
      & ( v3079(VarCurr,bitIndex5)
      <=> v509(VarCurr,bitIndex4) )
      & ( v3079(VarCurr,bitIndex4)
      <=> v509(VarCurr,bitIndex3) )
      & ( v3079(VarCurr,bitIndex3)
      <=> v509(VarCurr,bitIndex2) )
      & ( v3079(VarCurr,bitIndex2)
      <=> v509(VarCurr,bitIndex1) )
      & ( v3079(VarCurr,bitIndex1)
      <=> v509(VarCurr,bitIndex0) ) ) ).

fof(addAssignmentInitValue_151,axiom,
    ~ v509(constB0,bitIndex7) ).

fof(addAssignmentInitValue_150,axiom,
    ~ v509(constB0,bitIndex6) ).

fof(addAssignmentInitValue_149,axiom,
    ~ v509(constB0,bitIndex5) ).

fof(addAssignmentInitValue_148,axiom,
    ~ v509(constB0,bitIndex3) ).

fof(addAssignmentInitValue_147,axiom,
    ~ v509(constB0,bitIndex2) ).

fof(addAssignmentInitValue_146,axiom,
    ~ v509(constB0,bitIndex1) ).

fof(addAssignmentInitValue_145,axiom,
    ~ v509(constB0,bitIndex0) ).

fof(bitBlastConstant_891,axiom,
    ~ b000x0000(bitIndex7) ).

fof(bitBlastConstant_890,axiom,
    ~ b000x0000(bitIndex6) ).

fof(bitBlastConstant_889,axiom,
    ~ b000x0000(bitIndex5) ).

fof(bitBlastConstant_888,axiom,
    ~ b000x0000(bitIndex3) ).

fof(bitBlastConstant_887,axiom,
    ~ b000x0000(bitIndex2) ).

fof(bitBlastConstant_886,axiom,
    ~ b000x0000(bitIndex1) ).

fof(bitBlastConstant_885,axiom,
    ~ b000x0000(bitIndex0) ).

fof(addAssignment_710,axiom,
    ! [VarCurr] :
      ( v514(VarCurr)
    <=> v516(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_535,axiom,
    ! [VarCurr] :
      ( v516(VarCurr)
    <=> ( v3076(VarCurr)
        | v3071(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_534,axiom,
    ! [VarCurr] :
      ( v3076(VarCurr)
    <=> ( v518(VarCurr)
        | v548(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_81,axiom,
    ! [VarCurr] :
      ( ~ v3073(VarCurr)
     => ( v3071(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_83,axiom,
    ! [VarCurr] :
      ( v3073(VarCurr)
     => ( v3071(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_533,axiom,
    ! [VarCurr] :
      ( v3073(VarCurr)
    <=> ( v3074(VarCurr)
        & v2931(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_532,axiom,
    ! [VarCurr] :
      ( v3074(VarCurr)
    <=> ( v3047(VarCurr)
        & v2930(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_80,axiom,
    ! [VarCurr] :
      ( ~ v3068(VarCurr)
     => ( v518(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_82,axiom,
    ! [VarCurr] :
      ( v3068(VarCurr)
     => ( v518(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_531,axiom,
    ! [VarCurr] :
      ( v3068(VarCurr)
    <=> ( v3069(VarCurr)
        & v2931(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_530,axiom,
    ! [VarCurr] :
      ( v3069(VarCurr)
    <=> ( v2961(VarCurr)
        & v2930(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_34,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3056(VarNext)
       => ( v520(VarNext,bitIndex0)
        <=> v520(VarCurr,bitIndex0) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_39,axiom,
    ! [VarNext] :
      ( v3056(VarNext)
     => ( v520(VarNext,bitIndex0)
      <=> v3064(VarNext) ) ) ).

fof(addAssignment_709,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3064(VarNext)
      <=> v3062(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_79,axiom,
    ! [VarCurr] :
      ( ~ v2952(VarCurr)
     => ( v3062(VarCurr)
      <=> v522(VarCurr,bitIndex0) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_81,axiom,
    ! [VarCurr] :
      ( v2952(VarCurr)
     => ( v3062(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_529,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3056(VarNext)
      <=> v3057(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_528,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3057(VarNext)
      <=> ( v3059(VarNext)
          & v620(VarNext) ) ) ) ).

fof(writeUnaryOperator_217,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3059(VarNext)
      <=> v2945(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_78,axiom,
    ! [VarCurr] :
      ( ~ v3038(VarCurr)
     => ( v522(VarCurr,bitIndex0)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_80,axiom,
    ! [VarCurr] :
      ( v3038(VarCurr)
     => ( v522(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_527,axiom,
    ! [VarCurr] :
      ( v3038(VarCurr)
    <=> ( v3039(VarCurr)
        | v3052(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_526,axiom,
    ! [VarCurr] :
      ( v3052(VarCurr)
    <=> ( v3053(VarCurr)
        & v2966(VarCurr) ) ) ).

fof(writeUnaryOperator_216,axiom,
    ! [VarCurr] :
      ( ~ v3053(VarCurr)
    <=> v524(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_525,axiom,
    ! [VarCurr] :
      ( v3039(VarCurr)
    <=> ( v3040(VarCurr)
        | v3051(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_524,axiom,
    ! [VarCurr] :
      ( v3051(VarCurr)
    <=> ( v2983(VarCurr)
        & v2938(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_523,axiom,
    ! [VarCurr] :
      ( v3040(VarCurr)
    <=> ( v3041(VarCurr)
        & v2931(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_522,axiom,
    ! [VarCurr] :
      ( v3041(VarCurr)
    <=> ( v3042(VarCurr)
        | v3050(VarCurr) ) ) ).

fof(writeUnaryOperator_215,axiom,
    ! [VarCurr] :
      ( ~ v3050(VarCurr)
    <=> v2930(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_521,axiom,
    ! [VarCurr] :
      ( v3042(VarCurr)
    <=> ( v3043(VarCurr)
        & v2930(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_520,axiom,
    ! [VarCurr] :
      ( v3043(VarCurr)
    <=> ( v3044(VarCurr)
        | v3048(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_519,axiom,
    ! [VarCurr] :
      ( v3048(VarCurr)
    <=> ( v3049(VarCurr)
        & v2929(VarCurr) ) ) ).

fof(writeUnaryOperator_214,axiom,
    ! [VarCurr] :
      ( ~ v3049(VarCurr)
    <=> v541(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_518,axiom,
    ! [VarCurr] :
      ( v3044(VarCurr)
    <=> ( v3045(VarCurr)
        | v3047(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_275,axiom,
    ! [VarCurr] :
      ( v3047(VarCurr)
    <=> ( ( v27(VarCurr,bitIndex1)
        <=> $false )
        & ( v27(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_517,axiom,
    ! [VarCurr] :
      ( v3045(VarCurr)
    <=> ( v3046(VarCurr)
        & v2961(VarCurr) ) ) ).

fof(writeUnaryOperator_213,axiom,
    ! [VarCurr] :
      ( ~ v3046(VarCurr)
    <=> v524(VarCurr) ) ).

fof(writeUnaryOperator_212,axiom,
    ! [VarCurr] :
      ( ~ v524(VarCurr)
    <=> v3036(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_48,axiom,
    ! [VarCurr] :
      ( v3036(VarCurr)
    <=> ( v3014(VarCurr)
        | v526(VarCurr,bitIndex2) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_33,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3022(VarNext)
       => ! [B] :
            ( range_2_0(B)
           => ( v526(VarNext,B)
            <=> v526(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_38,axiom,
    ! [VarNext] :
      ( v3022(VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v526(VarNext,B)
          <=> v3030(VarNext,B) ) ) ) ).

fof(addAssignment_708,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v3030(VarNext,B)
          <=> v3028(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_77,axiom,
    ! [VarCurr] :
      ( ~ v3031(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3028(VarCurr,B)
          <=> v529(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_79,axiom,
    ! [VarCurr] :
      ( v3031(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3028(VarCurr,B)
          <=> b100(B) ) ) ) ).

fof(writeUnaryOperator_211,axiom,
    ! [VarCurr] :
      ( ~ v3031(VarCurr)
    <=> v35(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_516,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3022(VarNext)
      <=> v3023(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_515,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v3023(VarNext)
      <=> ( v3024(VarNext)
          & v620(VarNext) ) ) ) ).

fof(writeUnaryOperator_210,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v3024(VarNext)
      <=> v2945(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_39,axiom,
    ! [VarCurr] :
      ( ( ~ v2987(VarCurr)
        & ~ v3003(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v529(VarCurr,B)
          <=> v526(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_93,axiom,
    ! [VarCurr] :
      ( v3003(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v529(VarCurr,B)
          <=> v3005(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_90,axiom,
    ! [VarCurr] :
      ( v2987(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v529(VarCurr,B)
          <=> v2989(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_514,axiom,
    ! [VarCurr] :
      ( v3015(VarCurr)
    <=> ( v3016(VarCurr)
        | v3018(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_274,axiom,
    ! [VarCurr] :
      ( v3018(VarCurr)
    <=> ( ( v3019(VarCurr,bitIndex1)
        <=> $true )
        & ( v3019(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_707,axiom,
    ! [VarCurr] :
      ( v3019(VarCurr,bitIndex0)
    <=> v539(VarCurr) ) ).

fof(addAssignment_706,axiom,
    ! [VarCurr] :
      ( v3019(VarCurr,bitIndex1)
    <=> v531(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_273,axiom,
    ! [VarCurr] :
      ( v3016(VarCurr)
    <=> ( ( v3017(VarCurr,bitIndex1)
        <=> $false )
        & ( v3017(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_705,axiom,
    ! [VarCurr] :
      ( v3017(VarCurr,bitIndex0)
    <=> v539(VarCurr) ) ).

fof(addAssignment_704,axiom,
    ! [VarCurr] :
      ( v3017(VarCurr,bitIndex1)
    <=> v531(VarCurr) ) ).

fof(addAssignment_703,axiom,
    ! [VarCurr] :
      ( v3005(VarCurr,bitIndex0)
    <=> v3001(VarCurr) ) ).

fof(addAssignment_702,axiom,
    ! [VarCurr] :
      ( v3005(VarCurr,bitIndex1)
    <=> v3012(VarCurr) ) ).

fof(addAssignment_701,axiom,
    ! [VarCurr] :
      ( v3005(VarCurr,bitIndex2)
    <=> v3007(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_513,axiom,
    ! [VarCurr] :
      ( v3012(VarCurr)
    <=> ( v3013(VarCurr)
        & v3014(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_47,axiom,
    ! [VarCurr] :
      ( v3014(VarCurr)
    <=> ( v526(VarCurr,bitIndex0)
        | v526(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_512,axiom,
    ! [VarCurr] :
      ( v3013(VarCurr)
    <=> ( v3001(VarCurr)
        | v2996(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_511,axiom,
    ! [VarCurr] :
      ( v3007(VarCurr)
    <=> ( v3008(VarCurr)
        & v3011(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_46,axiom,
    ! [VarCurr] :
      ( v3011(VarCurr)
    <=> ( v526(VarCurr,bitIndex2)
        | v3010(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_510,axiom,
    ! [VarCurr] :
      ( v3008(VarCurr)
    <=> ( v2998(VarCurr)
        | v3009(VarCurr) ) ) ).

fof(writeUnaryOperator_209,axiom,
    ! [VarCurr] :
      ( ~ v3009(VarCurr)
    <=> v3010(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_45,axiom,
    ! [VarCurr] :
      ( v3010(VarCurr)
    <=> ( v526(VarCurr,bitIndex0)
        & v526(VarCurr,bitIndex1) ) ) ).

fof(addBitVectorEqualityBitBlasted_272,axiom,
    ! [VarCurr] :
      ( v3003(VarCurr)
    <=> ( ( v3004(VarCurr,bitIndex1)
        <=> $true )
        & ( v3004(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_700,axiom,
    ! [VarCurr] :
      ( v3004(VarCurr,bitIndex0)
    <=> v539(VarCurr) ) ).

fof(addAssignment_699,axiom,
    ! [VarCurr] :
      ( v3004(VarCurr,bitIndex1)
    <=> v531(VarCurr) ) ).

fof(addAssignment_698,axiom,
    ! [VarCurr] :
      ( v2989(VarCurr,bitIndex0)
    <=> v3001(VarCurr) ) ).

fof(addAssignment_697,axiom,
    ! [VarCurr] :
      ( v2989(VarCurr,bitIndex1)
    <=> v2999(VarCurr) ) ).

fof(addAssignment_696,axiom,
    ! [VarCurr] :
      ( v2989(VarCurr,bitIndex2)
    <=> v2991(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_509,axiom,
    ! [VarCurr] :
      ( v2999(VarCurr)
    <=> ( v3000(VarCurr)
        & v3002(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_508,axiom,
    ! [VarCurr] :
      ( v3002(VarCurr)
    <=> ( v526(VarCurr,bitIndex0)
        | v2996(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_44,axiom,
    ! [VarCurr] :
      ( v3000(VarCurr)
    <=> ( v3001(VarCurr)
        | v526(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_208,axiom,
    ! [VarCurr] :
      ( ~ v3001(VarCurr)
    <=> v526(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_507,axiom,
    ! [VarCurr] :
      ( v2991(VarCurr)
    <=> ( v2992(VarCurr)
        & v2997(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_506,axiom,
    ! [VarCurr] :
      ( v2997(VarCurr)
    <=> ( v2994(VarCurr)
        | v2998(VarCurr) ) ) ).

fof(writeUnaryOperator_207,axiom,
    ! [VarCurr] :
      ( ~ v2998(VarCurr)
    <=> v526(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges_43,axiom,
    ! [VarCurr] :
      ( v2992(VarCurr)
    <=> ( v2993(VarCurr)
        | v526(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_206,axiom,
    ! [VarCurr] :
      ( ~ v2993(VarCurr)
    <=> v2994(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_42,axiom,
    ! [VarCurr] :
      ( v2994(VarCurr)
    <=> ( v526(VarCurr,bitIndex1)
        | v2995(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_505,axiom,
    ! [VarCurr] :
      ( v2995(VarCurr)
    <=> ( v526(VarCurr,bitIndex0)
        & v2996(VarCurr) ) ) ).

fof(writeUnaryOperator_205,axiom,
    ! [VarCurr] :
      ( ~ v2996(VarCurr)
    <=> v526(VarCurr,bitIndex1) ) ).

fof(addAssignmentInitValue_144,axiom,
    v526(constB0,bitIndex2) ).

fof(addAssignmentInitValue_143,axiom,
    ~ v526(constB0,bitIndex1) ).

fof(addAssignmentInitValue_142,axiom,
    ~ v526(constB0,bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_271,axiom,
    ! [VarCurr] :
      ( v2987(VarCurr)
    <=> ( ( v2988(VarCurr,bitIndex1)
        <=> $false )
        & ( v2988(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_695,axiom,
    ! [VarCurr] :
      ( v2988(VarCurr,bitIndex0)
    <=> v539(VarCurr) ) ).

fof(addAssignment_694,axiom,
    ! [VarCurr] :
      ( v2988(VarCurr,bitIndex1)
    <=> v531(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_76,axiom,
    ! [VarCurr] :
      ( ~ v2976(VarCurr)
     => ( v539(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_78,axiom,
    ! [VarCurr] :
      ( v2976(VarCurr)
     => ( v539(VarCurr)
      <=> v2980(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_38,axiom,
    ! [VarCurr] :
      ( ( ~ v2978(VarCurr)
        & ~ v2938(VarCurr) )
     => ( v2980(VarCurr)
      <=> v2985(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_92,axiom,
    ! [VarCurr] :
      ( v2938(VarCurr)
     => ( v2980(VarCurr)
      <=> v2982(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_89,axiom,
    ! [VarCurr] :
      ( v2978(VarCurr)
     => ( v2980(VarCurr)
      <=> v2981(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_75,axiom,
    ! [VarCurr] :
      ( ~ v524(VarCurr)
     => ( v2985(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_77,axiom,
    ! [VarCurr] :
      ( v524(VarCurr)
     => ( v2985(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_37,axiom,
    ! [VarCurr] :
      ( ( ~ v2933(VarCurr)
        & ~ v2983(VarCurr) )
     => ( v2982(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_91,axiom,
    ! [VarCurr] :
      ( v2983(VarCurr)
     => ( v2982(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_88,axiom,
    ! [VarCurr] :
      ( v2933(VarCurr)
     => ( v2982(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_270,axiom,
    ! [VarCurr] :
      ( v2983(VarCurr)
    <=> ( ( v2984(VarCurr,bitIndex1)
        <=> $true )
        & ( v2984(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_693,axiom,
    ! [VarCurr] :
      ( v2984(VarCurr,bitIndex0)
    <=> v524(VarCurr) ) ).

fof(addAssignment_692,axiom,
    ! [VarCurr] :
      ( v2984(VarCurr,bitIndex1)
    <=> v548(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_74,axiom,
    ! [VarCurr] :
      ( ~ v524(VarCurr)
     => ( v2981(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_76,axiom,
    ! [VarCurr] :
      ( v524(VarCurr)
     => ( v2981(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_504,axiom,
    ! [VarCurr] :
      ( v2976(VarCurr)
    <=> ( v2977(VarCurr)
        | v2966(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_503,axiom,
    ! [VarCurr] :
      ( v2977(VarCurr)
    <=> ( v2978(VarCurr)
        | v2938(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_502,axiom,
    ! [VarCurr] :
      ( v2978(VarCurr)
    <=> ( v2979(VarCurr)
        & v2931(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_501,axiom,
    ! [VarCurr] :
      ( v2979(VarCurr)
    <=> ( v2961(VarCurr)
        & v2930(VarCurr) ) ) ).

fof(addAssignment_691,axiom,
    ! [VarNext] :
      ( v520(VarNext,bitIndex1)
    <=> v2968(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionShiftedRanges1_5,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2969(VarNext)
       => ( ( v2968(VarNext,bitIndex1)
          <=> v520(VarCurr,bitIndex2) )
          & ( v2968(VarNext,bitIndex0)
          <=> v520(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_37,axiom,
    ! [VarNext] :
      ( v2969(VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v2968(VarNext,B)
          <=> v2951(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_500,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2969(VarNext)
      <=> v2970(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_499,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2970(VarNext)
      <=> ( v2972(VarNext)
          & v620(VarNext) ) ) ) ).

fof(writeUnaryOperator_204,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2972(VarNext)
      <=> v2945(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_3,axiom,
    ! [VarCurr] :
      ( ~ v2956(VarCurr)
     => ( v522(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_1,axiom,
    ! [VarCurr] :
      ( v2956(VarCurr)
     => ( v522(VarCurr,bitIndex1)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_498,axiom,
    ! [VarCurr] :
      ( v2956(VarCurr)
    <=> ( v2957(VarCurr)
        | v2965(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_497,axiom,
    ! [VarCurr] :
      ( v2965(VarCurr)
    <=> ( v524(VarCurr)
        & v2966(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_269,axiom,
    ! [VarCurr] :
      ( v2966(VarCurr)
    <=> ( $true
      <=> v520(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_496,axiom,
    ! [VarCurr] :
      ( v2957(VarCurr)
    <=> ( v2958(VarCurr)
        | v2962(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_495,axiom,
    ! [VarCurr] :
      ( v2962(VarCurr)
    <=> ( v2963(VarCurr)
        & v2938(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_268,axiom,
    ! [VarCurr] :
      ( v2963(VarCurr)
    <=> ( ( v2964(VarCurr,bitIndex1)
        <=> $true )
        & ( v2964(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_690,axiom,
    ! [VarCurr] :
      ( v2964(VarCurr,bitIndex0)
    <=> v524(VarCurr) ) ).

fof(addAssignment_689,axiom,
    ! [VarCurr] :
      ( v2964(VarCurr,bitIndex1)
    <=> v548(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_494,axiom,
    ! [VarCurr] :
      ( v2958(VarCurr)
    <=> ( v2959(VarCurr)
        & v2931(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_493,axiom,
    ! [VarCurr] :
      ( v2959(VarCurr)
    <=> ( v2960(VarCurr)
        & v2930(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_492,axiom,
    ! [VarCurr] :
      ( v2960(VarCurr)
    <=> ( v524(VarCurr)
        & v2961(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_267,axiom,
    ! [VarCurr] :
      ( v2961(VarCurr)
    <=> ( ( v27(VarCurr,bitIndex1)
        <=> $false )
        & ( v27(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_688,axiom,
    ! [VarNext] :
      ( v520(VarNext,bitIndex2)
    <=> v2940(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionShiftedRanges1_4,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2941(VarNext)
       => ( ( v2940(VarNext,bitIndex1)
          <=> v520(VarCurr,bitIndex2) )
          & ( v2940(VarNext,bitIndex0)
          <=> v520(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_36,axiom,
    ! [VarNext] :
      ( v2941(VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v2940(VarNext,B)
          <=> v2951(VarNext,B) ) ) ) ).

fof(addAssignment_687,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v2951(VarNext,B)
          <=> v2949(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_2,axiom,
    ! [VarCurr] :
      ( ~ v2952(VarCurr)
     => ( ( v2949(VarCurr,bitIndex1)
        <=> v522(VarCurr,bitIndex2) )
        & ( v2949(VarCurr,bitIndex0)
        <=> v522(VarCurr,bitIndex1) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_75,axiom,
    ! [VarCurr] :
      ( v2952(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v2949(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_203,axiom,
    ! [VarCurr] :
      ( ~ v2952(VarCurr)
    <=> v35(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_491,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2941(VarNext)
      <=> v2942(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_490,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2942(VarNext)
      <=> ( v2943(VarNext)
          & v620(VarNext) ) ) ) ).

fof(writeUnaryOperator_202,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2943(VarNext)
      <=> v2945(VarNext) ) ) ).

fof(addAssignment_686,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2945(VarNext)
      <=> v620(VarCurr) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_1,axiom,
    ! [VarCurr] :
      ( ~ v2925(VarCurr)
     => ( v522(VarCurr,bitIndex2)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch,axiom,
    ! [VarCurr] :
      ( v2925(VarCurr)
     => ( v522(VarCurr,bitIndex2)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_489,axiom,
    ! [VarCurr] :
      ( v2925(VarCurr)
    <=> ( v2926(VarCurr)
        | v2932(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_488,axiom,
    ! [VarCurr] :
      ( v2932(VarCurr)
    <=> ( v2933(VarCurr)
        & v2938(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_266,axiom,
    ! [VarCurr] :
      ( v2938(VarCurr)
    <=> ( $true
      <=> v520(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_487,axiom,
    ! [VarCurr] :
      ( v2933(VarCurr)
    <=> ( v2934(VarCurr)
        | v2936(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_265,axiom,
    ! [VarCurr] :
      ( v2936(VarCurr)
    <=> ( ( v2937(VarCurr,bitIndex1)
        <=> $false )
        & ( v2937(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_685,axiom,
    ! [VarCurr] :
      ( v2937(VarCurr,bitIndex0)
    <=> v524(VarCurr) ) ).

fof(addAssignment_684,axiom,
    ! [VarCurr] :
      ( v2937(VarCurr,bitIndex1)
    <=> v548(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_264,axiom,
    ! [VarCurr] :
      ( v2934(VarCurr)
    <=> ( ( v2935(VarCurr,bitIndex1)
        <=> $false )
        & ( v2935(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_683,axiom,
    ! [VarCurr] :
      ( v2935(VarCurr,bitIndex0)
    <=> v524(VarCurr) ) ).

fof(addAssignment_682,axiom,
    ! [VarCurr] :
      ( v2935(VarCurr,bitIndex1)
    <=> v548(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_486,axiom,
    ! [VarCurr] :
      ( v2926(VarCurr)
    <=> ( v2927(VarCurr)
        & v2931(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_263,axiom,
    ! [VarCurr] :
      ( v2931(VarCurr)
    <=> ( $true
      <=> v520(VarCurr,bitIndex0) ) ) ).

fof(addAssignmentInitValueVector_43,axiom,
    ( ( v520(constB0,bitIndex2)
    <=> $false )
    & ( v520(constB0,bitIndex1)
    <=> $false ) ) ).

fof(addAssignmentInitValueVector_42,axiom,
    ( v520(constB0,bitIndex0)
  <=> $true ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_485,axiom,
    ! [VarCurr] :
      ( v2927(VarCurr)
    <=> ( v2928(VarCurr)
        & v2930(VarCurr) ) ) ).

fof(writeUnaryOperator_201,axiom,
    ! [VarCurr] :
      ( ~ v2930(VarCurr)
    <=> v29(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_484,axiom,
    ! [VarCurr] :
      ( v2928(VarCurr)
    <=> ( v541(VarCurr)
        & v2929(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_262,axiom,
    ! [VarCurr] :
      ( v2929(VarCurr)
    <=> ( ( v27(VarCurr,bitIndex1)
        <=> $true )
        & ( v27(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_681,axiom,
    ! [VarCurr] :
      ( v548(VarCurr)
    <=> v550(VarCurr) ) ).

fof(addAssignment_680,axiom,
    ! [VarCurr] :
      ( v550(VarCurr)
    <=> v552(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_483,axiom,
    ! [VarCurr] :
      ( v552(VarCurr)
    <=> ( v2923(VarCurr)
        & v554(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_41,axiom,
    ! [VarCurr] :
      ( v2923(VarCurr)
    <=> ( v6(VarCurr,bitIndex2)
        | v6(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_679,axiom,
    ! [VarCurr] :
      ( v554(VarCurr)
    <=> v556(VarCurr) ) ).

fof(addAssignment_678,axiom,
    ! [VarCurr] :
      ( v556(VarCurr)
    <=> v558(VarCurr) ) ).

fof(addAssignment_677,axiom,
    ! [VarCurr] :
      ( v558(VarCurr)
    <=> v560(VarCurr) ) ).

fof(addAssignment_676,axiom,
    ! [VarCurr] :
      ( v560(VarCurr)
    <=> v562(VarCurr) ) ).

fof(addAssignment_675,axiom,
    ! [VarCurr] :
      ( v562(VarCurr)
    <=> v564(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_32,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2910(VarNext)
       => ( v564(VarNext)
        <=> v564(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_35,axiom,
    ! [VarNext] :
      ( v2910(VarNext)
     => ( v564(VarNext)
      <=> v2918(VarNext) ) ) ).

fof(addAssignment_674,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2918(VarNext)
      <=> v2916(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_73,axiom,
    ! [VarCurr] :
      ( ~ v2919(VarCurr)
     => ( v2916(VarCurr)
      <=> v570(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_74,axiom,
    ! [VarCurr] :
      ( v2919(VarCurr)
     => ( v2916(VarCurr)
      <=> $false ) ) ).

fof(writeUnaryOperator_200,axiom,
    ! [VarCurr] :
      ( ~ v2919(VarCurr)
    <=> v566(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_482,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2910(VarNext)
      <=> v2911(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_481,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2911(VarNext)
      <=> ( v2912(VarNext)
          & v2810(VarNext) ) ) ) ).

fof(writeUnaryOperator_199,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2912(VarNext)
      <=> v2819(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_72,axiom,
    ! [VarCurr] :
      ( ~ v2869(VarCurr)
     => ( v570(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_73,axiom,
    ! [VarCurr] :
      ( v2869(VarCurr)
     => ( v570(VarCurr)
      <=> v2893(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_90,axiom,
    ! [VarCurr] :
      ( ~ v2830(VarCurr)
     => ( v2893(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_87,axiom,
    ! [VarCurr] :
      ( v2830(VarCurr)
     => ( v2893(VarCurr)
      <=> v2894(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_480,axiom,
    ! [VarCurr] :
      ( v2900(VarCurr)
    <=> ( v2902(VarCurr)
        | v2882(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_479,axiom,
    ! [VarCurr] :
      ( v2902(VarCurr)
    <=> ( v2903(VarCurr)
        | v2881(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_478,axiom,
    ! [VarCurr] :
      ( v2903(VarCurr)
    <=> ( v2904(VarCurr)
        | v2880(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_477,axiom,
    ! [VarCurr] :
      ( v2904(VarCurr)
    <=> ( v2905(VarCurr)
        | v2850(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_476,axiom,
    ! [VarCurr] :
      ( v2905(VarCurr)
    <=> ( v2906(VarCurr)
        | v2849(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_475,axiom,
    ! [VarCurr] :
      ( v2906(VarCurr)
    <=> ( v2907(VarCurr)
        | v2848(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_474,axiom,
    ! [VarCurr] :
      ( v2907(VarCurr)
    <=> ( v2833(VarCurr)
        | v2847(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_473,axiom,
    ! [VarCurr] :
      ( v2833(VarCurr)
    <=> ( v2834(VarCurr)
        | v2839(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_71,axiom,
    ! [VarCurr] :
      ( ~ v577(VarCurr)
     => ( v2894(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_72,axiom,
    ! [VarCurr] :
      ( v577(VarCurr)
     => ( v2894(VarCurr)
      <=> v2895(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_70,axiom,
    ! [VarCurr] :
      ( ~ v2896(VarCurr)
     => ( v2895(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_71,axiom,
    ! [VarCurr] :
      ( v2896(VarCurr)
     => ( v2895(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_472,axiom,
    ! [VarCurr] :
      ( v2896(VarCurr)
    <=> ( v2897(VarCurr)
        & v2808(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_471,axiom,
    ! [VarCurr] :
      ( v2897(VarCurr)
    <=> ( v2898(VarCurr)
        | v2899(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_261,axiom,
    ! [VarCurr] :
      ( v2899(VarCurr)
    <=> ( ( v2770(VarCurr,bitIndex3)
        <=> $true )
        & ( v2770(VarCurr,bitIndex2)
        <=> $true )
        & ( v2770(VarCurr,bitIndex1)
        <=> $false )
        & ( v2770(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_260,axiom,
    ! [VarCurr] :
      ( v2898(VarCurr)
    <=> ( ( v2770(VarCurr,bitIndex3)
        <=> $false )
        & ( v2770(VarCurr,bitIndex2)
        <=> $true )
        & ( v2770(VarCurr,bitIndex1)
        <=> $false )
        & ( v2770(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_470,axiom,
    ! [VarCurr] :
      ( v2869(VarCurr)
    <=> ( v2870(VarCurr)
        | v2882(VarCurr) ) ) ).

fof(writeUnaryOperator_198,axiom,
    ! [VarCurr] :
      ( ~ v2882(VarCurr)
    <=> v2883(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_469,axiom,
    ! [VarCurr] :
      ( v2883(VarCurr)
    <=> ( v2884(VarCurr)
        | v2851(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_468,axiom,
    ! [VarCurr] :
      ( v2884(VarCurr)
    <=> ( v2885(VarCurr)
        | v2850(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_467,axiom,
    ! [VarCurr] :
      ( v2885(VarCurr)
    <=> ( v2886(VarCurr)
        | v2849(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_466,axiom,
    ! [VarCurr] :
      ( v2886(VarCurr)
    <=> ( v2887(VarCurr)
        | v2848(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_465,axiom,
    ! [VarCurr] :
      ( v2887(VarCurr)
    <=> ( v2888(VarCurr)
        | v2847(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_464,axiom,
    ! [VarCurr] :
      ( v2888(VarCurr)
    <=> ( v2889(VarCurr)
        | v2840(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_463,axiom,
    ! [VarCurr] :
      ( v2889(VarCurr)
    <=> ( v2890(VarCurr)
        | v2839(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_462,axiom,
    ! [VarCurr] :
      ( v2890(VarCurr)
    <=> ( v2891(VarCurr)
        | v2838(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_461,axiom,
    ! [VarCurr] :
      ( v2891(VarCurr)
    <=> ( v2892(VarCurr)
        | v2837(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_460,axiom,
    ! [VarCurr] :
      ( v2892(VarCurr)
    <=> ( v2830(VarCurr)
        | v2836(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_459,axiom,
    ! [VarCurr] :
      ( v2870(VarCurr)
    <=> ( v2871(VarCurr)
        | v2881(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_458,axiom,
    ! [VarCurr] :
      ( v2881(VarCurr)
    <=> ( v2853(VarCurr)
        & v2851(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_457,axiom,
    ! [VarCurr] :
      ( v2871(VarCurr)
    <=> ( v2872(VarCurr)
        | v2850(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_456,axiom,
    ! [VarCurr] :
      ( v2872(VarCurr)
    <=> ( v2873(VarCurr)
        | v2849(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_455,axiom,
    ! [VarCurr] :
      ( v2873(VarCurr)
    <=> ( v2874(VarCurr)
        | v2848(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_454,axiom,
    ! [VarCurr] :
      ( v2874(VarCurr)
    <=> ( v2875(VarCurr)
        | v2847(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_453,axiom,
    ! [VarCurr] :
      ( v2875(VarCurr)
    <=> ( v2876(VarCurr)
        | v2880(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_452,axiom,
    ! [VarCurr] :
      ( v2880(VarCurr)
    <=> ( v2842(VarCurr)
        & v2840(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_451,axiom,
    ! [VarCurr] :
      ( v2876(VarCurr)
    <=> ( v2877(VarCurr)
        | v2839(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_450,axiom,
    ! [VarCurr] :
      ( v2877(VarCurr)
    <=> ( v2878(VarCurr)
        | v2838(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_449,axiom,
    ! [VarCurr] :
      ( v2878(VarCurr)
    <=> ( v2879(VarCurr)
        | v2837(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_448,axiom,
    ! [VarCurr] :
      ( v2879(VarCurr)
    <=> ( v2830(VarCurr)
        | v2836(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_31,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2856(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v572(VarNext,B)
            <=> v572(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_34,axiom,
    ! [VarNext] :
      ( v2856(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v572(VarNext,B)
          <=> v2864(VarNext,B) ) ) ) ).

fof(addAssignment_673,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v2864(VarNext,B)
          <=> v2862(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_69,axiom,
    ! [VarCurr] :
      ( ~ v2865(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2862(VarCurr,B)
          <=> v575(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_70,axiom,
    ! [VarCurr] :
      ( v2865(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2862(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_197,axiom,
    ! [VarCurr] :
      ( ~ v2865(VarCurr)
    <=> v566(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_447,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2856(VarNext)
      <=> v2857(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_446,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2857(VarNext)
      <=> ( v2858(VarNext)
          & v2810(VarNext) ) ) ) ).

fof(writeUnaryOperator_196,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2858(VarNext)
      <=> v2819(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges5_4,axiom,
    ! [VarCurr] :
      ( ( ~ v2830(VarCurr)
        & ~ v2832(VarCurr)
        & ~ v2840(VarCurr)
        & ~ v2843(VarCurr)
        & ~ v2851(VarCurr) )
     => ! [B] :
          ( range_3_0(B)
         => ( v575(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_6,axiom,
    ! [VarCurr] :
      ( v2851(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v575(VarCurr,B)
          <=> v2852(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_17,axiom,
    ! [VarCurr] :
      ( v2843(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v575(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_36,axiom,
    ! [VarCurr] :
      ( v2840(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v575(VarCurr,B)
          <=> v2841(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_89,axiom,
    ! [VarCurr] :
      ( v2832(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v575(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_86,axiom,
    ! [VarCurr] :
      ( v2830(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v575(VarCurr,B)
          <=> v2831(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_68,axiom,
    ! [VarCurr] :
      ( ~ v2853(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2852(VarCurr,B)
          <=> $false ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_69,axiom,
    ! [VarCurr] :
      ( v2853(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2852(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_195,axiom,
    ! [VarCurr] :
      ( ~ v2853(VarCurr)
    <=> v2806(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_259,axiom,
    ! [VarCurr] :
      ( v2851(VarCurr)
    <=> ( ( v572(VarCurr,bitIndex3)
        <=> $true )
        & ( v572(VarCurr,bitIndex2)
        <=> $true )
        & ( v572(VarCurr,bitIndex1)
        <=> $false )
        & ( v572(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_445,axiom,
    ! [VarCurr] :
      ( v2843(VarCurr)
    <=> ( v2845(VarCurr)
        | v2850(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_258,axiom,
    ! [VarCurr] :
      ( v2850(VarCurr)
    <=> ( ( v572(VarCurr,bitIndex3)
        <=> $true )
        & ( v572(VarCurr,bitIndex2)
        <=> $true )
        & ( v572(VarCurr,bitIndex1)
        <=> $false )
        & ( v572(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_444,axiom,
    ! [VarCurr] :
      ( v2845(VarCurr)
    <=> ( v2846(VarCurr)
        | v2849(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_257,axiom,
    ! [VarCurr] :
      ( v2849(VarCurr)
    <=> ( ( v572(VarCurr,bitIndex3)
        <=> $true )
        & ( v572(VarCurr,bitIndex2)
        <=> $false )
        & ( v572(VarCurr,bitIndex1)
        <=> $true )
        & ( v572(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_443,axiom,
    ! [VarCurr] :
      ( v2846(VarCurr)
    <=> ( v2847(VarCurr)
        | v2848(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_256,axiom,
    ! [VarCurr] :
      ( v2848(VarCurr)
    <=> ( ( v572(VarCurr,bitIndex3)
        <=> $true )
        & ( v572(VarCurr,bitIndex2)
        <=> $false )
        & ( v572(VarCurr,bitIndex1)
        <=> $true )
        & ( v572(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_255,axiom,
    ! [VarCurr] :
      ( v2847(VarCurr)
    <=> ( ( v572(VarCurr,bitIndex3)
        <=> $true )
        & ( v572(VarCurr,bitIndex2)
        <=> $false )
        & ( v572(VarCurr,bitIndex1)
        <=> $false )
        & ( v572(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_67,axiom,
    ! [VarCurr] :
      ( ~ v2842(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2841(VarCurr,B)
          <=> $false ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_68,axiom,
    ! [VarCurr] :
      ( v2842(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2841(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_194,axiom,
    ! [VarCurr] :
      ( ~ v2842(VarCurr)
    <=> v2806(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_254,axiom,
    ! [VarCurr] :
      ( v2840(VarCurr)
    <=> ( ( v572(VarCurr,bitIndex3)
        <=> $false )
        & ( v572(VarCurr,bitIndex2)
        <=> $true )
        & ( v572(VarCurr,bitIndex1)
        <=> $false )
        & ( v572(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_442,axiom,
    ! [VarCurr] :
      ( v2832(VarCurr)
    <=> ( v2834(VarCurr)
        | v2839(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_253,axiom,
    ! [VarCurr] :
      ( v2839(VarCurr)
    <=> ( ( v572(VarCurr,bitIndex3)
        <=> $false )
        & ( v572(VarCurr,bitIndex2)
        <=> $true )
        & ( v572(VarCurr,bitIndex1)
        <=> $false )
        & ( v572(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_441,axiom,
    ! [VarCurr] :
      ( v2834(VarCurr)
    <=> ( v2835(VarCurr)
        | v2838(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_252,axiom,
    ! [VarCurr] :
      ( v2838(VarCurr)
    <=> ( ( v572(VarCurr,bitIndex3)
        <=> $false )
        & ( v572(VarCurr,bitIndex2)
        <=> $false )
        & ( v572(VarCurr,bitIndex1)
        <=> $true )
        & ( v572(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_440,axiom,
    ! [VarCurr] :
      ( v2835(VarCurr)
    <=> ( v2836(VarCurr)
        | v2837(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_251,axiom,
    ! [VarCurr] :
      ( v2837(VarCurr)
    <=> ( ( v572(VarCurr,bitIndex3)
        <=> $false )
        & ( v572(VarCurr,bitIndex2)
        <=> $false )
        & ( v572(VarCurr,bitIndex1)
        <=> $true )
        & ( v572(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_250,axiom,
    ! [VarCurr] :
      ( v2836(VarCurr)
    <=> ( ( v572(VarCurr,bitIndex3)
        <=> $false )
        & ( v572(VarCurr,bitIndex2)
        <=> $false )
        & ( v572(VarCurr,bitIndex1)
        <=> $false )
        & ( v572(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_66,axiom,
    ! [VarCurr] :
      ( ~ v577(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2831(VarCurr,B)
          <=> $false ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_67,axiom,
    ! [VarCurr] :
      ( v577(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2831(VarCurr,B)
          <=> v2770(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_249,axiom,
    ! [VarCurr] :
      ( v2830(VarCurr)
    <=> ( ( v572(VarCurr,bitIndex3)
        <=> $false )
        & ( v572(VarCurr,bitIndex2)
        <=> $false )
        & ( v572(VarCurr,bitIndex1)
        <=> $false )
        & ( v572(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignmentInitValueVector_41,axiom,
    ! [B] :
      ( range_3_0(B)
     => ( v572(constB0,B)
      <=> $false ) ) ).

fof(addCaseBooleanConditionEqualRanges1_30,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2815(VarNext)
       => ( v2806(VarNext)
        <=> v2806(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_33,axiom,
    ! [VarNext] :
      ( v2815(VarNext)
     => ( v2806(VarNext)
      <=> v2825(VarNext) ) ) ).

fof(addAssignment_672,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2825(VarNext)
      <=> v2823(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_65,axiom,
    ! [VarCurr] :
      ( ~ v2826(VarCurr)
     => ( v2823(VarCurr)
      <=> v2808(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_66,axiom,
    ! [VarCurr] :
      ( v2826(VarCurr)
     => ( v2823(VarCurr)
      <=> $false ) ) ).

fof(writeUnaryOperator_193,axiom,
    ! [VarCurr] :
      ( ~ v2826(VarCurr)
    <=> v566(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_439,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2815(VarNext)
      <=> v2816(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_438,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2816(VarNext)
      <=> ( v2817(VarNext)
          & v2810(VarNext) ) ) ) ).

fof(writeUnaryOperator_192,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2817(VarNext)
      <=> v2819(VarNext) ) ) ).

fof(addAssignment_671,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2819(VarNext)
      <=> v2810(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_40,axiom,
    ( v2806(constB0)
  <=> $false ) ).

fof(addAssignment_670,axiom,
    ! [VarCurr] :
      ( v2810(VarCurr)
    <=> v2812(VarCurr) ) ).

fof(addAssignment_669,axiom,
    ! [VarCurr] :
      ( v2812(VarCurr)
    <=> v1(VarCurr) ) ).

fof(addAssignment_668,axiom,
    ! [VarCurr] :
      ( v2808(VarCurr)
    <=> $false ) ).

fof(addAssignment_667,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v2770(VarCurr,B)
      <=> v2772(VarCurr,B) ) ) ).

fof(addAssignment_666,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v2772(VarCurr,B)
      <=> v2774(VarCurr,B) ) ) ).

fof(addAssignment_665,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v2774(VarCurr,B)
      <=> v2776(VarCurr,B) ) ) ).

fof(addAssignment_664,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v2776(VarCurr,B)
      <=> v2778(VarCurr,B) ) ) ).

fof(addAssignment_663,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v2778(VarCurr,B)
      <=> v2780(VarCurr,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_29,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2794(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v2780(VarNext,B)
            <=> v2780(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_32,axiom,
    ! [VarNext] :
      ( v2794(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v2780(VarNext,B)
          <=> v2802(VarNext,B) ) ) ) ).

fof(addAssignment_662,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v2802(VarNext,B)
          <=> v2800(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_64,axiom,
    ! [VarCurr] :
      ( ~ v2766(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2800(VarCurr,B)
          <=> v2782(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_65,axiom,
    ! [VarCurr] :
      ( v2766(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2800(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_437,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2794(VarNext)
      <=> v2795(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_436,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2795(VarNext)
      <=> ( v2797(VarNext)
          & v2752(VarNext) ) ) ) ).

fof(writeUnaryOperator_191,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2797(VarNext)
      <=> v2759(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_63,axiom,
    ! [VarCurr] :
      ( ~ v2784(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2782(VarCurr,B)
          <=> $false ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_64,axiom,
    ! [VarCurr] :
      ( v2784(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2782(VarCurr,B)
          <=> v2787(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_16,axiom,
    ! [VarCurr] :
      ( ( ~ v2735(VarCurr)
        & ~ v2736(VarCurr)
        & ~ v2737(VarCurr) )
     => ! [B] :
          ( range_3_0(B)
         => ( v2787(VarCurr,B)
          <=> v2791(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_35,axiom,
    ! [VarCurr] :
      ( v2737(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2787(VarCurr,B)
          <=> v2790(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_88,axiom,
    ! [VarCurr] :
      ( v2736(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2787(VarCurr,B)
          <=> v2789(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_85,axiom,
    ! [VarCurr] :
      ( v2735(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2787(VarCurr,B)
          <=> v2788(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_62,axiom,
    ! [VarCurr] :
      ( ~ v554(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2791(VarCurr,B)
          <=> b0011(B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_63,axiom,
    ! [VarCurr] :
      ( v554(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2791(VarCurr,B)
          <=> $false ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_61,axiom,
    ! [VarCurr] :
      ( ~ v554(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2790(VarCurr,B)
          <=> b0100(B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_62,axiom,
    ! [VarCurr] :
      ( v554(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2790(VarCurr,B)
          <=> $false ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_60,axiom,
    ! [VarCurr] :
      ( ~ v554(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2789(VarCurr,B)
          <=> b0001(B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_61,axiom,
    ! [VarCurr] :
      ( v554(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2789(VarCurr,B)
          <=> b0100(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_34,axiom,
    ! [VarCurr] :
      ( ( ~ v2741(VarCurr)
        & ~ v2744(VarCurr) )
     => ! [B] :
          ( range_3_0(B)
         => ( v2788(VarCurr,B)
          <=> b0011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_87,axiom,
    ! [VarCurr] :
      ( v2744(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2788(VarCurr,B)
          <=> b0001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_84,axiom,
    ! [VarCurr] :
      ( v2741(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v2788(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_435,axiom,
    ! [VarCurr] :
      ( v2784(VarCurr)
    <=> ( v2785(VarCurr)
        | v2738(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_434,axiom,
    ! [VarCurr] :
      ( v2785(VarCurr)
    <=> ( v2786(VarCurr)
        | v2737(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_433,axiom,
    ! [VarCurr] :
      ( v2786(VarCurr)
    <=> ( v2735(VarCurr)
        | v2736(VarCurr) ) ) ).

fof(addAssignment_661,axiom,
    ! [VarCurr] :
      ( v577(VarCurr)
    <=> v579(VarCurr) ) ).

fof(addAssignment_660,axiom,
    ! [VarCurr] :
      ( v579(VarCurr)
    <=> v581(VarCurr) ) ).

fof(addAssignment_659,axiom,
    ! [VarCurr] :
      ( v581(VarCurr)
    <=> v583(VarCurr) ) ).

fof(addAssignment_658,axiom,
    ! [VarCurr] :
      ( v583(VarCurr)
    <=> v585(VarCurr) ) ).

fof(addAssignment_657,axiom,
    ! [VarCurr] :
      ( v585(VarCurr)
    <=> v587(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_28,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2755(VarNext)
       => ( v587(VarNext)
        <=> v587(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_31,axiom,
    ! [VarNext] :
      ( v2755(VarNext)
     => ( v587(VarNext)
      <=> v2765(VarNext) ) ) ).

fof(addAssignment_656,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2765(VarNext)
      <=> v2763(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_59,axiom,
    ! [VarCurr] :
      ( ~ v2766(VarCurr)
     => ( v2763(VarCurr)
      <=> v589(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_60,axiom,
    ! [VarCurr] :
      ( v2766(VarCurr)
     => ( v2763(VarCurr)
      <=> $false ) ) ).

fof(writeUnaryOperator_190,axiom,
    ! [VarCurr] :
      ( ~ v2766(VarCurr)
    <=> v8(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_432,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2755(VarNext)
      <=> v2756(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_431,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2756(VarNext)
      <=> ( v2757(VarNext)
          & v2752(VarNext) ) ) ) ).

fof(writeUnaryOperator_189,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2757(VarNext)
      <=> v2759(VarNext) ) ) ).

fof(addAssignment_655,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2759(VarNext)
      <=> v2752(VarCurr) ) ) ).

fof(addAssignment_654,axiom,
    ! [VarCurr] :
      ( v2752(VarCurr)
    <=> v622(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_58,axiom,
    ! [VarCurr] :
      ( ~ v2732(VarCurr)
     => ( v589(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_59,axiom,
    ! [VarCurr] :
      ( v2732(VarCurr)
     => ( v589(VarCurr)
      <=> v2739(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_33,axiom,
    ! [VarCurr] :
      ( ( ~ v2735(VarCurr)
        & ~ v2736(VarCurr) )
     => ( v2739(VarCurr)
      <=> v2750(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_86,axiom,
    ! [VarCurr] :
      ( v2736(VarCurr)
     => ( v2739(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_83,axiom,
    ! [VarCurr] :
      ( v2735(VarCurr)
     => ( v2739(VarCurr)
      <=> v2740(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_57,axiom,
    ! [VarCurr] :
      ( ~ v554(VarCurr)
     => ( v2750(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_58,axiom,
    ! [VarCurr] :
      ( v554(VarCurr)
     => ( v2750(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_430,axiom,
    ! [VarCurr] :
      ( v2749(VarCurr)
    <=> ( v2737(VarCurr)
        | v2738(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_85,axiom,
    ! [VarCurr] :
      ( ~ v2741(VarCurr)
     => ( v2740(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_82,axiom,
    ! [VarCurr] :
      ( v2741(VarCurr)
     => ( v2740(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_429,axiom,
    ! [VarCurr] :
      ( v2743(VarCurr)
    <=> ( v2744(VarCurr)
        | v2747(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_428,axiom,
    ! [VarCurr] :
      ( v2747(VarCurr)
    <=> ( v21(VarCurr)
        & v591(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_427,axiom,
    ! [VarCurr] :
      ( v2744(VarCurr)
    <=> ( v21(VarCurr)
        & v2746(VarCurr) ) ) ).

fof(writeUnaryOperator_188,axiom,
    ! [VarCurr] :
      ( ~ v2746(VarCurr)
    <=> v591(VarCurr) ) ).

fof(writeUnaryOperator_187,axiom,
    ! [VarCurr] :
      ( ~ v2741(VarCurr)
    <=> v21(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_426,axiom,
    ! [VarCurr] :
      ( v2732(VarCurr)
    <=> ( v2733(VarCurr)
        | v2738(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_248,axiom,
    ! [VarCurr] :
      ( v2738(VarCurr)
    <=> ( $true
      <=> v6(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_425,axiom,
    ! [VarCurr] :
      ( v2733(VarCurr)
    <=> ( v2734(VarCurr)
        | v2737(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_247,axiom,
    ! [VarCurr] :
      ( v2737(VarCurr)
    <=> ( $true
      <=> v6(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_424,axiom,
    ! [VarCurr] :
      ( v2734(VarCurr)
    <=> ( v2735(VarCurr)
        | v2736(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_246,axiom,
    ! [VarCurr] :
      ( v2736(VarCurr)
    <=> ( $true
      <=> v6(VarCurr,bitIndex2) ) ) ).

fof(addBitVectorEqualityBitBlasted_245,axiom,
    ! [VarCurr] :
      ( v2735(VarCurr)
    <=> ( $true
      <=> v6(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_653,axiom,
    ! [VarCurr] :
      ( v591(VarCurr)
    <=> v593(VarCurr) ) ).

fof(addAssignment_652,axiom,
    ! [VarCurr] :
      ( v593(VarCurr)
    <=> v595(VarCurr) ) ).

fof(addAssignment_651,axiom,
    ! [VarCurr] :
      ( v595(VarCurr)
    <=> v597(VarCurr,bitIndex0) ) ).

fof(addAssignment_650,axiom,
    ! [VarCurr] :
      ( v597(VarCurr,bitIndex0)
    <=> v599(VarCurr,bitIndex49) ) ).

fof(addAssignment_649,axiom,
    ! [VarCurr] :
      ( v599(VarCurr,bitIndex49)
    <=> v601(VarCurr,bitIndex49) ) ).

fof(addAssignment_648,axiom,
    ! [VarCurr] :
      ( v601(VarCurr,bitIndex49)
    <=> v603(VarCurr,bitIndex539) ) ).

fof(addAssignment_647,axiom,
    ! [VarNext] :
      ( v603(VarNext,bitIndex539)
    <=> v2699(VarNext,bitIndex49) ) ).

fof(addCaseBooleanConditionShiftedRanges1_3,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2700(VarNext)
       => ( ( v2699(VarNext,bitIndex69)
          <=> v603(VarCurr,bitIndex559) )
          & ( v2699(VarNext,bitIndex68)
          <=> v603(VarCurr,bitIndex558) )
          & ( v2699(VarNext,bitIndex67)
          <=> v603(VarCurr,bitIndex557) )
          & ( v2699(VarNext,bitIndex66)
          <=> v603(VarCurr,bitIndex556) )
          & ( v2699(VarNext,bitIndex65)
          <=> v603(VarCurr,bitIndex555) )
          & ( v2699(VarNext,bitIndex64)
          <=> v603(VarCurr,bitIndex554) )
          & ( v2699(VarNext,bitIndex63)
          <=> v603(VarCurr,bitIndex553) )
          & ( v2699(VarNext,bitIndex62)
          <=> v603(VarCurr,bitIndex552) )
          & ( v2699(VarNext,bitIndex61)
          <=> v603(VarCurr,bitIndex551) )
          & ( v2699(VarNext,bitIndex60)
          <=> v603(VarCurr,bitIndex550) )
          & ( v2699(VarNext,bitIndex59)
          <=> v603(VarCurr,bitIndex549) )
          & ( v2699(VarNext,bitIndex58)
          <=> v603(VarCurr,bitIndex548) )
          & ( v2699(VarNext,bitIndex57)
          <=> v603(VarCurr,bitIndex547) )
          & ( v2699(VarNext,bitIndex56)
          <=> v603(VarCurr,bitIndex546) )
          & ( v2699(VarNext,bitIndex55)
          <=> v603(VarCurr,bitIndex545) )
          & ( v2699(VarNext,bitIndex54)
          <=> v603(VarCurr,bitIndex544) )
          & ( v2699(VarNext,bitIndex53)
          <=> v603(VarCurr,bitIndex543) )
          & ( v2699(VarNext,bitIndex52)
          <=> v603(VarCurr,bitIndex542) )
          & ( v2699(VarNext,bitIndex51)
          <=> v603(VarCurr,bitIndex541) )
          & ( v2699(VarNext,bitIndex50)
          <=> v603(VarCurr,bitIndex540) )
          & ( v2699(VarNext,bitIndex49)
          <=> v603(VarCurr,bitIndex539) )
          & ( v2699(VarNext,bitIndex48)
          <=> v603(VarCurr,bitIndex538) )
          & ( v2699(VarNext,bitIndex47)
          <=> v603(VarCurr,bitIndex537) )
          & ( v2699(VarNext,bitIndex46)
          <=> v603(VarCurr,bitIndex536) )
          & ( v2699(VarNext,bitIndex45)
          <=> v603(VarCurr,bitIndex535) )
          & ( v2699(VarNext,bitIndex44)
          <=> v603(VarCurr,bitIndex534) )
          & ( v2699(VarNext,bitIndex43)
          <=> v603(VarCurr,bitIndex533) )
          & ( v2699(VarNext,bitIndex42)
          <=> v603(VarCurr,bitIndex532) )
          & ( v2699(VarNext,bitIndex41)
          <=> v603(VarCurr,bitIndex531) )
          & ( v2699(VarNext,bitIndex40)
          <=> v603(VarCurr,bitIndex530) )
          & ( v2699(VarNext,bitIndex39)
          <=> v603(VarCurr,bitIndex529) )
          & ( v2699(VarNext,bitIndex38)
          <=> v603(VarCurr,bitIndex528) )
          & ( v2699(VarNext,bitIndex37)
          <=> v603(VarCurr,bitIndex527) )
          & ( v2699(VarNext,bitIndex36)
          <=> v603(VarCurr,bitIndex526) )
          & ( v2699(VarNext,bitIndex35)
          <=> v603(VarCurr,bitIndex525) )
          & ( v2699(VarNext,bitIndex34)
          <=> v603(VarCurr,bitIndex524) )
          & ( v2699(VarNext,bitIndex33)
          <=> v603(VarCurr,bitIndex523) )
          & ( v2699(VarNext,bitIndex32)
          <=> v603(VarCurr,bitIndex522) )
          & ( v2699(VarNext,bitIndex31)
          <=> v603(VarCurr,bitIndex521) )
          & ( v2699(VarNext,bitIndex30)
          <=> v603(VarCurr,bitIndex520) )
          & ( v2699(VarNext,bitIndex29)
          <=> v603(VarCurr,bitIndex519) )
          & ( v2699(VarNext,bitIndex28)
          <=> v603(VarCurr,bitIndex518) )
          & ( v2699(VarNext,bitIndex27)
          <=> v603(VarCurr,bitIndex517) )
          & ( v2699(VarNext,bitIndex26)
          <=> v603(VarCurr,bitIndex516) )
          & ( v2699(VarNext,bitIndex25)
          <=> v603(VarCurr,bitIndex515) )
          & ( v2699(VarNext,bitIndex24)
          <=> v603(VarCurr,bitIndex514) )
          & ( v2699(VarNext,bitIndex23)
          <=> v603(VarCurr,bitIndex513) )
          & ( v2699(VarNext,bitIndex22)
          <=> v603(VarCurr,bitIndex512) )
          & ( v2699(VarNext,bitIndex21)
          <=> v603(VarCurr,bitIndex511) )
          & ( v2699(VarNext,bitIndex20)
          <=> v603(VarCurr,bitIndex510) )
          & ( v2699(VarNext,bitIndex19)
          <=> v603(VarCurr,bitIndex509) )
          & ( v2699(VarNext,bitIndex18)
          <=> v603(VarCurr,bitIndex508) )
          & ( v2699(VarNext,bitIndex17)
          <=> v603(VarCurr,bitIndex507) )
          & ( v2699(VarNext,bitIndex16)
          <=> v603(VarCurr,bitIndex506) )
          & ( v2699(VarNext,bitIndex15)
          <=> v603(VarCurr,bitIndex505) )
          & ( v2699(VarNext,bitIndex14)
          <=> v603(VarCurr,bitIndex504) )
          & ( v2699(VarNext,bitIndex13)
          <=> v603(VarCurr,bitIndex503) )
          & ( v2699(VarNext,bitIndex12)
          <=> v603(VarCurr,bitIndex502) )
          & ( v2699(VarNext,bitIndex11)
          <=> v603(VarCurr,bitIndex501) )
          & ( v2699(VarNext,bitIndex10)
          <=> v603(VarCurr,bitIndex500) )
          & ( v2699(VarNext,bitIndex9)
          <=> v603(VarCurr,bitIndex499) )
          & ( v2699(VarNext,bitIndex8)
          <=> v603(VarCurr,bitIndex498) )
          & ( v2699(VarNext,bitIndex7)
          <=> v603(VarCurr,bitIndex497) )
          & ( v2699(VarNext,bitIndex6)
          <=> v603(VarCurr,bitIndex496) )
          & ( v2699(VarNext,bitIndex5)
          <=> v603(VarCurr,bitIndex495) )
          & ( v2699(VarNext,bitIndex4)
          <=> v603(VarCurr,bitIndex494) )
          & ( v2699(VarNext,bitIndex3)
          <=> v603(VarCurr,bitIndex493) )
          & ( v2699(VarNext,bitIndex2)
          <=> v603(VarCurr,bitIndex492) )
          & ( v2699(VarNext,bitIndex1)
          <=> v603(VarCurr,bitIndex491) )
          & ( v2699(VarNext,bitIndex0)
          <=> v603(VarCurr,bitIndex490) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_30,axiom,
    ! [VarNext] :
      ( v2700(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v2699(VarNext,B)
          <=> v2726(VarNext,B) ) ) ) ).

fof(addAssignment_646,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v2726(VarNext,B)
          <=> v2724(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_84,axiom,
    ! [VarCurr] :
      ( ~ v2617(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v2724(VarCurr,B)
          <=> v2727(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_81,axiom,
    ! [VarCurr] :
      ( v2617(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v2724(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_32,axiom,
    ! [VarCurr] :
      ( ( ~ v2713(VarCurr)
        & ~ v2715(VarCurr) )
     => ! [B] :
          ( range_69_0(B)
         => ( v2727(VarCurr,B)
          <=> v2692(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_83,axiom,
    ! [VarCurr] :
      ( v2715(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v2727(VarCurr,B)
          <=> v2685(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_4,axiom,
    ! [VarCurr] :
      ( v2713(VarCurr)
     => ( ( v2727(VarCurr,bitIndex69)
        <=> v603(VarCurr,bitIndex489) )
        & ( v2727(VarCurr,bitIndex68)
        <=> v603(VarCurr,bitIndex488) )
        & ( v2727(VarCurr,bitIndex67)
        <=> v603(VarCurr,bitIndex487) )
        & ( v2727(VarCurr,bitIndex66)
        <=> v603(VarCurr,bitIndex486) )
        & ( v2727(VarCurr,bitIndex65)
        <=> v603(VarCurr,bitIndex485) )
        & ( v2727(VarCurr,bitIndex64)
        <=> v603(VarCurr,bitIndex484) )
        & ( v2727(VarCurr,bitIndex63)
        <=> v603(VarCurr,bitIndex483) )
        & ( v2727(VarCurr,bitIndex62)
        <=> v603(VarCurr,bitIndex482) )
        & ( v2727(VarCurr,bitIndex61)
        <=> v603(VarCurr,bitIndex481) )
        & ( v2727(VarCurr,bitIndex60)
        <=> v603(VarCurr,bitIndex480) )
        & ( v2727(VarCurr,bitIndex59)
        <=> v603(VarCurr,bitIndex479) )
        & ( v2727(VarCurr,bitIndex58)
        <=> v603(VarCurr,bitIndex478) )
        & ( v2727(VarCurr,bitIndex57)
        <=> v603(VarCurr,bitIndex477) )
        & ( v2727(VarCurr,bitIndex56)
        <=> v603(VarCurr,bitIndex476) )
        & ( v2727(VarCurr,bitIndex55)
        <=> v603(VarCurr,bitIndex475) )
        & ( v2727(VarCurr,bitIndex54)
        <=> v603(VarCurr,bitIndex474) )
        & ( v2727(VarCurr,bitIndex53)
        <=> v603(VarCurr,bitIndex473) )
        & ( v2727(VarCurr,bitIndex52)
        <=> v603(VarCurr,bitIndex472) )
        & ( v2727(VarCurr,bitIndex51)
        <=> v603(VarCurr,bitIndex471) )
        & ( v2727(VarCurr,bitIndex50)
        <=> v603(VarCurr,bitIndex470) )
        & ( v2727(VarCurr,bitIndex49)
        <=> v603(VarCurr,bitIndex469) )
        & ( v2727(VarCurr,bitIndex48)
        <=> v603(VarCurr,bitIndex468) )
        & ( v2727(VarCurr,bitIndex47)
        <=> v603(VarCurr,bitIndex467) )
        & ( v2727(VarCurr,bitIndex46)
        <=> v603(VarCurr,bitIndex466) )
        & ( v2727(VarCurr,bitIndex45)
        <=> v603(VarCurr,bitIndex465) )
        & ( v2727(VarCurr,bitIndex44)
        <=> v603(VarCurr,bitIndex464) )
        & ( v2727(VarCurr,bitIndex43)
        <=> v603(VarCurr,bitIndex463) )
        & ( v2727(VarCurr,bitIndex42)
        <=> v603(VarCurr,bitIndex462) )
        & ( v2727(VarCurr,bitIndex41)
        <=> v603(VarCurr,bitIndex461) )
        & ( v2727(VarCurr,bitIndex40)
        <=> v603(VarCurr,bitIndex460) )
        & ( v2727(VarCurr,bitIndex39)
        <=> v603(VarCurr,bitIndex459) )
        & ( v2727(VarCurr,bitIndex38)
        <=> v603(VarCurr,bitIndex458) )
        & ( v2727(VarCurr,bitIndex37)
        <=> v603(VarCurr,bitIndex457) )
        & ( v2727(VarCurr,bitIndex36)
        <=> v603(VarCurr,bitIndex456) )
        & ( v2727(VarCurr,bitIndex35)
        <=> v603(VarCurr,bitIndex455) )
        & ( v2727(VarCurr,bitIndex34)
        <=> v603(VarCurr,bitIndex454) )
        & ( v2727(VarCurr,bitIndex33)
        <=> v603(VarCurr,bitIndex453) )
        & ( v2727(VarCurr,bitIndex32)
        <=> v603(VarCurr,bitIndex452) )
        & ( v2727(VarCurr,bitIndex31)
        <=> v603(VarCurr,bitIndex451) )
        & ( v2727(VarCurr,bitIndex30)
        <=> v603(VarCurr,bitIndex450) )
        & ( v2727(VarCurr,bitIndex29)
        <=> v603(VarCurr,bitIndex449) )
        & ( v2727(VarCurr,bitIndex28)
        <=> v603(VarCurr,bitIndex448) )
        & ( v2727(VarCurr,bitIndex27)
        <=> v603(VarCurr,bitIndex447) )
        & ( v2727(VarCurr,bitIndex26)
        <=> v603(VarCurr,bitIndex446) )
        & ( v2727(VarCurr,bitIndex25)
        <=> v603(VarCurr,bitIndex445) )
        & ( v2727(VarCurr,bitIndex24)
        <=> v603(VarCurr,bitIndex444) )
        & ( v2727(VarCurr,bitIndex23)
        <=> v603(VarCurr,bitIndex443) )
        & ( v2727(VarCurr,bitIndex22)
        <=> v603(VarCurr,bitIndex442) )
        & ( v2727(VarCurr,bitIndex21)
        <=> v603(VarCurr,bitIndex441) )
        & ( v2727(VarCurr,bitIndex20)
        <=> v603(VarCurr,bitIndex440) )
        & ( v2727(VarCurr,bitIndex19)
        <=> v603(VarCurr,bitIndex439) )
        & ( v2727(VarCurr,bitIndex18)
        <=> v603(VarCurr,bitIndex438) )
        & ( v2727(VarCurr,bitIndex17)
        <=> v603(VarCurr,bitIndex437) )
        & ( v2727(VarCurr,bitIndex16)
        <=> v603(VarCurr,bitIndex436) )
        & ( v2727(VarCurr,bitIndex15)
        <=> v603(VarCurr,bitIndex435) )
        & ( v2727(VarCurr,bitIndex14)
        <=> v603(VarCurr,bitIndex434) )
        & ( v2727(VarCurr,bitIndex13)
        <=> v603(VarCurr,bitIndex433) )
        & ( v2727(VarCurr,bitIndex12)
        <=> v603(VarCurr,bitIndex432) )
        & ( v2727(VarCurr,bitIndex11)
        <=> v603(VarCurr,bitIndex431) )
        & ( v2727(VarCurr,bitIndex10)
        <=> v603(VarCurr,bitIndex430) )
        & ( v2727(VarCurr,bitIndex9)
        <=> v603(VarCurr,bitIndex429) )
        & ( v2727(VarCurr,bitIndex8)
        <=> v603(VarCurr,bitIndex428) )
        & ( v2727(VarCurr,bitIndex7)
        <=> v603(VarCurr,bitIndex427) )
        & ( v2727(VarCurr,bitIndex6)
        <=> v603(VarCurr,bitIndex426) )
        & ( v2727(VarCurr,bitIndex5)
        <=> v603(VarCurr,bitIndex425) )
        & ( v2727(VarCurr,bitIndex4)
        <=> v603(VarCurr,bitIndex424) )
        & ( v2727(VarCurr,bitIndex3)
        <=> v603(VarCurr,bitIndex423) )
        & ( v2727(VarCurr,bitIndex2)
        <=> v603(VarCurr,bitIndex422) )
        & ( v2727(VarCurr,bitIndex1)
        <=> v603(VarCurr,bitIndex421) )
        & ( v2727(VarCurr,bitIndex0)
        <=> v603(VarCurr,bitIndex420) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_423,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2700(VarNext)
      <=> ( v2701(VarNext)
          & v2708(VarNext) ) ) ) ).

fof(addAssignment_645,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2708(VarNext)
      <=> v2706(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_422,axiom,
    ! [VarCurr] :
      ( v2706(VarCurr)
    <=> ( v2709(VarCurr)
        & v2720(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_421,axiom,
    ! [VarCurr] :
      ( v2720(VarCurr)
    <=> ( v2721(VarCurr)
        | v2617(VarCurr) ) ) ).

fof(writeUnaryOperator_186,axiom,
    ! [VarCurr] :
      ( ~ v2721(VarCurr)
    <=> v2722(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_244,axiom,
    ! [VarCurr] :
      ( v2722(VarCurr)
    <=> ( ( v2723(VarCurr,bitIndex1)
        <=> $false )
        & ( v2723(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_644,axiom,
    ! [VarCurr] :
      ( v2723(VarCurr,bitIndex0)
    <=> v514(VarCurr) ) ).

fof(addAssignment_643,axiom,
    ! [VarCurr] :
      ( v2723(VarCurr,bitIndex1)
    <=> v37(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_420,axiom,
    ! [VarCurr] :
      ( v2709(VarCurr)
    <=> ( v2617(VarCurr)
        | v2710(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_419,axiom,
    ! [VarCurr] :
      ( v2710(VarCurr)
    <=> ( v2711(VarCurr)
        & v2719(VarCurr) ) ) ).

fof(writeUnaryOperator_185,axiom,
    ! [VarCurr] :
      ( ~ v2719(VarCurr)
    <=> v2617(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_418,axiom,
    ! [VarCurr] :
      ( v2711(VarCurr)
    <=> ( v2712(VarCurr)
        | v2717(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_243,axiom,
    ! [VarCurr] :
      ( v2717(VarCurr)
    <=> ( ( v2718(VarCurr,bitIndex1)
        <=> $true )
        & ( v2718(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_642,axiom,
    ! [VarCurr] :
      ( v2718(VarCurr,bitIndex0)
    <=> v514(VarCurr) ) ).

fof(addAssignment_641,axiom,
    ! [VarCurr] :
      ( v2718(VarCurr,bitIndex1)
    <=> v37(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_417,axiom,
    ! [VarCurr] :
      ( v2712(VarCurr)
    <=> ( v2713(VarCurr)
        | v2715(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_242,axiom,
    ! [VarCurr] :
      ( v2715(VarCurr)
    <=> ( ( v2716(VarCurr,bitIndex1)
        <=> $true )
        & ( v2716(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_640,axiom,
    ! [VarCurr] :
      ( v2716(VarCurr,bitIndex0)
    <=> v514(VarCurr) ) ).

fof(addAssignment_639,axiom,
    ! [VarCurr] :
      ( v2716(VarCurr,bitIndex1)
    <=> v37(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_241,axiom,
    ! [VarCurr] :
      ( v2713(VarCurr)
    <=> ( ( v2714(VarCurr,bitIndex1)
        <=> $false )
        & ( v2714(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_638,axiom,
    ! [VarCurr] :
      ( v2714(VarCurr,bitIndex0)
    <=> v514(VarCurr) ) ).

fof(addAssignment_637,axiom,
    ! [VarCurr] :
      ( v2714(VarCurr,bitIndex1)
    <=> v37(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_416,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2701(VarNext)
      <=> ( v2703(VarNext)
          & v618(VarNext) ) ) ) ).

fof(writeUnaryOperator_184,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2703(VarNext)
      <=> v633(VarNext) ) ) ).

fof(addAssignment_636,axiom,
    ! [VarCurr] :
      ( v2692(VarCurr,bitIndex49)
    <=> v2697(VarCurr,bitIndex49) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_56,axiom,
    ! [VarCurr] :
      ( ~ v2694(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v2697(VarCurr,B)
          <=> v2696(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_57,axiom,
    ! [VarCurr] :
      ( v2694(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v2697(VarCurr,B)
          <=> v686(VarCurr,B) ) ) ) ).

fof(addAssignment_635,axiom,
    ! [VarCurr] :
      ( v2696(VarCurr,bitIndex49)
    <=> v603(VarCurr,bitIndex469) ) ).

fof(addAssignment_634,axiom,
    ! [VarCurr] :
      ( v2694(VarCurr)
    <=> v611(VarCurr,bitIndex1) ) ).

fof(addAssignment_633,axiom,
    ! [VarCurr] :
      ( v2685(VarCurr,bitIndex49)
    <=> v2690(VarCurr,bitIndex49) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_55,axiom,
    ! [VarCurr] :
      ( ~ v2687(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v2690(VarCurr,B)
          <=> v2689(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_56,axiom,
    ! [VarCurr] :
      ( v2687(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v2690(VarCurr,B)
          <=> v686(VarCurr,B) ) ) ) ).

fof(addAssignment_632,axiom,
    ! [VarCurr] :
      ( v2689(VarCurr,bitIndex49)
    <=> v603(VarCurr,bitIndex539) ) ).

fof(addAssignment_631,axiom,
    ! [VarCurr] :
      ( v2687(VarCurr)
    <=> v611(VarCurr,bitIndex1) ) ).

fof(addAssignment_630,axiom,
    ! [VarNext] :
      ( v603(VarNext,bitIndex469)
    <=> v2653(VarNext,bitIndex49) ) ).

fof(addCaseBooleanConditionShiftedRanges1_2,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2654(VarNext)
       => ( ( v2653(VarNext,bitIndex69)
          <=> v603(VarCurr,bitIndex489) )
          & ( v2653(VarNext,bitIndex68)
          <=> v603(VarCurr,bitIndex488) )
          & ( v2653(VarNext,bitIndex67)
          <=> v603(VarCurr,bitIndex487) )
          & ( v2653(VarNext,bitIndex66)
          <=> v603(VarCurr,bitIndex486) )
          & ( v2653(VarNext,bitIndex65)
          <=> v603(VarCurr,bitIndex485) )
          & ( v2653(VarNext,bitIndex64)
          <=> v603(VarCurr,bitIndex484) )
          & ( v2653(VarNext,bitIndex63)
          <=> v603(VarCurr,bitIndex483) )
          & ( v2653(VarNext,bitIndex62)
          <=> v603(VarCurr,bitIndex482) )
          & ( v2653(VarNext,bitIndex61)
          <=> v603(VarCurr,bitIndex481) )
          & ( v2653(VarNext,bitIndex60)
          <=> v603(VarCurr,bitIndex480) )
          & ( v2653(VarNext,bitIndex59)
          <=> v603(VarCurr,bitIndex479) )
          & ( v2653(VarNext,bitIndex58)
          <=> v603(VarCurr,bitIndex478) )
          & ( v2653(VarNext,bitIndex57)
          <=> v603(VarCurr,bitIndex477) )
          & ( v2653(VarNext,bitIndex56)
          <=> v603(VarCurr,bitIndex476) )
          & ( v2653(VarNext,bitIndex55)
          <=> v603(VarCurr,bitIndex475) )
          & ( v2653(VarNext,bitIndex54)
          <=> v603(VarCurr,bitIndex474) )
          & ( v2653(VarNext,bitIndex53)
          <=> v603(VarCurr,bitIndex473) )
          & ( v2653(VarNext,bitIndex52)
          <=> v603(VarCurr,bitIndex472) )
          & ( v2653(VarNext,bitIndex51)
          <=> v603(VarCurr,bitIndex471) )
          & ( v2653(VarNext,bitIndex50)
          <=> v603(VarCurr,bitIndex470) )
          & ( v2653(VarNext,bitIndex49)
          <=> v603(VarCurr,bitIndex469) )
          & ( v2653(VarNext,bitIndex48)
          <=> v603(VarCurr,bitIndex468) )
          & ( v2653(VarNext,bitIndex47)
          <=> v603(VarCurr,bitIndex467) )
          & ( v2653(VarNext,bitIndex46)
          <=> v603(VarCurr,bitIndex466) )
          & ( v2653(VarNext,bitIndex45)
          <=> v603(VarCurr,bitIndex465) )
          & ( v2653(VarNext,bitIndex44)
          <=> v603(VarCurr,bitIndex464) )
          & ( v2653(VarNext,bitIndex43)
          <=> v603(VarCurr,bitIndex463) )
          & ( v2653(VarNext,bitIndex42)
          <=> v603(VarCurr,bitIndex462) )
          & ( v2653(VarNext,bitIndex41)
          <=> v603(VarCurr,bitIndex461) )
          & ( v2653(VarNext,bitIndex40)
          <=> v603(VarCurr,bitIndex460) )
          & ( v2653(VarNext,bitIndex39)
          <=> v603(VarCurr,bitIndex459) )
          & ( v2653(VarNext,bitIndex38)
          <=> v603(VarCurr,bitIndex458) )
          & ( v2653(VarNext,bitIndex37)
          <=> v603(VarCurr,bitIndex457) )
          & ( v2653(VarNext,bitIndex36)
          <=> v603(VarCurr,bitIndex456) )
          & ( v2653(VarNext,bitIndex35)
          <=> v603(VarCurr,bitIndex455) )
          & ( v2653(VarNext,bitIndex34)
          <=> v603(VarCurr,bitIndex454) )
          & ( v2653(VarNext,bitIndex33)
          <=> v603(VarCurr,bitIndex453) )
          & ( v2653(VarNext,bitIndex32)
          <=> v603(VarCurr,bitIndex452) )
          & ( v2653(VarNext,bitIndex31)
          <=> v603(VarCurr,bitIndex451) )
          & ( v2653(VarNext,bitIndex30)
          <=> v603(VarCurr,bitIndex450) )
          & ( v2653(VarNext,bitIndex29)
          <=> v603(VarCurr,bitIndex449) )
          & ( v2653(VarNext,bitIndex28)
          <=> v603(VarCurr,bitIndex448) )
          & ( v2653(VarNext,bitIndex27)
          <=> v603(VarCurr,bitIndex447) )
          & ( v2653(VarNext,bitIndex26)
          <=> v603(VarCurr,bitIndex446) )
          & ( v2653(VarNext,bitIndex25)
          <=> v603(VarCurr,bitIndex445) )
          & ( v2653(VarNext,bitIndex24)
          <=> v603(VarCurr,bitIndex444) )
          & ( v2653(VarNext,bitIndex23)
          <=> v603(VarCurr,bitIndex443) )
          & ( v2653(VarNext,bitIndex22)
          <=> v603(VarCurr,bitIndex442) )
          & ( v2653(VarNext,bitIndex21)
          <=> v603(VarCurr,bitIndex441) )
          & ( v2653(VarNext,bitIndex20)
          <=> v603(VarCurr,bitIndex440) )
          & ( v2653(VarNext,bitIndex19)
          <=> v603(VarCurr,bitIndex439) )
          & ( v2653(VarNext,bitIndex18)
          <=> v603(VarCurr,bitIndex438) )
          & ( v2653(VarNext,bitIndex17)
          <=> v603(VarCurr,bitIndex437) )
          & ( v2653(VarNext,bitIndex16)
          <=> v603(VarCurr,bitIndex436) )
          & ( v2653(VarNext,bitIndex15)
          <=> v603(VarCurr,bitIndex435) )
          & ( v2653(VarNext,bitIndex14)
          <=> v603(VarCurr,bitIndex434) )
          & ( v2653(VarNext,bitIndex13)
          <=> v603(VarCurr,bitIndex433) )
          & ( v2653(VarNext,bitIndex12)
          <=> v603(VarCurr,bitIndex432) )
          & ( v2653(VarNext,bitIndex11)
          <=> v603(VarCurr,bitIndex431) )
          & ( v2653(VarNext,bitIndex10)
          <=> v603(VarCurr,bitIndex430) )
          & ( v2653(VarNext,bitIndex9)
          <=> v603(VarCurr,bitIndex429) )
          & ( v2653(VarNext,bitIndex8)
          <=> v603(VarCurr,bitIndex428) )
          & ( v2653(VarNext,bitIndex7)
          <=> v603(VarCurr,bitIndex427) )
          & ( v2653(VarNext,bitIndex6)
          <=> v603(VarCurr,bitIndex426) )
          & ( v2653(VarNext,bitIndex5)
          <=> v603(VarCurr,bitIndex425) )
          & ( v2653(VarNext,bitIndex4)
          <=> v603(VarCurr,bitIndex424) )
          & ( v2653(VarNext,bitIndex3)
          <=> v603(VarCurr,bitIndex423) )
          & ( v2653(VarNext,bitIndex2)
          <=> v603(VarCurr,bitIndex422) )
          & ( v2653(VarNext,bitIndex1)
          <=> v603(VarCurr,bitIndex421) )
          & ( v2653(VarNext,bitIndex0)
          <=> v603(VarCurr,bitIndex420) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_29,axiom,
    ! [VarNext] :
      ( v2654(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v2653(VarNext,B)
          <=> v2680(VarNext,B) ) ) ) ).

fof(addAssignment_629,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v2680(VarNext,B)
          <=> v2678(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_82,axiom,
    ! [VarCurr] :
      ( ~ v2617(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v2678(VarCurr,B)
          <=> v2681(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_80,axiom,
    ! [VarCurr] :
      ( v2617(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v2678(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_31,axiom,
    ! [VarCurr] :
      ( ( ~ v2667(VarCurr)
        & ~ v2669(VarCurr) )
     => ! [B] :
          ( range_69_0(B)
         => ( v2681(VarCurr,B)
          <=> v2646(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_81,axiom,
    ! [VarCurr] :
      ( v2669(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v2681(VarCurr,B)
          <=> v2639(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_3,axiom,
    ! [VarCurr] :
      ( v2667(VarCurr)
     => ( ( v2681(VarCurr,bitIndex69)
        <=> v603(VarCurr,bitIndex419) )
        & ( v2681(VarCurr,bitIndex68)
        <=> v603(VarCurr,bitIndex418) )
        & ( v2681(VarCurr,bitIndex67)
        <=> v603(VarCurr,bitIndex417) )
        & ( v2681(VarCurr,bitIndex66)
        <=> v603(VarCurr,bitIndex416) )
        & ( v2681(VarCurr,bitIndex65)
        <=> v603(VarCurr,bitIndex415) )
        & ( v2681(VarCurr,bitIndex64)
        <=> v603(VarCurr,bitIndex414) )
        & ( v2681(VarCurr,bitIndex63)
        <=> v603(VarCurr,bitIndex413) )
        & ( v2681(VarCurr,bitIndex62)
        <=> v603(VarCurr,bitIndex412) )
        & ( v2681(VarCurr,bitIndex61)
        <=> v603(VarCurr,bitIndex411) )
        & ( v2681(VarCurr,bitIndex60)
        <=> v603(VarCurr,bitIndex410) )
        & ( v2681(VarCurr,bitIndex59)
        <=> v603(VarCurr,bitIndex409) )
        & ( v2681(VarCurr,bitIndex58)
        <=> v603(VarCurr,bitIndex408) )
        & ( v2681(VarCurr,bitIndex57)
        <=> v603(VarCurr,bitIndex407) )
        & ( v2681(VarCurr,bitIndex56)
        <=> v603(VarCurr,bitIndex406) )
        & ( v2681(VarCurr,bitIndex55)
        <=> v603(VarCurr,bitIndex405) )
        & ( v2681(VarCurr,bitIndex54)
        <=> v603(VarCurr,bitIndex404) )
        & ( v2681(VarCurr,bitIndex53)
        <=> v603(VarCurr,bitIndex403) )
        & ( v2681(VarCurr,bitIndex52)
        <=> v603(VarCurr,bitIndex402) )
        & ( v2681(VarCurr,bitIndex51)
        <=> v603(VarCurr,bitIndex401) )
        & ( v2681(VarCurr,bitIndex50)
        <=> v603(VarCurr,bitIndex400) )
        & ( v2681(VarCurr,bitIndex49)
        <=> v603(VarCurr,bitIndex399) )
        & ( v2681(VarCurr,bitIndex48)
        <=> v603(VarCurr,bitIndex398) )
        & ( v2681(VarCurr,bitIndex47)
        <=> v603(VarCurr,bitIndex397) )
        & ( v2681(VarCurr,bitIndex46)
        <=> v603(VarCurr,bitIndex396) )
        & ( v2681(VarCurr,bitIndex45)
        <=> v603(VarCurr,bitIndex395) )
        & ( v2681(VarCurr,bitIndex44)
        <=> v603(VarCurr,bitIndex394) )
        & ( v2681(VarCurr,bitIndex43)
        <=> v603(VarCurr,bitIndex393) )
        & ( v2681(VarCurr,bitIndex42)
        <=> v603(VarCurr,bitIndex392) )
        & ( v2681(VarCurr,bitIndex41)
        <=> v603(VarCurr,bitIndex391) )
        & ( v2681(VarCurr,bitIndex40)
        <=> v603(VarCurr,bitIndex390) )
        & ( v2681(VarCurr,bitIndex39)
        <=> v603(VarCurr,bitIndex389) )
        & ( v2681(VarCurr,bitIndex38)
        <=> v603(VarCurr,bitIndex388) )
        & ( v2681(VarCurr,bitIndex37)
        <=> v603(VarCurr,bitIndex387) )
        & ( v2681(VarCurr,bitIndex36)
        <=> v603(VarCurr,bitIndex386) )
        & ( v2681(VarCurr,bitIndex35)
        <=> v603(VarCurr,bitIndex385) )
        & ( v2681(VarCurr,bitIndex34)
        <=> v603(VarCurr,bitIndex384) )
        & ( v2681(VarCurr,bitIndex33)
        <=> v603(VarCurr,bitIndex383) )
        & ( v2681(VarCurr,bitIndex32)
        <=> v603(VarCurr,bitIndex382) )
        & ( v2681(VarCurr,bitIndex31)
        <=> v603(VarCurr,bitIndex381) )
        & ( v2681(VarCurr,bitIndex30)
        <=> v603(VarCurr,bitIndex380) )
        & ( v2681(VarCurr,bitIndex29)
        <=> v603(VarCurr,bitIndex379) )
        & ( v2681(VarCurr,bitIndex28)
        <=> v603(VarCurr,bitIndex378) )
        & ( v2681(VarCurr,bitIndex27)
        <=> v603(VarCurr,bitIndex377) )
        & ( v2681(VarCurr,bitIndex26)
        <=> v603(VarCurr,bitIndex376) )
        & ( v2681(VarCurr,bitIndex25)
        <=> v603(VarCurr,bitIndex375) )
        & ( v2681(VarCurr,bitIndex24)
        <=> v603(VarCurr,bitIndex374) )
        & ( v2681(VarCurr,bitIndex23)
        <=> v603(VarCurr,bitIndex373) )
        & ( v2681(VarCurr,bitIndex22)
        <=> v603(VarCurr,bitIndex372) )
        & ( v2681(VarCurr,bitIndex21)
        <=> v603(VarCurr,bitIndex371) )
        & ( v2681(VarCurr,bitIndex20)
        <=> v603(VarCurr,bitIndex370) )
        & ( v2681(VarCurr,bitIndex19)
        <=> v603(VarCurr,bitIndex369) )
        & ( v2681(VarCurr,bitIndex18)
        <=> v603(VarCurr,bitIndex368) )
        & ( v2681(VarCurr,bitIndex17)
        <=> v603(VarCurr,bitIndex367) )
        & ( v2681(VarCurr,bitIndex16)
        <=> v603(VarCurr,bitIndex366) )
        & ( v2681(VarCurr,bitIndex15)
        <=> v603(VarCurr,bitIndex365) )
        & ( v2681(VarCurr,bitIndex14)
        <=> v603(VarCurr,bitIndex364) )
        & ( v2681(VarCurr,bitIndex13)
        <=> v603(VarCurr,bitIndex363) )
        & ( v2681(VarCurr,bitIndex12)
        <=> v603(VarCurr,bitIndex362) )
        & ( v2681(VarCurr,bitIndex11)
        <=> v603(VarCurr,bitIndex361) )
        & ( v2681(VarCurr,bitIndex10)
        <=> v603(VarCurr,bitIndex360) )
        & ( v2681(VarCurr,bitIndex9)
        <=> v603(VarCurr,bitIndex359) )
        & ( v2681(VarCurr,bitIndex8)
        <=> v603(VarCurr,bitIndex358) )
        & ( v2681(VarCurr,bitIndex7)
        <=> v603(VarCurr,bitIndex357) )
        & ( v2681(VarCurr,bitIndex6)
        <=> v603(VarCurr,bitIndex356) )
        & ( v2681(VarCurr,bitIndex5)
        <=> v603(VarCurr,bitIndex355) )
        & ( v2681(VarCurr,bitIndex4)
        <=> v603(VarCurr,bitIndex354) )
        & ( v2681(VarCurr,bitIndex3)
        <=> v603(VarCurr,bitIndex353) )
        & ( v2681(VarCurr,bitIndex2)
        <=> v603(VarCurr,bitIndex352) )
        & ( v2681(VarCurr,bitIndex1)
        <=> v603(VarCurr,bitIndex351) )
        & ( v2681(VarCurr,bitIndex0)
        <=> v603(VarCurr,bitIndex350) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_415,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2654(VarNext)
      <=> ( v2655(VarNext)
          & v2662(VarNext) ) ) ) ).

fof(addAssignment_628,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2662(VarNext)
      <=> v2660(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_414,axiom,
    ! [VarCurr] :
      ( v2660(VarCurr)
    <=> ( v2663(VarCurr)
        & v2674(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_413,axiom,
    ! [VarCurr] :
      ( v2674(VarCurr)
    <=> ( v2675(VarCurr)
        | v2617(VarCurr) ) ) ).

fof(writeUnaryOperator_183,axiom,
    ! [VarCurr] :
      ( ~ v2675(VarCurr)
    <=> v2676(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_240,axiom,
    ! [VarCurr] :
      ( v2676(VarCurr)
    <=> ( ( v2677(VarCurr,bitIndex1)
        <=> $false )
        & ( v2677(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_627,axiom,
    ! [VarCurr] :
      ( v2677(VarCurr,bitIndex0)
    <=> v514(VarCurr) ) ).

fof(addAssignment_626,axiom,
    ! [VarCurr] :
      ( v2677(VarCurr,bitIndex1)
    <=> v37(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_412,axiom,
    ! [VarCurr] :
      ( v2663(VarCurr)
    <=> ( v2617(VarCurr)
        | v2664(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_411,axiom,
    ! [VarCurr] :
      ( v2664(VarCurr)
    <=> ( v2665(VarCurr)
        & v2673(VarCurr) ) ) ).

fof(writeUnaryOperator_182,axiom,
    ! [VarCurr] :
      ( ~ v2673(VarCurr)
    <=> v2617(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_410,axiom,
    ! [VarCurr] :
      ( v2665(VarCurr)
    <=> ( v2666(VarCurr)
        | v2671(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_239,axiom,
    ! [VarCurr] :
      ( v2671(VarCurr)
    <=> ( ( v2672(VarCurr,bitIndex1)
        <=> $true )
        & ( v2672(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_625,axiom,
    ! [VarCurr] :
      ( v2672(VarCurr,bitIndex0)
    <=> v514(VarCurr) ) ).

fof(addAssignment_624,axiom,
    ! [VarCurr] :
      ( v2672(VarCurr,bitIndex1)
    <=> v37(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_409,axiom,
    ! [VarCurr] :
      ( v2666(VarCurr)
    <=> ( v2667(VarCurr)
        | v2669(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_238,axiom,
    ! [VarCurr] :
      ( v2669(VarCurr)
    <=> ( ( v2670(VarCurr,bitIndex1)
        <=> $true )
        & ( v2670(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_623,axiom,
    ! [VarCurr] :
      ( v2670(VarCurr,bitIndex0)
    <=> v514(VarCurr) ) ).

fof(addAssignment_622,axiom,
    ! [VarCurr] :
      ( v2670(VarCurr,bitIndex1)
    <=> v37(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_237,axiom,
    ! [VarCurr] :
      ( v2667(VarCurr)
    <=> ( ( v2668(VarCurr,bitIndex1)
        <=> $false )
        & ( v2668(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_621,axiom,
    ! [VarCurr] :
      ( v2668(VarCurr,bitIndex0)
    <=> v514(VarCurr) ) ).

fof(addAssignment_620,axiom,
    ! [VarCurr] :
      ( v2668(VarCurr,bitIndex1)
    <=> v37(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_408,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2655(VarNext)
      <=> ( v2657(VarNext)
          & v618(VarNext) ) ) ) ).

fof(writeUnaryOperator_181,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2657(VarNext)
      <=> v633(VarNext) ) ) ).

fof(addAssignment_619,axiom,
    ! [VarCurr] :
      ( v2646(VarCurr,bitIndex49)
    <=> v2651(VarCurr,bitIndex49) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_54,axiom,
    ! [VarCurr] :
      ( ~ v2648(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v2651(VarCurr,B)
          <=> v2650(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_55,axiom,
    ! [VarCurr] :
      ( v2648(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v2651(VarCurr,B)
          <=> v686(VarCurr,B) ) ) ) ).

fof(addAssignment_618,axiom,
    ! [VarCurr] :
      ( v2650(VarCurr,bitIndex49)
    <=> v603(VarCurr,bitIndex399) ) ).

fof(addAssignment_617,axiom,
    ! [VarCurr] :
      ( v2648(VarCurr)
    <=> v611(VarCurr,bitIndex2) ) ).

fof(addAssignment_616,axiom,
    ! [VarCurr] :
      ( v2639(VarCurr,bitIndex49)
    <=> v2644(VarCurr,bitIndex49) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_53,axiom,
    ! [VarCurr] :
      ( ~ v2641(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v2644(VarCurr,B)
          <=> v2643(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_54,axiom,
    ! [VarCurr] :
      ( v2641(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v2644(VarCurr,B)
          <=> v686(VarCurr,B) ) ) ) ).

fof(addAssignment_615,axiom,
    ! [VarCurr] :
      ( v2643(VarCurr,bitIndex49)
    <=> v603(VarCurr,bitIndex469) ) ).

fof(addAssignment_614,axiom,
    ! [VarCurr] :
      ( v2641(VarCurr)
    <=> v611(VarCurr,bitIndex2) ) ).

fof(addAssignment_613,axiom,
    ! [VarNext] :
      ( v603(VarNext,bitIndex399)
    <=> v2606(VarNext,bitIndex49) ) ).

fof(addCaseBooleanConditionShiftedRanges1_1,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2607(VarNext)
       => ( ( v2606(VarNext,bitIndex69)
          <=> v603(VarCurr,bitIndex419) )
          & ( v2606(VarNext,bitIndex68)
          <=> v603(VarCurr,bitIndex418) )
          & ( v2606(VarNext,bitIndex67)
          <=> v603(VarCurr,bitIndex417) )
          & ( v2606(VarNext,bitIndex66)
          <=> v603(VarCurr,bitIndex416) )
          & ( v2606(VarNext,bitIndex65)
          <=> v603(VarCurr,bitIndex415) )
          & ( v2606(VarNext,bitIndex64)
          <=> v603(VarCurr,bitIndex414) )
          & ( v2606(VarNext,bitIndex63)
          <=> v603(VarCurr,bitIndex413) )
          & ( v2606(VarNext,bitIndex62)
          <=> v603(VarCurr,bitIndex412) )
          & ( v2606(VarNext,bitIndex61)
          <=> v603(VarCurr,bitIndex411) )
          & ( v2606(VarNext,bitIndex60)
          <=> v603(VarCurr,bitIndex410) )
          & ( v2606(VarNext,bitIndex59)
          <=> v603(VarCurr,bitIndex409) )
          & ( v2606(VarNext,bitIndex58)
          <=> v603(VarCurr,bitIndex408) )
          & ( v2606(VarNext,bitIndex57)
          <=> v603(VarCurr,bitIndex407) )
          & ( v2606(VarNext,bitIndex56)
          <=> v603(VarCurr,bitIndex406) )
          & ( v2606(VarNext,bitIndex55)
          <=> v603(VarCurr,bitIndex405) )
          & ( v2606(VarNext,bitIndex54)
          <=> v603(VarCurr,bitIndex404) )
          & ( v2606(VarNext,bitIndex53)
          <=> v603(VarCurr,bitIndex403) )
          & ( v2606(VarNext,bitIndex52)
          <=> v603(VarCurr,bitIndex402) )
          & ( v2606(VarNext,bitIndex51)
          <=> v603(VarCurr,bitIndex401) )
          & ( v2606(VarNext,bitIndex50)
          <=> v603(VarCurr,bitIndex400) )
          & ( v2606(VarNext,bitIndex49)
          <=> v603(VarCurr,bitIndex399) )
          & ( v2606(VarNext,bitIndex48)
          <=> v603(VarCurr,bitIndex398) )
          & ( v2606(VarNext,bitIndex47)
          <=> v603(VarCurr,bitIndex397) )
          & ( v2606(VarNext,bitIndex46)
          <=> v603(VarCurr,bitIndex396) )
          & ( v2606(VarNext,bitIndex45)
          <=> v603(VarCurr,bitIndex395) )
          & ( v2606(VarNext,bitIndex44)
          <=> v603(VarCurr,bitIndex394) )
          & ( v2606(VarNext,bitIndex43)
          <=> v603(VarCurr,bitIndex393) )
          & ( v2606(VarNext,bitIndex42)
          <=> v603(VarCurr,bitIndex392) )
          & ( v2606(VarNext,bitIndex41)
          <=> v603(VarCurr,bitIndex391) )
          & ( v2606(VarNext,bitIndex40)
          <=> v603(VarCurr,bitIndex390) )
          & ( v2606(VarNext,bitIndex39)
          <=> v603(VarCurr,bitIndex389) )
          & ( v2606(VarNext,bitIndex38)
          <=> v603(VarCurr,bitIndex388) )
          & ( v2606(VarNext,bitIndex37)
          <=> v603(VarCurr,bitIndex387) )
          & ( v2606(VarNext,bitIndex36)
          <=> v603(VarCurr,bitIndex386) )
          & ( v2606(VarNext,bitIndex35)
          <=> v603(VarCurr,bitIndex385) )
          & ( v2606(VarNext,bitIndex34)
          <=> v603(VarCurr,bitIndex384) )
          & ( v2606(VarNext,bitIndex33)
          <=> v603(VarCurr,bitIndex383) )
          & ( v2606(VarNext,bitIndex32)
          <=> v603(VarCurr,bitIndex382) )
          & ( v2606(VarNext,bitIndex31)
          <=> v603(VarCurr,bitIndex381) )
          & ( v2606(VarNext,bitIndex30)
          <=> v603(VarCurr,bitIndex380) )
          & ( v2606(VarNext,bitIndex29)
          <=> v603(VarCurr,bitIndex379) )
          & ( v2606(VarNext,bitIndex28)
          <=> v603(VarCurr,bitIndex378) )
          & ( v2606(VarNext,bitIndex27)
          <=> v603(VarCurr,bitIndex377) )
          & ( v2606(VarNext,bitIndex26)
          <=> v603(VarCurr,bitIndex376) )
          & ( v2606(VarNext,bitIndex25)
          <=> v603(VarCurr,bitIndex375) )
          & ( v2606(VarNext,bitIndex24)
          <=> v603(VarCurr,bitIndex374) )
          & ( v2606(VarNext,bitIndex23)
          <=> v603(VarCurr,bitIndex373) )
          & ( v2606(VarNext,bitIndex22)
          <=> v603(VarCurr,bitIndex372) )
          & ( v2606(VarNext,bitIndex21)
          <=> v603(VarCurr,bitIndex371) )
          & ( v2606(VarNext,bitIndex20)
          <=> v603(VarCurr,bitIndex370) )
          & ( v2606(VarNext,bitIndex19)
          <=> v603(VarCurr,bitIndex369) )
          & ( v2606(VarNext,bitIndex18)
          <=> v603(VarCurr,bitIndex368) )
          & ( v2606(VarNext,bitIndex17)
          <=> v603(VarCurr,bitIndex367) )
          & ( v2606(VarNext,bitIndex16)
          <=> v603(VarCurr,bitIndex366) )
          & ( v2606(VarNext,bitIndex15)
          <=> v603(VarCurr,bitIndex365) )
          & ( v2606(VarNext,bitIndex14)
          <=> v603(VarCurr,bitIndex364) )
          & ( v2606(VarNext,bitIndex13)
          <=> v603(VarCurr,bitIndex363) )
          & ( v2606(VarNext,bitIndex12)
          <=> v603(VarCurr,bitIndex362) )
          & ( v2606(VarNext,bitIndex11)
          <=> v603(VarCurr,bitIndex361) )
          & ( v2606(VarNext,bitIndex10)
          <=> v603(VarCurr,bitIndex360) )
          & ( v2606(VarNext,bitIndex9)
          <=> v603(VarCurr,bitIndex359) )
          & ( v2606(VarNext,bitIndex8)
          <=> v603(VarCurr,bitIndex358) )
          & ( v2606(VarNext,bitIndex7)
          <=> v603(VarCurr,bitIndex357) )
          & ( v2606(VarNext,bitIndex6)
          <=> v603(VarCurr,bitIndex356) )
          & ( v2606(VarNext,bitIndex5)
          <=> v603(VarCurr,bitIndex355) )
          & ( v2606(VarNext,bitIndex4)
          <=> v603(VarCurr,bitIndex354) )
          & ( v2606(VarNext,bitIndex3)
          <=> v603(VarCurr,bitIndex353) )
          & ( v2606(VarNext,bitIndex2)
          <=> v603(VarCurr,bitIndex352) )
          & ( v2606(VarNext,bitIndex1)
          <=> v603(VarCurr,bitIndex351) )
          & ( v2606(VarNext,bitIndex0)
          <=> v603(VarCurr,bitIndex350) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_28,axiom,
    ! [VarNext] :
      ( v2607(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v2606(VarNext,B)
          <=> v2634(VarNext,B) ) ) ) ).

fof(addAssignment_612,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v2634(VarNext,B)
          <=> v2632(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_80,axiom,
    ! [VarCurr] :
      ( ~ v2617(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v2632(VarCurr,B)
          <=> v2635(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_79,axiom,
    ! [VarCurr] :
      ( v2617(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v2632(VarCurr,B)
          <=> $false ) ) ) ).

fof(bitBlastConstant_884,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex69) ).

fof(bitBlastConstant_883,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex68) ).

fof(bitBlastConstant_882,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex67) ).

fof(bitBlastConstant_881,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex66) ).

fof(bitBlastConstant_880,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex65) ).

fof(bitBlastConstant_879,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex64) ).

fof(bitBlastConstant_878,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex63) ).

fof(bitBlastConstant_877,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex62) ).

fof(bitBlastConstant_876,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex61) ).

fof(bitBlastConstant_875,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex60) ).

fof(bitBlastConstant_874,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex59) ).

fof(bitBlastConstant_873,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex58) ).

fof(bitBlastConstant_872,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex57) ).

fof(bitBlastConstant_871,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex56) ).

fof(bitBlastConstant_870,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex55) ).

fof(bitBlastConstant_869,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex54) ).

fof(bitBlastConstant_868,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex53) ).

fof(bitBlastConstant_867,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex52) ).

fof(bitBlastConstant_866,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex51) ).

fof(bitBlastConstant_865,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex50) ).

fof(bitBlastConstant_864,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex49) ).

fof(bitBlastConstant_863,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex48) ).

fof(bitBlastConstant_862,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex47) ).

fof(bitBlastConstant_861,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex46) ).

fof(bitBlastConstant_860,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex45) ).

fof(bitBlastConstant_859,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex44) ).

fof(bitBlastConstant_858,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex43) ).

fof(bitBlastConstant_857,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex42) ).

fof(bitBlastConstant_856,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex41) ).

fof(bitBlastConstant_855,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex40) ).

fof(bitBlastConstant_854,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex39) ).

fof(bitBlastConstant_853,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex38) ).

fof(bitBlastConstant_852,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex37) ).

fof(bitBlastConstant_851,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex36) ).

fof(bitBlastConstant_850,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex35) ).

fof(bitBlastConstant_849,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex34) ).

fof(bitBlastConstant_848,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex33) ).

fof(bitBlastConstant_847,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex32) ).

fof(bitBlastConstant_846,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex31) ).

fof(bitBlastConstant_845,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex30) ).

fof(bitBlastConstant_844,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex29) ).

fof(bitBlastConstant_843,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex28) ).

fof(bitBlastConstant_842,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex27) ).

fof(bitBlastConstant_841,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex26) ).

fof(bitBlastConstant_840,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex25) ).

fof(bitBlastConstant_839,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex24) ).

fof(bitBlastConstant_838,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex23) ).

fof(bitBlastConstant_837,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex22) ).

fof(bitBlastConstant_836,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex21) ).

fof(bitBlastConstant_835,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex20) ).

fof(bitBlastConstant_834,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex19) ).

fof(bitBlastConstant_833,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex18) ).

fof(bitBlastConstant_832,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex17) ).

fof(bitBlastConstant_831,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex16) ).

fof(bitBlastConstant_830,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex15) ).

fof(bitBlastConstant_829,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex14) ).

fof(bitBlastConstant_828,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex13) ).

fof(bitBlastConstant_827,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex12) ).

fof(bitBlastConstant_826,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex11) ).

fof(bitBlastConstant_825,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex10) ).

fof(bitBlastConstant_824,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex9) ).

fof(bitBlastConstant_823,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex8) ).

fof(bitBlastConstant_822,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex7) ).

fof(bitBlastConstant_821,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex6) ).

fof(bitBlastConstant_820,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex5) ).

fof(bitBlastConstant_819,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex4) ).

fof(bitBlastConstant_818,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex3) ).

fof(bitBlastConstant_817,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex2) ).

fof(bitBlastConstant_816,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex1) ).

fof(bitBlastConstant_815,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges2_30,axiom,
    ! [VarCurr] :
      ( ( ~ v2621(VarCurr)
        & ~ v2623(VarCurr) )
     => ! [B] :
          ( range_69_0(B)
         => ( v2635(VarCurr,B)
          <=> v2599(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_79,axiom,
    ! [VarCurr] :
      ( v2623(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v2635(VarCurr,B)
          <=> v607(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_2,axiom,
    ! [VarCurr] :
      ( v2621(VarCurr)
     => ( ( v2635(VarCurr,bitIndex69)
        <=> v603(VarCurr,bitIndex349) )
        & ( v2635(VarCurr,bitIndex68)
        <=> v603(VarCurr,bitIndex348) )
        & ( v2635(VarCurr,bitIndex67)
        <=> v603(VarCurr,bitIndex347) )
        & ( v2635(VarCurr,bitIndex66)
        <=> v603(VarCurr,bitIndex346) )
        & ( v2635(VarCurr,bitIndex65)
        <=> v603(VarCurr,bitIndex345) )
        & ( v2635(VarCurr,bitIndex64)
        <=> v603(VarCurr,bitIndex344) )
        & ( v2635(VarCurr,bitIndex63)
        <=> v603(VarCurr,bitIndex343) )
        & ( v2635(VarCurr,bitIndex62)
        <=> v603(VarCurr,bitIndex342) )
        & ( v2635(VarCurr,bitIndex61)
        <=> v603(VarCurr,bitIndex341) )
        & ( v2635(VarCurr,bitIndex60)
        <=> v603(VarCurr,bitIndex340) )
        & ( v2635(VarCurr,bitIndex59)
        <=> v603(VarCurr,bitIndex339) )
        & ( v2635(VarCurr,bitIndex58)
        <=> v603(VarCurr,bitIndex338) )
        & ( v2635(VarCurr,bitIndex57)
        <=> v603(VarCurr,bitIndex337) )
        & ( v2635(VarCurr,bitIndex56)
        <=> v603(VarCurr,bitIndex336) )
        & ( v2635(VarCurr,bitIndex55)
        <=> v603(VarCurr,bitIndex335) )
        & ( v2635(VarCurr,bitIndex54)
        <=> v603(VarCurr,bitIndex334) )
        & ( v2635(VarCurr,bitIndex53)
        <=> v603(VarCurr,bitIndex333) )
        & ( v2635(VarCurr,bitIndex52)
        <=> v603(VarCurr,bitIndex332) )
        & ( v2635(VarCurr,bitIndex51)
        <=> v603(VarCurr,bitIndex331) )
        & ( v2635(VarCurr,bitIndex50)
        <=> v603(VarCurr,bitIndex330) )
        & ( v2635(VarCurr,bitIndex49)
        <=> v603(VarCurr,bitIndex329) )
        & ( v2635(VarCurr,bitIndex48)
        <=> v603(VarCurr,bitIndex328) )
        & ( v2635(VarCurr,bitIndex47)
        <=> v603(VarCurr,bitIndex327) )
        & ( v2635(VarCurr,bitIndex46)
        <=> v603(VarCurr,bitIndex326) )
        & ( v2635(VarCurr,bitIndex45)
        <=> v603(VarCurr,bitIndex325) )
        & ( v2635(VarCurr,bitIndex44)
        <=> v603(VarCurr,bitIndex324) )
        & ( v2635(VarCurr,bitIndex43)
        <=> v603(VarCurr,bitIndex323) )
        & ( v2635(VarCurr,bitIndex42)
        <=> v603(VarCurr,bitIndex322) )
        & ( v2635(VarCurr,bitIndex41)
        <=> v603(VarCurr,bitIndex321) )
        & ( v2635(VarCurr,bitIndex40)
        <=> v603(VarCurr,bitIndex320) )
        & ( v2635(VarCurr,bitIndex39)
        <=> v603(VarCurr,bitIndex319) )
        & ( v2635(VarCurr,bitIndex38)
        <=> v603(VarCurr,bitIndex318) )
        & ( v2635(VarCurr,bitIndex37)
        <=> v603(VarCurr,bitIndex317) )
        & ( v2635(VarCurr,bitIndex36)
        <=> v603(VarCurr,bitIndex316) )
        & ( v2635(VarCurr,bitIndex35)
        <=> v603(VarCurr,bitIndex315) )
        & ( v2635(VarCurr,bitIndex34)
        <=> v603(VarCurr,bitIndex314) )
        & ( v2635(VarCurr,bitIndex33)
        <=> v603(VarCurr,bitIndex313) )
        & ( v2635(VarCurr,bitIndex32)
        <=> v603(VarCurr,bitIndex312) )
        & ( v2635(VarCurr,bitIndex31)
        <=> v603(VarCurr,bitIndex311) )
        & ( v2635(VarCurr,bitIndex30)
        <=> v603(VarCurr,bitIndex310) )
        & ( v2635(VarCurr,bitIndex29)
        <=> v603(VarCurr,bitIndex309) )
        & ( v2635(VarCurr,bitIndex28)
        <=> v603(VarCurr,bitIndex308) )
        & ( v2635(VarCurr,bitIndex27)
        <=> v603(VarCurr,bitIndex307) )
        & ( v2635(VarCurr,bitIndex26)
        <=> v603(VarCurr,bitIndex306) )
        & ( v2635(VarCurr,bitIndex25)
        <=> v603(VarCurr,bitIndex305) )
        & ( v2635(VarCurr,bitIndex24)
        <=> v603(VarCurr,bitIndex304) )
        & ( v2635(VarCurr,bitIndex23)
        <=> v603(VarCurr,bitIndex303) )
        & ( v2635(VarCurr,bitIndex22)
        <=> v603(VarCurr,bitIndex302) )
        & ( v2635(VarCurr,bitIndex21)
        <=> v603(VarCurr,bitIndex301) )
        & ( v2635(VarCurr,bitIndex20)
        <=> v603(VarCurr,bitIndex300) )
        & ( v2635(VarCurr,bitIndex19)
        <=> v603(VarCurr,bitIndex299) )
        & ( v2635(VarCurr,bitIndex18)
        <=> v603(VarCurr,bitIndex298) )
        & ( v2635(VarCurr,bitIndex17)
        <=> v603(VarCurr,bitIndex297) )
        & ( v2635(VarCurr,bitIndex16)
        <=> v603(VarCurr,bitIndex296) )
        & ( v2635(VarCurr,bitIndex15)
        <=> v603(VarCurr,bitIndex295) )
        & ( v2635(VarCurr,bitIndex14)
        <=> v603(VarCurr,bitIndex294) )
        & ( v2635(VarCurr,bitIndex13)
        <=> v603(VarCurr,bitIndex293) )
        & ( v2635(VarCurr,bitIndex12)
        <=> v603(VarCurr,bitIndex292) )
        & ( v2635(VarCurr,bitIndex11)
        <=> v603(VarCurr,bitIndex291) )
        & ( v2635(VarCurr,bitIndex10)
        <=> v603(VarCurr,bitIndex290) )
        & ( v2635(VarCurr,bitIndex9)
        <=> v603(VarCurr,bitIndex289) )
        & ( v2635(VarCurr,bitIndex8)
        <=> v603(VarCurr,bitIndex288) )
        & ( v2635(VarCurr,bitIndex7)
        <=> v603(VarCurr,bitIndex287) )
        & ( v2635(VarCurr,bitIndex6)
        <=> v603(VarCurr,bitIndex286) )
        & ( v2635(VarCurr,bitIndex5)
        <=> v603(VarCurr,bitIndex285) )
        & ( v2635(VarCurr,bitIndex4)
        <=> v603(VarCurr,bitIndex284) )
        & ( v2635(VarCurr,bitIndex3)
        <=> v603(VarCurr,bitIndex283) )
        & ( v2635(VarCurr,bitIndex2)
        <=> v603(VarCurr,bitIndex282) )
        & ( v2635(VarCurr,bitIndex1)
        <=> v603(VarCurr,bitIndex281) )
        & ( v2635(VarCurr,bitIndex0)
        <=> v603(VarCurr,bitIndex280) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_407,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2607(VarNext)
      <=> ( v2608(VarNext)
          & v2615(VarNext) ) ) ) ).

fof(addAssignment_611,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2615(VarNext)
      <=> v2613(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_406,axiom,
    ! [VarCurr] :
      ( v2613(VarCurr)
    <=> ( v2616(VarCurr)
        & v2628(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_405,axiom,
    ! [VarCurr] :
      ( v2628(VarCurr)
    <=> ( v2629(VarCurr)
        | v2617(VarCurr) ) ) ).

fof(writeUnaryOperator_180,axiom,
    ! [VarCurr] :
      ( ~ v2629(VarCurr)
    <=> v2630(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_236,axiom,
    ! [VarCurr] :
      ( v2630(VarCurr)
    <=> ( ( v2631(VarCurr,bitIndex1)
        <=> $false )
        & ( v2631(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_610,axiom,
    ! [VarCurr] :
      ( v2631(VarCurr,bitIndex0)
    <=> v514(VarCurr) ) ).

fof(addAssignment_609,axiom,
    ! [VarCurr] :
      ( v2631(VarCurr,bitIndex1)
    <=> v37(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_404,axiom,
    ! [VarCurr] :
      ( v2616(VarCurr)
    <=> ( v2617(VarCurr)
        | v2618(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_403,axiom,
    ! [VarCurr] :
      ( v2618(VarCurr)
    <=> ( v2619(VarCurr)
        & v2627(VarCurr) ) ) ).

fof(writeUnaryOperator_179,axiom,
    ! [VarCurr] :
      ( ~ v2627(VarCurr)
    <=> v2617(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_402,axiom,
    ! [VarCurr] :
      ( v2619(VarCurr)
    <=> ( v2620(VarCurr)
        | v2625(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_235,axiom,
    ! [VarCurr] :
      ( v2625(VarCurr)
    <=> ( ( v2626(VarCurr,bitIndex1)
        <=> $true )
        & ( v2626(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_608,axiom,
    ! [VarCurr] :
      ( v2626(VarCurr,bitIndex0)
    <=> v514(VarCurr) ) ).

fof(addAssignment_607,axiom,
    ! [VarCurr] :
      ( v2626(VarCurr,bitIndex1)
    <=> v37(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_401,axiom,
    ! [VarCurr] :
      ( v2620(VarCurr)
    <=> ( v2621(VarCurr)
        | v2623(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_234,axiom,
    ! [VarCurr] :
      ( v2623(VarCurr)
    <=> ( ( v2624(VarCurr,bitIndex1)
        <=> $true )
        & ( v2624(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_606,axiom,
    ! [VarCurr] :
      ( v2624(VarCurr,bitIndex0)
    <=> v514(VarCurr) ) ).

fof(addAssignment_605,axiom,
    ! [VarCurr] :
      ( v2624(VarCurr,bitIndex1)
    <=> v37(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_233,axiom,
    ! [VarCurr] :
      ( v2621(VarCurr)
    <=> ( ( v2622(VarCurr,bitIndex1)
        <=> $false )
        & ( v2622(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_604,axiom,
    ! [VarCurr] :
      ( v2622(VarCurr,bitIndex0)
    <=> v514(VarCurr) ) ).

fof(addAssignment_603,axiom,
    ! [VarCurr] :
      ( v2622(VarCurr,bitIndex1)
    <=> v37(VarCurr) ) ).

fof(writeUnaryOperator_178,axiom,
    ! [VarCurr] :
      ( ~ v2617(VarCurr)
    <=> v33(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_400,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2608(VarNext)
      <=> ( v2609(VarNext)
          & v618(VarNext) ) ) ) ).

fof(writeUnaryOperator_177,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2609(VarNext)
      <=> v633(VarNext) ) ) ).

fof(addAssignment_602,axiom,
    ! [VarCurr] :
      ( v2599(VarCurr,bitIndex49)
    <=> v2604(VarCurr,bitIndex49) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_52,axiom,
    ! [VarCurr] :
      ( ~ v2601(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v2604(VarCurr,B)
          <=> v2603(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_53,axiom,
    ! [VarCurr] :
      ( v2601(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v2604(VarCurr,B)
          <=> v686(VarCurr,B) ) ) ) ).

fof(addAssignment_601,axiom,
    ! [VarCurr] :
      ( v2603(VarCurr,bitIndex49)
    <=> v603(VarCurr,bitIndex329) ) ).

fof(addAssignment_600,axiom,
    ! [VarCurr] :
      ( v2601(VarCurr)
    <=> v611(VarCurr,bitIndex3) ) ).

fof(addAssignment_599,axiom,
    ! [VarCurr] :
      ( v607(VarCurr,bitIndex49)
    <=> v2597(VarCurr,bitIndex49) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_51,axiom,
    ! [VarCurr] :
      ( ~ v609(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v2597(VarCurr,B)
          <=> v2588(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_52,axiom,
    ! [VarCurr] :
      ( v609(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v2597(VarCurr,B)
          <=> v686(VarCurr,B) ) ) ) ).

fof(range_axiom_16,axiom,
    ! [B] :
      ( range_69_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B
        | bitIndex30 = B
        | bitIndex31 = B
        | bitIndex32 = B
        | bitIndex33 = B
        | bitIndex34 = B
        | bitIndex35 = B
        | bitIndex36 = B
        | bitIndex37 = B
        | bitIndex38 = B
        | bitIndex39 = B
        | bitIndex40 = B
        | bitIndex41 = B
        | bitIndex42 = B
        | bitIndex43 = B
        | bitIndex44 = B
        | bitIndex45 = B
        | bitIndex46 = B
        | bitIndex47 = B
        | bitIndex48 = B
        | bitIndex49 = B
        | bitIndex50 = B
        | bitIndex51 = B
        | bitIndex52 = B
        | bitIndex53 = B
        | bitIndex54 = B
        | bitIndex55 = B
        | bitIndex56 = B
        | bitIndex57 = B
        | bitIndex58 = B
        | bitIndex59 = B
        | bitIndex60 = B
        | bitIndex61 = B
        | bitIndex62 = B
        | bitIndex63 = B
        | bitIndex64 = B
        | bitIndex65 = B
        | bitIndex66 = B
        | bitIndex67 = B
        | bitIndex68 = B
        | bitIndex69 = B ) ) ).

fof(addAssignment_598,axiom,
    ! [VarCurr] :
      ( v2588(VarCurr,bitIndex49)
    <=> v603(VarCurr,bitIndex399) ) ).

fof(addAssignmentInitValue_141,axiom,
    ~ v603(constB0,bitIndex559) ).

fof(addAssignmentInitValue_140,axiom,
    ~ v603(constB0,bitIndex558) ).

fof(addAssignmentInitValue_139,axiom,
    ~ v603(constB0,bitIndex557) ).

fof(addAssignmentInitValue_138,axiom,
    ~ v603(constB0,bitIndex556) ).

fof(addAssignmentInitValue_137,axiom,
    ~ v603(constB0,bitIndex555) ).

fof(addAssignmentInitValue_136,axiom,
    ~ v603(constB0,bitIndex554) ).

fof(addAssignmentInitValue_135,axiom,
    ~ v603(constB0,bitIndex553) ).

fof(addAssignmentInitValue_134,axiom,
    ~ v603(constB0,bitIndex539) ).

fof(bitBlastConstant_814,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex69) ).

fof(bitBlastConstant_813,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex68) ).

fof(bitBlastConstant_812,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex67) ).

fof(bitBlastConstant_811,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex66) ).

fof(bitBlastConstant_810,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex65) ).

fof(bitBlastConstant_809,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex64) ).

fof(bitBlastConstant_808,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex63) ).

fof(bitBlastConstant_807,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex49) ).

fof(addAssignmentInitValue_133,axiom,
    ~ v603(constB0,bitIndex489) ).

fof(addAssignmentInitValue_132,axiom,
    ~ v603(constB0,bitIndex488) ).

fof(addAssignmentInitValue_131,axiom,
    ~ v603(constB0,bitIndex487) ).

fof(addAssignmentInitValue_130,axiom,
    ~ v603(constB0,bitIndex486) ).

fof(addAssignmentInitValue_129,axiom,
    ~ v603(constB0,bitIndex485) ).

fof(addAssignmentInitValue_128,axiom,
    ~ v603(constB0,bitIndex484) ).

fof(addAssignmentInitValue_127,axiom,
    ~ v603(constB0,bitIndex483) ).

fof(addAssignmentInitValue_126,axiom,
    ~ v603(constB0,bitIndex469) ).

fof(bitBlastConstant_806,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex69) ).

fof(bitBlastConstant_805,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex68) ).

fof(bitBlastConstant_804,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex67) ).

fof(bitBlastConstant_803,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex66) ).

fof(bitBlastConstant_802,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex65) ).

fof(bitBlastConstant_801,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex64) ).

fof(bitBlastConstant_800,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex63) ).

fof(bitBlastConstant_799,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex49) ).

fof(addAssignmentInitValue_125,axiom,
    ~ v603(constB0,bitIndex419) ).

fof(addAssignmentInitValue_124,axiom,
    ~ v603(constB0,bitIndex418) ).

fof(addAssignmentInitValue_123,axiom,
    ~ v603(constB0,bitIndex417) ).

fof(addAssignmentInitValue_122,axiom,
    ~ v603(constB0,bitIndex416) ).

fof(addAssignmentInitValue_121,axiom,
    ~ v603(constB0,bitIndex415) ).

fof(addAssignmentInitValue_120,axiom,
    ~ v603(constB0,bitIndex414) ).

fof(addAssignmentInitValue_119,axiom,
    ~ v603(constB0,bitIndex413) ).

fof(addAssignmentInitValue_118,axiom,
    ~ v603(constB0,bitIndex399) ).

fof(bitBlastConstant_798,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex69) ).

fof(bitBlastConstant_797,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex68) ).

fof(bitBlastConstant_796,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex67) ).

fof(bitBlastConstant_795,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex66) ).

fof(bitBlastConstant_794,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex65) ).

fof(bitBlastConstant_793,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex64) ).

fof(bitBlastConstant_792,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex63) ).

fof(bitBlastConstant_791,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex49) ).

fof(addAssignmentInitValue_117,axiom,
    ~ v603(constB0,bitIndex349) ).

fof(addAssignmentInitValue_116,axiom,
    ~ v603(constB0,bitIndex348) ).

fof(addAssignmentInitValue_115,axiom,
    ~ v603(constB0,bitIndex347) ).

fof(addAssignmentInitValue_114,axiom,
    ~ v603(constB0,bitIndex346) ).

fof(addAssignmentInitValue_113,axiom,
    ~ v603(constB0,bitIndex345) ).

fof(addAssignmentInitValue_112,axiom,
    ~ v603(constB0,bitIndex344) ).

fof(addAssignmentInitValue_111,axiom,
    ~ v603(constB0,bitIndex343) ).

fof(addAssignmentInitValue_110,axiom,
    ~ v603(constB0,bitIndex329) ).

fof(bitBlastConstant_790,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex69) ).

fof(bitBlastConstant_789,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex68) ).

fof(bitBlastConstant_788,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex67) ).

fof(bitBlastConstant_787,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex66) ).

fof(bitBlastConstant_786,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex65) ).

fof(bitBlastConstant_785,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex64) ).

fof(bitBlastConstant_784,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex63) ).

fof(bitBlastConstant_783,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex49) ).

fof(addAssignment_597,axiom,
    ! [VarCurr] :
      ( v686(VarCurr,bitIndex49)
    <=> v688(VarCurr,bitIndex49) ) ).

fof(addAssignment_596,axiom,
    ! [VarCurr] :
      ( v688(VarCurr,bitIndex49)
    <=> v690(VarCurr,bitIndex49) ) ).

fof(addAssignment_595,axiom,
    ! [VarCurr] :
      ( v690(VarCurr,bitIndex49)
    <=> v692(VarCurr,bitIndex49) ) ).

fof(addAssignment_594,axiom,
    ! [VarCurr] :
      ( v692(VarCurr,bitIndex49)
    <=> v694(VarCurr,bitIndex49) ) ).

fof(addAssignment_593,axiom,
    ! [VarCurr] :
      ( v694(VarCurr,bitIndex49)
    <=> v696(VarCurr,bitIndex49) ) ).

fof(addAssignment_592,axiom,
    ! [VarCurr] :
      ( v696(VarCurr,bitIndex49)
    <=> v698(VarCurr,bitIndex49) ) ).

fof(addAssignment_591,axiom,
    ! [VarCurr] :
      ( v698(VarCurr,bitIndex49)
    <=> v2576(VarCurr,bitIndex49) ) ).

fof(addAssignment_590,axiom,
    ! [VarCurr,B] :
      ( range_5_0(B)
     => ( v2576(VarCurr,B)
      <=> v2585(VarCurr,B) ) ) ).

fof(range_axiom_15,axiom,
    ! [B] :
      ( range_5_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B ) ) ).

fof(addAssignment_589,axiom,
    ! [VarCurr] :
      ( ( v2576(VarCurr,bitIndex10)
      <=> v2583(VarCurr,bitIndex4) )
      & ( v2576(VarCurr,bitIndex9)
      <=> v2583(VarCurr,bitIndex3) )
      & ( v2576(VarCurr,bitIndex8)
      <=> v2583(VarCurr,bitIndex2) )
      & ( v2576(VarCurr,bitIndex7)
      <=> v2583(VarCurr,bitIndex1) )
      & ( v2576(VarCurr,bitIndex6)
      <=> v2583(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_588,axiom,
    ! [VarCurr] :
      ( ( v2576(VarCurr,bitIndex44)
      <=> v2581(VarCurr,bitIndex33) )
      & ( v2576(VarCurr,bitIndex43)
      <=> v2581(VarCurr,bitIndex32) )
      & ( v2576(VarCurr,bitIndex42)
      <=> v2581(VarCurr,bitIndex31) )
      & ( v2576(VarCurr,bitIndex41)
      <=> v2581(VarCurr,bitIndex30) )
      & ( v2576(VarCurr,bitIndex40)
      <=> v2581(VarCurr,bitIndex29) )
      & ( v2576(VarCurr,bitIndex39)
      <=> v2581(VarCurr,bitIndex28) )
      & ( v2576(VarCurr,bitIndex38)
      <=> v2581(VarCurr,bitIndex27) )
      & ( v2576(VarCurr,bitIndex37)
      <=> v2581(VarCurr,bitIndex26) )
      & ( v2576(VarCurr,bitIndex36)
      <=> v2581(VarCurr,bitIndex25) )
      & ( v2576(VarCurr,bitIndex35)
      <=> v2581(VarCurr,bitIndex24) )
      & ( v2576(VarCurr,bitIndex34)
      <=> v2581(VarCurr,bitIndex23) )
      & ( v2576(VarCurr,bitIndex33)
      <=> v2581(VarCurr,bitIndex22) )
      & ( v2576(VarCurr,bitIndex32)
      <=> v2581(VarCurr,bitIndex21) )
      & ( v2576(VarCurr,bitIndex31)
      <=> v2581(VarCurr,bitIndex20) )
      & ( v2576(VarCurr,bitIndex30)
      <=> v2581(VarCurr,bitIndex19) )
      & ( v2576(VarCurr,bitIndex29)
      <=> v2581(VarCurr,bitIndex18) )
      & ( v2576(VarCurr,bitIndex28)
      <=> v2581(VarCurr,bitIndex17) )
      & ( v2576(VarCurr,bitIndex27)
      <=> v2581(VarCurr,bitIndex16) )
      & ( v2576(VarCurr,bitIndex26)
      <=> v2581(VarCurr,bitIndex15) )
      & ( v2576(VarCurr,bitIndex25)
      <=> v2581(VarCurr,bitIndex14) )
      & ( v2576(VarCurr,bitIndex24)
      <=> v2581(VarCurr,bitIndex13) )
      & ( v2576(VarCurr,bitIndex23)
      <=> v2581(VarCurr,bitIndex12) )
      & ( v2576(VarCurr,bitIndex22)
      <=> v2581(VarCurr,bitIndex11) )
      & ( v2576(VarCurr,bitIndex21)
      <=> v2581(VarCurr,bitIndex10) )
      & ( v2576(VarCurr,bitIndex20)
      <=> v2581(VarCurr,bitIndex9) )
      & ( v2576(VarCurr,bitIndex19)
      <=> v2581(VarCurr,bitIndex8) )
      & ( v2576(VarCurr,bitIndex18)
      <=> v2581(VarCurr,bitIndex7) )
      & ( v2576(VarCurr,bitIndex17)
      <=> v2581(VarCurr,bitIndex6) )
      & ( v2576(VarCurr,bitIndex16)
      <=> v2581(VarCurr,bitIndex5) )
      & ( v2576(VarCurr,bitIndex15)
      <=> v2581(VarCurr,bitIndex4) )
      & ( v2576(VarCurr,bitIndex14)
      <=> v2581(VarCurr,bitIndex3) )
      & ( v2576(VarCurr,bitIndex13)
      <=> v2581(VarCurr,bitIndex2) )
      & ( v2576(VarCurr,bitIndex12)
      <=> v2581(VarCurr,bitIndex1) )
      & ( v2576(VarCurr,bitIndex11)
      <=> v2581(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_587,axiom,
    ! [VarCurr] :
      ( ( v2576(VarCurr,bitIndex52)
      <=> v700(VarCurr,bitIndex7) )
      & ( v2576(VarCurr,bitIndex51)
      <=> v700(VarCurr,bitIndex6) )
      & ( v2576(VarCurr,bitIndex50)
      <=> v700(VarCurr,bitIndex5) )
      & ( v2576(VarCurr,bitIndex49)
      <=> v700(VarCurr,bitIndex4) )
      & ( v2576(VarCurr,bitIndex48)
      <=> v700(VarCurr,bitIndex3) )
      & ( v2576(VarCurr,bitIndex47)
      <=> v700(VarCurr,bitIndex2) )
      & ( v2576(VarCurr,bitIndex46)
      <=> v700(VarCurr,bitIndex1) )
      & ( v2576(VarCurr,bitIndex45)
      <=> v700(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_586,axiom,
    ! [VarCurr] :
      ( ( v2576(VarCurr,bitIndex62)
      <=> v2579(VarCurr,bitIndex9) )
      & ( v2576(VarCurr,bitIndex61)
      <=> v2579(VarCurr,bitIndex8) )
      & ( v2576(VarCurr,bitIndex60)
      <=> v2579(VarCurr,bitIndex7) )
      & ( v2576(VarCurr,bitIndex59)
      <=> v2579(VarCurr,bitIndex6) )
      & ( v2576(VarCurr,bitIndex58)
      <=> v2579(VarCurr,bitIndex5) )
      & ( v2576(VarCurr,bitIndex57)
      <=> v2579(VarCurr,bitIndex4) )
      & ( v2576(VarCurr,bitIndex56)
      <=> v2579(VarCurr,bitIndex3) )
      & ( v2576(VarCurr,bitIndex55)
      <=> v2579(VarCurr,bitIndex2) )
      & ( v2576(VarCurr,bitIndex54)
      <=> v2579(VarCurr,bitIndex1) )
      & ( v2576(VarCurr,bitIndex53)
      <=> v2579(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_585,axiom,
    ! [VarCurr] :
      ( ( v2576(VarCurr,bitIndex69)
      <=> v2577(VarCurr,bitIndex6) )
      & ( v2576(VarCurr,bitIndex68)
      <=> v2577(VarCurr,bitIndex5) )
      & ( v2576(VarCurr,bitIndex67)
      <=> v2577(VarCurr,bitIndex4) )
      & ( v2576(VarCurr,bitIndex66)
      <=> v2577(VarCurr,bitIndex3) )
      & ( v2576(VarCurr,bitIndex65)
      <=> v2577(VarCurr,bitIndex2) )
      & ( v2576(VarCurr,bitIndex64)
      <=> v2577(VarCurr,bitIndex1) )
      & ( v2576(VarCurr,bitIndex63)
      <=> v2577(VarCurr,bitIndex0) ) ) ).

fof(addAssignmentInitValueVector_39,axiom,
    ! [B] :
      ( range_6_0(B)
     => ( v2577(constB0,B)
      <=> $false ) ) ).

fof(addAssignment_584,axiom,
    ! [VarNext] :
      ( v700(VarNext,bitIndex4)
    <=> v2530(VarNext,bitIndex4) ) ).

fof(addCaseBooleanConditionEqualRanges1_27,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2531(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v2530(VarNext,B)
            <=> v700(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_27,axiom,
    ! [VarNext] :
      ( v2531(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v2530(VarNext,B)
          <=> v2566(VarNext,B) ) ) ) ).

fof(addAssignment_583,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v2566(VarNext,B)
          <=> v2564(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_78,axiom,
    ! [VarCurr] :
      ( ~ v2541(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v2564(VarCurr,B)
          <=> v2567(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_78,axiom,
    ! [VarCurr] :
      ( v2541(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v2564(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_77,axiom,
    ! [VarCurr] :
      ( ~ v2544(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v2567(VarCurr,B)
          <=> v2501(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_77,axiom,
    ! [VarCurr] :
      ( v2544(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v2567(VarCurr,B)
          <=> v2568(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_76,axiom,
    ! [VarCurr] :
      ( ~ v2555(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v2568(VarCurr,B)
          <=> v2570(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_76,axiom,
    ! [VarCurr] :
      ( v2555(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v2568(VarCurr,B)
          <=> v2569(VarCurr,B) ) ) ) ).

fof(addAssignment_582,axiom,
    ! [VarCurr] :
      ( ( v2570(VarCurr,bitIndex3)
      <=> v1824(VarCurr,bitIndex31) )
      & ( v2570(VarCurr,bitIndex2)
      <=> v1824(VarCurr,bitIndex30) )
      & ( v2570(VarCurr,bitIndex1)
      <=> v1824(VarCurr,bitIndex29) )
      & ( v2570(VarCurr,bitIndex0)
      <=> v1824(VarCurr,bitIndex28) ) ) ).

fof(addAssignment_581,axiom,
    ! [VarCurr] :
      ( ( v2570(VarCurr,bitIndex7)
      <=> v2571(VarCurr,bitIndex3) )
      & ( v2570(VarCurr,bitIndex6)
      <=> v2571(VarCurr,bitIndex2) )
      & ( v2570(VarCurr,bitIndex5)
      <=> v2571(VarCurr,bitIndex1) )
      & ( v2570(VarCurr,bitIndex4)
      <=> v2571(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_580,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v2571(VarCurr,B)
      <=> v2572(VarCurr,B) ) ) ).

fof(writeBinaryOperatorShiftedRanges_40,axiom,
    ! [VarCurr] :
      ( v2572(VarCurr,bitIndex0)
    <=> ( v1824(VarCurr,bitIndex32)
        | v2573(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_39,axiom,
    ! [VarCurr] :
      ( v2572(VarCurr,bitIndex1)
    <=> ( v1824(VarCurr,bitIndex33)
        | v2573(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_38,axiom,
    ! [VarCurr] :
      ( v2572(VarCurr,bitIndex2)
    <=> ( v1824(VarCurr,bitIndex34)
        | v2573(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_37,axiom,
    ! [VarCurr] :
      ( v2572(VarCurr,bitIndex3)
    <=> ( v1824(VarCurr,bitIndex35)
        | v2573(VarCurr,bitIndex3) ) ) ).

fof(addAssignment_579,axiom,
    ! [VarCurr] :
      ( v2573(VarCurr,bitIndex0)
    <=> v1824(VarCurr,bitIndex36) ) ).

fof(addAssignment_578,axiom,
    ! [VarCurr] :
      ( ( v2573(VarCurr,bitIndex3)
      <=> $false )
      & ( v2573(VarCurr,bitIndex2)
      <=> $false )
      & ( v2573(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addAssignment_577,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v2569(VarCurr,B)
      <=> v2501(VarCurr,B) ) ) ).

fof(addAssignment_576,axiom,
    ! [VarCurr] :
      ( v2569(VarCurr,bitIndex4)
    <=> v2280(VarCurr) ) ).

fof(addAssignment_575,axiom,
    ! [VarCurr,B] :
      ( range_7_5(B)
     => ( v2569(VarCurr,B)
      <=> v2501(VarCurr,B) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_399,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2531(VarNext)
      <=> ( v2532(VarNext)
          & v2539(VarNext) ) ) ) ).

fof(addAssignment_574,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2539(VarNext)
      <=> v2537(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_398,axiom,
    ! [VarCurr] :
      ( v2537(VarCurr)
    <=> ( v2540(VarCurr)
        & v2547(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_397,axiom,
    ! [VarCurr] :
      ( v2547(VarCurr)
    <=> ( v2548(VarCurr)
        | v2541(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_396,axiom,
    ! [VarCurr] :
      ( v2548(VarCurr)
    <=> ( v2549(VarCurr)
        & v2562(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_395,axiom,
    ! [VarCurr] :
      ( v2562(VarCurr)
    <=> ( v2563(VarCurr)
        | v2545(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_394,axiom,
    ! [VarCurr] :
      ( v2563(VarCurr)
    <=> ( v2552(VarCurr)
        | v2544(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_393,axiom,
    ! [VarCurr] :
      ( v2549(VarCurr)
    <=> ( v2550(VarCurr)
        & v2560(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_392,axiom,
    ! [VarCurr] :
      ( v2560(VarCurr)
    <=> ( v56(VarCurr)
        | v2561(VarCurr) ) ) ).

fof(writeUnaryOperator_176,axiom,
    ! [VarCurr] :
      ( ~ v2561(VarCurr)
    <=> v2545(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_391,axiom,
    ! [VarCurr] :
      ( v2550(VarCurr)
    <=> ( v2551(VarCurr)
        & v2553(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_390,axiom,
    ! [VarCurr] :
      ( v2553(VarCurr)
    <=> ( v2554(VarCurr)
        | v2559(VarCurr) ) ) ).

fof(writeUnaryOperator_175,axiom,
    ! [VarCurr] :
      ( ~ v2559(VarCurr)
    <=> v2544(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_389,axiom,
    ! [VarCurr] :
      ( v2554(VarCurr)
    <=> ( v2555(VarCurr)
        | v2557(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_232,axiom,
    ! [VarCurr] :
      ( v2557(VarCurr)
    <=> ( ( v2558(VarCurr,bitIndex1)
        <=> $true )
        & ( v2558(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_573,axiom,
    ! [VarCurr] :
      ( v2558(VarCurr,bitIndex0)
    <=> v706(VarCurr) ) ).

fof(addAssignment_572,axiom,
    ! [VarCurr] :
      ( v2558(VarCurr,bitIndex1)
    <=> v704(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_231,axiom,
    ! [VarCurr] :
      ( v2555(VarCurr)
    <=> ( ( v2556(VarCurr,bitIndex1)
        <=> $true )
        & ( v2556(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_571,axiom,
    ! [VarCurr] :
      ( v2556(VarCurr,bitIndex0)
    <=> v706(VarCurr) ) ).

fof(addAssignment_570,axiom,
    ! [VarCurr] :
      ( v2556(VarCurr,bitIndex1)
    <=> v704(VarCurr) ) ).

fof(writeUnaryOperator_174,axiom,
    ! [VarCurr] :
      ( ~ v2551(VarCurr)
    <=> v2552(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_230,axiom,
    ! [VarCurr] :
      ( v2552(VarCurr)
    <=> ( ( v58(VarCurr,bitIndex2)
        <=> $false )
        & ( v58(VarCurr,bitIndex1)
        <=> $false )
        & ( v58(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_388,axiom,
    ! [VarCurr] :
      ( v2540(VarCurr)
    <=> ( v2541(VarCurr)
        | v2542(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_387,axiom,
    ! [VarCurr] :
      ( v2542(VarCurr)
    <=> ( v2543(VarCurr)
        & v2546(VarCurr) ) ) ).

fof(writeUnaryOperator_173,axiom,
    ! [VarCurr] :
      ( ~ v2546(VarCurr)
    <=> v2541(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_386,axiom,
    ! [VarCurr] :
      ( v2543(VarCurr)
    <=> ( v2544(VarCurr)
        | v2545(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_229,axiom,
    ! [VarCurr] :
      ( v2545(VarCurr)
    <=> ( ( v58(VarCurr,bitIndex2)
        <=> $false )
        & ( v58(VarCurr,bitIndex1)
        <=> $true )
        & ( v58(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_228,axiom,
    ! [VarCurr] :
      ( v2544(VarCurr)
    <=> ( ( v58(VarCurr,bitIndex2)
        <=> $false )
        & ( v58(VarCurr,bitIndex1)
        <=> $true )
        & ( v58(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeUnaryOperator_172,axiom,
    ! [VarCurr] :
      ( ~ v2541(VarCurr)
    <=> v51(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_385,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2532(VarNext)
      <=> ( v2533(VarNext)
          & v125(VarNext) ) ) ) ).

fof(writeUnaryOperator_171,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2533(VarNext)
      <=> v990(VarNext) ) ) ).

fof(addAssignmentInitValue_109,axiom,
    ~ v700(constB0,bitIndex4) ).

fof(bitBlastConstant_782,axiom,
    ~ bxxx0xxxx(bitIndex4) ).

fof(addAssignment_569,axiom,
    ! [VarNext] :
      ( v2501(VarNext,bitIndex4)
    <=> v2512(VarNext,bitIndex4) ) ).

fof(addCaseBooleanConditionEqualRanges1_26,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2513(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v2512(VarNext,B)
            <=> v2501(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_26,axiom,
    ! [VarNext] :
      ( v2513(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v2512(VarNext,B)
          <=> v2524(VarNext,B) ) ) ) ).

fof(addAssignment_568,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v2524(VarNext,B)
          <=> v2522(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_50,axiom,
    ! [VarCurr] :
      ( ~ v997(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v2522(VarCurr,B)
          <=> v2503(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_51,axiom,
    ! [VarCurr] :
      ( v997(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v2522(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_384,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2513(VarNext)
      <=> ( v2514(VarNext)
          & v2521(VarNext) ) ) ) ).

fof(addAssignment_567,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2521(VarNext)
      <=> v2519(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_383,axiom,
    ! [VarCurr] :
      ( v2519(VarCurr)
    <=> ( v67(VarCurr)
        | v997(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_382,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2514(VarNext)
      <=> ( v2516(VarNext)
          & v125(VarNext) ) ) ) ).

fof(writeUnaryOperator_170,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2516(VarNext)
      <=> v990(VarNext) ) ) ).

fof(addAssignmentInitValue_108,axiom,
    ~ v2501(constB0,bitIndex4) ).

fof(bitBlastConstant_781,axiom,
    ~ bxxx0xxxx(bitIndex4) ).

fof(addAssignment_566,axiom,
    ! [VarCurr] :
      ( v2503(VarCurr,bitIndex4)
    <=> v2504(VarCurr,bitIndex4) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_29,axiom,
    ! [VarCurr] :
      ( ( ~ v2505(VarCurr)
        & ~ v1032(VarCurr) )
     => ! [B] :
          ( range_7_0(B)
         => ( v2504(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_75,axiom,
    ! [VarCurr] :
      ( v1032(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v2504(VarCurr,B)
          <=> v2508(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_75,axiom,
    ! [VarCurr] :
      ( v2505(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v2504(VarCurr,B)
          <=> v847(VarCurr,B) ) ) ) ).

fof(addAssignment_565,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v2508(VarCurr,B)
      <=> v847(VarCurr,B) ) ) ).

fof(addAssignment_564,axiom,
    ! [VarCurr] :
      ( v2508(VarCurr,bitIndex4)
    <=> $true ) ).

fof(addAssignment_563,axiom,
    ! [VarCurr,B] :
      ( range_7_5(B)
     => ( v2508(VarCurr,B)
      <=> v847(VarCurr,B) ) ) ).

fof(range_axiom_14,axiom,
    ! [B] :
      ( range_7_5(B)
    <=> ( $false
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_381,axiom,
    ! [VarCurr] :
      ( v2505(VarCurr)
    <=> ( v2507(VarCurr)
        | v1029(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_380,axiom,
    ! [VarCurr] :
      ( v2507(VarCurr)
    <=> ( v1026(VarCurr)
        | v1027(VarCurr) ) ) ).

fof(addAssignment_562,axiom,
    ! [VarCurr] :
      ( v847(VarCurr,bitIndex4)
    <=> v849(VarCurr,bitIndex4) ) ).

fof(addAssignment_561,axiom,
    ! [VarCurr] :
      ( v849(VarCurr,bitIndex4)
    <=> v851(VarCurr,bitIndex4) ) ).

fof(addAssignment_560,axiom,
    ! [VarCurr] :
      ( v851(VarCurr,bitIndex4)
    <=> v853(VarCurr,bitIndex28) ) ).

fof(addAssignment_559,axiom,
    ! [VarCurr] :
      ( v1824(VarCurr,bitIndex36)
    <=> v1826(VarCurr,bitIndex36) ) ).

fof(addAssignment_558,axiom,
    ! [VarCurr] :
      ( v1826(VarCurr,bitIndex36)
    <=> v1828(VarCurr,bitIndex36) ) ).

fof(addAssignment_557,axiom,
    ! [VarCurr] :
      ( v1828(VarCurr,bitIndex36)
    <=> v1830(VarCurr,bitIndex36) ) ).

fof(addAssignment_556,axiom,
    ! [VarCurr] :
      ( v1830(VarCurr,bitIndex36)
    <=> v1879(VarCurr,bitIndex36) ) ).

fof(addAssignment_555,axiom,
    ! [VarCurr] :
      ( v1824(VarCurr,bitIndex32)
    <=> v1826(VarCurr,bitIndex32) ) ).

fof(addAssignment_554,axiom,
    ! [VarCurr] :
      ( v1826(VarCurr,bitIndex32)
    <=> v1828(VarCurr,bitIndex32) ) ).

fof(addAssignment_553,axiom,
    ! [VarCurr] :
      ( v1828(VarCurr,bitIndex32)
    <=> v1830(VarCurr,bitIndex32) ) ).

fof(addAssignment_552,axiom,
    ! [VarCurr] :
      ( v1830(VarCurr,bitIndex32)
    <=> v1879(VarCurr,bitIndex32) ) ).

fof(memoryReadIntoBuffer_50,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b0000_address_term = A
             => ( range_53_0(B)
               => ( v2333(VarNext,B)
                <=> v1832_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_49,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b0001_address_term = A
             => ( range_53_0(B)
               => ( v2343(VarNext,B)
                <=> v1832_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_48,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b0010_address_term = A
             => ( range_53_0(B)
               => ( v2352(VarNext,B)
                <=> v1832_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_47,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b0011_address_term = A
             => ( range_53_0(B)
               => ( v2361(VarNext,B)
                <=> v1832_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_46,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b0100_address_term = A
             => ( range_53_0(B)
               => ( v2370(VarNext,B)
                <=> v1832_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_45,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b0101_address_term = A
             => ( range_53_0(B)
               => ( v2379(VarNext,B)
                <=> v1832_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_44,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b0110_address_term = A
             => ( range_53_0(B)
               => ( v2389(VarNext,B)
                <=> v1832_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_43,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b0111_address_term = A
             => ( range_53_0(B)
               => ( v2399(VarNext,B)
                <=> v1832_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_42,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b1000_address_term = A
             => ( range_53_0(B)
               => ( v2409(VarNext,B)
                <=> v1832_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_41,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b1001_address_term = A
             => ( range_53_0(B)
               => ( v2419(VarNext,B)
                <=> v1832_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_40,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b1010_address_term = A
             => ( range_53_0(B)
               => ( v2429(VarNext,B)
                <=> v1832_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_39,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b1011_address_term = A
             => ( range_53_0(B)
               => ( v2439(VarNext,B)
                <=> v1832_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_38,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b1100_address_term = A
             => ( range_53_0(B)
               => ( v2449(VarNext,B)
                <=> v1832_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_37,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b1101_address_term = A
             => ( range_53_0(B)
               => ( v2459(VarNext,B)
                <=> v1832_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_36,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b1110_address_term = A
             => ( range_53_0(B)
               => ( v2469(VarNext,B)
                <=> v1832_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_35,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b1111_address_term = A
             => ( range_53_0(B)
               => ( v2479(VarNext,B)
                <=> v1832_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_34,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v1834_range_3_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( address(A)
             => ! [B] :
                  ( A = AssociatedAddressVar
                 => ( range_53_0(B)
                   => ( v1879(VarNext,B)
                    <=> v1832_array(VarNext,A,B) ) ) ) ) ) ) ).

fof(memoryConstantWriteDisabled_1,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( $true
              & v2492(VarNext) )
         => ! [B] :
              ( range_53_0(B)
             => ( v1832_array(VarNext,A,B)
              <=> v1832_17__array(VarNext,A,B) ) ) ) ) ).

fof(memoryConstantWriteEnabledInsideRange_1,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( $true
            & v2492(VarNext) )
         => ! [B] :
              ( range_53_0(B)
             => ( v1832_array(VarNext,A,B)
              <=> b000000000000000000000000000000000000000000000000000000(B) ) ) ) ) ).

fof(bitBlastConstant_780,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex53) ).

fof(bitBlastConstant_779,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex52) ).

fof(bitBlastConstant_778,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex51) ).

fof(bitBlastConstant_777,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex50) ).

fof(bitBlastConstant_776,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex49) ).

fof(bitBlastConstant_775,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex48) ).

fof(bitBlastConstant_774,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex47) ).

fof(bitBlastConstant_773,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex46) ).

fof(bitBlastConstant_772,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex45) ).

fof(bitBlastConstant_771,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex44) ).

fof(bitBlastConstant_770,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex43) ).

fof(bitBlastConstant_769,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex42) ).

fof(bitBlastConstant_768,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex41) ).

fof(bitBlastConstant_767,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex40) ).

fof(bitBlastConstant_766,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex39) ).

fof(bitBlastConstant_765,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex38) ).

fof(bitBlastConstant_764,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex37) ).

fof(bitBlastConstant_763,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex36) ).

fof(bitBlastConstant_762,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex35) ).

fof(bitBlastConstant_761,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex34) ).

fof(bitBlastConstant_760,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex33) ).

fof(bitBlastConstant_759,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex32) ).

fof(bitBlastConstant_758,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex31) ).

fof(bitBlastConstant_757,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex30) ).

fof(bitBlastConstant_756,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex29) ).

fof(bitBlastConstant_755,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex28) ).

fof(bitBlastConstant_754,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex27) ).

fof(bitBlastConstant_753,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex26) ).

fof(bitBlastConstant_752,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex25) ).

fof(bitBlastConstant_751,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex24) ).

fof(bitBlastConstant_750,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex23) ).

fof(bitBlastConstant_749,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex22) ).

fof(bitBlastConstant_748,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex21) ).

fof(bitBlastConstant_747,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex20) ).

fof(bitBlastConstant_746,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex19) ).

fof(bitBlastConstant_745,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex18) ).

fof(bitBlastConstant_744,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex17) ).

fof(bitBlastConstant_743,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex16) ).

fof(bitBlastConstant_742,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex15) ).

fof(bitBlastConstant_741,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex14) ).

fof(bitBlastConstant_740,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex13) ).

fof(bitBlastConstant_739,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex12) ).

fof(bitBlastConstant_738,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex11) ).

fof(bitBlastConstant_737,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex10) ).

fof(bitBlastConstant_736,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex9) ).

fof(bitBlastConstant_735,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex8) ).

fof(bitBlastConstant_734,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex7) ).

fof(bitBlastConstant_733,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex6) ).

fof(bitBlastConstant_732,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex5) ).

fof(bitBlastConstant_731,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex4) ).

fof(bitBlastConstant_730,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex3) ).

fof(bitBlastConstant_729,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex2) ).

fof(bitBlastConstant_728,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex1) ).

fof(bitBlastConstant_727,axiom,
    ~ b000000000000000000000000000000000000000000000000000000(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_379,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2492(VarNext)
      <=> ( v2493(VarNext)
          & v2498(VarNext) ) ) ) ).

fof(addAssignment_551,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2498(VarNext)
      <=> v2330(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_378,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2493(VarNext)
      <=> ( v2495(VarNext)
          & v2283(VarNext) ) ) ) ).

fof(writeUnaryOperator_169,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2495(VarNext)
      <=> v2323(VarNext) ) ) ).

fof(memoryWriteDisabled_52,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v1834_range_3_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ~ ( A = AssociatedAddressVar
                  & v2482(VarNext) )
             => ! [B] :
                  ( range_53_0(B)
                 => ( v1832_17__array(VarNext,A,B)
                  <=> v1832_16__array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_52,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v1834_range_3_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ( A = AssociatedAddressVar
                & v2482(VarNext) )
             => ! [B] :
                  ( range_53_0(B)
                 => ( v1832_17__array(VarNext,A,B)
                  <=> v2288(VarNext,B) ) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_377,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2482(VarNext)
      <=> ( v2483(VarNext)
          & v2489(VarNext) ) ) ) ).

fof(addAssignment_550,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2489(VarNext)
      <=> v2487(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_376,axiom,
    ! [VarCurr] :
      ( v2487(VarCurr)
    <=> ( v2329(VarCurr)
        & v2298(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_375,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2483(VarNext)
      <=> ( v2485(VarNext)
          & v2283(VarNext) ) ) ) ).

fof(writeUnaryOperator_168,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2485(VarNext)
      <=> v2323(VarNext) ) ) ).

fof(memoryWriteDisabled_51,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b1111_address_term = A
              & v2472(VarNext) )
         => ! [B] :
              ( range_53_0(B)
             => ( v1832_16__array(VarNext,A,B)
              <=> v1832_15__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_51,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b1111_address_term = A
            & v2472(VarNext) )
         => ( ( v1832_16__array(VarNext,A,bitIndex53)
            <=> v2479(VarNext,bitIndex863) )
            & ( v1832_16__array(VarNext,A,bitIndex52)
            <=> v2479(VarNext,bitIndex862) )
            & ( v1832_16__array(VarNext,A,bitIndex51)
            <=> v2479(VarNext,bitIndex861) )
            & ( v1832_16__array(VarNext,A,bitIndex50)
            <=> v2479(VarNext,bitIndex860) )
            & ( v1832_16__array(VarNext,A,bitIndex49)
            <=> v2479(VarNext,bitIndex859) )
            & ( v1832_16__array(VarNext,A,bitIndex48)
            <=> v2479(VarNext,bitIndex858) )
            & ( v1832_16__array(VarNext,A,bitIndex47)
            <=> v2479(VarNext,bitIndex857) )
            & ( v1832_16__array(VarNext,A,bitIndex46)
            <=> v2479(VarNext,bitIndex856) )
            & ( v1832_16__array(VarNext,A,bitIndex45)
            <=> v2479(VarNext,bitIndex855) )
            & ( v1832_16__array(VarNext,A,bitIndex44)
            <=> v2479(VarNext,bitIndex854) )
            & ( v1832_16__array(VarNext,A,bitIndex43)
            <=> v2479(VarNext,bitIndex853) )
            & ( v1832_16__array(VarNext,A,bitIndex42)
            <=> v2479(VarNext,bitIndex852) )
            & ( v1832_16__array(VarNext,A,bitIndex41)
            <=> v2479(VarNext,bitIndex851) )
            & ( v1832_16__array(VarNext,A,bitIndex40)
            <=> v2479(VarNext,bitIndex850) )
            & ( v1832_16__array(VarNext,A,bitIndex39)
            <=> v2479(VarNext,bitIndex849) )
            & ( v1832_16__array(VarNext,A,bitIndex38)
            <=> v2479(VarNext,bitIndex848) )
            & ( v1832_16__array(VarNext,A,bitIndex37)
            <=> v2479(VarNext,bitIndex847) )
            & ( v1832_16__array(VarNext,A,bitIndex36)
            <=> v2479(VarNext,bitIndex846) )
            & ( v1832_16__array(VarNext,A,bitIndex35)
            <=> v2479(VarNext,bitIndex845) )
            & ( v1832_16__array(VarNext,A,bitIndex34)
            <=> v2479(VarNext,bitIndex844) )
            & ( v1832_16__array(VarNext,A,bitIndex33)
            <=> v2479(VarNext,bitIndex843) )
            & ( v1832_16__array(VarNext,A,bitIndex32)
            <=> v2479(VarNext,bitIndex842) )
            & ( v1832_16__array(VarNext,A,bitIndex31)
            <=> v2479(VarNext,bitIndex841) )
            & ( v1832_16__array(VarNext,A,bitIndex30)
            <=> v2479(VarNext,bitIndex840) )
            & ( v1832_16__array(VarNext,A,bitIndex29)
            <=> v2479(VarNext,bitIndex839) )
            & ( v1832_16__array(VarNext,A,bitIndex28)
            <=> v2479(VarNext,bitIndex838) )
            & ( v1832_16__array(VarNext,A,bitIndex27)
            <=> v2479(VarNext,bitIndex837) )
            & ( v1832_16__array(VarNext,A,bitIndex26)
            <=> v2479(VarNext,bitIndex836) )
            & ( v1832_16__array(VarNext,A,bitIndex25)
            <=> v2479(VarNext,bitIndex835) )
            & ( v1832_16__array(VarNext,A,bitIndex24)
            <=> v2479(VarNext,bitIndex834) )
            & ( v1832_16__array(VarNext,A,bitIndex23)
            <=> v2479(VarNext,bitIndex833) )
            & ( v1832_16__array(VarNext,A,bitIndex22)
            <=> v2479(VarNext,bitIndex832) )
            & ( v1832_16__array(VarNext,A,bitIndex21)
            <=> v2479(VarNext,bitIndex831) )
            & ( v1832_16__array(VarNext,A,bitIndex20)
            <=> v2479(VarNext,bitIndex830) )
            & ( v1832_16__array(VarNext,A,bitIndex19)
            <=> v2479(VarNext,bitIndex829) )
            & ( v1832_16__array(VarNext,A,bitIndex18)
            <=> v2479(VarNext,bitIndex828) )
            & ( v1832_16__array(VarNext,A,bitIndex17)
            <=> v2479(VarNext,bitIndex827) )
            & ( v1832_16__array(VarNext,A,bitIndex16)
            <=> v2479(VarNext,bitIndex826) )
            & ( v1832_16__array(VarNext,A,bitIndex15)
            <=> v2479(VarNext,bitIndex825) )
            & ( v1832_16__array(VarNext,A,bitIndex14)
            <=> v2479(VarNext,bitIndex824) )
            & ( v1832_16__array(VarNext,A,bitIndex13)
            <=> v2479(VarNext,bitIndex823) )
            & ( v1832_16__array(VarNext,A,bitIndex12)
            <=> v2479(VarNext,bitIndex822) )
            & ( v1832_16__array(VarNext,A,bitIndex11)
            <=> v2479(VarNext,bitIndex821) )
            & ( v1832_16__array(VarNext,A,bitIndex10)
            <=> v2479(VarNext,bitIndex820) )
            & ( v1832_16__array(VarNext,A,bitIndex9)
            <=> v2479(VarNext,bitIndex819) )
            & ( v1832_16__array(VarNext,A,bitIndex8)
            <=> v2479(VarNext,bitIndex818) )
            & ( v1832_16__array(VarNext,A,bitIndex7)
            <=> v2479(VarNext,bitIndex817) )
            & ( v1832_16__array(VarNext,A,bitIndex6)
            <=> v2479(VarNext,bitIndex816) )
            & ( v1832_16__array(VarNext,A,bitIndex5)
            <=> v2479(VarNext,bitIndex815) )
            & ( v1832_16__array(VarNext,A,bitIndex4)
            <=> v2479(VarNext,bitIndex814) )
            & ( v1832_16__array(VarNext,A,bitIndex3)
            <=> v2479(VarNext,bitIndex813) )
            & ( v1832_16__array(VarNext,A,bitIndex2)
            <=> v2479(VarNext,bitIndex812) )
            & ( v1832_16__array(VarNext,A,bitIndex1)
            <=> v2479(VarNext,bitIndex811) )
            & ( v1832_16__array(VarNext,A,bitIndex0)
            <=> v2479(VarNext,bitIndex810) ) ) ) ) ).

fof(bitBlastConstant_726,axiom,
    b1111(bitIndex3) ).

fof(bitBlastConstant_725,axiom,
    b1111(bitIndex2) ).

fof(bitBlastConstant_724,axiom,
    b1111(bitIndex1) ).

fof(bitBlastConstant_723,axiom,
    b1111(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_374,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2472(VarNext)
      <=> ( v2473(VarNext)
          & v2328(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_373,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2473(VarNext)
      <=> ( v2475(VarNext)
          & v2283(VarNext) ) ) ) ).

fof(writeUnaryOperator_167,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2475(VarNext)
      <=> v2323(VarNext) ) ) ).

fof(memoryWriteDisabled_50,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b1110_address_term = A
              & v2462(VarNext) )
         => ! [B] :
              ( range_53_0(B)
             => ( v1832_15__array(VarNext,A,B)
              <=> v1832_14__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_50,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b1110_address_term = A
            & v2462(VarNext) )
         => ( ( v1832_15__array(VarNext,A,bitIndex53)
            <=> v2469(VarNext,bitIndex809) )
            & ( v1832_15__array(VarNext,A,bitIndex52)
            <=> v2469(VarNext,bitIndex808) )
            & ( v1832_15__array(VarNext,A,bitIndex51)
            <=> v2469(VarNext,bitIndex807) )
            & ( v1832_15__array(VarNext,A,bitIndex50)
            <=> v2469(VarNext,bitIndex806) )
            & ( v1832_15__array(VarNext,A,bitIndex49)
            <=> v2469(VarNext,bitIndex805) )
            & ( v1832_15__array(VarNext,A,bitIndex48)
            <=> v2469(VarNext,bitIndex804) )
            & ( v1832_15__array(VarNext,A,bitIndex47)
            <=> v2469(VarNext,bitIndex803) )
            & ( v1832_15__array(VarNext,A,bitIndex46)
            <=> v2469(VarNext,bitIndex802) )
            & ( v1832_15__array(VarNext,A,bitIndex45)
            <=> v2469(VarNext,bitIndex801) )
            & ( v1832_15__array(VarNext,A,bitIndex44)
            <=> v2469(VarNext,bitIndex800) )
            & ( v1832_15__array(VarNext,A,bitIndex43)
            <=> v2469(VarNext,bitIndex799) )
            & ( v1832_15__array(VarNext,A,bitIndex42)
            <=> v2469(VarNext,bitIndex798) )
            & ( v1832_15__array(VarNext,A,bitIndex41)
            <=> v2469(VarNext,bitIndex797) )
            & ( v1832_15__array(VarNext,A,bitIndex40)
            <=> v2469(VarNext,bitIndex796) )
            & ( v1832_15__array(VarNext,A,bitIndex39)
            <=> v2469(VarNext,bitIndex795) )
            & ( v1832_15__array(VarNext,A,bitIndex38)
            <=> v2469(VarNext,bitIndex794) )
            & ( v1832_15__array(VarNext,A,bitIndex37)
            <=> v2469(VarNext,bitIndex793) )
            & ( v1832_15__array(VarNext,A,bitIndex36)
            <=> v2469(VarNext,bitIndex792) )
            & ( v1832_15__array(VarNext,A,bitIndex35)
            <=> v2469(VarNext,bitIndex791) )
            & ( v1832_15__array(VarNext,A,bitIndex34)
            <=> v2469(VarNext,bitIndex790) )
            & ( v1832_15__array(VarNext,A,bitIndex33)
            <=> v2469(VarNext,bitIndex789) )
            & ( v1832_15__array(VarNext,A,bitIndex32)
            <=> v2469(VarNext,bitIndex788) )
            & ( v1832_15__array(VarNext,A,bitIndex31)
            <=> v2469(VarNext,bitIndex787) )
            & ( v1832_15__array(VarNext,A,bitIndex30)
            <=> v2469(VarNext,bitIndex786) )
            & ( v1832_15__array(VarNext,A,bitIndex29)
            <=> v2469(VarNext,bitIndex785) )
            & ( v1832_15__array(VarNext,A,bitIndex28)
            <=> v2469(VarNext,bitIndex784) )
            & ( v1832_15__array(VarNext,A,bitIndex27)
            <=> v2469(VarNext,bitIndex783) )
            & ( v1832_15__array(VarNext,A,bitIndex26)
            <=> v2469(VarNext,bitIndex782) )
            & ( v1832_15__array(VarNext,A,bitIndex25)
            <=> v2469(VarNext,bitIndex781) )
            & ( v1832_15__array(VarNext,A,bitIndex24)
            <=> v2469(VarNext,bitIndex780) )
            & ( v1832_15__array(VarNext,A,bitIndex23)
            <=> v2469(VarNext,bitIndex779) )
            & ( v1832_15__array(VarNext,A,bitIndex22)
            <=> v2469(VarNext,bitIndex778) )
            & ( v1832_15__array(VarNext,A,bitIndex21)
            <=> v2469(VarNext,bitIndex777) )
            & ( v1832_15__array(VarNext,A,bitIndex20)
            <=> v2469(VarNext,bitIndex776) )
            & ( v1832_15__array(VarNext,A,bitIndex19)
            <=> v2469(VarNext,bitIndex775) )
            & ( v1832_15__array(VarNext,A,bitIndex18)
            <=> v2469(VarNext,bitIndex774) )
            & ( v1832_15__array(VarNext,A,bitIndex17)
            <=> v2469(VarNext,bitIndex773) )
            & ( v1832_15__array(VarNext,A,bitIndex16)
            <=> v2469(VarNext,bitIndex772) )
            & ( v1832_15__array(VarNext,A,bitIndex15)
            <=> v2469(VarNext,bitIndex771) )
            & ( v1832_15__array(VarNext,A,bitIndex14)
            <=> v2469(VarNext,bitIndex770) )
            & ( v1832_15__array(VarNext,A,bitIndex13)
            <=> v2469(VarNext,bitIndex769) )
            & ( v1832_15__array(VarNext,A,bitIndex12)
            <=> v2469(VarNext,bitIndex768) )
            & ( v1832_15__array(VarNext,A,bitIndex11)
            <=> v2469(VarNext,bitIndex767) )
            & ( v1832_15__array(VarNext,A,bitIndex10)
            <=> v2469(VarNext,bitIndex766) )
            & ( v1832_15__array(VarNext,A,bitIndex9)
            <=> v2469(VarNext,bitIndex765) )
            & ( v1832_15__array(VarNext,A,bitIndex8)
            <=> v2469(VarNext,bitIndex764) )
            & ( v1832_15__array(VarNext,A,bitIndex7)
            <=> v2469(VarNext,bitIndex763) )
            & ( v1832_15__array(VarNext,A,bitIndex6)
            <=> v2469(VarNext,bitIndex762) )
            & ( v1832_15__array(VarNext,A,bitIndex5)
            <=> v2469(VarNext,bitIndex761) )
            & ( v1832_15__array(VarNext,A,bitIndex4)
            <=> v2469(VarNext,bitIndex760) )
            & ( v1832_15__array(VarNext,A,bitIndex3)
            <=> v2469(VarNext,bitIndex759) )
            & ( v1832_15__array(VarNext,A,bitIndex2)
            <=> v2469(VarNext,bitIndex758) )
            & ( v1832_15__array(VarNext,A,bitIndex1)
            <=> v2469(VarNext,bitIndex757) )
            & ( v1832_15__array(VarNext,A,bitIndex0)
            <=> v2469(VarNext,bitIndex756) ) ) ) ) ).

fof(bitBlastConstant_722,axiom,
    b1110(bitIndex3) ).

fof(bitBlastConstant_721,axiom,
    b1110(bitIndex2) ).

fof(bitBlastConstant_720,axiom,
    b1110(bitIndex1) ).

fof(bitBlastConstant_719,axiom,
    ~ b1110(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_372,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2462(VarNext)
      <=> ( v2463(VarNext)
          & v2328(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_371,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2463(VarNext)
      <=> ( v2465(VarNext)
          & v2283(VarNext) ) ) ) ).

fof(writeUnaryOperator_166,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2465(VarNext)
      <=> v2323(VarNext) ) ) ).

fof(memoryWriteDisabled_49,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b1101_address_term = A
              & v2452(VarNext) )
         => ! [B] :
              ( range_53_0(B)
             => ( v1832_14__array(VarNext,A,B)
              <=> v1832_13__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_49,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b1101_address_term = A
            & v2452(VarNext) )
         => ( ( v1832_14__array(VarNext,A,bitIndex53)
            <=> v2459(VarNext,bitIndex755) )
            & ( v1832_14__array(VarNext,A,bitIndex52)
            <=> v2459(VarNext,bitIndex754) )
            & ( v1832_14__array(VarNext,A,bitIndex51)
            <=> v2459(VarNext,bitIndex753) )
            & ( v1832_14__array(VarNext,A,bitIndex50)
            <=> v2459(VarNext,bitIndex752) )
            & ( v1832_14__array(VarNext,A,bitIndex49)
            <=> v2459(VarNext,bitIndex751) )
            & ( v1832_14__array(VarNext,A,bitIndex48)
            <=> v2459(VarNext,bitIndex750) )
            & ( v1832_14__array(VarNext,A,bitIndex47)
            <=> v2459(VarNext,bitIndex749) )
            & ( v1832_14__array(VarNext,A,bitIndex46)
            <=> v2459(VarNext,bitIndex748) )
            & ( v1832_14__array(VarNext,A,bitIndex45)
            <=> v2459(VarNext,bitIndex747) )
            & ( v1832_14__array(VarNext,A,bitIndex44)
            <=> v2459(VarNext,bitIndex746) )
            & ( v1832_14__array(VarNext,A,bitIndex43)
            <=> v2459(VarNext,bitIndex745) )
            & ( v1832_14__array(VarNext,A,bitIndex42)
            <=> v2459(VarNext,bitIndex744) )
            & ( v1832_14__array(VarNext,A,bitIndex41)
            <=> v2459(VarNext,bitIndex743) )
            & ( v1832_14__array(VarNext,A,bitIndex40)
            <=> v2459(VarNext,bitIndex742) )
            & ( v1832_14__array(VarNext,A,bitIndex39)
            <=> v2459(VarNext,bitIndex741) )
            & ( v1832_14__array(VarNext,A,bitIndex38)
            <=> v2459(VarNext,bitIndex740) )
            & ( v1832_14__array(VarNext,A,bitIndex37)
            <=> v2459(VarNext,bitIndex739) )
            & ( v1832_14__array(VarNext,A,bitIndex36)
            <=> v2459(VarNext,bitIndex738) )
            & ( v1832_14__array(VarNext,A,bitIndex35)
            <=> v2459(VarNext,bitIndex737) )
            & ( v1832_14__array(VarNext,A,bitIndex34)
            <=> v2459(VarNext,bitIndex736) )
            & ( v1832_14__array(VarNext,A,bitIndex33)
            <=> v2459(VarNext,bitIndex735) )
            & ( v1832_14__array(VarNext,A,bitIndex32)
            <=> v2459(VarNext,bitIndex734) )
            & ( v1832_14__array(VarNext,A,bitIndex31)
            <=> v2459(VarNext,bitIndex733) )
            & ( v1832_14__array(VarNext,A,bitIndex30)
            <=> v2459(VarNext,bitIndex732) )
            & ( v1832_14__array(VarNext,A,bitIndex29)
            <=> v2459(VarNext,bitIndex731) )
            & ( v1832_14__array(VarNext,A,bitIndex28)
            <=> v2459(VarNext,bitIndex730) )
            & ( v1832_14__array(VarNext,A,bitIndex27)
            <=> v2459(VarNext,bitIndex729) )
            & ( v1832_14__array(VarNext,A,bitIndex26)
            <=> v2459(VarNext,bitIndex728) )
            & ( v1832_14__array(VarNext,A,bitIndex25)
            <=> v2459(VarNext,bitIndex727) )
            & ( v1832_14__array(VarNext,A,bitIndex24)
            <=> v2459(VarNext,bitIndex726) )
            & ( v1832_14__array(VarNext,A,bitIndex23)
            <=> v2459(VarNext,bitIndex725) )
            & ( v1832_14__array(VarNext,A,bitIndex22)
            <=> v2459(VarNext,bitIndex724) )
            & ( v1832_14__array(VarNext,A,bitIndex21)
            <=> v2459(VarNext,bitIndex723) )
            & ( v1832_14__array(VarNext,A,bitIndex20)
            <=> v2459(VarNext,bitIndex722) )
            & ( v1832_14__array(VarNext,A,bitIndex19)
            <=> v2459(VarNext,bitIndex721) )
            & ( v1832_14__array(VarNext,A,bitIndex18)
            <=> v2459(VarNext,bitIndex720) )
            & ( v1832_14__array(VarNext,A,bitIndex17)
            <=> v2459(VarNext,bitIndex719) )
            & ( v1832_14__array(VarNext,A,bitIndex16)
            <=> v2459(VarNext,bitIndex718) )
            & ( v1832_14__array(VarNext,A,bitIndex15)
            <=> v2459(VarNext,bitIndex717) )
            & ( v1832_14__array(VarNext,A,bitIndex14)
            <=> v2459(VarNext,bitIndex716) )
            & ( v1832_14__array(VarNext,A,bitIndex13)
            <=> v2459(VarNext,bitIndex715) )
            & ( v1832_14__array(VarNext,A,bitIndex12)
            <=> v2459(VarNext,bitIndex714) )
            & ( v1832_14__array(VarNext,A,bitIndex11)
            <=> v2459(VarNext,bitIndex713) )
            & ( v1832_14__array(VarNext,A,bitIndex10)
            <=> v2459(VarNext,bitIndex712) )
            & ( v1832_14__array(VarNext,A,bitIndex9)
            <=> v2459(VarNext,bitIndex711) )
            & ( v1832_14__array(VarNext,A,bitIndex8)
            <=> v2459(VarNext,bitIndex710) )
            & ( v1832_14__array(VarNext,A,bitIndex7)
            <=> v2459(VarNext,bitIndex709) )
            & ( v1832_14__array(VarNext,A,bitIndex6)
            <=> v2459(VarNext,bitIndex708) )
            & ( v1832_14__array(VarNext,A,bitIndex5)
            <=> v2459(VarNext,bitIndex707) )
            & ( v1832_14__array(VarNext,A,bitIndex4)
            <=> v2459(VarNext,bitIndex706) )
            & ( v1832_14__array(VarNext,A,bitIndex3)
            <=> v2459(VarNext,bitIndex705) )
            & ( v1832_14__array(VarNext,A,bitIndex2)
            <=> v2459(VarNext,bitIndex704) )
            & ( v1832_14__array(VarNext,A,bitIndex1)
            <=> v2459(VarNext,bitIndex703) )
            & ( v1832_14__array(VarNext,A,bitIndex0)
            <=> v2459(VarNext,bitIndex702) ) ) ) ) ).

fof(bitBlastConstant_718,axiom,
    b1101(bitIndex3) ).

fof(bitBlastConstant_717,axiom,
    b1101(bitIndex2) ).

fof(bitBlastConstant_716,axiom,
    ~ b1101(bitIndex1) ).

fof(bitBlastConstant_715,axiom,
    b1101(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_370,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2452(VarNext)
      <=> ( v2453(VarNext)
          & v2328(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_369,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2453(VarNext)
      <=> ( v2455(VarNext)
          & v2283(VarNext) ) ) ) ).

fof(writeUnaryOperator_165,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2455(VarNext)
      <=> v2323(VarNext) ) ) ).

fof(memoryWriteDisabled_48,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b1100_address_term = A
              & v2442(VarNext) )
         => ! [B] :
              ( range_53_0(B)
             => ( v1832_13__array(VarNext,A,B)
              <=> v1832_12__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_48,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b1100_address_term = A
            & v2442(VarNext) )
         => ( ( v1832_13__array(VarNext,A,bitIndex53)
            <=> v2449(VarNext,bitIndex701) )
            & ( v1832_13__array(VarNext,A,bitIndex52)
            <=> v2449(VarNext,bitIndex700) )
            & ( v1832_13__array(VarNext,A,bitIndex51)
            <=> v2449(VarNext,bitIndex699) )
            & ( v1832_13__array(VarNext,A,bitIndex50)
            <=> v2449(VarNext,bitIndex698) )
            & ( v1832_13__array(VarNext,A,bitIndex49)
            <=> v2449(VarNext,bitIndex697) )
            & ( v1832_13__array(VarNext,A,bitIndex48)
            <=> v2449(VarNext,bitIndex696) )
            & ( v1832_13__array(VarNext,A,bitIndex47)
            <=> v2449(VarNext,bitIndex695) )
            & ( v1832_13__array(VarNext,A,bitIndex46)
            <=> v2449(VarNext,bitIndex694) )
            & ( v1832_13__array(VarNext,A,bitIndex45)
            <=> v2449(VarNext,bitIndex693) )
            & ( v1832_13__array(VarNext,A,bitIndex44)
            <=> v2449(VarNext,bitIndex692) )
            & ( v1832_13__array(VarNext,A,bitIndex43)
            <=> v2449(VarNext,bitIndex691) )
            & ( v1832_13__array(VarNext,A,bitIndex42)
            <=> v2449(VarNext,bitIndex690) )
            & ( v1832_13__array(VarNext,A,bitIndex41)
            <=> v2449(VarNext,bitIndex689) )
            & ( v1832_13__array(VarNext,A,bitIndex40)
            <=> v2449(VarNext,bitIndex688) )
            & ( v1832_13__array(VarNext,A,bitIndex39)
            <=> v2449(VarNext,bitIndex687) )
            & ( v1832_13__array(VarNext,A,bitIndex38)
            <=> v2449(VarNext,bitIndex686) )
            & ( v1832_13__array(VarNext,A,bitIndex37)
            <=> v2449(VarNext,bitIndex685) )
            & ( v1832_13__array(VarNext,A,bitIndex36)
            <=> v2449(VarNext,bitIndex684) )
            & ( v1832_13__array(VarNext,A,bitIndex35)
            <=> v2449(VarNext,bitIndex683) )
            & ( v1832_13__array(VarNext,A,bitIndex34)
            <=> v2449(VarNext,bitIndex682) )
            & ( v1832_13__array(VarNext,A,bitIndex33)
            <=> v2449(VarNext,bitIndex681) )
            & ( v1832_13__array(VarNext,A,bitIndex32)
            <=> v2449(VarNext,bitIndex680) )
            & ( v1832_13__array(VarNext,A,bitIndex31)
            <=> v2449(VarNext,bitIndex679) )
            & ( v1832_13__array(VarNext,A,bitIndex30)
            <=> v2449(VarNext,bitIndex678) )
            & ( v1832_13__array(VarNext,A,bitIndex29)
            <=> v2449(VarNext,bitIndex677) )
            & ( v1832_13__array(VarNext,A,bitIndex28)
            <=> v2449(VarNext,bitIndex676) )
            & ( v1832_13__array(VarNext,A,bitIndex27)
            <=> v2449(VarNext,bitIndex675) )
            & ( v1832_13__array(VarNext,A,bitIndex26)
            <=> v2449(VarNext,bitIndex674) )
            & ( v1832_13__array(VarNext,A,bitIndex25)
            <=> v2449(VarNext,bitIndex673) )
            & ( v1832_13__array(VarNext,A,bitIndex24)
            <=> v2449(VarNext,bitIndex672) )
            & ( v1832_13__array(VarNext,A,bitIndex23)
            <=> v2449(VarNext,bitIndex671) )
            & ( v1832_13__array(VarNext,A,bitIndex22)
            <=> v2449(VarNext,bitIndex670) )
            & ( v1832_13__array(VarNext,A,bitIndex21)
            <=> v2449(VarNext,bitIndex669) )
            & ( v1832_13__array(VarNext,A,bitIndex20)
            <=> v2449(VarNext,bitIndex668) )
            & ( v1832_13__array(VarNext,A,bitIndex19)
            <=> v2449(VarNext,bitIndex667) )
            & ( v1832_13__array(VarNext,A,bitIndex18)
            <=> v2449(VarNext,bitIndex666) )
            & ( v1832_13__array(VarNext,A,bitIndex17)
            <=> v2449(VarNext,bitIndex665) )
            & ( v1832_13__array(VarNext,A,bitIndex16)
            <=> v2449(VarNext,bitIndex664) )
            & ( v1832_13__array(VarNext,A,bitIndex15)
            <=> v2449(VarNext,bitIndex663) )
            & ( v1832_13__array(VarNext,A,bitIndex14)
            <=> v2449(VarNext,bitIndex662) )
            & ( v1832_13__array(VarNext,A,bitIndex13)
            <=> v2449(VarNext,bitIndex661) )
            & ( v1832_13__array(VarNext,A,bitIndex12)
            <=> v2449(VarNext,bitIndex660) )
            & ( v1832_13__array(VarNext,A,bitIndex11)
            <=> v2449(VarNext,bitIndex659) )
            & ( v1832_13__array(VarNext,A,bitIndex10)
            <=> v2449(VarNext,bitIndex658) )
            & ( v1832_13__array(VarNext,A,bitIndex9)
            <=> v2449(VarNext,bitIndex657) )
            & ( v1832_13__array(VarNext,A,bitIndex8)
            <=> v2449(VarNext,bitIndex656) )
            & ( v1832_13__array(VarNext,A,bitIndex7)
            <=> v2449(VarNext,bitIndex655) )
            & ( v1832_13__array(VarNext,A,bitIndex6)
            <=> v2449(VarNext,bitIndex654) )
            & ( v1832_13__array(VarNext,A,bitIndex5)
            <=> v2449(VarNext,bitIndex653) )
            & ( v1832_13__array(VarNext,A,bitIndex4)
            <=> v2449(VarNext,bitIndex652) )
            & ( v1832_13__array(VarNext,A,bitIndex3)
            <=> v2449(VarNext,bitIndex651) )
            & ( v1832_13__array(VarNext,A,bitIndex2)
            <=> v2449(VarNext,bitIndex650) )
            & ( v1832_13__array(VarNext,A,bitIndex1)
            <=> v2449(VarNext,bitIndex649) )
            & ( v1832_13__array(VarNext,A,bitIndex0)
            <=> v2449(VarNext,bitIndex648) ) ) ) ) ).

fof(bitBlastConstant_714,axiom,
    b1100(bitIndex3) ).

fof(bitBlastConstant_713,axiom,
    b1100(bitIndex2) ).

fof(bitBlastConstant_712,axiom,
    ~ b1100(bitIndex1) ).

fof(bitBlastConstant_711,axiom,
    ~ b1100(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_368,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2442(VarNext)
      <=> ( v2443(VarNext)
          & v2328(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_367,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2443(VarNext)
      <=> ( v2445(VarNext)
          & v2283(VarNext) ) ) ) ).

fof(writeUnaryOperator_164,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2445(VarNext)
      <=> v2323(VarNext) ) ) ).

fof(memoryWriteDisabled_47,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b1011_address_term = A
              & v2432(VarNext) )
         => ! [B] :
              ( range_53_0(B)
             => ( v1832_12__array(VarNext,A,B)
              <=> v1832_11__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_47,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b1011_address_term = A
            & v2432(VarNext) )
         => ( ( v1832_12__array(VarNext,A,bitIndex53)
            <=> v2439(VarNext,bitIndex647) )
            & ( v1832_12__array(VarNext,A,bitIndex52)
            <=> v2439(VarNext,bitIndex646) )
            & ( v1832_12__array(VarNext,A,bitIndex51)
            <=> v2439(VarNext,bitIndex645) )
            & ( v1832_12__array(VarNext,A,bitIndex50)
            <=> v2439(VarNext,bitIndex644) )
            & ( v1832_12__array(VarNext,A,bitIndex49)
            <=> v2439(VarNext,bitIndex643) )
            & ( v1832_12__array(VarNext,A,bitIndex48)
            <=> v2439(VarNext,bitIndex642) )
            & ( v1832_12__array(VarNext,A,bitIndex47)
            <=> v2439(VarNext,bitIndex641) )
            & ( v1832_12__array(VarNext,A,bitIndex46)
            <=> v2439(VarNext,bitIndex640) )
            & ( v1832_12__array(VarNext,A,bitIndex45)
            <=> v2439(VarNext,bitIndex639) )
            & ( v1832_12__array(VarNext,A,bitIndex44)
            <=> v2439(VarNext,bitIndex638) )
            & ( v1832_12__array(VarNext,A,bitIndex43)
            <=> v2439(VarNext,bitIndex637) )
            & ( v1832_12__array(VarNext,A,bitIndex42)
            <=> v2439(VarNext,bitIndex636) )
            & ( v1832_12__array(VarNext,A,bitIndex41)
            <=> v2439(VarNext,bitIndex635) )
            & ( v1832_12__array(VarNext,A,bitIndex40)
            <=> v2439(VarNext,bitIndex634) )
            & ( v1832_12__array(VarNext,A,bitIndex39)
            <=> v2439(VarNext,bitIndex633) )
            & ( v1832_12__array(VarNext,A,bitIndex38)
            <=> v2439(VarNext,bitIndex632) )
            & ( v1832_12__array(VarNext,A,bitIndex37)
            <=> v2439(VarNext,bitIndex631) )
            & ( v1832_12__array(VarNext,A,bitIndex36)
            <=> v2439(VarNext,bitIndex630) )
            & ( v1832_12__array(VarNext,A,bitIndex35)
            <=> v2439(VarNext,bitIndex629) )
            & ( v1832_12__array(VarNext,A,bitIndex34)
            <=> v2439(VarNext,bitIndex628) )
            & ( v1832_12__array(VarNext,A,bitIndex33)
            <=> v2439(VarNext,bitIndex627) )
            & ( v1832_12__array(VarNext,A,bitIndex32)
            <=> v2439(VarNext,bitIndex626) )
            & ( v1832_12__array(VarNext,A,bitIndex31)
            <=> v2439(VarNext,bitIndex625) )
            & ( v1832_12__array(VarNext,A,bitIndex30)
            <=> v2439(VarNext,bitIndex624) )
            & ( v1832_12__array(VarNext,A,bitIndex29)
            <=> v2439(VarNext,bitIndex623) )
            & ( v1832_12__array(VarNext,A,bitIndex28)
            <=> v2439(VarNext,bitIndex622) )
            & ( v1832_12__array(VarNext,A,bitIndex27)
            <=> v2439(VarNext,bitIndex621) )
            & ( v1832_12__array(VarNext,A,bitIndex26)
            <=> v2439(VarNext,bitIndex620) )
            & ( v1832_12__array(VarNext,A,bitIndex25)
            <=> v2439(VarNext,bitIndex619) )
            & ( v1832_12__array(VarNext,A,bitIndex24)
            <=> v2439(VarNext,bitIndex618) )
            & ( v1832_12__array(VarNext,A,bitIndex23)
            <=> v2439(VarNext,bitIndex617) )
            & ( v1832_12__array(VarNext,A,bitIndex22)
            <=> v2439(VarNext,bitIndex616) )
            & ( v1832_12__array(VarNext,A,bitIndex21)
            <=> v2439(VarNext,bitIndex615) )
            & ( v1832_12__array(VarNext,A,bitIndex20)
            <=> v2439(VarNext,bitIndex614) )
            & ( v1832_12__array(VarNext,A,bitIndex19)
            <=> v2439(VarNext,bitIndex613) )
            & ( v1832_12__array(VarNext,A,bitIndex18)
            <=> v2439(VarNext,bitIndex612) )
            & ( v1832_12__array(VarNext,A,bitIndex17)
            <=> v2439(VarNext,bitIndex611) )
            & ( v1832_12__array(VarNext,A,bitIndex16)
            <=> v2439(VarNext,bitIndex610) )
            & ( v1832_12__array(VarNext,A,bitIndex15)
            <=> v2439(VarNext,bitIndex609) )
            & ( v1832_12__array(VarNext,A,bitIndex14)
            <=> v2439(VarNext,bitIndex608) )
            & ( v1832_12__array(VarNext,A,bitIndex13)
            <=> v2439(VarNext,bitIndex607) )
            & ( v1832_12__array(VarNext,A,bitIndex12)
            <=> v2439(VarNext,bitIndex606) )
            & ( v1832_12__array(VarNext,A,bitIndex11)
            <=> v2439(VarNext,bitIndex605) )
            & ( v1832_12__array(VarNext,A,bitIndex10)
            <=> v2439(VarNext,bitIndex604) )
            & ( v1832_12__array(VarNext,A,bitIndex9)
            <=> v2439(VarNext,bitIndex603) )
            & ( v1832_12__array(VarNext,A,bitIndex8)
            <=> v2439(VarNext,bitIndex602) )
            & ( v1832_12__array(VarNext,A,bitIndex7)
            <=> v2439(VarNext,bitIndex601) )
            & ( v1832_12__array(VarNext,A,bitIndex6)
            <=> v2439(VarNext,bitIndex600) )
            & ( v1832_12__array(VarNext,A,bitIndex5)
            <=> v2439(VarNext,bitIndex599) )
            & ( v1832_12__array(VarNext,A,bitIndex4)
            <=> v2439(VarNext,bitIndex598) )
            & ( v1832_12__array(VarNext,A,bitIndex3)
            <=> v2439(VarNext,bitIndex597) )
            & ( v1832_12__array(VarNext,A,bitIndex2)
            <=> v2439(VarNext,bitIndex596) )
            & ( v1832_12__array(VarNext,A,bitIndex1)
            <=> v2439(VarNext,bitIndex595) )
            & ( v1832_12__array(VarNext,A,bitIndex0)
            <=> v2439(VarNext,bitIndex594) ) ) ) ) ).

fof(bitBlastConstant_710,axiom,
    b1011(bitIndex3) ).

fof(bitBlastConstant_709,axiom,
    ~ b1011(bitIndex2) ).

fof(bitBlastConstant_708,axiom,
    b1011(bitIndex1) ).

fof(bitBlastConstant_707,axiom,
    b1011(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_366,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2432(VarNext)
      <=> ( v2433(VarNext)
          & v2328(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_365,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2433(VarNext)
      <=> ( v2435(VarNext)
          & v2283(VarNext) ) ) ) ).

fof(writeUnaryOperator_163,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2435(VarNext)
      <=> v2323(VarNext) ) ) ).

fof(memoryWriteDisabled_46,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b1010_address_term = A
              & v2422(VarNext) )
         => ! [B] :
              ( range_53_0(B)
             => ( v1832_11__array(VarNext,A,B)
              <=> v1832_10__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_46,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b1010_address_term = A
            & v2422(VarNext) )
         => ( ( v1832_11__array(VarNext,A,bitIndex53)
            <=> v2429(VarNext,bitIndex593) )
            & ( v1832_11__array(VarNext,A,bitIndex52)
            <=> v2429(VarNext,bitIndex592) )
            & ( v1832_11__array(VarNext,A,bitIndex51)
            <=> v2429(VarNext,bitIndex591) )
            & ( v1832_11__array(VarNext,A,bitIndex50)
            <=> v2429(VarNext,bitIndex590) )
            & ( v1832_11__array(VarNext,A,bitIndex49)
            <=> v2429(VarNext,bitIndex589) )
            & ( v1832_11__array(VarNext,A,bitIndex48)
            <=> v2429(VarNext,bitIndex588) )
            & ( v1832_11__array(VarNext,A,bitIndex47)
            <=> v2429(VarNext,bitIndex587) )
            & ( v1832_11__array(VarNext,A,bitIndex46)
            <=> v2429(VarNext,bitIndex586) )
            & ( v1832_11__array(VarNext,A,bitIndex45)
            <=> v2429(VarNext,bitIndex585) )
            & ( v1832_11__array(VarNext,A,bitIndex44)
            <=> v2429(VarNext,bitIndex584) )
            & ( v1832_11__array(VarNext,A,bitIndex43)
            <=> v2429(VarNext,bitIndex583) )
            & ( v1832_11__array(VarNext,A,bitIndex42)
            <=> v2429(VarNext,bitIndex582) )
            & ( v1832_11__array(VarNext,A,bitIndex41)
            <=> v2429(VarNext,bitIndex581) )
            & ( v1832_11__array(VarNext,A,bitIndex40)
            <=> v2429(VarNext,bitIndex580) )
            & ( v1832_11__array(VarNext,A,bitIndex39)
            <=> v2429(VarNext,bitIndex579) )
            & ( v1832_11__array(VarNext,A,bitIndex38)
            <=> v2429(VarNext,bitIndex578) )
            & ( v1832_11__array(VarNext,A,bitIndex37)
            <=> v2429(VarNext,bitIndex577) )
            & ( v1832_11__array(VarNext,A,bitIndex36)
            <=> v2429(VarNext,bitIndex576) )
            & ( v1832_11__array(VarNext,A,bitIndex35)
            <=> v2429(VarNext,bitIndex575) )
            & ( v1832_11__array(VarNext,A,bitIndex34)
            <=> v2429(VarNext,bitIndex574) )
            & ( v1832_11__array(VarNext,A,bitIndex33)
            <=> v2429(VarNext,bitIndex573) )
            & ( v1832_11__array(VarNext,A,bitIndex32)
            <=> v2429(VarNext,bitIndex572) )
            & ( v1832_11__array(VarNext,A,bitIndex31)
            <=> v2429(VarNext,bitIndex571) )
            & ( v1832_11__array(VarNext,A,bitIndex30)
            <=> v2429(VarNext,bitIndex570) )
            & ( v1832_11__array(VarNext,A,bitIndex29)
            <=> v2429(VarNext,bitIndex569) )
            & ( v1832_11__array(VarNext,A,bitIndex28)
            <=> v2429(VarNext,bitIndex568) )
            & ( v1832_11__array(VarNext,A,bitIndex27)
            <=> v2429(VarNext,bitIndex567) )
            & ( v1832_11__array(VarNext,A,bitIndex26)
            <=> v2429(VarNext,bitIndex566) )
            & ( v1832_11__array(VarNext,A,bitIndex25)
            <=> v2429(VarNext,bitIndex565) )
            & ( v1832_11__array(VarNext,A,bitIndex24)
            <=> v2429(VarNext,bitIndex564) )
            & ( v1832_11__array(VarNext,A,bitIndex23)
            <=> v2429(VarNext,bitIndex563) )
            & ( v1832_11__array(VarNext,A,bitIndex22)
            <=> v2429(VarNext,bitIndex562) )
            & ( v1832_11__array(VarNext,A,bitIndex21)
            <=> v2429(VarNext,bitIndex561) )
            & ( v1832_11__array(VarNext,A,bitIndex20)
            <=> v2429(VarNext,bitIndex560) )
            & ( v1832_11__array(VarNext,A,bitIndex19)
            <=> v2429(VarNext,bitIndex559) )
            & ( v1832_11__array(VarNext,A,bitIndex18)
            <=> v2429(VarNext,bitIndex558) )
            & ( v1832_11__array(VarNext,A,bitIndex17)
            <=> v2429(VarNext,bitIndex557) )
            & ( v1832_11__array(VarNext,A,bitIndex16)
            <=> v2429(VarNext,bitIndex556) )
            & ( v1832_11__array(VarNext,A,bitIndex15)
            <=> v2429(VarNext,bitIndex555) )
            & ( v1832_11__array(VarNext,A,bitIndex14)
            <=> v2429(VarNext,bitIndex554) )
            & ( v1832_11__array(VarNext,A,bitIndex13)
            <=> v2429(VarNext,bitIndex553) )
            & ( v1832_11__array(VarNext,A,bitIndex12)
            <=> v2429(VarNext,bitIndex552) )
            & ( v1832_11__array(VarNext,A,bitIndex11)
            <=> v2429(VarNext,bitIndex551) )
            & ( v1832_11__array(VarNext,A,bitIndex10)
            <=> v2429(VarNext,bitIndex550) )
            & ( v1832_11__array(VarNext,A,bitIndex9)
            <=> v2429(VarNext,bitIndex549) )
            & ( v1832_11__array(VarNext,A,bitIndex8)
            <=> v2429(VarNext,bitIndex548) )
            & ( v1832_11__array(VarNext,A,bitIndex7)
            <=> v2429(VarNext,bitIndex547) )
            & ( v1832_11__array(VarNext,A,bitIndex6)
            <=> v2429(VarNext,bitIndex546) )
            & ( v1832_11__array(VarNext,A,bitIndex5)
            <=> v2429(VarNext,bitIndex545) )
            & ( v1832_11__array(VarNext,A,bitIndex4)
            <=> v2429(VarNext,bitIndex544) )
            & ( v1832_11__array(VarNext,A,bitIndex3)
            <=> v2429(VarNext,bitIndex543) )
            & ( v1832_11__array(VarNext,A,bitIndex2)
            <=> v2429(VarNext,bitIndex542) )
            & ( v1832_11__array(VarNext,A,bitIndex1)
            <=> v2429(VarNext,bitIndex541) )
            & ( v1832_11__array(VarNext,A,bitIndex0)
            <=> v2429(VarNext,bitIndex540) ) ) ) ) ).

fof(bitBlastConstant_706,axiom,
    b1010(bitIndex3) ).

fof(bitBlastConstant_705,axiom,
    ~ b1010(bitIndex2) ).

fof(bitBlastConstant_704,axiom,
    b1010(bitIndex1) ).

fof(bitBlastConstant_703,axiom,
    ~ b1010(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_364,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2422(VarNext)
      <=> ( v2423(VarNext)
          & v2328(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_363,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2423(VarNext)
      <=> ( v2425(VarNext)
          & v2283(VarNext) ) ) ) ).

fof(writeUnaryOperator_162,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2425(VarNext)
      <=> v2323(VarNext) ) ) ).

fof(memoryWriteDisabled_45,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b1001_address_term = A
              & v2412(VarNext) )
         => ! [B] :
              ( range_53_0(B)
             => ( v1832_10__array(VarNext,A,B)
              <=> v1832_9__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_45,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b1001_address_term = A
            & v2412(VarNext) )
         => ( ( v1832_10__array(VarNext,A,bitIndex53)
            <=> v2419(VarNext,bitIndex539) )
            & ( v1832_10__array(VarNext,A,bitIndex52)
            <=> v2419(VarNext,bitIndex538) )
            & ( v1832_10__array(VarNext,A,bitIndex51)
            <=> v2419(VarNext,bitIndex537) )
            & ( v1832_10__array(VarNext,A,bitIndex50)
            <=> v2419(VarNext,bitIndex536) )
            & ( v1832_10__array(VarNext,A,bitIndex49)
            <=> v2419(VarNext,bitIndex535) )
            & ( v1832_10__array(VarNext,A,bitIndex48)
            <=> v2419(VarNext,bitIndex534) )
            & ( v1832_10__array(VarNext,A,bitIndex47)
            <=> v2419(VarNext,bitIndex533) )
            & ( v1832_10__array(VarNext,A,bitIndex46)
            <=> v2419(VarNext,bitIndex532) )
            & ( v1832_10__array(VarNext,A,bitIndex45)
            <=> v2419(VarNext,bitIndex531) )
            & ( v1832_10__array(VarNext,A,bitIndex44)
            <=> v2419(VarNext,bitIndex530) )
            & ( v1832_10__array(VarNext,A,bitIndex43)
            <=> v2419(VarNext,bitIndex529) )
            & ( v1832_10__array(VarNext,A,bitIndex42)
            <=> v2419(VarNext,bitIndex528) )
            & ( v1832_10__array(VarNext,A,bitIndex41)
            <=> v2419(VarNext,bitIndex527) )
            & ( v1832_10__array(VarNext,A,bitIndex40)
            <=> v2419(VarNext,bitIndex526) )
            & ( v1832_10__array(VarNext,A,bitIndex39)
            <=> v2419(VarNext,bitIndex525) )
            & ( v1832_10__array(VarNext,A,bitIndex38)
            <=> v2419(VarNext,bitIndex524) )
            & ( v1832_10__array(VarNext,A,bitIndex37)
            <=> v2419(VarNext,bitIndex523) )
            & ( v1832_10__array(VarNext,A,bitIndex36)
            <=> v2419(VarNext,bitIndex522) )
            & ( v1832_10__array(VarNext,A,bitIndex35)
            <=> v2419(VarNext,bitIndex521) )
            & ( v1832_10__array(VarNext,A,bitIndex34)
            <=> v2419(VarNext,bitIndex520) )
            & ( v1832_10__array(VarNext,A,bitIndex33)
            <=> v2419(VarNext,bitIndex519) )
            & ( v1832_10__array(VarNext,A,bitIndex32)
            <=> v2419(VarNext,bitIndex518) )
            & ( v1832_10__array(VarNext,A,bitIndex31)
            <=> v2419(VarNext,bitIndex517) )
            & ( v1832_10__array(VarNext,A,bitIndex30)
            <=> v2419(VarNext,bitIndex516) )
            & ( v1832_10__array(VarNext,A,bitIndex29)
            <=> v2419(VarNext,bitIndex515) )
            & ( v1832_10__array(VarNext,A,bitIndex28)
            <=> v2419(VarNext,bitIndex514) )
            & ( v1832_10__array(VarNext,A,bitIndex27)
            <=> v2419(VarNext,bitIndex513) )
            & ( v1832_10__array(VarNext,A,bitIndex26)
            <=> v2419(VarNext,bitIndex512) )
            & ( v1832_10__array(VarNext,A,bitIndex25)
            <=> v2419(VarNext,bitIndex511) )
            & ( v1832_10__array(VarNext,A,bitIndex24)
            <=> v2419(VarNext,bitIndex510) )
            & ( v1832_10__array(VarNext,A,bitIndex23)
            <=> v2419(VarNext,bitIndex509) )
            & ( v1832_10__array(VarNext,A,bitIndex22)
            <=> v2419(VarNext,bitIndex508) )
            & ( v1832_10__array(VarNext,A,bitIndex21)
            <=> v2419(VarNext,bitIndex507) )
            & ( v1832_10__array(VarNext,A,bitIndex20)
            <=> v2419(VarNext,bitIndex506) )
            & ( v1832_10__array(VarNext,A,bitIndex19)
            <=> v2419(VarNext,bitIndex505) )
            & ( v1832_10__array(VarNext,A,bitIndex18)
            <=> v2419(VarNext,bitIndex504) )
            & ( v1832_10__array(VarNext,A,bitIndex17)
            <=> v2419(VarNext,bitIndex503) )
            & ( v1832_10__array(VarNext,A,bitIndex16)
            <=> v2419(VarNext,bitIndex502) )
            & ( v1832_10__array(VarNext,A,bitIndex15)
            <=> v2419(VarNext,bitIndex501) )
            & ( v1832_10__array(VarNext,A,bitIndex14)
            <=> v2419(VarNext,bitIndex500) )
            & ( v1832_10__array(VarNext,A,bitIndex13)
            <=> v2419(VarNext,bitIndex499) )
            & ( v1832_10__array(VarNext,A,bitIndex12)
            <=> v2419(VarNext,bitIndex498) )
            & ( v1832_10__array(VarNext,A,bitIndex11)
            <=> v2419(VarNext,bitIndex497) )
            & ( v1832_10__array(VarNext,A,bitIndex10)
            <=> v2419(VarNext,bitIndex496) )
            & ( v1832_10__array(VarNext,A,bitIndex9)
            <=> v2419(VarNext,bitIndex495) )
            & ( v1832_10__array(VarNext,A,bitIndex8)
            <=> v2419(VarNext,bitIndex494) )
            & ( v1832_10__array(VarNext,A,bitIndex7)
            <=> v2419(VarNext,bitIndex493) )
            & ( v1832_10__array(VarNext,A,bitIndex6)
            <=> v2419(VarNext,bitIndex492) )
            & ( v1832_10__array(VarNext,A,bitIndex5)
            <=> v2419(VarNext,bitIndex491) )
            & ( v1832_10__array(VarNext,A,bitIndex4)
            <=> v2419(VarNext,bitIndex490) )
            & ( v1832_10__array(VarNext,A,bitIndex3)
            <=> v2419(VarNext,bitIndex489) )
            & ( v1832_10__array(VarNext,A,bitIndex2)
            <=> v2419(VarNext,bitIndex488) )
            & ( v1832_10__array(VarNext,A,bitIndex1)
            <=> v2419(VarNext,bitIndex487) )
            & ( v1832_10__array(VarNext,A,bitIndex0)
            <=> v2419(VarNext,bitIndex486) ) ) ) ) ).

fof(bitBlastConstant_702,axiom,
    b1001(bitIndex3) ).

fof(bitBlastConstant_701,axiom,
    ~ b1001(bitIndex2) ).

fof(bitBlastConstant_700,axiom,
    ~ b1001(bitIndex1) ).

fof(bitBlastConstant_699,axiom,
    b1001(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_362,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2412(VarNext)
      <=> ( v2413(VarNext)
          & v2328(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_361,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2413(VarNext)
      <=> ( v2415(VarNext)
          & v2283(VarNext) ) ) ) ).

fof(writeUnaryOperator_161,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2415(VarNext)
      <=> v2323(VarNext) ) ) ).

fof(memoryWriteDisabled_44,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b1000_address_term = A
              & v2402(VarNext) )
         => ! [B] :
              ( range_53_0(B)
             => ( v1832_9__array(VarNext,A,B)
              <=> v1832_8__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_44,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b1000_address_term = A
            & v2402(VarNext) )
         => ( ( v1832_9__array(VarNext,A,bitIndex53)
            <=> v2409(VarNext,bitIndex485) )
            & ( v1832_9__array(VarNext,A,bitIndex52)
            <=> v2409(VarNext,bitIndex484) )
            & ( v1832_9__array(VarNext,A,bitIndex51)
            <=> v2409(VarNext,bitIndex483) )
            & ( v1832_9__array(VarNext,A,bitIndex50)
            <=> v2409(VarNext,bitIndex482) )
            & ( v1832_9__array(VarNext,A,bitIndex49)
            <=> v2409(VarNext,bitIndex481) )
            & ( v1832_9__array(VarNext,A,bitIndex48)
            <=> v2409(VarNext,bitIndex480) )
            & ( v1832_9__array(VarNext,A,bitIndex47)
            <=> v2409(VarNext,bitIndex479) )
            & ( v1832_9__array(VarNext,A,bitIndex46)
            <=> v2409(VarNext,bitIndex478) )
            & ( v1832_9__array(VarNext,A,bitIndex45)
            <=> v2409(VarNext,bitIndex477) )
            & ( v1832_9__array(VarNext,A,bitIndex44)
            <=> v2409(VarNext,bitIndex476) )
            & ( v1832_9__array(VarNext,A,bitIndex43)
            <=> v2409(VarNext,bitIndex475) )
            & ( v1832_9__array(VarNext,A,bitIndex42)
            <=> v2409(VarNext,bitIndex474) )
            & ( v1832_9__array(VarNext,A,bitIndex41)
            <=> v2409(VarNext,bitIndex473) )
            & ( v1832_9__array(VarNext,A,bitIndex40)
            <=> v2409(VarNext,bitIndex472) )
            & ( v1832_9__array(VarNext,A,bitIndex39)
            <=> v2409(VarNext,bitIndex471) )
            & ( v1832_9__array(VarNext,A,bitIndex38)
            <=> v2409(VarNext,bitIndex470) )
            & ( v1832_9__array(VarNext,A,bitIndex37)
            <=> v2409(VarNext,bitIndex469) )
            & ( v1832_9__array(VarNext,A,bitIndex36)
            <=> v2409(VarNext,bitIndex468) )
            & ( v1832_9__array(VarNext,A,bitIndex35)
            <=> v2409(VarNext,bitIndex467) )
            & ( v1832_9__array(VarNext,A,bitIndex34)
            <=> v2409(VarNext,bitIndex466) )
            & ( v1832_9__array(VarNext,A,bitIndex33)
            <=> v2409(VarNext,bitIndex465) )
            & ( v1832_9__array(VarNext,A,bitIndex32)
            <=> v2409(VarNext,bitIndex464) )
            & ( v1832_9__array(VarNext,A,bitIndex31)
            <=> v2409(VarNext,bitIndex463) )
            & ( v1832_9__array(VarNext,A,bitIndex30)
            <=> v2409(VarNext,bitIndex462) )
            & ( v1832_9__array(VarNext,A,bitIndex29)
            <=> v2409(VarNext,bitIndex461) )
            & ( v1832_9__array(VarNext,A,bitIndex28)
            <=> v2409(VarNext,bitIndex460) )
            & ( v1832_9__array(VarNext,A,bitIndex27)
            <=> v2409(VarNext,bitIndex459) )
            & ( v1832_9__array(VarNext,A,bitIndex26)
            <=> v2409(VarNext,bitIndex458) )
            & ( v1832_9__array(VarNext,A,bitIndex25)
            <=> v2409(VarNext,bitIndex457) )
            & ( v1832_9__array(VarNext,A,bitIndex24)
            <=> v2409(VarNext,bitIndex456) )
            & ( v1832_9__array(VarNext,A,bitIndex23)
            <=> v2409(VarNext,bitIndex455) )
            & ( v1832_9__array(VarNext,A,bitIndex22)
            <=> v2409(VarNext,bitIndex454) )
            & ( v1832_9__array(VarNext,A,bitIndex21)
            <=> v2409(VarNext,bitIndex453) )
            & ( v1832_9__array(VarNext,A,bitIndex20)
            <=> v2409(VarNext,bitIndex452) )
            & ( v1832_9__array(VarNext,A,bitIndex19)
            <=> v2409(VarNext,bitIndex451) )
            & ( v1832_9__array(VarNext,A,bitIndex18)
            <=> v2409(VarNext,bitIndex450) )
            & ( v1832_9__array(VarNext,A,bitIndex17)
            <=> v2409(VarNext,bitIndex449) )
            & ( v1832_9__array(VarNext,A,bitIndex16)
            <=> v2409(VarNext,bitIndex448) )
            & ( v1832_9__array(VarNext,A,bitIndex15)
            <=> v2409(VarNext,bitIndex447) )
            & ( v1832_9__array(VarNext,A,bitIndex14)
            <=> v2409(VarNext,bitIndex446) )
            & ( v1832_9__array(VarNext,A,bitIndex13)
            <=> v2409(VarNext,bitIndex445) )
            & ( v1832_9__array(VarNext,A,bitIndex12)
            <=> v2409(VarNext,bitIndex444) )
            & ( v1832_9__array(VarNext,A,bitIndex11)
            <=> v2409(VarNext,bitIndex443) )
            & ( v1832_9__array(VarNext,A,bitIndex10)
            <=> v2409(VarNext,bitIndex442) )
            & ( v1832_9__array(VarNext,A,bitIndex9)
            <=> v2409(VarNext,bitIndex441) )
            & ( v1832_9__array(VarNext,A,bitIndex8)
            <=> v2409(VarNext,bitIndex440) )
            & ( v1832_9__array(VarNext,A,bitIndex7)
            <=> v2409(VarNext,bitIndex439) )
            & ( v1832_9__array(VarNext,A,bitIndex6)
            <=> v2409(VarNext,bitIndex438) )
            & ( v1832_9__array(VarNext,A,bitIndex5)
            <=> v2409(VarNext,bitIndex437) )
            & ( v1832_9__array(VarNext,A,bitIndex4)
            <=> v2409(VarNext,bitIndex436) )
            & ( v1832_9__array(VarNext,A,bitIndex3)
            <=> v2409(VarNext,bitIndex435) )
            & ( v1832_9__array(VarNext,A,bitIndex2)
            <=> v2409(VarNext,bitIndex434) )
            & ( v1832_9__array(VarNext,A,bitIndex1)
            <=> v2409(VarNext,bitIndex433) )
            & ( v1832_9__array(VarNext,A,bitIndex0)
            <=> v2409(VarNext,bitIndex432) ) ) ) ) ).

fof(bitBlastConstant_698,axiom,
    b1000(bitIndex3) ).

fof(bitBlastConstant_697,axiom,
    ~ b1000(bitIndex2) ).

fof(bitBlastConstant_696,axiom,
    ~ b1000(bitIndex1) ).

fof(bitBlastConstant_695,axiom,
    ~ b1000(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_360,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2402(VarNext)
      <=> ( v2403(VarNext)
          & v2328(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_359,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2403(VarNext)
      <=> ( v2405(VarNext)
          & v2283(VarNext) ) ) ) ).

fof(writeUnaryOperator_160,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2405(VarNext)
      <=> v2323(VarNext) ) ) ).

fof(memoryWriteDisabled_43,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b0111_address_term = A
              & v2392(VarNext) )
         => ! [B] :
              ( range_53_0(B)
             => ( v1832_8__array(VarNext,A,B)
              <=> v1832_7__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_43,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b0111_address_term = A
            & v2392(VarNext) )
         => ( ( v1832_8__array(VarNext,A,bitIndex53)
            <=> v2399(VarNext,bitIndex431) )
            & ( v1832_8__array(VarNext,A,bitIndex52)
            <=> v2399(VarNext,bitIndex430) )
            & ( v1832_8__array(VarNext,A,bitIndex51)
            <=> v2399(VarNext,bitIndex429) )
            & ( v1832_8__array(VarNext,A,bitIndex50)
            <=> v2399(VarNext,bitIndex428) )
            & ( v1832_8__array(VarNext,A,bitIndex49)
            <=> v2399(VarNext,bitIndex427) )
            & ( v1832_8__array(VarNext,A,bitIndex48)
            <=> v2399(VarNext,bitIndex426) )
            & ( v1832_8__array(VarNext,A,bitIndex47)
            <=> v2399(VarNext,bitIndex425) )
            & ( v1832_8__array(VarNext,A,bitIndex46)
            <=> v2399(VarNext,bitIndex424) )
            & ( v1832_8__array(VarNext,A,bitIndex45)
            <=> v2399(VarNext,bitIndex423) )
            & ( v1832_8__array(VarNext,A,bitIndex44)
            <=> v2399(VarNext,bitIndex422) )
            & ( v1832_8__array(VarNext,A,bitIndex43)
            <=> v2399(VarNext,bitIndex421) )
            & ( v1832_8__array(VarNext,A,bitIndex42)
            <=> v2399(VarNext,bitIndex420) )
            & ( v1832_8__array(VarNext,A,bitIndex41)
            <=> v2399(VarNext,bitIndex419) )
            & ( v1832_8__array(VarNext,A,bitIndex40)
            <=> v2399(VarNext,bitIndex418) )
            & ( v1832_8__array(VarNext,A,bitIndex39)
            <=> v2399(VarNext,bitIndex417) )
            & ( v1832_8__array(VarNext,A,bitIndex38)
            <=> v2399(VarNext,bitIndex416) )
            & ( v1832_8__array(VarNext,A,bitIndex37)
            <=> v2399(VarNext,bitIndex415) )
            & ( v1832_8__array(VarNext,A,bitIndex36)
            <=> v2399(VarNext,bitIndex414) )
            & ( v1832_8__array(VarNext,A,bitIndex35)
            <=> v2399(VarNext,bitIndex413) )
            & ( v1832_8__array(VarNext,A,bitIndex34)
            <=> v2399(VarNext,bitIndex412) )
            & ( v1832_8__array(VarNext,A,bitIndex33)
            <=> v2399(VarNext,bitIndex411) )
            & ( v1832_8__array(VarNext,A,bitIndex32)
            <=> v2399(VarNext,bitIndex410) )
            & ( v1832_8__array(VarNext,A,bitIndex31)
            <=> v2399(VarNext,bitIndex409) )
            & ( v1832_8__array(VarNext,A,bitIndex30)
            <=> v2399(VarNext,bitIndex408) )
            & ( v1832_8__array(VarNext,A,bitIndex29)
            <=> v2399(VarNext,bitIndex407) )
            & ( v1832_8__array(VarNext,A,bitIndex28)
            <=> v2399(VarNext,bitIndex406) )
            & ( v1832_8__array(VarNext,A,bitIndex27)
            <=> v2399(VarNext,bitIndex405) )
            & ( v1832_8__array(VarNext,A,bitIndex26)
            <=> v2399(VarNext,bitIndex404) )
            & ( v1832_8__array(VarNext,A,bitIndex25)
            <=> v2399(VarNext,bitIndex403) )
            & ( v1832_8__array(VarNext,A,bitIndex24)
            <=> v2399(VarNext,bitIndex402) )
            & ( v1832_8__array(VarNext,A,bitIndex23)
            <=> v2399(VarNext,bitIndex401) )
            & ( v1832_8__array(VarNext,A,bitIndex22)
            <=> v2399(VarNext,bitIndex400) )
            & ( v1832_8__array(VarNext,A,bitIndex21)
            <=> v2399(VarNext,bitIndex399) )
            & ( v1832_8__array(VarNext,A,bitIndex20)
            <=> v2399(VarNext,bitIndex398) )
            & ( v1832_8__array(VarNext,A,bitIndex19)
            <=> v2399(VarNext,bitIndex397) )
            & ( v1832_8__array(VarNext,A,bitIndex18)
            <=> v2399(VarNext,bitIndex396) )
            & ( v1832_8__array(VarNext,A,bitIndex17)
            <=> v2399(VarNext,bitIndex395) )
            & ( v1832_8__array(VarNext,A,bitIndex16)
            <=> v2399(VarNext,bitIndex394) )
            & ( v1832_8__array(VarNext,A,bitIndex15)
            <=> v2399(VarNext,bitIndex393) )
            & ( v1832_8__array(VarNext,A,bitIndex14)
            <=> v2399(VarNext,bitIndex392) )
            & ( v1832_8__array(VarNext,A,bitIndex13)
            <=> v2399(VarNext,bitIndex391) )
            & ( v1832_8__array(VarNext,A,bitIndex12)
            <=> v2399(VarNext,bitIndex390) )
            & ( v1832_8__array(VarNext,A,bitIndex11)
            <=> v2399(VarNext,bitIndex389) )
            & ( v1832_8__array(VarNext,A,bitIndex10)
            <=> v2399(VarNext,bitIndex388) )
            & ( v1832_8__array(VarNext,A,bitIndex9)
            <=> v2399(VarNext,bitIndex387) )
            & ( v1832_8__array(VarNext,A,bitIndex8)
            <=> v2399(VarNext,bitIndex386) )
            & ( v1832_8__array(VarNext,A,bitIndex7)
            <=> v2399(VarNext,bitIndex385) )
            & ( v1832_8__array(VarNext,A,bitIndex6)
            <=> v2399(VarNext,bitIndex384) )
            & ( v1832_8__array(VarNext,A,bitIndex5)
            <=> v2399(VarNext,bitIndex383) )
            & ( v1832_8__array(VarNext,A,bitIndex4)
            <=> v2399(VarNext,bitIndex382) )
            & ( v1832_8__array(VarNext,A,bitIndex3)
            <=> v2399(VarNext,bitIndex381) )
            & ( v1832_8__array(VarNext,A,bitIndex2)
            <=> v2399(VarNext,bitIndex380) )
            & ( v1832_8__array(VarNext,A,bitIndex1)
            <=> v2399(VarNext,bitIndex379) )
            & ( v1832_8__array(VarNext,A,bitIndex0)
            <=> v2399(VarNext,bitIndex378) ) ) ) ) ).

fof(bitBlastConstant_694,axiom,
    ~ b0111(bitIndex3) ).

fof(bitBlastConstant_693,axiom,
    b0111(bitIndex2) ).

fof(bitBlastConstant_692,axiom,
    b0111(bitIndex1) ).

fof(bitBlastConstant_691,axiom,
    b0111(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_358,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2392(VarNext)
      <=> ( v2393(VarNext)
          & v2328(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_357,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2393(VarNext)
      <=> ( v2395(VarNext)
          & v2283(VarNext) ) ) ) ).

fof(writeUnaryOperator_159,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2395(VarNext)
      <=> v2323(VarNext) ) ) ).

fof(memoryWriteDisabled_42,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b0110_address_term = A
              & v2382(VarNext) )
         => ! [B] :
              ( range_53_0(B)
             => ( v1832_7__array(VarNext,A,B)
              <=> v1832_6__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_42,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b0110_address_term = A
            & v2382(VarNext) )
         => ( ( v1832_7__array(VarNext,A,bitIndex53)
            <=> v2389(VarNext,bitIndex377) )
            & ( v1832_7__array(VarNext,A,bitIndex52)
            <=> v2389(VarNext,bitIndex376) )
            & ( v1832_7__array(VarNext,A,bitIndex51)
            <=> v2389(VarNext,bitIndex375) )
            & ( v1832_7__array(VarNext,A,bitIndex50)
            <=> v2389(VarNext,bitIndex374) )
            & ( v1832_7__array(VarNext,A,bitIndex49)
            <=> v2389(VarNext,bitIndex373) )
            & ( v1832_7__array(VarNext,A,bitIndex48)
            <=> v2389(VarNext,bitIndex372) )
            & ( v1832_7__array(VarNext,A,bitIndex47)
            <=> v2389(VarNext,bitIndex371) )
            & ( v1832_7__array(VarNext,A,bitIndex46)
            <=> v2389(VarNext,bitIndex370) )
            & ( v1832_7__array(VarNext,A,bitIndex45)
            <=> v2389(VarNext,bitIndex369) )
            & ( v1832_7__array(VarNext,A,bitIndex44)
            <=> v2389(VarNext,bitIndex368) )
            & ( v1832_7__array(VarNext,A,bitIndex43)
            <=> v2389(VarNext,bitIndex367) )
            & ( v1832_7__array(VarNext,A,bitIndex42)
            <=> v2389(VarNext,bitIndex366) )
            & ( v1832_7__array(VarNext,A,bitIndex41)
            <=> v2389(VarNext,bitIndex365) )
            & ( v1832_7__array(VarNext,A,bitIndex40)
            <=> v2389(VarNext,bitIndex364) )
            & ( v1832_7__array(VarNext,A,bitIndex39)
            <=> v2389(VarNext,bitIndex363) )
            & ( v1832_7__array(VarNext,A,bitIndex38)
            <=> v2389(VarNext,bitIndex362) )
            & ( v1832_7__array(VarNext,A,bitIndex37)
            <=> v2389(VarNext,bitIndex361) )
            & ( v1832_7__array(VarNext,A,bitIndex36)
            <=> v2389(VarNext,bitIndex360) )
            & ( v1832_7__array(VarNext,A,bitIndex35)
            <=> v2389(VarNext,bitIndex359) )
            & ( v1832_7__array(VarNext,A,bitIndex34)
            <=> v2389(VarNext,bitIndex358) )
            & ( v1832_7__array(VarNext,A,bitIndex33)
            <=> v2389(VarNext,bitIndex357) )
            & ( v1832_7__array(VarNext,A,bitIndex32)
            <=> v2389(VarNext,bitIndex356) )
            & ( v1832_7__array(VarNext,A,bitIndex31)
            <=> v2389(VarNext,bitIndex355) )
            & ( v1832_7__array(VarNext,A,bitIndex30)
            <=> v2389(VarNext,bitIndex354) )
            & ( v1832_7__array(VarNext,A,bitIndex29)
            <=> v2389(VarNext,bitIndex353) )
            & ( v1832_7__array(VarNext,A,bitIndex28)
            <=> v2389(VarNext,bitIndex352) )
            & ( v1832_7__array(VarNext,A,bitIndex27)
            <=> v2389(VarNext,bitIndex351) )
            & ( v1832_7__array(VarNext,A,bitIndex26)
            <=> v2389(VarNext,bitIndex350) )
            & ( v1832_7__array(VarNext,A,bitIndex25)
            <=> v2389(VarNext,bitIndex349) )
            & ( v1832_7__array(VarNext,A,bitIndex24)
            <=> v2389(VarNext,bitIndex348) )
            & ( v1832_7__array(VarNext,A,bitIndex23)
            <=> v2389(VarNext,bitIndex347) )
            & ( v1832_7__array(VarNext,A,bitIndex22)
            <=> v2389(VarNext,bitIndex346) )
            & ( v1832_7__array(VarNext,A,bitIndex21)
            <=> v2389(VarNext,bitIndex345) )
            & ( v1832_7__array(VarNext,A,bitIndex20)
            <=> v2389(VarNext,bitIndex344) )
            & ( v1832_7__array(VarNext,A,bitIndex19)
            <=> v2389(VarNext,bitIndex343) )
            & ( v1832_7__array(VarNext,A,bitIndex18)
            <=> v2389(VarNext,bitIndex342) )
            & ( v1832_7__array(VarNext,A,bitIndex17)
            <=> v2389(VarNext,bitIndex341) )
            & ( v1832_7__array(VarNext,A,bitIndex16)
            <=> v2389(VarNext,bitIndex340) )
            & ( v1832_7__array(VarNext,A,bitIndex15)
            <=> v2389(VarNext,bitIndex339) )
            & ( v1832_7__array(VarNext,A,bitIndex14)
            <=> v2389(VarNext,bitIndex338) )
            & ( v1832_7__array(VarNext,A,bitIndex13)
            <=> v2389(VarNext,bitIndex337) )
            & ( v1832_7__array(VarNext,A,bitIndex12)
            <=> v2389(VarNext,bitIndex336) )
            & ( v1832_7__array(VarNext,A,bitIndex11)
            <=> v2389(VarNext,bitIndex335) )
            & ( v1832_7__array(VarNext,A,bitIndex10)
            <=> v2389(VarNext,bitIndex334) )
            & ( v1832_7__array(VarNext,A,bitIndex9)
            <=> v2389(VarNext,bitIndex333) )
            & ( v1832_7__array(VarNext,A,bitIndex8)
            <=> v2389(VarNext,bitIndex332) )
            & ( v1832_7__array(VarNext,A,bitIndex7)
            <=> v2389(VarNext,bitIndex331) )
            & ( v1832_7__array(VarNext,A,bitIndex6)
            <=> v2389(VarNext,bitIndex330) )
            & ( v1832_7__array(VarNext,A,bitIndex5)
            <=> v2389(VarNext,bitIndex329) )
            & ( v1832_7__array(VarNext,A,bitIndex4)
            <=> v2389(VarNext,bitIndex328) )
            & ( v1832_7__array(VarNext,A,bitIndex3)
            <=> v2389(VarNext,bitIndex327) )
            & ( v1832_7__array(VarNext,A,bitIndex2)
            <=> v2389(VarNext,bitIndex326) )
            & ( v1832_7__array(VarNext,A,bitIndex1)
            <=> v2389(VarNext,bitIndex325) )
            & ( v1832_7__array(VarNext,A,bitIndex0)
            <=> v2389(VarNext,bitIndex324) ) ) ) ) ).

fof(bitBlastConstant_690,axiom,
    ~ b0110(bitIndex3) ).

fof(bitBlastConstant_689,axiom,
    b0110(bitIndex2) ).

fof(bitBlastConstant_688,axiom,
    b0110(bitIndex1) ).

fof(bitBlastConstant_687,axiom,
    ~ b0110(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_356,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2382(VarNext)
      <=> ( v2383(VarNext)
          & v2328(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_355,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2383(VarNext)
      <=> ( v2385(VarNext)
          & v2283(VarNext) ) ) ) ).

fof(writeUnaryOperator_158,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2385(VarNext)
      <=> v2323(VarNext) ) ) ).

fof(memoryWriteDisabled_41,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b0101_address_term = A
              & v2373(VarNext) )
         => ! [B] :
              ( range_53_0(B)
             => ( v1832_6__array(VarNext,A,B)
              <=> v1832_5__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_41,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b0101_address_term = A
            & v2373(VarNext) )
         => ( ( v1832_6__array(VarNext,A,bitIndex53)
            <=> v2379(VarNext,bitIndex323) )
            & ( v1832_6__array(VarNext,A,bitIndex52)
            <=> v2379(VarNext,bitIndex322) )
            & ( v1832_6__array(VarNext,A,bitIndex51)
            <=> v2379(VarNext,bitIndex321) )
            & ( v1832_6__array(VarNext,A,bitIndex50)
            <=> v2379(VarNext,bitIndex320) )
            & ( v1832_6__array(VarNext,A,bitIndex49)
            <=> v2379(VarNext,bitIndex319) )
            & ( v1832_6__array(VarNext,A,bitIndex48)
            <=> v2379(VarNext,bitIndex318) )
            & ( v1832_6__array(VarNext,A,bitIndex47)
            <=> v2379(VarNext,bitIndex317) )
            & ( v1832_6__array(VarNext,A,bitIndex46)
            <=> v2379(VarNext,bitIndex316) )
            & ( v1832_6__array(VarNext,A,bitIndex45)
            <=> v2379(VarNext,bitIndex315) )
            & ( v1832_6__array(VarNext,A,bitIndex44)
            <=> v2379(VarNext,bitIndex314) )
            & ( v1832_6__array(VarNext,A,bitIndex43)
            <=> v2379(VarNext,bitIndex313) )
            & ( v1832_6__array(VarNext,A,bitIndex42)
            <=> v2379(VarNext,bitIndex312) )
            & ( v1832_6__array(VarNext,A,bitIndex41)
            <=> v2379(VarNext,bitIndex311) )
            & ( v1832_6__array(VarNext,A,bitIndex40)
            <=> v2379(VarNext,bitIndex310) )
            & ( v1832_6__array(VarNext,A,bitIndex39)
            <=> v2379(VarNext,bitIndex309) )
            & ( v1832_6__array(VarNext,A,bitIndex38)
            <=> v2379(VarNext,bitIndex308) )
            & ( v1832_6__array(VarNext,A,bitIndex37)
            <=> v2379(VarNext,bitIndex307) )
            & ( v1832_6__array(VarNext,A,bitIndex36)
            <=> v2379(VarNext,bitIndex306) )
            & ( v1832_6__array(VarNext,A,bitIndex35)
            <=> v2379(VarNext,bitIndex305) )
            & ( v1832_6__array(VarNext,A,bitIndex34)
            <=> v2379(VarNext,bitIndex304) )
            & ( v1832_6__array(VarNext,A,bitIndex33)
            <=> v2379(VarNext,bitIndex303) )
            & ( v1832_6__array(VarNext,A,bitIndex32)
            <=> v2379(VarNext,bitIndex302) )
            & ( v1832_6__array(VarNext,A,bitIndex31)
            <=> v2379(VarNext,bitIndex301) )
            & ( v1832_6__array(VarNext,A,bitIndex30)
            <=> v2379(VarNext,bitIndex300) )
            & ( v1832_6__array(VarNext,A,bitIndex29)
            <=> v2379(VarNext,bitIndex299) )
            & ( v1832_6__array(VarNext,A,bitIndex28)
            <=> v2379(VarNext,bitIndex298) )
            & ( v1832_6__array(VarNext,A,bitIndex27)
            <=> v2379(VarNext,bitIndex297) )
            & ( v1832_6__array(VarNext,A,bitIndex26)
            <=> v2379(VarNext,bitIndex296) )
            & ( v1832_6__array(VarNext,A,bitIndex25)
            <=> v2379(VarNext,bitIndex295) )
            & ( v1832_6__array(VarNext,A,bitIndex24)
            <=> v2379(VarNext,bitIndex294) )
            & ( v1832_6__array(VarNext,A,bitIndex23)
            <=> v2379(VarNext,bitIndex293) )
            & ( v1832_6__array(VarNext,A,bitIndex22)
            <=> v2379(VarNext,bitIndex292) )
            & ( v1832_6__array(VarNext,A,bitIndex21)
            <=> v2379(VarNext,bitIndex291) )
            & ( v1832_6__array(VarNext,A,bitIndex20)
            <=> v2379(VarNext,bitIndex290) )
            & ( v1832_6__array(VarNext,A,bitIndex19)
            <=> v2379(VarNext,bitIndex289) )
            & ( v1832_6__array(VarNext,A,bitIndex18)
            <=> v2379(VarNext,bitIndex288) )
            & ( v1832_6__array(VarNext,A,bitIndex17)
            <=> v2379(VarNext,bitIndex287) )
            & ( v1832_6__array(VarNext,A,bitIndex16)
            <=> v2379(VarNext,bitIndex286) )
            & ( v1832_6__array(VarNext,A,bitIndex15)
            <=> v2379(VarNext,bitIndex285) )
            & ( v1832_6__array(VarNext,A,bitIndex14)
            <=> v2379(VarNext,bitIndex284) )
            & ( v1832_6__array(VarNext,A,bitIndex13)
            <=> v2379(VarNext,bitIndex283) )
            & ( v1832_6__array(VarNext,A,bitIndex12)
            <=> v2379(VarNext,bitIndex282) )
            & ( v1832_6__array(VarNext,A,bitIndex11)
            <=> v2379(VarNext,bitIndex281) )
            & ( v1832_6__array(VarNext,A,bitIndex10)
            <=> v2379(VarNext,bitIndex280) )
            & ( v1832_6__array(VarNext,A,bitIndex9)
            <=> v2379(VarNext,bitIndex279) )
            & ( v1832_6__array(VarNext,A,bitIndex8)
            <=> v2379(VarNext,bitIndex278) )
            & ( v1832_6__array(VarNext,A,bitIndex7)
            <=> v2379(VarNext,bitIndex277) )
            & ( v1832_6__array(VarNext,A,bitIndex6)
            <=> v2379(VarNext,bitIndex276) )
            & ( v1832_6__array(VarNext,A,bitIndex5)
            <=> v2379(VarNext,bitIndex275) )
            & ( v1832_6__array(VarNext,A,bitIndex4)
            <=> v2379(VarNext,bitIndex274) )
            & ( v1832_6__array(VarNext,A,bitIndex3)
            <=> v2379(VarNext,bitIndex273) )
            & ( v1832_6__array(VarNext,A,bitIndex2)
            <=> v2379(VarNext,bitIndex272) )
            & ( v1832_6__array(VarNext,A,bitIndex1)
            <=> v2379(VarNext,bitIndex271) )
            & ( v1832_6__array(VarNext,A,bitIndex0)
            <=> v2379(VarNext,bitIndex270) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_354,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2373(VarNext)
      <=> ( v2374(VarNext)
          & v2328(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_353,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2374(VarNext)
      <=> ( v2376(VarNext)
          & v2283(VarNext) ) ) ) ).

fof(writeUnaryOperator_157,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2376(VarNext)
      <=> v2323(VarNext) ) ) ).

fof(memoryWriteDisabled_40,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b0100_address_term = A
              & v2364(VarNext) )
         => ! [B] :
              ( range_53_0(B)
             => ( v1832_5__array(VarNext,A,B)
              <=> v1832_4__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_40,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b0100_address_term = A
            & v2364(VarNext) )
         => ( ( v1832_5__array(VarNext,A,bitIndex53)
            <=> v2370(VarNext,bitIndex269) )
            & ( v1832_5__array(VarNext,A,bitIndex52)
            <=> v2370(VarNext,bitIndex268) )
            & ( v1832_5__array(VarNext,A,bitIndex51)
            <=> v2370(VarNext,bitIndex267) )
            & ( v1832_5__array(VarNext,A,bitIndex50)
            <=> v2370(VarNext,bitIndex266) )
            & ( v1832_5__array(VarNext,A,bitIndex49)
            <=> v2370(VarNext,bitIndex265) )
            & ( v1832_5__array(VarNext,A,bitIndex48)
            <=> v2370(VarNext,bitIndex264) )
            & ( v1832_5__array(VarNext,A,bitIndex47)
            <=> v2370(VarNext,bitIndex263) )
            & ( v1832_5__array(VarNext,A,bitIndex46)
            <=> v2370(VarNext,bitIndex262) )
            & ( v1832_5__array(VarNext,A,bitIndex45)
            <=> v2370(VarNext,bitIndex261) )
            & ( v1832_5__array(VarNext,A,bitIndex44)
            <=> v2370(VarNext,bitIndex260) )
            & ( v1832_5__array(VarNext,A,bitIndex43)
            <=> v2370(VarNext,bitIndex259) )
            & ( v1832_5__array(VarNext,A,bitIndex42)
            <=> v2370(VarNext,bitIndex258) )
            & ( v1832_5__array(VarNext,A,bitIndex41)
            <=> v2370(VarNext,bitIndex257) )
            & ( v1832_5__array(VarNext,A,bitIndex40)
            <=> v2370(VarNext,bitIndex256) )
            & ( v1832_5__array(VarNext,A,bitIndex39)
            <=> v2370(VarNext,bitIndex255) )
            & ( v1832_5__array(VarNext,A,bitIndex38)
            <=> v2370(VarNext,bitIndex254) )
            & ( v1832_5__array(VarNext,A,bitIndex37)
            <=> v2370(VarNext,bitIndex253) )
            & ( v1832_5__array(VarNext,A,bitIndex36)
            <=> v2370(VarNext,bitIndex252) )
            & ( v1832_5__array(VarNext,A,bitIndex35)
            <=> v2370(VarNext,bitIndex251) )
            & ( v1832_5__array(VarNext,A,bitIndex34)
            <=> v2370(VarNext,bitIndex250) )
            & ( v1832_5__array(VarNext,A,bitIndex33)
            <=> v2370(VarNext,bitIndex249) )
            & ( v1832_5__array(VarNext,A,bitIndex32)
            <=> v2370(VarNext,bitIndex248) )
            & ( v1832_5__array(VarNext,A,bitIndex31)
            <=> v2370(VarNext,bitIndex247) )
            & ( v1832_5__array(VarNext,A,bitIndex30)
            <=> v2370(VarNext,bitIndex246) )
            & ( v1832_5__array(VarNext,A,bitIndex29)
            <=> v2370(VarNext,bitIndex245) )
            & ( v1832_5__array(VarNext,A,bitIndex28)
            <=> v2370(VarNext,bitIndex244) )
            & ( v1832_5__array(VarNext,A,bitIndex27)
            <=> v2370(VarNext,bitIndex243) )
            & ( v1832_5__array(VarNext,A,bitIndex26)
            <=> v2370(VarNext,bitIndex242) )
            & ( v1832_5__array(VarNext,A,bitIndex25)
            <=> v2370(VarNext,bitIndex241) )
            & ( v1832_5__array(VarNext,A,bitIndex24)
            <=> v2370(VarNext,bitIndex240) )
            & ( v1832_5__array(VarNext,A,bitIndex23)
            <=> v2370(VarNext,bitIndex239) )
            & ( v1832_5__array(VarNext,A,bitIndex22)
            <=> v2370(VarNext,bitIndex238) )
            & ( v1832_5__array(VarNext,A,bitIndex21)
            <=> v2370(VarNext,bitIndex237) )
            & ( v1832_5__array(VarNext,A,bitIndex20)
            <=> v2370(VarNext,bitIndex236) )
            & ( v1832_5__array(VarNext,A,bitIndex19)
            <=> v2370(VarNext,bitIndex235) )
            & ( v1832_5__array(VarNext,A,bitIndex18)
            <=> v2370(VarNext,bitIndex234) )
            & ( v1832_5__array(VarNext,A,bitIndex17)
            <=> v2370(VarNext,bitIndex233) )
            & ( v1832_5__array(VarNext,A,bitIndex16)
            <=> v2370(VarNext,bitIndex232) )
            & ( v1832_5__array(VarNext,A,bitIndex15)
            <=> v2370(VarNext,bitIndex231) )
            & ( v1832_5__array(VarNext,A,bitIndex14)
            <=> v2370(VarNext,bitIndex230) )
            & ( v1832_5__array(VarNext,A,bitIndex13)
            <=> v2370(VarNext,bitIndex229) )
            & ( v1832_5__array(VarNext,A,bitIndex12)
            <=> v2370(VarNext,bitIndex228) )
            & ( v1832_5__array(VarNext,A,bitIndex11)
            <=> v2370(VarNext,bitIndex227) )
            & ( v1832_5__array(VarNext,A,bitIndex10)
            <=> v2370(VarNext,bitIndex226) )
            & ( v1832_5__array(VarNext,A,bitIndex9)
            <=> v2370(VarNext,bitIndex225) )
            & ( v1832_5__array(VarNext,A,bitIndex8)
            <=> v2370(VarNext,bitIndex224) )
            & ( v1832_5__array(VarNext,A,bitIndex7)
            <=> v2370(VarNext,bitIndex223) )
            & ( v1832_5__array(VarNext,A,bitIndex6)
            <=> v2370(VarNext,bitIndex222) )
            & ( v1832_5__array(VarNext,A,bitIndex5)
            <=> v2370(VarNext,bitIndex221) )
            & ( v1832_5__array(VarNext,A,bitIndex4)
            <=> v2370(VarNext,bitIndex220) )
            & ( v1832_5__array(VarNext,A,bitIndex3)
            <=> v2370(VarNext,bitIndex219) )
            & ( v1832_5__array(VarNext,A,bitIndex2)
            <=> v2370(VarNext,bitIndex218) )
            & ( v1832_5__array(VarNext,A,bitIndex1)
            <=> v2370(VarNext,bitIndex217) )
            & ( v1832_5__array(VarNext,A,bitIndex0)
            <=> v2370(VarNext,bitIndex216) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_352,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2364(VarNext)
      <=> ( v2365(VarNext)
          & v2328(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_351,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2365(VarNext)
      <=> ( v2367(VarNext)
          & v2283(VarNext) ) ) ) ).

fof(writeUnaryOperator_156,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2367(VarNext)
      <=> v2323(VarNext) ) ) ).

fof(memoryWriteDisabled_39,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b0011_address_term = A
              & v2355(VarNext) )
         => ! [B] :
              ( range_53_0(B)
             => ( v1832_4__array(VarNext,A,B)
              <=> v1832_3__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_39,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b0011_address_term = A
            & v2355(VarNext) )
         => ( ( v1832_4__array(VarNext,A,bitIndex53)
            <=> v2361(VarNext,bitIndex215) )
            & ( v1832_4__array(VarNext,A,bitIndex52)
            <=> v2361(VarNext,bitIndex214) )
            & ( v1832_4__array(VarNext,A,bitIndex51)
            <=> v2361(VarNext,bitIndex213) )
            & ( v1832_4__array(VarNext,A,bitIndex50)
            <=> v2361(VarNext,bitIndex212) )
            & ( v1832_4__array(VarNext,A,bitIndex49)
            <=> v2361(VarNext,bitIndex211) )
            & ( v1832_4__array(VarNext,A,bitIndex48)
            <=> v2361(VarNext,bitIndex210) )
            & ( v1832_4__array(VarNext,A,bitIndex47)
            <=> v2361(VarNext,bitIndex209) )
            & ( v1832_4__array(VarNext,A,bitIndex46)
            <=> v2361(VarNext,bitIndex208) )
            & ( v1832_4__array(VarNext,A,bitIndex45)
            <=> v2361(VarNext,bitIndex207) )
            & ( v1832_4__array(VarNext,A,bitIndex44)
            <=> v2361(VarNext,bitIndex206) )
            & ( v1832_4__array(VarNext,A,bitIndex43)
            <=> v2361(VarNext,bitIndex205) )
            & ( v1832_4__array(VarNext,A,bitIndex42)
            <=> v2361(VarNext,bitIndex204) )
            & ( v1832_4__array(VarNext,A,bitIndex41)
            <=> v2361(VarNext,bitIndex203) )
            & ( v1832_4__array(VarNext,A,bitIndex40)
            <=> v2361(VarNext,bitIndex202) )
            & ( v1832_4__array(VarNext,A,bitIndex39)
            <=> v2361(VarNext,bitIndex201) )
            & ( v1832_4__array(VarNext,A,bitIndex38)
            <=> v2361(VarNext,bitIndex200) )
            & ( v1832_4__array(VarNext,A,bitIndex37)
            <=> v2361(VarNext,bitIndex199) )
            & ( v1832_4__array(VarNext,A,bitIndex36)
            <=> v2361(VarNext,bitIndex198) )
            & ( v1832_4__array(VarNext,A,bitIndex35)
            <=> v2361(VarNext,bitIndex197) )
            & ( v1832_4__array(VarNext,A,bitIndex34)
            <=> v2361(VarNext,bitIndex196) )
            & ( v1832_4__array(VarNext,A,bitIndex33)
            <=> v2361(VarNext,bitIndex195) )
            & ( v1832_4__array(VarNext,A,bitIndex32)
            <=> v2361(VarNext,bitIndex194) )
            & ( v1832_4__array(VarNext,A,bitIndex31)
            <=> v2361(VarNext,bitIndex193) )
            & ( v1832_4__array(VarNext,A,bitIndex30)
            <=> v2361(VarNext,bitIndex192) )
            & ( v1832_4__array(VarNext,A,bitIndex29)
            <=> v2361(VarNext,bitIndex191) )
            & ( v1832_4__array(VarNext,A,bitIndex28)
            <=> v2361(VarNext,bitIndex190) )
            & ( v1832_4__array(VarNext,A,bitIndex27)
            <=> v2361(VarNext,bitIndex189) )
            & ( v1832_4__array(VarNext,A,bitIndex26)
            <=> v2361(VarNext,bitIndex188) )
            & ( v1832_4__array(VarNext,A,bitIndex25)
            <=> v2361(VarNext,bitIndex187) )
            & ( v1832_4__array(VarNext,A,bitIndex24)
            <=> v2361(VarNext,bitIndex186) )
            & ( v1832_4__array(VarNext,A,bitIndex23)
            <=> v2361(VarNext,bitIndex185) )
            & ( v1832_4__array(VarNext,A,bitIndex22)
            <=> v2361(VarNext,bitIndex184) )
            & ( v1832_4__array(VarNext,A,bitIndex21)
            <=> v2361(VarNext,bitIndex183) )
            & ( v1832_4__array(VarNext,A,bitIndex20)
            <=> v2361(VarNext,bitIndex182) )
            & ( v1832_4__array(VarNext,A,bitIndex19)
            <=> v2361(VarNext,bitIndex181) )
            & ( v1832_4__array(VarNext,A,bitIndex18)
            <=> v2361(VarNext,bitIndex180) )
            & ( v1832_4__array(VarNext,A,bitIndex17)
            <=> v2361(VarNext,bitIndex179) )
            & ( v1832_4__array(VarNext,A,bitIndex16)
            <=> v2361(VarNext,bitIndex178) )
            & ( v1832_4__array(VarNext,A,bitIndex15)
            <=> v2361(VarNext,bitIndex177) )
            & ( v1832_4__array(VarNext,A,bitIndex14)
            <=> v2361(VarNext,bitIndex176) )
            & ( v1832_4__array(VarNext,A,bitIndex13)
            <=> v2361(VarNext,bitIndex175) )
            & ( v1832_4__array(VarNext,A,bitIndex12)
            <=> v2361(VarNext,bitIndex174) )
            & ( v1832_4__array(VarNext,A,bitIndex11)
            <=> v2361(VarNext,bitIndex173) )
            & ( v1832_4__array(VarNext,A,bitIndex10)
            <=> v2361(VarNext,bitIndex172) )
            & ( v1832_4__array(VarNext,A,bitIndex9)
            <=> v2361(VarNext,bitIndex171) )
            & ( v1832_4__array(VarNext,A,bitIndex8)
            <=> v2361(VarNext,bitIndex170) )
            & ( v1832_4__array(VarNext,A,bitIndex7)
            <=> v2361(VarNext,bitIndex169) )
            & ( v1832_4__array(VarNext,A,bitIndex6)
            <=> v2361(VarNext,bitIndex168) )
            & ( v1832_4__array(VarNext,A,bitIndex5)
            <=> v2361(VarNext,bitIndex167) )
            & ( v1832_4__array(VarNext,A,bitIndex4)
            <=> v2361(VarNext,bitIndex166) )
            & ( v1832_4__array(VarNext,A,bitIndex3)
            <=> v2361(VarNext,bitIndex165) )
            & ( v1832_4__array(VarNext,A,bitIndex2)
            <=> v2361(VarNext,bitIndex164) )
            & ( v1832_4__array(VarNext,A,bitIndex1)
            <=> v2361(VarNext,bitIndex163) )
            & ( v1832_4__array(VarNext,A,bitIndex0)
            <=> v2361(VarNext,bitIndex162) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_350,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2355(VarNext)
      <=> ( v2356(VarNext)
          & v2328(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_349,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2356(VarNext)
      <=> ( v2358(VarNext)
          & v2283(VarNext) ) ) ) ).

fof(writeUnaryOperator_155,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2358(VarNext)
      <=> v2323(VarNext) ) ) ).

fof(memoryWriteDisabled_38,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b0010_address_term = A
              & v2346(VarNext) )
         => ! [B] :
              ( range_53_0(B)
             => ( v1832_3__array(VarNext,A,B)
              <=> v1832_2__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_38,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b0010_address_term = A
            & v2346(VarNext) )
         => ( ( v1832_3__array(VarNext,A,bitIndex53)
            <=> v2352(VarNext,bitIndex161) )
            & ( v1832_3__array(VarNext,A,bitIndex52)
            <=> v2352(VarNext,bitIndex160) )
            & ( v1832_3__array(VarNext,A,bitIndex51)
            <=> v2352(VarNext,bitIndex159) )
            & ( v1832_3__array(VarNext,A,bitIndex50)
            <=> v2352(VarNext,bitIndex158) )
            & ( v1832_3__array(VarNext,A,bitIndex49)
            <=> v2352(VarNext,bitIndex157) )
            & ( v1832_3__array(VarNext,A,bitIndex48)
            <=> v2352(VarNext,bitIndex156) )
            & ( v1832_3__array(VarNext,A,bitIndex47)
            <=> v2352(VarNext,bitIndex155) )
            & ( v1832_3__array(VarNext,A,bitIndex46)
            <=> v2352(VarNext,bitIndex154) )
            & ( v1832_3__array(VarNext,A,bitIndex45)
            <=> v2352(VarNext,bitIndex153) )
            & ( v1832_3__array(VarNext,A,bitIndex44)
            <=> v2352(VarNext,bitIndex152) )
            & ( v1832_3__array(VarNext,A,bitIndex43)
            <=> v2352(VarNext,bitIndex151) )
            & ( v1832_3__array(VarNext,A,bitIndex42)
            <=> v2352(VarNext,bitIndex150) )
            & ( v1832_3__array(VarNext,A,bitIndex41)
            <=> v2352(VarNext,bitIndex149) )
            & ( v1832_3__array(VarNext,A,bitIndex40)
            <=> v2352(VarNext,bitIndex148) )
            & ( v1832_3__array(VarNext,A,bitIndex39)
            <=> v2352(VarNext,bitIndex147) )
            & ( v1832_3__array(VarNext,A,bitIndex38)
            <=> v2352(VarNext,bitIndex146) )
            & ( v1832_3__array(VarNext,A,bitIndex37)
            <=> v2352(VarNext,bitIndex145) )
            & ( v1832_3__array(VarNext,A,bitIndex36)
            <=> v2352(VarNext,bitIndex144) )
            & ( v1832_3__array(VarNext,A,bitIndex35)
            <=> v2352(VarNext,bitIndex143) )
            & ( v1832_3__array(VarNext,A,bitIndex34)
            <=> v2352(VarNext,bitIndex142) )
            & ( v1832_3__array(VarNext,A,bitIndex33)
            <=> v2352(VarNext,bitIndex141) )
            & ( v1832_3__array(VarNext,A,bitIndex32)
            <=> v2352(VarNext,bitIndex140) )
            & ( v1832_3__array(VarNext,A,bitIndex31)
            <=> v2352(VarNext,bitIndex139) )
            & ( v1832_3__array(VarNext,A,bitIndex30)
            <=> v2352(VarNext,bitIndex138) )
            & ( v1832_3__array(VarNext,A,bitIndex29)
            <=> v2352(VarNext,bitIndex137) )
            & ( v1832_3__array(VarNext,A,bitIndex28)
            <=> v2352(VarNext,bitIndex136) )
            & ( v1832_3__array(VarNext,A,bitIndex27)
            <=> v2352(VarNext,bitIndex135) )
            & ( v1832_3__array(VarNext,A,bitIndex26)
            <=> v2352(VarNext,bitIndex134) )
            & ( v1832_3__array(VarNext,A,bitIndex25)
            <=> v2352(VarNext,bitIndex133) )
            & ( v1832_3__array(VarNext,A,bitIndex24)
            <=> v2352(VarNext,bitIndex132) )
            & ( v1832_3__array(VarNext,A,bitIndex23)
            <=> v2352(VarNext,bitIndex131) )
            & ( v1832_3__array(VarNext,A,bitIndex22)
            <=> v2352(VarNext,bitIndex130) )
            & ( v1832_3__array(VarNext,A,bitIndex21)
            <=> v2352(VarNext,bitIndex129) )
            & ( v1832_3__array(VarNext,A,bitIndex20)
            <=> v2352(VarNext,bitIndex128) )
            & ( v1832_3__array(VarNext,A,bitIndex19)
            <=> v2352(VarNext,bitIndex127) )
            & ( v1832_3__array(VarNext,A,bitIndex18)
            <=> v2352(VarNext,bitIndex126) )
            & ( v1832_3__array(VarNext,A,bitIndex17)
            <=> v2352(VarNext,bitIndex125) )
            & ( v1832_3__array(VarNext,A,bitIndex16)
            <=> v2352(VarNext,bitIndex124) )
            & ( v1832_3__array(VarNext,A,bitIndex15)
            <=> v2352(VarNext,bitIndex123) )
            & ( v1832_3__array(VarNext,A,bitIndex14)
            <=> v2352(VarNext,bitIndex122) )
            & ( v1832_3__array(VarNext,A,bitIndex13)
            <=> v2352(VarNext,bitIndex121) )
            & ( v1832_3__array(VarNext,A,bitIndex12)
            <=> v2352(VarNext,bitIndex120) )
            & ( v1832_3__array(VarNext,A,bitIndex11)
            <=> v2352(VarNext,bitIndex119) )
            & ( v1832_3__array(VarNext,A,bitIndex10)
            <=> v2352(VarNext,bitIndex118) )
            & ( v1832_3__array(VarNext,A,bitIndex9)
            <=> v2352(VarNext,bitIndex117) )
            & ( v1832_3__array(VarNext,A,bitIndex8)
            <=> v2352(VarNext,bitIndex116) )
            & ( v1832_3__array(VarNext,A,bitIndex7)
            <=> v2352(VarNext,bitIndex115) )
            & ( v1832_3__array(VarNext,A,bitIndex6)
            <=> v2352(VarNext,bitIndex114) )
            & ( v1832_3__array(VarNext,A,bitIndex5)
            <=> v2352(VarNext,bitIndex113) )
            & ( v1832_3__array(VarNext,A,bitIndex4)
            <=> v2352(VarNext,bitIndex112) )
            & ( v1832_3__array(VarNext,A,bitIndex3)
            <=> v2352(VarNext,bitIndex111) )
            & ( v1832_3__array(VarNext,A,bitIndex2)
            <=> v2352(VarNext,bitIndex110) )
            & ( v1832_3__array(VarNext,A,bitIndex1)
            <=> v2352(VarNext,bitIndex109) )
            & ( v1832_3__array(VarNext,A,bitIndex0)
            <=> v2352(VarNext,bitIndex108) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_348,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2346(VarNext)
      <=> ( v2347(VarNext)
          & v2328(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_347,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2347(VarNext)
      <=> ( v2349(VarNext)
          & v2283(VarNext) ) ) ) ).

fof(writeUnaryOperator_154,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2349(VarNext)
      <=> v2323(VarNext) ) ) ).

fof(memoryWriteDisabled_37,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b0001_address_term = A
              & v2336(VarNext) )
         => ! [B] :
              ( range_53_0(B)
             => ( v1832_2__array(VarNext,A,B)
              <=> v1832_1__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_37,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b0001_address_term = A
            & v2336(VarNext) )
         => ( ( v1832_2__array(VarNext,A,bitIndex53)
            <=> v2343(VarNext,bitIndex107) )
            & ( v1832_2__array(VarNext,A,bitIndex52)
            <=> v2343(VarNext,bitIndex106) )
            & ( v1832_2__array(VarNext,A,bitIndex51)
            <=> v2343(VarNext,bitIndex105) )
            & ( v1832_2__array(VarNext,A,bitIndex50)
            <=> v2343(VarNext,bitIndex104) )
            & ( v1832_2__array(VarNext,A,bitIndex49)
            <=> v2343(VarNext,bitIndex103) )
            & ( v1832_2__array(VarNext,A,bitIndex48)
            <=> v2343(VarNext,bitIndex102) )
            & ( v1832_2__array(VarNext,A,bitIndex47)
            <=> v2343(VarNext,bitIndex101) )
            & ( v1832_2__array(VarNext,A,bitIndex46)
            <=> v2343(VarNext,bitIndex100) )
            & ( v1832_2__array(VarNext,A,bitIndex45)
            <=> v2343(VarNext,bitIndex99) )
            & ( v1832_2__array(VarNext,A,bitIndex44)
            <=> v2343(VarNext,bitIndex98) )
            & ( v1832_2__array(VarNext,A,bitIndex43)
            <=> v2343(VarNext,bitIndex97) )
            & ( v1832_2__array(VarNext,A,bitIndex42)
            <=> v2343(VarNext,bitIndex96) )
            & ( v1832_2__array(VarNext,A,bitIndex41)
            <=> v2343(VarNext,bitIndex95) )
            & ( v1832_2__array(VarNext,A,bitIndex40)
            <=> v2343(VarNext,bitIndex94) )
            & ( v1832_2__array(VarNext,A,bitIndex39)
            <=> v2343(VarNext,bitIndex93) )
            & ( v1832_2__array(VarNext,A,bitIndex38)
            <=> v2343(VarNext,bitIndex92) )
            & ( v1832_2__array(VarNext,A,bitIndex37)
            <=> v2343(VarNext,bitIndex91) )
            & ( v1832_2__array(VarNext,A,bitIndex36)
            <=> v2343(VarNext,bitIndex90) )
            & ( v1832_2__array(VarNext,A,bitIndex35)
            <=> v2343(VarNext,bitIndex89) )
            & ( v1832_2__array(VarNext,A,bitIndex34)
            <=> v2343(VarNext,bitIndex88) )
            & ( v1832_2__array(VarNext,A,bitIndex33)
            <=> v2343(VarNext,bitIndex87) )
            & ( v1832_2__array(VarNext,A,bitIndex32)
            <=> v2343(VarNext,bitIndex86) )
            & ( v1832_2__array(VarNext,A,bitIndex31)
            <=> v2343(VarNext,bitIndex85) )
            & ( v1832_2__array(VarNext,A,bitIndex30)
            <=> v2343(VarNext,bitIndex84) )
            & ( v1832_2__array(VarNext,A,bitIndex29)
            <=> v2343(VarNext,bitIndex83) )
            & ( v1832_2__array(VarNext,A,bitIndex28)
            <=> v2343(VarNext,bitIndex82) )
            & ( v1832_2__array(VarNext,A,bitIndex27)
            <=> v2343(VarNext,bitIndex81) )
            & ( v1832_2__array(VarNext,A,bitIndex26)
            <=> v2343(VarNext,bitIndex80) )
            & ( v1832_2__array(VarNext,A,bitIndex25)
            <=> v2343(VarNext,bitIndex79) )
            & ( v1832_2__array(VarNext,A,bitIndex24)
            <=> v2343(VarNext,bitIndex78) )
            & ( v1832_2__array(VarNext,A,bitIndex23)
            <=> v2343(VarNext,bitIndex77) )
            & ( v1832_2__array(VarNext,A,bitIndex22)
            <=> v2343(VarNext,bitIndex76) )
            & ( v1832_2__array(VarNext,A,bitIndex21)
            <=> v2343(VarNext,bitIndex75) )
            & ( v1832_2__array(VarNext,A,bitIndex20)
            <=> v2343(VarNext,bitIndex74) )
            & ( v1832_2__array(VarNext,A,bitIndex19)
            <=> v2343(VarNext,bitIndex73) )
            & ( v1832_2__array(VarNext,A,bitIndex18)
            <=> v2343(VarNext,bitIndex72) )
            & ( v1832_2__array(VarNext,A,bitIndex17)
            <=> v2343(VarNext,bitIndex71) )
            & ( v1832_2__array(VarNext,A,bitIndex16)
            <=> v2343(VarNext,bitIndex70) )
            & ( v1832_2__array(VarNext,A,bitIndex15)
            <=> v2343(VarNext,bitIndex69) )
            & ( v1832_2__array(VarNext,A,bitIndex14)
            <=> v2343(VarNext,bitIndex68) )
            & ( v1832_2__array(VarNext,A,bitIndex13)
            <=> v2343(VarNext,bitIndex67) )
            & ( v1832_2__array(VarNext,A,bitIndex12)
            <=> v2343(VarNext,bitIndex66) )
            & ( v1832_2__array(VarNext,A,bitIndex11)
            <=> v2343(VarNext,bitIndex65) )
            & ( v1832_2__array(VarNext,A,bitIndex10)
            <=> v2343(VarNext,bitIndex64) )
            & ( v1832_2__array(VarNext,A,bitIndex9)
            <=> v2343(VarNext,bitIndex63) )
            & ( v1832_2__array(VarNext,A,bitIndex8)
            <=> v2343(VarNext,bitIndex62) )
            & ( v1832_2__array(VarNext,A,bitIndex7)
            <=> v2343(VarNext,bitIndex61) )
            & ( v1832_2__array(VarNext,A,bitIndex6)
            <=> v2343(VarNext,bitIndex60) )
            & ( v1832_2__array(VarNext,A,bitIndex5)
            <=> v2343(VarNext,bitIndex59) )
            & ( v1832_2__array(VarNext,A,bitIndex4)
            <=> v2343(VarNext,bitIndex58) )
            & ( v1832_2__array(VarNext,A,bitIndex3)
            <=> v2343(VarNext,bitIndex57) )
            & ( v1832_2__array(VarNext,A,bitIndex2)
            <=> v2343(VarNext,bitIndex56) )
            & ( v1832_2__array(VarNext,A,bitIndex1)
            <=> v2343(VarNext,bitIndex55) )
            & ( v1832_2__array(VarNext,A,bitIndex0)
            <=> v2343(VarNext,bitIndex54) ) ) ) ) ).

fof(bitBlastConstant_686,axiom,
    ~ b0001(bitIndex3) ).

fof(bitBlastConstant_685,axiom,
    ~ b0001(bitIndex2) ).

fof(bitBlastConstant_684,axiom,
    ~ b0001(bitIndex1) ).

fof(bitBlastConstant_683,axiom,
    b0001(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_346,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2336(VarNext)
      <=> ( v2337(VarNext)
          & v2328(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_345,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2337(VarNext)
      <=> ( v2339(VarNext)
          & v2283(VarNext) ) ) ) ).

fof(writeUnaryOperator_153,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2339(VarNext)
      <=> v2323(VarNext) ) ) ).

fof(memoryWriteDisabled_36,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b0000_address_term = A
              & v2319(VarNext) )
         => ! [B] :
              ( range_53_0(B)
             => ( v1832_1__array(VarNext,A,B)
              <=> v1832_array(VarCurr,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_36,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b0000_address_term = A
            & v2319(VarNext) )
         => ! [B] :
              ( range_53_0(B)
             => ( v1832_1__array(VarNext,A,B)
              <=> v2333(VarNext,B) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_344,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2319(VarNext)
      <=> ( v2320(VarNext)
          & v2328(VarNext) ) ) ) ).

fof(addAssignment_549,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2328(VarNext)
      <=> v2326(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_343,axiom,
    ! [VarCurr] :
      ( v2326(VarCurr)
    <=> ( v2329(VarCurr)
        & v2331(VarCurr) ) ) ).

fof(writeUnaryOperator_152,axiom,
    ! [VarCurr] :
      ( ~ v2331(VarCurr)
    <=> v2298(VarCurr) ) ).

fof(writeUnaryOperator_151,axiom,
    ! [VarCurr] :
      ( ~ v2329(VarCurr)
    <=> v2330(VarCurr) ) ).

fof(writeUnaryOperator_150,axiom,
    ! [VarCurr] :
      ( ~ v2330(VarCurr)
    <=> v2286(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_342,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2320(VarNext)
      <=> ( v2321(VarNext)
          & v2283(VarNext) ) ) ) ).

fof(writeUnaryOperator_149,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2321(VarNext)
      <=> v2323(VarNext) ) ) ).

fof(addAssignment_548,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2323(VarNext)
      <=> v2283(VarCurr) ) ) ).

fof(initSateConstraint_1247,axiom,
    ~ v1832_array(constB0,b1111_address_term,bitIndex0) ).

fof(initSateConstraint_1246,axiom,
    ~ v1832_array(constB0,b1111_address_term,bitIndex1) ).

fof(initSateConstraint_1245,axiom,
    ~ v1832_array(constB0,b1111_address_term,bitIndex2) ).

fof(initSateConstraint_1244,axiom,
    ~ v1832_array(constB0,b1111_address_term,bitIndex3) ).

fof(initSateConstraint_1243,axiom,
    ~ v1832_array(constB0,b1111_address_term,bitIndex4) ).

fof(initSateConstraint_1242,axiom,
    ~ v1832_array(constB0,b1111_address_term,bitIndex32) ).

fof(initSateConstraint_1241,axiom,
    ~ v1832_array(constB0,b1111_address_term,bitIndex36) ).

fof(initSateConstraint_1240,axiom,
    ~ v1832_array(constB0,b1111_address_term,bitIndex47) ).

fof(initSateConstraint_1239,axiom,
    ~ v1832_array(constB0,b1111_address_term,bitIndex48) ).

fof(initSateConstraint_1238,axiom,
    ~ v1832_array(constB0,b1111_address_term,bitIndex49) ).

fof(initSateConstraint_1237,axiom,
    ~ v1832_array(constB0,b1111_address_term,bitIndex50) ).

fof(initSateConstraint_1236,axiom,
    ~ v1832_array(constB0,b1111_address_term,bitIndex51) ).

fof(initSateConstraint_1235,axiom,
    ~ v1832_array(constB0,b1111_address_term,bitIndex52) ).

fof(initSateConstraint_1234,axiom,
    ~ v1832_array(constB0,b1111_address_term,bitIndex53) ).

fof(bitBlastConstant_682,axiom,
    b1111(bitIndex3) ).

fof(bitBlastConstant_681,axiom,
    b1111(bitIndex2) ).

fof(bitBlastConstant_680,axiom,
    b1111(bitIndex1) ).

fof(bitBlastConstant_679,axiom,
    b1111(bitIndex0) ).

fof(initSateConstraint_1233,axiom,
    ~ v1832_array(constB0,b1110_address_term,bitIndex0) ).

fof(initSateConstraint_1232,axiom,
    ~ v1832_array(constB0,b1110_address_term,bitIndex1) ).

fof(initSateConstraint_1231,axiom,
    ~ v1832_array(constB0,b1110_address_term,bitIndex2) ).

fof(initSateConstraint_1230,axiom,
    ~ v1832_array(constB0,b1110_address_term,bitIndex3) ).

fof(initSateConstraint_1229,axiom,
    ~ v1832_array(constB0,b1110_address_term,bitIndex4) ).

fof(initSateConstraint_1228,axiom,
    ~ v1832_array(constB0,b1110_address_term,bitIndex32) ).

fof(initSateConstraint_1227,axiom,
    ~ v1832_array(constB0,b1110_address_term,bitIndex36) ).

fof(initSateConstraint_1226,axiom,
    ~ v1832_array(constB0,b1110_address_term,bitIndex47) ).

fof(initSateConstraint_1225,axiom,
    ~ v1832_array(constB0,b1110_address_term,bitIndex48) ).

fof(initSateConstraint_1224,axiom,
    ~ v1832_array(constB0,b1110_address_term,bitIndex49) ).

fof(initSateConstraint_1223,axiom,
    ~ v1832_array(constB0,b1110_address_term,bitIndex50) ).

fof(initSateConstraint_1222,axiom,
    ~ v1832_array(constB0,b1110_address_term,bitIndex51) ).

fof(initSateConstraint_1221,axiom,
    ~ v1832_array(constB0,b1110_address_term,bitIndex52) ).

fof(initSateConstraint_1220,axiom,
    ~ v1832_array(constB0,b1110_address_term,bitIndex53) ).

fof(bitBlastConstant_678,axiom,
    b1110(bitIndex3) ).

fof(bitBlastConstant_677,axiom,
    b1110(bitIndex2) ).

fof(bitBlastConstant_676,axiom,
    b1110(bitIndex1) ).

fof(bitBlastConstant_675,axiom,
    ~ b1110(bitIndex0) ).

fof(initSateConstraint_1219,axiom,
    ~ v1832_array(constB0,b1101_address_term,bitIndex0) ).

fof(initSateConstraint_1218,axiom,
    ~ v1832_array(constB0,b1101_address_term,bitIndex1) ).

fof(initSateConstraint_1217,axiom,
    ~ v1832_array(constB0,b1101_address_term,bitIndex2) ).

fof(initSateConstraint_1216,axiom,
    ~ v1832_array(constB0,b1101_address_term,bitIndex3) ).

fof(initSateConstraint_1215,axiom,
    ~ v1832_array(constB0,b1101_address_term,bitIndex4) ).

fof(initSateConstraint_1214,axiom,
    ~ v1832_array(constB0,b1101_address_term,bitIndex32) ).

fof(initSateConstraint_1213,axiom,
    ~ v1832_array(constB0,b1101_address_term,bitIndex36) ).

fof(initSateConstraint_1212,axiom,
    ~ v1832_array(constB0,b1101_address_term,bitIndex47) ).

fof(initSateConstraint_1211,axiom,
    ~ v1832_array(constB0,b1101_address_term,bitIndex48) ).

fof(initSateConstraint_1210,axiom,
    ~ v1832_array(constB0,b1101_address_term,bitIndex49) ).

fof(initSateConstraint_1209,axiom,
    ~ v1832_array(constB0,b1101_address_term,bitIndex50) ).

fof(initSateConstraint_1208,axiom,
    ~ v1832_array(constB0,b1101_address_term,bitIndex51) ).

fof(initSateConstraint_1207,axiom,
    ~ v1832_array(constB0,b1101_address_term,bitIndex52) ).

fof(initSateConstraint_1206,axiom,
    ~ v1832_array(constB0,b1101_address_term,bitIndex53) ).

fof(bitBlastConstant_674,axiom,
    b1101(bitIndex3) ).

fof(bitBlastConstant_673,axiom,
    b1101(bitIndex2) ).

fof(bitBlastConstant_672,axiom,
    ~ b1101(bitIndex1) ).

fof(bitBlastConstant_671,axiom,
    b1101(bitIndex0) ).

fof(initSateConstraint_1205,axiom,
    ~ v1832_array(constB0,b1100_address_term,bitIndex0) ).

fof(initSateConstraint_1204,axiom,
    ~ v1832_array(constB0,b1100_address_term,bitIndex1) ).

fof(initSateConstraint_1203,axiom,
    ~ v1832_array(constB0,b1100_address_term,bitIndex2) ).

fof(initSateConstraint_1202,axiom,
    ~ v1832_array(constB0,b1100_address_term,bitIndex3) ).

fof(initSateConstraint_1201,axiom,
    ~ v1832_array(constB0,b1100_address_term,bitIndex4) ).

fof(initSateConstraint_1200,axiom,
    ~ v1832_array(constB0,b1100_address_term,bitIndex32) ).

fof(initSateConstraint_1199,axiom,
    ~ v1832_array(constB0,b1100_address_term,bitIndex36) ).

fof(initSateConstraint_1198,axiom,
    ~ v1832_array(constB0,b1100_address_term,bitIndex47) ).

fof(initSateConstraint_1197,axiom,
    ~ v1832_array(constB0,b1100_address_term,bitIndex48) ).

fof(initSateConstraint_1196,axiom,
    ~ v1832_array(constB0,b1100_address_term,bitIndex49) ).

fof(initSateConstraint_1195,axiom,
    ~ v1832_array(constB0,b1100_address_term,bitIndex50) ).

fof(initSateConstraint_1194,axiom,
    ~ v1832_array(constB0,b1100_address_term,bitIndex51) ).

fof(initSateConstraint_1193,axiom,
    ~ v1832_array(constB0,b1100_address_term,bitIndex52) ).

fof(initSateConstraint_1192,axiom,
    ~ v1832_array(constB0,b1100_address_term,bitIndex53) ).

fof(bitBlastConstant_670,axiom,
    b1100(bitIndex3) ).

fof(bitBlastConstant_669,axiom,
    b1100(bitIndex2) ).

fof(bitBlastConstant_668,axiom,
    ~ b1100(bitIndex1) ).

fof(bitBlastConstant_667,axiom,
    ~ b1100(bitIndex0) ).

fof(initSateConstraint_1191,axiom,
    ~ v1832_array(constB0,b1011_address_term,bitIndex0) ).

fof(initSateConstraint_1190,axiom,
    ~ v1832_array(constB0,b1011_address_term,bitIndex1) ).

fof(initSateConstraint_1189,axiom,
    ~ v1832_array(constB0,b1011_address_term,bitIndex2) ).

fof(initSateConstraint_1188,axiom,
    ~ v1832_array(constB0,b1011_address_term,bitIndex3) ).

fof(initSateConstraint_1187,axiom,
    ~ v1832_array(constB0,b1011_address_term,bitIndex4) ).

fof(initSateConstraint_1186,axiom,
    ~ v1832_array(constB0,b1011_address_term,bitIndex32) ).

fof(initSateConstraint_1185,axiom,
    ~ v1832_array(constB0,b1011_address_term,bitIndex36) ).

fof(initSateConstraint_1184,axiom,
    ~ v1832_array(constB0,b1011_address_term,bitIndex47) ).

fof(initSateConstraint_1183,axiom,
    ~ v1832_array(constB0,b1011_address_term,bitIndex48) ).

fof(initSateConstraint_1182,axiom,
    ~ v1832_array(constB0,b1011_address_term,bitIndex49) ).

fof(initSateConstraint_1181,axiom,
    ~ v1832_array(constB0,b1011_address_term,bitIndex50) ).

fof(initSateConstraint_1180,axiom,
    ~ v1832_array(constB0,b1011_address_term,bitIndex51) ).

fof(initSateConstraint_1179,axiom,
    ~ v1832_array(constB0,b1011_address_term,bitIndex52) ).

fof(initSateConstraint_1178,axiom,
    ~ v1832_array(constB0,b1011_address_term,bitIndex53) ).

fof(bitBlastConstant_666,axiom,
    b1011(bitIndex3) ).

fof(bitBlastConstant_665,axiom,
    ~ b1011(bitIndex2) ).

fof(bitBlastConstant_664,axiom,
    b1011(bitIndex1) ).

fof(bitBlastConstant_663,axiom,
    b1011(bitIndex0) ).

fof(initSateConstraint_1177,axiom,
    ~ v1832_array(constB0,b1010_address_term,bitIndex0) ).

fof(initSateConstraint_1176,axiom,
    ~ v1832_array(constB0,b1010_address_term,bitIndex1) ).

fof(initSateConstraint_1175,axiom,
    ~ v1832_array(constB0,b1010_address_term,bitIndex2) ).

fof(initSateConstraint_1174,axiom,
    ~ v1832_array(constB0,b1010_address_term,bitIndex3) ).

fof(initSateConstraint_1173,axiom,
    ~ v1832_array(constB0,b1010_address_term,bitIndex4) ).

fof(initSateConstraint_1172,axiom,
    ~ v1832_array(constB0,b1010_address_term,bitIndex32) ).

fof(initSateConstraint_1171,axiom,
    ~ v1832_array(constB0,b1010_address_term,bitIndex36) ).

fof(initSateConstraint_1170,axiom,
    ~ v1832_array(constB0,b1010_address_term,bitIndex47) ).

fof(initSateConstraint_1169,axiom,
    ~ v1832_array(constB0,b1010_address_term,bitIndex48) ).

fof(initSateConstraint_1168,axiom,
    ~ v1832_array(constB0,b1010_address_term,bitIndex49) ).

fof(initSateConstraint_1167,axiom,
    ~ v1832_array(constB0,b1010_address_term,bitIndex50) ).

fof(initSateConstraint_1166,axiom,
    ~ v1832_array(constB0,b1010_address_term,bitIndex51) ).

fof(initSateConstraint_1165,axiom,
    ~ v1832_array(constB0,b1010_address_term,bitIndex52) ).

fof(initSateConstraint_1164,axiom,
    ~ v1832_array(constB0,b1010_address_term,bitIndex53) ).

fof(bitBlastConstant_662,axiom,
    b1010(bitIndex3) ).

fof(bitBlastConstant_661,axiom,
    ~ b1010(bitIndex2) ).

fof(bitBlastConstant_660,axiom,
    b1010(bitIndex1) ).

fof(bitBlastConstant_659,axiom,
    ~ b1010(bitIndex0) ).

fof(initSateConstraint_1163,axiom,
    ~ v1832_array(constB0,b1001_address_term,bitIndex0) ).

fof(initSateConstraint_1162,axiom,
    ~ v1832_array(constB0,b1001_address_term,bitIndex1) ).

fof(initSateConstraint_1161,axiom,
    ~ v1832_array(constB0,b1001_address_term,bitIndex2) ).

fof(initSateConstraint_1160,axiom,
    ~ v1832_array(constB0,b1001_address_term,bitIndex3) ).

fof(initSateConstraint_1159,axiom,
    ~ v1832_array(constB0,b1001_address_term,bitIndex4) ).

fof(initSateConstraint_1158,axiom,
    ~ v1832_array(constB0,b1001_address_term,bitIndex32) ).

fof(initSateConstraint_1157,axiom,
    ~ v1832_array(constB0,b1001_address_term,bitIndex36) ).

fof(initSateConstraint_1156,axiom,
    ~ v1832_array(constB0,b1001_address_term,bitIndex47) ).

fof(initSateConstraint_1155,axiom,
    ~ v1832_array(constB0,b1001_address_term,bitIndex48) ).

fof(initSateConstraint_1154,axiom,
    ~ v1832_array(constB0,b1001_address_term,bitIndex49) ).

fof(initSateConstraint_1153,axiom,
    ~ v1832_array(constB0,b1001_address_term,bitIndex50) ).

fof(initSateConstraint_1152,axiom,
    ~ v1832_array(constB0,b1001_address_term,bitIndex51) ).

fof(initSateConstraint_1151,axiom,
    ~ v1832_array(constB0,b1001_address_term,bitIndex52) ).

fof(initSateConstraint_1150,axiom,
    ~ v1832_array(constB0,b1001_address_term,bitIndex53) ).

fof(bitBlastConstant_658,axiom,
    b1001(bitIndex3) ).

fof(bitBlastConstant_657,axiom,
    ~ b1001(bitIndex2) ).

fof(bitBlastConstant_656,axiom,
    ~ b1001(bitIndex1) ).

fof(bitBlastConstant_655,axiom,
    b1001(bitIndex0) ).

fof(initSateConstraint_1149,axiom,
    ~ v1832_array(constB0,b1000_address_term,bitIndex0) ).

fof(initSateConstraint_1148,axiom,
    ~ v1832_array(constB0,b1000_address_term,bitIndex1) ).

fof(initSateConstraint_1147,axiom,
    ~ v1832_array(constB0,b1000_address_term,bitIndex2) ).

fof(initSateConstraint_1146,axiom,
    ~ v1832_array(constB0,b1000_address_term,bitIndex3) ).

fof(initSateConstraint_1145,axiom,
    ~ v1832_array(constB0,b1000_address_term,bitIndex4) ).

fof(initSateConstraint_1144,axiom,
    ~ v1832_array(constB0,b1000_address_term,bitIndex32) ).

fof(initSateConstraint_1143,axiom,
    ~ v1832_array(constB0,b1000_address_term,bitIndex36) ).

fof(initSateConstraint_1142,axiom,
    ~ v1832_array(constB0,b1000_address_term,bitIndex47) ).

fof(initSateConstraint_1141,axiom,
    ~ v1832_array(constB0,b1000_address_term,bitIndex48) ).

fof(initSateConstraint_1140,axiom,
    ~ v1832_array(constB0,b1000_address_term,bitIndex49) ).

fof(initSateConstraint_1139,axiom,
    ~ v1832_array(constB0,b1000_address_term,bitIndex50) ).

fof(initSateConstraint_1138,axiom,
    ~ v1832_array(constB0,b1000_address_term,bitIndex51) ).

fof(initSateConstraint_1137,axiom,
    ~ v1832_array(constB0,b1000_address_term,bitIndex52) ).

fof(initSateConstraint_1136,axiom,
    ~ v1832_array(constB0,b1000_address_term,bitIndex53) ).

fof(bitBlastConstant_654,axiom,
    b1000(bitIndex3) ).

fof(bitBlastConstant_653,axiom,
    ~ b1000(bitIndex2) ).

fof(bitBlastConstant_652,axiom,
    ~ b1000(bitIndex1) ).

fof(bitBlastConstant_651,axiom,
    ~ b1000(bitIndex0) ).

fof(initSateConstraint_1135,axiom,
    ~ v1832_array(constB0,b0111_address_term,bitIndex0) ).

fof(initSateConstraint_1134,axiom,
    ~ v1832_array(constB0,b0111_address_term,bitIndex1) ).

fof(initSateConstraint_1133,axiom,
    ~ v1832_array(constB0,b0111_address_term,bitIndex2) ).

fof(initSateConstraint_1132,axiom,
    ~ v1832_array(constB0,b0111_address_term,bitIndex3) ).

fof(initSateConstraint_1131,axiom,
    ~ v1832_array(constB0,b0111_address_term,bitIndex4) ).

fof(initSateConstraint_1130,axiom,
    ~ v1832_array(constB0,b0111_address_term,bitIndex32) ).

fof(initSateConstraint_1129,axiom,
    ~ v1832_array(constB0,b0111_address_term,bitIndex36) ).

fof(initSateConstraint_1128,axiom,
    ~ v1832_array(constB0,b0111_address_term,bitIndex47) ).

fof(initSateConstraint_1127,axiom,
    ~ v1832_array(constB0,b0111_address_term,bitIndex48) ).

fof(initSateConstraint_1126,axiom,
    ~ v1832_array(constB0,b0111_address_term,bitIndex49) ).

fof(initSateConstraint_1125,axiom,
    ~ v1832_array(constB0,b0111_address_term,bitIndex50) ).

fof(initSateConstraint_1124,axiom,
    ~ v1832_array(constB0,b0111_address_term,bitIndex51) ).

fof(initSateConstraint_1123,axiom,
    ~ v1832_array(constB0,b0111_address_term,bitIndex52) ).

fof(initSateConstraint_1122,axiom,
    ~ v1832_array(constB0,b0111_address_term,bitIndex53) ).

fof(bitBlastConstant_650,axiom,
    ~ b0111(bitIndex3) ).

fof(bitBlastConstant_649,axiom,
    b0111(bitIndex2) ).

fof(bitBlastConstant_648,axiom,
    b0111(bitIndex1) ).

fof(bitBlastConstant_647,axiom,
    b0111(bitIndex0) ).

fof(initSateConstraint_1121,axiom,
    ~ v1832_array(constB0,b0110_address_term,bitIndex0) ).

fof(initSateConstraint_1120,axiom,
    ~ v1832_array(constB0,b0110_address_term,bitIndex1) ).

fof(initSateConstraint_1119,axiom,
    ~ v1832_array(constB0,b0110_address_term,bitIndex2) ).

fof(initSateConstraint_1118,axiom,
    ~ v1832_array(constB0,b0110_address_term,bitIndex3) ).

fof(initSateConstraint_1117,axiom,
    ~ v1832_array(constB0,b0110_address_term,bitIndex4) ).

fof(initSateConstraint_1116,axiom,
    ~ v1832_array(constB0,b0110_address_term,bitIndex32) ).

fof(initSateConstraint_1115,axiom,
    ~ v1832_array(constB0,b0110_address_term,bitIndex36) ).

fof(initSateConstraint_1114,axiom,
    ~ v1832_array(constB0,b0110_address_term,bitIndex47) ).

fof(initSateConstraint_1113,axiom,
    ~ v1832_array(constB0,b0110_address_term,bitIndex48) ).

fof(initSateConstraint_1112,axiom,
    ~ v1832_array(constB0,b0110_address_term,bitIndex49) ).

fof(initSateConstraint_1111,axiom,
    ~ v1832_array(constB0,b0110_address_term,bitIndex50) ).

fof(initSateConstraint_1110,axiom,
    ~ v1832_array(constB0,b0110_address_term,bitIndex51) ).

fof(initSateConstraint_1109,axiom,
    ~ v1832_array(constB0,b0110_address_term,bitIndex52) ).

fof(initSateConstraint_1108,axiom,
    ~ v1832_array(constB0,b0110_address_term,bitIndex53) ).

fof(bitBlastConstant_646,axiom,
    ~ b0110(bitIndex3) ).

fof(bitBlastConstant_645,axiom,
    b0110(bitIndex2) ).

fof(bitBlastConstant_644,axiom,
    b0110(bitIndex1) ).

fof(bitBlastConstant_643,axiom,
    ~ b0110(bitIndex0) ).

fof(initSateConstraint_1107,axiom,
    ~ v1832_array(constB0,b0101_address_term,bitIndex0) ).

fof(initSateConstraint_1106,axiom,
    ~ v1832_array(constB0,b0101_address_term,bitIndex1) ).

fof(initSateConstraint_1105,axiom,
    ~ v1832_array(constB0,b0101_address_term,bitIndex2) ).

fof(initSateConstraint_1104,axiom,
    ~ v1832_array(constB0,b0101_address_term,bitIndex3) ).

fof(initSateConstraint_1103,axiom,
    ~ v1832_array(constB0,b0101_address_term,bitIndex4) ).

fof(initSateConstraint_1102,axiom,
    ~ v1832_array(constB0,b0101_address_term,bitIndex32) ).

fof(initSateConstraint_1101,axiom,
    ~ v1832_array(constB0,b0101_address_term,bitIndex36) ).

fof(initSateConstraint_1100,axiom,
    ~ v1832_array(constB0,b0101_address_term,bitIndex47) ).

fof(initSateConstraint_1099,axiom,
    ~ v1832_array(constB0,b0101_address_term,bitIndex48) ).

fof(initSateConstraint_1098,axiom,
    ~ v1832_array(constB0,b0101_address_term,bitIndex49) ).

fof(initSateConstraint_1097,axiom,
    ~ v1832_array(constB0,b0101_address_term,bitIndex50) ).

fof(initSateConstraint_1096,axiom,
    ~ v1832_array(constB0,b0101_address_term,bitIndex51) ).

fof(initSateConstraint_1095,axiom,
    ~ v1832_array(constB0,b0101_address_term,bitIndex52) ).

fof(initSateConstraint_1094,axiom,
    ~ v1832_array(constB0,b0101_address_term,bitIndex53) ).

fof(initSateConstraint_1093,axiom,
    ~ v1832_array(constB0,b0100_address_term,bitIndex0) ).

fof(initSateConstraint_1092,axiom,
    ~ v1832_array(constB0,b0100_address_term,bitIndex1) ).

fof(initSateConstraint_1091,axiom,
    ~ v1832_array(constB0,b0100_address_term,bitIndex2) ).

fof(initSateConstraint_1090,axiom,
    ~ v1832_array(constB0,b0100_address_term,bitIndex3) ).

fof(initSateConstraint_1089,axiom,
    ~ v1832_array(constB0,b0100_address_term,bitIndex4) ).

fof(initSateConstraint_1088,axiom,
    ~ v1832_array(constB0,b0100_address_term,bitIndex32) ).

fof(initSateConstraint_1087,axiom,
    ~ v1832_array(constB0,b0100_address_term,bitIndex36) ).

fof(initSateConstraint_1086,axiom,
    ~ v1832_array(constB0,b0100_address_term,bitIndex47) ).

fof(initSateConstraint_1085,axiom,
    ~ v1832_array(constB0,b0100_address_term,bitIndex48) ).

fof(initSateConstraint_1084,axiom,
    ~ v1832_array(constB0,b0100_address_term,bitIndex49) ).

fof(initSateConstraint_1083,axiom,
    ~ v1832_array(constB0,b0100_address_term,bitIndex50) ).

fof(initSateConstraint_1082,axiom,
    ~ v1832_array(constB0,b0100_address_term,bitIndex51) ).

fof(initSateConstraint_1081,axiom,
    ~ v1832_array(constB0,b0100_address_term,bitIndex52) ).

fof(initSateConstraint_1080,axiom,
    ~ v1832_array(constB0,b0100_address_term,bitIndex53) ).

fof(initSateConstraint_1079,axiom,
    ~ v1832_array(constB0,b0011_address_term,bitIndex0) ).

fof(initSateConstraint_1078,axiom,
    ~ v1832_array(constB0,b0011_address_term,bitIndex1) ).

fof(initSateConstraint_1077,axiom,
    ~ v1832_array(constB0,b0011_address_term,bitIndex2) ).

fof(initSateConstraint_1076,axiom,
    ~ v1832_array(constB0,b0011_address_term,bitIndex3) ).

fof(initSateConstraint_1075,axiom,
    ~ v1832_array(constB0,b0011_address_term,bitIndex4) ).

fof(initSateConstraint_1074,axiom,
    ~ v1832_array(constB0,b0011_address_term,bitIndex32) ).

fof(initSateConstraint_1073,axiom,
    ~ v1832_array(constB0,b0011_address_term,bitIndex36) ).

fof(initSateConstraint_1072,axiom,
    ~ v1832_array(constB0,b0011_address_term,bitIndex47) ).

fof(initSateConstraint_1071,axiom,
    ~ v1832_array(constB0,b0011_address_term,bitIndex48) ).

fof(initSateConstraint_1070,axiom,
    ~ v1832_array(constB0,b0011_address_term,bitIndex49) ).

fof(initSateConstraint_1069,axiom,
    ~ v1832_array(constB0,b0011_address_term,bitIndex50) ).

fof(initSateConstraint_1068,axiom,
    ~ v1832_array(constB0,b0011_address_term,bitIndex51) ).

fof(initSateConstraint_1067,axiom,
    ~ v1832_array(constB0,b0011_address_term,bitIndex52) ).

fof(initSateConstraint_1066,axiom,
    ~ v1832_array(constB0,b0011_address_term,bitIndex53) ).

fof(initSateConstraint_1065,axiom,
    ~ v1832_array(constB0,b0010_address_term,bitIndex0) ).

fof(initSateConstraint_1064,axiom,
    ~ v1832_array(constB0,b0010_address_term,bitIndex1) ).

fof(initSateConstraint_1063,axiom,
    ~ v1832_array(constB0,b0010_address_term,bitIndex2) ).

fof(initSateConstraint_1062,axiom,
    ~ v1832_array(constB0,b0010_address_term,bitIndex3) ).

fof(initSateConstraint_1061,axiom,
    ~ v1832_array(constB0,b0010_address_term,bitIndex4) ).

fof(initSateConstraint_1060,axiom,
    ~ v1832_array(constB0,b0010_address_term,bitIndex32) ).

fof(initSateConstraint_1059,axiom,
    ~ v1832_array(constB0,b0010_address_term,bitIndex36) ).

fof(initSateConstraint_1058,axiom,
    ~ v1832_array(constB0,b0010_address_term,bitIndex47) ).

fof(initSateConstraint_1057,axiom,
    ~ v1832_array(constB0,b0010_address_term,bitIndex48) ).

fof(initSateConstraint_1056,axiom,
    ~ v1832_array(constB0,b0010_address_term,bitIndex49) ).

fof(initSateConstraint_1055,axiom,
    ~ v1832_array(constB0,b0010_address_term,bitIndex50) ).

fof(initSateConstraint_1054,axiom,
    ~ v1832_array(constB0,b0010_address_term,bitIndex51) ).

fof(initSateConstraint_1053,axiom,
    ~ v1832_array(constB0,b0010_address_term,bitIndex52) ).

fof(initSateConstraint_1052,axiom,
    ~ v1832_array(constB0,b0010_address_term,bitIndex53) ).

fof(initSateConstraint_1051,axiom,
    ~ v1832_array(constB0,b0001_address_term,bitIndex0) ).

fof(initSateConstraint_1050,axiom,
    ~ v1832_array(constB0,b0001_address_term,bitIndex1) ).

fof(initSateConstraint_1049,axiom,
    ~ v1832_array(constB0,b0001_address_term,bitIndex2) ).

fof(initSateConstraint_1048,axiom,
    ~ v1832_array(constB0,b0001_address_term,bitIndex3) ).

fof(initSateConstraint_1047,axiom,
    ~ v1832_array(constB0,b0001_address_term,bitIndex4) ).

fof(initSateConstraint_1046,axiom,
    ~ v1832_array(constB0,b0001_address_term,bitIndex32) ).

fof(initSateConstraint_1045,axiom,
    ~ v1832_array(constB0,b0001_address_term,bitIndex36) ).

fof(initSateConstraint_1044,axiom,
    ~ v1832_array(constB0,b0001_address_term,bitIndex47) ).

fof(initSateConstraint_1043,axiom,
    ~ v1832_array(constB0,b0001_address_term,bitIndex48) ).

fof(initSateConstraint_1042,axiom,
    ~ v1832_array(constB0,b0001_address_term,bitIndex49) ).

fof(initSateConstraint_1041,axiom,
    ~ v1832_array(constB0,b0001_address_term,bitIndex50) ).

fof(initSateConstraint_1040,axiom,
    ~ v1832_array(constB0,b0001_address_term,bitIndex51) ).

fof(initSateConstraint_1039,axiom,
    ~ v1832_array(constB0,b0001_address_term,bitIndex52) ).

fof(initSateConstraint_1038,axiom,
    ~ v1832_array(constB0,b0001_address_term,bitIndex53) ).

fof(bitBlastConstant_642,axiom,
    ~ b0001(bitIndex3) ).

fof(bitBlastConstant_641,axiom,
    ~ b0001(bitIndex2) ).

fof(bitBlastConstant_640,axiom,
    ~ b0001(bitIndex1) ).

fof(bitBlastConstant_639,axiom,
    b0001(bitIndex0) ).

fof(initSateConstraint_1037,axiom,
    ~ v1832_array(constB0,b0000_address_term,bitIndex0) ).

fof(initSateConstraint_1036,axiom,
    ~ v1832_array(constB0,b0000_address_term,bitIndex1) ).

fof(initSateConstraint_1035,axiom,
    ~ v1832_array(constB0,b0000_address_term,bitIndex2) ).

fof(initSateConstraint_1034,axiom,
    ~ v1832_array(constB0,b0000_address_term,bitIndex3) ).

fof(initSateConstraint_1033,axiom,
    ~ v1832_array(constB0,b0000_address_term,bitIndex4) ).

fof(initSateConstraint_1032,axiom,
    ~ v1832_array(constB0,b0000_address_term,bitIndex32) ).

fof(initSateConstraint_1031,axiom,
    ~ v1832_array(constB0,b0000_address_term,bitIndex36) ).

fof(initSateConstraint_1030,axiom,
    ~ v1832_array(constB0,b0000_address_term,bitIndex47) ).

fof(initSateConstraint_1029,axiom,
    ~ v1832_array(constB0,b0000_address_term,bitIndex48) ).

fof(initSateConstraint_1028,axiom,
    ~ v1832_array(constB0,b0000_address_term,bitIndex49) ).

fof(initSateConstraint_1027,axiom,
    ~ v1832_array(constB0,b0000_address_term,bitIndex50) ).

fof(initSateConstraint_1026,axiom,
    ~ v1832_array(constB0,b0000_address_term,bitIndex51) ).

fof(initSateConstraint_1025,axiom,
    ~ v1832_array(constB0,b0000_address_term,bitIndex52) ).

fof(initSateConstraint_1024,axiom,
    ~ v1832_array(constB0,b0000_address_term,bitIndex53) ).

fof(addAssignment_547,axiom,
    ! [VarCurr] :
      ( v2298(VarCurr)
    <=> v2300(VarCurr) ) ).

fof(addAssignment_546,axiom,
    ! [VarCurr] :
      ( v2300(VarCurr)
    <=> v2302(VarCurr) ) ).

fof(addAssignment_545,axiom,
    ! [VarCurr] :
      ( v2302(VarCurr)
    <=> v2304(VarCurr) ) ).

fof(addAssignmentInitValueVector_38,axiom,
    ( v2304(constB0)
  <=> $false ) ).

fof(addAssignment_544,axiom,
    ! [VarCurr,B] :
      ( range_53_0(B)
     => ( v2288(VarCurr,B)
      <=> v2290(VarCurr,B) ) ) ).

fof(addAssignment_543,axiom,
    ! [VarCurr,B] :
      ( range_53_0(B)
     => ( v2290(VarCurr,B)
      <=> v2292(VarCurr,B) ) ) ).

fof(addAssignment_542,axiom,
    ! [VarCurr,B] :
      ( range_53_0(B)
     => ( v2292(VarCurr,B)
      <=> v2294(VarCurr,B) ) ) ).

fof(range_axiom_13,axiom,
    ! [B] :
      ( range_53_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B
        | bitIndex30 = B
        | bitIndex31 = B
        | bitIndex32 = B
        | bitIndex33 = B
        | bitIndex34 = B
        | bitIndex35 = B
        | bitIndex36 = B
        | bitIndex37 = B
        | bitIndex38 = B
        | bitIndex39 = B
        | bitIndex40 = B
        | bitIndex41 = B
        | bitIndex42 = B
        | bitIndex43 = B
        | bitIndex44 = B
        | bitIndex45 = B
        | bitIndex46 = B
        | bitIndex47 = B
        | bitIndex48 = B
        | bitIndex49 = B
        | bitIndex50 = B
        | bitIndex51 = B
        | bitIndex52 = B
        | bitIndex53 = B ) ) ).

fof(addAssignmentInitValue_107,axiom,
    ~ v2294(constB0,bitIndex53) ).

fof(addAssignmentInitValue_106,axiom,
    ~ v2294(constB0,bitIndex52) ).

fof(addAssignmentInitValue_105,axiom,
    ~ v2294(constB0,bitIndex51) ).

fof(addAssignmentInitValue_104,axiom,
    ~ v2294(constB0,bitIndex50) ).

fof(addAssignmentInitValue_103,axiom,
    ~ v2294(constB0,bitIndex49) ).

fof(addAssignmentInitValue_102,axiom,
    ~ v2294(constB0,bitIndex48) ).

fof(addAssignmentInitValue_101,axiom,
    ~ v2294(constB0,bitIndex47) ).

fof(addAssignmentInitValue_100,axiom,
    ~ v2294(constB0,bitIndex36) ).

fof(addAssignmentInitValue_99,axiom,
    ~ v2294(constB0,bitIndex32) ).

fof(bitBlastConstant_638,axiom,
    ~ b0000000xxxxxxxxxx0xxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex53) ).

fof(bitBlastConstant_637,axiom,
    ~ b0000000xxxxxxxxxx0xxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex52) ).

fof(bitBlastConstant_636,axiom,
    ~ b0000000xxxxxxxxxx0xxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex51) ).

fof(bitBlastConstant_635,axiom,
    ~ b0000000xxxxxxxxxx0xxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex50) ).

fof(bitBlastConstant_634,axiom,
    ~ b0000000xxxxxxxxxx0xxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex49) ).

fof(bitBlastConstant_633,axiom,
    ~ b0000000xxxxxxxxxx0xxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex48) ).

fof(bitBlastConstant_632,axiom,
    ~ b0000000xxxxxxxxxx0xxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex47) ).

fof(bitBlastConstant_631,axiom,
    ~ b0000000xxxxxxxxxx0xxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex36) ).

fof(bitBlastConstant_630,axiom,
    ~ b0000000xxxxxxxxxx0xxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex32) ).

fof(addAssignment_541,axiom,
    ! [VarCurr] :
      ( v2286(VarCurr)
    <=> v1069(VarCurr) ) ).

fof(addAssignment_540,axiom,
    ! [VarCurr] :
      ( v2283(VarCurr)
    <=> v1064(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_341,axiom,
    ! [VarCurr] :
      ( v2280(VarCurr)
    <=> ( v2006(VarCurr)
        | v1818(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_15,axiom,
    ! [VarCurr] :
      ( ( ~ v2246(VarCurr)
        & ~ v2247(VarCurr)
        & ~ v2278(VarCurr) )
     => ( v704(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_28,axiom,
    ! [VarCurr] :
      ( v2278(VarCurr)
     => ( v704(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_74,axiom,
    ! [VarCurr] :
      ( v2247(VarCurr)
     => ( v704(VarCurr)
      <=> v2248(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_74,axiom,
    ! [VarCurr] :
      ( v2246(VarCurr)
     => ( v704(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_227,axiom,
    ! [VarCurr] :
      ( v2278(VarCurr)
    <=> ( ( v58(VarCurr,bitIndex2)
        <=> $false )
        & ( v58(VarCurr,bitIndex1)
        <=> $true )
        & ( v58(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_73,axiom,
    ! [VarCurr] :
      ( ~ v2249(VarCurr)
     => ( v2248(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_73,axiom,
    ! [VarCurr] :
      ( v2249(VarCurr)
     => ( v2248(VarCurr)
      <=> v2250(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_226,axiom,
    ! [VarCurr] :
      ( v2277(VarCurr)
    <=> ( v495(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_14,axiom,
    ! [VarCurr] :
      ( ( ~ v2251(VarCurr)
        & ~ v2253(VarCurr)
        & ~ v2267(VarCurr) )
     => ( v2250(VarCurr)
      <=> v2271(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_27,axiom,
    ! [VarCurr] :
      ( v2267(VarCurr)
     => ( v2250(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_72,axiom,
    ! [VarCurr] :
      ( v2253(VarCurr)
     => ( v2250(VarCurr)
      <=> v2255(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_72,axiom,
    ! [VarCurr] :
      ( v2251(VarCurr)
     => ( v2250(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_71,axiom,
    ! [VarCurr] :
      ( ~ v2272(VarCurr)
     => ( v2271(VarCurr)
      <=> v2274(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_71,axiom,
    ! [VarCurr] :
      ( v2272(VarCurr)
     => ( v2271(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_70,axiom,
    ! [VarCurr] :
      ( ~ v2275(VarCurr)
     => ( v2274(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_70,axiom,
    ! [VarCurr] :
      ( v2275(VarCurr)
     => ( v2274(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_225,axiom,
    ! [VarCurr] :
      ( v2276(VarCurr)
    <=> ( v2206(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_224,axiom,
    ! [VarCurr] :
      ( v2275(VarCurr)
    <=> ( v2206(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_223,axiom,
    ! [VarCurr] :
      ( v2273(VarCurr)
    <=> ( v1818(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_222,axiom,
    ! [VarCurr] :
      ( v2272(VarCurr)
    <=> ( v1818(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_221,axiom,
    ! [VarCurr] :
      ( v2269(VarCurr)
    <=> ( ( v2270(VarCurr,bitIndex1)
        <=> $true )
        & ( v2270(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_539,axiom,
    ! [VarCurr] :
      ( v2270(VarCurr,bitIndex0)
    <=> v2237(VarCurr) ) ).

fof(addAssignment_538,axiom,
    ! [VarCurr] :
      ( v2270(VarCurr,bitIndex1)
    <=> v706(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_220,axiom,
    ! [VarCurr] :
      ( v2267(VarCurr)
    <=> ( ( v2268(VarCurr,bitIndex1)
        <=> $true )
        & ( v2268(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_537,axiom,
    ! [VarCurr] :
      ( v2268(VarCurr,bitIndex0)
    <=> v2237(VarCurr) ) ).

fof(addAssignment_536,axiom,
    ! [VarCurr] :
      ( v2268(VarCurr,bitIndex1)
    <=> v706(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_69,axiom,
    ! [VarCurr] :
      ( ~ v2256(VarCurr)
     => ( v2255(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_69,axiom,
    ! [VarCurr] :
      ( v2256(VarCurr)
     => ( v2255(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_340,axiom,
    ! [VarCurr] :
      ( v2256(VarCurr)
    <=> ( v2257(VarCurr)
        | v2262(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_339,axiom,
    ! [VarCurr] :
      ( v2262(VarCurr)
    <=> ( v2263(VarCurr)
        | v2265(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_219,axiom,
    ! [VarCurr] :
      ( v2265(VarCurr)
    <=> ( ( v2266(VarCurr,bitIndex3)
        <=> $false )
        & ( v2266(VarCurr,bitIndex2)
        <=> $true )
        & ( v2266(VarCurr,bitIndex1)
        <=> $false )
        & ( v2266(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_535,axiom,
    ! [VarCurr] :
      ( v2266(VarCurr,bitIndex0)
    <=> v2006(VarCurr) ) ).

fof(addAssignment_534,axiom,
    ! [VarCurr] :
      ( ( v2266(VarCurr,bitIndex3)
      <=> v983(VarCurr,bitIndex2) )
      & ( v2266(VarCurr,bitIndex2)
      <=> v983(VarCurr,bitIndex1) )
      & ( v2266(VarCurr,bitIndex1)
      <=> v983(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_218,axiom,
    ! [VarCurr] :
      ( v2263(VarCurr)
    <=> ( ( v2264(VarCurr,bitIndex3)
        <=> $false )
        & ( v2264(VarCurr,bitIndex2)
        <=> $false )
        & ( v2264(VarCurr,bitIndex1)
        <=> $true )
        & ( v2264(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_533,axiom,
    ! [VarCurr] :
      ( v2264(VarCurr,bitIndex0)
    <=> v2006(VarCurr) ) ).

fof(addAssignment_532,axiom,
    ! [VarCurr] :
      ( ( v2264(VarCurr,bitIndex3)
      <=> v983(VarCurr,bitIndex2) )
      & ( v2264(VarCurr,bitIndex2)
      <=> v983(VarCurr,bitIndex1) )
      & ( v2264(VarCurr,bitIndex1)
      <=> v983(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_338,axiom,
    ! [VarCurr] :
      ( v2257(VarCurr)
    <=> ( v2258(VarCurr)
        | v2260(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_217,axiom,
    ! [VarCurr] :
      ( v2260(VarCurr)
    <=> ( ( v2261(VarCurr,bitIndex3)
        <=> $false )
        & ( v2261(VarCurr,bitIndex2)
        <=> $true )
        & ( v2261(VarCurr,bitIndex1)
        <=> $false )
        & ( v2261(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_629,axiom,
    ~ b0100(bitIndex3) ).

fof(bitBlastConstant_628,axiom,
    b0100(bitIndex2) ).

fof(bitBlastConstant_627,axiom,
    ~ b0100(bitIndex1) ).

fof(bitBlastConstant_626,axiom,
    ~ b0100(bitIndex0) ).

fof(addAssignment_531,axiom,
    ! [VarCurr] :
      ( v2261(VarCurr,bitIndex0)
    <=> v2006(VarCurr) ) ).

fof(addAssignment_530,axiom,
    ! [VarCurr] :
      ( ( v2261(VarCurr,bitIndex3)
      <=> v983(VarCurr,bitIndex2) )
      & ( v2261(VarCurr,bitIndex2)
      <=> v983(VarCurr,bitIndex1) )
      & ( v2261(VarCurr,bitIndex1)
      <=> v983(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_216,axiom,
    ! [VarCurr] :
      ( v2258(VarCurr)
    <=> ( ( v2259(VarCurr,bitIndex3)
        <=> $false )
        & ( v2259(VarCurr,bitIndex2)
        <=> $false )
        & ( v2259(VarCurr,bitIndex1)
        <=> $true )
        & ( v2259(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_625,axiom,
    ~ b0010(bitIndex3) ).

fof(bitBlastConstant_624,axiom,
    ~ b0010(bitIndex2) ).

fof(bitBlastConstant_623,axiom,
    b0010(bitIndex1) ).

fof(bitBlastConstant_622,axiom,
    ~ b0010(bitIndex0) ).

fof(addAssignment_529,axiom,
    ! [VarCurr] :
      ( v2259(VarCurr,bitIndex0)
    <=> v2006(VarCurr) ) ).

fof(addAssignment_528,axiom,
    ! [VarCurr] :
      ( ( v2259(VarCurr,bitIndex3)
      <=> v983(VarCurr,bitIndex2) )
      & ( v2259(VarCurr,bitIndex2)
      <=> v983(VarCurr,bitIndex1) )
      & ( v2259(VarCurr,bitIndex1)
      <=> v983(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_215,axiom,
    ! [VarCurr] :
      ( v2253(VarCurr)
    <=> ( ( v2254(VarCurr,bitIndex1)
        <=> $false )
        & ( v2254(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_527,axiom,
    ! [VarCurr] :
      ( v2254(VarCurr,bitIndex0)
    <=> v2237(VarCurr) ) ).

fof(addAssignment_526,axiom,
    ! [VarCurr] :
      ( v2254(VarCurr,bitIndex1)
    <=> v706(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_214,axiom,
    ! [VarCurr] :
      ( v2251(VarCurr)
    <=> ( ( v2252(VarCurr,bitIndex1)
        <=> $false )
        & ( v2252(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_525,axiom,
    ! [VarCurr] :
      ( v2252(VarCurr,bitIndex0)
    <=> v2237(VarCurr) ) ).

fof(addAssignment_524,axiom,
    ! [VarCurr] :
      ( v2252(VarCurr,bitIndex1)
    <=> v706(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_213,axiom,
    ! [VarCurr] :
      ( v2249(VarCurr)
    <=> ( v495(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_212,axiom,
    ! [VarCurr] :
      ( v2247(VarCurr)
    <=> ( ( v58(VarCurr,bitIndex2)
        <=> $false )
        & ( v58(VarCurr,bitIndex1)
        <=> $true )
        & ( v58(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_211,axiom,
    ! [VarCurr] :
      ( v2246(VarCurr)
    <=> ( ( v58(VarCurr,bitIndex2)
        <=> $false )
        & ( v58(VarCurr,bitIndex1)
        <=> $false )
        & ( v58(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignmentInitValueVector_37,axiom,
    ! [B] :
      ( range_2_0(B)
     => ( v58(constB0,B)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_13,axiom,
    ! [VarCurr] :
      ( ( ~ v2239(VarCurr)
        & ~ v1166(VarCurr)
        & ~ v1176(VarCurr) )
     => ( v2237(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_26,axiom,
    ! [VarCurr] :
      ( v1176(VarCurr)
     => ( v2237(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_68,axiom,
    ! [VarCurr] :
      ( v1166(VarCurr)
     => ( v2237(VarCurr)
      <=> v2240(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_68,axiom,
    ! [VarCurr] :
      ( v2239(VarCurr)
     => ( v2237(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_67,axiom,
    ! [VarCurr] :
      ( ~ v1168(VarCurr)
     => ( v2240(VarCurr)
      <=> v2242(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_67,axiom,
    ! [VarCurr] :
      ( v1168(VarCurr)
     => ( v2240(VarCurr)
      <=> v2241(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_66,axiom,
    ! [VarCurr] :
      ( ~ v1171(VarCurr)
     => ( v2242(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_66,axiom,
    ! [VarCurr] :
      ( v1171(VarCurr)
     => ( v2242(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_25,axiom,
    ! [VarCurr] :
      ( ( ~ v1772(VarCurr)
        & ~ v1774(VarCurr) )
     => ( v2241(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_65,axiom,
    ! [VarCurr] :
      ( v1774(VarCurr)
     => ( v2241(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_65,axiom,
    ! [VarCurr] :
      ( v1772(VarCurr)
     => ( v2241(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_337,axiom,
    ! [VarCurr] :
      ( v2239(VarCurr)
    <=> ( v1796(VarCurr)
        | v1165(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_25,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2221(VarNext)
       => ( v706(VarNext)
        <=> v706(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_25,axiom,
    ! [VarNext] :
      ( v2221(VarNext)
     => ( v706(VarNext)
      <=> v2229(VarNext) ) ) ).

fof(addAssignment_523,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2229(VarNext)
      <=> v2227(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_49,axiom,
    ! [VarCurr] :
      ( ~ v2230(VarCurr)
     => ( v2227(VarCurr)
      <=> v2231(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_50,axiom,
    ! [VarCurr] :
      ( v2230(VarCurr)
     => ( v2227(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_48,axiom,
    ! [VarCurr] :
      ( ~ v708(VarCurr)
     => ( v2231(VarCurr)
      <=> v2232(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_49,axiom,
    ! [VarCurr] :
      ( v708(VarCurr)
     => ( v2231(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_336,axiom,
    ! [VarCurr] :
      ( v2232(VarCurr)
    <=> ( v2233(VarCurr)
        & v706(VarCurr) ) ) ).

fof(writeUnaryOperator_148,axiom,
    ! [VarCurr] :
      ( ~ v2233(VarCurr)
    <=> v2206(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_210,axiom,
    ! [VarCurr] :
      ( v2230(VarCurr)
    <=> ( v51(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_335,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2221(VarNext)
      <=> v2222(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_334,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2222(VarNext)
      <=> ( v2223(VarNext)
          & v125(VarNext) ) ) ) ).

fof(writeUnaryOperator_147,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2223(VarNext)
      <=> v990(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges5_3,axiom,
    ! [VarCurr] :
      ( ( ~ v1160(VarCurr)
        & ~ v1161(VarCurr)
        & ~ v1165(VarCurr)
        & ~ v1166(VarCurr)
        & ~ v1176(VarCurr) )
     => ( v2206(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_5,axiom,
    ! [VarCurr] :
      ( v1176(VarCurr)
     => ( v2206(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_12,axiom,
    ! [VarCurr] :
      ( v1166(VarCurr)
     => ( v2206(VarCurr)
      <=> v2210(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_24,axiom,
    ! [VarCurr] :
      ( v1165(VarCurr)
     => ( v2206(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_64,axiom,
    ! [VarCurr] :
      ( v1161(VarCurr)
     => ( v2206(VarCurr)
      <=> v2208(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_64,axiom,
    ! [VarCurr] :
      ( v1160(VarCurr)
     => ( v2206(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_63,axiom,
    ! [VarCurr] :
      ( ~ v1168(VarCurr)
     => ( v2210(VarCurr)
      <=> v2218(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_63,axiom,
    ! [VarCurr] :
      ( v1168(VarCurr)
     => ( v2210(VarCurr)
      <=> v2211(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_62,axiom,
    ! [VarCurr] :
      ( ~ v1171(VarCurr)
     => ( v2218(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_62,axiom,
    ! [VarCurr] :
      ( v1171(VarCurr)
     => ( v2218(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_23,axiom,
    ! [VarCurr] :
      ( ( ~ v1772(VarCurr)
        & ~ v1774(VarCurr) )
     => ( v2211(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_61,axiom,
    ! [VarCurr] :
      ( v1774(VarCurr)
     => ( v2211(VarCurr)
      <=> v2215(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_61,axiom,
    ! [VarCurr] :
      ( v1772(VarCurr)
     => ( v2211(VarCurr)
      <=> v2212(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_60,axiom,
    ! [VarCurr] :
      ( ~ v2216(VarCurr)
     => ( v2215(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_60,axiom,
    ! [VarCurr] :
      ( v2216(VarCurr)
     => ( v2215(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_209,axiom,
    ! [VarCurr] :
      ( v2217(VarCurr)
    <=> ( v2110(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_208,axiom,
    ! [VarCurr] :
      ( v2216(VarCurr)
    <=> ( v2110(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_59,axiom,
    ! [VarCurr] :
      ( ~ v2213(VarCurr)
     => ( v2212(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_59,axiom,
    ! [VarCurr] :
      ( v2213(VarCurr)
     => ( v2212(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_207,axiom,
    ! [VarCurr] :
      ( v2214(VarCurr)
    <=> ( v2006(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_206,axiom,
    ! [VarCurr] :
      ( v2213(VarCurr)
    <=> ( v2006(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_58,axiom,
    ! [VarCurr] :
      ( ~ v1163(VarCurr)
     => ( v2208(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_58,axiom,
    ! [VarCurr] :
      ( v1163(VarCurr)
     => ( v2208(VarCurr)
      <=> v2209(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_57,axiom,
    ! [VarCurr] :
      ( ~ v2199(VarCurr)
     => ( v2209(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_57,axiom,
    ! [VarCurr] :
      ( v2199(VarCurr)
     => ( v2209(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges5_2,axiom,
    ! [VarCurr] :
      ( ( ~ v1160(VarCurr)
        & ~ v1161(VarCurr)
        & ~ v1165(VarCurr)
        & ~ v1166(VarCurr)
        & ~ v1176(VarCurr) )
     => ( v708(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_4,axiom,
    ! [VarCurr] :
      ( v1176(VarCurr)
     => ( v708(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_11,axiom,
    ! [VarCurr] :
      ( v1166(VarCurr)
     => ( v708(VarCurr)
      <=> v2201(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_22,axiom,
    ! [VarCurr] :
      ( v1165(VarCurr)
     => ( v708(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_56,axiom,
    ! [VarCurr] :
      ( v1161(VarCurr)
     => ( v708(VarCurr)
      <=> v2197(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_56,axiom,
    ! [VarCurr] :
      ( v1160(VarCurr)
     => ( v708(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_55,axiom,
    ! [VarCurr] :
      ( ~ v1168(VarCurr)
     => ( v2201(VarCurr)
      <=> v2204(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_55,axiom,
    ! [VarCurr] :
      ( v1168(VarCurr)
     => ( v2201(VarCurr)
      <=> v2202(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_54,axiom,
    ! [VarCurr] :
      ( ~ v1171(VarCurr)
     => ( v2204(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_54,axiom,
    ! [VarCurr] :
      ( v1171(VarCurr)
     => ( v2204(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_53,axiom,
    ! [VarCurr] :
      ( ~ v2203(VarCurr)
     => ( v2202(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_53,axiom,
    ! [VarCurr] :
      ( v2203(VarCurr)
     => ( v2202(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_333,axiom,
    ! [VarCurr] :
      ( v2203(VarCurr)
    <=> ( v1772(VarCurr)
        | v1774(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_52,axiom,
    ! [VarCurr] :
      ( ~ v1163(VarCurr)
     => ( v2197(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_52,axiom,
    ! [VarCurr] :
      ( v1163(VarCurr)
     => ( v2197(VarCurr)
      <=> v2198(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_51,axiom,
    ! [VarCurr] :
      ( ~ v2199(VarCurr)
     => ( v2198(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_51,axiom,
    ! [VarCurr] :
      ( v2199(VarCurr)
     => ( v2198(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_205,axiom,
    ! [VarCurr] :
      ( v2200(VarCurr)
    <=> ( v1818(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_204,axiom,
    ! [VarCurr] :
      ( v2199(VarCurr)
    <=> ( v1818(VarCurr)
      <=> $true ) ) ).

fof(addCaseBooleanConditionEqualRanges1_24,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2184(VarNext)
       => ! [B] :
            ( range_2_0(B)
           => ( v710(VarNext,B)
            <=> v710(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_24,axiom,
    ! [VarNext] :
      ( v2184(VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v710(VarNext,B)
          <=> v2192(VarNext,B) ) ) ) ).

fof(addAssignment_522,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v2192(VarNext,B)
          <=> v2190(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_47,axiom,
    ! [VarCurr] :
      ( ~ v2193(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2190(VarCurr,B)
          <=> v712(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_48,axiom,
    ! [VarCurr] :
      ( v2193(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2190(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_203,axiom,
    ! [VarCurr] :
      ( v2193(VarCurr)
    <=> ( v51(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_332,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2184(VarNext)
      <=> v2185(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_331,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2185(VarNext)
      <=> ( v2186(VarNext)
          & v125(VarNext) ) ) ) ).

fof(writeUnaryOperator_146,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2186(VarNext)
      <=> v990(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges5_1,axiom,
    ! [VarCurr] :
      ( ( ~ v2151(VarCurr)
        & ~ v2155(VarCurr)
        & ~ v2160(VarCurr)
        & ~ v2164(VarCurr)
        & ~ v2181(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v712(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_3,axiom,
    ! [VarCurr] :
      ( v2181(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v712(VarCurr,B)
          <=> b001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_10,axiom,
    ! [VarCurr] :
      ( v2164(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v712(VarCurr,B)
          <=> v2165(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_21,axiom,
    ! [VarCurr] :
      ( v2160(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v712(VarCurr,B)
          <=> v2161(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_50,axiom,
    ! [VarCurr] :
      ( v2155(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v712(VarCurr,B)
          <=> v2156(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_50,axiom,
    ! [VarCurr] :
      ( v2151(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v712(VarCurr,B)
          <=> v2152(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_202,axiom,
    ! [VarCurr] :
      ( v2181(VarCurr)
    <=> ( ( v710(VarCurr,bitIndex2)
        <=> $true )
        & ( v710(VarCurr,bitIndex1)
        <=> $false )
        & ( v710(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_49,axiom,
    ! [VarCurr] :
      ( ~ v2166(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2165(VarCurr,B)
          <=> v2175(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_49,axiom,
    ! [VarCurr] :
      ( v2166(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2165(VarCurr,B)
          <=> v2167(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_48,axiom,
    ! [VarCurr] :
      ( ~ v2176(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2175(VarCurr,B)
          <=> v2178(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_48,axiom,
    ! [VarCurr] :
      ( v2176(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2175(VarCurr,B)
          <=> b001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_47,axiom,
    ! [VarCurr] :
      ( ~ v2179(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2178(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_47,axiom,
    ! [VarCurr] :
      ( v2179(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2178(VarCurr,B)
          <=> b001(B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_201,axiom,
    ! [VarCurr] :
      ( v2180(VarCurr)
    <=> ( v714(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_200,axiom,
    ! [VarCurr] :
      ( v2179(VarCurr)
    <=> ( v714(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_199,axiom,
    ! [VarCurr] :
      ( v2177(VarCurr)
    <=> ( v1125(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_198,axiom,
    ! [VarCurr] :
      ( v2176(VarCurr)
    <=> ( v1125(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_197,axiom,
    ! [VarCurr] :
      ( v2174(VarCurr)
    <=> ( v706(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_20,axiom,
    ! [VarCurr] :
      ( ( ~ v2168(VarCurr)
        & ~ v2171(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v2167(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_46,axiom,
    ! [VarCurr] :
      ( v2171(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2167(VarCurr,B)
          <=> v2173(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_46,axiom,
    ! [VarCurr] :
      ( v2168(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2167(VarCurr,B)
          <=> v2170(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_46,axiom,
    ! [VarCurr] :
      ( ~ v2110(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2173(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_47,axiom,
    ! [VarCurr] :
      ( v2110(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2173(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_196,axiom,
    ! [VarCurr] :
      ( v2171(VarCurr)
    <=> ( ( v2172(VarCurr,bitIndex1)
        <=> $true )
        & ( v2172(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_521,axiom,
    ! [VarCurr] :
      ( v2172(VarCurr,bitIndex0)
    <=> v1008(VarCurr) ) ).

fof(addAssignment_520,axiom,
    ! [VarCurr] :
      ( v2172(VarCurr,bitIndex1)
    <=> v981(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_45,axiom,
    ! [VarCurr] :
      ( ~ v2006(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2170(VarCurr,B)
          <=> b100(B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_46,axiom,
    ! [VarCurr] :
      ( v2006(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2170(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_195,axiom,
    ! [VarCurr] :
      ( v2168(VarCurr)
    <=> ( ( v2169(VarCurr,bitIndex1)
        <=> $false )
        & ( v2169(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_519,axiom,
    ! [VarCurr] :
      ( v2169(VarCurr,bitIndex0)
    <=> v1008(VarCurr) ) ).

fof(addAssignment_518,axiom,
    ! [VarCurr] :
      ( v2169(VarCurr,bitIndex1)
    <=> v981(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_194,axiom,
    ! [VarCurr] :
      ( v2166(VarCurr)
    <=> ( v706(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_193,axiom,
    ! [VarCurr] :
      ( v2164(VarCurr)
    <=> ( ( v710(VarCurr,bitIndex2)
        <=> $false )
        & ( v710(VarCurr,bitIndex1)
        <=> $true )
        & ( v710(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_45,axiom,
    ! [VarCurr] :
      ( ~ v2162(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2161(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_45,axiom,
    ! [VarCurr] :
      ( v2162(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2161(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_192,axiom,
    ! [VarCurr] :
      ( v2163(VarCurr)
    <=> ( v495(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_191,axiom,
    ! [VarCurr] :
      ( v2162(VarCurr)
    <=> ( v495(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_190,axiom,
    ! [VarCurr] :
      ( v2160(VarCurr)
    <=> ( ( v710(VarCurr,bitIndex2)
        <=> $false )
        & ( v710(VarCurr,bitIndex1)
        <=> $true )
        & ( v710(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_44,axiom,
    ! [VarCurr] :
      ( ~ v2157(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2156(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_44,axiom,
    ! [VarCurr] :
      ( v2157(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2156(VarCurr,B)
          <=> v2158(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_189,axiom,
    ! [VarCurr] :
      ( v2159(VarCurr)
    <=> ( v706(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_44,axiom,
    ! [VarCurr] :
      ( ~ v1818(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2158(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_45,axiom,
    ! [VarCurr] :
      ( v1818(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2158(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_188,axiom,
    ! [VarCurr] :
      ( v2157(VarCurr)
    <=> ( v706(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_187,axiom,
    ! [VarCurr] :
      ( v2155(VarCurr)
    <=> ( ( v710(VarCurr,bitIndex2)
        <=> $false )
        & ( v710(VarCurr,bitIndex1)
        <=> $false )
        & ( v710(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_43,axiom,
    ! [VarCurr] :
      ( ~ v2153(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2152(VarCurr,B)
          <=> b001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_43,axiom,
    ! [VarCurr] :
      ( v2153(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v2152(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_186,axiom,
    ! [VarCurr] :
      ( v2154(VarCurr)
    <=> ( v714(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_185,axiom,
    ! [VarCurr] :
      ( v2153(VarCurr)
    <=> ( v714(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_184,axiom,
    ! [VarCurr] :
      ( v2151(VarCurr)
    <=> ( ( v710(VarCurr,bitIndex2)
        <=> $false )
        & ( v710(VarCurr,bitIndex1)
        <=> $false )
        & ( v710(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_19,axiom,
    ! [VarCurr] :
      ( ( ~ v2149(VarCurr)
        & ~ v2133(VarCurr) )
     => ( v2110(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_42,axiom,
    ! [VarCurr] :
      ( v2133(VarCurr)
     => ( v2110(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_42,axiom,
    ! [VarCurr] :
      ( v2149(VarCurr)
     => ( v2110(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_330,axiom,
    ! [VarCurr] :
      ( v2149(VarCurr)
    <=> ( v2125(VarCurr)
        | v2129(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_23,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2136(VarNext)
       => ! [B] :
            ( range_1_0(B)
           => ( v2112(VarNext,B)
            <=> v2112(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_23,axiom,
    ! [VarNext] :
      ( v2136(VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v2112(VarNext,B)
          <=> v2144(VarNext,B) ) ) ) ).

fof(addAssignment_517,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v2144(VarNext,B)
          <=> v2142(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_43,axiom,
    ! [VarCurr] :
      ( ~ v2145(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v2142(VarCurr,B)
          <=> v2114(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_44,axiom,
    ! [VarCurr] :
      ( v2145(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v2142(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_183,axiom,
    ! [VarCurr] :
      ( v2145(VarCurr)
    <=> ( v51(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_329,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2136(VarNext)
      <=> v2137(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_328,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2137(VarNext)
      <=> ( v2138(VarNext)
          & v125(VarNext) ) ) ) ).

fof(writeUnaryOperator_145,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2138(VarNext)
      <=> v990(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_9,axiom,
    ! [VarCurr] :
      ( ( ~ v2125(VarCurr)
        & ~ v2129(VarCurr)
        & ~ v2133(VarCurr) )
     => ! [B] :
          ( range_1_0(B)
         => ( v2114(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_18,axiom,
    ! [VarCurr] :
      ( v2133(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v2114(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_41,axiom,
    ! [VarCurr] :
      ( v2129(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v2114(VarCurr,B)
          <=> v2130(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_41,axiom,
    ! [VarCurr] :
      ( v2125(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v2114(VarCurr,B)
          <=> v2126(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_182,axiom,
    ! [VarCurr] :
      ( v2133(VarCurr)
    <=> ( ( v2112(VarCurr,bitIndex1)
        <=> $true )
        & ( v2112(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_40,axiom,
    ! [VarCurr] :
      ( ~ v2131(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v2130(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_40,axiom,
    ! [VarCurr] :
      ( v2131(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v2130(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_181,axiom,
    ! [VarCurr] :
      ( v2132(VarCurr)
    <=> ( v1854(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_180,axiom,
    ! [VarCurr] :
      ( v2131(VarCurr)
    <=> ( v1854(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_179,axiom,
    ! [VarCurr] :
      ( v2129(VarCurr)
    <=> ( ( v2112(VarCurr,bitIndex1)
        <=> $false )
        & ( v2112(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_39,axiom,
    ! [VarCurr] :
      ( ~ v2127(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v2126(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_39,axiom,
    ! [VarCurr] :
      ( v2127(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v2126(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_178,axiom,
    ! [VarCurr] :
      ( v2128(VarCurr)
    <=> ( v2116(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_177,axiom,
    ! [VarCurr] :
      ( v2127(VarCurr)
    <=> ( v2116(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_176,axiom,
    ! [VarCurr] :
      ( v2125(VarCurr)
    <=> ( ( v2112(VarCurr,bitIndex1)
        <=> $false )
        & ( v2112(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignmentInitValueVector_36,axiom,
    ! [B] :
      ( range_1_0(B)
     => ( v2112(constB0,B)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_8,axiom,
    ! [VarCurr] :
      ( ( ~ v2118(VarCurr)
        & ~ v1166(VarCurr)
        & ~ v1176(VarCurr) )
     => ( v2116(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_17,axiom,
    ! [VarCurr] :
      ( v1176(VarCurr)
     => ( v2116(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_38,axiom,
    ! [VarCurr] :
      ( v1166(VarCurr)
     => ( v2116(VarCurr)
      <=> v2119(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_38,axiom,
    ! [VarCurr] :
      ( v2118(VarCurr)
     => ( v2116(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_37,axiom,
    ! [VarCurr] :
      ( ~ v1168(VarCurr)
     => ( v2119(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_37,axiom,
    ! [VarCurr] :
      ( v1168(VarCurr)
     => ( v2119(VarCurr)
      <=> v2120(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_16,axiom,
    ! [VarCurr] :
      ( ( ~ v1772(VarCurr)
        & ~ v1774(VarCurr) )
     => ( v2120(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_36,axiom,
    ! [VarCurr] :
      ( v1774(VarCurr)
     => ( v2120(VarCurr)
      <=> v2121(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_36,axiom,
    ! [VarCurr] :
      ( v1772(VarCurr)
     => ( v2120(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_35,axiom,
    ! [VarCurr] :
      ( ~ v2122(VarCurr)
     => ( v2121(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_35,axiom,
    ! [VarCurr] :
      ( v2122(VarCurr)
     => ( v2121(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_175,axiom,
    ! [VarCurr] :
      ( v2123(VarCurr)
    <=> ( v1125(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_174,axiom,
    ! [VarCurr] :
      ( v2122(VarCurr)
    <=> ( v1125(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_327,axiom,
    ! [VarCurr] :
      ( v2118(VarCurr)
    <=> ( v1796(VarCurr)
        | v1165(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_22,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2009(VarNext)
       => ( v2006(VarNext)
        <=> v2006(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_22,axiom,
    ! [VarNext] :
      ( v2009(VarNext)
     => ( v2006(VarNext)
      <=> v2017(VarNext) ) ) ).

fof(addAssignment_516,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2017(VarNext)
      <=> v2015(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_42,axiom,
    ! [VarCurr] :
      ( ~ v1156(VarCurr)
     => ( v2015(VarCurr)
      <=> v2018(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_43,axiom,
    ! [VarCurr] :
      ( v1156(VarCurr)
     => ( v2015(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_41,axiom,
    ! [VarCurr] :
      ( ~ v2019(VarCurr)
     => ( v2018(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_42,axiom,
    ! [VarCurr] :
      ( v2019(VarCurr)
     => ( v2018(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_173,axiom,
    ! [VarCurr] :
      ( v2019(VarCurr)
    <=> ( ( v2020(VarCurr,bitIndex5)
        <=> $false )
        & ( v2020(VarCurr,bitIndex4)
        <=> $false )
        & ( v2020(VarCurr,bitIndex3)
        <=> $false )
        & ( v2020(VarCurr,bitIndex2)
        <=> $false )
        & ( v2020(VarCurr,bitIndex1)
        <=> $false )
        & ( v2020(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_515,axiom,
    ! [VarCurr] :
      ( v2020(VarCurr,bitIndex0)
    <=> v2104(VarCurr) ) ).

fof(addAssignment_514,axiom,
    ! [VarCurr] :
      ( v2020(VarCurr,bitIndex1)
    <=> v2099(VarCurr) ) ).

fof(addAssignment_513,axiom,
    ! [VarCurr] :
      ( v2020(VarCurr,bitIndex2)
    <=> v2094(VarCurr) ) ).

fof(addAssignment_512,axiom,
    ! [VarCurr] :
      ( v2020(VarCurr,bitIndex3)
    <=> v2089(VarCurr) ) ).

fof(addAssignment_511,axiom,
    ! [VarCurr] :
      ( v2020(VarCurr,bitIndex4)
    <=> v2084(VarCurr) ) ).

fof(addAssignment_510,axiom,
    ! [VarCurr] :
      ( v2020(VarCurr,bitIndex5)
    <=> v2022(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_326,axiom,
    ! [VarCurr] :
      ( v2104(VarCurr)
    <=> ( v2105(VarCurr)
        & v2106(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_36,axiom,
    ! [VarCurr] :
      ( v2106(VarCurr)
    <=> ( v1820(VarCurr,bitIndex38)
        | v1012(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_325,axiom,
    ! [VarCurr] :
      ( v2105(VarCurr)
    <=> ( v2001(VarCurr)
        | v2040(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_324,axiom,
    ! [VarCurr] :
      ( v2099(VarCurr)
    <=> ( v2100(VarCurr)
        & v2103(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_323,axiom,
    ! [VarCurr] :
      ( v2103(VarCurr)
    <=> ( v2033(VarCurr)
        | v2034(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_322,axiom,
    ! [VarCurr] :
      ( v2100(VarCurr)
    <=> ( v2101(VarCurr)
        | v2102(VarCurr) ) ) ).

fof(writeUnaryOperator_144,axiom,
    ! [VarCurr] :
      ( ~ v2102(VarCurr)
    <=> v2034(VarCurr) ) ).

fof(writeUnaryOperator_143,axiom,
    ! [VarCurr] :
      ( ~ v2101(VarCurr)
    <=> v2033(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_321,axiom,
    ! [VarCurr] :
      ( v2094(VarCurr)
    <=> ( v2095(VarCurr)
        & v2098(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_320,axiom,
    ! [VarCurr] :
      ( v2098(VarCurr)
    <=> ( v2031(VarCurr)
        | v2044(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_319,axiom,
    ! [VarCurr] :
      ( v2095(VarCurr)
    <=> ( v2096(VarCurr)
        | v2097(VarCurr) ) ) ).

fof(writeUnaryOperator_142,axiom,
    ! [VarCurr] :
      ( ~ v2097(VarCurr)
    <=> v2044(VarCurr) ) ).

fof(writeUnaryOperator_141,axiom,
    ! [VarCurr] :
      ( ~ v2096(VarCurr)
    <=> v2031(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_318,axiom,
    ! [VarCurr] :
      ( v2089(VarCurr)
    <=> ( v2090(VarCurr)
        & v2093(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_317,axiom,
    ! [VarCurr] :
      ( v2093(VarCurr)
    <=> ( v2029(VarCurr)
        | v2055(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_316,axiom,
    ! [VarCurr] :
      ( v2090(VarCurr)
    <=> ( v2091(VarCurr)
        | v2092(VarCurr) ) ) ).

fof(writeUnaryOperator_140,axiom,
    ! [VarCurr] :
      ( ~ v2092(VarCurr)
    <=> v2055(VarCurr) ) ).

fof(writeUnaryOperator_139,axiom,
    ! [VarCurr] :
      ( ~ v2091(VarCurr)
    <=> v2029(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_315,axiom,
    ! [VarCurr] :
      ( v2084(VarCurr)
    <=> ( v2085(VarCurr)
        & v2088(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_314,axiom,
    ! [VarCurr] :
      ( v2088(VarCurr)
    <=> ( v2027(VarCurr)
        | v2066(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_313,axiom,
    ! [VarCurr] :
      ( v2085(VarCurr)
    <=> ( v2086(VarCurr)
        | v2087(VarCurr) ) ) ).

fof(writeUnaryOperator_138,axiom,
    ! [VarCurr] :
      ( ~ v2087(VarCurr)
    <=> v2066(VarCurr) ) ).

fof(writeUnaryOperator_137,axiom,
    ! [VarCurr] :
      ( ~ v2086(VarCurr)
    <=> v2027(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_312,axiom,
    ! [VarCurr] :
      ( v2022(VarCurr)
    <=> ( v2023(VarCurr)
        & v2083(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_311,axiom,
    ! [VarCurr] :
      ( v2083(VarCurr)
    <=> ( v2025(VarCurr)
        | v2078(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_310,axiom,
    ! [VarCurr] :
      ( v2023(VarCurr)
    <=> ( v2024(VarCurr)
        | v2077(VarCurr) ) ) ).

fof(writeUnaryOperator_136,axiom,
    ! [VarCurr] :
      ( ~ v2077(VarCurr)
    <=> v2078(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_309,axiom,
    ! [VarCurr] :
      ( v2078(VarCurr)
    <=> ( v2079(VarCurr)
        & v2081(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_35,axiom,
    ! [VarCurr] :
      ( v2081(VarCurr)
    <=> ( v1820(VarCurr,bitIndex43)
        | v2082(VarCurr) ) ) ).

fof(writeUnaryOperator_135,axiom,
    ! [VarCurr] :
      ( ~ v2082(VarCurr)
    <=> v2080(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_308,axiom,
    ! [VarCurr] :
      ( v2079(VarCurr)
    <=> ( v1975(VarCurr)
        | v2080(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_307,axiom,
    ! [VarCurr] :
      ( v2080(VarCurr)
    <=> ( v2072(VarCurr)
        & v2074(VarCurr) ) ) ).

fof(writeUnaryOperator_134,axiom,
    ! [VarCurr] :
      ( ~ v2024(VarCurr)
    <=> v2025(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_306,axiom,
    ! [VarCurr] :
      ( v2025(VarCurr)
    <=> ( v2026(VarCurr)
        | v2076(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_34,axiom,
    ! [VarCurr] :
      ( v2076(VarCurr)
    <=> ( v1820(VarCurr,bitIndex42)
        & v2069(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_305,axiom,
    ! [VarCurr] :
      ( v2026(VarCurr)
    <=> ( v2027(VarCurr)
        & v2066(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_304,axiom,
    ! [VarCurr] :
      ( v2066(VarCurr)
    <=> ( v2067(VarCurr)
        & v2075(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_33,axiom,
    ! [VarCurr] :
      ( v2075(VarCurr)
    <=> ( v1820(VarCurr,bitIndex42)
        | v2069(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_303,axiom,
    ! [VarCurr] :
      ( v2067(VarCurr)
    <=> ( v1968(VarCurr)
        | v2068(VarCurr) ) ) ).

fof(writeUnaryOperator_133,axiom,
    ! [VarCurr] :
      ( ~ v2068(VarCurr)
    <=> v2069(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_302,axiom,
    ! [VarCurr] :
      ( v2069(VarCurr)
    <=> ( v2070(VarCurr)
        & v2073(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_301,axiom,
    ! [VarCurr] :
      ( v2073(VarCurr)
    <=> ( v2072(VarCurr)
        | v2074(VarCurr) ) ) ).

fof(writeUnaryOperator_132,axiom,
    ! [VarCurr] :
      ( ~ v2074(VarCurr)
    <=> v1012(VarCurr,bitIndex4) ) ).

fof(writeBinaryOperatorShiftedRanges_32,axiom,
    ! [VarCurr] :
      ( v2070(VarCurr)
    <=> ( v2071(VarCurr)
        | v1012(VarCurr,bitIndex4) ) ) ).

fof(writeUnaryOperator_131,axiom,
    ! [VarCurr] :
      ( ~ v2071(VarCurr)
    <=> v2072(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_300,axiom,
    ! [VarCurr] :
      ( v2072(VarCurr)
    <=> ( v2061(VarCurr)
        & v2063(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_299,axiom,
    ! [VarCurr] :
      ( v2027(VarCurr)
    <=> ( v2028(VarCurr)
        | v2065(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_31,axiom,
    ! [VarCurr] :
      ( v2065(VarCurr)
    <=> ( v1820(VarCurr,bitIndex41)
        & v2058(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_298,axiom,
    ! [VarCurr] :
      ( v2028(VarCurr)
    <=> ( v2029(VarCurr)
        & v2055(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_297,axiom,
    ! [VarCurr] :
      ( v2055(VarCurr)
    <=> ( v2056(VarCurr)
        & v2064(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_30,axiom,
    ! [VarCurr] :
      ( v2064(VarCurr)
    <=> ( v1820(VarCurr,bitIndex41)
        | v2058(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_296,axiom,
    ! [VarCurr] :
      ( v2056(VarCurr)
    <=> ( v1956(VarCurr)
        | v2057(VarCurr) ) ) ).

fof(writeUnaryOperator_130,axiom,
    ! [VarCurr] :
      ( ~ v2057(VarCurr)
    <=> v2058(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_295,axiom,
    ! [VarCurr] :
      ( v2058(VarCurr)
    <=> ( v2059(VarCurr)
        & v2062(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_294,axiom,
    ! [VarCurr] :
      ( v2062(VarCurr)
    <=> ( v2061(VarCurr)
        | v2063(VarCurr) ) ) ).

fof(writeUnaryOperator_129,axiom,
    ! [VarCurr] :
      ( ~ v2063(VarCurr)
    <=> v1012(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorShiftedRanges_29,axiom,
    ! [VarCurr] :
      ( v2059(VarCurr)
    <=> ( v2060(VarCurr)
        | v1012(VarCurr,bitIndex3) ) ) ).

fof(writeUnaryOperator_128,axiom,
    ! [VarCurr] :
      ( ~ v2060(VarCurr)
    <=> v2061(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_293,axiom,
    ! [VarCurr] :
      ( v2061(VarCurr)
    <=> ( v2050(VarCurr)
        & v2052(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_292,axiom,
    ! [VarCurr] :
      ( v2029(VarCurr)
    <=> ( v2030(VarCurr)
        | v2054(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_28,axiom,
    ! [VarCurr] :
      ( v2054(VarCurr)
    <=> ( v1820(VarCurr,bitIndex40)
        & v2047(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_291,axiom,
    ! [VarCurr] :
      ( v2030(VarCurr)
    <=> ( v2031(VarCurr)
        & v2044(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_290,axiom,
    ! [VarCurr] :
      ( v2044(VarCurr)
    <=> ( v2045(VarCurr)
        & v2053(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_27,axiom,
    ! [VarCurr] :
      ( v2053(VarCurr)
    <=> ( v1820(VarCurr,bitIndex40)
        | v2047(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_289,axiom,
    ! [VarCurr] :
      ( v2045(VarCurr)
    <=> ( v1944(VarCurr)
        | v2046(VarCurr) ) ) ).

fof(writeUnaryOperator_127,axiom,
    ! [VarCurr] :
      ( ~ v2046(VarCurr)
    <=> v2047(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_288,axiom,
    ! [VarCurr] :
      ( v2047(VarCurr)
    <=> ( v2048(VarCurr)
        & v2051(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_287,axiom,
    ! [VarCurr] :
      ( v2051(VarCurr)
    <=> ( v2050(VarCurr)
        | v2052(VarCurr) ) ) ).

fof(writeUnaryOperator_126,axiom,
    ! [VarCurr] :
      ( ~ v2052(VarCurr)
    <=> v1012(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges_26,axiom,
    ! [VarCurr] :
      ( v2048(VarCurr)
    <=> ( v2049(VarCurr)
        | v1012(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_125,axiom,
    ! [VarCurr] :
      ( ~ v2049(VarCurr)
    <=> v2050(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_286,axiom,
    ! [VarCurr] :
      ( v2050(VarCurr)
    <=> ( v2040(VarCurr)
        & v2041(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_285,axiom,
    ! [VarCurr] :
      ( v2031(VarCurr)
    <=> ( v2032(VarCurr)
        | v2043(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_25,axiom,
    ! [VarCurr] :
      ( v2043(VarCurr)
    <=> ( v1820(VarCurr,bitIndex39)
        & v2037(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_284,axiom,
    ! [VarCurr] :
      ( v2032(VarCurr)
    <=> ( v2033(VarCurr)
        & v2034(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_283,axiom,
    ! [VarCurr] :
      ( v2034(VarCurr)
    <=> ( v2035(VarCurr)
        & v2042(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_24,axiom,
    ! [VarCurr] :
      ( v2042(VarCurr)
    <=> ( v1820(VarCurr,bitIndex39)
        | v2037(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_282,axiom,
    ! [VarCurr] :
      ( v2035(VarCurr)
    <=> ( v1932(VarCurr)
        | v2036(VarCurr) ) ) ).

fof(writeUnaryOperator_124,axiom,
    ! [VarCurr] :
      ( ~ v2036(VarCurr)
    <=> v2037(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_281,axiom,
    ! [VarCurr] :
      ( v2037(VarCurr)
    <=> ( v2038(VarCurr)
        & v2039(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_280,axiom,
    ! [VarCurr] :
      ( v2039(VarCurr)
    <=> ( v2040(VarCurr)
        | v2041(VarCurr) ) ) ).

fof(writeUnaryOperator_123,axiom,
    ! [VarCurr] :
      ( ~ v2041(VarCurr)
    <=> v1012(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_122,axiom,
    ! [VarCurr] :
      ( ~ v2040(VarCurr)
    <=> v1012(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorShiftedRanges_23,axiom,
    ! [VarCurr] :
      ( v2038(VarCurr)
    <=> ( v1012(VarCurr,bitIndex0)
        | v1012(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_22,axiom,
    ! [VarCurr] :
      ( v2033(VarCurr)
    <=> ( v1820(VarCurr,bitIndex38)
        & v1012(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_279,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2009(VarNext)
      <=> v2010(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_278,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v2010(VarNext)
      <=> ( v2012(VarNext)
          & v125(VarNext) ) ) ) ).

fof(writeUnaryOperator_121,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v2012(VarNext)
      <=> v990(VarNext) ) ) ).

fof(addAssignmentInitValueVector_35,axiom,
    ( v2006(constB0)
  <=> $false ) ).

fof(addCaseBooleanConditionEqualRanges1_21,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1890(VarNext)
       => ( v1818(VarNext)
        <=> v1818(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_21,axiom,
    ! [VarNext] :
      ( v1890(VarNext)
     => ( v1818(VarNext)
      <=> v1906(VarNext) ) ) ).

fof(addAssignment_509,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1906(VarNext)
      <=> v1904(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_40,axiom,
    ! [VarCurr] :
      ( ~ v1903(VarCurr)
     => ( v1904(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_41,axiom,
    ! [VarCurr] :
      ( v1903(VarCurr)
     => ( v1904(VarCurr)
      <=> v1907(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_172,axiom,
    ! [VarCurr] :
      ( v1907(VarCurr)
    <=> ( ( v1908(VarCurr,bitIndex5)
        <=> $false )
        & ( v1908(VarCurr,bitIndex4)
        <=> $false )
        & ( v1908(VarCurr,bitIndex3)
        <=> $false )
        & ( v1908(VarCurr,bitIndex2)
        <=> $false )
        & ( v1908(VarCurr,bitIndex1)
        <=> $false )
        & ( v1908(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_621,axiom,
    ~ b000001(bitIndex5) ).

fof(bitBlastConstant_620,axiom,
    ~ b000001(bitIndex4) ).

fof(bitBlastConstant_619,axiom,
    ~ b000001(bitIndex3) ).

fof(bitBlastConstant_618,axiom,
    ~ b000001(bitIndex2) ).

fof(bitBlastConstant_617,axiom,
    ~ b000001(bitIndex1) ).

fof(bitBlastConstant_616,axiom,
    b000001(bitIndex0) ).

fof(addAssignment_508,axiom,
    ! [VarCurr] :
      ( v1908(VarCurr,bitIndex0)
    <=> v1999(VarCurr) ) ).

fof(addAssignment_507,axiom,
    ! [VarCurr] :
      ( v1908(VarCurr,bitIndex1)
    <=> v1994(VarCurr) ) ).

fof(addAssignment_506,axiom,
    ! [VarCurr] :
      ( v1908(VarCurr,bitIndex2)
    <=> v1989(VarCurr) ) ).

fof(addAssignment_505,axiom,
    ! [VarCurr] :
      ( v1908(VarCurr,bitIndex3)
    <=> v1984(VarCurr) ) ).

fof(addAssignment_504,axiom,
    ! [VarCurr] :
      ( v1908(VarCurr,bitIndex4)
    <=> v1979(VarCurr) ) ).

fof(addAssignment_503,axiom,
    ! [VarCurr] :
      ( v1908(VarCurr,bitIndex5)
    <=> v1910(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_277,axiom,
    ! [VarCurr] :
      ( v1999(VarCurr)
    <=> ( v2000(VarCurr)
        & v2002(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_21,axiom,
    ! [VarCurr] :
      ( v2002(VarCurr)
    <=> ( v1822(VarCurr,bitIndex0)
        | v1820(VarCurr,bitIndex38) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_276,axiom,
    ! [VarCurr] :
      ( v2000(VarCurr)
    <=> ( v1930(VarCurr)
        | v2001(VarCurr) ) ) ).

fof(writeUnaryOperator_120,axiom,
    ! [VarCurr] :
      ( ~ v2001(VarCurr)
    <=> v1820(VarCurr,bitIndex38) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_275,axiom,
    ! [VarCurr] :
      ( v1994(VarCurr)
    <=> ( v1995(VarCurr)
        & v1998(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_274,axiom,
    ! [VarCurr] :
      ( v1998(VarCurr)
    <=> ( v1921(VarCurr)
        | v1924(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_273,axiom,
    ! [VarCurr] :
      ( v1995(VarCurr)
    <=> ( v1996(VarCurr)
        | v1997(VarCurr) ) ) ).

fof(writeUnaryOperator_119,axiom,
    ! [VarCurr] :
      ( ~ v1997(VarCurr)
    <=> v1924(VarCurr) ) ).

fof(writeUnaryOperator_118,axiom,
    ! [VarCurr] :
      ( ~ v1996(VarCurr)
    <=> v1921(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_272,axiom,
    ! [VarCurr] :
      ( v1989(VarCurr)
    <=> ( v1990(VarCurr)
        & v1993(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_271,axiom,
    ! [VarCurr] :
      ( v1993(VarCurr)
    <=> ( v1919(VarCurr)
        | v1935(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_270,axiom,
    ! [VarCurr] :
      ( v1990(VarCurr)
    <=> ( v1991(VarCurr)
        | v1992(VarCurr) ) ) ).

fof(writeUnaryOperator_117,axiom,
    ! [VarCurr] :
      ( ~ v1992(VarCurr)
    <=> v1935(VarCurr) ) ).

fof(writeUnaryOperator_116,axiom,
    ! [VarCurr] :
      ( ~ v1991(VarCurr)
    <=> v1919(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_269,axiom,
    ! [VarCurr] :
      ( v1984(VarCurr)
    <=> ( v1985(VarCurr)
        & v1988(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_268,axiom,
    ! [VarCurr] :
      ( v1988(VarCurr)
    <=> ( v1917(VarCurr)
        | v1947(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_267,axiom,
    ! [VarCurr] :
      ( v1985(VarCurr)
    <=> ( v1986(VarCurr)
        | v1987(VarCurr) ) ) ).

fof(writeUnaryOperator_115,axiom,
    ! [VarCurr] :
      ( ~ v1987(VarCurr)
    <=> v1947(VarCurr) ) ).

fof(writeUnaryOperator_114,axiom,
    ! [VarCurr] :
      ( ~ v1986(VarCurr)
    <=> v1917(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_266,axiom,
    ! [VarCurr] :
      ( v1979(VarCurr)
    <=> ( v1980(VarCurr)
        & v1983(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_265,axiom,
    ! [VarCurr] :
      ( v1983(VarCurr)
    <=> ( v1915(VarCurr)
        | v1959(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_264,axiom,
    ! [VarCurr] :
      ( v1980(VarCurr)
    <=> ( v1981(VarCurr)
        | v1982(VarCurr) ) ) ).

fof(writeUnaryOperator_113,axiom,
    ! [VarCurr] :
      ( ~ v1982(VarCurr)
    <=> v1959(VarCurr) ) ).

fof(writeUnaryOperator_112,axiom,
    ! [VarCurr] :
      ( ~ v1981(VarCurr)
    <=> v1915(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_263,axiom,
    ! [VarCurr] :
      ( v1910(VarCurr)
    <=> ( v1911(VarCurr)
        & v1978(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_262,axiom,
    ! [VarCurr] :
      ( v1978(VarCurr)
    <=> ( v1913(VarCurr)
        | v1972(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_261,axiom,
    ! [VarCurr] :
      ( v1911(VarCurr)
    <=> ( v1912(VarCurr)
        | v1971(VarCurr) ) ) ).

fof(writeUnaryOperator_111,axiom,
    ! [VarCurr] :
      ( ~ v1971(VarCurr)
    <=> v1972(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_260,axiom,
    ! [VarCurr] :
      ( v1972(VarCurr)
    <=> ( v1973(VarCurr)
        & v1976(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_20,axiom,
    ! [VarCurr] :
      ( v1976(VarCurr)
    <=> ( v1977(VarCurr)
        | v1820(VarCurr,bitIndex43) ) ) ).

fof(writeUnaryOperator_110,axiom,
    ! [VarCurr] :
      ( ~ v1977(VarCurr)
    <=> v1974(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_259,axiom,
    ! [VarCurr] :
      ( v1973(VarCurr)
    <=> ( v1974(VarCurr)
        | v1975(VarCurr) ) ) ).

fof(writeUnaryOperator_109,axiom,
    ! [VarCurr] :
      ( ~ v1975(VarCurr)
    <=> v1820(VarCurr,bitIndex43) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_258,axiom,
    ! [VarCurr] :
      ( v1974(VarCurr)
    <=> ( v1965(VarCurr)
        & v1967(VarCurr) ) ) ).

fof(writeUnaryOperator_108,axiom,
    ! [VarCurr] :
      ( ~ v1912(VarCurr)
    <=> v1913(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_257,axiom,
    ! [VarCurr] :
      ( v1913(VarCurr)
    <=> ( v1914(VarCurr)
        | v1970(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_19,axiom,
    ! [VarCurr] :
      ( v1970(VarCurr)
    <=> ( v1962(VarCurr)
        & v1820(VarCurr,bitIndex42) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_256,axiom,
    ! [VarCurr] :
      ( v1914(VarCurr)
    <=> ( v1915(VarCurr)
        & v1959(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_255,axiom,
    ! [VarCurr] :
      ( v1959(VarCurr)
    <=> ( v1960(VarCurr)
        & v1969(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_18,axiom,
    ! [VarCurr] :
      ( v1969(VarCurr)
    <=> ( v1962(VarCurr)
        | v1820(VarCurr,bitIndex42) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_254,axiom,
    ! [VarCurr] :
      ( v1960(VarCurr)
    <=> ( v1961(VarCurr)
        | v1968(VarCurr) ) ) ).

fof(writeUnaryOperator_107,axiom,
    ! [VarCurr] :
      ( ~ v1968(VarCurr)
    <=> v1820(VarCurr,bitIndex42) ) ).

fof(writeUnaryOperator_106,axiom,
    ! [VarCurr] :
      ( ~ v1961(VarCurr)
    <=> v1962(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_253,axiom,
    ! [VarCurr] :
      ( v1962(VarCurr)
    <=> ( v1963(VarCurr)
        & v1966(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_252,axiom,
    ! [VarCurr] :
      ( v1966(VarCurr)
    <=> ( v1965(VarCurr)
        | v1967(VarCurr) ) ) ).

fof(writeUnaryOperator_105,axiom,
    ! [VarCurr] :
      ( ~ v1967(VarCurr)
    <=> v1822(VarCurr,bitIndex4) ) ).

fof(writeBinaryOperatorShiftedRanges_17,axiom,
    ! [VarCurr] :
      ( v1963(VarCurr)
    <=> ( v1964(VarCurr)
        | v1822(VarCurr,bitIndex4) ) ) ).

fof(writeUnaryOperator_104,axiom,
    ! [VarCurr] :
      ( ~ v1964(VarCurr)
    <=> v1965(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_251,axiom,
    ! [VarCurr] :
      ( v1965(VarCurr)
    <=> ( v1953(VarCurr)
        & v1955(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_250,axiom,
    ! [VarCurr] :
      ( v1915(VarCurr)
    <=> ( v1916(VarCurr)
        | v1958(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_16,axiom,
    ! [VarCurr] :
      ( v1958(VarCurr)
    <=> ( v1950(VarCurr)
        & v1820(VarCurr,bitIndex41) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_249,axiom,
    ! [VarCurr] :
      ( v1916(VarCurr)
    <=> ( v1917(VarCurr)
        & v1947(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_248,axiom,
    ! [VarCurr] :
      ( v1947(VarCurr)
    <=> ( v1948(VarCurr)
        & v1957(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_15,axiom,
    ! [VarCurr] :
      ( v1957(VarCurr)
    <=> ( v1950(VarCurr)
        | v1820(VarCurr,bitIndex41) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_247,axiom,
    ! [VarCurr] :
      ( v1948(VarCurr)
    <=> ( v1949(VarCurr)
        | v1956(VarCurr) ) ) ).

fof(writeUnaryOperator_103,axiom,
    ! [VarCurr] :
      ( ~ v1956(VarCurr)
    <=> v1820(VarCurr,bitIndex41) ) ).

fof(writeUnaryOperator_102,axiom,
    ! [VarCurr] :
      ( ~ v1949(VarCurr)
    <=> v1950(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_246,axiom,
    ! [VarCurr] :
      ( v1950(VarCurr)
    <=> ( v1951(VarCurr)
        & v1954(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_245,axiom,
    ! [VarCurr] :
      ( v1954(VarCurr)
    <=> ( v1953(VarCurr)
        | v1955(VarCurr) ) ) ).

fof(writeUnaryOperator_101,axiom,
    ! [VarCurr] :
      ( ~ v1955(VarCurr)
    <=> v1822(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorShiftedRanges_14,axiom,
    ! [VarCurr] :
      ( v1951(VarCurr)
    <=> ( v1952(VarCurr)
        | v1822(VarCurr,bitIndex3) ) ) ).

fof(writeUnaryOperator_100,axiom,
    ! [VarCurr] :
      ( ~ v1952(VarCurr)
    <=> v1953(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_244,axiom,
    ! [VarCurr] :
      ( v1953(VarCurr)
    <=> ( v1941(VarCurr)
        & v1943(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_243,axiom,
    ! [VarCurr] :
      ( v1917(VarCurr)
    <=> ( v1918(VarCurr)
        | v1946(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_13,axiom,
    ! [VarCurr] :
      ( v1946(VarCurr)
    <=> ( v1938(VarCurr)
        & v1820(VarCurr,bitIndex40) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_242,axiom,
    ! [VarCurr] :
      ( v1918(VarCurr)
    <=> ( v1919(VarCurr)
        & v1935(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_241,axiom,
    ! [VarCurr] :
      ( v1935(VarCurr)
    <=> ( v1936(VarCurr)
        & v1945(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_12,axiom,
    ! [VarCurr] :
      ( v1945(VarCurr)
    <=> ( v1938(VarCurr)
        | v1820(VarCurr,bitIndex40) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_240,axiom,
    ! [VarCurr] :
      ( v1936(VarCurr)
    <=> ( v1937(VarCurr)
        | v1944(VarCurr) ) ) ).

fof(writeUnaryOperator_99,axiom,
    ! [VarCurr] :
      ( ~ v1944(VarCurr)
    <=> v1820(VarCurr,bitIndex40) ) ).

fof(writeUnaryOperator_98,axiom,
    ! [VarCurr] :
      ( ~ v1937(VarCurr)
    <=> v1938(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_239,axiom,
    ! [VarCurr] :
      ( v1938(VarCurr)
    <=> ( v1939(VarCurr)
        & v1942(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_238,axiom,
    ! [VarCurr] :
      ( v1942(VarCurr)
    <=> ( v1941(VarCurr)
        | v1943(VarCurr) ) ) ).

fof(writeUnaryOperator_97,axiom,
    ! [VarCurr] :
      ( ~ v1943(VarCurr)
    <=> v1822(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges_11,axiom,
    ! [VarCurr] :
      ( v1939(VarCurr)
    <=> ( v1940(VarCurr)
        | v1822(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_96,axiom,
    ! [VarCurr] :
      ( ~ v1940(VarCurr)
    <=> v1941(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_237,axiom,
    ! [VarCurr] :
      ( v1941(VarCurr)
    <=> ( v1930(VarCurr)
        & v1931(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_236,axiom,
    ! [VarCurr] :
      ( v1919(VarCurr)
    <=> ( v1920(VarCurr)
        | v1934(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_10,axiom,
    ! [VarCurr] :
      ( v1934(VarCurr)
    <=> ( v1927(VarCurr)
        & v1820(VarCurr,bitIndex39) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_235,axiom,
    ! [VarCurr] :
      ( v1920(VarCurr)
    <=> ( v1921(VarCurr)
        & v1924(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_234,axiom,
    ! [VarCurr] :
      ( v1924(VarCurr)
    <=> ( v1925(VarCurr)
        & v1933(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_9,axiom,
    ! [VarCurr] :
      ( v1933(VarCurr)
    <=> ( v1927(VarCurr)
        | v1820(VarCurr,bitIndex39) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_233,axiom,
    ! [VarCurr] :
      ( v1925(VarCurr)
    <=> ( v1926(VarCurr)
        | v1932(VarCurr) ) ) ).

fof(writeUnaryOperator_95,axiom,
    ! [VarCurr] :
      ( ~ v1932(VarCurr)
    <=> v1820(VarCurr,bitIndex39) ) ).

fof(writeUnaryOperator_94,axiom,
    ! [VarCurr] :
      ( ~ v1926(VarCurr)
    <=> v1927(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_232,axiom,
    ! [VarCurr] :
      ( v1927(VarCurr)
    <=> ( v1928(VarCurr)
        & v1929(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_231,axiom,
    ! [VarCurr] :
      ( v1929(VarCurr)
    <=> ( v1930(VarCurr)
        | v1931(VarCurr) ) ) ).

fof(writeUnaryOperator_93,axiom,
    ! [VarCurr] :
      ( ~ v1931(VarCurr)
    <=> v1822(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_92,axiom,
    ! [VarCurr] :
      ( ~ v1930(VarCurr)
    <=> v1822(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorShiftedRanges_8,axiom,
    ! [VarCurr] :
      ( v1928(VarCurr)
    <=> ( v1822(VarCurr,bitIndex0)
        | v1822(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_7,axiom,
    ! [VarCurr] :
      ( v1921(VarCurr)
    <=> ( v1822(VarCurr,bitIndex0)
        & v1820(VarCurr,bitIndex38) ) ) ).

fof(addAssignmentInitValue_98,axiom,
    ~ v1820(constB0,bitIndex43) ).

fof(addAssignmentInitValue_97,axiom,
    ~ v1820(constB0,bitIndex42) ).

fof(addAssignmentInitValue_96,axiom,
    ~ v1820(constB0,bitIndex41) ).

fof(addAssignmentInitValue_95,axiom,
    ~ v1820(constB0,bitIndex40) ).

fof(addAssignmentInitValue_94,axiom,
    ~ v1820(constB0,bitIndex39) ).

fof(addAssignmentInitValue_93,axiom,
    ~ v1820(constB0,bitIndex38) ).

fof(bitBlastConstant_615,axiom,
    ~ b000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex43) ).

fof(bitBlastConstant_614,axiom,
    ~ b000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex42) ).

fof(bitBlastConstant_613,axiom,
    ~ b000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex41) ).

fof(bitBlastConstant_612,axiom,
    ~ b000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex40) ).

fof(bitBlastConstant_611,axiom,
    ~ b000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex39) ).

fof(bitBlastConstant_610,axiom,
    ~ b000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex38) ).

fof(writeBinaryOperatorEqualRangesSingleBits_230,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1890(VarNext)
      <=> ( v1891(VarNext)
          & v1898(VarNext) ) ) ) ).

fof(addAssignment_502,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1898(VarNext)
      <=> v1896(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_229,axiom,
    ! [VarCurr] :
      ( v1896(VarCurr)
    <=> ( v1899(VarCurr)
        & v1900(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_228,axiom,
    ! [VarCurr] :
      ( v1900(VarCurr)
    <=> ( v1901(VarCurr)
        | v1156(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_227,axiom,
    ! [VarCurr] :
      ( v1901(VarCurr)
    <=> ( v1882(VarCurr)
        | v1902(VarCurr) ) ) ).

fof(writeUnaryOperator_91,axiom,
    ! [VarCurr] :
      ( ~ v1902(VarCurr)
    <=> v1903(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_171,axiom,
    ! [VarCurr] :
      ( v1903(VarCurr)
    <=> ( v706(VarCurr)
      <=> $true ) ) ).

fof(writeUnaryOperator_90,axiom,
    ! [VarCurr] :
      ( ~ v1899(VarCurr)
    <=> v1156(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_226,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1891(VarNext)
      <=> ( v1893(VarNext)
          & v125(VarNext) ) ) ) ).

fof(writeUnaryOperator_89,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1893(VarNext)
      <=> v990(VarNext) ) ) ).

fof(addAssignmentInitValueVector_34,axiom,
    ( v1818(constB0)
  <=> $false ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_7,axiom,
    ! [VarCurr] :
      ( ( ~ v1884(VarCurr)
        & ~ v1166(VarCurr)
        & ~ v1176(VarCurr) )
     => ( v1882(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_15,axiom,
    ! [VarCurr] :
      ( v1176(VarCurr)
     => ( v1882(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_34,axiom,
    ! [VarCurr] :
      ( v1166(VarCurr)
     => ( v1882(VarCurr)
      <=> v1885(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_34,axiom,
    ! [VarCurr] :
      ( v1884(VarCurr)
     => ( v1882(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_33,axiom,
    ! [VarCurr] :
      ( ~ v1168(VarCurr)
     => ( v1885(VarCurr)
      <=> v1887(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_33,axiom,
    ! [VarCurr] :
      ( v1168(VarCurr)
     => ( v1885(VarCurr)
      <=> v1886(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_32,axiom,
    ! [VarCurr] :
      ( ~ v1171(VarCurr)
     => ( v1887(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_32,axiom,
    ! [VarCurr] :
      ( v1171(VarCurr)
     => ( v1887(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_14,axiom,
    ! [VarCurr] :
      ( ( ~ v1772(VarCurr)
        & ~ v1774(VarCurr) )
     => ( v1886(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_31,axiom,
    ! [VarCurr] :
      ( v1774(VarCurr)
     => ( v1886(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_31,axiom,
    ! [VarCurr] :
      ( v1772(VarCurr)
     => ( v1886(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_225,axiom,
    ! [VarCurr] :
      ( v1884(VarCurr)
    <=> ( v1796(VarCurr)
        | v1165(VarCurr) ) ) ).

fof(addAssignment_501,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v1822(VarCurr,B)
      <=> v1824(VarCurr,B) ) ) ).

fof(addAssignment_500,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v1824(VarCurr,B)
      <=> v1826(VarCurr,B) ) ) ).

fof(addAssignment_499,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v1826(VarCurr,B)
      <=> v1828(VarCurr,B) ) ) ).

fof(addAssignment_498,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v1828(VarCurr,B)
      <=> v1830(VarCurr,B) ) ) ).

fof(addAssignment_497,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v1830(VarCurr,B)
      <=> v1879(VarCurr,B) ) ) ).

fof(addAssignment_496,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v1834(VarCurr,B)
      <=> v1836(VarCurr,B) ) ) ).

fof(addAssignment_495,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v1836(VarCurr,B)
      <=> v1838(VarCurr,B) ) ) ).

fof(addAssignment_494,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v1838(VarCurr,B)
      <=> v1840(VarCurr,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_20,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1863(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v1840(VarNext,B)
            <=> v1840(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_20,axiom,
    ! [VarNext] :
      ( v1863(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v1840(VarNext,B)
          <=> v1875(VarNext,B) ) ) ) ).

fof(addAssignment_493,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v1875(VarNext,B)
          <=> v1873(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_39,axiom,
    ! [VarCurr] :
      ( ~ v1156(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1873(VarCurr,B)
          <=> v1876(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_40,axiom,
    ! [VarCurr] :
      ( v1156(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1873(VarCurr,B)
          <=> $false ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_38,axiom,
    ! [VarCurr] :
      ( ~ v1842(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1876(VarCurr,B)
          <=> v1844(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_39,axiom,
    ! [VarCurr] :
      ( v1842(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v1876(VarCurr,B)
          <=> v1127(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_224,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1863(VarNext)
      <=> ( v1864(VarNext)
          & v1871(VarNext) ) ) ) ).

fof(addAssignment_492,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1871(VarNext)
      <=> v1869(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_223,axiom,
    ! [VarCurr] :
      ( v1869(VarCurr)
    <=> ( v1872(VarCurr)
        | v1156(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_222,axiom,
    ! [VarCurr] :
      ( v1872(VarCurr)
    <=> ( v1854(VarCurr)
        | v1842(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_33,axiom,
    ( v1842(constB0)
  <=> $false ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_221,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1864(VarNext)
      <=> ( v1866(VarNext)
          & v125(VarNext) ) ) ) ).

fof(writeUnaryOperator_88,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1866(VarNext)
      <=> v990(VarNext) ) ) ).

fof(addAssignmentInitValueVector_32,axiom,
    ! [B] :
      ( range_3_0(B)
     => ( v1840(constB0,B)
      <=> $false ) ) ).

fof(addAssignment_491,axiom,
    ! [VarCurr] :
      ( v1854(VarCurr)
    <=> v1856(VarCurr) ) ).

fof(addAssignment_490,axiom,
    ! [VarCurr] :
      ( v1856(VarCurr)
    <=> v1858(VarCurr) ) ).

fof(addAssignment_489,axiom,
    ! [VarCurr] :
      ( v1858(VarCurr)
    <=> v1860(VarCurr) ) ).

fof(addAssignmentInitValueVector_31,axiom,
    ( v1860(constB0)
  <=> $false ) ).

fof(addAssignment_488,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v1844(VarCurr,B)
      <=> v1846(VarCurr,B) ) ) ).

fof(addAssignment_487,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v1846(VarCurr,B)
      <=> v1848(VarCurr,B) ) ) ).

fof(addAssignment_486,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v1848(VarCurr,B)
      <=> v1850(VarCurr,B) ) ) ).

fof(addAssignment_485,axiom,
    ! [VarCurr] :
      ( ( v1850(VarCurr,bitIndex3)
      <=> v1852(VarCurr,bitIndex63) )
      & ( v1850(VarCurr,bitIndex2)
      <=> v1852(VarCurr,bitIndex62) )
      & ( v1850(VarCurr,bitIndex1)
      <=> v1852(VarCurr,bitIndex61) )
      & ( v1850(VarCurr,bitIndex0)
      <=> v1852(VarCurr,bitIndex60) ) ) ).

fof(addAssignmentInitValueVector_30,axiom,
    ( ( v1852(constB0,bitIndex63)
    <=> $false )
    & ( v1852(constB0,bitIndex62)
    <=> $false )
    & ( v1852(constB0,bitIndex61)
    <=> $false )
    & ( v1852(constB0,bitIndex60)
    <=> $false ) ) ).

fof(bitBlastConstant_609,axiom,
    ~ b0000(bitIndex3) ).

fof(bitBlastConstant_608,axiom,
    ~ b0000(bitIndex2) ).

fof(bitBlastConstant_607,axiom,
    ~ b0000(bitIndex1) ).

fof(bitBlastConstant_606,axiom,
    ~ b0000(bitIndex0) ).

fof(addAssignment_484,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v1127(VarCurr,B)
      <=> v1129(VarCurr,B) ) ) ).

fof(addAssignment_483,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v1129(VarCurr,B)
      <=> v1131(VarCurr,B) ) ) ).

fof(addAssignment_482,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v1131(VarCurr,B)
      <=> v1133(VarCurr,B) ) ) ).

fof(addAssignment_481,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v1133(VarCurr,B)
      <=> v1144(VarCurr,B) ) ) ).

fof(range_axiom_12,axiom,
    ! [B] :
      ( range_3_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_220,axiom,
    ! [VarCurr] :
      ( v714(VarCurr)
    <=> ( v716(VarCurr)
        | v977(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_19,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1802(VarNext)
       => ( v977(VarNext)
        <=> v977(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_19,axiom,
    ! [VarNext] :
      ( v1802(VarNext)
     => ( v977(VarNext)
      <=> v1810(VarNext) ) ) ).

fof(addAssignment_480,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1810(VarNext)
      <=> v1808(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_37,axiom,
    ! [VarCurr] :
      ( ~ v1156(VarCurr)
     => ( v1808(VarCurr)
      <=> v1811(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_38,axiom,
    ! [VarCurr] :
      ( v1156(VarCurr)
     => ( v1808(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_36,axiom,
    ! [VarCurr] :
      ( ~ v716(VarCurr)
     => ( v1811(VarCurr)
      <=> v1812(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_37,axiom,
    ! [VarCurr] :
      ( v716(VarCurr)
     => ( v1811(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_219,axiom,
    ! [VarCurr] :
      ( v1812(VarCurr)
    <=> ( v1813(VarCurr)
        & v977(VarCurr) ) ) ).

fof(writeUnaryOperator_87,axiom,
    ! [VarCurr] :
      ( ~ v1813(VarCurr)
    <=> v979(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_218,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1802(VarNext)
      <=> v1803(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_217,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1803(VarNext)
      <=> ( v1805(VarNext)
          & v125(VarNext) ) ) ) ).

fof(writeUnaryOperator_86,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1805(VarNext)
      <=> v990(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_6,axiom,
    ! [VarCurr] :
      ( ( ~ v1794(VarCurr)
        & ~ v1166(VarCurr)
        & ~ v1176(VarCurr) )
     => ( v979(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_13,axiom,
    ! [VarCurr] :
      ( v1176(VarCurr)
     => ( v979(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_30,axiom,
    ! [VarCurr] :
      ( v1166(VarCurr)
     => ( v979(VarCurr)
      <=> v1797(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_30,axiom,
    ! [VarCurr] :
      ( v1794(VarCurr)
     => ( v979(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_29,axiom,
    ! [VarCurr] :
      ( ~ v1168(VarCurr)
     => ( v1797(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_29,axiom,
    ! [VarCurr] :
      ( v1168(VarCurr)
     => ( v1797(VarCurr)
      <=> v1798(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_28,axiom,
    ! [VarCurr] :
      ( ~ v1799(VarCurr)
     => ( v1798(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_28,axiom,
    ! [VarCurr] :
      ( v1799(VarCurr)
     => ( v1798(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_216,axiom,
    ! [VarCurr] :
      ( v1799(VarCurr)
    <=> ( v1772(VarCurr)
        | v1774(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_215,axiom,
    ! [VarCurr] :
      ( v1794(VarCurr)
    <=> ( v1796(VarCurr)
        | v1165(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_214,axiom,
    ! [VarCurr] :
      ( v1796(VarCurr)
    <=> ( v1160(VarCurr)
        | v1161(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_35,axiom,
    ! [VarCurr] :
      ( ~ v1654(VarCurr)
     => ( v981(VarCurr)
      <=> v1790(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_36,axiom,
    ! [VarCurr] :
      ( v1654(VarCurr)
     => ( v981(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_27,axiom,
    ! [VarCurr] :
      ( ~ v1656(VarCurr)
     => ( v1790(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_27,axiom,
    ! [VarCurr] :
      ( v1656(VarCurr)
     => ( v1790(VarCurr)
      <=> v1791(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_34,axiom,
    ! [VarCurr] :
      ( ~ v1662(VarCurr)
     => ( v1791(VarCurr)
      <=> v1792(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_35,axiom,
    ! [VarCurr] :
      ( v1662(VarCurr)
     => ( v1791(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_33,axiom,
    ! [VarCurr] :
      ( ~ v1664(VarCurr)
     => ( v1792(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_34,axiom,
    ! [VarCurr] :
      ( v1664(VarCurr)
     => ( v1792(VarCurr)
      <=> $false ) ) ).

fof(addCaseBooleanConditionEqualRanges1_18,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1778(VarNext)
       => ( v1004(VarNext)
        <=> v1004(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_18,axiom,
    ! [VarNext] :
      ( v1778(VarNext)
     => ( v1004(VarNext)
      <=> v1786(VarNext) ) ) ).

fof(addAssignment_479,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1786(VarNext)
      <=> v1784(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_32,axiom,
    ! [VarCurr] :
      ( ~ v1156(VarCurr)
     => ( v1784(VarCurr)
      <=> v1006(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_33,axiom,
    ! [VarCurr] :
      ( v1156(VarCurr)
     => ( v1784(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_213,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1778(VarNext)
      <=> v1779(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_212,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1779(VarNext)
      <=> ( v1781(VarNext)
          & v125(VarNext) ) ) ) ).

fof(writeUnaryOperator_85,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1781(VarNext)
      <=> v990(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_2,axiom,
    ! [VarCurr] :
      ( ( ~ v1160(VarCurr)
        & ~ v1767(VarCurr)
        & ~ v1166(VarCurr)
        & ~ v1176(VarCurr) )
     => ( v1006(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_5,axiom,
    ! [VarCurr] :
      ( v1176(VarCurr)
     => ( v1006(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_12,axiom,
    ! [VarCurr] :
      ( v1166(VarCurr)
     => ( v1006(VarCurr)
      <=> v1769(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_26,axiom,
    ! [VarCurr] :
      ( v1767(VarCurr)
     => ( v1006(VarCurr)
      <=> v1768(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_26,axiom,
    ! [VarCurr] :
      ( v1160(VarCurr)
     => ( v1006(VarCurr)
      <=> v1764(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_25,axiom,
    ! [VarCurr] :
      ( ~ v1168(VarCurr)
     => ( v1769(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_25,axiom,
    ! [VarCurr] :
      ( v1168(VarCurr)
     => ( v1769(VarCurr)
      <=> v1770(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_24,axiom,
    ! [VarCurr] :
      ( ~ v1771(VarCurr)
     => ( v1770(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_24,axiom,
    ! [VarCurr] :
      ( v1771(VarCurr)
     => ( v1770(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_211,axiom,
    ! [VarCurr] :
      ( v1771(VarCurr)
    <=> ( v1772(VarCurr)
        | v1774(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_170,axiom,
    ! [VarCurr] :
      ( v1774(VarCurr)
    <=> ( ( v1775(VarCurr,bitIndex1)
        <=> $true )
        & ( v1775(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_478,axiom,
    ! [VarCurr] :
      ( v1775(VarCurr,bitIndex0)
    <=> v1008(VarCurr) ) ).

fof(addAssignment_477,axiom,
    ! [VarCurr] :
      ( v1775(VarCurr,bitIndex1)
    <=> v981(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_169,axiom,
    ! [VarCurr] :
      ( v1772(VarCurr)
    <=> ( ( v1773(VarCurr,bitIndex1)
        <=> $false )
        & ( v1773(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_476,axiom,
    ! [VarCurr] :
      ( v1773(VarCurr,bitIndex0)
    <=> v1008(VarCurr) ) ).

fof(addAssignment_475,axiom,
    ! [VarCurr] :
      ( v1773(VarCurr,bitIndex1)
    <=> v981(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_23,axiom,
    ! [VarCurr] :
      ( ~ v1163(VarCurr)
     => ( v1768(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_23,axiom,
    ! [VarCurr] :
      ( v1163(VarCurr)
     => ( v1768(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_210,axiom,
    ! [VarCurr] :
      ( v1767(VarCurr)
    <=> ( v1161(VarCurr)
        | v1165(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_22,axiom,
    ! [VarCurr] :
      ( ~ v1765(VarCurr)
     => ( v1764(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_22,axiom,
    ! [VarCurr] :
      ( v1765(VarCurr)
     => ( v1764(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_168,axiom,
    ! [VarCurr] :
      ( v1766(VarCurr)
    <=> ( v714(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_167,axiom,
    ! [VarCurr] :
      ( v1765(VarCurr)
    <=> ( v714(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_31,axiom,
    ! [VarCurr] :
      ( ~ v1654(VarCurr)
     => ( v1008(VarCurr)
      <=> v1655(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_32,axiom,
    ! [VarCurr] :
      ( v1654(VarCurr)
     => ( v1008(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_21,axiom,
    ! [VarCurr] :
      ( ~ v1656(VarCurr)
     => ( v1655(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_21,axiom,
    ! [VarCurr] :
      ( v1656(VarCurr)
     => ( v1655(VarCurr)
      <=> v1661(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_30,axiom,
    ! [VarCurr] :
      ( ~ v1662(VarCurr)
     => ( v1661(VarCurr)
      <=> v1663(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_31,axiom,
    ! [VarCurr] :
      ( v1662(VarCurr)
     => ( v1661(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_29,axiom,
    ! [VarCurr] :
      ( ~ v1664(VarCurr)
     => ( v1663(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_30,axiom,
    ! [VarCurr] :
      ( v1664(VarCurr)
     => ( v1663(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_209,axiom,
    ! [VarCurr] :
      ( v1664(VarCurr)
    <=> ( v1665(VarCurr)
        & v1700(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_166,axiom,
    ! [VarCurr] :
      ( v1700(VarCurr)
    <=> ( v1701(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges31_1,axiom,
    ! [VarCurr] :
      ( ( ~ v1731(VarCurr)
        & ~ v1732(VarCurr)
        & ~ v1733(VarCurr)
        & ~ v1734(VarCurr)
        & ~ v1735(VarCurr)
        & ~ v1736(VarCurr)
        & ~ v1737(VarCurr)
        & ~ v1738(VarCurr)
        & ~ v1739(VarCurr)
        & ~ v1740(VarCurr)
        & ~ v1741(VarCurr)
        & ~ v1742(VarCurr)
        & ~ v1743(VarCurr)
        & ~ v1744(VarCurr)
        & ~ v1745(VarCurr)
        & ~ v1746(VarCurr)
        & ~ v1747(VarCurr)
        & ~ v1748(VarCurr)
        & ~ v1749(VarCurr)
        & ~ v1750(VarCurr)
        & ~ v1751(VarCurr)
        & ~ v1752(VarCurr)
        & ~ v1753(VarCurr)
        & ~ v1754(VarCurr)
        & ~ v1755(VarCurr)
        & ~ v1756(VarCurr)
        & ~ v1757(VarCurr)
        & ~ v1758(VarCurr)
        & ~ v1759(VarCurr)
        & ~ v1760(VarCurr)
        & ~ v1761(VarCurr) )
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex31) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges30_1,axiom,
    ! [VarCurr] :
      ( v1761(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex30) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges29_1,axiom,
    ! [VarCurr] :
      ( v1760(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex29) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges28_1,axiom,
    ! [VarCurr] :
      ( v1759(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex28) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges27_1,axiom,
    ! [VarCurr] :
      ( v1758(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex27) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges26_1,axiom,
    ! [VarCurr] :
      ( v1757(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex26) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges25_1,axiom,
    ! [VarCurr] :
      ( v1756(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex25) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges24_1,axiom,
    ! [VarCurr] :
      ( v1755(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex24) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges23_1,axiom,
    ! [VarCurr] :
      ( v1754(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex23) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges22_1,axiom,
    ! [VarCurr] :
      ( v1753(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex22) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges21_1,axiom,
    ! [VarCurr] :
      ( v1752(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex21) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges20_1,axiom,
    ! [VarCurr] :
      ( v1751(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex20) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges19_1,axiom,
    ! [VarCurr] :
      ( v1750(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex19) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges18_1,axiom,
    ! [VarCurr] :
      ( v1749(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex18) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges17_1,axiom,
    ! [VarCurr] :
      ( v1748(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex17) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges16_1,axiom,
    ! [VarCurr] :
      ( v1747(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex16) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges15_1,axiom,
    ! [VarCurr] :
      ( v1746(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex15) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges14_1,axiom,
    ! [VarCurr] :
      ( v1745(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex14) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges13_1,axiom,
    ! [VarCurr] :
      ( v1744(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex13) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges12_1,axiom,
    ! [VarCurr] :
      ( v1743(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex12) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges11_1,axiom,
    ! [VarCurr] :
      ( v1742(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex11) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges10_1,axiom,
    ! [VarCurr] :
      ( v1741(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex10) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges9_1,axiom,
    ! [VarCurr] :
      ( v1740(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex9) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges8_1,axiom,
    ! [VarCurr] :
      ( v1739(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex8) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges7_1,axiom,
    ! [VarCurr] :
      ( v1738(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex7) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges6_1,axiom,
    ! [VarCurr] :
      ( v1737(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex6) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges5_1,axiom,
    ! [VarCurr] :
      ( v1736(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex5) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges4_1,axiom,
    ! [VarCurr] :
      ( v1735(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex4) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges3_1,axiom,
    ! [VarCurr] :
      ( v1734(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex3) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges2_1,axiom,
    ! [VarCurr] :
      ( v1733(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex2) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges1_1,axiom,
    ! [VarCurr] :
      ( v1732(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex1) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_20,axiom,
    ! [VarCurr] :
      ( v1731(VarCurr)
     => ( v1701(VarCurr)
      <=> v1050(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_165,axiom,
    ! [VarCurr] :
      ( v1762(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $true )
        & ( v1703(VarCurr,bitIndex3)
        <=> $true )
        & ( v1703(VarCurr,bitIndex2)
        <=> $true )
        & ( v1703(VarCurr,bitIndex1)
        <=> $true )
        & ( v1703(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_164,axiom,
    ! [VarCurr] :
      ( v1761(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $true )
        & ( v1703(VarCurr,bitIndex3)
        <=> $true )
        & ( v1703(VarCurr,bitIndex2)
        <=> $true )
        & ( v1703(VarCurr,bitIndex1)
        <=> $true )
        & ( v1703(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_163,axiom,
    ! [VarCurr] :
      ( v1760(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $true )
        & ( v1703(VarCurr,bitIndex3)
        <=> $true )
        & ( v1703(VarCurr,bitIndex2)
        <=> $true )
        & ( v1703(VarCurr,bitIndex1)
        <=> $false )
        & ( v1703(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_162,axiom,
    ! [VarCurr] :
      ( v1759(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $true )
        & ( v1703(VarCurr,bitIndex3)
        <=> $true )
        & ( v1703(VarCurr,bitIndex2)
        <=> $true )
        & ( v1703(VarCurr,bitIndex1)
        <=> $false )
        & ( v1703(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_161,axiom,
    ! [VarCurr] :
      ( v1758(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $true )
        & ( v1703(VarCurr,bitIndex3)
        <=> $true )
        & ( v1703(VarCurr,bitIndex2)
        <=> $false )
        & ( v1703(VarCurr,bitIndex1)
        <=> $true )
        & ( v1703(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_160,axiom,
    ! [VarCurr] :
      ( v1757(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $true )
        & ( v1703(VarCurr,bitIndex3)
        <=> $true )
        & ( v1703(VarCurr,bitIndex2)
        <=> $false )
        & ( v1703(VarCurr,bitIndex1)
        <=> $true )
        & ( v1703(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_159,axiom,
    ! [VarCurr] :
      ( v1756(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $true )
        & ( v1703(VarCurr,bitIndex3)
        <=> $true )
        & ( v1703(VarCurr,bitIndex2)
        <=> $false )
        & ( v1703(VarCurr,bitIndex1)
        <=> $false )
        & ( v1703(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_158,axiom,
    ! [VarCurr] :
      ( v1755(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $true )
        & ( v1703(VarCurr,bitIndex3)
        <=> $true )
        & ( v1703(VarCurr,bitIndex2)
        <=> $false )
        & ( v1703(VarCurr,bitIndex1)
        <=> $false )
        & ( v1703(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_157,axiom,
    ! [VarCurr] :
      ( v1754(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $true )
        & ( v1703(VarCurr,bitIndex3)
        <=> $false )
        & ( v1703(VarCurr,bitIndex2)
        <=> $true )
        & ( v1703(VarCurr,bitIndex1)
        <=> $true )
        & ( v1703(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_156,axiom,
    ! [VarCurr] :
      ( v1753(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $true )
        & ( v1703(VarCurr,bitIndex3)
        <=> $false )
        & ( v1703(VarCurr,bitIndex2)
        <=> $true )
        & ( v1703(VarCurr,bitIndex1)
        <=> $true )
        & ( v1703(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_155,axiom,
    ! [VarCurr] :
      ( v1752(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $true )
        & ( v1703(VarCurr,bitIndex3)
        <=> $false )
        & ( v1703(VarCurr,bitIndex2)
        <=> $true )
        & ( v1703(VarCurr,bitIndex1)
        <=> $false )
        & ( v1703(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_154,axiom,
    ! [VarCurr] :
      ( v1751(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $true )
        & ( v1703(VarCurr,bitIndex3)
        <=> $false )
        & ( v1703(VarCurr,bitIndex2)
        <=> $true )
        & ( v1703(VarCurr,bitIndex1)
        <=> $false )
        & ( v1703(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_153,axiom,
    ! [VarCurr] :
      ( v1750(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $true )
        & ( v1703(VarCurr,bitIndex3)
        <=> $false )
        & ( v1703(VarCurr,bitIndex2)
        <=> $false )
        & ( v1703(VarCurr,bitIndex1)
        <=> $true )
        & ( v1703(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_152,axiom,
    ! [VarCurr] :
      ( v1749(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $true )
        & ( v1703(VarCurr,bitIndex3)
        <=> $false )
        & ( v1703(VarCurr,bitIndex2)
        <=> $false )
        & ( v1703(VarCurr,bitIndex1)
        <=> $true )
        & ( v1703(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_151,axiom,
    ! [VarCurr] :
      ( v1748(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $true )
        & ( v1703(VarCurr,bitIndex3)
        <=> $false )
        & ( v1703(VarCurr,bitIndex2)
        <=> $false )
        & ( v1703(VarCurr,bitIndex1)
        <=> $false )
        & ( v1703(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_150,axiom,
    ! [VarCurr] :
      ( v1747(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $true )
        & ( v1703(VarCurr,bitIndex3)
        <=> $false )
        & ( v1703(VarCurr,bitIndex2)
        <=> $false )
        & ( v1703(VarCurr,bitIndex1)
        <=> $false )
        & ( v1703(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_149,axiom,
    ! [VarCurr] :
      ( v1746(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $false )
        & ( v1703(VarCurr,bitIndex3)
        <=> $true )
        & ( v1703(VarCurr,bitIndex2)
        <=> $true )
        & ( v1703(VarCurr,bitIndex1)
        <=> $true )
        & ( v1703(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_148,axiom,
    ! [VarCurr] :
      ( v1745(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $false )
        & ( v1703(VarCurr,bitIndex3)
        <=> $true )
        & ( v1703(VarCurr,bitIndex2)
        <=> $true )
        & ( v1703(VarCurr,bitIndex1)
        <=> $true )
        & ( v1703(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_147,axiom,
    ! [VarCurr] :
      ( v1744(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $false )
        & ( v1703(VarCurr,bitIndex3)
        <=> $true )
        & ( v1703(VarCurr,bitIndex2)
        <=> $true )
        & ( v1703(VarCurr,bitIndex1)
        <=> $false )
        & ( v1703(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_146,axiom,
    ! [VarCurr] :
      ( v1743(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $false )
        & ( v1703(VarCurr,bitIndex3)
        <=> $true )
        & ( v1703(VarCurr,bitIndex2)
        <=> $true )
        & ( v1703(VarCurr,bitIndex1)
        <=> $false )
        & ( v1703(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_145,axiom,
    ! [VarCurr] :
      ( v1742(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $false )
        & ( v1703(VarCurr,bitIndex3)
        <=> $true )
        & ( v1703(VarCurr,bitIndex2)
        <=> $false )
        & ( v1703(VarCurr,bitIndex1)
        <=> $true )
        & ( v1703(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_144,axiom,
    ! [VarCurr] :
      ( v1741(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $false )
        & ( v1703(VarCurr,bitIndex3)
        <=> $true )
        & ( v1703(VarCurr,bitIndex2)
        <=> $false )
        & ( v1703(VarCurr,bitIndex1)
        <=> $true )
        & ( v1703(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_143,axiom,
    ! [VarCurr] :
      ( v1740(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $false )
        & ( v1703(VarCurr,bitIndex3)
        <=> $true )
        & ( v1703(VarCurr,bitIndex2)
        <=> $false )
        & ( v1703(VarCurr,bitIndex1)
        <=> $false )
        & ( v1703(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_142,axiom,
    ! [VarCurr] :
      ( v1739(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $false )
        & ( v1703(VarCurr,bitIndex3)
        <=> $true )
        & ( v1703(VarCurr,bitIndex2)
        <=> $false )
        & ( v1703(VarCurr,bitIndex1)
        <=> $false )
        & ( v1703(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_141,axiom,
    ! [VarCurr] :
      ( v1738(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $false )
        & ( v1703(VarCurr,bitIndex3)
        <=> $false )
        & ( v1703(VarCurr,bitIndex2)
        <=> $true )
        & ( v1703(VarCurr,bitIndex1)
        <=> $true )
        & ( v1703(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_140,axiom,
    ! [VarCurr] :
      ( v1737(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $false )
        & ( v1703(VarCurr,bitIndex3)
        <=> $false )
        & ( v1703(VarCurr,bitIndex2)
        <=> $true )
        & ( v1703(VarCurr,bitIndex1)
        <=> $true )
        & ( v1703(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_139,axiom,
    ! [VarCurr] :
      ( v1736(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $false )
        & ( v1703(VarCurr,bitIndex3)
        <=> $false )
        & ( v1703(VarCurr,bitIndex2)
        <=> $true )
        & ( v1703(VarCurr,bitIndex1)
        <=> $false )
        & ( v1703(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_138,axiom,
    ! [VarCurr] :
      ( v1735(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $false )
        & ( v1703(VarCurr,bitIndex3)
        <=> $false )
        & ( v1703(VarCurr,bitIndex2)
        <=> $true )
        & ( v1703(VarCurr,bitIndex1)
        <=> $false )
        & ( v1703(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_137,axiom,
    ! [VarCurr] :
      ( v1734(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $false )
        & ( v1703(VarCurr,bitIndex3)
        <=> $false )
        & ( v1703(VarCurr,bitIndex2)
        <=> $false )
        & ( v1703(VarCurr,bitIndex1)
        <=> $true )
        & ( v1703(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_136,axiom,
    ! [VarCurr] :
      ( v1733(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $false )
        & ( v1703(VarCurr,bitIndex3)
        <=> $false )
        & ( v1703(VarCurr,bitIndex2)
        <=> $false )
        & ( v1703(VarCurr,bitIndex1)
        <=> $true )
        & ( v1703(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_135,axiom,
    ! [VarCurr] :
      ( v1732(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $false )
        & ( v1703(VarCurr,bitIndex3)
        <=> $false )
        & ( v1703(VarCurr,bitIndex2)
        <=> $false )
        & ( v1703(VarCurr,bitIndex1)
        <=> $false )
        & ( v1703(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_134,axiom,
    ! [VarCurr] :
      ( v1731(VarCurr)
    <=> ( ( v1703(VarCurr,bitIndex4)
        <=> $false )
        & ( v1703(VarCurr,bitIndex3)
        <=> $false )
        & ( v1703(VarCurr,bitIndex2)
        <=> $false )
        & ( v1703(VarCurr,bitIndex1)
        <=> $false )
        & ( v1703(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_474,axiom,
    ! [VarCurr] :
      ( v1703(VarCurr,bitIndex0)
    <=> v1729(VarCurr) ) ).

fof(addAssignment_473,axiom,
    ! [VarCurr] :
      ( v1703(VarCurr,bitIndex1)
    <=> v1727(VarCurr) ) ).

fof(addAssignment_472,axiom,
    ! [VarCurr] :
      ( v1703(VarCurr,bitIndex2)
    <=> v1723(VarCurr) ) ).

fof(addAssignment_471,axiom,
    ! [VarCurr] :
      ( v1703(VarCurr,bitIndex3)
    <=> v1719(VarCurr) ) ).

fof(addAssignment_470,axiom,
    ! [VarCurr] :
      ( v1703(VarCurr,bitIndex4)
    <=> v1705(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_208,axiom,
    ! [VarCurr] :
      ( v1727(VarCurr)
    <=> ( v1728(VarCurr)
        & v1730(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_207,axiom,
    ! [VarCurr] :
      ( v1730(VarCurr)
    <=> ( v1012(VarCurr,bitIndex0)
        | v1714(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_6,axiom,
    ! [VarCurr] :
      ( v1728(VarCurr)
    <=> ( v1729(VarCurr)
        | v1012(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_84,axiom,
    ! [VarCurr] :
      ( ~ v1729(VarCurr)
    <=> v1012(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_206,axiom,
    ! [VarCurr] :
      ( v1723(VarCurr)
    <=> ( v1724(VarCurr)
        & v1726(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_205,axiom,
    ! [VarCurr] :
      ( v1726(VarCurr)
    <=> ( v1712(VarCurr)
        | v1715(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_5,axiom,
    ! [VarCurr] :
      ( v1724(VarCurr)
    <=> ( v1725(VarCurr)
        | v1012(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_83,axiom,
    ! [VarCurr] :
      ( ~ v1725(VarCurr)
    <=> v1712(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_204,axiom,
    ! [VarCurr] :
      ( v1719(VarCurr)
    <=> ( v1720(VarCurr)
        & v1722(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_203,axiom,
    ! [VarCurr] :
      ( v1722(VarCurr)
    <=> ( v1710(VarCurr)
        | v1716(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_4,axiom,
    ! [VarCurr] :
      ( v1720(VarCurr)
    <=> ( v1721(VarCurr)
        | v1012(VarCurr,bitIndex3) ) ) ).

fof(writeUnaryOperator_82,axiom,
    ! [VarCurr] :
      ( ~ v1721(VarCurr)
    <=> v1710(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_202,axiom,
    ! [VarCurr] :
      ( v1705(VarCurr)
    <=> ( v1706(VarCurr)
        & v1717(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_201,axiom,
    ! [VarCurr] :
      ( v1717(VarCurr)
    <=> ( v1708(VarCurr)
        | v1718(VarCurr) ) ) ).

fof(writeUnaryOperator_81,axiom,
    ! [VarCurr] :
      ( ~ v1718(VarCurr)
    <=> v1012(VarCurr,bitIndex4) ) ).

fof(writeBinaryOperatorShiftedRanges_3,axiom,
    ! [VarCurr] :
      ( v1706(VarCurr)
    <=> ( v1707(VarCurr)
        | v1012(VarCurr,bitIndex4) ) ) ).

fof(writeUnaryOperator_80,axiom,
    ! [VarCurr] :
      ( ~ v1707(VarCurr)
    <=> v1708(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_2,axiom,
    ! [VarCurr] :
      ( v1708(VarCurr)
    <=> ( v1012(VarCurr,bitIndex3)
        | v1709(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_200,axiom,
    ! [VarCurr] :
      ( v1709(VarCurr)
    <=> ( v1710(VarCurr)
        & v1716(VarCurr) ) ) ).

fof(writeUnaryOperator_79,axiom,
    ! [VarCurr] :
      ( ~ v1716(VarCurr)
    <=> v1012(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorShiftedRanges_1,axiom,
    ! [VarCurr] :
      ( v1710(VarCurr)
    <=> ( v1012(VarCurr,bitIndex2)
        | v1711(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_199,axiom,
    ! [VarCurr] :
      ( v1711(VarCurr)
    <=> ( v1712(VarCurr)
        & v1715(VarCurr) ) ) ).

fof(writeUnaryOperator_78,axiom,
    ! [VarCurr] :
      ( ~ v1715(VarCurr)
    <=> v1012(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges,axiom,
    ! [VarCurr] :
      ( v1712(VarCurr)
    <=> ( v1012(VarCurr,bitIndex1)
        | v1713(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_198,axiom,
    ! [VarCurr] :
      ( v1713(VarCurr)
    <=> ( v1012(VarCurr,bitIndex0)
        & v1714(VarCurr) ) ) ).

fof(writeUnaryOperator_77,axiom,
    ! [VarCurr] :
      ( ~ v1714(VarCurr)
    <=> v1012(VarCurr,bitIndex1) ) ).

fof(addBitVectorEqualityBitBlasted_133,axiom,
    ! [VarCurr] :
      ( v1665(VarCurr)
    <=> ( v1666(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges31,axiom,
    ! [VarCurr] :
      ( ( ~ v1668(VarCurr)
        & ~ v1669(VarCurr)
        & ~ v1670(VarCurr)
        & ~ v1671(VarCurr)
        & ~ v1672(VarCurr)
        & ~ v1673(VarCurr)
        & ~ v1674(VarCurr)
        & ~ v1675(VarCurr)
        & ~ v1676(VarCurr)
        & ~ v1677(VarCurr)
        & ~ v1678(VarCurr)
        & ~ v1679(VarCurr)
        & ~ v1680(VarCurr)
        & ~ v1681(VarCurr)
        & ~ v1682(VarCurr)
        & ~ v1683(VarCurr)
        & ~ v1684(VarCurr)
        & ~ v1685(VarCurr)
        & ~ v1686(VarCurr)
        & ~ v1687(VarCurr)
        & ~ v1688(VarCurr)
        & ~ v1689(VarCurr)
        & ~ v1690(VarCurr)
        & ~ v1691(VarCurr)
        & ~ v1692(VarCurr)
        & ~ v1693(VarCurr)
        & ~ v1694(VarCurr)
        & ~ v1695(VarCurr)
        & ~ v1696(VarCurr)
        & ~ v1697(VarCurr)
        & ~ v1698(VarCurr) )
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex31) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges30,axiom,
    ! [VarCurr] :
      ( v1698(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex30) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges29,axiom,
    ! [VarCurr] :
      ( v1697(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex29) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges28,axiom,
    ! [VarCurr] :
      ( v1696(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex28) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges27,axiom,
    ! [VarCurr] :
      ( v1695(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex27) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges26,axiom,
    ! [VarCurr] :
      ( v1694(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex26) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges25,axiom,
    ! [VarCurr] :
      ( v1693(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex25) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges24,axiom,
    ! [VarCurr] :
      ( v1692(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex24) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges23,axiom,
    ! [VarCurr] :
      ( v1691(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex23) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges22,axiom,
    ! [VarCurr] :
      ( v1690(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex22) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges21,axiom,
    ! [VarCurr] :
      ( v1689(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex21) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges20,axiom,
    ! [VarCurr] :
      ( v1688(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex20) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges19,axiom,
    ! [VarCurr] :
      ( v1687(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex19) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges18,axiom,
    ! [VarCurr] :
      ( v1686(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex18) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges17,axiom,
    ! [VarCurr] :
      ( v1685(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex17) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges16,axiom,
    ! [VarCurr] :
      ( v1684(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex16) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges15,axiom,
    ! [VarCurr] :
      ( v1683(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex15) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges14,axiom,
    ! [VarCurr] :
      ( v1682(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex14) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges13,axiom,
    ! [VarCurr] :
      ( v1681(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex13) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges12,axiom,
    ! [VarCurr] :
      ( v1680(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex12) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges11,axiom,
    ! [VarCurr] :
      ( v1679(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex11) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges10,axiom,
    ! [VarCurr] :
      ( v1678(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex10) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges9,axiom,
    ! [VarCurr] :
      ( v1677(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex9) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges8,axiom,
    ! [VarCurr] :
      ( v1676(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex8) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges7,axiom,
    ! [VarCurr] :
      ( v1675(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex7) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges6,axiom,
    ! [VarCurr] :
      ( v1674(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex6) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges5,axiom,
    ! [VarCurr] :
      ( v1673(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex5) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges4,axiom,
    ! [VarCurr] :
      ( v1672(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex4) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges3,axiom,
    ! [VarCurr] :
      ( v1671(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex3) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges2,axiom,
    ! [VarCurr] :
      ( v1670(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex2) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges1,axiom,
    ! [VarCurr] :
      ( v1669(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex1) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_19,axiom,
    ! [VarCurr] :
      ( v1668(VarCurr)
     => ( v1666(VarCurr)
      <=> v1050(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_132,axiom,
    ! [VarCurr] :
      ( v1699(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $true )
        & ( v1012(VarCurr,bitIndex3)
        <=> $true )
        & ( v1012(VarCurr,bitIndex2)
        <=> $true )
        & ( v1012(VarCurr,bitIndex1)
        <=> $true )
        & ( v1012(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_131,axiom,
    ! [VarCurr] :
      ( v1698(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $true )
        & ( v1012(VarCurr,bitIndex3)
        <=> $true )
        & ( v1012(VarCurr,bitIndex2)
        <=> $true )
        & ( v1012(VarCurr,bitIndex1)
        <=> $true )
        & ( v1012(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_130,axiom,
    ! [VarCurr] :
      ( v1697(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $true )
        & ( v1012(VarCurr,bitIndex3)
        <=> $true )
        & ( v1012(VarCurr,bitIndex2)
        <=> $true )
        & ( v1012(VarCurr,bitIndex1)
        <=> $false )
        & ( v1012(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_129,axiom,
    ! [VarCurr] :
      ( v1696(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $true )
        & ( v1012(VarCurr,bitIndex3)
        <=> $true )
        & ( v1012(VarCurr,bitIndex2)
        <=> $true )
        & ( v1012(VarCurr,bitIndex1)
        <=> $false )
        & ( v1012(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_128,axiom,
    ! [VarCurr] :
      ( v1695(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $true )
        & ( v1012(VarCurr,bitIndex3)
        <=> $true )
        & ( v1012(VarCurr,bitIndex2)
        <=> $false )
        & ( v1012(VarCurr,bitIndex1)
        <=> $true )
        & ( v1012(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_127,axiom,
    ! [VarCurr] :
      ( v1694(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $true )
        & ( v1012(VarCurr,bitIndex3)
        <=> $true )
        & ( v1012(VarCurr,bitIndex2)
        <=> $false )
        & ( v1012(VarCurr,bitIndex1)
        <=> $true )
        & ( v1012(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_126,axiom,
    ! [VarCurr] :
      ( v1693(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $true )
        & ( v1012(VarCurr,bitIndex3)
        <=> $true )
        & ( v1012(VarCurr,bitIndex2)
        <=> $false )
        & ( v1012(VarCurr,bitIndex1)
        <=> $false )
        & ( v1012(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_125,axiom,
    ! [VarCurr] :
      ( v1692(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $true )
        & ( v1012(VarCurr,bitIndex3)
        <=> $true )
        & ( v1012(VarCurr,bitIndex2)
        <=> $false )
        & ( v1012(VarCurr,bitIndex1)
        <=> $false )
        & ( v1012(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_124,axiom,
    ! [VarCurr] :
      ( v1691(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $true )
        & ( v1012(VarCurr,bitIndex3)
        <=> $false )
        & ( v1012(VarCurr,bitIndex2)
        <=> $true )
        & ( v1012(VarCurr,bitIndex1)
        <=> $true )
        & ( v1012(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_123,axiom,
    ! [VarCurr] :
      ( v1690(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $true )
        & ( v1012(VarCurr,bitIndex3)
        <=> $false )
        & ( v1012(VarCurr,bitIndex2)
        <=> $true )
        & ( v1012(VarCurr,bitIndex1)
        <=> $true )
        & ( v1012(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_122,axiom,
    ! [VarCurr] :
      ( v1689(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $true )
        & ( v1012(VarCurr,bitIndex3)
        <=> $false )
        & ( v1012(VarCurr,bitIndex2)
        <=> $true )
        & ( v1012(VarCurr,bitIndex1)
        <=> $false )
        & ( v1012(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_121,axiom,
    ! [VarCurr] :
      ( v1688(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $true )
        & ( v1012(VarCurr,bitIndex3)
        <=> $false )
        & ( v1012(VarCurr,bitIndex2)
        <=> $true )
        & ( v1012(VarCurr,bitIndex1)
        <=> $false )
        & ( v1012(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_120,axiom,
    ! [VarCurr] :
      ( v1687(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $true )
        & ( v1012(VarCurr,bitIndex3)
        <=> $false )
        & ( v1012(VarCurr,bitIndex2)
        <=> $false )
        & ( v1012(VarCurr,bitIndex1)
        <=> $true )
        & ( v1012(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_119,axiom,
    ! [VarCurr] :
      ( v1686(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $true )
        & ( v1012(VarCurr,bitIndex3)
        <=> $false )
        & ( v1012(VarCurr,bitIndex2)
        <=> $false )
        & ( v1012(VarCurr,bitIndex1)
        <=> $true )
        & ( v1012(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_118,axiom,
    ! [VarCurr] :
      ( v1685(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $true )
        & ( v1012(VarCurr,bitIndex3)
        <=> $false )
        & ( v1012(VarCurr,bitIndex2)
        <=> $false )
        & ( v1012(VarCurr,bitIndex1)
        <=> $false )
        & ( v1012(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_117,axiom,
    ! [VarCurr] :
      ( v1684(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $true )
        & ( v1012(VarCurr,bitIndex3)
        <=> $false )
        & ( v1012(VarCurr,bitIndex2)
        <=> $false )
        & ( v1012(VarCurr,bitIndex1)
        <=> $false )
        & ( v1012(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_116,axiom,
    ! [VarCurr] :
      ( v1683(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $false )
        & ( v1012(VarCurr,bitIndex3)
        <=> $true )
        & ( v1012(VarCurr,bitIndex2)
        <=> $true )
        & ( v1012(VarCurr,bitIndex1)
        <=> $true )
        & ( v1012(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_115,axiom,
    ! [VarCurr] :
      ( v1682(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $false )
        & ( v1012(VarCurr,bitIndex3)
        <=> $true )
        & ( v1012(VarCurr,bitIndex2)
        <=> $true )
        & ( v1012(VarCurr,bitIndex1)
        <=> $true )
        & ( v1012(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_114,axiom,
    ! [VarCurr] :
      ( v1681(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $false )
        & ( v1012(VarCurr,bitIndex3)
        <=> $true )
        & ( v1012(VarCurr,bitIndex2)
        <=> $true )
        & ( v1012(VarCurr,bitIndex1)
        <=> $false )
        & ( v1012(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_113,axiom,
    ! [VarCurr] :
      ( v1680(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $false )
        & ( v1012(VarCurr,bitIndex3)
        <=> $true )
        & ( v1012(VarCurr,bitIndex2)
        <=> $true )
        & ( v1012(VarCurr,bitIndex1)
        <=> $false )
        & ( v1012(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_112,axiom,
    ! [VarCurr] :
      ( v1679(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $false )
        & ( v1012(VarCurr,bitIndex3)
        <=> $true )
        & ( v1012(VarCurr,bitIndex2)
        <=> $false )
        & ( v1012(VarCurr,bitIndex1)
        <=> $true )
        & ( v1012(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_111,axiom,
    ! [VarCurr] :
      ( v1678(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $false )
        & ( v1012(VarCurr,bitIndex3)
        <=> $true )
        & ( v1012(VarCurr,bitIndex2)
        <=> $false )
        & ( v1012(VarCurr,bitIndex1)
        <=> $true )
        & ( v1012(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_110,axiom,
    ! [VarCurr] :
      ( v1677(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $false )
        & ( v1012(VarCurr,bitIndex3)
        <=> $true )
        & ( v1012(VarCurr,bitIndex2)
        <=> $false )
        & ( v1012(VarCurr,bitIndex1)
        <=> $false )
        & ( v1012(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_109,axiom,
    ! [VarCurr] :
      ( v1676(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $false )
        & ( v1012(VarCurr,bitIndex3)
        <=> $true )
        & ( v1012(VarCurr,bitIndex2)
        <=> $false )
        & ( v1012(VarCurr,bitIndex1)
        <=> $false )
        & ( v1012(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_108,axiom,
    ! [VarCurr] :
      ( v1675(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $false )
        & ( v1012(VarCurr,bitIndex3)
        <=> $false )
        & ( v1012(VarCurr,bitIndex2)
        <=> $true )
        & ( v1012(VarCurr,bitIndex1)
        <=> $true )
        & ( v1012(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_107,axiom,
    ! [VarCurr] :
      ( v1674(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $false )
        & ( v1012(VarCurr,bitIndex3)
        <=> $false )
        & ( v1012(VarCurr,bitIndex2)
        <=> $true )
        & ( v1012(VarCurr,bitIndex1)
        <=> $true )
        & ( v1012(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_106,axiom,
    ! [VarCurr] :
      ( v1673(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $false )
        & ( v1012(VarCurr,bitIndex3)
        <=> $false )
        & ( v1012(VarCurr,bitIndex2)
        <=> $true )
        & ( v1012(VarCurr,bitIndex1)
        <=> $false )
        & ( v1012(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_105,axiom,
    ! [VarCurr] :
      ( v1672(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $false )
        & ( v1012(VarCurr,bitIndex3)
        <=> $false )
        & ( v1012(VarCurr,bitIndex2)
        <=> $true )
        & ( v1012(VarCurr,bitIndex1)
        <=> $false )
        & ( v1012(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_104,axiom,
    ! [VarCurr] :
      ( v1671(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $false )
        & ( v1012(VarCurr,bitIndex3)
        <=> $false )
        & ( v1012(VarCurr,bitIndex2)
        <=> $false )
        & ( v1012(VarCurr,bitIndex1)
        <=> $true )
        & ( v1012(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_103,axiom,
    ! [VarCurr] :
      ( v1670(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $false )
        & ( v1012(VarCurr,bitIndex3)
        <=> $false )
        & ( v1012(VarCurr,bitIndex2)
        <=> $false )
        & ( v1012(VarCurr,bitIndex1)
        <=> $true )
        & ( v1012(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_102,axiom,
    ! [VarCurr] :
      ( v1669(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $false )
        & ( v1012(VarCurr,bitIndex3)
        <=> $false )
        & ( v1012(VarCurr,bitIndex2)
        <=> $false )
        & ( v1012(VarCurr,bitIndex1)
        <=> $false )
        & ( v1012(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_101,axiom,
    ! [VarCurr] :
      ( v1668(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $false )
        & ( v1012(VarCurr,bitIndex3)
        <=> $false )
        & ( v1012(VarCurr,bitIndex2)
        <=> $false )
        & ( v1012(VarCurr,bitIndex1)
        <=> $false )
        & ( v1012(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_100,axiom,
    ! [VarCurr] :
      ( v1662(VarCurr)
    <=> ( ( v1012(VarCurr,bitIndex4)
        <=> $false )
        & ( v1012(VarCurr,bitIndex3)
        <=> $false )
        & ( v1012(VarCurr,bitIndex2)
        <=> $false )
        & ( v1012(VarCurr,bitIndex1)
        <=> $false )
        & ( v1012(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_197,axiom,
    ! [VarCurr] :
      ( v1656(VarCurr)
    <=> ( v1657(VarCurr)
        | v1659(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_99,axiom,
    ! [VarCurr] :
      ( v1659(VarCurr)
    <=> ( ( v1660(VarCurr,bitIndex3)
        <=> $false )
        & ( v1660(VarCurr,bitIndex2)
        <=> $true )
        & ( v1660(VarCurr,bitIndex1)
        <=> $false )
        & ( v1660(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_605,axiom,
    ~ b0101(bitIndex3) ).

fof(bitBlastConstant_604,axiom,
    b0101(bitIndex2) ).

fof(bitBlastConstant_603,axiom,
    ~ b0101(bitIndex1) ).

fof(bitBlastConstant_602,axiom,
    b0101(bitIndex0) ).

fof(addAssignment_469,axiom,
    ! [VarCurr] :
      ( v1660(VarCurr,bitIndex0)
    <=> v1004(VarCurr) ) ).

fof(addAssignment_468,axiom,
    ! [VarCurr] :
      ( ( v1660(VarCurr,bitIndex3)
      <=> v983(VarCurr,bitIndex2) )
      & ( v1660(VarCurr,bitIndex2)
      <=> v983(VarCurr,bitIndex1) )
      & ( v1660(VarCurr,bitIndex1)
      <=> v983(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_98,axiom,
    ! [VarCurr] :
      ( v1657(VarCurr)
    <=> ( ( v1658(VarCurr,bitIndex3)
        <=> $false )
        & ( v1658(VarCurr,bitIndex2)
        <=> $false )
        & ( v1658(VarCurr,bitIndex1)
        <=> $true )
        & ( v1658(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_601,axiom,
    ~ b0011(bitIndex3) ).

fof(bitBlastConstant_600,axiom,
    ~ b0011(bitIndex2) ).

fof(bitBlastConstant_599,axiom,
    b0011(bitIndex1) ).

fof(bitBlastConstant_598,axiom,
    b0011(bitIndex0) ).

fof(addAssignment_467,axiom,
    ! [VarCurr] :
      ( v1658(VarCurr,bitIndex0)
    <=> v1004(VarCurr) ) ).

fof(addAssignment_466,axiom,
    ! [VarCurr] :
      ( ( v1658(VarCurr,bitIndex3)
      <=> v983(VarCurr,bitIndex2) )
      & ( v1658(VarCurr,bitIndex2)
      <=> v983(VarCurr,bitIndex1) )
      & ( v1658(VarCurr,bitIndex1)
      <=> v983(VarCurr,bitIndex0) ) ) ).

fof(addAssignmentInitValueVector_29,axiom,
    ( v1004(constB0)
  <=> $false ) ).

fof(addBitVectorEqualityBitBlasted_97,axiom,
    ! [VarCurr] :
      ( v1654(VarCurr)
    <=> ( v51(VarCurr)
      <=> $false ) ) ).

fof(addAssignment_465,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex31)
    <=> v1052(VarCurr,bitIndex31) ) ).

fof(addAssignment_464,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex31)
    <=> v1054(VarCurr,bitIndex31) ) ).

fof(addAssignment_463,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex31)
    <=> v1056(VarCurr,bitIndex31) ) ).

fof(addAssignment_462,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex31)
    <=> v1058(VarCurr,bitIndex31) ) ).

fof(addAssignment_461,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex31)
    <=> v1652(VarCurr,bitIndex31) ) ).

fof(addAssignment_460,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex30)
    <=> v1052(VarCurr,bitIndex30) ) ).

fof(addAssignment_459,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex30)
    <=> v1054(VarCurr,bitIndex30) ) ).

fof(addAssignment_458,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex30)
    <=> v1056(VarCurr,bitIndex30) ) ).

fof(addAssignment_457,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex30)
    <=> v1058(VarCurr,bitIndex30) ) ).

fof(addAssignment_456,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex30)
    <=> v1652(VarCurr,bitIndex30) ) ).

fof(addAssignment_455,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex29)
    <=> v1052(VarCurr,bitIndex29) ) ).

fof(addAssignment_454,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex29)
    <=> v1054(VarCurr,bitIndex29) ) ).

fof(addAssignment_453,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex29)
    <=> v1056(VarCurr,bitIndex29) ) ).

fof(addAssignment_452,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex29)
    <=> v1058(VarCurr,bitIndex29) ) ).

fof(addAssignment_451,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex29)
    <=> v1652(VarCurr,bitIndex29) ) ).

fof(addAssignment_450,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex28)
    <=> v1052(VarCurr,bitIndex28) ) ).

fof(addAssignment_449,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex28)
    <=> v1054(VarCurr,bitIndex28) ) ).

fof(addAssignment_448,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex28)
    <=> v1056(VarCurr,bitIndex28) ) ).

fof(addAssignment_447,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex28)
    <=> v1058(VarCurr,bitIndex28) ) ).

fof(addAssignment_446,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex28)
    <=> v1652(VarCurr,bitIndex28) ) ).

fof(addAssignment_445,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex27)
    <=> v1052(VarCurr,bitIndex27) ) ).

fof(addAssignment_444,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex27)
    <=> v1054(VarCurr,bitIndex27) ) ).

fof(addAssignment_443,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex27)
    <=> v1056(VarCurr,bitIndex27) ) ).

fof(addAssignment_442,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex27)
    <=> v1058(VarCurr,bitIndex27) ) ).

fof(addAssignment_441,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex27)
    <=> v1652(VarCurr,bitIndex27) ) ).

fof(addAssignment_440,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex26)
    <=> v1052(VarCurr,bitIndex26) ) ).

fof(addAssignment_439,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex26)
    <=> v1054(VarCurr,bitIndex26) ) ).

fof(addAssignment_438,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex26)
    <=> v1056(VarCurr,bitIndex26) ) ).

fof(addAssignment_437,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex26)
    <=> v1058(VarCurr,bitIndex26) ) ).

fof(addAssignment_436,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex26)
    <=> v1652(VarCurr,bitIndex26) ) ).

fof(addAssignment_435,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex25)
    <=> v1052(VarCurr,bitIndex25) ) ).

fof(addAssignment_434,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex25)
    <=> v1054(VarCurr,bitIndex25) ) ).

fof(addAssignment_433,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex25)
    <=> v1056(VarCurr,bitIndex25) ) ).

fof(addAssignment_432,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex25)
    <=> v1058(VarCurr,bitIndex25) ) ).

fof(addAssignment_431,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex25)
    <=> v1652(VarCurr,bitIndex25) ) ).

fof(addAssignment_430,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex24)
    <=> v1052(VarCurr,bitIndex24) ) ).

fof(addAssignment_429,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex24)
    <=> v1054(VarCurr,bitIndex24) ) ).

fof(addAssignment_428,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex24)
    <=> v1056(VarCurr,bitIndex24) ) ).

fof(addAssignment_427,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex24)
    <=> v1058(VarCurr,bitIndex24) ) ).

fof(addAssignment_426,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex24)
    <=> v1652(VarCurr,bitIndex24) ) ).

fof(addAssignment_425,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex23)
    <=> v1052(VarCurr,bitIndex23) ) ).

fof(addAssignment_424,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex23)
    <=> v1054(VarCurr,bitIndex23) ) ).

fof(addAssignment_423,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex23)
    <=> v1056(VarCurr,bitIndex23) ) ).

fof(addAssignment_422,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex23)
    <=> v1058(VarCurr,bitIndex23) ) ).

fof(addAssignment_421,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex23)
    <=> v1652(VarCurr,bitIndex23) ) ).

fof(addAssignment_420,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex22)
    <=> v1052(VarCurr,bitIndex22) ) ).

fof(addAssignment_419,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex22)
    <=> v1054(VarCurr,bitIndex22) ) ).

fof(addAssignment_418,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex22)
    <=> v1056(VarCurr,bitIndex22) ) ).

fof(addAssignment_417,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex22)
    <=> v1058(VarCurr,bitIndex22) ) ).

fof(addAssignment_416,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex22)
    <=> v1652(VarCurr,bitIndex22) ) ).

fof(addAssignment_415,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex21)
    <=> v1052(VarCurr,bitIndex21) ) ).

fof(addAssignment_414,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex21)
    <=> v1054(VarCurr,bitIndex21) ) ).

fof(addAssignment_413,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex21)
    <=> v1056(VarCurr,bitIndex21) ) ).

fof(addAssignment_412,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex21)
    <=> v1058(VarCurr,bitIndex21) ) ).

fof(addAssignment_411,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex21)
    <=> v1652(VarCurr,bitIndex21) ) ).

fof(addAssignment_410,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex20)
    <=> v1052(VarCurr,bitIndex20) ) ).

fof(addAssignment_409,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex20)
    <=> v1054(VarCurr,bitIndex20) ) ).

fof(addAssignment_408,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex20)
    <=> v1056(VarCurr,bitIndex20) ) ).

fof(addAssignment_407,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex20)
    <=> v1058(VarCurr,bitIndex20) ) ).

fof(addAssignment_406,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex20)
    <=> v1652(VarCurr,bitIndex20) ) ).

fof(addAssignment_405,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex19)
    <=> v1052(VarCurr,bitIndex19) ) ).

fof(addAssignment_404,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex19)
    <=> v1054(VarCurr,bitIndex19) ) ).

fof(addAssignment_403,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex19)
    <=> v1056(VarCurr,bitIndex19) ) ).

fof(addAssignment_402,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex19)
    <=> v1058(VarCurr,bitIndex19) ) ).

fof(addAssignment_401,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex19)
    <=> v1652(VarCurr,bitIndex19) ) ).

fof(addAssignment_400,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex18)
    <=> v1052(VarCurr,bitIndex18) ) ).

fof(addAssignment_399,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex18)
    <=> v1054(VarCurr,bitIndex18) ) ).

fof(addAssignment_398,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex18)
    <=> v1056(VarCurr,bitIndex18) ) ).

fof(addAssignment_397,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex18)
    <=> v1058(VarCurr,bitIndex18) ) ).

fof(addAssignment_396,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex18)
    <=> v1652(VarCurr,bitIndex18) ) ).

fof(addAssignment_395,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex17)
    <=> v1052(VarCurr,bitIndex17) ) ).

fof(addAssignment_394,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex17)
    <=> v1054(VarCurr,bitIndex17) ) ).

fof(addAssignment_393,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex17)
    <=> v1056(VarCurr,bitIndex17) ) ).

fof(addAssignment_392,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex17)
    <=> v1058(VarCurr,bitIndex17) ) ).

fof(addAssignment_391,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex17)
    <=> v1652(VarCurr,bitIndex17) ) ).

fof(addAssignment_390,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex16)
    <=> v1052(VarCurr,bitIndex16) ) ).

fof(addAssignment_389,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex16)
    <=> v1054(VarCurr,bitIndex16) ) ).

fof(addAssignment_388,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex16)
    <=> v1056(VarCurr,bitIndex16) ) ).

fof(addAssignment_387,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex16)
    <=> v1058(VarCurr,bitIndex16) ) ).

fof(addAssignment_386,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex16)
    <=> v1652(VarCurr,bitIndex16) ) ).

fof(addAssignment_385,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex15)
    <=> v1052(VarCurr,bitIndex15) ) ).

fof(addAssignment_384,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex15)
    <=> v1054(VarCurr,bitIndex15) ) ).

fof(addAssignment_383,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex15)
    <=> v1056(VarCurr,bitIndex15) ) ).

fof(addAssignment_382,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex15)
    <=> v1058(VarCurr,bitIndex15) ) ).

fof(addAssignment_381,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex15)
    <=> v1652(VarCurr,bitIndex15) ) ).

fof(addAssignment_380,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex14)
    <=> v1052(VarCurr,bitIndex14) ) ).

fof(addAssignment_379,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex14)
    <=> v1054(VarCurr,bitIndex14) ) ).

fof(addAssignment_378,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex14)
    <=> v1056(VarCurr,bitIndex14) ) ).

fof(addAssignment_377,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex14)
    <=> v1058(VarCurr,bitIndex14) ) ).

fof(addAssignment_376,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex14)
    <=> v1652(VarCurr,bitIndex14) ) ).

fof(addAssignment_375,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex13)
    <=> v1052(VarCurr,bitIndex13) ) ).

fof(addAssignment_374,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex13)
    <=> v1054(VarCurr,bitIndex13) ) ).

fof(addAssignment_373,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex13)
    <=> v1056(VarCurr,bitIndex13) ) ).

fof(addAssignment_372,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex13)
    <=> v1058(VarCurr,bitIndex13) ) ).

fof(addAssignment_371,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex13)
    <=> v1652(VarCurr,bitIndex13) ) ).

fof(addAssignment_370,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex12)
    <=> v1052(VarCurr,bitIndex12) ) ).

fof(addAssignment_369,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex12)
    <=> v1054(VarCurr,bitIndex12) ) ).

fof(addAssignment_368,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex12)
    <=> v1056(VarCurr,bitIndex12) ) ).

fof(addAssignment_367,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex12)
    <=> v1058(VarCurr,bitIndex12) ) ).

fof(addAssignment_366,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex12)
    <=> v1652(VarCurr,bitIndex12) ) ).

fof(addAssignment_365,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex11)
    <=> v1052(VarCurr,bitIndex11) ) ).

fof(addAssignment_364,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex11)
    <=> v1054(VarCurr,bitIndex11) ) ).

fof(addAssignment_363,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex11)
    <=> v1056(VarCurr,bitIndex11) ) ).

fof(addAssignment_362,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex11)
    <=> v1058(VarCurr,bitIndex11) ) ).

fof(addAssignment_361,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex11)
    <=> v1652(VarCurr,bitIndex11) ) ).

fof(addAssignment_360,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex10)
    <=> v1052(VarCurr,bitIndex10) ) ).

fof(addAssignment_359,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex10)
    <=> v1054(VarCurr,bitIndex10) ) ).

fof(addAssignment_358,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex10)
    <=> v1056(VarCurr,bitIndex10) ) ).

fof(addAssignment_357,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex10)
    <=> v1058(VarCurr,bitIndex10) ) ).

fof(addAssignment_356,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex10)
    <=> v1652(VarCurr,bitIndex10) ) ).

fof(addAssignment_355,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex9)
    <=> v1052(VarCurr,bitIndex9) ) ).

fof(addAssignment_354,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex9)
    <=> v1054(VarCurr,bitIndex9) ) ).

fof(addAssignment_353,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex9)
    <=> v1056(VarCurr,bitIndex9) ) ).

fof(addAssignment_352,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex9)
    <=> v1058(VarCurr,bitIndex9) ) ).

fof(addAssignment_351,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex9)
    <=> v1652(VarCurr,bitIndex9) ) ).

fof(addAssignment_350,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex8)
    <=> v1052(VarCurr,bitIndex8) ) ).

fof(addAssignment_349,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex8)
    <=> v1054(VarCurr,bitIndex8) ) ).

fof(addAssignment_348,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex8)
    <=> v1056(VarCurr,bitIndex8) ) ).

fof(addAssignment_347,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex8)
    <=> v1058(VarCurr,bitIndex8) ) ).

fof(addAssignment_346,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex8)
    <=> v1652(VarCurr,bitIndex8) ) ).

fof(addAssignment_345,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex7)
    <=> v1052(VarCurr,bitIndex7) ) ).

fof(addAssignment_344,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex7)
    <=> v1054(VarCurr,bitIndex7) ) ).

fof(addAssignment_343,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex7)
    <=> v1056(VarCurr,bitIndex7) ) ).

fof(addAssignment_342,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex7)
    <=> v1058(VarCurr,bitIndex7) ) ).

fof(addAssignment_341,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex7)
    <=> v1652(VarCurr,bitIndex7) ) ).

fof(addAssignment_340,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex6)
    <=> v1052(VarCurr,bitIndex6) ) ).

fof(addAssignment_339,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex6)
    <=> v1054(VarCurr,bitIndex6) ) ).

fof(addAssignment_338,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex6)
    <=> v1056(VarCurr,bitIndex6) ) ).

fof(addAssignment_337,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex6)
    <=> v1058(VarCurr,bitIndex6) ) ).

fof(addAssignment_336,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex6)
    <=> v1652(VarCurr,bitIndex6) ) ).

fof(addAssignment_335,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex5)
    <=> v1052(VarCurr,bitIndex5) ) ).

fof(addAssignment_334,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex5)
    <=> v1054(VarCurr,bitIndex5) ) ).

fof(addAssignment_333,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex5)
    <=> v1056(VarCurr,bitIndex5) ) ).

fof(addAssignment_332,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex5)
    <=> v1058(VarCurr,bitIndex5) ) ).

fof(addAssignment_331,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex5)
    <=> v1652(VarCurr,bitIndex5) ) ).

fof(addAssignment_330,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex4)
    <=> v1052(VarCurr,bitIndex4) ) ).

fof(addAssignment_329,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex4)
    <=> v1054(VarCurr,bitIndex4) ) ).

fof(addAssignment_328,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex4)
    <=> v1056(VarCurr,bitIndex4) ) ).

fof(addAssignment_327,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex4)
    <=> v1058(VarCurr,bitIndex4) ) ).

fof(addAssignment_326,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex4)
    <=> v1652(VarCurr,bitIndex4) ) ).

fof(addAssignment_325,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex3)
    <=> v1052(VarCurr,bitIndex3) ) ).

fof(addAssignment_324,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex3)
    <=> v1054(VarCurr,bitIndex3) ) ).

fof(addAssignment_323,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex3)
    <=> v1056(VarCurr,bitIndex3) ) ).

fof(addAssignment_322,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex3)
    <=> v1058(VarCurr,bitIndex3) ) ).

fof(addAssignment_321,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex3)
    <=> v1652(VarCurr,bitIndex3) ) ).

fof(addAssignment_320,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex2)
    <=> v1052(VarCurr,bitIndex2) ) ).

fof(addAssignment_319,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex2)
    <=> v1054(VarCurr,bitIndex2) ) ).

fof(addAssignment_318,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex2)
    <=> v1056(VarCurr,bitIndex2) ) ).

fof(addAssignment_317,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex2)
    <=> v1058(VarCurr,bitIndex2) ) ).

fof(addAssignment_316,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex2)
    <=> v1652(VarCurr,bitIndex2) ) ).

fof(addAssignment_315,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex1)
    <=> v1052(VarCurr,bitIndex1) ) ).

fof(addAssignment_314,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex1)
    <=> v1054(VarCurr,bitIndex1) ) ).

fof(addAssignment_313,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex1)
    <=> v1056(VarCurr,bitIndex1) ) ).

fof(addAssignment_312,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex1)
    <=> v1058(VarCurr,bitIndex1) ) ).

fof(addAssignment_311,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex1)
    <=> v1652(VarCurr,bitIndex1) ) ).

fof(addAssignment_310,axiom,
    ! [VarCurr] :
      ( v1050(VarCurr,bitIndex0)
    <=> v1052(VarCurr,bitIndex0) ) ).

fof(addAssignment_309,axiom,
    ! [VarCurr] :
      ( v1052(VarCurr,bitIndex0)
    <=> v1054(VarCurr,bitIndex0) ) ).

fof(addAssignment_308,axiom,
    ! [VarCurr] :
      ( v1054(VarCurr,bitIndex0)
    <=> v1056(VarCurr,bitIndex0) ) ).

fof(addAssignment_307,axiom,
    ! [VarCurr] :
      ( v1056(VarCurr,bitIndex0)
    <=> v1058(VarCurr,bitIndex0) ) ).

fof(addAssignment_306,axiom,
    ! [VarCurr] :
      ( v1058(VarCurr,bitIndex0)
    <=> v1652(VarCurr,bitIndex0) ) ).

fof(memoryReadIntoBuffer_33,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00000_address_term = A
             => ( range_43_0(B)
               => ( v1329(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_32,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00001_address_term = A
             => ( range_43_0(B)
               => ( v1339(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_31,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00010_address_term = A
             => ( range_43_0(B)
               => ( v1349(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_30,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00011_address_term = A
             => ( range_43_0(B)
               => ( v1359(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_29,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00100_address_term = A
             => ( range_43_0(B)
               => ( v1369(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_28,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00101_address_term = A
             => ( range_43_0(B)
               => ( v1379(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_27,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00110_address_term = A
             => ( range_43_0(B)
               => ( v1389(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_26,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00111_address_term = A
             => ( range_43_0(B)
               => ( v1399(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_25,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01000_address_term = A
             => ( range_43_0(B)
               => ( v1409(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_24,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01001_address_term = A
             => ( range_43_0(B)
               => ( v1419(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_23,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01010_address_term = A
             => ( range_43_0(B)
               => ( v1429(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_22,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01011_address_term = A
             => ( range_43_0(B)
               => ( v1439(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_21,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01100_address_term = A
             => ( range_43_0(B)
               => ( v1449(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_20,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01101_address_term = A
             => ( range_43_0(B)
               => ( v1459(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_19,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01110_address_term = A
             => ( range_43_0(B)
               => ( v1469(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_18,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01111_address_term = A
             => ( range_43_0(B)
               => ( v1479(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_17,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10000_address_term = A
             => ( range_43_0(B)
               => ( v1489(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_16,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10001_address_term = A
             => ( range_43_0(B)
               => ( v1499(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_15,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10010_address_term = A
             => ( range_43_0(B)
               => ( v1509(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_14,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10011_address_term = A
             => ( range_43_0(B)
               => ( v1519(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_13,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10100_address_term = A
             => ( range_43_0(B)
               => ( v1529(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_12,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10101_address_term = A
             => ( range_43_0(B)
               => ( v1539(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_11,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10110_address_term = A
             => ( range_43_0(B)
               => ( v1549(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_10,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10111_address_term = A
             => ( range_43_0(B)
               => ( v1559(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_9,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11000_address_term = A
             => ( range_43_0(B)
               => ( v1569(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_8,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11001_address_term = A
             => ( range_43_0(B)
               => ( v1579(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_7,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11010_address_term = A
             => ( range_43_0(B)
               => ( v1589(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_6,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11011_address_term = A
             => ( range_43_0(B)
               => ( v1599(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_5,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11100_address_term = A
             => ( range_43_0(B)
               => ( v1609(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_4,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11101_address_term = A
             => ( range_43_0(B)
               => ( v1619(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_3,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11110_address_term = A
             => ( range_43_0(B)
               => ( v1629(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_2,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11111_address_term = A
             => ( range_43_0(B)
               => ( v1639(VarNext,B)
                <=> v1060_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_1,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v1115_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( address(A)
             => ! [B] :
                  ( A = AssociatedAddressVar
                 => ( range_43_0(B)
                   => ( v1652(VarNext,B)
                    <=> v1060_array(VarNext,A,B) ) ) ) ) ) ) ).

fof(memoryReadIntoBuffer,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v1097_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( address(A)
             => ! [B] :
                  ( A = AssociatedAddressVar
                 => ( range_43_0(B)
                   => ( v1650(VarNext,B)
                    <=> v1060_array(VarNext,A,B) ) ) ) ) ) ) ).

fof(memoryConstantWriteDisabled,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( $true
              & v1642(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_array(VarNext,A,B)
              <=> v1060_36__array(VarNext,A,B) ) ) ) ) ).

fof(memoryConstantWriteEnabledInsideRange,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( $true
            & v1642(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_array(VarNext,A,B)
              <=> b00000000000000000000000000000000000000000000(B) ) ) ) ) ).

fof(bitBlastConstant_597,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex43) ).

fof(bitBlastConstant_596,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex42) ).

fof(bitBlastConstant_595,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex41) ).

fof(bitBlastConstant_594,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex40) ).

fof(bitBlastConstant_593,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex39) ).

fof(bitBlastConstant_592,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex38) ).

fof(bitBlastConstant_591,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex37) ).

fof(bitBlastConstant_590,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex36) ).

fof(bitBlastConstant_589,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex35) ).

fof(bitBlastConstant_588,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex34) ).

fof(bitBlastConstant_587,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex33) ).

fof(bitBlastConstant_586,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex32) ).

fof(bitBlastConstant_585,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex31) ).

fof(bitBlastConstant_584,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex30) ).

fof(bitBlastConstant_583,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex29) ).

fof(bitBlastConstant_582,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex28) ).

fof(bitBlastConstant_581,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex27) ).

fof(bitBlastConstant_580,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex26) ).

fof(bitBlastConstant_579,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex25) ).

fof(bitBlastConstant_578,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex24) ).

fof(bitBlastConstant_577,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex23) ).

fof(bitBlastConstant_576,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex22) ).

fof(bitBlastConstant_575,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex21) ).

fof(bitBlastConstant_574,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex20) ).

fof(bitBlastConstant_573,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex19) ).

fof(bitBlastConstant_572,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex18) ).

fof(bitBlastConstant_571,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex17) ).

fof(bitBlastConstant_570,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex16) ).

fof(bitBlastConstant_569,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex15) ).

fof(bitBlastConstant_568,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex14) ).

fof(bitBlastConstant_567,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex13) ).

fof(bitBlastConstant_566,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex12) ).

fof(bitBlastConstant_565,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex11) ).

fof(bitBlastConstant_564,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex10) ).

fof(bitBlastConstant_563,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex9) ).

fof(bitBlastConstant_562,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex8) ).

fof(bitBlastConstant_561,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex7) ).

fof(bitBlastConstant_560,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex6) ).

fof(bitBlastConstant_559,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex5) ).

fof(bitBlastConstant_558,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex4) ).

fof(bitBlastConstant_557,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex3) ).

fof(bitBlastConstant_556,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex2) ).

fof(bitBlastConstant_555,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex1) ).

fof(bitBlastConstant_554,axiom,
    ~ b00000000000000000000000000000000000000000000(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_196,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1642(VarNext)
      <=> ( v1643(VarNext)
          & v1648(VarNext) ) ) ) ).

fof(addAssignment_305,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1648(VarNext)
      <=> v1282(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_195,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1643(VarNext)
      <=> ( v1645(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_76,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1645(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_35,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11111_address_term = A
              & v1632(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_36__array(VarNext,A,B)
              <=> v1060_35__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_35,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11111_address_term = A
            & v1632(VarNext) )
         => ( ( v1060_36__array(VarNext,A,bitIndex43)
            <=> v1639(VarNext,bitIndex1407) )
            & ( v1060_36__array(VarNext,A,bitIndex42)
            <=> v1639(VarNext,bitIndex1406) )
            & ( v1060_36__array(VarNext,A,bitIndex41)
            <=> v1639(VarNext,bitIndex1405) )
            & ( v1060_36__array(VarNext,A,bitIndex40)
            <=> v1639(VarNext,bitIndex1404) )
            & ( v1060_36__array(VarNext,A,bitIndex39)
            <=> v1639(VarNext,bitIndex1403) )
            & ( v1060_36__array(VarNext,A,bitIndex38)
            <=> v1639(VarNext,bitIndex1402) )
            & ( v1060_36__array(VarNext,A,bitIndex37)
            <=> v1639(VarNext,bitIndex1401) )
            & ( v1060_36__array(VarNext,A,bitIndex36)
            <=> v1639(VarNext,bitIndex1400) )
            & ( v1060_36__array(VarNext,A,bitIndex35)
            <=> v1639(VarNext,bitIndex1399) )
            & ( v1060_36__array(VarNext,A,bitIndex34)
            <=> v1639(VarNext,bitIndex1398) )
            & ( v1060_36__array(VarNext,A,bitIndex33)
            <=> v1639(VarNext,bitIndex1397) )
            & ( v1060_36__array(VarNext,A,bitIndex32)
            <=> v1639(VarNext,bitIndex1396) )
            & ( v1060_36__array(VarNext,A,bitIndex31)
            <=> v1639(VarNext,bitIndex1395) )
            & ( v1060_36__array(VarNext,A,bitIndex30)
            <=> v1639(VarNext,bitIndex1394) )
            & ( v1060_36__array(VarNext,A,bitIndex29)
            <=> v1639(VarNext,bitIndex1393) )
            & ( v1060_36__array(VarNext,A,bitIndex28)
            <=> v1639(VarNext,bitIndex1392) )
            & ( v1060_36__array(VarNext,A,bitIndex27)
            <=> v1639(VarNext,bitIndex1391) )
            & ( v1060_36__array(VarNext,A,bitIndex26)
            <=> v1639(VarNext,bitIndex1390) )
            & ( v1060_36__array(VarNext,A,bitIndex25)
            <=> v1639(VarNext,bitIndex1389) )
            & ( v1060_36__array(VarNext,A,bitIndex24)
            <=> v1639(VarNext,bitIndex1388) )
            & ( v1060_36__array(VarNext,A,bitIndex23)
            <=> v1639(VarNext,bitIndex1387) )
            & ( v1060_36__array(VarNext,A,bitIndex22)
            <=> v1639(VarNext,bitIndex1386) )
            & ( v1060_36__array(VarNext,A,bitIndex21)
            <=> v1639(VarNext,bitIndex1385) )
            & ( v1060_36__array(VarNext,A,bitIndex20)
            <=> v1639(VarNext,bitIndex1384) )
            & ( v1060_36__array(VarNext,A,bitIndex19)
            <=> v1639(VarNext,bitIndex1383) )
            & ( v1060_36__array(VarNext,A,bitIndex18)
            <=> v1639(VarNext,bitIndex1382) )
            & ( v1060_36__array(VarNext,A,bitIndex17)
            <=> v1639(VarNext,bitIndex1381) )
            & ( v1060_36__array(VarNext,A,bitIndex16)
            <=> v1639(VarNext,bitIndex1380) )
            & ( v1060_36__array(VarNext,A,bitIndex15)
            <=> v1639(VarNext,bitIndex1379) )
            & ( v1060_36__array(VarNext,A,bitIndex14)
            <=> v1639(VarNext,bitIndex1378) )
            & ( v1060_36__array(VarNext,A,bitIndex13)
            <=> v1639(VarNext,bitIndex1377) )
            & ( v1060_36__array(VarNext,A,bitIndex12)
            <=> v1639(VarNext,bitIndex1376) )
            & ( v1060_36__array(VarNext,A,bitIndex11)
            <=> v1639(VarNext,bitIndex1375) )
            & ( v1060_36__array(VarNext,A,bitIndex10)
            <=> v1639(VarNext,bitIndex1374) )
            & ( v1060_36__array(VarNext,A,bitIndex9)
            <=> v1639(VarNext,bitIndex1373) )
            & ( v1060_36__array(VarNext,A,bitIndex8)
            <=> v1639(VarNext,bitIndex1372) )
            & ( v1060_36__array(VarNext,A,bitIndex7)
            <=> v1639(VarNext,bitIndex1371) )
            & ( v1060_36__array(VarNext,A,bitIndex6)
            <=> v1639(VarNext,bitIndex1370) )
            & ( v1060_36__array(VarNext,A,bitIndex5)
            <=> v1639(VarNext,bitIndex1369) )
            & ( v1060_36__array(VarNext,A,bitIndex4)
            <=> v1639(VarNext,bitIndex1368) )
            & ( v1060_36__array(VarNext,A,bitIndex3)
            <=> v1639(VarNext,bitIndex1367) )
            & ( v1060_36__array(VarNext,A,bitIndex2)
            <=> v1639(VarNext,bitIndex1366) )
            & ( v1060_36__array(VarNext,A,bitIndex1)
            <=> v1639(VarNext,bitIndex1365) )
            & ( v1060_36__array(VarNext,A,bitIndex0)
            <=> v1639(VarNext,bitIndex1364) ) ) ) ) ).

fof(bitBlastConstant_553,axiom,
    b11111(bitIndex4) ).

fof(bitBlastConstant_552,axiom,
    b11111(bitIndex3) ).

fof(bitBlastConstant_551,axiom,
    b11111(bitIndex2) ).

fof(bitBlastConstant_550,axiom,
    b11111(bitIndex1) ).

fof(bitBlastConstant_549,axiom,
    b11111(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_194,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1632(VarNext)
      <=> ( v1633(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_193,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1633(VarNext)
      <=> ( v1635(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_75,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1635(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_34,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11110_address_term = A
              & v1622(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_35__array(VarNext,A,B)
              <=> v1060_34__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_34,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11110_address_term = A
            & v1622(VarNext) )
         => ( ( v1060_35__array(VarNext,A,bitIndex43)
            <=> v1629(VarNext,bitIndex1363) )
            & ( v1060_35__array(VarNext,A,bitIndex42)
            <=> v1629(VarNext,bitIndex1362) )
            & ( v1060_35__array(VarNext,A,bitIndex41)
            <=> v1629(VarNext,bitIndex1361) )
            & ( v1060_35__array(VarNext,A,bitIndex40)
            <=> v1629(VarNext,bitIndex1360) )
            & ( v1060_35__array(VarNext,A,bitIndex39)
            <=> v1629(VarNext,bitIndex1359) )
            & ( v1060_35__array(VarNext,A,bitIndex38)
            <=> v1629(VarNext,bitIndex1358) )
            & ( v1060_35__array(VarNext,A,bitIndex37)
            <=> v1629(VarNext,bitIndex1357) )
            & ( v1060_35__array(VarNext,A,bitIndex36)
            <=> v1629(VarNext,bitIndex1356) )
            & ( v1060_35__array(VarNext,A,bitIndex35)
            <=> v1629(VarNext,bitIndex1355) )
            & ( v1060_35__array(VarNext,A,bitIndex34)
            <=> v1629(VarNext,bitIndex1354) )
            & ( v1060_35__array(VarNext,A,bitIndex33)
            <=> v1629(VarNext,bitIndex1353) )
            & ( v1060_35__array(VarNext,A,bitIndex32)
            <=> v1629(VarNext,bitIndex1352) )
            & ( v1060_35__array(VarNext,A,bitIndex31)
            <=> v1629(VarNext,bitIndex1351) )
            & ( v1060_35__array(VarNext,A,bitIndex30)
            <=> v1629(VarNext,bitIndex1350) )
            & ( v1060_35__array(VarNext,A,bitIndex29)
            <=> v1629(VarNext,bitIndex1349) )
            & ( v1060_35__array(VarNext,A,bitIndex28)
            <=> v1629(VarNext,bitIndex1348) )
            & ( v1060_35__array(VarNext,A,bitIndex27)
            <=> v1629(VarNext,bitIndex1347) )
            & ( v1060_35__array(VarNext,A,bitIndex26)
            <=> v1629(VarNext,bitIndex1346) )
            & ( v1060_35__array(VarNext,A,bitIndex25)
            <=> v1629(VarNext,bitIndex1345) )
            & ( v1060_35__array(VarNext,A,bitIndex24)
            <=> v1629(VarNext,bitIndex1344) )
            & ( v1060_35__array(VarNext,A,bitIndex23)
            <=> v1629(VarNext,bitIndex1343) )
            & ( v1060_35__array(VarNext,A,bitIndex22)
            <=> v1629(VarNext,bitIndex1342) )
            & ( v1060_35__array(VarNext,A,bitIndex21)
            <=> v1629(VarNext,bitIndex1341) )
            & ( v1060_35__array(VarNext,A,bitIndex20)
            <=> v1629(VarNext,bitIndex1340) )
            & ( v1060_35__array(VarNext,A,bitIndex19)
            <=> v1629(VarNext,bitIndex1339) )
            & ( v1060_35__array(VarNext,A,bitIndex18)
            <=> v1629(VarNext,bitIndex1338) )
            & ( v1060_35__array(VarNext,A,bitIndex17)
            <=> v1629(VarNext,bitIndex1337) )
            & ( v1060_35__array(VarNext,A,bitIndex16)
            <=> v1629(VarNext,bitIndex1336) )
            & ( v1060_35__array(VarNext,A,bitIndex15)
            <=> v1629(VarNext,bitIndex1335) )
            & ( v1060_35__array(VarNext,A,bitIndex14)
            <=> v1629(VarNext,bitIndex1334) )
            & ( v1060_35__array(VarNext,A,bitIndex13)
            <=> v1629(VarNext,bitIndex1333) )
            & ( v1060_35__array(VarNext,A,bitIndex12)
            <=> v1629(VarNext,bitIndex1332) )
            & ( v1060_35__array(VarNext,A,bitIndex11)
            <=> v1629(VarNext,bitIndex1331) )
            & ( v1060_35__array(VarNext,A,bitIndex10)
            <=> v1629(VarNext,bitIndex1330) )
            & ( v1060_35__array(VarNext,A,bitIndex9)
            <=> v1629(VarNext,bitIndex1329) )
            & ( v1060_35__array(VarNext,A,bitIndex8)
            <=> v1629(VarNext,bitIndex1328) )
            & ( v1060_35__array(VarNext,A,bitIndex7)
            <=> v1629(VarNext,bitIndex1327) )
            & ( v1060_35__array(VarNext,A,bitIndex6)
            <=> v1629(VarNext,bitIndex1326) )
            & ( v1060_35__array(VarNext,A,bitIndex5)
            <=> v1629(VarNext,bitIndex1325) )
            & ( v1060_35__array(VarNext,A,bitIndex4)
            <=> v1629(VarNext,bitIndex1324) )
            & ( v1060_35__array(VarNext,A,bitIndex3)
            <=> v1629(VarNext,bitIndex1323) )
            & ( v1060_35__array(VarNext,A,bitIndex2)
            <=> v1629(VarNext,bitIndex1322) )
            & ( v1060_35__array(VarNext,A,bitIndex1)
            <=> v1629(VarNext,bitIndex1321) )
            & ( v1060_35__array(VarNext,A,bitIndex0)
            <=> v1629(VarNext,bitIndex1320) ) ) ) ) ).

fof(bitBlastConstant_548,axiom,
    b11110(bitIndex4) ).

fof(bitBlastConstant_547,axiom,
    b11110(bitIndex3) ).

fof(bitBlastConstant_546,axiom,
    b11110(bitIndex2) ).

fof(bitBlastConstant_545,axiom,
    b11110(bitIndex1) ).

fof(bitBlastConstant_544,axiom,
    ~ b11110(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_192,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1622(VarNext)
      <=> ( v1623(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_191,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1623(VarNext)
      <=> ( v1625(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_74,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1625(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_33,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11101_address_term = A
              & v1612(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_34__array(VarNext,A,B)
              <=> v1060_33__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_33,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11101_address_term = A
            & v1612(VarNext) )
         => ( ( v1060_34__array(VarNext,A,bitIndex43)
            <=> v1619(VarNext,bitIndex1319) )
            & ( v1060_34__array(VarNext,A,bitIndex42)
            <=> v1619(VarNext,bitIndex1318) )
            & ( v1060_34__array(VarNext,A,bitIndex41)
            <=> v1619(VarNext,bitIndex1317) )
            & ( v1060_34__array(VarNext,A,bitIndex40)
            <=> v1619(VarNext,bitIndex1316) )
            & ( v1060_34__array(VarNext,A,bitIndex39)
            <=> v1619(VarNext,bitIndex1315) )
            & ( v1060_34__array(VarNext,A,bitIndex38)
            <=> v1619(VarNext,bitIndex1314) )
            & ( v1060_34__array(VarNext,A,bitIndex37)
            <=> v1619(VarNext,bitIndex1313) )
            & ( v1060_34__array(VarNext,A,bitIndex36)
            <=> v1619(VarNext,bitIndex1312) )
            & ( v1060_34__array(VarNext,A,bitIndex35)
            <=> v1619(VarNext,bitIndex1311) )
            & ( v1060_34__array(VarNext,A,bitIndex34)
            <=> v1619(VarNext,bitIndex1310) )
            & ( v1060_34__array(VarNext,A,bitIndex33)
            <=> v1619(VarNext,bitIndex1309) )
            & ( v1060_34__array(VarNext,A,bitIndex32)
            <=> v1619(VarNext,bitIndex1308) )
            & ( v1060_34__array(VarNext,A,bitIndex31)
            <=> v1619(VarNext,bitIndex1307) )
            & ( v1060_34__array(VarNext,A,bitIndex30)
            <=> v1619(VarNext,bitIndex1306) )
            & ( v1060_34__array(VarNext,A,bitIndex29)
            <=> v1619(VarNext,bitIndex1305) )
            & ( v1060_34__array(VarNext,A,bitIndex28)
            <=> v1619(VarNext,bitIndex1304) )
            & ( v1060_34__array(VarNext,A,bitIndex27)
            <=> v1619(VarNext,bitIndex1303) )
            & ( v1060_34__array(VarNext,A,bitIndex26)
            <=> v1619(VarNext,bitIndex1302) )
            & ( v1060_34__array(VarNext,A,bitIndex25)
            <=> v1619(VarNext,bitIndex1301) )
            & ( v1060_34__array(VarNext,A,bitIndex24)
            <=> v1619(VarNext,bitIndex1300) )
            & ( v1060_34__array(VarNext,A,bitIndex23)
            <=> v1619(VarNext,bitIndex1299) )
            & ( v1060_34__array(VarNext,A,bitIndex22)
            <=> v1619(VarNext,bitIndex1298) )
            & ( v1060_34__array(VarNext,A,bitIndex21)
            <=> v1619(VarNext,bitIndex1297) )
            & ( v1060_34__array(VarNext,A,bitIndex20)
            <=> v1619(VarNext,bitIndex1296) )
            & ( v1060_34__array(VarNext,A,bitIndex19)
            <=> v1619(VarNext,bitIndex1295) )
            & ( v1060_34__array(VarNext,A,bitIndex18)
            <=> v1619(VarNext,bitIndex1294) )
            & ( v1060_34__array(VarNext,A,bitIndex17)
            <=> v1619(VarNext,bitIndex1293) )
            & ( v1060_34__array(VarNext,A,bitIndex16)
            <=> v1619(VarNext,bitIndex1292) )
            & ( v1060_34__array(VarNext,A,bitIndex15)
            <=> v1619(VarNext,bitIndex1291) )
            & ( v1060_34__array(VarNext,A,bitIndex14)
            <=> v1619(VarNext,bitIndex1290) )
            & ( v1060_34__array(VarNext,A,bitIndex13)
            <=> v1619(VarNext,bitIndex1289) )
            & ( v1060_34__array(VarNext,A,bitIndex12)
            <=> v1619(VarNext,bitIndex1288) )
            & ( v1060_34__array(VarNext,A,bitIndex11)
            <=> v1619(VarNext,bitIndex1287) )
            & ( v1060_34__array(VarNext,A,bitIndex10)
            <=> v1619(VarNext,bitIndex1286) )
            & ( v1060_34__array(VarNext,A,bitIndex9)
            <=> v1619(VarNext,bitIndex1285) )
            & ( v1060_34__array(VarNext,A,bitIndex8)
            <=> v1619(VarNext,bitIndex1284) )
            & ( v1060_34__array(VarNext,A,bitIndex7)
            <=> v1619(VarNext,bitIndex1283) )
            & ( v1060_34__array(VarNext,A,bitIndex6)
            <=> v1619(VarNext,bitIndex1282) )
            & ( v1060_34__array(VarNext,A,bitIndex5)
            <=> v1619(VarNext,bitIndex1281) )
            & ( v1060_34__array(VarNext,A,bitIndex4)
            <=> v1619(VarNext,bitIndex1280) )
            & ( v1060_34__array(VarNext,A,bitIndex3)
            <=> v1619(VarNext,bitIndex1279) )
            & ( v1060_34__array(VarNext,A,bitIndex2)
            <=> v1619(VarNext,bitIndex1278) )
            & ( v1060_34__array(VarNext,A,bitIndex1)
            <=> v1619(VarNext,bitIndex1277) )
            & ( v1060_34__array(VarNext,A,bitIndex0)
            <=> v1619(VarNext,bitIndex1276) ) ) ) ) ).

fof(bitBlastConstant_543,axiom,
    b11101(bitIndex4) ).

fof(bitBlastConstant_542,axiom,
    b11101(bitIndex3) ).

fof(bitBlastConstant_541,axiom,
    b11101(bitIndex2) ).

fof(bitBlastConstant_540,axiom,
    ~ b11101(bitIndex1) ).

fof(bitBlastConstant_539,axiom,
    b11101(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_190,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1612(VarNext)
      <=> ( v1613(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_189,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1613(VarNext)
      <=> ( v1615(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_73,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1615(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_32,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11100_address_term = A
              & v1602(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_33__array(VarNext,A,B)
              <=> v1060_32__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_32,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11100_address_term = A
            & v1602(VarNext) )
         => ( ( v1060_33__array(VarNext,A,bitIndex43)
            <=> v1609(VarNext,bitIndex1275) )
            & ( v1060_33__array(VarNext,A,bitIndex42)
            <=> v1609(VarNext,bitIndex1274) )
            & ( v1060_33__array(VarNext,A,bitIndex41)
            <=> v1609(VarNext,bitIndex1273) )
            & ( v1060_33__array(VarNext,A,bitIndex40)
            <=> v1609(VarNext,bitIndex1272) )
            & ( v1060_33__array(VarNext,A,bitIndex39)
            <=> v1609(VarNext,bitIndex1271) )
            & ( v1060_33__array(VarNext,A,bitIndex38)
            <=> v1609(VarNext,bitIndex1270) )
            & ( v1060_33__array(VarNext,A,bitIndex37)
            <=> v1609(VarNext,bitIndex1269) )
            & ( v1060_33__array(VarNext,A,bitIndex36)
            <=> v1609(VarNext,bitIndex1268) )
            & ( v1060_33__array(VarNext,A,bitIndex35)
            <=> v1609(VarNext,bitIndex1267) )
            & ( v1060_33__array(VarNext,A,bitIndex34)
            <=> v1609(VarNext,bitIndex1266) )
            & ( v1060_33__array(VarNext,A,bitIndex33)
            <=> v1609(VarNext,bitIndex1265) )
            & ( v1060_33__array(VarNext,A,bitIndex32)
            <=> v1609(VarNext,bitIndex1264) )
            & ( v1060_33__array(VarNext,A,bitIndex31)
            <=> v1609(VarNext,bitIndex1263) )
            & ( v1060_33__array(VarNext,A,bitIndex30)
            <=> v1609(VarNext,bitIndex1262) )
            & ( v1060_33__array(VarNext,A,bitIndex29)
            <=> v1609(VarNext,bitIndex1261) )
            & ( v1060_33__array(VarNext,A,bitIndex28)
            <=> v1609(VarNext,bitIndex1260) )
            & ( v1060_33__array(VarNext,A,bitIndex27)
            <=> v1609(VarNext,bitIndex1259) )
            & ( v1060_33__array(VarNext,A,bitIndex26)
            <=> v1609(VarNext,bitIndex1258) )
            & ( v1060_33__array(VarNext,A,bitIndex25)
            <=> v1609(VarNext,bitIndex1257) )
            & ( v1060_33__array(VarNext,A,bitIndex24)
            <=> v1609(VarNext,bitIndex1256) )
            & ( v1060_33__array(VarNext,A,bitIndex23)
            <=> v1609(VarNext,bitIndex1255) )
            & ( v1060_33__array(VarNext,A,bitIndex22)
            <=> v1609(VarNext,bitIndex1254) )
            & ( v1060_33__array(VarNext,A,bitIndex21)
            <=> v1609(VarNext,bitIndex1253) )
            & ( v1060_33__array(VarNext,A,bitIndex20)
            <=> v1609(VarNext,bitIndex1252) )
            & ( v1060_33__array(VarNext,A,bitIndex19)
            <=> v1609(VarNext,bitIndex1251) )
            & ( v1060_33__array(VarNext,A,bitIndex18)
            <=> v1609(VarNext,bitIndex1250) )
            & ( v1060_33__array(VarNext,A,bitIndex17)
            <=> v1609(VarNext,bitIndex1249) )
            & ( v1060_33__array(VarNext,A,bitIndex16)
            <=> v1609(VarNext,bitIndex1248) )
            & ( v1060_33__array(VarNext,A,bitIndex15)
            <=> v1609(VarNext,bitIndex1247) )
            & ( v1060_33__array(VarNext,A,bitIndex14)
            <=> v1609(VarNext,bitIndex1246) )
            & ( v1060_33__array(VarNext,A,bitIndex13)
            <=> v1609(VarNext,bitIndex1245) )
            & ( v1060_33__array(VarNext,A,bitIndex12)
            <=> v1609(VarNext,bitIndex1244) )
            & ( v1060_33__array(VarNext,A,bitIndex11)
            <=> v1609(VarNext,bitIndex1243) )
            & ( v1060_33__array(VarNext,A,bitIndex10)
            <=> v1609(VarNext,bitIndex1242) )
            & ( v1060_33__array(VarNext,A,bitIndex9)
            <=> v1609(VarNext,bitIndex1241) )
            & ( v1060_33__array(VarNext,A,bitIndex8)
            <=> v1609(VarNext,bitIndex1240) )
            & ( v1060_33__array(VarNext,A,bitIndex7)
            <=> v1609(VarNext,bitIndex1239) )
            & ( v1060_33__array(VarNext,A,bitIndex6)
            <=> v1609(VarNext,bitIndex1238) )
            & ( v1060_33__array(VarNext,A,bitIndex5)
            <=> v1609(VarNext,bitIndex1237) )
            & ( v1060_33__array(VarNext,A,bitIndex4)
            <=> v1609(VarNext,bitIndex1236) )
            & ( v1060_33__array(VarNext,A,bitIndex3)
            <=> v1609(VarNext,bitIndex1235) )
            & ( v1060_33__array(VarNext,A,bitIndex2)
            <=> v1609(VarNext,bitIndex1234) )
            & ( v1060_33__array(VarNext,A,bitIndex1)
            <=> v1609(VarNext,bitIndex1233) )
            & ( v1060_33__array(VarNext,A,bitIndex0)
            <=> v1609(VarNext,bitIndex1232) ) ) ) ) ).

fof(bitBlastConstant_538,axiom,
    b11100(bitIndex4) ).

fof(bitBlastConstant_537,axiom,
    b11100(bitIndex3) ).

fof(bitBlastConstant_536,axiom,
    b11100(bitIndex2) ).

fof(bitBlastConstant_535,axiom,
    ~ b11100(bitIndex1) ).

fof(bitBlastConstant_534,axiom,
    ~ b11100(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_188,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1602(VarNext)
      <=> ( v1603(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_187,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1603(VarNext)
      <=> ( v1605(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_72,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1605(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_31,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11011_address_term = A
              & v1592(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_32__array(VarNext,A,B)
              <=> v1060_31__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_31,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11011_address_term = A
            & v1592(VarNext) )
         => ( ( v1060_32__array(VarNext,A,bitIndex43)
            <=> v1599(VarNext,bitIndex1231) )
            & ( v1060_32__array(VarNext,A,bitIndex42)
            <=> v1599(VarNext,bitIndex1230) )
            & ( v1060_32__array(VarNext,A,bitIndex41)
            <=> v1599(VarNext,bitIndex1229) )
            & ( v1060_32__array(VarNext,A,bitIndex40)
            <=> v1599(VarNext,bitIndex1228) )
            & ( v1060_32__array(VarNext,A,bitIndex39)
            <=> v1599(VarNext,bitIndex1227) )
            & ( v1060_32__array(VarNext,A,bitIndex38)
            <=> v1599(VarNext,bitIndex1226) )
            & ( v1060_32__array(VarNext,A,bitIndex37)
            <=> v1599(VarNext,bitIndex1225) )
            & ( v1060_32__array(VarNext,A,bitIndex36)
            <=> v1599(VarNext,bitIndex1224) )
            & ( v1060_32__array(VarNext,A,bitIndex35)
            <=> v1599(VarNext,bitIndex1223) )
            & ( v1060_32__array(VarNext,A,bitIndex34)
            <=> v1599(VarNext,bitIndex1222) )
            & ( v1060_32__array(VarNext,A,bitIndex33)
            <=> v1599(VarNext,bitIndex1221) )
            & ( v1060_32__array(VarNext,A,bitIndex32)
            <=> v1599(VarNext,bitIndex1220) )
            & ( v1060_32__array(VarNext,A,bitIndex31)
            <=> v1599(VarNext,bitIndex1219) )
            & ( v1060_32__array(VarNext,A,bitIndex30)
            <=> v1599(VarNext,bitIndex1218) )
            & ( v1060_32__array(VarNext,A,bitIndex29)
            <=> v1599(VarNext,bitIndex1217) )
            & ( v1060_32__array(VarNext,A,bitIndex28)
            <=> v1599(VarNext,bitIndex1216) )
            & ( v1060_32__array(VarNext,A,bitIndex27)
            <=> v1599(VarNext,bitIndex1215) )
            & ( v1060_32__array(VarNext,A,bitIndex26)
            <=> v1599(VarNext,bitIndex1214) )
            & ( v1060_32__array(VarNext,A,bitIndex25)
            <=> v1599(VarNext,bitIndex1213) )
            & ( v1060_32__array(VarNext,A,bitIndex24)
            <=> v1599(VarNext,bitIndex1212) )
            & ( v1060_32__array(VarNext,A,bitIndex23)
            <=> v1599(VarNext,bitIndex1211) )
            & ( v1060_32__array(VarNext,A,bitIndex22)
            <=> v1599(VarNext,bitIndex1210) )
            & ( v1060_32__array(VarNext,A,bitIndex21)
            <=> v1599(VarNext,bitIndex1209) )
            & ( v1060_32__array(VarNext,A,bitIndex20)
            <=> v1599(VarNext,bitIndex1208) )
            & ( v1060_32__array(VarNext,A,bitIndex19)
            <=> v1599(VarNext,bitIndex1207) )
            & ( v1060_32__array(VarNext,A,bitIndex18)
            <=> v1599(VarNext,bitIndex1206) )
            & ( v1060_32__array(VarNext,A,bitIndex17)
            <=> v1599(VarNext,bitIndex1205) )
            & ( v1060_32__array(VarNext,A,bitIndex16)
            <=> v1599(VarNext,bitIndex1204) )
            & ( v1060_32__array(VarNext,A,bitIndex15)
            <=> v1599(VarNext,bitIndex1203) )
            & ( v1060_32__array(VarNext,A,bitIndex14)
            <=> v1599(VarNext,bitIndex1202) )
            & ( v1060_32__array(VarNext,A,bitIndex13)
            <=> v1599(VarNext,bitIndex1201) )
            & ( v1060_32__array(VarNext,A,bitIndex12)
            <=> v1599(VarNext,bitIndex1200) )
            & ( v1060_32__array(VarNext,A,bitIndex11)
            <=> v1599(VarNext,bitIndex1199) )
            & ( v1060_32__array(VarNext,A,bitIndex10)
            <=> v1599(VarNext,bitIndex1198) )
            & ( v1060_32__array(VarNext,A,bitIndex9)
            <=> v1599(VarNext,bitIndex1197) )
            & ( v1060_32__array(VarNext,A,bitIndex8)
            <=> v1599(VarNext,bitIndex1196) )
            & ( v1060_32__array(VarNext,A,bitIndex7)
            <=> v1599(VarNext,bitIndex1195) )
            & ( v1060_32__array(VarNext,A,bitIndex6)
            <=> v1599(VarNext,bitIndex1194) )
            & ( v1060_32__array(VarNext,A,bitIndex5)
            <=> v1599(VarNext,bitIndex1193) )
            & ( v1060_32__array(VarNext,A,bitIndex4)
            <=> v1599(VarNext,bitIndex1192) )
            & ( v1060_32__array(VarNext,A,bitIndex3)
            <=> v1599(VarNext,bitIndex1191) )
            & ( v1060_32__array(VarNext,A,bitIndex2)
            <=> v1599(VarNext,bitIndex1190) )
            & ( v1060_32__array(VarNext,A,bitIndex1)
            <=> v1599(VarNext,bitIndex1189) )
            & ( v1060_32__array(VarNext,A,bitIndex0)
            <=> v1599(VarNext,bitIndex1188) ) ) ) ) ).

fof(bitBlastConstant_533,axiom,
    b11011(bitIndex4) ).

fof(bitBlastConstant_532,axiom,
    b11011(bitIndex3) ).

fof(bitBlastConstant_531,axiom,
    ~ b11011(bitIndex2) ).

fof(bitBlastConstant_530,axiom,
    b11011(bitIndex1) ).

fof(bitBlastConstant_529,axiom,
    b11011(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_186,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1592(VarNext)
      <=> ( v1593(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_185,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1593(VarNext)
      <=> ( v1595(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_71,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1595(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_30,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11010_address_term = A
              & v1582(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_31__array(VarNext,A,B)
              <=> v1060_30__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_30,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11010_address_term = A
            & v1582(VarNext) )
         => ( ( v1060_31__array(VarNext,A,bitIndex43)
            <=> v1589(VarNext,bitIndex1187) )
            & ( v1060_31__array(VarNext,A,bitIndex42)
            <=> v1589(VarNext,bitIndex1186) )
            & ( v1060_31__array(VarNext,A,bitIndex41)
            <=> v1589(VarNext,bitIndex1185) )
            & ( v1060_31__array(VarNext,A,bitIndex40)
            <=> v1589(VarNext,bitIndex1184) )
            & ( v1060_31__array(VarNext,A,bitIndex39)
            <=> v1589(VarNext,bitIndex1183) )
            & ( v1060_31__array(VarNext,A,bitIndex38)
            <=> v1589(VarNext,bitIndex1182) )
            & ( v1060_31__array(VarNext,A,bitIndex37)
            <=> v1589(VarNext,bitIndex1181) )
            & ( v1060_31__array(VarNext,A,bitIndex36)
            <=> v1589(VarNext,bitIndex1180) )
            & ( v1060_31__array(VarNext,A,bitIndex35)
            <=> v1589(VarNext,bitIndex1179) )
            & ( v1060_31__array(VarNext,A,bitIndex34)
            <=> v1589(VarNext,bitIndex1178) )
            & ( v1060_31__array(VarNext,A,bitIndex33)
            <=> v1589(VarNext,bitIndex1177) )
            & ( v1060_31__array(VarNext,A,bitIndex32)
            <=> v1589(VarNext,bitIndex1176) )
            & ( v1060_31__array(VarNext,A,bitIndex31)
            <=> v1589(VarNext,bitIndex1175) )
            & ( v1060_31__array(VarNext,A,bitIndex30)
            <=> v1589(VarNext,bitIndex1174) )
            & ( v1060_31__array(VarNext,A,bitIndex29)
            <=> v1589(VarNext,bitIndex1173) )
            & ( v1060_31__array(VarNext,A,bitIndex28)
            <=> v1589(VarNext,bitIndex1172) )
            & ( v1060_31__array(VarNext,A,bitIndex27)
            <=> v1589(VarNext,bitIndex1171) )
            & ( v1060_31__array(VarNext,A,bitIndex26)
            <=> v1589(VarNext,bitIndex1170) )
            & ( v1060_31__array(VarNext,A,bitIndex25)
            <=> v1589(VarNext,bitIndex1169) )
            & ( v1060_31__array(VarNext,A,bitIndex24)
            <=> v1589(VarNext,bitIndex1168) )
            & ( v1060_31__array(VarNext,A,bitIndex23)
            <=> v1589(VarNext,bitIndex1167) )
            & ( v1060_31__array(VarNext,A,bitIndex22)
            <=> v1589(VarNext,bitIndex1166) )
            & ( v1060_31__array(VarNext,A,bitIndex21)
            <=> v1589(VarNext,bitIndex1165) )
            & ( v1060_31__array(VarNext,A,bitIndex20)
            <=> v1589(VarNext,bitIndex1164) )
            & ( v1060_31__array(VarNext,A,bitIndex19)
            <=> v1589(VarNext,bitIndex1163) )
            & ( v1060_31__array(VarNext,A,bitIndex18)
            <=> v1589(VarNext,bitIndex1162) )
            & ( v1060_31__array(VarNext,A,bitIndex17)
            <=> v1589(VarNext,bitIndex1161) )
            & ( v1060_31__array(VarNext,A,bitIndex16)
            <=> v1589(VarNext,bitIndex1160) )
            & ( v1060_31__array(VarNext,A,bitIndex15)
            <=> v1589(VarNext,bitIndex1159) )
            & ( v1060_31__array(VarNext,A,bitIndex14)
            <=> v1589(VarNext,bitIndex1158) )
            & ( v1060_31__array(VarNext,A,bitIndex13)
            <=> v1589(VarNext,bitIndex1157) )
            & ( v1060_31__array(VarNext,A,bitIndex12)
            <=> v1589(VarNext,bitIndex1156) )
            & ( v1060_31__array(VarNext,A,bitIndex11)
            <=> v1589(VarNext,bitIndex1155) )
            & ( v1060_31__array(VarNext,A,bitIndex10)
            <=> v1589(VarNext,bitIndex1154) )
            & ( v1060_31__array(VarNext,A,bitIndex9)
            <=> v1589(VarNext,bitIndex1153) )
            & ( v1060_31__array(VarNext,A,bitIndex8)
            <=> v1589(VarNext,bitIndex1152) )
            & ( v1060_31__array(VarNext,A,bitIndex7)
            <=> v1589(VarNext,bitIndex1151) )
            & ( v1060_31__array(VarNext,A,bitIndex6)
            <=> v1589(VarNext,bitIndex1150) )
            & ( v1060_31__array(VarNext,A,bitIndex5)
            <=> v1589(VarNext,bitIndex1149) )
            & ( v1060_31__array(VarNext,A,bitIndex4)
            <=> v1589(VarNext,bitIndex1148) )
            & ( v1060_31__array(VarNext,A,bitIndex3)
            <=> v1589(VarNext,bitIndex1147) )
            & ( v1060_31__array(VarNext,A,bitIndex2)
            <=> v1589(VarNext,bitIndex1146) )
            & ( v1060_31__array(VarNext,A,bitIndex1)
            <=> v1589(VarNext,bitIndex1145) )
            & ( v1060_31__array(VarNext,A,bitIndex0)
            <=> v1589(VarNext,bitIndex1144) ) ) ) ) ).

fof(bitBlastConstant_528,axiom,
    b11010(bitIndex4) ).

fof(bitBlastConstant_527,axiom,
    b11010(bitIndex3) ).

fof(bitBlastConstant_526,axiom,
    ~ b11010(bitIndex2) ).

fof(bitBlastConstant_525,axiom,
    b11010(bitIndex1) ).

fof(bitBlastConstant_524,axiom,
    ~ b11010(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_184,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1582(VarNext)
      <=> ( v1583(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_183,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1583(VarNext)
      <=> ( v1585(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_70,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1585(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_29,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11001_address_term = A
              & v1572(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_30__array(VarNext,A,B)
              <=> v1060_29__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_29,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11001_address_term = A
            & v1572(VarNext) )
         => ( ( v1060_30__array(VarNext,A,bitIndex43)
            <=> v1579(VarNext,bitIndex1143) )
            & ( v1060_30__array(VarNext,A,bitIndex42)
            <=> v1579(VarNext,bitIndex1142) )
            & ( v1060_30__array(VarNext,A,bitIndex41)
            <=> v1579(VarNext,bitIndex1141) )
            & ( v1060_30__array(VarNext,A,bitIndex40)
            <=> v1579(VarNext,bitIndex1140) )
            & ( v1060_30__array(VarNext,A,bitIndex39)
            <=> v1579(VarNext,bitIndex1139) )
            & ( v1060_30__array(VarNext,A,bitIndex38)
            <=> v1579(VarNext,bitIndex1138) )
            & ( v1060_30__array(VarNext,A,bitIndex37)
            <=> v1579(VarNext,bitIndex1137) )
            & ( v1060_30__array(VarNext,A,bitIndex36)
            <=> v1579(VarNext,bitIndex1136) )
            & ( v1060_30__array(VarNext,A,bitIndex35)
            <=> v1579(VarNext,bitIndex1135) )
            & ( v1060_30__array(VarNext,A,bitIndex34)
            <=> v1579(VarNext,bitIndex1134) )
            & ( v1060_30__array(VarNext,A,bitIndex33)
            <=> v1579(VarNext,bitIndex1133) )
            & ( v1060_30__array(VarNext,A,bitIndex32)
            <=> v1579(VarNext,bitIndex1132) )
            & ( v1060_30__array(VarNext,A,bitIndex31)
            <=> v1579(VarNext,bitIndex1131) )
            & ( v1060_30__array(VarNext,A,bitIndex30)
            <=> v1579(VarNext,bitIndex1130) )
            & ( v1060_30__array(VarNext,A,bitIndex29)
            <=> v1579(VarNext,bitIndex1129) )
            & ( v1060_30__array(VarNext,A,bitIndex28)
            <=> v1579(VarNext,bitIndex1128) )
            & ( v1060_30__array(VarNext,A,bitIndex27)
            <=> v1579(VarNext,bitIndex1127) )
            & ( v1060_30__array(VarNext,A,bitIndex26)
            <=> v1579(VarNext,bitIndex1126) )
            & ( v1060_30__array(VarNext,A,bitIndex25)
            <=> v1579(VarNext,bitIndex1125) )
            & ( v1060_30__array(VarNext,A,bitIndex24)
            <=> v1579(VarNext,bitIndex1124) )
            & ( v1060_30__array(VarNext,A,bitIndex23)
            <=> v1579(VarNext,bitIndex1123) )
            & ( v1060_30__array(VarNext,A,bitIndex22)
            <=> v1579(VarNext,bitIndex1122) )
            & ( v1060_30__array(VarNext,A,bitIndex21)
            <=> v1579(VarNext,bitIndex1121) )
            & ( v1060_30__array(VarNext,A,bitIndex20)
            <=> v1579(VarNext,bitIndex1120) )
            & ( v1060_30__array(VarNext,A,bitIndex19)
            <=> v1579(VarNext,bitIndex1119) )
            & ( v1060_30__array(VarNext,A,bitIndex18)
            <=> v1579(VarNext,bitIndex1118) )
            & ( v1060_30__array(VarNext,A,bitIndex17)
            <=> v1579(VarNext,bitIndex1117) )
            & ( v1060_30__array(VarNext,A,bitIndex16)
            <=> v1579(VarNext,bitIndex1116) )
            & ( v1060_30__array(VarNext,A,bitIndex15)
            <=> v1579(VarNext,bitIndex1115) )
            & ( v1060_30__array(VarNext,A,bitIndex14)
            <=> v1579(VarNext,bitIndex1114) )
            & ( v1060_30__array(VarNext,A,bitIndex13)
            <=> v1579(VarNext,bitIndex1113) )
            & ( v1060_30__array(VarNext,A,bitIndex12)
            <=> v1579(VarNext,bitIndex1112) )
            & ( v1060_30__array(VarNext,A,bitIndex11)
            <=> v1579(VarNext,bitIndex1111) )
            & ( v1060_30__array(VarNext,A,bitIndex10)
            <=> v1579(VarNext,bitIndex1110) )
            & ( v1060_30__array(VarNext,A,bitIndex9)
            <=> v1579(VarNext,bitIndex1109) )
            & ( v1060_30__array(VarNext,A,bitIndex8)
            <=> v1579(VarNext,bitIndex1108) )
            & ( v1060_30__array(VarNext,A,bitIndex7)
            <=> v1579(VarNext,bitIndex1107) )
            & ( v1060_30__array(VarNext,A,bitIndex6)
            <=> v1579(VarNext,bitIndex1106) )
            & ( v1060_30__array(VarNext,A,bitIndex5)
            <=> v1579(VarNext,bitIndex1105) )
            & ( v1060_30__array(VarNext,A,bitIndex4)
            <=> v1579(VarNext,bitIndex1104) )
            & ( v1060_30__array(VarNext,A,bitIndex3)
            <=> v1579(VarNext,bitIndex1103) )
            & ( v1060_30__array(VarNext,A,bitIndex2)
            <=> v1579(VarNext,bitIndex1102) )
            & ( v1060_30__array(VarNext,A,bitIndex1)
            <=> v1579(VarNext,bitIndex1101) )
            & ( v1060_30__array(VarNext,A,bitIndex0)
            <=> v1579(VarNext,bitIndex1100) ) ) ) ) ).

fof(bitBlastConstant_523,axiom,
    b11001(bitIndex4) ).

fof(bitBlastConstant_522,axiom,
    b11001(bitIndex3) ).

fof(bitBlastConstant_521,axiom,
    ~ b11001(bitIndex2) ).

fof(bitBlastConstant_520,axiom,
    ~ b11001(bitIndex1) ).

fof(bitBlastConstant_519,axiom,
    b11001(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_182,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1572(VarNext)
      <=> ( v1573(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_181,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1573(VarNext)
      <=> ( v1575(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_69,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1575(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_28,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11000_address_term = A
              & v1562(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_29__array(VarNext,A,B)
              <=> v1060_28__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_28,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11000_address_term = A
            & v1562(VarNext) )
         => ( ( v1060_29__array(VarNext,A,bitIndex43)
            <=> v1569(VarNext,bitIndex1099) )
            & ( v1060_29__array(VarNext,A,bitIndex42)
            <=> v1569(VarNext,bitIndex1098) )
            & ( v1060_29__array(VarNext,A,bitIndex41)
            <=> v1569(VarNext,bitIndex1097) )
            & ( v1060_29__array(VarNext,A,bitIndex40)
            <=> v1569(VarNext,bitIndex1096) )
            & ( v1060_29__array(VarNext,A,bitIndex39)
            <=> v1569(VarNext,bitIndex1095) )
            & ( v1060_29__array(VarNext,A,bitIndex38)
            <=> v1569(VarNext,bitIndex1094) )
            & ( v1060_29__array(VarNext,A,bitIndex37)
            <=> v1569(VarNext,bitIndex1093) )
            & ( v1060_29__array(VarNext,A,bitIndex36)
            <=> v1569(VarNext,bitIndex1092) )
            & ( v1060_29__array(VarNext,A,bitIndex35)
            <=> v1569(VarNext,bitIndex1091) )
            & ( v1060_29__array(VarNext,A,bitIndex34)
            <=> v1569(VarNext,bitIndex1090) )
            & ( v1060_29__array(VarNext,A,bitIndex33)
            <=> v1569(VarNext,bitIndex1089) )
            & ( v1060_29__array(VarNext,A,bitIndex32)
            <=> v1569(VarNext,bitIndex1088) )
            & ( v1060_29__array(VarNext,A,bitIndex31)
            <=> v1569(VarNext,bitIndex1087) )
            & ( v1060_29__array(VarNext,A,bitIndex30)
            <=> v1569(VarNext,bitIndex1086) )
            & ( v1060_29__array(VarNext,A,bitIndex29)
            <=> v1569(VarNext,bitIndex1085) )
            & ( v1060_29__array(VarNext,A,bitIndex28)
            <=> v1569(VarNext,bitIndex1084) )
            & ( v1060_29__array(VarNext,A,bitIndex27)
            <=> v1569(VarNext,bitIndex1083) )
            & ( v1060_29__array(VarNext,A,bitIndex26)
            <=> v1569(VarNext,bitIndex1082) )
            & ( v1060_29__array(VarNext,A,bitIndex25)
            <=> v1569(VarNext,bitIndex1081) )
            & ( v1060_29__array(VarNext,A,bitIndex24)
            <=> v1569(VarNext,bitIndex1080) )
            & ( v1060_29__array(VarNext,A,bitIndex23)
            <=> v1569(VarNext,bitIndex1079) )
            & ( v1060_29__array(VarNext,A,bitIndex22)
            <=> v1569(VarNext,bitIndex1078) )
            & ( v1060_29__array(VarNext,A,bitIndex21)
            <=> v1569(VarNext,bitIndex1077) )
            & ( v1060_29__array(VarNext,A,bitIndex20)
            <=> v1569(VarNext,bitIndex1076) )
            & ( v1060_29__array(VarNext,A,bitIndex19)
            <=> v1569(VarNext,bitIndex1075) )
            & ( v1060_29__array(VarNext,A,bitIndex18)
            <=> v1569(VarNext,bitIndex1074) )
            & ( v1060_29__array(VarNext,A,bitIndex17)
            <=> v1569(VarNext,bitIndex1073) )
            & ( v1060_29__array(VarNext,A,bitIndex16)
            <=> v1569(VarNext,bitIndex1072) )
            & ( v1060_29__array(VarNext,A,bitIndex15)
            <=> v1569(VarNext,bitIndex1071) )
            & ( v1060_29__array(VarNext,A,bitIndex14)
            <=> v1569(VarNext,bitIndex1070) )
            & ( v1060_29__array(VarNext,A,bitIndex13)
            <=> v1569(VarNext,bitIndex1069) )
            & ( v1060_29__array(VarNext,A,bitIndex12)
            <=> v1569(VarNext,bitIndex1068) )
            & ( v1060_29__array(VarNext,A,bitIndex11)
            <=> v1569(VarNext,bitIndex1067) )
            & ( v1060_29__array(VarNext,A,bitIndex10)
            <=> v1569(VarNext,bitIndex1066) )
            & ( v1060_29__array(VarNext,A,bitIndex9)
            <=> v1569(VarNext,bitIndex1065) )
            & ( v1060_29__array(VarNext,A,bitIndex8)
            <=> v1569(VarNext,bitIndex1064) )
            & ( v1060_29__array(VarNext,A,bitIndex7)
            <=> v1569(VarNext,bitIndex1063) )
            & ( v1060_29__array(VarNext,A,bitIndex6)
            <=> v1569(VarNext,bitIndex1062) )
            & ( v1060_29__array(VarNext,A,bitIndex5)
            <=> v1569(VarNext,bitIndex1061) )
            & ( v1060_29__array(VarNext,A,bitIndex4)
            <=> v1569(VarNext,bitIndex1060) )
            & ( v1060_29__array(VarNext,A,bitIndex3)
            <=> v1569(VarNext,bitIndex1059) )
            & ( v1060_29__array(VarNext,A,bitIndex2)
            <=> v1569(VarNext,bitIndex1058) )
            & ( v1060_29__array(VarNext,A,bitIndex1)
            <=> v1569(VarNext,bitIndex1057) )
            & ( v1060_29__array(VarNext,A,bitIndex0)
            <=> v1569(VarNext,bitIndex1056) ) ) ) ) ).

fof(bitBlastConstant_518,axiom,
    b11000(bitIndex4) ).

fof(bitBlastConstant_517,axiom,
    b11000(bitIndex3) ).

fof(bitBlastConstant_516,axiom,
    ~ b11000(bitIndex2) ).

fof(bitBlastConstant_515,axiom,
    ~ b11000(bitIndex1) ).

fof(bitBlastConstant_514,axiom,
    ~ b11000(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_180,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1562(VarNext)
      <=> ( v1563(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_179,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1563(VarNext)
      <=> ( v1565(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_68,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1565(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_27,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10111_address_term = A
              & v1552(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_28__array(VarNext,A,B)
              <=> v1060_27__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_27,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10111_address_term = A
            & v1552(VarNext) )
         => ( ( v1060_28__array(VarNext,A,bitIndex43)
            <=> v1559(VarNext,bitIndex1055) )
            & ( v1060_28__array(VarNext,A,bitIndex42)
            <=> v1559(VarNext,bitIndex1054) )
            & ( v1060_28__array(VarNext,A,bitIndex41)
            <=> v1559(VarNext,bitIndex1053) )
            & ( v1060_28__array(VarNext,A,bitIndex40)
            <=> v1559(VarNext,bitIndex1052) )
            & ( v1060_28__array(VarNext,A,bitIndex39)
            <=> v1559(VarNext,bitIndex1051) )
            & ( v1060_28__array(VarNext,A,bitIndex38)
            <=> v1559(VarNext,bitIndex1050) )
            & ( v1060_28__array(VarNext,A,bitIndex37)
            <=> v1559(VarNext,bitIndex1049) )
            & ( v1060_28__array(VarNext,A,bitIndex36)
            <=> v1559(VarNext,bitIndex1048) )
            & ( v1060_28__array(VarNext,A,bitIndex35)
            <=> v1559(VarNext,bitIndex1047) )
            & ( v1060_28__array(VarNext,A,bitIndex34)
            <=> v1559(VarNext,bitIndex1046) )
            & ( v1060_28__array(VarNext,A,bitIndex33)
            <=> v1559(VarNext,bitIndex1045) )
            & ( v1060_28__array(VarNext,A,bitIndex32)
            <=> v1559(VarNext,bitIndex1044) )
            & ( v1060_28__array(VarNext,A,bitIndex31)
            <=> v1559(VarNext,bitIndex1043) )
            & ( v1060_28__array(VarNext,A,bitIndex30)
            <=> v1559(VarNext,bitIndex1042) )
            & ( v1060_28__array(VarNext,A,bitIndex29)
            <=> v1559(VarNext,bitIndex1041) )
            & ( v1060_28__array(VarNext,A,bitIndex28)
            <=> v1559(VarNext,bitIndex1040) )
            & ( v1060_28__array(VarNext,A,bitIndex27)
            <=> v1559(VarNext,bitIndex1039) )
            & ( v1060_28__array(VarNext,A,bitIndex26)
            <=> v1559(VarNext,bitIndex1038) )
            & ( v1060_28__array(VarNext,A,bitIndex25)
            <=> v1559(VarNext,bitIndex1037) )
            & ( v1060_28__array(VarNext,A,bitIndex24)
            <=> v1559(VarNext,bitIndex1036) )
            & ( v1060_28__array(VarNext,A,bitIndex23)
            <=> v1559(VarNext,bitIndex1035) )
            & ( v1060_28__array(VarNext,A,bitIndex22)
            <=> v1559(VarNext,bitIndex1034) )
            & ( v1060_28__array(VarNext,A,bitIndex21)
            <=> v1559(VarNext,bitIndex1033) )
            & ( v1060_28__array(VarNext,A,bitIndex20)
            <=> v1559(VarNext,bitIndex1032) )
            & ( v1060_28__array(VarNext,A,bitIndex19)
            <=> v1559(VarNext,bitIndex1031) )
            & ( v1060_28__array(VarNext,A,bitIndex18)
            <=> v1559(VarNext,bitIndex1030) )
            & ( v1060_28__array(VarNext,A,bitIndex17)
            <=> v1559(VarNext,bitIndex1029) )
            & ( v1060_28__array(VarNext,A,bitIndex16)
            <=> v1559(VarNext,bitIndex1028) )
            & ( v1060_28__array(VarNext,A,bitIndex15)
            <=> v1559(VarNext,bitIndex1027) )
            & ( v1060_28__array(VarNext,A,bitIndex14)
            <=> v1559(VarNext,bitIndex1026) )
            & ( v1060_28__array(VarNext,A,bitIndex13)
            <=> v1559(VarNext,bitIndex1025) )
            & ( v1060_28__array(VarNext,A,bitIndex12)
            <=> v1559(VarNext,bitIndex1024) )
            & ( v1060_28__array(VarNext,A,bitIndex11)
            <=> v1559(VarNext,bitIndex1023) )
            & ( v1060_28__array(VarNext,A,bitIndex10)
            <=> v1559(VarNext,bitIndex1022) )
            & ( v1060_28__array(VarNext,A,bitIndex9)
            <=> v1559(VarNext,bitIndex1021) )
            & ( v1060_28__array(VarNext,A,bitIndex8)
            <=> v1559(VarNext,bitIndex1020) )
            & ( v1060_28__array(VarNext,A,bitIndex7)
            <=> v1559(VarNext,bitIndex1019) )
            & ( v1060_28__array(VarNext,A,bitIndex6)
            <=> v1559(VarNext,bitIndex1018) )
            & ( v1060_28__array(VarNext,A,bitIndex5)
            <=> v1559(VarNext,bitIndex1017) )
            & ( v1060_28__array(VarNext,A,bitIndex4)
            <=> v1559(VarNext,bitIndex1016) )
            & ( v1060_28__array(VarNext,A,bitIndex3)
            <=> v1559(VarNext,bitIndex1015) )
            & ( v1060_28__array(VarNext,A,bitIndex2)
            <=> v1559(VarNext,bitIndex1014) )
            & ( v1060_28__array(VarNext,A,bitIndex1)
            <=> v1559(VarNext,bitIndex1013) )
            & ( v1060_28__array(VarNext,A,bitIndex0)
            <=> v1559(VarNext,bitIndex1012) ) ) ) ) ).

fof(bitBlastConstant_513,axiom,
    b10111(bitIndex4) ).

fof(bitBlastConstant_512,axiom,
    ~ b10111(bitIndex3) ).

fof(bitBlastConstant_511,axiom,
    b10111(bitIndex2) ).

fof(bitBlastConstant_510,axiom,
    b10111(bitIndex1) ).

fof(bitBlastConstant_509,axiom,
    b10111(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_178,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1552(VarNext)
      <=> ( v1553(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_177,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1553(VarNext)
      <=> ( v1555(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_67,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1555(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_26,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10110_address_term = A
              & v1542(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_27__array(VarNext,A,B)
              <=> v1060_26__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_26,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10110_address_term = A
            & v1542(VarNext) )
         => ( ( v1060_27__array(VarNext,A,bitIndex43)
            <=> v1549(VarNext,bitIndex1011) )
            & ( v1060_27__array(VarNext,A,bitIndex42)
            <=> v1549(VarNext,bitIndex1010) )
            & ( v1060_27__array(VarNext,A,bitIndex41)
            <=> v1549(VarNext,bitIndex1009) )
            & ( v1060_27__array(VarNext,A,bitIndex40)
            <=> v1549(VarNext,bitIndex1008) )
            & ( v1060_27__array(VarNext,A,bitIndex39)
            <=> v1549(VarNext,bitIndex1007) )
            & ( v1060_27__array(VarNext,A,bitIndex38)
            <=> v1549(VarNext,bitIndex1006) )
            & ( v1060_27__array(VarNext,A,bitIndex37)
            <=> v1549(VarNext,bitIndex1005) )
            & ( v1060_27__array(VarNext,A,bitIndex36)
            <=> v1549(VarNext,bitIndex1004) )
            & ( v1060_27__array(VarNext,A,bitIndex35)
            <=> v1549(VarNext,bitIndex1003) )
            & ( v1060_27__array(VarNext,A,bitIndex34)
            <=> v1549(VarNext,bitIndex1002) )
            & ( v1060_27__array(VarNext,A,bitIndex33)
            <=> v1549(VarNext,bitIndex1001) )
            & ( v1060_27__array(VarNext,A,bitIndex32)
            <=> v1549(VarNext,bitIndex1000) )
            & ( v1060_27__array(VarNext,A,bitIndex31)
            <=> v1549(VarNext,bitIndex999) )
            & ( v1060_27__array(VarNext,A,bitIndex30)
            <=> v1549(VarNext,bitIndex998) )
            & ( v1060_27__array(VarNext,A,bitIndex29)
            <=> v1549(VarNext,bitIndex997) )
            & ( v1060_27__array(VarNext,A,bitIndex28)
            <=> v1549(VarNext,bitIndex996) )
            & ( v1060_27__array(VarNext,A,bitIndex27)
            <=> v1549(VarNext,bitIndex995) )
            & ( v1060_27__array(VarNext,A,bitIndex26)
            <=> v1549(VarNext,bitIndex994) )
            & ( v1060_27__array(VarNext,A,bitIndex25)
            <=> v1549(VarNext,bitIndex993) )
            & ( v1060_27__array(VarNext,A,bitIndex24)
            <=> v1549(VarNext,bitIndex992) )
            & ( v1060_27__array(VarNext,A,bitIndex23)
            <=> v1549(VarNext,bitIndex991) )
            & ( v1060_27__array(VarNext,A,bitIndex22)
            <=> v1549(VarNext,bitIndex990) )
            & ( v1060_27__array(VarNext,A,bitIndex21)
            <=> v1549(VarNext,bitIndex989) )
            & ( v1060_27__array(VarNext,A,bitIndex20)
            <=> v1549(VarNext,bitIndex988) )
            & ( v1060_27__array(VarNext,A,bitIndex19)
            <=> v1549(VarNext,bitIndex987) )
            & ( v1060_27__array(VarNext,A,bitIndex18)
            <=> v1549(VarNext,bitIndex986) )
            & ( v1060_27__array(VarNext,A,bitIndex17)
            <=> v1549(VarNext,bitIndex985) )
            & ( v1060_27__array(VarNext,A,bitIndex16)
            <=> v1549(VarNext,bitIndex984) )
            & ( v1060_27__array(VarNext,A,bitIndex15)
            <=> v1549(VarNext,bitIndex983) )
            & ( v1060_27__array(VarNext,A,bitIndex14)
            <=> v1549(VarNext,bitIndex982) )
            & ( v1060_27__array(VarNext,A,bitIndex13)
            <=> v1549(VarNext,bitIndex981) )
            & ( v1060_27__array(VarNext,A,bitIndex12)
            <=> v1549(VarNext,bitIndex980) )
            & ( v1060_27__array(VarNext,A,bitIndex11)
            <=> v1549(VarNext,bitIndex979) )
            & ( v1060_27__array(VarNext,A,bitIndex10)
            <=> v1549(VarNext,bitIndex978) )
            & ( v1060_27__array(VarNext,A,bitIndex9)
            <=> v1549(VarNext,bitIndex977) )
            & ( v1060_27__array(VarNext,A,bitIndex8)
            <=> v1549(VarNext,bitIndex976) )
            & ( v1060_27__array(VarNext,A,bitIndex7)
            <=> v1549(VarNext,bitIndex975) )
            & ( v1060_27__array(VarNext,A,bitIndex6)
            <=> v1549(VarNext,bitIndex974) )
            & ( v1060_27__array(VarNext,A,bitIndex5)
            <=> v1549(VarNext,bitIndex973) )
            & ( v1060_27__array(VarNext,A,bitIndex4)
            <=> v1549(VarNext,bitIndex972) )
            & ( v1060_27__array(VarNext,A,bitIndex3)
            <=> v1549(VarNext,bitIndex971) )
            & ( v1060_27__array(VarNext,A,bitIndex2)
            <=> v1549(VarNext,bitIndex970) )
            & ( v1060_27__array(VarNext,A,bitIndex1)
            <=> v1549(VarNext,bitIndex969) )
            & ( v1060_27__array(VarNext,A,bitIndex0)
            <=> v1549(VarNext,bitIndex968) ) ) ) ) ).

fof(bitBlastConstant_508,axiom,
    b10110(bitIndex4) ).

fof(bitBlastConstant_507,axiom,
    ~ b10110(bitIndex3) ).

fof(bitBlastConstant_506,axiom,
    b10110(bitIndex2) ).

fof(bitBlastConstant_505,axiom,
    b10110(bitIndex1) ).

fof(bitBlastConstant_504,axiom,
    ~ b10110(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_176,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1542(VarNext)
      <=> ( v1543(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_175,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1543(VarNext)
      <=> ( v1545(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_66,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1545(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_25,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10101_address_term = A
              & v1532(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_26__array(VarNext,A,B)
              <=> v1060_25__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_25,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10101_address_term = A
            & v1532(VarNext) )
         => ( ( v1060_26__array(VarNext,A,bitIndex43)
            <=> v1539(VarNext,bitIndex967) )
            & ( v1060_26__array(VarNext,A,bitIndex42)
            <=> v1539(VarNext,bitIndex966) )
            & ( v1060_26__array(VarNext,A,bitIndex41)
            <=> v1539(VarNext,bitIndex965) )
            & ( v1060_26__array(VarNext,A,bitIndex40)
            <=> v1539(VarNext,bitIndex964) )
            & ( v1060_26__array(VarNext,A,bitIndex39)
            <=> v1539(VarNext,bitIndex963) )
            & ( v1060_26__array(VarNext,A,bitIndex38)
            <=> v1539(VarNext,bitIndex962) )
            & ( v1060_26__array(VarNext,A,bitIndex37)
            <=> v1539(VarNext,bitIndex961) )
            & ( v1060_26__array(VarNext,A,bitIndex36)
            <=> v1539(VarNext,bitIndex960) )
            & ( v1060_26__array(VarNext,A,bitIndex35)
            <=> v1539(VarNext,bitIndex959) )
            & ( v1060_26__array(VarNext,A,bitIndex34)
            <=> v1539(VarNext,bitIndex958) )
            & ( v1060_26__array(VarNext,A,bitIndex33)
            <=> v1539(VarNext,bitIndex957) )
            & ( v1060_26__array(VarNext,A,bitIndex32)
            <=> v1539(VarNext,bitIndex956) )
            & ( v1060_26__array(VarNext,A,bitIndex31)
            <=> v1539(VarNext,bitIndex955) )
            & ( v1060_26__array(VarNext,A,bitIndex30)
            <=> v1539(VarNext,bitIndex954) )
            & ( v1060_26__array(VarNext,A,bitIndex29)
            <=> v1539(VarNext,bitIndex953) )
            & ( v1060_26__array(VarNext,A,bitIndex28)
            <=> v1539(VarNext,bitIndex952) )
            & ( v1060_26__array(VarNext,A,bitIndex27)
            <=> v1539(VarNext,bitIndex951) )
            & ( v1060_26__array(VarNext,A,bitIndex26)
            <=> v1539(VarNext,bitIndex950) )
            & ( v1060_26__array(VarNext,A,bitIndex25)
            <=> v1539(VarNext,bitIndex949) )
            & ( v1060_26__array(VarNext,A,bitIndex24)
            <=> v1539(VarNext,bitIndex948) )
            & ( v1060_26__array(VarNext,A,bitIndex23)
            <=> v1539(VarNext,bitIndex947) )
            & ( v1060_26__array(VarNext,A,bitIndex22)
            <=> v1539(VarNext,bitIndex946) )
            & ( v1060_26__array(VarNext,A,bitIndex21)
            <=> v1539(VarNext,bitIndex945) )
            & ( v1060_26__array(VarNext,A,bitIndex20)
            <=> v1539(VarNext,bitIndex944) )
            & ( v1060_26__array(VarNext,A,bitIndex19)
            <=> v1539(VarNext,bitIndex943) )
            & ( v1060_26__array(VarNext,A,bitIndex18)
            <=> v1539(VarNext,bitIndex942) )
            & ( v1060_26__array(VarNext,A,bitIndex17)
            <=> v1539(VarNext,bitIndex941) )
            & ( v1060_26__array(VarNext,A,bitIndex16)
            <=> v1539(VarNext,bitIndex940) )
            & ( v1060_26__array(VarNext,A,bitIndex15)
            <=> v1539(VarNext,bitIndex939) )
            & ( v1060_26__array(VarNext,A,bitIndex14)
            <=> v1539(VarNext,bitIndex938) )
            & ( v1060_26__array(VarNext,A,bitIndex13)
            <=> v1539(VarNext,bitIndex937) )
            & ( v1060_26__array(VarNext,A,bitIndex12)
            <=> v1539(VarNext,bitIndex936) )
            & ( v1060_26__array(VarNext,A,bitIndex11)
            <=> v1539(VarNext,bitIndex935) )
            & ( v1060_26__array(VarNext,A,bitIndex10)
            <=> v1539(VarNext,bitIndex934) )
            & ( v1060_26__array(VarNext,A,bitIndex9)
            <=> v1539(VarNext,bitIndex933) )
            & ( v1060_26__array(VarNext,A,bitIndex8)
            <=> v1539(VarNext,bitIndex932) )
            & ( v1060_26__array(VarNext,A,bitIndex7)
            <=> v1539(VarNext,bitIndex931) )
            & ( v1060_26__array(VarNext,A,bitIndex6)
            <=> v1539(VarNext,bitIndex930) )
            & ( v1060_26__array(VarNext,A,bitIndex5)
            <=> v1539(VarNext,bitIndex929) )
            & ( v1060_26__array(VarNext,A,bitIndex4)
            <=> v1539(VarNext,bitIndex928) )
            & ( v1060_26__array(VarNext,A,bitIndex3)
            <=> v1539(VarNext,bitIndex927) )
            & ( v1060_26__array(VarNext,A,bitIndex2)
            <=> v1539(VarNext,bitIndex926) )
            & ( v1060_26__array(VarNext,A,bitIndex1)
            <=> v1539(VarNext,bitIndex925) )
            & ( v1060_26__array(VarNext,A,bitIndex0)
            <=> v1539(VarNext,bitIndex924) ) ) ) ) ).

fof(bitBlastConstant_503,axiom,
    b10101(bitIndex4) ).

fof(bitBlastConstant_502,axiom,
    ~ b10101(bitIndex3) ).

fof(bitBlastConstant_501,axiom,
    b10101(bitIndex2) ).

fof(bitBlastConstant_500,axiom,
    ~ b10101(bitIndex1) ).

fof(bitBlastConstant_499,axiom,
    b10101(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_174,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1532(VarNext)
      <=> ( v1533(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_173,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1533(VarNext)
      <=> ( v1535(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_65,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1535(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_24,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10100_address_term = A
              & v1522(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_25__array(VarNext,A,B)
              <=> v1060_24__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_24,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10100_address_term = A
            & v1522(VarNext) )
         => ( ( v1060_25__array(VarNext,A,bitIndex43)
            <=> v1529(VarNext,bitIndex923) )
            & ( v1060_25__array(VarNext,A,bitIndex42)
            <=> v1529(VarNext,bitIndex922) )
            & ( v1060_25__array(VarNext,A,bitIndex41)
            <=> v1529(VarNext,bitIndex921) )
            & ( v1060_25__array(VarNext,A,bitIndex40)
            <=> v1529(VarNext,bitIndex920) )
            & ( v1060_25__array(VarNext,A,bitIndex39)
            <=> v1529(VarNext,bitIndex919) )
            & ( v1060_25__array(VarNext,A,bitIndex38)
            <=> v1529(VarNext,bitIndex918) )
            & ( v1060_25__array(VarNext,A,bitIndex37)
            <=> v1529(VarNext,bitIndex917) )
            & ( v1060_25__array(VarNext,A,bitIndex36)
            <=> v1529(VarNext,bitIndex916) )
            & ( v1060_25__array(VarNext,A,bitIndex35)
            <=> v1529(VarNext,bitIndex915) )
            & ( v1060_25__array(VarNext,A,bitIndex34)
            <=> v1529(VarNext,bitIndex914) )
            & ( v1060_25__array(VarNext,A,bitIndex33)
            <=> v1529(VarNext,bitIndex913) )
            & ( v1060_25__array(VarNext,A,bitIndex32)
            <=> v1529(VarNext,bitIndex912) )
            & ( v1060_25__array(VarNext,A,bitIndex31)
            <=> v1529(VarNext,bitIndex911) )
            & ( v1060_25__array(VarNext,A,bitIndex30)
            <=> v1529(VarNext,bitIndex910) )
            & ( v1060_25__array(VarNext,A,bitIndex29)
            <=> v1529(VarNext,bitIndex909) )
            & ( v1060_25__array(VarNext,A,bitIndex28)
            <=> v1529(VarNext,bitIndex908) )
            & ( v1060_25__array(VarNext,A,bitIndex27)
            <=> v1529(VarNext,bitIndex907) )
            & ( v1060_25__array(VarNext,A,bitIndex26)
            <=> v1529(VarNext,bitIndex906) )
            & ( v1060_25__array(VarNext,A,bitIndex25)
            <=> v1529(VarNext,bitIndex905) )
            & ( v1060_25__array(VarNext,A,bitIndex24)
            <=> v1529(VarNext,bitIndex904) )
            & ( v1060_25__array(VarNext,A,bitIndex23)
            <=> v1529(VarNext,bitIndex903) )
            & ( v1060_25__array(VarNext,A,bitIndex22)
            <=> v1529(VarNext,bitIndex902) )
            & ( v1060_25__array(VarNext,A,bitIndex21)
            <=> v1529(VarNext,bitIndex901) )
            & ( v1060_25__array(VarNext,A,bitIndex20)
            <=> v1529(VarNext,bitIndex900) )
            & ( v1060_25__array(VarNext,A,bitIndex19)
            <=> v1529(VarNext,bitIndex899) )
            & ( v1060_25__array(VarNext,A,bitIndex18)
            <=> v1529(VarNext,bitIndex898) )
            & ( v1060_25__array(VarNext,A,bitIndex17)
            <=> v1529(VarNext,bitIndex897) )
            & ( v1060_25__array(VarNext,A,bitIndex16)
            <=> v1529(VarNext,bitIndex896) )
            & ( v1060_25__array(VarNext,A,bitIndex15)
            <=> v1529(VarNext,bitIndex895) )
            & ( v1060_25__array(VarNext,A,bitIndex14)
            <=> v1529(VarNext,bitIndex894) )
            & ( v1060_25__array(VarNext,A,bitIndex13)
            <=> v1529(VarNext,bitIndex893) )
            & ( v1060_25__array(VarNext,A,bitIndex12)
            <=> v1529(VarNext,bitIndex892) )
            & ( v1060_25__array(VarNext,A,bitIndex11)
            <=> v1529(VarNext,bitIndex891) )
            & ( v1060_25__array(VarNext,A,bitIndex10)
            <=> v1529(VarNext,bitIndex890) )
            & ( v1060_25__array(VarNext,A,bitIndex9)
            <=> v1529(VarNext,bitIndex889) )
            & ( v1060_25__array(VarNext,A,bitIndex8)
            <=> v1529(VarNext,bitIndex888) )
            & ( v1060_25__array(VarNext,A,bitIndex7)
            <=> v1529(VarNext,bitIndex887) )
            & ( v1060_25__array(VarNext,A,bitIndex6)
            <=> v1529(VarNext,bitIndex886) )
            & ( v1060_25__array(VarNext,A,bitIndex5)
            <=> v1529(VarNext,bitIndex885) )
            & ( v1060_25__array(VarNext,A,bitIndex4)
            <=> v1529(VarNext,bitIndex884) )
            & ( v1060_25__array(VarNext,A,bitIndex3)
            <=> v1529(VarNext,bitIndex883) )
            & ( v1060_25__array(VarNext,A,bitIndex2)
            <=> v1529(VarNext,bitIndex882) )
            & ( v1060_25__array(VarNext,A,bitIndex1)
            <=> v1529(VarNext,bitIndex881) )
            & ( v1060_25__array(VarNext,A,bitIndex0)
            <=> v1529(VarNext,bitIndex880) ) ) ) ) ).

fof(bitBlastConstant_498,axiom,
    b10100(bitIndex4) ).

fof(bitBlastConstant_497,axiom,
    ~ b10100(bitIndex3) ).

fof(bitBlastConstant_496,axiom,
    b10100(bitIndex2) ).

fof(bitBlastConstant_495,axiom,
    ~ b10100(bitIndex1) ).

fof(bitBlastConstant_494,axiom,
    ~ b10100(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_172,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1522(VarNext)
      <=> ( v1523(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_171,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1523(VarNext)
      <=> ( v1525(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_64,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1525(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_23,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10011_address_term = A
              & v1512(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_24__array(VarNext,A,B)
              <=> v1060_23__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_23,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10011_address_term = A
            & v1512(VarNext) )
         => ( ( v1060_24__array(VarNext,A,bitIndex43)
            <=> v1519(VarNext,bitIndex879) )
            & ( v1060_24__array(VarNext,A,bitIndex42)
            <=> v1519(VarNext,bitIndex878) )
            & ( v1060_24__array(VarNext,A,bitIndex41)
            <=> v1519(VarNext,bitIndex877) )
            & ( v1060_24__array(VarNext,A,bitIndex40)
            <=> v1519(VarNext,bitIndex876) )
            & ( v1060_24__array(VarNext,A,bitIndex39)
            <=> v1519(VarNext,bitIndex875) )
            & ( v1060_24__array(VarNext,A,bitIndex38)
            <=> v1519(VarNext,bitIndex874) )
            & ( v1060_24__array(VarNext,A,bitIndex37)
            <=> v1519(VarNext,bitIndex873) )
            & ( v1060_24__array(VarNext,A,bitIndex36)
            <=> v1519(VarNext,bitIndex872) )
            & ( v1060_24__array(VarNext,A,bitIndex35)
            <=> v1519(VarNext,bitIndex871) )
            & ( v1060_24__array(VarNext,A,bitIndex34)
            <=> v1519(VarNext,bitIndex870) )
            & ( v1060_24__array(VarNext,A,bitIndex33)
            <=> v1519(VarNext,bitIndex869) )
            & ( v1060_24__array(VarNext,A,bitIndex32)
            <=> v1519(VarNext,bitIndex868) )
            & ( v1060_24__array(VarNext,A,bitIndex31)
            <=> v1519(VarNext,bitIndex867) )
            & ( v1060_24__array(VarNext,A,bitIndex30)
            <=> v1519(VarNext,bitIndex866) )
            & ( v1060_24__array(VarNext,A,bitIndex29)
            <=> v1519(VarNext,bitIndex865) )
            & ( v1060_24__array(VarNext,A,bitIndex28)
            <=> v1519(VarNext,bitIndex864) )
            & ( v1060_24__array(VarNext,A,bitIndex27)
            <=> v1519(VarNext,bitIndex863) )
            & ( v1060_24__array(VarNext,A,bitIndex26)
            <=> v1519(VarNext,bitIndex862) )
            & ( v1060_24__array(VarNext,A,bitIndex25)
            <=> v1519(VarNext,bitIndex861) )
            & ( v1060_24__array(VarNext,A,bitIndex24)
            <=> v1519(VarNext,bitIndex860) )
            & ( v1060_24__array(VarNext,A,bitIndex23)
            <=> v1519(VarNext,bitIndex859) )
            & ( v1060_24__array(VarNext,A,bitIndex22)
            <=> v1519(VarNext,bitIndex858) )
            & ( v1060_24__array(VarNext,A,bitIndex21)
            <=> v1519(VarNext,bitIndex857) )
            & ( v1060_24__array(VarNext,A,bitIndex20)
            <=> v1519(VarNext,bitIndex856) )
            & ( v1060_24__array(VarNext,A,bitIndex19)
            <=> v1519(VarNext,bitIndex855) )
            & ( v1060_24__array(VarNext,A,bitIndex18)
            <=> v1519(VarNext,bitIndex854) )
            & ( v1060_24__array(VarNext,A,bitIndex17)
            <=> v1519(VarNext,bitIndex853) )
            & ( v1060_24__array(VarNext,A,bitIndex16)
            <=> v1519(VarNext,bitIndex852) )
            & ( v1060_24__array(VarNext,A,bitIndex15)
            <=> v1519(VarNext,bitIndex851) )
            & ( v1060_24__array(VarNext,A,bitIndex14)
            <=> v1519(VarNext,bitIndex850) )
            & ( v1060_24__array(VarNext,A,bitIndex13)
            <=> v1519(VarNext,bitIndex849) )
            & ( v1060_24__array(VarNext,A,bitIndex12)
            <=> v1519(VarNext,bitIndex848) )
            & ( v1060_24__array(VarNext,A,bitIndex11)
            <=> v1519(VarNext,bitIndex847) )
            & ( v1060_24__array(VarNext,A,bitIndex10)
            <=> v1519(VarNext,bitIndex846) )
            & ( v1060_24__array(VarNext,A,bitIndex9)
            <=> v1519(VarNext,bitIndex845) )
            & ( v1060_24__array(VarNext,A,bitIndex8)
            <=> v1519(VarNext,bitIndex844) )
            & ( v1060_24__array(VarNext,A,bitIndex7)
            <=> v1519(VarNext,bitIndex843) )
            & ( v1060_24__array(VarNext,A,bitIndex6)
            <=> v1519(VarNext,bitIndex842) )
            & ( v1060_24__array(VarNext,A,bitIndex5)
            <=> v1519(VarNext,bitIndex841) )
            & ( v1060_24__array(VarNext,A,bitIndex4)
            <=> v1519(VarNext,bitIndex840) )
            & ( v1060_24__array(VarNext,A,bitIndex3)
            <=> v1519(VarNext,bitIndex839) )
            & ( v1060_24__array(VarNext,A,bitIndex2)
            <=> v1519(VarNext,bitIndex838) )
            & ( v1060_24__array(VarNext,A,bitIndex1)
            <=> v1519(VarNext,bitIndex837) )
            & ( v1060_24__array(VarNext,A,bitIndex0)
            <=> v1519(VarNext,bitIndex836) ) ) ) ) ).

fof(bitBlastConstant_493,axiom,
    b10011(bitIndex4) ).

fof(bitBlastConstant_492,axiom,
    ~ b10011(bitIndex3) ).

fof(bitBlastConstant_491,axiom,
    ~ b10011(bitIndex2) ).

fof(bitBlastConstant_490,axiom,
    b10011(bitIndex1) ).

fof(bitBlastConstant_489,axiom,
    b10011(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_170,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1512(VarNext)
      <=> ( v1513(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_169,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1513(VarNext)
      <=> ( v1515(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_63,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1515(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_22,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10010_address_term = A
              & v1502(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_23__array(VarNext,A,B)
              <=> v1060_22__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_22,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10010_address_term = A
            & v1502(VarNext) )
         => ( ( v1060_23__array(VarNext,A,bitIndex43)
            <=> v1509(VarNext,bitIndex835) )
            & ( v1060_23__array(VarNext,A,bitIndex42)
            <=> v1509(VarNext,bitIndex834) )
            & ( v1060_23__array(VarNext,A,bitIndex41)
            <=> v1509(VarNext,bitIndex833) )
            & ( v1060_23__array(VarNext,A,bitIndex40)
            <=> v1509(VarNext,bitIndex832) )
            & ( v1060_23__array(VarNext,A,bitIndex39)
            <=> v1509(VarNext,bitIndex831) )
            & ( v1060_23__array(VarNext,A,bitIndex38)
            <=> v1509(VarNext,bitIndex830) )
            & ( v1060_23__array(VarNext,A,bitIndex37)
            <=> v1509(VarNext,bitIndex829) )
            & ( v1060_23__array(VarNext,A,bitIndex36)
            <=> v1509(VarNext,bitIndex828) )
            & ( v1060_23__array(VarNext,A,bitIndex35)
            <=> v1509(VarNext,bitIndex827) )
            & ( v1060_23__array(VarNext,A,bitIndex34)
            <=> v1509(VarNext,bitIndex826) )
            & ( v1060_23__array(VarNext,A,bitIndex33)
            <=> v1509(VarNext,bitIndex825) )
            & ( v1060_23__array(VarNext,A,bitIndex32)
            <=> v1509(VarNext,bitIndex824) )
            & ( v1060_23__array(VarNext,A,bitIndex31)
            <=> v1509(VarNext,bitIndex823) )
            & ( v1060_23__array(VarNext,A,bitIndex30)
            <=> v1509(VarNext,bitIndex822) )
            & ( v1060_23__array(VarNext,A,bitIndex29)
            <=> v1509(VarNext,bitIndex821) )
            & ( v1060_23__array(VarNext,A,bitIndex28)
            <=> v1509(VarNext,bitIndex820) )
            & ( v1060_23__array(VarNext,A,bitIndex27)
            <=> v1509(VarNext,bitIndex819) )
            & ( v1060_23__array(VarNext,A,bitIndex26)
            <=> v1509(VarNext,bitIndex818) )
            & ( v1060_23__array(VarNext,A,bitIndex25)
            <=> v1509(VarNext,bitIndex817) )
            & ( v1060_23__array(VarNext,A,bitIndex24)
            <=> v1509(VarNext,bitIndex816) )
            & ( v1060_23__array(VarNext,A,bitIndex23)
            <=> v1509(VarNext,bitIndex815) )
            & ( v1060_23__array(VarNext,A,bitIndex22)
            <=> v1509(VarNext,bitIndex814) )
            & ( v1060_23__array(VarNext,A,bitIndex21)
            <=> v1509(VarNext,bitIndex813) )
            & ( v1060_23__array(VarNext,A,bitIndex20)
            <=> v1509(VarNext,bitIndex812) )
            & ( v1060_23__array(VarNext,A,bitIndex19)
            <=> v1509(VarNext,bitIndex811) )
            & ( v1060_23__array(VarNext,A,bitIndex18)
            <=> v1509(VarNext,bitIndex810) )
            & ( v1060_23__array(VarNext,A,bitIndex17)
            <=> v1509(VarNext,bitIndex809) )
            & ( v1060_23__array(VarNext,A,bitIndex16)
            <=> v1509(VarNext,bitIndex808) )
            & ( v1060_23__array(VarNext,A,bitIndex15)
            <=> v1509(VarNext,bitIndex807) )
            & ( v1060_23__array(VarNext,A,bitIndex14)
            <=> v1509(VarNext,bitIndex806) )
            & ( v1060_23__array(VarNext,A,bitIndex13)
            <=> v1509(VarNext,bitIndex805) )
            & ( v1060_23__array(VarNext,A,bitIndex12)
            <=> v1509(VarNext,bitIndex804) )
            & ( v1060_23__array(VarNext,A,bitIndex11)
            <=> v1509(VarNext,bitIndex803) )
            & ( v1060_23__array(VarNext,A,bitIndex10)
            <=> v1509(VarNext,bitIndex802) )
            & ( v1060_23__array(VarNext,A,bitIndex9)
            <=> v1509(VarNext,bitIndex801) )
            & ( v1060_23__array(VarNext,A,bitIndex8)
            <=> v1509(VarNext,bitIndex800) )
            & ( v1060_23__array(VarNext,A,bitIndex7)
            <=> v1509(VarNext,bitIndex799) )
            & ( v1060_23__array(VarNext,A,bitIndex6)
            <=> v1509(VarNext,bitIndex798) )
            & ( v1060_23__array(VarNext,A,bitIndex5)
            <=> v1509(VarNext,bitIndex797) )
            & ( v1060_23__array(VarNext,A,bitIndex4)
            <=> v1509(VarNext,bitIndex796) )
            & ( v1060_23__array(VarNext,A,bitIndex3)
            <=> v1509(VarNext,bitIndex795) )
            & ( v1060_23__array(VarNext,A,bitIndex2)
            <=> v1509(VarNext,bitIndex794) )
            & ( v1060_23__array(VarNext,A,bitIndex1)
            <=> v1509(VarNext,bitIndex793) )
            & ( v1060_23__array(VarNext,A,bitIndex0)
            <=> v1509(VarNext,bitIndex792) ) ) ) ) ).

fof(bitBlastConstant_488,axiom,
    b10010(bitIndex4) ).

fof(bitBlastConstant_487,axiom,
    ~ b10010(bitIndex3) ).

fof(bitBlastConstant_486,axiom,
    ~ b10010(bitIndex2) ).

fof(bitBlastConstant_485,axiom,
    b10010(bitIndex1) ).

fof(bitBlastConstant_484,axiom,
    ~ b10010(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_168,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1502(VarNext)
      <=> ( v1503(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_167,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1503(VarNext)
      <=> ( v1505(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_62,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1505(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_21,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10001_address_term = A
              & v1492(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_22__array(VarNext,A,B)
              <=> v1060_21__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_21,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10001_address_term = A
            & v1492(VarNext) )
         => ( ( v1060_22__array(VarNext,A,bitIndex43)
            <=> v1499(VarNext,bitIndex791) )
            & ( v1060_22__array(VarNext,A,bitIndex42)
            <=> v1499(VarNext,bitIndex790) )
            & ( v1060_22__array(VarNext,A,bitIndex41)
            <=> v1499(VarNext,bitIndex789) )
            & ( v1060_22__array(VarNext,A,bitIndex40)
            <=> v1499(VarNext,bitIndex788) )
            & ( v1060_22__array(VarNext,A,bitIndex39)
            <=> v1499(VarNext,bitIndex787) )
            & ( v1060_22__array(VarNext,A,bitIndex38)
            <=> v1499(VarNext,bitIndex786) )
            & ( v1060_22__array(VarNext,A,bitIndex37)
            <=> v1499(VarNext,bitIndex785) )
            & ( v1060_22__array(VarNext,A,bitIndex36)
            <=> v1499(VarNext,bitIndex784) )
            & ( v1060_22__array(VarNext,A,bitIndex35)
            <=> v1499(VarNext,bitIndex783) )
            & ( v1060_22__array(VarNext,A,bitIndex34)
            <=> v1499(VarNext,bitIndex782) )
            & ( v1060_22__array(VarNext,A,bitIndex33)
            <=> v1499(VarNext,bitIndex781) )
            & ( v1060_22__array(VarNext,A,bitIndex32)
            <=> v1499(VarNext,bitIndex780) )
            & ( v1060_22__array(VarNext,A,bitIndex31)
            <=> v1499(VarNext,bitIndex779) )
            & ( v1060_22__array(VarNext,A,bitIndex30)
            <=> v1499(VarNext,bitIndex778) )
            & ( v1060_22__array(VarNext,A,bitIndex29)
            <=> v1499(VarNext,bitIndex777) )
            & ( v1060_22__array(VarNext,A,bitIndex28)
            <=> v1499(VarNext,bitIndex776) )
            & ( v1060_22__array(VarNext,A,bitIndex27)
            <=> v1499(VarNext,bitIndex775) )
            & ( v1060_22__array(VarNext,A,bitIndex26)
            <=> v1499(VarNext,bitIndex774) )
            & ( v1060_22__array(VarNext,A,bitIndex25)
            <=> v1499(VarNext,bitIndex773) )
            & ( v1060_22__array(VarNext,A,bitIndex24)
            <=> v1499(VarNext,bitIndex772) )
            & ( v1060_22__array(VarNext,A,bitIndex23)
            <=> v1499(VarNext,bitIndex771) )
            & ( v1060_22__array(VarNext,A,bitIndex22)
            <=> v1499(VarNext,bitIndex770) )
            & ( v1060_22__array(VarNext,A,bitIndex21)
            <=> v1499(VarNext,bitIndex769) )
            & ( v1060_22__array(VarNext,A,bitIndex20)
            <=> v1499(VarNext,bitIndex768) )
            & ( v1060_22__array(VarNext,A,bitIndex19)
            <=> v1499(VarNext,bitIndex767) )
            & ( v1060_22__array(VarNext,A,bitIndex18)
            <=> v1499(VarNext,bitIndex766) )
            & ( v1060_22__array(VarNext,A,bitIndex17)
            <=> v1499(VarNext,bitIndex765) )
            & ( v1060_22__array(VarNext,A,bitIndex16)
            <=> v1499(VarNext,bitIndex764) )
            & ( v1060_22__array(VarNext,A,bitIndex15)
            <=> v1499(VarNext,bitIndex763) )
            & ( v1060_22__array(VarNext,A,bitIndex14)
            <=> v1499(VarNext,bitIndex762) )
            & ( v1060_22__array(VarNext,A,bitIndex13)
            <=> v1499(VarNext,bitIndex761) )
            & ( v1060_22__array(VarNext,A,bitIndex12)
            <=> v1499(VarNext,bitIndex760) )
            & ( v1060_22__array(VarNext,A,bitIndex11)
            <=> v1499(VarNext,bitIndex759) )
            & ( v1060_22__array(VarNext,A,bitIndex10)
            <=> v1499(VarNext,bitIndex758) )
            & ( v1060_22__array(VarNext,A,bitIndex9)
            <=> v1499(VarNext,bitIndex757) )
            & ( v1060_22__array(VarNext,A,bitIndex8)
            <=> v1499(VarNext,bitIndex756) )
            & ( v1060_22__array(VarNext,A,bitIndex7)
            <=> v1499(VarNext,bitIndex755) )
            & ( v1060_22__array(VarNext,A,bitIndex6)
            <=> v1499(VarNext,bitIndex754) )
            & ( v1060_22__array(VarNext,A,bitIndex5)
            <=> v1499(VarNext,bitIndex753) )
            & ( v1060_22__array(VarNext,A,bitIndex4)
            <=> v1499(VarNext,bitIndex752) )
            & ( v1060_22__array(VarNext,A,bitIndex3)
            <=> v1499(VarNext,bitIndex751) )
            & ( v1060_22__array(VarNext,A,bitIndex2)
            <=> v1499(VarNext,bitIndex750) )
            & ( v1060_22__array(VarNext,A,bitIndex1)
            <=> v1499(VarNext,bitIndex749) )
            & ( v1060_22__array(VarNext,A,bitIndex0)
            <=> v1499(VarNext,bitIndex748) ) ) ) ) ).

fof(bitBlastConstant_483,axiom,
    b10001(bitIndex4) ).

fof(bitBlastConstant_482,axiom,
    ~ b10001(bitIndex3) ).

fof(bitBlastConstant_481,axiom,
    ~ b10001(bitIndex2) ).

fof(bitBlastConstant_480,axiom,
    ~ b10001(bitIndex1) ).

fof(bitBlastConstant_479,axiom,
    b10001(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_166,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1492(VarNext)
      <=> ( v1493(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_165,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1493(VarNext)
      <=> ( v1495(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_61,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1495(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_20,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10000_address_term = A
              & v1482(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_21__array(VarNext,A,B)
              <=> v1060_20__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_20,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10000_address_term = A
            & v1482(VarNext) )
         => ( ( v1060_21__array(VarNext,A,bitIndex43)
            <=> v1489(VarNext,bitIndex747) )
            & ( v1060_21__array(VarNext,A,bitIndex42)
            <=> v1489(VarNext,bitIndex746) )
            & ( v1060_21__array(VarNext,A,bitIndex41)
            <=> v1489(VarNext,bitIndex745) )
            & ( v1060_21__array(VarNext,A,bitIndex40)
            <=> v1489(VarNext,bitIndex744) )
            & ( v1060_21__array(VarNext,A,bitIndex39)
            <=> v1489(VarNext,bitIndex743) )
            & ( v1060_21__array(VarNext,A,bitIndex38)
            <=> v1489(VarNext,bitIndex742) )
            & ( v1060_21__array(VarNext,A,bitIndex37)
            <=> v1489(VarNext,bitIndex741) )
            & ( v1060_21__array(VarNext,A,bitIndex36)
            <=> v1489(VarNext,bitIndex740) )
            & ( v1060_21__array(VarNext,A,bitIndex35)
            <=> v1489(VarNext,bitIndex739) )
            & ( v1060_21__array(VarNext,A,bitIndex34)
            <=> v1489(VarNext,bitIndex738) )
            & ( v1060_21__array(VarNext,A,bitIndex33)
            <=> v1489(VarNext,bitIndex737) )
            & ( v1060_21__array(VarNext,A,bitIndex32)
            <=> v1489(VarNext,bitIndex736) )
            & ( v1060_21__array(VarNext,A,bitIndex31)
            <=> v1489(VarNext,bitIndex735) )
            & ( v1060_21__array(VarNext,A,bitIndex30)
            <=> v1489(VarNext,bitIndex734) )
            & ( v1060_21__array(VarNext,A,bitIndex29)
            <=> v1489(VarNext,bitIndex733) )
            & ( v1060_21__array(VarNext,A,bitIndex28)
            <=> v1489(VarNext,bitIndex732) )
            & ( v1060_21__array(VarNext,A,bitIndex27)
            <=> v1489(VarNext,bitIndex731) )
            & ( v1060_21__array(VarNext,A,bitIndex26)
            <=> v1489(VarNext,bitIndex730) )
            & ( v1060_21__array(VarNext,A,bitIndex25)
            <=> v1489(VarNext,bitIndex729) )
            & ( v1060_21__array(VarNext,A,bitIndex24)
            <=> v1489(VarNext,bitIndex728) )
            & ( v1060_21__array(VarNext,A,bitIndex23)
            <=> v1489(VarNext,bitIndex727) )
            & ( v1060_21__array(VarNext,A,bitIndex22)
            <=> v1489(VarNext,bitIndex726) )
            & ( v1060_21__array(VarNext,A,bitIndex21)
            <=> v1489(VarNext,bitIndex725) )
            & ( v1060_21__array(VarNext,A,bitIndex20)
            <=> v1489(VarNext,bitIndex724) )
            & ( v1060_21__array(VarNext,A,bitIndex19)
            <=> v1489(VarNext,bitIndex723) )
            & ( v1060_21__array(VarNext,A,bitIndex18)
            <=> v1489(VarNext,bitIndex722) )
            & ( v1060_21__array(VarNext,A,bitIndex17)
            <=> v1489(VarNext,bitIndex721) )
            & ( v1060_21__array(VarNext,A,bitIndex16)
            <=> v1489(VarNext,bitIndex720) )
            & ( v1060_21__array(VarNext,A,bitIndex15)
            <=> v1489(VarNext,bitIndex719) )
            & ( v1060_21__array(VarNext,A,bitIndex14)
            <=> v1489(VarNext,bitIndex718) )
            & ( v1060_21__array(VarNext,A,bitIndex13)
            <=> v1489(VarNext,bitIndex717) )
            & ( v1060_21__array(VarNext,A,bitIndex12)
            <=> v1489(VarNext,bitIndex716) )
            & ( v1060_21__array(VarNext,A,bitIndex11)
            <=> v1489(VarNext,bitIndex715) )
            & ( v1060_21__array(VarNext,A,bitIndex10)
            <=> v1489(VarNext,bitIndex714) )
            & ( v1060_21__array(VarNext,A,bitIndex9)
            <=> v1489(VarNext,bitIndex713) )
            & ( v1060_21__array(VarNext,A,bitIndex8)
            <=> v1489(VarNext,bitIndex712) )
            & ( v1060_21__array(VarNext,A,bitIndex7)
            <=> v1489(VarNext,bitIndex711) )
            & ( v1060_21__array(VarNext,A,bitIndex6)
            <=> v1489(VarNext,bitIndex710) )
            & ( v1060_21__array(VarNext,A,bitIndex5)
            <=> v1489(VarNext,bitIndex709) )
            & ( v1060_21__array(VarNext,A,bitIndex4)
            <=> v1489(VarNext,bitIndex708) )
            & ( v1060_21__array(VarNext,A,bitIndex3)
            <=> v1489(VarNext,bitIndex707) )
            & ( v1060_21__array(VarNext,A,bitIndex2)
            <=> v1489(VarNext,bitIndex706) )
            & ( v1060_21__array(VarNext,A,bitIndex1)
            <=> v1489(VarNext,bitIndex705) )
            & ( v1060_21__array(VarNext,A,bitIndex0)
            <=> v1489(VarNext,bitIndex704) ) ) ) ) ).

fof(bitBlastConstant_478,axiom,
    b10000(bitIndex4) ).

fof(bitBlastConstant_477,axiom,
    ~ b10000(bitIndex3) ).

fof(bitBlastConstant_476,axiom,
    ~ b10000(bitIndex2) ).

fof(bitBlastConstant_475,axiom,
    ~ b10000(bitIndex1) ).

fof(bitBlastConstant_474,axiom,
    ~ b10000(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_164,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1482(VarNext)
      <=> ( v1483(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_163,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1483(VarNext)
      <=> ( v1485(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_60,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1485(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_19,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01111_address_term = A
              & v1472(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_20__array(VarNext,A,B)
              <=> v1060_19__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_19,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01111_address_term = A
            & v1472(VarNext) )
         => ( ( v1060_20__array(VarNext,A,bitIndex43)
            <=> v1479(VarNext,bitIndex703) )
            & ( v1060_20__array(VarNext,A,bitIndex42)
            <=> v1479(VarNext,bitIndex702) )
            & ( v1060_20__array(VarNext,A,bitIndex41)
            <=> v1479(VarNext,bitIndex701) )
            & ( v1060_20__array(VarNext,A,bitIndex40)
            <=> v1479(VarNext,bitIndex700) )
            & ( v1060_20__array(VarNext,A,bitIndex39)
            <=> v1479(VarNext,bitIndex699) )
            & ( v1060_20__array(VarNext,A,bitIndex38)
            <=> v1479(VarNext,bitIndex698) )
            & ( v1060_20__array(VarNext,A,bitIndex37)
            <=> v1479(VarNext,bitIndex697) )
            & ( v1060_20__array(VarNext,A,bitIndex36)
            <=> v1479(VarNext,bitIndex696) )
            & ( v1060_20__array(VarNext,A,bitIndex35)
            <=> v1479(VarNext,bitIndex695) )
            & ( v1060_20__array(VarNext,A,bitIndex34)
            <=> v1479(VarNext,bitIndex694) )
            & ( v1060_20__array(VarNext,A,bitIndex33)
            <=> v1479(VarNext,bitIndex693) )
            & ( v1060_20__array(VarNext,A,bitIndex32)
            <=> v1479(VarNext,bitIndex692) )
            & ( v1060_20__array(VarNext,A,bitIndex31)
            <=> v1479(VarNext,bitIndex691) )
            & ( v1060_20__array(VarNext,A,bitIndex30)
            <=> v1479(VarNext,bitIndex690) )
            & ( v1060_20__array(VarNext,A,bitIndex29)
            <=> v1479(VarNext,bitIndex689) )
            & ( v1060_20__array(VarNext,A,bitIndex28)
            <=> v1479(VarNext,bitIndex688) )
            & ( v1060_20__array(VarNext,A,bitIndex27)
            <=> v1479(VarNext,bitIndex687) )
            & ( v1060_20__array(VarNext,A,bitIndex26)
            <=> v1479(VarNext,bitIndex686) )
            & ( v1060_20__array(VarNext,A,bitIndex25)
            <=> v1479(VarNext,bitIndex685) )
            & ( v1060_20__array(VarNext,A,bitIndex24)
            <=> v1479(VarNext,bitIndex684) )
            & ( v1060_20__array(VarNext,A,bitIndex23)
            <=> v1479(VarNext,bitIndex683) )
            & ( v1060_20__array(VarNext,A,bitIndex22)
            <=> v1479(VarNext,bitIndex682) )
            & ( v1060_20__array(VarNext,A,bitIndex21)
            <=> v1479(VarNext,bitIndex681) )
            & ( v1060_20__array(VarNext,A,bitIndex20)
            <=> v1479(VarNext,bitIndex680) )
            & ( v1060_20__array(VarNext,A,bitIndex19)
            <=> v1479(VarNext,bitIndex679) )
            & ( v1060_20__array(VarNext,A,bitIndex18)
            <=> v1479(VarNext,bitIndex678) )
            & ( v1060_20__array(VarNext,A,bitIndex17)
            <=> v1479(VarNext,bitIndex677) )
            & ( v1060_20__array(VarNext,A,bitIndex16)
            <=> v1479(VarNext,bitIndex676) )
            & ( v1060_20__array(VarNext,A,bitIndex15)
            <=> v1479(VarNext,bitIndex675) )
            & ( v1060_20__array(VarNext,A,bitIndex14)
            <=> v1479(VarNext,bitIndex674) )
            & ( v1060_20__array(VarNext,A,bitIndex13)
            <=> v1479(VarNext,bitIndex673) )
            & ( v1060_20__array(VarNext,A,bitIndex12)
            <=> v1479(VarNext,bitIndex672) )
            & ( v1060_20__array(VarNext,A,bitIndex11)
            <=> v1479(VarNext,bitIndex671) )
            & ( v1060_20__array(VarNext,A,bitIndex10)
            <=> v1479(VarNext,bitIndex670) )
            & ( v1060_20__array(VarNext,A,bitIndex9)
            <=> v1479(VarNext,bitIndex669) )
            & ( v1060_20__array(VarNext,A,bitIndex8)
            <=> v1479(VarNext,bitIndex668) )
            & ( v1060_20__array(VarNext,A,bitIndex7)
            <=> v1479(VarNext,bitIndex667) )
            & ( v1060_20__array(VarNext,A,bitIndex6)
            <=> v1479(VarNext,bitIndex666) )
            & ( v1060_20__array(VarNext,A,bitIndex5)
            <=> v1479(VarNext,bitIndex665) )
            & ( v1060_20__array(VarNext,A,bitIndex4)
            <=> v1479(VarNext,bitIndex664) )
            & ( v1060_20__array(VarNext,A,bitIndex3)
            <=> v1479(VarNext,bitIndex663) )
            & ( v1060_20__array(VarNext,A,bitIndex2)
            <=> v1479(VarNext,bitIndex662) )
            & ( v1060_20__array(VarNext,A,bitIndex1)
            <=> v1479(VarNext,bitIndex661) )
            & ( v1060_20__array(VarNext,A,bitIndex0)
            <=> v1479(VarNext,bitIndex660) ) ) ) ) ).

fof(bitBlastConstant_473,axiom,
    ~ b01111(bitIndex4) ).

fof(bitBlastConstant_472,axiom,
    b01111(bitIndex3) ).

fof(bitBlastConstant_471,axiom,
    b01111(bitIndex2) ).

fof(bitBlastConstant_470,axiom,
    b01111(bitIndex1) ).

fof(bitBlastConstant_469,axiom,
    b01111(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_162,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1472(VarNext)
      <=> ( v1473(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_161,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1473(VarNext)
      <=> ( v1475(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_59,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1475(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_18,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01110_address_term = A
              & v1462(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_19__array(VarNext,A,B)
              <=> v1060_18__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_18,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01110_address_term = A
            & v1462(VarNext) )
         => ( ( v1060_19__array(VarNext,A,bitIndex43)
            <=> v1469(VarNext,bitIndex659) )
            & ( v1060_19__array(VarNext,A,bitIndex42)
            <=> v1469(VarNext,bitIndex658) )
            & ( v1060_19__array(VarNext,A,bitIndex41)
            <=> v1469(VarNext,bitIndex657) )
            & ( v1060_19__array(VarNext,A,bitIndex40)
            <=> v1469(VarNext,bitIndex656) )
            & ( v1060_19__array(VarNext,A,bitIndex39)
            <=> v1469(VarNext,bitIndex655) )
            & ( v1060_19__array(VarNext,A,bitIndex38)
            <=> v1469(VarNext,bitIndex654) )
            & ( v1060_19__array(VarNext,A,bitIndex37)
            <=> v1469(VarNext,bitIndex653) )
            & ( v1060_19__array(VarNext,A,bitIndex36)
            <=> v1469(VarNext,bitIndex652) )
            & ( v1060_19__array(VarNext,A,bitIndex35)
            <=> v1469(VarNext,bitIndex651) )
            & ( v1060_19__array(VarNext,A,bitIndex34)
            <=> v1469(VarNext,bitIndex650) )
            & ( v1060_19__array(VarNext,A,bitIndex33)
            <=> v1469(VarNext,bitIndex649) )
            & ( v1060_19__array(VarNext,A,bitIndex32)
            <=> v1469(VarNext,bitIndex648) )
            & ( v1060_19__array(VarNext,A,bitIndex31)
            <=> v1469(VarNext,bitIndex647) )
            & ( v1060_19__array(VarNext,A,bitIndex30)
            <=> v1469(VarNext,bitIndex646) )
            & ( v1060_19__array(VarNext,A,bitIndex29)
            <=> v1469(VarNext,bitIndex645) )
            & ( v1060_19__array(VarNext,A,bitIndex28)
            <=> v1469(VarNext,bitIndex644) )
            & ( v1060_19__array(VarNext,A,bitIndex27)
            <=> v1469(VarNext,bitIndex643) )
            & ( v1060_19__array(VarNext,A,bitIndex26)
            <=> v1469(VarNext,bitIndex642) )
            & ( v1060_19__array(VarNext,A,bitIndex25)
            <=> v1469(VarNext,bitIndex641) )
            & ( v1060_19__array(VarNext,A,bitIndex24)
            <=> v1469(VarNext,bitIndex640) )
            & ( v1060_19__array(VarNext,A,bitIndex23)
            <=> v1469(VarNext,bitIndex639) )
            & ( v1060_19__array(VarNext,A,bitIndex22)
            <=> v1469(VarNext,bitIndex638) )
            & ( v1060_19__array(VarNext,A,bitIndex21)
            <=> v1469(VarNext,bitIndex637) )
            & ( v1060_19__array(VarNext,A,bitIndex20)
            <=> v1469(VarNext,bitIndex636) )
            & ( v1060_19__array(VarNext,A,bitIndex19)
            <=> v1469(VarNext,bitIndex635) )
            & ( v1060_19__array(VarNext,A,bitIndex18)
            <=> v1469(VarNext,bitIndex634) )
            & ( v1060_19__array(VarNext,A,bitIndex17)
            <=> v1469(VarNext,bitIndex633) )
            & ( v1060_19__array(VarNext,A,bitIndex16)
            <=> v1469(VarNext,bitIndex632) )
            & ( v1060_19__array(VarNext,A,bitIndex15)
            <=> v1469(VarNext,bitIndex631) )
            & ( v1060_19__array(VarNext,A,bitIndex14)
            <=> v1469(VarNext,bitIndex630) )
            & ( v1060_19__array(VarNext,A,bitIndex13)
            <=> v1469(VarNext,bitIndex629) )
            & ( v1060_19__array(VarNext,A,bitIndex12)
            <=> v1469(VarNext,bitIndex628) )
            & ( v1060_19__array(VarNext,A,bitIndex11)
            <=> v1469(VarNext,bitIndex627) )
            & ( v1060_19__array(VarNext,A,bitIndex10)
            <=> v1469(VarNext,bitIndex626) )
            & ( v1060_19__array(VarNext,A,bitIndex9)
            <=> v1469(VarNext,bitIndex625) )
            & ( v1060_19__array(VarNext,A,bitIndex8)
            <=> v1469(VarNext,bitIndex624) )
            & ( v1060_19__array(VarNext,A,bitIndex7)
            <=> v1469(VarNext,bitIndex623) )
            & ( v1060_19__array(VarNext,A,bitIndex6)
            <=> v1469(VarNext,bitIndex622) )
            & ( v1060_19__array(VarNext,A,bitIndex5)
            <=> v1469(VarNext,bitIndex621) )
            & ( v1060_19__array(VarNext,A,bitIndex4)
            <=> v1469(VarNext,bitIndex620) )
            & ( v1060_19__array(VarNext,A,bitIndex3)
            <=> v1469(VarNext,bitIndex619) )
            & ( v1060_19__array(VarNext,A,bitIndex2)
            <=> v1469(VarNext,bitIndex618) )
            & ( v1060_19__array(VarNext,A,bitIndex1)
            <=> v1469(VarNext,bitIndex617) )
            & ( v1060_19__array(VarNext,A,bitIndex0)
            <=> v1469(VarNext,bitIndex616) ) ) ) ) ).

fof(bitBlastConstant_468,axiom,
    ~ b01110(bitIndex4) ).

fof(bitBlastConstant_467,axiom,
    b01110(bitIndex3) ).

fof(bitBlastConstant_466,axiom,
    b01110(bitIndex2) ).

fof(bitBlastConstant_465,axiom,
    b01110(bitIndex1) ).

fof(bitBlastConstant_464,axiom,
    ~ b01110(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_160,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1462(VarNext)
      <=> ( v1463(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_159,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1463(VarNext)
      <=> ( v1465(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_58,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1465(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_17,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01101_address_term = A
              & v1452(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_18__array(VarNext,A,B)
              <=> v1060_17__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_17,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01101_address_term = A
            & v1452(VarNext) )
         => ( ( v1060_18__array(VarNext,A,bitIndex43)
            <=> v1459(VarNext,bitIndex615) )
            & ( v1060_18__array(VarNext,A,bitIndex42)
            <=> v1459(VarNext,bitIndex614) )
            & ( v1060_18__array(VarNext,A,bitIndex41)
            <=> v1459(VarNext,bitIndex613) )
            & ( v1060_18__array(VarNext,A,bitIndex40)
            <=> v1459(VarNext,bitIndex612) )
            & ( v1060_18__array(VarNext,A,bitIndex39)
            <=> v1459(VarNext,bitIndex611) )
            & ( v1060_18__array(VarNext,A,bitIndex38)
            <=> v1459(VarNext,bitIndex610) )
            & ( v1060_18__array(VarNext,A,bitIndex37)
            <=> v1459(VarNext,bitIndex609) )
            & ( v1060_18__array(VarNext,A,bitIndex36)
            <=> v1459(VarNext,bitIndex608) )
            & ( v1060_18__array(VarNext,A,bitIndex35)
            <=> v1459(VarNext,bitIndex607) )
            & ( v1060_18__array(VarNext,A,bitIndex34)
            <=> v1459(VarNext,bitIndex606) )
            & ( v1060_18__array(VarNext,A,bitIndex33)
            <=> v1459(VarNext,bitIndex605) )
            & ( v1060_18__array(VarNext,A,bitIndex32)
            <=> v1459(VarNext,bitIndex604) )
            & ( v1060_18__array(VarNext,A,bitIndex31)
            <=> v1459(VarNext,bitIndex603) )
            & ( v1060_18__array(VarNext,A,bitIndex30)
            <=> v1459(VarNext,bitIndex602) )
            & ( v1060_18__array(VarNext,A,bitIndex29)
            <=> v1459(VarNext,bitIndex601) )
            & ( v1060_18__array(VarNext,A,bitIndex28)
            <=> v1459(VarNext,bitIndex600) )
            & ( v1060_18__array(VarNext,A,bitIndex27)
            <=> v1459(VarNext,bitIndex599) )
            & ( v1060_18__array(VarNext,A,bitIndex26)
            <=> v1459(VarNext,bitIndex598) )
            & ( v1060_18__array(VarNext,A,bitIndex25)
            <=> v1459(VarNext,bitIndex597) )
            & ( v1060_18__array(VarNext,A,bitIndex24)
            <=> v1459(VarNext,bitIndex596) )
            & ( v1060_18__array(VarNext,A,bitIndex23)
            <=> v1459(VarNext,bitIndex595) )
            & ( v1060_18__array(VarNext,A,bitIndex22)
            <=> v1459(VarNext,bitIndex594) )
            & ( v1060_18__array(VarNext,A,bitIndex21)
            <=> v1459(VarNext,bitIndex593) )
            & ( v1060_18__array(VarNext,A,bitIndex20)
            <=> v1459(VarNext,bitIndex592) )
            & ( v1060_18__array(VarNext,A,bitIndex19)
            <=> v1459(VarNext,bitIndex591) )
            & ( v1060_18__array(VarNext,A,bitIndex18)
            <=> v1459(VarNext,bitIndex590) )
            & ( v1060_18__array(VarNext,A,bitIndex17)
            <=> v1459(VarNext,bitIndex589) )
            & ( v1060_18__array(VarNext,A,bitIndex16)
            <=> v1459(VarNext,bitIndex588) )
            & ( v1060_18__array(VarNext,A,bitIndex15)
            <=> v1459(VarNext,bitIndex587) )
            & ( v1060_18__array(VarNext,A,bitIndex14)
            <=> v1459(VarNext,bitIndex586) )
            & ( v1060_18__array(VarNext,A,bitIndex13)
            <=> v1459(VarNext,bitIndex585) )
            & ( v1060_18__array(VarNext,A,bitIndex12)
            <=> v1459(VarNext,bitIndex584) )
            & ( v1060_18__array(VarNext,A,bitIndex11)
            <=> v1459(VarNext,bitIndex583) )
            & ( v1060_18__array(VarNext,A,bitIndex10)
            <=> v1459(VarNext,bitIndex582) )
            & ( v1060_18__array(VarNext,A,bitIndex9)
            <=> v1459(VarNext,bitIndex581) )
            & ( v1060_18__array(VarNext,A,bitIndex8)
            <=> v1459(VarNext,bitIndex580) )
            & ( v1060_18__array(VarNext,A,bitIndex7)
            <=> v1459(VarNext,bitIndex579) )
            & ( v1060_18__array(VarNext,A,bitIndex6)
            <=> v1459(VarNext,bitIndex578) )
            & ( v1060_18__array(VarNext,A,bitIndex5)
            <=> v1459(VarNext,bitIndex577) )
            & ( v1060_18__array(VarNext,A,bitIndex4)
            <=> v1459(VarNext,bitIndex576) )
            & ( v1060_18__array(VarNext,A,bitIndex3)
            <=> v1459(VarNext,bitIndex575) )
            & ( v1060_18__array(VarNext,A,bitIndex2)
            <=> v1459(VarNext,bitIndex574) )
            & ( v1060_18__array(VarNext,A,bitIndex1)
            <=> v1459(VarNext,bitIndex573) )
            & ( v1060_18__array(VarNext,A,bitIndex0)
            <=> v1459(VarNext,bitIndex572) ) ) ) ) ).

fof(bitBlastConstant_463,axiom,
    ~ b01101(bitIndex4) ).

fof(bitBlastConstant_462,axiom,
    b01101(bitIndex3) ).

fof(bitBlastConstant_461,axiom,
    b01101(bitIndex2) ).

fof(bitBlastConstant_460,axiom,
    ~ b01101(bitIndex1) ).

fof(bitBlastConstant_459,axiom,
    b01101(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_158,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1452(VarNext)
      <=> ( v1453(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_157,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1453(VarNext)
      <=> ( v1455(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_57,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1455(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_16,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01100_address_term = A
              & v1442(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_17__array(VarNext,A,B)
              <=> v1060_16__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_16,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01100_address_term = A
            & v1442(VarNext) )
         => ( ( v1060_17__array(VarNext,A,bitIndex43)
            <=> v1449(VarNext,bitIndex571) )
            & ( v1060_17__array(VarNext,A,bitIndex42)
            <=> v1449(VarNext,bitIndex570) )
            & ( v1060_17__array(VarNext,A,bitIndex41)
            <=> v1449(VarNext,bitIndex569) )
            & ( v1060_17__array(VarNext,A,bitIndex40)
            <=> v1449(VarNext,bitIndex568) )
            & ( v1060_17__array(VarNext,A,bitIndex39)
            <=> v1449(VarNext,bitIndex567) )
            & ( v1060_17__array(VarNext,A,bitIndex38)
            <=> v1449(VarNext,bitIndex566) )
            & ( v1060_17__array(VarNext,A,bitIndex37)
            <=> v1449(VarNext,bitIndex565) )
            & ( v1060_17__array(VarNext,A,bitIndex36)
            <=> v1449(VarNext,bitIndex564) )
            & ( v1060_17__array(VarNext,A,bitIndex35)
            <=> v1449(VarNext,bitIndex563) )
            & ( v1060_17__array(VarNext,A,bitIndex34)
            <=> v1449(VarNext,bitIndex562) )
            & ( v1060_17__array(VarNext,A,bitIndex33)
            <=> v1449(VarNext,bitIndex561) )
            & ( v1060_17__array(VarNext,A,bitIndex32)
            <=> v1449(VarNext,bitIndex560) )
            & ( v1060_17__array(VarNext,A,bitIndex31)
            <=> v1449(VarNext,bitIndex559) )
            & ( v1060_17__array(VarNext,A,bitIndex30)
            <=> v1449(VarNext,bitIndex558) )
            & ( v1060_17__array(VarNext,A,bitIndex29)
            <=> v1449(VarNext,bitIndex557) )
            & ( v1060_17__array(VarNext,A,bitIndex28)
            <=> v1449(VarNext,bitIndex556) )
            & ( v1060_17__array(VarNext,A,bitIndex27)
            <=> v1449(VarNext,bitIndex555) )
            & ( v1060_17__array(VarNext,A,bitIndex26)
            <=> v1449(VarNext,bitIndex554) )
            & ( v1060_17__array(VarNext,A,bitIndex25)
            <=> v1449(VarNext,bitIndex553) )
            & ( v1060_17__array(VarNext,A,bitIndex24)
            <=> v1449(VarNext,bitIndex552) )
            & ( v1060_17__array(VarNext,A,bitIndex23)
            <=> v1449(VarNext,bitIndex551) )
            & ( v1060_17__array(VarNext,A,bitIndex22)
            <=> v1449(VarNext,bitIndex550) )
            & ( v1060_17__array(VarNext,A,bitIndex21)
            <=> v1449(VarNext,bitIndex549) )
            & ( v1060_17__array(VarNext,A,bitIndex20)
            <=> v1449(VarNext,bitIndex548) )
            & ( v1060_17__array(VarNext,A,bitIndex19)
            <=> v1449(VarNext,bitIndex547) )
            & ( v1060_17__array(VarNext,A,bitIndex18)
            <=> v1449(VarNext,bitIndex546) )
            & ( v1060_17__array(VarNext,A,bitIndex17)
            <=> v1449(VarNext,bitIndex545) )
            & ( v1060_17__array(VarNext,A,bitIndex16)
            <=> v1449(VarNext,bitIndex544) )
            & ( v1060_17__array(VarNext,A,bitIndex15)
            <=> v1449(VarNext,bitIndex543) )
            & ( v1060_17__array(VarNext,A,bitIndex14)
            <=> v1449(VarNext,bitIndex542) )
            & ( v1060_17__array(VarNext,A,bitIndex13)
            <=> v1449(VarNext,bitIndex541) )
            & ( v1060_17__array(VarNext,A,bitIndex12)
            <=> v1449(VarNext,bitIndex540) )
            & ( v1060_17__array(VarNext,A,bitIndex11)
            <=> v1449(VarNext,bitIndex539) )
            & ( v1060_17__array(VarNext,A,bitIndex10)
            <=> v1449(VarNext,bitIndex538) )
            & ( v1060_17__array(VarNext,A,bitIndex9)
            <=> v1449(VarNext,bitIndex537) )
            & ( v1060_17__array(VarNext,A,bitIndex8)
            <=> v1449(VarNext,bitIndex536) )
            & ( v1060_17__array(VarNext,A,bitIndex7)
            <=> v1449(VarNext,bitIndex535) )
            & ( v1060_17__array(VarNext,A,bitIndex6)
            <=> v1449(VarNext,bitIndex534) )
            & ( v1060_17__array(VarNext,A,bitIndex5)
            <=> v1449(VarNext,bitIndex533) )
            & ( v1060_17__array(VarNext,A,bitIndex4)
            <=> v1449(VarNext,bitIndex532) )
            & ( v1060_17__array(VarNext,A,bitIndex3)
            <=> v1449(VarNext,bitIndex531) )
            & ( v1060_17__array(VarNext,A,bitIndex2)
            <=> v1449(VarNext,bitIndex530) )
            & ( v1060_17__array(VarNext,A,bitIndex1)
            <=> v1449(VarNext,bitIndex529) )
            & ( v1060_17__array(VarNext,A,bitIndex0)
            <=> v1449(VarNext,bitIndex528) ) ) ) ) ).

fof(bitBlastConstant_458,axiom,
    ~ b01100(bitIndex4) ).

fof(bitBlastConstant_457,axiom,
    b01100(bitIndex3) ).

fof(bitBlastConstant_456,axiom,
    b01100(bitIndex2) ).

fof(bitBlastConstant_455,axiom,
    ~ b01100(bitIndex1) ).

fof(bitBlastConstant_454,axiom,
    ~ b01100(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_156,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1442(VarNext)
      <=> ( v1443(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_155,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1443(VarNext)
      <=> ( v1445(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_56,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1445(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_15,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01011_address_term = A
              & v1432(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_16__array(VarNext,A,B)
              <=> v1060_15__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_15,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01011_address_term = A
            & v1432(VarNext) )
         => ( ( v1060_16__array(VarNext,A,bitIndex43)
            <=> v1439(VarNext,bitIndex527) )
            & ( v1060_16__array(VarNext,A,bitIndex42)
            <=> v1439(VarNext,bitIndex526) )
            & ( v1060_16__array(VarNext,A,bitIndex41)
            <=> v1439(VarNext,bitIndex525) )
            & ( v1060_16__array(VarNext,A,bitIndex40)
            <=> v1439(VarNext,bitIndex524) )
            & ( v1060_16__array(VarNext,A,bitIndex39)
            <=> v1439(VarNext,bitIndex523) )
            & ( v1060_16__array(VarNext,A,bitIndex38)
            <=> v1439(VarNext,bitIndex522) )
            & ( v1060_16__array(VarNext,A,bitIndex37)
            <=> v1439(VarNext,bitIndex521) )
            & ( v1060_16__array(VarNext,A,bitIndex36)
            <=> v1439(VarNext,bitIndex520) )
            & ( v1060_16__array(VarNext,A,bitIndex35)
            <=> v1439(VarNext,bitIndex519) )
            & ( v1060_16__array(VarNext,A,bitIndex34)
            <=> v1439(VarNext,bitIndex518) )
            & ( v1060_16__array(VarNext,A,bitIndex33)
            <=> v1439(VarNext,bitIndex517) )
            & ( v1060_16__array(VarNext,A,bitIndex32)
            <=> v1439(VarNext,bitIndex516) )
            & ( v1060_16__array(VarNext,A,bitIndex31)
            <=> v1439(VarNext,bitIndex515) )
            & ( v1060_16__array(VarNext,A,bitIndex30)
            <=> v1439(VarNext,bitIndex514) )
            & ( v1060_16__array(VarNext,A,bitIndex29)
            <=> v1439(VarNext,bitIndex513) )
            & ( v1060_16__array(VarNext,A,bitIndex28)
            <=> v1439(VarNext,bitIndex512) )
            & ( v1060_16__array(VarNext,A,bitIndex27)
            <=> v1439(VarNext,bitIndex511) )
            & ( v1060_16__array(VarNext,A,bitIndex26)
            <=> v1439(VarNext,bitIndex510) )
            & ( v1060_16__array(VarNext,A,bitIndex25)
            <=> v1439(VarNext,bitIndex509) )
            & ( v1060_16__array(VarNext,A,bitIndex24)
            <=> v1439(VarNext,bitIndex508) )
            & ( v1060_16__array(VarNext,A,bitIndex23)
            <=> v1439(VarNext,bitIndex507) )
            & ( v1060_16__array(VarNext,A,bitIndex22)
            <=> v1439(VarNext,bitIndex506) )
            & ( v1060_16__array(VarNext,A,bitIndex21)
            <=> v1439(VarNext,bitIndex505) )
            & ( v1060_16__array(VarNext,A,bitIndex20)
            <=> v1439(VarNext,bitIndex504) )
            & ( v1060_16__array(VarNext,A,bitIndex19)
            <=> v1439(VarNext,bitIndex503) )
            & ( v1060_16__array(VarNext,A,bitIndex18)
            <=> v1439(VarNext,bitIndex502) )
            & ( v1060_16__array(VarNext,A,bitIndex17)
            <=> v1439(VarNext,bitIndex501) )
            & ( v1060_16__array(VarNext,A,bitIndex16)
            <=> v1439(VarNext,bitIndex500) )
            & ( v1060_16__array(VarNext,A,bitIndex15)
            <=> v1439(VarNext,bitIndex499) )
            & ( v1060_16__array(VarNext,A,bitIndex14)
            <=> v1439(VarNext,bitIndex498) )
            & ( v1060_16__array(VarNext,A,bitIndex13)
            <=> v1439(VarNext,bitIndex497) )
            & ( v1060_16__array(VarNext,A,bitIndex12)
            <=> v1439(VarNext,bitIndex496) )
            & ( v1060_16__array(VarNext,A,bitIndex11)
            <=> v1439(VarNext,bitIndex495) )
            & ( v1060_16__array(VarNext,A,bitIndex10)
            <=> v1439(VarNext,bitIndex494) )
            & ( v1060_16__array(VarNext,A,bitIndex9)
            <=> v1439(VarNext,bitIndex493) )
            & ( v1060_16__array(VarNext,A,bitIndex8)
            <=> v1439(VarNext,bitIndex492) )
            & ( v1060_16__array(VarNext,A,bitIndex7)
            <=> v1439(VarNext,bitIndex491) )
            & ( v1060_16__array(VarNext,A,bitIndex6)
            <=> v1439(VarNext,bitIndex490) )
            & ( v1060_16__array(VarNext,A,bitIndex5)
            <=> v1439(VarNext,bitIndex489) )
            & ( v1060_16__array(VarNext,A,bitIndex4)
            <=> v1439(VarNext,bitIndex488) )
            & ( v1060_16__array(VarNext,A,bitIndex3)
            <=> v1439(VarNext,bitIndex487) )
            & ( v1060_16__array(VarNext,A,bitIndex2)
            <=> v1439(VarNext,bitIndex486) )
            & ( v1060_16__array(VarNext,A,bitIndex1)
            <=> v1439(VarNext,bitIndex485) )
            & ( v1060_16__array(VarNext,A,bitIndex0)
            <=> v1439(VarNext,bitIndex484) ) ) ) ) ).

fof(bitBlastConstant_453,axiom,
    ~ b01011(bitIndex4) ).

fof(bitBlastConstant_452,axiom,
    b01011(bitIndex3) ).

fof(bitBlastConstant_451,axiom,
    ~ b01011(bitIndex2) ).

fof(bitBlastConstant_450,axiom,
    b01011(bitIndex1) ).

fof(bitBlastConstant_449,axiom,
    b01011(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_154,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1432(VarNext)
      <=> ( v1433(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_153,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1433(VarNext)
      <=> ( v1435(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_55,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1435(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_14,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01010_address_term = A
              & v1422(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_15__array(VarNext,A,B)
              <=> v1060_14__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_14,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01010_address_term = A
            & v1422(VarNext) )
         => ( ( v1060_15__array(VarNext,A,bitIndex43)
            <=> v1429(VarNext,bitIndex483) )
            & ( v1060_15__array(VarNext,A,bitIndex42)
            <=> v1429(VarNext,bitIndex482) )
            & ( v1060_15__array(VarNext,A,bitIndex41)
            <=> v1429(VarNext,bitIndex481) )
            & ( v1060_15__array(VarNext,A,bitIndex40)
            <=> v1429(VarNext,bitIndex480) )
            & ( v1060_15__array(VarNext,A,bitIndex39)
            <=> v1429(VarNext,bitIndex479) )
            & ( v1060_15__array(VarNext,A,bitIndex38)
            <=> v1429(VarNext,bitIndex478) )
            & ( v1060_15__array(VarNext,A,bitIndex37)
            <=> v1429(VarNext,bitIndex477) )
            & ( v1060_15__array(VarNext,A,bitIndex36)
            <=> v1429(VarNext,bitIndex476) )
            & ( v1060_15__array(VarNext,A,bitIndex35)
            <=> v1429(VarNext,bitIndex475) )
            & ( v1060_15__array(VarNext,A,bitIndex34)
            <=> v1429(VarNext,bitIndex474) )
            & ( v1060_15__array(VarNext,A,bitIndex33)
            <=> v1429(VarNext,bitIndex473) )
            & ( v1060_15__array(VarNext,A,bitIndex32)
            <=> v1429(VarNext,bitIndex472) )
            & ( v1060_15__array(VarNext,A,bitIndex31)
            <=> v1429(VarNext,bitIndex471) )
            & ( v1060_15__array(VarNext,A,bitIndex30)
            <=> v1429(VarNext,bitIndex470) )
            & ( v1060_15__array(VarNext,A,bitIndex29)
            <=> v1429(VarNext,bitIndex469) )
            & ( v1060_15__array(VarNext,A,bitIndex28)
            <=> v1429(VarNext,bitIndex468) )
            & ( v1060_15__array(VarNext,A,bitIndex27)
            <=> v1429(VarNext,bitIndex467) )
            & ( v1060_15__array(VarNext,A,bitIndex26)
            <=> v1429(VarNext,bitIndex466) )
            & ( v1060_15__array(VarNext,A,bitIndex25)
            <=> v1429(VarNext,bitIndex465) )
            & ( v1060_15__array(VarNext,A,bitIndex24)
            <=> v1429(VarNext,bitIndex464) )
            & ( v1060_15__array(VarNext,A,bitIndex23)
            <=> v1429(VarNext,bitIndex463) )
            & ( v1060_15__array(VarNext,A,bitIndex22)
            <=> v1429(VarNext,bitIndex462) )
            & ( v1060_15__array(VarNext,A,bitIndex21)
            <=> v1429(VarNext,bitIndex461) )
            & ( v1060_15__array(VarNext,A,bitIndex20)
            <=> v1429(VarNext,bitIndex460) )
            & ( v1060_15__array(VarNext,A,bitIndex19)
            <=> v1429(VarNext,bitIndex459) )
            & ( v1060_15__array(VarNext,A,bitIndex18)
            <=> v1429(VarNext,bitIndex458) )
            & ( v1060_15__array(VarNext,A,bitIndex17)
            <=> v1429(VarNext,bitIndex457) )
            & ( v1060_15__array(VarNext,A,bitIndex16)
            <=> v1429(VarNext,bitIndex456) )
            & ( v1060_15__array(VarNext,A,bitIndex15)
            <=> v1429(VarNext,bitIndex455) )
            & ( v1060_15__array(VarNext,A,bitIndex14)
            <=> v1429(VarNext,bitIndex454) )
            & ( v1060_15__array(VarNext,A,bitIndex13)
            <=> v1429(VarNext,bitIndex453) )
            & ( v1060_15__array(VarNext,A,bitIndex12)
            <=> v1429(VarNext,bitIndex452) )
            & ( v1060_15__array(VarNext,A,bitIndex11)
            <=> v1429(VarNext,bitIndex451) )
            & ( v1060_15__array(VarNext,A,bitIndex10)
            <=> v1429(VarNext,bitIndex450) )
            & ( v1060_15__array(VarNext,A,bitIndex9)
            <=> v1429(VarNext,bitIndex449) )
            & ( v1060_15__array(VarNext,A,bitIndex8)
            <=> v1429(VarNext,bitIndex448) )
            & ( v1060_15__array(VarNext,A,bitIndex7)
            <=> v1429(VarNext,bitIndex447) )
            & ( v1060_15__array(VarNext,A,bitIndex6)
            <=> v1429(VarNext,bitIndex446) )
            & ( v1060_15__array(VarNext,A,bitIndex5)
            <=> v1429(VarNext,bitIndex445) )
            & ( v1060_15__array(VarNext,A,bitIndex4)
            <=> v1429(VarNext,bitIndex444) )
            & ( v1060_15__array(VarNext,A,bitIndex3)
            <=> v1429(VarNext,bitIndex443) )
            & ( v1060_15__array(VarNext,A,bitIndex2)
            <=> v1429(VarNext,bitIndex442) )
            & ( v1060_15__array(VarNext,A,bitIndex1)
            <=> v1429(VarNext,bitIndex441) )
            & ( v1060_15__array(VarNext,A,bitIndex0)
            <=> v1429(VarNext,bitIndex440) ) ) ) ) ).

fof(bitBlastConstant_448,axiom,
    ~ b01010(bitIndex4) ).

fof(bitBlastConstant_447,axiom,
    b01010(bitIndex3) ).

fof(bitBlastConstant_446,axiom,
    ~ b01010(bitIndex2) ).

fof(bitBlastConstant_445,axiom,
    b01010(bitIndex1) ).

fof(bitBlastConstant_444,axiom,
    ~ b01010(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_152,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1422(VarNext)
      <=> ( v1423(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_151,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1423(VarNext)
      <=> ( v1425(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_54,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1425(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_13,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01001_address_term = A
              & v1412(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_14__array(VarNext,A,B)
              <=> v1060_13__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_13,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01001_address_term = A
            & v1412(VarNext) )
         => ( ( v1060_14__array(VarNext,A,bitIndex43)
            <=> v1419(VarNext,bitIndex439) )
            & ( v1060_14__array(VarNext,A,bitIndex42)
            <=> v1419(VarNext,bitIndex438) )
            & ( v1060_14__array(VarNext,A,bitIndex41)
            <=> v1419(VarNext,bitIndex437) )
            & ( v1060_14__array(VarNext,A,bitIndex40)
            <=> v1419(VarNext,bitIndex436) )
            & ( v1060_14__array(VarNext,A,bitIndex39)
            <=> v1419(VarNext,bitIndex435) )
            & ( v1060_14__array(VarNext,A,bitIndex38)
            <=> v1419(VarNext,bitIndex434) )
            & ( v1060_14__array(VarNext,A,bitIndex37)
            <=> v1419(VarNext,bitIndex433) )
            & ( v1060_14__array(VarNext,A,bitIndex36)
            <=> v1419(VarNext,bitIndex432) )
            & ( v1060_14__array(VarNext,A,bitIndex35)
            <=> v1419(VarNext,bitIndex431) )
            & ( v1060_14__array(VarNext,A,bitIndex34)
            <=> v1419(VarNext,bitIndex430) )
            & ( v1060_14__array(VarNext,A,bitIndex33)
            <=> v1419(VarNext,bitIndex429) )
            & ( v1060_14__array(VarNext,A,bitIndex32)
            <=> v1419(VarNext,bitIndex428) )
            & ( v1060_14__array(VarNext,A,bitIndex31)
            <=> v1419(VarNext,bitIndex427) )
            & ( v1060_14__array(VarNext,A,bitIndex30)
            <=> v1419(VarNext,bitIndex426) )
            & ( v1060_14__array(VarNext,A,bitIndex29)
            <=> v1419(VarNext,bitIndex425) )
            & ( v1060_14__array(VarNext,A,bitIndex28)
            <=> v1419(VarNext,bitIndex424) )
            & ( v1060_14__array(VarNext,A,bitIndex27)
            <=> v1419(VarNext,bitIndex423) )
            & ( v1060_14__array(VarNext,A,bitIndex26)
            <=> v1419(VarNext,bitIndex422) )
            & ( v1060_14__array(VarNext,A,bitIndex25)
            <=> v1419(VarNext,bitIndex421) )
            & ( v1060_14__array(VarNext,A,bitIndex24)
            <=> v1419(VarNext,bitIndex420) )
            & ( v1060_14__array(VarNext,A,bitIndex23)
            <=> v1419(VarNext,bitIndex419) )
            & ( v1060_14__array(VarNext,A,bitIndex22)
            <=> v1419(VarNext,bitIndex418) )
            & ( v1060_14__array(VarNext,A,bitIndex21)
            <=> v1419(VarNext,bitIndex417) )
            & ( v1060_14__array(VarNext,A,bitIndex20)
            <=> v1419(VarNext,bitIndex416) )
            & ( v1060_14__array(VarNext,A,bitIndex19)
            <=> v1419(VarNext,bitIndex415) )
            & ( v1060_14__array(VarNext,A,bitIndex18)
            <=> v1419(VarNext,bitIndex414) )
            & ( v1060_14__array(VarNext,A,bitIndex17)
            <=> v1419(VarNext,bitIndex413) )
            & ( v1060_14__array(VarNext,A,bitIndex16)
            <=> v1419(VarNext,bitIndex412) )
            & ( v1060_14__array(VarNext,A,bitIndex15)
            <=> v1419(VarNext,bitIndex411) )
            & ( v1060_14__array(VarNext,A,bitIndex14)
            <=> v1419(VarNext,bitIndex410) )
            & ( v1060_14__array(VarNext,A,bitIndex13)
            <=> v1419(VarNext,bitIndex409) )
            & ( v1060_14__array(VarNext,A,bitIndex12)
            <=> v1419(VarNext,bitIndex408) )
            & ( v1060_14__array(VarNext,A,bitIndex11)
            <=> v1419(VarNext,bitIndex407) )
            & ( v1060_14__array(VarNext,A,bitIndex10)
            <=> v1419(VarNext,bitIndex406) )
            & ( v1060_14__array(VarNext,A,bitIndex9)
            <=> v1419(VarNext,bitIndex405) )
            & ( v1060_14__array(VarNext,A,bitIndex8)
            <=> v1419(VarNext,bitIndex404) )
            & ( v1060_14__array(VarNext,A,bitIndex7)
            <=> v1419(VarNext,bitIndex403) )
            & ( v1060_14__array(VarNext,A,bitIndex6)
            <=> v1419(VarNext,bitIndex402) )
            & ( v1060_14__array(VarNext,A,bitIndex5)
            <=> v1419(VarNext,bitIndex401) )
            & ( v1060_14__array(VarNext,A,bitIndex4)
            <=> v1419(VarNext,bitIndex400) )
            & ( v1060_14__array(VarNext,A,bitIndex3)
            <=> v1419(VarNext,bitIndex399) )
            & ( v1060_14__array(VarNext,A,bitIndex2)
            <=> v1419(VarNext,bitIndex398) )
            & ( v1060_14__array(VarNext,A,bitIndex1)
            <=> v1419(VarNext,bitIndex397) )
            & ( v1060_14__array(VarNext,A,bitIndex0)
            <=> v1419(VarNext,bitIndex396) ) ) ) ) ).

fof(bitBlastConstant_443,axiom,
    ~ b01001(bitIndex4) ).

fof(bitBlastConstant_442,axiom,
    b01001(bitIndex3) ).

fof(bitBlastConstant_441,axiom,
    ~ b01001(bitIndex2) ).

fof(bitBlastConstant_440,axiom,
    ~ b01001(bitIndex1) ).

fof(bitBlastConstant_439,axiom,
    b01001(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_150,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1412(VarNext)
      <=> ( v1413(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_149,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1413(VarNext)
      <=> ( v1415(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_53,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1415(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_12,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01000_address_term = A
              & v1402(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_13__array(VarNext,A,B)
              <=> v1060_12__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_12,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01000_address_term = A
            & v1402(VarNext) )
         => ( ( v1060_13__array(VarNext,A,bitIndex43)
            <=> v1409(VarNext,bitIndex395) )
            & ( v1060_13__array(VarNext,A,bitIndex42)
            <=> v1409(VarNext,bitIndex394) )
            & ( v1060_13__array(VarNext,A,bitIndex41)
            <=> v1409(VarNext,bitIndex393) )
            & ( v1060_13__array(VarNext,A,bitIndex40)
            <=> v1409(VarNext,bitIndex392) )
            & ( v1060_13__array(VarNext,A,bitIndex39)
            <=> v1409(VarNext,bitIndex391) )
            & ( v1060_13__array(VarNext,A,bitIndex38)
            <=> v1409(VarNext,bitIndex390) )
            & ( v1060_13__array(VarNext,A,bitIndex37)
            <=> v1409(VarNext,bitIndex389) )
            & ( v1060_13__array(VarNext,A,bitIndex36)
            <=> v1409(VarNext,bitIndex388) )
            & ( v1060_13__array(VarNext,A,bitIndex35)
            <=> v1409(VarNext,bitIndex387) )
            & ( v1060_13__array(VarNext,A,bitIndex34)
            <=> v1409(VarNext,bitIndex386) )
            & ( v1060_13__array(VarNext,A,bitIndex33)
            <=> v1409(VarNext,bitIndex385) )
            & ( v1060_13__array(VarNext,A,bitIndex32)
            <=> v1409(VarNext,bitIndex384) )
            & ( v1060_13__array(VarNext,A,bitIndex31)
            <=> v1409(VarNext,bitIndex383) )
            & ( v1060_13__array(VarNext,A,bitIndex30)
            <=> v1409(VarNext,bitIndex382) )
            & ( v1060_13__array(VarNext,A,bitIndex29)
            <=> v1409(VarNext,bitIndex381) )
            & ( v1060_13__array(VarNext,A,bitIndex28)
            <=> v1409(VarNext,bitIndex380) )
            & ( v1060_13__array(VarNext,A,bitIndex27)
            <=> v1409(VarNext,bitIndex379) )
            & ( v1060_13__array(VarNext,A,bitIndex26)
            <=> v1409(VarNext,bitIndex378) )
            & ( v1060_13__array(VarNext,A,bitIndex25)
            <=> v1409(VarNext,bitIndex377) )
            & ( v1060_13__array(VarNext,A,bitIndex24)
            <=> v1409(VarNext,bitIndex376) )
            & ( v1060_13__array(VarNext,A,bitIndex23)
            <=> v1409(VarNext,bitIndex375) )
            & ( v1060_13__array(VarNext,A,bitIndex22)
            <=> v1409(VarNext,bitIndex374) )
            & ( v1060_13__array(VarNext,A,bitIndex21)
            <=> v1409(VarNext,bitIndex373) )
            & ( v1060_13__array(VarNext,A,bitIndex20)
            <=> v1409(VarNext,bitIndex372) )
            & ( v1060_13__array(VarNext,A,bitIndex19)
            <=> v1409(VarNext,bitIndex371) )
            & ( v1060_13__array(VarNext,A,bitIndex18)
            <=> v1409(VarNext,bitIndex370) )
            & ( v1060_13__array(VarNext,A,bitIndex17)
            <=> v1409(VarNext,bitIndex369) )
            & ( v1060_13__array(VarNext,A,bitIndex16)
            <=> v1409(VarNext,bitIndex368) )
            & ( v1060_13__array(VarNext,A,bitIndex15)
            <=> v1409(VarNext,bitIndex367) )
            & ( v1060_13__array(VarNext,A,bitIndex14)
            <=> v1409(VarNext,bitIndex366) )
            & ( v1060_13__array(VarNext,A,bitIndex13)
            <=> v1409(VarNext,bitIndex365) )
            & ( v1060_13__array(VarNext,A,bitIndex12)
            <=> v1409(VarNext,bitIndex364) )
            & ( v1060_13__array(VarNext,A,bitIndex11)
            <=> v1409(VarNext,bitIndex363) )
            & ( v1060_13__array(VarNext,A,bitIndex10)
            <=> v1409(VarNext,bitIndex362) )
            & ( v1060_13__array(VarNext,A,bitIndex9)
            <=> v1409(VarNext,bitIndex361) )
            & ( v1060_13__array(VarNext,A,bitIndex8)
            <=> v1409(VarNext,bitIndex360) )
            & ( v1060_13__array(VarNext,A,bitIndex7)
            <=> v1409(VarNext,bitIndex359) )
            & ( v1060_13__array(VarNext,A,bitIndex6)
            <=> v1409(VarNext,bitIndex358) )
            & ( v1060_13__array(VarNext,A,bitIndex5)
            <=> v1409(VarNext,bitIndex357) )
            & ( v1060_13__array(VarNext,A,bitIndex4)
            <=> v1409(VarNext,bitIndex356) )
            & ( v1060_13__array(VarNext,A,bitIndex3)
            <=> v1409(VarNext,bitIndex355) )
            & ( v1060_13__array(VarNext,A,bitIndex2)
            <=> v1409(VarNext,bitIndex354) )
            & ( v1060_13__array(VarNext,A,bitIndex1)
            <=> v1409(VarNext,bitIndex353) )
            & ( v1060_13__array(VarNext,A,bitIndex0)
            <=> v1409(VarNext,bitIndex352) ) ) ) ) ).

fof(bitBlastConstant_438,axiom,
    ~ b01000(bitIndex4) ).

fof(bitBlastConstant_437,axiom,
    b01000(bitIndex3) ).

fof(bitBlastConstant_436,axiom,
    ~ b01000(bitIndex2) ).

fof(bitBlastConstant_435,axiom,
    ~ b01000(bitIndex1) ).

fof(bitBlastConstant_434,axiom,
    ~ b01000(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_148,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1402(VarNext)
      <=> ( v1403(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_147,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1403(VarNext)
      <=> ( v1405(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_52,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1405(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_11,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00111_address_term = A
              & v1392(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_12__array(VarNext,A,B)
              <=> v1060_11__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_11,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00111_address_term = A
            & v1392(VarNext) )
         => ( ( v1060_12__array(VarNext,A,bitIndex43)
            <=> v1399(VarNext,bitIndex351) )
            & ( v1060_12__array(VarNext,A,bitIndex42)
            <=> v1399(VarNext,bitIndex350) )
            & ( v1060_12__array(VarNext,A,bitIndex41)
            <=> v1399(VarNext,bitIndex349) )
            & ( v1060_12__array(VarNext,A,bitIndex40)
            <=> v1399(VarNext,bitIndex348) )
            & ( v1060_12__array(VarNext,A,bitIndex39)
            <=> v1399(VarNext,bitIndex347) )
            & ( v1060_12__array(VarNext,A,bitIndex38)
            <=> v1399(VarNext,bitIndex346) )
            & ( v1060_12__array(VarNext,A,bitIndex37)
            <=> v1399(VarNext,bitIndex345) )
            & ( v1060_12__array(VarNext,A,bitIndex36)
            <=> v1399(VarNext,bitIndex344) )
            & ( v1060_12__array(VarNext,A,bitIndex35)
            <=> v1399(VarNext,bitIndex343) )
            & ( v1060_12__array(VarNext,A,bitIndex34)
            <=> v1399(VarNext,bitIndex342) )
            & ( v1060_12__array(VarNext,A,bitIndex33)
            <=> v1399(VarNext,bitIndex341) )
            & ( v1060_12__array(VarNext,A,bitIndex32)
            <=> v1399(VarNext,bitIndex340) )
            & ( v1060_12__array(VarNext,A,bitIndex31)
            <=> v1399(VarNext,bitIndex339) )
            & ( v1060_12__array(VarNext,A,bitIndex30)
            <=> v1399(VarNext,bitIndex338) )
            & ( v1060_12__array(VarNext,A,bitIndex29)
            <=> v1399(VarNext,bitIndex337) )
            & ( v1060_12__array(VarNext,A,bitIndex28)
            <=> v1399(VarNext,bitIndex336) )
            & ( v1060_12__array(VarNext,A,bitIndex27)
            <=> v1399(VarNext,bitIndex335) )
            & ( v1060_12__array(VarNext,A,bitIndex26)
            <=> v1399(VarNext,bitIndex334) )
            & ( v1060_12__array(VarNext,A,bitIndex25)
            <=> v1399(VarNext,bitIndex333) )
            & ( v1060_12__array(VarNext,A,bitIndex24)
            <=> v1399(VarNext,bitIndex332) )
            & ( v1060_12__array(VarNext,A,bitIndex23)
            <=> v1399(VarNext,bitIndex331) )
            & ( v1060_12__array(VarNext,A,bitIndex22)
            <=> v1399(VarNext,bitIndex330) )
            & ( v1060_12__array(VarNext,A,bitIndex21)
            <=> v1399(VarNext,bitIndex329) )
            & ( v1060_12__array(VarNext,A,bitIndex20)
            <=> v1399(VarNext,bitIndex328) )
            & ( v1060_12__array(VarNext,A,bitIndex19)
            <=> v1399(VarNext,bitIndex327) )
            & ( v1060_12__array(VarNext,A,bitIndex18)
            <=> v1399(VarNext,bitIndex326) )
            & ( v1060_12__array(VarNext,A,bitIndex17)
            <=> v1399(VarNext,bitIndex325) )
            & ( v1060_12__array(VarNext,A,bitIndex16)
            <=> v1399(VarNext,bitIndex324) )
            & ( v1060_12__array(VarNext,A,bitIndex15)
            <=> v1399(VarNext,bitIndex323) )
            & ( v1060_12__array(VarNext,A,bitIndex14)
            <=> v1399(VarNext,bitIndex322) )
            & ( v1060_12__array(VarNext,A,bitIndex13)
            <=> v1399(VarNext,bitIndex321) )
            & ( v1060_12__array(VarNext,A,bitIndex12)
            <=> v1399(VarNext,bitIndex320) )
            & ( v1060_12__array(VarNext,A,bitIndex11)
            <=> v1399(VarNext,bitIndex319) )
            & ( v1060_12__array(VarNext,A,bitIndex10)
            <=> v1399(VarNext,bitIndex318) )
            & ( v1060_12__array(VarNext,A,bitIndex9)
            <=> v1399(VarNext,bitIndex317) )
            & ( v1060_12__array(VarNext,A,bitIndex8)
            <=> v1399(VarNext,bitIndex316) )
            & ( v1060_12__array(VarNext,A,bitIndex7)
            <=> v1399(VarNext,bitIndex315) )
            & ( v1060_12__array(VarNext,A,bitIndex6)
            <=> v1399(VarNext,bitIndex314) )
            & ( v1060_12__array(VarNext,A,bitIndex5)
            <=> v1399(VarNext,bitIndex313) )
            & ( v1060_12__array(VarNext,A,bitIndex4)
            <=> v1399(VarNext,bitIndex312) )
            & ( v1060_12__array(VarNext,A,bitIndex3)
            <=> v1399(VarNext,bitIndex311) )
            & ( v1060_12__array(VarNext,A,bitIndex2)
            <=> v1399(VarNext,bitIndex310) )
            & ( v1060_12__array(VarNext,A,bitIndex1)
            <=> v1399(VarNext,bitIndex309) )
            & ( v1060_12__array(VarNext,A,bitIndex0)
            <=> v1399(VarNext,bitIndex308) ) ) ) ) ).

fof(bitBlastConstant_433,axiom,
    ~ b00111(bitIndex4) ).

fof(bitBlastConstant_432,axiom,
    ~ b00111(bitIndex3) ).

fof(bitBlastConstant_431,axiom,
    b00111(bitIndex2) ).

fof(bitBlastConstant_430,axiom,
    b00111(bitIndex1) ).

fof(bitBlastConstant_429,axiom,
    b00111(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_146,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1392(VarNext)
      <=> ( v1393(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_145,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1393(VarNext)
      <=> ( v1395(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_51,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1395(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_10,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00110_address_term = A
              & v1382(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_11__array(VarNext,A,B)
              <=> v1060_10__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_10,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00110_address_term = A
            & v1382(VarNext) )
         => ( ( v1060_11__array(VarNext,A,bitIndex43)
            <=> v1389(VarNext,bitIndex307) )
            & ( v1060_11__array(VarNext,A,bitIndex42)
            <=> v1389(VarNext,bitIndex306) )
            & ( v1060_11__array(VarNext,A,bitIndex41)
            <=> v1389(VarNext,bitIndex305) )
            & ( v1060_11__array(VarNext,A,bitIndex40)
            <=> v1389(VarNext,bitIndex304) )
            & ( v1060_11__array(VarNext,A,bitIndex39)
            <=> v1389(VarNext,bitIndex303) )
            & ( v1060_11__array(VarNext,A,bitIndex38)
            <=> v1389(VarNext,bitIndex302) )
            & ( v1060_11__array(VarNext,A,bitIndex37)
            <=> v1389(VarNext,bitIndex301) )
            & ( v1060_11__array(VarNext,A,bitIndex36)
            <=> v1389(VarNext,bitIndex300) )
            & ( v1060_11__array(VarNext,A,bitIndex35)
            <=> v1389(VarNext,bitIndex299) )
            & ( v1060_11__array(VarNext,A,bitIndex34)
            <=> v1389(VarNext,bitIndex298) )
            & ( v1060_11__array(VarNext,A,bitIndex33)
            <=> v1389(VarNext,bitIndex297) )
            & ( v1060_11__array(VarNext,A,bitIndex32)
            <=> v1389(VarNext,bitIndex296) )
            & ( v1060_11__array(VarNext,A,bitIndex31)
            <=> v1389(VarNext,bitIndex295) )
            & ( v1060_11__array(VarNext,A,bitIndex30)
            <=> v1389(VarNext,bitIndex294) )
            & ( v1060_11__array(VarNext,A,bitIndex29)
            <=> v1389(VarNext,bitIndex293) )
            & ( v1060_11__array(VarNext,A,bitIndex28)
            <=> v1389(VarNext,bitIndex292) )
            & ( v1060_11__array(VarNext,A,bitIndex27)
            <=> v1389(VarNext,bitIndex291) )
            & ( v1060_11__array(VarNext,A,bitIndex26)
            <=> v1389(VarNext,bitIndex290) )
            & ( v1060_11__array(VarNext,A,bitIndex25)
            <=> v1389(VarNext,bitIndex289) )
            & ( v1060_11__array(VarNext,A,bitIndex24)
            <=> v1389(VarNext,bitIndex288) )
            & ( v1060_11__array(VarNext,A,bitIndex23)
            <=> v1389(VarNext,bitIndex287) )
            & ( v1060_11__array(VarNext,A,bitIndex22)
            <=> v1389(VarNext,bitIndex286) )
            & ( v1060_11__array(VarNext,A,bitIndex21)
            <=> v1389(VarNext,bitIndex285) )
            & ( v1060_11__array(VarNext,A,bitIndex20)
            <=> v1389(VarNext,bitIndex284) )
            & ( v1060_11__array(VarNext,A,bitIndex19)
            <=> v1389(VarNext,bitIndex283) )
            & ( v1060_11__array(VarNext,A,bitIndex18)
            <=> v1389(VarNext,bitIndex282) )
            & ( v1060_11__array(VarNext,A,bitIndex17)
            <=> v1389(VarNext,bitIndex281) )
            & ( v1060_11__array(VarNext,A,bitIndex16)
            <=> v1389(VarNext,bitIndex280) )
            & ( v1060_11__array(VarNext,A,bitIndex15)
            <=> v1389(VarNext,bitIndex279) )
            & ( v1060_11__array(VarNext,A,bitIndex14)
            <=> v1389(VarNext,bitIndex278) )
            & ( v1060_11__array(VarNext,A,bitIndex13)
            <=> v1389(VarNext,bitIndex277) )
            & ( v1060_11__array(VarNext,A,bitIndex12)
            <=> v1389(VarNext,bitIndex276) )
            & ( v1060_11__array(VarNext,A,bitIndex11)
            <=> v1389(VarNext,bitIndex275) )
            & ( v1060_11__array(VarNext,A,bitIndex10)
            <=> v1389(VarNext,bitIndex274) )
            & ( v1060_11__array(VarNext,A,bitIndex9)
            <=> v1389(VarNext,bitIndex273) )
            & ( v1060_11__array(VarNext,A,bitIndex8)
            <=> v1389(VarNext,bitIndex272) )
            & ( v1060_11__array(VarNext,A,bitIndex7)
            <=> v1389(VarNext,bitIndex271) )
            & ( v1060_11__array(VarNext,A,bitIndex6)
            <=> v1389(VarNext,bitIndex270) )
            & ( v1060_11__array(VarNext,A,bitIndex5)
            <=> v1389(VarNext,bitIndex269) )
            & ( v1060_11__array(VarNext,A,bitIndex4)
            <=> v1389(VarNext,bitIndex268) )
            & ( v1060_11__array(VarNext,A,bitIndex3)
            <=> v1389(VarNext,bitIndex267) )
            & ( v1060_11__array(VarNext,A,bitIndex2)
            <=> v1389(VarNext,bitIndex266) )
            & ( v1060_11__array(VarNext,A,bitIndex1)
            <=> v1389(VarNext,bitIndex265) )
            & ( v1060_11__array(VarNext,A,bitIndex0)
            <=> v1389(VarNext,bitIndex264) ) ) ) ) ).

fof(bitBlastConstant_428,axiom,
    ~ b00110(bitIndex4) ).

fof(bitBlastConstant_427,axiom,
    ~ b00110(bitIndex3) ).

fof(bitBlastConstant_426,axiom,
    b00110(bitIndex2) ).

fof(bitBlastConstant_425,axiom,
    b00110(bitIndex1) ).

fof(bitBlastConstant_424,axiom,
    ~ b00110(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_144,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1382(VarNext)
      <=> ( v1383(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_143,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1383(VarNext)
      <=> ( v1385(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_50,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1385(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_9,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00101_address_term = A
              & v1372(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_10__array(VarNext,A,B)
              <=> v1060_9__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_9,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00101_address_term = A
            & v1372(VarNext) )
         => ( ( v1060_10__array(VarNext,A,bitIndex43)
            <=> v1379(VarNext,bitIndex263) )
            & ( v1060_10__array(VarNext,A,bitIndex42)
            <=> v1379(VarNext,bitIndex262) )
            & ( v1060_10__array(VarNext,A,bitIndex41)
            <=> v1379(VarNext,bitIndex261) )
            & ( v1060_10__array(VarNext,A,bitIndex40)
            <=> v1379(VarNext,bitIndex260) )
            & ( v1060_10__array(VarNext,A,bitIndex39)
            <=> v1379(VarNext,bitIndex259) )
            & ( v1060_10__array(VarNext,A,bitIndex38)
            <=> v1379(VarNext,bitIndex258) )
            & ( v1060_10__array(VarNext,A,bitIndex37)
            <=> v1379(VarNext,bitIndex257) )
            & ( v1060_10__array(VarNext,A,bitIndex36)
            <=> v1379(VarNext,bitIndex256) )
            & ( v1060_10__array(VarNext,A,bitIndex35)
            <=> v1379(VarNext,bitIndex255) )
            & ( v1060_10__array(VarNext,A,bitIndex34)
            <=> v1379(VarNext,bitIndex254) )
            & ( v1060_10__array(VarNext,A,bitIndex33)
            <=> v1379(VarNext,bitIndex253) )
            & ( v1060_10__array(VarNext,A,bitIndex32)
            <=> v1379(VarNext,bitIndex252) )
            & ( v1060_10__array(VarNext,A,bitIndex31)
            <=> v1379(VarNext,bitIndex251) )
            & ( v1060_10__array(VarNext,A,bitIndex30)
            <=> v1379(VarNext,bitIndex250) )
            & ( v1060_10__array(VarNext,A,bitIndex29)
            <=> v1379(VarNext,bitIndex249) )
            & ( v1060_10__array(VarNext,A,bitIndex28)
            <=> v1379(VarNext,bitIndex248) )
            & ( v1060_10__array(VarNext,A,bitIndex27)
            <=> v1379(VarNext,bitIndex247) )
            & ( v1060_10__array(VarNext,A,bitIndex26)
            <=> v1379(VarNext,bitIndex246) )
            & ( v1060_10__array(VarNext,A,bitIndex25)
            <=> v1379(VarNext,bitIndex245) )
            & ( v1060_10__array(VarNext,A,bitIndex24)
            <=> v1379(VarNext,bitIndex244) )
            & ( v1060_10__array(VarNext,A,bitIndex23)
            <=> v1379(VarNext,bitIndex243) )
            & ( v1060_10__array(VarNext,A,bitIndex22)
            <=> v1379(VarNext,bitIndex242) )
            & ( v1060_10__array(VarNext,A,bitIndex21)
            <=> v1379(VarNext,bitIndex241) )
            & ( v1060_10__array(VarNext,A,bitIndex20)
            <=> v1379(VarNext,bitIndex240) )
            & ( v1060_10__array(VarNext,A,bitIndex19)
            <=> v1379(VarNext,bitIndex239) )
            & ( v1060_10__array(VarNext,A,bitIndex18)
            <=> v1379(VarNext,bitIndex238) )
            & ( v1060_10__array(VarNext,A,bitIndex17)
            <=> v1379(VarNext,bitIndex237) )
            & ( v1060_10__array(VarNext,A,bitIndex16)
            <=> v1379(VarNext,bitIndex236) )
            & ( v1060_10__array(VarNext,A,bitIndex15)
            <=> v1379(VarNext,bitIndex235) )
            & ( v1060_10__array(VarNext,A,bitIndex14)
            <=> v1379(VarNext,bitIndex234) )
            & ( v1060_10__array(VarNext,A,bitIndex13)
            <=> v1379(VarNext,bitIndex233) )
            & ( v1060_10__array(VarNext,A,bitIndex12)
            <=> v1379(VarNext,bitIndex232) )
            & ( v1060_10__array(VarNext,A,bitIndex11)
            <=> v1379(VarNext,bitIndex231) )
            & ( v1060_10__array(VarNext,A,bitIndex10)
            <=> v1379(VarNext,bitIndex230) )
            & ( v1060_10__array(VarNext,A,bitIndex9)
            <=> v1379(VarNext,bitIndex229) )
            & ( v1060_10__array(VarNext,A,bitIndex8)
            <=> v1379(VarNext,bitIndex228) )
            & ( v1060_10__array(VarNext,A,bitIndex7)
            <=> v1379(VarNext,bitIndex227) )
            & ( v1060_10__array(VarNext,A,bitIndex6)
            <=> v1379(VarNext,bitIndex226) )
            & ( v1060_10__array(VarNext,A,bitIndex5)
            <=> v1379(VarNext,bitIndex225) )
            & ( v1060_10__array(VarNext,A,bitIndex4)
            <=> v1379(VarNext,bitIndex224) )
            & ( v1060_10__array(VarNext,A,bitIndex3)
            <=> v1379(VarNext,bitIndex223) )
            & ( v1060_10__array(VarNext,A,bitIndex2)
            <=> v1379(VarNext,bitIndex222) )
            & ( v1060_10__array(VarNext,A,bitIndex1)
            <=> v1379(VarNext,bitIndex221) )
            & ( v1060_10__array(VarNext,A,bitIndex0)
            <=> v1379(VarNext,bitIndex220) ) ) ) ) ).

fof(bitBlastConstant_423,axiom,
    ~ b00101(bitIndex4) ).

fof(bitBlastConstant_422,axiom,
    ~ b00101(bitIndex3) ).

fof(bitBlastConstant_421,axiom,
    b00101(bitIndex2) ).

fof(bitBlastConstant_420,axiom,
    ~ b00101(bitIndex1) ).

fof(bitBlastConstant_419,axiom,
    b00101(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_142,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1372(VarNext)
      <=> ( v1373(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_141,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1373(VarNext)
      <=> ( v1375(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_49,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1375(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_8,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00100_address_term = A
              & v1362(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_9__array(VarNext,A,B)
              <=> v1060_8__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_8,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00100_address_term = A
            & v1362(VarNext) )
         => ( ( v1060_9__array(VarNext,A,bitIndex43)
            <=> v1369(VarNext,bitIndex219) )
            & ( v1060_9__array(VarNext,A,bitIndex42)
            <=> v1369(VarNext,bitIndex218) )
            & ( v1060_9__array(VarNext,A,bitIndex41)
            <=> v1369(VarNext,bitIndex217) )
            & ( v1060_9__array(VarNext,A,bitIndex40)
            <=> v1369(VarNext,bitIndex216) )
            & ( v1060_9__array(VarNext,A,bitIndex39)
            <=> v1369(VarNext,bitIndex215) )
            & ( v1060_9__array(VarNext,A,bitIndex38)
            <=> v1369(VarNext,bitIndex214) )
            & ( v1060_9__array(VarNext,A,bitIndex37)
            <=> v1369(VarNext,bitIndex213) )
            & ( v1060_9__array(VarNext,A,bitIndex36)
            <=> v1369(VarNext,bitIndex212) )
            & ( v1060_9__array(VarNext,A,bitIndex35)
            <=> v1369(VarNext,bitIndex211) )
            & ( v1060_9__array(VarNext,A,bitIndex34)
            <=> v1369(VarNext,bitIndex210) )
            & ( v1060_9__array(VarNext,A,bitIndex33)
            <=> v1369(VarNext,bitIndex209) )
            & ( v1060_9__array(VarNext,A,bitIndex32)
            <=> v1369(VarNext,bitIndex208) )
            & ( v1060_9__array(VarNext,A,bitIndex31)
            <=> v1369(VarNext,bitIndex207) )
            & ( v1060_9__array(VarNext,A,bitIndex30)
            <=> v1369(VarNext,bitIndex206) )
            & ( v1060_9__array(VarNext,A,bitIndex29)
            <=> v1369(VarNext,bitIndex205) )
            & ( v1060_9__array(VarNext,A,bitIndex28)
            <=> v1369(VarNext,bitIndex204) )
            & ( v1060_9__array(VarNext,A,bitIndex27)
            <=> v1369(VarNext,bitIndex203) )
            & ( v1060_9__array(VarNext,A,bitIndex26)
            <=> v1369(VarNext,bitIndex202) )
            & ( v1060_9__array(VarNext,A,bitIndex25)
            <=> v1369(VarNext,bitIndex201) )
            & ( v1060_9__array(VarNext,A,bitIndex24)
            <=> v1369(VarNext,bitIndex200) )
            & ( v1060_9__array(VarNext,A,bitIndex23)
            <=> v1369(VarNext,bitIndex199) )
            & ( v1060_9__array(VarNext,A,bitIndex22)
            <=> v1369(VarNext,bitIndex198) )
            & ( v1060_9__array(VarNext,A,bitIndex21)
            <=> v1369(VarNext,bitIndex197) )
            & ( v1060_9__array(VarNext,A,bitIndex20)
            <=> v1369(VarNext,bitIndex196) )
            & ( v1060_9__array(VarNext,A,bitIndex19)
            <=> v1369(VarNext,bitIndex195) )
            & ( v1060_9__array(VarNext,A,bitIndex18)
            <=> v1369(VarNext,bitIndex194) )
            & ( v1060_9__array(VarNext,A,bitIndex17)
            <=> v1369(VarNext,bitIndex193) )
            & ( v1060_9__array(VarNext,A,bitIndex16)
            <=> v1369(VarNext,bitIndex192) )
            & ( v1060_9__array(VarNext,A,bitIndex15)
            <=> v1369(VarNext,bitIndex191) )
            & ( v1060_9__array(VarNext,A,bitIndex14)
            <=> v1369(VarNext,bitIndex190) )
            & ( v1060_9__array(VarNext,A,bitIndex13)
            <=> v1369(VarNext,bitIndex189) )
            & ( v1060_9__array(VarNext,A,bitIndex12)
            <=> v1369(VarNext,bitIndex188) )
            & ( v1060_9__array(VarNext,A,bitIndex11)
            <=> v1369(VarNext,bitIndex187) )
            & ( v1060_9__array(VarNext,A,bitIndex10)
            <=> v1369(VarNext,bitIndex186) )
            & ( v1060_9__array(VarNext,A,bitIndex9)
            <=> v1369(VarNext,bitIndex185) )
            & ( v1060_9__array(VarNext,A,bitIndex8)
            <=> v1369(VarNext,bitIndex184) )
            & ( v1060_9__array(VarNext,A,bitIndex7)
            <=> v1369(VarNext,bitIndex183) )
            & ( v1060_9__array(VarNext,A,bitIndex6)
            <=> v1369(VarNext,bitIndex182) )
            & ( v1060_9__array(VarNext,A,bitIndex5)
            <=> v1369(VarNext,bitIndex181) )
            & ( v1060_9__array(VarNext,A,bitIndex4)
            <=> v1369(VarNext,bitIndex180) )
            & ( v1060_9__array(VarNext,A,bitIndex3)
            <=> v1369(VarNext,bitIndex179) )
            & ( v1060_9__array(VarNext,A,bitIndex2)
            <=> v1369(VarNext,bitIndex178) )
            & ( v1060_9__array(VarNext,A,bitIndex1)
            <=> v1369(VarNext,bitIndex177) )
            & ( v1060_9__array(VarNext,A,bitIndex0)
            <=> v1369(VarNext,bitIndex176) ) ) ) ) ).

fof(bitBlastConstant_418,axiom,
    ~ b00100(bitIndex4) ).

fof(bitBlastConstant_417,axiom,
    ~ b00100(bitIndex3) ).

fof(bitBlastConstant_416,axiom,
    b00100(bitIndex2) ).

fof(bitBlastConstant_415,axiom,
    ~ b00100(bitIndex1) ).

fof(bitBlastConstant_414,axiom,
    ~ b00100(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_140,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1362(VarNext)
      <=> ( v1363(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_139,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1363(VarNext)
      <=> ( v1365(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_48,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1365(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_7,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00011_address_term = A
              & v1352(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_8__array(VarNext,A,B)
              <=> v1060_7__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_7,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00011_address_term = A
            & v1352(VarNext) )
         => ( ( v1060_8__array(VarNext,A,bitIndex43)
            <=> v1359(VarNext,bitIndex175) )
            & ( v1060_8__array(VarNext,A,bitIndex42)
            <=> v1359(VarNext,bitIndex174) )
            & ( v1060_8__array(VarNext,A,bitIndex41)
            <=> v1359(VarNext,bitIndex173) )
            & ( v1060_8__array(VarNext,A,bitIndex40)
            <=> v1359(VarNext,bitIndex172) )
            & ( v1060_8__array(VarNext,A,bitIndex39)
            <=> v1359(VarNext,bitIndex171) )
            & ( v1060_8__array(VarNext,A,bitIndex38)
            <=> v1359(VarNext,bitIndex170) )
            & ( v1060_8__array(VarNext,A,bitIndex37)
            <=> v1359(VarNext,bitIndex169) )
            & ( v1060_8__array(VarNext,A,bitIndex36)
            <=> v1359(VarNext,bitIndex168) )
            & ( v1060_8__array(VarNext,A,bitIndex35)
            <=> v1359(VarNext,bitIndex167) )
            & ( v1060_8__array(VarNext,A,bitIndex34)
            <=> v1359(VarNext,bitIndex166) )
            & ( v1060_8__array(VarNext,A,bitIndex33)
            <=> v1359(VarNext,bitIndex165) )
            & ( v1060_8__array(VarNext,A,bitIndex32)
            <=> v1359(VarNext,bitIndex164) )
            & ( v1060_8__array(VarNext,A,bitIndex31)
            <=> v1359(VarNext,bitIndex163) )
            & ( v1060_8__array(VarNext,A,bitIndex30)
            <=> v1359(VarNext,bitIndex162) )
            & ( v1060_8__array(VarNext,A,bitIndex29)
            <=> v1359(VarNext,bitIndex161) )
            & ( v1060_8__array(VarNext,A,bitIndex28)
            <=> v1359(VarNext,bitIndex160) )
            & ( v1060_8__array(VarNext,A,bitIndex27)
            <=> v1359(VarNext,bitIndex159) )
            & ( v1060_8__array(VarNext,A,bitIndex26)
            <=> v1359(VarNext,bitIndex158) )
            & ( v1060_8__array(VarNext,A,bitIndex25)
            <=> v1359(VarNext,bitIndex157) )
            & ( v1060_8__array(VarNext,A,bitIndex24)
            <=> v1359(VarNext,bitIndex156) )
            & ( v1060_8__array(VarNext,A,bitIndex23)
            <=> v1359(VarNext,bitIndex155) )
            & ( v1060_8__array(VarNext,A,bitIndex22)
            <=> v1359(VarNext,bitIndex154) )
            & ( v1060_8__array(VarNext,A,bitIndex21)
            <=> v1359(VarNext,bitIndex153) )
            & ( v1060_8__array(VarNext,A,bitIndex20)
            <=> v1359(VarNext,bitIndex152) )
            & ( v1060_8__array(VarNext,A,bitIndex19)
            <=> v1359(VarNext,bitIndex151) )
            & ( v1060_8__array(VarNext,A,bitIndex18)
            <=> v1359(VarNext,bitIndex150) )
            & ( v1060_8__array(VarNext,A,bitIndex17)
            <=> v1359(VarNext,bitIndex149) )
            & ( v1060_8__array(VarNext,A,bitIndex16)
            <=> v1359(VarNext,bitIndex148) )
            & ( v1060_8__array(VarNext,A,bitIndex15)
            <=> v1359(VarNext,bitIndex147) )
            & ( v1060_8__array(VarNext,A,bitIndex14)
            <=> v1359(VarNext,bitIndex146) )
            & ( v1060_8__array(VarNext,A,bitIndex13)
            <=> v1359(VarNext,bitIndex145) )
            & ( v1060_8__array(VarNext,A,bitIndex12)
            <=> v1359(VarNext,bitIndex144) )
            & ( v1060_8__array(VarNext,A,bitIndex11)
            <=> v1359(VarNext,bitIndex143) )
            & ( v1060_8__array(VarNext,A,bitIndex10)
            <=> v1359(VarNext,bitIndex142) )
            & ( v1060_8__array(VarNext,A,bitIndex9)
            <=> v1359(VarNext,bitIndex141) )
            & ( v1060_8__array(VarNext,A,bitIndex8)
            <=> v1359(VarNext,bitIndex140) )
            & ( v1060_8__array(VarNext,A,bitIndex7)
            <=> v1359(VarNext,bitIndex139) )
            & ( v1060_8__array(VarNext,A,bitIndex6)
            <=> v1359(VarNext,bitIndex138) )
            & ( v1060_8__array(VarNext,A,bitIndex5)
            <=> v1359(VarNext,bitIndex137) )
            & ( v1060_8__array(VarNext,A,bitIndex4)
            <=> v1359(VarNext,bitIndex136) )
            & ( v1060_8__array(VarNext,A,bitIndex3)
            <=> v1359(VarNext,bitIndex135) )
            & ( v1060_8__array(VarNext,A,bitIndex2)
            <=> v1359(VarNext,bitIndex134) )
            & ( v1060_8__array(VarNext,A,bitIndex1)
            <=> v1359(VarNext,bitIndex133) )
            & ( v1060_8__array(VarNext,A,bitIndex0)
            <=> v1359(VarNext,bitIndex132) ) ) ) ) ).

fof(bitBlastConstant_413,axiom,
    ~ b00011(bitIndex4) ).

fof(bitBlastConstant_412,axiom,
    ~ b00011(bitIndex3) ).

fof(bitBlastConstant_411,axiom,
    ~ b00011(bitIndex2) ).

fof(bitBlastConstant_410,axiom,
    b00011(bitIndex1) ).

fof(bitBlastConstant_409,axiom,
    b00011(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_138,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1352(VarNext)
      <=> ( v1353(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_137,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1353(VarNext)
      <=> ( v1355(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_47,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1355(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_6,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00010_address_term = A
              & v1342(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_7__array(VarNext,A,B)
              <=> v1060_6__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_6,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00010_address_term = A
            & v1342(VarNext) )
         => ( ( v1060_7__array(VarNext,A,bitIndex43)
            <=> v1349(VarNext,bitIndex131) )
            & ( v1060_7__array(VarNext,A,bitIndex42)
            <=> v1349(VarNext,bitIndex130) )
            & ( v1060_7__array(VarNext,A,bitIndex41)
            <=> v1349(VarNext,bitIndex129) )
            & ( v1060_7__array(VarNext,A,bitIndex40)
            <=> v1349(VarNext,bitIndex128) )
            & ( v1060_7__array(VarNext,A,bitIndex39)
            <=> v1349(VarNext,bitIndex127) )
            & ( v1060_7__array(VarNext,A,bitIndex38)
            <=> v1349(VarNext,bitIndex126) )
            & ( v1060_7__array(VarNext,A,bitIndex37)
            <=> v1349(VarNext,bitIndex125) )
            & ( v1060_7__array(VarNext,A,bitIndex36)
            <=> v1349(VarNext,bitIndex124) )
            & ( v1060_7__array(VarNext,A,bitIndex35)
            <=> v1349(VarNext,bitIndex123) )
            & ( v1060_7__array(VarNext,A,bitIndex34)
            <=> v1349(VarNext,bitIndex122) )
            & ( v1060_7__array(VarNext,A,bitIndex33)
            <=> v1349(VarNext,bitIndex121) )
            & ( v1060_7__array(VarNext,A,bitIndex32)
            <=> v1349(VarNext,bitIndex120) )
            & ( v1060_7__array(VarNext,A,bitIndex31)
            <=> v1349(VarNext,bitIndex119) )
            & ( v1060_7__array(VarNext,A,bitIndex30)
            <=> v1349(VarNext,bitIndex118) )
            & ( v1060_7__array(VarNext,A,bitIndex29)
            <=> v1349(VarNext,bitIndex117) )
            & ( v1060_7__array(VarNext,A,bitIndex28)
            <=> v1349(VarNext,bitIndex116) )
            & ( v1060_7__array(VarNext,A,bitIndex27)
            <=> v1349(VarNext,bitIndex115) )
            & ( v1060_7__array(VarNext,A,bitIndex26)
            <=> v1349(VarNext,bitIndex114) )
            & ( v1060_7__array(VarNext,A,bitIndex25)
            <=> v1349(VarNext,bitIndex113) )
            & ( v1060_7__array(VarNext,A,bitIndex24)
            <=> v1349(VarNext,bitIndex112) )
            & ( v1060_7__array(VarNext,A,bitIndex23)
            <=> v1349(VarNext,bitIndex111) )
            & ( v1060_7__array(VarNext,A,bitIndex22)
            <=> v1349(VarNext,bitIndex110) )
            & ( v1060_7__array(VarNext,A,bitIndex21)
            <=> v1349(VarNext,bitIndex109) )
            & ( v1060_7__array(VarNext,A,bitIndex20)
            <=> v1349(VarNext,bitIndex108) )
            & ( v1060_7__array(VarNext,A,bitIndex19)
            <=> v1349(VarNext,bitIndex107) )
            & ( v1060_7__array(VarNext,A,bitIndex18)
            <=> v1349(VarNext,bitIndex106) )
            & ( v1060_7__array(VarNext,A,bitIndex17)
            <=> v1349(VarNext,bitIndex105) )
            & ( v1060_7__array(VarNext,A,bitIndex16)
            <=> v1349(VarNext,bitIndex104) )
            & ( v1060_7__array(VarNext,A,bitIndex15)
            <=> v1349(VarNext,bitIndex103) )
            & ( v1060_7__array(VarNext,A,bitIndex14)
            <=> v1349(VarNext,bitIndex102) )
            & ( v1060_7__array(VarNext,A,bitIndex13)
            <=> v1349(VarNext,bitIndex101) )
            & ( v1060_7__array(VarNext,A,bitIndex12)
            <=> v1349(VarNext,bitIndex100) )
            & ( v1060_7__array(VarNext,A,bitIndex11)
            <=> v1349(VarNext,bitIndex99) )
            & ( v1060_7__array(VarNext,A,bitIndex10)
            <=> v1349(VarNext,bitIndex98) )
            & ( v1060_7__array(VarNext,A,bitIndex9)
            <=> v1349(VarNext,bitIndex97) )
            & ( v1060_7__array(VarNext,A,bitIndex8)
            <=> v1349(VarNext,bitIndex96) )
            & ( v1060_7__array(VarNext,A,bitIndex7)
            <=> v1349(VarNext,bitIndex95) )
            & ( v1060_7__array(VarNext,A,bitIndex6)
            <=> v1349(VarNext,bitIndex94) )
            & ( v1060_7__array(VarNext,A,bitIndex5)
            <=> v1349(VarNext,bitIndex93) )
            & ( v1060_7__array(VarNext,A,bitIndex4)
            <=> v1349(VarNext,bitIndex92) )
            & ( v1060_7__array(VarNext,A,bitIndex3)
            <=> v1349(VarNext,bitIndex91) )
            & ( v1060_7__array(VarNext,A,bitIndex2)
            <=> v1349(VarNext,bitIndex90) )
            & ( v1060_7__array(VarNext,A,bitIndex1)
            <=> v1349(VarNext,bitIndex89) )
            & ( v1060_7__array(VarNext,A,bitIndex0)
            <=> v1349(VarNext,bitIndex88) ) ) ) ) ).

fof(bitBlastConstant_408,axiom,
    ~ b00010(bitIndex4) ).

fof(bitBlastConstant_407,axiom,
    ~ b00010(bitIndex3) ).

fof(bitBlastConstant_406,axiom,
    ~ b00010(bitIndex2) ).

fof(bitBlastConstant_405,axiom,
    b00010(bitIndex1) ).

fof(bitBlastConstant_404,axiom,
    ~ b00010(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_136,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1342(VarNext)
      <=> ( v1343(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_135,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1343(VarNext)
      <=> ( v1345(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_46,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1345(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_5,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00001_address_term = A
              & v1332(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_6__array(VarNext,A,B)
              <=> v1060_5__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_5,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00001_address_term = A
            & v1332(VarNext) )
         => ( ( v1060_6__array(VarNext,A,bitIndex43)
            <=> v1339(VarNext,bitIndex87) )
            & ( v1060_6__array(VarNext,A,bitIndex42)
            <=> v1339(VarNext,bitIndex86) )
            & ( v1060_6__array(VarNext,A,bitIndex41)
            <=> v1339(VarNext,bitIndex85) )
            & ( v1060_6__array(VarNext,A,bitIndex40)
            <=> v1339(VarNext,bitIndex84) )
            & ( v1060_6__array(VarNext,A,bitIndex39)
            <=> v1339(VarNext,bitIndex83) )
            & ( v1060_6__array(VarNext,A,bitIndex38)
            <=> v1339(VarNext,bitIndex82) )
            & ( v1060_6__array(VarNext,A,bitIndex37)
            <=> v1339(VarNext,bitIndex81) )
            & ( v1060_6__array(VarNext,A,bitIndex36)
            <=> v1339(VarNext,bitIndex80) )
            & ( v1060_6__array(VarNext,A,bitIndex35)
            <=> v1339(VarNext,bitIndex79) )
            & ( v1060_6__array(VarNext,A,bitIndex34)
            <=> v1339(VarNext,bitIndex78) )
            & ( v1060_6__array(VarNext,A,bitIndex33)
            <=> v1339(VarNext,bitIndex77) )
            & ( v1060_6__array(VarNext,A,bitIndex32)
            <=> v1339(VarNext,bitIndex76) )
            & ( v1060_6__array(VarNext,A,bitIndex31)
            <=> v1339(VarNext,bitIndex75) )
            & ( v1060_6__array(VarNext,A,bitIndex30)
            <=> v1339(VarNext,bitIndex74) )
            & ( v1060_6__array(VarNext,A,bitIndex29)
            <=> v1339(VarNext,bitIndex73) )
            & ( v1060_6__array(VarNext,A,bitIndex28)
            <=> v1339(VarNext,bitIndex72) )
            & ( v1060_6__array(VarNext,A,bitIndex27)
            <=> v1339(VarNext,bitIndex71) )
            & ( v1060_6__array(VarNext,A,bitIndex26)
            <=> v1339(VarNext,bitIndex70) )
            & ( v1060_6__array(VarNext,A,bitIndex25)
            <=> v1339(VarNext,bitIndex69) )
            & ( v1060_6__array(VarNext,A,bitIndex24)
            <=> v1339(VarNext,bitIndex68) )
            & ( v1060_6__array(VarNext,A,bitIndex23)
            <=> v1339(VarNext,bitIndex67) )
            & ( v1060_6__array(VarNext,A,bitIndex22)
            <=> v1339(VarNext,bitIndex66) )
            & ( v1060_6__array(VarNext,A,bitIndex21)
            <=> v1339(VarNext,bitIndex65) )
            & ( v1060_6__array(VarNext,A,bitIndex20)
            <=> v1339(VarNext,bitIndex64) )
            & ( v1060_6__array(VarNext,A,bitIndex19)
            <=> v1339(VarNext,bitIndex63) )
            & ( v1060_6__array(VarNext,A,bitIndex18)
            <=> v1339(VarNext,bitIndex62) )
            & ( v1060_6__array(VarNext,A,bitIndex17)
            <=> v1339(VarNext,bitIndex61) )
            & ( v1060_6__array(VarNext,A,bitIndex16)
            <=> v1339(VarNext,bitIndex60) )
            & ( v1060_6__array(VarNext,A,bitIndex15)
            <=> v1339(VarNext,bitIndex59) )
            & ( v1060_6__array(VarNext,A,bitIndex14)
            <=> v1339(VarNext,bitIndex58) )
            & ( v1060_6__array(VarNext,A,bitIndex13)
            <=> v1339(VarNext,bitIndex57) )
            & ( v1060_6__array(VarNext,A,bitIndex12)
            <=> v1339(VarNext,bitIndex56) )
            & ( v1060_6__array(VarNext,A,bitIndex11)
            <=> v1339(VarNext,bitIndex55) )
            & ( v1060_6__array(VarNext,A,bitIndex10)
            <=> v1339(VarNext,bitIndex54) )
            & ( v1060_6__array(VarNext,A,bitIndex9)
            <=> v1339(VarNext,bitIndex53) )
            & ( v1060_6__array(VarNext,A,bitIndex8)
            <=> v1339(VarNext,bitIndex52) )
            & ( v1060_6__array(VarNext,A,bitIndex7)
            <=> v1339(VarNext,bitIndex51) )
            & ( v1060_6__array(VarNext,A,bitIndex6)
            <=> v1339(VarNext,bitIndex50) )
            & ( v1060_6__array(VarNext,A,bitIndex5)
            <=> v1339(VarNext,bitIndex49) )
            & ( v1060_6__array(VarNext,A,bitIndex4)
            <=> v1339(VarNext,bitIndex48) )
            & ( v1060_6__array(VarNext,A,bitIndex3)
            <=> v1339(VarNext,bitIndex47) )
            & ( v1060_6__array(VarNext,A,bitIndex2)
            <=> v1339(VarNext,bitIndex46) )
            & ( v1060_6__array(VarNext,A,bitIndex1)
            <=> v1339(VarNext,bitIndex45) )
            & ( v1060_6__array(VarNext,A,bitIndex0)
            <=> v1339(VarNext,bitIndex44) ) ) ) ) ).

fof(bitBlastConstant_403,axiom,
    ~ b00001(bitIndex4) ).

fof(bitBlastConstant_402,axiom,
    ~ b00001(bitIndex3) ).

fof(bitBlastConstant_401,axiom,
    ~ b00001(bitIndex2) ).

fof(bitBlastConstant_400,axiom,
    ~ b00001(bitIndex1) ).

fof(bitBlastConstant_399,axiom,
    b00001(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_134,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1332(VarNext)
      <=> ( v1333(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_133,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1333(VarNext)
      <=> ( v1335(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_45,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1335(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_4,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00000_address_term = A
              & v1318(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_5__array(VarNext,A,B)
              <=> v1060_4__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_4,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00000_address_term = A
            & v1318(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v1060_5__array(VarNext,A,B)
              <=> v1329(VarNext,B) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_132,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1318(VarNext)
      <=> ( v1319(VarNext)
          & v1325(VarNext) ) ) ) ).

fof(addAssignment_304,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1325(VarNext)
      <=> v1323(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_131,axiom,
    ! [VarCurr] :
      ( v1323(VarCurr)
    <=> ( v1281(VarCurr)
        & v1326(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_96,axiom,
    ! [VarCurr] :
      ( v1326(VarCurr)
    <=> ( ( v1327(VarCurr,bitIndex1)
        <=> $false )
        & ( v1327(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_303,axiom,
    ! [VarCurr] :
      ( v1327(VarCurr,bitIndex0)
    <=> v1079(VarCurr) ) ).

fof(addAssignment_302,axiom,
    ! [VarCurr] :
      ( v1327(VarCurr,bitIndex1)
    <=> v1071(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_130,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1319(VarNext)
      <=> ( v1321(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_44,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1321(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_3,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v1097_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ~ ( A = AssociatedAddressVar
                  & v1306(VarNext) )
             => ! [B] :
                  ( range_43_0(B)
                 => ( v1060_4__array(VarNext,A,B)
                  <=> v1060_3__array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_3,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v1097_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ( A = AssociatedAddressVar
                & v1306(VarNext) )
             => ! [B] :
                  ( range_43_0(B)
                 => ( v1060_4__array(VarNext,A,B)
                  <=> v1087(VarNext,B) ) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_129,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1306(VarNext)
      <=> ( v1307(VarNext)
          & v1313(VarNext) ) ) ) ).

fof(addAssignment_301,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1313(VarNext)
      <=> v1311(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_128,axiom,
    ! [VarCurr] :
      ( v1311(VarCurr)
    <=> ( v1281(VarCurr)
        & v1314(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_95,axiom,
    ! [VarCurr] :
      ( v1314(VarCurr)
    <=> ( ( v1315(VarCurr,bitIndex1)
        <=> $true )
        & ( v1315(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_300,axiom,
    ! [VarCurr] :
      ( v1315(VarCurr,bitIndex0)
    <=> v1079(VarCurr) ) ).

fof(addAssignment_299,axiom,
    ! [VarCurr] :
      ( v1315(VarCurr,bitIndex1)
    <=> v1071(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_127,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1307(VarNext)
      <=> ( v1309(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_43,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1309(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_2,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v1115_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ~ ( A = AssociatedAddressVar
                  & v1294(VarNext) )
             => ! [B] :
                  ( range_43_0(B)
                 => ( v1060_3__array(VarNext,A,B)
                  <=> v1060_2__array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_2,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v1115_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ( A = AssociatedAddressVar
                & v1294(VarNext) )
             => ! [B] :
                  ( range_43_0(B)
                 => ( v1060_3__array(VarNext,A,B)
                  <=> v1105(VarNext,B) ) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_126,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1294(VarNext)
      <=> ( v1295(VarNext)
          & v1301(VarNext) ) ) ) ).

fof(addAssignment_298,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1301(VarNext)
      <=> v1299(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_125,axiom,
    ! [VarCurr] :
      ( v1299(VarCurr)
    <=> ( v1281(VarCurr)
        & v1302(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_94,axiom,
    ! [VarCurr] :
      ( v1302(VarCurr)
    <=> ( ( v1303(VarCurr,bitIndex1)
        <=> $false )
        & ( v1303(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_297,axiom,
    ! [VarCurr] :
      ( v1303(VarCurr,bitIndex0)
    <=> v1079(VarCurr) ) ).

fof(addAssignment_296,axiom,
    ! [VarCurr] :
      ( v1303(VarCurr,bitIndex1)
    <=> v1071(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_124,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1295(VarNext)
      <=> ( v1297(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_42,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1297(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled_1,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v1115_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ~ ( A = AssociatedAddressVar
                  & v1287(VarNext) )
             => ! [B] :
                  ( range_43_0(B)
                 => ( v1060_2__array(VarNext,A,B)
                  <=> v1060_1__array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_1,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v1115_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ( A = AssociatedAddressVar
                & v1287(VarNext) )
             => ! [B] :
                  ( range_43_0(B)
                 => ( v1060_2__array(VarNext,A,B)
                  <=> v1105(VarNext,B) ) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_123,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1287(VarNext)
      <=> ( v1288(VarNext)
          & v1280(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_122,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1288(VarNext)
      <=> ( v1290(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_41,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1290(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(memoryWriteDisabled,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v1097_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ~ ( A = AssociatedAddressVar
                  & v1271(VarNext) )
             => ! [B] :
                  ( range_43_0(B)
                 => ( v1060_1__array(VarNext,A,B)
                  <=> v1060_array(VarCurr,A,B) ) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v1097_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ( A = AssociatedAddressVar
                & v1271(VarNext) )
             => ! [B] :
                  ( range_43_0(B)
                 => ( v1060_1__array(VarNext,A,B)
                  <=> v1087(VarNext,B) ) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_121,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1271(VarNext)
      <=> ( v1272(VarNext)
          & v1280(VarNext) ) ) ) ).

fof(addAssignment_295,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1280(VarNext)
      <=> v1278(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_120,axiom,
    ! [VarCurr] :
      ( v1278(VarCurr)
    <=> ( v1281(VarCurr)
        & v1283(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_93,axiom,
    ! [VarCurr] :
      ( v1283(VarCurr)
    <=> ( ( v1284(VarCurr,bitIndex1)
        <=> $true )
        & ( v1284(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_294,axiom,
    ! [VarCurr] :
      ( v1284(VarCurr,bitIndex0)
    <=> v1079(VarCurr) ) ).

fof(addAssignment_293,axiom,
    ! [VarCurr] :
      ( v1284(VarCurr,bitIndex1)
    <=> v1071(VarCurr) ) ).

fof(writeUnaryOperator_40,axiom,
    ! [VarCurr] :
      ( ~ v1281(VarCurr)
    <=> v1282(VarCurr) ) ).

fof(writeUnaryOperator_39,axiom,
    ! [VarCurr] :
      ( ~ v1282(VarCurr)
    <=> v1067(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_119,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1272(VarNext)
      <=> ( v1273(VarNext)
          & v1062(VarNext) ) ) ) ).

fof(writeUnaryOperator_38,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1273(VarNext)
      <=> v1275(VarNext) ) ) ).

fof(addAssignment_292,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1275(VarNext)
      <=> v1062(VarCurr) ) ) ).

fof(initSateConstraint_1023,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex0) ).

fof(initSateConstraint_1022,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex1) ).

fof(initSateConstraint_1021,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex2) ).

fof(initSateConstraint_1020,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex3) ).

fof(initSateConstraint_1019,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex4) ).

fof(initSateConstraint_1018,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex5) ).

fof(initSateConstraint_1017,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex6) ).

fof(initSateConstraint_1016,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex7) ).

fof(initSateConstraint_1015,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex8) ).

fof(initSateConstraint_1014,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex9) ).

fof(initSateConstraint_1013,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex10) ).

fof(initSateConstraint_1012,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex11) ).

fof(initSateConstraint_1011,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex12) ).

fof(initSateConstraint_1010,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex13) ).

fof(initSateConstraint_1009,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex14) ).

fof(initSateConstraint_1008,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex15) ).

fof(initSateConstraint_1007,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex16) ).

fof(initSateConstraint_1006,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex17) ).

fof(initSateConstraint_1005,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex18) ).

fof(initSateConstraint_1004,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex19) ).

fof(initSateConstraint_1003,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex20) ).

fof(initSateConstraint_1002,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex21) ).

fof(initSateConstraint_1001,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex22) ).

fof(initSateConstraint_1000,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex23) ).

fof(initSateConstraint_999,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex24) ).

fof(initSateConstraint_998,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex25) ).

fof(initSateConstraint_997,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex26) ).

fof(initSateConstraint_996,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex27) ).

fof(initSateConstraint_995,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex28) ).

fof(initSateConstraint_994,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex29) ).

fof(initSateConstraint_993,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex30) ).

fof(initSateConstraint_992,axiom,
    ~ v1060_array(constB0,b11111_address_term,bitIndex31) ).

fof(bitBlastConstant_398,axiom,
    b11111(bitIndex4) ).

fof(bitBlastConstant_397,axiom,
    b11111(bitIndex3) ).

fof(bitBlastConstant_396,axiom,
    b11111(bitIndex2) ).

fof(bitBlastConstant_395,axiom,
    b11111(bitIndex1) ).

fof(bitBlastConstant_394,axiom,
    b11111(bitIndex0) ).

fof(initSateConstraint_991,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex0) ).

fof(initSateConstraint_990,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex1) ).

fof(initSateConstraint_989,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex2) ).

fof(initSateConstraint_988,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex3) ).

fof(initSateConstraint_987,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex4) ).

fof(initSateConstraint_986,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex5) ).

fof(initSateConstraint_985,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex6) ).

fof(initSateConstraint_984,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex7) ).

fof(initSateConstraint_983,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex8) ).

fof(initSateConstraint_982,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex9) ).

fof(initSateConstraint_981,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex10) ).

fof(initSateConstraint_980,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex11) ).

fof(initSateConstraint_979,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex12) ).

fof(initSateConstraint_978,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex13) ).

fof(initSateConstraint_977,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex14) ).

fof(initSateConstraint_976,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex15) ).

fof(initSateConstraint_975,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex16) ).

fof(initSateConstraint_974,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex17) ).

fof(initSateConstraint_973,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex18) ).

fof(initSateConstraint_972,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex19) ).

fof(initSateConstraint_971,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex20) ).

fof(initSateConstraint_970,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex21) ).

fof(initSateConstraint_969,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex22) ).

fof(initSateConstraint_968,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex23) ).

fof(initSateConstraint_967,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex24) ).

fof(initSateConstraint_966,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex25) ).

fof(initSateConstraint_965,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex26) ).

fof(initSateConstraint_964,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex27) ).

fof(initSateConstraint_963,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex28) ).

fof(initSateConstraint_962,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex29) ).

fof(initSateConstraint_961,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex30) ).

fof(initSateConstraint_960,axiom,
    ~ v1060_array(constB0,b11110_address_term,bitIndex31) ).

fof(bitBlastConstant_393,axiom,
    b11110(bitIndex4) ).

fof(bitBlastConstant_392,axiom,
    b11110(bitIndex3) ).

fof(bitBlastConstant_391,axiom,
    b11110(bitIndex2) ).

fof(bitBlastConstant_390,axiom,
    b11110(bitIndex1) ).

fof(bitBlastConstant_389,axiom,
    ~ b11110(bitIndex0) ).

fof(initSateConstraint_959,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex0) ).

fof(initSateConstraint_958,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex1) ).

fof(initSateConstraint_957,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex2) ).

fof(initSateConstraint_956,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex3) ).

fof(initSateConstraint_955,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex4) ).

fof(initSateConstraint_954,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex5) ).

fof(initSateConstraint_953,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex6) ).

fof(initSateConstraint_952,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex7) ).

fof(initSateConstraint_951,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex8) ).

fof(initSateConstraint_950,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex9) ).

fof(initSateConstraint_949,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex10) ).

fof(initSateConstraint_948,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex11) ).

fof(initSateConstraint_947,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex12) ).

fof(initSateConstraint_946,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex13) ).

fof(initSateConstraint_945,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex14) ).

fof(initSateConstraint_944,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex15) ).

fof(initSateConstraint_943,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex16) ).

fof(initSateConstraint_942,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex17) ).

fof(initSateConstraint_941,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex18) ).

fof(initSateConstraint_940,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex19) ).

fof(initSateConstraint_939,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex20) ).

fof(initSateConstraint_938,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex21) ).

fof(initSateConstraint_937,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex22) ).

fof(initSateConstraint_936,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex23) ).

fof(initSateConstraint_935,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex24) ).

fof(initSateConstraint_934,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex25) ).

fof(initSateConstraint_933,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex26) ).

fof(initSateConstraint_932,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex27) ).

fof(initSateConstraint_931,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex28) ).

fof(initSateConstraint_930,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex29) ).

fof(initSateConstraint_929,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex30) ).

fof(initSateConstraint_928,axiom,
    ~ v1060_array(constB0,b11101_address_term,bitIndex31) ).

fof(bitBlastConstant_388,axiom,
    b11101(bitIndex4) ).

fof(bitBlastConstant_387,axiom,
    b11101(bitIndex3) ).

fof(bitBlastConstant_386,axiom,
    b11101(bitIndex2) ).

fof(bitBlastConstant_385,axiom,
    ~ b11101(bitIndex1) ).

fof(bitBlastConstant_384,axiom,
    b11101(bitIndex0) ).

fof(initSateConstraint_927,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex0) ).

fof(initSateConstraint_926,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex1) ).

fof(initSateConstraint_925,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex2) ).

fof(initSateConstraint_924,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex3) ).

fof(initSateConstraint_923,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex4) ).

fof(initSateConstraint_922,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex5) ).

fof(initSateConstraint_921,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex6) ).

fof(initSateConstraint_920,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex7) ).

fof(initSateConstraint_919,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex8) ).

fof(initSateConstraint_918,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex9) ).

fof(initSateConstraint_917,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex10) ).

fof(initSateConstraint_916,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex11) ).

fof(initSateConstraint_915,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex12) ).

fof(initSateConstraint_914,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex13) ).

fof(initSateConstraint_913,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex14) ).

fof(initSateConstraint_912,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex15) ).

fof(initSateConstraint_911,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex16) ).

fof(initSateConstraint_910,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex17) ).

fof(initSateConstraint_909,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex18) ).

fof(initSateConstraint_908,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex19) ).

fof(initSateConstraint_907,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex20) ).

fof(initSateConstraint_906,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex21) ).

fof(initSateConstraint_905,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex22) ).

fof(initSateConstraint_904,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex23) ).

fof(initSateConstraint_903,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex24) ).

fof(initSateConstraint_902,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex25) ).

fof(initSateConstraint_901,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex26) ).

fof(initSateConstraint_900,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex27) ).

fof(initSateConstraint_899,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex28) ).

fof(initSateConstraint_898,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex29) ).

fof(initSateConstraint_897,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex30) ).

fof(initSateConstraint_896,axiom,
    ~ v1060_array(constB0,b11100_address_term,bitIndex31) ).

fof(bitBlastConstant_383,axiom,
    b11100(bitIndex4) ).

fof(bitBlastConstant_382,axiom,
    b11100(bitIndex3) ).

fof(bitBlastConstant_381,axiom,
    b11100(bitIndex2) ).

fof(bitBlastConstant_380,axiom,
    ~ b11100(bitIndex1) ).

fof(bitBlastConstant_379,axiom,
    ~ b11100(bitIndex0) ).

fof(initSateConstraint_895,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex0) ).

fof(initSateConstraint_894,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex1) ).

fof(initSateConstraint_893,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex2) ).

fof(initSateConstraint_892,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex3) ).

fof(initSateConstraint_891,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex4) ).

fof(initSateConstraint_890,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex5) ).

fof(initSateConstraint_889,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex6) ).

fof(initSateConstraint_888,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex7) ).

fof(initSateConstraint_887,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex8) ).

fof(initSateConstraint_886,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex9) ).

fof(initSateConstraint_885,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex10) ).

fof(initSateConstraint_884,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex11) ).

fof(initSateConstraint_883,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex12) ).

fof(initSateConstraint_882,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex13) ).

fof(initSateConstraint_881,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex14) ).

fof(initSateConstraint_880,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex15) ).

fof(initSateConstraint_879,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex16) ).

fof(initSateConstraint_878,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex17) ).

fof(initSateConstraint_877,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex18) ).

fof(initSateConstraint_876,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex19) ).

fof(initSateConstraint_875,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex20) ).

fof(initSateConstraint_874,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex21) ).

fof(initSateConstraint_873,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex22) ).

fof(initSateConstraint_872,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex23) ).

fof(initSateConstraint_871,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex24) ).

fof(initSateConstraint_870,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex25) ).

fof(initSateConstraint_869,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex26) ).

fof(initSateConstraint_868,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex27) ).

fof(initSateConstraint_867,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex28) ).

fof(initSateConstraint_866,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex29) ).

fof(initSateConstraint_865,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex30) ).

fof(initSateConstraint_864,axiom,
    ~ v1060_array(constB0,b11011_address_term,bitIndex31) ).

fof(bitBlastConstant_378,axiom,
    b11011(bitIndex4) ).

fof(bitBlastConstant_377,axiom,
    b11011(bitIndex3) ).

fof(bitBlastConstant_376,axiom,
    ~ b11011(bitIndex2) ).

fof(bitBlastConstant_375,axiom,
    b11011(bitIndex1) ).

fof(bitBlastConstant_374,axiom,
    b11011(bitIndex0) ).

fof(initSateConstraint_863,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex0) ).

fof(initSateConstraint_862,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex1) ).

fof(initSateConstraint_861,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex2) ).

fof(initSateConstraint_860,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex3) ).

fof(initSateConstraint_859,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex4) ).

fof(initSateConstraint_858,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex5) ).

fof(initSateConstraint_857,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex6) ).

fof(initSateConstraint_856,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex7) ).

fof(initSateConstraint_855,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex8) ).

fof(initSateConstraint_854,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex9) ).

fof(initSateConstraint_853,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex10) ).

fof(initSateConstraint_852,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex11) ).

fof(initSateConstraint_851,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex12) ).

fof(initSateConstraint_850,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex13) ).

fof(initSateConstraint_849,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex14) ).

fof(initSateConstraint_848,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex15) ).

fof(initSateConstraint_847,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex16) ).

fof(initSateConstraint_846,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex17) ).

fof(initSateConstraint_845,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex18) ).

fof(initSateConstraint_844,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex19) ).

fof(initSateConstraint_843,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex20) ).

fof(initSateConstraint_842,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex21) ).

fof(initSateConstraint_841,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex22) ).

fof(initSateConstraint_840,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex23) ).

fof(initSateConstraint_839,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex24) ).

fof(initSateConstraint_838,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex25) ).

fof(initSateConstraint_837,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex26) ).

fof(initSateConstraint_836,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex27) ).

fof(initSateConstraint_835,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex28) ).

fof(initSateConstraint_834,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex29) ).

fof(initSateConstraint_833,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex30) ).

fof(initSateConstraint_832,axiom,
    ~ v1060_array(constB0,b11010_address_term,bitIndex31) ).

fof(bitBlastConstant_373,axiom,
    b11010(bitIndex4) ).

fof(bitBlastConstant_372,axiom,
    b11010(bitIndex3) ).

fof(bitBlastConstant_371,axiom,
    ~ b11010(bitIndex2) ).

fof(bitBlastConstant_370,axiom,
    b11010(bitIndex1) ).

fof(bitBlastConstant_369,axiom,
    ~ b11010(bitIndex0) ).

fof(initSateConstraint_831,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex0) ).

fof(initSateConstraint_830,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex1) ).

fof(initSateConstraint_829,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex2) ).

fof(initSateConstraint_828,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex3) ).

fof(initSateConstraint_827,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex4) ).

fof(initSateConstraint_826,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex5) ).

fof(initSateConstraint_825,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex6) ).

fof(initSateConstraint_824,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex7) ).

fof(initSateConstraint_823,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex8) ).

fof(initSateConstraint_822,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex9) ).

fof(initSateConstraint_821,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex10) ).

fof(initSateConstraint_820,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex11) ).

fof(initSateConstraint_819,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex12) ).

fof(initSateConstraint_818,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex13) ).

fof(initSateConstraint_817,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex14) ).

fof(initSateConstraint_816,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex15) ).

fof(initSateConstraint_815,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex16) ).

fof(initSateConstraint_814,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex17) ).

fof(initSateConstraint_813,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex18) ).

fof(initSateConstraint_812,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex19) ).

fof(initSateConstraint_811,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex20) ).

fof(initSateConstraint_810,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex21) ).

fof(initSateConstraint_809,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex22) ).

fof(initSateConstraint_808,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex23) ).

fof(initSateConstraint_807,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex24) ).

fof(initSateConstraint_806,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex25) ).

fof(initSateConstraint_805,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex26) ).

fof(initSateConstraint_804,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex27) ).

fof(initSateConstraint_803,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex28) ).

fof(initSateConstraint_802,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex29) ).

fof(initSateConstraint_801,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex30) ).

fof(initSateConstraint_800,axiom,
    ~ v1060_array(constB0,b11001_address_term,bitIndex31) ).

fof(bitBlastConstant_368,axiom,
    b11001(bitIndex4) ).

fof(bitBlastConstant_367,axiom,
    b11001(bitIndex3) ).

fof(bitBlastConstant_366,axiom,
    ~ b11001(bitIndex2) ).

fof(bitBlastConstant_365,axiom,
    ~ b11001(bitIndex1) ).

fof(bitBlastConstant_364,axiom,
    b11001(bitIndex0) ).

fof(initSateConstraint_799,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex0) ).

fof(initSateConstraint_798,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex1) ).

fof(initSateConstraint_797,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex2) ).

fof(initSateConstraint_796,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex3) ).

fof(initSateConstraint_795,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex4) ).

fof(initSateConstraint_794,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex5) ).

fof(initSateConstraint_793,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex6) ).

fof(initSateConstraint_792,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex7) ).

fof(initSateConstraint_791,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex8) ).

fof(initSateConstraint_790,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex9) ).

fof(initSateConstraint_789,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex10) ).

fof(initSateConstraint_788,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex11) ).

fof(initSateConstraint_787,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex12) ).

fof(initSateConstraint_786,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex13) ).

fof(initSateConstraint_785,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex14) ).

fof(initSateConstraint_784,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex15) ).

fof(initSateConstraint_783,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex16) ).

fof(initSateConstraint_782,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex17) ).

fof(initSateConstraint_781,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex18) ).

fof(initSateConstraint_780,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex19) ).

fof(initSateConstraint_779,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex20) ).

fof(initSateConstraint_778,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex21) ).

fof(initSateConstraint_777,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex22) ).

fof(initSateConstraint_776,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex23) ).

fof(initSateConstraint_775,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex24) ).

fof(initSateConstraint_774,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex25) ).

fof(initSateConstraint_773,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex26) ).

fof(initSateConstraint_772,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex27) ).

fof(initSateConstraint_771,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex28) ).

fof(initSateConstraint_770,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex29) ).

fof(initSateConstraint_769,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex30) ).

fof(initSateConstraint_768,axiom,
    ~ v1060_array(constB0,b11000_address_term,bitIndex31) ).

fof(bitBlastConstant_363,axiom,
    b11000(bitIndex4) ).

fof(bitBlastConstant_362,axiom,
    b11000(bitIndex3) ).

fof(bitBlastConstant_361,axiom,
    ~ b11000(bitIndex2) ).

fof(bitBlastConstant_360,axiom,
    ~ b11000(bitIndex1) ).

fof(bitBlastConstant_359,axiom,
    ~ b11000(bitIndex0) ).

fof(initSateConstraint_767,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex0) ).

fof(initSateConstraint_766,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex1) ).

fof(initSateConstraint_765,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex2) ).

fof(initSateConstraint_764,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex3) ).

fof(initSateConstraint_763,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex4) ).

fof(initSateConstraint_762,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex5) ).

fof(initSateConstraint_761,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex6) ).

fof(initSateConstraint_760,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex7) ).

fof(initSateConstraint_759,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex8) ).

fof(initSateConstraint_758,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex9) ).

fof(initSateConstraint_757,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex10) ).

fof(initSateConstraint_756,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex11) ).

fof(initSateConstraint_755,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex12) ).

fof(initSateConstraint_754,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex13) ).

fof(initSateConstraint_753,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex14) ).

fof(initSateConstraint_752,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex15) ).

fof(initSateConstraint_751,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex16) ).

fof(initSateConstraint_750,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex17) ).

fof(initSateConstraint_749,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex18) ).

fof(initSateConstraint_748,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex19) ).

fof(initSateConstraint_747,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex20) ).

fof(initSateConstraint_746,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex21) ).

fof(initSateConstraint_745,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex22) ).

fof(initSateConstraint_744,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex23) ).

fof(initSateConstraint_743,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex24) ).

fof(initSateConstraint_742,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex25) ).

fof(initSateConstraint_741,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex26) ).

fof(initSateConstraint_740,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex27) ).

fof(initSateConstraint_739,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex28) ).

fof(initSateConstraint_738,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex29) ).

fof(initSateConstraint_737,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex30) ).

fof(initSateConstraint_736,axiom,
    ~ v1060_array(constB0,b10111_address_term,bitIndex31) ).

fof(bitBlastConstant_358,axiom,
    b10111(bitIndex4) ).

fof(bitBlastConstant_357,axiom,
    ~ b10111(bitIndex3) ).

fof(bitBlastConstant_356,axiom,
    b10111(bitIndex2) ).

fof(bitBlastConstant_355,axiom,
    b10111(bitIndex1) ).

fof(bitBlastConstant_354,axiom,
    b10111(bitIndex0) ).

fof(initSateConstraint_735,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex0) ).

fof(initSateConstraint_734,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex1) ).

fof(initSateConstraint_733,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex2) ).

fof(initSateConstraint_732,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex3) ).

fof(initSateConstraint_731,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex4) ).

fof(initSateConstraint_730,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex5) ).

fof(initSateConstraint_729,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex6) ).

fof(initSateConstraint_728,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex7) ).

fof(initSateConstraint_727,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex8) ).

fof(initSateConstraint_726,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex9) ).

fof(initSateConstraint_725,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex10) ).

fof(initSateConstraint_724,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex11) ).

fof(initSateConstraint_723,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex12) ).

fof(initSateConstraint_722,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex13) ).

fof(initSateConstraint_721,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex14) ).

fof(initSateConstraint_720,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex15) ).

fof(initSateConstraint_719,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex16) ).

fof(initSateConstraint_718,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex17) ).

fof(initSateConstraint_717,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex18) ).

fof(initSateConstraint_716,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex19) ).

fof(initSateConstraint_715,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex20) ).

fof(initSateConstraint_714,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex21) ).

fof(initSateConstraint_713,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex22) ).

fof(initSateConstraint_712,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex23) ).

fof(initSateConstraint_711,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex24) ).

fof(initSateConstraint_710,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex25) ).

fof(initSateConstraint_709,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex26) ).

fof(initSateConstraint_708,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex27) ).

fof(initSateConstraint_707,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex28) ).

fof(initSateConstraint_706,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex29) ).

fof(initSateConstraint_705,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex30) ).

fof(initSateConstraint_704,axiom,
    ~ v1060_array(constB0,b10110_address_term,bitIndex31) ).

fof(bitBlastConstant_353,axiom,
    b10110(bitIndex4) ).

fof(bitBlastConstant_352,axiom,
    ~ b10110(bitIndex3) ).

fof(bitBlastConstant_351,axiom,
    b10110(bitIndex2) ).

fof(bitBlastConstant_350,axiom,
    b10110(bitIndex1) ).

fof(bitBlastConstant_349,axiom,
    ~ b10110(bitIndex0) ).

fof(initSateConstraint_703,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex0) ).

fof(initSateConstraint_702,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex1) ).

fof(initSateConstraint_701,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex2) ).

fof(initSateConstraint_700,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex3) ).

fof(initSateConstraint_699,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex4) ).

fof(initSateConstraint_698,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex5) ).

fof(initSateConstraint_697,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex6) ).

fof(initSateConstraint_696,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex7) ).

fof(initSateConstraint_695,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex8) ).

fof(initSateConstraint_694,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex9) ).

fof(initSateConstraint_693,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex10) ).

fof(initSateConstraint_692,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex11) ).

fof(initSateConstraint_691,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex12) ).

fof(initSateConstraint_690,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex13) ).

fof(initSateConstraint_689,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex14) ).

fof(initSateConstraint_688,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex15) ).

fof(initSateConstraint_687,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex16) ).

fof(initSateConstraint_686,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex17) ).

fof(initSateConstraint_685,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex18) ).

fof(initSateConstraint_684,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex19) ).

fof(initSateConstraint_683,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex20) ).

fof(initSateConstraint_682,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex21) ).

fof(initSateConstraint_681,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex22) ).

fof(initSateConstraint_680,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex23) ).

fof(initSateConstraint_679,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex24) ).

fof(initSateConstraint_678,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex25) ).

fof(initSateConstraint_677,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex26) ).

fof(initSateConstraint_676,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex27) ).

fof(initSateConstraint_675,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex28) ).

fof(initSateConstraint_674,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex29) ).

fof(initSateConstraint_673,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex30) ).

fof(initSateConstraint_672,axiom,
    ~ v1060_array(constB0,b10101_address_term,bitIndex31) ).

fof(bitBlastConstant_348,axiom,
    b10101(bitIndex4) ).

fof(bitBlastConstant_347,axiom,
    ~ b10101(bitIndex3) ).

fof(bitBlastConstant_346,axiom,
    b10101(bitIndex2) ).

fof(bitBlastConstant_345,axiom,
    ~ b10101(bitIndex1) ).

fof(bitBlastConstant_344,axiom,
    b10101(bitIndex0) ).

fof(initSateConstraint_671,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex0) ).

fof(initSateConstraint_670,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex1) ).

fof(initSateConstraint_669,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex2) ).

fof(initSateConstraint_668,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex3) ).

fof(initSateConstraint_667,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex4) ).

fof(initSateConstraint_666,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex5) ).

fof(initSateConstraint_665,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex6) ).

fof(initSateConstraint_664,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex7) ).

fof(initSateConstraint_663,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex8) ).

fof(initSateConstraint_662,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex9) ).

fof(initSateConstraint_661,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex10) ).

fof(initSateConstraint_660,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex11) ).

fof(initSateConstraint_659,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex12) ).

fof(initSateConstraint_658,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex13) ).

fof(initSateConstraint_657,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex14) ).

fof(initSateConstraint_656,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex15) ).

fof(initSateConstraint_655,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex16) ).

fof(initSateConstraint_654,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex17) ).

fof(initSateConstraint_653,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex18) ).

fof(initSateConstraint_652,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex19) ).

fof(initSateConstraint_651,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex20) ).

fof(initSateConstraint_650,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex21) ).

fof(initSateConstraint_649,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex22) ).

fof(initSateConstraint_648,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex23) ).

fof(initSateConstraint_647,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex24) ).

fof(initSateConstraint_646,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex25) ).

fof(initSateConstraint_645,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex26) ).

fof(initSateConstraint_644,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex27) ).

fof(initSateConstraint_643,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex28) ).

fof(initSateConstraint_642,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex29) ).

fof(initSateConstraint_641,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex30) ).

fof(initSateConstraint_640,axiom,
    ~ v1060_array(constB0,b10100_address_term,bitIndex31) ).

fof(bitBlastConstant_343,axiom,
    b10100(bitIndex4) ).

fof(bitBlastConstant_342,axiom,
    ~ b10100(bitIndex3) ).

fof(bitBlastConstant_341,axiom,
    b10100(bitIndex2) ).

fof(bitBlastConstant_340,axiom,
    ~ b10100(bitIndex1) ).

fof(bitBlastConstant_339,axiom,
    ~ b10100(bitIndex0) ).

fof(initSateConstraint_639,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex0) ).

fof(initSateConstraint_638,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex1) ).

fof(initSateConstraint_637,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex2) ).

fof(initSateConstraint_636,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex3) ).

fof(initSateConstraint_635,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex4) ).

fof(initSateConstraint_634,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex5) ).

fof(initSateConstraint_633,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex6) ).

fof(initSateConstraint_632,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex7) ).

fof(initSateConstraint_631,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex8) ).

fof(initSateConstraint_630,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex9) ).

fof(initSateConstraint_629,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex10) ).

fof(initSateConstraint_628,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex11) ).

fof(initSateConstraint_627,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex12) ).

fof(initSateConstraint_626,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex13) ).

fof(initSateConstraint_625,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex14) ).

fof(initSateConstraint_624,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex15) ).

fof(initSateConstraint_623,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex16) ).

fof(initSateConstraint_622,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex17) ).

fof(initSateConstraint_621,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex18) ).

fof(initSateConstraint_620,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex19) ).

fof(initSateConstraint_619,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex20) ).

fof(initSateConstraint_618,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex21) ).

fof(initSateConstraint_617,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex22) ).

fof(initSateConstraint_616,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex23) ).

fof(initSateConstraint_615,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex24) ).

fof(initSateConstraint_614,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex25) ).

fof(initSateConstraint_613,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex26) ).

fof(initSateConstraint_612,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex27) ).

fof(initSateConstraint_611,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex28) ).

fof(initSateConstraint_610,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex29) ).

fof(initSateConstraint_609,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex30) ).

fof(initSateConstraint_608,axiom,
    ~ v1060_array(constB0,b10011_address_term,bitIndex31) ).

fof(bitBlastConstant_338,axiom,
    b10011(bitIndex4) ).

fof(bitBlastConstant_337,axiom,
    ~ b10011(bitIndex3) ).

fof(bitBlastConstant_336,axiom,
    ~ b10011(bitIndex2) ).

fof(bitBlastConstant_335,axiom,
    b10011(bitIndex1) ).

fof(bitBlastConstant_334,axiom,
    b10011(bitIndex0) ).

fof(initSateConstraint_607,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex0) ).

fof(initSateConstraint_606,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex1) ).

fof(initSateConstraint_605,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex2) ).

fof(initSateConstraint_604,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex3) ).

fof(initSateConstraint_603,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex4) ).

fof(initSateConstraint_602,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex5) ).

fof(initSateConstraint_601,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex6) ).

fof(initSateConstraint_600,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex7) ).

fof(initSateConstraint_599,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex8) ).

fof(initSateConstraint_598,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex9) ).

fof(initSateConstraint_597,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex10) ).

fof(initSateConstraint_596,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex11) ).

fof(initSateConstraint_595,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex12) ).

fof(initSateConstraint_594,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex13) ).

fof(initSateConstraint_593,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex14) ).

fof(initSateConstraint_592,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex15) ).

fof(initSateConstraint_591,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex16) ).

fof(initSateConstraint_590,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex17) ).

fof(initSateConstraint_589,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex18) ).

fof(initSateConstraint_588,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex19) ).

fof(initSateConstraint_587,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex20) ).

fof(initSateConstraint_586,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex21) ).

fof(initSateConstraint_585,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex22) ).

fof(initSateConstraint_584,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex23) ).

fof(initSateConstraint_583,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex24) ).

fof(initSateConstraint_582,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex25) ).

fof(initSateConstraint_581,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex26) ).

fof(initSateConstraint_580,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex27) ).

fof(initSateConstraint_579,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex28) ).

fof(initSateConstraint_578,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex29) ).

fof(initSateConstraint_577,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex30) ).

fof(initSateConstraint_576,axiom,
    ~ v1060_array(constB0,b10010_address_term,bitIndex31) ).

fof(bitBlastConstant_333,axiom,
    b10010(bitIndex4) ).

fof(bitBlastConstant_332,axiom,
    ~ b10010(bitIndex3) ).

fof(bitBlastConstant_331,axiom,
    ~ b10010(bitIndex2) ).

fof(bitBlastConstant_330,axiom,
    b10010(bitIndex1) ).

fof(bitBlastConstant_329,axiom,
    ~ b10010(bitIndex0) ).

fof(initSateConstraint_575,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex0) ).

fof(initSateConstraint_574,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex1) ).

fof(initSateConstraint_573,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex2) ).

fof(initSateConstraint_572,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex3) ).

fof(initSateConstraint_571,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex4) ).

fof(initSateConstraint_570,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex5) ).

fof(initSateConstraint_569,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex6) ).

fof(initSateConstraint_568,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex7) ).

fof(initSateConstraint_567,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex8) ).

fof(initSateConstraint_566,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex9) ).

fof(initSateConstraint_565,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex10) ).

fof(initSateConstraint_564,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex11) ).

fof(initSateConstraint_563,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex12) ).

fof(initSateConstraint_562,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex13) ).

fof(initSateConstraint_561,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex14) ).

fof(initSateConstraint_560,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex15) ).

fof(initSateConstraint_559,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex16) ).

fof(initSateConstraint_558,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex17) ).

fof(initSateConstraint_557,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex18) ).

fof(initSateConstraint_556,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex19) ).

fof(initSateConstraint_555,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex20) ).

fof(initSateConstraint_554,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex21) ).

fof(initSateConstraint_553,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex22) ).

fof(initSateConstraint_552,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex23) ).

fof(initSateConstraint_551,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex24) ).

fof(initSateConstraint_550,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex25) ).

fof(initSateConstraint_549,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex26) ).

fof(initSateConstraint_548,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex27) ).

fof(initSateConstraint_547,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex28) ).

fof(initSateConstraint_546,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex29) ).

fof(initSateConstraint_545,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex30) ).

fof(initSateConstraint_544,axiom,
    ~ v1060_array(constB0,b10001_address_term,bitIndex31) ).

fof(bitBlastConstant_328,axiom,
    b10001(bitIndex4) ).

fof(bitBlastConstant_327,axiom,
    ~ b10001(bitIndex3) ).

fof(bitBlastConstant_326,axiom,
    ~ b10001(bitIndex2) ).

fof(bitBlastConstant_325,axiom,
    ~ b10001(bitIndex1) ).

fof(bitBlastConstant_324,axiom,
    b10001(bitIndex0) ).

fof(initSateConstraint_543,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex0) ).

fof(initSateConstraint_542,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex1) ).

fof(initSateConstraint_541,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex2) ).

fof(initSateConstraint_540,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex3) ).

fof(initSateConstraint_539,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex4) ).

fof(initSateConstraint_538,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex5) ).

fof(initSateConstraint_537,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex6) ).

fof(initSateConstraint_536,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex7) ).

fof(initSateConstraint_535,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex8) ).

fof(initSateConstraint_534,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex9) ).

fof(initSateConstraint_533,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex10) ).

fof(initSateConstraint_532,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex11) ).

fof(initSateConstraint_531,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex12) ).

fof(initSateConstraint_530,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex13) ).

fof(initSateConstraint_529,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex14) ).

fof(initSateConstraint_528,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex15) ).

fof(initSateConstraint_527,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex16) ).

fof(initSateConstraint_526,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex17) ).

fof(initSateConstraint_525,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex18) ).

fof(initSateConstraint_524,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex19) ).

fof(initSateConstraint_523,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex20) ).

fof(initSateConstraint_522,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex21) ).

fof(initSateConstraint_521,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex22) ).

fof(initSateConstraint_520,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex23) ).

fof(initSateConstraint_519,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex24) ).

fof(initSateConstraint_518,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex25) ).

fof(initSateConstraint_517,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex26) ).

fof(initSateConstraint_516,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex27) ).

fof(initSateConstraint_515,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex28) ).

fof(initSateConstraint_514,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex29) ).

fof(initSateConstraint_513,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex30) ).

fof(initSateConstraint_512,axiom,
    ~ v1060_array(constB0,b10000_address_term,bitIndex31) ).

fof(bitBlastConstant_323,axiom,
    b10000(bitIndex4) ).

fof(bitBlastConstant_322,axiom,
    ~ b10000(bitIndex3) ).

fof(bitBlastConstant_321,axiom,
    ~ b10000(bitIndex2) ).

fof(bitBlastConstant_320,axiom,
    ~ b10000(bitIndex1) ).

fof(bitBlastConstant_319,axiom,
    ~ b10000(bitIndex0) ).

fof(initSateConstraint_511,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex0) ).

fof(initSateConstraint_510,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex1) ).

fof(initSateConstraint_509,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex2) ).

fof(initSateConstraint_508,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex3) ).

fof(initSateConstraint_507,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex4) ).

fof(initSateConstraint_506,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex5) ).

fof(initSateConstraint_505,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex6) ).

fof(initSateConstraint_504,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex7) ).

fof(initSateConstraint_503,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex8) ).

fof(initSateConstraint_502,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex9) ).

fof(initSateConstraint_501,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex10) ).

fof(initSateConstraint_500,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex11) ).

fof(initSateConstraint_499,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex12) ).

fof(initSateConstraint_498,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex13) ).

fof(initSateConstraint_497,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex14) ).

fof(initSateConstraint_496,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex15) ).

fof(initSateConstraint_495,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex16) ).

fof(initSateConstraint_494,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex17) ).

fof(initSateConstraint_493,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex18) ).

fof(initSateConstraint_492,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex19) ).

fof(initSateConstraint_491,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex20) ).

fof(initSateConstraint_490,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex21) ).

fof(initSateConstraint_489,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex22) ).

fof(initSateConstraint_488,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex23) ).

fof(initSateConstraint_487,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex24) ).

fof(initSateConstraint_486,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex25) ).

fof(initSateConstraint_485,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex26) ).

fof(initSateConstraint_484,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex27) ).

fof(initSateConstraint_483,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex28) ).

fof(initSateConstraint_482,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex29) ).

fof(initSateConstraint_481,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex30) ).

fof(initSateConstraint_480,axiom,
    ~ v1060_array(constB0,b01111_address_term,bitIndex31) ).

fof(bitBlastConstant_318,axiom,
    ~ b01111(bitIndex4) ).

fof(bitBlastConstant_317,axiom,
    b01111(bitIndex3) ).

fof(bitBlastConstant_316,axiom,
    b01111(bitIndex2) ).

fof(bitBlastConstant_315,axiom,
    b01111(bitIndex1) ).

fof(bitBlastConstant_314,axiom,
    b01111(bitIndex0) ).

fof(initSateConstraint_479,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex0) ).

fof(initSateConstraint_478,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex1) ).

fof(initSateConstraint_477,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex2) ).

fof(initSateConstraint_476,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex3) ).

fof(initSateConstraint_475,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex4) ).

fof(initSateConstraint_474,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex5) ).

fof(initSateConstraint_473,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex6) ).

fof(initSateConstraint_472,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex7) ).

fof(initSateConstraint_471,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex8) ).

fof(initSateConstraint_470,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex9) ).

fof(initSateConstraint_469,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex10) ).

fof(initSateConstraint_468,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex11) ).

fof(initSateConstraint_467,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex12) ).

fof(initSateConstraint_466,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex13) ).

fof(initSateConstraint_465,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex14) ).

fof(initSateConstraint_464,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex15) ).

fof(initSateConstraint_463,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex16) ).

fof(initSateConstraint_462,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex17) ).

fof(initSateConstraint_461,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex18) ).

fof(initSateConstraint_460,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex19) ).

fof(initSateConstraint_459,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex20) ).

fof(initSateConstraint_458,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex21) ).

fof(initSateConstraint_457,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex22) ).

fof(initSateConstraint_456,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex23) ).

fof(initSateConstraint_455,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex24) ).

fof(initSateConstraint_454,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex25) ).

fof(initSateConstraint_453,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex26) ).

fof(initSateConstraint_452,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex27) ).

fof(initSateConstraint_451,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex28) ).

fof(initSateConstraint_450,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex29) ).

fof(initSateConstraint_449,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex30) ).

fof(initSateConstraint_448,axiom,
    ~ v1060_array(constB0,b01110_address_term,bitIndex31) ).

fof(bitBlastConstant_313,axiom,
    ~ b01110(bitIndex4) ).

fof(bitBlastConstant_312,axiom,
    b01110(bitIndex3) ).

fof(bitBlastConstant_311,axiom,
    b01110(bitIndex2) ).

fof(bitBlastConstant_310,axiom,
    b01110(bitIndex1) ).

fof(bitBlastConstant_309,axiom,
    ~ b01110(bitIndex0) ).

fof(initSateConstraint_447,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex0) ).

fof(initSateConstraint_446,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex1) ).

fof(initSateConstraint_445,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex2) ).

fof(initSateConstraint_444,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex3) ).

fof(initSateConstraint_443,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex4) ).

fof(initSateConstraint_442,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex5) ).

fof(initSateConstraint_441,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex6) ).

fof(initSateConstraint_440,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex7) ).

fof(initSateConstraint_439,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex8) ).

fof(initSateConstraint_438,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex9) ).

fof(initSateConstraint_437,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex10) ).

fof(initSateConstraint_436,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex11) ).

fof(initSateConstraint_435,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex12) ).

fof(initSateConstraint_434,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex13) ).

fof(initSateConstraint_433,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex14) ).

fof(initSateConstraint_432,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex15) ).

fof(initSateConstraint_431,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex16) ).

fof(initSateConstraint_430,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex17) ).

fof(initSateConstraint_429,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex18) ).

fof(initSateConstraint_428,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex19) ).

fof(initSateConstraint_427,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex20) ).

fof(initSateConstraint_426,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex21) ).

fof(initSateConstraint_425,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex22) ).

fof(initSateConstraint_424,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex23) ).

fof(initSateConstraint_423,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex24) ).

fof(initSateConstraint_422,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex25) ).

fof(initSateConstraint_421,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex26) ).

fof(initSateConstraint_420,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex27) ).

fof(initSateConstraint_419,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex28) ).

fof(initSateConstraint_418,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex29) ).

fof(initSateConstraint_417,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex30) ).

fof(initSateConstraint_416,axiom,
    ~ v1060_array(constB0,b01101_address_term,bitIndex31) ).

fof(bitBlastConstant_308,axiom,
    ~ b01101(bitIndex4) ).

fof(bitBlastConstant_307,axiom,
    b01101(bitIndex3) ).

fof(bitBlastConstant_306,axiom,
    b01101(bitIndex2) ).

fof(bitBlastConstant_305,axiom,
    ~ b01101(bitIndex1) ).

fof(bitBlastConstant_304,axiom,
    b01101(bitIndex0) ).

fof(initSateConstraint_415,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex0) ).

fof(initSateConstraint_414,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex1) ).

fof(initSateConstraint_413,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex2) ).

fof(initSateConstraint_412,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex3) ).

fof(initSateConstraint_411,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex4) ).

fof(initSateConstraint_410,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex5) ).

fof(initSateConstraint_409,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex6) ).

fof(initSateConstraint_408,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex7) ).

fof(initSateConstraint_407,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex8) ).

fof(initSateConstraint_406,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex9) ).

fof(initSateConstraint_405,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex10) ).

fof(initSateConstraint_404,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex11) ).

fof(initSateConstraint_403,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex12) ).

fof(initSateConstraint_402,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex13) ).

fof(initSateConstraint_401,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex14) ).

fof(initSateConstraint_400,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex15) ).

fof(initSateConstraint_399,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex16) ).

fof(initSateConstraint_398,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex17) ).

fof(initSateConstraint_397,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex18) ).

fof(initSateConstraint_396,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex19) ).

fof(initSateConstraint_395,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex20) ).

fof(initSateConstraint_394,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex21) ).

fof(initSateConstraint_393,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex22) ).

fof(initSateConstraint_392,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex23) ).

fof(initSateConstraint_391,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex24) ).

fof(initSateConstraint_390,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex25) ).

fof(initSateConstraint_389,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex26) ).

fof(initSateConstraint_388,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex27) ).

fof(initSateConstraint_387,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex28) ).

fof(initSateConstraint_386,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex29) ).

fof(initSateConstraint_385,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex30) ).

fof(initSateConstraint_384,axiom,
    ~ v1060_array(constB0,b01100_address_term,bitIndex31) ).

fof(bitBlastConstant_303,axiom,
    ~ b01100(bitIndex4) ).

fof(bitBlastConstant_302,axiom,
    b01100(bitIndex3) ).

fof(bitBlastConstant_301,axiom,
    b01100(bitIndex2) ).

fof(bitBlastConstant_300,axiom,
    ~ b01100(bitIndex1) ).

fof(bitBlastConstant_299,axiom,
    ~ b01100(bitIndex0) ).

fof(initSateConstraint_383,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex0) ).

fof(initSateConstraint_382,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex1) ).

fof(initSateConstraint_381,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex2) ).

fof(initSateConstraint_380,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex3) ).

fof(initSateConstraint_379,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex4) ).

fof(initSateConstraint_378,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex5) ).

fof(initSateConstraint_377,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex6) ).

fof(initSateConstraint_376,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex7) ).

fof(initSateConstraint_375,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex8) ).

fof(initSateConstraint_374,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex9) ).

fof(initSateConstraint_373,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex10) ).

fof(initSateConstraint_372,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex11) ).

fof(initSateConstraint_371,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex12) ).

fof(initSateConstraint_370,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex13) ).

fof(initSateConstraint_369,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex14) ).

fof(initSateConstraint_368,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex15) ).

fof(initSateConstraint_367,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex16) ).

fof(initSateConstraint_366,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex17) ).

fof(initSateConstraint_365,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex18) ).

fof(initSateConstraint_364,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex19) ).

fof(initSateConstraint_363,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex20) ).

fof(initSateConstraint_362,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex21) ).

fof(initSateConstraint_361,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex22) ).

fof(initSateConstraint_360,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex23) ).

fof(initSateConstraint_359,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex24) ).

fof(initSateConstraint_358,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex25) ).

fof(initSateConstraint_357,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex26) ).

fof(initSateConstraint_356,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex27) ).

fof(initSateConstraint_355,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex28) ).

fof(initSateConstraint_354,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex29) ).

fof(initSateConstraint_353,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex30) ).

fof(initSateConstraint_352,axiom,
    ~ v1060_array(constB0,b01011_address_term,bitIndex31) ).

fof(bitBlastConstant_298,axiom,
    ~ b01011(bitIndex4) ).

fof(bitBlastConstant_297,axiom,
    b01011(bitIndex3) ).

fof(bitBlastConstant_296,axiom,
    ~ b01011(bitIndex2) ).

fof(bitBlastConstant_295,axiom,
    b01011(bitIndex1) ).

fof(bitBlastConstant_294,axiom,
    b01011(bitIndex0) ).

fof(initSateConstraint_351,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex0) ).

fof(initSateConstraint_350,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex1) ).

fof(initSateConstraint_349,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex2) ).

fof(initSateConstraint_348,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex3) ).

fof(initSateConstraint_347,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex4) ).

fof(initSateConstraint_346,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex5) ).

fof(initSateConstraint_345,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex6) ).

fof(initSateConstraint_344,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex7) ).

fof(initSateConstraint_343,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex8) ).

fof(initSateConstraint_342,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex9) ).

fof(initSateConstraint_341,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex10) ).

fof(initSateConstraint_340,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex11) ).

fof(initSateConstraint_339,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex12) ).

fof(initSateConstraint_338,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex13) ).

fof(initSateConstraint_337,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex14) ).

fof(initSateConstraint_336,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex15) ).

fof(initSateConstraint_335,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex16) ).

fof(initSateConstraint_334,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex17) ).

fof(initSateConstraint_333,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex18) ).

fof(initSateConstraint_332,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex19) ).

fof(initSateConstraint_331,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex20) ).

fof(initSateConstraint_330,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex21) ).

fof(initSateConstraint_329,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex22) ).

fof(initSateConstraint_328,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex23) ).

fof(initSateConstraint_327,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex24) ).

fof(initSateConstraint_326,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex25) ).

fof(initSateConstraint_325,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex26) ).

fof(initSateConstraint_324,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex27) ).

fof(initSateConstraint_323,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex28) ).

fof(initSateConstraint_322,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex29) ).

fof(initSateConstraint_321,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex30) ).

fof(initSateConstraint_320,axiom,
    ~ v1060_array(constB0,b01010_address_term,bitIndex31) ).

fof(bitBlastConstant_293,axiom,
    ~ b01010(bitIndex4) ).

fof(bitBlastConstant_292,axiom,
    b01010(bitIndex3) ).

fof(bitBlastConstant_291,axiom,
    ~ b01010(bitIndex2) ).

fof(bitBlastConstant_290,axiom,
    b01010(bitIndex1) ).

fof(bitBlastConstant_289,axiom,
    ~ b01010(bitIndex0) ).

fof(initSateConstraint_319,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex0) ).

fof(initSateConstraint_318,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex1) ).

fof(initSateConstraint_317,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex2) ).

fof(initSateConstraint_316,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex3) ).

fof(initSateConstraint_315,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex4) ).

fof(initSateConstraint_314,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex5) ).

fof(initSateConstraint_313,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex6) ).

fof(initSateConstraint_312,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex7) ).

fof(initSateConstraint_311,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex8) ).

fof(initSateConstraint_310,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex9) ).

fof(initSateConstraint_309,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex10) ).

fof(initSateConstraint_308,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex11) ).

fof(initSateConstraint_307,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex12) ).

fof(initSateConstraint_306,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex13) ).

fof(initSateConstraint_305,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex14) ).

fof(initSateConstraint_304,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex15) ).

fof(initSateConstraint_303,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex16) ).

fof(initSateConstraint_302,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex17) ).

fof(initSateConstraint_301,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex18) ).

fof(initSateConstraint_300,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex19) ).

fof(initSateConstraint_299,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex20) ).

fof(initSateConstraint_298,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex21) ).

fof(initSateConstraint_297,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex22) ).

fof(initSateConstraint_296,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex23) ).

fof(initSateConstraint_295,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex24) ).

fof(initSateConstraint_294,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex25) ).

fof(initSateConstraint_293,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex26) ).

fof(initSateConstraint_292,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex27) ).

fof(initSateConstraint_291,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex28) ).

fof(initSateConstraint_290,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex29) ).

fof(initSateConstraint_289,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex30) ).

fof(initSateConstraint_288,axiom,
    ~ v1060_array(constB0,b01001_address_term,bitIndex31) ).

fof(bitBlastConstant_288,axiom,
    ~ b01001(bitIndex4) ).

fof(bitBlastConstant_287,axiom,
    b01001(bitIndex3) ).

fof(bitBlastConstant_286,axiom,
    ~ b01001(bitIndex2) ).

fof(bitBlastConstant_285,axiom,
    ~ b01001(bitIndex1) ).

fof(bitBlastConstant_284,axiom,
    b01001(bitIndex0) ).

fof(initSateConstraint_287,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex0) ).

fof(initSateConstraint_286,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex1) ).

fof(initSateConstraint_285,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex2) ).

fof(initSateConstraint_284,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex3) ).

fof(initSateConstraint_283,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex4) ).

fof(initSateConstraint_282,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex5) ).

fof(initSateConstraint_281,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex6) ).

fof(initSateConstraint_280,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex7) ).

fof(initSateConstraint_279,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex8) ).

fof(initSateConstraint_278,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex9) ).

fof(initSateConstraint_277,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex10) ).

fof(initSateConstraint_276,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex11) ).

fof(initSateConstraint_275,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex12) ).

fof(initSateConstraint_274,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex13) ).

fof(initSateConstraint_273,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex14) ).

fof(initSateConstraint_272,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex15) ).

fof(initSateConstraint_271,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex16) ).

fof(initSateConstraint_270,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex17) ).

fof(initSateConstraint_269,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex18) ).

fof(initSateConstraint_268,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex19) ).

fof(initSateConstraint_267,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex20) ).

fof(initSateConstraint_266,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex21) ).

fof(initSateConstraint_265,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex22) ).

fof(initSateConstraint_264,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex23) ).

fof(initSateConstraint_263,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex24) ).

fof(initSateConstraint_262,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex25) ).

fof(initSateConstraint_261,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex26) ).

fof(initSateConstraint_260,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex27) ).

fof(initSateConstraint_259,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex28) ).

fof(initSateConstraint_258,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex29) ).

fof(initSateConstraint_257,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex30) ).

fof(initSateConstraint_256,axiom,
    ~ v1060_array(constB0,b01000_address_term,bitIndex31) ).

fof(bitBlastConstant_283,axiom,
    ~ b01000(bitIndex4) ).

fof(bitBlastConstant_282,axiom,
    b01000(bitIndex3) ).

fof(bitBlastConstant_281,axiom,
    ~ b01000(bitIndex2) ).

fof(bitBlastConstant_280,axiom,
    ~ b01000(bitIndex1) ).

fof(bitBlastConstant_279,axiom,
    ~ b01000(bitIndex0) ).

fof(initSateConstraint_255,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex0) ).

fof(initSateConstraint_254,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex1) ).

fof(initSateConstraint_253,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex2) ).

fof(initSateConstraint_252,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex3) ).

fof(initSateConstraint_251,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex4) ).

fof(initSateConstraint_250,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex5) ).

fof(initSateConstraint_249,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex6) ).

fof(initSateConstraint_248,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex7) ).

fof(initSateConstraint_247,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex8) ).

fof(initSateConstraint_246,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex9) ).

fof(initSateConstraint_245,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex10) ).

fof(initSateConstraint_244,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex11) ).

fof(initSateConstraint_243,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex12) ).

fof(initSateConstraint_242,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex13) ).

fof(initSateConstraint_241,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex14) ).

fof(initSateConstraint_240,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex15) ).

fof(initSateConstraint_239,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex16) ).

fof(initSateConstraint_238,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex17) ).

fof(initSateConstraint_237,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex18) ).

fof(initSateConstraint_236,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex19) ).

fof(initSateConstraint_235,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex20) ).

fof(initSateConstraint_234,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex21) ).

fof(initSateConstraint_233,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex22) ).

fof(initSateConstraint_232,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex23) ).

fof(initSateConstraint_231,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex24) ).

fof(initSateConstraint_230,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex25) ).

fof(initSateConstraint_229,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex26) ).

fof(initSateConstraint_228,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex27) ).

fof(initSateConstraint_227,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex28) ).

fof(initSateConstraint_226,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex29) ).

fof(initSateConstraint_225,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex30) ).

fof(initSateConstraint_224,axiom,
    ~ v1060_array(constB0,b00111_address_term,bitIndex31) ).

fof(bitBlastConstant_278,axiom,
    ~ b00111(bitIndex4) ).

fof(bitBlastConstant_277,axiom,
    ~ b00111(bitIndex3) ).

fof(bitBlastConstant_276,axiom,
    b00111(bitIndex2) ).

fof(bitBlastConstant_275,axiom,
    b00111(bitIndex1) ).

fof(bitBlastConstant_274,axiom,
    b00111(bitIndex0) ).

fof(initSateConstraint_223,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex0) ).

fof(initSateConstraint_222,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex1) ).

fof(initSateConstraint_221,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex2) ).

fof(initSateConstraint_220,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex3) ).

fof(initSateConstraint_219,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex4) ).

fof(initSateConstraint_218,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex5) ).

fof(initSateConstraint_217,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex6) ).

fof(initSateConstraint_216,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex7) ).

fof(initSateConstraint_215,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex8) ).

fof(initSateConstraint_214,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex9) ).

fof(initSateConstraint_213,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex10) ).

fof(initSateConstraint_212,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex11) ).

fof(initSateConstraint_211,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex12) ).

fof(initSateConstraint_210,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex13) ).

fof(initSateConstraint_209,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex14) ).

fof(initSateConstraint_208,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex15) ).

fof(initSateConstraint_207,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex16) ).

fof(initSateConstraint_206,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex17) ).

fof(initSateConstraint_205,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex18) ).

fof(initSateConstraint_204,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex19) ).

fof(initSateConstraint_203,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex20) ).

fof(initSateConstraint_202,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex21) ).

fof(initSateConstraint_201,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex22) ).

fof(initSateConstraint_200,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex23) ).

fof(initSateConstraint_199,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex24) ).

fof(initSateConstraint_198,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex25) ).

fof(initSateConstraint_197,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex26) ).

fof(initSateConstraint_196,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex27) ).

fof(initSateConstraint_195,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex28) ).

fof(initSateConstraint_194,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex29) ).

fof(initSateConstraint_193,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex30) ).

fof(initSateConstraint_192,axiom,
    ~ v1060_array(constB0,b00110_address_term,bitIndex31) ).

fof(bitBlastConstant_273,axiom,
    ~ b00110(bitIndex4) ).

fof(bitBlastConstant_272,axiom,
    ~ b00110(bitIndex3) ).

fof(bitBlastConstant_271,axiom,
    b00110(bitIndex2) ).

fof(bitBlastConstant_270,axiom,
    b00110(bitIndex1) ).

fof(bitBlastConstant_269,axiom,
    ~ b00110(bitIndex0) ).

fof(initSateConstraint_191,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex0) ).

fof(initSateConstraint_190,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex1) ).

fof(initSateConstraint_189,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex2) ).

fof(initSateConstraint_188,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex3) ).

fof(initSateConstraint_187,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex4) ).

fof(initSateConstraint_186,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex5) ).

fof(initSateConstraint_185,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex6) ).

fof(initSateConstraint_184,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex7) ).

fof(initSateConstraint_183,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex8) ).

fof(initSateConstraint_182,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex9) ).

fof(initSateConstraint_181,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex10) ).

fof(initSateConstraint_180,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex11) ).

fof(initSateConstraint_179,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex12) ).

fof(initSateConstraint_178,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex13) ).

fof(initSateConstraint_177,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex14) ).

fof(initSateConstraint_176,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex15) ).

fof(initSateConstraint_175,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex16) ).

fof(initSateConstraint_174,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex17) ).

fof(initSateConstraint_173,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex18) ).

fof(initSateConstraint_172,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex19) ).

fof(initSateConstraint_171,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex20) ).

fof(initSateConstraint_170,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex21) ).

fof(initSateConstraint_169,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex22) ).

fof(initSateConstraint_168,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex23) ).

fof(initSateConstraint_167,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex24) ).

fof(initSateConstraint_166,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex25) ).

fof(initSateConstraint_165,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex26) ).

fof(initSateConstraint_164,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex27) ).

fof(initSateConstraint_163,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex28) ).

fof(initSateConstraint_162,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex29) ).

fof(initSateConstraint_161,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex30) ).

fof(initSateConstraint_160,axiom,
    ~ v1060_array(constB0,b00101_address_term,bitIndex31) ).

fof(bitBlastConstant_268,axiom,
    ~ b00101(bitIndex4) ).

fof(bitBlastConstant_267,axiom,
    ~ b00101(bitIndex3) ).

fof(bitBlastConstant_266,axiom,
    b00101(bitIndex2) ).

fof(bitBlastConstant_265,axiom,
    ~ b00101(bitIndex1) ).

fof(bitBlastConstant_264,axiom,
    b00101(bitIndex0) ).

fof(initSateConstraint_159,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex0) ).

fof(initSateConstraint_158,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex1) ).

fof(initSateConstraint_157,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex2) ).

fof(initSateConstraint_156,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex3) ).

fof(initSateConstraint_155,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex4) ).

fof(initSateConstraint_154,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex5) ).

fof(initSateConstraint_153,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex6) ).

fof(initSateConstraint_152,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex7) ).

fof(initSateConstraint_151,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex8) ).

fof(initSateConstraint_150,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex9) ).

fof(initSateConstraint_149,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex10) ).

fof(initSateConstraint_148,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex11) ).

fof(initSateConstraint_147,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex12) ).

fof(initSateConstraint_146,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex13) ).

fof(initSateConstraint_145,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex14) ).

fof(initSateConstraint_144,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex15) ).

fof(initSateConstraint_143,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex16) ).

fof(initSateConstraint_142,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex17) ).

fof(initSateConstraint_141,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex18) ).

fof(initSateConstraint_140,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex19) ).

fof(initSateConstraint_139,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex20) ).

fof(initSateConstraint_138,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex21) ).

fof(initSateConstraint_137,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex22) ).

fof(initSateConstraint_136,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex23) ).

fof(initSateConstraint_135,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex24) ).

fof(initSateConstraint_134,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex25) ).

fof(initSateConstraint_133,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex26) ).

fof(initSateConstraint_132,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex27) ).

fof(initSateConstraint_131,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex28) ).

fof(initSateConstraint_130,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex29) ).

fof(initSateConstraint_129,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex30) ).

fof(initSateConstraint_128,axiom,
    ~ v1060_array(constB0,b00100_address_term,bitIndex31) ).

fof(bitBlastConstant_263,axiom,
    ~ b00100(bitIndex4) ).

fof(bitBlastConstant_262,axiom,
    ~ b00100(bitIndex3) ).

fof(bitBlastConstant_261,axiom,
    b00100(bitIndex2) ).

fof(bitBlastConstant_260,axiom,
    ~ b00100(bitIndex1) ).

fof(bitBlastConstant_259,axiom,
    ~ b00100(bitIndex0) ).

fof(initSateConstraint_127,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex0) ).

fof(initSateConstraint_126,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex1) ).

fof(initSateConstraint_125,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex2) ).

fof(initSateConstraint_124,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex3) ).

fof(initSateConstraint_123,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex4) ).

fof(initSateConstraint_122,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex5) ).

fof(initSateConstraint_121,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex6) ).

fof(initSateConstraint_120,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex7) ).

fof(initSateConstraint_119,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex8) ).

fof(initSateConstraint_118,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex9) ).

fof(initSateConstraint_117,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex10) ).

fof(initSateConstraint_116,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex11) ).

fof(initSateConstraint_115,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex12) ).

fof(initSateConstraint_114,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex13) ).

fof(initSateConstraint_113,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex14) ).

fof(initSateConstraint_112,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex15) ).

fof(initSateConstraint_111,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex16) ).

fof(initSateConstraint_110,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex17) ).

fof(initSateConstraint_109,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex18) ).

fof(initSateConstraint_108,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex19) ).

fof(initSateConstraint_107,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex20) ).

fof(initSateConstraint_106,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex21) ).

fof(initSateConstraint_105,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex22) ).

fof(initSateConstraint_104,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex23) ).

fof(initSateConstraint_103,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex24) ).

fof(initSateConstraint_102,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex25) ).

fof(initSateConstraint_101,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex26) ).

fof(initSateConstraint_100,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex27) ).

fof(initSateConstraint_99,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex28) ).

fof(initSateConstraint_98,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex29) ).

fof(initSateConstraint_97,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex30) ).

fof(initSateConstraint_96,axiom,
    ~ v1060_array(constB0,b00011_address_term,bitIndex31) ).

fof(bitBlastConstant_258,axiom,
    ~ b00011(bitIndex4) ).

fof(bitBlastConstant_257,axiom,
    ~ b00011(bitIndex3) ).

fof(bitBlastConstant_256,axiom,
    ~ b00011(bitIndex2) ).

fof(bitBlastConstant_255,axiom,
    b00011(bitIndex1) ).

fof(bitBlastConstant_254,axiom,
    b00011(bitIndex0) ).

fof(initSateConstraint_95,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex0) ).

fof(initSateConstraint_94,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex1) ).

fof(initSateConstraint_93,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex2) ).

fof(initSateConstraint_92,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex3) ).

fof(initSateConstraint_91,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex4) ).

fof(initSateConstraint_90,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex5) ).

fof(initSateConstraint_89,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex6) ).

fof(initSateConstraint_88,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex7) ).

fof(initSateConstraint_87,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex8) ).

fof(initSateConstraint_86,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex9) ).

fof(initSateConstraint_85,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex10) ).

fof(initSateConstraint_84,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex11) ).

fof(initSateConstraint_83,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex12) ).

fof(initSateConstraint_82,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex13) ).

fof(initSateConstraint_81,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex14) ).

fof(initSateConstraint_80,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex15) ).

fof(initSateConstraint_79,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex16) ).

fof(initSateConstraint_78,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex17) ).

fof(initSateConstraint_77,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex18) ).

fof(initSateConstraint_76,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex19) ).

fof(initSateConstraint_75,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex20) ).

fof(initSateConstraint_74,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex21) ).

fof(initSateConstraint_73,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex22) ).

fof(initSateConstraint_72,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex23) ).

fof(initSateConstraint_71,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex24) ).

fof(initSateConstraint_70,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex25) ).

fof(initSateConstraint_69,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex26) ).

fof(initSateConstraint_68,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex27) ).

fof(initSateConstraint_67,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex28) ).

fof(initSateConstraint_66,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex29) ).

fof(initSateConstraint_65,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex30) ).

fof(initSateConstraint_64,axiom,
    ~ v1060_array(constB0,b00010_address_term,bitIndex31) ).

fof(bitBlastConstant_253,axiom,
    ~ b00010(bitIndex4) ).

fof(bitBlastConstant_252,axiom,
    ~ b00010(bitIndex3) ).

fof(bitBlastConstant_251,axiom,
    ~ b00010(bitIndex2) ).

fof(bitBlastConstant_250,axiom,
    b00010(bitIndex1) ).

fof(bitBlastConstant_249,axiom,
    ~ b00010(bitIndex0) ).

fof(initSateConstraint_63,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex0) ).

fof(initSateConstraint_62,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex1) ).

fof(initSateConstraint_61,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex2) ).

fof(initSateConstraint_60,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex3) ).

fof(initSateConstraint_59,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex4) ).

fof(initSateConstraint_58,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex5) ).

fof(initSateConstraint_57,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex6) ).

fof(initSateConstraint_56,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex7) ).

fof(initSateConstraint_55,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex8) ).

fof(initSateConstraint_54,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex9) ).

fof(initSateConstraint_53,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex10) ).

fof(initSateConstraint_52,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex11) ).

fof(initSateConstraint_51,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex12) ).

fof(initSateConstraint_50,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex13) ).

fof(initSateConstraint_49,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex14) ).

fof(initSateConstraint_48,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex15) ).

fof(initSateConstraint_47,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex16) ).

fof(initSateConstraint_46,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex17) ).

fof(initSateConstraint_45,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex18) ).

fof(initSateConstraint_44,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex19) ).

fof(initSateConstraint_43,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex20) ).

fof(initSateConstraint_42,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex21) ).

fof(initSateConstraint_41,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex22) ).

fof(initSateConstraint_40,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex23) ).

fof(initSateConstraint_39,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex24) ).

fof(initSateConstraint_38,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex25) ).

fof(initSateConstraint_37,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex26) ).

fof(initSateConstraint_36,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex27) ).

fof(initSateConstraint_35,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex28) ).

fof(initSateConstraint_34,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex29) ).

fof(initSateConstraint_33,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex30) ).

fof(initSateConstraint_32,axiom,
    ~ v1060_array(constB0,b00001_address_term,bitIndex31) ).

fof(bitBlastConstant_248,axiom,
    ~ b00001(bitIndex4) ).

fof(bitBlastConstant_247,axiom,
    ~ b00001(bitIndex3) ).

fof(bitBlastConstant_246,axiom,
    ~ b00001(bitIndex2) ).

fof(bitBlastConstant_245,axiom,
    ~ b00001(bitIndex1) ).

fof(bitBlastConstant_244,axiom,
    b00001(bitIndex0) ).

fof(initSateConstraint_31,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex0) ).

fof(initSateConstraint_30,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex1) ).

fof(initSateConstraint_29,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex2) ).

fof(initSateConstraint_28,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex3) ).

fof(initSateConstraint_27,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex4) ).

fof(initSateConstraint_26,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex5) ).

fof(initSateConstraint_25,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex6) ).

fof(initSateConstraint_24,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex7) ).

fof(initSateConstraint_23,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex8) ).

fof(initSateConstraint_22,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex9) ).

fof(initSateConstraint_21,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex10) ).

fof(initSateConstraint_20,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex11) ).

fof(initSateConstraint_19,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex12) ).

fof(initSateConstraint_18,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex13) ).

fof(initSateConstraint_17,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex14) ).

fof(initSateConstraint_16,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex15) ).

fof(initSateConstraint_15,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex16) ).

fof(initSateConstraint_14,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex17) ).

fof(initSateConstraint_13,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex18) ).

fof(initSateConstraint_12,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex19) ).

fof(initSateConstraint_11,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex20) ).

fof(initSateConstraint_10,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex21) ).

fof(initSateConstraint_9,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex22) ).

fof(initSateConstraint_8,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex23) ).

fof(initSateConstraint_7,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex24) ).

fof(initSateConstraint_6,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex25) ).

fof(initSateConstraint_5,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex26) ).

fof(initSateConstraint_4,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex27) ).

fof(initSateConstraint_3,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex28) ).

fof(initSateConstraint_2,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex29) ).

fof(initSateConstraint_1,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex30) ).

fof(initSateConstraint,axiom,
    ~ v1060_array(constB0,b00000_address_term,bitIndex31) ).

fof(addAssignment_291,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v1115(VarCurr,B)
      <=> v1117(VarCurr,B) ) ) ).

fof(addAssignment_290,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v1117(VarCurr,B)
      <=> v1119(VarCurr,B) ) ) ).

fof(addAssignment_289,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v1119(VarCurr,B)
      <=> v1121(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_28,axiom,
    ! [VarCurr] :
      ( ~ v1232(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v1121(VarCurr,B)
          <=> v1209(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_29,axiom,
    ! [VarCurr] :
      ( v1232(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v1121(VarCurr,B)
          <=> v1178(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_118,axiom,
    ! [VarCurr] :
      ( v1232(VarCurr)
    <=> ( v1233(VarCurr)
        & v977(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_117,axiom,
    ! [VarCurr] :
      ( v1233(VarCurr)
    <=> ( v1123(VarCurr)
        & v1234(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_116,axiom,
    ! [VarCurr] :
      ( v1234(VarCurr)
    <=> ( v1235(VarCurr)
        | v1236(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_92,axiom,
    ! [VarCurr] :
      ( v1236(VarCurr)
    <=> ( ( v983(VarCurr,bitIndex2)
        <=> $false )
        & ( v983(VarCurr,bitIndex1)
        <=> $true )
        & ( v983(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_91,axiom,
    ! [VarCurr] :
      ( v1235(VarCurr)
    <=> ( ( v983(VarCurr,bitIndex2)
        <=> $false )
        & ( v983(VarCurr,bitIndex1)
        <=> $false )
        & ( v983(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_17,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1212(VarNext)
       => ! [B] :
            ( range_4_0(B)
           => ( v1209(VarNext,B)
            <=> v1209(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_17,axiom,
    ! [VarNext] :
      ( v1212(VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v1209(VarNext,B)
          <=> v1228(VarNext,B) ) ) ) ).

fof(addAssignment_288,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v1228(VarNext,B)
          <=> v1226(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_27,axiom,
    ! [VarCurr] :
      ( ~ v1156(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v1226(VarCurr,B)
          <=> v1178(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_28,axiom,
    ! [VarCurr] :
      ( v1156(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v1226(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_115,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1212(VarNext)
      <=> ( v1213(VarNext)
          & v1220(VarNext) ) ) ) ).

fof(addAssignment_287,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1220(VarNext)
      <=> v1218(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_114,axiom,
    ! [VarCurr] :
      ( v1218(VarCurr)
    <=> ( v1221(VarCurr)
        | v1156(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_113,axiom,
    ! [VarCurr] :
      ( v1221(VarCurr)
    <=> ( v1222(VarCurr)
        & v977(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_28,axiom,
    ( v977(constB0)
  <=> $false ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_112,axiom,
    ! [VarCurr] :
      ( v1222(VarCurr)
    <=> ( v1123(VarCurr)
        & v1223(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_111,axiom,
    ! [VarCurr] :
      ( v1223(VarCurr)
    <=> ( v1224(VarCurr)
        | v1225(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_90,axiom,
    ! [VarCurr] :
      ( v1225(VarCurr)
    <=> ( ( v983(VarCurr,bitIndex2)
        <=> $false )
        & ( v983(VarCurr,bitIndex1)
        <=> $true )
        & ( v983(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_89,axiom,
    ! [VarCurr] :
      ( v1224(VarCurr)
    <=> ( ( v983(VarCurr,bitIndex2)
        <=> $false )
        & ( v983(VarCurr,bitIndex1)
        <=> $false )
        & ( v983(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_110,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1213(VarNext)
      <=> ( v1215(VarNext)
          & v125(VarNext) ) ) ) ).

fof(writeUnaryOperator_37,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1215(VarNext)
      <=> v990(VarNext) ) ) ).

fof(addAssignmentInitValueVector_27,axiom,
    ! [B] :
      ( range_4_0(B)
     => ( v1209(constB0,B)
      <=> $false ) ) ).

fof(addCaseBooleanConditionEqualRanges1_16,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1194(VarNext)
       => ! [B] :
            ( range_4_0(B)
           => ( v1178(VarNext,B)
            <=> v1178(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_16,axiom,
    ! [VarNext] :
      ( v1194(VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v1178(VarNext,B)
          <=> v1205(VarNext,B) ) ) ) ).

fof(addAssignment_286,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v1205(VarNext,B)
          <=> v1203(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_26,axiom,
    ! [VarCurr] :
      ( ~ v997(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v1203(VarCurr,B)
          <=> v1180(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_27,axiom,
    ! [VarCurr] :
      ( v997(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v1203(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_109,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1194(VarNext)
      <=> ( v1195(VarNext)
          & v1202(VarNext) ) ) ) ).

fof(addAssignment_285,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1202(VarNext)
      <=> v1200(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_108,axiom,
    ! [VarCurr] :
      ( v1200(VarCurr)
    <=> ( v67(VarCurr)
        | v997(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_107,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1195(VarNext)
      <=> ( v1197(VarNext)
          & v125(VarNext) ) ) ) ).

fof(writeUnaryOperator_36,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1197(VarNext)
      <=> v990(VarNext) ) ) ).

fof(addAssignmentInitValueVector_26,axiom,
    ! [B] :
      ( range_4_0(B)
     => ( v1178(constB0,B)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_11,axiom,
    ! [VarCurr] :
      ( ( ~ v1190(VarCurr)
        & ~ v1191(VarCurr) )
     => ! [B] :
          ( range_4_0(B)
         => ( v1180(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_20,axiom,
    ! [VarCurr] :
      ( v1191(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v1180(VarCurr,B)
          <=> v1182(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_18,axiom,
    ! [VarCurr] :
      ( v1190(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v1180(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_106,axiom,
    ! [VarCurr] :
      ( v1191(VarCurr)
    <=> ( v1029(VarCurr)
        | v1032(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_105,axiom,
    ! [VarCurr] :
      ( v1190(VarCurr)
    <=> ( v1026(VarCurr)
        | v1027(VarCurr) ) ) ).

fof(addAssignment_284,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v1182(VarCurr,B)
      <=> v1184(VarCurr,B) ) ) ).

fof(addAssignment_283,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v1184(VarCurr,B)
      <=> v1186(VarCurr,B) ) ) ).

fof(addAssignment_282,axiom,
    ! [VarCurr] :
      ( ( v1186(VarCurr,bitIndex4)
      <=> v1188(VarCurr,bitIndex19) )
      & ( v1186(VarCurr,bitIndex3)
      <=> v1188(VarCurr,bitIndex18) )
      & ( v1186(VarCurr,bitIndex2)
      <=> v1188(VarCurr,bitIndex17) )
      & ( v1186(VarCurr,bitIndex1)
      <=> v1188(VarCurr,bitIndex16) )
      & ( v1186(VarCurr,bitIndex0)
      <=> v1188(VarCurr,bitIndex15) ) ) ).

fof(addAssignmentInitValueVector_25,axiom,
    ( ( v1188(constB0,bitIndex19)
    <=> $false )
    & ( v1188(constB0,bitIndex18)
    <=> $false )
    & ( v1188(constB0,bitIndex17)
    <=> $false )
    & ( v1188(constB0,bitIndex16)
    <=> $false )
    & ( v1188(constB0,bitIndex15)
    <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges5,axiom,
    ! [VarCurr] :
      ( ( ~ v1160(VarCurr)
        & ~ v1161(VarCurr)
        & ~ v1165(VarCurr)
        & ~ v1166(VarCurr)
        & ~ v1176(VarCurr) )
     => ( v1123(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_1,axiom,
    ! [VarCurr] :
      ( v1176(VarCurr)
     => ( v1123(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_4,axiom,
    ! [VarCurr] :
      ( v1166(VarCurr)
     => ( v1123(VarCurr)
      <=> v1167(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_10,axiom,
    ! [VarCurr] :
      ( v1165(VarCurr)
     => ( v1123(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_19,axiom,
    ! [VarCurr] :
      ( v1161(VarCurr)
     => ( v1123(VarCurr)
      <=> v1162(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_17,axiom,
    ! [VarCurr] :
      ( v1160(VarCurr)
     => ( v1123(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_88,axiom,
    ! [VarCurr] :
      ( v1176(VarCurr)
    <=> ( ( v710(VarCurr,bitIndex2)
        <=> $true )
        & ( v710(VarCurr,bitIndex1)
        <=> $false )
        & ( v710(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_18,axiom,
    ! [VarCurr] :
      ( ~ v1168(VarCurr)
     => ( v1167(VarCurr)
      <=> v1170(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_16,axiom,
    ! [VarCurr] :
      ( v1168(VarCurr)
     => ( v1167(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_17,axiom,
    ! [VarCurr] :
      ( ~ v1171(VarCurr)
     => ( v1170(VarCurr)
      <=> v1173(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_15,axiom,
    ! [VarCurr] :
      ( v1171(VarCurr)
     => ( v1170(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_16,axiom,
    ! [VarCurr] :
      ( ~ v1174(VarCurr)
     => ( v1173(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_14,axiom,
    ! [VarCurr] :
      ( v1174(VarCurr)
     => ( v1173(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_87,axiom,
    ! [VarCurr] :
      ( v1175(VarCurr)
    <=> ( v714(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_86,axiom,
    ! [VarCurr] :
      ( v1174(VarCurr)
    <=> ( v714(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_85,axiom,
    ! [VarCurr] :
      ( v1172(VarCurr)
    <=> ( v1125(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_84,axiom,
    ! [VarCurr] :
      ( v1171(VarCurr)
    <=> ( v1125(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_83,axiom,
    ! [VarCurr] :
      ( v1169(VarCurr)
    <=> ( v706(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_82,axiom,
    ! [VarCurr] :
      ( v1168(VarCurr)
    <=> ( v706(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_81,axiom,
    ! [VarCurr] :
      ( v1166(VarCurr)
    <=> ( ( v710(VarCurr,bitIndex2)
        <=> $false )
        & ( v710(VarCurr,bitIndex1)
        <=> $true )
        & ( v710(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_80,axiom,
    ! [VarCurr] :
      ( v1165(VarCurr)
    <=> ( ( v710(VarCurr,bitIndex2)
        <=> $false )
        & ( v710(VarCurr,bitIndex1)
        <=> $true )
        & ( v710(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_15,axiom,
    ! [VarCurr] :
      ( ~ v1163(VarCurr)
     => ( v1162(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_13,axiom,
    ! [VarCurr] :
      ( v1163(VarCurr)
     => ( v1162(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_79,axiom,
    ! [VarCurr] :
      ( v1164(VarCurr)
    <=> ( v706(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_78,axiom,
    ! [VarCurr] :
      ( v1163(VarCurr)
    <=> ( v706(VarCurr)
      <=> $true ) ) ).

fof(addAssignmentInitValueVector_24,axiom,
    ( v706(constB0)
  <=> $false ) ).

fof(addBitVectorEqualityBitBlasted_77,axiom,
    ! [VarCurr] :
      ( v1161(VarCurr)
    <=> ( ( v710(VarCurr,bitIndex2)
        <=> $false )
        & ( v710(VarCurr,bitIndex1)
        <=> $false )
        & ( v710(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_76,axiom,
    ! [VarCurr] :
      ( v1160(VarCurr)
    <=> ( ( v710(VarCurr,bitIndex2)
        <=> $false )
        & ( v710(VarCurr,bitIndex1)
        <=> $false )
        & ( v710(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignmentInitValueVector_23,axiom,
    ! [B] :
      ( range_2_0(B)
     => ( v710(constB0,B)
      <=> $false ) ) ).

fof(addCaseBooleanConditionEqualRanges1_15,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1147(VarNext)
       => ( v1125(VarNext)
        <=> v1125(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_15,axiom,
    ! [VarNext] :
      ( v1147(VarNext)
     => ( v1125(VarNext)
      <=> v1155(VarNext) ) ) ).

fof(addAssignment_281,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1155(VarNext)
      <=> v1153(VarCurr) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch,axiom,
    ! [VarCurr] :
      ( ~ v1156(VarCurr)
     => ( v1153(VarCurr)
      <=> v1127(VarCurr,bitIndex4) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_26,axiom,
    ! [VarCurr] :
      ( v1156(VarCurr)
     => ( v1153(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_75,axiom,
    ! [VarCurr] :
      ( v1156(VarCurr)
    <=> ( v51(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_104,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1147(VarNext)
      <=> v1148(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_103,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1148(VarNext)
      <=> ( v1149(VarNext)
          & v125(VarNext) ) ) ) ).

fof(writeUnaryOperator_35,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1149(VarNext)
      <=> v990(VarNext) ) ) ).

fof(addAssignmentInitValueVector_22,axiom,
    ( v1125(constB0)
  <=> $false ) ).

fof(addAssignment_280,axiom,
    ! [VarCurr] :
      ( v1127(VarCurr,bitIndex4)
    <=> v1129(VarCurr,bitIndex4) ) ).

fof(addAssignment_279,axiom,
    ! [VarCurr] :
      ( v1129(VarCurr,bitIndex4)
    <=> v1131(VarCurr,bitIndex4) ) ).

fof(addAssignment_278,axiom,
    ! [VarCurr] :
      ( v1131(VarCurr,bitIndex4)
    <=> v1133(VarCurr,bitIndex4) ) ).

fof(addAssignment_277,axiom,
    ! [VarCurr] :
      ( v1133(VarCurr,bitIndex4)
    <=> v1144(VarCurr,bitIndex4) ) ).

fof(addAssignment_276,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v1137(VarCurr,B)
      <=> v1139(VarCurr,B) ) ) ).

fof(addAssignment_275,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v1139(VarCurr,B)
      <=> v1141(VarCurr,B) ) ) ).

fof(addAssignment_274,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v1141(VarCurr,B)
      <=> v1143(VarCurr,B) ) ) ).

fof(addAssignmentInitValueVector_21,axiom,
    ! [B] :
      ( range_4_0(B)
     => ( v1143(constB0,B)
      <=> $false ) ) ).

fof(addAssignment_273,axiom,
    ! [VarCurr,B] :
      ( range_43_0(B)
     => ( v1105(VarCurr,B)
      <=> v1107(VarCurr,B) ) ) ).

fof(addAssignment_272,axiom,
    ! [VarCurr,B] :
      ( range_43_0(B)
     => ( v1107(VarCurr,B)
      <=> v1109(VarCurr,B) ) ) ).

fof(addAssignment_271,axiom,
    ! [VarCurr,B] :
      ( range_43_0(B)
     => ( v1109(VarCurr,B)
      <=> v1111(VarCurr,B) ) ) ).

fof(addAssignmentInitValue_92,axiom,
    ~ v1111(constB0,bitIndex31) ).

fof(addAssignmentInitValue_91,axiom,
    ~ v1111(constB0,bitIndex30) ).

fof(addAssignmentInitValue_90,axiom,
    ~ v1111(constB0,bitIndex29) ).

fof(addAssignmentInitValue_89,axiom,
    ~ v1111(constB0,bitIndex28) ).

fof(addAssignmentInitValue_88,axiom,
    ~ v1111(constB0,bitIndex27) ).

fof(addAssignmentInitValue_87,axiom,
    ~ v1111(constB0,bitIndex26) ).

fof(addAssignmentInitValue_86,axiom,
    ~ v1111(constB0,bitIndex25) ).

fof(addAssignmentInitValue_85,axiom,
    ~ v1111(constB0,bitIndex24) ).

fof(addAssignmentInitValue_84,axiom,
    ~ v1111(constB0,bitIndex23) ).

fof(addAssignmentInitValue_83,axiom,
    ~ v1111(constB0,bitIndex22) ).

fof(addAssignmentInitValue_82,axiom,
    ~ v1111(constB0,bitIndex21) ).

fof(addAssignmentInitValue_81,axiom,
    ~ v1111(constB0,bitIndex20) ).

fof(addAssignmentInitValue_80,axiom,
    ~ v1111(constB0,bitIndex19) ).

fof(addAssignmentInitValue_79,axiom,
    ~ v1111(constB0,bitIndex18) ).

fof(addAssignmentInitValue_78,axiom,
    ~ v1111(constB0,bitIndex17) ).

fof(addAssignmentInitValue_77,axiom,
    ~ v1111(constB0,bitIndex16) ).

fof(addAssignmentInitValue_76,axiom,
    ~ v1111(constB0,bitIndex15) ).

fof(addAssignmentInitValue_75,axiom,
    ~ v1111(constB0,bitIndex14) ).

fof(addAssignmentInitValue_74,axiom,
    ~ v1111(constB0,bitIndex13) ).

fof(addAssignmentInitValue_73,axiom,
    ~ v1111(constB0,bitIndex12) ).

fof(addAssignmentInitValue_72,axiom,
    ~ v1111(constB0,bitIndex11) ).

fof(addAssignmentInitValue_71,axiom,
    ~ v1111(constB0,bitIndex10) ).

fof(addAssignmentInitValue_70,axiom,
    ~ v1111(constB0,bitIndex9) ).

fof(addAssignmentInitValue_69,axiom,
    ~ v1111(constB0,bitIndex8) ).

fof(addAssignmentInitValue_68,axiom,
    ~ v1111(constB0,bitIndex7) ).

fof(addAssignmentInitValue_67,axiom,
    ~ v1111(constB0,bitIndex6) ).

fof(addAssignmentInitValue_66,axiom,
    ~ v1111(constB0,bitIndex5) ).

fof(addAssignmentInitValue_65,axiom,
    ~ v1111(constB0,bitIndex4) ).

fof(addAssignmentInitValue_64,axiom,
    ~ v1111(constB0,bitIndex3) ).

fof(addAssignmentInitValue_63,axiom,
    ~ v1111(constB0,bitIndex2) ).

fof(addAssignmentInitValue_62,axiom,
    ~ v1111(constB0,bitIndex1) ).

fof(addAssignmentInitValue_61,axiom,
    ~ v1111(constB0,bitIndex0) ).

fof(bitBlastConstant_243,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex31) ).

fof(bitBlastConstant_242,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex30) ).

fof(bitBlastConstant_241,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex29) ).

fof(bitBlastConstant_240,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex28) ).

fof(bitBlastConstant_239,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex27) ).

fof(bitBlastConstant_238,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex26) ).

fof(bitBlastConstant_237,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex25) ).

fof(bitBlastConstant_236,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex24) ).

fof(bitBlastConstant_235,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex23) ).

fof(bitBlastConstant_234,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex22) ).

fof(bitBlastConstant_233,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex21) ).

fof(bitBlastConstant_232,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex20) ).

fof(bitBlastConstant_231,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex19) ).

fof(bitBlastConstant_230,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex18) ).

fof(bitBlastConstant_229,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex17) ).

fof(bitBlastConstant_228,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex16) ).

fof(bitBlastConstant_227,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex15) ).

fof(bitBlastConstant_226,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex14) ).

fof(bitBlastConstant_225,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex13) ).

fof(bitBlastConstant_224,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex12) ).

fof(bitBlastConstant_223,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex11) ).

fof(bitBlastConstant_222,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex10) ).

fof(bitBlastConstant_221,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex9) ).

fof(bitBlastConstant_220,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex8) ).

fof(bitBlastConstant_219,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex7) ).

fof(bitBlastConstant_218,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex6) ).

fof(bitBlastConstant_217,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex5) ).

fof(bitBlastConstant_216,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex4) ).

fof(bitBlastConstant_215,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex3) ).

fof(bitBlastConstant_214,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex2) ).

fof(bitBlastConstant_213,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex1) ).

fof(bitBlastConstant_212,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex0) ).

fof(addAssignment_270,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v1097(VarCurr,B)
      <=> v1099(VarCurr,B) ) ) ).

fof(addAssignment_269,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v1099(VarCurr,B)
      <=> v1101(VarCurr,B) ) ) ).

fof(addAssignment_268,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v1101(VarCurr,B)
      <=> v1103(VarCurr,B) ) ) ).

fof(addAssignmentInitValueVector_20,axiom,
    ! [B] :
      ( range_4_0(B)
     => ( v1103(constB0,B)
      <=> $false ) ) ).

fof(addAssignment_267,axiom,
    ! [VarCurr,B] :
      ( range_43_0(B)
     => ( v1087(VarCurr,B)
      <=> v1089(VarCurr,B) ) ) ).

fof(addAssignment_266,axiom,
    ! [VarCurr,B] :
      ( range_43_0(B)
     => ( v1089(VarCurr,B)
      <=> v1091(VarCurr,B) ) ) ).

fof(addAssignment_265,axiom,
    ! [VarCurr,B] :
      ( range_43_0(B)
     => ( v1091(VarCurr,B)
      <=> v1093(VarCurr,B) ) ) ).

fof(range_axiom_11,axiom,
    ! [B] :
      ( range_43_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B
        | bitIndex30 = B
        | bitIndex31 = B
        | bitIndex32 = B
        | bitIndex33 = B
        | bitIndex34 = B
        | bitIndex35 = B
        | bitIndex36 = B
        | bitIndex37 = B
        | bitIndex38 = B
        | bitIndex39 = B
        | bitIndex40 = B
        | bitIndex41 = B
        | bitIndex42 = B
        | bitIndex43 = B ) ) ).

fof(addAssignmentInitValue_60,axiom,
    ~ v1093(constB0,bitIndex31) ).

fof(addAssignmentInitValue_59,axiom,
    ~ v1093(constB0,bitIndex30) ).

fof(addAssignmentInitValue_58,axiom,
    ~ v1093(constB0,bitIndex29) ).

fof(addAssignmentInitValue_57,axiom,
    ~ v1093(constB0,bitIndex28) ).

fof(addAssignmentInitValue_56,axiom,
    ~ v1093(constB0,bitIndex27) ).

fof(addAssignmentInitValue_55,axiom,
    ~ v1093(constB0,bitIndex26) ).

fof(addAssignmentInitValue_54,axiom,
    ~ v1093(constB0,bitIndex25) ).

fof(addAssignmentInitValue_53,axiom,
    ~ v1093(constB0,bitIndex24) ).

fof(addAssignmentInitValue_52,axiom,
    ~ v1093(constB0,bitIndex23) ).

fof(addAssignmentInitValue_51,axiom,
    ~ v1093(constB0,bitIndex22) ).

fof(addAssignmentInitValue_50,axiom,
    ~ v1093(constB0,bitIndex21) ).

fof(addAssignmentInitValue_49,axiom,
    ~ v1093(constB0,bitIndex20) ).

fof(addAssignmentInitValue_48,axiom,
    ~ v1093(constB0,bitIndex19) ).

fof(addAssignmentInitValue_47,axiom,
    ~ v1093(constB0,bitIndex18) ).

fof(addAssignmentInitValue_46,axiom,
    ~ v1093(constB0,bitIndex17) ).

fof(addAssignmentInitValue_45,axiom,
    ~ v1093(constB0,bitIndex16) ).

fof(addAssignmentInitValue_44,axiom,
    ~ v1093(constB0,bitIndex15) ).

fof(addAssignmentInitValue_43,axiom,
    ~ v1093(constB0,bitIndex14) ).

fof(addAssignmentInitValue_42,axiom,
    ~ v1093(constB0,bitIndex13) ).

fof(addAssignmentInitValue_41,axiom,
    ~ v1093(constB0,bitIndex12) ).

fof(addAssignmentInitValue_40,axiom,
    ~ v1093(constB0,bitIndex11) ).

fof(addAssignmentInitValue_39,axiom,
    ~ v1093(constB0,bitIndex10) ).

fof(addAssignmentInitValue_38,axiom,
    ~ v1093(constB0,bitIndex9) ).

fof(addAssignmentInitValue_37,axiom,
    ~ v1093(constB0,bitIndex8) ).

fof(addAssignmentInitValue_36,axiom,
    ~ v1093(constB0,bitIndex7) ).

fof(addAssignmentInitValue_35,axiom,
    ~ v1093(constB0,bitIndex6) ).

fof(addAssignmentInitValue_34,axiom,
    ~ v1093(constB0,bitIndex5) ).

fof(addAssignmentInitValue_33,axiom,
    ~ v1093(constB0,bitIndex4) ).

fof(addAssignmentInitValue_32,axiom,
    ~ v1093(constB0,bitIndex3) ).

fof(addAssignmentInitValue_31,axiom,
    ~ v1093(constB0,bitIndex2) ).

fof(addAssignmentInitValue_30,axiom,
    ~ v1093(constB0,bitIndex1) ).

fof(addAssignmentInitValue_29,axiom,
    ~ v1093(constB0,bitIndex0) ).

fof(bitBlastConstant_211,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex31) ).

fof(bitBlastConstant_210,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex30) ).

fof(bitBlastConstant_209,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex29) ).

fof(bitBlastConstant_208,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex28) ).

fof(bitBlastConstant_207,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex27) ).

fof(bitBlastConstant_206,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex26) ).

fof(bitBlastConstant_205,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex25) ).

fof(bitBlastConstant_204,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex24) ).

fof(bitBlastConstant_203,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex23) ).

fof(bitBlastConstant_202,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex22) ).

fof(bitBlastConstant_201,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex21) ).

fof(bitBlastConstant_200,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex20) ).

fof(bitBlastConstant_199,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex19) ).

fof(bitBlastConstant_198,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex18) ).

fof(bitBlastConstant_197,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex17) ).

fof(bitBlastConstant_196,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex16) ).

fof(bitBlastConstant_195,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex15) ).

fof(bitBlastConstant_194,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex14) ).

fof(bitBlastConstant_193,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex13) ).

fof(bitBlastConstant_192,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex12) ).

fof(bitBlastConstant_191,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex11) ).

fof(bitBlastConstant_190,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex10) ).

fof(bitBlastConstant_189,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex9) ).

fof(bitBlastConstant_188,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex8) ).

fof(bitBlastConstant_187,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex7) ).

fof(bitBlastConstant_186,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex6) ).

fof(bitBlastConstant_185,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex5) ).

fof(bitBlastConstant_184,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex4) ).

fof(bitBlastConstant_183,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex3) ).

fof(bitBlastConstant_182,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex2) ).

fof(bitBlastConstant_181,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex1) ).

fof(bitBlastConstant_180,axiom,
    ~ bxxxxxxxxxxxx00000000000000000000000000000000(bitIndex0) ).

fof(addAssignment_264,axiom,
    ! [VarCurr] :
      ( v1079(VarCurr)
    <=> v1081(VarCurr) ) ).

fof(addAssignment_263,axiom,
    ! [VarCurr] :
      ( v1081(VarCurr)
    <=> v1083(VarCurr) ) ).

fof(addAssignment_262,axiom,
    ! [VarCurr] :
      ( v1083(VarCurr)
    <=> v1085(VarCurr) ) ).

fof(addAssignmentInitValueVector_19,axiom,
    ( v1085(constB0)
  <=> $false ) ).

fof(addAssignment_261,axiom,
    ! [VarCurr] :
      ( v1071(VarCurr)
    <=> v1073(VarCurr) ) ).

fof(addAssignment_260,axiom,
    ! [VarCurr] :
      ( v1073(VarCurr)
    <=> v1075(VarCurr) ) ).

fof(addAssignment_259,axiom,
    ! [VarCurr] :
      ( v1075(VarCurr)
    <=> v1077(VarCurr) ) ).

fof(addAssignmentInitValueVector_18,axiom,
    ( v1077(constB0)
  <=> $false ) ).

fof(addAssignment_258,axiom,
    ! [VarCurr] :
      ( v1067(VarCurr)
    <=> v1069(VarCurr) ) ).

fof(addAssignment_257,axiom,
    ! [VarCurr] :
      ( v1069(VarCurr)
    <=> v53(VarCurr) ) ).

fof(addAssignment_256,axiom,
    ! [VarCurr] :
      ( v1062(VarCurr)
    <=> v1064(VarCurr) ) ).

fof(addAssignment_255,axiom,
    ! [VarCurr] :
      ( v1064(VarCurr)
    <=> v127(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_14,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1035(VarNext)
       => ! [B] :
            ( range_4_0(B)
           => ( v1012(VarNext,B)
            <=> v1012(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_14,axiom,
    ! [VarNext] :
      ( v1035(VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v1012(VarNext,B)
          <=> v1046(VarNext,B) ) ) ) ).

fof(addAssignment_254,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v1046(VarNext,B)
          <=> v1044(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_25,axiom,
    ! [VarCurr] :
      ( ~ v997(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v1044(VarCurr,B)
          <=> v1015(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_25,axiom,
    ! [VarCurr] :
      ( v997(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v1044(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_102,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1035(VarNext)
      <=> ( v1036(VarNext)
          & v1043(VarNext) ) ) ) ).

fof(addAssignment_253,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1043(VarNext)
      <=> v1041(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_101,axiom,
    ! [VarCurr] :
      ( v1041(VarCurr)
    <=> ( v67(VarCurr)
        | v997(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_100,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1036(VarNext)
      <=> ( v1038(VarNext)
          & v125(VarNext) ) ) ) ).

fof(writeUnaryOperator_34,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v1038(VarNext)
      <=> v990(VarNext) ) ) ).

fof(addAssignmentInitValueVector_17,axiom,
    ! [B] :
      ( range_4_0(B)
     => ( v1012(constB0,B)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_9,axiom,
    ! [VarCurr] :
      ( ( ~ v1025(VarCurr)
        & ~ v1028(VarCurr) )
     => ! [B] :
          ( range_4_0(B)
         => ( v1015(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_14,axiom,
    ! [VarCurr] :
      ( v1028(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v1015(VarCurr,B)
          <=> v1017(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_12,axiom,
    ! [VarCurr] :
      ( v1025(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v1015(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_99,axiom,
    ! [VarCurr] :
      ( v1028(VarCurr)
    <=> ( v1029(VarCurr)
        | v1032(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_74,axiom,
    ! [VarCurr] :
      ( v1032(VarCurr)
    <=> ( ( v718(VarCurr,bitIndex2)
        <=> $true )
        & ( v718(VarCurr,bitIndex1)
        <=> $false )
        & ( v718(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_98,axiom,
    ! [VarCurr] :
      ( v1029(VarCurr)
    <=> ( v1030(VarCurr)
        | v1031(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_73,axiom,
    ! [VarCurr] :
      ( v1031(VarCurr)
    <=> ( ( v718(VarCurr,bitIndex2)
        <=> $false )
        & ( v718(VarCurr,bitIndex1)
        <=> $true )
        & ( v718(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_72,axiom,
    ! [VarCurr] :
      ( v1030(VarCurr)
    <=> ( ( v718(VarCurr,bitIndex2)
        <=> $false )
        & ( v718(VarCurr,bitIndex1)
        <=> $false )
        & ( v718(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_97,axiom,
    ! [VarCurr] :
      ( v1025(VarCurr)
    <=> ( v1026(VarCurr)
        | v1027(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_71,axiom,
    ! [VarCurr] :
      ( v1027(VarCurr)
    <=> ( ( v718(VarCurr,bitIndex2)
        <=> $true )
        & ( v718(VarCurr,bitIndex1)
        <=> $false )
        & ( v718(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_70,axiom,
    ! [VarCurr] :
      ( v1026(VarCurr)
    <=> ( ( v718(VarCurr,bitIndex2)
        <=> $false )
        & ( v718(VarCurr,bitIndex1)
        <=> $true )
        & ( v718(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_252,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v1017(VarCurr,B)
      <=> v1019(VarCurr,B) ) ) ).

fof(addAssignment_251,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v1019(VarCurr,B)
      <=> v1021(VarCurr,B) ) ) ).

fof(addAssignment_250,axiom,
    ! [VarCurr] :
      ( ( v1021(VarCurr,bitIndex4)
      <=> v1023(VarCurr,bitIndex19) )
      & ( v1021(VarCurr,bitIndex3)
      <=> v1023(VarCurr,bitIndex18) )
      & ( v1021(VarCurr,bitIndex2)
      <=> v1023(VarCurr,bitIndex17) )
      & ( v1021(VarCurr,bitIndex1)
      <=> v1023(VarCurr,bitIndex16) )
      & ( v1021(VarCurr,bitIndex0)
      <=> v1023(VarCurr,bitIndex15) ) ) ).

fof(addAssignmentInitValueVector_16,axiom,
    ( ( v1023(constB0,bitIndex19)
    <=> $false )
    & ( v1023(constB0,bitIndex18)
    <=> $false )
    & ( v1023(constB0,bitIndex17)
    <=> $false )
    & ( v1023(constB0,bitIndex16)
    <=> $false )
    & ( v1023(constB0,bitIndex15)
    <=> $false ) ) ).

fof(bitBlastConstant_179,axiom,
    ~ b00000(bitIndex4) ).

fof(bitBlastConstant_178,axiom,
    ~ b00000(bitIndex3) ).

fof(bitBlastConstant_177,axiom,
    ~ b00000(bitIndex2) ).

fof(bitBlastConstant_176,axiom,
    ~ b00000(bitIndex1) ).

fof(bitBlastConstant_175,axiom,
    ~ b00000(bitIndex0) ).

fof(addCaseBooleanConditionEqualRanges1_13,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v986(VarNext)
       => ! [B] :
            ( range_2_0(B)
           => ( v983(VarNext,B)
            <=> v983(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_13,axiom,
    ! [VarNext] :
      ( v986(VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v983(VarNext,B)
          <=> v1000(VarNext,B) ) ) ) ).

fof(addAssignment_249,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v1000(VarNext,B)
          <=> v998(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_24,axiom,
    ! [VarCurr] :
      ( ~ v997(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v998(VarCurr,B)
          <=> v718(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_24,axiom,
    ! [VarCurr] :
      ( v997(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v998(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_96,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v986(VarNext)
      <=> ( v987(VarNext)
          & v996(VarNext) ) ) ) ).

fof(addAssignment_248,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v996(VarNext)
      <=> v994(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_95,axiom,
    ! [VarCurr] :
      ( v994(VarCurr)
    <=> ( v67(VarCurr)
        | v997(VarCurr) ) ) ).

fof(writeUnaryOperator_33,axiom,
    ! [VarCurr] :
      ( ~ v997(VarCurr)
    <=> v51(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_94,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v987(VarNext)
      <=> ( v988(VarNext)
          & v125(VarNext) ) ) ) ).

fof(writeUnaryOperator_32,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v988(VarNext)
      <=> v990(VarNext) ) ) ).

fof(addAssignment_247,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v990(VarNext)
      <=> v125(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_15,axiom,
    ! [B] :
      ( range_2_0(B)
     => ( v983(constB0,B)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_8,axiom,
    ! [VarCurr] :
      ( ( ~ v109(VarCurr)
        & ~ v110(VarCurr) )
     => ( v716(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_13,axiom,
    ! [VarCurr] :
      ( v110(VarCurr)
     => ( v716(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_11,axiom,
    ! [VarCurr] :
      ( v109(VarCurr)
     => ( v716(VarCurr)
      <=> v959(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_12,axiom,
    ! [VarCurr] :
      ( ~ v960(VarCurr)
     => ( v959(VarCurr)
      <=> v962(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_10,axiom,
    ! [VarCurr] :
      ( v960(VarCurr)
     => ( v959(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_11,axiom,
    ! [VarCurr] :
      ( ~ v963(VarCurr)
     => ( v962(VarCurr)
      <=> v967(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_9,axiom,
    ! [VarCurr] :
      ( v963(VarCurr)
     => ( v962(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_7,axiom,
    ! [VarCurr] :
      ( ( ~ v968(VarCurr)
        & ~ v973(VarCurr) )
     => ( v967(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_10,axiom,
    ! [VarCurr] :
      ( v973(VarCurr)
     => ( v967(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_8,axiom,
    ! [VarCurr] :
      ( v968(VarCurr)
     => ( v967(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_93,axiom,
    ! [VarCurr] :
      ( v973(VarCurr)
    <=> ( v974(VarCurr)
        | v975(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_69,axiom,
    ! [VarCurr] :
      ( v975(VarCurr)
    <=> ( ( v718(VarCurr,bitIndex2)
        <=> $false )
        & ( v718(VarCurr,bitIndex1)
        <=> $true )
        & ( v718(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_68,axiom,
    ! [VarCurr] :
      ( v974(VarCurr)
    <=> ( ( v718(VarCurr,bitIndex2)
        <=> $false )
        & ( v718(VarCurr,bitIndex1)
        <=> $false )
        & ( v718(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_92,axiom,
    ! [VarCurr] :
      ( v968(VarCurr)
    <=> ( v969(VarCurr)
        | v972(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_67,axiom,
    ! [VarCurr] :
      ( v972(VarCurr)
    <=> ( ( v718(VarCurr,bitIndex2)
        <=> $true )
        & ( v718(VarCurr,bitIndex1)
        <=> $false )
        & ( v718(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_91,axiom,
    ! [VarCurr] :
      ( v969(VarCurr)
    <=> ( v970(VarCurr)
        | v971(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_66,axiom,
    ! [VarCurr] :
      ( v971(VarCurr)
    <=> ( ( v718(VarCurr,bitIndex2)
        <=> $false )
        & ( v718(VarCurr,bitIndex1)
        <=> $true )
        & ( v718(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_65,axiom,
    ! [VarCurr] :
      ( v970(VarCurr)
    <=> ( ( v718(VarCurr,bitIndex2)
        <=> $true )
        & ( v718(VarCurr,bitIndex1)
        <=> $false )
        & ( v718(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_64,axiom,
    ! [VarCurr] :
      ( v965(VarCurr)
    <=> ( v966(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_90,axiom,
    ! [VarCurr] :
      ( v966(VarCurr)
    <=> ( v65(VarCurr)
        | v495(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_63,axiom,
    ! [VarCurr] :
      ( v963(VarCurr)
    <=> ( v964(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_89,axiom,
    ! [VarCurr] :
      ( v964(VarCurr)
    <=> ( v65(VarCurr)
        | v495(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_14,axiom,
    ( v65(constB0)
  <=> $false ) ).

fof(addBitVectorEqualityBitBlasted_62,axiom,
    ! [VarCurr] :
      ( v961(VarCurr)
    <=> ( v74(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_61,axiom,
    ! [VarCurr] :
      ( v960(VarCurr)
    <=> ( v74(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4,axiom,
    ! [VarCurr] :
      ( ( ~ v932(VarCurr)
        & ~ v951(VarCurr)
        & ~ v952(VarCurr)
        & ~ v957(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v718(VarCurr,B)
          <=> $true ) ) ) ).

fof(bitBlastConstant_174,axiom,
    b111(bitIndex2) ).

fof(bitBlastConstant_173,axiom,
    b111(bitIndex1) ).

fof(bitBlastConstant_172,axiom,
    b111(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges3_3,axiom,
    ! [VarCurr] :
      ( v957(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v718(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(bitBlastConstant_171,axiom,
    ~ b010(bitIndex2) ).

fof(bitBlastConstant_170,axiom,
    b010(bitIndex1) ).

fof(bitBlastConstant_169,axiom,
    ~ b010(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges2_6,axiom,
    ! [VarCurr] :
      ( v952(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v718(VarCurr,B)
          <=> v955(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_9,axiom,
    ! [VarCurr] :
      ( v951(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v718(VarCurr,B)
          <=> b100(B) ) ) ) ).

fof(bitBlastConstant_168,axiom,
    b100(bitIndex2) ).

fof(bitBlastConstant_167,axiom,
    ~ b100(bitIndex1) ).

fof(bitBlastConstant_166,axiom,
    ~ b100(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges0_7,axiom,
    ! [VarCurr] :
      ( v932(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v718(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(bitBlastConstant_165,axiom,
    ~ b011(bitIndex2) ).

fof(bitBlastConstant_164,axiom,
    b011(bitIndex1) ).

fof(bitBlastConstant_163,axiom,
    b011(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_60,axiom,
    ! [VarCurr] :
      ( v957(VarCurr)
    <=> ( ( v720(VarCurr,bitIndex6)
        <=> $true )
        & ( v720(VarCurr,bitIndex5)
        <=> $false )
        & ( v720(VarCurr,bitIndex4)
        <=> $false )
        & ( v720(VarCurr,bitIndex3)
        <=> $true )
        & ( v720(VarCurr,bitIndex2)
        <=> $false )
        & ( v720(VarCurr,bitIndex1)
        <=> $true )
        & ( v720(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_162,axiom,
    b1001010(bitIndex6) ).

fof(bitBlastConstant_161,axiom,
    ~ b1001010(bitIndex5) ).

fof(bitBlastConstant_160,axiom,
    ~ b1001010(bitIndex4) ).

fof(bitBlastConstant_159,axiom,
    b1001010(bitIndex3) ).

fof(bitBlastConstant_158,axiom,
    ~ b1001010(bitIndex2) ).

fof(bitBlastConstant_157,axiom,
    b1001010(bitIndex1) ).

fof(bitBlastConstant_156,axiom,
    ~ b1001010(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges1_8,axiom,
    ! [VarCurr] :
      ( ~ v956(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v955(VarCurr,B)
          <=> b001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_6,axiom,
    ! [VarCurr] :
      ( v956(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v955(VarCurr,B)
          <=> b101(B) ) ) ) ).

fof(bitBlastConstant_155,axiom,
    b101(bitIndex2) ).

fof(bitBlastConstant_154,axiom,
    ~ b101(bitIndex1) ).

fof(bitBlastConstant_153,axiom,
    b101(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_59,axiom,
    ! [VarCurr] :
      ( v956(VarCurr)
    <=> ( ( v845(VarCurr,bitIndex2)
        <=> $false )
        & ( v845(VarCurr,bitIndex1)
        <=> $false )
        & ( v845(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_152,axiom,
    ~ b001(bitIndex2) ).

fof(bitBlastConstant_151,axiom,
    ~ b001(bitIndex1) ).

fof(bitBlastConstant_150,axiom,
    b001(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_88,axiom,
    ! [VarCurr] :
      ( v952(VarCurr)
    <=> ( v953(VarCurr)
        | v954(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_58,axiom,
    ! [VarCurr] :
      ( v954(VarCurr)
    <=> ( ( v720(VarCurr,bitIndex6)
        <=> $false )
        & ( v720(VarCurr,bitIndex5)
        <=> $false )
        & ( v720(VarCurr,bitIndex4)
        <=> $false )
        & ( v720(VarCurr,bitIndex3)
        <=> $true )
        & ( v720(VarCurr,bitIndex2)
        <=> $false )
        & ( v720(VarCurr,bitIndex1)
        <=> $true )
        & ( v720(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_149,axiom,
    ~ b0001011(bitIndex6) ).

fof(bitBlastConstant_148,axiom,
    ~ b0001011(bitIndex5) ).

fof(bitBlastConstant_147,axiom,
    ~ b0001011(bitIndex4) ).

fof(bitBlastConstant_146,axiom,
    b0001011(bitIndex3) ).

fof(bitBlastConstant_145,axiom,
    ~ b0001011(bitIndex2) ).

fof(bitBlastConstant_144,axiom,
    b0001011(bitIndex1) ).

fof(bitBlastConstant_143,axiom,
    b0001011(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_57,axiom,
    ! [VarCurr] :
      ( v953(VarCurr)
    <=> ( ( v720(VarCurr,bitIndex6)
        <=> $false )
        & ( v720(VarCurr,bitIndex5)
        <=> $false )
        & ( v720(VarCurr,bitIndex4)
        <=> $false )
        & ( v720(VarCurr,bitIndex3)
        <=> $true )
        & ( v720(VarCurr,bitIndex2)
        <=> $false )
        & ( v720(VarCurr,bitIndex1)
        <=> $true )
        & ( v720(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_142,axiom,
    ~ b0001010(bitIndex6) ).

fof(bitBlastConstant_141,axiom,
    ~ b0001010(bitIndex5) ).

fof(bitBlastConstant_140,axiom,
    ~ b0001010(bitIndex4) ).

fof(bitBlastConstant_139,axiom,
    b0001010(bitIndex3) ).

fof(bitBlastConstant_138,axiom,
    ~ b0001010(bitIndex2) ).

fof(bitBlastConstant_137,axiom,
    b0001010(bitIndex1) ).

fof(bitBlastConstant_136,axiom,
    ~ b0001010(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_56,axiom,
    ! [VarCurr] :
      ( v951(VarCurr)
    <=> ( ( v720(VarCurr,bitIndex6)
        <=> $true )
        & ( v720(VarCurr,bitIndex5)
        <=> $true )
        & ( v720(VarCurr,bitIndex4)
        <=> $true )
        & ( v720(VarCurr,bitIndex3)
        <=> $true )
        & ( v720(VarCurr,bitIndex2)
        <=> $false )
        & ( v720(VarCurr,bitIndex1)
        <=> $true )
        & ( v720(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_135,axiom,
    b1111010(bitIndex6) ).

fof(bitBlastConstant_134,axiom,
    b1111010(bitIndex5) ).

fof(bitBlastConstant_133,axiom,
    b1111010(bitIndex4) ).

fof(bitBlastConstant_132,axiom,
    b1111010(bitIndex3) ).

fof(bitBlastConstant_131,axiom,
    ~ b1111010(bitIndex2) ).

fof(bitBlastConstant_130,axiom,
    b1111010(bitIndex1) ).

fof(bitBlastConstant_129,axiom,
    ~ b1111010(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_87,axiom,
    ! [VarCurr] :
      ( v932(VarCurr)
    <=> ( v933(VarCurr)
        | v950(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_55,axiom,
    ! [VarCurr] :
      ( v950(VarCurr)
    <=> ( ( v720(VarCurr,bitIndex6)
        <=> $true )
        & ( v720(VarCurr,bitIndex5)
        <=> $false )
        & ( v720(VarCurr,bitIndex4)
        <=> $false )
        & ( v720(VarCurr,bitIndex3)
        <=> $false )
        & ( v720(VarCurr,bitIndex2)
        <=> $true )
        & ( v720(VarCurr,bitIndex1)
        <=> $false )
        & ( v720(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_128,axiom,
    b1000101(bitIndex6) ).

fof(bitBlastConstant_127,axiom,
    ~ b1000101(bitIndex5) ).

fof(bitBlastConstant_126,axiom,
    ~ b1000101(bitIndex4) ).

fof(bitBlastConstant_125,axiom,
    ~ b1000101(bitIndex3) ).

fof(bitBlastConstant_124,axiom,
    b1000101(bitIndex2) ).

fof(bitBlastConstant_123,axiom,
    ~ b1000101(bitIndex1) ).

fof(bitBlastConstant_122,axiom,
    b1000101(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_86,axiom,
    ! [VarCurr] :
      ( v933(VarCurr)
    <=> ( v934(VarCurr)
        | v949(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_54,axiom,
    ! [VarCurr] :
      ( v949(VarCurr)
    <=> ( ( v720(VarCurr,bitIndex6)
        <=> $true )
        & ( v720(VarCurr,bitIndex5)
        <=> $false )
        & ( v720(VarCurr,bitIndex4)
        <=> $false )
        & ( v720(VarCurr,bitIndex3)
        <=> $false )
        & ( v720(VarCurr,bitIndex2)
        <=> $true )
        & ( v720(VarCurr,bitIndex1)
        <=> $false )
        & ( v720(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_121,axiom,
    b1000100(bitIndex6) ).

fof(bitBlastConstant_120,axiom,
    ~ b1000100(bitIndex5) ).

fof(bitBlastConstant_119,axiom,
    ~ b1000100(bitIndex4) ).

fof(bitBlastConstant_118,axiom,
    ~ b1000100(bitIndex3) ).

fof(bitBlastConstant_117,axiom,
    b1000100(bitIndex2) ).

fof(bitBlastConstant_116,axiom,
    ~ b1000100(bitIndex1) ).

fof(bitBlastConstant_115,axiom,
    ~ b1000100(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_85,axiom,
    ! [VarCurr] :
      ( v934(VarCurr)
    <=> ( v935(VarCurr)
        | v948(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_53,axiom,
    ! [VarCurr] :
      ( v948(VarCurr)
    <=> ( ( v720(VarCurr,bitIndex6)
        <=> $true )
        & ( v720(VarCurr,bitIndex5)
        <=> $false )
        & ( v720(VarCurr,bitIndex4)
        <=> $false )
        & ( v720(VarCurr,bitIndex3)
        <=> $false )
        & ( v720(VarCurr,bitIndex2)
        <=> $false )
        & ( v720(VarCurr,bitIndex1)
        <=> $true )
        & ( v720(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_114,axiom,
    b1000010(bitIndex6) ).

fof(bitBlastConstant_113,axiom,
    ~ b1000010(bitIndex5) ).

fof(bitBlastConstant_112,axiom,
    ~ b1000010(bitIndex4) ).

fof(bitBlastConstant_111,axiom,
    ~ b1000010(bitIndex3) ).

fof(bitBlastConstant_110,axiom,
    ~ b1000010(bitIndex2) ).

fof(bitBlastConstant_109,axiom,
    b1000010(bitIndex1) ).

fof(bitBlastConstant_108,axiom,
    ~ b1000010(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_84,axiom,
    ! [VarCurr] :
      ( v935(VarCurr)
    <=> ( v936(VarCurr)
        | v947(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_52,axiom,
    ! [VarCurr] :
      ( v947(VarCurr)
    <=> ( ( v720(VarCurr,bitIndex6)
        <=> $true )
        & ( v720(VarCurr,bitIndex5)
        <=> $true )
        & ( v720(VarCurr,bitIndex4)
        <=> $false )
        & ( v720(VarCurr,bitIndex3)
        <=> $false )
        & ( v720(VarCurr,bitIndex2)
        <=> $false )
        & ( v720(VarCurr,bitIndex1)
        <=> $false )
        & ( v720(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_107,axiom,
    b1100000(bitIndex6) ).

fof(bitBlastConstant_106,axiom,
    b1100000(bitIndex5) ).

fof(bitBlastConstant_105,axiom,
    ~ b1100000(bitIndex4) ).

fof(bitBlastConstant_104,axiom,
    ~ b1100000(bitIndex3) ).

fof(bitBlastConstant_103,axiom,
    ~ b1100000(bitIndex2) ).

fof(bitBlastConstant_102,axiom,
    ~ b1100000(bitIndex1) ).

fof(bitBlastConstant_101,axiom,
    ~ b1100000(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_83,axiom,
    ! [VarCurr] :
      ( v936(VarCurr)
    <=> ( v937(VarCurr)
        | v946(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_51,axiom,
    ! [VarCurr] :
      ( v946(VarCurr)
    <=> ( ( v720(VarCurr,bitIndex6)
        <=> $true )
        & ( v720(VarCurr,bitIndex5)
        <=> $false )
        & ( v720(VarCurr,bitIndex4)
        <=> $false )
        & ( v720(VarCurr,bitIndex3)
        <=> $false )
        & ( v720(VarCurr,bitIndex2)
        <=> $false )
        & ( v720(VarCurr,bitIndex1)
        <=> $false )
        & ( v720(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_100,axiom,
    b1000000(bitIndex6) ).

fof(bitBlastConstant_99,axiom,
    ~ b1000000(bitIndex5) ).

fof(bitBlastConstant_98,axiom,
    ~ b1000000(bitIndex4) ).

fof(bitBlastConstant_97,axiom,
    ~ b1000000(bitIndex3) ).

fof(bitBlastConstant_96,axiom,
    ~ b1000000(bitIndex2) ).

fof(bitBlastConstant_95,axiom,
    ~ b1000000(bitIndex1) ).

fof(bitBlastConstant_94,axiom,
    ~ b1000000(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_82,axiom,
    ! [VarCurr] :
      ( v937(VarCurr)
    <=> ( v938(VarCurr)
        | v945(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_50,axiom,
    ! [VarCurr] :
      ( v945(VarCurr)
    <=> ( ( v720(VarCurr,bitIndex6)
        <=> $false )
        & ( v720(VarCurr,bitIndex5)
        <=> $false )
        & ( v720(VarCurr,bitIndex4)
        <=> $false )
        & ( v720(VarCurr,bitIndex3)
        <=> $false )
        & ( v720(VarCurr,bitIndex2)
        <=> $true )
        & ( v720(VarCurr,bitIndex1)
        <=> $false )
        & ( v720(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_93,axiom,
    ~ b0000101(bitIndex6) ).

fof(bitBlastConstant_92,axiom,
    ~ b0000101(bitIndex5) ).

fof(bitBlastConstant_91,axiom,
    ~ b0000101(bitIndex4) ).

fof(bitBlastConstant_90,axiom,
    ~ b0000101(bitIndex3) ).

fof(bitBlastConstant_89,axiom,
    b0000101(bitIndex2) ).

fof(bitBlastConstant_88,axiom,
    ~ b0000101(bitIndex1) ).

fof(bitBlastConstant_87,axiom,
    b0000101(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_81,axiom,
    ! [VarCurr] :
      ( v938(VarCurr)
    <=> ( v939(VarCurr)
        | v944(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_49,axiom,
    ! [VarCurr] :
      ( v944(VarCurr)
    <=> ( ( v720(VarCurr,bitIndex6)
        <=> $false )
        & ( v720(VarCurr,bitIndex5)
        <=> $false )
        & ( v720(VarCurr,bitIndex4)
        <=> $false )
        & ( v720(VarCurr,bitIndex3)
        <=> $false )
        & ( v720(VarCurr,bitIndex2)
        <=> $true )
        & ( v720(VarCurr,bitIndex1)
        <=> $false )
        & ( v720(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_86,axiom,
    ~ b0000100(bitIndex6) ).

fof(bitBlastConstant_85,axiom,
    ~ b0000100(bitIndex5) ).

fof(bitBlastConstant_84,axiom,
    ~ b0000100(bitIndex4) ).

fof(bitBlastConstant_83,axiom,
    ~ b0000100(bitIndex3) ).

fof(bitBlastConstant_82,axiom,
    b0000100(bitIndex2) ).

fof(bitBlastConstant_81,axiom,
    ~ b0000100(bitIndex1) ).

fof(bitBlastConstant_80,axiom,
    ~ b0000100(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_80,axiom,
    ! [VarCurr] :
      ( v939(VarCurr)
    <=> ( v940(VarCurr)
        | v943(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_48,axiom,
    ! [VarCurr] :
      ( v943(VarCurr)
    <=> ( ( v720(VarCurr,bitIndex6)
        <=> $false )
        & ( v720(VarCurr,bitIndex5)
        <=> $false )
        & ( v720(VarCurr,bitIndex4)
        <=> $false )
        & ( v720(VarCurr,bitIndex3)
        <=> $false )
        & ( v720(VarCurr,bitIndex2)
        <=> $false )
        & ( v720(VarCurr,bitIndex1)
        <=> $true )
        & ( v720(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_79,axiom,
    ~ b0000010(bitIndex6) ).

fof(bitBlastConstant_78,axiom,
    ~ b0000010(bitIndex5) ).

fof(bitBlastConstant_77,axiom,
    ~ b0000010(bitIndex4) ).

fof(bitBlastConstant_76,axiom,
    ~ b0000010(bitIndex3) ).

fof(bitBlastConstant_75,axiom,
    ~ b0000010(bitIndex2) ).

fof(bitBlastConstant_74,axiom,
    b0000010(bitIndex1) ).

fof(bitBlastConstant_73,axiom,
    ~ b0000010(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_79,axiom,
    ! [VarCurr] :
      ( v940(VarCurr)
    <=> ( v941(VarCurr)
        | v942(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_47,axiom,
    ! [VarCurr] :
      ( v942(VarCurr)
    <=> ( ( v720(VarCurr,bitIndex6)
        <=> $false )
        & ( v720(VarCurr,bitIndex5)
        <=> $true )
        & ( v720(VarCurr,bitIndex4)
        <=> $false )
        & ( v720(VarCurr,bitIndex3)
        <=> $false )
        & ( v720(VarCurr,bitIndex2)
        <=> $false )
        & ( v720(VarCurr,bitIndex1)
        <=> $false )
        & ( v720(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_72,axiom,
    ~ b0100000(bitIndex6) ).

fof(bitBlastConstant_71,axiom,
    b0100000(bitIndex5) ).

fof(bitBlastConstant_70,axiom,
    ~ b0100000(bitIndex4) ).

fof(bitBlastConstant_69,axiom,
    ~ b0100000(bitIndex3) ).

fof(bitBlastConstant_68,axiom,
    ~ b0100000(bitIndex2) ).

fof(bitBlastConstant_67,axiom,
    ~ b0100000(bitIndex1) ).

fof(bitBlastConstant_66,axiom,
    ~ b0100000(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_46,axiom,
    ! [VarCurr] :
      ( v941(VarCurr)
    <=> ( ( v720(VarCurr,bitIndex6)
        <=> $false )
        & ( v720(VarCurr,bitIndex5)
        <=> $false )
        & ( v720(VarCurr,bitIndex4)
        <=> $false )
        & ( v720(VarCurr,bitIndex3)
        <=> $false )
        & ( v720(VarCurr,bitIndex2)
        <=> $false )
        & ( v720(VarCurr,bitIndex1)
        <=> $false )
        & ( v720(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_246,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v845(VarCurr,B)
      <=> v847(VarCurr,B) ) ) ).

fof(addAssignment_245,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v847(VarCurr,B)
      <=> v849(VarCurr,B) ) ) ).

fof(addAssignment_244,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v849(VarCurr,B)
      <=> v851(VarCurr,B) ) ) ).

fof(addAssignment_243,axiom,
    ! [VarCurr] :
      ( ( v851(VarCurr,bitIndex2)
      <=> v853(VarCurr,bitIndex26) )
      & ( v851(VarCurr,bitIndex1)
      <=> v853(VarCurr,bitIndex25) )
      & ( v851(VarCurr,bitIndex0)
      <=> v853(VarCurr,bitIndex24) ) ) ).

fof(addAssignment_242,axiom,
    ! [VarNext] :
      ( ( v853(VarNext,bitIndex26)
      <=> v895(VarNext,bitIndex2) )
      & ( v853(VarNext,bitIndex25)
      <=> v895(VarNext,bitIndex1) )
      & ( v853(VarNext,bitIndex24)
      <=> v895(VarNext,bitIndex0) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v896(VarNext)
       => ( ( v895(VarNext,bitIndex7)
          <=> v853(VarCurr,bitIndex31) )
          & ( v895(VarNext,bitIndex6)
          <=> v853(VarCurr,bitIndex30) )
          & ( v895(VarNext,bitIndex5)
          <=> v853(VarCurr,bitIndex29) )
          & ( v895(VarNext,bitIndex4)
          <=> v853(VarCurr,bitIndex28) )
          & ( v895(VarNext,bitIndex3)
          <=> v853(VarCurr,bitIndex27) )
          & ( v895(VarNext,bitIndex2)
          <=> v853(VarCurr,bitIndex26) )
          & ( v895(VarNext,bitIndex1)
          <=> v853(VarCurr,bitIndex25) )
          & ( v895(VarNext,bitIndex0)
          <=> v853(VarCurr,bitIndex24) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_12,axiom,
    ! [VarNext] :
      ( v896(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v895(VarNext,B)
          <=> v923(VarNext,B) ) ) ) ).

fof(addAssignment_241,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v923(VarNext,B)
          <=> v921(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_7,axiom,
    ! [VarCurr] :
      ( ~ v906(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v921(VarCurr,B)
          <=> v924(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5,axiom,
    ! [VarCurr] :
      ( v906(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v921(VarCurr,B)
          <=> $false ) ) ) ).

fof(bitBlastConstant_65,axiom,
    ~ b00000000(bitIndex7) ).

fof(bitBlastConstant_64,axiom,
    ~ b00000000(bitIndex6) ).

fof(bitBlastConstant_63,axiom,
    ~ b00000000(bitIndex5) ).

fof(bitBlastConstant_62,axiom,
    ~ b00000000(bitIndex4) ).

fof(bitBlastConstant_61,axiom,
    ~ b00000000(bitIndex3) ).

fof(bitBlastConstant_60,axiom,
    ~ b00000000(bitIndex2) ).

fof(bitBlastConstant_59,axiom,
    ~ b00000000(bitIndex1) ).

fof(bitBlastConstant_58,axiom,
    ~ b00000000(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges2_5,axiom,
    ! [VarCurr] :
      ( ( ~ v910(VarCurr)
        & ~ v912(VarCurr) )
     => ! [B] :
          ( range_7_0(B)
         => ( v924(VarCurr,B)
          <=> v888(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_6,axiom,
    ! [VarCurr] :
      ( v912(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v924(VarCurr,B)
          <=> v855(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_1,axiom,
    ! [VarCurr] :
      ( v910(VarCurr)
     => ( ( v924(VarCurr,bitIndex7)
        <=> v853(VarCurr,bitIndex23) )
        & ( v924(VarCurr,bitIndex6)
        <=> v853(VarCurr,bitIndex22) )
        & ( v924(VarCurr,bitIndex5)
        <=> v853(VarCurr,bitIndex21) )
        & ( v924(VarCurr,bitIndex4)
        <=> v853(VarCurr,bitIndex20) )
        & ( v924(VarCurr,bitIndex3)
        <=> v853(VarCurr,bitIndex19) )
        & ( v924(VarCurr,bitIndex2)
        <=> v853(VarCurr,bitIndex18) )
        & ( v924(VarCurr,bitIndex1)
        <=> v853(VarCurr,bitIndex17) )
        & ( v924(VarCurr,bitIndex0)
        <=> v853(VarCurr,bitIndex16) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_78,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v896(VarNext)
      <=> ( v897(VarNext)
          & v904(VarNext) ) ) ) ).

fof(addAssignment_240,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v904(VarNext)
      <=> v902(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_77,axiom,
    ! [VarCurr] :
      ( v902(VarCurr)
    <=> ( v905(VarCurr)
        & v917(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_76,axiom,
    ! [VarCurr] :
      ( v917(VarCurr)
    <=> ( v918(VarCurr)
        | v906(VarCurr) ) ) ).

fof(writeUnaryOperator_31,axiom,
    ! [VarCurr] :
      ( ~ v918(VarCurr)
    <=> v919(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_45,axiom,
    ! [VarCurr] :
      ( v919(VarCurr)
    <=> ( ( v920(VarCurr,bitIndex1)
        <=> $false )
        & ( v920(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_239,axiom,
    ! [VarCurr] :
      ( v920(VarCurr,bitIndex0)
    <=> v212(VarCurr) ) ).

fof(addAssignment_238,axiom,
    ! [VarCurr] :
      ( v920(VarCurr,bitIndex1)
    <=> v210(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_75,axiom,
    ! [VarCurr] :
      ( v905(VarCurr)
    <=> ( v906(VarCurr)
        | v907(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_74,axiom,
    ! [VarCurr] :
      ( v907(VarCurr)
    <=> ( v908(VarCurr)
        & v916(VarCurr) ) ) ).

fof(writeUnaryOperator_30,axiom,
    ! [VarCurr] :
      ( ~ v916(VarCurr)
    <=> v906(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_73,axiom,
    ! [VarCurr] :
      ( v908(VarCurr)
    <=> ( v909(VarCurr)
        | v914(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_44,axiom,
    ! [VarCurr] :
      ( v914(VarCurr)
    <=> ( ( v915(VarCurr,bitIndex1)
        <=> $true )
        & ( v915(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_237,axiom,
    ! [VarCurr] :
      ( v915(VarCurr,bitIndex0)
    <=> v212(VarCurr) ) ).

fof(addAssignment_236,axiom,
    ! [VarCurr] :
      ( v915(VarCurr,bitIndex1)
    <=> v210(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_72,axiom,
    ! [VarCurr] :
      ( v909(VarCurr)
    <=> ( v910(VarCurr)
        | v912(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_43,axiom,
    ! [VarCurr] :
      ( v912(VarCurr)
    <=> ( ( v913(VarCurr,bitIndex1)
        <=> $true )
        & ( v913(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_235,axiom,
    ! [VarCurr] :
      ( v913(VarCurr,bitIndex0)
    <=> v212(VarCurr) ) ).

fof(addAssignment_234,axiom,
    ! [VarCurr] :
      ( v913(VarCurr,bitIndex1)
    <=> v210(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_42,axiom,
    ! [VarCurr] :
      ( v910(VarCurr)
    <=> ( ( v911(VarCurr,bitIndex1)
        <=> $false )
        & ( v911(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_233,axiom,
    ! [VarCurr] :
      ( v911(VarCurr,bitIndex0)
    <=> v212(VarCurr) ) ).

fof(addAssignment_232,axiom,
    ! [VarCurr] :
      ( v911(VarCurr,bitIndex1)
    <=> v210(VarCurr) ) ).

fof(writeUnaryOperator_29,axiom,
    ! [VarCurr] :
      ( ~ v906(VarCurr)
    <=> v208(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_71,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v897(VarNext)
      <=> ( v898(VarNext)
          & v223(VarNext) ) ) ) ).

fof(writeUnaryOperator_28,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v898(VarNext)
      <=> v230(VarNext) ) ) ).

fof(addAssignment_231,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v888(VarCurr,B)
      <=> v893(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_23,axiom,
    ! [VarCurr] :
      ( ~ v890(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v893(VarCurr,B)
          <=> v892(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_23,axiom,
    ! [VarCurr] :
      ( v890(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v893(VarCurr,B)
          <=> v877(VarCurr,B) ) ) ) ).

fof(addAssignment_230,axiom,
    ! [VarCurr] :
      ( ( v892(VarCurr,bitIndex2)
      <=> v853(VarCurr,bitIndex18) )
      & ( v892(VarCurr,bitIndex1)
      <=> v853(VarCurr,bitIndex17) )
      & ( v892(VarCurr,bitIndex0)
      <=> v853(VarCurr,bitIndex16) ) ) ).

fof(addAssignment_229,axiom,
    ! [VarCurr] :
      ( v890(VarCurr)
    <=> v859(VarCurr,bitIndex1) ) ).

fof(addAssignment_228,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v855(VarCurr,B)
      <=> v886(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_22,axiom,
    ! [VarCurr] :
      ( ~ v857(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v886(VarCurr,B)
          <=> v881(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_22,axiom,
    ! [VarCurr] :
      ( v857(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v886(VarCurr,B)
          <=> v877(VarCurr,B) ) ) ) ).

fof(range_axiom_10,axiom,
    ! [B] :
      ( range_7_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B ) ) ).

fof(addAssignment_227,axiom,
    ! [VarCurr] :
      ( ( v881(VarCurr,bitIndex2)
      <=> v853(VarCurr,bitIndex26) )
      & ( v881(VarCurr,bitIndex1)
      <=> v853(VarCurr,bitIndex25) )
      & ( v881(VarCurr,bitIndex0)
      <=> v853(VarCurr,bitIndex24) ) ) ).

fof(addAssignmentInitValue_28,axiom,
    ~ v853(constB0,bitIndex28) ).

fof(addAssignmentInitValue_27,axiom,
    ~ v853(constB0,bitIndex26) ).

fof(addAssignmentInitValue_26,axiom,
    ~ v853(constB0,bitIndex25) ).

fof(addAssignmentInitValue_25,axiom,
    ~ v853(constB0,bitIndex24) ).

fof(bitBlastConstant_57,axiom,
    ~ bxxx0x000(bitIndex4) ).

fof(bitBlastConstant_56,axiom,
    ~ bxxx0x000(bitIndex2) ).

fof(bitBlastConstant_55,axiom,
    ~ bxxx0x000(bitIndex1) ).

fof(bitBlastConstant_54,axiom,
    ~ bxxx0x000(bitIndex0) ).

fof(addAssignmentInitValue_24,axiom,
    ~ v853(constB0,bitIndex18) ).

fof(addAssignmentInitValue_23,axiom,
    ~ v853(constB0,bitIndex17) ).

fof(addAssignmentInitValue_22,axiom,
    ~ v853(constB0,bitIndex16) ).

fof(bitBlastConstant_53,axiom,
    ~ bxxxxx000(bitIndex2) ).

fof(bitBlastConstant_52,axiom,
    ~ bxxxxx000(bitIndex1) ).

fof(bitBlastConstant_51,axiom,
    ~ bxxxxx000(bitIndex0) ).

fof(addAssignment_226,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v877(VarCurr,B)
      <=> v879(VarCurr,B) ) ) ).

fof(range_axiom_9,axiom,
    ! [B] :
      ( range_2_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B ) ) ).

fof(addAssignment_225,axiom,
    ! [VarCurr] :
      ( ( v879(VarCurr,bitIndex2)
      <=> v755(VarCurr,bitIndex57) )
      & ( v879(VarCurr,bitIndex1)
      <=> v755(VarCurr,bitIndex56) )
      & ( v879(VarCurr,bitIndex0)
      <=> v755(VarCurr,bitIndex55) ) ) ).

fof(addAssignment_224,axiom,
    ! [VarCurr,B] :
      ( range_57_55(B)
     => ( v755(VarCurr,B)
      <=> v757(VarCurr,B) ) ) ).

fof(addAssignment_223,axiom,
    ! [VarCurr,B] :
      ( range_57_55(B)
     => ( v757(VarCurr,B)
      <=> v759(VarCurr,B) ) ) ).

fof(addAssignment_222,axiom,
    ! [VarCurr,B] :
      ( range_57_55(B)
     => ( v759(VarCurr,B)
      <=> v761(VarCurr,B) ) ) ).

fof(addAssignment_221,axiom,
    ! [VarCurr,B] :
      ( range_57_55(B)
     => ( v761(VarCurr,B)
      <=> v763(VarCurr,B) ) ) ).

fof(addAssignment_220,axiom,
    ! [VarCurr,B] :
      ( range_57_55(B)
     => ( v763(VarCurr,B)
      <=> v765(VarCurr,B) ) ) ).

fof(addAssignment_219,axiom,
    ! [VarCurr,B] :
      ( range_57_55(B)
     => ( v765(VarCurr,B)
      <=> v767(VarCurr,B) ) ) ).

fof(addAssignment_218,axiom,
    ! [VarCurr,B] :
      ( range_57_55(B)
     => ( v767(VarCurr,B)
      <=> v770(VarCurr,B) ) ) ).

fof(range_axiom_8,axiom,
    ! [B] :
      ( range_57_55(B)
    <=> ( $false
        | bitIndex55 = B
        | bitIndex56 = B
        | bitIndex57 = B ) ) ).

fof(addAssignment_217,axiom,
    ! [VarCurr] :
      ( v857(VarCurr)
    <=> v859(VarCurr,bitIndex1) ) ).

fof(addAssignment_216,axiom,
    ! [VarCurr] :
      ( v859(VarCurr,bitIndex1)
    <=> v860(VarCurr,bitIndex1) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_21,axiom,
    ! [VarCurr] :
      ( ~ v861(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v860(VarCurr,B)
          <=> v863(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_21,axiom,
    ! [VarCurr] :
      ( v861(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v860(VarCurr,B)
          <=> v862(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_2,axiom,
    ! [VarCurr] :
      ( ( ~ v864(VarCurr)
        & ~ v866(VarCurr)
        & ~ v870(VarCurr) )
     => ! [B] :
          ( range_6_0(B)
         => ( v863(VarCurr,B)
          <=> v218(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_4,axiom,
    ! [VarCurr] :
      ( v870(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v863(VarCurr,B)
          <=> v872(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5,axiom,
    ! [VarCurr] :
      ( v866(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v863(VarCurr,B)
          <=> v868(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_4,axiom,
    ! [VarCurr] :
      ( v864(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v863(VarCurr,B)
          <=> v218(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_41,axiom,
    ! [VarCurr] :
      ( v874(VarCurr)
    <=> ( ( v875(VarCurr,bitIndex1)
        <=> $true )
        & ( v875(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_215,axiom,
    ! [VarCurr] :
      ( v875(VarCurr,bitIndex0)
    <=> v212(VarCurr) ) ).

fof(addAssignment_214,axiom,
    ! [VarCurr] :
      ( v875(VarCurr,bitIndex1)
    <=> v210(VarCurr) ) ).

fof(addAssignment_213,axiom,
    ! [VarCurr] :
      ( v872(VarCurr,bitIndex0)
    <=> $false ) ).

fof(addAssignment_212,axiom,
    ! [VarCurr] :
      ( ( v872(VarCurr,bitIndex6)
      <=> v218(VarCurr,bitIndex5) )
      & ( v872(VarCurr,bitIndex5)
      <=> v218(VarCurr,bitIndex4) )
      & ( v872(VarCurr,bitIndex4)
      <=> v218(VarCurr,bitIndex3) )
      & ( v872(VarCurr,bitIndex3)
      <=> v218(VarCurr,bitIndex2) )
      & ( v872(VarCurr,bitIndex2)
      <=> v218(VarCurr,bitIndex1) )
      & ( v872(VarCurr,bitIndex1)
      <=> v218(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_40,axiom,
    ! [