%------------------------------------------------------------------------------
% File     : HWV102+1 : TPTP v9.2.0. Released v6.1.0.
% Domain   : Hardware Verification
% Problem  : dmu_dmc property 14 cone of influence 7_b20
% Version  : Especial.
% English  : Verification of a property of the SPARCT2 RTL hardware design.

% Refs     : [Kha14] Khasidashvili (2014), Email to Geoff Sutcliffe
% Source   : [Kha14]
% Names    : dmu_dmc_prop14_cone7_b20 [Kha14]

% Status   : Theorem
% Rating   : 1.00 v6.1.0
% Syntax   : Number of formulae    : 13076 (4200 unt;   0 def)
%            Number of atoms       : 43652 ( 969 equ)
%            Maximal formula atoms :  142 (   3 avg)
%            Number of connectives : 36036 (5460   ~;1622   |;7851   &)
%                                         (15628 <=>;5475  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   75 (   4 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of predicates  : 6496 (6493 usr;   2 prp; 0-3 aty)
%            Number of functors    : 1714 (1714 usr;1714 con; 0-0 aty)
%            Number of variables   : 12130 (12130   !;   0   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : Copyright 2013 Moshe Emmer and Zurab Khasidashvili
%            Licensed under the Apache License, Version 2.0 (the "License");
%            you may not use this file except in compliance with the License.
%            You may obtain a copy of the License at
%                http://www.apache.org/licenses/LICENSE-2.0
%            Unless required by applicable law or agreed to in writing,
%            software distributed under the License is distributed on an "AS
%            IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
%            express or implied. See the License for the specific language
%            governing permissions and limitations under the License.
%------------------------------------------------------------------------------
fof(pathAxiom_8,axiom,
    nextState(constB8,constB9) ).

fof(pathAxiom_7,axiom,
    nextState(constB7,constB8) ).

fof(pathAxiom_6,axiom,
    nextState(constB6,constB7) ).

fof(pathAxiom_5,axiom,
    nextState(constB5,constB6) ).

fof(pathAxiom_4,axiom,
    nextState(constB4,constB5) ).

fof(pathAxiom_3,axiom,
    nextState(constB3,constB4) ).

fof(pathAxiom_2,axiom,
    nextState(constB2,constB3) ).

fof(pathAxiom_1,axiom,
    nextState(constB1,constB2) ).

fof(pathAxiom,axiom,
    nextState(constB0,constB1) ).

fof(reachableStateAxiom_22,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( reachableState(VarCurr)
        & reachableState(VarNext) ) ) ).

fof(reachableStateAxiom_21,axiom,
    ! [VarState] :
      ( reachableState(VarState)
     => ( constB0 = VarState
        | constB1 = VarState
        | constB2 = VarState
        | constB3 = VarState
        | constB4 = VarState
        | constB5 = VarState
        | constB6 = VarState
        | constB7 = VarState
        | constB8 = VarState
        | constB9 = VarState
        | constB10 = VarState
        | constB11 = VarState
        | constB12 = VarState
        | constB13 = VarState
        | constB14 = VarState
        | constB15 = VarState
        | constB16 = VarState
        | constB17 = VarState
        | constB18 = VarState
        | constB19 = VarState
        | constB20 = VarState ) ) ).

fof(reachableStateAxiom_20,axiom,
    reachableState(constB20) ).

fof(reachableStateAxiom_19,axiom,
    reachableState(constB19) ).

fof(reachableStateAxiom_18,axiom,
    reachableState(constB18) ).

fof(reachableStateAxiom_17,axiom,
    reachableState(constB17) ).

fof(reachableStateAxiom_16,axiom,
    reachableState(constB16) ).

fof(reachableStateAxiom_15,axiom,
    reachableState(constB15) ).

fof(reachableStateAxiom_14,axiom,
    reachableState(constB14) ).

fof(reachableStateAxiom_13,axiom,
    reachableState(constB13) ).

fof(reachableStateAxiom_12,axiom,
    reachableState(constB12) ).

fof(reachableStateAxiom_11,axiom,
    reachableState(constB11) ).

fof(reachableStateAxiom_10,axiom,
    reachableState(constB10) ).

fof(reachableStateAxiom_9,axiom,
    reachableState(constB9) ).

fof(reachableStateAxiom_8,axiom,
    reachableState(constB8) ).

fof(reachableStateAxiom_7,axiom,
    reachableState(constB7) ).

fof(reachableStateAxiom_6,axiom,
    reachableState(constB6) ).

fof(reachableStateAxiom_5,axiom,
    reachableState(constB5) ).

fof(reachableStateAxiom_4,axiom,
    reachableState(constB4) ).

fof(reachableStateAxiom_3,axiom,
    reachableState(constB3) ).

fof(reachableStateAxiom_2,axiom,
    reachableState(constB2) ).

fof(reachableStateAxiom_1,axiom,
    reachableState(constB1) ).

fof(reachableStateAxiom,axiom,
    reachableState(constB0) ).

fof(clock_toggling,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1(VarCurr)
      <=> ~ v1(VarNext) ) ) ).

fof(clock_pattern,axiom,
    ~ v1(constB0) ).

fof(transient_address_definition_230,axiom,
    ! [B] :
      ( addressVal(v7748_range_4_to_0_address_term_bound_20,B)
    <=> v7748(constB20,B) ) ).

fof(is_address_299,axiom,
    address(v7748_range_4_to_0_address_term_bound_20) ).

fof(address_association_230,axiom,
    v7748_range_4_to_0_address_association(constB20,v7748_range_4_to_0_address_term_bound_20) ).

fof(transient_address_definition_229,axiom,
    ! [B] :
      ( addressVal(v7748_range_4_to_0_address_term_bound_19,B)
    <=> v7748(constB19,B) ) ).

fof(is_address_298,axiom,
    address(v7748_range_4_to_0_address_term_bound_19) ).

fof(address_association_229,axiom,
    v7748_range_4_to_0_address_association(constB19,v7748_range_4_to_0_address_term_bound_19) ).

fof(transient_address_definition_228,axiom,
    ! [B] :
      ( addressVal(v7748_range_4_to_0_address_term_bound_18,B)
    <=> v7748(constB18,B) ) ).

fof(is_address_297,axiom,
    address(v7748_range_4_to_0_address_term_bound_18) ).

fof(address_association_228,axiom,
    v7748_range_4_to_0_address_association(constB18,v7748_range_4_to_0_address_term_bound_18) ).

fof(transient_address_definition_227,axiom,
    ! [B] :
      ( addressVal(v7748_range_4_to_0_address_term_bound_17,B)
    <=> v7748(constB17,B) ) ).

fof(is_address_296,axiom,
    address(v7748_range_4_to_0_address_term_bound_17) ).

fof(address_association_227,axiom,
    v7748_range_4_to_0_address_association(constB17,v7748_range_4_to_0_address_term_bound_17) ).

fof(transient_address_definition_226,axiom,
    ! [B] :
      ( addressVal(v7748_range_4_to_0_address_term_bound_16,B)
    <=> v7748(constB16,B) ) ).

fof(is_address_295,axiom,
    address(v7748_range_4_to_0_address_term_bound_16) ).

fof(address_association_226,axiom,
    v7748_range_4_to_0_address_association(constB16,v7748_range_4_to_0_address_term_bound_16) ).

fof(transient_address_definition_225,axiom,
    ! [B] :
      ( addressVal(v7748_range_4_to_0_address_term_bound_15,B)
    <=> v7748(constB15,B) ) ).

fof(is_address_294,axiom,
    address(v7748_range_4_to_0_address_term_bound_15) ).

fof(address_association_225,axiom,
    v7748_range_4_to_0_address_association(constB15,v7748_range_4_to_0_address_term_bound_15) ).

fof(transient_address_definition_224,axiom,
    ! [B] :
      ( addressVal(v7748_range_4_to_0_address_term_bound_14,B)
    <=> v7748(constB14,B) ) ).

fof(is_address_293,axiom,
    address(v7748_range_4_to_0_address_term_bound_14) ).

fof(address_association_224,axiom,
    v7748_range_4_to_0_address_association(constB14,v7748_range_4_to_0_address_term_bound_14) ).

fof(transient_address_definition_223,axiom,
    ! [B] :
      ( addressVal(v7748_range_4_to_0_address_term_bound_13,B)
    <=> v7748(constB13,B) ) ).

fof(is_address_292,axiom,
    address(v7748_range_4_to_0_address_term_bound_13) ).

fof(address_association_223,axiom,
    v7748_range_4_to_0_address_association(constB13,v7748_range_4_to_0_address_term_bound_13) ).

fof(transient_address_definition_222,axiom,
    ! [B] :
      ( addressVal(v7748_range_4_to_0_address_term_bound_12,B)
    <=> v7748(constB12,B) ) ).

fof(is_address_291,axiom,
    address(v7748_range_4_to_0_address_term_bound_12) ).

fof(address_association_222,axiom,
    v7748_range_4_to_0_address_association(constB12,v7748_range_4_to_0_address_term_bound_12) ).

fof(transient_address_definition_221,axiom,
    ! [B] :
      ( addressVal(v7748_range_4_to_0_address_term_bound_11,B)
    <=> v7748(constB11,B) ) ).

fof(is_address_290,axiom,
    address(v7748_range_4_to_0_address_term_bound_11) ).

fof(address_association_221,axiom,
    v7748_range_4_to_0_address_association(constB11,v7748_range_4_to_0_address_term_bound_11) ).

fof(transient_address_definition_220,axiom,
    ! [B] :
      ( addressVal(v7748_range_4_to_0_address_term_bound_10,B)
    <=> v7748(constB10,B) ) ).

fof(is_address_289,axiom,
    address(v7748_range_4_to_0_address_term_bound_10) ).

fof(address_association_220,axiom,
    v7748_range_4_to_0_address_association(constB10,v7748_range_4_to_0_address_term_bound_10) ).

fof(transient_address_definition_219,axiom,
    ! [B] :
      ( addressVal(v7748_range_4_to_0_address_term_bound_9,B)
    <=> v7748(constB9,B) ) ).

fof(is_address_288,axiom,
    address(v7748_range_4_to_0_address_term_bound_9) ).

fof(address_association_219,axiom,
    v7748_range_4_to_0_address_association(constB9,v7748_range_4_to_0_address_term_bound_9) ).

fof(transient_address_definition_218,axiom,
    ! [B] :
      ( addressVal(v7748_range_4_to_0_address_term_bound_8,B)
    <=> v7748(constB8,B) ) ).

fof(is_address_287,axiom,
    address(v7748_range_4_to_0_address_term_bound_8) ).

fof(address_association_218,axiom,
    v7748_range_4_to_0_address_association(constB8,v7748_range_4_to_0_address_term_bound_8) ).

fof(transient_address_definition_217,axiom,
    ! [B] :
      ( addressVal(v7748_range_4_to_0_address_term_bound_7,B)
    <=> v7748(constB7,B) ) ).

fof(is_address_286,axiom,
    address(v7748_range_4_to_0_address_term_bound_7) ).

fof(address_association_217,axiom,
    v7748_range_4_to_0_address_association(constB7,v7748_range_4_to_0_address_term_bound_7) ).

fof(transient_address_definition_216,axiom,
    ! [B] :
      ( addressVal(v7748_range_4_to_0_address_term_bound_6,B)
    <=> v7748(constB6,B) ) ).

fof(is_address_285,axiom,
    address(v7748_range_4_to_0_address_term_bound_6) ).

fof(address_association_216,axiom,
    v7748_range_4_to_0_address_association(constB6,v7748_range_4_to_0_address_term_bound_6) ).

fof(transient_address_definition_215,axiom,
    ! [B] :
      ( addressVal(v7748_range_4_to_0_address_term_bound_5,B)
    <=> v7748(constB5,B) ) ).

fof(is_address_284,axiom,
    address(v7748_range_4_to_0_address_term_bound_5) ).

fof(address_association_215,axiom,
    v7748_range_4_to_0_address_association(constB5,v7748_range_4_to_0_address_term_bound_5) ).

fof(transient_address_definition_214,axiom,
    ! [B] :
      ( addressVal(v7748_range_4_to_0_address_term_bound_4,B)
    <=> v7748(constB4,B) ) ).

fof(is_address_283,axiom,
    address(v7748_range_4_to_0_address_term_bound_4) ).

fof(address_association_214,axiom,
    v7748_range_4_to_0_address_association(constB4,v7748_range_4_to_0_address_term_bound_4) ).

fof(transient_address_definition_213,axiom,
    ! [B] :
      ( addressVal(v7748_range_4_to_0_address_term_bound_3,B)
    <=> v7748(constB3,B) ) ).

fof(is_address_282,axiom,
    address(v7748_range_4_to_0_address_term_bound_3) ).

fof(address_association_213,axiom,
    v7748_range_4_to_0_address_association(constB3,v7748_range_4_to_0_address_term_bound_3) ).

fof(transient_address_definition_212,axiom,
    ! [B] :
      ( addressVal(v7748_range_4_to_0_address_term_bound_2,B)
    <=> v7748(constB2,B) ) ).

fof(is_address_281,axiom,
    address(v7748_range_4_to_0_address_term_bound_2) ).

fof(address_association_212,axiom,
    v7748_range_4_to_0_address_association(constB2,v7748_range_4_to_0_address_term_bound_2) ).

fof(transient_address_definition_211,axiom,
    ! [B] :
      ( addressVal(v7748_range_4_to_0_address_term_bound_1,B)
    <=> v7748(constB1,B) ) ).

fof(is_address_280,axiom,
    address(v7748_range_4_to_0_address_term_bound_1) ).

fof(address_association_211,axiom,
    v7748_range_4_to_0_address_association(constB1,v7748_range_4_to_0_address_term_bound_1) ).

fof(transient_address_definition_210,axiom,
    ! [B] :
      ( addressVal(v7748_range_4_to_0_address_term_bound_0,B)
    <=> v7748(constB0,B) ) ).

fof(is_address_279,axiom,
    address(v7748_range_4_to_0_address_term_bound_0) ).

fof(address_association_210,axiom,
    v7748_range_4_to_0_address_association(constB0,v7748_range_4_to_0_address_term_bound_0) ).

fof(is_address_278,axiom,
    address(b11110_address_term) ).

fof(constant_address_definition_68,axiom,
    ! [B] :
      ( addressVal(b11110_address_term,B)
    <=> b11110(B) ) ).

fof(is_address_277,axiom,
    address(b11101_address_term) ).

fof(constant_address_definition_67,axiom,
    ! [B] :
      ( addressVal(b11101_address_term,B)
    <=> b11101(B) ) ).

fof(is_address_276,axiom,
    address(b11011_address_term) ).

fof(constant_address_definition_66,axiom,
    ! [B] :
      ( addressVal(b11011_address_term,B)
    <=> b11011(B) ) ).

fof(is_address_275,axiom,
    address(b11010_address_term) ).

fof(constant_address_definition_65,axiom,
    ! [B] :
      ( addressVal(b11010_address_term,B)
    <=> b11010(B) ) ).

fof(is_address_274,axiom,
    address(b11001_address_term) ).

fof(constant_address_definition_64,axiom,
    ! [B] :
      ( addressVal(b11001_address_term,B)
    <=> b11001(B) ) ).

fof(is_address_273,axiom,
    address(b10111_address_term) ).

fof(constant_address_definition_63,axiom,
    ! [B] :
      ( addressVal(b10111_address_term,B)
    <=> b10111(B) ) ).

fof(is_address_272,axiom,
    address(b10110_address_term) ).

fof(constant_address_definition_62,axiom,
    ! [B] :
      ( addressVal(b10110_address_term,B)
    <=> b10110(B) ) ).

fof(is_address_271,axiom,
    address(b10101_address_term) ).

fof(constant_address_definition_61,axiom,
    ! [B] :
      ( addressVal(b10101_address_term,B)
    <=> b10101(B) ) ).

fof(is_address_270,axiom,
    address(b01111_address_term) ).

fof(constant_address_definition_60,axiom,
    ! [B] :
      ( addressVal(b01111_address_term,B)
    <=> b01111(B) ) ).

fof(is_address_269,axiom,
    address(b01110_address_term) ).

fof(constant_address_definition_59,axiom,
    ! [B] :
      ( addressVal(b01110_address_term,B)
    <=> b01110(B) ) ).

fof(is_address_268,axiom,
    address(b01101_address_term) ).

fof(constant_address_definition_58,axiom,
    ! [B] :
      ( addressVal(b01101_address_term,B)
    <=> b01101(B) ) ).

fof(is_address_267,axiom,
    address(b01100_address_term) ).

fof(constant_address_definition_57,axiom,
    ! [B] :
      ( addressVal(b01100_address_term,B)
    <=> b01100(B) ) ).

fof(is_address_266,axiom,
    address(b01011_address_term) ).

fof(constant_address_definition_56,axiom,
    ! [B] :
      ( addressVal(b01011_address_term,B)
    <=> b01011(B) ) ).

fof(is_address_265,axiom,
    address(b01010_address_term) ).

fof(constant_address_definition_55,axiom,
    ! [B] :
      ( addressVal(b01010_address_term,B)
    <=> b01010(B) ) ).

fof(is_address_264,axiom,
    address(b01001_address_term) ).

fof(constant_address_definition_54,axiom,
    ! [B] :
      ( addressVal(b01001_address_term,B)
    <=> b01001(B) ) ).

fof(is_address_263,axiom,
    address(b01000_address_term) ).

fof(constant_address_definition_53,axiom,
    ! [B] :
      ( addressVal(b01000_address_term,B)
    <=> b01000(B) ) ).

fof(is_address_262,axiom,
    address(b00111_address_term) ).

fof(constant_address_definition_52,axiom,
    ! [B] :
      ( addressVal(b00111_address_term,B)
    <=> b00111(B) ) ).

fof(is_address_261,axiom,
    address(b00110_address_term) ).

fof(constant_address_definition_51,axiom,
    ! [B] :
      ( addressVal(b00110_address_term,B)
    <=> b00110(B) ) ).

fof(is_address_260,axiom,
    address(b00101_address_term) ).

fof(constant_address_definition_50,axiom,
    ! [B] :
      ( addressVal(b00101_address_term,B)
    <=> b00101(B) ) ).

fof(is_address_259,axiom,
    address(b00100_address_term) ).

fof(constant_address_definition_49,axiom,
    ! [B] :
      ( addressVal(b00100_address_term,B)
    <=> b00100(B) ) ).

fof(is_address_258,axiom,
    address(b00011_address_term) ).

fof(constant_address_definition_48,axiom,
    ! [B] :
      ( addressVal(b00011_address_term,B)
    <=> b00011(B) ) ).

fof(is_address_257,axiom,
    address(b00010_address_term) ).

fof(constant_address_definition_47,axiom,
    ! [B] :
      ( addressVal(b00010_address_term,B)
    <=> b00010(B) ) ).

fof(address_false_msb_231,axiom,
    ~ addressVal(v6902_range_3_to_0_address_term_bound_20,bitIndex4) ).

fof(transient_address_definition_209,axiom,
    ( $true
    & ( addressVal(v6902_range_3_to_0_address_term_bound_20,bitIndex0)
    <=> v6902(constB20,bitIndex0) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_20,bitIndex1)
    <=> v6902(constB20,bitIndex1) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_20,bitIndex2)
    <=> v6902(constB20,bitIndex2) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_20,bitIndex3)
    <=> v6902(constB20,bitIndex3) ) ) ).

fof(is_address_256,axiom,
    address(v6902_range_3_to_0_address_term_bound_20) ).

fof(address_association_209,axiom,
    v6902_range_3_to_0_address_association(constB20,v6902_range_3_to_0_address_term_bound_20) ).

fof(address_false_msb_230,axiom,
    ~ addressVal(v6902_range_3_to_0_address_term_bound_19,bitIndex4) ).

fof(transient_address_definition_208,axiom,
    ( $true
    & ( addressVal(v6902_range_3_to_0_address_term_bound_19,bitIndex0)
    <=> v6902(constB19,bitIndex0) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_19,bitIndex1)
    <=> v6902(constB19,bitIndex1) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_19,bitIndex2)
    <=> v6902(constB19,bitIndex2) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_19,bitIndex3)
    <=> v6902(constB19,bitIndex3) ) ) ).

fof(is_address_255,axiom,
    address(v6902_range_3_to_0_address_term_bound_19) ).

fof(address_association_208,axiom,
    v6902_range_3_to_0_address_association(constB19,v6902_range_3_to_0_address_term_bound_19) ).

fof(address_false_msb_229,axiom,
    ~ addressVal(v6902_range_3_to_0_address_term_bound_18,bitIndex4) ).

fof(transient_address_definition_207,axiom,
    ( $true
    & ( addressVal(v6902_range_3_to_0_address_term_bound_18,bitIndex0)
    <=> v6902(constB18,bitIndex0) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_18,bitIndex1)
    <=> v6902(constB18,bitIndex1) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_18,bitIndex2)
    <=> v6902(constB18,bitIndex2) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_18,bitIndex3)
    <=> v6902(constB18,bitIndex3) ) ) ).

fof(is_address_254,axiom,
    address(v6902_range_3_to_0_address_term_bound_18) ).

fof(address_association_207,axiom,
    v6902_range_3_to_0_address_association(constB18,v6902_range_3_to_0_address_term_bound_18) ).

fof(address_false_msb_228,axiom,
    ~ addressVal(v6902_range_3_to_0_address_term_bound_17,bitIndex4) ).

fof(transient_address_definition_206,axiom,
    ( $true
    & ( addressVal(v6902_range_3_to_0_address_term_bound_17,bitIndex0)
    <=> v6902(constB17,bitIndex0) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_17,bitIndex1)
    <=> v6902(constB17,bitIndex1) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_17,bitIndex2)
    <=> v6902(constB17,bitIndex2) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_17,bitIndex3)
    <=> v6902(constB17,bitIndex3) ) ) ).

fof(is_address_253,axiom,
    address(v6902_range_3_to_0_address_term_bound_17) ).

fof(address_association_206,axiom,
    v6902_range_3_to_0_address_association(constB17,v6902_range_3_to_0_address_term_bound_17) ).

fof(address_false_msb_227,axiom,
    ~ addressVal(v6902_range_3_to_0_address_term_bound_16,bitIndex4) ).

fof(transient_address_definition_205,axiom,
    ( $true
    & ( addressVal(v6902_range_3_to_0_address_term_bound_16,bitIndex0)
    <=> v6902(constB16,bitIndex0) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_16,bitIndex1)
    <=> v6902(constB16,bitIndex1) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_16,bitIndex2)
    <=> v6902(constB16,bitIndex2) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_16,bitIndex3)
    <=> v6902(constB16,bitIndex3) ) ) ).

fof(is_address_252,axiom,
    address(v6902_range_3_to_0_address_term_bound_16) ).

fof(address_association_205,axiom,
    v6902_range_3_to_0_address_association(constB16,v6902_range_3_to_0_address_term_bound_16) ).

fof(address_false_msb_226,axiom,
    ~ addressVal(v6902_range_3_to_0_address_term_bound_15,bitIndex4) ).

fof(transient_address_definition_204,axiom,
    ( $true
    & ( addressVal(v6902_range_3_to_0_address_term_bound_15,bitIndex0)
    <=> v6902(constB15,bitIndex0) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_15,bitIndex1)
    <=> v6902(constB15,bitIndex1) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_15,bitIndex2)
    <=> v6902(constB15,bitIndex2) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_15,bitIndex3)
    <=> v6902(constB15,bitIndex3) ) ) ).

fof(is_address_251,axiom,
    address(v6902_range_3_to_0_address_term_bound_15) ).

fof(address_association_204,axiom,
    v6902_range_3_to_0_address_association(constB15,v6902_range_3_to_0_address_term_bound_15) ).

fof(address_false_msb_225,axiom,
    ~ addressVal(v6902_range_3_to_0_address_term_bound_14,bitIndex4) ).

fof(transient_address_definition_203,axiom,
    ( $true
    & ( addressVal(v6902_range_3_to_0_address_term_bound_14,bitIndex0)
    <=> v6902(constB14,bitIndex0) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_14,bitIndex1)
    <=> v6902(constB14,bitIndex1) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_14,bitIndex2)
    <=> v6902(constB14,bitIndex2) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_14,bitIndex3)
    <=> v6902(constB14,bitIndex3) ) ) ).

fof(is_address_250,axiom,
    address(v6902_range_3_to_0_address_term_bound_14) ).

fof(address_association_203,axiom,
    v6902_range_3_to_0_address_association(constB14,v6902_range_3_to_0_address_term_bound_14) ).

fof(address_false_msb_224,axiom,
    ~ addressVal(v6902_range_3_to_0_address_term_bound_13,bitIndex4) ).

fof(transient_address_definition_202,axiom,
    ( $true
    & ( addressVal(v6902_range_3_to_0_address_term_bound_13,bitIndex0)
    <=> v6902(constB13,bitIndex0) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_13,bitIndex1)
    <=> v6902(constB13,bitIndex1) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_13,bitIndex2)
    <=> v6902(constB13,bitIndex2) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_13,bitIndex3)
    <=> v6902(constB13,bitIndex3) ) ) ).

fof(is_address_249,axiom,
    address(v6902_range_3_to_0_address_term_bound_13) ).

fof(address_association_202,axiom,
    v6902_range_3_to_0_address_association(constB13,v6902_range_3_to_0_address_term_bound_13) ).

fof(address_false_msb_223,axiom,
    ~ addressVal(v6902_range_3_to_0_address_term_bound_12,bitIndex4) ).

fof(transient_address_definition_201,axiom,
    ( $true
    & ( addressVal(v6902_range_3_to_0_address_term_bound_12,bitIndex0)
    <=> v6902(constB12,bitIndex0) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_12,bitIndex1)
    <=> v6902(constB12,bitIndex1) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_12,bitIndex2)
    <=> v6902(constB12,bitIndex2) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_12,bitIndex3)
    <=> v6902(constB12,bitIndex3) ) ) ).

fof(is_address_248,axiom,
    address(v6902_range_3_to_0_address_term_bound_12) ).

fof(address_association_201,axiom,
    v6902_range_3_to_0_address_association(constB12,v6902_range_3_to_0_address_term_bound_12) ).

fof(address_false_msb_222,axiom,
    ~ addressVal(v6902_range_3_to_0_address_term_bound_11,bitIndex4) ).

fof(transient_address_definition_200,axiom,
    ( $true
    & ( addressVal(v6902_range_3_to_0_address_term_bound_11,bitIndex0)
    <=> v6902(constB11,bitIndex0) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_11,bitIndex1)
    <=> v6902(constB11,bitIndex1) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_11,bitIndex2)
    <=> v6902(constB11,bitIndex2) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_11,bitIndex3)
    <=> v6902(constB11,bitIndex3) ) ) ).

fof(is_address_247,axiom,
    address(v6902_range_3_to_0_address_term_bound_11) ).

fof(address_association_200,axiom,
    v6902_range_3_to_0_address_association(constB11,v6902_range_3_to_0_address_term_bound_11) ).

fof(address_false_msb_221,axiom,
    ~ addressVal(v6902_range_3_to_0_address_term_bound_10,bitIndex4) ).

fof(transient_address_definition_199,axiom,
    ( $true
    & ( addressVal(v6902_range_3_to_0_address_term_bound_10,bitIndex0)
    <=> v6902(constB10,bitIndex0) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_10,bitIndex1)
    <=> v6902(constB10,bitIndex1) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_10,bitIndex2)
    <=> v6902(constB10,bitIndex2) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_10,bitIndex3)
    <=> v6902(constB10,bitIndex3) ) ) ).

fof(is_address_246,axiom,
    address(v6902_range_3_to_0_address_term_bound_10) ).

fof(address_association_199,axiom,
    v6902_range_3_to_0_address_association(constB10,v6902_range_3_to_0_address_term_bound_10) ).

fof(address_false_msb_220,axiom,
    ~ addressVal(v6902_range_3_to_0_address_term_bound_9,bitIndex4) ).

fof(transient_address_definition_198,axiom,
    ( $true
    & ( addressVal(v6902_range_3_to_0_address_term_bound_9,bitIndex0)
    <=> v6902(constB9,bitIndex0) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_9,bitIndex1)
    <=> v6902(constB9,bitIndex1) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_9,bitIndex2)
    <=> v6902(constB9,bitIndex2) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_9,bitIndex3)
    <=> v6902(constB9,bitIndex3) ) ) ).

fof(is_address_245,axiom,
    address(v6902_range_3_to_0_address_term_bound_9) ).

fof(address_association_198,axiom,
    v6902_range_3_to_0_address_association(constB9,v6902_range_3_to_0_address_term_bound_9) ).

fof(address_false_msb_219,axiom,
    ~ addressVal(v6902_range_3_to_0_address_term_bound_8,bitIndex4) ).

fof(transient_address_definition_197,axiom,
    ( $true
    & ( addressVal(v6902_range_3_to_0_address_term_bound_8,bitIndex0)
    <=> v6902(constB8,bitIndex0) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_8,bitIndex1)
    <=> v6902(constB8,bitIndex1) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_8,bitIndex2)
    <=> v6902(constB8,bitIndex2) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_8,bitIndex3)
    <=> v6902(constB8,bitIndex3) ) ) ).

fof(is_address_244,axiom,
    address(v6902_range_3_to_0_address_term_bound_8) ).

fof(address_association_197,axiom,
    v6902_range_3_to_0_address_association(constB8,v6902_range_3_to_0_address_term_bound_8) ).

fof(address_false_msb_218,axiom,
    ~ addressVal(v6902_range_3_to_0_address_term_bound_7,bitIndex4) ).

fof(transient_address_definition_196,axiom,
    ( $true
    & ( addressVal(v6902_range_3_to_0_address_term_bound_7,bitIndex0)
    <=> v6902(constB7,bitIndex0) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_7,bitIndex1)
    <=> v6902(constB7,bitIndex1) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_7,bitIndex2)
    <=> v6902(constB7,bitIndex2) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_7,bitIndex3)
    <=> v6902(constB7,bitIndex3) ) ) ).

fof(is_address_243,axiom,
    address(v6902_range_3_to_0_address_term_bound_7) ).

fof(address_association_196,axiom,
    v6902_range_3_to_0_address_association(constB7,v6902_range_3_to_0_address_term_bound_7) ).

fof(address_false_msb_217,axiom,
    ~ addressVal(v6902_range_3_to_0_address_term_bound_6,bitIndex4) ).

fof(transient_address_definition_195,axiom,
    ( $true
    & ( addressVal(v6902_range_3_to_0_address_term_bound_6,bitIndex0)
    <=> v6902(constB6,bitIndex0) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_6,bitIndex1)
    <=> v6902(constB6,bitIndex1) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_6,bitIndex2)
    <=> v6902(constB6,bitIndex2) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_6,bitIndex3)
    <=> v6902(constB6,bitIndex3) ) ) ).

fof(is_address_242,axiom,
    address(v6902_range_3_to_0_address_term_bound_6) ).

fof(address_association_195,axiom,
    v6902_range_3_to_0_address_association(constB6,v6902_range_3_to_0_address_term_bound_6) ).

fof(address_false_msb_216,axiom,
    ~ addressVal(v6902_range_3_to_0_address_term_bound_5,bitIndex4) ).

fof(transient_address_definition_194,axiom,
    ( $true
    & ( addressVal(v6902_range_3_to_0_address_term_bound_5,bitIndex0)
    <=> v6902(constB5,bitIndex0) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_5,bitIndex1)
    <=> v6902(constB5,bitIndex1) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_5,bitIndex2)
    <=> v6902(constB5,bitIndex2) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_5,bitIndex3)
    <=> v6902(constB5,bitIndex3) ) ) ).

fof(is_address_241,axiom,
    address(v6902_range_3_to_0_address_term_bound_5) ).

fof(address_association_194,axiom,
    v6902_range_3_to_0_address_association(constB5,v6902_range_3_to_0_address_term_bound_5) ).

fof(address_false_msb_215,axiom,
    ~ addressVal(v6902_range_3_to_0_address_term_bound_4,bitIndex4) ).

fof(transient_address_definition_193,axiom,
    ( $true
    & ( addressVal(v6902_range_3_to_0_address_term_bound_4,bitIndex0)
    <=> v6902(constB4,bitIndex0) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_4,bitIndex1)
    <=> v6902(constB4,bitIndex1) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_4,bitIndex2)
    <=> v6902(constB4,bitIndex2) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_4,bitIndex3)
    <=> v6902(constB4,bitIndex3) ) ) ).

fof(is_address_240,axiom,
    address(v6902_range_3_to_0_address_term_bound_4) ).

fof(address_association_193,axiom,
    v6902_range_3_to_0_address_association(constB4,v6902_range_3_to_0_address_term_bound_4) ).

fof(address_false_msb_214,axiom,
    ~ addressVal(v6902_range_3_to_0_address_term_bound_3,bitIndex4) ).

fof(transient_address_definition_192,axiom,
    ( $true
    & ( addressVal(v6902_range_3_to_0_address_term_bound_3,bitIndex0)
    <=> v6902(constB3,bitIndex0) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_3,bitIndex1)
    <=> v6902(constB3,bitIndex1) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_3,bitIndex2)
    <=> v6902(constB3,bitIndex2) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_3,bitIndex3)
    <=> v6902(constB3,bitIndex3) ) ) ).

fof(is_address_239,axiom,
    address(v6902_range_3_to_0_address_term_bound_3) ).

fof(address_association_192,axiom,
    v6902_range_3_to_0_address_association(constB3,v6902_range_3_to_0_address_term_bound_3) ).

fof(address_false_msb_213,axiom,
    ~ addressVal(v6902_range_3_to_0_address_term_bound_2,bitIndex4) ).

fof(transient_address_definition_191,axiom,
    ( $true
    & ( addressVal(v6902_range_3_to_0_address_term_bound_2,bitIndex0)
    <=> v6902(constB2,bitIndex0) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_2,bitIndex1)
    <=> v6902(constB2,bitIndex1) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_2,bitIndex2)
    <=> v6902(constB2,bitIndex2) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_2,bitIndex3)
    <=> v6902(constB2,bitIndex3) ) ) ).

fof(is_address_238,axiom,
    address(v6902_range_3_to_0_address_term_bound_2) ).

fof(address_association_191,axiom,
    v6902_range_3_to_0_address_association(constB2,v6902_range_3_to_0_address_term_bound_2) ).

fof(address_false_msb_212,axiom,
    ~ addressVal(v6902_range_3_to_0_address_term_bound_1,bitIndex4) ).

fof(transient_address_definition_190,axiom,
    ( $true
    & ( addressVal(v6902_range_3_to_0_address_term_bound_1,bitIndex0)
    <=> v6902(constB1,bitIndex0) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_1,bitIndex1)
    <=> v6902(constB1,bitIndex1) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_1,bitIndex2)
    <=> v6902(constB1,bitIndex2) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_1,bitIndex3)
    <=> v6902(constB1,bitIndex3) ) ) ).

fof(is_address_237,axiom,
    address(v6902_range_3_to_0_address_term_bound_1) ).

fof(address_association_190,axiom,
    v6902_range_3_to_0_address_association(constB1,v6902_range_3_to_0_address_term_bound_1) ).

fof(address_false_msb_211,axiom,
    ~ addressVal(v6902_range_3_to_0_address_term_bound_0,bitIndex4) ).

fof(transient_address_definition_189,axiom,
    ( $true
    & ( addressVal(v6902_range_3_to_0_address_term_bound_0,bitIndex0)
    <=> v6902(constB0,bitIndex0) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_0,bitIndex1)
    <=> v6902(constB0,bitIndex1) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_0,bitIndex2)
    <=> v6902(constB0,bitIndex2) )
    & ( addressVal(v6902_range_3_to_0_address_term_bound_0,bitIndex3)
    <=> v6902(constB0,bitIndex3) ) ) ).

fof(is_address_236,axiom,
    address(v6902_range_3_to_0_address_term_bound_0) ).

fof(address_association_189,axiom,
    v6902_range_3_to_0_address_association(constB0,v6902_range_3_to_0_address_term_bound_0) ).

fof(transient_address_definition_188,axiom,
    ! [B] :
      ( addressVal(v6279_range_4_to_0_address_term_bound_20,B)
    <=> v6279(constB20,B) ) ).

fof(is_address_235,axiom,
    address(v6279_range_4_to_0_address_term_bound_20) ).

fof(address_association_188,axiom,
    v6279_range_4_to_0_address_association(constB20,v6279_range_4_to_0_address_term_bound_20) ).

fof(transient_address_definition_187,axiom,
    ! [B] :
      ( addressVal(v6279_range_4_to_0_address_term_bound_19,B)
    <=> v6279(constB19,B) ) ).

fof(is_address_234,axiom,
    address(v6279_range_4_to_0_address_term_bound_19) ).

fof(address_association_187,axiom,
    v6279_range_4_to_0_address_association(constB19,v6279_range_4_to_0_address_term_bound_19) ).

fof(transient_address_definition_186,axiom,
    ! [B] :
      ( addressVal(v6279_range_4_to_0_address_term_bound_18,B)
    <=> v6279(constB18,B) ) ).

fof(is_address_233,axiom,
    address(v6279_range_4_to_0_address_term_bound_18) ).

fof(address_association_186,axiom,
    v6279_range_4_to_0_address_association(constB18,v6279_range_4_to_0_address_term_bound_18) ).

fof(transient_address_definition_185,axiom,
    ! [B] :
      ( addressVal(v6279_range_4_to_0_address_term_bound_17,B)
    <=> v6279(constB17,B) ) ).

fof(is_address_232,axiom,
    address(v6279_range_4_to_0_address_term_bound_17) ).

fof(address_association_185,axiom,
    v6279_range_4_to_0_address_association(constB17,v6279_range_4_to_0_address_term_bound_17) ).

fof(transient_address_definition_184,axiom,
    ! [B] :
      ( addressVal(v6279_range_4_to_0_address_term_bound_16,B)
    <=> v6279(constB16,B) ) ).

fof(is_address_231,axiom,
    address(v6279_range_4_to_0_address_term_bound_16) ).

fof(address_association_184,axiom,
    v6279_range_4_to_0_address_association(constB16,v6279_range_4_to_0_address_term_bound_16) ).

fof(transient_address_definition_183,axiom,
    ! [B] :
      ( addressVal(v6279_range_4_to_0_address_term_bound_15,B)
    <=> v6279(constB15,B) ) ).

fof(is_address_230,axiom,
    address(v6279_range_4_to_0_address_term_bound_15) ).

fof(address_association_183,axiom,
    v6279_range_4_to_0_address_association(constB15,v6279_range_4_to_0_address_term_bound_15) ).

fof(transient_address_definition_182,axiom,
    ! [B] :
      ( addressVal(v6279_range_4_to_0_address_term_bound_14,B)
    <=> v6279(constB14,B) ) ).

fof(is_address_229,axiom,
    address(v6279_range_4_to_0_address_term_bound_14) ).

fof(address_association_182,axiom,
    v6279_range_4_to_0_address_association(constB14,v6279_range_4_to_0_address_term_bound_14) ).

fof(transient_address_definition_181,axiom,
    ! [B] :
      ( addressVal(v6279_range_4_to_0_address_term_bound_13,B)
    <=> v6279(constB13,B) ) ).

fof(is_address_228,axiom,
    address(v6279_range_4_to_0_address_term_bound_13) ).

fof(address_association_181,axiom,
    v6279_range_4_to_0_address_association(constB13,v6279_range_4_to_0_address_term_bound_13) ).

fof(transient_address_definition_180,axiom,
    ! [B] :
      ( addressVal(v6279_range_4_to_0_address_term_bound_12,B)
    <=> v6279(constB12,B) ) ).

fof(is_address_227,axiom,
    address(v6279_range_4_to_0_address_term_bound_12) ).

fof(address_association_180,axiom,
    v6279_range_4_to_0_address_association(constB12,v6279_range_4_to_0_address_term_bound_12) ).

fof(transient_address_definition_179,axiom,
    ! [B] :
      ( addressVal(v6279_range_4_to_0_address_term_bound_11,B)
    <=> v6279(constB11,B) ) ).

fof(is_address_226,axiom,
    address(v6279_range_4_to_0_address_term_bound_11) ).

fof(address_association_179,axiom,
    v6279_range_4_to_0_address_association(constB11,v6279_range_4_to_0_address_term_bound_11) ).

fof(transient_address_definition_178,axiom,
    ! [B] :
      ( addressVal(v6279_range_4_to_0_address_term_bound_10,B)
    <=> v6279(constB10,B) ) ).

fof(is_address_225,axiom,
    address(v6279_range_4_to_0_address_term_bound_10) ).

fof(address_association_178,axiom,
    v6279_range_4_to_0_address_association(constB10,v6279_range_4_to_0_address_term_bound_10) ).

fof(transient_address_definition_177,axiom,
    ! [B] :
      ( addressVal(v6279_range_4_to_0_address_term_bound_9,B)
    <=> v6279(constB9,B) ) ).

fof(is_address_224,axiom,
    address(v6279_range_4_to_0_address_term_bound_9) ).

fof(address_association_177,axiom,
    v6279_range_4_to_0_address_association(constB9,v6279_range_4_to_0_address_term_bound_9) ).

fof(transient_address_definition_176,axiom,
    ! [B] :
      ( addressVal(v6279_range_4_to_0_address_term_bound_8,B)
    <=> v6279(constB8,B) ) ).

fof(is_address_223,axiom,
    address(v6279_range_4_to_0_address_term_bound_8) ).

fof(address_association_176,axiom,
    v6279_range_4_to_0_address_association(constB8,v6279_range_4_to_0_address_term_bound_8) ).

fof(transient_address_definition_175,axiom,
    ! [B] :
      ( addressVal(v6279_range_4_to_0_address_term_bound_7,B)
    <=> v6279(constB7,B) ) ).

fof(is_address_222,axiom,
    address(v6279_range_4_to_0_address_term_bound_7) ).

fof(address_association_175,axiom,
    v6279_range_4_to_0_address_association(constB7,v6279_range_4_to_0_address_term_bound_7) ).

fof(transient_address_definition_174,axiom,
    ! [B] :
      ( addressVal(v6279_range_4_to_0_address_term_bound_6,B)
    <=> v6279(constB6,B) ) ).

fof(is_address_221,axiom,
    address(v6279_range_4_to_0_address_term_bound_6) ).

fof(address_association_174,axiom,
    v6279_range_4_to_0_address_association(constB6,v6279_range_4_to_0_address_term_bound_6) ).

fof(transient_address_definition_173,axiom,
    ! [B] :
      ( addressVal(v6279_range_4_to_0_address_term_bound_5,B)
    <=> v6279(constB5,B) ) ).

fof(is_address_220,axiom,
    address(v6279_range_4_to_0_address_term_bound_5) ).

fof(address_association_173,axiom,
    v6279_range_4_to_0_address_association(constB5,v6279_range_4_to_0_address_term_bound_5) ).

fof(transient_address_definition_172,axiom,
    ! [B] :
      ( addressVal(v6279_range_4_to_0_address_term_bound_4,B)
    <=> v6279(constB4,B) ) ).

fof(is_address_219,axiom,
    address(v6279_range_4_to_0_address_term_bound_4) ).

fof(address_association_172,axiom,
    v6279_range_4_to_0_address_association(constB4,v6279_range_4_to_0_address_term_bound_4) ).

fof(transient_address_definition_171,axiom,
    ! [B] :
      ( addressVal(v6279_range_4_to_0_address_term_bound_3,B)
    <=> v6279(constB3,B) ) ).

fof(is_address_218,axiom,
    address(v6279_range_4_to_0_address_term_bound_3) ).

fof(address_association_171,axiom,
    v6279_range_4_to_0_address_association(constB3,v6279_range_4_to_0_address_term_bound_3) ).

fof(transient_address_definition_170,axiom,
    ! [B] :
      ( addressVal(v6279_range_4_to_0_address_term_bound_2,B)
    <=> v6279(constB2,B) ) ).

fof(is_address_217,axiom,
    address(v6279_range_4_to_0_address_term_bound_2) ).

fof(address_association_170,axiom,
    v6279_range_4_to_0_address_association(constB2,v6279_range_4_to_0_address_term_bound_2) ).

fof(transient_address_definition_169,axiom,
    ! [B] :
      ( addressVal(v6279_range_4_to_0_address_term_bound_1,B)
    <=> v6279(constB1,B) ) ).

fof(is_address_216,axiom,
    address(v6279_range_4_to_0_address_term_bound_1) ).

fof(address_association_169,axiom,
    v6279_range_4_to_0_address_association(constB1,v6279_range_4_to_0_address_term_bound_1) ).

fof(transient_address_definition_168,axiom,
    ! [B] :
      ( addressVal(v6279_range_4_to_0_address_term_bound_0,B)
    <=> v6279(constB0,B) ) ).

fof(is_address_215,axiom,
    address(v6279_range_4_to_0_address_term_bound_0) ).

fof(address_association_168,axiom,
    v6279_range_4_to_0_address_association(constB0,v6279_range_4_to_0_address_term_bound_0) ).

fof(transient_address_definition_167,axiom,
    ! [B] :
      ( addressVal(v6239_range_4_to_0_address_term_bound_20,B)
    <=> v6239(constB20,B) ) ).

fof(is_address_214,axiom,
    address(v6239_range_4_to_0_address_term_bound_20) ).

fof(address_association_167,axiom,
    v6239_range_4_to_0_address_association(constB20,v6239_range_4_to_0_address_term_bound_20) ).

fof(transient_address_definition_166,axiom,
    ! [B] :
      ( addressVal(v6239_range_4_to_0_address_term_bound_19,B)
    <=> v6239(constB19,B) ) ).

fof(is_address_213,axiom,
    address(v6239_range_4_to_0_address_term_bound_19) ).

fof(address_association_166,axiom,
    v6239_range_4_to_0_address_association(constB19,v6239_range_4_to_0_address_term_bound_19) ).

fof(transient_address_definition_165,axiom,
    ! [B] :
      ( addressVal(v6239_range_4_to_0_address_term_bound_18,B)
    <=> v6239(constB18,B) ) ).

fof(is_address_212,axiom,
    address(v6239_range_4_to_0_address_term_bound_18) ).

fof(address_association_165,axiom,
    v6239_range_4_to_0_address_association(constB18,v6239_range_4_to_0_address_term_bound_18) ).

fof(transient_address_definition_164,axiom,
    ! [B] :
      ( addressVal(v6239_range_4_to_0_address_term_bound_17,B)
    <=> v6239(constB17,B) ) ).

fof(is_address_211,axiom,
    address(v6239_range_4_to_0_address_term_bound_17) ).

fof(address_association_164,axiom,
    v6239_range_4_to_0_address_association(constB17,v6239_range_4_to_0_address_term_bound_17) ).

fof(transient_address_definition_163,axiom,
    ! [B] :
      ( addressVal(v6239_range_4_to_0_address_term_bound_16,B)
    <=> v6239(constB16,B) ) ).

fof(is_address_210,axiom,
    address(v6239_range_4_to_0_address_term_bound_16) ).

fof(address_association_163,axiom,
    v6239_range_4_to_0_address_association(constB16,v6239_range_4_to_0_address_term_bound_16) ).

fof(transient_address_definition_162,axiom,
    ! [B] :
      ( addressVal(v6239_range_4_to_0_address_term_bound_15,B)
    <=> v6239(constB15,B) ) ).

fof(is_address_209,axiom,
    address(v6239_range_4_to_0_address_term_bound_15) ).

fof(address_association_162,axiom,
    v6239_range_4_to_0_address_association(constB15,v6239_range_4_to_0_address_term_bound_15) ).

fof(transient_address_definition_161,axiom,
    ! [B] :
      ( addressVal(v6239_range_4_to_0_address_term_bound_14,B)
    <=> v6239(constB14,B) ) ).

fof(is_address_208,axiom,
    address(v6239_range_4_to_0_address_term_bound_14) ).

fof(address_association_161,axiom,
    v6239_range_4_to_0_address_association(constB14,v6239_range_4_to_0_address_term_bound_14) ).

fof(transient_address_definition_160,axiom,
    ! [B] :
      ( addressVal(v6239_range_4_to_0_address_term_bound_13,B)
    <=> v6239(constB13,B) ) ).

fof(is_address_207,axiom,
    address(v6239_range_4_to_0_address_term_bound_13) ).

fof(address_association_160,axiom,
    v6239_range_4_to_0_address_association(constB13,v6239_range_4_to_0_address_term_bound_13) ).

fof(transient_address_definition_159,axiom,
    ! [B] :
      ( addressVal(v6239_range_4_to_0_address_term_bound_12,B)
    <=> v6239(constB12,B) ) ).

fof(is_address_206,axiom,
    address(v6239_range_4_to_0_address_term_bound_12) ).

fof(address_association_159,axiom,
    v6239_range_4_to_0_address_association(constB12,v6239_range_4_to_0_address_term_bound_12) ).

fof(transient_address_definition_158,axiom,
    ! [B] :
      ( addressVal(v6239_range_4_to_0_address_term_bound_11,B)
    <=> v6239(constB11,B) ) ).

fof(is_address_205,axiom,
    address(v6239_range_4_to_0_address_term_bound_11) ).

fof(address_association_158,axiom,
    v6239_range_4_to_0_address_association(constB11,v6239_range_4_to_0_address_term_bound_11) ).

fof(transient_address_definition_157,axiom,
    ! [B] :
      ( addressVal(v6239_range_4_to_0_address_term_bound_10,B)
    <=> v6239(constB10,B) ) ).

fof(is_address_204,axiom,
    address(v6239_range_4_to_0_address_term_bound_10) ).

fof(address_association_157,axiom,
    v6239_range_4_to_0_address_association(constB10,v6239_range_4_to_0_address_term_bound_10) ).

fof(transient_address_definition_156,axiom,
    ! [B] :
      ( addressVal(v6239_range_4_to_0_address_term_bound_9,B)
    <=> v6239(constB9,B) ) ).

fof(is_address_203,axiom,
    address(v6239_range_4_to_0_address_term_bound_9) ).

fof(address_association_156,axiom,
    v6239_range_4_to_0_address_association(constB9,v6239_range_4_to_0_address_term_bound_9) ).

fof(transient_address_definition_155,axiom,
    ! [B] :
      ( addressVal(v6239_range_4_to_0_address_term_bound_8,B)
    <=> v6239(constB8,B) ) ).

fof(is_address_202,axiom,
    address(v6239_range_4_to_0_address_term_bound_8) ).

fof(address_association_155,axiom,
    v6239_range_4_to_0_address_association(constB8,v6239_range_4_to_0_address_term_bound_8) ).

fof(transient_address_definition_154,axiom,
    ! [B] :
      ( addressVal(v6239_range_4_to_0_address_term_bound_7,B)
    <=> v6239(constB7,B) ) ).

fof(is_address_201,axiom,
    address(v6239_range_4_to_0_address_term_bound_7) ).

fof(address_association_154,axiom,
    v6239_range_4_to_0_address_association(constB7,v6239_range_4_to_0_address_term_bound_7) ).

fof(transient_address_definition_153,axiom,
    ! [B] :
      ( addressVal(v6239_range_4_to_0_address_term_bound_6,B)
    <=> v6239(constB6,B) ) ).

fof(is_address_200,axiom,
    address(v6239_range_4_to_0_address_term_bound_6) ).

fof(address_association_153,axiom,
    v6239_range_4_to_0_address_association(constB6,v6239_range_4_to_0_address_term_bound_6) ).

fof(transient_address_definition_152,axiom,
    ! [B] :
      ( addressVal(v6239_range_4_to_0_address_term_bound_5,B)
    <=> v6239(constB5,B) ) ).

fof(is_address_199,axiom,
    address(v6239_range_4_to_0_address_term_bound_5) ).

fof(address_association_152,axiom,
    v6239_range_4_to_0_address_association(constB5,v6239_range_4_to_0_address_term_bound_5) ).

fof(transient_address_definition_151,axiom,
    ! [B] :
      ( addressVal(v6239_range_4_to_0_address_term_bound_4,B)
    <=> v6239(constB4,B) ) ).

fof(is_address_198,axiom,
    address(v6239_range_4_to_0_address_term_bound_4) ).

fof(address_association_151,axiom,
    v6239_range_4_to_0_address_association(constB4,v6239_range_4_to_0_address_term_bound_4) ).

fof(transient_address_definition_150,axiom,
    ! [B] :
      ( addressVal(v6239_range_4_to_0_address_term_bound_3,B)
    <=> v6239(constB3,B) ) ).

fof(is_address_197,axiom,
    address(v6239_range_4_to_0_address_term_bound_3) ).

fof(address_association_150,axiom,
    v6239_range_4_to_0_address_association(constB3,v6239_range_4_to_0_address_term_bound_3) ).

fof(transient_address_definition_149,axiom,
    ! [B] :
      ( addressVal(v6239_range_4_to_0_address_term_bound_2,B)
    <=> v6239(constB2,B) ) ).

fof(is_address_196,axiom,
    address(v6239_range_4_to_0_address_term_bound_2) ).

fof(address_association_149,axiom,
    v6239_range_4_to_0_address_association(constB2,v6239_range_4_to_0_address_term_bound_2) ).

fof(transient_address_definition_148,axiom,
    ! [B] :
      ( addressVal(v6239_range_4_to_0_address_term_bound_1,B)
    <=> v6239(constB1,B) ) ).

fof(is_address_195,axiom,
    address(v6239_range_4_to_0_address_term_bound_1) ).

fof(address_association_148,axiom,
    v6239_range_4_to_0_address_association(constB1,v6239_range_4_to_0_address_term_bound_1) ).

fof(transient_address_definition_147,axiom,
    ! [B] :
      ( addressVal(v6239_range_4_to_0_address_term_bound_0,B)
    <=> v6239(constB0,B) ) ).

fof(is_address_194,axiom,
    address(v6239_range_4_to_0_address_term_bound_0) ).

fof(address_association_147,axiom,
    v6239_range_4_to_0_address_association(constB0,v6239_range_4_to_0_address_term_bound_0) ).

fof(transient_address_definition_146,axiom,
    ! [B] :
      ( addressVal(v5573_range_4_to_0_address_term_bound_20,B)
    <=> v5573(constB20,B) ) ).

fof(is_address_193,axiom,
    address(v5573_range_4_to_0_address_term_bound_20) ).

fof(address_association_146,axiom,
    v5573_range_4_to_0_address_association(constB20,v5573_range_4_to_0_address_term_bound_20) ).

fof(transient_address_definition_145,axiom,
    ! [B] :
      ( addressVal(v5573_range_4_to_0_address_term_bound_19,B)
    <=> v5573(constB19,B) ) ).

fof(is_address_192,axiom,
    address(v5573_range_4_to_0_address_term_bound_19) ).

fof(address_association_145,axiom,
    v5573_range_4_to_0_address_association(constB19,v5573_range_4_to_0_address_term_bound_19) ).

fof(transient_address_definition_144,axiom,
    ! [B] :
      ( addressVal(v5573_range_4_to_0_address_term_bound_18,B)
    <=> v5573(constB18,B) ) ).

fof(is_address_191,axiom,
    address(v5573_range_4_to_0_address_term_bound_18) ).

fof(address_association_144,axiom,
    v5573_range_4_to_0_address_association(constB18,v5573_range_4_to_0_address_term_bound_18) ).

fof(transient_address_definition_143,axiom,
    ! [B] :
      ( addressVal(v5573_range_4_to_0_address_term_bound_17,B)
    <=> v5573(constB17,B) ) ).

fof(is_address_190,axiom,
    address(v5573_range_4_to_0_address_term_bound_17) ).

fof(address_association_143,axiom,
    v5573_range_4_to_0_address_association(constB17,v5573_range_4_to_0_address_term_bound_17) ).

fof(transient_address_definition_142,axiom,
    ! [B] :
      ( addressVal(v5573_range_4_to_0_address_term_bound_16,B)
    <=> v5573(constB16,B) ) ).

fof(is_address_189,axiom,
    address(v5573_range_4_to_0_address_term_bound_16) ).

fof(address_association_142,axiom,
    v5573_range_4_to_0_address_association(constB16,v5573_range_4_to_0_address_term_bound_16) ).

fof(transient_address_definition_141,axiom,
    ! [B] :
      ( addressVal(v5573_range_4_to_0_address_term_bound_15,B)
    <=> v5573(constB15,B) ) ).

fof(is_address_188,axiom,
    address(v5573_range_4_to_0_address_term_bound_15) ).

fof(address_association_141,axiom,
    v5573_range_4_to_0_address_association(constB15,v5573_range_4_to_0_address_term_bound_15) ).

fof(transient_address_definition_140,axiom,
    ! [B] :
      ( addressVal(v5573_range_4_to_0_address_term_bound_14,B)
    <=> v5573(constB14,B) ) ).

fof(is_address_187,axiom,
    address(v5573_range_4_to_0_address_term_bound_14) ).

fof(address_association_140,axiom,
    v5573_range_4_to_0_address_association(constB14,v5573_range_4_to_0_address_term_bound_14) ).

fof(transient_address_definition_139,axiom,
    ! [B] :
      ( addressVal(v5573_range_4_to_0_address_term_bound_13,B)
    <=> v5573(constB13,B) ) ).

fof(is_address_186,axiom,
    address(v5573_range_4_to_0_address_term_bound_13) ).

fof(address_association_139,axiom,
    v5573_range_4_to_0_address_association(constB13,v5573_range_4_to_0_address_term_bound_13) ).

fof(transient_address_definition_138,axiom,
    ! [B] :
      ( addressVal(v5573_range_4_to_0_address_term_bound_12,B)
    <=> v5573(constB12,B) ) ).

fof(is_address_185,axiom,
    address(v5573_range_4_to_0_address_term_bound_12) ).

fof(address_association_138,axiom,
    v5573_range_4_to_0_address_association(constB12,v5573_range_4_to_0_address_term_bound_12) ).

fof(transient_address_definition_137,axiom,
    ! [B] :
      ( addressVal(v5573_range_4_to_0_address_term_bound_11,B)
    <=> v5573(constB11,B) ) ).

fof(is_address_184,axiom,
    address(v5573_range_4_to_0_address_term_bound_11) ).

fof(address_association_137,axiom,
    v5573_range_4_to_0_address_association(constB11,v5573_range_4_to_0_address_term_bound_11) ).

fof(transient_address_definition_136,axiom,
    ! [B] :
      ( addressVal(v5573_range_4_to_0_address_term_bound_10,B)
    <=> v5573(constB10,B) ) ).

fof(is_address_183,axiom,
    address(v5573_range_4_to_0_address_term_bound_10) ).

fof(address_association_136,axiom,
    v5573_range_4_to_0_address_association(constB10,v5573_range_4_to_0_address_term_bound_10) ).

fof(transient_address_definition_135,axiom,
    ! [B] :
      ( addressVal(v5573_range_4_to_0_address_term_bound_9,B)
    <=> v5573(constB9,B) ) ).

fof(is_address_182,axiom,
    address(v5573_range_4_to_0_address_term_bound_9) ).

fof(address_association_135,axiom,
    v5573_range_4_to_0_address_association(constB9,v5573_range_4_to_0_address_term_bound_9) ).

fof(transient_address_definition_134,axiom,
    ! [B] :
      ( addressVal(v5573_range_4_to_0_address_term_bound_8,B)
    <=> v5573(constB8,B) ) ).

fof(is_address_181,axiom,
    address(v5573_range_4_to_0_address_term_bound_8) ).

fof(address_association_134,axiom,
    v5573_range_4_to_0_address_association(constB8,v5573_range_4_to_0_address_term_bound_8) ).

fof(transient_address_definition_133,axiom,
    ! [B] :
      ( addressVal(v5573_range_4_to_0_address_term_bound_7,B)
    <=> v5573(constB7,B) ) ).

fof(is_address_180,axiom,
    address(v5573_range_4_to_0_address_term_bound_7) ).

fof(address_association_133,axiom,
    v5573_range_4_to_0_address_association(constB7,v5573_range_4_to_0_address_term_bound_7) ).

fof(transient_address_definition_132,axiom,
    ! [B] :
      ( addressVal(v5573_range_4_to_0_address_term_bound_6,B)
    <=> v5573(constB6,B) ) ).

fof(is_address_179,axiom,
    address(v5573_range_4_to_0_address_term_bound_6) ).

fof(address_association_132,axiom,
    v5573_range_4_to_0_address_association(constB6,v5573_range_4_to_0_address_term_bound_6) ).

fof(transient_address_definition_131,axiom,
    ! [B] :
      ( addressVal(v5573_range_4_to_0_address_term_bound_5,B)
    <=> v5573(constB5,B) ) ).

fof(is_address_178,axiom,
    address(v5573_range_4_to_0_address_term_bound_5) ).

fof(address_association_131,axiom,
    v5573_range_4_to_0_address_association(constB5,v5573_range_4_to_0_address_term_bound_5) ).

fof(transient_address_definition_130,axiom,
    ! [B] :
      ( addressVal(v5573_range_4_to_0_address_term_bound_4,B)
    <=> v5573(constB4,B) ) ).

fof(is_address_177,axiom,
    address(v5573_range_4_to_0_address_term_bound_4) ).

fof(address_association_130,axiom,
    v5573_range_4_to_0_address_association(constB4,v5573_range_4_to_0_address_term_bound_4) ).

fof(transient_address_definition_129,axiom,
    ! [B] :
      ( addressVal(v5573_range_4_to_0_address_term_bound_3,B)
    <=> v5573(constB3,B) ) ).

fof(is_address_176,axiom,
    address(v5573_range_4_to_0_address_term_bound_3) ).

fof(address_association_129,axiom,
    v5573_range_4_to_0_address_association(constB3,v5573_range_4_to_0_address_term_bound_3) ).

fof(transient_address_definition_128,axiom,
    ! [B] :
      ( addressVal(v5573_range_4_to_0_address_term_bound_2,B)
    <=> v5573(constB2,B) ) ).

fof(is_address_175,axiom,
    address(v5573_range_4_to_0_address_term_bound_2) ).

fof(address_association_128,axiom,
    v5573_range_4_to_0_address_association(constB2,v5573_range_4_to_0_address_term_bound_2) ).

fof(transient_address_definition_127,axiom,
    ! [B] :
      ( addressVal(v5573_range_4_to_0_address_term_bound_1,B)
    <=> v5573(constB1,B) ) ).

fof(is_address_174,axiom,
    address(v5573_range_4_to_0_address_term_bound_1) ).

fof(address_association_127,axiom,
    v5573_range_4_to_0_address_association(constB1,v5573_range_4_to_0_address_term_bound_1) ).

fof(transient_address_definition_126,axiom,
    ! [B] :
      ( addressVal(v5573_range_4_to_0_address_term_bound_0,B)
    <=> v5573(constB0,B) ) ).

fof(is_address_173,axiom,
    address(v5573_range_4_to_0_address_term_bound_0) ).

fof(address_association_126,axiom,
    v5573_range_4_to_0_address_association(constB0,v5573_range_4_to_0_address_term_bound_0) ).

fof(is_address_172,axiom,
    address(b11100_address_term) ).

fof(constant_address_definition_46,axiom,
    ! [B] :
      ( addressVal(b11100_address_term,B)
    <=> b11100(B) ) ).

fof(is_address_171,axiom,
    address(b10011_address_term) ).

fof(constant_address_definition_45,axiom,
    ! [B] :
      ( addressVal(b10011_address_term,B)
    <=> b10011(B) ) ).

fof(is_address_170,axiom,
    address(b11000_address_term) ).

fof(constant_address_definition_44,axiom,
    ! [B] :
      ( addressVal(b11000_address_term,B)
    <=> b11000(B) ) ).

fof(is_address_169,axiom,
    address(b10100_address_term) ).

fof(constant_address_definition_43,axiom,
    ! [B] :
      ( addressVal(b10100_address_term,B)
    <=> b10100(B) ) ).

fof(is_address_168,axiom,
    address(b10010_address_term) ).

fof(constant_address_definition_42,axiom,
    ! [B] :
      ( addressVal(b10010_address_term,B)
    <=> b10010(B) ) ).

fof(is_address_167,axiom,
    address(b10001_address_term) ).

fof(constant_address_definition_41,axiom,
    ! [B] :
      ( addressVal(b10001_address_term,B)
    <=> b10001(B) ) ).

fof(address_false_msb_210,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_20,bitIndex4) ).

fof(address_false_msb_209,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_20,bitIndex3) ).

fof(transient_address_definition_125,axiom,
    ( $true
    & ( addressVal(v4043_range_2_to_0_address_term_bound_20,bitIndex0)
    <=> v4043(constB20,bitIndex0) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_20,bitIndex1)
    <=> v4043(constB20,bitIndex1) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_20,bitIndex2)
    <=> v4043(constB20,bitIndex2) ) ) ).

fof(is_address_166,axiom,
    address(v4043_range_2_to_0_address_term_bound_20) ).

fof(address_association_125,axiom,
    v4043_range_2_to_0_address_association(constB20,v4043_range_2_to_0_address_term_bound_20) ).

fof(address_false_msb_208,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_19,bitIndex4) ).

fof(address_false_msb_207,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_19,bitIndex3) ).

fof(transient_address_definition_124,axiom,
    ( $true
    & ( addressVal(v4043_range_2_to_0_address_term_bound_19,bitIndex0)
    <=> v4043(constB19,bitIndex0) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_19,bitIndex1)
    <=> v4043(constB19,bitIndex1) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_19,bitIndex2)
    <=> v4043(constB19,bitIndex2) ) ) ).

fof(is_address_165,axiom,
    address(v4043_range_2_to_0_address_term_bound_19) ).

fof(address_association_124,axiom,
    v4043_range_2_to_0_address_association(constB19,v4043_range_2_to_0_address_term_bound_19) ).

fof(address_false_msb_206,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_18,bitIndex4) ).

fof(address_false_msb_205,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_18,bitIndex3) ).

fof(transient_address_definition_123,axiom,
    ( $true
    & ( addressVal(v4043_range_2_to_0_address_term_bound_18,bitIndex0)
    <=> v4043(constB18,bitIndex0) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_18,bitIndex1)
    <=> v4043(constB18,bitIndex1) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_18,bitIndex2)
    <=> v4043(constB18,bitIndex2) ) ) ).

fof(is_address_164,axiom,
    address(v4043_range_2_to_0_address_term_bound_18) ).

fof(address_association_123,axiom,
    v4043_range_2_to_0_address_association(constB18,v4043_range_2_to_0_address_term_bound_18) ).

fof(address_false_msb_204,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_17,bitIndex4) ).

fof(address_false_msb_203,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_17,bitIndex3) ).

fof(transient_address_definition_122,axiom,
    ( $true
    & ( addressVal(v4043_range_2_to_0_address_term_bound_17,bitIndex0)
    <=> v4043(constB17,bitIndex0) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_17,bitIndex1)
    <=> v4043(constB17,bitIndex1) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_17,bitIndex2)
    <=> v4043(constB17,bitIndex2) ) ) ).

fof(is_address_163,axiom,
    address(v4043_range_2_to_0_address_term_bound_17) ).

fof(address_association_122,axiom,
    v4043_range_2_to_0_address_association(constB17,v4043_range_2_to_0_address_term_bound_17) ).

fof(address_false_msb_202,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_16,bitIndex4) ).

fof(address_false_msb_201,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_16,bitIndex3) ).

fof(transient_address_definition_121,axiom,
    ( $true
    & ( addressVal(v4043_range_2_to_0_address_term_bound_16,bitIndex0)
    <=> v4043(constB16,bitIndex0) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_16,bitIndex1)
    <=> v4043(constB16,bitIndex1) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_16,bitIndex2)
    <=> v4043(constB16,bitIndex2) ) ) ).

fof(is_address_162,axiom,
    address(v4043_range_2_to_0_address_term_bound_16) ).

fof(address_association_121,axiom,
    v4043_range_2_to_0_address_association(constB16,v4043_range_2_to_0_address_term_bound_16) ).

fof(address_false_msb_200,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_15,bitIndex4) ).

fof(address_false_msb_199,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_15,bitIndex3) ).

fof(transient_address_definition_120,axiom,
    ( $true
    & ( addressVal(v4043_range_2_to_0_address_term_bound_15,bitIndex0)
    <=> v4043(constB15,bitIndex0) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_15,bitIndex1)
    <=> v4043(constB15,bitIndex1) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_15,bitIndex2)
    <=> v4043(constB15,bitIndex2) ) ) ).

fof(is_address_161,axiom,
    address(v4043_range_2_to_0_address_term_bound_15) ).

fof(address_association_120,axiom,
    v4043_range_2_to_0_address_association(constB15,v4043_range_2_to_0_address_term_bound_15) ).

fof(address_false_msb_198,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_14,bitIndex4) ).

fof(address_false_msb_197,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_14,bitIndex3) ).

fof(transient_address_definition_119,axiom,
    ( $true
    & ( addressVal(v4043_range_2_to_0_address_term_bound_14,bitIndex0)
    <=> v4043(constB14,bitIndex0) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_14,bitIndex1)
    <=> v4043(constB14,bitIndex1) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_14,bitIndex2)
    <=> v4043(constB14,bitIndex2) ) ) ).

fof(is_address_160,axiom,
    address(v4043_range_2_to_0_address_term_bound_14) ).

fof(address_association_119,axiom,
    v4043_range_2_to_0_address_association(constB14,v4043_range_2_to_0_address_term_bound_14) ).

fof(address_false_msb_196,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_13,bitIndex4) ).

fof(address_false_msb_195,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_13,bitIndex3) ).

fof(transient_address_definition_118,axiom,
    ( $true
    & ( addressVal(v4043_range_2_to_0_address_term_bound_13,bitIndex0)
    <=> v4043(constB13,bitIndex0) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_13,bitIndex1)
    <=> v4043(constB13,bitIndex1) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_13,bitIndex2)
    <=> v4043(constB13,bitIndex2) ) ) ).

fof(is_address_159,axiom,
    address(v4043_range_2_to_0_address_term_bound_13) ).

fof(address_association_118,axiom,
    v4043_range_2_to_0_address_association(constB13,v4043_range_2_to_0_address_term_bound_13) ).

fof(address_false_msb_194,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_12,bitIndex4) ).

fof(address_false_msb_193,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_12,bitIndex3) ).

fof(transient_address_definition_117,axiom,
    ( $true
    & ( addressVal(v4043_range_2_to_0_address_term_bound_12,bitIndex0)
    <=> v4043(constB12,bitIndex0) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_12,bitIndex1)
    <=> v4043(constB12,bitIndex1) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_12,bitIndex2)
    <=> v4043(constB12,bitIndex2) ) ) ).

fof(is_address_158,axiom,
    address(v4043_range_2_to_0_address_term_bound_12) ).

fof(address_association_117,axiom,
    v4043_range_2_to_0_address_association(constB12,v4043_range_2_to_0_address_term_bound_12) ).

fof(address_false_msb_192,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_11,bitIndex4) ).

fof(address_false_msb_191,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_11,bitIndex3) ).

fof(transient_address_definition_116,axiom,
    ( $true
    & ( addressVal(v4043_range_2_to_0_address_term_bound_11,bitIndex0)
    <=> v4043(constB11,bitIndex0) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_11,bitIndex1)
    <=> v4043(constB11,bitIndex1) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_11,bitIndex2)
    <=> v4043(constB11,bitIndex2) ) ) ).

fof(is_address_157,axiom,
    address(v4043_range_2_to_0_address_term_bound_11) ).

fof(address_association_116,axiom,
    v4043_range_2_to_0_address_association(constB11,v4043_range_2_to_0_address_term_bound_11) ).

fof(address_false_msb_190,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_10,bitIndex4) ).

fof(address_false_msb_189,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_10,bitIndex3) ).

fof(transient_address_definition_115,axiom,
    ( $true
    & ( addressVal(v4043_range_2_to_0_address_term_bound_10,bitIndex0)
    <=> v4043(constB10,bitIndex0) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_10,bitIndex1)
    <=> v4043(constB10,bitIndex1) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_10,bitIndex2)
    <=> v4043(constB10,bitIndex2) ) ) ).

fof(is_address_156,axiom,
    address(v4043_range_2_to_0_address_term_bound_10) ).

fof(address_association_115,axiom,
    v4043_range_2_to_0_address_association(constB10,v4043_range_2_to_0_address_term_bound_10) ).

fof(address_false_msb_188,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_9,bitIndex4) ).

fof(address_false_msb_187,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_9,bitIndex3) ).

fof(transient_address_definition_114,axiom,
    ( $true
    & ( addressVal(v4043_range_2_to_0_address_term_bound_9,bitIndex0)
    <=> v4043(constB9,bitIndex0) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_9,bitIndex1)
    <=> v4043(constB9,bitIndex1) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_9,bitIndex2)
    <=> v4043(constB9,bitIndex2) ) ) ).

fof(is_address_155,axiom,
    address(v4043_range_2_to_0_address_term_bound_9) ).

fof(address_association_114,axiom,
    v4043_range_2_to_0_address_association(constB9,v4043_range_2_to_0_address_term_bound_9) ).

fof(address_false_msb_186,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_8,bitIndex4) ).

fof(address_false_msb_185,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_8,bitIndex3) ).

fof(transient_address_definition_113,axiom,
    ( $true
    & ( addressVal(v4043_range_2_to_0_address_term_bound_8,bitIndex0)
    <=> v4043(constB8,bitIndex0) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_8,bitIndex1)
    <=> v4043(constB8,bitIndex1) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_8,bitIndex2)
    <=> v4043(constB8,bitIndex2) ) ) ).

fof(is_address_154,axiom,
    address(v4043_range_2_to_0_address_term_bound_8) ).

fof(address_association_113,axiom,
    v4043_range_2_to_0_address_association(constB8,v4043_range_2_to_0_address_term_bound_8) ).

fof(address_false_msb_184,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_7,bitIndex4) ).

fof(address_false_msb_183,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_7,bitIndex3) ).

fof(transient_address_definition_112,axiom,
    ( $true
    & ( addressVal(v4043_range_2_to_0_address_term_bound_7,bitIndex0)
    <=> v4043(constB7,bitIndex0) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_7,bitIndex1)
    <=> v4043(constB7,bitIndex1) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_7,bitIndex2)
    <=> v4043(constB7,bitIndex2) ) ) ).

fof(is_address_153,axiom,
    address(v4043_range_2_to_0_address_term_bound_7) ).

fof(address_association_112,axiom,
    v4043_range_2_to_0_address_association(constB7,v4043_range_2_to_0_address_term_bound_7) ).

fof(address_false_msb_182,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_6,bitIndex4) ).

fof(address_false_msb_181,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_6,bitIndex3) ).

fof(transient_address_definition_111,axiom,
    ( $true
    & ( addressVal(v4043_range_2_to_0_address_term_bound_6,bitIndex0)
    <=> v4043(constB6,bitIndex0) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_6,bitIndex1)
    <=> v4043(constB6,bitIndex1) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_6,bitIndex2)
    <=> v4043(constB6,bitIndex2) ) ) ).

fof(is_address_152,axiom,
    address(v4043_range_2_to_0_address_term_bound_6) ).

fof(address_association_111,axiom,
    v4043_range_2_to_0_address_association(constB6,v4043_range_2_to_0_address_term_bound_6) ).

fof(address_false_msb_180,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_5,bitIndex4) ).

fof(address_false_msb_179,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_5,bitIndex3) ).

fof(transient_address_definition_110,axiom,
    ( $true
    & ( addressVal(v4043_range_2_to_0_address_term_bound_5,bitIndex0)
    <=> v4043(constB5,bitIndex0) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_5,bitIndex1)
    <=> v4043(constB5,bitIndex1) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_5,bitIndex2)
    <=> v4043(constB5,bitIndex2) ) ) ).

fof(is_address_151,axiom,
    address(v4043_range_2_to_0_address_term_bound_5) ).

fof(address_association_110,axiom,
    v4043_range_2_to_0_address_association(constB5,v4043_range_2_to_0_address_term_bound_5) ).

fof(address_false_msb_178,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_4,bitIndex4) ).

fof(address_false_msb_177,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_4,bitIndex3) ).

fof(transient_address_definition_109,axiom,
    ( $true
    & ( addressVal(v4043_range_2_to_0_address_term_bound_4,bitIndex0)
    <=> v4043(constB4,bitIndex0) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_4,bitIndex1)
    <=> v4043(constB4,bitIndex1) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_4,bitIndex2)
    <=> v4043(constB4,bitIndex2) ) ) ).

fof(is_address_150,axiom,
    address(v4043_range_2_to_0_address_term_bound_4) ).

fof(address_association_109,axiom,
    v4043_range_2_to_0_address_association(constB4,v4043_range_2_to_0_address_term_bound_4) ).

fof(address_false_msb_176,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_3,bitIndex4) ).

fof(address_false_msb_175,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_3,bitIndex3) ).

fof(transient_address_definition_108,axiom,
    ( $true
    & ( addressVal(v4043_range_2_to_0_address_term_bound_3,bitIndex0)
    <=> v4043(constB3,bitIndex0) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_3,bitIndex1)
    <=> v4043(constB3,bitIndex1) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_3,bitIndex2)
    <=> v4043(constB3,bitIndex2) ) ) ).

fof(is_address_149,axiom,
    address(v4043_range_2_to_0_address_term_bound_3) ).

fof(address_association_108,axiom,
    v4043_range_2_to_0_address_association(constB3,v4043_range_2_to_0_address_term_bound_3) ).

fof(address_false_msb_174,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_2,bitIndex4) ).

fof(address_false_msb_173,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_2,bitIndex3) ).

fof(transient_address_definition_107,axiom,
    ( $true
    & ( addressVal(v4043_range_2_to_0_address_term_bound_2,bitIndex0)
    <=> v4043(constB2,bitIndex0) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_2,bitIndex1)
    <=> v4043(constB2,bitIndex1) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_2,bitIndex2)
    <=> v4043(constB2,bitIndex2) ) ) ).

fof(is_address_148,axiom,
    address(v4043_range_2_to_0_address_term_bound_2) ).

fof(address_association_107,axiom,
    v4043_range_2_to_0_address_association(constB2,v4043_range_2_to_0_address_term_bound_2) ).

fof(address_false_msb_172,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_1,bitIndex4) ).

fof(address_false_msb_171,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_1,bitIndex3) ).

fof(transient_address_definition_106,axiom,
    ( $true
    & ( addressVal(v4043_range_2_to_0_address_term_bound_1,bitIndex0)
    <=> v4043(constB1,bitIndex0) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_1,bitIndex1)
    <=> v4043(constB1,bitIndex1) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_1,bitIndex2)
    <=> v4043(constB1,bitIndex2) ) ) ).

fof(is_address_147,axiom,
    address(v4043_range_2_to_0_address_term_bound_1) ).

fof(address_association_106,axiom,
    v4043_range_2_to_0_address_association(constB1,v4043_range_2_to_0_address_term_bound_1) ).

fof(address_false_msb_170,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_0,bitIndex4) ).

fof(address_false_msb_169,axiom,
    ~ addressVal(v4043_range_2_to_0_address_term_bound_0,bitIndex3) ).

fof(transient_address_definition_105,axiom,
    ( $true
    & ( addressVal(v4043_range_2_to_0_address_term_bound_0,bitIndex0)
    <=> v4043(constB0,bitIndex0) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_0,bitIndex1)
    <=> v4043(constB0,bitIndex1) )
    & ( addressVal(v4043_range_2_to_0_address_term_bound_0,bitIndex2)
    <=> v4043(constB0,bitIndex2) ) ) ).

fof(is_address_146,axiom,
    address(v4043_range_2_to_0_address_term_bound_0) ).

fof(address_association_105,axiom,
    v4043_range_2_to_0_address_association(constB0,v4043_range_2_to_0_address_term_bound_0) ).

fof(address_false_msb_168,axiom,
    ~ addressVal(b101_address_term,bitIndex4) ).

fof(address_false_msb_167,axiom,
    ~ addressVal(b101_address_term,bitIndex3) ).

fof(is_address_145,axiom,
    address(b101_address_term) ).

fof(constant_address_definition_40,axiom,
    ! [B] :
      ( addressVal(b101_address_term,B)
    <=> b101(B) ) ).

fof(address_false_msb_166,axiom,
    ~ addressVal(b011_address_term,bitIndex4) ).

fof(address_false_msb_165,axiom,
    ~ addressVal(b011_address_term,bitIndex3) ).

fof(is_address_144,axiom,
    address(b011_address_term) ).

fof(constant_address_definition_39,axiom,
    ! [B] :
      ( addressVal(b011_address_term,B)
    <=> b011(B) ) ).

fof(address_false_msb_164,axiom,
    ~ addressVal(b000_address_term,bitIndex4) ).

fof(address_false_msb_163,axiom,
    ~ addressVal(b000_address_term,bitIndex3) ).

fof(is_address_143,axiom,
    address(b000_address_term) ).

fof(constant_address_definition_38,axiom,
    ! [B] :
      ( addressVal(b000_address_term,B)
    <=> b000(B) ) ).

fof(address_false_msb_162,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_20,bitIndex4) ).

fof(address_false_msb_161,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_20,bitIndex3) ).

fof(transient_address_definition_104,axiom,
    ( $true
    & ( addressVal(v4014_range_2_to_0_address_term_bound_20,bitIndex0)
    <=> v4014(constB20,bitIndex0) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_20,bitIndex1)
    <=> v4014(constB20,bitIndex1) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_20,bitIndex2)
    <=> v4014(constB20,bitIndex2) ) ) ).

fof(is_address_142,axiom,
    address(v4014_range_2_to_0_address_term_bound_20) ).

fof(address_association_104,axiom,
    v4014_range_2_to_0_address_association(constB20,v4014_range_2_to_0_address_term_bound_20) ).

fof(address_false_msb_160,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_19,bitIndex4) ).

fof(address_false_msb_159,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_19,bitIndex3) ).

fof(transient_address_definition_103,axiom,
    ( $true
    & ( addressVal(v4014_range_2_to_0_address_term_bound_19,bitIndex0)
    <=> v4014(constB19,bitIndex0) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_19,bitIndex1)
    <=> v4014(constB19,bitIndex1) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_19,bitIndex2)
    <=> v4014(constB19,bitIndex2) ) ) ).

fof(is_address_141,axiom,
    address(v4014_range_2_to_0_address_term_bound_19) ).

fof(address_association_103,axiom,
    v4014_range_2_to_0_address_association(constB19,v4014_range_2_to_0_address_term_bound_19) ).

fof(address_false_msb_158,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_18,bitIndex4) ).

fof(address_false_msb_157,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_18,bitIndex3) ).

fof(transient_address_definition_102,axiom,
    ( $true
    & ( addressVal(v4014_range_2_to_0_address_term_bound_18,bitIndex0)
    <=> v4014(constB18,bitIndex0) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_18,bitIndex1)
    <=> v4014(constB18,bitIndex1) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_18,bitIndex2)
    <=> v4014(constB18,bitIndex2) ) ) ).

fof(is_address_140,axiom,
    address(v4014_range_2_to_0_address_term_bound_18) ).

fof(address_association_102,axiom,
    v4014_range_2_to_0_address_association(constB18,v4014_range_2_to_0_address_term_bound_18) ).

fof(address_false_msb_156,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_17,bitIndex4) ).

fof(address_false_msb_155,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_17,bitIndex3) ).

fof(transient_address_definition_101,axiom,
    ( $true
    & ( addressVal(v4014_range_2_to_0_address_term_bound_17,bitIndex0)
    <=> v4014(constB17,bitIndex0) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_17,bitIndex1)
    <=> v4014(constB17,bitIndex1) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_17,bitIndex2)
    <=> v4014(constB17,bitIndex2) ) ) ).

fof(is_address_139,axiom,
    address(v4014_range_2_to_0_address_term_bound_17) ).

fof(address_association_101,axiom,
    v4014_range_2_to_0_address_association(constB17,v4014_range_2_to_0_address_term_bound_17) ).

fof(address_false_msb_154,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_16,bitIndex4) ).

fof(address_false_msb_153,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_16,bitIndex3) ).

fof(transient_address_definition_100,axiom,
    ( $true
    & ( addressVal(v4014_range_2_to_0_address_term_bound_16,bitIndex0)
    <=> v4014(constB16,bitIndex0) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_16,bitIndex1)
    <=> v4014(constB16,bitIndex1) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_16,bitIndex2)
    <=> v4014(constB16,bitIndex2) ) ) ).

fof(is_address_138,axiom,
    address(v4014_range_2_to_0_address_term_bound_16) ).

fof(address_association_100,axiom,
    v4014_range_2_to_0_address_association(constB16,v4014_range_2_to_0_address_term_bound_16) ).

fof(address_false_msb_152,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_15,bitIndex4) ).

fof(address_false_msb_151,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_15,bitIndex3) ).

fof(transient_address_definition_99,axiom,
    ( $true
    & ( addressVal(v4014_range_2_to_0_address_term_bound_15,bitIndex0)
    <=> v4014(constB15,bitIndex0) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_15,bitIndex1)
    <=> v4014(constB15,bitIndex1) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_15,bitIndex2)
    <=> v4014(constB15,bitIndex2) ) ) ).

fof(is_address_137,axiom,
    address(v4014_range_2_to_0_address_term_bound_15) ).

fof(address_association_99,axiom,
    v4014_range_2_to_0_address_association(constB15,v4014_range_2_to_0_address_term_bound_15) ).

fof(address_false_msb_150,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_14,bitIndex4) ).

fof(address_false_msb_149,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_14,bitIndex3) ).

fof(transient_address_definition_98,axiom,
    ( $true
    & ( addressVal(v4014_range_2_to_0_address_term_bound_14,bitIndex0)
    <=> v4014(constB14,bitIndex0) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_14,bitIndex1)
    <=> v4014(constB14,bitIndex1) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_14,bitIndex2)
    <=> v4014(constB14,bitIndex2) ) ) ).

fof(is_address_136,axiom,
    address(v4014_range_2_to_0_address_term_bound_14) ).

fof(address_association_98,axiom,
    v4014_range_2_to_0_address_association(constB14,v4014_range_2_to_0_address_term_bound_14) ).

fof(address_false_msb_148,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_13,bitIndex4) ).

fof(address_false_msb_147,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_13,bitIndex3) ).

fof(transient_address_definition_97,axiom,
    ( $true
    & ( addressVal(v4014_range_2_to_0_address_term_bound_13,bitIndex0)
    <=> v4014(constB13,bitIndex0) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_13,bitIndex1)
    <=> v4014(constB13,bitIndex1) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_13,bitIndex2)
    <=> v4014(constB13,bitIndex2) ) ) ).

fof(is_address_135,axiom,
    address(v4014_range_2_to_0_address_term_bound_13) ).

fof(address_association_97,axiom,
    v4014_range_2_to_0_address_association(constB13,v4014_range_2_to_0_address_term_bound_13) ).

fof(address_false_msb_146,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_12,bitIndex4) ).

fof(address_false_msb_145,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_12,bitIndex3) ).

fof(transient_address_definition_96,axiom,
    ( $true
    & ( addressVal(v4014_range_2_to_0_address_term_bound_12,bitIndex0)
    <=> v4014(constB12,bitIndex0) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_12,bitIndex1)
    <=> v4014(constB12,bitIndex1) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_12,bitIndex2)
    <=> v4014(constB12,bitIndex2) ) ) ).

fof(is_address_134,axiom,
    address(v4014_range_2_to_0_address_term_bound_12) ).

fof(address_association_96,axiom,
    v4014_range_2_to_0_address_association(constB12,v4014_range_2_to_0_address_term_bound_12) ).

fof(address_false_msb_144,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_11,bitIndex4) ).

fof(address_false_msb_143,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_11,bitIndex3) ).

fof(transient_address_definition_95,axiom,
    ( $true
    & ( addressVal(v4014_range_2_to_0_address_term_bound_11,bitIndex0)
    <=> v4014(constB11,bitIndex0) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_11,bitIndex1)
    <=> v4014(constB11,bitIndex1) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_11,bitIndex2)
    <=> v4014(constB11,bitIndex2) ) ) ).

fof(is_address_133,axiom,
    address(v4014_range_2_to_0_address_term_bound_11) ).

fof(address_association_95,axiom,
    v4014_range_2_to_0_address_association(constB11,v4014_range_2_to_0_address_term_bound_11) ).

fof(address_false_msb_142,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_10,bitIndex4) ).

fof(address_false_msb_141,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_10,bitIndex3) ).

fof(transient_address_definition_94,axiom,
    ( $true
    & ( addressVal(v4014_range_2_to_0_address_term_bound_10,bitIndex0)
    <=> v4014(constB10,bitIndex0) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_10,bitIndex1)
    <=> v4014(constB10,bitIndex1) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_10,bitIndex2)
    <=> v4014(constB10,bitIndex2) ) ) ).

fof(is_address_132,axiom,
    address(v4014_range_2_to_0_address_term_bound_10) ).

fof(address_association_94,axiom,
    v4014_range_2_to_0_address_association(constB10,v4014_range_2_to_0_address_term_bound_10) ).

fof(address_false_msb_140,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_9,bitIndex4) ).

fof(address_false_msb_139,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_9,bitIndex3) ).

fof(transient_address_definition_93,axiom,
    ( $true
    & ( addressVal(v4014_range_2_to_0_address_term_bound_9,bitIndex0)
    <=> v4014(constB9,bitIndex0) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_9,bitIndex1)
    <=> v4014(constB9,bitIndex1) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_9,bitIndex2)
    <=> v4014(constB9,bitIndex2) ) ) ).

fof(is_address_131,axiom,
    address(v4014_range_2_to_0_address_term_bound_9) ).

fof(address_association_93,axiom,
    v4014_range_2_to_0_address_association(constB9,v4014_range_2_to_0_address_term_bound_9) ).

fof(address_false_msb_138,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_8,bitIndex4) ).

fof(address_false_msb_137,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_8,bitIndex3) ).

fof(transient_address_definition_92,axiom,
    ( $true
    & ( addressVal(v4014_range_2_to_0_address_term_bound_8,bitIndex0)
    <=> v4014(constB8,bitIndex0) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_8,bitIndex1)
    <=> v4014(constB8,bitIndex1) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_8,bitIndex2)
    <=> v4014(constB8,bitIndex2) ) ) ).

fof(is_address_130,axiom,
    address(v4014_range_2_to_0_address_term_bound_8) ).

fof(address_association_92,axiom,
    v4014_range_2_to_0_address_association(constB8,v4014_range_2_to_0_address_term_bound_8) ).

fof(address_false_msb_136,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_7,bitIndex4) ).

fof(address_false_msb_135,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_7,bitIndex3) ).

fof(transient_address_definition_91,axiom,
    ( $true
    & ( addressVal(v4014_range_2_to_0_address_term_bound_7,bitIndex0)
    <=> v4014(constB7,bitIndex0) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_7,bitIndex1)
    <=> v4014(constB7,bitIndex1) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_7,bitIndex2)
    <=> v4014(constB7,bitIndex2) ) ) ).

fof(is_address_129,axiom,
    address(v4014_range_2_to_0_address_term_bound_7) ).

fof(address_association_91,axiom,
    v4014_range_2_to_0_address_association(constB7,v4014_range_2_to_0_address_term_bound_7) ).

fof(address_false_msb_134,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_6,bitIndex4) ).

fof(address_false_msb_133,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_6,bitIndex3) ).

fof(transient_address_definition_90,axiom,
    ( $true
    & ( addressVal(v4014_range_2_to_0_address_term_bound_6,bitIndex0)
    <=> v4014(constB6,bitIndex0) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_6,bitIndex1)
    <=> v4014(constB6,bitIndex1) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_6,bitIndex2)
    <=> v4014(constB6,bitIndex2) ) ) ).

fof(is_address_128,axiom,
    address(v4014_range_2_to_0_address_term_bound_6) ).

fof(address_association_90,axiom,
    v4014_range_2_to_0_address_association(constB6,v4014_range_2_to_0_address_term_bound_6) ).

fof(address_false_msb_132,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_5,bitIndex4) ).

fof(address_false_msb_131,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_5,bitIndex3) ).

fof(transient_address_definition_89,axiom,
    ( $true
    & ( addressVal(v4014_range_2_to_0_address_term_bound_5,bitIndex0)
    <=> v4014(constB5,bitIndex0) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_5,bitIndex1)
    <=> v4014(constB5,bitIndex1) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_5,bitIndex2)
    <=> v4014(constB5,bitIndex2) ) ) ).

fof(is_address_127,axiom,
    address(v4014_range_2_to_0_address_term_bound_5) ).

fof(address_association_89,axiom,
    v4014_range_2_to_0_address_association(constB5,v4014_range_2_to_0_address_term_bound_5) ).

fof(address_false_msb_130,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_4,bitIndex4) ).

fof(address_false_msb_129,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_4,bitIndex3) ).

fof(transient_address_definition_88,axiom,
    ( $true
    & ( addressVal(v4014_range_2_to_0_address_term_bound_4,bitIndex0)
    <=> v4014(constB4,bitIndex0) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_4,bitIndex1)
    <=> v4014(constB4,bitIndex1) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_4,bitIndex2)
    <=> v4014(constB4,bitIndex2) ) ) ).

fof(is_address_126,axiom,
    address(v4014_range_2_to_0_address_term_bound_4) ).

fof(address_association_88,axiom,
    v4014_range_2_to_0_address_association(constB4,v4014_range_2_to_0_address_term_bound_4) ).

fof(address_false_msb_128,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_3,bitIndex4) ).

fof(address_false_msb_127,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_3,bitIndex3) ).

fof(transient_address_definition_87,axiom,
    ( $true
    & ( addressVal(v4014_range_2_to_0_address_term_bound_3,bitIndex0)
    <=> v4014(constB3,bitIndex0) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_3,bitIndex1)
    <=> v4014(constB3,bitIndex1) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_3,bitIndex2)
    <=> v4014(constB3,bitIndex2) ) ) ).

fof(is_address_125,axiom,
    address(v4014_range_2_to_0_address_term_bound_3) ).

fof(address_association_87,axiom,
    v4014_range_2_to_0_address_association(constB3,v4014_range_2_to_0_address_term_bound_3) ).

fof(address_false_msb_126,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_2,bitIndex4) ).

fof(address_false_msb_125,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_2,bitIndex3) ).

fof(transient_address_definition_86,axiom,
    ( $true
    & ( addressVal(v4014_range_2_to_0_address_term_bound_2,bitIndex0)
    <=> v4014(constB2,bitIndex0) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_2,bitIndex1)
    <=> v4014(constB2,bitIndex1) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_2,bitIndex2)
    <=> v4014(constB2,bitIndex2) ) ) ).

fof(is_address_124,axiom,
    address(v4014_range_2_to_0_address_term_bound_2) ).

fof(address_association_86,axiom,
    v4014_range_2_to_0_address_association(constB2,v4014_range_2_to_0_address_term_bound_2) ).

fof(address_false_msb_124,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_1,bitIndex4) ).

fof(address_false_msb_123,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_1,bitIndex3) ).

fof(transient_address_definition_85,axiom,
    ( $true
    & ( addressVal(v4014_range_2_to_0_address_term_bound_1,bitIndex0)
    <=> v4014(constB1,bitIndex0) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_1,bitIndex1)
    <=> v4014(constB1,bitIndex1) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_1,bitIndex2)
    <=> v4014(constB1,bitIndex2) ) ) ).

fof(is_address_123,axiom,
    address(v4014_range_2_to_0_address_term_bound_1) ).

fof(address_association_85,axiom,
    v4014_range_2_to_0_address_association(constB1,v4014_range_2_to_0_address_term_bound_1) ).

fof(address_false_msb_122,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_0,bitIndex4) ).

fof(address_false_msb_121,axiom,
    ~ addressVal(v4014_range_2_to_0_address_term_bound_0,bitIndex3) ).

fof(transient_address_definition_84,axiom,
    ( $true
    & ( addressVal(v4014_range_2_to_0_address_term_bound_0,bitIndex0)
    <=> v4014(constB0,bitIndex0) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_0,bitIndex1)
    <=> v4014(constB0,bitIndex1) )
    & ( addressVal(v4014_range_2_to_0_address_term_bound_0,bitIndex2)
    <=> v4014(constB0,bitIndex2) ) ) ).

fof(is_address_122,axiom,
    address(v4014_range_2_to_0_address_term_bound_0) ).

fof(address_association_84,axiom,
    v4014_range_2_to_0_address_association(constB0,v4014_range_2_to_0_address_term_bound_0) ).

fof(is_address_121,axiom,
    address(b11111_address_term) ).

fof(constant_address_definition_37,axiom,
    ! [B] :
      ( addressVal(b11111_address_term,B)
    <=> b11111(B) ) ).

fof(address_false_msb_120,axiom,
    ~ addressVal(b1110_address_term,bitIndex4) ).

fof(is_address_120,axiom,
    address(b1110_address_term) ).

fof(constant_address_definition_36,axiom,
    ! [B] :
      ( addressVal(b1110_address_term,B)
    <=> b1110(B) ) ).

fof(address_false_msb_119,axiom,
    ~ addressVal(b1000_address_term,bitIndex4) ).

fof(is_address_119,axiom,
    address(b1000_address_term) ).

fof(constant_address_definition_35,axiom,
    ! [B] :
      ( addressVal(b1000_address_term,B)
    <=> b1000(B) ) ).

fof(address_false_msb_118,axiom,
    ~ addressVal(b001_address_term,bitIndex4) ).

fof(address_false_msb_117,axiom,
    ~ addressVal(b001_address_term,bitIndex3) ).

fof(is_address_118,axiom,
    address(b001_address_term) ).

fof(constant_address_definition_34,axiom,
    ! [B] :
      ( addressVal(b001_address_term,B)
    <=> b001(B) ) ).

fof(address_false_msb_116,axiom,
    ~ addressVal(b010_address_term,bitIndex4) ).

fof(address_false_msb_115,axiom,
    ~ addressVal(b010_address_term,bitIndex3) ).

fof(is_address_117,axiom,
    address(b010_address_term) ).

fof(constant_address_definition_33,axiom,
    ! [B] :
      ( addressVal(b010_address_term,B)
    <=> b010(B) ) ).

fof(address_false_msb_114,axiom,
    ~ addressVal(b0111_address_term,bitIndex4) ).

fof(is_address_116,axiom,
    address(b0111_address_term) ).

fof(constant_address_definition_32,axiom,
    ! [B] :
      ( addressVal(b0111_address_term,B)
    <=> b0111(B) ) ).

fof(address_false_msb_113,axiom,
    ~ addressVal(b1111_address_term,bitIndex4) ).

fof(is_address_115,axiom,
    address(b1111_address_term) ).

fof(constant_address_definition_31,axiom,
    ! [B] :
      ( addressVal(b1111_address_term,B)
    <=> b1111(B) ) ).

fof(address_false_msb_112,axiom,
    ~ addressVal(b1101_address_term,bitIndex4) ).

fof(is_address_114,axiom,
    address(b1101_address_term) ).

fof(constant_address_definition_30,axiom,
    ! [B] :
      ( addressVal(b1101_address_term,B)
    <=> b1101(B) ) ).

fof(address_false_msb_111,axiom,
    ~ addressVal(b1100_address_term,bitIndex4) ).

fof(is_address_113,axiom,
    address(b1100_address_term) ).

fof(constant_address_definition_29,axiom,
    ! [B] :
      ( addressVal(b1100_address_term,B)
    <=> b1100(B) ) ).

fof(address_false_msb_110,axiom,
    ~ addressVal(b1011_address_term,bitIndex4) ).

fof(is_address_112,axiom,
    address(b1011_address_term) ).

fof(constant_address_definition_28,axiom,
    ! [B] :
      ( addressVal(b1011_address_term,B)
    <=> b1011(B) ) ).

fof(address_false_msb_109,axiom,
    ~ addressVal(b1010_address_term,bitIndex4) ).

fof(is_address_111,axiom,
    address(b1010_address_term) ).

fof(constant_address_definition_27,axiom,
    ! [B] :
      ( addressVal(b1010_address_term,B)
    <=> b1010(B) ) ).

fof(address_false_msb_108,axiom,
    ~ addressVal(b1001_address_term,bitIndex4) ).

fof(is_address_110,axiom,
    address(b1001_address_term) ).

fof(constant_address_definition_26,axiom,
    ! [B] :
      ( addressVal(b1001_address_term,B)
    <=> b1001(B) ) ).

fof(address_false_msb_107,axiom,
    ~ addressVal(b0101_address_term,bitIndex4) ).

fof(is_address_109,axiom,
    address(b0101_address_term) ).

fof(constant_address_definition_25,axiom,
    ! [B] :
      ( addressVal(b0101_address_term,B)
    <=> b0101(B) ) ).

fof(address_false_msb_106,axiom,
    ~ addressVal(b0100_address_term,bitIndex4) ).

fof(is_address_108,axiom,
    address(b0100_address_term) ).

fof(constant_address_definition_24,axiom,
    ! [B] :
      ( addressVal(b0100_address_term,B)
    <=> b0100(B) ) ).

fof(address_false_msb_105,axiom,
    ~ addressVal(b0011_address_term,bitIndex4) ).

fof(is_address_107,axiom,
    address(b0011_address_term) ).

fof(constant_address_definition_23,axiom,
    ! [B] :
      ( addressVal(b0011_address_term,B)
    <=> b0011(B) ) ).

fof(address_false_msb_104,axiom,
    ~ addressVal(b0010_address_term,bitIndex4) ).

fof(is_address_106,axiom,
    address(b0010_address_term) ).

fof(constant_address_definition_22,axiom,
    ! [B] :
      ( addressVal(b0010_address_term,B)
    <=> b0010(B) ) ).

fof(address_false_msb_103,axiom,
    ~ addressVal(b0001_address_term,bitIndex4) ).

fof(is_address_105,axiom,
    address(b0001_address_term) ).

fof(constant_address_definition_21,axiom,
    ! [B] :
      ( addressVal(b0001_address_term,B)
    <=> b0001(B) ) ).

fof(address_false_msb_102,axiom,
    ~ addressVal(v624_range_3_to_0_address_term_bound_20,bitIndex4) ).

fof(transient_address_definition_83,axiom,
    ( $true
    & ( addressVal(v624_range_3_to_0_address_term_bound_20,bitIndex0)
    <=> v624(constB20,bitIndex0) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_20,bitIndex1)
    <=> v624(constB20,bitIndex1) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_20,bitIndex2)
    <=> v624(constB20,bitIndex2) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_20,bitIndex3)
    <=> v624(constB20,bitIndex3) ) ) ).

fof(is_address_104,axiom,
    address(v624_range_3_to_0_address_term_bound_20) ).

fof(address_association_83,axiom,
    v624_range_3_to_0_address_association(constB20,v624_range_3_to_0_address_term_bound_20) ).

fof(address_false_msb_101,axiom,
    ~ addressVal(v624_range_3_to_0_address_term_bound_19,bitIndex4) ).

fof(transient_address_definition_82,axiom,
    ( $true
    & ( addressVal(v624_range_3_to_0_address_term_bound_19,bitIndex0)
    <=> v624(constB19,bitIndex0) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_19,bitIndex1)
    <=> v624(constB19,bitIndex1) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_19,bitIndex2)
    <=> v624(constB19,bitIndex2) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_19,bitIndex3)
    <=> v624(constB19,bitIndex3) ) ) ).

fof(is_address_103,axiom,
    address(v624_range_3_to_0_address_term_bound_19) ).

fof(address_association_82,axiom,
    v624_range_3_to_0_address_association(constB19,v624_range_3_to_0_address_term_bound_19) ).

fof(address_false_msb_100,axiom,
    ~ addressVal(v624_range_3_to_0_address_term_bound_18,bitIndex4) ).

fof(transient_address_definition_81,axiom,
    ( $true
    & ( addressVal(v624_range_3_to_0_address_term_bound_18,bitIndex0)
    <=> v624(constB18,bitIndex0) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_18,bitIndex1)
    <=> v624(constB18,bitIndex1) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_18,bitIndex2)
    <=> v624(constB18,bitIndex2) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_18,bitIndex3)
    <=> v624(constB18,bitIndex3) ) ) ).

fof(is_address_102,axiom,
    address(v624_range_3_to_0_address_term_bound_18) ).

fof(address_association_81,axiom,
    v624_range_3_to_0_address_association(constB18,v624_range_3_to_0_address_term_bound_18) ).

fof(address_false_msb_99,axiom,
    ~ addressVal(v624_range_3_to_0_address_term_bound_17,bitIndex4) ).

fof(transient_address_definition_80,axiom,
    ( $true
    & ( addressVal(v624_range_3_to_0_address_term_bound_17,bitIndex0)
    <=> v624(constB17,bitIndex0) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_17,bitIndex1)
    <=> v624(constB17,bitIndex1) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_17,bitIndex2)
    <=> v624(constB17,bitIndex2) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_17,bitIndex3)
    <=> v624(constB17,bitIndex3) ) ) ).

fof(is_address_101,axiom,
    address(v624_range_3_to_0_address_term_bound_17) ).

fof(address_association_80,axiom,
    v624_range_3_to_0_address_association(constB17,v624_range_3_to_0_address_term_bound_17) ).

fof(address_false_msb_98,axiom,
    ~ addressVal(v624_range_3_to_0_address_term_bound_16,bitIndex4) ).

fof(transient_address_definition_79,axiom,
    ( $true
    & ( addressVal(v624_range_3_to_0_address_term_bound_16,bitIndex0)
    <=> v624(constB16,bitIndex0) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_16,bitIndex1)
    <=> v624(constB16,bitIndex1) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_16,bitIndex2)
    <=> v624(constB16,bitIndex2) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_16,bitIndex3)
    <=> v624(constB16,bitIndex3) ) ) ).

fof(is_address_100,axiom,
    address(v624_range_3_to_0_address_term_bound_16) ).

fof(address_association_79,axiom,
    v624_range_3_to_0_address_association(constB16,v624_range_3_to_0_address_term_bound_16) ).

fof(address_false_msb_97,axiom,
    ~ addressVal(v624_range_3_to_0_address_term_bound_15,bitIndex4) ).

fof(transient_address_definition_78,axiom,
    ( $true
    & ( addressVal(v624_range_3_to_0_address_term_bound_15,bitIndex0)
    <=> v624(constB15,bitIndex0) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_15,bitIndex1)
    <=> v624(constB15,bitIndex1) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_15,bitIndex2)
    <=> v624(constB15,bitIndex2) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_15,bitIndex3)
    <=> v624(constB15,bitIndex3) ) ) ).

fof(is_address_99,axiom,
    address(v624_range_3_to_0_address_term_bound_15) ).

fof(address_association_78,axiom,
    v624_range_3_to_0_address_association(constB15,v624_range_3_to_0_address_term_bound_15) ).

fof(address_false_msb_96,axiom,
    ~ addressVal(v624_range_3_to_0_address_term_bound_14,bitIndex4) ).

fof(transient_address_definition_77,axiom,
    ( $true
    & ( addressVal(v624_range_3_to_0_address_term_bound_14,bitIndex0)
    <=> v624(constB14,bitIndex0) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_14,bitIndex1)
    <=> v624(constB14,bitIndex1) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_14,bitIndex2)
    <=> v624(constB14,bitIndex2) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_14,bitIndex3)
    <=> v624(constB14,bitIndex3) ) ) ).

fof(is_address_98,axiom,
    address(v624_range_3_to_0_address_term_bound_14) ).

fof(address_association_77,axiom,
    v624_range_3_to_0_address_association(constB14,v624_range_3_to_0_address_term_bound_14) ).

fof(address_false_msb_95,axiom,
    ~ addressVal(v624_range_3_to_0_address_term_bound_13,bitIndex4) ).

fof(transient_address_definition_76,axiom,
    ( $true
    & ( addressVal(v624_range_3_to_0_address_term_bound_13,bitIndex0)
    <=> v624(constB13,bitIndex0) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_13,bitIndex1)
    <=> v624(constB13,bitIndex1) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_13,bitIndex2)
    <=> v624(constB13,bitIndex2) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_13,bitIndex3)
    <=> v624(constB13,bitIndex3) ) ) ).

fof(is_address_97,axiom,
    address(v624_range_3_to_0_address_term_bound_13) ).

fof(address_association_76,axiom,
    v624_range_3_to_0_address_association(constB13,v624_range_3_to_0_address_term_bound_13) ).

fof(address_false_msb_94,axiom,
    ~ addressVal(v624_range_3_to_0_address_term_bound_12,bitIndex4) ).

fof(transient_address_definition_75,axiom,
    ( $true
    & ( addressVal(v624_range_3_to_0_address_term_bound_12,bitIndex0)
    <=> v624(constB12,bitIndex0) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_12,bitIndex1)
    <=> v624(constB12,bitIndex1) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_12,bitIndex2)
    <=> v624(constB12,bitIndex2) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_12,bitIndex3)
    <=> v624(constB12,bitIndex3) ) ) ).

fof(is_address_96,axiom,
    address(v624_range_3_to_0_address_term_bound_12) ).

fof(address_association_75,axiom,
    v624_range_3_to_0_address_association(constB12,v624_range_3_to_0_address_term_bound_12) ).

fof(address_false_msb_93,axiom,
    ~ addressVal(v624_range_3_to_0_address_term_bound_11,bitIndex4) ).

fof(transient_address_definition_74,axiom,
    ( $true
    & ( addressVal(v624_range_3_to_0_address_term_bound_11,bitIndex0)
    <=> v624(constB11,bitIndex0) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_11,bitIndex1)
    <=> v624(constB11,bitIndex1) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_11,bitIndex2)
    <=> v624(constB11,bitIndex2) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_11,bitIndex3)
    <=> v624(constB11,bitIndex3) ) ) ).

fof(is_address_95,axiom,
    address(v624_range_3_to_0_address_term_bound_11) ).

fof(address_association_74,axiom,
    v624_range_3_to_0_address_association(constB11,v624_range_3_to_0_address_term_bound_11) ).

fof(address_false_msb_92,axiom,
    ~ addressVal(v624_range_3_to_0_address_term_bound_10,bitIndex4) ).

fof(transient_address_definition_73,axiom,
    ( $true
    & ( addressVal(v624_range_3_to_0_address_term_bound_10,bitIndex0)
    <=> v624(constB10,bitIndex0) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_10,bitIndex1)
    <=> v624(constB10,bitIndex1) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_10,bitIndex2)
    <=> v624(constB10,bitIndex2) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_10,bitIndex3)
    <=> v624(constB10,bitIndex3) ) ) ).

fof(is_address_94,axiom,
    address(v624_range_3_to_0_address_term_bound_10) ).

fof(address_association_73,axiom,
    v624_range_3_to_0_address_association(constB10,v624_range_3_to_0_address_term_bound_10) ).

fof(address_false_msb_91,axiom,
    ~ addressVal(v624_range_3_to_0_address_term_bound_9,bitIndex4) ).

fof(transient_address_definition_72,axiom,
    ( $true
    & ( addressVal(v624_range_3_to_0_address_term_bound_9,bitIndex0)
    <=> v624(constB9,bitIndex0) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_9,bitIndex1)
    <=> v624(constB9,bitIndex1) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_9,bitIndex2)
    <=> v624(constB9,bitIndex2) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_9,bitIndex3)
    <=> v624(constB9,bitIndex3) ) ) ).

fof(is_address_93,axiom,
    address(v624_range_3_to_0_address_term_bound_9) ).

fof(address_association_72,axiom,
    v624_range_3_to_0_address_association(constB9,v624_range_3_to_0_address_term_bound_9) ).

fof(address_false_msb_90,axiom,
    ~ addressVal(v624_range_3_to_0_address_term_bound_8,bitIndex4) ).

fof(transient_address_definition_71,axiom,
    ( $true
    & ( addressVal(v624_range_3_to_0_address_term_bound_8,bitIndex0)
    <=> v624(constB8,bitIndex0) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_8,bitIndex1)
    <=> v624(constB8,bitIndex1) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_8,bitIndex2)
    <=> v624(constB8,bitIndex2) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_8,bitIndex3)
    <=> v624(constB8,bitIndex3) ) ) ).

fof(is_address_92,axiom,
    address(v624_range_3_to_0_address_term_bound_8) ).

fof(address_association_71,axiom,
    v624_range_3_to_0_address_association(constB8,v624_range_3_to_0_address_term_bound_8) ).

fof(address_false_msb_89,axiom,
    ~ addressVal(v624_range_3_to_0_address_term_bound_7,bitIndex4) ).

fof(transient_address_definition_70,axiom,
    ( $true
    & ( addressVal(v624_range_3_to_0_address_term_bound_7,bitIndex0)
    <=> v624(constB7,bitIndex0) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_7,bitIndex1)
    <=> v624(constB7,bitIndex1) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_7,bitIndex2)
    <=> v624(constB7,bitIndex2) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_7,bitIndex3)
    <=> v624(constB7,bitIndex3) ) ) ).

fof(is_address_91,axiom,
    address(v624_range_3_to_0_address_term_bound_7) ).

fof(address_association_70,axiom,
    v624_range_3_to_0_address_association(constB7,v624_range_3_to_0_address_term_bound_7) ).

fof(address_false_msb_88,axiom,
    ~ addressVal(v624_range_3_to_0_address_term_bound_6,bitIndex4) ).

fof(transient_address_definition_69,axiom,
    ( $true
    & ( addressVal(v624_range_3_to_0_address_term_bound_6,bitIndex0)
    <=> v624(constB6,bitIndex0) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_6,bitIndex1)
    <=> v624(constB6,bitIndex1) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_6,bitIndex2)
    <=> v624(constB6,bitIndex2) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_6,bitIndex3)
    <=> v624(constB6,bitIndex3) ) ) ).

fof(is_address_90,axiom,
    address(v624_range_3_to_0_address_term_bound_6) ).

fof(address_association_69,axiom,
    v624_range_3_to_0_address_association(constB6,v624_range_3_to_0_address_term_bound_6) ).

fof(address_false_msb_87,axiom,
    ~ addressVal(v624_range_3_to_0_address_term_bound_5,bitIndex4) ).

fof(transient_address_definition_68,axiom,
    ( $true
    & ( addressVal(v624_range_3_to_0_address_term_bound_5,bitIndex0)
    <=> v624(constB5,bitIndex0) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_5,bitIndex1)
    <=> v624(constB5,bitIndex1) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_5,bitIndex2)
    <=> v624(constB5,bitIndex2) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_5,bitIndex3)
    <=> v624(constB5,bitIndex3) ) ) ).

fof(is_address_89,axiom,
    address(v624_range_3_to_0_address_term_bound_5) ).

fof(address_association_68,axiom,
    v624_range_3_to_0_address_association(constB5,v624_range_3_to_0_address_term_bound_5) ).

fof(address_false_msb_86,axiom,
    ~ addressVal(v624_range_3_to_0_address_term_bound_4,bitIndex4) ).

fof(transient_address_definition_67,axiom,
    ( $true
    & ( addressVal(v624_range_3_to_0_address_term_bound_4,bitIndex0)
    <=> v624(constB4,bitIndex0) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_4,bitIndex1)
    <=> v624(constB4,bitIndex1) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_4,bitIndex2)
    <=> v624(constB4,bitIndex2) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_4,bitIndex3)
    <=> v624(constB4,bitIndex3) ) ) ).

fof(is_address_88,axiom,
    address(v624_range_3_to_0_address_term_bound_4) ).

fof(address_association_67,axiom,
    v624_range_3_to_0_address_association(constB4,v624_range_3_to_0_address_term_bound_4) ).

fof(address_false_msb_85,axiom,
    ~ addressVal(v624_range_3_to_0_address_term_bound_3,bitIndex4) ).

fof(transient_address_definition_66,axiom,
    ( $true
    & ( addressVal(v624_range_3_to_0_address_term_bound_3,bitIndex0)
    <=> v624(constB3,bitIndex0) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_3,bitIndex1)
    <=> v624(constB3,bitIndex1) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_3,bitIndex2)
    <=> v624(constB3,bitIndex2) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_3,bitIndex3)
    <=> v624(constB3,bitIndex3) ) ) ).

fof(is_address_87,axiom,
    address(v624_range_3_to_0_address_term_bound_3) ).

fof(address_association_66,axiom,
    v624_range_3_to_0_address_association(constB3,v624_range_3_to_0_address_term_bound_3) ).

fof(address_false_msb_84,axiom,
    ~ addressVal(v624_range_3_to_0_address_term_bound_2,bitIndex4) ).

fof(transient_address_definition_65,axiom,
    ( $true
    & ( addressVal(v624_range_3_to_0_address_term_bound_2,bitIndex0)
    <=> v624(constB2,bitIndex0) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_2,bitIndex1)
    <=> v624(constB2,bitIndex1) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_2,bitIndex2)
    <=> v624(constB2,bitIndex2) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_2,bitIndex3)
    <=> v624(constB2,bitIndex3) ) ) ).

fof(is_address_86,axiom,
    address(v624_range_3_to_0_address_term_bound_2) ).

fof(address_association_65,axiom,
    v624_range_3_to_0_address_association(constB2,v624_range_3_to_0_address_term_bound_2) ).

fof(address_false_msb_83,axiom,
    ~ addressVal(v624_range_3_to_0_address_term_bound_1,bitIndex4) ).

fof(transient_address_definition_64,axiom,
    ( $true
    & ( addressVal(v624_range_3_to_0_address_term_bound_1,bitIndex0)
    <=> v624(constB1,bitIndex0) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_1,bitIndex1)
    <=> v624(constB1,bitIndex1) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_1,bitIndex2)
    <=> v624(constB1,bitIndex2) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_1,bitIndex3)
    <=> v624(constB1,bitIndex3) ) ) ).

fof(is_address_85,axiom,
    address(v624_range_3_to_0_address_term_bound_1) ).

fof(address_association_64,axiom,
    v624_range_3_to_0_address_association(constB1,v624_range_3_to_0_address_term_bound_1) ).

fof(address_false_msb_82,axiom,
    ~ addressVal(v624_range_3_to_0_address_term_bound_0,bitIndex4) ).

fof(transient_address_definition_63,axiom,
    ( $true
    & ( addressVal(v624_range_3_to_0_address_term_bound_0,bitIndex0)
    <=> v624(constB0,bitIndex0) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_0,bitIndex1)
    <=> v624(constB0,bitIndex1) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_0,bitIndex2)
    <=> v624(constB0,bitIndex2) )
    & ( addressVal(v624_range_3_to_0_address_term_bound_0,bitIndex3)
    <=> v624(constB0,bitIndex3) ) ) ).

fof(is_address_84,axiom,
    address(v624_range_3_to_0_address_term_bound_0) ).

fof(address_association_63,axiom,
    v624_range_3_to_0_address_association(constB0,v624_range_3_to_0_address_term_bound_0) ).

fof(address_false_msb_81,axiom,
    ~ addressVal(v596_range_3_to_0_address_term_bound_20,bitIndex4) ).

fof(transient_address_definition_62,axiom,
    ( $true
    & ( addressVal(v596_range_3_to_0_address_term_bound_20,bitIndex0)
    <=> v596(constB20,bitIndex0) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_20,bitIndex1)
    <=> v596(constB20,bitIndex1) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_20,bitIndex2)
    <=> v596(constB20,bitIndex2) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_20,bitIndex3)
    <=> v596(constB20,bitIndex3) ) ) ).

fof(is_address_83,axiom,
    address(v596_range_3_to_0_address_term_bound_20) ).

fof(address_association_62,axiom,
    v596_range_3_to_0_address_association(constB20,v596_range_3_to_0_address_term_bound_20) ).

fof(address_false_msb_80,axiom,
    ~ addressVal(v596_range_3_to_0_address_term_bound_19,bitIndex4) ).

fof(transient_address_definition_61,axiom,
    ( $true
    & ( addressVal(v596_range_3_to_0_address_term_bound_19,bitIndex0)
    <=> v596(constB19,bitIndex0) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_19,bitIndex1)
    <=> v596(constB19,bitIndex1) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_19,bitIndex2)
    <=> v596(constB19,bitIndex2) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_19,bitIndex3)
    <=> v596(constB19,bitIndex3) ) ) ).

fof(is_address_82,axiom,
    address(v596_range_3_to_0_address_term_bound_19) ).

fof(address_association_61,axiom,
    v596_range_3_to_0_address_association(constB19,v596_range_3_to_0_address_term_bound_19) ).

fof(address_false_msb_79,axiom,
    ~ addressVal(v596_range_3_to_0_address_term_bound_18,bitIndex4) ).

fof(transient_address_definition_60,axiom,
    ( $true
    & ( addressVal(v596_range_3_to_0_address_term_bound_18,bitIndex0)
    <=> v596(constB18,bitIndex0) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_18,bitIndex1)
    <=> v596(constB18,bitIndex1) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_18,bitIndex2)
    <=> v596(constB18,bitIndex2) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_18,bitIndex3)
    <=> v596(constB18,bitIndex3) ) ) ).

fof(is_address_81,axiom,
    address(v596_range_3_to_0_address_term_bound_18) ).

fof(address_association_60,axiom,
    v596_range_3_to_0_address_association(constB18,v596_range_3_to_0_address_term_bound_18) ).

fof(address_false_msb_78,axiom,
    ~ addressVal(v596_range_3_to_0_address_term_bound_17,bitIndex4) ).

fof(transient_address_definition_59,axiom,
    ( $true
    & ( addressVal(v596_range_3_to_0_address_term_bound_17,bitIndex0)
    <=> v596(constB17,bitIndex0) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_17,bitIndex1)
    <=> v596(constB17,bitIndex1) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_17,bitIndex2)
    <=> v596(constB17,bitIndex2) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_17,bitIndex3)
    <=> v596(constB17,bitIndex3) ) ) ).

fof(is_address_80,axiom,
    address(v596_range_3_to_0_address_term_bound_17) ).

fof(address_association_59,axiom,
    v596_range_3_to_0_address_association(constB17,v596_range_3_to_0_address_term_bound_17) ).

fof(address_false_msb_77,axiom,
    ~ addressVal(v596_range_3_to_0_address_term_bound_16,bitIndex4) ).

fof(transient_address_definition_58,axiom,
    ( $true
    & ( addressVal(v596_range_3_to_0_address_term_bound_16,bitIndex0)
    <=> v596(constB16,bitIndex0) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_16,bitIndex1)
    <=> v596(constB16,bitIndex1) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_16,bitIndex2)
    <=> v596(constB16,bitIndex2) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_16,bitIndex3)
    <=> v596(constB16,bitIndex3) ) ) ).

fof(is_address_79,axiom,
    address(v596_range_3_to_0_address_term_bound_16) ).

fof(address_association_58,axiom,
    v596_range_3_to_0_address_association(constB16,v596_range_3_to_0_address_term_bound_16) ).

fof(address_false_msb_76,axiom,
    ~ addressVal(v596_range_3_to_0_address_term_bound_15,bitIndex4) ).

fof(transient_address_definition_57,axiom,
    ( $true
    & ( addressVal(v596_range_3_to_0_address_term_bound_15,bitIndex0)
    <=> v596(constB15,bitIndex0) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_15,bitIndex1)
    <=> v596(constB15,bitIndex1) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_15,bitIndex2)
    <=> v596(constB15,bitIndex2) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_15,bitIndex3)
    <=> v596(constB15,bitIndex3) ) ) ).

fof(is_address_78,axiom,
    address(v596_range_3_to_0_address_term_bound_15) ).

fof(address_association_57,axiom,
    v596_range_3_to_0_address_association(constB15,v596_range_3_to_0_address_term_bound_15) ).

fof(address_false_msb_75,axiom,
    ~ addressVal(v596_range_3_to_0_address_term_bound_14,bitIndex4) ).

fof(transient_address_definition_56,axiom,
    ( $true
    & ( addressVal(v596_range_3_to_0_address_term_bound_14,bitIndex0)
    <=> v596(constB14,bitIndex0) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_14,bitIndex1)
    <=> v596(constB14,bitIndex1) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_14,bitIndex2)
    <=> v596(constB14,bitIndex2) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_14,bitIndex3)
    <=> v596(constB14,bitIndex3) ) ) ).

fof(is_address_77,axiom,
    address(v596_range_3_to_0_address_term_bound_14) ).

fof(address_association_56,axiom,
    v596_range_3_to_0_address_association(constB14,v596_range_3_to_0_address_term_bound_14) ).

fof(address_false_msb_74,axiom,
    ~ addressVal(v596_range_3_to_0_address_term_bound_13,bitIndex4) ).

fof(transient_address_definition_55,axiom,
    ( $true
    & ( addressVal(v596_range_3_to_0_address_term_bound_13,bitIndex0)
    <=> v596(constB13,bitIndex0) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_13,bitIndex1)
    <=> v596(constB13,bitIndex1) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_13,bitIndex2)
    <=> v596(constB13,bitIndex2) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_13,bitIndex3)
    <=> v596(constB13,bitIndex3) ) ) ).

fof(is_address_76,axiom,
    address(v596_range_3_to_0_address_term_bound_13) ).

fof(address_association_55,axiom,
    v596_range_3_to_0_address_association(constB13,v596_range_3_to_0_address_term_bound_13) ).

fof(address_false_msb_73,axiom,
    ~ addressVal(v596_range_3_to_0_address_term_bound_12,bitIndex4) ).

fof(transient_address_definition_54,axiom,
    ( $true
    & ( addressVal(v596_range_3_to_0_address_term_bound_12,bitIndex0)
    <=> v596(constB12,bitIndex0) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_12,bitIndex1)
    <=> v596(constB12,bitIndex1) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_12,bitIndex2)
    <=> v596(constB12,bitIndex2) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_12,bitIndex3)
    <=> v596(constB12,bitIndex3) ) ) ).

fof(is_address_75,axiom,
    address(v596_range_3_to_0_address_term_bound_12) ).

fof(address_association_54,axiom,
    v596_range_3_to_0_address_association(constB12,v596_range_3_to_0_address_term_bound_12) ).

fof(address_false_msb_72,axiom,
    ~ addressVal(v596_range_3_to_0_address_term_bound_11,bitIndex4) ).

fof(transient_address_definition_53,axiom,
    ( $true
    & ( addressVal(v596_range_3_to_0_address_term_bound_11,bitIndex0)
    <=> v596(constB11,bitIndex0) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_11,bitIndex1)
    <=> v596(constB11,bitIndex1) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_11,bitIndex2)
    <=> v596(constB11,bitIndex2) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_11,bitIndex3)
    <=> v596(constB11,bitIndex3) ) ) ).

fof(is_address_74,axiom,
    address(v596_range_3_to_0_address_term_bound_11) ).

fof(address_association_53,axiom,
    v596_range_3_to_0_address_association(constB11,v596_range_3_to_0_address_term_bound_11) ).

fof(address_false_msb_71,axiom,
    ~ addressVal(v596_range_3_to_0_address_term_bound_10,bitIndex4) ).

fof(transient_address_definition_52,axiom,
    ( $true
    & ( addressVal(v596_range_3_to_0_address_term_bound_10,bitIndex0)
    <=> v596(constB10,bitIndex0) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_10,bitIndex1)
    <=> v596(constB10,bitIndex1) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_10,bitIndex2)
    <=> v596(constB10,bitIndex2) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_10,bitIndex3)
    <=> v596(constB10,bitIndex3) ) ) ).

fof(is_address_73,axiom,
    address(v596_range_3_to_0_address_term_bound_10) ).

fof(address_association_52,axiom,
    v596_range_3_to_0_address_association(constB10,v596_range_3_to_0_address_term_bound_10) ).

fof(address_false_msb_70,axiom,
    ~ addressVal(v596_range_3_to_0_address_term_bound_9,bitIndex4) ).

fof(transient_address_definition_51,axiom,
    ( $true
    & ( addressVal(v596_range_3_to_0_address_term_bound_9,bitIndex0)
    <=> v596(constB9,bitIndex0) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_9,bitIndex1)
    <=> v596(constB9,bitIndex1) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_9,bitIndex2)
    <=> v596(constB9,bitIndex2) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_9,bitIndex3)
    <=> v596(constB9,bitIndex3) ) ) ).

fof(is_address_72,axiom,
    address(v596_range_3_to_0_address_term_bound_9) ).

fof(address_association_51,axiom,
    v596_range_3_to_0_address_association(constB9,v596_range_3_to_0_address_term_bound_9) ).

fof(address_false_msb_69,axiom,
    ~ addressVal(v596_range_3_to_0_address_term_bound_8,bitIndex4) ).

fof(transient_address_definition_50,axiom,
    ( $true
    & ( addressVal(v596_range_3_to_0_address_term_bound_8,bitIndex0)
    <=> v596(constB8,bitIndex0) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_8,bitIndex1)
    <=> v596(constB8,bitIndex1) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_8,bitIndex2)
    <=> v596(constB8,bitIndex2) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_8,bitIndex3)
    <=> v596(constB8,bitIndex3) ) ) ).

fof(is_address_71,axiom,
    address(v596_range_3_to_0_address_term_bound_8) ).

fof(address_association_50,axiom,
    v596_range_3_to_0_address_association(constB8,v596_range_3_to_0_address_term_bound_8) ).

fof(address_false_msb_68,axiom,
    ~ addressVal(v596_range_3_to_0_address_term_bound_7,bitIndex4) ).

fof(transient_address_definition_49,axiom,
    ( $true
    & ( addressVal(v596_range_3_to_0_address_term_bound_7,bitIndex0)
    <=> v596(constB7,bitIndex0) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_7,bitIndex1)
    <=> v596(constB7,bitIndex1) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_7,bitIndex2)
    <=> v596(constB7,bitIndex2) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_7,bitIndex3)
    <=> v596(constB7,bitIndex3) ) ) ).

fof(is_address_70,axiom,
    address(v596_range_3_to_0_address_term_bound_7) ).

fof(address_association_49,axiom,
    v596_range_3_to_0_address_association(constB7,v596_range_3_to_0_address_term_bound_7) ).

fof(address_false_msb_67,axiom,
    ~ addressVal(v596_range_3_to_0_address_term_bound_6,bitIndex4) ).

fof(transient_address_definition_48,axiom,
    ( $true
    & ( addressVal(v596_range_3_to_0_address_term_bound_6,bitIndex0)
    <=> v596(constB6,bitIndex0) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_6,bitIndex1)
    <=> v596(constB6,bitIndex1) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_6,bitIndex2)
    <=> v596(constB6,bitIndex2) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_6,bitIndex3)
    <=> v596(constB6,bitIndex3) ) ) ).

fof(is_address_69,axiom,
    address(v596_range_3_to_0_address_term_bound_6) ).

fof(address_association_48,axiom,
    v596_range_3_to_0_address_association(constB6,v596_range_3_to_0_address_term_bound_6) ).

fof(address_false_msb_66,axiom,
    ~ addressVal(v596_range_3_to_0_address_term_bound_5,bitIndex4) ).

fof(transient_address_definition_47,axiom,
    ( $true
    & ( addressVal(v596_range_3_to_0_address_term_bound_5,bitIndex0)
    <=> v596(constB5,bitIndex0) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_5,bitIndex1)
    <=> v596(constB5,bitIndex1) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_5,bitIndex2)
    <=> v596(constB5,bitIndex2) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_5,bitIndex3)
    <=> v596(constB5,bitIndex3) ) ) ).

fof(is_address_68,axiom,
    address(v596_range_3_to_0_address_term_bound_5) ).

fof(address_association_47,axiom,
    v596_range_3_to_0_address_association(constB5,v596_range_3_to_0_address_term_bound_5) ).

fof(address_false_msb_65,axiom,
    ~ addressVal(v596_range_3_to_0_address_term_bound_4,bitIndex4) ).

fof(transient_address_definition_46,axiom,
    ( $true
    & ( addressVal(v596_range_3_to_0_address_term_bound_4,bitIndex0)
    <=> v596(constB4,bitIndex0) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_4,bitIndex1)
    <=> v596(constB4,bitIndex1) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_4,bitIndex2)
    <=> v596(constB4,bitIndex2) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_4,bitIndex3)
    <=> v596(constB4,bitIndex3) ) ) ).

fof(is_address_67,axiom,
    address(v596_range_3_to_0_address_term_bound_4) ).

fof(address_association_46,axiom,
    v596_range_3_to_0_address_association(constB4,v596_range_3_to_0_address_term_bound_4) ).

fof(address_false_msb_64,axiom,
    ~ addressVal(v596_range_3_to_0_address_term_bound_3,bitIndex4) ).

fof(transient_address_definition_45,axiom,
    ( $true
    & ( addressVal(v596_range_3_to_0_address_term_bound_3,bitIndex0)
    <=> v596(constB3,bitIndex0) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_3,bitIndex1)
    <=> v596(constB3,bitIndex1) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_3,bitIndex2)
    <=> v596(constB3,bitIndex2) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_3,bitIndex3)
    <=> v596(constB3,bitIndex3) ) ) ).

fof(is_address_66,axiom,
    address(v596_range_3_to_0_address_term_bound_3) ).

fof(address_association_45,axiom,
    v596_range_3_to_0_address_association(constB3,v596_range_3_to_0_address_term_bound_3) ).

fof(address_false_msb_63,axiom,
    ~ addressVal(v596_range_3_to_0_address_term_bound_2,bitIndex4) ).

fof(transient_address_definition_44,axiom,
    ( $true
    & ( addressVal(v596_range_3_to_0_address_term_bound_2,bitIndex0)
    <=> v596(constB2,bitIndex0) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_2,bitIndex1)
    <=> v596(constB2,bitIndex1) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_2,bitIndex2)
    <=> v596(constB2,bitIndex2) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_2,bitIndex3)
    <=> v596(constB2,bitIndex3) ) ) ).

fof(is_address_65,axiom,
    address(v596_range_3_to_0_address_term_bound_2) ).

fof(address_association_44,axiom,
    v596_range_3_to_0_address_association(constB2,v596_range_3_to_0_address_term_bound_2) ).

fof(address_false_msb_62,axiom,
    ~ addressVal(v596_range_3_to_0_address_term_bound_1,bitIndex4) ).

fof(transient_address_definition_43,axiom,
    ( $true
    & ( addressVal(v596_range_3_to_0_address_term_bound_1,bitIndex0)
    <=> v596(constB1,bitIndex0) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_1,bitIndex1)
    <=> v596(constB1,bitIndex1) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_1,bitIndex2)
    <=> v596(constB1,bitIndex2) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_1,bitIndex3)
    <=> v596(constB1,bitIndex3) ) ) ).

fof(is_address_64,axiom,
    address(v596_range_3_to_0_address_term_bound_1) ).

fof(address_association_43,axiom,
    v596_range_3_to_0_address_association(constB1,v596_range_3_to_0_address_term_bound_1) ).

fof(address_false_msb_61,axiom,
    ~ addressVal(v596_range_3_to_0_address_term_bound_0,bitIndex4) ).

fof(transient_address_definition_42,axiom,
    ( $true
    & ( addressVal(v596_range_3_to_0_address_term_bound_0,bitIndex0)
    <=> v596(constB0,bitIndex0) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_0,bitIndex1)
    <=> v596(constB0,bitIndex1) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_0,bitIndex2)
    <=> v596(constB0,bitIndex2) )
    & ( addressVal(v596_range_3_to_0_address_term_bound_0,bitIndex3)
    <=> v596(constB0,bitIndex3) ) ) ).

fof(is_address_63,axiom,
    address(v596_range_3_to_0_address_term_bound_0) ).

fof(address_association_42,axiom,
    v596_range_3_to_0_address_association(constB0,v596_range_3_to_0_address_term_bound_0) ).

fof(address_false_msb_60,axiom,
    ~ addressVal(b0110_address_term,bitIndex4) ).

fof(is_address_62,axiom,
    address(b0110_address_term) ).

fof(constant_address_definition_20,axiom,
    ! [B] :
      ( addressVal(b0110_address_term,B)
    <=> b0110(B) ) ).

fof(is_address_61,axiom,
    address(b00001_address_term) ).

fof(constant_address_definition_19,axiom,
    ! [B] :
      ( addressVal(b00001_address_term,B)
    <=> b00001(B) ) ).

fof(is_address_60,axiom,
    address(b10000_address_term) ).

fof(constant_address_definition_18,axiom,
    ! [B] :
      ( addressVal(b10000_address_term,B)
    <=> b10000(B) ) ).

fof(is_address_59,axiom,
    address(b00000_address_term) ).

fof(constant_address_definition_17,axiom,
    ! [B] :
      ( addressVal(b00000_address_term,B)
    <=> b00000(B) ) ).

fof(address_false_msb_59,axiom,
    ~ addressVal(v385_range_3_to_0_address_term_bound_20,bitIndex4) ).

fof(transient_address_definition_41,axiom,
    ( $true
    & ( addressVal(v385_range_3_to_0_address_term_bound_20,bitIndex0)
    <=> v385(constB20,bitIndex0) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_20,bitIndex1)
    <=> v385(constB20,bitIndex1) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_20,bitIndex2)
    <=> v385(constB20,bitIndex2) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_20,bitIndex3)
    <=> v385(constB20,bitIndex3) ) ) ).

fof(is_address_58,axiom,
    address(v385_range_3_to_0_address_term_bound_20) ).

fof(address_association_41,axiom,
    v385_range_3_to_0_address_association(constB20,v385_range_3_to_0_address_term_bound_20) ).

fof(address_false_msb_58,axiom,
    ~ addressVal(v385_range_3_to_0_address_term_bound_19,bitIndex4) ).

fof(transient_address_definition_40,axiom,
    ( $true
    & ( addressVal(v385_range_3_to_0_address_term_bound_19,bitIndex0)
    <=> v385(constB19,bitIndex0) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_19,bitIndex1)
    <=> v385(constB19,bitIndex1) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_19,bitIndex2)
    <=> v385(constB19,bitIndex2) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_19,bitIndex3)
    <=> v385(constB19,bitIndex3) ) ) ).

fof(is_address_57,axiom,
    address(v385_range_3_to_0_address_term_bound_19) ).

fof(address_association_40,axiom,
    v385_range_3_to_0_address_association(constB19,v385_range_3_to_0_address_term_bound_19) ).

fof(address_false_msb_57,axiom,
    ~ addressVal(v385_range_3_to_0_address_term_bound_18,bitIndex4) ).

fof(transient_address_definition_39,axiom,
    ( $true
    & ( addressVal(v385_range_3_to_0_address_term_bound_18,bitIndex0)
    <=> v385(constB18,bitIndex0) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_18,bitIndex1)
    <=> v385(constB18,bitIndex1) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_18,bitIndex2)
    <=> v385(constB18,bitIndex2) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_18,bitIndex3)
    <=> v385(constB18,bitIndex3) ) ) ).

fof(is_address_56,axiom,
    address(v385_range_3_to_0_address_term_bound_18) ).

fof(address_association_39,axiom,
    v385_range_3_to_0_address_association(constB18,v385_range_3_to_0_address_term_bound_18) ).

fof(address_false_msb_56,axiom,
    ~ addressVal(v385_range_3_to_0_address_term_bound_17,bitIndex4) ).

fof(transient_address_definition_38,axiom,
    ( $true
    & ( addressVal(v385_range_3_to_0_address_term_bound_17,bitIndex0)
    <=> v385(constB17,bitIndex0) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_17,bitIndex1)
    <=> v385(constB17,bitIndex1) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_17,bitIndex2)
    <=> v385(constB17,bitIndex2) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_17,bitIndex3)
    <=> v385(constB17,bitIndex3) ) ) ).

fof(is_address_55,axiom,
    address(v385_range_3_to_0_address_term_bound_17) ).

fof(address_association_38,axiom,
    v385_range_3_to_0_address_association(constB17,v385_range_3_to_0_address_term_bound_17) ).

fof(address_false_msb_55,axiom,
    ~ addressVal(v385_range_3_to_0_address_term_bound_16,bitIndex4) ).

fof(transient_address_definition_37,axiom,
    ( $true
    & ( addressVal(v385_range_3_to_0_address_term_bound_16,bitIndex0)
    <=> v385(constB16,bitIndex0) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_16,bitIndex1)
    <=> v385(constB16,bitIndex1) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_16,bitIndex2)
    <=> v385(constB16,bitIndex2) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_16,bitIndex3)
    <=> v385(constB16,bitIndex3) ) ) ).

fof(is_address_54,axiom,
    address(v385_range_3_to_0_address_term_bound_16) ).

fof(address_association_37,axiom,
    v385_range_3_to_0_address_association(constB16,v385_range_3_to_0_address_term_bound_16) ).

fof(address_false_msb_54,axiom,
    ~ addressVal(v385_range_3_to_0_address_term_bound_15,bitIndex4) ).

fof(transient_address_definition_36,axiom,
    ( $true
    & ( addressVal(v385_range_3_to_0_address_term_bound_15,bitIndex0)
    <=> v385(constB15,bitIndex0) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_15,bitIndex1)
    <=> v385(constB15,bitIndex1) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_15,bitIndex2)
    <=> v385(constB15,bitIndex2) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_15,bitIndex3)
    <=> v385(constB15,bitIndex3) ) ) ).

fof(is_address_53,axiom,
    address(v385_range_3_to_0_address_term_bound_15) ).

fof(address_association_36,axiom,
    v385_range_3_to_0_address_association(constB15,v385_range_3_to_0_address_term_bound_15) ).

fof(address_false_msb_53,axiom,
    ~ addressVal(v385_range_3_to_0_address_term_bound_14,bitIndex4) ).

fof(transient_address_definition_35,axiom,
    ( $true
    & ( addressVal(v385_range_3_to_0_address_term_bound_14,bitIndex0)
    <=> v385(constB14,bitIndex0) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_14,bitIndex1)
    <=> v385(constB14,bitIndex1) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_14,bitIndex2)
    <=> v385(constB14,bitIndex2) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_14,bitIndex3)
    <=> v385(constB14,bitIndex3) ) ) ).

fof(is_address_52,axiom,
    address(v385_range_3_to_0_address_term_bound_14) ).

fof(address_association_35,axiom,
    v385_range_3_to_0_address_association(constB14,v385_range_3_to_0_address_term_bound_14) ).

fof(address_false_msb_52,axiom,
    ~ addressVal(v385_range_3_to_0_address_term_bound_13,bitIndex4) ).

fof(transient_address_definition_34,axiom,
    ( $true
    & ( addressVal(v385_range_3_to_0_address_term_bound_13,bitIndex0)
    <=> v385(constB13,bitIndex0) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_13,bitIndex1)
    <=> v385(constB13,bitIndex1) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_13,bitIndex2)
    <=> v385(constB13,bitIndex2) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_13,bitIndex3)
    <=> v385(constB13,bitIndex3) ) ) ).

fof(is_address_51,axiom,
    address(v385_range_3_to_0_address_term_bound_13) ).

fof(address_association_34,axiom,
    v385_range_3_to_0_address_association(constB13,v385_range_3_to_0_address_term_bound_13) ).

fof(address_false_msb_51,axiom,
    ~ addressVal(v385_range_3_to_0_address_term_bound_12,bitIndex4) ).

fof(transient_address_definition_33,axiom,
    ( $true
    & ( addressVal(v385_range_3_to_0_address_term_bound_12,bitIndex0)
    <=> v385(constB12,bitIndex0) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_12,bitIndex1)
    <=> v385(constB12,bitIndex1) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_12,bitIndex2)
    <=> v385(constB12,bitIndex2) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_12,bitIndex3)
    <=> v385(constB12,bitIndex3) ) ) ).

fof(is_address_50,axiom,
    address(v385_range_3_to_0_address_term_bound_12) ).

fof(address_association_33,axiom,
    v385_range_3_to_0_address_association(constB12,v385_range_3_to_0_address_term_bound_12) ).

fof(address_false_msb_50,axiom,
    ~ addressVal(v385_range_3_to_0_address_term_bound_11,bitIndex4) ).

fof(transient_address_definition_32,axiom,
    ( $true
    & ( addressVal(v385_range_3_to_0_address_term_bound_11,bitIndex0)
    <=> v385(constB11,bitIndex0) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_11,bitIndex1)
    <=> v385(constB11,bitIndex1) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_11,bitIndex2)
    <=> v385(constB11,bitIndex2) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_11,bitIndex3)
    <=> v385(constB11,bitIndex3) ) ) ).

fof(is_address_49,axiom,
    address(v385_range_3_to_0_address_term_bound_11) ).

fof(address_association_32,axiom,
    v385_range_3_to_0_address_association(constB11,v385_range_3_to_0_address_term_bound_11) ).

fof(address_false_msb_49,axiom,
    ~ addressVal(v385_range_3_to_0_address_term_bound_10,bitIndex4) ).

fof(transient_address_definition_31,axiom,
    ( $true
    & ( addressVal(v385_range_3_to_0_address_term_bound_10,bitIndex0)
    <=> v385(constB10,bitIndex0) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_10,bitIndex1)
    <=> v385(constB10,bitIndex1) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_10,bitIndex2)
    <=> v385(constB10,bitIndex2) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_10,bitIndex3)
    <=> v385(constB10,bitIndex3) ) ) ).

fof(is_address_48,axiom,
    address(v385_range_3_to_0_address_term_bound_10) ).

fof(address_association_31,axiom,
    v385_range_3_to_0_address_association(constB10,v385_range_3_to_0_address_term_bound_10) ).

fof(address_false_msb_48,axiom,
    ~ addressVal(v385_range_3_to_0_address_term_bound_9,bitIndex4) ).

fof(transient_address_definition_30,axiom,
    ( $true
    & ( addressVal(v385_range_3_to_0_address_term_bound_9,bitIndex0)
    <=> v385(constB9,bitIndex0) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_9,bitIndex1)
    <=> v385(constB9,bitIndex1) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_9,bitIndex2)
    <=> v385(constB9,bitIndex2) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_9,bitIndex3)
    <=> v385(constB9,bitIndex3) ) ) ).

fof(is_address_47,axiom,
    address(v385_range_3_to_0_address_term_bound_9) ).

fof(address_association_30,axiom,
    v385_range_3_to_0_address_association(constB9,v385_range_3_to_0_address_term_bound_9) ).

fof(address_false_msb_47,axiom,
    ~ addressVal(v385_range_3_to_0_address_term_bound_8,bitIndex4) ).

fof(transient_address_definition_29,axiom,
    ( $true
    & ( addressVal(v385_range_3_to_0_address_term_bound_8,bitIndex0)
    <=> v385(constB8,bitIndex0) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_8,bitIndex1)
    <=> v385(constB8,bitIndex1) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_8,bitIndex2)
    <=> v385(constB8,bitIndex2) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_8,bitIndex3)
    <=> v385(constB8,bitIndex3) ) ) ).

fof(is_address_46,axiom,
    address(v385_range_3_to_0_address_term_bound_8) ).

fof(address_association_29,axiom,
    v385_range_3_to_0_address_association(constB8,v385_range_3_to_0_address_term_bound_8) ).

fof(address_false_msb_46,axiom,
    ~ addressVal(v385_range_3_to_0_address_term_bound_7,bitIndex4) ).

fof(transient_address_definition_28,axiom,
    ( $true
    & ( addressVal(v385_range_3_to_0_address_term_bound_7,bitIndex0)
    <=> v385(constB7,bitIndex0) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_7,bitIndex1)
    <=> v385(constB7,bitIndex1) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_7,bitIndex2)
    <=> v385(constB7,bitIndex2) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_7,bitIndex3)
    <=> v385(constB7,bitIndex3) ) ) ).

fof(is_address_45,axiom,
    address(v385_range_3_to_0_address_term_bound_7) ).

fof(address_association_28,axiom,
    v385_range_3_to_0_address_association(constB7,v385_range_3_to_0_address_term_bound_7) ).

fof(address_false_msb_45,axiom,
    ~ addressVal(v385_range_3_to_0_address_term_bound_6,bitIndex4) ).

fof(transient_address_definition_27,axiom,
    ( $true
    & ( addressVal(v385_range_3_to_0_address_term_bound_6,bitIndex0)
    <=> v385(constB6,bitIndex0) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_6,bitIndex1)
    <=> v385(constB6,bitIndex1) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_6,bitIndex2)
    <=> v385(constB6,bitIndex2) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_6,bitIndex3)
    <=> v385(constB6,bitIndex3) ) ) ).

fof(is_address_44,axiom,
    address(v385_range_3_to_0_address_term_bound_6) ).

fof(address_association_27,axiom,
    v385_range_3_to_0_address_association(constB6,v385_range_3_to_0_address_term_bound_6) ).

fof(address_false_msb_44,axiom,
    ~ addressVal(v385_range_3_to_0_address_term_bound_5,bitIndex4) ).

fof(transient_address_definition_26,axiom,
    ( $true
    & ( addressVal(v385_range_3_to_0_address_term_bound_5,bitIndex0)
    <=> v385(constB5,bitIndex0) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_5,bitIndex1)
    <=> v385(constB5,bitIndex1) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_5,bitIndex2)
    <=> v385(constB5,bitIndex2) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_5,bitIndex3)
    <=> v385(constB5,bitIndex3) ) ) ).

fof(is_address_43,axiom,
    address(v385_range_3_to_0_address_term_bound_5) ).

fof(address_association_26,axiom,
    v385_range_3_to_0_address_association(constB5,v385_range_3_to_0_address_term_bound_5) ).

fof(address_false_msb_43,axiom,
    ~ addressVal(v385_range_3_to_0_address_term_bound_4,bitIndex4) ).

fof(transient_address_definition_25,axiom,
    ( $true
    & ( addressVal(v385_range_3_to_0_address_term_bound_4,bitIndex0)
    <=> v385(constB4,bitIndex0) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_4,bitIndex1)
    <=> v385(constB4,bitIndex1) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_4,bitIndex2)
    <=> v385(constB4,bitIndex2) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_4,bitIndex3)
    <=> v385(constB4,bitIndex3) ) ) ).

fof(is_address_42,axiom,
    address(v385_range_3_to_0_address_term_bound_4) ).

fof(address_association_25,axiom,
    v385_range_3_to_0_address_association(constB4,v385_range_3_to_0_address_term_bound_4) ).

fof(address_false_msb_42,axiom,
    ~ addressVal(v385_range_3_to_0_address_term_bound_3,bitIndex4) ).

fof(transient_address_definition_24,axiom,
    ( $true
    & ( addressVal(v385_range_3_to_0_address_term_bound_3,bitIndex0)
    <=> v385(constB3,bitIndex0) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_3,bitIndex1)
    <=> v385(constB3,bitIndex1) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_3,bitIndex2)
    <=> v385(constB3,bitIndex2) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_3,bitIndex3)
    <=> v385(constB3,bitIndex3) ) ) ).

fof(is_address_41,axiom,
    address(v385_range_3_to_0_address_term_bound_3) ).

fof(address_association_24,axiom,
    v385_range_3_to_0_address_association(constB3,v385_range_3_to_0_address_term_bound_3) ).

fof(address_false_msb_41,axiom,
    ~ addressVal(v385_range_3_to_0_address_term_bound_2,bitIndex4) ).

fof(transient_address_definition_23,axiom,
    ( $true
    & ( addressVal(v385_range_3_to_0_address_term_bound_2,bitIndex0)
    <=> v385(constB2,bitIndex0) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_2,bitIndex1)
    <=> v385(constB2,bitIndex1) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_2,bitIndex2)
    <=> v385(constB2,bitIndex2) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_2,bitIndex3)
    <=> v385(constB2,bitIndex3) ) ) ).

fof(is_address_40,axiom,
    address(v385_range_3_to_0_address_term_bound_2) ).

fof(address_association_23,axiom,
    v385_range_3_to_0_address_association(constB2,v385_range_3_to_0_address_term_bound_2) ).

fof(address_false_msb_40,axiom,
    ~ addressVal(v385_range_3_to_0_address_term_bound_1,bitIndex4) ).

fof(transient_address_definition_22,axiom,
    ( $true
    & ( addressVal(v385_range_3_to_0_address_term_bound_1,bitIndex0)
    <=> v385(constB1,bitIndex0) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_1,bitIndex1)
    <=> v385(constB1,bitIndex1) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_1,bitIndex2)
    <=> v385(constB1,bitIndex2) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_1,bitIndex3)
    <=> v385(constB1,bitIndex3) ) ) ).

fof(is_address_39,axiom,
    address(v385_range_3_to_0_address_term_bound_1) ).

fof(address_association_22,axiom,
    v385_range_3_to_0_address_association(constB1,v385_range_3_to_0_address_term_bound_1) ).

fof(address_false_msb_39,axiom,
    ~ addressVal(v385_range_3_to_0_address_term_bound_0,bitIndex4) ).

fof(transient_address_definition_21,axiom,
    ( $true
    & ( addressVal(v385_range_3_to_0_address_term_bound_0,bitIndex0)
    <=> v385(constB0,bitIndex0) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_0,bitIndex1)
    <=> v385(constB0,bitIndex1) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_0,bitIndex2)
    <=> v385(constB0,bitIndex2) )
    & ( addressVal(v385_range_3_to_0_address_term_bound_0,bitIndex3)
    <=> v385(constB0,bitIndex3) ) ) ).

fof(is_address_38,axiom,
    address(v385_range_3_to_0_address_term_bound_0) ).

fof(address_association_21,axiom,
    v385_range_3_to_0_address_association(constB0,v385_range_3_to_0_address_term_bound_0) ).

fof(address_false_msb_38,axiom,
    ~ addressVal(b1111_address_term,bitIndex4) ).

fof(is_address_37,axiom,
    address(b1111_address_term) ).

fof(constant_address_definition_16,axiom,
    ! [B] :
      ( addressVal(b1111_address_term,B)
    <=> b1111(B) ) ).

fof(address_false_msb_37,axiom,
    ~ addressVal(b1110_address_term,bitIndex4) ).

fof(is_address_36,axiom,
    address(b1110_address_term) ).

fof(constant_address_definition_15,axiom,
    ! [B] :
      ( addressVal(b1110_address_term,B)
    <=> b1110(B) ) ).

fof(address_false_msb_36,axiom,
    ~ addressVal(b1101_address_term,bitIndex4) ).

fof(is_address_35,axiom,
    address(b1101_address_term) ).

fof(constant_address_definition_14,axiom,
    ! [B] :
      ( addressVal(b1101_address_term,B)
    <=> b1101(B) ) ).

fof(address_false_msb_35,axiom,
    ~ addressVal(b1100_address_term,bitIndex4) ).

fof(is_address_34,axiom,
    address(b1100_address_term) ).

fof(constant_address_definition_13,axiom,
    ! [B] :
      ( addressVal(b1100_address_term,B)
    <=> b1100(B) ) ).

fof(address_false_msb_34,axiom,
    ~ addressVal(b1011_address_term,bitIndex4) ).

fof(is_address_33,axiom,
    address(b1011_address_term) ).

fof(constant_address_definition_12,axiom,
    ! [B] :
      ( addressVal(b1011_address_term,B)
    <=> b1011(B) ) ).

fof(address_false_msb_33,axiom,
    ~ addressVal(b1010_address_term,bitIndex4) ).

fof(is_address_32,axiom,
    address(b1010_address_term) ).

fof(constant_address_definition_11,axiom,
    ! [B] :
      ( addressVal(b1010_address_term,B)
    <=> b1010(B) ) ).

fof(address_false_msb_32,axiom,
    ~ addressVal(b1001_address_term,bitIndex4) ).

fof(is_address_31,axiom,
    address(b1001_address_term) ).

fof(constant_address_definition_10,axiom,
    ! [B] :
      ( addressVal(b1001_address_term,B)
    <=> b1001(B) ) ).

fof(address_false_msb_31,axiom,
    ~ addressVal(b1000_address_term,bitIndex4) ).

fof(is_address_30,axiom,
    address(b1000_address_term) ).

fof(constant_address_definition_9,axiom,
    ! [B] :
      ( addressVal(b1000_address_term,B)
    <=> b1000(B) ) ).

fof(address_false_msb_30,axiom,
    ~ addressVal(b0111_address_term,bitIndex4) ).

fof(is_address_29,axiom,
    address(b0111_address_term) ).

fof(constant_address_definition_8,axiom,
    ! [B] :
      ( addressVal(b0111_address_term,B)
    <=> b0111(B) ) ).

fof(address_false_msb_29,axiom,
    ~ addressVal(b0110_address_term,bitIndex4) ).

fof(is_address_28,axiom,
    address(b0110_address_term) ).

fof(constant_address_definition_7,axiom,
    ! [B] :
      ( addressVal(b0110_address_term,B)
    <=> b0110(B) ) ).

fof(address_false_msb_28,axiom,
    ~ addressVal(b0101_address_term,bitIndex4) ).

fof(is_address_27,axiom,
    address(b0101_address_term) ).

fof(constant_address_definition_6,axiom,
    ! [B] :
      ( addressVal(b0101_address_term,B)
    <=> b0101(B) ) ).

fof(address_false_msb_27,axiom,
    ~ addressVal(b0100_address_term,bitIndex4) ).

fof(is_address_26,axiom,
    address(b0100_address_term) ).

fof(constant_address_definition_5,axiom,
    ! [B] :
      ( addressVal(b0100_address_term,B)
    <=> b0100(B) ) ).

fof(address_false_msb_26,axiom,
    ~ addressVal(b0011_address_term,bitIndex4) ).

fof(is_address_25,axiom,
    address(b0011_address_term) ).

fof(constant_address_definition_4,axiom,
    ! [B] :
      ( addressVal(b0011_address_term,B)
    <=> b0011(B) ) ).

fof(address_false_msb_25,axiom,
    ~ addressVal(b0010_address_term,bitIndex4) ).

fof(is_address_24,axiom,
    address(b0010_address_term) ).

fof(constant_address_definition_3,axiom,
    ! [B] :
      ( addressVal(b0010_address_term,B)
    <=> b0010(B) ) ).

fof(address_false_msb_24,axiom,
    ~ addressVal(b0001_address_term,bitIndex4) ).

fof(is_address_23,axiom,
    address(b0001_address_term) ).

fof(constant_address_definition_2,axiom,
    ! [B] :
      ( addressVal(b0001_address_term,B)
    <=> b0001(B) ) ).

fof(address_false_msb_23,axiom,
    ~ addressVal(v342_range_3_to_0_address_term_bound_20,bitIndex4) ).

fof(transient_address_definition_20,axiom,
    ( $true
    & ( addressVal(v342_range_3_to_0_address_term_bound_20,bitIndex0)
    <=> v342(constB20,bitIndex0) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_20,bitIndex1)
    <=> v342(constB20,bitIndex1) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_20,bitIndex2)
    <=> v342(constB20,bitIndex2) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_20,bitIndex3)
    <=> v342(constB20,bitIndex3) ) ) ).

fof(is_address_22,axiom,
    address(v342_range_3_to_0_address_term_bound_20) ).

fof(address_association_20,axiom,
    v342_range_3_to_0_address_association(constB20,v342_range_3_to_0_address_term_bound_20) ).

fof(address_false_msb_22,axiom,
    ~ addressVal(v342_range_3_to_0_address_term_bound_19,bitIndex4) ).

fof(transient_address_definition_19,axiom,
    ( $true
    & ( addressVal(v342_range_3_to_0_address_term_bound_19,bitIndex0)
    <=> v342(constB19,bitIndex0) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_19,bitIndex1)
    <=> v342(constB19,bitIndex1) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_19,bitIndex2)
    <=> v342(constB19,bitIndex2) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_19,bitIndex3)
    <=> v342(constB19,bitIndex3) ) ) ).

fof(is_address_21,axiom,
    address(v342_range_3_to_0_address_term_bound_19) ).

fof(address_association_19,axiom,
    v342_range_3_to_0_address_association(constB19,v342_range_3_to_0_address_term_bound_19) ).

fof(address_false_msb_21,axiom,
    ~ addressVal(v342_range_3_to_0_address_term_bound_18,bitIndex4) ).

fof(transient_address_definition_18,axiom,
    ( $true
    & ( addressVal(v342_range_3_to_0_address_term_bound_18,bitIndex0)
    <=> v342(constB18,bitIndex0) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_18,bitIndex1)
    <=> v342(constB18,bitIndex1) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_18,bitIndex2)
    <=> v342(constB18,bitIndex2) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_18,bitIndex3)
    <=> v342(constB18,bitIndex3) ) ) ).

fof(is_address_20,axiom,
    address(v342_range_3_to_0_address_term_bound_18) ).

fof(address_association_18,axiom,
    v342_range_3_to_0_address_association(constB18,v342_range_3_to_0_address_term_bound_18) ).

fof(address_false_msb_20,axiom,
    ~ addressVal(v342_range_3_to_0_address_term_bound_17,bitIndex4) ).

fof(transient_address_definition_17,axiom,
    ( $true
    & ( addressVal(v342_range_3_to_0_address_term_bound_17,bitIndex0)
    <=> v342(constB17,bitIndex0) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_17,bitIndex1)
    <=> v342(constB17,bitIndex1) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_17,bitIndex2)
    <=> v342(constB17,bitIndex2) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_17,bitIndex3)
    <=> v342(constB17,bitIndex3) ) ) ).

fof(is_address_19,axiom,
    address(v342_range_3_to_0_address_term_bound_17) ).

fof(address_association_17,axiom,
    v342_range_3_to_0_address_association(constB17,v342_range_3_to_0_address_term_bound_17) ).

fof(address_false_msb_19,axiom,
    ~ addressVal(v342_range_3_to_0_address_term_bound_16,bitIndex4) ).

fof(transient_address_definition_16,axiom,
    ( $true
    & ( addressVal(v342_range_3_to_0_address_term_bound_16,bitIndex0)
    <=> v342(constB16,bitIndex0) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_16,bitIndex1)
    <=> v342(constB16,bitIndex1) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_16,bitIndex2)
    <=> v342(constB16,bitIndex2) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_16,bitIndex3)
    <=> v342(constB16,bitIndex3) ) ) ).

fof(is_address_18,axiom,
    address(v342_range_3_to_0_address_term_bound_16) ).

fof(address_association_16,axiom,
    v342_range_3_to_0_address_association(constB16,v342_range_3_to_0_address_term_bound_16) ).

fof(address_false_msb_18,axiom,
    ~ addressVal(v342_range_3_to_0_address_term_bound_15,bitIndex4) ).

fof(transient_address_definition_15,axiom,
    ( $true
    & ( addressVal(v342_range_3_to_0_address_term_bound_15,bitIndex0)
    <=> v342(constB15,bitIndex0) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_15,bitIndex1)
    <=> v342(constB15,bitIndex1) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_15,bitIndex2)
    <=> v342(constB15,bitIndex2) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_15,bitIndex3)
    <=> v342(constB15,bitIndex3) ) ) ).

fof(is_address_17,axiom,
    address(v342_range_3_to_0_address_term_bound_15) ).

fof(address_association_15,axiom,
    v342_range_3_to_0_address_association(constB15,v342_range_3_to_0_address_term_bound_15) ).

fof(address_false_msb_17,axiom,
    ~ addressVal(v342_range_3_to_0_address_term_bound_14,bitIndex4) ).

fof(transient_address_definition_14,axiom,
    ( $true
    & ( addressVal(v342_range_3_to_0_address_term_bound_14,bitIndex0)
    <=> v342(constB14,bitIndex0) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_14,bitIndex1)
    <=> v342(constB14,bitIndex1) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_14,bitIndex2)
    <=> v342(constB14,bitIndex2) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_14,bitIndex3)
    <=> v342(constB14,bitIndex3) ) ) ).

fof(is_address_16,axiom,
    address(v342_range_3_to_0_address_term_bound_14) ).

fof(address_association_14,axiom,
    v342_range_3_to_0_address_association(constB14,v342_range_3_to_0_address_term_bound_14) ).

fof(address_false_msb_16,axiom,
    ~ addressVal(v342_range_3_to_0_address_term_bound_13,bitIndex4) ).

fof(transient_address_definition_13,axiom,
    ( $true
    & ( addressVal(v342_range_3_to_0_address_term_bound_13,bitIndex0)
    <=> v342(constB13,bitIndex0) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_13,bitIndex1)
    <=> v342(constB13,bitIndex1) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_13,bitIndex2)
    <=> v342(constB13,bitIndex2) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_13,bitIndex3)
    <=> v342(constB13,bitIndex3) ) ) ).

fof(is_address_15,axiom,
    address(v342_range_3_to_0_address_term_bound_13) ).

fof(address_association_13,axiom,
    v342_range_3_to_0_address_association(constB13,v342_range_3_to_0_address_term_bound_13) ).

fof(address_false_msb_15,axiom,
    ~ addressVal(v342_range_3_to_0_address_term_bound_12,bitIndex4) ).

fof(transient_address_definition_12,axiom,
    ( $true
    & ( addressVal(v342_range_3_to_0_address_term_bound_12,bitIndex0)
    <=> v342(constB12,bitIndex0) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_12,bitIndex1)
    <=> v342(constB12,bitIndex1) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_12,bitIndex2)
    <=> v342(constB12,bitIndex2) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_12,bitIndex3)
    <=> v342(constB12,bitIndex3) ) ) ).

fof(is_address_14,axiom,
    address(v342_range_3_to_0_address_term_bound_12) ).

fof(address_association_12,axiom,
    v342_range_3_to_0_address_association(constB12,v342_range_3_to_0_address_term_bound_12) ).

fof(address_false_msb_14,axiom,
    ~ addressVal(v342_range_3_to_0_address_term_bound_11,bitIndex4) ).

fof(transient_address_definition_11,axiom,
    ( $true
    & ( addressVal(v342_range_3_to_0_address_term_bound_11,bitIndex0)
    <=> v342(constB11,bitIndex0) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_11,bitIndex1)
    <=> v342(constB11,bitIndex1) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_11,bitIndex2)
    <=> v342(constB11,bitIndex2) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_11,bitIndex3)
    <=> v342(constB11,bitIndex3) ) ) ).

fof(is_address_13,axiom,
    address(v342_range_3_to_0_address_term_bound_11) ).

fof(address_association_11,axiom,
    v342_range_3_to_0_address_association(constB11,v342_range_3_to_0_address_term_bound_11) ).

fof(address_false_msb_13,axiom,
    ~ addressVal(v342_range_3_to_0_address_term_bound_10,bitIndex4) ).

fof(transient_address_definition_10,axiom,
    ( $true
    & ( addressVal(v342_range_3_to_0_address_term_bound_10,bitIndex0)
    <=> v342(constB10,bitIndex0) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_10,bitIndex1)
    <=> v342(constB10,bitIndex1) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_10,bitIndex2)
    <=> v342(constB10,bitIndex2) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_10,bitIndex3)
    <=> v342(constB10,bitIndex3) ) ) ).

fof(is_address_12,axiom,
    address(v342_range_3_to_0_address_term_bound_10) ).

fof(address_association_10,axiom,
    v342_range_3_to_0_address_association(constB10,v342_range_3_to_0_address_term_bound_10) ).

fof(address_false_msb_12,axiom,
    ~ addressVal(v342_range_3_to_0_address_term_bound_9,bitIndex4) ).

fof(transient_address_definition_9,axiom,
    ( $true
    & ( addressVal(v342_range_3_to_0_address_term_bound_9,bitIndex0)
    <=> v342(constB9,bitIndex0) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_9,bitIndex1)
    <=> v342(constB9,bitIndex1) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_9,bitIndex2)
    <=> v342(constB9,bitIndex2) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_9,bitIndex3)
    <=> v342(constB9,bitIndex3) ) ) ).

fof(is_address_11,axiom,
    address(v342_range_3_to_0_address_term_bound_9) ).

fof(address_association_9,axiom,
    v342_range_3_to_0_address_association(constB9,v342_range_3_to_0_address_term_bound_9) ).

fof(address_false_msb_11,axiom,
    ~ addressVal(v342_range_3_to_0_address_term_bound_8,bitIndex4) ).

fof(transient_address_definition_8,axiom,
    ( $true
    & ( addressVal(v342_range_3_to_0_address_term_bound_8,bitIndex0)
    <=> v342(constB8,bitIndex0) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_8,bitIndex1)
    <=> v342(constB8,bitIndex1) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_8,bitIndex2)
    <=> v342(constB8,bitIndex2) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_8,bitIndex3)
    <=> v342(constB8,bitIndex3) ) ) ).

fof(is_address_10,axiom,
    address(v342_range_3_to_0_address_term_bound_8) ).

fof(address_association_8,axiom,
    v342_range_3_to_0_address_association(constB8,v342_range_3_to_0_address_term_bound_8) ).

fof(address_false_msb_10,axiom,
    ~ addressVal(v342_range_3_to_0_address_term_bound_7,bitIndex4) ).

fof(transient_address_definition_7,axiom,
    ( $true
    & ( addressVal(v342_range_3_to_0_address_term_bound_7,bitIndex0)
    <=> v342(constB7,bitIndex0) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_7,bitIndex1)
    <=> v342(constB7,bitIndex1) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_7,bitIndex2)
    <=> v342(constB7,bitIndex2) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_7,bitIndex3)
    <=> v342(constB7,bitIndex3) ) ) ).

fof(is_address_9,axiom,
    address(v342_range_3_to_0_address_term_bound_7) ).

fof(address_association_7,axiom,
    v342_range_3_to_0_address_association(constB7,v342_range_3_to_0_address_term_bound_7) ).

fof(address_false_msb_9,axiom,
    ~ addressVal(v342_range_3_to_0_address_term_bound_6,bitIndex4) ).

fof(transient_address_definition_6,axiom,
    ( $true
    & ( addressVal(v342_range_3_to_0_address_term_bound_6,bitIndex0)
    <=> v342(constB6,bitIndex0) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_6,bitIndex1)
    <=> v342(constB6,bitIndex1) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_6,bitIndex2)
    <=> v342(constB6,bitIndex2) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_6,bitIndex3)
    <=> v342(constB6,bitIndex3) ) ) ).

fof(is_address_8,axiom,
    address(v342_range_3_to_0_address_term_bound_6) ).

fof(address_association_6,axiom,
    v342_range_3_to_0_address_association(constB6,v342_range_3_to_0_address_term_bound_6) ).

fof(address_false_msb_8,axiom,
    ~ addressVal(v342_range_3_to_0_address_term_bound_5,bitIndex4) ).

fof(transient_address_definition_5,axiom,
    ( $true
    & ( addressVal(v342_range_3_to_0_address_term_bound_5,bitIndex0)
    <=> v342(constB5,bitIndex0) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_5,bitIndex1)
    <=> v342(constB5,bitIndex1) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_5,bitIndex2)
    <=> v342(constB5,bitIndex2) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_5,bitIndex3)
    <=> v342(constB5,bitIndex3) ) ) ).

fof(is_address_7,axiom,
    address(v342_range_3_to_0_address_term_bound_5) ).

fof(address_association_5,axiom,
    v342_range_3_to_0_address_association(constB5,v342_range_3_to_0_address_term_bound_5) ).

fof(address_false_msb_7,axiom,
    ~ addressVal(v342_range_3_to_0_address_term_bound_4,bitIndex4) ).

fof(transient_address_definition_4,axiom,
    ( $true
    & ( addressVal(v342_range_3_to_0_address_term_bound_4,bitIndex0)
    <=> v342(constB4,bitIndex0) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_4,bitIndex1)
    <=> v342(constB4,bitIndex1) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_4,bitIndex2)
    <=> v342(constB4,bitIndex2) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_4,bitIndex3)
    <=> v342(constB4,bitIndex3) ) ) ).

fof(is_address_6,axiom,
    address(v342_range_3_to_0_address_term_bound_4) ).

fof(address_association_4,axiom,
    v342_range_3_to_0_address_association(constB4,v342_range_3_to_0_address_term_bound_4) ).

fof(address_false_msb_6,axiom,
    ~ addressVal(v342_range_3_to_0_address_term_bound_3,bitIndex4) ).

fof(transient_address_definition_3,axiom,
    ( $true
    & ( addressVal(v342_range_3_to_0_address_term_bound_3,bitIndex0)
    <=> v342(constB3,bitIndex0) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_3,bitIndex1)
    <=> v342(constB3,bitIndex1) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_3,bitIndex2)
    <=> v342(constB3,bitIndex2) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_3,bitIndex3)
    <=> v342(constB3,bitIndex3) ) ) ).

fof(is_address_5,axiom,
    address(v342_range_3_to_0_address_term_bound_3) ).

fof(address_association_3,axiom,
    v342_range_3_to_0_address_association(constB3,v342_range_3_to_0_address_term_bound_3) ).

fof(address_false_msb_5,axiom,
    ~ addressVal(v342_range_3_to_0_address_term_bound_2,bitIndex4) ).

fof(transient_address_definition_2,axiom,
    ( $true
    & ( addressVal(v342_range_3_to_0_address_term_bound_2,bitIndex0)
    <=> v342(constB2,bitIndex0) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_2,bitIndex1)
    <=> v342(constB2,bitIndex1) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_2,bitIndex2)
    <=> v342(constB2,bitIndex2) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_2,bitIndex3)
    <=> v342(constB2,bitIndex3) ) ) ).

fof(is_address_4,axiom,
    address(v342_range_3_to_0_address_term_bound_2) ).

fof(address_association_2,axiom,
    v342_range_3_to_0_address_association(constB2,v342_range_3_to_0_address_term_bound_2) ).

fof(address_false_msb_4,axiom,
    ~ addressVal(v342_range_3_to_0_address_term_bound_1,bitIndex4) ).

fof(transient_address_definition_1,axiom,
    ( $true
    & ( addressVal(v342_range_3_to_0_address_term_bound_1,bitIndex0)
    <=> v342(constB1,bitIndex0) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_1,bitIndex1)
    <=> v342(constB1,bitIndex1) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_1,bitIndex2)
    <=> v342(constB1,bitIndex2) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_1,bitIndex3)
    <=> v342(constB1,bitIndex3) ) ) ).

fof(is_address_3,axiom,
    address(v342_range_3_to_0_address_term_bound_1) ).

fof(address_association_1,axiom,
    v342_range_3_to_0_address_association(constB1,v342_range_3_to_0_address_term_bound_1) ).

fof(address_false_msb_3,axiom,
    ~ addressVal(v342_range_3_to_0_address_term_bound_0,bitIndex4) ).

fof(transient_address_definition,axiom,
    ( $true
    & ( addressVal(v342_range_3_to_0_address_term_bound_0,bitIndex0)
    <=> v342(constB0,bitIndex0) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_0,bitIndex1)
    <=> v342(constB0,bitIndex1) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_0,bitIndex2)
    <=> v342(constB0,bitIndex2) )
    & ( addressVal(v342_range_3_to_0_address_term_bound_0,bitIndex3)
    <=> v342(constB0,bitIndex3) ) ) ).

fof(is_address_2,axiom,
    address(v342_range_3_to_0_address_term_bound_0) ).

fof(address_association,axiom,
    v342_range_3_to_0_address_association(constB0,v342_range_3_to_0_address_term_bound_0) ).

fof(address_false_msb_2,axiom,
    ~ addressVal(b0000_address_term,bitIndex4) ).

fof(is_address_1,axiom,
    address(b0000_address_term) ).

fof(constant_address_definition_1,axiom,
    ! [B] :
      ( addressVal(b0000_address_term,B)
    <=> b0000(B) ) ).

fof(address_false_msb_1,axiom,
    ~ addressVal(b100_address_term,bitIndex4) ).

fof(address_false_msb,axiom,
    ~ addressVal(b100_address_term,bitIndex3) ).

fof(is_address,axiom,
    address(b100_address_term) ).

fof(constant_address_definition,axiom,
    ! [B] :
      ( addressVal(b100_address_term,B)
    <=> b100(B) ) ).

fof(addressDiff,axiom,
    ! [B,A2,A1] :
      ( ( address(A1)
        & address(A2)
        & addressDiff(A1,A2,B) )
     => ( A1 = A2
        | ( addressVal(A1,B)
        <=> ~ addressVal(A2,B) ) ) ) ).

fof(addressDomain,axiom,
    ! [A1,A2] :
      ( addressDiff(A1,A2,bitIndex0)
      | addressDiff(A1,A2,bitIndex1)
      | addressDiff(A1,A2,bitIndex2)
      | addressDiff(A1,A2,bitIndex3)
      | addressDiff(A1,A2,bitIndex4) ) ).

fof(addAssertion,conjecture,
    ! [VarCurr] :
      ( reachableState(VarCurr)
     => v4(VarCurr) ) ).

fof(writeUnaryOperator_860,axiom,
    ! [VarCurr] :
      ( ~ v4(VarCurr)
    <=> v9854(VarCurr) ) ).

fof(writeUnaryOperator_859,axiom,
    ! [VarCurr] :
      ( ~ v9854(VarCurr)
    <=> v9855(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1898,axiom,
    ! [VarCurr] :
      ( v9855(VarCurr)
    <=> ( v9857(VarCurr)
        & v9865(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_379,axiom,
    ! [VarCurr] :
      ( v9865(VarCurr)
    <=> ( v9866(VarCurr)
        | v6(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_378,axiom,
    ! [VarCurr] :
      ( v9866(VarCurr)
    <=> ( v6(VarCurr,bitIndex0)
        | v6(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1897,axiom,
    ! [VarCurr] :
      ( v9857(VarCurr)
    <=> ( v9858(VarCurr)
        & v9863(VarCurr) ) ) ).

fof(writeUnaryOperator_858,axiom,
    ! [VarCurr] :
      ( ~ v9863(VarCurr)
    <=> v9864(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_377,axiom,
    ! [VarCurr] :
      ( v9864(VarCurr)
    <=> ( v6(VarCurr,bitIndex1)
        & v6(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1896,axiom,
    ! [VarCurr] :
      ( v9858(VarCurr)
    <=> ( v9859(VarCurr)
        & v9861(VarCurr) ) ) ).

fof(writeUnaryOperator_857,axiom,
    ! [VarCurr] :
      ( ~ v9861(VarCurr)
    <=> v9862(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_376,axiom,
    ! [VarCurr] :
      ( v9862(VarCurr)
    <=> ( v6(VarCurr,bitIndex0)
        & v6(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_856,axiom,
    ! [VarCurr] :
      ( ~ v9859(VarCurr)
    <=> v9860(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_375,axiom,
    ! [VarCurr] :
      ( v9860(VarCurr)
    <=> ( v6(VarCurr,bitIndex0)
        & v6(VarCurr,bitIndex1) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_164,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9842(VarNext)
       => ! [B] :
            ( range_2_1(B)
           => ( v6(VarNext,B)
            <=> v6(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionShiftedRanges0_9,axiom,
    ! [VarNext] :
      ( v9842(VarNext)
     => ( ( v6(VarNext,bitIndex2)
        <=> v9850(VarNext,bitIndex1) )
        & ( v6(VarNext,bitIndex1)
        <=> v9850(VarNext,bitIndex0) ) ) ) ).

fof(addAssignment_2273,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v9850(VarNext,B)
          <=> v9848(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_115,axiom,
    ! [VarCurr] :
      ( ~ v9837(VarCurr)
     => ( ( v9848(VarCurr,bitIndex1)
        <=> v19(VarCurr,bitIndex2) )
        & ( v9848(VarCurr,bitIndex0)
        <=> v19(VarCurr,bitIndex1) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_264,axiom,
    ! [VarCurr] :
      ( v9837(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v9848(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1895,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9842(VarNext)
      <=> v9843(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1894,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9843(VarNext)
      <=> ( v9845(VarNext)
          & v3073(VarNext) ) ) ) ).

fof(writeUnaryOperator_855,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9845(VarNext)
      <=> v9783(VarNext) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_163,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9828(VarNext)
       => ( v6(VarNext,bitIndex0)
        <=> v6(VarCurr,bitIndex0) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_183,axiom,
    ! [VarNext] :
      ( v9828(VarNext)
     => ( v6(VarNext,bitIndex0)
      <=> v9836(VarNext) ) ) ).

fof(addAssignment_2272,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9836(VarNext)
      <=> v9834(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_259,axiom,
    ! [VarCurr] :
      ( ~ v9837(VarCurr)
     => ( v9834(VarCurr)
      <=> v19(VarCurr,bitIndex0) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_263,axiom,
    ! [VarCurr] :
      ( v9837(VarCurr)
     => ( v9834(VarCurr)
      <=> $true ) ) ).

fof(writeUnaryOperator_854,axiom,
    ! [VarCurr] :
      ( ~ v9837(VarCurr)
    <=> v8(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1893,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9828(VarNext)
      <=> v9829(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1892,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9829(VarNext)
      <=> ( v9830(VarNext)
          & v3073(VarNext) ) ) ) ).

fof(writeUnaryOperator_853,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9830(VarNext)
      <=> v9783(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_114,axiom,
    ! [VarCurr] :
      ( ~ v9821(VarCurr)
     => ( v19(VarCurr,bitIndex2)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_110,axiom,
    ! [VarCurr] :
      ( v9821(VarCurr)
     => ( v19(VarCurr,bitIndex2)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1891,axiom,
    ! [VarCurr] :
      ( v9821(VarCurr)
    <=> ( v9822(VarCurr)
        | v9825(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1890,axiom,
    ! [VarCurr] :
      ( v9825(VarCurr)
    <=> ( v9733(VarCurr)
        & v9728(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1889,axiom,
    ! [VarCurr] :
      ( v9822(VarCurr)
    <=> ( v9823(VarCurr)
        & v3019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1888,axiom,
    ! [VarCurr] :
      ( v9823(VarCurr)
    <=> ( v9824(VarCurr)
        & v3018(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1887,axiom,
    ! [VarCurr] :
      ( v9824(VarCurr)
    <=> ( v3039(VarCurr)
        & v9295(VarCurr) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_113,axiom,
    ! [VarCurr] :
      ( ~ v9813(VarCurr)
     => ( v19(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_109,axiom,
    ! [VarCurr] :
      ( v9813(VarCurr)
     => ( v19(VarCurr,bitIndex1)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1886,axiom,
    ! [VarCurr] :
      ( v9813(VarCurr)
    <=> ( v9814(VarCurr)
        | v9819(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1885,axiom,
    ! [VarCurr] :
      ( v9819(VarCurr)
    <=> ( v21(VarCurr)
        & v9729(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1884,axiom,
    ! [VarCurr] :
      ( v9814(VarCurr)
    <=> ( v9815(VarCurr)
        | v9818(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1883,axiom,
    ! [VarCurr] :
      ( v9818(VarCurr)
    <=> ( v9740(VarCurr)
        & v9728(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1882,axiom,
    ! [VarCurr] :
      ( v9815(VarCurr)
    <=> ( v9816(VarCurr)
        & v3019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1881,axiom,
    ! [VarCurr] :
      ( v9816(VarCurr)
    <=> ( v9817(VarCurr)
        & v3018(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1880,axiom,
    ! [VarCurr] :
      ( v9817(VarCurr)
    <=> ( v21(VarCurr)
        & v3017(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_258,axiom,
    ! [VarCurr] :
      ( ~ v9797(VarCurr)
     => ( v19(VarCurr,bitIndex0)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_262,axiom,
    ! [VarCurr] :
      ( v9797(VarCurr)
     => ( v19(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1879,axiom,
    ! [VarCurr] :
      ( v9797(VarCurr)
    <=> ( v9798(VarCurr)
        | v9810(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1878,axiom,
    ! [VarCurr] :
      ( v9810(VarCurr)
    <=> ( v9811(VarCurr)
        & v9729(VarCurr) ) ) ).

fof(writeUnaryOperator_852,axiom,
    ! [VarCurr] :
      ( ~ v9811(VarCurr)
    <=> v21(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1877,axiom,
    ! [VarCurr] :
      ( v9798(VarCurr)
    <=> ( v9799(VarCurr)
        | v9809(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1876,axiom,
    ! [VarCurr] :
      ( v9809(VarCurr)
    <=> ( v9738(VarCurr)
        & v9728(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1875,axiom,
    ! [VarCurr] :
      ( v9799(VarCurr)
    <=> ( v9800(VarCurr)
        & v3019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1874,axiom,
    ! [VarCurr] :
      ( v9800(VarCurr)
    <=> ( v9801(VarCurr)
        | v9808(VarCurr) ) ) ).

fof(writeUnaryOperator_851,axiom,
    ! [VarCurr] :
      ( ~ v9808(VarCurr)
    <=> v3018(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1873,axiom,
    ! [VarCurr] :
      ( v9801(VarCurr)
    <=> ( v9802(VarCurr)
        & v3018(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1872,axiom,
    ! [VarCurr] :
      ( v9802(VarCurr)
    <=> ( v9803(VarCurr)
        | v9806(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1871,axiom,
    ! [VarCurr] :
      ( v9806(VarCurr)
    <=> ( v9807(VarCurr)
        & v9295(VarCurr) ) ) ).

fof(writeUnaryOperator_850,axiom,
    ! [VarCurr] :
      ( ~ v9807(VarCurr)
    <=> v3039(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1870,axiom,
    ! [VarCurr] :
      ( v9803(VarCurr)
    <=> ( v9804(VarCurr)
        | v9317(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1869,axiom,
    ! [VarCurr] :
      ( v9804(VarCurr)
    <=> ( v9805(VarCurr)
        & v3017(VarCurr) ) ) ).

fof(writeUnaryOperator_849,axiom,
    ! [VarCurr] :
      ( ~ v9805(VarCurr)
    <=> v21(VarCurr) ) ).

fof(writeUnaryOperator_848,axiom,
    ! [VarCurr] :
      ( ~ v21(VarCurr)
    <=> v9795(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_374,axiom,
    ! [VarCurr] :
      ( v9795(VarCurr)
    <=> ( v9771(VarCurr)
        | v23(VarCurr,bitIndex2) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_162,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9779(VarNext)
       => ! [B] :
            ( range_2_0(B)
           => ( v23(VarNext,B)
            <=> v23(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_182,axiom,
    ! [VarNext] :
      ( v9779(VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v23(VarNext,B)
          <=> v9789(VarNext,B) ) ) ) ).

fof(addAssignment_2271,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v9789(VarNext,B)
          <=> v9787(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_257,axiom,
    ! [VarCurr] :
      ( ~ v9790(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v9787(VarCurr,B)
          <=> v26(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_261,axiom,
    ! [VarCurr] :
      ( v9790(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v9787(VarCurr,B)
          <=> b100(B) ) ) ) ).

fof(writeUnaryOperator_847,axiom,
    ! [VarCurr] :
      ( ~ v9790(VarCurr)
    <=> v8(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1868,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9779(VarNext)
      <=> v9780(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1867,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9780(VarNext)
      <=> ( v9781(VarNext)
          & v3073(VarNext) ) ) ) ).

fof(writeUnaryOperator_846,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9781(VarNext)
      <=> v9783(VarNext) ) ) ).

fof(addAssignment_2270,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9783(VarNext)
      <=> v3073(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_103,axiom,
    ! [VarCurr] :
      ( ( ~ v9744(VarCurr)
        & ~ v9760(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v26(VarCurr,B)
          <=> v23(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_265,axiom,
    ! [VarCurr] :
      ( v9760(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v26(VarCurr,B)
          <=> v9762(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_253,axiom,
    ! [VarCurr] :
      ( v9744(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v26(VarCurr,B)
          <=> v9746(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1866,axiom,
    ! [VarCurr] :
      ( v9772(VarCurr)
    <=> ( v9773(VarCurr)
        | v9775(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_738,axiom,
    ! [VarCurr] :
      ( v9775(VarCurr)
    <=> ( ( v9776(VarCurr,bitIndex1)
        <=> $true )
        & ( v9776(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2269,axiom,
    ! [VarCurr] :
      ( v9776(VarCurr,bitIndex0)
    <=> v36(VarCurr) ) ).

fof(addAssignment_2268,axiom,
    ! [VarCurr] :
      ( v9776(VarCurr,bitIndex1)
    <=> v28(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_737,axiom,
    ! [VarCurr] :
      ( v9773(VarCurr)
    <=> ( ( v9774(VarCurr,bitIndex1)
        <=> $false )
        & ( v9774(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2267,axiom,
    ! [VarCurr] :
      ( v9774(VarCurr,bitIndex0)
    <=> v36(VarCurr) ) ).

fof(addAssignment_2266,axiom,
    ! [VarCurr] :
      ( v9774(VarCurr,bitIndex1)
    <=> v28(VarCurr) ) ).

fof(addAssignment_2265,axiom,
    ! [VarCurr] :
      ( v9762(VarCurr,bitIndex0)
    <=> v9758(VarCurr) ) ).

fof(addAssignment_2264,axiom,
    ! [VarCurr] :
      ( v9762(VarCurr,bitIndex1)
    <=> v9769(VarCurr) ) ).

fof(addAssignment_2263,axiom,
    ! [VarCurr] :
      ( v9762(VarCurr,bitIndex2)
    <=> v9764(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1865,axiom,
    ! [VarCurr] :
      ( v9769(VarCurr)
    <=> ( v9770(VarCurr)
        & v9771(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_373,axiom,
    ! [VarCurr] :
      ( v9771(VarCurr)
    <=> ( v23(VarCurr,bitIndex0)
        | v23(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1864,axiom,
    ! [VarCurr] :
      ( v9770(VarCurr)
    <=> ( v9758(VarCurr)
        | v9753(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1863,axiom,
    ! [VarCurr] :
      ( v9764(VarCurr)
    <=> ( v9765(VarCurr)
        & v9768(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_372,axiom,
    ! [VarCurr] :
      ( v9768(VarCurr)
    <=> ( v23(VarCurr,bitIndex2)
        | v9767(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1862,axiom,
    ! [VarCurr] :
      ( v9765(VarCurr)
    <=> ( v9755(VarCurr)
        | v9766(VarCurr) ) ) ).

fof(writeUnaryOperator_845,axiom,
    ! [VarCurr] :
      ( ~ v9766(VarCurr)
    <=> v9767(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_371,axiom,
    ! [VarCurr] :
      ( v9767(VarCurr)
    <=> ( v23(VarCurr,bitIndex0)
        & v23(VarCurr,bitIndex1) ) ) ).

fof(addBitVectorEqualityBitBlasted_736,axiom,
    ! [VarCurr] :
      ( v9760(VarCurr)
    <=> ( ( v9761(VarCurr,bitIndex1)
        <=> $true )
        & ( v9761(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2262,axiom,
    ! [VarCurr] :
      ( v9761(VarCurr,bitIndex0)
    <=> v36(VarCurr) ) ).

fof(addAssignment_2261,axiom,
    ! [VarCurr] :
      ( v9761(VarCurr,bitIndex1)
    <=> v28(VarCurr) ) ).

fof(addAssignment_2260,axiom,
    ! [VarCurr] :
      ( v9746(VarCurr,bitIndex0)
    <=> v9758(VarCurr) ) ).

fof(addAssignment_2259,axiom,
    ! [VarCurr] :
      ( v9746(VarCurr,bitIndex1)
    <=> v9756(VarCurr) ) ).

fof(addAssignment_2258,axiom,
    ! [VarCurr] :
      ( v9746(VarCurr,bitIndex2)
    <=> v9748(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1861,axiom,
    ! [VarCurr] :
      ( v9756(VarCurr)
    <=> ( v9757(VarCurr)
        & v9759(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1860,axiom,
    ! [VarCurr] :
      ( v9759(VarCurr)
    <=> ( v23(VarCurr,bitIndex0)
        | v9753(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_370,axiom,
    ! [VarCurr] :
      ( v9757(VarCurr)
    <=> ( v9758(VarCurr)
        | v23(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_844,axiom,
    ! [VarCurr] :
      ( ~ v9758(VarCurr)
    <=> v23(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1859,axiom,
    ! [VarCurr] :
      ( v9748(VarCurr)
    <=> ( v9749(VarCurr)
        & v9754(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1858,axiom,
    ! [VarCurr] :
      ( v9754(VarCurr)
    <=> ( v9751(VarCurr)
        | v9755(VarCurr) ) ) ).

fof(writeUnaryOperator_843,axiom,
    ! [VarCurr] :
      ( ~ v9755(VarCurr)
    <=> v23(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges_369,axiom,
    ! [VarCurr] :
      ( v9749(VarCurr)
    <=> ( v9750(VarCurr)
        | v23(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_842,axiom,
    ! [VarCurr] :
      ( ~ v9750(VarCurr)
    <=> v9751(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_368,axiom,
    ! [VarCurr] :
      ( v9751(VarCurr)
    <=> ( v23(VarCurr,bitIndex1)
        | v9752(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1857,axiom,
    ! [VarCurr] :
      ( v9752(VarCurr)
    <=> ( v23(VarCurr,bitIndex0)
        & v9753(VarCurr) ) ) ).

fof(writeUnaryOperator_841,axiom,
    ! [VarCurr] :
      ( ~ v9753(VarCurr)
    <=> v23(VarCurr,bitIndex1) ) ).

fof(addAssignmentInitValue_213,axiom,
    v23(constB0,bitIndex2) ).

fof(addAssignmentInitValue_212,axiom,
    ~ v23(constB0,bitIndex1) ).

fof(addAssignmentInitValue_211,axiom,
    ~ v23(constB0,bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_735,axiom,
    ! [VarCurr] :
      ( v9744(VarCurr)
    <=> ( ( v9745(VarCurr,bitIndex1)
        <=> $false )
        & ( v9745(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2257,axiom,
    ! [VarCurr] :
      ( v9745(VarCurr,bitIndex0)
    <=> v36(VarCurr) ) ).

fof(addAssignment_2256,axiom,
    ! [VarCurr] :
      ( v9745(VarCurr,bitIndex1)
    <=> v28(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_256,axiom,
    ! [VarCurr] :
      ( ~ v9724(VarCurr)
     => ( v36(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_260,axiom,
    ! [VarCurr] :
      ( v9724(VarCurr)
     => ( v36(VarCurr)
      <=> v9730(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_102,axiom,
    ! [VarCurr] :
      ( ( ~ v9726(VarCurr)
        & ~ v9728(VarCurr) )
     => ( v9730(VarCurr)
      <=> v9742(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_264,axiom,
    ! [VarCurr] :
      ( v9728(VarCurr)
     => ( v9730(VarCurr)
      <=> v9732(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_252,axiom,
    ! [VarCurr] :
      ( v9726(VarCurr)
     => ( v9730(VarCurr)
      <=> v9731(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_255,axiom,
    ! [VarCurr] :
      ( ~ v21(VarCurr)
     => ( v9742(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_259,axiom,
    ! [VarCurr] :
      ( v21(VarCurr)
     => ( v9742(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_101,axiom,
    ! [VarCurr] :
      ( ( ~ v9733(VarCurr)
        & ~ v9738(VarCurr) )
     => ( v9732(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_263,axiom,
    ! [VarCurr] :
      ( v9738(VarCurr)
     => ( v9732(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_251,axiom,
    ! [VarCurr] :
      ( v9733(VarCurr)
     => ( v9732(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_734,axiom,
    ! [VarCurr] :
      ( v9740(VarCurr)
    <=> ( ( v9741(VarCurr,bitIndex1)
        <=> $true )
        & ( v9741(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2255,axiom,
    ! [VarCurr] :
      ( v9741(VarCurr,bitIndex0)
    <=> v21(VarCurr) ) ).

fof(addAssignment_2254,axiom,
    ! [VarCurr] :
      ( v9741(VarCurr,bitIndex1)
    <=> v3021(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_733,axiom,
    ! [VarCurr] :
      ( v9738(VarCurr)
    <=> ( ( v9739(VarCurr,bitIndex1)
        <=> $true )
        & ( v9739(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2253,axiom,
    ! [VarCurr] :
      ( v9739(VarCurr,bitIndex0)
    <=> v21(VarCurr) ) ).

fof(addAssignment_2252,axiom,
    ! [VarCurr] :
      ( v9739(VarCurr,bitIndex1)
    <=> v3021(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1856,axiom,
    ! [VarCurr] :
      ( v9733(VarCurr)
    <=> ( v9734(VarCurr)
        | v9736(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_732,axiom,
    ! [VarCurr] :
      ( v9736(VarCurr)
    <=> ( ( v9737(VarCurr,bitIndex1)
        <=> $false )
        & ( v9737(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2251,axiom,
    ! [VarCurr] :
      ( v9737(VarCurr,bitIndex0)
    <=> v21(VarCurr) ) ).

fof(addAssignment_2250,axiom,
    ! [VarCurr] :
      ( v9737(VarCurr,bitIndex1)
    <=> v3021(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_731,axiom,
    ! [VarCurr] :
      ( v9734(VarCurr)
    <=> ( ( v9735(VarCurr,bitIndex1)
        <=> $false )
        & ( v9735(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2249,axiom,
    ! [VarCurr] :
      ( v9735(VarCurr,bitIndex0)
    <=> v21(VarCurr) ) ).

fof(addAssignment_2248,axiom,
    ! [VarCurr] :
      ( v9735(VarCurr,bitIndex1)
    <=> v3021(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_254,axiom,
    ! [VarCurr] :
      ( ~ v21(VarCurr)
     => ( v9731(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_258,axiom,
    ! [VarCurr] :
      ( v21(VarCurr)
     => ( v9731(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1855,axiom,
    ! [VarCurr] :
      ( v9724(VarCurr)
    <=> ( v9725(VarCurr)
        | v9729(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_730,axiom,
    ! [VarCurr] :
      ( v9729(VarCurr)
    <=> ( $true
      <=> v6(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1854,axiom,
    ! [VarCurr] :
      ( v9725(VarCurr)
    <=> ( v9726(VarCurr)
        | v9728(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_729,axiom,
    ! [VarCurr] :
      ( v9728(VarCurr)
    <=> ( $true
      <=> v6(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1853,axiom,
    ! [VarCurr] :
      ( v9726(VarCurr)
    <=> ( v9727(VarCurr)
        & v3019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1852,axiom,
    ! [VarCurr] :
      ( v9727(VarCurr)
    <=> ( v3017(VarCurr)
        & v3018(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_253,axiom,
    ! [VarCurr] :
      ( ~ v40(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v38(VarCurr,B)
          <=> v9695(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_257,axiom,
    ! [VarCurr] :
      ( v40(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v38(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_48,axiom,
    ! [VarCurr] :
      ( ( ~ v9696(VarCurr)
        & ~ v9716(VarCurr)
        & ~ v9717(VarCurr) )
     => ! [B] :
          ( range_1_0(B)
         => ( v9695(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_100,axiom,
    ! [VarCurr] :
      ( v9717(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v9695(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_262,axiom,
    ! [VarCurr] :
      ( v9716(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v9695(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_250,axiom,
    ! [VarCurr] :
      ( v9696(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v9695(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1851,axiom,
    ! [VarCurr] :
      ( v9717(VarCurr)
    <=> ( v9719(VarCurr)
        | v9722(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_728,axiom,
    ! [VarCurr] :
      ( v9722(VarCurr)
    <=> ( ( v9581(VarCurr,bitIndex6)
        <=> $true )
        & ( v9581(VarCurr,bitIndex5)
        <=> $false )
        & ( v9581(VarCurr,bitIndex4)
        <=> $false )
        & ( v9581(VarCurr,bitIndex3)
        <=> $true )
        & ( v9581(VarCurr,bitIndex2)
        <=> $false )
        & ( v9581(VarCurr,bitIndex1)
        <=> $true )
        & ( v9581(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1850,axiom,
    ! [VarCurr] :
      ( v9719(VarCurr)
    <=> ( v9720(VarCurr)
        | v9721(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_727,axiom,
    ! [VarCurr] :
      ( v9721(VarCurr)
    <=> ( ( v9581(VarCurr,bitIndex6)
        <=> $false )
        & ( v9581(VarCurr,bitIndex5)
        <=> $false )
        & ( v9581(VarCurr,bitIndex4)
        <=> $false )
        & ( v9581(VarCurr,bitIndex3)
        <=> $true )
        & ( v9581(VarCurr,bitIndex2)
        <=> $false )
        & ( v9581(VarCurr,bitIndex1)
        <=> $true )
        & ( v9581(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_726,axiom,
    ! [VarCurr] :
      ( v9720(VarCurr)
    <=> ( ( v9581(VarCurr,bitIndex6)
        <=> $false )
        & ( v9581(VarCurr,bitIndex5)
        <=> $false )
        & ( v9581(VarCurr,bitIndex4)
        <=> $false )
        & ( v9581(VarCurr,bitIndex3)
        <=> $true )
        & ( v9581(VarCurr,bitIndex2)
        <=> $false )
        & ( v9581(VarCurr,bitIndex1)
        <=> $true )
        & ( v9581(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_725,axiom,
    ! [VarCurr] :
      ( v9716(VarCurr)
    <=> ( ( v9581(VarCurr,bitIndex6)
        <=> $true )
        & ( v9581(VarCurr,bitIndex5)
        <=> $true )
        & ( v9581(VarCurr,bitIndex4)
        <=> $true )
        & ( v9581(VarCurr,bitIndex3)
        <=> $true )
        & ( v9581(VarCurr,bitIndex2)
        <=> $false )
        & ( v9581(VarCurr,bitIndex1)
        <=> $true )
        & ( v9581(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1849,axiom,
    ! [VarCurr] :
      ( v9696(VarCurr)
    <=> ( v9698(VarCurr)
        | v9715(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_724,axiom,
    ! [VarCurr] :
      ( v9715(VarCurr)
    <=> ( ( v9581(VarCurr,bitIndex6)
        <=> $true )
        & ( v9581(VarCurr,bitIndex5)
        <=> $false )
        & ( v9581(VarCurr,bitIndex4)
        <=> $false )
        & ( v9581(VarCurr,bitIndex3)
        <=> $false )
        & ( v9581(VarCurr,bitIndex2)
        <=> $true )
        & ( v9581(VarCurr,bitIndex1)
        <=> $false )
        & ( v9581(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1848,axiom,
    ! [VarCurr] :
      ( v9698(VarCurr)
    <=> ( v9699(VarCurr)
        | v9714(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_723,axiom,
    ! [VarCurr] :
      ( v9714(VarCurr)
    <=> ( ( v9581(VarCurr,bitIndex6)
        <=> $true )
        & ( v9581(VarCurr,bitIndex5)
        <=> $false )
        & ( v9581(VarCurr,bitIndex4)
        <=> $false )
        & ( v9581(VarCurr,bitIndex3)
        <=> $false )
        & ( v9581(VarCurr,bitIndex2)
        <=> $true )
        & ( v9581(VarCurr,bitIndex1)
        <=> $false )
        & ( v9581(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1847,axiom,
    ! [VarCurr] :
      ( v9699(VarCurr)
    <=> ( v9700(VarCurr)
        | v9713(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_722,axiom,
    ! [VarCurr] :
      ( v9713(VarCurr)
    <=> ( ( v9581(VarCurr,bitIndex6)
        <=> $true )
        & ( v9581(VarCurr,bitIndex5)
        <=> $true )
        & ( v9581(VarCurr,bitIndex4)
        <=> $false )
        & ( v9581(VarCurr,bitIndex3)
        <=> $false )
        & ( v9581(VarCurr,bitIndex2)
        <=> $false )
        & ( v9581(VarCurr,bitIndex1)
        <=> $false )
        & ( v9581(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1846,axiom,
    ! [VarCurr] :
      ( v9700(VarCurr)
    <=> ( v9701(VarCurr)
        | v9712(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_721,axiom,
    ! [VarCurr] :
      ( v9712(VarCurr)
    <=> ( ( v9581(VarCurr,bitIndex6)
        <=> $true )
        & ( v9581(VarCurr,bitIndex5)
        <=> $false )
        & ( v9581(VarCurr,bitIndex4)
        <=> $false )
        & ( v9581(VarCurr,bitIndex3)
        <=> $false )
        & ( v9581(VarCurr,bitIndex2)
        <=> $false )
        & ( v9581(VarCurr,bitIndex1)
        <=> $false )
        & ( v9581(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1845,axiom,
    ! [VarCurr] :
      ( v9701(VarCurr)
    <=> ( v9702(VarCurr)
        | v9711(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_720,axiom,
    ! [VarCurr] :
      ( v9711(VarCurr)
    <=> ( ( v9581(VarCurr,bitIndex6)
        <=> $true )
        & ( v9581(VarCurr,bitIndex5)
        <=> $false )
        & ( v9581(VarCurr,bitIndex4)
        <=> $false )
        & ( v9581(VarCurr,bitIndex3)
        <=> $false )
        & ( v9581(VarCurr,bitIndex2)
        <=> $false )
        & ( v9581(VarCurr,bitIndex1)
        <=> $true )
        & ( v9581(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1844,axiom,
    ! [VarCurr] :
      ( v9702(VarCurr)
    <=> ( v9703(VarCurr)
        | v9710(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_719,axiom,
    ! [VarCurr] :
      ( v9710(VarCurr)
    <=> ( ( v9581(VarCurr,bitIndex6)
        <=> $false )
        & ( v9581(VarCurr,bitIndex5)
        <=> $false )
        & ( v9581(VarCurr,bitIndex4)
        <=> $false )
        & ( v9581(VarCurr,bitIndex3)
        <=> $false )
        & ( v9581(VarCurr,bitIndex2)
        <=> $true )
        & ( v9581(VarCurr,bitIndex1)
        <=> $false )
        & ( v9581(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1843,axiom,
    ! [VarCurr] :
      ( v9703(VarCurr)
    <=> ( v9704(VarCurr)
        | v9709(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_718,axiom,
    ! [VarCurr] :
      ( v9709(VarCurr)
    <=> ( ( v9581(VarCurr,bitIndex6)
        <=> $false )
        & ( v9581(VarCurr,bitIndex5)
        <=> $false )
        & ( v9581(VarCurr,bitIndex4)
        <=> $false )
        & ( v9581(VarCurr,bitIndex3)
        <=> $false )
        & ( v9581(VarCurr,bitIndex2)
        <=> $true )
        & ( v9581(VarCurr,bitIndex1)
        <=> $false )
        & ( v9581(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1842,axiom,
    ! [VarCurr] :
      ( v9704(VarCurr)
    <=> ( v9705(VarCurr)
        | v9708(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_717,axiom,
    ! [VarCurr] :
      ( v9708(VarCurr)
    <=> ( ( v9581(VarCurr,bitIndex6)
        <=> $false )
        & ( v9581(VarCurr,bitIndex5)
        <=> $false )
        & ( v9581(VarCurr,bitIndex4)
        <=> $false )
        & ( v9581(VarCurr,bitIndex3)
        <=> $false )
        & ( v9581(VarCurr,bitIndex2)
        <=> $false )
        & ( v9581(VarCurr,bitIndex1)
        <=> $true )
        & ( v9581(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1841,axiom,
    ! [VarCurr] :
      ( v9705(VarCurr)
    <=> ( v9706(VarCurr)
        | v9707(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_716,axiom,
    ! [VarCurr] :
      ( v9707(VarCurr)
    <=> ( ( v9581(VarCurr,bitIndex6)
        <=> $false )
        & ( v9581(VarCurr,bitIndex5)
        <=> $true )
        & ( v9581(VarCurr,bitIndex4)
        <=> $false )
        & ( v9581(VarCurr,bitIndex3)
        <=> $false )
        & ( v9581(VarCurr,bitIndex2)
        <=> $false )
        & ( v9581(VarCurr,bitIndex1)
        <=> $false )
        & ( v9581(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_715,axiom,
    ! [VarCurr] :
      ( v9706(VarCurr)
    <=> ( ( v9581(VarCurr,bitIndex6)
        <=> $false )
        & ( v9581(VarCurr,bitIndex5)
        <=> $false )
        & ( v9581(VarCurr,bitIndex4)
        <=> $false )
        & ( v9581(VarCurr,bitIndex3)
        <=> $false )
        & ( v9581(VarCurr,bitIndex2)
        <=> $false )
        & ( v9581(VarCurr,bitIndex1)
        <=> $false )
        & ( v9581(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2247,axiom,
    ! [VarCurr] :
      ( ( v9581(VarCurr,bitIndex6)
      <=> v3053(VarCurr,bitIndex69) )
      & ( v9581(VarCurr,bitIndex5)
      <=> v3053(VarCurr,bitIndex68) )
      & ( v9581(VarCurr,bitIndex4)
      <=> v3053(VarCurr,bitIndex67) )
      & ( v9581(VarCurr,bitIndex3)
      <=> v3053(VarCurr,bitIndex66) )
      & ( v9581(VarCurr,bitIndex2)
      <=> v3053(VarCurr,bitIndex65) )
      & ( v9581(VarCurr,bitIndex1)
      <=> v3053(VarCurr,bitIndex64) )
      & ( v9581(VarCurr,bitIndex0)
      <=> v3053(VarCurr,bitIndex63) ) ) ).

fof(addAssignment_2246,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v3053(VarCurr,B)
      <=> v3055(VarCurr,B) ) ) ).

fof(addAssignment_2245,axiom,
    ! [VarCurr] :
      ( ( v3055(VarCurr,bitIndex69)
      <=> v3057(VarCurr,bitIndex559) )
      & ( v3055(VarCurr,bitIndex68)
      <=> v3057(VarCurr,bitIndex558) )
      & ( v3055(VarCurr,bitIndex67)
      <=> v3057(VarCurr,bitIndex557) )
      & ( v3055(VarCurr,bitIndex66)
      <=> v3057(VarCurr,bitIndex556) )
      & ( v3055(VarCurr,bitIndex65)
      <=> v3057(VarCurr,bitIndex555) )
      & ( v3055(VarCurr,bitIndex64)
      <=> v3057(VarCurr,bitIndex554) )
      & ( v3055(VarCurr,bitIndex63)
      <=> v3057(VarCurr,bitIndex553) ) ) ).

fof(addAssignment_2244,axiom,
    ! [VarNext] :
      ( ( v3057(VarNext,bitIndex559)
      <=> v9687(VarNext,bitIndex69) )
      & ( v3057(VarNext,bitIndex558)
      <=> v9687(VarNext,bitIndex68) )
      & ( v3057(VarNext,bitIndex557)
      <=> v9687(VarNext,bitIndex67) )
      & ( v3057(VarNext,bitIndex556)
      <=> v9687(VarNext,bitIndex66) )
      & ( v3057(VarNext,bitIndex555)
      <=> v9687(VarNext,bitIndex65) )
      & ( v3057(VarNext,bitIndex554)
      <=> v9687(VarNext,bitIndex64) )
      & ( v3057(VarNext,bitIndex553)
      <=> v9687(VarNext,bitIndex63) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_28,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9689(VarNext)
       => ( ( v9687(VarNext,bitIndex69)
          <=> v3057(VarCurr,bitIndex559) )
          & ( v9687(VarNext,bitIndex68)
          <=> v3057(VarCurr,bitIndex558) )
          & ( v9687(VarNext,bitIndex67)
          <=> v3057(VarCurr,bitIndex557) )
          & ( v9687(VarNext,bitIndex66)
          <=> v3057(VarCurr,bitIndex556) )
          & ( v9687(VarNext,bitIndex65)
          <=> v3057(VarCurr,bitIndex555) )
          & ( v9687(VarNext,bitIndex64)
          <=> v3057(VarCurr,bitIndex554) )
          & ( v9687(VarNext,bitIndex63)
          <=> v3057(VarCurr,bitIndex553) )
          & ( v9687(VarNext,bitIndex62)
          <=> v3057(VarCurr,bitIndex552) )
          & ( v9687(VarNext,bitIndex61)
          <=> v3057(VarCurr,bitIndex551) )
          & ( v9687(VarNext,bitIndex60)
          <=> v3057(VarCurr,bitIndex550) )
          & ( v9687(VarNext,bitIndex59)
          <=> v3057(VarCurr,bitIndex549) )
          & ( v9687(VarNext,bitIndex58)
          <=> v3057(VarCurr,bitIndex548) )
          & ( v9687(VarNext,bitIndex57)
          <=> v3057(VarCurr,bitIndex547) )
          & ( v9687(VarNext,bitIndex56)
          <=> v3057(VarCurr,bitIndex546) )
          & ( v9687(VarNext,bitIndex55)
          <=> v3057(VarCurr,bitIndex545) )
          & ( v9687(VarNext,bitIndex54)
          <=> v3057(VarCurr,bitIndex544) )
          & ( v9687(VarNext,bitIndex53)
          <=> v3057(VarCurr,bitIndex543) )
          & ( v9687(VarNext,bitIndex52)
          <=> v3057(VarCurr,bitIndex542) )
          & ( v9687(VarNext,bitIndex51)
          <=> v3057(VarCurr,bitIndex541) )
          & ( v9687(VarNext,bitIndex50)
          <=> v3057(VarCurr,bitIndex540) )
          & ( v9687(VarNext,bitIndex49)
          <=> v3057(VarCurr,bitIndex539) )
          & ( v9687(VarNext,bitIndex48)
          <=> v3057(VarCurr,bitIndex538) )
          & ( v9687(VarNext,bitIndex47)
          <=> v3057(VarCurr,bitIndex537) )
          & ( v9687(VarNext,bitIndex46)
          <=> v3057(VarCurr,bitIndex536) )
          & ( v9687(VarNext,bitIndex45)
          <=> v3057(VarCurr,bitIndex535) )
          & ( v9687(VarNext,bitIndex44)
          <=> v3057(VarCurr,bitIndex534) )
          & ( v9687(VarNext,bitIndex43)
          <=> v3057(VarCurr,bitIndex533) )
          & ( v9687(VarNext,bitIndex42)
          <=> v3057(VarCurr,bitIndex532) )
          & ( v9687(VarNext,bitIndex41)
          <=> v3057(VarCurr,bitIndex531) )
          & ( v9687(VarNext,bitIndex40)
          <=> v3057(VarCurr,bitIndex530) )
          & ( v9687(VarNext,bitIndex39)
          <=> v3057(VarCurr,bitIndex529) )
          & ( v9687(VarNext,bitIndex38)
          <=> v3057(VarCurr,bitIndex528) )
          & ( v9687(VarNext,bitIndex37)
          <=> v3057(VarCurr,bitIndex527) )
          & ( v9687(VarNext,bitIndex36)
          <=> v3057(VarCurr,bitIndex526) )
          & ( v9687(VarNext,bitIndex35)
          <=> v3057(VarCurr,bitIndex525) )
          & ( v9687(VarNext,bitIndex34)
          <=> v3057(VarCurr,bitIndex524) )
          & ( v9687(VarNext,bitIndex33)
          <=> v3057(VarCurr,bitIndex523) )
          & ( v9687(VarNext,bitIndex32)
          <=> v3057(VarCurr,bitIndex522) )
          & ( v9687(VarNext,bitIndex31)
          <=> v3057(VarCurr,bitIndex521) )
          & ( v9687(VarNext,bitIndex30)
          <=> v3057(VarCurr,bitIndex520) )
          & ( v9687(VarNext,bitIndex29)
          <=> v3057(VarCurr,bitIndex519) )
          & ( v9687(VarNext,bitIndex28)
          <=> v3057(VarCurr,bitIndex518) )
          & ( v9687(VarNext,bitIndex27)
          <=> v3057(VarCurr,bitIndex517) )
          & ( v9687(VarNext,bitIndex26)
          <=> v3057(VarCurr,bitIndex516) )
          & ( v9687(VarNext,bitIndex25)
          <=> v3057(VarCurr,bitIndex515) )
          & ( v9687(VarNext,bitIndex24)
          <=> v3057(VarCurr,bitIndex514) )
          & ( v9687(VarNext,bitIndex23)
          <=> v3057(VarCurr,bitIndex513) )
          & ( v9687(VarNext,bitIndex22)
          <=> v3057(VarCurr,bitIndex512) )
          & ( v9687(VarNext,bitIndex21)
          <=> v3057(VarCurr,bitIndex511) )
          & ( v9687(VarNext,bitIndex20)
          <=> v3057(VarCurr,bitIndex510) )
          & ( v9687(VarNext,bitIndex19)
          <=> v3057(VarCurr,bitIndex509) )
          & ( v9687(VarNext,bitIndex18)
          <=> v3057(VarCurr,bitIndex508) )
          & ( v9687(VarNext,bitIndex17)
          <=> v3057(VarCurr,bitIndex507) )
          & ( v9687(VarNext,bitIndex16)
          <=> v3057(VarCurr,bitIndex506) )
          & ( v9687(VarNext,bitIndex15)
          <=> v3057(VarCurr,bitIndex505) )
          & ( v9687(VarNext,bitIndex14)
          <=> v3057(VarCurr,bitIndex504) )
          & ( v9687(VarNext,bitIndex13)
          <=> v3057(VarCurr,bitIndex503) )
          & ( v9687(VarNext,bitIndex12)
          <=> v3057(VarCurr,bitIndex502) )
          & ( v9687(VarNext,bitIndex11)
          <=> v3057(VarCurr,bitIndex501) )
          & ( v9687(VarNext,bitIndex10)
          <=> v3057(VarCurr,bitIndex500) )
          & ( v9687(VarNext,bitIndex9)
          <=> v3057(VarCurr,bitIndex499) )
          & ( v9687(VarNext,bitIndex8)
          <=> v3057(VarCurr,bitIndex498) )
          & ( v9687(VarNext,bitIndex7)
          <=> v3057(VarCurr,bitIndex497) )
          & ( v9687(VarNext,bitIndex6)
          <=> v3057(VarCurr,bitIndex496) )
          & ( v9687(VarNext,bitIndex5)
          <=> v3057(VarCurr,bitIndex495) )
          & ( v9687(VarNext,bitIndex4)
          <=> v3057(VarCurr,bitIndex494) )
          & ( v9687(VarNext,bitIndex3)
          <=> v3057(VarCurr,bitIndex493) )
          & ( v9687(VarNext,bitIndex2)
          <=> v3057(VarCurr,bitIndex492) )
          & ( v9687(VarNext,bitIndex1)
          <=> v3057(VarCurr,bitIndex491) )
          & ( v9687(VarNext,bitIndex0)
          <=> v3057(VarCurr,bitIndex490) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_181,axiom,
    ! [VarNext] :
      ( v9689(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v9687(VarNext,B)
          <=> v9010(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1840,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9689(VarNext)
      <=> ( v9690(VarNext)
          & v8992(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1839,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9690(VarNext)
      <=> ( v9692(VarNext)
          & v3071(VarNext) ) ) ) ).

fof(writeUnaryOperator_840,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9692(VarNext)
      <=> v3086(VarNext) ) ) ).

fof(addAssignment_2243,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v8976(VarCurr,B)
      <=> v8981(VarCurr,B) ) ) ).

fof(addAssignment_2242,axiom,
    ! [VarCurr] :
      ( ( v8980(VarCurr,bitIndex69)
      <=> v3057(VarCurr,bitIndex489) )
      & ( v8980(VarCurr,bitIndex68)
      <=> v3057(VarCurr,bitIndex488) )
      & ( v8980(VarCurr,bitIndex67)
      <=> v3057(VarCurr,bitIndex487) )
      & ( v8980(VarCurr,bitIndex66)
      <=> v3057(VarCurr,bitIndex486) )
      & ( v8980(VarCurr,bitIndex65)
      <=> v3057(VarCurr,bitIndex485) )
      & ( v8980(VarCurr,bitIndex64)
      <=> v3057(VarCurr,bitIndex484) )
      & ( v8980(VarCurr,bitIndex63)
      <=> v3057(VarCurr,bitIndex483) ) ) ).

fof(addAssignment_2241,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v8969(VarCurr,B)
      <=> v8974(VarCurr,B) ) ) ).

fof(addAssignment_2240,axiom,
    ! [VarCurr] :
      ( ( v8973(VarCurr,bitIndex69)
      <=> v3057(VarCurr,bitIndex559) )
      & ( v8973(VarCurr,bitIndex68)
      <=> v3057(VarCurr,bitIndex558) )
      & ( v8973(VarCurr,bitIndex67)
      <=> v3057(VarCurr,bitIndex557) )
      & ( v8973(VarCurr,bitIndex66)
      <=> v3057(VarCurr,bitIndex556) )
      & ( v8973(VarCurr,bitIndex65)
      <=> v3057(VarCurr,bitIndex555) )
      & ( v8973(VarCurr,bitIndex64)
      <=> v3057(VarCurr,bitIndex554) )
      & ( v8973(VarCurr,bitIndex63)
      <=> v3057(VarCurr,bitIndex553) ) ) ).

fof(addAssignment_2239,axiom,
    ! [VarNext] :
      ( ( v3057(VarNext,bitIndex489)
      <=> v9679(VarNext,bitIndex69) )
      & ( v3057(VarNext,bitIndex488)
      <=> v9679(VarNext,bitIndex68) )
      & ( v3057(VarNext,bitIndex487)
      <=> v9679(VarNext,bitIndex67) )
      & ( v3057(VarNext,bitIndex486)
      <=> v9679(VarNext,bitIndex66) )
      & ( v3057(VarNext,bitIndex485)
      <=> v9679(VarNext,bitIndex65) )
      & ( v3057(VarNext,bitIndex484)
      <=> v9679(VarNext,bitIndex64) )
      & ( v3057(VarNext,bitIndex483)
      <=> v9679(VarNext,bitIndex63) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_27,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9681(VarNext)
       => ( ( v9679(VarNext,bitIndex69)
          <=> v3057(VarCurr,bitIndex489) )
          & ( v9679(VarNext,bitIndex68)
          <=> v3057(VarCurr,bitIndex488) )
          & ( v9679(VarNext,bitIndex67)
          <=> v3057(VarCurr,bitIndex487) )
          & ( v9679(VarNext,bitIndex66)
          <=> v3057(VarCurr,bitIndex486) )
          & ( v9679(VarNext,bitIndex65)
          <=> v3057(VarCurr,bitIndex485) )
          & ( v9679(VarNext,bitIndex64)
          <=> v3057(VarCurr,bitIndex484) )
          & ( v9679(VarNext,bitIndex63)
          <=> v3057(VarCurr,bitIndex483) )
          & ( v9679(VarNext,bitIndex62)
          <=> v3057(VarCurr,bitIndex482) )
          & ( v9679(VarNext,bitIndex61)
          <=> v3057(VarCurr,bitIndex481) )
          & ( v9679(VarNext,bitIndex60)
          <=> v3057(VarCurr,bitIndex480) )
          & ( v9679(VarNext,bitIndex59)
          <=> v3057(VarCurr,bitIndex479) )
          & ( v9679(VarNext,bitIndex58)
          <=> v3057(VarCurr,bitIndex478) )
          & ( v9679(VarNext,bitIndex57)
          <=> v3057(VarCurr,bitIndex477) )
          & ( v9679(VarNext,bitIndex56)
          <=> v3057(VarCurr,bitIndex476) )
          & ( v9679(VarNext,bitIndex55)
          <=> v3057(VarCurr,bitIndex475) )
          & ( v9679(VarNext,bitIndex54)
          <=> v3057(VarCurr,bitIndex474) )
          & ( v9679(VarNext,bitIndex53)
          <=> v3057(VarCurr,bitIndex473) )
          & ( v9679(VarNext,bitIndex52)
          <=> v3057(VarCurr,bitIndex472) )
          & ( v9679(VarNext,bitIndex51)
          <=> v3057(VarCurr,bitIndex471) )
          & ( v9679(VarNext,bitIndex50)
          <=> v3057(VarCurr,bitIndex470) )
          & ( v9679(VarNext,bitIndex49)
          <=> v3057(VarCurr,bitIndex469) )
          & ( v9679(VarNext,bitIndex48)
          <=> v3057(VarCurr,bitIndex468) )
          & ( v9679(VarNext,bitIndex47)
          <=> v3057(VarCurr,bitIndex467) )
          & ( v9679(VarNext,bitIndex46)
          <=> v3057(VarCurr,bitIndex466) )
          & ( v9679(VarNext,bitIndex45)
          <=> v3057(VarCurr,bitIndex465) )
          & ( v9679(VarNext,bitIndex44)
          <=> v3057(VarCurr,bitIndex464) )
          & ( v9679(VarNext,bitIndex43)
          <=> v3057(VarCurr,bitIndex463) )
          & ( v9679(VarNext,bitIndex42)
          <=> v3057(VarCurr,bitIndex462) )
          & ( v9679(VarNext,bitIndex41)
          <=> v3057(VarCurr,bitIndex461) )
          & ( v9679(VarNext,bitIndex40)
          <=> v3057(VarCurr,bitIndex460) )
          & ( v9679(VarNext,bitIndex39)
          <=> v3057(VarCurr,bitIndex459) )
          & ( v9679(VarNext,bitIndex38)
          <=> v3057(VarCurr,bitIndex458) )
          & ( v9679(VarNext,bitIndex37)
          <=> v3057(VarCurr,bitIndex457) )
          & ( v9679(VarNext,bitIndex36)
          <=> v3057(VarCurr,bitIndex456) )
          & ( v9679(VarNext,bitIndex35)
          <=> v3057(VarCurr,bitIndex455) )
          & ( v9679(VarNext,bitIndex34)
          <=> v3057(VarCurr,bitIndex454) )
          & ( v9679(VarNext,bitIndex33)
          <=> v3057(VarCurr,bitIndex453) )
          & ( v9679(VarNext,bitIndex32)
          <=> v3057(VarCurr,bitIndex452) )
          & ( v9679(VarNext,bitIndex31)
          <=> v3057(VarCurr,bitIndex451) )
          & ( v9679(VarNext,bitIndex30)
          <=> v3057(VarCurr,bitIndex450) )
          & ( v9679(VarNext,bitIndex29)
          <=> v3057(VarCurr,bitIndex449) )
          & ( v9679(VarNext,bitIndex28)
          <=> v3057(VarCurr,bitIndex448) )
          & ( v9679(VarNext,bitIndex27)
          <=> v3057(VarCurr,bitIndex447) )
          & ( v9679(VarNext,bitIndex26)
          <=> v3057(VarCurr,bitIndex446) )
          & ( v9679(VarNext,bitIndex25)
          <=> v3057(VarCurr,bitIndex445) )
          & ( v9679(VarNext,bitIndex24)
          <=> v3057(VarCurr,bitIndex444) )
          & ( v9679(VarNext,bitIndex23)
          <=> v3057(VarCurr,bitIndex443) )
          & ( v9679(VarNext,bitIndex22)
          <=> v3057(VarCurr,bitIndex442) )
          & ( v9679(VarNext,bitIndex21)
          <=> v3057(VarCurr,bitIndex441) )
          & ( v9679(VarNext,bitIndex20)
          <=> v3057(VarCurr,bitIndex440) )
          & ( v9679(VarNext,bitIndex19)
          <=> v3057(VarCurr,bitIndex439) )
          & ( v9679(VarNext,bitIndex18)
          <=> v3057(VarCurr,bitIndex438) )
          & ( v9679(VarNext,bitIndex17)
          <=> v3057(VarCurr,bitIndex437) )
          & ( v9679(VarNext,bitIndex16)
          <=> v3057(VarCurr,bitIndex436) )
          & ( v9679(VarNext,bitIndex15)
          <=> v3057(VarCurr,bitIndex435) )
          & ( v9679(VarNext,bitIndex14)
          <=> v3057(VarCurr,bitIndex434) )
          & ( v9679(VarNext,bitIndex13)
          <=> v3057(VarCurr,bitIndex433) )
          & ( v9679(VarNext,bitIndex12)
          <=> v3057(VarCurr,bitIndex432) )
          & ( v9679(VarNext,bitIndex11)
          <=> v3057(VarCurr,bitIndex431) )
          & ( v9679(VarNext,bitIndex10)
          <=> v3057(VarCurr,bitIndex430) )
          & ( v9679(VarNext,bitIndex9)
          <=> v3057(VarCurr,bitIndex429) )
          & ( v9679(VarNext,bitIndex8)
          <=> v3057(VarCurr,bitIndex428) )
          & ( v9679(VarNext,bitIndex7)
          <=> v3057(VarCurr,bitIndex427) )
          & ( v9679(VarNext,bitIndex6)
          <=> v3057(VarCurr,bitIndex426) )
          & ( v9679(VarNext,bitIndex5)
          <=> v3057(VarCurr,bitIndex425) )
          & ( v9679(VarNext,bitIndex4)
          <=> v3057(VarCurr,bitIndex424) )
          & ( v9679(VarNext,bitIndex3)
          <=> v3057(VarCurr,bitIndex423) )
          & ( v9679(VarNext,bitIndex2)
          <=> v3057(VarCurr,bitIndex422) )
          & ( v9679(VarNext,bitIndex1)
          <=> v3057(VarCurr,bitIndex421) )
          & ( v9679(VarNext,bitIndex0)
          <=> v3057(VarCurr,bitIndex420) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_180,axiom,
    ! [VarNext] :
      ( v9681(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v9679(VarNext,B)
          <=> v8964(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1838,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9681(VarNext)
      <=> ( v9682(VarNext)
          & v8946(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1837,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9682(VarNext)
      <=> ( v9684(VarNext)
          & v3071(VarNext) ) ) ) ).

fof(writeUnaryOperator_839,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9684(VarNext)
      <=> v3086(VarNext) ) ) ).

fof(addAssignment_2238,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v8930(VarCurr,B)
      <=> v8935(VarCurr,B) ) ) ).

fof(addAssignment_2237,axiom,
    ! [VarCurr] :
      ( ( v8934(VarCurr,bitIndex69)
      <=> v3057(VarCurr,bitIndex419) )
      & ( v8934(VarCurr,bitIndex68)
      <=> v3057(VarCurr,bitIndex418) )
      & ( v8934(VarCurr,bitIndex67)
      <=> v3057(VarCurr,bitIndex417) )
      & ( v8934(VarCurr,bitIndex66)
      <=> v3057(VarCurr,bitIndex416) )
      & ( v8934(VarCurr,bitIndex65)
      <=> v3057(VarCurr,bitIndex415) )
      & ( v8934(VarCurr,bitIndex64)
      <=> v3057(VarCurr,bitIndex414) )
      & ( v8934(VarCurr,bitIndex63)
      <=> v3057(VarCurr,bitIndex413) ) ) ).

fof(addAssignment_2236,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v8923(VarCurr,B)
      <=> v8928(VarCurr,B) ) ) ).

fof(addAssignment_2235,axiom,
    ! [VarCurr] :
      ( ( v8927(VarCurr,bitIndex69)
      <=> v3057(VarCurr,bitIndex489) )
      & ( v8927(VarCurr,bitIndex68)
      <=> v3057(VarCurr,bitIndex488) )
      & ( v8927(VarCurr,bitIndex67)
      <=> v3057(VarCurr,bitIndex487) )
      & ( v8927(VarCurr,bitIndex66)
      <=> v3057(VarCurr,bitIndex486) )
      & ( v8927(VarCurr,bitIndex65)
      <=> v3057(VarCurr,bitIndex485) )
      & ( v8927(VarCurr,bitIndex64)
      <=> v3057(VarCurr,bitIndex484) )
      & ( v8927(VarCurr,bitIndex63)
      <=> v3057(VarCurr,bitIndex483) ) ) ).

fof(addAssignment_2234,axiom,
    ! [VarNext] :
      ( ( v3057(VarNext,bitIndex419)
      <=> v9671(VarNext,bitIndex69) )
      & ( v3057(VarNext,bitIndex418)
      <=> v9671(VarNext,bitIndex68) )
      & ( v3057(VarNext,bitIndex417)
      <=> v9671(VarNext,bitIndex67) )
      & ( v3057(VarNext,bitIndex416)
      <=> v9671(VarNext,bitIndex66) )
      & ( v3057(VarNext,bitIndex415)
      <=> v9671(VarNext,bitIndex65) )
      & ( v3057(VarNext,bitIndex414)
      <=> v9671(VarNext,bitIndex64) )
      & ( v3057(VarNext,bitIndex413)
      <=> v9671(VarNext,bitIndex63) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_26,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9673(VarNext)
       => ( ( v9671(VarNext,bitIndex69)
          <=> v3057(VarCurr,bitIndex419) )
          & ( v9671(VarNext,bitIndex68)
          <=> v3057(VarCurr,bitIndex418) )
          & ( v9671(VarNext,bitIndex67)
          <=> v3057(VarCurr,bitIndex417) )
          & ( v9671(VarNext,bitIndex66)
          <=> v3057(VarCurr,bitIndex416) )
          & ( v9671(VarNext,bitIndex65)
          <=> v3057(VarCurr,bitIndex415) )
          & ( v9671(VarNext,bitIndex64)
          <=> v3057(VarCurr,bitIndex414) )
          & ( v9671(VarNext,bitIndex63)
          <=> v3057(VarCurr,bitIndex413) )
          & ( v9671(VarNext,bitIndex62)
          <=> v3057(VarCurr,bitIndex412) )
          & ( v9671(VarNext,bitIndex61)
          <=> v3057(VarCurr,bitIndex411) )
          & ( v9671(VarNext,bitIndex60)
          <=> v3057(VarCurr,bitIndex410) )
          & ( v9671(VarNext,bitIndex59)
          <=> v3057(VarCurr,bitIndex409) )
          & ( v9671(VarNext,bitIndex58)
          <=> v3057(VarCurr,bitIndex408) )
          & ( v9671(VarNext,bitIndex57)
          <=> v3057(VarCurr,bitIndex407) )
          & ( v9671(VarNext,bitIndex56)
          <=> v3057(VarCurr,bitIndex406) )
          & ( v9671(VarNext,bitIndex55)
          <=> v3057(VarCurr,bitIndex405) )
          & ( v9671(VarNext,bitIndex54)
          <=> v3057(VarCurr,bitIndex404) )
          & ( v9671(VarNext,bitIndex53)
          <=> v3057(VarCurr,bitIndex403) )
          & ( v9671(VarNext,bitIndex52)
          <=> v3057(VarCurr,bitIndex402) )
          & ( v9671(VarNext,bitIndex51)
          <=> v3057(VarCurr,bitIndex401) )
          & ( v9671(VarNext,bitIndex50)
          <=> v3057(VarCurr,bitIndex400) )
          & ( v9671(VarNext,bitIndex49)
          <=> v3057(VarCurr,bitIndex399) )
          & ( v9671(VarNext,bitIndex48)
          <=> v3057(VarCurr,bitIndex398) )
          & ( v9671(VarNext,bitIndex47)
          <=> v3057(VarCurr,bitIndex397) )
          & ( v9671(VarNext,bitIndex46)
          <=> v3057(VarCurr,bitIndex396) )
          & ( v9671(VarNext,bitIndex45)
          <=> v3057(VarCurr,bitIndex395) )
          & ( v9671(VarNext,bitIndex44)
          <=> v3057(VarCurr,bitIndex394) )
          & ( v9671(VarNext,bitIndex43)
          <=> v3057(VarCurr,bitIndex393) )
          & ( v9671(VarNext,bitIndex42)
          <=> v3057(VarCurr,bitIndex392) )
          & ( v9671(VarNext,bitIndex41)
          <=> v3057(VarCurr,bitIndex391) )
          & ( v9671(VarNext,bitIndex40)
          <=> v3057(VarCurr,bitIndex390) )
          & ( v9671(VarNext,bitIndex39)
          <=> v3057(VarCurr,bitIndex389) )
          & ( v9671(VarNext,bitIndex38)
          <=> v3057(VarCurr,bitIndex388) )
          & ( v9671(VarNext,bitIndex37)
          <=> v3057(VarCurr,bitIndex387) )
          & ( v9671(VarNext,bitIndex36)
          <=> v3057(VarCurr,bitIndex386) )
          & ( v9671(VarNext,bitIndex35)
          <=> v3057(VarCurr,bitIndex385) )
          & ( v9671(VarNext,bitIndex34)
          <=> v3057(VarCurr,bitIndex384) )
          & ( v9671(VarNext,bitIndex33)
          <=> v3057(VarCurr,bitIndex383) )
          & ( v9671(VarNext,bitIndex32)
          <=> v3057(VarCurr,bitIndex382) )
          & ( v9671(VarNext,bitIndex31)
          <=> v3057(VarCurr,bitIndex381) )
          & ( v9671(VarNext,bitIndex30)
          <=> v3057(VarCurr,bitIndex380) )
          & ( v9671(VarNext,bitIndex29)
          <=> v3057(VarCurr,bitIndex379) )
          & ( v9671(VarNext,bitIndex28)
          <=> v3057(VarCurr,bitIndex378) )
          & ( v9671(VarNext,bitIndex27)
          <=> v3057(VarCurr,bitIndex377) )
          & ( v9671(VarNext,bitIndex26)
          <=> v3057(VarCurr,bitIndex376) )
          & ( v9671(VarNext,bitIndex25)
          <=> v3057(VarCurr,bitIndex375) )
          & ( v9671(VarNext,bitIndex24)
          <=> v3057(VarCurr,bitIndex374) )
          & ( v9671(VarNext,bitIndex23)
          <=> v3057(VarCurr,bitIndex373) )
          & ( v9671(VarNext,bitIndex22)
          <=> v3057(VarCurr,bitIndex372) )
          & ( v9671(VarNext,bitIndex21)
          <=> v3057(VarCurr,bitIndex371) )
          & ( v9671(VarNext,bitIndex20)
          <=> v3057(VarCurr,bitIndex370) )
          & ( v9671(VarNext,bitIndex19)
          <=> v3057(VarCurr,bitIndex369) )
          & ( v9671(VarNext,bitIndex18)
          <=> v3057(VarCurr,bitIndex368) )
          & ( v9671(VarNext,bitIndex17)
          <=> v3057(VarCurr,bitIndex367) )
          & ( v9671(VarNext,bitIndex16)
          <=> v3057(VarCurr,bitIndex366) )
          & ( v9671(VarNext,bitIndex15)
          <=> v3057(VarCurr,bitIndex365) )
          & ( v9671(VarNext,bitIndex14)
          <=> v3057(VarCurr,bitIndex364) )
          & ( v9671(VarNext,bitIndex13)
          <=> v3057(VarCurr,bitIndex363) )
          & ( v9671(VarNext,bitIndex12)
          <=> v3057(VarCurr,bitIndex362) )
          & ( v9671(VarNext,bitIndex11)
          <=> v3057(VarCurr,bitIndex361) )
          & ( v9671(VarNext,bitIndex10)
          <=> v3057(VarCurr,bitIndex360) )
          & ( v9671(VarNext,bitIndex9)
          <=> v3057(VarCurr,bitIndex359) )
          & ( v9671(VarNext,bitIndex8)
          <=> v3057(VarCurr,bitIndex358) )
          & ( v9671(VarNext,bitIndex7)
          <=> v3057(VarCurr,bitIndex357) )
          & ( v9671(VarNext,bitIndex6)
          <=> v3057(VarCurr,bitIndex356) )
          & ( v9671(VarNext,bitIndex5)
          <=> v3057(VarCurr,bitIndex355) )
          & ( v9671(VarNext,bitIndex4)
          <=> v3057(VarCurr,bitIndex354) )
          & ( v9671(VarNext,bitIndex3)
          <=> v3057(VarCurr,bitIndex353) )
          & ( v9671(VarNext,bitIndex2)
          <=> v3057(VarCurr,bitIndex352) )
          & ( v9671(VarNext,bitIndex1)
          <=> v3057(VarCurr,bitIndex351) )
          & ( v9671(VarNext,bitIndex0)
          <=> v3057(VarCurr,bitIndex350) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_179,axiom,
    ! [VarNext] :
      ( v9673(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v9671(VarNext,B)
          <=> v8918(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1836,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9673(VarNext)
      <=> ( v9674(VarNext)
          & v8900(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1835,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9674(VarNext)
      <=> ( v9676(VarNext)
          & v3071(VarNext) ) ) ) ).

fof(writeUnaryOperator_838,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9676(VarNext)
      <=> v3086(VarNext) ) ) ).

fof(addAssignment_2233,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v8884(VarCurr,B)
      <=> v8889(VarCurr,B) ) ) ).

fof(addAssignment_2232,axiom,
    ! [VarCurr] :
      ( ( v8888(VarCurr,bitIndex69)
      <=> v3057(VarCurr,bitIndex349) )
      & ( v8888(VarCurr,bitIndex68)
      <=> v3057(VarCurr,bitIndex348) )
      & ( v8888(VarCurr,bitIndex67)
      <=> v3057(VarCurr,bitIndex347) )
      & ( v8888(VarCurr,bitIndex66)
      <=> v3057(VarCurr,bitIndex346) )
      & ( v8888(VarCurr,bitIndex65)
      <=> v3057(VarCurr,bitIndex345) )
      & ( v8888(VarCurr,bitIndex64)
      <=> v3057(VarCurr,bitIndex344) )
      & ( v8888(VarCurr,bitIndex63)
      <=> v3057(VarCurr,bitIndex343) ) ) ).

fof(addAssignment_2231,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v8877(VarCurr,B)
      <=> v8882(VarCurr,B) ) ) ).

fof(addAssignment_2230,axiom,
    ! [VarCurr] :
      ( ( v8881(VarCurr,bitIndex69)
      <=> v3057(VarCurr,bitIndex419) )
      & ( v8881(VarCurr,bitIndex68)
      <=> v3057(VarCurr,bitIndex418) )
      & ( v8881(VarCurr,bitIndex67)
      <=> v3057(VarCurr,bitIndex417) )
      & ( v8881(VarCurr,bitIndex66)
      <=> v3057(VarCurr,bitIndex416) )
      & ( v8881(VarCurr,bitIndex65)
      <=> v3057(VarCurr,bitIndex415) )
      & ( v8881(VarCurr,bitIndex64)
      <=> v3057(VarCurr,bitIndex414) )
      & ( v8881(VarCurr,bitIndex63)
      <=> v3057(VarCurr,bitIndex413) ) ) ).

fof(addAssignment_2229,axiom,
    ! [VarNext] :
      ( ( v3057(VarNext,bitIndex349)
      <=> v9663(VarNext,bitIndex69) )
      & ( v3057(VarNext,bitIndex348)
      <=> v9663(VarNext,bitIndex68) )
      & ( v3057(VarNext,bitIndex347)
      <=> v9663(VarNext,bitIndex67) )
      & ( v3057(VarNext,bitIndex346)
      <=> v9663(VarNext,bitIndex66) )
      & ( v3057(VarNext,bitIndex345)
      <=> v9663(VarNext,bitIndex65) )
      & ( v3057(VarNext,bitIndex344)
      <=> v9663(VarNext,bitIndex64) )
      & ( v3057(VarNext,bitIndex343)
      <=> v9663(VarNext,bitIndex63) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_25,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9665(VarNext)
       => ( ( v9663(VarNext,bitIndex69)
          <=> v3057(VarCurr,bitIndex349) )
          & ( v9663(VarNext,bitIndex68)
          <=> v3057(VarCurr,bitIndex348) )
          & ( v9663(VarNext,bitIndex67)
          <=> v3057(VarCurr,bitIndex347) )
          & ( v9663(VarNext,bitIndex66)
          <=> v3057(VarCurr,bitIndex346) )
          & ( v9663(VarNext,bitIndex65)
          <=> v3057(VarCurr,bitIndex345) )
          & ( v9663(VarNext,bitIndex64)
          <=> v3057(VarCurr,bitIndex344) )
          & ( v9663(VarNext,bitIndex63)
          <=> v3057(VarCurr,bitIndex343) )
          & ( v9663(VarNext,bitIndex62)
          <=> v3057(VarCurr,bitIndex342) )
          & ( v9663(VarNext,bitIndex61)
          <=> v3057(VarCurr,bitIndex341) )
          & ( v9663(VarNext,bitIndex60)
          <=> v3057(VarCurr,bitIndex340) )
          & ( v9663(VarNext,bitIndex59)
          <=> v3057(VarCurr,bitIndex339) )
          & ( v9663(VarNext,bitIndex58)
          <=> v3057(VarCurr,bitIndex338) )
          & ( v9663(VarNext,bitIndex57)
          <=> v3057(VarCurr,bitIndex337) )
          & ( v9663(VarNext,bitIndex56)
          <=> v3057(VarCurr,bitIndex336) )
          & ( v9663(VarNext,bitIndex55)
          <=> v3057(VarCurr,bitIndex335) )
          & ( v9663(VarNext,bitIndex54)
          <=> v3057(VarCurr,bitIndex334) )
          & ( v9663(VarNext,bitIndex53)
          <=> v3057(VarCurr,bitIndex333) )
          & ( v9663(VarNext,bitIndex52)
          <=> v3057(VarCurr,bitIndex332) )
          & ( v9663(VarNext,bitIndex51)
          <=> v3057(VarCurr,bitIndex331) )
          & ( v9663(VarNext,bitIndex50)
          <=> v3057(VarCurr,bitIndex330) )
          & ( v9663(VarNext,bitIndex49)
          <=> v3057(VarCurr,bitIndex329) )
          & ( v9663(VarNext,bitIndex48)
          <=> v3057(VarCurr,bitIndex328) )
          & ( v9663(VarNext,bitIndex47)
          <=> v3057(VarCurr,bitIndex327) )
          & ( v9663(VarNext,bitIndex46)
          <=> v3057(VarCurr,bitIndex326) )
          & ( v9663(VarNext,bitIndex45)
          <=> v3057(VarCurr,bitIndex325) )
          & ( v9663(VarNext,bitIndex44)
          <=> v3057(VarCurr,bitIndex324) )
          & ( v9663(VarNext,bitIndex43)
          <=> v3057(VarCurr,bitIndex323) )
          & ( v9663(VarNext,bitIndex42)
          <=> v3057(VarCurr,bitIndex322) )
          & ( v9663(VarNext,bitIndex41)
          <=> v3057(VarCurr,bitIndex321) )
          & ( v9663(VarNext,bitIndex40)
          <=> v3057(VarCurr,bitIndex320) )
          & ( v9663(VarNext,bitIndex39)
          <=> v3057(VarCurr,bitIndex319) )
          & ( v9663(VarNext,bitIndex38)
          <=> v3057(VarCurr,bitIndex318) )
          & ( v9663(VarNext,bitIndex37)
          <=> v3057(VarCurr,bitIndex317) )
          & ( v9663(VarNext,bitIndex36)
          <=> v3057(VarCurr,bitIndex316) )
          & ( v9663(VarNext,bitIndex35)
          <=> v3057(VarCurr,bitIndex315) )
          & ( v9663(VarNext,bitIndex34)
          <=> v3057(VarCurr,bitIndex314) )
          & ( v9663(VarNext,bitIndex33)
          <=> v3057(VarCurr,bitIndex313) )
          & ( v9663(VarNext,bitIndex32)
          <=> v3057(VarCurr,bitIndex312) )
          & ( v9663(VarNext,bitIndex31)
          <=> v3057(VarCurr,bitIndex311) )
          & ( v9663(VarNext,bitIndex30)
          <=> v3057(VarCurr,bitIndex310) )
          & ( v9663(VarNext,bitIndex29)
          <=> v3057(VarCurr,bitIndex309) )
          & ( v9663(VarNext,bitIndex28)
          <=> v3057(VarCurr,bitIndex308) )
          & ( v9663(VarNext,bitIndex27)
          <=> v3057(VarCurr,bitIndex307) )
          & ( v9663(VarNext,bitIndex26)
          <=> v3057(VarCurr,bitIndex306) )
          & ( v9663(VarNext,bitIndex25)
          <=> v3057(VarCurr,bitIndex305) )
          & ( v9663(VarNext,bitIndex24)
          <=> v3057(VarCurr,bitIndex304) )
          & ( v9663(VarNext,bitIndex23)
          <=> v3057(VarCurr,bitIndex303) )
          & ( v9663(VarNext,bitIndex22)
          <=> v3057(VarCurr,bitIndex302) )
          & ( v9663(VarNext,bitIndex21)
          <=> v3057(VarCurr,bitIndex301) )
          & ( v9663(VarNext,bitIndex20)
          <=> v3057(VarCurr,bitIndex300) )
          & ( v9663(VarNext,bitIndex19)
          <=> v3057(VarCurr,bitIndex299) )
          & ( v9663(VarNext,bitIndex18)
          <=> v3057(VarCurr,bitIndex298) )
          & ( v9663(VarNext,bitIndex17)
          <=> v3057(VarCurr,bitIndex297) )
          & ( v9663(VarNext,bitIndex16)
          <=> v3057(VarCurr,bitIndex296) )
          & ( v9663(VarNext,bitIndex15)
          <=> v3057(VarCurr,bitIndex295) )
          & ( v9663(VarNext,bitIndex14)
          <=> v3057(VarCurr,bitIndex294) )
          & ( v9663(VarNext,bitIndex13)
          <=> v3057(VarCurr,bitIndex293) )
          & ( v9663(VarNext,bitIndex12)
          <=> v3057(VarCurr,bitIndex292) )
          & ( v9663(VarNext,bitIndex11)
          <=> v3057(VarCurr,bitIndex291) )
          & ( v9663(VarNext,bitIndex10)
          <=> v3057(VarCurr,bitIndex290) )
          & ( v9663(VarNext,bitIndex9)
          <=> v3057(VarCurr,bitIndex289) )
          & ( v9663(VarNext,bitIndex8)
          <=> v3057(VarCurr,bitIndex288) )
          & ( v9663(VarNext,bitIndex7)
          <=> v3057(VarCurr,bitIndex287) )
          & ( v9663(VarNext,bitIndex6)
          <=> v3057(VarCurr,bitIndex286) )
          & ( v9663(VarNext,bitIndex5)
          <=> v3057(VarCurr,bitIndex285) )
          & ( v9663(VarNext,bitIndex4)
          <=> v3057(VarCurr,bitIndex284) )
          & ( v9663(VarNext,bitIndex3)
          <=> v3057(VarCurr,bitIndex283) )
          & ( v9663(VarNext,bitIndex2)
          <=> v3057(VarCurr,bitIndex282) )
          & ( v9663(VarNext,bitIndex1)
          <=> v3057(VarCurr,bitIndex281) )
          & ( v9663(VarNext,bitIndex0)
          <=> v3057(VarCurr,bitIndex280) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_178,axiom,
    ! [VarNext] :
      ( v9665(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v9663(VarNext,B)
          <=> v8872(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1834,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9665(VarNext)
      <=> ( v9666(VarNext)
          & v8853(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1833,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9666(VarNext)
      <=> ( v9668(VarNext)
          & v3071(VarNext) ) ) ) ).

fof(writeUnaryOperator_837,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9668(VarNext)
      <=> v3086(VarNext) ) ) ).

fof(addAssignment_2228,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v8837(VarCurr,B)
      <=> v8842(VarCurr,B) ) ) ).

fof(addAssignment_2227,axiom,
    ! [VarCurr] :
      ( ( v8841(VarCurr,bitIndex69)
      <=> v3057(VarCurr,bitIndex279) )
      & ( v8841(VarCurr,bitIndex68)
      <=> v3057(VarCurr,bitIndex278) )
      & ( v8841(VarCurr,bitIndex67)
      <=> v3057(VarCurr,bitIndex277) )
      & ( v8841(VarCurr,bitIndex66)
      <=> v3057(VarCurr,bitIndex276) )
      & ( v8841(VarCurr,bitIndex65)
      <=> v3057(VarCurr,bitIndex275) )
      & ( v8841(VarCurr,bitIndex64)
      <=> v3057(VarCurr,bitIndex274) )
      & ( v8841(VarCurr,bitIndex63)
      <=> v3057(VarCurr,bitIndex273) ) ) ).

fof(addAssignment_2226,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v3060(VarCurr,B)
      <=> v8835(VarCurr,B) ) ) ).

fof(addAssignment_2225,axiom,
    ! [VarCurr] :
      ( ( v8824(VarCurr,bitIndex69)
      <=> v3057(VarCurr,bitIndex349) )
      & ( v8824(VarCurr,bitIndex68)
      <=> v3057(VarCurr,bitIndex348) )
      & ( v8824(VarCurr,bitIndex67)
      <=> v3057(VarCurr,bitIndex347) )
      & ( v8824(VarCurr,bitIndex66)
      <=> v3057(VarCurr,bitIndex346) )
      & ( v8824(VarCurr,bitIndex65)
      <=> v3057(VarCurr,bitIndex345) )
      & ( v8824(VarCurr,bitIndex64)
      <=> v3057(VarCurr,bitIndex344) )
      & ( v8824(VarCurr,bitIndex63)
      <=> v3057(VarCurr,bitIndex343) ) ) ).

fof(addAssignment_2224,axiom,
    ! [VarNext] :
      ( ( v3057(VarNext,bitIndex279)
      <=> v9631(VarNext,bitIndex69) )
      & ( v3057(VarNext,bitIndex278)
      <=> v9631(VarNext,bitIndex68) )
      & ( v3057(VarNext,bitIndex277)
      <=> v9631(VarNext,bitIndex67) )
      & ( v3057(VarNext,bitIndex276)
      <=> v9631(VarNext,bitIndex66) )
      & ( v3057(VarNext,bitIndex275)
      <=> v9631(VarNext,bitIndex65) )
      & ( v3057(VarNext,bitIndex274)
      <=> v9631(VarNext,bitIndex64) )
      & ( v3057(VarNext,bitIndex273)
      <=> v9631(VarNext,bitIndex63) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_24,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9632(VarNext)
       => ( ( v9631(VarNext,bitIndex69)
          <=> v3057(VarCurr,bitIndex279) )
          & ( v9631(VarNext,bitIndex68)
          <=> v3057(VarCurr,bitIndex278) )
          & ( v9631(VarNext,bitIndex67)
          <=> v3057(VarCurr,bitIndex277) )
          & ( v9631(VarNext,bitIndex66)
          <=> v3057(VarCurr,bitIndex276) )
          & ( v9631(VarNext,bitIndex65)
          <=> v3057(VarCurr,bitIndex275) )
          & ( v9631(VarNext,bitIndex64)
          <=> v3057(VarCurr,bitIndex274) )
          & ( v9631(VarNext,bitIndex63)
          <=> v3057(VarCurr,bitIndex273) )
          & ( v9631(VarNext,bitIndex62)
          <=> v3057(VarCurr,bitIndex272) )
          & ( v9631(VarNext,bitIndex61)
          <=> v3057(VarCurr,bitIndex271) )
          & ( v9631(VarNext,bitIndex60)
          <=> v3057(VarCurr,bitIndex270) )
          & ( v9631(VarNext,bitIndex59)
          <=> v3057(VarCurr,bitIndex269) )
          & ( v9631(VarNext,bitIndex58)
          <=> v3057(VarCurr,bitIndex268) )
          & ( v9631(VarNext,bitIndex57)
          <=> v3057(VarCurr,bitIndex267) )
          & ( v9631(VarNext,bitIndex56)
          <=> v3057(VarCurr,bitIndex266) )
          & ( v9631(VarNext,bitIndex55)
          <=> v3057(VarCurr,bitIndex265) )
          & ( v9631(VarNext,bitIndex54)
          <=> v3057(VarCurr,bitIndex264) )
          & ( v9631(VarNext,bitIndex53)
          <=> v3057(VarCurr,bitIndex263) )
          & ( v9631(VarNext,bitIndex52)
          <=> v3057(VarCurr,bitIndex262) )
          & ( v9631(VarNext,bitIndex51)
          <=> v3057(VarCurr,bitIndex261) )
          & ( v9631(VarNext,bitIndex50)
          <=> v3057(VarCurr,bitIndex260) )
          & ( v9631(VarNext,bitIndex49)
          <=> v3057(VarCurr,bitIndex259) )
          & ( v9631(VarNext,bitIndex48)
          <=> v3057(VarCurr,bitIndex258) )
          & ( v9631(VarNext,bitIndex47)
          <=> v3057(VarCurr,bitIndex257) )
          & ( v9631(VarNext,bitIndex46)
          <=> v3057(VarCurr,bitIndex256) )
          & ( v9631(VarNext,bitIndex45)
          <=> v3057(VarCurr,bitIndex255) )
          & ( v9631(VarNext,bitIndex44)
          <=> v3057(VarCurr,bitIndex254) )
          & ( v9631(VarNext,bitIndex43)
          <=> v3057(VarCurr,bitIndex253) )
          & ( v9631(VarNext,bitIndex42)
          <=> v3057(VarCurr,bitIndex252) )
          & ( v9631(VarNext,bitIndex41)
          <=> v3057(VarCurr,bitIndex251) )
          & ( v9631(VarNext,bitIndex40)
          <=> v3057(VarCurr,bitIndex250) )
          & ( v9631(VarNext,bitIndex39)
          <=> v3057(VarCurr,bitIndex249) )
          & ( v9631(VarNext,bitIndex38)
          <=> v3057(VarCurr,bitIndex248) )
          & ( v9631(VarNext,bitIndex37)
          <=> v3057(VarCurr,bitIndex247) )
          & ( v9631(VarNext,bitIndex36)
          <=> v3057(VarCurr,bitIndex246) )
          & ( v9631(VarNext,bitIndex35)
          <=> v3057(VarCurr,bitIndex245) )
          & ( v9631(VarNext,bitIndex34)
          <=> v3057(VarCurr,bitIndex244) )
          & ( v9631(VarNext,bitIndex33)
          <=> v3057(VarCurr,bitIndex243) )
          & ( v9631(VarNext,bitIndex32)
          <=> v3057(VarCurr,bitIndex242) )
          & ( v9631(VarNext,bitIndex31)
          <=> v3057(VarCurr,bitIndex241) )
          & ( v9631(VarNext,bitIndex30)
          <=> v3057(VarCurr,bitIndex240) )
          & ( v9631(VarNext,bitIndex29)
          <=> v3057(VarCurr,bitIndex239) )
          & ( v9631(VarNext,bitIndex28)
          <=> v3057(VarCurr,bitIndex238) )
          & ( v9631(VarNext,bitIndex27)
          <=> v3057(VarCurr,bitIndex237) )
          & ( v9631(VarNext,bitIndex26)
          <=> v3057(VarCurr,bitIndex236) )
          & ( v9631(VarNext,bitIndex25)
          <=> v3057(VarCurr,bitIndex235) )
          & ( v9631(VarNext,bitIndex24)
          <=> v3057(VarCurr,bitIndex234) )
          & ( v9631(VarNext,bitIndex23)
          <=> v3057(VarCurr,bitIndex233) )
          & ( v9631(VarNext,bitIndex22)
          <=> v3057(VarCurr,bitIndex232) )
          & ( v9631(VarNext,bitIndex21)
          <=> v3057(VarCurr,bitIndex231) )
          & ( v9631(VarNext,bitIndex20)
          <=> v3057(VarCurr,bitIndex230) )
          & ( v9631(VarNext,bitIndex19)
          <=> v3057(VarCurr,bitIndex229) )
          & ( v9631(VarNext,bitIndex18)
          <=> v3057(VarCurr,bitIndex228) )
          & ( v9631(VarNext,bitIndex17)
          <=> v3057(VarCurr,bitIndex227) )
          & ( v9631(VarNext,bitIndex16)
          <=> v3057(VarCurr,bitIndex226) )
          & ( v9631(VarNext,bitIndex15)
          <=> v3057(VarCurr,bitIndex225) )
          & ( v9631(VarNext,bitIndex14)
          <=> v3057(VarCurr,bitIndex224) )
          & ( v9631(VarNext,bitIndex13)
          <=> v3057(VarCurr,bitIndex223) )
          & ( v9631(VarNext,bitIndex12)
          <=> v3057(VarCurr,bitIndex222) )
          & ( v9631(VarNext,bitIndex11)
          <=> v3057(VarCurr,bitIndex221) )
          & ( v9631(VarNext,bitIndex10)
          <=> v3057(VarCurr,bitIndex220) )
          & ( v9631(VarNext,bitIndex9)
          <=> v3057(VarCurr,bitIndex219) )
          & ( v9631(VarNext,bitIndex8)
          <=> v3057(VarCurr,bitIndex218) )
          & ( v9631(VarNext,bitIndex7)
          <=> v3057(VarCurr,bitIndex217) )
          & ( v9631(VarNext,bitIndex6)
          <=> v3057(VarCurr,bitIndex216) )
          & ( v9631(VarNext,bitIndex5)
          <=> v3057(VarCurr,bitIndex215) )
          & ( v9631(VarNext,bitIndex4)
          <=> v3057(VarCurr,bitIndex214) )
          & ( v9631(VarNext,bitIndex3)
          <=> v3057(VarCurr,bitIndex213) )
          & ( v9631(VarNext,bitIndex2)
          <=> v3057(VarCurr,bitIndex212) )
          & ( v9631(VarNext,bitIndex1)
          <=> v3057(VarCurr,bitIndex211) )
          & ( v9631(VarNext,bitIndex0)
          <=> v3057(VarCurr,bitIndex210) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_177,axiom,
    ! [VarNext] :
      ( v9632(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v9631(VarNext,B)
          <=> v9658(VarNext,B) ) ) ) ).

fof(addAssignment_2223,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v9658(VarNext,B)
          <=> v9656(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_261,axiom,
    ! [VarCurr] :
      ( ~ v8855(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v9656(VarCurr,B)
          <=> v9659(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_249,axiom,
    ! [VarCurr] :
      ( v8855(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v9656(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_99,axiom,
    ! [VarCurr] :
      ( ( ~ v9645(VarCurr)
        & ~ v9647(VarCurr) )
     => ! [B] :
          ( range_69_0(B)
         => ( v9659(VarCurr,B)
          <=> v9624(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_260,axiom,
    ! [VarCurr] :
      ( v9647(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v9659(VarCurr,B)
          <=> v9583(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_14,axiom,
    ! [VarCurr] :
      ( v9645(VarCurr)
     => ( ( v9659(VarCurr,bitIndex69)
        <=> v3057(VarCurr,bitIndex209) )
        & ( v9659(VarCurr,bitIndex68)
        <=> v3057(VarCurr,bitIndex208) )
        & ( v9659(VarCurr,bitIndex67)
        <=> v3057(VarCurr,bitIndex207) )
        & ( v9659(VarCurr,bitIndex66)
        <=> v3057(VarCurr,bitIndex206) )
        & ( v9659(VarCurr,bitIndex65)
        <=> v3057(VarCurr,bitIndex205) )
        & ( v9659(VarCurr,bitIndex64)
        <=> v3057(VarCurr,bitIndex204) )
        & ( v9659(VarCurr,bitIndex63)
        <=> v3057(VarCurr,bitIndex203) )
        & ( v9659(VarCurr,bitIndex62)
        <=> v3057(VarCurr,bitIndex202) )
        & ( v9659(VarCurr,bitIndex61)
        <=> v3057(VarCurr,bitIndex201) )
        & ( v9659(VarCurr,bitIndex60)
        <=> v3057(VarCurr,bitIndex200) )
        & ( v9659(VarCurr,bitIndex59)
        <=> v3057(VarCurr,bitIndex199) )
        & ( v9659(VarCurr,bitIndex58)
        <=> v3057(VarCurr,bitIndex198) )
        & ( v9659(VarCurr,bitIndex57)
        <=> v3057(VarCurr,bitIndex197) )
        & ( v9659(VarCurr,bitIndex56)
        <=> v3057(VarCurr,bitIndex196) )
        & ( v9659(VarCurr,bitIndex55)
        <=> v3057(VarCurr,bitIndex195) )
        & ( v9659(VarCurr,bitIndex54)
        <=> v3057(VarCurr,bitIndex194) )
        & ( v9659(VarCurr,bitIndex53)
        <=> v3057(VarCurr,bitIndex193) )
        & ( v9659(VarCurr,bitIndex52)
        <=> v3057(VarCurr,bitIndex192) )
        & ( v9659(VarCurr,bitIndex51)
        <=> v3057(VarCurr,bitIndex191) )
        & ( v9659(VarCurr,bitIndex50)
        <=> v3057(VarCurr,bitIndex190) )
        & ( v9659(VarCurr,bitIndex49)
        <=> v3057(VarCurr,bitIndex189) )
        & ( v9659(VarCurr,bitIndex48)
        <=> v3057(VarCurr,bitIndex188) )
        & ( v9659(VarCurr,bitIndex47)
        <=> v3057(VarCurr,bitIndex187) )
        & ( v9659(VarCurr,bitIndex46)
        <=> v3057(VarCurr,bitIndex186) )
        & ( v9659(VarCurr,bitIndex45)
        <=> v3057(VarCurr,bitIndex185) )
        & ( v9659(VarCurr,bitIndex44)
        <=> v3057(VarCurr,bitIndex184) )
        & ( v9659(VarCurr,bitIndex43)
        <=> v3057(VarCurr,bitIndex183) )
        & ( v9659(VarCurr,bitIndex42)
        <=> v3057(VarCurr,bitIndex182) )
        & ( v9659(VarCurr,bitIndex41)
        <=> v3057(VarCurr,bitIndex181) )
        & ( v9659(VarCurr,bitIndex40)
        <=> v3057(VarCurr,bitIndex180) )
        & ( v9659(VarCurr,bitIndex39)
        <=> v3057(VarCurr,bitIndex179) )
        & ( v9659(VarCurr,bitIndex38)
        <=> v3057(VarCurr,bitIndex178) )
        & ( v9659(VarCurr,bitIndex37)
        <=> v3057(VarCurr,bitIndex177) )
        & ( v9659(VarCurr,bitIndex36)
        <=> v3057(VarCurr,bitIndex176) )
        & ( v9659(VarCurr,bitIndex35)
        <=> v3057(VarCurr,bitIndex175) )
        & ( v9659(VarCurr,bitIndex34)
        <=> v3057(VarCurr,bitIndex174) )
        & ( v9659(VarCurr,bitIndex33)
        <=> v3057(VarCurr,bitIndex173) )
        & ( v9659(VarCurr,bitIndex32)
        <=> v3057(VarCurr,bitIndex172) )
        & ( v9659(VarCurr,bitIndex31)
        <=> v3057(VarCurr,bitIndex171) )
        & ( v9659(VarCurr,bitIndex30)
        <=> v3057(VarCurr,bitIndex170) )
        & ( v9659(VarCurr,bitIndex29)
        <=> v3057(VarCurr,bitIndex169) )
        & ( v9659(VarCurr,bitIndex28)
        <=> v3057(VarCurr,bitIndex168) )
        & ( v9659(VarCurr,bitIndex27)
        <=> v3057(VarCurr,bitIndex167) )
        & ( v9659(VarCurr,bitIndex26)
        <=> v3057(VarCurr,bitIndex166) )
        & ( v9659(VarCurr,bitIndex25)
        <=> v3057(VarCurr,bitIndex165) )
        & ( v9659(VarCurr,bitIndex24)
        <=> v3057(VarCurr,bitIndex164) )
        & ( v9659(VarCurr,bitIndex23)
        <=> v3057(VarCurr,bitIndex163) )
        & ( v9659(VarCurr,bitIndex22)
        <=> v3057(VarCurr,bitIndex162) )
        & ( v9659(VarCurr,bitIndex21)
        <=> v3057(VarCurr,bitIndex161) )
        & ( v9659(VarCurr,bitIndex20)
        <=> v3057(VarCurr,bitIndex160) )
        & ( v9659(VarCurr,bitIndex19)
        <=> v3057(VarCurr,bitIndex159) )
        & ( v9659(VarCurr,bitIndex18)
        <=> v3057(VarCurr,bitIndex158) )
        & ( v9659(VarCurr,bitIndex17)
        <=> v3057(VarCurr,bitIndex157) )
        & ( v9659(VarCurr,bitIndex16)
        <=> v3057(VarCurr,bitIndex156) )
        & ( v9659(VarCurr,bitIndex15)
        <=> v3057(VarCurr,bitIndex155) )
        & ( v9659(VarCurr,bitIndex14)
        <=> v3057(VarCurr,bitIndex154) )
        & ( v9659(VarCurr,bitIndex13)
        <=> v3057(VarCurr,bitIndex153) )
        & ( v9659(VarCurr,bitIndex12)
        <=> v3057(VarCurr,bitIndex152) )
        & ( v9659(VarCurr,bitIndex11)
        <=> v3057(VarCurr,bitIndex151) )
        & ( v9659(VarCurr,bitIndex10)
        <=> v3057(VarCurr,bitIndex150) )
        & ( v9659(VarCurr,bitIndex9)
        <=> v3057(VarCurr,bitIndex149) )
        & ( v9659(VarCurr,bitIndex8)
        <=> v3057(VarCurr,bitIndex148) )
        & ( v9659(VarCurr,bitIndex7)
        <=> v3057(VarCurr,bitIndex147) )
        & ( v9659(VarCurr,bitIndex6)
        <=> v3057(VarCurr,bitIndex146) )
        & ( v9659(VarCurr,bitIndex5)
        <=> v3057(VarCurr,bitIndex145) )
        & ( v9659(VarCurr,bitIndex4)
        <=> v3057(VarCurr,bitIndex144) )
        & ( v9659(VarCurr,bitIndex3)
        <=> v3057(VarCurr,bitIndex143) )
        & ( v9659(VarCurr,bitIndex2)
        <=> v3057(VarCurr,bitIndex142) )
        & ( v9659(VarCurr,bitIndex1)
        <=> v3057(VarCurr,bitIndex141) )
        & ( v9659(VarCurr,bitIndex0)
        <=> v3057(VarCurr,bitIndex140) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1832,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9632(VarNext)
      <=> ( v9633(VarNext)
          & v9640(VarNext) ) ) ) ).

fof(addAssignment_2222,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9640(VarNext)
      <=> v9638(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1831,axiom,
    ! [VarCurr] :
      ( v9638(VarCurr)
    <=> ( v9641(VarCurr)
        & v9652(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1830,axiom,
    ! [VarCurr] :
      ( v9652(VarCurr)
    <=> ( v9653(VarCurr)
        | v8855(VarCurr) ) ) ).

fof(writeUnaryOperator_836,axiom,
    ! [VarCurr] :
      ( ~ v9653(VarCurr)
    <=> v9654(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_714,axiom,
    ! [VarCurr] :
      ( v9654(VarCurr)
    <=> ( ( v9655(VarCurr,bitIndex1)
        <=> $false )
        & ( v9655(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2221,axiom,
    ! [VarCurr] :
      ( v9655(VarCurr,bitIndex0)
    <=> v3009(VarCurr) ) ).

fof(addAssignment_2220,axiom,
    ! [VarCurr] :
      ( v9655(VarCurr,bitIndex1)
    <=> v46(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1829,axiom,
    ! [VarCurr] :
      ( v9641(VarCurr)
    <=> ( v8855(VarCurr)
        | v9642(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1828,axiom,
    ! [VarCurr] :
      ( v9642(VarCurr)
    <=> ( v9643(VarCurr)
        & v9651(VarCurr) ) ) ).

fof(writeUnaryOperator_835,axiom,
    ! [VarCurr] :
      ( ~ v9651(VarCurr)
    <=> v8855(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1827,axiom,
    ! [VarCurr] :
      ( v9643(VarCurr)
    <=> ( v9644(VarCurr)
        | v9649(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_713,axiom,
    ! [VarCurr] :
      ( v9649(VarCurr)
    <=> ( ( v9650(VarCurr,bitIndex1)
        <=> $true )
        & ( v9650(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2219,axiom,
    ! [VarCurr] :
      ( v9650(VarCurr,bitIndex0)
    <=> v3009(VarCurr) ) ).

fof(addAssignment_2218,axiom,
    ! [VarCurr] :
      ( v9650(VarCurr,bitIndex1)
    <=> v46(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1826,axiom,
    ! [VarCurr] :
      ( v9644(VarCurr)
    <=> ( v9645(VarCurr)
        | v9647(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_712,axiom,
    ! [VarCurr] :
      ( v9647(VarCurr)
    <=> ( ( v9648(VarCurr,bitIndex1)
        <=> $true )
        & ( v9648(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2217,axiom,
    ! [VarCurr] :
      ( v9648(VarCurr,bitIndex0)
    <=> v3009(VarCurr) ) ).

fof(addAssignment_2216,axiom,
    ! [VarCurr] :
      ( v9648(VarCurr,bitIndex1)
    <=> v46(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_711,axiom,
    ! [VarCurr] :
      ( v9645(VarCurr)
    <=> ( ( v9646(VarCurr,bitIndex1)
        <=> $false )
        & ( v9646(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2215,axiom,
    ! [VarCurr] :
      ( v9646(VarCurr,bitIndex0)
    <=> v3009(VarCurr) ) ).

fof(addAssignment_2214,axiom,
    ! [VarCurr] :
      ( v9646(VarCurr,bitIndex1)
    <=> v46(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1825,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9633(VarNext)
      <=> ( v9635(VarNext)
          & v3071(VarNext) ) ) ) ).

fof(writeUnaryOperator_834,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9635(VarNext)
      <=> v3086(VarNext) ) ) ).

fof(addAssignment_2213,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v9624(VarCurr,B)
      <=> v9629(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_252,axiom,
    ! [VarCurr] :
      ( ~ v9626(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v9629(VarCurr,B)
          <=> v9628(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_256,axiom,
    ! [VarCurr] :
      ( v9626(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v9629(VarCurr,B)
          <=> v3154(VarCurr,B) ) ) ) ).

fof(addAssignment_2212,axiom,
    ! [VarCurr] :
      ( ( v9628(VarCurr,bitIndex69)
      <=> v3057(VarCurr,bitIndex209) )
      & ( v9628(VarCurr,bitIndex68)
      <=> v3057(VarCurr,bitIndex208) )
      & ( v9628(VarCurr,bitIndex67)
      <=> v3057(VarCurr,bitIndex207) )
      & ( v9628(VarCurr,bitIndex66)
      <=> v3057(VarCurr,bitIndex206) )
      & ( v9628(VarCurr,bitIndex65)
      <=> v3057(VarCurr,bitIndex205) )
      & ( v9628(VarCurr,bitIndex64)
      <=> v3057(VarCurr,bitIndex204) )
      & ( v9628(VarCurr,bitIndex63)
      <=> v3057(VarCurr,bitIndex203) ) ) ).

fof(addAssignment_2211,axiom,
    ! [VarCurr] :
      ( v9626(VarCurr)
    <=> v3064(VarCurr,bitIndex5) ) ).

fof(addAssignment_2210,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v9583(VarCurr,B)
      <=> v9622(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_251,axiom,
    ! [VarCurr] :
      ( ~ v9585(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v9622(VarCurr,B)
          <=> v9621(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_255,axiom,
    ! [VarCurr] :
      ( v9585(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v9622(VarCurr,B)
          <=> v3154(VarCurr,B) ) ) ) ).

fof(addAssignment_2209,axiom,
    ! [VarCurr] :
      ( ( v9621(VarCurr,bitIndex69)
      <=> v3057(VarCurr,bitIndex279) )
      & ( v9621(VarCurr,bitIndex68)
      <=> v3057(VarCurr,bitIndex278) )
      & ( v9621(VarCurr,bitIndex67)
      <=> v3057(VarCurr,bitIndex277) )
      & ( v9621(VarCurr,bitIndex66)
      <=> v3057(VarCurr,bitIndex276) )
      & ( v9621(VarCurr,bitIndex65)
      <=> v3057(VarCurr,bitIndex275) )
      & ( v9621(VarCurr,bitIndex64)
      <=> v3057(VarCurr,bitIndex274) )
      & ( v9621(VarCurr,bitIndex63)
      <=> v3057(VarCurr,bitIndex273) ) ) ).

fof(addAssignment_2208,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v3154(VarCurr,B)
      <=> v3156(VarCurr,B) ) ) ).

fof(addAssignment_2207,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v3156(VarCurr,B)
      <=> v3158(VarCurr,B) ) ) ).

fof(addAssignment_2206,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v3158(VarCurr,B)
      <=> v3160(VarCurr,B) ) ) ).

fof(addAssignment_2205,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v3160(VarCurr,B)
      <=> v3162(VarCurr,B) ) ) ).

fof(addAssignment_2204,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v3162(VarCurr,B)
      <=> v3164(VarCurr,B) ) ) ).

fof(addAssignment_2203,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v3164(VarCurr,B)
      <=> v3166(VarCurr,B) ) ) ).

fof(addAssignment_2202,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v3166(VarCurr,B)
      <=> v8812(VarCurr,B) ) ) ).

fof(range_axiom_54,axiom,
    ! [B] :
      ( range_69_63(B)
    <=> ( $false
        | bitIndex63 = B
        | bitIndex64 = B
        | bitIndex65 = B
        | bitIndex66 = B
        | bitIndex67 = B
        | bitIndex68 = B
        | bitIndex69 = B ) ) ).

fof(addCaseBooleanConditionEqualRanges1_161,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9588(VarNext)
       => ! [B] :
            ( range_6_0(B)
           => ( v8813(VarNext,B)
            <=> v8813(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_176,axiom,
    ! [VarNext] :
      ( v9588(VarNext)
     => ! [B] :
          ( range_6_0(B)
         => ( v8813(VarNext,B)
          <=> v9615(VarNext,B) ) ) ) ).

fof(addAssignment_2201,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_6_0(B)
         => ( v9615(VarNext,B)
          <=> v9613(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_259,axiom,
    ! [VarCurr] :
      ( ~ v8777(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v9613(VarCurr,B)
          <=> v9616(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_248,axiom,
    ! [VarCurr] :
      ( v8777(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v9613(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_258,axiom,
    ! [VarCurr] :
      ( ~ v8780(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v9616(VarCurr,B)
          <=> v6574(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_247,axiom,
    ! [VarCurr] :
      ( v8780(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v9616(VarCurr,B)
          <=> v9617(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges1_2,axiom,
    ! [VarCurr] :
      ( ~ v8791(VarCurr)
     => ( ( v9617(VarCurr,bitIndex6)
        <=> v6551(VarCurr,bitIndex53) )
        & ( v9617(VarCurr,bitIndex5)
        <=> v6551(VarCurr,bitIndex52) )
        & ( v9617(VarCurr,bitIndex4)
        <=> v6551(VarCurr,bitIndex51) )
        & ( v9617(VarCurr,bitIndex3)
        <=> v6551(VarCurr,bitIndex50) )
        & ( v9617(VarCurr,bitIndex2)
        <=> v6551(VarCurr,bitIndex49) )
        & ( v9617(VarCurr,bitIndex1)
        <=> v6551(VarCurr,bitIndex48) )
        & ( v9617(VarCurr,bitIndex0)
        <=> v6551(VarCurr,bitIndex47) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_246,axiom,
    ! [VarCurr] :
      ( v8791(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v9617(VarCurr,B)
          <=> v6574(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1824,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9588(VarNext)
      <=> ( v9589(VarNext)
          & v9596(VarNext) ) ) ) ).

fof(addAssignment_2200,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9596(VarNext)
      <=> v9594(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1823,axiom,
    ! [VarCurr] :
      ( v9594(VarCurr)
    <=> ( v9597(VarCurr)
        & v9601(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1822,axiom,
    ! [VarCurr] :
      ( v9601(VarCurr)
    <=> ( v9602(VarCurr)
        | v8777(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1821,axiom,
    ! [VarCurr] :
      ( v9602(VarCurr)
    <=> ( v9603(VarCurr)
        & v9611(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1820,axiom,
    ! [VarCurr] :
      ( v9611(VarCurr)
    <=> ( v9612(VarCurr)
        | v8781(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1819,axiom,
    ! [VarCurr] :
      ( v9612(VarCurr)
    <=> ( v8788(VarCurr)
        | v8780(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1818,axiom,
    ! [VarCurr] :
      ( v9603(VarCurr)
    <=> ( v9604(VarCurr)
        & v9609(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1817,axiom,
    ! [VarCurr] :
      ( v9609(VarCurr)
    <=> ( v65(VarCurr)
        | v9610(VarCurr) ) ) ).

fof(writeUnaryOperator_833,axiom,
    ! [VarCurr] :
      ( ~ v9610(VarCurr)
    <=> v8781(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1816,axiom,
    ! [VarCurr] :
      ( v9604(VarCurr)
    <=> ( v9605(VarCurr)
        & v9606(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1815,axiom,
    ! [VarCurr] :
      ( v9606(VarCurr)
    <=> ( v9607(VarCurr)
        | v9608(VarCurr) ) ) ).

fof(writeUnaryOperator_832,axiom,
    ! [VarCurr] :
      ( ~ v9608(VarCurr)
    <=> v8780(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1814,axiom,
    ! [VarCurr] :
      ( v9607(VarCurr)
    <=> ( v8791(VarCurr)
        | v8793(VarCurr) ) ) ).

fof(writeUnaryOperator_831,axiom,
    ! [VarCurr] :
      ( ~ v9605(VarCurr)
    <=> v8788(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1813,axiom,
    ! [VarCurr] :
      ( v9597(VarCurr)
    <=> ( v8777(VarCurr)
        | v9598(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1812,axiom,
    ! [VarCurr] :
      ( v9598(VarCurr)
    <=> ( v9599(VarCurr)
        & v9600(VarCurr) ) ) ).

fof(writeUnaryOperator_830,axiom,
    ! [VarCurr] :
      ( ~ v9600(VarCurr)
    <=> v8777(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1811,axiom,
    ! [VarCurr] :
      ( v9599(VarCurr)
    <=> ( v8780(VarCurr)
        | v8781(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1810,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9589(VarNext)
      <=> ( v9591(VarNext)
          & v179(VarNext) ) ) ) ).

fof(writeUnaryOperator_829,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9591(VarNext)
      <=> v4675(VarNext) ) ) ).

fof(addAssignment_2199,axiom,
    ! [VarCurr,B] :
      ( range_53_47(B)
     => ( v6551(VarCurr,B)
      <=> v6553(VarCurr,B) ) ) ).

fof(addAssignment_2198,axiom,
    ! [VarCurr,B] :
      ( range_53_47(B)
     => ( v6553(VarCurr,B)
      <=> v6555(VarCurr,B) ) ) ).

fof(addAssignment_2197,axiom,
    ! [VarCurr,B] :
      ( range_53_47(B)
     => ( v6555(VarCurr,B)
      <=> v6557(VarCurr,B) ) ) ).

fof(addAssignment_2196,axiom,
    ! [VarCurr,B] :
      ( range_53_47(B)
     => ( v6557(VarCurr,B)
      <=> v7080(VarCurr,B) ) ) ).

fof(range_axiom_53,axiom,
    ! [B] :
      ( range_53_47(B)
    <=> ( $false
        | bitIndex47 = B
        | bitIndex48 = B
        | bitIndex49 = B
        | bitIndex50 = B
        | bitIndex51 = B
        | bitIndex52 = B
        | bitIndex53 = B ) ) ).

fof(addAssignment_2195,axiom,
    ! [VarCurr] :
      ( v9585(VarCurr)
    <=> v3064(VarCurr,bitIndex5) ) ).

fof(addAssignment_2194,axiom,
    ! [VarCurr] :
      ( v40(VarCurr)
    <=> v42(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_160,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9558(VarNext)
       => ( v42(VarNext)
        <=> v42(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_175,axiom,
    ! [VarNext] :
      ( v9558(VarNext)
     => ( v42(VarNext)
      <=> v9576(VarNext) ) ) ).

fof(addAssignment_2193,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9576(VarNext)
      <=> v9574(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_250,axiom,
    ! [VarCurr] :
      ( ~ v9573(VarCurr)
     => ( v9574(VarCurr)
      <=> v9577(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_254,axiom,
    ! [VarCurr] :
      ( v9573(VarCurr)
     => ( v9574(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_249,axiom,
    ! [VarCurr] :
      ( ~ v46(VarCurr)
     => ( v9577(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_253,axiom,
    ! [VarCurr] :
      ( v46(VarCurr)
     => ( v9577(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1809,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9558(VarNext)
      <=> ( v9559(VarNext)
          & v9566(VarNext) ) ) ) ).

fof(addAssignment_2192,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9566(VarNext)
      <=> v9564(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1808,axiom,
    ! [VarCurr] :
      ( v9564(VarCurr)
    <=> ( v9567(VarCurr)
        | v9573(VarCurr) ) ) ).

fof(writeUnaryOperator_828,axiom,
    ! [VarCurr] :
      ( ~ v9573(VarCurr)
    <=> v44(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1807,axiom,
    ! [VarCurr] :
      ( v9567(VarCurr)
    <=> ( v9568(VarCurr)
        | v46(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1806,axiom,
    ! [VarCurr] :
      ( v9568(VarCurr)
    <=> ( v9569(VarCurr)
        & v9572(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_710,axiom,
    ! [VarCurr] :
      ( v9572(VarCurr)
    <=> ( v3066(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1805,axiom,
    ! [VarCurr] :
      ( v9569(VarCurr)
    <=> ( v9570(VarCurr)
        & v9571(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_709,axiom,
    ! [VarCurr] :
      ( v9571(VarCurr)
    <=> ( v3004(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_708,axiom,
    ! [VarCurr] :
      ( v9570(VarCurr)
    <=> ( v3009(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1804,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9559(VarNext)
      <=> ( v9560(VarNext)
          & v3071(VarNext) ) ) ) ).

fof(writeUnaryOperator_827,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9560(VarNext)
      <=> v3086(VarNext) ) ) ).

fof(addAssignment_2191,axiom,
    ! [VarCurr] :
      ( v3066(VarCurr,bitIndex0)
    <=> v3096(VarCurr,bitIndex0) ) ).

fof(addAssignment_2190,axiom,
    ! [VarCurr] :
      ( v46(VarCurr)
    <=> v48(VarCurr) ) ).

fof(addAssignment_2189,axiom,
    ! [VarCurr] :
      ( v48(VarCurr)
    <=> v50(VarCurr) ) ).

fof(addAssignment_2188,axiom,
    ! [VarCurr] :
      ( v50(VarCurr)
    <=> v52(VarCurr) ) ).

fof(addAssignment_2187,axiom,
    ! [VarCurr] :
      ( v52(VarCurr)
    <=> v54(VarCurr) ) ).

fof(addAssignment_2186,axiom,
    ! [VarCurr] :
      ( v54(VarCurr)
    <=> v56(VarCurr) ) ).

fof(addAssignment_2185,axiom,
    ! [VarCurr] :
      ( v56(VarCurr)
    <=> v58(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_159,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9545(VarNext)
       => ( v58(VarNext)
        <=> v58(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_174,axiom,
    ! [VarNext] :
      ( v9545(VarNext)
     => ( v58(VarNext)
      <=> v9553(VarNext) ) ) ).

fof(addAssignment_2184,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9553(VarNext)
      <=> v9551(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_248,axiom,
    ! [VarCurr] :
      ( ~ v5393(VarCurr)
     => ( v9551(VarCurr)
      <=> v65(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_252,axiom,
    ! [VarCurr] :
      ( v5393(VarCurr)
     => ( v9551(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1803,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9545(VarNext)
      <=> v9546(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1802,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9546(VarNext)
      <=> ( v9548(VarNext)
          & v179(VarNext) ) ) ) ).

fof(writeUnaryOperator_826,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9548(VarNext)
      <=> v4675(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_47,axiom,
    ! [VarCurr] :
      ( ( ~ v8711(VarCurr)
        & ~ v8712(VarCurr)
        & ~ v8743(VarCurr) )
     => ( v65(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_98,axiom,
    ! [VarCurr] :
      ( v8743(VarCurr)
     => ( v65(VarCurr)
      <=> v9542(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_257,axiom,
    ! [VarCurr] :
      ( v8712(VarCurr)
     => ( v65(VarCurr)
      <=> v9536(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_245,axiom,
    ! [VarCurr] :
      ( v8711(VarCurr)
     => ( v65(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_256,axiom,
    ! [VarCurr] :
      ( ~ v9448(VarCurr)
     => ( v9542(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_244,axiom,
    ! [VarCurr] :
      ( v9448(VarCurr)
     => ( v9542(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_255,axiom,
    ! [VarCurr] :
      ( ~ v8714(VarCurr)
     => ( v9536(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_243,axiom,
    ! [VarCurr] :
      ( v8714(VarCurr)
     => ( v9536(VarCurr)
      <=> v9537(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_46,axiom,
    ! [VarCurr] :
      ( ( ~ v8716(VarCurr)
        & ~ v8718(VarCurr)
        & ~ v8732(VarCurr) )
     => ( v9537(VarCurr)
      <=> v9540(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_97,axiom,
    ! [VarCurr] :
      ( v8732(VarCurr)
     => ( v9537(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_254,axiom,
    ! [VarCurr] :
      ( v8718(VarCurr)
     => ( v9537(VarCurr)
      <=> v9538(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_242,axiom,
    ! [VarCurr] :
      ( v8716(VarCurr)
     => ( v9537(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_253,axiom,
    ! [VarCurr] :
      ( ~ v8737(VarCurr)
     => ( v9540(VarCurr)
      <=> v9541(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_241,axiom,
    ! [VarCurr] :
      ( v8737(VarCurr)
     => ( v9540(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_252,axiom,
    ! [VarCurr] :
      ( ~ v8740(VarCurr)
     => ( v9541(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_240,axiom,
    ! [VarCurr] :
      ( v8740(VarCurr)
     => ( v9541(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_251,axiom,
    ! [VarCurr] :
      ( ~ v9539(VarCurr)
     => ( v9538(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_239,axiom,
    ! [VarCurr] :
      ( v9539(VarCurr)
     => ( v9538(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1801,axiom,
    ! [VarCurr] :
      ( v9539(VarCurr)
    <=> ( v8722(VarCurr)
        | v8727(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_158,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9523(VarNext)
       => ! [B] :
            ( range_2_0(B)
           => ( v67(VarNext,B)
            <=> v67(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_173,axiom,
    ! [VarNext] :
      ( v9523(VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v67(VarNext,B)
          <=> v9531(VarNext,B) ) ) ) ).

fof(addAssignment_2183,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v9531(VarNext,B)
          <=> v9529(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_247,axiom,
    ! [VarCurr] :
      ( ~ v9532(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v9529(VarCurr,B)
          <=> v70(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_251,axiom,
    ! [VarCurr] :
      ( v9532(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v9529(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_707,axiom,
    ! [VarCurr] :
      ( v9532(VarCurr)
    <=> ( v60(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1800,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9523(VarNext)
      <=> v9524(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1799,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9524(VarNext)
      <=> ( v9525(VarNext)
          & v179(VarNext) ) ) ) ).

fof(writeUnaryOperator_825,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9525(VarNext)
      <=> v4675(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_45,axiom,
    ! [VarCurr] :
      ( ( ~ v9468(VarCurr)
        & ~ v9481(VarCurr)
        & ~ v9517(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v70(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_96,axiom,
    ! [VarCurr] :
      ( v9517(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v70(VarCurr,B)
          <=> v9518(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_250,axiom,
    ! [VarCurr] :
      ( v9481(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v70(VarCurr,B)
          <=> v9482(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_238,axiom,
    ! [VarCurr] :
      ( v9468(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v70(VarCurr,B)
          <=> v9469(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_249,axiom,
    ! [VarCurr] :
      ( ~ v9519(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v9518(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_237,axiom,
    ! [VarCurr] :
      ( v9519(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v9518(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_706,axiom,
    ! [VarCurr] :
      ( v9520(VarCurr)
    <=> ( v2990(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_705,axiom,
    ! [VarCurr] :
      ( v9519(VarCurr)
    <=> ( v2990(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_704,axiom,
    ! [VarCurr] :
      ( v9517(VarCurr)
    <=> ( ( v67(VarCurr,bitIndex2)
        <=> $false )
        & ( v67(VarCurr,bitIndex1)
        <=> $true )
        & ( v67(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_248,axiom,
    ! [VarCurr] :
      ( ~ v9483(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v9482(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_236,axiom,
    ! [VarCurr] :
      ( v9483(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v9482(VarCurr,B)
          <=> v9484(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_703,axiom,
    ! [VarCurr] :
      ( v9516(VarCurr)
    <=> ( v2990(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_44,axiom,
    ! [VarCurr] :
      ( ( ~ v9485(VarCurr)
        & ~ v9490(VarCurr)
        & ~ v9503(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v9484(VarCurr,B)
          <=> v9510(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_95,axiom,
    ! [VarCurr] :
      ( v9503(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v9484(VarCurr,B)
          <=> v9505(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_247,axiom,
    ! [VarCurr] :
      ( v9490(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v9484(VarCurr,B)
          <=> v9492(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_235,axiom,
    ! [VarCurr] :
      ( v9485(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v9484(VarCurr,B)
          <=> v9487(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_246,axiom,
    ! [VarCurr] :
      ( ~ v9511(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v9510(VarCurr,B)
          <=> v9513(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_234,axiom,
    ! [VarCurr] :
      ( v9511(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v9510(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_245,axiom,
    ! [VarCurr] :
      ( ~ v9514(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v9513(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_233,axiom,
    ! [VarCurr] :
      ( v9514(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v9513(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_702,axiom,
    ! [VarCurr] :
      ( v9515(VarCurr)
    <=> ( v8673(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_701,axiom,
    ! [VarCurr] :
      ( v9514(VarCurr)
    <=> ( v8673(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_700,axiom,
    ! [VarCurr] :
      ( v9512(VarCurr)
    <=> ( v5621(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_699,axiom,
    ! [VarCurr] :
      ( v9511(VarCurr)
    <=> ( v5621(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_698,axiom,
    ! [VarCurr] :
      ( v9508(VarCurr)
    <=> ( ( v9509(VarCurr,bitIndex1)
        <=> $true )
        & ( v9509(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2182,axiom,
    ! [VarCurr] :
      ( v9509(VarCurr,bitIndex0)
    <=> v8704(VarCurr) ) ).

fof(addAssignment_2181,axiom,
    ! [VarCurr] :
      ( v9509(VarCurr,bitIndex1)
    <=> v3173(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_244,axiom,
    ! [VarCurr] :
      ( ~ v9506(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v9505(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_232,axiom,
    ! [VarCurr] :
      ( v9506(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v9505(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_697,axiom,
    ! [VarCurr] :
      ( v9507(VarCurr)
    <=> ( v8673(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_696,axiom,
    ! [VarCurr] :
      ( v9506(VarCurr)
    <=> ( v8673(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_695,axiom,
    ! [VarCurr] :
      ( v9503(VarCurr)
    <=> ( ( v9504(VarCurr,bitIndex1)
        <=> $true )
        & ( v9504(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2180,axiom,
    ! [VarCurr] :
      ( v9504(VarCurr,bitIndex0)
    <=> v8704(VarCurr) ) ).

fof(addAssignment_2179,axiom,
    ! [VarCurr] :
      ( v9504(VarCurr,bitIndex1)
    <=> v3173(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_94,axiom,
    ! [VarCurr] :
      ( ( ~ v9493(VarCurr)
        & ~ v9498(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v9492(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_243,axiom,
    ! [VarCurr] :
      ( v9498(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v9492(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_231,axiom,
    ! [VarCurr] :
      ( v9493(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v9492(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1798,axiom,
    ! [VarCurr] :
      ( v9498(VarCurr)
    <=> ( v9499(VarCurr)
        | v9501(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_694,axiom,
    ! [VarCurr] :
      ( v9501(VarCurr)
    <=> ( ( v9502(VarCurr,bitIndex3)
        <=> $false )
        & ( v9502(VarCurr,bitIndex2)
        <=> $true )
        & ( v9502(VarCurr,bitIndex1)
        <=> $false )
        & ( v9502(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2178,axiom,
    ! [VarCurr] :
      ( v9502(VarCurr,bitIndex0)
    <=> v6630(VarCurr) ) ).

fof(addAssignment_2177,axiom,
    ! [VarCurr] :
      ( ( v9502(VarCurr,bitIndex3)
      <=> v4668(VarCurr,bitIndex2) )
      & ( v9502(VarCurr,bitIndex2)
      <=> v4668(VarCurr,bitIndex1) )
      & ( v9502(VarCurr,bitIndex1)
      <=> v4668(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_693,axiom,
    ! [VarCurr] :
      ( v9499(VarCurr)
    <=> ( ( v9500(VarCurr,bitIndex3)
        <=> $false )
        & ( v9500(VarCurr,bitIndex2)
        <=> $false )
        & ( v9500(VarCurr,bitIndex1)
        <=> $true )
        & ( v9500(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2176,axiom,
    ! [VarCurr] :
      ( v9500(VarCurr,bitIndex0)
    <=> v6630(VarCurr) ) ).

fof(addAssignment_2175,axiom,
    ! [VarCurr] :
      ( ( v9500(VarCurr,bitIndex3)
      <=> v4668(VarCurr,bitIndex2) )
      & ( v9500(VarCurr,bitIndex2)
      <=> v4668(VarCurr,bitIndex1) )
      & ( v9500(VarCurr,bitIndex1)
      <=> v4668(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1797,axiom,
    ! [VarCurr] :
      ( v9493(VarCurr)
    <=> ( v9494(VarCurr)
        | v9496(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_692,axiom,
    ! [VarCurr] :
      ( v9496(VarCurr)
    <=> ( ( v9497(VarCurr,bitIndex3)
        <=> $false )
        & ( v9497(VarCurr,bitIndex2)
        <=> $true )
        & ( v9497(VarCurr,bitIndex1)
        <=> $false )
        & ( v9497(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2174,axiom,
    ! [VarCurr] :
      ( v9497(VarCurr,bitIndex0)
    <=> v6630(VarCurr) ) ).

fof(addAssignment_2173,axiom,
    ! [VarCurr] :
      ( ( v9497(VarCurr,bitIndex3)
      <=> v4668(VarCurr,bitIndex2) )
      & ( v9497(VarCurr,bitIndex2)
      <=> v4668(VarCurr,bitIndex1) )
      & ( v9497(VarCurr,bitIndex1)
      <=> v4668(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_691,axiom,
    ! [VarCurr] :
      ( v9494(VarCurr)
    <=> ( ( v9495(VarCurr,bitIndex3)
        <=> $false )
        & ( v9495(VarCurr,bitIndex2)
        <=> $false )
        & ( v9495(VarCurr,bitIndex1)
        <=> $true )
        & ( v9495(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2172,axiom,
    ! [VarCurr] :
      ( v9495(VarCurr,bitIndex0)
    <=> v6630(VarCurr) ) ).

fof(addAssignment_2171,axiom,
    ! [VarCurr] :
      ( ( v9495(VarCurr,bitIndex3)
      <=> v4668(VarCurr,bitIndex2) )
      & ( v9495(VarCurr,bitIndex2)
      <=> v4668(VarCurr,bitIndex1) )
      & ( v9495(VarCurr,bitIndex1)
      <=> v4668(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_690,axiom,
    ! [VarCurr] :
      ( v9490(VarCurr)
    <=> ( ( v9491(VarCurr,bitIndex1)
        <=> $false )
        & ( v9491(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2170,axiom,
    ! [VarCurr] :
      ( v9491(VarCurr,bitIndex0)
    <=> v8704(VarCurr) ) ).

fof(addAssignment_2169,axiom,
    ! [VarCurr] :
      ( v9491(VarCurr,bitIndex1)
    <=> v3173(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_242,axiom,
    ! [VarCurr] :
      ( ~ v9488(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v9487(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_230,axiom,
    ! [VarCurr] :
      ( v9488(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v9487(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_689,axiom,
    ! [VarCurr] :
      ( v9489(VarCurr)
    <=> ( v8673(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_688,axiom,
    ! [VarCurr] :
      ( v9488(VarCurr)
    <=> ( v8673(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_687,axiom,
    ! [VarCurr] :
      ( v9485(VarCurr)
    <=> ( ( v9486(VarCurr,bitIndex1)
        <=> $false )
        & ( v9486(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2168,axiom,
    ! [VarCurr] :
      ( v9486(VarCurr,bitIndex0)
    <=> v8704(VarCurr) ) ).

fof(addAssignment_2167,axiom,
    ! [VarCurr] :
      ( v9486(VarCurr,bitIndex1)
    <=> v3173(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_686,axiom,
    ! [VarCurr] :
      ( v9483(VarCurr)
    <=> ( v2990(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_685,axiom,
    ! [VarCurr] :
      ( v9481(VarCurr)
    <=> ( ( v67(VarCurr,bitIndex2)
        <=> $false )
        & ( v67(VarCurr,bitIndex1)
        <=> $true )
        & ( v67(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_241,axiom,
    ! [VarCurr] :
      ( ~ v9470(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v9469(VarCurr,B)
          <=> v9472(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_229,axiom,
    ! [VarCurr] :
      ( v9470(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v9469(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_93,axiom,
    ! [VarCurr] :
      ( ( ~ v9473(VarCurr)
        & ~ v9478(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v9472(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_240,axiom,
    ! [VarCurr] :
      ( v9478(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v9472(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_228,axiom,
    ! [VarCurr] :
      ( v9473(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v9472(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1796,axiom,
    ! [VarCurr] :
      ( v9478(VarCurr)
    <=> ( v9479(VarCurr)
        | v9480(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_684,axiom,
    ! [VarCurr] :
      ( v9480(VarCurr)
    <=> ( ( v4668(VarCurr,bitIndex2)
        <=> $false )
        & ( v4668(VarCurr,bitIndex1)
        <=> $true )
        & ( v4668(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_683,axiom,
    ! [VarCurr] :
      ( v9479(VarCurr)
    <=> ( ( v4668(VarCurr,bitIndex2)
        <=> $false )
        & ( v4668(VarCurr,bitIndex1)
        <=> $false )
        & ( v4668(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1795,axiom,
    ! [VarCurr] :
      ( v9473(VarCurr)
    <=> ( v9474(VarCurr)
        | v9477(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_682,axiom,
    ! [VarCurr] :
      ( v9477(VarCurr)
    <=> ( ( v4668(VarCurr,bitIndex2)
        <=> $true )
        & ( v4668(VarCurr,bitIndex1)
        <=> $false )
        & ( v4668(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1794,axiom,
    ! [VarCurr] :
      ( v9474(VarCurr)
    <=> ( v9475(VarCurr)
        | v9476(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_681,axiom,
    ! [VarCurr] :
      ( v9476(VarCurr)
    <=> ( ( v4668(VarCurr,bitIndex2)
        <=> $false )
        & ( v4668(VarCurr,bitIndex1)
        <=> $true )
        & ( v4668(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_680,axiom,
    ! [VarCurr] :
      ( v9475(VarCurr)
    <=> ( ( v4668(VarCurr,bitIndex2)
        <=> $true )
        & ( v4668(VarCurr,bitIndex1)
        <=> $false )
        & ( v4668(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_679,axiom,
    ! [VarCurr] :
      ( v9471(VarCurr)
    <=> ( v72(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_678,axiom,
    ! [VarCurr] :
      ( v9470(VarCurr)
    <=> ( v72(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_677,axiom,
    ! [VarCurr] :
      ( v9468(VarCurr)
    <=> ( ( v67(VarCurr,bitIndex2)
        <=> $false )
        & ( v67(VarCurr,bitIndex1)
        <=> $false )
        & ( v67(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeUnaryOperator_824,axiom,
    ! [VarCurr] :
      ( ~ v72(VarCurr)
    <=> v74(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_157,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9452(VarNext)
       => ( v74(VarNext)
        <=> v74(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_172,axiom,
    ! [VarNext] :
      ( v9452(VarNext)
     => ( v74(VarNext)
      <=> v9460(VarNext) ) ) ).

fof(addAssignment_2166,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9460(VarNext)
      <=> v9458(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_246,axiom,
    ! [VarCurr] :
      ( ~ v5393(VarCurr)
     => ( v9458(VarCurr)
      <=> v9461(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_250,axiom,
    ! [VarCurr] :
      ( v5393(VarCurr)
     => ( v9458(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_245,axiom,
    ! [VarCurr] :
      ( ~ v76(VarCurr)
     => ( v9461(VarCurr)
      <=> v9462(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_249,axiom,
    ! [VarCurr] :
      ( v76(VarCurr)
     => ( v9461(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1793,axiom,
    ! [VarCurr] :
      ( v9462(VarCurr)
    <=> ( v9463(VarCurr)
        & v74(VarCurr) ) ) ).

fof(writeUnaryOperator_823,axiom,
    ! [VarCurr] :
      ( ~ v9463(VarCurr)
    <=> v9436(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1792,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9452(VarNext)
      <=> v9453(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1791,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9453(VarNext)
      <=> ( v9455(VarNext)
          & v179(VarNext) ) ) ) ).

fof(writeUnaryOperator_822,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9455(VarNext)
      <=> v4675(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_43,axiom,
    ! [VarCurr] :
      ( ( ~ v8711(VarCurr)
        & ~ v8712(VarCurr)
        & ~ v8743(VarCurr) )
     => ( v9436(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_92,axiom,
    ! [VarCurr] :
      ( v8743(VarCurr)
     => ( v9436(VarCurr)
      <=> v9447(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_239,axiom,
    ! [VarCurr] :
      ( v8712(VarCurr)
     => ( v9436(VarCurr)
      <=> v9438(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_227,axiom,
    ! [VarCurr] :
      ( v8711(VarCurr)
     => ( v9436(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_238,axiom,
    ! [VarCurr] :
      ( ~ v9448(VarCurr)
     => ( v9447(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_226,axiom,
    ! [VarCurr] :
      ( v9448(VarCurr)
     => ( v9447(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_676,axiom,
    ! [VarCurr] :
      ( v9449(VarCurr)
    <=> ( v2990(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_675,axiom,
    ! [VarCurr] :
      ( v9448(VarCurr)
    <=> ( v2990(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_237,axiom,
    ! [VarCurr] :
      ( ~ v8714(VarCurr)
     => ( v9438(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_225,axiom,
    ! [VarCurr] :
      ( v8714(VarCurr)
     => ( v9438(VarCurr)
      <=> v9439(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_42,axiom,
    ! [VarCurr] :
      ( ( ~ v8716(VarCurr)
        & ~ v8718(VarCurr)
        & ~ v8732(VarCurr) )
     => ( v9439(VarCurr)
      <=> v9445(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_91,axiom,
    ! [VarCurr] :
      ( v8732(VarCurr)
     => ( v9439(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_236,axiom,
    ! [VarCurr] :
      ( v8718(VarCurr)
     => ( v9439(VarCurr)
      <=> v9443(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_224,axiom,
    ! [VarCurr] :
      ( v8716(VarCurr)
     => ( v9439(VarCurr)
      <=> v9440(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_235,axiom,
    ! [VarCurr] :
      ( ~ v8737(VarCurr)
     => ( v9445(VarCurr)
      <=> v9446(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_223,axiom,
    ! [VarCurr] :
      ( v8737(VarCurr)
     => ( v9445(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_234,axiom,
    ! [VarCurr] :
      ( ~ v8740(VarCurr)
     => ( v9446(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_222,axiom,
    ! [VarCurr] :
      ( v8740(VarCurr)
     => ( v9446(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_233,axiom,
    ! [VarCurr] :
      ( ~ v9444(VarCurr)
     => ( v9443(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_221,axiom,
    ! [VarCurr] :
      ( v9444(VarCurr)
     => ( v9443(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1790,axiom,
    ! [VarCurr] :
      ( v9444(VarCurr)
    <=> ( v8722(VarCurr)
        | v8727(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_232,axiom,
    ! [VarCurr] :
      ( ~ v9441(VarCurr)
     => ( v9440(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_220,axiom,
    ! [VarCurr] :
      ( v9441(VarCurr)
     => ( v9440(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_674,axiom,
    ! [VarCurr] :
      ( v9442(VarCurr)
    <=> ( v8673(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_673,axiom,
    ! [VarCurr] :
      ( v9441(VarCurr)
    <=> ( v8673(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_90,axiom,
    ! [VarCurr] :
      ( ( ~ v151(VarCurr)
        & ~ v152(VarCurr) )
     => ( v76(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_231,axiom,
    ! [VarCurr] :
      ( v152(VarCurr)
     => ( v76(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_219,axiom,
    ! [VarCurr] :
      ( v151(VarCurr)
     => ( v76(VarCurr)
      <=> v9433(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_230,axiom,
    ! [VarCurr] :
      ( ~ v4645(VarCurr)
     => ( v9433(VarCurr)
      <=> v9434(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_218,axiom,
    ! [VarCurr] :
      ( v4645(VarCurr)
     => ( v9433(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_229,axiom,
    ! [VarCurr] :
      ( ~ v4648(VarCurr)
     => ( v9434(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_217,axiom,
    ! [VarCurr] :
      ( v4648(VarCurr)
     => ( v9434(VarCurr)
      <=> $false ) ) ).

fof(addCaseBooleanConditionEqualRanges1_156,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9420(VarNext)
       => ! [B] :
            ( range_1_0(B)
           => ( v78(VarNext,B)
            <=> v78(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_171,axiom,
    ! [VarNext] :
      ( v9420(VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v78(VarNext,B)
          <=> v9428(VarNext,B) ) ) ) ).

fof(addAssignment_2165,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v9428(VarNext,B)
          <=> v9426(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_244,axiom,
    ! [VarCurr] :
      ( ~ v9429(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v9426(VarCurr,B)
          <=> v81(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_248,axiom,
    ! [VarCurr] :
      ( v9429(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v9426(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_672,axiom,
    ! [VarCurr] :
      ( v9429(VarCurr)
    <=> ( v60(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1789,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9420(VarNext)
      <=> v9421(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1788,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9421(VarNext)
      <=> ( v9422(VarNext)
          & v179(VarNext) ) ) ) ).

fof(writeUnaryOperator_821,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9422(VarNext)
      <=> v4675(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_89,axiom,
    ! [VarCurr] :
      ( ( ~ v9408(VarCurr)
        & ~ v9417(VarCurr) )
     => ! [B] :
          ( range_1_0(B)
         => ( v81(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_228,axiom,
    ! [VarCurr] :
      ( v9417(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v81(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_216,axiom,
    ! [VarCurr] :
      ( v9408(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v81(VarCurr,B)
          <=> v9409(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_671,axiom,
    ! [VarCurr] :
      ( v9417(VarCurr)
    <=> ( ( v78(VarCurr,bitIndex1)
        <=> $false )
        & ( v78(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_227,axiom,
    ! [VarCurr] :
      ( ~ v9410(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v9409(VarCurr,B)
          <=> v9412(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_215,axiom,
    ! [VarCurr] :
      ( v9410(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v9409(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_226,axiom,
    ! [VarCurr] :
      ( ~ v9413(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v9412(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_214,axiom,
    ! [VarCurr] :
      ( v9413(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v9412(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_670,axiom,
    ! [VarCurr] :
      ( v9415(VarCurr)
    <=> ( v9416(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1787,axiom,
    ! [VarCurr] :
      ( v9416(VarCurr)
    <=> ( v74(VarCurr)
        | v2990(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_669,axiom,
    ! [VarCurr] :
      ( v9413(VarCurr)
    <=> ( v9414(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1786,axiom,
    ! [VarCurr] :
      ( v9414(VarCurr)
    <=> ( v74(VarCurr)
        | v2990(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_668,axiom,
    ! [VarCurr] :
      ( v9411(VarCurr)
    <=> ( v83(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_667,axiom,
    ! [VarCurr] :
      ( v9410(VarCurr)
    <=> ( v83(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_666,axiom,
    ! [VarCurr] :
      ( v9408(VarCurr)
    <=> ( ( v78(VarCurr,bitIndex1)
        <=> $false )
        & ( v78(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2164,axiom,
    ! [VarCurr] :
      ( v2990(VarCurr)
    <=> v2992(VarCurr) ) ).

fof(addAssignment_2163,axiom,
    ! [VarCurr] :
      ( v2992(VarCurr)
    <=> v2994(VarCurr) ) ).

fof(addAssignment_2162,axiom,
    ! [VarCurr] :
      ( v2994(VarCurr)
    <=> v2996(VarCurr) ) ).

fof(addAssignment_2161,axiom,
    ! [VarCurr] :
      ( v2996(VarCurr)
    <=> v2998(VarCurr) ) ).

fof(addAssignment_2160,axiom,
    ! [VarCurr] :
      ( v2998(VarCurr)
    <=> v3000(VarCurr) ) ).

fof(addAssignment_2159,axiom,
    ! [VarCurr] :
      ( v3000(VarCurr)
    <=> v3002(VarCurr) ) ).

fof(addAssignment_2158,axiom,
    ! [VarCurr] :
      ( v3002(VarCurr)
    <=> v3004(VarCurr,bitIndex6) ) ).

fof(addAssignment_2157,axiom,
    ! [VarNext] :
      ( v3004(VarNext,bitIndex6)
    <=> v9400(VarNext,bitIndex6) ) ).

fof(addCaseBooleanConditionEqualRanges1_155,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9401(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v9400(VarNext,B)
            <=> v3004(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_170,axiom,
    ! [VarNext] :
      ( v9401(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v9400(VarNext,B)
          <=> v9348(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1785,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9401(VarNext)
      <=> v9402(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1784,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9402(VarNext)
      <=> ( v9404(VarNext)
          & v3071(VarNext) ) ) ) ).

fof(writeUnaryOperator_820,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9404(VarNext)
      <=> v3086(VarNext) ) ) ).

fof(addAssignment_2156,axiom,
    ! [VarCurr] :
      ( v3007(VarCurr,bitIndex6)
    <=> v9324(VarCurr,bitIndex6) ) ).

fof(addAssignment_2155,axiom,
    ! [VarCurr] :
      ( v9321(VarCurr,bitIndex6)
    <=> v9322(VarCurr,bitIndex6) ) ).

fof(addAssignment_2154,axiom,
    ! [VarNext] :
      ( v3004(VarNext,bitIndex5)
    <=> v9392(VarNext,bitIndex5) ) ).

fof(addCaseBooleanConditionEqualRanges1_154,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9393(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v9392(VarNext,B)
            <=> v3004(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_169,axiom,
    ! [VarNext] :
      ( v9393(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v9392(VarNext,B)
          <=> v9348(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1783,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9393(VarNext)
      <=> v9394(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1782,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9394(VarNext)
      <=> ( v9396(VarNext)
          & v3071(VarNext) ) ) ) ).

fof(writeUnaryOperator_819,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9396(VarNext)
      <=> v3086(VarNext) ) ) ).

fof(addAssignment_2153,axiom,
    ! [VarCurr] :
      ( v3007(VarCurr,bitIndex5)
    <=> v9324(VarCurr,bitIndex5) ) ).

fof(addAssignment_2152,axiom,
    ! [VarCurr] :
      ( v9321(VarCurr,bitIndex5)
    <=> v9322(VarCurr,bitIndex5) ) ).

fof(addAssignment_2151,axiom,
    ! [VarNext] :
      ( v3004(VarNext,bitIndex4)
    <=> v9384(VarNext,bitIndex4) ) ).

fof(addCaseBooleanConditionEqualRanges1_153,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9385(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v9384(VarNext,B)
            <=> v3004(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_168,axiom,
    ! [VarNext] :
      ( v9385(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v9384(VarNext,B)
          <=> v9348(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1781,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9385(VarNext)
      <=> v9386(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1780,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9386(VarNext)
      <=> ( v9388(VarNext)
          & v3071(VarNext) ) ) ) ).

fof(writeUnaryOperator_818,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9388(VarNext)
      <=> v3086(VarNext) ) ) ).

fof(addAssignment_2150,axiom,
    ! [VarCurr] :
      ( v3007(VarCurr,bitIndex4)
    <=> v9324(VarCurr,bitIndex4) ) ).

fof(addAssignment_2149,axiom,
    ! [VarCurr] :
      ( v9321(VarCurr,bitIndex4)
    <=> v9322(VarCurr,bitIndex4) ) ).

fof(addAssignment_2148,axiom,
    ! [VarNext] :
      ( v3004(VarNext,bitIndex3)
    <=> v9376(VarNext,bitIndex3) ) ).

fof(addCaseBooleanConditionEqualRanges1_152,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9377(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v9376(VarNext,B)
            <=> v3004(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_167,axiom,
    ! [VarNext] :
      ( v9377(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v9376(VarNext,B)
          <=> v9348(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1779,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9377(VarNext)
      <=> v9378(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1778,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9378(VarNext)
      <=> ( v9380(VarNext)
          & v3071(VarNext) ) ) ) ).

fof(writeUnaryOperator_817,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9380(VarNext)
      <=> v3086(VarNext) ) ) ).

fof(addAssignment_2147,axiom,
    ! [VarCurr] :
      ( v3007(VarCurr,bitIndex3)
    <=> v9324(VarCurr,bitIndex3) ) ).

fof(addAssignment_2146,axiom,
    ! [VarCurr] :
      ( v9321(VarCurr,bitIndex3)
    <=> v9322(VarCurr,bitIndex3) ) ).

fof(addAssignment_2145,axiom,
    ! [VarNext] :
      ( v3004(VarNext,bitIndex2)
    <=> v9368(VarNext,bitIndex2) ) ).

fof(addCaseBooleanConditionEqualRanges1_151,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9369(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v9368(VarNext,B)
            <=> v3004(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_166,axiom,
    ! [VarNext] :
      ( v9369(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v9368(VarNext,B)
          <=> v9348(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1777,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9369(VarNext)
      <=> v9370(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1776,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9370(VarNext)
      <=> ( v9372(VarNext)
          & v3071(VarNext) ) ) ) ).

fof(writeUnaryOperator_816,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9372(VarNext)
      <=> v3086(VarNext) ) ) ).

fof(addAssignment_2144,axiom,
    ! [VarCurr] :
      ( v3007(VarCurr,bitIndex2)
    <=> v9324(VarCurr,bitIndex2) ) ).

fof(addAssignment_2143,axiom,
    ! [VarCurr] :
      ( v9321(VarCurr,bitIndex2)
    <=> v9322(VarCurr,bitIndex2) ) ).

fof(addAssignment_2142,axiom,
    ! [VarNext] :
      ( v3004(VarNext,bitIndex1)
    <=> v9360(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_150,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9361(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v9360(VarNext,B)
            <=> v3004(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_165,axiom,
    ! [VarNext] :
      ( v9361(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v9360(VarNext,B)
          <=> v9348(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1775,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9361(VarNext)
      <=> v9362(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1774,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9362(VarNext)
      <=> ( v9364(VarNext)
          & v3071(VarNext) ) ) ) ).

fof(writeUnaryOperator_815,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9364(VarNext)
      <=> v3086(VarNext) ) ) ).

fof(addAssignment_2141,axiom,
    ! [VarCurr] :
      ( v3007(VarCurr,bitIndex1)
    <=> v9324(VarCurr,bitIndex1) ) ).

fof(addAssignment_2140,axiom,
    ! [VarCurr] :
      ( v9321(VarCurr,bitIndex1)
    <=> v9322(VarCurr,bitIndex1) ) ).

fof(addAssignment_2139,axiom,
    ! [VarNext] :
      ( v3004(VarNext,bitIndex0)
    <=> v9352(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionEqualRanges1_149,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9353(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v9352(VarNext,B)
            <=> v3004(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_164,axiom,
    ! [VarNext] :
      ( v9353(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v9352(VarNext,B)
          <=> v9348(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1773,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9353(VarNext)
      <=> v9354(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1772,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9354(VarNext)
      <=> ( v9356(VarNext)
          & v3071(VarNext) ) ) ) ).

fof(writeUnaryOperator_814,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9356(VarNext)
      <=> v3086(VarNext) ) ) ).

fof(addAssignment_2138,axiom,
    ! [VarCurr] :
      ( v3007(VarCurr,bitIndex0)
    <=> v9324(VarCurr,bitIndex0) ) ).

fof(addAssignment_2137,axiom,
    ! [VarNext] :
      ( v3004(VarNext,bitIndex7)
    <=> v9339(VarNext,bitIndex7) ) ).

fof(addCaseBooleanConditionEqualRanges1_148,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9340(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v9339(VarNext,B)
            <=> v3004(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_163,axiom,
    ! [VarNext] :
      ( v9340(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v9339(VarNext,B)
          <=> v9348(VarNext,B) ) ) ) ).

fof(addAssignment_2136,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v9348(VarNext,B)
          <=> v9346(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_243,axiom,
    ! [VarCurr] :
      ( ~ v3093(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v9346(VarCurr,B)
          <=> v3007(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_247,axiom,
    ! [VarCurr] :
      ( v3093(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v9346(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1771,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9340(VarNext)
      <=> v9341(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1770,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9341(VarNext)
      <=> ( v9343(VarNext)
          & v3071(VarNext) ) ) ) ).

fof(writeUnaryOperator_813,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9343(VarNext)
      <=> v3086(VarNext) ) ) ).

fof(addAssignment_2135,axiom,
    ! [VarCurr] :
      ( v3007(VarCurr,bitIndex7)
    <=> v9324(VarCurr,bitIndex7) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_242,axiom,
    ! [VarCurr] :
      ( ~ v9325(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v9324(VarCurr,B)
          <=> v9326(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_246,axiom,
    ! [VarCurr] :
      ( v9325(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v9324(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_41,axiom,
    ! [VarCurr] :
      ( ( ~ v9327(VarCurr)
        & ~ v9329(VarCurr)
        & ~ v9333(VarCurr) )
     => ! [B] :
          ( range_7_0(B)
         => ( v9326(VarCurr,B)
          <=> v3004(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_88,axiom,
    ! [VarCurr] :
      ( v9333(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v9326(VarCurr,B)
          <=> v9335(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_225,axiom,
    ! [VarCurr] :
      ( v9329(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v9326(VarCurr,B)
          <=> v9331(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_213,axiom,
    ! [VarCurr] :
      ( v9327(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v9326(VarCurr,B)
          <=> v3004(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_665,axiom,
    ! [VarCurr] :
      ( v9336(VarCurr)
    <=> ( ( v9337(VarCurr,bitIndex1)
        <=> $true )
        & ( v9337(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2134,axiom,
    ! [VarCurr] :
      ( v9337(VarCurr,bitIndex0)
    <=> v3009(VarCurr) ) ).

fof(addAssignment_2133,axiom,
    ! [VarCurr] :
      ( v9337(VarCurr,bitIndex1)
    <=> v46(VarCurr) ) ).

fof(addAssignment_2132,axiom,
    ! [VarCurr] :
      ( v9335(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_2131,axiom,
    ! [VarCurr,B] :
      ( range_7_1(B)
     => ( v9335(VarCurr,B)
      <=> v9321(VarCurr,B) ) ) ).

fof(range_axiom_52,axiom,
    ! [B] :
      ( range_7_1(B)
    <=> ( $false
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B ) ) ).

fof(addBitVectorEqualityBitBlasted_664,axiom,
    ! [VarCurr] :
      ( v9333(VarCurr)
    <=> ( ( v9334(VarCurr,bitIndex1)
        <=> $true )
        & ( v9334(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2130,axiom,
    ! [VarCurr] :
      ( v9334(VarCurr,bitIndex0)
    <=> v3009(VarCurr) ) ).

fof(addAssignment_2129,axiom,
    ! [VarCurr] :
      ( v9334(VarCurr,bitIndex1)
    <=> v46(VarCurr) ) ).

fof(addAssignment_2128,axiom,
    ! [VarCurr] :
      ( ( v9331(VarCurr,bitIndex6)
      <=> v3004(VarCurr,bitIndex7) )
      & ( v9331(VarCurr,bitIndex5)
      <=> v3004(VarCurr,bitIndex6) )
      & ( v9331(VarCurr,bitIndex4)
      <=> v3004(VarCurr,bitIndex5) )
      & ( v9331(VarCurr,bitIndex3)
      <=> v3004(VarCurr,bitIndex4) )
      & ( v9331(VarCurr,bitIndex2)
      <=> v3004(VarCurr,bitIndex3) )
      & ( v9331(VarCurr,bitIndex1)
      <=> v3004(VarCurr,bitIndex2) )
      & ( v9331(VarCurr,bitIndex0)
      <=> v3004(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_2127,axiom,
    ! [VarCurr] :
      ( v9331(VarCurr,bitIndex7)
    <=> $false ) ).

fof(addBitVectorEqualityBitBlasted_663,axiom,
    ! [VarCurr] :
      ( v9329(VarCurr)
    <=> ( ( v9330(VarCurr,bitIndex1)
        <=> $false )
        & ( v9330(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2126,axiom,
    ! [VarCurr] :
      ( v9330(VarCurr,bitIndex0)
    <=> v3009(VarCurr) ) ).

fof(addAssignment_2125,axiom,
    ! [VarCurr] :
      ( v9330(VarCurr,bitIndex1)
    <=> v46(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_662,axiom,
    ! [VarCurr] :
      ( v9327(VarCurr)
    <=> ( ( v9328(VarCurr,bitIndex1)
        <=> $false )
        & ( v9328(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2124,axiom,
    ! [VarCurr] :
      ( v9328(VarCurr,bitIndex0)
    <=> v3009(VarCurr) ) ).

fof(addAssignment_2123,axiom,
    ! [VarCurr] :
      ( v9328(VarCurr,bitIndex1)
    <=> v46(VarCurr) ) ).

fof(writeUnaryOperator_812,axiom,
    ! [VarCurr] :
      ( ~ v9325(VarCurr)
    <=> v44(VarCurr) ) ).

fof(addAssignment_2122,axiom,
    ! [VarCurr] :
      ( v9321(VarCurr,bitIndex7)
    <=> v9322(VarCurr,bitIndex7) ) ).

fof(addAssignment_2121,axiom,
    ! [VarCurr] :
      ( v9322(VarCurr,bitIndex0)
    <=> $false ) ).

fof(addAssignment_2120,axiom,
    ! [VarCurr] :
      ( ( v9322(VarCurr,bitIndex7)
      <=> v3004(VarCurr,bitIndex6) )
      & ( v9322(VarCurr,bitIndex6)
      <=> v3004(VarCurr,bitIndex5) )
      & ( v9322(VarCurr,bitIndex5)
      <=> v3004(VarCurr,bitIndex4) )
      & ( v9322(VarCurr,bitIndex4)
      <=> v3004(VarCurr,bitIndex3) )
      & ( v9322(VarCurr,bitIndex3)
      <=> v3004(VarCurr,bitIndex2) )
      & ( v9322(VarCurr,bitIndex2)
      <=> v3004(VarCurr,bitIndex1) )
      & ( v9322(VarCurr,bitIndex1)
      <=> v3004(VarCurr,bitIndex0) ) ) ).

fof(addAssignmentInitValueVector_73,axiom,
    ! [B] :
      ( range_7_0(B)
     => ( v3004(constB0,B)
      <=> $false ) ) ).

fof(addAssignment_2119,axiom,
    ! [VarCurr] :
      ( v3009(VarCurr)
    <=> v3011(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1769,axiom,
    ! [VarCurr] :
      ( v3011(VarCurr)
    <=> ( v9319(VarCurr)
        | v9313(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1768,axiom,
    ! [VarCurr] :
      ( v9319(VarCurr)
    <=> ( v3013(VarCurr)
        | v3021(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_241,axiom,
    ! [VarCurr] :
      ( ~ v9315(VarCurr)
     => ( v9313(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_245,axiom,
    ! [VarCurr] :
      ( v9315(VarCurr)
     => ( v9313(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1767,axiom,
    ! [VarCurr] :
      ( v9315(VarCurr)
    <=> ( v9316(VarCurr)
        & v3019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1766,axiom,
    ! [VarCurr] :
      ( v9316(VarCurr)
    <=> ( v9317(VarCurr)
        & v3018(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_661,axiom,
    ! [VarCurr] :
      ( v9317(VarCurr)
    <=> ( ( v38(VarCurr,bitIndex1)
        <=> $false )
        & ( v38(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2118,axiom,
    ! [VarCurr] :
      ( v3021(VarCurr)
    <=> v3023(VarCurr) ) ).

fof(addAssignment_2117,axiom,
    ! [VarCurr] :
      ( v3023(VarCurr)
    <=> v3025(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1765,axiom,
    ! [VarCurr] :
      ( v3025(VarCurr)
    <=> ( v9311(VarCurr)
        & v9016(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_367,axiom,
    ! [VarCurr] :
      ( v9311(VarCurr)
    <=> ( v3027(VarCurr,bitIndex2)
        | v3027(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_2116,axiom,
    ! [VarNext] :
      ( v3027(VarNext,bitIndex2)
    <=> v9303(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionShiftedRanges1_23,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9304(VarNext)
       => ( ( v9303(VarNext,bitIndex2)
          <=> v3027(VarCurr,bitIndex3) )
          & ( v9303(VarNext,bitIndex1)
          <=> v3027(VarCurr,bitIndex2) )
          & ( v9303(VarNext,bitIndex0)
          <=> v3027(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_162,axiom,
    ! [VarNext] :
      ( v9304(VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v9303(VarNext,B)
          <=> v9072(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1764,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9304(VarNext)
      <=> v9305(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1763,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9305(VarNext)
      <=> ( v9307(VarNext)
          & v9059(VarNext) ) ) ) ).

fof(writeUnaryOperator_811,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9307(VarNext)
      <=> v9066(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_112,axiom,
    ! [VarCurr] :
      ( ~ v9298(VarCurr)
     => ( v3031(VarCurr,bitIndex2)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_108,axiom,
    ! [VarCurr] :
      ( v9298(VarCurr)
     => ( v3031(VarCurr,bitIndex2)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1762,axiom,
    ! [VarCurr] :
      ( v9298(VarCurr)
    <=> ( v9299(VarCurr)
        | v9300(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1761,axiom,
    ! [VarCurr] :
      ( v9300(VarCurr)
    <=> ( v9301(VarCurr)
        & v9054(VarCurr) ) ) ).

fof(writeUnaryOperator_810,axiom,
    ! [VarCurr] :
      ( ~ v9301(VarCurr)
    <=> v9016(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1760,axiom,
    ! [VarCurr] :
      ( v9299(VarCurr)
    <=> ( v9102(VarCurr)
        & v9081(VarCurr) ) ) ).

fof(addAssignment_2115,axiom,
    ! [VarCurr] :
      ( v3033(VarCurr)
    <=> v3035(VarCurr) ) ).

fof(addAssignment_2114,axiom,
    ! [VarCurr] :
      ( v3035(VarCurr)
    <=> v3037(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_240,axiom,
    ! [VarCurr] :
      ( ~ v9293(VarCurr)
     => ( v3037(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_244,axiom,
    ! [VarCurr] :
      ( v9293(VarCurr)
     => ( v3037(VarCurr)
      <=> v9296(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_239,axiom,
    ! [VarCurr] :
      ( ~ v3039(VarCurr)
     => ( v9296(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_243,axiom,
    ! [VarCurr] :
      ( v3039(VarCurr)
     => ( v9296(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1759,axiom,
    ! [VarCurr] :
      ( v9293(VarCurr)
    <=> ( v9294(VarCurr)
        & v3019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1758,axiom,
    ! [VarCurr] :
      ( v9294(VarCurr)
    <=> ( v9295(VarCurr)
        & v3018(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_660,axiom,
    ! [VarCurr] :
      ( v9295(VarCurr)
    <=> ( ( v38(VarCurr,bitIndex1)
        <=> $true )
        & ( v38(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2113,axiom,
    ! [VarCurr] :
      ( v3039(VarCurr)
    <=> v3041(VarCurr) ) ).

fof(addAssignment_2112,axiom,
    ! [VarCurr] :
      ( v3041(VarCurr)
    <=> v3043(VarCurr) ) ).

fof(addAssignment_2111,axiom,
    ! [VarCurr] :
      ( v3043(VarCurr)
    <=> v3027(VarCurr,bitIndex0) ) ).

fof(addCaseBooleanConditionEqualRanges1_147,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9281(VarNext)
       => ( v3027(VarNext,bitIndex0)
        <=> v3027(VarCurr,bitIndex0) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_161,axiom,
    ! [VarNext] :
      ( v9281(VarNext)
     => ( v3027(VarNext,bitIndex0)
      <=> v9289(VarNext) ) ) ).

fof(addAssignment_2110,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9289(VarNext)
      <=> v9287(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_238,axiom,
    ! [VarCurr] :
      ( ~ v9073(VarCurr)
     => ( v9287(VarCurr)
      <=> v3031(VarCurr,bitIndex0) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_242,axiom,
    ! [VarCurr] :
      ( v9073(VarCurr)
     => ( v9287(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1757,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9281(VarNext)
      <=> v9282(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1756,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9282(VarNext)
      <=> ( v9284(VarNext)
          & v9059(VarNext) ) ) ) ).

fof(writeUnaryOperator_809,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9284(VarNext)
      <=> v9066(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_237,axiom,
    ! [VarCurr] :
      ( ~ v9274(VarCurr)
     => ( v3031(VarCurr,bitIndex0)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_241,axiom,
    ! [VarCurr] :
      ( v9274(VarCurr)
     => ( v3031(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1755,axiom,
    ! [VarCurr] :
      ( v9274(VarCurr)
    <=> ( v9275(VarCurr)
        | v9278(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1754,axiom,
    ! [VarCurr] :
      ( v9278(VarCurr)
    <=> ( v9016(VarCurr)
        & v9084(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1753,axiom,
    ! [VarCurr] :
      ( v9275(VarCurr)
    <=> ( v9276(VarCurr)
        | v9277(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1752,axiom,
    ! [VarCurr] :
      ( v9277(VarCurr)
    <=> ( v9016(VarCurr)
        & v9057(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1751,axiom,
    ! [VarCurr] :
      ( v9276(VarCurr)
    <=> ( v9099(VarCurr)
        & v9081(VarCurr) ) ) ).

fof(addAssignment_2109,axiom,
    ! [VarCurr] :
      ( v9016(VarCurr)
    <=> v9018(VarCurr) ) ).

fof(addAssignment_2108,axiom,
    ! [VarCurr] :
      ( v9018(VarCurr)
    <=> v9020(VarCurr) ) ).

fof(addAssignment_2107,axiom,
    ! [VarCurr] :
      ( v9020(VarCurr)
    <=> v9022(VarCurr) ) ).

fof(addAssignment_2106,axiom,
    ! [VarCurr] :
      ( v9022(VarCurr)
    <=> v9024(VarCurr) ) ).

fof(addAssignment_2105,axiom,
    ! [VarCurr] :
      ( v9024(VarCurr)
    <=> v9026(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_146,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9261(VarNext)
       => ( v9026(VarNext)
        <=> v9026(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_160,axiom,
    ! [VarNext] :
      ( v9261(VarNext)
     => ( v9026(VarNext)
      <=> v9269(VarNext) ) ) ).

fof(addAssignment_2104,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9269(VarNext)
      <=> v9267(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_236,axiom,
    ! [VarCurr] :
      ( ~ v9270(VarCurr)
     => ( v9267(VarCurr)
      <=> v9032(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_240,axiom,
    ! [VarCurr] :
      ( v9270(VarCurr)
     => ( v9267(VarCurr)
      <=> $false ) ) ).

fof(writeUnaryOperator_808,axiom,
    ! [VarCurr] :
      ( ~ v9270(VarCurr)
    <=> v9028(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1750,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9261(VarNext)
      <=> v9262(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1749,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9262(VarNext)
      <=> ( v9263(VarNext)
          & v9161(VarNext) ) ) ) ).

fof(writeUnaryOperator_807,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9263(VarNext)
      <=> v9170(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_235,axiom,
    ! [VarCurr] :
      ( ~ v9220(VarCurr)
     => ( v9032(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_239,axiom,
    ! [VarCurr] :
      ( v9220(VarCurr)
     => ( v9032(VarCurr)
      <=> v9244(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_224,axiom,
    ! [VarCurr] :
      ( ~ v9181(VarCurr)
     => ( v9244(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_212,axiom,
    ! [VarCurr] :
      ( v9181(VarCurr)
     => ( v9244(VarCurr)
      <=> v9245(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1748,axiom,
    ! [VarCurr] :
      ( v9251(VarCurr)
    <=> ( v9253(VarCurr)
        | v9233(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1747,axiom,
    ! [VarCurr] :
      ( v9253(VarCurr)
    <=> ( v9254(VarCurr)
        | v9232(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1746,axiom,
    ! [VarCurr] :
      ( v9254(VarCurr)
    <=> ( v9255(VarCurr)
        | v9231(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1745,axiom,
    ! [VarCurr] :
      ( v9255(VarCurr)
    <=> ( v9256(VarCurr)
        | v9201(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1744,axiom,
    ! [VarCurr] :
      ( v9256(VarCurr)
    <=> ( v9257(VarCurr)
        | v9200(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1743,axiom,
    ! [VarCurr] :
      ( v9257(VarCurr)
    <=> ( v9258(VarCurr)
        | v9199(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1742,axiom,
    ! [VarCurr] :
      ( v9258(VarCurr)
    <=> ( v9184(VarCurr)
        | v9198(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1741,axiom,
    ! [VarCurr] :
      ( v9184(VarCurr)
    <=> ( v9185(VarCurr)
        | v9190(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_234,axiom,
    ! [VarCurr] :
      ( ~ v9038(VarCurr)
     => ( v9245(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_238,axiom,
    ! [VarCurr] :
      ( v9038(VarCurr)
     => ( v9245(VarCurr)
      <=> v9246(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_233,axiom,
    ! [VarCurr] :
      ( ~ v9247(VarCurr)
     => ( v9246(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_237,axiom,
    ! [VarCurr] :
      ( v9247(VarCurr)
     => ( v9246(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1740,axiom,
    ! [VarCurr] :
      ( v9247(VarCurr)
    <=> ( v9248(VarCurr)
        & v9159(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1739,axiom,
    ! [VarCurr] :
      ( v9248(VarCurr)
    <=> ( v9249(VarCurr)
        | v9250(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_659,axiom,
    ! [VarCurr] :
      ( v9250(VarCurr)
    <=> ( ( v9121(VarCurr,bitIndex3)
        <=> $true )
        & ( v9121(VarCurr,bitIndex2)
        <=> $true )
        & ( v9121(VarCurr,bitIndex1)
        <=> $false )
        & ( v9121(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_658,axiom,
    ! [VarCurr] :
      ( v9249(VarCurr)
    <=> ( ( v9121(VarCurr,bitIndex3)
        <=> $false )
        & ( v9121(VarCurr,bitIndex2)
        <=> $true )
        & ( v9121(VarCurr,bitIndex1)
        <=> $false )
        & ( v9121(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1738,axiom,
    ! [VarCurr] :
      ( v9220(VarCurr)
    <=> ( v9221(VarCurr)
        | v9233(VarCurr) ) ) ).

fof(writeUnaryOperator_806,axiom,
    ! [VarCurr] :
      ( ~ v9233(VarCurr)
    <=> v9234(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1737,axiom,
    ! [VarCurr] :
      ( v9234(VarCurr)
    <=> ( v9235(VarCurr)
        | v9202(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1736,axiom,
    ! [VarCurr] :
      ( v9235(VarCurr)
    <=> ( v9236(VarCurr)
        | v9201(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1735,axiom,
    ! [VarCurr] :
      ( v9236(VarCurr)
    <=> ( v9237(VarCurr)
        | v9200(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1734,axiom,
    ! [VarCurr] :
      ( v9237(VarCurr)
    <=> ( v9238(VarCurr)
        | v9199(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1733,axiom,
    ! [VarCurr] :
      ( v9238(VarCurr)
    <=> ( v9239(VarCurr)
        | v9198(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1732,axiom,
    ! [VarCurr] :
      ( v9239(VarCurr)
    <=> ( v9240(VarCurr)
        | v9191(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1731,axiom,
    ! [VarCurr] :
      ( v9240(VarCurr)
    <=> ( v9241(VarCurr)
        | v9190(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1730,axiom,
    ! [VarCurr] :
      ( v9241(VarCurr)
    <=> ( v9242(VarCurr)
        | v9189(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1729,axiom,
    ! [VarCurr] :
      ( v9242(VarCurr)
    <=> ( v9243(VarCurr)
        | v9188(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1728,axiom,
    ! [VarCurr] :
      ( v9243(VarCurr)
    <=> ( v9181(VarCurr)
        | v9187(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1727,axiom,
    ! [VarCurr] :
      ( v9221(VarCurr)
    <=> ( v9222(VarCurr)
        | v9232(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1726,axiom,
    ! [VarCurr] :
      ( v9232(VarCurr)
    <=> ( v9204(VarCurr)
        & v9202(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1725,axiom,
    ! [VarCurr] :
      ( v9222(VarCurr)
    <=> ( v9223(VarCurr)
        | v9201(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1724,axiom,
    ! [VarCurr] :
      ( v9223(VarCurr)
    <=> ( v9224(VarCurr)
        | v9200(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1723,axiom,
    ! [VarCurr] :
      ( v9224(VarCurr)
    <=> ( v9225(VarCurr)
        | v9199(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1722,axiom,
    ! [VarCurr] :
      ( v9225(VarCurr)
    <=> ( v9226(VarCurr)
        | v9198(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1721,axiom,
    ! [VarCurr] :
      ( v9226(VarCurr)
    <=> ( v9227(VarCurr)
        | v9231(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1720,axiom,
    ! [VarCurr] :
      ( v9231(VarCurr)
    <=> ( v9193(VarCurr)
        & v9191(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1719,axiom,
    ! [VarCurr] :
      ( v9227(VarCurr)
    <=> ( v9228(VarCurr)
        | v9190(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1718,axiom,
    ! [VarCurr] :
      ( v9228(VarCurr)
    <=> ( v9229(VarCurr)
        | v9189(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1717,axiom,
    ! [VarCurr] :
      ( v9229(VarCurr)
    <=> ( v9230(VarCurr)
        | v9188(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1716,axiom,
    ! [VarCurr] :
      ( v9230(VarCurr)
    <=> ( v9181(VarCurr)
        | v9187(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_145,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9207(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v9034(VarNext,B)
            <=> v9034(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_159,axiom,
    ! [VarNext] :
      ( v9207(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v9034(VarNext,B)
          <=> v9215(VarNext,B) ) ) ) ).

fof(addAssignment_2103,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v9215(VarNext,B)
          <=> v9213(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_232,axiom,
    ! [VarCurr] :
      ( ~ v9216(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v9213(VarCurr,B)
          <=> v9036(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_236,axiom,
    ! [VarCurr] :
      ( v9216(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v9213(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_805,axiom,
    ! [VarCurr] :
      ( ~ v9216(VarCurr)
    <=> v9028(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1715,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9207(VarNext)
      <=> v9208(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1714,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9208(VarNext)
      <=> ( v9209(VarNext)
          & v9161(VarNext) ) ) ) ).

fof(writeUnaryOperator_804,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9209(VarNext)
      <=> v9170(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges5_7,axiom,
    ! [VarCurr] :
      ( ( ~ v9181(VarCurr)
        & ~ v9183(VarCurr)
        & ~ v9191(VarCurr)
        & ~ v9194(VarCurr)
        & ~ v9202(VarCurr) )
     => ! [B] :
          ( range_3_0(B)
         => ( v9036(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_10,axiom,
    ! [VarCurr] :
      ( v9202(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v9036(VarCurr,B)
          <=> v9203(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_40,axiom,
    ! [VarCurr] :
      ( v9194(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v9036(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_87,axiom,
    ! [VarCurr] :
      ( v9191(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v9036(VarCurr,B)
          <=> v9192(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_223,axiom,
    ! [VarCurr] :
      ( v9183(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v9036(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_211,axiom,
    ! [VarCurr] :
      ( v9181(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v9036(VarCurr,B)
          <=> v9182(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_231,axiom,
    ! [VarCurr] :
      ( ~ v9204(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v9203(VarCurr,B)
          <=> $false ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_235,axiom,
    ! [VarCurr] :
      ( v9204(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v9203(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_803,axiom,
    ! [VarCurr] :
      ( ~ v9204(VarCurr)
    <=> v9157(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_657,axiom,
    ! [VarCurr] :
      ( v9202(VarCurr)
    <=> ( ( v9034(VarCurr,bitIndex3)
        <=> $true )
        & ( v9034(VarCurr,bitIndex2)
        <=> $true )
        & ( v9034(VarCurr,bitIndex1)
        <=> $false )
        & ( v9034(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1713,axiom,
    ! [VarCurr] :
      ( v9194(VarCurr)
    <=> ( v9196(VarCurr)
        | v9201(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_656,axiom,
    ! [VarCurr] :
      ( v9201(VarCurr)
    <=> ( ( v9034(VarCurr,bitIndex3)
        <=> $true )
        & ( v9034(VarCurr,bitIndex2)
        <=> $true )
        & ( v9034(VarCurr,bitIndex1)
        <=> $false )
        & ( v9034(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1712,axiom,
    ! [VarCurr] :
      ( v9196(VarCurr)
    <=> ( v9197(VarCurr)
        | v9200(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_655,axiom,
    ! [VarCurr] :
      ( v9200(VarCurr)
    <=> ( ( v9034(VarCurr,bitIndex3)
        <=> $true )
        & ( v9034(VarCurr,bitIndex2)
        <=> $false )
        & ( v9034(VarCurr,bitIndex1)
        <=> $true )
        & ( v9034(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1711,axiom,
    ! [VarCurr] :
      ( v9197(VarCurr)
    <=> ( v9198(VarCurr)
        | v9199(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_654,axiom,
    ! [VarCurr] :
      ( v9199(VarCurr)
    <=> ( ( v9034(VarCurr,bitIndex3)
        <=> $true )
        & ( v9034(VarCurr,bitIndex2)
        <=> $false )
        & ( v9034(VarCurr,bitIndex1)
        <=> $true )
        & ( v9034(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_653,axiom,
    ! [VarCurr] :
      ( v9198(VarCurr)
    <=> ( ( v9034(VarCurr,bitIndex3)
        <=> $true )
        & ( v9034(VarCurr,bitIndex2)
        <=> $false )
        & ( v9034(VarCurr,bitIndex1)
        <=> $false )
        & ( v9034(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_230,axiom,
    ! [VarCurr] :
      ( ~ v9193(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v9192(VarCurr,B)
          <=> $false ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_234,axiom,
    ! [VarCurr] :
      ( v9193(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v9192(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_802,axiom,
    ! [VarCurr] :
      ( ~ v9193(VarCurr)
    <=> v9157(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_652,axiom,
    ! [VarCurr] :
      ( v9191(VarCurr)
    <=> ( ( v9034(VarCurr,bitIndex3)
        <=> $false )
        & ( v9034(VarCurr,bitIndex2)
        <=> $true )
        & ( v9034(VarCurr,bitIndex1)
        <=> $false )
        & ( v9034(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1710,axiom,
    ! [VarCurr] :
      ( v9183(VarCurr)
    <=> ( v9185(VarCurr)
        | v9190(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_651,axiom,
    ! [VarCurr] :
      ( v9190(VarCurr)
    <=> ( ( v9034(VarCurr,bitIndex3)
        <=> $false )
        & ( v9034(VarCurr,bitIndex2)
        <=> $true )
        & ( v9034(VarCurr,bitIndex1)
        <=> $false )
        & ( v9034(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1709,axiom,
    ! [VarCurr] :
      ( v9185(VarCurr)
    <=> ( v9186(VarCurr)
        | v9189(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_650,axiom,
    ! [VarCurr] :
      ( v9189(VarCurr)
    <=> ( ( v9034(VarCurr,bitIndex3)
        <=> $false )
        & ( v9034(VarCurr,bitIndex2)
        <=> $false )
        & ( v9034(VarCurr,bitIndex1)
        <=> $true )
        & ( v9034(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1708,axiom,
    ! [VarCurr] :
      ( v9186(VarCurr)
    <=> ( v9187(VarCurr)
        | v9188(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_649,axiom,
    ! [VarCurr] :
      ( v9188(VarCurr)
    <=> ( ( v9034(VarCurr,bitIndex3)
        <=> $false )
        & ( v9034(VarCurr,bitIndex2)
        <=> $false )
        & ( v9034(VarCurr,bitIndex1)
        <=> $true )
        & ( v9034(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_648,axiom,
    ! [VarCurr] :
      ( v9187(VarCurr)
    <=> ( ( v9034(VarCurr,bitIndex3)
        <=> $false )
        & ( v9034(VarCurr,bitIndex2)
        <=> $false )
        & ( v9034(VarCurr,bitIndex1)
        <=> $false )
        & ( v9034(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_229,axiom,
    ! [VarCurr] :
      ( ~ v9038(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v9182(VarCurr,B)
          <=> $false ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_233,axiom,
    ! [VarCurr] :
      ( v9038(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v9182(VarCurr,B)
          <=> v9121(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_647,axiom,
    ! [VarCurr] :
      ( v9181(VarCurr)
    <=> ( ( v9034(VarCurr,bitIndex3)
        <=> $false )
        & ( v9034(VarCurr,bitIndex2)
        <=> $false )
        & ( v9034(VarCurr,bitIndex1)
        <=> $false )
        & ( v9034(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignmentInitValueVector_72,axiom,
    ! [B] :
      ( range_3_0(B)
     => ( v9034(constB0,B)
      <=> $false ) ) ).

fof(addCaseBooleanConditionEqualRanges1_144,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9166(VarNext)
       => ( v9157(VarNext)
        <=> v9157(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_158,axiom,
    ! [VarNext] :
      ( v9166(VarNext)
     => ( v9157(VarNext)
      <=> v9176(VarNext) ) ) ).

fof(addAssignment_2102,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9176(VarNext)
      <=> v9174(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_228,axiom,
    ! [VarCurr] :
      ( ~ v9177(VarCurr)
     => ( v9174(VarCurr)
      <=> v9159(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_232,axiom,
    ! [VarCurr] :
      ( v9177(VarCurr)
     => ( v9174(VarCurr)
      <=> $false ) ) ).

fof(writeUnaryOperator_801,axiom,
    ! [VarCurr] :
      ( ~ v9177(VarCurr)
    <=> v9028(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1707,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9166(VarNext)
      <=> v9167(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1706,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9167(VarNext)
      <=> ( v9168(VarNext)
          & v9161(VarNext) ) ) ) ).

fof(writeUnaryOperator_800,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9168(VarNext)
      <=> v9170(VarNext) ) ) ).

fof(addAssignment_2101,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9170(VarNext)
      <=> v9161(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_71,axiom,
    ( v9157(constB0)
  <=> $false ) ).

fof(addAssignment_2100,axiom,
    ! [VarCurr] :
      ( v9161(VarCurr)
    <=> v9163(VarCurr) ) ).

fof(addAssignment_2099,axiom,
    ! [VarCurr] :
      ( v9163(VarCurr)
    <=> v1(VarCurr) ) ).

fof(addAssignment_2098,axiom,
    ! [VarCurr] :
      ( v9159(VarCurr)
    <=> $false ) ).

fof(addAssignment_2097,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v9121(VarCurr,B)
      <=> v9123(VarCurr,B) ) ) ).

fof(addAssignment_2096,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v9123(VarCurr,B)
      <=> v9125(VarCurr,B) ) ) ).

fof(addAssignment_2095,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v9125(VarCurr,B)
      <=> v9127(VarCurr,B) ) ) ).

fof(addAssignment_2094,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v9127(VarCurr,B)
      <=> v9129(VarCurr,B) ) ) ).

fof(addAssignment_2093,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v9129(VarCurr,B)
      <=> v9131(VarCurr,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_143,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9145(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v9131(VarNext,B)
            <=> v9131(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_157,axiom,
    ! [VarNext] :
      ( v9145(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v9131(VarNext,B)
          <=> v9153(VarNext,B) ) ) ) ).

fof(addAssignment_2092,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v9153(VarNext,B)
          <=> v9151(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_227,axiom,
    ! [VarCurr] :
      ( ~ v9073(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v9151(VarCurr,B)
          <=> v9133(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_231,axiom,
    ! [VarCurr] :
      ( v9073(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v9151(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1705,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9145(VarNext)
      <=> v9146(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1704,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9146(VarNext)
      <=> ( v9148(VarNext)
          & v9059(VarNext) ) ) ) ).

fof(writeUnaryOperator_799,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9148(VarNext)
      <=> v9066(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_226,axiom,
    ! [VarCurr] :
      ( ~ v9135(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v9133(VarCurr,B)
          <=> $false ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_230,axiom,
    ! [VarCurr] :
      ( v9135(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v9133(VarCurr,B)
          <=> v9138(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_39,axiom,
    ! [VarCurr] :
      ( ( ~ v9081(VarCurr)
        & ~ v9054(VarCurr)
        & ~ v9057(VarCurr) )
     => ! [B] :
          ( range_3_0(B)
         => ( v9138(VarCurr,B)
          <=> v9142(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_86,axiom,
    ! [VarCurr] :
      ( v9057(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v9138(VarCurr,B)
          <=> v9141(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_222,axiom,
    ! [VarCurr] :
      ( v9054(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v9138(VarCurr,B)
          <=> v9140(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_210,axiom,
    ! [VarCurr] :
      ( v9081(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v9138(VarCurr,B)
          <=> v9139(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_225,axiom,
    ! [VarCurr] :
      ( ~ v9016(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v9142(VarCurr,B)
          <=> b0011(B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_229,axiom,
    ! [VarCurr] :
      ( v9016(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v9142(VarCurr,B)
          <=> $false ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_224,axiom,
    ! [VarCurr] :
      ( ~ v9016(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v9141(VarCurr,B)
          <=> b0100(B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_228,axiom,
    ! [VarCurr] :
      ( v9016(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v9141(VarCurr,B)
          <=> $false ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_223,axiom,
    ! [VarCurr] :
      ( ~ v9016(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v9140(VarCurr,B)
          <=> b0001(B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_227,axiom,
    ! [VarCurr] :
      ( v9016(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v9140(VarCurr,B)
          <=> b0100(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_85,axiom,
    ! [VarCurr] :
      ( ( ~ v9099(VarCurr)
        & ~ v9102(VarCurr) )
     => ! [B] :
          ( range_3_0(B)
         => ( v9139(VarCurr,B)
          <=> b0011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_221,axiom,
    ! [VarCurr] :
      ( v9102(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v9139(VarCurr,B)
          <=> b0001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_209,axiom,
    ! [VarCurr] :
      ( v9099(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v9139(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1703,axiom,
    ! [VarCurr] :
      ( v9135(VarCurr)
    <=> ( v9136(VarCurr)
        | v9084(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1702,axiom,
    ! [VarCurr] :
      ( v9136(VarCurr)
    <=> ( v9137(VarCurr)
        | v9057(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1701,axiom,
    ! [VarCurr] :
      ( v9137(VarCurr)
    <=> ( v9081(VarCurr)
        | v9054(VarCurr) ) ) ).

fof(addAssignment_2091,axiom,
    ! [VarCurr] :
      ( v9038(VarCurr)
    <=> v9040(VarCurr) ) ).

fof(addAssignment_2090,axiom,
    ! [VarCurr] :
      ( v9040(VarCurr)
    <=> v9042(VarCurr) ) ).

fof(addAssignment_2089,axiom,
    ! [VarCurr] :
      ( v9042(VarCurr)
    <=> v9044(VarCurr) ) ).

fof(addAssignment_2088,axiom,
    ! [VarCurr] :
      ( v9044(VarCurr)
    <=> v9046(VarCurr) ) ).

fof(addAssignment_2087,axiom,
    ! [VarCurr] :
      ( v9046(VarCurr)
    <=> v9048(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_142,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9109(VarNext)
       => ( v9048(VarNext)
        <=> v9048(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_156,axiom,
    ! [VarNext] :
      ( v9109(VarNext)
     => ( v9048(VarNext)
      <=> v9117(VarNext) ) ) ).

fof(addAssignment_2086,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9117(VarNext)
      <=> v9115(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_222,axiom,
    ! [VarCurr] :
      ( ~ v9073(VarCurr)
     => ( v9115(VarCurr)
      <=> v9050(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_226,axiom,
    ! [VarCurr] :
      ( v9073(VarCurr)
     => ( v9115(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1700,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9109(VarNext)
      <=> v9110(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1699,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9110(VarNext)
      <=> ( v9112(VarNext)
          & v9059(VarNext) ) ) ) ).

fof(writeUnaryOperator_798,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9112(VarNext)
      <=> v9066(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_221,axiom,
    ! [VarCurr] :
      ( ~ v9094(VarCurr)
     => ( v9050(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_225,axiom,
    ! [VarCurr] :
      ( v9094(VarCurr)
     => ( v9050(VarCurr)
      <=> v9097(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_84,axiom,
    ! [VarCurr] :
      ( ( ~ v9081(VarCurr)
        & ~ v9054(VarCurr) )
     => ( v9097(VarCurr)
      <=> v9106(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_220,axiom,
    ! [VarCurr] :
      ( v9054(VarCurr)
     => ( v9097(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_208,axiom,
    ! [VarCurr] :
      ( v9081(VarCurr)
     => ( v9097(VarCurr)
      <=> v9098(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_220,axiom,
    ! [VarCurr] :
      ( ~ v9016(VarCurr)
     => ( v9106(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_224,axiom,
    ! [VarCurr] :
      ( v9016(VarCurr)
     => ( v9106(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1698,axiom,
    ! [VarCurr] :
      ( v9105(VarCurr)
    <=> ( v9057(VarCurr)
        | v9084(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_219,axiom,
    ! [VarCurr] :
      ( ~ v9099(VarCurr)
     => ( v9098(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_207,axiom,
    ! [VarCurr] :
      ( v9099(VarCurr)
     => ( v9098(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1697,axiom,
    ! [VarCurr] :
      ( v9101(VarCurr)
    <=> ( v9102(VarCurr)
        | v9079(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1696,axiom,
    ! [VarCurr] :
      ( v9102(VarCurr)
    <=> ( v3033(VarCurr)
        & v9104(VarCurr) ) ) ).

fof(writeUnaryOperator_797,axiom,
    ! [VarCurr] :
      ( ~ v9104(VarCurr)
    <=> v3045(VarCurr) ) ).

fof(writeUnaryOperator_796,axiom,
    ! [VarCurr] :
      ( ~ v9099(VarCurr)
    <=> v3033(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1695,axiom,
    ! [VarCurr] :
      ( v9094(VarCurr)
    <=> ( v9095(VarCurr)
        | v9084(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1694,axiom,
    ! [VarCurr] :
      ( v9095(VarCurr)
    <=> ( v9096(VarCurr)
        | v9057(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1693,axiom,
    ! [VarCurr] :
      ( v9096(VarCurr)
    <=> ( v9081(VarCurr)
        | v9054(VarCurr) ) ) ).

fof(addAssignment_2085,axiom,
    ! [VarNext] :
      ( v3027(VarNext,bitIndex1)
    <=> v9086(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionShiftedRanges1_22,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9087(VarNext)
       => ( ( v9086(VarNext,bitIndex2)
          <=> v3027(VarCurr,bitIndex3) )
          & ( v9086(VarNext,bitIndex1)
          <=> v3027(VarCurr,bitIndex2) )
          & ( v9086(VarNext,bitIndex0)
          <=> v3027(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_155,axiom,
    ! [VarNext] :
      ( v9087(VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v9086(VarNext,B)
          <=> v9072(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1692,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9087(VarNext)
      <=> v9088(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1691,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9088(VarNext)
      <=> ( v9090(VarNext)
          & v9059(VarNext) ) ) ) ).

fof(writeUnaryOperator_795,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9090(VarNext)
      <=> v9066(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_111,axiom,
    ! [VarCurr] :
      ( ~ v9077(VarCurr)
     => ( v3031(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_107,axiom,
    ! [VarCurr] :
      ( v9077(VarCurr)
     => ( v3031(VarCurr,bitIndex1)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1690,axiom,
    ! [VarCurr] :
      ( v9077(VarCurr)
    <=> ( v9078(VarCurr)
        | v9082(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1689,axiom,
    ! [VarCurr] :
      ( v9082(VarCurr)
    <=> ( v9083(VarCurr)
        & v9084(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_646,axiom,
    ! [VarCurr] :
      ( v9084(VarCurr)
    <=> ( $true
      <=> v3027(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_794,axiom,
    ! [VarCurr] :
      ( ~ v9083(VarCurr)
    <=> v9016(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1688,axiom,
    ! [VarCurr] :
      ( v9078(VarCurr)
    <=> ( v9079(VarCurr)
        & v9081(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_645,axiom,
    ! [VarCurr] :
      ( v9081(VarCurr)
    <=> ( $true
      <=> v3027(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1687,axiom,
    ! [VarCurr] :
      ( v9079(VarCurr)
    <=> ( v3033(VarCurr)
        & v3045(VarCurr) ) ) ).

fof(addAssignment_2084,axiom,
    ! [VarNext] :
      ( v3027(VarNext,bitIndex3)
    <=> v9061(VarNext,bitIndex2) ) ).

fof(addCaseBooleanConditionShiftedRanges1_21,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9062(VarNext)
       => ( ( v9061(VarNext,bitIndex2)
          <=> v3027(VarCurr,bitIndex3) )
          & ( v9061(VarNext,bitIndex1)
          <=> v3027(VarCurr,bitIndex2) )
          & ( v9061(VarNext,bitIndex0)
          <=> v3027(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_154,axiom,
    ! [VarNext] :
      ( v9062(VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v9061(VarNext,B)
          <=> v9072(VarNext,B) ) ) ) ).

fof(addAssignment_2083,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v9072(VarNext,B)
          <=> v9070(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_110,axiom,
    ! [VarCurr] :
      ( ~ v9073(VarCurr)
     => ( ( v9070(VarCurr,bitIndex2)
        <=> v3031(VarCurr,bitIndex3) )
        & ( v9070(VarCurr,bitIndex1)
        <=> v3031(VarCurr,bitIndex2) )
        & ( v9070(VarCurr,bitIndex0)
        <=> v3031(VarCurr,bitIndex1) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_223,axiom,
    ! [VarCurr] :
      ( v9073(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v9070(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_793,axiom,
    ! [VarCurr] :
      ( ~ v9073(VarCurr)
    <=> v3029(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1686,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9062(VarNext)
      <=> v9063(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1685,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9063(VarNext)
      <=> ( v9064(VarNext)
          & v9059(VarNext) ) ) ) ).

fof(writeUnaryOperator_792,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v9064(VarNext)
      <=> v9066(VarNext) ) ) ).

fof(addAssignment_2082,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v9066(VarNext)
      <=> v9059(VarCurr) ) ) ).

fof(addAssignment_2081,axiom,
    ! [VarCurr] :
      ( v9059(VarCurr)
    <=> v3075(VarCurr) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_109,axiom,
    ! [VarCurr] :
      ( ~ v9052(VarCurr)
     => ( v3031(VarCurr,bitIndex3)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_106,axiom,
    ! [VarCurr] :
      ( v9052(VarCurr)
     => ( v3031(VarCurr,bitIndex3)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1684,axiom,
    ! [VarCurr] :
      ( v9052(VarCurr)
    <=> ( v9053(VarCurr)
        | v9055(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1683,axiom,
    ! [VarCurr] :
      ( v9055(VarCurr)
    <=> ( v9056(VarCurr)
        & v9057(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_644,axiom,
    ! [VarCurr] :
      ( v9057(VarCurr)
    <=> ( $true
      <=> v3027(VarCurr,bitIndex3) ) ) ).

fof(writeUnaryOperator_791,axiom,
    ! [VarCurr] :
      ( ~ v9056(VarCurr)
    <=> v9016(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1682,axiom,
    ! [VarCurr] :
      ( v9053(VarCurr)
    <=> ( v9016(VarCurr)
        & v9054(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_643,axiom,
    ! [VarCurr] :
      ( v9054(VarCurr)
    <=> ( $true
      <=> v3027(VarCurr,bitIndex2) ) ) ).

fof(addAssignmentInitValueVector_70,axiom,
    ( ( v3027(constB0,bitIndex3)
    <=> $false )
    & ( v3027(constB0,bitIndex2)
    <=> $false )
    & ( v3027(constB0,bitIndex1)
    <=> $false ) ) ).

fof(addAssignmentInitValueVector_69,axiom,
    ( v3027(constB0,bitIndex0)
  <=> $true ) ).

fof(addAssignment_2080,axiom,
    ! [VarCurr] :
      ( v9028(VarCurr)
    <=> v9030(VarCurr) ) ).

fof(addAssignment_2079,axiom,
    ! [VarCurr] :
      ( v9030(VarCurr)
    <=> v14(VarCurr) ) ).

fof(addAssignment_2078,axiom,
    ! [VarCurr] :
      ( v3045(VarCurr)
    <=> v3047(VarCurr) ) ).

fof(addAssignment_2077,axiom,
    ! [VarCurr] :
      ( v3047(VarCurr)
    <=> v3049(VarCurr) ) ).

fof(addAssignment_2076,axiom,
    ! [VarCurr] :
      ( v3049(VarCurr)
    <=> v3051(VarCurr,bitIndex0) ) ).

fof(addAssignment_2075,axiom,
    ! [VarCurr] :
      ( v3051(VarCurr,bitIndex0)
    <=> v3053(VarCurr,bitIndex49) ) ).

fof(addAssignment_2074,axiom,
    ! [VarCurr] :
      ( v3053(VarCurr,bitIndex49)
    <=> v3055(VarCurr,bitIndex49) ) ).

fof(addAssignment_2073,axiom,
    ! [VarCurr] :
      ( v3055(VarCurr,bitIndex49)
    <=> v3057(VarCurr,bitIndex539) ) ).

fof(addAssignment_2072,axiom,
    ! [VarNext] :
      ( v3057(VarNext,bitIndex539)
    <=> v8983(VarNext,bitIndex49) ) ).

fof(addCaseBooleanConditionShiftedRanges1_20,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8984(VarNext)
       => ( ( v8983(VarNext,bitIndex69)
          <=> v3057(VarCurr,bitIndex559) )
          & ( v8983(VarNext,bitIndex68)
          <=> v3057(VarCurr,bitIndex558) )
          & ( v8983(VarNext,bitIndex67)
          <=> v3057(VarCurr,bitIndex557) )
          & ( v8983(VarNext,bitIndex66)
          <=> v3057(VarCurr,bitIndex556) )
          & ( v8983(VarNext,bitIndex65)
          <=> v3057(VarCurr,bitIndex555) )
          & ( v8983(VarNext,bitIndex64)
          <=> v3057(VarCurr,bitIndex554) )
          & ( v8983(VarNext,bitIndex63)
          <=> v3057(VarCurr,bitIndex553) )
          & ( v8983(VarNext,bitIndex62)
          <=> v3057(VarCurr,bitIndex552) )
          & ( v8983(VarNext,bitIndex61)
          <=> v3057(VarCurr,bitIndex551) )
          & ( v8983(VarNext,bitIndex60)
          <=> v3057(VarCurr,bitIndex550) )
          & ( v8983(VarNext,bitIndex59)
          <=> v3057(VarCurr,bitIndex549) )
          & ( v8983(VarNext,bitIndex58)
          <=> v3057(VarCurr,bitIndex548) )
          & ( v8983(VarNext,bitIndex57)
          <=> v3057(VarCurr,bitIndex547) )
          & ( v8983(VarNext,bitIndex56)
          <=> v3057(VarCurr,bitIndex546) )
          & ( v8983(VarNext,bitIndex55)
          <=> v3057(VarCurr,bitIndex545) )
          & ( v8983(VarNext,bitIndex54)
          <=> v3057(VarCurr,bitIndex544) )
          & ( v8983(VarNext,bitIndex53)
          <=> v3057(VarCurr,bitIndex543) )
          & ( v8983(VarNext,bitIndex52)
          <=> v3057(VarCurr,bitIndex542) )
          & ( v8983(VarNext,bitIndex51)
          <=> v3057(VarCurr,bitIndex541) )
          & ( v8983(VarNext,bitIndex50)
          <=> v3057(VarCurr,bitIndex540) )
          & ( v8983(VarNext,bitIndex49)
          <=> v3057(VarCurr,bitIndex539) )
          & ( v8983(VarNext,bitIndex48)
          <=> v3057(VarCurr,bitIndex538) )
          & ( v8983(VarNext,bitIndex47)
          <=> v3057(VarCurr,bitIndex537) )
          & ( v8983(VarNext,bitIndex46)
          <=> v3057(VarCurr,bitIndex536) )
          & ( v8983(VarNext,bitIndex45)
          <=> v3057(VarCurr,bitIndex535) )
          & ( v8983(VarNext,bitIndex44)
          <=> v3057(VarCurr,bitIndex534) )
          & ( v8983(VarNext,bitIndex43)
          <=> v3057(VarCurr,bitIndex533) )
          & ( v8983(VarNext,bitIndex42)
          <=> v3057(VarCurr,bitIndex532) )
          & ( v8983(VarNext,bitIndex41)
          <=> v3057(VarCurr,bitIndex531) )
          & ( v8983(VarNext,bitIndex40)
          <=> v3057(VarCurr,bitIndex530) )
          & ( v8983(VarNext,bitIndex39)
          <=> v3057(VarCurr,bitIndex529) )
          & ( v8983(VarNext,bitIndex38)
          <=> v3057(VarCurr,bitIndex528) )
          & ( v8983(VarNext,bitIndex37)
          <=> v3057(VarCurr,bitIndex527) )
          & ( v8983(VarNext,bitIndex36)
          <=> v3057(VarCurr,bitIndex526) )
          & ( v8983(VarNext,bitIndex35)
          <=> v3057(VarCurr,bitIndex525) )
          & ( v8983(VarNext,bitIndex34)
          <=> v3057(VarCurr,bitIndex524) )
          & ( v8983(VarNext,bitIndex33)
          <=> v3057(VarCurr,bitIndex523) )
          & ( v8983(VarNext,bitIndex32)
          <=> v3057(VarCurr,bitIndex522) )
          & ( v8983(VarNext,bitIndex31)
          <=> v3057(VarCurr,bitIndex521) )
          & ( v8983(VarNext,bitIndex30)
          <=> v3057(VarCurr,bitIndex520) )
          & ( v8983(VarNext,bitIndex29)
          <=> v3057(VarCurr,bitIndex519) )
          & ( v8983(VarNext,bitIndex28)
          <=> v3057(VarCurr,bitIndex518) )
          & ( v8983(VarNext,bitIndex27)
          <=> v3057(VarCurr,bitIndex517) )
          & ( v8983(VarNext,bitIndex26)
          <=> v3057(VarCurr,bitIndex516) )
          & ( v8983(VarNext,bitIndex25)
          <=> v3057(VarCurr,bitIndex515) )
          & ( v8983(VarNext,bitIndex24)
          <=> v3057(VarCurr,bitIndex514) )
          & ( v8983(VarNext,bitIndex23)
          <=> v3057(VarCurr,bitIndex513) )
          & ( v8983(VarNext,bitIndex22)
          <=> v3057(VarCurr,bitIndex512) )
          & ( v8983(VarNext,bitIndex21)
          <=> v3057(VarCurr,bitIndex511) )
          & ( v8983(VarNext,bitIndex20)
          <=> v3057(VarCurr,bitIndex510) )
          & ( v8983(VarNext,bitIndex19)
          <=> v3057(VarCurr,bitIndex509) )
          & ( v8983(VarNext,bitIndex18)
          <=> v3057(VarCurr,bitIndex508) )
          & ( v8983(VarNext,bitIndex17)
          <=> v3057(VarCurr,bitIndex507) )
          & ( v8983(VarNext,bitIndex16)
          <=> v3057(VarCurr,bitIndex506) )
          & ( v8983(VarNext,bitIndex15)
          <=> v3057(VarCurr,bitIndex505) )
          & ( v8983(VarNext,bitIndex14)
          <=> v3057(VarCurr,bitIndex504) )
          & ( v8983(VarNext,bitIndex13)
          <=> v3057(VarCurr,bitIndex503) )
          & ( v8983(VarNext,bitIndex12)
          <=> v3057(VarCurr,bitIndex502) )
          & ( v8983(VarNext,bitIndex11)
          <=> v3057(VarCurr,bitIndex501) )
          & ( v8983(VarNext,bitIndex10)
          <=> v3057(VarCurr,bitIndex500) )
          & ( v8983(VarNext,bitIndex9)
          <=> v3057(VarCurr,bitIndex499) )
          & ( v8983(VarNext,bitIndex8)
          <=> v3057(VarCurr,bitIndex498) )
          & ( v8983(VarNext,bitIndex7)
          <=> v3057(VarCurr,bitIndex497) )
          & ( v8983(VarNext,bitIndex6)
          <=> v3057(VarCurr,bitIndex496) )
          & ( v8983(VarNext,bitIndex5)
          <=> v3057(VarCurr,bitIndex495) )
          & ( v8983(VarNext,bitIndex4)
          <=> v3057(VarCurr,bitIndex494) )
          & ( v8983(VarNext,bitIndex3)
          <=> v3057(VarCurr,bitIndex493) )
          & ( v8983(VarNext,bitIndex2)
          <=> v3057(VarCurr,bitIndex492) )
          & ( v8983(VarNext,bitIndex1)
          <=> v3057(VarCurr,bitIndex491) )
          & ( v8983(VarNext,bitIndex0)
          <=> v3057(VarCurr,bitIndex490) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_153,axiom,
    ! [VarNext] :
      ( v8984(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v8983(VarNext,B)
          <=> v9010(VarNext,B) ) ) ) ).

fof(addAssignment_2071,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v9010(VarNext,B)
          <=> v9008(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_218,axiom,
    ! [VarCurr] :
      ( ~ v8855(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v9008(VarCurr,B)
          <=> v9011(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_206,axiom,
    ! [VarCurr] :
      ( v8855(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v9008(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_83,axiom,
    ! [VarCurr] :
      ( ( ~ v8997(VarCurr)
        & ~ v8999(VarCurr) )
     => ! [B] :
          ( range_69_0(B)
         => ( v9011(VarCurr,B)
          <=> v8976(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_217,axiom,
    ! [VarCurr] :
      ( v8999(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v9011(VarCurr,B)
          <=> v8969(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_13,axiom,
    ! [VarCurr] :
      ( v8997(VarCurr)
     => ( ( v9011(VarCurr,bitIndex69)
        <=> v3057(VarCurr,bitIndex489) )
        & ( v9011(VarCurr,bitIndex68)
        <=> v3057(VarCurr,bitIndex488) )
        & ( v9011(VarCurr,bitIndex67)
        <=> v3057(VarCurr,bitIndex487) )
        & ( v9011(VarCurr,bitIndex66)
        <=> v3057(VarCurr,bitIndex486) )
        & ( v9011(VarCurr,bitIndex65)
        <=> v3057(VarCurr,bitIndex485) )
        & ( v9011(VarCurr,bitIndex64)
        <=> v3057(VarCurr,bitIndex484) )
        & ( v9011(VarCurr,bitIndex63)
        <=> v3057(VarCurr,bitIndex483) )
        & ( v9011(VarCurr,bitIndex62)
        <=> v3057(VarCurr,bitIndex482) )
        & ( v9011(VarCurr,bitIndex61)
        <=> v3057(VarCurr,bitIndex481) )
        & ( v9011(VarCurr,bitIndex60)
        <=> v3057(VarCurr,bitIndex480) )
        & ( v9011(VarCurr,bitIndex59)
        <=> v3057(VarCurr,bitIndex479) )
        & ( v9011(VarCurr,bitIndex58)
        <=> v3057(VarCurr,bitIndex478) )
        & ( v9011(VarCurr,bitIndex57)
        <=> v3057(VarCurr,bitIndex477) )
        & ( v9011(VarCurr,bitIndex56)
        <=> v3057(VarCurr,bitIndex476) )
        & ( v9011(VarCurr,bitIndex55)
        <=> v3057(VarCurr,bitIndex475) )
        & ( v9011(VarCurr,bitIndex54)
        <=> v3057(VarCurr,bitIndex474) )
        & ( v9011(VarCurr,bitIndex53)
        <=> v3057(VarCurr,bitIndex473) )
        & ( v9011(VarCurr,bitIndex52)
        <=> v3057(VarCurr,bitIndex472) )
        & ( v9011(VarCurr,bitIndex51)
        <=> v3057(VarCurr,bitIndex471) )
        & ( v9011(VarCurr,bitIndex50)
        <=> v3057(VarCurr,bitIndex470) )
        & ( v9011(VarCurr,bitIndex49)
        <=> v3057(VarCurr,bitIndex469) )
        & ( v9011(VarCurr,bitIndex48)
        <=> v3057(VarCurr,bitIndex468) )
        & ( v9011(VarCurr,bitIndex47)
        <=> v3057(VarCurr,bitIndex467) )
        & ( v9011(VarCurr,bitIndex46)
        <=> v3057(VarCurr,bitIndex466) )
        & ( v9011(VarCurr,bitIndex45)
        <=> v3057(VarCurr,bitIndex465) )
        & ( v9011(VarCurr,bitIndex44)
        <=> v3057(VarCurr,bitIndex464) )
        & ( v9011(VarCurr,bitIndex43)
        <=> v3057(VarCurr,bitIndex463) )
        & ( v9011(VarCurr,bitIndex42)
        <=> v3057(VarCurr,bitIndex462) )
        & ( v9011(VarCurr,bitIndex41)
        <=> v3057(VarCurr,bitIndex461) )
        & ( v9011(VarCurr,bitIndex40)
        <=> v3057(VarCurr,bitIndex460) )
        & ( v9011(VarCurr,bitIndex39)
        <=> v3057(VarCurr,bitIndex459) )
        & ( v9011(VarCurr,bitIndex38)
        <=> v3057(VarCurr,bitIndex458) )
        & ( v9011(VarCurr,bitIndex37)
        <=> v3057(VarCurr,bitIndex457) )
        & ( v9011(VarCurr,bitIndex36)
        <=> v3057(VarCurr,bitIndex456) )
        & ( v9011(VarCurr,bitIndex35)
        <=> v3057(VarCurr,bitIndex455) )
        & ( v9011(VarCurr,bitIndex34)
        <=> v3057(VarCurr,bitIndex454) )
        & ( v9011(VarCurr,bitIndex33)
        <=> v3057(VarCurr,bitIndex453) )
        & ( v9011(VarCurr,bitIndex32)
        <=> v3057(VarCurr,bitIndex452) )
        & ( v9011(VarCurr,bitIndex31)
        <=> v3057(VarCurr,bitIndex451) )
        & ( v9011(VarCurr,bitIndex30)
        <=> v3057(VarCurr,bitIndex450) )
        & ( v9011(VarCurr,bitIndex29)
        <=> v3057(VarCurr,bitIndex449) )
        & ( v9011(VarCurr,bitIndex28)
        <=> v3057(VarCurr,bitIndex448) )
        & ( v9011(VarCurr,bitIndex27)
        <=> v3057(VarCurr,bitIndex447) )
        & ( v9011(VarCurr,bitIndex26)
        <=> v3057(VarCurr,bitIndex446) )
        & ( v9011(VarCurr,bitIndex25)
        <=> v3057(VarCurr,bitIndex445) )
        & ( v9011(VarCurr,bitIndex24)
        <=> v3057(VarCurr,bitIndex444) )
        & ( v9011(VarCurr,bitIndex23)
        <=> v3057(VarCurr,bitIndex443) )
        & ( v9011(VarCurr,bitIndex22)
        <=> v3057(VarCurr,bitIndex442) )
        & ( v9011(VarCurr,bitIndex21)
        <=> v3057(VarCurr,bitIndex441) )
        & ( v9011(VarCurr,bitIndex20)
        <=> v3057(VarCurr,bitIndex440) )
        & ( v9011(VarCurr,bitIndex19)
        <=> v3057(VarCurr,bitIndex439) )
        & ( v9011(VarCurr,bitIndex18)
        <=> v3057(VarCurr,bitIndex438) )
        & ( v9011(VarCurr,bitIndex17)
        <=> v3057(VarCurr,bitIndex437) )
        & ( v9011(VarCurr,bitIndex16)
        <=> v3057(VarCurr,bitIndex436) )
        & ( v9011(VarCurr,bitIndex15)
        <=> v3057(VarCurr,bitIndex435) )
        & ( v9011(VarCurr,bitIndex14)
        <=> v3057(VarCurr,bitIndex434) )
        & ( v9011(VarCurr,bitIndex13)
        <=> v3057(VarCurr,bitIndex433) )
        & ( v9011(VarCurr,bitIndex12)
        <=> v3057(VarCurr,bitIndex432) )
        & ( v9011(VarCurr,bitIndex11)
        <=> v3057(VarCurr,bitIndex431) )
        & ( v9011(VarCurr,bitIndex10)
        <=> v3057(VarCurr,bitIndex430) )
        & ( v9011(VarCurr,bitIndex9)
        <=> v3057(VarCurr,bitIndex429) )
        & ( v9011(VarCurr,bitIndex8)
        <=> v3057(VarCurr,bitIndex428) )
        & ( v9011(VarCurr,bitIndex7)
        <=> v3057(VarCurr,bitIndex427) )
        & ( v9011(VarCurr,bitIndex6)
        <=> v3057(VarCurr,bitIndex426) )
        & ( v9011(VarCurr,bitIndex5)
        <=> v3057(VarCurr,bitIndex425) )
        & ( v9011(VarCurr,bitIndex4)
        <=> v3057(VarCurr,bitIndex424) )
        & ( v9011(VarCurr,bitIndex3)
        <=> v3057(VarCurr,bitIndex423) )
        & ( v9011(VarCurr,bitIndex2)
        <=> v3057(VarCurr,bitIndex422) )
        & ( v9011(VarCurr,bitIndex1)
        <=> v3057(VarCurr,bitIndex421) )
        & ( v9011(VarCurr,bitIndex0)
        <=> v3057(VarCurr,bitIndex420) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1681,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8984(VarNext)
      <=> ( v8985(VarNext)
          & v8992(VarNext) ) ) ) ).

fof(addAssignment_2070,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8992(VarNext)
      <=> v8990(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1680,axiom,
    ! [VarCurr] :
      ( v8990(VarCurr)
    <=> ( v8993(VarCurr)
        & v9004(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1679,axiom,
    ! [VarCurr] :
      ( v9004(VarCurr)
    <=> ( v9005(VarCurr)
        | v8855(VarCurr) ) ) ).

fof(writeUnaryOperator_790,axiom,
    ! [VarCurr] :
      ( ~ v9005(VarCurr)
    <=> v9006(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_642,axiom,
    ! [VarCurr] :
      ( v9006(VarCurr)
    <=> ( ( v9007(VarCurr,bitIndex1)
        <=> $false )
        & ( v9007(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2069,axiom,
    ! [VarCurr] :
      ( v9007(VarCurr,bitIndex0)
    <=> v3009(VarCurr) ) ).

fof(addAssignment_2068,axiom,
    ! [VarCurr] :
      ( v9007(VarCurr,bitIndex1)
    <=> v46(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1678,axiom,
    ! [VarCurr] :
      ( v8993(VarCurr)
    <=> ( v8855(VarCurr)
        | v8994(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1677,axiom,
    ! [VarCurr] :
      ( v8994(VarCurr)
    <=> ( v8995(VarCurr)
        & v9003(VarCurr) ) ) ).

fof(writeUnaryOperator_789,axiom,
    ! [VarCurr] :
      ( ~ v9003(VarCurr)
    <=> v8855(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1676,axiom,
    ! [VarCurr] :
      ( v8995(VarCurr)
    <=> ( v8996(VarCurr)
        | v9001(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_641,axiom,
    ! [VarCurr] :
      ( v9001(VarCurr)
    <=> ( ( v9002(VarCurr,bitIndex1)
        <=> $true )
        & ( v9002(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2067,axiom,
    ! [VarCurr] :
      ( v9002(VarCurr,bitIndex0)
    <=> v3009(VarCurr) ) ).

fof(addAssignment_2066,axiom,
    ! [VarCurr] :
      ( v9002(VarCurr,bitIndex1)
    <=> v46(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1675,axiom,
    ! [VarCurr] :
      ( v8996(VarCurr)
    <=> ( v8997(VarCurr)
        | v8999(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_640,axiom,
    ! [VarCurr] :
      ( v8999(VarCurr)
    <=> ( ( v9000(VarCurr,bitIndex1)
        <=> $true )
        & ( v9000(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2065,axiom,
    ! [VarCurr] :
      ( v9000(VarCurr,bitIndex0)
    <=> v3009(VarCurr) ) ).

fof(addAssignment_2064,axiom,
    ! [VarCurr] :
      ( v9000(VarCurr,bitIndex1)
    <=> v46(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_639,axiom,
    ! [VarCurr] :
      ( v8997(VarCurr)
    <=> ( ( v8998(VarCurr,bitIndex1)
        <=> $false )
        & ( v8998(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2063,axiom,
    ! [VarCurr] :
      ( v8998(VarCurr,bitIndex0)
    <=> v3009(VarCurr) ) ).

fof(addAssignment_2062,axiom,
    ! [VarCurr] :
      ( v8998(VarCurr,bitIndex1)
    <=> v46(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1674,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8985(VarNext)
      <=> ( v8987(VarNext)
          & v3071(VarNext) ) ) ) ).

fof(writeUnaryOperator_788,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8987(VarNext)
      <=> v3086(VarNext) ) ) ).

fof(addAssignment_2061,axiom,
    ! [VarCurr] :
      ( v8976(VarCurr,bitIndex49)
    <=> v8981(VarCurr,bitIndex49) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_219,axiom,
    ! [VarCurr] :
      ( ~ v8978(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v8981(VarCurr,B)
          <=> v8980(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_222,axiom,
    ! [VarCurr] :
      ( v8978(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v8981(VarCurr,B)
          <=> v3154(VarCurr,B) ) ) ) ).

fof(addAssignment_2060,axiom,
    ! [VarCurr] :
      ( v8980(VarCurr,bitIndex49)
    <=> v3057(VarCurr,bitIndex469) ) ).

fof(addAssignment_2059,axiom,
    ! [VarCurr] :
      ( v8978(VarCurr)
    <=> v3064(VarCurr,bitIndex1) ) ).

fof(addAssignment_2058,axiom,
    ! [VarCurr] :
      ( v8969(VarCurr,bitIndex49)
    <=> v8974(VarCurr,bitIndex49) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_218,axiom,
    ! [VarCurr] :
      ( ~ v8971(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v8974(VarCurr,B)
          <=> v8973(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_221,axiom,
    ! [VarCurr] :
      ( v8971(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v8974(VarCurr,B)
          <=> v3154(VarCurr,B) ) ) ) ).

fof(addAssignment_2057,axiom,
    ! [VarCurr] :
      ( v8973(VarCurr,bitIndex49)
    <=> v3057(VarCurr,bitIndex539) ) ).

fof(addAssignment_2056,axiom,
    ! [VarCurr] :
      ( v8971(VarCurr)
    <=> v3064(VarCurr,bitIndex1) ) ).

fof(addAssignment_2055,axiom,
    ! [VarNext] :
      ( v3057(VarNext,bitIndex469)
    <=> v8937(VarNext,bitIndex49) ) ).

fof(addCaseBooleanConditionShiftedRanges1_19,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8938(VarNext)
       => ( ( v8937(VarNext,bitIndex69)
          <=> v3057(VarCurr,bitIndex489) )
          & ( v8937(VarNext,bitIndex68)
          <=> v3057(VarCurr,bitIndex488) )
          & ( v8937(VarNext,bitIndex67)
          <=> v3057(VarCurr,bitIndex487) )
          & ( v8937(VarNext,bitIndex66)
          <=> v3057(VarCurr,bitIndex486) )
          & ( v8937(VarNext,bitIndex65)
          <=> v3057(VarCurr,bitIndex485) )
          & ( v8937(VarNext,bitIndex64)
          <=> v3057(VarCurr,bitIndex484) )
          & ( v8937(VarNext,bitIndex63)
          <=> v3057(VarCurr,bitIndex483) )
          & ( v8937(VarNext,bitIndex62)
          <=> v3057(VarCurr,bitIndex482) )
          & ( v8937(VarNext,bitIndex61)
          <=> v3057(VarCurr,bitIndex481) )
          & ( v8937(VarNext,bitIndex60)
          <=> v3057(VarCurr,bitIndex480) )
          & ( v8937(VarNext,bitIndex59)
          <=> v3057(VarCurr,bitIndex479) )
          & ( v8937(VarNext,bitIndex58)
          <=> v3057(VarCurr,bitIndex478) )
          & ( v8937(VarNext,bitIndex57)
          <=> v3057(VarCurr,bitIndex477) )
          & ( v8937(VarNext,bitIndex56)
          <=> v3057(VarCurr,bitIndex476) )
          & ( v8937(VarNext,bitIndex55)
          <=> v3057(VarCurr,bitIndex475) )
          & ( v8937(VarNext,bitIndex54)
          <=> v3057(VarCurr,bitIndex474) )
          & ( v8937(VarNext,bitIndex53)
          <=> v3057(VarCurr,bitIndex473) )
          & ( v8937(VarNext,bitIndex52)
          <=> v3057(VarCurr,bitIndex472) )
          & ( v8937(VarNext,bitIndex51)
          <=> v3057(VarCurr,bitIndex471) )
          & ( v8937(VarNext,bitIndex50)
          <=> v3057(VarCurr,bitIndex470) )
          & ( v8937(VarNext,bitIndex49)
          <=> v3057(VarCurr,bitIndex469) )
          & ( v8937(VarNext,bitIndex48)
          <=> v3057(VarCurr,bitIndex468) )
          & ( v8937(VarNext,bitIndex47)
          <=> v3057(VarCurr,bitIndex467) )
          & ( v8937(VarNext,bitIndex46)
          <=> v3057(VarCurr,bitIndex466) )
          & ( v8937(VarNext,bitIndex45)
          <=> v3057(VarCurr,bitIndex465) )
          & ( v8937(VarNext,bitIndex44)
          <=> v3057(VarCurr,bitIndex464) )
          & ( v8937(VarNext,bitIndex43)
          <=> v3057(VarCurr,bitIndex463) )
          & ( v8937(VarNext,bitIndex42)
          <=> v3057(VarCurr,bitIndex462) )
          & ( v8937(VarNext,bitIndex41)
          <=> v3057(VarCurr,bitIndex461) )
          & ( v8937(VarNext,bitIndex40)
          <=> v3057(VarCurr,bitIndex460) )
          & ( v8937(VarNext,bitIndex39)
          <=> v3057(VarCurr,bitIndex459) )
          & ( v8937(VarNext,bitIndex38)
          <=> v3057(VarCurr,bitIndex458) )
          & ( v8937(VarNext,bitIndex37)
          <=> v3057(VarCurr,bitIndex457) )
          & ( v8937(VarNext,bitIndex36)
          <=> v3057(VarCurr,bitIndex456) )
          & ( v8937(VarNext,bitIndex35)
          <=> v3057(VarCurr,bitIndex455) )
          & ( v8937(VarNext,bitIndex34)
          <=> v3057(VarCurr,bitIndex454) )
          & ( v8937(VarNext,bitIndex33)
          <=> v3057(VarCurr,bitIndex453) )
          & ( v8937(VarNext,bitIndex32)
          <=> v3057(VarCurr,bitIndex452) )
          & ( v8937(VarNext,bitIndex31)
          <=> v3057(VarCurr,bitIndex451) )
          & ( v8937(VarNext,bitIndex30)
          <=> v3057(VarCurr,bitIndex450) )
          & ( v8937(VarNext,bitIndex29)
          <=> v3057(VarCurr,bitIndex449) )
          & ( v8937(VarNext,bitIndex28)
          <=> v3057(VarCurr,bitIndex448) )
          & ( v8937(VarNext,bitIndex27)
          <=> v3057(VarCurr,bitIndex447) )
          & ( v8937(VarNext,bitIndex26)
          <=> v3057(VarCurr,bitIndex446) )
          & ( v8937(VarNext,bitIndex25)
          <=> v3057(VarCurr,bitIndex445) )
          & ( v8937(VarNext,bitIndex24)
          <=> v3057(VarCurr,bitIndex444) )
          & ( v8937(VarNext,bitIndex23)
          <=> v3057(VarCurr,bitIndex443) )
          & ( v8937(VarNext,bitIndex22)
          <=> v3057(VarCurr,bitIndex442) )
          & ( v8937(VarNext,bitIndex21)
          <=> v3057(VarCurr,bitIndex441) )
          & ( v8937(VarNext,bitIndex20)
          <=> v3057(VarCurr,bitIndex440) )
          & ( v8937(VarNext,bitIndex19)
          <=> v3057(VarCurr,bitIndex439) )
          & ( v8937(VarNext,bitIndex18)
          <=> v3057(VarCurr,bitIndex438) )
          & ( v8937(VarNext,bitIndex17)
          <=> v3057(VarCurr,bitIndex437) )
          & ( v8937(VarNext,bitIndex16)
          <=> v3057(VarCurr,bitIndex436) )
          & ( v8937(VarNext,bitIndex15)
          <=> v3057(VarCurr,bitIndex435) )
          & ( v8937(VarNext,bitIndex14)
          <=> v3057(VarCurr,bitIndex434) )
          & ( v8937(VarNext,bitIndex13)
          <=> v3057(VarCurr,bitIndex433) )
          & ( v8937(VarNext,bitIndex12)
          <=> v3057(VarCurr,bitIndex432) )
          & ( v8937(VarNext,bitIndex11)
          <=> v3057(VarCurr,bitIndex431) )
          & ( v8937(VarNext,bitIndex10)
          <=> v3057(VarCurr,bitIndex430) )
          & ( v8937(VarNext,bitIndex9)
          <=> v3057(VarCurr,bitIndex429) )
          & ( v8937(VarNext,bitIndex8)
          <=> v3057(VarCurr,bitIndex428) )
          & ( v8937(VarNext,bitIndex7)
          <=> v3057(VarCurr,bitIndex427) )
          & ( v8937(VarNext,bitIndex6)
          <=> v3057(VarCurr,bitIndex426) )
          & ( v8937(VarNext,bitIndex5)
          <=> v3057(VarCurr,bitIndex425) )
          & ( v8937(VarNext,bitIndex4)
          <=> v3057(VarCurr,bitIndex424) )
          & ( v8937(VarNext,bitIndex3)
          <=> v3057(VarCurr,bitIndex423) )
          & ( v8937(VarNext,bitIndex2)
          <=> v3057(VarCurr,bitIndex422) )
          & ( v8937(VarNext,bitIndex1)
          <=> v3057(VarCurr,bitIndex421) )
          & ( v8937(VarNext,bitIndex0)
          <=> v3057(VarCurr,bitIndex420) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_152,axiom,
    ! [VarNext] :
      ( v8938(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v8937(VarNext,B)
          <=> v8964(VarNext,B) ) ) ) ).

fof(addAssignment_2054,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v8964(VarNext,B)
          <=> v8962(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_216,axiom,
    ! [VarCurr] :
      ( ~ v8855(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v8962(VarCurr,B)
          <=> v8965(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_205,axiom,
    ! [VarCurr] :
      ( v8855(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v8962(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_82,axiom,
    ! [VarCurr] :
      ( ( ~ v8951(VarCurr)
        & ~ v8953(VarCurr) )
     => ! [B] :
          ( range_69_0(B)
         => ( v8965(VarCurr,B)
          <=> v8930(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_215,axiom,
    ! [VarCurr] :
      ( v8953(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v8965(VarCurr,B)
          <=> v8923(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_12,axiom,
    ! [VarCurr] :
      ( v8951(VarCurr)
     => ( ( v8965(VarCurr,bitIndex69)
        <=> v3057(VarCurr,bitIndex419) )
        & ( v8965(VarCurr,bitIndex68)
        <=> v3057(VarCurr,bitIndex418) )
        & ( v8965(VarCurr,bitIndex67)
        <=> v3057(VarCurr,bitIndex417) )
        & ( v8965(VarCurr,bitIndex66)
        <=> v3057(VarCurr,bitIndex416) )
        & ( v8965(VarCurr,bitIndex65)
        <=> v3057(VarCurr,bitIndex415) )
        & ( v8965(VarCurr,bitIndex64)
        <=> v3057(VarCurr,bitIndex414) )
        & ( v8965(VarCurr,bitIndex63)
        <=> v3057(VarCurr,bitIndex413) )
        & ( v8965(VarCurr,bitIndex62)
        <=> v3057(VarCurr,bitIndex412) )
        & ( v8965(VarCurr,bitIndex61)
        <=> v3057(VarCurr,bitIndex411) )
        & ( v8965(VarCurr,bitIndex60)
        <=> v3057(VarCurr,bitIndex410) )
        & ( v8965(VarCurr,bitIndex59)
        <=> v3057(VarCurr,bitIndex409) )
        & ( v8965(VarCurr,bitIndex58)
        <=> v3057(VarCurr,bitIndex408) )
        & ( v8965(VarCurr,bitIndex57)
        <=> v3057(VarCurr,bitIndex407) )
        & ( v8965(VarCurr,bitIndex56)
        <=> v3057(VarCurr,bitIndex406) )
        & ( v8965(VarCurr,bitIndex55)
        <=> v3057(VarCurr,bitIndex405) )
        & ( v8965(VarCurr,bitIndex54)
        <=> v3057(VarCurr,bitIndex404) )
        & ( v8965(VarCurr,bitIndex53)
        <=> v3057(VarCurr,bitIndex403) )
        & ( v8965(VarCurr,bitIndex52)
        <=> v3057(VarCurr,bitIndex402) )
        & ( v8965(VarCurr,bitIndex51)
        <=> v3057(VarCurr,bitIndex401) )
        & ( v8965(VarCurr,bitIndex50)
        <=> v3057(VarCurr,bitIndex400) )
        & ( v8965(VarCurr,bitIndex49)
        <=> v3057(VarCurr,bitIndex399) )
        & ( v8965(VarCurr,bitIndex48)
        <=> v3057(VarCurr,bitIndex398) )
        & ( v8965(VarCurr,bitIndex47)
        <=> v3057(VarCurr,bitIndex397) )
        & ( v8965(VarCurr,bitIndex46)
        <=> v3057(VarCurr,bitIndex396) )
        & ( v8965(VarCurr,bitIndex45)
        <=> v3057(VarCurr,bitIndex395) )
        & ( v8965(VarCurr,bitIndex44)
        <=> v3057(VarCurr,bitIndex394) )
        & ( v8965(VarCurr,bitIndex43)
        <=> v3057(VarCurr,bitIndex393) )
        & ( v8965(VarCurr,bitIndex42)
        <=> v3057(VarCurr,bitIndex392) )
        & ( v8965(VarCurr,bitIndex41)
        <=> v3057(VarCurr,bitIndex391) )
        & ( v8965(VarCurr,bitIndex40)
        <=> v3057(VarCurr,bitIndex390) )
        & ( v8965(VarCurr,bitIndex39)
        <=> v3057(VarCurr,bitIndex389) )
        & ( v8965(VarCurr,bitIndex38)
        <=> v3057(VarCurr,bitIndex388) )
        & ( v8965(VarCurr,bitIndex37)
        <=> v3057(VarCurr,bitIndex387) )
        & ( v8965(VarCurr,bitIndex36)
        <=> v3057(VarCurr,bitIndex386) )
        & ( v8965(VarCurr,bitIndex35)
        <=> v3057(VarCurr,bitIndex385) )
        & ( v8965(VarCurr,bitIndex34)
        <=> v3057(VarCurr,bitIndex384) )
        & ( v8965(VarCurr,bitIndex33)
        <=> v3057(VarCurr,bitIndex383) )
        & ( v8965(VarCurr,bitIndex32)
        <=> v3057(VarCurr,bitIndex382) )
        & ( v8965(VarCurr,bitIndex31)
        <=> v3057(VarCurr,bitIndex381) )
        & ( v8965(VarCurr,bitIndex30)
        <=> v3057(VarCurr,bitIndex380) )
        & ( v8965(VarCurr,bitIndex29)
        <=> v3057(VarCurr,bitIndex379) )
        & ( v8965(VarCurr,bitIndex28)
        <=> v3057(VarCurr,bitIndex378) )
        & ( v8965(VarCurr,bitIndex27)
        <=> v3057(VarCurr,bitIndex377) )
        & ( v8965(VarCurr,bitIndex26)
        <=> v3057(VarCurr,bitIndex376) )
        & ( v8965(VarCurr,bitIndex25)
        <=> v3057(VarCurr,bitIndex375) )
        & ( v8965(VarCurr,bitIndex24)
        <=> v3057(VarCurr,bitIndex374) )
        & ( v8965(VarCurr,bitIndex23)
        <=> v3057(VarCurr,bitIndex373) )
        & ( v8965(VarCurr,bitIndex22)
        <=> v3057(VarCurr,bitIndex372) )
        & ( v8965(VarCurr,bitIndex21)
        <=> v3057(VarCurr,bitIndex371) )
        & ( v8965(VarCurr,bitIndex20)
        <=> v3057(VarCurr,bitIndex370) )
        & ( v8965(VarCurr,bitIndex19)
        <=> v3057(VarCurr,bitIndex369) )
        & ( v8965(VarCurr,bitIndex18)
        <=> v3057(VarCurr,bitIndex368) )
        & ( v8965(VarCurr,bitIndex17)
        <=> v3057(VarCurr,bitIndex367) )
        & ( v8965(VarCurr,bitIndex16)
        <=> v3057(VarCurr,bitIndex366) )
        & ( v8965(VarCurr,bitIndex15)
        <=> v3057(VarCurr,bitIndex365) )
        & ( v8965(VarCurr,bitIndex14)
        <=> v3057(VarCurr,bitIndex364) )
        & ( v8965(VarCurr,bitIndex13)
        <=> v3057(VarCurr,bitIndex363) )
        & ( v8965(VarCurr,bitIndex12)
        <=> v3057(VarCurr,bitIndex362) )
        & ( v8965(VarCurr,bitIndex11)
        <=> v3057(VarCurr,bitIndex361) )
        & ( v8965(VarCurr,bitIndex10)
        <=> v3057(VarCurr,bitIndex360) )
        & ( v8965(VarCurr,bitIndex9)
        <=> v3057(VarCurr,bitIndex359) )
        & ( v8965(VarCurr,bitIndex8)
        <=> v3057(VarCurr,bitIndex358) )
        & ( v8965(VarCurr,bitIndex7)
        <=> v3057(VarCurr,bitIndex357) )
        & ( v8965(VarCurr,bitIndex6)
        <=> v3057(VarCurr,bitIndex356) )
        & ( v8965(VarCurr,bitIndex5)
        <=> v3057(VarCurr,bitIndex355) )
        & ( v8965(VarCurr,bitIndex4)
        <=> v3057(VarCurr,bitIndex354) )
        & ( v8965(VarCurr,bitIndex3)
        <=> v3057(VarCurr,bitIndex353) )
        & ( v8965(VarCurr,bitIndex2)
        <=> v3057(VarCurr,bitIndex352) )
        & ( v8965(VarCurr,bitIndex1)
        <=> v3057(VarCurr,bitIndex351) )
        & ( v8965(VarCurr,bitIndex0)
        <=> v3057(VarCurr,bitIndex350) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1673,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8938(VarNext)
      <=> ( v8939(VarNext)
          & v8946(VarNext) ) ) ) ).

fof(addAssignment_2053,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8946(VarNext)
      <=> v8944(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1672,axiom,
    ! [VarCurr] :
      ( v8944(VarCurr)
    <=> ( v8947(VarCurr)
        & v8958(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1671,axiom,
    ! [VarCurr] :
      ( v8958(VarCurr)
    <=> ( v8959(VarCurr)
        | v8855(VarCurr) ) ) ).

fof(writeUnaryOperator_787,axiom,
    ! [VarCurr] :
      ( ~ v8959(VarCurr)
    <=> v8960(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_638,axiom,
    ! [VarCurr] :
      ( v8960(VarCurr)
    <=> ( ( v8961(VarCurr,bitIndex1)
        <=> $false )
        & ( v8961(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2052,axiom,
    ! [VarCurr] :
      ( v8961(VarCurr,bitIndex0)
    <=> v3009(VarCurr) ) ).

fof(addAssignment_2051,axiom,
    ! [VarCurr] :
      ( v8961(VarCurr,bitIndex1)
    <=> v46(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1670,axiom,
    ! [VarCurr] :
      ( v8947(VarCurr)
    <=> ( v8855(VarCurr)
        | v8948(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1669,axiom,
    ! [VarCurr] :
      ( v8948(VarCurr)
    <=> ( v8949(VarCurr)
        & v8957(VarCurr) ) ) ).

fof(writeUnaryOperator_786,axiom,
    ! [VarCurr] :
      ( ~ v8957(VarCurr)
    <=> v8855(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1668,axiom,
    ! [VarCurr] :
      ( v8949(VarCurr)
    <=> ( v8950(VarCurr)
        | v8955(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_637,axiom,
    ! [VarCurr] :
      ( v8955(VarCurr)
    <=> ( ( v8956(VarCurr,bitIndex1)
        <=> $true )
        & ( v8956(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2050,axiom,
    ! [VarCurr] :
      ( v8956(VarCurr,bitIndex0)
    <=> v3009(VarCurr) ) ).

fof(addAssignment_2049,axiom,
    ! [VarCurr] :
      ( v8956(VarCurr,bitIndex1)
    <=> v46(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1667,axiom,
    ! [VarCurr] :
      ( v8950(VarCurr)
    <=> ( v8951(VarCurr)
        | v8953(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_636,axiom,
    ! [VarCurr] :
      ( v8953(VarCurr)
    <=> ( ( v8954(VarCurr,bitIndex1)
        <=> $true )
        & ( v8954(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2048,axiom,
    ! [VarCurr] :
      ( v8954(VarCurr,bitIndex0)
    <=> v3009(VarCurr) ) ).

fof(addAssignment_2047,axiom,
    ! [VarCurr] :
      ( v8954(VarCurr,bitIndex1)
    <=> v46(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_635,axiom,
    ! [VarCurr] :
      ( v8951(VarCurr)
    <=> ( ( v8952(VarCurr,bitIndex1)
        <=> $false )
        & ( v8952(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2046,axiom,
    ! [VarCurr] :
      ( v8952(VarCurr,bitIndex0)
    <=> v3009(VarCurr) ) ).

fof(addAssignment_2045,axiom,
    ! [VarCurr] :
      ( v8952(VarCurr,bitIndex1)
    <=> v46(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1666,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8939(VarNext)
      <=> ( v8941(VarNext)
          & v3071(VarNext) ) ) ) ).

fof(writeUnaryOperator_785,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8941(VarNext)
      <=> v3086(VarNext) ) ) ).

fof(addAssignment_2044,axiom,
    ! [VarCurr] :
      ( v8930(VarCurr,bitIndex49)
    <=> v8935(VarCurr,bitIndex49) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_217,axiom,
    ! [VarCurr] :
      ( ~ v8932(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v8935(VarCurr,B)
          <=> v8934(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_220,axiom,
    ! [VarCurr] :
      ( v8932(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v8935(VarCurr,B)
          <=> v3154(VarCurr,B) ) ) ) ).

fof(addAssignment_2043,axiom,
    ! [VarCurr] :
      ( v8934(VarCurr,bitIndex49)
    <=> v3057(VarCurr,bitIndex399) ) ).

fof(addAssignment_2042,axiom,
    ! [VarCurr] :
      ( v8932(VarCurr)
    <=> v3064(VarCurr,bitIndex2) ) ).

fof(addAssignment_2041,axiom,
    ! [VarCurr] :
      ( v8923(VarCurr,bitIndex49)
    <=> v8928(VarCurr,bitIndex49) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_216,axiom,
    ! [VarCurr] :
      ( ~ v8925(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v8928(VarCurr,B)
          <=> v8927(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_219,axiom,
    ! [VarCurr] :
      ( v8925(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v8928(VarCurr,B)
          <=> v3154(VarCurr,B) ) ) ) ).

fof(addAssignment_2040,axiom,
    ! [VarCurr] :
      ( v8927(VarCurr,bitIndex49)
    <=> v3057(VarCurr,bitIndex469) ) ).

fof(addAssignment_2039,axiom,
    ! [VarCurr] :
      ( v8925(VarCurr)
    <=> v3064(VarCurr,bitIndex2) ) ).

fof(addAssignment_2038,axiom,
    ! [VarNext] :
      ( v3057(VarNext,bitIndex399)
    <=> v8891(VarNext,bitIndex49) ) ).

fof(addCaseBooleanConditionShiftedRanges1_18,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8892(VarNext)
       => ( ( v8891(VarNext,bitIndex69)
          <=> v3057(VarCurr,bitIndex419) )
          & ( v8891(VarNext,bitIndex68)
          <=> v3057(VarCurr,bitIndex418) )
          & ( v8891(VarNext,bitIndex67)
          <=> v3057(VarCurr,bitIndex417) )
          & ( v8891(VarNext,bitIndex66)
          <=> v3057(VarCurr,bitIndex416) )
          & ( v8891(VarNext,bitIndex65)
          <=> v3057(VarCurr,bitIndex415) )
          & ( v8891(VarNext,bitIndex64)
          <=> v3057(VarCurr,bitIndex414) )
          & ( v8891(VarNext,bitIndex63)
          <=> v3057(VarCurr,bitIndex413) )
          & ( v8891(VarNext,bitIndex62)
          <=> v3057(VarCurr,bitIndex412) )
          & ( v8891(VarNext,bitIndex61)
          <=> v3057(VarCurr,bitIndex411) )
          & ( v8891(VarNext,bitIndex60)
          <=> v3057(VarCurr,bitIndex410) )
          & ( v8891(VarNext,bitIndex59)
          <=> v3057(VarCurr,bitIndex409) )
          & ( v8891(VarNext,bitIndex58)
          <=> v3057(VarCurr,bitIndex408) )
          & ( v8891(VarNext,bitIndex57)
          <=> v3057(VarCurr,bitIndex407) )
          & ( v8891(VarNext,bitIndex56)
          <=> v3057(VarCurr,bitIndex406) )
          & ( v8891(VarNext,bitIndex55)
          <=> v3057(VarCurr,bitIndex405) )
          & ( v8891(VarNext,bitIndex54)
          <=> v3057(VarCurr,bitIndex404) )
          & ( v8891(VarNext,bitIndex53)
          <=> v3057(VarCurr,bitIndex403) )
          & ( v8891(VarNext,bitIndex52)
          <=> v3057(VarCurr,bitIndex402) )
          & ( v8891(VarNext,bitIndex51)
          <=> v3057(VarCurr,bitIndex401) )
          & ( v8891(VarNext,bitIndex50)
          <=> v3057(VarCurr,bitIndex400) )
          & ( v8891(VarNext,bitIndex49)
          <=> v3057(VarCurr,bitIndex399) )
          & ( v8891(VarNext,bitIndex48)
          <=> v3057(VarCurr,bitIndex398) )
          & ( v8891(VarNext,bitIndex47)
          <=> v3057(VarCurr,bitIndex397) )
          & ( v8891(VarNext,bitIndex46)
          <=> v3057(VarCurr,bitIndex396) )
          & ( v8891(VarNext,bitIndex45)
          <=> v3057(VarCurr,bitIndex395) )
          & ( v8891(VarNext,bitIndex44)
          <=> v3057(VarCurr,bitIndex394) )
          & ( v8891(VarNext,bitIndex43)
          <=> v3057(VarCurr,bitIndex393) )
          & ( v8891(VarNext,bitIndex42)
          <=> v3057(VarCurr,bitIndex392) )
          & ( v8891(VarNext,bitIndex41)
          <=> v3057(VarCurr,bitIndex391) )
          & ( v8891(VarNext,bitIndex40)
          <=> v3057(VarCurr,bitIndex390) )
          & ( v8891(VarNext,bitIndex39)
          <=> v3057(VarCurr,bitIndex389) )
          & ( v8891(VarNext,bitIndex38)
          <=> v3057(VarCurr,bitIndex388) )
          & ( v8891(VarNext,bitIndex37)
          <=> v3057(VarCurr,bitIndex387) )
          & ( v8891(VarNext,bitIndex36)
          <=> v3057(VarCurr,bitIndex386) )
          & ( v8891(VarNext,bitIndex35)
          <=> v3057(VarCurr,bitIndex385) )
          & ( v8891(VarNext,bitIndex34)
          <=> v3057(VarCurr,bitIndex384) )
          & ( v8891(VarNext,bitIndex33)
          <=> v3057(VarCurr,bitIndex383) )
          & ( v8891(VarNext,bitIndex32)
          <=> v3057(VarCurr,bitIndex382) )
          & ( v8891(VarNext,bitIndex31)
          <=> v3057(VarCurr,bitIndex381) )
          & ( v8891(VarNext,bitIndex30)
          <=> v3057(VarCurr,bitIndex380) )
          & ( v8891(VarNext,bitIndex29)
          <=> v3057(VarCurr,bitIndex379) )
          & ( v8891(VarNext,bitIndex28)
          <=> v3057(VarCurr,bitIndex378) )
          & ( v8891(VarNext,bitIndex27)
          <=> v3057(VarCurr,bitIndex377) )
          & ( v8891(VarNext,bitIndex26)
          <=> v3057(VarCurr,bitIndex376) )
          & ( v8891(VarNext,bitIndex25)
          <=> v3057(VarCurr,bitIndex375) )
          & ( v8891(VarNext,bitIndex24)
          <=> v3057(VarCurr,bitIndex374) )
          & ( v8891(VarNext,bitIndex23)
          <=> v3057(VarCurr,bitIndex373) )
          & ( v8891(VarNext,bitIndex22)
          <=> v3057(VarCurr,bitIndex372) )
          & ( v8891(VarNext,bitIndex21)
          <=> v3057(VarCurr,bitIndex371) )
          & ( v8891(VarNext,bitIndex20)
          <=> v3057(VarCurr,bitIndex370) )
          & ( v8891(VarNext,bitIndex19)
          <=> v3057(VarCurr,bitIndex369) )
          & ( v8891(VarNext,bitIndex18)
          <=> v3057(VarCurr,bitIndex368) )
          & ( v8891(VarNext,bitIndex17)
          <=> v3057(VarCurr,bitIndex367) )
          & ( v8891(VarNext,bitIndex16)
          <=> v3057(VarCurr,bitIndex366) )
          & ( v8891(VarNext,bitIndex15)
          <=> v3057(VarCurr,bitIndex365) )
          & ( v8891(VarNext,bitIndex14)
          <=> v3057(VarCurr,bitIndex364) )
          & ( v8891(VarNext,bitIndex13)
          <=> v3057(VarCurr,bitIndex363) )
          & ( v8891(VarNext,bitIndex12)
          <=> v3057(VarCurr,bitIndex362) )
          & ( v8891(VarNext,bitIndex11)
          <=> v3057(VarCurr,bitIndex361) )
          & ( v8891(VarNext,bitIndex10)
          <=> v3057(VarCurr,bitIndex360) )
          & ( v8891(VarNext,bitIndex9)
          <=> v3057(VarCurr,bitIndex359) )
          & ( v8891(VarNext,bitIndex8)
          <=> v3057(VarCurr,bitIndex358) )
          & ( v8891(VarNext,bitIndex7)
          <=> v3057(VarCurr,bitIndex357) )
          & ( v8891(VarNext,bitIndex6)
          <=> v3057(VarCurr,bitIndex356) )
          & ( v8891(VarNext,bitIndex5)
          <=> v3057(VarCurr,bitIndex355) )
          & ( v8891(VarNext,bitIndex4)
          <=> v3057(VarCurr,bitIndex354) )
          & ( v8891(VarNext,bitIndex3)
          <=> v3057(VarCurr,bitIndex353) )
          & ( v8891(VarNext,bitIndex2)
          <=> v3057(VarCurr,bitIndex352) )
          & ( v8891(VarNext,bitIndex1)
          <=> v3057(VarCurr,bitIndex351) )
          & ( v8891(VarNext,bitIndex0)
          <=> v3057(VarCurr,bitIndex350) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_151,axiom,
    ! [VarNext] :
      ( v8892(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v8891(VarNext,B)
          <=> v8918(VarNext,B) ) ) ) ).

fof(addAssignment_2037,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v8918(VarNext,B)
          <=> v8916(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_214,axiom,
    ! [VarCurr] :
      ( ~ v8855(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v8916(VarCurr,B)
          <=> v8919(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_204,axiom,
    ! [VarCurr] :
      ( v8855(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v8916(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_81,axiom,
    ! [VarCurr] :
      ( ( ~ v8905(VarCurr)
        & ~ v8907(VarCurr) )
     => ! [B] :
          ( range_69_0(B)
         => ( v8919(VarCurr,B)
          <=> v8884(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_213,axiom,
    ! [VarCurr] :
      ( v8907(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v8919(VarCurr,B)
          <=> v8877(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_11,axiom,
    ! [VarCurr] :
      ( v8905(VarCurr)
     => ( ( v8919(VarCurr,bitIndex69)
        <=> v3057(VarCurr,bitIndex349) )
        & ( v8919(VarCurr,bitIndex68)
        <=> v3057(VarCurr,bitIndex348) )
        & ( v8919(VarCurr,bitIndex67)
        <=> v3057(VarCurr,bitIndex347) )
        & ( v8919(VarCurr,bitIndex66)
        <=> v3057(VarCurr,bitIndex346) )
        & ( v8919(VarCurr,bitIndex65)
        <=> v3057(VarCurr,bitIndex345) )
        & ( v8919(VarCurr,bitIndex64)
        <=> v3057(VarCurr,bitIndex344) )
        & ( v8919(VarCurr,bitIndex63)
        <=> v3057(VarCurr,bitIndex343) )
        & ( v8919(VarCurr,bitIndex62)
        <=> v3057(VarCurr,bitIndex342) )
        & ( v8919(VarCurr,bitIndex61)
        <=> v3057(VarCurr,bitIndex341) )
        & ( v8919(VarCurr,bitIndex60)
        <=> v3057(VarCurr,bitIndex340) )
        & ( v8919(VarCurr,bitIndex59)
        <=> v3057(VarCurr,bitIndex339) )
        & ( v8919(VarCurr,bitIndex58)
        <=> v3057(VarCurr,bitIndex338) )
        & ( v8919(VarCurr,bitIndex57)
        <=> v3057(VarCurr,bitIndex337) )
        & ( v8919(VarCurr,bitIndex56)
        <=> v3057(VarCurr,bitIndex336) )
        & ( v8919(VarCurr,bitIndex55)
        <=> v3057(VarCurr,bitIndex335) )
        & ( v8919(VarCurr,bitIndex54)
        <=> v3057(VarCurr,bitIndex334) )
        & ( v8919(VarCurr,bitIndex53)
        <=> v3057(VarCurr,bitIndex333) )
        & ( v8919(VarCurr,bitIndex52)
        <=> v3057(VarCurr,bitIndex332) )
        & ( v8919(VarCurr,bitIndex51)
        <=> v3057(VarCurr,bitIndex331) )
        & ( v8919(VarCurr,bitIndex50)
        <=> v3057(VarCurr,bitIndex330) )
        & ( v8919(VarCurr,bitIndex49)
        <=> v3057(VarCurr,bitIndex329) )
        & ( v8919(VarCurr,bitIndex48)
        <=> v3057(VarCurr,bitIndex328) )
        & ( v8919(VarCurr,bitIndex47)
        <=> v3057(VarCurr,bitIndex327) )
        & ( v8919(VarCurr,bitIndex46)
        <=> v3057(VarCurr,bitIndex326) )
        & ( v8919(VarCurr,bitIndex45)
        <=> v3057(VarCurr,bitIndex325) )
        & ( v8919(VarCurr,bitIndex44)
        <=> v3057(VarCurr,bitIndex324) )
        & ( v8919(VarCurr,bitIndex43)
        <=> v3057(VarCurr,bitIndex323) )
        & ( v8919(VarCurr,bitIndex42)
        <=> v3057(VarCurr,bitIndex322) )
        & ( v8919(VarCurr,bitIndex41)
        <=> v3057(VarCurr,bitIndex321) )
        & ( v8919(VarCurr,bitIndex40)
        <=> v3057(VarCurr,bitIndex320) )
        & ( v8919(VarCurr,bitIndex39)
        <=> v3057(VarCurr,bitIndex319) )
        & ( v8919(VarCurr,bitIndex38)
        <=> v3057(VarCurr,bitIndex318) )
        & ( v8919(VarCurr,bitIndex37)
        <=> v3057(VarCurr,bitIndex317) )
        & ( v8919(VarCurr,bitIndex36)
        <=> v3057(VarCurr,bitIndex316) )
        & ( v8919(VarCurr,bitIndex35)
        <=> v3057(VarCurr,bitIndex315) )
        & ( v8919(VarCurr,bitIndex34)
        <=> v3057(VarCurr,bitIndex314) )
        & ( v8919(VarCurr,bitIndex33)
        <=> v3057(VarCurr,bitIndex313) )
        & ( v8919(VarCurr,bitIndex32)
        <=> v3057(VarCurr,bitIndex312) )
        & ( v8919(VarCurr,bitIndex31)
        <=> v3057(VarCurr,bitIndex311) )
        & ( v8919(VarCurr,bitIndex30)
        <=> v3057(VarCurr,bitIndex310) )
        & ( v8919(VarCurr,bitIndex29)
        <=> v3057(VarCurr,bitIndex309) )
        & ( v8919(VarCurr,bitIndex28)
        <=> v3057(VarCurr,bitIndex308) )
        & ( v8919(VarCurr,bitIndex27)
        <=> v3057(VarCurr,bitIndex307) )
        & ( v8919(VarCurr,bitIndex26)
        <=> v3057(VarCurr,bitIndex306) )
        & ( v8919(VarCurr,bitIndex25)
        <=> v3057(VarCurr,bitIndex305) )
        & ( v8919(VarCurr,bitIndex24)
        <=> v3057(VarCurr,bitIndex304) )
        & ( v8919(VarCurr,bitIndex23)
        <=> v3057(VarCurr,bitIndex303) )
        & ( v8919(VarCurr,bitIndex22)
        <=> v3057(VarCurr,bitIndex302) )
        & ( v8919(VarCurr,bitIndex21)
        <=> v3057(VarCurr,bitIndex301) )
        & ( v8919(VarCurr,bitIndex20)
        <=> v3057(VarCurr,bitIndex300) )
        & ( v8919(VarCurr,bitIndex19)
        <=> v3057(VarCurr,bitIndex299) )
        & ( v8919(VarCurr,bitIndex18)
        <=> v3057(VarCurr,bitIndex298) )
        & ( v8919(VarCurr,bitIndex17)
        <=> v3057(VarCurr,bitIndex297) )
        & ( v8919(VarCurr,bitIndex16)
        <=> v3057(VarCurr,bitIndex296) )
        & ( v8919(VarCurr,bitIndex15)
        <=> v3057(VarCurr,bitIndex295) )
        & ( v8919(VarCurr,bitIndex14)
        <=> v3057(VarCurr,bitIndex294) )
        & ( v8919(VarCurr,bitIndex13)
        <=> v3057(VarCurr,bitIndex293) )
        & ( v8919(VarCurr,bitIndex12)
        <=> v3057(VarCurr,bitIndex292) )
        & ( v8919(VarCurr,bitIndex11)
        <=> v3057(VarCurr,bitIndex291) )
        & ( v8919(VarCurr,bitIndex10)
        <=> v3057(VarCurr,bitIndex290) )
        & ( v8919(VarCurr,bitIndex9)
        <=> v3057(VarCurr,bitIndex289) )
        & ( v8919(VarCurr,bitIndex8)
        <=> v3057(VarCurr,bitIndex288) )
        & ( v8919(VarCurr,bitIndex7)
        <=> v3057(VarCurr,bitIndex287) )
        & ( v8919(VarCurr,bitIndex6)
        <=> v3057(VarCurr,bitIndex286) )
        & ( v8919(VarCurr,bitIndex5)
        <=> v3057(VarCurr,bitIndex285) )
        & ( v8919(VarCurr,bitIndex4)
        <=> v3057(VarCurr,bitIndex284) )
        & ( v8919(VarCurr,bitIndex3)
        <=> v3057(VarCurr,bitIndex283) )
        & ( v8919(VarCurr,bitIndex2)
        <=> v3057(VarCurr,bitIndex282) )
        & ( v8919(VarCurr,bitIndex1)
        <=> v3057(VarCurr,bitIndex281) )
        & ( v8919(VarCurr,bitIndex0)
        <=> v3057(VarCurr,bitIndex280) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1665,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8892(VarNext)
      <=> ( v8893(VarNext)
          & v8900(VarNext) ) ) ) ).

fof(addAssignment_2036,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8900(VarNext)
      <=> v8898(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1664,axiom,
    ! [VarCurr] :
      ( v8898(VarCurr)
    <=> ( v8901(VarCurr)
        & v8912(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1663,axiom,
    ! [VarCurr] :
      ( v8912(VarCurr)
    <=> ( v8913(VarCurr)
        | v8855(VarCurr) ) ) ).

fof(writeUnaryOperator_784,axiom,
    ! [VarCurr] :
      ( ~ v8913(VarCurr)
    <=> v8914(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_634,axiom,
    ! [VarCurr] :
      ( v8914(VarCurr)
    <=> ( ( v8915(VarCurr,bitIndex1)
        <=> $false )
        & ( v8915(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2035,axiom,
    ! [VarCurr] :
      ( v8915(VarCurr,bitIndex0)
    <=> v3009(VarCurr) ) ).

fof(addAssignment_2034,axiom,
    ! [VarCurr] :
      ( v8915(VarCurr,bitIndex1)
    <=> v46(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1662,axiom,
    ! [VarCurr] :
      ( v8901(VarCurr)
    <=> ( v8855(VarCurr)
        | v8902(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1661,axiom,
    ! [VarCurr] :
      ( v8902(VarCurr)
    <=> ( v8903(VarCurr)
        & v8911(VarCurr) ) ) ).

fof(writeUnaryOperator_783,axiom,
    ! [VarCurr] :
      ( ~ v8911(VarCurr)
    <=> v8855(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1660,axiom,
    ! [VarCurr] :
      ( v8903(VarCurr)
    <=> ( v8904(VarCurr)
        | v8909(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_633,axiom,
    ! [VarCurr] :
      ( v8909(VarCurr)
    <=> ( ( v8910(VarCurr,bitIndex1)
        <=> $true )
        & ( v8910(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2033,axiom,
    ! [VarCurr] :
      ( v8910(VarCurr,bitIndex0)
    <=> v3009(VarCurr) ) ).

fof(addAssignment_2032,axiom,
    ! [VarCurr] :
      ( v8910(VarCurr,bitIndex1)
    <=> v46(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1659,axiom,
    ! [VarCurr] :
      ( v8904(VarCurr)
    <=> ( v8905(VarCurr)
        | v8907(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_632,axiom,
    ! [VarCurr] :
      ( v8907(VarCurr)
    <=> ( ( v8908(VarCurr,bitIndex1)
        <=> $true )
        & ( v8908(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2031,axiom,
    ! [VarCurr] :
      ( v8908(VarCurr,bitIndex0)
    <=> v3009(VarCurr) ) ).

fof(addAssignment_2030,axiom,
    ! [VarCurr] :
      ( v8908(VarCurr,bitIndex1)
    <=> v46(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_631,axiom,
    ! [VarCurr] :
      ( v8905(VarCurr)
    <=> ( ( v8906(VarCurr,bitIndex1)
        <=> $false )
        & ( v8906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2029,axiom,
    ! [VarCurr] :
      ( v8906(VarCurr,bitIndex0)
    <=> v3009(VarCurr) ) ).

fof(addAssignment_2028,axiom,
    ! [VarCurr] :
      ( v8906(VarCurr,bitIndex1)
    <=> v46(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1658,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8893(VarNext)
      <=> ( v8895(VarNext)
          & v3071(VarNext) ) ) ) ).

fof(writeUnaryOperator_782,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8895(VarNext)
      <=> v3086(VarNext) ) ) ).

fof(addAssignment_2027,axiom,
    ! [VarCurr] :
      ( v8884(VarCurr,bitIndex49)
    <=> v8889(VarCurr,bitIndex49) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_215,axiom,
    ! [VarCurr] :
      ( ~ v8886(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v8889(VarCurr,B)
          <=> v8888(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_218,axiom,
    ! [VarCurr] :
      ( v8886(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v8889(VarCurr,B)
          <=> v3154(VarCurr,B) ) ) ) ).

fof(addAssignment_2026,axiom,
    ! [VarCurr] :
      ( v8888(VarCurr,bitIndex49)
    <=> v3057(VarCurr,bitIndex329) ) ).

fof(addAssignment_2025,axiom,
    ! [VarCurr] :
      ( v8886(VarCurr)
    <=> v3064(VarCurr,bitIndex3) ) ).

fof(addAssignment_2024,axiom,
    ! [VarCurr] :
      ( v8877(VarCurr,bitIndex49)
    <=> v8882(VarCurr,bitIndex49) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_214,axiom,
    ! [VarCurr] :
      ( ~ v8879(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v8882(VarCurr,B)
          <=> v8881(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_217,axiom,
    ! [VarCurr] :
      ( v8879(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v8882(VarCurr,B)
          <=> v3154(VarCurr,B) ) ) ) ).

fof(addAssignment_2023,axiom,
    ! [VarCurr] :
      ( v8881(VarCurr,bitIndex49)
    <=> v3057(VarCurr,bitIndex399) ) ).

fof(addAssignment_2022,axiom,
    ! [VarCurr] :
      ( v8879(VarCurr)
    <=> v3064(VarCurr,bitIndex3) ) ).

fof(addAssignment_2021,axiom,
    ! [VarNext] :
      ( v3057(VarNext,bitIndex329)
    <=> v8844(VarNext,bitIndex49) ) ).

fof(addCaseBooleanConditionShiftedRanges1_17,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8845(VarNext)
       => ( ( v8844(VarNext,bitIndex69)
          <=> v3057(VarCurr,bitIndex349) )
          & ( v8844(VarNext,bitIndex68)
          <=> v3057(VarCurr,bitIndex348) )
          & ( v8844(VarNext,bitIndex67)
          <=> v3057(VarCurr,bitIndex347) )
          & ( v8844(VarNext,bitIndex66)
          <=> v3057(VarCurr,bitIndex346) )
          & ( v8844(VarNext,bitIndex65)
          <=> v3057(VarCurr,bitIndex345) )
          & ( v8844(VarNext,bitIndex64)
          <=> v3057(VarCurr,bitIndex344) )
          & ( v8844(VarNext,bitIndex63)
          <=> v3057(VarCurr,bitIndex343) )
          & ( v8844(VarNext,bitIndex62)
          <=> v3057(VarCurr,bitIndex342) )
          & ( v8844(VarNext,bitIndex61)
          <=> v3057(VarCurr,bitIndex341) )
          & ( v8844(VarNext,bitIndex60)
          <=> v3057(VarCurr,bitIndex340) )
          & ( v8844(VarNext,bitIndex59)
          <=> v3057(VarCurr,bitIndex339) )
          & ( v8844(VarNext,bitIndex58)
          <=> v3057(VarCurr,bitIndex338) )
          & ( v8844(VarNext,bitIndex57)
          <=> v3057(VarCurr,bitIndex337) )
          & ( v8844(VarNext,bitIndex56)
          <=> v3057(VarCurr,bitIndex336) )
          & ( v8844(VarNext,bitIndex55)
          <=> v3057(VarCurr,bitIndex335) )
          & ( v8844(VarNext,bitIndex54)
          <=> v3057(VarCurr,bitIndex334) )
          & ( v8844(VarNext,bitIndex53)
          <=> v3057(VarCurr,bitIndex333) )
          & ( v8844(VarNext,bitIndex52)
          <=> v3057(VarCurr,bitIndex332) )
          & ( v8844(VarNext,bitIndex51)
          <=> v3057(VarCurr,bitIndex331) )
          & ( v8844(VarNext,bitIndex50)
          <=> v3057(VarCurr,bitIndex330) )
          & ( v8844(VarNext,bitIndex49)
          <=> v3057(VarCurr,bitIndex329) )
          & ( v8844(VarNext,bitIndex48)
          <=> v3057(VarCurr,bitIndex328) )
          & ( v8844(VarNext,bitIndex47)
          <=> v3057(VarCurr,bitIndex327) )
          & ( v8844(VarNext,bitIndex46)
          <=> v3057(VarCurr,bitIndex326) )
          & ( v8844(VarNext,bitIndex45)
          <=> v3057(VarCurr,bitIndex325) )
          & ( v8844(VarNext,bitIndex44)
          <=> v3057(VarCurr,bitIndex324) )
          & ( v8844(VarNext,bitIndex43)
          <=> v3057(VarCurr,bitIndex323) )
          & ( v8844(VarNext,bitIndex42)
          <=> v3057(VarCurr,bitIndex322) )
          & ( v8844(VarNext,bitIndex41)
          <=> v3057(VarCurr,bitIndex321) )
          & ( v8844(VarNext,bitIndex40)
          <=> v3057(VarCurr,bitIndex320) )
          & ( v8844(VarNext,bitIndex39)
          <=> v3057(VarCurr,bitIndex319) )
          & ( v8844(VarNext,bitIndex38)
          <=> v3057(VarCurr,bitIndex318) )
          & ( v8844(VarNext,bitIndex37)
          <=> v3057(VarCurr,bitIndex317) )
          & ( v8844(VarNext,bitIndex36)
          <=> v3057(VarCurr,bitIndex316) )
          & ( v8844(VarNext,bitIndex35)
          <=> v3057(VarCurr,bitIndex315) )
          & ( v8844(VarNext,bitIndex34)
          <=> v3057(VarCurr,bitIndex314) )
          & ( v8844(VarNext,bitIndex33)
          <=> v3057(VarCurr,bitIndex313) )
          & ( v8844(VarNext,bitIndex32)
          <=> v3057(VarCurr,bitIndex312) )
          & ( v8844(VarNext,bitIndex31)
          <=> v3057(VarCurr,bitIndex311) )
          & ( v8844(VarNext,bitIndex30)
          <=> v3057(VarCurr,bitIndex310) )
          & ( v8844(VarNext,bitIndex29)
          <=> v3057(VarCurr,bitIndex309) )
          & ( v8844(VarNext,bitIndex28)
          <=> v3057(VarCurr,bitIndex308) )
          & ( v8844(VarNext,bitIndex27)
          <=> v3057(VarCurr,bitIndex307) )
          & ( v8844(VarNext,bitIndex26)
          <=> v3057(VarCurr,bitIndex306) )
          & ( v8844(VarNext,bitIndex25)
          <=> v3057(VarCurr,bitIndex305) )
          & ( v8844(VarNext,bitIndex24)
          <=> v3057(VarCurr,bitIndex304) )
          & ( v8844(VarNext,bitIndex23)
          <=> v3057(VarCurr,bitIndex303) )
          & ( v8844(VarNext,bitIndex22)
          <=> v3057(VarCurr,bitIndex302) )
          & ( v8844(VarNext,bitIndex21)
          <=> v3057(VarCurr,bitIndex301) )
          & ( v8844(VarNext,bitIndex20)
          <=> v3057(VarCurr,bitIndex300) )
          & ( v8844(VarNext,bitIndex19)
          <=> v3057(VarCurr,bitIndex299) )
          & ( v8844(VarNext,bitIndex18)
          <=> v3057(VarCurr,bitIndex298) )
          & ( v8844(VarNext,bitIndex17)
          <=> v3057(VarCurr,bitIndex297) )
          & ( v8844(VarNext,bitIndex16)
          <=> v3057(VarCurr,bitIndex296) )
          & ( v8844(VarNext,bitIndex15)
          <=> v3057(VarCurr,bitIndex295) )
          & ( v8844(VarNext,bitIndex14)
          <=> v3057(VarCurr,bitIndex294) )
          & ( v8844(VarNext,bitIndex13)
          <=> v3057(VarCurr,bitIndex293) )
          & ( v8844(VarNext,bitIndex12)
          <=> v3057(VarCurr,bitIndex292) )
          & ( v8844(VarNext,bitIndex11)
          <=> v3057(VarCurr,bitIndex291) )
          & ( v8844(VarNext,bitIndex10)
          <=> v3057(VarCurr,bitIndex290) )
          & ( v8844(VarNext,bitIndex9)
          <=> v3057(VarCurr,bitIndex289) )
          & ( v8844(VarNext,bitIndex8)
          <=> v3057(VarCurr,bitIndex288) )
          & ( v8844(VarNext,bitIndex7)
          <=> v3057(VarCurr,bitIndex287) )
          & ( v8844(VarNext,bitIndex6)
          <=> v3057(VarCurr,bitIndex286) )
          & ( v8844(VarNext,bitIndex5)
          <=> v3057(VarCurr,bitIndex285) )
          & ( v8844(VarNext,bitIndex4)
          <=> v3057(VarCurr,bitIndex284) )
          & ( v8844(VarNext,bitIndex3)
          <=> v3057(VarCurr,bitIndex283) )
          & ( v8844(VarNext,bitIndex2)
          <=> v3057(VarCurr,bitIndex282) )
          & ( v8844(VarNext,bitIndex1)
          <=> v3057(VarCurr,bitIndex281) )
          & ( v8844(VarNext,bitIndex0)
          <=> v3057(VarCurr,bitIndex280) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_150,axiom,
    ! [VarNext] :
      ( v8845(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v8844(VarNext,B)
          <=> v8872(VarNext,B) ) ) ) ).

fof(addAssignment_2020,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v8872(VarNext,B)
          <=> v8870(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_212,axiom,
    ! [VarCurr] :
      ( ~ v8855(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v8870(VarCurr,B)
          <=> v8873(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_203,axiom,
    ! [VarCurr] :
      ( v8855(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v8870(VarCurr,B)
          <=> $false ) ) ) ).

fof(bitBlastConstant_1026,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex69) ).

fof(bitBlastConstant_1025,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex68) ).

fof(bitBlastConstant_1024,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex67) ).

fof(bitBlastConstant_1023,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex66) ).

fof(bitBlastConstant_1022,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex65) ).

fof(bitBlastConstant_1021,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex64) ).

fof(bitBlastConstant_1020,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex63) ).

fof(bitBlastConstant_1019,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex62) ).

fof(bitBlastConstant_1018,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex61) ).

fof(bitBlastConstant_1017,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex60) ).

fof(bitBlastConstant_1016,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex59) ).

fof(bitBlastConstant_1015,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex58) ).

fof(bitBlastConstant_1014,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex57) ).

fof(bitBlastConstant_1013,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex56) ).

fof(bitBlastConstant_1012,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex55) ).

fof(bitBlastConstant_1011,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex54) ).

fof(bitBlastConstant_1010,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex53) ).

fof(bitBlastConstant_1009,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex52) ).

fof(bitBlastConstant_1008,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex51) ).

fof(bitBlastConstant_1007,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex50) ).

fof(bitBlastConstant_1006,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex49) ).

fof(bitBlastConstant_1005,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex48) ).

fof(bitBlastConstant_1004,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex47) ).

fof(bitBlastConstant_1003,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex46) ).

fof(bitBlastConstant_1002,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex45) ).

fof(bitBlastConstant_1001,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex44) ).

fof(bitBlastConstant_1000,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex43) ).

fof(bitBlastConstant_999,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex42) ).

fof(bitBlastConstant_998,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex41) ).

fof(bitBlastConstant_997,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex40) ).

fof(bitBlastConstant_996,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex39) ).

fof(bitBlastConstant_995,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex38) ).

fof(bitBlastConstant_994,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex37) ).

fof(bitBlastConstant_993,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex36) ).

fof(bitBlastConstant_992,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex35) ).

fof(bitBlastConstant_991,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex34) ).

fof(bitBlastConstant_990,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex33) ).

fof(bitBlastConstant_989,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex32) ).

fof(bitBlastConstant_988,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex31) ).

fof(bitBlastConstant_987,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex30) ).

fof(bitBlastConstant_986,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex29) ).

fof(bitBlastConstant_985,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex28) ).

fof(bitBlastConstant_984,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex27) ).

fof(bitBlastConstant_983,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex26) ).

fof(bitBlastConstant_982,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex25) ).

fof(bitBlastConstant_981,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex24) ).

fof(bitBlastConstant_980,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex23) ).

fof(bitBlastConstant_979,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex22) ).

fof(bitBlastConstant_978,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex21) ).

fof(bitBlastConstant_977,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex20) ).

fof(bitBlastConstant_976,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex19) ).

fof(bitBlastConstant_975,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex18) ).

fof(bitBlastConstant_974,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex17) ).

fof(bitBlastConstant_973,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex16) ).

fof(bitBlastConstant_972,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex15) ).

fof(bitBlastConstant_971,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex14) ).

fof(bitBlastConstant_970,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex13) ).

fof(bitBlastConstant_969,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex12) ).

fof(bitBlastConstant_968,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex11) ).

fof(bitBlastConstant_967,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex10) ).

fof(bitBlastConstant_966,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex9) ).

fof(bitBlastConstant_965,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex8) ).

fof(bitBlastConstant_964,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex7) ).

fof(bitBlastConstant_963,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex6) ).

fof(bitBlastConstant_962,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex5) ).

fof(bitBlastConstant_961,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex4) ).

fof(bitBlastConstant_960,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex3) ).

fof(bitBlastConstant_959,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex2) ).

fof(bitBlastConstant_958,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex1) ).

fof(bitBlastConstant_957,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges2_80,axiom,
    ! [VarCurr] :
      ( ( ~ v8859(VarCurr)
        & ~ v8861(VarCurr) )
     => ! [B] :
          ( range_69_0(B)
         => ( v8873(VarCurr,B)
          <=> v8837(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_211,axiom,
    ! [VarCurr] :
      ( v8861(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v8873(VarCurr,B)
          <=> v3060(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_10,axiom,
    ! [VarCurr] :
      ( v8859(VarCurr)
     => ( ( v8873(VarCurr,bitIndex69)
        <=> v3057(VarCurr,bitIndex279) )
        & ( v8873(VarCurr,bitIndex68)
        <=> v3057(VarCurr,bitIndex278) )
        & ( v8873(VarCurr,bitIndex67)
        <=> v3057(VarCurr,bitIndex277) )
        & ( v8873(VarCurr,bitIndex66)
        <=> v3057(VarCurr,bitIndex276) )
        & ( v8873(VarCurr,bitIndex65)
        <=> v3057(VarCurr,bitIndex275) )
        & ( v8873(VarCurr,bitIndex64)
        <=> v3057(VarCurr,bitIndex274) )
        & ( v8873(VarCurr,bitIndex63)
        <=> v3057(VarCurr,bitIndex273) )
        & ( v8873(VarCurr,bitIndex62)
        <=> v3057(VarCurr,bitIndex272) )
        & ( v8873(VarCurr,bitIndex61)
        <=> v3057(VarCurr,bitIndex271) )
        & ( v8873(VarCurr,bitIndex60)
        <=> v3057(VarCurr,bitIndex270) )
        & ( v8873(VarCurr,bitIndex59)
        <=> v3057(VarCurr,bitIndex269) )
        & ( v8873(VarCurr,bitIndex58)
        <=> v3057(VarCurr,bitIndex268) )
        & ( v8873(VarCurr,bitIndex57)
        <=> v3057(VarCurr,bitIndex267) )
        & ( v8873(VarCurr,bitIndex56)
        <=> v3057(VarCurr,bitIndex266) )
        & ( v8873(VarCurr,bitIndex55)
        <=> v3057(VarCurr,bitIndex265) )
        & ( v8873(VarCurr,bitIndex54)
        <=> v3057(VarCurr,bitIndex264) )
        & ( v8873(VarCurr,bitIndex53)
        <=> v3057(VarCurr,bitIndex263) )
        & ( v8873(VarCurr,bitIndex52)
        <=> v3057(VarCurr,bitIndex262) )
        & ( v8873(VarCurr,bitIndex51)
        <=> v3057(VarCurr,bitIndex261) )
        & ( v8873(VarCurr,bitIndex50)
        <=> v3057(VarCurr,bitIndex260) )
        & ( v8873(VarCurr,bitIndex49)
        <=> v3057(VarCurr,bitIndex259) )
        & ( v8873(VarCurr,bitIndex48)
        <=> v3057(VarCurr,bitIndex258) )
        & ( v8873(VarCurr,bitIndex47)
        <=> v3057(VarCurr,bitIndex257) )
        & ( v8873(VarCurr,bitIndex46)
        <=> v3057(VarCurr,bitIndex256) )
        & ( v8873(VarCurr,bitIndex45)
        <=> v3057(VarCurr,bitIndex255) )
        & ( v8873(VarCurr,bitIndex44)
        <=> v3057(VarCurr,bitIndex254) )
        & ( v8873(VarCurr,bitIndex43)
        <=> v3057(VarCurr,bitIndex253) )
        & ( v8873(VarCurr,bitIndex42)
        <=> v3057(VarCurr,bitIndex252) )
        & ( v8873(VarCurr,bitIndex41)
        <=> v3057(VarCurr,bitIndex251) )
        & ( v8873(VarCurr,bitIndex40)
        <=> v3057(VarCurr,bitIndex250) )
        & ( v8873(VarCurr,bitIndex39)
        <=> v3057(VarCurr,bitIndex249) )
        & ( v8873(VarCurr,bitIndex38)
        <=> v3057(VarCurr,bitIndex248) )
        & ( v8873(VarCurr,bitIndex37)
        <=> v3057(VarCurr,bitIndex247) )
        & ( v8873(VarCurr,bitIndex36)
        <=> v3057(VarCurr,bitIndex246) )
        & ( v8873(VarCurr,bitIndex35)
        <=> v3057(VarCurr,bitIndex245) )
        & ( v8873(VarCurr,bitIndex34)
        <=> v3057(VarCurr,bitIndex244) )
        & ( v8873(VarCurr,bitIndex33)
        <=> v3057(VarCurr,bitIndex243) )
        & ( v8873(VarCurr,bitIndex32)
        <=> v3057(VarCurr,bitIndex242) )
        & ( v8873(VarCurr,bitIndex31)
        <=> v3057(VarCurr,bitIndex241) )
        & ( v8873(VarCurr,bitIndex30)
        <=> v3057(VarCurr,bitIndex240) )
        & ( v8873(VarCurr,bitIndex29)
        <=> v3057(VarCurr,bitIndex239) )
        & ( v8873(VarCurr,bitIndex28)
        <=> v3057(VarCurr,bitIndex238) )
        & ( v8873(VarCurr,bitIndex27)
        <=> v3057(VarCurr,bitIndex237) )
        & ( v8873(VarCurr,bitIndex26)
        <=> v3057(VarCurr,bitIndex236) )
        & ( v8873(VarCurr,bitIndex25)
        <=> v3057(VarCurr,bitIndex235) )
        & ( v8873(VarCurr,bitIndex24)
        <=> v3057(VarCurr,bitIndex234) )
        & ( v8873(VarCurr,bitIndex23)
        <=> v3057(VarCurr,bitIndex233) )
        & ( v8873(VarCurr,bitIndex22)
        <=> v3057(VarCurr,bitIndex232) )
        & ( v8873(VarCurr,bitIndex21)
        <=> v3057(VarCurr,bitIndex231) )
        & ( v8873(VarCurr,bitIndex20)
        <=> v3057(VarCurr,bitIndex230) )
        & ( v8873(VarCurr,bitIndex19)
        <=> v3057(VarCurr,bitIndex229) )
        & ( v8873(VarCurr,bitIndex18)
        <=> v3057(VarCurr,bitIndex228) )
        & ( v8873(VarCurr,bitIndex17)
        <=> v3057(VarCurr,bitIndex227) )
        & ( v8873(VarCurr,bitIndex16)
        <=> v3057(VarCurr,bitIndex226) )
        & ( v8873(VarCurr,bitIndex15)
        <=> v3057(VarCurr,bitIndex225) )
        & ( v8873(VarCurr,bitIndex14)
        <=> v3057(VarCurr,bitIndex224) )
        & ( v8873(VarCurr,bitIndex13)
        <=> v3057(VarCurr,bitIndex223) )
        & ( v8873(VarCurr,bitIndex12)
        <=> v3057(VarCurr,bitIndex222) )
        & ( v8873(VarCurr,bitIndex11)
        <=> v3057(VarCurr,bitIndex221) )
        & ( v8873(VarCurr,bitIndex10)
        <=> v3057(VarCurr,bitIndex220) )
        & ( v8873(VarCurr,bitIndex9)
        <=> v3057(VarCurr,bitIndex219) )
        & ( v8873(VarCurr,bitIndex8)
        <=> v3057(VarCurr,bitIndex218) )
        & ( v8873(VarCurr,bitIndex7)
        <=> v3057(VarCurr,bitIndex217) )
        & ( v8873(VarCurr,bitIndex6)
        <=> v3057(VarCurr,bitIndex216) )
        & ( v8873(VarCurr,bitIndex5)
        <=> v3057(VarCurr,bitIndex215) )
        & ( v8873(VarCurr,bitIndex4)
        <=> v3057(VarCurr,bitIndex214) )
        & ( v8873(VarCurr,bitIndex3)
        <=> v3057(VarCurr,bitIndex213) )
        & ( v8873(VarCurr,bitIndex2)
        <=> v3057(VarCurr,bitIndex212) )
        & ( v8873(VarCurr,bitIndex1)
        <=> v3057(VarCurr,bitIndex211) )
        & ( v8873(VarCurr,bitIndex0)
        <=> v3057(VarCurr,bitIndex210) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1657,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8845(VarNext)
      <=> ( v8846(VarNext)
          & v8853(VarNext) ) ) ) ).

fof(addAssignment_2019,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8853(VarNext)
      <=> v8851(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1656,axiom,
    ! [VarCurr] :
      ( v8851(VarCurr)
    <=> ( v8854(VarCurr)
        & v8866(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1655,axiom,
    ! [VarCurr] :
      ( v8866(VarCurr)
    <=> ( v8867(VarCurr)
        | v8855(VarCurr) ) ) ).

fof(writeUnaryOperator_781,axiom,
    ! [VarCurr] :
      ( ~ v8867(VarCurr)
    <=> v8868(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_630,axiom,
    ! [VarCurr] :
      ( v8868(VarCurr)
    <=> ( ( v8869(VarCurr,bitIndex1)
        <=> $false )
        & ( v8869(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2018,axiom,
    ! [VarCurr] :
      ( v8869(VarCurr,bitIndex0)
    <=> v3009(VarCurr) ) ).

fof(addAssignment_2017,axiom,
    ! [VarCurr] :
      ( v8869(VarCurr,bitIndex1)
    <=> v46(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1654,axiom,
    ! [VarCurr] :
      ( v8854(VarCurr)
    <=> ( v8855(VarCurr)
        | v8856(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1653,axiom,
    ! [VarCurr] :
      ( v8856(VarCurr)
    <=> ( v8857(VarCurr)
        & v8865(VarCurr) ) ) ).

fof(writeUnaryOperator_780,axiom,
    ! [VarCurr] :
      ( ~ v8865(VarCurr)
    <=> v8855(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1652,axiom,
    ! [VarCurr] :
      ( v8857(VarCurr)
    <=> ( v8858(VarCurr)
        | v8863(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_629,axiom,
    ! [VarCurr] :
      ( v8863(VarCurr)
    <=> ( ( v8864(VarCurr,bitIndex1)
        <=> $true )
        & ( v8864(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2016,axiom,
    ! [VarCurr] :
      ( v8864(VarCurr,bitIndex0)
    <=> v3009(VarCurr) ) ).

fof(addAssignment_2015,axiom,
    ! [VarCurr] :
      ( v8864(VarCurr,bitIndex1)
    <=> v46(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1651,axiom,
    ! [VarCurr] :
      ( v8858(VarCurr)
    <=> ( v8859(VarCurr)
        | v8861(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_628,axiom,
    ! [VarCurr] :
      ( v8861(VarCurr)
    <=> ( ( v8862(VarCurr,bitIndex1)
        <=> $true )
        & ( v8862(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2014,axiom,
    ! [VarCurr] :
      ( v8862(VarCurr,bitIndex0)
    <=> v3009(VarCurr) ) ).

fof(addAssignment_2013,axiom,
    ! [VarCurr] :
      ( v8862(VarCurr,bitIndex1)
    <=> v46(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_627,axiom,
    ! [VarCurr] :
      ( v8859(VarCurr)
    <=> ( ( v8860(VarCurr,bitIndex1)
        <=> $false )
        & ( v8860(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2012,axiom,
    ! [VarCurr] :
      ( v8860(VarCurr,bitIndex0)
    <=> v3009(VarCurr) ) ).

fof(addAssignment_2011,axiom,
    ! [VarCurr] :
      ( v8860(VarCurr,bitIndex1)
    <=> v46(VarCurr) ) ).

fof(writeUnaryOperator_779,axiom,
    ! [VarCurr] :
      ( ~ v8855(VarCurr)
    <=> v44(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1650,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8846(VarNext)
      <=> ( v8847(VarNext)
          & v3071(VarNext) ) ) ) ).

fof(writeUnaryOperator_778,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8847(VarNext)
      <=> v3086(VarNext) ) ) ).

fof(addAssignment_2010,axiom,
    ! [VarCurr] :
      ( v8837(VarCurr,bitIndex49)
    <=> v8842(VarCurr,bitIndex49) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_213,axiom,
    ! [VarCurr] :
      ( ~ v8839(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v8842(VarCurr,B)
          <=> v8841(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_216,axiom,
    ! [VarCurr] :
      ( v8839(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v8842(VarCurr,B)
          <=> v3154(VarCurr,B) ) ) ) ).

fof(addAssignment_2009,axiom,
    ! [VarCurr] :
      ( v8841(VarCurr,bitIndex49)
    <=> v3057(VarCurr,bitIndex259) ) ).

fof(addAssignment_2008,axiom,
    ! [VarCurr] :
      ( v8839(VarCurr)
    <=> v3064(VarCurr,bitIndex4) ) ).

fof(addAssignment_2007,axiom,
    ! [VarCurr] :
      ( v3060(VarCurr,bitIndex49)
    <=> v8835(VarCurr,bitIndex49) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_212,axiom,
    ! [VarCurr] :
      ( ~ v3062(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v8835(VarCurr,B)
          <=> v8824(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_215,axiom,
    ! [VarCurr] :
      ( v3062(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v8835(VarCurr,B)
          <=> v3154(VarCurr,B) ) ) ) ).

fof(range_axiom_51,axiom,
    ! [B] :
      ( range_69_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B
        | bitIndex30 = B
        | bitIndex31 = B
        | bitIndex32 = B
        | bitIndex33 = B
        | bitIndex34 = B
        | bitIndex35 = B
        | bitIndex36 = B
        | bitIndex37 = B
        | bitIndex38 = B
        | bitIndex39 = B
        | bitIndex40 = B
        | bitIndex41 = B
        | bitIndex42 = B
        | bitIndex43 = B
        | bitIndex44 = B
        | bitIndex45 = B
        | bitIndex46 = B
        | bitIndex47 = B
        | bitIndex48 = B
        | bitIndex49 = B
        | bitIndex50 = B
        | bitIndex51 = B
        | bitIndex52 = B
        | bitIndex53 = B
        | bitIndex54 = B
        | bitIndex55 = B
        | bitIndex56 = B
        | bitIndex57 = B
        | bitIndex58 = B
        | bitIndex59 = B
        | bitIndex60 = B
        | bitIndex61 = B
        | bitIndex62 = B
        | bitIndex63 = B
        | bitIndex64 = B
        | bitIndex65 = B
        | bitIndex66 = B
        | bitIndex67 = B
        | bitIndex68 = B
        | bitIndex69 = B ) ) ).

fof(addAssignment_2006,axiom,
    ! [VarCurr] :
      ( v8824(VarCurr,bitIndex49)
    <=> v3057(VarCurr,bitIndex329) ) ).

fof(addAssignmentInitValue_210,axiom,
    ~ v3057(constB0,bitIndex559) ).

fof(addAssignmentInitValue_209,axiom,
    ~ v3057(constB0,bitIndex558) ).

fof(addAssignmentInitValue_208,axiom,
    ~ v3057(constB0,bitIndex557) ).

fof(addAssignmentInitValue_207,axiom,
    ~ v3057(constB0,bitIndex556) ).

fof(addAssignmentInitValue_206,axiom,
    ~ v3057(constB0,bitIndex555) ).

fof(addAssignmentInitValue_205,axiom,
    ~ v3057(constB0,bitIndex554) ).

fof(addAssignmentInitValue_204,axiom,
    ~ v3057(constB0,bitIndex553) ).

fof(addAssignmentInitValue_203,axiom,
    ~ v3057(constB0,bitIndex539) ).

fof(bitBlastConstant_956,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex69) ).

fof(bitBlastConstant_955,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex68) ).

fof(bitBlastConstant_954,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex67) ).

fof(bitBlastConstant_953,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex66) ).

fof(bitBlastConstant_952,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex65) ).

fof(bitBlastConstant_951,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex64) ).

fof(bitBlastConstant_950,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex63) ).

fof(bitBlastConstant_949,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex49) ).

fof(addAssignmentInitValue_202,axiom,
    ~ v3057(constB0,bitIndex489) ).

fof(addAssignmentInitValue_201,axiom,
    ~ v3057(constB0,bitIndex488) ).

fof(addAssignmentInitValue_200,axiom,
    ~ v3057(constB0,bitIndex487) ).

fof(addAssignmentInitValue_199,axiom,
    ~ v3057(constB0,bitIndex486) ).

fof(addAssignmentInitValue_198,axiom,
    ~ v3057(constB0,bitIndex485) ).

fof(addAssignmentInitValue_197,axiom,
    ~ v3057(constB0,bitIndex484) ).

fof(addAssignmentInitValue_196,axiom,
    ~ v3057(constB0,bitIndex483) ).

fof(addAssignmentInitValue_195,axiom,
    ~ v3057(constB0,bitIndex469) ).

fof(bitBlastConstant_948,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex69) ).

fof(bitBlastConstant_947,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex68) ).

fof(bitBlastConstant_946,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex67) ).

fof(bitBlastConstant_945,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex66) ).

fof(bitBlastConstant_944,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex65) ).

fof(bitBlastConstant_943,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex64) ).

fof(bitBlastConstant_942,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex63) ).

fof(bitBlastConstant_941,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex49) ).

fof(addAssignmentInitValue_194,axiom,
    ~ v3057(constB0,bitIndex419) ).

fof(addAssignmentInitValue_193,axiom,
    ~ v3057(constB0,bitIndex418) ).

fof(addAssignmentInitValue_192,axiom,
    ~ v3057(constB0,bitIndex417) ).

fof(addAssignmentInitValue_191,axiom,
    ~ v3057(constB0,bitIndex416) ).

fof(addAssignmentInitValue_190,axiom,
    ~ v3057(constB0,bitIndex415) ).

fof(addAssignmentInitValue_189,axiom,
    ~ v3057(constB0,bitIndex414) ).

fof(addAssignmentInitValue_188,axiom,
    ~ v3057(constB0,bitIndex413) ).

fof(addAssignmentInitValue_187,axiom,
    ~ v3057(constB0,bitIndex399) ).

fof(bitBlastConstant_940,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex69) ).

fof(bitBlastConstant_939,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex68) ).

fof(bitBlastConstant_938,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex67) ).

fof(bitBlastConstant_937,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex66) ).

fof(bitBlastConstant_936,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex65) ).

fof(bitBlastConstant_935,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex64) ).

fof(bitBlastConstant_934,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex63) ).

fof(bitBlastConstant_933,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex49) ).

fof(addAssignmentInitValue_186,axiom,
    ~ v3057(constB0,bitIndex349) ).

fof(addAssignmentInitValue_185,axiom,
    ~ v3057(constB0,bitIndex348) ).

fof(addAssignmentInitValue_184,axiom,
    ~ v3057(constB0,bitIndex347) ).

fof(addAssignmentInitValue_183,axiom,
    ~ v3057(constB0,bitIndex346) ).

fof(addAssignmentInitValue_182,axiom,
    ~ v3057(constB0,bitIndex345) ).

fof(addAssignmentInitValue_181,axiom,
    ~ v3057(constB0,bitIndex344) ).

fof(addAssignmentInitValue_180,axiom,
    ~ v3057(constB0,bitIndex343) ).

fof(addAssignmentInitValue_179,axiom,
    ~ v3057(constB0,bitIndex329) ).

fof(bitBlastConstant_932,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex69) ).

fof(bitBlastConstant_931,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex68) ).

fof(bitBlastConstant_930,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex67) ).

fof(bitBlastConstant_929,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex66) ).

fof(bitBlastConstant_928,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex65) ).

fof(bitBlastConstant_927,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex64) ).

fof(bitBlastConstant_926,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex63) ).

fof(bitBlastConstant_925,axiom,
    ~ b0000000xxxxxxxxxxxxx0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex49) ).

fof(addAssignmentInitValue_178,axiom,
    ~ v3057(constB0,bitIndex279) ).

fof(addAssignmentInitValue_177,axiom,
    ~ v3057(constB0,bitIndex278) ).

fof(addAssignmentInitValue_176,axiom,
    ~ v3057(constB0,bitIndex277) ).

fof(addAssignmentInitValue_175,axiom,
    ~ v3057(constB0,bitIndex276) ).

fof(addAssignmentInitValue_174,axiom,
    ~ v3057(constB0,bitIndex275) ).

fof(addAssignmentInitValue_173,axiom,
    ~ v3057(constB0,bitIndex274) ).

fof(addAssignmentInitValue_172,axiom,
    ~ v3057(constB0,bitIndex273) ).

fof(bitBlastConstant_924,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex69) ).

fof(bitBlastConstant_923,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex68) ).

fof(bitBlastConstant_922,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex67) ).

fof(bitBlastConstant_921,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex66) ).

fof(bitBlastConstant_920,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex65) ).

fof(bitBlastConstant_919,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex64) ).

fof(bitBlastConstant_918,axiom,
    ~ b0000000xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx(bitIndex63) ).

fof(addAssignment_2005,axiom,
    ! [VarCurr] :
      ( v3154(VarCurr,bitIndex49)
    <=> v3156(VarCurr,bitIndex49) ) ).

fof(addAssignment_2004,axiom,
    ! [VarCurr] :
      ( v3156(VarCurr,bitIndex49)
    <=> v3158(VarCurr,bitIndex49) ) ).

fof(addAssignment_2003,axiom,
    ! [VarCurr] :
      ( v3158(VarCurr,bitIndex49)
    <=> v3160(VarCurr,bitIndex49) ) ).

fof(addAssignment_2002,axiom,
    ! [VarCurr] :
      ( v3160(VarCurr,bitIndex49)
    <=> v3162(VarCurr,bitIndex49) ) ).

fof(addAssignment_2001,axiom,
    ! [VarCurr] :
      ( v3162(VarCurr,bitIndex49)
    <=> v3164(VarCurr,bitIndex49) ) ).

fof(addAssignment_2000,axiom,
    ! [VarCurr] :
      ( v3164(VarCurr,bitIndex49)
    <=> v3166(VarCurr,bitIndex49) ) ).

fof(addAssignment_1999,axiom,
    ! [VarCurr] :
      ( v3166(VarCurr,bitIndex49)
    <=> v8812(VarCurr,bitIndex49) ) ).

fof(addAssignment_1998,axiom,
    ! [VarCurr,B] :
      ( range_5_0(B)
     => ( v8812(VarCurr,B)
      <=> v8821(VarCurr,B) ) ) ).

fof(addAssignment_1997,axiom,
    ! [VarCurr] :
      ( ( v8812(VarCurr,bitIndex10)
      <=> v8819(VarCurr,bitIndex4) )
      & ( v8812(VarCurr,bitIndex9)
      <=> v8819(VarCurr,bitIndex3) )
      & ( v8812(VarCurr,bitIndex8)
      <=> v8819(VarCurr,bitIndex2) )
      & ( v8812(VarCurr,bitIndex7)
      <=> v8819(VarCurr,bitIndex1) )
      & ( v8812(VarCurr,bitIndex6)
      <=> v8819(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_1996,axiom,
    ! [VarCurr] :
      ( ( v8812(VarCurr,bitIndex44)
      <=> v8817(VarCurr,bitIndex33) )
      & ( v8812(VarCurr,bitIndex43)
      <=> v8817(VarCurr,bitIndex32) )
      & ( v8812(VarCurr,bitIndex42)
      <=> v8817(VarCurr,bitIndex31) )
      & ( v8812(VarCurr,bitIndex41)
      <=> v8817(VarCurr,bitIndex30) )
      & ( v8812(VarCurr,bitIndex40)
      <=> v8817(VarCurr,bitIndex29) )
      & ( v8812(VarCurr,bitIndex39)
      <=> v8817(VarCurr,bitIndex28) )
      & ( v8812(VarCurr,bitIndex38)
      <=> v8817(VarCurr,bitIndex27) )
      & ( v8812(VarCurr,bitIndex37)
      <=> v8817(VarCurr,bitIndex26) )
      & ( v8812(VarCurr,bitIndex36)
      <=> v8817(VarCurr,bitIndex25) )
      & ( v8812(VarCurr,bitIndex35)
      <=> v8817(VarCurr,bitIndex24) )
      & ( v8812(VarCurr,bitIndex34)
      <=> v8817(VarCurr,bitIndex23) )
      & ( v8812(VarCurr,bitIndex33)
      <=> v8817(VarCurr,bitIndex22) )
      & ( v8812(VarCurr,bitIndex32)
      <=> v8817(VarCurr,bitIndex21) )
      & ( v8812(VarCurr,bitIndex31)
      <=> v8817(VarCurr,bitIndex20) )
      & ( v8812(VarCurr,bitIndex30)
      <=> v8817(VarCurr,bitIndex19) )
      & ( v8812(VarCurr,bitIndex29)
      <=> v8817(VarCurr,bitIndex18) )
      & ( v8812(VarCurr,bitIndex28)
      <=> v8817(VarCurr,bitIndex17) )
      & ( v8812(VarCurr,bitIndex27)
      <=> v8817(VarCurr,bitIndex16) )
      & ( v8812(VarCurr,bitIndex26)
      <=> v8817(VarCurr,bitIndex15) )
      & ( v8812(VarCurr,bitIndex25)
      <=> v8817(VarCurr,bitIndex14) )
      & ( v8812(VarCurr,bitIndex24)
      <=> v8817(VarCurr,bitIndex13) )
      & ( v8812(VarCurr,bitIndex23)
      <=> v8817(VarCurr,bitIndex12) )
      & ( v8812(VarCurr,bitIndex22)
      <=> v8817(VarCurr,bitIndex11) )
      & ( v8812(VarCurr,bitIndex21)
      <=> v8817(VarCurr,bitIndex10) )
      & ( v8812(VarCurr,bitIndex20)
      <=> v8817(VarCurr,bitIndex9) )
      & ( v8812(VarCurr,bitIndex19)
      <=> v8817(VarCurr,bitIndex8) )
      & ( v8812(VarCurr,bitIndex18)
      <=> v8817(VarCurr,bitIndex7) )
      & ( v8812(VarCurr,bitIndex17)
      <=> v8817(VarCurr,bitIndex6) )
      & ( v8812(VarCurr,bitIndex16)
      <=> v8817(VarCurr,bitIndex5) )
      & ( v8812(VarCurr,bitIndex15)
      <=> v8817(VarCurr,bitIndex4) )
      & ( v8812(VarCurr,bitIndex14)
      <=> v8817(VarCurr,bitIndex3) )
      & ( v8812(VarCurr,bitIndex13)
      <=> v8817(VarCurr,bitIndex2) )
      & ( v8812(VarCurr,bitIndex12)
      <=> v8817(VarCurr,bitIndex1) )
      & ( v8812(VarCurr,bitIndex11)
      <=> v8817(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_1995,axiom,
    ! [VarCurr] :
      ( ( v8812(VarCurr,bitIndex52)
      <=> v3168(VarCurr,bitIndex7) )
      & ( v8812(VarCurr,bitIndex51)
      <=> v3168(VarCurr,bitIndex6) )
      & ( v8812(VarCurr,bitIndex50)
      <=> v3168(VarCurr,bitIndex5) )
      & ( v8812(VarCurr,bitIndex49)
      <=> v3168(VarCurr,bitIndex4) )
      & ( v8812(VarCurr,bitIndex48)
      <=> v3168(VarCurr,bitIndex3) )
      & ( v8812(VarCurr,bitIndex47)
      <=> v3168(VarCurr,bitIndex2) )
      & ( v8812(VarCurr,bitIndex46)
      <=> v3168(VarCurr,bitIndex1) )
      & ( v8812(VarCurr,bitIndex45)
      <=> v3168(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_1994,axiom,
    ! [VarCurr] :
      ( ( v8812(VarCurr,bitIndex62)
      <=> v8815(VarCurr,bitIndex9) )
      & ( v8812(VarCurr,bitIndex61)
      <=> v8815(VarCurr,bitIndex8) )
      & ( v8812(VarCurr,bitIndex60)
      <=> v8815(VarCurr,bitIndex7) )
      & ( v8812(VarCurr,bitIndex59)
      <=> v8815(VarCurr,bitIndex6) )
      & ( v8812(VarCurr,bitIndex58)
      <=> v8815(VarCurr,bitIndex5) )
      & ( v8812(VarCurr,bitIndex57)
      <=> v8815(VarCurr,bitIndex4) )
      & ( v8812(VarCurr,bitIndex56)
      <=> v8815(VarCurr,bitIndex3) )
      & ( v8812(VarCurr,bitIndex55)
      <=> v8815(VarCurr,bitIndex2) )
      & ( v8812(VarCurr,bitIndex54)
      <=> v8815(VarCurr,bitIndex1) )
      & ( v8812(VarCurr,bitIndex53)
      <=> v8815(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_1993,axiom,
    ! [VarCurr] :
      ( ( v8812(VarCurr,bitIndex69)
      <=> v8813(VarCurr,bitIndex6) )
      & ( v8812(VarCurr,bitIndex68)
      <=> v8813(VarCurr,bitIndex5) )
      & ( v8812(VarCurr,bitIndex67)
      <=> v8813(VarCurr,bitIndex4) )
      & ( v8812(VarCurr,bitIndex66)
      <=> v8813(VarCurr,bitIndex3) )
      & ( v8812(VarCurr,bitIndex65)
      <=> v8813(VarCurr,bitIndex2) )
      & ( v8812(VarCurr,bitIndex64)
      <=> v8813(VarCurr,bitIndex1) )
      & ( v8812(VarCurr,bitIndex63)
      <=> v8813(VarCurr,bitIndex0) ) ) ).

fof(addAssignmentInitValueVector_68,axiom,
    ! [B] :
      ( range_6_0(B)
     => ( v8813(constB0,B)
      <=> $false ) ) ).

fof(addAssignment_1992,axiom,
    ! [VarNext] :
      ( v3168(VarNext,bitIndex4)
    <=> v8766(VarNext,bitIndex4) ) ).

fof(addCaseBooleanConditionEqualRanges1_141,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8767(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v8766(VarNext,B)
            <=> v3168(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_149,axiom,
    ! [VarNext] :
      ( v8767(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v8766(VarNext,B)
          <=> v8802(VarNext,B) ) ) ) ).

fof(addAssignment_1991,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v8802(VarNext,B)
          <=> v8800(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_210,axiom,
    ! [VarCurr] :
      ( ~ v8777(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v8800(VarCurr,B)
          <=> v8803(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_202,axiom,
    ! [VarCurr] :
      ( v8777(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v8800(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_209,axiom,
    ! [VarCurr] :
      ( ~ v8780(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v8803(VarCurr,B)
          <=> v6740(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_201,axiom,
    ! [VarCurr] :
      ( v8780(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v8803(VarCurr,B)
          <=> v8804(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_208,axiom,
    ! [VarCurr] :
      ( ~ v8791(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v8804(VarCurr,B)
          <=> v8806(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_200,axiom,
    ! [VarCurr] :
      ( v8791(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v8804(VarCurr,B)
          <=> v8805(VarCurr,B) ) ) ) ).

fof(addAssignment_1990,axiom,
    ! [VarCurr] :
      ( ( v8806(VarCurr,bitIndex3)
      <=> v6551(VarCurr,bitIndex31) )
      & ( v8806(VarCurr,bitIndex2)
      <=> v6551(VarCurr,bitIndex30) )
      & ( v8806(VarCurr,bitIndex1)
      <=> v6551(VarCurr,bitIndex29) )
      & ( v8806(VarCurr,bitIndex0)
      <=> v6551(VarCurr,bitIndex28) ) ) ).

fof(addAssignment_1989,axiom,
    ! [VarCurr] :
      ( ( v8806(VarCurr,bitIndex7)
      <=> v8807(VarCurr,bitIndex3) )
      & ( v8806(VarCurr,bitIndex6)
      <=> v8807(VarCurr,bitIndex2) )
      & ( v8806(VarCurr,bitIndex5)
      <=> v8807(VarCurr,bitIndex1) )
      & ( v8806(VarCurr,bitIndex4)
      <=> v8807(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_1988,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v8807(VarCurr,B)
      <=> v8808(VarCurr,B) ) ) ).

fof(writeBinaryOperatorShiftedRanges_366,axiom,
    ! [VarCurr] :
      ( v8808(VarCurr,bitIndex0)
    <=> ( v6551(VarCurr,bitIndex32)
        | v8809(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_365,axiom,
    ! [VarCurr] :
      ( v8808(VarCurr,bitIndex1)
    <=> ( v6551(VarCurr,bitIndex33)
        | v8809(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_364,axiom,
    ! [VarCurr] :
      ( v8808(VarCurr,bitIndex2)
    <=> ( v6551(VarCurr,bitIndex34)
        | v8809(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_363,axiom,
    ! [VarCurr] :
      ( v8808(VarCurr,bitIndex3)
    <=> ( v6551(VarCurr,bitIndex35)
        | v8809(VarCurr,bitIndex3) ) ) ).

fof(addAssignment_1987,axiom,
    ! [VarCurr] :
      ( v8809(VarCurr,bitIndex0)
    <=> v6551(VarCurr,bitIndex36) ) ).

fof(addAssignment_1986,axiom,
    ! [VarCurr] :
      ( ( v8809(VarCurr,bitIndex3)
      <=> $false )
      & ( v8809(VarCurr,bitIndex2)
      <=> $false )
      & ( v8809(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addAssignment_1985,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v8805(VarCurr,B)
      <=> v6740(VarCurr,B) ) ) ).

fof(addAssignment_1984,axiom,
    ! [VarCurr] :
      ( v8805(VarCurr,bitIndex4)
    <=> v8745(VarCurr) ) ).

fof(addAssignment_1983,axiom,
    ! [VarCurr,B] :
      ( range_7_5(B)
     => ( v8805(VarCurr,B)
      <=> v6740(VarCurr,B) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1649,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8767(VarNext)
      <=> ( v8768(VarNext)
          & v8775(VarNext) ) ) ) ).

fof(addAssignment_1982,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8775(VarNext)
      <=> v8773(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1648,axiom,
    ! [VarCurr] :
      ( v8773(VarCurr)
    <=> ( v8776(VarCurr)
        & v8783(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1647,axiom,
    ! [VarCurr] :
      ( v8783(VarCurr)
    <=> ( v8784(VarCurr)
        | v8777(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1646,axiom,
    ! [VarCurr] :
      ( v8784(VarCurr)
    <=> ( v8785(VarCurr)
        & v8798(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1645,axiom,
    ! [VarCurr] :
      ( v8798(VarCurr)
    <=> ( v8799(VarCurr)
        | v8781(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1644,axiom,
    ! [VarCurr] :
      ( v8799(VarCurr)
    <=> ( v8788(VarCurr)
        | v8780(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1643,axiom,
    ! [VarCurr] :
      ( v8785(VarCurr)
    <=> ( v8786(VarCurr)
        & v8796(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1642,axiom,
    ! [VarCurr] :
      ( v8796(VarCurr)
    <=> ( v65(VarCurr)
        | v8797(VarCurr) ) ) ).

fof(writeUnaryOperator_777,axiom,
    ! [VarCurr] :
      ( ~ v8797(VarCurr)
    <=> v8781(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1641,axiom,
    ! [VarCurr] :
      ( v8786(VarCurr)
    <=> ( v8787(VarCurr)
        & v8789(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1640,axiom,
    ! [VarCurr] :
      ( v8789(VarCurr)
    <=> ( v8790(VarCurr)
        | v8795(VarCurr) ) ) ).

fof(writeUnaryOperator_776,axiom,
    ! [VarCurr] :
      ( ~ v8795(VarCurr)
    <=> v8780(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1639,axiom,
    ! [VarCurr] :
      ( v8790(VarCurr)
    <=> ( v8791(VarCurr)
        | v8793(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_626,axiom,
    ! [VarCurr] :
      ( v8793(VarCurr)
    <=> ( ( v8794(VarCurr,bitIndex1)
        <=> $true )
        & ( v8794(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1981,axiom,
    ! [VarCurr] :
      ( v8794(VarCurr,bitIndex0)
    <=> v3173(VarCurr) ) ).

fof(addAssignment_1980,axiom,
    ! [VarCurr] :
      ( v8794(VarCurr,bitIndex1)
    <=> v3171(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_625,axiom,
    ! [VarCurr] :
      ( v8791(VarCurr)
    <=> ( ( v8792(VarCurr,bitIndex1)
        <=> $true )
        & ( v8792(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1979,axiom,
    ! [VarCurr] :
      ( v8792(VarCurr,bitIndex0)
    <=> v3173(VarCurr) ) ).

fof(addAssignment_1978,axiom,
    ! [VarCurr] :
      ( v8792(VarCurr,bitIndex1)
    <=> v3171(VarCurr) ) ).

fof(writeUnaryOperator_775,axiom,
    ! [VarCurr] :
      ( ~ v8787(VarCurr)
    <=> v8788(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_624,axiom,
    ! [VarCurr] :
      ( v8788(VarCurr)
    <=> ( ( v67(VarCurr,bitIndex2)
        <=> $false )
        & ( v67(VarCurr,bitIndex1)
        <=> $false )
        & ( v67(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1638,axiom,
    ! [VarCurr] :
      ( v8776(VarCurr)
    <=> ( v8777(VarCurr)
        | v8778(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1637,axiom,
    ! [VarCurr] :
      ( v8778(VarCurr)
    <=> ( v8779(VarCurr)
        & v8782(VarCurr) ) ) ).

fof(writeUnaryOperator_774,axiom,
    ! [VarCurr] :
      ( ~ v8782(VarCurr)
    <=> v8777(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1636,axiom,
    ! [VarCurr] :
      ( v8779(VarCurr)
    <=> ( v8780(VarCurr)
        | v8781(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_623,axiom,
    ! [VarCurr] :
      ( v8781(VarCurr)
    <=> ( ( v67(VarCurr,bitIndex2)
        <=> $false )
        & ( v67(VarCurr,bitIndex1)
        <=> $true )
        & ( v67(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_622,axiom,
    ! [VarCurr] :
      ( v8780(VarCurr)
    <=> ( ( v67(VarCurr,bitIndex2)
        <=> $false )
        & ( v67(VarCurr,bitIndex1)
        <=> $true )
        & ( v67(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeUnaryOperator_773,axiom,
    ! [VarCurr] :
      ( ~ v8777(VarCurr)
    <=> v60(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1635,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8768(VarNext)
      <=> ( v8769(VarNext)
          & v179(VarNext) ) ) ) ).

fof(writeUnaryOperator_772,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8769(VarNext)
      <=> v4675(VarNext) ) ) ).

fof(addAssignmentInitValue_171,axiom,
    ~ v3168(constB0,bitIndex4) ).

fof(bitBlastConstant_917,axiom,
    ~ bxxx0xxxx(bitIndex4) ).

fof(addAssignment_1977,axiom,
    ! [VarNext] :
      ( v6740(VarNext,bitIndex4)
    <=> v8756(VarNext,bitIndex4) ) ).

fof(addCaseBooleanConditionEqualRanges1_140,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8758(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v8756(VarNext,B)
            <=> v6740(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_148,axiom,
    ! [VarNext] :
      ( v8758(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v8756(VarNext,B)
          <=> v6761(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1634,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8758(VarNext)
      <=> ( v8759(VarNext)
          & v6758(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1633,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8759(VarNext)
      <=> ( v8761(VarNext)
          & v179(VarNext) ) ) ) ).

fof(writeUnaryOperator_771,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8761(VarNext)
      <=> v4675(VarNext) ) ) ).

fof(addAssignment_1976,axiom,
    ! [VarCurr] :
      ( v6742(VarCurr,bitIndex4)
    <=> v6743(VarCurr,bitIndex4) ) ).

fof(addAssignment_1975,axiom,
    ! [VarCurr] :
      ( v4272(VarCurr,bitIndex4)
    <=> v4274(VarCurr,bitIndex4) ) ).

fof(addAssignment_1974,axiom,
    ! [VarCurr] :
      ( v4274(VarCurr,bitIndex4)
    <=> v4276(VarCurr,bitIndex4) ) ).

fof(addAssignment_1973,axiom,
    ! [VarCurr] :
      ( v4276(VarCurr,bitIndex4)
    <=> v4278(VarCurr,bitIndex28) ) ).

fof(addAssignment_1972,axiom,
    ! [VarNext] :
      ( v4278(VarNext,bitIndex28)
    <=> v8748(VarNext,bitIndex4) ) ).

fof(addCaseBooleanConditionShiftedRanges1_16,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8750(VarNext)
       => ( ( v8748(VarNext,bitIndex7)
          <=> v4278(VarCurr,bitIndex31) )
          & ( v8748(VarNext,bitIndex6)
          <=> v4278(VarCurr,bitIndex30) )
          & ( v8748(VarNext,bitIndex5)
          <=> v4278(VarCurr,bitIndex29) )
          & ( v8748(VarNext,bitIndex4)
          <=> v4278(VarCurr,bitIndex28) )
          & ( v8748(VarNext,bitIndex3)
          <=> v4278(VarCurr,bitIndex27) )
          & ( v8748(VarNext,bitIndex2)
          <=> v4278(VarCurr,bitIndex26) )
          & ( v8748(VarNext,bitIndex1)
          <=> v4278(VarCurr,bitIndex25) )
          & ( v8748(VarNext,bitIndex0)
          <=> v4278(VarCurr,bitIndex24) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_147,axiom,
    ! [VarNext] :
      ( v8750(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v8748(VarNext,B)
          <=> v4612(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1632,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8750(VarNext)
      <=> ( v8751(VarNext)
          & v4594(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1631,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8751(VarNext)
      <=> ( v8753(VarNext)
          & v2429(VarNext) ) ) ) ).

fof(writeUnaryOperator_770,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8753(VarNext)
      <=> v2436(VarNext) ) ) ).

fof(addAssignment_1971,axiom,
    ! [VarCurr] :
      ( v4578(VarCurr,bitIndex4)
    <=> v4583(VarCurr,bitIndex4) ) ).

fof(addAssignment_1970,axiom,
    ! [VarCurr] :
      ( v4582(VarCurr,bitIndex4)
    <=> v4278(VarCurr,bitIndex20) ) ).

fof(addAssignment_1969,axiom,
    ! [VarCurr] :
      ( v4571(VarCurr,bitIndex4)
    <=> v4576(VarCurr,bitIndex4) ) ).

fof(addAssignment_1968,axiom,
    ! [VarCurr] :
      ( v4575(VarCurr,bitIndex4)
    <=> v4278(VarCurr,bitIndex28) ) ).

fof(addAssignment_1967,axiom,
    ! [VarCurr] :
      ( v4339(VarCurr,bitIndex4)
    <=> v4341(VarCurr,bitIndex4) ) ).

fof(addAssignment_1966,axiom,
    ! [VarCurr] :
      ( v4341(VarCurr,bitIndex4)
    <=> v3260(VarCurr,bitIndex59) ) ).

fof(addAssignment_1965,axiom,
    ! [VarCurr] :
      ( v3260(VarCurr,bitIndex59)
    <=> v3262(VarCurr,bitIndex59) ) ).

fof(addAssignment_1964,axiom,
    ! [VarCurr] :
      ( v3262(VarCurr,bitIndex59)
    <=> v3264(VarCurr,bitIndex59) ) ).

fof(addAssignment_1963,axiom,
    ! [VarCurr] :
      ( v3264(VarCurr,bitIndex59)
    <=> v3266(VarCurr,bitIndex59) ) ).

fof(addAssignment_1962,axiom,
    ! [VarCurr] :
      ( v3266(VarCurr,bitIndex59)
    <=> v3268(VarCurr,bitIndex59) ) ).

fof(addAssignment_1961,axiom,
    ! [VarCurr] :
      ( v3268(VarCurr,bitIndex59)
    <=> v3270(VarCurr,bitIndex59) ) ).

fof(addAssignment_1960,axiom,
    ! [VarCurr] :
      ( v3270(VarCurr,bitIndex59)
    <=> v3272(VarCurr,bitIndex59) ) ).

fof(addAssignment_1959,axiom,
    ! [VarCurr] :
      ( v3272(VarCurr,bitIndex59)
    <=> v4115(VarCurr,bitIndex59) ) ).

fof(addAssignment_1958,axiom,
    ! [VarCurr] :
      ( v6551(VarCurr,bitIndex36)
    <=> v6553(VarCurr,bitIndex36) ) ).

fof(addAssignment_1957,axiom,
    ! [VarCurr] :
      ( v6553(VarCurr,bitIndex36)
    <=> v6555(VarCurr,bitIndex36) ) ).

fof(addAssignment_1956,axiom,
    ! [VarCurr] :
      ( v6555(VarCurr,bitIndex36)
    <=> v6557(VarCurr,bitIndex36) ) ).

fof(addAssignment_1955,axiom,
    ! [VarCurr] :
      ( v6557(VarCurr,bitIndex36)
    <=> v7080(VarCurr,bitIndex36) ) ).

fof(addAssignment_1954,axiom,
    ! [VarCurr] :
      ( v6551(VarCurr,bitIndex32)
    <=> v6553(VarCurr,bitIndex32) ) ).

fof(addAssignment_1953,axiom,
    ! [VarCurr] :
      ( v6553(VarCurr,bitIndex32)
    <=> v6555(VarCurr,bitIndex32) ) ).

fof(addAssignment_1952,axiom,
    ! [VarCurr] :
      ( v6555(VarCurr,bitIndex32)
    <=> v6557(VarCurr,bitIndex32) ) ).

fof(addAssignment_1951,axiom,
    ! [VarCurr] :
      ( v6557(VarCurr,bitIndex32)
    <=> v7080(VarCurr,bitIndex32) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1630,axiom,
    ! [VarCurr] :
      ( v8745(VarCurr)
    <=> ( v6630(VarCurr)
        | v5621(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_38,axiom,
    ! [VarCurr] :
      ( ( ~ v8711(VarCurr)
        & ~ v8712(VarCurr)
        & ~ v8743(VarCurr) )
     => ( v3171(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_79,axiom,
    ! [VarCurr] :
      ( v8743(VarCurr)
     => ( v3171(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_207,axiom,
    ! [VarCurr] :
      ( v8712(VarCurr)
     => ( v3171(VarCurr)
      <=> v8713(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_199,axiom,
    ! [VarCurr] :
      ( v8711(VarCurr)
     => ( v3171(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_621,axiom,
    ! [VarCurr] :
      ( v8743(VarCurr)
    <=> ( ( v67(VarCurr,bitIndex2)
        <=> $false )
        & ( v67(VarCurr,bitIndex1)
        <=> $true )
        & ( v67(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_206,axiom,
    ! [VarCurr] :
      ( ~ v8714(VarCurr)
     => ( v8713(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_198,axiom,
    ! [VarCurr] :
      ( v8714(VarCurr)
     => ( v8713(VarCurr)
      <=> v8715(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_620,axiom,
    ! [VarCurr] :
      ( v8742(VarCurr)
    <=> ( v2990(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_37,axiom,
    ! [VarCurr] :
      ( ( ~ v8716(VarCurr)
        & ~ v8718(VarCurr)
        & ~ v8732(VarCurr) )
     => ( v8715(VarCurr)
      <=> v8736(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_78,axiom,
    ! [VarCurr] :
      ( v8732(VarCurr)
     => ( v8715(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_205,axiom,
    ! [VarCurr] :
      ( v8718(VarCurr)
     => ( v8715(VarCurr)
      <=> v8720(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_197,axiom,
    ! [VarCurr] :
      ( v8716(VarCurr)
     => ( v8715(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_204,axiom,
    ! [VarCurr] :
      ( ~ v8737(VarCurr)
     => ( v8736(VarCurr)
      <=> v8739(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_196,axiom,
    ! [VarCurr] :
      ( v8737(VarCurr)
     => ( v8736(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_203,axiom,
    ! [VarCurr] :
      ( ~ v8740(VarCurr)
     => ( v8739(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_195,axiom,
    ! [VarCurr] :
      ( v8740(VarCurr)
     => ( v8739(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_619,axiom,
    ! [VarCurr] :
      ( v8741(VarCurr)
    <=> ( v8673(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_618,axiom,
    ! [VarCurr] :
      ( v8740(VarCurr)
    <=> ( v8673(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_617,axiom,
    ! [VarCurr] :
      ( v8738(VarCurr)
    <=> ( v5621(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_616,axiom,
    ! [VarCurr] :
      ( v8737(VarCurr)
    <=> ( v5621(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_615,axiom,
    ! [VarCurr] :
      ( v8734(VarCurr)
    <=> ( ( v8735(VarCurr,bitIndex1)
        <=> $true )
        & ( v8735(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1950,axiom,
    ! [VarCurr] :
      ( v8735(VarCurr,bitIndex0)
    <=> v8704(VarCurr) ) ).

fof(addAssignment_1949,axiom,
    ! [VarCurr] :
      ( v8735(VarCurr,bitIndex1)
    <=> v3173(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_614,axiom,
    ! [VarCurr] :
      ( v8732(VarCurr)
    <=> ( ( v8733(VarCurr,bitIndex1)
        <=> $true )
        & ( v8733(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1948,axiom,
    ! [VarCurr] :
      ( v8733(VarCurr,bitIndex0)
    <=> v8704(VarCurr) ) ).

fof(addAssignment_1947,axiom,
    ! [VarCurr] :
      ( v8733(VarCurr,bitIndex1)
    <=> v3173(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_202,axiom,
    ! [VarCurr] :
      ( ~ v8721(VarCurr)
     => ( v8720(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_194,axiom,
    ! [VarCurr] :
      ( v8721(VarCurr)
     => ( v8720(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1629,axiom,
    ! [VarCurr] :
      ( v8721(VarCurr)
    <=> ( v8722(VarCurr)
        | v8727(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1628,axiom,
    ! [VarCurr] :
      ( v8727(VarCurr)
    <=> ( v8728(VarCurr)
        | v8730(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_613,axiom,
    ! [VarCurr] :
      ( v8730(VarCurr)
    <=> ( ( v8731(VarCurr,bitIndex3)
        <=> $false )
        & ( v8731(VarCurr,bitIndex2)
        <=> $true )
        & ( v8731(VarCurr,bitIndex1)
        <=> $false )
        & ( v8731(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1946,axiom,
    ! [VarCurr] :
      ( v8731(VarCurr,bitIndex0)
    <=> v6630(VarCurr) ) ).

fof(addAssignment_1945,axiom,
    ! [VarCurr] :
      ( ( v8731(VarCurr,bitIndex3)
      <=> v4668(VarCurr,bitIndex2) )
      & ( v8731(VarCurr,bitIndex2)
      <=> v4668(VarCurr,bitIndex1) )
      & ( v8731(VarCurr,bitIndex1)
      <=> v4668(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_612,axiom,
    ! [VarCurr] :
      ( v8728(VarCurr)
    <=> ( ( v8729(VarCurr,bitIndex3)
        <=> $false )
        & ( v8729(VarCurr,bitIndex2)
        <=> $false )
        & ( v8729(VarCurr,bitIndex1)
        <=> $true )
        & ( v8729(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1944,axiom,
    ! [VarCurr] :
      ( v8729(VarCurr,bitIndex0)
    <=> v6630(VarCurr) ) ).

fof(addAssignment_1943,axiom,
    ! [VarCurr] :
      ( ( v8729(VarCurr,bitIndex3)
      <=> v4668(VarCurr,bitIndex2) )
      & ( v8729(VarCurr,bitIndex2)
      <=> v4668(VarCurr,bitIndex1) )
      & ( v8729(VarCurr,bitIndex1)
      <=> v4668(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1627,axiom,
    ! [VarCurr] :
      ( v8722(VarCurr)
    <=> ( v8723(VarCurr)
        | v8725(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_611,axiom,
    ! [VarCurr] :
      ( v8725(VarCurr)
    <=> ( ( v8726(VarCurr,bitIndex3)
        <=> $false )
        & ( v8726(VarCurr,bitIndex2)
        <=> $true )
        & ( v8726(VarCurr,bitIndex1)
        <=> $false )
        & ( v8726(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1942,axiom,
    ! [VarCurr] :
      ( v8726(VarCurr,bitIndex0)
    <=> v6630(VarCurr) ) ).

fof(addAssignment_1941,axiom,
    ! [VarCurr] :
      ( ( v8726(VarCurr,bitIndex3)
      <=> v4668(VarCurr,bitIndex2) )
      & ( v8726(VarCurr,bitIndex2)
      <=> v4668(VarCurr,bitIndex1) )
      & ( v8726(VarCurr,bitIndex1)
      <=> v4668(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_610,axiom,
    ! [VarCurr] :
      ( v8723(VarCurr)
    <=> ( ( v8724(VarCurr,bitIndex3)
        <=> $false )
        & ( v8724(VarCurr,bitIndex2)
        <=> $false )
        & ( v8724(VarCurr,bitIndex1)
        <=> $true )
        & ( v8724(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1940,axiom,
    ! [VarCurr] :
      ( v8724(VarCurr,bitIndex0)
    <=> v6630(VarCurr) ) ).

fof(addAssignment_1939,axiom,
    ! [VarCurr] :
      ( ( v8724(VarCurr,bitIndex3)
      <=> v4668(VarCurr,bitIndex2) )
      & ( v8724(VarCurr,bitIndex2)
      <=> v4668(VarCurr,bitIndex1) )
      & ( v8724(VarCurr,bitIndex1)
      <=> v4668(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_609,axiom,
    ! [VarCurr] :
      ( v8718(VarCurr)
    <=> ( ( v8719(VarCurr,bitIndex1)
        <=> $false )
        & ( v8719(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1938,axiom,
    ! [VarCurr] :
      ( v8719(VarCurr,bitIndex0)
    <=> v8704(VarCurr) ) ).

fof(addAssignment_1937,axiom,
    ! [VarCurr] :
      ( v8719(VarCurr,bitIndex1)
    <=> v3173(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_608,axiom,
    ! [VarCurr] :
      ( v8716(VarCurr)
    <=> ( ( v8717(VarCurr,bitIndex1)
        <=> $false )
        & ( v8717(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1936,axiom,
    ! [VarCurr] :
      ( v8717(VarCurr,bitIndex0)
    <=> v8704(VarCurr) ) ).

fof(addAssignment_1935,axiom,
    ! [VarCurr] :
      ( v8717(VarCurr,bitIndex1)
    <=> v3173(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_607,axiom,
    ! [VarCurr] :
      ( v8714(VarCurr)
    <=> ( v2990(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_606,axiom,
    ! [VarCurr] :
      ( v8712(VarCurr)
    <=> ( ( v67(VarCurr,bitIndex2)
        <=> $false )
        & ( v67(VarCurr,bitIndex1)
        <=> $true )
        & ( v67(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_605,axiom,
    ! [VarCurr] :
      ( v8711(VarCurr)
    <=> ( ( v67(VarCurr,bitIndex2)
        <=> $false )
        & ( v67(VarCurr,bitIndex1)
        <=> $false )
        & ( v67(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignmentInitValueVector_67,axiom,
    ! [B] :
      ( range_2_0(B)
     => ( v67(constB0,B)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_36,axiom,
    ! [VarCurr] :
      ( ( ~ v8706(VarCurr)
        & ~ v5337(VarCurr)
        & ~ v5349(VarCurr) )
     => ( v8704(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_77,axiom,
    ! [VarCurr] :
      ( v5349(VarCurr)
     => ( v8704(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_201,axiom,
    ! [VarCurr] :
      ( v5337(VarCurr)
     => ( v8704(VarCurr)
      <=> v8707(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_193,axiom,
    ! [VarCurr] :
      ( v8706(VarCurr)
     => ( v8704(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_200,axiom,
    ! [VarCurr] :
      ( ~ v5339(VarCurr)
     => ( v8707(VarCurr)
      <=> v8709(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_192,axiom,
    ! [VarCurr] :
      ( v5339(VarCurr)
     => ( v8707(VarCurr)
      <=> v8708(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_199,axiom,
    ! [VarCurr] :
      ( ~ v6294(VarCurr)
     => ( v8709(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_191,axiom,
    ! [VarCurr] :
      ( v6294(VarCurr)
     => ( v8709(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_76,axiom,
    ! [VarCurr] :
      ( ( ~ v5341(VarCurr)
        & ~ v5343(VarCurr) )
     => ( v8708(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_198,axiom,
    ! [VarCurr] :
      ( v5343(VarCurr)
     => ( v8708(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_190,axiom,
    ! [VarCurr] :
      ( v5341(VarCurr)
     => ( v8708(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1626,axiom,
    ! [VarCurr] :
      ( v8706(VarCurr)
    <=> ( v5333(VarCurr)
        | v5336(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_139,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8688(VarNext)
       => ( v3173(VarNext)
        <=> v3173(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_146,axiom,
    ! [VarNext] :
      ( v8688(VarNext)
     => ( v3173(VarNext)
      <=> v8696(VarNext) ) ) ).

fof(addAssignment_1934,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8696(VarNext)
      <=> v8694(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_211,axiom,
    ! [VarCurr] :
      ( ~ v8697(VarCurr)
     => ( v8694(VarCurr)
      <=> v8698(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_214,axiom,
    ! [VarCurr] :
      ( v8697(VarCurr)
     => ( v8694(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_210,axiom,
    ! [VarCurr] :
      ( ~ v3175(VarCurr)
     => ( v8698(VarCurr)
      <=> v8699(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_213,axiom,
    ! [VarCurr] :
      ( v3175(VarCurr)
     => ( v8698(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1625,axiom,
    ! [VarCurr] :
      ( v8699(VarCurr)
    <=> ( v8700(VarCurr)
        & v3173(VarCurr) ) ) ).

fof(writeUnaryOperator_769,axiom,
    ! [VarCurr] :
      ( ~ v8700(VarCurr)
    <=> v8673(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_604,axiom,
    ! [VarCurr] :
      ( v8697(VarCurr)
    <=> ( v60(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1624,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8688(VarNext)
      <=> v8689(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1623,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8689(VarNext)
      <=> ( v8690(VarNext)
          & v179(VarNext) ) ) ) ).

fof(writeUnaryOperator_768,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8690(VarNext)
      <=> v4675(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges5_6,axiom,
    ! [VarCurr] :
      ( ( ~ v5334(VarCurr)
        & ~ v5335(VarCurr)
        & ~ v5336(VarCurr)
        & ~ v5337(VarCurr)
        & ~ v5349(VarCurr) )
     => ( v8673(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_9,axiom,
    ! [VarCurr] :
      ( v5349(VarCurr)
     => ( v8673(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_35,axiom,
    ! [VarCurr] :
      ( v5337(VarCurr)
     => ( v8673(VarCurr)
      <=> v8677(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_75,axiom,
    ! [VarCurr] :
      ( v5336(VarCurr)
     => ( v8673(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_197,axiom,
    ! [VarCurr] :
      ( v5335(VarCurr)
     => ( v8673(VarCurr)
      <=> v8675(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_189,axiom,
    ! [VarCurr] :
      ( v5334(VarCurr)
     => ( v8673(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_196,axiom,
    ! [VarCurr] :
      ( ~ v5339(VarCurr)
     => ( v8677(VarCurr)
      <=> v8685(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_188,axiom,
    ! [VarCurr] :
      ( v5339(VarCurr)
     => ( v8677(VarCurr)
      <=> v8678(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_195,axiom,
    ! [VarCurr] :
      ( ~ v6294(VarCurr)
     => ( v8685(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_187,axiom,
    ! [VarCurr] :
      ( v6294(VarCurr)
     => ( v8685(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_74,axiom,
    ! [VarCurr] :
      ( ( ~ v5341(VarCurr)
        & ~ v5343(VarCurr) )
     => ( v8678(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_194,axiom,
    ! [VarCurr] :
      ( v5343(VarCurr)
     => ( v8678(VarCurr)
      <=> v8682(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_186,axiom,
    ! [VarCurr] :
      ( v5341(VarCurr)
     => ( v8678(VarCurr)
      <=> v8679(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_193,axiom,
    ! [VarCurr] :
      ( ~ v8683(VarCurr)
     => ( v8682(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_185,axiom,
    ! [VarCurr] :
      ( v8683(VarCurr)
     => ( v8682(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_603,axiom,
    ! [VarCurr] :
      ( v8684(VarCurr)
    <=> ( v5323(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_602,axiom,
    ! [VarCurr] :
      ( v8683(VarCurr)
    <=> ( v5323(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_192,axiom,
    ! [VarCurr] :
      ( ~ v8680(VarCurr)
     => ( v8679(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_184,axiom,
    ! [VarCurr] :
      ( v8680(VarCurr)
     => ( v8679(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_601,axiom,
    ! [VarCurr] :
      ( v8681(VarCurr)
    <=> ( v6630(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_600,axiom,
    ! [VarCurr] :
      ( v8680(VarCurr)
    <=> ( v6630(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_191,axiom,
    ! [VarCurr] :
      ( ~ v6290(VarCurr)
     => ( v8675(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_183,axiom,
    ! [VarCurr] :
      ( v6290(VarCurr)
     => ( v8675(VarCurr)
      <=> v8676(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_190,axiom,
    ! [VarCurr] :
      ( ~ v7729(VarCurr)
     => ( v8676(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_182,axiom,
    ! [VarCurr] :
      ( v7729(VarCurr)
     => ( v8676(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges5_5,axiom,
    ! [VarCurr] :
      ( ( ~ v5334(VarCurr)
        & ~ v5335(VarCurr)
        & ~ v5336(VarCurr)
        & ~ v5337(VarCurr)
        & ~ v5349(VarCurr) )
     => ( v3175(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_8,axiom,
    ! [VarCurr] :
      ( v5349(VarCurr)
     => ( v3175(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_34,axiom,
    ! [VarCurr] :
      ( v5337(VarCurr)
     => ( v3175(VarCurr)
      <=> v8668(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_73,axiom,
    ! [VarCurr] :
      ( v5336(VarCurr)
     => ( v3175(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_189,axiom,
    ! [VarCurr] :
      ( v5335(VarCurr)
     => ( v3175(VarCurr)
      <=> v8666(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_181,axiom,
    ! [VarCurr] :
      ( v5334(VarCurr)
     => ( v3175(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_188,axiom,
    ! [VarCurr] :
      ( ~ v5339(VarCurr)
     => ( v8668(VarCurr)
      <=> v8671(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_180,axiom,
    ! [VarCurr] :
      ( v5339(VarCurr)
     => ( v8668(VarCurr)
      <=> v8669(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_187,axiom,
    ! [VarCurr] :
      ( ~ v6294(VarCurr)
     => ( v8671(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_179,axiom,
    ! [VarCurr] :
      ( v6294(VarCurr)
     => ( v8671(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_186,axiom,
    ! [VarCurr] :
      ( ~ v8670(VarCurr)
     => ( v8669(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_178,axiom,
    ! [VarCurr] :
      ( v8670(VarCurr)
     => ( v8669(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1622,axiom,
    ! [VarCurr] :
      ( v8670(VarCurr)
    <=> ( v5341(VarCurr)
        | v5343(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_185,axiom,
    ! [VarCurr] :
      ( ~ v6290(VarCurr)
     => ( v8666(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_177,axiom,
    ! [VarCurr] :
      ( v6290(VarCurr)
     => ( v8666(VarCurr)
      <=> v8667(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_184,axiom,
    ! [VarCurr] :
      ( ~ v7729(VarCurr)
     => ( v8667(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_176,axiom,
    ! [VarCurr] :
      ( v7729(VarCurr)
     => ( v8667(VarCurr)
      <=> $false ) ) ).

fof(addCaseBooleanConditionEqualRanges1_138,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8653(VarNext)
       => ! [B] :
            ( range_2_0(B)
           => ( v3177(VarNext,B)
            <=> v3177(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_145,axiom,
    ! [VarNext] :
      ( v8653(VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v3177(VarNext,B)
          <=> v8661(VarNext,B) ) ) ) ).

fof(addAssignment_1933,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v8661(VarNext,B)
          <=> v8659(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_209,axiom,
    ! [VarCurr] :
      ( ~ v8662(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v8659(VarCurr,B)
          <=> v3179(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_212,axiom,
    ! [VarCurr] :
      ( v8662(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v8659(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_599,axiom,
    ! [VarCurr] :
      ( v8662(VarCurr)
    <=> ( v60(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1621,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8653(VarNext)
      <=> v8654(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1620,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8654(VarNext)
      <=> ( v8655(VarNext)
          & v179(VarNext) ) ) ) ).

fof(writeUnaryOperator_767,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8655(VarNext)
      <=> v4675(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges5_4,axiom,
    ! [VarCurr] :
      ( ( ~ v8620(VarCurr)
        & ~ v8624(VarCurr)
        & ~ v8629(VarCurr)
        & ~ v8633(VarCurr)
        & ~ v8650(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v3179(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_7,axiom,
    ! [VarCurr] :
      ( v8650(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3179(VarCurr,B)
          <=> b001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_33,axiom,
    ! [VarCurr] :
      ( v8633(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3179(VarCurr,B)
          <=> v8634(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_72,axiom,
    ! [VarCurr] :
      ( v8629(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3179(VarCurr,B)
          <=> v8630(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_183,axiom,
    ! [VarCurr] :
      ( v8624(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3179(VarCurr,B)
          <=> v8625(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_175,axiom,
    ! [VarCurr] :
      ( v8620(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3179(VarCurr,B)
          <=> v8621(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_598,axiom,
    ! [VarCurr] :
      ( v8650(VarCurr)
    <=> ( ( v3177(VarCurr,bitIndex2)
        <=> $true )
        & ( v3177(VarCurr,bitIndex1)
        <=> $false )
        & ( v3177(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_182,axiom,
    ! [VarCurr] :
      ( ~ v8635(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v8634(VarCurr,B)
          <=> v8644(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_174,axiom,
    ! [VarCurr] :
      ( v8635(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v8634(VarCurr,B)
          <=> v8636(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_181,axiom,
    ! [VarCurr] :
      ( ~ v8645(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v8644(VarCurr,B)
          <=> v8647(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_173,axiom,
    ! [VarCurr] :
      ( v8645(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v8644(VarCurr,B)
          <=> b001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_180,axiom,
    ! [VarCurr] :
      ( ~ v8648(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v8647(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_172,axiom,
    ! [VarCurr] :
      ( v8648(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v8647(VarCurr,B)
          <=> b001(B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_597,axiom,
    ! [VarCurr] :
      ( v8649(VarCurr)
    <=> ( v3181(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_596,axiom,
    ! [VarCurr] :
      ( v8648(VarCurr)
    <=> ( v3181(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_595,axiom,
    ! [VarCurr] :
      ( v8646(VarCurr)
    <=> ( v5276(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_594,axiom,
    ! [VarCurr] :
      ( v8645(VarCurr)
    <=> ( v5276(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_593,axiom,
    ! [VarCurr] :
      ( v8643(VarCurr)
    <=> ( v3173(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_71,axiom,
    ! [VarCurr] :
      ( ( ~ v8637(VarCurr)
        & ~ v8640(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v8636(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_179,axiom,
    ! [VarCurr] :
      ( v8640(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v8636(VarCurr,B)
          <=> v8642(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_171,axiom,
    ! [VarCurr] :
      ( v8637(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v8636(VarCurr,B)
          <=> v8639(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_208,axiom,
    ! [VarCurr] :
      ( ~ v5323(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v8642(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_211,axiom,
    ! [VarCurr] :
      ( v5323(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v8642(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_592,axiom,
    ! [VarCurr] :
      ( v8640(VarCurr)
    <=> ( ( v8641(VarCurr,bitIndex1)
        <=> $true )
        & ( v8641(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1932,axiom,
    ! [VarCurr] :
      ( v8641(VarCurr,bitIndex0)
    <=> v4693(VarCurr) ) ).

fof(addAssignment_1931,axiom,
    ! [VarCurr] :
      ( v8641(VarCurr,bitIndex1)
    <=> v4666(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_207,axiom,
    ! [VarCurr] :
      ( ~ v6630(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v8639(VarCurr,B)
          <=> b100(B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_210,axiom,
    ! [VarCurr] :
      ( v6630(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v8639(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_591,axiom,
    ! [VarCurr] :
      ( v8637(VarCurr)
    <=> ( ( v8638(VarCurr,bitIndex1)
        <=> $false )
        & ( v8638(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1930,axiom,
    ! [VarCurr] :
      ( v8638(VarCurr,bitIndex0)
    <=> v4693(VarCurr) ) ).

fof(addAssignment_1929,axiom,
    ! [VarCurr] :
      ( v8638(VarCurr,bitIndex1)
    <=> v4666(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_590,axiom,
    ! [VarCurr] :
      ( v8635(VarCurr)
    <=> ( v3173(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_589,axiom,
    ! [VarCurr] :
      ( v8633(VarCurr)
    <=> ( ( v3177(VarCurr,bitIndex2)
        <=> $false )
        & ( v3177(VarCurr,bitIndex1)
        <=> $true )
        & ( v3177(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_178,axiom,
    ! [VarCurr] :
      ( ~ v8631(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v8630(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_170,axiom,
    ! [VarCurr] :
      ( v8631(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v8630(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_588,axiom,
    ! [VarCurr] :
      ( v8632(VarCurr)
    <=> ( v2990(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_587,axiom,
    ! [VarCurr] :
      ( v8631(VarCurr)
    <=> ( v2990(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_586,axiom,
    ! [VarCurr] :
      ( v8629(VarCurr)
    <=> ( ( v3177(VarCurr,bitIndex2)
        <=> $false )
        & ( v3177(VarCurr,bitIndex1)
        <=> $true )
        & ( v3177(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_177,axiom,
    ! [VarCurr] :
      ( ~ v8626(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v8625(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_169,axiom,
    ! [VarCurr] :
      ( v8626(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v8625(VarCurr,B)
          <=> v8627(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_585,axiom,
    ! [VarCurr] :
      ( v8628(VarCurr)
    <=> ( v3173(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_206,axiom,
    ! [VarCurr] :
      ( ~ v5621(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v8627(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_209,axiom,
    ! [VarCurr] :
      ( v5621(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v8627(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_584,axiom,
    ! [VarCurr] :
      ( v8626(VarCurr)
    <=> ( v3173(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_583,axiom,
    ! [VarCurr] :
      ( v8624(VarCurr)
    <=> ( ( v3177(VarCurr,bitIndex2)
        <=> $false )
        & ( v3177(VarCurr,bitIndex1)
        <=> $false )
        & ( v3177(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_176,axiom,
    ! [VarCurr] :
      ( ~ v8622(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v8621(VarCurr,B)
          <=> b001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_168,axiom,
    ! [VarCurr] :
      ( v8622(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v8621(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_582,axiom,
    ! [VarCurr] :
      ( v8623(VarCurr)
    <=> ( v3181(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_581,axiom,
    ! [VarCurr] :
      ( v8622(VarCurr)
    <=> ( v3181(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_580,axiom,
    ! [VarCurr] :
      ( v8620(VarCurr)
    <=> ( ( v3177(VarCurr,bitIndex2)
        <=> $false )
        & ( v3177(VarCurr,bitIndex1)
        <=> $false )
        & ( v3177(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1619,axiom,
    ! [VarCurr] :
      ( v3181(VarCurr)
    <=> ( v3183(VarCurr)
        | v4662(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_137,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8604(VarNext)
       => ( v4662(VarNext)
        <=> v4662(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_144,axiom,
    ! [VarNext] :
      ( v8604(VarNext)
     => ( v4662(VarNext)
      <=> v8612(VarNext) ) ) ).

fof(addAssignment_1928,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8612(VarNext)
      <=> v8610(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_205,axiom,
    ! [VarCurr] :
      ( ~ v5393(VarCurr)
     => ( v8610(VarCurr)
      <=> v8613(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_208,axiom,
    ! [VarCurr] :
      ( v5393(VarCurr)
     => ( v8610(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_204,axiom,
    ! [VarCurr] :
      ( ~ v3183(VarCurr)
     => ( v8613(VarCurr)
      <=> v8614(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_207,axiom,
    ! [VarCurr] :
      ( v3183(VarCurr)
     => ( v8613(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1618,axiom,
    ! [VarCurr] :
      ( v8614(VarCurr)
    <=> ( v8615(VarCurr)
        & v4662(VarCurr) ) ) ).

fof(writeUnaryOperator_766,axiom,
    ! [VarCurr] :
      ( ~ v8615(VarCurr)
    <=> v4664(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1617,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8604(VarNext)
      <=> v8605(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1616,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8605(VarNext)
      <=> ( v8607(VarNext)
          & v179(VarNext) ) ) ) ).

fof(writeUnaryOperator_765,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8607(VarNext)
      <=> v4675(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_32,axiom,
    ! [VarCurr] :
      ( ( ~ v8598(VarCurr)
        & ~ v5337(VarCurr)
        & ~ v5349(VarCurr) )
     => ( v4664(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_70,axiom,
    ! [VarCurr] :
      ( v5349(VarCurr)
     => ( v4664(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_175,axiom,
    ! [VarCurr] :
      ( v5337(VarCurr)
     => ( v4664(VarCurr)
      <=> v8599(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_167,axiom,
    ! [VarCurr] :
      ( v8598(VarCurr)
     => ( v4664(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_174,axiom,
    ! [VarCurr] :
      ( ~ v5339(VarCurr)
     => ( v8599(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_166,axiom,
    ! [VarCurr] :
      ( v5339(VarCurr)
     => ( v8599(VarCurr)
      <=> v8600(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_173,axiom,
    ! [VarCurr] :
      ( ~ v8601(VarCurr)
     => ( v8600(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_165,axiom,
    ! [VarCurr] :
      ( v8601(VarCurr)
     => ( v8600(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1615,axiom,
    ! [VarCurr] :
      ( v8601(VarCurr)
    <=> ( v5341(VarCurr)
        | v5343(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1614,axiom,
    ! [VarCurr] :
      ( v8598(VarCurr)
    <=> ( v5333(VarCurr)
        | v5336(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_203,axiom,
    ! [VarCurr] :
      ( ~ v8467(VarCurr)
     => ( v4666(VarCurr)
      <=> v8594(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_206,axiom,
    ! [VarCurr] :
      ( v8467(VarCurr)
     => ( v4666(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_172,axiom,
    ! [VarCurr] :
      ( ~ v8469(VarCurr)
     => ( v8594(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_164,axiom,
    ! [VarCurr] :
      ( v8469(VarCurr)
     => ( v8594(VarCurr)
      <=> v8595(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_202,axiom,
    ! [VarCurr] :
      ( ~ v8475(VarCurr)
     => ( v8595(VarCurr)
      <=> v8596(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_205,axiom,
    ! [VarCurr] :
      ( v8475(VarCurr)
     => ( v8595(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_201,axiom,
    ! [VarCurr] :
      ( ~ v8477(VarCurr)
     => ( v8596(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_204,axiom,
    ! [VarCurr] :
      ( v8477(VarCurr)
     => ( v8596(VarCurr)
      <=> $false ) ) ).

fof(addCaseBooleanConditionEqualRanges1_136,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8582(VarNext)
       => ( v4689(VarNext)
        <=> v4689(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_143,axiom,
    ! [VarNext] :
      ( v8582(VarNext)
     => ( v4689(VarNext)
      <=> v8590(VarNext) ) ) ).

fof(addAssignment_1927,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8590(VarNext)
      <=> v8588(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_200,axiom,
    ! [VarCurr] :
      ( ~ v5393(VarCurr)
     => ( v8588(VarCurr)
      <=> v4691(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_203,axiom,
    ! [VarCurr] :
      ( v5393(VarCurr)
     => ( v8588(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1613,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8582(VarNext)
      <=> v8583(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1612,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8583(VarNext)
      <=> ( v8585(VarNext)
          & v179(VarNext) ) ) ) ).

fof(writeUnaryOperator_764,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8585(VarNext)
      <=> v4675(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_6,axiom,
    ! [VarCurr] :
      ( ( ~ v5334(VarCurr)
        & ~ v8575(VarCurr)
        & ~ v5337(VarCurr)
        & ~ v5349(VarCurr) )
     => ( v4691(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_31,axiom,
    ! [VarCurr] :
      ( v5349(VarCurr)
     => ( v4691(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_69,axiom,
    ! [VarCurr] :
      ( v5337(VarCurr)
     => ( v4691(VarCurr)
      <=> v8577(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_171,axiom,
    ! [VarCurr] :
      ( v8575(VarCurr)
     => ( v4691(VarCurr)
      <=> v8576(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_163,axiom,
    ! [VarCurr] :
      ( v5334(VarCurr)
     => ( v4691(VarCurr)
      <=> v8572(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_170,axiom,
    ! [VarCurr] :
      ( ~ v5339(VarCurr)
     => ( v8577(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_162,axiom,
    ! [VarCurr] :
      ( v5339(VarCurr)
     => ( v8577(VarCurr)
      <=> v8578(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_169,axiom,
    ! [VarCurr] :
      ( ~ v8579(VarCurr)
     => ( v8578(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_161,axiom,
    ! [VarCurr] :
      ( v8579(VarCurr)
     => ( v8578(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1611,axiom,
    ! [VarCurr] :
      ( v8579(VarCurr)
    <=> ( v5341(VarCurr)
        | v5343(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_168,axiom,
    ! [VarCurr] :
      ( ~ v6290(VarCurr)
     => ( v8576(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_160,axiom,
    ! [VarCurr] :
      ( v6290(VarCurr)
     => ( v8576(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1610,axiom,
    ! [VarCurr] :
      ( v8575(VarCurr)
    <=> ( v5335(VarCurr)
        | v5336(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_167,axiom,
    ! [VarCurr] :
      ( ~ v8573(VarCurr)
     => ( v8572(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_159,axiom,
    ! [VarCurr] :
      ( v8573(VarCurr)
     => ( v8572(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_579,axiom,
    ! [VarCurr] :
      ( v8574(VarCurr)
    <=> ( v3181(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_578,axiom,
    ! [VarCurr] :
      ( v8573(VarCurr)
    <=> ( v3181(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_199,axiom,
    ! [VarCurr] :
      ( ~ v8467(VarCurr)
     => ( v4693(VarCurr)
      <=> v8468(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_202,axiom,
    ! [VarCurr] :
      ( v8467(VarCurr)
     => ( v4693(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_166,axiom,
    ! [VarCurr] :
      ( ~ v8469(VarCurr)
     => ( v8468(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_158,axiom,
    ! [VarCurr] :
      ( v8469(VarCurr)
     => ( v8468(VarCurr)
      <=> v8474(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_198,axiom,
    ! [VarCurr] :
      ( ~ v8475(VarCurr)
     => ( v8474(VarCurr)
      <=> v8476(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_201,axiom,
    ! [VarCurr] :
      ( v8475(VarCurr)
     => ( v8474(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_197,axiom,
    ! [VarCurr] :
      ( ~ v8477(VarCurr)
     => ( v8476(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_200,axiom,
    ! [VarCurr] :
      ( v8477(VarCurr)
     => ( v8476(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1609,axiom,
    ! [VarCurr] :
      ( v8477(VarCurr)
    <=> ( v8478(VarCurr)
        & v8513(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_577,axiom,
    ! [VarCurr] :
      ( v8513(VarCurr)
    <=> ( v8514(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges31_1,axiom,
    ! [VarCurr] :
      ( ( ~ v8539(VarCurr)
        & ~ v8540(VarCurr)
        & ~ v8541(VarCurr)
        & ~ v8542(VarCurr)
        & ~ v8543(VarCurr)
        & ~ v8544(VarCurr)
        & ~ v8545(VarCurr)
        & ~ v8546(VarCurr)
        & ~ v8547(VarCurr)
        & ~ v8548(VarCurr)
        & ~ v8549(VarCurr)
        & ~ v8550(VarCurr)
        & ~ v8551(VarCurr)
        & ~ v8552(VarCurr)
        & ~ v8553(VarCurr)
        & ~ v8554(VarCurr)
        & ~ v8555(VarCurr)
        & ~ v8556(VarCurr)
        & ~ v8557(VarCurr)
        & ~ v8558(VarCurr)
        & ~ v8559(VarCurr)
        & ~ v8560(VarCurr)
        & ~ v8561(VarCurr)
        & ~ v8562(VarCurr)
        & ~ v8563(VarCurr)
        & ~ v8564(VarCurr)
        & ~ v8565(VarCurr)
        & ~ v8566(VarCurr)
        & ~ v8567(VarCurr)
        & ~ v8568(VarCurr)
        & ~ v8569(VarCurr) )
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex31) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges30_1,axiom,
    ! [VarCurr] :
      ( v8569(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex30) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges29_1,axiom,
    ! [VarCurr] :
      ( v8568(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex29) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges28_1,axiom,
    ! [VarCurr] :
      ( v8567(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex28) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges27_1,axiom,
    ! [VarCurr] :
      ( v8566(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex27) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges26_1,axiom,
    ! [VarCurr] :
      ( v8565(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex26) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges25_1,axiom,
    ! [VarCurr] :
      ( v8564(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex25) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges24_1,axiom,
    ! [VarCurr] :
      ( v8563(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex24) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges23_1,axiom,
    ! [VarCurr] :
      ( v8562(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex23) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges22_1,axiom,
    ! [VarCurr] :
      ( v8561(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex22) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges21_1,axiom,
    ! [VarCurr] :
      ( v8560(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex21) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges20_1,axiom,
    ! [VarCurr] :
      ( v8559(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex20) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges19_1,axiom,
    ! [VarCurr] :
      ( v8558(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex19) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges18_1,axiom,
    ! [VarCurr] :
      ( v8557(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex18) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges17_1,axiom,
    ! [VarCurr] :
      ( v8556(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex17) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges16_1,axiom,
    ! [VarCurr] :
      ( v8555(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex16) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges15_1,axiom,
    ! [VarCurr] :
      ( v8554(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex15) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges14_1,axiom,
    ! [VarCurr] :
      ( v8553(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex14) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges13_1,axiom,
    ! [VarCurr] :
      ( v8552(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex13) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges12_1,axiom,
    ! [VarCurr] :
      ( v8551(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex12) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges11_1,axiom,
    ! [VarCurr] :
      ( v8550(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex11) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges10_1,axiom,
    ! [VarCurr] :
      ( v8549(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex10) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges9_1,axiom,
    ! [VarCurr] :
      ( v8548(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex9) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges8_1,axiom,
    ! [VarCurr] :
      ( v8547(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex8) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges7_1,axiom,
    ! [VarCurr] :
      ( v8546(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex7) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges6_1,axiom,
    ! [VarCurr] :
      ( v8545(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex6) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges5_1,axiom,
    ! [VarCurr] :
      ( v8544(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex5) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges4_1,axiom,
    ! [VarCurr] :
      ( v8543(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex4) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges3_1,axiom,
    ! [VarCurr] :
      ( v8542(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex3) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges2_1,axiom,
    ! [VarCurr] :
      ( v8541(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex2) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges1_1,axiom,
    ! [VarCurr] :
      ( v8540(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex1) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_157,axiom,
    ! [VarCurr] :
      ( v8539(VarCurr)
     => ( v8514(VarCurr)
      <=> v4919(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_576,axiom,
    ! [VarCurr] :
      ( v8570(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $true )
        & ( v8516(VarCurr,bitIndex3)
        <=> $true )
        & ( v8516(VarCurr,bitIndex2)
        <=> $true )
        & ( v8516(VarCurr,bitIndex1)
        <=> $true )
        & ( v8516(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_575,axiom,
    ! [VarCurr] :
      ( v8569(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $true )
        & ( v8516(VarCurr,bitIndex3)
        <=> $true )
        & ( v8516(VarCurr,bitIndex2)
        <=> $true )
        & ( v8516(VarCurr,bitIndex1)
        <=> $true )
        & ( v8516(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_574,axiom,
    ! [VarCurr] :
      ( v8568(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $true )
        & ( v8516(VarCurr,bitIndex3)
        <=> $true )
        & ( v8516(VarCurr,bitIndex2)
        <=> $true )
        & ( v8516(VarCurr,bitIndex1)
        <=> $false )
        & ( v8516(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_573,axiom,
    ! [VarCurr] :
      ( v8567(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $true )
        & ( v8516(VarCurr,bitIndex3)
        <=> $true )
        & ( v8516(VarCurr,bitIndex2)
        <=> $true )
        & ( v8516(VarCurr,bitIndex1)
        <=> $false )
        & ( v8516(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_572,axiom,
    ! [VarCurr] :
      ( v8566(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $true )
        & ( v8516(VarCurr,bitIndex3)
        <=> $true )
        & ( v8516(VarCurr,bitIndex2)
        <=> $false )
        & ( v8516(VarCurr,bitIndex1)
        <=> $true )
        & ( v8516(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_571,axiom,
    ! [VarCurr] :
      ( v8565(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $true )
        & ( v8516(VarCurr,bitIndex3)
        <=> $true )
        & ( v8516(VarCurr,bitIndex2)
        <=> $false )
        & ( v8516(VarCurr,bitIndex1)
        <=> $true )
        & ( v8516(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_570,axiom,
    ! [VarCurr] :
      ( v8564(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $true )
        & ( v8516(VarCurr,bitIndex3)
        <=> $true )
        & ( v8516(VarCurr,bitIndex2)
        <=> $false )
        & ( v8516(VarCurr,bitIndex1)
        <=> $false )
        & ( v8516(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_569,axiom,
    ! [VarCurr] :
      ( v8563(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $true )
        & ( v8516(VarCurr,bitIndex3)
        <=> $true )
        & ( v8516(VarCurr,bitIndex2)
        <=> $false )
        & ( v8516(VarCurr,bitIndex1)
        <=> $false )
        & ( v8516(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_568,axiom,
    ! [VarCurr] :
      ( v8562(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $true )
        & ( v8516(VarCurr,bitIndex3)
        <=> $false )
        & ( v8516(VarCurr,bitIndex2)
        <=> $true )
        & ( v8516(VarCurr,bitIndex1)
        <=> $true )
        & ( v8516(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_567,axiom,
    ! [VarCurr] :
      ( v8561(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $true )
        & ( v8516(VarCurr,bitIndex3)
        <=> $false )
        & ( v8516(VarCurr,bitIndex2)
        <=> $true )
        & ( v8516(VarCurr,bitIndex1)
        <=> $true )
        & ( v8516(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_566,axiom,
    ! [VarCurr] :
      ( v8560(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $true )
        & ( v8516(VarCurr,bitIndex3)
        <=> $false )
        & ( v8516(VarCurr,bitIndex2)
        <=> $true )
        & ( v8516(VarCurr,bitIndex1)
        <=> $false )
        & ( v8516(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_565,axiom,
    ! [VarCurr] :
      ( v8559(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $true )
        & ( v8516(VarCurr,bitIndex3)
        <=> $false )
        & ( v8516(VarCurr,bitIndex2)
        <=> $true )
        & ( v8516(VarCurr,bitIndex1)
        <=> $false )
        & ( v8516(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_564,axiom,
    ! [VarCurr] :
      ( v8558(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $true )
        & ( v8516(VarCurr,bitIndex3)
        <=> $false )
        & ( v8516(VarCurr,bitIndex2)
        <=> $false )
        & ( v8516(VarCurr,bitIndex1)
        <=> $true )
        & ( v8516(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_563,axiom,
    ! [VarCurr] :
      ( v8557(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $true )
        & ( v8516(VarCurr,bitIndex3)
        <=> $false )
        & ( v8516(VarCurr,bitIndex2)
        <=> $false )
        & ( v8516(VarCurr,bitIndex1)
        <=> $true )
        & ( v8516(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_562,axiom,
    ! [VarCurr] :
      ( v8556(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $true )
        & ( v8516(VarCurr,bitIndex3)
        <=> $false )
        & ( v8516(VarCurr,bitIndex2)
        <=> $false )
        & ( v8516(VarCurr,bitIndex1)
        <=> $false )
        & ( v8516(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_561,axiom,
    ! [VarCurr] :
      ( v8555(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $true )
        & ( v8516(VarCurr,bitIndex3)
        <=> $false )
        & ( v8516(VarCurr,bitIndex2)
        <=> $false )
        & ( v8516(VarCurr,bitIndex1)
        <=> $false )
        & ( v8516(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_560,axiom,
    ! [VarCurr] :
      ( v8554(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $false )
        & ( v8516(VarCurr,bitIndex3)
        <=> $true )
        & ( v8516(VarCurr,bitIndex2)
        <=> $true )
        & ( v8516(VarCurr,bitIndex1)
        <=> $true )
        & ( v8516(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_559,axiom,
    ! [VarCurr] :
      ( v8553(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $false )
        & ( v8516(VarCurr,bitIndex3)
        <=> $true )
        & ( v8516(VarCurr,bitIndex2)
        <=> $true )
        & ( v8516(VarCurr,bitIndex1)
        <=> $true )
        & ( v8516(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_558,axiom,
    ! [VarCurr] :
      ( v8552(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $false )
        & ( v8516(VarCurr,bitIndex3)
        <=> $true )
        & ( v8516(VarCurr,bitIndex2)
        <=> $true )
        & ( v8516(VarCurr,bitIndex1)
        <=> $false )
        & ( v8516(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_557,axiom,
    ! [VarCurr] :
      ( v8551(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $false )
        & ( v8516(VarCurr,bitIndex3)
        <=> $true )
        & ( v8516(VarCurr,bitIndex2)
        <=> $true )
        & ( v8516(VarCurr,bitIndex1)
        <=> $false )
        & ( v8516(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_556,axiom,
    ! [VarCurr] :
      ( v8550(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $false )
        & ( v8516(VarCurr,bitIndex3)
        <=> $true )
        & ( v8516(VarCurr,bitIndex2)
        <=> $false )
        & ( v8516(VarCurr,bitIndex1)
        <=> $true )
        & ( v8516(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_555,axiom,
    ! [VarCurr] :
      ( v8549(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $false )
        & ( v8516(VarCurr,bitIndex3)
        <=> $true )
        & ( v8516(VarCurr,bitIndex2)
        <=> $false )
        & ( v8516(VarCurr,bitIndex1)
        <=> $true )
        & ( v8516(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_554,axiom,
    ! [VarCurr] :
      ( v8548(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $false )
        & ( v8516(VarCurr,bitIndex3)
        <=> $true )
        & ( v8516(VarCurr,bitIndex2)
        <=> $false )
        & ( v8516(VarCurr,bitIndex1)
        <=> $false )
        & ( v8516(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_553,axiom,
    ! [VarCurr] :
      ( v8547(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $false )
        & ( v8516(VarCurr,bitIndex3)
        <=> $true )
        & ( v8516(VarCurr,bitIndex2)
        <=> $false )
        & ( v8516(VarCurr,bitIndex1)
        <=> $false )
        & ( v8516(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_552,axiom,
    ! [VarCurr] :
      ( v8546(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $false )
        & ( v8516(VarCurr,bitIndex3)
        <=> $false )
        & ( v8516(VarCurr,bitIndex2)
        <=> $true )
        & ( v8516(VarCurr,bitIndex1)
        <=> $true )
        & ( v8516(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_551,axiom,
    ! [VarCurr] :
      ( v8545(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $false )
        & ( v8516(VarCurr,bitIndex3)
        <=> $false )
        & ( v8516(VarCurr,bitIndex2)
        <=> $true )
        & ( v8516(VarCurr,bitIndex1)
        <=> $true )
        & ( v8516(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_550,axiom,
    ! [VarCurr] :
      ( v8544(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $false )
        & ( v8516(VarCurr,bitIndex3)
        <=> $false )
        & ( v8516(VarCurr,bitIndex2)
        <=> $true )
        & ( v8516(VarCurr,bitIndex1)
        <=> $false )
        & ( v8516(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_549,axiom,
    ! [VarCurr] :
      ( v8543(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $false )
        & ( v8516(VarCurr,bitIndex3)
        <=> $false )
        & ( v8516(VarCurr,bitIndex2)
        <=> $true )
        & ( v8516(VarCurr,bitIndex1)
        <=> $false )
        & ( v8516(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_548,axiom,
    ! [VarCurr] :
      ( v8542(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $false )
        & ( v8516(VarCurr,bitIndex3)
        <=> $false )
        & ( v8516(VarCurr,bitIndex2)
        <=> $false )
        & ( v8516(VarCurr,bitIndex1)
        <=> $true )
        & ( v8516(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_547,axiom,
    ! [VarCurr] :
      ( v8541(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $false )
        & ( v8516(VarCurr,bitIndex3)
        <=> $false )
        & ( v8516(VarCurr,bitIndex2)
        <=> $false )
        & ( v8516(VarCurr,bitIndex1)
        <=> $true )
        & ( v8516(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_546,axiom,
    ! [VarCurr] :
      ( v8540(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $false )
        & ( v8516(VarCurr,bitIndex3)
        <=> $false )
        & ( v8516(VarCurr,bitIndex2)
        <=> $false )
        & ( v8516(VarCurr,bitIndex1)
        <=> $false )
        & ( v8516(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_545,axiom,
    ! [VarCurr] :
      ( v8539(VarCurr)
    <=> ( ( v8516(VarCurr,bitIndex4)
        <=> $false )
        & ( v8516(VarCurr,bitIndex3)
        <=> $false )
        & ( v8516(VarCurr,bitIndex2)
        <=> $false )
        & ( v8516(VarCurr,bitIndex1)
        <=> $false )
        & ( v8516(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1926,axiom,
    ! [VarCurr] :
      ( v8516(VarCurr,bitIndex0)
    <=> v7867(VarCurr) ) ).

fof(addAssignment_1925,axiom,
    ! [VarCurr] :
      ( v8516(VarCurr,bitIndex1)
    <=> v8536(VarCurr) ) ).

fof(addAssignment_1924,axiom,
    ! [VarCurr] :
      ( v8516(VarCurr,bitIndex2)
    <=> v8532(VarCurr) ) ).

fof(addAssignment_1923,axiom,
    ! [VarCurr] :
      ( v8516(VarCurr,bitIndex3)
    <=> v8528(VarCurr) ) ).

fof(addAssignment_1922,axiom,
    ! [VarCurr] :
      ( v8516(VarCurr,bitIndex4)
    <=> v8518(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1608,axiom,
    ! [VarCurr] :
      ( v8536(VarCurr)
    <=> ( v8537(VarCurr)
        & v8538(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1607,axiom,
    ! [VarCurr] :
      ( v8538(VarCurr)
    <=> ( v4695(VarCurr,bitIndex0)
        | v7827(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_362,axiom,
    ! [VarCurr] :
      ( v8537(VarCurr)
    <=> ( v7867(VarCurr)
        | v4695(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1606,axiom,
    ! [VarCurr] :
      ( v8532(VarCurr)
    <=> ( v8533(VarCurr)
        & v8535(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1605,axiom,
    ! [VarCurr] :
      ( v8535(VarCurr)
    <=> ( v7833(VarCurr)
        | v8525(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_361,axiom,
    ! [VarCurr] :
      ( v8533(VarCurr)
    <=> ( v4695(VarCurr,bitIndex2)
        | v8534(VarCurr) ) ) ).

fof(writeUnaryOperator_763,axiom,
    ! [VarCurr] :
      ( ~ v8534(VarCurr)
    <=> v8525(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1604,axiom,
    ! [VarCurr] :
      ( v8528(VarCurr)
    <=> ( v8529(VarCurr)
        & v8531(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1603,axiom,
    ! [VarCurr] :
      ( v8531(VarCurr)
    <=> ( v7839(VarCurr)
        | v8523(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_360,axiom,
    ! [VarCurr] :
      ( v8529(VarCurr)
    <=> ( v4695(VarCurr,bitIndex3)
        | v8530(VarCurr) ) ) ).

fof(writeUnaryOperator_762,axiom,
    ! [VarCurr] :
      ( ~ v8530(VarCurr)
    <=> v8523(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1602,axiom,
    ! [VarCurr] :
      ( v8518(VarCurr)
    <=> ( v8519(VarCurr)
        & v8527(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1601,axiom,
    ! [VarCurr] :
      ( v8527(VarCurr)
    <=> ( v7846(VarCurr)
        | v8521(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_359,axiom,
    ! [VarCurr] :
      ( v8519(VarCurr)
    <=> ( v4695(VarCurr,bitIndex4)
        | v8520(VarCurr) ) ) ).

fof(writeUnaryOperator_761,axiom,
    ! [VarCurr] :
      ( ~ v8520(VarCurr)
    <=> v8521(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_358,axiom,
    ! [VarCurr] :
      ( v8521(VarCurr)
    <=> ( v4695(VarCurr,bitIndex3)
        | v8522(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1600,axiom,
    ! [VarCurr] :
      ( v8522(VarCurr)
    <=> ( v7839(VarCurr)
        & v8523(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_357,axiom,
    ! [VarCurr] :
      ( v8523(VarCurr)
    <=> ( v4695(VarCurr,bitIndex2)
        | v8524(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1599,axiom,
    ! [VarCurr] :
      ( v8524(VarCurr)
    <=> ( v7833(VarCurr)
        & v8525(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_356,axiom,
    ! [VarCurr] :
      ( v8525(VarCurr)
    <=> ( v4695(VarCurr,bitIndex1)
        | v8526(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1598,axiom,
    ! [VarCurr] :
      ( v8526(VarCurr)
    <=> ( v4695(VarCurr,bitIndex0)
        & v7827(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_544,axiom,
    ! [VarCurr] :
      ( v8478(VarCurr)
    <=> ( v8479(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges31,axiom,
    ! [VarCurr] :
      ( ( ~ v8481(VarCurr)
        & ~ v8482(VarCurr)
        & ~ v8483(VarCurr)
        & ~ v8484(VarCurr)
        & ~ v8485(VarCurr)
        & ~ v8486(VarCurr)
        & ~ v8487(VarCurr)
        & ~ v8488(VarCurr)
        & ~ v8489(VarCurr)
        & ~ v8490(VarCurr)
        & ~ v8491(VarCurr)
        & ~ v8492(VarCurr)
        & ~ v8493(VarCurr)
        & ~ v8494(VarCurr)
        & ~ v8495(VarCurr)
        & ~ v8496(VarCurr)
        & ~ v8497(VarCurr)
        & ~ v8498(VarCurr)
        & ~ v8499(VarCurr)
        & ~ v8500(VarCurr)
        & ~ v8501(VarCurr)
        & ~ v8502(VarCurr)
        & ~ v8503(VarCurr)
        & ~ v8504(VarCurr)
        & ~ v8505(VarCurr)
        & ~ v8506(VarCurr)
        & ~ v8507(VarCurr)
        & ~ v8508(VarCurr)
        & ~ v8509(VarCurr)
        & ~ v8510(VarCurr)
        & ~ v8511(VarCurr) )
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex31) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges30,axiom,
    ! [VarCurr] :
      ( v8511(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex30) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges29,axiom,
    ! [VarCurr] :
      ( v8510(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex29) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges28,axiom,
    ! [VarCurr] :
      ( v8509(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex28) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges27,axiom,
    ! [VarCurr] :
      ( v8508(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex27) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges26,axiom,
    ! [VarCurr] :
      ( v8507(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex26) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges25,axiom,
    ! [VarCurr] :
      ( v8506(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex25) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges24,axiom,
    ! [VarCurr] :
      ( v8505(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex24) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges23,axiom,
    ! [VarCurr] :
      ( v8504(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex23) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges22,axiom,
    ! [VarCurr] :
      ( v8503(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex22) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges21,axiom,
    ! [VarCurr] :
      ( v8502(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex21) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges20,axiom,
    ! [VarCurr] :
      ( v8501(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex20) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges19,axiom,
    ! [VarCurr] :
      ( v8500(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex19) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges18,axiom,
    ! [VarCurr] :
      ( v8499(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex18) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges17,axiom,
    ! [VarCurr] :
      ( v8498(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex17) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges16,axiom,
    ! [VarCurr] :
      ( v8497(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex16) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges15,axiom,
    ! [VarCurr] :
      ( v8496(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex15) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges14,axiom,
    ! [VarCurr] :
      ( v8495(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex14) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges13,axiom,
    ! [VarCurr] :
      ( v8494(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex13) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges12,axiom,
    ! [VarCurr] :
      ( v8493(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex12) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges11,axiom,
    ! [VarCurr] :
      ( v8492(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex11) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges10,axiom,
    ! [VarCurr] :
      ( v8491(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex10) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges9,axiom,
    ! [VarCurr] :
      ( v8490(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex9) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges8,axiom,
    ! [VarCurr] :
      ( v8489(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex8) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges7,axiom,
    ! [VarCurr] :
      ( v8488(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex7) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges6,axiom,
    ! [VarCurr] :
      ( v8487(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex6) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges5,axiom,
    ! [VarCurr] :
      ( v8486(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex5) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges4,axiom,
    ! [VarCurr] :
      ( v8485(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex4) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges3,axiom,
    ! [VarCurr] :
      ( v8484(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex3) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges2,axiom,
    ! [VarCurr] :
      ( v8483(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex2) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges1,axiom,
    ! [VarCurr] :
      ( v8482(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex1) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_156,axiom,
    ! [VarCurr] :
      ( v8481(VarCurr)
     => ( v8479(VarCurr)
      <=> v4919(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_543,axiom,
    ! [VarCurr] :
      ( v8512(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $true )
        & ( v4695(VarCurr,bitIndex3)
        <=> $true )
        & ( v4695(VarCurr,bitIndex2)
        <=> $true )
        & ( v4695(VarCurr,bitIndex1)
        <=> $true )
        & ( v4695(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_542,axiom,
    ! [VarCurr] :
      ( v8511(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $true )
        & ( v4695(VarCurr,bitIndex3)
        <=> $true )
        & ( v4695(VarCurr,bitIndex2)
        <=> $true )
        & ( v4695(VarCurr,bitIndex1)
        <=> $true )
        & ( v4695(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_541,axiom,
    ! [VarCurr] :
      ( v8510(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $true )
        & ( v4695(VarCurr,bitIndex3)
        <=> $true )
        & ( v4695(VarCurr,bitIndex2)
        <=> $true )
        & ( v4695(VarCurr,bitIndex1)
        <=> $false )
        & ( v4695(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_540,axiom,
    ! [VarCurr] :
      ( v8509(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $true )
        & ( v4695(VarCurr,bitIndex3)
        <=> $true )
        & ( v4695(VarCurr,bitIndex2)
        <=> $true )
        & ( v4695(VarCurr,bitIndex1)
        <=> $false )
        & ( v4695(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_539,axiom,
    ! [VarCurr] :
      ( v8508(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $true )
        & ( v4695(VarCurr,bitIndex3)
        <=> $true )
        & ( v4695(VarCurr,bitIndex2)
        <=> $false )
        & ( v4695(VarCurr,bitIndex1)
        <=> $true )
        & ( v4695(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_538,axiom,
    ! [VarCurr] :
      ( v8507(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $true )
        & ( v4695(VarCurr,bitIndex3)
        <=> $true )
        & ( v4695(VarCurr,bitIndex2)
        <=> $false )
        & ( v4695(VarCurr,bitIndex1)
        <=> $true )
        & ( v4695(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_537,axiom,
    ! [VarCurr] :
      ( v8506(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $true )
        & ( v4695(VarCurr,bitIndex3)
        <=> $true )
        & ( v4695(VarCurr,bitIndex2)
        <=> $false )
        & ( v4695(VarCurr,bitIndex1)
        <=> $false )
        & ( v4695(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_536,axiom,
    ! [VarCurr] :
      ( v8505(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $true )
        & ( v4695(VarCurr,bitIndex3)
        <=> $true )
        & ( v4695(VarCurr,bitIndex2)
        <=> $false )
        & ( v4695(VarCurr,bitIndex1)
        <=> $false )
        & ( v4695(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_535,axiom,
    ! [VarCurr] :
      ( v8504(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $true )
        & ( v4695(VarCurr,bitIndex3)
        <=> $false )
        & ( v4695(VarCurr,bitIndex2)
        <=> $true )
        & ( v4695(VarCurr,bitIndex1)
        <=> $true )
        & ( v4695(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_534,axiom,
    ! [VarCurr] :
      ( v8503(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $true )
        & ( v4695(VarCurr,bitIndex3)
        <=> $false )
        & ( v4695(VarCurr,bitIndex2)
        <=> $true )
        & ( v4695(VarCurr,bitIndex1)
        <=> $true )
        & ( v4695(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_533,axiom,
    ! [VarCurr] :
      ( v8502(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $true )
        & ( v4695(VarCurr,bitIndex3)
        <=> $false )
        & ( v4695(VarCurr,bitIndex2)
        <=> $true )
        & ( v4695(VarCurr,bitIndex1)
        <=> $false )
        & ( v4695(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_532,axiom,
    ! [VarCurr] :
      ( v8501(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $true )
        & ( v4695(VarCurr,bitIndex3)
        <=> $false )
        & ( v4695(VarCurr,bitIndex2)
        <=> $true )
        & ( v4695(VarCurr,bitIndex1)
        <=> $false )
        & ( v4695(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_531,axiom,
    ! [VarCurr] :
      ( v8500(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $true )
        & ( v4695(VarCurr,bitIndex3)
        <=> $false )
        & ( v4695(VarCurr,bitIndex2)
        <=> $false )
        & ( v4695(VarCurr,bitIndex1)
        <=> $true )
        & ( v4695(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_530,axiom,
    ! [VarCurr] :
      ( v8499(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $true )
        & ( v4695(VarCurr,bitIndex3)
        <=> $false )
        & ( v4695(VarCurr,bitIndex2)
        <=> $false )
        & ( v4695(VarCurr,bitIndex1)
        <=> $true )
        & ( v4695(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_529,axiom,
    ! [VarCurr] :
      ( v8498(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $true )
        & ( v4695(VarCurr,bitIndex3)
        <=> $false )
        & ( v4695(VarCurr,bitIndex2)
        <=> $false )
        & ( v4695(VarCurr,bitIndex1)
        <=> $false )
        & ( v4695(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_528,axiom,
    ! [VarCurr] :
      ( v8497(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $true )
        & ( v4695(VarCurr,bitIndex3)
        <=> $false )
        & ( v4695(VarCurr,bitIndex2)
        <=> $false )
        & ( v4695(VarCurr,bitIndex1)
        <=> $false )
        & ( v4695(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_527,axiom,
    ! [VarCurr] :
      ( v8496(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $false )
        & ( v4695(VarCurr,bitIndex3)
        <=> $true )
        & ( v4695(VarCurr,bitIndex2)
        <=> $true )
        & ( v4695(VarCurr,bitIndex1)
        <=> $true )
        & ( v4695(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_526,axiom,
    ! [VarCurr] :
      ( v8495(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $false )
        & ( v4695(VarCurr,bitIndex3)
        <=> $true )
        & ( v4695(VarCurr,bitIndex2)
        <=> $true )
        & ( v4695(VarCurr,bitIndex1)
        <=> $true )
        & ( v4695(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_525,axiom,
    ! [VarCurr] :
      ( v8494(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $false )
        & ( v4695(VarCurr,bitIndex3)
        <=> $true )
        & ( v4695(VarCurr,bitIndex2)
        <=> $true )
        & ( v4695(VarCurr,bitIndex1)
        <=> $false )
        & ( v4695(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_524,axiom,
    ! [VarCurr] :
      ( v8493(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $false )
        & ( v4695(VarCurr,bitIndex3)
        <=> $true )
        & ( v4695(VarCurr,bitIndex2)
        <=> $true )
        & ( v4695(VarCurr,bitIndex1)
        <=> $false )
        & ( v4695(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_523,axiom,
    ! [VarCurr] :
      ( v8492(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $false )
        & ( v4695(VarCurr,bitIndex3)
        <=> $true )
        & ( v4695(VarCurr,bitIndex2)
        <=> $false )
        & ( v4695(VarCurr,bitIndex1)
        <=> $true )
        & ( v4695(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_522,axiom,
    ! [VarCurr] :
      ( v8491(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $false )
        & ( v4695(VarCurr,bitIndex3)
        <=> $true )
        & ( v4695(VarCurr,bitIndex2)
        <=> $false )
        & ( v4695(VarCurr,bitIndex1)
        <=> $true )
        & ( v4695(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_521,axiom,
    ! [VarCurr] :
      ( v8490(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $false )
        & ( v4695(VarCurr,bitIndex3)
        <=> $true )
        & ( v4695(VarCurr,bitIndex2)
        <=> $false )
        & ( v4695(VarCurr,bitIndex1)
        <=> $false )
        & ( v4695(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_520,axiom,
    ! [VarCurr] :
      ( v8489(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $false )
        & ( v4695(VarCurr,bitIndex3)
        <=> $true )
        & ( v4695(VarCurr,bitIndex2)
        <=> $false )
        & ( v4695(VarCurr,bitIndex1)
        <=> $false )
        & ( v4695(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_519,axiom,
    ! [VarCurr] :
      ( v8488(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $false )
        & ( v4695(VarCurr,bitIndex3)
        <=> $false )
        & ( v4695(VarCurr,bitIndex2)
        <=> $true )
        & ( v4695(VarCurr,bitIndex1)
        <=> $true )
        & ( v4695(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_518,axiom,
    ! [VarCurr] :
      ( v8487(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $false )
        & ( v4695(VarCurr,bitIndex3)
        <=> $false )
        & ( v4695(VarCurr,bitIndex2)
        <=> $true )
        & ( v4695(VarCurr,bitIndex1)
        <=> $true )
        & ( v4695(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_517,axiom,
    ! [VarCurr] :
      ( v8486(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $false )
        & ( v4695(VarCurr,bitIndex3)
        <=> $false )
        & ( v4695(VarCurr,bitIndex2)
        <=> $true )
        & ( v4695(VarCurr,bitIndex1)
        <=> $false )
        & ( v4695(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_516,axiom,
    ! [VarCurr] :
      ( v8485(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $false )
        & ( v4695(VarCurr,bitIndex3)
        <=> $false )
        & ( v4695(VarCurr,bitIndex2)
        <=> $true )
        & ( v4695(VarCurr,bitIndex1)
        <=> $false )
        & ( v4695(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_515,axiom,
    ! [VarCurr] :
      ( v8484(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $false )
        & ( v4695(VarCurr,bitIndex3)
        <=> $false )
        & ( v4695(VarCurr,bitIndex2)
        <=> $false )
        & ( v4695(VarCurr,bitIndex1)
        <=> $true )
        & ( v4695(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_514,axiom,
    ! [VarCurr] :
      ( v8483(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $false )
        & ( v4695(VarCurr,bitIndex3)
        <=> $false )
        & ( v4695(VarCurr,bitIndex2)
        <=> $false )
        & ( v4695(VarCurr,bitIndex1)
        <=> $true )
        & ( v4695(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_513,axiom,
    ! [VarCurr] :
      ( v8482(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $false )
        & ( v4695(VarCurr,bitIndex3)
        <=> $false )
        & ( v4695(VarCurr,bitIndex2)
        <=> $false )
        & ( v4695(VarCurr,bitIndex1)
        <=> $false )
        & ( v4695(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_512,axiom,
    ! [VarCurr] :
      ( v8481(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $false )
        & ( v4695(VarCurr,bitIndex3)
        <=> $false )
        & ( v4695(VarCurr,bitIndex2)
        <=> $false )
        & ( v4695(VarCurr,bitIndex1)
        <=> $false )
        & ( v4695(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_511,axiom,
    ! [VarCurr] :
      ( v8475(VarCurr)
    <=> ( ( v4695(VarCurr,bitIndex4)
        <=> $false )
        & ( v4695(VarCurr,bitIndex3)
        <=> $false )
        & ( v4695(VarCurr,bitIndex2)
        <=> $false )
        & ( v4695(VarCurr,bitIndex1)
        <=> $false )
        & ( v4695(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1597,axiom,
    ! [VarCurr] :
      ( v8469(VarCurr)
    <=> ( v8470(VarCurr)
        | v8472(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_510,axiom,
    ! [VarCurr] :
      ( v8472(VarCurr)
    <=> ( ( v8473(VarCurr,bitIndex3)
        <=> $false )
        & ( v8473(VarCurr,bitIndex2)
        <=> $true )
        & ( v8473(VarCurr,bitIndex1)
        <=> $false )
        & ( v8473(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1921,axiom,
    ! [VarCurr] :
      ( v8473(VarCurr,bitIndex0)
    <=> v4689(VarCurr) ) ).

fof(addAssignment_1920,axiom,
    ! [VarCurr] :
      ( ( v8473(VarCurr,bitIndex3)
      <=> v4668(VarCurr,bitIndex2) )
      & ( v8473(VarCurr,bitIndex2)
      <=> v4668(VarCurr,bitIndex1) )
      & ( v8473(VarCurr,bitIndex1)
      <=> v4668(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_509,axiom,
    ! [VarCurr] :
      ( v8470(VarCurr)
    <=> ( ( v8471(VarCurr,bitIndex3)
        <=> $false )
        & ( v8471(VarCurr,bitIndex2)
        <=> $false )
        & ( v8471(VarCurr,bitIndex1)
        <=> $true )
        & ( v8471(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1919,axiom,
    ! [VarCurr] :
      ( v8471(VarCurr,bitIndex0)
    <=> v4689(VarCurr) ) ).

fof(addAssignment_1918,axiom,
    ! [VarCurr] :
      ( ( v8471(VarCurr,bitIndex3)
      <=> v4668(VarCurr,bitIndex2) )
      & ( v8471(VarCurr,bitIndex2)
      <=> v4668(VarCurr,bitIndex1) )
      & ( v8471(VarCurr,bitIndex1)
      <=> v4668(VarCurr,bitIndex0) ) ) ).

fof(addAssignmentInitValueVector_66,axiom,
    ( v4689(constB0)
  <=> $false ) ).

fof(addBitVectorEqualityBitBlasted_508,axiom,
    ! [VarCurr] :
      ( v8467(VarCurr)
    <=> ( v60(VarCurr)
      <=> $false ) ) ).

fof(addAssignment_1917,axiom,
    ! [VarCurr] :
      ( v4921(VarCurr,bitIndex0)
    <=> v4923(VarCurr,bitIndex0) ) ).

fof(addAssignment_1916,axiom,
    ! [VarCurr] :
      ( v4923(VarCurr,bitIndex0)
    <=> v4925(VarCurr,bitIndex0) ) ).

fof(addAssignment_1915,axiom,
    ! [VarCurr] :
      ( v4925(VarCurr,bitIndex0)
    <=> v4927(VarCurr,bitIndex0) ) ).

fof(addAssignment_1914,axiom,
    ! [VarCurr] :
      ( v4927(VarCurr,bitIndex0)
    <=> v6527(VarCurr,bitIndex0) ) ).

fof(addAssignment_1913,axiom,
    ! [VarCurr] :
      ( v5266(VarCurr)
    <=> v5268(VarCurr) ) ).

fof(addAssignment_1912,axiom,
    ! [VarCurr] :
      ( v5268(VarCurr)
    <=> v5270(VarCurr) ) ).

fof(addAssignment_1911,axiom,
    ! [VarCurr] :
      ( v5270(VarCurr)
    <=> v5272(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_135,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8455(VarNext)
       => ( v5272(VarNext)
        <=> v5272(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_142,axiom,
    ! [VarNext] :
      ( v8455(VarNext)
     => ( v5272(VarNext)
      <=> v8463(VarNext) ) ) ).

fof(addAssignment_1910,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8463(VarNext)
      <=> v8461(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_196,axiom,
    ! [VarCurr] :
      ( ~ v5393(VarCurr)
     => ( v8461(VarCurr)
      <=> v5274(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_199,axiom,
    ! [VarCurr] :
      ( v5393(VarCurr)
     => ( v8461(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1596,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8455(VarNext)
      <=> v8456(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1595,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8456(VarNext)
      <=> ( v8458(VarNext)
          & v179(VarNext) ) ) ) ).

fof(writeUnaryOperator_760,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8458(VarNext)
      <=> v4675(VarNext) ) ) ).

fof(addAssignmentInitValueVector_65,axiom,
    ( v5272(constB0)
  <=> $false ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_30,axiom,
    ! [VarCurr] :
      ( ( ~ v8449(VarCurr)
        & ~ v5337(VarCurr)
        & ~ v5349(VarCurr) )
     => ( v5274(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_68,axiom,
    ! [VarCurr] :
      ( v5349(VarCurr)
     => ( v5274(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_165,axiom,
    ! [VarCurr] :
      ( v5337(VarCurr)
     => ( v5274(VarCurr)
      <=> v8450(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_155,axiom,
    ! [VarCurr] :
      ( v8449(VarCurr)
     => ( v5274(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_164,axiom,
    ! [VarCurr] :
      ( ~ v5339(VarCurr)
     => ( v8450(VarCurr)
      <=> v8452(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_154,axiom,
    ! [VarCurr] :
      ( v5339(VarCurr)
     => ( v8450(VarCurr)
      <=> v8451(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_163,axiom,
    ! [VarCurr] :
      ( ~ v6294(VarCurr)
     => ( v8452(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_153,axiom,
    ! [VarCurr] :
      ( v6294(VarCurr)
     => ( v8452(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_67,axiom,
    ! [VarCurr] :
      ( ( ~ v5341(VarCurr)
        & ~ v5343(VarCurr) )
     => ( v8451(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_162,axiom,
    ! [VarCurr] :
      ( v5343(VarCurr)
     => ( v8451(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_152,axiom,
    ! [VarCurr] :
      ( v5341(VarCurr)
     => ( v8451(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1594,axiom,
    ! [VarCurr] :
      ( v8449(VarCurr)
    <=> ( v5333(VarCurr)
        | v5336(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_134,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8437(VarNext)
       => ( v5276(VarNext)
        <=> v5276(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_141,axiom,
    ! [VarNext] :
      ( v8437(VarNext)
     => ( v5276(VarNext)
      <=> v8445(VarNext) ) ) ).

fof(addAssignment_1909,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8445(VarNext)
      <=> v8443(VarCurr) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_108,axiom,
    ! [VarCurr] :
      ( ~ v5393(VarCurr)
     => ( v8443(VarCurr)
      <=> v5278(VarCurr,bitIndex4) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_198,axiom,
    ! [VarCurr] :
      ( v5393(VarCurr)
     => ( v8443(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1593,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8437(VarNext)
      <=> v8438(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1592,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8438(VarNext)
      <=> ( v8440(VarNext)
          & v179(VarNext) ) ) ) ).

fof(writeUnaryOperator_759,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8440(VarNext)
      <=> v4675(VarNext) ) ) ).

fof(addAssignment_1908,axiom,
    ! [VarCurr] :
      ( v5278(VarCurr,bitIndex4)
    <=> v5280(VarCurr,bitIndex4) ) ).

fof(addAssignment_1907,axiom,
    ! [VarCurr] :
      ( v5280(VarCurr,bitIndex4)
    <=> v5282(VarCurr,bitIndex4) ) ).

fof(addAssignment_1906,axiom,
    ! [VarCurr] :
      ( v5282(VarCurr,bitIndex4)
    <=> v5284(VarCurr,bitIndex4) ) ).

fof(addAssignment_1905,axiom,
    ! [VarCurr] :
      ( v5284(VarCurr,bitIndex4)
    <=> v7871(VarCurr,bitIndex4) ) ).

fof(memoryReadIntoBuffer_87,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00000_address_term = A
             => ( range_4_0(B)
               => ( v8143(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_86,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00001_address_term = A
             => ( range_4_0(B)
               => ( v8152(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_85,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00010_address_term = A
             => ( range_4_0(B)
               => ( v8161(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_84,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00011_address_term = A
             => ( range_4_0(B)
               => ( v8170(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_83,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00100_address_term = A
             => ( range_4_0(B)
               => ( v8179(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_82,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00101_address_term = A
             => ( range_4_0(B)
               => ( v8188(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_81,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00110_address_term = A
             => ( range_4_0(B)
               => ( v8197(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_80,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00111_address_term = A
             => ( range_4_0(B)
               => ( v8206(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_79,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01000_address_term = A
             => ( range_4_0(B)
               => ( v8215(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_78,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01001_address_term = A
             => ( range_4_0(B)
               => ( v8224(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_77,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01010_address_term = A
             => ( range_4_0(B)
               => ( v8233(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_76,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01011_address_term = A
             => ( range_4_0(B)
               => ( v8242(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_75,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01100_address_term = A
             => ( range_4_0(B)
               => ( v8251(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_74,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01101_address_term = A
             => ( range_4_0(B)
               => ( v8260(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_73,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01110_address_term = A
             => ( range_4_0(B)
               => ( v8269(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_72,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01111_address_term = A
             => ( range_4_0(B)
               => ( v8278(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_71,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10000_address_term = A
             => ( range_4_0(B)
               => ( v8287(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_70,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10001_address_term = A
             => ( range_4_0(B)
               => ( v8296(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_69,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10010_address_term = A
             => ( range_4_0(B)
               => ( v8305(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_68,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10011_address_term = A
             => ( range_4_0(B)
               => ( v8314(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_67,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10100_address_term = A
             => ( range_4_0(B)
               => ( v8323(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_66,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10101_address_term = A
             => ( range_4_0(B)
               => ( v8332(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_65,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10110_address_term = A
             => ( range_4_0(B)
               => ( v8341(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_64,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10111_address_term = A
             => ( range_4_0(B)
               => ( v8350(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_63,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11000_address_term = A
             => ( range_4_0(B)
               => ( v8359(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_62,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11001_address_term = A
             => ( range_4_0(B)
               => ( v8368(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_61,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11010_address_term = A
             => ( range_4_0(B)
               => ( v8377(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_60,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11011_address_term = A
             => ( range_4_0(B)
               => ( v8386(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_59,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11100_address_term = A
             => ( range_4_0(B)
               => ( v8395(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_58,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11101_address_term = A
             => ( range_4_0(B)
               => ( v8404(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_57,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11110_address_term = A
             => ( range_4_0(B)
               => ( v8413(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_56,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11111_address_term = A
             => ( range_4_0(B)
               => ( v8422(VarNext,B)
                <=> v5286_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_55,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v7748_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( address(A)
             => ! [B] :
                  ( A = AssociatedAddressVar
                 => ( range_4_0(B)
                   => ( v7871(VarNext,B)
                    <=> v5286_array(VarNext,A,B) ) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_54,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v5573_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( address(A)
             => ! [B] :
                  ( A = AssociatedAddressVar
                 => ( range_4_0(B)
                   => ( v8433(VarNext,B)
                    <=> v5286_array(VarNext,A,B) ) ) ) ) ) ) ).

fof(memoryConstantWriteDisabled_5,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( $true
              & v8425(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_array(VarNext,A,B)
              <=> v5286_36__array(VarNext,A,B) ) ) ) ) ).

fof(memoryConstantWriteEnabledInsideRange_5,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( $true
            & v8425(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_array(VarNext,A,B)
              <=> b00000(B) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1591,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8425(VarNext)
      <=> ( v8426(VarNext)
          & v8431(VarNext) ) ) ) ).

fof(addAssignment_1904,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8431(VarNext)
      <=> v8096(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1590,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8426(VarNext)
      <=> ( v8428(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_758,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8428(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_91,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11111_address_term = A
              & v8416(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_36__array(VarNext,A,B)
              <=> v5286_35__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_91,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11111_address_term = A
            & v8416(VarNext) )
         => ( ( v5286_36__array(VarNext,A,bitIndex4)
            <=> v8422(VarNext,bitIndex159) )
            & ( v5286_36__array(VarNext,A,bitIndex3)
            <=> v8422(VarNext,bitIndex158) )
            & ( v5286_36__array(VarNext,A,bitIndex2)
            <=> v8422(VarNext,bitIndex157) )
            & ( v5286_36__array(VarNext,A,bitIndex1)
            <=> v8422(VarNext,bitIndex156) )
            & ( v5286_36__array(VarNext,A,bitIndex0)
            <=> v8422(VarNext,bitIndex155) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1589,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8416(VarNext)
      <=> ( v8417(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1588,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8417(VarNext)
      <=> ( v8419(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_757,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8419(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_90,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11110_address_term = A
              & v8407(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_35__array(VarNext,A,B)
              <=> v5286_34__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_90,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11110_address_term = A
            & v8407(VarNext) )
         => ( ( v5286_35__array(VarNext,A,bitIndex4)
            <=> v8413(VarNext,bitIndex154) )
            & ( v5286_35__array(VarNext,A,bitIndex3)
            <=> v8413(VarNext,bitIndex153) )
            & ( v5286_35__array(VarNext,A,bitIndex2)
            <=> v8413(VarNext,bitIndex152) )
            & ( v5286_35__array(VarNext,A,bitIndex1)
            <=> v8413(VarNext,bitIndex151) )
            & ( v5286_35__array(VarNext,A,bitIndex0)
            <=> v8413(VarNext,bitIndex150) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1587,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8407(VarNext)
      <=> ( v8408(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1586,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8408(VarNext)
      <=> ( v8410(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_756,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8410(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_89,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11101_address_term = A
              & v8398(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_34__array(VarNext,A,B)
              <=> v5286_33__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_89,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11101_address_term = A
            & v8398(VarNext) )
         => ( ( v5286_34__array(VarNext,A,bitIndex4)
            <=> v8404(VarNext,bitIndex149) )
            & ( v5286_34__array(VarNext,A,bitIndex3)
            <=> v8404(VarNext,bitIndex148) )
            & ( v5286_34__array(VarNext,A,bitIndex2)
            <=> v8404(VarNext,bitIndex147) )
            & ( v5286_34__array(VarNext,A,bitIndex1)
            <=> v8404(VarNext,bitIndex146) )
            & ( v5286_34__array(VarNext,A,bitIndex0)
            <=> v8404(VarNext,bitIndex145) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1585,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8398(VarNext)
      <=> ( v8399(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1584,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8399(VarNext)
      <=> ( v8401(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_755,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8401(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_88,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11100_address_term = A
              & v8389(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_33__array(VarNext,A,B)
              <=> v5286_32__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_88,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11100_address_term = A
            & v8389(VarNext) )
         => ( ( v5286_33__array(VarNext,A,bitIndex4)
            <=> v8395(VarNext,bitIndex144) )
            & ( v5286_33__array(VarNext,A,bitIndex3)
            <=> v8395(VarNext,bitIndex143) )
            & ( v5286_33__array(VarNext,A,bitIndex2)
            <=> v8395(VarNext,bitIndex142) )
            & ( v5286_33__array(VarNext,A,bitIndex1)
            <=> v8395(VarNext,bitIndex141) )
            & ( v5286_33__array(VarNext,A,bitIndex0)
            <=> v8395(VarNext,bitIndex140) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1583,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8389(VarNext)
      <=> ( v8390(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1582,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8390(VarNext)
      <=> ( v8392(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_754,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8392(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_87,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11011_address_term = A
              & v8380(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_32__array(VarNext,A,B)
              <=> v5286_31__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_87,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11011_address_term = A
            & v8380(VarNext) )
         => ( ( v5286_32__array(VarNext,A,bitIndex4)
            <=> v8386(VarNext,bitIndex139) )
            & ( v5286_32__array(VarNext,A,bitIndex3)
            <=> v8386(VarNext,bitIndex138) )
            & ( v5286_32__array(VarNext,A,bitIndex2)
            <=> v8386(VarNext,bitIndex137) )
            & ( v5286_32__array(VarNext,A,bitIndex1)
            <=> v8386(VarNext,bitIndex136) )
            & ( v5286_32__array(VarNext,A,bitIndex0)
            <=> v8386(VarNext,bitIndex135) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1581,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8380(VarNext)
      <=> ( v8381(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1580,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8381(VarNext)
      <=> ( v8383(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_753,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8383(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_86,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11010_address_term = A
              & v8371(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_31__array(VarNext,A,B)
              <=> v5286_30__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_86,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11010_address_term = A
            & v8371(VarNext) )
         => ( ( v5286_31__array(VarNext,A,bitIndex4)
            <=> v8377(VarNext,bitIndex134) )
            & ( v5286_31__array(VarNext,A,bitIndex3)
            <=> v8377(VarNext,bitIndex133) )
            & ( v5286_31__array(VarNext,A,bitIndex2)
            <=> v8377(VarNext,bitIndex132) )
            & ( v5286_31__array(VarNext,A,bitIndex1)
            <=> v8377(VarNext,bitIndex131) )
            & ( v5286_31__array(VarNext,A,bitIndex0)
            <=> v8377(VarNext,bitIndex130) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1579,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8371(VarNext)
      <=> ( v8372(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1578,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8372(VarNext)
      <=> ( v8374(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_752,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8374(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_85,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11001_address_term = A
              & v8362(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_30__array(VarNext,A,B)
              <=> v5286_29__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_85,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11001_address_term = A
            & v8362(VarNext) )
         => ( ( v5286_30__array(VarNext,A,bitIndex4)
            <=> v8368(VarNext,bitIndex129) )
            & ( v5286_30__array(VarNext,A,bitIndex3)
            <=> v8368(VarNext,bitIndex128) )
            & ( v5286_30__array(VarNext,A,bitIndex2)
            <=> v8368(VarNext,bitIndex127) )
            & ( v5286_30__array(VarNext,A,bitIndex1)
            <=> v8368(VarNext,bitIndex126) )
            & ( v5286_30__array(VarNext,A,bitIndex0)
            <=> v8368(VarNext,bitIndex125) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1577,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8362(VarNext)
      <=> ( v8363(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1576,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8363(VarNext)
      <=> ( v8365(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_751,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8365(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_84,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11000_address_term = A
              & v8353(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_29__array(VarNext,A,B)
              <=> v5286_28__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_84,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11000_address_term = A
            & v8353(VarNext) )
         => ( ( v5286_29__array(VarNext,A,bitIndex4)
            <=> v8359(VarNext,bitIndex124) )
            & ( v5286_29__array(VarNext,A,bitIndex3)
            <=> v8359(VarNext,bitIndex123) )
            & ( v5286_29__array(VarNext,A,bitIndex2)
            <=> v8359(VarNext,bitIndex122) )
            & ( v5286_29__array(VarNext,A,bitIndex1)
            <=> v8359(VarNext,bitIndex121) )
            & ( v5286_29__array(VarNext,A,bitIndex0)
            <=> v8359(VarNext,bitIndex120) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1575,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8353(VarNext)
      <=> ( v8354(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1574,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8354(VarNext)
      <=> ( v8356(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_750,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8356(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_83,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10111_address_term = A
              & v8344(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_28__array(VarNext,A,B)
              <=> v5286_27__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_83,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10111_address_term = A
            & v8344(VarNext) )
         => ( ( v5286_28__array(VarNext,A,bitIndex4)
            <=> v8350(VarNext,bitIndex119) )
            & ( v5286_28__array(VarNext,A,bitIndex3)
            <=> v8350(VarNext,bitIndex118) )
            & ( v5286_28__array(VarNext,A,bitIndex2)
            <=> v8350(VarNext,bitIndex117) )
            & ( v5286_28__array(VarNext,A,bitIndex1)
            <=> v8350(VarNext,bitIndex116) )
            & ( v5286_28__array(VarNext,A,bitIndex0)
            <=> v8350(VarNext,bitIndex115) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1573,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8344(VarNext)
      <=> ( v8345(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1572,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8345(VarNext)
      <=> ( v8347(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_749,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8347(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_82,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10110_address_term = A
              & v8335(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_27__array(VarNext,A,B)
              <=> v5286_26__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_82,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10110_address_term = A
            & v8335(VarNext) )
         => ( ( v5286_27__array(VarNext,A,bitIndex4)
            <=> v8341(VarNext,bitIndex114) )
            & ( v5286_27__array(VarNext,A,bitIndex3)
            <=> v8341(VarNext,bitIndex113) )
            & ( v5286_27__array(VarNext,A,bitIndex2)
            <=> v8341(VarNext,bitIndex112) )
            & ( v5286_27__array(VarNext,A,bitIndex1)
            <=> v8341(VarNext,bitIndex111) )
            & ( v5286_27__array(VarNext,A,bitIndex0)
            <=> v8341(VarNext,bitIndex110) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1571,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8335(VarNext)
      <=> ( v8336(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1570,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8336(VarNext)
      <=> ( v8338(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_748,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8338(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_81,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10101_address_term = A
              & v8326(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_26__array(VarNext,A,B)
              <=> v5286_25__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_81,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10101_address_term = A
            & v8326(VarNext) )
         => ( ( v5286_26__array(VarNext,A,bitIndex4)
            <=> v8332(VarNext,bitIndex109) )
            & ( v5286_26__array(VarNext,A,bitIndex3)
            <=> v8332(VarNext,bitIndex108) )
            & ( v5286_26__array(VarNext,A,bitIndex2)
            <=> v8332(VarNext,bitIndex107) )
            & ( v5286_26__array(VarNext,A,bitIndex1)
            <=> v8332(VarNext,bitIndex106) )
            & ( v5286_26__array(VarNext,A,bitIndex0)
            <=> v8332(VarNext,bitIndex105) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1569,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8326(VarNext)
      <=> ( v8327(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1568,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8327(VarNext)
      <=> ( v8329(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_747,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8329(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_80,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10100_address_term = A
              & v8317(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_25__array(VarNext,A,B)
              <=> v5286_24__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_80,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10100_address_term = A
            & v8317(VarNext) )
         => ( ( v5286_25__array(VarNext,A,bitIndex4)
            <=> v8323(VarNext,bitIndex104) )
            & ( v5286_25__array(VarNext,A,bitIndex3)
            <=> v8323(VarNext,bitIndex103) )
            & ( v5286_25__array(VarNext,A,bitIndex2)
            <=> v8323(VarNext,bitIndex102) )
            & ( v5286_25__array(VarNext,A,bitIndex1)
            <=> v8323(VarNext,bitIndex101) )
            & ( v5286_25__array(VarNext,A,bitIndex0)
            <=> v8323(VarNext,bitIndex100) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1567,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8317(VarNext)
      <=> ( v8318(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1566,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8318(VarNext)
      <=> ( v8320(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_746,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8320(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_79,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10011_address_term = A
              & v8308(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_24__array(VarNext,A,B)
              <=> v5286_23__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_79,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10011_address_term = A
            & v8308(VarNext) )
         => ( ( v5286_24__array(VarNext,A,bitIndex4)
            <=> v8314(VarNext,bitIndex99) )
            & ( v5286_24__array(VarNext,A,bitIndex3)
            <=> v8314(VarNext,bitIndex98) )
            & ( v5286_24__array(VarNext,A,bitIndex2)
            <=> v8314(VarNext,bitIndex97) )
            & ( v5286_24__array(VarNext,A,bitIndex1)
            <=> v8314(VarNext,bitIndex96) )
            & ( v5286_24__array(VarNext,A,bitIndex0)
            <=> v8314(VarNext,bitIndex95) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1565,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8308(VarNext)
      <=> ( v8309(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1564,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8309(VarNext)
      <=> ( v8311(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_745,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8311(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_78,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10010_address_term = A
              & v8299(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_23__array(VarNext,A,B)
              <=> v5286_22__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_78,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10010_address_term = A
            & v8299(VarNext) )
         => ( ( v5286_23__array(VarNext,A,bitIndex4)
            <=> v8305(VarNext,bitIndex94) )
            & ( v5286_23__array(VarNext,A,bitIndex3)
            <=> v8305(VarNext,bitIndex93) )
            & ( v5286_23__array(VarNext,A,bitIndex2)
            <=> v8305(VarNext,bitIndex92) )
            & ( v5286_23__array(VarNext,A,bitIndex1)
            <=> v8305(VarNext,bitIndex91) )
            & ( v5286_23__array(VarNext,A,bitIndex0)
            <=> v8305(VarNext,bitIndex90) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1563,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8299(VarNext)
      <=> ( v8300(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1562,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8300(VarNext)
      <=> ( v8302(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_744,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8302(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_77,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10001_address_term = A
              & v8290(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_22__array(VarNext,A,B)
              <=> v5286_21__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_77,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10001_address_term = A
            & v8290(VarNext) )
         => ( ( v5286_22__array(VarNext,A,bitIndex4)
            <=> v8296(VarNext,bitIndex89) )
            & ( v5286_22__array(VarNext,A,bitIndex3)
            <=> v8296(VarNext,bitIndex88) )
            & ( v5286_22__array(VarNext,A,bitIndex2)
            <=> v8296(VarNext,bitIndex87) )
            & ( v5286_22__array(VarNext,A,bitIndex1)
            <=> v8296(VarNext,bitIndex86) )
            & ( v5286_22__array(VarNext,A,bitIndex0)
            <=> v8296(VarNext,bitIndex85) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1561,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8290(VarNext)
      <=> ( v8291(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1560,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8291(VarNext)
      <=> ( v8293(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_743,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8293(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_76,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10000_address_term = A
              & v8281(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_21__array(VarNext,A,B)
              <=> v5286_20__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_76,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10000_address_term = A
            & v8281(VarNext) )
         => ( ( v5286_21__array(VarNext,A,bitIndex4)
            <=> v8287(VarNext,bitIndex84) )
            & ( v5286_21__array(VarNext,A,bitIndex3)
            <=> v8287(VarNext,bitIndex83) )
            & ( v5286_21__array(VarNext,A,bitIndex2)
            <=> v8287(VarNext,bitIndex82) )
            & ( v5286_21__array(VarNext,A,bitIndex1)
            <=> v8287(VarNext,bitIndex81) )
            & ( v5286_21__array(VarNext,A,bitIndex0)
            <=> v8287(VarNext,bitIndex80) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1559,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8281(VarNext)
      <=> ( v8282(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1558,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8282(VarNext)
      <=> ( v8284(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_742,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8284(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_75,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01111_address_term = A
              & v8272(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_20__array(VarNext,A,B)
              <=> v5286_19__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_75,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01111_address_term = A
            & v8272(VarNext) )
         => ( ( v5286_20__array(VarNext,A,bitIndex4)
            <=> v8278(VarNext,bitIndex79) )
            & ( v5286_20__array(VarNext,A,bitIndex3)
            <=> v8278(VarNext,bitIndex78) )
            & ( v5286_20__array(VarNext,A,bitIndex2)
            <=> v8278(VarNext,bitIndex77) )
            & ( v5286_20__array(VarNext,A,bitIndex1)
            <=> v8278(VarNext,bitIndex76) )
            & ( v5286_20__array(VarNext,A,bitIndex0)
            <=> v8278(VarNext,bitIndex75) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1557,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8272(VarNext)
      <=> ( v8273(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1556,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8273(VarNext)
      <=> ( v8275(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_741,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8275(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_74,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01110_address_term = A
              & v8263(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_19__array(VarNext,A,B)
              <=> v5286_18__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_74,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01110_address_term = A
            & v8263(VarNext) )
         => ( ( v5286_19__array(VarNext,A,bitIndex4)
            <=> v8269(VarNext,bitIndex74) )
            & ( v5286_19__array(VarNext,A,bitIndex3)
            <=> v8269(VarNext,bitIndex73) )
            & ( v5286_19__array(VarNext,A,bitIndex2)
            <=> v8269(VarNext,bitIndex72) )
            & ( v5286_19__array(VarNext,A,bitIndex1)
            <=> v8269(VarNext,bitIndex71) )
            & ( v5286_19__array(VarNext,A,bitIndex0)
            <=> v8269(VarNext,bitIndex70) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1555,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8263(VarNext)
      <=> ( v8264(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1554,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8264(VarNext)
      <=> ( v8266(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_740,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8266(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_73,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01101_address_term = A
              & v8254(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_18__array(VarNext,A,B)
              <=> v5286_17__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_73,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01101_address_term = A
            & v8254(VarNext) )
         => ( ( v5286_18__array(VarNext,A,bitIndex4)
            <=> v8260(VarNext,bitIndex69) )
            & ( v5286_18__array(VarNext,A,bitIndex3)
            <=> v8260(VarNext,bitIndex68) )
            & ( v5286_18__array(VarNext,A,bitIndex2)
            <=> v8260(VarNext,bitIndex67) )
            & ( v5286_18__array(VarNext,A,bitIndex1)
            <=> v8260(VarNext,bitIndex66) )
            & ( v5286_18__array(VarNext,A,bitIndex0)
            <=> v8260(VarNext,bitIndex65) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1553,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8254(VarNext)
      <=> ( v8255(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1552,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8255(VarNext)
      <=> ( v8257(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_739,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8257(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_72,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01100_address_term = A
              & v8245(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_17__array(VarNext,A,B)
              <=> v5286_16__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_72,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01100_address_term = A
            & v8245(VarNext) )
         => ( ( v5286_17__array(VarNext,A,bitIndex4)
            <=> v8251(VarNext,bitIndex64) )
            & ( v5286_17__array(VarNext,A,bitIndex3)
            <=> v8251(VarNext,bitIndex63) )
            & ( v5286_17__array(VarNext,A,bitIndex2)
            <=> v8251(VarNext,bitIndex62) )
            & ( v5286_17__array(VarNext,A,bitIndex1)
            <=> v8251(VarNext,bitIndex61) )
            & ( v5286_17__array(VarNext,A,bitIndex0)
            <=> v8251(VarNext,bitIndex60) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1551,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8245(VarNext)
      <=> ( v8246(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1550,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8246(VarNext)
      <=> ( v8248(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_738,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8248(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_71,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01011_address_term = A
              & v8236(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_16__array(VarNext,A,B)
              <=> v5286_15__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_71,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01011_address_term = A
            & v8236(VarNext) )
         => ( ( v5286_16__array(VarNext,A,bitIndex4)
            <=> v8242(VarNext,bitIndex59) )
            & ( v5286_16__array(VarNext,A,bitIndex3)
            <=> v8242(VarNext,bitIndex58) )
            & ( v5286_16__array(VarNext,A,bitIndex2)
            <=> v8242(VarNext,bitIndex57) )
            & ( v5286_16__array(VarNext,A,bitIndex1)
            <=> v8242(VarNext,bitIndex56) )
            & ( v5286_16__array(VarNext,A,bitIndex0)
            <=> v8242(VarNext,bitIndex55) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1549,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8236(VarNext)
      <=> ( v8237(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1548,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8237(VarNext)
      <=> ( v8239(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_737,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8239(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_70,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01010_address_term = A
              & v8227(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_15__array(VarNext,A,B)
              <=> v5286_14__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_70,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01010_address_term = A
            & v8227(VarNext) )
         => ( ( v5286_15__array(VarNext,A,bitIndex4)
            <=> v8233(VarNext,bitIndex54) )
            & ( v5286_15__array(VarNext,A,bitIndex3)
            <=> v8233(VarNext,bitIndex53) )
            & ( v5286_15__array(VarNext,A,bitIndex2)
            <=> v8233(VarNext,bitIndex52) )
            & ( v5286_15__array(VarNext,A,bitIndex1)
            <=> v8233(VarNext,bitIndex51) )
            & ( v5286_15__array(VarNext,A,bitIndex0)
            <=> v8233(VarNext,bitIndex50) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1547,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8227(VarNext)
      <=> ( v8228(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1546,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8228(VarNext)
      <=> ( v8230(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_736,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8230(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_69,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01001_address_term = A
              & v8218(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_14__array(VarNext,A,B)
              <=> v5286_13__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_69,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01001_address_term = A
            & v8218(VarNext) )
         => ( ( v5286_14__array(VarNext,A,bitIndex4)
            <=> v8224(VarNext,bitIndex49) )
            & ( v5286_14__array(VarNext,A,bitIndex3)
            <=> v8224(VarNext,bitIndex48) )
            & ( v5286_14__array(VarNext,A,bitIndex2)
            <=> v8224(VarNext,bitIndex47) )
            & ( v5286_14__array(VarNext,A,bitIndex1)
            <=> v8224(VarNext,bitIndex46) )
            & ( v5286_14__array(VarNext,A,bitIndex0)
            <=> v8224(VarNext,bitIndex45) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1545,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8218(VarNext)
      <=> ( v8219(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1544,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8219(VarNext)
      <=> ( v8221(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_735,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8221(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_68,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01000_address_term = A
              & v8209(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_13__array(VarNext,A,B)
              <=> v5286_12__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_68,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01000_address_term = A
            & v8209(VarNext) )
         => ( ( v5286_13__array(VarNext,A,bitIndex4)
            <=> v8215(VarNext,bitIndex44) )
            & ( v5286_13__array(VarNext,A,bitIndex3)
            <=> v8215(VarNext,bitIndex43) )
            & ( v5286_13__array(VarNext,A,bitIndex2)
            <=> v8215(VarNext,bitIndex42) )
            & ( v5286_13__array(VarNext,A,bitIndex1)
            <=> v8215(VarNext,bitIndex41) )
            & ( v5286_13__array(VarNext,A,bitIndex0)
            <=> v8215(VarNext,bitIndex40) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1543,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8209(VarNext)
      <=> ( v8210(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1542,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8210(VarNext)
      <=> ( v8212(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_734,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8212(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_67,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00111_address_term = A
              & v8200(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_12__array(VarNext,A,B)
              <=> v5286_11__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_67,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00111_address_term = A
            & v8200(VarNext) )
         => ( ( v5286_12__array(VarNext,A,bitIndex4)
            <=> v8206(VarNext,bitIndex39) )
            & ( v5286_12__array(VarNext,A,bitIndex3)
            <=> v8206(VarNext,bitIndex38) )
            & ( v5286_12__array(VarNext,A,bitIndex2)
            <=> v8206(VarNext,bitIndex37) )
            & ( v5286_12__array(VarNext,A,bitIndex1)
            <=> v8206(VarNext,bitIndex36) )
            & ( v5286_12__array(VarNext,A,bitIndex0)
            <=> v8206(VarNext,bitIndex35) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1541,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8200(VarNext)
      <=> ( v8201(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1540,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8201(VarNext)
      <=> ( v8203(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_733,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8203(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_66,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00110_address_term = A
              & v8191(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_11__array(VarNext,A,B)
              <=> v5286_10__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_66,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00110_address_term = A
            & v8191(VarNext) )
         => ( ( v5286_11__array(VarNext,A,bitIndex4)
            <=> v8197(VarNext,bitIndex34) )
            & ( v5286_11__array(VarNext,A,bitIndex3)
            <=> v8197(VarNext,bitIndex33) )
            & ( v5286_11__array(VarNext,A,bitIndex2)
            <=> v8197(VarNext,bitIndex32) )
            & ( v5286_11__array(VarNext,A,bitIndex1)
            <=> v8197(VarNext,bitIndex31) )
            & ( v5286_11__array(VarNext,A,bitIndex0)
            <=> v8197(VarNext,bitIndex30) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1539,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8191(VarNext)
      <=> ( v8192(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1538,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8192(VarNext)
      <=> ( v8194(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_732,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8194(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_65,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00101_address_term = A
              & v8182(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_10__array(VarNext,A,B)
              <=> v5286_9__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_65,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00101_address_term = A
            & v8182(VarNext) )
         => ( ( v5286_10__array(VarNext,A,bitIndex4)
            <=> v8188(VarNext,bitIndex29) )
            & ( v5286_10__array(VarNext,A,bitIndex3)
            <=> v8188(VarNext,bitIndex28) )
            & ( v5286_10__array(VarNext,A,bitIndex2)
            <=> v8188(VarNext,bitIndex27) )
            & ( v5286_10__array(VarNext,A,bitIndex1)
            <=> v8188(VarNext,bitIndex26) )
            & ( v5286_10__array(VarNext,A,bitIndex0)
            <=> v8188(VarNext,bitIndex25) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1537,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8182(VarNext)
      <=> ( v8183(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1536,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8183(VarNext)
      <=> ( v8185(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_731,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8185(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_64,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00100_address_term = A
              & v8173(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_9__array(VarNext,A,B)
              <=> v5286_8__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_64,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00100_address_term = A
            & v8173(VarNext) )
         => ( ( v5286_9__array(VarNext,A,bitIndex4)
            <=> v8179(VarNext,bitIndex24) )
            & ( v5286_9__array(VarNext,A,bitIndex3)
            <=> v8179(VarNext,bitIndex23) )
            & ( v5286_9__array(VarNext,A,bitIndex2)
            <=> v8179(VarNext,bitIndex22) )
            & ( v5286_9__array(VarNext,A,bitIndex1)
            <=> v8179(VarNext,bitIndex21) )
            & ( v5286_9__array(VarNext,A,bitIndex0)
            <=> v8179(VarNext,bitIndex20) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1535,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8173(VarNext)
      <=> ( v8174(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1534,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8174(VarNext)
      <=> ( v8176(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_730,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8176(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_63,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00011_address_term = A
              & v8164(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_8__array(VarNext,A,B)
              <=> v5286_7__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_63,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00011_address_term = A
            & v8164(VarNext) )
         => ( ( v5286_8__array(VarNext,A,bitIndex4)
            <=> v8170(VarNext,bitIndex19) )
            & ( v5286_8__array(VarNext,A,bitIndex3)
            <=> v8170(VarNext,bitIndex18) )
            & ( v5286_8__array(VarNext,A,bitIndex2)
            <=> v8170(VarNext,bitIndex17) )
            & ( v5286_8__array(VarNext,A,bitIndex1)
            <=> v8170(VarNext,bitIndex16) )
            & ( v5286_8__array(VarNext,A,bitIndex0)
            <=> v8170(VarNext,bitIndex15) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1533,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8164(VarNext)
      <=> ( v8165(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1532,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8165(VarNext)
      <=> ( v8167(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_729,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8167(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_62,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00010_address_term = A
              & v8155(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_7__array(VarNext,A,B)
              <=> v5286_6__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_62,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00010_address_term = A
            & v8155(VarNext) )
         => ( ( v5286_7__array(VarNext,A,bitIndex4)
            <=> v8161(VarNext,bitIndex14) )
            & ( v5286_7__array(VarNext,A,bitIndex3)
            <=> v8161(VarNext,bitIndex13) )
            & ( v5286_7__array(VarNext,A,bitIndex2)
            <=> v8161(VarNext,bitIndex12) )
            & ( v5286_7__array(VarNext,A,bitIndex1)
            <=> v8161(VarNext,bitIndex11) )
            & ( v5286_7__array(VarNext,A,bitIndex0)
            <=> v8161(VarNext,bitIndex10) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1531,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8155(VarNext)
      <=> ( v8156(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1530,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8156(VarNext)
      <=> ( v8158(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_728,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8158(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_61,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00001_address_term = A
              & v8146(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_6__array(VarNext,A,B)
              <=> v5286_5__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_61,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00001_address_term = A
            & v8146(VarNext) )
         => ( ( v5286_6__array(VarNext,A,bitIndex4)
            <=> v8152(VarNext,bitIndex9) )
            & ( v5286_6__array(VarNext,A,bitIndex3)
            <=> v8152(VarNext,bitIndex8) )
            & ( v5286_6__array(VarNext,A,bitIndex2)
            <=> v8152(VarNext,bitIndex7) )
            & ( v5286_6__array(VarNext,A,bitIndex1)
            <=> v8152(VarNext,bitIndex6) )
            & ( v5286_6__array(VarNext,A,bitIndex0)
            <=> v8152(VarNext,bitIndex5) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1529,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8146(VarNext)
      <=> ( v8147(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1528,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8147(VarNext)
      <=> ( v8149(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_727,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8149(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_60,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00000_address_term = A
              & v8132(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_5__array(VarNext,A,B)
              <=> v5286_4__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_60,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00000_address_term = A
            & v8132(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v5286_5__array(VarNext,A,B)
              <=> v8143(VarNext,B) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1527,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8132(VarNext)
      <=> ( v8133(VarNext)
          & v8139(VarNext) ) ) ) ).

fof(addAssignment_1903,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8139(VarNext)
      <=> v8137(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1526,axiom,
    ! [VarCurr] :
      ( v8137(VarCurr)
    <=> ( v8095(VarCurr)
        & v8140(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_507,axiom,
    ! [VarCurr] :
      ( v8140(VarCurr)
    <=> ( ( v8141(VarCurr,bitIndex1)
        <=> $false )
        & ( v8141(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1902,axiom,
    ! [VarCurr] :
      ( v8141(VarCurr,bitIndex0)
    <=> v5315(VarCurr) ) ).

fof(addAssignment_1901,axiom,
    ! [VarCurr] :
      ( v8141(VarCurr,bitIndex1)
    <=> v5292(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1525,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8133(VarNext)
      <=> ( v8135(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_726,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8135(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_59,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v5573_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ~ ( A = AssociatedAddressVar
                  & v8120(VarNext) )
             => ! [B] :
                  ( range_4_0(B)
                 => ( v5286_4__array(VarNext,A,B)
                  <=> v5286_3__array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_59,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v5573_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ( A = AssociatedAddressVar
                & v8120(VarNext) )
             => ! [B] :
                  ( range_4_0(B)
                 => ( v5286_4__array(VarNext,A,B)
                  <=> v5565(VarNext,B) ) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1524,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8120(VarNext)
      <=> ( v8121(VarNext)
          & v8127(VarNext) ) ) ) ).

fof(addAssignment_1900,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8127(VarNext)
      <=> v8125(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1523,axiom,
    ! [VarCurr] :
      ( v8125(VarCurr)
    <=> ( v8095(VarCurr)
        & v8128(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_506,axiom,
    ! [VarCurr] :
      ( v8128(VarCurr)
    <=> ( ( v8129(VarCurr,bitIndex1)
        <=> $true )
        & ( v8129(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1899,axiom,
    ! [VarCurr] :
      ( v8129(VarCurr,bitIndex0)
    <=> v5315(VarCurr) ) ).

fof(addAssignment_1898,axiom,
    ! [VarCurr] :
      ( v8129(VarCurr,bitIndex1)
    <=> v5292(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1522,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8121(VarNext)
      <=> ( v8123(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_725,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8123(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_58,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v7748_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ~ ( A = AssociatedAddressVar
                  & v8108(VarNext) )
             => ! [B] :
                  ( range_4_0(B)
                 => ( v5286_3__array(VarNext,A,B)
                  <=> v5286_2__array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_58,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v7748_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ( A = AssociatedAddressVar
                & v8108(VarNext) )
             => ! [B] :
                  ( range_4_0(B)
                 => ( v5286_3__array(VarNext,A,B)
                  <=> v5607(VarNext,B) ) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1521,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8108(VarNext)
      <=> ( v8109(VarNext)
          & v8115(VarNext) ) ) ) ).

fof(addAssignment_1897,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8115(VarNext)
      <=> v8113(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1520,axiom,
    ! [VarCurr] :
      ( v8113(VarCurr)
    <=> ( v8095(VarCurr)
        & v8116(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_505,axiom,
    ! [VarCurr] :
      ( v8116(VarCurr)
    <=> ( ( v8117(VarCurr,bitIndex1)
        <=> $false )
        & ( v8117(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1896,axiom,
    ! [VarCurr] :
      ( v8117(VarCurr,bitIndex0)
    <=> v5315(VarCurr) ) ).

fof(addAssignment_1895,axiom,
    ! [VarCurr] :
      ( v8117(VarCurr,bitIndex1)
    <=> v5292(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1519,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8109(VarNext)
      <=> ( v8111(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_724,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8111(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_57,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v7748_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ~ ( A = AssociatedAddressVar
                  & v8101(VarNext) )
             => ! [B] :
                  ( range_4_0(B)
                 => ( v5286_2__array(VarNext,A,B)
                  <=> v5286_1__array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_57,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v7748_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ( A = AssociatedAddressVar
                & v8101(VarNext) )
             => ! [B] :
                  ( range_4_0(B)
                 => ( v5286_2__array(VarNext,A,B)
                  <=> v5607(VarNext,B) ) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1518,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8101(VarNext)
      <=> ( v8102(VarNext)
          & v8094(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1517,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8102(VarNext)
      <=> ( v8104(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_723,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8104(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(memoryWriteDisabled_56,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v5573_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ~ ( A = AssociatedAddressVar
                  & v8085(VarNext) )
             => ! [B] :
                  ( range_4_0(B)
                 => ( v5286_1__array(VarNext,A,B)
                  <=> v5286_array(VarCurr,A,B) ) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_56,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v5573_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ( A = AssociatedAddressVar
                & v8085(VarNext) )
             => ! [B] :
                  ( range_4_0(B)
                 => ( v5286_1__array(VarNext,A,B)
                  <=> v5565(VarNext,B) ) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1516,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8085(VarNext)
      <=> ( v8086(VarNext)
          & v8094(VarNext) ) ) ) ).

fof(addAssignment_1894,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8094(VarNext)
      <=> v8092(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1515,axiom,
    ! [VarCurr] :
      ( v8092(VarCurr)
    <=> ( v8095(VarCurr)
        & v8097(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_504,axiom,
    ! [VarCurr] :
      ( v8097(VarCurr)
    <=> ( ( v8098(VarCurr,bitIndex1)
        <=> $true )
        & ( v8098(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1893,axiom,
    ! [VarCurr] :
      ( v8098(VarCurr,bitIndex0)
    <=> v5315(VarCurr) ) ).

fof(addAssignment_1892,axiom,
    ! [VarCurr] :
      ( v8098(VarCurr,bitIndex1)
    <=> v5292(VarCurr) ) ).

fof(writeUnaryOperator_722,axiom,
    ! [VarCurr] :
      ( ~ v8095(VarCurr)
    <=> v8096(VarCurr) ) ).

fof(writeUnaryOperator_721,axiom,
    ! [VarCurr] :
      ( ~ v8096(VarCurr)
    <=> v5290(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1514,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8086(VarNext)
      <=> ( v8087(VarNext)
          & v5288(VarNext) ) ) ) ).

fof(writeUnaryOperator_720,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8087(VarNext)
      <=> v8089(VarNext) ) ) ).

fof(addAssignment_1891,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8089(VarNext)
      <=> v5288(VarCurr) ) ) ).

fof(memoryInitStateConstraint,axiom,
    ! [B,A] :
      ( address(A)
     => ~ v5286_array(constB0,A,B) ) ).

fof(addAssignment_1890,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v5607(VarCurr,B)
      <=> v5609(VarCurr,B) ) ) ).

fof(addAssignment_1889,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v5609(VarCurr,B)
      <=> v5611(VarCurr,B) ) ) ).

fof(addAssignment_1888,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v5611(VarCurr,B)
      <=> v5613(VarCurr,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_133,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8067(VarNext)
       => ! [B] :
            ( range_4_0(B)
           => ( v5613(VarNext,B)
            <=> v5613(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_140,axiom,
    ! [VarNext] :
      ( v8067(VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v5613(VarNext,B)
          <=> v8078(VarNext,B) ) ) ) ).

fof(addAssignment_1887,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v8078(VarNext,B)
          <=> v8076(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_195,axiom,
    ! [VarCurr] :
      ( ~ v5393(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v8076(VarCurr,B)
          <=> v8079(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_197,axiom,
    ! [VarCurr] :
      ( v5393(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v8076(VarCurr,B)
          <=> $false ) ) ) ).

fof(addAssignment_1886,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v8079(VarCurr,B)
      <=> v5615(VarCurr,B) ) ) ).

fof(addAssignment_1885,axiom,
    ! [VarCurr] :
      ( v8079(VarCurr,bitIndex4)
    <=> $true ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1513,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8067(VarNext)
      <=> ( v8068(VarNext)
          & v8075(VarNext) ) ) ) ).

fof(addAssignment_1884,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8075(VarNext)
      <=> v8073(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1512,axiom,
    ! [VarCurr] :
      ( v8073(VarCurr)
    <=> ( v5323(VarCurr)
        | v5393(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1511,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8068(VarNext)
      <=> ( v8070(VarNext)
          & v179(VarNext) ) ) ) ).

fof(writeUnaryOperator_719,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8070(VarNext)
      <=> v4675(VarNext) ) ) ).

fof(addAssignmentInitValueVector_64,axiom,
    ! [B] :
      ( range_4_0(B)
     => ( v5613(constB0,B)
      <=> $false ) ) ).

fof(addCaseBooleanConditionEqualRanges1_132,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8049(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v5615(VarNext,B)
            <=> v5615(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_139,axiom,
    ! [VarNext] :
      ( v8049(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v5615(VarNext,B)
          <=> v8061(VarNext,B) ) ) ) ).

fof(addAssignment_1883,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v8061(VarNext,B)
          <=> v8059(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_194,axiom,
    ! [VarCurr] :
      ( ~ v5393(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v8059(VarCurr,B)
          <=> v8062(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_196,axiom,
    ! [VarCurr] :
      ( v5393(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v8059(VarCurr,B)
          <=> $false ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_193,axiom,
    ! [VarCurr] :
      ( ~ v5617(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v8062(VarCurr,B)
          <=> v7873(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_195,axiom,
    ! [VarCurr] :
      ( v5617(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v8062(VarCurr,B)
          <=> v5278(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1510,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8049(VarNext)
      <=> ( v8050(VarNext)
          & v8057(VarNext) ) ) ) ).

fof(addAssignment_1882,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8057(VarNext)
      <=> v8055(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1509,axiom,
    ! [VarCurr] :
      ( v8055(VarCurr)
    <=> ( v8058(VarCurr)
        | v5393(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1508,axiom,
    ! [VarCurr] :
      ( v8058(VarCurr)
    <=> ( v5351(VarCurr)
        | v5617(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1507,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8050(VarNext)
      <=> ( v8052(VarNext)
          & v179(VarNext) ) ) ) ).

fof(writeUnaryOperator_718,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8052(VarNext)
      <=> v4675(VarNext) ) ) ).

fof(addAssignment_1881,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v7873(VarCurr,B)
      <=> v7875(VarCurr,B) ) ) ).

fof(addAssignment_1880,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v7875(VarCurr,B)
      <=> v7877(VarCurr,B) ) ) ).

fof(addAssignment_1879,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v7877(VarCurr,B)
      <=> v7879(VarCurr,B) ) ) ).

fof(addAssignment_1878,axiom,
    ! [VarCurr] :
      ( ( v7879(VarCurr,bitIndex3)
      <=> v7881(VarCurr,bitIndex63) )
      & ( v7879(VarCurr,bitIndex2)
      <=> v7881(VarCurr,bitIndex62) )
      & ( v7879(VarCurr,bitIndex1)
      <=> v7881(VarCurr,bitIndex61) )
      & ( v7879(VarCurr,bitIndex0)
      <=> v7881(VarCurr,bitIndex60) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_131,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8013(VarNext)
       => ! [B] :
            ( range_63_60(B)
           => ( v7881(VarNext,B)
            <=> v7881(VarCurr,B) ) ) ) ) ).

fof(range_axiom_50,axiom,
    ! [B] :
      ( range_63_60(B)
    <=> ( $false
        | bitIndex60 = B
        | bitIndex61 = B
        | bitIndex62 = B
        | bitIndex63 = B ) ) ).

fof(addCaseBooleanConditionShiftedRanges0_8,axiom,
    ! [VarNext] :
      ( v8013(VarNext)
     => ( ( v7881(VarNext,bitIndex63)
        <=> v8043(VarNext,bitIndex3) )
        & ( v7881(VarNext,bitIndex62)
        <=> v8043(VarNext,bitIndex2) )
        & ( v7881(VarNext,bitIndex61)
        <=> v8043(VarNext,bitIndex1) )
        & ( v7881(VarNext,bitIndex60)
        <=> v8043(VarNext,bitIndex0) ) ) ) ).

fof(addAssignment_1877,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v8043(VarNext,B)
          <=> v8041(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_161,axiom,
    ! [VarCurr] :
      ( ~ v7972(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v8041(VarCurr,B)
          <=> v8044(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_151,axiom,
    ! [VarCurr] :
      ( v7972(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v8041(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_66,axiom,
    ! [VarCurr] :
      ( ( ~ v8026(VarCurr)
        & ~ v8028(VarCurr) )
     => ! [B] :
          ( range_3_0(B)
         => ( v8044(VarCurr,B)
          <=> v8005(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_160,axiom,
    ! [VarCurr] :
      ( v8028(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v8044(VarCurr,B)
          <=> v7998(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_9,axiom,
    ! [VarCurr] :
      ( v8026(VarCurr)
     => ( ( v8044(VarCurr,bitIndex3)
        <=> v7881(VarCurr,bitIndex59) )
        & ( v8044(VarCurr,bitIndex2)
        <=> v7881(VarCurr,bitIndex58) )
        & ( v8044(VarCurr,bitIndex1)
        <=> v7881(VarCurr,bitIndex57) )
        & ( v8044(VarCurr,bitIndex0)
        <=> v7881(VarCurr,bitIndex56) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1506,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8013(VarNext)
      <=> ( v8014(VarNext)
          & v8021(VarNext) ) ) ) ).

fof(addAssignment_1876,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8021(VarNext)
      <=> v8019(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1505,axiom,
    ! [VarCurr] :
      ( v8019(VarCurr)
    <=> ( v8022(VarCurr)
        & v8033(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1504,axiom,
    ! [VarCurr] :
      ( v8033(VarCurr)
    <=> ( v8034(VarCurr)
        | v7972(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1503,axiom,
    ! [VarCurr] :
      ( v8034(VarCurr)
    <=> ( v8035(VarCurr)
        & v8038(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1502,axiom,
    ! [VarCurr] :
      ( v8038(VarCurr)
    <=> ( v8039(VarCurr)
        | v8030(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1501,axiom,
    ! [VarCurr] :
      ( v8039(VarCurr)
    <=> ( v8040(VarCurr)
        | v8028(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1500,axiom,
    ! [VarCurr] :
      ( v8040(VarCurr)
    <=> ( v8036(VarCurr)
        | v8026(VarCurr) ) ) ).

fof(writeUnaryOperator_717,axiom,
    ! [VarCurr] :
      ( ~ v8035(VarCurr)
    <=> v8036(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_503,axiom,
    ! [VarCurr] :
      ( v8036(VarCurr)
    <=> ( ( v8037(VarCurr,bitIndex1)
        <=> $false )
        & ( v8037(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1875,axiom,
    ! [VarCurr] :
      ( v8037(VarCurr,bitIndex0)
    <=> v5468(VarCurr) ) ).

fof(addAssignment_1874,axiom,
    ! [VarCurr] :
      ( v8037(VarCurr,bitIndex1)
    <=> v5403(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1499,axiom,
    ! [VarCurr] :
      ( v8022(VarCurr)
    <=> ( v7972(VarCurr)
        | v8023(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1498,axiom,
    ! [VarCurr] :
      ( v8023(VarCurr)
    <=> ( v8024(VarCurr)
        & v8032(VarCurr) ) ) ).

fof(writeUnaryOperator_716,axiom,
    ! [VarCurr] :
      ( ~ v8032(VarCurr)
    <=> v7972(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1497,axiom,
    ! [VarCurr] :
      ( v8024(VarCurr)
    <=> ( v8025(VarCurr)
        | v8030(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_502,axiom,
    ! [VarCurr] :
      ( v8030(VarCurr)
    <=> ( ( v8031(VarCurr,bitIndex1)
        <=> $true )
        & ( v8031(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1873,axiom,
    ! [VarCurr] :
      ( v8031(VarCurr,bitIndex0)
    <=> v5468(VarCurr) ) ).

fof(addAssignment_1872,axiom,
    ! [VarCurr] :
      ( v8031(VarCurr,bitIndex1)
    <=> v5403(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1496,axiom,
    ! [VarCurr] :
      ( v8025(VarCurr)
    <=> ( v8026(VarCurr)
        | v8028(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_501,axiom,
    ! [VarCurr] :
      ( v8028(VarCurr)
    <=> ( ( v8029(VarCurr,bitIndex1)
        <=> $true )
        & ( v8029(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1871,axiom,
    ! [VarCurr] :
      ( v8029(VarCurr,bitIndex0)
    <=> v5468(VarCurr) ) ).

fof(addAssignment_1870,axiom,
    ! [VarCurr] :
      ( v8029(VarCurr,bitIndex1)
    <=> v5403(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_500,axiom,
    ! [VarCurr] :
      ( v8026(VarCurr)
    <=> ( ( v8027(VarCurr,bitIndex1)
        <=> $false )
        & ( v8027(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1869,axiom,
    ! [VarCurr] :
      ( v8027(VarCurr,bitIndex0)
    <=> v5468(VarCurr) ) ).

fof(addAssignment_1868,axiom,
    ! [VarCurr] :
      ( v8027(VarCurr,bitIndex1)
    <=> v5403(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1495,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v8014(VarNext)
      <=> ( v8016(VarNext)
          & v5472(VarNext) ) ) ) ).

fof(writeUnaryOperator_715,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v8016(VarNext)
      <=> v5479(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_192,axiom,
    ! [VarCurr] :
      ( ~ v8007(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v8005(VarCurr,B)
          <=> v8009(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_194,axiom,
    ! [VarCurr] :
      ( v8007(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v8005(VarCurr,B)
          <=> v7939(VarCurr,B) ) ) ) ).

fof(addAssignment_1867,axiom,
    ! [VarCurr] :
      ( ( v8009(VarCurr,bitIndex3)
      <=> v7881(VarCurr,bitIndex59) )
      & ( v8009(VarCurr,bitIndex2)
      <=> v7881(VarCurr,bitIndex58) )
      & ( v8009(VarCurr,bitIndex1)
      <=> v7881(VarCurr,bitIndex57) )
      & ( v8009(VarCurr,bitIndex0)
      <=> v7881(VarCurr,bitIndex56) ) ) ).

fof(addAssignment_1866,axiom,
    ! [VarCurr] :
      ( v8007(VarCurr)
    <=> v7887(VarCurr,bitIndex1) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_191,axiom,
    ! [VarCurr] :
      ( ~ v8000(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v7998(VarCurr,B)
          <=> v8002(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_193,axiom,
    ! [VarCurr] :
      ( v8000(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v7998(VarCurr,B)
          <=> v7939(VarCurr,B) ) ) ) ).

fof(addAssignment_1865,axiom,
    ! [VarCurr] :
      ( ( v8002(VarCurr,bitIndex3)
      <=> v7881(VarCurr,bitIndex63) )
      & ( v8002(VarCurr,bitIndex2)
      <=> v7881(VarCurr,bitIndex62) )
      & ( v8002(VarCurr,bitIndex1)
      <=> v7881(VarCurr,bitIndex61) )
      & ( v8002(VarCurr,bitIndex0)
      <=> v7881(VarCurr,bitIndex60) ) ) ).

fof(addAssignment_1864,axiom,
    ! [VarCurr] :
      ( v8000(VarCurr)
    <=> v7887(VarCurr,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_130,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7962(VarNext)
       => ! [B] :
            ( range_59_56(B)
           => ( v7881(VarNext,B)
            <=> v7881(VarCurr,B) ) ) ) ) ).

fof(range_axiom_49,axiom,
    ! [B] :
      ( range_59_56(B)
    <=> ( $false
        | bitIndex56 = B
        | bitIndex57 = B
        | bitIndex58 = B
        | bitIndex59 = B ) ) ).

fof(addCaseBooleanConditionShiftedRanges0_7,axiom,
    ! [VarNext] :
      ( v7962(VarNext)
     => ( ( v7881(VarNext,bitIndex59)
        <=> v7993(VarNext,bitIndex3) )
        & ( v7881(VarNext,bitIndex58)
        <=> v7993(VarNext,bitIndex2) )
        & ( v7881(VarNext,bitIndex57)
        <=> v7993(VarNext,bitIndex1) )
        & ( v7881(VarNext,bitIndex56)
        <=> v7993(VarNext,bitIndex0) ) ) ) ).

fof(addAssignment_1863,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v7993(VarNext,B)
          <=> v7991(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_159,axiom,
    ! [VarCurr] :
      ( ~ v7972(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v7991(VarCurr,B)
          <=> v7994(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_150,axiom,
    ! [VarCurr] :
      ( v7972(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v7991(VarCurr,B)
          <=> b0001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_65,axiom,
    ! [VarCurr] :
      ( ( ~ v7976(VarCurr)
        & ~ v7978(VarCurr) )
     => ! [B] :
          ( range_3_0(B)
         => ( v7994(VarCurr,B)
          <=> v7954(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_158,axiom,
    ! [VarCurr] :
      ( v7978(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v7994(VarCurr,B)
          <=> v7883(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_8,axiom,
    ! [VarCurr] :
      ( v7976(VarCurr)
     => ( ( v7994(VarCurr,bitIndex3)
        <=> v7881(VarCurr,bitIndex55) )
        & ( v7994(VarCurr,bitIndex2)
        <=> v7881(VarCurr,bitIndex54) )
        & ( v7994(VarCurr,bitIndex1)
        <=> v7881(VarCurr,bitIndex53) )
        & ( v7994(VarCurr,bitIndex0)
        <=> v7881(VarCurr,bitIndex52) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1494,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7962(VarNext)
      <=> ( v7963(VarNext)
          & v7970(VarNext) ) ) ) ).

fof(addAssignment_1862,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7970(VarNext)
      <=> v7968(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1493,axiom,
    ! [VarCurr] :
      ( v7968(VarCurr)
    <=> ( v7971(VarCurr)
        & v7983(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1492,axiom,
    ! [VarCurr] :
      ( v7983(VarCurr)
    <=> ( v7984(VarCurr)
        | v7972(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1491,axiom,
    ! [VarCurr] :
      ( v7984(VarCurr)
    <=> ( v7985(VarCurr)
        & v7988(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1490,axiom,
    ! [VarCurr] :
      ( v7988(VarCurr)
    <=> ( v7989(VarCurr)
        | v7980(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1489,axiom,
    ! [VarCurr] :
      ( v7989(VarCurr)
    <=> ( v7990(VarCurr)
        | v7978(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1488,axiom,
    ! [VarCurr] :
      ( v7990(VarCurr)
    <=> ( v7986(VarCurr)
        | v7976(VarCurr) ) ) ).

fof(writeUnaryOperator_714,axiom,
    ! [VarCurr] :
      ( ~ v7985(VarCurr)
    <=> v7986(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_499,axiom,
    ! [VarCurr] :
      ( v7986(VarCurr)
    <=> ( ( v7987(VarCurr,bitIndex1)
        <=> $false )
        & ( v7987(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1861,axiom,
    ! [VarCurr] :
      ( v7987(VarCurr,bitIndex0)
    <=> v5468(VarCurr) ) ).

fof(addAssignment_1860,axiom,
    ! [VarCurr] :
      ( v7987(VarCurr,bitIndex1)
    <=> v5403(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1487,axiom,
    ! [VarCurr] :
      ( v7971(VarCurr)
    <=> ( v7972(VarCurr)
        | v7973(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1486,axiom,
    ! [VarCurr] :
      ( v7973(VarCurr)
    <=> ( v7974(VarCurr)
        & v7982(VarCurr) ) ) ).

fof(writeUnaryOperator_713,axiom,
    ! [VarCurr] :
      ( ~ v7982(VarCurr)
    <=> v7972(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1485,axiom,
    ! [VarCurr] :
      ( v7974(VarCurr)
    <=> ( v7975(VarCurr)
        | v7980(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_498,axiom,
    ! [VarCurr] :
      ( v7980(VarCurr)
    <=> ( ( v7981(VarCurr,bitIndex1)
        <=> $true )
        & ( v7981(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1859,axiom,
    ! [VarCurr] :
      ( v7981(VarCurr,bitIndex0)
    <=> v5468(VarCurr) ) ).

fof(addAssignment_1858,axiom,
    ! [VarCurr] :
      ( v7981(VarCurr,bitIndex1)
    <=> v5403(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1484,axiom,
    ! [VarCurr] :
      ( v7975(VarCurr)
    <=> ( v7976(VarCurr)
        | v7978(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_497,axiom,
    ! [VarCurr] :
      ( v7978(VarCurr)
    <=> ( ( v7979(VarCurr,bitIndex1)
        <=> $true )
        & ( v7979(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1857,axiom,
    ! [VarCurr] :
      ( v7979(VarCurr,bitIndex0)
    <=> v5468(VarCurr) ) ).

fof(addAssignment_1856,axiom,
    ! [VarCurr] :
      ( v7979(VarCurr,bitIndex1)
    <=> v5403(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_496,axiom,
    ! [VarCurr] :
      ( v7976(VarCurr)
    <=> ( ( v7977(VarCurr,bitIndex1)
        <=> $false )
        & ( v7977(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1855,axiom,
    ! [VarCurr] :
      ( v7977(VarCurr,bitIndex0)
    <=> v5468(VarCurr) ) ).

fof(addAssignment_1854,axiom,
    ! [VarCurr] :
      ( v7977(VarCurr,bitIndex1)
    <=> v5403(VarCurr) ) ).

fof(writeUnaryOperator_712,axiom,
    ! [VarCurr] :
      ( ~ v7972(VarCurr)
    <=> v5401(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1483,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7963(VarNext)
      <=> ( v7964(VarNext)
          & v5472(VarNext) ) ) ) ).

fof(writeUnaryOperator_711,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7964(VarNext)
      <=> v5479(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_190,axiom,
    ! [VarCurr] :
      ( ~ v7956(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v7954(VarCurr,B)
          <=> v7958(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_192,axiom,
    ! [VarCurr] :
      ( v7956(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v7954(VarCurr,B)
          <=> v7939(VarCurr,B) ) ) ) ).

fof(addAssignment_1853,axiom,
    ! [VarCurr] :
      ( ( v7958(VarCurr,bitIndex3)
      <=> v7881(VarCurr,bitIndex55) )
      & ( v7958(VarCurr,bitIndex2)
      <=> v7881(VarCurr,bitIndex54) )
      & ( v7958(VarCurr,bitIndex1)
      <=> v7881(VarCurr,bitIndex53) )
      & ( v7958(VarCurr,bitIndex0)
      <=> v7881(VarCurr,bitIndex52) ) ) ).

fof(addAssignment_1852,axiom,
    ! [VarCurr] :
      ( v7956(VarCurr)
    <=> v7887(VarCurr,bitIndex2) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_189,axiom,
    ! [VarCurr] :
      ( ~ v7885(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v7883(VarCurr,B)
          <=> v7951(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_191,axiom,
    ! [VarCurr] :
      ( v7885(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v7883(VarCurr,B)
          <=> v7939(VarCurr,B) ) ) ) ).

fof(addAssignment_1851,axiom,
    ! [VarCurr] :
      ( ( v7951(VarCurr,bitIndex3)
      <=> v7881(VarCurr,bitIndex59) )
      & ( v7951(VarCurr,bitIndex2)
      <=> v7881(VarCurr,bitIndex58) )
      & ( v7951(VarCurr,bitIndex1)
      <=> v7881(VarCurr,bitIndex57) )
      & ( v7951(VarCurr,bitIndex0)
      <=> v7881(VarCurr,bitIndex56) ) ) ).

fof(addAssignmentInitValueVector_63,axiom,
    ( ( v7881(constB0,bitIndex63)
    <=> $false )
    & ( v7881(constB0,bitIndex62)
    <=> $false )
    & ( v7881(constB0,bitIndex61)
    <=> $false )
    & ( v7881(constB0,bitIndex60)
    <=> $false ) ) ).

fof(addAssignmentInitValue_170,axiom,
    ~ v7881(constB0,bitIndex59) ).

fof(addAssignmentInitValue_169,axiom,
    ~ v7881(constB0,bitIndex58) ).

fof(addAssignmentInitValue_168,axiom,
    ~ v7881(constB0,bitIndex57) ).

fof(addAssignmentInitValue_167,axiom,
    v7881(constB0,bitIndex56) ).

fof(addAssignment_1850,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v7939(VarCurr,B)
      <=> v7941(VarCurr,B) ) ) ).

fof(addAssignment_1849,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v7941(VarCurr,B)
      <=> v5428(VarCurr,B) ) ) ).

fof(addAssignment_1848,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v5428(VarCurr,B)
      <=> v5430(VarCurr,B) ) ) ).

fof(addAssignment_1847,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v5430(VarCurr,B)
      <=> v5432(VarCurr,B) ) ) ).

fof(addAssignment_1846,axiom,
    ! [VarNext,B] :
      ( range_3_0(B)
     => ( v5432(VarNext,B)
      <=> v7943(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_129,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7945(VarNext)
       => ! [B] :
            ( range_16_0(B)
           => ( v7943(VarNext,B)
            <=> v5432(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_138,axiom,
    ! [VarNext] :
      ( v7945(VarNext)
     => ! [B] :
          ( range_16_0(B)
         => ( v7943(VarNext,B)
          <=> v5451(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1482,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7945(VarNext)
      <=> ( v7946(VarNext)
          & v5448(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1481,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7946(VarNext)
      <=> ( v7948(VarNext)
          & v179(VarNext) ) ) ) ).

fof(writeUnaryOperator_710,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7948(VarNext)
      <=> v4675(VarNext) ) ) ).

fof(addAssignment_1845,axiom,
    ! [VarCurr] :
      ( v7885(VarCurr)
    <=> v7887(VarCurr,bitIndex2) ) ).

fof(addAssignment_1844,axiom,
    ! [VarCurr] :
      ( v7887(VarCurr,bitIndex2)
    <=> v7907(VarCurr,bitIndex2) ) ).

fof(addAssignment_1843,axiom,
    ! [VarNext] :
      ( v7890(VarNext,bitIndex1)
    <=> v7931(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_128,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7932(VarNext)
       => ! [B] :
            ( range_16_0(B)
           => ( v7931(VarNext,B)
            <=> v7890(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_137,axiom,
    ! [VarNext] :
      ( v7932(VarNext)
     => ! [B] :
          ( range_16_0(B)
         => ( v7931(VarNext,B)
          <=> v7903(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1480,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7932(VarNext)
      <=> v7933(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1479,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7933(VarNext)
      <=> ( v7935(VarNext)
          & v5472(VarNext) ) ) ) ).

fof(writeUnaryOperator_709,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7935(VarNext)
      <=> v5479(VarNext) ) ) ).

fof(addAssignment_1842,axiom,
    ! [VarCurr] :
      ( v7887(VarCurr,bitIndex1)
    <=> v7907(VarCurr,bitIndex1) ) ).

fof(addAssignment_1841,axiom,
    ! [VarNext] :
      ( v7890(VarNext,bitIndex0)
    <=> v7923(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionEqualRanges1_127,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7924(VarNext)
       => ! [B] :
            ( range_16_0(B)
           => ( v7923(VarNext,B)
            <=> v7890(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_136,axiom,
    ! [VarNext] :
      ( v7924(VarNext)
     => ! [B] :
          ( range_16_0(B)
         => ( v7923(VarNext,B)
          <=> v7903(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1478,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7924(VarNext)
      <=> v7925(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1477,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7925(VarNext)
      <=> ( v7927(VarNext)
          & v5472(VarNext) ) ) ) ).

fof(writeUnaryOperator_708,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7927(VarNext)
      <=> v5479(VarNext) ) ) ).

fof(addAssignment_1840,axiom,
    ! [VarCurr] :
      ( v7887(VarCurr,bitIndex0)
    <=> v7907(VarCurr,bitIndex0) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_188,axiom,
    ! [VarCurr] :
      ( ~ v7908(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v7907(VarCurr,B)
          <=> v7909(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_190,axiom,
    ! [VarCurr] :
      ( v7908(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v7907(VarCurr,B)
          <=> b10000000000000000(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_5,axiom,
    ! [VarCurr] :
      ( ( ~ v7910(VarCurr)
        & ~ v7912(VarCurr)
        & ~ v7916(VarCurr)
        & ~ v7920(VarCurr) )
     => ! [B] :
          ( range_16_0(B)
         => ( v7909(VarCurr,B)
          <=> v7890(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_29,axiom,
    ! [VarCurr] :
      ( v7920(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v7909(VarCurr,B)
          <=> v7890(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_64,axiom,
    ! [VarCurr] :
      ( v7916(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v7909(VarCurr,B)
          <=> v7918(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_157,axiom,
    ! [VarCurr] :
      ( v7912(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v7909(VarCurr,B)
          <=> v7914(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_149,axiom,
    ! [VarCurr] :
      ( v7910(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v7909(VarCurr,B)
          <=> v7890(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_495,axiom,
    ! [VarCurr] :
      ( v7920(VarCurr)
    <=> ( ( v7921(VarCurr,bitIndex1)
        <=> $true )
        & ( v7921(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1839,axiom,
    ! [VarCurr] :
      ( v7921(VarCurr,bitIndex0)
    <=> v5468(VarCurr) ) ).

fof(addAssignment_1838,axiom,
    ! [VarCurr] :
      ( v7921(VarCurr,bitIndex1)
    <=> v5403(VarCurr) ) ).

fof(addAssignment_1837,axiom,
    ! [VarCurr] :
      ( v7918(VarCurr,bitIndex0)
    <=> $false ) ).

fof(addAssignment_1836,axiom,
    ! [VarCurr] :
      ( ( v7918(VarCurr,bitIndex16)
      <=> v7890(VarCurr,bitIndex15) )
      & ( v7918(VarCurr,bitIndex15)
      <=> v7890(VarCurr,bitIndex14) )
      & ( v7918(VarCurr,bitIndex14)
      <=> v7890(VarCurr,bitIndex13) )
      & ( v7918(VarCurr,bitIndex13)
      <=> v7890(VarCurr,bitIndex12) )
      & ( v7918(VarCurr,bitIndex12)
      <=> v7890(VarCurr,bitIndex11) )
      & ( v7918(VarCurr,bitIndex11)
      <=> v7890(VarCurr,bitIndex10) )
      & ( v7918(VarCurr,bitIndex10)
      <=> v7890(VarCurr,bitIndex9) )
      & ( v7918(VarCurr,bitIndex9)
      <=> v7890(VarCurr,bitIndex8) )
      & ( v7918(VarCurr,bitIndex8)
      <=> v7890(VarCurr,bitIndex7) )
      & ( v7918(VarCurr,bitIndex7)
      <=> v7890(VarCurr,bitIndex6) )
      & ( v7918(VarCurr,bitIndex6)
      <=> v7890(VarCurr,bitIndex5) )
      & ( v7918(VarCurr,bitIndex5)
      <=> v7890(VarCurr,bitIndex4) )
      & ( v7918(VarCurr,bitIndex4)
      <=> v7890(VarCurr,bitIndex3) )
      & ( v7918(VarCurr,bitIndex3)
      <=> v7890(VarCurr,bitIndex2) )
      & ( v7918(VarCurr,bitIndex2)
      <=> v7890(VarCurr,bitIndex1) )
      & ( v7918(VarCurr,bitIndex1)
      <=> v7890(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_494,axiom,
    ! [VarCurr] :
      ( v7916(VarCurr)
    <=> ( ( v7917(VarCurr,bitIndex1)
        <=> $true )
        & ( v7917(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1835,axiom,
    ! [VarCurr] :
      ( v7917(VarCurr,bitIndex0)
    <=> v5468(VarCurr) ) ).

fof(addAssignment_1834,axiom,
    ! [VarCurr] :
      ( v7917(VarCurr,bitIndex1)
    <=> v5403(VarCurr) ) ).

fof(addAssignment_1833,axiom,
    ! [VarCurr] :
      ( ( v7914(VarCurr,bitIndex15)
      <=> v7890(VarCurr,bitIndex16) )
      & ( v7914(VarCurr,bitIndex14)
      <=> v7890(VarCurr,bitIndex15) )
      & ( v7914(VarCurr,bitIndex13)
      <=> v7890(VarCurr,bitIndex14) )
      & ( v7914(VarCurr,bitIndex12)
      <=> v7890(VarCurr,bitIndex13) )
      & ( v7914(VarCurr,bitIndex11)
      <=> v7890(VarCurr,bitIndex12) )
      & ( v7914(VarCurr,bitIndex10)
      <=> v7890(VarCurr,bitIndex11) )
      & ( v7914(VarCurr,bitIndex9)
      <=> v7890(VarCurr,bitIndex10) )
      & ( v7914(VarCurr,bitIndex8)
      <=> v7890(VarCurr,bitIndex9) )
      & ( v7914(VarCurr,bitIndex7)
      <=> v7890(VarCurr,bitIndex8) )
      & ( v7914(VarCurr,bitIndex6)
      <=> v7890(VarCurr,bitIndex7) )
      & ( v7914(VarCurr,bitIndex5)
      <=> v7890(VarCurr,bitIndex6) )
      & ( v7914(VarCurr,bitIndex4)
      <=> v7890(VarCurr,bitIndex5) )
      & ( v7914(VarCurr,bitIndex3)
      <=> v7890(VarCurr,bitIndex4) )
      & ( v7914(VarCurr,bitIndex2)
      <=> v7890(VarCurr,bitIndex3) )
      & ( v7914(VarCurr,bitIndex1)
      <=> v7890(VarCurr,bitIndex2) )
      & ( v7914(VarCurr,bitIndex0)
      <=> v7890(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_1832,axiom,
    ! [VarCurr] :
      ( v7914(VarCurr,bitIndex16)
    <=> $false ) ).

fof(addBitVectorEqualityBitBlasted_493,axiom,
    ! [VarCurr] :
      ( v7912(VarCurr)
    <=> ( ( v7913(VarCurr,bitIndex1)
        <=> $false )
        & ( v7913(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1831,axiom,
    ! [VarCurr] :
      ( v7913(VarCurr,bitIndex0)
    <=> v5468(VarCurr) ) ).

fof(addAssignment_1830,axiom,
    ! [VarCurr] :
      ( v7913(VarCurr,bitIndex1)
    <=> v5403(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_492,axiom,
    ! [VarCurr] :
      ( v7910(VarCurr)
    <=> ( ( v7911(VarCurr,bitIndex1)
        <=> $false )
        & ( v7911(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1829,axiom,
    ! [VarCurr] :
      ( v7911(VarCurr,bitIndex0)
    <=> v5468(VarCurr) ) ).

fof(addAssignment_1828,axiom,
    ! [VarCurr] :
      ( v7911(VarCurr,bitIndex1)
    <=> v5403(VarCurr) ) ).

fof(writeUnaryOperator_707,axiom,
    ! [VarCurr] :
      ( ~ v7908(VarCurr)
    <=> v5401(VarCurr) ) ).

fof(addAssignment_1827,axiom,
    ! [VarNext] :
      ( v7890(VarNext,bitIndex2)
    <=> v7894(VarNext,bitIndex2) ) ).

fof(addCaseBooleanConditionEqualRanges1_126,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7895(VarNext)
       => ! [B] :
            ( range_16_0(B)
           => ( v7894(VarNext,B)
            <=> v7890(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_135,axiom,
    ! [VarNext] :
      ( v7895(VarNext)
     => ! [B] :
          ( range_16_0(B)
         => ( v7894(VarNext,B)
          <=> v7903(VarNext,B) ) ) ) ).

fof(addAssignment_1826,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_16_0(B)
         => ( v7903(VarNext,B)
          <=> v7901(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_187,axiom,
    ! [VarCurr] :
      ( ~ v7904(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v7901(VarCurr,B)
          <=> v7887(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_189,axiom,
    ! [VarCurr] :
      ( v7904(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v7901(VarCurr,B)
          <=> b10000000000000000(B) ) ) ) ).

fof(bitBlastConstant_916,axiom,
    b10000000000000000(bitIndex16) ).

fof(bitBlastConstant_915,axiom,
    ~ b10000000000000000(bitIndex15) ).

fof(bitBlastConstant_914,axiom,
    ~ b10000000000000000(bitIndex14) ).

fof(bitBlastConstant_913,axiom,
    ~ b10000000000000000(bitIndex13) ).

fof(bitBlastConstant_912,axiom,
    ~ b10000000000000000(bitIndex12) ).

fof(bitBlastConstant_911,axiom,
    ~ b10000000000000000(bitIndex11) ).

fof(bitBlastConstant_910,axiom,
    ~ b10000000000000000(bitIndex10) ).

fof(bitBlastConstant_909,axiom,
    ~ b10000000000000000(bitIndex9) ).

fof(bitBlastConstant_908,axiom,
    ~ b10000000000000000(bitIndex8) ).

fof(bitBlastConstant_907,axiom,
    ~ b10000000000000000(bitIndex7) ).

fof(bitBlastConstant_906,axiom,
    ~ b10000000000000000(bitIndex6) ).

fof(bitBlastConstant_905,axiom,
    ~ b10000000000000000(bitIndex5) ).

fof(bitBlastConstant_904,axiom,
    ~ b10000000000000000(bitIndex4) ).

fof(bitBlastConstant_903,axiom,
    ~ b10000000000000000(bitIndex3) ).

fof(bitBlastConstant_902,axiom,
    ~ b10000000000000000(bitIndex2) ).

fof(bitBlastConstant_901,axiom,
    ~ b10000000000000000(bitIndex1) ).

fof(bitBlastConstant_900,axiom,
    ~ b10000000000000000(bitIndex0) ).

fof(writeUnaryOperator_706,axiom,
    ! [VarCurr] :
      ( ~ v7904(VarCurr)
    <=> v5401(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1476,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7895(VarNext)
      <=> v7896(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1475,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7896(VarNext)
      <=> ( v7897(VarNext)
          & v5472(VarNext) ) ) ) ).

fof(writeUnaryOperator_705,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7897(VarNext)
      <=> v5479(VarNext) ) ) ).

fof(addAssignmentInitValue_166,axiom,
    ~ v7890(constB0,bitIndex2) ).

fof(addAssignmentInitValue_165,axiom,
    ~ v7890(constB0,bitIndex1) ).

fof(addAssignmentInitValue_164,axiom,
    ~ v7890(constB0,bitIndex0) ).

fof(bitBlastConstant_899,axiom,
    ~ bxxxxxxxxxxxxxx000(bitIndex2) ).

fof(bitBlastConstant_898,axiom,
    ~ bxxxxxxxxxxxxxx000(bitIndex1) ).

fof(bitBlastConstant_897,axiom,
    ~ bxxxxxxxxxxxxxx000(bitIndex0) ).

fof(addAssignment_1825,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v5278(VarCurr,B)
      <=> v5280(VarCurr,B) ) ) ).

fof(addAssignment_1824,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v5280(VarCurr,B)
      <=> v5282(VarCurr,B) ) ) ).

fof(addAssignment_1823,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v5282(VarCurr,B)
      <=> v5284(VarCurr,B) ) ) ).

fof(addAssignment_1822,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v5284(VarCurr,B)
      <=> v7871(VarCurr,B) ) ) ).

fof(addAssignment_1821,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v7748(VarCurr,B)
      <=> v7750(VarCurr,B) ) ) ).

fof(addAssignment_1820,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v7750(VarCurr,B)
      <=> v7752(VarCurr,B) ) ) ).

fof(addAssignment_1819,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v7752(VarCurr,B)
      <=> v7754(VarCurr,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_125,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7757(VarNext)
       => ! [B] :
            ( range_4_0(B)
           => ( v7754(VarNext,B)
            <=> v7754(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_134,axiom,
    ! [VarNext] :
      ( v7757(VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v7754(VarNext,B)
          <=> v7775(VarNext,B) ) ) ) ).

fof(addAssignment_1818,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v7775(VarNext,B)
          <=> v7773(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_156,axiom,
    ! [VarCurr] :
      ( ~ v5393(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v7773(VarCurr,B)
          <=> v7776(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_148,axiom,
    ! [VarCurr] :
      ( v5393(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v7773(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_155,axiom,
    ! [VarCurr] :
      ( ~ v7777(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v7776(VarCurr,B)
          <=> v7812(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_147,axiom,
    ! [VarCurr] :
      ( v7777(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v7776(VarCurr,B)
          <=> v7782(VarCurr,B) ) ) ) ).

fof(addAssignment_1817,axiom,
    ! [VarCurr] :
      ( v7812(VarCurr,bitIndex0)
    <=> v7864(VarCurr) ) ).

fof(addAssignment_1816,axiom,
    ! [VarCurr] :
      ( v7812(VarCurr,bitIndex1)
    <=> v7859(VarCurr) ) ).

fof(addAssignment_1815,axiom,
    ! [VarCurr] :
      ( v7812(VarCurr,bitIndex2)
    <=> v7854(VarCurr) ) ).

fof(addAssignment_1814,axiom,
    ! [VarCurr] :
      ( v7812(VarCurr,bitIndex3)
    <=> v7849(VarCurr) ) ).

fof(addAssignment_1813,axiom,
    ! [VarCurr] :
      ( v7812(VarCurr,bitIndex4)
    <=> v7814(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1474,axiom,
    ! [VarCurr] :
      ( v7864(VarCurr)
    <=> ( v7865(VarCurr)
        & v7868(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_355,axiom,
    ! [VarCurr] :
      ( v7868(VarCurr)
    <=> ( v4921(VarCurr,bitIndex33)
        | v4695(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1473,axiom,
    ! [VarCurr] :
      ( v7865(VarCurr)
    <=> ( v7866(VarCurr)
        | v7867(VarCurr) ) ) ).

fof(writeUnaryOperator_704,axiom,
    ! [VarCurr] :
      ( ~ v7867(VarCurr)
    <=> v4695(VarCurr,bitIndex0) ) ).

fof(writeUnaryOperator_703,axiom,
    ! [VarCurr] :
      ( ~ v7866(VarCurr)
    <=> v4921(VarCurr,bitIndex33) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1472,axiom,
    ! [VarCurr] :
      ( v7859(VarCurr)
    <=> ( v7860(VarCurr)
        & v7863(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1471,axiom,
    ! [VarCurr] :
      ( v7863(VarCurr)
    <=> ( v7823(VarCurr)
        | v7824(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1470,axiom,
    ! [VarCurr] :
      ( v7860(VarCurr)
    <=> ( v7861(VarCurr)
        | v7862(VarCurr) ) ) ).

fof(writeUnaryOperator_702,axiom,
    ! [VarCurr] :
      ( ~ v7862(VarCurr)
    <=> v7824(VarCurr) ) ).

fof(writeUnaryOperator_701,axiom,
    ! [VarCurr] :
      ( ~ v7861(VarCurr)
    <=> v7823(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1469,axiom,
    ! [VarCurr] :
      ( v7854(VarCurr)
    <=> ( v7855(VarCurr)
        & v7858(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1468,axiom,
    ! [VarCurr] :
      ( v7858(VarCurr)
    <=> ( v7821(VarCurr)
        | v7830(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1467,axiom,
    ! [VarCurr] :
      ( v7855(VarCurr)
    <=> ( v7856(VarCurr)
        | v7857(VarCurr) ) ) ).

fof(writeUnaryOperator_700,axiom,
    ! [VarCurr] :
      ( ~ v7857(VarCurr)
    <=> v7830(VarCurr) ) ).

fof(writeUnaryOperator_699,axiom,
    ! [VarCurr] :
      ( ~ v7856(VarCurr)
    <=> v7821(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1466,axiom,
    ! [VarCurr] :
      ( v7849(VarCurr)
    <=> ( v7850(VarCurr)
        & v7853(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1465,axiom,
    ! [VarCurr] :
      ( v7853(VarCurr)
    <=> ( v7819(VarCurr)
        | v7836(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1464,axiom,
    ! [VarCurr] :
      ( v7850(VarCurr)
    <=> ( v7851(VarCurr)
        | v7852(VarCurr) ) ) ).

fof(writeUnaryOperator_698,axiom,
    ! [VarCurr] :
      ( ~ v7852(VarCurr)
    <=> v7836(VarCurr) ) ).

fof(writeUnaryOperator_697,axiom,
    ! [VarCurr] :
      ( ~ v7851(VarCurr)
    <=> v7819(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1463,axiom,
    ! [VarCurr] :
      ( v7814(VarCurr)
    <=> ( v7815(VarCurr)
        & v7848(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1462,axiom,
    ! [VarCurr] :
      ( v7848(VarCurr)
    <=> ( v7817(VarCurr)
        | v7843(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1461,axiom,
    ! [VarCurr] :
      ( v7815(VarCurr)
    <=> ( v7816(VarCurr)
        | v7842(VarCurr) ) ) ).

fof(writeUnaryOperator_696,axiom,
    ! [VarCurr] :
      ( ~ v7842(VarCurr)
    <=> v7843(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1460,axiom,
    ! [VarCurr] :
      ( v7843(VarCurr)
    <=> ( v7844(VarCurr)
        & v7847(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_354,axiom,
    ! [VarCurr] :
      ( v7847(VarCurr)
    <=> ( v4921(VarCurr,bitIndex37)
        | v4695(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1459,axiom,
    ! [VarCurr] :
      ( v7844(VarCurr)
    <=> ( v7845(VarCurr)
        | v7846(VarCurr) ) ) ).

fof(writeUnaryOperator_695,axiom,
    ! [VarCurr] :
      ( ~ v7846(VarCurr)
    <=> v4695(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_694,axiom,
    ! [VarCurr] :
      ( ~ v7845(VarCurr)
    <=> v4921(VarCurr,bitIndex37) ) ).

fof(writeUnaryOperator_693,axiom,
    ! [VarCurr] :
      ( ~ v7816(VarCurr)
    <=> v7817(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1458,axiom,
    ! [VarCurr] :
      ( v7817(VarCurr)
    <=> ( v7818(VarCurr)
        | v7841(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_353,axiom,
    ! [VarCurr] :
      ( v7841(VarCurr)
    <=> ( v4921(VarCurr,bitIndex36)
        & v4695(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1457,axiom,
    ! [VarCurr] :
      ( v7818(VarCurr)
    <=> ( v7819(VarCurr)
        & v7836(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1456,axiom,
    ! [VarCurr] :
      ( v7836(VarCurr)
    <=> ( v7837(VarCurr)
        & v7840(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_352,axiom,
    ! [VarCurr] :
      ( v7840(VarCurr)
    <=> ( v4921(VarCurr,bitIndex36)
        | v4695(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1455,axiom,
    ! [VarCurr] :
      ( v7837(VarCurr)
    <=> ( v7838(VarCurr)
        | v7839(VarCurr) ) ) ).

fof(writeUnaryOperator_692,axiom,
    ! [VarCurr] :
      ( ~ v7839(VarCurr)
    <=> v4695(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_691,axiom,
    ! [VarCurr] :
      ( ~ v7838(VarCurr)
    <=> v4921(VarCurr,bitIndex36) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1454,axiom,
    ! [VarCurr] :
      ( v7819(VarCurr)
    <=> ( v7820(VarCurr)
        | v7835(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_351,axiom,
    ! [VarCurr] :
      ( v7835(VarCurr)
    <=> ( v4921(VarCurr,bitIndex35)
        & v4695(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1453,axiom,
    ! [VarCurr] :
      ( v7820(VarCurr)
    <=> ( v7821(VarCurr)
        & v7830(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1452,axiom,
    ! [VarCurr] :
      ( v7830(VarCurr)
    <=> ( v7831(VarCurr)
        & v7834(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_350,axiom,
    ! [VarCurr] :
      ( v7834(VarCurr)
    <=> ( v4921(VarCurr,bitIndex35)
        | v4695(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1451,axiom,
    ! [VarCurr] :
      ( v7831(VarCurr)
    <=> ( v7832(VarCurr)
        | v7833(VarCurr) ) ) ).

fof(writeUnaryOperator_690,axiom,
    ! [VarCurr] :
      ( ~ v7833(VarCurr)
    <=> v4695(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_689,axiom,
    ! [VarCurr] :
      ( ~ v7832(VarCurr)
    <=> v4921(VarCurr,bitIndex35) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1450,axiom,
    ! [VarCurr] :
      ( v7821(VarCurr)
    <=> ( v7822(VarCurr)
        | v7829(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_349,axiom,
    ! [VarCurr] :
      ( v7829(VarCurr)
    <=> ( v4921(VarCurr,bitIndex34)
        & v4695(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1449,axiom,
    ! [VarCurr] :
      ( v7822(VarCurr)
    <=> ( v7823(VarCurr)
        & v7824(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1448,axiom,
    ! [VarCurr] :
      ( v7824(VarCurr)
    <=> ( v7825(VarCurr)
        & v7828(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_348,axiom,
    ! [VarCurr] :
      ( v7828(VarCurr)
    <=> ( v4921(VarCurr,bitIndex34)
        | v4695(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1447,axiom,
    ! [VarCurr] :
      ( v7825(VarCurr)
    <=> ( v7826(VarCurr)
        | v7827(VarCurr) ) ) ).

fof(writeUnaryOperator_688,axiom,
    ! [VarCurr] :
      ( ~ v7827(VarCurr)
    <=> v4695(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_687,axiom,
    ! [VarCurr] :
      ( ~ v7826(VarCurr)
    <=> v4921(VarCurr,bitIndex34) ) ).

fof(writeBinaryOperatorShiftedRanges_347,axiom,
    ! [VarCurr] :
      ( v7823(VarCurr)
    <=> ( v4921(VarCurr,bitIndex33)
        & v4695(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1446,axiom,
    ! [VarCurr] :
      ( v7807(VarCurr)
    <=> ( v7808(VarCurr)
        | v7810(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_491,axiom,
    ! [VarCurr] :
      ( v7810(VarCurr)
    <=> ( ( v7811(VarCurr,bitIndex1)
        <=> $false )
        & ( v7811(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1812,axiom,
    ! [VarCurr] :
      ( v7811(VarCurr,bitIndex0)
    <=> v4666(VarCurr) ) ).

fof(addAssignment_1811,axiom,
    ! [VarCurr] :
      ( v7811(VarCurr,bitIndex1)
    <=> v3173(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_490,axiom,
    ! [VarCurr] :
      ( v7808(VarCurr)
    <=> ( ( v7809(VarCurr,bitIndex1)
        <=> $false )
        & ( v7809(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1810,axiom,
    ! [VarCurr] :
      ( v7809(VarCurr,bitIndex0)
    <=> v4666(VarCurr) ) ).

fof(addAssignment_1809,axiom,
    ! [VarCurr] :
      ( v7809(VarCurr,bitIndex1)
    <=> v3173(VarCurr) ) ).

fof(addAssignment_1808,axiom,
    ! [VarCurr] :
      ( v7782(VarCurr,bitIndex0)
    <=> v7804(VarCurr) ) ).

fof(addAssignment_1807,axiom,
    ! [VarCurr] :
      ( v7782(VarCurr,bitIndex1)
    <=> v7802(VarCurr) ) ).

fof(addAssignment_1806,axiom,
    ! [VarCurr] :
      ( v7782(VarCurr,bitIndex2)
    <=> v7797(VarCurr) ) ).

fof(addAssignment_1805,axiom,
    ! [VarCurr] :
      ( v7782(VarCurr,bitIndex3)
    <=> v7792(VarCurr) ) ).

fof(addAssignment_1804,axiom,
    ! [VarCurr] :
      ( v7782(VarCurr,bitIndex4)
    <=> v7784(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1445,axiom,
    ! [VarCurr] :
      ( v7802(VarCurr)
    <=> ( v7803(VarCurr)
        & v7806(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_346,axiom,
    ! [VarCurr] :
      ( v7806(VarCurr)
    <=> ( v7754(VarCurr,bitIndex0)
        | v7754(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1444,axiom,
    ! [VarCurr] :
      ( v7803(VarCurr)
    <=> ( v7804(VarCurr)
        | v7805(VarCurr) ) ) ).

fof(writeUnaryOperator_686,axiom,
    ! [VarCurr] :
      ( ~ v7805(VarCurr)
    <=> v7754(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_685,axiom,
    ! [VarCurr] :
      ( ~ v7804(VarCurr)
    <=> v7754(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1443,axiom,
    ! [VarCurr] :
      ( v7797(VarCurr)
    <=> ( v7798(VarCurr)
        & v7801(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_345,axiom,
    ! [VarCurr] :
      ( v7801(VarCurr)
    <=> ( v7789(VarCurr)
        | v7754(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1442,axiom,
    ! [VarCurr] :
      ( v7798(VarCurr)
    <=> ( v7799(VarCurr)
        | v7800(VarCurr) ) ) ).

fof(writeUnaryOperator_684,axiom,
    ! [VarCurr] :
      ( ~ v7800(VarCurr)
    <=> v7754(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_683,axiom,
    ! [VarCurr] :
      ( ~ v7799(VarCurr)
    <=> v7789(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1441,axiom,
    ! [VarCurr] :
      ( v7792(VarCurr)
    <=> ( v7793(VarCurr)
        & v7796(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_344,axiom,
    ! [VarCurr] :
      ( v7796(VarCurr)
    <=> ( v7788(VarCurr)
        | v7754(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1440,axiom,
    ! [VarCurr] :
      ( v7793(VarCurr)
    <=> ( v7794(VarCurr)
        | v7795(VarCurr) ) ) ).

fof(writeUnaryOperator_682,axiom,
    ! [VarCurr] :
      ( ~ v7795(VarCurr)
    <=> v7754(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_681,axiom,
    ! [VarCurr] :
      ( ~ v7794(VarCurr)
    <=> v7788(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1439,axiom,
    ! [VarCurr] :
      ( v7784(VarCurr)
    <=> ( v7785(VarCurr)
        & v7791(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_343,axiom,
    ! [VarCurr] :
      ( v7791(VarCurr)
    <=> ( v7787(VarCurr)
        | v7754(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1438,axiom,
    ! [VarCurr] :
      ( v7785(VarCurr)
    <=> ( v7786(VarCurr)
        | v7790(VarCurr) ) ) ).

fof(writeUnaryOperator_680,axiom,
    ! [VarCurr] :
      ( ~ v7790(VarCurr)
    <=> v7754(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_679,axiom,
    ! [VarCurr] :
      ( ~ v7786(VarCurr)
    <=> v7787(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_342,axiom,
    ! [VarCurr] :
      ( v7787(VarCurr)
    <=> ( v7788(VarCurr)
        & v7754(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_341,axiom,
    ! [VarCurr] :
      ( v7788(VarCurr)
    <=> ( v7789(VarCurr)
        & v7754(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_340,axiom,
    ! [VarCurr] :
      ( v7789(VarCurr)
    <=> ( v7754(VarCurr,bitIndex0)
        & v7754(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1437,axiom,
    ! [VarCurr] :
      ( v7777(VarCurr)
    <=> ( v7778(VarCurr)
        | v7780(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_489,axiom,
    ! [VarCurr] :
      ( v7780(VarCurr)
    <=> ( ( v7781(VarCurr,bitIndex1)
        <=> $true )
        & ( v7781(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1803,axiom,
    ! [VarCurr] :
      ( v7781(VarCurr,bitIndex0)
    <=> v4666(VarCurr) ) ).

fof(addAssignment_1802,axiom,
    ! [VarCurr] :
      ( v7781(VarCurr,bitIndex1)
    <=> v3173(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_488,axiom,
    ! [VarCurr] :
      ( v7778(VarCurr)
    <=> ( ( v7779(VarCurr,bitIndex1)
        <=> $true )
        & ( v7779(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1801,axiom,
    ! [VarCurr] :
      ( v7779(VarCurr,bitIndex0)
    <=> v4666(VarCurr) ) ).

fof(addAssignment_1800,axiom,
    ! [VarCurr] :
      ( v7779(VarCurr,bitIndex1)
    <=> v3173(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1436,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7757(VarNext)
      <=> ( v7758(VarNext)
          & v7765(VarNext) ) ) ) ).

fof(addAssignment_1799,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7765(VarNext)
      <=> v7763(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1435,axiom,
    ! [VarCurr] :
      ( v7763(VarCurr)
    <=> ( v7766(VarCurr)
        & v7770(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1434,axiom,
    ! [VarCurr] :
      ( v7770(VarCurr)
    <=> ( v7771(VarCurr)
        | v5393(VarCurr) ) ) ).

fof(writeUnaryOperator_678,axiom,
    ! [VarCurr] :
      ( ~ v7771(VarCurr)
    <=> v7772(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_487,axiom,
    ! [VarCurr] :
      ( v7772(VarCurr)
    <=> ( v5619(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1433,axiom,
    ! [VarCurr] :
      ( v7766(VarCurr)
    <=> ( v5393(VarCurr)
        | v7767(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1432,axiom,
    ! [VarCurr] :
      ( v7767(VarCurr)
    <=> ( v7768(VarCurr)
        & v7769(VarCurr) ) ) ).

fof(writeUnaryOperator_677,axiom,
    ! [VarCurr] :
      ( ~ v7769(VarCurr)
    <=> v5393(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_486,axiom,
    ! [VarCurr] :
      ( v7768(VarCurr)
    <=> ( v5619(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1431,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7758(VarNext)
      <=> ( v7760(VarNext)
          & v179(VarNext) ) ) ) ).

fof(writeUnaryOperator_676,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7760(VarNext)
      <=> v4675(VarNext) ) ) ).

fof(addAssignmentInitValueVector_62,axiom,
    ! [B] :
      ( range_4_0(B)
     => ( v7754(constB0,B)
      <=> $false ) ) ).

fof(addCaseBooleanConditionEqualRanges1_124,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7736(VarNext)
       => ( v5617(VarNext)
        <=> v5617(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_133,axiom,
    ! [VarNext] :
      ( v7736(VarNext)
     => ( v5617(VarNext)
      <=> v7744(VarNext) ) ) ).

fof(addAssignment_1798,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7744(VarNext)
      <=> v7742(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_186,axiom,
    ! [VarCurr] :
      ( ~ v5393(VarCurr)
     => ( v7742(VarCurr)
      <=> v5619(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_188,axiom,
    ! [VarCurr] :
      ( v5393(VarCurr)
     => ( v7742(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1430,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7736(VarNext)
      <=> v7737(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1429,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7737(VarNext)
      <=> ( v7739(VarNext)
          & v179(VarNext) ) ) ) ).

fof(writeUnaryOperator_675,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7739(VarNext)
      <=> v4675(VarNext) ) ) ).

fof(addAssignmentInitValueVector_61,axiom,
    ( v5617(constB0)
  <=> $false ) ).

fof(addParallelCaseBooleanConditionEqualRanges5_3,axiom,
    ! [VarCurr] :
      ( ( ~ v5334(VarCurr)
        & ~ v5335(VarCurr)
        & ~ v5336(VarCurr)
        & ~ v5337(VarCurr)
        & ~ v5349(VarCurr) )
     => ( v5619(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_4,axiom,
    ! [VarCurr] :
      ( v5349(VarCurr)
     => ( v5619(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_28,axiom,
    ! [VarCurr] :
      ( v5337(VarCurr)
     => ( v5619(VarCurr)
      <=> v7731(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_63,axiom,
    ! [VarCurr] :
      ( v5336(VarCurr)
     => ( v5619(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_154,axiom,
    ! [VarCurr] :
      ( v5335(VarCurr)
     => ( v5619(VarCurr)
      <=> v7727(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_146,axiom,
    ! [VarCurr] :
      ( v5334(VarCurr)
     => ( v5619(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_153,axiom,
    ! [VarCurr] :
      ( ~ v5339(VarCurr)
     => ( v7731(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_145,axiom,
    ! [VarCurr] :
      ( v5339(VarCurr)
     => ( v7731(VarCurr)
      <=> v7732(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_152,axiom,
    ! [VarCurr] :
      ( ~ v7733(VarCurr)
     => ( v7732(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_144,axiom,
    ! [VarCurr] :
      ( v7733(VarCurr)
     => ( v7732(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1428,axiom,
    ! [VarCurr] :
      ( v7733(VarCurr)
    <=> ( v5341(VarCurr)
        | v5343(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_151,axiom,
    ! [VarCurr] :
      ( ~ v6290(VarCurr)
     => ( v7727(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_143,axiom,
    ! [VarCurr] :
      ( v6290(VarCurr)
     => ( v7727(VarCurr)
      <=> v7728(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_150,axiom,
    ! [VarCurr] :
      ( ~ v7729(VarCurr)
     => ( v7728(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_142,axiom,
    ! [VarCurr] :
      ( v7729(VarCurr)
     => ( v7728(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_485,axiom,
    ! [VarCurr] :
      ( v7730(VarCurr)
    <=> ( v5621(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_484,axiom,
    ! [VarCurr] :
      ( v7729(VarCurr)
    <=> ( v5621(VarCurr)
      <=> $true ) ) ).

fof(addCaseBooleanConditionEqualRanges1_123,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7619(VarNext)
       => ( v5621(VarNext)
        <=> v5621(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_132,axiom,
    ! [VarNext] :
      ( v7619(VarNext)
     => ( v5621(VarNext)
      <=> v7635(VarNext) ) ) ).

fof(addAssignment_1797,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7635(VarNext)
      <=> v7633(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_185,axiom,
    ! [VarCurr] :
      ( ~ v7632(VarCurr)
     => ( v7633(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_187,axiom,
    ! [VarCurr] :
      ( v7632(VarCurr)
     => ( v7633(VarCurr)
      <=> v7636(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_483,axiom,
    ! [VarCurr] :
      ( v7636(VarCurr)
    <=> ( ( v7637(VarCurr,bitIndex5)
        <=> $false )
        & ( v7637(VarCurr,bitIndex4)
        <=> $false )
        & ( v7637(VarCurr,bitIndex3)
        <=> $false )
        & ( v7637(VarCurr,bitIndex2)
        <=> $false )
        & ( v7637(VarCurr,bitIndex1)
        <=> $false )
        & ( v7637(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1796,axiom,
    ! [VarCurr] :
      ( v7637(VarCurr,bitIndex0)
    <=> v7721(VarCurr) ) ).

fof(addAssignment_1795,axiom,
    ! [VarCurr] :
      ( v7637(VarCurr,bitIndex1)
    <=> v7716(VarCurr) ) ).

fof(addAssignment_1794,axiom,
    ! [VarCurr] :
      ( v7637(VarCurr,bitIndex2)
    <=> v7711(VarCurr) ) ).

fof(addAssignment_1793,axiom,
    ! [VarCurr] :
      ( v7637(VarCurr,bitIndex3)
    <=> v7706(VarCurr) ) ).

fof(addAssignment_1792,axiom,
    ! [VarCurr] :
      ( v7637(VarCurr,bitIndex4)
    <=> v7701(VarCurr) ) ).

fof(addAssignment_1791,axiom,
    ! [VarCurr] :
      ( v7637(VarCurr,bitIndex5)
    <=> v7639(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1427,axiom,
    ! [VarCurr] :
      ( v7721(VarCurr)
    <=> ( v7722(VarCurr)
        & v7723(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_339,axiom,
    ! [VarCurr] :
      ( v7723(VarCurr)
    <=> ( v5623(VarCurr,bitIndex38)
        | v6549(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1426,axiom,
    ! [VarCurr] :
      ( v7722(VarCurr)
    <=> ( v6735(VarCurr)
        | v7657(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1425,axiom,
    ! [VarCurr] :
      ( v7716(VarCurr)
    <=> ( v7717(VarCurr)
        & v7720(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1424,axiom,
    ! [VarCurr] :
      ( v7720(VarCurr)
    <=> ( v7650(VarCurr)
        | v7651(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1423,axiom,
    ! [VarCurr] :
      ( v7717(VarCurr)
    <=> ( v7718(VarCurr)
        | v7719(VarCurr) ) ) ).

fof(writeUnaryOperator_674,axiom,
    ! [VarCurr] :
      ( ~ v7719(VarCurr)
    <=> v7651(VarCurr) ) ).

fof(writeUnaryOperator_673,axiom,
    ! [VarCurr] :
      ( ~ v7718(VarCurr)
    <=> v7650(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1422,axiom,
    ! [VarCurr] :
      ( v7711(VarCurr)
    <=> ( v7712(VarCurr)
        & v7715(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1421,axiom,
    ! [VarCurr] :
      ( v7715(VarCurr)
    <=> ( v7648(VarCurr)
        | v7661(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1420,axiom,
    ! [VarCurr] :
      ( v7712(VarCurr)
    <=> ( v7713(VarCurr)
        | v7714(VarCurr) ) ) ).

fof(writeUnaryOperator_672,axiom,
    ! [VarCurr] :
      ( ~ v7714(VarCurr)
    <=> v7661(VarCurr) ) ).

fof(writeUnaryOperator_671,axiom,
    ! [VarCurr] :
      ( ~ v7713(VarCurr)
    <=> v7648(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1419,axiom,
    ! [VarCurr] :
      ( v7706(VarCurr)
    <=> ( v7707(VarCurr)
        & v7710(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1418,axiom,
    ! [VarCurr] :
      ( v7710(VarCurr)
    <=> ( v7646(VarCurr)
        | v7672(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1417,axiom,
    ! [VarCurr] :
      ( v7707(VarCurr)
    <=> ( v7708(VarCurr)
        | v7709(VarCurr) ) ) ).

fof(writeUnaryOperator_670,axiom,
    ! [VarCurr] :
      ( ~ v7709(VarCurr)
    <=> v7672(VarCurr) ) ).

fof(writeUnaryOperator_669,axiom,
    ! [VarCurr] :
      ( ~ v7708(VarCurr)
    <=> v7646(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1416,axiom,
    ! [VarCurr] :
      ( v7701(VarCurr)
    <=> ( v7702(VarCurr)
        & v7705(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1415,axiom,
    ! [VarCurr] :
      ( v7705(VarCurr)
    <=> ( v7644(VarCurr)
        | v7683(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1414,axiom,
    ! [VarCurr] :
      ( v7702(VarCurr)
    <=> ( v7703(VarCurr)
        | v7704(VarCurr) ) ) ).

fof(writeUnaryOperator_668,axiom,
    ! [VarCurr] :
      ( ~ v7704(VarCurr)
    <=> v7683(VarCurr) ) ).

fof(writeUnaryOperator_667,axiom,
    ! [VarCurr] :
      ( ~ v7703(VarCurr)
    <=> v7644(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1413,axiom,
    ! [VarCurr] :
      ( v7639(VarCurr)
    <=> ( v7640(VarCurr)
        & v7700(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1412,axiom,
    ! [VarCurr] :
      ( v7700(VarCurr)
    <=> ( v7642(VarCurr)
        | v7695(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1411,axiom,
    ! [VarCurr] :
      ( v7640(VarCurr)
    <=> ( v7641(VarCurr)
        | v7694(VarCurr) ) ) ).

fof(writeUnaryOperator_666,axiom,
    ! [VarCurr] :
      ( ~ v7694(VarCurr)
    <=> v7695(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1410,axiom,
    ! [VarCurr] :
      ( v7695(VarCurr)
    <=> ( v7696(VarCurr)
        & v7698(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_338,axiom,
    ! [VarCurr] :
      ( v7698(VarCurr)
    <=> ( v5623(VarCurr,bitIndex43)
        | v7699(VarCurr) ) ) ).

fof(writeUnaryOperator_665,axiom,
    ! [VarCurr] :
      ( ~ v7699(VarCurr)
    <=> v7697(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1409,axiom,
    ! [VarCurr] :
      ( v7696(VarCurr)
    <=> ( v6709(VarCurr)
        | v7697(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1408,axiom,
    ! [VarCurr] :
      ( v7697(VarCurr)
    <=> ( v7689(VarCurr)
        & v7691(VarCurr) ) ) ).

fof(writeUnaryOperator_664,axiom,
    ! [VarCurr] :
      ( ~ v7641(VarCurr)
    <=> v7642(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1407,axiom,
    ! [VarCurr] :
      ( v7642(VarCurr)
    <=> ( v7643(VarCurr)
        | v7693(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_337,axiom,
    ! [VarCurr] :
      ( v7693(VarCurr)
    <=> ( v5623(VarCurr,bitIndex42)
        & v7686(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1406,axiom,
    ! [VarCurr] :
      ( v7643(VarCurr)
    <=> ( v7644(VarCurr)
        & v7683(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1405,axiom,
    ! [VarCurr] :
      ( v7683(VarCurr)
    <=> ( v7684(VarCurr)
        & v7692(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_336,axiom,
    ! [VarCurr] :
      ( v7692(VarCurr)
    <=> ( v5623(VarCurr,bitIndex42)
        | v7686(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1404,axiom,
    ! [VarCurr] :
      ( v7684(VarCurr)
    <=> ( v6702(VarCurr)
        | v7685(VarCurr) ) ) ).

fof(writeUnaryOperator_663,axiom,
    ! [VarCurr] :
      ( ~ v7685(VarCurr)
    <=> v7686(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1403,axiom,
    ! [VarCurr] :
      ( v7686(VarCurr)
    <=> ( v7687(VarCurr)
        & v7690(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1402,axiom,
    ! [VarCurr] :
      ( v7690(VarCurr)
    <=> ( v7689(VarCurr)
        | v7691(VarCurr) ) ) ).

fof(writeUnaryOperator_662,axiom,
    ! [VarCurr] :
      ( ~ v7691(VarCurr)
    <=> v6549(VarCurr,bitIndex4) ) ).

fof(writeBinaryOperatorShiftedRanges_335,axiom,
    ! [VarCurr] :
      ( v7687(VarCurr)
    <=> ( v7688(VarCurr)
        | v6549(VarCurr,bitIndex4) ) ) ).

fof(writeUnaryOperator_661,axiom,
    ! [VarCurr] :
      ( ~ v7688(VarCurr)
    <=> v7689(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1401,axiom,
    ! [VarCurr] :
      ( v7689(VarCurr)
    <=> ( v7678(VarCurr)
        & v7680(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1400,axiom,
    ! [VarCurr] :
      ( v7644(VarCurr)
    <=> ( v7645(VarCurr)
        | v7682(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_334,axiom,
    ! [VarCurr] :
      ( v7682(VarCurr)
    <=> ( v5623(VarCurr,bitIndex41)
        & v7675(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1399,axiom,
    ! [VarCurr] :
      ( v7645(VarCurr)
    <=> ( v7646(VarCurr)
        & v7672(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1398,axiom,
    ! [VarCurr] :
      ( v7672(VarCurr)
    <=> ( v7673(VarCurr)
        & v7681(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_333,axiom,
    ! [VarCurr] :
      ( v7681(VarCurr)
    <=> ( v5623(VarCurr,bitIndex41)
        | v7675(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1397,axiom,
    ! [VarCurr] :
      ( v7673(VarCurr)
    <=> ( v6690(VarCurr)
        | v7674(VarCurr) ) ) ).

fof(writeUnaryOperator_660,axiom,
    ! [VarCurr] :
      ( ~ v7674(VarCurr)
    <=> v7675(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1396,axiom,
    ! [VarCurr] :
      ( v7675(VarCurr)
    <=> ( v7676(VarCurr)
        & v7679(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1395,axiom,
    ! [VarCurr] :
      ( v7679(VarCurr)
    <=> ( v7678(VarCurr)
        | v7680(VarCurr) ) ) ).

fof(writeUnaryOperator_659,axiom,
    ! [VarCurr] :
      ( ~ v7680(VarCurr)
    <=> v6549(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorShiftedRanges_332,axiom,
    ! [VarCurr] :
      ( v7676(VarCurr)
    <=> ( v7677(VarCurr)
        | v6549(VarCurr,bitIndex3) ) ) ).

fof(writeUnaryOperator_658,axiom,
    ! [VarCurr] :
      ( ~ v7677(VarCurr)
    <=> v7678(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1394,axiom,
    ! [VarCurr] :
      ( v7678(VarCurr)
    <=> ( v7667(VarCurr)
        & v7669(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1393,axiom,
    ! [VarCurr] :
      ( v7646(VarCurr)
    <=> ( v7647(VarCurr)
        | v7671(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_331,axiom,
    ! [VarCurr] :
      ( v7671(VarCurr)
    <=> ( v5623(VarCurr,bitIndex40)
        & v7664(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1392,axiom,
    ! [VarCurr] :
      ( v7647(VarCurr)
    <=> ( v7648(VarCurr)
        & v7661(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1391,axiom,
    ! [VarCurr] :
      ( v7661(VarCurr)
    <=> ( v7662(VarCurr)
        & v7670(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_330,axiom,
    ! [VarCurr] :
      ( v7670(VarCurr)
    <=> ( v5623(VarCurr,bitIndex40)
        | v7664(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1390,axiom,
    ! [VarCurr] :
      ( v7662(VarCurr)
    <=> ( v6678(VarCurr)
        | v7663(VarCurr) ) ) ).

fof(writeUnaryOperator_657,axiom,
    ! [VarCurr] :
      ( ~ v7663(VarCurr)
    <=> v7664(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1389,axiom,
    ! [VarCurr] :
      ( v7664(VarCurr)
    <=> ( v7665(VarCurr)
        & v7668(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1388,axiom,
    ! [VarCurr] :
      ( v7668(VarCurr)
    <=> ( v7667(VarCurr)
        | v7669(VarCurr) ) ) ).

fof(writeUnaryOperator_656,axiom,
    ! [VarCurr] :
      ( ~ v7669(VarCurr)
    <=> v6549(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges_329,axiom,
    ! [VarCurr] :
      ( v7665(VarCurr)
    <=> ( v7666(VarCurr)
        | v6549(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_655,axiom,
    ! [VarCurr] :
      ( ~ v7666(VarCurr)
    <=> v7667(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1387,axiom,
    ! [VarCurr] :
      ( v7667(VarCurr)
    <=> ( v7657(VarCurr)
        & v7658(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1386,axiom,
    ! [VarCurr] :
      ( v7648(VarCurr)
    <=> ( v7649(VarCurr)
        | v7660(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_328,axiom,
    ! [VarCurr] :
      ( v7660(VarCurr)
    <=> ( v5623(VarCurr,bitIndex39)
        & v7654(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1385,axiom,
    ! [VarCurr] :
      ( v7649(VarCurr)
    <=> ( v7650(VarCurr)
        & v7651(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1384,axiom,
    ! [VarCurr] :
      ( v7651(VarCurr)
    <=> ( v7652(VarCurr)
        & v7659(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_327,axiom,
    ! [VarCurr] :
      ( v7659(VarCurr)
    <=> ( v5623(VarCurr,bitIndex39)
        | v7654(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1383,axiom,
    ! [VarCurr] :
      ( v7652(VarCurr)
    <=> ( v6666(VarCurr)
        | v7653(VarCurr) ) ) ).

fof(writeUnaryOperator_654,axiom,
    ! [VarCurr] :
      ( ~ v7653(VarCurr)
    <=> v7654(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1382,axiom,
    ! [VarCurr] :
      ( v7654(VarCurr)
    <=> ( v7655(VarCurr)
        & v7656(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1381,axiom,
    ! [VarCurr] :
      ( v7656(VarCurr)
    <=> ( v7657(VarCurr)
        | v7658(VarCurr) ) ) ).

fof(writeUnaryOperator_653,axiom,
    ! [VarCurr] :
      ( ~ v7658(VarCurr)
    <=> v6549(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_652,axiom,
    ! [VarCurr] :
      ( ~ v7657(VarCurr)
    <=> v6549(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorShiftedRanges_326,axiom,
    ! [VarCurr] :
      ( v7655(VarCurr)
    <=> ( v6549(VarCurr,bitIndex0)
        | v6549(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_325,axiom,
    ! [VarCurr] :
      ( v7650(VarCurr)
    <=> ( v5623(VarCurr,bitIndex38)
        & v6549(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1380,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7619(VarNext)
      <=> ( v7620(VarNext)
          & v7627(VarNext) ) ) ) ).

fof(addAssignment_1790,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7627(VarNext)
      <=> v7625(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1379,axiom,
    ! [VarCurr] :
      ( v7625(VarCurr)
    <=> ( v7628(VarCurr)
        & v7629(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1378,axiom,
    ! [VarCurr] :
      ( v7629(VarCurr)
    <=> ( v7630(VarCurr)
        | v5393(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1377,axiom,
    ! [VarCurr] :
      ( v7630(VarCurr)
    <=> ( v5274(VarCurr)
        | v7631(VarCurr) ) ) ).

fof(writeUnaryOperator_651,axiom,
    ! [VarCurr] :
      ( ~ v7631(VarCurr)
    <=> v7632(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_482,axiom,
    ! [VarCurr] :
      ( v7632(VarCurr)
    <=> ( v3173(VarCurr)
      <=> $true ) ) ).

fof(writeUnaryOperator_650,axiom,
    ! [VarCurr] :
      ( ~ v7628(VarCurr)
    <=> v5393(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1376,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7620(VarNext)
      <=> ( v7622(VarNext)
          & v179(VarNext) ) ) ) ).

fof(writeUnaryOperator_649,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7622(VarNext)
      <=> v4675(VarNext) ) ) ).

fof(addAssignmentInitValueVector_60,axiom,
    ( v5621(constB0)
  <=> $false ) ).

fof(addAssignment_1789,axiom,
    ! [VarCurr,B] :
      ( range_43_38(B)
     => ( v4921(VarCurr,B)
      <=> v4923(VarCurr,B) ) ) ).

fof(addAssignment_1788,axiom,
    ! [VarCurr,B] :
      ( range_43_38(B)
     => ( v4923(VarCurr,B)
      <=> v4925(VarCurr,B) ) ) ).

fof(addAssignment_1787,axiom,
    ! [VarCurr,B] :
      ( range_43_38(B)
     => ( v4925(VarCurr,B)
      <=> v4927(VarCurr,B) ) ) ).

fof(addAssignment_1786,axiom,
    ! [VarCurr,B] :
      ( range_43_38(B)
     => ( v4927(VarCurr,B)
      <=> v6527(VarCurr,B) ) ) ).

fof(range_axiom_48,axiom,
    ! [B] :
      ( range_43_38(B)
    <=> ( $false
        | bitIndex38 = B
        | bitIndex39 = B
        | bitIndex40 = B
        | bitIndex41 = B
        | bitIndex42 = B
        | bitIndex43 = B ) ) ).

fof(memoryReadIntoBuffer_53,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00000_address_term = A
             => ( range_43_0(B)
               => ( v7325(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_52,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00001_address_term = A
             => ( range_43_0(B)
               => ( v7334(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_51,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00010_address_term = A
             => ( range_43_0(B)
               => ( v7343(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_50,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00011_address_term = A
             => ( range_43_0(B)
               => ( v7352(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_49,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00100_address_term = A
             => ( range_43_0(B)
               => ( v7361(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_48,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00101_address_term = A
             => ( range_43_0(B)
               => ( v7370(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_47,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00110_address_term = A
             => ( range_43_0(B)
               => ( v7379(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_46,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00111_address_term = A
             => ( range_43_0(B)
               => ( v7388(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_45,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01000_address_term = A
             => ( range_43_0(B)
               => ( v7397(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_44,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01001_address_term = A
             => ( range_43_0(B)
               => ( v7406(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_43,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01010_address_term = A
             => ( range_43_0(B)
               => ( v7415(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_42,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01011_address_term = A
             => ( range_43_0(B)
               => ( v7424(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_41,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01100_address_term = A
             => ( range_43_0(B)
               => ( v7433(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_40,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01101_address_term = A
             => ( range_43_0(B)
               => ( v7442(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_39,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01110_address_term = A
             => ( range_43_0(B)
               => ( v7451(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_38,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01111_address_term = A
             => ( range_43_0(B)
               => ( v7460(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_37,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10000_address_term = A
             => ( range_43_0(B)
               => ( v7469(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_36,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10001_address_term = A
             => ( range_43_0(B)
               => ( v7478(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_35,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10010_address_term = A
             => ( range_43_0(B)
               => ( v7487(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_34,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10011_address_term = A
             => ( range_43_0(B)
               => ( v7496(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_33,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10100_address_term = A
             => ( range_43_0(B)
               => ( v7505(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_32,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10101_address_term = A
             => ( range_43_0(B)
               => ( v7514(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_31,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10110_address_term = A
             => ( range_43_0(B)
               => ( v7523(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_30,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10111_address_term = A
             => ( range_43_0(B)
               => ( v7532(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_29,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11000_address_term = A
             => ( range_43_0(B)
               => ( v7541(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_28,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11001_address_term = A
             => ( range_43_0(B)
               => ( v7550(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_27,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11010_address_term = A
             => ( range_43_0(B)
               => ( v7559(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_26,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11011_address_term = A
             => ( range_43_0(B)
               => ( v7568(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_25,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11100_address_term = A
             => ( range_43_0(B)
               => ( v7577(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_24,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11101_address_term = A
             => ( range_43_0(B)
               => ( v7586(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_23,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11110_address_term = A
             => ( range_43_0(B)
               => ( v7595(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_22,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11111_address_term = A
             => ( range_43_0(B)
               => ( v7604(VarNext,B)
                <=> v4929_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_21,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v6279_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( address(A)
             => ! [B] :
                  ( A = AssociatedAddressVar
                 => ( range_43_0(B)
                   => ( v6527(VarNext,B)
                    <=> v4929_array(VarNext,A,B) ) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_20,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v6239_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( address(A)
             => ! [B] :
                  ( A = AssociatedAddressVar
                 => ( range_43_0(B)
                   => ( v7615(VarNext,B)
                    <=> v4929_array(VarNext,A,B) ) ) ) ) ) ) ).

fof(memoryConstantWriteDisabled_4,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( $true
              & v7607(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_array(VarNext,A,B)
              <=> v4929_36__array(VarNext,A,B) ) ) ) ) ).

fof(memoryConstantWriteEnabledInsideRange_4,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( $true
            & v7607(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_array(VarNext,A,B)
              <=> b00000000000000000000000000000000000000000000(B) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1375,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7607(VarNext)
      <=> ( v7608(VarNext)
          & v7613(VarNext) ) ) ) ).

fof(addAssignment_1785,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7613(VarNext)
      <=> v7278(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1374,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7608(VarNext)
      <=> ( v7610(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_648,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7610(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_55,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11111_address_term = A
              & v7598(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_36__array(VarNext,A,B)
              <=> v4929_35__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_55,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11111_address_term = A
            & v7598(VarNext) )
         => ( ( v4929_36__array(VarNext,A,bitIndex43)
            <=> v7604(VarNext,bitIndex1407) )
            & ( v4929_36__array(VarNext,A,bitIndex42)
            <=> v7604(VarNext,bitIndex1406) )
            & ( v4929_36__array(VarNext,A,bitIndex41)
            <=> v7604(VarNext,bitIndex1405) )
            & ( v4929_36__array(VarNext,A,bitIndex40)
            <=> v7604(VarNext,bitIndex1404) )
            & ( v4929_36__array(VarNext,A,bitIndex39)
            <=> v7604(VarNext,bitIndex1403) )
            & ( v4929_36__array(VarNext,A,bitIndex38)
            <=> v7604(VarNext,bitIndex1402) )
            & ( v4929_36__array(VarNext,A,bitIndex37)
            <=> v7604(VarNext,bitIndex1401) )
            & ( v4929_36__array(VarNext,A,bitIndex36)
            <=> v7604(VarNext,bitIndex1400) )
            & ( v4929_36__array(VarNext,A,bitIndex35)
            <=> v7604(VarNext,bitIndex1399) )
            & ( v4929_36__array(VarNext,A,bitIndex34)
            <=> v7604(VarNext,bitIndex1398) )
            & ( v4929_36__array(VarNext,A,bitIndex33)
            <=> v7604(VarNext,bitIndex1397) )
            & ( v4929_36__array(VarNext,A,bitIndex32)
            <=> v7604(VarNext,bitIndex1396) )
            & ( v4929_36__array(VarNext,A,bitIndex31)
            <=> v7604(VarNext,bitIndex1395) )
            & ( v4929_36__array(VarNext,A,bitIndex30)
            <=> v7604(VarNext,bitIndex1394) )
            & ( v4929_36__array(VarNext,A,bitIndex29)
            <=> v7604(VarNext,bitIndex1393) )
            & ( v4929_36__array(VarNext,A,bitIndex28)
            <=> v7604(VarNext,bitIndex1392) )
            & ( v4929_36__array(VarNext,A,bitIndex27)
            <=> v7604(VarNext,bitIndex1391) )
            & ( v4929_36__array(VarNext,A,bitIndex26)
            <=> v7604(VarNext,bitIndex1390) )
            & ( v4929_36__array(VarNext,A,bitIndex25)
            <=> v7604(VarNext,bitIndex1389) )
            & ( v4929_36__array(VarNext,A,bitIndex24)
            <=> v7604(VarNext,bitIndex1388) )
            & ( v4929_36__array(VarNext,A,bitIndex23)
            <=> v7604(VarNext,bitIndex1387) )
            & ( v4929_36__array(VarNext,A,bitIndex22)
            <=> v7604(VarNext,bitIndex1386) )
            & ( v4929_36__array(VarNext,A,bitIndex21)
            <=> v7604(VarNext,bitIndex1385) )
            & ( v4929_36__array(VarNext,A,bitIndex20)
            <=> v7604(VarNext,bitIndex1384) )
            & ( v4929_36__array(VarNext,A,bitIndex19)
            <=> v7604(VarNext,bitIndex1383) )
            & ( v4929_36__array(VarNext,A,bitIndex18)
            <=> v7604(VarNext,bitIndex1382) )
            & ( v4929_36__array(VarNext,A,bitIndex17)
            <=> v7604(VarNext,bitIndex1381) )
            & ( v4929_36__array(VarNext,A,bitIndex16)
            <=> v7604(VarNext,bitIndex1380) )
            & ( v4929_36__array(VarNext,A,bitIndex15)
            <=> v7604(VarNext,bitIndex1379) )
            & ( v4929_36__array(VarNext,A,bitIndex14)
            <=> v7604(VarNext,bitIndex1378) )
            & ( v4929_36__array(VarNext,A,bitIndex13)
            <=> v7604(VarNext,bitIndex1377) )
            & ( v4929_36__array(VarNext,A,bitIndex12)
            <=> v7604(VarNext,bitIndex1376) )
            & ( v4929_36__array(VarNext,A,bitIndex11)
            <=> v7604(VarNext,bitIndex1375) )
            & ( v4929_36__array(VarNext,A,bitIndex10)
            <=> v7604(VarNext,bitIndex1374) )
            & ( v4929_36__array(VarNext,A,bitIndex9)
            <=> v7604(VarNext,bitIndex1373) )
            & ( v4929_36__array(VarNext,A,bitIndex8)
            <=> v7604(VarNext,bitIndex1372) )
            & ( v4929_36__array(VarNext,A,bitIndex7)
            <=> v7604(VarNext,bitIndex1371) )
            & ( v4929_36__array(VarNext,A,bitIndex6)
            <=> v7604(VarNext,bitIndex1370) )
            & ( v4929_36__array(VarNext,A,bitIndex5)
            <=> v7604(VarNext,bitIndex1369) )
            & ( v4929_36__array(VarNext,A,bitIndex4)
            <=> v7604(VarNext,bitIndex1368) )
            & ( v4929_36__array(VarNext,A,bitIndex3)
            <=> v7604(VarNext,bitIndex1367) )
            & ( v4929_36__array(VarNext,A,bitIndex2)
            <=> v7604(VarNext,bitIndex1366) )
            & ( v4929_36__array(VarNext,A,bitIndex1)
            <=> v7604(VarNext,bitIndex1365) )
            & ( v4929_36__array(VarNext,A,bitIndex0)
            <=> v7604(VarNext,bitIndex1364) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1373,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7598(VarNext)
      <=> ( v7599(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1372,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7599(VarNext)
      <=> ( v7601(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_647,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7601(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_54,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11110_address_term = A
              & v7589(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_35__array(VarNext,A,B)
              <=> v4929_34__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_54,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11110_address_term = A
            & v7589(VarNext) )
         => ( ( v4929_35__array(VarNext,A,bitIndex43)
            <=> v7595(VarNext,bitIndex1363) )
            & ( v4929_35__array(VarNext,A,bitIndex42)
            <=> v7595(VarNext,bitIndex1362) )
            & ( v4929_35__array(VarNext,A,bitIndex41)
            <=> v7595(VarNext,bitIndex1361) )
            & ( v4929_35__array(VarNext,A,bitIndex40)
            <=> v7595(VarNext,bitIndex1360) )
            & ( v4929_35__array(VarNext,A,bitIndex39)
            <=> v7595(VarNext,bitIndex1359) )
            & ( v4929_35__array(VarNext,A,bitIndex38)
            <=> v7595(VarNext,bitIndex1358) )
            & ( v4929_35__array(VarNext,A,bitIndex37)
            <=> v7595(VarNext,bitIndex1357) )
            & ( v4929_35__array(VarNext,A,bitIndex36)
            <=> v7595(VarNext,bitIndex1356) )
            & ( v4929_35__array(VarNext,A,bitIndex35)
            <=> v7595(VarNext,bitIndex1355) )
            & ( v4929_35__array(VarNext,A,bitIndex34)
            <=> v7595(VarNext,bitIndex1354) )
            & ( v4929_35__array(VarNext,A,bitIndex33)
            <=> v7595(VarNext,bitIndex1353) )
            & ( v4929_35__array(VarNext,A,bitIndex32)
            <=> v7595(VarNext,bitIndex1352) )
            & ( v4929_35__array(VarNext,A,bitIndex31)
            <=> v7595(VarNext,bitIndex1351) )
            & ( v4929_35__array(VarNext,A,bitIndex30)
            <=> v7595(VarNext,bitIndex1350) )
            & ( v4929_35__array(VarNext,A,bitIndex29)
            <=> v7595(VarNext,bitIndex1349) )
            & ( v4929_35__array(VarNext,A,bitIndex28)
            <=> v7595(VarNext,bitIndex1348) )
            & ( v4929_35__array(VarNext,A,bitIndex27)
            <=> v7595(VarNext,bitIndex1347) )
            & ( v4929_35__array(VarNext,A,bitIndex26)
            <=> v7595(VarNext,bitIndex1346) )
            & ( v4929_35__array(VarNext,A,bitIndex25)
            <=> v7595(VarNext,bitIndex1345) )
            & ( v4929_35__array(VarNext,A,bitIndex24)
            <=> v7595(VarNext,bitIndex1344) )
            & ( v4929_35__array(VarNext,A,bitIndex23)
            <=> v7595(VarNext,bitIndex1343) )
            & ( v4929_35__array(VarNext,A,bitIndex22)
            <=> v7595(VarNext,bitIndex1342) )
            & ( v4929_35__array(VarNext,A,bitIndex21)
            <=> v7595(VarNext,bitIndex1341) )
            & ( v4929_35__array(VarNext,A,bitIndex20)
            <=> v7595(VarNext,bitIndex1340) )
            & ( v4929_35__array(VarNext,A,bitIndex19)
            <=> v7595(VarNext,bitIndex1339) )
            & ( v4929_35__array(VarNext,A,bitIndex18)
            <=> v7595(VarNext,bitIndex1338) )
            & ( v4929_35__array(VarNext,A,bitIndex17)
            <=> v7595(VarNext,bitIndex1337) )
            & ( v4929_35__array(VarNext,A,bitIndex16)
            <=> v7595(VarNext,bitIndex1336) )
            & ( v4929_35__array(VarNext,A,bitIndex15)
            <=> v7595(VarNext,bitIndex1335) )
            & ( v4929_35__array(VarNext,A,bitIndex14)
            <=> v7595(VarNext,bitIndex1334) )
            & ( v4929_35__array(VarNext,A,bitIndex13)
            <=> v7595(VarNext,bitIndex1333) )
            & ( v4929_35__array(VarNext,A,bitIndex12)
            <=> v7595(VarNext,bitIndex1332) )
            & ( v4929_35__array(VarNext,A,bitIndex11)
            <=> v7595(VarNext,bitIndex1331) )
            & ( v4929_35__array(VarNext,A,bitIndex10)
            <=> v7595(VarNext,bitIndex1330) )
            & ( v4929_35__array(VarNext,A,bitIndex9)
            <=> v7595(VarNext,bitIndex1329) )
            & ( v4929_35__array(VarNext,A,bitIndex8)
            <=> v7595(VarNext,bitIndex1328) )
            & ( v4929_35__array(VarNext,A,bitIndex7)
            <=> v7595(VarNext,bitIndex1327) )
            & ( v4929_35__array(VarNext,A,bitIndex6)
            <=> v7595(VarNext,bitIndex1326) )
            & ( v4929_35__array(VarNext,A,bitIndex5)
            <=> v7595(VarNext,bitIndex1325) )
            & ( v4929_35__array(VarNext,A,bitIndex4)
            <=> v7595(VarNext,bitIndex1324) )
            & ( v4929_35__array(VarNext,A,bitIndex3)
            <=> v7595(VarNext,bitIndex1323) )
            & ( v4929_35__array(VarNext,A,bitIndex2)
            <=> v7595(VarNext,bitIndex1322) )
            & ( v4929_35__array(VarNext,A,bitIndex1)
            <=> v7595(VarNext,bitIndex1321) )
            & ( v4929_35__array(VarNext,A,bitIndex0)
            <=> v7595(VarNext,bitIndex1320) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1371,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7589(VarNext)
      <=> ( v7590(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1370,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7590(VarNext)
      <=> ( v7592(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_646,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7592(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_53,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11101_address_term = A
              & v7580(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_34__array(VarNext,A,B)
              <=> v4929_33__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_53,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11101_address_term = A
            & v7580(VarNext) )
         => ( ( v4929_34__array(VarNext,A,bitIndex43)
            <=> v7586(VarNext,bitIndex1319) )
            & ( v4929_34__array(VarNext,A,bitIndex42)
            <=> v7586(VarNext,bitIndex1318) )
            & ( v4929_34__array(VarNext,A,bitIndex41)
            <=> v7586(VarNext,bitIndex1317) )
            & ( v4929_34__array(VarNext,A,bitIndex40)
            <=> v7586(VarNext,bitIndex1316) )
            & ( v4929_34__array(VarNext,A,bitIndex39)
            <=> v7586(VarNext,bitIndex1315) )
            & ( v4929_34__array(VarNext,A,bitIndex38)
            <=> v7586(VarNext,bitIndex1314) )
            & ( v4929_34__array(VarNext,A,bitIndex37)
            <=> v7586(VarNext,bitIndex1313) )
            & ( v4929_34__array(VarNext,A,bitIndex36)
            <=> v7586(VarNext,bitIndex1312) )
            & ( v4929_34__array(VarNext,A,bitIndex35)
            <=> v7586(VarNext,bitIndex1311) )
            & ( v4929_34__array(VarNext,A,bitIndex34)
            <=> v7586(VarNext,bitIndex1310) )
            & ( v4929_34__array(VarNext,A,bitIndex33)
            <=> v7586(VarNext,bitIndex1309) )
            & ( v4929_34__array(VarNext,A,bitIndex32)
            <=> v7586(VarNext,bitIndex1308) )
            & ( v4929_34__array(VarNext,A,bitIndex31)
            <=> v7586(VarNext,bitIndex1307) )
            & ( v4929_34__array(VarNext,A,bitIndex30)
            <=> v7586(VarNext,bitIndex1306) )
            & ( v4929_34__array(VarNext,A,bitIndex29)
            <=> v7586(VarNext,bitIndex1305) )
            & ( v4929_34__array(VarNext,A,bitIndex28)
            <=> v7586(VarNext,bitIndex1304) )
            & ( v4929_34__array(VarNext,A,bitIndex27)
            <=> v7586(VarNext,bitIndex1303) )
            & ( v4929_34__array(VarNext,A,bitIndex26)
            <=> v7586(VarNext,bitIndex1302) )
            & ( v4929_34__array(VarNext,A,bitIndex25)
            <=> v7586(VarNext,bitIndex1301) )
            & ( v4929_34__array(VarNext,A,bitIndex24)
            <=> v7586(VarNext,bitIndex1300) )
            & ( v4929_34__array(VarNext,A,bitIndex23)
            <=> v7586(VarNext,bitIndex1299) )
            & ( v4929_34__array(VarNext,A,bitIndex22)
            <=> v7586(VarNext,bitIndex1298) )
            & ( v4929_34__array(VarNext,A,bitIndex21)
            <=> v7586(VarNext,bitIndex1297) )
            & ( v4929_34__array(VarNext,A,bitIndex20)
            <=> v7586(VarNext,bitIndex1296) )
            & ( v4929_34__array(VarNext,A,bitIndex19)
            <=> v7586(VarNext,bitIndex1295) )
            & ( v4929_34__array(VarNext,A,bitIndex18)
            <=> v7586(VarNext,bitIndex1294) )
            & ( v4929_34__array(VarNext,A,bitIndex17)
            <=> v7586(VarNext,bitIndex1293) )
            & ( v4929_34__array(VarNext,A,bitIndex16)
            <=> v7586(VarNext,bitIndex1292) )
            & ( v4929_34__array(VarNext,A,bitIndex15)
            <=> v7586(VarNext,bitIndex1291) )
            & ( v4929_34__array(VarNext,A,bitIndex14)
            <=> v7586(VarNext,bitIndex1290) )
            & ( v4929_34__array(VarNext,A,bitIndex13)
            <=> v7586(VarNext,bitIndex1289) )
            & ( v4929_34__array(VarNext,A,bitIndex12)
            <=> v7586(VarNext,bitIndex1288) )
            & ( v4929_34__array(VarNext,A,bitIndex11)
            <=> v7586(VarNext,bitIndex1287) )
            & ( v4929_34__array(VarNext,A,bitIndex10)
            <=> v7586(VarNext,bitIndex1286) )
            & ( v4929_34__array(VarNext,A,bitIndex9)
            <=> v7586(VarNext,bitIndex1285) )
            & ( v4929_34__array(VarNext,A,bitIndex8)
            <=> v7586(VarNext,bitIndex1284) )
            & ( v4929_34__array(VarNext,A,bitIndex7)
            <=> v7586(VarNext,bitIndex1283) )
            & ( v4929_34__array(VarNext,A,bitIndex6)
            <=> v7586(VarNext,bitIndex1282) )
            & ( v4929_34__array(VarNext,A,bitIndex5)
            <=> v7586(VarNext,bitIndex1281) )
            & ( v4929_34__array(VarNext,A,bitIndex4)
            <=> v7586(VarNext,bitIndex1280) )
            & ( v4929_34__array(VarNext,A,bitIndex3)
            <=> v7586(VarNext,bitIndex1279) )
            & ( v4929_34__array(VarNext,A,bitIndex2)
            <=> v7586(VarNext,bitIndex1278) )
            & ( v4929_34__array(VarNext,A,bitIndex1)
            <=> v7586(VarNext,bitIndex1277) )
            & ( v4929_34__array(VarNext,A,bitIndex0)
            <=> v7586(VarNext,bitIndex1276) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1369,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7580(VarNext)
      <=> ( v7581(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1368,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7581(VarNext)
      <=> ( v7583(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_645,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7583(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_52,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11100_address_term = A
              & v7571(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_33__array(VarNext,A,B)
              <=> v4929_32__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_52,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11100_address_term = A
            & v7571(VarNext) )
         => ( ( v4929_33__array(VarNext,A,bitIndex43)
            <=> v7577(VarNext,bitIndex1275) )
            & ( v4929_33__array(VarNext,A,bitIndex42)
            <=> v7577(VarNext,bitIndex1274) )
            & ( v4929_33__array(VarNext,A,bitIndex41)
            <=> v7577(VarNext,bitIndex1273) )
            & ( v4929_33__array(VarNext,A,bitIndex40)
            <=> v7577(VarNext,bitIndex1272) )
            & ( v4929_33__array(VarNext,A,bitIndex39)
            <=> v7577(VarNext,bitIndex1271) )
            & ( v4929_33__array(VarNext,A,bitIndex38)
            <=> v7577(VarNext,bitIndex1270) )
            & ( v4929_33__array(VarNext,A,bitIndex37)
            <=> v7577(VarNext,bitIndex1269) )
            & ( v4929_33__array(VarNext,A,bitIndex36)
            <=> v7577(VarNext,bitIndex1268) )
            & ( v4929_33__array(VarNext,A,bitIndex35)
            <=> v7577(VarNext,bitIndex1267) )
            & ( v4929_33__array(VarNext,A,bitIndex34)
            <=> v7577(VarNext,bitIndex1266) )
            & ( v4929_33__array(VarNext,A,bitIndex33)
            <=> v7577(VarNext,bitIndex1265) )
            & ( v4929_33__array(VarNext,A,bitIndex32)
            <=> v7577(VarNext,bitIndex1264) )
            & ( v4929_33__array(VarNext,A,bitIndex31)
            <=> v7577(VarNext,bitIndex1263) )
            & ( v4929_33__array(VarNext,A,bitIndex30)
            <=> v7577(VarNext,bitIndex1262) )
            & ( v4929_33__array(VarNext,A,bitIndex29)
            <=> v7577(VarNext,bitIndex1261) )
            & ( v4929_33__array(VarNext,A,bitIndex28)
            <=> v7577(VarNext,bitIndex1260) )
            & ( v4929_33__array(VarNext,A,bitIndex27)
            <=> v7577(VarNext,bitIndex1259) )
            & ( v4929_33__array(VarNext,A,bitIndex26)
            <=> v7577(VarNext,bitIndex1258) )
            & ( v4929_33__array(VarNext,A,bitIndex25)
            <=> v7577(VarNext,bitIndex1257) )
            & ( v4929_33__array(VarNext,A,bitIndex24)
            <=> v7577(VarNext,bitIndex1256) )
            & ( v4929_33__array(VarNext,A,bitIndex23)
            <=> v7577(VarNext,bitIndex1255) )
            & ( v4929_33__array(VarNext,A,bitIndex22)
            <=> v7577(VarNext,bitIndex1254) )
            & ( v4929_33__array(VarNext,A,bitIndex21)
            <=> v7577(VarNext,bitIndex1253) )
            & ( v4929_33__array(VarNext,A,bitIndex20)
            <=> v7577(VarNext,bitIndex1252) )
            & ( v4929_33__array(VarNext,A,bitIndex19)
            <=> v7577(VarNext,bitIndex1251) )
            & ( v4929_33__array(VarNext,A,bitIndex18)
            <=> v7577(VarNext,bitIndex1250) )
            & ( v4929_33__array(VarNext,A,bitIndex17)
            <=> v7577(VarNext,bitIndex1249) )
            & ( v4929_33__array(VarNext,A,bitIndex16)
            <=> v7577(VarNext,bitIndex1248) )
            & ( v4929_33__array(VarNext,A,bitIndex15)
            <=> v7577(VarNext,bitIndex1247) )
            & ( v4929_33__array(VarNext,A,bitIndex14)
            <=> v7577(VarNext,bitIndex1246) )
            & ( v4929_33__array(VarNext,A,bitIndex13)
            <=> v7577(VarNext,bitIndex1245) )
            & ( v4929_33__array(VarNext,A,bitIndex12)
            <=> v7577(VarNext,bitIndex1244) )
            & ( v4929_33__array(VarNext,A,bitIndex11)
            <=> v7577(VarNext,bitIndex1243) )
            & ( v4929_33__array(VarNext,A,bitIndex10)
            <=> v7577(VarNext,bitIndex1242) )
            & ( v4929_33__array(VarNext,A,bitIndex9)
            <=> v7577(VarNext,bitIndex1241) )
            & ( v4929_33__array(VarNext,A,bitIndex8)
            <=> v7577(VarNext,bitIndex1240) )
            & ( v4929_33__array(VarNext,A,bitIndex7)
            <=> v7577(VarNext,bitIndex1239) )
            & ( v4929_33__array(VarNext,A,bitIndex6)
            <=> v7577(VarNext,bitIndex1238) )
            & ( v4929_33__array(VarNext,A,bitIndex5)
            <=> v7577(VarNext,bitIndex1237) )
            & ( v4929_33__array(VarNext,A,bitIndex4)
            <=> v7577(VarNext,bitIndex1236) )
            & ( v4929_33__array(VarNext,A,bitIndex3)
            <=> v7577(VarNext,bitIndex1235) )
            & ( v4929_33__array(VarNext,A,bitIndex2)
            <=> v7577(VarNext,bitIndex1234) )
            & ( v4929_33__array(VarNext,A,bitIndex1)
            <=> v7577(VarNext,bitIndex1233) )
            & ( v4929_33__array(VarNext,A,bitIndex0)
            <=> v7577(VarNext,bitIndex1232) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1367,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7571(VarNext)
      <=> ( v7572(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1366,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7572(VarNext)
      <=> ( v7574(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_644,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7574(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_51,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11011_address_term = A
              & v7562(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_32__array(VarNext,A,B)
              <=> v4929_31__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_51,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11011_address_term = A
            & v7562(VarNext) )
         => ( ( v4929_32__array(VarNext,A,bitIndex43)
            <=> v7568(VarNext,bitIndex1231) )
            & ( v4929_32__array(VarNext,A,bitIndex42)
            <=> v7568(VarNext,bitIndex1230) )
            & ( v4929_32__array(VarNext,A,bitIndex41)
            <=> v7568(VarNext,bitIndex1229) )
            & ( v4929_32__array(VarNext,A,bitIndex40)
            <=> v7568(VarNext,bitIndex1228) )
            & ( v4929_32__array(VarNext,A,bitIndex39)
            <=> v7568(VarNext,bitIndex1227) )
            & ( v4929_32__array(VarNext,A,bitIndex38)
            <=> v7568(VarNext,bitIndex1226) )
            & ( v4929_32__array(VarNext,A,bitIndex37)
            <=> v7568(VarNext,bitIndex1225) )
            & ( v4929_32__array(VarNext,A,bitIndex36)
            <=> v7568(VarNext,bitIndex1224) )
            & ( v4929_32__array(VarNext,A,bitIndex35)
            <=> v7568(VarNext,bitIndex1223) )
            & ( v4929_32__array(VarNext,A,bitIndex34)
            <=> v7568(VarNext,bitIndex1222) )
            & ( v4929_32__array(VarNext,A,bitIndex33)
            <=> v7568(VarNext,bitIndex1221) )
            & ( v4929_32__array(VarNext,A,bitIndex32)
            <=> v7568(VarNext,bitIndex1220) )
            & ( v4929_32__array(VarNext,A,bitIndex31)
            <=> v7568(VarNext,bitIndex1219) )
            & ( v4929_32__array(VarNext,A,bitIndex30)
            <=> v7568(VarNext,bitIndex1218) )
            & ( v4929_32__array(VarNext,A,bitIndex29)
            <=> v7568(VarNext,bitIndex1217) )
            & ( v4929_32__array(VarNext,A,bitIndex28)
            <=> v7568(VarNext,bitIndex1216) )
            & ( v4929_32__array(VarNext,A,bitIndex27)
            <=> v7568(VarNext,bitIndex1215) )
            & ( v4929_32__array(VarNext,A,bitIndex26)
            <=> v7568(VarNext,bitIndex1214) )
            & ( v4929_32__array(VarNext,A,bitIndex25)
            <=> v7568(VarNext,bitIndex1213) )
            & ( v4929_32__array(VarNext,A,bitIndex24)
            <=> v7568(VarNext,bitIndex1212) )
            & ( v4929_32__array(VarNext,A,bitIndex23)
            <=> v7568(VarNext,bitIndex1211) )
            & ( v4929_32__array(VarNext,A,bitIndex22)
            <=> v7568(VarNext,bitIndex1210) )
            & ( v4929_32__array(VarNext,A,bitIndex21)
            <=> v7568(VarNext,bitIndex1209) )
            & ( v4929_32__array(VarNext,A,bitIndex20)
            <=> v7568(VarNext,bitIndex1208) )
            & ( v4929_32__array(VarNext,A,bitIndex19)
            <=> v7568(VarNext,bitIndex1207) )
            & ( v4929_32__array(VarNext,A,bitIndex18)
            <=> v7568(VarNext,bitIndex1206) )
            & ( v4929_32__array(VarNext,A,bitIndex17)
            <=> v7568(VarNext,bitIndex1205) )
            & ( v4929_32__array(VarNext,A,bitIndex16)
            <=> v7568(VarNext,bitIndex1204) )
            & ( v4929_32__array(VarNext,A,bitIndex15)
            <=> v7568(VarNext,bitIndex1203) )
            & ( v4929_32__array(VarNext,A,bitIndex14)
            <=> v7568(VarNext,bitIndex1202) )
            & ( v4929_32__array(VarNext,A,bitIndex13)
            <=> v7568(VarNext,bitIndex1201) )
            & ( v4929_32__array(VarNext,A,bitIndex12)
            <=> v7568(VarNext,bitIndex1200) )
            & ( v4929_32__array(VarNext,A,bitIndex11)
            <=> v7568(VarNext,bitIndex1199) )
            & ( v4929_32__array(VarNext,A,bitIndex10)
            <=> v7568(VarNext,bitIndex1198) )
            & ( v4929_32__array(VarNext,A,bitIndex9)
            <=> v7568(VarNext,bitIndex1197) )
            & ( v4929_32__array(VarNext,A,bitIndex8)
            <=> v7568(VarNext,bitIndex1196) )
            & ( v4929_32__array(VarNext,A,bitIndex7)
            <=> v7568(VarNext,bitIndex1195) )
            & ( v4929_32__array(VarNext,A,bitIndex6)
            <=> v7568(VarNext,bitIndex1194) )
            & ( v4929_32__array(VarNext,A,bitIndex5)
            <=> v7568(VarNext,bitIndex1193) )
            & ( v4929_32__array(VarNext,A,bitIndex4)
            <=> v7568(VarNext,bitIndex1192) )
            & ( v4929_32__array(VarNext,A,bitIndex3)
            <=> v7568(VarNext,bitIndex1191) )
            & ( v4929_32__array(VarNext,A,bitIndex2)
            <=> v7568(VarNext,bitIndex1190) )
            & ( v4929_32__array(VarNext,A,bitIndex1)
            <=> v7568(VarNext,bitIndex1189) )
            & ( v4929_32__array(VarNext,A,bitIndex0)
            <=> v7568(VarNext,bitIndex1188) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1365,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7562(VarNext)
      <=> ( v7563(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1364,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7563(VarNext)
      <=> ( v7565(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_643,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7565(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_50,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11010_address_term = A
              & v7553(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_31__array(VarNext,A,B)
              <=> v4929_30__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_50,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11010_address_term = A
            & v7553(VarNext) )
         => ( ( v4929_31__array(VarNext,A,bitIndex43)
            <=> v7559(VarNext,bitIndex1187) )
            & ( v4929_31__array(VarNext,A,bitIndex42)
            <=> v7559(VarNext,bitIndex1186) )
            & ( v4929_31__array(VarNext,A,bitIndex41)
            <=> v7559(VarNext,bitIndex1185) )
            & ( v4929_31__array(VarNext,A,bitIndex40)
            <=> v7559(VarNext,bitIndex1184) )
            & ( v4929_31__array(VarNext,A,bitIndex39)
            <=> v7559(VarNext,bitIndex1183) )
            & ( v4929_31__array(VarNext,A,bitIndex38)
            <=> v7559(VarNext,bitIndex1182) )
            & ( v4929_31__array(VarNext,A,bitIndex37)
            <=> v7559(VarNext,bitIndex1181) )
            & ( v4929_31__array(VarNext,A,bitIndex36)
            <=> v7559(VarNext,bitIndex1180) )
            & ( v4929_31__array(VarNext,A,bitIndex35)
            <=> v7559(VarNext,bitIndex1179) )
            & ( v4929_31__array(VarNext,A,bitIndex34)
            <=> v7559(VarNext,bitIndex1178) )
            & ( v4929_31__array(VarNext,A,bitIndex33)
            <=> v7559(VarNext,bitIndex1177) )
            & ( v4929_31__array(VarNext,A,bitIndex32)
            <=> v7559(VarNext,bitIndex1176) )
            & ( v4929_31__array(VarNext,A,bitIndex31)
            <=> v7559(VarNext,bitIndex1175) )
            & ( v4929_31__array(VarNext,A,bitIndex30)
            <=> v7559(VarNext,bitIndex1174) )
            & ( v4929_31__array(VarNext,A,bitIndex29)
            <=> v7559(VarNext,bitIndex1173) )
            & ( v4929_31__array(VarNext,A,bitIndex28)
            <=> v7559(VarNext,bitIndex1172) )
            & ( v4929_31__array(VarNext,A,bitIndex27)
            <=> v7559(VarNext,bitIndex1171) )
            & ( v4929_31__array(VarNext,A,bitIndex26)
            <=> v7559(VarNext,bitIndex1170) )
            & ( v4929_31__array(VarNext,A,bitIndex25)
            <=> v7559(VarNext,bitIndex1169) )
            & ( v4929_31__array(VarNext,A,bitIndex24)
            <=> v7559(VarNext,bitIndex1168) )
            & ( v4929_31__array(VarNext,A,bitIndex23)
            <=> v7559(VarNext,bitIndex1167) )
            & ( v4929_31__array(VarNext,A,bitIndex22)
            <=> v7559(VarNext,bitIndex1166) )
            & ( v4929_31__array(VarNext,A,bitIndex21)
            <=> v7559(VarNext,bitIndex1165) )
            & ( v4929_31__array(VarNext,A,bitIndex20)
            <=> v7559(VarNext,bitIndex1164) )
            & ( v4929_31__array(VarNext,A,bitIndex19)
            <=> v7559(VarNext,bitIndex1163) )
            & ( v4929_31__array(VarNext,A,bitIndex18)
            <=> v7559(VarNext,bitIndex1162) )
            & ( v4929_31__array(VarNext,A,bitIndex17)
            <=> v7559(VarNext,bitIndex1161) )
            & ( v4929_31__array(VarNext,A,bitIndex16)
            <=> v7559(VarNext,bitIndex1160) )
            & ( v4929_31__array(VarNext,A,bitIndex15)
            <=> v7559(VarNext,bitIndex1159) )
            & ( v4929_31__array(VarNext,A,bitIndex14)
            <=> v7559(VarNext,bitIndex1158) )
            & ( v4929_31__array(VarNext,A,bitIndex13)
            <=> v7559(VarNext,bitIndex1157) )
            & ( v4929_31__array(VarNext,A,bitIndex12)
            <=> v7559(VarNext,bitIndex1156) )
            & ( v4929_31__array(VarNext,A,bitIndex11)
            <=> v7559(VarNext,bitIndex1155) )
            & ( v4929_31__array(VarNext,A,bitIndex10)
            <=> v7559(VarNext,bitIndex1154) )
            & ( v4929_31__array(VarNext,A,bitIndex9)
            <=> v7559(VarNext,bitIndex1153) )
            & ( v4929_31__array(VarNext,A,bitIndex8)
            <=> v7559(VarNext,bitIndex1152) )
            & ( v4929_31__array(VarNext,A,bitIndex7)
            <=> v7559(VarNext,bitIndex1151) )
            & ( v4929_31__array(VarNext,A,bitIndex6)
            <=> v7559(VarNext,bitIndex1150) )
            & ( v4929_31__array(VarNext,A,bitIndex5)
            <=> v7559(VarNext,bitIndex1149) )
            & ( v4929_31__array(VarNext,A,bitIndex4)
            <=> v7559(VarNext,bitIndex1148) )
            & ( v4929_31__array(VarNext,A,bitIndex3)
            <=> v7559(VarNext,bitIndex1147) )
            & ( v4929_31__array(VarNext,A,bitIndex2)
            <=> v7559(VarNext,bitIndex1146) )
            & ( v4929_31__array(VarNext,A,bitIndex1)
            <=> v7559(VarNext,bitIndex1145) )
            & ( v4929_31__array(VarNext,A,bitIndex0)
            <=> v7559(VarNext,bitIndex1144) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1363,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7553(VarNext)
      <=> ( v7554(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1362,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7554(VarNext)
      <=> ( v7556(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_642,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7556(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_49,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11001_address_term = A
              & v7544(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_30__array(VarNext,A,B)
              <=> v4929_29__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_49,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11001_address_term = A
            & v7544(VarNext) )
         => ( ( v4929_30__array(VarNext,A,bitIndex43)
            <=> v7550(VarNext,bitIndex1143) )
            & ( v4929_30__array(VarNext,A,bitIndex42)
            <=> v7550(VarNext,bitIndex1142) )
            & ( v4929_30__array(VarNext,A,bitIndex41)
            <=> v7550(VarNext,bitIndex1141) )
            & ( v4929_30__array(VarNext,A,bitIndex40)
            <=> v7550(VarNext,bitIndex1140) )
            & ( v4929_30__array(VarNext,A,bitIndex39)
            <=> v7550(VarNext,bitIndex1139) )
            & ( v4929_30__array(VarNext,A,bitIndex38)
            <=> v7550(VarNext,bitIndex1138) )
            & ( v4929_30__array(VarNext,A,bitIndex37)
            <=> v7550(VarNext,bitIndex1137) )
            & ( v4929_30__array(VarNext,A,bitIndex36)
            <=> v7550(VarNext,bitIndex1136) )
            & ( v4929_30__array(VarNext,A,bitIndex35)
            <=> v7550(VarNext,bitIndex1135) )
            & ( v4929_30__array(VarNext,A,bitIndex34)
            <=> v7550(VarNext,bitIndex1134) )
            & ( v4929_30__array(VarNext,A,bitIndex33)
            <=> v7550(VarNext,bitIndex1133) )
            & ( v4929_30__array(VarNext,A,bitIndex32)
            <=> v7550(VarNext,bitIndex1132) )
            & ( v4929_30__array(VarNext,A,bitIndex31)
            <=> v7550(VarNext,bitIndex1131) )
            & ( v4929_30__array(VarNext,A,bitIndex30)
            <=> v7550(VarNext,bitIndex1130) )
            & ( v4929_30__array(VarNext,A,bitIndex29)
            <=> v7550(VarNext,bitIndex1129) )
            & ( v4929_30__array(VarNext,A,bitIndex28)
            <=> v7550(VarNext,bitIndex1128) )
            & ( v4929_30__array(VarNext,A,bitIndex27)
            <=> v7550(VarNext,bitIndex1127) )
            & ( v4929_30__array(VarNext,A,bitIndex26)
            <=> v7550(VarNext,bitIndex1126) )
            & ( v4929_30__array(VarNext,A,bitIndex25)
            <=> v7550(VarNext,bitIndex1125) )
            & ( v4929_30__array(VarNext,A,bitIndex24)
            <=> v7550(VarNext,bitIndex1124) )
            & ( v4929_30__array(VarNext,A,bitIndex23)
            <=> v7550(VarNext,bitIndex1123) )
            & ( v4929_30__array(VarNext,A,bitIndex22)
            <=> v7550(VarNext,bitIndex1122) )
            & ( v4929_30__array(VarNext,A,bitIndex21)
            <=> v7550(VarNext,bitIndex1121) )
            & ( v4929_30__array(VarNext,A,bitIndex20)
            <=> v7550(VarNext,bitIndex1120) )
            & ( v4929_30__array(VarNext,A,bitIndex19)
            <=> v7550(VarNext,bitIndex1119) )
            & ( v4929_30__array(VarNext,A,bitIndex18)
            <=> v7550(VarNext,bitIndex1118) )
            & ( v4929_30__array(VarNext,A,bitIndex17)
            <=> v7550(VarNext,bitIndex1117) )
            & ( v4929_30__array(VarNext,A,bitIndex16)
            <=> v7550(VarNext,bitIndex1116) )
            & ( v4929_30__array(VarNext,A,bitIndex15)
            <=> v7550(VarNext,bitIndex1115) )
            & ( v4929_30__array(VarNext,A,bitIndex14)
            <=> v7550(VarNext,bitIndex1114) )
            & ( v4929_30__array(VarNext,A,bitIndex13)
            <=> v7550(VarNext,bitIndex1113) )
            & ( v4929_30__array(VarNext,A,bitIndex12)
            <=> v7550(VarNext,bitIndex1112) )
            & ( v4929_30__array(VarNext,A,bitIndex11)
            <=> v7550(VarNext,bitIndex1111) )
            & ( v4929_30__array(VarNext,A,bitIndex10)
            <=> v7550(VarNext,bitIndex1110) )
            & ( v4929_30__array(VarNext,A,bitIndex9)
            <=> v7550(VarNext,bitIndex1109) )
            & ( v4929_30__array(VarNext,A,bitIndex8)
            <=> v7550(VarNext,bitIndex1108) )
            & ( v4929_30__array(VarNext,A,bitIndex7)
            <=> v7550(VarNext,bitIndex1107) )
            & ( v4929_30__array(VarNext,A,bitIndex6)
            <=> v7550(VarNext,bitIndex1106) )
            & ( v4929_30__array(VarNext,A,bitIndex5)
            <=> v7550(VarNext,bitIndex1105) )
            & ( v4929_30__array(VarNext,A,bitIndex4)
            <=> v7550(VarNext,bitIndex1104) )
            & ( v4929_30__array(VarNext,A,bitIndex3)
            <=> v7550(VarNext,bitIndex1103) )
            & ( v4929_30__array(VarNext,A,bitIndex2)
            <=> v7550(VarNext,bitIndex1102) )
            & ( v4929_30__array(VarNext,A,bitIndex1)
            <=> v7550(VarNext,bitIndex1101) )
            & ( v4929_30__array(VarNext,A,bitIndex0)
            <=> v7550(VarNext,bitIndex1100) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1361,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7544(VarNext)
      <=> ( v7545(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1360,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7545(VarNext)
      <=> ( v7547(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_641,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7547(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_48,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11000_address_term = A
              & v7535(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_29__array(VarNext,A,B)
              <=> v4929_28__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_48,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11000_address_term = A
            & v7535(VarNext) )
         => ( ( v4929_29__array(VarNext,A,bitIndex43)
            <=> v7541(VarNext,bitIndex1099) )
            & ( v4929_29__array(VarNext,A,bitIndex42)
            <=> v7541(VarNext,bitIndex1098) )
            & ( v4929_29__array(VarNext,A,bitIndex41)
            <=> v7541(VarNext,bitIndex1097) )
            & ( v4929_29__array(VarNext,A,bitIndex40)
            <=> v7541(VarNext,bitIndex1096) )
            & ( v4929_29__array(VarNext,A,bitIndex39)
            <=> v7541(VarNext,bitIndex1095) )
            & ( v4929_29__array(VarNext,A,bitIndex38)
            <=> v7541(VarNext,bitIndex1094) )
            & ( v4929_29__array(VarNext,A,bitIndex37)
            <=> v7541(VarNext,bitIndex1093) )
            & ( v4929_29__array(VarNext,A,bitIndex36)
            <=> v7541(VarNext,bitIndex1092) )
            & ( v4929_29__array(VarNext,A,bitIndex35)
            <=> v7541(VarNext,bitIndex1091) )
            & ( v4929_29__array(VarNext,A,bitIndex34)
            <=> v7541(VarNext,bitIndex1090) )
            & ( v4929_29__array(VarNext,A,bitIndex33)
            <=> v7541(VarNext,bitIndex1089) )
            & ( v4929_29__array(VarNext,A,bitIndex32)
            <=> v7541(VarNext,bitIndex1088) )
            & ( v4929_29__array(VarNext,A,bitIndex31)
            <=> v7541(VarNext,bitIndex1087) )
            & ( v4929_29__array(VarNext,A,bitIndex30)
            <=> v7541(VarNext,bitIndex1086) )
            & ( v4929_29__array(VarNext,A,bitIndex29)
            <=> v7541(VarNext,bitIndex1085) )
            & ( v4929_29__array(VarNext,A,bitIndex28)
            <=> v7541(VarNext,bitIndex1084) )
            & ( v4929_29__array(VarNext,A,bitIndex27)
            <=> v7541(VarNext,bitIndex1083) )
            & ( v4929_29__array(VarNext,A,bitIndex26)
            <=> v7541(VarNext,bitIndex1082) )
            & ( v4929_29__array(VarNext,A,bitIndex25)
            <=> v7541(VarNext,bitIndex1081) )
            & ( v4929_29__array(VarNext,A,bitIndex24)
            <=> v7541(VarNext,bitIndex1080) )
            & ( v4929_29__array(VarNext,A,bitIndex23)
            <=> v7541(VarNext,bitIndex1079) )
            & ( v4929_29__array(VarNext,A,bitIndex22)
            <=> v7541(VarNext,bitIndex1078) )
            & ( v4929_29__array(VarNext,A,bitIndex21)
            <=> v7541(VarNext,bitIndex1077) )
            & ( v4929_29__array(VarNext,A,bitIndex20)
            <=> v7541(VarNext,bitIndex1076) )
            & ( v4929_29__array(VarNext,A,bitIndex19)
            <=> v7541(VarNext,bitIndex1075) )
            & ( v4929_29__array(VarNext,A,bitIndex18)
            <=> v7541(VarNext,bitIndex1074) )
            & ( v4929_29__array(VarNext,A,bitIndex17)
            <=> v7541(VarNext,bitIndex1073) )
            & ( v4929_29__array(VarNext,A,bitIndex16)
            <=> v7541(VarNext,bitIndex1072) )
            & ( v4929_29__array(VarNext,A,bitIndex15)
            <=> v7541(VarNext,bitIndex1071) )
            & ( v4929_29__array(VarNext,A,bitIndex14)
            <=> v7541(VarNext,bitIndex1070) )
            & ( v4929_29__array(VarNext,A,bitIndex13)
            <=> v7541(VarNext,bitIndex1069) )
            & ( v4929_29__array(VarNext,A,bitIndex12)
            <=> v7541(VarNext,bitIndex1068) )
            & ( v4929_29__array(VarNext,A,bitIndex11)
            <=> v7541(VarNext,bitIndex1067) )
            & ( v4929_29__array(VarNext,A,bitIndex10)
            <=> v7541(VarNext,bitIndex1066) )
            & ( v4929_29__array(VarNext,A,bitIndex9)
            <=> v7541(VarNext,bitIndex1065) )
            & ( v4929_29__array(VarNext,A,bitIndex8)
            <=> v7541(VarNext,bitIndex1064) )
            & ( v4929_29__array(VarNext,A,bitIndex7)
            <=> v7541(VarNext,bitIndex1063) )
            & ( v4929_29__array(VarNext,A,bitIndex6)
            <=> v7541(VarNext,bitIndex1062) )
            & ( v4929_29__array(VarNext,A,bitIndex5)
            <=> v7541(VarNext,bitIndex1061) )
            & ( v4929_29__array(VarNext,A,bitIndex4)
            <=> v7541(VarNext,bitIndex1060) )
            & ( v4929_29__array(VarNext,A,bitIndex3)
            <=> v7541(VarNext,bitIndex1059) )
            & ( v4929_29__array(VarNext,A,bitIndex2)
            <=> v7541(VarNext,bitIndex1058) )
            & ( v4929_29__array(VarNext,A,bitIndex1)
            <=> v7541(VarNext,bitIndex1057) )
            & ( v4929_29__array(VarNext,A,bitIndex0)
            <=> v7541(VarNext,bitIndex1056) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1359,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7535(VarNext)
      <=> ( v7536(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1358,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7536(VarNext)
      <=> ( v7538(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_640,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7538(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_47,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10111_address_term = A
              & v7526(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_28__array(VarNext,A,B)
              <=> v4929_27__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_47,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10111_address_term = A
            & v7526(VarNext) )
         => ( ( v4929_28__array(VarNext,A,bitIndex43)
            <=> v7532(VarNext,bitIndex1055) )
            & ( v4929_28__array(VarNext,A,bitIndex42)
            <=> v7532(VarNext,bitIndex1054) )
            & ( v4929_28__array(VarNext,A,bitIndex41)
            <=> v7532(VarNext,bitIndex1053) )
            & ( v4929_28__array(VarNext,A,bitIndex40)
            <=> v7532(VarNext,bitIndex1052) )
            & ( v4929_28__array(VarNext,A,bitIndex39)
            <=> v7532(VarNext,bitIndex1051) )
            & ( v4929_28__array(VarNext,A,bitIndex38)
            <=> v7532(VarNext,bitIndex1050) )
            & ( v4929_28__array(VarNext,A,bitIndex37)
            <=> v7532(VarNext,bitIndex1049) )
            & ( v4929_28__array(VarNext,A,bitIndex36)
            <=> v7532(VarNext,bitIndex1048) )
            & ( v4929_28__array(VarNext,A,bitIndex35)
            <=> v7532(VarNext,bitIndex1047) )
            & ( v4929_28__array(VarNext,A,bitIndex34)
            <=> v7532(VarNext,bitIndex1046) )
            & ( v4929_28__array(VarNext,A,bitIndex33)
            <=> v7532(VarNext,bitIndex1045) )
            & ( v4929_28__array(VarNext,A,bitIndex32)
            <=> v7532(VarNext,bitIndex1044) )
            & ( v4929_28__array(VarNext,A,bitIndex31)
            <=> v7532(VarNext,bitIndex1043) )
            & ( v4929_28__array(VarNext,A,bitIndex30)
            <=> v7532(VarNext,bitIndex1042) )
            & ( v4929_28__array(VarNext,A,bitIndex29)
            <=> v7532(VarNext,bitIndex1041) )
            & ( v4929_28__array(VarNext,A,bitIndex28)
            <=> v7532(VarNext,bitIndex1040) )
            & ( v4929_28__array(VarNext,A,bitIndex27)
            <=> v7532(VarNext,bitIndex1039) )
            & ( v4929_28__array(VarNext,A,bitIndex26)
            <=> v7532(VarNext,bitIndex1038) )
            & ( v4929_28__array(VarNext,A,bitIndex25)
            <=> v7532(VarNext,bitIndex1037) )
            & ( v4929_28__array(VarNext,A,bitIndex24)
            <=> v7532(VarNext,bitIndex1036) )
            & ( v4929_28__array(VarNext,A,bitIndex23)
            <=> v7532(VarNext,bitIndex1035) )
            & ( v4929_28__array(VarNext,A,bitIndex22)
            <=> v7532(VarNext,bitIndex1034) )
            & ( v4929_28__array(VarNext,A,bitIndex21)
            <=> v7532(VarNext,bitIndex1033) )
            & ( v4929_28__array(VarNext,A,bitIndex20)
            <=> v7532(VarNext,bitIndex1032) )
            & ( v4929_28__array(VarNext,A,bitIndex19)
            <=> v7532(VarNext,bitIndex1031) )
            & ( v4929_28__array(VarNext,A,bitIndex18)
            <=> v7532(VarNext,bitIndex1030) )
            & ( v4929_28__array(VarNext,A,bitIndex17)
            <=> v7532(VarNext,bitIndex1029) )
            & ( v4929_28__array(VarNext,A,bitIndex16)
            <=> v7532(VarNext,bitIndex1028) )
            & ( v4929_28__array(VarNext,A,bitIndex15)
            <=> v7532(VarNext,bitIndex1027) )
            & ( v4929_28__array(VarNext,A,bitIndex14)
            <=> v7532(VarNext,bitIndex1026) )
            & ( v4929_28__array(VarNext,A,bitIndex13)
            <=> v7532(VarNext,bitIndex1025) )
            & ( v4929_28__array(VarNext,A,bitIndex12)
            <=> v7532(VarNext,bitIndex1024) )
            & ( v4929_28__array(VarNext,A,bitIndex11)
            <=> v7532(VarNext,bitIndex1023) )
            & ( v4929_28__array(VarNext,A,bitIndex10)
            <=> v7532(VarNext,bitIndex1022) )
            & ( v4929_28__array(VarNext,A,bitIndex9)
            <=> v7532(VarNext,bitIndex1021) )
            & ( v4929_28__array(VarNext,A,bitIndex8)
            <=> v7532(VarNext,bitIndex1020) )
            & ( v4929_28__array(VarNext,A,bitIndex7)
            <=> v7532(VarNext,bitIndex1019) )
            & ( v4929_28__array(VarNext,A,bitIndex6)
            <=> v7532(VarNext,bitIndex1018) )
            & ( v4929_28__array(VarNext,A,bitIndex5)
            <=> v7532(VarNext,bitIndex1017) )
            & ( v4929_28__array(VarNext,A,bitIndex4)
            <=> v7532(VarNext,bitIndex1016) )
            & ( v4929_28__array(VarNext,A,bitIndex3)
            <=> v7532(VarNext,bitIndex1015) )
            & ( v4929_28__array(VarNext,A,bitIndex2)
            <=> v7532(VarNext,bitIndex1014) )
            & ( v4929_28__array(VarNext,A,bitIndex1)
            <=> v7532(VarNext,bitIndex1013) )
            & ( v4929_28__array(VarNext,A,bitIndex0)
            <=> v7532(VarNext,bitIndex1012) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1357,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7526(VarNext)
      <=> ( v7527(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1356,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7527(VarNext)
      <=> ( v7529(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_639,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7529(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_46,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10110_address_term = A
              & v7517(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_27__array(VarNext,A,B)
              <=> v4929_26__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_46,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10110_address_term = A
            & v7517(VarNext) )
         => ( ( v4929_27__array(VarNext,A,bitIndex43)
            <=> v7523(VarNext,bitIndex1011) )
            & ( v4929_27__array(VarNext,A,bitIndex42)
            <=> v7523(VarNext,bitIndex1010) )
            & ( v4929_27__array(VarNext,A,bitIndex41)
            <=> v7523(VarNext,bitIndex1009) )
            & ( v4929_27__array(VarNext,A,bitIndex40)
            <=> v7523(VarNext,bitIndex1008) )
            & ( v4929_27__array(VarNext,A,bitIndex39)
            <=> v7523(VarNext,bitIndex1007) )
            & ( v4929_27__array(VarNext,A,bitIndex38)
            <=> v7523(VarNext,bitIndex1006) )
            & ( v4929_27__array(VarNext,A,bitIndex37)
            <=> v7523(VarNext,bitIndex1005) )
            & ( v4929_27__array(VarNext,A,bitIndex36)
            <=> v7523(VarNext,bitIndex1004) )
            & ( v4929_27__array(VarNext,A,bitIndex35)
            <=> v7523(VarNext,bitIndex1003) )
            & ( v4929_27__array(VarNext,A,bitIndex34)
            <=> v7523(VarNext,bitIndex1002) )
            & ( v4929_27__array(VarNext,A,bitIndex33)
            <=> v7523(VarNext,bitIndex1001) )
            & ( v4929_27__array(VarNext,A,bitIndex32)
            <=> v7523(VarNext,bitIndex1000) )
            & ( v4929_27__array(VarNext,A,bitIndex31)
            <=> v7523(VarNext,bitIndex999) )
            & ( v4929_27__array(VarNext,A,bitIndex30)
            <=> v7523(VarNext,bitIndex998) )
            & ( v4929_27__array(VarNext,A,bitIndex29)
            <=> v7523(VarNext,bitIndex997) )
            & ( v4929_27__array(VarNext,A,bitIndex28)
            <=> v7523(VarNext,bitIndex996) )
            & ( v4929_27__array(VarNext,A,bitIndex27)
            <=> v7523(VarNext,bitIndex995) )
            & ( v4929_27__array(VarNext,A,bitIndex26)
            <=> v7523(VarNext,bitIndex994) )
            & ( v4929_27__array(VarNext,A,bitIndex25)
            <=> v7523(VarNext,bitIndex993) )
            & ( v4929_27__array(VarNext,A,bitIndex24)
            <=> v7523(VarNext,bitIndex992) )
            & ( v4929_27__array(VarNext,A,bitIndex23)
            <=> v7523(VarNext,bitIndex991) )
            & ( v4929_27__array(VarNext,A,bitIndex22)
            <=> v7523(VarNext,bitIndex990) )
            & ( v4929_27__array(VarNext,A,bitIndex21)
            <=> v7523(VarNext,bitIndex989) )
            & ( v4929_27__array(VarNext,A,bitIndex20)
            <=> v7523(VarNext,bitIndex988) )
            & ( v4929_27__array(VarNext,A,bitIndex19)
            <=> v7523(VarNext,bitIndex987) )
            & ( v4929_27__array(VarNext,A,bitIndex18)
            <=> v7523(VarNext,bitIndex986) )
            & ( v4929_27__array(VarNext,A,bitIndex17)
            <=> v7523(VarNext,bitIndex985) )
            & ( v4929_27__array(VarNext,A,bitIndex16)
            <=> v7523(VarNext,bitIndex984) )
            & ( v4929_27__array(VarNext,A,bitIndex15)
            <=> v7523(VarNext,bitIndex983) )
            & ( v4929_27__array(VarNext,A,bitIndex14)
            <=> v7523(VarNext,bitIndex982) )
            & ( v4929_27__array(VarNext,A,bitIndex13)
            <=> v7523(VarNext,bitIndex981) )
            & ( v4929_27__array(VarNext,A,bitIndex12)
            <=> v7523(VarNext,bitIndex980) )
            & ( v4929_27__array(VarNext,A,bitIndex11)
            <=> v7523(VarNext,bitIndex979) )
            & ( v4929_27__array(VarNext,A,bitIndex10)
            <=> v7523(VarNext,bitIndex978) )
            & ( v4929_27__array(VarNext,A,bitIndex9)
            <=> v7523(VarNext,bitIndex977) )
            & ( v4929_27__array(VarNext,A,bitIndex8)
            <=> v7523(VarNext,bitIndex976) )
            & ( v4929_27__array(VarNext,A,bitIndex7)
            <=> v7523(VarNext,bitIndex975) )
            & ( v4929_27__array(VarNext,A,bitIndex6)
            <=> v7523(VarNext,bitIndex974) )
            & ( v4929_27__array(VarNext,A,bitIndex5)
            <=> v7523(VarNext,bitIndex973) )
            & ( v4929_27__array(VarNext,A,bitIndex4)
            <=> v7523(VarNext,bitIndex972) )
            & ( v4929_27__array(VarNext,A,bitIndex3)
            <=> v7523(VarNext,bitIndex971) )
            & ( v4929_27__array(VarNext,A,bitIndex2)
            <=> v7523(VarNext,bitIndex970) )
            & ( v4929_27__array(VarNext,A,bitIndex1)
            <=> v7523(VarNext,bitIndex969) )
            & ( v4929_27__array(VarNext,A,bitIndex0)
            <=> v7523(VarNext,bitIndex968) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1355,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7517(VarNext)
      <=> ( v7518(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1354,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7518(VarNext)
      <=> ( v7520(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_638,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7520(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_45,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10101_address_term = A
              & v7508(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_26__array(VarNext,A,B)
              <=> v4929_25__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_45,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10101_address_term = A
            & v7508(VarNext) )
         => ( ( v4929_26__array(VarNext,A,bitIndex43)
            <=> v7514(VarNext,bitIndex967) )
            & ( v4929_26__array(VarNext,A,bitIndex42)
            <=> v7514(VarNext,bitIndex966) )
            & ( v4929_26__array(VarNext,A,bitIndex41)
            <=> v7514(VarNext,bitIndex965) )
            & ( v4929_26__array(VarNext,A,bitIndex40)
            <=> v7514(VarNext,bitIndex964) )
            & ( v4929_26__array(VarNext,A,bitIndex39)
            <=> v7514(VarNext,bitIndex963) )
            & ( v4929_26__array(VarNext,A,bitIndex38)
            <=> v7514(VarNext,bitIndex962) )
            & ( v4929_26__array(VarNext,A,bitIndex37)
            <=> v7514(VarNext,bitIndex961) )
            & ( v4929_26__array(VarNext,A,bitIndex36)
            <=> v7514(VarNext,bitIndex960) )
            & ( v4929_26__array(VarNext,A,bitIndex35)
            <=> v7514(VarNext,bitIndex959) )
            & ( v4929_26__array(VarNext,A,bitIndex34)
            <=> v7514(VarNext,bitIndex958) )
            & ( v4929_26__array(VarNext,A,bitIndex33)
            <=> v7514(VarNext,bitIndex957) )
            & ( v4929_26__array(VarNext,A,bitIndex32)
            <=> v7514(VarNext,bitIndex956) )
            & ( v4929_26__array(VarNext,A,bitIndex31)
            <=> v7514(VarNext,bitIndex955) )
            & ( v4929_26__array(VarNext,A,bitIndex30)
            <=> v7514(VarNext,bitIndex954) )
            & ( v4929_26__array(VarNext,A,bitIndex29)
            <=> v7514(VarNext,bitIndex953) )
            & ( v4929_26__array(VarNext,A,bitIndex28)
            <=> v7514(VarNext,bitIndex952) )
            & ( v4929_26__array(VarNext,A,bitIndex27)
            <=> v7514(VarNext,bitIndex951) )
            & ( v4929_26__array(VarNext,A,bitIndex26)
            <=> v7514(VarNext,bitIndex950) )
            & ( v4929_26__array(VarNext,A,bitIndex25)
            <=> v7514(VarNext,bitIndex949) )
            & ( v4929_26__array(VarNext,A,bitIndex24)
            <=> v7514(VarNext,bitIndex948) )
            & ( v4929_26__array(VarNext,A,bitIndex23)
            <=> v7514(VarNext,bitIndex947) )
            & ( v4929_26__array(VarNext,A,bitIndex22)
            <=> v7514(VarNext,bitIndex946) )
            & ( v4929_26__array(VarNext,A,bitIndex21)
            <=> v7514(VarNext,bitIndex945) )
            & ( v4929_26__array(VarNext,A,bitIndex20)
            <=> v7514(VarNext,bitIndex944) )
            & ( v4929_26__array(VarNext,A,bitIndex19)
            <=> v7514(VarNext,bitIndex943) )
            & ( v4929_26__array(VarNext,A,bitIndex18)
            <=> v7514(VarNext,bitIndex942) )
            & ( v4929_26__array(VarNext,A,bitIndex17)
            <=> v7514(VarNext,bitIndex941) )
            & ( v4929_26__array(VarNext,A,bitIndex16)
            <=> v7514(VarNext,bitIndex940) )
            & ( v4929_26__array(VarNext,A,bitIndex15)
            <=> v7514(VarNext,bitIndex939) )
            & ( v4929_26__array(VarNext,A,bitIndex14)
            <=> v7514(VarNext,bitIndex938) )
            & ( v4929_26__array(VarNext,A,bitIndex13)
            <=> v7514(VarNext,bitIndex937) )
            & ( v4929_26__array(VarNext,A,bitIndex12)
            <=> v7514(VarNext,bitIndex936) )
            & ( v4929_26__array(VarNext,A,bitIndex11)
            <=> v7514(VarNext,bitIndex935) )
            & ( v4929_26__array(VarNext,A,bitIndex10)
            <=> v7514(VarNext,bitIndex934) )
            & ( v4929_26__array(VarNext,A,bitIndex9)
            <=> v7514(VarNext,bitIndex933) )
            & ( v4929_26__array(VarNext,A,bitIndex8)
            <=> v7514(VarNext,bitIndex932) )
            & ( v4929_26__array(VarNext,A,bitIndex7)
            <=> v7514(VarNext,bitIndex931) )
            & ( v4929_26__array(VarNext,A,bitIndex6)
            <=> v7514(VarNext,bitIndex930) )
            & ( v4929_26__array(VarNext,A,bitIndex5)
            <=> v7514(VarNext,bitIndex929) )
            & ( v4929_26__array(VarNext,A,bitIndex4)
            <=> v7514(VarNext,bitIndex928) )
            & ( v4929_26__array(VarNext,A,bitIndex3)
            <=> v7514(VarNext,bitIndex927) )
            & ( v4929_26__array(VarNext,A,bitIndex2)
            <=> v7514(VarNext,bitIndex926) )
            & ( v4929_26__array(VarNext,A,bitIndex1)
            <=> v7514(VarNext,bitIndex925) )
            & ( v4929_26__array(VarNext,A,bitIndex0)
            <=> v7514(VarNext,bitIndex924) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1353,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7508(VarNext)
      <=> ( v7509(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1352,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7509(VarNext)
      <=> ( v7511(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_637,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7511(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_44,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10100_address_term = A
              & v7499(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_25__array(VarNext,A,B)
              <=> v4929_24__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_44,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10100_address_term = A
            & v7499(VarNext) )
         => ( ( v4929_25__array(VarNext,A,bitIndex43)
            <=> v7505(VarNext,bitIndex923) )
            & ( v4929_25__array(VarNext,A,bitIndex42)
            <=> v7505(VarNext,bitIndex922) )
            & ( v4929_25__array(VarNext,A,bitIndex41)
            <=> v7505(VarNext,bitIndex921) )
            & ( v4929_25__array(VarNext,A,bitIndex40)
            <=> v7505(VarNext,bitIndex920) )
            & ( v4929_25__array(VarNext,A,bitIndex39)
            <=> v7505(VarNext,bitIndex919) )
            & ( v4929_25__array(VarNext,A,bitIndex38)
            <=> v7505(VarNext,bitIndex918) )
            & ( v4929_25__array(VarNext,A,bitIndex37)
            <=> v7505(VarNext,bitIndex917) )
            & ( v4929_25__array(VarNext,A,bitIndex36)
            <=> v7505(VarNext,bitIndex916) )
            & ( v4929_25__array(VarNext,A,bitIndex35)
            <=> v7505(VarNext,bitIndex915) )
            & ( v4929_25__array(VarNext,A,bitIndex34)
            <=> v7505(VarNext,bitIndex914) )
            & ( v4929_25__array(VarNext,A,bitIndex33)
            <=> v7505(VarNext,bitIndex913) )
            & ( v4929_25__array(VarNext,A,bitIndex32)
            <=> v7505(VarNext,bitIndex912) )
            & ( v4929_25__array(VarNext,A,bitIndex31)
            <=> v7505(VarNext,bitIndex911) )
            & ( v4929_25__array(VarNext,A,bitIndex30)
            <=> v7505(VarNext,bitIndex910) )
            & ( v4929_25__array(VarNext,A,bitIndex29)
            <=> v7505(VarNext,bitIndex909) )
            & ( v4929_25__array(VarNext,A,bitIndex28)
            <=> v7505(VarNext,bitIndex908) )
            & ( v4929_25__array(VarNext,A,bitIndex27)
            <=> v7505(VarNext,bitIndex907) )
            & ( v4929_25__array(VarNext,A,bitIndex26)
            <=> v7505(VarNext,bitIndex906) )
            & ( v4929_25__array(VarNext,A,bitIndex25)
            <=> v7505(VarNext,bitIndex905) )
            & ( v4929_25__array(VarNext,A,bitIndex24)
            <=> v7505(VarNext,bitIndex904) )
            & ( v4929_25__array(VarNext,A,bitIndex23)
            <=> v7505(VarNext,bitIndex903) )
            & ( v4929_25__array(VarNext,A,bitIndex22)
            <=> v7505(VarNext,bitIndex902) )
            & ( v4929_25__array(VarNext,A,bitIndex21)
            <=> v7505(VarNext,bitIndex901) )
            & ( v4929_25__array(VarNext,A,bitIndex20)
            <=> v7505(VarNext,bitIndex900) )
            & ( v4929_25__array(VarNext,A,bitIndex19)
            <=> v7505(VarNext,bitIndex899) )
            & ( v4929_25__array(VarNext,A,bitIndex18)
            <=> v7505(VarNext,bitIndex898) )
            & ( v4929_25__array(VarNext,A,bitIndex17)
            <=> v7505(VarNext,bitIndex897) )
            & ( v4929_25__array(VarNext,A,bitIndex16)
            <=> v7505(VarNext,bitIndex896) )
            & ( v4929_25__array(VarNext,A,bitIndex15)
            <=> v7505(VarNext,bitIndex895) )
            & ( v4929_25__array(VarNext,A,bitIndex14)
            <=> v7505(VarNext,bitIndex894) )
            & ( v4929_25__array(VarNext,A,bitIndex13)
            <=> v7505(VarNext,bitIndex893) )
            & ( v4929_25__array(VarNext,A,bitIndex12)
            <=> v7505(VarNext,bitIndex892) )
            & ( v4929_25__array(VarNext,A,bitIndex11)
            <=> v7505(VarNext,bitIndex891) )
            & ( v4929_25__array(VarNext,A,bitIndex10)
            <=> v7505(VarNext,bitIndex890) )
            & ( v4929_25__array(VarNext,A,bitIndex9)
            <=> v7505(VarNext,bitIndex889) )
            & ( v4929_25__array(VarNext,A,bitIndex8)
            <=> v7505(VarNext,bitIndex888) )
            & ( v4929_25__array(VarNext,A,bitIndex7)
            <=> v7505(VarNext,bitIndex887) )
            & ( v4929_25__array(VarNext,A,bitIndex6)
            <=> v7505(VarNext,bitIndex886) )
            & ( v4929_25__array(VarNext,A,bitIndex5)
            <=> v7505(VarNext,bitIndex885) )
            & ( v4929_25__array(VarNext,A,bitIndex4)
            <=> v7505(VarNext,bitIndex884) )
            & ( v4929_25__array(VarNext,A,bitIndex3)
            <=> v7505(VarNext,bitIndex883) )
            & ( v4929_25__array(VarNext,A,bitIndex2)
            <=> v7505(VarNext,bitIndex882) )
            & ( v4929_25__array(VarNext,A,bitIndex1)
            <=> v7505(VarNext,bitIndex881) )
            & ( v4929_25__array(VarNext,A,bitIndex0)
            <=> v7505(VarNext,bitIndex880) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1351,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7499(VarNext)
      <=> ( v7500(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1350,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7500(VarNext)
      <=> ( v7502(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_636,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7502(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_43,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10011_address_term = A
              & v7490(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_24__array(VarNext,A,B)
              <=> v4929_23__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_43,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10011_address_term = A
            & v7490(VarNext) )
         => ( ( v4929_24__array(VarNext,A,bitIndex43)
            <=> v7496(VarNext,bitIndex879) )
            & ( v4929_24__array(VarNext,A,bitIndex42)
            <=> v7496(VarNext,bitIndex878) )
            & ( v4929_24__array(VarNext,A,bitIndex41)
            <=> v7496(VarNext,bitIndex877) )
            & ( v4929_24__array(VarNext,A,bitIndex40)
            <=> v7496(VarNext,bitIndex876) )
            & ( v4929_24__array(VarNext,A,bitIndex39)
            <=> v7496(VarNext,bitIndex875) )
            & ( v4929_24__array(VarNext,A,bitIndex38)
            <=> v7496(VarNext,bitIndex874) )
            & ( v4929_24__array(VarNext,A,bitIndex37)
            <=> v7496(VarNext,bitIndex873) )
            & ( v4929_24__array(VarNext,A,bitIndex36)
            <=> v7496(VarNext,bitIndex872) )
            & ( v4929_24__array(VarNext,A,bitIndex35)
            <=> v7496(VarNext,bitIndex871) )
            & ( v4929_24__array(VarNext,A,bitIndex34)
            <=> v7496(VarNext,bitIndex870) )
            & ( v4929_24__array(VarNext,A,bitIndex33)
            <=> v7496(VarNext,bitIndex869) )
            & ( v4929_24__array(VarNext,A,bitIndex32)
            <=> v7496(VarNext,bitIndex868) )
            & ( v4929_24__array(VarNext,A,bitIndex31)
            <=> v7496(VarNext,bitIndex867) )
            & ( v4929_24__array(VarNext,A,bitIndex30)
            <=> v7496(VarNext,bitIndex866) )
            & ( v4929_24__array(VarNext,A,bitIndex29)
            <=> v7496(VarNext,bitIndex865) )
            & ( v4929_24__array(VarNext,A,bitIndex28)
            <=> v7496(VarNext,bitIndex864) )
            & ( v4929_24__array(VarNext,A,bitIndex27)
            <=> v7496(VarNext,bitIndex863) )
            & ( v4929_24__array(VarNext,A,bitIndex26)
            <=> v7496(VarNext,bitIndex862) )
            & ( v4929_24__array(VarNext,A,bitIndex25)
            <=> v7496(VarNext,bitIndex861) )
            & ( v4929_24__array(VarNext,A,bitIndex24)
            <=> v7496(VarNext,bitIndex860) )
            & ( v4929_24__array(VarNext,A,bitIndex23)
            <=> v7496(VarNext,bitIndex859) )
            & ( v4929_24__array(VarNext,A,bitIndex22)
            <=> v7496(VarNext,bitIndex858) )
            & ( v4929_24__array(VarNext,A,bitIndex21)
            <=> v7496(VarNext,bitIndex857) )
            & ( v4929_24__array(VarNext,A,bitIndex20)
            <=> v7496(VarNext,bitIndex856) )
            & ( v4929_24__array(VarNext,A,bitIndex19)
            <=> v7496(VarNext,bitIndex855) )
            & ( v4929_24__array(VarNext,A,bitIndex18)
            <=> v7496(VarNext,bitIndex854) )
            & ( v4929_24__array(VarNext,A,bitIndex17)
            <=> v7496(VarNext,bitIndex853) )
            & ( v4929_24__array(VarNext,A,bitIndex16)
            <=> v7496(VarNext,bitIndex852) )
            & ( v4929_24__array(VarNext,A,bitIndex15)
            <=> v7496(VarNext,bitIndex851) )
            & ( v4929_24__array(VarNext,A,bitIndex14)
            <=> v7496(VarNext,bitIndex850) )
            & ( v4929_24__array(VarNext,A,bitIndex13)
            <=> v7496(VarNext,bitIndex849) )
            & ( v4929_24__array(VarNext,A,bitIndex12)
            <=> v7496(VarNext,bitIndex848) )
            & ( v4929_24__array(VarNext,A,bitIndex11)
            <=> v7496(VarNext,bitIndex847) )
            & ( v4929_24__array(VarNext,A,bitIndex10)
            <=> v7496(VarNext,bitIndex846) )
            & ( v4929_24__array(VarNext,A,bitIndex9)
            <=> v7496(VarNext,bitIndex845) )
            & ( v4929_24__array(VarNext,A,bitIndex8)
            <=> v7496(VarNext,bitIndex844) )
            & ( v4929_24__array(VarNext,A,bitIndex7)
            <=> v7496(VarNext,bitIndex843) )
            & ( v4929_24__array(VarNext,A,bitIndex6)
            <=> v7496(VarNext,bitIndex842) )
            & ( v4929_24__array(VarNext,A,bitIndex5)
            <=> v7496(VarNext,bitIndex841) )
            & ( v4929_24__array(VarNext,A,bitIndex4)
            <=> v7496(VarNext,bitIndex840) )
            & ( v4929_24__array(VarNext,A,bitIndex3)
            <=> v7496(VarNext,bitIndex839) )
            & ( v4929_24__array(VarNext,A,bitIndex2)
            <=> v7496(VarNext,bitIndex838) )
            & ( v4929_24__array(VarNext,A,bitIndex1)
            <=> v7496(VarNext,bitIndex837) )
            & ( v4929_24__array(VarNext,A,bitIndex0)
            <=> v7496(VarNext,bitIndex836) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1349,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7490(VarNext)
      <=> ( v7491(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1348,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7491(VarNext)
      <=> ( v7493(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_635,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7493(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_42,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10010_address_term = A
              & v7481(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_23__array(VarNext,A,B)
              <=> v4929_22__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_42,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10010_address_term = A
            & v7481(VarNext) )
         => ( ( v4929_23__array(VarNext,A,bitIndex43)
            <=> v7487(VarNext,bitIndex835) )
            & ( v4929_23__array(VarNext,A,bitIndex42)
            <=> v7487(VarNext,bitIndex834) )
            & ( v4929_23__array(VarNext,A,bitIndex41)
            <=> v7487(VarNext,bitIndex833) )
            & ( v4929_23__array(VarNext,A,bitIndex40)
            <=> v7487(VarNext,bitIndex832) )
            & ( v4929_23__array(VarNext,A,bitIndex39)
            <=> v7487(VarNext,bitIndex831) )
            & ( v4929_23__array(VarNext,A,bitIndex38)
            <=> v7487(VarNext,bitIndex830) )
            & ( v4929_23__array(VarNext,A,bitIndex37)
            <=> v7487(VarNext,bitIndex829) )
            & ( v4929_23__array(VarNext,A,bitIndex36)
            <=> v7487(VarNext,bitIndex828) )
            & ( v4929_23__array(VarNext,A,bitIndex35)
            <=> v7487(VarNext,bitIndex827) )
            & ( v4929_23__array(VarNext,A,bitIndex34)
            <=> v7487(VarNext,bitIndex826) )
            & ( v4929_23__array(VarNext,A,bitIndex33)
            <=> v7487(VarNext,bitIndex825) )
            & ( v4929_23__array(VarNext,A,bitIndex32)
            <=> v7487(VarNext,bitIndex824) )
            & ( v4929_23__array(VarNext,A,bitIndex31)
            <=> v7487(VarNext,bitIndex823) )
            & ( v4929_23__array(VarNext,A,bitIndex30)
            <=> v7487(VarNext,bitIndex822) )
            & ( v4929_23__array(VarNext,A,bitIndex29)
            <=> v7487(VarNext,bitIndex821) )
            & ( v4929_23__array(VarNext,A,bitIndex28)
            <=> v7487(VarNext,bitIndex820) )
            & ( v4929_23__array(VarNext,A,bitIndex27)
            <=> v7487(VarNext,bitIndex819) )
            & ( v4929_23__array(VarNext,A,bitIndex26)
            <=> v7487(VarNext,bitIndex818) )
            & ( v4929_23__array(VarNext,A,bitIndex25)
            <=> v7487(VarNext,bitIndex817) )
            & ( v4929_23__array(VarNext,A,bitIndex24)
            <=> v7487(VarNext,bitIndex816) )
            & ( v4929_23__array(VarNext,A,bitIndex23)
            <=> v7487(VarNext,bitIndex815) )
            & ( v4929_23__array(VarNext,A,bitIndex22)
            <=> v7487(VarNext,bitIndex814) )
            & ( v4929_23__array(VarNext,A,bitIndex21)
            <=> v7487(VarNext,bitIndex813) )
            & ( v4929_23__array(VarNext,A,bitIndex20)
            <=> v7487(VarNext,bitIndex812) )
            & ( v4929_23__array(VarNext,A,bitIndex19)
            <=> v7487(VarNext,bitIndex811) )
            & ( v4929_23__array(VarNext,A,bitIndex18)
            <=> v7487(VarNext,bitIndex810) )
            & ( v4929_23__array(VarNext,A,bitIndex17)
            <=> v7487(VarNext,bitIndex809) )
            & ( v4929_23__array(VarNext,A,bitIndex16)
            <=> v7487(VarNext,bitIndex808) )
            & ( v4929_23__array(VarNext,A,bitIndex15)
            <=> v7487(VarNext,bitIndex807) )
            & ( v4929_23__array(VarNext,A,bitIndex14)
            <=> v7487(VarNext,bitIndex806) )
            & ( v4929_23__array(VarNext,A,bitIndex13)
            <=> v7487(VarNext,bitIndex805) )
            & ( v4929_23__array(VarNext,A,bitIndex12)
            <=> v7487(VarNext,bitIndex804) )
            & ( v4929_23__array(VarNext,A,bitIndex11)
            <=> v7487(VarNext,bitIndex803) )
            & ( v4929_23__array(VarNext,A,bitIndex10)
            <=> v7487(VarNext,bitIndex802) )
            & ( v4929_23__array(VarNext,A,bitIndex9)
            <=> v7487(VarNext,bitIndex801) )
            & ( v4929_23__array(VarNext,A,bitIndex8)
            <=> v7487(VarNext,bitIndex800) )
            & ( v4929_23__array(VarNext,A,bitIndex7)
            <=> v7487(VarNext,bitIndex799) )
            & ( v4929_23__array(VarNext,A,bitIndex6)
            <=> v7487(VarNext,bitIndex798) )
            & ( v4929_23__array(VarNext,A,bitIndex5)
            <=> v7487(VarNext,bitIndex797) )
            & ( v4929_23__array(VarNext,A,bitIndex4)
            <=> v7487(VarNext,bitIndex796) )
            & ( v4929_23__array(VarNext,A,bitIndex3)
            <=> v7487(VarNext,bitIndex795) )
            & ( v4929_23__array(VarNext,A,bitIndex2)
            <=> v7487(VarNext,bitIndex794) )
            & ( v4929_23__array(VarNext,A,bitIndex1)
            <=> v7487(VarNext,bitIndex793) )
            & ( v4929_23__array(VarNext,A,bitIndex0)
            <=> v7487(VarNext,bitIndex792) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1347,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7481(VarNext)
      <=> ( v7482(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1346,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7482(VarNext)
      <=> ( v7484(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_634,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7484(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_41,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10001_address_term = A
              & v7472(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_22__array(VarNext,A,B)
              <=> v4929_21__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_41,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10001_address_term = A
            & v7472(VarNext) )
         => ( ( v4929_22__array(VarNext,A,bitIndex43)
            <=> v7478(VarNext,bitIndex791) )
            & ( v4929_22__array(VarNext,A,bitIndex42)
            <=> v7478(VarNext,bitIndex790) )
            & ( v4929_22__array(VarNext,A,bitIndex41)
            <=> v7478(VarNext,bitIndex789) )
            & ( v4929_22__array(VarNext,A,bitIndex40)
            <=> v7478(VarNext,bitIndex788) )
            & ( v4929_22__array(VarNext,A,bitIndex39)
            <=> v7478(VarNext,bitIndex787) )
            & ( v4929_22__array(VarNext,A,bitIndex38)
            <=> v7478(VarNext,bitIndex786) )
            & ( v4929_22__array(VarNext,A,bitIndex37)
            <=> v7478(VarNext,bitIndex785) )
            & ( v4929_22__array(VarNext,A,bitIndex36)
            <=> v7478(VarNext,bitIndex784) )
            & ( v4929_22__array(VarNext,A,bitIndex35)
            <=> v7478(VarNext,bitIndex783) )
            & ( v4929_22__array(VarNext,A,bitIndex34)
            <=> v7478(VarNext,bitIndex782) )
            & ( v4929_22__array(VarNext,A,bitIndex33)
            <=> v7478(VarNext,bitIndex781) )
            & ( v4929_22__array(VarNext,A,bitIndex32)
            <=> v7478(VarNext,bitIndex780) )
            & ( v4929_22__array(VarNext,A,bitIndex31)
            <=> v7478(VarNext,bitIndex779) )
            & ( v4929_22__array(VarNext,A,bitIndex30)
            <=> v7478(VarNext,bitIndex778) )
            & ( v4929_22__array(VarNext,A,bitIndex29)
            <=> v7478(VarNext,bitIndex777) )
            & ( v4929_22__array(VarNext,A,bitIndex28)
            <=> v7478(VarNext,bitIndex776) )
            & ( v4929_22__array(VarNext,A,bitIndex27)
            <=> v7478(VarNext,bitIndex775) )
            & ( v4929_22__array(VarNext,A,bitIndex26)
            <=> v7478(VarNext,bitIndex774) )
            & ( v4929_22__array(VarNext,A,bitIndex25)
            <=> v7478(VarNext,bitIndex773) )
            & ( v4929_22__array(VarNext,A,bitIndex24)
            <=> v7478(VarNext,bitIndex772) )
            & ( v4929_22__array(VarNext,A,bitIndex23)
            <=> v7478(VarNext,bitIndex771) )
            & ( v4929_22__array(VarNext,A,bitIndex22)
            <=> v7478(VarNext,bitIndex770) )
            & ( v4929_22__array(VarNext,A,bitIndex21)
            <=> v7478(VarNext,bitIndex769) )
            & ( v4929_22__array(VarNext,A,bitIndex20)
            <=> v7478(VarNext,bitIndex768) )
            & ( v4929_22__array(VarNext,A,bitIndex19)
            <=> v7478(VarNext,bitIndex767) )
            & ( v4929_22__array(VarNext,A,bitIndex18)
            <=> v7478(VarNext,bitIndex766) )
            & ( v4929_22__array(VarNext,A,bitIndex17)
            <=> v7478(VarNext,bitIndex765) )
            & ( v4929_22__array(VarNext,A,bitIndex16)
            <=> v7478(VarNext,bitIndex764) )
            & ( v4929_22__array(VarNext,A,bitIndex15)
            <=> v7478(VarNext,bitIndex763) )
            & ( v4929_22__array(VarNext,A,bitIndex14)
            <=> v7478(VarNext,bitIndex762) )
            & ( v4929_22__array(VarNext,A,bitIndex13)
            <=> v7478(VarNext,bitIndex761) )
            & ( v4929_22__array(VarNext,A,bitIndex12)
            <=> v7478(VarNext,bitIndex760) )
            & ( v4929_22__array(VarNext,A,bitIndex11)
            <=> v7478(VarNext,bitIndex759) )
            & ( v4929_22__array(VarNext,A,bitIndex10)
            <=> v7478(VarNext,bitIndex758) )
            & ( v4929_22__array(VarNext,A,bitIndex9)
            <=> v7478(VarNext,bitIndex757) )
            & ( v4929_22__array(VarNext,A,bitIndex8)
            <=> v7478(VarNext,bitIndex756) )
            & ( v4929_22__array(VarNext,A,bitIndex7)
            <=> v7478(VarNext,bitIndex755) )
            & ( v4929_22__array(VarNext,A,bitIndex6)
            <=> v7478(VarNext,bitIndex754) )
            & ( v4929_22__array(VarNext,A,bitIndex5)
            <=> v7478(VarNext,bitIndex753) )
            & ( v4929_22__array(VarNext,A,bitIndex4)
            <=> v7478(VarNext,bitIndex752) )
            & ( v4929_22__array(VarNext,A,bitIndex3)
            <=> v7478(VarNext,bitIndex751) )
            & ( v4929_22__array(VarNext,A,bitIndex2)
            <=> v7478(VarNext,bitIndex750) )
            & ( v4929_22__array(VarNext,A,bitIndex1)
            <=> v7478(VarNext,bitIndex749) )
            & ( v4929_22__array(VarNext,A,bitIndex0)
            <=> v7478(VarNext,bitIndex748) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1345,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7472(VarNext)
      <=> ( v7473(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1344,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7473(VarNext)
      <=> ( v7475(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_633,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7475(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_40,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10000_address_term = A
              & v7463(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_21__array(VarNext,A,B)
              <=> v4929_20__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_40,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10000_address_term = A
            & v7463(VarNext) )
         => ( ( v4929_21__array(VarNext,A,bitIndex43)
            <=> v7469(VarNext,bitIndex747) )
            & ( v4929_21__array(VarNext,A,bitIndex42)
            <=> v7469(VarNext,bitIndex746) )
            & ( v4929_21__array(VarNext,A,bitIndex41)
            <=> v7469(VarNext,bitIndex745) )
            & ( v4929_21__array(VarNext,A,bitIndex40)
            <=> v7469(VarNext,bitIndex744) )
            & ( v4929_21__array(VarNext,A,bitIndex39)
            <=> v7469(VarNext,bitIndex743) )
            & ( v4929_21__array(VarNext,A,bitIndex38)
            <=> v7469(VarNext,bitIndex742) )
            & ( v4929_21__array(VarNext,A,bitIndex37)
            <=> v7469(VarNext,bitIndex741) )
            & ( v4929_21__array(VarNext,A,bitIndex36)
            <=> v7469(VarNext,bitIndex740) )
            & ( v4929_21__array(VarNext,A,bitIndex35)
            <=> v7469(VarNext,bitIndex739) )
            & ( v4929_21__array(VarNext,A,bitIndex34)
            <=> v7469(VarNext,bitIndex738) )
            & ( v4929_21__array(VarNext,A,bitIndex33)
            <=> v7469(VarNext,bitIndex737) )
            & ( v4929_21__array(VarNext,A,bitIndex32)
            <=> v7469(VarNext,bitIndex736) )
            & ( v4929_21__array(VarNext,A,bitIndex31)
            <=> v7469(VarNext,bitIndex735) )
            & ( v4929_21__array(VarNext,A,bitIndex30)
            <=> v7469(VarNext,bitIndex734) )
            & ( v4929_21__array(VarNext,A,bitIndex29)
            <=> v7469(VarNext,bitIndex733) )
            & ( v4929_21__array(VarNext,A,bitIndex28)
            <=> v7469(VarNext,bitIndex732) )
            & ( v4929_21__array(VarNext,A,bitIndex27)
            <=> v7469(VarNext,bitIndex731) )
            & ( v4929_21__array(VarNext,A,bitIndex26)
            <=> v7469(VarNext,bitIndex730) )
            & ( v4929_21__array(VarNext,A,bitIndex25)
            <=> v7469(VarNext,bitIndex729) )
            & ( v4929_21__array(VarNext,A,bitIndex24)
            <=> v7469(VarNext,bitIndex728) )
            & ( v4929_21__array(VarNext,A,bitIndex23)
            <=> v7469(VarNext,bitIndex727) )
            & ( v4929_21__array(VarNext,A,bitIndex22)
            <=> v7469(VarNext,bitIndex726) )
            & ( v4929_21__array(VarNext,A,bitIndex21)
            <=> v7469(VarNext,bitIndex725) )
            & ( v4929_21__array(VarNext,A,bitIndex20)
            <=> v7469(VarNext,bitIndex724) )
            & ( v4929_21__array(VarNext,A,bitIndex19)
            <=> v7469(VarNext,bitIndex723) )
            & ( v4929_21__array(VarNext,A,bitIndex18)
            <=> v7469(VarNext,bitIndex722) )
            & ( v4929_21__array(VarNext,A,bitIndex17)
            <=> v7469(VarNext,bitIndex721) )
            & ( v4929_21__array(VarNext,A,bitIndex16)
            <=> v7469(VarNext,bitIndex720) )
            & ( v4929_21__array(VarNext,A,bitIndex15)
            <=> v7469(VarNext,bitIndex719) )
            & ( v4929_21__array(VarNext,A,bitIndex14)
            <=> v7469(VarNext,bitIndex718) )
            & ( v4929_21__array(VarNext,A,bitIndex13)
            <=> v7469(VarNext,bitIndex717) )
            & ( v4929_21__array(VarNext,A,bitIndex12)
            <=> v7469(VarNext,bitIndex716) )
            & ( v4929_21__array(VarNext,A,bitIndex11)
            <=> v7469(VarNext,bitIndex715) )
            & ( v4929_21__array(VarNext,A,bitIndex10)
            <=> v7469(VarNext,bitIndex714) )
            & ( v4929_21__array(VarNext,A,bitIndex9)
            <=> v7469(VarNext,bitIndex713) )
            & ( v4929_21__array(VarNext,A,bitIndex8)
            <=> v7469(VarNext,bitIndex712) )
            & ( v4929_21__array(VarNext,A,bitIndex7)
            <=> v7469(VarNext,bitIndex711) )
            & ( v4929_21__array(VarNext,A,bitIndex6)
            <=> v7469(VarNext,bitIndex710) )
            & ( v4929_21__array(VarNext,A,bitIndex5)
            <=> v7469(VarNext,bitIndex709) )
            & ( v4929_21__array(VarNext,A,bitIndex4)
            <=> v7469(VarNext,bitIndex708) )
            & ( v4929_21__array(VarNext,A,bitIndex3)
            <=> v7469(VarNext,bitIndex707) )
            & ( v4929_21__array(VarNext,A,bitIndex2)
            <=> v7469(VarNext,bitIndex706) )
            & ( v4929_21__array(VarNext,A,bitIndex1)
            <=> v7469(VarNext,bitIndex705) )
            & ( v4929_21__array(VarNext,A,bitIndex0)
            <=> v7469(VarNext,bitIndex704) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1343,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7463(VarNext)
      <=> ( v7464(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1342,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7464(VarNext)
      <=> ( v7466(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_632,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7466(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_39,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01111_address_term = A
              & v7454(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_20__array(VarNext,A,B)
              <=> v4929_19__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_39,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01111_address_term = A
            & v7454(VarNext) )
         => ( ( v4929_20__array(VarNext,A,bitIndex43)
            <=> v7460(VarNext,bitIndex703) )
            & ( v4929_20__array(VarNext,A,bitIndex42)
            <=> v7460(VarNext,bitIndex702) )
            & ( v4929_20__array(VarNext,A,bitIndex41)
            <=> v7460(VarNext,bitIndex701) )
            & ( v4929_20__array(VarNext,A,bitIndex40)
            <=> v7460(VarNext,bitIndex700) )
            & ( v4929_20__array(VarNext,A,bitIndex39)
            <=> v7460(VarNext,bitIndex699) )
            & ( v4929_20__array(VarNext,A,bitIndex38)
            <=> v7460(VarNext,bitIndex698) )
            & ( v4929_20__array(VarNext,A,bitIndex37)
            <=> v7460(VarNext,bitIndex697) )
            & ( v4929_20__array(VarNext,A,bitIndex36)
            <=> v7460(VarNext,bitIndex696) )
            & ( v4929_20__array(VarNext,A,bitIndex35)
            <=> v7460(VarNext,bitIndex695) )
            & ( v4929_20__array(VarNext,A,bitIndex34)
            <=> v7460(VarNext,bitIndex694) )
            & ( v4929_20__array(VarNext,A,bitIndex33)
            <=> v7460(VarNext,bitIndex693) )
            & ( v4929_20__array(VarNext,A,bitIndex32)
            <=> v7460(VarNext,bitIndex692) )
            & ( v4929_20__array(VarNext,A,bitIndex31)
            <=> v7460(VarNext,bitIndex691) )
            & ( v4929_20__array(VarNext,A,bitIndex30)
            <=> v7460(VarNext,bitIndex690) )
            & ( v4929_20__array(VarNext,A,bitIndex29)
            <=> v7460(VarNext,bitIndex689) )
            & ( v4929_20__array(VarNext,A,bitIndex28)
            <=> v7460(VarNext,bitIndex688) )
            & ( v4929_20__array(VarNext,A,bitIndex27)
            <=> v7460(VarNext,bitIndex687) )
            & ( v4929_20__array(VarNext,A,bitIndex26)
            <=> v7460(VarNext,bitIndex686) )
            & ( v4929_20__array(VarNext,A,bitIndex25)
            <=> v7460(VarNext,bitIndex685) )
            & ( v4929_20__array(VarNext,A,bitIndex24)
            <=> v7460(VarNext,bitIndex684) )
            & ( v4929_20__array(VarNext,A,bitIndex23)
            <=> v7460(VarNext,bitIndex683) )
            & ( v4929_20__array(VarNext,A,bitIndex22)
            <=> v7460(VarNext,bitIndex682) )
            & ( v4929_20__array(VarNext,A,bitIndex21)
            <=> v7460(VarNext,bitIndex681) )
            & ( v4929_20__array(VarNext,A,bitIndex20)
            <=> v7460(VarNext,bitIndex680) )
            & ( v4929_20__array(VarNext,A,bitIndex19)
            <=> v7460(VarNext,bitIndex679) )
            & ( v4929_20__array(VarNext,A,bitIndex18)
            <=> v7460(VarNext,bitIndex678) )
            & ( v4929_20__array(VarNext,A,bitIndex17)
            <=> v7460(VarNext,bitIndex677) )
            & ( v4929_20__array(VarNext,A,bitIndex16)
            <=> v7460(VarNext,bitIndex676) )
            & ( v4929_20__array(VarNext,A,bitIndex15)
            <=> v7460(VarNext,bitIndex675) )
            & ( v4929_20__array(VarNext,A,bitIndex14)
            <=> v7460(VarNext,bitIndex674) )
            & ( v4929_20__array(VarNext,A,bitIndex13)
            <=> v7460(VarNext,bitIndex673) )
            & ( v4929_20__array(VarNext,A,bitIndex12)
            <=> v7460(VarNext,bitIndex672) )
            & ( v4929_20__array(VarNext,A,bitIndex11)
            <=> v7460(VarNext,bitIndex671) )
            & ( v4929_20__array(VarNext,A,bitIndex10)
            <=> v7460(VarNext,bitIndex670) )
            & ( v4929_20__array(VarNext,A,bitIndex9)
            <=> v7460(VarNext,bitIndex669) )
            & ( v4929_20__array(VarNext,A,bitIndex8)
            <=> v7460(VarNext,bitIndex668) )
            & ( v4929_20__array(VarNext,A,bitIndex7)
            <=> v7460(VarNext,bitIndex667) )
            & ( v4929_20__array(VarNext,A,bitIndex6)
            <=> v7460(VarNext,bitIndex666) )
            & ( v4929_20__array(VarNext,A,bitIndex5)
            <=> v7460(VarNext,bitIndex665) )
            & ( v4929_20__array(VarNext,A,bitIndex4)
            <=> v7460(VarNext,bitIndex664) )
            & ( v4929_20__array(VarNext,A,bitIndex3)
            <=> v7460(VarNext,bitIndex663) )
            & ( v4929_20__array(VarNext,A,bitIndex2)
            <=> v7460(VarNext,bitIndex662) )
            & ( v4929_20__array(VarNext,A,bitIndex1)
            <=> v7460(VarNext,bitIndex661) )
            & ( v4929_20__array(VarNext,A,bitIndex0)
            <=> v7460(VarNext,bitIndex660) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1341,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7454(VarNext)
      <=> ( v7455(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1340,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7455(VarNext)
      <=> ( v7457(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_631,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7457(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_38,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01110_address_term = A
              & v7445(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_19__array(VarNext,A,B)
              <=> v4929_18__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_38,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01110_address_term = A
            & v7445(VarNext) )
         => ( ( v4929_19__array(VarNext,A,bitIndex43)
            <=> v7451(VarNext,bitIndex659) )
            & ( v4929_19__array(VarNext,A,bitIndex42)
            <=> v7451(VarNext,bitIndex658) )
            & ( v4929_19__array(VarNext,A,bitIndex41)
            <=> v7451(VarNext,bitIndex657) )
            & ( v4929_19__array(VarNext,A,bitIndex40)
            <=> v7451(VarNext,bitIndex656) )
            & ( v4929_19__array(VarNext,A,bitIndex39)
            <=> v7451(VarNext,bitIndex655) )
            & ( v4929_19__array(VarNext,A,bitIndex38)
            <=> v7451(VarNext,bitIndex654) )
            & ( v4929_19__array(VarNext,A,bitIndex37)
            <=> v7451(VarNext,bitIndex653) )
            & ( v4929_19__array(VarNext,A,bitIndex36)
            <=> v7451(VarNext,bitIndex652) )
            & ( v4929_19__array(VarNext,A,bitIndex35)
            <=> v7451(VarNext,bitIndex651) )
            & ( v4929_19__array(VarNext,A,bitIndex34)
            <=> v7451(VarNext,bitIndex650) )
            & ( v4929_19__array(VarNext,A,bitIndex33)
            <=> v7451(VarNext,bitIndex649) )
            & ( v4929_19__array(VarNext,A,bitIndex32)
            <=> v7451(VarNext,bitIndex648) )
            & ( v4929_19__array(VarNext,A,bitIndex31)
            <=> v7451(VarNext,bitIndex647) )
            & ( v4929_19__array(VarNext,A,bitIndex30)
            <=> v7451(VarNext,bitIndex646) )
            & ( v4929_19__array(VarNext,A,bitIndex29)
            <=> v7451(VarNext,bitIndex645) )
            & ( v4929_19__array(VarNext,A,bitIndex28)
            <=> v7451(VarNext,bitIndex644) )
            & ( v4929_19__array(VarNext,A,bitIndex27)
            <=> v7451(VarNext,bitIndex643) )
            & ( v4929_19__array(VarNext,A,bitIndex26)
            <=> v7451(VarNext,bitIndex642) )
            & ( v4929_19__array(VarNext,A,bitIndex25)
            <=> v7451(VarNext,bitIndex641) )
            & ( v4929_19__array(VarNext,A,bitIndex24)
            <=> v7451(VarNext,bitIndex640) )
            & ( v4929_19__array(VarNext,A,bitIndex23)
            <=> v7451(VarNext,bitIndex639) )
            & ( v4929_19__array(VarNext,A,bitIndex22)
            <=> v7451(VarNext,bitIndex638) )
            & ( v4929_19__array(VarNext,A,bitIndex21)
            <=> v7451(VarNext,bitIndex637) )
            & ( v4929_19__array(VarNext,A,bitIndex20)
            <=> v7451(VarNext,bitIndex636) )
            & ( v4929_19__array(VarNext,A,bitIndex19)
            <=> v7451(VarNext,bitIndex635) )
            & ( v4929_19__array(VarNext,A,bitIndex18)
            <=> v7451(VarNext,bitIndex634) )
            & ( v4929_19__array(VarNext,A,bitIndex17)
            <=> v7451(VarNext,bitIndex633) )
            & ( v4929_19__array(VarNext,A,bitIndex16)
            <=> v7451(VarNext,bitIndex632) )
            & ( v4929_19__array(VarNext,A,bitIndex15)
            <=> v7451(VarNext,bitIndex631) )
            & ( v4929_19__array(VarNext,A,bitIndex14)
            <=> v7451(VarNext,bitIndex630) )
            & ( v4929_19__array(VarNext,A,bitIndex13)
            <=> v7451(VarNext,bitIndex629) )
            & ( v4929_19__array(VarNext,A,bitIndex12)
            <=> v7451(VarNext,bitIndex628) )
            & ( v4929_19__array(VarNext,A,bitIndex11)
            <=> v7451(VarNext,bitIndex627) )
            & ( v4929_19__array(VarNext,A,bitIndex10)
            <=> v7451(VarNext,bitIndex626) )
            & ( v4929_19__array(VarNext,A,bitIndex9)
            <=> v7451(VarNext,bitIndex625) )
            & ( v4929_19__array(VarNext,A,bitIndex8)
            <=> v7451(VarNext,bitIndex624) )
            & ( v4929_19__array(VarNext,A,bitIndex7)
            <=> v7451(VarNext,bitIndex623) )
            & ( v4929_19__array(VarNext,A,bitIndex6)
            <=> v7451(VarNext,bitIndex622) )
            & ( v4929_19__array(VarNext,A,bitIndex5)
            <=> v7451(VarNext,bitIndex621) )
            & ( v4929_19__array(VarNext,A,bitIndex4)
            <=> v7451(VarNext,bitIndex620) )
            & ( v4929_19__array(VarNext,A,bitIndex3)
            <=> v7451(VarNext,bitIndex619) )
            & ( v4929_19__array(VarNext,A,bitIndex2)
            <=> v7451(VarNext,bitIndex618) )
            & ( v4929_19__array(VarNext,A,bitIndex1)
            <=> v7451(VarNext,bitIndex617) )
            & ( v4929_19__array(VarNext,A,bitIndex0)
            <=> v7451(VarNext,bitIndex616) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1339,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7445(VarNext)
      <=> ( v7446(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1338,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7446(VarNext)
      <=> ( v7448(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_630,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7448(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_37,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01101_address_term = A
              & v7436(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_18__array(VarNext,A,B)
              <=> v4929_17__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_37,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01101_address_term = A
            & v7436(VarNext) )
         => ( ( v4929_18__array(VarNext,A,bitIndex43)
            <=> v7442(VarNext,bitIndex615) )
            & ( v4929_18__array(VarNext,A,bitIndex42)
            <=> v7442(VarNext,bitIndex614) )
            & ( v4929_18__array(VarNext,A,bitIndex41)
            <=> v7442(VarNext,bitIndex613) )
            & ( v4929_18__array(VarNext,A,bitIndex40)
            <=> v7442(VarNext,bitIndex612) )
            & ( v4929_18__array(VarNext,A,bitIndex39)
            <=> v7442(VarNext,bitIndex611) )
            & ( v4929_18__array(VarNext,A,bitIndex38)
            <=> v7442(VarNext,bitIndex610) )
            & ( v4929_18__array(VarNext,A,bitIndex37)
            <=> v7442(VarNext,bitIndex609) )
            & ( v4929_18__array(VarNext,A,bitIndex36)
            <=> v7442(VarNext,bitIndex608) )
            & ( v4929_18__array(VarNext,A,bitIndex35)
            <=> v7442(VarNext,bitIndex607) )
            & ( v4929_18__array(VarNext,A,bitIndex34)
            <=> v7442(VarNext,bitIndex606) )
            & ( v4929_18__array(VarNext,A,bitIndex33)
            <=> v7442(VarNext,bitIndex605) )
            & ( v4929_18__array(VarNext,A,bitIndex32)
            <=> v7442(VarNext,bitIndex604) )
            & ( v4929_18__array(VarNext,A,bitIndex31)
            <=> v7442(VarNext,bitIndex603) )
            & ( v4929_18__array(VarNext,A,bitIndex30)
            <=> v7442(VarNext,bitIndex602) )
            & ( v4929_18__array(VarNext,A,bitIndex29)
            <=> v7442(VarNext,bitIndex601) )
            & ( v4929_18__array(VarNext,A,bitIndex28)
            <=> v7442(VarNext,bitIndex600) )
            & ( v4929_18__array(VarNext,A,bitIndex27)
            <=> v7442(VarNext,bitIndex599) )
            & ( v4929_18__array(VarNext,A,bitIndex26)
            <=> v7442(VarNext,bitIndex598) )
            & ( v4929_18__array(VarNext,A,bitIndex25)
            <=> v7442(VarNext,bitIndex597) )
            & ( v4929_18__array(VarNext,A,bitIndex24)
            <=> v7442(VarNext,bitIndex596) )
            & ( v4929_18__array(VarNext,A,bitIndex23)
            <=> v7442(VarNext,bitIndex595) )
            & ( v4929_18__array(VarNext,A,bitIndex22)
            <=> v7442(VarNext,bitIndex594) )
            & ( v4929_18__array(VarNext,A,bitIndex21)
            <=> v7442(VarNext,bitIndex593) )
            & ( v4929_18__array(VarNext,A,bitIndex20)
            <=> v7442(VarNext,bitIndex592) )
            & ( v4929_18__array(VarNext,A,bitIndex19)
            <=> v7442(VarNext,bitIndex591) )
            & ( v4929_18__array(VarNext,A,bitIndex18)
            <=> v7442(VarNext,bitIndex590) )
            & ( v4929_18__array(VarNext,A,bitIndex17)
            <=> v7442(VarNext,bitIndex589) )
            & ( v4929_18__array(VarNext,A,bitIndex16)
            <=> v7442(VarNext,bitIndex588) )
            & ( v4929_18__array(VarNext,A,bitIndex15)
            <=> v7442(VarNext,bitIndex587) )
            & ( v4929_18__array(VarNext,A,bitIndex14)
            <=> v7442(VarNext,bitIndex586) )
            & ( v4929_18__array(VarNext,A,bitIndex13)
            <=> v7442(VarNext,bitIndex585) )
            & ( v4929_18__array(VarNext,A,bitIndex12)
            <=> v7442(VarNext,bitIndex584) )
            & ( v4929_18__array(VarNext,A,bitIndex11)
            <=> v7442(VarNext,bitIndex583) )
            & ( v4929_18__array(VarNext,A,bitIndex10)
            <=> v7442(VarNext,bitIndex582) )
            & ( v4929_18__array(VarNext,A,bitIndex9)
            <=> v7442(VarNext,bitIndex581) )
            & ( v4929_18__array(VarNext,A,bitIndex8)
            <=> v7442(VarNext,bitIndex580) )
            & ( v4929_18__array(VarNext,A,bitIndex7)
            <=> v7442(VarNext,bitIndex579) )
            & ( v4929_18__array(VarNext,A,bitIndex6)
            <=> v7442(VarNext,bitIndex578) )
            & ( v4929_18__array(VarNext,A,bitIndex5)
            <=> v7442(VarNext,bitIndex577) )
            & ( v4929_18__array(VarNext,A,bitIndex4)
            <=> v7442(VarNext,bitIndex576) )
            & ( v4929_18__array(VarNext,A,bitIndex3)
            <=> v7442(VarNext,bitIndex575) )
            & ( v4929_18__array(VarNext,A,bitIndex2)
            <=> v7442(VarNext,bitIndex574) )
            & ( v4929_18__array(VarNext,A,bitIndex1)
            <=> v7442(VarNext,bitIndex573) )
            & ( v4929_18__array(VarNext,A,bitIndex0)
            <=> v7442(VarNext,bitIndex572) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1337,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7436(VarNext)
      <=> ( v7437(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1336,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7437(VarNext)
      <=> ( v7439(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_629,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7439(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_36,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01100_address_term = A
              & v7427(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_17__array(VarNext,A,B)
              <=> v4929_16__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_36,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01100_address_term = A
            & v7427(VarNext) )
         => ( ( v4929_17__array(VarNext,A,bitIndex43)
            <=> v7433(VarNext,bitIndex571) )
            & ( v4929_17__array(VarNext,A,bitIndex42)
            <=> v7433(VarNext,bitIndex570) )
            & ( v4929_17__array(VarNext,A,bitIndex41)
            <=> v7433(VarNext,bitIndex569) )
            & ( v4929_17__array(VarNext,A,bitIndex40)
            <=> v7433(VarNext,bitIndex568) )
            & ( v4929_17__array(VarNext,A,bitIndex39)
            <=> v7433(VarNext,bitIndex567) )
            & ( v4929_17__array(VarNext,A,bitIndex38)
            <=> v7433(VarNext,bitIndex566) )
            & ( v4929_17__array(VarNext,A,bitIndex37)
            <=> v7433(VarNext,bitIndex565) )
            & ( v4929_17__array(VarNext,A,bitIndex36)
            <=> v7433(VarNext,bitIndex564) )
            & ( v4929_17__array(VarNext,A,bitIndex35)
            <=> v7433(VarNext,bitIndex563) )
            & ( v4929_17__array(VarNext,A,bitIndex34)
            <=> v7433(VarNext,bitIndex562) )
            & ( v4929_17__array(VarNext,A,bitIndex33)
            <=> v7433(VarNext,bitIndex561) )
            & ( v4929_17__array(VarNext,A,bitIndex32)
            <=> v7433(VarNext,bitIndex560) )
            & ( v4929_17__array(VarNext,A,bitIndex31)
            <=> v7433(VarNext,bitIndex559) )
            & ( v4929_17__array(VarNext,A,bitIndex30)
            <=> v7433(VarNext,bitIndex558) )
            & ( v4929_17__array(VarNext,A,bitIndex29)
            <=> v7433(VarNext,bitIndex557) )
            & ( v4929_17__array(VarNext,A,bitIndex28)
            <=> v7433(VarNext,bitIndex556) )
            & ( v4929_17__array(VarNext,A,bitIndex27)
            <=> v7433(VarNext,bitIndex555) )
            & ( v4929_17__array(VarNext,A,bitIndex26)
            <=> v7433(VarNext,bitIndex554) )
            & ( v4929_17__array(VarNext,A,bitIndex25)
            <=> v7433(VarNext,bitIndex553) )
            & ( v4929_17__array(VarNext,A,bitIndex24)
            <=> v7433(VarNext,bitIndex552) )
            & ( v4929_17__array(VarNext,A,bitIndex23)
            <=> v7433(VarNext,bitIndex551) )
            & ( v4929_17__array(VarNext,A,bitIndex22)
            <=> v7433(VarNext,bitIndex550) )
            & ( v4929_17__array(VarNext,A,bitIndex21)
            <=> v7433(VarNext,bitIndex549) )
            & ( v4929_17__array(VarNext,A,bitIndex20)
            <=> v7433(VarNext,bitIndex548) )
            & ( v4929_17__array(VarNext,A,bitIndex19)
            <=> v7433(VarNext,bitIndex547) )
            & ( v4929_17__array(VarNext,A,bitIndex18)
            <=> v7433(VarNext,bitIndex546) )
            & ( v4929_17__array(VarNext,A,bitIndex17)
            <=> v7433(VarNext,bitIndex545) )
            & ( v4929_17__array(VarNext,A,bitIndex16)
            <=> v7433(VarNext,bitIndex544) )
            & ( v4929_17__array(VarNext,A,bitIndex15)
            <=> v7433(VarNext,bitIndex543) )
            & ( v4929_17__array(VarNext,A,bitIndex14)
            <=> v7433(VarNext,bitIndex542) )
            & ( v4929_17__array(VarNext,A,bitIndex13)
            <=> v7433(VarNext,bitIndex541) )
            & ( v4929_17__array(VarNext,A,bitIndex12)
            <=> v7433(VarNext,bitIndex540) )
            & ( v4929_17__array(VarNext,A,bitIndex11)
            <=> v7433(VarNext,bitIndex539) )
            & ( v4929_17__array(VarNext,A,bitIndex10)
            <=> v7433(VarNext,bitIndex538) )
            & ( v4929_17__array(VarNext,A,bitIndex9)
            <=> v7433(VarNext,bitIndex537) )
            & ( v4929_17__array(VarNext,A,bitIndex8)
            <=> v7433(VarNext,bitIndex536) )
            & ( v4929_17__array(VarNext,A,bitIndex7)
            <=> v7433(VarNext,bitIndex535) )
            & ( v4929_17__array(VarNext,A,bitIndex6)
            <=> v7433(VarNext,bitIndex534) )
            & ( v4929_17__array(VarNext,A,bitIndex5)
            <=> v7433(VarNext,bitIndex533) )
            & ( v4929_17__array(VarNext,A,bitIndex4)
            <=> v7433(VarNext,bitIndex532) )
            & ( v4929_17__array(VarNext,A,bitIndex3)
            <=> v7433(VarNext,bitIndex531) )
            & ( v4929_17__array(VarNext,A,bitIndex2)
            <=> v7433(VarNext,bitIndex530) )
            & ( v4929_17__array(VarNext,A,bitIndex1)
            <=> v7433(VarNext,bitIndex529) )
            & ( v4929_17__array(VarNext,A,bitIndex0)
            <=> v7433(VarNext,bitIndex528) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1335,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7427(VarNext)
      <=> ( v7428(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1334,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7428(VarNext)
      <=> ( v7430(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_628,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7430(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_35,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01011_address_term = A
              & v7418(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_16__array(VarNext,A,B)
              <=> v4929_15__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_35,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01011_address_term = A
            & v7418(VarNext) )
         => ( ( v4929_16__array(VarNext,A,bitIndex43)
            <=> v7424(VarNext,bitIndex527) )
            & ( v4929_16__array(VarNext,A,bitIndex42)
            <=> v7424(VarNext,bitIndex526) )
            & ( v4929_16__array(VarNext,A,bitIndex41)
            <=> v7424(VarNext,bitIndex525) )
            & ( v4929_16__array(VarNext,A,bitIndex40)
            <=> v7424(VarNext,bitIndex524) )
            & ( v4929_16__array(VarNext,A,bitIndex39)
            <=> v7424(VarNext,bitIndex523) )
            & ( v4929_16__array(VarNext,A,bitIndex38)
            <=> v7424(VarNext,bitIndex522) )
            & ( v4929_16__array(VarNext,A,bitIndex37)
            <=> v7424(VarNext,bitIndex521) )
            & ( v4929_16__array(VarNext,A,bitIndex36)
            <=> v7424(VarNext,bitIndex520) )
            & ( v4929_16__array(VarNext,A,bitIndex35)
            <=> v7424(VarNext,bitIndex519) )
            & ( v4929_16__array(VarNext,A,bitIndex34)
            <=> v7424(VarNext,bitIndex518) )
            & ( v4929_16__array(VarNext,A,bitIndex33)
            <=> v7424(VarNext,bitIndex517) )
            & ( v4929_16__array(VarNext,A,bitIndex32)
            <=> v7424(VarNext,bitIndex516) )
            & ( v4929_16__array(VarNext,A,bitIndex31)
            <=> v7424(VarNext,bitIndex515) )
            & ( v4929_16__array(VarNext,A,bitIndex30)
            <=> v7424(VarNext,bitIndex514) )
            & ( v4929_16__array(VarNext,A,bitIndex29)
            <=> v7424(VarNext,bitIndex513) )
            & ( v4929_16__array(VarNext,A,bitIndex28)
            <=> v7424(VarNext,bitIndex512) )
            & ( v4929_16__array(VarNext,A,bitIndex27)
            <=> v7424(VarNext,bitIndex511) )
            & ( v4929_16__array(VarNext,A,bitIndex26)
            <=> v7424(VarNext,bitIndex510) )
            & ( v4929_16__array(VarNext,A,bitIndex25)
            <=> v7424(VarNext,bitIndex509) )
            & ( v4929_16__array(VarNext,A,bitIndex24)
            <=> v7424(VarNext,bitIndex508) )
            & ( v4929_16__array(VarNext,A,bitIndex23)
            <=> v7424(VarNext,bitIndex507) )
            & ( v4929_16__array(VarNext,A,bitIndex22)
            <=> v7424(VarNext,bitIndex506) )
            & ( v4929_16__array(VarNext,A,bitIndex21)
            <=> v7424(VarNext,bitIndex505) )
            & ( v4929_16__array(VarNext,A,bitIndex20)
            <=> v7424(VarNext,bitIndex504) )
            & ( v4929_16__array(VarNext,A,bitIndex19)
            <=> v7424(VarNext,bitIndex503) )
            & ( v4929_16__array(VarNext,A,bitIndex18)
            <=> v7424(VarNext,bitIndex502) )
            & ( v4929_16__array(VarNext,A,bitIndex17)
            <=> v7424(VarNext,bitIndex501) )
            & ( v4929_16__array(VarNext,A,bitIndex16)
            <=> v7424(VarNext,bitIndex500) )
            & ( v4929_16__array(VarNext,A,bitIndex15)
            <=> v7424(VarNext,bitIndex499) )
            & ( v4929_16__array(VarNext,A,bitIndex14)
            <=> v7424(VarNext,bitIndex498) )
            & ( v4929_16__array(VarNext,A,bitIndex13)
            <=> v7424(VarNext,bitIndex497) )
            & ( v4929_16__array(VarNext,A,bitIndex12)
            <=> v7424(VarNext,bitIndex496) )
            & ( v4929_16__array(VarNext,A,bitIndex11)
            <=> v7424(VarNext,bitIndex495) )
            & ( v4929_16__array(VarNext,A,bitIndex10)
            <=> v7424(VarNext,bitIndex494) )
            & ( v4929_16__array(VarNext,A,bitIndex9)
            <=> v7424(VarNext,bitIndex493) )
            & ( v4929_16__array(VarNext,A,bitIndex8)
            <=> v7424(VarNext,bitIndex492) )
            & ( v4929_16__array(VarNext,A,bitIndex7)
            <=> v7424(VarNext,bitIndex491) )
            & ( v4929_16__array(VarNext,A,bitIndex6)
            <=> v7424(VarNext,bitIndex490) )
            & ( v4929_16__array(VarNext,A,bitIndex5)
            <=> v7424(VarNext,bitIndex489) )
            & ( v4929_16__array(VarNext,A,bitIndex4)
            <=> v7424(VarNext,bitIndex488) )
            & ( v4929_16__array(VarNext,A,bitIndex3)
            <=> v7424(VarNext,bitIndex487) )
            & ( v4929_16__array(VarNext,A,bitIndex2)
            <=> v7424(VarNext,bitIndex486) )
            & ( v4929_16__array(VarNext,A,bitIndex1)
            <=> v7424(VarNext,bitIndex485) )
            & ( v4929_16__array(VarNext,A,bitIndex0)
            <=> v7424(VarNext,bitIndex484) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1333,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7418(VarNext)
      <=> ( v7419(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1332,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7419(VarNext)
      <=> ( v7421(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_627,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7421(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_34,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01010_address_term = A
              & v7409(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_15__array(VarNext,A,B)
              <=> v4929_14__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_34,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01010_address_term = A
            & v7409(VarNext) )
         => ( ( v4929_15__array(VarNext,A,bitIndex43)
            <=> v7415(VarNext,bitIndex483) )
            & ( v4929_15__array(VarNext,A,bitIndex42)
            <=> v7415(VarNext,bitIndex482) )
            & ( v4929_15__array(VarNext,A,bitIndex41)
            <=> v7415(VarNext,bitIndex481) )
            & ( v4929_15__array(VarNext,A,bitIndex40)
            <=> v7415(VarNext,bitIndex480) )
            & ( v4929_15__array(VarNext,A,bitIndex39)
            <=> v7415(VarNext,bitIndex479) )
            & ( v4929_15__array(VarNext,A,bitIndex38)
            <=> v7415(VarNext,bitIndex478) )
            & ( v4929_15__array(VarNext,A,bitIndex37)
            <=> v7415(VarNext,bitIndex477) )
            & ( v4929_15__array(VarNext,A,bitIndex36)
            <=> v7415(VarNext,bitIndex476) )
            & ( v4929_15__array(VarNext,A,bitIndex35)
            <=> v7415(VarNext,bitIndex475) )
            & ( v4929_15__array(VarNext,A,bitIndex34)
            <=> v7415(VarNext,bitIndex474) )
            & ( v4929_15__array(VarNext,A,bitIndex33)
            <=> v7415(VarNext,bitIndex473) )
            & ( v4929_15__array(VarNext,A,bitIndex32)
            <=> v7415(VarNext,bitIndex472) )
            & ( v4929_15__array(VarNext,A,bitIndex31)
            <=> v7415(VarNext,bitIndex471) )
            & ( v4929_15__array(VarNext,A,bitIndex30)
            <=> v7415(VarNext,bitIndex470) )
            & ( v4929_15__array(VarNext,A,bitIndex29)
            <=> v7415(VarNext,bitIndex469) )
            & ( v4929_15__array(VarNext,A,bitIndex28)
            <=> v7415(VarNext,bitIndex468) )
            & ( v4929_15__array(VarNext,A,bitIndex27)
            <=> v7415(VarNext,bitIndex467) )
            & ( v4929_15__array(VarNext,A,bitIndex26)
            <=> v7415(VarNext,bitIndex466) )
            & ( v4929_15__array(VarNext,A,bitIndex25)
            <=> v7415(VarNext,bitIndex465) )
            & ( v4929_15__array(VarNext,A,bitIndex24)
            <=> v7415(VarNext,bitIndex464) )
            & ( v4929_15__array(VarNext,A,bitIndex23)
            <=> v7415(VarNext,bitIndex463) )
            & ( v4929_15__array(VarNext,A,bitIndex22)
            <=> v7415(VarNext,bitIndex462) )
            & ( v4929_15__array(VarNext,A,bitIndex21)
            <=> v7415(VarNext,bitIndex461) )
            & ( v4929_15__array(VarNext,A,bitIndex20)
            <=> v7415(VarNext,bitIndex460) )
            & ( v4929_15__array(VarNext,A,bitIndex19)
            <=> v7415(VarNext,bitIndex459) )
            & ( v4929_15__array(VarNext,A,bitIndex18)
            <=> v7415(VarNext,bitIndex458) )
            & ( v4929_15__array(VarNext,A,bitIndex17)
            <=> v7415(VarNext,bitIndex457) )
            & ( v4929_15__array(VarNext,A,bitIndex16)
            <=> v7415(VarNext,bitIndex456) )
            & ( v4929_15__array(VarNext,A,bitIndex15)
            <=> v7415(VarNext,bitIndex455) )
            & ( v4929_15__array(VarNext,A,bitIndex14)
            <=> v7415(VarNext,bitIndex454) )
            & ( v4929_15__array(VarNext,A,bitIndex13)
            <=> v7415(VarNext,bitIndex453) )
            & ( v4929_15__array(VarNext,A,bitIndex12)
            <=> v7415(VarNext,bitIndex452) )
            & ( v4929_15__array(VarNext,A,bitIndex11)
            <=> v7415(VarNext,bitIndex451) )
            & ( v4929_15__array(VarNext,A,bitIndex10)
            <=> v7415(VarNext,bitIndex450) )
            & ( v4929_15__array(VarNext,A,bitIndex9)
            <=> v7415(VarNext,bitIndex449) )
            & ( v4929_15__array(VarNext,A,bitIndex8)
            <=> v7415(VarNext,bitIndex448) )
            & ( v4929_15__array(VarNext,A,bitIndex7)
            <=> v7415(VarNext,bitIndex447) )
            & ( v4929_15__array(VarNext,A,bitIndex6)
            <=> v7415(VarNext,bitIndex446) )
            & ( v4929_15__array(VarNext,A,bitIndex5)
            <=> v7415(VarNext,bitIndex445) )
            & ( v4929_15__array(VarNext,A,bitIndex4)
            <=> v7415(VarNext,bitIndex444) )
            & ( v4929_15__array(VarNext,A,bitIndex3)
            <=> v7415(VarNext,bitIndex443) )
            & ( v4929_15__array(VarNext,A,bitIndex2)
            <=> v7415(VarNext,bitIndex442) )
            & ( v4929_15__array(VarNext,A,bitIndex1)
            <=> v7415(VarNext,bitIndex441) )
            & ( v4929_15__array(VarNext,A,bitIndex0)
            <=> v7415(VarNext,bitIndex440) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1331,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7409(VarNext)
      <=> ( v7410(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1330,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7410(VarNext)
      <=> ( v7412(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_626,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7412(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_33,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01001_address_term = A
              & v7400(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_14__array(VarNext,A,B)
              <=> v4929_13__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_33,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01001_address_term = A
            & v7400(VarNext) )
         => ( ( v4929_14__array(VarNext,A,bitIndex43)
            <=> v7406(VarNext,bitIndex439) )
            & ( v4929_14__array(VarNext,A,bitIndex42)
            <=> v7406(VarNext,bitIndex438) )
            & ( v4929_14__array(VarNext,A,bitIndex41)
            <=> v7406(VarNext,bitIndex437) )
            & ( v4929_14__array(VarNext,A,bitIndex40)
            <=> v7406(VarNext,bitIndex436) )
            & ( v4929_14__array(VarNext,A,bitIndex39)
            <=> v7406(VarNext,bitIndex435) )
            & ( v4929_14__array(VarNext,A,bitIndex38)
            <=> v7406(VarNext,bitIndex434) )
            & ( v4929_14__array(VarNext,A,bitIndex37)
            <=> v7406(VarNext,bitIndex433) )
            & ( v4929_14__array(VarNext,A,bitIndex36)
            <=> v7406(VarNext,bitIndex432) )
            & ( v4929_14__array(VarNext,A,bitIndex35)
            <=> v7406(VarNext,bitIndex431) )
            & ( v4929_14__array(VarNext,A,bitIndex34)
            <=> v7406(VarNext,bitIndex430) )
            & ( v4929_14__array(VarNext,A,bitIndex33)
            <=> v7406(VarNext,bitIndex429) )
            & ( v4929_14__array(VarNext,A,bitIndex32)
            <=> v7406(VarNext,bitIndex428) )
            & ( v4929_14__array(VarNext,A,bitIndex31)
            <=> v7406(VarNext,bitIndex427) )
            & ( v4929_14__array(VarNext,A,bitIndex30)
            <=> v7406(VarNext,bitIndex426) )
            & ( v4929_14__array(VarNext,A,bitIndex29)
            <=> v7406(VarNext,bitIndex425) )
            & ( v4929_14__array(VarNext,A,bitIndex28)
            <=> v7406(VarNext,bitIndex424) )
            & ( v4929_14__array(VarNext,A,bitIndex27)
            <=> v7406(VarNext,bitIndex423) )
            & ( v4929_14__array(VarNext,A,bitIndex26)
            <=> v7406(VarNext,bitIndex422) )
            & ( v4929_14__array(VarNext,A,bitIndex25)
            <=> v7406(VarNext,bitIndex421) )
            & ( v4929_14__array(VarNext,A,bitIndex24)
            <=> v7406(VarNext,bitIndex420) )
            & ( v4929_14__array(VarNext,A,bitIndex23)
            <=> v7406(VarNext,bitIndex419) )
            & ( v4929_14__array(VarNext,A,bitIndex22)
            <=> v7406(VarNext,bitIndex418) )
            & ( v4929_14__array(VarNext,A,bitIndex21)
            <=> v7406(VarNext,bitIndex417) )
            & ( v4929_14__array(VarNext,A,bitIndex20)
            <=> v7406(VarNext,bitIndex416) )
            & ( v4929_14__array(VarNext,A,bitIndex19)
            <=> v7406(VarNext,bitIndex415) )
            & ( v4929_14__array(VarNext,A,bitIndex18)
            <=> v7406(VarNext,bitIndex414) )
            & ( v4929_14__array(VarNext,A,bitIndex17)
            <=> v7406(VarNext,bitIndex413) )
            & ( v4929_14__array(VarNext,A,bitIndex16)
            <=> v7406(VarNext,bitIndex412) )
            & ( v4929_14__array(VarNext,A,bitIndex15)
            <=> v7406(VarNext,bitIndex411) )
            & ( v4929_14__array(VarNext,A,bitIndex14)
            <=> v7406(VarNext,bitIndex410) )
            & ( v4929_14__array(VarNext,A,bitIndex13)
            <=> v7406(VarNext,bitIndex409) )
            & ( v4929_14__array(VarNext,A,bitIndex12)
            <=> v7406(VarNext,bitIndex408) )
            & ( v4929_14__array(VarNext,A,bitIndex11)
            <=> v7406(VarNext,bitIndex407) )
            & ( v4929_14__array(VarNext,A,bitIndex10)
            <=> v7406(VarNext,bitIndex406) )
            & ( v4929_14__array(VarNext,A,bitIndex9)
            <=> v7406(VarNext,bitIndex405) )
            & ( v4929_14__array(VarNext,A,bitIndex8)
            <=> v7406(VarNext,bitIndex404) )
            & ( v4929_14__array(VarNext,A,bitIndex7)
            <=> v7406(VarNext,bitIndex403) )
            & ( v4929_14__array(VarNext,A,bitIndex6)
            <=> v7406(VarNext,bitIndex402) )
            & ( v4929_14__array(VarNext,A,bitIndex5)
            <=> v7406(VarNext,bitIndex401) )
            & ( v4929_14__array(VarNext,A,bitIndex4)
            <=> v7406(VarNext,bitIndex400) )
            & ( v4929_14__array(VarNext,A,bitIndex3)
            <=> v7406(VarNext,bitIndex399) )
            & ( v4929_14__array(VarNext,A,bitIndex2)
            <=> v7406(VarNext,bitIndex398) )
            & ( v4929_14__array(VarNext,A,bitIndex1)
            <=> v7406(VarNext,bitIndex397) )
            & ( v4929_14__array(VarNext,A,bitIndex0)
            <=> v7406(VarNext,bitIndex396) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1329,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7400(VarNext)
      <=> ( v7401(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1328,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7401(VarNext)
      <=> ( v7403(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_625,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7403(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_32,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01000_address_term = A
              & v7391(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_13__array(VarNext,A,B)
              <=> v4929_12__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_32,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01000_address_term = A
            & v7391(VarNext) )
         => ( ( v4929_13__array(VarNext,A,bitIndex43)
            <=> v7397(VarNext,bitIndex395) )
            & ( v4929_13__array(VarNext,A,bitIndex42)
            <=> v7397(VarNext,bitIndex394) )
            & ( v4929_13__array(VarNext,A,bitIndex41)
            <=> v7397(VarNext,bitIndex393) )
            & ( v4929_13__array(VarNext,A,bitIndex40)
            <=> v7397(VarNext,bitIndex392) )
            & ( v4929_13__array(VarNext,A,bitIndex39)
            <=> v7397(VarNext,bitIndex391) )
            & ( v4929_13__array(VarNext,A,bitIndex38)
            <=> v7397(VarNext,bitIndex390) )
            & ( v4929_13__array(VarNext,A,bitIndex37)
            <=> v7397(VarNext,bitIndex389) )
            & ( v4929_13__array(VarNext,A,bitIndex36)
            <=> v7397(VarNext,bitIndex388) )
            & ( v4929_13__array(VarNext,A,bitIndex35)
            <=> v7397(VarNext,bitIndex387) )
            & ( v4929_13__array(VarNext,A,bitIndex34)
            <=> v7397(VarNext,bitIndex386) )
            & ( v4929_13__array(VarNext,A,bitIndex33)
            <=> v7397(VarNext,bitIndex385) )
            & ( v4929_13__array(VarNext,A,bitIndex32)
            <=> v7397(VarNext,bitIndex384) )
            & ( v4929_13__array(VarNext,A,bitIndex31)
            <=> v7397(VarNext,bitIndex383) )
            & ( v4929_13__array(VarNext,A,bitIndex30)
            <=> v7397(VarNext,bitIndex382) )
            & ( v4929_13__array(VarNext,A,bitIndex29)
            <=> v7397(VarNext,bitIndex381) )
            & ( v4929_13__array(VarNext,A,bitIndex28)
            <=> v7397(VarNext,bitIndex380) )
            & ( v4929_13__array(VarNext,A,bitIndex27)
            <=> v7397(VarNext,bitIndex379) )
            & ( v4929_13__array(VarNext,A,bitIndex26)
            <=> v7397(VarNext,bitIndex378) )
            & ( v4929_13__array(VarNext,A,bitIndex25)
            <=> v7397(VarNext,bitIndex377) )
            & ( v4929_13__array(VarNext,A,bitIndex24)
            <=> v7397(VarNext,bitIndex376) )
            & ( v4929_13__array(VarNext,A,bitIndex23)
            <=> v7397(VarNext,bitIndex375) )
            & ( v4929_13__array(VarNext,A,bitIndex22)
            <=> v7397(VarNext,bitIndex374) )
            & ( v4929_13__array(VarNext,A,bitIndex21)
            <=> v7397(VarNext,bitIndex373) )
            & ( v4929_13__array(VarNext,A,bitIndex20)
            <=> v7397(VarNext,bitIndex372) )
            & ( v4929_13__array(VarNext,A,bitIndex19)
            <=> v7397(VarNext,bitIndex371) )
            & ( v4929_13__array(VarNext,A,bitIndex18)
            <=> v7397(VarNext,bitIndex370) )
            & ( v4929_13__array(VarNext,A,bitIndex17)
            <=> v7397(VarNext,bitIndex369) )
            & ( v4929_13__array(VarNext,A,bitIndex16)
            <=> v7397(VarNext,bitIndex368) )
            & ( v4929_13__array(VarNext,A,bitIndex15)
            <=> v7397(VarNext,bitIndex367) )
            & ( v4929_13__array(VarNext,A,bitIndex14)
            <=> v7397(VarNext,bitIndex366) )
            & ( v4929_13__array(VarNext,A,bitIndex13)
            <=> v7397(VarNext,bitIndex365) )
            & ( v4929_13__array(VarNext,A,bitIndex12)
            <=> v7397(VarNext,bitIndex364) )
            & ( v4929_13__array(VarNext,A,bitIndex11)
            <=> v7397(VarNext,bitIndex363) )
            & ( v4929_13__array(VarNext,A,bitIndex10)
            <=> v7397(VarNext,bitIndex362) )
            & ( v4929_13__array(VarNext,A,bitIndex9)
            <=> v7397(VarNext,bitIndex361) )
            & ( v4929_13__array(VarNext,A,bitIndex8)
            <=> v7397(VarNext,bitIndex360) )
            & ( v4929_13__array(VarNext,A,bitIndex7)
            <=> v7397(VarNext,bitIndex359) )
            & ( v4929_13__array(VarNext,A,bitIndex6)
            <=> v7397(VarNext,bitIndex358) )
            & ( v4929_13__array(VarNext,A,bitIndex5)
            <=> v7397(VarNext,bitIndex357) )
            & ( v4929_13__array(VarNext,A,bitIndex4)
            <=> v7397(VarNext,bitIndex356) )
            & ( v4929_13__array(VarNext,A,bitIndex3)
            <=> v7397(VarNext,bitIndex355) )
            & ( v4929_13__array(VarNext,A,bitIndex2)
            <=> v7397(VarNext,bitIndex354) )
            & ( v4929_13__array(VarNext,A,bitIndex1)
            <=> v7397(VarNext,bitIndex353) )
            & ( v4929_13__array(VarNext,A,bitIndex0)
            <=> v7397(VarNext,bitIndex352) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1327,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7391(VarNext)
      <=> ( v7392(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1326,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7392(VarNext)
      <=> ( v7394(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_624,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7394(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_31,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00111_address_term = A
              & v7382(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_12__array(VarNext,A,B)
              <=> v4929_11__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_31,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00111_address_term = A
            & v7382(VarNext) )
         => ( ( v4929_12__array(VarNext,A,bitIndex43)
            <=> v7388(VarNext,bitIndex351) )
            & ( v4929_12__array(VarNext,A,bitIndex42)
            <=> v7388(VarNext,bitIndex350) )
            & ( v4929_12__array(VarNext,A,bitIndex41)
            <=> v7388(VarNext,bitIndex349) )
            & ( v4929_12__array(VarNext,A,bitIndex40)
            <=> v7388(VarNext,bitIndex348) )
            & ( v4929_12__array(VarNext,A,bitIndex39)
            <=> v7388(VarNext,bitIndex347) )
            & ( v4929_12__array(VarNext,A,bitIndex38)
            <=> v7388(VarNext,bitIndex346) )
            & ( v4929_12__array(VarNext,A,bitIndex37)
            <=> v7388(VarNext,bitIndex345) )
            & ( v4929_12__array(VarNext,A,bitIndex36)
            <=> v7388(VarNext,bitIndex344) )
            & ( v4929_12__array(VarNext,A,bitIndex35)
            <=> v7388(VarNext,bitIndex343) )
            & ( v4929_12__array(VarNext,A,bitIndex34)
            <=> v7388(VarNext,bitIndex342) )
            & ( v4929_12__array(VarNext,A,bitIndex33)
            <=> v7388(VarNext,bitIndex341) )
            & ( v4929_12__array(VarNext,A,bitIndex32)
            <=> v7388(VarNext,bitIndex340) )
            & ( v4929_12__array(VarNext,A,bitIndex31)
            <=> v7388(VarNext,bitIndex339) )
            & ( v4929_12__array(VarNext,A,bitIndex30)
            <=> v7388(VarNext,bitIndex338) )
            & ( v4929_12__array(VarNext,A,bitIndex29)
            <=> v7388(VarNext,bitIndex337) )
            & ( v4929_12__array(VarNext,A,bitIndex28)
            <=> v7388(VarNext,bitIndex336) )
            & ( v4929_12__array(VarNext,A,bitIndex27)
            <=> v7388(VarNext,bitIndex335) )
            & ( v4929_12__array(VarNext,A,bitIndex26)
            <=> v7388(VarNext,bitIndex334) )
            & ( v4929_12__array(VarNext,A,bitIndex25)
            <=> v7388(VarNext,bitIndex333) )
            & ( v4929_12__array(VarNext,A,bitIndex24)
            <=> v7388(VarNext,bitIndex332) )
            & ( v4929_12__array(VarNext,A,bitIndex23)
            <=> v7388(VarNext,bitIndex331) )
            & ( v4929_12__array(VarNext,A,bitIndex22)
            <=> v7388(VarNext,bitIndex330) )
            & ( v4929_12__array(VarNext,A,bitIndex21)
            <=> v7388(VarNext,bitIndex329) )
            & ( v4929_12__array(VarNext,A,bitIndex20)
            <=> v7388(VarNext,bitIndex328) )
            & ( v4929_12__array(VarNext,A,bitIndex19)
            <=> v7388(VarNext,bitIndex327) )
            & ( v4929_12__array(VarNext,A,bitIndex18)
            <=> v7388(VarNext,bitIndex326) )
            & ( v4929_12__array(VarNext,A,bitIndex17)
            <=> v7388(VarNext,bitIndex325) )
            & ( v4929_12__array(VarNext,A,bitIndex16)
            <=> v7388(VarNext,bitIndex324) )
            & ( v4929_12__array(VarNext,A,bitIndex15)
            <=> v7388(VarNext,bitIndex323) )
            & ( v4929_12__array(VarNext,A,bitIndex14)
            <=> v7388(VarNext,bitIndex322) )
            & ( v4929_12__array(VarNext,A,bitIndex13)
            <=> v7388(VarNext,bitIndex321) )
            & ( v4929_12__array(VarNext,A,bitIndex12)
            <=> v7388(VarNext,bitIndex320) )
            & ( v4929_12__array(VarNext,A,bitIndex11)
            <=> v7388(VarNext,bitIndex319) )
            & ( v4929_12__array(VarNext,A,bitIndex10)
            <=> v7388(VarNext,bitIndex318) )
            & ( v4929_12__array(VarNext,A,bitIndex9)
            <=> v7388(VarNext,bitIndex317) )
            & ( v4929_12__array(VarNext,A,bitIndex8)
            <=> v7388(VarNext,bitIndex316) )
            & ( v4929_12__array(VarNext,A,bitIndex7)
            <=> v7388(VarNext,bitIndex315) )
            & ( v4929_12__array(VarNext,A,bitIndex6)
            <=> v7388(VarNext,bitIndex314) )
            & ( v4929_12__array(VarNext,A,bitIndex5)
            <=> v7388(VarNext,bitIndex313) )
            & ( v4929_12__array(VarNext,A,bitIndex4)
            <=> v7388(VarNext,bitIndex312) )
            & ( v4929_12__array(VarNext,A,bitIndex3)
            <=> v7388(VarNext,bitIndex311) )
            & ( v4929_12__array(VarNext,A,bitIndex2)
            <=> v7388(VarNext,bitIndex310) )
            & ( v4929_12__array(VarNext,A,bitIndex1)
            <=> v7388(VarNext,bitIndex309) )
            & ( v4929_12__array(VarNext,A,bitIndex0)
            <=> v7388(VarNext,bitIndex308) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1325,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7382(VarNext)
      <=> ( v7383(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1324,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7383(VarNext)
      <=> ( v7385(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_623,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7385(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_30,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00110_address_term = A
              & v7373(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_11__array(VarNext,A,B)
              <=> v4929_10__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_30,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00110_address_term = A
            & v7373(VarNext) )
         => ( ( v4929_11__array(VarNext,A,bitIndex43)
            <=> v7379(VarNext,bitIndex307) )
            & ( v4929_11__array(VarNext,A,bitIndex42)
            <=> v7379(VarNext,bitIndex306) )
            & ( v4929_11__array(VarNext,A,bitIndex41)
            <=> v7379(VarNext,bitIndex305) )
            & ( v4929_11__array(VarNext,A,bitIndex40)
            <=> v7379(VarNext,bitIndex304) )
            & ( v4929_11__array(VarNext,A,bitIndex39)
            <=> v7379(VarNext,bitIndex303) )
            & ( v4929_11__array(VarNext,A,bitIndex38)
            <=> v7379(VarNext,bitIndex302) )
            & ( v4929_11__array(VarNext,A,bitIndex37)
            <=> v7379(VarNext,bitIndex301) )
            & ( v4929_11__array(VarNext,A,bitIndex36)
            <=> v7379(VarNext,bitIndex300) )
            & ( v4929_11__array(VarNext,A,bitIndex35)
            <=> v7379(VarNext,bitIndex299) )
            & ( v4929_11__array(VarNext,A,bitIndex34)
            <=> v7379(VarNext,bitIndex298) )
            & ( v4929_11__array(VarNext,A,bitIndex33)
            <=> v7379(VarNext,bitIndex297) )
            & ( v4929_11__array(VarNext,A,bitIndex32)
            <=> v7379(VarNext,bitIndex296) )
            & ( v4929_11__array(VarNext,A,bitIndex31)
            <=> v7379(VarNext,bitIndex295) )
            & ( v4929_11__array(VarNext,A,bitIndex30)
            <=> v7379(VarNext,bitIndex294) )
            & ( v4929_11__array(VarNext,A,bitIndex29)
            <=> v7379(VarNext,bitIndex293) )
            & ( v4929_11__array(VarNext,A,bitIndex28)
            <=> v7379(VarNext,bitIndex292) )
            & ( v4929_11__array(VarNext,A,bitIndex27)
            <=> v7379(VarNext,bitIndex291) )
            & ( v4929_11__array(VarNext,A,bitIndex26)
            <=> v7379(VarNext,bitIndex290) )
            & ( v4929_11__array(VarNext,A,bitIndex25)
            <=> v7379(VarNext,bitIndex289) )
            & ( v4929_11__array(VarNext,A,bitIndex24)
            <=> v7379(VarNext,bitIndex288) )
            & ( v4929_11__array(VarNext,A,bitIndex23)
            <=> v7379(VarNext,bitIndex287) )
            & ( v4929_11__array(VarNext,A,bitIndex22)
            <=> v7379(VarNext,bitIndex286) )
            & ( v4929_11__array(VarNext,A,bitIndex21)
            <=> v7379(VarNext,bitIndex285) )
            & ( v4929_11__array(VarNext,A,bitIndex20)
            <=> v7379(VarNext,bitIndex284) )
            & ( v4929_11__array(VarNext,A,bitIndex19)
            <=> v7379(VarNext,bitIndex283) )
            & ( v4929_11__array(VarNext,A,bitIndex18)
            <=> v7379(VarNext,bitIndex282) )
            & ( v4929_11__array(VarNext,A,bitIndex17)
            <=> v7379(VarNext,bitIndex281) )
            & ( v4929_11__array(VarNext,A,bitIndex16)
            <=> v7379(VarNext,bitIndex280) )
            & ( v4929_11__array(VarNext,A,bitIndex15)
            <=> v7379(VarNext,bitIndex279) )
            & ( v4929_11__array(VarNext,A,bitIndex14)
            <=> v7379(VarNext,bitIndex278) )
            & ( v4929_11__array(VarNext,A,bitIndex13)
            <=> v7379(VarNext,bitIndex277) )
            & ( v4929_11__array(VarNext,A,bitIndex12)
            <=> v7379(VarNext,bitIndex276) )
            & ( v4929_11__array(VarNext,A,bitIndex11)
            <=> v7379(VarNext,bitIndex275) )
            & ( v4929_11__array(VarNext,A,bitIndex10)
            <=> v7379(VarNext,bitIndex274) )
            & ( v4929_11__array(VarNext,A,bitIndex9)
            <=> v7379(VarNext,bitIndex273) )
            & ( v4929_11__array(VarNext,A,bitIndex8)
            <=> v7379(VarNext,bitIndex272) )
            & ( v4929_11__array(VarNext,A,bitIndex7)
            <=> v7379(VarNext,bitIndex271) )
            & ( v4929_11__array(VarNext,A,bitIndex6)
            <=> v7379(VarNext,bitIndex270) )
            & ( v4929_11__array(VarNext,A,bitIndex5)
            <=> v7379(VarNext,bitIndex269) )
            & ( v4929_11__array(VarNext,A,bitIndex4)
            <=> v7379(VarNext,bitIndex268) )
            & ( v4929_11__array(VarNext,A,bitIndex3)
            <=> v7379(VarNext,bitIndex267) )
            & ( v4929_11__array(VarNext,A,bitIndex2)
            <=> v7379(VarNext,bitIndex266) )
            & ( v4929_11__array(VarNext,A,bitIndex1)
            <=> v7379(VarNext,bitIndex265) )
            & ( v4929_11__array(VarNext,A,bitIndex0)
            <=> v7379(VarNext,bitIndex264) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1323,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7373(VarNext)
      <=> ( v7374(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1322,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7374(VarNext)
      <=> ( v7376(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_622,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7376(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_29,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00101_address_term = A
              & v7364(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_10__array(VarNext,A,B)
              <=> v4929_9__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_29,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00101_address_term = A
            & v7364(VarNext) )
         => ( ( v4929_10__array(VarNext,A,bitIndex43)
            <=> v7370(VarNext,bitIndex263) )
            & ( v4929_10__array(VarNext,A,bitIndex42)
            <=> v7370(VarNext,bitIndex262) )
            & ( v4929_10__array(VarNext,A,bitIndex41)
            <=> v7370(VarNext,bitIndex261) )
            & ( v4929_10__array(VarNext,A,bitIndex40)
            <=> v7370(VarNext,bitIndex260) )
            & ( v4929_10__array(VarNext,A,bitIndex39)
            <=> v7370(VarNext,bitIndex259) )
            & ( v4929_10__array(VarNext,A,bitIndex38)
            <=> v7370(VarNext,bitIndex258) )
            & ( v4929_10__array(VarNext,A,bitIndex37)
            <=> v7370(VarNext,bitIndex257) )
            & ( v4929_10__array(VarNext,A,bitIndex36)
            <=> v7370(VarNext,bitIndex256) )
            & ( v4929_10__array(VarNext,A,bitIndex35)
            <=> v7370(VarNext,bitIndex255) )
            & ( v4929_10__array(VarNext,A,bitIndex34)
            <=> v7370(VarNext,bitIndex254) )
            & ( v4929_10__array(VarNext,A,bitIndex33)
            <=> v7370(VarNext,bitIndex253) )
            & ( v4929_10__array(VarNext,A,bitIndex32)
            <=> v7370(VarNext,bitIndex252) )
            & ( v4929_10__array(VarNext,A,bitIndex31)
            <=> v7370(VarNext,bitIndex251) )
            & ( v4929_10__array(VarNext,A,bitIndex30)
            <=> v7370(VarNext,bitIndex250) )
            & ( v4929_10__array(VarNext,A,bitIndex29)
            <=> v7370(VarNext,bitIndex249) )
            & ( v4929_10__array(VarNext,A,bitIndex28)
            <=> v7370(VarNext,bitIndex248) )
            & ( v4929_10__array(VarNext,A,bitIndex27)
            <=> v7370(VarNext,bitIndex247) )
            & ( v4929_10__array(VarNext,A,bitIndex26)
            <=> v7370(VarNext,bitIndex246) )
            & ( v4929_10__array(VarNext,A,bitIndex25)
            <=> v7370(VarNext,bitIndex245) )
            & ( v4929_10__array(VarNext,A,bitIndex24)
            <=> v7370(VarNext,bitIndex244) )
            & ( v4929_10__array(VarNext,A,bitIndex23)
            <=> v7370(VarNext,bitIndex243) )
            & ( v4929_10__array(VarNext,A,bitIndex22)
            <=> v7370(VarNext,bitIndex242) )
            & ( v4929_10__array(VarNext,A,bitIndex21)
            <=> v7370(VarNext,bitIndex241) )
            & ( v4929_10__array(VarNext,A,bitIndex20)
            <=> v7370(VarNext,bitIndex240) )
            & ( v4929_10__array(VarNext,A,bitIndex19)
            <=> v7370(VarNext,bitIndex239) )
            & ( v4929_10__array(VarNext,A,bitIndex18)
            <=> v7370(VarNext,bitIndex238) )
            & ( v4929_10__array(VarNext,A,bitIndex17)
            <=> v7370(VarNext,bitIndex237) )
            & ( v4929_10__array(VarNext,A,bitIndex16)
            <=> v7370(VarNext,bitIndex236) )
            & ( v4929_10__array(VarNext,A,bitIndex15)
            <=> v7370(VarNext,bitIndex235) )
            & ( v4929_10__array(VarNext,A,bitIndex14)
            <=> v7370(VarNext,bitIndex234) )
            & ( v4929_10__array(VarNext,A,bitIndex13)
            <=> v7370(VarNext,bitIndex233) )
            & ( v4929_10__array(VarNext,A,bitIndex12)
            <=> v7370(VarNext,bitIndex232) )
            & ( v4929_10__array(VarNext,A,bitIndex11)
            <=> v7370(VarNext,bitIndex231) )
            & ( v4929_10__array(VarNext,A,bitIndex10)
            <=> v7370(VarNext,bitIndex230) )
            & ( v4929_10__array(VarNext,A,bitIndex9)
            <=> v7370(VarNext,bitIndex229) )
            & ( v4929_10__array(VarNext,A,bitIndex8)
            <=> v7370(VarNext,bitIndex228) )
            & ( v4929_10__array(VarNext,A,bitIndex7)
            <=> v7370(VarNext,bitIndex227) )
            & ( v4929_10__array(VarNext,A,bitIndex6)
            <=> v7370(VarNext,bitIndex226) )
            & ( v4929_10__array(VarNext,A,bitIndex5)
            <=> v7370(VarNext,bitIndex225) )
            & ( v4929_10__array(VarNext,A,bitIndex4)
            <=> v7370(VarNext,bitIndex224) )
            & ( v4929_10__array(VarNext,A,bitIndex3)
            <=> v7370(VarNext,bitIndex223) )
            & ( v4929_10__array(VarNext,A,bitIndex2)
            <=> v7370(VarNext,bitIndex222) )
            & ( v4929_10__array(VarNext,A,bitIndex1)
            <=> v7370(VarNext,bitIndex221) )
            & ( v4929_10__array(VarNext,A,bitIndex0)
            <=> v7370(VarNext,bitIndex220) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1321,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7364(VarNext)
      <=> ( v7365(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1320,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7365(VarNext)
      <=> ( v7367(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_621,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7367(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_28,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00100_address_term = A
              & v7355(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_9__array(VarNext,A,B)
              <=> v4929_8__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_28,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00100_address_term = A
            & v7355(VarNext) )
         => ( ( v4929_9__array(VarNext,A,bitIndex43)
            <=> v7361(VarNext,bitIndex219) )
            & ( v4929_9__array(VarNext,A,bitIndex42)
            <=> v7361(VarNext,bitIndex218) )
            & ( v4929_9__array(VarNext,A,bitIndex41)
            <=> v7361(VarNext,bitIndex217) )
            & ( v4929_9__array(VarNext,A,bitIndex40)
            <=> v7361(VarNext,bitIndex216) )
            & ( v4929_9__array(VarNext,A,bitIndex39)
            <=> v7361(VarNext,bitIndex215) )
            & ( v4929_9__array(VarNext,A,bitIndex38)
            <=> v7361(VarNext,bitIndex214) )
            & ( v4929_9__array(VarNext,A,bitIndex37)
            <=> v7361(VarNext,bitIndex213) )
            & ( v4929_9__array(VarNext,A,bitIndex36)
            <=> v7361(VarNext,bitIndex212) )
            & ( v4929_9__array(VarNext,A,bitIndex35)
            <=> v7361(VarNext,bitIndex211) )
            & ( v4929_9__array(VarNext,A,bitIndex34)
            <=> v7361(VarNext,bitIndex210) )
            & ( v4929_9__array(VarNext,A,bitIndex33)
            <=> v7361(VarNext,bitIndex209) )
            & ( v4929_9__array(VarNext,A,bitIndex32)
            <=> v7361(VarNext,bitIndex208) )
            & ( v4929_9__array(VarNext,A,bitIndex31)
            <=> v7361(VarNext,bitIndex207) )
            & ( v4929_9__array(VarNext,A,bitIndex30)
            <=> v7361(VarNext,bitIndex206) )
            & ( v4929_9__array(VarNext,A,bitIndex29)
            <=> v7361(VarNext,bitIndex205) )
            & ( v4929_9__array(VarNext,A,bitIndex28)
            <=> v7361(VarNext,bitIndex204) )
            & ( v4929_9__array(VarNext,A,bitIndex27)
            <=> v7361(VarNext,bitIndex203) )
            & ( v4929_9__array(VarNext,A,bitIndex26)
            <=> v7361(VarNext,bitIndex202) )
            & ( v4929_9__array(VarNext,A,bitIndex25)
            <=> v7361(VarNext,bitIndex201) )
            & ( v4929_9__array(VarNext,A,bitIndex24)
            <=> v7361(VarNext,bitIndex200) )
            & ( v4929_9__array(VarNext,A,bitIndex23)
            <=> v7361(VarNext,bitIndex199) )
            & ( v4929_9__array(VarNext,A,bitIndex22)
            <=> v7361(VarNext,bitIndex198) )
            & ( v4929_9__array(VarNext,A,bitIndex21)
            <=> v7361(VarNext,bitIndex197) )
            & ( v4929_9__array(VarNext,A,bitIndex20)
            <=> v7361(VarNext,bitIndex196) )
            & ( v4929_9__array(VarNext,A,bitIndex19)
            <=> v7361(VarNext,bitIndex195) )
            & ( v4929_9__array(VarNext,A,bitIndex18)
            <=> v7361(VarNext,bitIndex194) )
            & ( v4929_9__array(VarNext,A,bitIndex17)
            <=> v7361(VarNext,bitIndex193) )
            & ( v4929_9__array(VarNext,A,bitIndex16)
            <=> v7361(VarNext,bitIndex192) )
            & ( v4929_9__array(VarNext,A,bitIndex15)
            <=> v7361(VarNext,bitIndex191) )
            & ( v4929_9__array(VarNext,A,bitIndex14)
            <=> v7361(VarNext,bitIndex190) )
            & ( v4929_9__array(VarNext,A,bitIndex13)
            <=> v7361(VarNext,bitIndex189) )
            & ( v4929_9__array(VarNext,A,bitIndex12)
            <=> v7361(VarNext,bitIndex188) )
            & ( v4929_9__array(VarNext,A,bitIndex11)
            <=> v7361(VarNext,bitIndex187) )
            & ( v4929_9__array(VarNext,A,bitIndex10)
            <=> v7361(VarNext,bitIndex186) )
            & ( v4929_9__array(VarNext,A,bitIndex9)
            <=> v7361(VarNext,bitIndex185) )
            & ( v4929_9__array(VarNext,A,bitIndex8)
            <=> v7361(VarNext,bitIndex184) )
            & ( v4929_9__array(VarNext,A,bitIndex7)
            <=> v7361(VarNext,bitIndex183) )
            & ( v4929_9__array(VarNext,A,bitIndex6)
            <=> v7361(VarNext,bitIndex182) )
            & ( v4929_9__array(VarNext,A,bitIndex5)
            <=> v7361(VarNext,bitIndex181) )
            & ( v4929_9__array(VarNext,A,bitIndex4)
            <=> v7361(VarNext,bitIndex180) )
            & ( v4929_9__array(VarNext,A,bitIndex3)
            <=> v7361(VarNext,bitIndex179) )
            & ( v4929_9__array(VarNext,A,bitIndex2)
            <=> v7361(VarNext,bitIndex178) )
            & ( v4929_9__array(VarNext,A,bitIndex1)
            <=> v7361(VarNext,bitIndex177) )
            & ( v4929_9__array(VarNext,A,bitIndex0)
            <=> v7361(VarNext,bitIndex176) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1319,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7355(VarNext)
      <=> ( v7356(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1318,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7356(VarNext)
      <=> ( v7358(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_620,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7358(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_27,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00011_address_term = A
              & v7346(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_8__array(VarNext,A,B)
              <=> v4929_7__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_27,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00011_address_term = A
            & v7346(VarNext) )
         => ( ( v4929_8__array(VarNext,A,bitIndex43)
            <=> v7352(VarNext,bitIndex175) )
            & ( v4929_8__array(VarNext,A,bitIndex42)
            <=> v7352(VarNext,bitIndex174) )
            & ( v4929_8__array(VarNext,A,bitIndex41)
            <=> v7352(VarNext,bitIndex173) )
            & ( v4929_8__array(VarNext,A,bitIndex40)
            <=> v7352(VarNext,bitIndex172) )
            & ( v4929_8__array(VarNext,A,bitIndex39)
            <=> v7352(VarNext,bitIndex171) )
            & ( v4929_8__array(VarNext,A,bitIndex38)
            <=> v7352(VarNext,bitIndex170) )
            & ( v4929_8__array(VarNext,A,bitIndex37)
            <=> v7352(VarNext,bitIndex169) )
            & ( v4929_8__array(VarNext,A,bitIndex36)
            <=> v7352(VarNext,bitIndex168) )
            & ( v4929_8__array(VarNext,A,bitIndex35)
            <=> v7352(VarNext,bitIndex167) )
            & ( v4929_8__array(VarNext,A,bitIndex34)
            <=> v7352(VarNext,bitIndex166) )
            & ( v4929_8__array(VarNext,A,bitIndex33)
            <=> v7352(VarNext,bitIndex165) )
            & ( v4929_8__array(VarNext,A,bitIndex32)
            <=> v7352(VarNext,bitIndex164) )
            & ( v4929_8__array(VarNext,A,bitIndex31)
            <=> v7352(VarNext,bitIndex163) )
            & ( v4929_8__array(VarNext,A,bitIndex30)
            <=> v7352(VarNext,bitIndex162) )
            & ( v4929_8__array(VarNext,A,bitIndex29)
            <=> v7352(VarNext,bitIndex161) )
            & ( v4929_8__array(VarNext,A,bitIndex28)
            <=> v7352(VarNext,bitIndex160) )
            & ( v4929_8__array(VarNext,A,bitIndex27)
            <=> v7352(VarNext,bitIndex159) )
            & ( v4929_8__array(VarNext,A,bitIndex26)
            <=> v7352(VarNext,bitIndex158) )
            & ( v4929_8__array(VarNext,A,bitIndex25)
            <=> v7352(VarNext,bitIndex157) )
            & ( v4929_8__array(VarNext,A,bitIndex24)
            <=> v7352(VarNext,bitIndex156) )
            & ( v4929_8__array(VarNext,A,bitIndex23)
            <=> v7352(VarNext,bitIndex155) )
            & ( v4929_8__array(VarNext,A,bitIndex22)
            <=> v7352(VarNext,bitIndex154) )
            & ( v4929_8__array(VarNext,A,bitIndex21)
            <=> v7352(VarNext,bitIndex153) )
            & ( v4929_8__array(VarNext,A,bitIndex20)
            <=> v7352(VarNext,bitIndex152) )
            & ( v4929_8__array(VarNext,A,bitIndex19)
            <=> v7352(VarNext,bitIndex151) )
            & ( v4929_8__array(VarNext,A,bitIndex18)
            <=> v7352(VarNext,bitIndex150) )
            & ( v4929_8__array(VarNext,A,bitIndex17)
            <=> v7352(VarNext,bitIndex149) )
            & ( v4929_8__array(VarNext,A,bitIndex16)
            <=> v7352(VarNext,bitIndex148) )
            & ( v4929_8__array(VarNext,A,bitIndex15)
            <=> v7352(VarNext,bitIndex147) )
            & ( v4929_8__array(VarNext,A,bitIndex14)
            <=> v7352(VarNext,bitIndex146) )
            & ( v4929_8__array(VarNext,A,bitIndex13)
            <=> v7352(VarNext,bitIndex145) )
            & ( v4929_8__array(VarNext,A,bitIndex12)
            <=> v7352(VarNext,bitIndex144) )
            & ( v4929_8__array(VarNext,A,bitIndex11)
            <=> v7352(VarNext,bitIndex143) )
            & ( v4929_8__array(VarNext,A,bitIndex10)
            <=> v7352(VarNext,bitIndex142) )
            & ( v4929_8__array(VarNext,A,bitIndex9)
            <=> v7352(VarNext,bitIndex141) )
            & ( v4929_8__array(VarNext,A,bitIndex8)
            <=> v7352(VarNext,bitIndex140) )
            & ( v4929_8__array(VarNext,A,bitIndex7)
            <=> v7352(VarNext,bitIndex139) )
            & ( v4929_8__array(VarNext,A,bitIndex6)
            <=> v7352(VarNext,bitIndex138) )
            & ( v4929_8__array(VarNext,A,bitIndex5)
            <=> v7352(VarNext,bitIndex137) )
            & ( v4929_8__array(VarNext,A,bitIndex4)
            <=> v7352(VarNext,bitIndex136) )
            & ( v4929_8__array(VarNext,A,bitIndex3)
            <=> v7352(VarNext,bitIndex135) )
            & ( v4929_8__array(VarNext,A,bitIndex2)
            <=> v7352(VarNext,bitIndex134) )
            & ( v4929_8__array(VarNext,A,bitIndex1)
            <=> v7352(VarNext,bitIndex133) )
            & ( v4929_8__array(VarNext,A,bitIndex0)
            <=> v7352(VarNext,bitIndex132) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1317,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7346(VarNext)
      <=> ( v7347(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1316,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7347(VarNext)
      <=> ( v7349(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_619,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7349(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_26,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00010_address_term = A
              & v7337(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_7__array(VarNext,A,B)
              <=> v4929_6__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_26,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00010_address_term = A
            & v7337(VarNext) )
         => ( ( v4929_7__array(VarNext,A,bitIndex43)
            <=> v7343(VarNext,bitIndex131) )
            & ( v4929_7__array(VarNext,A,bitIndex42)
            <=> v7343(VarNext,bitIndex130) )
            & ( v4929_7__array(VarNext,A,bitIndex41)
            <=> v7343(VarNext,bitIndex129) )
            & ( v4929_7__array(VarNext,A,bitIndex40)
            <=> v7343(VarNext,bitIndex128) )
            & ( v4929_7__array(VarNext,A,bitIndex39)
            <=> v7343(VarNext,bitIndex127) )
            & ( v4929_7__array(VarNext,A,bitIndex38)
            <=> v7343(VarNext,bitIndex126) )
            & ( v4929_7__array(VarNext,A,bitIndex37)
            <=> v7343(VarNext,bitIndex125) )
            & ( v4929_7__array(VarNext,A,bitIndex36)
            <=> v7343(VarNext,bitIndex124) )
            & ( v4929_7__array(VarNext,A,bitIndex35)
            <=> v7343(VarNext,bitIndex123) )
            & ( v4929_7__array(VarNext,A,bitIndex34)
            <=> v7343(VarNext,bitIndex122) )
            & ( v4929_7__array(VarNext,A,bitIndex33)
            <=> v7343(VarNext,bitIndex121) )
            & ( v4929_7__array(VarNext,A,bitIndex32)
            <=> v7343(VarNext,bitIndex120) )
            & ( v4929_7__array(VarNext,A,bitIndex31)
            <=> v7343(VarNext,bitIndex119) )
            & ( v4929_7__array(VarNext,A,bitIndex30)
            <=> v7343(VarNext,bitIndex118) )
            & ( v4929_7__array(VarNext,A,bitIndex29)
            <=> v7343(VarNext,bitIndex117) )
            & ( v4929_7__array(VarNext,A,bitIndex28)
            <=> v7343(VarNext,bitIndex116) )
            & ( v4929_7__array(VarNext,A,bitIndex27)
            <=> v7343(VarNext,bitIndex115) )
            & ( v4929_7__array(VarNext,A,bitIndex26)
            <=> v7343(VarNext,bitIndex114) )
            & ( v4929_7__array(VarNext,A,bitIndex25)
            <=> v7343(VarNext,bitIndex113) )
            & ( v4929_7__array(VarNext,A,bitIndex24)
            <=> v7343(VarNext,bitIndex112) )
            & ( v4929_7__array(VarNext,A,bitIndex23)
            <=> v7343(VarNext,bitIndex111) )
            & ( v4929_7__array(VarNext,A,bitIndex22)
            <=> v7343(VarNext,bitIndex110) )
            & ( v4929_7__array(VarNext,A,bitIndex21)
            <=> v7343(VarNext,bitIndex109) )
            & ( v4929_7__array(VarNext,A,bitIndex20)
            <=> v7343(VarNext,bitIndex108) )
            & ( v4929_7__array(VarNext,A,bitIndex19)
            <=> v7343(VarNext,bitIndex107) )
            & ( v4929_7__array(VarNext,A,bitIndex18)
            <=> v7343(VarNext,bitIndex106) )
            & ( v4929_7__array(VarNext,A,bitIndex17)
            <=> v7343(VarNext,bitIndex105) )
            & ( v4929_7__array(VarNext,A,bitIndex16)
            <=> v7343(VarNext,bitIndex104) )
            & ( v4929_7__array(VarNext,A,bitIndex15)
            <=> v7343(VarNext,bitIndex103) )
            & ( v4929_7__array(VarNext,A,bitIndex14)
            <=> v7343(VarNext,bitIndex102) )
            & ( v4929_7__array(VarNext,A,bitIndex13)
            <=> v7343(VarNext,bitIndex101) )
            & ( v4929_7__array(VarNext,A,bitIndex12)
            <=> v7343(VarNext,bitIndex100) )
            & ( v4929_7__array(VarNext,A,bitIndex11)
            <=> v7343(VarNext,bitIndex99) )
            & ( v4929_7__array(VarNext,A,bitIndex10)
            <=> v7343(VarNext,bitIndex98) )
            & ( v4929_7__array(VarNext,A,bitIndex9)
            <=> v7343(VarNext,bitIndex97) )
            & ( v4929_7__array(VarNext,A,bitIndex8)
            <=> v7343(VarNext,bitIndex96) )
            & ( v4929_7__array(VarNext,A,bitIndex7)
            <=> v7343(VarNext,bitIndex95) )
            & ( v4929_7__array(VarNext,A,bitIndex6)
            <=> v7343(VarNext,bitIndex94) )
            & ( v4929_7__array(VarNext,A,bitIndex5)
            <=> v7343(VarNext,bitIndex93) )
            & ( v4929_7__array(VarNext,A,bitIndex4)
            <=> v7343(VarNext,bitIndex92) )
            & ( v4929_7__array(VarNext,A,bitIndex3)
            <=> v7343(VarNext,bitIndex91) )
            & ( v4929_7__array(VarNext,A,bitIndex2)
            <=> v7343(VarNext,bitIndex90) )
            & ( v4929_7__array(VarNext,A,bitIndex1)
            <=> v7343(VarNext,bitIndex89) )
            & ( v4929_7__array(VarNext,A,bitIndex0)
            <=> v7343(VarNext,bitIndex88) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1315,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7337(VarNext)
      <=> ( v7338(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1314,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7338(VarNext)
      <=> ( v7340(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_618,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7340(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_25,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00001_address_term = A
              & v7328(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_6__array(VarNext,A,B)
              <=> v4929_5__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_25,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00001_address_term = A
            & v7328(VarNext) )
         => ( ( v4929_6__array(VarNext,A,bitIndex43)
            <=> v7334(VarNext,bitIndex87) )
            & ( v4929_6__array(VarNext,A,bitIndex42)
            <=> v7334(VarNext,bitIndex86) )
            & ( v4929_6__array(VarNext,A,bitIndex41)
            <=> v7334(VarNext,bitIndex85) )
            & ( v4929_6__array(VarNext,A,bitIndex40)
            <=> v7334(VarNext,bitIndex84) )
            & ( v4929_6__array(VarNext,A,bitIndex39)
            <=> v7334(VarNext,bitIndex83) )
            & ( v4929_6__array(VarNext,A,bitIndex38)
            <=> v7334(VarNext,bitIndex82) )
            & ( v4929_6__array(VarNext,A,bitIndex37)
            <=> v7334(VarNext,bitIndex81) )
            & ( v4929_6__array(VarNext,A,bitIndex36)
            <=> v7334(VarNext,bitIndex80) )
            & ( v4929_6__array(VarNext,A,bitIndex35)
            <=> v7334(VarNext,bitIndex79) )
            & ( v4929_6__array(VarNext,A,bitIndex34)
            <=> v7334(VarNext,bitIndex78) )
            & ( v4929_6__array(VarNext,A,bitIndex33)
            <=> v7334(VarNext,bitIndex77) )
            & ( v4929_6__array(VarNext,A,bitIndex32)
            <=> v7334(VarNext,bitIndex76) )
            & ( v4929_6__array(VarNext,A,bitIndex31)
            <=> v7334(VarNext,bitIndex75) )
            & ( v4929_6__array(VarNext,A,bitIndex30)
            <=> v7334(VarNext,bitIndex74) )
            & ( v4929_6__array(VarNext,A,bitIndex29)
            <=> v7334(VarNext,bitIndex73) )
            & ( v4929_6__array(VarNext,A,bitIndex28)
            <=> v7334(VarNext,bitIndex72) )
            & ( v4929_6__array(VarNext,A,bitIndex27)
            <=> v7334(VarNext,bitIndex71) )
            & ( v4929_6__array(VarNext,A,bitIndex26)
            <=> v7334(VarNext,bitIndex70) )
            & ( v4929_6__array(VarNext,A,bitIndex25)
            <=> v7334(VarNext,bitIndex69) )
            & ( v4929_6__array(VarNext,A,bitIndex24)
            <=> v7334(VarNext,bitIndex68) )
            & ( v4929_6__array(VarNext,A,bitIndex23)
            <=> v7334(VarNext,bitIndex67) )
            & ( v4929_6__array(VarNext,A,bitIndex22)
            <=> v7334(VarNext,bitIndex66) )
            & ( v4929_6__array(VarNext,A,bitIndex21)
            <=> v7334(VarNext,bitIndex65) )
            & ( v4929_6__array(VarNext,A,bitIndex20)
            <=> v7334(VarNext,bitIndex64) )
            & ( v4929_6__array(VarNext,A,bitIndex19)
            <=> v7334(VarNext,bitIndex63) )
            & ( v4929_6__array(VarNext,A,bitIndex18)
            <=> v7334(VarNext,bitIndex62) )
            & ( v4929_6__array(VarNext,A,bitIndex17)
            <=> v7334(VarNext,bitIndex61) )
            & ( v4929_6__array(VarNext,A,bitIndex16)
            <=> v7334(VarNext,bitIndex60) )
            & ( v4929_6__array(VarNext,A,bitIndex15)
            <=> v7334(VarNext,bitIndex59) )
            & ( v4929_6__array(VarNext,A,bitIndex14)
            <=> v7334(VarNext,bitIndex58) )
            & ( v4929_6__array(VarNext,A,bitIndex13)
            <=> v7334(VarNext,bitIndex57) )
            & ( v4929_6__array(VarNext,A,bitIndex12)
            <=> v7334(VarNext,bitIndex56) )
            & ( v4929_6__array(VarNext,A,bitIndex11)
            <=> v7334(VarNext,bitIndex55) )
            & ( v4929_6__array(VarNext,A,bitIndex10)
            <=> v7334(VarNext,bitIndex54) )
            & ( v4929_6__array(VarNext,A,bitIndex9)
            <=> v7334(VarNext,bitIndex53) )
            & ( v4929_6__array(VarNext,A,bitIndex8)
            <=> v7334(VarNext,bitIndex52) )
            & ( v4929_6__array(VarNext,A,bitIndex7)
            <=> v7334(VarNext,bitIndex51) )
            & ( v4929_6__array(VarNext,A,bitIndex6)
            <=> v7334(VarNext,bitIndex50) )
            & ( v4929_6__array(VarNext,A,bitIndex5)
            <=> v7334(VarNext,bitIndex49) )
            & ( v4929_6__array(VarNext,A,bitIndex4)
            <=> v7334(VarNext,bitIndex48) )
            & ( v4929_6__array(VarNext,A,bitIndex3)
            <=> v7334(VarNext,bitIndex47) )
            & ( v4929_6__array(VarNext,A,bitIndex2)
            <=> v7334(VarNext,bitIndex46) )
            & ( v4929_6__array(VarNext,A,bitIndex1)
            <=> v7334(VarNext,bitIndex45) )
            & ( v4929_6__array(VarNext,A,bitIndex0)
            <=> v7334(VarNext,bitIndex44) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1313,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7328(VarNext)
      <=> ( v7329(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1312,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7329(VarNext)
      <=> ( v7331(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_617,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7331(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_24,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00000_address_term = A
              & v7314(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_5__array(VarNext,A,B)
              <=> v4929_4__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_24,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00000_address_term = A
            & v7314(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v4929_5__array(VarNext,A,B)
              <=> v7325(VarNext,B) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1311,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7314(VarNext)
      <=> ( v7315(VarNext)
          & v7321(VarNext) ) ) ) ).

fof(addAssignment_1784,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7321(VarNext)
      <=> v7319(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1310,axiom,
    ! [VarCurr] :
      ( v7319(VarCurr)
    <=> ( v7277(VarCurr)
        & v7322(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_481,axiom,
    ! [VarCurr] :
      ( v7322(VarCurr)
    <=> ( ( v7323(VarCurr,bitIndex1)
        <=> $false )
        & ( v7323(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1783,axiom,
    ! [VarCurr] :
      ( v7323(VarCurr,bitIndex0)
    <=> v5266(VarCurr) ) ).

fof(addAssignment_1782,axiom,
    ! [VarCurr] :
      ( v7323(VarCurr,bitIndex1)
    <=> v4940(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1309,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7315(VarNext)
      <=> ( v7317(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_616,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7317(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_23,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v6239_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ~ ( A = AssociatedAddressVar
                  & v7302(VarNext) )
             => ! [B] :
                  ( range_43_0(B)
                 => ( v4929_4__array(VarNext,A,B)
                  <=> v4929_3__array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_23,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v6239_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ( A = AssociatedAddressVar
                & v7302(VarNext) )
             => ! [B] :
                  ( range_43_0(B)
                 => ( v4929_4__array(VarNext,A,B)
                  <=> v5625(VarNext,B) ) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1308,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7302(VarNext)
      <=> ( v7303(VarNext)
          & v7309(VarNext) ) ) ) ).

fof(addAssignment_1781,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7309(VarNext)
      <=> v7307(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1307,axiom,
    ! [VarCurr] :
      ( v7307(VarCurr)
    <=> ( v7277(VarCurr)
        & v7310(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_480,axiom,
    ! [VarCurr] :
      ( v7310(VarCurr)
    <=> ( ( v7311(VarCurr,bitIndex1)
        <=> $true )
        & ( v7311(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_1780,axiom,
    ! [VarCurr] :
      ( v7311(VarCurr,bitIndex0)
    <=> v5266(VarCurr) ) ).

fof(addAssignment_1779,axiom,
    ! [VarCurr] :
      ( v7311(VarCurr,bitIndex1)
    <=> v4940(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1306,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7303(VarNext)
      <=> ( v7305(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_615,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7305(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_22,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v6279_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ~ ( A = AssociatedAddressVar
                  & v7290(VarNext) )
             => ! [B] :
                  ( range_43_0(B)
                 => ( v4929_3__array(VarNext,A,B)
                  <=> v4929_2__array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_22,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v6279_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ( A = AssociatedAddressVar
                & v7290(VarNext) )
             => ! [B] :
                  ( range_43_0(B)
                 => ( v4929_3__array(VarNext,A,B)
                  <=> v6271(VarNext,B) ) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1305,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7290(VarNext)
      <=> ( v7291(VarNext)
          & v7297(VarNext) ) ) ) ).

fof(addAssignment_1778,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7297(VarNext)
      <=> v7295(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1304,axiom,
    ! [VarCurr] :
      ( v7295(VarCurr)
    <=> ( v7277(VarCurr)
        & v7298(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_479,axiom,
    ! [VarCurr] :
      ( v7298(VarCurr)
    <=> ( ( v7299(VarCurr,bitIndex1)
        <=> $false )
        & ( v7299(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1777,axiom,
    ! [VarCurr] :
      ( v7299(VarCurr,bitIndex0)
    <=> v5266(VarCurr) ) ).

fof(addAssignment_1776,axiom,
    ! [VarCurr] :
      ( v7299(VarCurr,bitIndex1)
    <=> v4940(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1303,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7291(VarNext)
      <=> ( v7293(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_614,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7293(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_21,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v6279_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ~ ( A = AssociatedAddressVar
                  & v7283(VarNext) )
             => ! [B] :
                  ( range_43_0(B)
                 => ( v4929_2__array(VarNext,A,B)
                  <=> v4929_1__array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_21,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v6279_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ( A = AssociatedAddressVar
                & v7283(VarNext) )
             => ! [B] :
                  ( range_43_0(B)
                 => ( v4929_2__array(VarNext,A,B)
                  <=> v6271(VarNext,B) ) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1302,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7283(VarNext)
      <=> ( v7284(VarNext)
          & v7276(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1301,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7284(VarNext)
      <=> ( v7286(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_613,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7286(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(memoryWriteDisabled_20,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v6239_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ~ ( A = AssociatedAddressVar
                  & v7267(VarNext) )
             => ! [B] :
                  ( range_43_0(B)
                 => ( v4929_1__array(VarNext,A,B)
                  <=> v4929_array(VarCurr,A,B) ) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_20,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v6239_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ( A = AssociatedAddressVar
                & v7267(VarNext) )
             => ! [B] :
                  ( range_43_0(B)
                 => ( v4929_1__array(VarNext,A,B)
                  <=> v5625(VarNext,B) ) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1300,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7267(VarNext)
      <=> ( v7268(VarNext)
          & v7276(VarNext) ) ) ) ).

fof(addAssignment_1775,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7276(VarNext)
      <=> v7274(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1299,axiom,
    ! [VarCurr] :
      ( v7274(VarCurr)
    <=> ( v7277(VarCurr)
        & v7279(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_478,axiom,
    ! [VarCurr] :
      ( v7279(VarCurr)
    <=> ( ( v7280(VarCurr,bitIndex1)
        <=> $true )
        & ( v7280(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_1774,axiom,
    ! [VarCurr] :
      ( v7280(VarCurr,bitIndex0)
    <=> v5266(VarCurr) ) ).

fof(addAssignment_1773,axiom,
    ! [VarCurr] :
      ( v7280(VarCurr,bitIndex1)
    <=> v4940(VarCurr) ) ).

fof(writeUnaryOperator_612,axiom,
    ! [VarCurr] :
      ( ~ v7277(VarCurr)
    <=> v7278(VarCurr) ) ).

fof(writeUnaryOperator_611,axiom,
    ! [VarCurr] :
      ( ~ v7278(VarCurr)
    <=> v4936(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1298,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7268(VarNext)
      <=> ( v7269(VarNext)
          & v4931(VarNext) ) ) ) ).

fof(writeUnaryOperator_610,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7269(VarNext)
      <=> v7271(VarNext) ) ) ).

fof(addAssignment_1772,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7271(VarNext)
      <=> v4931(VarCurr) ) ) ).

fof(initSateConstraint_2161,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex0) ).

fof(initSateConstraint_2160,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex1) ).

fof(initSateConstraint_2159,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex2) ).

fof(initSateConstraint_2158,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex3) ).

fof(initSateConstraint_2157,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex4) ).

fof(initSateConstraint_2156,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex5) ).

fof(initSateConstraint_2155,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex6) ).

fof(initSateConstraint_2154,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex7) ).

fof(initSateConstraint_2153,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex8) ).

fof(initSateConstraint_2152,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex9) ).

fof(initSateConstraint_2151,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex10) ).

fof(initSateConstraint_2150,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex11) ).

fof(initSateConstraint_2149,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex12) ).

fof(initSateConstraint_2148,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex13) ).

fof(initSateConstraint_2147,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex14) ).

fof(initSateConstraint_2146,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex15) ).

fof(initSateConstraint_2145,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex16) ).

fof(initSateConstraint_2144,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex17) ).

fof(initSateConstraint_2143,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex18) ).

fof(initSateConstraint_2142,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex19) ).

fof(initSateConstraint_2141,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex20) ).

fof(initSateConstraint_2140,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex21) ).

fof(initSateConstraint_2139,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex22) ).

fof(initSateConstraint_2138,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex23) ).

fof(initSateConstraint_2137,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex24) ).

fof(initSateConstraint_2136,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex25) ).

fof(initSateConstraint_2135,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex26) ).

fof(initSateConstraint_2134,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex27) ).

fof(initSateConstraint_2133,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex28) ).

fof(initSateConstraint_2132,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex29) ).

fof(initSateConstraint_2131,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex30) ).

fof(initSateConstraint_2130,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex31) ).

fof(initSateConstraint_2129,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex33) ).

fof(initSateConstraint_2128,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex34) ).

fof(initSateConstraint_2127,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex35) ).

fof(initSateConstraint_2126,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex36) ).

fof(initSateConstraint_2125,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex37) ).

fof(initSateConstraint_2124,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex38) ).

fof(initSateConstraint_2123,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex39) ).

fof(initSateConstraint_2122,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex40) ).

fof(initSateConstraint_2121,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex41) ).

fof(initSateConstraint_2120,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex42) ).

fof(initSateConstraint_2119,axiom,
    ~ v4929_array(constB0,b11111_address_term,bitIndex43) ).

fof(initSateConstraint_2118,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex0) ).

fof(initSateConstraint_2117,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex1) ).

fof(initSateConstraint_2116,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex2) ).

fof(initSateConstraint_2115,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex3) ).

fof(initSateConstraint_2114,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex4) ).

fof(initSateConstraint_2113,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex5) ).

fof(initSateConstraint_2112,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex6) ).

fof(initSateConstraint_2111,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex7) ).

fof(initSateConstraint_2110,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex8) ).

fof(initSateConstraint_2109,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex9) ).

fof(initSateConstraint_2108,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex10) ).

fof(initSateConstraint_2107,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex11) ).

fof(initSateConstraint_2106,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex12) ).

fof(initSateConstraint_2105,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex13) ).

fof(initSateConstraint_2104,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex14) ).

fof(initSateConstraint_2103,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex15) ).

fof(initSateConstraint_2102,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex16) ).

fof(initSateConstraint_2101,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex17) ).

fof(initSateConstraint_2100,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex18) ).

fof(initSateConstraint_2099,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex19) ).

fof(initSateConstraint_2098,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex20) ).

fof(initSateConstraint_2097,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex21) ).

fof(initSateConstraint_2096,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex22) ).

fof(initSateConstraint_2095,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex23) ).

fof(initSateConstraint_2094,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex24) ).

fof(initSateConstraint_2093,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex25) ).

fof(initSateConstraint_2092,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex26) ).

fof(initSateConstraint_2091,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex27) ).

fof(initSateConstraint_2090,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex28) ).

fof(initSateConstraint_2089,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex29) ).

fof(initSateConstraint_2088,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex30) ).

fof(initSateConstraint_2087,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex31) ).

fof(initSateConstraint_2086,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex33) ).

fof(initSateConstraint_2085,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex34) ).

fof(initSateConstraint_2084,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex35) ).

fof(initSateConstraint_2083,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex36) ).

fof(initSateConstraint_2082,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex37) ).

fof(initSateConstraint_2081,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex38) ).

fof(initSateConstraint_2080,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex39) ).

fof(initSateConstraint_2079,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex40) ).

fof(initSateConstraint_2078,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex41) ).

fof(initSateConstraint_2077,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex42) ).

fof(initSateConstraint_2076,axiom,
    ~ v4929_array(constB0,b11110_address_term,bitIndex43) ).

fof(initSateConstraint_2075,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex0) ).

fof(initSateConstraint_2074,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex1) ).

fof(initSateConstraint_2073,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex2) ).

fof(initSateConstraint_2072,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex3) ).

fof(initSateConstraint_2071,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex4) ).

fof(initSateConstraint_2070,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex5) ).

fof(initSateConstraint_2069,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex6) ).

fof(initSateConstraint_2068,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex7) ).

fof(initSateConstraint_2067,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex8) ).

fof(initSateConstraint_2066,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex9) ).

fof(initSateConstraint_2065,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex10) ).

fof(initSateConstraint_2064,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex11) ).

fof(initSateConstraint_2063,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex12) ).

fof(initSateConstraint_2062,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex13) ).

fof(initSateConstraint_2061,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex14) ).

fof(initSateConstraint_2060,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex15) ).

fof(initSateConstraint_2059,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex16) ).

fof(initSateConstraint_2058,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex17) ).

fof(initSateConstraint_2057,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex18) ).

fof(initSateConstraint_2056,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex19) ).

fof(initSateConstraint_2055,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex20) ).

fof(initSateConstraint_2054,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex21) ).

fof(initSateConstraint_2053,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex22) ).

fof(initSateConstraint_2052,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex23) ).

fof(initSateConstraint_2051,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex24) ).

fof(initSateConstraint_2050,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex25) ).

fof(initSateConstraint_2049,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex26) ).

fof(initSateConstraint_2048,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex27) ).

fof(initSateConstraint_2047,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex28) ).

fof(initSateConstraint_2046,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex29) ).

fof(initSateConstraint_2045,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex30) ).

fof(initSateConstraint_2044,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex31) ).

fof(initSateConstraint_2043,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex33) ).

fof(initSateConstraint_2042,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex34) ).

fof(initSateConstraint_2041,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex35) ).

fof(initSateConstraint_2040,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex36) ).

fof(initSateConstraint_2039,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex37) ).

fof(initSateConstraint_2038,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex38) ).

fof(initSateConstraint_2037,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex39) ).

fof(initSateConstraint_2036,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex40) ).

fof(initSateConstraint_2035,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex41) ).

fof(initSateConstraint_2034,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex42) ).

fof(initSateConstraint_2033,axiom,
    ~ v4929_array(constB0,b11101_address_term,bitIndex43) ).

fof(initSateConstraint_2032,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex0) ).

fof(initSateConstraint_2031,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex1) ).

fof(initSateConstraint_2030,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex2) ).

fof(initSateConstraint_2029,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex3) ).

fof(initSateConstraint_2028,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex4) ).

fof(initSateConstraint_2027,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex5) ).

fof(initSateConstraint_2026,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex6) ).

fof(initSateConstraint_2025,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex7) ).

fof(initSateConstraint_2024,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex8) ).

fof(initSateConstraint_2023,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex9) ).

fof(initSateConstraint_2022,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex10) ).

fof(initSateConstraint_2021,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex11) ).

fof(initSateConstraint_2020,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex12) ).

fof(initSateConstraint_2019,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex13) ).

fof(initSateConstraint_2018,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex14) ).

fof(initSateConstraint_2017,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex15) ).

fof(initSateConstraint_2016,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex16) ).

fof(initSateConstraint_2015,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex17) ).

fof(initSateConstraint_2014,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex18) ).

fof(initSateConstraint_2013,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex19) ).

fof(initSateConstraint_2012,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex20) ).

fof(initSateConstraint_2011,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex21) ).

fof(initSateConstraint_2010,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex22) ).

fof(initSateConstraint_2009,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex23) ).

fof(initSateConstraint_2008,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex24) ).

fof(initSateConstraint_2007,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex25) ).

fof(initSateConstraint_2006,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex26) ).

fof(initSateConstraint_2005,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex27) ).

fof(initSateConstraint_2004,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex28) ).

fof(initSateConstraint_2003,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex29) ).

fof(initSateConstraint_2002,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex30) ).

fof(initSateConstraint_2001,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex31) ).

fof(initSateConstraint_2000,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex33) ).

fof(initSateConstraint_1999,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex34) ).

fof(initSateConstraint_1998,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex35) ).

fof(initSateConstraint_1997,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex36) ).

fof(initSateConstraint_1996,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex37) ).

fof(initSateConstraint_1995,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex38) ).

fof(initSateConstraint_1994,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex39) ).

fof(initSateConstraint_1993,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex40) ).

fof(initSateConstraint_1992,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex41) ).

fof(initSateConstraint_1991,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex42) ).

fof(initSateConstraint_1990,axiom,
    ~ v4929_array(constB0,b11100_address_term,bitIndex43) ).

fof(initSateConstraint_1989,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex0) ).

fof(initSateConstraint_1988,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex1) ).

fof(initSateConstraint_1987,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex2) ).

fof(initSateConstraint_1986,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex3) ).

fof(initSateConstraint_1985,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex4) ).

fof(initSateConstraint_1984,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex5) ).

fof(initSateConstraint_1983,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex6) ).

fof(initSateConstraint_1982,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex7) ).

fof(initSateConstraint_1981,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex8) ).

fof(initSateConstraint_1980,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex9) ).

fof(initSateConstraint_1979,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex10) ).

fof(initSateConstraint_1978,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex11) ).

fof(initSateConstraint_1977,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex12) ).

fof(initSateConstraint_1976,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex13) ).

fof(initSateConstraint_1975,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex14) ).

fof(initSateConstraint_1974,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex15) ).

fof(initSateConstraint_1973,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex16) ).

fof(initSateConstraint_1972,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex17) ).

fof(initSateConstraint_1971,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex18) ).

fof(initSateConstraint_1970,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex19) ).

fof(initSateConstraint_1969,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex20) ).

fof(initSateConstraint_1968,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex21) ).

fof(initSateConstraint_1967,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex22) ).

fof(initSateConstraint_1966,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex23) ).

fof(initSateConstraint_1965,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex24) ).

fof(initSateConstraint_1964,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex25) ).

fof(initSateConstraint_1963,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex26) ).

fof(initSateConstraint_1962,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex27) ).

fof(initSateConstraint_1961,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex28) ).

fof(initSateConstraint_1960,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex29) ).

fof(initSateConstraint_1959,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex30) ).

fof(initSateConstraint_1958,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex31) ).

fof(initSateConstraint_1957,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex33) ).

fof(initSateConstraint_1956,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex34) ).

fof(initSateConstraint_1955,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex35) ).

fof(initSateConstraint_1954,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex36) ).

fof(initSateConstraint_1953,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex37) ).

fof(initSateConstraint_1952,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex38) ).

fof(initSateConstraint_1951,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex39) ).

fof(initSateConstraint_1950,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex40) ).

fof(initSateConstraint_1949,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex41) ).

fof(initSateConstraint_1948,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex42) ).

fof(initSateConstraint_1947,axiom,
    ~ v4929_array(constB0,b11011_address_term,bitIndex43) ).

fof(initSateConstraint_1946,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex0) ).

fof(initSateConstraint_1945,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex1) ).

fof(initSateConstraint_1944,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex2) ).

fof(initSateConstraint_1943,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex3) ).

fof(initSateConstraint_1942,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex4) ).

fof(initSateConstraint_1941,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex5) ).

fof(initSateConstraint_1940,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex6) ).

fof(initSateConstraint_1939,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex7) ).

fof(initSateConstraint_1938,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex8) ).

fof(initSateConstraint_1937,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex9) ).

fof(initSateConstraint_1936,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex10) ).

fof(initSateConstraint_1935,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex11) ).

fof(initSateConstraint_1934,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex12) ).

fof(initSateConstraint_1933,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex13) ).

fof(initSateConstraint_1932,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex14) ).

fof(initSateConstraint_1931,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex15) ).

fof(initSateConstraint_1930,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex16) ).

fof(initSateConstraint_1929,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex17) ).

fof(initSateConstraint_1928,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex18) ).

fof(initSateConstraint_1927,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex19) ).

fof(initSateConstraint_1926,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex20) ).

fof(initSateConstraint_1925,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex21) ).

fof(initSateConstraint_1924,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex22) ).

fof(initSateConstraint_1923,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex23) ).

fof(initSateConstraint_1922,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex24) ).

fof(initSateConstraint_1921,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex25) ).

fof(initSateConstraint_1920,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex26) ).

fof(initSateConstraint_1919,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex27) ).

fof(initSateConstraint_1918,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex28) ).

fof(initSateConstraint_1917,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex29) ).

fof(initSateConstraint_1916,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex30) ).

fof(initSateConstraint_1915,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex31) ).

fof(initSateConstraint_1914,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex33) ).

fof(initSateConstraint_1913,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex34) ).

fof(initSateConstraint_1912,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex35) ).

fof(initSateConstraint_1911,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex36) ).

fof(initSateConstraint_1910,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex37) ).

fof(initSateConstraint_1909,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex38) ).

fof(initSateConstraint_1908,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex39) ).

fof(initSateConstraint_1907,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex40) ).

fof(initSateConstraint_1906,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex41) ).

fof(initSateConstraint_1905,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex42) ).

fof(initSateConstraint_1904,axiom,
    ~ v4929_array(constB0,b11010_address_term,bitIndex43) ).

fof(initSateConstraint_1903,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex0) ).

fof(initSateConstraint_1902,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex1) ).

fof(initSateConstraint_1901,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex2) ).

fof(initSateConstraint_1900,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex3) ).

fof(initSateConstraint_1899,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex4) ).

fof(initSateConstraint_1898,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex5) ).

fof(initSateConstraint_1897,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex6) ).

fof(initSateConstraint_1896,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex7) ).

fof(initSateConstraint_1895,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex8) ).

fof(initSateConstraint_1894,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex9) ).

fof(initSateConstraint_1893,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex10) ).

fof(initSateConstraint_1892,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex11) ).

fof(initSateConstraint_1891,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex12) ).

fof(initSateConstraint_1890,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex13) ).

fof(initSateConstraint_1889,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex14) ).

fof(initSateConstraint_1888,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex15) ).

fof(initSateConstraint_1887,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex16) ).

fof(initSateConstraint_1886,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex17) ).

fof(initSateConstraint_1885,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex18) ).

fof(initSateConstraint_1884,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex19) ).

fof(initSateConstraint_1883,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex20) ).

fof(initSateConstraint_1882,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex21) ).

fof(initSateConstraint_1881,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex22) ).

fof(initSateConstraint_1880,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex23) ).

fof(initSateConstraint_1879,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex24) ).

fof(initSateConstraint_1878,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex25) ).

fof(initSateConstraint_1877,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex26) ).

fof(initSateConstraint_1876,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex27) ).

fof(initSateConstraint_1875,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex28) ).

fof(initSateConstraint_1874,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex29) ).

fof(initSateConstraint_1873,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex30) ).

fof(initSateConstraint_1872,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex31) ).

fof(initSateConstraint_1871,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex33) ).

fof(initSateConstraint_1870,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex34) ).

fof(initSateConstraint_1869,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex35) ).

fof(initSateConstraint_1868,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex36) ).

fof(initSateConstraint_1867,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex37) ).

fof(initSateConstraint_1866,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex38) ).

fof(initSateConstraint_1865,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex39) ).

fof(initSateConstraint_1864,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex40) ).

fof(initSateConstraint_1863,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex41) ).

fof(initSateConstraint_1862,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex42) ).

fof(initSateConstraint_1861,axiom,
    ~ v4929_array(constB0,b11001_address_term,bitIndex43) ).

fof(initSateConstraint_1860,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex0) ).

fof(initSateConstraint_1859,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex1) ).

fof(initSateConstraint_1858,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex2) ).

fof(initSateConstraint_1857,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex3) ).

fof(initSateConstraint_1856,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex4) ).

fof(initSateConstraint_1855,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex5) ).

fof(initSateConstraint_1854,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex6) ).

fof(initSateConstraint_1853,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex7) ).

fof(initSateConstraint_1852,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex8) ).

fof(initSateConstraint_1851,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex9) ).

fof(initSateConstraint_1850,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex10) ).

fof(initSateConstraint_1849,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex11) ).

fof(initSateConstraint_1848,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex12) ).

fof(initSateConstraint_1847,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex13) ).

fof(initSateConstraint_1846,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex14) ).

fof(initSateConstraint_1845,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex15) ).

fof(initSateConstraint_1844,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex16) ).

fof(initSateConstraint_1843,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex17) ).

fof(initSateConstraint_1842,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex18) ).

fof(initSateConstraint_1841,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex19) ).

fof(initSateConstraint_1840,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex20) ).

fof(initSateConstraint_1839,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex21) ).

fof(initSateConstraint_1838,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex22) ).

fof(initSateConstraint_1837,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex23) ).

fof(initSateConstraint_1836,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex24) ).

fof(initSateConstraint_1835,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex25) ).

fof(initSateConstraint_1834,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex26) ).

fof(initSateConstraint_1833,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex27) ).

fof(initSateConstraint_1832,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex28) ).

fof(initSateConstraint_1831,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex29) ).

fof(initSateConstraint_1830,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex30) ).

fof(initSateConstraint_1829,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex31) ).

fof(initSateConstraint_1828,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex33) ).

fof(initSateConstraint_1827,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex34) ).

fof(initSateConstraint_1826,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex35) ).

fof(initSateConstraint_1825,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex36) ).

fof(initSateConstraint_1824,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex37) ).

fof(initSateConstraint_1823,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex38) ).

fof(initSateConstraint_1822,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex39) ).

fof(initSateConstraint_1821,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex40) ).

fof(initSateConstraint_1820,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex41) ).

fof(initSateConstraint_1819,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex42) ).

fof(initSateConstraint_1818,axiom,
    ~ v4929_array(constB0,b11000_address_term,bitIndex43) ).

fof(initSateConstraint_1817,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex0) ).

fof(initSateConstraint_1816,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex1) ).

fof(initSateConstraint_1815,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex2) ).

fof(initSateConstraint_1814,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex3) ).

fof(initSateConstraint_1813,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex4) ).

fof(initSateConstraint_1812,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex5) ).

fof(initSateConstraint_1811,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex6) ).

fof(initSateConstraint_1810,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex7) ).

fof(initSateConstraint_1809,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex8) ).

fof(initSateConstraint_1808,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex9) ).

fof(initSateConstraint_1807,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex10) ).

fof(initSateConstraint_1806,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex11) ).

fof(initSateConstraint_1805,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex12) ).

fof(initSateConstraint_1804,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex13) ).

fof(initSateConstraint_1803,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex14) ).

fof(initSateConstraint_1802,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex15) ).

fof(initSateConstraint_1801,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex16) ).

fof(initSateConstraint_1800,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex17) ).

fof(initSateConstraint_1799,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex18) ).

fof(initSateConstraint_1798,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex19) ).

fof(initSateConstraint_1797,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex20) ).

fof(initSateConstraint_1796,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex21) ).

fof(initSateConstraint_1795,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex22) ).

fof(initSateConstraint_1794,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex23) ).

fof(initSateConstraint_1793,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex24) ).

fof(initSateConstraint_1792,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex25) ).

fof(initSateConstraint_1791,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex26) ).

fof(initSateConstraint_1790,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex27) ).

fof(initSateConstraint_1789,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex28) ).

fof(initSateConstraint_1788,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex29) ).

fof(initSateConstraint_1787,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex30) ).

fof(initSateConstraint_1786,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex31) ).

fof(initSateConstraint_1785,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex33) ).

fof(initSateConstraint_1784,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex34) ).

fof(initSateConstraint_1783,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex35) ).

fof(initSateConstraint_1782,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex36) ).

fof(initSateConstraint_1781,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex37) ).

fof(initSateConstraint_1780,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex38) ).

fof(initSateConstraint_1779,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex39) ).

fof(initSateConstraint_1778,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex40) ).

fof(initSateConstraint_1777,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex41) ).

fof(initSateConstraint_1776,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex42) ).

fof(initSateConstraint_1775,axiom,
    ~ v4929_array(constB0,b10111_address_term,bitIndex43) ).

fof(initSateConstraint_1774,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex0) ).

fof(initSateConstraint_1773,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex1) ).

fof(initSateConstraint_1772,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex2) ).

fof(initSateConstraint_1771,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex3) ).

fof(initSateConstraint_1770,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex4) ).

fof(initSateConstraint_1769,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex5) ).

fof(initSateConstraint_1768,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex6) ).

fof(initSateConstraint_1767,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex7) ).

fof(initSateConstraint_1766,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex8) ).

fof(initSateConstraint_1765,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex9) ).

fof(initSateConstraint_1764,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex10) ).

fof(initSateConstraint_1763,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex11) ).

fof(initSateConstraint_1762,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex12) ).

fof(initSateConstraint_1761,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex13) ).

fof(initSateConstraint_1760,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex14) ).

fof(initSateConstraint_1759,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex15) ).

fof(initSateConstraint_1758,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex16) ).

fof(initSateConstraint_1757,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex17) ).

fof(initSateConstraint_1756,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex18) ).

fof(initSateConstraint_1755,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex19) ).

fof(initSateConstraint_1754,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex20) ).

fof(initSateConstraint_1753,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex21) ).

fof(initSateConstraint_1752,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex22) ).

fof(initSateConstraint_1751,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex23) ).

fof(initSateConstraint_1750,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex24) ).

fof(initSateConstraint_1749,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex25) ).

fof(initSateConstraint_1748,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex26) ).

fof(initSateConstraint_1747,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex27) ).

fof(initSateConstraint_1746,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex28) ).

fof(initSateConstraint_1745,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex29) ).

fof(initSateConstraint_1744,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex30) ).

fof(initSateConstraint_1743,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex31) ).

fof(initSateConstraint_1742,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex33) ).

fof(initSateConstraint_1741,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex34) ).

fof(initSateConstraint_1740,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex35) ).

fof(initSateConstraint_1739,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex36) ).

fof(initSateConstraint_1738,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex37) ).

fof(initSateConstraint_1737,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex38) ).

fof(initSateConstraint_1736,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex39) ).

fof(initSateConstraint_1735,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex40) ).

fof(initSateConstraint_1734,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex41) ).

fof(initSateConstraint_1733,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex42) ).

fof(initSateConstraint_1732,axiom,
    ~ v4929_array(constB0,b10110_address_term,bitIndex43) ).

fof(initSateConstraint_1731,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex0) ).

fof(initSateConstraint_1730,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex1) ).

fof(initSateConstraint_1729,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex2) ).

fof(initSateConstraint_1728,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex3) ).

fof(initSateConstraint_1727,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex4) ).

fof(initSateConstraint_1726,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex5) ).

fof(initSateConstraint_1725,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex6) ).

fof(initSateConstraint_1724,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex7) ).

fof(initSateConstraint_1723,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex8) ).

fof(initSateConstraint_1722,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex9) ).

fof(initSateConstraint_1721,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex10) ).

fof(initSateConstraint_1720,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex11) ).

fof(initSateConstraint_1719,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex12) ).

fof(initSateConstraint_1718,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex13) ).

fof(initSateConstraint_1717,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex14) ).

fof(initSateConstraint_1716,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex15) ).

fof(initSateConstraint_1715,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex16) ).

fof(initSateConstraint_1714,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex17) ).

fof(initSateConstraint_1713,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex18) ).

fof(initSateConstraint_1712,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex19) ).

fof(initSateConstraint_1711,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex20) ).

fof(initSateConstraint_1710,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex21) ).

fof(initSateConstraint_1709,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex22) ).

fof(initSateConstraint_1708,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex23) ).

fof(initSateConstraint_1707,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex24) ).

fof(initSateConstraint_1706,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex25) ).

fof(initSateConstraint_1705,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex26) ).

fof(initSateConstraint_1704,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex27) ).

fof(initSateConstraint_1703,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex28) ).

fof(initSateConstraint_1702,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex29) ).

fof(initSateConstraint_1701,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex30) ).

fof(initSateConstraint_1700,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex31) ).

fof(initSateConstraint_1699,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex33) ).

fof(initSateConstraint_1698,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex34) ).

fof(initSateConstraint_1697,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex35) ).

fof(initSateConstraint_1696,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex36) ).

fof(initSateConstraint_1695,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex37) ).

fof(initSateConstraint_1694,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex38) ).

fof(initSateConstraint_1693,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex39) ).

fof(initSateConstraint_1692,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex40) ).

fof(initSateConstraint_1691,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex41) ).

fof(initSateConstraint_1690,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex42) ).

fof(initSateConstraint_1689,axiom,
    ~ v4929_array(constB0,b10101_address_term,bitIndex43) ).

fof(initSateConstraint_1688,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex0) ).

fof(initSateConstraint_1687,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex1) ).

fof(initSateConstraint_1686,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex2) ).

fof(initSateConstraint_1685,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex3) ).

fof(initSateConstraint_1684,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex4) ).

fof(initSateConstraint_1683,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex5) ).

fof(initSateConstraint_1682,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex6) ).

fof(initSateConstraint_1681,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex7) ).

fof(initSateConstraint_1680,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex8) ).

fof(initSateConstraint_1679,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex9) ).

fof(initSateConstraint_1678,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex10) ).

fof(initSateConstraint_1677,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex11) ).

fof(initSateConstraint_1676,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex12) ).

fof(initSateConstraint_1675,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex13) ).

fof(initSateConstraint_1674,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex14) ).

fof(initSateConstraint_1673,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex15) ).

fof(initSateConstraint_1672,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex16) ).

fof(initSateConstraint_1671,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex17) ).

fof(initSateConstraint_1670,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex18) ).

fof(initSateConstraint_1669,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex19) ).

fof(initSateConstraint_1668,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex20) ).

fof(initSateConstraint_1667,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex21) ).

fof(initSateConstraint_1666,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex22) ).

fof(initSateConstraint_1665,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex23) ).

fof(initSateConstraint_1664,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex24) ).

fof(initSateConstraint_1663,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex25) ).

fof(initSateConstraint_1662,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex26) ).

fof(initSateConstraint_1661,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex27) ).

fof(initSateConstraint_1660,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex28) ).

fof(initSateConstraint_1659,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex29) ).

fof(initSateConstraint_1658,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex30) ).

fof(initSateConstraint_1657,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex31) ).

fof(initSateConstraint_1656,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex33) ).

fof(initSateConstraint_1655,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex34) ).

fof(initSateConstraint_1654,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex35) ).

fof(initSateConstraint_1653,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex36) ).

fof(initSateConstraint_1652,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex37) ).

fof(initSateConstraint_1651,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex38) ).

fof(initSateConstraint_1650,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex39) ).

fof(initSateConstraint_1649,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex40) ).

fof(initSateConstraint_1648,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex41) ).

fof(initSateConstraint_1647,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex42) ).

fof(initSateConstraint_1646,axiom,
    ~ v4929_array(constB0,b10100_address_term,bitIndex43) ).

fof(initSateConstraint_1645,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex0) ).

fof(initSateConstraint_1644,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex1) ).

fof(initSateConstraint_1643,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex2) ).

fof(initSateConstraint_1642,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex3) ).

fof(initSateConstraint_1641,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex4) ).

fof(initSateConstraint_1640,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex5) ).

fof(initSateConstraint_1639,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex6) ).

fof(initSateConstraint_1638,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex7) ).

fof(initSateConstraint_1637,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex8) ).

fof(initSateConstraint_1636,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex9) ).

fof(initSateConstraint_1635,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex10) ).

fof(initSateConstraint_1634,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex11) ).

fof(initSateConstraint_1633,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex12) ).

fof(initSateConstraint_1632,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex13) ).

fof(initSateConstraint_1631,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex14) ).

fof(initSateConstraint_1630,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex15) ).

fof(initSateConstraint_1629,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex16) ).

fof(initSateConstraint_1628,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex17) ).

fof(initSateConstraint_1627,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex18) ).

fof(initSateConstraint_1626,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex19) ).

fof(initSateConstraint_1625,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex20) ).

fof(initSateConstraint_1624,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex21) ).

fof(initSateConstraint_1623,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex22) ).

fof(initSateConstraint_1622,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex23) ).

fof(initSateConstraint_1621,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex24) ).

fof(initSateConstraint_1620,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex25) ).

fof(initSateConstraint_1619,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex26) ).

fof(initSateConstraint_1618,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex27) ).

fof(initSateConstraint_1617,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex28) ).

fof(initSateConstraint_1616,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex29) ).

fof(initSateConstraint_1615,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex30) ).

fof(initSateConstraint_1614,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex31) ).

fof(initSateConstraint_1613,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex33) ).

fof(initSateConstraint_1612,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex34) ).

fof(initSateConstraint_1611,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex35) ).

fof(initSateConstraint_1610,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex36) ).

fof(initSateConstraint_1609,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex37) ).

fof(initSateConstraint_1608,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex38) ).

fof(initSateConstraint_1607,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex39) ).

fof(initSateConstraint_1606,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex40) ).

fof(initSateConstraint_1605,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex41) ).

fof(initSateConstraint_1604,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex42) ).

fof(initSateConstraint_1603,axiom,
    ~ v4929_array(constB0,b10011_address_term,bitIndex43) ).

fof(initSateConstraint_1602,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex0) ).

fof(initSateConstraint_1601,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex1) ).

fof(initSateConstraint_1600,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex2) ).

fof(initSateConstraint_1599,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex3) ).

fof(initSateConstraint_1598,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex4) ).

fof(initSateConstraint_1597,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex5) ).

fof(initSateConstraint_1596,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex6) ).

fof(initSateConstraint_1595,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex7) ).

fof(initSateConstraint_1594,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex8) ).

fof(initSateConstraint_1593,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex9) ).

fof(initSateConstraint_1592,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex10) ).

fof(initSateConstraint_1591,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex11) ).

fof(initSateConstraint_1590,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex12) ).

fof(initSateConstraint_1589,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex13) ).

fof(initSateConstraint_1588,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex14) ).

fof(initSateConstraint_1587,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex15) ).

fof(initSateConstraint_1586,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex16) ).

fof(initSateConstraint_1585,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex17) ).

fof(initSateConstraint_1584,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex18) ).

fof(initSateConstraint_1583,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex19) ).

fof(initSateConstraint_1582,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex20) ).

fof(initSateConstraint_1581,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex21) ).

fof(initSateConstraint_1580,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex22) ).

fof(initSateConstraint_1579,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex23) ).

fof(initSateConstraint_1578,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex24) ).

fof(initSateConstraint_1577,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex25) ).

fof(initSateConstraint_1576,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex26) ).

fof(initSateConstraint_1575,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex27) ).

fof(initSateConstraint_1574,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex28) ).

fof(initSateConstraint_1573,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex29) ).

fof(initSateConstraint_1572,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex30) ).

fof(initSateConstraint_1571,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex31) ).

fof(initSateConstraint_1570,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex33) ).

fof(initSateConstraint_1569,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex34) ).

fof(initSateConstraint_1568,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex35) ).

fof(initSateConstraint_1567,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex36) ).

fof(initSateConstraint_1566,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex37) ).

fof(initSateConstraint_1565,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex38) ).

fof(initSateConstraint_1564,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex39) ).

fof(initSateConstraint_1563,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex40) ).

fof(initSateConstraint_1562,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex41) ).

fof(initSateConstraint_1561,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex42) ).

fof(initSateConstraint_1560,axiom,
    ~ v4929_array(constB0,b10010_address_term,bitIndex43) ).

fof(initSateConstraint_1559,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex0) ).

fof(initSateConstraint_1558,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex1) ).

fof(initSateConstraint_1557,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex2) ).

fof(initSateConstraint_1556,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex3) ).

fof(initSateConstraint_1555,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex4) ).

fof(initSateConstraint_1554,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex5) ).

fof(initSateConstraint_1553,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex6) ).

fof(initSateConstraint_1552,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex7) ).

fof(initSateConstraint_1551,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex8) ).

fof(initSateConstraint_1550,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex9) ).

fof(initSateConstraint_1549,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex10) ).

fof(initSateConstraint_1548,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex11) ).

fof(initSateConstraint_1547,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex12) ).

fof(initSateConstraint_1546,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex13) ).

fof(initSateConstraint_1545,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex14) ).

fof(initSateConstraint_1544,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex15) ).

fof(initSateConstraint_1543,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex16) ).

fof(initSateConstraint_1542,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex17) ).

fof(initSateConstraint_1541,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex18) ).

fof(initSateConstraint_1540,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex19) ).

fof(initSateConstraint_1539,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex20) ).

fof(initSateConstraint_1538,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex21) ).

fof(initSateConstraint_1537,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex22) ).

fof(initSateConstraint_1536,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex23) ).

fof(initSateConstraint_1535,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex24) ).

fof(initSateConstraint_1534,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex25) ).

fof(initSateConstraint_1533,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex26) ).

fof(initSateConstraint_1532,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex27) ).

fof(initSateConstraint_1531,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex28) ).

fof(initSateConstraint_1530,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex29) ).

fof(initSateConstraint_1529,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex30) ).

fof(initSateConstraint_1528,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex31) ).

fof(initSateConstraint_1527,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex33) ).

fof(initSateConstraint_1526,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex34) ).

fof(initSateConstraint_1525,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex35) ).

fof(initSateConstraint_1524,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex36) ).

fof(initSateConstraint_1523,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex37) ).

fof(initSateConstraint_1522,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex38) ).

fof(initSateConstraint_1521,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex39) ).

fof(initSateConstraint_1520,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex40) ).

fof(initSateConstraint_1519,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex41) ).

fof(initSateConstraint_1518,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex42) ).

fof(initSateConstraint_1517,axiom,
    ~ v4929_array(constB0,b10001_address_term,bitIndex43) ).

fof(initSateConstraint_1516,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex0) ).

fof(initSateConstraint_1515,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex1) ).

fof(initSateConstraint_1514,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex2) ).

fof(initSateConstraint_1513,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex3) ).

fof(initSateConstraint_1512,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex4) ).

fof(initSateConstraint_1511,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex5) ).

fof(initSateConstraint_1510,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex6) ).

fof(initSateConstraint_1509,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex7) ).

fof(initSateConstraint_1508,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex8) ).

fof(initSateConstraint_1507,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex9) ).

fof(initSateConstraint_1506,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex10) ).

fof(initSateConstraint_1505,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex11) ).

fof(initSateConstraint_1504,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex12) ).

fof(initSateConstraint_1503,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex13) ).

fof(initSateConstraint_1502,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex14) ).

fof(initSateConstraint_1501,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex15) ).

fof(initSateConstraint_1500,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex16) ).

fof(initSateConstraint_1499,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex17) ).

fof(initSateConstraint_1498,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex18) ).

fof(initSateConstraint_1497,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex19) ).

fof(initSateConstraint_1496,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex20) ).

fof(initSateConstraint_1495,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex21) ).

fof(initSateConstraint_1494,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex22) ).

fof(initSateConstraint_1493,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex23) ).

fof(initSateConstraint_1492,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex24) ).

fof(initSateConstraint_1491,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex25) ).

fof(initSateConstraint_1490,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex26) ).

fof(initSateConstraint_1489,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex27) ).

fof(initSateConstraint_1488,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex28) ).

fof(initSateConstraint_1487,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex29) ).

fof(initSateConstraint_1486,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex30) ).

fof(initSateConstraint_1485,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex31) ).

fof(initSateConstraint_1484,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex33) ).

fof(initSateConstraint_1483,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex34) ).

fof(initSateConstraint_1482,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex35) ).

fof(initSateConstraint_1481,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex36) ).

fof(initSateConstraint_1480,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex37) ).

fof(initSateConstraint_1479,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex38) ).

fof(initSateConstraint_1478,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex39) ).

fof(initSateConstraint_1477,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex40) ).

fof(initSateConstraint_1476,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex41) ).

fof(initSateConstraint_1475,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex42) ).

fof(initSateConstraint_1474,axiom,
    ~ v4929_array(constB0,b10000_address_term,bitIndex43) ).

fof(initSateConstraint_1473,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex0) ).

fof(initSateConstraint_1472,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex1) ).

fof(initSateConstraint_1471,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex2) ).

fof(initSateConstraint_1470,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex3) ).

fof(initSateConstraint_1469,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex4) ).

fof(initSateConstraint_1468,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex5) ).

fof(initSateConstraint_1467,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex6) ).

fof(initSateConstraint_1466,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex7) ).

fof(initSateConstraint_1465,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex8) ).

fof(initSateConstraint_1464,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex9) ).

fof(initSateConstraint_1463,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex10) ).

fof(initSateConstraint_1462,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex11) ).

fof(initSateConstraint_1461,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex12) ).

fof(initSateConstraint_1460,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex13) ).

fof(initSateConstraint_1459,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex14) ).

fof(initSateConstraint_1458,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex15) ).

fof(initSateConstraint_1457,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex16) ).

fof(initSateConstraint_1456,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex17) ).

fof(initSateConstraint_1455,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex18) ).

fof(initSateConstraint_1454,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex19) ).

fof(initSateConstraint_1453,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex20) ).

fof(initSateConstraint_1452,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex21) ).

fof(initSateConstraint_1451,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex22) ).

fof(initSateConstraint_1450,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex23) ).

fof(initSateConstraint_1449,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex24) ).

fof(initSateConstraint_1448,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex25) ).

fof(initSateConstraint_1447,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex26) ).

fof(initSateConstraint_1446,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex27) ).

fof(initSateConstraint_1445,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex28) ).

fof(initSateConstraint_1444,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex29) ).

fof(initSateConstraint_1443,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex30) ).

fof(initSateConstraint_1442,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex31) ).

fof(initSateConstraint_1441,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex33) ).

fof(initSateConstraint_1440,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex34) ).

fof(initSateConstraint_1439,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex35) ).

fof(initSateConstraint_1438,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex36) ).

fof(initSateConstraint_1437,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex37) ).

fof(initSateConstraint_1436,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex38) ).

fof(initSateConstraint_1435,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex39) ).

fof(initSateConstraint_1434,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex40) ).

fof(initSateConstraint_1433,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex41) ).

fof(initSateConstraint_1432,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex42) ).

fof(initSateConstraint_1431,axiom,
    ~ v4929_array(constB0,b01111_address_term,bitIndex43) ).

fof(initSateConstraint_1430,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex0) ).

fof(initSateConstraint_1429,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex1) ).

fof(initSateConstraint_1428,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex2) ).

fof(initSateConstraint_1427,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex3) ).

fof(initSateConstraint_1426,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex4) ).

fof(initSateConstraint_1425,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex5) ).

fof(initSateConstraint_1424,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex6) ).

fof(initSateConstraint_1423,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex7) ).

fof(initSateConstraint_1422,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex8) ).

fof(initSateConstraint_1421,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex9) ).

fof(initSateConstraint_1420,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex10) ).

fof(initSateConstraint_1419,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex11) ).

fof(initSateConstraint_1418,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex12) ).

fof(initSateConstraint_1417,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex13) ).

fof(initSateConstraint_1416,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex14) ).

fof(initSateConstraint_1415,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex15) ).

fof(initSateConstraint_1414,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex16) ).

fof(initSateConstraint_1413,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex17) ).

fof(initSateConstraint_1412,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex18) ).

fof(initSateConstraint_1411,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex19) ).

fof(initSateConstraint_1410,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex20) ).

fof(initSateConstraint_1409,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex21) ).

fof(initSateConstraint_1408,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex22) ).

fof(initSateConstraint_1407,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex23) ).

fof(initSateConstraint_1406,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex24) ).

fof(initSateConstraint_1405,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex25) ).

fof(initSateConstraint_1404,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex26) ).

fof(initSateConstraint_1403,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex27) ).

fof(initSateConstraint_1402,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex28) ).

fof(initSateConstraint_1401,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex29) ).

fof(initSateConstraint_1400,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex30) ).

fof(initSateConstraint_1399,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex31) ).

fof(initSateConstraint_1398,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex33) ).

fof(initSateConstraint_1397,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex34) ).

fof(initSateConstraint_1396,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex35) ).

fof(initSateConstraint_1395,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex36) ).

fof(initSateConstraint_1394,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex37) ).

fof(initSateConstraint_1393,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex38) ).

fof(initSateConstraint_1392,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex39) ).

fof(initSateConstraint_1391,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex40) ).

fof(initSateConstraint_1390,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex41) ).

fof(initSateConstraint_1389,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex42) ).

fof(initSateConstraint_1388,axiom,
    ~ v4929_array(constB0,b01110_address_term,bitIndex43) ).

fof(initSateConstraint_1387,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex0) ).

fof(initSateConstraint_1386,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex1) ).

fof(initSateConstraint_1385,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex2) ).

fof(initSateConstraint_1384,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex3) ).

fof(initSateConstraint_1383,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex4) ).

fof(initSateConstraint_1382,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex5) ).

fof(initSateConstraint_1381,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex6) ).

fof(initSateConstraint_1380,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex7) ).

fof(initSateConstraint_1379,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex8) ).

fof(initSateConstraint_1378,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex9) ).

fof(initSateConstraint_1377,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex10) ).

fof(initSateConstraint_1376,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex11) ).

fof(initSateConstraint_1375,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex12) ).

fof(initSateConstraint_1374,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex13) ).

fof(initSateConstraint_1373,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex14) ).

fof(initSateConstraint_1372,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex15) ).

fof(initSateConstraint_1371,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex16) ).

fof(initSateConstraint_1370,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex17) ).

fof(initSateConstraint_1369,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex18) ).

fof(initSateConstraint_1368,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex19) ).

fof(initSateConstraint_1367,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex20) ).

fof(initSateConstraint_1366,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex21) ).

fof(initSateConstraint_1365,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex22) ).

fof(initSateConstraint_1364,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex23) ).

fof(initSateConstraint_1363,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex24) ).

fof(initSateConstraint_1362,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex25) ).

fof(initSateConstraint_1361,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex26) ).

fof(initSateConstraint_1360,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex27) ).

fof(initSateConstraint_1359,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex28) ).

fof(initSateConstraint_1358,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex29) ).

fof(initSateConstraint_1357,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex30) ).

fof(initSateConstraint_1356,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex31) ).

fof(initSateConstraint_1355,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex33) ).

fof(initSateConstraint_1354,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex34) ).

fof(initSateConstraint_1353,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex35) ).

fof(initSateConstraint_1352,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex36) ).

fof(initSateConstraint_1351,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex37) ).

fof(initSateConstraint_1350,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex38) ).

fof(initSateConstraint_1349,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex39) ).

fof(initSateConstraint_1348,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex40) ).

fof(initSateConstraint_1347,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex41) ).

fof(initSateConstraint_1346,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex42) ).

fof(initSateConstraint_1345,axiom,
    ~ v4929_array(constB0,b01101_address_term,bitIndex43) ).

fof(initSateConstraint_1344,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex0) ).

fof(initSateConstraint_1343,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex1) ).

fof(initSateConstraint_1342,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex2) ).

fof(initSateConstraint_1341,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex3) ).

fof(initSateConstraint_1340,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex4) ).

fof(initSateConstraint_1339,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex5) ).

fof(initSateConstraint_1338,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex6) ).

fof(initSateConstraint_1337,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex7) ).

fof(initSateConstraint_1336,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex8) ).

fof(initSateConstraint_1335,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex9) ).

fof(initSateConstraint_1334,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex10) ).

fof(initSateConstraint_1333,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex11) ).

fof(initSateConstraint_1332,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex12) ).

fof(initSateConstraint_1331,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex13) ).

fof(initSateConstraint_1330,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex14) ).

fof(initSateConstraint_1329,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex15) ).

fof(initSateConstraint_1328,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex16) ).

fof(initSateConstraint_1327,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex17) ).

fof(initSateConstraint_1326,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex18) ).

fof(initSateConstraint_1325,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex19) ).

fof(initSateConstraint_1324,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex20) ).

fof(initSateConstraint_1323,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex21) ).

fof(initSateConstraint_1322,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex22) ).

fof(initSateConstraint_1321,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex23) ).

fof(initSateConstraint_1320,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex24) ).

fof(initSateConstraint_1319,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex25) ).

fof(initSateConstraint_1318,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex26) ).

fof(initSateConstraint_1317,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex27) ).

fof(initSateConstraint_1316,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex28) ).

fof(initSateConstraint_1315,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex29) ).

fof(initSateConstraint_1314,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex30) ).

fof(initSateConstraint_1313,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex31) ).

fof(initSateConstraint_1312,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex33) ).

fof(initSateConstraint_1311,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex34) ).

fof(initSateConstraint_1310,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex35) ).

fof(initSateConstraint_1309,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex36) ).

fof(initSateConstraint_1308,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex37) ).

fof(initSateConstraint_1307,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex38) ).

fof(initSateConstraint_1306,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex39) ).

fof(initSateConstraint_1305,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex40) ).

fof(initSateConstraint_1304,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex41) ).

fof(initSateConstraint_1303,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex42) ).

fof(initSateConstraint_1302,axiom,
    ~ v4929_array(constB0,b01100_address_term,bitIndex43) ).

fof(initSateConstraint_1301,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex0) ).

fof(initSateConstraint_1300,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex1) ).

fof(initSateConstraint_1299,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex2) ).

fof(initSateConstraint_1298,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex3) ).

fof(initSateConstraint_1297,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex4) ).

fof(initSateConstraint_1296,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex5) ).

fof(initSateConstraint_1295,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex6) ).

fof(initSateConstraint_1294,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex7) ).

fof(initSateConstraint_1293,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex8) ).

fof(initSateConstraint_1292,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex9) ).

fof(initSateConstraint_1291,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex10) ).

fof(initSateConstraint_1290,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex11) ).

fof(initSateConstraint_1289,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex12) ).

fof(initSateConstraint_1288,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex13) ).

fof(initSateConstraint_1287,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex14) ).

fof(initSateConstraint_1286,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex15) ).

fof(initSateConstraint_1285,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex16) ).

fof(initSateConstraint_1284,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex17) ).

fof(initSateConstraint_1283,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex18) ).

fof(initSateConstraint_1282,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex19) ).

fof(initSateConstraint_1281,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex20) ).

fof(initSateConstraint_1280,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex21) ).

fof(initSateConstraint_1279,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex22) ).

fof(initSateConstraint_1278,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex23) ).

fof(initSateConstraint_1277,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex24) ).

fof(initSateConstraint_1276,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex25) ).

fof(initSateConstraint_1275,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex26) ).

fof(initSateConstraint_1274,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex27) ).

fof(initSateConstraint_1273,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex28) ).

fof(initSateConstraint_1272,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex29) ).

fof(initSateConstraint_1271,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex30) ).

fof(initSateConstraint_1270,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex31) ).

fof(initSateConstraint_1269,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex33) ).

fof(initSateConstraint_1268,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex34) ).

fof(initSateConstraint_1267,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex35) ).

fof(initSateConstraint_1266,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex36) ).

fof(initSateConstraint_1265,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex37) ).

fof(initSateConstraint_1264,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex38) ).

fof(initSateConstraint_1263,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex39) ).

fof(initSateConstraint_1262,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex40) ).

fof(initSateConstraint_1261,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex41) ).

fof(initSateConstraint_1260,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex42) ).

fof(initSateConstraint_1259,axiom,
    ~ v4929_array(constB0,b01011_address_term,bitIndex43) ).

fof(initSateConstraint_1258,axiom,
    ~ v4929_array(constB0,b01010_address_term,bitIndex0) ).

fof(initSateConstraint_1257,axiom,
    ~ v4929_array(constB0,b01010_address_term,bitIndex1) ).

fof(initSateConstraint_1256,axiom,
    ~ v4929_array(constB0,b01010_address_term,bitIndex2) ).

fof(initSateConstraint_1255,axiom,
    ~ v4929_array(constB0,b01010_address_term,bitIndex3) ).

fof(initSateConstraint_1254,axiom,
    ~ v4929_array(constB0,b01010_address_term,bitIndex4) ).

fof(initSateConstraint_1253,axiom,
    ~ v4929_array(constB0,b01010_address_term,bitIndex5) ).

fof(initSateConstraint_1252,axiom,
    ~ v4929_array(constB0,b01010_address_term,bitIndex6) ).

fof(initSateConstraint_1251,axiom,
    ~ v4929_array(constB0,b01010_address_term,bitIndex7) ).

fof(initSateConstraint_1250,axiom,
    ~ v4929_array(constB0,b01010_address_term,bitIndex8) ).

fof(initSateConstraint_1249,axiom,
    ~ v4929_array(constB0,b01010_address_term,bitIndex9) ).

fof(initSateConstraint_1248,axiom,
    ~ v4929_array(constB0,b01010_address_term,bitIndex10) ).

fof(initSateConstraint_1247,axiom,
    ~ v4929_array(constB0,b01010_address_term,bitIndex11) ).

fof(initSateConstraint_1246,axiom,
    ~ v4929_array(constB0,b01010_address_term,bitIndex12) ).

fof(initSateConstraint_1245,axiom,
    ~ v4929_array(constB0,b01010_address_term,bitIndex13) ).

fof(initSateConstraint_1244,axiom,
    ~ v4929_array(constB0,b01010_address_term,bitIndex14) ).

fof(initSateConstraint_1243,axiom,
    ~ v4929_array(constB0,b01010_address_term,bitIndex15) ).

fof(initSateConstraint_1242,axiom,
    ~ v4929_array(constB0,b01010_address_term,bitIndex16) ).

fof(initSateConstraint_1241,axiom,
    ~ v4929_array(co