%------------------------------------------------------------------------------
% File     : HWV098+1 : TPTP v9.2.0. Released v6.1.0.
% Domain   : Hardware Verification
% Problem  : dmu_dmc property 8 cone of influence 8_b20
% Version  : Especial.
% English  : Verification of a property of the SPARCT2 RTL hardware design.

% Refs     : [Kha14] Khasidashvili (2014), Email to Geoff Sutcliffe
% Source   : [Kha14]
% Names    : dmu_dmc_prop8_cone8_b20 [Kha14]

% Status   : Theorem
% Rating   : 1.00 v6.1.0
% Syntax   : Number of formulae    : 63535 (11947 unt;   0 def)
%            Number of atoms       : 228663 (5350 equ)
%            Maximal formula atoms :  264 (   3 avg)
%            Number of connectives : 186102 (20974   ~;10234   |;44422   &)
%                                         (88693 <=>;21764  =>;   0  <=;  15 <~>)
%            Maximal formula depth :  136 (   4 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of predicates  : 33996 (33993 usr;   2 prp; 0-3 aty)
%            Number of functors    : 2496 (2496 usr;2496 con; 0-0 aty)
%            Number of variables   : 63119 (63119   !;   0   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : Copyright 2013 Moshe Emmer and Zurab Khasidashvili
%            Licensed under the Apache License, Version 2.0 (the "License");
%            you may not use this file except in compliance with the License.
%            You may obtain a copy of the License at
%                http://www.apache.org/licenses/LICENSE-2.0
%            Unless required by applicable law or agreed to in writing,
%            software distributed under the License is distributed on an "AS
%            IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
%            express or implied. See the License for the specific language
%            governing permissions and limitations under the License.
%------------------------------------------------------------------------------
fof(pathAxiom_8,axiom,
    nextState(constB8,constB9) ).

fof(pathAxiom_7,axiom,
    nextState(constB7,constB8) ).

fof(pathAxiom_6,axiom,
    nextState(constB6,constB7) ).

fof(pathAxiom_5,axiom,
    nextState(constB5,constB6) ).

fof(pathAxiom_4,axiom,
    nextState(constB4,constB5) ).

fof(pathAxiom_3,axiom,
    nextState(constB3,constB4) ).

fof(pathAxiom_2,axiom,
    nextState(constB2,constB3) ).

fof(pathAxiom_1,axiom,
    nextState(constB1,constB2) ).

fof(pathAxiom,axiom,
    nextState(constB0,constB1) ).

fof(reachableStateAxiom_22,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( reachableState(VarCurr)
        & reachableState(VarNext) ) ) ).

fof(reachableStateAxiom_21,axiom,
    ! [VarState] :
      ( reachableState(VarState)
     => ( constB0 = VarState
        | constB1 = VarState
        | constB2 = VarState
        | constB3 = VarState
        | constB4 = VarState
        | constB5 = VarState
        | constB6 = VarState
        | constB7 = VarState
        | constB8 = VarState
        | constB9 = VarState
        | constB10 = VarState
        | constB11 = VarState
        | constB12 = VarState
        | constB13 = VarState
        | constB14 = VarState
        | constB15 = VarState
        | constB16 = VarState
        | constB17 = VarState
        | constB18 = VarState
        | constB19 = VarState
        | constB20 = VarState ) ) ).

fof(reachableStateAxiom_20,axiom,
    reachableState(constB20) ).

fof(reachableStateAxiom_19,axiom,
    reachableState(constB19) ).

fof(reachableStateAxiom_18,axiom,
    reachableState(constB18) ).

fof(reachableStateAxiom_17,axiom,
    reachableState(constB17) ).

fof(reachableStateAxiom_16,axiom,
    reachableState(constB16) ).

fof(reachableStateAxiom_15,axiom,
    reachableState(constB15) ).

fof(reachableStateAxiom_14,axiom,
    reachableState(constB14) ).

fof(reachableStateAxiom_13,axiom,
    reachableState(constB13) ).

fof(reachableStateAxiom_12,axiom,
    reachableState(constB12) ).

fof(reachableStateAxiom_11,axiom,
    reachableState(constB11) ).

fof(reachableStateAxiom_10,axiom,
    reachableState(constB10) ).

fof(reachableStateAxiom_9,axiom,
    reachableState(constB9) ).

fof(reachableStateAxiom_8,axiom,
    reachableState(constB8) ).

fof(reachableStateAxiom_7,axiom,
    reachableState(constB7) ).

fof(reachableStateAxiom_6,axiom,
    reachableState(constB6) ).

fof(reachableStateAxiom_5,axiom,
    reachableState(constB5) ).

fof(reachableStateAxiom_4,axiom,
    reachableState(constB4) ).

fof(reachableStateAxiom_3,axiom,
    reachableState(constB3) ).

fof(reachableStateAxiom_2,axiom,
    reachableState(constB2) ).

fof(reachableStateAxiom_1,axiom,
    reachableState(constB1) ).

fof(reachableStateAxiom,axiom,
    reachableState(constB0) ).

fof(clock_toggling,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1(VarCurr)
      <=> ~ v1(VarNext) ) ) ).

fof(clock_pattern,axiom,
    ~ v1(constB0) ).

fof(transient_address_definition_314,axiom,
    ! [B] :
      ( addressVal(v50561_range_4_to_0_address_term_bound_20,B)
    <=> v50561(constB20,B) ) ).

fof(is_address_362,axiom,
    address(v50561_range_4_to_0_address_term_bound_20) ).

fof(address_association_314,axiom,
    v50561_range_4_to_0_address_association(constB20,v50561_range_4_to_0_address_term_bound_20) ).

fof(transient_address_definition_313,axiom,
    ! [B] :
      ( addressVal(v50561_range_4_to_0_address_term_bound_19,B)
    <=> v50561(constB19,B) ) ).

fof(is_address_361,axiom,
    address(v50561_range_4_to_0_address_term_bound_19) ).

fof(address_association_313,axiom,
    v50561_range_4_to_0_address_association(constB19,v50561_range_4_to_0_address_term_bound_19) ).

fof(transient_address_definition_312,axiom,
    ! [B] :
      ( addressVal(v50561_range_4_to_0_address_term_bound_18,B)
    <=> v50561(constB18,B) ) ).

fof(is_address_360,axiom,
    address(v50561_range_4_to_0_address_term_bound_18) ).

fof(address_association_312,axiom,
    v50561_range_4_to_0_address_association(constB18,v50561_range_4_to_0_address_term_bound_18) ).

fof(transient_address_definition_311,axiom,
    ! [B] :
      ( addressVal(v50561_range_4_to_0_address_term_bound_17,B)
    <=> v50561(constB17,B) ) ).

fof(is_address_359,axiom,
    address(v50561_range_4_to_0_address_term_bound_17) ).

fof(address_association_311,axiom,
    v50561_range_4_to_0_address_association(constB17,v50561_range_4_to_0_address_term_bound_17) ).

fof(transient_address_definition_310,axiom,
    ! [B] :
      ( addressVal(v50561_range_4_to_0_address_term_bound_16,B)
    <=> v50561(constB16,B) ) ).

fof(is_address_358,axiom,
    address(v50561_range_4_to_0_address_term_bound_16) ).

fof(address_association_310,axiom,
    v50561_range_4_to_0_address_association(constB16,v50561_range_4_to_0_address_term_bound_16) ).

fof(transient_address_definition_309,axiom,
    ! [B] :
      ( addressVal(v50561_range_4_to_0_address_term_bound_15,B)
    <=> v50561(constB15,B) ) ).

fof(is_address_357,axiom,
    address(v50561_range_4_to_0_address_term_bound_15) ).

fof(address_association_309,axiom,
    v50561_range_4_to_0_address_association(constB15,v50561_range_4_to_0_address_term_bound_15) ).

fof(transient_address_definition_308,axiom,
    ! [B] :
      ( addressVal(v50561_range_4_to_0_address_term_bound_14,B)
    <=> v50561(constB14,B) ) ).

fof(is_address_356,axiom,
    address(v50561_range_4_to_0_address_term_bound_14) ).

fof(address_association_308,axiom,
    v50561_range_4_to_0_address_association(constB14,v50561_range_4_to_0_address_term_bound_14) ).

fof(transient_address_definition_307,axiom,
    ! [B] :
      ( addressVal(v50561_range_4_to_0_address_term_bound_13,B)
    <=> v50561(constB13,B) ) ).

fof(is_address_355,axiom,
    address(v50561_range_4_to_0_address_term_bound_13) ).

fof(address_association_307,axiom,
    v50561_range_4_to_0_address_association(constB13,v50561_range_4_to_0_address_term_bound_13) ).

fof(transient_address_definition_306,axiom,
    ! [B] :
      ( addressVal(v50561_range_4_to_0_address_term_bound_12,B)
    <=> v50561(constB12,B) ) ).

fof(is_address_354,axiom,
    address(v50561_range_4_to_0_address_term_bound_12) ).

fof(address_association_306,axiom,
    v50561_range_4_to_0_address_association(constB12,v50561_range_4_to_0_address_term_bound_12) ).

fof(transient_address_definition_305,axiom,
    ! [B] :
      ( addressVal(v50561_range_4_to_0_address_term_bound_11,B)
    <=> v50561(constB11,B) ) ).

fof(is_address_353,axiom,
    address(v50561_range_4_to_0_address_term_bound_11) ).

fof(address_association_305,axiom,
    v50561_range_4_to_0_address_association(constB11,v50561_range_4_to_0_address_term_bound_11) ).

fof(transient_address_definition_304,axiom,
    ! [B] :
      ( addressVal(v50561_range_4_to_0_address_term_bound_10,B)
    <=> v50561(constB10,B) ) ).

fof(is_address_352,axiom,
    address(v50561_range_4_to_0_address_term_bound_10) ).

fof(address_association_304,axiom,
    v50561_range_4_to_0_address_association(constB10,v50561_range_4_to_0_address_term_bound_10) ).

fof(transient_address_definition_303,axiom,
    ! [B] :
      ( addressVal(v50561_range_4_to_0_address_term_bound_9,B)
    <=> v50561(constB9,B) ) ).

fof(is_address_351,axiom,
    address(v50561_range_4_to_0_address_term_bound_9) ).

fof(address_association_303,axiom,
    v50561_range_4_to_0_address_association(constB9,v50561_range_4_to_0_address_term_bound_9) ).

fof(transient_address_definition_302,axiom,
    ! [B] :
      ( addressVal(v50561_range_4_to_0_address_term_bound_8,B)
    <=> v50561(constB8,B) ) ).

fof(is_address_350,axiom,
    address(v50561_range_4_to_0_address_term_bound_8) ).

fof(address_association_302,axiom,
    v50561_range_4_to_0_address_association(constB8,v50561_range_4_to_0_address_term_bound_8) ).

fof(transient_address_definition_301,axiom,
    ! [B] :
      ( addressVal(v50561_range_4_to_0_address_term_bound_7,B)
    <=> v50561(constB7,B) ) ).

fof(is_address_349,axiom,
    address(v50561_range_4_to_0_address_term_bound_7) ).

fof(address_association_301,axiom,
    v50561_range_4_to_0_address_association(constB7,v50561_range_4_to_0_address_term_bound_7) ).

fof(transient_address_definition_300,axiom,
    ! [B] :
      ( addressVal(v50561_range_4_to_0_address_term_bound_6,B)
    <=> v50561(constB6,B) ) ).

fof(is_address_348,axiom,
    address(v50561_range_4_to_0_address_term_bound_6) ).

fof(address_association_300,axiom,
    v50561_range_4_to_0_address_association(constB6,v50561_range_4_to_0_address_term_bound_6) ).

fof(transient_address_definition_299,axiom,
    ! [B] :
      ( addressVal(v50561_range_4_to_0_address_term_bound_5,B)
    <=> v50561(constB5,B) ) ).

fof(is_address_347,axiom,
    address(v50561_range_4_to_0_address_term_bound_5) ).

fof(address_association_299,axiom,
    v50561_range_4_to_0_address_association(constB5,v50561_range_4_to_0_address_term_bound_5) ).

fof(transient_address_definition_298,axiom,
    ! [B] :
      ( addressVal(v50561_range_4_to_0_address_term_bound_4,B)
    <=> v50561(constB4,B) ) ).

fof(is_address_346,axiom,
    address(v50561_range_4_to_0_address_term_bound_4) ).

fof(address_association_298,axiom,
    v50561_range_4_to_0_address_association(constB4,v50561_range_4_to_0_address_term_bound_4) ).

fof(transient_address_definition_297,axiom,
    ! [B] :
      ( addressVal(v50561_range_4_to_0_address_term_bound_3,B)
    <=> v50561(constB3,B) ) ).

fof(is_address_345,axiom,
    address(v50561_range_4_to_0_address_term_bound_3) ).

fof(address_association_297,axiom,
    v50561_range_4_to_0_address_association(constB3,v50561_range_4_to_0_address_term_bound_3) ).

fof(transient_address_definition_296,axiom,
    ! [B] :
      ( addressVal(v50561_range_4_to_0_address_term_bound_2,B)
    <=> v50561(constB2,B) ) ).

fof(is_address_344,axiom,
    address(v50561_range_4_to_0_address_term_bound_2) ).

fof(address_association_296,axiom,
    v50561_range_4_to_0_address_association(constB2,v50561_range_4_to_0_address_term_bound_2) ).

fof(transient_address_definition_295,axiom,
    ! [B] :
      ( addressVal(v50561_range_4_to_0_address_term_bound_1,B)
    <=> v50561(constB1,B) ) ).

fof(is_address_343,axiom,
    address(v50561_range_4_to_0_address_term_bound_1) ).

fof(address_association_295,axiom,
    v50561_range_4_to_0_address_association(constB1,v50561_range_4_to_0_address_term_bound_1) ).

fof(transient_address_definition_294,axiom,
    ! [B] :
      ( addressVal(v50561_range_4_to_0_address_term_bound_0,B)
    <=> v50561(constB0,B) ) ).

fof(is_address_342,axiom,
    address(v50561_range_4_to_0_address_term_bound_0) ).

fof(address_association_294,axiom,
    v50561_range_4_to_0_address_association(constB0,v50561_range_4_to_0_address_term_bound_0) ).

fof(address_false_msb_330,axiom,
    ~ addressVal(v49739_range_3_to_0_address_term_bound_20,bitIndex4) ).

fof(transient_address_definition_293,axiom,
    ( $true
    & ( addressVal(v49739_range_3_to_0_address_term_bound_20,bitIndex0)
    <=> v49739(constB20,bitIndex0) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_20,bitIndex1)
    <=> v49739(constB20,bitIndex1) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_20,bitIndex2)
    <=> v49739(constB20,bitIndex2) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_20,bitIndex3)
    <=> v49739(constB20,bitIndex3) ) ) ).

fof(is_address_341,axiom,
    address(v49739_range_3_to_0_address_term_bound_20) ).

fof(address_association_293,axiom,
    v49739_range_3_to_0_address_association(constB20,v49739_range_3_to_0_address_term_bound_20) ).

fof(address_false_msb_329,axiom,
    ~ addressVal(v49739_range_3_to_0_address_term_bound_19,bitIndex4) ).

fof(transient_address_definition_292,axiom,
    ( $true
    & ( addressVal(v49739_range_3_to_0_address_term_bound_19,bitIndex0)
    <=> v49739(constB19,bitIndex0) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_19,bitIndex1)
    <=> v49739(constB19,bitIndex1) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_19,bitIndex2)
    <=> v49739(constB19,bitIndex2) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_19,bitIndex3)
    <=> v49739(constB19,bitIndex3) ) ) ).

fof(is_address_340,axiom,
    address(v49739_range_3_to_0_address_term_bound_19) ).

fof(address_association_292,axiom,
    v49739_range_3_to_0_address_association(constB19,v49739_range_3_to_0_address_term_bound_19) ).

fof(address_false_msb_328,axiom,
    ~ addressVal(v49739_range_3_to_0_address_term_bound_18,bitIndex4) ).

fof(transient_address_definition_291,axiom,
    ( $true
    & ( addressVal(v49739_range_3_to_0_address_term_bound_18,bitIndex0)
    <=> v49739(constB18,bitIndex0) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_18,bitIndex1)
    <=> v49739(constB18,bitIndex1) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_18,bitIndex2)
    <=> v49739(constB18,bitIndex2) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_18,bitIndex3)
    <=> v49739(constB18,bitIndex3) ) ) ).

fof(is_address_339,axiom,
    address(v49739_range_3_to_0_address_term_bound_18) ).

fof(address_association_291,axiom,
    v49739_range_3_to_0_address_association(constB18,v49739_range_3_to_0_address_term_bound_18) ).

fof(address_false_msb_327,axiom,
    ~ addressVal(v49739_range_3_to_0_address_term_bound_17,bitIndex4) ).

fof(transient_address_definition_290,axiom,
    ( $true
    & ( addressVal(v49739_range_3_to_0_address_term_bound_17,bitIndex0)
    <=> v49739(constB17,bitIndex0) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_17,bitIndex1)
    <=> v49739(constB17,bitIndex1) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_17,bitIndex2)
    <=> v49739(constB17,bitIndex2) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_17,bitIndex3)
    <=> v49739(constB17,bitIndex3) ) ) ).

fof(is_address_338,axiom,
    address(v49739_range_3_to_0_address_term_bound_17) ).

fof(address_association_290,axiom,
    v49739_range_3_to_0_address_association(constB17,v49739_range_3_to_0_address_term_bound_17) ).

fof(address_false_msb_326,axiom,
    ~ addressVal(v49739_range_3_to_0_address_term_bound_16,bitIndex4) ).

fof(transient_address_definition_289,axiom,
    ( $true
    & ( addressVal(v49739_range_3_to_0_address_term_bound_16,bitIndex0)
    <=> v49739(constB16,bitIndex0) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_16,bitIndex1)
    <=> v49739(constB16,bitIndex1) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_16,bitIndex2)
    <=> v49739(constB16,bitIndex2) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_16,bitIndex3)
    <=> v49739(constB16,bitIndex3) ) ) ).

fof(is_address_337,axiom,
    address(v49739_range_3_to_0_address_term_bound_16) ).

fof(address_association_289,axiom,
    v49739_range_3_to_0_address_association(constB16,v49739_range_3_to_0_address_term_bound_16) ).

fof(address_false_msb_325,axiom,
    ~ addressVal(v49739_range_3_to_0_address_term_bound_15,bitIndex4) ).

fof(transient_address_definition_288,axiom,
    ( $true
    & ( addressVal(v49739_range_3_to_0_address_term_bound_15,bitIndex0)
    <=> v49739(constB15,bitIndex0) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_15,bitIndex1)
    <=> v49739(constB15,bitIndex1) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_15,bitIndex2)
    <=> v49739(constB15,bitIndex2) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_15,bitIndex3)
    <=> v49739(constB15,bitIndex3) ) ) ).

fof(is_address_336,axiom,
    address(v49739_range_3_to_0_address_term_bound_15) ).

fof(address_association_288,axiom,
    v49739_range_3_to_0_address_association(constB15,v49739_range_3_to_0_address_term_bound_15) ).

fof(address_false_msb_324,axiom,
    ~ addressVal(v49739_range_3_to_0_address_term_bound_14,bitIndex4) ).

fof(transient_address_definition_287,axiom,
    ( $true
    & ( addressVal(v49739_range_3_to_0_address_term_bound_14,bitIndex0)
    <=> v49739(constB14,bitIndex0) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_14,bitIndex1)
    <=> v49739(constB14,bitIndex1) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_14,bitIndex2)
    <=> v49739(constB14,bitIndex2) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_14,bitIndex3)
    <=> v49739(constB14,bitIndex3) ) ) ).

fof(is_address_335,axiom,
    address(v49739_range_3_to_0_address_term_bound_14) ).

fof(address_association_287,axiom,
    v49739_range_3_to_0_address_association(constB14,v49739_range_3_to_0_address_term_bound_14) ).

fof(address_false_msb_323,axiom,
    ~ addressVal(v49739_range_3_to_0_address_term_bound_13,bitIndex4) ).

fof(transient_address_definition_286,axiom,
    ( $true
    & ( addressVal(v49739_range_3_to_0_address_term_bound_13,bitIndex0)
    <=> v49739(constB13,bitIndex0) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_13,bitIndex1)
    <=> v49739(constB13,bitIndex1) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_13,bitIndex2)
    <=> v49739(constB13,bitIndex2) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_13,bitIndex3)
    <=> v49739(constB13,bitIndex3) ) ) ).

fof(is_address_334,axiom,
    address(v49739_range_3_to_0_address_term_bound_13) ).

fof(address_association_286,axiom,
    v49739_range_3_to_0_address_association(constB13,v49739_range_3_to_0_address_term_bound_13) ).

fof(address_false_msb_322,axiom,
    ~ addressVal(v49739_range_3_to_0_address_term_bound_12,bitIndex4) ).

fof(transient_address_definition_285,axiom,
    ( $true
    & ( addressVal(v49739_range_3_to_0_address_term_bound_12,bitIndex0)
    <=> v49739(constB12,bitIndex0) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_12,bitIndex1)
    <=> v49739(constB12,bitIndex1) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_12,bitIndex2)
    <=> v49739(constB12,bitIndex2) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_12,bitIndex3)
    <=> v49739(constB12,bitIndex3) ) ) ).

fof(is_address_333,axiom,
    address(v49739_range_3_to_0_address_term_bound_12) ).

fof(address_association_285,axiom,
    v49739_range_3_to_0_address_association(constB12,v49739_range_3_to_0_address_term_bound_12) ).

fof(address_false_msb_321,axiom,
    ~ addressVal(v49739_range_3_to_0_address_term_bound_11,bitIndex4) ).

fof(transient_address_definition_284,axiom,
    ( $true
    & ( addressVal(v49739_range_3_to_0_address_term_bound_11,bitIndex0)
    <=> v49739(constB11,bitIndex0) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_11,bitIndex1)
    <=> v49739(constB11,bitIndex1) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_11,bitIndex2)
    <=> v49739(constB11,bitIndex2) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_11,bitIndex3)
    <=> v49739(constB11,bitIndex3) ) ) ).

fof(is_address_332,axiom,
    address(v49739_range_3_to_0_address_term_bound_11) ).

fof(address_association_284,axiom,
    v49739_range_3_to_0_address_association(constB11,v49739_range_3_to_0_address_term_bound_11) ).

fof(address_false_msb_320,axiom,
    ~ addressVal(v49739_range_3_to_0_address_term_bound_10,bitIndex4) ).

fof(transient_address_definition_283,axiom,
    ( $true
    & ( addressVal(v49739_range_3_to_0_address_term_bound_10,bitIndex0)
    <=> v49739(constB10,bitIndex0) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_10,bitIndex1)
    <=> v49739(constB10,bitIndex1) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_10,bitIndex2)
    <=> v49739(constB10,bitIndex2) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_10,bitIndex3)
    <=> v49739(constB10,bitIndex3) ) ) ).

fof(is_address_331,axiom,
    address(v49739_range_3_to_0_address_term_bound_10) ).

fof(address_association_283,axiom,
    v49739_range_3_to_0_address_association(constB10,v49739_range_3_to_0_address_term_bound_10) ).

fof(address_false_msb_319,axiom,
    ~ addressVal(v49739_range_3_to_0_address_term_bound_9,bitIndex4) ).

fof(transient_address_definition_282,axiom,
    ( $true
    & ( addressVal(v49739_range_3_to_0_address_term_bound_9,bitIndex0)
    <=> v49739(constB9,bitIndex0) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_9,bitIndex1)
    <=> v49739(constB9,bitIndex1) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_9,bitIndex2)
    <=> v49739(constB9,bitIndex2) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_9,bitIndex3)
    <=> v49739(constB9,bitIndex3) ) ) ).

fof(is_address_330,axiom,
    address(v49739_range_3_to_0_address_term_bound_9) ).

fof(address_association_282,axiom,
    v49739_range_3_to_0_address_association(constB9,v49739_range_3_to_0_address_term_bound_9) ).

fof(address_false_msb_318,axiom,
    ~ addressVal(v49739_range_3_to_0_address_term_bound_8,bitIndex4) ).

fof(transient_address_definition_281,axiom,
    ( $true
    & ( addressVal(v49739_range_3_to_0_address_term_bound_8,bitIndex0)
    <=> v49739(constB8,bitIndex0) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_8,bitIndex1)
    <=> v49739(constB8,bitIndex1) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_8,bitIndex2)
    <=> v49739(constB8,bitIndex2) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_8,bitIndex3)
    <=> v49739(constB8,bitIndex3) ) ) ).

fof(is_address_329,axiom,
    address(v49739_range_3_to_0_address_term_bound_8) ).

fof(address_association_281,axiom,
    v49739_range_3_to_0_address_association(constB8,v49739_range_3_to_0_address_term_bound_8) ).

fof(address_false_msb_317,axiom,
    ~ addressVal(v49739_range_3_to_0_address_term_bound_7,bitIndex4) ).

fof(transient_address_definition_280,axiom,
    ( $true
    & ( addressVal(v49739_range_3_to_0_address_term_bound_7,bitIndex0)
    <=> v49739(constB7,bitIndex0) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_7,bitIndex1)
    <=> v49739(constB7,bitIndex1) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_7,bitIndex2)
    <=> v49739(constB7,bitIndex2) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_7,bitIndex3)
    <=> v49739(constB7,bitIndex3) ) ) ).

fof(is_address_328,axiom,
    address(v49739_range_3_to_0_address_term_bound_7) ).

fof(address_association_280,axiom,
    v49739_range_3_to_0_address_association(constB7,v49739_range_3_to_0_address_term_bound_7) ).

fof(address_false_msb_316,axiom,
    ~ addressVal(v49739_range_3_to_0_address_term_bound_6,bitIndex4) ).

fof(transient_address_definition_279,axiom,
    ( $true
    & ( addressVal(v49739_range_3_to_0_address_term_bound_6,bitIndex0)
    <=> v49739(constB6,bitIndex0) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_6,bitIndex1)
    <=> v49739(constB6,bitIndex1) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_6,bitIndex2)
    <=> v49739(constB6,bitIndex2) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_6,bitIndex3)
    <=> v49739(constB6,bitIndex3) ) ) ).

fof(is_address_327,axiom,
    address(v49739_range_3_to_0_address_term_bound_6) ).

fof(address_association_279,axiom,
    v49739_range_3_to_0_address_association(constB6,v49739_range_3_to_0_address_term_bound_6) ).

fof(address_false_msb_315,axiom,
    ~ addressVal(v49739_range_3_to_0_address_term_bound_5,bitIndex4) ).

fof(transient_address_definition_278,axiom,
    ( $true
    & ( addressVal(v49739_range_3_to_0_address_term_bound_5,bitIndex0)
    <=> v49739(constB5,bitIndex0) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_5,bitIndex1)
    <=> v49739(constB5,bitIndex1) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_5,bitIndex2)
    <=> v49739(constB5,bitIndex2) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_5,bitIndex3)
    <=> v49739(constB5,bitIndex3) ) ) ).

fof(is_address_326,axiom,
    address(v49739_range_3_to_0_address_term_bound_5) ).

fof(address_association_278,axiom,
    v49739_range_3_to_0_address_association(constB5,v49739_range_3_to_0_address_term_bound_5) ).

fof(address_false_msb_314,axiom,
    ~ addressVal(v49739_range_3_to_0_address_term_bound_4,bitIndex4) ).

fof(transient_address_definition_277,axiom,
    ( $true
    & ( addressVal(v49739_range_3_to_0_address_term_bound_4,bitIndex0)
    <=> v49739(constB4,bitIndex0) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_4,bitIndex1)
    <=> v49739(constB4,bitIndex1) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_4,bitIndex2)
    <=> v49739(constB4,bitIndex2) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_4,bitIndex3)
    <=> v49739(constB4,bitIndex3) ) ) ).

fof(is_address_325,axiom,
    address(v49739_range_3_to_0_address_term_bound_4) ).

fof(address_association_277,axiom,
    v49739_range_3_to_0_address_association(constB4,v49739_range_3_to_0_address_term_bound_4) ).

fof(address_false_msb_313,axiom,
    ~ addressVal(v49739_range_3_to_0_address_term_bound_3,bitIndex4) ).

fof(transient_address_definition_276,axiom,
    ( $true
    & ( addressVal(v49739_range_3_to_0_address_term_bound_3,bitIndex0)
    <=> v49739(constB3,bitIndex0) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_3,bitIndex1)
    <=> v49739(constB3,bitIndex1) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_3,bitIndex2)
    <=> v49739(constB3,bitIndex2) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_3,bitIndex3)
    <=> v49739(constB3,bitIndex3) ) ) ).

fof(is_address_324,axiom,
    address(v49739_range_3_to_0_address_term_bound_3) ).

fof(address_association_276,axiom,
    v49739_range_3_to_0_address_association(constB3,v49739_range_3_to_0_address_term_bound_3) ).

fof(address_false_msb_312,axiom,
    ~ addressVal(v49739_range_3_to_0_address_term_bound_2,bitIndex4) ).

fof(transient_address_definition_275,axiom,
    ( $true
    & ( addressVal(v49739_range_3_to_0_address_term_bound_2,bitIndex0)
    <=> v49739(constB2,bitIndex0) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_2,bitIndex1)
    <=> v49739(constB2,bitIndex1) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_2,bitIndex2)
    <=> v49739(constB2,bitIndex2) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_2,bitIndex3)
    <=> v49739(constB2,bitIndex3) ) ) ).

fof(is_address_323,axiom,
    address(v49739_range_3_to_0_address_term_bound_2) ).

fof(address_association_275,axiom,
    v49739_range_3_to_0_address_association(constB2,v49739_range_3_to_0_address_term_bound_2) ).

fof(address_false_msb_311,axiom,
    ~ addressVal(v49739_range_3_to_0_address_term_bound_1,bitIndex4) ).

fof(transient_address_definition_274,axiom,
    ( $true
    & ( addressVal(v49739_range_3_to_0_address_term_bound_1,bitIndex0)
    <=> v49739(constB1,bitIndex0) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_1,bitIndex1)
    <=> v49739(constB1,bitIndex1) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_1,bitIndex2)
    <=> v49739(constB1,bitIndex2) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_1,bitIndex3)
    <=> v49739(constB1,bitIndex3) ) ) ).

fof(is_address_322,axiom,
    address(v49739_range_3_to_0_address_term_bound_1) ).

fof(address_association_274,axiom,
    v49739_range_3_to_0_address_association(constB1,v49739_range_3_to_0_address_term_bound_1) ).

fof(address_false_msb_310,axiom,
    ~ addressVal(v49739_range_3_to_0_address_term_bound_0,bitIndex4) ).

fof(transient_address_definition_273,axiom,
    ( $true
    & ( addressVal(v49739_range_3_to_0_address_term_bound_0,bitIndex0)
    <=> v49739(constB0,bitIndex0) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_0,bitIndex1)
    <=> v49739(constB0,bitIndex1) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_0,bitIndex2)
    <=> v49739(constB0,bitIndex2) )
    & ( addressVal(v49739_range_3_to_0_address_term_bound_0,bitIndex3)
    <=> v49739(constB0,bitIndex3) ) ) ).

fof(is_address_321,axiom,
    address(v49739_range_3_to_0_address_term_bound_0) ).

fof(address_association_273,axiom,
    v49739_range_3_to_0_address_association(constB0,v49739_range_3_to_0_address_term_bound_0) ).

fof(transient_address_definition_272,axiom,
    ! [B] :
      ( addressVal(v49258_range_4_to_0_address_term_bound_20,B)
    <=> v49258(constB20,B) ) ).

fof(is_address_320,axiom,
    address(v49258_range_4_to_0_address_term_bound_20) ).

fof(address_association_272,axiom,
    v49258_range_4_to_0_address_association(constB20,v49258_range_4_to_0_address_term_bound_20) ).

fof(transient_address_definition_271,axiom,
    ! [B] :
      ( addressVal(v49258_range_4_to_0_address_term_bound_19,B)
    <=> v49258(constB19,B) ) ).

fof(is_address_319,axiom,
    address(v49258_range_4_to_0_address_term_bound_19) ).

fof(address_association_271,axiom,
    v49258_range_4_to_0_address_association(constB19,v49258_range_4_to_0_address_term_bound_19) ).

fof(transient_address_definition_270,axiom,
    ! [B] :
      ( addressVal(v49258_range_4_to_0_address_term_bound_18,B)
    <=> v49258(constB18,B) ) ).

fof(is_address_318,axiom,
    address(v49258_range_4_to_0_address_term_bound_18) ).

fof(address_association_270,axiom,
    v49258_range_4_to_0_address_association(constB18,v49258_range_4_to_0_address_term_bound_18) ).

fof(transient_address_definition_269,axiom,
    ! [B] :
      ( addressVal(v49258_range_4_to_0_address_term_bound_17,B)
    <=> v49258(constB17,B) ) ).

fof(is_address_317,axiom,
    address(v49258_range_4_to_0_address_term_bound_17) ).

fof(address_association_269,axiom,
    v49258_range_4_to_0_address_association(constB17,v49258_range_4_to_0_address_term_bound_17) ).

fof(transient_address_definition_268,axiom,
    ! [B] :
      ( addressVal(v49258_range_4_to_0_address_term_bound_16,B)
    <=> v49258(constB16,B) ) ).

fof(is_address_316,axiom,
    address(v49258_range_4_to_0_address_term_bound_16) ).

fof(address_association_268,axiom,
    v49258_range_4_to_0_address_association(constB16,v49258_range_4_to_0_address_term_bound_16) ).

fof(transient_address_definition_267,axiom,
    ! [B] :
      ( addressVal(v49258_range_4_to_0_address_term_bound_15,B)
    <=> v49258(constB15,B) ) ).

fof(is_address_315,axiom,
    address(v49258_range_4_to_0_address_term_bound_15) ).

fof(address_association_267,axiom,
    v49258_range_4_to_0_address_association(constB15,v49258_range_4_to_0_address_term_bound_15) ).

fof(transient_address_definition_266,axiom,
    ! [B] :
      ( addressVal(v49258_range_4_to_0_address_term_bound_14,B)
    <=> v49258(constB14,B) ) ).

fof(is_address_314,axiom,
    address(v49258_range_4_to_0_address_term_bound_14) ).

fof(address_association_266,axiom,
    v49258_range_4_to_0_address_association(constB14,v49258_range_4_to_0_address_term_bound_14) ).

fof(transient_address_definition_265,axiom,
    ! [B] :
      ( addressVal(v49258_range_4_to_0_address_term_bound_13,B)
    <=> v49258(constB13,B) ) ).

fof(is_address_313,axiom,
    address(v49258_range_4_to_0_address_term_bound_13) ).

fof(address_association_265,axiom,
    v49258_range_4_to_0_address_association(constB13,v49258_range_4_to_0_address_term_bound_13) ).

fof(transient_address_definition_264,axiom,
    ! [B] :
      ( addressVal(v49258_range_4_to_0_address_term_bound_12,B)
    <=> v49258(constB12,B) ) ).

fof(is_address_312,axiom,
    address(v49258_range_4_to_0_address_term_bound_12) ).

fof(address_association_264,axiom,
    v49258_range_4_to_0_address_association(constB12,v49258_range_4_to_0_address_term_bound_12) ).

fof(transient_address_definition_263,axiom,
    ! [B] :
      ( addressVal(v49258_range_4_to_0_address_term_bound_11,B)
    <=> v49258(constB11,B) ) ).

fof(is_address_311,axiom,
    address(v49258_range_4_to_0_address_term_bound_11) ).

fof(address_association_263,axiom,
    v49258_range_4_to_0_address_association(constB11,v49258_range_4_to_0_address_term_bound_11) ).

fof(transient_address_definition_262,axiom,
    ! [B] :
      ( addressVal(v49258_range_4_to_0_address_term_bound_10,B)
    <=> v49258(constB10,B) ) ).

fof(is_address_310,axiom,
    address(v49258_range_4_to_0_address_term_bound_10) ).

fof(address_association_262,axiom,
    v49258_range_4_to_0_address_association(constB10,v49258_range_4_to_0_address_term_bound_10) ).

fof(transient_address_definition_261,axiom,
    ! [B] :
      ( addressVal(v49258_range_4_to_0_address_term_bound_9,B)
    <=> v49258(constB9,B) ) ).

fof(is_address_309,axiom,
    address(v49258_range_4_to_0_address_term_bound_9) ).

fof(address_association_261,axiom,
    v49258_range_4_to_0_address_association(constB9,v49258_range_4_to_0_address_term_bound_9) ).

fof(transient_address_definition_260,axiom,
    ! [B] :
      ( addressVal(v49258_range_4_to_0_address_term_bound_8,B)
    <=> v49258(constB8,B) ) ).

fof(is_address_308,axiom,
    address(v49258_range_4_to_0_address_term_bound_8) ).

fof(address_association_260,axiom,
    v49258_range_4_to_0_address_association(constB8,v49258_range_4_to_0_address_term_bound_8) ).

fof(transient_address_definition_259,axiom,
    ! [B] :
      ( addressVal(v49258_range_4_to_0_address_term_bound_7,B)
    <=> v49258(constB7,B) ) ).

fof(is_address_307,axiom,
    address(v49258_range_4_to_0_address_term_bound_7) ).

fof(address_association_259,axiom,
    v49258_range_4_to_0_address_association(constB7,v49258_range_4_to_0_address_term_bound_7) ).

fof(transient_address_definition_258,axiom,
    ! [B] :
      ( addressVal(v49258_range_4_to_0_address_term_bound_6,B)
    <=> v49258(constB6,B) ) ).

fof(is_address_306,axiom,
    address(v49258_range_4_to_0_address_term_bound_6) ).

fof(address_association_258,axiom,
    v49258_range_4_to_0_address_association(constB6,v49258_range_4_to_0_address_term_bound_6) ).

fof(transient_address_definition_257,axiom,
    ! [B] :
      ( addressVal(v49258_range_4_to_0_address_term_bound_5,B)
    <=> v49258(constB5,B) ) ).

fof(is_address_305,axiom,
    address(v49258_range_4_to_0_address_term_bound_5) ).

fof(address_association_257,axiom,
    v49258_range_4_to_0_address_association(constB5,v49258_range_4_to_0_address_term_bound_5) ).

fof(transient_address_definition_256,axiom,
    ! [B] :
      ( addressVal(v49258_range_4_to_0_address_term_bound_4,B)
    <=> v49258(constB4,B) ) ).

fof(is_address_304,axiom,
    address(v49258_range_4_to_0_address_term_bound_4) ).

fof(address_association_256,axiom,
    v49258_range_4_to_0_address_association(constB4,v49258_range_4_to_0_address_term_bound_4) ).

fof(transient_address_definition_255,axiom,
    ! [B] :
      ( addressVal(v49258_range_4_to_0_address_term_bound_3,B)
    <=> v49258(constB3,B) ) ).

fof(is_address_303,axiom,
    address(v49258_range_4_to_0_address_term_bound_3) ).

fof(address_association_255,axiom,
    v49258_range_4_to_0_address_association(constB3,v49258_range_4_to_0_address_term_bound_3) ).

fof(transient_address_definition_254,axiom,
    ! [B] :
      ( addressVal(v49258_range_4_to_0_address_term_bound_2,B)
    <=> v49258(constB2,B) ) ).

fof(is_address_302,axiom,
    address(v49258_range_4_to_0_address_term_bound_2) ).

fof(address_association_254,axiom,
    v49258_range_4_to_0_address_association(constB2,v49258_range_4_to_0_address_term_bound_2) ).

fof(transient_address_definition_253,axiom,
    ! [B] :
      ( addressVal(v49258_range_4_to_0_address_term_bound_1,B)
    <=> v49258(constB1,B) ) ).

fof(is_address_301,axiom,
    address(v49258_range_4_to_0_address_term_bound_1) ).

fof(address_association_253,axiom,
    v49258_range_4_to_0_address_association(constB1,v49258_range_4_to_0_address_term_bound_1) ).

fof(transient_address_definition_252,axiom,
    ! [B] :
      ( addressVal(v49258_range_4_to_0_address_term_bound_0,B)
    <=> v49258(constB0,B) ) ).

fof(is_address_300,axiom,
    address(v49258_range_4_to_0_address_term_bound_0) ).

fof(address_association_252,axiom,
    v49258_range_4_to_0_address_association(constB0,v49258_range_4_to_0_address_term_bound_0) ).

fof(transient_address_definition_251,axiom,
    ! [B] :
      ( addressVal(v49218_range_4_to_0_address_term_bound_20,B)
    <=> v49218(constB20,B) ) ).

fof(is_address_299,axiom,
    address(v49218_range_4_to_0_address_term_bound_20) ).

fof(address_association_251,axiom,
    v49218_range_4_to_0_address_association(constB20,v49218_range_4_to_0_address_term_bound_20) ).

fof(transient_address_definition_250,axiom,
    ! [B] :
      ( addressVal(v49218_range_4_to_0_address_term_bound_19,B)
    <=> v49218(constB19,B) ) ).

fof(is_address_298,axiom,
    address(v49218_range_4_to_0_address_term_bound_19) ).

fof(address_association_250,axiom,
    v49218_range_4_to_0_address_association(constB19,v49218_range_4_to_0_address_term_bound_19) ).

fof(transient_address_definition_249,axiom,
    ! [B] :
      ( addressVal(v49218_range_4_to_0_address_term_bound_18,B)
    <=> v49218(constB18,B) ) ).

fof(is_address_297,axiom,
    address(v49218_range_4_to_0_address_term_bound_18) ).

fof(address_association_249,axiom,
    v49218_range_4_to_0_address_association(constB18,v49218_range_4_to_0_address_term_bound_18) ).

fof(transient_address_definition_248,axiom,
    ! [B] :
      ( addressVal(v49218_range_4_to_0_address_term_bound_17,B)
    <=> v49218(constB17,B) ) ).

fof(is_address_296,axiom,
    address(v49218_range_4_to_0_address_term_bound_17) ).

fof(address_association_248,axiom,
    v49218_range_4_to_0_address_association(constB17,v49218_range_4_to_0_address_term_bound_17) ).

fof(transient_address_definition_247,axiom,
    ! [B] :
      ( addressVal(v49218_range_4_to_0_address_term_bound_16,B)
    <=> v49218(constB16,B) ) ).

fof(is_address_295,axiom,
    address(v49218_range_4_to_0_address_term_bound_16) ).

fof(address_association_247,axiom,
    v49218_range_4_to_0_address_association(constB16,v49218_range_4_to_0_address_term_bound_16) ).

fof(transient_address_definition_246,axiom,
    ! [B] :
      ( addressVal(v49218_range_4_to_0_address_term_bound_15,B)
    <=> v49218(constB15,B) ) ).

fof(is_address_294,axiom,
    address(v49218_range_4_to_0_address_term_bound_15) ).

fof(address_association_246,axiom,
    v49218_range_4_to_0_address_association(constB15,v49218_range_4_to_0_address_term_bound_15) ).

fof(transient_address_definition_245,axiom,
    ! [B] :
      ( addressVal(v49218_range_4_to_0_address_term_bound_14,B)
    <=> v49218(constB14,B) ) ).

fof(is_address_293,axiom,
    address(v49218_range_4_to_0_address_term_bound_14) ).

fof(address_association_245,axiom,
    v49218_range_4_to_0_address_association(constB14,v49218_range_4_to_0_address_term_bound_14) ).

fof(transient_address_definition_244,axiom,
    ! [B] :
      ( addressVal(v49218_range_4_to_0_address_term_bound_13,B)
    <=> v49218(constB13,B) ) ).

fof(is_address_292,axiom,
    address(v49218_range_4_to_0_address_term_bound_13) ).

fof(address_association_244,axiom,
    v49218_range_4_to_0_address_association(constB13,v49218_range_4_to_0_address_term_bound_13) ).

fof(transient_address_definition_243,axiom,
    ! [B] :
      ( addressVal(v49218_range_4_to_0_address_term_bound_12,B)
    <=> v49218(constB12,B) ) ).

fof(is_address_291,axiom,
    address(v49218_range_4_to_0_address_term_bound_12) ).

fof(address_association_243,axiom,
    v49218_range_4_to_0_address_association(constB12,v49218_range_4_to_0_address_term_bound_12) ).

fof(transient_address_definition_242,axiom,
    ! [B] :
      ( addressVal(v49218_range_4_to_0_address_term_bound_11,B)
    <=> v49218(constB11,B) ) ).

fof(is_address_290,axiom,
    address(v49218_range_4_to_0_address_term_bound_11) ).

fof(address_association_242,axiom,
    v49218_range_4_to_0_address_association(constB11,v49218_range_4_to_0_address_term_bound_11) ).

fof(transient_address_definition_241,axiom,
    ! [B] :
      ( addressVal(v49218_range_4_to_0_address_term_bound_10,B)
    <=> v49218(constB10,B) ) ).

fof(is_address_289,axiom,
    address(v49218_range_4_to_0_address_term_bound_10) ).

fof(address_association_241,axiom,
    v49218_range_4_to_0_address_association(constB10,v49218_range_4_to_0_address_term_bound_10) ).

fof(transient_address_definition_240,axiom,
    ! [B] :
      ( addressVal(v49218_range_4_to_0_address_term_bound_9,B)
    <=> v49218(constB9,B) ) ).

fof(is_address_288,axiom,
    address(v49218_range_4_to_0_address_term_bound_9) ).

fof(address_association_240,axiom,
    v49218_range_4_to_0_address_association(constB9,v49218_range_4_to_0_address_term_bound_9) ).

fof(transient_address_definition_239,axiom,
    ! [B] :
      ( addressVal(v49218_range_4_to_0_address_term_bound_8,B)
    <=> v49218(constB8,B) ) ).

fof(is_address_287,axiom,
    address(v49218_range_4_to_0_address_term_bound_8) ).

fof(address_association_239,axiom,
    v49218_range_4_to_0_address_association(constB8,v49218_range_4_to_0_address_term_bound_8) ).

fof(transient_address_definition_238,axiom,
    ! [B] :
      ( addressVal(v49218_range_4_to_0_address_term_bound_7,B)
    <=> v49218(constB7,B) ) ).

fof(is_address_286,axiom,
    address(v49218_range_4_to_0_address_term_bound_7) ).

fof(address_association_238,axiom,
    v49218_range_4_to_0_address_association(constB7,v49218_range_4_to_0_address_term_bound_7) ).

fof(transient_address_definition_237,axiom,
    ! [B] :
      ( addressVal(v49218_range_4_to_0_address_term_bound_6,B)
    <=> v49218(constB6,B) ) ).

fof(is_address_285,axiom,
    address(v49218_range_4_to_0_address_term_bound_6) ).

fof(address_association_237,axiom,
    v49218_range_4_to_0_address_association(constB6,v49218_range_4_to_0_address_term_bound_6) ).

fof(transient_address_definition_236,axiom,
    ! [B] :
      ( addressVal(v49218_range_4_to_0_address_term_bound_5,B)
    <=> v49218(constB5,B) ) ).

fof(is_address_284,axiom,
    address(v49218_range_4_to_0_address_term_bound_5) ).

fof(address_association_236,axiom,
    v49218_range_4_to_0_address_association(constB5,v49218_range_4_to_0_address_term_bound_5) ).

fof(transient_address_definition_235,axiom,
    ! [B] :
      ( addressVal(v49218_range_4_to_0_address_term_bound_4,B)
    <=> v49218(constB4,B) ) ).

fof(is_address_283,axiom,
    address(v49218_range_4_to_0_address_term_bound_4) ).

fof(address_association_235,axiom,
    v49218_range_4_to_0_address_association(constB4,v49218_range_4_to_0_address_term_bound_4) ).

fof(transient_address_definition_234,axiom,
    ! [B] :
      ( addressVal(v49218_range_4_to_0_address_term_bound_3,B)
    <=> v49218(constB3,B) ) ).

fof(is_address_282,axiom,
    address(v49218_range_4_to_0_address_term_bound_3) ).

fof(address_association_234,axiom,
    v49218_range_4_to_0_address_association(constB3,v49218_range_4_to_0_address_term_bound_3) ).

fof(transient_address_definition_233,axiom,
    ! [B] :
      ( addressVal(v49218_range_4_to_0_address_term_bound_2,B)
    <=> v49218(constB2,B) ) ).

fof(is_address_281,axiom,
    address(v49218_range_4_to_0_address_term_bound_2) ).

fof(address_association_233,axiom,
    v49218_range_4_to_0_address_association(constB2,v49218_range_4_to_0_address_term_bound_2) ).

fof(transient_address_definition_232,axiom,
    ! [B] :
      ( addressVal(v49218_range_4_to_0_address_term_bound_1,B)
    <=> v49218(constB1,B) ) ).

fof(is_address_280,axiom,
    address(v49218_range_4_to_0_address_term_bound_1) ).

fof(address_association_232,axiom,
    v49218_range_4_to_0_address_association(constB1,v49218_range_4_to_0_address_term_bound_1) ).

fof(transient_address_definition_231,axiom,
    ! [B] :
      ( addressVal(v49218_range_4_to_0_address_term_bound_0,B)
    <=> v49218(constB0,B) ) ).

fof(is_address_279,axiom,
    address(v49218_range_4_to_0_address_term_bound_0) ).

fof(address_association_231,axiom,
    v49218_range_4_to_0_address_association(constB0,v49218_range_4_to_0_address_term_bound_0) ).

fof(transient_address_definition_230,axiom,
    ! [B] :
      ( addressVal(v48599_range_4_to_0_address_term_bound_20,B)
    <=> v48599(constB20,B) ) ).

fof(is_address_278,axiom,
    address(v48599_range_4_to_0_address_term_bound_20) ).

fof(address_association_230,axiom,
    v48599_range_4_to_0_address_association(constB20,v48599_range_4_to_0_address_term_bound_20) ).

fof(transient_address_definition_229,axiom,
    ! [B] :
      ( addressVal(v48599_range_4_to_0_address_term_bound_19,B)
    <=> v48599(constB19,B) ) ).

fof(is_address_277,axiom,
    address(v48599_range_4_to_0_address_term_bound_19) ).

fof(address_association_229,axiom,
    v48599_range_4_to_0_address_association(constB19,v48599_range_4_to_0_address_term_bound_19) ).

fof(transient_address_definition_228,axiom,
    ! [B] :
      ( addressVal(v48599_range_4_to_0_address_term_bound_18,B)
    <=> v48599(constB18,B) ) ).

fof(is_address_276,axiom,
    address(v48599_range_4_to_0_address_term_bound_18) ).

fof(address_association_228,axiom,
    v48599_range_4_to_0_address_association(constB18,v48599_range_4_to_0_address_term_bound_18) ).

fof(transient_address_definition_227,axiom,
    ! [B] :
      ( addressVal(v48599_range_4_to_0_address_term_bound_17,B)
    <=> v48599(constB17,B) ) ).

fof(is_address_275,axiom,
    address(v48599_range_4_to_0_address_term_bound_17) ).

fof(address_association_227,axiom,
    v48599_range_4_to_0_address_association(constB17,v48599_range_4_to_0_address_term_bound_17) ).

fof(transient_address_definition_226,axiom,
    ! [B] :
      ( addressVal(v48599_range_4_to_0_address_term_bound_16,B)
    <=> v48599(constB16,B) ) ).

fof(is_address_274,axiom,
    address(v48599_range_4_to_0_address_term_bound_16) ).

fof(address_association_226,axiom,
    v48599_range_4_to_0_address_association(constB16,v48599_range_4_to_0_address_term_bound_16) ).

fof(transient_address_definition_225,axiom,
    ! [B] :
      ( addressVal(v48599_range_4_to_0_address_term_bound_15,B)
    <=> v48599(constB15,B) ) ).

fof(is_address_273,axiom,
    address(v48599_range_4_to_0_address_term_bound_15) ).

fof(address_association_225,axiom,
    v48599_range_4_to_0_address_association(constB15,v48599_range_4_to_0_address_term_bound_15) ).

fof(transient_address_definition_224,axiom,
    ! [B] :
      ( addressVal(v48599_range_4_to_0_address_term_bound_14,B)
    <=> v48599(constB14,B) ) ).

fof(is_address_272,axiom,
    address(v48599_range_4_to_0_address_term_bound_14) ).

fof(address_association_224,axiom,
    v48599_range_4_to_0_address_association(constB14,v48599_range_4_to_0_address_term_bound_14) ).

fof(transient_address_definition_223,axiom,
    ! [B] :
      ( addressVal(v48599_range_4_to_0_address_term_bound_13,B)
    <=> v48599(constB13,B) ) ).

fof(is_address_271,axiom,
    address(v48599_range_4_to_0_address_term_bound_13) ).

fof(address_association_223,axiom,
    v48599_range_4_to_0_address_association(constB13,v48599_range_4_to_0_address_term_bound_13) ).

fof(transient_address_definition_222,axiom,
    ! [B] :
      ( addressVal(v48599_range_4_to_0_address_term_bound_12,B)
    <=> v48599(constB12,B) ) ).

fof(is_address_270,axiom,
    address(v48599_range_4_to_0_address_term_bound_12) ).

fof(address_association_222,axiom,
    v48599_range_4_to_0_address_association(constB12,v48599_range_4_to_0_address_term_bound_12) ).

fof(transient_address_definition_221,axiom,
    ! [B] :
      ( addressVal(v48599_range_4_to_0_address_term_bound_11,B)
    <=> v48599(constB11,B) ) ).

fof(is_address_269,axiom,
    address(v48599_range_4_to_0_address_term_bound_11) ).

fof(address_association_221,axiom,
    v48599_range_4_to_0_address_association(constB11,v48599_range_4_to_0_address_term_bound_11) ).

fof(transient_address_definition_220,axiom,
    ! [B] :
      ( addressVal(v48599_range_4_to_0_address_term_bound_10,B)
    <=> v48599(constB10,B) ) ).

fof(is_address_268,axiom,
    address(v48599_range_4_to_0_address_term_bound_10) ).

fof(address_association_220,axiom,
    v48599_range_4_to_0_address_association(constB10,v48599_range_4_to_0_address_term_bound_10) ).

fof(transient_address_definition_219,axiom,
    ! [B] :
      ( addressVal(v48599_range_4_to_0_address_term_bound_9,B)
    <=> v48599(constB9,B) ) ).

fof(is_address_267,axiom,
    address(v48599_range_4_to_0_address_term_bound_9) ).

fof(address_association_219,axiom,
    v48599_range_4_to_0_address_association(constB9,v48599_range_4_to_0_address_term_bound_9) ).

fof(transient_address_definition_218,axiom,
    ! [B] :
      ( addressVal(v48599_range_4_to_0_address_term_bound_8,B)
    <=> v48599(constB8,B) ) ).

fof(is_address_266,axiom,
    address(v48599_range_4_to_0_address_term_bound_8) ).

fof(address_association_218,axiom,
    v48599_range_4_to_0_address_association(constB8,v48599_range_4_to_0_address_term_bound_8) ).

fof(transient_address_definition_217,axiom,
    ! [B] :
      ( addressVal(v48599_range_4_to_0_address_term_bound_7,B)
    <=> v48599(constB7,B) ) ).

fof(is_address_265,axiom,
    address(v48599_range_4_to_0_address_term_bound_7) ).

fof(address_association_217,axiom,
    v48599_range_4_to_0_address_association(constB7,v48599_range_4_to_0_address_term_bound_7) ).

fof(transient_address_definition_216,axiom,
    ! [B] :
      ( addressVal(v48599_range_4_to_0_address_term_bound_6,B)
    <=> v48599(constB6,B) ) ).

fof(is_address_264,axiom,
    address(v48599_range_4_to_0_address_term_bound_6) ).

fof(address_association_216,axiom,
    v48599_range_4_to_0_address_association(constB6,v48599_range_4_to_0_address_term_bound_6) ).

fof(transient_address_definition_215,axiom,
    ! [B] :
      ( addressVal(v48599_range_4_to_0_address_term_bound_5,B)
    <=> v48599(constB5,B) ) ).

fof(is_address_263,axiom,
    address(v48599_range_4_to_0_address_term_bound_5) ).

fof(address_association_215,axiom,
    v48599_range_4_to_0_address_association(constB5,v48599_range_4_to_0_address_term_bound_5) ).

fof(transient_address_definition_214,axiom,
    ! [B] :
      ( addressVal(v48599_range_4_to_0_address_term_bound_4,B)
    <=> v48599(constB4,B) ) ).

fof(is_address_262,axiom,
    address(v48599_range_4_to_0_address_term_bound_4) ).

fof(address_association_214,axiom,
    v48599_range_4_to_0_address_association(constB4,v48599_range_4_to_0_address_term_bound_4) ).

fof(transient_address_definition_213,axiom,
    ! [B] :
      ( addressVal(v48599_range_4_to_0_address_term_bound_3,B)
    <=> v48599(constB3,B) ) ).

fof(is_address_261,axiom,
    address(v48599_range_4_to_0_address_term_bound_3) ).

fof(address_association_213,axiom,
    v48599_range_4_to_0_address_association(constB3,v48599_range_4_to_0_address_term_bound_3) ).

fof(transient_address_definition_212,axiom,
    ! [B] :
      ( addressVal(v48599_range_4_to_0_address_term_bound_2,B)
    <=> v48599(constB2,B) ) ).

fof(is_address_260,axiom,
    address(v48599_range_4_to_0_address_term_bound_2) ).

fof(address_association_212,axiom,
    v48599_range_4_to_0_address_association(constB2,v48599_range_4_to_0_address_term_bound_2) ).

fof(transient_address_definition_211,axiom,
    ! [B] :
      ( addressVal(v48599_range_4_to_0_address_term_bound_1,B)
    <=> v48599(constB1,B) ) ).

fof(is_address_259,axiom,
    address(v48599_range_4_to_0_address_term_bound_1) ).

fof(address_association_211,axiom,
    v48599_range_4_to_0_address_association(constB1,v48599_range_4_to_0_address_term_bound_1) ).

fof(transient_address_definition_210,axiom,
    ! [B] :
      ( addressVal(v48599_range_4_to_0_address_term_bound_0,B)
    <=> v48599(constB0,B) ) ).

fof(is_address_258,axiom,
    address(v48599_range_4_to_0_address_term_bound_0) ).

fof(address_association_210,axiom,
    v48599_range_4_to_0_address_association(constB0,v48599_range_4_to_0_address_term_bound_0) ).

fof(address_false_msb_309,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_20,bitIndex4) ).

fof(address_false_msb_308,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_20,bitIndex3) ).

fof(transient_address_definition_209,axiom,
    ( $true
    & ( addressVal(v47299_range_2_to_0_address_term_bound_20,bitIndex0)
    <=> v47299(constB20,bitIndex0) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_20,bitIndex1)
    <=> v47299(constB20,bitIndex1) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_20,bitIndex2)
    <=> v47299(constB20,bitIndex2) ) ) ).

fof(is_address_257,axiom,
    address(v47299_range_2_to_0_address_term_bound_20) ).

fof(address_association_209,axiom,
    v47299_range_2_to_0_address_association(constB20,v47299_range_2_to_0_address_term_bound_20) ).

fof(address_false_msb_307,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_19,bitIndex4) ).

fof(address_false_msb_306,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_19,bitIndex3) ).

fof(transient_address_definition_208,axiom,
    ( $true
    & ( addressVal(v47299_range_2_to_0_address_term_bound_19,bitIndex0)
    <=> v47299(constB19,bitIndex0) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_19,bitIndex1)
    <=> v47299(constB19,bitIndex1) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_19,bitIndex2)
    <=> v47299(constB19,bitIndex2) ) ) ).

fof(is_address_256,axiom,
    address(v47299_range_2_to_0_address_term_bound_19) ).

fof(address_association_208,axiom,
    v47299_range_2_to_0_address_association(constB19,v47299_range_2_to_0_address_term_bound_19) ).

fof(address_false_msb_305,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_18,bitIndex4) ).

fof(address_false_msb_304,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_18,bitIndex3) ).

fof(transient_address_definition_207,axiom,
    ( $true
    & ( addressVal(v47299_range_2_to_0_address_term_bound_18,bitIndex0)
    <=> v47299(constB18,bitIndex0) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_18,bitIndex1)
    <=> v47299(constB18,bitIndex1) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_18,bitIndex2)
    <=> v47299(constB18,bitIndex2) ) ) ).

fof(is_address_255,axiom,
    address(v47299_range_2_to_0_address_term_bound_18) ).

fof(address_association_207,axiom,
    v47299_range_2_to_0_address_association(constB18,v47299_range_2_to_0_address_term_bound_18) ).

fof(address_false_msb_303,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_17,bitIndex4) ).

fof(address_false_msb_302,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_17,bitIndex3) ).

fof(transient_address_definition_206,axiom,
    ( $true
    & ( addressVal(v47299_range_2_to_0_address_term_bound_17,bitIndex0)
    <=> v47299(constB17,bitIndex0) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_17,bitIndex1)
    <=> v47299(constB17,bitIndex1) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_17,bitIndex2)
    <=> v47299(constB17,bitIndex2) ) ) ).

fof(is_address_254,axiom,
    address(v47299_range_2_to_0_address_term_bound_17) ).

fof(address_association_206,axiom,
    v47299_range_2_to_0_address_association(constB17,v47299_range_2_to_0_address_term_bound_17) ).

fof(address_false_msb_301,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_16,bitIndex4) ).

fof(address_false_msb_300,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_16,bitIndex3) ).

fof(transient_address_definition_205,axiom,
    ( $true
    & ( addressVal(v47299_range_2_to_0_address_term_bound_16,bitIndex0)
    <=> v47299(constB16,bitIndex0) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_16,bitIndex1)
    <=> v47299(constB16,bitIndex1) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_16,bitIndex2)
    <=> v47299(constB16,bitIndex2) ) ) ).

fof(is_address_253,axiom,
    address(v47299_range_2_to_0_address_term_bound_16) ).

fof(address_association_205,axiom,
    v47299_range_2_to_0_address_association(constB16,v47299_range_2_to_0_address_term_bound_16) ).

fof(address_false_msb_299,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_15,bitIndex4) ).

fof(address_false_msb_298,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_15,bitIndex3) ).

fof(transient_address_definition_204,axiom,
    ( $true
    & ( addressVal(v47299_range_2_to_0_address_term_bound_15,bitIndex0)
    <=> v47299(constB15,bitIndex0) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_15,bitIndex1)
    <=> v47299(constB15,bitIndex1) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_15,bitIndex2)
    <=> v47299(constB15,bitIndex2) ) ) ).

fof(is_address_252,axiom,
    address(v47299_range_2_to_0_address_term_bound_15) ).

fof(address_association_204,axiom,
    v47299_range_2_to_0_address_association(constB15,v47299_range_2_to_0_address_term_bound_15) ).

fof(address_false_msb_297,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_14,bitIndex4) ).

fof(address_false_msb_296,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_14,bitIndex3) ).

fof(transient_address_definition_203,axiom,
    ( $true
    & ( addressVal(v47299_range_2_to_0_address_term_bound_14,bitIndex0)
    <=> v47299(constB14,bitIndex0) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_14,bitIndex1)
    <=> v47299(constB14,bitIndex1) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_14,bitIndex2)
    <=> v47299(constB14,bitIndex2) ) ) ).

fof(is_address_251,axiom,
    address(v47299_range_2_to_0_address_term_bound_14) ).

fof(address_association_203,axiom,
    v47299_range_2_to_0_address_association(constB14,v47299_range_2_to_0_address_term_bound_14) ).

fof(address_false_msb_295,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_13,bitIndex4) ).

fof(address_false_msb_294,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_13,bitIndex3) ).

fof(transient_address_definition_202,axiom,
    ( $true
    & ( addressVal(v47299_range_2_to_0_address_term_bound_13,bitIndex0)
    <=> v47299(constB13,bitIndex0) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_13,bitIndex1)
    <=> v47299(constB13,bitIndex1) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_13,bitIndex2)
    <=> v47299(constB13,bitIndex2) ) ) ).

fof(is_address_250,axiom,
    address(v47299_range_2_to_0_address_term_bound_13) ).

fof(address_association_202,axiom,
    v47299_range_2_to_0_address_association(constB13,v47299_range_2_to_0_address_term_bound_13) ).

fof(address_false_msb_293,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_12,bitIndex4) ).

fof(address_false_msb_292,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_12,bitIndex3) ).

fof(transient_address_definition_201,axiom,
    ( $true
    & ( addressVal(v47299_range_2_to_0_address_term_bound_12,bitIndex0)
    <=> v47299(constB12,bitIndex0) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_12,bitIndex1)
    <=> v47299(constB12,bitIndex1) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_12,bitIndex2)
    <=> v47299(constB12,bitIndex2) ) ) ).

fof(is_address_249,axiom,
    address(v47299_range_2_to_0_address_term_bound_12) ).

fof(address_association_201,axiom,
    v47299_range_2_to_0_address_association(constB12,v47299_range_2_to_0_address_term_bound_12) ).

fof(address_false_msb_291,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_11,bitIndex4) ).

fof(address_false_msb_290,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_11,bitIndex3) ).

fof(transient_address_definition_200,axiom,
    ( $true
    & ( addressVal(v47299_range_2_to_0_address_term_bound_11,bitIndex0)
    <=> v47299(constB11,bitIndex0) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_11,bitIndex1)
    <=> v47299(constB11,bitIndex1) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_11,bitIndex2)
    <=> v47299(constB11,bitIndex2) ) ) ).

fof(is_address_248,axiom,
    address(v47299_range_2_to_0_address_term_bound_11) ).

fof(address_association_200,axiom,
    v47299_range_2_to_0_address_association(constB11,v47299_range_2_to_0_address_term_bound_11) ).

fof(address_false_msb_289,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_10,bitIndex4) ).

fof(address_false_msb_288,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_10,bitIndex3) ).

fof(transient_address_definition_199,axiom,
    ( $true
    & ( addressVal(v47299_range_2_to_0_address_term_bound_10,bitIndex0)
    <=> v47299(constB10,bitIndex0) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_10,bitIndex1)
    <=> v47299(constB10,bitIndex1) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_10,bitIndex2)
    <=> v47299(constB10,bitIndex2) ) ) ).

fof(is_address_247,axiom,
    address(v47299_range_2_to_0_address_term_bound_10) ).

fof(address_association_199,axiom,
    v47299_range_2_to_0_address_association(constB10,v47299_range_2_to_0_address_term_bound_10) ).

fof(address_false_msb_287,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_9,bitIndex4) ).

fof(address_false_msb_286,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_9,bitIndex3) ).

fof(transient_address_definition_198,axiom,
    ( $true
    & ( addressVal(v47299_range_2_to_0_address_term_bound_9,bitIndex0)
    <=> v47299(constB9,bitIndex0) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_9,bitIndex1)
    <=> v47299(constB9,bitIndex1) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_9,bitIndex2)
    <=> v47299(constB9,bitIndex2) ) ) ).

fof(is_address_246,axiom,
    address(v47299_range_2_to_0_address_term_bound_9) ).

fof(address_association_198,axiom,
    v47299_range_2_to_0_address_association(constB9,v47299_range_2_to_0_address_term_bound_9) ).

fof(address_false_msb_285,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_8,bitIndex4) ).

fof(address_false_msb_284,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_8,bitIndex3) ).

fof(transient_address_definition_197,axiom,
    ( $true
    & ( addressVal(v47299_range_2_to_0_address_term_bound_8,bitIndex0)
    <=> v47299(constB8,bitIndex0) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_8,bitIndex1)
    <=> v47299(constB8,bitIndex1) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_8,bitIndex2)
    <=> v47299(constB8,bitIndex2) ) ) ).

fof(is_address_245,axiom,
    address(v47299_range_2_to_0_address_term_bound_8) ).

fof(address_association_197,axiom,
    v47299_range_2_to_0_address_association(constB8,v47299_range_2_to_0_address_term_bound_8) ).

fof(address_false_msb_283,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_7,bitIndex4) ).

fof(address_false_msb_282,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_7,bitIndex3) ).

fof(transient_address_definition_196,axiom,
    ( $true
    & ( addressVal(v47299_range_2_to_0_address_term_bound_7,bitIndex0)
    <=> v47299(constB7,bitIndex0) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_7,bitIndex1)
    <=> v47299(constB7,bitIndex1) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_7,bitIndex2)
    <=> v47299(constB7,bitIndex2) ) ) ).

fof(is_address_244,axiom,
    address(v47299_range_2_to_0_address_term_bound_7) ).

fof(address_association_196,axiom,
    v47299_range_2_to_0_address_association(constB7,v47299_range_2_to_0_address_term_bound_7) ).

fof(address_false_msb_281,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_6,bitIndex4) ).

fof(address_false_msb_280,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_6,bitIndex3) ).

fof(transient_address_definition_195,axiom,
    ( $true
    & ( addressVal(v47299_range_2_to_0_address_term_bound_6,bitIndex0)
    <=> v47299(constB6,bitIndex0) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_6,bitIndex1)
    <=> v47299(constB6,bitIndex1) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_6,bitIndex2)
    <=> v47299(constB6,bitIndex2) ) ) ).

fof(is_address_243,axiom,
    address(v47299_range_2_to_0_address_term_bound_6) ).

fof(address_association_195,axiom,
    v47299_range_2_to_0_address_association(constB6,v47299_range_2_to_0_address_term_bound_6) ).

fof(address_false_msb_279,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_5,bitIndex4) ).

fof(address_false_msb_278,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_5,bitIndex3) ).

fof(transient_address_definition_194,axiom,
    ( $true
    & ( addressVal(v47299_range_2_to_0_address_term_bound_5,bitIndex0)
    <=> v47299(constB5,bitIndex0) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_5,bitIndex1)
    <=> v47299(constB5,bitIndex1) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_5,bitIndex2)
    <=> v47299(constB5,bitIndex2) ) ) ).

fof(is_address_242,axiom,
    address(v47299_range_2_to_0_address_term_bound_5) ).

fof(address_association_194,axiom,
    v47299_range_2_to_0_address_association(constB5,v47299_range_2_to_0_address_term_bound_5) ).

fof(address_false_msb_277,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_4,bitIndex4) ).

fof(address_false_msb_276,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_4,bitIndex3) ).

fof(transient_address_definition_193,axiom,
    ( $true
    & ( addressVal(v47299_range_2_to_0_address_term_bound_4,bitIndex0)
    <=> v47299(constB4,bitIndex0) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_4,bitIndex1)
    <=> v47299(constB4,bitIndex1) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_4,bitIndex2)
    <=> v47299(constB4,bitIndex2) ) ) ).

fof(is_address_241,axiom,
    address(v47299_range_2_to_0_address_term_bound_4) ).

fof(address_association_193,axiom,
    v47299_range_2_to_0_address_association(constB4,v47299_range_2_to_0_address_term_bound_4) ).

fof(address_false_msb_275,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_3,bitIndex4) ).

fof(address_false_msb_274,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_3,bitIndex3) ).

fof(transient_address_definition_192,axiom,
    ( $true
    & ( addressVal(v47299_range_2_to_0_address_term_bound_3,bitIndex0)
    <=> v47299(constB3,bitIndex0) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_3,bitIndex1)
    <=> v47299(constB3,bitIndex1) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_3,bitIndex2)
    <=> v47299(constB3,bitIndex2) ) ) ).

fof(is_address_240,axiom,
    address(v47299_range_2_to_0_address_term_bound_3) ).

fof(address_association_192,axiom,
    v47299_range_2_to_0_address_association(constB3,v47299_range_2_to_0_address_term_bound_3) ).

fof(address_false_msb_273,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_2,bitIndex4) ).

fof(address_false_msb_272,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_2,bitIndex3) ).

fof(transient_address_definition_191,axiom,
    ( $true
    & ( addressVal(v47299_range_2_to_0_address_term_bound_2,bitIndex0)
    <=> v47299(constB2,bitIndex0) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_2,bitIndex1)
    <=> v47299(constB2,bitIndex1) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_2,bitIndex2)
    <=> v47299(constB2,bitIndex2) ) ) ).

fof(is_address_239,axiom,
    address(v47299_range_2_to_0_address_term_bound_2) ).

fof(address_association_191,axiom,
    v47299_range_2_to_0_address_association(constB2,v47299_range_2_to_0_address_term_bound_2) ).

fof(address_false_msb_271,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_1,bitIndex4) ).

fof(address_false_msb_270,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_1,bitIndex3) ).

fof(transient_address_definition_190,axiom,
    ( $true
    & ( addressVal(v47299_range_2_to_0_address_term_bound_1,bitIndex0)
    <=> v47299(constB1,bitIndex0) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_1,bitIndex1)
    <=> v47299(constB1,bitIndex1) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_1,bitIndex2)
    <=> v47299(constB1,bitIndex2) ) ) ).

fof(is_address_238,axiom,
    address(v47299_range_2_to_0_address_term_bound_1) ).

fof(address_association_190,axiom,
    v47299_range_2_to_0_address_association(constB1,v47299_range_2_to_0_address_term_bound_1) ).

fof(address_false_msb_269,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_0,bitIndex4) ).

fof(address_false_msb_268,axiom,
    ~ addressVal(v47299_range_2_to_0_address_term_bound_0,bitIndex3) ).

fof(transient_address_definition_189,axiom,
    ( $true
    & ( addressVal(v47299_range_2_to_0_address_term_bound_0,bitIndex0)
    <=> v47299(constB0,bitIndex0) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_0,bitIndex1)
    <=> v47299(constB0,bitIndex1) )
    & ( addressVal(v47299_range_2_to_0_address_term_bound_0,bitIndex2)
    <=> v47299(constB0,bitIndex2) ) ) ).

fof(is_address_237,axiom,
    address(v47299_range_2_to_0_address_term_bound_0) ).

fof(address_association_189,axiom,
    v47299_range_2_to_0_address_association(constB0,v47299_range_2_to_0_address_term_bound_0) ).

fof(address_false_msb_267,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_20,bitIndex4) ).

fof(address_false_msb_266,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_20,bitIndex3) ).

fof(transient_address_definition_188,axiom,
    ( $true
    & ( addressVal(v47273_range_2_to_0_address_term_bound_20,bitIndex0)
    <=> v47273(constB20,bitIndex0) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_20,bitIndex1)
    <=> v47273(constB20,bitIndex1) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_20,bitIndex2)
    <=> v47273(constB20,bitIndex2) ) ) ).

fof(is_address_236,axiom,
    address(v47273_range_2_to_0_address_term_bound_20) ).

fof(address_association_188,axiom,
    v47273_range_2_to_0_address_association(constB20,v47273_range_2_to_0_address_term_bound_20) ).

fof(address_false_msb_265,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_19,bitIndex4) ).

fof(address_false_msb_264,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_19,bitIndex3) ).

fof(transient_address_definition_187,axiom,
    ( $true
    & ( addressVal(v47273_range_2_to_0_address_term_bound_19,bitIndex0)
    <=> v47273(constB19,bitIndex0) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_19,bitIndex1)
    <=> v47273(constB19,bitIndex1) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_19,bitIndex2)
    <=> v47273(constB19,bitIndex2) ) ) ).

fof(is_address_235,axiom,
    address(v47273_range_2_to_0_address_term_bound_19) ).

fof(address_association_187,axiom,
    v47273_range_2_to_0_address_association(constB19,v47273_range_2_to_0_address_term_bound_19) ).

fof(address_false_msb_263,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_18,bitIndex4) ).

fof(address_false_msb_262,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_18,bitIndex3) ).

fof(transient_address_definition_186,axiom,
    ( $true
    & ( addressVal(v47273_range_2_to_0_address_term_bound_18,bitIndex0)
    <=> v47273(constB18,bitIndex0) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_18,bitIndex1)
    <=> v47273(constB18,bitIndex1) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_18,bitIndex2)
    <=> v47273(constB18,bitIndex2) ) ) ).

fof(is_address_234,axiom,
    address(v47273_range_2_to_0_address_term_bound_18) ).

fof(address_association_186,axiom,
    v47273_range_2_to_0_address_association(constB18,v47273_range_2_to_0_address_term_bound_18) ).

fof(address_false_msb_261,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_17,bitIndex4) ).

fof(address_false_msb_260,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_17,bitIndex3) ).

fof(transient_address_definition_185,axiom,
    ( $true
    & ( addressVal(v47273_range_2_to_0_address_term_bound_17,bitIndex0)
    <=> v47273(constB17,bitIndex0) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_17,bitIndex1)
    <=> v47273(constB17,bitIndex1) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_17,bitIndex2)
    <=> v47273(constB17,bitIndex2) ) ) ).

fof(is_address_233,axiom,
    address(v47273_range_2_to_0_address_term_bound_17) ).

fof(address_association_185,axiom,
    v47273_range_2_to_0_address_association(constB17,v47273_range_2_to_0_address_term_bound_17) ).

fof(address_false_msb_259,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_16,bitIndex4) ).

fof(address_false_msb_258,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_16,bitIndex3) ).

fof(transient_address_definition_184,axiom,
    ( $true
    & ( addressVal(v47273_range_2_to_0_address_term_bound_16,bitIndex0)
    <=> v47273(constB16,bitIndex0) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_16,bitIndex1)
    <=> v47273(constB16,bitIndex1) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_16,bitIndex2)
    <=> v47273(constB16,bitIndex2) ) ) ).

fof(is_address_232,axiom,
    address(v47273_range_2_to_0_address_term_bound_16) ).

fof(address_association_184,axiom,
    v47273_range_2_to_0_address_association(constB16,v47273_range_2_to_0_address_term_bound_16) ).

fof(address_false_msb_257,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_15,bitIndex4) ).

fof(address_false_msb_256,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_15,bitIndex3) ).

fof(transient_address_definition_183,axiom,
    ( $true
    & ( addressVal(v47273_range_2_to_0_address_term_bound_15,bitIndex0)
    <=> v47273(constB15,bitIndex0) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_15,bitIndex1)
    <=> v47273(constB15,bitIndex1) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_15,bitIndex2)
    <=> v47273(constB15,bitIndex2) ) ) ).

fof(is_address_231,axiom,
    address(v47273_range_2_to_0_address_term_bound_15) ).

fof(address_association_183,axiom,
    v47273_range_2_to_0_address_association(constB15,v47273_range_2_to_0_address_term_bound_15) ).

fof(address_false_msb_255,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_14,bitIndex4) ).

fof(address_false_msb_254,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_14,bitIndex3) ).

fof(transient_address_definition_182,axiom,
    ( $true
    & ( addressVal(v47273_range_2_to_0_address_term_bound_14,bitIndex0)
    <=> v47273(constB14,bitIndex0) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_14,bitIndex1)
    <=> v47273(constB14,bitIndex1) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_14,bitIndex2)
    <=> v47273(constB14,bitIndex2) ) ) ).

fof(is_address_230,axiom,
    address(v47273_range_2_to_0_address_term_bound_14) ).

fof(address_association_182,axiom,
    v47273_range_2_to_0_address_association(constB14,v47273_range_2_to_0_address_term_bound_14) ).

fof(address_false_msb_253,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_13,bitIndex4) ).

fof(address_false_msb_252,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_13,bitIndex3) ).

fof(transient_address_definition_181,axiom,
    ( $true
    & ( addressVal(v47273_range_2_to_0_address_term_bound_13,bitIndex0)
    <=> v47273(constB13,bitIndex0) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_13,bitIndex1)
    <=> v47273(constB13,bitIndex1) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_13,bitIndex2)
    <=> v47273(constB13,bitIndex2) ) ) ).

fof(is_address_229,axiom,
    address(v47273_range_2_to_0_address_term_bound_13) ).

fof(address_association_181,axiom,
    v47273_range_2_to_0_address_association(constB13,v47273_range_2_to_0_address_term_bound_13) ).

fof(address_false_msb_251,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_12,bitIndex4) ).

fof(address_false_msb_250,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_12,bitIndex3) ).

fof(transient_address_definition_180,axiom,
    ( $true
    & ( addressVal(v47273_range_2_to_0_address_term_bound_12,bitIndex0)
    <=> v47273(constB12,bitIndex0) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_12,bitIndex1)
    <=> v47273(constB12,bitIndex1) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_12,bitIndex2)
    <=> v47273(constB12,bitIndex2) ) ) ).

fof(is_address_228,axiom,
    address(v47273_range_2_to_0_address_term_bound_12) ).

fof(address_association_180,axiom,
    v47273_range_2_to_0_address_association(constB12,v47273_range_2_to_0_address_term_bound_12) ).

fof(address_false_msb_249,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_11,bitIndex4) ).

fof(address_false_msb_248,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_11,bitIndex3) ).

fof(transient_address_definition_179,axiom,
    ( $true
    & ( addressVal(v47273_range_2_to_0_address_term_bound_11,bitIndex0)
    <=> v47273(constB11,bitIndex0) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_11,bitIndex1)
    <=> v47273(constB11,bitIndex1) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_11,bitIndex2)
    <=> v47273(constB11,bitIndex2) ) ) ).

fof(is_address_227,axiom,
    address(v47273_range_2_to_0_address_term_bound_11) ).

fof(address_association_179,axiom,
    v47273_range_2_to_0_address_association(constB11,v47273_range_2_to_0_address_term_bound_11) ).

fof(address_false_msb_247,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_10,bitIndex4) ).

fof(address_false_msb_246,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_10,bitIndex3) ).

fof(transient_address_definition_178,axiom,
    ( $true
    & ( addressVal(v47273_range_2_to_0_address_term_bound_10,bitIndex0)
    <=> v47273(constB10,bitIndex0) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_10,bitIndex1)
    <=> v47273(constB10,bitIndex1) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_10,bitIndex2)
    <=> v47273(constB10,bitIndex2) ) ) ).

fof(is_address_226,axiom,
    address(v47273_range_2_to_0_address_term_bound_10) ).

fof(address_association_178,axiom,
    v47273_range_2_to_0_address_association(constB10,v47273_range_2_to_0_address_term_bound_10) ).

fof(address_false_msb_245,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_9,bitIndex4) ).

fof(address_false_msb_244,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_9,bitIndex3) ).

fof(transient_address_definition_177,axiom,
    ( $true
    & ( addressVal(v47273_range_2_to_0_address_term_bound_9,bitIndex0)
    <=> v47273(constB9,bitIndex0) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_9,bitIndex1)
    <=> v47273(constB9,bitIndex1) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_9,bitIndex2)
    <=> v47273(constB9,bitIndex2) ) ) ).

fof(is_address_225,axiom,
    address(v47273_range_2_to_0_address_term_bound_9) ).

fof(address_association_177,axiom,
    v47273_range_2_to_0_address_association(constB9,v47273_range_2_to_0_address_term_bound_9) ).

fof(address_false_msb_243,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_8,bitIndex4) ).

fof(address_false_msb_242,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_8,bitIndex3) ).

fof(transient_address_definition_176,axiom,
    ( $true
    & ( addressVal(v47273_range_2_to_0_address_term_bound_8,bitIndex0)
    <=> v47273(constB8,bitIndex0) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_8,bitIndex1)
    <=> v47273(constB8,bitIndex1) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_8,bitIndex2)
    <=> v47273(constB8,bitIndex2) ) ) ).

fof(is_address_224,axiom,
    address(v47273_range_2_to_0_address_term_bound_8) ).

fof(address_association_176,axiom,
    v47273_range_2_to_0_address_association(constB8,v47273_range_2_to_0_address_term_bound_8) ).

fof(address_false_msb_241,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_7,bitIndex4) ).

fof(address_false_msb_240,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_7,bitIndex3) ).

fof(transient_address_definition_175,axiom,
    ( $true
    & ( addressVal(v47273_range_2_to_0_address_term_bound_7,bitIndex0)
    <=> v47273(constB7,bitIndex0) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_7,bitIndex1)
    <=> v47273(constB7,bitIndex1) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_7,bitIndex2)
    <=> v47273(constB7,bitIndex2) ) ) ).

fof(is_address_223,axiom,
    address(v47273_range_2_to_0_address_term_bound_7) ).

fof(address_association_175,axiom,
    v47273_range_2_to_0_address_association(constB7,v47273_range_2_to_0_address_term_bound_7) ).

fof(address_false_msb_239,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_6,bitIndex4) ).

fof(address_false_msb_238,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_6,bitIndex3) ).

fof(transient_address_definition_174,axiom,
    ( $true
    & ( addressVal(v47273_range_2_to_0_address_term_bound_6,bitIndex0)
    <=> v47273(constB6,bitIndex0) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_6,bitIndex1)
    <=> v47273(constB6,bitIndex1) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_6,bitIndex2)
    <=> v47273(constB6,bitIndex2) ) ) ).

fof(is_address_222,axiom,
    address(v47273_range_2_to_0_address_term_bound_6) ).

fof(address_association_174,axiom,
    v47273_range_2_to_0_address_association(constB6,v47273_range_2_to_0_address_term_bound_6) ).

fof(address_false_msb_237,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_5,bitIndex4) ).

fof(address_false_msb_236,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_5,bitIndex3) ).

fof(transient_address_definition_173,axiom,
    ( $true
    & ( addressVal(v47273_range_2_to_0_address_term_bound_5,bitIndex0)
    <=> v47273(constB5,bitIndex0) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_5,bitIndex1)
    <=> v47273(constB5,bitIndex1) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_5,bitIndex2)
    <=> v47273(constB5,bitIndex2) ) ) ).

fof(is_address_221,axiom,
    address(v47273_range_2_to_0_address_term_bound_5) ).

fof(address_association_173,axiom,
    v47273_range_2_to_0_address_association(constB5,v47273_range_2_to_0_address_term_bound_5) ).

fof(address_false_msb_235,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_4,bitIndex4) ).

fof(address_false_msb_234,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_4,bitIndex3) ).

fof(transient_address_definition_172,axiom,
    ( $true
    & ( addressVal(v47273_range_2_to_0_address_term_bound_4,bitIndex0)
    <=> v47273(constB4,bitIndex0) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_4,bitIndex1)
    <=> v47273(constB4,bitIndex1) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_4,bitIndex2)
    <=> v47273(constB4,bitIndex2) ) ) ).

fof(is_address_220,axiom,
    address(v47273_range_2_to_0_address_term_bound_4) ).

fof(address_association_172,axiom,
    v47273_range_2_to_0_address_association(constB4,v47273_range_2_to_0_address_term_bound_4) ).

fof(address_false_msb_233,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_3,bitIndex4) ).

fof(address_false_msb_232,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_3,bitIndex3) ).

fof(transient_address_definition_171,axiom,
    ( $true
    & ( addressVal(v47273_range_2_to_0_address_term_bound_3,bitIndex0)
    <=> v47273(constB3,bitIndex0) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_3,bitIndex1)
    <=> v47273(constB3,bitIndex1) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_3,bitIndex2)
    <=> v47273(constB3,bitIndex2) ) ) ).

fof(is_address_219,axiom,
    address(v47273_range_2_to_0_address_term_bound_3) ).

fof(address_association_171,axiom,
    v47273_range_2_to_0_address_association(constB3,v47273_range_2_to_0_address_term_bound_3) ).

fof(address_false_msb_231,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_2,bitIndex4) ).

fof(address_false_msb_230,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_2,bitIndex3) ).

fof(transient_address_definition_170,axiom,
    ( $true
    & ( addressVal(v47273_range_2_to_0_address_term_bound_2,bitIndex0)
    <=> v47273(constB2,bitIndex0) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_2,bitIndex1)
    <=> v47273(constB2,bitIndex1) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_2,bitIndex2)
    <=> v47273(constB2,bitIndex2) ) ) ).

fof(is_address_218,axiom,
    address(v47273_range_2_to_0_address_term_bound_2) ).

fof(address_association_170,axiom,
    v47273_range_2_to_0_address_association(constB2,v47273_range_2_to_0_address_term_bound_2) ).

fof(address_false_msb_229,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_1,bitIndex4) ).

fof(address_false_msb_228,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_1,bitIndex3) ).

fof(transient_address_definition_169,axiom,
    ( $true
    & ( addressVal(v47273_range_2_to_0_address_term_bound_1,bitIndex0)
    <=> v47273(constB1,bitIndex0) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_1,bitIndex1)
    <=> v47273(constB1,bitIndex1) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_1,bitIndex2)
    <=> v47273(constB1,bitIndex2) ) ) ).

fof(is_address_217,axiom,
    address(v47273_range_2_to_0_address_term_bound_1) ).

fof(address_association_169,axiom,
    v47273_range_2_to_0_address_association(constB1,v47273_range_2_to_0_address_term_bound_1) ).

fof(address_false_msb_227,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_0,bitIndex4) ).

fof(address_false_msb_226,axiom,
    ~ addressVal(v47273_range_2_to_0_address_term_bound_0,bitIndex3) ).

fof(transient_address_definition_168,axiom,
    ( $true
    & ( addressVal(v47273_range_2_to_0_address_term_bound_0,bitIndex0)
    <=> v47273(constB0,bitIndex0) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_0,bitIndex1)
    <=> v47273(constB0,bitIndex1) )
    & ( addressVal(v47273_range_2_to_0_address_term_bound_0,bitIndex2)
    <=> v47273(constB0,bitIndex2) ) ) ).

fof(is_address_216,axiom,
    address(v47273_range_2_to_0_address_term_bound_0) ).

fof(address_association_168,axiom,
    v47273_range_2_to_0_address_association(constB0,v47273_range_2_to_0_address_term_bound_0) ).

fof(is_address_215,axiom,
    address(b11111_address_term) ).

fof(constant_address_definition_47,axiom,
    ! [B] :
      ( addressVal(b11111_address_term,B)
    <=> b11111(B) ) ).

fof(is_address_214,axiom,
    address(b11110_address_term) ).

fof(constant_address_definition_46,axiom,
    ! [B] :
      ( addressVal(b11110_address_term,B)
    <=> b11110(B) ) ).

fof(is_address_213,axiom,
    address(b11101_address_term) ).

fof(constant_address_definition_45,axiom,
    ! [B] :
      ( addressVal(b11101_address_term,B)
    <=> b11101(B) ) ).

fof(is_address_212,axiom,
    address(b11100_address_term) ).

fof(constant_address_definition_44,axiom,
    ! [B] :
      ( addressVal(b11100_address_term,B)
    <=> b11100(B) ) ).

fof(is_address_211,axiom,
    address(b11011_address_term) ).

fof(constant_address_definition_43,axiom,
    ! [B] :
      ( addressVal(b11011_address_term,B)
    <=> b11011(B) ) ).

fof(is_address_210,axiom,
    address(b11010_address_term) ).

fof(constant_address_definition_42,axiom,
    ! [B] :
      ( addressVal(b11010_address_term,B)
    <=> b11010(B) ) ).

fof(is_address_209,axiom,
    address(b11001_address_term) ).

fof(constant_address_definition_41,axiom,
    ! [B] :
      ( addressVal(b11001_address_term,B)
    <=> b11001(B) ) ).

fof(is_address_208,axiom,
    address(b11000_address_term) ).

fof(constant_address_definition_40,axiom,
    ! [B] :
      ( addressVal(b11000_address_term,B)
    <=> b11000(B) ) ).

fof(is_address_207,axiom,
    address(b10111_address_term) ).

fof(constant_address_definition_39,axiom,
    ! [B] :
      ( addressVal(b10111_address_term,B)
    <=> b10111(B) ) ).

fof(is_address_206,axiom,
    address(b10110_address_term) ).

fof(constant_address_definition_38,axiom,
    ! [B] :
      ( addressVal(b10110_address_term,B)
    <=> b10110(B) ) ).

fof(is_address_205,axiom,
    address(b10101_address_term) ).

fof(constant_address_definition_37,axiom,
    ! [B] :
      ( addressVal(b10101_address_term,B)
    <=> b10101(B) ) ).

fof(is_address_204,axiom,
    address(b10100_address_term) ).

fof(constant_address_definition_36,axiom,
    ! [B] :
      ( addressVal(b10100_address_term,B)
    <=> b10100(B) ) ).

fof(is_address_203,axiom,
    address(b10011_address_term) ).

fof(constant_address_definition_35,axiom,
    ! [B] :
      ( addressVal(b10011_address_term,B)
    <=> b10011(B) ) ).

fof(is_address_202,axiom,
    address(b10010_address_term) ).

fof(constant_address_definition_34,axiom,
    ! [B] :
      ( addressVal(b10010_address_term,B)
    <=> b10010(B) ) ).

fof(is_address_201,axiom,
    address(b10001_address_term) ).

fof(constant_address_definition_33,axiom,
    ! [B] :
      ( addressVal(b10001_address_term,B)
    <=> b10001(B) ) ).

fof(is_address_200,axiom,
    address(b01111_address_term) ).

fof(constant_address_definition_32,axiom,
    ! [B] :
      ( addressVal(b01111_address_term,B)
    <=> b01111(B) ) ).

fof(is_address_199,axiom,
    address(b01110_address_term) ).

fof(constant_address_definition_31,axiom,
    ! [B] :
      ( addressVal(b01110_address_term,B)
    <=> b01110(B) ) ).

fof(is_address_198,axiom,
    address(b01101_address_term) ).

fof(constant_address_definition_30,axiom,
    ! [B] :
      ( addressVal(b01101_address_term,B)
    <=> b01101(B) ) ).

fof(is_address_197,axiom,
    address(b01100_address_term) ).

fof(constant_address_definition_29,axiom,
    ! [B] :
      ( addressVal(b01100_address_term,B)
    <=> b01100(B) ) ).

fof(is_address_196,axiom,
    address(b01011_address_term) ).

fof(constant_address_definition_28,axiom,
    ! [B] :
      ( addressVal(b01011_address_term,B)
    <=> b01011(B) ) ).

fof(is_address_195,axiom,
    address(b00101_address_term) ).

fof(constant_address_definition_27,axiom,
    ! [B] :
      ( addressVal(b00101_address_term,B)
    <=> b00101(B) ) ).

fof(is_address_194,axiom,
    address(b00100_address_term) ).

fof(constant_address_definition_26,axiom,
    ! [B] :
      ( addressVal(b00100_address_term,B)
    <=> b00100(B) ) ).

fof(is_address_193,axiom,
    address(b00010_address_term) ).

fof(constant_address_definition_25,axiom,
    ! [B] :
      ( addressVal(b00010_address_term,B)
    <=> b00010(B) ) ).

fof(is_address_192,axiom,
    address(b00011_address_term) ).

fof(constant_address_definition_24,axiom,
    ! [B] :
      ( addressVal(b00011_address_term,B)
    <=> b00011(B) ) ).

fof(is_address_191,axiom,
    address(b00111_address_term) ).

fof(constant_address_definition_23,axiom,
    ! [B] :
      ( addressVal(b00111_address_term,B)
    <=> b00111(B) ) ).

fof(is_address_190,axiom,
    address(b00110_address_term) ).

fof(constant_address_definition_22,axiom,
    ! [B] :
      ( addressVal(b00110_address_term,B)
    <=> b00110(B) ) ).

fof(address_false_msb_225,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_20,bitIndex4) ).

fof(address_false_msb_224,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_20,bitIndex3) ).

fof(transient_address_definition_167,axiom,
    ( $true
    & ( addressVal(v7361_range_2_to_0_address_term_bound_20,bitIndex0)
    <=> v7361(constB20,bitIndex0) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_20,bitIndex1)
    <=> v7361(constB20,bitIndex1) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_20,bitIndex2)
    <=> v7361(constB20,bitIndex2) ) ) ).

fof(is_address_189,axiom,
    address(v7361_range_2_to_0_address_term_bound_20) ).

fof(address_association_167,axiom,
    v7361_range_2_to_0_address_association(constB20,v7361_range_2_to_0_address_term_bound_20) ).

fof(address_false_msb_223,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_19,bitIndex4) ).

fof(address_false_msb_222,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_19,bitIndex3) ).

fof(transient_address_definition_166,axiom,
    ( $true
    & ( addressVal(v7361_range_2_to_0_address_term_bound_19,bitIndex0)
    <=> v7361(constB19,bitIndex0) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_19,bitIndex1)
    <=> v7361(constB19,bitIndex1) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_19,bitIndex2)
    <=> v7361(constB19,bitIndex2) ) ) ).

fof(is_address_188,axiom,
    address(v7361_range_2_to_0_address_term_bound_19) ).

fof(address_association_166,axiom,
    v7361_range_2_to_0_address_association(constB19,v7361_range_2_to_0_address_term_bound_19) ).

fof(address_false_msb_221,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_18,bitIndex4) ).

fof(address_false_msb_220,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_18,bitIndex3) ).

fof(transient_address_definition_165,axiom,
    ( $true
    & ( addressVal(v7361_range_2_to_0_address_term_bound_18,bitIndex0)
    <=> v7361(constB18,bitIndex0) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_18,bitIndex1)
    <=> v7361(constB18,bitIndex1) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_18,bitIndex2)
    <=> v7361(constB18,bitIndex2) ) ) ).

fof(is_address_187,axiom,
    address(v7361_range_2_to_0_address_term_bound_18) ).

fof(address_association_165,axiom,
    v7361_range_2_to_0_address_association(constB18,v7361_range_2_to_0_address_term_bound_18) ).

fof(address_false_msb_219,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_17,bitIndex4) ).

fof(address_false_msb_218,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_17,bitIndex3) ).

fof(transient_address_definition_164,axiom,
    ( $true
    & ( addressVal(v7361_range_2_to_0_address_term_bound_17,bitIndex0)
    <=> v7361(constB17,bitIndex0) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_17,bitIndex1)
    <=> v7361(constB17,bitIndex1) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_17,bitIndex2)
    <=> v7361(constB17,bitIndex2) ) ) ).

fof(is_address_186,axiom,
    address(v7361_range_2_to_0_address_term_bound_17) ).

fof(address_association_164,axiom,
    v7361_range_2_to_0_address_association(constB17,v7361_range_2_to_0_address_term_bound_17) ).

fof(address_false_msb_217,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_16,bitIndex4) ).

fof(address_false_msb_216,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_16,bitIndex3) ).

fof(transient_address_definition_163,axiom,
    ( $true
    & ( addressVal(v7361_range_2_to_0_address_term_bound_16,bitIndex0)
    <=> v7361(constB16,bitIndex0) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_16,bitIndex1)
    <=> v7361(constB16,bitIndex1) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_16,bitIndex2)
    <=> v7361(constB16,bitIndex2) ) ) ).

fof(is_address_185,axiom,
    address(v7361_range_2_to_0_address_term_bound_16) ).

fof(address_association_163,axiom,
    v7361_range_2_to_0_address_association(constB16,v7361_range_2_to_0_address_term_bound_16) ).

fof(address_false_msb_215,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_15,bitIndex4) ).

fof(address_false_msb_214,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_15,bitIndex3) ).

fof(transient_address_definition_162,axiom,
    ( $true
    & ( addressVal(v7361_range_2_to_0_address_term_bound_15,bitIndex0)
    <=> v7361(constB15,bitIndex0) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_15,bitIndex1)
    <=> v7361(constB15,bitIndex1) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_15,bitIndex2)
    <=> v7361(constB15,bitIndex2) ) ) ).

fof(is_address_184,axiom,
    address(v7361_range_2_to_0_address_term_bound_15) ).

fof(address_association_162,axiom,
    v7361_range_2_to_0_address_association(constB15,v7361_range_2_to_0_address_term_bound_15) ).

fof(address_false_msb_213,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_14,bitIndex4) ).

fof(address_false_msb_212,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_14,bitIndex3) ).

fof(transient_address_definition_161,axiom,
    ( $true
    & ( addressVal(v7361_range_2_to_0_address_term_bound_14,bitIndex0)
    <=> v7361(constB14,bitIndex0) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_14,bitIndex1)
    <=> v7361(constB14,bitIndex1) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_14,bitIndex2)
    <=> v7361(constB14,bitIndex2) ) ) ).

fof(is_address_183,axiom,
    address(v7361_range_2_to_0_address_term_bound_14) ).

fof(address_association_161,axiom,
    v7361_range_2_to_0_address_association(constB14,v7361_range_2_to_0_address_term_bound_14) ).

fof(address_false_msb_211,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_13,bitIndex4) ).

fof(address_false_msb_210,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_13,bitIndex3) ).

fof(transient_address_definition_160,axiom,
    ( $true
    & ( addressVal(v7361_range_2_to_0_address_term_bound_13,bitIndex0)
    <=> v7361(constB13,bitIndex0) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_13,bitIndex1)
    <=> v7361(constB13,bitIndex1) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_13,bitIndex2)
    <=> v7361(constB13,bitIndex2) ) ) ).

fof(is_address_182,axiom,
    address(v7361_range_2_to_0_address_term_bound_13) ).

fof(address_association_160,axiom,
    v7361_range_2_to_0_address_association(constB13,v7361_range_2_to_0_address_term_bound_13) ).

fof(address_false_msb_209,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_12,bitIndex4) ).

fof(address_false_msb_208,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_12,bitIndex3) ).

fof(transient_address_definition_159,axiom,
    ( $true
    & ( addressVal(v7361_range_2_to_0_address_term_bound_12,bitIndex0)
    <=> v7361(constB12,bitIndex0) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_12,bitIndex1)
    <=> v7361(constB12,bitIndex1) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_12,bitIndex2)
    <=> v7361(constB12,bitIndex2) ) ) ).

fof(is_address_181,axiom,
    address(v7361_range_2_to_0_address_term_bound_12) ).

fof(address_association_159,axiom,
    v7361_range_2_to_0_address_association(constB12,v7361_range_2_to_0_address_term_bound_12) ).

fof(address_false_msb_207,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_11,bitIndex4) ).

fof(address_false_msb_206,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_11,bitIndex3) ).

fof(transient_address_definition_158,axiom,
    ( $true
    & ( addressVal(v7361_range_2_to_0_address_term_bound_11,bitIndex0)
    <=> v7361(constB11,bitIndex0) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_11,bitIndex1)
    <=> v7361(constB11,bitIndex1) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_11,bitIndex2)
    <=> v7361(constB11,bitIndex2) ) ) ).

fof(is_address_180,axiom,
    address(v7361_range_2_to_0_address_term_bound_11) ).

fof(address_association_158,axiom,
    v7361_range_2_to_0_address_association(constB11,v7361_range_2_to_0_address_term_bound_11) ).

fof(address_false_msb_205,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_10,bitIndex4) ).

fof(address_false_msb_204,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_10,bitIndex3) ).

fof(transient_address_definition_157,axiom,
    ( $true
    & ( addressVal(v7361_range_2_to_0_address_term_bound_10,bitIndex0)
    <=> v7361(constB10,bitIndex0) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_10,bitIndex1)
    <=> v7361(constB10,bitIndex1) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_10,bitIndex2)
    <=> v7361(constB10,bitIndex2) ) ) ).

fof(is_address_179,axiom,
    address(v7361_range_2_to_0_address_term_bound_10) ).

fof(address_association_157,axiom,
    v7361_range_2_to_0_address_association(constB10,v7361_range_2_to_0_address_term_bound_10) ).

fof(address_false_msb_203,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_9,bitIndex4) ).

fof(address_false_msb_202,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_9,bitIndex3) ).

fof(transient_address_definition_156,axiom,
    ( $true
    & ( addressVal(v7361_range_2_to_0_address_term_bound_9,bitIndex0)
    <=> v7361(constB9,bitIndex0) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_9,bitIndex1)
    <=> v7361(constB9,bitIndex1) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_9,bitIndex2)
    <=> v7361(constB9,bitIndex2) ) ) ).

fof(is_address_178,axiom,
    address(v7361_range_2_to_0_address_term_bound_9) ).

fof(address_association_156,axiom,
    v7361_range_2_to_0_address_association(constB9,v7361_range_2_to_0_address_term_bound_9) ).

fof(address_false_msb_201,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_8,bitIndex4) ).

fof(address_false_msb_200,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_8,bitIndex3) ).

fof(transient_address_definition_155,axiom,
    ( $true
    & ( addressVal(v7361_range_2_to_0_address_term_bound_8,bitIndex0)
    <=> v7361(constB8,bitIndex0) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_8,bitIndex1)
    <=> v7361(constB8,bitIndex1) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_8,bitIndex2)
    <=> v7361(constB8,bitIndex2) ) ) ).

fof(is_address_177,axiom,
    address(v7361_range_2_to_0_address_term_bound_8) ).

fof(address_association_155,axiom,
    v7361_range_2_to_0_address_association(constB8,v7361_range_2_to_0_address_term_bound_8) ).

fof(address_false_msb_199,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_7,bitIndex4) ).

fof(address_false_msb_198,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_7,bitIndex3) ).

fof(transient_address_definition_154,axiom,
    ( $true
    & ( addressVal(v7361_range_2_to_0_address_term_bound_7,bitIndex0)
    <=> v7361(constB7,bitIndex0) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_7,bitIndex1)
    <=> v7361(constB7,bitIndex1) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_7,bitIndex2)
    <=> v7361(constB7,bitIndex2) ) ) ).

fof(is_address_176,axiom,
    address(v7361_range_2_to_0_address_term_bound_7) ).

fof(address_association_154,axiom,
    v7361_range_2_to_0_address_association(constB7,v7361_range_2_to_0_address_term_bound_7) ).

fof(address_false_msb_197,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_6,bitIndex4) ).

fof(address_false_msb_196,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_6,bitIndex3) ).

fof(transient_address_definition_153,axiom,
    ( $true
    & ( addressVal(v7361_range_2_to_0_address_term_bound_6,bitIndex0)
    <=> v7361(constB6,bitIndex0) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_6,bitIndex1)
    <=> v7361(constB6,bitIndex1) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_6,bitIndex2)
    <=> v7361(constB6,bitIndex2) ) ) ).

fof(is_address_175,axiom,
    address(v7361_range_2_to_0_address_term_bound_6) ).

fof(address_association_153,axiom,
    v7361_range_2_to_0_address_association(constB6,v7361_range_2_to_0_address_term_bound_6) ).

fof(address_false_msb_195,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_5,bitIndex4) ).

fof(address_false_msb_194,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_5,bitIndex3) ).

fof(transient_address_definition_152,axiom,
    ( $true
    & ( addressVal(v7361_range_2_to_0_address_term_bound_5,bitIndex0)
    <=> v7361(constB5,bitIndex0) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_5,bitIndex1)
    <=> v7361(constB5,bitIndex1) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_5,bitIndex2)
    <=> v7361(constB5,bitIndex2) ) ) ).

fof(is_address_174,axiom,
    address(v7361_range_2_to_0_address_term_bound_5) ).

fof(address_association_152,axiom,
    v7361_range_2_to_0_address_association(constB5,v7361_range_2_to_0_address_term_bound_5) ).

fof(address_false_msb_193,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_4,bitIndex4) ).

fof(address_false_msb_192,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_4,bitIndex3) ).

fof(transient_address_definition_151,axiom,
    ( $true
    & ( addressVal(v7361_range_2_to_0_address_term_bound_4,bitIndex0)
    <=> v7361(constB4,bitIndex0) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_4,bitIndex1)
    <=> v7361(constB4,bitIndex1) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_4,bitIndex2)
    <=> v7361(constB4,bitIndex2) ) ) ).

fof(is_address_173,axiom,
    address(v7361_range_2_to_0_address_term_bound_4) ).

fof(address_association_151,axiom,
    v7361_range_2_to_0_address_association(constB4,v7361_range_2_to_0_address_term_bound_4) ).

fof(address_false_msb_191,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_3,bitIndex4) ).

fof(address_false_msb_190,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_3,bitIndex3) ).

fof(transient_address_definition_150,axiom,
    ( $true
    & ( addressVal(v7361_range_2_to_0_address_term_bound_3,bitIndex0)
    <=> v7361(constB3,bitIndex0) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_3,bitIndex1)
    <=> v7361(constB3,bitIndex1) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_3,bitIndex2)
    <=> v7361(constB3,bitIndex2) ) ) ).

fof(is_address_172,axiom,
    address(v7361_range_2_to_0_address_term_bound_3) ).

fof(address_association_150,axiom,
    v7361_range_2_to_0_address_association(constB3,v7361_range_2_to_0_address_term_bound_3) ).

fof(address_false_msb_189,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_2,bitIndex4) ).

fof(address_false_msb_188,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_2,bitIndex3) ).

fof(transient_address_definition_149,axiom,
    ( $true
    & ( addressVal(v7361_range_2_to_0_address_term_bound_2,bitIndex0)
    <=> v7361(constB2,bitIndex0) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_2,bitIndex1)
    <=> v7361(constB2,bitIndex1) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_2,bitIndex2)
    <=> v7361(constB2,bitIndex2) ) ) ).

fof(is_address_171,axiom,
    address(v7361_range_2_to_0_address_term_bound_2) ).

fof(address_association_149,axiom,
    v7361_range_2_to_0_address_association(constB2,v7361_range_2_to_0_address_term_bound_2) ).

fof(address_false_msb_187,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_1,bitIndex4) ).

fof(address_false_msb_186,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_1,bitIndex3) ).

fof(transient_address_definition_148,axiom,
    ( $true
    & ( addressVal(v7361_range_2_to_0_address_term_bound_1,bitIndex0)
    <=> v7361(constB1,bitIndex0) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_1,bitIndex1)
    <=> v7361(constB1,bitIndex1) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_1,bitIndex2)
    <=> v7361(constB1,bitIndex2) ) ) ).

fof(is_address_170,axiom,
    address(v7361_range_2_to_0_address_term_bound_1) ).

fof(address_association_148,axiom,
    v7361_range_2_to_0_address_association(constB1,v7361_range_2_to_0_address_term_bound_1) ).

fof(address_false_msb_185,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_0,bitIndex4) ).

fof(address_false_msb_184,axiom,
    ~ addressVal(v7361_range_2_to_0_address_term_bound_0,bitIndex3) ).

fof(transient_address_definition_147,axiom,
    ( $true
    & ( addressVal(v7361_range_2_to_0_address_term_bound_0,bitIndex0)
    <=> v7361(constB0,bitIndex0) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_0,bitIndex1)
    <=> v7361(constB0,bitIndex1) )
    & ( addressVal(v7361_range_2_to_0_address_term_bound_0,bitIndex2)
    <=> v7361(constB0,bitIndex2) ) ) ).

fof(is_address_169,axiom,
    address(v7361_range_2_to_0_address_term_bound_0) ).

fof(address_association_147,axiom,
    v7361_range_2_to_0_address_association(constB0,v7361_range_2_to_0_address_term_bound_0) ).

fof(address_false_msb_183,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_20,bitIndex4) ).

fof(address_false_msb_182,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_20,bitIndex3) ).

fof(transient_address_definition_146,axiom,
    ( $true
    & ( addressVal(v7301_range_2_to_0_address_term_bound_20,bitIndex0)
    <=> v7301(constB20,bitIndex0) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_20,bitIndex1)
    <=> v7301(constB20,bitIndex1) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_20,bitIndex2)
    <=> v7301(constB20,bitIndex2) ) ) ).

fof(is_address_168,axiom,
    address(v7301_range_2_to_0_address_term_bound_20) ).

fof(address_association_146,axiom,
    v7301_range_2_to_0_address_association(constB20,v7301_range_2_to_0_address_term_bound_20) ).

fof(address_false_msb_181,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_19,bitIndex4) ).

fof(address_false_msb_180,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_19,bitIndex3) ).

fof(transient_address_definition_145,axiom,
    ( $true
    & ( addressVal(v7301_range_2_to_0_address_term_bound_19,bitIndex0)
    <=> v7301(constB19,bitIndex0) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_19,bitIndex1)
    <=> v7301(constB19,bitIndex1) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_19,bitIndex2)
    <=> v7301(constB19,bitIndex2) ) ) ).

fof(is_address_167,axiom,
    address(v7301_range_2_to_0_address_term_bound_19) ).

fof(address_association_145,axiom,
    v7301_range_2_to_0_address_association(constB19,v7301_range_2_to_0_address_term_bound_19) ).

fof(address_false_msb_179,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_18,bitIndex4) ).

fof(address_false_msb_178,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_18,bitIndex3) ).

fof(transient_address_definition_144,axiom,
    ( $true
    & ( addressVal(v7301_range_2_to_0_address_term_bound_18,bitIndex0)
    <=> v7301(constB18,bitIndex0) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_18,bitIndex1)
    <=> v7301(constB18,bitIndex1) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_18,bitIndex2)
    <=> v7301(constB18,bitIndex2) ) ) ).

fof(is_address_166,axiom,
    address(v7301_range_2_to_0_address_term_bound_18) ).

fof(address_association_144,axiom,
    v7301_range_2_to_0_address_association(constB18,v7301_range_2_to_0_address_term_bound_18) ).

fof(address_false_msb_177,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_17,bitIndex4) ).

fof(address_false_msb_176,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_17,bitIndex3) ).

fof(transient_address_definition_143,axiom,
    ( $true
    & ( addressVal(v7301_range_2_to_0_address_term_bound_17,bitIndex0)
    <=> v7301(constB17,bitIndex0) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_17,bitIndex1)
    <=> v7301(constB17,bitIndex1) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_17,bitIndex2)
    <=> v7301(constB17,bitIndex2) ) ) ).

fof(is_address_165,axiom,
    address(v7301_range_2_to_0_address_term_bound_17) ).

fof(address_association_143,axiom,
    v7301_range_2_to_0_address_association(constB17,v7301_range_2_to_0_address_term_bound_17) ).

fof(address_false_msb_175,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_16,bitIndex4) ).

fof(address_false_msb_174,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_16,bitIndex3) ).

fof(transient_address_definition_142,axiom,
    ( $true
    & ( addressVal(v7301_range_2_to_0_address_term_bound_16,bitIndex0)
    <=> v7301(constB16,bitIndex0) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_16,bitIndex1)
    <=> v7301(constB16,bitIndex1) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_16,bitIndex2)
    <=> v7301(constB16,bitIndex2) ) ) ).

fof(is_address_164,axiom,
    address(v7301_range_2_to_0_address_term_bound_16) ).

fof(address_association_142,axiom,
    v7301_range_2_to_0_address_association(constB16,v7301_range_2_to_0_address_term_bound_16) ).

fof(address_false_msb_173,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_15,bitIndex4) ).

fof(address_false_msb_172,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_15,bitIndex3) ).

fof(transient_address_definition_141,axiom,
    ( $true
    & ( addressVal(v7301_range_2_to_0_address_term_bound_15,bitIndex0)
    <=> v7301(constB15,bitIndex0) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_15,bitIndex1)
    <=> v7301(constB15,bitIndex1) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_15,bitIndex2)
    <=> v7301(constB15,bitIndex2) ) ) ).

fof(is_address_163,axiom,
    address(v7301_range_2_to_0_address_term_bound_15) ).

fof(address_association_141,axiom,
    v7301_range_2_to_0_address_association(constB15,v7301_range_2_to_0_address_term_bound_15) ).

fof(address_false_msb_171,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_14,bitIndex4) ).

fof(address_false_msb_170,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_14,bitIndex3) ).

fof(transient_address_definition_140,axiom,
    ( $true
    & ( addressVal(v7301_range_2_to_0_address_term_bound_14,bitIndex0)
    <=> v7301(constB14,bitIndex0) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_14,bitIndex1)
    <=> v7301(constB14,bitIndex1) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_14,bitIndex2)
    <=> v7301(constB14,bitIndex2) ) ) ).

fof(is_address_162,axiom,
    address(v7301_range_2_to_0_address_term_bound_14) ).

fof(address_association_140,axiom,
    v7301_range_2_to_0_address_association(constB14,v7301_range_2_to_0_address_term_bound_14) ).

fof(address_false_msb_169,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_13,bitIndex4) ).

fof(address_false_msb_168,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_13,bitIndex3) ).

fof(transient_address_definition_139,axiom,
    ( $true
    & ( addressVal(v7301_range_2_to_0_address_term_bound_13,bitIndex0)
    <=> v7301(constB13,bitIndex0) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_13,bitIndex1)
    <=> v7301(constB13,bitIndex1) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_13,bitIndex2)
    <=> v7301(constB13,bitIndex2) ) ) ).

fof(is_address_161,axiom,
    address(v7301_range_2_to_0_address_term_bound_13) ).

fof(address_association_139,axiom,
    v7301_range_2_to_0_address_association(constB13,v7301_range_2_to_0_address_term_bound_13) ).

fof(address_false_msb_167,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_12,bitIndex4) ).

fof(address_false_msb_166,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_12,bitIndex3) ).

fof(transient_address_definition_138,axiom,
    ( $true
    & ( addressVal(v7301_range_2_to_0_address_term_bound_12,bitIndex0)
    <=> v7301(constB12,bitIndex0) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_12,bitIndex1)
    <=> v7301(constB12,bitIndex1) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_12,bitIndex2)
    <=> v7301(constB12,bitIndex2) ) ) ).

fof(is_address_160,axiom,
    address(v7301_range_2_to_0_address_term_bound_12) ).

fof(address_association_138,axiom,
    v7301_range_2_to_0_address_association(constB12,v7301_range_2_to_0_address_term_bound_12) ).

fof(address_false_msb_165,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_11,bitIndex4) ).

fof(address_false_msb_164,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_11,bitIndex3) ).

fof(transient_address_definition_137,axiom,
    ( $true
    & ( addressVal(v7301_range_2_to_0_address_term_bound_11,bitIndex0)
    <=> v7301(constB11,bitIndex0) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_11,bitIndex1)
    <=> v7301(constB11,bitIndex1) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_11,bitIndex2)
    <=> v7301(constB11,bitIndex2) ) ) ).

fof(is_address_159,axiom,
    address(v7301_range_2_to_0_address_term_bound_11) ).

fof(address_association_137,axiom,
    v7301_range_2_to_0_address_association(constB11,v7301_range_2_to_0_address_term_bound_11) ).

fof(address_false_msb_163,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_10,bitIndex4) ).

fof(address_false_msb_162,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_10,bitIndex3) ).

fof(transient_address_definition_136,axiom,
    ( $true
    & ( addressVal(v7301_range_2_to_0_address_term_bound_10,bitIndex0)
    <=> v7301(constB10,bitIndex0) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_10,bitIndex1)
    <=> v7301(constB10,bitIndex1) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_10,bitIndex2)
    <=> v7301(constB10,bitIndex2) ) ) ).

fof(is_address_158,axiom,
    address(v7301_range_2_to_0_address_term_bound_10) ).

fof(address_association_136,axiom,
    v7301_range_2_to_0_address_association(constB10,v7301_range_2_to_0_address_term_bound_10) ).

fof(address_false_msb_161,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_9,bitIndex4) ).

fof(address_false_msb_160,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_9,bitIndex3) ).

fof(transient_address_definition_135,axiom,
    ( $true
    & ( addressVal(v7301_range_2_to_0_address_term_bound_9,bitIndex0)
    <=> v7301(constB9,bitIndex0) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_9,bitIndex1)
    <=> v7301(constB9,bitIndex1) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_9,bitIndex2)
    <=> v7301(constB9,bitIndex2) ) ) ).

fof(is_address_157,axiom,
    address(v7301_range_2_to_0_address_term_bound_9) ).

fof(address_association_135,axiom,
    v7301_range_2_to_0_address_association(constB9,v7301_range_2_to_0_address_term_bound_9) ).

fof(address_false_msb_159,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_8,bitIndex4) ).

fof(address_false_msb_158,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_8,bitIndex3) ).

fof(transient_address_definition_134,axiom,
    ( $true
    & ( addressVal(v7301_range_2_to_0_address_term_bound_8,bitIndex0)
    <=> v7301(constB8,bitIndex0) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_8,bitIndex1)
    <=> v7301(constB8,bitIndex1) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_8,bitIndex2)
    <=> v7301(constB8,bitIndex2) ) ) ).

fof(is_address_156,axiom,
    address(v7301_range_2_to_0_address_term_bound_8) ).

fof(address_association_134,axiom,
    v7301_range_2_to_0_address_association(constB8,v7301_range_2_to_0_address_term_bound_8) ).

fof(address_false_msb_157,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_7,bitIndex4) ).

fof(address_false_msb_156,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_7,bitIndex3) ).

fof(transient_address_definition_133,axiom,
    ( $true
    & ( addressVal(v7301_range_2_to_0_address_term_bound_7,bitIndex0)
    <=> v7301(constB7,bitIndex0) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_7,bitIndex1)
    <=> v7301(constB7,bitIndex1) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_7,bitIndex2)
    <=> v7301(constB7,bitIndex2) ) ) ).

fof(is_address_155,axiom,
    address(v7301_range_2_to_0_address_term_bound_7) ).

fof(address_association_133,axiom,
    v7301_range_2_to_0_address_association(constB7,v7301_range_2_to_0_address_term_bound_7) ).

fof(address_false_msb_155,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_6,bitIndex4) ).

fof(address_false_msb_154,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_6,bitIndex3) ).

fof(transient_address_definition_132,axiom,
    ( $true
    & ( addressVal(v7301_range_2_to_0_address_term_bound_6,bitIndex0)
    <=> v7301(constB6,bitIndex0) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_6,bitIndex1)
    <=> v7301(constB6,bitIndex1) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_6,bitIndex2)
    <=> v7301(constB6,bitIndex2) ) ) ).

fof(is_address_154,axiom,
    address(v7301_range_2_to_0_address_term_bound_6) ).

fof(address_association_132,axiom,
    v7301_range_2_to_0_address_association(constB6,v7301_range_2_to_0_address_term_bound_6) ).

fof(address_false_msb_153,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_5,bitIndex4) ).

fof(address_false_msb_152,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_5,bitIndex3) ).

fof(transient_address_definition_131,axiom,
    ( $true
    & ( addressVal(v7301_range_2_to_0_address_term_bound_5,bitIndex0)
    <=> v7301(constB5,bitIndex0) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_5,bitIndex1)
    <=> v7301(constB5,bitIndex1) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_5,bitIndex2)
    <=> v7301(constB5,bitIndex2) ) ) ).

fof(is_address_153,axiom,
    address(v7301_range_2_to_0_address_term_bound_5) ).

fof(address_association_131,axiom,
    v7301_range_2_to_0_address_association(constB5,v7301_range_2_to_0_address_term_bound_5) ).

fof(address_false_msb_151,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_4,bitIndex4) ).

fof(address_false_msb_150,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_4,bitIndex3) ).

fof(transient_address_definition_130,axiom,
    ( $true
    & ( addressVal(v7301_range_2_to_0_address_term_bound_4,bitIndex0)
    <=> v7301(constB4,bitIndex0) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_4,bitIndex1)
    <=> v7301(constB4,bitIndex1) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_4,bitIndex2)
    <=> v7301(constB4,bitIndex2) ) ) ).

fof(is_address_152,axiom,
    address(v7301_range_2_to_0_address_term_bound_4) ).

fof(address_association_130,axiom,
    v7301_range_2_to_0_address_association(constB4,v7301_range_2_to_0_address_term_bound_4) ).

fof(address_false_msb_149,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_3,bitIndex4) ).

fof(address_false_msb_148,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_3,bitIndex3) ).

fof(transient_address_definition_129,axiom,
    ( $true
    & ( addressVal(v7301_range_2_to_0_address_term_bound_3,bitIndex0)
    <=> v7301(constB3,bitIndex0) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_3,bitIndex1)
    <=> v7301(constB3,bitIndex1) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_3,bitIndex2)
    <=> v7301(constB3,bitIndex2) ) ) ).

fof(is_address_151,axiom,
    address(v7301_range_2_to_0_address_term_bound_3) ).

fof(address_association_129,axiom,
    v7301_range_2_to_0_address_association(constB3,v7301_range_2_to_0_address_term_bound_3) ).

fof(address_false_msb_147,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_2,bitIndex4) ).

fof(address_false_msb_146,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_2,bitIndex3) ).

fof(transient_address_definition_128,axiom,
    ( $true
    & ( addressVal(v7301_range_2_to_0_address_term_bound_2,bitIndex0)
    <=> v7301(constB2,bitIndex0) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_2,bitIndex1)
    <=> v7301(constB2,bitIndex1) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_2,bitIndex2)
    <=> v7301(constB2,bitIndex2) ) ) ).

fof(is_address_150,axiom,
    address(v7301_range_2_to_0_address_term_bound_2) ).

fof(address_association_128,axiom,
    v7301_range_2_to_0_address_association(constB2,v7301_range_2_to_0_address_term_bound_2) ).

fof(address_false_msb_145,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_1,bitIndex4) ).

fof(address_false_msb_144,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_1,bitIndex3) ).

fof(transient_address_definition_127,axiom,
    ( $true
    & ( addressVal(v7301_range_2_to_0_address_term_bound_1,bitIndex0)
    <=> v7301(constB1,bitIndex0) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_1,bitIndex1)
    <=> v7301(constB1,bitIndex1) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_1,bitIndex2)
    <=> v7301(constB1,bitIndex2) ) ) ).

fof(is_address_149,axiom,
    address(v7301_range_2_to_0_address_term_bound_1) ).

fof(address_association_127,axiom,
    v7301_range_2_to_0_address_association(constB1,v7301_range_2_to_0_address_term_bound_1) ).

fof(address_false_msb_143,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_0,bitIndex4) ).

fof(address_false_msb_142,axiom,
    ~ addressVal(v7301_range_2_to_0_address_term_bound_0,bitIndex3) ).

fof(transient_address_definition_126,axiom,
    ( $true
    & ( addressVal(v7301_range_2_to_0_address_term_bound_0,bitIndex0)
    <=> v7301(constB0,bitIndex0) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_0,bitIndex1)
    <=> v7301(constB0,bitIndex1) )
    & ( addressVal(v7301_range_2_to_0_address_term_bound_0,bitIndex2)
    <=> v7301(constB0,bitIndex2) ) ) ).

fof(is_address_148,axiom,
    address(v7301_range_2_to_0_address_term_bound_0) ).

fof(address_association_126,axiom,
    v7301_range_2_to_0_address_association(constB0,v7301_range_2_to_0_address_term_bound_0) ).

fof(is_address_147,axiom,
    address(b01000_address_term) ).

fof(constant_address_definition_21,axiom,
    ! [B] :
      ( addressVal(b01000_address_term,B)
    <=> b01000(B) ) ).

fof(address_false_msb_141,axiom,
    ~ addressVal(v5438_range_3_to_0_address_term_bound_20,bitIndex4) ).

fof(transient_address_definition_125,axiom,
    ( $true
    & ( addressVal(v5438_range_3_to_0_address_term_bound_20,bitIndex0)
    <=> v5438(constB20,bitIndex0) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_20,bitIndex1)
    <=> v5438(constB20,bitIndex1) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_20,bitIndex2)
    <=> v5438(constB20,bitIndex2) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_20,bitIndex3)
    <=> v5438(constB20,bitIndex3) ) ) ).

fof(is_address_146,axiom,
    address(v5438_range_3_to_0_address_term_bound_20) ).

fof(address_association_125,axiom,
    v5438_range_3_to_0_address_association(constB20,v5438_range_3_to_0_address_term_bound_20) ).

fof(address_false_msb_140,axiom,
    ~ addressVal(v5438_range_3_to_0_address_term_bound_19,bitIndex4) ).

fof(transient_address_definition_124,axiom,
    ( $true
    & ( addressVal(v5438_range_3_to_0_address_term_bound_19,bitIndex0)
    <=> v5438(constB19,bitIndex0) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_19,bitIndex1)
    <=> v5438(constB19,bitIndex1) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_19,bitIndex2)
    <=> v5438(constB19,bitIndex2) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_19,bitIndex3)
    <=> v5438(constB19,bitIndex3) ) ) ).

fof(is_address_145,axiom,
    address(v5438_range_3_to_0_address_term_bound_19) ).

fof(address_association_124,axiom,
    v5438_range_3_to_0_address_association(constB19,v5438_range_3_to_0_address_term_bound_19) ).

fof(address_false_msb_139,axiom,
    ~ addressVal(v5438_range_3_to_0_address_term_bound_18,bitIndex4) ).

fof(transient_address_definition_123,axiom,
    ( $true
    & ( addressVal(v5438_range_3_to_0_address_term_bound_18,bitIndex0)
    <=> v5438(constB18,bitIndex0) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_18,bitIndex1)
    <=> v5438(constB18,bitIndex1) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_18,bitIndex2)
    <=> v5438(constB18,bitIndex2) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_18,bitIndex3)
    <=> v5438(constB18,bitIndex3) ) ) ).

fof(is_address_144,axiom,
    address(v5438_range_3_to_0_address_term_bound_18) ).

fof(address_association_123,axiom,
    v5438_range_3_to_0_address_association(constB18,v5438_range_3_to_0_address_term_bound_18) ).

fof(address_false_msb_138,axiom,
    ~ addressVal(v5438_range_3_to_0_address_term_bound_17,bitIndex4) ).

fof(transient_address_definition_122,axiom,
    ( $true
    & ( addressVal(v5438_range_3_to_0_address_term_bound_17,bitIndex0)
    <=> v5438(constB17,bitIndex0) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_17,bitIndex1)
    <=> v5438(constB17,bitIndex1) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_17,bitIndex2)
    <=> v5438(constB17,bitIndex2) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_17,bitIndex3)
    <=> v5438(constB17,bitIndex3) ) ) ).

fof(is_address_143,axiom,
    address(v5438_range_3_to_0_address_term_bound_17) ).

fof(address_association_122,axiom,
    v5438_range_3_to_0_address_association(constB17,v5438_range_3_to_0_address_term_bound_17) ).

fof(address_false_msb_137,axiom,
    ~ addressVal(v5438_range_3_to_0_address_term_bound_16,bitIndex4) ).

fof(transient_address_definition_121,axiom,
    ( $true
    & ( addressVal(v5438_range_3_to_0_address_term_bound_16,bitIndex0)
    <=> v5438(constB16,bitIndex0) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_16,bitIndex1)
    <=> v5438(constB16,bitIndex1) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_16,bitIndex2)
    <=> v5438(constB16,bitIndex2) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_16,bitIndex3)
    <=> v5438(constB16,bitIndex3) ) ) ).

fof(is_address_142,axiom,
    address(v5438_range_3_to_0_address_term_bound_16) ).

fof(address_association_121,axiom,
    v5438_range_3_to_0_address_association(constB16,v5438_range_3_to_0_address_term_bound_16) ).

fof(address_false_msb_136,axiom,
    ~ addressVal(v5438_range_3_to_0_address_term_bound_15,bitIndex4) ).

fof(transient_address_definition_120,axiom,
    ( $true
    & ( addressVal(v5438_range_3_to_0_address_term_bound_15,bitIndex0)
    <=> v5438(constB15,bitIndex0) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_15,bitIndex1)
    <=> v5438(constB15,bitIndex1) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_15,bitIndex2)
    <=> v5438(constB15,bitIndex2) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_15,bitIndex3)
    <=> v5438(constB15,bitIndex3) ) ) ).

fof(is_address_141,axiom,
    address(v5438_range_3_to_0_address_term_bound_15) ).

fof(address_association_120,axiom,
    v5438_range_3_to_0_address_association(constB15,v5438_range_3_to_0_address_term_bound_15) ).

fof(address_false_msb_135,axiom,
    ~ addressVal(v5438_range_3_to_0_address_term_bound_14,bitIndex4) ).

fof(transient_address_definition_119,axiom,
    ( $true
    & ( addressVal(v5438_range_3_to_0_address_term_bound_14,bitIndex0)
    <=> v5438(constB14,bitIndex0) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_14,bitIndex1)
    <=> v5438(constB14,bitIndex1) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_14,bitIndex2)
    <=> v5438(constB14,bitIndex2) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_14,bitIndex3)
    <=> v5438(constB14,bitIndex3) ) ) ).

fof(is_address_140,axiom,
    address(v5438_range_3_to_0_address_term_bound_14) ).

fof(address_association_119,axiom,
    v5438_range_3_to_0_address_association(constB14,v5438_range_3_to_0_address_term_bound_14) ).

fof(address_false_msb_134,axiom,
    ~ addressVal(v5438_range_3_to_0_address_term_bound_13,bitIndex4) ).

fof(transient_address_definition_118,axiom,
    ( $true
    & ( addressVal(v5438_range_3_to_0_address_term_bound_13,bitIndex0)
    <=> v5438(constB13,bitIndex0) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_13,bitIndex1)
    <=> v5438(constB13,bitIndex1) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_13,bitIndex2)
    <=> v5438(constB13,bitIndex2) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_13,bitIndex3)
    <=> v5438(constB13,bitIndex3) ) ) ).

fof(is_address_139,axiom,
    address(v5438_range_3_to_0_address_term_bound_13) ).

fof(address_association_118,axiom,
    v5438_range_3_to_0_address_association(constB13,v5438_range_3_to_0_address_term_bound_13) ).

fof(address_false_msb_133,axiom,
    ~ addressVal(v5438_range_3_to_0_address_term_bound_12,bitIndex4) ).

fof(transient_address_definition_117,axiom,
    ( $true
    & ( addressVal(v5438_range_3_to_0_address_term_bound_12,bitIndex0)
    <=> v5438(constB12,bitIndex0) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_12,bitIndex1)
    <=> v5438(constB12,bitIndex1) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_12,bitIndex2)
    <=> v5438(constB12,bitIndex2) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_12,bitIndex3)
    <=> v5438(constB12,bitIndex3) ) ) ).

fof(is_address_138,axiom,
    address(v5438_range_3_to_0_address_term_bound_12) ).

fof(address_association_117,axiom,
    v5438_range_3_to_0_address_association(constB12,v5438_range_3_to_0_address_term_bound_12) ).

fof(address_false_msb_132,axiom,
    ~ addressVal(v5438_range_3_to_0_address_term_bound_11,bitIndex4) ).

fof(transient_address_definition_116,axiom,
    ( $true
    & ( addressVal(v5438_range_3_to_0_address_term_bound_11,bitIndex0)
    <=> v5438(constB11,bitIndex0) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_11,bitIndex1)
    <=> v5438(constB11,bitIndex1) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_11,bitIndex2)
    <=> v5438(constB11,bitIndex2) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_11,bitIndex3)
    <=> v5438(constB11,bitIndex3) ) ) ).

fof(is_address_137,axiom,
    address(v5438_range_3_to_0_address_term_bound_11) ).

fof(address_association_116,axiom,
    v5438_range_3_to_0_address_association(constB11,v5438_range_3_to_0_address_term_bound_11) ).

fof(address_false_msb_131,axiom,
    ~ addressVal(v5438_range_3_to_0_address_term_bound_10,bitIndex4) ).

fof(transient_address_definition_115,axiom,
    ( $true
    & ( addressVal(v5438_range_3_to_0_address_term_bound_10,bitIndex0)
    <=> v5438(constB10,bitIndex0) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_10,bitIndex1)
    <=> v5438(constB10,bitIndex1) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_10,bitIndex2)
    <=> v5438(constB10,bitIndex2) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_10,bitIndex3)
    <=> v5438(constB10,bitIndex3) ) ) ).

fof(is_address_136,axiom,
    address(v5438_range_3_to_0_address_term_bound_10) ).

fof(address_association_115,axiom,
    v5438_range_3_to_0_address_association(constB10,v5438_range_3_to_0_address_term_bound_10) ).

fof(address_false_msb_130,axiom,
    ~ addressVal(v5438_range_3_to_0_address_term_bound_9,bitIndex4) ).

fof(transient_address_definition_114,axiom,
    ( $true
    & ( addressVal(v5438_range_3_to_0_address_term_bound_9,bitIndex0)
    <=> v5438(constB9,bitIndex0) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_9,bitIndex1)
    <=> v5438(constB9,bitIndex1) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_9,bitIndex2)
    <=> v5438(constB9,bitIndex2) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_9,bitIndex3)
    <=> v5438(constB9,bitIndex3) ) ) ).

fof(is_address_135,axiom,
    address(v5438_range_3_to_0_address_term_bound_9) ).

fof(address_association_114,axiom,
    v5438_range_3_to_0_address_association(constB9,v5438_range_3_to_0_address_term_bound_9) ).

fof(address_false_msb_129,axiom,
    ~ addressVal(v5438_range_3_to_0_address_term_bound_8,bitIndex4) ).

fof(transient_address_definition_113,axiom,
    ( $true
    & ( addressVal(v5438_range_3_to_0_address_term_bound_8,bitIndex0)
    <=> v5438(constB8,bitIndex0) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_8,bitIndex1)
    <=> v5438(constB8,bitIndex1) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_8,bitIndex2)
    <=> v5438(constB8,bitIndex2) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_8,bitIndex3)
    <=> v5438(constB8,bitIndex3) ) ) ).

fof(is_address_134,axiom,
    address(v5438_range_3_to_0_address_term_bound_8) ).

fof(address_association_113,axiom,
    v5438_range_3_to_0_address_association(constB8,v5438_range_3_to_0_address_term_bound_8) ).

fof(address_false_msb_128,axiom,
    ~ addressVal(v5438_range_3_to_0_address_term_bound_7,bitIndex4) ).

fof(transient_address_definition_112,axiom,
    ( $true
    & ( addressVal(v5438_range_3_to_0_address_term_bound_7,bitIndex0)
    <=> v5438(constB7,bitIndex0) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_7,bitIndex1)
    <=> v5438(constB7,bitIndex1) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_7,bitIndex2)
    <=> v5438(constB7,bitIndex2) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_7,bitIndex3)
    <=> v5438(constB7,bitIndex3) ) ) ).

fof(is_address_133,axiom,
    address(v5438_range_3_to_0_address_term_bound_7) ).

fof(address_association_112,axiom,
    v5438_range_3_to_0_address_association(constB7,v5438_range_3_to_0_address_term_bound_7) ).

fof(address_false_msb_127,axiom,
    ~ addressVal(v5438_range_3_to_0_address_term_bound_6,bitIndex4) ).

fof(transient_address_definition_111,axiom,
    ( $true
    & ( addressVal(v5438_range_3_to_0_address_term_bound_6,bitIndex0)
    <=> v5438(constB6,bitIndex0) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_6,bitIndex1)
    <=> v5438(constB6,bitIndex1) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_6,bitIndex2)
    <=> v5438(constB6,bitIndex2) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_6,bitIndex3)
    <=> v5438(constB6,bitIndex3) ) ) ).

fof(is_address_132,axiom,
    address(v5438_range_3_to_0_address_term_bound_6) ).

fof(address_association_111,axiom,
    v5438_range_3_to_0_address_association(constB6,v5438_range_3_to_0_address_term_bound_6) ).

fof(address_false_msb_126,axiom,
    ~ addressVal(v5438_range_3_to_0_address_term_bound_5,bitIndex4) ).

fof(transient_address_definition_110,axiom,
    ( $true
    & ( addressVal(v5438_range_3_to_0_address_term_bound_5,bitIndex0)
    <=> v5438(constB5,bitIndex0) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_5,bitIndex1)
    <=> v5438(constB5,bitIndex1) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_5,bitIndex2)
    <=> v5438(constB5,bitIndex2) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_5,bitIndex3)
    <=> v5438(constB5,bitIndex3) ) ) ).

fof(is_address_131,axiom,
    address(v5438_range_3_to_0_address_term_bound_5) ).

fof(address_association_110,axiom,
    v5438_range_3_to_0_address_association(constB5,v5438_range_3_to_0_address_term_bound_5) ).

fof(address_false_msb_125,axiom,
    ~ addressVal(v5438_range_3_to_0_address_term_bound_4,bitIndex4) ).

fof(transient_address_definition_109,axiom,
    ( $true
    & ( addressVal(v5438_range_3_to_0_address_term_bound_4,bitIndex0)
    <=> v5438(constB4,bitIndex0) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_4,bitIndex1)
    <=> v5438(constB4,bitIndex1) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_4,bitIndex2)
    <=> v5438(constB4,bitIndex2) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_4,bitIndex3)
    <=> v5438(constB4,bitIndex3) ) ) ).

fof(is_address_130,axiom,
    address(v5438_range_3_to_0_address_term_bound_4) ).

fof(address_association_109,axiom,
    v5438_range_3_to_0_address_association(constB4,v5438_range_3_to_0_address_term_bound_4) ).

fof(address_false_msb_124,axiom,
    ~ addressVal(v5438_range_3_to_0_address_term_bound_3,bitIndex4) ).

fof(transient_address_definition_108,axiom,
    ( $true
    & ( addressVal(v5438_range_3_to_0_address_term_bound_3,bitIndex0)
    <=> v5438(constB3,bitIndex0) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_3,bitIndex1)
    <=> v5438(constB3,bitIndex1) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_3,bitIndex2)
    <=> v5438(constB3,bitIndex2) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_3,bitIndex3)
    <=> v5438(constB3,bitIndex3) ) ) ).

fof(is_address_129,axiom,
    address(v5438_range_3_to_0_address_term_bound_3) ).

fof(address_association_108,axiom,
    v5438_range_3_to_0_address_association(constB3,v5438_range_3_to_0_address_term_bound_3) ).

fof(address_false_msb_123,axiom,
    ~ addressVal(v5438_range_3_to_0_address_term_bound_2,bitIndex4) ).

fof(transient_address_definition_107,axiom,
    ( $true
    & ( addressVal(v5438_range_3_to_0_address_term_bound_2,bitIndex0)
    <=> v5438(constB2,bitIndex0) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_2,bitIndex1)
    <=> v5438(constB2,bitIndex1) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_2,bitIndex2)
    <=> v5438(constB2,bitIndex2) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_2,bitIndex3)
    <=> v5438(constB2,bitIndex3) ) ) ).

fof(is_address_128,axiom,
    address(v5438_range_3_to_0_address_term_bound_2) ).

fof(address_association_107,axiom,
    v5438_range_3_to_0_address_association(constB2,v5438_range_3_to_0_address_term_bound_2) ).

fof(address_false_msb_122,axiom,
    ~ addressVal(v5438_range_3_to_0_address_term_bound_1,bitIndex4) ).

fof(transient_address_definition_106,axiom,
    ( $true
    & ( addressVal(v5438_range_3_to_0_address_term_bound_1,bitIndex0)
    <=> v5438(constB1,bitIndex0) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_1,bitIndex1)
    <=> v5438(constB1,bitIndex1) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_1,bitIndex2)
    <=> v5438(constB1,bitIndex2) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_1,bitIndex3)
    <=> v5438(constB1,bitIndex3) ) ) ).

fof(is_address_127,axiom,
    address(v5438_range_3_to_0_address_term_bound_1) ).

fof(address_association_106,axiom,
    v5438_range_3_to_0_address_association(constB1,v5438_range_3_to_0_address_term_bound_1) ).

fof(address_false_msb_121,axiom,
    ~ addressVal(v5438_range_3_to_0_address_term_bound_0,bitIndex4) ).

fof(transient_address_definition_105,axiom,
    ( $true
    & ( addressVal(v5438_range_3_to_0_address_term_bound_0,bitIndex0)
    <=> v5438(constB0,bitIndex0) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_0,bitIndex1)
    <=> v5438(constB0,bitIndex1) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_0,bitIndex2)
    <=> v5438(constB0,bitIndex2) )
    & ( addressVal(v5438_range_3_to_0_address_term_bound_0,bitIndex3)
    <=> v5438(constB0,bitIndex3) ) ) ).

fof(is_address_126,axiom,
    address(v5438_range_3_to_0_address_term_bound_0) ).

fof(address_association_105,axiom,
    v5438_range_3_to_0_address_association(constB0,v5438_range_3_to_0_address_term_bound_0) ).

fof(address_false_msb_120,axiom,
    ~ addressVal(v5372_range_3_to_0_address_term_bound_20,bitIndex4) ).

fof(transient_address_definition_104,axiom,
    ( $true
    & ( addressVal(v5372_range_3_to_0_address_term_bound_20,bitIndex0)
    <=> v5372(constB20,bitIndex0) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_20,bitIndex1)
    <=> v5372(constB20,bitIndex1) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_20,bitIndex2)
    <=> v5372(constB20,bitIndex2) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_20,bitIndex3)
    <=> v5372(constB20,bitIndex3) ) ) ).

fof(is_address_125,axiom,
    address(v5372_range_3_to_0_address_term_bound_20) ).

fof(address_association_104,axiom,
    v5372_range_3_to_0_address_association(constB20,v5372_range_3_to_0_address_term_bound_20) ).

fof(address_false_msb_119,axiom,
    ~ addressVal(v5372_range_3_to_0_address_term_bound_19,bitIndex4) ).

fof(transient_address_definition_103,axiom,
    ( $true
    & ( addressVal(v5372_range_3_to_0_address_term_bound_19,bitIndex0)
    <=> v5372(constB19,bitIndex0) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_19,bitIndex1)
    <=> v5372(constB19,bitIndex1) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_19,bitIndex2)
    <=> v5372(constB19,bitIndex2) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_19,bitIndex3)
    <=> v5372(constB19,bitIndex3) ) ) ).

fof(is_address_124,axiom,
    address(v5372_range_3_to_0_address_term_bound_19) ).

fof(address_association_103,axiom,
    v5372_range_3_to_0_address_association(constB19,v5372_range_3_to_0_address_term_bound_19) ).

fof(address_false_msb_118,axiom,
    ~ addressVal(v5372_range_3_to_0_address_term_bound_18,bitIndex4) ).

fof(transient_address_definition_102,axiom,
    ( $true
    & ( addressVal(v5372_range_3_to_0_address_term_bound_18,bitIndex0)
    <=> v5372(constB18,bitIndex0) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_18,bitIndex1)
    <=> v5372(constB18,bitIndex1) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_18,bitIndex2)
    <=> v5372(constB18,bitIndex2) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_18,bitIndex3)
    <=> v5372(constB18,bitIndex3) ) ) ).

fof(is_address_123,axiom,
    address(v5372_range_3_to_0_address_term_bound_18) ).

fof(address_association_102,axiom,
    v5372_range_3_to_0_address_association(constB18,v5372_range_3_to_0_address_term_bound_18) ).

fof(address_false_msb_117,axiom,
    ~ addressVal(v5372_range_3_to_0_address_term_bound_17,bitIndex4) ).

fof(transient_address_definition_101,axiom,
    ( $true
    & ( addressVal(v5372_range_3_to_0_address_term_bound_17,bitIndex0)
    <=> v5372(constB17,bitIndex0) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_17,bitIndex1)
    <=> v5372(constB17,bitIndex1) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_17,bitIndex2)
    <=> v5372(constB17,bitIndex2) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_17,bitIndex3)
    <=> v5372(constB17,bitIndex3) ) ) ).

fof(is_address_122,axiom,
    address(v5372_range_3_to_0_address_term_bound_17) ).

fof(address_association_101,axiom,
    v5372_range_3_to_0_address_association(constB17,v5372_range_3_to_0_address_term_bound_17) ).

fof(address_false_msb_116,axiom,
    ~ addressVal(v5372_range_3_to_0_address_term_bound_16,bitIndex4) ).

fof(transient_address_definition_100,axiom,
    ( $true
    & ( addressVal(v5372_range_3_to_0_address_term_bound_16,bitIndex0)
    <=> v5372(constB16,bitIndex0) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_16,bitIndex1)
    <=> v5372(constB16,bitIndex1) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_16,bitIndex2)
    <=> v5372(constB16,bitIndex2) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_16,bitIndex3)
    <=> v5372(constB16,bitIndex3) ) ) ).

fof(is_address_121,axiom,
    address(v5372_range_3_to_0_address_term_bound_16) ).

fof(address_association_100,axiom,
    v5372_range_3_to_0_address_association(constB16,v5372_range_3_to_0_address_term_bound_16) ).

fof(address_false_msb_115,axiom,
    ~ addressVal(v5372_range_3_to_0_address_term_bound_15,bitIndex4) ).

fof(transient_address_definition_99,axiom,
    ( $true
    & ( addressVal(v5372_range_3_to_0_address_term_bound_15,bitIndex0)
    <=> v5372(constB15,bitIndex0) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_15,bitIndex1)
    <=> v5372(constB15,bitIndex1) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_15,bitIndex2)
    <=> v5372(constB15,bitIndex2) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_15,bitIndex3)
    <=> v5372(constB15,bitIndex3) ) ) ).

fof(is_address_120,axiom,
    address(v5372_range_3_to_0_address_term_bound_15) ).

fof(address_association_99,axiom,
    v5372_range_3_to_0_address_association(constB15,v5372_range_3_to_0_address_term_bound_15) ).

fof(address_false_msb_114,axiom,
    ~ addressVal(v5372_range_3_to_0_address_term_bound_14,bitIndex4) ).

fof(transient_address_definition_98,axiom,
    ( $true
    & ( addressVal(v5372_range_3_to_0_address_term_bound_14,bitIndex0)
    <=> v5372(constB14,bitIndex0) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_14,bitIndex1)
    <=> v5372(constB14,bitIndex1) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_14,bitIndex2)
    <=> v5372(constB14,bitIndex2) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_14,bitIndex3)
    <=> v5372(constB14,bitIndex3) ) ) ).

fof(is_address_119,axiom,
    address(v5372_range_3_to_0_address_term_bound_14) ).

fof(address_association_98,axiom,
    v5372_range_3_to_0_address_association(constB14,v5372_range_3_to_0_address_term_bound_14) ).

fof(address_false_msb_113,axiom,
    ~ addressVal(v5372_range_3_to_0_address_term_bound_13,bitIndex4) ).

fof(transient_address_definition_97,axiom,
    ( $true
    & ( addressVal(v5372_range_3_to_0_address_term_bound_13,bitIndex0)
    <=> v5372(constB13,bitIndex0) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_13,bitIndex1)
    <=> v5372(constB13,bitIndex1) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_13,bitIndex2)
    <=> v5372(constB13,bitIndex2) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_13,bitIndex3)
    <=> v5372(constB13,bitIndex3) ) ) ).

fof(is_address_118,axiom,
    address(v5372_range_3_to_0_address_term_bound_13) ).

fof(address_association_97,axiom,
    v5372_range_3_to_0_address_association(constB13,v5372_range_3_to_0_address_term_bound_13) ).

fof(address_false_msb_112,axiom,
    ~ addressVal(v5372_range_3_to_0_address_term_bound_12,bitIndex4) ).

fof(transient_address_definition_96,axiom,
    ( $true
    & ( addressVal(v5372_range_3_to_0_address_term_bound_12,bitIndex0)
    <=> v5372(constB12,bitIndex0) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_12,bitIndex1)
    <=> v5372(constB12,bitIndex1) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_12,bitIndex2)
    <=> v5372(constB12,bitIndex2) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_12,bitIndex3)
    <=> v5372(constB12,bitIndex3) ) ) ).

fof(is_address_117,axiom,
    address(v5372_range_3_to_0_address_term_bound_12) ).

fof(address_association_96,axiom,
    v5372_range_3_to_0_address_association(constB12,v5372_range_3_to_0_address_term_bound_12) ).

fof(address_false_msb_111,axiom,
    ~ addressVal(v5372_range_3_to_0_address_term_bound_11,bitIndex4) ).

fof(transient_address_definition_95,axiom,
    ( $true
    & ( addressVal(v5372_range_3_to_0_address_term_bound_11,bitIndex0)
    <=> v5372(constB11,bitIndex0) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_11,bitIndex1)
    <=> v5372(constB11,bitIndex1) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_11,bitIndex2)
    <=> v5372(constB11,bitIndex2) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_11,bitIndex3)
    <=> v5372(constB11,bitIndex3) ) ) ).

fof(is_address_116,axiom,
    address(v5372_range_3_to_0_address_term_bound_11) ).

fof(address_association_95,axiom,
    v5372_range_3_to_0_address_association(constB11,v5372_range_3_to_0_address_term_bound_11) ).

fof(address_false_msb_110,axiom,
    ~ addressVal(v5372_range_3_to_0_address_term_bound_10,bitIndex4) ).

fof(transient_address_definition_94,axiom,
    ( $true
    & ( addressVal(v5372_range_3_to_0_address_term_bound_10,bitIndex0)
    <=> v5372(constB10,bitIndex0) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_10,bitIndex1)
    <=> v5372(constB10,bitIndex1) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_10,bitIndex2)
    <=> v5372(constB10,bitIndex2) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_10,bitIndex3)
    <=> v5372(constB10,bitIndex3) ) ) ).

fof(is_address_115,axiom,
    address(v5372_range_3_to_0_address_term_bound_10) ).

fof(address_association_94,axiom,
    v5372_range_3_to_0_address_association(constB10,v5372_range_3_to_0_address_term_bound_10) ).

fof(address_false_msb_109,axiom,
    ~ addressVal(v5372_range_3_to_0_address_term_bound_9,bitIndex4) ).

fof(transient_address_definition_93,axiom,
    ( $true
    & ( addressVal(v5372_range_3_to_0_address_term_bound_9,bitIndex0)
    <=> v5372(constB9,bitIndex0) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_9,bitIndex1)
    <=> v5372(constB9,bitIndex1) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_9,bitIndex2)
    <=> v5372(constB9,bitIndex2) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_9,bitIndex3)
    <=> v5372(constB9,bitIndex3) ) ) ).

fof(is_address_114,axiom,
    address(v5372_range_3_to_0_address_term_bound_9) ).

fof(address_association_93,axiom,
    v5372_range_3_to_0_address_association(constB9,v5372_range_3_to_0_address_term_bound_9) ).

fof(address_false_msb_108,axiom,
    ~ addressVal(v5372_range_3_to_0_address_term_bound_8,bitIndex4) ).

fof(transient_address_definition_92,axiom,
    ( $true
    & ( addressVal(v5372_range_3_to_0_address_term_bound_8,bitIndex0)
    <=> v5372(constB8,bitIndex0) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_8,bitIndex1)
    <=> v5372(constB8,bitIndex1) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_8,bitIndex2)
    <=> v5372(constB8,bitIndex2) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_8,bitIndex3)
    <=> v5372(constB8,bitIndex3) ) ) ).

fof(is_address_113,axiom,
    address(v5372_range_3_to_0_address_term_bound_8) ).

fof(address_association_92,axiom,
    v5372_range_3_to_0_address_association(constB8,v5372_range_3_to_0_address_term_bound_8) ).

fof(address_false_msb_107,axiom,
    ~ addressVal(v5372_range_3_to_0_address_term_bound_7,bitIndex4) ).

fof(transient_address_definition_91,axiom,
    ( $true
    & ( addressVal(v5372_range_3_to_0_address_term_bound_7,bitIndex0)
    <=> v5372(constB7,bitIndex0) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_7,bitIndex1)
    <=> v5372(constB7,bitIndex1) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_7,bitIndex2)
    <=> v5372(constB7,bitIndex2) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_7,bitIndex3)
    <=> v5372(constB7,bitIndex3) ) ) ).

fof(is_address_112,axiom,
    address(v5372_range_3_to_0_address_term_bound_7) ).

fof(address_association_91,axiom,
    v5372_range_3_to_0_address_association(constB7,v5372_range_3_to_0_address_term_bound_7) ).

fof(address_false_msb_106,axiom,
    ~ addressVal(v5372_range_3_to_0_address_term_bound_6,bitIndex4) ).

fof(transient_address_definition_90,axiom,
    ( $true
    & ( addressVal(v5372_range_3_to_0_address_term_bound_6,bitIndex0)
    <=> v5372(constB6,bitIndex0) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_6,bitIndex1)
    <=> v5372(constB6,bitIndex1) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_6,bitIndex2)
    <=> v5372(constB6,bitIndex2) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_6,bitIndex3)
    <=> v5372(constB6,bitIndex3) ) ) ).

fof(is_address_111,axiom,
    address(v5372_range_3_to_0_address_term_bound_6) ).

fof(address_association_90,axiom,
    v5372_range_3_to_0_address_association(constB6,v5372_range_3_to_0_address_term_bound_6) ).

fof(address_false_msb_105,axiom,
    ~ addressVal(v5372_range_3_to_0_address_term_bound_5,bitIndex4) ).

fof(transient_address_definition_89,axiom,
    ( $true
    & ( addressVal(v5372_range_3_to_0_address_term_bound_5,bitIndex0)
    <=> v5372(constB5,bitIndex0) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_5,bitIndex1)
    <=> v5372(constB5,bitIndex1) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_5,bitIndex2)
    <=> v5372(constB5,bitIndex2) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_5,bitIndex3)
    <=> v5372(constB5,bitIndex3) ) ) ).

fof(is_address_110,axiom,
    address(v5372_range_3_to_0_address_term_bound_5) ).

fof(address_association_89,axiom,
    v5372_range_3_to_0_address_association(constB5,v5372_range_3_to_0_address_term_bound_5) ).

fof(address_false_msb_104,axiom,
    ~ addressVal(v5372_range_3_to_0_address_term_bound_4,bitIndex4) ).

fof(transient_address_definition_88,axiom,
    ( $true
    & ( addressVal(v5372_range_3_to_0_address_term_bound_4,bitIndex0)
    <=> v5372(constB4,bitIndex0) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_4,bitIndex1)
    <=> v5372(constB4,bitIndex1) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_4,bitIndex2)
    <=> v5372(constB4,bitIndex2) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_4,bitIndex3)
    <=> v5372(constB4,bitIndex3) ) ) ).

fof(is_address_109,axiom,
    address(v5372_range_3_to_0_address_term_bound_4) ).

fof(address_association_88,axiom,
    v5372_range_3_to_0_address_association(constB4,v5372_range_3_to_0_address_term_bound_4) ).

fof(address_false_msb_103,axiom,
    ~ addressVal(v5372_range_3_to_0_address_term_bound_3,bitIndex4) ).

fof(transient_address_definition_87,axiom,
    ( $true
    & ( addressVal(v5372_range_3_to_0_address_term_bound_3,bitIndex0)
    <=> v5372(constB3,bitIndex0) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_3,bitIndex1)
    <=> v5372(constB3,bitIndex1) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_3,bitIndex2)
    <=> v5372(constB3,bitIndex2) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_3,bitIndex3)
    <=> v5372(constB3,bitIndex3) ) ) ).

fof(is_address_108,axiom,
    address(v5372_range_3_to_0_address_term_bound_3) ).

fof(address_association_87,axiom,
    v5372_range_3_to_0_address_association(constB3,v5372_range_3_to_0_address_term_bound_3) ).

fof(address_false_msb_102,axiom,
    ~ addressVal(v5372_range_3_to_0_address_term_bound_2,bitIndex4) ).

fof(transient_address_definition_86,axiom,
    ( $true
    & ( addressVal(v5372_range_3_to_0_address_term_bound_2,bitIndex0)
    <=> v5372(constB2,bitIndex0) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_2,bitIndex1)
    <=> v5372(constB2,bitIndex1) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_2,bitIndex2)
    <=> v5372(constB2,bitIndex2) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_2,bitIndex3)
    <=> v5372(constB2,bitIndex3) ) ) ).

fof(is_address_107,axiom,
    address(v5372_range_3_to_0_address_term_bound_2) ).

fof(address_association_86,axiom,
    v5372_range_3_to_0_address_association(constB2,v5372_range_3_to_0_address_term_bound_2) ).

fof(address_false_msb_101,axiom,
    ~ addressVal(v5372_range_3_to_0_address_term_bound_1,bitIndex4) ).

fof(transient_address_definition_85,axiom,
    ( $true
    & ( addressVal(v5372_range_3_to_0_address_term_bound_1,bitIndex0)
    <=> v5372(constB1,bitIndex0) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_1,bitIndex1)
    <=> v5372(constB1,bitIndex1) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_1,bitIndex2)
    <=> v5372(constB1,bitIndex2) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_1,bitIndex3)
    <=> v5372(constB1,bitIndex3) ) ) ).

fof(is_address_106,axiom,
    address(v5372_range_3_to_0_address_term_bound_1) ).

fof(address_association_85,axiom,
    v5372_range_3_to_0_address_association(constB1,v5372_range_3_to_0_address_term_bound_1) ).

fof(address_false_msb_100,axiom,
    ~ addressVal(v5372_range_3_to_0_address_term_bound_0,bitIndex4) ).

fof(transient_address_definition_84,axiom,
    ( $true
    & ( addressVal(v5372_range_3_to_0_address_term_bound_0,bitIndex0)
    <=> v5372(constB0,bitIndex0) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_0,bitIndex1)
    <=> v5372(constB0,bitIndex1) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_0,bitIndex2)
    <=> v5372(constB0,bitIndex2) )
    & ( addressVal(v5372_range_3_to_0_address_term_bound_0,bitIndex3)
    <=> v5372(constB0,bitIndex3) ) ) ).

fof(is_address_105,axiom,
    address(v5372_range_3_to_0_address_term_bound_0) ).

fof(address_association_84,axiom,
    v5372_range_3_to_0_address_association(constB0,v5372_range_3_to_0_address_term_bound_0) ).

fof(address_false_msb_99,axiom,
    ~ addressVal(v4093_range_3_to_0_address_term_bound_20,bitIndex4) ).

fof(transient_address_definition_83,axiom,
    ( $true
    & ( addressVal(v4093_range_3_to_0_address_term_bound_20,bitIndex0)
    <=> v4093(constB20,bitIndex0) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_20,bitIndex1)
    <=> v4093(constB20,bitIndex1) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_20,bitIndex2)
    <=> v4093(constB20,bitIndex2) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_20,bitIndex3)
    <=> v4093(constB20,bitIndex3) ) ) ).

fof(is_address_104,axiom,
    address(v4093_range_3_to_0_address_term_bound_20) ).

fof(address_association_83,axiom,
    v4093_range_3_to_0_address_association(constB20,v4093_range_3_to_0_address_term_bound_20) ).

fof(address_false_msb_98,axiom,
    ~ addressVal(v4093_range_3_to_0_address_term_bound_19,bitIndex4) ).

fof(transient_address_definition_82,axiom,
    ( $true
    & ( addressVal(v4093_range_3_to_0_address_term_bound_19,bitIndex0)
    <=> v4093(constB19,bitIndex0) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_19,bitIndex1)
    <=> v4093(constB19,bitIndex1) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_19,bitIndex2)
    <=> v4093(constB19,bitIndex2) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_19,bitIndex3)
    <=> v4093(constB19,bitIndex3) ) ) ).

fof(is_address_103,axiom,
    address(v4093_range_3_to_0_address_term_bound_19) ).

fof(address_association_82,axiom,
    v4093_range_3_to_0_address_association(constB19,v4093_range_3_to_0_address_term_bound_19) ).

fof(address_false_msb_97,axiom,
    ~ addressVal(v4093_range_3_to_0_address_term_bound_18,bitIndex4) ).

fof(transient_address_definition_81,axiom,
    ( $true
    & ( addressVal(v4093_range_3_to_0_address_term_bound_18,bitIndex0)
    <=> v4093(constB18,bitIndex0) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_18,bitIndex1)
    <=> v4093(constB18,bitIndex1) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_18,bitIndex2)
    <=> v4093(constB18,bitIndex2) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_18,bitIndex3)
    <=> v4093(constB18,bitIndex3) ) ) ).

fof(is_address_102,axiom,
    address(v4093_range_3_to_0_address_term_bound_18) ).

fof(address_association_81,axiom,
    v4093_range_3_to_0_address_association(constB18,v4093_range_3_to_0_address_term_bound_18) ).

fof(address_false_msb_96,axiom,
    ~ addressVal(v4093_range_3_to_0_address_term_bound_17,bitIndex4) ).

fof(transient_address_definition_80,axiom,
    ( $true
    & ( addressVal(v4093_range_3_to_0_address_term_bound_17,bitIndex0)
    <=> v4093(constB17,bitIndex0) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_17,bitIndex1)
    <=> v4093(constB17,bitIndex1) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_17,bitIndex2)
    <=> v4093(constB17,bitIndex2) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_17,bitIndex3)
    <=> v4093(constB17,bitIndex3) ) ) ).

fof(is_address_101,axiom,
    address(v4093_range_3_to_0_address_term_bound_17) ).

fof(address_association_80,axiom,
    v4093_range_3_to_0_address_association(constB17,v4093_range_3_to_0_address_term_bound_17) ).

fof(address_false_msb_95,axiom,
    ~ addressVal(v4093_range_3_to_0_address_term_bound_16,bitIndex4) ).

fof(transient_address_definition_79,axiom,
    ( $true
    & ( addressVal(v4093_range_3_to_0_address_term_bound_16,bitIndex0)
    <=> v4093(constB16,bitIndex0) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_16,bitIndex1)
    <=> v4093(constB16,bitIndex1) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_16,bitIndex2)
    <=> v4093(constB16,bitIndex2) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_16,bitIndex3)
    <=> v4093(constB16,bitIndex3) ) ) ).

fof(is_address_100,axiom,
    address(v4093_range_3_to_0_address_term_bound_16) ).

fof(address_association_79,axiom,
    v4093_range_3_to_0_address_association(constB16,v4093_range_3_to_0_address_term_bound_16) ).

fof(address_false_msb_94,axiom,
    ~ addressVal(v4093_range_3_to_0_address_term_bound_15,bitIndex4) ).

fof(transient_address_definition_78,axiom,
    ( $true
    & ( addressVal(v4093_range_3_to_0_address_term_bound_15,bitIndex0)
    <=> v4093(constB15,bitIndex0) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_15,bitIndex1)
    <=> v4093(constB15,bitIndex1) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_15,bitIndex2)
    <=> v4093(constB15,bitIndex2) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_15,bitIndex3)
    <=> v4093(constB15,bitIndex3) ) ) ).

fof(is_address_99,axiom,
    address(v4093_range_3_to_0_address_term_bound_15) ).

fof(address_association_78,axiom,
    v4093_range_3_to_0_address_association(constB15,v4093_range_3_to_0_address_term_bound_15) ).

fof(address_false_msb_93,axiom,
    ~ addressVal(v4093_range_3_to_0_address_term_bound_14,bitIndex4) ).

fof(transient_address_definition_77,axiom,
    ( $true
    & ( addressVal(v4093_range_3_to_0_address_term_bound_14,bitIndex0)
    <=> v4093(constB14,bitIndex0) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_14,bitIndex1)
    <=> v4093(constB14,bitIndex1) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_14,bitIndex2)
    <=> v4093(constB14,bitIndex2) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_14,bitIndex3)
    <=> v4093(constB14,bitIndex3) ) ) ).

fof(is_address_98,axiom,
    address(v4093_range_3_to_0_address_term_bound_14) ).

fof(address_association_77,axiom,
    v4093_range_3_to_0_address_association(constB14,v4093_range_3_to_0_address_term_bound_14) ).

fof(address_false_msb_92,axiom,
    ~ addressVal(v4093_range_3_to_0_address_term_bound_13,bitIndex4) ).

fof(transient_address_definition_76,axiom,
    ( $true
    & ( addressVal(v4093_range_3_to_0_address_term_bound_13,bitIndex0)
    <=> v4093(constB13,bitIndex0) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_13,bitIndex1)
    <=> v4093(constB13,bitIndex1) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_13,bitIndex2)
    <=> v4093(constB13,bitIndex2) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_13,bitIndex3)
    <=> v4093(constB13,bitIndex3) ) ) ).

fof(is_address_97,axiom,
    address(v4093_range_3_to_0_address_term_bound_13) ).

fof(address_association_76,axiom,
    v4093_range_3_to_0_address_association(constB13,v4093_range_3_to_0_address_term_bound_13) ).

fof(address_false_msb_91,axiom,
    ~ addressVal(v4093_range_3_to_0_address_term_bound_12,bitIndex4) ).

fof(transient_address_definition_75,axiom,
    ( $true
    & ( addressVal(v4093_range_3_to_0_address_term_bound_12,bitIndex0)
    <=> v4093(constB12,bitIndex0) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_12,bitIndex1)
    <=> v4093(constB12,bitIndex1) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_12,bitIndex2)
    <=> v4093(constB12,bitIndex2) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_12,bitIndex3)
    <=> v4093(constB12,bitIndex3) ) ) ).

fof(is_address_96,axiom,
    address(v4093_range_3_to_0_address_term_bound_12) ).

fof(address_association_75,axiom,
    v4093_range_3_to_0_address_association(constB12,v4093_range_3_to_0_address_term_bound_12) ).

fof(address_false_msb_90,axiom,
    ~ addressVal(v4093_range_3_to_0_address_term_bound_11,bitIndex4) ).

fof(transient_address_definition_74,axiom,
    ( $true
    & ( addressVal(v4093_range_3_to_0_address_term_bound_11,bitIndex0)
    <=> v4093(constB11,bitIndex0) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_11,bitIndex1)
    <=> v4093(constB11,bitIndex1) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_11,bitIndex2)
    <=> v4093(constB11,bitIndex2) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_11,bitIndex3)
    <=> v4093(constB11,bitIndex3) ) ) ).

fof(is_address_95,axiom,
    address(v4093_range_3_to_0_address_term_bound_11) ).

fof(address_association_74,axiom,
    v4093_range_3_to_0_address_association(constB11,v4093_range_3_to_0_address_term_bound_11) ).

fof(address_false_msb_89,axiom,
    ~ addressVal(v4093_range_3_to_0_address_term_bound_10,bitIndex4) ).

fof(transient_address_definition_73,axiom,
    ( $true
    & ( addressVal(v4093_range_3_to_0_address_term_bound_10,bitIndex0)
    <=> v4093(constB10,bitIndex0) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_10,bitIndex1)
    <=> v4093(constB10,bitIndex1) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_10,bitIndex2)
    <=> v4093(constB10,bitIndex2) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_10,bitIndex3)
    <=> v4093(constB10,bitIndex3) ) ) ).

fof(is_address_94,axiom,
    address(v4093_range_3_to_0_address_term_bound_10) ).

fof(address_association_73,axiom,
    v4093_range_3_to_0_address_association(constB10,v4093_range_3_to_0_address_term_bound_10) ).

fof(address_false_msb_88,axiom,
    ~ addressVal(v4093_range_3_to_0_address_term_bound_9,bitIndex4) ).

fof(transient_address_definition_72,axiom,
    ( $true
    & ( addressVal(v4093_range_3_to_0_address_term_bound_9,bitIndex0)
    <=> v4093(constB9,bitIndex0) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_9,bitIndex1)
    <=> v4093(constB9,bitIndex1) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_9,bitIndex2)
    <=> v4093(constB9,bitIndex2) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_9,bitIndex3)
    <=> v4093(constB9,bitIndex3) ) ) ).

fof(is_address_93,axiom,
    address(v4093_range_3_to_0_address_term_bound_9) ).

fof(address_association_72,axiom,
    v4093_range_3_to_0_address_association(constB9,v4093_range_3_to_0_address_term_bound_9) ).

fof(address_false_msb_87,axiom,
    ~ addressVal(v4093_range_3_to_0_address_term_bound_8,bitIndex4) ).

fof(transient_address_definition_71,axiom,
    ( $true
    & ( addressVal(v4093_range_3_to_0_address_term_bound_8,bitIndex0)
    <=> v4093(constB8,bitIndex0) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_8,bitIndex1)
    <=> v4093(constB8,bitIndex1) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_8,bitIndex2)
    <=> v4093(constB8,bitIndex2) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_8,bitIndex3)
    <=> v4093(constB8,bitIndex3) ) ) ).

fof(is_address_92,axiom,
    address(v4093_range_3_to_0_address_term_bound_8) ).

fof(address_association_71,axiom,
    v4093_range_3_to_0_address_association(constB8,v4093_range_3_to_0_address_term_bound_8) ).

fof(address_false_msb_86,axiom,
    ~ addressVal(v4093_range_3_to_0_address_term_bound_7,bitIndex4) ).

fof(transient_address_definition_70,axiom,
    ( $true
    & ( addressVal(v4093_range_3_to_0_address_term_bound_7,bitIndex0)
    <=> v4093(constB7,bitIndex0) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_7,bitIndex1)
    <=> v4093(constB7,bitIndex1) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_7,bitIndex2)
    <=> v4093(constB7,bitIndex2) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_7,bitIndex3)
    <=> v4093(constB7,bitIndex3) ) ) ).

fof(is_address_91,axiom,
    address(v4093_range_3_to_0_address_term_bound_7) ).

fof(address_association_70,axiom,
    v4093_range_3_to_0_address_association(constB7,v4093_range_3_to_0_address_term_bound_7) ).

fof(address_false_msb_85,axiom,
    ~ addressVal(v4093_range_3_to_0_address_term_bound_6,bitIndex4) ).

fof(transient_address_definition_69,axiom,
    ( $true
    & ( addressVal(v4093_range_3_to_0_address_term_bound_6,bitIndex0)
    <=> v4093(constB6,bitIndex0) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_6,bitIndex1)
    <=> v4093(constB6,bitIndex1) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_6,bitIndex2)
    <=> v4093(constB6,bitIndex2) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_6,bitIndex3)
    <=> v4093(constB6,bitIndex3) ) ) ).

fof(is_address_90,axiom,
    address(v4093_range_3_to_0_address_term_bound_6) ).

fof(address_association_69,axiom,
    v4093_range_3_to_0_address_association(constB6,v4093_range_3_to_0_address_term_bound_6) ).

fof(address_false_msb_84,axiom,
    ~ addressVal(v4093_range_3_to_0_address_term_bound_5,bitIndex4) ).

fof(transient_address_definition_68,axiom,
    ( $true
    & ( addressVal(v4093_range_3_to_0_address_term_bound_5,bitIndex0)
    <=> v4093(constB5,bitIndex0) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_5,bitIndex1)
    <=> v4093(constB5,bitIndex1) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_5,bitIndex2)
    <=> v4093(constB5,bitIndex2) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_5,bitIndex3)
    <=> v4093(constB5,bitIndex3) ) ) ).

fof(is_address_89,axiom,
    address(v4093_range_3_to_0_address_term_bound_5) ).

fof(address_association_68,axiom,
    v4093_range_3_to_0_address_association(constB5,v4093_range_3_to_0_address_term_bound_5) ).

fof(address_false_msb_83,axiom,
    ~ addressVal(v4093_range_3_to_0_address_term_bound_4,bitIndex4) ).

fof(transient_address_definition_67,axiom,
    ( $true
    & ( addressVal(v4093_range_3_to_0_address_term_bound_4,bitIndex0)
    <=> v4093(constB4,bitIndex0) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_4,bitIndex1)
    <=> v4093(constB4,bitIndex1) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_4,bitIndex2)
    <=> v4093(constB4,bitIndex2) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_4,bitIndex3)
    <=> v4093(constB4,bitIndex3) ) ) ).

fof(is_address_88,axiom,
    address(v4093_range_3_to_0_address_term_bound_4) ).

fof(address_association_67,axiom,
    v4093_range_3_to_0_address_association(constB4,v4093_range_3_to_0_address_term_bound_4) ).

fof(address_false_msb_82,axiom,
    ~ addressVal(v4093_range_3_to_0_address_term_bound_3,bitIndex4) ).

fof(transient_address_definition_66,axiom,
    ( $true
    & ( addressVal(v4093_range_3_to_0_address_term_bound_3,bitIndex0)
    <=> v4093(constB3,bitIndex0) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_3,bitIndex1)
    <=> v4093(constB3,bitIndex1) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_3,bitIndex2)
    <=> v4093(constB3,bitIndex2) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_3,bitIndex3)
    <=> v4093(constB3,bitIndex3) ) ) ).

fof(is_address_87,axiom,
    address(v4093_range_3_to_0_address_term_bound_3) ).

fof(address_association_66,axiom,
    v4093_range_3_to_0_address_association(constB3,v4093_range_3_to_0_address_term_bound_3) ).

fof(address_false_msb_81,axiom,
    ~ addressVal(v4093_range_3_to_0_address_term_bound_2,bitIndex4) ).

fof(transient_address_definition_65,axiom,
    ( $true
    & ( addressVal(v4093_range_3_to_0_address_term_bound_2,bitIndex0)
    <=> v4093(constB2,bitIndex0) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_2,bitIndex1)
    <=> v4093(constB2,bitIndex1) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_2,bitIndex2)
    <=> v4093(constB2,bitIndex2) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_2,bitIndex3)
    <=> v4093(constB2,bitIndex3) ) ) ).

fof(is_address_86,axiom,
    address(v4093_range_3_to_0_address_term_bound_2) ).

fof(address_association_65,axiom,
    v4093_range_3_to_0_address_association(constB2,v4093_range_3_to_0_address_term_bound_2) ).

fof(address_false_msb_80,axiom,
    ~ addressVal(v4093_range_3_to_0_address_term_bound_1,bitIndex4) ).

fof(transient_address_definition_64,axiom,
    ( $true
    & ( addressVal(v4093_range_3_to_0_address_term_bound_1,bitIndex0)
    <=> v4093(constB1,bitIndex0) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_1,bitIndex1)
    <=> v4093(constB1,bitIndex1) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_1,bitIndex2)
    <=> v4093(constB1,bitIndex2) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_1,bitIndex3)
    <=> v4093(constB1,bitIndex3) ) ) ).

fof(is_address_85,axiom,
    address(v4093_range_3_to_0_address_term_bound_1) ).

fof(address_association_64,axiom,
    v4093_range_3_to_0_address_association(constB1,v4093_range_3_to_0_address_term_bound_1) ).

fof(address_false_msb_79,axiom,
    ~ addressVal(v4093_range_3_to_0_address_term_bound_0,bitIndex4) ).

fof(transient_address_definition_63,axiom,
    ( $true
    & ( addressVal(v4093_range_3_to_0_address_term_bound_0,bitIndex0)
    <=> v4093(constB0,bitIndex0) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_0,bitIndex1)
    <=> v4093(constB0,bitIndex1) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_0,bitIndex2)
    <=> v4093(constB0,bitIndex2) )
    & ( addressVal(v4093_range_3_to_0_address_term_bound_0,bitIndex3)
    <=> v4093(constB0,bitIndex3) ) ) ).

fof(is_address_84,axiom,
    address(v4093_range_3_to_0_address_term_bound_0) ).

fof(address_association_63,axiom,
    v4093_range_3_to_0_address_association(constB0,v4093_range_3_to_0_address_term_bound_0) ).

fof(address_false_msb_78,axiom,
    ~ addressVal(v4027_range_3_to_0_address_term_bound_20,bitIndex4) ).

fof(transient_address_definition_62,axiom,
    ( $true
    & ( addressVal(v4027_range_3_to_0_address_term_bound_20,bitIndex0)
    <=> v4027(constB20,bitIndex0) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_20,bitIndex1)
    <=> v4027(constB20,bitIndex1) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_20,bitIndex2)
    <=> v4027(constB20,bitIndex2) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_20,bitIndex3)
    <=> v4027(constB20,bitIndex3) ) ) ).

fof(is_address_83,axiom,
    address(v4027_range_3_to_0_address_term_bound_20) ).

fof(address_association_62,axiom,
    v4027_range_3_to_0_address_association(constB20,v4027_range_3_to_0_address_term_bound_20) ).

fof(address_false_msb_77,axiom,
    ~ addressVal(v4027_range_3_to_0_address_term_bound_19,bitIndex4) ).

fof(transient_address_definition_61,axiom,
    ( $true
    & ( addressVal(v4027_range_3_to_0_address_term_bound_19,bitIndex0)
    <=> v4027(constB19,bitIndex0) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_19,bitIndex1)
    <=> v4027(constB19,bitIndex1) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_19,bitIndex2)
    <=> v4027(constB19,bitIndex2) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_19,bitIndex3)
    <=> v4027(constB19,bitIndex3) ) ) ).

fof(is_address_82,axiom,
    address(v4027_range_3_to_0_address_term_bound_19) ).

fof(address_association_61,axiom,
    v4027_range_3_to_0_address_association(constB19,v4027_range_3_to_0_address_term_bound_19) ).

fof(address_false_msb_76,axiom,
    ~ addressVal(v4027_range_3_to_0_address_term_bound_18,bitIndex4) ).

fof(transient_address_definition_60,axiom,
    ( $true
    & ( addressVal(v4027_range_3_to_0_address_term_bound_18,bitIndex0)
    <=> v4027(constB18,bitIndex0) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_18,bitIndex1)
    <=> v4027(constB18,bitIndex1) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_18,bitIndex2)
    <=> v4027(constB18,bitIndex2) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_18,bitIndex3)
    <=> v4027(constB18,bitIndex3) ) ) ).

fof(is_address_81,axiom,
    address(v4027_range_3_to_0_address_term_bound_18) ).

fof(address_association_60,axiom,
    v4027_range_3_to_0_address_association(constB18,v4027_range_3_to_0_address_term_bound_18) ).

fof(address_false_msb_75,axiom,
    ~ addressVal(v4027_range_3_to_0_address_term_bound_17,bitIndex4) ).

fof(transient_address_definition_59,axiom,
    ( $true
    & ( addressVal(v4027_range_3_to_0_address_term_bound_17,bitIndex0)
    <=> v4027(constB17,bitIndex0) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_17,bitIndex1)
    <=> v4027(constB17,bitIndex1) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_17,bitIndex2)
    <=> v4027(constB17,bitIndex2) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_17,bitIndex3)
    <=> v4027(constB17,bitIndex3) ) ) ).

fof(is_address_80,axiom,
    address(v4027_range_3_to_0_address_term_bound_17) ).

fof(address_association_59,axiom,
    v4027_range_3_to_0_address_association(constB17,v4027_range_3_to_0_address_term_bound_17) ).

fof(address_false_msb_74,axiom,
    ~ addressVal(v4027_range_3_to_0_address_term_bound_16,bitIndex4) ).

fof(transient_address_definition_58,axiom,
    ( $true
    & ( addressVal(v4027_range_3_to_0_address_term_bound_16,bitIndex0)
    <=> v4027(constB16,bitIndex0) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_16,bitIndex1)
    <=> v4027(constB16,bitIndex1) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_16,bitIndex2)
    <=> v4027(constB16,bitIndex2) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_16,bitIndex3)
    <=> v4027(constB16,bitIndex3) ) ) ).

fof(is_address_79,axiom,
    address(v4027_range_3_to_0_address_term_bound_16) ).

fof(address_association_58,axiom,
    v4027_range_3_to_0_address_association(constB16,v4027_range_3_to_0_address_term_bound_16) ).

fof(address_false_msb_73,axiom,
    ~ addressVal(v4027_range_3_to_0_address_term_bound_15,bitIndex4) ).

fof(transient_address_definition_57,axiom,
    ( $true
    & ( addressVal(v4027_range_3_to_0_address_term_bound_15,bitIndex0)
    <=> v4027(constB15,bitIndex0) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_15,bitIndex1)
    <=> v4027(constB15,bitIndex1) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_15,bitIndex2)
    <=> v4027(constB15,bitIndex2) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_15,bitIndex3)
    <=> v4027(constB15,bitIndex3) ) ) ).

fof(is_address_78,axiom,
    address(v4027_range_3_to_0_address_term_bound_15) ).

fof(address_association_57,axiom,
    v4027_range_3_to_0_address_association(constB15,v4027_range_3_to_0_address_term_bound_15) ).

fof(address_false_msb_72,axiom,
    ~ addressVal(v4027_range_3_to_0_address_term_bound_14,bitIndex4) ).

fof(transient_address_definition_56,axiom,
    ( $true
    & ( addressVal(v4027_range_3_to_0_address_term_bound_14,bitIndex0)
    <=> v4027(constB14,bitIndex0) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_14,bitIndex1)
    <=> v4027(constB14,bitIndex1) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_14,bitIndex2)
    <=> v4027(constB14,bitIndex2) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_14,bitIndex3)
    <=> v4027(constB14,bitIndex3) ) ) ).

fof(is_address_77,axiom,
    address(v4027_range_3_to_0_address_term_bound_14) ).

fof(address_association_56,axiom,
    v4027_range_3_to_0_address_association(constB14,v4027_range_3_to_0_address_term_bound_14) ).

fof(address_false_msb_71,axiom,
    ~ addressVal(v4027_range_3_to_0_address_term_bound_13,bitIndex4) ).

fof(transient_address_definition_55,axiom,
    ( $true
    & ( addressVal(v4027_range_3_to_0_address_term_bound_13,bitIndex0)
    <=> v4027(constB13,bitIndex0) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_13,bitIndex1)
    <=> v4027(constB13,bitIndex1) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_13,bitIndex2)
    <=> v4027(constB13,bitIndex2) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_13,bitIndex3)
    <=> v4027(constB13,bitIndex3) ) ) ).

fof(is_address_76,axiom,
    address(v4027_range_3_to_0_address_term_bound_13) ).

fof(address_association_55,axiom,
    v4027_range_3_to_0_address_association(constB13,v4027_range_3_to_0_address_term_bound_13) ).

fof(address_false_msb_70,axiom,
    ~ addressVal(v4027_range_3_to_0_address_term_bound_12,bitIndex4) ).

fof(transient_address_definition_54,axiom,
    ( $true
    & ( addressVal(v4027_range_3_to_0_address_term_bound_12,bitIndex0)
    <=> v4027(constB12,bitIndex0) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_12,bitIndex1)
    <=> v4027(constB12,bitIndex1) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_12,bitIndex2)
    <=> v4027(constB12,bitIndex2) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_12,bitIndex3)
    <=> v4027(constB12,bitIndex3) ) ) ).

fof(is_address_75,axiom,
    address(v4027_range_3_to_0_address_term_bound_12) ).

fof(address_association_54,axiom,
    v4027_range_3_to_0_address_association(constB12,v4027_range_3_to_0_address_term_bound_12) ).

fof(address_false_msb_69,axiom,
    ~ addressVal(v4027_range_3_to_0_address_term_bound_11,bitIndex4) ).

fof(transient_address_definition_53,axiom,
    ( $true
    & ( addressVal(v4027_range_3_to_0_address_term_bound_11,bitIndex0)
    <=> v4027(constB11,bitIndex0) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_11,bitIndex1)
    <=> v4027(constB11,bitIndex1) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_11,bitIndex2)
    <=> v4027(constB11,bitIndex2) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_11,bitIndex3)
    <=> v4027(constB11,bitIndex3) ) ) ).

fof(is_address_74,axiom,
    address(v4027_range_3_to_0_address_term_bound_11) ).

fof(address_association_53,axiom,
    v4027_range_3_to_0_address_association(constB11,v4027_range_3_to_0_address_term_bound_11) ).

fof(address_false_msb_68,axiom,
    ~ addressVal(v4027_range_3_to_0_address_term_bound_10,bitIndex4) ).

fof(transient_address_definition_52,axiom,
    ( $true
    & ( addressVal(v4027_range_3_to_0_address_term_bound_10,bitIndex0)
    <=> v4027(constB10,bitIndex0) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_10,bitIndex1)
    <=> v4027(constB10,bitIndex1) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_10,bitIndex2)
    <=> v4027(constB10,bitIndex2) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_10,bitIndex3)
    <=> v4027(constB10,bitIndex3) ) ) ).

fof(is_address_73,axiom,
    address(v4027_range_3_to_0_address_term_bound_10) ).

fof(address_association_52,axiom,
    v4027_range_3_to_0_address_association(constB10,v4027_range_3_to_0_address_term_bound_10) ).

fof(address_false_msb_67,axiom,
    ~ addressVal(v4027_range_3_to_0_address_term_bound_9,bitIndex4) ).

fof(transient_address_definition_51,axiom,
    ( $true
    & ( addressVal(v4027_range_3_to_0_address_term_bound_9,bitIndex0)
    <=> v4027(constB9,bitIndex0) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_9,bitIndex1)
    <=> v4027(constB9,bitIndex1) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_9,bitIndex2)
    <=> v4027(constB9,bitIndex2) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_9,bitIndex3)
    <=> v4027(constB9,bitIndex3) ) ) ).

fof(is_address_72,axiom,
    address(v4027_range_3_to_0_address_term_bound_9) ).

fof(address_association_51,axiom,
    v4027_range_3_to_0_address_association(constB9,v4027_range_3_to_0_address_term_bound_9) ).

fof(address_false_msb_66,axiom,
    ~ addressVal(v4027_range_3_to_0_address_term_bound_8,bitIndex4) ).

fof(transient_address_definition_50,axiom,
    ( $true
    & ( addressVal(v4027_range_3_to_0_address_term_bound_8,bitIndex0)
    <=> v4027(constB8,bitIndex0) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_8,bitIndex1)
    <=> v4027(constB8,bitIndex1) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_8,bitIndex2)
    <=> v4027(constB8,bitIndex2) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_8,bitIndex3)
    <=> v4027(constB8,bitIndex3) ) ) ).

fof(is_address_71,axiom,
    address(v4027_range_3_to_0_address_term_bound_8) ).

fof(address_association_50,axiom,
    v4027_range_3_to_0_address_association(constB8,v4027_range_3_to_0_address_term_bound_8) ).

fof(address_false_msb_65,axiom,
    ~ addressVal(v4027_range_3_to_0_address_term_bound_7,bitIndex4) ).

fof(transient_address_definition_49,axiom,
    ( $true
    & ( addressVal(v4027_range_3_to_0_address_term_bound_7,bitIndex0)
    <=> v4027(constB7,bitIndex0) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_7,bitIndex1)
    <=> v4027(constB7,bitIndex1) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_7,bitIndex2)
    <=> v4027(constB7,bitIndex2) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_7,bitIndex3)
    <=> v4027(constB7,bitIndex3) ) ) ).

fof(is_address_70,axiom,
    address(v4027_range_3_to_0_address_term_bound_7) ).

fof(address_association_49,axiom,
    v4027_range_3_to_0_address_association(constB7,v4027_range_3_to_0_address_term_bound_7) ).

fof(address_false_msb_64,axiom,
    ~ addressVal(v4027_range_3_to_0_address_term_bound_6,bitIndex4) ).

fof(transient_address_definition_48,axiom,
    ( $true
    & ( addressVal(v4027_range_3_to_0_address_term_bound_6,bitIndex0)
    <=> v4027(constB6,bitIndex0) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_6,bitIndex1)
    <=> v4027(constB6,bitIndex1) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_6,bitIndex2)
    <=> v4027(constB6,bitIndex2) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_6,bitIndex3)
    <=> v4027(constB6,bitIndex3) ) ) ).

fof(is_address_69,axiom,
    address(v4027_range_3_to_0_address_term_bound_6) ).

fof(address_association_48,axiom,
    v4027_range_3_to_0_address_association(constB6,v4027_range_3_to_0_address_term_bound_6) ).

fof(address_false_msb_63,axiom,
    ~ addressVal(v4027_range_3_to_0_address_term_bound_5,bitIndex4) ).

fof(transient_address_definition_47,axiom,
    ( $true
    & ( addressVal(v4027_range_3_to_0_address_term_bound_5,bitIndex0)
    <=> v4027(constB5,bitIndex0) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_5,bitIndex1)
    <=> v4027(constB5,bitIndex1) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_5,bitIndex2)
    <=> v4027(constB5,bitIndex2) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_5,bitIndex3)
    <=> v4027(constB5,bitIndex3) ) ) ).

fof(is_address_68,axiom,
    address(v4027_range_3_to_0_address_term_bound_5) ).

fof(address_association_47,axiom,
    v4027_range_3_to_0_address_association(constB5,v4027_range_3_to_0_address_term_bound_5) ).

fof(address_false_msb_62,axiom,
    ~ addressVal(v4027_range_3_to_0_address_term_bound_4,bitIndex4) ).

fof(transient_address_definition_46,axiom,
    ( $true
    & ( addressVal(v4027_range_3_to_0_address_term_bound_4,bitIndex0)
    <=> v4027(constB4,bitIndex0) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_4,bitIndex1)
    <=> v4027(constB4,bitIndex1) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_4,bitIndex2)
    <=> v4027(constB4,bitIndex2) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_4,bitIndex3)
    <=> v4027(constB4,bitIndex3) ) ) ).

fof(is_address_67,axiom,
    address(v4027_range_3_to_0_address_term_bound_4) ).

fof(address_association_46,axiom,
    v4027_range_3_to_0_address_association(constB4,v4027_range_3_to_0_address_term_bound_4) ).

fof(address_false_msb_61,axiom,
    ~ addressVal(v4027_range_3_to_0_address_term_bound_3,bitIndex4) ).

fof(transient_address_definition_45,axiom,
    ( $true
    & ( addressVal(v4027_range_3_to_0_address_term_bound_3,bitIndex0)
    <=> v4027(constB3,bitIndex0) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_3,bitIndex1)
    <=> v4027(constB3,bitIndex1) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_3,bitIndex2)
    <=> v4027(constB3,bitIndex2) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_3,bitIndex3)
    <=> v4027(constB3,bitIndex3) ) ) ).

fof(is_address_66,axiom,
    address(v4027_range_3_to_0_address_term_bound_3) ).

fof(address_association_45,axiom,
    v4027_range_3_to_0_address_association(constB3,v4027_range_3_to_0_address_term_bound_3) ).

fof(address_false_msb_60,axiom,
    ~ addressVal(v4027_range_3_to_0_address_term_bound_2,bitIndex4) ).

fof(transient_address_definition_44,axiom,
    ( $true
    & ( addressVal(v4027_range_3_to_0_address_term_bound_2,bitIndex0)
    <=> v4027(constB2,bitIndex0) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_2,bitIndex1)
    <=> v4027(constB2,bitIndex1) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_2,bitIndex2)
    <=> v4027(constB2,bitIndex2) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_2,bitIndex3)
    <=> v4027(constB2,bitIndex3) ) ) ).

fof(is_address_65,axiom,
    address(v4027_range_3_to_0_address_term_bound_2) ).

fof(address_association_44,axiom,
    v4027_range_3_to_0_address_association(constB2,v4027_range_3_to_0_address_term_bound_2) ).

fof(address_false_msb_59,axiom,
    ~ addressVal(v4027_range_3_to_0_address_term_bound_1,bitIndex4) ).

fof(transient_address_definition_43,axiom,
    ( $true
    & ( addressVal(v4027_range_3_to_0_address_term_bound_1,bitIndex0)
    <=> v4027(constB1,bitIndex0) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_1,bitIndex1)
    <=> v4027(constB1,bitIndex1) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_1,bitIndex2)
    <=> v4027(constB1,bitIndex2) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_1,bitIndex3)
    <=> v4027(constB1,bitIndex3) ) ) ).

fof(is_address_64,axiom,
    address(v4027_range_3_to_0_address_term_bound_1) ).

fof(address_association_43,axiom,
    v4027_range_3_to_0_address_association(constB1,v4027_range_3_to_0_address_term_bound_1) ).

fof(address_false_msb_58,axiom,
    ~ addressVal(v4027_range_3_to_0_address_term_bound_0,bitIndex4) ).

fof(transient_address_definition_42,axiom,
    ( $true
    & ( addressVal(v4027_range_3_to_0_address_term_bound_0,bitIndex0)
    <=> v4027(constB0,bitIndex0) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_0,bitIndex1)
    <=> v4027(constB0,bitIndex1) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_0,bitIndex2)
    <=> v4027(constB0,bitIndex2) )
    & ( addressVal(v4027_range_3_to_0_address_term_bound_0,bitIndex3)
    <=> v4027(constB0,bitIndex3) ) ) ).

fof(is_address_63,axiom,
    address(v4027_range_3_to_0_address_term_bound_0) ).

fof(address_association_42,axiom,
    v4027_range_3_to_0_address_association(constB0,v4027_range_3_to_0_address_term_bound_0) ).

fof(is_address_62,axiom,
    address(b00001_address_term) ).

fof(constant_address_definition_20,axiom,
    ! [B] :
      ( addressVal(b00001_address_term,B)
    <=> b00001(B) ) ).

fof(is_address_61,axiom,
    address(b10000_address_term) ).

fof(constant_address_definition_19,axiom,
    ! [B] :
      ( addressVal(b10000_address_term,B)
    <=> b10000(B) ) ).

fof(address_false_msb_57,axiom,
    ~ addressVal(v3777_range_3_to_0_address_term_bound_20,bitIndex4) ).

fof(transient_address_definition_41,axiom,
    ( $true
    & ( addressVal(v3777_range_3_to_0_address_term_bound_20,bitIndex0)
    <=> v3777(constB20,bitIndex0) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_20,bitIndex1)
    <=> v3777(constB20,bitIndex1) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_20,bitIndex2)
    <=> v3777(constB20,bitIndex2) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_20,bitIndex3)
    <=> v3777(constB20,bitIndex3) ) ) ).

fof(is_address_60,axiom,
    address(v3777_range_3_to_0_address_term_bound_20) ).

fof(address_association_41,axiom,
    v3777_range_3_to_0_address_association(constB20,v3777_range_3_to_0_address_term_bound_20) ).

fof(address_false_msb_56,axiom,
    ~ addressVal(v3777_range_3_to_0_address_term_bound_19,bitIndex4) ).

fof(transient_address_definition_40,axiom,
    ( $true
    & ( addressVal(v3777_range_3_to_0_address_term_bound_19,bitIndex0)
    <=> v3777(constB19,bitIndex0) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_19,bitIndex1)
    <=> v3777(constB19,bitIndex1) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_19,bitIndex2)
    <=> v3777(constB19,bitIndex2) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_19,bitIndex3)
    <=> v3777(constB19,bitIndex3) ) ) ).

fof(is_address_59,axiom,
    address(v3777_range_3_to_0_address_term_bound_19) ).

fof(address_association_40,axiom,
    v3777_range_3_to_0_address_association(constB19,v3777_range_3_to_0_address_term_bound_19) ).

fof(address_false_msb_55,axiom,
    ~ addressVal(v3777_range_3_to_0_address_term_bound_18,bitIndex4) ).

fof(transient_address_definition_39,axiom,
    ( $true
    & ( addressVal(v3777_range_3_to_0_address_term_bound_18,bitIndex0)
    <=> v3777(constB18,bitIndex0) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_18,bitIndex1)
    <=> v3777(constB18,bitIndex1) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_18,bitIndex2)
    <=> v3777(constB18,bitIndex2) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_18,bitIndex3)
    <=> v3777(constB18,bitIndex3) ) ) ).

fof(is_address_58,axiom,
    address(v3777_range_3_to_0_address_term_bound_18) ).

fof(address_association_39,axiom,
    v3777_range_3_to_0_address_association(constB18,v3777_range_3_to_0_address_term_bound_18) ).

fof(address_false_msb_54,axiom,
    ~ addressVal(v3777_range_3_to_0_address_term_bound_17,bitIndex4) ).

fof(transient_address_definition_38,axiom,
    ( $true
    & ( addressVal(v3777_range_3_to_0_address_term_bound_17,bitIndex0)
    <=> v3777(constB17,bitIndex0) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_17,bitIndex1)
    <=> v3777(constB17,bitIndex1) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_17,bitIndex2)
    <=> v3777(constB17,bitIndex2) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_17,bitIndex3)
    <=> v3777(constB17,bitIndex3) ) ) ).

fof(is_address_57,axiom,
    address(v3777_range_3_to_0_address_term_bound_17) ).

fof(address_association_38,axiom,
    v3777_range_3_to_0_address_association(constB17,v3777_range_3_to_0_address_term_bound_17) ).

fof(address_false_msb_53,axiom,
    ~ addressVal(v3777_range_3_to_0_address_term_bound_16,bitIndex4) ).

fof(transient_address_definition_37,axiom,
    ( $true
    & ( addressVal(v3777_range_3_to_0_address_term_bound_16,bitIndex0)
    <=> v3777(constB16,bitIndex0) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_16,bitIndex1)
    <=> v3777(constB16,bitIndex1) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_16,bitIndex2)
    <=> v3777(constB16,bitIndex2) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_16,bitIndex3)
    <=> v3777(constB16,bitIndex3) ) ) ).

fof(is_address_56,axiom,
    address(v3777_range_3_to_0_address_term_bound_16) ).

fof(address_association_37,axiom,
    v3777_range_3_to_0_address_association(constB16,v3777_range_3_to_0_address_term_bound_16) ).

fof(address_false_msb_52,axiom,
    ~ addressVal(v3777_range_3_to_0_address_term_bound_15,bitIndex4) ).

fof(transient_address_definition_36,axiom,
    ( $true
    & ( addressVal(v3777_range_3_to_0_address_term_bound_15,bitIndex0)
    <=> v3777(constB15,bitIndex0) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_15,bitIndex1)
    <=> v3777(constB15,bitIndex1) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_15,bitIndex2)
    <=> v3777(constB15,bitIndex2) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_15,bitIndex3)
    <=> v3777(constB15,bitIndex3) ) ) ).

fof(is_address_55,axiom,
    address(v3777_range_3_to_0_address_term_bound_15) ).

fof(address_association_36,axiom,
    v3777_range_3_to_0_address_association(constB15,v3777_range_3_to_0_address_term_bound_15) ).

fof(address_false_msb_51,axiom,
    ~ addressVal(v3777_range_3_to_0_address_term_bound_14,bitIndex4) ).

fof(transient_address_definition_35,axiom,
    ( $true
    & ( addressVal(v3777_range_3_to_0_address_term_bound_14,bitIndex0)
    <=> v3777(constB14,bitIndex0) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_14,bitIndex1)
    <=> v3777(constB14,bitIndex1) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_14,bitIndex2)
    <=> v3777(constB14,bitIndex2) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_14,bitIndex3)
    <=> v3777(constB14,bitIndex3) ) ) ).

fof(is_address_54,axiom,
    address(v3777_range_3_to_0_address_term_bound_14) ).

fof(address_association_35,axiom,
    v3777_range_3_to_0_address_association(constB14,v3777_range_3_to_0_address_term_bound_14) ).

fof(address_false_msb_50,axiom,
    ~ addressVal(v3777_range_3_to_0_address_term_bound_13,bitIndex4) ).

fof(transient_address_definition_34,axiom,
    ( $true
    & ( addressVal(v3777_range_3_to_0_address_term_bound_13,bitIndex0)
    <=> v3777(constB13,bitIndex0) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_13,bitIndex1)
    <=> v3777(constB13,bitIndex1) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_13,bitIndex2)
    <=> v3777(constB13,bitIndex2) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_13,bitIndex3)
    <=> v3777(constB13,bitIndex3) ) ) ).

fof(is_address_53,axiom,
    address(v3777_range_3_to_0_address_term_bound_13) ).

fof(address_association_34,axiom,
    v3777_range_3_to_0_address_association(constB13,v3777_range_3_to_0_address_term_bound_13) ).

fof(address_false_msb_49,axiom,
    ~ addressVal(v3777_range_3_to_0_address_term_bound_12,bitIndex4) ).

fof(transient_address_definition_33,axiom,
    ( $true
    & ( addressVal(v3777_range_3_to_0_address_term_bound_12,bitIndex0)
    <=> v3777(constB12,bitIndex0) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_12,bitIndex1)
    <=> v3777(constB12,bitIndex1) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_12,bitIndex2)
    <=> v3777(constB12,bitIndex2) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_12,bitIndex3)
    <=> v3777(constB12,bitIndex3) ) ) ).

fof(is_address_52,axiom,
    address(v3777_range_3_to_0_address_term_bound_12) ).

fof(address_association_33,axiom,
    v3777_range_3_to_0_address_association(constB12,v3777_range_3_to_0_address_term_bound_12) ).

fof(address_false_msb_48,axiom,
    ~ addressVal(v3777_range_3_to_0_address_term_bound_11,bitIndex4) ).

fof(transient_address_definition_32,axiom,
    ( $true
    & ( addressVal(v3777_range_3_to_0_address_term_bound_11,bitIndex0)
    <=> v3777(constB11,bitIndex0) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_11,bitIndex1)
    <=> v3777(constB11,bitIndex1) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_11,bitIndex2)
    <=> v3777(constB11,bitIndex2) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_11,bitIndex3)
    <=> v3777(constB11,bitIndex3) ) ) ).

fof(is_address_51,axiom,
    address(v3777_range_3_to_0_address_term_bound_11) ).

fof(address_association_32,axiom,
    v3777_range_3_to_0_address_association(constB11,v3777_range_3_to_0_address_term_bound_11) ).

fof(address_false_msb_47,axiom,
    ~ addressVal(v3777_range_3_to_0_address_term_bound_10,bitIndex4) ).

fof(transient_address_definition_31,axiom,
    ( $true
    & ( addressVal(v3777_range_3_to_0_address_term_bound_10,bitIndex0)
    <=> v3777(constB10,bitIndex0) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_10,bitIndex1)
    <=> v3777(constB10,bitIndex1) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_10,bitIndex2)
    <=> v3777(constB10,bitIndex2) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_10,bitIndex3)
    <=> v3777(constB10,bitIndex3) ) ) ).

fof(is_address_50,axiom,
    address(v3777_range_3_to_0_address_term_bound_10) ).

fof(address_association_31,axiom,
    v3777_range_3_to_0_address_association(constB10,v3777_range_3_to_0_address_term_bound_10) ).

fof(address_false_msb_46,axiom,
    ~ addressVal(v3777_range_3_to_0_address_term_bound_9,bitIndex4) ).

fof(transient_address_definition_30,axiom,
    ( $true
    & ( addressVal(v3777_range_3_to_0_address_term_bound_9,bitIndex0)
    <=> v3777(constB9,bitIndex0) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_9,bitIndex1)
    <=> v3777(constB9,bitIndex1) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_9,bitIndex2)
    <=> v3777(constB9,bitIndex2) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_9,bitIndex3)
    <=> v3777(constB9,bitIndex3) ) ) ).

fof(is_address_49,axiom,
    address(v3777_range_3_to_0_address_term_bound_9) ).

fof(address_association_30,axiom,
    v3777_range_3_to_0_address_association(constB9,v3777_range_3_to_0_address_term_bound_9) ).

fof(address_false_msb_45,axiom,
    ~ addressVal(v3777_range_3_to_0_address_term_bound_8,bitIndex4) ).

fof(transient_address_definition_29,axiom,
    ( $true
    & ( addressVal(v3777_range_3_to_0_address_term_bound_8,bitIndex0)
    <=> v3777(constB8,bitIndex0) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_8,bitIndex1)
    <=> v3777(constB8,bitIndex1) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_8,bitIndex2)
    <=> v3777(constB8,bitIndex2) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_8,bitIndex3)
    <=> v3777(constB8,bitIndex3) ) ) ).

fof(is_address_48,axiom,
    address(v3777_range_3_to_0_address_term_bound_8) ).

fof(address_association_29,axiom,
    v3777_range_3_to_0_address_association(constB8,v3777_range_3_to_0_address_term_bound_8) ).

fof(address_false_msb_44,axiom,
    ~ addressVal(v3777_range_3_to_0_address_term_bound_7,bitIndex4) ).

fof(transient_address_definition_28,axiom,
    ( $true
    & ( addressVal(v3777_range_3_to_0_address_term_bound_7,bitIndex0)
    <=> v3777(constB7,bitIndex0) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_7,bitIndex1)
    <=> v3777(constB7,bitIndex1) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_7,bitIndex2)
    <=> v3777(constB7,bitIndex2) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_7,bitIndex3)
    <=> v3777(constB7,bitIndex3) ) ) ).

fof(is_address_47,axiom,
    address(v3777_range_3_to_0_address_term_bound_7) ).

fof(address_association_28,axiom,
    v3777_range_3_to_0_address_association(constB7,v3777_range_3_to_0_address_term_bound_7) ).

fof(address_false_msb_43,axiom,
    ~ addressVal(v3777_range_3_to_0_address_term_bound_6,bitIndex4) ).

fof(transient_address_definition_27,axiom,
    ( $true
    & ( addressVal(v3777_range_3_to_0_address_term_bound_6,bitIndex0)
    <=> v3777(constB6,bitIndex0) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_6,bitIndex1)
    <=> v3777(constB6,bitIndex1) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_6,bitIndex2)
    <=> v3777(constB6,bitIndex2) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_6,bitIndex3)
    <=> v3777(constB6,bitIndex3) ) ) ).

fof(is_address_46,axiom,
    address(v3777_range_3_to_0_address_term_bound_6) ).

fof(address_association_27,axiom,
    v3777_range_3_to_0_address_association(constB6,v3777_range_3_to_0_address_term_bound_6) ).

fof(address_false_msb_42,axiom,
    ~ addressVal(v3777_range_3_to_0_address_term_bound_5,bitIndex4) ).

fof(transient_address_definition_26,axiom,
    ( $true
    & ( addressVal(v3777_range_3_to_0_address_term_bound_5,bitIndex0)
    <=> v3777(constB5,bitIndex0) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_5,bitIndex1)
    <=> v3777(constB5,bitIndex1) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_5,bitIndex2)
    <=> v3777(constB5,bitIndex2) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_5,bitIndex3)
    <=> v3777(constB5,bitIndex3) ) ) ).

fof(is_address_45,axiom,
    address(v3777_range_3_to_0_address_term_bound_5) ).

fof(address_association_26,axiom,
    v3777_range_3_to_0_address_association(constB5,v3777_range_3_to_0_address_term_bound_5) ).

fof(address_false_msb_41,axiom,
    ~ addressVal(v3777_range_3_to_0_address_term_bound_4,bitIndex4) ).

fof(transient_address_definition_25,axiom,
    ( $true
    & ( addressVal(v3777_range_3_to_0_address_term_bound_4,bitIndex0)
    <=> v3777(constB4,bitIndex0) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_4,bitIndex1)
    <=> v3777(constB4,bitIndex1) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_4,bitIndex2)
    <=> v3777(constB4,bitIndex2) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_4,bitIndex3)
    <=> v3777(constB4,bitIndex3) ) ) ).

fof(is_address_44,axiom,
    address(v3777_range_3_to_0_address_term_bound_4) ).

fof(address_association_25,axiom,
    v3777_range_3_to_0_address_association(constB4,v3777_range_3_to_0_address_term_bound_4) ).

fof(address_false_msb_40,axiom,
    ~ addressVal(v3777_range_3_to_0_address_term_bound_3,bitIndex4) ).

fof(transient_address_definition_24,axiom,
    ( $true
    & ( addressVal(v3777_range_3_to_0_address_term_bound_3,bitIndex0)
    <=> v3777(constB3,bitIndex0) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_3,bitIndex1)
    <=> v3777(constB3,bitIndex1) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_3,bitIndex2)
    <=> v3777(constB3,bitIndex2) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_3,bitIndex3)
    <=> v3777(constB3,bitIndex3) ) ) ).

fof(is_address_43,axiom,
    address(v3777_range_3_to_0_address_term_bound_3) ).

fof(address_association_24,axiom,
    v3777_range_3_to_0_address_association(constB3,v3777_range_3_to_0_address_term_bound_3) ).

fof(address_false_msb_39,axiom,
    ~ addressVal(v3777_range_3_to_0_address_term_bound_2,bitIndex4) ).

fof(transient_address_definition_23,axiom,
    ( $true
    & ( addressVal(v3777_range_3_to_0_address_term_bound_2,bitIndex0)
    <=> v3777(constB2,bitIndex0) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_2,bitIndex1)
    <=> v3777(constB2,bitIndex1) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_2,bitIndex2)
    <=> v3777(constB2,bitIndex2) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_2,bitIndex3)
    <=> v3777(constB2,bitIndex3) ) ) ).

fof(is_address_42,axiom,
    address(v3777_range_3_to_0_address_term_bound_2) ).

fof(address_association_23,axiom,
    v3777_range_3_to_0_address_association(constB2,v3777_range_3_to_0_address_term_bound_2) ).

fof(address_false_msb_38,axiom,
    ~ addressVal(v3777_range_3_to_0_address_term_bound_1,bitIndex4) ).

fof(transient_address_definition_22,axiom,
    ( $true
    & ( addressVal(v3777_range_3_to_0_address_term_bound_1,bitIndex0)
    <=> v3777(constB1,bitIndex0) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_1,bitIndex1)
    <=> v3777(constB1,bitIndex1) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_1,bitIndex2)
    <=> v3777(constB1,bitIndex2) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_1,bitIndex3)
    <=> v3777(constB1,bitIndex3) ) ) ).

fof(is_address_41,axiom,
    address(v3777_range_3_to_0_address_term_bound_1) ).

fof(address_association_22,axiom,
    v3777_range_3_to_0_address_association(constB1,v3777_range_3_to_0_address_term_bound_1) ).

fof(address_false_msb_37,axiom,
    ~ addressVal(v3777_range_3_to_0_address_term_bound_0,bitIndex4) ).

fof(transient_address_definition_21,axiom,
    ( $true
    & ( addressVal(v3777_range_3_to_0_address_term_bound_0,bitIndex0)
    <=> v3777(constB0,bitIndex0) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_0,bitIndex1)
    <=> v3777(constB0,bitIndex1) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_0,bitIndex2)
    <=> v3777(constB0,bitIndex2) )
    & ( addressVal(v3777_range_3_to_0_address_term_bound_0,bitIndex3)
    <=> v3777(constB0,bitIndex3) ) ) ).

fof(is_address_40,axiom,
    address(v3777_range_3_to_0_address_term_bound_0) ).

fof(address_association_21,axiom,
    v3777_range_3_to_0_address_association(constB0,v3777_range_3_to_0_address_term_bound_0) ).

fof(address_false_msb_36,axiom,
    ~ addressVal(v3711_range_3_to_0_address_term_bound_20,bitIndex4) ).

fof(transient_address_definition_20,axiom,
    ( $true
    & ( addressVal(v3711_range_3_to_0_address_term_bound_20,bitIndex0)
    <=> v3711(constB20,bitIndex0) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_20,bitIndex1)
    <=> v3711(constB20,bitIndex1) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_20,bitIndex2)
    <=> v3711(constB20,bitIndex2) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_20,bitIndex3)
    <=> v3711(constB20,bitIndex3) ) ) ).

fof(is_address_39,axiom,
    address(v3711_range_3_to_0_address_term_bound_20) ).

fof(address_association_20,axiom,
    v3711_range_3_to_0_address_association(constB20,v3711_range_3_to_0_address_term_bound_20) ).

fof(address_false_msb_35,axiom,
    ~ addressVal(v3711_range_3_to_0_address_term_bound_19,bitIndex4) ).

fof(transient_address_definition_19,axiom,
    ( $true
    & ( addressVal(v3711_range_3_to_0_address_term_bound_19,bitIndex0)
    <=> v3711(constB19,bitIndex0) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_19,bitIndex1)
    <=> v3711(constB19,bitIndex1) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_19,bitIndex2)
    <=> v3711(constB19,bitIndex2) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_19,bitIndex3)
    <=> v3711(constB19,bitIndex3) ) ) ).

fof(is_address_38,axiom,
    address(v3711_range_3_to_0_address_term_bound_19) ).

fof(address_association_19,axiom,
    v3711_range_3_to_0_address_association(constB19,v3711_range_3_to_0_address_term_bound_19) ).

fof(address_false_msb_34,axiom,
    ~ addressVal(v3711_range_3_to_0_address_term_bound_18,bitIndex4) ).

fof(transient_address_definition_18,axiom,
    ( $true
    & ( addressVal(v3711_range_3_to_0_address_term_bound_18,bitIndex0)
    <=> v3711(constB18,bitIndex0) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_18,bitIndex1)
    <=> v3711(constB18,bitIndex1) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_18,bitIndex2)
    <=> v3711(constB18,bitIndex2) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_18,bitIndex3)
    <=> v3711(constB18,bitIndex3) ) ) ).

fof(is_address_37,axiom,
    address(v3711_range_3_to_0_address_term_bound_18) ).

fof(address_association_18,axiom,
    v3711_range_3_to_0_address_association(constB18,v3711_range_3_to_0_address_term_bound_18) ).

fof(address_false_msb_33,axiom,
    ~ addressVal(v3711_range_3_to_0_address_term_bound_17,bitIndex4) ).

fof(transient_address_definition_17,axiom,
    ( $true
    & ( addressVal(v3711_range_3_to_0_address_term_bound_17,bitIndex0)
    <=> v3711(constB17,bitIndex0) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_17,bitIndex1)
    <=> v3711(constB17,bitIndex1) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_17,bitIndex2)
    <=> v3711(constB17,bitIndex2) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_17,bitIndex3)
    <=> v3711(constB17,bitIndex3) ) ) ).

fof(is_address_36,axiom,
    address(v3711_range_3_to_0_address_term_bound_17) ).

fof(address_association_17,axiom,
    v3711_range_3_to_0_address_association(constB17,v3711_range_3_to_0_address_term_bound_17) ).

fof(address_false_msb_32,axiom,
    ~ addressVal(v3711_range_3_to_0_address_term_bound_16,bitIndex4) ).

fof(transient_address_definition_16,axiom,
    ( $true
    & ( addressVal(v3711_range_3_to_0_address_term_bound_16,bitIndex0)
    <=> v3711(constB16,bitIndex0) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_16,bitIndex1)
    <=> v3711(constB16,bitIndex1) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_16,bitIndex2)
    <=> v3711(constB16,bitIndex2) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_16,bitIndex3)
    <=> v3711(constB16,bitIndex3) ) ) ).

fof(is_address_35,axiom,
    address(v3711_range_3_to_0_address_term_bound_16) ).

fof(address_association_16,axiom,
    v3711_range_3_to_0_address_association(constB16,v3711_range_3_to_0_address_term_bound_16) ).

fof(address_false_msb_31,axiom,
    ~ addressVal(v3711_range_3_to_0_address_term_bound_15,bitIndex4) ).

fof(transient_address_definition_15,axiom,
    ( $true
    & ( addressVal(v3711_range_3_to_0_address_term_bound_15,bitIndex0)
    <=> v3711(constB15,bitIndex0) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_15,bitIndex1)
    <=> v3711(constB15,bitIndex1) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_15,bitIndex2)
    <=> v3711(constB15,bitIndex2) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_15,bitIndex3)
    <=> v3711(constB15,bitIndex3) ) ) ).

fof(is_address_34,axiom,
    address(v3711_range_3_to_0_address_term_bound_15) ).

fof(address_association_15,axiom,
    v3711_range_3_to_0_address_association(constB15,v3711_range_3_to_0_address_term_bound_15) ).

fof(address_false_msb_30,axiom,
    ~ addressVal(v3711_range_3_to_0_address_term_bound_14,bitIndex4) ).

fof(transient_address_definition_14,axiom,
    ( $true
    & ( addressVal(v3711_range_3_to_0_address_term_bound_14,bitIndex0)
    <=> v3711(constB14,bitIndex0) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_14,bitIndex1)
    <=> v3711(constB14,bitIndex1) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_14,bitIndex2)
    <=> v3711(constB14,bitIndex2) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_14,bitIndex3)
    <=> v3711(constB14,bitIndex3) ) ) ).

fof(is_address_33,axiom,
    address(v3711_range_3_to_0_address_term_bound_14) ).

fof(address_association_14,axiom,
    v3711_range_3_to_0_address_association(constB14,v3711_range_3_to_0_address_term_bound_14) ).

fof(address_false_msb_29,axiom,
    ~ addressVal(v3711_range_3_to_0_address_term_bound_13,bitIndex4) ).

fof(transient_address_definition_13,axiom,
    ( $true
    & ( addressVal(v3711_range_3_to_0_address_term_bound_13,bitIndex0)
    <=> v3711(constB13,bitIndex0) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_13,bitIndex1)
    <=> v3711(constB13,bitIndex1) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_13,bitIndex2)
    <=> v3711(constB13,bitIndex2) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_13,bitIndex3)
    <=> v3711(constB13,bitIndex3) ) ) ).

fof(is_address_32,axiom,
    address(v3711_range_3_to_0_address_term_bound_13) ).

fof(address_association_13,axiom,
    v3711_range_3_to_0_address_association(constB13,v3711_range_3_to_0_address_term_bound_13) ).

fof(address_false_msb_28,axiom,
    ~ addressVal(v3711_range_3_to_0_address_term_bound_12,bitIndex4) ).

fof(transient_address_definition_12,axiom,
    ( $true
    & ( addressVal(v3711_range_3_to_0_address_term_bound_12,bitIndex0)
    <=> v3711(constB12,bitIndex0) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_12,bitIndex1)
    <=> v3711(constB12,bitIndex1) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_12,bitIndex2)
    <=> v3711(constB12,bitIndex2) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_12,bitIndex3)
    <=> v3711(constB12,bitIndex3) ) ) ).

fof(is_address_31,axiom,
    address(v3711_range_3_to_0_address_term_bound_12) ).

fof(address_association_12,axiom,
    v3711_range_3_to_0_address_association(constB12,v3711_range_3_to_0_address_term_bound_12) ).

fof(address_false_msb_27,axiom,
    ~ addressVal(v3711_range_3_to_0_address_term_bound_11,bitIndex4) ).

fof(transient_address_definition_11,axiom,
    ( $true
    & ( addressVal(v3711_range_3_to_0_address_term_bound_11,bitIndex0)
    <=> v3711(constB11,bitIndex0) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_11,bitIndex1)
    <=> v3711(constB11,bitIndex1) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_11,bitIndex2)
    <=> v3711(constB11,bitIndex2) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_11,bitIndex3)
    <=> v3711(constB11,bitIndex3) ) ) ).

fof(is_address_30,axiom,
    address(v3711_range_3_to_0_address_term_bound_11) ).

fof(address_association_11,axiom,
    v3711_range_3_to_0_address_association(constB11,v3711_range_3_to_0_address_term_bound_11) ).

fof(address_false_msb_26,axiom,
    ~ addressVal(v3711_range_3_to_0_address_term_bound_10,bitIndex4) ).

fof(transient_address_definition_10,axiom,
    ( $true
    & ( addressVal(v3711_range_3_to_0_address_term_bound_10,bitIndex0)
    <=> v3711(constB10,bitIndex0) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_10,bitIndex1)
    <=> v3711(constB10,bitIndex1) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_10,bitIndex2)
    <=> v3711(constB10,bitIndex2) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_10,bitIndex3)
    <=> v3711(constB10,bitIndex3) ) ) ).

fof(is_address_29,axiom,
    address(v3711_range_3_to_0_address_term_bound_10) ).

fof(address_association_10,axiom,
    v3711_range_3_to_0_address_association(constB10,v3711_range_3_to_0_address_term_bound_10) ).

fof(address_false_msb_25,axiom,
    ~ addressVal(v3711_range_3_to_0_address_term_bound_9,bitIndex4) ).

fof(transient_address_definition_9,axiom,
    ( $true
    & ( addressVal(v3711_range_3_to_0_address_term_bound_9,bitIndex0)
    <=> v3711(constB9,bitIndex0) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_9,bitIndex1)
    <=> v3711(constB9,bitIndex1) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_9,bitIndex2)
    <=> v3711(constB9,bitIndex2) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_9,bitIndex3)
    <=> v3711(constB9,bitIndex3) ) ) ).

fof(is_address_28,axiom,
    address(v3711_range_3_to_0_address_term_bound_9) ).

fof(address_association_9,axiom,
    v3711_range_3_to_0_address_association(constB9,v3711_range_3_to_0_address_term_bound_9) ).

fof(address_false_msb_24,axiom,
    ~ addressVal(v3711_range_3_to_0_address_term_bound_8,bitIndex4) ).

fof(transient_address_definition_8,axiom,
    ( $true
    & ( addressVal(v3711_range_3_to_0_address_term_bound_8,bitIndex0)
    <=> v3711(constB8,bitIndex0) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_8,bitIndex1)
    <=> v3711(constB8,bitIndex1) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_8,bitIndex2)
    <=> v3711(constB8,bitIndex2) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_8,bitIndex3)
    <=> v3711(constB8,bitIndex3) ) ) ).

fof(is_address_27,axiom,
    address(v3711_range_3_to_0_address_term_bound_8) ).

fof(address_association_8,axiom,
    v3711_range_3_to_0_address_association(constB8,v3711_range_3_to_0_address_term_bound_8) ).

fof(address_false_msb_23,axiom,
    ~ addressVal(v3711_range_3_to_0_address_term_bound_7,bitIndex4) ).

fof(transient_address_definition_7,axiom,
    ( $true
    & ( addressVal(v3711_range_3_to_0_address_term_bound_7,bitIndex0)
    <=> v3711(constB7,bitIndex0) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_7,bitIndex1)
    <=> v3711(constB7,bitIndex1) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_7,bitIndex2)
    <=> v3711(constB7,bitIndex2) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_7,bitIndex3)
    <=> v3711(constB7,bitIndex3) ) ) ).

fof(is_address_26,axiom,
    address(v3711_range_3_to_0_address_term_bound_7) ).

fof(address_association_7,axiom,
    v3711_range_3_to_0_address_association(constB7,v3711_range_3_to_0_address_term_bound_7) ).

fof(address_false_msb_22,axiom,
    ~ addressVal(v3711_range_3_to_0_address_term_bound_6,bitIndex4) ).

fof(transient_address_definition_6,axiom,
    ( $true
    & ( addressVal(v3711_range_3_to_0_address_term_bound_6,bitIndex0)
    <=> v3711(constB6,bitIndex0) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_6,bitIndex1)
    <=> v3711(constB6,bitIndex1) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_6,bitIndex2)
    <=> v3711(constB6,bitIndex2) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_6,bitIndex3)
    <=> v3711(constB6,bitIndex3) ) ) ).

fof(is_address_25,axiom,
    address(v3711_range_3_to_0_address_term_bound_6) ).

fof(address_association_6,axiom,
    v3711_range_3_to_0_address_association(constB6,v3711_range_3_to_0_address_term_bound_6) ).

fof(address_false_msb_21,axiom,
    ~ addressVal(v3711_range_3_to_0_address_term_bound_5,bitIndex4) ).

fof(transient_address_definition_5,axiom,
    ( $true
    & ( addressVal(v3711_range_3_to_0_address_term_bound_5,bitIndex0)
    <=> v3711(constB5,bitIndex0) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_5,bitIndex1)
    <=> v3711(constB5,bitIndex1) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_5,bitIndex2)
    <=> v3711(constB5,bitIndex2) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_5,bitIndex3)
    <=> v3711(constB5,bitIndex3) ) ) ).

fof(is_address_24,axiom,
    address(v3711_range_3_to_0_address_term_bound_5) ).

fof(address_association_5,axiom,
    v3711_range_3_to_0_address_association(constB5,v3711_range_3_to_0_address_term_bound_5) ).

fof(address_false_msb_20,axiom,
    ~ addressVal(v3711_range_3_to_0_address_term_bound_4,bitIndex4) ).

fof(transient_address_definition_4,axiom,
    ( $true
    & ( addressVal(v3711_range_3_to_0_address_term_bound_4,bitIndex0)
    <=> v3711(constB4,bitIndex0) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_4,bitIndex1)
    <=> v3711(constB4,bitIndex1) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_4,bitIndex2)
    <=> v3711(constB4,bitIndex2) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_4,bitIndex3)
    <=> v3711(constB4,bitIndex3) ) ) ).

fof(is_address_23,axiom,
    address(v3711_range_3_to_0_address_term_bound_4) ).

fof(address_association_4,axiom,
    v3711_range_3_to_0_address_association(constB4,v3711_range_3_to_0_address_term_bound_4) ).

fof(address_false_msb_19,axiom,
    ~ addressVal(v3711_range_3_to_0_address_term_bound_3,bitIndex4) ).

fof(transient_address_definition_3,axiom,
    ( $true
    & ( addressVal(v3711_range_3_to_0_address_term_bound_3,bitIndex0)
    <=> v3711(constB3,bitIndex0) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_3,bitIndex1)
    <=> v3711(constB3,bitIndex1) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_3,bitIndex2)
    <=> v3711(constB3,bitIndex2) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_3,bitIndex3)
    <=> v3711(constB3,bitIndex3) ) ) ).

fof(is_address_22,axiom,
    address(v3711_range_3_to_0_address_term_bound_3) ).

fof(address_association_3,axiom,
    v3711_range_3_to_0_address_association(constB3,v3711_range_3_to_0_address_term_bound_3) ).

fof(address_false_msb_18,axiom,
    ~ addressVal(v3711_range_3_to_0_address_term_bound_2,bitIndex4) ).

fof(transient_address_definition_2,axiom,
    ( $true
    & ( addressVal(v3711_range_3_to_0_address_term_bound_2,bitIndex0)
    <=> v3711(constB2,bitIndex0) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_2,bitIndex1)
    <=> v3711(constB2,bitIndex1) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_2,bitIndex2)
    <=> v3711(constB2,bitIndex2) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_2,bitIndex3)
    <=> v3711(constB2,bitIndex3) ) ) ).

fof(is_address_21,axiom,
    address(v3711_range_3_to_0_address_term_bound_2) ).

fof(address_association_2,axiom,
    v3711_range_3_to_0_address_association(constB2,v3711_range_3_to_0_address_term_bound_2) ).

fof(address_false_msb_17,axiom,
    ~ addressVal(v3711_range_3_to_0_address_term_bound_1,bitIndex4) ).

fof(transient_address_definition_1,axiom,
    ( $true
    & ( addressVal(v3711_range_3_to_0_address_term_bound_1,bitIndex0)
    <=> v3711(constB1,bitIndex0) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_1,bitIndex1)
    <=> v3711(constB1,bitIndex1) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_1,bitIndex2)
    <=> v3711(constB1,bitIndex2) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_1,bitIndex3)
    <=> v3711(constB1,bitIndex3) ) ) ).

fof(is_address_20,axiom,
    address(v3711_range_3_to_0_address_term_bound_1) ).

fof(address_association_1,axiom,
    v3711_range_3_to_0_address_association(constB1,v3711_range_3_to_0_address_term_bound_1) ).

fof(address_false_msb_16,axiom,
    ~ addressVal(v3711_range_3_to_0_address_term_bound_0,bitIndex4) ).

fof(transient_address_definition,axiom,
    ( $true
    & ( addressVal(v3711_range_3_to_0_address_term_bound_0,bitIndex0)
    <=> v3711(constB0,bitIndex0) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_0,bitIndex1)
    <=> v3711(constB0,bitIndex1) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_0,bitIndex2)
    <=> v3711(constB0,bitIndex2) )
    & ( addressVal(v3711_range_3_to_0_address_term_bound_0,bitIndex3)
    <=> v3711(constB0,bitIndex3) ) ) ).

fof(is_address_19,axiom,
    address(v3711_range_3_to_0_address_term_bound_0) ).

fof(address_association,axiom,
    v3711_range_3_to_0_address_association(constB0,v3711_range_3_to_0_address_term_bound_0) ).

fof(address_false_msb_15,axiom,
    ~ addressVal(b1011_address_term,bitIndex4) ).

fof(is_address_18,axiom,
    address(b1011_address_term) ).

fof(constant_address_definition_18,axiom,
    ! [B] :
      ( addressVal(b1011_address_term,B)
    <=> b1011(B) ) ).

fof(is_address_17,axiom,
    address(b01010_address_term) ).

fof(constant_address_definition_17,axiom,
    ! [B] :
      ( addressVal(b01010_address_term,B)
    <=> b01010(B) ) ).

fof(is_address_16,axiom,
    address(b01001_address_term) ).

fof(constant_address_definition_16,axiom,
    ! [B] :
      ( addressVal(b01001_address_term,B)
    <=> b01001(B) ) ).

fof(address_false_msb_14,axiom,
    ~ addressVal(b1111_address_term,bitIndex4) ).

fof(is_address_15,axiom,
    address(b1111_address_term) ).

fof(constant_address_definition_15,axiom,
    ! [B] :
      ( addressVal(b1111_address_term,B)
    <=> b1111(B) ) ).

fof(address_false_msb_13,axiom,
    ~ addressVal(b0011_address_term,bitIndex4) ).

fof(is_address_14,axiom,
    address(b0011_address_term) ).

fof(constant_address_definition_14,axiom,
    ! [B] :
      ( addressVal(b0011_address_term,B)
    <=> b0011(B) ) ).

fof(address_false_msb_12,axiom,
    ~ addressVal(b0111_address_term,bitIndex4) ).

fof(is_address_13,axiom,
    address(b0111_address_term) ).

fof(constant_address_definition_13,axiom,
    ! [B] :
      ( addressVal(b0111_address_term,B)
    <=> b0111(B) ) ).

fof(address_false_msb_11,axiom,
    ~ addressVal(b1000_address_term,bitIndex4) ).

fof(is_address_12,axiom,
    address(b1000_address_term) ).

fof(constant_address_definition_12,axiom,
    ! [B] :
      ( addressVal(b1000_address_term,B)
    <=> b1000(B) ) ).

fof(address_false_msb_10,axiom,
    ~ addressVal(b0010_address_term,bitIndex4) ).

fof(is_address_11,axiom,
    address(b0010_address_term) ).

fof(constant_address_definition_11,axiom,
    ! [B] :
      ( addressVal(b0010_address_term,B)
    <=> b0010(B) ) ).

fof(address_false_msb_9,axiom,
    ~ addressVal(b0101_address_term,bitIndex4) ).

fof(is_address_10,axiom,
    address(b0101_address_term) ).

fof(constant_address_definition_10,axiom,
    ! [B] :
      ( addressVal(b0101_address_term,B)
    <=> b0101(B) ) ).

fof(address_false_msb_8,axiom,
    ~ addressVal(b0110_address_term,bitIndex4) ).

fof(is_address_9,axiom,
    address(b0110_address_term) ).

fof(constant_address_definition_9,axiom,
    ! [B] :
      ( addressVal(b0110_address_term,B)
    <=> b0110(B) ) ).

fof(address_false_msb_7,axiom,
    ~ addressVal(b0100_address_term,bitIndex4) ).

fof(is_address_8,axiom,
    address(b0100_address_term) ).

fof(constant_address_definition_8,axiom,
    ! [B] :
      ( addressVal(b0100_address_term,B)
    <=> b0100(B) ) ).

fof(address_false_msb_6,axiom,
    ~ addressVal(b0001_address_term,bitIndex4) ).

fof(is_address_7,axiom,
    address(b0001_address_term) ).

fof(constant_address_definition_7,axiom,
    ! [B] :
      ( addressVal(b0001_address_term,B)
    <=> b0001(B) ) ).

fof(address_false_msb_5,axiom,
    ~ addressVal(b1101_address_term,bitIndex4) ).

fof(is_address_6,axiom,
    address(b1101_address_term) ).

fof(constant_address_definition_6,axiom,
    ! [B] :
      ( addressVal(b1101_address_term,B)
    <=> b1101(B) ) ).

fof(address_false_msb_4,axiom,
    ~ addressVal(b1110_address_term,bitIndex4) ).

fof(is_address_5,axiom,
    address(b1110_address_term) ).

fof(constant_address_definition_5,axiom,
    ! [B] :
      ( addressVal(b1110_address_term,B)
    <=> b1110(B) ) ).

fof(address_false_msb_3,axiom,
    ~ addressVal(b1100_address_term,bitIndex4) ).

fof(is_address_4,axiom,
    address(b1100_address_term) ).

fof(constant_address_definition_4,axiom,
    ! [B] :
      ( addressVal(b1100_address_term,B)
    <=> b1100(B) ) ).

fof(address_false_msb_2,axiom,
    ~ addressVal(b1010_address_term,bitIndex4) ).

fof(is_address_3,axiom,
    address(b1010_address_term) ).

fof(constant_address_definition_3,axiom,
    ! [B] :
      ( addressVal(b1010_address_term,B)
    <=> b1010(B) ) ).

fof(address_false_msb_1,axiom,
    ~ addressVal(b1001_address_term,bitIndex4) ).

fof(is_address_2,axiom,
    address(b1001_address_term) ).

fof(constant_address_definition_2,axiom,
    ! [B] :
      ( addressVal(b1001_address_term,B)
    <=> b1001(B) ) ).

fof(is_address_1,axiom,
    address(b00000_address_term) ).

fof(constant_address_definition_1,axiom,
    ! [B] :
      ( addressVal(b00000_address_term,B)
    <=> b00000(B) ) ).

fof(address_false_msb,axiom,
    ~ addressVal(b0000_address_term,bitIndex4) ).

fof(is_address,axiom,
    address(b0000_address_term) ).

fof(constant_address_definition,axiom,
    ! [B] :
      ( addressVal(b0000_address_term,B)
    <=> b0000(B) ) ).

fof(addressDiff,axiom,
    ! [B,A2,A1] :
      ( ( address(A1)
        & address(A2)
        & addressDiff(A1,A2,B) )
     => ( A1 = A2
        | ( addressVal(A1,B)
        <=> ~ addressVal(A2,B) ) ) ) ).

fof(addressDomain,axiom,
    ! [A1,A2] :
      ( addressDiff(A1,A2,bitIndex0)
      | addressDiff(A1,A2,bitIndex1)
      | addressDiff(A1,A2,bitIndex2)
      | addressDiff(A1,A2,bitIndex3)
      | addressDiff(A1,A2,bitIndex4) ) ).

fof(addAssertion,conjecture,
    ! [VarCurr] :
      ( reachableState(VarCurr)
     => v4(VarCurr) ) ).

fof(writeUnaryOperator_4647,axiom,
    ! [VarCurr] :
      ( ~ v4(VarCurr)
    <=> v52706(VarCurr) ) ).

fof(writeUnaryOperator_4646,axiom,
    ! [VarCurr] :
      ( ~ v52706(VarCurr)
    <=> v52707(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11106,axiom,
    ! [VarCurr] :
      ( v52707(VarCurr)
    <=> ( v52709(VarCurr)
        & v52766(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1936,axiom,
    ! [VarCurr] :
      ( v52766(VarCurr)
    <=> ( v52767(VarCurr)
        | v6(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1935,axiom,
    ! [VarCurr] :
      ( v52767(VarCurr)
    <=> ( v52768(VarCurr)
        | v6(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1934,axiom,
    ! [VarCurr] :
      ( v52768(VarCurr)
    <=> ( v52769(VarCurr)
        | v6(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1933,axiom,
    ! [VarCurr] :
      ( v52769(VarCurr)
    <=> ( v52770(VarCurr)
        | v6(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1932,axiom,
    ! [VarCurr] :
      ( v52770(VarCurr)
    <=> ( v52771(VarCurr)
        | v6(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1931,axiom,
    ! [VarCurr] :
      ( v52771(VarCurr)
    <=> ( v52772(VarCurr)
        | v6(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1930,axiom,
    ! [VarCurr] :
      ( v52772(VarCurr)
    <=> ( v52773(VarCurr)
        | v6(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1929,axiom,
    ! [VarCurr] :
      ( v52773(VarCurr)
    <=> ( v52774(VarCurr)
        | v6(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1928,axiom,
    ! [VarCurr] :
      ( v52774(VarCurr)
    <=> ( v52775(VarCurr)
        | v6(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1927,axiom,
    ! [VarCurr] :
      ( v52775(VarCurr)
    <=> ( v52776(VarCurr)
        | v6(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1926,axiom,
    ! [VarCurr] :
      ( v52776(VarCurr)
    <=> ( v6(VarCurr,bitIndex0)
        | v6(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11105,axiom,
    ! [VarCurr] :
      ( v52709(VarCurr)
    <=> ( v52710(VarCurr)
        | v52733(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11104,axiom,
    ! [VarCurr] :
      ( v52733(VarCurr)
    <=> ( v52734(VarCurr)
        | v52735(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11103,axiom,
    ! [VarCurr] :
      ( v52735(VarCurr)
    <=> ( v52711(VarCurr)
        & v52736(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11102,axiom,
    ! [VarCurr] :
      ( v52736(VarCurr)
    <=> ( v52737(VarCurr)
        | v52738(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11101,axiom,
    ! [VarCurr] :
      ( v52738(VarCurr)
    <=> ( v52713(VarCurr)
        & v52739(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11100,axiom,
    ! [VarCurr] :
      ( v52739(VarCurr)
    <=> ( v52740(VarCurr)
        | v52741(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11099,axiom,
    ! [VarCurr] :
      ( v52741(VarCurr)
    <=> ( v52715(VarCurr)
        & v52742(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11098,axiom,
    ! [VarCurr] :
      ( v52742(VarCurr)
    <=> ( v52743(VarCurr)
        | v52744(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11097,axiom,
    ! [VarCurr] :
      ( v52744(VarCurr)
    <=> ( v52717(VarCurr)
        & v52745(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11096,axiom,
    ! [VarCurr] :
      ( v52745(VarCurr)
    <=> ( v52746(VarCurr)
        | v52747(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11095,axiom,
    ! [VarCurr] :
      ( v52747(VarCurr)
    <=> ( v52719(VarCurr)
        & v52748(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11094,axiom,
    ! [VarCurr] :
      ( v52748(VarCurr)
    <=> ( v52749(VarCurr)
        | v52750(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11093,axiom,
    ! [VarCurr] :
      ( v52750(VarCurr)
    <=> ( v52721(VarCurr)
        & v52751(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11092,axiom,
    ! [VarCurr] :
      ( v52751(VarCurr)
    <=> ( v52752(VarCurr)
        | v52753(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11091,axiom,
    ! [VarCurr] :
      ( v52753(VarCurr)
    <=> ( v52723(VarCurr)
        & v52754(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11090,axiom,
    ! [VarCurr] :
      ( v52754(VarCurr)
    <=> ( v52755(VarCurr)
        | v52756(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11089,axiom,
    ! [VarCurr] :
      ( v52756(VarCurr)
    <=> ( v52725(VarCurr)
        & v52757(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11088,axiom,
    ! [VarCurr] :
      ( v52757(VarCurr)
    <=> ( v52758(VarCurr)
        | v52759(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11087,axiom,
    ! [VarCurr] :
      ( v52759(VarCurr)
    <=> ( v52727(VarCurr)
        & v52760(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11086,axiom,
    ! [VarCurr] :
      ( v52760(VarCurr)
    <=> ( v52761(VarCurr)
        | v52762(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11085,axiom,
    ! [VarCurr] :
      ( v52762(VarCurr)
    <=> ( v52729(VarCurr)
        & v52763(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11084,axiom,
    ! [VarCurr] :
      ( v52763(VarCurr)
    <=> ( v52764(VarCurr)
        | v52765(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11083,axiom,
    ! [VarCurr] :
      ( v52765(VarCurr)
    <=> ( v6(VarCurr,bitIndex0)
        & v52732(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1925,axiom,
    ! [VarCurr] :
      ( v52764(VarCurr)
    <=> ( v52731(VarCurr)
        & v6(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1924,axiom,
    ! [VarCurr] :
      ( v52761(VarCurr)
    <=> ( v6(VarCurr,bitIndex2)
        & v52730(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1923,axiom,
    ! [VarCurr] :
      ( v52758(VarCurr)
    <=> ( v6(VarCurr,bitIndex3)
        & v52728(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1922,axiom,
    ! [VarCurr] :
      ( v52755(VarCurr)
    <=> ( v6(VarCurr,bitIndex4)
        & v52726(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1921,axiom,
    ! [VarCurr] :
      ( v52752(VarCurr)
    <=> ( v6(VarCurr,bitIndex5)
        & v52724(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1920,axiom,
    ! [VarCurr] :
      ( v52749(VarCurr)
    <=> ( v6(VarCurr,bitIndex6)
        & v52722(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1919,axiom,
    ! [VarCurr] :
      ( v52746(VarCurr)
    <=> ( v6(VarCurr,bitIndex7)
        & v52720(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1918,axiom,
    ! [VarCurr] :
      ( v52743(VarCurr)
    <=> ( v6(VarCurr,bitIndex8)
        & v52718(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1917,axiom,
    ! [VarCurr] :
      ( v52740(VarCurr)
    <=> ( v6(VarCurr,bitIndex9)
        & v52716(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1916,axiom,
    ! [VarCurr] :
      ( v52737(VarCurr)
    <=> ( v6(VarCurr,bitIndex10)
        & v52714(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1915,axiom,
    ! [VarCurr] :
      ( v52734(VarCurr)
    <=> ( v6(VarCurr,bitIndex11)
        & v52712(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11082,axiom,
    ! [VarCurr] :
      ( v52710(VarCurr)
    <=> ( v52711(VarCurr)
        & v52712(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11081,axiom,
    ! [VarCurr] :
      ( v52712(VarCurr)
    <=> ( v52713(VarCurr)
        & v52714(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11080,axiom,
    ! [VarCurr] :
      ( v52714(VarCurr)
    <=> ( v52715(VarCurr)
        & v52716(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11079,axiom,
    ! [VarCurr] :
      ( v52716(VarCurr)
    <=> ( v52717(VarCurr)
        & v52718(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11078,axiom,
    ! [VarCurr] :
      ( v52718(VarCurr)
    <=> ( v52719(VarCurr)
        & v52720(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11077,axiom,
    ! [VarCurr] :
      ( v52720(VarCurr)
    <=> ( v52721(VarCurr)
        & v52722(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11076,axiom,
    ! [VarCurr] :
      ( v52722(VarCurr)
    <=> ( v52723(VarCurr)
        & v52724(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11075,axiom,
    ! [VarCurr] :
      ( v52724(VarCurr)
    <=> ( v52725(VarCurr)
        & v52726(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11074,axiom,
    ! [VarCurr] :
      ( v52726(VarCurr)
    <=> ( v52727(VarCurr)
        & v52728(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11073,axiom,
    ! [VarCurr] :
      ( v52728(VarCurr)
    <=> ( v52729(VarCurr)
        & v52730(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11072,axiom,
    ! [VarCurr] :
      ( v52730(VarCurr)
    <=> ( v52731(VarCurr)
        & v52732(VarCurr) ) ) ).

fof(writeUnaryOperator_4645,axiom,
    ! [VarCurr] :
      ( ~ v52732(VarCurr)
    <=> v6(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_4644,axiom,
    ! [VarCurr] :
      ( ~ v52731(VarCurr)
    <=> v6(VarCurr,bitIndex0) ) ).

fof(writeUnaryOperator_4643,axiom,
    ! [VarCurr] :
      ( ~ v52729(VarCurr)
    <=> v6(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_4642,axiom,
    ! [VarCurr] :
      ( ~ v52727(VarCurr)
    <=> v6(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_4641,axiom,
    ! [VarCurr] :
      ( ~ v52725(VarCurr)
    <=> v6(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_4640,axiom,
    ! [VarCurr] :
      ( ~ v52723(VarCurr)
    <=> v6(VarCurr,bitIndex5) ) ).

fof(writeUnaryOperator_4639,axiom,
    ! [VarCurr] :
      ( ~ v52721(VarCurr)
    <=> v6(VarCurr,bitIndex6) ) ).

fof(writeUnaryOperator_4638,axiom,
    ! [VarCurr] :
      ( ~ v52719(VarCurr)
    <=> v6(VarCurr,bitIndex7) ) ).

fof(writeUnaryOperator_4637,axiom,
    ! [VarCurr] :
      ( ~ v52717(VarCurr)
    <=> v6(VarCurr,bitIndex8) ) ).

fof(writeUnaryOperator_4636,axiom,
    ! [VarCurr] :
      ( ~ v52715(VarCurr)
    <=> v6(VarCurr,bitIndex9) ) ).

fof(writeUnaryOperator_4635,axiom,
    ! [VarCurr] :
      ( ~ v52713(VarCurr)
    <=> v6(VarCurr,bitIndex10) ) ).

fof(writeUnaryOperator_4634,axiom,
    ! [VarCurr] :
      ( ~ v52711(VarCurr)
    <=> v6(VarCurr,bitIndex11) ) ).

fof(addCaseBooleanConditionEqualRanges1_1015,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52694(VarNext)
       => ! [B] :
            ( range_11_1(B)
           => ( v6(VarNext,B)
            <=> v6(VarCurr,B) ) ) ) ) ).

fof(range_axiom_219,axiom,
    ! [B] :
      ( range_11_1(B)
    <=> ( $false
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B ) ) ).

fof(addCaseBooleanConditionShiftedRanges0_28,axiom,
    ! [VarNext] :
      ( v52694(VarNext)
     => ( ( v6(VarNext,bitIndex11)
        <=> v52702(VarNext,bitIndex10) )
        & ( v6(VarNext,bitIndex10)
        <=> v52702(VarNext,bitIndex9) )
        & ( v6(VarNext,bitIndex9)
        <=> v52702(VarNext,bitIndex8) )
        & ( v6(VarNext,bitIndex8)
        <=> v52702(VarNext,bitIndex7) )
        & ( v6(VarNext,bitIndex7)
        <=> v52702(VarNext,bitIndex6) )
        & ( v6(VarNext,bitIndex6)
        <=> v52702(VarNext,bitIndex5) )
        & ( v6(VarNext,bitIndex5)
        <=> v52702(VarNext,bitIndex4) )
        & ( v6(VarNext,bitIndex4)
        <=> v52702(VarNext,bitIndex3) )
        & ( v6(VarNext,bitIndex3)
        <=> v52702(VarNext,bitIndex2) )
        & ( v6(VarNext,bitIndex2)
        <=> v52702(VarNext,bitIndex1) )
        & ( v6(VarNext,bitIndex1)
        <=> v52702(VarNext,bitIndex0) ) ) ) ).

fof(addAssignment_19285,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_10_0(B)
         => ( v52702(VarNext,B)
          <=> v52700(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_487,axiom,
    ! [VarCurr] :
      ( ~ v52689(VarCurr)
     => ( ( v52700(VarCurr,bitIndex10)
        <=> v19(VarCurr,bitIndex11) )
        & ( v52700(VarCurr,bitIndex9)
        <=> v19(VarCurr,bitIndex10) )
        & ( v52700(VarCurr,bitIndex8)
        <=> v19(VarCurr,bitIndex9) )
        & ( v52700(VarCurr,bitIndex7)
        <=> v19(VarCurr,bitIndex8) )
        & ( v52700(VarCurr,bitIndex6)
        <=> v19(VarCurr,bitIndex7) )
        & ( v52700(VarCurr,bitIndex5)
        <=> v19(VarCurr,bitIndex6) )
        & ( v52700(VarCurr,bitIndex4)
        <=> v19(VarCurr,bitIndex5) )
        & ( v52700(VarCurr,bitIndex3)
        <=> v19(VarCurr,bitIndex4) )
        & ( v52700(VarCurr,bitIndex2)
        <=> v19(VarCurr,bitIndex3) )
        & ( v52700(VarCurr,bitIndex1)
        <=> v19(VarCurr,bitIndex2) )
        & ( v52700(VarCurr,bitIndex0)
        <=> v19(VarCurr,bitIndex1) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1488,axiom,
    ! [VarCurr] :
      ( v52689(VarCurr)
     => ! [B] :
          ( range_10_0(B)
         => ( v52700(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11071,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52694(VarNext)
      <=> v52695(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11070,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52695(VarNext)
      <=> ( v52697(VarNext)
          & v5694(VarNext) ) ) ) ).

fof(writeUnaryOperator_4633,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52697(VarNext)
      <=> v5701(VarNext) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_1014,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52680(VarNext)
       => ( v6(VarNext,bitIndex0)
        <=> v6(VarCurr,bitIndex0) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1086,axiom,
    ! [VarNext] :
      ( v52680(VarNext)
     => ( v6(VarNext,bitIndex0)
      <=> v52688(VarNext) ) ) ).

fof(addAssignment_19284,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52688(VarNext)
      <=> v52686(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1650,axiom,
    ! [VarCurr] :
      ( ~ v52689(VarCurr)
     => ( v52686(VarCurr)
      <=> v19(VarCurr,bitIndex0) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1487,axiom,
    ! [VarCurr] :
      ( v52689(VarCurr)
     => ( v52686(VarCurr)
      <=> $true ) ) ).

fof(writeUnaryOperator_4632,axiom,
    ! [VarCurr] :
      ( ~ v52689(VarCurr)
    <=> v8(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11069,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52680(VarNext)
      <=> v52681(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11068,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52681(VarNext)
      <=> ( v52682(VarNext)
          & v5694(VarNext) ) ) ) ).

fof(writeUnaryOperator_4631,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52682(VarNext)
      <=> v5701(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1649,axiom,
    ! [VarCurr] :
      ( ~ v52633(VarCurr)
     => ( v19(VarCurr,bitIndex0)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1486,axiom,
    ! [VarCurr] :
      ( v52633(VarCurr)
     => ( v19(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11067,axiom,
    ! [VarCurr] :
      ( v52633(VarCurr)
    <=> ( v52634(VarCurr)
        | v52674(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11066,axiom,
    ! [VarCurr] :
      ( v52674(VarCurr)
    <=> ( v52675(VarCurr)
        & v4243(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11065,axiom,
    ! [VarCurr] :
      ( v52675(VarCurr)
    <=> ( v52676(VarCurr)
        | v52677(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11064,axiom,
    ! [VarCurr] :
      ( v52677(VarCurr)
    <=> ( v4524(VarCurr)
        & v45458(VarCurr) ) ) ).

fof(addAssignment_19283,axiom,
    ! [VarCurr] :
      ( v52676(VarCurr)
    <=> v52644(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11063,axiom,
    ! [VarCurr] :
      ( v52634(VarCurr)
    <=> ( v52635(VarCurr)
        | v52670(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11062,axiom,
    ! [VarCurr] :
      ( v52670(VarCurr)
    <=> ( v52671(VarCurr)
        & v4240(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11061,axiom,
    ! [VarCurr] :
      ( v52671(VarCurr)
    <=> ( v52672(VarCurr)
        | v52673(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11060,axiom,
    ! [VarCurr] :
      ( v52673(VarCurr)
    <=> ( v4532(VarCurr)
        & v45458(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11059,axiom,
    ! [VarCurr] :
      ( v52672(VarCurr)
    <=> ( v52644(VarCurr)
        & v4169(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11058,axiom,
    ! [VarCurr] :
      ( v52635(VarCurr)
    <=> ( v52636(VarCurr)
        | v52664(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11057,axiom,
    ! [VarCurr] :
      ( v52664(VarCurr)
    <=> ( v52665(VarCurr)
        & v4125(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11056,axiom,
    ! [VarCurr] :
      ( v52665(VarCurr)
    <=> ( v52666(VarCurr)
        | v52669(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11055,axiom,
    ! [VarCurr] :
      ( v52669(VarCurr)
    <=> ( v4524(VarCurr)
        & v45458(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11054,axiom,
    ! [VarCurr] :
      ( v52666(VarCurr)
    <=> ( v52667(VarCurr)
        | v52668(VarCurr) ) ) ).

fof(addAssignment_19282,axiom,
    ! [VarCurr] :
      ( v52668(VarCurr)
    <=> v52644(VarCurr) ) ).

fof(addAssignment_19281,axiom,
    ! [VarCurr] :
      ( v52667(VarCurr)
    <=> v21(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11053,axiom,
    ! [VarCurr] :
      ( v52636(VarCurr)
    <=> ( v52637(VarCurr)
        | v52660(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11052,axiom,
    ! [VarCurr] :
      ( v52660(VarCurr)
    <=> ( v52661(VarCurr)
        & v4235(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11051,axiom,
    ! [VarCurr] :
      ( v52661(VarCurr)
    <=> ( v52662(VarCurr)
        | v52663(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11050,axiom,
    ! [VarCurr] :
      ( v52663(VarCurr)
    <=> ( v4532(VarCurr)
        & v45458(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11049,axiom,
    ! [VarCurr] :
      ( v52662(VarCurr)
    <=> ( v52644(VarCurr)
        & v4169(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11048,axiom,
    ! [VarCurr] :
      ( v52637(VarCurr)
    <=> ( v52638(VarCurr)
        | v52654(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11047,axiom,
    ! [VarCurr] :
      ( v52654(VarCurr)
    <=> ( v52655(VarCurr)
        & v4122(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11046,axiom,
    ! [VarCurr] :
      ( v52655(VarCurr)
    <=> ( v52656(VarCurr)
        | v52659(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11045,axiom,
    ! [VarCurr] :
      ( v52659(VarCurr)
    <=> ( v4524(VarCurr)
        & v45458(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11044,axiom,
    ! [VarCurr] :
      ( v52656(VarCurr)
    <=> ( v52657(VarCurr)
        | v52658(VarCurr) ) ) ).

fof(addAssignment_19280,axiom,
    ! [VarCurr] :
      ( v52658(VarCurr)
    <=> v52644(VarCurr) ) ).

fof(addAssignment_19279,axiom,
    ! [VarCurr] :
      ( v52657(VarCurr)
    <=> v21(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11043,axiom,
    ! [VarCurr] :
      ( v52638(VarCurr)
    <=> ( v52639(VarCurr)
        | v52648(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11042,axiom,
    ! [VarCurr] :
      ( v52648(VarCurr)
    <=> ( v52649(VarCurr)
        & v4230(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11041,axiom,
    ! [VarCurr] :
      ( v52649(VarCurr)
    <=> ( v52650(VarCurr)
        | v52652(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11040,axiom,
    ! [VarCurr] :
      ( v52652(VarCurr)
    <=> ( v4532(VarCurr)
        & v45458(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11039,axiom,
    ! [VarCurr] :
      ( v52650(VarCurr)
    <=> ( v52644(VarCurr)
        & v4169(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11038,axiom,
    ! [VarCurr] :
      ( v52644(VarCurr)
    <=> ( v52645(VarCurr)
        & v4117(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11037,axiom,
    ! [VarCurr] :
      ( v52639(VarCurr)
    <=> ( v52640(VarCurr)
        & v4119(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11036,axiom,
    ! [VarCurr] :
      ( v52640(VarCurr)
    <=> ( v52641(VarCurr)
        | v52646(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11035,axiom,
    ! [VarCurr] :
      ( v52646(VarCurr)
    <=> ( v4524(VarCurr)
        & v45458(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11034,axiom,
    ! [VarCurr] :
      ( v52641(VarCurr)
    <=> ( v52642(VarCurr)
        | v52643(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11033,axiom,
    ! [VarCurr] :
      ( v52643(VarCurr)
    <=> ( v52645(VarCurr)
        & v4117(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11032,axiom,
    ! [VarCurr] :
      ( v52645(VarCurr)
    <=> ( v4225(VarCurr)
        & v4116(VarCurr) ) ) ).

fof(addAssignment_19278,axiom,
    ! [VarCurr] :
      ( v52642(VarCurr)
    <=> v21(VarCurr) ) ).

fof(addAssignment_19277,axiom,
    ! [VarCurr] :
      ( v21(VarCurr)
    <=> v23(VarCurr) ) ).

fof(addAssignment_19276,axiom,
    ! [VarCurr] :
      ( v23(VarCurr)
    <=> v25(VarCurr) ) ).

fof(addAssignment_19275,axiom,
    ! [VarCurr] :
      ( v25(VarCurr)
    <=> v27(VarCurr) ) ).

fof(addAssignment_19274,axiom,
    ! [VarCurr] :
      ( v27(VarCurr)
    <=> v29(VarCurr) ) ).

fof(addAssignment_19273,axiom,
    ! [VarCurr] :
      ( v29(VarCurr)
    <=> v31(VarCurr) ) ).

fof(addAssignment_19272,axiom,
    ! [VarCurr] :
      ( v31(VarCurr)
    <=> v33(VarCurr) ) ).

fof(addAssignment_19271,axiom,
    ! [VarCurr] :
      ( v33(VarCurr)
    <=> v35(VarCurr) ) ).

fof(addAssignment_19270,axiom,
    ! [VarCurr] :
      ( v35(VarCurr)
    <=> v37(VarCurr) ) ).

fof(addAssignment_19269,axiom,
    ! [VarCurr] :
      ( v37(VarCurr)
    <=> v39(VarCurr,bitIndex2) ) ).

fof(addAssignment_19268,axiom,
    ! [VarNext] :
      ( v39(VarNext,bitIndex2)
    <=> v52621(VarNext,bitIndex2) ) ).

fof(addCaseBooleanConditionEqualRanges1_1013,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52622(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v52621(VarNext,B)
            <=> v39(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1085,axiom,
    ! [VarNext] :
      ( v52622(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v52621(VarNext,B)
          <=> v45633(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11031,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52622(VarNext)
      <=> v52623(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11030,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52623(VarNext)
      <=> ( v52625(VarNext)
          & v45616(VarNext) ) ) ) ).

fof(writeUnaryOperator_4630,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52625(VarNext)
      <=> v45627(VarNext) ) ) ).

fof(addAssignment_19267,axiom,
    ! [VarCurr] :
      ( v50(VarCurr,bitIndex2)
    <=> v45601(VarCurr,bitIndex2) ) ).

fof(addAssignment_19266,axiom,
    ! [VarCurr] :
      ( v45600(VarCurr,bitIndex2)
    <=> v45637(VarCurr,bitIndex2) ) ).

fof(addAssignment_19265,axiom,
    ! [VarNext] :
      ( v39(VarNext,bitIndex3)
    <=> v52613(VarNext,bitIndex3) ) ).

fof(addCaseBooleanConditionEqualRanges1_1012,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52614(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v52613(VarNext,B)
            <=> v39(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1084,axiom,
    ! [VarNext] :
      ( v52614(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v52613(VarNext,B)
          <=> v45633(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11029,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52614(VarNext)
      <=> v52615(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11028,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52615(VarNext)
      <=> ( v52617(VarNext)
          & v45616(VarNext) ) ) ) ).

fof(writeUnaryOperator_4629,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52617(VarNext)
      <=> v45627(VarNext) ) ) ).

fof(addAssignment_19264,axiom,
    ! [VarCurr] :
      ( v50(VarCurr,bitIndex3)
    <=> v45601(VarCurr,bitIndex3) ) ).

fof(addAssignment_19263,axiom,
    ! [VarCurr] :
      ( v45600(VarCurr,bitIndex3)
    <=> v45637(VarCurr,bitIndex3) ) ).

fof(addAssignment_19262,axiom,
    ! [VarCurr] :
      ( v45582(VarCurr)
    <=> v45584(VarCurr) ) ).

fof(addAssignment_19261,axiom,
    ! [VarCurr] :
      ( v45584(VarCurr)
    <=> v45586(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_456,axiom,
    ! [VarCurr] :
      ( ( ~ v47911(VarCurr)
        & ~ v47929(VarCurr) )
     => ( v45586(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1205,axiom,
    ! [VarCurr] :
      ( v47929(VarCurr)
     => ( v45586(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1170,axiom,
    ! [VarCurr] :
      ( v47911(VarCurr)
     => ( v45586(VarCurr)
      <=> $false ) ) ).

fof(addCaseBooleanConditionEqualRanges1_1011,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52599(VarNext)
       => ! [B] :
            ( range_1_0(B)
           => ( v45588(VarNext,B)
            <=> v45588(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1083,axiom,
    ! [VarNext] :
      ( v52599(VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v45588(VarNext,B)
          <=> v52607(VarNext,B) ) ) ) ).

fof(addAssignment_19260,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v52607(VarNext,B)
          <=> v52605(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1648,axiom,
    ! [VarCurr] :
      ( ~ v52608(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v52605(VarCurr,B)
          <=> v45590(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1485,axiom,
    ! [VarCurr] :
      ( v52608(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v52605(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3379,axiom,
    ! [VarCurr] :
      ( v52608(VarCurr)
    <=> ( v45(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11027,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52599(VarNext)
      <=> v52600(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11026,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52600(VarNext)
      <=> ( v52601(VarNext)
          & v45620(VarNext) ) ) ) ).

fof(writeUnaryOperator_4628,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52601(VarNext)
      <=> v47885(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_455,axiom,
    ! [VarCurr] :
      ( ( ~ v52587(VarCurr)
        & ~ v52596(VarCurr) )
     => ! [B] :
          ( range_1_0(B)
         => ( v45590(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1204,axiom,
    ! [VarCurr] :
      ( v52596(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v45590(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1169,axiom,
    ! [VarCurr] :
      ( v52587(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v45590(VarCurr,B)
          <=> v52588(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3378,axiom,
    ! [VarCurr] :
      ( v52596(VarCurr)
    <=> ( ( v45588(VarCurr,bitIndex1)
        <=> $false )
        & ( v45588(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1203,axiom,
    ! [VarCurr] :
      ( ~ v52589(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v52588(VarCurr,B)
          <=> v52591(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1168,axiom,
    ! [VarCurr] :
      ( v52589(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v52588(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1202,axiom,
    ! [VarCurr] :
      ( ~ v52592(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v52591(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1167,axiom,
    ! [VarCurr] :
      ( v52592(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v52591(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3377,axiom,
    ! [VarCurr] :
      ( v52594(VarCurr)
    <=> ( v52595(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11025,axiom,
    ! [VarCurr] :
      ( v52595(VarCurr)
    <=> ( v46405(VarCurr)
        | v46409(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3376,axiom,
    ! [VarCurr] :
      ( v52592(VarCurr)
    <=> ( v52593(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11024,axiom,
    ! [VarCurr] :
      ( v52593(VarCurr)
    <=> ( v46405(VarCurr)
        | v46409(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3375,axiom,
    ! [VarCurr] :
      ( v52590(VarCurr)
    <=> ( v45592(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3374,axiom,
    ! [VarCurr] :
      ( v52589(VarCurr)
    <=> ( v45592(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_3373,axiom,
    ! [VarCurr] :
      ( v52587(VarCurr)
    <=> ( ( v45588(VarCurr,bitIndex1)
        <=> $false )
        & ( v45588(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_1010,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52572(VarNext)
       => ( v46405(VarNext)
        <=> v46405(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1082,axiom,
    ! [VarNext] :
      ( v52572(VarNext)
     => ( v46405(VarNext)
      <=> v52580(VarNext) ) ) ).

fof(addAssignment_19259,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52580(VarNext)
      <=> v52578(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1647,axiom,
    ! [VarCurr] :
      ( ~ v48464(VarCurr)
     => ( v52578(VarCurr)
      <=> v52581(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1484,axiom,
    ! [VarCurr] :
      ( v48464(VarCurr)
     => ( v52578(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1646,axiom,
    ! [VarCurr] :
      ( ~ v46407(VarCurr)
     => ( v52581(VarCurr)
      <=> v52582(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1483,axiom,
    ! [VarCurr] :
      ( v46407(VarCurr)
     => ( v52581(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11023,axiom,
    ! [VarCurr] :
      ( v52582(VarCurr)
    <=> ( v52583(VarCurr)
        & v46405(VarCurr) ) ) ).

fof(writeUnaryOperator_4627,axiom,
    ! [VarCurr] :
      ( ~ v52583(VarCurr)
    <=> v52558(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11022,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52572(VarNext)
      <=> v52573(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11021,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52573(VarNext)
      <=> ( v52575(VarNext)
          & v45620(VarNext) ) ) ) ).

fof(writeUnaryOperator_4626,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52575(VarNext)
      <=> v47885(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_133,axiom,
    ! [VarCurr] :
      ( ( ~ v51502(VarCurr)
        & ~ v51503(VarCurr)
        & ~ v51534(VarCurr) )
     => ( v52558(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_454,axiom,
    ! [VarCurr] :
      ( v51534(VarCurr)
     => ( v52558(VarCurr)
      <=> v52569(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1201,axiom,
    ! [VarCurr] :
      ( v51503(VarCurr)
     => ( v52558(VarCurr)
      <=> v52560(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1166,axiom,
    ! [VarCurr] :
      ( v51502(VarCurr)
     => ( v52558(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1200,axiom,
    ! [VarCurr] :
      ( ~ v51536(VarCurr)
     => ( v52569(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1165,axiom,
    ! [VarCurr] :
      ( v51536(VarCurr)
     => ( v52569(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1199,axiom,
    ! [VarCurr] :
      ( ~ v51505(VarCurr)
     => ( v52560(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1164,axiom,
    ! [VarCurr] :
      ( v51505(VarCurr)
     => ( v52560(VarCurr)
      <=> v52561(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_132,axiom,
    ! [VarCurr] :
      ( ( ~ v51507(VarCurr)
        & ~ v51509(VarCurr)
        & ~ v51523(VarCurr) )
     => ( v52561(VarCurr)
      <=> v52567(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_453,axiom,
    ! [VarCurr] :
      ( v51523(VarCurr)
     => ( v52561(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1198,axiom,
    ! [VarCurr] :
      ( v51509(VarCurr)
     => ( v52561(VarCurr)
      <=> v52565(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1163,axiom,
    ! [VarCurr] :
      ( v51507(VarCurr)
     => ( v52561(VarCurr)
      <=> v52562(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1197,axiom,
    ! [VarCurr] :
      ( ~ v51528(VarCurr)
     => ( v52567(VarCurr)
      <=> v52568(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1162,axiom,
    ! [VarCurr] :
      ( v51528(VarCurr)
     => ( v52567(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1196,axiom,
    ! [VarCurr] :
      ( ~ v51531(VarCurr)
     => ( v52568(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1161,axiom,
    ! [VarCurr] :
      ( v51531(VarCurr)
     => ( v52568(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1195,axiom,
    ! [VarCurr] :
      ( ~ v52566(VarCurr)
     => ( v52565(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1160,axiom,
    ! [VarCurr] :
      ( v52566(VarCurr)
     => ( v52565(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11020,axiom,
    ! [VarCurr] :
      ( v52566(VarCurr)
    <=> ( v51513(VarCurr)
        | v51518(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1194,axiom,
    ! [VarCurr] :
      ( ~ v52563(VarCurr)
     => ( v52562(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1159,axiom,
    ! [VarCurr] :
      ( v52563(VarCurr)
     => ( v52562(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_3372,axiom,
    ! [VarCurr] :
      ( v52564(VarCurr)
    <=> ( v51396(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3371,axiom,
    ! [VarCurr] :
      ( v52563(VarCurr)
    <=> ( v51396(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_452,axiom,
    ! [VarCurr] :
      ( ( ~ v47911(VarCurr)
        & ~ v47929(VarCurr) )
     => ( v46407(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1193,axiom,
    ! [VarCurr] :
      ( v47929(VarCurr)
     => ( v46407(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1158,axiom,
    ! [VarCurr] :
      ( v47911(VarCurr)
     => ( v46407(VarCurr)
      <=> v52555(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1192,axiom,
    ! [VarCurr] :
      ( ~ v47913(VarCurr)
     => ( v52555(VarCurr)
      <=> v52556(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1157,axiom,
    ! [VarCurr] :
      ( v47913(VarCurr)
     => ( v52555(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1191,axiom,
    ! [VarCurr] :
      ( ~ v47916(VarCurr)
     => ( v52556(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1156,axiom,
    ! [VarCurr] :
      ( v47916(VarCurr)
     => ( v52556(VarCurr)
      <=> $false ) ) ).

fof(addAssignment_19258,axiom,
    ! [VarCurr] :
      ( v46409(VarCurr)
    <=> v46411(VarCurr) ) ).

fof(addAssignment_19257,axiom,
    ! [VarCurr] :
      ( v46411(VarCurr)
    <=> v46413(VarCurr) ) ).

fof(addAssignment_19256,axiom,
    ! [VarCurr] :
      ( v46413(VarCurr)
    <=> v46415(VarCurr) ) ).

fof(addAssignment_19255,axiom,
    ! [VarCurr] :
      ( v46415(VarCurr)
    <=> v46417(VarCurr) ) ).

fof(addAssignment_19254,axiom,
    ! [VarCurr] :
      ( v46417(VarCurr)
    <=> v46419(VarCurr) ) ).

fof(addAssignment_19253,axiom,
    ! [VarCurr] :
      ( v46419(VarCurr)
    <=> v46421(VarCurr) ) ).

fof(addAssignment_19252,axiom,
    ! [VarCurr] :
      ( v46421(VarCurr)
    <=> v46423(VarCurr,bitIndex6) ) ).

fof(addAssignment_19251,axiom,
    ! [VarNext] :
      ( v46423(VarNext,bitIndex6)
    <=> v52547(VarNext,bitIndex6) ) ).

fof(addCaseBooleanConditionEqualRanges1_1009,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52548(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v52547(VarNext,B)
            <=> v46423(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1081,axiom,
    ! [VarNext] :
      ( v52548(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v52547(VarNext,B)
          <=> v51599(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11019,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52548(VarNext)
      <=> v52549(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11018,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52549(VarNext)
      <=> ( v52551(VarNext)
          & v51584(VarNext) ) ) ) ).

fof(writeUnaryOperator_4625,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52551(VarNext)
      <=> v51593(VarNext) ) ) ).

fof(addAssignment_19250,axiom,
    ! [VarCurr] :
      ( v46429(VarCurr,bitIndex6)
    <=> v51569(VarCurr,bitIndex6) ) ).

fof(addAssignment_19249,axiom,
    ! [VarCurr] :
      ( v51564(VarCurr,bitIndex6)
    <=> v51565(VarCurr,bitIndex6) ) ).

fof(addAssignment_19248,axiom,
    ! [VarNext] :
      ( v46423(VarNext,bitIndex7)
    <=> v52539(VarNext,bitIndex7) ) ).

fof(addCaseBooleanConditionEqualRanges1_1008,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52540(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v52539(VarNext,B)
            <=> v46423(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1080,axiom,
    ! [VarNext] :
      ( v52540(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v52539(VarNext,B)
          <=> v51599(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11017,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52540(VarNext)
      <=> v52541(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11016,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52541(VarNext)
      <=> ( v52543(VarNext)
          & v51584(VarNext) ) ) ) ).

fof(writeUnaryOperator_4624,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52543(VarNext)
      <=> v51593(VarNext) ) ) ).

fof(addAssignment_19247,axiom,
    ! [VarCurr] :
      ( v46429(VarCurr,bitIndex7)
    <=> v51569(VarCurr,bitIndex7) ) ).

fof(addAssignment_19246,axiom,
    ! [VarCurr] :
      ( v51564(VarCurr,bitIndex7)
    <=> v51565(VarCurr,bitIndex7) ) ).

fof(addAssignment_19245,axiom,
    ! [VarCurr] :
      ( v51552(VarCurr)
    <=> v51554(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11015,axiom,
    ! [VarCurr] :
      ( v51554(VarCurr)
    <=> ( v52537(VarCurr)
        | v52532(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11014,axiom,
    ! [VarCurr] :
      ( v52537(VarCurr)
    <=> ( v51556(VarCurr)
        | v52381(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1645,axiom,
    ! [VarCurr] :
      ( ~ v52534(VarCurr)
     => ( v52532(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1482,axiom,
    ! [VarCurr] :
      ( v52534(VarCurr)
     => ( v52532(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11013,axiom,
    ! [VarCurr] :
      ( v52534(VarCurr)
    <=> ( v52535(VarCurr)
        & v52026(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11012,axiom,
    ! [VarCurr] :
      ( v52535(VarCurr)
    <=> ( v52508(VarCurr)
        & v52025(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1644,axiom,
    ! [VarCurr] :
      ( ~ v52529(VarCurr)
     => ( v51556(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1481,axiom,
    ! [VarCurr] :
      ( v52529(VarCurr)
     => ( v51556(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11011,axiom,
    ! [VarCurr] :
      ( v52529(VarCurr)
    <=> ( v52530(VarCurr)
        & v52026(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11010,axiom,
    ! [VarCurr] :
      ( v52530(VarCurr)
    <=> ( v52422(VarCurr)
        & v52025(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_1007,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52517(VarNext)
       => ( v51984(VarNext,bitIndex0)
        <=> v51984(VarCurr,bitIndex0) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1079,axiom,
    ! [VarNext] :
      ( v52517(VarNext)
     => ( v51984(VarNext,bitIndex0)
      <=> v52525(VarNext) ) ) ).

fof(addAssignment_19244,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52525(VarNext)
      <=> v52523(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1643,axiom,
    ! [VarCurr] :
      ( ~ v52413(VarCurr)
     => ( v52523(VarCurr)
      <=> v51986(VarCurr,bitIndex0) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1480,axiom,
    ! [VarCurr] :
      ( v52413(VarCurr)
     => ( v52523(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11009,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52517(VarNext)
      <=> v52518(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11008,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52518(VarNext)
      <=> ( v52520(VarNext)
          & v51586(VarNext) ) ) ) ).

fof(writeUnaryOperator_4623,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52520(VarNext)
      <=> v52406(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1642,axiom,
    ! [VarCurr] :
      ( ~ v52499(VarCurr)
     => ( v51986(VarCurr,bitIndex0)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1479,axiom,
    ! [VarCurr] :
      ( v52499(VarCurr)
     => ( v51986(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11007,axiom,
    ! [VarCurr] :
      ( v52499(VarCurr)
    <=> ( v52500(VarCurr)
        | v52513(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11006,axiom,
    ! [VarCurr] :
      ( v52513(VarCurr)
    <=> ( v52514(VarCurr)
        & v52427(VarCurr) ) ) ).

fof(writeUnaryOperator_4622,axiom,
    ! [VarCurr] :
      ( ~ v52514(VarCurr)
    <=> v51988(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11005,axiom,
    ! [VarCurr] :
      ( v52500(VarCurr)
    <=> ( v52501(VarCurr)
        | v52512(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11004,axiom,
    ! [VarCurr] :
      ( v52512(VarCurr)
    <=> ( v52444(VarCurr)
        & v52399(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11003,axiom,
    ! [VarCurr] :
      ( v52501(VarCurr)
    <=> ( v52502(VarCurr)
        & v52026(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11002,axiom,
    ! [VarCurr] :
      ( v52502(VarCurr)
    <=> ( v52503(VarCurr)
        | v52511(VarCurr) ) ) ).

fof(writeUnaryOperator_4621,axiom,
    ! [VarCurr] :
      ( ~ v52511(VarCurr)
    <=> v52025(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11001,axiom,
    ! [VarCurr] :
      ( v52503(VarCurr)
    <=> ( v52504(VarCurr)
        & v52025(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11000,axiom,
    ! [VarCurr] :
      ( v52504(VarCurr)
    <=> ( v52505(VarCurr)
        | v52509(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10999,axiom,
    ! [VarCurr] :
      ( v52509(VarCurr)
    <=> ( v52510(VarCurr)
        & v52024(VarCurr) ) ) ).

fof(writeUnaryOperator_4620,axiom,
    ! [VarCurr] :
      ( ~ v52510(VarCurr)
    <=> v52004(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10998,axiom,
    ! [VarCurr] :
      ( v52505(VarCurr)
    <=> ( v52506(VarCurr)
        | v52508(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3370,axiom,
    ! [VarCurr] :
      ( v52508(VarCurr)
    <=> ( ( v51558(VarCurr,bitIndex1)
        <=> $false )
        & ( v51558(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10997,axiom,
    ! [VarCurr] :
      ( v52506(VarCurr)
    <=> ( v52507(VarCurr)
        & v52422(VarCurr) ) ) ).

fof(writeUnaryOperator_4619,axiom,
    ! [VarCurr] :
      ( ~ v52507(VarCurr)
    <=> v51988(VarCurr) ) ).

fof(writeUnaryOperator_4618,axiom,
    ! [VarCurr] :
      ( ~ v51988(VarCurr)
    <=> v52497(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_1914,axiom,
    ! [VarCurr] :
      ( v52497(VarCurr)
    <=> ( v52475(VarCurr)
        | v51990(VarCurr,bitIndex2) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_1006,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52483(VarNext)
       => ! [B] :
            ( range_2_0(B)
           => ( v51990(VarNext,B)
            <=> v51990(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1078,axiom,
    ! [VarNext] :
      ( v52483(VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v51990(VarNext,B)
          <=> v52491(VarNext,B) ) ) ) ).

fof(addAssignment_19243,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v52491(VarNext,B)
          <=> v52489(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1641,axiom,
    ! [VarCurr] :
      ( ~ v52492(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v52489(VarCurr,B)
          <=> v51992(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1478,axiom,
    ! [VarCurr] :
      ( v52492(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v52489(VarCurr,B)
          <=> b100(B) ) ) ) ).

fof(writeUnaryOperator_4617,axiom,
    ! [VarCurr] :
      ( ~ v52492(VarCurr)
    <=> v46427(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10996,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52483(VarNext)
      <=> v52484(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10995,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52484(VarNext)
      <=> ( v52485(VarNext)
          & v51586(VarNext) ) ) ) ).

fof(writeUnaryOperator_4616,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52485(VarNext)
      <=> v52406(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_451,axiom,
    ! [VarCurr] :
      ( ( ~ v52448(VarCurr)
        & ~ v52464(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v51992(VarCurr,B)
          <=> v51990(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1190,axiom,
    ! [VarCurr] :
      ( v52464(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51992(VarCurr,B)
          <=> v52466(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1155,axiom,
    ! [VarCurr] :
      ( v52448(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51992(VarCurr,B)
          <=> v52450(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10994,axiom,
    ! [VarCurr] :
      ( v52476(VarCurr)
    <=> ( v52477(VarCurr)
        | v52479(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3369,axiom,
    ! [VarCurr] :
      ( v52479(VarCurr)
    <=> ( ( v52480(VarCurr,bitIndex1)
        <=> $true )
        & ( v52480(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_19242,axiom,
    ! [VarCurr] :
      ( v52480(VarCurr,bitIndex0)
    <=> v52002(VarCurr) ) ).

fof(addAssignment_19241,axiom,
    ! [VarCurr] :
      ( v52480(VarCurr,bitIndex1)
    <=> v51994(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_3368,axiom,
    ! [VarCurr] :
      ( v52477(VarCurr)
    <=> ( ( v52478(VarCurr,bitIndex1)
        <=> $false )
        & ( v52478(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_19240,axiom,
    ! [VarCurr] :
      ( v52478(VarCurr,bitIndex0)
    <=> v52002(VarCurr) ) ).

fof(addAssignment_19239,axiom,
    ! [VarCurr] :
      ( v52478(VarCurr,bitIndex1)
    <=> v51994(VarCurr) ) ).

fof(addAssignment_19238,axiom,
    ! [VarCurr] :
      ( v52466(VarCurr,bitIndex0)
    <=> v52462(VarCurr) ) ).

fof(addAssignment_19237,axiom,
    ! [VarCurr] :
      ( v52466(VarCurr,bitIndex1)
    <=> v52473(VarCurr) ) ).

fof(addAssignment_19236,axiom,
    ! [VarCurr] :
      ( v52466(VarCurr,bitIndex2)
    <=> v52468(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10993,axiom,
    ! [VarCurr] :
      ( v52473(VarCurr)
    <=> ( v52474(VarCurr)
        & v52475(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1913,axiom,
    ! [VarCurr] :
      ( v52475(VarCurr)
    <=> ( v51990(VarCurr,bitIndex0)
        | v51990(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10992,axiom,
    ! [VarCurr] :
      ( v52474(VarCurr)
    <=> ( v52462(VarCurr)
        | v52457(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10991,axiom,
    ! [VarCurr] :
      ( v52468(VarCurr)
    <=> ( v52469(VarCurr)
        & v52472(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1912,axiom,
    ! [VarCurr] :
      ( v52472(VarCurr)
    <=> ( v51990(VarCurr,bitIndex2)
        | v52471(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10990,axiom,
    ! [VarCurr] :
      ( v52469(VarCurr)
    <=> ( v52459(VarCurr)
        | v52470(VarCurr) ) ) ).

fof(writeUnaryOperator_4615,axiom,
    ! [VarCurr] :
      ( ~ v52470(VarCurr)
    <=> v52471(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_1911,axiom,
    ! [VarCurr] :
      ( v52471(VarCurr)
    <=> ( v51990(VarCurr,bitIndex0)
        & v51990(VarCurr,bitIndex1) ) ) ).

fof(addBitVectorEqualityBitBlasted_3367,axiom,
    ! [VarCurr] :
      ( v52464(VarCurr)
    <=> ( ( v52465(VarCurr,bitIndex1)
        <=> $true )
        & ( v52465(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_19235,axiom,
    ! [VarCurr] :
      ( v52465(VarCurr,bitIndex0)
    <=> v52002(VarCurr) ) ).

fof(addAssignment_19234,axiom,
    ! [VarCurr] :
      ( v52465(VarCurr,bitIndex1)
    <=> v51994(VarCurr) ) ).

fof(addAssignment_19233,axiom,
    ! [VarCurr] :
      ( v52450(VarCurr,bitIndex0)
    <=> v52462(VarCurr) ) ).

fof(addAssignment_19232,axiom,
    ! [VarCurr] :
      ( v52450(VarCurr,bitIndex1)
    <=> v52460(VarCurr) ) ).

fof(addAssignment_19231,axiom,
    ! [VarCurr] :
      ( v52450(VarCurr,bitIndex2)
    <=> v52452(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10989,axiom,
    ! [VarCurr] :
      ( v52460(VarCurr)
    <=> ( v52461(VarCurr)
        & v52463(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10988,axiom,
    ! [VarCurr] :
      ( v52463(VarCurr)
    <=> ( v51990(VarCurr,bitIndex0)
        | v52457(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1910,axiom,
    ! [VarCurr] :
      ( v52461(VarCurr)
    <=> ( v52462(VarCurr)
        | v51990(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_4614,axiom,
    ! [VarCurr] :
      ( ~ v52462(VarCurr)
    <=> v51990(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10987,axiom,
    ! [VarCurr] :
      ( v52452(VarCurr)
    <=> ( v52453(VarCurr)
        & v52458(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10986,axiom,
    ! [VarCurr] :
      ( v52458(VarCurr)
    <=> ( v52455(VarCurr)
        | v52459(VarCurr) ) ) ).

fof(writeUnaryOperator_4613,axiom,
    ! [VarCurr] :
      ( ~ v52459(VarCurr)
    <=> v51990(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges_1909,axiom,
    ! [VarCurr] :
      ( v52453(VarCurr)
    <=> ( v52454(VarCurr)
        | v51990(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_4612,axiom,
    ! [VarCurr] :
      ( ~ v52454(VarCurr)
    <=> v52455(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_1908,axiom,
    ! [VarCurr] :
      ( v52455(VarCurr)
    <=> ( v51990(VarCurr,bitIndex1)
        | v52456(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10985,axiom,
    ! [VarCurr] :
      ( v52456(VarCurr)
    <=> ( v51990(VarCurr,bitIndex0)
        & v52457(VarCurr) ) ) ).

fof(writeUnaryOperator_4611,axiom,
    ! [VarCurr] :
      ( ~ v52457(VarCurr)
    <=> v51990(VarCurr,bitIndex1) ) ).

fof(addBitVectorEqualityBitBlasted_3366,axiom,
    ! [VarCurr] :
      ( v52448(VarCurr)
    <=> ( ( v52449(VarCurr,bitIndex1)
        <=> $false )
        & ( v52449(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_19230,axiom,
    ! [VarCurr] :
      ( v52449(VarCurr,bitIndex0)
    <=> v52002(VarCurr) ) ).

fof(addAssignment_19229,axiom,
    ! [VarCurr] :
      ( v52449(VarCurr,bitIndex1)
    <=> v51994(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1640,axiom,
    ! [VarCurr] :
      ( ~ v52437(VarCurr)
     => ( v52002(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1477,axiom,
    ! [VarCurr] :
      ( v52437(VarCurr)
     => ( v52002(VarCurr)
      <=> v52441(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_450,axiom,
    ! [VarCurr] :
      ( ( ~ v52439(VarCurr)
        & ~ v52399(VarCurr) )
     => ( v52441(VarCurr)
      <=> v52446(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1189,axiom,
    ! [VarCurr] :
      ( v52399(VarCurr)
     => ( v52441(VarCurr)
      <=> v52443(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1154,axiom,
    ! [VarCurr] :
      ( v52439(VarCurr)
     => ( v52441(VarCurr)
      <=> v52442(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1639,axiom,
    ! [VarCurr] :
      ( ~ v51988(VarCurr)
     => ( v52446(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1476,axiom,
    ! [VarCurr] :
      ( v51988(VarCurr)
     => ( v52446(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_449,axiom,
    ! [VarCurr] :
      ( ( ~ v52394(VarCurr)
        & ~ v52444(VarCurr) )
     => ( v52443(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1188,axiom,
    ! [VarCurr] :
      ( v52444(VarCurr)
     => ( v52443(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1153,axiom,
    ! [VarCurr] :
      ( v52394(VarCurr)
     => ( v52443(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3365,axiom,
    ! [VarCurr] :
      ( v52444(VarCurr)
    <=> ( ( v52445(VarCurr,bitIndex1)
        <=> $true )
        & ( v52445(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_19228,axiom,
    ! [VarCurr] :
      ( v52445(VarCurr,bitIndex0)
    <=> v51988(VarCurr) ) ).

fof(addAssignment_19227,axiom,
    ! [VarCurr] :
      ( v52445(VarCurr,bitIndex1)
    <=> v52381(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1638,axiom,
    ! [VarCurr] :
      ( ~ v51988(VarCurr)
     => ( v52442(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1475,axiom,
    ! [VarCurr] :
      ( v51988(VarCurr)
     => ( v52442(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10984,axiom,
    ! [VarCurr] :
      ( v52437(VarCurr)
    <=> ( v52438(VarCurr)
        | v52427(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10983,axiom,
    ! [VarCurr] :
      ( v52438(VarCurr)
    <=> ( v52439(VarCurr)
        | v52399(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10982,axiom,
    ! [VarCurr] :
      ( v52439(VarCurr)
    <=> ( v52440(VarCurr)
        & v52026(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10981,axiom,
    ! [VarCurr] :
      ( v52440(VarCurr)
    <=> ( v52422(VarCurr)
        & v52025(VarCurr) ) ) ).

fof(addAssignment_19226,axiom,
    ! [VarNext] :
      ( v51984(VarNext,bitIndex1)
    <=> v52429(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionShiftedRanges1_99,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52430(VarNext)
       => ( ( v52429(VarNext,bitIndex1)
          <=> v51984(VarCurr,bitIndex2) )
          & ( v52429(VarNext,bitIndex0)
          <=> v51984(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1077,axiom,
    ! [VarNext] :
      ( v52430(VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v52429(VarNext,B)
          <=> v52412(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10980,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52430(VarNext)
      <=> v52431(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10979,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52431(VarNext)
      <=> ( v52433(VarNext)
          & v51586(VarNext) ) ) ) ).

fof(writeUnaryOperator_4610,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52433(VarNext)
      <=> v52406(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_486,axiom,
    ! [VarCurr] :
      ( ~ v52417(VarCurr)
     => ( v51986(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_649,axiom,
    ! [VarCurr] :
      ( v52417(VarCurr)
     => ( v51986(VarCurr,bitIndex1)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10978,axiom,
    ! [VarCurr] :
      ( v52417(VarCurr)
    <=> ( v52418(VarCurr)
        | v52426(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10977,axiom,
    ! [VarCurr] :
      ( v52426(VarCurr)
    <=> ( v51988(VarCurr)
        & v52427(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3364,axiom,
    ! [VarCurr] :
      ( v52427(VarCurr)
    <=> ( $true
      <=> v51984(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10976,axiom,
    ! [VarCurr] :
      ( v52418(VarCurr)
    <=> ( v52419(VarCurr)
        | v52423(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10975,axiom,
    ! [VarCurr] :
      ( v52423(VarCurr)
    <=> ( v52424(VarCurr)
        & v52399(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3363,axiom,
    ! [VarCurr] :
      ( v52424(VarCurr)
    <=> ( ( v52425(VarCurr,bitIndex1)
        <=> $true )
        & ( v52425(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_19225,axiom,
    ! [VarCurr] :
      ( v52425(VarCurr,bitIndex0)
    <=> v51988(VarCurr) ) ).

fof(addAssignment_19224,axiom,
    ! [VarCurr] :
      ( v52425(VarCurr,bitIndex1)
    <=> v52381(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10974,axiom,
    ! [VarCurr] :
      ( v52419(VarCurr)
    <=> ( v52420(VarCurr)
        & v52026(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10973,axiom,
    ! [VarCurr] :
      ( v52420(VarCurr)
    <=> ( v52421(VarCurr)
        & v52025(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10972,axiom,
    ! [VarCurr] :
      ( v52421(VarCurr)
    <=> ( v51988(VarCurr)
        & v52422(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3362,axiom,
    ! [VarCurr] :
      ( v52422(VarCurr)
    <=> ( ( v51558(VarCurr,bitIndex1)
        <=> $false )
        & ( v51558(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_19223,axiom,
    ! [VarNext] :
      ( v51984(VarNext,bitIndex2)
    <=> v52401(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionShiftedRanges1_98,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52402(VarNext)
       => ( ( v52401(VarNext,bitIndex1)
          <=> v51984(VarCurr,bitIndex2) )
          & ( v52401(VarNext,bitIndex0)
          <=> v51984(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1076,axiom,
    ! [VarNext] :
      ( v52402(VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v52401(VarNext,B)
          <=> v52412(VarNext,B) ) ) ) ).

fof(addAssignment_19222,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v52412(VarNext,B)
          <=> v52410(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_485,axiom,
    ! [VarCurr] :
      ( ~ v52413(VarCurr)
     => ( ( v52410(VarCurr,bitIndex1)
        <=> v51986(VarCurr,bitIndex2) )
        & ( v52410(VarCurr,bitIndex0)
        <=> v51986(VarCurr,bitIndex1) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1474,axiom,
    ! [VarCurr] :
      ( v52413(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v52410(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_4609,axiom,
    ! [VarCurr] :
      ( ~ v52413(VarCurr)
    <=> v46427(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10971,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52402(VarNext)
      <=> v52403(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10970,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52403(VarNext)
      <=> ( v52404(VarNext)
          & v51586(VarNext) ) ) ) ).

fof(writeUnaryOperator_4608,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52404(VarNext)
      <=> v52406(VarNext) ) ) ).

fof(addAssignment_19221,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52406(VarNext)
      <=> v51586(VarCurr) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_484,axiom,
    ! [VarCurr] :
      ( ~ v52389(VarCurr)
     => ( v51986(VarCurr,bitIndex2)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_648,axiom,
    ! [VarCurr] :
      ( v52389(VarCurr)
     => ( v51986(VarCurr,bitIndex2)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10969,axiom,
    ! [VarCurr] :
      ( v52389(VarCurr)
    <=> ( v52390(VarCurr)
        | v52393(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10968,axiom,
    ! [VarCurr] :
      ( v52393(VarCurr)
    <=> ( v52394(VarCurr)
        & v52399(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3361,axiom,
    ! [VarCurr] :
      ( v52399(VarCurr)
    <=> ( $true
      <=> v51984(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10967,axiom,
    ! [VarCurr] :
      ( v52394(VarCurr)
    <=> ( v52395(VarCurr)
        | v52397(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3360,axiom,
    ! [VarCurr] :
      ( v52397(VarCurr)
    <=> ( ( v52398(VarCurr,bitIndex1)
        <=> $false )
        & ( v52398(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_19220,axiom,
    ! [VarCurr] :
      ( v52398(VarCurr,bitIndex0)
    <=> v51988(VarCurr) ) ).

fof(addAssignment_19219,axiom,
    ! [VarCurr] :
      ( v52398(VarCurr,bitIndex1)
    <=> v52381(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_3359,axiom,
    ! [VarCurr] :
      ( v52395(VarCurr)
    <=> ( ( v52396(VarCurr,bitIndex1)
        <=> $false )
        & ( v52396(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_19218,axiom,
    ! [VarCurr] :
      ( v52396(VarCurr,bitIndex0)
    <=> v51988(VarCurr) ) ).

fof(addAssignment_19217,axiom,
    ! [VarCurr] :
      ( v52396(VarCurr,bitIndex1)
    <=> v52381(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10966,axiom,
    ! [VarCurr] :
      ( v52390(VarCurr)
    <=> ( v52391(VarCurr)
        & v52026(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10965,axiom,
    ! [VarCurr] :
      ( v52391(VarCurr)
    <=> ( v52392(VarCurr)
        & v52025(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10964,axiom,
    ! [VarCurr] :
      ( v52392(VarCurr)
    <=> ( v52004(VarCurr)
        & v52024(VarCurr) ) ) ).

fof(addAssignment_19216,axiom,
    ! [VarCurr] :
      ( v52381(VarCurr)
    <=> v52383(VarCurr) ) ).

fof(addAssignment_19215,axiom,
    ! [VarCurr] :
      ( v52383(VarCurr)
    <=> v52385(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10963,axiom,
    ! [VarCurr] :
      ( v52385(VarCurr)
    <=> ( v52387(VarCurr)
        & v52095(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1907,axiom,
    ! [VarCurr] :
      ( v52387(VarCurr)
    <=> ( v52010(VarCurr,bitIndex2)
        | v52010(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_19214,axiom,
    ! [VarCurr] :
      ( v52004(VarCurr)
    <=> v52006(VarCurr) ) ).

fof(addAssignment_19213,axiom,
    ! [VarCurr] :
      ( v52006(VarCurr)
    <=> v52008(VarCurr) ) ).

fof(addAssignment_19212,axiom,
    ! [VarCurr] :
      ( v52008(VarCurr)
    <=> v52010(VarCurr,bitIndex0) ) ).

fof(addCaseBooleanConditionEqualRanges1_1005,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52369(VarNext)
       => ( v52010(VarNext,bitIndex0)
        <=> v52010(VarCurr,bitIndex0) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1075,axiom,
    ! [VarNext] :
      ( v52369(VarNext)
     => ( v52010(VarNext,bitIndex0)
      <=> v52377(VarNext) ) ) ).

fof(addAssignment_19211,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52377(VarNext)
      <=> v52375(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1637,axiom,
    ! [VarCurr] :
      ( ~ v52153(VarCurr)
     => ( v52375(VarCurr)
      <=> v52014(VarCurr,bitIndex0) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1473,axiom,
    ! [VarCurr] :
      ( v52153(VarCurr)
     => ( v52375(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10962,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52369(VarNext)
      <=> v52370(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10961,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52370(VarNext)
      <=> ( v52372(VarNext)
          & v52139(VarNext) ) ) ) ).

fof(writeUnaryOperator_4607,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52372(VarNext)
      <=> v52146(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1636,axiom,
    ! [VarCurr] :
      ( ~ v52362(VarCurr)
     => ( v52014(VarCurr,bitIndex0)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1472,axiom,
    ! [VarCurr] :
      ( v52362(VarCurr)
     => ( v52014(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10960,axiom,
    ! [VarCurr] :
      ( v52362(VarCurr)
    <=> ( v52363(VarCurr)
        | v52366(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10959,axiom,
    ! [VarCurr] :
      ( v52366(VarCurr)
    <=> ( v52095(VarCurr)
        & v52177(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10958,axiom,
    ! [VarCurr] :
      ( v52363(VarCurr)
    <=> ( v52364(VarCurr)
        | v52365(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10957,axiom,
    ! [VarCurr] :
      ( v52365(VarCurr)
    <=> ( v52095(VarCurr)
        & v52161(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10956,axiom,
    ! [VarCurr] :
      ( v52364(VarCurr)
    <=> ( v52192(VarCurr)
        & v52134(VarCurr) ) ) ).

fof(addAssignment_19210,axiom,
    ! [VarCurr] :
      ( v52095(VarCurr)
    <=> v52097(VarCurr) ) ).

fof(addAssignment_19209,axiom,
    ! [VarCurr] :
      ( v52097(VarCurr)
    <=> v52099(VarCurr) ) ).

fof(addAssignment_19208,axiom,
    ! [VarCurr] :
      ( v52099(VarCurr)
    <=> v52101(VarCurr) ) ).

fof(addAssignment_19207,axiom,
    ! [VarCurr] :
      ( v52101(VarCurr)
    <=> v52103(VarCurr) ) ).

fof(addAssignment_19206,axiom,
    ! [VarCurr] :
      ( v52103(VarCurr)
    <=> v52105(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_1004,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52349(VarNext)
       => ( v52105(VarNext)
        <=> v52105(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1074,axiom,
    ! [VarNext] :
      ( v52349(VarNext)
     => ( v52105(VarNext)
      <=> v52357(VarNext) ) ) ).

fof(addAssignment_19205,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52357(VarNext)
      <=> v52355(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1635,axiom,
    ! [VarCurr] :
      ( ~ v52358(VarCurr)
     => ( v52355(VarCurr)
      <=> v52109(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1471,axiom,
    ! [VarCurr] :
      ( v52358(VarCurr)
     => ( v52355(VarCurr)
      <=> $false ) ) ).

fof(writeUnaryOperator_4606,axiom,
    ! [VarCurr] :
      ( ~ v52358(VarCurr)
    <=> v52107(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10955,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52349(VarNext)
      <=> v52350(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10954,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52350(VarNext)
      <=> ( v52351(VarNext)
          & v52251(VarNext) ) ) ) ).

fof(writeUnaryOperator_4605,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52351(VarNext)
      <=> v52258(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1634,axiom,
    ! [VarCurr] :
      ( ~ v52308(VarCurr)
     => ( v52109(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1470,axiom,
    ! [VarCurr] :
      ( v52308(VarCurr)
     => ( v52109(VarCurr)
      <=> v52332(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1187,axiom,
    ! [VarCurr] :
      ( ~ v52269(VarCurr)
     => ( v52332(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1152,axiom,
    ! [VarCurr] :
      ( v52269(VarCurr)
     => ( v52332(VarCurr)
      <=> v52333(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10953,axiom,
    ! [VarCurr] :
      ( v52339(VarCurr)
    <=> ( v52341(VarCurr)
        | v52321(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10952,axiom,
    ! [VarCurr] :
      ( v52341(VarCurr)
    <=> ( v52342(VarCurr)
        | v52320(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10951,axiom,
    ! [VarCurr] :
      ( v52342(VarCurr)
    <=> ( v52343(VarCurr)
        | v52319(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10950,axiom,
    ! [VarCurr] :
      ( v52343(VarCurr)
    <=> ( v52344(VarCurr)
        | v52289(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10949,axiom,
    ! [VarCurr] :
      ( v52344(VarCurr)
    <=> ( v52345(VarCurr)
        | v52288(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10948,axiom,
    ! [VarCurr] :
      ( v52345(VarCurr)
    <=> ( v52346(VarCurr)
        | v52287(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10947,axiom,
    ! [VarCurr] :
      ( v52346(VarCurr)
    <=> ( v52272(VarCurr)
        | v52286(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10946,axiom,
    ! [VarCurr] :
      ( v52272(VarCurr)
    <=> ( v52273(VarCurr)
        | v52278(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1633,axiom,
    ! [VarCurr] :
      ( ~ v52115(VarCurr)
     => ( v52333(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1469,axiom,
    ! [VarCurr] :
      ( v52115(VarCurr)
     => ( v52333(VarCurr)
      <=> v52334(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1632,axiom,
    ! [VarCurr] :
      ( ~ v52335(VarCurr)
     => ( v52334(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1468,axiom,
    ! [VarCurr] :
      ( v52335(VarCurr)
     => ( v52334(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10945,axiom,
    ! [VarCurr] :
      ( v52335(VarCurr)
    <=> ( v52336(VarCurr)
        & v52249(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10944,axiom,
    ! [VarCurr] :
      ( v52336(VarCurr)
    <=> ( v52337(VarCurr)
        | v52338(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3358,axiom,
    ! [VarCurr] :
      ( v52338(VarCurr)
    <=> ( ( v52211(VarCurr,bitIndex3)
        <=> $true )
        & ( v52211(VarCurr,bitIndex2)
        <=> $true )
        & ( v52211(VarCurr,bitIndex1)
        <=> $false )
        & ( v52211(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3357,axiom,
    ! [VarCurr] :
      ( v52337(VarCurr)
    <=> ( ( v52211(VarCurr,bitIndex3)
        <=> $false )
        & ( v52211(VarCurr,bitIndex2)
        <=> $true )
        & ( v52211(VarCurr,bitIndex1)
        <=> $false )
        & ( v52211(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10943,axiom,
    ! [VarCurr] :
      ( v52308(VarCurr)
    <=> ( v52309(VarCurr)
        | v52321(VarCurr) ) ) ).

fof(writeUnaryOperator_4604,axiom,
    ! [VarCurr] :
      ( ~ v52321(VarCurr)
    <=> v52322(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10942,axiom,
    ! [VarCurr] :
      ( v52322(VarCurr)
    <=> ( v52323(VarCurr)
        | v52290(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10941,axiom,
    ! [VarCurr] :
      ( v52323(VarCurr)
    <=> ( v52324(VarCurr)
        | v52289(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10940,axiom,
    ! [VarCurr] :
      ( v52324(VarCurr)
    <=> ( v52325(VarCurr)
        | v52288(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10939,axiom,
    ! [VarCurr] :
      ( v52325(VarCurr)
    <=> ( v52326(VarCurr)
        | v52287(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10938,axiom,
    ! [VarCurr] :
      ( v52326(VarCurr)
    <=> ( v52327(VarCurr)
        | v52286(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10937,axiom,
    ! [VarCurr] :
      ( v52327(VarCurr)
    <=> ( v52328(VarCurr)
        | v52279(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10936,axiom,
    ! [VarCurr] :
      ( v52328(VarCurr)
    <=> ( v52329(VarCurr)
        | v52278(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10935,axiom,
    ! [VarCurr] :
      ( v52329(VarCurr)
    <=> ( v52330(VarCurr)
        | v52277(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10934,axiom,
    ! [VarCurr] :
      ( v52330(VarCurr)
    <=> ( v52331(VarCurr)
        | v52276(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10933,axiom,
    ! [VarCurr] :
      ( v52331(VarCurr)
    <=> ( v52269(VarCurr)
        | v52275(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10932,axiom,
    ! [VarCurr] :
      ( v52309(VarCurr)
    <=> ( v52310(VarCurr)
        | v52320(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10931,axiom,
    ! [VarCurr] :
      ( v52320(VarCurr)
    <=> ( v52292(VarCurr)
        & v52290(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10930,axiom,
    ! [VarCurr] :
      ( v52310(VarCurr)
    <=> ( v52311(VarCurr)
        | v52289(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10929,axiom,
    ! [VarCurr] :
      ( v52311(VarCurr)
    <=> ( v52312(VarCurr)
        | v52288(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10928,axiom,
    ! [VarCurr] :
      ( v52312(VarCurr)
    <=> ( v52313(VarCurr)
        | v52287(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10927,axiom,
    ! [VarCurr] :
      ( v52313(VarCurr)
    <=> ( v52314(VarCurr)
        | v52286(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10926,axiom,
    ! [VarCurr] :
      ( v52314(VarCurr)
    <=> ( v52315(VarCurr)
        | v52319(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10925,axiom,
    ! [VarCurr] :
      ( v52319(VarCurr)
    <=> ( v52281(VarCurr)
        & v52279(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10924,axiom,
    ! [VarCurr] :
      ( v52315(VarCurr)
    <=> ( v52316(VarCurr)
        | v52278(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10923,axiom,
    ! [VarCurr] :
      ( v52316(VarCurr)
    <=> ( v52317(VarCurr)
        | v52277(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10922,axiom,
    ! [VarCurr] :
      ( v52317(VarCurr)
    <=> ( v52318(VarCurr)
        | v52276(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10921,axiom,
    ! [VarCurr] :
      ( v52318(VarCurr)
    <=> ( v52269(VarCurr)
        | v52275(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_1003,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52295(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v52111(VarNext,B)
            <=> v52111(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1073,axiom,
    ! [VarNext] :
      ( v52295(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v52111(VarNext,B)
          <=> v52303(VarNext,B) ) ) ) ).

fof(addAssignment_19204,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v52303(VarNext,B)
          <=> v52301(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1631,axiom,
    ! [VarCurr] :
      ( ~ v52304(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v52301(VarCurr,B)
          <=> v52113(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1467,axiom,
    ! [VarCurr] :
      ( v52304(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v52301(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_4603,axiom,
    ! [VarCurr] :
      ( ~ v52304(VarCurr)
    <=> v52107(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10920,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52295(VarNext)
      <=> v52296(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10919,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52296(VarNext)
      <=> ( v52297(VarNext)
          & v52251(VarNext) ) ) ) ).

fof(writeUnaryOperator_4602,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52297(VarNext)
      <=> v52258(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges5_28,axiom,
    ! [VarCurr] :
      ( ( ~ v52269(VarCurr)
        & ~ v52271(VarCurr)
        & ~ v52279(VarCurr)
        & ~ v52282(VarCurr)
        & ~ v52290(VarCurr) )
     => ! [B] :
          ( range_3_0(B)
         => ( v52113(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_31,axiom,
    ! [VarCurr] :
      ( v52290(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v52113(VarCurr,B)
          <=> v52291(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_131,axiom,
    ! [VarCurr] :
      ( v52282(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v52113(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_448,axiom,
    ! [VarCurr] :
      ( v52279(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v52113(VarCurr,B)
          <=> v52280(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1186,axiom,
    ! [VarCurr] :
      ( v52271(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v52113(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1151,axiom,
    ! [VarCurr] :
      ( v52269(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v52113(VarCurr,B)
          <=> v52270(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1630,axiom,
    ! [VarCurr] :
      ( ~ v52292(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v52291(VarCurr,B)
          <=> $false ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1466,axiom,
    ! [VarCurr] :
      ( v52292(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v52291(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_4601,axiom,
    ! [VarCurr] :
      ( ~ v52292(VarCurr)
    <=> v52247(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_3356,axiom,
    ! [VarCurr] :
      ( v52290(VarCurr)
    <=> ( ( v52111(VarCurr,bitIndex3)
        <=> $true )
        & ( v52111(VarCurr,bitIndex2)
        <=> $true )
        & ( v52111(VarCurr,bitIndex1)
        <=> $false )
        & ( v52111(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10918,axiom,
    ! [VarCurr] :
      ( v52282(VarCurr)
    <=> ( v52284(VarCurr)
        | v52289(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3355,axiom,
    ! [VarCurr] :
      ( v52289(VarCurr)
    <=> ( ( v52111(VarCurr,bitIndex3)
        <=> $true )
        & ( v52111(VarCurr,bitIndex2)
        <=> $true )
        & ( v52111(VarCurr,bitIndex1)
        <=> $false )
        & ( v52111(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10917,axiom,
    ! [VarCurr] :
      ( v52284(VarCurr)
    <=> ( v52285(VarCurr)
        | v52288(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3354,axiom,
    ! [VarCurr] :
      ( v52288(VarCurr)
    <=> ( ( v52111(VarCurr,bitIndex3)
        <=> $true )
        & ( v52111(VarCurr,bitIndex2)
        <=> $false )
        & ( v52111(VarCurr,bitIndex1)
        <=> $true )
        & ( v52111(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10916,axiom,
    ! [VarCurr] :
      ( v52285(VarCurr)
    <=> ( v52286(VarCurr)
        | v52287(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3353,axiom,
    ! [VarCurr] :
      ( v52287(VarCurr)
    <=> ( ( v52111(VarCurr,bitIndex3)
        <=> $true )
        & ( v52111(VarCurr,bitIndex2)
        <=> $false )
        & ( v52111(VarCurr,bitIndex1)
        <=> $true )
        & ( v52111(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3352,axiom,
    ! [VarCurr] :
      ( v52286(VarCurr)
    <=> ( ( v52111(VarCurr,bitIndex3)
        <=> $true )
        & ( v52111(VarCurr,bitIndex2)
        <=> $false )
        & ( v52111(VarCurr,bitIndex1)
        <=> $false )
        & ( v52111(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1629,axiom,
    ! [VarCurr] :
      ( ~ v52281(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v52280(VarCurr,B)
          <=> $false ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1465,axiom,
    ! [VarCurr] :
      ( v52281(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v52280(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_4600,axiom,
    ! [VarCurr] :
      ( ~ v52281(VarCurr)
    <=> v52247(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_3351,axiom,
    ! [VarCurr] :
      ( v52279(VarCurr)
    <=> ( ( v52111(VarCurr,bitIndex3)
        <=> $false )
        & ( v52111(VarCurr,bitIndex2)
        <=> $true )
        & ( v52111(VarCurr,bitIndex1)
        <=> $false )
        & ( v52111(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10915,axiom,
    ! [VarCurr] :
      ( v52271(VarCurr)
    <=> ( v52273(VarCurr)
        | v52278(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3350,axiom,
    ! [VarCurr] :
      ( v52278(VarCurr)
    <=> ( ( v52111(VarCurr,bitIndex3)
        <=> $false )
        & ( v52111(VarCurr,bitIndex2)
        <=> $true )
        & ( v52111(VarCurr,bitIndex1)
        <=> $false )
        & ( v52111(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10914,axiom,
    ! [VarCurr] :
      ( v52273(VarCurr)
    <=> ( v52274(VarCurr)
        | v52277(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3349,axiom,
    ! [VarCurr] :
      ( v52277(VarCurr)
    <=> ( ( v52111(VarCurr,bitIndex3)
        <=> $false )
        & ( v52111(VarCurr,bitIndex2)
        <=> $false )
        & ( v52111(VarCurr,bitIndex1)
        <=> $true )
        & ( v52111(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10913,axiom,
    ! [VarCurr] :
      ( v52274(VarCurr)
    <=> ( v52275(VarCurr)
        | v52276(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3348,axiom,
    ! [VarCurr] :
      ( v52276(VarCurr)
    <=> ( ( v52111(VarCurr,bitIndex3)
        <=> $false )
        & ( v52111(VarCurr,bitIndex2)
        <=> $false )
        & ( v52111(VarCurr,bitIndex1)
        <=> $true )
        & ( v52111(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3347,axiom,
    ! [VarCurr] :
      ( v52275(VarCurr)
    <=> ( ( v52111(VarCurr,bitIndex3)
        <=> $false )
        & ( v52111(VarCurr,bitIndex2)
        <=> $false )
        & ( v52111(VarCurr,bitIndex1)
        <=> $false )
        & ( v52111(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1628,axiom,
    ! [VarCurr] :
      ( ~ v52115(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v52270(VarCurr,B)
          <=> $false ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1464,axiom,
    ! [VarCurr] :
      ( v52115(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v52270(VarCurr,B)
          <=> v52211(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3346,axiom,
    ! [VarCurr] :
      ( v52269(VarCurr)
    <=> ( ( v52111(VarCurr,bitIndex3)
        <=> $false )
        & ( v52111(VarCurr,bitIndex2)
        <=> $false )
        & ( v52111(VarCurr,bitIndex1)
        <=> $false )
        & ( v52111(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_1002,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52254(VarNext)
       => ( v52247(VarNext)
        <=> v52247(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1072,axiom,
    ! [VarNext] :
      ( v52254(VarNext)
     => ( v52247(VarNext)
      <=> v52264(VarNext) ) ) ).

fof(addAssignment_19203,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52264(VarNext)
      <=> v52262(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1627,axiom,
    ! [VarCurr] :
      ( ~ v52265(VarCurr)
     => ( v52262(VarCurr)
      <=> v52249(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1463,axiom,
    ! [VarCurr] :
      ( v52265(VarCurr)
     => ( v52262(VarCurr)
      <=> $false ) ) ).

fof(writeUnaryOperator_4599,axiom,
    ! [VarCurr] :
      ( ~ v52265(VarCurr)
    <=> v52107(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10912,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52254(VarNext)
      <=> v52255(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10911,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52255(VarNext)
      <=> ( v52256(VarNext)
          & v52251(VarNext) ) ) ) ).

fof(writeUnaryOperator_4598,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52256(VarNext)
      <=> v52258(VarNext) ) ) ).

fof(addAssignment_19202,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52258(VarNext)
      <=> v52251(VarCurr) ) ) ).

fof(addAssignment_19201,axiom,
    ! [VarCurr] :
      ( v52251(VarCurr)
    <=> v26723(VarCurr) ) ).

fof(addAssignment_19200,axiom,
    ! [VarCurr] :
      ( v52249(VarCurr)
    <=> $false ) ).

fof(addAssignment_19199,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v52211(VarCurr,B)
      <=> v52213(VarCurr,B) ) ) ).

fof(addAssignment_19198,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v52213(VarCurr,B)
      <=> v52215(VarCurr,B) ) ) ).

fof(addAssignment_19197,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v52215(VarCurr,B)
      <=> v52217(VarCurr,B) ) ) ).

fof(addAssignment_19196,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v52217(VarCurr,B)
      <=> v52219(VarCurr,B) ) ) ).

fof(addAssignment_19195,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v52219(VarCurr,B)
      <=> v52221(VarCurr,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_1001,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52235(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v52221(VarNext,B)
            <=> v52221(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1071,axiom,
    ! [VarNext] :
      ( v52235(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v52221(VarNext,B)
          <=> v52243(VarNext,B) ) ) ) ).

fof(addAssignment_19194,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v52243(VarNext,B)
          <=> v52241(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1626,axiom,
    ! [VarCurr] :
      ( ~ v52153(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v52241(VarCurr,B)
          <=> v52223(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1462,axiom,
    ! [VarCurr] :
      ( v52153(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v52241(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10910,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52235(VarNext)
      <=> v52236(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10909,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52236(VarNext)
      <=> ( v52238(VarNext)
          & v52139(VarNext) ) ) ) ).

fof(writeUnaryOperator_4597,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52238(VarNext)
      <=> v52146(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1625,axiom,
    ! [VarCurr] :
      ( ~ v52225(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v52223(VarCurr,B)
          <=> $false ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1461,axiom,
    ! [VarCurr] :
      ( v52225(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v52223(VarCurr,B)
          <=> v52228(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_130,axiom,
    ! [VarCurr] :
      ( ( ~ v52134(VarCurr)
        & ~ v52137(VarCurr)
        & ~ v52161(VarCurr) )
     => ! [B] :
          ( range_3_0(B)
         => ( v52228(VarCurr,B)
          <=> v52232(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_447,axiom,
    ! [VarCurr] :
      ( v52161(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v52228(VarCurr,B)
          <=> v52231(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1185,axiom,
    ! [VarCurr] :
      ( v52137(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v52228(VarCurr,B)
          <=> v52230(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1150,axiom,
    ! [VarCurr] :
      ( v52134(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v52228(VarCurr,B)
          <=> v52229(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1624,axiom,
    ! [VarCurr] :
      ( ~ v52095(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v52232(VarCurr,B)
          <=> b0011(B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1460,axiom,
    ! [VarCurr] :
      ( v52095(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v52232(VarCurr,B)
          <=> $false ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1623,axiom,
    ! [VarCurr] :
      ( ~ v52095(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v52231(VarCurr,B)
          <=> b0100(B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1459,axiom,
    ! [VarCurr] :
      ( v52095(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v52231(VarCurr,B)
          <=> $false ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1622,axiom,
    ! [VarCurr] :
      ( ~ v52095(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v52230(VarCurr,B)
          <=> b0001(B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1458,axiom,
    ! [VarCurr] :
      ( v52095(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v52230(VarCurr,B)
          <=> b0100(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_446,axiom,
    ! [VarCurr] :
      ( ( ~ v52192(VarCurr)
        & ~ v52131(VarCurr) )
     => ! [B] :
          ( range_3_0(B)
         => ( v52229(VarCurr,B)
          <=> b0011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1184,axiom,
    ! [VarCurr] :
      ( v52131(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v52229(VarCurr,B)
          <=> b0001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1149,axiom,
    ! [VarCurr] :
      ( v52192(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v52229(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10908,axiom,
    ! [VarCurr] :
      ( v52225(VarCurr)
    <=> ( v52226(VarCurr)
        | v52177(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10907,axiom,
    ! [VarCurr] :
      ( v52226(VarCurr)
    <=> ( v52227(VarCurr)
        | v52161(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10906,axiom,
    ! [VarCurr] :
      ( v52227(VarCurr)
    <=> ( v52134(VarCurr)
        | v52137(VarCurr) ) ) ).

fof(addAssignment_19193,axiom,
    ! [VarCurr] :
      ( v52115(VarCurr)
    <=> v52117(VarCurr) ) ).

fof(addAssignment_19192,axiom,
    ! [VarCurr] :
      ( v52117(VarCurr)
    <=> v52119(VarCurr) ) ).

fof(addAssignment_19191,axiom,
    ! [VarCurr] :
      ( v52119(VarCurr)
    <=> v52121(VarCurr) ) ).

fof(addAssignment_19190,axiom,
    ! [VarCurr] :
      ( v52121(VarCurr)
    <=> v52123(VarCurr) ) ).

fof(addAssignment_19189,axiom,
    ! [VarCurr] :
      ( v52123(VarCurr)
    <=> v52125(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_1000,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52199(VarNext)
       => ( v52125(VarNext)
        <=> v52125(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1070,axiom,
    ! [VarNext] :
      ( v52199(VarNext)
     => ( v52125(VarNext)
      <=> v52207(VarNext) ) ) ).

fof(addAssignment_19188,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52207(VarNext)
      <=> v52205(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1621,axiom,
    ! [VarCurr] :
      ( ~ v52153(VarCurr)
     => ( v52205(VarCurr)
      <=> v52127(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1457,axiom,
    ! [VarCurr] :
      ( v52153(VarCurr)
     => ( v52205(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10905,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52199(VarNext)
      <=> v52200(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10904,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52200(VarNext)
      <=> ( v52202(VarNext)
          & v52139(VarNext) ) ) ) ).

fof(writeUnaryOperator_4596,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52202(VarNext)
      <=> v52146(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1620,axiom,
    ! [VarCurr] :
      ( ~ v52187(VarCurr)
     => ( v52127(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1456,axiom,
    ! [VarCurr] :
      ( v52187(VarCurr)
     => ( v52127(VarCurr)
      <=> v52190(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_445,axiom,
    ! [VarCurr] :
      ( ( ~ v52134(VarCurr)
        & ~ v52137(VarCurr) )
     => ( v52190(VarCurr)
      <=> v52196(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1183,axiom,
    ! [VarCurr] :
      ( v52137(VarCurr)
     => ( v52190(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1148,axiom,
    ! [VarCurr] :
      ( v52134(VarCurr)
     => ( v52190(VarCurr)
      <=> v52191(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1619,axiom,
    ! [VarCurr] :
      ( ~ v52095(VarCurr)
     => ( v52196(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1455,axiom,
    ! [VarCurr] :
      ( v52095(VarCurr)
     => ( v52196(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10903,axiom,
    ! [VarCurr] :
      ( v52195(VarCurr)
    <=> ( v52161(VarCurr)
        | v52177(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1182,axiom,
    ! [VarCurr] :
      ( ~ v52192(VarCurr)
     => ( v52191(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1147,axiom,
    ! [VarCurr] :
      ( v52192(VarCurr)
     => ( v52191(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10902,axiom,
    ! [VarCurr] :
      ( v52194(VarCurr)
    <=> ( v52131(VarCurr)
        | v52173(VarCurr) ) ) ).

fof(writeUnaryOperator_4595,axiom,
    ! [VarCurr] :
      ( ~ v52192(VarCurr)
    <=> v52016(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10901,axiom,
    ! [VarCurr] :
      ( v52187(VarCurr)
    <=> ( v52188(VarCurr)
        | v52177(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10900,axiom,
    ! [VarCurr] :
      ( v52188(VarCurr)
    <=> ( v52189(VarCurr)
        | v52161(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10899,axiom,
    ! [VarCurr] :
      ( v52189(VarCurr)
    <=> ( v52134(VarCurr)
        | v52137(VarCurr) ) ) ).

fof(addAssignment_19187,axiom,
    ! [VarNext] :
      ( v52010(VarNext,bitIndex1)
    <=> v52179(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionShiftedRanges1_97,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52180(VarNext)
       => ( ( v52179(VarNext,bitIndex2)
          <=> v52010(VarCurr,bitIndex3) )
          & ( v52179(VarNext,bitIndex1)
          <=> v52010(VarCurr,bitIndex2) )
          & ( v52179(VarNext,bitIndex0)
          <=> v52010(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1069,axiom,
    ! [VarNext] :
      ( v52180(VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v52179(VarNext,B)
          <=> v52152(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10898,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52180(VarNext)
      <=> v52181(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10897,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52181(VarNext)
      <=> ( v52183(VarNext)
          & v52139(VarNext) ) ) ) ).

fof(writeUnaryOperator_4594,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52183(VarNext)
      <=> v52146(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_483,axiom,
    ! [VarCurr] :
      ( ~ v52171(VarCurr)
     => ( v52014(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_647,axiom,
    ! [VarCurr] :
      ( v52171(VarCurr)
     => ( v52014(VarCurr,bitIndex1)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10896,axiom,
    ! [VarCurr] :
      ( v52171(VarCurr)
    <=> ( v52172(VarCurr)
        | v52175(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10895,axiom,
    ! [VarCurr] :
      ( v52175(VarCurr)
    <=> ( v52176(VarCurr)
        & v52177(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3345,axiom,
    ! [VarCurr] :
      ( v52177(VarCurr)
    <=> ( $true
      <=> v52010(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_4593,axiom,
    ! [VarCurr] :
      ( ~ v52176(VarCurr)
    <=> v52095(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10894,axiom,
    ! [VarCurr] :
      ( v52172(VarCurr)
    <=> ( v52173(VarCurr)
        & v52134(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10893,axiom,
    ! [VarCurr] :
      ( v52173(VarCurr)
    <=> ( v52016(VarCurr)
        & v52029(VarCurr) ) ) ).

fof(addAssignment_19186,axiom,
    ! [VarNext] :
      ( v52010(VarNext,bitIndex3)
    <=> v52163(VarNext,bitIndex2) ) ).

fof(addCaseBooleanConditionShiftedRanges1_96,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52164(VarNext)
       => ( ( v52163(VarNext,bitIndex2)
          <=> v52010(VarCurr,bitIndex3) )
          & ( v52163(VarNext,bitIndex1)
          <=> v52010(VarCurr,bitIndex2) )
          & ( v52163(VarNext,bitIndex0)
          <=> v52010(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1068,axiom,
    ! [VarNext] :
      ( v52164(VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v52163(VarNext,B)
          <=> v52152(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10892,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52164(VarNext)
      <=> v52165(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10891,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52165(VarNext)
      <=> ( v52167(VarNext)
          & v52139(VarNext) ) ) ) ).

fof(writeUnaryOperator_4592,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52167(VarNext)
      <=> v52146(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_482,axiom,
    ! [VarCurr] :
      ( ~ v52157(VarCurr)
     => ( v52014(VarCurr,bitIndex3)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_646,axiom,
    ! [VarCurr] :
      ( v52157(VarCurr)
     => ( v52014(VarCurr,bitIndex3)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10890,axiom,
    ! [VarCurr] :
      ( v52157(VarCurr)
    <=> ( v52158(VarCurr)
        | v52159(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10889,axiom,
    ! [VarCurr] :
      ( v52159(VarCurr)
    <=> ( v52160(VarCurr)
        & v52161(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3344,axiom,
    ! [VarCurr] :
      ( v52161(VarCurr)
    <=> ( $true
      <=> v52010(VarCurr,bitIndex3) ) ) ).

fof(writeUnaryOperator_4591,axiom,
    ! [VarCurr] :
      ( ~ v52160(VarCurr)
    <=> v52095(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10888,axiom,
    ! [VarCurr] :
      ( v52158(VarCurr)
    <=> ( v52095(VarCurr)
        & v52137(VarCurr) ) ) ).

fof(addAssignment_19185,axiom,
    ! [VarNext] :
      ( v52010(VarNext,bitIndex2)
    <=> v52141(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionShiftedRanges1_95,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52142(VarNext)
       => ( ( v52141(VarNext,bitIndex2)
          <=> v52010(VarCurr,bitIndex3) )
          & ( v52141(VarNext,bitIndex1)
          <=> v52010(VarCurr,bitIndex2) )
          & ( v52141(VarNext,bitIndex0)
          <=> v52010(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1067,axiom,
    ! [VarNext] :
      ( v52142(VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v52141(VarNext,B)
          <=> v52152(VarNext,B) ) ) ) ).

fof(addAssignment_19184,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v52152(VarNext,B)
          <=> v52150(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_481,axiom,
    ! [VarCurr] :
      ( ~ v52153(VarCurr)
     => ( ( v52150(VarCurr,bitIndex2)
        <=> v52014(VarCurr,bitIndex3) )
        & ( v52150(VarCurr,bitIndex1)
        <=> v52014(VarCurr,bitIndex2) )
        & ( v52150(VarCurr,bitIndex0)
        <=> v52014(VarCurr,bitIndex1) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1454,axiom,
    ! [VarCurr] :
      ( v52153(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v52150(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_4590,axiom,
    ! [VarCurr] :
      ( ~ v52153(VarCurr)
    <=> v52012(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10887,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52142(VarNext)
      <=> v52143(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10886,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52143(VarNext)
      <=> ( v52144(VarNext)
          & v52139(VarNext) ) ) ) ).

fof(writeUnaryOperator_4589,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52144(VarNext)
      <=> v52146(VarNext) ) ) ).

fof(addAssignment_19183,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52146(VarNext)
      <=> v52139(VarCurr) ) ) ).

fof(addAssignment_19182,axiom,
    ! [VarCurr] :
      ( v52139(VarCurr)
    <=> v42723(VarCurr) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_480,axiom,
    ! [VarCurr] :
      ( ~ v52129(VarCurr)
     => ( v52014(VarCurr,bitIndex2)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_645,axiom,
    ! [VarCurr] :
      ( v52129(VarCurr)
     => ( v52014(VarCurr,bitIndex2)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10885,axiom,
    ! [VarCurr] :
      ( v52129(VarCurr)
    <=> ( v52130(VarCurr)
        | v52135(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10884,axiom,
    ! [VarCurr] :
      ( v52135(VarCurr)
    <=> ( v52136(VarCurr)
        & v52137(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3343,axiom,
    ! [VarCurr] :
      ( v52137(VarCurr)
    <=> ( $true
      <=> v52010(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_4588,axiom,
    ! [VarCurr] :
      ( ~ v52136(VarCurr)
    <=> v52095(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10883,axiom,
    ! [VarCurr] :
      ( v52130(VarCurr)
    <=> ( v52131(VarCurr)
        & v52134(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3342,axiom,
    ! [VarCurr] :
      ( v52134(VarCurr)
    <=> ( $true
      <=> v52010(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10882,axiom,
    ! [VarCurr] :
      ( v52131(VarCurr)
    <=> ( v52016(VarCurr)
        & v52133(VarCurr) ) ) ).

fof(writeUnaryOperator_4587,axiom,
    ! [VarCurr] :
      ( ~ v52133(VarCurr)
    <=> v52029(VarCurr) ) ).

fof(addAssignment_19181,axiom,
    ! [VarCurr] :
      ( v52107(VarCurr)
    <=> v26627(VarCurr) ) ).

fof(addAssignment_19180,axiom,
    ! [VarCurr] :
      ( v52029(VarCurr)
    <=> v52031(VarCurr) ) ).

fof(addAssignment_19179,axiom,
    ! [VarCurr] :
      ( v52031(VarCurr)
    <=> v52033(VarCurr) ) ).

fof(addAssignment_19178,axiom,
    ! [VarCurr] :
      ( v52033(VarCurr)
    <=> v52035(VarCurr,bitIndex0) ) ).

fof(addAssignment_19177,axiom,
    ! [VarCurr] :
      ( v52035(VarCurr,bitIndex0)
    <=> v51675(VarCurr,bitIndex49) ) ).

fof(addAssignment_19176,axiom,
    ! [VarCurr] :
      ( v51675(VarCurr,bitIndex49)
    <=> v51677(VarCurr,bitIndex49) ) ).

fof(addAssignment_19175,axiom,
    ! [VarCurr] :
      ( v51677(VarCurr,bitIndex49)
    <=> v51679(VarCurr,bitIndex539) ) ).

fof(addAssignment_19174,axiom,
    ! [VarNext] :
      ( v51679(VarNext,bitIndex539)
    <=> v52087(VarNext,bitIndex49) ) ).

fof(addCaseBooleanConditionShiftedRanges1_94,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52089(VarNext)
       => ( ( v52087(VarNext,bitIndex69)
          <=> v51679(VarCurr,bitIndex559) )
          & ( v52087(VarNext,bitIndex68)
          <=> v51679(VarCurr,bitIndex558) )
          & ( v52087(VarNext,bitIndex67)
          <=> v51679(VarCurr,bitIndex557) )
          & ( v52087(VarNext,bitIndex66)
          <=> v51679(VarCurr,bitIndex556) )
          & ( v52087(VarNext,bitIndex65)
          <=> v51679(VarCurr,bitIndex555) )
          & ( v52087(VarNext,bitIndex64)
          <=> v51679(VarCurr,bitIndex554) )
          & ( v52087(VarNext,bitIndex63)
          <=> v51679(VarCurr,bitIndex553) )
          & ( v52087(VarNext,bitIndex62)
          <=> v51679(VarCurr,bitIndex552) )
          & ( v52087(VarNext,bitIndex61)
          <=> v51679(VarCurr,bitIndex551) )
          & ( v52087(VarNext,bitIndex60)
          <=> v51679(VarCurr,bitIndex550) )
          & ( v52087(VarNext,bitIndex59)
          <=> v51679(VarCurr,bitIndex549) )
          & ( v52087(VarNext,bitIndex58)
          <=> v51679(VarCurr,bitIndex548) )
          & ( v52087(VarNext,bitIndex57)
          <=> v51679(VarCurr,bitIndex547) )
          & ( v52087(VarNext,bitIndex56)
          <=> v51679(VarCurr,bitIndex546) )
          & ( v52087(VarNext,bitIndex55)
          <=> v51679(VarCurr,bitIndex545) )
          & ( v52087(VarNext,bitIndex54)
          <=> v51679(VarCurr,bitIndex544) )
          & ( v52087(VarNext,bitIndex53)
          <=> v51679(VarCurr,bitIndex543) )
          & ( v52087(VarNext,bitIndex52)
          <=> v51679(VarCurr,bitIndex542) )
          & ( v52087(VarNext,bitIndex51)
          <=> v51679(VarCurr,bitIndex541) )
          & ( v52087(VarNext,bitIndex50)
          <=> v51679(VarCurr,bitIndex540) )
          & ( v52087(VarNext,bitIndex49)
          <=> v51679(VarCurr,bitIndex539) )
          & ( v52087(VarNext,bitIndex48)
          <=> v51679(VarCurr,bitIndex538) )
          & ( v52087(VarNext,bitIndex47)
          <=> v51679(VarCurr,bitIndex537) )
          & ( v52087(VarNext,bitIndex46)
          <=> v51679(VarCurr,bitIndex536) )
          & ( v52087(VarNext,bitIndex45)
          <=> v51679(VarCurr,bitIndex535) )
          & ( v52087(VarNext,bitIndex44)
          <=> v51679(VarCurr,bitIndex534) )
          & ( v52087(VarNext,bitIndex43)
          <=> v51679(VarCurr,bitIndex533) )
          & ( v52087(VarNext,bitIndex42)
          <=> v51679(VarCurr,bitIndex532) )
          & ( v52087(VarNext,bitIndex41)
          <=> v51679(VarCurr,bitIndex531) )
          & ( v52087(VarNext,bitIndex40)
          <=> v51679(VarCurr,bitIndex530) )
          & ( v52087(VarNext,bitIndex39)
          <=> v51679(VarCurr,bitIndex529) )
          & ( v52087(VarNext,bitIndex38)
          <=> v51679(VarCurr,bitIndex528) )
          & ( v52087(VarNext,bitIndex37)
          <=> v51679(VarCurr,bitIndex527) )
          & ( v52087(VarNext,bitIndex36)
          <=> v51679(VarCurr,bitIndex526) )
          & ( v52087(VarNext,bitIndex35)
          <=> v51679(VarCurr,bitIndex525) )
          & ( v52087(VarNext,bitIndex34)
          <=> v51679(VarCurr,bitIndex524) )
          & ( v52087(VarNext,bitIndex33)
          <=> v51679(VarCurr,bitIndex523) )
          & ( v52087(VarNext,bitIndex32)
          <=> v51679(VarCurr,bitIndex522) )
          & ( v52087(VarNext,bitIndex31)
          <=> v51679(VarCurr,bitIndex521) )
          & ( v52087(VarNext,bitIndex30)
          <=> v51679(VarCurr,bitIndex520) )
          & ( v52087(VarNext,bitIndex29)
          <=> v51679(VarCurr,bitIndex519) )
          & ( v52087(VarNext,bitIndex28)
          <=> v51679(VarCurr,bitIndex518) )
          & ( v52087(VarNext,bitIndex27)
          <=> v51679(VarCurr,bitIndex517) )
          & ( v52087(VarNext,bitIndex26)
          <=> v51679(VarCurr,bitIndex516) )
          & ( v52087(VarNext,bitIndex25)
          <=> v51679(VarCurr,bitIndex515) )
          & ( v52087(VarNext,bitIndex24)
          <=> v51679(VarCurr,bitIndex514) )
          & ( v52087(VarNext,bitIndex23)
          <=> v51679(VarCurr,bitIndex513) )
          & ( v52087(VarNext,bitIndex22)
          <=> v51679(VarCurr,bitIndex512) )
          & ( v52087(VarNext,bitIndex21)
          <=> v51679(VarCurr,bitIndex511) )
          & ( v52087(VarNext,bitIndex20)
          <=> v51679(VarCurr,bitIndex510) )
          & ( v52087(VarNext,bitIndex19)
          <=> v51679(VarCurr,bitIndex509) )
          & ( v52087(VarNext,bitIndex18)
          <=> v51679(VarCurr,bitIndex508) )
          & ( v52087(VarNext,bitIndex17)
          <=> v51679(VarCurr,bitIndex507) )
          & ( v52087(VarNext,bitIndex16)
          <=> v51679(VarCurr,bitIndex506) )
          & ( v52087(VarNext,bitIndex15)
          <=> v51679(VarCurr,bitIndex505) )
          & ( v52087(VarNext,bitIndex14)
          <=> v51679(VarCurr,bitIndex504) )
          & ( v52087(VarNext,bitIndex13)
          <=> v51679(VarCurr,bitIndex503) )
          & ( v52087(VarNext,bitIndex12)
          <=> v51679(VarCurr,bitIndex502) )
          & ( v52087(VarNext,bitIndex11)
          <=> v51679(VarCurr,bitIndex501) )
          & ( v52087(VarNext,bitIndex10)
          <=> v51679(VarCurr,bitIndex500) )
          & ( v52087(VarNext,bitIndex9)
          <=> v51679(VarCurr,bitIndex499) )
          & ( v52087(VarNext,bitIndex8)
          <=> v51679(VarCurr,bitIndex498) )
          & ( v52087(VarNext,bitIndex7)
          <=> v51679(VarCurr,bitIndex497) )
          & ( v52087(VarNext,bitIndex6)
          <=> v51679(VarCurr,bitIndex496) )
          & ( v52087(VarNext,bitIndex5)
          <=> v51679(VarCurr,bitIndex495) )
          & ( v52087(VarNext,bitIndex4)
          <=> v51679(VarCurr,bitIndex494) )
          & ( v52087(VarNext,bitIndex3)
          <=> v51679(VarCurr,bitIndex493) )
          & ( v52087(VarNext,bitIndex2)
          <=> v51679(VarCurr,bitIndex492) )
          & ( v52087(VarNext,bitIndex1)
          <=> v51679(VarCurr,bitIndex491) )
          & ( v52087(VarNext,bitIndex0)
          <=> v51679(VarCurr,bitIndex490) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1066,axiom,
    ! [VarNext] :
      ( v52089(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v52087(VarNext,B)
          <=> v51950(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10881,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52089(VarNext)
      <=> ( v52090(VarNext)
          & v51932(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10880,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52090(VarNext)
      <=> ( v52092(VarNext)
          & v51584(VarNext) ) ) ) ).

fof(writeUnaryOperator_4586,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52092(VarNext)
      <=> v51593(VarNext) ) ) ).

fof(addAssignment_19173,axiom,
    ! [VarCurr] :
      ( v51916(VarCurr,bitIndex49)
    <=> v51921(VarCurr,bitIndex49) ) ).

fof(addAssignment_19172,axiom,
    ! [VarCurr] :
      ( v51920(VarCurr,bitIndex49)
    <=> v51679(VarCurr,bitIndex469) ) ).

fof(addAssignment_19171,axiom,
    ! [VarCurr] :
      ( v51909(VarCurr,bitIndex49)
    <=> v51914(VarCurr,bitIndex49) ) ).

fof(addAssignment_19170,axiom,
    ! [VarCurr] :
      ( v51913(VarCurr,bitIndex49)
    <=> v51679(VarCurr,bitIndex539) ) ).

fof(addAssignment_19169,axiom,
    ! [VarNext] :
      ( v51679(VarNext,bitIndex469)
    <=> v52079(VarNext,bitIndex49) ) ).

fof(addCaseBooleanConditionShiftedRanges1_93,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52081(VarNext)
       => ( ( v52079(VarNext,bitIndex69)
          <=> v51679(VarCurr,bitIndex489) )
          & ( v52079(VarNext,bitIndex68)
          <=> v51679(VarCurr,bitIndex488) )
          & ( v52079(VarNext,bitIndex67)
          <=> v51679(VarCurr,bitIndex487) )
          & ( v52079(VarNext,bitIndex66)
          <=> v51679(VarCurr,bitIndex486) )
          & ( v52079(VarNext,bitIndex65)
          <=> v51679(VarCurr,bitIndex485) )
          & ( v52079(VarNext,bitIndex64)
          <=> v51679(VarCurr,bitIndex484) )
          & ( v52079(VarNext,bitIndex63)
          <=> v51679(VarCurr,bitIndex483) )
          & ( v52079(VarNext,bitIndex62)
          <=> v51679(VarCurr,bitIndex482) )
          & ( v52079(VarNext,bitIndex61)
          <=> v51679(VarCurr,bitIndex481) )
          & ( v52079(VarNext,bitIndex60)
          <=> v51679(VarCurr,bitIndex480) )
          & ( v52079(VarNext,bitIndex59)
          <=> v51679(VarCurr,bitIndex479) )
          & ( v52079(VarNext,bitIndex58)
          <=> v51679(VarCurr,bitIndex478) )
          & ( v52079(VarNext,bitIndex57)
          <=> v51679(VarCurr,bitIndex477) )
          & ( v52079(VarNext,bitIndex56)
          <=> v51679(VarCurr,bitIndex476) )
          & ( v52079(VarNext,bitIndex55)
          <=> v51679(VarCurr,bitIndex475) )
          & ( v52079(VarNext,bitIndex54)
          <=> v51679(VarCurr,bitIndex474) )
          & ( v52079(VarNext,bitIndex53)
          <=> v51679(VarCurr,bitIndex473) )
          & ( v52079(VarNext,bitIndex52)
          <=> v51679(VarCurr,bitIndex472) )
          & ( v52079(VarNext,bitIndex51)
          <=> v51679(VarCurr,bitIndex471) )
          & ( v52079(VarNext,bitIndex50)
          <=> v51679(VarCurr,bitIndex470) )
          & ( v52079(VarNext,bitIndex49)
          <=> v51679(VarCurr,bitIndex469) )
          & ( v52079(VarNext,bitIndex48)
          <=> v51679(VarCurr,bitIndex468) )
          & ( v52079(VarNext,bitIndex47)
          <=> v51679(VarCurr,bitIndex467) )
          & ( v52079(VarNext,bitIndex46)
          <=> v51679(VarCurr,bitIndex466) )
          & ( v52079(VarNext,bitIndex45)
          <=> v51679(VarCurr,bitIndex465) )
          & ( v52079(VarNext,bitIndex44)
          <=> v51679(VarCurr,bitIndex464) )
          & ( v52079(VarNext,bitIndex43)
          <=> v51679(VarCurr,bitIndex463) )
          & ( v52079(VarNext,bitIndex42)
          <=> v51679(VarCurr,bitIndex462) )
          & ( v52079(VarNext,bitIndex41)
          <=> v51679(VarCurr,bitIndex461) )
          & ( v52079(VarNext,bitIndex40)
          <=> v51679(VarCurr,bitIndex460) )
          & ( v52079(VarNext,bitIndex39)
          <=> v51679(VarCurr,bitIndex459) )
          & ( v52079(VarNext,bitIndex38)
          <=> v51679(VarCurr,bitIndex458) )
          & ( v52079(VarNext,bitIndex37)
          <=> v51679(VarCurr,bitIndex457) )
          & ( v52079(VarNext,bitIndex36)
          <=> v51679(VarCurr,bitIndex456) )
          & ( v52079(VarNext,bitIndex35)
          <=> v51679(VarCurr,bitIndex455) )
          & ( v52079(VarNext,bitIndex34)
          <=> v51679(VarCurr,bitIndex454) )
          & ( v52079(VarNext,bitIndex33)
          <=> v51679(VarCurr,bitIndex453) )
          & ( v52079(VarNext,bitIndex32)
          <=> v51679(VarCurr,bitIndex452) )
          & ( v52079(VarNext,bitIndex31)
          <=> v51679(VarCurr,bitIndex451) )
          & ( v52079(VarNext,bitIndex30)
          <=> v51679(VarCurr,bitIndex450) )
          & ( v52079(VarNext,bitIndex29)
          <=> v51679(VarCurr,bitIndex449) )
          & ( v52079(VarNext,bitIndex28)
          <=> v51679(VarCurr,bitIndex448) )
          & ( v52079(VarNext,bitIndex27)
          <=> v51679(VarCurr,bitIndex447) )
          & ( v52079(VarNext,bitIndex26)
          <=> v51679(VarCurr,bitIndex446) )
          & ( v52079(VarNext,bitIndex25)
          <=> v51679(VarCurr,bitIndex445) )
          & ( v52079(VarNext,bitIndex24)
          <=> v51679(VarCurr,bitIndex444) )
          & ( v52079(VarNext,bitIndex23)
          <=> v51679(VarCurr,bitIndex443) )
          & ( v52079(VarNext,bitIndex22)
          <=> v51679(VarCurr,bitIndex442) )
          & ( v52079(VarNext,bitIndex21)
          <=> v51679(VarCurr,bitIndex441) )
          & ( v52079(VarNext,bitIndex20)
          <=> v51679(VarCurr,bitIndex440) )
          & ( v52079(VarNext,bitIndex19)
          <=> v51679(VarCurr,bitIndex439) )
          & ( v52079(VarNext,bitIndex18)
          <=> v51679(VarCurr,bitIndex438) )
          & ( v52079(VarNext,bitIndex17)
          <=> v51679(VarCurr,bitIndex437) )
          & ( v52079(VarNext,bitIndex16)
          <=> v51679(VarCurr,bitIndex436) )
          & ( v52079(VarNext,bitIndex15)
          <=> v51679(VarCurr,bitIndex435) )
          & ( v52079(VarNext,bitIndex14)
          <=> v51679(VarCurr,bitIndex434) )
          & ( v52079(VarNext,bitIndex13)
          <=> v51679(VarCurr,bitIndex433) )
          & ( v52079(VarNext,bitIndex12)
          <=> v51679(VarCurr,bitIndex432) )
          & ( v52079(VarNext,bitIndex11)
          <=> v51679(VarCurr,bitIndex431) )
          & ( v52079(VarNext,bitIndex10)
          <=> v51679(VarCurr,bitIndex430) )
          & ( v52079(VarNext,bitIndex9)
          <=> v51679(VarCurr,bitIndex429) )
          & ( v52079(VarNext,bitIndex8)
          <=> v51679(VarCurr,bitIndex428) )
          & ( v52079(VarNext,bitIndex7)
          <=> v51679(VarCurr,bitIndex427) )
          & ( v52079(VarNext,bitIndex6)
          <=> v51679(VarCurr,bitIndex426) )
          & ( v52079(VarNext,bitIndex5)
          <=> v51679(VarCurr,bitIndex425) )
          & ( v52079(VarNext,bitIndex4)
          <=> v51679(VarCurr,bitIndex424) )
          & ( v52079(VarNext,bitIndex3)
          <=> v51679(VarCurr,bitIndex423) )
          & ( v52079(VarNext,bitIndex2)
          <=> v51679(VarCurr,bitIndex422) )
          & ( v52079(VarNext,bitIndex1)
          <=> v51679(VarCurr,bitIndex421) )
          & ( v52079(VarNext,bitIndex0)
          <=> v51679(VarCurr,bitIndex420) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1065,axiom,
    ! [VarNext] :
      ( v52081(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v52079(VarNext,B)
          <=> v51904(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10879,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52081(VarNext)
      <=> ( v52082(VarNext)
          & v51886(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10878,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52082(VarNext)
      <=> ( v52084(VarNext)
          & v51584(VarNext) ) ) ) ).

fof(writeUnaryOperator_4585,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52084(VarNext)
      <=> v51593(VarNext) ) ) ).

fof(addAssignment_19168,axiom,
    ! [VarCurr] :
      ( v51870(VarCurr,bitIndex49)
    <=> v51875(VarCurr,bitIndex49) ) ).

fof(addAssignment_19167,axiom,
    ! [VarCurr] :
      ( v51874(VarCurr,bitIndex49)
    <=> v51679(VarCurr,bitIndex399) ) ).

fof(addAssignment_19166,axiom,
    ! [VarCurr] :
      ( v51863(VarCurr,bitIndex49)
    <=> v51868(VarCurr,bitIndex49) ) ).

fof(addAssignment_19165,axiom,
    ! [VarCurr] :
      ( v51867(VarCurr,bitIndex49)
    <=> v51679(VarCurr,bitIndex469) ) ).

fof(addAssignment_19164,axiom,
    ! [VarCurr] :
      ( v51742(VarCurr,bitIndex49)
    <=> v51744(VarCurr,bitIndex49) ) ).

fof(addAssignment_19163,axiom,
    ! [VarCurr] :
      ( v51744(VarCurr,bitIndex49)
    <=> v51746(VarCurr,bitIndex49) ) ).

fof(addAssignment_19162,axiom,
    ! [VarCurr] :
      ( v51746(VarCurr,bitIndex49)
    <=> v51748(VarCurr,bitIndex49) ) ).

fof(addAssignment_19161,axiom,
    ! [VarCurr] :
      ( v51748(VarCurr,bitIndex49)
    <=> v51750(VarCurr,bitIndex49) ) ).

fof(addAssignment_19160,axiom,
    ! [VarCurr] :
      ( v51750(VarCurr,bitIndex49)
    <=> v51752(VarCurr,bitIndex49) ) ).

fof(addAssignment_19159,axiom,
    ! [VarCurr] :
      ( v51752(VarCurr,bitIndex49)
    <=> v51754(VarCurr,bitIndex49) ) ).

fof(addAssignment_19158,axiom,
    ! [VarCurr] :
      ( v51754(VarCurr,bitIndex49)
    <=> v51808(VarCurr,bitIndex49) ) ).

fof(addAssignment_19157,axiom,
    ! [VarNext] :
      ( v51811(VarNext,bitIndex4)
    <=> v52040(VarNext,bitIndex4) ) ).

fof(addCaseBooleanConditionEqualRanges1_999,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52041(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v52040(VarNext,B)
            <=> v51811(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1064,axiom,
    ! [VarNext] :
      ( v52041(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v52040(VarNext,B)
          <=> v52068(VarNext,B) ) ) ) ).

fof(addAssignment_19156,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v52068(VarNext,B)
          <=> v52066(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1181,axiom,
    ! [VarCurr] :
      ( ~ v51778(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v52066(VarCurr,B)
          <=> v52069(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1146,axiom,
    ! [VarCurr] :
      ( v51778(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v52066(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1180,axiom,
    ! [VarCurr] :
      ( ~ v51781(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v52069(VarCurr,B)
          <=> v49688(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1145,axiom,
    ! [VarCurr] :
      ( v51781(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v52069(VarCurr,B)
          <=> v52070(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1179,axiom,
    ! [VarCurr] :
      ( ~ v51792(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v52070(VarCurr,B)
          <=> v52072(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1144,axiom,
    ! [VarCurr] :
      ( v51792(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v52070(VarCurr,B)
          <=> v52071(VarCurr,B) ) ) ) ).

fof(addAssignment_19155,axiom,
    ! [VarCurr] :
      ( ( v52072(VarCurr,bitIndex3)
      <=> v49528(VarCurr,bitIndex31) )
      & ( v52072(VarCurr,bitIndex2)
      <=> v49528(VarCurr,bitIndex30) )
      & ( v52072(VarCurr,bitIndex1)
      <=> v49528(VarCurr,bitIndex29) )
      & ( v52072(VarCurr,bitIndex0)
      <=> v49528(VarCurr,bitIndex28) ) ) ).

fof(addAssignment_19154,axiom,
    ! [VarCurr] :
      ( ( v52072(VarCurr,bitIndex7)
      <=> v52073(VarCurr,bitIndex3) )
      & ( v52072(VarCurr,bitIndex6)
      <=> v52073(VarCurr,bitIndex2) )
      & ( v52072(VarCurr,bitIndex5)
      <=> v52073(VarCurr,bitIndex1) )
      & ( v52072(VarCurr,bitIndex4)
      <=> v52073(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_19153,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v52073(VarCurr,B)
      <=> v52074(VarCurr,B) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1906,axiom,
    ! [VarCurr] :
      ( v52074(VarCurr,bitIndex0)
    <=> ( v49528(VarCurr,bitIndex32)
        | v52075(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1905,axiom,
    ! [VarCurr] :
      ( v52074(VarCurr,bitIndex1)
    <=> ( v49528(VarCurr,bitIndex33)
        | v52075(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1904,axiom,
    ! [VarCurr] :
      ( v52074(VarCurr,bitIndex2)
    <=> ( v49528(VarCurr,bitIndex34)
        | v52075(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1903,axiom,
    ! [VarCurr] :
      ( v52074(VarCurr,bitIndex3)
    <=> ( v49528(VarCurr,bitIndex35)
        | v52075(VarCurr,bitIndex3) ) ) ).

fof(addAssignment_19152,axiom,
    ! [VarCurr] :
      ( v52075(VarCurr,bitIndex0)
    <=> v49528(VarCurr,bitIndex36) ) ).

fof(addAssignment_19151,axiom,
    ! [VarCurr] :
      ( ( v52075(VarCurr,bitIndex3)
      <=> $false )
      & ( v52075(VarCurr,bitIndex2)
      <=> $false )
      & ( v52075(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addAssignment_19150,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v52071(VarCurr,B)
      <=> v49688(VarCurr,B) ) ) ).

fof(addAssignment_19149,axiom,
    ! [VarCurr] :
      ( v52071(VarCurr,bitIndex4)
    <=> v52037(VarCurr) ) ).

fof(addAssignment_19148,axiom,
    ! [VarCurr,B] :
      ( range_7_5(B)
     => ( v52071(VarCurr,B)
      <=> v49688(VarCurr,B) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10877,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52041(VarNext)
      <=> ( v52042(VarNext)
          & v52049(VarNext) ) ) ) ).

fof(addAssignment_19147,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52049(VarNext)
      <=> v52047(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10876,axiom,
    ! [VarCurr] :
      ( v52047(VarCurr)
    <=> ( v52050(VarCurr)
        & v52054(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10875,axiom,
    ! [VarCurr] :
      ( v52054(VarCurr)
    <=> ( v52055(VarCurr)
        | v51778(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10874,axiom,
    ! [VarCurr] :
      ( v52055(VarCurr)
    <=> ( v52056(VarCurr)
        & v52064(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10873,axiom,
    ! [VarCurr] :
      ( v52064(VarCurr)
    <=> ( v52065(VarCurr)
        | v51782(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10872,axiom,
    ! [VarCurr] :
      ( v52065(VarCurr)
    <=> ( v51789(VarCurr)
        | v51781(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10871,axiom,
    ! [VarCurr] :
      ( v52056(VarCurr)
    <=> ( v52057(VarCurr)
        & v52062(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10870,axiom,
    ! [VarCurr] :
      ( v52062(VarCurr)
    <=> ( v46445(VarCurr)
        | v52063(VarCurr) ) ) ).

fof(writeUnaryOperator_4584,axiom,
    ! [VarCurr] :
      ( ~ v52063(VarCurr)
    <=> v51782(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10869,axiom,
    ! [VarCurr] :
      ( v52057(VarCurr)
    <=> ( v52058(VarCurr)
        & v52059(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10868,axiom,
    ! [VarCurr] :
      ( v52059(VarCurr)
    <=> ( v52060(VarCurr)
        | v52061(VarCurr) ) ) ).

fof(writeUnaryOperator_4583,axiom,
    ! [VarCurr] :
      ( ~ v52061(VarCurr)
    <=> v51781(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10867,axiom,
    ! [VarCurr] :
      ( v52060(VarCurr)
    <=> ( v51792(VarCurr)
        | v51794(VarCurr) ) ) ).

fof(writeUnaryOperator_4582,axiom,
    ! [VarCurr] :
      ( ~ v52058(VarCurr)
    <=> v51789(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10866,axiom,
    ! [VarCurr] :
      ( v52050(VarCurr)
    <=> ( v51778(VarCurr)
        | v52051(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10865,axiom,
    ! [VarCurr] :
      ( v52051(VarCurr)
    <=> ( v52052(VarCurr)
        & v52053(VarCurr) ) ) ).

fof(writeUnaryOperator_4581,axiom,
    ! [VarCurr] :
      ( ~ v52053(VarCurr)
    <=> v51778(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10864,axiom,
    ! [VarCurr] :
      ( v52052(VarCurr)
    <=> ( v51781(VarCurr)
        | v51782(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10863,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v52042(VarNext)
      <=> ( v52044(VarNext)
          & v45620(VarNext) ) ) ) ).

fof(writeUnaryOperator_4580,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v52044(VarNext)
      <=> v47885(VarNext) ) ) ).

fof(addAssignment_19146,axiom,
    ! [VarCurr] :
      ( v49528(VarCurr,bitIndex36)
    <=> v49530(VarCurr,bitIndex36) ) ).

fof(addAssignment_19145,axiom,
    ! [VarCurr] :
      ( v49530(VarCurr,bitIndex36)
    <=> v49532(VarCurr,bitIndex36) ) ).

fof(addAssignment_19144,axiom,
    ! [VarCurr] :
      ( v49532(VarCurr,bitIndex36)
    <=> v49534(VarCurr,bitIndex36) ) ).

fof(addAssignment_19143,axiom,
    ! [VarCurr] :
      ( v49534(VarCurr,bitIndex36)
    <=> v49917(VarCurr,bitIndex36) ) ).

fof(addAssignment_19142,axiom,
    ! [VarCurr] :
      ( v49528(VarCurr,bitIndex32)
    <=> v49530(VarCurr,bitIndex32) ) ).

fof(addAssignment_19141,axiom,
    ! [VarCurr] :
      ( v49530(VarCurr,bitIndex32)
    <=> v49532(VarCurr,bitIndex32) ) ).

fof(addAssignment_19140,axiom,
    ! [VarCurr] :
      ( v49532(VarCurr,bitIndex32)
    <=> v49534(VarCurr,bitIndex32) ) ).

fof(addAssignment_19139,axiom,
    ! [VarCurr] :
      ( v49534(VarCurr,bitIndex32)
    <=> v49917(VarCurr,bitIndex32) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10862,axiom,
    ! [VarCurr] :
      ( v52037(VarCurr)
    <=> ( v49578(VarCurr)
        | v48647(VarCurr) ) ) ).

fof(addAssignment_19138,axiom,
    ! [VarCurr] :
      ( v52016(VarCurr)
    <=> v52018(VarCurr) ) ).

fof(addAssignment_19137,axiom,
    ! [VarCurr] :
      ( v52018(VarCurr)
    <=> v52020(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1618,axiom,
    ! [VarCurr] :
      ( ~ v52022(VarCurr)
     => ( v52020(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1453,axiom,
    ! [VarCurr] :
      ( v52022(VarCurr)
     => ( v52020(VarCurr)
      <=> v52027(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1617,axiom,
    ! [VarCurr] :
      ( ~ v52004(VarCurr)
     => ( v52027(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1452,axiom,
    ! [VarCurr] :
      ( v52004(VarCurr)
     => ( v52027(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10861,axiom,
    ! [VarCurr] :
      ( v52022(VarCurr)
    <=> ( v52023(VarCurr)
        & v52026(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3341,axiom,
    ! [VarCurr] :
      ( v52026(VarCurr)
    <=> ( $true
      <=> v51984(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10860,axiom,
    ! [VarCurr] :
      ( v52023(VarCurr)
    <=> ( v52024(VarCurr)
        & v52025(VarCurr) ) ) ).

fof(writeUnaryOperator_4579,axiom,
    ! [VarCurr] :
      ( ~ v52025(VarCurr)
    <=> v51560(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_3340,axiom,
    ! [VarCurr] :
      ( v52024(VarCurr)
    <=> ( ( v51558(VarCurr,bitIndex1)
        <=> $true )
        & ( v51558(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_19136,axiom,
    ! [VarCurr] :
      ( v52012(VarCurr)
    <=> v42709(VarCurr) ) ).

fof(addAssignment_19135,axiom,
    ! [VarCurr] :
      ( v51994(VarCurr)
    <=> v51996(VarCurr) ) ).

fof(addAssignment_19134,axiom,
    ! [VarCurr] :
      ( v51996(VarCurr)
    <=> v51998(VarCurr) ) ).

fof(addAssignment_19133,axiom,
    ! [VarCurr] :
      ( v51998(VarCurr)
    <=> v52000(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1616,axiom,
    ! [VarCurr] :
      ( ~ v51560(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v51558(VarCurr,B)
          <=> v51955(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1451,axiom,
    ! [VarCurr] :
      ( v51560(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v51558(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_129,axiom,
    ! [VarCurr] :
      ( ( ~ v51956(VarCurr)
        & ~ v51976(VarCurr)
        & ~ v51977(VarCurr) )
     => ! [B] :
          ( range_1_0(B)
         => ( v51955(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_444,axiom,
    ! [VarCurr] :
      ( v51977(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v51955(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1178,axiom,
    ! [VarCurr] :
      ( v51976(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v51955(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1143,axiom,
    ! [VarCurr] :
      ( v51956(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v51955(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10859,axiom,
    ! [VarCurr] :
      ( v51977(VarCurr)
    <=> ( v51979(VarCurr)
        | v51982(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3339,axiom,
    ! [VarCurr] :
      ( v51982(VarCurr)
    <=> ( ( v51673(VarCurr,bitIndex6)
        <=> $true )
        & ( v51673(VarCurr,bitIndex5)
        <=> $false )
        & ( v51673(VarCurr,bitIndex4)
        <=> $false )
        & ( v51673(VarCurr,bitIndex3)
        <=> $true )
        & ( v51673(VarCurr,bitIndex2)
        <=> $false )
        & ( v51673(VarCurr,bitIndex1)
        <=> $true )
        & ( v51673(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10858,axiom,
    ! [VarCurr] :
      ( v51979(VarCurr)
    <=> ( v51980(VarCurr)
        | v51981(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3338,axiom,
    ! [VarCurr] :
      ( v51981(VarCurr)
    <=> ( ( v51673(VarCurr,bitIndex6)
        <=> $false )
        & ( v51673(VarCurr,bitIndex5)
        <=> $false )
        & ( v51673(VarCurr,bitIndex4)
        <=> $false )
        & ( v51673(VarCurr,bitIndex3)
        <=> $true )
        & ( v51673(VarCurr,bitIndex2)
        <=> $false )
        & ( v51673(VarCurr,bitIndex1)
        <=> $true )
        & ( v51673(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3337,axiom,
    ! [VarCurr] :
      ( v51980(VarCurr)
    <=> ( ( v51673(VarCurr,bitIndex6)
        <=> $false )
        & ( v51673(VarCurr,bitIndex5)
        <=> $false )
        & ( v51673(VarCurr,bitIndex4)
        <=> $false )
        & ( v51673(VarCurr,bitIndex3)
        <=> $true )
        & ( v51673(VarCurr,bitIndex2)
        <=> $false )
        & ( v51673(VarCurr,bitIndex1)
        <=> $true )
        & ( v51673(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3336,axiom,
    ! [VarCurr] :
      ( v51976(VarCurr)
    <=> ( ( v51673(VarCurr,bitIndex6)
        <=> $true )
        & ( v51673(VarCurr,bitIndex5)
        <=> $true )
        & ( v51673(VarCurr,bitIndex4)
        <=> $true )
        & ( v51673(VarCurr,bitIndex3)
        <=> $true )
        & ( v51673(VarCurr,bitIndex2)
        <=> $false )
        & ( v51673(VarCurr,bitIndex1)
        <=> $true )
        & ( v51673(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10857,axiom,
    ! [VarCurr] :
      ( v51956(VarCurr)
    <=> ( v51958(VarCurr)
        | v51975(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3335,axiom,
    ! [VarCurr] :
      ( v51975(VarCurr)
    <=> ( ( v51673(VarCurr,bitIndex6)
        <=> $true )
        & ( v51673(VarCurr,bitIndex5)
        <=> $false )
        & ( v51673(VarCurr,bitIndex4)
        <=> $false )
        & ( v51673(VarCurr,bitIndex3)
        <=> $false )
        & ( v51673(VarCurr,bitIndex2)
        <=> $true )
        & ( v51673(VarCurr,bitIndex1)
        <=> $false )
        & ( v51673(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10856,axiom,
    ! [VarCurr] :
      ( v51958(VarCurr)
    <=> ( v51959(VarCurr)
        | v51974(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3334,axiom,
    ! [VarCurr] :
      ( v51974(VarCurr)
    <=> ( ( v51673(VarCurr,bitIndex6)
        <=> $true )
        & ( v51673(VarCurr,bitIndex5)
        <=> $false )
        & ( v51673(VarCurr,bitIndex4)
        <=> $false )
        & ( v51673(VarCurr,bitIndex3)
        <=> $false )
        & ( v51673(VarCurr,bitIndex2)
        <=> $true )
        & ( v51673(VarCurr,bitIndex1)
        <=> $false )
        & ( v51673(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10855,axiom,
    ! [VarCurr] :
      ( v51959(VarCurr)
    <=> ( v51960(VarCurr)
        | v51973(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3333,axiom,
    ! [VarCurr] :
      ( v51973(VarCurr)
    <=> ( ( v51673(VarCurr,bitIndex6)
        <=> $true )
        & ( v51673(VarCurr,bitIndex5)
        <=> $true )
        & ( v51673(VarCurr,bitIndex4)
        <=> $false )
        & ( v51673(VarCurr,bitIndex3)
        <=> $false )
        & ( v51673(VarCurr,bitIndex2)
        <=> $false )
        & ( v51673(VarCurr,bitIndex1)
        <=> $false )
        & ( v51673(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10854,axiom,
    ! [VarCurr] :
      ( v51960(VarCurr)
    <=> ( v51961(VarCurr)
        | v51972(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3332,axiom,
    ! [VarCurr] :
      ( v51972(VarCurr)
    <=> ( ( v51673(VarCurr,bitIndex6)
        <=> $true )
        & ( v51673(VarCurr,bitIndex5)
        <=> $false )
        & ( v51673(VarCurr,bitIndex4)
        <=> $false )
        & ( v51673(VarCurr,bitIndex3)
        <=> $false )
        & ( v51673(VarCurr,bitIndex2)
        <=> $false )
        & ( v51673(VarCurr,bitIndex1)
        <=> $false )
        & ( v51673(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10853,axiom,
    ! [VarCurr] :
      ( v51961(VarCurr)
    <=> ( v51962(VarCurr)
        | v51971(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3331,axiom,
    ! [VarCurr] :
      ( v51971(VarCurr)
    <=> ( ( v51673(VarCurr,bitIndex6)
        <=> $true )
        & ( v51673(VarCurr,bitIndex5)
        <=> $false )
        & ( v51673(VarCurr,bitIndex4)
        <=> $false )
        & ( v51673(VarCurr,bitIndex3)
        <=> $false )
        & ( v51673(VarCurr,bitIndex2)
        <=> $false )
        & ( v51673(VarCurr,bitIndex1)
        <=> $true )
        & ( v51673(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10852,axiom,
    ! [VarCurr] :
      ( v51962(VarCurr)
    <=> ( v51963(VarCurr)
        | v51970(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3330,axiom,
    ! [VarCurr] :
      ( v51970(VarCurr)
    <=> ( ( v51673(VarCurr,bitIndex6)
        <=> $false )
        & ( v51673(VarCurr,bitIndex5)
        <=> $false )
        & ( v51673(VarCurr,bitIndex4)
        <=> $false )
        & ( v51673(VarCurr,bitIndex3)
        <=> $false )
        & ( v51673(VarCurr,bitIndex2)
        <=> $true )
        & ( v51673(VarCurr,bitIndex1)
        <=> $false )
        & ( v51673(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10851,axiom,
    ! [VarCurr] :
      ( v51963(VarCurr)
    <=> ( v51964(VarCurr)
        | v51969(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3329,axiom,
    ! [VarCurr] :
      ( v51969(VarCurr)
    <=> ( ( v51673(VarCurr,bitIndex6)
        <=> $false )
        & ( v51673(VarCurr,bitIndex5)
        <=> $false )
        & ( v51673(VarCurr,bitIndex4)
        <=> $false )
        & ( v51673(VarCurr,bitIndex3)
        <=> $false )
        & ( v51673(VarCurr,bitIndex2)
        <=> $true )
        & ( v51673(VarCurr,bitIndex1)
        <=> $false )
        & ( v51673(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10850,axiom,
    ! [VarCurr] :
      ( v51964(VarCurr)
    <=> ( v51965(VarCurr)
        | v51968(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3328,axiom,
    ! [VarCurr] :
      ( v51968(VarCurr)
    <=> ( ( v51673(VarCurr,bitIndex6)
        <=> $false )
        & ( v51673(VarCurr,bitIndex5)
        <=> $false )
        & ( v51673(VarCurr,bitIndex4)
        <=> $false )
        & ( v51673(VarCurr,bitIndex3)
        <=> $false )
        & ( v51673(VarCurr,bitIndex2)
        <=> $false )
        & ( v51673(VarCurr,bitIndex1)
        <=> $true )
        & ( v51673(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10849,axiom,
    ! [VarCurr] :
      ( v51965(VarCurr)
    <=> ( v51966(VarCurr)
        | v51967(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3327,axiom,
    ! [VarCurr] :
      ( v51967(VarCurr)
    <=> ( ( v51673(VarCurr,bitIndex6)
        <=> $false )
        & ( v51673(VarCurr,bitIndex5)
        <=> $true )
        & ( v51673(VarCurr,bitIndex4)
        <=> $false )
        & ( v51673(VarCurr,bitIndex3)
        <=> $false )
        & ( v51673(VarCurr,bitIndex2)
        <=> $false )
        & ( v51673(VarCurr,bitIndex1)
        <=> $false )
        & ( v51673(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3326,axiom,
    ! [VarCurr] :
      ( v51966(VarCurr)
    <=> ( ( v51673(VarCurr,bitIndex6)
        <=> $false )
        & ( v51673(VarCurr,bitIndex5)
        <=> $false )
        & ( v51673(VarCurr,bitIndex4)
        <=> $false )
        & ( v51673(VarCurr,bitIndex3)
        <=> $false )
        & ( v51673(VarCurr,bitIndex2)
        <=> $false )
        & ( v51673(VarCurr,bitIndex1)
        <=> $false )
        & ( v51673(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_19132,axiom,
    ! [VarCurr] :
      ( ( v51673(VarCurr,bitIndex6)
      <=> v51675(VarCurr,bitIndex69) )
      & ( v51673(VarCurr,bitIndex5)
      <=> v51675(VarCurr,bitIndex68) )
      & ( v51673(VarCurr,bitIndex4)
      <=> v51675(VarCurr,bitIndex67) )
      & ( v51673(VarCurr,bitIndex3)
      <=> v51675(VarCurr,bitIndex66) )
      & ( v51673(VarCurr,bitIndex2)
      <=> v51675(VarCurr,bitIndex65) )
      & ( v51673(VarCurr,bitIndex1)
      <=> v51675(VarCurr,bitIndex64) )
      & ( v51673(VarCurr,bitIndex0)
      <=> v51675(VarCurr,bitIndex63) ) ) ).

fof(addAssignment_19131,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v51675(VarCurr,B)
      <=> v51677(VarCurr,B) ) ) ).

fof(addAssignment_19130,axiom,
    ! [VarCurr] :
      ( ( v51677(VarCurr,bitIndex69)
      <=> v51679(VarCurr,bitIndex559) )
      & ( v51677(VarCurr,bitIndex68)
      <=> v51679(VarCurr,bitIndex558) )
      & ( v51677(VarCurr,bitIndex67)
      <=> v51679(VarCurr,bitIndex557) )
      & ( v51677(VarCurr,bitIndex66)
      <=> v51679(VarCurr,bitIndex556) )
      & ( v51677(VarCurr,bitIndex65)
      <=> v51679(VarCurr,bitIndex555) )
      & ( v51677(VarCurr,bitIndex64)
      <=> v51679(VarCurr,bitIndex554) )
      & ( v51677(VarCurr,bitIndex63)
      <=> v51679(VarCurr,bitIndex553) ) ) ).

fof(addAssignment_19129,axiom,
    ! [VarNext] :
      ( ( v51679(VarNext,bitIndex559)
      <=> v51923(VarNext,bitIndex69) )
      & ( v51679(VarNext,bitIndex558)
      <=> v51923(VarNext,bitIndex68) )
      & ( v51679(VarNext,bitIndex557)
      <=> v51923(VarNext,bitIndex67) )
      & ( v51679(VarNext,bitIndex556)
      <=> v51923(VarNext,bitIndex66) )
      & ( v51679(VarNext,bitIndex555)
      <=> v51923(VarNext,bitIndex65) )
      & ( v51679(VarNext,bitIndex554)
      <=> v51923(VarNext,bitIndex64) )
      & ( v51679(VarNext,bitIndex553)
      <=> v51923(VarNext,bitIndex63) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_92,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51924(VarNext)
       => ( ( v51923(VarNext,bitIndex69)
          <=> v51679(VarCurr,bitIndex559) )
          & ( v51923(VarNext,bitIndex68)
          <=> v51679(VarCurr,bitIndex558) )
          & ( v51923(VarNext,bitIndex67)
          <=> v51679(VarCurr,bitIndex557) )
          & ( v51923(VarNext,bitIndex66)
          <=> v51679(VarCurr,bitIndex556) )
          & ( v51923(VarNext,bitIndex65)
          <=> v51679(VarCurr,bitIndex555) )
          & ( v51923(VarNext,bitIndex64)
          <=> v51679(VarCurr,bitIndex554) )
          & ( v51923(VarNext,bitIndex63)
          <=> v51679(VarCurr,bitIndex553) )
          & ( v51923(VarNext,bitIndex62)
          <=> v51679(VarCurr,bitIndex552) )
          & ( v51923(VarNext,bitIndex61)
          <=> v51679(VarCurr,bitIndex551) )
          & ( v51923(VarNext,bitIndex60)
          <=> v51679(VarCurr,bitIndex550) )
          & ( v51923(VarNext,bitIndex59)
          <=> v51679(VarCurr,bitIndex549) )
          & ( v51923(VarNext,bitIndex58)
          <=> v51679(VarCurr,bitIndex548) )
          & ( v51923(VarNext,bitIndex57)
          <=> v51679(VarCurr,bitIndex547) )
          & ( v51923(VarNext,bitIndex56)
          <=> v51679(VarCurr,bitIndex546) )
          & ( v51923(VarNext,bitIndex55)
          <=> v51679(VarCurr,bitIndex545) )
          & ( v51923(VarNext,bitIndex54)
          <=> v51679(VarCurr,bitIndex544) )
          & ( v51923(VarNext,bitIndex53)
          <=> v51679(VarCurr,bitIndex543) )
          & ( v51923(VarNext,bitIndex52)
          <=> v51679(VarCurr,bitIndex542) )
          & ( v51923(VarNext,bitIndex51)
          <=> v51679(VarCurr,bitIndex541) )
          & ( v51923(VarNext,bitIndex50)
          <=> v51679(VarCurr,bitIndex540) )
          & ( v51923(VarNext,bitIndex49)
          <=> v51679(VarCurr,bitIndex539) )
          & ( v51923(VarNext,bitIndex48)
          <=> v51679(VarCurr,bitIndex538) )
          & ( v51923(VarNext,bitIndex47)
          <=> v51679(VarCurr,bitIndex537) )
          & ( v51923(VarNext,bitIndex46)
          <=> v51679(VarCurr,bitIndex536) )
          & ( v51923(VarNext,bitIndex45)
          <=> v51679(VarCurr,bitIndex535) )
          & ( v51923(VarNext,bitIndex44)
          <=> v51679(VarCurr,bitIndex534) )
          & ( v51923(VarNext,bitIndex43)
          <=> v51679(VarCurr,bitIndex533) )
          & ( v51923(VarNext,bitIndex42)
          <=> v51679(VarCurr,bitIndex532) )
          & ( v51923(VarNext,bitIndex41)
          <=> v51679(VarCurr,bitIndex531) )
          & ( v51923(VarNext,bitIndex40)
          <=> v51679(VarCurr,bitIndex530) )
          & ( v51923(VarNext,bitIndex39)
          <=> v51679(VarCurr,bitIndex529) )
          & ( v51923(VarNext,bitIndex38)
          <=> v51679(VarCurr,bitIndex528) )
          & ( v51923(VarNext,bitIndex37)
          <=> v51679(VarCurr,bitIndex527) )
          & ( v51923(VarNext,bitIndex36)
          <=> v51679(VarCurr,bitIndex526) )
          & ( v51923(VarNext,bitIndex35)
          <=> v51679(VarCurr,bitIndex525) )
          & ( v51923(VarNext,bitIndex34)
          <=> v51679(VarCurr,bitIndex524) )
          & ( v51923(VarNext,bitIndex33)
          <=> v51679(VarCurr,bitIndex523) )
          & ( v51923(VarNext,bitIndex32)
          <=> v51679(VarCurr,bitIndex522) )
          & ( v51923(VarNext,bitIndex31)
          <=> v51679(VarCurr,bitIndex521) )
          & ( v51923(VarNext,bitIndex30)
          <=> v51679(VarCurr,bitIndex520) )
          & ( v51923(VarNext,bitIndex29)
          <=> v51679(VarCurr,bitIndex519) )
          & ( v51923(VarNext,bitIndex28)
          <=> v51679(VarCurr,bitIndex518) )
          & ( v51923(VarNext,bitIndex27)
          <=> v51679(VarCurr,bitIndex517) )
          & ( v51923(VarNext,bitIndex26)
          <=> v51679(VarCurr,bitIndex516) )
          & ( v51923(VarNext,bitIndex25)
          <=> v51679(VarCurr,bitIndex515) )
          & ( v51923(VarNext,bitIndex24)
          <=> v51679(VarCurr,bitIndex514) )
          & ( v51923(VarNext,bitIndex23)
          <=> v51679(VarCurr,bitIndex513) )
          & ( v51923(VarNext,bitIndex22)
          <=> v51679(VarCurr,bitIndex512) )
          & ( v51923(VarNext,bitIndex21)
          <=> v51679(VarCurr,bitIndex511) )
          & ( v51923(VarNext,bitIndex20)
          <=> v51679(VarCurr,bitIndex510) )
          & ( v51923(VarNext,bitIndex19)
          <=> v51679(VarCurr,bitIndex509) )
          & ( v51923(VarNext,bitIndex18)
          <=> v51679(VarCurr,bitIndex508) )
          & ( v51923(VarNext,bitIndex17)
          <=> v51679(VarCurr,bitIndex507) )
          & ( v51923(VarNext,bitIndex16)
          <=> v51679(VarCurr,bitIndex506) )
          & ( v51923(VarNext,bitIndex15)
          <=> v51679(VarCurr,bitIndex505) )
          & ( v51923(VarNext,bitIndex14)
          <=> v51679(VarCurr,bitIndex504) )
          & ( v51923(VarNext,bitIndex13)
          <=> v51679(VarCurr,bitIndex503) )
          & ( v51923(VarNext,bitIndex12)
          <=> v51679(VarCurr,bitIndex502) )
          & ( v51923(VarNext,bitIndex11)
          <=> v51679(VarCurr,bitIndex501) )
          & ( v51923(VarNext,bitIndex10)
          <=> v51679(VarCurr,bitIndex500) )
          & ( v51923(VarNext,bitIndex9)
          <=> v51679(VarCurr,bitIndex499) )
          & ( v51923(VarNext,bitIndex8)
          <=> v51679(VarCurr,bitIndex498) )
          & ( v51923(VarNext,bitIndex7)
          <=> v51679(VarCurr,bitIndex497) )
          & ( v51923(VarNext,bitIndex6)
          <=> v51679(VarCurr,bitIndex496) )
          & ( v51923(VarNext,bitIndex5)
          <=> v51679(VarCurr,bitIndex495) )
          & ( v51923(VarNext,bitIndex4)
          <=> v51679(VarCurr,bitIndex494) )
          & ( v51923(VarNext,bitIndex3)
          <=> v51679(VarCurr,bitIndex493) )
          & ( v51923(VarNext,bitIndex2)
          <=> v51679(VarCurr,bitIndex492) )
          & ( v51923(VarNext,bitIndex1)
          <=> v51679(VarCurr,bitIndex491) )
          & ( v51923(VarNext,bitIndex0)
          <=> v51679(VarCurr,bitIndex490) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1063,axiom,
    ! [VarNext] :
      ( v51924(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v51923(VarNext,B)
          <=> v51950(VarNext,B) ) ) ) ).

fof(addAssignment_19128,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v51950(VarNext,B)
          <=> v51948(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1177,axiom,
    ! [VarCurr] :
      ( ~ v51841(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v51948(VarCurr,B)
          <=> v51951(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1142,axiom,
    ! [VarCurr] :
      ( v51841(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v51948(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_443,axiom,
    ! [VarCurr] :
      ( ( ~ v51937(VarCurr)
        & ~ v51939(VarCurr) )
     => ! [B] :
          ( range_69_0(B)
         => ( v51951(VarCurr,B)
          <=> v51916(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1176,axiom,
    ! [VarCurr] :
      ( v51939(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v51951(VarCurr,B)
          <=> v51909(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_46,axiom,
    ! [VarCurr] :
      ( v51937(VarCurr)
     => ( ( v51951(VarCurr,bitIndex69)
        <=> v51679(VarCurr,bitIndex489) )
        & ( v51951(VarCurr,bitIndex68)
        <=> v51679(VarCurr,bitIndex488) )
        & ( v51951(VarCurr,bitIndex67)
        <=> v51679(VarCurr,bitIndex487) )
        & ( v51951(VarCurr,bitIndex66)
        <=> v51679(VarCurr,bitIndex486) )
        & ( v51951(VarCurr,bitIndex65)
        <=> v51679(VarCurr,bitIndex485) )
        & ( v51951(VarCurr,bitIndex64)
        <=> v51679(VarCurr,bitIndex484) )
        & ( v51951(VarCurr,bitIndex63)
        <=> v51679(VarCurr,bitIndex483) )
        & ( v51951(VarCurr,bitIndex62)
        <=> v51679(VarCurr,bitIndex482) )
        & ( v51951(VarCurr,bitIndex61)
        <=> v51679(VarCurr,bitIndex481) )
        & ( v51951(VarCurr,bitIndex60)
        <=> v51679(VarCurr,bitIndex480) )
        & ( v51951(VarCurr,bitIndex59)
        <=> v51679(VarCurr,bitIndex479) )
        & ( v51951(VarCurr,bitIndex58)
        <=> v51679(VarCurr,bitIndex478) )
        & ( v51951(VarCurr,bitIndex57)
        <=> v51679(VarCurr,bitIndex477) )
        & ( v51951(VarCurr,bitIndex56)
        <=> v51679(VarCurr,bitIndex476) )
        & ( v51951(VarCurr,bitIndex55)
        <=> v51679(VarCurr,bitIndex475) )
        & ( v51951(VarCurr,bitIndex54)
        <=> v51679(VarCurr,bitIndex474) )
        & ( v51951(VarCurr,bitIndex53)
        <=> v51679(VarCurr,bitIndex473) )
        & ( v51951(VarCurr,bitIndex52)
        <=> v51679(VarCurr,bitIndex472) )
        & ( v51951(VarCurr,bitIndex51)
        <=> v51679(VarCurr,bitIndex471) )
        & ( v51951(VarCurr,bitIndex50)
        <=> v51679(VarCurr,bitIndex470) )
        & ( v51951(VarCurr,bitIndex49)
        <=> v51679(VarCurr,bitIndex469) )
        & ( v51951(VarCurr,bitIndex48)
        <=> v51679(VarCurr,bitIndex468) )
        & ( v51951(VarCurr,bitIndex47)
        <=> v51679(VarCurr,bitIndex467) )
        & ( v51951(VarCurr,bitIndex46)
        <=> v51679(VarCurr,bitIndex466) )
        & ( v51951(VarCurr,bitIndex45)
        <=> v51679(VarCurr,bitIndex465) )
        & ( v51951(VarCurr,bitIndex44)
        <=> v51679(VarCurr,bitIndex464) )
        & ( v51951(VarCurr,bitIndex43)
        <=> v51679(VarCurr,bitIndex463) )
        & ( v51951(VarCurr,bitIndex42)
        <=> v51679(VarCurr,bitIndex462) )
        & ( v51951(VarCurr,bitIndex41)
        <=> v51679(VarCurr,bitIndex461) )
        & ( v51951(VarCurr,bitIndex40)
        <=> v51679(VarCurr,bitIndex460) )
        & ( v51951(VarCurr,bitIndex39)
        <=> v51679(VarCurr,bitIndex459) )
        & ( v51951(VarCurr,bitIndex38)
        <=> v51679(VarCurr,bitIndex458) )
        & ( v51951(VarCurr,bitIndex37)
        <=> v51679(VarCurr,bitIndex457) )
        & ( v51951(VarCurr,bitIndex36)
        <=> v51679(VarCurr,bitIndex456) )
        & ( v51951(VarCurr,bitIndex35)
        <=> v51679(VarCurr,bitIndex455) )
        & ( v51951(VarCurr,bitIndex34)
        <=> v51679(VarCurr,bitIndex454) )
        & ( v51951(VarCurr,bitIndex33)
        <=> v51679(VarCurr,bitIndex453) )
        & ( v51951(VarCurr,bitIndex32)
        <=> v51679(VarCurr,bitIndex452) )
        & ( v51951(VarCurr,bitIndex31)
        <=> v51679(VarCurr,bitIndex451) )
        & ( v51951(VarCurr,bitIndex30)
        <=> v51679(VarCurr,bitIndex450) )
        & ( v51951(VarCurr,bitIndex29)
        <=> v51679(VarCurr,bitIndex449) )
        & ( v51951(VarCurr,bitIndex28)
        <=> v51679(VarCurr,bitIndex448) )
        & ( v51951(VarCurr,bitIndex27)
        <=> v51679(VarCurr,bitIndex447) )
        & ( v51951(VarCurr,bitIndex26)
        <=> v51679(VarCurr,bitIndex446) )
        & ( v51951(VarCurr,bitIndex25)
        <=> v51679(VarCurr,bitIndex445) )
        & ( v51951(VarCurr,bitIndex24)
        <=> v51679(VarCurr,bitIndex444) )
        & ( v51951(VarCurr,bitIndex23)
        <=> v51679(VarCurr,bitIndex443) )
        & ( v51951(VarCurr,bitIndex22)
        <=> v51679(VarCurr,bitIndex442) )
        & ( v51951(VarCurr,bitIndex21)
        <=> v51679(VarCurr,bitIndex441) )
        & ( v51951(VarCurr,bitIndex20)
        <=> v51679(VarCurr,bitIndex440) )
        & ( v51951(VarCurr,bitIndex19)
        <=> v51679(VarCurr,bitIndex439) )
        & ( v51951(VarCurr,bitIndex18)
        <=> v51679(VarCurr,bitIndex438) )
        & ( v51951(VarCurr,bitIndex17)
        <=> v51679(VarCurr,bitIndex437) )
        & ( v51951(VarCurr,bitIndex16)
        <=> v51679(VarCurr,bitIndex436) )
        & ( v51951(VarCurr,bitIndex15)
        <=> v51679(VarCurr,bitIndex435) )
        & ( v51951(VarCurr,bitIndex14)
        <=> v51679(VarCurr,bitIndex434) )
        & ( v51951(VarCurr,bitIndex13)
        <=> v51679(VarCurr,bitIndex433) )
        & ( v51951(VarCurr,bitIndex12)
        <=> v51679(VarCurr,bitIndex432) )
        & ( v51951(VarCurr,bitIndex11)
        <=> v51679(VarCurr,bitIndex431) )
        & ( v51951(VarCurr,bitIndex10)
        <=> v51679(VarCurr,bitIndex430) )
        & ( v51951(VarCurr,bitIndex9)
        <=> v51679(VarCurr,bitIndex429) )
        & ( v51951(VarCurr,bitIndex8)
        <=> v51679(VarCurr,bitIndex428) )
        & ( v51951(VarCurr,bitIndex7)
        <=> v51679(VarCurr,bitIndex427) )
        & ( v51951(VarCurr,bitIndex6)
        <=> v51679(VarCurr,bitIndex426) )
        & ( v51951(VarCurr,bitIndex5)
        <=> v51679(VarCurr,bitIndex425) )
        & ( v51951(VarCurr,bitIndex4)
        <=> v51679(VarCurr,bitIndex424) )
        & ( v51951(VarCurr,bitIndex3)
        <=> v51679(VarCurr,bitIndex423) )
        & ( v51951(VarCurr,bitIndex2)
        <=> v51679(VarCurr,bitIndex422) )
        & ( v51951(VarCurr,bitIndex1)
        <=> v51679(VarCurr,bitIndex421) )
        & ( v51951(VarCurr,bitIndex0)
        <=> v51679(VarCurr,bitIndex420) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10848,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51924(VarNext)
      <=> ( v51925(VarNext)
          & v51932(VarNext) ) ) ) ).

fof(addAssignment_19127,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51932(VarNext)
      <=> v51930(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10847,axiom,
    ! [VarCurr] :
      ( v51930(VarCurr)
    <=> ( v51933(VarCurr)
        & v51944(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10846,axiom,
    ! [VarCurr] :
      ( v51944(VarCurr)
    <=> ( v51945(VarCurr)
        | v51841(VarCurr) ) ) ).

fof(writeUnaryOperator_4578,axiom,
    ! [VarCurr] :
      ( ~ v51945(VarCurr)
    <=> v51946(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_3325,axiom,
    ! [VarCurr] :
      ( v51946(VarCurr)
    <=> ( ( v51947(VarCurr,bitIndex1)
        <=> $false )
        & ( v51947(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_19126,axiom,
    ! [VarCurr] :
      ( v51947(VarCurr,bitIndex0)
    <=> v51552(VarCurr) ) ).

fof(addAssignment_19125,axiom,
    ! [VarCurr] :
      ( v51947(VarCurr,bitIndex1)
    <=> v46431(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10845,axiom,
    ! [VarCurr] :
      ( v51933(VarCurr)
    <=> ( v51841(VarCurr)
        | v51934(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10844,axiom,
    ! [VarCurr] :
      ( v51934(VarCurr)
    <=> ( v51935(VarCurr)
        & v51943(VarCurr) ) ) ).

fof(writeUnaryOperator_4577,axiom,
    ! [VarCurr] :
      ( ~ v51943(VarCurr)
    <=> v51841(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10843,axiom,
    ! [VarCurr] :
      ( v51935(VarCurr)
    <=> ( v51936(VarCurr)
        | v51941(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3324,axiom,
    ! [VarCurr] :
      ( v51941(VarCurr)
    <=> ( ( v51942(VarCurr,bitIndex1)
        <=> $true )
        & ( v51942(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_19124,axiom,
    ! [VarCurr] :
      ( v51942(VarCurr,bitIndex0)
    <=> v51552(VarCurr) ) ).

fof(addAssignment_19123,axiom,
    ! [VarCurr] :
      ( v51942(VarCurr,bitIndex1)
    <=> v46431(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10842,axiom,
    ! [VarCurr] :
      ( v51936(VarCurr)
    <=> ( v51937(VarCurr)
        | v51939(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3323,axiom,
    ! [VarCurr] :
      ( v51939(VarCurr)
    <=> ( ( v51940(VarCurr,bitIndex1)
        <=> $true )
        & ( v51940(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_19122,axiom,
    ! [VarCurr] :
      ( v51940(VarCurr,bitIndex0)
    <=> v51552(VarCurr) ) ).

fof(addAssignment_19121,axiom,
    ! [VarCurr] :
      ( v51940(VarCurr,bitIndex1)
    <=> v46431(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_3322,axiom,
    ! [VarCurr] :
      ( v51937(VarCurr)
    <=> ( ( v51938(VarCurr,bitIndex1)
        <=> $false )
        & ( v51938(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_19120,axiom,
    ! [VarCurr] :
      ( v51938(VarCurr,bitIndex0)
    <=> v51552(VarCurr) ) ).

fof(addAssignment_19119,axiom,
    ! [VarCurr] :
      ( v51938(VarCurr,bitIndex1)
    <=> v46431(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10841,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51925(VarNext)
      <=> ( v51927(VarNext)
          & v51584(VarNext) ) ) ) ).

fof(writeUnaryOperator_4576,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51927(VarNext)
      <=> v51593(VarNext) ) ) ).

fof(addAssignment_19118,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v51916(VarCurr,B)
      <=> v51921(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1615,axiom,
    ! [VarCurr] :
      ( ~ v51918(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v51921(VarCurr,B)
          <=> v51920(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1450,axiom,
    ! [VarCurr] :
      ( v51918(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v51921(VarCurr,B)
          <=> v51742(VarCurr,B) ) ) ) ).

fof(addAssignment_19117,axiom,
    ! [VarCurr] :
      ( ( v51920(VarCurr,bitIndex69)
      <=> v51679(VarCurr,bitIndex489) )
      & ( v51920(VarCurr,bitIndex68)
      <=> v51679(VarCurr,bitIndex488) )
      & ( v51920(VarCurr,bitIndex67)
      <=> v51679(VarCurr,bitIndex487) )
      & ( v51920(VarCurr,bitIndex66)
      <=> v51679(VarCurr,bitIndex486) )
      & ( v51920(VarCurr,bitIndex65)
      <=> v51679(VarCurr,bitIndex485) )
      & ( v51920(VarCurr,bitIndex64)
      <=> v51679(VarCurr,bitIndex484) )
      & ( v51920(VarCurr,bitIndex63)
      <=> v51679(VarCurr,bitIndex483) ) ) ).

fof(addAssignment_19116,axiom,
    ! [VarCurr] :
      ( v51918(VarCurr)
    <=> v51686(VarCurr,bitIndex1) ) ).

fof(addAssignment_19115,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v51909(VarCurr,B)
      <=> v51914(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1614,axiom,
    ! [VarCurr] :
      ( ~ v51911(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v51914(VarCurr,B)
          <=> v51913(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1449,axiom,
    ! [VarCurr] :
      ( v51911(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v51914(VarCurr,B)
          <=> v51742(VarCurr,B) ) ) ) ).

fof(addAssignment_19114,axiom,
    ! [VarCurr] :
      ( ( v51913(VarCurr,bitIndex69)
      <=> v51679(VarCurr,bitIndex559) )
      & ( v51913(VarCurr,bitIndex68)
      <=> v51679(VarCurr,bitIndex558) )
      & ( v51913(VarCurr,bitIndex67)
      <=> v51679(VarCurr,bitIndex557) )
      & ( v51913(VarCurr,bitIndex66)
      <=> v51679(VarCurr,bitIndex556) )
      & ( v51913(VarCurr,bitIndex65)
      <=> v51679(VarCurr,bitIndex555) )
      & ( v51913(VarCurr,bitIndex64)
      <=> v51679(VarCurr,bitIndex554) )
      & ( v51913(VarCurr,bitIndex63)
      <=> v51679(VarCurr,bitIndex553) ) ) ).

fof(addAssignment_19113,axiom,
    ! [VarCurr] :
      ( v51911(VarCurr)
    <=> v51686(VarCurr,bitIndex1) ) ).

fof(addAssignment_19112,axiom,
    ! [VarNext] :
      ( ( v51679(VarNext,bitIndex489)
      <=> v51877(VarNext,bitIndex69) )
      & ( v51679(VarNext,bitIndex488)
      <=> v51877(VarNext,bitIndex68) )
      & ( v51679(VarNext,bitIndex487)
      <=> v51877(VarNext,bitIndex67) )
      & ( v51679(VarNext,bitIndex486)
      <=> v51877(VarNext,bitIndex66) )
      & ( v51679(VarNext,bitIndex485)
      <=> v51877(VarNext,bitIndex65) )
      & ( v51679(VarNext,bitIndex484)
      <=> v51877(VarNext,bitIndex64) )
      & ( v51679(VarNext,bitIndex483)
      <=> v51877(VarNext,bitIndex63) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_91,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51878(VarNext)
       => ( ( v51877(VarNext,bitIndex69)
          <=> v51679(VarCurr,bitIndex489) )
          & ( v51877(VarNext,bitIndex68)
          <=> v51679(VarCurr,bitIndex488) )
          & ( v51877(VarNext,bitIndex67)
          <=> v51679(VarCurr,bitIndex487) )
          & ( v51877(VarNext,bitIndex66)
          <=> v51679(VarCurr,bitIndex486) )
          & ( v51877(VarNext,bitIndex65)
          <=> v51679(VarCurr,bitIndex485) )
          & ( v51877(VarNext,bitIndex64)
          <=> v51679(VarCurr,bitIndex484) )
          & ( v51877(VarNext,bitIndex63)
          <=> v51679(VarCurr,bitIndex483) )
          & ( v51877(VarNext,bitIndex62)
          <=> v51679(VarCurr,bitIndex482) )
          & ( v51877(VarNext,bitIndex61)
          <=> v51679(VarCurr,bitIndex481) )
          & ( v51877(VarNext,bitIndex60)
          <=> v51679(VarCurr,bitIndex480) )
          & ( v51877(VarNext,bitIndex59)
          <=> v51679(VarCurr,bitIndex479) )
          & ( v51877(VarNext,bitIndex58)
          <=> v51679(VarCurr,bitIndex478) )
          & ( v51877(VarNext,bitIndex57)
          <=> v51679(VarCurr,bitIndex477) )
          & ( v51877(VarNext,bitIndex56)
          <=> v51679(VarCurr,bitIndex476) )
          & ( v51877(VarNext,bitIndex55)
          <=> v51679(VarCurr,bitIndex475) )
          & ( v51877(VarNext,bitIndex54)
          <=> v51679(VarCurr,bitIndex474) )
          & ( v51877(VarNext,bitIndex53)
          <=> v51679(VarCurr,bitIndex473) )
          & ( v51877(VarNext,bitIndex52)
          <=> v51679(VarCurr,bitIndex472) )
          & ( v51877(VarNext,bitIndex51)
          <=> v51679(VarCurr,bitIndex471) )
          & ( v51877(VarNext,bitIndex50)
          <=> v51679(VarCurr,bitIndex470) )
          & ( v51877(VarNext,bitIndex49)
          <=> v51679(VarCurr,bitIndex469) )
          & ( v51877(VarNext,bitIndex48)
          <=> v51679(VarCurr,bitIndex468) )
          & ( v51877(VarNext,bitIndex47)
          <=> v51679(VarCurr,bitIndex467) )
          & ( v51877(VarNext,bitIndex46)
          <=> v51679(VarCurr,bitIndex466) )
          & ( v51877(VarNext,bitIndex45)
          <=> v51679(VarCurr,bitIndex465) )
          & ( v51877(VarNext,bitIndex44)
          <=> v51679(VarCurr,bitIndex464) )
          & ( v51877(VarNext,bitIndex43)
          <=> v51679(VarCurr,bitIndex463) )
          & ( v51877(VarNext,bitIndex42)
          <=> v51679(VarCurr,bitIndex462) )
          & ( v51877(VarNext,bitIndex41)
          <=> v51679(VarCurr,bitIndex461) )
          & ( v51877(VarNext,bitIndex40)
          <=> v51679(VarCurr,bitIndex460) )
          & ( v51877(VarNext,bitIndex39)
          <=> v51679(VarCurr,bitIndex459) )
          & ( v51877(VarNext,bitIndex38)
          <=> v51679(VarCurr,bitIndex458) )
          & ( v51877(VarNext,bitIndex37)
          <=> v51679(VarCurr,bitIndex457) )
          & ( v51877(VarNext,bitIndex36)
          <=> v51679(VarCurr,bitIndex456) )
          & ( v51877(VarNext,bitIndex35)
          <=> v51679(VarCurr,bitIndex455) )
          & ( v51877(VarNext,bitIndex34)
          <=> v51679(VarCurr,bitIndex454) )
          & ( v51877(VarNext,bitIndex33)
          <=> v51679(VarCurr,bitIndex453) )
          & ( v51877(VarNext,bitIndex32)
          <=> v51679(VarCurr,bitIndex452) )
          & ( v51877(VarNext,bitIndex31)
          <=> v51679(VarCurr,bitIndex451) )
          & ( v51877(VarNext,bitIndex30)
          <=> v51679(VarCurr,bitIndex450) )
          & ( v51877(VarNext,bitIndex29)
          <=> v51679(VarCurr,bitIndex449) )
          & ( v51877(VarNext,bitIndex28)
          <=> v51679(VarCurr,bitIndex448) )
          & ( v51877(VarNext,bitIndex27)
          <=> v51679(VarCurr,bitIndex447) )
          & ( v51877(VarNext,bitIndex26)
          <=> v51679(VarCurr,bitIndex446) )
          & ( v51877(VarNext,bitIndex25)
          <=> v51679(VarCurr,bitIndex445) )
          & ( v51877(VarNext,bitIndex24)
          <=> v51679(VarCurr,bitIndex444) )
          & ( v51877(VarNext,bitIndex23)
          <=> v51679(VarCurr,bitIndex443) )
          & ( v51877(VarNext,bitIndex22)
          <=> v51679(VarCurr,bitIndex442) )
          & ( v51877(VarNext,bitIndex21)
          <=> v51679(VarCurr,bitIndex441) )
          & ( v51877(VarNext,bitIndex20)
          <=> v51679(VarCurr,bitIndex440) )
          & ( v51877(VarNext,bitIndex19)
          <=> v51679(VarCurr,bitIndex439) )
          & ( v51877(VarNext,bitIndex18)
          <=> v51679(VarCurr,bitIndex438) )
          & ( v51877(VarNext,bitIndex17)
          <=> v51679(VarCurr,bitIndex437) )
          & ( v51877(VarNext,bitIndex16)
          <=> v51679(VarCurr,bitIndex436) )
          & ( v51877(VarNext,bitIndex15)
          <=> v51679(VarCurr,bitIndex435) )
          & ( v51877(VarNext,bitIndex14)
          <=> v51679(VarCurr,bitIndex434) )
          & ( v51877(VarNext,bitIndex13)
          <=> v51679(VarCurr,bitIndex433) )
          & ( v51877(VarNext,bitIndex12)
          <=> v51679(VarCurr,bitIndex432) )
          & ( v51877(VarNext,bitIndex11)
          <=> v51679(VarCurr,bitIndex431) )
          & ( v51877(VarNext,bitIndex10)
          <=> v51679(VarCurr,bitIndex430) )
          & ( v51877(VarNext,bitIndex9)
          <=> v51679(VarCurr,bitIndex429) )
          & ( v51877(VarNext,bitIndex8)
          <=> v51679(VarCurr,bitIndex428) )
          & ( v51877(VarNext,bitIndex7)
          <=> v51679(VarCurr,bitIndex427) )
          & ( v51877(VarNext,bitIndex6)
          <=> v51679(VarCurr,bitIndex426) )
          & ( v51877(VarNext,bitIndex5)
          <=> v51679(VarCurr,bitIndex425) )
          & ( v51877(VarNext,bitIndex4)
          <=> v51679(VarCurr,bitIndex424) )
          & ( v51877(VarNext,bitIndex3)
          <=> v51679(VarCurr,bitIndex423) )
          & ( v51877(VarNext,bitIndex2)
          <=> v51679(VarCurr,bitIndex422) )
          & ( v51877(VarNext,bitIndex1)
          <=> v51679(VarCurr,bitIndex421) )
          & ( v51877(VarNext,bitIndex0)
          <=> v51679(VarCurr,bitIndex420) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1062,axiom,
    ! [VarNext] :
      ( v51878(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v51877(VarNext,B)
          <=> v51904(VarNext,B) ) ) ) ).

fof(addAssignment_19111,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v51904(VarNext,B)
          <=> v51902(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1175,axiom,
    ! [VarCurr] :
      ( ~ v51841(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v51902(VarCurr,B)
          <=> v51905(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1141,axiom,
    ! [VarCurr] :
      ( v51841(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v51902(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_442,axiom,
    ! [VarCurr] :
      ( ( ~ v51891(VarCurr)
        & ~ v51893(VarCurr) )
     => ! [B] :
          ( range_69_0(B)
         => ( v51905(VarCurr,B)
          <=> v51870(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1174,axiom,
    ! [VarCurr] :
      ( v51893(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v51905(VarCurr,B)
          <=> v51863(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_45,axiom,
    ! [VarCurr] :
      ( v51891(VarCurr)
     => ( ( v51905(VarCurr,bitIndex69)
        <=> v51679(VarCurr,bitIndex419) )
        & ( v51905(VarCurr,bitIndex68)
        <=> v51679(VarCurr,bitIndex418) )
        & ( v51905(VarCurr,bitIndex67)
        <=> v51679(VarCurr,bitIndex417) )
        & ( v51905(VarCurr,bitIndex66)
        <=> v51679(VarCurr,bitIndex416) )
        & ( v51905(VarCurr,bitIndex65)
        <=> v51679(VarCurr,bitIndex415) )
        & ( v51905(VarCurr,bitIndex64)
        <=> v51679(VarCurr,bitIndex414) )
        & ( v51905(VarCurr,bitIndex63)
        <=> v51679(VarCurr,bitIndex413) )
        & ( v51905(VarCurr,bitIndex62)
        <=> v51679(VarCurr,bitIndex412) )
        & ( v51905(VarCurr,bitIndex61)
        <=> v51679(VarCurr,bitIndex411) )
        & ( v51905(VarCurr,bitIndex60)
        <=> v51679(VarCurr,bitIndex410) )
        & ( v51905(VarCurr,bitIndex59)
        <=> v51679(VarCurr,bitIndex409) )
        & ( v51905(VarCurr,bitIndex58)
        <=> v51679(VarCurr,bitIndex408) )
        & ( v51905(VarCurr,bitIndex57)
        <=> v51679(VarCurr,bitIndex407) )
        & ( v51905(VarCurr,bitIndex56)
        <=> v51679(VarCurr,bitIndex406) )
        & ( v51905(VarCurr,bitIndex55)
        <=> v51679(VarCurr,bitIndex405) )
        & ( v51905(VarCurr,bitIndex54)
        <=> v51679(VarCurr,bitIndex404) )
        & ( v51905(VarCurr,bitIndex53)
        <=> v51679(VarCurr,bitIndex403) )
        & ( v51905(VarCurr,bitIndex52)
        <=> v51679(VarCurr,bitIndex402) )
        & ( v51905(VarCurr,bitIndex51)
        <=> v51679(VarCurr,bitIndex401) )
        & ( v51905(VarCurr,bitIndex50)
        <=> v51679(VarCurr,bitIndex400) )
        & ( v51905(VarCurr,bitIndex49)
        <=> v51679(VarCurr,bitIndex399) )
        & ( v51905(VarCurr,bitIndex48)
        <=> v51679(VarCurr,bitIndex398) )
        & ( v51905(VarCurr,bitIndex47)
        <=> v51679(VarCurr,bitIndex397) )
        & ( v51905(VarCurr,bitIndex46)
        <=> v51679(VarCurr,bitIndex396) )
        & ( v51905(VarCurr,bitIndex45)
        <=> v51679(VarCurr,bitIndex395) )
        & ( v51905(VarCurr,bitIndex44)
        <=> v51679(VarCurr,bitIndex394) )
        & ( v51905(VarCurr,bitIndex43)
        <=> v51679(VarCurr,bitIndex393) )
        & ( v51905(VarCurr,bitIndex42)
        <=> v51679(VarCurr,bitIndex392) )
        & ( v51905(VarCurr,bitIndex41)
        <=> v51679(VarCurr,bitIndex391) )
        & ( v51905(VarCurr,bitIndex40)
        <=> v51679(VarCurr,bitIndex390) )
        & ( v51905(VarCurr,bitIndex39)
        <=> v51679(VarCurr,bitIndex389) )
        & ( v51905(VarCurr,bitIndex38)
        <=> v51679(VarCurr,bitIndex388) )
        & ( v51905(VarCurr,bitIndex37)
        <=> v51679(VarCurr,bitIndex387) )
        & ( v51905(VarCurr,bitIndex36)
        <=> v51679(VarCurr,bitIndex386) )
        & ( v51905(VarCurr,bitIndex35)
        <=> v51679(VarCurr,bitIndex385) )
        & ( v51905(VarCurr,bitIndex34)
        <=> v51679(VarCurr,bitIndex384) )
        & ( v51905(VarCurr,bitIndex33)
        <=> v51679(VarCurr,bitIndex383) )
        & ( v51905(VarCurr,bitIndex32)
        <=> v51679(VarCurr,bitIndex382) )
        & ( v51905(VarCurr,bitIndex31)
        <=> v51679(VarCurr,bitIndex381) )
        & ( v51905(VarCurr,bitIndex30)
        <=> v51679(VarCurr,bitIndex380) )
        & ( v51905(VarCurr,bitIndex29)
        <=> v51679(VarCurr,bitIndex379) )
        & ( v51905(VarCurr,bitIndex28)
        <=> v51679(VarCurr,bitIndex378) )
        & ( v51905(VarCurr,bitIndex27)
        <=> v51679(VarCurr,bitIndex377) )
        & ( v51905(VarCurr,bitIndex26)
        <=> v51679(VarCurr,bitIndex376) )
        & ( v51905(VarCurr,bitIndex25)
        <=> v51679(VarCurr,bitIndex375) )
        & ( v51905(VarCurr,bitIndex24)
        <=> v51679(VarCurr,bitIndex374) )
        & ( v51905(VarCurr,bitIndex23)
        <=> v51679(VarCurr,bitIndex373) )
        & ( v51905(VarCurr,bitIndex22)
        <=> v51679(VarCurr,bitIndex372) )
        & ( v51905(VarCurr,bitIndex21)
        <=> v51679(VarCurr,bitIndex371) )
        & ( v51905(VarCurr,bitIndex20)
        <=> v51679(VarCurr,bitIndex370) )
        & ( v51905(VarCurr,bitIndex19)
        <=> v51679(VarCurr,bitIndex369) )
        & ( v51905(VarCurr,bitIndex18)
        <=> v51679(VarCurr,bitIndex368) )
        & ( v51905(VarCurr,bitIndex17)
        <=> v51679(VarCurr,bitIndex367) )
        & ( v51905(VarCurr,bitIndex16)
        <=> v51679(VarCurr,bitIndex366) )
        & ( v51905(VarCurr,bitIndex15)
        <=> v51679(VarCurr,bitIndex365) )
        & ( v51905(VarCurr,bitIndex14)
        <=> v51679(VarCurr,bitIndex364) )
        & ( v51905(VarCurr,bitIndex13)
        <=> v51679(VarCurr,bitIndex363) )
        & ( v51905(VarCurr,bitIndex12)
        <=> v51679(VarCurr,bitIndex362) )
        & ( v51905(VarCurr,bitIndex11)
        <=> v51679(VarCurr,bitIndex361) )
        & ( v51905(VarCurr,bitIndex10)
        <=> v51679(VarCurr,bitIndex360) )
        & ( v51905(VarCurr,bitIndex9)
        <=> v51679(VarCurr,bitIndex359) )
        & ( v51905(VarCurr,bitIndex8)
        <=> v51679(VarCurr,bitIndex358) )
        & ( v51905(VarCurr,bitIndex7)
        <=> v51679(VarCurr,bitIndex357) )
        & ( v51905(VarCurr,bitIndex6)
        <=> v51679(VarCurr,bitIndex356) )
        & ( v51905(VarCurr,bitIndex5)
        <=> v51679(VarCurr,bitIndex355) )
        & ( v51905(VarCurr,bitIndex4)
        <=> v51679(VarCurr,bitIndex354) )
        & ( v51905(VarCurr,bitIndex3)
        <=> v51679(VarCurr,bitIndex353) )
        & ( v51905(VarCurr,bitIndex2)
        <=> v51679(VarCurr,bitIndex352) )
        & ( v51905(VarCurr,bitIndex1)
        <=> v51679(VarCurr,bitIndex351) )
        & ( v51905(VarCurr,bitIndex0)
        <=> v51679(VarCurr,bitIndex350) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10840,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51878(VarNext)
      <=> ( v51879(VarNext)
          & v51886(VarNext) ) ) ) ).

fof(addAssignment_19110,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51886(VarNext)
      <=> v51884(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10839,axiom,
    ! [VarCurr] :
      ( v51884(VarCurr)
    <=> ( v51887(VarCurr)
        & v51898(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10838,axiom,
    ! [VarCurr] :
      ( v51898(VarCurr)
    <=> ( v51899(VarCurr)
        | v51841(VarCurr) ) ) ).

fof(writeUnaryOperator_4575,axiom,
    ! [VarCurr] :
      ( ~ v51899(VarCurr)
    <=> v51900(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_3321,axiom,
    ! [VarCurr] :
      ( v51900(VarCurr)
    <=> ( ( v51901(VarCurr,bitIndex1)
        <=> $false )
        & ( v51901(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_19109,axiom,
    ! [VarCurr] :
      ( v51901(VarCurr,bitIndex0)
    <=> v51552(VarCurr) ) ).

fof(addAssignment_19108,axiom,
    ! [VarCurr] :
      ( v51901(VarCurr,bitIndex1)
    <=> v46431(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10837,axiom,
    ! [VarCurr] :
      ( v51887(VarCurr)
    <=> ( v51841(VarCurr)
        | v51888(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10836,axiom,
    ! [VarCurr] :
      ( v51888(VarCurr)
    <=> ( v51889(VarCurr)
        & v51897(VarCurr) ) ) ).

fof(writeUnaryOperator_4574,axiom,
    ! [VarCurr] :
      ( ~ v51897(VarCurr)
    <=> v51841(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10835,axiom,
    ! [VarCurr] :
      ( v51889(VarCurr)
    <=> ( v51890(VarCurr)
        | v51895(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3320,axiom,
    ! [VarCurr] :
      ( v51895(VarCurr)
    <=> ( ( v51896(VarCurr,bitIndex1)
        <=> $true )
        & ( v51896(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_19107,axiom,
    ! [VarCurr] :
      ( v51896(VarCurr,bitIndex0)
    <=> v51552(VarCurr) ) ).

fof(addAssignment_19106,axiom,
    ! [VarCurr] :
      ( v51896(VarCurr,bitIndex1)
    <=> v46431(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10834,axiom,
    ! [VarCurr] :
      ( v51890(VarCurr)
    <=> ( v51891(VarCurr)
        | v51893(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3319,axiom,
    ! [VarCurr] :
      ( v51893(VarCurr)
    <=> ( ( v51894(VarCurr,bitIndex1)
        <=> $true )
        & ( v51894(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_19105,axiom,
    ! [VarCurr] :
      ( v51894(VarCurr,bitIndex0)
    <=> v51552(VarCurr) ) ).

fof(addAssignment_19104,axiom,
    ! [VarCurr] :
      ( v51894(VarCurr,bitIndex1)
    <=> v46431(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_3318,axiom,
    ! [VarCurr] :
      ( v51891(VarCurr)
    <=> ( ( v51892(VarCurr,bitIndex1)
        <=> $false )
        & ( v51892(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_19103,axiom,
    ! [VarCurr] :
      ( v51892(VarCurr,bitIndex0)
    <=> v51552(VarCurr) ) ).

fof(addAssignment_19102,axiom,
    ! [VarCurr] :
      ( v51892(VarCurr,bitIndex1)
    <=> v46431(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10833,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51879(VarNext)
      <=> ( v51881(VarNext)
          & v51584(VarNext) ) ) ) ).

fof(writeUnaryOperator_4573,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51881(VarNext)
      <=> v51593(VarNext) ) ) ).

fof(addAssignment_19101,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v51870(VarCurr,B)
      <=> v51875(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1613,axiom,
    ! [VarCurr] :
      ( ~ v51872(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v51875(VarCurr,B)
          <=> v51874(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1448,axiom,
    ! [VarCurr] :
      ( v51872(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v51875(VarCurr,B)
          <=> v51742(VarCurr,B) ) ) ) ).

fof(addAssignment_19100,axiom,
    ! [VarCurr] :
      ( ( v51874(VarCurr,bitIndex69)
      <=> v51679(VarCurr,bitIndex419) )
      & ( v51874(VarCurr,bitIndex68)
      <=> v51679(VarCurr,bitIndex418) )
      & ( v51874(VarCurr,bitIndex67)
      <=> v51679(VarCurr,bitIndex417) )
      & ( v51874(VarCurr,bitIndex66)
      <=> v51679(VarCurr,bitIndex416) )
      & ( v51874(VarCurr,bitIndex65)
      <=> v51679(VarCurr,bitIndex415) )
      & ( v51874(VarCurr,bitIndex64)
      <=> v51679(VarCurr,bitIndex414) )
      & ( v51874(VarCurr,bitIndex63)
      <=> v51679(VarCurr,bitIndex413) ) ) ).

fof(addAssignment_19099,axiom,
    ! [VarCurr] :
      ( v51872(VarCurr)
    <=> v51686(VarCurr,bitIndex2) ) ).

fof(addAssignment_19098,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v51863(VarCurr,B)
      <=> v51868(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1612,axiom,
    ! [VarCurr] :
      ( ~ v51865(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v51868(VarCurr,B)
          <=> v51867(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1447,axiom,
    ! [VarCurr] :
      ( v51865(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v51868(VarCurr,B)
          <=> v51742(VarCurr,B) ) ) ) ).

fof(addAssignment_19097,axiom,
    ! [VarCurr] :
      ( ( v51867(VarCurr,bitIndex69)
      <=> v51679(VarCurr,bitIndex489) )
      & ( v51867(VarCurr,bitIndex68)
      <=> v51679(VarCurr,bitIndex488) )
      & ( v51867(VarCurr,bitIndex67)
      <=> v51679(VarCurr,bitIndex487) )
      & ( v51867(VarCurr,bitIndex66)
      <=> v51679(VarCurr,bitIndex486) )
      & ( v51867(VarCurr,bitIndex65)
      <=> v51679(VarCurr,bitIndex485) )
      & ( v51867(VarCurr,bitIndex64)
      <=> v51679(VarCurr,bitIndex484) )
      & ( v51867(VarCurr,bitIndex63)
      <=> v51679(VarCurr,bitIndex483) ) ) ).

fof(addAssignment_19096,axiom,
    ! [VarCurr] :
      ( v51865(VarCurr)
    <=> v51686(VarCurr,bitIndex2) ) ).

fof(addAssignment_19095,axiom,
    ! [VarNext] :
      ( ( v51679(VarNext,bitIndex419)
      <=> v51830(VarNext,bitIndex69) )
      & ( v51679(VarNext,bitIndex418)
      <=> v51830(VarNext,bitIndex68) )
      & ( v51679(VarNext,bitIndex417)
      <=> v51830(VarNext,bitIndex67) )
      & ( v51679(VarNext,bitIndex416)
      <=> v51830(VarNext,bitIndex66) )
      & ( v51679(VarNext,bitIndex415)
      <=> v51830(VarNext,bitIndex65) )
      & ( v51679(VarNext,bitIndex414)
      <=> v51830(VarNext,bitIndex64) )
      & ( v51679(VarNext,bitIndex413)
      <=> v51830(VarNext,bitIndex63) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1_90,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51831(VarNext)
       => ( ( v51830(VarNext,bitIndex69)
          <=> v51679(VarCurr,bitIndex419) )
          & ( v51830(VarNext,bitIndex68)
          <=> v51679(VarCurr,bitIndex418) )
          & ( v51830(VarNext,bitIndex67)
          <=> v51679(VarCurr,bitIndex417) )
          & ( v51830(VarNext,bitIndex66)
          <=> v51679(VarCurr,bitIndex416) )
          & ( v51830(VarNext,bitIndex65)
          <=> v51679(VarCurr,bitIndex415) )
          & ( v51830(VarNext,bitIndex64)
          <=> v51679(VarCurr,bitIndex414) )
          & ( v51830(VarNext,bitIndex63)
          <=> v51679(VarCurr,bitIndex413) )
          & ( v51830(VarNext,bitIndex62)
          <=> v51679(VarCurr,bitIndex412) )
          & ( v51830(VarNext,bitIndex61)
          <=> v51679(VarCurr,bitIndex411) )
          & ( v51830(VarNext,bitIndex60)
          <=> v51679(VarCurr,bitIndex410) )
          & ( v51830(VarNext,bitIndex59)
          <=> v51679(VarCurr,bitIndex409) )
          & ( v51830(VarNext,bitIndex58)
          <=> v51679(VarCurr,bitIndex408) )
          & ( v51830(VarNext,bitIndex57)
          <=> v51679(VarCurr,bitIndex407) )
          & ( v51830(VarNext,bitIndex56)
          <=> v51679(VarCurr,bitIndex406) )
          & ( v51830(VarNext,bitIndex55)
          <=> v51679(VarCurr,bitIndex405) )
          & ( v51830(VarNext,bitIndex54)
          <=> v51679(VarCurr,bitIndex404) )
          & ( v51830(VarNext,bitIndex53)
          <=> v51679(VarCurr,bitIndex403) )
          & ( v51830(VarNext,bitIndex52)
          <=> v51679(VarCurr,bitIndex402) )
          & ( v51830(VarNext,bitIndex51)
          <=> v51679(VarCurr,bitIndex401) )
          & ( v51830(VarNext,bitIndex50)
          <=> v51679(VarCurr,bitIndex400) )
          & ( v51830(VarNext,bitIndex49)
          <=> v51679(VarCurr,bitIndex399) )
          & ( v51830(VarNext,bitIndex48)
          <=> v51679(VarCurr,bitIndex398) )
          & ( v51830(VarNext,bitIndex47)
          <=> v51679(VarCurr,bitIndex397) )
          & ( v51830(VarNext,bitIndex46)
          <=> v51679(VarCurr,bitIndex396) )
          & ( v51830(VarNext,bitIndex45)
          <=> v51679(VarCurr,bitIndex395) )
          & ( v51830(VarNext,bitIndex44)
          <=> v51679(VarCurr,bitIndex394) )
          & ( v51830(VarNext,bitIndex43)
          <=> v51679(VarCurr,bitIndex393) )
          & ( v51830(VarNext,bitIndex42)
          <=> v51679(VarCurr,bitIndex392) )
          & ( v51830(VarNext,bitIndex41)
          <=> v51679(VarCurr,bitIndex391) )
          & ( v51830(VarNext,bitIndex40)
          <=> v51679(VarCurr,bitIndex390) )
          & ( v51830(VarNext,bitIndex39)
          <=> v51679(VarCurr,bitIndex389) )
          & ( v51830(VarNext,bitIndex38)
          <=> v51679(VarCurr,bitIndex388) )
          & ( v51830(VarNext,bitIndex37)
          <=> v51679(VarCurr,bitIndex387) )
          & ( v51830(VarNext,bitIndex36)
          <=> v51679(VarCurr,bitIndex386) )
          & ( v51830(VarNext,bitIndex35)
          <=> v51679(VarCurr,bitIndex385) )
          & ( v51830(VarNext,bitIndex34)
          <=> v51679(VarCurr,bitIndex384) )
          & ( v51830(VarNext,bitIndex33)
          <=> v51679(VarCurr,bitIndex383) )
          & ( v51830(VarNext,bitIndex32)
          <=> v51679(VarCurr,bitIndex382) )
          & ( v51830(VarNext,bitIndex31)
          <=> v51679(VarCurr,bitIndex381) )
          & ( v51830(VarNext,bitIndex30)
          <=> v51679(VarCurr,bitIndex380) )
          & ( v51830(VarNext,bitIndex29)
          <=> v51679(VarCurr,bitIndex379) )
          & ( v51830(VarNext,bitIndex28)
          <=> v51679(VarCurr,bitIndex378) )
          & ( v51830(VarNext,bitIndex27)
          <=> v51679(VarCurr,bitIndex377) )
          & ( v51830(VarNext,bitIndex26)
          <=> v51679(VarCurr,bitIndex376) )
          & ( v51830(VarNext,bitIndex25)
          <=> v51679(VarCurr,bitIndex375) )
          & ( v51830(VarNext,bitIndex24)
          <=> v51679(VarCurr,bitIndex374) )
          & ( v51830(VarNext,bitIndex23)
          <=> v51679(VarCurr,bitIndex373) )
          & ( v51830(VarNext,bitIndex22)
          <=> v51679(VarCurr,bitIndex372) )
          & ( v51830(VarNext,bitIndex21)
          <=> v51679(VarCurr,bitIndex371) )
          & ( v51830(VarNext,bitIndex20)
          <=> v51679(VarCurr,bitIndex370) )
          & ( v51830(VarNext,bitIndex19)
          <=> v51679(VarCurr,bitIndex369) )
          & ( v51830(VarNext,bitIndex18)
          <=> v51679(VarCurr,bitIndex368) )
          & ( v51830(VarNext,bitIndex17)
          <=> v51679(VarCurr,bitIndex367) )
          & ( v51830(VarNext,bitIndex16)
          <=> v51679(VarCurr,bitIndex366) )
          & ( v51830(VarNext,bitIndex15)
          <=> v51679(VarCurr,bitIndex365) )
          & ( v51830(VarNext,bitIndex14)
          <=> v51679(VarCurr,bitIndex364) )
          & ( v51830(VarNext,bitIndex13)
          <=> v51679(VarCurr,bitIndex363) )
          & ( v51830(VarNext,bitIndex12)
          <=> v51679(VarCurr,bitIndex362) )
          & ( v51830(VarNext,bitIndex11)
          <=> v51679(VarCurr,bitIndex361) )
          & ( v51830(VarNext,bitIndex10)
          <=> v51679(VarCurr,bitIndex360) )
          & ( v51830(VarNext,bitIndex9)
          <=> v51679(VarCurr,bitIndex359) )
          & ( v51830(VarNext,bitIndex8)
          <=> v51679(VarCurr,bitIndex358) )
          & ( v51830(VarNext,bitIndex7)
          <=> v51679(VarCurr,bitIndex357) )
          & ( v51830(VarNext,bitIndex6)
          <=> v51679(VarCurr,bitIndex356) )
          & ( v51830(VarNext,bitIndex5)
          <=> v51679(VarCurr,bitIndex355) )
          & ( v51830(VarNext,bitIndex4)
          <=> v51679(VarCurr,bitIndex354) )
          & ( v51830(VarNext,bitIndex3)
          <=> v51679(VarCurr,bitIndex353) )
          & ( v51830(VarNext,bitIndex2)
          <=> v51679(VarCurr,bitIndex352) )
          & ( v51830(VarNext,bitIndex1)
          <=> v51679(VarCurr,bitIndex351) )
          & ( v51830(VarNext,bitIndex0)
          <=> v51679(VarCurr,bitIndex350) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1061,axiom,
    ! [VarNext] :
      ( v51831(VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v51830(VarNext,B)
          <=> v51858(VarNext,B) ) ) ) ).

fof(addAssignment_19094,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_69_0(B)
         => ( v51858(VarNext,B)
          <=> v51856(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1173,axiom,
    ! [VarCurr] :
      ( ~ v51841(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v51856(VarCurr,B)
          <=> v51859(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1140,axiom,
    ! [VarCurr] :
      ( v51841(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v51856(VarCurr,B)
          <=> $false ) ) ) ).

fof(bitBlastConstant_10589,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex69) ).

fof(bitBlastConstant_10588,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex68) ).

fof(bitBlastConstant_10587,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex67) ).

fof(bitBlastConstant_10586,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex66) ).

fof(bitBlastConstant_10585,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex65) ).

fof(bitBlastConstant_10584,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex64) ).

fof(bitBlastConstant_10583,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex63) ).

fof(bitBlastConstant_10582,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex62) ).

fof(bitBlastConstant_10581,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex61) ).

fof(bitBlastConstant_10580,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex60) ).

fof(bitBlastConstant_10579,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex59) ).

fof(bitBlastConstant_10578,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex58) ).

fof(bitBlastConstant_10577,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex57) ).

fof(bitBlastConstant_10576,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex56) ).

fof(bitBlastConstant_10575,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex55) ).

fof(bitBlastConstant_10574,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex54) ).

fof(bitBlastConstant_10573,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex53) ).

fof(bitBlastConstant_10572,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex52) ).

fof(bitBlastConstant_10571,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex51) ).

fof(bitBlastConstant_10570,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex50) ).

fof(bitBlastConstant_10569,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex49) ).

fof(bitBlastConstant_10568,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex48) ).

fof(bitBlastConstant_10567,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex47) ).

fof(bitBlastConstant_10566,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex46) ).

fof(bitBlastConstant_10565,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex45) ).

fof(bitBlastConstant_10564,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex44) ).

fof(bitBlastConstant_10563,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex43) ).

fof(bitBlastConstant_10562,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex42) ).

fof(bitBlastConstant_10561,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex41) ).

fof(bitBlastConstant_10560,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex40) ).

fof(bitBlastConstant_10559,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex39) ).

fof(bitBlastConstant_10558,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex38) ).

fof(bitBlastConstant_10557,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex37) ).

fof(bitBlastConstant_10556,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex36) ).

fof(bitBlastConstant_10555,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex35) ).

fof(bitBlastConstant_10554,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex34) ).

fof(bitBlastConstant_10553,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex33) ).

fof(bitBlastConstant_10552,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex32) ).

fof(bitBlastConstant_10551,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex31) ).

fof(bitBlastConstant_10550,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex30) ).

fof(bitBlastConstant_10549,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex29) ).

fof(bitBlastConstant_10548,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex28) ).

fof(bitBlastConstant_10547,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex27) ).

fof(bitBlastConstant_10546,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex26) ).

fof(bitBlastConstant_10545,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex25) ).

fof(bitBlastConstant_10544,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex24) ).

fof(bitBlastConstant_10543,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex23) ).

fof(bitBlastConstant_10542,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex22) ).

fof(bitBlastConstant_10541,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex21) ).

fof(bitBlastConstant_10540,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex20) ).

fof(bitBlastConstant_10539,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex19) ).

fof(bitBlastConstant_10538,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex18) ).

fof(bitBlastConstant_10537,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex17) ).

fof(bitBlastConstant_10536,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex16) ).

fof(bitBlastConstant_10535,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex15) ).

fof(bitBlastConstant_10534,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex14) ).

fof(bitBlastConstant_10533,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex13) ).

fof(bitBlastConstant_10532,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex12) ).

fof(bitBlastConstant_10531,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex11) ).

fof(bitBlastConstant_10530,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex10) ).

fof(bitBlastConstant_10529,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex9) ).

fof(bitBlastConstant_10528,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex8) ).

fof(bitBlastConstant_10527,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex7) ).

fof(bitBlastConstant_10526,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex6) ).

fof(bitBlastConstant_10525,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex5) ).

fof(bitBlastConstant_10524,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex4) ).

fof(bitBlastConstant_10523,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex3) ).

fof(bitBlastConstant_10522,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex2) ).

fof(bitBlastConstant_10521,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex1) ).

fof(bitBlastConstant_10520,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000000000(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges2_441,axiom,
    ! [VarCurr] :
      ( ( ~ v51845(VarCurr)
        & ~ v51847(VarCurr) )
     => ! [B] :
          ( range_69_0(B)
         => ( v51859(VarCurr,B)
          <=> v51823(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1172,axiom,
    ! [VarCurr] :
      ( v51847(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v51859(VarCurr,B)
          <=> v51682(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_44,axiom,
    ! [VarCurr] :
      ( v51845(VarCurr)
     => ( ( v51859(VarCurr,bitIndex69)
        <=> v51679(VarCurr,bitIndex349) )
        & ( v51859(VarCurr,bitIndex68)
        <=> v51679(VarCurr,bitIndex348) )
        & ( v51859(VarCurr,bitIndex67)
        <=> v51679(VarCurr,bitIndex347) )
        & ( v51859(VarCurr,bitIndex66)
        <=> v51679(VarCurr,bitIndex346) )
        & ( v51859(VarCurr,bitIndex65)
        <=> v51679(VarCurr,bitIndex345) )
        & ( v51859(VarCurr,bitIndex64)
        <=> v51679(VarCurr,bitIndex344) )
        & ( v51859(VarCurr,bitIndex63)
        <=> v51679(VarCurr,bitIndex343) )
        & ( v51859(VarCurr,bitIndex62)
        <=> v51679(VarCurr,bitIndex342) )
        & ( v51859(VarCurr,bitIndex61)
        <=> v51679(VarCurr,bitIndex341) )
        & ( v51859(VarCurr,bitIndex60)
        <=> v51679(VarCurr,bitIndex340) )
        & ( v51859(VarCurr,bitIndex59)
        <=> v51679(VarCurr,bitIndex339) )
        & ( v51859(VarCurr,bitIndex58)
        <=> v51679(VarCurr,bitIndex338) )
        & ( v51859(VarCurr,bitIndex57)
        <=> v51679(VarCurr,bitIndex337) )
        & ( v51859(VarCurr,bitIndex56)
        <=> v51679(VarCurr,bitIndex336) )
        & ( v51859(VarCurr,bitIndex55)
        <=> v51679(VarCurr,bitIndex335) )
        & ( v51859(VarCurr,bitIndex54)
        <=> v51679(VarCurr,bitIndex334) )
        & ( v51859(VarCurr,bitIndex53)
        <=> v51679(VarCurr,bitIndex333) )
        & ( v51859(VarCurr,bitIndex52)
        <=> v51679(VarCurr,bitIndex332) )
        & ( v51859(VarCurr,bitIndex51)
        <=> v51679(VarCurr,bitIndex331) )
        & ( v51859(VarCurr,bitIndex50)
        <=> v51679(VarCurr,bitIndex330) )
        & ( v51859(VarCurr,bitIndex49)
        <=> v51679(VarCurr,bitIndex329) )
        & ( v51859(VarCurr,bitIndex48)
        <=> v51679(VarCurr,bitIndex328) )
        & ( v51859(VarCurr,bitIndex47)
        <=> v51679(VarCurr,bitIndex327) )
        & ( v51859(VarCurr,bitIndex46)
        <=> v51679(VarCurr,bitIndex326) )
        & ( v51859(VarCurr,bitIndex45)
        <=> v51679(VarCurr,bitIndex325) )
        & ( v51859(VarCurr,bitIndex44)
        <=> v51679(VarCurr,bitIndex324) )
        & ( v51859(VarCurr,bitIndex43)
        <=> v51679(VarCurr,bitIndex323) )
        & ( v51859(VarCurr,bitIndex42)
        <=> v51679(VarCurr,bitIndex322) )
        & ( v51859(VarCurr,bitIndex41)
        <=> v51679(VarCurr,bitIndex321) )
        & ( v51859(VarCurr,bitIndex40)
        <=> v51679(VarCurr,bitIndex320) )
        & ( v51859(VarCurr,bitIndex39)
        <=> v51679(VarCurr,bitIndex319) )
        & ( v51859(VarCurr,bitIndex38)
        <=> v51679(VarCurr,bitIndex318) )
        & ( v51859(VarCurr,bitIndex37)
        <=> v51679(VarCurr,bitIndex317) )
        & ( v51859(VarCurr,bitIndex36)
        <=> v51679(VarCurr,bitIndex316) )
        & ( v51859(VarCurr,bitIndex35)
        <=> v51679(VarCurr,bitIndex315) )
        & ( v51859(VarCurr,bitIndex34)
        <=> v51679(VarCurr,bitIndex314) )
        & ( v51859(VarCurr,bitIndex33)
        <=> v51679(VarCurr,bitIndex313) )
        & ( v51859(VarCurr,bitIndex32)
        <=> v51679(VarCurr,bitIndex312) )
        & ( v51859(VarCurr,bitIndex31)
        <=> v51679(VarCurr,bitIndex311) )
        & ( v51859(VarCurr,bitIndex30)
        <=> v51679(VarCurr,bitIndex310) )
        & ( v51859(VarCurr,bitIndex29)
        <=> v51679(VarCurr,bitIndex309) )
        & ( v51859(VarCurr,bitIndex28)
        <=> v51679(VarCurr,bitIndex308) )
        & ( v51859(VarCurr,bitIndex27)
        <=> v51679(VarCurr,bitIndex307) )
        & ( v51859(VarCurr,bitIndex26)
        <=> v51679(VarCurr,bitIndex306) )
        & ( v51859(VarCurr,bitIndex25)
        <=> v51679(VarCurr,bitIndex305) )
        & ( v51859(VarCurr,bitIndex24)
        <=> v51679(VarCurr,bitIndex304) )
        & ( v51859(VarCurr,bitIndex23)
        <=> v51679(VarCurr,bitIndex303) )
        & ( v51859(VarCurr,bitIndex22)
        <=> v51679(VarCurr,bitIndex302) )
        & ( v51859(VarCurr,bitIndex21)
        <=> v51679(VarCurr,bitIndex301) )
        & ( v51859(VarCurr,bitIndex20)
        <=> v51679(VarCurr,bitIndex300) )
        & ( v51859(VarCurr,bitIndex19)
        <=> v51679(VarCurr,bitIndex299) )
        & ( v51859(VarCurr,bitIndex18)
        <=> v51679(VarCurr,bitIndex298) )
        & ( v51859(VarCurr,bitIndex17)
        <=> v51679(VarCurr,bitIndex297) )
        & ( v51859(VarCurr,bitIndex16)
        <=> v51679(VarCurr,bitIndex296) )
        & ( v51859(VarCurr,bitIndex15)
        <=> v51679(VarCurr,bitIndex295) )
        & ( v51859(VarCurr,bitIndex14)
        <=> v51679(VarCurr,bitIndex294) )
        & ( v51859(VarCurr,bitIndex13)
        <=> v51679(VarCurr,bitIndex293) )
        & ( v51859(VarCurr,bitIndex12)
        <=> v51679(VarCurr,bitIndex292) )
        & ( v51859(VarCurr,bitIndex11)
        <=> v51679(VarCurr,bitIndex291) )
        & ( v51859(VarCurr,bitIndex10)
        <=> v51679(VarCurr,bitIndex290) )
        & ( v51859(VarCurr,bitIndex9)
        <=> v51679(VarCurr,bitIndex289) )
        & ( v51859(VarCurr,bitIndex8)
        <=> v51679(VarCurr,bitIndex288) )
        & ( v51859(VarCurr,bitIndex7)
        <=> v51679(VarCurr,bitIndex287) )
        & ( v51859(VarCurr,bitIndex6)
        <=> v51679(VarCurr,bitIndex286) )
        & ( v51859(VarCurr,bitIndex5)
        <=> v51679(VarCurr,bitIndex285) )
        & ( v51859(VarCurr,bitIndex4)
        <=> v51679(VarCurr,bitIndex284) )
        & ( v51859(VarCurr,bitIndex3)
        <=> v51679(VarCurr,bitIndex283) )
        & ( v51859(VarCurr,bitIndex2)
        <=> v51679(VarCurr,bitIndex282) )
        & ( v51859(VarCurr,bitIndex1)
        <=> v51679(VarCurr,bitIndex281) )
        & ( v51859(VarCurr,bitIndex0)
        <=> v51679(VarCurr,bitIndex280) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10832,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51831(VarNext)
      <=> ( v51832(VarNext)
          & v51839(VarNext) ) ) ) ).

fof(addAssignment_19093,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51839(VarNext)
      <=> v51837(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10831,axiom,
    ! [VarCurr] :
      ( v51837(VarCurr)
    <=> ( v51840(VarCurr)
        & v51852(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10830,axiom,
    ! [VarCurr] :
      ( v51852(VarCurr)
    <=> ( v51853(VarCurr)
        | v51841(VarCurr) ) ) ).

fof(writeUnaryOperator_4572,axiom,
    ! [VarCurr] :
      ( ~ v51853(VarCurr)
    <=> v51854(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_3317,axiom,
    ! [VarCurr] :
      ( v51854(VarCurr)
    <=> ( ( v51855(VarCurr,bitIndex1)
        <=> $false )
        & ( v51855(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_19092,axiom,
    ! [VarCurr] :
      ( v51855(VarCurr,bitIndex0)
    <=> v51552(VarCurr) ) ).

fof(addAssignment_19091,axiom,
    ! [VarCurr] :
      ( v51855(VarCurr,bitIndex1)
    <=> v46431(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10829,axiom,
    ! [VarCurr] :
      ( v51840(VarCurr)
    <=> ( v51841(VarCurr)
        | v51842(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10828,axiom,
    ! [VarCurr] :
      ( v51842(VarCurr)
    <=> ( v51843(VarCurr)
        & v51851(VarCurr) ) ) ).

fof(writeUnaryOperator_4571,axiom,
    ! [VarCurr] :
      ( ~ v51851(VarCurr)
    <=> v51841(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10827,axiom,
    ! [VarCurr] :
      ( v51843(VarCurr)
    <=> ( v51844(VarCurr)
        | v51849(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3316,axiom,
    ! [VarCurr] :
      ( v51849(VarCurr)
    <=> ( ( v51850(VarCurr,bitIndex1)
        <=> $true )
        & ( v51850(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_19090,axiom,
    ! [VarCurr] :
      ( v51850(VarCurr,bitIndex0)
    <=> v51552(VarCurr) ) ).

fof(addAssignment_19089,axiom,
    ! [VarCurr] :
      ( v51850(VarCurr,bitIndex1)
    <=> v46431(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10826,axiom,
    ! [VarCurr] :
      ( v51844(VarCurr)
    <=> ( v51845(VarCurr)
        | v51847(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3315,axiom,
    ! [VarCurr] :
      ( v51847(VarCurr)
    <=> ( ( v51848(VarCurr,bitIndex1)
        <=> $true )
        & ( v51848(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_19088,axiom,
    ! [VarCurr] :
      ( v51848(VarCurr,bitIndex0)
    <=> v51552(VarCurr) ) ).

fof(addAssignment_19087,axiom,
    ! [VarCurr] :
      ( v51848(VarCurr,bitIndex1)
    <=> v46431(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_3314,axiom,
    ! [VarCurr] :
      ( v51845(VarCurr)
    <=> ( ( v51846(VarCurr,bitIndex1)
        <=> $false )
        & ( v51846(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_19086,axiom,
    ! [VarCurr] :
      ( v51846(VarCurr,bitIndex0)
    <=> v51552(VarCurr) ) ).

fof(addAssignment_19085,axiom,
    ! [VarCurr] :
      ( v51846(VarCurr,bitIndex1)
    <=> v46431(VarCurr) ) ).

fof(writeUnaryOperator_4570,axiom,
    ! [VarCurr] :
      ( ~ v51841(VarCurr)
    <=> v46425(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10825,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51832(VarNext)
      <=> ( v51833(VarNext)
          & v51584(VarNext) ) ) ) ).

fof(writeUnaryOperator_4569,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51833(VarNext)
      <=> v51593(VarNext) ) ) ).

fof(addAssignment_19084,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v51823(VarCurr,B)
      <=> v51828(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1611,axiom,
    ! [VarCurr] :
      ( ~ v51825(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v51828(VarCurr,B)
          <=> v51827(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1446,axiom,
    ! [VarCurr] :
      ( v51825(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v51828(VarCurr,B)
          <=> v51742(VarCurr,B) ) ) ) ).

fof(addAssignment_19083,axiom,
    ! [VarCurr] :
      ( ( v51827(VarCurr,bitIndex69)
      <=> v51679(VarCurr,bitIndex349) )
      & ( v51827(VarCurr,bitIndex68)
      <=> v51679(VarCurr,bitIndex348) )
      & ( v51827(VarCurr,bitIndex67)
      <=> v51679(VarCurr,bitIndex347) )
      & ( v51827(VarCurr,bitIndex66)
      <=> v51679(VarCurr,bitIndex346) )
      & ( v51827(VarCurr,bitIndex65)
      <=> v51679(VarCurr,bitIndex345) )
      & ( v51827(VarCurr,bitIndex64)
      <=> v51679(VarCurr,bitIndex344) )
      & ( v51827(VarCurr,bitIndex63)
      <=> v51679(VarCurr,bitIndex343) ) ) ).

fof(addAssignment_19082,axiom,
    ! [VarCurr] :
      ( v51825(VarCurr)
    <=> v51686(VarCurr,bitIndex3) ) ).

fof(addAssignment_19081,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v51682(VarCurr,B)
      <=> v51821(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1610,axiom,
    ! [VarCurr] :
      ( ~ v51684(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v51821(VarCurr,B)
          <=> v51820(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1445,axiom,
    ! [VarCurr] :
      ( v51684(VarCurr)
     => ! [B] :
          ( range_69_0(B)
         => ( v51821(VarCurr,B)
          <=> v51742(VarCurr,B) ) ) ) ).

fof(range_axiom_218,axiom,
    ! [B] :
      ( range_69_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B
        | bitIndex30 = B
        | bitIndex31 = B
        | bitIndex32 = B
        | bitIndex33 = B
        | bitIndex34 = B
        | bitIndex35 = B
        | bitIndex36 = B
        | bitIndex37 = B
        | bitIndex38 = B
        | bitIndex39 = B
        | bitIndex40 = B
        | bitIndex41 = B
        | bitIndex42 = B
        | bitIndex43 = B
        | bitIndex44 = B
        | bitIndex45 = B
        | bitIndex46 = B
        | bitIndex47 = B
        | bitIndex48 = B
        | bitIndex49 = B
        | bitIndex50 = B
        | bitIndex51 = B
        | bitIndex52 = B
        | bitIndex53 = B
        | bitIndex54 = B
        | bitIndex55 = B
        | bitIndex56 = B
        | bitIndex57 = B
        | bitIndex58 = B
        | bitIndex59 = B
        | bitIndex60 = B
        | bitIndex61 = B
        | bitIndex62 = B
        | bitIndex63 = B
        | bitIndex64 = B
        | bitIndex65 = B
        | bitIndex66 = B
        | bitIndex67 = B
        | bitIndex68 = B
        | bitIndex69 = B ) ) ).

fof(addAssignment_19080,axiom,
    ! [VarCurr] :
      ( ( v51820(VarCurr,bitIndex69)
      <=> v51679(VarCurr,bitIndex419) )
      & ( v51820(VarCurr,bitIndex68)
      <=> v51679(VarCurr,bitIndex418) )
      & ( v51820(VarCurr,bitIndex67)
      <=> v51679(VarCurr,bitIndex417) )
      & ( v51820(VarCurr,bitIndex66)
      <=> v51679(VarCurr,bitIndex416) )
      & ( v51820(VarCurr,bitIndex65)
      <=> v51679(VarCurr,bitIndex415) )
      & ( v51820(VarCurr,bitIndex64)
      <=> v51679(VarCurr,bitIndex414) )
      & ( v51820(VarCurr,bitIndex63)
      <=> v51679(VarCurr,bitIndex413) ) ) ).

fof(addAssignment_19079,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v51742(VarCurr,B)
      <=> v51744(VarCurr,B) ) ) ).

fof(addAssignment_19078,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v51744(VarCurr,B)
      <=> v51746(VarCurr,B) ) ) ).

fof(addAssignment_19077,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v51746(VarCurr,B)
      <=> v51748(VarCurr,B) ) ) ).

fof(addAssignment_19076,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v51748(VarCurr,B)
      <=> v51750(VarCurr,B) ) ) ).

fof(addAssignment_19075,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v51750(VarCurr,B)
      <=> v51752(VarCurr,B) ) ) ).

fof(addAssignment_19074,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v51752(VarCurr,B)
      <=> v51754(VarCurr,B) ) ) ).

fof(addAssignment_19073,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v51754(VarCurr,B)
      <=> v51808(VarCurr,B) ) ) ).

fof(range_axiom_217,axiom,
    ! [B] :
      ( range_69_63(B)
    <=> ( $false
        | bitIndex63 = B
        | bitIndex64 = B
        | bitIndex65 = B
        | bitIndex66 = B
        | bitIndex67 = B
        | bitIndex68 = B
        | bitIndex69 = B ) ) ).

fof(addAssignment_19072,axiom,
    ! [VarCurr,B] :
      ( range_5_0(B)
     => ( v51808(VarCurr,B)
      <=> v51817(VarCurr,B) ) ) ).

fof(addAssignment_19071,axiom,
    ! [VarCurr] :
      ( ( v51808(VarCurr,bitIndex10)
      <=> v51815(VarCurr,bitIndex4) )
      & ( v51808(VarCurr,bitIndex9)
      <=> v51815(VarCurr,bitIndex3) )
      & ( v51808(VarCurr,bitIndex8)
      <=> v51815(VarCurr,bitIndex2) )
      & ( v51808(VarCurr,bitIndex7)
      <=> v51815(VarCurr,bitIndex1) )
      & ( v51808(VarCurr,bitIndex6)
      <=> v51815(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_19070,axiom,
    ! [VarCurr] :
      ( ( v51808(VarCurr,bitIndex44)
      <=> v51813(VarCurr,bitIndex33) )
      & ( v51808(VarCurr,bitIndex43)
      <=> v51813(VarCurr,bitIndex32) )
      & ( v51808(VarCurr,bitIndex42)
      <=> v51813(VarCurr,bitIndex31) )
      & ( v51808(VarCurr,bitIndex41)
      <=> v51813(VarCurr,bitIndex30) )
      & ( v51808(VarCurr,bitIndex40)
      <=> v51813(VarCurr,bitIndex29) )
      & ( v51808(VarCurr,bitIndex39)
      <=> v51813(VarCurr,bitIndex28) )
      & ( v51808(VarCurr,bitIndex38)
      <=> v51813(VarCurr,bitIndex27) )
      & ( v51808(VarCurr,bitIndex37)
      <=> v51813(VarCurr,bitIndex26) )
      & ( v51808(VarCurr,bitIndex36)
      <=> v51813(VarCurr,bitIndex25) )
      & ( v51808(VarCurr,bitIndex35)
      <=> v51813(VarCurr,bitIndex24) )
      & ( v51808(VarCurr,bitIndex34)
      <=> v51813(VarCurr,bitIndex23) )
      & ( v51808(VarCurr,bitIndex33)
      <=> v51813(VarCurr,bitIndex22) )
      & ( v51808(VarCurr,bitIndex32)
      <=> v51813(VarCurr,bitIndex21) )
      & ( v51808(VarCurr,bitIndex31)
      <=> v51813(VarCurr,bitIndex20) )
      & ( v51808(VarCurr,bitIndex30)
      <=> v51813(VarCurr,bitIndex19) )
      & ( v51808(VarCurr,bitIndex29)
      <=> v51813(VarCurr,bitIndex18) )
      & ( v51808(VarCurr,bitIndex28)
      <=> v51813(VarCurr,bitIndex17) )
      & ( v51808(VarCurr,bitIndex27)
      <=> v51813(VarCurr,bitIndex16) )
      & ( v51808(VarCurr,bitIndex26)
      <=> v51813(VarCurr,bitIndex15) )
      & ( v51808(VarCurr,bitIndex25)
      <=> v51813(VarCurr,bitIndex14) )
      & ( v51808(VarCurr,bitIndex24)
      <=> v51813(VarCurr,bitIndex13) )
      & ( v51808(VarCurr,bitIndex23)
      <=> v51813(VarCurr,bitIndex12) )
      & ( v51808(VarCurr,bitIndex22)
      <=> v51813(VarCurr,bitIndex11) )
      & ( v51808(VarCurr,bitIndex21)
      <=> v51813(VarCurr,bitIndex10) )
      & ( v51808(VarCurr,bitIndex20)
      <=> v51813(VarCurr,bitIndex9) )
      & ( v51808(VarCurr,bitIndex19)
      <=> v51813(VarCurr,bitIndex8) )
      & ( v51808(VarCurr,bitIndex18)
      <=> v51813(VarCurr,bitIndex7) )
      & ( v51808(VarCurr,bitIndex17)
      <=> v51813(VarCurr,bitIndex6) )
      & ( v51808(VarCurr,bitIndex16)
      <=> v51813(VarCurr,bitIndex5) )
      & ( v51808(VarCurr,bitIndex15)
      <=> v51813(VarCurr,bitIndex4) )
      & ( v51808(VarCurr,bitIndex14)
      <=> v51813(VarCurr,bitIndex3) )
      & ( v51808(VarCurr,bitIndex13)
      <=> v51813(VarCurr,bitIndex2) )
      & ( v51808(VarCurr,bitIndex12)
      <=> v51813(VarCurr,bitIndex1) )
      & ( v51808(VarCurr,bitIndex11)
      <=> v51813(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_19069,axiom,
    ! [VarCurr] :
      ( ( v51808(VarCurr,bitIndex52)
      <=> v51811(VarCurr,bitIndex7) )
      & ( v51808(VarCurr,bitIndex51)
      <=> v51811(VarCurr,bitIndex6) )
      & ( v51808(VarCurr,bitIndex50)
      <=> v51811(VarCurr,bitIndex5) )
      & ( v51808(VarCurr,bitIndex49)
      <=> v51811(VarCurr,bitIndex4) )
      & ( v51808(VarCurr,bitIndex48)
      <=> v51811(VarCurr,bitIndex3) )
      & ( v51808(VarCurr,bitIndex47)
      <=> v51811(VarCurr,bitIndex2) )
      & ( v51808(VarCurr,bitIndex46)
      <=> v51811(VarCurr,bitIndex1) )
      & ( v51808(VarCurr,bitIndex45)
      <=> v51811(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_19068,axiom,
    ! [VarCurr] :
      ( ( v51808(VarCurr,bitIndex62)
      <=> v51809(VarCurr,bitIndex9) )
      & ( v51808(VarCurr,bitIndex61)
      <=> v51809(VarCurr,bitIndex8) )
      & ( v51808(VarCurr,bitIndex60)
      <=> v51809(VarCurr,bitIndex7) )
      & ( v51808(VarCurr,bitIndex59)
      <=> v51809(VarCurr,bitIndex6) )
      & ( v51808(VarCurr,bitIndex58)
      <=> v51809(VarCurr,bitIndex5) )
      & ( v51808(VarCurr,bitIndex57)
      <=> v51809(VarCurr,bitIndex4) )
      & ( v51808(VarCurr,bitIndex56)
      <=> v51809(VarCurr,bitIndex3) )
      & ( v51808(VarCurr,bitIndex55)
      <=> v51809(VarCurr,bitIndex2) )
      & ( v51808(VarCurr,bitIndex54)
      <=> v51809(VarCurr,bitIndex1) )
      & ( v51808(VarCurr,bitIndex53)
      <=> v51809(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_19067,axiom,
    ! [VarCurr] :
      ( ( v51808(VarCurr,bitIndex69)
      <=> v51756(VarCurr,bitIndex6) )
      & ( v51808(VarCurr,bitIndex68)
      <=> v51756(VarCurr,bitIndex5) )
      & ( v51808(VarCurr,bitIndex67)
      <=> v51756(VarCurr,bitIndex4) )
      & ( v51808(VarCurr,bitIndex66)
      <=> v51756(VarCurr,bitIndex3) )
      & ( v51808(VarCurr,bitIndex65)
      <=> v51756(VarCurr,bitIndex2) )
      & ( v51808(VarCurr,bitIndex64)
      <=> v51756(VarCurr,bitIndex1) )
      & ( v51808(VarCurr,bitIndex63)
      <=> v51756(VarCurr,bitIndex0) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_998,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51768(VarNext)
       => ! [B] :
            ( range_6_0(B)
           => ( v51756(VarNext,B)
            <=> v51756(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1060,axiom,
    ! [VarNext] :
      ( v51768(VarNext)
     => ! [B] :
          ( range_6_0(B)
         => ( v51756(VarNext,B)
          <=> v51803(VarNext,B) ) ) ) ).

fof(addAssignment_19066,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_6_0(B)
         => ( v51803(VarNext,B)
          <=> v51801(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1171,axiom,
    ! [VarCurr] :
      ( ~ v51778(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v51801(VarCurr,B)
          <=> v51804(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1139,axiom,
    ! [VarCurr] :
      ( v51778(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v51801(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1170,axiom,
    ! [VarCurr] :
      ( ~ v51781(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v51804(VarCurr,B)
          <=> v49551(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1138,axiom,
    ! [VarCurr] :
      ( v51781(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v51804(VarCurr,B)
          <=> v51805(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges1_11,axiom,
    ! [VarCurr] :
      ( ~ v51792(VarCurr)
     => ( ( v51805(VarCurr,bitIndex6)
        <=> v49528(VarCurr,bitIndex53) )
        & ( v51805(VarCurr,bitIndex5)
        <=> v49528(VarCurr,bitIndex52) )
        & ( v51805(VarCurr,bitIndex4)
        <=> v49528(VarCurr,bitIndex51) )
        & ( v51805(VarCurr,bitIndex3)
        <=> v49528(VarCurr,bitIndex50) )
        & ( v51805(VarCurr,bitIndex2)
        <=> v49528(VarCurr,bitIndex49) )
        & ( v51805(VarCurr,bitIndex1)
        <=> v49528(VarCurr,bitIndex48) )
        & ( v51805(VarCurr,bitIndex0)
        <=> v49528(VarCurr,bitIndex47) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1137,axiom,
    ! [VarCurr] :
      ( v51792(VarCurr)
     => ! [B] :
          ( range_6_0(B)
         => ( v51805(VarCurr,B)
          <=> v49551(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10824,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51768(VarNext)
      <=> ( v51769(VarNext)
          & v51776(VarNext) ) ) ) ).

fof(addAssignment_19065,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51776(VarNext)
      <=> v51774(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10823,axiom,
    ! [VarCurr] :
      ( v51774(VarCurr)
    <=> ( v51777(VarCurr)
        & v51784(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10822,axiom,
    ! [VarCurr] :
      ( v51784(VarCurr)
    <=> ( v51785(VarCurr)
        | v51778(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10821,axiom,
    ! [VarCurr] :
      ( v51785(VarCurr)
    <=> ( v51786(VarCurr)
        & v51799(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10820,axiom,
    ! [VarCurr] :
      ( v51799(VarCurr)
    <=> ( v51800(VarCurr)
        | v51782(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10819,axiom,
    ! [VarCurr] :
      ( v51800(VarCurr)
    <=> ( v51789(VarCurr)
        | v51781(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10818,axiom,
    ! [VarCurr] :
      ( v51786(VarCurr)
    <=> ( v51787(VarCurr)
        & v51797(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10817,axiom,
    ! [VarCurr] :
      ( v51797(VarCurr)
    <=> ( v46445(VarCurr)
        | v51798(VarCurr) ) ) ).

fof(writeUnaryOperator_4568,axiom,
    ! [VarCurr] :
      ( ~ v51798(VarCurr)
    <=> v51782(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10816,axiom,
    ! [VarCurr] :
      ( v51787(VarCurr)
    <=> ( v51788(VarCurr)
        & v51790(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10815,axiom,
    ! [VarCurr] :
      ( v51790(VarCurr)
    <=> ( v51791(VarCurr)
        | v51796(VarCurr) ) ) ).

fof(writeUnaryOperator_4567,axiom,
    ! [VarCurr] :
      ( ~ v51796(VarCurr)
    <=> v51781(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10814,axiom,
    ! [VarCurr] :
      ( v51791(VarCurr)
    <=> ( v51792(VarCurr)
        | v51794(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3313,axiom,
    ! [VarCurr] :
      ( v51794(VarCurr)
    <=> ( ( v51795(VarCurr,bitIndex1)
        <=> $true )
        & ( v51795(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_19064,axiom,
    ! [VarCurr] :
      ( v51795(VarCurr,bitIndex0)
    <=> v47899(VarCurr) ) ).

fof(addAssignment_19063,axiom,
    ! [VarCurr] :
      ( v51795(VarCurr,bitIndex1)
    <=> v51758(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_3312,axiom,
    ! [VarCurr] :
      ( v51792(VarCurr)
    <=> ( ( v51793(VarCurr,bitIndex1)
        <=> $true )
        & ( v51793(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_19062,axiom,
    ! [VarCurr] :
      ( v51793(VarCurr,bitIndex0)
    <=> v47899(VarCurr) ) ).

fof(addAssignment_19061,axiom,
    ! [VarCurr] :
      ( v51793(VarCurr,bitIndex1)
    <=> v51758(VarCurr) ) ).

fof(writeUnaryOperator_4566,axiom,
    ! [VarCurr] :
      ( ~ v51788(VarCurr)
    <=> v51789(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_3311,axiom,
    ! [VarCurr] :
      ( v51789(VarCurr)
    <=> ( ( v46447(VarCurr,bitIndex2)
        <=> $false )
        & ( v46447(VarCurr,bitIndex1)
        <=> $false )
        & ( v46447(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10813,axiom,
    ! [VarCurr] :
      ( v51777(VarCurr)
    <=> ( v51778(VarCurr)
        | v51779(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10812,axiom,
    ! [VarCurr] :
      ( v51779(VarCurr)
    <=> ( v51780(VarCurr)
        & v51783(VarCurr) ) ) ).

fof(writeUnaryOperator_4565,axiom,
    ! [VarCurr] :
      ( ~ v51783(VarCurr)
    <=> v51778(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10811,axiom,
    ! [VarCurr] :
      ( v51780(VarCurr)
    <=> ( v51781(VarCurr)
        | v51782(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3310,axiom,
    ! [VarCurr] :
      ( v51782(VarCurr)
    <=> ( ( v46447(VarCurr,bitIndex2)
        <=> $false )
        & ( v46447(VarCurr,bitIndex1)
        <=> $true )
        & ( v46447(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3309,axiom,
    ! [VarCurr] :
      ( v51781(VarCurr)
    <=> ( ( v46447(VarCurr,bitIndex2)
        <=> $false )
        & ( v46447(VarCurr,bitIndex1)
        <=> $true )
        & ( v46447(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeUnaryOperator_4564,axiom,
    ! [VarCurr] :
      ( ~ v51778(VarCurr)
    <=> v45(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10810,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51769(VarNext)
      <=> ( v51770(VarNext)
          & v45620(VarNext) ) ) ) ).

fof(writeUnaryOperator_4563,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51770(VarNext)
      <=> v47885(VarNext) ) ) ).

fof(addAssignment_19060,axiom,
    ! [VarCurr,B] :
      ( range_53_47(B)
     => ( v49528(VarCurr,B)
      <=> v49530(VarCurr,B) ) ) ).

fof(addAssignment_19059,axiom,
    ! [VarCurr,B] :
      ( range_53_47(B)
     => ( v49530(VarCurr,B)
      <=> v49532(VarCurr,B) ) ) ).

fof(addAssignment_19058,axiom,
    ! [VarCurr,B] :
      ( range_53_47(B)
     => ( v49532(VarCurr,B)
      <=> v49534(VarCurr,B) ) ) ).

fof(addAssignment_19057,axiom,
    ! [VarCurr,B] :
      ( range_53_47(B)
     => ( v49534(VarCurr,B)
      <=> v49917(VarCurr,B) ) ) ).

fof(range_axiom_216,axiom,
    ! [B] :
      ( range_53_47(B)
    <=> ( $false
        | bitIndex47 = B
        | bitIndex48 = B
        | bitIndex49 = B
        | bitIndex50 = B
        | bitIndex51 = B
        | bitIndex52 = B
        | bitIndex53 = B ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_128,axiom,
    ! [VarCurr] :
      ( ( ~ v51502(VarCurr)
        & ~ v51503(VarCurr)
        & ~ v51534(VarCurr) )
     => ( v51758(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_440,axiom,
    ! [VarCurr] :
      ( v51534(VarCurr)
     => ( v51758(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1169,axiom,
    ! [VarCurr] :
      ( v51503(VarCurr)
     => ( v51758(VarCurr)
      <=> v51760(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1136,axiom,
    ! [VarCurr] :
      ( v51502(VarCurr)
     => ( v51758(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1168,axiom,
    ! [VarCurr] :
      ( ~ v51505(VarCurr)
     => ( v51760(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1135,axiom,
    ! [VarCurr] :
      ( v51505(VarCurr)
     => ( v51760(VarCurr)
      <=> v51761(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_127,axiom,
    ! [VarCurr] :
      ( ( ~ v51507(VarCurr)
        & ~ v51509(VarCurr)
        & ~ v51523(VarCurr) )
     => ( v51761(VarCurr)
      <=> v51764(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_439,axiom,
    ! [VarCurr] :
      ( v51523(VarCurr)
     => ( v51761(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1167,axiom,
    ! [VarCurr] :
      ( v51509(VarCurr)
     => ( v51761(VarCurr)
      <=> v51762(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1134,axiom,
    ! [VarCurr] :
      ( v51507(VarCurr)
     => ( v51761(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1166,axiom,
    ! [VarCurr] :
      ( ~ v51528(VarCurr)
     => ( v51764(VarCurr)
      <=> v51765(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1133,axiom,
    ! [VarCurr] :
      ( v51528(VarCurr)
     => ( v51764(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1165,axiom,
    ! [VarCurr] :
      ( ~ v51531(VarCurr)
     => ( v51765(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1132,axiom,
    ! [VarCurr] :
      ( v51531(VarCurr)
     => ( v51765(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1164,axiom,
    ! [VarCurr] :
      ( ~ v51763(VarCurr)
     => ( v51762(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1131,axiom,
    ! [VarCurr] :
      ( v51763(VarCurr)
     => ( v51762(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10809,axiom,
    ! [VarCurr] :
      ( v51763(VarCurr)
    <=> ( v51513(VarCurr)
        | v51518(VarCurr) ) ) ).

fof(addAssignment_19056,axiom,
    ! [VarCurr] :
      ( v51684(VarCurr)
    <=> v51686(VarCurr,bitIndex3) ) ).

fof(addAssignment_19055,axiom,
    ! [VarCurr] :
      ( v51686(VarCurr,bitIndex3)
    <=> v51701(VarCurr,bitIndex3) ) ).

fof(addAssignment_19054,axiom,
    ! [VarNext] :
      ( v51646(VarNext,bitIndex2)
    <=> v51734(VarNext,bitIndex2) ) ).

fof(addCaseBooleanConditionEqualRanges1_997,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51735(VarNext)
       => ! [B] :
            ( range_10_0(B)
           => ( v51734(VarNext,B)
            <=> v51646(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1059,axiom,
    ! [VarNext] :
      ( v51735(VarNext)
     => ! [B] :
          ( range_10_0(B)
         => ( v51734(VarNext,B)
          <=> v51698(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10808,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51735(VarNext)
      <=> v51736(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10807,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51736(VarNext)
      <=> ( v51738(VarNext)
          & v51584(VarNext) ) ) ) ).

fof(writeUnaryOperator_4562,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51738(VarNext)
      <=> v51593(VarNext) ) ) ).

fof(addAssignment_19053,axiom,
    ! [VarCurr] :
      ( v51686(VarCurr,bitIndex2)
    <=> v51701(VarCurr,bitIndex2) ) ).

fof(addAssignment_19052,axiom,
    ! [VarNext] :
      ( v51646(VarNext,bitIndex1)
    <=> v51726(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_996,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51727(VarNext)
       => ! [B] :
            ( range_10_0(B)
           => ( v51726(VarNext,B)
            <=> v51646(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1058,axiom,
    ! [VarNext] :
      ( v51727(VarNext)
     => ! [B] :
          ( range_10_0(B)
         => ( v51726(VarNext,B)
          <=> v51698(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10806,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51727(VarNext)
      <=> v51728(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10805,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51728(VarNext)
      <=> ( v51730(VarNext)
          & v51584(VarNext) ) ) ) ).

fof(writeUnaryOperator_4561,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51730(VarNext)
      <=> v51593(VarNext) ) ) ).

fof(addAssignment_19051,axiom,
    ! [VarCurr] :
      ( v51686(VarCurr,bitIndex1)
    <=> v51701(VarCurr,bitIndex1) ) ).

fof(addAssignment_19050,axiom,
    ! [VarNext] :
      ( v51646(VarNext,bitIndex0)
    <=> v51718(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionEqualRanges1_995,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51719(VarNext)
       => ! [B] :
            ( range_10_0(B)
           => ( v51718(VarNext,B)
            <=> v51646(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1057,axiom,
    ! [VarNext] :
      ( v51719(VarNext)
     => ! [B] :
          ( range_10_0(B)
         => ( v51718(VarNext,B)
          <=> v51698(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10804,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51719(VarNext)
      <=> v51720(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10803,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51720(VarNext)
      <=> ( v51722(VarNext)
          & v51584(VarNext) ) ) ) ).

fof(writeUnaryOperator_4560,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51722(VarNext)
      <=> v51593(VarNext) ) ) ).

fof(addAssignment_19049,axiom,
    ! [VarCurr] :
      ( v51686(VarCurr,bitIndex0)
    <=> v51701(VarCurr,bitIndex0) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1609,axiom,
    ! [VarCurr] :
      ( ~ v51702(VarCurr)
     => ! [B] :
          ( range_10_0(B)
         => ( v51701(VarCurr,B)
          <=> v51704(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1444,axiom,
    ! [VarCurr] :
      ( v51702(VarCurr)
     => ! [B] :
          ( range_10_0(B)
         => ( v51701(VarCurr,B)
          <=> v51703(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_126,axiom,
    ! [VarCurr] :
      ( ( ~ v51705(VarCurr)
        & ~ v51707(VarCurr)
        & ~ v51711(VarCurr) )
     => ! [B] :
          ( range_10_0(B)
         => ( v51704(VarCurr,B)
          <=> v51646(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_438,axiom,
    ! [VarCurr] :
      ( v51711(VarCurr)
     => ! [B] :
          ( range_10_0(B)
         => ( v51704(VarCurr,B)
          <=> v51713(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1163,axiom,
    ! [VarCurr] :
      ( v51707(VarCurr)
     => ! [B] :
          ( range_10_0(B)
         => ( v51704(VarCurr,B)
          <=> v51709(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1130,axiom,
    ! [VarCurr] :
      ( v51705(VarCurr)
     => ! [B] :
          ( range_10_0(B)
         => ( v51704(VarCurr,B)
          <=> v51646(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3308,axiom,
    ! [VarCurr] :
      ( v51715(VarCurr)
    <=> ( ( v51716(VarCurr,bitIndex1)
        <=> $true )
        & ( v51716(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_19048,axiom,
    ! [VarCurr] :
      ( v51716(VarCurr,bitIndex0)
    <=> v51552(VarCurr) ) ).

fof(addAssignment_19047,axiom,
    ! [VarCurr] :
      ( v51716(VarCurr,bitIndex1)
    <=> v46431(VarCurr) ) ).

fof(addAssignment_19046,axiom,
    ! [VarCurr] :
      ( v51713(VarCurr,bitIndex0)
    <=> $false ) ).

fof(addAssignment_19045,axiom,
    ! [VarCurr] :
      ( ( v51713(VarCurr,bitIndex10)
      <=> v51646(VarCurr,bitIndex9) )
      & ( v51713(VarCurr,bitIndex9)
      <=> v51646(VarCurr,bitIndex8) )
      & ( v51713(VarCurr,bitIndex8)
      <=> v51646(VarCurr,bitIndex7) )
      & ( v51713(VarCurr,bitIndex7)
      <=> v51646(VarCurr,bitIndex6) )
      & ( v51713(VarCurr,bitIndex6)
      <=> v51646(VarCurr,bitIndex5) )
      & ( v51713(VarCurr,bitIndex5)
      <=> v51646(VarCurr,bitIndex4) )
      & ( v51713(VarCurr,bitIndex4)
      <=> v51646(VarCurr,bitIndex3) )
      & ( v51713(VarCurr,bitIndex3)
      <=> v51646(VarCurr,bitIndex2) )
      & ( v51713(VarCurr,bitIndex2)
      <=> v51646(VarCurr,bitIndex1) )
      & ( v51713(VarCurr,bitIndex1)
      <=> v51646(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_3307,axiom,
    ! [VarCurr] :
      ( v51711(VarCurr)
    <=> ( ( v51712(VarCurr,bitIndex1)
        <=> $true )
        & ( v51712(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_19044,axiom,
    ! [VarCurr] :
      ( v51712(VarCurr,bitIndex0)
    <=> v51552(VarCurr) ) ).

fof(addAssignment_19043,axiom,
    ! [VarCurr] :
      ( v51712(VarCurr,bitIndex1)
    <=> v46431(VarCurr) ) ).

fof(addAssignment_19042,axiom,
    ! [VarCurr] :
      ( ( v51709(VarCurr,bitIndex9)
      <=> v51646(VarCurr,bitIndex10) )
      & ( v51709(VarCurr,bitIndex8)
      <=> v51646(VarCurr,bitIndex9) )
      & ( v51709(VarCurr,bitIndex7)
      <=> v51646(VarCurr,bitIndex8) )
      & ( v51709(VarCurr,bitIndex6)
      <=> v51646(VarCurr,bitIndex7) )
      & ( v51709(VarCurr,bitIndex5)
      <=> v51646(VarCurr,bitIndex6) )
      & ( v51709(VarCurr,bitIndex4)
      <=> v51646(VarCurr,bitIndex5) )
      & ( v51709(VarCurr,bitIndex3)
      <=> v51646(VarCurr,bitIndex4) )
      & ( v51709(VarCurr,bitIndex2)
      <=> v51646(VarCurr,bitIndex3) )
      & ( v51709(VarCurr,bitIndex1)
      <=> v51646(VarCurr,bitIndex2) )
      & ( v51709(VarCurr,bitIndex0)
      <=> v51646(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_19041,axiom,
    ! [VarCurr] :
      ( v51709(VarCurr,bitIndex10)
    <=> $false ) ).

fof(addBitVectorEqualityBitBlasted_3306,axiom,
    ! [VarCurr] :
      ( v51707(VarCurr)
    <=> ( ( v51708(VarCurr,bitIndex1)
        <=> $false )
        & ( v51708(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_19040,axiom,
    ! [VarCurr] :
      ( v51708(VarCurr,bitIndex0)
    <=> v51552(VarCurr) ) ).

fof(addAssignment_19039,axiom,
    ! [VarCurr] :
      ( v51708(VarCurr,bitIndex1)
    <=> v46431(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_3305,axiom,
    ! [VarCurr] :
      ( v51705(VarCurr)
    <=> ( ( v51706(VarCurr,bitIndex1)
        <=> $false )
        & ( v51706(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_19038,axiom,
    ! [VarCurr] :
      ( v51706(VarCurr,bitIndex0)
    <=> v51552(VarCurr) ) ).

fof(addAssignment_19037,axiom,
    ! [VarCurr] :
      ( v51706(VarCurr,bitIndex1)
    <=> v46431(VarCurr) ) ).

fof(addAssignment_19036,axiom,
    ! [VarCurr] :
      ( v51703(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_19035,axiom,
    ! [VarCurr,B] :
      ( range_10_1(B)
     => ( v51703(VarCurr,B)
      <=> v51644(VarCurr,B) ) ) ).

fof(writeUnaryOperator_4559,axiom,
    ! [VarCurr] :
      ( ~ v51702(VarCurr)
    <=> v46425(VarCurr) ) ).

fof(addAssignment_19034,axiom,
    ! [VarCurr] :
      ( v51644(VarCurr,bitIndex1)
    <=> v51645(VarCurr,bitIndex1) ) ).

fof(addAssignment_19033,axiom,
    ! [VarCurr] :
      ( v51644(VarCurr,bitIndex2)
    <=> v51645(VarCurr,bitIndex2) ) ).

fof(addAssignment_19032,axiom,
    ! [VarCurr] :
      ( v51644(VarCurr,bitIndex3)
    <=> v51645(VarCurr,bitIndex3) ) ).

fof(addAssignment_19031,axiom,
    ! [VarNext] :
      ( v51646(VarNext,bitIndex3)
    <=> v51689(VarNext,bitIndex3) ) ).

fof(addCaseBooleanConditionEqualRanges1_994,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51690(VarNext)
       => ! [B] :
            ( range_10_0(B)
           => ( v51689(VarNext,B)
            <=> v51646(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1056,axiom,
    ! [VarNext] :
      ( v51690(VarNext)
     => ! [B] :
          ( range_10_0(B)
         => ( v51689(VarNext,B)
          <=> v51698(VarNext,B) ) ) ) ).

fof(addAssignment_19030,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_10_0(B)
         => ( v51698(VarNext,B)
          <=> v51696(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1608,axiom,
    ! [VarCurr] :
      ( ~ v51600(VarCurr)
     => ! [B] :
          ( range_10_0(B)
         => ( v51696(VarCurr,B)
          <=> v51686(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1443,axiom,
    ! [VarCurr] :
      ( v51600(VarCurr)
     => ! [B] :
          ( range_10_0(B)
         => ( v51696(VarCurr,B)
          <=> b00000000001(B) ) ) ) ).

fof(bitBlastConstant_10519,axiom,
    ~ b00000000001(bitIndex10) ).

fof(bitBlastConstant_10518,axiom,
    ~ b00000000001(bitIndex9) ).

fof(bitBlastConstant_10517,axiom,
    ~ b00000000001(bitIndex8) ).

fof(bitBlastConstant_10516,axiom,
    ~ b00000000001(bitIndex7) ).

fof(bitBlastConstant_10515,axiom,
    ~ b00000000001(bitIndex6) ).

fof(bitBlastConstant_10514,axiom,
    ~ b00000000001(bitIndex5) ).

fof(bitBlastConstant_10513,axiom,
    ~ b00000000001(bitIndex4) ).

fof(bitBlastConstant_10512,axiom,
    ~ b00000000001(bitIndex3) ).

fof(bitBlastConstant_10511,axiom,
    ~ b00000000001(bitIndex2) ).

fof(bitBlastConstant_10510,axiom,
    ~ b00000000001(bitIndex1) ).

fof(bitBlastConstant_10509,axiom,
    b00000000001(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10802,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51690(VarNext)
      <=> v51691(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10801,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51691(VarNext)
      <=> ( v51693(VarNext)
          & v51584(VarNext) ) ) ) ).

fof(writeUnaryOperator_4558,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51693(VarNext)
      <=> v51593(VarNext) ) ) ).

fof(addAssignment_19029,axiom,
    ! [VarCurr] :
      ( v51560(VarCurr)
    <=> v51562(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_993,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51650(VarNext)
       => ( v51562(VarNext)
        <=> v51562(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1055,axiom,
    ! [VarNext] :
      ( v51650(VarNext)
     => ( v51562(VarNext)
      <=> v51668(VarNext) ) ) ).

fof(addAssignment_19028,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51668(VarNext)
      <=> v51666(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1607,axiom,
    ! [VarCurr] :
      ( ~ v51665(VarCurr)
     => ( v51666(VarCurr)
      <=> v51669(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1442,axiom,
    ! [VarCurr] :
      ( v51665(VarCurr)
     => ( v51666(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1606,axiom,
    ! [VarCurr] :
      ( ~ v46431(VarCurr)
     => ( v51669(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1441,axiom,
    ! [VarCurr] :
      ( v46431(VarCurr)
     => ( v51669(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10800,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51650(VarNext)
      <=> ( v51651(VarNext)
          & v51658(VarNext) ) ) ) ).

fof(addAssignment_19027,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51658(VarNext)
      <=> v51656(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10799,axiom,
    ! [VarCurr] :
      ( v51656(VarCurr)
    <=> ( v51659(VarCurr)
        | v51665(VarCurr) ) ) ).

fof(writeUnaryOperator_4557,axiom,
    ! [VarCurr] :
      ( ~ v51665(VarCurr)
    <=> v46425(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10798,axiom,
    ! [VarCurr] :
      ( v51659(VarCurr)
    <=> ( v51660(VarCurr)
        | v46431(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10797,axiom,
    ! [VarCurr] :
      ( v51660(VarCurr)
    <=> ( v51661(VarCurr)
        & v51664(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3304,axiom,
    ! [VarCurr] :
      ( v51664(VarCurr)
    <=> ( v51644(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10796,axiom,
    ! [VarCurr] :
      ( v51661(VarCurr)
    <=> ( v51662(VarCurr)
        & v51663(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3303,axiom,
    ! [VarCurr] :
      ( v51663(VarCurr)
    <=> ( v46423(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3302,axiom,
    ! [VarCurr] :
      ( v51662(VarCurr)
    <=> ( v51552(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10795,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51651(VarNext)
      <=> ( v51652(VarNext)
          & v51584(VarNext) ) ) ) ).

fof(writeUnaryOperator_4556,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51652(VarNext)
      <=> v51593(VarNext) ) ) ).

fof(addAssignment_19026,axiom,
    ! [VarCurr] :
      ( v51644(VarCurr,bitIndex0)
    <=> v51645(VarCurr,bitIndex0) ) ).

fof(addAssignment_19025,axiom,
    ! [VarCurr] :
      ( v51645(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_19024,axiom,
    ! [VarCurr,B] :
      ( range_10_1(B)
     => ( v51645(VarCurr,B)
      <=> v51646(VarCurr,B) ) ) ).

fof(range_axiom_215,axiom,
    ! [B] :
      ( range_10_1(B)
    <=> ( $false
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B ) ) ).

fof(addAssignment_19023,axiom,
    ! [VarNext] :
      ( v46423(VarNext,bitIndex1)
    <=> v51636(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_992,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51637(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v51636(VarNext,B)
            <=> v46423(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1054,axiom,
    ! [VarNext] :
      ( v51637(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v51636(VarNext,B)
          <=> v51599(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10794,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51637(VarNext)
      <=> v51638(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10793,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51638(VarNext)
      <=> ( v51640(VarNext)
          & v51584(VarNext) ) ) ) ).

fof(writeUnaryOperator_4555,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51640(VarNext)
      <=> v51593(VarNext) ) ) ).

fof(addAssignment_19022,axiom,
    ! [VarCurr] :
      ( v46429(VarCurr,bitIndex1)
    <=> v51569(VarCurr,bitIndex1) ) ).

fof(addAssignment_19021,axiom,
    ! [VarCurr] :
      ( v51564(VarCurr,bitIndex1)
    <=> v51565(VarCurr,bitIndex1) ) ).

fof(addAssignment_19020,axiom,
    ! [VarNext] :
      ( v46423(VarNext,bitIndex0)
    <=> v51628(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionEqualRanges1_991,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51629(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v51628(VarNext,B)
            <=> v46423(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1053,axiom,
    ! [VarNext] :
      ( v51629(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v51628(VarNext,B)
          <=> v51599(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10792,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51629(VarNext)
      <=> v51630(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10791,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51630(VarNext)
      <=> ( v51632(VarNext)
          & v51584(VarNext) ) ) ) ).

fof(writeUnaryOperator_4554,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51632(VarNext)
      <=> v51593(VarNext) ) ) ).

fof(addAssignment_19019,axiom,
    ! [VarCurr] :
      ( v46429(VarCurr,bitIndex0)
    <=> v51569(VarCurr,bitIndex0) ) ).

fof(addAssignment_19018,axiom,
    ! [VarNext] :
      ( v46423(VarNext,bitIndex2)
    <=> v51620(VarNext,bitIndex2) ) ).

fof(addCaseBooleanConditionEqualRanges1_990,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51621(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v51620(VarNext,B)
            <=> v46423(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1052,axiom,
    ! [VarNext] :
      ( v51621(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v51620(VarNext,B)
          <=> v51599(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10790,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51621(VarNext)
      <=> v51622(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10789,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51622(VarNext)
      <=> ( v51624(VarNext)
          & v51584(VarNext) ) ) ) ).

fof(writeUnaryOperator_4553,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51624(VarNext)
      <=> v51593(VarNext) ) ) ).

fof(addAssignment_19017,axiom,
    ! [VarCurr] :
      ( v46429(VarCurr,bitIndex2)
    <=> v51569(VarCurr,bitIndex2) ) ).

fof(addAssignment_19016,axiom,
    ! [VarCurr] :
      ( v51564(VarCurr,bitIndex2)
    <=> v51565(VarCurr,bitIndex2) ) ).

fof(addAssignment_19015,axiom,
    ! [VarNext] :
      ( v46423(VarNext,bitIndex3)
    <=> v51612(VarNext,bitIndex3) ) ).

fof(addCaseBooleanConditionEqualRanges1_989,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51613(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v51612(VarNext,B)
            <=> v46423(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1051,axiom,
    ! [VarNext] :
      ( v51613(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v51612(VarNext,B)
          <=> v51599(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10788,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51613(VarNext)
      <=> v51614(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10787,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51614(VarNext)
      <=> ( v51616(VarNext)
          & v51584(VarNext) ) ) ) ).

fof(writeUnaryOperator_4552,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51616(VarNext)
      <=> v51593(VarNext) ) ) ).

fof(addAssignment_19014,axiom,
    ! [VarCurr] :
      ( v46429(VarCurr,bitIndex3)
    <=> v51569(VarCurr,bitIndex3) ) ).

fof(addAssignment_19013,axiom,
    ! [VarCurr] :
      ( v51564(VarCurr,bitIndex3)
    <=> v51565(VarCurr,bitIndex3) ) ).

fof(addAssignment_19012,axiom,
    ! [VarNext] :
      ( v46423(VarNext,bitIndex4)
    <=> v51604(VarNext,bitIndex4) ) ).

fof(addCaseBooleanConditionEqualRanges1_988,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51605(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v51604(VarNext,B)
            <=> v46423(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1050,axiom,
    ! [VarNext] :
      ( v51605(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v51604(VarNext,B)
          <=> v51599(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10786,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51605(VarNext)
      <=> v51606(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10785,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51606(VarNext)
      <=> ( v51608(VarNext)
          & v51584(VarNext) ) ) ) ).

fof(writeUnaryOperator_4551,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51608(VarNext)
      <=> v51593(VarNext) ) ) ).

fof(addAssignment_19011,axiom,
    ! [VarCurr] :
      ( v46429(VarCurr,bitIndex4)
    <=> v51569(VarCurr,bitIndex4) ) ).

fof(addAssignment_19010,axiom,
    ! [VarCurr] :
      ( v51564(VarCurr,bitIndex4)
    <=> v51565(VarCurr,bitIndex4) ) ).

fof(addAssignment_19009,axiom,
    ! [VarNext] :
      ( v46423(VarNext,bitIndex5)
    <=> v51588(VarNext,bitIndex5) ) ).

fof(addCaseBooleanConditionEqualRanges1_987,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51589(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v51588(VarNext,B)
            <=> v46423(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1049,axiom,
    ! [VarNext] :
      ( v51589(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v51588(VarNext,B)
          <=> v51599(VarNext,B) ) ) ) ).

fof(addAssignment_19008,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v51599(VarNext,B)
          <=> v51597(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1605,axiom,
    ! [VarCurr] :
      ( ~ v51600(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v51597(VarCurr,B)
          <=> v46429(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1440,axiom,
    ! [VarCurr] :
      ( v51600(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v51597(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_4550,axiom,
    ! [VarCurr] :
      ( ~ v51600(VarCurr)
    <=> v46425(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10784,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51589(VarNext)
      <=> v51590(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10783,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51590(VarNext)
      <=> ( v51591(VarNext)
          & v51584(VarNext) ) ) ) ).

fof(writeUnaryOperator_4549,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51591(VarNext)
      <=> v51593(VarNext) ) ) ).

fof(addAssignment_19007,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51593(VarNext)
      <=> v51584(VarCurr) ) ) ).

fof(addAssignment_19006,axiom,
    ! [VarCurr] :
      ( v51584(VarCurr)
    <=> v51586(VarCurr) ) ).

fof(addAssignment_19005,axiom,
    ! [VarCurr] :
      ( v51586(VarCurr)
    <=> v42723(VarCurr) ) ).

fof(addAssignment_19004,axiom,
    ! [VarCurr] :
      ( v46429(VarCurr,bitIndex5)
    <=> v51569(VarCurr,bitIndex5) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1604,axiom,
    ! [VarCurr] :
      ( ~ v51570(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v51569(VarCurr,B)
          <=> v51571(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1439,axiom,
    ! [VarCurr] :
      ( v51570(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v51569(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_125,axiom,
    ! [VarCurr] :
      ( ( ~ v51572(VarCurr)
        & ~ v51574(VarCurr)
        & ~ v51578(VarCurr) )
     => ! [B] :
          ( range_7_0(B)
         => ( v51571(VarCurr,B)
          <=> v46423(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_437,axiom,
    ! [VarCurr] :
      ( v51578(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v51571(VarCurr,B)
          <=> v51580(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1162,axiom,
    ! [VarCurr] :
      ( v51574(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v51571(VarCurr,B)
          <=> v51576(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1129,axiom,
    ! [VarCurr] :
      ( v51572(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v51571(VarCurr,B)
          <=> v46423(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3301,axiom,
    ! [VarCurr] :
      ( v51581(VarCurr)
    <=> ( ( v51582(VarCurr,bitIndex1)
        <=> $true )
        & ( v51582(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_19003,axiom,
    ! [VarCurr] :
      ( v51582(VarCurr,bitIndex0)
    <=> v51552(VarCurr) ) ).

fof(addAssignment_19002,axiom,
    ! [VarCurr] :
      ( v51582(VarCurr,bitIndex1)
    <=> v46431(VarCurr) ) ).

fof(addAssignment_19001,axiom,
    ! [VarCurr] :
      ( v51580(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_19000,axiom,
    ! [VarCurr,B] :
      ( range_7_1(B)
     => ( v51580(VarCurr,B)
      <=> v51564(VarCurr,B) ) ) ).

fof(range_axiom_214,axiom,
    ! [B] :
      ( range_7_1(B)
    <=> ( $false
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B ) ) ).

fof(addBitVectorEqualityBitBlasted_3300,axiom,
    ! [VarCurr] :
      ( v51578(VarCurr)
    <=> ( ( v51579(VarCurr,bitIndex1)
        <=> $true )
        & ( v51579(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_18999,axiom,
    ! [VarCurr] :
      ( v51579(VarCurr,bitIndex0)
    <=> v51552(VarCurr) ) ).

fof(addAssignment_18998,axiom,
    ! [VarCurr] :
      ( v51579(VarCurr,bitIndex1)
    <=> v46431(VarCurr) ) ).

fof(addAssignment_18997,axiom,
    ! [VarCurr] :
      ( ( v51576(VarCurr,bitIndex6)
      <=> v46423(VarCurr,bitIndex7) )
      & ( v51576(VarCurr,bitIndex5)
      <=> v46423(VarCurr,bitIndex6) )
      & ( v51576(VarCurr,bitIndex4)
      <=> v46423(VarCurr,bitIndex5) )
      & ( v51576(VarCurr,bitIndex3)
      <=> v46423(VarCurr,bitIndex4) )
      & ( v51576(VarCurr,bitIndex2)
      <=> v46423(VarCurr,bitIndex3) )
      & ( v51576(VarCurr,bitIndex1)
      <=> v46423(VarCurr,bitIndex2) )
      & ( v51576(VarCurr,bitIndex0)
      <=> v46423(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_18996,axiom,
    ! [VarCurr] :
      ( v51576(VarCurr,bitIndex7)
    <=> $false ) ).

fof(addBitVectorEqualityBitBlasted_3299,axiom,
    ! [VarCurr] :
      ( v51574(VarCurr)
    <=> ( ( v51575(VarCurr,bitIndex1)
        <=> $false )
        & ( v51575(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_18995,axiom,
    ! [VarCurr] :
      ( v51575(VarCurr,bitIndex0)
    <=> v51552(VarCurr) ) ).

fof(addAssignment_18994,axiom,
    ! [VarCurr] :
      ( v51575(VarCurr,bitIndex1)
    <=> v46431(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_3298,axiom,
    ! [VarCurr] :
      ( v51572(VarCurr)
    <=> ( ( v51573(VarCurr,bitIndex1)
        <=> $false )
        & ( v51573(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_18993,axiom,
    ! [VarCurr] :
      ( v51573(VarCurr,bitIndex0)
    <=> v51552(VarCurr) ) ).

fof(addAssignment_18992,axiom,
    ! [VarCurr] :
      ( v51573(VarCurr,bitIndex1)
    <=> v46431(VarCurr) ) ).

fof(writeUnaryOperator_4548,axiom,
    ! [VarCurr] :
      ( ~ v51570(VarCurr)
    <=> v46425(VarCurr) ) ).

fof(addAssignment_18991,axiom,
    ! [VarCurr] :
      ( v51564(VarCurr,bitIndex5)
    <=> v51565(VarCurr,bitIndex5) ) ).

fof(addAssignment_18990,axiom,
    ! [VarCurr] :
      ( v51565(VarCurr,bitIndex0)
    <=> $false ) ).

fof(addAssignment_18989,axiom,
    ! [VarCurr] :
      ( ( v51565(VarCurr,bitIndex7)
      <=> v46423(VarCurr,bitIndex6) )
      & ( v51565(VarCurr,bitIndex6)
      <=> v46423(VarCurr,bitIndex5) )
      & ( v51565(VarCurr,bitIndex5)
      <=> v46423(VarCurr,bitIndex4) )
      & ( v51565(VarCurr,bitIndex4)
      <=> v46423(VarCurr,bitIndex3) )
      & ( v51565(VarCurr,bitIndex3)
      <=> v46423(VarCurr,bitIndex2) )
      & ( v51565(VarCurr,bitIndex2)
      <=> v46423(VarCurr,bitIndex1) )
      & ( v51565(VarCurr,bitIndex1)
      <=> v46423(VarCurr,bitIndex0) ) ) ).

fof(addAssignmentInitValue_43,axiom,
    ~ v46423(constB0,bitIndex6) ).

fof(bitBlastConstant_10508,axiom,
    ~ bx0xxxxxx(bitIndex6) ).

fof(addAssignment_18988,axiom,
    ! [VarCurr] :
      ( v46431(VarCurr)
    <=> v46433(VarCurr) ) ).

fof(addAssignment_18987,axiom,
    ! [VarCurr] :
      ( v46433(VarCurr)
    <=> v46435(VarCurr) ) ).

fof(addAssignment_18986,axiom,
    ! [VarCurr] :
      ( v46435(VarCurr)
    <=> v46437(VarCurr) ) ).

fof(addAssignment_18985,axiom,
    ! [VarCurr] :
      ( v46437(VarCurr)
    <=> v46439(VarCurr) ) ).

fof(addAssignment_18984,axiom,
    ! [VarCurr] :
      ( v46439(VarCurr)
    <=> v46441(VarCurr) ) ).

fof(addAssignment_18983,axiom,
    ! [VarCurr] :
      ( v46441(VarCurr)
    <=> v46443(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_986,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51540(VarNext)
       => ( v46443(VarNext)
        <=> v46443(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1048,axiom,
    ! [VarNext] :
      ( v51540(VarNext)
     => ( v46443(VarNext)
      <=> v51548(VarNext) ) ) ).

fof(addAssignment_18982,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51548(VarNext)
      <=> v51546(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1603,axiom,
    ! [VarCurr] :
      ( ~ v48464(VarCurr)
     => ( v51546(VarCurr)
      <=> v46445(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1438,axiom,
    ! [VarCurr] :
      ( v48464(VarCurr)
     => ( v51546(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10782,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51540(VarNext)
      <=> v51541(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10781,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51541(VarNext)
      <=> ( v51543(VarNext)
          & v45620(VarNext) ) ) ) ).

fof(writeUnaryOperator_4547,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51543(VarNext)
      <=> v47885(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_124,axiom,
    ! [VarCurr] :
      ( ( ~ v51502(VarCurr)
        & ~ v51503(VarCurr)
        & ~ v51534(VarCurr) )
     => ( v46445(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_436,axiom,
    ! [VarCurr] :
      ( v51534(VarCurr)
     => ( v46445(VarCurr)
      <=> v51535(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1161,axiom,
    ! [VarCurr] :
      ( v51503(VarCurr)
     => ( v46445(VarCurr)
      <=> v51504(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1128,axiom,
    ! [VarCurr] :
      ( v51502(VarCurr)
     => ( v46445(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1160,axiom,
    ! [VarCurr] :
      ( ~ v51536(VarCurr)
     => ( v51535(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1127,axiom,
    ! [VarCurr] :
      ( v51536(VarCurr)
     => ( v51535(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_3297,axiom,
    ! [VarCurr] :
      ( v51537(VarCurr)
    <=> ( v46409(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_3296,axiom,
    ! [VarCurr] :
      ( v51536(VarCurr)
    <=> ( v46409(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3295,axiom,
    ! [VarCurr] :
      ( v51534(VarCurr)
    <=> ( ( v46447(VarCurr,bitIndex2)
        <=> $false )
        & ( v46447(VarCurr,bitIndex1)
        <=> $true )
        & ( v46447(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1159,axiom,
    ! [VarCurr] :
      ( ~ v51505(VarCurr)
     => ( v51504(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1126,axiom,
    ! [VarCurr] :
      ( v51505(VarCurr)
     => ( v51504(VarCurr)
      <=> v51506(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3294,axiom,
    ! [VarCurr] :
      ( v51533(VarCurr)
    <=> ( v46409(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_123,axiom,
    ! [VarCurr] :
      ( ( ~ v51507(VarCurr)
        & ~ v51509(VarCurr)
        & ~ v51523(VarCurr) )
     => ( v51506(VarCurr)
      <=> v51527(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_435,axiom,
    ! [VarCurr] :
      ( v51523(VarCurr)
     => ( v51506(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1158,axiom,
    ! [VarCurr] :
      ( v51509(VarCurr)
     => ( v51506(VarCurr)
      <=> v51511(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1125,axiom,
    ! [VarCurr] :
      ( v51507(VarCurr)
     => ( v51506(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1157,axiom,
    ! [VarCurr] :
      ( ~ v51528(VarCurr)
     => ( v51527(VarCurr)
      <=> v51530(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1124,axiom,
    ! [VarCurr] :
      ( v51528(VarCurr)
     => ( v51527(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1156,axiom,
    ! [VarCurr] :
      ( ~ v51531(VarCurr)
     => ( v51530(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1123,axiom,
    ! [VarCurr] :
      ( v51531(VarCurr)
     => ( v51530(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3293,axiom,
    ! [VarCurr] :
      ( v51532(VarCurr)
    <=> ( v51396(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3292,axiom,
    ! [VarCurr] :
      ( v51531(VarCurr)
    <=> ( v51396(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_3291,axiom,
    ! [VarCurr] :
      ( v51529(VarCurr)
    <=> ( v48647(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3290,axiom,
    ! [VarCurr] :
      ( v51528(VarCurr)
    <=> ( v48647(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_3289,axiom,
    ! [VarCurr] :
      ( v51525(VarCurr)
    <=> ( ( v51526(VarCurr,bitIndex1)
        <=> $true )
        & ( v51526(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_18981,axiom,
    ! [VarCurr] :
      ( v51526(VarCurr,bitIndex0)
    <=> v51427(VarCurr) ) ).

fof(addAssignment_18980,axiom,
    ! [VarCurr] :
      ( v51526(VarCurr,bitIndex1)
    <=> v47899(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_3288,axiom,
    ! [VarCurr] :
      ( v51523(VarCurr)
    <=> ( ( v51524(VarCurr,bitIndex1)
        <=> $true )
        & ( v51524(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_18979,axiom,
    ! [VarCurr] :
      ( v51524(VarCurr,bitIndex0)
    <=> v51427(VarCurr) ) ).

fof(addAssignment_18978,axiom,
    ! [VarCurr] :
      ( v51524(VarCurr,bitIndex1)
    <=> v47899(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1155,axiom,
    ! [VarCurr] :
      ( ~ v51512(VarCurr)
     => ( v51511(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1122,axiom,
    ! [VarCurr] :
      ( v51512(VarCurr)
     => ( v51511(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10780,axiom,
    ! [VarCurr] :
      ( v51512(VarCurr)
    <=> ( v51513(VarCurr)
        | v51518(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10779,axiom,
    ! [VarCurr] :
      ( v51518(VarCurr)
    <=> ( v51519(VarCurr)
        | v51521(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3287,axiom,
    ! [VarCurr] :
      ( v51521(VarCurr)
    <=> ( ( v51522(VarCurr,bitIndex3)
        <=> $false )
        & ( v51522(VarCurr,bitIndex2)
        <=> $true )
        & ( v51522(VarCurr,bitIndex1)
        <=> $false )
        & ( v51522(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_18977,axiom,
    ! [VarCurr] :
      ( v51522(VarCurr,bitIndex0)
    <=> v49578(VarCurr) ) ).

fof(addAssignment_18976,axiom,
    ! [VarCurr] :
      ( ( v51522(VarCurr,bitIndex3)
      <=> v46454(VarCurr,bitIndex2) )
      & ( v51522(VarCurr,bitIndex2)
      <=> v46454(VarCurr,bitIndex1) )
      & ( v51522(VarCurr,bitIndex1)
      <=> v46454(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_3286,axiom,
    ! [VarCurr] :
      ( v51519(VarCurr)
    <=> ( ( v51520(VarCurr,bitIndex3)
        <=> $false )
        & ( v51520(VarCurr,bitIndex2)
        <=> $false )
        & ( v51520(VarCurr,bitIndex1)
        <=> $true )
        & ( v51520(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_18975,axiom,
    ! [VarCurr] :
      ( v51520(VarCurr,bitIndex0)
    <=> v49578(VarCurr) ) ).

fof(addAssignment_18974,axiom,
    ! [VarCurr] :
      ( ( v51520(VarCurr,bitIndex3)
      <=> v46454(VarCurr,bitIndex2) )
      & ( v51520(VarCurr,bitIndex2)
      <=> v46454(VarCurr,bitIndex1) )
      & ( v51520(VarCurr,bitIndex1)
      <=> v46454(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10778,axiom,
    ! [VarCurr] :
      ( v51513(VarCurr)
    <=> ( v51514(VarCurr)
        | v51516(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3285,axiom,
    ! [VarCurr] :
      ( v51516(VarCurr)
    <=> ( ( v51517(VarCurr,bitIndex3)
        <=> $false )
        & ( v51517(VarCurr,bitIndex2)
        <=> $true )
        & ( v51517(VarCurr,bitIndex1)
        <=> $false )
        & ( v51517(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_18973,axiom,
    ! [VarCurr] :
      ( v51517(VarCurr,bitIndex0)
    <=> v49578(VarCurr) ) ).

fof(addAssignment_18972,axiom,
    ! [VarCurr] :
      ( ( v51517(VarCurr,bitIndex3)
      <=> v46454(VarCurr,bitIndex2) )
      & ( v51517(VarCurr,bitIndex2)
      <=> v46454(VarCurr,bitIndex1) )
      & ( v51517(VarCurr,bitIndex1)
      <=> v46454(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_3284,axiom,
    ! [VarCurr] :
      ( v51514(VarCurr)
    <=> ( ( v51515(VarCurr,bitIndex3)
        <=> $false )
        & ( v51515(VarCurr,bitIndex2)
        <=> $false )
        & ( v51515(VarCurr,bitIndex1)
        <=> $true )
        & ( v51515(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_18971,axiom,
    ! [VarCurr] :
      ( v51515(VarCurr,bitIndex0)
    <=> v49578(VarCurr) ) ).

fof(addAssignment_18970,axiom,
    ! [VarCurr] :
      ( ( v51515(VarCurr,bitIndex3)
      <=> v46454(VarCurr,bitIndex2) )
      & ( v51515(VarCurr,bitIndex2)
      <=> v46454(VarCurr,bitIndex1) )
      & ( v51515(VarCurr,bitIndex1)
      <=> v46454(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_3283,axiom,
    ! [VarCurr] :
      ( v51509(VarCurr)
    <=> ( ( v51510(VarCurr,bitIndex1)
        <=> $false )
        & ( v51510(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_18969,axiom,
    ! [VarCurr] :
      ( v51510(VarCurr,bitIndex0)
    <=> v51427(VarCurr) ) ).

fof(addAssignment_18968,axiom,
    ! [VarCurr] :
      ( v51510(VarCurr,bitIndex1)
    <=> v47899(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_3282,axiom,
    ! [VarCurr] :
      ( v51507(VarCurr)
    <=> ( ( v51508(VarCurr,bitIndex1)
        <=> $false )
        & ( v51508(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_18967,axiom,
    ! [VarCurr] :
      ( v51508(VarCurr,bitIndex0)
    <=> v51427(VarCurr) ) ).

fof(addAssignment_18966,axiom,
    ! [VarCurr] :
      ( v51508(VarCurr,bitIndex1)
    <=> v47899(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_3281,axiom,
    ! [VarCurr] :
      ( v51505(VarCurr)
    <=> ( v46409(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3280,axiom,
    ! [VarCurr] :
      ( v51503(VarCurr)
    <=> ( ( v46447(VarCurr,bitIndex2)
        <=> $false )
        & ( v46447(VarCurr,bitIndex1)
        <=> $true )
        & ( v46447(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3279,axiom,
    ! [VarCurr] :
      ( v51502(VarCurr)
    <=> ( ( v46447(VarCurr,bitIndex2)
        <=> $false )
        & ( v46447(VarCurr,bitIndex1)
        <=> $false )
        & ( v46447(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_985,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51489(VarNext)
       => ! [B] :
            ( range_2_0(B)
           => ( v46447(VarNext,B)
            <=> v46447(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1047,axiom,
    ! [VarNext] :
      ( v51489(VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v46447(VarNext,B)
          <=> v51497(VarNext,B) ) ) ) ).

fof(addAssignment_18965,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v51497(VarNext,B)
          <=> v51495(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1602,axiom,
    ! [VarCurr] :
      ( ~ v51498(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51495(VarCurr,B)
          <=> v46449(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1437,axiom,
    ! [VarCurr] :
      ( v51498(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51495(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3278,axiom,
    ! [VarCurr] :
      ( v51498(VarCurr)
    <=> ( v45(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10777,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51489(VarNext)
      <=> v51490(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10776,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51490(VarNext)
      <=> ( v51491(VarNext)
          & v45620(VarNext) ) ) ) ).

fof(writeUnaryOperator_4546,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51491(VarNext)
      <=> v47885(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_122,axiom,
    ! [VarCurr] :
      ( ( ~ v51434(VarCurr)
        & ~ v51447(VarCurr)
        & ~ v51483(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v46449(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_434,axiom,
    ! [VarCurr] :
      ( v51483(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v46449(VarCurr,B)
          <=> v51484(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1154,axiom,
    ! [VarCurr] :
      ( v51447(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v46449(VarCurr,B)
          <=> v51448(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1121,axiom,
    ! [VarCurr] :
      ( v51434(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v46449(VarCurr,B)
          <=> v51435(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1153,axiom,
    ! [VarCurr] :
      ( ~ v51485(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51484(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1120,axiom,
    ! [VarCurr] :
      ( v51485(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51484(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3277,axiom,
    ! [VarCurr] :
      ( v51486(VarCurr)
    <=> ( v46409(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_3276,axiom,
    ! [VarCurr] :
      ( v51485(VarCurr)
    <=> ( v46409(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3275,axiom,
    ! [VarCurr] :
      ( v51483(VarCurr)
    <=> ( ( v46447(VarCurr,bitIndex2)
        <=> $false )
        & ( v46447(VarCurr,bitIndex1)
        <=> $true )
        & ( v46447(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1152,axiom,
    ! [VarCurr] :
      ( ~ v51449(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51448(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1119,axiom,
    ! [VarCurr] :
      ( v51449(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51448(VarCurr,B)
          <=> v51450(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3274,axiom,
    ! [VarCurr] :
      ( v51482(VarCurr)
    <=> ( v46409(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_121,axiom,
    ! [VarCurr] :
      ( ( ~ v51451(VarCurr)
        & ~ v51456(VarCurr)
        & ~ v51469(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v51450(VarCurr,B)
          <=> v51476(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_433,axiom,
    ! [VarCurr] :
      ( v51469(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51450(VarCurr,B)
          <=> v51471(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1151,axiom,
    ! [VarCurr] :
      ( v51456(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51450(VarCurr,B)
          <=> v51458(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1118,axiom,
    ! [VarCurr] :
      ( v51451(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51450(VarCurr,B)
          <=> v51453(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1150,axiom,
    ! [VarCurr] :
      ( ~ v51477(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51476(VarCurr,B)
          <=> v51479(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1117,axiom,
    ! [VarCurr] :
      ( v51477(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51476(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1149,axiom,
    ! [VarCurr] :
      ( ~ v51480(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51479(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1116,axiom,
    ! [VarCurr] :
      ( v51480(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51479(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3273,axiom,
    ! [VarCurr] :
      ( v51481(VarCurr)
    <=> ( v51396(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3272,axiom,
    ! [VarCurr] :
      ( v51480(VarCurr)
    <=> ( v51396(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_3271,axiom,
    ! [VarCurr] :
      ( v51478(VarCurr)
    <=> ( v48647(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3270,axiom,
    ! [VarCurr] :
      ( v51477(VarCurr)
    <=> ( v48647(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_3269,axiom,
    ! [VarCurr] :
      ( v51474(VarCurr)
    <=> ( ( v51475(VarCurr,bitIndex1)
        <=> $true )
        & ( v51475(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_18964,axiom,
    ! [VarCurr] :
      ( v51475(VarCurr,bitIndex0)
    <=> v51427(VarCurr) ) ).

fof(addAssignment_18963,axiom,
    ! [VarCurr] :
      ( v51475(VarCurr,bitIndex1)
    <=> v47899(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1148,axiom,
    ! [VarCurr] :
      ( ~ v51472(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51471(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1115,axiom,
    ! [VarCurr] :
      ( v51472(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51471(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3268,axiom,
    ! [VarCurr] :
      ( v51473(VarCurr)
    <=> ( v51396(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3267,axiom,
    ! [VarCurr] :
      ( v51472(VarCurr)
    <=> ( v51396(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_3266,axiom,
    ! [VarCurr] :
      ( v51469(VarCurr)
    <=> ( ( v51470(VarCurr,bitIndex1)
        <=> $true )
        & ( v51470(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_18962,axiom,
    ! [VarCurr] :
      ( v51470(VarCurr,bitIndex0)
    <=> v51427(VarCurr) ) ).

fof(addAssignment_18961,axiom,
    ! [VarCurr] :
      ( v51470(VarCurr,bitIndex1)
    <=> v47899(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_432,axiom,
    ! [VarCurr] :
      ( ( ~ v51459(VarCurr)
        & ~ v51464(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v51458(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1147,axiom,
    ! [VarCurr] :
      ( v51464(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51458(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1114,axiom,
    ! [VarCurr] :
      ( v51459(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51458(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10775,axiom,
    ! [VarCurr] :
      ( v51464(VarCurr)
    <=> ( v51465(VarCurr)
        | v51467(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3265,axiom,
    ! [VarCurr] :
      ( v51467(VarCurr)
    <=> ( ( v51468(VarCurr,bitIndex3)
        <=> $false )
        & ( v51468(VarCurr,bitIndex2)
        <=> $true )
        & ( v51468(VarCurr,bitIndex1)
        <=> $false )
        & ( v51468(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_18960,axiom,
    ! [VarCurr] :
      ( v51468(VarCurr,bitIndex0)
    <=> v49578(VarCurr) ) ).

fof(addAssignment_18959,axiom,
    ! [VarCurr] :
      ( ( v51468(VarCurr,bitIndex3)
      <=> v46454(VarCurr,bitIndex2) )
      & ( v51468(VarCurr,bitIndex2)
      <=> v46454(VarCurr,bitIndex1) )
      & ( v51468(VarCurr,bitIndex1)
      <=> v46454(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_3264,axiom,
    ! [VarCurr] :
      ( v51465(VarCurr)
    <=> ( ( v51466(VarCurr,bitIndex3)
        <=> $false )
        & ( v51466(VarCurr,bitIndex2)
        <=> $false )
        & ( v51466(VarCurr,bitIndex1)
        <=> $true )
        & ( v51466(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_18958,axiom,
    ! [VarCurr] :
      ( v51466(VarCurr,bitIndex0)
    <=> v49578(VarCurr) ) ).

fof(addAssignment_18957,axiom,
    ! [VarCurr] :
      ( ( v51466(VarCurr,bitIndex3)
      <=> v46454(VarCurr,bitIndex2) )
      & ( v51466(VarCurr,bitIndex2)
      <=> v46454(VarCurr,bitIndex1) )
      & ( v51466(VarCurr,bitIndex1)
      <=> v46454(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10774,axiom,
    ! [VarCurr] :
      ( v51459(VarCurr)
    <=> ( v51460(VarCurr)
        | v51462(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3263,axiom,
    ! [VarCurr] :
      ( v51462(VarCurr)
    <=> ( ( v51463(VarCurr,bitIndex3)
        <=> $false )
        & ( v51463(VarCurr,bitIndex2)
        <=> $true )
        & ( v51463(VarCurr,bitIndex1)
        <=> $false )
        & ( v51463(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_18956,axiom,
    ! [VarCurr] :
      ( v51463(VarCurr,bitIndex0)
    <=> v49578(VarCurr) ) ).

fof(addAssignment_18955,axiom,
    ! [VarCurr] :
      ( ( v51463(VarCurr,bitIndex3)
      <=> v46454(VarCurr,bitIndex2) )
      & ( v51463(VarCurr,bitIndex2)
      <=> v46454(VarCurr,bitIndex1) )
      & ( v51463(VarCurr,bitIndex1)
      <=> v46454(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_3262,axiom,
    ! [VarCurr] :
      ( v51460(VarCurr)
    <=> ( ( v51461(VarCurr,bitIndex3)
        <=> $false )
        & ( v51461(VarCurr,bitIndex2)
        <=> $false )
        & ( v51461(VarCurr,bitIndex1)
        <=> $true )
        & ( v51461(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_18954,axiom,
    ! [VarCurr] :
      ( v51461(VarCurr,bitIndex0)
    <=> v49578(VarCurr) ) ).

fof(addAssignment_18953,axiom,
    ! [VarCurr] :
      ( ( v51461(VarCurr,bitIndex3)
      <=> v46454(VarCurr,bitIndex2) )
      & ( v51461(VarCurr,bitIndex2)
      <=> v46454(VarCurr,bitIndex1) )
      & ( v51461(VarCurr,bitIndex1)
      <=> v46454(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_3261,axiom,
    ! [VarCurr] :
      ( v51456(VarCurr)
    <=> ( ( v51457(VarCurr,bitIndex1)
        <=> $false )
        & ( v51457(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_18952,axiom,
    ! [VarCurr] :
      ( v51457(VarCurr,bitIndex0)
    <=> v51427(VarCurr) ) ).

fof(addAssignment_18951,axiom,
    ! [VarCurr] :
      ( v51457(VarCurr,bitIndex1)
    <=> v47899(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1146,axiom,
    ! [VarCurr] :
      ( ~ v51454(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51453(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1113,axiom,
    ! [VarCurr] :
      ( v51454(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51453(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3260,axiom,
    ! [VarCurr] :
      ( v51455(VarCurr)
    <=> ( v51396(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3259,axiom,
    ! [VarCurr] :
      ( v51454(VarCurr)
    <=> ( v51396(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_3258,axiom,
    ! [VarCurr] :
      ( v51451(VarCurr)
    <=> ( ( v51452(VarCurr,bitIndex1)
        <=> $false )
        & ( v51452(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_18950,axiom,
    ! [VarCurr] :
      ( v51452(VarCurr,bitIndex0)
    <=> v51427(VarCurr) ) ).

fof(addAssignment_18949,axiom,
    ! [VarCurr] :
      ( v51452(VarCurr,bitIndex1)
    <=> v47899(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_3257,axiom,
    ! [VarCurr] :
      ( v51449(VarCurr)
    <=> ( v46409(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3256,axiom,
    ! [VarCurr] :
      ( v51447(VarCurr)
    <=> ( ( v46447(VarCurr,bitIndex2)
        <=> $false )
        & ( v46447(VarCurr,bitIndex1)
        <=> $true )
        & ( v46447(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1145,axiom,
    ! [VarCurr] :
      ( ~ v51436(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51435(VarCurr,B)
          <=> v51438(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1112,axiom,
    ! [VarCurr] :
      ( v51436(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51435(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_431,axiom,
    ! [VarCurr] :
      ( ( ~ v51439(VarCurr)
        & ~ v51444(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v51438(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1144,axiom,
    ! [VarCurr] :
      ( v51444(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51438(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1111,axiom,
    ! [VarCurr] :
      ( v51439(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51438(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10773,axiom,
    ! [VarCurr] :
      ( v51444(VarCurr)
    <=> ( v51445(VarCurr)
        | v51446(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3255,axiom,
    ! [VarCurr] :
      ( v51446(VarCurr)
    <=> ( ( v46454(VarCurr,bitIndex2)
        <=> $false )
        & ( v46454(VarCurr,bitIndex1)
        <=> $true )
        & ( v46454(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3254,axiom,
    ! [VarCurr] :
      ( v51445(VarCurr)
    <=> ( ( v46454(VarCurr,bitIndex2)
        <=> $false )
        & ( v46454(VarCurr,bitIndex1)
        <=> $false )
        & ( v46454(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10772,axiom,
    ! [VarCurr] :
      ( v51439(VarCurr)
    <=> ( v51440(VarCurr)
        | v51443(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3253,axiom,
    ! [VarCurr] :
      ( v51443(VarCurr)
    <=> ( ( v46454(VarCurr,bitIndex2)
        <=> $true )
        & ( v46454(VarCurr,bitIndex1)
        <=> $false )
        & ( v46454(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10771,axiom,
    ! [VarCurr] :
      ( v51440(VarCurr)
    <=> ( v51441(VarCurr)
        | v51442(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3252,axiom,
    ! [VarCurr] :
      ( v51442(VarCurr)
    <=> ( ( v46454(VarCurr,bitIndex2)
        <=> $false )
        & ( v46454(VarCurr,bitIndex1)
        <=> $true )
        & ( v46454(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3251,axiom,
    ! [VarCurr] :
      ( v51441(VarCurr)
    <=> ( ( v46454(VarCurr,bitIndex2)
        <=> $true )
        & ( v46454(VarCurr,bitIndex1)
        <=> $false )
        & ( v46454(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3250,axiom,
    ! [VarCurr] :
      ( v51437(VarCurr)
    <=> ( v46451(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3249,axiom,
    ! [VarCurr] :
      ( v51436(VarCurr)
    <=> ( v46451(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_3248,axiom,
    ! [VarCurr] :
      ( v51434(VarCurr)
    <=> ( ( v46447(VarCurr,bitIndex2)
        <=> $false )
        & ( v46447(VarCurr,bitIndex1)
        <=> $false )
        & ( v46447(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_120,axiom,
    ! [VarCurr] :
      ( ( ~ v51429(VarCurr)
        & ~ v48408(VarCurr)
        & ~ v48420(VarCurr) )
     => ( v51427(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_430,axiom,
    ! [VarCurr] :
      ( v48420(VarCurr)
     => ( v51427(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1143,axiom,
    ! [VarCurr] :
      ( v48408(VarCurr)
     => ( v51427(VarCurr)
      <=> v51430(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1110,axiom,
    ! [VarCurr] :
      ( v51429(VarCurr)
     => ( v51427(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1142,axiom,
    ! [VarCurr] :
      ( ~ v48410(VarCurr)
     => ( v51430(VarCurr)
      <=> v51432(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1109,axiom,
    ! [VarCurr] :
      ( v48410(VarCurr)
     => ( v51430(VarCurr)
      <=> v51431(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1141,axiom,
    ! [VarCurr] :
      ( ~ v49273(VarCurr)
     => ( v51432(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1108,axiom,
    ! [VarCurr] :
      ( v49273(VarCurr)
     => ( v51432(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_429,axiom,
    ! [VarCurr] :
      ( ( ~ v48412(VarCurr)
        & ~ v48414(VarCurr) )
     => ( v51431(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1140,axiom,
    ! [VarCurr] :
      ( v48414(VarCurr)
     => ( v51431(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1107,axiom,
    ! [VarCurr] :
      ( v48412(VarCurr)
     => ( v51431(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10770,axiom,
    ! [VarCurr] :
      ( v51429(VarCurr)
    <=> ( v48404(VarCurr)
        | v48407(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_984,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51411(VarNext)
       => ( v47899(VarNext)
        <=> v47899(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1046,axiom,
    ! [VarNext] :
      ( v51411(VarNext)
     => ( v47899(VarNext)
      <=> v51419(VarNext) ) ) ).

fof(addAssignment_18948,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51419(VarNext)
      <=> v51417(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1601,axiom,
    ! [VarCurr] :
      ( ~ v51420(VarCurr)
     => ( v51417(VarCurr)
      <=> v51421(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1436,axiom,
    ! [VarCurr] :
      ( v51420(VarCurr)
     => ( v51417(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1600,axiom,
    ! [VarCurr] :
      ( ~ v47901(VarCurr)
     => ( v51421(VarCurr)
      <=> v51422(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1435,axiom,
    ! [VarCurr] :
      ( v47901(VarCurr)
     => ( v51421(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10769,axiom,
    ! [VarCurr] :
      ( v51422(VarCurr)
    <=> ( v51423(VarCurr)
        & v47899(VarCurr) ) ) ).

fof(writeUnaryOperator_4545,axiom,
    ! [VarCurr] :
      ( ~ v51423(VarCurr)
    <=> v51396(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_3247,axiom,
    ! [VarCurr] :
      ( v51420(VarCurr)
    <=> ( v45(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10768,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51411(VarNext)
      <=> v51412(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10767,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51412(VarNext)
      <=> ( v51413(VarNext)
          & v45620(VarNext) ) ) ) ).

fof(writeUnaryOperator_4544,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51413(VarNext)
      <=> v47885(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges5_27,axiom,
    ! [VarCurr] :
      ( ( ~ v48405(VarCurr)
        & ~ v48406(VarCurr)
        & ~ v48407(VarCurr)
        & ~ v48408(VarCurr)
        & ~ v48420(VarCurr) )
     => ( v51396(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_30,axiom,
    ! [VarCurr] :
      ( v48420(VarCurr)
     => ( v51396(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_119,axiom,
    ! [VarCurr] :
      ( v48408(VarCurr)
     => ( v51396(VarCurr)
      <=> v51400(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_428,axiom,
    ! [VarCurr] :
      ( v48407(VarCurr)
     => ( v51396(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1139,axiom,
    ! [VarCurr] :
      ( v48406(VarCurr)
     => ( v51396(VarCurr)
      <=> v51398(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1106,axiom,
    ! [VarCurr] :
      ( v48405(VarCurr)
     => ( v51396(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1138,axiom,
    ! [VarCurr] :
      ( ~ v48410(VarCurr)
     => ( v51400(VarCurr)
      <=> v51408(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1105,axiom,
    ! [VarCurr] :
      ( v48410(VarCurr)
     => ( v51400(VarCurr)
      <=> v51401(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1137,axiom,
    ! [VarCurr] :
      ( ~ v49273(VarCurr)
     => ( v51408(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1104,axiom,
    ! [VarCurr] :
      ( v49273(VarCurr)
     => ( v51408(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_427,axiom,
    ! [VarCurr] :
      ( ( ~ v48412(VarCurr)
        & ~ v48414(VarCurr) )
     => ( v51401(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1136,axiom,
    ! [VarCurr] :
      ( v48414(VarCurr)
     => ( v51401(VarCurr)
      <=> v51405(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1103,axiom,
    ! [VarCurr] :
      ( v48412(VarCurr)
     => ( v51401(VarCurr)
      <=> v51402(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1135,axiom,
    ! [VarCurr] :
      ( ~ v51406(VarCurr)
     => ( v51405(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1102,axiom,
    ! [VarCurr] :
      ( v51406(VarCurr)
     => ( v51405(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_3246,axiom,
    ! [VarCurr] :
      ( v51407(VarCurr)
    <=> ( v48394(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3245,axiom,
    ! [VarCurr] :
      ( v51406(VarCurr)
    <=> ( v48394(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1134,axiom,
    ! [VarCurr] :
      ( ~ v51403(VarCurr)
     => ( v51402(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1101,axiom,
    ! [VarCurr] :
      ( v51403(VarCurr)
     => ( v51402(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_3244,axiom,
    ! [VarCurr] :
      ( v51404(VarCurr)
    <=> ( v49578(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3243,axiom,
    ! [VarCurr] :
      ( v51403(VarCurr)
    <=> ( v49578(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1133,axiom,
    ! [VarCurr] :
      ( ~ v49269(VarCurr)
     => ( v51398(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1100,axiom,
    ! [VarCurr] :
      ( v49269(VarCurr)
     => ( v51398(VarCurr)
      <=> v51399(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1132,axiom,
    ! [VarCurr] :
      ( ~ v50542(VarCurr)
     => ( v51399(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1099,axiom,
    ! [VarCurr] :
      ( v50542(VarCurr)
     => ( v51399(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges5_26,axiom,
    ! [VarCurr] :
      ( ( ~ v48405(VarCurr)
        & ~ v48406(VarCurr)
        & ~ v48407(VarCurr)
        & ~ v48408(VarCurr)
        & ~ v48420(VarCurr) )
     => ( v47901(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_29,axiom,
    ! [VarCurr] :
      ( v48420(VarCurr)
     => ( v47901(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_118,axiom,
    ! [VarCurr] :
      ( v48408(VarCurr)
     => ( v47901(VarCurr)
      <=> v51391(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_426,axiom,
    ! [VarCurr] :
      ( v48407(VarCurr)
     => ( v47901(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1131,axiom,
    ! [VarCurr] :
      ( v48406(VarCurr)
     => ( v47901(VarCurr)
      <=> v51389(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1098,axiom,
    ! [VarCurr] :
      ( v48405(VarCurr)
     => ( v47901(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1130,axiom,
    ! [VarCurr] :
      ( ~ v48410(VarCurr)
     => ( v51391(VarCurr)
      <=> v51394(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1097,axiom,
    ! [VarCurr] :
      ( v48410(VarCurr)
     => ( v51391(VarCurr)
      <=> v51392(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1129,axiom,
    ! [VarCurr] :
      ( ~ v49273(VarCurr)
     => ( v51394(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1096,axiom,
    ! [VarCurr] :
      ( v49273(VarCurr)
     => ( v51394(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1128,axiom,
    ! [VarCurr] :
      ( ~ v51393(VarCurr)
     => ( v51392(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1095,axiom,
    ! [VarCurr] :
      ( v51393(VarCurr)
     => ( v51392(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10766,axiom,
    ! [VarCurr] :
      ( v51393(VarCurr)
    <=> ( v48412(VarCurr)
        | v48414(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1127,axiom,
    ! [VarCurr] :
      ( ~ v49269(VarCurr)
     => ( v51389(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1094,axiom,
    ! [VarCurr] :
      ( v49269(VarCurr)
     => ( v51389(VarCurr)
      <=> v51390(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1126,axiom,
    ! [VarCurr] :
      ( ~ v50542(VarCurr)
     => ( v51390(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1093,axiom,
    ! [VarCurr] :
      ( v50542(VarCurr)
     => ( v51390(VarCurr)
      <=> $false ) ) ).

fof(addCaseBooleanConditionEqualRanges1_983,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51376(VarNext)
       => ! [B] :
            ( range_2_0(B)
           => ( v47903(VarNext,B)
            <=> v47903(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1045,axiom,
    ! [VarNext] :
      ( v51376(VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v47903(VarNext,B)
          <=> v51384(VarNext,B) ) ) ) ).

fof(addAssignment_18947,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v51384(VarNext,B)
          <=> v51382(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1599,axiom,
    ! [VarCurr] :
      ( ~ v51385(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51382(VarCurr,B)
          <=> v47905(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1434,axiom,
    ! [VarCurr] :
      ( v51385(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51382(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3242,axiom,
    ! [VarCurr] :
      ( v51385(VarCurr)
    <=> ( v45(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10765,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51376(VarNext)
      <=> v51377(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10764,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51377(VarNext)
      <=> ( v51378(VarNext)
          & v45620(VarNext) ) ) ) ).

fof(writeUnaryOperator_4543,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51378(VarNext)
      <=> v47885(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges5_25,axiom,
    ! [VarCurr] :
      ( ( ~ v51343(VarCurr)
        & ~ v51347(VarCurr)
        & ~ v51352(VarCurr)
        & ~ v51356(VarCurr)
        & ~ v51373(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v47905(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_28,axiom,
    ! [VarCurr] :
      ( v51373(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v47905(VarCurr,B)
          <=> b001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_117,axiom,
    ! [VarCurr] :
      ( v51356(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v47905(VarCurr,B)
          <=> v51357(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_425,axiom,
    ! [VarCurr] :
      ( v51352(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v47905(VarCurr,B)
          <=> v51353(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1125,axiom,
    ! [VarCurr] :
      ( v51347(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v47905(VarCurr,B)
          <=> v51348(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1092,axiom,
    ! [VarCurr] :
      ( v51343(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v47905(VarCurr,B)
          <=> v51344(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3241,axiom,
    ! [VarCurr] :
      ( v51373(VarCurr)
    <=> ( ( v47903(VarCurr,bitIndex2)
        <=> $true )
        & ( v47903(VarCurr,bitIndex1)
        <=> $false )
        & ( v47903(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1124,axiom,
    ! [VarCurr] :
      ( ~ v51358(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51357(VarCurr,B)
          <=> v51367(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1091,axiom,
    ! [VarCurr] :
      ( v51358(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51357(VarCurr,B)
          <=> v51359(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1123,axiom,
    ! [VarCurr] :
      ( ~ v51368(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51367(VarCurr,B)
          <=> v51370(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1090,axiom,
    ! [VarCurr] :
      ( v51368(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51367(VarCurr,B)
          <=> b001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1122,axiom,
    ! [VarCurr] :
      ( ~ v51371(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51370(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1089,axiom,
    ! [VarCurr] :
      ( v51371(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51370(VarCurr,B)
          <=> b001(B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3240,axiom,
    ! [VarCurr] :
      ( v51372(VarCurr)
    <=> ( v47907(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3239,axiom,
    ! [VarCurr] :
      ( v51371(VarCurr)
    <=> ( v47907(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_3238,axiom,
    ! [VarCurr] :
      ( v51369(VarCurr)
    <=> ( v48347(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3237,axiom,
    ! [VarCurr] :
      ( v51368(VarCurr)
    <=> ( v48347(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_3236,axiom,
    ! [VarCurr] :
      ( v51366(VarCurr)
    <=> ( v47899(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_424,axiom,
    ! [VarCurr] :
      ( ( ~ v51360(VarCurr)
        & ~ v51363(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v51359(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1121,axiom,
    ! [VarCurr] :
      ( v51363(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51359(VarCurr,B)
          <=> v51365(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1088,axiom,
    ! [VarCurr] :
      ( v51360(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51359(VarCurr,B)
          <=> v51362(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1598,axiom,
    ! [VarCurr] :
      ( ~ v48394(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51365(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1433,axiom,
    ! [VarCurr] :
      ( v48394(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51365(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3235,axiom,
    ! [VarCurr] :
      ( v51363(VarCurr)
    <=> ( ( v51364(VarCurr,bitIndex1)
        <=> $true )
        & ( v51364(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_18946,axiom,
    ! [VarCurr] :
      ( v51364(VarCurr,bitIndex0)
    <=> v47941(VarCurr) ) ).

fof(addAssignment_18945,axiom,
    ! [VarCurr] :
      ( v51364(VarCurr,bitIndex1)
    <=> v47935(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1597,axiom,
    ! [VarCurr] :
      ( ~ v49578(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51362(VarCurr,B)
          <=> b100(B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1432,axiom,
    ! [VarCurr] :
      ( v49578(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51362(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3234,axiom,
    ! [VarCurr] :
      ( v51360(VarCurr)
    <=> ( ( v51361(VarCurr,bitIndex1)
        <=> $false )
        & ( v51361(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_18944,axiom,
    ! [VarCurr] :
      ( v51361(VarCurr,bitIndex0)
    <=> v47941(VarCurr) ) ).

fof(addAssignment_18943,axiom,
    ! [VarCurr] :
      ( v51361(VarCurr,bitIndex1)
    <=> v47935(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_3233,axiom,
    ! [VarCurr] :
      ( v51358(VarCurr)
    <=> ( v47899(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3232,axiom,
    ! [VarCurr] :
      ( v51356(VarCurr)
    <=> ( ( v47903(VarCurr,bitIndex2)
        <=> $false )
        & ( v47903(VarCurr,bitIndex1)
        <=> $true )
        & ( v47903(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1120,axiom,
    ! [VarCurr] :
      ( ~ v51354(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51353(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1087,axiom,
    ! [VarCurr] :
      ( v51354(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51353(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3231,axiom,
    ! [VarCurr] :
      ( v51355(VarCurr)
    <=> ( v46409(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3230,axiom,
    ! [VarCurr] :
      ( v51354(VarCurr)
    <=> ( v46409(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_3229,axiom,
    ! [VarCurr] :
      ( v51352(VarCurr)
    <=> ( ( v47903(VarCurr,bitIndex2)
        <=> $false )
        & ( v47903(VarCurr,bitIndex1)
        <=> $true )
        & ( v47903(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1119,axiom,
    ! [VarCurr] :
      ( ~ v51349(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51348(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1086,axiom,
    ! [VarCurr] :
      ( v51349(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51348(VarCurr,B)
          <=> v51350(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3228,axiom,
    ! [VarCurr] :
      ( v51351(VarCurr)
    <=> ( v47899(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1596,axiom,
    ! [VarCurr] :
      ( ~ v48647(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51350(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1431,axiom,
    ! [VarCurr] :
      ( v48647(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51350(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3227,axiom,
    ! [VarCurr] :
      ( v51349(VarCurr)
    <=> ( v47899(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_3226,axiom,
    ! [VarCurr] :
      ( v51347(VarCurr)
    <=> ( ( v47903(VarCurr,bitIndex2)
        <=> $false )
        & ( v47903(VarCurr,bitIndex1)
        <=> $false )
        & ( v47903(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1118,axiom,
    ! [VarCurr] :
      ( ~ v51345(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51344(VarCurr,B)
          <=> b001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1085,axiom,
    ! [VarCurr] :
      ( v51345(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v51344(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3225,axiom,
    ! [VarCurr] :
      ( v51346(VarCurr)
    <=> ( v47907(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_3224,axiom,
    ! [VarCurr] :
      ( v51345(VarCurr)
    <=> ( v47907(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3223,axiom,
    ! [VarCurr] :
      ( v51343(VarCurr)
    <=> ( ( v47903(VarCurr,bitIndex2)
        <=> $false )
        & ( v47903(VarCurr,bitIndex1)
        <=> $false )
        & ( v47903(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10763,axiom,
    ! [VarCurr] :
      ( v47907(VarCurr)
    <=> ( v47909(VarCurr)
        | v47931(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_982,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51327(VarNext)
       => ( v47931(VarNext)
        <=> v47931(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1044,axiom,
    ! [VarNext] :
      ( v51327(VarNext)
     => ( v47931(VarNext)
      <=> v51335(VarNext) ) ) ).

fof(addAssignment_18942,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51335(VarNext)
      <=> v51333(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1595,axiom,
    ! [VarCurr] :
      ( ~ v48464(VarCurr)
     => ( v51333(VarCurr)
      <=> v51336(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1430,axiom,
    ! [VarCurr] :
      ( v48464(VarCurr)
     => ( v51333(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1594,axiom,
    ! [VarCurr] :
      ( ~ v47909(VarCurr)
     => ( v51336(VarCurr)
      <=> v51337(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1429,axiom,
    ! [VarCurr] :
      ( v47909(VarCurr)
     => ( v51336(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10762,axiom,
    ! [VarCurr] :
      ( v51337(VarCurr)
    <=> ( v51338(VarCurr)
        & v47931(VarCurr) ) ) ).

fof(writeUnaryOperator_4542,axiom,
    ! [VarCurr] :
      ( ~ v51338(VarCurr)
    <=> v47933(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10761,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51327(VarNext)
      <=> v51328(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10760,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51328(VarNext)
      <=> ( v51330(VarNext)
          & v45620(VarNext) ) ) ) ).

fof(writeUnaryOperator_4541,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51330(VarNext)
      <=> v47885(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_116,axiom,
    ! [VarCurr] :
      ( ( ~ v51321(VarCurr)
        & ~ v48408(VarCurr)
        & ~ v48420(VarCurr) )
     => ( v47933(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_423,axiom,
    ! [VarCurr] :
      ( v48420(VarCurr)
     => ( v47933(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1117,axiom,
    ! [VarCurr] :
      ( v48408(VarCurr)
     => ( v47933(VarCurr)
      <=> v51322(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1084,axiom,
    ! [VarCurr] :
      ( v51321(VarCurr)
     => ( v47933(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1116,axiom,
    ! [VarCurr] :
      ( ~ v48410(VarCurr)
     => ( v51322(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1083,axiom,
    ! [VarCurr] :
      ( v48410(VarCurr)
     => ( v51322(VarCurr)
      <=> v51323(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1115,axiom,
    ! [VarCurr] :
      ( ~ v51324(VarCurr)
     => ( v51323(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1082,axiom,
    ! [VarCurr] :
      ( v51324(VarCurr)
     => ( v51323(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10759,axiom,
    ! [VarCurr] :
      ( v51324(VarCurr)
    <=> ( v48412(VarCurr)
        | v48414(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10758,axiom,
    ! [VarCurr] :
      ( v51321(VarCurr)
    <=> ( v48404(VarCurr)
        | v48407(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1593,axiom,
    ! [VarCurr] :
      ( ~ v51190(VarCurr)
     => ( v47935(VarCurr)
      <=> v51317(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1428,axiom,
    ! [VarCurr] :
      ( v51190(VarCurr)
     => ( v47935(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1114,axiom,
    ! [VarCurr] :
      ( ~ v51192(VarCurr)
     => ( v51317(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1081,axiom,
    ! [VarCurr] :
      ( v51192(VarCurr)
     => ( v51317(VarCurr)
      <=> v51318(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1592,axiom,
    ! [VarCurr] :
      ( ~ v51198(VarCurr)
     => ( v51318(VarCurr)
      <=> v51319(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1427,axiom,
    ! [VarCurr] :
      ( v51198(VarCurr)
     => ( v51318(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1591,axiom,
    ! [VarCurr] :
      ( ~ v51200(VarCurr)
     => ( v51319(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1426,axiom,
    ! [VarCurr] :
      ( v51200(VarCurr)
     => ( v51319(VarCurr)
      <=> $false ) ) ).

fof(addCaseBooleanConditionEqualRanges1_981,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51305(VarNext)
       => ( v47937(VarNext)
        <=> v47937(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1043,axiom,
    ! [VarNext] :
      ( v51305(VarNext)
     => ( v47937(VarNext)
      <=> v51313(VarNext) ) ) ).

fof(addAssignment_18941,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51313(VarNext)
      <=> v51311(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1590,axiom,
    ! [VarCurr] :
      ( ~ v48464(VarCurr)
     => ( v51311(VarCurr)
      <=> v47939(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1425,axiom,
    ! [VarCurr] :
      ( v48464(VarCurr)
     => ( v51311(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10757,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51305(VarNext)
      <=> v51306(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10756,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51306(VarNext)
      <=> ( v51308(VarNext)
          & v45620(VarNext) ) ) ) ).

fof(writeUnaryOperator_4540,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51308(VarNext)
      <=> v47885(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_27,axiom,
    ! [VarCurr] :
      ( ( ~ v48405(VarCurr)
        & ~ v51298(VarCurr)
        & ~ v48408(VarCurr)
        & ~ v48420(VarCurr) )
     => ( v47939(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_115,axiom,
    ! [VarCurr] :
      ( v48420(VarCurr)
     => ( v47939(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_422,axiom,
    ! [VarCurr] :
      ( v48408(VarCurr)
     => ( v47939(VarCurr)
      <=> v51300(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1113,axiom,
    ! [VarCurr] :
      ( v51298(VarCurr)
     => ( v47939(VarCurr)
      <=> v51299(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1080,axiom,
    ! [VarCurr] :
      ( v48405(VarCurr)
     => ( v47939(VarCurr)
      <=> v51295(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1112,axiom,
    ! [VarCurr] :
      ( ~ v48410(VarCurr)
     => ( v51300(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1079,axiom,
    ! [VarCurr] :
      ( v48410(VarCurr)
     => ( v51300(VarCurr)
      <=> v51301(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1111,axiom,
    ! [VarCurr] :
      ( ~ v51302(VarCurr)
     => ( v51301(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1078,axiom,
    ! [VarCurr] :
      ( v51302(VarCurr)
     => ( v51301(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10755,axiom,
    ! [VarCurr] :
      ( v51302(VarCurr)
    <=> ( v48412(VarCurr)
        | v48414(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1110,axiom,
    ! [VarCurr] :
      ( ~ v49269(VarCurr)
     => ( v51299(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1077,axiom,
    ! [VarCurr] :
      ( v49269(VarCurr)
     => ( v51299(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10754,axiom,
    ! [VarCurr] :
      ( v51298(VarCurr)
    <=> ( v48406(VarCurr)
        | v48407(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1109,axiom,
    ! [VarCurr] :
      ( ~ v51296(VarCurr)
     => ( v51295(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1076,axiom,
    ! [VarCurr] :
      ( v51296(VarCurr)
     => ( v51295(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3222,axiom,
    ! [VarCurr] :
      ( v51297(VarCurr)
    <=> ( v47907(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_3221,axiom,
    ! [VarCurr] :
      ( v51296(VarCurr)
    <=> ( v47907(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1589,axiom,
    ! [VarCurr] :
      ( ~ v51190(VarCurr)
     => ( v47941(VarCurr)
      <=> v51191(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1424,axiom,
    ! [VarCurr] :
      ( v51190(VarCurr)
     => ( v47941(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1108,axiom,
    ! [VarCurr] :
      ( ~ v51192(VarCurr)
     => ( v51191(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1075,axiom,
    ! [VarCurr] :
      ( v51192(VarCurr)
     => ( v51191(VarCurr)
      <=> v51197(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1588,axiom,
    ! [VarCurr] :
      ( ~ v51198(VarCurr)
     => ( v51197(VarCurr)
      <=> v51199(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1423,axiom,
    ! [VarCurr] :
      ( v51198(VarCurr)
     => ( v51197(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1587,axiom,
    ! [VarCurr] :
      ( ~ v51200(VarCurr)
     => ( v51199(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1422,axiom,
    ! [VarCurr] :
      ( v51200(VarCurr)
     => ( v51199(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10753,axiom,
    ! [VarCurr] :
      ( v51200(VarCurr)
    <=> ( v51201(VarCurr)
        & v51236(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3220,axiom,
    ! [VarCurr] :
      ( v51236(VarCurr)
    <=> ( v51237(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges31_1,axiom,
    ! [VarCurr] :
      ( ( ~ v51262(VarCurr)
        & ~ v51263(VarCurr)
        & ~ v51264(VarCurr)
        & ~ v51265(VarCurr)
        & ~ v51266(VarCurr)
        & ~ v51267(VarCurr)
        & ~ v51268(VarCurr)
        & ~ v51269(VarCurr)
        & ~ v51270(VarCurr)
        & ~ v51271(VarCurr)
        & ~ v51272(VarCurr)
        & ~ v51273(VarCurr)
        & ~ v51274(VarCurr)
        & ~ v51275(VarCurr)
        & ~ v51276(VarCurr)
        & ~ v51277(VarCurr)
        & ~ v51278(VarCurr)
        & ~ v51279(VarCurr)
        & ~ v51280(VarCurr)
        & ~ v51281(VarCurr)
        & ~ v51282(VarCurr)
        & ~ v51283(VarCurr)
        & ~ v51284(VarCurr)
        & ~ v51285(VarCurr)
        & ~ v51286(VarCurr)
        & ~ v51287(VarCurr)
        & ~ v51288(VarCurr)
        & ~ v51289(VarCurr)
        & ~ v51290(VarCurr)
        & ~ v51291(VarCurr)
        & ~ v51292(VarCurr) )
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex31) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges30_1,axiom,
    ! [VarCurr] :
      ( v51292(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex30) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges29_1,axiom,
    ! [VarCurr] :
      ( v51291(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex29) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges28_1,axiom,
    ! [VarCurr] :
      ( v51290(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex28) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges27_1,axiom,
    ! [VarCurr] :
      ( v51289(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex27) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges26_1,axiom,
    ! [VarCurr] :
      ( v51288(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex26) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges25_1,axiom,
    ! [VarCurr] :
      ( v51287(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex25) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges24_1,axiom,
    ! [VarCurr] :
      ( v51286(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex24) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges23_1,axiom,
    ! [VarCurr] :
      ( v51285(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex23) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges22_1,axiom,
    ! [VarCurr] :
      ( v51284(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex22) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges21_1,axiom,
    ! [VarCurr] :
      ( v51283(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex21) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges20_1,axiom,
    ! [VarCurr] :
      ( v51282(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex20) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges19_1,axiom,
    ! [VarCurr] :
      ( v51281(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex19) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges18_1,axiom,
    ! [VarCurr] :
      ( v51280(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex18) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges17_1,axiom,
    ! [VarCurr] :
      ( v51279(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex17) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges16_1,axiom,
    ! [VarCurr] :
      ( v51278(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex16) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges15_1,axiom,
    ! [VarCurr] :
      ( v51277(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex15) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges14_2,axiom,
    ! [VarCurr] :
      ( v51276(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex14) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges13_2,axiom,
    ! [VarCurr] :
      ( v51275(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex13) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges12_2,axiom,
    ! [VarCurr] :
      ( v51274(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex12) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges11_2,axiom,
    ! [VarCurr] :
      ( v51273(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex11) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges10_3,axiom,
    ! [VarCurr] :
      ( v51272(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex10) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges9_3,axiom,
    ! [VarCurr] :
      ( v51271(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex9) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges8_3,axiom,
    ! [VarCurr] :
      ( v51270(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex8) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges7_6,axiom,
    ! [VarCurr] :
      ( v51269(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex7) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges6_6,axiom,
    ! [VarCurr] :
      ( v51268(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex6) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges5_4,axiom,
    ! [VarCurr] :
      ( v51267(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex5) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges4_7,axiom,
    ! [VarCurr] :
      ( v51266(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex4) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges3_4,axiom,
    ! [VarCurr] :
      ( v51265(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex3) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges2_11,axiom,
    ! [VarCurr] :
      ( v51264(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex2) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges1_10,axiom,
    ! [VarCurr] :
      ( v51263(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex1) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1074,axiom,
    ! [VarCurr] :
      ( v51262(VarCurr)
     => ( v51237(VarCurr)
      <=> v48167(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_3219,axiom,
    ! [VarCurr] :
      ( v51293(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $true )
        & ( v51239(VarCurr,bitIndex3)
        <=> $true )
        & ( v51239(VarCurr,bitIndex2)
        <=> $true )
        & ( v51239(VarCurr,bitIndex1)
        <=> $true )
        & ( v51239(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3218,axiom,
    ! [VarCurr] :
      ( v51292(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $true )
        & ( v51239(VarCurr,bitIndex3)
        <=> $true )
        & ( v51239(VarCurr,bitIndex2)
        <=> $true )
        & ( v51239(VarCurr,bitIndex1)
        <=> $true )
        & ( v51239(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3217,axiom,
    ! [VarCurr] :
      ( v51291(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $true )
        & ( v51239(VarCurr,bitIndex3)
        <=> $true )
        & ( v51239(VarCurr,bitIndex2)
        <=> $true )
        & ( v51239(VarCurr,bitIndex1)
        <=> $false )
        & ( v51239(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3216,axiom,
    ! [VarCurr] :
      ( v51290(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $true )
        & ( v51239(VarCurr,bitIndex3)
        <=> $true )
        & ( v51239(VarCurr,bitIndex2)
        <=> $true )
        & ( v51239(VarCurr,bitIndex1)
        <=> $false )
        & ( v51239(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3215,axiom,
    ! [VarCurr] :
      ( v51289(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $true )
        & ( v51239(VarCurr,bitIndex3)
        <=> $true )
        & ( v51239(VarCurr,bitIndex2)
        <=> $false )
        & ( v51239(VarCurr,bitIndex1)
        <=> $true )
        & ( v51239(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3214,axiom,
    ! [VarCurr] :
      ( v51288(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $true )
        & ( v51239(VarCurr,bitIndex3)
        <=> $true )
        & ( v51239(VarCurr,bitIndex2)
        <=> $false )
        & ( v51239(VarCurr,bitIndex1)
        <=> $true )
        & ( v51239(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3213,axiom,
    ! [VarCurr] :
      ( v51287(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $true )
        & ( v51239(VarCurr,bitIndex3)
        <=> $true )
        & ( v51239(VarCurr,bitIndex2)
        <=> $false )
        & ( v51239(VarCurr,bitIndex1)
        <=> $false )
        & ( v51239(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3212,axiom,
    ! [VarCurr] :
      ( v51286(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $true )
        & ( v51239(VarCurr,bitIndex3)
        <=> $true )
        & ( v51239(VarCurr,bitIndex2)
        <=> $false )
        & ( v51239(VarCurr,bitIndex1)
        <=> $false )
        & ( v51239(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3211,axiom,
    ! [VarCurr] :
      ( v51285(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $true )
        & ( v51239(VarCurr,bitIndex3)
        <=> $false )
        & ( v51239(VarCurr,bitIndex2)
        <=> $true )
        & ( v51239(VarCurr,bitIndex1)
        <=> $true )
        & ( v51239(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3210,axiom,
    ! [VarCurr] :
      ( v51284(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $true )
        & ( v51239(VarCurr,bitIndex3)
        <=> $false )
        & ( v51239(VarCurr,bitIndex2)
        <=> $true )
        & ( v51239(VarCurr,bitIndex1)
        <=> $true )
        & ( v51239(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3209,axiom,
    ! [VarCurr] :
      ( v51283(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $true )
        & ( v51239(VarCurr,bitIndex3)
        <=> $false )
        & ( v51239(VarCurr,bitIndex2)
        <=> $true )
        & ( v51239(VarCurr,bitIndex1)
        <=> $false )
        & ( v51239(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3208,axiom,
    ! [VarCurr] :
      ( v51282(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $true )
        & ( v51239(VarCurr,bitIndex3)
        <=> $false )
        & ( v51239(VarCurr,bitIndex2)
        <=> $true )
        & ( v51239(VarCurr,bitIndex1)
        <=> $false )
        & ( v51239(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3207,axiom,
    ! [VarCurr] :
      ( v51281(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $true )
        & ( v51239(VarCurr,bitIndex3)
        <=> $false )
        & ( v51239(VarCurr,bitIndex2)
        <=> $false )
        & ( v51239(VarCurr,bitIndex1)
        <=> $true )
        & ( v51239(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3206,axiom,
    ! [VarCurr] :
      ( v51280(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $true )
        & ( v51239(VarCurr,bitIndex3)
        <=> $false )
        & ( v51239(VarCurr,bitIndex2)
        <=> $false )
        & ( v51239(VarCurr,bitIndex1)
        <=> $true )
        & ( v51239(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3205,axiom,
    ! [VarCurr] :
      ( v51279(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $true )
        & ( v51239(VarCurr,bitIndex3)
        <=> $false )
        & ( v51239(VarCurr,bitIndex2)
        <=> $false )
        & ( v51239(VarCurr,bitIndex1)
        <=> $false )
        & ( v51239(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3204,axiom,
    ! [VarCurr] :
      ( v51278(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $true )
        & ( v51239(VarCurr,bitIndex3)
        <=> $false )
        & ( v51239(VarCurr,bitIndex2)
        <=> $false )
        & ( v51239(VarCurr,bitIndex1)
        <=> $false )
        & ( v51239(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3203,axiom,
    ! [VarCurr] :
      ( v51277(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $false )
        & ( v51239(VarCurr,bitIndex3)
        <=> $true )
        & ( v51239(VarCurr,bitIndex2)
        <=> $true )
        & ( v51239(VarCurr,bitIndex1)
        <=> $true )
        & ( v51239(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3202,axiom,
    ! [VarCurr] :
      ( v51276(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $false )
        & ( v51239(VarCurr,bitIndex3)
        <=> $true )
        & ( v51239(VarCurr,bitIndex2)
        <=> $true )
        & ( v51239(VarCurr,bitIndex1)
        <=> $true )
        & ( v51239(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3201,axiom,
    ! [VarCurr] :
      ( v51275(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $false )
        & ( v51239(VarCurr,bitIndex3)
        <=> $true )
        & ( v51239(VarCurr,bitIndex2)
        <=> $true )
        & ( v51239(VarCurr,bitIndex1)
        <=> $false )
        & ( v51239(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3200,axiom,
    ! [VarCurr] :
      ( v51274(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $false )
        & ( v51239(VarCurr,bitIndex3)
        <=> $true )
        & ( v51239(VarCurr,bitIndex2)
        <=> $true )
        & ( v51239(VarCurr,bitIndex1)
        <=> $false )
        & ( v51239(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3199,axiom,
    ! [VarCurr] :
      ( v51273(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $false )
        & ( v51239(VarCurr,bitIndex3)
        <=> $true )
        & ( v51239(VarCurr,bitIndex2)
        <=> $false )
        & ( v51239(VarCurr,bitIndex1)
        <=> $true )
        & ( v51239(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3198,axiom,
    ! [VarCurr] :
      ( v51272(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $false )
        & ( v51239(VarCurr,bitIndex3)
        <=> $true )
        & ( v51239(VarCurr,bitIndex2)
        <=> $false )
        & ( v51239(VarCurr,bitIndex1)
        <=> $true )
        & ( v51239(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3197,axiom,
    ! [VarCurr] :
      ( v51271(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $false )
        & ( v51239(VarCurr,bitIndex3)
        <=> $true )
        & ( v51239(VarCurr,bitIndex2)
        <=> $false )
        & ( v51239(VarCurr,bitIndex1)
        <=> $false )
        & ( v51239(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3196,axiom,
    ! [VarCurr] :
      ( v51270(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $false )
        & ( v51239(VarCurr,bitIndex3)
        <=> $true )
        & ( v51239(VarCurr,bitIndex2)
        <=> $false )
        & ( v51239(VarCurr,bitIndex1)
        <=> $false )
        & ( v51239(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3195,axiom,
    ! [VarCurr] :
      ( v51269(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $false )
        & ( v51239(VarCurr,bitIndex3)
        <=> $false )
        & ( v51239(VarCurr,bitIndex2)
        <=> $true )
        & ( v51239(VarCurr,bitIndex1)
        <=> $true )
        & ( v51239(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3194,axiom,
    ! [VarCurr] :
      ( v51268(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $false )
        & ( v51239(VarCurr,bitIndex3)
        <=> $false )
        & ( v51239(VarCurr,bitIndex2)
        <=> $true )
        & ( v51239(VarCurr,bitIndex1)
        <=> $true )
        & ( v51239(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3193,axiom,
    ! [VarCurr] :
      ( v51267(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $false )
        & ( v51239(VarCurr,bitIndex3)
        <=> $false )
        & ( v51239(VarCurr,bitIndex2)
        <=> $true )
        & ( v51239(VarCurr,bitIndex1)
        <=> $false )
        & ( v51239(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3192,axiom,
    ! [VarCurr] :
      ( v51266(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $false )
        & ( v51239(VarCurr,bitIndex3)
        <=> $false )
        & ( v51239(VarCurr,bitIndex2)
        <=> $true )
        & ( v51239(VarCurr,bitIndex1)
        <=> $false )
        & ( v51239(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3191,axiom,
    ! [VarCurr] :
      ( v51265(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $false )
        & ( v51239(VarCurr,bitIndex3)
        <=> $false )
        & ( v51239(VarCurr,bitIndex2)
        <=> $false )
        & ( v51239(VarCurr,bitIndex1)
        <=> $true )
        & ( v51239(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3190,axiom,
    ! [VarCurr] :
      ( v51264(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $false )
        & ( v51239(VarCurr,bitIndex3)
        <=> $false )
        & ( v51239(VarCurr,bitIndex2)
        <=> $false )
        & ( v51239(VarCurr,bitIndex1)
        <=> $true )
        & ( v51239(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3189,axiom,
    ! [VarCurr] :
      ( v51263(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $false )
        & ( v51239(VarCurr,bitIndex3)
        <=> $false )
        & ( v51239(VarCurr,bitIndex2)
        <=> $false )
        & ( v51239(VarCurr,bitIndex1)
        <=> $false )
        & ( v51239(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3188,axiom,
    ! [VarCurr] :
      ( v51262(VarCurr)
    <=> ( ( v51239(VarCurr,bitIndex4)
        <=> $false )
        & ( v51239(VarCurr,bitIndex3)
        <=> $false )
        & ( v51239(VarCurr,bitIndex2)
        <=> $false )
        & ( v51239(VarCurr,bitIndex1)
        <=> $false )
        & ( v51239(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_18940,axiom,
    ! [VarCurr] :
      ( v51239(VarCurr,bitIndex0)
    <=> v50680(VarCurr) ) ).

fof(addAssignment_18939,axiom,
    ! [VarCurr] :
      ( v51239(VarCurr,bitIndex1)
    <=> v51259(VarCurr) ) ).

fof(addAssignment_18938,axiom,
    ! [VarCurr] :
      ( v51239(VarCurr,bitIndex2)
    <=> v51255(VarCurr) ) ).

fof(addAssignment_18937,axiom,
    ! [VarCurr] :
      ( v51239(VarCurr,bitIndex3)
    <=> v51251(VarCurr) ) ).

fof(addAssignment_18936,axiom,
    ! [VarCurr] :
      ( v51239(VarCurr,bitIndex4)
    <=> v51241(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10752,axiom,
    ! [VarCurr] :
      ( v51259(VarCurr)
    <=> ( v51260(VarCurr)
        & v51261(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10751,axiom,
    ! [VarCurr] :
      ( v51261(VarCurr)
    <=> ( v47943(VarCurr,bitIndex0)
        | v50640(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1902,axiom,
    ! [VarCurr] :
      ( v51260(VarCurr)
    <=> ( v50680(VarCurr)
        | v47943(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10750,axiom,
    ! [VarCurr] :
      ( v51255(VarCurr)
    <=> ( v51256(VarCurr)
        & v51258(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10749,axiom,
    ! [VarCurr] :
      ( v51258(VarCurr)
    <=> ( v50646(VarCurr)
        | v51248(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1901,axiom,
    ! [VarCurr] :
      ( v51256(VarCurr)
    <=> ( v47943(VarCurr,bitIndex2)
        | v51257(VarCurr) ) ) ).

fof(writeUnaryOperator_4539,axiom,
    ! [VarCurr] :
      ( ~ v51257(VarCurr)
    <=> v51248(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10748,axiom,
    ! [VarCurr] :
      ( v51251(VarCurr)
    <=> ( v51252(VarCurr)
        & v51254(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10747,axiom,
    ! [VarCurr] :
      ( v51254(VarCurr)
    <=> ( v50652(VarCurr)
        | v51246(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1900,axiom,
    ! [VarCurr] :
      ( v51252(VarCurr)
    <=> ( v47943(VarCurr,bitIndex3)
        | v51253(VarCurr) ) ) ).

fof(writeUnaryOperator_4538,axiom,
    ! [VarCurr] :
      ( ~ v51253(VarCurr)
    <=> v51246(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10746,axiom,
    ! [VarCurr] :
      ( v51241(VarCurr)
    <=> ( v51242(VarCurr)
        & v51250(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10745,axiom,
    ! [VarCurr] :
      ( v51250(VarCurr)
    <=> ( v50659(VarCurr)
        | v51244(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1899,axiom,
    ! [VarCurr] :
      ( v51242(VarCurr)
    <=> ( v47943(VarCurr,bitIndex4)
        | v51243(VarCurr) ) ) ).

fof(writeUnaryOperator_4537,axiom,
    ! [VarCurr] :
      ( ~ v51243(VarCurr)
    <=> v51244(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_1898,axiom,
    ! [VarCurr] :
      ( v51244(VarCurr)
    <=> ( v47943(VarCurr,bitIndex3)
        | v51245(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10744,axiom,
    ! [VarCurr] :
      ( v51245(VarCurr)
    <=> ( v50652(VarCurr)
        & v51246(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1897,axiom,
    ! [VarCurr] :
      ( v51246(VarCurr)
    <=> ( v47943(VarCurr,bitIndex2)
        | v51247(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10743,axiom,
    ! [VarCurr] :
      ( v51247(VarCurr)
    <=> ( v50646(VarCurr)
        & v51248(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1896,axiom,
    ! [VarCurr] :
      ( v51248(VarCurr)
    <=> ( v47943(VarCurr,bitIndex1)
        | v51249(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10742,axiom,
    ! [VarCurr] :
      ( v51249(VarCurr)
    <=> ( v47943(VarCurr,bitIndex0)
        & v50640(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3187,axiom,
    ! [VarCurr] :
      ( v51201(VarCurr)
    <=> ( v51202(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges31,axiom,
    ! [VarCurr] :
      ( ( ~ v51204(VarCurr)
        & ~ v51205(VarCurr)
        & ~ v51206(VarCurr)
        & ~ v51207(VarCurr)
        & ~ v51208(VarCurr)
        & ~ v51209(VarCurr)
        & ~ v51210(VarCurr)
        & ~ v51211(VarCurr)
        & ~ v51212(VarCurr)
        & ~ v51213(VarCurr)
        & ~ v51214(VarCurr)
        & ~ v51215(VarCurr)
        & ~ v51216(VarCurr)
        & ~ v51217(VarCurr)
        & ~ v51218(VarCurr)
        & ~ v51219(VarCurr)
        & ~ v51220(VarCurr)
        & ~ v51221(VarCurr)
        & ~ v51222(VarCurr)
        & ~ v51223(VarCurr)
        & ~ v51224(VarCurr)
        & ~ v51225(VarCurr)
        & ~ v51226(VarCurr)
        & ~ v51227(VarCurr)
        & ~ v51228(VarCurr)
        & ~ v51229(VarCurr)
        & ~ v51230(VarCurr)
        & ~ v51231(VarCurr)
        & ~ v51232(VarCurr)
        & ~ v51233(VarCurr)
        & ~ v51234(VarCurr) )
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex31) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges30,axiom,
    ! [VarCurr] :
      ( v51234(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex30) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges29,axiom,
    ! [VarCurr] :
      ( v51233(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex29) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges28,axiom,
    ! [VarCurr] :
      ( v51232(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex28) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges27,axiom,
    ! [VarCurr] :
      ( v51231(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex27) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges26,axiom,
    ! [VarCurr] :
      ( v51230(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex26) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges25,axiom,
    ! [VarCurr] :
      ( v51229(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex25) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges24,axiom,
    ! [VarCurr] :
      ( v51228(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex24) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges23,axiom,
    ! [VarCurr] :
      ( v51227(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex23) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges22,axiom,
    ! [VarCurr] :
      ( v51226(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex22) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges21,axiom,
    ! [VarCurr] :
      ( v51225(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex21) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges20,axiom,
    ! [VarCurr] :
      ( v51224(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex20) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges19,axiom,
    ! [VarCurr] :
      ( v51223(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex19) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges18,axiom,
    ! [VarCurr] :
      ( v51222(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex18) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges17,axiom,
    ! [VarCurr] :
      ( v51221(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex17) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges16,axiom,
    ! [VarCurr] :
      ( v51220(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex16) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges15,axiom,
    ! [VarCurr] :
      ( v51219(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex15) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges14_1,axiom,
    ! [VarCurr] :
      ( v51218(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex14) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges13_1,axiom,
    ! [VarCurr] :
      ( v51217(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex13) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges12_1,axiom,
    ! [VarCurr] :
      ( v51216(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex12) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges11_1,axiom,
    ! [VarCurr] :
      ( v51215(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex11) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges10_2,axiom,
    ! [VarCurr] :
      ( v51214(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex10) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges9_2,axiom,
    ! [VarCurr] :
      ( v51213(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex9) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges8_2,axiom,
    ! [VarCurr] :
      ( v51212(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex8) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges7_5,axiom,
    ! [VarCurr] :
      ( v51211(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex7) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges6_5,axiom,
    ! [VarCurr] :
      ( v51210(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex6) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges5_3,axiom,
    ! [VarCurr] :
      ( v51209(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex5) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges4_6,axiom,
    ! [VarCurr] :
      ( v51208(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex4) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges3_3,axiom,
    ! [VarCurr] :
      ( v51207(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex3) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges2_10,axiom,
    ! [VarCurr] :
      ( v51206(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex2) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges1_9,axiom,
    ! [VarCurr] :
      ( v51205(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex1) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1073,axiom,
    ! [VarCurr] :
      ( v51204(VarCurr)
     => ( v51202(VarCurr)
      <=> v48167(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_3186,axiom,
    ! [VarCurr] :
      ( v51235(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3185,axiom,
    ! [VarCurr] :
      ( v51234(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3184,axiom,
    ! [VarCurr] :
      ( v51233(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3183,axiom,
    ! [VarCurr] :
      ( v51232(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3182,axiom,
    ! [VarCurr] :
      ( v51231(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3181,axiom,
    ! [VarCurr] :
      ( v51230(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3180,axiom,
    ! [VarCurr] :
      ( v51229(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3179,axiom,
    ! [VarCurr] :
      ( v51228(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3178,axiom,
    ! [VarCurr] :
      ( v51227(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3177,axiom,
    ! [VarCurr] :
      ( v51226(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3176,axiom,
    ! [VarCurr] :
      ( v51225(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3175,axiom,
    ! [VarCurr] :
      ( v51224(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3174,axiom,
    ! [VarCurr] :
      ( v51223(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3173,axiom,
    ! [VarCurr] :
      ( v51222(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3172,axiom,
    ! [VarCurr] :
      ( v51221(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3171,axiom,
    ! [VarCurr] :
      ( v51220(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3170,axiom,
    ! [VarCurr] :
      ( v51219(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3169,axiom,
    ! [VarCurr] :
      ( v51218(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3168,axiom,
    ! [VarCurr] :
      ( v51217(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3167,axiom,
    ! [VarCurr] :
      ( v51216(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3166,axiom,
    ! [VarCurr] :
      ( v51215(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3165,axiom,
    ! [VarCurr] :
      ( v51214(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3164,axiom,
    ! [VarCurr] :
      ( v51213(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3163,axiom,
    ! [VarCurr] :
      ( v51212(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3162,axiom,
    ! [VarCurr] :
      ( v51211(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3161,axiom,
    ! [VarCurr] :
      ( v51210(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3160,axiom,
    ! [VarCurr] :
      ( v51209(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3159,axiom,
    ! [VarCurr] :
      ( v51208(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3158,axiom,
    ! [VarCurr] :
      ( v51207(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3157,axiom,
    ! [VarCurr] :
      ( v51206(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3156,axiom,
    ! [VarCurr] :
      ( v51205(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3155,axiom,
    ! [VarCurr] :
      ( v51204(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3154,axiom,
    ! [VarCurr] :
      ( v51198(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10741,axiom,
    ! [VarCurr] :
      ( v51192(VarCurr)
    <=> ( v51193(VarCurr)
        | v51195(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3153,axiom,
    ! [VarCurr] :
      ( v51195(VarCurr)
    <=> ( ( v51196(VarCurr,bitIndex3)
        <=> $false )
        & ( v51196(VarCurr,bitIndex2)
        <=> $true )
        & ( v51196(VarCurr,bitIndex1)
        <=> $false )
        & ( v51196(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_18935,axiom,
    ! [VarCurr] :
      ( v51196(VarCurr,bitIndex0)
    <=> v47937(VarCurr) ) ).

fof(addAssignment_18934,axiom,
    ! [VarCurr] :
      ( ( v51196(VarCurr,bitIndex3)
      <=> v46454(VarCurr,bitIndex2) )
      & ( v51196(VarCurr,bitIndex2)
      <=> v46454(VarCurr,bitIndex1) )
      & ( v51196(VarCurr,bitIndex1)
      <=> v46454(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_3152,axiom,
    ! [VarCurr] :
      ( v51193(VarCurr)
    <=> ( ( v51194(VarCurr,bitIndex3)
        <=> $false )
        & ( v51194(VarCurr,bitIndex2)
        <=> $false )
        & ( v51194(VarCurr,bitIndex1)
        <=> $true )
        & ( v51194(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_18933,axiom,
    ! [VarCurr] :
      ( v51194(VarCurr,bitIndex0)
    <=> v47937(VarCurr) ) ).

fof(addAssignment_18932,axiom,
    ! [VarCurr] :
      ( ( v51194(VarCurr,bitIndex3)
      <=> v46454(VarCurr,bitIndex2) )
      & ( v51194(VarCurr,bitIndex2)
      <=> v46454(VarCurr,bitIndex1) )
      & ( v51194(VarCurr,bitIndex1)
      <=> v46454(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_3151,axiom,
    ! [VarCurr] :
      ( v51190(VarCurr)
    <=> ( v45(VarCurr)
      <=> $false ) ) ).

fof(addAssignment_18931,axiom,
    ! [VarCurr] :
      ( v48169(VarCurr,bitIndex0)
    <=> v48171(VarCurr,bitIndex0) ) ).

fof(addAssignment_18930,axiom,
    ! [VarCurr] :
      ( v48171(VarCurr,bitIndex0)
    <=> v48173(VarCurr,bitIndex0) ) ).

fof(addAssignment_18929,axiom,
    ! [VarCurr] :
      ( v48173(VarCurr,bitIndex0)
    <=> v48175(VarCurr,bitIndex0) ) ).

fof(addAssignment_18928,axiom,
    ! [VarCurr] :
      ( v48175(VarCurr,bitIndex0)
    <=> v49506(VarCurr,bitIndex0) ) ).

fof(addAssignment_18927,axiom,
    ! [VarCurr] :
      ( v48337(VarCurr)
    <=> v48339(VarCurr) ) ).

fof(addAssignment_18926,axiom,
    ! [VarCurr] :
      ( v48339(VarCurr)
    <=> v48341(VarCurr) ) ).

fof(addAssignment_18925,axiom,
    ! [VarCurr] :
      ( v48341(VarCurr)
    <=> v48343(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_980,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51178(VarNext)
       => ( v48343(VarNext)
        <=> v48343(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1042,axiom,
    ! [VarNext] :
      ( v51178(VarNext)
     => ( v48343(VarNext)
      <=> v51186(VarNext) ) ) ).

fof(addAssignment_18924,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51186(VarNext)
      <=> v51184(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1586,axiom,
    ! [VarCurr] :
      ( ~ v48464(VarCurr)
     => ( v51184(VarCurr)
      <=> v48345(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1421,axiom,
    ! [VarCurr] :
      ( v48464(VarCurr)
     => ( v51184(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10740,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51178(VarNext)
      <=> v51179(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10739,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51179(VarNext)
      <=> ( v51181(VarNext)
          & v45620(VarNext) ) ) ) ).

fof(writeUnaryOperator_4536,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51181(VarNext)
      <=> v47885(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_114,axiom,
    ! [VarCurr] :
      ( ( ~ v51172(VarCurr)
        & ~ v48408(VarCurr)
        & ~ v48420(VarCurr) )
     => ( v48345(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_421,axiom,
    ! [VarCurr] :
      ( v48420(VarCurr)
     => ( v48345(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1107,axiom,
    ! [VarCurr] :
      ( v48408(VarCurr)
     => ( v48345(VarCurr)
      <=> v51173(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1072,axiom,
    ! [VarCurr] :
      ( v51172(VarCurr)
     => ( v48345(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1106,axiom,
    ! [VarCurr] :
      ( ~ v48410(VarCurr)
     => ( v51173(VarCurr)
      <=> v51175(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1071,axiom,
    ! [VarCurr] :
      ( v48410(VarCurr)
     => ( v51173(VarCurr)
      <=> v51174(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1105,axiom,
    ! [VarCurr] :
      ( ~ v49273(VarCurr)
     => ( v51175(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1070,axiom,
    ! [VarCurr] :
      ( v49273(VarCurr)
     => ( v51175(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_420,axiom,
    ! [VarCurr] :
      ( ( ~ v48412(VarCurr)
        & ~ v48414(VarCurr) )
     => ( v51174(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1104,axiom,
    ! [VarCurr] :
      ( v48414(VarCurr)
     => ( v51174(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1069,axiom,
    ! [VarCurr] :
      ( v48412(VarCurr)
     => ( v51174(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10738,axiom,
    ! [VarCurr] :
      ( v51172(VarCurr)
    <=> ( v48404(VarCurr)
        | v48407(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_979,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51160(VarNext)
       => ( v48347(VarNext)
        <=> v48347(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1041,axiom,
    ! [VarNext] :
      ( v51160(VarNext)
     => ( v48347(VarNext)
      <=> v51168(VarNext) ) ) ).

fof(addAssignment_18923,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51168(VarNext)
      <=> v51166(VarCurr) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_479,axiom,
    ! [VarCurr] :
      ( ~ v48464(VarCurr)
     => ( v51166(VarCurr)
      <=> v48349(VarCurr,bitIndex4) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1420,axiom,
    ! [VarCurr] :
      ( v48464(VarCurr)
     => ( v51166(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10737,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51160(VarNext)
      <=> v51161(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10736,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51161(VarNext)
      <=> ( v51163(VarNext)
          & v45620(VarNext) ) ) ) ).

fof(writeUnaryOperator_4535,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51163(VarNext)
      <=> v47885(VarNext) ) ) ).

fof(addAssignment_18922,axiom,
    ! [VarCurr] :
      ( v48349(VarCurr,bitIndex4)
    <=> v48351(VarCurr,bitIndex4) ) ).

fof(addAssignment_18921,axiom,
    ! [VarCurr] :
      ( v48351(VarCurr,bitIndex4)
    <=> v48353(VarCurr,bitIndex4) ) ).

fof(addAssignment_18920,axiom,
    ! [VarCurr] :
      ( v48353(VarCurr,bitIndex4)
    <=> v48355(VarCurr,bitIndex4) ) ).

fof(addAssignment_18919,axiom,
    ! [VarCurr] :
      ( v48355(VarCurr,bitIndex4)
    <=> v50684(VarCurr,bitIndex4) ) ).

fof(memoryReadIntoBuffer_89,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00000_address_term = A
             => ( range_4_0(B)
               => ( v50866(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_88,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00001_address_term = A
             => ( range_4_0(B)
               => ( v50875(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_87,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00010_address_term = A
             => ( range_4_0(B)
               => ( v50884(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_86,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00011_address_term = A
             => ( range_4_0(B)
               => ( v50893(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_85,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00100_address_term = A
             => ( range_4_0(B)
               => ( v50902(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_84,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00101_address_term = A
             => ( range_4_0(B)
               => ( v50911(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_83,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00110_address_term = A
             => ( range_4_0(B)
               => ( v50920(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_82,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00111_address_term = A
             => ( range_4_0(B)
               => ( v50929(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_81,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01000_address_term = A
             => ( range_4_0(B)
               => ( v50938(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_80,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01001_address_term = A
             => ( range_4_0(B)
               => ( v50947(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_79,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01010_address_term = A
             => ( range_4_0(B)
               => ( v50956(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_78,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01011_address_term = A
             => ( range_4_0(B)
               => ( v50965(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_77,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01100_address_term = A
             => ( range_4_0(B)
               => ( v50974(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_76,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01101_address_term = A
             => ( range_4_0(B)
               => ( v50983(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_75,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01110_address_term = A
             => ( range_4_0(B)
               => ( v50992(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_74,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01111_address_term = A
             => ( range_4_0(B)
               => ( v51001(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_73,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10000_address_term = A
             => ( range_4_0(B)
               => ( v51010(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_72,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10001_address_term = A
             => ( range_4_0(B)
               => ( v51019(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_71,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10010_address_term = A
             => ( range_4_0(B)
               => ( v51028(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_70,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10011_address_term = A
             => ( range_4_0(B)
               => ( v51037(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_69,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10100_address_term = A
             => ( range_4_0(B)
               => ( v51046(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_68,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10101_address_term = A
             => ( range_4_0(B)
               => ( v51055(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_67,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10110_address_term = A
             => ( range_4_0(B)
               => ( v51064(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_66,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10111_address_term = A
             => ( range_4_0(B)
               => ( v51073(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_65,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11000_address_term = A
             => ( range_4_0(B)
               => ( v51082(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_64,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11001_address_term = A
             => ( range_4_0(B)
               => ( v51091(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_63,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11010_address_term = A
             => ( range_4_0(B)
               => ( v51100(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_62,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11011_address_term = A
             => ( range_4_0(B)
               => ( v51109(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_61,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11100_address_term = A
             => ( range_4_0(B)
               => ( v51118(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_60,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11101_address_term = A
             => ( range_4_0(B)
               => ( v51127(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_59,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11110_address_term = A
             => ( range_4_0(B)
               => ( v51136(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_58,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11111_address_term = A
             => ( range_4_0(B)
               => ( v51145(VarNext,B)
                <=> v48357_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_57,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v50561_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( address(A)
             => ! [B] :
                  ( A = AssociatedAddressVar
                 => ( range_4_0(B)
                   => ( v50684(VarNext,B)
                    <=> v48357_array(VarNext,A,B) ) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_56,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v48599_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( address(A)
             => ! [B] :
                  ( A = AssociatedAddressVar
                 => ( range_4_0(B)
                   => ( v51156(VarNext,B)
                    <=> v48357_array(VarNext,A,B) ) ) ) ) ) ) ).

fof(memoryConstantWriteDisabled_7,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( $true
              & v51148(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_array(VarNext,A,B)
              <=> v48357_36__array(VarNext,A,B) ) ) ) ) ).

fof(memoryConstantWriteEnabledInsideRange_7,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( $true
            & v51148(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_array(VarNext,A,B)
              <=> b00000(B) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10735,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51148(VarNext)
      <=> ( v51149(VarNext)
          & v51154(VarNext) ) ) ) ).

fof(addAssignment_18918,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51154(VarNext)
      <=> v50819(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10734,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51149(VarNext)
      <=> ( v51151(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4534,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51151(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_93,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11111_address_term = A
              & v51139(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_36__array(VarNext,A,B)
              <=> v48357_35__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_93,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11111_address_term = A
            & v51139(VarNext) )
         => ( ( v48357_36__array(VarNext,A,bitIndex4)
            <=> v51145(VarNext,bitIndex159) )
            & ( v48357_36__array(VarNext,A,bitIndex3)
            <=> v51145(VarNext,bitIndex158) )
            & ( v48357_36__array(VarNext,A,bitIndex2)
            <=> v51145(VarNext,bitIndex157) )
            & ( v48357_36__array(VarNext,A,bitIndex1)
            <=> v51145(VarNext,bitIndex156) )
            & ( v48357_36__array(VarNext,A,bitIndex0)
            <=> v51145(VarNext,bitIndex155) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10733,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51139(VarNext)
      <=> ( v51140(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10732,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51140(VarNext)
      <=> ( v51142(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4533,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51142(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_92,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11110_address_term = A
              & v51130(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_35__array(VarNext,A,B)
              <=> v48357_34__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_92,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11110_address_term = A
            & v51130(VarNext) )
         => ( ( v48357_35__array(VarNext,A,bitIndex4)
            <=> v51136(VarNext,bitIndex154) )
            & ( v48357_35__array(VarNext,A,bitIndex3)
            <=> v51136(VarNext,bitIndex153) )
            & ( v48357_35__array(VarNext,A,bitIndex2)
            <=> v51136(VarNext,bitIndex152) )
            & ( v48357_35__array(VarNext,A,bitIndex1)
            <=> v51136(VarNext,bitIndex151) )
            & ( v48357_35__array(VarNext,A,bitIndex0)
            <=> v51136(VarNext,bitIndex150) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10731,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51130(VarNext)
      <=> ( v51131(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10730,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51131(VarNext)
      <=> ( v51133(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4532,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51133(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_91,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11101_address_term = A
              & v51121(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_34__array(VarNext,A,B)
              <=> v48357_33__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_91,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11101_address_term = A
            & v51121(VarNext) )
         => ( ( v48357_34__array(VarNext,A,bitIndex4)
            <=> v51127(VarNext,bitIndex149) )
            & ( v48357_34__array(VarNext,A,bitIndex3)
            <=> v51127(VarNext,bitIndex148) )
            & ( v48357_34__array(VarNext,A,bitIndex2)
            <=> v51127(VarNext,bitIndex147) )
            & ( v48357_34__array(VarNext,A,bitIndex1)
            <=> v51127(VarNext,bitIndex146) )
            & ( v48357_34__array(VarNext,A,bitIndex0)
            <=> v51127(VarNext,bitIndex145) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10729,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51121(VarNext)
      <=> ( v51122(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10728,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51122(VarNext)
      <=> ( v51124(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4531,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51124(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_90,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11100_address_term = A
              & v51112(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_33__array(VarNext,A,B)
              <=> v48357_32__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_90,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11100_address_term = A
            & v51112(VarNext) )
         => ( ( v48357_33__array(VarNext,A,bitIndex4)
            <=> v51118(VarNext,bitIndex144) )
            & ( v48357_33__array(VarNext,A,bitIndex3)
            <=> v51118(VarNext,bitIndex143) )
            & ( v48357_33__array(VarNext,A,bitIndex2)
            <=> v51118(VarNext,bitIndex142) )
            & ( v48357_33__array(VarNext,A,bitIndex1)
            <=> v51118(VarNext,bitIndex141) )
            & ( v48357_33__array(VarNext,A,bitIndex0)
            <=> v51118(VarNext,bitIndex140) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10727,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51112(VarNext)
      <=> ( v51113(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10726,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51113(VarNext)
      <=> ( v51115(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4530,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51115(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_89,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11011_address_term = A
              & v51103(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_32__array(VarNext,A,B)
              <=> v48357_31__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_89,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11011_address_term = A
            & v51103(VarNext) )
         => ( ( v48357_32__array(VarNext,A,bitIndex4)
            <=> v51109(VarNext,bitIndex139) )
            & ( v48357_32__array(VarNext,A,bitIndex3)
            <=> v51109(VarNext,bitIndex138) )
            & ( v48357_32__array(VarNext,A,bitIndex2)
            <=> v51109(VarNext,bitIndex137) )
            & ( v48357_32__array(VarNext,A,bitIndex1)
            <=> v51109(VarNext,bitIndex136) )
            & ( v48357_32__array(VarNext,A,bitIndex0)
            <=> v51109(VarNext,bitIndex135) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10725,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51103(VarNext)
      <=> ( v51104(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10724,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51104(VarNext)
      <=> ( v51106(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4529,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51106(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_88,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11010_address_term = A
              & v51094(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_31__array(VarNext,A,B)
              <=> v48357_30__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_88,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11010_address_term = A
            & v51094(VarNext) )
         => ( ( v48357_31__array(VarNext,A,bitIndex4)
            <=> v51100(VarNext,bitIndex134) )
            & ( v48357_31__array(VarNext,A,bitIndex3)
            <=> v51100(VarNext,bitIndex133) )
            & ( v48357_31__array(VarNext,A,bitIndex2)
            <=> v51100(VarNext,bitIndex132) )
            & ( v48357_31__array(VarNext,A,bitIndex1)
            <=> v51100(VarNext,bitIndex131) )
            & ( v48357_31__array(VarNext,A,bitIndex0)
            <=> v51100(VarNext,bitIndex130) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10723,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51094(VarNext)
      <=> ( v51095(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10722,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51095(VarNext)
      <=> ( v51097(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4528,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51097(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_87,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11001_address_term = A
              & v51085(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_30__array(VarNext,A,B)
              <=> v48357_29__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_87,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11001_address_term = A
            & v51085(VarNext) )
         => ( ( v48357_30__array(VarNext,A,bitIndex4)
            <=> v51091(VarNext,bitIndex129) )
            & ( v48357_30__array(VarNext,A,bitIndex3)
            <=> v51091(VarNext,bitIndex128) )
            & ( v48357_30__array(VarNext,A,bitIndex2)
            <=> v51091(VarNext,bitIndex127) )
            & ( v48357_30__array(VarNext,A,bitIndex1)
            <=> v51091(VarNext,bitIndex126) )
            & ( v48357_30__array(VarNext,A,bitIndex0)
            <=> v51091(VarNext,bitIndex125) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10721,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51085(VarNext)
      <=> ( v51086(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10720,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51086(VarNext)
      <=> ( v51088(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4527,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51088(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_86,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11000_address_term = A
              & v51076(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_29__array(VarNext,A,B)
              <=> v48357_28__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_86,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11000_address_term = A
            & v51076(VarNext) )
         => ( ( v48357_29__array(VarNext,A,bitIndex4)
            <=> v51082(VarNext,bitIndex124) )
            & ( v48357_29__array(VarNext,A,bitIndex3)
            <=> v51082(VarNext,bitIndex123) )
            & ( v48357_29__array(VarNext,A,bitIndex2)
            <=> v51082(VarNext,bitIndex122) )
            & ( v48357_29__array(VarNext,A,bitIndex1)
            <=> v51082(VarNext,bitIndex121) )
            & ( v48357_29__array(VarNext,A,bitIndex0)
            <=> v51082(VarNext,bitIndex120) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10719,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51076(VarNext)
      <=> ( v51077(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10718,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51077(VarNext)
      <=> ( v51079(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4526,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51079(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_85,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10111_address_term = A
              & v51067(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_28__array(VarNext,A,B)
              <=> v48357_27__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_85,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10111_address_term = A
            & v51067(VarNext) )
         => ( ( v48357_28__array(VarNext,A,bitIndex4)
            <=> v51073(VarNext,bitIndex119) )
            & ( v48357_28__array(VarNext,A,bitIndex3)
            <=> v51073(VarNext,bitIndex118) )
            & ( v48357_28__array(VarNext,A,bitIndex2)
            <=> v51073(VarNext,bitIndex117) )
            & ( v48357_28__array(VarNext,A,bitIndex1)
            <=> v51073(VarNext,bitIndex116) )
            & ( v48357_28__array(VarNext,A,bitIndex0)
            <=> v51073(VarNext,bitIndex115) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10717,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51067(VarNext)
      <=> ( v51068(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10716,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51068(VarNext)
      <=> ( v51070(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4525,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51070(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_84,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10110_address_term = A
              & v51058(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_27__array(VarNext,A,B)
              <=> v48357_26__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_84,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10110_address_term = A
            & v51058(VarNext) )
         => ( ( v48357_27__array(VarNext,A,bitIndex4)
            <=> v51064(VarNext,bitIndex114) )
            & ( v48357_27__array(VarNext,A,bitIndex3)
            <=> v51064(VarNext,bitIndex113) )
            & ( v48357_27__array(VarNext,A,bitIndex2)
            <=> v51064(VarNext,bitIndex112) )
            & ( v48357_27__array(VarNext,A,bitIndex1)
            <=> v51064(VarNext,bitIndex111) )
            & ( v48357_27__array(VarNext,A,bitIndex0)
            <=> v51064(VarNext,bitIndex110) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10715,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51058(VarNext)
      <=> ( v51059(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10714,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51059(VarNext)
      <=> ( v51061(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4524,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51061(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_83,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10101_address_term = A
              & v51049(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_26__array(VarNext,A,B)
              <=> v48357_25__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_83,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10101_address_term = A
            & v51049(VarNext) )
         => ( ( v48357_26__array(VarNext,A,bitIndex4)
            <=> v51055(VarNext,bitIndex109) )
            & ( v48357_26__array(VarNext,A,bitIndex3)
            <=> v51055(VarNext,bitIndex108) )
            & ( v48357_26__array(VarNext,A,bitIndex2)
            <=> v51055(VarNext,bitIndex107) )
            & ( v48357_26__array(VarNext,A,bitIndex1)
            <=> v51055(VarNext,bitIndex106) )
            & ( v48357_26__array(VarNext,A,bitIndex0)
            <=> v51055(VarNext,bitIndex105) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10713,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51049(VarNext)
      <=> ( v51050(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10712,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51050(VarNext)
      <=> ( v51052(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4523,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51052(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_82,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10100_address_term = A
              & v51040(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_25__array(VarNext,A,B)
              <=> v48357_24__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_82,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10100_address_term = A
            & v51040(VarNext) )
         => ( ( v48357_25__array(VarNext,A,bitIndex4)
            <=> v51046(VarNext,bitIndex104) )
            & ( v48357_25__array(VarNext,A,bitIndex3)
            <=> v51046(VarNext,bitIndex103) )
            & ( v48357_25__array(VarNext,A,bitIndex2)
            <=> v51046(VarNext,bitIndex102) )
            & ( v48357_25__array(VarNext,A,bitIndex1)
            <=> v51046(VarNext,bitIndex101) )
            & ( v48357_25__array(VarNext,A,bitIndex0)
            <=> v51046(VarNext,bitIndex100) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10711,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51040(VarNext)
      <=> ( v51041(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10710,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51041(VarNext)
      <=> ( v51043(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4522,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51043(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_81,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10011_address_term = A
              & v51031(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_24__array(VarNext,A,B)
              <=> v48357_23__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_81,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10011_address_term = A
            & v51031(VarNext) )
         => ( ( v48357_24__array(VarNext,A,bitIndex4)
            <=> v51037(VarNext,bitIndex99) )
            & ( v48357_24__array(VarNext,A,bitIndex3)
            <=> v51037(VarNext,bitIndex98) )
            & ( v48357_24__array(VarNext,A,bitIndex2)
            <=> v51037(VarNext,bitIndex97) )
            & ( v48357_24__array(VarNext,A,bitIndex1)
            <=> v51037(VarNext,bitIndex96) )
            & ( v48357_24__array(VarNext,A,bitIndex0)
            <=> v51037(VarNext,bitIndex95) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10709,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51031(VarNext)
      <=> ( v51032(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10708,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51032(VarNext)
      <=> ( v51034(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4521,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51034(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_80,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10010_address_term = A
              & v51022(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_23__array(VarNext,A,B)
              <=> v48357_22__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_80,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10010_address_term = A
            & v51022(VarNext) )
         => ( ( v48357_23__array(VarNext,A,bitIndex4)
            <=> v51028(VarNext,bitIndex94) )
            & ( v48357_23__array(VarNext,A,bitIndex3)
            <=> v51028(VarNext,bitIndex93) )
            & ( v48357_23__array(VarNext,A,bitIndex2)
            <=> v51028(VarNext,bitIndex92) )
            & ( v48357_23__array(VarNext,A,bitIndex1)
            <=> v51028(VarNext,bitIndex91) )
            & ( v48357_23__array(VarNext,A,bitIndex0)
            <=> v51028(VarNext,bitIndex90) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10707,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51022(VarNext)
      <=> ( v51023(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10706,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51023(VarNext)
      <=> ( v51025(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4520,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51025(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_79,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10001_address_term = A
              & v51013(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_22__array(VarNext,A,B)
              <=> v48357_21__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_79,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10001_address_term = A
            & v51013(VarNext) )
         => ( ( v48357_22__array(VarNext,A,bitIndex4)
            <=> v51019(VarNext,bitIndex89) )
            & ( v48357_22__array(VarNext,A,bitIndex3)
            <=> v51019(VarNext,bitIndex88) )
            & ( v48357_22__array(VarNext,A,bitIndex2)
            <=> v51019(VarNext,bitIndex87) )
            & ( v48357_22__array(VarNext,A,bitIndex1)
            <=> v51019(VarNext,bitIndex86) )
            & ( v48357_22__array(VarNext,A,bitIndex0)
            <=> v51019(VarNext,bitIndex85) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10705,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51013(VarNext)
      <=> ( v51014(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10704,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51014(VarNext)
      <=> ( v51016(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4519,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51016(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_78,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10000_address_term = A
              & v51004(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_21__array(VarNext,A,B)
              <=> v48357_20__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_78,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10000_address_term = A
            & v51004(VarNext) )
         => ( ( v48357_21__array(VarNext,A,bitIndex4)
            <=> v51010(VarNext,bitIndex84) )
            & ( v48357_21__array(VarNext,A,bitIndex3)
            <=> v51010(VarNext,bitIndex83) )
            & ( v48357_21__array(VarNext,A,bitIndex2)
            <=> v51010(VarNext,bitIndex82) )
            & ( v48357_21__array(VarNext,A,bitIndex1)
            <=> v51010(VarNext,bitIndex81) )
            & ( v48357_21__array(VarNext,A,bitIndex0)
            <=> v51010(VarNext,bitIndex80) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10703,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51004(VarNext)
      <=> ( v51005(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10702,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v51005(VarNext)
      <=> ( v51007(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4518,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v51007(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_77,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01111_address_term = A
              & v50995(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_20__array(VarNext,A,B)
              <=> v48357_19__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_77,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01111_address_term = A
            & v50995(VarNext) )
         => ( ( v48357_20__array(VarNext,A,bitIndex4)
            <=> v51001(VarNext,bitIndex79) )
            & ( v48357_20__array(VarNext,A,bitIndex3)
            <=> v51001(VarNext,bitIndex78) )
            & ( v48357_20__array(VarNext,A,bitIndex2)
            <=> v51001(VarNext,bitIndex77) )
            & ( v48357_20__array(VarNext,A,bitIndex1)
            <=> v51001(VarNext,bitIndex76) )
            & ( v48357_20__array(VarNext,A,bitIndex0)
            <=> v51001(VarNext,bitIndex75) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10701,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50995(VarNext)
      <=> ( v50996(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10700,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50996(VarNext)
      <=> ( v50998(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4517,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50998(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_76,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01110_address_term = A
              & v50986(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_19__array(VarNext,A,B)
              <=> v48357_18__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_76,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01110_address_term = A
            & v50986(VarNext) )
         => ( ( v48357_19__array(VarNext,A,bitIndex4)
            <=> v50992(VarNext,bitIndex74) )
            & ( v48357_19__array(VarNext,A,bitIndex3)
            <=> v50992(VarNext,bitIndex73) )
            & ( v48357_19__array(VarNext,A,bitIndex2)
            <=> v50992(VarNext,bitIndex72) )
            & ( v48357_19__array(VarNext,A,bitIndex1)
            <=> v50992(VarNext,bitIndex71) )
            & ( v48357_19__array(VarNext,A,bitIndex0)
            <=> v50992(VarNext,bitIndex70) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10699,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50986(VarNext)
      <=> ( v50987(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10698,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50987(VarNext)
      <=> ( v50989(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4516,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50989(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_75,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01101_address_term = A
              & v50977(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_18__array(VarNext,A,B)
              <=> v48357_17__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_75,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01101_address_term = A
            & v50977(VarNext) )
         => ( ( v48357_18__array(VarNext,A,bitIndex4)
            <=> v50983(VarNext,bitIndex69) )
            & ( v48357_18__array(VarNext,A,bitIndex3)
            <=> v50983(VarNext,bitIndex68) )
            & ( v48357_18__array(VarNext,A,bitIndex2)
            <=> v50983(VarNext,bitIndex67) )
            & ( v48357_18__array(VarNext,A,bitIndex1)
            <=> v50983(VarNext,bitIndex66) )
            & ( v48357_18__array(VarNext,A,bitIndex0)
            <=> v50983(VarNext,bitIndex65) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10697,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50977(VarNext)
      <=> ( v50978(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10696,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50978(VarNext)
      <=> ( v50980(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4515,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50980(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_74,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01100_address_term = A
              & v50968(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_17__array(VarNext,A,B)
              <=> v48357_16__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_74,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01100_address_term = A
            & v50968(VarNext) )
         => ( ( v48357_17__array(VarNext,A,bitIndex4)
            <=> v50974(VarNext,bitIndex64) )
            & ( v48357_17__array(VarNext,A,bitIndex3)
            <=> v50974(VarNext,bitIndex63) )
            & ( v48357_17__array(VarNext,A,bitIndex2)
            <=> v50974(VarNext,bitIndex62) )
            & ( v48357_17__array(VarNext,A,bitIndex1)
            <=> v50974(VarNext,bitIndex61) )
            & ( v48357_17__array(VarNext,A,bitIndex0)
            <=> v50974(VarNext,bitIndex60) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10695,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50968(VarNext)
      <=> ( v50969(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10694,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50969(VarNext)
      <=> ( v50971(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4514,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50971(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_73,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01011_address_term = A
              & v50959(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_16__array(VarNext,A,B)
              <=> v48357_15__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_73,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01011_address_term = A
            & v50959(VarNext) )
         => ( ( v48357_16__array(VarNext,A,bitIndex4)
            <=> v50965(VarNext,bitIndex59) )
            & ( v48357_16__array(VarNext,A,bitIndex3)
            <=> v50965(VarNext,bitIndex58) )
            & ( v48357_16__array(VarNext,A,bitIndex2)
            <=> v50965(VarNext,bitIndex57) )
            & ( v48357_16__array(VarNext,A,bitIndex1)
            <=> v50965(VarNext,bitIndex56) )
            & ( v48357_16__array(VarNext,A,bitIndex0)
            <=> v50965(VarNext,bitIndex55) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10693,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50959(VarNext)
      <=> ( v50960(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10692,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50960(VarNext)
      <=> ( v50962(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4513,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50962(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_72,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01010_address_term = A
              & v50950(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_15__array(VarNext,A,B)
              <=> v48357_14__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_72,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01010_address_term = A
            & v50950(VarNext) )
         => ( ( v48357_15__array(VarNext,A,bitIndex4)
            <=> v50956(VarNext,bitIndex54) )
            & ( v48357_15__array(VarNext,A,bitIndex3)
            <=> v50956(VarNext,bitIndex53) )
            & ( v48357_15__array(VarNext,A,bitIndex2)
            <=> v50956(VarNext,bitIndex52) )
            & ( v48357_15__array(VarNext,A,bitIndex1)
            <=> v50956(VarNext,bitIndex51) )
            & ( v48357_15__array(VarNext,A,bitIndex0)
            <=> v50956(VarNext,bitIndex50) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10691,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50950(VarNext)
      <=> ( v50951(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10690,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50951(VarNext)
      <=> ( v50953(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4512,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50953(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_71,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01001_address_term = A
              & v50941(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_14__array(VarNext,A,B)
              <=> v48357_13__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_71,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01001_address_term = A
            & v50941(VarNext) )
         => ( ( v48357_14__array(VarNext,A,bitIndex4)
            <=> v50947(VarNext,bitIndex49) )
            & ( v48357_14__array(VarNext,A,bitIndex3)
            <=> v50947(VarNext,bitIndex48) )
            & ( v48357_14__array(VarNext,A,bitIndex2)
            <=> v50947(VarNext,bitIndex47) )
            & ( v48357_14__array(VarNext,A,bitIndex1)
            <=> v50947(VarNext,bitIndex46) )
            & ( v48357_14__array(VarNext,A,bitIndex0)
            <=> v50947(VarNext,bitIndex45) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10689,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50941(VarNext)
      <=> ( v50942(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10688,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50942(VarNext)
      <=> ( v50944(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4511,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50944(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_70,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01000_address_term = A
              & v50932(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_13__array(VarNext,A,B)
              <=> v48357_12__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_70,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01000_address_term = A
            & v50932(VarNext) )
         => ( ( v48357_13__array(VarNext,A,bitIndex4)
            <=> v50938(VarNext,bitIndex44) )
            & ( v48357_13__array(VarNext,A,bitIndex3)
            <=> v50938(VarNext,bitIndex43) )
            & ( v48357_13__array(VarNext,A,bitIndex2)
            <=> v50938(VarNext,bitIndex42) )
            & ( v48357_13__array(VarNext,A,bitIndex1)
            <=> v50938(VarNext,bitIndex41) )
            & ( v48357_13__array(VarNext,A,bitIndex0)
            <=> v50938(VarNext,bitIndex40) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10687,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50932(VarNext)
      <=> ( v50933(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10686,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50933(VarNext)
      <=> ( v50935(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4510,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50935(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_69,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00111_address_term = A
              & v50923(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_12__array(VarNext,A,B)
              <=> v48357_11__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_69,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00111_address_term = A
            & v50923(VarNext) )
         => ( ( v48357_12__array(VarNext,A,bitIndex4)
            <=> v50929(VarNext,bitIndex39) )
            & ( v48357_12__array(VarNext,A,bitIndex3)
            <=> v50929(VarNext,bitIndex38) )
            & ( v48357_12__array(VarNext,A,bitIndex2)
            <=> v50929(VarNext,bitIndex37) )
            & ( v48357_12__array(VarNext,A,bitIndex1)
            <=> v50929(VarNext,bitIndex36) )
            & ( v48357_12__array(VarNext,A,bitIndex0)
            <=> v50929(VarNext,bitIndex35) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10685,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50923(VarNext)
      <=> ( v50924(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10684,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50924(VarNext)
      <=> ( v50926(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4509,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50926(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_68,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00110_address_term = A
              & v50914(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_11__array(VarNext,A,B)
              <=> v48357_10__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_68,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00110_address_term = A
            & v50914(VarNext) )
         => ( ( v48357_11__array(VarNext,A,bitIndex4)
            <=> v50920(VarNext,bitIndex34) )
            & ( v48357_11__array(VarNext,A,bitIndex3)
            <=> v50920(VarNext,bitIndex33) )
            & ( v48357_11__array(VarNext,A,bitIndex2)
            <=> v50920(VarNext,bitIndex32) )
            & ( v48357_11__array(VarNext,A,bitIndex1)
            <=> v50920(VarNext,bitIndex31) )
            & ( v48357_11__array(VarNext,A,bitIndex0)
            <=> v50920(VarNext,bitIndex30) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10683,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50914(VarNext)
      <=> ( v50915(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10682,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50915(VarNext)
      <=> ( v50917(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4508,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50917(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_67,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00101_address_term = A
              & v50905(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_10__array(VarNext,A,B)
              <=> v48357_9__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_67,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00101_address_term = A
            & v50905(VarNext) )
         => ( ( v48357_10__array(VarNext,A,bitIndex4)
            <=> v50911(VarNext,bitIndex29) )
            & ( v48357_10__array(VarNext,A,bitIndex3)
            <=> v50911(VarNext,bitIndex28) )
            & ( v48357_10__array(VarNext,A,bitIndex2)
            <=> v50911(VarNext,bitIndex27) )
            & ( v48357_10__array(VarNext,A,bitIndex1)
            <=> v50911(VarNext,bitIndex26) )
            & ( v48357_10__array(VarNext,A,bitIndex0)
            <=> v50911(VarNext,bitIndex25) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10681,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50905(VarNext)
      <=> ( v50906(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10680,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50906(VarNext)
      <=> ( v50908(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4507,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50908(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_66,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00100_address_term = A
              & v50896(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_9__array(VarNext,A,B)
              <=> v48357_8__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_66,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00100_address_term = A
            & v50896(VarNext) )
         => ( ( v48357_9__array(VarNext,A,bitIndex4)
            <=> v50902(VarNext,bitIndex24) )
            & ( v48357_9__array(VarNext,A,bitIndex3)
            <=> v50902(VarNext,bitIndex23) )
            & ( v48357_9__array(VarNext,A,bitIndex2)
            <=> v50902(VarNext,bitIndex22) )
            & ( v48357_9__array(VarNext,A,bitIndex1)
            <=> v50902(VarNext,bitIndex21) )
            & ( v48357_9__array(VarNext,A,bitIndex0)
            <=> v50902(VarNext,bitIndex20) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10679,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50896(VarNext)
      <=> ( v50897(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10678,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50897(VarNext)
      <=> ( v50899(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4506,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50899(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_65,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00011_address_term = A
              & v50887(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_8__array(VarNext,A,B)
              <=> v48357_7__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_65,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00011_address_term = A
            & v50887(VarNext) )
         => ( ( v48357_8__array(VarNext,A,bitIndex4)
            <=> v50893(VarNext,bitIndex19) )
            & ( v48357_8__array(VarNext,A,bitIndex3)
            <=> v50893(VarNext,bitIndex18) )
            & ( v48357_8__array(VarNext,A,bitIndex2)
            <=> v50893(VarNext,bitIndex17) )
            & ( v48357_8__array(VarNext,A,bitIndex1)
            <=> v50893(VarNext,bitIndex16) )
            & ( v48357_8__array(VarNext,A,bitIndex0)
            <=> v50893(VarNext,bitIndex15) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10677,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50887(VarNext)
      <=> ( v50888(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10676,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50888(VarNext)
      <=> ( v50890(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4505,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50890(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_64,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00010_address_term = A
              & v50878(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_7__array(VarNext,A,B)
              <=> v48357_6__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_64,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00010_address_term = A
            & v50878(VarNext) )
         => ( ( v48357_7__array(VarNext,A,bitIndex4)
            <=> v50884(VarNext,bitIndex14) )
            & ( v48357_7__array(VarNext,A,bitIndex3)
            <=> v50884(VarNext,bitIndex13) )
            & ( v48357_7__array(VarNext,A,bitIndex2)
            <=> v50884(VarNext,bitIndex12) )
            & ( v48357_7__array(VarNext,A,bitIndex1)
            <=> v50884(VarNext,bitIndex11) )
            & ( v48357_7__array(VarNext,A,bitIndex0)
            <=> v50884(VarNext,bitIndex10) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10675,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50878(VarNext)
      <=> ( v50879(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10674,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50879(VarNext)
      <=> ( v50881(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4504,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50881(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_63,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00001_address_term = A
              & v50869(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_6__array(VarNext,A,B)
              <=> v48357_5__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_63,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00001_address_term = A
            & v50869(VarNext) )
         => ( ( v48357_6__array(VarNext,A,bitIndex4)
            <=> v50875(VarNext,bitIndex9) )
            & ( v48357_6__array(VarNext,A,bitIndex3)
            <=> v50875(VarNext,bitIndex8) )
            & ( v48357_6__array(VarNext,A,bitIndex2)
            <=> v50875(VarNext,bitIndex7) )
            & ( v48357_6__array(VarNext,A,bitIndex1)
            <=> v50875(VarNext,bitIndex6) )
            & ( v48357_6__array(VarNext,A,bitIndex0)
            <=> v50875(VarNext,bitIndex5) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10673,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50869(VarNext)
      <=> ( v50870(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10672,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50870(VarNext)
      <=> ( v50872(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4503,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50872(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_62,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00000_address_term = A
              & v50855(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_5__array(VarNext,A,B)
              <=> v48357_4__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_62,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00000_address_term = A
            & v50855(VarNext) )
         => ! [B] :
              ( range_4_0(B)
             => ( v48357_5__array(VarNext,A,B)
              <=> v50866(VarNext,B) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10671,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50855(VarNext)
      <=> ( v50856(VarNext)
          & v50862(VarNext) ) ) ) ).

fof(addAssignment_18917,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50862(VarNext)
      <=> v50860(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10670,axiom,
    ! [VarCurr] :
      ( v50860(VarCurr)
    <=> ( v50818(VarCurr)
        & v50863(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3150,axiom,
    ! [VarCurr] :
      ( v50863(VarCurr)
    <=> ( ( v50864(VarCurr,bitIndex1)
        <=> $false )
        & ( v50864(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_18916,axiom,
    ! [VarCurr] :
      ( v50864(VarCurr,bitIndex0)
    <=> v48386(VarCurr) ) ).

fof(addAssignment_18915,axiom,
    ! [VarCurr] :
      ( v50864(VarCurr,bitIndex1)
    <=> v48363(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10669,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50856(VarNext)
      <=> ( v50858(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4502,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50858(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_61,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v48599_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ~ ( A = AssociatedAddressVar
                  & v50843(VarNext) )
             => ! [B] :
                  ( range_4_0(B)
                 => ( v48357_4__array(VarNext,A,B)
                  <=> v48357_3__array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_61,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v48599_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ( A = AssociatedAddressVar
                & v50843(VarNext) )
             => ! [B] :
                  ( range_4_0(B)
                 => ( v48357_4__array(VarNext,A,B)
                  <=> v48591(VarNext,B) ) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10668,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50843(VarNext)
      <=> ( v50844(VarNext)
          & v50850(VarNext) ) ) ) ).

fof(addAssignment_18914,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50850(VarNext)
      <=> v50848(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10667,axiom,
    ! [VarCurr] :
      ( v50848(VarCurr)
    <=> ( v50818(VarCurr)
        & v50851(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3149,axiom,
    ! [VarCurr] :
      ( v50851(VarCurr)
    <=> ( ( v50852(VarCurr,bitIndex1)
        <=> $true )
        & ( v50852(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_18913,axiom,
    ! [VarCurr] :
      ( v50852(VarCurr,bitIndex0)
    <=> v48386(VarCurr) ) ).

fof(addAssignment_18912,axiom,
    ! [VarCurr] :
      ( v50852(VarCurr,bitIndex1)
    <=> v48363(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10666,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50844(VarNext)
      <=> ( v50846(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4501,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50846(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_60,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v50561_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ~ ( A = AssociatedAddressVar
                  & v50831(VarNext) )
             => ! [B] :
                  ( range_4_0(B)
                 => ( v48357_3__array(VarNext,A,B)
                  <=> v48357_2__array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_60,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v50561_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ( A = AssociatedAddressVar
                & v50831(VarNext) )
             => ! [B] :
                  ( range_4_0(B)
                 => ( v48357_3__array(VarNext,A,B)
                  <=> v48633(VarNext,B) ) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10665,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50831(VarNext)
      <=> ( v50832(VarNext)
          & v50838(VarNext) ) ) ) ).

fof(addAssignment_18911,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50838(VarNext)
      <=> v50836(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10664,axiom,
    ! [VarCurr] :
      ( v50836(VarCurr)
    <=> ( v50818(VarCurr)
        & v50839(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3148,axiom,
    ! [VarCurr] :
      ( v50839(VarCurr)
    <=> ( ( v50840(VarCurr,bitIndex1)
        <=> $false )
        & ( v50840(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_18910,axiom,
    ! [VarCurr] :
      ( v50840(VarCurr,bitIndex0)
    <=> v48386(VarCurr) ) ).

fof(addAssignment_18909,axiom,
    ! [VarCurr] :
      ( v50840(VarCurr,bitIndex1)
    <=> v48363(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10663,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50832(VarNext)
      <=> ( v50834(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4500,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50834(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_59,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v50561_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ~ ( A = AssociatedAddressVar
                  & v50824(VarNext) )
             => ! [B] :
                  ( range_4_0(B)
                 => ( v48357_2__array(VarNext,A,B)
                  <=> v48357_1__array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_59,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v50561_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ( A = AssociatedAddressVar
                & v50824(VarNext) )
             => ! [B] :
                  ( range_4_0(B)
                 => ( v48357_2__array(VarNext,A,B)
                  <=> v48633(VarNext,B) ) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10662,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50824(VarNext)
      <=> ( v50825(VarNext)
          & v50817(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10661,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50825(VarNext)
      <=> ( v50827(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4499,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50827(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(memoryWriteDisabled_58,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v48599_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ~ ( A = AssociatedAddressVar
                  & v50808(VarNext) )
             => ! [B] :
                  ( range_4_0(B)
                 => ( v48357_1__array(VarNext,A,B)
                  <=> v48357_array(VarCurr,A,B) ) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_58,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v48599_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ( A = AssociatedAddressVar
                & v50808(VarNext) )
             => ! [B] :
                  ( range_4_0(B)
                 => ( v48357_1__array(VarNext,A,B)
                  <=> v48591(VarNext,B) ) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10660,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50808(VarNext)
      <=> ( v50809(VarNext)
          & v50817(VarNext) ) ) ) ).

fof(addAssignment_18908,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50817(VarNext)
      <=> v50815(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10659,axiom,
    ! [VarCurr] :
      ( v50815(VarCurr)
    <=> ( v50818(VarCurr)
        & v50820(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3147,axiom,
    ! [VarCurr] :
      ( v50820(VarCurr)
    <=> ( ( v50821(VarCurr,bitIndex1)
        <=> $true )
        & ( v50821(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_18907,axiom,
    ! [VarCurr] :
      ( v50821(VarCurr,bitIndex0)
    <=> v48386(VarCurr) ) ).

fof(addAssignment_18906,axiom,
    ! [VarCurr] :
      ( v50821(VarCurr,bitIndex1)
    <=> v48363(VarCurr) ) ).

fof(writeUnaryOperator_4498,axiom,
    ! [VarCurr] :
      ( ~ v50818(VarCurr)
    <=> v50819(VarCurr) ) ).

fof(writeUnaryOperator_4497,axiom,
    ! [VarCurr] :
      ( ~ v50819(VarCurr)
    <=> v48361(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10658,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50809(VarNext)
      <=> ( v50810(VarNext)
          & v48359(VarNext) ) ) ) ).

fof(writeUnaryOperator_4496,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50810(VarNext)
      <=> v50812(VarNext) ) ) ).

fof(addAssignment_18905,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50812(VarNext)
      <=> v48359(VarCurr) ) ) ).

fof(addAssignment_18904,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v48633(VarCurr,B)
      <=> v48635(VarCurr,B) ) ) ).

fof(addAssignment_18903,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v48635(VarCurr,B)
      <=> v48637(VarCurr,B) ) ) ).

fof(addAssignment_18902,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v48637(VarCurr,B)
      <=> v48639(VarCurr,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_978,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50790(VarNext)
       => ! [B] :
            ( range_4_0(B)
           => ( v48639(VarNext,B)
            <=> v48639(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1040,axiom,
    ! [VarNext] :
      ( v50790(VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v48639(VarNext,B)
          <=> v50801(VarNext,B) ) ) ) ).

fof(addAssignment_18901,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v50801(VarNext,B)
          <=> v50799(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1585,axiom,
    ! [VarCurr] :
      ( ~ v48464(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v50799(VarCurr,B)
          <=> v50802(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1419,axiom,
    ! [VarCurr] :
      ( v48464(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v50799(VarCurr,B)
          <=> $false ) ) ) ).

fof(addAssignment_18900,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v50802(VarCurr,B)
      <=> v48641(VarCurr,B) ) ) ).

fof(addAssignment_18899,axiom,
    ! [VarCurr] :
      ( v50802(VarCurr,bitIndex4)
    <=> $true ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10657,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50790(VarNext)
      <=> ( v50791(VarNext)
          & v50798(VarNext) ) ) ) ).

fof(addAssignment_18898,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50798(VarNext)
      <=> v50796(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10656,axiom,
    ! [VarCurr] :
      ( v50796(VarCurr)
    <=> ( v48394(VarCurr)
        | v48464(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10655,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50791(VarNext)
      <=> ( v50793(VarNext)
          & v45620(VarNext) ) ) ) ).

fof(writeUnaryOperator_4495,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50793(VarNext)
      <=> v47885(VarNext) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_977,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50772(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v48641(VarNext,B)
            <=> v48641(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1039,axiom,
    ! [VarNext] :
      ( v50772(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v48641(VarNext,B)
          <=> v50784(VarNext,B) ) ) ) ).

fof(addAssignment_18897,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v50784(VarNext,B)
          <=> v50782(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1584,axiom,
    ! [VarCurr] :
      ( ~ v48464(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v50782(VarCurr,B)
          <=> v50785(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1418,axiom,
    ! [VarCurr] :
      ( v48464(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v50782(VarCurr,B)
          <=> $false ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1583,axiom,
    ! [VarCurr] :
      ( ~ v48643(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v50785(VarCurr,B)
          <=> v50686(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1417,axiom,
    ! [VarCurr] :
      ( v48643(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v50785(VarCurr,B)
          <=> v48349(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10654,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50772(VarNext)
      <=> ( v50773(VarNext)
          & v50780(VarNext) ) ) ) ).

fof(addAssignment_18896,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50780(VarNext)
      <=> v50778(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10653,axiom,
    ! [VarCurr] :
      ( v50778(VarCurr)
    <=> ( v50781(VarCurr)
        | v48464(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10652,axiom,
    ! [VarCurr] :
      ( v50781(VarCurr)
    <=> ( v48422(VarCurr)
        | v48643(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10651,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50773(VarNext)
      <=> ( v50775(VarNext)
          & v45620(VarNext) ) ) ) ).

fof(writeUnaryOperator_4494,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50775(VarNext)
      <=> v47885(VarNext) ) ) ).

fof(addAssignment_18895,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v50686(VarCurr,B)
      <=> v50688(VarCurr,B) ) ) ).

fof(addAssignment_18894,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v50688(VarCurr,B)
      <=> v50690(VarCurr,B) ) ) ).

fof(addAssignment_18893,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v50690(VarCurr,B)
      <=> v50692(VarCurr,B) ) ) ).

fof(addAssignment_18892,axiom,
    ! [VarCurr] :
      ( ( v50692(VarCurr,bitIndex3)
      <=> v50694(VarCurr,bitIndex63) )
      & ( v50692(VarCurr,bitIndex2)
      <=> v50694(VarCurr,bitIndex62) )
      & ( v50692(VarCurr,bitIndex1)
      <=> v50694(VarCurr,bitIndex61) )
      & ( v50692(VarCurr,bitIndex0)
      <=> v50694(VarCurr,bitIndex60) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_976,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50735(VarNext)
       => ! [B] :
            ( range_63_60(B)
           => ( v50694(VarNext,B)
            <=> v50694(VarCurr,B) ) ) ) ) ).

fof(range_axiom_213,axiom,
    ! [B] :
      ( range_63_60(B)
    <=> ( $false
        | bitIndex60 = B
        | bitIndex61 = B
        | bitIndex62 = B
        | bitIndex63 = B ) ) ).

fof(addCaseBooleanConditionShiftedRanges0_27,axiom,
    ! [VarNext] :
      ( v50735(VarNext)
     => ( ( v50694(VarNext,bitIndex63)
        <=> v50766(VarNext,bitIndex3) )
        & ( v50694(VarNext,bitIndex62)
        <=> v50766(VarNext,bitIndex2) )
        & ( v50694(VarNext,bitIndex61)
        <=> v50766(VarNext,bitIndex1) )
        & ( v50694(VarNext,bitIndex60)
        <=> v50766(VarNext,bitIndex0) ) ) ) ).

fof(addAssignment_18891,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v50766(VarNext,B)
          <=> v50764(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1103,axiom,
    ! [VarCurr] :
      ( ~ v50745(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v50764(VarCurr,B)
          <=> v50767(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1068,axiom,
    ! [VarCurr] :
      ( v50745(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v50764(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_419,axiom,
    ! [VarCurr] :
      ( ( ~ v50749(VarCurr)
        & ~ v50751(VarCurr) )
     => ! [B] :
          ( range_3_0(B)
         => ( v50767(VarCurr,B)
          <=> v50727(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1102,axiom,
    ! [VarCurr] :
      ( v50751(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v50767(VarCurr,B)
          <=> v50696(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0_43,axiom,
    ! [VarCurr] :
      ( v50749(VarCurr)
     => ( ( v50767(VarCurr,bitIndex3)
        <=> v50694(VarCurr,bitIndex59) )
        & ( v50767(VarCurr,bitIndex2)
        <=> v50694(VarCurr,bitIndex58) )
        & ( v50767(VarCurr,bitIndex1)
        <=> v50694(VarCurr,bitIndex57) )
        & ( v50767(VarCurr,bitIndex0)
        <=> v50694(VarCurr,bitIndex56) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10650,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50735(VarNext)
      <=> ( v50736(VarNext)
          & v50743(VarNext) ) ) ) ).

fof(addAssignment_18890,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50743(VarNext)
      <=> v50741(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10649,axiom,
    ! [VarCurr] :
      ( v50741(VarCurr)
    <=> ( v50744(VarCurr)
        & v50756(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10648,axiom,
    ! [VarCurr] :
      ( v50756(VarCurr)
    <=> ( v50757(VarCurr)
        | v50745(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10647,axiom,
    ! [VarCurr] :
      ( v50757(VarCurr)
    <=> ( v50758(VarCurr)
        & v50761(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10646,axiom,
    ! [VarCurr] :
      ( v50761(VarCurr)
    <=> ( v50762(VarCurr)
        | v50753(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10645,axiom,
    ! [VarCurr] :
      ( v50762(VarCurr)
    <=> ( v50763(VarCurr)
        | v50751(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10644,axiom,
    ! [VarCurr] :
      ( v50763(VarCurr)
    <=> ( v50759(VarCurr)
        | v50749(VarCurr) ) ) ).

fof(writeUnaryOperator_4493,axiom,
    ! [VarCurr] :
      ( ~ v50758(VarCurr)
    <=> v50759(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_3146,axiom,
    ! [VarCurr] :
      ( v50759(VarCurr)
    <=> ( ( v50760(VarCurr,bitIndex1)
        <=> $false )
        & ( v50760(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_18889,axiom,
    ! [VarCurr] :
      ( v50760(VarCurr,bitIndex0)
    <=> v48494(VarCurr) ) ).

fof(addAssignment_18888,axiom,
    ! [VarCurr] :
      ( v50760(VarCurr,bitIndex1)
    <=> v48474(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10643,axiom,
    ! [VarCurr] :
      ( v50744(VarCurr)
    <=> ( v50745(VarCurr)
        | v50746(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10642,axiom,
    ! [VarCurr] :
      ( v50746(VarCurr)
    <=> ( v50747(VarCurr)
        & v50755(VarCurr) ) ) ).

fof(writeUnaryOperator_4492,axiom,
    ! [VarCurr] :
      ( ~ v50755(VarCurr)
    <=> v50745(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10641,axiom,
    ! [VarCurr] :
      ( v50747(VarCurr)
    <=> ( v50748(VarCurr)
        | v50753(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3145,axiom,
    ! [VarCurr] :
      ( v50753(VarCurr)
    <=> ( ( v50754(VarCurr,bitIndex1)
        <=> $true )
        & ( v50754(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_18887,axiom,
    ! [VarCurr] :
      ( v50754(VarCurr,bitIndex0)
    <=> v48494(VarCurr) ) ).

fof(addAssignment_18886,axiom,
    ! [VarCurr] :
      ( v50754(VarCurr,bitIndex1)
    <=> v48474(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10640,axiom,
    ! [VarCurr] :
      ( v50748(VarCurr)
    <=> ( v50749(VarCurr)
        | v50751(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3144,axiom,
    ! [VarCurr] :
      ( v50751(VarCurr)
    <=> ( ( v50752(VarCurr,bitIndex1)
        <=> $true )
        & ( v50752(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_18885,axiom,
    ! [VarCurr] :
      ( v50752(VarCurr,bitIndex0)
    <=> v48494(VarCurr) ) ).

fof(addAssignment_18884,axiom,
    ! [VarCurr] :
      ( v50752(VarCurr,bitIndex1)
    <=> v48474(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_3143,axiom,
    ! [VarCurr] :
      ( v50749(VarCurr)
    <=> ( ( v50750(VarCurr,bitIndex1)
        <=> $false )
        & ( v50750(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_18883,axiom,
    ! [VarCurr] :
      ( v50750(VarCurr,bitIndex0)
    <=> v48494(VarCurr) ) ).

fof(addAssignment_18882,axiom,
    ! [VarCurr] :
      ( v50750(VarCurr,bitIndex1)
    <=> v48474(VarCurr) ) ).

fof(writeUnaryOperator_4491,axiom,
    ! [VarCurr] :
      ( ~ v50745(VarCurr)
    <=> v48472(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10639,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50736(VarNext)
      <=> ( v50737(VarNext)
          & v48498(VarNext) ) ) ) ).

fof(writeUnaryOperator_4490,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50737(VarNext)
      <=> v48505(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1582,axiom,
    ! [VarCurr] :
      ( ~ v50729(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v50727(VarCurr,B)
          <=> v50731(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1416,axiom,
    ! [VarCurr] :
      ( v50729(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v50727(VarCurr,B)
          <=> v50720(VarCurr,B) ) ) ) ).

fof(addAssignment_18881,axiom,
    ! [VarCurr] :
      ( ( v50731(VarCurr,bitIndex3)
      <=> v50694(VarCurr,bitIndex59) )
      & ( v50731(VarCurr,bitIndex2)
      <=> v50694(VarCurr,bitIndex58) )
      & ( v50731(VarCurr,bitIndex1)
      <=> v50694(VarCurr,bitIndex57) )
      & ( v50731(VarCurr,bitIndex0)
      <=> v50694(VarCurr,bitIndex56) ) ) ).

fof(addAssignment_18880,axiom,
    ! [VarCurr] :
      ( v50729(VarCurr)
    <=> v50700(VarCurr,bitIndex1) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1581,axiom,
    ! [VarCurr] :
      ( ~ v50698(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v50696(VarCurr,B)
          <=> v50724(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1415,axiom,
    ! [VarCurr] :
      ( v50698(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v50696(VarCurr,B)
          <=> v50720(VarCurr,B) ) ) ) ).

fof(addAssignment_18879,axiom,
    ! [VarCurr] :
      ( ( v50724(VarCurr,bitIndex3)
      <=> v50694(VarCurr,bitIndex63) )
      & ( v50724(VarCurr,bitIndex2)
      <=> v50694(VarCurr,bitIndex62) )
      & ( v50724(VarCurr,bitIndex1)
      <=> v50694(VarCurr,bitIndex61) )
      & ( v50724(VarCurr,bitIndex0)
      <=> v50694(VarCurr,bitIndex60) ) ) ).

fof(addAssignment_18878,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v50720(VarCurr,B)
      <=> v50722(VarCurr,B) ) ) ).

fof(addAssignment_18877,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v50722(VarCurr,B)
      <=> v48486(VarCurr,B) ) ) ).

fof(addAssignment_18876,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v48486(VarCurr,B)
      <=> v48488(VarCurr,B) ) ) ).

fof(addAssignment_18875,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v48488(VarCurr,B)
      <=> v48490(VarCurr,B) ) ) ).

fof(addAssignment_18874,axiom,
    ! [VarCurr] :
      ( v50698(VarCurr)
    <=> v50700(VarCurr,bitIndex1) ) ).

fof(addAssignment_18873,axiom,
    ! [VarCurr] :
      ( v50700(VarCurr,bitIndex1)
    <=> v50704(VarCurr,bitIndex1) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1580,axiom,
    ! [VarCurr] :
      ( ~ v50705(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v50704(VarCurr,B)
          <=> v50706(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1414,axiom,
    ! [VarCurr] :
      ( v50705(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v50704(VarCurr,B)
          <=> b10000000000000000(B) ) ) ) ).

fof(bitBlastConstant_10507,axiom,
    b10000000000000000(bitIndex16) ).

fof(bitBlastConstant_10506,axiom,
    ~ b10000000000000000(bitIndex15) ).

fof(bitBlastConstant_10505,axiom,
    ~ b10000000000000000(bitIndex14) ).

fof(bitBlastConstant_10504,axiom,
    ~ b10000000000000000(bitIndex13) ).

fof(bitBlastConstant_10503,axiom,
    ~ b10000000000000000(bitIndex12) ).

fof(bitBlastConstant_10502,axiom,
    ~ b10000000000000000(bitIndex11) ).

fof(bitBlastConstant_10501,axiom,
    ~ b10000000000000000(bitIndex10) ).

fof(bitBlastConstant_10500,axiom,
    ~ b10000000000000000(bitIndex9) ).

fof(bitBlastConstant_10499,axiom,
    ~ b10000000000000000(bitIndex8) ).

fof(bitBlastConstant_10498,axiom,
    ~ b10000000000000000(bitIndex7) ).

fof(bitBlastConstant_10497,axiom,
    ~ b10000000000000000(bitIndex6) ).

fof(bitBlastConstant_10496,axiom,
    ~ b10000000000000000(bitIndex5) ).

fof(bitBlastConstant_10495,axiom,
    ~ b10000000000000000(bitIndex4) ).

fof(bitBlastConstant_10494,axiom,
    ~ b10000000000000000(bitIndex3) ).

fof(bitBlastConstant_10493,axiom,
    ~ b10000000000000000(bitIndex2) ).

fof(bitBlastConstant_10492,axiom,
    ~ b10000000000000000(bitIndex1) ).

fof(bitBlastConstant_10491,axiom,
    ~ b10000000000000000(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges4_26,axiom,
    ! [VarCurr] :
      ( ( ~ v50707(VarCurr)
        & ~ v50709(VarCurr)
        & ~ v50713(VarCurr)
        & ~ v50717(VarCurr) )
     => ! [B] :
          ( range_16_0(B)
         => ( v50706(VarCurr,B)
          <=> v50703(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_113,axiom,
    ! [VarCurr] :
      ( v50717(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v50706(VarCurr,B)
          <=> v50703(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_418,axiom,
    ! [VarCurr] :
      ( v50713(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v50706(VarCurr,B)
          <=> v50715(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1101,axiom,
    ! [VarCurr] :
      ( v50709(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v50706(VarCurr,B)
          <=> v50711(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1067,axiom,
    ! [VarCurr] :
      ( v50707(VarCurr)
     => ! [B] :
          ( range_16_0(B)
         => ( v50706(VarCurr,B)
          <=> v50703(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3142,axiom,
    ! [VarCurr] :
      ( v50717(VarCurr)
    <=> ( ( v50718(VarCurr,bitIndex1)
        <=> $true )
        & ( v50718(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_18872,axiom,
    ! [VarCurr] :
      ( v50718(VarCurr,bitIndex0)
    <=> v48494(VarCurr) ) ).

fof(addAssignment_18871,axiom,
    ! [VarCurr] :
      ( v50718(VarCurr,bitIndex1)
    <=> v48474(VarCurr) ) ).

fof(addAssignment_18870,axiom,
    ! [VarCurr] :
      ( v50715(VarCurr,bitIndex0)
    <=> $false ) ).

fof(addAssignment_18869,axiom,
    ! [VarCurr] :
      ( ( v50715(VarCurr,bitIndex16)
      <=> v50703(VarCurr,bitIndex15) )
      & ( v50715(VarCurr,bitIndex15)
      <=> v50703(VarCurr,bitIndex14) )
      & ( v50715(VarCurr,bitIndex14)
      <=> v50703(VarCurr,bitIndex13) )
      & ( v50715(VarCurr,bitIndex13)
      <=> v50703(VarCurr,bitIndex12) )
      & ( v50715(VarCurr,bitIndex12)
      <=> v50703(VarCurr,bitIndex11) )
      & ( v50715(VarCurr,bitIndex11)
      <=> v50703(VarCurr,bitIndex10) )
      & ( v50715(VarCurr,bitIndex10)
      <=> v50703(VarCurr,bitIndex9) )
      & ( v50715(VarCurr,bitIndex9)
      <=> v50703(VarCurr,bitIndex8) )
      & ( v50715(VarCurr,bitIndex8)
      <=> v50703(VarCurr,bitIndex7) )
      & ( v50715(VarCurr,bitIndex7)
      <=> v50703(VarCurr,bitIndex6) )
      & ( v50715(VarCurr,bitIndex6)
      <=> v50703(VarCurr,bitIndex5) )
      & ( v50715(VarCurr,bitIndex5)
      <=> v50703(VarCurr,bitIndex4) )
      & ( v50715(VarCurr,bitIndex4)
      <=> v50703(VarCurr,bitIndex3) )
      & ( v50715(VarCurr,bitIndex3)
      <=> v50703(VarCurr,bitIndex2) )
      & ( v50715(VarCurr,bitIndex2)
      <=> v50703(VarCurr,bitIndex1) )
      & ( v50715(VarCurr,bitIndex1)
      <=> v50703(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_3141,axiom,
    ! [VarCurr] :
      ( v50713(VarCurr)
    <=> ( ( v50714(VarCurr,bitIndex1)
        <=> $true )
        & ( v50714(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_18868,axiom,
    ! [VarCurr] :
      ( v50714(VarCurr,bitIndex0)
    <=> v48494(VarCurr) ) ).

fof(addAssignment_18867,axiom,
    ! [VarCurr] :
      ( v50714(VarCurr,bitIndex1)
    <=> v48474(VarCurr) ) ).

fof(addAssignment_18866,axiom,
    ! [VarCurr] :
      ( ( v50711(VarCurr,bitIndex15)
      <=> v50703(VarCurr,bitIndex16) )
      & ( v50711(VarCurr,bitIndex14)
      <=> v50703(VarCurr,bitIndex15) )
      & ( v50711(VarCurr,bitIndex13)
      <=> v50703(VarCurr,bitIndex14) )
      & ( v50711(VarCurr,bitIndex12)
      <=> v50703(VarCurr,bitIndex13) )
      & ( v50711(VarCurr,bitIndex11)
      <=> v50703(VarCurr,bitIndex12) )
      & ( v50711(VarCurr,bitIndex10)
      <=> v50703(VarCurr,bitIndex11) )
      & ( v50711(VarCurr,bitIndex9)
      <=> v50703(VarCurr,bitIndex10) )
      & ( v50711(VarCurr,bitIndex8)
      <=> v50703(VarCurr,bitIndex9) )
      & ( v50711(VarCurr,bitIndex7)
      <=> v50703(VarCurr,bitIndex8) )
      & ( v50711(VarCurr,bitIndex6)
      <=> v50703(VarCurr,bitIndex7) )
      & ( v50711(VarCurr,bitIndex5)
      <=> v50703(VarCurr,bitIndex6) )
      & ( v50711(VarCurr,bitIndex4)
      <=> v50703(VarCurr,bitIndex5) )
      & ( v50711(VarCurr,bitIndex3)
      <=> v50703(VarCurr,bitIndex4) )
      & ( v50711(VarCurr,bitIndex2)
      <=> v50703(VarCurr,bitIndex3) )
      & ( v50711(VarCurr,bitIndex1)
      <=> v50703(VarCurr,bitIndex2) )
      & ( v50711(VarCurr,bitIndex0)
      <=> v50703(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_18865,axiom,
    ! [VarCurr] :
      ( v50711(VarCurr,bitIndex16)
    <=> $false ) ).

fof(addBitVectorEqualityBitBlasted_3140,axiom,
    ! [VarCurr] :
      ( v50709(VarCurr)
    <=> ( ( v50710(VarCurr,bitIndex1)
        <=> $false )
        & ( v50710(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_18864,axiom,
    ! [VarCurr] :
      ( v50710(VarCurr,bitIndex0)
    <=> v48494(VarCurr) ) ).

fof(addAssignment_18863,axiom,
    ! [VarCurr] :
      ( v50710(VarCurr,bitIndex1)
    <=> v48474(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_3139,axiom,
    ! [VarCurr] :
      ( v50707(VarCurr)
    <=> ( ( v50708(VarCurr,bitIndex1)
        <=> $false )
        & ( v50708(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_18862,axiom,
    ! [VarCurr] :
      ( v50708(VarCurr,bitIndex0)
    <=> v48494(VarCurr) ) ).

fof(addAssignment_18861,axiom,
    ! [VarCurr] :
      ( v50708(VarCurr,bitIndex1)
    <=> v48474(VarCurr) ) ).

fof(writeUnaryOperator_4489,axiom,
    ! [VarCurr] :
      ( ~ v50705(VarCurr)
    <=> v48472(VarCurr) ) ).

fof(addAssignment_18860,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v48349(VarCurr,B)
      <=> v48351(VarCurr,B) ) ) ).

fof(addAssignment_18859,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v48351(VarCurr,B)
      <=> v48353(VarCurr,B) ) ) ).

fof(addAssignment_18858,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v48353(VarCurr,B)
      <=> v48355(VarCurr,B) ) ) ).

fof(addAssignment_18857,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v48355(VarCurr,B)
      <=> v50684(VarCurr,B) ) ) ).

fof(addAssignment_18856,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v50561(VarCurr,B)
      <=> v50563(VarCurr,B) ) ) ).

fof(addAssignment_18855,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v50563(VarCurr,B)
      <=> v50565(VarCurr,B) ) ) ).

fof(addAssignment_18854,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v50565(VarCurr,B)
      <=> v50567(VarCurr,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_975,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50570(VarNext)
       => ! [B] :
            ( range_4_0(B)
           => ( v50567(VarNext,B)
            <=> v50567(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1038,axiom,
    ! [VarNext] :
      ( v50570(VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v50567(VarNext,B)
          <=> v50588(VarNext,B) ) ) ) ).

fof(addAssignment_18853,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v50588(VarNext,B)
          <=> v50586(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1100,axiom,
    ! [VarCurr] :
      ( ~ v48464(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v50586(VarCurr,B)
          <=> v50589(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1066,axiom,
    ! [VarCurr] :
      ( v48464(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v50586(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1099,axiom,
    ! [VarCurr] :
      ( ~ v50590(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v50589(VarCurr,B)
          <=> v50625(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1065,axiom,
    ! [VarCurr] :
      ( v50590(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v50589(VarCurr,B)
          <=> v50595(VarCurr,B) ) ) ) ).

fof(addAssignment_18852,axiom,
    ! [VarCurr] :
      ( v50625(VarCurr,bitIndex0)
    <=> v50677(VarCurr) ) ).

fof(addAssignment_18851,axiom,
    ! [VarCurr] :
      ( v50625(VarCurr,bitIndex1)
    <=> v50672(VarCurr) ) ).

fof(addAssignment_18850,axiom,
    ! [VarCurr] :
      ( v50625(VarCurr,bitIndex2)
    <=> v50667(VarCurr) ) ).

fof(addAssignment_18849,axiom,
    ! [VarCurr] :
      ( v50625(VarCurr,bitIndex3)
    <=> v50662(VarCurr) ) ).

fof(addAssignment_18848,axiom,
    ! [VarCurr] :
      ( v50625(VarCurr,bitIndex4)
    <=> v50627(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10638,axiom,
    ! [VarCurr] :
      ( v50677(VarCurr)
    <=> ( v50678(VarCurr)
        & v50681(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1895,axiom,
    ! [VarCurr] :
      ( v50681(VarCurr)
    <=> ( v48169(VarCurr,bitIndex33)
        | v47943(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10637,axiom,
    ! [VarCurr] :
      ( v50678(VarCurr)
    <=> ( v50679(VarCurr)
        | v50680(VarCurr) ) ) ).

fof(writeUnaryOperator_4488,axiom,
    ! [VarCurr] :
      ( ~ v50680(VarCurr)
    <=> v47943(VarCurr,bitIndex0) ) ).

fof(writeUnaryOperator_4487,axiom,
    ! [VarCurr] :
      ( ~ v50679(VarCurr)
    <=> v48169(VarCurr,bitIndex33) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10636,axiom,
    ! [VarCurr] :
      ( v50672(VarCurr)
    <=> ( v50673(VarCurr)
        & v50676(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10635,axiom,
    ! [VarCurr] :
      ( v50676(VarCurr)
    <=> ( v50636(VarCurr)
        | v50637(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10634,axiom,
    ! [VarCurr] :
      ( v50673(VarCurr)
    <=> ( v50674(VarCurr)
        | v50675(VarCurr) ) ) ).

fof(writeUnaryOperator_4486,axiom,
    ! [VarCurr] :
      ( ~ v50675(VarCurr)
    <=> v50637(VarCurr) ) ).

fof(writeUnaryOperator_4485,axiom,
    ! [VarCurr] :
      ( ~ v50674(VarCurr)
    <=> v50636(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10633,axiom,
    ! [VarCurr] :
      ( v50667(VarCurr)
    <=> ( v50668(VarCurr)
        & v50671(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10632,axiom,
    ! [VarCurr] :
      ( v50671(VarCurr)
    <=> ( v50634(VarCurr)
        | v50643(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10631,axiom,
    ! [VarCurr] :
      ( v50668(VarCurr)
    <=> ( v50669(VarCurr)
        | v50670(VarCurr) ) ) ).

fof(writeUnaryOperator_4484,axiom,
    ! [VarCurr] :
      ( ~ v50670(VarCurr)
    <=> v50643(VarCurr) ) ).

fof(writeUnaryOperator_4483,axiom,
    ! [VarCurr] :
      ( ~ v50669(VarCurr)
    <=> v50634(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10630,axiom,
    ! [VarCurr] :
      ( v50662(VarCurr)
    <=> ( v50663(VarCurr)
        & v50666(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10629,axiom,
    ! [VarCurr] :
      ( v50666(VarCurr)
    <=> ( v50632(VarCurr)
        | v50649(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10628,axiom,
    ! [VarCurr] :
      ( v50663(VarCurr)
    <=> ( v50664(VarCurr)
        | v50665(VarCurr) ) ) ).

fof(writeUnaryOperator_4482,axiom,
    ! [VarCurr] :
      ( ~ v50665(VarCurr)
    <=> v50649(VarCurr) ) ).

fof(writeUnaryOperator_4481,axiom,
    ! [VarCurr] :
      ( ~ v50664(VarCurr)
    <=> v50632(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10627,axiom,
    ! [VarCurr] :
      ( v50627(VarCurr)
    <=> ( v50628(VarCurr)
        & v50661(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10626,axiom,
    ! [VarCurr] :
      ( v50661(VarCurr)
    <=> ( v50630(VarCurr)
        | v50656(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10625,axiom,
    ! [VarCurr] :
      ( v50628(VarCurr)
    <=> ( v50629(VarCurr)
        | v50655(VarCurr) ) ) ).

fof(writeUnaryOperator_4480,axiom,
    ! [VarCurr] :
      ( ~ v50655(VarCurr)
    <=> v50656(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10624,axiom,
    ! [VarCurr] :
      ( v50656(VarCurr)
    <=> ( v50657(VarCurr)
        & v50660(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1894,axiom,
    ! [VarCurr] :
      ( v50660(VarCurr)
    <=> ( v48169(VarCurr,bitIndex37)
        | v47943(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10623,axiom,
    ! [VarCurr] :
      ( v50657(VarCurr)
    <=> ( v50658(VarCurr)
        | v50659(VarCurr) ) ) ).

fof(writeUnaryOperator_4479,axiom,
    ! [VarCurr] :
      ( ~ v50659(VarCurr)
    <=> v47943(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_4478,axiom,
    ! [VarCurr] :
      ( ~ v50658(VarCurr)
    <=> v48169(VarCurr,bitIndex37) ) ).

fof(writeUnaryOperator_4477,axiom,
    ! [VarCurr] :
      ( ~ v50629(VarCurr)
    <=> v50630(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10622,axiom,
    ! [VarCurr] :
      ( v50630(VarCurr)
    <=> ( v50631(VarCurr)
        | v50654(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1893,axiom,
    ! [VarCurr] :
      ( v50654(VarCurr)
    <=> ( v48169(VarCurr,bitIndex36)
        & v47943(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10621,axiom,
    ! [VarCurr] :
      ( v50631(VarCurr)
    <=> ( v50632(VarCurr)
        & v50649(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10620,axiom,
    ! [VarCurr] :
      ( v50649(VarCurr)
    <=> ( v50650(VarCurr)
        & v50653(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1892,axiom,
    ! [VarCurr] :
      ( v50653(VarCurr)
    <=> ( v48169(VarCurr,bitIndex36)
        | v47943(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10619,axiom,
    ! [VarCurr] :
      ( v50650(VarCurr)
    <=> ( v50651(VarCurr)
        | v50652(VarCurr) ) ) ).

fof(writeUnaryOperator_4476,axiom,
    ! [VarCurr] :
      ( ~ v50652(VarCurr)
    <=> v47943(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_4475,axiom,
    ! [VarCurr] :
      ( ~ v50651(VarCurr)
    <=> v48169(VarCurr,bitIndex36) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10618,axiom,
    ! [VarCurr] :
      ( v50632(VarCurr)
    <=> ( v50633(VarCurr)
        | v50648(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1891,axiom,
    ! [VarCurr] :
      ( v50648(VarCurr)
    <=> ( v48169(VarCurr,bitIndex35)
        & v47943(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10617,axiom,
    ! [VarCurr] :
      ( v50633(VarCurr)
    <=> ( v50634(VarCurr)
        & v50643(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10616,axiom,
    ! [VarCurr] :
      ( v50643(VarCurr)
    <=> ( v50644(VarCurr)
        & v50647(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1890,axiom,
    ! [VarCurr] :
      ( v50647(VarCurr)
    <=> ( v48169(VarCurr,bitIndex35)
        | v47943(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10615,axiom,
    ! [VarCurr] :
      ( v50644(VarCurr)
    <=> ( v50645(VarCurr)
        | v50646(VarCurr) ) ) ).

fof(writeUnaryOperator_4474,axiom,
    ! [VarCurr] :
      ( ~ v50646(VarCurr)
    <=> v47943(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_4473,axiom,
    ! [VarCurr] :
      ( ~ v50645(VarCurr)
    <=> v48169(VarCurr,bitIndex35) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10614,axiom,
    ! [VarCurr] :
      ( v50634(VarCurr)
    <=> ( v50635(VarCurr)
        | v50642(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1889,axiom,
    ! [VarCurr] :
      ( v50642(VarCurr)
    <=> ( v48169(VarCurr,bitIndex34)
        & v47943(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10613,axiom,
    ! [VarCurr] :
      ( v50635(VarCurr)
    <=> ( v50636(VarCurr)
        & v50637(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10612,axiom,
    ! [VarCurr] :
      ( v50637(VarCurr)
    <=> ( v50638(VarCurr)
        & v50641(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1888,axiom,
    ! [VarCurr] :
      ( v50641(VarCurr)
    <=> ( v48169(VarCurr,bitIndex34)
        | v47943(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10611,axiom,
    ! [VarCurr] :
      ( v50638(VarCurr)
    <=> ( v50639(VarCurr)
        | v50640(VarCurr) ) ) ).

fof(writeUnaryOperator_4472,axiom,
    ! [VarCurr] :
      ( ~ v50640(VarCurr)
    <=> v47943(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_4471,axiom,
    ! [VarCurr] :
      ( ~ v50639(VarCurr)
    <=> v48169(VarCurr,bitIndex34) ) ).

fof(writeBinaryOperatorShiftedRanges_1887,axiom,
    ! [VarCurr] :
      ( v50636(VarCurr)
    <=> ( v48169(VarCurr,bitIndex33)
        & v47943(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10610,axiom,
    ! [VarCurr] :
      ( v50620(VarCurr)
    <=> ( v50621(VarCurr)
        | v50623(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3138,axiom,
    ! [VarCurr] :
      ( v50623(VarCurr)
    <=> ( ( v50624(VarCurr,bitIndex1)
        <=> $false )
        & ( v50624(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_18847,axiom,
    ! [VarCurr] :
      ( v50624(VarCurr,bitIndex0)
    <=> v47935(VarCurr) ) ).

fof(addAssignment_18846,axiom,
    ! [VarCurr] :
      ( v50624(VarCurr,bitIndex1)
    <=> v47899(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_3137,axiom,
    ! [VarCurr] :
      ( v50621(VarCurr)
    <=> ( ( v50622(VarCurr,bitIndex1)
        <=> $false )
        & ( v50622(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_18845,axiom,
    ! [VarCurr] :
      ( v50622(VarCurr,bitIndex0)
    <=> v47935(VarCurr) ) ).

fof(addAssignment_18844,axiom,
    ! [VarCurr] :
      ( v50622(VarCurr,bitIndex1)
    <=> v47899(VarCurr) ) ).

fof(addAssignment_18843,axiom,
    ! [VarCurr] :
      ( v50595(VarCurr,bitIndex0)
    <=> v50617(VarCurr) ) ).

fof(addAssignment_18842,axiom,
    ! [VarCurr] :
      ( v50595(VarCurr,bitIndex1)
    <=> v50615(VarCurr) ) ).

fof(addAssignment_18841,axiom,
    ! [VarCurr] :
      ( v50595(VarCurr,bitIndex2)
    <=> v50610(VarCurr) ) ).

fof(addAssignment_18840,axiom,
    ! [VarCurr] :
      ( v50595(VarCurr,bitIndex3)
    <=> v50605(VarCurr) ) ).

fof(addAssignment_18839,axiom,
    ! [VarCurr] :
      ( v50595(VarCurr,bitIndex4)
    <=> v50597(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10609,axiom,
    ! [VarCurr] :
      ( v50615(VarCurr)
    <=> ( v50616(VarCurr)
        & v50619(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1886,axiom,
    ! [VarCurr] :
      ( v50619(VarCurr)
    <=> ( v50567(VarCurr,bitIndex0)
        | v50567(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10608,axiom,
    ! [VarCurr] :
      ( v50616(VarCurr)
    <=> ( v50617(VarCurr)
        | v50618(VarCurr) ) ) ).

fof(writeUnaryOperator_4470,axiom,
    ! [VarCurr] :
      ( ~ v50618(VarCurr)
    <=> v50567(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_4469,axiom,
    ! [VarCurr] :
      ( ~ v50617(VarCurr)
    <=> v50567(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10607,axiom,
    ! [VarCurr] :
      ( v50610(VarCurr)
    <=> ( v50611(VarCurr)
        & v50614(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1885,axiom,
    ! [VarCurr] :
      ( v50614(VarCurr)
    <=> ( v50602(VarCurr)
        | v50567(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10606,axiom,
    ! [VarCurr] :
      ( v50611(VarCurr)
    <=> ( v50612(VarCurr)
        | v50613(VarCurr) ) ) ).

fof(writeUnaryOperator_4468,axiom,
    ! [VarCurr] :
      ( ~ v50613(VarCurr)
    <=> v50567(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_4467,axiom,
    ! [VarCurr] :
      ( ~ v50612(VarCurr)
    <=> v50602(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10605,axiom,
    ! [VarCurr] :
      ( v50605(VarCurr)
    <=> ( v50606(VarCurr)
        & v50609(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1884,axiom,
    ! [VarCurr] :
      ( v50609(VarCurr)
    <=> ( v50601(VarCurr)
        | v50567(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10604,axiom,
    ! [VarCurr] :
      ( v50606(VarCurr)
    <=> ( v50607(VarCurr)
        | v50608(VarCurr) ) ) ).

fof(writeUnaryOperator_4466,axiom,
    ! [VarCurr] :
      ( ~ v50608(VarCurr)
    <=> v50567(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_4465,axiom,
    ! [VarCurr] :
      ( ~ v50607(VarCurr)
    <=> v50601(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10603,axiom,
    ! [VarCurr] :
      ( v50597(VarCurr)
    <=> ( v50598(VarCurr)
        & v50604(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1883,axiom,
    ! [VarCurr] :
      ( v50604(VarCurr)
    <=> ( v50600(VarCurr)
        | v50567(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10602,axiom,
    ! [VarCurr] :
      ( v50598(VarCurr)
    <=> ( v50599(VarCurr)
        | v50603(VarCurr) ) ) ).

fof(writeUnaryOperator_4464,axiom,
    ! [VarCurr] :
      ( ~ v50603(VarCurr)
    <=> v50567(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_4463,axiom,
    ! [VarCurr] :
      ( ~ v50599(VarCurr)
    <=> v50600(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_1882,axiom,
    ! [VarCurr] :
      ( v50600(VarCurr)
    <=> ( v50601(VarCurr)
        & v50567(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1881,axiom,
    ! [VarCurr] :
      ( v50601(VarCurr)
    <=> ( v50602(VarCurr)
        & v50567(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1880,axiom,
    ! [VarCurr] :
      ( v50602(VarCurr)
    <=> ( v50567(VarCurr,bitIndex0)
        & v50567(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10601,axiom,
    ! [VarCurr] :
      ( v50590(VarCurr)
    <=> ( v50591(VarCurr)
        | v50593(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3136,axiom,
    ! [VarCurr] :
      ( v50593(VarCurr)
    <=> ( ( v50594(VarCurr,bitIndex1)
        <=> $true )
        & ( v50594(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_18838,axiom,
    ! [VarCurr] :
      ( v50594(VarCurr,bitIndex0)
    <=> v47935(VarCurr) ) ).

fof(addAssignment_18837,axiom,
    ! [VarCurr] :
      ( v50594(VarCurr,bitIndex1)
    <=> v47899(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_3135,axiom,
    ! [VarCurr] :
      ( v50591(VarCurr)
    <=> ( ( v50592(VarCurr,bitIndex1)
        <=> $true )
        & ( v50592(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_18836,axiom,
    ! [VarCurr] :
      ( v50592(VarCurr,bitIndex0)
    <=> v47935(VarCurr) ) ).

fof(addAssignment_18835,axiom,
    ! [VarCurr] :
      ( v50592(VarCurr,bitIndex1)
    <=> v47899(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10600,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50570(VarNext)
      <=> ( v50571(VarNext)
          & v50578(VarNext) ) ) ) ).

fof(addAssignment_18834,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50578(VarNext)
      <=> v50576(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10599,axiom,
    ! [VarCurr] :
      ( v50576(VarCurr)
    <=> ( v50579(VarCurr)
        & v50583(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10598,axiom,
    ! [VarCurr] :
      ( v50583(VarCurr)
    <=> ( v50584(VarCurr)
        | v48464(VarCurr) ) ) ).

fof(writeUnaryOperator_4462,axiom,
    ! [VarCurr] :
      ( ~ v50584(VarCurr)
    <=> v50585(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_3134,axiom,
    ! [VarCurr] :
      ( v50585(VarCurr)
    <=> ( v48645(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10597,axiom,
    ! [VarCurr] :
      ( v50579(VarCurr)
    <=> ( v48464(VarCurr)
        | v50580(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10596,axiom,
    ! [VarCurr] :
      ( v50580(VarCurr)
    <=> ( v50581(VarCurr)
        & v50582(VarCurr) ) ) ).

fof(writeUnaryOperator_4461,axiom,
    ! [VarCurr] :
      ( ~ v50582(VarCurr)
    <=> v48464(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_3133,axiom,
    ! [VarCurr] :
      ( v50581(VarCurr)
    <=> ( v48645(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10595,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50571(VarNext)
      <=> ( v50573(VarNext)
          & v45620(VarNext) ) ) ) ).

fof(writeUnaryOperator_4460,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50573(VarNext)
      <=> v47885(VarNext) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_974,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50549(VarNext)
       => ( v48643(VarNext)
        <=> v48643(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1037,axiom,
    ! [VarNext] :
      ( v50549(VarNext)
     => ( v48643(VarNext)
      <=> v50557(VarNext) ) ) ).

fof(addAssignment_18833,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50557(VarNext)
      <=> v50555(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1579,axiom,
    ! [VarCurr] :
      ( ~ v48464(VarCurr)
     => ( v50555(VarCurr)
      <=> v48645(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1413,axiom,
    ! [VarCurr] :
      ( v48464(VarCurr)
     => ( v50555(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10594,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50549(VarNext)
      <=> v50550(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10593,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50550(VarNext)
      <=> ( v50552(VarNext)
          & v45620(VarNext) ) ) ) ).

fof(writeUnaryOperator_4459,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50552(VarNext)
      <=> v47885(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges5_24,axiom,
    ! [VarCurr] :
      ( ( ~ v48405(VarCurr)
        & ~ v48406(VarCurr)
        & ~ v48407(VarCurr)
        & ~ v48408(VarCurr)
        & ~ v48420(VarCurr) )
     => ( v48645(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_25,axiom,
    ! [VarCurr] :
      ( v48420(VarCurr)
     => ( v48645(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_112,axiom,
    ! [VarCurr] :
      ( v48408(VarCurr)
     => ( v48645(VarCurr)
      <=> v50544(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_417,axiom,
    ! [VarCurr] :
      ( v48407(VarCurr)
     => ( v48645(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1098,axiom,
    ! [VarCurr] :
      ( v48406(VarCurr)
     => ( v48645(VarCurr)
      <=> v50540(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1064,axiom,
    ! [VarCurr] :
      ( v48405(VarCurr)
     => ( v48645(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1097,axiom,
    ! [VarCurr] :
      ( ~ v48410(VarCurr)
     => ( v50544(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1063,axiom,
    ! [VarCurr] :
      ( v48410(VarCurr)
     => ( v50544(VarCurr)
      <=> v50545(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1096,axiom,
    ! [VarCurr] :
      ( ~ v50546(VarCurr)
     => ( v50545(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1062,axiom,
    ! [VarCurr] :
      ( v50546(VarCurr)
     => ( v50545(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10592,axiom,
    ! [VarCurr] :
      ( v50546(VarCurr)
    <=> ( v48412(VarCurr)
        | v48414(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1095,axiom,
    ! [VarCurr] :
      ( ~ v49269(VarCurr)
     => ( v50540(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1061,axiom,
    ! [VarCurr] :
      ( v49269(VarCurr)
     => ( v50540(VarCurr)
      <=> v50541(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1094,axiom,
    ! [VarCurr] :
      ( ~ v50542(VarCurr)
     => ( v50541(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1060,axiom,
    ! [VarCurr] :
      ( v50542(VarCurr)
     => ( v50541(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3132,axiom,
    ! [VarCurr] :
      ( v50543(VarCurr)
    <=> ( v48647(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3131,axiom,
    ! [VarCurr] :
      ( v50542(VarCurr)
    <=> ( v48647(VarCurr)
      <=> $true ) ) ).

fof(addCaseBooleanConditionEqualRanges1_973,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50432(VarNext)
       => ( v48647(VarNext)
        <=> v48647(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1036,axiom,
    ! [VarNext] :
      ( v50432(VarNext)
     => ( v48647(VarNext)
      <=> v50448(VarNext) ) ) ).

fof(addAssignment_18832,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50448(VarNext)
      <=> v50446(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1578,axiom,
    ! [VarCurr] :
      ( ~ v50445(VarCurr)
     => ( v50446(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1412,axiom,
    ! [VarCurr] :
      ( v50445(VarCurr)
     => ( v50446(VarCurr)
      <=> v50449(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3130,axiom,
    ! [VarCurr] :
      ( v50449(VarCurr)
    <=> ( ( v50450(VarCurr,bitIndex5)
        <=> $false )
        & ( v50450(VarCurr,bitIndex4)
        <=> $false )
        & ( v50450(VarCurr,bitIndex3)
        <=> $false )
        & ( v50450(VarCurr,bitIndex2)
        <=> $false )
        & ( v50450(VarCurr,bitIndex1)
        <=> $false )
        & ( v50450(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_18831,axiom,
    ! [VarCurr] :
      ( v50450(VarCurr,bitIndex0)
    <=> v50534(VarCurr) ) ).

fof(addAssignment_18830,axiom,
    ! [VarCurr] :
      ( v50450(VarCurr,bitIndex1)
    <=> v50529(VarCurr) ) ).

fof(addAssignment_18829,axiom,
    ! [VarCurr] :
      ( v50450(VarCurr,bitIndex2)
    <=> v50524(VarCurr) ) ).

fof(addAssignment_18828,axiom,
    ! [VarCurr] :
      ( v50450(VarCurr,bitIndex3)
    <=> v50519(VarCurr) ) ).

fof(addAssignment_18827,axiom,
    ! [VarCurr] :
      ( v50450(VarCurr,bitIndex4)
    <=> v50514(VarCurr) ) ).

fof(addAssignment_18826,axiom,
    ! [VarCurr] :
      ( v50450(VarCurr,bitIndex5)
    <=> v50452(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10591,axiom,
    ! [VarCurr] :
      ( v50534(VarCurr)
    <=> ( v50535(VarCurr)
        & v50536(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1879,axiom,
    ! [VarCurr] :
      ( v50536(VarCurr)
    <=> ( v48649(VarCurr,bitIndex38)
        | v49526(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10590,axiom,
    ! [VarCurr] :
      ( v50535(VarCurr)
    <=> ( v49683(VarCurr)
        | v50470(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10589,axiom,
    ! [VarCurr] :
      ( v50529(VarCurr)
    <=> ( v50530(VarCurr)
        & v50533(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10588,axiom,
    ! [VarCurr] :
      ( v50533(VarCurr)
    <=> ( v50463(VarCurr)
        | v50464(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10587,axiom,
    ! [VarCurr] :
      ( v50530(VarCurr)
    <=> ( v50531(VarCurr)
        | v50532(VarCurr) ) ) ).

fof(writeUnaryOperator_4458,axiom,
    ! [VarCurr] :
      ( ~ v50532(VarCurr)
    <=> v50464(VarCurr) ) ).

fof(writeUnaryOperator_4457,axiom,
    ! [VarCurr] :
      ( ~ v50531(VarCurr)
    <=> v50463(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10586,axiom,
    ! [VarCurr] :
      ( v50524(VarCurr)
    <=> ( v50525(VarCurr)
        & v50528(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10585,axiom,
    ! [VarCurr] :
      ( v50528(VarCurr)
    <=> ( v50461(VarCurr)
        | v50474(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10584,axiom,
    ! [VarCurr] :
      ( v50525(VarCurr)
    <=> ( v50526(VarCurr)
        | v50527(VarCurr) ) ) ).

fof(writeUnaryOperator_4456,axiom,
    ! [VarCurr] :
      ( ~ v50527(VarCurr)
    <=> v50474(VarCurr) ) ).

fof(writeUnaryOperator_4455,axiom,
    ! [VarCurr] :
      ( ~ v50526(VarCurr)
    <=> v50461(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10583,axiom,
    ! [VarCurr] :
      ( v50519(VarCurr)
    <=> ( v50520(VarCurr)
        & v50523(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10582,axiom,
    ! [VarCurr] :
      ( v50523(VarCurr)
    <=> ( v50459(VarCurr)
        | v50485(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10581,axiom,
    ! [VarCurr] :
      ( v50520(VarCurr)
    <=> ( v50521(VarCurr)
        | v50522(VarCurr) ) ) ).

fof(writeUnaryOperator_4454,axiom,
    ! [VarCurr] :
      ( ~ v50522(VarCurr)
    <=> v50485(VarCurr) ) ).

fof(writeUnaryOperator_4453,axiom,
    ! [VarCurr] :
      ( ~ v50521(VarCurr)
    <=> v50459(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10580,axiom,
    ! [VarCurr] :
      ( v50514(VarCurr)
    <=> ( v50515(VarCurr)
        & v50518(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10579,axiom,
    ! [VarCurr] :
      ( v50518(VarCurr)
    <=> ( v50457(VarCurr)
        | v50496(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10578,axiom,
    ! [VarCurr] :
      ( v50515(VarCurr)
    <=> ( v50516(VarCurr)
        | v50517(VarCurr) ) ) ).

fof(writeUnaryOperator_4452,axiom,
    ! [VarCurr] :
      ( ~ v50517(VarCurr)
    <=> v50496(VarCurr) ) ).

fof(writeUnaryOperator_4451,axiom,
    ! [VarCurr] :
      ( ~ v50516(VarCurr)
    <=> v50457(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10577,axiom,
    ! [VarCurr] :
      ( v50452(VarCurr)
    <=> ( v50453(VarCurr)
        & v50513(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10576,axiom,
    ! [VarCurr] :
      ( v50513(VarCurr)
    <=> ( v50455(VarCurr)
        | v50508(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10575,axiom,
    ! [VarCurr] :
      ( v50453(VarCurr)
    <=> ( v50454(VarCurr)
        | v50507(VarCurr) ) ) ).

fof(writeUnaryOperator_4450,axiom,
    ! [VarCurr] :
      ( ~ v50507(VarCurr)
    <=> v50508(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10574,axiom,
    ! [VarCurr] :
      ( v50508(VarCurr)
    <=> ( v50509(VarCurr)
        & v50511(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1878,axiom,
    ! [VarCurr] :
      ( v50511(VarCurr)
    <=> ( v48649(VarCurr,bitIndex43)
        | v50512(VarCurr) ) ) ).

fof(writeUnaryOperator_4449,axiom,
    ! [VarCurr] :
      ( ~ v50512(VarCurr)
    <=> v50510(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10573,axiom,
    ! [VarCurr] :
      ( v50509(VarCurr)
    <=> ( v49657(VarCurr)
        | v50510(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10572,axiom,
    ! [VarCurr] :
      ( v50510(VarCurr)
    <=> ( v50502(VarCurr)
        & v50504(VarCurr) ) ) ).

fof(writeUnaryOperator_4448,axiom,
    ! [VarCurr] :
      ( ~ v50454(VarCurr)
    <=> v50455(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10571,axiom,
    ! [VarCurr] :
      ( v50455(VarCurr)
    <=> ( v50456(VarCurr)
        | v50506(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1877,axiom,
    ! [VarCurr] :
      ( v50506(VarCurr)
    <=> ( v48649(VarCurr,bitIndex42)
        & v50499(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10570,axiom,
    ! [VarCurr] :
      ( v50456(VarCurr)
    <=> ( v50457(VarCurr)
        & v50496(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10569,axiom,
    ! [VarCurr] :
      ( v50496(VarCurr)
    <=> ( v50497(VarCurr)
        & v50505(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1876,axiom,
    ! [VarCurr] :
      ( v50505(VarCurr)
    <=> ( v48649(VarCurr,bitIndex42)
        | v50499(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10568,axiom,
    ! [VarCurr] :
      ( v50497(VarCurr)
    <=> ( v49650(VarCurr)
        | v50498(VarCurr) ) ) ).

fof(writeUnaryOperator_4447,axiom,
    ! [VarCurr] :
      ( ~ v50498(VarCurr)
    <=> v50499(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10567,axiom,
    ! [VarCurr] :
      ( v50499(VarCurr)
    <=> ( v50500(VarCurr)
        & v50503(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10566,axiom,
    ! [VarCurr] :
      ( v50503(VarCurr)
    <=> ( v50502(VarCurr)
        | v50504(VarCurr) ) ) ).

fof(writeUnaryOperator_4446,axiom,
    ! [VarCurr] :
      ( ~ v50504(VarCurr)
    <=> v49526(VarCurr,bitIndex4) ) ).

fof(writeBinaryOperatorShiftedRanges_1875,axiom,
    ! [VarCurr] :
      ( v50500(VarCurr)
    <=> ( v50501(VarCurr)
        | v49526(VarCurr,bitIndex4) ) ) ).

fof(writeUnaryOperator_4445,axiom,
    ! [VarCurr] :
      ( ~ v50501(VarCurr)
    <=> v50502(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10565,axiom,
    ! [VarCurr] :
      ( v50502(VarCurr)
    <=> ( v50491(VarCurr)
        & v50493(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10564,axiom,
    ! [VarCurr] :
      ( v50457(VarCurr)
    <=> ( v50458(VarCurr)
        | v50495(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1874,axiom,
    ! [VarCurr] :
      ( v50495(VarCurr)
    <=> ( v48649(VarCurr,bitIndex41)
        & v50488(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10563,axiom,
    ! [VarCurr] :
      ( v50458(VarCurr)
    <=> ( v50459(VarCurr)
        & v50485(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10562,axiom,
    ! [VarCurr] :
      ( v50485(VarCurr)
    <=> ( v50486(VarCurr)
        & v50494(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1873,axiom,
    ! [VarCurr] :
      ( v50494(VarCurr)
    <=> ( v48649(VarCurr,bitIndex41)
        | v50488(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10561,axiom,
    ! [VarCurr] :
      ( v50486(VarCurr)
    <=> ( v49638(VarCurr)
        | v50487(VarCurr) ) ) ).

fof(writeUnaryOperator_4444,axiom,
    ! [VarCurr] :
      ( ~ v50487(VarCurr)
    <=> v50488(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10560,axiom,
    ! [VarCurr] :
      ( v50488(VarCurr)
    <=> ( v50489(VarCurr)
        & v50492(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10559,axiom,
    ! [VarCurr] :
      ( v50492(VarCurr)
    <=> ( v50491(VarCurr)
        | v50493(VarCurr) ) ) ).

fof(writeUnaryOperator_4443,axiom,
    ! [VarCurr] :
      ( ~ v50493(VarCurr)
    <=> v49526(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorShiftedRanges_1872,axiom,
    ! [VarCurr] :
      ( v50489(VarCurr)
    <=> ( v50490(VarCurr)
        | v49526(VarCurr,bitIndex3) ) ) ).

fof(writeUnaryOperator_4442,axiom,
    ! [VarCurr] :
      ( ~ v50490(VarCurr)
    <=> v50491(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10558,axiom,
    ! [VarCurr] :
      ( v50491(VarCurr)
    <=> ( v50480(VarCurr)
        & v50482(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10557,axiom,
    ! [VarCurr] :
      ( v50459(VarCurr)
    <=> ( v50460(VarCurr)
        | v50484(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1871,axiom,
    ! [VarCurr] :
      ( v50484(VarCurr)
    <=> ( v48649(VarCurr,bitIndex40)
        & v50477(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10556,axiom,
    ! [VarCurr] :
      ( v50460(VarCurr)
    <=> ( v50461(VarCurr)
        & v50474(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10555,axiom,
    ! [VarCurr] :
      ( v50474(VarCurr)
    <=> ( v50475(VarCurr)
        & v50483(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1870,axiom,
    ! [VarCurr] :
      ( v50483(VarCurr)
    <=> ( v48649(VarCurr,bitIndex40)
        | v50477(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10554,axiom,
    ! [VarCurr] :
      ( v50475(VarCurr)
    <=> ( v49626(VarCurr)
        | v50476(VarCurr) ) ) ).

fof(writeUnaryOperator_4441,axiom,
    ! [VarCurr] :
      ( ~ v50476(VarCurr)
    <=> v50477(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10553,axiom,
    ! [VarCurr] :
      ( v50477(VarCurr)
    <=> ( v50478(VarCurr)
        & v50481(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10552,axiom,
    ! [VarCurr] :
      ( v50481(VarCurr)
    <=> ( v50480(VarCurr)
        | v50482(VarCurr) ) ) ).

fof(writeUnaryOperator_4440,axiom,
    ! [VarCurr] :
      ( ~ v50482(VarCurr)
    <=> v49526(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges_1869,axiom,
    ! [VarCurr] :
      ( v50478(VarCurr)
    <=> ( v50479(VarCurr)
        | v49526(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_4439,axiom,
    ! [VarCurr] :
      ( ~ v50479(VarCurr)
    <=> v50480(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10551,axiom,
    ! [VarCurr] :
      ( v50480(VarCurr)
    <=> ( v50470(VarCurr)
        & v50471(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10550,axiom,
    ! [VarCurr] :
      ( v50461(VarCurr)
    <=> ( v50462(VarCurr)
        | v50473(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1868,axiom,
    ! [VarCurr] :
      ( v50473(VarCurr)
    <=> ( v48649(VarCurr,bitIndex39)
        & v50467(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10549,axiom,
    ! [VarCurr] :
      ( v50462(VarCurr)
    <=> ( v50463(VarCurr)
        & v50464(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10548,axiom,
    ! [VarCurr] :
      ( v50464(VarCurr)
    <=> ( v50465(VarCurr)
        & v50472(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1867,axiom,
    ! [VarCurr] :
      ( v50472(VarCurr)
    <=> ( v48649(VarCurr,bitIndex39)
        | v50467(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10547,axiom,
    ! [VarCurr] :
      ( v50465(VarCurr)
    <=> ( v49614(VarCurr)
        | v50466(VarCurr) ) ) ).

fof(writeUnaryOperator_4438,axiom,
    ! [VarCurr] :
      ( ~ v50466(VarCurr)
    <=> v50467(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10546,axiom,
    ! [VarCurr] :
      ( v50467(VarCurr)
    <=> ( v50468(VarCurr)
        & v50469(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10545,axiom,
    ! [VarCurr] :
      ( v50469(VarCurr)
    <=> ( v50470(VarCurr)
        | v50471(VarCurr) ) ) ).

fof(writeUnaryOperator_4437,axiom,
    ! [VarCurr] :
      ( ~ v50471(VarCurr)
    <=> v49526(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_4436,axiom,
    ! [VarCurr] :
      ( ~ v50470(VarCurr)
    <=> v49526(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorShiftedRanges_1866,axiom,
    ! [VarCurr] :
      ( v50468(VarCurr)
    <=> ( v49526(VarCurr,bitIndex0)
        | v49526(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_1865,axiom,
    ! [VarCurr] :
      ( v50463(VarCurr)
    <=> ( v48649(VarCurr,bitIndex38)
        & v49526(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10544,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50432(VarNext)
      <=> ( v50433(VarNext)
          & v50440(VarNext) ) ) ) ).

fof(addAssignment_18825,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50440(VarNext)
      <=> v50438(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10543,axiom,
    ! [VarCurr] :
      ( v50438(VarCurr)
    <=> ( v50441(VarCurr)
        & v50442(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10542,axiom,
    ! [VarCurr] :
      ( v50442(VarCurr)
    <=> ( v50443(VarCurr)
        | v48464(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10541,axiom,
    ! [VarCurr] :
      ( v50443(VarCurr)
    <=> ( v48345(VarCurr)
        | v50444(VarCurr) ) ) ).

fof(writeUnaryOperator_4435,axiom,
    ! [VarCurr] :
      ( ~ v50444(VarCurr)
    <=> v50445(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_3129,axiom,
    ! [VarCurr] :
      ( v50445(VarCurr)
    <=> ( v47899(VarCurr)
      <=> $true ) ) ).

fof(writeUnaryOperator_4434,axiom,
    ! [VarCurr] :
      ( ~ v50441(VarCurr)
    <=> v48464(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10540,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50433(VarNext)
      <=> ( v50435(VarNext)
          & v45620(VarNext) ) ) ) ).

fof(writeUnaryOperator_4433,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50435(VarNext)
      <=> v47885(VarNext) ) ) ).

fof(addAssignment_18824,axiom,
    ! [VarCurr,B] :
      ( range_43_38(B)
     => ( v48169(VarCurr,B)
      <=> v48171(VarCurr,B) ) ) ).

fof(addAssignment_18823,axiom,
    ! [VarCurr,B] :
      ( range_43_38(B)
     => ( v48171(VarCurr,B)
      <=> v48173(VarCurr,B) ) ) ).

fof(addAssignment_18822,axiom,
    ! [VarCurr,B] :
      ( range_43_38(B)
     => ( v48173(VarCurr,B)
      <=> v48175(VarCurr,B) ) ) ).

fof(addAssignment_18821,axiom,
    ! [VarCurr,B] :
      ( range_43_38(B)
     => ( v48175(VarCurr,B)
      <=> v49506(VarCurr,B) ) ) ).

fof(range_axiom_212,axiom,
    ! [B] :
      ( range_43_38(B)
    <=> ( $false
        | bitIndex38 = B
        | bitIndex39 = B
        | bitIndex40 = B
        | bitIndex41 = B
        | bitIndex42 = B
        | bitIndex43 = B ) ) ).

fof(memoryReadIntoBuffer_55,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00000_address_term = A
             => ( range_43_0(B)
               => ( v50138(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_54,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00001_address_term = A
             => ( range_43_0(B)
               => ( v50147(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_53,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00010_address_term = A
             => ( range_43_0(B)
               => ( v50156(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_52,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00011_address_term = A
             => ( range_43_0(B)
               => ( v50165(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_51,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00100_address_term = A
             => ( range_43_0(B)
               => ( v50174(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_50,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00101_address_term = A
             => ( range_43_0(B)
               => ( v50183(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_49,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00110_address_term = A
             => ( range_43_0(B)
               => ( v50192(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_48,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b00111_address_term = A
             => ( range_43_0(B)
               => ( v50201(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_47,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01000_address_term = A
             => ( range_43_0(B)
               => ( v50210(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_46,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01001_address_term = A
             => ( range_43_0(B)
               => ( v50219(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_45,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01010_address_term = A
             => ( range_43_0(B)
               => ( v50228(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_44,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01011_address_term = A
             => ( range_43_0(B)
               => ( v50237(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_43,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01100_address_term = A
             => ( range_43_0(B)
               => ( v50246(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_42,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01101_address_term = A
             => ( range_43_0(B)
               => ( v50255(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_41,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01110_address_term = A
             => ( range_43_0(B)
               => ( v50264(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_40,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b01111_address_term = A
             => ( range_43_0(B)
               => ( v50273(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_39,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10000_address_term = A
             => ( range_43_0(B)
               => ( v50282(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_38,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10001_address_term = A
             => ( range_43_0(B)
               => ( v50291(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_37,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10010_address_term = A
             => ( range_43_0(B)
               => ( v50300(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_36,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10011_address_term = A
             => ( range_43_0(B)
               => ( v50309(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_35,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10100_address_term = A
             => ( range_43_0(B)
               => ( v50318(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_34,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10101_address_term = A
             => ( range_43_0(B)
               => ( v50327(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_33,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10110_address_term = A
             => ( range_43_0(B)
               => ( v50336(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_32,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b10111_address_term = A
             => ( range_43_0(B)
               => ( v50345(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_31,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11000_address_term = A
             => ( range_43_0(B)
               => ( v50354(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_30,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11001_address_term = A
             => ( range_43_0(B)
               => ( v50363(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_29,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11010_address_term = A
             => ( range_43_0(B)
               => ( v50372(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_28,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11011_address_term = A
             => ( range_43_0(B)
               => ( v50381(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_27,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11100_address_term = A
             => ( range_43_0(B)
               => ( v50390(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_26,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11101_address_term = A
             => ( range_43_0(B)
               => ( v50399(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_25,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11110_address_term = A
             => ( range_43_0(B)
               => ( v50408(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_24,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b11111_address_term = A
             => ( range_43_0(B)
               => ( v50417(VarNext,B)
                <=> v48177_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_23,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v49258_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( address(A)
             => ! [B] :
                  ( A = AssociatedAddressVar
                 => ( range_43_0(B)
                   => ( v49506(VarNext,B)
                    <=> v48177_array(VarNext,A,B) ) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_22,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v49218_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( address(A)
             => ! [B] :
                  ( A = AssociatedAddressVar
                 => ( range_43_0(B)
                   => ( v50428(VarNext,B)
                    <=> v48177_array(VarNext,A,B) ) ) ) ) ) ) ).

fof(memoryConstantWriteDisabled_6,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( $true
              & v50420(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_array(VarNext,A,B)
              <=> v48177_36__array(VarNext,A,B) ) ) ) ) ).

fof(memoryConstantWriteEnabledInsideRange_6,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( $true
            & v50420(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_array(VarNext,A,B)
              <=> b00000000000000000000000000000000000000000000(B) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10539,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50420(VarNext)
      <=> ( v50421(VarNext)
          & v50426(VarNext) ) ) ) ).

fof(addAssignment_18820,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50426(VarNext)
      <=> v50091(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10538,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50421(VarNext)
      <=> ( v50423(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4432,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50423(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_57,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11111_address_term = A
              & v50411(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_36__array(VarNext,A,B)
              <=> v48177_35__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_57,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11111_address_term = A
            & v50411(VarNext) )
         => ( ( v48177_36__array(VarNext,A,bitIndex43)
            <=> v50417(VarNext,bitIndex1407) )
            & ( v48177_36__array(VarNext,A,bitIndex42)
            <=> v50417(VarNext,bitIndex1406) )
            & ( v48177_36__array(VarNext,A,bitIndex41)
            <=> v50417(VarNext,bitIndex1405) )
            & ( v48177_36__array(VarNext,A,bitIndex40)
            <=> v50417(VarNext,bitIndex1404) )
            & ( v48177_36__array(VarNext,A,bitIndex39)
            <=> v50417(VarNext,bitIndex1403) )
            & ( v48177_36__array(VarNext,A,bitIndex38)
            <=> v50417(VarNext,bitIndex1402) )
            & ( v48177_36__array(VarNext,A,bitIndex37)
            <=> v50417(VarNext,bitIndex1401) )
            & ( v48177_36__array(VarNext,A,bitIndex36)
            <=> v50417(VarNext,bitIndex1400) )
            & ( v48177_36__array(VarNext,A,bitIndex35)
            <=> v50417(VarNext,bitIndex1399) )
            & ( v48177_36__array(VarNext,A,bitIndex34)
            <=> v50417(VarNext,bitIndex1398) )
            & ( v48177_36__array(VarNext,A,bitIndex33)
            <=> v50417(VarNext,bitIndex1397) )
            & ( v48177_36__array(VarNext,A,bitIndex32)
            <=> v50417(VarNext,bitIndex1396) )
            & ( v48177_36__array(VarNext,A,bitIndex31)
            <=> v50417(VarNext,bitIndex1395) )
            & ( v48177_36__array(VarNext,A,bitIndex30)
            <=> v50417(VarNext,bitIndex1394) )
            & ( v48177_36__array(VarNext,A,bitIndex29)
            <=> v50417(VarNext,bitIndex1393) )
            & ( v48177_36__array(VarNext,A,bitIndex28)
            <=> v50417(VarNext,bitIndex1392) )
            & ( v48177_36__array(VarNext,A,bitIndex27)
            <=> v50417(VarNext,bitIndex1391) )
            & ( v48177_36__array(VarNext,A,bitIndex26)
            <=> v50417(VarNext,bitIndex1390) )
            & ( v48177_36__array(VarNext,A,bitIndex25)
            <=> v50417(VarNext,bitIndex1389) )
            & ( v48177_36__array(VarNext,A,bitIndex24)
            <=> v50417(VarNext,bitIndex1388) )
            & ( v48177_36__array(VarNext,A,bitIndex23)
            <=> v50417(VarNext,bitIndex1387) )
            & ( v48177_36__array(VarNext,A,bitIndex22)
            <=> v50417(VarNext,bitIndex1386) )
            & ( v48177_36__array(VarNext,A,bitIndex21)
            <=> v50417(VarNext,bitIndex1385) )
            & ( v48177_36__array(VarNext,A,bitIndex20)
            <=> v50417(VarNext,bitIndex1384) )
            & ( v48177_36__array(VarNext,A,bitIndex19)
            <=> v50417(VarNext,bitIndex1383) )
            & ( v48177_36__array(VarNext,A,bitIndex18)
            <=> v50417(VarNext,bitIndex1382) )
            & ( v48177_36__array(VarNext,A,bitIndex17)
            <=> v50417(VarNext,bitIndex1381) )
            & ( v48177_36__array(VarNext,A,bitIndex16)
            <=> v50417(VarNext,bitIndex1380) )
            & ( v48177_36__array(VarNext,A,bitIndex15)
            <=> v50417(VarNext,bitIndex1379) )
            & ( v48177_36__array(VarNext,A,bitIndex14)
            <=> v50417(VarNext,bitIndex1378) )
            & ( v48177_36__array(VarNext,A,bitIndex13)
            <=> v50417(VarNext,bitIndex1377) )
            & ( v48177_36__array(VarNext,A,bitIndex12)
            <=> v50417(VarNext,bitIndex1376) )
            & ( v48177_36__array(VarNext,A,bitIndex11)
            <=> v50417(VarNext,bitIndex1375) )
            & ( v48177_36__array(VarNext,A,bitIndex10)
            <=> v50417(VarNext,bitIndex1374) )
            & ( v48177_36__array(VarNext,A,bitIndex9)
            <=> v50417(VarNext,bitIndex1373) )
            & ( v48177_36__array(VarNext,A,bitIndex8)
            <=> v50417(VarNext,bitIndex1372) )
            & ( v48177_36__array(VarNext,A,bitIndex7)
            <=> v50417(VarNext,bitIndex1371) )
            & ( v48177_36__array(VarNext,A,bitIndex6)
            <=> v50417(VarNext,bitIndex1370) )
            & ( v48177_36__array(VarNext,A,bitIndex5)
            <=> v50417(VarNext,bitIndex1369) )
            & ( v48177_36__array(VarNext,A,bitIndex4)
            <=> v50417(VarNext,bitIndex1368) )
            & ( v48177_36__array(VarNext,A,bitIndex3)
            <=> v50417(VarNext,bitIndex1367) )
            & ( v48177_36__array(VarNext,A,bitIndex2)
            <=> v50417(VarNext,bitIndex1366) )
            & ( v48177_36__array(VarNext,A,bitIndex1)
            <=> v50417(VarNext,bitIndex1365) )
            & ( v48177_36__array(VarNext,A,bitIndex0)
            <=> v50417(VarNext,bitIndex1364) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10537,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50411(VarNext)
      <=> ( v50412(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10536,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50412(VarNext)
      <=> ( v50414(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4431,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50414(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_56,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11110_address_term = A
              & v50402(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_35__array(VarNext,A,B)
              <=> v48177_34__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_56,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11110_address_term = A
            & v50402(VarNext) )
         => ( ( v48177_35__array(VarNext,A,bitIndex43)
            <=> v50408(VarNext,bitIndex1363) )
            & ( v48177_35__array(VarNext,A,bitIndex42)
            <=> v50408(VarNext,bitIndex1362) )
            & ( v48177_35__array(VarNext,A,bitIndex41)
            <=> v50408(VarNext,bitIndex1361) )
            & ( v48177_35__array(VarNext,A,bitIndex40)
            <=> v50408(VarNext,bitIndex1360) )
            & ( v48177_35__array(VarNext,A,bitIndex39)
            <=> v50408(VarNext,bitIndex1359) )
            & ( v48177_35__array(VarNext,A,bitIndex38)
            <=> v50408(VarNext,bitIndex1358) )
            & ( v48177_35__array(VarNext,A,bitIndex37)
            <=> v50408(VarNext,bitIndex1357) )
            & ( v48177_35__array(VarNext,A,bitIndex36)
            <=> v50408(VarNext,bitIndex1356) )
            & ( v48177_35__array(VarNext,A,bitIndex35)
            <=> v50408(VarNext,bitIndex1355) )
            & ( v48177_35__array(VarNext,A,bitIndex34)
            <=> v50408(VarNext,bitIndex1354) )
            & ( v48177_35__array(VarNext,A,bitIndex33)
            <=> v50408(VarNext,bitIndex1353) )
            & ( v48177_35__array(VarNext,A,bitIndex32)
            <=> v50408(VarNext,bitIndex1352) )
            & ( v48177_35__array(VarNext,A,bitIndex31)
            <=> v50408(VarNext,bitIndex1351) )
            & ( v48177_35__array(VarNext,A,bitIndex30)
            <=> v50408(VarNext,bitIndex1350) )
            & ( v48177_35__array(VarNext,A,bitIndex29)
            <=> v50408(VarNext,bitIndex1349) )
            & ( v48177_35__array(VarNext,A,bitIndex28)
            <=> v50408(VarNext,bitIndex1348) )
            & ( v48177_35__array(VarNext,A,bitIndex27)
            <=> v50408(VarNext,bitIndex1347) )
            & ( v48177_35__array(VarNext,A,bitIndex26)
            <=> v50408(VarNext,bitIndex1346) )
            & ( v48177_35__array(VarNext,A,bitIndex25)
            <=> v50408(VarNext,bitIndex1345) )
            & ( v48177_35__array(VarNext,A,bitIndex24)
            <=> v50408(VarNext,bitIndex1344) )
            & ( v48177_35__array(VarNext,A,bitIndex23)
            <=> v50408(VarNext,bitIndex1343) )
            & ( v48177_35__array(VarNext,A,bitIndex22)
            <=> v50408(VarNext,bitIndex1342) )
            & ( v48177_35__array(VarNext,A,bitIndex21)
            <=> v50408(VarNext,bitIndex1341) )
            & ( v48177_35__array(VarNext,A,bitIndex20)
            <=> v50408(VarNext,bitIndex1340) )
            & ( v48177_35__array(VarNext,A,bitIndex19)
            <=> v50408(VarNext,bitIndex1339) )
            & ( v48177_35__array(VarNext,A,bitIndex18)
            <=> v50408(VarNext,bitIndex1338) )
            & ( v48177_35__array(VarNext,A,bitIndex17)
            <=> v50408(VarNext,bitIndex1337) )
            & ( v48177_35__array(VarNext,A,bitIndex16)
            <=> v50408(VarNext,bitIndex1336) )
            & ( v48177_35__array(VarNext,A,bitIndex15)
            <=> v50408(VarNext,bitIndex1335) )
            & ( v48177_35__array(VarNext,A,bitIndex14)
            <=> v50408(VarNext,bitIndex1334) )
            & ( v48177_35__array(VarNext,A,bitIndex13)
            <=> v50408(VarNext,bitIndex1333) )
            & ( v48177_35__array(VarNext,A,bitIndex12)
            <=> v50408(VarNext,bitIndex1332) )
            & ( v48177_35__array(VarNext,A,bitIndex11)
            <=> v50408(VarNext,bitIndex1331) )
            & ( v48177_35__array(VarNext,A,bitIndex10)
            <=> v50408(VarNext,bitIndex1330) )
            & ( v48177_35__array(VarNext,A,bitIndex9)
            <=> v50408(VarNext,bitIndex1329) )
            & ( v48177_35__array(VarNext,A,bitIndex8)
            <=> v50408(VarNext,bitIndex1328) )
            & ( v48177_35__array(VarNext,A,bitIndex7)
            <=> v50408(VarNext,bitIndex1327) )
            & ( v48177_35__array(VarNext,A,bitIndex6)
            <=> v50408(VarNext,bitIndex1326) )
            & ( v48177_35__array(VarNext,A,bitIndex5)
            <=> v50408(VarNext,bitIndex1325) )
            & ( v48177_35__array(VarNext,A,bitIndex4)
            <=> v50408(VarNext,bitIndex1324) )
            & ( v48177_35__array(VarNext,A,bitIndex3)
            <=> v50408(VarNext,bitIndex1323) )
            & ( v48177_35__array(VarNext,A,bitIndex2)
            <=> v50408(VarNext,bitIndex1322) )
            & ( v48177_35__array(VarNext,A,bitIndex1)
            <=> v50408(VarNext,bitIndex1321) )
            & ( v48177_35__array(VarNext,A,bitIndex0)
            <=> v50408(VarNext,bitIndex1320) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10535,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50402(VarNext)
      <=> ( v50403(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10534,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50403(VarNext)
      <=> ( v50405(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4430,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50405(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_55,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11101_address_term = A
              & v50393(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_34__array(VarNext,A,B)
              <=> v48177_33__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_55,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11101_address_term = A
            & v50393(VarNext) )
         => ( ( v48177_34__array(VarNext,A,bitIndex43)
            <=> v50399(VarNext,bitIndex1319) )
            & ( v48177_34__array(VarNext,A,bitIndex42)
            <=> v50399(VarNext,bitIndex1318) )
            & ( v48177_34__array(VarNext,A,bitIndex41)
            <=> v50399(VarNext,bitIndex1317) )
            & ( v48177_34__array(VarNext,A,bitIndex40)
            <=> v50399(VarNext,bitIndex1316) )
            & ( v48177_34__array(VarNext,A,bitIndex39)
            <=> v50399(VarNext,bitIndex1315) )
            & ( v48177_34__array(VarNext,A,bitIndex38)
            <=> v50399(VarNext,bitIndex1314) )
            & ( v48177_34__array(VarNext,A,bitIndex37)
            <=> v50399(VarNext,bitIndex1313) )
            & ( v48177_34__array(VarNext,A,bitIndex36)
            <=> v50399(VarNext,bitIndex1312) )
            & ( v48177_34__array(VarNext,A,bitIndex35)
            <=> v50399(VarNext,bitIndex1311) )
            & ( v48177_34__array(VarNext,A,bitIndex34)
            <=> v50399(VarNext,bitIndex1310) )
            & ( v48177_34__array(VarNext,A,bitIndex33)
            <=> v50399(VarNext,bitIndex1309) )
            & ( v48177_34__array(VarNext,A,bitIndex32)
            <=> v50399(VarNext,bitIndex1308) )
            & ( v48177_34__array(VarNext,A,bitIndex31)
            <=> v50399(VarNext,bitIndex1307) )
            & ( v48177_34__array(VarNext,A,bitIndex30)
            <=> v50399(VarNext,bitIndex1306) )
            & ( v48177_34__array(VarNext,A,bitIndex29)
            <=> v50399(VarNext,bitIndex1305) )
            & ( v48177_34__array(VarNext,A,bitIndex28)
            <=> v50399(VarNext,bitIndex1304) )
            & ( v48177_34__array(VarNext,A,bitIndex27)
            <=> v50399(VarNext,bitIndex1303) )
            & ( v48177_34__array(VarNext,A,bitIndex26)
            <=> v50399(VarNext,bitIndex1302) )
            & ( v48177_34__array(VarNext,A,bitIndex25)
            <=> v50399(VarNext,bitIndex1301) )
            & ( v48177_34__array(VarNext,A,bitIndex24)
            <=> v50399(VarNext,bitIndex1300) )
            & ( v48177_34__array(VarNext,A,bitIndex23)
            <=> v50399(VarNext,bitIndex1299) )
            & ( v48177_34__array(VarNext,A,bitIndex22)
            <=> v50399(VarNext,bitIndex1298) )
            & ( v48177_34__array(VarNext,A,bitIndex21)
            <=> v50399(VarNext,bitIndex1297) )
            & ( v48177_34__array(VarNext,A,bitIndex20)
            <=> v50399(VarNext,bitIndex1296) )
            & ( v48177_34__array(VarNext,A,bitIndex19)
            <=> v50399(VarNext,bitIndex1295) )
            & ( v48177_34__array(VarNext,A,bitIndex18)
            <=> v50399(VarNext,bitIndex1294) )
            & ( v48177_34__array(VarNext,A,bitIndex17)
            <=> v50399(VarNext,bitIndex1293) )
            & ( v48177_34__array(VarNext,A,bitIndex16)
            <=> v50399(VarNext,bitIndex1292) )
            & ( v48177_34__array(VarNext,A,bitIndex15)
            <=> v50399(VarNext,bitIndex1291) )
            & ( v48177_34__array(VarNext,A,bitIndex14)
            <=> v50399(VarNext,bitIndex1290) )
            & ( v48177_34__array(VarNext,A,bitIndex13)
            <=> v50399(VarNext,bitIndex1289) )
            & ( v48177_34__array(VarNext,A,bitIndex12)
            <=> v50399(VarNext,bitIndex1288) )
            & ( v48177_34__array(VarNext,A,bitIndex11)
            <=> v50399(VarNext,bitIndex1287) )
            & ( v48177_34__array(VarNext,A,bitIndex10)
            <=> v50399(VarNext,bitIndex1286) )
            & ( v48177_34__array(VarNext,A,bitIndex9)
            <=> v50399(VarNext,bitIndex1285) )
            & ( v48177_34__array(VarNext,A,bitIndex8)
            <=> v50399(VarNext,bitIndex1284) )
            & ( v48177_34__array(VarNext,A,bitIndex7)
            <=> v50399(VarNext,bitIndex1283) )
            & ( v48177_34__array(VarNext,A,bitIndex6)
            <=> v50399(VarNext,bitIndex1282) )
            & ( v48177_34__array(VarNext,A,bitIndex5)
            <=> v50399(VarNext,bitIndex1281) )
            & ( v48177_34__array(VarNext,A,bitIndex4)
            <=> v50399(VarNext,bitIndex1280) )
            & ( v48177_34__array(VarNext,A,bitIndex3)
            <=> v50399(VarNext,bitIndex1279) )
            & ( v48177_34__array(VarNext,A,bitIndex2)
            <=> v50399(VarNext,bitIndex1278) )
            & ( v48177_34__array(VarNext,A,bitIndex1)
            <=> v50399(VarNext,bitIndex1277) )
            & ( v48177_34__array(VarNext,A,bitIndex0)
            <=> v50399(VarNext,bitIndex1276) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10533,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50393(VarNext)
      <=> ( v50394(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10532,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50394(VarNext)
      <=> ( v50396(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4429,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50396(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_54,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11100_address_term = A
              & v50384(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_33__array(VarNext,A,B)
              <=> v48177_32__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_54,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11100_address_term = A
            & v50384(VarNext) )
         => ( ( v48177_33__array(VarNext,A,bitIndex43)
            <=> v50390(VarNext,bitIndex1275) )
            & ( v48177_33__array(VarNext,A,bitIndex42)
            <=> v50390(VarNext,bitIndex1274) )
            & ( v48177_33__array(VarNext,A,bitIndex41)
            <=> v50390(VarNext,bitIndex1273) )
            & ( v48177_33__array(VarNext,A,bitIndex40)
            <=> v50390(VarNext,bitIndex1272) )
            & ( v48177_33__array(VarNext,A,bitIndex39)
            <=> v50390(VarNext,bitIndex1271) )
            & ( v48177_33__array(VarNext,A,bitIndex38)
            <=> v50390(VarNext,bitIndex1270) )
            & ( v48177_33__array(VarNext,A,bitIndex37)
            <=> v50390(VarNext,bitIndex1269) )
            & ( v48177_33__array(VarNext,A,bitIndex36)
            <=> v50390(VarNext,bitIndex1268) )
            & ( v48177_33__array(VarNext,A,bitIndex35)
            <=> v50390(VarNext,bitIndex1267) )
            & ( v48177_33__array(VarNext,A,bitIndex34)
            <=> v50390(VarNext,bitIndex1266) )
            & ( v48177_33__array(VarNext,A,bitIndex33)
            <=> v50390(VarNext,bitIndex1265) )
            & ( v48177_33__array(VarNext,A,bitIndex32)
            <=> v50390(VarNext,bitIndex1264) )
            & ( v48177_33__array(VarNext,A,bitIndex31)
            <=> v50390(VarNext,bitIndex1263) )
            & ( v48177_33__array(VarNext,A,bitIndex30)
            <=> v50390(VarNext,bitIndex1262) )
            & ( v48177_33__array(VarNext,A,bitIndex29)
            <=> v50390(VarNext,bitIndex1261) )
            & ( v48177_33__array(VarNext,A,bitIndex28)
            <=> v50390(VarNext,bitIndex1260) )
            & ( v48177_33__array(VarNext,A,bitIndex27)
            <=> v50390(VarNext,bitIndex1259) )
            & ( v48177_33__array(VarNext,A,bitIndex26)
            <=> v50390(VarNext,bitIndex1258) )
            & ( v48177_33__array(VarNext,A,bitIndex25)
            <=> v50390(VarNext,bitIndex1257) )
            & ( v48177_33__array(VarNext,A,bitIndex24)
            <=> v50390(VarNext,bitIndex1256) )
            & ( v48177_33__array(VarNext,A,bitIndex23)
            <=> v50390(VarNext,bitIndex1255) )
            & ( v48177_33__array(VarNext,A,bitIndex22)
            <=> v50390(VarNext,bitIndex1254) )
            & ( v48177_33__array(VarNext,A,bitIndex21)
            <=> v50390(VarNext,bitIndex1253) )
            & ( v48177_33__array(VarNext,A,bitIndex20)
            <=> v50390(VarNext,bitIndex1252) )
            & ( v48177_33__array(VarNext,A,bitIndex19)
            <=> v50390(VarNext,bitIndex1251) )
            & ( v48177_33__array(VarNext,A,bitIndex18)
            <=> v50390(VarNext,bitIndex1250) )
            & ( v48177_33__array(VarNext,A,bitIndex17)
            <=> v50390(VarNext,bitIndex1249) )
            & ( v48177_33__array(VarNext,A,bitIndex16)
            <=> v50390(VarNext,bitIndex1248) )
            & ( v48177_33__array(VarNext,A,bitIndex15)
            <=> v50390(VarNext,bitIndex1247) )
            & ( v48177_33__array(VarNext,A,bitIndex14)
            <=> v50390(VarNext,bitIndex1246) )
            & ( v48177_33__array(VarNext,A,bitIndex13)
            <=> v50390(VarNext,bitIndex1245) )
            & ( v48177_33__array(VarNext,A,bitIndex12)
            <=> v50390(VarNext,bitIndex1244) )
            & ( v48177_33__array(VarNext,A,bitIndex11)
            <=> v50390(VarNext,bitIndex1243) )
            & ( v48177_33__array(VarNext,A,bitIndex10)
            <=> v50390(VarNext,bitIndex1242) )
            & ( v48177_33__array(VarNext,A,bitIndex9)
            <=> v50390(VarNext,bitIndex1241) )
            & ( v48177_33__array(VarNext,A,bitIndex8)
            <=> v50390(VarNext,bitIndex1240) )
            & ( v48177_33__array(VarNext,A,bitIndex7)
            <=> v50390(VarNext,bitIndex1239) )
            & ( v48177_33__array(VarNext,A,bitIndex6)
            <=> v50390(VarNext,bitIndex1238) )
            & ( v48177_33__array(VarNext,A,bitIndex5)
            <=> v50390(VarNext,bitIndex1237) )
            & ( v48177_33__array(VarNext,A,bitIndex4)
            <=> v50390(VarNext,bitIndex1236) )
            & ( v48177_33__array(VarNext,A,bitIndex3)
            <=> v50390(VarNext,bitIndex1235) )
            & ( v48177_33__array(VarNext,A,bitIndex2)
            <=> v50390(VarNext,bitIndex1234) )
            & ( v48177_33__array(VarNext,A,bitIndex1)
            <=> v50390(VarNext,bitIndex1233) )
            & ( v48177_33__array(VarNext,A,bitIndex0)
            <=> v50390(VarNext,bitIndex1232) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10531,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50384(VarNext)
      <=> ( v50385(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10530,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50385(VarNext)
      <=> ( v50387(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4428,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50387(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_53,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11011_address_term = A
              & v50375(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_32__array(VarNext,A,B)
              <=> v48177_31__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_53,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11011_address_term = A
            & v50375(VarNext) )
         => ( ( v48177_32__array(VarNext,A,bitIndex43)
            <=> v50381(VarNext,bitIndex1231) )
            & ( v48177_32__array(VarNext,A,bitIndex42)
            <=> v50381(VarNext,bitIndex1230) )
            & ( v48177_32__array(VarNext,A,bitIndex41)
            <=> v50381(VarNext,bitIndex1229) )
            & ( v48177_32__array(VarNext,A,bitIndex40)
            <=> v50381(VarNext,bitIndex1228) )
            & ( v48177_32__array(VarNext,A,bitIndex39)
            <=> v50381(VarNext,bitIndex1227) )
            & ( v48177_32__array(VarNext,A,bitIndex38)
            <=> v50381(VarNext,bitIndex1226) )
            & ( v48177_32__array(VarNext,A,bitIndex37)
            <=> v50381(VarNext,bitIndex1225) )
            & ( v48177_32__array(VarNext,A,bitIndex36)
            <=> v50381(VarNext,bitIndex1224) )
            & ( v48177_32__array(VarNext,A,bitIndex35)
            <=> v50381(VarNext,bitIndex1223) )
            & ( v48177_32__array(VarNext,A,bitIndex34)
            <=> v50381(VarNext,bitIndex1222) )
            & ( v48177_32__array(VarNext,A,bitIndex33)
            <=> v50381(VarNext,bitIndex1221) )
            & ( v48177_32__array(VarNext,A,bitIndex32)
            <=> v50381(VarNext,bitIndex1220) )
            & ( v48177_32__array(VarNext,A,bitIndex31)
            <=> v50381(VarNext,bitIndex1219) )
            & ( v48177_32__array(VarNext,A,bitIndex30)
            <=> v50381(VarNext,bitIndex1218) )
            & ( v48177_32__array(VarNext,A,bitIndex29)
            <=> v50381(VarNext,bitIndex1217) )
            & ( v48177_32__array(VarNext,A,bitIndex28)
            <=> v50381(VarNext,bitIndex1216) )
            & ( v48177_32__array(VarNext,A,bitIndex27)
            <=> v50381(VarNext,bitIndex1215) )
            & ( v48177_32__array(VarNext,A,bitIndex26)
            <=> v50381(VarNext,bitIndex1214) )
            & ( v48177_32__array(VarNext,A,bitIndex25)
            <=> v50381(VarNext,bitIndex1213) )
            & ( v48177_32__array(VarNext,A,bitIndex24)
            <=> v50381(VarNext,bitIndex1212) )
            & ( v48177_32__array(VarNext,A,bitIndex23)
            <=> v50381(VarNext,bitIndex1211) )
            & ( v48177_32__array(VarNext,A,bitIndex22)
            <=> v50381(VarNext,bitIndex1210) )
            & ( v48177_32__array(VarNext,A,bitIndex21)
            <=> v50381(VarNext,bitIndex1209) )
            & ( v48177_32__array(VarNext,A,bitIndex20)
            <=> v50381(VarNext,bitIndex1208) )
            & ( v48177_32__array(VarNext,A,bitIndex19)
            <=> v50381(VarNext,bitIndex1207) )
            & ( v48177_32__array(VarNext,A,bitIndex18)
            <=> v50381(VarNext,bitIndex1206) )
            & ( v48177_32__array(VarNext,A,bitIndex17)
            <=> v50381(VarNext,bitIndex1205) )
            & ( v48177_32__array(VarNext,A,bitIndex16)
            <=> v50381(VarNext,bitIndex1204) )
            & ( v48177_32__array(VarNext,A,bitIndex15)
            <=> v50381(VarNext,bitIndex1203) )
            & ( v48177_32__array(VarNext,A,bitIndex14)
            <=> v50381(VarNext,bitIndex1202) )
            & ( v48177_32__array(VarNext,A,bitIndex13)
            <=> v50381(VarNext,bitIndex1201) )
            & ( v48177_32__array(VarNext,A,bitIndex12)
            <=> v50381(VarNext,bitIndex1200) )
            & ( v48177_32__array(VarNext,A,bitIndex11)
            <=> v50381(VarNext,bitIndex1199) )
            & ( v48177_32__array(VarNext,A,bitIndex10)
            <=> v50381(VarNext,bitIndex1198) )
            & ( v48177_32__array(VarNext,A,bitIndex9)
            <=> v50381(VarNext,bitIndex1197) )
            & ( v48177_32__array(VarNext,A,bitIndex8)
            <=> v50381(VarNext,bitIndex1196) )
            & ( v48177_32__array(VarNext,A,bitIndex7)
            <=> v50381(VarNext,bitIndex1195) )
            & ( v48177_32__array(VarNext,A,bitIndex6)
            <=> v50381(VarNext,bitIndex1194) )
            & ( v48177_32__array(VarNext,A,bitIndex5)
            <=> v50381(VarNext,bitIndex1193) )
            & ( v48177_32__array(VarNext,A,bitIndex4)
            <=> v50381(VarNext,bitIndex1192) )
            & ( v48177_32__array(VarNext,A,bitIndex3)
            <=> v50381(VarNext,bitIndex1191) )
            & ( v48177_32__array(VarNext,A,bitIndex2)
            <=> v50381(VarNext,bitIndex1190) )
            & ( v48177_32__array(VarNext,A,bitIndex1)
            <=> v50381(VarNext,bitIndex1189) )
            & ( v48177_32__array(VarNext,A,bitIndex0)
            <=> v50381(VarNext,bitIndex1188) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10529,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50375(VarNext)
      <=> ( v50376(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10528,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50376(VarNext)
      <=> ( v50378(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4427,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50378(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_52,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11010_address_term = A
              & v50366(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_31__array(VarNext,A,B)
              <=> v48177_30__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_52,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11010_address_term = A
            & v50366(VarNext) )
         => ( ( v48177_31__array(VarNext,A,bitIndex43)
            <=> v50372(VarNext,bitIndex1187) )
            & ( v48177_31__array(VarNext,A,bitIndex42)
            <=> v50372(VarNext,bitIndex1186) )
            & ( v48177_31__array(VarNext,A,bitIndex41)
            <=> v50372(VarNext,bitIndex1185) )
            & ( v48177_31__array(VarNext,A,bitIndex40)
            <=> v50372(VarNext,bitIndex1184) )
            & ( v48177_31__array(VarNext,A,bitIndex39)
            <=> v50372(VarNext,bitIndex1183) )
            & ( v48177_31__array(VarNext,A,bitIndex38)
            <=> v50372(VarNext,bitIndex1182) )
            & ( v48177_31__array(VarNext,A,bitIndex37)
            <=> v50372(VarNext,bitIndex1181) )
            & ( v48177_31__array(VarNext,A,bitIndex36)
            <=> v50372(VarNext,bitIndex1180) )
            & ( v48177_31__array(VarNext,A,bitIndex35)
            <=> v50372(VarNext,bitIndex1179) )
            & ( v48177_31__array(VarNext,A,bitIndex34)
            <=> v50372(VarNext,bitIndex1178) )
            & ( v48177_31__array(VarNext,A,bitIndex33)
            <=> v50372(VarNext,bitIndex1177) )
            & ( v48177_31__array(VarNext,A,bitIndex32)
            <=> v50372(VarNext,bitIndex1176) )
            & ( v48177_31__array(VarNext,A,bitIndex31)
            <=> v50372(VarNext,bitIndex1175) )
            & ( v48177_31__array(VarNext,A,bitIndex30)
            <=> v50372(VarNext,bitIndex1174) )
            & ( v48177_31__array(VarNext,A,bitIndex29)
            <=> v50372(VarNext,bitIndex1173) )
            & ( v48177_31__array(VarNext,A,bitIndex28)
            <=> v50372(VarNext,bitIndex1172) )
            & ( v48177_31__array(VarNext,A,bitIndex27)
            <=> v50372(VarNext,bitIndex1171) )
            & ( v48177_31__array(VarNext,A,bitIndex26)
            <=> v50372(VarNext,bitIndex1170) )
            & ( v48177_31__array(VarNext,A,bitIndex25)
            <=> v50372(VarNext,bitIndex1169) )
            & ( v48177_31__array(VarNext,A,bitIndex24)
            <=> v50372(VarNext,bitIndex1168) )
            & ( v48177_31__array(VarNext,A,bitIndex23)
            <=> v50372(VarNext,bitIndex1167) )
            & ( v48177_31__array(VarNext,A,bitIndex22)
            <=> v50372(VarNext,bitIndex1166) )
            & ( v48177_31__array(VarNext,A,bitIndex21)
            <=> v50372(VarNext,bitIndex1165) )
            & ( v48177_31__array(VarNext,A,bitIndex20)
            <=> v50372(VarNext,bitIndex1164) )
            & ( v48177_31__array(VarNext,A,bitIndex19)
            <=> v50372(VarNext,bitIndex1163) )
            & ( v48177_31__array(VarNext,A,bitIndex18)
            <=> v50372(VarNext,bitIndex1162) )
            & ( v48177_31__array(VarNext,A,bitIndex17)
            <=> v50372(VarNext,bitIndex1161) )
            & ( v48177_31__array(VarNext,A,bitIndex16)
            <=> v50372(VarNext,bitIndex1160) )
            & ( v48177_31__array(VarNext,A,bitIndex15)
            <=> v50372(VarNext,bitIndex1159) )
            & ( v48177_31__array(VarNext,A,bitIndex14)
            <=> v50372(VarNext,bitIndex1158) )
            & ( v48177_31__array(VarNext,A,bitIndex13)
            <=> v50372(VarNext,bitIndex1157) )
            & ( v48177_31__array(VarNext,A,bitIndex12)
            <=> v50372(VarNext,bitIndex1156) )
            & ( v48177_31__array(VarNext,A,bitIndex11)
            <=> v50372(VarNext,bitIndex1155) )
            & ( v48177_31__array(VarNext,A,bitIndex10)
            <=> v50372(VarNext,bitIndex1154) )
            & ( v48177_31__array(VarNext,A,bitIndex9)
            <=> v50372(VarNext,bitIndex1153) )
            & ( v48177_31__array(VarNext,A,bitIndex8)
            <=> v50372(VarNext,bitIndex1152) )
            & ( v48177_31__array(VarNext,A,bitIndex7)
            <=> v50372(VarNext,bitIndex1151) )
            & ( v48177_31__array(VarNext,A,bitIndex6)
            <=> v50372(VarNext,bitIndex1150) )
            & ( v48177_31__array(VarNext,A,bitIndex5)
            <=> v50372(VarNext,bitIndex1149) )
            & ( v48177_31__array(VarNext,A,bitIndex4)
            <=> v50372(VarNext,bitIndex1148) )
            & ( v48177_31__array(VarNext,A,bitIndex3)
            <=> v50372(VarNext,bitIndex1147) )
            & ( v48177_31__array(VarNext,A,bitIndex2)
            <=> v50372(VarNext,bitIndex1146) )
            & ( v48177_31__array(VarNext,A,bitIndex1)
            <=> v50372(VarNext,bitIndex1145) )
            & ( v48177_31__array(VarNext,A,bitIndex0)
            <=> v50372(VarNext,bitIndex1144) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10527,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50366(VarNext)
      <=> ( v50367(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10526,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50367(VarNext)
      <=> ( v50369(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4426,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50369(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_51,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11001_address_term = A
              & v50357(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_30__array(VarNext,A,B)
              <=> v48177_29__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_51,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11001_address_term = A
            & v50357(VarNext) )
         => ( ( v48177_30__array(VarNext,A,bitIndex43)
            <=> v50363(VarNext,bitIndex1143) )
            & ( v48177_30__array(VarNext,A,bitIndex42)
            <=> v50363(VarNext,bitIndex1142) )
            & ( v48177_30__array(VarNext,A,bitIndex41)
            <=> v50363(VarNext,bitIndex1141) )
            & ( v48177_30__array(VarNext,A,bitIndex40)
            <=> v50363(VarNext,bitIndex1140) )
            & ( v48177_30__array(VarNext,A,bitIndex39)
            <=> v50363(VarNext,bitIndex1139) )
            & ( v48177_30__array(VarNext,A,bitIndex38)
            <=> v50363(VarNext,bitIndex1138) )
            & ( v48177_30__array(VarNext,A,bitIndex37)
            <=> v50363(VarNext,bitIndex1137) )
            & ( v48177_30__array(VarNext,A,bitIndex36)
            <=> v50363(VarNext,bitIndex1136) )
            & ( v48177_30__array(VarNext,A,bitIndex35)
            <=> v50363(VarNext,bitIndex1135) )
            & ( v48177_30__array(VarNext,A,bitIndex34)
            <=> v50363(VarNext,bitIndex1134) )
            & ( v48177_30__array(VarNext,A,bitIndex33)
            <=> v50363(VarNext,bitIndex1133) )
            & ( v48177_30__array(VarNext,A,bitIndex32)
            <=> v50363(VarNext,bitIndex1132) )
            & ( v48177_30__array(VarNext,A,bitIndex31)
            <=> v50363(VarNext,bitIndex1131) )
            & ( v48177_30__array(VarNext,A,bitIndex30)
            <=> v50363(VarNext,bitIndex1130) )
            & ( v48177_30__array(VarNext,A,bitIndex29)
            <=> v50363(VarNext,bitIndex1129) )
            & ( v48177_30__array(VarNext,A,bitIndex28)
            <=> v50363(VarNext,bitIndex1128) )
            & ( v48177_30__array(VarNext,A,bitIndex27)
            <=> v50363(VarNext,bitIndex1127) )
            & ( v48177_30__array(VarNext,A,bitIndex26)
            <=> v50363(VarNext,bitIndex1126) )
            & ( v48177_30__array(VarNext,A,bitIndex25)
            <=> v50363(VarNext,bitIndex1125) )
            & ( v48177_30__array(VarNext,A,bitIndex24)
            <=> v50363(VarNext,bitIndex1124) )
            & ( v48177_30__array(VarNext,A,bitIndex23)
            <=> v50363(VarNext,bitIndex1123) )
            & ( v48177_30__array(VarNext,A,bitIndex22)
            <=> v50363(VarNext,bitIndex1122) )
            & ( v48177_30__array(VarNext,A,bitIndex21)
            <=> v50363(VarNext,bitIndex1121) )
            & ( v48177_30__array(VarNext,A,bitIndex20)
            <=> v50363(VarNext,bitIndex1120) )
            & ( v48177_30__array(VarNext,A,bitIndex19)
            <=> v50363(VarNext,bitIndex1119) )
            & ( v48177_30__array(VarNext,A,bitIndex18)
            <=> v50363(VarNext,bitIndex1118) )
            & ( v48177_30__array(VarNext,A,bitIndex17)
            <=> v50363(VarNext,bitIndex1117) )
            & ( v48177_30__array(VarNext,A,bitIndex16)
            <=> v50363(VarNext,bitIndex1116) )
            & ( v48177_30__array(VarNext,A,bitIndex15)
            <=> v50363(VarNext,bitIndex1115) )
            & ( v48177_30__array(VarNext,A,bitIndex14)
            <=> v50363(VarNext,bitIndex1114) )
            & ( v48177_30__array(VarNext,A,bitIndex13)
            <=> v50363(VarNext,bitIndex1113) )
            & ( v48177_30__array(VarNext,A,bitIndex12)
            <=> v50363(VarNext,bitIndex1112) )
            & ( v48177_30__array(VarNext,A,bitIndex11)
            <=> v50363(VarNext,bitIndex1111) )
            & ( v48177_30__array(VarNext,A,bitIndex10)
            <=> v50363(VarNext,bitIndex1110) )
            & ( v48177_30__array(VarNext,A,bitIndex9)
            <=> v50363(VarNext,bitIndex1109) )
            & ( v48177_30__array(VarNext,A,bitIndex8)
            <=> v50363(VarNext,bitIndex1108) )
            & ( v48177_30__array(VarNext,A,bitIndex7)
            <=> v50363(VarNext,bitIndex1107) )
            & ( v48177_30__array(VarNext,A,bitIndex6)
            <=> v50363(VarNext,bitIndex1106) )
            & ( v48177_30__array(VarNext,A,bitIndex5)
            <=> v50363(VarNext,bitIndex1105) )
            & ( v48177_30__array(VarNext,A,bitIndex4)
            <=> v50363(VarNext,bitIndex1104) )
            & ( v48177_30__array(VarNext,A,bitIndex3)
            <=> v50363(VarNext,bitIndex1103) )
            & ( v48177_30__array(VarNext,A,bitIndex2)
            <=> v50363(VarNext,bitIndex1102) )
            & ( v48177_30__array(VarNext,A,bitIndex1)
            <=> v50363(VarNext,bitIndex1101) )
            & ( v48177_30__array(VarNext,A,bitIndex0)
            <=> v50363(VarNext,bitIndex1100) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10525,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50357(VarNext)
      <=> ( v50358(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10524,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50358(VarNext)
      <=> ( v50360(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4425,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50360(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_50,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b11000_address_term = A
              & v50348(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_29__array(VarNext,A,B)
              <=> v48177_28__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_50,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b11000_address_term = A
            & v50348(VarNext) )
         => ( ( v48177_29__array(VarNext,A,bitIndex43)
            <=> v50354(VarNext,bitIndex1099) )
            & ( v48177_29__array(VarNext,A,bitIndex42)
            <=> v50354(VarNext,bitIndex1098) )
            & ( v48177_29__array(VarNext,A,bitIndex41)
            <=> v50354(VarNext,bitIndex1097) )
            & ( v48177_29__array(VarNext,A,bitIndex40)
            <=> v50354(VarNext,bitIndex1096) )
            & ( v48177_29__array(VarNext,A,bitIndex39)
            <=> v50354(VarNext,bitIndex1095) )
            & ( v48177_29__array(VarNext,A,bitIndex38)
            <=> v50354(VarNext,bitIndex1094) )
            & ( v48177_29__array(VarNext,A,bitIndex37)
            <=> v50354(VarNext,bitIndex1093) )
            & ( v48177_29__array(VarNext,A,bitIndex36)
            <=> v50354(VarNext,bitIndex1092) )
            & ( v48177_29__array(VarNext,A,bitIndex35)
            <=> v50354(VarNext,bitIndex1091) )
            & ( v48177_29__array(VarNext,A,bitIndex34)
            <=> v50354(VarNext,bitIndex1090) )
            & ( v48177_29__array(VarNext,A,bitIndex33)
            <=> v50354(VarNext,bitIndex1089) )
            & ( v48177_29__array(VarNext,A,bitIndex32)
            <=> v50354(VarNext,bitIndex1088) )
            & ( v48177_29__array(VarNext,A,bitIndex31)
            <=> v50354(VarNext,bitIndex1087) )
            & ( v48177_29__array(VarNext,A,bitIndex30)
            <=> v50354(VarNext,bitIndex1086) )
            & ( v48177_29__array(VarNext,A,bitIndex29)
            <=> v50354(VarNext,bitIndex1085) )
            & ( v48177_29__array(VarNext,A,bitIndex28)
            <=> v50354(VarNext,bitIndex1084) )
            & ( v48177_29__array(VarNext,A,bitIndex27)
            <=> v50354(VarNext,bitIndex1083) )
            & ( v48177_29__array(VarNext,A,bitIndex26)
            <=> v50354(VarNext,bitIndex1082) )
            & ( v48177_29__array(VarNext,A,bitIndex25)
            <=> v50354(VarNext,bitIndex1081) )
            & ( v48177_29__array(VarNext,A,bitIndex24)
            <=> v50354(VarNext,bitIndex1080) )
            & ( v48177_29__array(VarNext,A,bitIndex23)
            <=> v50354(VarNext,bitIndex1079) )
            & ( v48177_29__array(VarNext,A,bitIndex22)
            <=> v50354(VarNext,bitIndex1078) )
            & ( v48177_29__array(VarNext,A,bitIndex21)
            <=> v50354(VarNext,bitIndex1077) )
            & ( v48177_29__array(VarNext,A,bitIndex20)
            <=> v50354(VarNext,bitIndex1076) )
            & ( v48177_29__array(VarNext,A,bitIndex19)
            <=> v50354(VarNext,bitIndex1075) )
            & ( v48177_29__array(VarNext,A,bitIndex18)
            <=> v50354(VarNext,bitIndex1074) )
            & ( v48177_29__array(VarNext,A,bitIndex17)
            <=> v50354(VarNext,bitIndex1073) )
            & ( v48177_29__array(VarNext,A,bitIndex16)
            <=> v50354(VarNext,bitIndex1072) )
            & ( v48177_29__array(VarNext,A,bitIndex15)
            <=> v50354(VarNext,bitIndex1071) )
            & ( v48177_29__array(VarNext,A,bitIndex14)
            <=> v50354(VarNext,bitIndex1070) )
            & ( v48177_29__array(VarNext,A,bitIndex13)
            <=> v50354(VarNext,bitIndex1069) )
            & ( v48177_29__array(VarNext,A,bitIndex12)
            <=> v50354(VarNext,bitIndex1068) )
            & ( v48177_29__array(VarNext,A,bitIndex11)
            <=> v50354(VarNext,bitIndex1067) )
            & ( v48177_29__array(VarNext,A,bitIndex10)
            <=> v50354(VarNext,bitIndex1066) )
            & ( v48177_29__array(VarNext,A,bitIndex9)
            <=> v50354(VarNext,bitIndex1065) )
            & ( v48177_29__array(VarNext,A,bitIndex8)
            <=> v50354(VarNext,bitIndex1064) )
            & ( v48177_29__array(VarNext,A,bitIndex7)
            <=> v50354(VarNext,bitIndex1063) )
            & ( v48177_29__array(VarNext,A,bitIndex6)
            <=> v50354(VarNext,bitIndex1062) )
            & ( v48177_29__array(VarNext,A,bitIndex5)
            <=> v50354(VarNext,bitIndex1061) )
            & ( v48177_29__array(VarNext,A,bitIndex4)
            <=> v50354(VarNext,bitIndex1060) )
            & ( v48177_29__array(VarNext,A,bitIndex3)
            <=> v50354(VarNext,bitIndex1059) )
            & ( v48177_29__array(VarNext,A,bitIndex2)
            <=> v50354(VarNext,bitIndex1058) )
            & ( v48177_29__array(VarNext,A,bitIndex1)
            <=> v50354(VarNext,bitIndex1057) )
            & ( v48177_29__array(VarNext,A,bitIndex0)
            <=> v50354(VarNext,bitIndex1056) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10523,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50348(VarNext)
      <=> ( v50349(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10522,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50349(VarNext)
      <=> ( v50351(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4424,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50351(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_49,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10111_address_term = A
              & v50339(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_28__array(VarNext,A,B)
              <=> v48177_27__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_49,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10111_address_term = A
            & v50339(VarNext) )
         => ( ( v48177_28__array(VarNext,A,bitIndex43)
            <=> v50345(VarNext,bitIndex1055) )
            & ( v48177_28__array(VarNext,A,bitIndex42)
            <=> v50345(VarNext,bitIndex1054) )
            & ( v48177_28__array(VarNext,A,bitIndex41)
            <=> v50345(VarNext,bitIndex1053) )
            & ( v48177_28__array(VarNext,A,bitIndex40)
            <=> v50345(VarNext,bitIndex1052) )
            & ( v48177_28__array(VarNext,A,bitIndex39)
            <=> v50345(VarNext,bitIndex1051) )
            & ( v48177_28__array(VarNext,A,bitIndex38)
            <=> v50345(VarNext,bitIndex1050) )
            & ( v48177_28__array(VarNext,A,bitIndex37)
            <=> v50345(VarNext,bitIndex1049) )
            & ( v48177_28__array(VarNext,A,bitIndex36)
            <=> v50345(VarNext,bitIndex1048) )
            & ( v48177_28__array(VarNext,A,bitIndex35)
            <=> v50345(VarNext,bitIndex1047) )
            & ( v48177_28__array(VarNext,A,bitIndex34)
            <=> v50345(VarNext,bitIndex1046) )
            & ( v48177_28__array(VarNext,A,bitIndex33)
            <=> v50345(VarNext,bitIndex1045) )
            & ( v48177_28__array(VarNext,A,bitIndex32)
            <=> v50345(VarNext,bitIndex1044) )
            & ( v48177_28__array(VarNext,A,bitIndex31)
            <=> v50345(VarNext,bitIndex1043) )
            & ( v48177_28__array(VarNext,A,bitIndex30)
            <=> v50345(VarNext,bitIndex1042) )
            & ( v48177_28__array(VarNext,A,bitIndex29)
            <=> v50345(VarNext,bitIndex1041) )
            & ( v48177_28__array(VarNext,A,bitIndex28)
            <=> v50345(VarNext,bitIndex1040) )
            & ( v48177_28__array(VarNext,A,bitIndex27)
            <=> v50345(VarNext,bitIndex1039) )
            & ( v48177_28__array(VarNext,A,bitIndex26)
            <=> v50345(VarNext,bitIndex1038) )
            & ( v48177_28__array(VarNext,A,bitIndex25)
            <=> v50345(VarNext,bitIndex1037) )
            & ( v48177_28__array(VarNext,A,bitIndex24)
            <=> v50345(VarNext,bitIndex1036) )
            & ( v48177_28__array(VarNext,A,bitIndex23)
            <=> v50345(VarNext,bitIndex1035) )
            & ( v48177_28__array(VarNext,A,bitIndex22)
            <=> v50345(VarNext,bitIndex1034) )
            & ( v48177_28__array(VarNext,A,bitIndex21)
            <=> v50345(VarNext,bitIndex1033) )
            & ( v48177_28__array(VarNext,A,bitIndex20)
            <=> v50345(VarNext,bitIndex1032) )
            & ( v48177_28__array(VarNext,A,bitIndex19)
            <=> v50345(VarNext,bitIndex1031) )
            & ( v48177_28__array(VarNext,A,bitIndex18)
            <=> v50345(VarNext,bitIndex1030) )
            & ( v48177_28__array(VarNext,A,bitIndex17)
            <=> v50345(VarNext,bitIndex1029) )
            & ( v48177_28__array(VarNext,A,bitIndex16)
            <=> v50345(VarNext,bitIndex1028) )
            & ( v48177_28__array(VarNext,A,bitIndex15)
            <=> v50345(VarNext,bitIndex1027) )
            & ( v48177_28__array(VarNext,A,bitIndex14)
            <=> v50345(VarNext,bitIndex1026) )
            & ( v48177_28__array(VarNext,A,bitIndex13)
            <=> v50345(VarNext,bitIndex1025) )
            & ( v48177_28__array(VarNext,A,bitIndex12)
            <=> v50345(VarNext,bitIndex1024) )
            & ( v48177_28__array(VarNext,A,bitIndex11)
            <=> v50345(VarNext,bitIndex1023) )
            & ( v48177_28__array(VarNext,A,bitIndex10)
            <=> v50345(VarNext,bitIndex1022) )
            & ( v48177_28__array(VarNext,A,bitIndex9)
            <=> v50345(VarNext,bitIndex1021) )
            & ( v48177_28__array(VarNext,A,bitIndex8)
            <=> v50345(VarNext,bitIndex1020) )
            & ( v48177_28__array(VarNext,A,bitIndex7)
            <=> v50345(VarNext,bitIndex1019) )
            & ( v48177_28__array(VarNext,A,bitIndex6)
            <=> v50345(VarNext,bitIndex1018) )
            & ( v48177_28__array(VarNext,A,bitIndex5)
            <=> v50345(VarNext,bitIndex1017) )
            & ( v48177_28__array(VarNext,A,bitIndex4)
            <=> v50345(VarNext,bitIndex1016) )
            & ( v48177_28__array(VarNext,A,bitIndex3)
            <=> v50345(VarNext,bitIndex1015) )
            & ( v48177_28__array(VarNext,A,bitIndex2)
            <=> v50345(VarNext,bitIndex1014) )
            & ( v48177_28__array(VarNext,A,bitIndex1)
            <=> v50345(VarNext,bitIndex1013) )
            & ( v48177_28__array(VarNext,A,bitIndex0)
            <=> v50345(VarNext,bitIndex1012) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10521,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50339(VarNext)
      <=> ( v50340(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10520,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50340(VarNext)
      <=> ( v50342(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4423,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50342(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_48,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10110_address_term = A
              & v50330(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_27__array(VarNext,A,B)
              <=> v48177_26__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_48,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10110_address_term = A
            & v50330(VarNext) )
         => ( ( v48177_27__array(VarNext,A,bitIndex43)
            <=> v50336(VarNext,bitIndex1011) )
            & ( v48177_27__array(VarNext,A,bitIndex42)
            <=> v50336(VarNext,bitIndex1010) )
            & ( v48177_27__array(VarNext,A,bitIndex41)
            <=> v50336(VarNext,bitIndex1009) )
            & ( v48177_27__array(VarNext,A,bitIndex40)
            <=> v50336(VarNext,bitIndex1008) )
            & ( v48177_27__array(VarNext,A,bitIndex39)
            <=> v50336(VarNext,bitIndex1007) )
            & ( v48177_27__array(VarNext,A,bitIndex38)
            <=> v50336(VarNext,bitIndex1006) )
            & ( v48177_27__array(VarNext,A,bitIndex37)
            <=> v50336(VarNext,bitIndex1005) )
            & ( v48177_27__array(VarNext,A,bitIndex36)
            <=> v50336(VarNext,bitIndex1004) )
            & ( v48177_27__array(VarNext,A,bitIndex35)
            <=> v50336(VarNext,bitIndex1003) )
            & ( v48177_27__array(VarNext,A,bitIndex34)
            <=> v50336(VarNext,bitIndex1002) )
            & ( v48177_27__array(VarNext,A,bitIndex33)
            <=> v50336(VarNext,bitIndex1001) )
            & ( v48177_27__array(VarNext,A,bitIndex32)
            <=> v50336(VarNext,bitIndex1000) )
            & ( v48177_27__array(VarNext,A,bitIndex31)
            <=> v50336(VarNext,bitIndex999) )
            & ( v48177_27__array(VarNext,A,bitIndex30)
            <=> v50336(VarNext,bitIndex998) )
            & ( v48177_27__array(VarNext,A,bitIndex29)
            <=> v50336(VarNext,bitIndex997) )
            & ( v48177_27__array(VarNext,A,bitIndex28)
            <=> v50336(VarNext,bitIndex996) )
            & ( v48177_27__array(VarNext,A,bitIndex27)
            <=> v50336(VarNext,bitIndex995) )
            & ( v48177_27__array(VarNext,A,bitIndex26)
            <=> v50336(VarNext,bitIndex994) )
            & ( v48177_27__array(VarNext,A,bitIndex25)
            <=> v50336(VarNext,bitIndex993) )
            & ( v48177_27__array(VarNext,A,bitIndex24)
            <=> v50336(VarNext,bitIndex992) )
            & ( v48177_27__array(VarNext,A,bitIndex23)
            <=> v50336(VarNext,bitIndex991) )
            & ( v48177_27__array(VarNext,A,bitIndex22)
            <=> v50336(VarNext,bitIndex990) )
            & ( v48177_27__array(VarNext,A,bitIndex21)
            <=> v50336(VarNext,bitIndex989) )
            & ( v48177_27__array(VarNext,A,bitIndex20)
            <=> v50336(VarNext,bitIndex988) )
            & ( v48177_27__array(VarNext,A,bitIndex19)
            <=> v50336(VarNext,bitIndex987) )
            & ( v48177_27__array(VarNext,A,bitIndex18)
            <=> v50336(VarNext,bitIndex986) )
            & ( v48177_27__array(VarNext,A,bitIndex17)
            <=> v50336(VarNext,bitIndex985) )
            & ( v48177_27__array(VarNext,A,bitIndex16)
            <=> v50336(VarNext,bitIndex984) )
            & ( v48177_27__array(VarNext,A,bitIndex15)
            <=> v50336(VarNext,bitIndex983) )
            & ( v48177_27__array(VarNext,A,bitIndex14)
            <=> v50336(VarNext,bitIndex982) )
            & ( v48177_27__array(VarNext,A,bitIndex13)
            <=> v50336(VarNext,bitIndex981) )
            & ( v48177_27__array(VarNext,A,bitIndex12)
            <=> v50336(VarNext,bitIndex980) )
            & ( v48177_27__array(VarNext,A,bitIndex11)
            <=> v50336(VarNext,bitIndex979) )
            & ( v48177_27__array(VarNext,A,bitIndex10)
            <=> v50336(VarNext,bitIndex978) )
            & ( v48177_27__array(VarNext,A,bitIndex9)
            <=> v50336(VarNext,bitIndex977) )
            & ( v48177_27__array(VarNext,A,bitIndex8)
            <=> v50336(VarNext,bitIndex976) )
            & ( v48177_27__array(VarNext,A,bitIndex7)
            <=> v50336(VarNext,bitIndex975) )
            & ( v48177_27__array(VarNext,A,bitIndex6)
            <=> v50336(VarNext,bitIndex974) )
            & ( v48177_27__array(VarNext,A,bitIndex5)
            <=> v50336(VarNext,bitIndex973) )
            & ( v48177_27__array(VarNext,A,bitIndex4)
            <=> v50336(VarNext,bitIndex972) )
            & ( v48177_27__array(VarNext,A,bitIndex3)
            <=> v50336(VarNext,bitIndex971) )
            & ( v48177_27__array(VarNext,A,bitIndex2)
            <=> v50336(VarNext,bitIndex970) )
            & ( v48177_27__array(VarNext,A,bitIndex1)
            <=> v50336(VarNext,bitIndex969) )
            & ( v48177_27__array(VarNext,A,bitIndex0)
            <=> v50336(VarNext,bitIndex968) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10519,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50330(VarNext)
      <=> ( v50331(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10518,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50331(VarNext)
      <=> ( v50333(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4422,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50333(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_47,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10101_address_term = A
              & v50321(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_26__array(VarNext,A,B)
              <=> v48177_25__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_47,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10101_address_term = A
            & v50321(VarNext) )
         => ( ( v48177_26__array(VarNext,A,bitIndex43)
            <=> v50327(VarNext,bitIndex967) )
            & ( v48177_26__array(VarNext,A,bitIndex42)
            <=> v50327(VarNext,bitIndex966) )
            & ( v48177_26__array(VarNext,A,bitIndex41)
            <=> v50327(VarNext,bitIndex965) )
            & ( v48177_26__array(VarNext,A,bitIndex40)
            <=> v50327(VarNext,bitIndex964) )
            & ( v48177_26__array(VarNext,A,bitIndex39)
            <=> v50327(VarNext,bitIndex963) )
            & ( v48177_26__array(VarNext,A,bitIndex38)
            <=> v50327(VarNext,bitIndex962) )
            & ( v48177_26__array(VarNext,A,bitIndex37)
            <=> v50327(VarNext,bitIndex961) )
            & ( v48177_26__array(VarNext,A,bitIndex36)
            <=> v50327(VarNext,bitIndex960) )
            & ( v48177_26__array(VarNext,A,bitIndex35)
            <=> v50327(VarNext,bitIndex959) )
            & ( v48177_26__array(VarNext,A,bitIndex34)
            <=> v50327(VarNext,bitIndex958) )
            & ( v48177_26__array(VarNext,A,bitIndex33)
            <=> v50327(VarNext,bitIndex957) )
            & ( v48177_26__array(VarNext,A,bitIndex32)
            <=> v50327(VarNext,bitIndex956) )
            & ( v48177_26__array(VarNext,A,bitIndex31)
            <=> v50327(VarNext,bitIndex955) )
            & ( v48177_26__array(VarNext,A,bitIndex30)
            <=> v50327(VarNext,bitIndex954) )
            & ( v48177_26__array(VarNext,A,bitIndex29)
            <=> v50327(VarNext,bitIndex953) )
            & ( v48177_26__array(VarNext,A,bitIndex28)
            <=> v50327(VarNext,bitIndex952) )
            & ( v48177_26__array(VarNext,A,bitIndex27)
            <=> v50327(VarNext,bitIndex951) )
            & ( v48177_26__array(VarNext,A,bitIndex26)
            <=> v50327(VarNext,bitIndex950) )
            & ( v48177_26__array(VarNext,A,bitIndex25)
            <=> v50327(VarNext,bitIndex949) )
            & ( v48177_26__array(VarNext,A,bitIndex24)
            <=> v50327(VarNext,bitIndex948) )
            & ( v48177_26__array(VarNext,A,bitIndex23)
            <=> v50327(VarNext,bitIndex947) )
            & ( v48177_26__array(VarNext,A,bitIndex22)
            <=> v50327(VarNext,bitIndex946) )
            & ( v48177_26__array(VarNext,A,bitIndex21)
            <=> v50327(VarNext,bitIndex945) )
            & ( v48177_26__array(VarNext,A,bitIndex20)
            <=> v50327(VarNext,bitIndex944) )
            & ( v48177_26__array(VarNext,A,bitIndex19)
            <=> v50327(VarNext,bitIndex943) )
            & ( v48177_26__array(VarNext,A,bitIndex18)
            <=> v50327(VarNext,bitIndex942) )
            & ( v48177_26__array(VarNext,A,bitIndex17)
            <=> v50327(VarNext,bitIndex941) )
            & ( v48177_26__array(VarNext,A,bitIndex16)
            <=> v50327(VarNext,bitIndex940) )
            & ( v48177_26__array(VarNext,A,bitIndex15)
            <=> v50327(VarNext,bitIndex939) )
            & ( v48177_26__array(VarNext,A,bitIndex14)
            <=> v50327(VarNext,bitIndex938) )
            & ( v48177_26__array(VarNext,A,bitIndex13)
            <=> v50327(VarNext,bitIndex937) )
            & ( v48177_26__array(VarNext,A,bitIndex12)
            <=> v50327(VarNext,bitIndex936) )
            & ( v48177_26__array(VarNext,A,bitIndex11)
            <=> v50327(VarNext,bitIndex935) )
            & ( v48177_26__array(VarNext,A,bitIndex10)
            <=> v50327(VarNext,bitIndex934) )
            & ( v48177_26__array(VarNext,A,bitIndex9)
            <=> v50327(VarNext,bitIndex933) )
            & ( v48177_26__array(VarNext,A,bitIndex8)
            <=> v50327(VarNext,bitIndex932) )
            & ( v48177_26__array(VarNext,A,bitIndex7)
            <=> v50327(VarNext,bitIndex931) )
            & ( v48177_26__array(VarNext,A,bitIndex6)
            <=> v50327(VarNext,bitIndex930) )
            & ( v48177_26__array(VarNext,A,bitIndex5)
            <=> v50327(VarNext,bitIndex929) )
            & ( v48177_26__array(VarNext,A,bitIndex4)
            <=> v50327(VarNext,bitIndex928) )
            & ( v48177_26__array(VarNext,A,bitIndex3)
            <=> v50327(VarNext,bitIndex927) )
            & ( v48177_26__array(VarNext,A,bitIndex2)
            <=> v50327(VarNext,bitIndex926) )
            & ( v48177_26__array(VarNext,A,bitIndex1)
            <=> v50327(VarNext,bitIndex925) )
            & ( v48177_26__array(VarNext,A,bitIndex0)
            <=> v50327(VarNext,bitIndex924) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10517,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50321(VarNext)
      <=> ( v50322(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10516,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50322(VarNext)
      <=> ( v50324(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4421,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50324(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_46,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10100_address_term = A
              & v50312(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_25__array(VarNext,A,B)
              <=> v48177_24__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_46,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10100_address_term = A
            & v50312(VarNext) )
         => ( ( v48177_25__array(VarNext,A,bitIndex43)
            <=> v50318(VarNext,bitIndex923) )
            & ( v48177_25__array(VarNext,A,bitIndex42)
            <=> v50318(VarNext,bitIndex922) )
            & ( v48177_25__array(VarNext,A,bitIndex41)
            <=> v50318(VarNext,bitIndex921) )
            & ( v48177_25__array(VarNext,A,bitIndex40)
            <=> v50318(VarNext,bitIndex920) )
            & ( v48177_25__array(VarNext,A,bitIndex39)
            <=> v50318(VarNext,bitIndex919) )
            & ( v48177_25__array(VarNext,A,bitIndex38)
            <=> v50318(VarNext,bitIndex918) )
            & ( v48177_25__array(VarNext,A,bitIndex37)
            <=> v50318(VarNext,bitIndex917) )
            & ( v48177_25__array(VarNext,A,bitIndex36)
            <=> v50318(VarNext,bitIndex916) )
            & ( v48177_25__array(VarNext,A,bitIndex35)
            <=> v50318(VarNext,bitIndex915) )
            & ( v48177_25__array(VarNext,A,bitIndex34)
            <=> v50318(VarNext,bitIndex914) )
            & ( v48177_25__array(VarNext,A,bitIndex33)
            <=> v50318(VarNext,bitIndex913) )
            & ( v48177_25__array(VarNext,A,bitIndex32)
            <=> v50318(VarNext,bitIndex912) )
            & ( v48177_25__array(VarNext,A,bitIndex31)
            <=> v50318(VarNext,bitIndex911) )
            & ( v48177_25__array(VarNext,A,bitIndex30)
            <=> v50318(VarNext,bitIndex910) )
            & ( v48177_25__array(VarNext,A,bitIndex29)
            <=> v50318(VarNext,bitIndex909) )
            & ( v48177_25__array(VarNext,A,bitIndex28)
            <=> v50318(VarNext,bitIndex908) )
            & ( v48177_25__array(VarNext,A,bitIndex27)
            <=> v50318(VarNext,bitIndex907) )
            & ( v48177_25__array(VarNext,A,bitIndex26)
            <=> v50318(VarNext,bitIndex906) )
            & ( v48177_25__array(VarNext,A,bitIndex25)
            <=> v50318(VarNext,bitIndex905) )
            & ( v48177_25__array(VarNext,A,bitIndex24)
            <=> v50318(VarNext,bitIndex904) )
            & ( v48177_25__array(VarNext,A,bitIndex23)
            <=> v50318(VarNext,bitIndex903) )
            & ( v48177_25__array(VarNext,A,bitIndex22)
            <=> v50318(VarNext,bitIndex902) )
            & ( v48177_25__array(VarNext,A,bitIndex21)
            <=> v50318(VarNext,bitIndex901) )
            & ( v48177_25__array(VarNext,A,bitIndex20)
            <=> v50318(VarNext,bitIndex900) )
            & ( v48177_25__array(VarNext,A,bitIndex19)
            <=> v50318(VarNext,bitIndex899) )
            & ( v48177_25__array(VarNext,A,bitIndex18)
            <=> v50318(VarNext,bitIndex898) )
            & ( v48177_25__array(VarNext,A,bitIndex17)
            <=> v50318(VarNext,bitIndex897) )
            & ( v48177_25__array(VarNext,A,bitIndex16)
            <=> v50318(VarNext,bitIndex896) )
            & ( v48177_25__array(VarNext,A,bitIndex15)
            <=> v50318(VarNext,bitIndex895) )
            & ( v48177_25__array(VarNext,A,bitIndex14)
            <=> v50318(VarNext,bitIndex894) )
            & ( v48177_25__array(VarNext,A,bitIndex13)
            <=> v50318(VarNext,bitIndex893) )
            & ( v48177_25__array(VarNext,A,bitIndex12)
            <=> v50318(VarNext,bitIndex892) )
            & ( v48177_25__array(VarNext,A,bitIndex11)
            <=> v50318(VarNext,bitIndex891) )
            & ( v48177_25__array(VarNext,A,bitIndex10)
            <=> v50318(VarNext,bitIndex890) )
            & ( v48177_25__array(VarNext,A,bitIndex9)
            <=> v50318(VarNext,bitIndex889) )
            & ( v48177_25__array(VarNext,A,bitIndex8)
            <=> v50318(VarNext,bitIndex888) )
            & ( v48177_25__array(VarNext,A,bitIndex7)
            <=> v50318(VarNext,bitIndex887) )
            & ( v48177_25__array(VarNext,A,bitIndex6)
            <=> v50318(VarNext,bitIndex886) )
            & ( v48177_25__array(VarNext,A,bitIndex5)
            <=> v50318(VarNext,bitIndex885) )
            & ( v48177_25__array(VarNext,A,bitIndex4)
            <=> v50318(VarNext,bitIndex884) )
            & ( v48177_25__array(VarNext,A,bitIndex3)
            <=> v50318(VarNext,bitIndex883) )
            & ( v48177_25__array(VarNext,A,bitIndex2)
            <=> v50318(VarNext,bitIndex882) )
            & ( v48177_25__array(VarNext,A,bitIndex1)
            <=> v50318(VarNext,bitIndex881) )
            & ( v48177_25__array(VarNext,A,bitIndex0)
            <=> v50318(VarNext,bitIndex880) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10515,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50312(VarNext)
      <=> ( v50313(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10514,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50313(VarNext)
      <=> ( v50315(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4420,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50315(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_45,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10011_address_term = A
              & v50303(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_24__array(VarNext,A,B)
              <=> v48177_23__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_45,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10011_address_term = A
            & v50303(VarNext) )
         => ( ( v48177_24__array(VarNext,A,bitIndex43)
            <=> v50309(VarNext,bitIndex879) )
            & ( v48177_24__array(VarNext,A,bitIndex42)
            <=> v50309(VarNext,bitIndex878) )
            & ( v48177_24__array(VarNext,A,bitIndex41)
            <=> v50309(VarNext,bitIndex877) )
            & ( v48177_24__array(VarNext,A,bitIndex40)
            <=> v50309(VarNext,bitIndex876) )
            & ( v48177_24__array(VarNext,A,bitIndex39)
            <=> v50309(VarNext,bitIndex875) )
            & ( v48177_24__array(VarNext,A,bitIndex38)
            <=> v50309(VarNext,bitIndex874) )
            & ( v48177_24__array(VarNext,A,bitIndex37)
            <=> v50309(VarNext,bitIndex873) )
            & ( v48177_24__array(VarNext,A,bitIndex36)
            <=> v50309(VarNext,bitIndex872) )
            & ( v48177_24__array(VarNext,A,bitIndex35)
            <=> v50309(VarNext,bitIndex871) )
            & ( v48177_24__array(VarNext,A,bitIndex34)
            <=> v50309(VarNext,bitIndex870) )
            & ( v48177_24__array(VarNext,A,bitIndex33)
            <=> v50309(VarNext,bitIndex869) )
            & ( v48177_24__array(VarNext,A,bitIndex32)
            <=> v50309(VarNext,bitIndex868) )
            & ( v48177_24__array(VarNext,A,bitIndex31)
            <=> v50309(VarNext,bitIndex867) )
            & ( v48177_24__array(VarNext,A,bitIndex30)
            <=> v50309(VarNext,bitIndex866) )
            & ( v48177_24__array(VarNext,A,bitIndex29)
            <=> v50309(VarNext,bitIndex865) )
            & ( v48177_24__array(VarNext,A,bitIndex28)
            <=> v50309(VarNext,bitIndex864) )
            & ( v48177_24__array(VarNext,A,bitIndex27)
            <=> v50309(VarNext,bitIndex863) )
            & ( v48177_24__array(VarNext,A,bitIndex26)
            <=> v50309(VarNext,bitIndex862) )
            & ( v48177_24__array(VarNext,A,bitIndex25)
            <=> v50309(VarNext,bitIndex861) )
            & ( v48177_24__array(VarNext,A,bitIndex24)
            <=> v50309(VarNext,bitIndex860) )
            & ( v48177_24__array(VarNext,A,bitIndex23)
            <=> v50309(VarNext,bitIndex859) )
            & ( v48177_24__array(VarNext,A,bitIndex22)
            <=> v50309(VarNext,bitIndex858) )
            & ( v48177_24__array(VarNext,A,bitIndex21)
            <=> v50309(VarNext,bitIndex857) )
            & ( v48177_24__array(VarNext,A,bitIndex20)
            <=> v50309(VarNext,bitIndex856) )
            & ( v48177_24__array(VarNext,A,bitIndex19)
            <=> v50309(VarNext,bitIndex855) )
            & ( v48177_24__array(VarNext,A,bitIndex18)
            <=> v50309(VarNext,bitIndex854) )
            & ( v48177_24__array(VarNext,A,bitIndex17)
            <=> v50309(VarNext,bitIndex853) )
            & ( v48177_24__array(VarNext,A,bitIndex16)
            <=> v50309(VarNext,bitIndex852) )
            & ( v48177_24__array(VarNext,A,bitIndex15)
            <=> v50309(VarNext,bitIndex851) )
            & ( v48177_24__array(VarNext,A,bitIndex14)
            <=> v50309(VarNext,bitIndex850) )
            & ( v48177_24__array(VarNext,A,bitIndex13)
            <=> v50309(VarNext,bitIndex849) )
            & ( v48177_24__array(VarNext,A,bitIndex12)
            <=> v50309(VarNext,bitIndex848) )
            & ( v48177_24__array(VarNext,A,bitIndex11)
            <=> v50309(VarNext,bitIndex847) )
            & ( v48177_24__array(VarNext,A,bitIndex10)
            <=> v50309(VarNext,bitIndex846) )
            & ( v48177_24__array(VarNext,A,bitIndex9)
            <=> v50309(VarNext,bitIndex845) )
            & ( v48177_24__array(VarNext,A,bitIndex8)
            <=> v50309(VarNext,bitIndex844) )
            & ( v48177_24__array(VarNext,A,bitIndex7)
            <=> v50309(VarNext,bitIndex843) )
            & ( v48177_24__array(VarNext,A,bitIndex6)
            <=> v50309(VarNext,bitIndex842) )
            & ( v48177_24__array(VarNext,A,bitIndex5)
            <=> v50309(VarNext,bitIndex841) )
            & ( v48177_24__array(VarNext,A,bitIndex4)
            <=> v50309(VarNext,bitIndex840) )
            & ( v48177_24__array(VarNext,A,bitIndex3)
            <=> v50309(VarNext,bitIndex839) )
            & ( v48177_24__array(VarNext,A,bitIndex2)
            <=> v50309(VarNext,bitIndex838) )
            & ( v48177_24__array(VarNext,A,bitIndex1)
            <=> v50309(VarNext,bitIndex837) )
            & ( v48177_24__array(VarNext,A,bitIndex0)
            <=> v50309(VarNext,bitIndex836) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10513,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50303(VarNext)
      <=> ( v50304(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10512,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50304(VarNext)
      <=> ( v50306(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4419,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50306(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_44,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10010_address_term = A
              & v50294(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_23__array(VarNext,A,B)
              <=> v48177_22__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_44,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10010_address_term = A
            & v50294(VarNext) )
         => ( ( v48177_23__array(VarNext,A,bitIndex43)
            <=> v50300(VarNext,bitIndex835) )
            & ( v48177_23__array(VarNext,A,bitIndex42)
            <=> v50300(VarNext,bitIndex834) )
            & ( v48177_23__array(VarNext,A,bitIndex41)
            <=> v50300(VarNext,bitIndex833) )
            & ( v48177_23__array(VarNext,A,bitIndex40)
            <=> v50300(VarNext,bitIndex832) )
            & ( v48177_23__array(VarNext,A,bitIndex39)
            <=> v50300(VarNext,bitIndex831) )
            & ( v48177_23__array(VarNext,A,bitIndex38)
            <=> v50300(VarNext,bitIndex830) )
            & ( v48177_23__array(VarNext,A,bitIndex37)
            <=> v50300(VarNext,bitIndex829) )
            & ( v48177_23__array(VarNext,A,bitIndex36)
            <=> v50300(VarNext,bitIndex828) )
            & ( v48177_23__array(VarNext,A,bitIndex35)
            <=> v50300(VarNext,bitIndex827) )
            & ( v48177_23__array(VarNext,A,bitIndex34)
            <=> v50300(VarNext,bitIndex826) )
            & ( v48177_23__array(VarNext,A,bitIndex33)
            <=> v50300(VarNext,bitIndex825) )
            & ( v48177_23__array(VarNext,A,bitIndex32)
            <=> v50300(VarNext,bitIndex824) )
            & ( v48177_23__array(VarNext,A,bitIndex31)
            <=> v50300(VarNext,bitIndex823) )
            & ( v48177_23__array(VarNext,A,bitIndex30)
            <=> v50300(VarNext,bitIndex822) )
            & ( v48177_23__array(VarNext,A,bitIndex29)
            <=> v50300(VarNext,bitIndex821) )
            & ( v48177_23__array(VarNext,A,bitIndex28)
            <=> v50300(VarNext,bitIndex820) )
            & ( v48177_23__array(VarNext,A,bitIndex27)
            <=> v50300(VarNext,bitIndex819) )
            & ( v48177_23__array(VarNext,A,bitIndex26)
            <=> v50300(VarNext,bitIndex818) )
            & ( v48177_23__array(VarNext,A,bitIndex25)
            <=> v50300(VarNext,bitIndex817) )
            & ( v48177_23__array(VarNext,A,bitIndex24)
            <=> v50300(VarNext,bitIndex816) )
            & ( v48177_23__array(VarNext,A,bitIndex23)
            <=> v50300(VarNext,bitIndex815) )
            & ( v48177_23__array(VarNext,A,bitIndex22)
            <=> v50300(VarNext,bitIndex814) )
            & ( v48177_23__array(VarNext,A,bitIndex21)
            <=> v50300(VarNext,bitIndex813) )
            & ( v48177_23__array(VarNext,A,bitIndex20)
            <=> v50300(VarNext,bitIndex812) )
            & ( v48177_23__array(VarNext,A,bitIndex19)
            <=> v50300(VarNext,bitIndex811) )
            & ( v48177_23__array(VarNext,A,bitIndex18)
            <=> v50300(VarNext,bitIndex810) )
            & ( v48177_23__array(VarNext,A,bitIndex17)
            <=> v50300(VarNext,bitIndex809) )
            & ( v48177_23__array(VarNext,A,bitIndex16)
            <=> v50300(VarNext,bitIndex808) )
            & ( v48177_23__array(VarNext,A,bitIndex15)
            <=> v50300(VarNext,bitIndex807) )
            & ( v48177_23__array(VarNext,A,bitIndex14)
            <=> v50300(VarNext,bitIndex806) )
            & ( v48177_23__array(VarNext,A,bitIndex13)
            <=> v50300(VarNext,bitIndex805) )
            & ( v48177_23__array(VarNext,A,bitIndex12)
            <=> v50300(VarNext,bitIndex804) )
            & ( v48177_23__array(VarNext,A,bitIndex11)
            <=> v50300(VarNext,bitIndex803) )
            & ( v48177_23__array(VarNext,A,bitIndex10)
            <=> v50300(VarNext,bitIndex802) )
            & ( v48177_23__array(VarNext,A,bitIndex9)
            <=> v50300(VarNext,bitIndex801) )
            & ( v48177_23__array(VarNext,A,bitIndex8)
            <=> v50300(VarNext,bitIndex800) )
            & ( v48177_23__array(VarNext,A,bitIndex7)
            <=> v50300(VarNext,bitIndex799) )
            & ( v48177_23__array(VarNext,A,bitIndex6)
            <=> v50300(VarNext,bitIndex798) )
            & ( v48177_23__array(VarNext,A,bitIndex5)
            <=> v50300(VarNext,bitIndex797) )
            & ( v48177_23__array(VarNext,A,bitIndex4)
            <=> v50300(VarNext,bitIndex796) )
            & ( v48177_23__array(VarNext,A,bitIndex3)
            <=> v50300(VarNext,bitIndex795) )
            & ( v48177_23__array(VarNext,A,bitIndex2)
            <=> v50300(VarNext,bitIndex794) )
            & ( v48177_23__array(VarNext,A,bitIndex1)
            <=> v50300(VarNext,bitIndex793) )
            & ( v48177_23__array(VarNext,A,bitIndex0)
            <=> v50300(VarNext,bitIndex792) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10511,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50294(VarNext)
      <=> ( v50295(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10510,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50295(VarNext)
      <=> ( v50297(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4418,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50297(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_43,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10001_address_term = A
              & v50285(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_22__array(VarNext,A,B)
              <=> v48177_21__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_43,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10001_address_term = A
            & v50285(VarNext) )
         => ( ( v48177_22__array(VarNext,A,bitIndex43)
            <=> v50291(VarNext,bitIndex791) )
            & ( v48177_22__array(VarNext,A,bitIndex42)
            <=> v50291(VarNext,bitIndex790) )
            & ( v48177_22__array(VarNext,A,bitIndex41)
            <=> v50291(VarNext,bitIndex789) )
            & ( v48177_22__array(VarNext,A,bitIndex40)
            <=> v50291(VarNext,bitIndex788) )
            & ( v48177_22__array(VarNext,A,bitIndex39)
            <=> v50291(VarNext,bitIndex787) )
            & ( v48177_22__array(VarNext,A,bitIndex38)
            <=> v50291(VarNext,bitIndex786) )
            & ( v48177_22__array(VarNext,A,bitIndex37)
            <=> v50291(VarNext,bitIndex785) )
            & ( v48177_22__array(VarNext,A,bitIndex36)
            <=> v50291(VarNext,bitIndex784) )
            & ( v48177_22__array(VarNext,A,bitIndex35)
            <=> v50291(VarNext,bitIndex783) )
            & ( v48177_22__array(VarNext,A,bitIndex34)
            <=> v50291(VarNext,bitIndex782) )
            & ( v48177_22__array(VarNext,A,bitIndex33)
            <=> v50291(VarNext,bitIndex781) )
            & ( v48177_22__array(VarNext,A,bitIndex32)
            <=> v50291(VarNext,bitIndex780) )
            & ( v48177_22__array(VarNext,A,bitIndex31)
            <=> v50291(VarNext,bitIndex779) )
            & ( v48177_22__array(VarNext,A,bitIndex30)
            <=> v50291(VarNext,bitIndex778) )
            & ( v48177_22__array(VarNext,A,bitIndex29)
            <=> v50291(VarNext,bitIndex777) )
            & ( v48177_22__array(VarNext,A,bitIndex28)
            <=> v50291(VarNext,bitIndex776) )
            & ( v48177_22__array(VarNext,A,bitIndex27)
            <=> v50291(VarNext,bitIndex775) )
            & ( v48177_22__array(VarNext,A,bitIndex26)
            <=> v50291(VarNext,bitIndex774) )
            & ( v48177_22__array(VarNext,A,bitIndex25)
            <=> v50291(VarNext,bitIndex773) )
            & ( v48177_22__array(VarNext,A,bitIndex24)
            <=> v50291(VarNext,bitIndex772) )
            & ( v48177_22__array(VarNext,A,bitIndex23)
            <=> v50291(VarNext,bitIndex771) )
            & ( v48177_22__array(VarNext,A,bitIndex22)
            <=> v50291(VarNext,bitIndex770) )
            & ( v48177_22__array(VarNext,A,bitIndex21)
            <=> v50291(VarNext,bitIndex769) )
            & ( v48177_22__array(VarNext,A,bitIndex20)
            <=> v50291(VarNext,bitIndex768) )
            & ( v48177_22__array(VarNext,A,bitIndex19)
            <=> v50291(VarNext,bitIndex767) )
            & ( v48177_22__array(VarNext,A,bitIndex18)
            <=> v50291(VarNext,bitIndex766) )
            & ( v48177_22__array(VarNext,A,bitIndex17)
            <=> v50291(VarNext,bitIndex765) )
            & ( v48177_22__array(VarNext,A,bitIndex16)
            <=> v50291(VarNext,bitIndex764) )
            & ( v48177_22__array(VarNext,A,bitIndex15)
            <=> v50291(VarNext,bitIndex763) )
            & ( v48177_22__array(VarNext,A,bitIndex14)
            <=> v50291(VarNext,bitIndex762) )
            & ( v48177_22__array(VarNext,A,bitIndex13)
            <=> v50291(VarNext,bitIndex761) )
            & ( v48177_22__array(VarNext,A,bitIndex12)
            <=> v50291(VarNext,bitIndex760) )
            & ( v48177_22__array(VarNext,A,bitIndex11)
            <=> v50291(VarNext,bitIndex759) )
            & ( v48177_22__array(VarNext,A,bitIndex10)
            <=> v50291(VarNext,bitIndex758) )
            & ( v48177_22__array(VarNext,A,bitIndex9)
            <=> v50291(VarNext,bitIndex757) )
            & ( v48177_22__array(VarNext,A,bitIndex8)
            <=> v50291(VarNext,bitIndex756) )
            & ( v48177_22__array(VarNext,A,bitIndex7)
            <=> v50291(VarNext,bitIndex755) )
            & ( v48177_22__array(VarNext,A,bitIndex6)
            <=> v50291(VarNext,bitIndex754) )
            & ( v48177_22__array(VarNext,A,bitIndex5)
            <=> v50291(VarNext,bitIndex753) )
            & ( v48177_22__array(VarNext,A,bitIndex4)
            <=> v50291(VarNext,bitIndex752) )
            & ( v48177_22__array(VarNext,A,bitIndex3)
            <=> v50291(VarNext,bitIndex751) )
            & ( v48177_22__array(VarNext,A,bitIndex2)
            <=> v50291(VarNext,bitIndex750) )
            & ( v48177_22__array(VarNext,A,bitIndex1)
            <=> v50291(VarNext,bitIndex749) )
            & ( v48177_22__array(VarNext,A,bitIndex0)
            <=> v50291(VarNext,bitIndex748) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10509,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50285(VarNext)
      <=> ( v50286(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10508,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50286(VarNext)
      <=> ( v50288(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4417,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50288(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_42,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b10000_address_term = A
              & v50276(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_21__array(VarNext,A,B)
              <=> v48177_20__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_42,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b10000_address_term = A
            & v50276(VarNext) )
         => ( ( v48177_21__array(VarNext,A,bitIndex43)
            <=> v50282(VarNext,bitIndex747) )
            & ( v48177_21__array(VarNext,A,bitIndex42)
            <=> v50282(VarNext,bitIndex746) )
            & ( v48177_21__array(VarNext,A,bitIndex41)
            <=> v50282(VarNext,bitIndex745) )
            & ( v48177_21__array(VarNext,A,bitIndex40)
            <=> v50282(VarNext,bitIndex744) )
            & ( v48177_21__array(VarNext,A,bitIndex39)
            <=> v50282(VarNext,bitIndex743) )
            & ( v48177_21__array(VarNext,A,bitIndex38)
            <=> v50282(VarNext,bitIndex742) )
            & ( v48177_21__array(VarNext,A,bitIndex37)
            <=> v50282(VarNext,bitIndex741) )
            & ( v48177_21__array(VarNext,A,bitIndex36)
            <=> v50282(VarNext,bitIndex740) )
            & ( v48177_21__array(VarNext,A,bitIndex35)
            <=> v50282(VarNext,bitIndex739) )
            & ( v48177_21__array(VarNext,A,bitIndex34)
            <=> v50282(VarNext,bitIndex738) )
            & ( v48177_21__array(VarNext,A,bitIndex33)
            <=> v50282(VarNext,bitIndex737) )
            & ( v48177_21__array(VarNext,A,bitIndex32)
            <=> v50282(VarNext,bitIndex736) )
            & ( v48177_21__array(VarNext,A,bitIndex31)
            <=> v50282(VarNext,bitIndex735) )
            & ( v48177_21__array(VarNext,A,bitIndex30)
            <=> v50282(VarNext,bitIndex734) )
            & ( v48177_21__array(VarNext,A,bitIndex29)
            <=> v50282(VarNext,bitIndex733) )
            & ( v48177_21__array(VarNext,A,bitIndex28)
            <=> v50282(VarNext,bitIndex732) )
            & ( v48177_21__array(VarNext,A,bitIndex27)
            <=> v50282(VarNext,bitIndex731) )
            & ( v48177_21__array(VarNext,A,bitIndex26)
            <=> v50282(VarNext,bitIndex730) )
            & ( v48177_21__array(VarNext,A,bitIndex25)
            <=> v50282(VarNext,bitIndex729) )
            & ( v48177_21__array(VarNext,A,bitIndex24)
            <=> v50282(VarNext,bitIndex728) )
            & ( v48177_21__array(VarNext,A,bitIndex23)
            <=> v50282(VarNext,bitIndex727) )
            & ( v48177_21__array(VarNext,A,bitIndex22)
            <=> v50282(VarNext,bitIndex726) )
            & ( v48177_21__array(VarNext,A,bitIndex21)
            <=> v50282(VarNext,bitIndex725) )
            & ( v48177_21__array(VarNext,A,bitIndex20)
            <=> v50282(VarNext,bitIndex724) )
            & ( v48177_21__array(VarNext,A,bitIndex19)
            <=> v50282(VarNext,bitIndex723) )
            & ( v48177_21__array(VarNext,A,bitIndex18)
            <=> v50282(VarNext,bitIndex722) )
            & ( v48177_21__array(VarNext,A,bitIndex17)
            <=> v50282(VarNext,bitIndex721) )
            & ( v48177_21__array(VarNext,A,bitIndex16)
            <=> v50282(VarNext,bitIndex720) )
            & ( v48177_21__array(VarNext,A,bitIndex15)
            <=> v50282(VarNext,bitIndex719) )
            & ( v48177_21__array(VarNext,A,bitIndex14)
            <=> v50282(VarNext,bitIndex718) )
            & ( v48177_21__array(VarNext,A,bitIndex13)
            <=> v50282(VarNext,bitIndex717) )
            & ( v48177_21__array(VarNext,A,bitIndex12)
            <=> v50282(VarNext,bitIndex716) )
            & ( v48177_21__array(VarNext,A,bitIndex11)
            <=> v50282(VarNext,bitIndex715) )
            & ( v48177_21__array(VarNext,A,bitIndex10)
            <=> v50282(VarNext,bitIndex714) )
            & ( v48177_21__array(VarNext,A,bitIndex9)
            <=> v50282(VarNext,bitIndex713) )
            & ( v48177_21__array(VarNext,A,bitIndex8)
            <=> v50282(VarNext,bitIndex712) )
            & ( v48177_21__array(VarNext,A,bitIndex7)
            <=> v50282(VarNext,bitIndex711) )
            & ( v48177_21__array(VarNext,A,bitIndex6)
            <=> v50282(VarNext,bitIndex710) )
            & ( v48177_21__array(VarNext,A,bitIndex5)
            <=> v50282(VarNext,bitIndex709) )
            & ( v48177_21__array(VarNext,A,bitIndex4)
            <=> v50282(VarNext,bitIndex708) )
            & ( v48177_21__array(VarNext,A,bitIndex3)
            <=> v50282(VarNext,bitIndex707) )
            & ( v48177_21__array(VarNext,A,bitIndex2)
            <=> v50282(VarNext,bitIndex706) )
            & ( v48177_21__array(VarNext,A,bitIndex1)
            <=> v50282(VarNext,bitIndex705) )
            & ( v48177_21__array(VarNext,A,bitIndex0)
            <=> v50282(VarNext,bitIndex704) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10507,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50276(VarNext)
      <=> ( v50277(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10506,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50277(VarNext)
      <=> ( v50279(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4416,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50279(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_41,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01111_address_term = A
              & v50267(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_20__array(VarNext,A,B)
              <=> v48177_19__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_41,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01111_address_term = A
            & v50267(VarNext) )
         => ( ( v48177_20__array(VarNext,A,bitIndex43)
            <=> v50273(VarNext,bitIndex703) )
            & ( v48177_20__array(VarNext,A,bitIndex42)
            <=> v50273(VarNext,bitIndex702) )
            & ( v48177_20__array(VarNext,A,bitIndex41)
            <=> v50273(VarNext,bitIndex701) )
            & ( v48177_20__array(VarNext,A,bitIndex40)
            <=> v50273(VarNext,bitIndex700) )
            & ( v48177_20__array(VarNext,A,bitIndex39)
            <=> v50273(VarNext,bitIndex699) )
            & ( v48177_20__array(VarNext,A,bitIndex38)
            <=> v50273(VarNext,bitIndex698) )
            & ( v48177_20__array(VarNext,A,bitIndex37)
            <=> v50273(VarNext,bitIndex697) )
            & ( v48177_20__array(VarNext,A,bitIndex36)
            <=> v50273(VarNext,bitIndex696) )
            & ( v48177_20__array(VarNext,A,bitIndex35)
            <=> v50273(VarNext,bitIndex695) )
            & ( v48177_20__array(VarNext,A,bitIndex34)
            <=> v50273(VarNext,bitIndex694) )
            & ( v48177_20__array(VarNext,A,bitIndex33)
            <=> v50273(VarNext,bitIndex693) )
            & ( v48177_20__array(VarNext,A,bitIndex32)
            <=> v50273(VarNext,bitIndex692) )
            & ( v48177_20__array(VarNext,A,bitIndex31)
            <=> v50273(VarNext,bitIndex691) )
            & ( v48177_20__array(VarNext,A,bitIndex30)
            <=> v50273(VarNext,bitIndex690) )
            & ( v48177_20__array(VarNext,A,bitIndex29)
            <=> v50273(VarNext,bitIndex689) )
            & ( v48177_20__array(VarNext,A,bitIndex28)
            <=> v50273(VarNext,bitIndex688) )
            & ( v48177_20__array(VarNext,A,bitIndex27)
            <=> v50273(VarNext,bitIndex687) )
            & ( v48177_20__array(VarNext,A,bitIndex26)
            <=> v50273(VarNext,bitIndex686) )
            & ( v48177_20__array(VarNext,A,bitIndex25)
            <=> v50273(VarNext,bitIndex685) )
            & ( v48177_20__array(VarNext,A,bitIndex24)
            <=> v50273(VarNext,bitIndex684) )
            & ( v48177_20__array(VarNext,A,bitIndex23)
            <=> v50273(VarNext,bitIndex683) )
            & ( v48177_20__array(VarNext,A,bitIndex22)
            <=> v50273(VarNext,bitIndex682) )
            & ( v48177_20__array(VarNext,A,bitIndex21)
            <=> v50273(VarNext,bitIndex681) )
            & ( v48177_20__array(VarNext,A,bitIndex20)
            <=> v50273(VarNext,bitIndex680) )
            & ( v48177_20__array(VarNext,A,bitIndex19)
            <=> v50273(VarNext,bitIndex679) )
            & ( v48177_20__array(VarNext,A,bitIndex18)
            <=> v50273(VarNext,bitIndex678) )
            & ( v48177_20__array(VarNext,A,bitIndex17)
            <=> v50273(VarNext,bitIndex677) )
            & ( v48177_20__array(VarNext,A,bitIndex16)
            <=> v50273(VarNext,bitIndex676) )
            & ( v48177_20__array(VarNext,A,bitIndex15)
            <=> v50273(VarNext,bitIndex675) )
            & ( v48177_20__array(VarNext,A,bitIndex14)
            <=> v50273(VarNext,bitIndex674) )
            & ( v48177_20__array(VarNext,A,bitIndex13)
            <=> v50273(VarNext,bitIndex673) )
            & ( v48177_20__array(VarNext,A,bitIndex12)
            <=> v50273(VarNext,bitIndex672) )
            & ( v48177_20__array(VarNext,A,bitIndex11)
            <=> v50273(VarNext,bitIndex671) )
            & ( v48177_20__array(VarNext,A,bitIndex10)
            <=> v50273(VarNext,bitIndex670) )
            & ( v48177_20__array(VarNext,A,bitIndex9)
            <=> v50273(VarNext,bitIndex669) )
            & ( v48177_20__array(VarNext,A,bitIndex8)
            <=> v50273(VarNext,bitIndex668) )
            & ( v48177_20__array(VarNext,A,bitIndex7)
            <=> v50273(VarNext,bitIndex667) )
            & ( v48177_20__array(VarNext,A,bitIndex6)
            <=> v50273(VarNext,bitIndex666) )
            & ( v48177_20__array(VarNext,A,bitIndex5)
            <=> v50273(VarNext,bitIndex665) )
            & ( v48177_20__array(VarNext,A,bitIndex4)
            <=> v50273(VarNext,bitIndex664) )
            & ( v48177_20__array(VarNext,A,bitIndex3)
            <=> v50273(VarNext,bitIndex663) )
            & ( v48177_20__array(VarNext,A,bitIndex2)
            <=> v50273(VarNext,bitIndex662) )
            & ( v48177_20__array(VarNext,A,bitIndex1)
            <=> v50273(VarNext,bitIndex661) )
            & ( v48177_20__array(VarNext,A,bitIndex0)
            <=> v50273(VarNext,bitIndex660) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10505,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50267(VarNext)
      <=> ( v50268(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10504,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50268(VarNext)
      <=> ( v50270(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4415,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50270(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_40,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01110_address_term = A
              & v50258(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_19__array(VarNext,A,B)
              <=> v48177_18__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_40,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01110_address_term = A
            & v50258(VarNext) )
         => ( ( v48177_19__array(VarNext,A,bitIndex43)
            <=> v50264(VarNext,bitIndex659) )
            & ( v48177_19__array(VarNext,A,bitIndex42)
            <=> v50264(VarNext,bitIndex658) )
            & ( v48177_19__array(VarNext,A,bitIndex41)
            <=> v50264(VarNext,bitIndex657) )
            & ( v48177_19__array(VarNext,A,bitIndex40)
            <=> v50264(VarNext,bitIndex656) )
            & ( v48177_19__array(VarNext,A,bitIndex39)
            <=> v50264(VarNext,bitIndex655) )
            & ( v48177_19__array(VarNext,A,bitIndex38)
            <=> v50264(VarNext,bitIndex654) )
            & ( v48177_19__array(VarNext,A,bitIndex37)
            <=> v50264(VarNext,bitIndex653) )
            & ( v48177_19__array(VarNext,A,bitIndex36)
            <=> v50264(VarNext,bitIndex652) )
            & ( v48177_19__array(VarNext,A,bitIndex35)
            <=> v50264(VarNext,bitIndex651) )
            & ( v48177_19__array(VarNext,A,bitIndex34)
            <=> v50264(VarNext,bitIndex650) )
            & ( v48177_19__array(VarNext,A,bitIndex33)
            <=> v50264(VarNext,bitIndex649) )
            & ( v48177_19__array(VarNext,A,bitIndex32)
            <=> v50264(VarNext,bitIndex648) )
            & ( v48177_19__array(VarNext,A,bitIndex31)
            <=> v50264(VarNext,bitIndex647) )
            & ( v48177_19__array(VarNext,A,bitIndex30)
            <=> v50264(VarNext,bitIndex646) )
            & ( v48177_19__array(VarNext,A,bitIndex29)
            <=> v50264(VarNext,bitIndex645) )
            & ( v48177_19__array(VarNext,A,bitIndex28)
            <=> v50264(VarNext,bitIndex644) )
            & ( v48177_19__array(VarNext,A,bitIndex27)
            <=> v50264(VarNext,bitIndex643) )
            & ( v48177_19__array(VarNext,A,bitIndex26)
            <=> v50264(VarNext,bitIndex642) )
            & ( v48177_19__array(VarNext,A,bitIndex25)
            <=> v50264(VarNext,bitIndex641) )
            & ( v48177_19__array(VarNext,A,bitIndex24)
            <=> v50264(VarNext,bitIndex640) )
            & ( v48177_19__array(VarNext,A,bitIndex23)
            <=> v50264(VarNext,bitIndex639) )
            & ( v48177_19__array(VarNext,A,bitIndex22)
            <=> v50264(VarNext,bitIndex638) )
            & ( v48177_19__array(VarNext,A,bitIndex21)
            <=> v50264(VarNext,bitIndex637) )
            & ( v48177_19__array(VarNext,A,bitIndex20)
            <=> v50264(VarNext,bitIndex636) )
            & ( v48177_19__array(VarNext,A,bitIndex19)
            <=> v50264(VarNext,bitIndex635) )
            & ( v48177_19__array(VarNext,A,bitIndex18)
            <=> v50264(VarNext,bitIndex634) )
            & ( v48177_19__array(VarNext,A,bitIndex17)
            <=> v50264(VarNext,bitIndex633) )
            & ( v48177_19__array(VarNext,A,bitIndex16)
            <=> v50264(VarNext,bitIndex632) )
            & ( v48177_19__array(VarNext,A,bitIndex15)
            <=> v50264(VarNext,bitIndex631) )
            & ( v48177_19__array(VarNext,A,bitIndex14)
            <=> v50264(VarNext,bitIndex630) )
            & ( v48177_19__array(VarNext,A,bitIndex13)
            <=> v50264(VarNext,bitIndex629) )
            & ( v48177_19__array(VarNext,A,bitIndex12)
            <=> v50264(VarNext,bitIndex628) )
            & ( v48177_19__array(VarNext,A,bitIndex11)
            <=> v50264(VarNext,bitIndex627) )
            & ( v48177_19__array(VarNext,A,bitIndex10)
            <=> v50264(VarNext,bitIndex626) )
            & ( v48177_19__array(VarNext,A,bitIndex9)
            <=> v50264(VarNext,bitIndex625) )
            & ( v48177_19__array(VarNext,A,bitIndex8)
            <=> v50264(VarNext,bitIndex624) )
            & ( v48177_19__array(VarNext,A,bitIndex7)
            <=> v50264(VarNext,bitIndex623) )
            & ( v48177_19__array(VarNext,A,bitIndex6)
            <=> v50264(VarNext,bitIndex622) )
            & ( v48177_19__array(VarNext,A,bitIndex5)
            <=> v50264(VarNext,bitIndex621) )
            & ( v48177_19__array(VarNext,A,bitIndex4)
            <=> v50264(VarNext,bitIndex620) )
            & ( v48177_19__array(VarNext,A,bitIndex3)
            <=> v50264(VarNext,bitIndex619) )
            & ( v48177_19__array(VarNext,A,bitIndex2)
            <=> v50264(VarNext,bitIndex618) )
            & ( v48177_19__array(VarNext,A,bitIndex1)
            <=> v50264(VarNext,bitIndex617) )
            & ( v48177_19__array(VarNext,A,bitIndex0)
            <=> v50264(VarNext,bitIndex616) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10503,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50258(VarNext)
      <=> ( v50259(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10502,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50259(VarNext)
      <=> ( v50261(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4414,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50261(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_39,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01101_address_term = A
              & v50249(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_18__array(VarNext,A,B)
              <=> v48177_17__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_39,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01101_address_term = A
            & v50249(VarNext) )
         => ( ( v48177_18__array(VarNext,A,bitIndex43)
            <=> v50255(VarNext,bitIndex615) )
            & ( v48177_18__array(VarNext,A,bitIndex42)
            <=> v50255(VarNext,bitIndex614) )
            & ( v48177_18__array(VarNext,A,bitIndex41)
            <=> v50255(VarNext,bitIndex613) )
            & ( v48177_18__array(VarNext,A,bitIndex40)
            <=> v50255(VarNext,bitIndex612) )
            & ( v48177_18__array(VarNext,A,bitIndex39)
            <=> v50255(VarNext,bitIndex611) )
            & ( v48177_18__array(VarNext,A,bitIndex38)
            <=> v50255(VarNext,bitIndex610) )
            & ( v48177_18__array(VarNext,A,bitIndex37)
            <=> v50255(VarNext,bitIndex609) )
            & ( v48177_18__array(VarNext,A,bitIndex36)
            <=> v50255(VarNext,bitIndex608) )
            & ( v48177_18__array(VarNext,A,bitIndex35)
            <=> v50255(VarNext,bitIndex607) )
            & ( v48177_18__array(VarNext,A,bitIndex34)
            <=> v50255(VarNext,bitIndex606) )
            & ( v48177_18__array(VarNext,A,bitIndex33)
            <=> v50255(VarNext,bitIndex605) )
            & ( v48177_18__array(VarNext,A,bitIndex32)
            <=> v50255(VarNext,bitIndex604) )
            & ( v48177_18__array(VarNext,A,bitIndex31)
            <=> v50255(VarNext,bitIndex603) )
            & ( v48177_18__array(VarNext,A,bitIndex30)
            <=> v50255(VarNext,bitIndex602) )
            & ( v48177_18__array(VarNext,A,bitIndex29)
            <=> v50255(VarNext,bitIndex601) )
            & ( v48177_18__array(VarNext,A,bitIndex28)
            <=> v50255(VarNext,bitIndex600) )
            & ( v48177_18__array(VarNext,A,bitIndex27)
            <=> v50255(VarNext,bitIndex599) )
            & ( v48177_18__array(VarNext,A,bitIndex26)
            <=> v50255(VarNext,bitIndex598) )
            & ( v48177_18__array(VarNext,A,bitIndex25)
            <=> v50255(VarNext,bitIndex597) )
            & ( v48177_18__array(VarNext,A,bitIndex24)
            <=> v50255(VarNext,bitIndex596) )
            & ( v48177_18__array(VarNext,A,bitIndex23)
            <=> v50255(VarNext,bitIndex595) )
            & ( v48177_18__array(VarNext,A,bitIndex22)
            <=> v50255(VarNext,bitIndex594) )
            & ( v48177_18__array(VarNext,A,bitIndex21)
            <=> v50255(VarNext,bitIndex593) )
            & ( v48177_18__array(VarNext,A,bitIndex20)
            <=> v50255(VarNext,bitIndex592) )
            & ( v48177_18__array(VarNext,A,bitIndex19)
            <=> v50255(VarNext,bitIndex591) )
            & ( v48177_18__array(VarNext,A,bitIndex18)
            <=> v50255(VarNext,bitIndex590) )
            & ( v48177_18__array(VarNext,A,bitIndex17)
            <=> v50255(VarNext,bitIndex589) )
            & ( v48177_18__array(VarNext,A,bitIndex16)
            <=> v50255(VarNext,bitIndex588) )
            & ( v48177_18__array(VarNext,A,bitIndex15)
            <=> v50255(VarNext,bitIndex587) )
            & ( v48177_18__array(VarNext,A,bitIndex14)
            <=> v50255(VarNext,bitIndex586) )
            & ( v48177_18__array(VarNext,A,bitIndex13)
            <=> v50255(VarNext,bitIndex585) )
            & ( v48177_18__array(VarNext,A,bitIndex12)
            <=> v50255(VarNext,bitIndex584) )
            & ( v48177_18__array(VarNext,A,bitIndex11)
            <=> v50255(VarNext,bitIndex583) )
            & ( v48177_18__array(VarNext,A,bitIndex10)
            <=> v50255(VarNext,bitIndex582) )
            & ( v48177_18__array(VarNext,A,bitIndex9)
            <=> v50255(VarNext,bitIndex581) )
            & ( v48177_18__array(VarNext,A,bitIndex8)
            <=> v50255(VarNext,bitIndex580) )
            & ( v48177_18__array(VarNext,A,bitIndex7)
            <=> v50255(VarNext,bitIndex579) )
            & ( v48177_18__array(VarNext,A,bitIndex6)
            <=> v50255(VarNext,bitIndex578) )
            & ( v48177_18__array(VarNext,A,bitIndex5)
            <=> v50255(VarNext,bitIndex577) )
            & ( v48177_18__array(VarNext,A,bitIndex4)
            <=> v50255(VarNext,bitIndex576) )
            & ( v48177_18__array(VarNext,A,bitIndex3)
            <=> v50255(VarNext,bitIndex575) )
            & ( v48177_18__array(VarNext,A,bitIndex2)
            <=> v50255(VarNext,bitIndex574) )
            & ( v48177_18__array(VarNext,A,bitIndex1)
            <=> v50255(VarNext,bitIndex573) )
            & ( v48177_18__array(VarNext,A,bitIndex0)
            <=> v50255(VarNext,bitIndex572) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10501,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50249(VarNext)
      <=> ( v50250(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10500,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50250(VarNext)
      <=> ( v50252(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4413,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50252(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_38,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01100_address_term = A
              & v50240(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_17__array(VarNext,A,B)
              <=> v48177_16__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_38,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01100_address_term = A
            & v50240(VarNext) )
         => ( ( v48177_17__array(VarNext,A,bitIndex43)
            <=> v50246(VarNext,bitIndex571) )
            & ( v48177_17__array(VarNext,A,bitIndex42)
            <=> v50246(VarNext,bitIndex570) )
            & ( v48177_17__array(VarNext,A,bitIndex41)
            <=> v50246(VarNext,bitIndex569) )
            & ( v48177_17__array(VarNext,A,bitIndex40)
            <=> v50246(VarNext,bitIndex568) )
            & ( v48177_17__array(VarNext,A,bitIndex39)
            <=> v50246(VarNext,bitIndex567) )
            & ( v48177_17__array(VarNext,A,bitIndex38)
            <=> v50246(VarNext,bitIndex566) )
            & ( v48177_17__array(VarNext,A,bitIndex37)
            <=> v50246(VarNext,bitIndex565) )
            & ( v48177_17__array(VarNext,A,bitIndex36)
            <=> v50246(VarNext,bitIndex564) )
            & ( v48177_17__array(VarNext,A,bitIndex35)
            <=> v50246(VarNext,bitIndex563) )
            & ( v48177_17__array(VarNext,A,bitIndex34)
            <=> v50246(VarNext,bitIndex562) )
            & ( v48177_17__array(VarNext,A,bitIndex33)
            <=> v50246(VarNext,bitIndex561) )
            & ( v48177_17__array(VarNext,A,bitIndex32)
            <=> v50246(VarNext,bitIndex560) )
            & ( v48177_17__array(VarNext,A,bitIndex31)
            <=> v50246(VarNext,bitIndex559) )
            & ( v48177_17__array(VarNext,A,bitIndex30)
            <=> v50246(VarNext,bitIndex558) )
            & ( v48177_17__array(VarNext,A,bitIndex29)
            <=> v50246(VarNext,bitIndex557) )
            & ( v48177_17__array(VarNext,A,bitIndex28)
            <=> v50246(VarNext,bitIndex556) )
            & ( v48177_17__array(VarNext,A,bitIndex27)
            <=> v50246(VarNext,bitIndex555) )
            & ( v48177_17__array(VarNext,A,bitIndex26)
            <=> v50246(VarNext,bitIndex554) )
            & ( v48177_17__array(VarNext,A,bitIndex25)
            <=> v50246(VarNext,bitIndex553) )
            & ( v48177_17__array(VarNext,A,bitIndex24)
            <=> v50246(VarNext,bitIndex552) )
            & ( v48177_17__array(VarNext,A,bitIndex23)
            <=> v50246(VarNext,bitIndex551) )
            & ( v48177_17__array(VarNext,A,bitIndex22)
            <=> v50246(VarNext,bitIndex550) )
            & ( v48177_17__array(VarNext,A,bitIndex21)
            <=> v50246(VarNext,bitIndex549) )
            & ( v48177_17__array(VarNext,A,bitIndex20)
            <=> v50246(VarNext,bitIndex548) )
            & ( v48177_17__array(VarNext,A,bitIndex19)
            <=> v50246(VarNext,bitIndex547) )
            & ( v48177_17__array(VarNext,A,bitIndex18)
            <=> v50246(VarNext,bitIndex546) )
            & ( v48177_17__array(VarNext,A,bitIndex17)
            <=> v50246(VarNext,bitIndex545) )
            & ( v48177_17__array(VarNext,A,bitIndex16)
            <=> v50246(VarNext,bitIndex544) )
            & ( v48177_17__array(VarNext,A,bitIndex15)
            <=> v50246(VarNext,bitIndex543) )
            & ( v48177_17__array(VarNext,A,bitIndex14)
            <=> v50246(VarNext,bitIndex542) )
            & ( v48177_17__array(VarNext,A,bitIndex13)
            <=> v50246(VarNext,bitIndex541) )
            & ( v48177_17__array(VarNext,A,bitIndex12)
            <=> v50246(VarNext,bitIndex540) )
            & ( v48177_17__array(VarNext,A,bitIndex11)
            <=> v50246(VarNext,bitIndex539) )
            & ( v48177_17__array(VarNext,A,bitIndex10)
            <=> v50246(VarNext,bitIndex538) )
            & ( v48177_17__array(VarNext,A,bitIndex9)
            <=> v50246(VarNext,bitIndex537) )
            & ( v48177_17__array(VarNext,A,bitIndex8)
            <=> v50246(VarNext,bitIndex536) )
            & ( v48177_17__array(VarNext,A,bitIndex7)
            <=> v50246(VarNext,bitIndex535) )
            & ( v48177_17__array(VarNext,A,bitIndex6)
            <=> v50246(VarNext,bitIndex534) )
            & ( v48177_17__array(VarNext,A,bitIndex5)
            <=> v50246(VarNext,bitIndex533) )
            & ( v48177_17__array(VarNext,A,bitIndex4)
            <=> v50246(VarNext,bitIndex532) )
            & ( v48177_17__array(VarNext,A,bitIndex3)
            <=> v50246(VarNext,bitIndex531) )
            & ( v48177_17__array(VarNext,A,bitIndex2)
            <=> v50246(VarNext,bitIndex530) )
            & ( v48177_17__array(VarNext,A,bitIndex1)
            <=> v50246(VarNext,bitIndex529) )
            & ( v48177_17__array(VarNext,A,bitIndex0)
            <=> v50246(VarNext,bitIndex528) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10499,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50240(VarNext)
      <=> ( v50241(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10498,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50241(VarNext)
      <=> ( v50243(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4412,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50243(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_37,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01011_address_term = A
              & v50231(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_16__array(VarNext,A,B)
              <=> v48177_15__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_37,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01011_address_term = A
            & v50231(VarNext) )
         => ( ( v48177_16__array(VarNext,A,bitIndex43)
            <=> v50237(VarNext,bitIndex527) )
            & ( v48177_16__array(VarNext,A,bitIndex42)
            <=> v50237(VarNext,bitIndex526) )
            & ( v48177_16__array(VarNext,A,bitIndex41)
            <=> v50237(VarNext,bitIndex525) )
            & ( v48177_16__array(VarNext,A,bitIndex40)
            <=> v50237(VarNext,bitIndex524) )
            & ( v48177_16__array(VarNext,A,bitIndex39)
            <=> v50237(VarNext,bitIndex523) )
            & ( v48177_16__array(VarNext,A,bitIndex38)
            <=> v50237(VarNext,bitIndex522) )
            & ( v48177_16__array(VarNext,A,bitIndex37)
            <=> v50237(VarNext,bitIndex521) )
            & ( v48177_16__array(VarNext,A,bitIndex36)
            <=> v50237(VarNext,bitIndex520) )
            & ( v48177_16__array(VarNext,A,bitIndex35)
            <=> v50237(VarNext,bitIndex519) )
            & ( v48177_16__array(VarNext,A,bitIndex34)
            <=> v50237(VarNext,bitIndex518) )
            & ( v48177_16__array(VarNext,A,bitIndex33)
            <=> v50237(VarNext,bitIndex517) )
            & ( v48177_16__array(VarNext,A,bitIndex32)
            <=> v50237(VarNext,bitIndex516) )
            & ( v48177_16__array(VarNext,A,bitIndex31)
            <=> v50237(VarNext,bitIndex515) )
            & ( v48177_16__array(VarNext,A,bitIndex30)
            <=> v50237(VarNext,bitIndex514) )
            & ( v48177_16__array(VarNext,A,bitIndex29)
            <=> v50237(VarNext,bitIndex513) )
            & ( v48177_16__array(VarNext,A,bitIndex28)
            <=> v50237(VarNext,bitIndex512) )
            & ( v48177_16__array(VarNext,A,bitIndex27)
            <=> v50237(VarNext,bitIndex511) )
            & ( v48177_16__array(VarNext,A,bitIndex26)
            <=> v50237(VarNext,bitIndex510) )
            & ( v48177_16__array(VarNext,A,bitIndex25)
            <=> v50237(VarNext,bitIndex509) )
            & ( v48177_16__array(VarNext,A,bitIndex24)
            <=> v50237(VarNext,bitIndex508) )
            & ( v48177_16__array(VarNext,A,bitIndex23)
            <=> v50237(VarNext,bitIndex507) )
            & ( v48177_16__array(VarNext,A,bitIndex22)
            <=> v50237(VarNext,bitIndex506) )
            & ( v48177_16__array(VarNext,A,bitIndex21)
            <=> v50237(VarNext,bitIndex505) )
            & ( v48177_16__array(VarNext,A,bitIndex20)
            <=> v50237(VarNext,bitIndex504) )
            & ( v48177_16__array(VarNext,A,bitIndex19)
            <=> v50237(VarNext,bitIndex503) )
            & ( v48177_16__array(VarNext,A,bitIndex18)
            <=> v50237(VarNext,bitIndex502) )
            & ( v48177_16__array(VarNext,A,bitIndex17)
            <=> v50237(VarNext,bitIndex501) )
            & ( v48177_16__array(VarNext,A,bitIndex16)
            <=> v50237(VarNext,bitIndex500) )
            & ( v48177_16__array(VarNext,A,bitIndex15)
            <=> v50237(VarNext,bitIndex499) )
            & ( v48177_16__array(VarNext,A,bitIndex14)
            <=> v50237(VarNext,bitIndex498) )
            & ( v48177_16__array(VarNext,A,bitIndex13)
            <=> v50237(VarNext,bitIndex497) )
            & ( v48177_16__array(VarNext,A,bitIndex12)
            <=> v50237(VarNext,bitIndex496) )
            & ( v48177_16__array(VarNext,A,bitIndex11)
            <=> v50237(VarNext,bitIndex495) )
            & ( v48177_16__array(VarNext,A,bitIndex10)
            <=> v50237(VarNext,bitIndex494) )
            & ( v48177_16__array(VarNext,A,bitIndex9)
            <=> v50237(VarNext,bitIndex493) )
            & ( v48177_16__array(VarNext,A,bitIndex8)
            <=> v50237(VarNext,bitIndex492) )
            & ( v48177_16__array(VarNext,A,bitIndex7)
            <=> v50237(VarNext,bitIndex491) )
            & ( v48177_16__array(VarNext,A,bitIndex6)
            <=> v50237(VarNext,bitIndex490) )
            & ( v48177_16__array(VarNext,A,bitIndex5)
            <=> v50237(VarNext,bitIndex489) )
            & ( v48177_16__array(VarNext,A,bitIndex4)
            <=> v50237(VarNext,bitIndex488) )
            & ( v48177_16__array(VarNext,A,bitIndex3)
            <=> v50237(VarNext,bitIndex487) )
            & ( v48177_16__array(VarNext,A,bitIndex2)
            <=> v50237(VarNext,bitIndex486) )
            & ( v48177_16__array(VarNext,A,bitIndex1)
            <=> v50237(VarNext,bitIndex485) )
            & ( v48177_16__array(VarNext,A,bitIndex0)
            <=> v50237(VarNext,bitIndex484) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10497,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50231(VarNext)
      <=> ( v50232(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10496,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50232(VarNext)
      <=> ( v50234(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4411,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50234(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_36,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01010_address_term = A
              & v50222(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_15__array(VarNext,A,B)
              <=> v48177_14__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_36,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01010_address_term = A
            & v50222(VarNext) )
         => ( ( v48177_15__array(VarNext,A,bitIndex43)
            <=> v50228(VarNext,bitIndex483) )
            & ( v48177_15__array(VarNext,A,bitIndex42)
            <=> v50228(VarNext,bitIndex482) )
            & ( v48177_15__array(VarNext,A,bitIndex41)
            <=> v50228(VarNext,bitIndex481) )
            & ( v48177_15__array(VarNext,A,bitIndex40)
            <=> v50228(VarNext,bitIndex480) )
            & ( v48177_15__array(VarNext,A,bitIndex39)
            <=> v50228(VarNext,bitIndex479) )
            & ( v48177_15__array(VarNext,A,bitIndex38)
            <=> v50228(VarNext,bitIndex478) )
            & ( v48177_15__array(VarNext,A,bitIndex37)
            <=> v50228(VarNext,bitIndex477) )
            & ( v48177_15__array(VarNext,A,bitIndex36)
            <=> v50228(VarNext,bitIndex476) )
            & ( v48177_15__array(VarNext,A,bitIndex35)
            <=> v50228(VarNext,bitIndex475) )
            & ( v48177_15__array(VarNext,A,bitIndex34)
            <=> v50228(VarNext,bitIndex474) )
            & ( v48177_15__array(VarNext,A,bitIndex33)
            <=> v50228(VarNext,bitIndex473) )
            & ( v48177_15__array(VarNext,A,bitIndex32)
            <=> v50228(VarNext,bitIndex472) )
            & ( v48177_15__array(VarNext,A,bitIndex31)
            <=> v50228(VarNext,bitIndex471) )
            & ( v48177_15__array(VarNext,A,bitIndex30)
            <=> v50228(VarNext,bitIndex470) )
            & ( v48177_15__array(VarNext,A,bitIndex29)
            <=> v50228(VarNext,bitIndex469) )
            & ( v48177_15__array(VarNext,A,bitIndex28)
            <=> v50228(VarNext,bitIndex468) )
            & ( v48177_15__array(VarNext,A,bitIndex27)
            <=> v50228(VarNext,bitIndex467) )
            & ( v48177_15__array(VarNext,A,bitIndex26)
            <=> v50228(VarNext,bitIndex466) )
            & ( v48177_15__array(VarNext,A,bitIndex25)
            <=> v50228(VarNext,bitIndex465) )
            & ( v48177_15__array(VarNext,A,bitIndex24)
            <=> v50228(VarNext,bitIndex464) )
            & ( v48177_15__array(VarNext,A,bitIndex23)
            <=> v50228(VarNext,bitIndex463) )
            & ( v48177_15__array(VarNext,A,bitIndex22)
            <=> v50228(VarNext,bitIndex462) )
            & ( v48177_15__array(VarNext,A,bitIndex21)
            <=> v50228(VarNext,bitIndex461) )
            & ( v48177_15__array(VarNext,A,bitIndex20)
            <=> v50228(VarNext,bitIndex460) )
            & ( v48177_15__array(VarNext,A,bitIndex19)
            <=> v50228(VarNext,bitIndex459) )
            & ( v48177_15__array(VarNext,A,bitIndex18)
            <=> v50228(VarNext,bitIndex458) )
            & ( v48177_15__array(VarNext,A,bitIndex17)
            <=> v50228(VarNext,bitIndex457) )
            & ( v48177_15__array(VarNext,A,bitIndex16)
            <=> v50228(VarNext,bitIndex456) )
            & ( v48177_15__array(VarNext,A,bitIndex15)
            <=> v50228(VarNext,bitIndex455) )
            & ( v48177_15__array(VarNext,A,bitIndex14)
            <=> v50228(VarNext,bitIndex454) )
            & ( v48177_15__array(VarNext,A,bitIndex13)
            <=> v50228(VarNext,bitIndex453) )
            & ( v48177_15__array(VarNext,A,bitIndex12)
            <=> v50228(VarNext,bitIndex452) )
            & ( v48177_15__array(VarNext,A,bitIndex11)
            <=> v50228(VarNext,bitIndex451) )
            & ( v48177_15__array(VarNext,A,bitIndex10)
            <=> v50228(VarNext,bitIndex450) )
            & ( v48177_15__array(VarNext,A,bitIndex9)
            <=> v50228(VarNext,bitIndex449) )
            & ( v48177_15__array(VarNext,A,bitIndex8)
            <=> v50228(VarNext,bitIndex448) )
            & ( v48177_15__array(VarNext,A,bitIndex7)
            <=> v50228(VarNext,bitIndex447) )
            & ( v48177_15__array(VarNext,A,bitIndex6)
            <=> v50228(VarNext,bitIndex446) )
            & ( v48177_15__array(VarNext,A,bitIndex5)
            <=> v50228(VarNext,bitIndex445) )
            & ( v48177_15__array(VarNext,A,bitIndex4)
            <=> v50228(VarNext,bitIndex444) )
            & ( v48177_15__array(VarNext,A,bitIndex3)
            <=> v50228(VarNext,bitIndex443) )
            & ( v48177_15__array(VarNext,A,bitIndex2)
            <=> v50228(VarNext,bitIndex442) )
            & ( v48177_15__array(VarNext,A,bitIndex1)
            <=> v50228(VarNext,bitIndex441) )
            & ( v48177_15__array(VarNext,A,bitIndex0)
            <=> v50228(VarNext,bitIndex440) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10495,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50222(VarNext)
      <=> ( v50223(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10494,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50223(VarNext)
      <=> ( v50225(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4410,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50225(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_35,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01001_address_term = A
              & v50213(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_14__array(VarNext,A,B)
              <=> v48177_13__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_35,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01001_address_term = A
            & v50213(VarNext) )
         => ( ( v48177_14__array(VarNext,A,bitIndex43)
            <=> v50219(VarNext,bitIndex439) )
            & ( v48177_14__array(VarNext,A,bitIndex42)
            <=> v50219(VarNext,bitIndex438) )
            & ( v48177_14__array(VarNext,A,bitIndex41)
            <=> v50219(VarNext,bitIndex437) )
            & ( v48177_14__array(VarNext,A,bitIndex40)
            <=> v50219(VarNext,bitIndex436) )
            & ( v48177_14__array(VarNext,A,bitIndex39)
            <=> v50219(VarNext,bitIndex435) )
            & ( v48177_14__array(VarNext,A,bitIndex38)
            <=> v50219(VarNext,bitIndex434) )
            & ( v48177_14__array(VarNext,A,bitIndex37)
            <=> v50219(VarNext,bitIndex433) )
            & ( v48177_14__array(VarNext,A,bitIndex36)
            <=> v50219(VarNext,bitIndex432) )
            & ( v48177_14__array(VarNext,A,bitIndex35)
            <=> v50219(VarNext,bitIndex431) )
            & ( v48177_14__array(VarNext,A,bitIndex34)
            <=> v50219(VarNext,bitIndex430) )
            & ( v48177_14__array(VarNext,A,bitIndex33)
            <=> v50219(VarNext,bitIndex429) )
            & ( v48177_14__array(VarNext,A,bitIndex32)
            <=> v50219(VarNext,bitIndex428) )
            & ( v48177_14__array(VarNext,A,bitIndex31)
            <=> v50219(VarNext,bitIndex427) )
            & ( v48177_14__array(VarNext,A,bitIndex30)
            <=> v50219(VarNext,bitIndex426) )
            & ( v48177_14__array(VarNext,A,bitIndex29)
            <=> v50219(VarNext,bitIndex425) )
            & ( v48177_14__array(VarNext,A,bitIndex28)
            <=> v50219(VarNext,bitIndex424) )
            & ( v48177_14__array(VarNext,A,bitIndex27)
            <=> v50219(VarNext,bitIndex423) )
            & ( v48177_14__array(VarNext,A,bitIndex26)
            <=> v50219(VarNext,bitIndex422) )
            & ( v48177_14__array(VarNext,A,bitIndex25)
            <=> v50219(VarNext,bitIndex421) )
            & ( v48177_14__array(VarNext,A,bitIndex24)
            <=> v50219(VarNext,bitIndex420) )
            & ( v48177_14__array(VarNext,A,bitIndex23)
            <=> v50219(VarNext,bitIndex419) )
            & ( v48177_14__array(VarNext,A,bitIndex22)
            <=> v50219(VarNext,bitIndex418) )
            & ( v48177_14__array(VarNext,A,bitIndex21)
            <=> v50219(VarNext,bitIndex417) )
            & ( v48177_14__array(VarNext,A,bitIndex20)
            <=> v50219(VarNext,bitIndex416) )
            & ( v48177_14__array(VarNext,A,bitIndex19)
            <=> v50219(VarNext,bitIndex415) )
            & ( v48177_14__array(VarNext,A,bitIndex18)
            <=> v50219(VarNext,bitIndex414) )
            & ( v48177_14__array(VarNext,A,bitIndex17)
            <=> v50219(VarNext,bitIndex413) )
            & ( v48177_14__array(VarNext,A,bitIndex16)
            <=> v50219(VarNext,bitIndex412) )
            & ( v48177_14__array(VarNext,A,bitIndex15)
            <=> v50219(VarNext,bitIndex411) )
            & ( v48177_14__array(VarNext,A,bitIndex14)
            <=> v50219(VarNext,bitIndex410) )
            & ( v48177_14__array(VarNext,A,bitIndex13)
            <=> v50219(VarNext,bitIndex409) )
            & ( v48177_14__array(VarNext,A,bitIndex12)
            <=> v50219(VarNext,bitIndex408) )
            & ( v48177_14__array(VarNext,A,bitIndex11)
            <=> v50219(VarNext,bitIndex407) )
            & ( v48177_14__array(VarNext,A,bitIndex10)
            <=> v50219(VarNext,bitIndex406) )
            & ( v48177_14__array(VarNext,A,bitIndex9)
            <=> v50219(VarNext,bitIndex405) )
            & ( v48177_14__array(VarNext,A,bitIndex8)
            <=> v50219(VarNext,bitIndex404) )
            & ( v48177_14__array(VarNext,A,bitIndex7)
            <=> v50219(VarNext,bitIndex403) )
            & ( v48177_14__array(VarNext,A,bitIndex6)
            <=> v50219(VarNext,bitIndex402) )
            & ( v48177_14__array(VarNext,A,bitIndex5)
            <=> v50219(VarNext,bitIndex401) )
            & ( v48177_14__array(VarNext,A,bitIndex4)
            <=> v50219(VarNext,bitIndex400) )
            & ( v48177_14__array(VarNext,A,bitIndex3)
            <=> v50219(VarNext,bitIndex399) )
            & ( v48177_14__array(VarNext,A,bitIndex2)
            <=> v50219(VarNext,bitIndex398) )
            & ( v48177_14__array(VarNext,A,bitIndex1)
            <=> v50219(VarNext,bitIndex397) )
            & ( v48177_14__array(VarNext,A,bitIndex0)
            <=> v50219(VarNext,bitIndex396) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10493,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50213(VarNext)
      <=> ( v50214(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10492,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50214(VarNext)
      <=> ( v50216(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4409,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50216(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_34,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b01000_address_term = A
              & v50204(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_13__array(VarNext,A,B)
              <=> v48177_12__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_34,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b01000_address_term = A
            & v50204(VarNext) )
         => ( ( v48177_13__array(VarNext,A,bitIndex43)
            <=> v50210(VarNext,bitIndex395) )
            & ( v48177_13__array(VarNext,A,bitIndex42)
            <=> v50210(VarNext,bitIndex394) )
            & ( v48177_13__array(VarNext,A,bitIndex41)
            <=> v50210(VarNext,bitIndex393) )
            & ( v48177_13__array(VarNext,A,bitIndex40)
            <=> v50210(VarNext,bitIndex392) )
            & ( v48177_13__array(VarNext,A,bitIndex39)
            <=> v50210(VarNext,bitIndex391) )
            & ( v48177_13__array(VarNext,A,bitIndex38)
            <=> v50210(VarNext,bitIndex390) )
            & ( v48177_13__array(VarNext,A,bitIndex37)
            <=> v50210(VarNext,bitIndex389) )
            & ( v48177_13__array(VarNext,A,bitIndex36)
            <=> v50210(VarNext,bitIndex388) )
            & ( v48177_13__array(VarNext,A,bitIndex35)
            <=> v50210(VarNext,bitIndex387) )
            & ( v48177_13__array(VarNext,A,bitIndex34)
            <=> v50210(VarNext,bitIndex386) )
            & ( v48177_13__array(VarNext,A,bitIndex33)
            <=> v50210(VarNext,bitIndex385) )
            & ( v48177_13__array(VarNext,A,bitIndex32)
            <=> v50210(VarNext,bitIndex384) )
            & ( v48177_13__array(VarNext,A,bitIndex31)
            <=> v50210(VarNext,bitIndex383) )
            & ( v48177_13__array(VarNext,A,bitIndex30)
            <=> v50210(VarNext,bitIndex382) )
            & ( v48177_13__array(VarNext,A,bitIndex29)
            <=> v50210(VarNext,bitIndex381) )
            & ( v48177_13__array(VarNext,A,bitIndex28)
            <=> v50210(VarNext,bitIndex380) )
            & ( v48177_13__array(VarNext,A,bitIndex27)
            <=> v50210(VarNext,bitIndex379) )
            & ( v48177_13__array(VarNext,A,bitIndex26)
            <=> v50210(VarNext,bitIndex378) )
            & ( v48177_13__array(VarNext,A,bitIndex25)
            <=> v50210(VarNext,bitIndex377) )
            & ( v48177_13__array(VarNext,A,bitIndex24)
            <=> v50210(VarNext,bitIndex376) )
            & ( v48177_13__array(VarNext,A,bitIndex23)
            <=> v50210(VarNext,bitIndex375) )
            & ( v48177_13__array(VarNext,A,bitIndex22)
            <=> v50210(VarNext,bitIndex374) )
            & ( v48177_13__array(VarNext,A,bitIndex21)
            <=> v50210(VarNext,bitIndex373) )
            & ( v48177_13__array(VarNext,A,bitIndex20)
            <=> v50210(VarNext,bitIndex372) )
            & ( v48177_13__array(VarNext,A,bitIndex19)
            <=> v50210(VarNext,bitIndex371) )
            & ( v48177_13__array(VarNext,A,bitIndex18)
            <=> v50210(VarNext,bitIndex370) )
            & ( v48177_13__array(VarNext,A,bitIndex17)
            <=> v50210(VarNext,bitIndex369) )
            & ( v48177_13__array(VarNext,A,bitIndex16)
            <=> v50210(VarNext,bitIndex368) )
            & ( v48177_13__array(VarNext,A,bitIndex15)
            <=> v50210(VarNext,bitIndex367) )
            & ( v48177_13__array(VarNext,A,bitIndex14)
            <=> v50210(VarNext,bitIndex366) )
            & ( v48177_13__array(VarNext,A,bitIndex13)
            <=> v50210(VarNext,bitIndex365) )
            & ( v48177_13__array(VarNext,A,bitIndex12)
            <=> v50210(VarNext,bitIndex364) )
            & ( v48177_13__array(VarNext,A,bitIndex11)
            <=> v50210(VarNext,bitIndex363) )
            & ( v48177_13__array(VarNext,A,bitIndex10)
            <=> v50210(VarNext,bitIndex362) )
            & ( v48177_13__array(VarNext,A,bitIndex9)
            <=> v50210(VarNext,bitIndex361) )
            & ( v48177_13__array(VarNext,A,bitIndex8)
            <=> v50210(VarNext,bitIndex360) )
            & ( v48177_13__array(VarNext,A,bitIndex7)
            <=> v50210(VarNext,bitIndex359) )
            & ( v48177_13__array(VarNext,A,bitIndex6)
            <=> v50210(VarNext,bitIndex358) )
            & ( v48177_13__array(VarNext,A,bitIndex5)
            <=> v50210(VarNext,bitIndex357) )
            & ( v48177_13__array(VarNext,A,bitIndex4)
            <=> v50210(VarNext,bitIndex356) )
            & ( v48177_13__array(VarNext,A,bitIndex3)
            <=> v50210(VarNext,bitIndex355) )
            & ( v48177_13__array(VarNext,A,bitIndex2)
            <=> v50210(VarNext,bitIndex354) )
            & ( v48177_13__array(VarNext,A,bitIndex1)
            <=> v50210(VarNext,bitIndex353) )
            & ( v48177_13__array(VarNext,A,bitIndex0)
            <=> v50210(VarNext,bitIndex352) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10491,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50204(VarNext)
      <=> ( v50205(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10490,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50205(VarNext)
      <=> ( v50207(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4408,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50207(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_33,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00111_address_term = A
              & v50195(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_12__array(VarNext,A,B)
              <=> v48177_11__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_33,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00111_address_term = A
            & v50195(VarNext) )
         => ( ( v48177_12__array(VarNext,A,bitIndex43)
            <=> v50201(VarNext,bitIndex351) )
            & ( v48177_12__array(VarNext,A,bitIndex42)
            <=> v50201(VarNext,bitIndex350) )
            & ( v48177_12__array(VarNext,A,bitIndex41)
            <=> v50201(VarNext,bitIndex349) )
            & ( v48177_12__array(VarNext,A,bitIndex40)
            <=> v50201(VarNext,bitIndex348) )
            & ( v48177_12__array(VarNext,A,bitIndex39)
            <=> v50201(VarNext,bitIndex347) )
            & ( v48177_12__array(VarNext,A,bitIndex38)
            <=> v50201(VarNext,bitIndex346) )
            & ( v48177_12__array(VarNext,A,bitIndex37)
            <=> v50201(VarNext,bitIndex345) )
            & ( v48177_12__array(VarNext,A,bitIndex36)
            <=> v50201(VarNext,bitIndex344) )
            & ( v48177_12__array(VarNext,A,bitIndex35)
            <=> v50201(VarNext,bitIndex343) )
            & ( v48177_12__array(VarNext,A,bitIndex34)
            <=> v50201(VarNext,bitIndex342) )
            & ( v48177_12__array(VarNext,A,bitIndex33)
            <=> v50201(VarNext,bitIndex341) )
            & ( v48177_12__array(VarNext,A,bitIndex32)
            <=> v50201(VarNext,bitIndex340) )
            & ( v48177_12__array(VarNext,A,bitIndex31)
            <=> v50201(VarNext,bitIndex339) )
            & ( v48177_12__array(VarNext,A,bitIndex30)
            <=> v50201(VarNext,bitIndex338) )
            & ( v48177_12__array(VarNext,A,bitIndex29)
            <=> v50201(VarNext,bitIndex337) )
            & ( v48177_12__array(VarNext,A,bitIndex28)
            <=> v50201(VarNext,bitIndex336) )
            & ( v48177_12__array(VarNext,A,bitIndex27)
            <=> v50201(VarNext,bitIndex335) )
            & ( v48177_12__array(VarNext,A,bitIndex26)
            <=> v50201(VarNext,bitIndex334) )
            & ( v48177_12__array(VarNext,A,bitIndex25)
            <=> v50201(VarNext,bitIndex333) )
            & ( v48177_12__array(VarNext,A,bitIndex24)
            <=> v50201(VarNext,bitIndex332) )
            & ( v48177_12__array(VarNext,A,bitIndex23)
            <=> v50201(VarNext,bitIndex331) )
            & ( v48177_12__array(VarNext,A,bitIndex22)
            <=> v50201(VarNext,bitIndex330) )
            & ( v48177_12__array(VarNext,A,bitIndex21)
            <=> v50201(VarNext,bitIndex329) )
            & ( v48177_12__array(VarNext,A,bitIndex20)
            <=> v50201(VarNext,bitIndex328) )
            & ( v48177_12__array(VarNext,A,bitIndex19)
            <=> v50201(VarNext,bitIndex327) )
            & ( v48177_12__array(VarNext,A,bitIndex18)
            <=> v50201(VarNext,bitIndex326) )
            & ( v48177_12__array(VarNext,A,bitIndex17)
            <=> v50201(VarNext,bitIndex325) )
            & ( v48177_12__array(VarNext,A,bitIndex16)
            <=> v50201(VarNext,bitIndex324) )
            & ( v48177_12__array(VarNext,A,bitIndex15)
            <=> v50201(VarNext,bitIndex323) )
            & ( v48177_12__array(VarNext,A,bitIndex14)
            <=> v50201(VarNext,bitIndex322) )
            & ( v48177_12__array(VarNext,A,bitIndex13)
            <=> v50201(VarNext,bitIndex321) )
            & ( v48177_12__array(VarNext,A,bitIndex12)
            <=> v50201(VarNext,bitIndex320) )
            & ( v48177_12__array(VarNext,A,bitIndex11)
            <=> v50201(VarNext,bitIndex319) )
            & ( v48177_12__array(VarNext,A,bitIndex10)
            <=> v50201(VarNext,bitIndex318) )
            & ( v48177_12__array(VarNext,A,bitIndex9)
            <=> v50201(VarNext,bitIndex317) )
            & ( v48177_12__array(VarNext,A,bitIndex8)
            <=> v50201(VarNext,bitIndex316) )
            & ( v48177_12__array(VarNext,A,bitIndex7)
            <=> v50201(VarNext,bitIndex315) )
            & ( v48177_12__array(VarNext,A,bitIndex6)
            <=> v50201(VarNext,bitIndex314) )
            & ( v48177_12__array(VarNext,A,bitIndex5)
            <=> v50201(VarNext,bitIndex313) )
            & ( v48177_12__array(VarNext,A,bitIndex4)
            <=> v50201(VarNext,bitIndex312) )
            & ( v48177_12__array(VarNext,A,bitIndex3)
            <=> v50201(VarNext,bitIndex311) )
            & ( v48177_12__array(VarNext,A,bitIndex2)
            <=> v50201(VarNext,bitIndex310) )
            & ( v48177_12__array(VarNext,A,bitIndex1)
            <=> v50201(VarNext,bitIndex309) )
            & ( v48177_12__array(VarNext,A,bitIndex0)
            <=> v50201(VarNext,bitIndex308) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10489,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50195(VarNext)
      <=> ( v50196(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10488,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50196(VarNext)
      <=> ( v50198(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4407,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50198(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_32,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00110_address_term = A
              & v50186(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_11__array(VarNext,A,B)
              <=> v48177_10__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_32,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00110_address_term = A
            & v50186(VarNext) )
         => ( ( v48177_11__array(VarNext,A,bitIndex43)
            <=> v50192(VarNext,bitIndex307) )
            & ( v48177_11__array(VarNext,A,bitIndex42)
            <=> v50192(VarNext,bitIndex306) )
            & ( v48177_11__array(VarNext,A,bitIndex41)
            <=> v50192(VarNext,bitIndex305) )
            & ( v48177_11__array(VarNext,A,bitIndex40)
            <=> v50192(VarNext,bitIndex304) )
            & ( v48177_11__array(VarNext,A,bitIndex39)
            <=> v50192(VarNext,bitIndex303) )
            & ( v48177_11__array(VarNext,A,bitIndex38)
            <=> v50192(VarNext,bitIndex302) )
            & ( v48177_11__array(VarNext,A,bitIndex37)
            <=> v50192(VarNext,bitIndex301) )
            & ( v48177_11__array(VarNext,A,bitIndex36)
            <=> v50192(VarNext,bitIndex300) )
            & ( v48177_11__array(VarNext,A,bitIndex35)
            <=> v50192(VarNext,bitIndex299) )
            & ( v48177_11__array(VarNext,A,bitIndex34)
            <=> v50192(VarNext,bitIndex298) )
            & ( v48177_11__array(VarNext,A,bitIndex33)
            <=> v50192(VarNext,bitIndex297) )
            & ( v48177_11__array(VarNext,A,bitIndex32)
            <=> v50192(VarNext,bitIndex296) )
            & ( v48177_11__array(VarNext,A,bitIndex31)
            <=> v50192(VarNext,bitIndex295) )
            & ( v48177_11__array(VarNext,A,bitIndex30)
            <=> v50192(VarNext,bitIndex294) )
            & ( v48177_11__array(VarNext,A,bitIndex29)
            <=> v50192(VarNext,bitIndex293) )
            & ( v48177_11__array(VarNext,A,bitIndex28)
            <=> v50192(VarNext,bitIndex292) )
            & ( v48177_11__array(VarNext,A,bitIndex27)
            <=> v50192(VarNext,bitIndex291) )
            & ( v48177_11__array(VarNext,A,bitIndex26)
            <=> v50192(VarNext,bitIndex290) )
            & ( v48177_11__array(VarNext,A,bitIndex25)
            <=> v50192(VarNext,bitIndex289) )
            & ( v48177_11__array(VarNext,A,bitIndex24)
            <=> v50192(VarNext,bitIndex288) )
            & ( v48177_11__array(VarNext,A,bitIndex23)
            <=> v50192(VarNext,bitIndex287) )
            & ( v48177_11__array(VarNext,A,bitIndex22)
            <=> v50192(VarNext,bitIndex286) )
            & ( v48177_11__array(VarNext,A,bitIndex21)
            <=> v50192(VarNext,bitIndex285) )
            & ( v48177_11__array(VarNext,A,bitIndex20)
            <=> v50192(VarNext,bitIndex284) )
            & ( v48177_11__array(VarNext,A,bitIndex19)
            <=> v50192(VarNext,bitIndex283) )
            & ( v48177_11__array(VarNext,A,bitIndex18)
            <=> v50192(VarNext,bitIndex282) )
            & ( v48177_11__array(VarNext,A,bitIndex17)
            <=> v50192(VarNext,bitIndex281) )
            & ( v48177_11__array(VarNext,A,bitIndex16)
            <=> v50192(VarNext,bitIndex280) )
            & ( v48177_11__array(VarNext,A,bitIndex15)
            <=> v50192(VarNext,bitIndex279) )
            & ( v48177_11__array(VarNext,A,bitIndex14)
            <=> v50192(VarNext,bitIndex278) )
            & ( v48177_11__array(VarNext,A,bitIndex13)
            <=> v50192(VarNext,bitIndex277) )
            & ( v48177_11__array(VarNext,A,bitIndex12)
            <=> v50192(VarNext,bitIndex276) )
            & ( v48177_11__array(VarNext,A,bitIndex11)
            <=> v50192(VarNext,bitIndex275) )
            & ( v48177_11__array(VarNext,A,bitIndex10)
            <=> v50192(VarNext,bitIndex274) )
            & ( v48177_11__array(VarNext,A,bitIndex9)
            <=> v50192(VarNext,bitIndex273) )
            & ( v48177_11__array(VarNext,A,bitIndex8)
            <=> v50192(VarNext,bitIndex272) )
            & ( v48177_11__array(VarNext,A,bitIndex7)
            <=> v50192(VarNext,bitIndex271) )
            & ( v48177_11__array(VarNext,A,bitIndex6)
            <=> v50192(VarNext,bitIndex270) )
            & ( v48177_11__array(VarNext,A,bitIndex5)
            <=> v50192(VarNext,bitIndex269) )
            & ( v48177_11__array(VarNext,A,bitIndex4)
            <=> v50192(VarNext,bitIndex268) )
            & ( v48177_11__array(VarNext,A,bitIndex3)
            <=> v50192(VarNext,bitIndex267) )
            & ( v48177_11__array(VarNext,A,bitIndex2)
            <=> v50192(VarNext,bitIndex266) )
            & ( v48177_11__array(VarNext,A,bitIndex1)
            <=> v50192(VarNext,bitIndex265) )
            & ( v48177_11__array(VarNext,A,bitIndex0)
            <=> v50192(VarNext,bitIndex264) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10487,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50186(VarNext)
      <=> ( v50187(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10486,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50187(VarNext)
      <=> ( v50189(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4406,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50189(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_31,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00101_address_term = A
              & v50177(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_10__array(VarNext,A,B)
              <=> v48177_9__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_31,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00101_address_term = A
            & v50177(VarNext) )
         => ( ( v48177_10__array(VarNext,A,bitIndex43)
            <=> v50183(VarNext,bitIndex263) )
            & ( v48177_10__array(VarNext,A,bitIndex42)
            <=> v50183(VarNext,bitIndex262) )
            & ( v48177_10__array(VarNext,A,bitIndex41)
            <=> v50183(VarNext,bitIndex261) )
            & ( v48177_10__array(VarNext,A,bitIndex40)
            <=> v50183(VarNext,bitIndex260) )
            & ( v48177_10__array(VarNext,A,bitIndex39)
            <=> v50183(VarNext,bitIndex259) )
            & ( v48177_10__array(VarNext,A,bitIndex38)
            <=> v50183(VarNext,bitIndex258) )
            & ( v48177_10__array(VarNext,A,bitIndex37)
            <=> v50183(VarNext,bitIndex257) )
            & ( v48177_10__array(VarNext,A,bitIndex36)
            <=> v50183(VarNext,bitIndex256) )
            & ( v48177_10__array(VarNext,A,bitIndex35)
            <=> v50183(VarNext,bitIndex255) )
            & ( v48177_10__array(VarNext,A,bitIndex34)
            <=> v50183(VarNext,bitIndex254) )
            & ( v48177_10__array(VarNext,A,bitIndex33)
            <=> v50183(VarNext,bitIndex253) )
            & ( v48177_10__array(VarNext,A,bitIndex32)
            <=> v50183(VarNext,bitIndex252) )
            & ( v48177_10__array(VarNext,A,bitIndex31)
            <=> v50183(VarNext,bitIndex251) )
            & ( v48177_10__array(VarNext,A,bitIndex30)
            <=> v50183(VarNext,bitIndex250) )
            & ( v48177_10__array(VarNext,A,bitIndex29)
            <=> v50183(VarNext,bitIndex249) )
            & ( v48177_10__array(VarNext,A,bitIndex28)
            <=> v50183(VarNext,bitIndex248) )
            & ( v48177_10__array(VarNext,A,bitIndex27)
            <=> v50183(VarNext,bitIndex247) )
            & ( v48177_10__array(VarNext,A,bitIndex26)
            <=> v50183(VarNext,bitIndex246) )
            & ( v48177_10__array(VarNext,A,bitIndex25)
            <=> v50183(VarNext,bitIndex245) )
            & ( v48177_10__array(VarNext,A,bitIndex24)
            <=> v50183(VarNext,bitIndex244) )
            & ( v48177_10__array(VarNext,A,bitIndex23)
            <=> v50183(VarNext,bitIndex243) )
            & ( v48177_10__array(VarNext,A,bitIndex22)
            <=> v50183(VarNext,bitIndex242) )
            & ( v48177_10__array(VarNext,A,bitIndex21)
            <=> v50183(VarNext,bitIndex241) )
            & ( v48177_10__array(VarNext,A,bitIndex20)
            <=> v50183(VarNext,bitIndex240) )
            & ( v48177_10__array(VarNext,A,bitIndex19)
            <=> v50183(VarNext,bitIndex239) )
            & ( v48177_10__array(VarNext,A,bitIndex18)
            <=> v50183(VarNext,bitIndex238) )
            & ( v48177_10__array(VarNext,A,bitIndex17)
            <=> v50183(VarNext,bitIndex237) )
            & ( v48177_10__array(VarNext,A,bitIndex16)
            <=> v50183(VarNext,bitIndex236) )
            & ( v48177_10__array(VarNext,A,bitIndex15)
            <=> v50183(VarNext,bitIndex235) )
            & ( v48177_10__array(VarNext,A,bitIndex14)
            <=> v50183(VarNext,bitIndex234) )
            & ( v48177_10__array(VarNext,A,bitIndex13)
            <=> v50183(VarNext,bitIndex233) )
            & ( v48177_10__array(VarNext,A,bitIndex12)
            <=> v50183(VarNext,bitIndex232) )
            & ( v48177_10__array(VarNext,A,bitIndex11)
            <=> v50183(VarNext,bitIndex231) )
            & ( v48177_10__array(VarNext,A,bitIndex10)
            <=> v50183(VarNext,bitIndex230) )
            & ( v48177_10__array(VarNext,A,bitIndex9)
            <=> v50183(VarNext,bitIndex229) )
            & ( v48177_10__array(VarNext,A,bitIndex8)
            <=> v50183(VarNext,bitIndex228) )
            & ( v48177_10__array(VarNext,A,bitIndex7)
            <=> v50183(VarNext,bitIndex227) )
            & ( v48177_10__array(VarNext,A,bitIndex6)
            <=> v50183(VarNext,bitIndex226) )
            & ( v48177_10__array(VarNext,A,bitIndex5)
            <=> v50183(VarNext,bitIndex225) )
            & ( v48177_10__array(VarNext,A,bitIndex4)
            <=> v50183(VarNext,bitIndex224) )
            & ( v48177_10__array(VarNext,A,bitIndex3)
            <=> v50183(VarNext,bitIndex223) )
            & ( v48177_10__array(VarNext,A,bitIndex2)
            <=> v50183(VarNext,bitIndex222) )
            & ( v48177_10__array(VarNext,A,bitIndex1)
            <=> v50183(VarNext,bitIndex221) )
            & ( v48177_10__array(VarNext,A,bitIndex0)
            <=> v50183(VarNext,bitIndex220) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10485,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50177(VarNext)
      <=> ( v50178(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10484,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50178(VarNext)
      <=> ( v50180(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4405,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50180(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_30,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00100_address_term = A
              & v50168(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_9__array(VarNext,A,B)
              <=> v48177_8__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_30,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00100_address_term = A
            & v50168(VarNext) )
         => ( ( v48177_9__array(VarNext,A,bitIndex43)
            <=> v50174(VarNext,bitIndex219) )
            & ( v48177_9__array(VarNext,A,bitIndex42)
            <=> v50174(VarNext,bitIndex218) )
            & ( v48177_9__array(VarNext,A,bitIndex41)
            <=> v50174(VarNext,bitIndex217) )
            & ( v48177_9__array(VarNext,A,bitIndex40)
            <=> v50174(VarNext,bitIndex216) )
            & ( v48177_9__array(VarNext,A,bitIndex39)
            <=> v50174(VarNext,bitIndex215) )
            & ( v48177_9__array(VarNext,A,bitIndex38)
            <=> v50174(VarNext,bitIndex214) )
            & ( v48177_9__array(VarNext,A,bitIndex37)
            <=> v50174(VarNext,bitIndex213) )
            & ( v48177_9__array(VarNext,A,bitIndex36)
            <=> v50174(VarNext,bitIndex212) )
            & ( v48177_9__array(VarNext,A,bitIndex35)
            <=> v50174(VarNext,bitIndex211) )
            & ( v48177_9__array(VarNext,A,bitIndex34)
            <=> v50174(VarNext,bitIndex210) )
            & ( v48177_9__array(VarNext,A,bitIndex33)
            <=> v50174(VarNext,bitIndex209) )
            & ( v48177_9__array(VarNext,A,bitIndex32)
            <=> v50174(VarNext,bitIndex208) )
            & ( v48177_9__array(VarNext,A,bitIndex31)
            <=> v50174(VarNext,bitIndex207) )
            & ( v48177_9__array(VarNext,A,bitIndex30)
            <=> v50174(VarNext,bitIndex206) )
            & ( v48177_9__array(VarNext,A,bitIndex29)
            <=> v50174(VarNext,bitIndex205) )
            & ( v48177_9__array(VarNext,A,bitIndex28)
            <=> v50174(VarNext,bitIndex204) )
            & ( v48177_9__array(VarNext,A,bitIndex27)
            <=> v50174(VarNext,bitIndex203) )
            & ( v48177_9__array(VarNext,A,bitIndex26)
            <=> v50174(VarNext,bitIndex202) )
            & ( v48177_9__array(VarNext,A,bitIndex25)
            <=> v50174(VarNext,bitIndex201) )
            & ( v48177_9__array(VarNext,A,bitIndex24)
            <=> v50174(VarNext,bitIndex200) )
            & ( v48177_9__array(VarNext,A,bitIndex23)
            <=> v50174(VarNext,bitIndex199) )
            & ( v48177_9__array(VarNext,A,bitIndex22)
            <=> v50174(VarNext,bitIndex198) )
            & ( v48177_9__array(VarNext,A,bitIndex21)
            <=> v50174(VarNext,bitIndex197) )
            & ( v48177_9__array(VarNext,A,bitIndex20)
            <=> v50174(VarNext,bitIndex196) )
            & ( v48177_9__array(VarNext,A,bitIndex19)
            <=> v50174(VarNext,bitIndex195) )
            & ( v48177_9__array(VarNext,A,bitIndex18)
            <=> v50174(VarNext,bitIndex194) )
            & ( v48177_9__array(VarNext,A,bitIndex17)
            <=> v50174(VarNext,bitIndex193) )
            & ( v48177_9__array(VarNext,A,bitIndex16)
            <=> v50174(VarNext,bitIndex192) )
            & ( v48177_9__array(VarNext,A,bitIndex15)
            <=> v50174(VarNext,bitIndex191) )
            & ( v48177_9__array(VarNext,A,bitIndex14)
            <=> v50174(VarNext,bitIndex190) )
            & ( v48177_9__array(VarNext,A,bitIndex13)
            <=> v50174(VarNext,bitIndex189) )
            & ( v48177_9__array(VarNext,A,bitIndex12)
            <=> v50174(VarNext,bitIndex188) )
            & ( v48177_9__array(VarNext,A,bitIndex11)
            <=> v50174(VarNext,bitIndex187) )
            & ( v48177_9__array(VarNext,A,bitIndex10)
            <=> v50174(VarNext,bitIndex186) )
            & ( v48177_9__array(VarNext,A,bitIndex9)
            <=> v50174(VarNext,bitIndex185) )
            & ( v48177_9__array(VarNext,A,bitIndex8)
            <=> v50174(VarNext,bitIndex184) )
            & ( v48177_9__array(VarNext,A,bitIndex7)
            <=> v50174(VarNext,bitIndex183) )
            & ( v48177_9__array(VarNext,A,bitIndex6)
            <=> v50174(VarNext,bitIndex182) )
            & ( v48177_9__array(VarNext,A,bitIndex5)
            <=> v50174(VarNext,bitIndex181) )
            & ( v48177_9__array(VarNext,A,bitIndex4)
            <=> v50174(VarNext,bitIndex180) )
            & ( v48177_9__array(VarNext,A,bitIndex3)
            <=> v50174(VarNext,bitIndex179) )
            & ( v48177_9__array(VarNext,A,bitIndex2)
            <=> v50174(VarNext,bitIndex178) )
            & ( v48177_9__array(VarNext,A,bitIndex1)
            <=> v50174(VarNext,bitIndex177) )
            & ( v48177_9__array(VarNext,A,bitIndex0)
            <=> v50174(VarNext,bitIndex176) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10483,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50168(VarNext)
      <=> ( v50169(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10482,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50169(VarNext)
      <=> ( v50171(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4404,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50171(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_29,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00011_address_term = A
              & v50159(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_8__array(VarNext,A,B)
              <=> v48177_7__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_29,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00011_address_term = A
            & v50159(VarNext) )
         => ( ( v48177_8__array(VarNext,A,bitIndex43)
            <=> v50165(VarNext,bitIndex175) )
            & ( v48177_8__array(VarNext,A,bitIndex42)
            <=> v50165(VarNext,bitIndex174) )
            & ( v48177_8__array(VarNext,A,bitIndex41)
            <=> v50165(VarNext,bitIndex173) )
            & ( v48177_8__array(VarNext,A,bitIndex40)
            <=> v50165(VarNext,bitIndex172) )
            & ( v48177_8__array(VarNext,A,bitIndex39)
            <=> v50165(VarNext,bitIndex171) )
            & ( v48177_8__array(VarNext,A,bitIndex38)
            <=> v50165(VarNext,bitIndex170) )
            & ( v48177_8__array(VarNext,A,bitIndex37)
            <=> v50165(VarNext,bitIndex169) )
            & ( v48177_8__array(VarNext,A,bitIndex36)
            <=> v50165(VarNext,bitIndex168) )
            & ( v48177_8__array(VarNext,A,bitIndex35)
            <=> v50165(VarNext,bitIndex167) )
            & ( v48177_8__array(VarNext,A,bitIndex34)
            <=> v50165(VarNext,bitIndex166) )
            & ( v48177_8__array(VarNext,A,bitIndex33)
            <=> v50165(VarNext,bitIndex165) )
            & ( v48177_8__array(VarNext,A,bitIndex32)
            <=> v50165(VarNext,bitIndex164) )
            & ( v48177_8__array(VarNext,A,bitIndex31)
            <=> v50165(VarNext,bitIndex163) )
            & ( v48177_8__array(VarNext,A,bitIndex30)
            <=> v50165(VarNext,bitIndex162) )
            & ( v48177_8__array(VarNext,A,bitIndex29)
            <=> v50165(VarNext,bitIndex161) )
            & ( v48177_8__array(VarNext,A,bitIndex28)
            <=> v50165(VarNext,bitIndex160) )
            & ( v48177_8__array(VarNext,A,bitIndex27)
            <=> v50165(VarNext,bitIndex159) )
            & ( v48177_8__array(VarNext,A,bitIndex26)
            <=> v50165(VarNext,bitIndex158) )
            & ( v48177_8__array(VarNext,A,bitIndex25)
            <=> v50165(VarNext,bitIndex157) )
            & ( v48177_8__array(VarNext,A,bitIndex24)
            <=> v50165(VarNext,bitIndex156) )
            & ( v48177_8__array(VarNext,A,bitIndex23)
            <=> v50165(VarNext,bitIndex155) )
            & ( v48177_8__array(VarNext,A,bitIndex22)
            <=> v50165(VarNext,bitIndex154) )
            & ( v48177_8__array(VarNext,A,bitIndex21)
            <=> v50165(VarNext,bitIndex153) )
            & ( v48177_8__array(VarNext,A,bitIndex20)
            <=> v50165(VarNext,bitIndex152) )
            & ( v48177_8__array(VarNext,A,bitIndex19)
            <=> v50165(VarNext,bitIndex151) )
            & ( v48177_8__array(VarNext,A,bitIndex18)
            <=> v50165(VarNext,bitIndex150) )
            & ( v48177_8__array(VarNext,A,bitIndex17)
            <=> v50165(VarNext,bitIndex149) )
            & ( v48177_8__array(VarNext,A,bitIndex16)
            <=> v50165(VarNext,bitIndex148) )
            & ( v48177_8__array(VarNext,A,bitIndex15)
            <=> v50165(VarNext,bitIndex147) )
            & ( v48177_8__array(VarNext,A,bitIndex14)
            <=> v50165(VarNext,bitIndex146) )
            & ( v48177_8__array(VarNext,A,bitIndex13)
            <=> v50165(VarNext,bitIndex145) )
            & ( v48177_8__array(VarNext,A,bitIndex12)
            <=> v50165(VarNext,bitIndex144) )
            & ( v48177_8__array(VarNext,A,bitIndex11)
            <=> v50165(VarNext,bitIndex143) )
            & ( v48177_8__array(VarNext,A,bitIndex10)
            <=> v50165(VarNext,bitIndex142) )
            & ( v48177_8__array(VarNext,A,bitIndex9)
            <=> v50165(VarNext,bitIndex141) )
            & ( v48177_8__array(VarNext,A,bitIndex8)
            <=> v50165(VarNext,bitIndex140) )
            & ( v48177_8__array(VarNext,A,bitIndex7)
            <=> v50165(VarNext,bitIndex139) )
            & ( v48177_8__array(VarNext,A,bitIndex6)
            <=> v50165(VarNext,bitIndex138) )
            & ( v48177_8__array(VarNext,A,bitIndex5)
            <=> v50165(VarNext,bitIndex137) )
            & ( v48177_8__array(VarNext,A,bitIndex4)
            <=> v50165(VarNext,bitIndex136) )
            & ( v48177_8__array(VarNext,A,bitIndex3)
            <=> v50165(VarNext,bitIndex135) )
            & ( v48177_8__array(VarNext,A,bitIndex2)
            <=> v50165(VarNext,bitIndex134) )
            & ( v48177_8__array(VarNext,A,bitIndex1)
            <=> v50165(VarNext,bitIndex133) )
            & ( v48177_8__array(VarNext,A,bitIndex0)
            <=> v50165(VarNext,bitIndex132) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10481,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50159(VarNext)
      <=> ( v50160(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10480,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50160(VarNext)
      <=> ( v50162(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4403,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50162(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_28,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00010_address_term = A
              & v50150(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_7__array(VarNext,A,B)
              <=> v48177_6__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_28,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00010_address_term = A
            & v50150(VarNext) )
         => ( ( v48177_7__array(VarNext,A,bitIndex43)
            <=> v50156(VarNext,bitIndex131) )
            & ( v48177_7__array(VarNext,A,bitIndex42)
            <=> v50156(VarNext,bitIndex130) )
            & ( v48177_7__array(VarNext,A,bitIndex41)
            <=> v50156(VarNext,bitIndex129) )
            & ( v48177_7__array(VarNext,A,bitIndex40)
            <=> v50156(VarNext,bitIndex128) )
            & ( v48177_7__array(VarNext,A,bitIndex39)
            <=> v50156(VarNext,bitIndex127) )
            & ( v48177_7__array(VarNext,A,bitIndex38)
            <=> v50156(VarNext,bitIndex126) )
            & ( v48177_7__array(VarNext,A,bitIndex37)
            <=> v50156(VarNext,bitIndex125) )
            & ( v48177_7__array(VarNext,A,bitIndex36)
            <=> v50156(VarNext,bitIndex124) )
            & ( v48177_7__array(VarNext,A,bitIndex35)
            <=> v50156(VarNext,bitIndex123) )
            & ( v48177_7__array(VarNext,A,bitIndex34)
            <=> v50156(VarNext,bitIndex122) )
            & ( v48177_7__array(VarNext,A,bitIndex33)
            <=> v50156(VarNext,bitIndex121) )
            & ( v48177_7__array(VarNext,A,bitIndex32)
            <=> v50156(VarNext,bitIndex120) )
            & ( v48177_7__array(VarNext,A,bitIndex31)
            <=> v50156(VarNext,bitIndex119) )
            & ( v48177_7__array(VarNext,A,bitIndex30)
            <=> v50156(VarNext,bitIndex118) )
            & ( v48177_7__array(VarNext,A,bitIndex29)
            <=> v50156(VarNext,bitIndex117) )
            & ( v48177_7__array(VarNext,A,bitIndex28)
            <=> v50156(VarNext,bitIndex116) )
            & ( v48177_7__array(VarNext,A,bitIndex27)
            <=> v50156(VarNext,bitIndex115) )
            & ( v48177_7__array(VarNext,A,bitIndex26)
            <=> v50156(VarNext,bitIndex114) )
            & ( v48177_7__array(VarNext,A,bitIndex25)
            <=> v50156(VarNext,bitIndex113) )
            & ( v48177_7__array(VarNext,A,bitIndex24)
            <=> v50156(VarNext,bitIndex112) )
            & ( v48177_7__array(VarNext,A,bitIndex23)
            <=> v50156(VarNext,bitIndex111) )
            & ( v48177_7__array(VarNext,A,bitIndex22)
            <=> v50156(VarNext,bitIndex110) )
            & ( v48177_7__array(VarNext,A,bitIndex21)
            <=> v50156(VarNext,bitIndex109) )
            & ( v48177_7__array(VarNext,A,bitIndex20)
            <=> v50156(VarNext,bitIndex108) )
            & ( v48177_7__array(VarNext,A,bitIndex19)
            <=> v50156(VarNext,bitIndex107) )
            & ( v48177_7__array(VarNext,A,bitIndex18)
            <=> v50156(VarNext,bitIndex106) )
            & ( v48177_7__array(VarNext,A,bitIndex17)
            <=> v50156(VarNext,bitIndex105) )
            & ( v48177_7__array(VarNext,A,bitIndex16)
            <=> v50156(VarNext,bitIndex104) )
            & ( v48177_7__array(VarNext,A,bitIndex15)
            <=> v50156(VarNext,bitIndex103) )
            & ( v48177_7__array(VarNext,A,bitIndex14)
            <=> v50156(VarNext,bitIndex102) )
            & ( v48177_7__array(VarNext,A,bitIndex13)
            <=> v50156(VarNext,bitIndex101) )
            & ( v48177_7__array(VarNext,A,bitIndex12)
            <=> v50156(VarNext,bitIndex100) )
            & ( v48177_7__array(VarNext,A,bitIndex11)
            <=> v50156(VarNext,bitIndex99) )
            & ( v48177_7__array(VarNext,A,bitIndex10)
            <=> v50156(VarNext,bitIndex98) )
            & ( v48177_7__array(VarNext,A,bitIndex9)
            <=> v50156(VarNext,bitIndex97) )
            & ( v48177_7__array(VarNext,A,bitIndex8)
            <=> v50156(VarNext,bitIndex96) )
            & ( v48177_7__array(VarNext,A,bitIndex7)
            <=> v50156(VarNext,bitIndex95) )
            & ( v48177_7__array(VarNext,A,bitIndex6)
            <=> v50156(VarNext,bitIndex94) )
            & ( v48177_7__array(VarNext,A,bitIndex5)
            <=> v50156(VarNext,bitIndex93) )
            & ( v48177_7__array(VarNext,A,bitIndex4)
            <=> v50156(VarNext,bitIndex92) )
            & ( v48177_7__array(VarNext,A,bitIndex3)
            <=> v50156(VarNext,bitIndex91) )
            & ( v48177_7__array(VarNext,A,bitIndex2)
            <=> v50156(VarNext,bitIndex90) )
            & ( v48177_7__array(VarNext,A,bitIndex1)
            <=> v50156(VarNext,bitIndex89) )
            & ( v48177_7__array(VarNext,A,bitIndex0)
            <=> v50156(VarNext,bitIndex88) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10479,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50150(VarNext)
      <=> ( v50151(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10478,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50151(VarNext)
      <=> ( v50153(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4402,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50153(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_27,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00001_address_term = A
              & v50141(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_6__array(VarNext,A,B)
              <=> v48177_5__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_27,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00001_address_term = A
            & v50141(VarNext) )
         => ( ( v48177_6__array(VarNext,A,bitIndex43)
            <=> v50147(VarNext,bitIndex87) )
            & ( v48177_6__array(VarNext,A,bitIndex42)
            <=> v50147(VarNext,bitIndex86) )
            & ( v48177_6__array(VarNext,A,bitIndex41)
            <=> v50147(VarNext,bitIndex85) )
            & ( v48177_6__array(VarNext,A,bitIndex40)
            <=> v50147(VarNext,bitIndex84) )
            & ( v48177_6__array(VarNext,A,bitIndex39)
            <=> v50147(VarNext,bitIndex83) )
            & ( v48177_6__array(VarNext,A,bitIndex38)
            <=> v50147(VarNext,bitIndex82) )
            & ( v48177_6__array(VarNext,A,bitIndex37)
            <=> v50147(VarNext,bitIndex81) )
            & ( v48177_6__array(VarNext,A,bitIndex36)
            <=> v50147(VarNext,bitIndex80) )
            & ( v48177_6__array(VarNext,A,bitIndex35)
            <=> v50147(VarNext,bitIndex79) )
            & ( v48177_6__array(VarNext,A,bitIndex34)
            <=> v50147(VarNext,bitIndex78) )
            & ( v48177_6__array(VarNext,A,bitIndex33)
            <=> v50147(VarNext,bitIndex77) )
            & ( v48177_6__array(VarNext,A,bitIndex32)
            <=> v50147(VarNext,bitIndex76) )
            & ( v48177_6__array(VarNext,A,bitIndex31)
            <=> v50147(VarNext,bitIndex75) )
            & ( v48177_6__array(VarNext,A,bitIndex30)
            <=> v50147(VarNext,bitIndex74) )
            & ( v48177_6__array(VarNext,A,bitIndex29)
            <=> v50147(VarNext,bitIndex73) )
            & ( v48177_6__array(VarNext,A,bitIndex28)
            <=> v50147(VarNext,bitIndex72) )
            & ( v48177_6__array(VarNext,A,bitIndex27)
            <=> v50147(VarNext,bitIndex71) )
            & ( v48177_6__array(VarNext,A,bitIndex26)
            <=> v50147(VarNext,bitIndex70) )
            & ( v48177_6__array(VarNext,A,bitIndex25)
            <=> v50147(VarNext,bitIndex69) )
            & ( v48177_6__array(VarNext,A,bitIndex24)
            <=> v50147(VarNext,bitIndex68) )
            & ( v48177_6__array(VarNext,A,bitIndex23)
            <=> v50147(VarNext,bitIndex67) )
            & ( v48177_6__array(VarNext,A,bitIndex22)
            <=> v50147(VarNext,bitIndex66) )
            & ( v48177_6__array(VarNext,A,bitIndex21)
            <=> v50147(VarNext,bitIndex65) )
            & ( v48177_6__array(VarNext,A,bitIndex20)
            <=> v50147(VarNext,bitIndex64) )
            & ( v48177_6__array(VarNext,A,bitIndex19)
            <=> v50147(VarNext,bitIndex63) )
            & ( v48177_6__array(VarNext,A,bitIndex18)
            <=> v50147(VarNext,bitIndex62) )
            & ( v48177_6__array(VarNext,A,bitIndex17)
            <=> v50147(VarNext,bitIndex61) )
            & ( v48177_6__array(VarNext,A,bitIndex16)
            <=> v50147(VarNext,bitIndex60) )
            & ( v48177_6__array(VarNext,A,bitIndex15)
            <=> v50147(VarNext,bitIndex59) )
            & ( v48177_6__array(VarNext,A,bitIndex14)
            <=> v50147(VarNext,bitIndex58) )
            & ( v48177_6__array(VarNext,A,bitIndex13)
            <=> v50147(VarNext,bitIndex57) )
            & ( v48177_6__array(VarNext,A,bitIndex12)
            <=> v50147(VarNext,bitIndex56) )
            & ( v48177_6__array(VarNext,A,bitIndex11)
            <=> v50147(VarNext,bitIndex55) )
            & ( v48177_6__array(VarNext,A,bitIndex10)
            <=> v50147(VarNext,bitIndex54) )
            & ( v48177_6__array(VarNext,A,bitIndex9)
            <=> v50147(VarNext,bitIndex53) )
            & ( v48177_6__array(VarNext,A,bitIndex8)
            <=> v50147(VarNext,bitIndex52) )
            & ( v48177_6__array(VarNext,A,bitIndex7)
            <=> v50147(VarNext,bitIndex51) )
            & ( v48177_6__array(VarNext,A,bitIndex6)
            <=> v50147(VarNext,bitIndex50) )
            & ( v48177_6__array(VarNext,A,bitIndex5)
            <=> v50147(VarNext,bitIndex49) )
            & ( v48177_6__array(VarNext,A,bitIndex4)
            <=> v50147(VarNext,bitIndex48) )
            & ( v48177_6__array(VarNext,A,bitIndex3)
            <=> v50147(VarNext,bitIndex47) )
            & ( v48177_6__array(VarNext,A,bitIndex2)
            <=> v50147(VarNext,bitIndex46) )
            & ( v48177_6__array(VarNext,A,bitIndex1)
            <=> v50147(VarNext,bitIndex45) )
            & ( v48177_6__array(VarNext,A,bitIndex0)
            <=> v50147(VarNext,bitIndex44) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10477,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50141(VarNext)
      <=> ( v50142(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10476,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50142(VarNext)
      <=> ( v50144(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4401,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50144(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_26,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ~ ( b00000_address_term = A
              & v50127(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_5__array(VarNext,A,B)
              <=> v48177_4__array(VarNext,A,B) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_26,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( ( b00000_address_term = A
            & v50127(VarNext) )
         => ! [B] :
              ( range_43_0(B)
             => ( v48177_5__array(VarNext,A,B)
              <=> v50138(VarNext,B) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10475,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50127(VarNext)
      <=> ( v50128(VarNext)
          & v50134(VarNext) ) ) ) ).

fof(addAssignment_18819,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50134(VarNext)
      <=> v50132(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10474,axiom,
    ! [VarCurr] :
      ( v50132(VarCurr)
    <=> ( v50090(VarCurr)
        & v50135(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3128,axiom,
    ! [VarCurr] :
      ( v50135(VarCurr)
    <=> ( ( v50136(VarCurr,bitIndex1)
        <=> $false )
        & ( v50136(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_18818,axiom,
    ! [VarCurr] :
      ( v50136(VarCurr,bitIndex0)
    <=> v48337(VarCurr) ) ).

fof(addAssignment_18817,axiom,
    ! [VarCurr] :
      ( v50136(VarCurr,bitIndex1)
    <=> v48188(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10473,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50128(VarNext)
      <=> ( v50130(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4400,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50130(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_25,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v49218_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ~ ( A = AssociatedAddressVar
                  & v50115(VarNext) )
             => ! [B] :
                  ( range_43_0(B)
                 => ( v48177_4__array(VarNext,A,B)
                  <=> v48177_3__array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_25,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v49218_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ( A = AssociatedAddressVar
                & v50115(VarNext) )
             => ! [B] :
                  ( range_43_0(B)
                 => ( v48177_4__array(VarNext,A,B)
                  <=> v48651(VarNext,B) ) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10472,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50115(VarNext)
      <=> ( v50116(VarNext)
          & v50122(VarNext) ) ) ) ).

fof(addAssignment_18816,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50122(VarNext)
      <=> v50120(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10471,axiom,
    ! [VarCurr] :
      ( v50120(VarCurr)
    <=> ( v50090(VarCurr)
        & v50123(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3127,axiom,
    ! [VarCurr] :
      ( v50123(VarCurr)
    <=> ( ( v50124(VarCurr,bitIndex1)
        <=> $true )
        & ( v50124(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_18815,axiom,
    ! [VarCurr] :
      ( v50124(VarCurr,bitIndex0)
    <=> v48337(VarCurr) ) ).

fof(addAssignment_18814,axiom,
    ! [VarCurr] :
      ( v50124(VarCurr,bitIndex1)
    <=> v48188(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10470,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50116(VarNext)
      <=> ( v50118(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4399,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50118(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_24,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v49258_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ~ ( A = AssociatedAddressVar
                  & v50103(VarNext) )
             => ! [B] :
                  ( range_43_0(B)
                 => ( v48177_3__array(VarNext,A,B)
                  <=> v48177_2__array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_24,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v49258_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ( A = AssociatedAddressVar
                & v50103(VarNext) )
             => ! [B] :
                  ( range_43_0(B)
                 => ( v48177_3__array(VarNext,A,B)
                  <=> v49250(VarNext,B) ) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10469,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50103(VarNext)
      <=> ( v50104(VarNext)
          & v50110(VarNext) ) ) ) ).

fof(addAssignment_18813,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50110(VarNext)
      <=> v50108(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10468,axiom,
    ! [VarCurr] :
      ( v50108(VarCurr)
    <=> ( v50090(VarCurr)
        & v50111(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3126,axiom,
    ! [VarCurr] :
      ( v50111(VarCurr)
    <=> ( ( v50112(VarCurr,bitIndex1)
        <=> $false )
        & ( v50112(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_18812,axiom,
    ! [VarCurr] :
      ( v50112(VarCurr,bitIndex0)
    <=> v48337(VarCurr) ) ).

fof(addAssignment_18811,axiom,
    ! [VarCurr] :
      ( v50112(VarCurr,bitIndex1)
    <=> v48188(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10467,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50104(VarNext)
      <=> ( v50106(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4398,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50106(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_23,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v49258_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ~ ( A = AssociatedAddressVar
                  & v50096(VarNext) )
             => ! [B] :
                  ( range_43_0(B)
                 => ( v48177_2__array(VarNext,A,B)
                  <=> v48177_1__array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_23,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v49258_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ( A = AssociatedAddressVar
                & v50096(VarNext) )
             => ! [B] :
                  ( range_43_0(B)
                 => ( v48177_2__array(VarNext,A,B)
                  <=> v49250(VarNext,B) ) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10466,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50096(VarNext)
      <=> ( v50097(VarNext)
          & v50089(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10465,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50097(VarNext)
      <=> ( v50099(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4397,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50099(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(memoryWriteDisabled_22,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v49218_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ~ ( A = AssociatedAddressVar
                  & v50080(VarNext) )
             => ! [B] :
                  ( range_43_0(B)
                 => ( v48177_1__array(VarNext,A,B)
                  <=> v48177_array(VarCurr,A,B) ) ) ) ) ) ).

fof(memoryWriteEnabledInsideRange_22,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [AssociatedAddressVar] :
          ( v49218_range_4_to_0_address_association(VarNext,AssociatedAddressVar)
         => ! [A] :
              ( ( A = AssociatedAddressVar
                & v50080(VarNext) )
             => ! [B] :
                  ( range_43_0(B)
                 => ( v48177_1__array(VarNext,A,B)
                  <=> v48651(VarNext,B) ) ) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10464,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50080(VarNext)
      <=> ( v50081(VarNext)
          & v50089(VarNext) ) ) ) ).

fof(addAssignment_18810,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50089(VarNext)
      <=> v50087(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10463,axiom,
    ! [VarCurr] :
      ( v50087(VarCurr)
    <=> ( v50090(VarCurr)
        & v50092(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3125,axiom,
    ! [VarCurr] :
      ( v50092(VarCurr)
    <=> ( ( v50093(VarCurr,bitIndex1)
        <=> $true )
        & ( v50093(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_18809,axiom,
    ! [VarCurr] :
      ( v50093(VarCurr,bitIndex0)
    <=> v48337(VarCurr) ) ).

fof(addAssignment_18808,axiom,
    ! [VarCurr] :
      ( v50093(VarCurr,bitIndex1)
    <=> v48188(VarCurr) ) ).

fof(writeUnaryOperator_4396,axiom,
    ! [VarCurr] :
      ( ~ v50090(VarCurr)
    <=> v50091(VarCurr) ) ).

fof(writeUnaryOperator_4395,axiom,
    ! [VarCurr] :
      ( ~ v50091(VarCurr)
    <=> v48184(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10462,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50081(VarNext)
      <=> ( v50082(VarNext)
          & v48179(VarNext) ) ) ) ).

fof(writeUnaryOperator_4394,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50082(VarNext)
      <=> v50084(VarNext) ) ) ).

fof(addAssignment_18807,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50084(VarNext)
      <=> v48179(VarCurr) ) ) ).

fof(addAssignment_18806,axiom,
    ! [VarCurr,B] :
      ( range_43_0(B)
     => ( v49250(VarCurr,B)
      <=> v49252(VarCurr,B) ) ) ).

fof(addAssignment_18805,axiom,
    ! [VarCurr,B] :
      ( range_43_0(B)
     => ( v49252(VarCurr,B)
      <=> v49254(VarCurr,B) ) ) ).

fof(addAssignment_18804,axiom,
    ! [VarCurr,B] :
      ( range_43_0(B)
     => ( v49254(VarCurr,B)
      <=> v49256(VarCurr,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_972,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50059(VarNext)
       => ! [B] :
            ( range_43_0(B)
           => ( v49256(VarNext,B)
            <=> v49256(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1035,axiom,
    ! [VarNext] :
      ( v50059(VarNext)
     => ! [B] :
          ( range_43_0(B)
         => ( v49256(VarNext,B)
          <=> v50070(VarNext,B) ) ) ) ).

fof(addAssignment_18803,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_43_0(B)
         => ( v50070(VarNext,B)
          <=> v50068(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1577,axiom,
    ! [VarCurr] :
      ( ~ v48464(VarCurr)
     => ! [B] :
          ( range_43_0(B)
         => ( v50068(VarCurr,B)
          <=> v50071(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1411,axiom,
    ! [VarCurr] :
      ( v48464(VarCurr)
     => ! [B] :
          ( range_43_0(B)
         => ( v50068(VarCurr,B)
          <=> $false ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1576,axiom,
    ! [VarCurr] :
      ( ~ v47899(VarCurr)
     => ! [B] :
          ( range_43_0(B)
         => ( v50071(VarCurr,B)
          <=> v50074(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1410,axiom,
    ! [VarCurr] :
      ( v47899(VarCurr)
     => ! [B] :
          ( range_43_0(B)
         => ( v50071(VarCurr,B)
          <=> v50072(VarCurr,B) ) ) ) ).

fof(addAssignment_18802,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v50074(VarCurr,B)
      <=> v49983(VarCurr,B) ) ) ).

fof(addAssignment_18801,axiom,
    ! [VarCurr,B] :
      ( range_43_32(B)
     => ( v50074(VarCurr,B)
      <=> v48649(VarCurr,B) ) ) ).

fof(addAssignment_18800,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v50072(VarCurr,B)
      <=> v50073(VarCurr,B) ) ) ).

fof(addAssignment_18799,axiom,
    ! [VarCurr,B] :
      ( range_43_32(B)
     => ( v50072(VarCurr,B)
      <=> v48649(VarCurr,B) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_211,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v50073(VarCurr,B)
      <=> ( v49524(VarCurr,B)
          & v48167(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10461,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50059(VarNext)
      <=> ( v50060(VarNext)
          & v50067(VarNext) ) ) ) ).

fof(addAssignment_18798,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50067(VarNext)
      <=> v50065(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10460,axiom,
    ! [VarCurr] :
      ( v50065(VarCurr)
    <=> ( v48345(VarCurr)
        | v48464(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10459,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v50060(VarNext)
      <=> ( v50062(VarNext)
          & v45620(VarNext) ) ) ) ).

fof(writeUnaryOperator_4393,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v50062(VarNext)
      <=> v47885(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1575,axiom,
    ! [VarCurr] :
      ( ~ v50051(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v49983(VarCurr,B)
          <=> v48167(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1409,axiom,
    ! [VarCurr] :
      ( v50051(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v49983(VarCurr,B)
          <=> v50056(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_210,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v50056(VarCurr,B)
      <=> ( v49985(VarCurr,B)
          & v48167(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10458,axiom,
    ! [VarCurr] :
      ( v50051(VarCurr)
    <=> ( v50052(VarCurr)
        & v50055(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3124,axiom,
    ! [VarCurr] :
      ( v50055(VarCurr)
    <=> ( v47941(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10457,axiom,
    ! [VarCurr] :
      ( v50052(VarCurr)
    <=> ( v50053(VarCurr)
        | v50054(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_3123,axiom,
    ! [VarCurr] :
      ( v50054(VarCurr)
    <=> ( ( v46454(VarCurr,bitIndex2)
        <=> $false )
        & ( v46454(VarCurr,bitIndex1)
        <=> $false )
        & ( v46454(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_3122,axiom,
    ! [VarCurr] :
      ( v50053(VarCurr)
    <=> ( ( v46454(VarCurr,bitIndex2)
        <=> $false )
        & ( v46454(VarCurr,bitIndex1)
        <=> $true )
        & ( v46454(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_478,axiom,
    ! [VarCurr] :
      ( ~ v50049(VarCurr)
     => ( v49985(VarCurr,bitIndex31)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_644,axiom,
    ! [VarCurr] :
      ( v50049(VarCurr)
     => ( v49985(VarCurr,bitIndex31)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3121,axiom,
    ! [VarCurr] :
      ( v50049(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_477,axiom,
    ! [VarCurr] :
      ( ~ v50047(VarCurr)
     => ( v49985(VarCurr,bitIndex30)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_643,axiom,
    ! [VarCurr] :
      ( v50047(VarCurr)
     => ( v49985(VarCurr,bitIndex30)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3120,axiom,
    ! [VarCurr] :
      ( v50047(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_476,axiom,
    ! [VarCurr] :
      ( ~ v50045(VarCurr)
     => ( v49985(VarCurr,bitIndex29)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_642,axiom,
    ! [VarCurr] :
      ( v50045(VarCurr)
     => ( v49985(VarCurr,bitIndex29)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3119,axiom,
    ! [VarCurr] :
      ( v50045(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_475,axiom,
    ! [VarCurr] :
      ( ~ v50043(VarCurr)
     => ( v49985(VarCurr,bitIndex28)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_641,axiom,
    ! [VarCurr] :
      ( v50043(VarCurr)
     => ( v49985(VarCurr,bitIndex28)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3118,axiom,
    ! [VarCurr] :
      ( v50043(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_474,axiom,
    ! [VarCurr] :
      ( ~ v50041(VarCurr)
     => ( v49985(VarCurr,bitIndex27)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_640,axiom,
    ! [VarCurr] :
      ( v50041(VarCurr)
     => ( v49985(VarCurr,bitIndex27)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3117,axiom,
    ! [VarCurr] :
      ( v50041(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_473,axiom,
    ! [VarCurr] :
      ( ~ v50039(VarCurr)
     => ( v49985(VarCurr,bitIndex26)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_639,axiom,
    ! [VarCurr] :
      ( v50039(VarCurr)
     => ( v49985(VarCurr,bitIndex26)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3116,axiom,
    ! [VarCurr] :
      ( v50039(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_472,axiom,
    ! [VarCurr] :
      ( ~ v50037(VarCurr)
     => ( v49985(VarCurr,bitIndex25)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_638,axiom,
    ! [VarCurr] :
      ( v50037(VarCurr)
     => ( v49985(VarCurr,bitIndex25)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3115,axiom,
    ! [VarCurr] :
      ( v50037(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_471,axiom,
    ! [VarCurr] :
      ( ~ v50035(VarCurr)
     => ( v49985(VarCurr,bitIndex24)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_637,axiom,
    ! [VarCurr] :
      ( v50035(VarCurr)
     => ( v49985(VarCurr,bitIndex24)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3114,axiom,
    ! [VarCurr] :
      ( v50035(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_470,axiom,
    ! [VarCurr] :
      ( ~ v50033(VarCurr)
     => ( v49985(VarCurr,bitIndex23)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_636,axiom,
    ! [VarCurr] :
      ( v50033(VarCurr)
     => ( v49985(VarCurr,bitIndex23)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3113,axiom,
    ! [VarCurr] :
      ( v50033(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_469,axiom,
    ! [VarCurr] :
      ( ~ v50031(VarCurr)
     => ( v49985(VarCurr,bitIndex22)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_635,axiom,
    ! [VarCurr] :
      ( v50031(VarCurr)
     => ( v49985(VarCurr,bitIndex22)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3112,axiom,
    ! [VarCurr] :
      ( v50031(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_468,axiom,
    ! [VarCurr] :
      ( ~ v50029(VarCurr)
     => ( v49985(VarCurr,bitIndex21)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_634,axiom,
    ! [VarCurr] :
      ( v50029(VarCurr)
     => ( v49985(VarCurr,bitIndex21)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3111,axiom,
    ! [VarCurr] :
      ( v50029(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_467,axiom,
    ! [VarCurr] :
      ( ~ v50027(VarCurr)
     => ( v49985(VarCurr,bitIndex20)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_633,axiom,
    ! [VarCurr] :
      ( v50027(VarCurr)
     => ( v49985(VarCurr,bitIndex20)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3110,axiom,
    ! [VarCurr] :
      ( v50027(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_466,axiom,
    ! [VarCurr] :
      ( ~ v50025(VarCurr)
     => ( v49985(VarCurr,bitIndex19)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_632,axiom,
    ! [VarCurr] :
      ( v50025(VarCurr)
     => ( v49985(VarCurr,bitIndex19)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3109,axiom,
    ! [VarCurr] :
      ( v50025(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_465,axiom,
    ! [VarCurr] :
      ( ~ v50023(VarCurr)
     => ( v49985(VarCurr,bitIndex18)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_631,axiom,
    ! [VarCurr] :
      ( v50023(VarCurr)
     => ( v49985(VarCurr,bitIndex18)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3108,axiom,
    ! [VarCurr] :
      ( v50023(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_464,axiom,
    ! [VarCurr] :
      ( ~ v50021(VarCurr)
     => ( v49985(VarCurr,bitIndex17)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_630,axiom,
    ! [VarCurr] :
      ( v50021(VarCurr)
     => ( v49985(VarCurr,bitIndex17)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3107,axiom,
    ! [VarCurr] :
      ( v50021(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_463,axiom,
    ! [VarCurr] :
      ( ~ v50019(VarCurr)
     => ( v49985(VarCurr,bitIndex16)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_629,axiom,
    ! [VarCurr] :
      ( v50019(VarCurr)
     => ( v49985(VarCurr,bitIndex16)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3106,axiom,
    ! [VarCurr] :
      ( v50019(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $true )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_462,axiom,
    ! [VarCurr] :
      ( ~ v50017(VarCurr)
     => ( v49985(VarCurr,bitIndex15)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_628,axiom,
    ! [VarCurr] :
      ( v50017(VarCurr)
     => ( v49985(VarCurr,bitIndex15)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3105,axiom,
    ! [VarCurr] :
      ( v50017(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_461,axiom,
    ! [VarCurr] :
      ( ~ v50015(VarCurr)
     => ( v49985(VarCurr,bitIndex14)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_627,axiom,
    ! [VarCurr] :
      ( v50015(VarCurr)
     => ( v49985(VarCurr,bitIndex14)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3104,axiom,
    ! [VarCurr] :
      ( v50015(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_460,axiom,
    ! [VarCurr] :
      ( ~ v50013(VarCurr)
     => ( v49985(VarCurr,bitIndex13)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_626,axiom,
    ! [VarCurr] :
      ( v50013(VarCurr)
     => ( v49985(VarCurr,bitIndex13)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3103,axiom,
    ! [VarCurr] :
      ( v50013(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_459,axiom,
    ! [VarCurr] :
      ( ~ v50011(VarCurr)
     => ( v49985(VarCurr,bitIndex12)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_625,axiom,
    ! [VarCurr] :
      ( v50011(VarCurr)
     => ( v49985(VarCurr,bitIndex12)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3102,axiom,
    ! [VarCurr] :
      ( v50011(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_458,axiom,
    ! [VarCurr] :
      ( ~ v50009(VarCurr)
     => ( v49985(VarCurr,bitIndex11)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_624,axiom,
    ! [VarCurr] :
      ( v50009(VarCurr)
     => ( v49985(VarCurr,bitIndex11)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3101,axiom,
    ! [VarCurr] :
      ( v50009(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_457,axiom,
    ! [VarCurr] :
      ( ~ v50007(VarCurr)
     => ( v49985(VarCurr,bitIndex10)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_623,axiom,
    ! [VarCurr] :
      ( v50007(VarCurr)
     => ( v49985(VarCurr,bitIndex10)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3100,axiom,
    ! [VarCurr] :
      ( v50007(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_456,axiom,
    ! [VarCurr] :
      ( ~ v50005(VarCurr)
     => ( v49985(VarCurr,bitIndex9)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_622,axiom,
    ! [VarCurr] :
      ( v50005(VarCurr)
     => ( v49985(VarCurr,bitIndex9)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3099,axiom,
    ! [VarCurr] :
      ( v50005(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_455,axiom,
    ! [VarCurr] :
      ( ~ v50003(VarCurr)
     => ( v49985(VarCurr,bitIndex8)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_621,axiom,
    ! [VarCurr] :
      ( v50003(VarCurr)
     => ( v49985(VarCurr,bitIndex8)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3098,axiom,
    ! [VarCurr] :
      ( v50003(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $true )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_454,axiom,
    ! [VarCurr] :
      ( ~ v50001(VarCurr)
     => ( v49985(VarCurr,bitIndex7)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_620,axiom,
    ! [VarCurr] :
      ( v50001(VarCurr)
     => ( v49985(VarCurr,bitIndex7)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3097,axiom,
    ! [VarCurr] :
      ( v50001(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_453,axiom,
    ! [VarCurr] :
      ( ~ v49999(VarCurr)
     => ( v49985(VarCurr,bitIndex6)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_619,axiom,
    ! [VarCurr] :
      ( v49999(VarCurr)
     => ( v49985(VarCurr,bitIndex6)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3096,axiom,
    ! [VarCurr] :
      ( v49999(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_452,axiom,
    ! [VarCurr] :
      ( ~ v49997(VarCurr)
     => ( v49985(VarCurr,bitIndex5)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_618,axiom,
    ! [VarCurr] :
      ( v49997(VarCurr)
     => ( v49985(VarCurr,bitIndex5)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3095,axiom,
    ! [VarCurr] :
      ( v49997(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_451,axiom,
    ! [VarCurr] :
      ( ~ v49995(VarCurr)
     => ( v49985(VarCurr,bitIndex4)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_617,axiom,
    ! [VarCurr] :
      ( v49995(VarCurr)
     => ( v49985(VarCurr,bitIndex4)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3094,axiom,
    ! [VarCurr] :
      ( v49995(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $true )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_450,axiom,
    ! [VarCurr] :
      ( ~ v49993(VarCurr)
     => ( v49985(VarCurr,bitIndex3)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_616,axiom,
    ! [VarCurr] :
      ( v49993(VarCurr)
     => ( v49985(VarCurr,bitIndex3)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3093,axiom,
    ! [VarCurr] :
      ( v49993(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_449,axiom,
    ! [VarCurr] :
      ( ~ v49991(VarCurr)
     => ( v49985(VarCurr,bitIndex2)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_615,axiom,
    ! [VarCurr] :
      ( v49991(VarCurr)
     => ( v49985(VarCurr,bitIndex2)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3092,axiom,
    ! [VarCurr] :
      ( v49991(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $true )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_448,axiom,
    ! [VarCurr] :
      ( ~ v49989(VarCurr)
     => ( v49985(VarCurr,bitIndex1)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_614,axiom,
    ! [VarCurr] :
      ( v49989(VarCurr)
     => ( v49985(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3091,axiom,
    ! [VarCurr] :
      ( v49989(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1574,axiom,
    ! [VarCurr] :
      ( ~ v49987(VarCurr)
     => ( v49985(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1408,axiom,
    ! [VarCurr] :
      ( v49987(VarCurr)
     => ( v49985(VarCurr,bitIndex0)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3090,axiom,
    ! [VarCurr] :
      ( v49987(VarCurr)
    <=> ( ( v47943(VarCurr,bitIndex4)
        <=> $false )
        & ( v47943(VarCurr,bitIndex3)
        <=> $false )
        & ( v47943(VarCurr,bitIndex2)
        <=> $false )
        & ( v47943(VarCurr,bitIndex1)
        <=> $false )
        & ( v47943(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_18797,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v48167(VarCurr,B)
      <=> v48169(VarCurr,B) ) ) ).

fof(addAssignment_18796,axiom,
    ! [VarCurr,B] :
      ( range_31_1(B)
     => ( v48169(VarCurr,B)
      <=> v48171(VarCurr,B) ) ) ).

fof(addAssignment_18795,axiom,
    ! [VarCurr,B] :
      ( range_31_1(B)
     => ( v48171(VarCurr,B)
      <=> v48173(VarCurr,B) ) ) ).

fof(addAssignment_18794,axiom,
    ! [VarCurr,B] :
      ( range_31_1(B)
     => ( v48173(VarCurr,B)
      <=> v48175(VarCurr,B) ) ) ).

fof(addAssignment_18793,axiom,
    ! [VarCurr,B] :
      ( range_31_1(B)
     => ( v48175(VarCurr,B)
      <=> v49506(VarCurr,B) ) ) ).

fof(range_axiom_211,axiom,
    ! [B] :
      ( range_31_1(B)
    <=> ( $false
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B
        | bitIndex30 = B
        | bitIndex31 = B ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_447,axiom,
    ! [VarCurr] :
      ( ~ v49981(VarCurr)
     => ( v49524(VarCurr,bitIndex31)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_613,axiom,
    ! [VarCurr] :
      ( v49981(VarCurr)
     => ( v49524(VarCurr,bitIndex31)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3089,axiom,
    ! [VarCurr] :
      ( v49981(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $true )
        & ( v49526(VarCurr,bitIndex3)
        <=> $true )
        & ( v49526(VarCurr,bitIndex2)
        <=> $true )
        & ( v49526(VarCurr,bitIndex1)
        <=> $true )
        & ( v49526(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_446,axiom,
    ! [VarCurr] :
      ( ~ v49979(VarCurr)
     => ( v49524(VarCurr,bitIndex30)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_612,axiom,
    ! [VarCurr] :
      ( v49979(VarCurr)
     => ( v49524(VarCurr,bitIndex30)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3088,axiom,
    ! [VarCurr] :
      ( v49979(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $true )
        & ( v49526(VarCurr,bitIndex3)
        <=> $true )
        & ( v49526(VarCurr,bitIndex2)
        <=> $true )
        & ( v49526(VarCurr,bitIndex1)
        <=> $true )
        & ( v49526(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_445,axiom,
    ! [VarCurr] :
      ( ~ v49977(VarCurr)
     => ( v49524(VarCurr,bitIndex29)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_611,axiom,
    ! [VarCurr] :
      ( v49977(VarCurr)
     => ( v49524(VarCurr,bitIndex29)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3087,axiom,
    ! [VarCurr] :
      ( v49977(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $true )
        & ( v49526(VarCurr,bitIndex3)
        <=> $true )
        & ( v49526(VarCurr,bitIndex2)
        <=> $true )
        & ( v49526(VarCurr,bitIndex1)
        <=> $false )
        & ( v49526(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_444,axiom,
    ! [VarCurr] :
      ( ~ v49975(VarCurr)
     => ( v49524(VarCurr,bitIndex28)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_610,axiom,
    ! [VarCurr] :
      ( v49975(VarCurr)
     => ( v49524(VarCurr,bitIndex28)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3086,axiom,
    ! [VarCurr] :
      ( v49975(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $true )
        & ( v49526(VarCurr,bitIndex3)
        <=> $true )
        & ( v49526(VarCurr,bitIndex2)
        <=> $true )
        & ( v49526(VarCurr,bitIndex1)
        <=> $false )
        & ( v49526(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_443,axiom,
    ! [VarCurr] :
      ( ~ v49973(VarCurr)
     => ( v49524(VarCurr,bitIndex27)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_609,axiom,
    ! [VarCurr] :
      ( v49973(VarCurr)
     => ( v49524(VarCurr,bitIndex27)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3085,axiom,
    ! [VarCurr] :
      ( v49973(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $true )
        & ( v49526(VarCurr,bitIndex3)
        <=> $true )
        & ( v49526(VarCurr,bitIndex2)
        <=> $false )
        & ( v49526(VarCurr,bitIndex1)
        <=> $true )
        & ( v49526(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_442,axiom,
    ! [VarCurr] :
      ( ~ v49971(VarCurr)
     => ( v49524(VarCurr,bitIndex26)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_608,axiom,
    ! [VarCurr] :
      ( v49971(VarCurr)
     => ( v49524(VarCurr,bitIndex26)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3084,axiom,
    ! [VarCurr] :
      ( v49971(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $true )
        & ( v49526(VarCurr,bitIndex3)
        <=> $true )
        & ( v49526(VarCurr,bitIndex2)
        <=> $false )
        & ( v49526(VarCurr,bitIndex1)
        <=> $true )
        & ( v49526(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_441,axiom,
    ! [VarCurr] :
      ( ~ v49969(VarCurr)
     => ( v49524(VarCurr,bitIndex25)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_607,axiom,
    ! [VarCurr] :
      ( v49969(VarCurr)
     => ( v49524(VarCurr,bitIndex25)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3083,axiom,
    ! [VarCurr] :
      ( v49969(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $true )
        & ( v49526(VarCurr,bitIndex3)
        <=> $true )
        & ( v49526(VarCurr,bitIndex2)
        <=> $false )
        & ( v49526(VarCurr,bitIndex1)
        <=> $false )
        & ( v49526(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_440,axiom,
    ! [VarCurr] :
      ( ~ v49967(VarCurr)
     => ( v49524(VarCurr,bitIndex24)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_606,axiom,
    ! [VarCurr] :
      ( v49967(VarCurr)
     => ( v49524(VarCurr,bitIndex24)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3082,axiom,
    ! [VarCurr] :
      ( v49967(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $true )
        & ( v49526(VarCurr,bitIndex3)
        <=> $true )
        & ( v49526(VarCurr,bitIndex2)
        <=> $false )
        & ( v49526(VarCurr,bitIndex1)
        <=> $false )
        & ( v49526(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_439,axiom,
    ! [VarCurr] :
      ( ~ v49965(VarCurr)
     => ( v49524(VarCurr,bitIndex23)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_605,axiom,
    ! [VarCurr] :
      ( v49965(VarCurr)
     => ( v49524(VarCurr,bitIndex23)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3081,axiom,
    ! [VarCurr] :
      ( v49965(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $true )
        & ( v49526(VarCurr,bitIndex3)
        <=> $false )
        & ( v49526(VarCurr,bitIndex2)
        <=> $true )
        & ( v49526(VarCurr,bitIndex1)
        <=> $true )
        & ( v49526(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_438,axiom,
    ! [VarCurr] :
      ( ~ v49963(VarCurr)
     => ( v49524(VarCurr,bitIndex22)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_604,axiom,
    ! [VarCurr] :
      ( v49963(VarCurr)
     => ( v49524(VarCurr,bitIndex22)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3080,axiom,
    ! [VarCurr] :
      ( v49963(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $true )
        & ( v49526(VarCurr,bitIndex3)
        <=> $false )
        & ( v49526(VarCurr,bitIndex2)
        <=> $true )
        & ( v49526(VarCurr,bitIndex1)
        <=> $true )
        & ( v49526(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_437,axiom,
    ! [VarCurr] :
      ( ~ v49961(VarCurr)
     => ( v49524(VarCurr,bitIndex21)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_603,axiom,
    ! [VarCurr] :
      ( v49961(VarCurr)
     => ( v49524(VarCurr,bitIndex21)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3079,axiom,
    ! [VarCurr] :
      ( v49961(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $true )
        & ( v49526(VarCurr,bitIndex3)
        <=> $false )
        & ( v49526(VarCurr,bitIndex2)
        <=> $true )
        & ( v49526(VarCurr,bitIndex1)
        <=> $false )
        & ( v49526(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_436,axiom,
    ! [VarCurr] :
      ( ~ v49959(VarCurr)
     => ( v49524(VarCurr,bitIndex20)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_602,axiom,
    ! [VarCurr] :
      ( v49959(VarCurr)
     => ( v49524(VarCurr,bitIndex20)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3078,axiom,
    ! [VarCurr] :
      ( v49959(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $true )
        & ( v49526(VarCurr,bitIndex3)
        <=> $false )
        & ( v49526(VarCurr,bitIndex2)
        <=> $true )
        & ( v49526(VarCurr,bitIndex1)
        <=> $false )
        & ( v49526(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_435,axiom,
    ! [VarCurr] :
      ( ~ v49957(VarCurr)
     => ( v49524(VarCurr,bitIndex19)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_601,axiom,
    ! [VarCurr] :
      ( v49957(VarCurr)
     => ( v49524(VarCurr,bitIndex19)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3077,axiom,
    ! [VarCurr] :
      ( v49957(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $true )
        & ( v49526(VarCurr,bitIndex3)
        <=> $false )
        & ( v49526(VarCurr,bitIndex2)
        <=> $false )
        & ( v49526(VarCurr,bitIndex1)
        <=> $true )
        & ( v49526(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_434,axiom,
    ! [VarCurr] :
      ( ~ v49955(VarCurr)
     => ( v49524(VarCurr,bitIndex18)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_600,axiom,
    ! [VarCurr] :
      ( v49955(VarCurr)
     => ( v49524(VarCurr,bitIndex18)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3076,axiom,
    ! [VarCurr] :
      ( v49955(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $true )
        & ( v49526(VarCurr,bitIndex3)
        <=> $false )
        & ( v49526(VarCurr,bitIndex2)
        <=> $false )
        & ( v49526(VarCurr,bitIndex1)
        <=> $true )
        & ( v49526(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_433,axiom,
    ! [VarCurr] :
      ( ~ v49953(VarCurr)
     => ( v49524(VarCurr,bitIndex17)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_599,axiom,
    ! [VarCurr] :
      ( v49953(VarCurr)
     => ( v49524(VarCurr,bitIndex17)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3075,axiom,
    ! [VarCurr] :
      ( v49953(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $true )
        & ( v49526(VarCurr,bitIndex3)
        <=> $false )
        & ( v49526(VarCurr,bitIndex2)
        <=> $false )
        & ( v49526(VarCurr,bitIndex1)
        <=> $false )
        & ( v49526(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_432,axiom,
    ! [VarCurr] :
      ( ~ v49951(VarCurr)
     => ( v49524(VarCurr,bitIndex16)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_598,axiom,
    ! [VarCurr] :
      ( v49951(VarCurr)
     => ( v49524(VarCurr,bitIndex16)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3074,axiom,
    ! [VarCurr] :
      ( v49951(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $true )
        & ( v49526(VarCurr,bitIndex3)
        <=> $false )
        & ( v49526(VarCurr,bitIndex2)
        <=> $false )
        & ( v49526(VarCurr,bitIndex1)
        <=> $false )
        & ( v49526(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_431,axiom,
    ! [VarCurr] :
      ( ~ v49949(VarCurr)
     => ( v49524(VarCurr,bitIndex15)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_597,axiom,
    ! [VarCurr] :
      ( v49949(VarCurr)
     => ( v49524(VarCurr,bitIndex15)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3073,axiom,
    ! [VarCurr] :
      ( v49949(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $false )
        & ( v49526(VarCurr,bitIndex3)
        <=> $true )
        & ( v49526(VarCurr,bitIndex2)
        <=> $true )
        & ( v49526(VarCurr,bitIndex1)
        <=> $true )
        & ( v49526(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_430,axiom,
    ! [VarCurr] :
      ( ~ v49947(VarCurr)
     => ( v49524(VarCurr,bitIndex14)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_596,axiom,
    ! [VarCurr] :
      ( v49947(VarCurr)
     => ( v49524(VarCurr,bitIndex14)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3072,axiom,
    ! [VarCurr] :
      ( v49947(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $false )
        & ( v49526(VarCurr,bitIndex3)
        <=> $true )
        & ( v49526(VarCurr,bitIndex2)
        <=> $true )
        & ( v49526(VarCurr,bitIndex1)
        <=> $true )
        & ( v49526(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_429,axiom,
    ! [VarCurr] :
      ( ~ v49945(VarCurr)
     => ( v49524(VarCurr,bitIndex13)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_595,axiom,
    ! [VarCurr] :
      ( v49945(VarCurr)
     => ( v49524(VarCurr,bitIndex13)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3071,axiom,
    ! [VarCurr] :
      ( v49945(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $false )
        & ( v49526(VarCurr,bitIndex3)
        <=> $true )
        & ( v49526(VarCurr,bitIndex2)
        <=> $true )
        & ( v49526(VarCurr,bitIndex1)
        <=> $false )
        & ( v49526(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_428,axiom,
    ! [VarCurr] :
      ( ~ v49943(VarCurr)
     => ( v49524(VarCurr,bitIndex12)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_594,axiom,
    ! [VarCurr] :
      ( v49943(VarCurr)
     => ( v49524(VarCurr,bitIndex12)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3070,axiom,
    ! [VarCurr] :
      ( v49943(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $false )
        & ( v49526(VarCurr,bitIndex3)
        <=> $true )
        & ( v49526(VarCurr,bitIndex2)
        <=> $true )
        & ( v49526(VarCurr,bitIndex1)
        <=> $false )
        & ( v49526(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_427,axiom,
    ! [VarCurr] :
      ( ~ v49941(VarCurr)
     => ( v49524(VarCurr,bitIndex11)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_593,axiom,
    ! [VarCurr] :
      ( v49941(VarCurr)
     => ( v49524(VarCurr,bitIndex11)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3069,axiom,
    ! [VarCurr] :
      ( v49941(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $false )
        & ( v49526(VarCurr,bitIndex3)
        <=> $true )
        & ( v49526(VarCurr,bitIndex2)
        <=> $false )
        & ( v49526(VarCurr,bitIndex1)
        <=> $true )
        & ( v49526(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_426,axiom,
    ! [VarCurr] :
      ( ~ v49939(VarCurr)
     => ( v49524(VarCurr,bitIndex10)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_592,axiom,
    ! [VarCurr] :
      ( v49939(VarCurr)
     => ( v49524(VarCurr,bitIndex10)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3068,axiom,
    ! [VarCurr] :
      ( v49939(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $false )
        & ( v49526(VarCurr,bitIndex3)
        <=> $true )
        & ( v49526(VarCurr,bitIndex2)
        <=> $false )
        & ( v49526(VarCurr,bitIndex1)
        <=> $true )
        & ( v49526(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_425,axiom,
    ! [VarCurr] :
      ( ~ v49937(VarCurr)
     => ( v49524(VarCurr,bitIndex9)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_591,axiom,
    ! [VarCurr] :
      ( v49937(VarCurr)
     => ( v49524(VarCurr,bitIndex9)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3067,axiom,
    ! [VarCurr] :
      ( v49937(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $false )
        & ( v49526(VarCurr,bitIndex3)
        <=> $true )
        & ( v49526(VarCurr,bitIndex2)
        <=> $false )
        & ( v49526(VarCurr,bitIndex1)
        <=> $false )
        & ( v49526(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_424,axiom,
    ! [VarCurr] :
      ( ~ v49935(VarCurr)
     => ( v49524(VarCurr,bitIndex8)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_590,axiom,
    ! [VarCurr] :
      ( v49935(VarCurr)
     => ( v49524(VarCurr,bitIndex8)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3066,axiom,
    ! [VarCurr] :
      ( v49935(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $false )
        & ( v49526(VarCurr,bitIndex3)
        <=> $true )
        & ( v49526(VarCurr,bitIndex2)
        <=> $false )
        & ( v49526(VarCurr,bitIndex1)
        <=> $false )
        & ( v49526(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_423,axiom,
    ! [VarCurr] :
      ( ~ v49933(VarCurr)
     => ( v49524(VarCurr,bitIndex7)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_589,axiom,
    ! [VarCurr] :
      ( v49933(VarCurr)
     => ( v49524(VarCurr,bitIndex7)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3065,axiom,
    ! [VarCurr] :
      ( v49933(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $false )
        & ( v49526(VarCurr,bitIndex3)
        <=> $false )
        & ( v49526(VarCurr,bitIndex2)
        <=> $true )
        & ( v49526(VarCurr,bitIndex1)
        <=> $true )
        & ( v49526(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_422,axiom,
    ! [VarCurr] :
      ( ~ v49931(VarCurr)
     => ( v49524(VarCurr,bitIndex6)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_588,axiom,
    ! [VarCurr] :
      ( v49931(VarCurr)
     => ( v49524(VarCurr,bitIndex6)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3064,axiom,
    ! [VarCurr] :
      ( v49931(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $false )
        & ( v49526(VarCurr,bitIndex3)
        <=> $false )
        & ( v49526(VarCurr,bitIndex2)
        <=> $true )
        & ( v49526(VarCurr,bitIndex1)
        <=> $true )
        & ( v49526(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_421,axiom,
    ! [VarCurr] :
      ( ~ v49929(VarCurr)
     => ( v49524(VarCurr,bitIndex5)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_587,axiom,
    ! [VarCurr] :
      ( v49929(VarCurr)
     => ( v49524(VarCurr,bitIndex5)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3063,axiom,
    ! [VarCurr] :
      ( v49929(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $false )
        & ( v49526(VarCurr,bitIndex3)
        <=> $false )
        & ( v49526(VarCurr,bitIndex2)
        <=> $true )
        & ( v49526(VarCurr,bitIndex1)
        <=> $false )
        & ( v49526(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_420,axiom,
    ! [VarCurr] :
      ( ~ v49927(VarCurr)
     => ( v49524(VarCurr,bitIndex4)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_586,axiom,
    ! [VarCurr] :
      ( v49927(VarCurr)
     => ( v49524(VarCurr,bitIndex4)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3062,axiom,
    ! [VarCurr] :
      ( v49927(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $false )
        & ( v49526(VarCurr,bitIndex3)
        <=> $false )
        & ( v49526(VarCurr,bitIndex2)
        <=> $true )
        & ( v49526(VarCurr,bitIndex1)
        <=> $false )
        & ( v49526(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_419,axiom,
    ! [VarCurr] :
      ( ~ v49925(VarCurr)
     => ( v49524(VarCurr,bitIndex3)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_585,axiom,
    ! [VarCurr] :
      ( v49925(VarCurr)
     => ( v49524(VarCurr,bitIndex3)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3061,axiom,
    ! [VarCurr] :
      ( v49925(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $false )
        & ( v49526(VarCurr,bitIndex3)
        <=> $false )
        & ( v49526(VarCurr,bitIndex2)
        <=> $false )
        & ( v49526(VarCurr,bitIndex1)
        <=> $true )
        & ( v49526(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_418,axiom,
    ! [VarCurr] :
      ( ~ v49923(VarCurr)
     => ( v49524(VarCurr,bitIndex2)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_584,axiom,
    ! [VarCurr] :
      ( v49923(VarCurr)
     => ( v49524(VarCurr,bitIndex2)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3060,axiom,
    ! [VarCurr] :
      ( v49923(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $false )
        & ( v49526(VarCurr,bitIndex3)
        <=> $false )
        & ( v49526(VarCurr,bitIndex2)
        <=> $false )
        & ( v49526(VarCurr,bitIndex1)
        <=> $true )
        & ( v49526(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_417,axiom,
    ! [VarCurr] :
      ( ~ v49921(VarCurr)
     => ( v49524(VarCurr,bitIndex1)
      <=> $true ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_583,axiom,
    ! [VarCurr] :
      ( v49921(VarCurr)
     => ( v49524(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3059,axiom,
    ! [VarCurr] :
      ( v49921(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $false )
        & ( v49526(VarCurr,bitIndex3)
        <=> $false )
        & ( v49526(VarCurr,bitIndex2)
        <=> $false )
        & ( v49526(VarCurr,bitIndex1)
        <=> $false )
        & ( v49526(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1573,axiom,
    ! [VarCurr] :
      ( ~ v49919(VarCurr)
     => ( v49524(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1407,axiom,
    ! [VarCurr] :
      ( v49919(VarCurr)
     => ( v49524(VarCurr,bitIndex0)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_3058,axiom,
    ! [VarCurr] :
      ( v49919(VarCurr)
    <=> ( ( v49526(VarCurr,bitIndex4)
        <=> $false )
        & ( v49526(VarCurr,bitIndex3)
        <=> $false )
        & ( v49526(VarCurr,bitIndex2)
        <=> $false )
        & ( v49526(VarCurr,bitIndex1)
        <=> $false )
        & ( v49526(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_18792,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v49526(VarCurr,B)
      <=> v49528(VarCurr,B) ) ) ).

fof(addAssignment_18791,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v49528(VarCurr,B)
      <=> v49530(VarCurr,B) ) ) ).

fof(addAssignment_18790,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v49530(VarCurr,B)
      <=> v49532(VarCurr,B) ) ) ).

fof(addAssignment_18789,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v49532(VarCurr,B)
      <=> v49534(VarCurr,B) ) ) ).

fof(addAssignment_18788,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v49534(VarCurr,B)
      <=> v49917(VarCurr,B) ) ) ).

fof(memoryReadIntoBuffer_21,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b0000_address_term = A
             => ( range_53_0(B)
               => ( v49761(VarNext,B)
                <=> v49536_array(VarNext,A,B) ) ) ) ) ) ).

fof(memoryReadIntoBuffer_20,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [A] :
          ( address(A)
         => ! [B] :
              ( b0001_address_term = A
             => ( range_53_0(B)
               => ( v49770(VarNext,B)
                <=> v49536_array(VarNext,A,B) ) ) ) ) ) ).